
/*******************************************************************************
 *                                                                             *
 *                  Copyright (C) 2011 Altera Corporation                      *
 *                                                                             *
 * ALTERA, ARRIA, CYCLONE, HARDCOPY, MAX, MEGACORE, NIOS, QUARTUS & STRATIX    *
 * are Reg. U.S. Pat. & Tm. Off. and Altera marks in and outside the U.S.      *
 *                                                                             *
 * All information provided herein is provided on an "as is" basis,            *
 * without warranty of any kind.                                               *
 *                                                                             *
 * Module Name: avalon_state_machine_master                                                       *
 * File Name:   avalon_state_machine_master.v                                                     *
 *                                                                             *
 * Module Function: This file contains an Avalon state machine master which    *
 *                  will create Avalon-MM bus transactions.                    *
 *                                                                             *
 * REVISION HISTORY:                                                           *
 *  Revision 1.0    02/28/2011 - Initial Revision                              *
 *  Revision 2.0    04/18/2011 - Added header                                  *
 ******************************************************************************/

module avalon_state_machine_master (
	input 				rst, clk,
	input 				am_waitreq,
	input [31:0] 		am_data_in,
	output reg [31:0] 	am_addr,
	output reg [31:0]	am_data_out,
	output reg			am_rd, am_wr
);

	reg [31:0]			data_reg;
	reg					data_reg_ena;
	
	reg [82:0]	current_state, next_state;

	localparam		st_0  = 0,  st_1  = 1,  st_2  = 2,  st_3  = 3,  st_4  = 4,  st_5  = 5,  st_6  = 6,  st_7  = 7,  st_8  = 8,  st_9  = 9,  st_10  = 10,  st_11  = 11,  st_12  = 12,  st_13  = 13,  st_14  = 14,  st_15  = 15,  st_16  = 16,  st_17  = 17,  st_18  = 18,  st_19  = 19,  st_20  = 20,  st_21  = 21,  st_22  = 22,  st_23  = 23,  st_24  = 24,  st_25  = 25,  st_26  = 26,  st_27  = 27,  st_28  = 28,  st_29  = 29,  st_30  = 30,  st_31  = 31,  st_32  = 32,  st_33  = 33,  st_34  = 34,  st_35  = 35,  st_36  = 36,  st_37  = 37,  st_38  = 38,  st_39  = 39,  st_40  = 40,  st_41  = 41,  st_42  = 42,  st_43  = 43,  st_44  = 44,  st_45  = 45,  st_46  = 46,  st_47  = 47,  st_48  = 48,  st_49  = 49,  st_50  = 50,  st_51  = 51,  st_52  = 52,  st_53  = 53,  st_54  = 54,  st_55  = 55,  st_56  = 56,  st_57  = 57,  st_58  = 58,  st_59  = 59,  st_60  = 60,  st_61  = 61,  st_62  = 62,  st_63  = 63,  st_64  = 64,  st_65  = 65,  st_66  = 66,  st_67  = 67,  st_68  = 68,  st_69  = 69,  st_70  = 70,  st_71  = 71,  st_72  = 72,  st_73  = 73,  st_74  = 74,  st_75  = 75,  st_76  = 76,  st_77  = 77,  st_78  = 78,  st_79  = 79,  st_80  = 80,  st_81  = 81,  st_82  = 82;

	// Data register
	always @ (posedge clk, posedge rst)
	begin:  data_reg_proc
		if (rst)
			data_reg <= 32'h0;
		else begin
			if (data_reg_ena)
				data_reg <= am_data_in;
		end
	end // data_reg_proc	

	// State register transitions
	always @ (posedge clk, posedge rst)
	begin:  state_reg_proc
		if (rst)
			current_state <= st_0;
		else
			current_state <= next_state;
	end // state_reg_proc
	
	// Next state logic
	always @ *
	begin:  next_state_proc
		am_addr <= 32'h0;
		am_wr <= 1'b0;
		am_rd <= 1'b0;
		am_data_out <= 32'h0;
		data_reg_ena <= 1'b0;
		
		case (current_state)

 			st_0 :	// idle
 					next_state <= st_1;
 
 			st_1 :	// idle
 					next_state <= st_2;
 
 			st_2 :	// write 1030, 00
 					begin
 						am_addr <= 32'h1030;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h00;
 						if (am_waitreq)
 							next_state <= st_2;
 						else
 							next_state <= st_3;
 					end
 
 			st_3 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_3;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_4;
 						end
 					end
 
 			st_4 :	// testbit 0, 0
 					begin
 						if (data_reg[0] == 1'b0)
 							next_state <= st_5;
 						else
 							next_state <= st_3;
 					end
 
 			st_5 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_5;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_6;
 						end
 					end
 
 			st_6 :	// testbit 0, 1
 					begin
 						if (data_reg[0] == 1'b1)
 							next_state <= st_7;
 						else
 							next_state <= st_5;
 					end
 
 			st_7 :	// write 1078, 284
 					begin
 						am_addr <= 32'h1078;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h284;
 						if (am_waitreq)
 							next_state <= st_7;
 						else
 							next_state <= st_8;
 					end
 
 			st_8 :	// read 1078
 					begin
 						am_addr <= 32'h1078;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_8;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_9;
 						end
 					end
 
 			st_9 :	// write 106C, 40
 					begin
 						am_addr <= 32'h106C;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h40;
 						if (am_waitreq)
 							next_state <= st_9;
 						else
 							next_state <= st_10;
 					end
 
 			st_10 :	// read 106C
 					begin
 						am_addr <= 32'h106C;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_10;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_11;
 						end
 					end
 
 			st_11 :	// write 1064, 0000
 					begin
 						am_addr <= 32'h1064;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h0000;
 						if (am_waitreq)
 							next_state <= st_11;
 						else
 							next_state <= st_12;
 					end
 
 			st_12 :	// read 1064
 					begin
 						am_addr <= 32'h1064;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_12;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_13;
 						end
 					end
 
 			st_13 :	// write 1068, 1010
 					begin
 						am_addr <= 32'h1068;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h1010;
 						if (am_waitreq)
 							next_state <= st_13;
 						else
 							next_state <= st_14;
 					end
 
 			st_14 :	// read 1068
 					begin
 						am_addr <= 32'h1068;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_14;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_15;
 						end
 					end
 
 			st_15 :	// write 2898, 184
 					begin
 						am_addr <= 32'h2898;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h184;
 						if (am_waitreq)
 							next_state <= st_15;
 						else
 							next_state <= st_16;
 					end
 
 			st_16 :	// read 2898
 					begin
 						am_addr <= 32'h2898;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_16;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_17;
 						end
 					end
 
 			st_17 :	// write 288C, 40
 					begin
 						am_addr <= 32'h288C;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h40;
 						if (am_waitreq)
 							next_state <= st_17;
 						else
 							next_state <= st_18;
 					end
 
 			st_18 :	// read 288C
 					begin
 						am_addr <= 32'h288C;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_18;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_19;
 						end
 					end
 
 			st_19 :	// write 2884, 2840
 					begin
 						am_addr <= 32'h2884;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h2840;
 						if (am_waitreq)
 							next_state <= st_19;
 						else
 							next_state <= st_20;
 					end
 
 			st_20 :	// read 2884
 					begin
 						am_addr <= 32'h2884;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_20;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_21;
 						end
 					end
 
 			st_21 :	// write 2888, 3800
 					begin
 						am_addr <= 32'h2888;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h3800;
 						if (am_waitreq)
 							next_state <= st_21;
 						else
 							next_state <= st_22;
 					end
 
 			st_22 :	// read 2888
 					begin
 						am_addr <= 32'h2888;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_22;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_23;
 						end
 					end
 
 			st_23 :	// write 1078, 28C
 					begin
 						am_addr <= 32'h1078;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h28C;
 						if (am_waitreq)
 							next_state <= st_23;
 						else
 							next_state <= st_24;
 					end
 
 			st_24 :	// write 2898, 18C
 					begin
 						am_addr <= 32'h2898;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h18C;
 						if (am_waitreq)
 							next_state <= st_24;
 						else
 							next_state <= st_25;
 					end
 
 			st_25 :	// read 2880
 					begin
 						am_addr <= 32'h2880;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_25;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_26;
 						end
 					end
 
 			st_26 :	// testbit 4, 1
 					begin
 						if (data_reg[4] == 1'b1)
 							next_state <= st_27;
 						else
 							next_state <= st_25;
 					end
 
 			st_27 :	// write 1030, FF
 					begin
 						am_addr <= 32'h1030;
 						am_wr <= 1'b1;
 						am_data_out <= 32'hFF;
 						if (am_waitreq)
 							next_state <= st_27;
 						else
 							next_state <= st_28;
 					end
 
 			st_28 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_28;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_29;
 						end
 					end
 
 			st_29 :	// testbit 3, 0
 					begin
 						if (data_reg[3] == 1'b0)
 							next_state <= st_30;
 						else
 							next_state <= st_28;
 					end
 
 			st_30 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_30;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_31;
 						end
 					end
 
 			st_31 :	// testbit 3, 1
 					begin
 						if (data_reg[3] == 1'b1)
 							next_state <= st_32;
 						else
 							next_state <= st_30;
 					end
 
 			st_32 :	// idle
 					next_state <= st_33;
 
 			st_33 :	// write 2000, 0000358E
 					begin
 						am_addr <= 32'h2000;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h0000358E;
 						if (am_waitreq)
 							next_state <= st_33;
 						else
 							next_state <= st_34;
 					end
 
 			st_34 :	// read 2000
 					begin
 						am_addr <= 32'h2000;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_34;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_35;
 						end
 					end
 
 			st_35 :	// write 2004, FFFFF454
 					begin
 						am_addr <= 32'h2004;
 						am_wr <= 1'b1;
 						am_data_out <= 32'hFFFFF454;
 						if (am_waitreq)
 							next_state <= st_35;
 						else
 							next_state <= st_36;
 					end
 
 			st_36 :	// read 2004
 					begin
 						am_addr <= 32'h2004;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_36;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_37;
 						end
 					end
 
 			st_37 :	// write 2008, 0000001D
 					begin
 						am_addr <= 32'h2008;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h0000001D;
 						if (am_waitreq)
 							next_state <= st_37;
 						else
 							next_state <= st_38;
 					end
 
 			st_38 :	// read 2008
 					begin
 						am_addr <= 32'h2008;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_38;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_39;
 						end
 					end
 
 			st_39 :	// write 200C, FFFFEBB0
 					begin
 						am_addr <= 32'h200C;
 						am_wr <= 1'b1;
 						am_data_out <= 32'hFFFFEBB0;
 						if (am_waitreq)
 							next_state <= st_39;
 						else
 							next_state <= st_40;
 					end
 
 			st_40 :	// read 200C
 					begin
 						am_addr <= 32'h200C;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_40;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_41;
 						end
 					end
 
 			st_41 :	// write 2010, 0000204E
 					begin
 						am_addr <= 32'h2010;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h0000204E;
 						if (am_waitreq)
 							next_state <= st_41;
 						else
 							next_state <= st_42;
 					end
 
 			st_42 :	// read 2010
 					begin
 						am_addr <= 32'h2010;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_42;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_43;
 						end
 					end
 
 			st_43 :	// write 2014, FFFFFFAB
 					begin
 						am_addr <= 32'h2014;
 						am_wr <= 1'b1;
 						am_data_out <= 32'hFFFFFFAB;
 						if (am_waitreq)
 							next_state <= st_43;
 						else
 							next_state <= st_44;
 					end
 
 			st_44 :	// read 2014
 					begin
 						am_addr <= 32'h2014;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_44;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_45;
 						end
 					end
 
 			st_45 :	// write 2018, FFFFF567
 					begin
 						am_addr <= 32'h2018;
 						am_wr <= 1'b1;
 						am_data_out <= 32'hFFFFF567;
 						if (am_waitreq)
 							next_state <= st_45;
 						else
 							next_state <= st_46;
 					end
 
 			st_46 :	// read 2018
 					begin
 						am_addr <= 32'h2018;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_46;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_47;
 						end
 					end
 
 			st_47 :	// write 201C, 00000202
 					begin
 						am_addr <= 32'h201C;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h00000202;
 						if (am_waitreq)
 							next_state <= st_47;
 						else
 							next_state <= st_48;
 					end
 
 			st_48 :	// read 201C
 					begin
 						am_addr <= 32'h201C;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_48;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_49;
 						end
 					end
 
 			st_49 :	// write 2020, 000016DC
 					begin
 						am_addr <= 32'h2020;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h000016DC;
 						if (am_waitreq)
 							next_state <= st_49;
 						else
 							next_state <= st_50;
 					end
 
 			st_50 :	// read 2020
 					begin
 						am_addr <= 32'h2020;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_50;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_51;
 						end
 					end
 
 			st_51 :	// idle
 					next_state <= st_52;
 
 			st_52 :	// write 1030, 00
 					begin
 						am_addr <= 32'h1030;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h00;
 						if (am_waitreq)
 							next_state <= st_52;
 						else
 							next_state <= st_53;
 					end
 
 			st_53 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_53;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_54;
 						end
 					end
 
 			st_54 :	// testbit 0, 0
 					begin
 						if (data_reg[0] == 1'b0)
 							next_state <= st_55;
 						else
 							next_state <= st_53;
 					end
 
 			st_55 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_55;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_56;
 						end
 					end
 
 			st_56 :	// testbit 0, 1
 					begin
 						if (data_reg[0] == 1'b1)
 							next_state <= st_57;
 						else
 							next_state <= st_55;
 					end
 
 			st_57 :	// write 1078, 284
 					begin
 						am_addr <= 32'h1078;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h284;
 						if (am_waitreq)
 							next_state <= st_57;
 						else
 							next_state <= st_58;
 					end
 
 			st_58 :	// read 1078
 					begin
 						am_addr <= 32'h1078;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_58;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_59;
 						end
 					end
 
 			st_59 :	// write 106C, 40
 					begin
 						am_addr <= 32'h106C;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h40;
 						if (am_waitreq)
 							next_state <= st_59;
 						else
 							next_state <= st_60;
 					end
 
 			st_60 :	// read 106C
 					begin
 						am_addr <= 32'h106C;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_60;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_61;
 						end
 					end
 
 			st_61 :	// write 1064, 0000
 					begin
 						am_addr <= 32'h1064;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h0000;
 						if (am_waitreq)
 							next_state <= st_61;
 						else
 							next_state <= st_62;
 					end
 
 			st_62 :	// read 1064
 					begin
 						am_addr <= 32'h1064;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_62;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_63;
 						end
 					end
 
 			st_63 :	// write 1068, 1010
 					begin
 						am_addr <= 32'h1068;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h1010;
 						if (am_waitreq)
 							next_state <= st_63;
 						else
 							next_state <= st_64;
 					end
 
 			st_64 :	// read 1068
 					begin
 						am_addr <= 32'h1068;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_64;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_65;
 						end
 					end
 
 			st_65 :	// write 2898, 184
 					begin
 						am_addr <= 32'h2898;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h184;
 						if (am_waitreq)
 							next_state <= st_65;
 						else
 							next_state <= st_66;
 					end
 
 			st_66 :	// read 2898
 					begin
 						am_addr <= 32'h2898;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_66;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_67;
 						end
 					end
 
 			st_67 :	// write 288C, 40
 					begin
 						am_addr <= 32'h288C;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h40;
 						if (am_waitreq)
 							next_state <= st_67;
 						else
 							next_state <= st_68;
 					end
 
 			st_68 :	// read 288C
 					begin
 						am_addr <= 32'h288C;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_68;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_69;
 						end
 					end
 
 			st_69 :	// write 2884, 2840
 					begin
 						am_addr <= 32'h2884;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h2840;
 						if (am_waitreq)
 							next_state <= st_69;
 						else
 							next_state <= st_70;
 					end
 
 			st_70 :	// read 2884
 					begin
 						am_addr <= 32'h2884;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_70;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_71;
 						end
 					end
 
 			st_71 :	// write 2888, 3840
 					begin
 						am_addr <= 32'h2888;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h3840;
 						if (am_waitreq)
 							next_state <= st_71;
 						else
 							next_state <= st_72;
 					end
 
 			st_72 :	// read 2888
 					begin
 						am_addr <= 32'h2888;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_72;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_73;
 						end
 					end
 
 			st_73 :	// write 1078, 28C
 					begin
 						am_addr <= 32'h1078;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h28C;
 						if (am_waitreq)
 							next_state <= st_73;
 						else
 							next_state <= st_74;
 					end
 
 			st_74 :	// write 2898, 18C
 					begin
 						am_addr <= 32'h2898;
 						am_wr <= 1'b1;
 						am_data_out <= 32'h18C;
 						if (am_waitreq)
 							next_state <= st_74;
 						else
 							next_state <= st_75;
 					end
 
 			st_75 :	// read 2880
 					begin
 						am_addr <= 32'h2880;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_75;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_76;
 						end
 					end
 
 			st_76 :	// testbit 4, 1
 					begin
 						if (data_reg[4] == 1'b1)
 							next_state <= st_77;
 						else
 							next_state <= st_75;
 					end
 
 			st_77 :	// write 1030, FF
 					begin
 						am_addr <= 32'h1030;
 						am_wr <= 1'b1;
 						am_data_out <= 32'hFF;
 						if (am_waitreq)
 							next_state <= st_77;
 						else
 							next_state <= st_78;
 					end
 
 			st_78 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_78;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_79;
 						end
 					end
 
 			st_79 :	// testbit 3, 0
 					begin
 						if (data_reg[3] == 1'b0)
 							next_state <= st_80;
 						else
 							next_state <= st_78;
 					end
 
 			st_80 :	// read 1040
 					begin
 						am_addr <= 32'h1040;
 						am_rd <= 1'b1;
 						if (am_waitreq)
 							next_state <= st_80;
 						else begin
 							data_reg_ena <= 1'b1;
 							next_state <= st_81;
 						end
 					end
 
 			st_81 :	// testbit 3, 1
 					begin
 						if (data_reg[3] == 1'b1)
 							next_state <= st_82;
 						else
 							next_state <= st_80;
 					end
 
 			st_82 :	// loop 0
 					next_state <= st_0;
			
						
			default :
						next_state <= st_0;

		endcase	

	end
						
endmodule
