// system_CH0_TRANSFORM.v

// Generated using ACDS version 16.1 196

`timescale 1 ps / 1 ps
module system_CH0_TRANSFORM (
		input  wire        csi_clk,          //  clock.clk
		input  wire        rsi_reset_n,      //  reset.reset_n
		output wire        asi_rgbin_ready,  //  rgbin.ready
		input  wire        asi_rgbin_valid,  //       .valid
		input  wire [23:0] asi_rgbin_data,   //       .data
		input  wire        avs_s0_write,     //     s0.write
		input  wire        avs_s0_read,      //       .read
		input  wire [3:0]  avs_s0_address,   //       .address
		input  wire [31:0] avs_s0_writedata, //       .writedata
		output wire [31:0] avs_s0_readdata,  //       .readdata
		input  wire        aso_xyzout_ready, // xyzout.ready
		output wire        aso_xyzout_valid, //       .valid
		output wire [31:0] aso_xyzout_data   //       .data
	);

	video_transform #(
		.shift_val      (15),
		.chk_fifo_full  (2'b00),
		.write_to_fifo  (2'b01),
		.chk_fifo_empty (2'b00),
		.read_from_fifo (2'b01)
	) ch0_transform (
		.csi_clk          (csi_clk),          //  clock.clk
		.rsi_reset_n      (rsi_reset_n),      //  reset.reset_n
		.avs_s0_write     (avs_s0_write),     //     s0.write
		.avs_s0_read      (avs_s0_read),      //       .read
		.avs_s0_address   (avs_s0_address),   //       .address
		.avs_s0_writedata (avs_s0_writedata), //       .writedata
		.avs_s0_readdata  (avs_s0_readdata),  //       .readdata
		.asi_rgbin_ready  (asi_rgbin_ready),  //  rgbin.ready
		.asi_rgbin_valid  (asi_rgbin_valid),  //       .valid
		.asi_rgbin_data   (asi_rgbin_data),   //       .data
		.aso_xyzout_ready (aso_xyzout_ready), // xyzout.ready
		.aso_xyzout_valid (aso_xyzout_valid), //       .valid
		.aso_xyzout_data  (aso_xyzout_data)   //       .data
	);

endmodule
