/*******************************************************************************
 *                                                                             *
 *                  Copyright (C) 2011 Altera Corporation                      *
 *                                                                             *
 * ALTERA, ARRIA, CYCLONE, HARDCOPY, MAX, MEGACORE, NIOS, QUARTUS & STRATIX    *
 * are Reg. U.S. Pat. & Tm. Off. and Altera marks in and outside the U.S.      *
 *                                                                             *
 * All information provided herein is provided on an "as is" basis,            *
 * without warranty of any kind.                                               *
 *                                                                             *
 * Module Name: byte_extract           File Name: byte_extract.v       	       *
 *                                                                             *
 * Module Function: This file contains the FIFO file used in the Nios Lab.     *
 *                                                                             *
 * REVISION HISTORY:                                                           *
 *  Revision 1.0    02/08/2011 - Initial Revision                              *
 ******************************************************************************/

 
// synopsys translate_off
`timescale 1 ps / 1 ps
// synopsys translate_on


module byte_extract(

	asi_rgbin_ready,
	asi_rgbin_valid, 
	asi_rgbin_data,

	aso_xyzout_ready,
	aso_xyzout_valid, 
	aso_xyzout_data,
	aso_xyzout_channel,
	
	csi_clk
	
)
;


   // STREAMING SINK INTERFACE (rgbin)
   // Receives data from streaming port of RGB_fifo
	output 	     	asi_rgbin_ready;
	input 	     	asi_rgbin_valid; 
	input [31:0]  	asi_rgbin_data;

   // STREAMING SOURCE INTERFACE (RGBOUT)
   // Sends data to "channel_selector" demux
	input 	     	aso_xyzout_ready;
	output 	     	aso_xyzout_valid; 
	output [23:0]  aso_xyzout_data;
	output [1:0]	aso_xyzout_channel;
	
   // GLOBAL SIGNALS
	input 			csi_clk;

	
	
	// CONTROL SIGNAL PASS-THROUGH:
	assign asi_rgbin_ready 	= aso_xyzout_ready;
	assign aso_xyzout_valid = asi_rgbin_valid;	

	
	// PERFORM BYTE EXTRACTION: (remember data gets byte-swapped through the FIFO
	// so the channel data is on the opposite side of where you would expect it to be)
	assign aso_xyzout_channel 	= asi_rgbin_data[1:0];  // channel
	assign aso_xyzout_data 		= asi_rgbin_data[31:8]; //  B G R

	
endmodule

