

module cs_regs (
  input  wire           host_clk,
  input  wire           hw_reset_n,
  input  wire   [15:0]  writeDataBus,  
    
  input  wire   [10:0]  addrBus, 
  input  wire           read_en,
  input  wire           write_en, 
  
  input  wire   [15:0]   status1,
  input  wire   [15:0]   status2,
 
  output reg   [15:0]  readDataBus,
  
  output reg    [15:0]  gpo_cr1,
  output reg    [15:0]  gpo_cr2  
  );
    
    
/*********** WRITES *****************************/    
   
   always @(posedge host_clk )
     begin
        if (!hw_reset_n)
          begin             
             gpo_cr1            <= 0;
             gpo_cr2            <= 0;             
          end  
        else
          begin                                     
            if (write_en)
              begin
                 case (addrBus)
                   11'h08: gpo_cr1                   <= writeDataBus[15:0]; 
                   11'hF8: gpo_cr2                   <= writeDataBus[15:0];
                 endcase
              end // end if 
            end   //end else    
     end //end always       
          
/*************  READ **************************************/    
          
          
   always @(posedge host_clk )
     begin
        if (!hw_reset_n)
          readDataBus <= 16'b0;
        else
          begin              
            if (read_en)
              begin
                 case (addrBus)                                      
                   11'h08: readDataBus   <= gpo_cr1[15:0];                   
                   11'h24: readDataBus   <= status1;
                   11'hCC: readDataBus   <= status2;                  
                   11'hF8: readDataBus   <= gpo_cr2[15:0];                   
                   default: readDataBus <= 16'b0;
                 endcase
              end
            else
              readDataBus <= 16'b0;
               
          end // end else
     end  // end always


//*************************************************************************
               

endmodule