#--------------------------------------------------------------#
#
# Set Board pinout
#
load_package report
load_package flow
# Input project name
puts "Info: *******************************************************************"
puts "   Info: Running qii_seed_sweep.tcl "

set project_name  [lindex $quartus(args) 0]
if { [ string eq "" $project_name] } {
   puts "Error: *******************************************************"
   puts "        Invalid first argument                                "
   puts "                                                              "
   puts "  quartus_sh -t qii_seed_sweep.tcl <project>  <revision>      "
   puts "                                                              "
   puts "     <project>      : Quartus II project name  - required     "
   puts "     <revision>     : Quartus II revision name - optional     "
   puts "Error: *******************************************************"
   puts $fileId "   Error: Invalid argument                            "
   close $fileId
   return 1
}
puts "Info: *******************************************************************"
puts "   Info: Quartus project                 : $project_name"


#--------------------------------------------------------------#
#
# Open Quartus II project
#
if { [ project_exists $project_name ]  } {
   project_open $project_name -force
} else {
   puts "Error: *******************************************************************"
   puts "   Error:  Unable to open Quartus II project $project_name"
   puts $fileId "   Error:  Unable to open Quartus II project $project_name"
   close $fileId
   return 1
}

#--------------------------------------------------------------#
#
# Quartus II compilation seed sweeping
#
set_global_assignment -name FAMILY "Cyclone V"
#set_global_assignment -name DEVICE 5CGXFC7D6F31C6


#PCIE_REFCLK
set_location_assignment PIN_W7 -to "refclk_clk(n)"
set_location_assignment PIN_W8 -to refclk_clk
#set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to refclk_clk
#set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to refclk_clk
set_instance_assignment -name IO_STANDARD "HCSL" -to refclk_clk
set_instance_assignment -name XCVR_REFCLK_PIN_TERMINATION DC_COUPLING_EXTERNAL_RESISTOR -to refclk_clk

#CLK_125
#This is for Rev B Board only. For Rev A board please use PIN_AB14
set_location_assignment PIN_Y15 -to reconfig_xcvr_clk
set_instance_assignment -name IO_STANDARD LVDS -to reconfig_xcvr_clk

#PCIE_PERSTn
set_location_assignment PIN_W24 -to perstn
set_instance_assignment -name IO_STANDARD "2.5 V" -to perstn

#USER1_PB_BUF0
set_location_assignment PIN_AF29 -to local_rstn
set_instance_assignment -name IO_STANDARD "2.5 V" -to local_rstn

#USER1_PB_BUF1
set_location_assignment PIN_AF30 -to req_compliance_pb
set_instance_assignment -name IO_STANDARD "2.5 V" -to req_compliance_pb

#USER_DIPSW_BUF1
set_location_assignment PIN_AH29 -to set_compliance_mode
set_instance_assignment -name IO_STANDARD "2.5 V" -to set_compliance_mode

set_location_assignment PIN_AG1 -to "hip_serial_rx_in0(n)"
set_location_assignment PIN_AG2 -to hip_serial_rx_in0
set_location_assignment PIN_AE1 -to "hip_serial_rx_in1(n)"
set_location_assignment PIN_AE2 -to hip_serial_rx_in1
set_location_assignment PIN_AC1 -to "hip_serial_rx_in2(n)"
set_location_assignment PIN_AC2 -to hip_serial_rx_in2
set_location_assignment PIN_AA1 -to "hip_serial_rx_in3(n)"
set_location_assignment PIN_AA2 -to hip_serial_rx_in3

set_location_assignment PIN_AF3 -to "hip_serial_tx_out0(n)"
set_location_assignment PIN_AF4 -to hip_serial_tx_out0
set_location_assignment PIN_AD3 -to "hip_serial_tx_out1(n)"
set_location_assignment PIN_AD4 -to hip_serial_tx_out1
set_location_assignment PIN_AB3 -to "hip_serial_tx_out2(n)"
set_location_assignment PIN_AB4 -to hip_serial_tx_out2
set_location_assignment PIN_Y3 -to "hip_serial_tx_out3(n)"
set_location_assignment PIN_Y4 -to hip_serial_tx_out3
set_location_assignment PIN_G9 -to hsma_clk_out_p2

set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in0
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in1
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in2
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in3
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out0
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out1
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out2
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out3

#USER1_LED_BUF[0]
set_location_assignment PIN_AF28 -to alive_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to alive_led
#USER1_LED_BUF[1]
set_location_assignment PIN_AG28 -to L0_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to L0_led
#USER1_LED_BUF[2]
set_location_assignment PIN_AH30 -to comp_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to comp_led
##USER1_LED_BUF[3] TODO
set_location_assignment PIN_AJ30 -to gen2_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to gen2_led
#PCIE_LED_X4_BUF On when x4
set_location_assignment PIN_AC29 -to lane_active_led[1]
set_instance_assignment -name IO_STANDARD "2.5 V" -to lane_active_led[1]
#PCIE_LED_X1_BUF On when x1
set_location_assignment PIN_AD28 -to lane_active_led[0]
set_instance_assignment -name IO_STANDARD "2.5 V" -to lane_active_led[0]


set_global_assignment -name FITTER_EFFORT "FAST FIT"

project_close
return 0
