load_package report
load_package flow

puts "Info: *******************************************************************"
puts "   Info: Running qii_seed_sweep.tcl "

#----- more assignments for design that includes BUP --------------
set is_bup ""
foreach argument $quartus(args) {
  if { [ string eq "bup" $argument ] } {
    set is_bup "true"
    puts "   Info: Design included BUP"
    break
  }
}

set project_name  [lindex $quartus(args) 0]
if { [ string eq "" $project_name] } {
   puts "Error: *******************************************************"
   puts "        Invalid first argument                                "
   puts "                                                              "
   puts "  quartus_sh -t qii_seed_sweep.tcl <project>  <revision>      "
   puts "                                                              "
   puts "     <project>      : Quartus II project name  - required     "
   puts "     <revision>     : Quartus II revision name - optional     "
   puts "Error: *******************************************************"
   puts $fileId "   Error: Invalid argument                            "
   close $fileId
   return 1
}
puts "Info: *******************************************************************"
puts "   Info: Quartus project                 : $project_name"

#--------------------------------------------------------------#
#
# Open Quartus II project
#
if { [ project_exists $project_name ]  } {
   project_open $project_name -force
} else {
   puts "Error: *******************************************************************"
   puts "   Error:  Unable to open Quartus II project $project_name"
   puts $fileId "   Error:  Unable to open Quartus II project $project_name"
   close $fileId
   return 1
}

set_location_assignment PIN_V10 -to "refclk_clk(n)"
set_location_assignment PIN_W11 -to refclk_clk
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to refclk_clk

set_location_assignment PIN_AA11 -to reconfig_xcvr_clk
set_instance_assignment -name IO_STANDARD LVDS -to reconfig_xcvr_clk

set_location_assignment PIN_AA22 -to perstn
if { [ string eq "true" $is_bup ] } {   
  set_instance_assignment -name IO_STANDARD "1.8 V" -to perstn
} else {
  set_instance_assignment -name IO_STANDARD "2.5 V" -to perstn
}

set_location_assignment PIN_AK13 -to local_rstn
set_instance_assignment -name IO_STANDARD "2.5 V" -to local_rstn

set_location_assignment PIN_AA15 -to req_compliance_pb
set_instance_assignment -name IO_STANDARD "2.5 V" -to req_compliance_pb

set_location_assignment PIN_H12 -to set_compliance_mode
set_instance_assignment -name IO_STANDARD "2.5 V" -to set_compliance_mode

set_location_assignment PIN_AJ1 -to "hip_serial_rx_in0(n)"
set_location_assignment PIN_AJ2 -to hip_serial_rx_in0
set_location_assignment PIN_AG1 -to "hip_serial_rx_in1(n)"
set_location_assignment PIN_AG2 -to hip_serial_rx_in1
set_location_assignment PIN_AE1 -to "hip_serial_rx_in2(n)"
set_location_assignment PIN_AE2 -to hip_serial_rx_in2
set_location_assignment PIN_AC1 -to "hip_serial_rx_in3(n)"
set_location_assignment PIN_AC2 -to hip_serial_rx_in3

set_location_assignment PIN_AH3 -to "hip_serial_tx_out0(n)"
set_location_assignment PIN_AH4 -to hip_serial_tx_out0
set_location_assignment PIN_AF3 -to "hip_serial_tx_out1(n)"
set_location_assignment PIN_AF4 -to hip_serial_tx_out1
set_location_assignment PIN_AD3 -to "hip_serial_tx_out2(n)"
set_location_assignment PIN_AD4 -to hip_serial_tx_out2
set_location_assignment PIN_AB3 -to "hip_serial_tx_out3(n)"
set_location_assignment PIN_AB4 -to hip_serial_tx_out3
set_location_assignment PIN_B18 -to hsma_clk_out_p2

set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in0
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in1
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in2
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_rx_in3
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out0
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out1
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out2
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to hip_serial_tx_out3

set_location_assignment PIN_AL31 -to alive_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to alive_led
set_location_assignment PIN_AK29 -to L0_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to L0_led
set_location_assignment PIN_AE25 -to comp_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to comp_led
set_location_assignment PIN_AM23 -to gen2_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to gen2_led

set_location_assignment PIN_AF25 -to lane_active_led[3]
set_instance_assignment -name IO_STANDARD "2.5 V" -to lane_active_led[3]
set_location_assignment PIN_AJ27 -to lane_active_led[2]
set_instance_assignment -name IO_STANDARD "2.5 V" -to lane_active_led[2]
set_location_assignment PIN_AC22 -to lane_active_led[1]
set_instance_assignment -name IO_STANDARD "2.5 V" -to lane_active_led[1]
set_location_assignment PIN_AH27 -to lane_active_led[0]
set_instance_assignment -name IO_STANDARD "2.5 V" -to lane_active_led[0]

set_global_assignment -name FITTER_EFFORT "FAST FIT"

if { [ string eq "true" $is_bup ] } { 
# -------------------------------------------------------------------------- #
# new for BUP
# -------------------------------------------------------------------------- #
# Assembler Assignments
# =====================
set_global_assignment -name RESERVE_ALL_UNUSED_PINS_NO_OUTPUT_GND "AS INPUT TRI-STATED"

# Power Estimation Assignments
# ============================
set_global_assignment -name POWER_PRESET_COOLING_SOLUTION "23 MM HEAT SINK WITH 200 LFPM AIRFLOW"
set_global_assignment -name POWER_BOARD_THERMAL_MODEL "NONE (CONSERVATIVE)"

# IO location and standards
# ============================
set_location_assignment PIN_L11 -to hsma_prsntn
set_location_assignment PIN_D12 -to hsma_rx_led
set_location_assignment PIN_B3 -to hsma_tx_led
set_location_assignment PIN_B30 -to hsmb_rx_led
set_location_assignment PIN_C24 -to hsmb_tx_led
set_location_assignment PIN_AD29 -to cpu_resetn
set_location_assignment PIN_AP7 -to enet_gtx_clk
set_location_assignment PIN_AK10 -to enet_intn
set_location_assignment PIN_AM8 -to enet_mdc
set_location_assignment PIN_AG14 -to enet_mdio
set_location_assignment PIN_AN9 -to enet_resetn
set_location_assignment PIN_AM10 -to enet_rx_clk
set_location_assignment PIN_AK14 -to enet_rx_d[0]
set_location_assignment PIN_AL10 -to enet_rx_d[1]
set_location_assignment PIN_AJ14 -to enet_rx_d[2]
set_location_assignment PIN_AK12 -to enet_rx_d[3]
set_location_assignment PIN_AH14 -to enet_rx_dv
set_location_assignment PIN_AB14 -to enet_tx_d[0]
set_location_assignment PIN_AD15 -to enet_tx_d[1]
set_location_assignment PIN_AB15 -to enet_tx_d[2]
set_location_assignment PIN_AB13 -to enet_tx_d[3]
set_location_assignment PIN_AC14 -to enet_tx_en


set_location_assignment PIN_AL12 -to usb_addr[0]
set_location_assignment PIN_AL13 -to usb_addr[1]
set_location_assignment PIN_AC18 -to usb_clk
set_location_assignment PIN_AJ15 -to usb_data[0]
set_location_assignment PIN_AN11 -to usb_data[1]
set_location_assignment PIN_AK15 -to usb_data[2]
set_location_assignment PIN_AP11 -to usb_data[3]
set_location_assignment PIN_AP9 -to usb_data[4]
set_location_assignment PIN_AL15 -to usb_data[5]
set_location_assignment PIN_AL11 -to usb_data[6]
set_location_assignment PIN_AM15 -to usb_data[7]
set_location_assignment PIN_AP10 -to usb_empty
set_location_assignment PIN_AM11 -to usb_full
set_location_assignment PIN_AN14 -to usb_oen
set_location_assignment PIN_AB18 -to usb_rdn
set_location_assignment PIN_AC17 -to usb_resetn
set_location_assignment PIN_AD16 -to usb_scl
set_location_assignment PIN_AC16 -to usb_sda
set_location_assignment PIN_AG15 -to usb_wrn
set_location_assignment PIN_H12 -to user_dipsw[0]
set_location_assignment PIN_A2 -to user_dipsw[1]
set_location_assignment PIN_E10 -to user_dipsw[2]
set_location_assignment PIN_D9 -to user_dipsw[3]
set_location_assignment PIN_E9 -to user_dipsw[4]
set_location_assignment PIN_D7 -to user_dipsw[5]
set_location_assignment PIN_AK13 -to user_pb[0] -disable
set_location_assignment PIN_AA15 -to user_pb[1]
set_location_assignment PIN_AN8 -to user_pb[2]
set_location_assignment PIN_AA21 -to flash_cen
set_location_assignment PIN_AK33 -to fm_a[1]
set_location_assignment PIN_AB28 -to fm_a[10]
set_location_assignment PIN_AE28 -to fm_a[11]
set_location_assignment PIN_AB29 -to fm_a[12]
set_location_assignment PIN_AF28 -to fm_a[13]
set_location_assignment PIN_AH28 -to fm_a[14]
set_location_assignment PIN_AB30 -to fm_a[15]
set_location_assignment PIN_AG29 -to fm_a[16]
set_location_assignment PIN_AA30 -to fm_a[17]
set_location_assignment PIN_AK30 -to fm_a[18]
set_location_assignment PIN_AJ30 -to fm_a[19]
set_location_assignment PIN_AC27 -to fm_a[2]
set_location_assignment PIN_AG30 -to fm_a[20]
set_location_assignment PIN_AN33 -to fm_a[21]
set_location_assignment PIN_AF30 -to fm_a[22]
set_location_assignment PIN_AM33 -to fm_a[23]
set_location_assignment PIN_AK32 -to fm_a[24]
set_location_assignment PIN_AH31 -to fm_a[25]
set_location_assignment PIN_AB24 -to fm_a[3]
set_location_assignment PIN_AB23 -to fm_a[4]
set_location_assignment PIN_AC28 -to fm_a[5]
set_location_assignment PIN_Y24 -to fm_a[6]
set_location_assignment PIN_Y25 -to fm_a[7]
set_location_assignment PIN_AF27 -to fm_a[8]
set_location_assignment PIN_AF26 -to fm_a[9]
set_location_assignment PIN_AJ31 -to fm_d[0]
set_location_assignment PIN_AA23 -to fm_d[1]
set_location_assignment PIN_AA27 -to fm_d[10]
set_location_assignment PIN_AA28 -to fm_d[11]
set_location_assignment PIN_AL32 -to fm_d[12]
set_location_assignment PIN_AC24 -to fm_d[13]
set_location_assignment PIN_AC23 -to fm_d[14]
set_location_assignment PIN_AL33 -to fm_d[15]
set_location_assignment PIN_Y23 -to fm_d[2]
set_location_assignment PIN_Y22 -to fm_d[3]
set_location_assignment PIN_W24 -to fm_d[4]
set_location_assignment PIN_AC29 -to fm_d[5]
set_location_assignment PIN_AB25 -to fm_d[6]
set_location_assignment PIN_AA25 -to fm_d[7]
set_location_assignment PIN_AG28 -to fm_d[8]
set_location_assignment PIN_AH29 -to fm_d[9]


set_instance_assignment -name IO_STANDARD "1.5 V" -to rzqin_1_5v

######## Ethernet Signals ################

set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_intn
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_tx_en
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_mdc
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_mdio
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_resetn
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_rx_d[0]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_rx_d[1]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_rx_d[2]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_rx_d[3]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_tx_d[0]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_tx_d[1]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_tx_d[2]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_tx_d[3]
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_gtx_clk
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_rx_dv
set_instance_assignment -name IO_STANDARD "2.5 V" -to enet_rx_clk

########## Flash/MAX Signals ################
set_instance_assignment -name IO_STANDARD "1.8 V" -to flash_clk
set_instance_assignment -name IO_STANDARD "1.5 V" -to flash_oen
set_instance_assignment -name IO_STANDARD "1.5 V" -to flash_rdybsyn
set_instance_assignment -name IO_STANDARD "1.5 V" -to flash_resetn
set_instance_assignment -name IO_STANDARD "1.5 V" -to flash_wen
set_instance_assignment -name IO_STANDARD "1.5 V" -to flash_advn
set_instance_assignment -name IO_STANDARD "1.8 V" -to flash_cen
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[26]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[25]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[24]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[23]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[22]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[21]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[20]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[19]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[18]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[17]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[16]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[15]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[14]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[13]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[12]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[11]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[10]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[9]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[8]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[7]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[6]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[5]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[4]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[3]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[2]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a[1]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[15]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[14]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[13]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[12]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[11]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[10]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[9]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[8]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[7]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[6]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[5]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[4]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[3]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[2]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[1]
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_d[0]


########## USB Blaster II Signals ################
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[7]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[6]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[5]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[4]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[3]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[2]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[1]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_data[0]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_addr[1]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_addr[0]
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_full
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_empty
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_scl
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_sda
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_resetn
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_oen
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_rdn
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_wrn
set_instance_assignment -name IO_STANDARD "1.5 V" -to usb_clk

########## User Signals ################                
set_instance_assignment -name IO_STANDARD "1.8 V" -to cpu_resetn
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_pb[2]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_pb[1]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_pb[0]
                                                          
                                                          
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[0]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[1]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[2]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[3]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[4]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[5]


########## PCIe Signals ################ 


set_instance_assignment -name IO_STANDARD "1.5 V" -to hsmb_rx_led
set_instance_assignment -name IO_STANDARD "1.5 V" -to hsmb_tx_led


set_instance_assignment -name IO_STANDARD "2.5 V" -to hsma_prsntn
set_instance_assignment -name IO_STANDARD "2.5 V" -to hsma_rx_led
set_instance_assignment -name IO_STANDARD "2.5 V" -to hsma_tx_led
set_location_assignment PIN_AE29 -to flash_clk
set_location_assignment PIN_AG16 -to flash_oen
set_location_assignment PIN_AD20 -to flash_rdybsyn
set_location_assignment PIN_AB16 -to flash_resetn
set_location_assignment PIN_AM14 -to flash_wen
set_instance_assignment -name IO_STANDARD "1.5 V" -to clkin_50
set_location_assignment PIN_V28 -to clkin_50
set_location_assignment PIN_AB34 -to flash_advn
set_location_assignment PIN_AL6 -to disp_i2c_scl
set_location_assignment PIN_AJ10 -to disp_i2c_sda
set_location_assignment PIN_AD24 -to fm_a[26]
set_location_assignment PIN_F7 -to fpga_cen
set_location_assignment PIN_G10 -to fpga_conf_done
set_location_assignment PIN_AH9 -to fpga_config_d[0]
set_location_assignment PIN_AJ7 -to fpga_config_d[1]
set_location_assignment PIN_AH8 -to fpga_config_d[2]
set_location_assignment PIN_AJ6 -to fpga_config_d[3]
set_location_assignment PIN_AG10 -to fpga_config_d[4]
set_location_assignment PIN_AM4 -to fpga_config_d[5]
set_location_assignment PIN_AD11 -to fpga_config_d[6]
set_location_assignment PIN_AM5 -to fpga_config_d[7]
set_location_assignment PIN_AD12 -to fpga_config_d[8]
set_location_assignment PIN_AL7 -to fpga_config_d[9]
set_location_assignment PIN_AJ11 -to fpga_config_d[10]
set_location_assignment PIN_AK7 -to fpga_config_d[11]
set_location_assignment PIN_AH12 -to fpga_config_d[12]
set_location_assignment PIN_AL8 -to fpga_config_d[13]
set_location_assignment PIN_AG13 -to fpga_config_d[14]
set_location_assignment PIN_AK8 -to fpga_config_d[15]
set_location_assignment PIN_AC26 -to fpga_cvp_confdone
set_location_assignment PIN_AF10 -to fpga_dclk
set_location_assignment PIN_J12 -to fpga_msel[0]
set_location_assignment PIN_J11 -to fpga_msel[1]
set_location_assignment PIN_F6 -to fpga_msel[2]
set_location_assignment PIN_K10 -to fpga_msel[3]
set_location_assignment PIN_H7 -to fpga_msel[4]
set_location_assignment PIN_G8 -to fpga_nconfig
set_location_assignment PIN_G9 -to fpga_nstatus
set_location_assignment PIN_AC12 -to fpga_pr_done
set_location_assignment PIN_AC13 -to fpga_pr_error
set_location_assignment PIN_AK9 -to fpga_pr_ready
set_location_assignment PIN_AD25 -to fpga_pr_request
set_location_assignment PIN_AE10 -to jtag_blaster_tdo
set_location_assignment PIN_AF11 -to jtag_fpga_tdo
set_location_assignment PIN_AK5 -to jtag_tck
set_location_assignment PIN_AG11 -to jtag_tms
set_location_assignment PIN_E1 -to rref_tl
set_location_assignment PIN_AP19 -to rzqin_1_5v
set_location_assignment PIN_A20 -to rzqin_hsmb_var
set_location_assignment PIN_E8 -to user_dipsw[6]
set_location_assignment PIN_E7 -to user_dipsw[7]
set_location_assignment PIN_AM23 -to user_led[0]
set_location_assignment PIN_AE25 -to user_led[1] -disable
set_location_assignment PIN_AK29 -to user_led[2] -disable
set_location_assignment PIN_AL31 -to user_led[3] -disable
set_location_assignment PIN_AF25 -to user_led[4] -disable
set_location_assignment PIN_AJ27 -to user_led[5] -disable
set_location_assignment PIN_AC22 -to user_led[6] -disable
set_location_assignment PIN_AH27 -to user_led[7] -disable
set_location_assignment PIN_G19 -to vref_hsmb
set_location_assignment PIN_R1 -to xcvr_rx_n3
set_location_assignment PIN_R2 -to xcvr_rx_p3
set_location_assignment PIN_P3 -to xcvr_tx_n3
set_location_assignment PIN_P4 -to xcvr_tx_p3
set_instance_assignment -name IO_STANDARD "2.5 V" -to disp_i2c_scl
set_instance_assignment -name IO_STANDARD "2.5 V" -to disp_i2c_sda
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[0] -disable
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[1]
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[2]
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[3]
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[4]
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[5]
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[6]
set_instance_assignment -name IO_STANDARD "1.5 V" -to user_led[7]
set_instance_assignment -name IO_STANDARD "1.5 V" -to rzqin_hsmb_var
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[6]
set_instance_assignment -name IO_STANDARD "2.5 V" -to user_dipsw[7]

# Misc
# ============================
set_global_assignment -name STRATIXV_CONFIGURATION_SCHEME "PASSIVE PARALLEL X16"
set_global_assignment -name USE_CONFIGURATION_DEVICE OFF
set_global_assignment -name CRC_ERROR_OPEN_DRAIN ON
set_global_assignment -name ON_CHIP_BITSTREAM_DECOMPRESSION OFF
set_global_assignment -name OUTPUT_IO_TIMING_NEAR_END_VMEAS "HALF VCCIO" -rise
set_global_assignment -name OUTPUT_IO_TIMING_NEAR_END_VMEAS "HALF VCCIO" -fall
set_global_assignment -name OUTPUT_IO_TIMING_FAR_END_VMEAS "HALF SIGNAL SWING" -rise
set_global_assignment -name OUTPUT_IO_TIMING_FAR_END_VMEAS "HALF SIGNAL SWING" -fall


# -----------------------------------
# start ENTITY(c5gt_fpga_bup_top)

	# Pin & Location Assignments
	# ==========================
set_instance_assignment -name FAST_INPUT_REGISTER ON -to rx_control
set_instance_assignment -name FAST_INPUT_REGISTER ON -to rgmii_in
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to tx_control
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to rgmii_out

	# Fitter Assignments
	# ==================
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_addr[0]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_addr[1]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_clk
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[0]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[1]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[2]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[3]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[4]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[5]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[6]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_data[7]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_empty
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_full
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_oen
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_rdn
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_scl
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_sda
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to usb_wrn
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to flash_advn
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to flash_cen
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to flash_clk
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to flash_oen
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to flash_rdybsyn
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to flash_resetn
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to flash_wen
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[0]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[1]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[10]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[11]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[12]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[13]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[14]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[15]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[16]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[17]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[18]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[19]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[2]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[20]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[21]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[22]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[23]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[24]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[25]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[26]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[3]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[4]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[5]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[6]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[7]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[8]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_a[9]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[0]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[1]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[10]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[11]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[12]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[13]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[14]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[15]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[2]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[3]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[4]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[5]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[6]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[7]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[8]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to fm_d[9]
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to pcie_led_x1
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to pcie_led_x4
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to pcie_led_x8
#set_instance_assignment -name ENABLE_BENEFICIAL_SKEW_OPTIMIZATION_FOR_NON_GLOBAL_CLOCKS ON -to ddr3x72_wrap_p0_inst|ddr3x72_inst -tag __ddr3x72_p0
#set_instance_assignment -name PLL_ENFORCE_USER_PHASE_SHIFT ON -to ddr3x72_wrap_p0_inst|ddr3x72_inst|pll0|upll_memphy|auto_generated|pll1 -tag __ddr3x72_p0
#set_instance_assignment -name ENABLE_BENEFICIAL_SKEW_OPTIMIZATION_FOR_NON_GLOBAL_CLOCKS ON -to qdr2x36_wrap_p0_inst|qdr2x36_inst -tag __qdr2x36_p0
#set_instance_assignment -name PLL_ENFORCE_USER_PHASE_SHIFT ON -to qdr2x36_wrap_p0_inst|qdr2x36_inst|pll0|upll_memphy|auto_generated|pll1 -tag __qdr2x36_p0
#set_instance_assignment -name ENABLE_BENEFICIAL_SKEW_OPTIMIZATION_FOR_NON_GLOBAL_CLOCKS ON -to qdr2x36_wrap_p1_inst|qdr2x36_inst -tag __qdr2x36_p0
#set_instance_assignment -name PLL_ENFORCE_USER_PHASE_SHIFT ON -to qdr2x36_wrap_p1_inst|qdr2x36_inst|pll0|upll_memphy|auto_generated|pll1 -tag __qdr2x36_p0
#set_instance_assignment -name ENABLE_BENEFICIAL_SKEW_OPTIMIZATION_FOR_NON_GLOBAL_CLOCKS ON -to ddr3x72_example_inst|if0 -tag __ddr3x72_example_if0_p0
#set_instance_assignment -name PLL_ENFORCE_USER_PHASE_SHIFT ON -to ddr3x72_example_inst|if0|pll0|upll_memphy|auto_generated|pll1 -tag __ddr3x72_example_if0_p0
#set_instance_assignment -name ENABLE_BENEFICIAL_SKEW_OPTIMIZATION_FOR_NON_GLOBAL_CLOCKS ON -to qdr2x36_example_inst|if0 -tag __qdr2x36_example_if0_p0
#set_instance_assignment -name PLL_ENFORCE_USER_PHASE_SHIFT ON -to qdr2x36_example_inst|if0|pll0|upll_memphy|auto_generated|pll1 -tag __qdr2x36_example_if0_p0
set_instance_assignment -name GLOBAL_SIGNAL OFF -to *reset_ff_wr
set_instance_assignment -name GLOBAL_SIGNAL OFF -to *reset_ff_rd
set_instance_assignment -name GLOBAL_SIGNAL OFF -to *reset_sync_*|altera_tse_reset_synchronizer_chain[0]
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to clkin_50

	# start DESIGN_PARTITION(Top)
	# ---------------------------

		# Incremental Compilation Assignments
		# ===================================
set_global_assignment -name PARTITION_NETLIST_TYPE SOURCE -section_id Top
set_global_assignment -name PARTITION_FITTER_PRESERVATION_LEVEL PLACEMENT_AND_ROUTING -section_id Top
set_global_assignment -name PARTITION_COLOR 16764057 -section_id Top

	# end DESIGN_PARTITION(Top)
	# -------------------------

set_global_assignment -name MIN_CORE_JUNCTION_TEMP 0
set_global_assignment -name MAX_CORE_JUNCTION_TEMP 85
set_instance_assignment -name IO_MAXIMUM_TOGGLE_RATE "10 MHz" -to cpu_resetn
set_global_assignment -name ENABLE_DRC_SETTINGS ON
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to enet_rx_clk
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to altera_reserved_tck
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to virtual_phy_clk
set_instance_assignment -name MAX_FANOUT 90 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_tse_mac:tse_mac|altera_tse_mac:altera_tse_mac_inst|altera_tse_top_gen_host:top_gen_host_inst|altera_tse_top_w_fifo_10_100_1000:U_MAC_TOP|altera_tse_clk_cntl:U_CLKCT|rxclk_ena"
set_instance_assignment -name MAX_FANOUT 90 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_tse_mac:tse_mac|altera_tse_mac:altera_tse_mac_inst|altera_tse_top_gen_host:top_gen_host_inst|altera_tse_top_w_fifo_10_100_1000:U_MAC_TOP|altera_tse_clk_cntl:U_CLKCT|txclk_ena"
set_global_assignment -name SEED 2
set_global_assignment -name FIT_ATTEMPTS_TO_SKIP 0
set_instance_assignment -name CURRENT_STRENGTH_NEW "MAXIMUM CURRENT" -to enet_*
set_instance_assignment -name IO_STANDARD "1.8 V" -to fm_a
set_global_assignment -name TEXT_FILE software/c5pro_sss0/sss.out.txt
set_location_assignment PIN_AK19 -to pcie_led_x1
set_location_assignment PIN_AD22 -to pcie_led_x4
set_instance_assignment -name IO_STANDARD "1.5 V" -to pcie_led_x1 -disable
set_instance_assignment -name IO_STANDARD "1.5 V" -to pcie_led_x4 -disable
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to bup_top|c5gt_fpga_bup_qsys_inst|enet_pll|altera_pll_i|general[0].gpll~PLL_OUTPUT_COUNTER|divclk
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to bup_top|c5gt_fpga_bup_qsys_inst|enet_pll|altera_pll_i|general[1].gpll~PLL_OUTPUT_COUNTER|divclk
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to bup_top|c5gt_fpga_bup_qsys_inst|enet_pll|altera_pll_i|general[2].gpll~PLL_OUTPUT_COUNTER|divclk
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to enet_gtx_clk_125
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to enet_gtx_clk_25
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to enet_gtx_clk_2p5
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to tx_clk_125
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to tx_clk_25
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to tx_clk_2p5
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to altera_internal_jtag~FF_13
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to altera_internal_jtag~FF_14
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to altera_internal_jtag~FF_32
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to altera_internal_jtag~FF_33
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cfi_flash_atb_bridge_0:cfi_flash_atb_bridge_0|tcm_data_outen_reg"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cfi_flash_atb_bridge_0:cfi_flash_atb_bridge_0|tcm_read_n_out_reg[0]"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cfi_flash_atb_bridge_0:cfi_flash_atb_bridge_0|tcm_read_n_outen_reg"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cfi_flash_atb_bridge_0:cfi_flash_atb_bridge_0|tcm_write_n_out_reg[0]"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cfi_flash_atb_bridge_0:cfi_flash_atb_bridge_0|tcm_write_n_outen_reg"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_tse_mac:tse_mac|altera_tse_mac:altera_tse_mac_inst|altera_tse_top_gen_host:top_gen_host_inst|altera_tse_top_mdio:U_MDIO|altera_tse_mdio_clk_gen:U_CLKGEN|mdio_clk"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_tse_mac:tse_mac|altera_tse_mac:altera_tse_mac_inst|altera_tse_top_gen_host:top_gen_host_inst|altera_tse_top_mdio:U_MDIO|mdio_oen"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_tse_mac:tse_mac|altera_tse_mac:altera_tse_mac_inst|altera_tse_top_gen_host:top_gen_host_inst|altera_tse_top_mdio:U_MDIO|mdio_out"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|i2c_opencores:i2c_opencores_lcd|i2c_master_top:i2c_master_top_inst|i2c_master_byte_ctrl:byte_controller|i2c_master_bit_ctrl:bit_controller|scl_oen"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|i2c_opencores:i2c_opencores_lcd|i2c_master_top:i2c_master_top_inst|i2c_master_byte_ctrl:byte_controller|i2c_master_bit_ctrl:bit_controller|sda_oen"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to count125[27]
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to count25[24]
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to epcount[18]
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "sld_hub:auto_hub|sld_jtag_hub:\\jtag_hub_gen:sld_jtag_hub_inst|tdo"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cfi_flash_atb_bridge_0:cfi_flash_atb_bridge_0|tcm_address_out_reg[*]"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cfi_flash_atb_bridge_0:cfi_flash_atb_bridge_0|tcm_chipselect_n_out_reg[*]"
set_instance_assignment -name FAST_OUTPUT_REGISTER ON -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_led_pio:led_pio|data_out[*]"
set_instance_assignment -name GLOBAL_SIGNAL "GLOBAL CLOCK" -to bup_top|c5gt_fpga_bup_qsys_inst|enet_pll|altera_pll_i|general[0].gpll~FRACTIONAL_PLL|vcoph[*]
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cpu:cpu|d_address_line_field[0]"
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cpu:cpu|d_address_offset_field[0]"
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_onchip_ram:onchip_ram|altsyncram:the_altsyncram|altsyncram_r1k1:auto_generated|address_reg_a[1]"
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_onchip_ram:onchip_ram|altsyncram:the_altsyncram|altsyncram_r1k1:auto_generated|address_reg_a[2]"
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_tse_mac:tse_mac|altera_tse_mac:altera_tse_mac_inst|altera_tse_top_gen_host:top_gen_host_inst|altera_tse_mac_control:U_MAC_CONTROL|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]"
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cpu:cpu|d_address_offset_field[2]"
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cpu:cpu|d_address_offset_field[1]"
set_instance_assignment -name MAX_FANOUT 60 -to altera_internal_jtag~FF_38
set_instance_assignment -name MAX_FANOUT 60 -to altera_internal_jtag~FF_19
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_cpu:cpu|d_address_line_field[1]"
set_instance_assignment -name MAX_FANOUT 60 -to "c5gt_fpga_bup_top:bup_top|c5gt_fpga_bup_qsys:c5gt_fpga_bup_qsys_inst|c5gt_fpga_bup_qsys_onchip_ram:onchip_ram|altsyncram:the_altsyncram|altsyncram_r1k1:auto_generated|address_reg_a[0]"
set_instance_assignment -name FAST_INPUT_REGISTER ON -to enet_rx*
set_global_assignment -name QIP_FILE c5gt_fpga_bup_qsys/synthesis/c5gt_fpga_bup_qsys.qip
set_global_assignment -name QIP_FILE c5gt_fpga_bup_qsys/synthesis/submodules/c5gt_fpga_bup_qsys_enet_pll.qip
set_global_assignment -name QIP_FILE enet_gtx_clk_ddio_buffer.qip

set_instance_assignment -name PARTITION_HIERARCHY root_partition -to | -section_id Top

}

project_close
return 0
