// (C) 2001-2014 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera MegaCore Function License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synopsys translate_off
`timescale 1 ps / 1 ps
// synopsys translate_on

module altpcieav_hip_interface
  # (
       parameter DEVICE_FAMILY     = "Stratix V",
       parameter SRIOV_EN          = 0,
       parameter VF_COUNT          = 32,
       parameter RXFIFO_DATA_WIDTH = (SRIOV_EN == 1) ? 274 : 266,
       parameter DMA_WIDTH         = 256,
       parameter DMA_BE_WIDTH      = 32,
       parameter TX_FIFO_WIDTH     = (DMA_WIDTH == 256) ? 260 : 131
    )

(
    input  logic                                     Clk_i,
    input  logic                                     Rstn_i,
    
    output logic                                     RxStReady_o,
    input  logic  [DMA_WIDTH-1:0]                    RxStData_i,
    input  logic  [1:0]                              RxStEmpty_i,
    input  logic                                     RxStSop_i,
    input  logic                                     RxStEop_i,
    input  logic                                     RxStValid_i,
    input  logic  [7:0]                              RxStBarDec1_i,
    input  logic  [7:0]                              RxStFunc_i,    // SR-IOV: rx_st_bar_hit_fn_tlp0, =>  Target Function for first TLP in this cycle
    
    input  logic                                     TxStReady_i  ,
    output logic   [DMA_WIDTH-1:0]                   TxStData_o   ,
    output logic                                     TxStSop_o    ,
    output logic                                     TxStEop_o    ,                      
    output logic   [1:0]                             TxStEmpty_o  ,
    output logic                                     TxStValid_o  ,
    
          // Rx fifo Interface
    input logic                                      RxFifoRdReq_i,
    output  logic [RXFIFO_DATA_WIDTH-1:0]            RxFifoDataq_o,
    output  logic [3:0]                              RxFifoCount_o,
    
    input   logic                                    PreDecodeTagRdReq_i,     
    output  logic [7:0]                              PreDecodeTag_o,         
    output  logic [3:0]                              PreDecodeTagCount_o, 
                                                    
    // Tx fifo Interface                            
    input logic                                      TxFifoWrReq_i,
    input logic [TX_FIFO_WIDTH-1:0]                  TxFifoData_i,
    output  logic [3:0]                              TxFifoCount_o,
    // Cfg interface
    output  logic  [81:0]                            MsiIntfc_o,
    output  logic  [15:0]                            MsixIntfc_o,
    input   logic  [3:0]                             CfgAddr_i, 
    input   logic  [31:0]                            CfgCtl_i, 
    output  logic  [12:0]                            CfgBusDev_o,
    output  logic  [31:0]                            DevCsr_o,
    output  logic  [31:0]                            PciCmd_o,     
    output  logic  [31:0]                            MsiDataCrl_o,

    // SRIOV I/O

   input  logic [7:0]                                bus_num_f0_i,       // Captured bus number for PF0
   input  logic [4:0]                                device_num_f0_i,    // Captured device number for PF0
   input  logic [2:0]                                max_payload_size_i, // Max payload size from Device Control Register of PF 0
   input  logic [2:0]                                rd_req_size_i,      // Read Request Size from Device Control Register of PF 0
   input  logic                                      bus_master_en_pf_i, // Bus Master Enable for PF 0
   input  logic [VF_COUNT-1:0]                       bus_master_en_vf_i  // Bus Master Enable for VFs

    


);

    logic                                            rx_fifo_wrreq;
    logic  [RXFIFO_DATA_WIDTH-1:0]                   rx_fifo_data;
    logic  [RXFIFO_DATA_WIDTH-1:0]                   rx_fifo_dataq;
    logic  [3:0]                                     rx_fifo_count;
    logic                                            tx_fifo_rdreq;
    logic  [3:0]                                     tx_fifo_count;
    logic  [TX_FIFO_WIDTH-1:0]                       tx_fifo_dataq;
    logic  [255:0]                                   tx_tlp_out_reg;
    logic                                            tx_sop_out_reg;
    logic                                            tx_eop_out_reg;
    logic  [1:0]                                     tx_empty_out_reg;
    logic                                            output_valid_reg;
    logic                                            fifo_valid_reg;
    logic                                            output_transmit;
    logic                                            fifo_transmit;   
    logic                                            tx_st_ready_reg;     
    logic                                            output_fifo_rdempty;      
    logic  [12:0]                                    cfg_busdev;            
    logic  [31:0]                                    cfg_dev_csr;           
    logic  [15:0]                                    msi_ena;               
    logic  [15:0]                                    msix_control;          
    logic  [15:0]                                    cfg_prmcsr;            
    logic  [63:0]                                    msi_addr;              
    logic  [15:0]                                    msi_data;              
    logic  [63:0]                                    msi_addr_reg;          
    logic  [15:0]                                    msi_data_reg;          
    logic  [15:0]                                    msi_ena_reg;           
    logic  [15:0]                                    msix_control_reg;             
    logic                                            rstn_reg;

    logic                                            rstn_rr;

    logic                                            rstn_r;
    logic  [3:0]                                     cfg_addr_reg;
    logic   [31:0]                                   cfg_data_reg;
    logic  [255:0]                                   rx_input_data_reg;
    logic                                            rx_input_valid_reg;
    logic                                            rx_input_sop_reg;
    logic                                            rx_input_eop_reg;
    logic  [1:0]                                     rx_input_empty_reg;
    logic  [5:0]                                     rx_input_bardesc_reg;

    logic  [255:0]                                   rx_input_data_reg2;
    logic                                            rx_input_valid_reg2;
    logic                                            rx_input_sop_reg2;
    logic                                            rx_input_eop_reg2;
    logic  [1:0]                                     rx_input_empty_reg2;
    logic  [5:0]                                     rx_input_bardesc_reg2;    
    
    logic  [7:0]                                     cpl_tag;
    logic                                            is_cpl_wd;
    logic                                            valid_dma_rd_cpl;
    logic                                            tag_predecode_fifo_wrreq;
   
   //============================
   // SR-IOV signals
   //============================
    logic  [7:0]                                     rx_input_func_reg;    
    logic  [7:0]                                     rx_input_func_reg2;    

// ==============================================================================================
// Workaround for 128 AV/CV rx_st_valid being deasserted within single TLP
// Insert an additional FIFO before rx_input_fifo to account for the deassertion of rx_st_valid b/w sop and eop while rx_st_ready is asserted
localparam RX_BUFFER_ENABLE = (DEVICE_FAMILY=="Arria V" | DEVICE_FAMILY=="Cyclone V") & (DMA_WIDTH==128);
logic [RXFIFO_DATA_WIDTH-1:0] rx_buf_fifo_data;
logic [RXFIFO_DATA_WIDTH-1:0] rx_buf_fifo_dataq;
logic [6:0]                   rx_buf_fifo_usedw;
logic                         rx_buf_fifo_rdreq;
logic                         rx_buf_fifo_rdreq_reg;
logic                         rx_buf_fifo_wrreq;
logic [6:0]                   rx_buf_fifo_eop_count; // How many EOP(full TLP) are in the FIFO
logic                         rx_buf_fifo_eop_in; // Asserted when EOP is inserted into FIFO
logic                         rx_buf_fifo_eop_out; // Asserted when EOP is taken out of FIFO
logic                         rx_input_eop_reg3; 
logic                         rx_input_eop_reg4;
logic                         rx_input_eop_ready; // Account for delay b/w data and dataq in scfifo
logic                         rx_buf_fifo_rd_continue; // Pop out SOP but not yet pop EOP from FIFO
logic                         rx_buf_fifo_dataq_sop; // SOP appears in the output dataq
logic                         rx_buf_fifo_dataq_eop; // EOP appears in the output dataq 

generate if (RX_BUFFER_ENABLE) begin
   always @(posedge Clk_i or negedge Rstn_i) 
   begin
      if (~Rstn_i) begin
	      rx_input_eop_reg3 <= 1'b0;
         rx_input_eop_reg4 <= 1'b0;
      end
      else begin
         rx_input_eop_reg3 <= rx_input_eop_reg2;
         rx_input_eop_reg4 <= rx_input_eop_reg3;
      end 
   end

   always @(posedge Clk_i or negedge Rstn_i) 
   begin
      if (~Rstn_i) begin
	      rx_input_eop_ready <= 1'b0;
      end
      else if (rx_input_eop_reg4)
         rx_input_eop_ready <= 1'b1;
      else if (rx_input_eop_reg2)
         rx_input_eop_ready <= 1'b0;
   end

   always @(posedge Clk_i or negedge Rstn_i) 
   begin
      if (~Rstn_i) begin
	      rx_buf_fifo_rd_continue <= 1'b0;
      end
      else if (rx_buf_fifo_dataq_sop & ~rx_buf_fifo_dataq_eop)
         rx_buf_fifo_rd_continue <= 1'b1;
      else if (rx_buf_fifo_dataq_eop)
         rx_buf_fifo_rd_continue <= 1'b0;
   end

   always @(posedge Clk_i or negedge Rstn_i)
	begin
	   if (~Rstn_i) begin
         rx_buf_fifo_rdreq_reg <= 0;
      end
		else begin
         rx_buf_fifo_rdreq_reg <= rx_buf_fifo_rdreq;
      end
	end

   always @(posedge Clk_i or negedge Rstn_i) 
   begin
      if (~Rstn_i)
	      rx_buf_fifo_eop_count <= 7'h0;
      else if (rx_buf_fifo_eop_in & ~(rx_buf_fifo_eop_out))
         rx_buf_fifo_eop_count <= rx_buf_fifo_eop_count + 7'h1;
      else if (~rx_buf_fifo_eop_in & rx_buf_fifo_eop_out)
         rx_buf_fifo_eop_count <= rx_buf_fifo_eop_count - 7'h1;
      else
         rx_buf_fifo_eop_count <= rx_buf_fifo_eop_count;
   end

   assign rx_buf_fifo_data = rx_fifo_data;
   assign rx_buf_fifo_wrreq = rx_fifo_wrreq;
   assign rx_buf_fifo_rdreq = (rx_fifo_count > 8)? 1'b0 :
                              (rx_buf_fifo_usedw==0)? 1'b0 :
                              (rx_buf_fifo_eop_count==4'h0)? 1'b0 :
                              (rx_buf_fifo_eop_count==4'h1&rx_buf_fifo_dataq_eop&rx_buf_fifo_rdreq_reg)? 1'b0 :
                              ((rx_buf_fifo_dataq_sop|rx_buf_fifo_rd_continue) & ~rx_buf_fifo_dataq_eop)? 1'b1 :
                              rx_input_eop_ready;
   assign rx_buf_fifo_dataq_sop = rx_buf_fifo_dataq[256];
   assign rx_buf_fifo_dataq_eop = rx_buf_fifo_dataq[257];
   assign rx_buf_fifo_eop_in = rx_input_eop_reg2 & rx_buf_fifo_wrreq;
   assign rx_buf_fifo_eop_out = rx_buf_fifo_rdreq_reg & rx_buf_fifo_dataq_eop;
   
	// RX buffer FIFO
	scfifo	rx_input_buffer_fifo (
            .rdreq(rx_buf_fifo_rdreq),
				.clock (Clk_i),
				.wrreq (rx_buf_fifo_wrreq),
				.data (rx_buf_fifo_data),
				.usedw (rx_buf_fifo_usedw),
				.empty (),
				.q (rx_buf_fifo_dataq),
				.full (),
				.aclr (~Rstn_i),
				.almost_empty (),
				.almost_full (),
				.sclr (1'b0)
				);
	defparam
		rx_input_buffer_fifo.add_ram_output_register = "ON",
      rx_input_buffer_fifo.intended_device_family = "Stratix V",
		rx_input_buffer_fifo.lpm_numwords = 80, // Each depth stores 4DW. Max TLP=128DW. TLP header=4DW.
		rx_input_buffer_fifo.lpm_showahead = "OFF",
		rx_input_buffer_fifo.lpm_type = "scfifo",
		rx_input_buffer_fifo.lpm_width = RXFIFO_DATA_WIDTH,
      rx_input_buffer_fifo.lpm_widthu = 7,
		rx_input_buffer_fifo.overflow_checking = "ON",
		rx_input_buffer_fifo.underflow_checking = "ON",
		rx_input_buffer_fifo.use_eab = "ON";
end
endgenerate
// ==============================================================================================

/// Rx input FIFO

altpcie_fifo 
   #(
    .FIFO_DEPTH(10),    
    .DATA_WIDTH(RXFIFO_DATA_WIDTH)   
    )
 rx_input_fifo   
(
      .clk(Clk_i),       
      .rstn(Rstn_i),      
      .srst(1'b0),      
      .wrreq((RX_BUFFER_ENABLE==0)?	rx_fifo_wrreq : rx_buf_fifo_rdreq_reg),
      .rdreq(RxFifoRdReq_i),     
      .data((RX_BUFFER_ENABLE==0)? rx_fifo_data : rx_buf_fifo_dataq),
      .q(rx_fifo_dataq),         
      .fifo_count(rx_fifo_count) 
);


/// Tag predecode fifo used to look ahead tag array for fmax
assign cpl_tag       = rx_input_data_reg[79:72];
assign is_cpl_wd     = rx_input_data_reg[30] & (rx_input_data_reg[28:24]==5'b01010) & rx_input_sop_reg;
assign valid_dma_rd_cpl = is_cpl_wd & cpl_tag <= 15;
assign tag_predecode_fifo_wrreq = valid_dma_rd_cpl & rx_input_valid_reg;

altpcie_fifo 
   #(
    .FIFO_DEPTH(16),    
    .DATA_WIDTH(8)   
    )
 predecode_tag_fifo   
(
      .clk(Clk_i),       
      .rstn(Rstn_i),      
      .srst(1'b0),      
      .wrreq(tag_predecode_fifo_wrreq),     
      .rdreq(PreDecodeTagRdReq_i),     
      .data(cpl_tag),      
      .q(PreDecodeTag_o),         
      .fifo_count(PreDecodeTagCount_o) 
);
/// Tx output FIFO

	scfifo	tx_output_fifo (
				.rdreq (tx_fifo_rdreq),
				.clock (Clk_i),
				.wrreq (TxFifoWrReq_i),
				.data (TxFifoData_i),
				.usedw (tx_fifo_count),
				.empty (output_fifo_rdempty),
				.q (tx_fifo_dataq),
				.full (),
				.aclr (~Rstn_i),
				.almost_empty (),
				.almost_full (),
				.sclr ()
				);
	defparam
		tx_output_fifo.add_ram_output_register = "ON",
		tx_output_fifo.intended_device_family = "Stratix V",
		tx_output_fifo.lpm_numwords = 16,
		tx_output_fifo.lpm_showahead = "OFF",
		tx_output_fifo.lpm_type = "scfifo",
		tx_output_fifo.lpm_width = TX_FIFO_WIDTH,
		tx_output_fifo.lpm_widthu = 4,
		tx_output_fifo.overflow_checking = "ON",
		tx_output_fifo.underflow_checking = "ON",
		tx_output_fifo.use_eab = "ON";


// Rx fifo Interface
assign rx_fifo_data[RXFIFO_DATA_WIDTH-1:0] = (SRIOV_EN == 1) ?  {rx_input_func_reg2[7:0], rx_input_bardesc_reg2[5:0], rx_input_empty_reg2,rx_input_eop_reg2, rx_input_sop_reg2, rx_input_data_reg2} :
                                             {rx_input_bardesc_reg2[5:0], rx_input_empty_reg2,rx_input_eop_reg2, rx_input_sop_reg2, rx_input_data_reg2};
assign rx_fifo_wrreq = rx_input_valid_reg2;
assign RxStReady_o = (RX_BUFFER_ENABLE == 1)? (rx_buf_fifo_usedw <= 65) :
                                              (rx_fifo_count <= 5 );

always @ (posedge Clk_i or negedge Rstn_i)
  begin
     if (~Rstn_i)
       begin
         cfg_addr_reg <= 4'h0;
         cfg_data_reg <= 32'h0;
         rx_input_data_reg <= 256'h0;
         rx_input_valid_reg <= 1'b0;
         rx_input_sop_reg <= 1'b0;
         rx_input_eop_reg <= 1'b0;
         rx_input_empty_reg <= 2'b00;
         rx_input_bardesc_reg <= 6'h0;
         
         rx_input_data_reg2 <= 256'h0;
         rx_input_valid_reg2 <= 1'b0;
         rx_input_sop_reg2 <= 1'b0;
         rx_input_eop_reg2 <= 1'b0;
         rx_input_empty_reg2 <= 2'b00;
         rx_input_bardesc_reg2 <= 6'h0;
         
       end
     else
       begin
         cfg_addr_reg <= CfgAddr_i[3:0];
         cfg_data_reg <= CfgCtl_i[31:0];
         rx_input_data_reg <= RxStData_i;
         rx_input_valid_reg <= RxStValid_i;
         rx_input_sop_reg <= RxStSop_i;
         rx_input_eop_reg <= RxStEop_i;
         rx_input_empty_reg <= RxStEmpty_i;
         rx_input_bardesc_reg <= RxStBarDec1_i;
         rx_input_data_reg2 <= rx_input_data_reg;
         rx_input_valid_reg2 <= rx_input_valid_reg;
         rx_input_sop_reg2 <= rx_input_sop_reg;
         rx_input_eop_reg2 <= rx_input_eop_reg;
         rx_input_empty_reg2 <= rx_input_empty_reg;
         rx_input_bardesc_reg2 <= rx_input_bardesc_reg;
         // Expand to support SR-IOV
         rx_input_func_reg   <= RxStFunc_i;
         rx_input_func_reg2  <= rx_input_func_reg;
      end
end


// Tx fifo interface
always @ (posedge Clk_i or negedge Rstn_i)
  begin
     if (~Rstn_i)
       tx_tlp_out_reg <= 256'h0;
     else if(fifo_transmit)
       tx_tlp_out_reg <= tx_fifo_dataq[DMA_WIDTH-1:0];
  end

always @ (posedge Clk_i or negedge Rstn_i)
  begin
     if (~Rstn_i)
      begin
       tx_sop_out_reg <= 1'b0;
       tx_eop_out_reg <= 1'b0; 
       tx_empty_out_reg <= 1'b0;
      end
     else if(fifo_transmit)
      begin
       tx_sop_out_reg <= (DMA_WIDTH == 256) ? tx_fifo_dataq[256] : tx_fifo_dataq[128];
       tx_eop_out_reg <= (DMA_WIDTH == 256) ? tx_fifo_dataq[257] : tx_fifo_dataq[129];
       tx_empty_out_reg <= (DMA_WIDTH == 256) ? tx_fifo_dataq[259:258] : tx_fifo_dataq[130];
      end
     else if(output_transmit)
      begin
       tx_sop_out_reg <= 1'b0;
       tx_eop_out_reg <= 1'b0;
       tx_empty_out_reg <= 2'b00;
      end
  end
  
always @ (posedge Clk_i or negedge Rstn_i)
  begin
     if (~Rstn_i)
       output_valid_reg <= 1'b0;
     else if(fifo_transmit)
       output_valid_reg <= 1'b1;
     else if (output_transmit)
       output_valid_reg <= 1'b0;
  end
  
always @ (posedge Clk_i or negedge Rstn_i)
  begin
     if (~Rstn_i)
       fifo_valid_reg <= 1'b0;
     else if(tx_fifo_rdreq)
       fifo_valid_reg <= 1'b1;
     else if (fifo_transmit)
       fifo_valid_reg <= 1'b0;
  end
  
always @ (posedge Clk_i or negedge Rstn_i)
  begin
     if (~Rstn_i)
       tx_st_ready_reg <= 1'b0;
     else
       tx_st_ready_reg <= TxStReady_i;
  end
  
  
assign output_transmit = output_valid_reg & tx_st_ready_reg;
assign fifo_transmit   = fifo_valid_reg & (~output_valid_reg | output_valid_reg & output_transmit);
assign tx_fifo_rdreq = ~output_fifo_rdempty & (~fifo_valid_reg | fifo_valid_reg & fifo_transmit);

assign TxStData_o =tx_tlp_out_reg;
assign TxStSop_o  = tx_sop_out_reg;
assign TxStEop_o  = tx_eop_out_reg; 
assign TxStEmpty_o[1:0] = tx_empty_out_reg[1:0];
assign TxStValid_o = output_transmit;

assign RxFifoCount_o = rx_fifo_count;

assign TxFifoCount_o = tx_fifo_count;


/// Config CTL
    //Configuration Demux logic 
    
generate if (SRIOV_EN == 0) 
  begin 
    always @(posedge Clk_i or negedge Rstn_i)
      begin
  	    if(~Rstn_i)
  	      begin
            rstn_r <= 1'b0; 
            rstn_rr <= 1'b0;
          end
        else
          begin
       	    rstn_r <= 1'b1;
            rstn_rr <= rstn_r;
        end
    end
 
    assign rstn_reg = rstn_rr;
    
    always @(posedge Clk_i or negedge rstn_reg) 
      begin
        if (rstn_reg == 0)
          begin
            cfg_busdev  <= 13'h0;
            cfg_dev_csr <= 32'h0;
            msi_ena     <= 16'b0;
            msix_control <= 16'h0;
            msi_data    <= 16'h0;
            msi_addr    <= 64'h0;
            cfg_prmcsr  <= 16'h0;
          end
        else 
          begin
            cfg_busdev          <= (cfg_addr_reg[3:0]==4'hF) ? cfg_data_reg[12 : 0]  : cfg_busdev;
            cfg_dev_csr         <= (cfg_addr_reg[3:0]==4'h0) ? {16'h0, cfg_data_reg[31 : 16]}  : cfg_dev_csr;
            msi_ena             <= (cfg_addr_reg[3:0]==4'hD) ? cfg_data_reg[15:0]   :  msi_ena;
            msix_control        <= (cfg_addr_reg[3:0] == 4'hD) ? cfg_data_reg[31:16]  :  msix_control; 
            cfg_prmcsr          <= (cfg_addr_reg[3:0]==4'h3) ? cfg_data_reg[23:8]   :  cfg_prmcsr;
            msi_addr[11:0]      <= (cfg_addr_reg[3:0]==4'h5) ? cfg_data_reg[31:20]  :  msi_addr[11:0];
            msi_addr[31:12]     <= (cfg_addr_reg[3:0]==4'h9) ? cfg_data_reg[31:12]  :  msi_addr[31:12];
            msi_addr[43:32]     <= (cfg_addr_reg[3:0]==4'h6) ? cfg_data_reg[31:20]  :  msi_addr[43:32];
            msi_addr[63:44]     <= (cfg_addr_reg[3:0]==4'hB) ? cfg_data_reg[31:12]  :  msi_addr[63:44];
            msi_data[15:0]      <= (cfg_addr_reg[3:0]==4'hF) ? cfg_data_reg[31:16]  :  msi_data[15:0];
          end
      end 

    always @(posedge Clk_i or negedge rstn_reg)
    begin
      if(~rstn_reg)
        begin
        msi_data_reg      <= 16'h0;
        msi_ena_reg       <= 16'h0;
        msix_control_reg  <= 16'h0;
        msi_addr_reg      <= 64'h0;
        end
      else
        begin
        msi_data_reg      <= msi_data;
        msi_addr_reg      <= msi_addr;
        msi_ena_reg       <= msi_ena;   
        msix_control_reg  <= msix_control; 
        end
    end
  end // generate 
endgenerate

generate if (SRIOV_EN == 1) 
  begin 
    assign MsiIntfc_o         = 82'h0;
    assign CfgBusDev_o[12:0]  = {bus_num_f0_i, device_num_f0_i};   
    assign DevCsr_o[31:0]     = { 17'h0,                   //[31: 15]
                                  rd_req_size_i[2:0],      //[14:12] = MRRS, 
                                  4'h0,                    //[11:;8]
                                  max_payload_size_i[2:0], //[7:5] = MPS
                                  5'h0                     //[4:0]
                                };               
    assign PciCmd_o           = {16'h0, 
                                 9'h0,
                                 bus_master_en_vf_i[3:0],  //[3:0] MasterEnable for VF0 of PF0 (Borrow this bit to minimize changes)
                                 bus_master_en_pf_i,       //[2] MasterEnable for PF0 
                                 2'h0   
                                };
    assign MsiDataCrl_o       = 32'h0;

  end // generate for SRIOV
else 
  begin // Normal non-config bypass for one function
    assign MsiIntfc_o[63:0]  = msi_addr_reg;
    assign MsiIntfc_o[79:64] = msi_data_reg;
    assign MsiIntfc_o[80]    = msi_ena_reg[0];
    assign MsiIntfc_o[81]    = cfg_prmcsr[2];  // Master Enable
    assign MsixIntfc_o[15:0] = msix_control_reg;                 
    assign CfgBusDev_o[12:0] = cfg_busdev;   
    assign DevCsr_o[31:0]    = cfg_dev_csr;
    assign PciCmd_o = {16'h0, cfg_prmcsr};
    assign MsiDataCrl_o = {msi_data_reg, msi_ena_reg};
  end  
endgenerate

assign RxFifoDataq_o = rx_fifo_dataq;       

endmodule
