/*
 * |-----------------------------------------------------------------------|
 * |                                                                       |
 * |   Copyright Avery Design Systems, Inc. 2017.                          |
 * |     All Rights Reserved.       Licensed Software.                     |
 * |                                                                       |
 * |                                                                       |
 * | THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AVERY DESIGN SYSTEMS   |
 * | The copyright notice above does not evidence any actual or intended   |
 * | publication of such source code.                                      |
 * |                                                                       |
 * |-----------------------------------------------------------------------|
 */

//`timescale 1ps/1ps

//<---- The commented out lines below should be included in the top most module to import the Avery VIP
//`include "apci_defines.svh"
//import avery_pkg::*;
//import apci_pkg::*;
//import apci_pkg_test::*;

apci_device rc;

`ifndef APCI_NUM_LANES
    `define APCI_NUM_LANES 16
`endif

`ifndef APCI_COMMON_CLOCK
    `define APCI_COMMON_CLOCK 1
`endif

`ifdef APCI_FIXED_WIDTH
    parameter GEN1_W   = 4;
    parameter GEN2_W   = 4;
    parameter GEN3_W   = 4;
    parameter GEN4_W   = 4;
    parameter GEN1_CLK = 0; // 62.5M
    parameter GEN2_CLK = 1; // 125M
    parameter GEN3_CLK = 2;
    parameter GEN4_CLK = 3;
`else // fixed  clock
    parameter GEN1_W   = 4;
    parameter GEN2_W   = 4;
    parameter GEN3_W   = 4;
    parameter GEN4_W   = 4;
    parameter GEN1_CLK = 0; // 2: 125M
    parameter GEN2_CLK = 1;
    parameter GEN3_CLK = 2;
    parameter GEN4_CLK = 3; // 3: 500M
`endif

apci_pipe_intf rc_pif[`APCI_NUM_LANES]();
apci_pipe_intf ep_pif[`APCI_NUM_LANES]();

parameter RANDOM_TX_POLARITY = 1;

`ifdef APCI_NEW_PHY
    wire [`APCI_NUM_LANES-1:0] tx_data, tx_datan, rx_data, rx_datan;
    wire clkreq_n; // optional for L1 PM Substates

//--------------------------------INTEL - AVERY integration------------------------------------
	assign  tx_data[0] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out0 ;
	assign  tx_data[1] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out1 ;
	assign  tx_data[2] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out2 ;
	assign  tx_data[3] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out3 ;
	assign  tx_data[4] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out4 ;
	assign  tx_data[5] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out5 ;
	assign  tx_data[6] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out6 ;
	assign  tx_data[7] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out7 ;
	assign  tx_data[8] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out8 ;
	assign  tx_data[9] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out9 ;
	assign  tx_data[10] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out10 ;
	assign  tx_data[11] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out11 ;
	assign  tx_data[12] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out12 ;
	assign  tx_data[13] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out13 ;
	assign  tx_data[14] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out14 ;
	assign  tx_data[15] = ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out15 ;
	assign  tx_datan[0] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out0 ;
	assign  tx_datan[1] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out1 ;
	assign  tx_datan[2] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out2 ;
	assign  tx_datan[3] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out3 ;
	assign  tx_datan[4] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out4 ;
	assign  tx_datan[5] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out5 ;
	assign  tx_datan[6] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out6 ;
	assign  tx_datan[7] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out7 ;
	assign  tx_datan[8] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out8 ;
	assign  tx_datan[9] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out9 ;
	assign  tx_datan[10] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out10 ;
	assign  tx_datan[11] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out11 ;
	assign  tx_datan[12] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out12 ;
	assign  tx_datan[13] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out13 ;
	assign  tx_datan[14] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out14 ;
	assign  tx_datan[15] = ~ep_g3x16_ast_tb.ep_g3x16_ast_inst_xcvr_tx_out15 ;

	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in0= rx_data[0]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in1= rx_data[1]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in2= rx_data[2]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in3= rx_data[3]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in4= rx_data[4]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in5= rx_data[5]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in6= rx_data[6]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in7= rx_data[7]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in8= rx_data[8]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in9= rx_data[9]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in10= rx_data[10]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in11= rx_data[11]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in12= rx_data[12]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in13= rx_data[13]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in14= rx_data[14]; 
	assign ep_g3x16_ast_tb.dut_pcie_tb_hip_serial_rx_in15= rx_data[15]; 



//--------------------------------INTEL - AVERY integration------------------------------------

    apci_phy #(
	.RANDOM_TX_POLARITY(RANDOM_TX_POLARITY),
	.COMMON_CLOCK    (`APCI_COMMON_CLOCK),
	.NUM_LANES       (`APCI_NUM_LANES),
	.GENERATE_REF_CLK(0),  // 0 to disable reference clock at rc_pif[0].Clk
	.GEN1_DATA_WIDTH (GEN1_W  ), 
	.GEN2_DATA_WIDTH (GEN2_W  ),
	.GEN3_DATA_WIDTH (GEN3_W  ),
	.GEN4_DATA_WIDTH (GEN4_W  ), 
	.GEN1_CLOCK_RATE (GEN1_CLK),
	.GEN2_CLOCK_RATE (GEN2_CLK),  //  1: 125, 2: 250 Mhz, 3: 500Mhs
	.GEN3_CLOCK_RATE (GEN3_CLK),
	.GEN4_CLOCK_RATE (GEN4_CLK)
    ) rc_phy(
	.pifs     (rc_pif),
	.txp      (rx_data),
	.txn      (rx_datan),
	.rxp      (tx_data),
	.rxn      (tx_datan),
	.clkreq_n (clkreq_n)
    );

`else
    apci_mpipe_box #(
	.COMMON_CLOCK      (`APCI_COMMON_CLOCK),
	.A_NUM_LANES       (`APCI_NUM_LANES),
	.RANDOM_TX_POLARITY(RANDOM_TX_POLARITY),
	.A_GEN1_DATA_WIDTH (GEN1_W  ), 
	.A_GEN2_DATA_WIDTH (GEN2_W  ),
	.A_GEN3_DATA_WIDTH (GEN3_W  ),
	.A_GEN4_DATA_WIDTH (GEN4_W  ), 
	.A_GEN1_CLOCK_RATE (GEN1_CLK),
	.A_GEN2_CLOCK_RATE (GEN2_CLK),  //  1: 125, 2: 250 Mhz, 3: 500Mhs
	.A_GEN3_CLOCK_RATE (GEN3_CLK),
	.A_GEN4_CLOCK_RATE (GEN4_CLK),

    `ifdef APCI_USE_VENDOR0
	.B_VENDOR0         (1),
    `endif
	.B_NUM_LANES       (`APCI_NUM_LANES),
	.B_GEN1_DATA_WIDTH (GEN1_W  ), 
	.B_GEN2_DATA_WIDTH (GEN2_W  ), 
	.B_GEN3_DATA_WIDTH (GEN3_W  ), 
	.B_GEN4_DATA_WIDTH (GEN4_W  ), 
	.B_GEN1_CLOCK_RATE (GEN1_CLK),
	.B_GEN2_CLOCK_RATE (GEN2_CLK), 
	.B_GEN3_CLOCK_RATE (GEN3_CLK),
	.B_GEN4_CLOCK_RATE (GEN4_CLK) 
    ) mpipe_box(
	rc_pif,
	ep_pif
    );


initial begin
#1000ps;
#10000ps;
    for (int i=0; i<`APCI_NUM_LANES; i++) begin
       mpipe_box.set_timing("TxDetect_to_PhyStatus", i, 200, 0);
       mpipe_box.set_timing("TxDetect_to_PhyStatus", i, 200, 1);
       //mpipe_box.set_timing("Rate_to_PhyStatus", i, 50, 0);  // Need to be asserted after de-assert of dut_pcie_tb_hip_pipe_sim_pipe_mask_tx_pll_lock.
       //mpipe_box.set_timing("Rate_to_PhyStatus", i, 50, 1);  
    end
end

`endif

`ifdef AVERY_UVM
    `define APCI_UVM_NO_START_BFM
    `include "apci_uvm_rcep_pkg.svh"
    initial begin
	wait (rc != null);
	rc.set("start_bfm");
    end
`else

initial begin
    rc  = new("rc",  null, APCI_DEVICE_rc, 1);

    #10ps
    rc.assign_vi (0, rc_pif);
    rc.cfg_info.recov_equal_timeout_32 = 50us; 
    rc.cfg_info.recov_rcvrlock_timeout = 15us;
    rc.cfg_info.speed_sup = 3;  // default speed to Gen3
    rc.cfg_info.disabled_ts1_tx_cnt = 32;
	
    rc.set("start_bfm", 1);
    rc.wait_event("bfm_started");
    // rc.port_set_tracker(-1, "cfg" , 1);
    rc.port_set_tracker(-1, "tl" , 1);
    rc.port_set_tracker(-1, "dll", 1);
    rc.port_set_tracker(-1, "phy", 1);
	
    rc.set("auto_speedup",       1); //  Always speed up, DUT will request the speed up as well
    rc.set("skip_equal_phase23", 1); //  Always skip equalization phase 2/3, faster

    rc.log.set_severity_by_id(APCI4_2_2_3_3n22, AVY_WARNING);
    rc.log.set_severity_by_id(APCI4_2_4_2n20,  AVY_WARNING);
    rc.log.set_severity_by_id(APCI4_2_2_3_3n13,  AVY_WARNING);
end
`endif

task automatic start_test(apci_testcase_base test);
    apci_pkg_test::apci_test_select(test.test_name);
    // !! Note: user shall not put any delays inside this task !!
    // Otherwise, pre_bfm_started() could be compromised.
    fork
        begin
            wait (rc != null);
        end
        begin
            repeat(10) #100us $display("%m still waiting for rc assigned");
            wait(0);
        end
    join_any
    disable fork;
    test.add_rc(rc);
`ifdef APCI_DUT_RC
    test.add_rc_app_bfm(rc);   // to run DUT0-RC test
    test.add_dut1_bfm(rc);     // to run DUT1-RC test
`else	
    test.add_bfm(rc);
    test.add_rc_app_bfm(rc); 
`ifdef APCI_BACKEND_BFM
    // test.add_dut1_bfm(app_ep);   // to run DUT1-EP tests
`endif
`endif
    if (rc && rc.get("bfm_started"))
	test_log.usage("RC shall not be started yet");
`ifdef APCI_NEW_PHY
    test_info.serial_phy = 1;
`else
    test_info.serial_phy = 0;
`endif
    test_info.opt_checks.framing_err_8b10b = 1;
    test_info.opt_checks.framing_err_128b = 1;
    test_info.opt_checks.infer_ei_L0 = 1;

    test.run();
endtask

initial begin
    int start_time=0;
    int end_time=0;

    $timeformat(-9, 3, "ns", 8);                                                                                                                
`ifdef APCI_DUMP_VCD
    $dumpfile("apci_top.vcd");
    $dumpvars(0, ep_g3x16_ast_tb);
    $dumpon;
`endif
`ifdef APCI_DUMP_NC
    // need compilation arg " +access+r "
    $shm_open("ep_g3x16_ast_tb.shm");
    $shm_probe(ep_g3x16_ast_tb, "AMCTF");
`endif
`ifdef APCI_DUMP_VPD // +define+APCI_DUMP_VPD -debug_pp
    // may need -debug_pp argument
    if ($value$plusargs("dump_start=%d", start_time)) begin
    #(start_time);
    end
    $vcdplusfile("apci_top.vpd");
    $vcdpluson(0, ep_g3x16_ast_tb);
    if ($value$plusargs("dump_end=%d", end_time)) begin
    #(end_time - start_time);
    $vcdplusflush;
    $vcdplusoff;
    end
`endif
`ifdef APCI_DUMP_WLF
    $wlfdumpvars(0, ep_g3x16_ast_tb);
`endif
`ifdef APCI_DUMP_FSDB
    // Verdi path and PLI should be set and compiled correctly
    $fsdbDumpfile("apci_top.fsdb");
    $fsdbDumpvars(0, ep_g3x16_ast_tb);
    $fsdbDumpon;
`endif
end


reg         dut_pcie_tb_npor_npor_g;               
reg         dut_pcie_tb_npor_pin_perst_g;         
reg         dut_pcie_tb_hip_ctrl_simu_mode_pipe_g;
reg         dut_pcie_tb_refclk_clk_g;
reg  [66:0] dut_pcie_tb_hip_ctrl_test_in_g; 

assign  ep_g3x16_ast_tb.dut_pcie_tb_npor_npor                  = dut_pcie_tb_npor_npor_g;               
assign  ep_g3x16_ast_tb.dut_pcie_tb_npor_pin_perst             = dut_pcie_tb_npor_pin_perst_g;         
assign  ep_g3x16_ast_tb.dut_pcie_tb_hip_ctrl_simu_mode_pipe    = dut_pcie_tb_hip_ctrl_simu_mode_pipe_g;
assign  ep_g3x16_ast_tb.dut_pcie_tb_refclk_clk                 = dut_pcie_tb_refclk_clk_g;
assign  ep_g3x16_ast_tb.dut_pcie_tb_hip_ctrl_test_in           = dut_pcie_tb_hip_ctrl_test_in_g; 

initial begin // initialize S10 GEN3x16 RTL reset/refclk/pipemode 
   #10ps;
    //reset DUT as well
    $display("AVERY_TB: ***************** Detected Fundamental ( Cold/ Warm) Reset, Resetting DUT ********************");
    dut_pcie_tb_refclk_clk_g = 0;
    dut_pcie_tb_npor_npor_g = 1;
    dut_pcie_tb_npor_pin_perst_g = 1;
`ifdef APCI_NEW_PHY
    dut_pcie_tb_hip_ctrl_simu_mode_pipe_g =0; //SERIAL MODE
    $display("AVERY_TB: ***************** Running in SERIAL MODE ********************");
`else
    dut_pcie_tb_hip_pipe_sim_pipe_mask_tx_pll_lock_g = 0;
    dut_pcie_tb_hip_ctrl_simu_mode_pipe_g =1; //PIPE MODE
    $display("AVERY_TB: ***************** Running in PIPE MODE ********************");
`endif
    dut_pcie_tb_hip_ctrl_test_in_g = 32'h0000_0201;
    #1000ps;
    dut_pcie_tb_npor_npor_g = 0;
    dut_pcie_tb_npor_pin_perst_g =0;
    #203000ps;
    dut_pcie_tb_npor_npor_g = 1;
    dut_pcie_tb_npor_pin_perst_g =1;
        
`ifdef APCI_NEW_PHY
    ep_pif[0].Reset_ = 1;
`else
    pcie_reset_ = 1;
`endif
end

initial begin
	forever begin 
		#10ps;
		rc.wait_event("bfm_started");
		rc.wait_event("fundamental_reset_active");
		//reset DUT as well
		$display("AVERY_TB: ***************** Detected Fundamental ( Cold/ Warm) Reset, Resetting DUT ********************");
		dut_pcie_tb_refclk_clk_g = 0;
		dut_pcie_tb_npor_npor_g = 1;
		dut_pcie_tb_npor_pin_perst_g = 1;
		`ifdef APCI_NEW_PHY
			dut_pcie_tb_hip_ctrl_simu_mode_pipe_g =0; //SERIAL MODE
			$display("AVERY_TB: ***************** Running in SERIAL MODE ********************");
		`else
			dut_pcie_tb_hip_ctrl_simu_mode_pipe_g =1; //PIPE MODE
			$display("AVERY_TB: ***************** Running in PIPE MODE ********************");
		`endif
		dut_pcie_tb_hip_ctrl_test_in_g = 32'h0000_0201;
		#1000ps;
		dut_pcie_tb_npor_npor_g = 0;
		dut_pcie_tb_npor_pin_perst_g =0;
		#203000ps;
		dut_pcie_tb_npor_npor_g = 1;
		dut_pcie_tb_npor_pin_perst_g =1;
		rc.wait_event("fundamental_reset_done");
			
		`ifdef APCI_NEW_PHY
		    ep_pif[0].Reset_ = 1;
		`else
		    pcie_reset_ = 1;
		`endif
	end
end


always begin
    if(dut_pcie_tb_npor_pin_perst_g == 1) begin
        dut_pcie_tb_refclk_clk_g = ~dut_pcie_tb_refclk_clk_g;
        #5000ps;
    end else begin
        dut_pcie_tb_refclk_clk_g = 0;
        #5000ps;
    end
end

final begin
    if (rc)
	rc.my_report("pending_trans");
end


/*	Example shows how to use apci_transaction to do memory transfer.  */
class mem_tr_test extends apci_testcase_base;
    function new();
	super.new("mem_tr_test");
    endfunction

    virtual task test_body();
	apci_device_mgr  mgrs[$];
	apci_transaction tr, all_trs[$];
	apci_bar_t       mbar[$];

	// wait for all devices enumerated
	rc.collect_devices(-1, mgrs); 

	// find a memory BAR in the endpoints
	foreach (mgrs[i])  begin
	    if (mgrs[i].dev_type inside {APCI_DEVICE_ep, APCI_DEVICE_legacy_ep}) begin
		foreach (mgrs[i].finfs[j]) begin
		    apci_func_info func = mgrs[i].finfs[j];
		    if (func.mem_ranges.size > 0)
			mbar.push_back(func.mem_ranges[0]);
		end
	    end
	end
	if (mbar.size == 0) begin
	    test_not_applicable = 1;
	    test_log.info("No memory BAR found in endpoint device");
	    return;
	end

	// 1 memory write followed by 1 loop back mem read transactions. The addresses are always aligned at a DWORD by default.
	foreach(mbar[i]) begin
	    test_log.info($psprintf("Pick one of the bars %s", apci_sprint_bar(mbar[i])));
		// 1 mem write
		tr = new();
		ok = tr.randomize() with {
		    kind == APCI_TRANS_mem;
			is_write == 1;
		    addr              ==  mbar[i].base;
		    length == 1;  //1DW transaction for example test
		    proc_hint == 0;
		};
		assert(ok) else test_log.fatal("randomization failed");
		if (tr.is_write) begin
		    int k = $random;
		    repeat(tr.length) 
			    tr.payload.push_back(k++);
		end
		// test_log.info(tr.sprint(3));
		rc.post_transaction(tr);
	    all_trs.push_back(tr);
		
		tr = all_trs[0];
		tr.wait_done(1ms, "from mem_tr_test");
		test_log.info(tr.sprint(3));
		if (tr.err_code != apci_transaction::OK) begin
		    test_log.info($psprintf("Transaction failed with %s", tr.err_code.name));
		    test_failed = 1;
		    return;
		end
		
		//loopback mem read
		tr = new();
		ok = tr.randomize() with {
		    kind == APCI_TRANS_mem;
			is_write == 0;
		    addr              == mbar[i].base;
		    length == 1;  //1DW transaction for example test
		    proc_hint == 0;
		};
		assert(ok) else test_log.fatal("randomization failed");
		if (tr.is_write) begin
		    int k = $random;
		    repeat(tr.length) 
			    tr.payload.push_back(k++);
		end
		// test_log.info(tr.sprint(3));
		rc.post_transaction(tr);
	    all_trs.push_back(tr);
		
		tr = all_trs[1];
		tr.wait_done(1ms, "from mem_tr_test");
		test_log.info(tr.sprint(3));
		if (tr.err_code != apci_transaction::OK) begin
		    test_log.info($psprintf("Transaction failed with %s", tr.err_code.name));
		    test_failed = 1;
		    return;
		end
	end
    endtask
endclass

initial begin
    mem_tr_test t;
    t = new();
    start_test(t);
	$finish();
end
