-- Copyright (C) 2009 - Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-------------------------------------------------------------------------------
--                                                                           --
-- Containing VHDL Model for the Atoms:                                      --
--                         cycloneiv_hssi_rx_pma                              --
--                         cycloneiv_hssi_tx_pma                              --
--                         cycloneiv_hssi_tx_pcs                              --
--                         cycloneiv_hssi_rx_pcs                              --
--                         cycloneiv_hssi_cmu                                 --
--                         cycloneiv_hssi_calibration_block                   --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_reg
--
-- Description : Simulation model for a simple DFF.
--               This is used for registering the enable inputs.
--               No timing, powers upto 0.
--
-------------------------------------------------------------------------------

LIBRARY IEEE, std;
USE ieee.std_logic_1164.all;
--USE ieee.std_logic_unsigned.all;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
use work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_tx_pma_sub_reg is
PORT (	q                       : OUT std_logic;
        clk                     : IN std_logic;
        ena                     : IN std_logic;
        d                       : IN std_logic;
        clrn                    : IN std_logic;
        prn                     : IN std_logic
);
ATTRIBUTE VITAL_LEVEL0 of cycloneiv_hssi_tx_pma_sub_reg : ENTITY is TRUE;
END cycloneiv_hssi_tx_pma_sub_reg;

ARCHITECTURE vital_cycloneiv_hssi_tx_pma_sub_reg of cycloneiv_hssi_tx_pma_sub_reg is
ATTRIBUTE VITAL_LEVEL0 of vital_cycloneiv_hssi_tx_pma_sub_reg : architecture is TRUE;
BEGIN
	PROCESS (clk, clrn, prn)
        BEGIN
        	if (prn = '0') then
                	q <= '1';
            	elsif (clrn = '0') then
                	q <= '0';
            	elsif (clk'event and clk = '1') then
                	if (ena = '1') then
                    		q <= d;
                	end if;
            	end if;
        END PROCESS;

END vital_cycloneiv_hssi_tx_pma_sub_reg;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_out_block
--
-- Description : Negative edge triggered register on the Tx output.
--               Also, optionally generates an identical/inverted output clock
--
-------------------------------------------------------------------------------

LIBRARY IEEE, std;
USE IEEE.std_logic_1164.all;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
USE work.cycloneiv_hssi_components.all;
USE std.textio.all;

ENTITY cycloneiv_hssi_tx_pma_sub_out_block is
GENERIC (	bypass_serializer          : String := "false";
              	invert_clock               : String := "false";
              	use_falling_clock_edge     : String := "false"
);

PORT (	 	clk                        : IN std_logic;
              	datain                     : IN std_logic;
              	devclrn                    : IN std_logic := '1';
              	devpor                     : IN std_logic := '1';
              	dataout                    : OUT std_logic
);

END cycloneiv_hssi_tx_pma_sub_out_block;

ARCHITECTURE vital_tx_out_block of cycloneiv_hssi_tx_pma_sub_out_block is
BEGIN

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
VITAL: PROCESS (clk, datain, devpor, devclrn)
BEGIN
	if (now = 0 ns) then
        	dataout <= '0';
        else
            	if (bypass_serializer = "false") then
                	if (use_falling_clock_edge = "false") then
                    		dataout <= datain;
                	end if;

                	if (clk'event and clk = '0') then
                    		if (use_falling_clock_edge = "true") then
                        		dataout <= datain;
                    		end if;
                	end if;
            	else
                	if (invert_clock = "false") then
                    		dataout <= clk;
                	else
                    		dataout <= NOT (clk);
                	end if;

            	end if;
        end if;

        ----------------------
        --  Path Delay Section
        ----------------------
END PROCESS;
END vital_tx_out_block;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_parallel_register
--
-- Description : Register for the 10 data input channels of the cycloneiv 
--               LVDS Tx
--
-------------------------------------------------------------------------------

LIBRARY IEEE, std;
USE IEEE.std_logic_1164.all;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
USE work.cycloneiv_hssi_components.all;
USE std.textio.all;

ENTITY cycloneiv_hssi_tx_pma_sub_parallel_register is
GENERIC (	channel_width                     : integer := 4
);

PORT (		clk                            : IN std_logic;
              	enable                         : IN std_logic;
              	datain                         : IN std_logic_vector(channel_width - 1 downto 0);
              	devclrn                        : IN std_logic := '1';
              	devpor                         : IN std_logic := '1';
              	dataout                        : OUT std_logic_vector(channel_width - 1 downto 0)
);

END cycloneiv_hssi_tx_pma_sub_parallel_register;

ARCHITECTURE vital_tx_reg of cycloneiv_hssi_tx_pma_sub_parallel_register is
BEGIN

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------

VITAL: PROCESS (clk, enable, datain, devpor, devclrn)
VARIABLE Tviol_datain_clk : std_ulogic := '0';
VARIABLE i : integer := 0;
VARIABLE dataout_tmp : std_logic_vector(channel_width - 1 downto 0);
BEGIN

	if (now = 0 ns) then
       		dataout_tmp := (OTHERS => '0');
        end if;

        ------------------------
        --  Timing Check Section
        ------------------------

        if ((devpor = '0') or (devclrn = '0')) then
        	dataout_tmp := (OTHERS => '0');
        else
        	if (clk'event and clk = '1') then
               		if (enable = '1') then
               			dataout_tmp := datain;
               		end if;
        	end if;
        end if;

        ----------------------
        --  Path Delay Section
        ----------------------
	dataout <= dataout_tmp;

END PROCESS;

END vital_tx_reg;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_ser
--
-- Description : Timing simulation model for the cycloneiv LVDS Tx WYSIWYG.
--               It instantiates the following sub-modules :
--               1) primitive DFFE
--               2) cycloneiv_hssi_tx_pma_sub_parallel_register and
--               3) cycloneiv_hssi_tx_pma_sub_out_block
--
-------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;
USE work.cycloneiv_hssi_tx_pma_sub_reg;
USE work.cycloneiv_hssi_tx_pma_sub_out_block;
USE work.cycloneiv_hssi_tx_pma_sub_parallel_register;

USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;

ENTITY cycloneiv_hssi_tx_pma_sub_ser is
GENERIC ( 	channel_width                    : integer := 8;
              	bypass_serializer                : String  := "false";
              	invert_clock                     : String  := "false";
              	use_falling_clock_edge           : String  := "false";
              	use_serial_data_input            : String  := "false";
              	use_post_dpa_serial_data_input   : String  := "false";
              	is_used_as_outclk              : String  := "false";      
              	tx_output_path_delay_engineering_bits : Integer  := -1;   
              	enable_dpaclk_to_lvdsout    : string := "off";    
              	preemphasis_setting              : integer := 0;
              	vod_setting                      : integer := 0;
              	differential_drive               : integer := 0;
              	lpm_type                         : string  := "cycloneiv_hssi_tx_pma_sub_ser"
);

PORT    ( 	clk0                     : IN std_logic;
              	cgb_pdb                  : IN std_logic;
	   	enable0                  : IN std_logic := '0';
              	datain                   : IN std_logic_vector(9 downto 0);
              	serialdatain             : IN std_logic := '0';
              	postdpaserialdatain      : IN std_logic := '0';
              	dpaclkin                 : IN std_logic := '0';
              	devclrn                  : IN std_logic := '1';
              	devpor                   : IN std_logic := '1';
              	dataout                  : OUT std_logic;
              	serialfdbkout            : OUT std_logic
);

END cycloneiv_hssi_tx_pma_sub_ser;

ARCHITECTURE vital_transmitter_atom of cycloneiv_hssi_tx_pma_sub_ser is

SIGNAL txload0 : std_logic;

SIGNAL dataout_buf      : std_logic;
SIGNAL dataout_wire     : std_logic;
SIGNAL dataout_tmp	: std_logic;
SIGNAL deven		: std_logic;
SIGNAL dodd	 	: std_logic;

SIGNAL shift_out_even	: std_logic;
SIGNAL shift_out_odd 	: std_logic;

SIGNAL shift_data_even	: std_logic_vector(channel_width/2 - 1 downto 0);
SIGNAL shift_data_odd	: std_logic_vector(channel_width/2 - 1 downto 0);

SIGNAL input_data_even 	: std_logic_vector(channel_width/2 - 1 downto 0);
SIGNAL input_data_odd 	: std_logic_vector(channel_width/2 - 1 downto 0);

SIGNAL datain_odd 	: std_logic_vector(channel_width/2 - 1 downto 0);
SIGNAL datain_even 	: std_logic_vector(channel_width/2 - 1 downto 0);

SIGNAL datain_odd_x10	: std_logic_vector(4 downto 0);
SIGNAL datain_odd_x8	: std_logic_vector(3 downto 0);

SIGNAL datain_even_x10	: std_logic_vector(4 downto 0);
SIGNAL datain_even_x8	: std_logic_vector(3 downto 0);

SIGNAL vcc : std_logic := '1';
SIGNAL tmp_dataout : std_logic;

COMPONENT cycloneiv_hssi_tx_pma_sub_parallel_register
GENERIC ( 	channel_width           : integer := 8
);

PORT (		clk                     : IN std_logic;
              	enable                  : IN std_logic;
              	datain                  : IN std_logic_vector(channel_width - 1 downto 0);
              	devclrn                 : IN std_logic := '1';
              	devpor                  : IN std_logic := '1';
              	dataout                 : OUT std_logic_vector(channel_width - 1 downto 0)
);

END COMPONENT;

COMPONENT cycloneiv_hssi_tx_pma_sub_out_block
GENERIC ( 	bypass_serializer        : String := "false";
              	invert_clock             : String := "false";
              	use_falling_clock_edge   : String := "false"
);

PORT    ( 	clk                      : IN std_logic;
              	datain                   : IN std_logic;
              	devclrn                  : IN std_logic := '1';
              	devpor                   : IN std_logic := '1';
              	dataout                  : OUT std_logic
);
END COMPONENT;

COMPONENT cycloneiv_hssi_tx_pma_sub_reg
PORT (		q                              :  OUT   STD_LOGIC := '0';
            	d                              :  IN    STD_LOGIC := '1';
            	clrn                           :  IN    STD_LOGIC := '1';
            	prn                            :  IN    STD_LOGIC := '1';
            	clk                            :  IN    STD_LOGIC := '0';
            	ena                            :  IN    STD_LOGIC := '1'
);
END COMPONENT;

BEGIN

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------

    	txload0_reg: cycloneiv_hssi_tx_pma_sub_reg
             	PORT MAP (	d    => enable0,
                       		clrn => vcc,
                       		prn  => vcc,
                       		ena  => vcc,
                       		clk  => clk0,
                       		q    => txload0
                      );

	input_data_odd <= (OTHERS => '0') WHEN ((devpor = '0') OR (devclrn = '0')) ELSE datain_odd;
	input_data_even <= (OTHERS => '0') WHEN ((devpor = '0') OR (devclrn = '0')) ELSE datain_even;


    	output_module_even: cycloneiv_hssi_tx_pma_sub_out_block
             	GENERIC MAP ( 	bypass_serializer => bypass_serializer,
                         	use_falling_clock_edge => use_falling_clock_edge,
                           	invert_clock => invert_clock)
             	PORT MAP    ( 	clk => clk0,
                           	datain => shift_out_even,
                           	dataout => deven,
                           	devclrn => devclrn,
                           	devpor => devpor
                         );

	output_module_odd: cycloneiv_hssi_tx_pma_sub_out_block
             	GENERIC MAP ( 	bypass_serializer => bypass_serializer,
                         	use_falling_clock_edge => use_falling_clock_edge,
                           	invert_clock => invert_clock)
             	PORT MAP    ( 	clk => clk0,
                           	datain => shift_out_odd,
                           	dataout => dodd,
                           	devclrn => devclrn,
                           	devpor => devpor
                         );

    VITAL: PROCESS (clk0, devclrn, devpor)
    VARIABLE i : integer := 0;
    BEGIN
        if (now = 0 ns) then
            shift_data_even <= (OTHERS => '0');
	    shift_data_odd <= (OTHERS => '0');
        end if;

        if ((devpor = '0') or (devclrn = '0')) then
            shift_data_even <= (OTHERS => '0');
	    shift_data_odd <= (OTHERS => '0');
        else
            if (bypass_serializer = "false") then
                if (clk0'event and clk0 = '1') then
                    if (txload0 = '1') then
                    		shift_data_even	<= input_data_even;
				shift_data_odd	<= input_data_odd;
		    else
		    		for i in (channel_width/2 - 1) downto 1 loop
                        		shift_data_even(i) <= shift_data_even(i - 1); -- here!
					shift_data_odd(i) <= shift_data_odd(i - 1);
                    		end loop;
		    end if;
                end if;
            end if;
        end if;

    END PROCESS;

    shift_out_even <= shift_data_even(channel_width/2 - 1);
    shift_out_odd <= shift_data_odd(channel_width/2 - 1);

    datain_even <= datain_even_x10 when (channel_width = 10) else datain_even_x8;
    datain_odd  <= datain_odd_x10 when (channel_width = 10) else datain_odd_x8;

    datain_even_x10 	<= datain(0) & datain(2) & datain(4) & datain(6) & datain(8);
    datain_even_x8 	<= datain(0) & datain(2) & datain(4) & datain(6);
    datain_odd_x10 	<= datain(1) & datain(3) & datain(5) & datain(7) & datain(9);
    datain_odd_x8 	<= datain(1) & datain(3) & datain(5) & datain(7);

    dataout_tmp <= deven when (clk0 = '1') else dodd;

    PROCESS (serialdatain, postdpaserialdatain, dpaclkin, dataout_tmp)
    BEGIN
        if (serialdatain'event and use_serial_data_input = "true") then
            dataout_wire <= serialdatain;
        elsif (postdpaserialdatain'event and use_post_dpa_serial_data_input = "true") then
            dataout_wire <= postdpaserialdatain;
        elsif (dpaclkin'event and enable_dpaclk_to_lvdsout = "on") then
            dataout_wire <= dpaclkin;
        else
            dataout_wire <= dataout_tmp;
        end if;

    END PROCESS;

    dataout_buf 	<= '0' when (cgb_pdb = '0') else dataout_wire;

    dataout 		<= dataout_buf;
    serialfdbkout 	<= dataout_buf;

end vital_transmitter_atom;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2
--
-- Description : Module to halve the frequency or double the period of the
--               input clock by 2.
--
-------------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;


ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 IS
    PORT (
        clk                     : IN std_logic;   
        reset_n                 : IN std_logic;   
        clkout                  : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2;

ARCHITECTURE div_by_2_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 IS


    SIGNAL next_val                 :  std_logic := '0';   
    SIGNAL clkout_xhdl1             :  std_logic := '0';   

BEGIN
    clkout <= clkout_xhdl1;

    -- state definition
    
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (reset_n'EVENT AND reset_n = '0');
        IF (NOT reset_n = '1') THEN
            clkout_xhdl1 <= '0';    
        ELSE
            clkout_xhdl1 <= next_val;    
        END IF;
    END PROCESS;
    next_val <= NOT clkout_xhdl1 ;

END div_by_2_arch;
-- div_by_2

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;


ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 IS
    PORT (
        clk                     : IN std_logic;   
        reset_n                 : IN std_logic;   
        clkout                  : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2;

ARCHITECTURE div_by_2_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 IS


    SIGNAL next_val                 :  std_logic := '0';   
    SIGNAL clkout_xhdl1             :  std_logic := '0';   

BEGIN
    clkout <= clkout_xhdl1;

    -- state definition
    
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (reset_n'EVENT AND reset_n = '0');
        IF (NOT reset_n = '1') THEN
            clkout_xhdl1 <= '0';    
        ELSE
            clkout_xhdl1 <= next_val;    
        END IF;
    END PROCESS;
    next_val <= NOT clkout_xhdl1 ;

END div_by_2_arch;
-- div_by_2

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen
--
-- Description : Network of byn clock generators; where n = 2, 4, 8
--               Instantiates tx_rx_det_div_by_2   
--
-------------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2;

ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen IS
    PORT (
        clk                     : IN std_logic;   
        reset_n                 : IN std_logic;   
        clkout                  : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen;

ARCHITECTURE clk_gen_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen IS

    COMPONENT cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2
        PORT (
            clk                     : IN  std_logic;
            reset_n                 : IN  std_logic;
            clkout                  : OUT std_logic);
    END COMPONENT;


    SIGNAL clk8m                    :  std_logic;   
    SIGNAL clk4m                    :  std_logic;   
    SIGNAL clk2m                    :  std_logic;   
    SIGNAL clkout_xhdl1             :  std_logic;   

BEGIN
    clkout <= clkout_xhdl1;
    div_1 : cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 
        PORT MAP (
            clk => clk,
            reset_n => reset_n,
            clkout => clk8m);   
    
    div_2 : cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 
        PORT MAP (
            clk => clk8m,
            reset_n => reset_n,
            clkout => clk4m);   
    
    div_3 : cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 
        PORT MAP (
            clk => clk4m,
            reset_n => reset_n,
            clkout => clk2m);   
    
    div_4 : cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 
        PORT MAP (
            clk => clk2m,
            reset_n => reset_n,
            clkout => clkout_xhdl1);   
    

END clk_gen_arch;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync
--
-- Description : Delays input data by 1 clock cycle 
--
-------------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync IS
    PORT (
        clk                     : IN std_logic;   
        reset_n                 : IN std_logic;   
        rcv_det                 : IN std_logic;   
        rcv_det_out             : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync;

ARCHITECTURE rcv_det_sync_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync IS


    SIGNAL rcv_det_mid              :  std_logic;   
    SIGNAL rcv_det_out_xhdl1        :  std_logic;   

BEGIN
    rcv_det_out <= rcv_det_out_xhdl1;

    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (reset_n'EVENT AND reset_n = '0');
        IF (NOT reset_n = '1') THEN
            rcv_det_out_xhdl1 <= '0';    
            rcv_det_mid <= '0';    
        ELSE
            rcv_det_out_xhdl1 <= rcv_det_mid;    
            rcv_det_mid <= rcv_det;    
        END IF;
    END PROCESS;

END rcv_det_sync_arch;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm
--
-- Description : State machine to generate SIGNALs/ indications for 
-- 		 rcv_found, next_rcv_found and detect_valid 
--
-------------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm IS
    PORT (
        clk                     : IN std_logic;   
        reset_n                 : IN std_logic;   
        com_pass                : IN std_logic;   
        probe_pass              : IN std_logic;   
        det_on                  : OUT std_logic;   
        detect_valid            : OUT std_logic;   
        rcv_found               : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm;

ARCHITECTURE rcv_det_fsm_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm IS


    SIGNAL state                    :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL nextstate                :  std_logic_vector(2 DOWNTO 0) := "001";   
    SIGNAL next_rcv_found           :  std_logic;   
    SIGNAL fake_rcv_present         :  std_logic;   
    -- state definition
    CONSTANT  reset                 :  std_logic_vector(2 DOWNTO 0) := "000";    
    CONSTANT  wake                  :  std_logic_vector(2 DOWNTO 0) := "001";    
    CONSTANT  state_1               :  std_logic_vector(2 DOWNTO 0) := "011";    
    CONSTANT  state_2               :  std_logic_vector(2 DOWNTO 0) := "101";    
    CONSTANT  hold                  :  std_logic_vector(2 DOWNTO 0) := "100";    
    SIGNAL rcv_found_xhdl1          :  std_logic;   
    SIGNAL det_on_xhdl2             :  std_logic;   
    SIGNAL detect_valid_xhdl3       :  std_logic;   

BEGIN
    rcv_found <= rcv_found_xhdl1;
    det_on <= det_on_xhdl2;
    detect_valid <= detect_valid_xhdl3;

    PROCESS
        VARIABLE xhdl_initial : BOOLEAN := TRUE;
    BEGIN
        IF (xhdl_initial) THEN
            fake_rcv_present <= '1';    
            xhdl_initial := FALSE;
        ELSE
            WAIT;
        END IF;
    END PROCESS;

    -- State logic and fsm
    
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (reset_n'EVENT AND reset_n = '0');
        IF (NOT reset_n = '1') THEN
            state <= reset;    
        ELSE
            state <= nextstate;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL state'EVENT OR com_pass'EVENT;
        CASE state IS
            WHen reset =>
                        nextstate <= wake;    
            WHen wake =>
                        IF (com_pass = '1') THEN
                            nextstate <= state_1;    
                        ELSE
                            nextstate <= wake;    
                        END IF;
            WHen state_1 =>
                        nextstate <= state_2;    
            WHen state_2 =>
                        nextstate <= hold;    
            WHen hold =>
                        nextstate <= hold;    
            WHen OTHERS  =>
                        nextstate <= reset;    
            
        END CASE;
        -- case(state)
        
        
    END PROCESS;

    -- always @ (state or com_pass)
    -- Output logic
    
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (reset_n'EVENT AND reset_n = '0');
        IF (NOT reset_n = '1') THEN
            rcv_found_xhdl1 <= '0';    
        ELSE
            rcv_found_xhdl1 <= next_rcv_found;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL nextstate'EVENT OR probe_pass'EVENT OR fake_rcv_present'EVENT;
        IF ( (nextstate = state_2) AND (probe_pass = '0') AND (fake_rcv_present = '1') ) THEN
            -- probe pass goes up slow -> there is rx 
            
            next_rcv_found <= '1';    
        ELSE
            IF ((nextstate = hold) AND (fake_rcv_present = '1')) THEN
                next_rcv_found <= rcv_found_xhdl1;    
            ELSE
                -- probe pass goes up fast -> no rx
                
                next_rcv_found <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- there is no rcv_det_syn
    
    PROCESS
    BEGIN
        WAIT UNTIL state'EVENT;
        IF (state = reset) THEN
            det_on_xhdl2 <= '0';    
        ELSE
            det_on_xhdl2 <= '1';    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL state'EVENT;
        IF (state = hold) THEN
            detect_valid_xhdl3 <= '1';    
        ELSE
            detect_valid_xhdl3 <= '0';    
        END IF;
    END PROCESS;

END rcv_det_fsm_arch;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control
--
-- Description : Module to hook up the fsm and detect sync block 
--
-------------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm;
USE WORK.cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync;

ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control IS
    PORT (
        clk                     : IN std_logic;   
        rcv_det_en              : IN std_logic;   
        rcv_det_pdb             : IN std_logic;   
        com_pass                : IN std_logic;   
        probe_pass              : IN std_logic;   
        det_on                  : OUT std_logic;   
        detect_valid            : OUT std_logic;   
        rcv_found               : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control;

ARCHITECTURE rcv_det_control_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control IS

    COMPONENT cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm
        PORT (
            clk                     : IN  std_logic;
            reset_n                 : IN  std_logic;
            com_pass                : IN  std_logic;
            probe_pass              : IN  std_logic;
            det_on                  : OUT std_logic;
            detect_valid            : OUT std_logic;
            rcv_found               : OUT std_logic);
    END COMPONENT;

    COMPONENT cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync
        PORT (
            clk                     : IN  std_logic;
            reset_n                 : IN  std_logic;
            rcv_det                 : IN  std_logic;
            rcv_det_out             : OUT std_logic);
    END COMPONENT;


    SIGNAL rcv_det_syn              :  std_logic;   
    SIGNAL det_on_xhdl1             :  std_logic;   
    SIGNAL detect_valid_xhdl2       :  std_logic;   
    SIGNAL rcv_found_xhdl3          :  std_logic;   

BEGIN
    det_on <= det_on_xhdl1;
    detect_valid <= detect_valid_xhdl2;
    rcv_found <= rcv_found_xhdl3;
    Xrcv_det_sync : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync 
        PORT MAP (
            clk => clk,
            reset_n => rcv_det_pdb,
            rcv_det => rcv_det_en,
            rcv_det_out => rcv_det_syn);   
    
    Xrcv_det_fsm : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm 
        PORT MAP (
            clk => clk,
            reset_n => rcv_det_syn,
            com_pass => com_pass,
            probe_pass => probe_pass,
            det_on => det_on_xhdl1,
            detect_valid => detect_valid_xhdl2,
            rcv_found => rcv_found_xhdl3);   
    

END rcv_det_control_arch;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital
--
-- Description : Digital part of the receiver detection  
--
-------------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen;
USE WORK.cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control;

ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital IS
    PORT (
        oscclk                  : IN std_logic;   
        rcv_det_pdb             : IN std_logic;   
        rcv_det_en              : IN std_logic;   
        com_pass                : IN std_logic;   
        probe_pass              : IN std_logic;   
        det_on                  : OUT std_logic;   
        detect_valid            : OUT std_logic;   
        rcv_found               : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital;

ARCHITECTURE rcv_det_digital_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital IS

    COMPONENT cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen
        PORT (
            clk                     : IN  std_logic;
            reset_n                 : IN  std_logic;
            clkout                  : OUT std_logic);
    END COMPONENT;

    COMPONENT cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control
        PORT (
            clk                     : IN  std_logic;
            rcv_det_en              : IN  std_logic;
            rcv_det_pdb             : IN  std_logic;
            com_pass                : IN  std_logic;
            probe_pass              : IN  std_logic;
            det_on                  : OUT std_logic;
            detect_valid            : OUT std_logic;
            rcv_found               : OUT std_logic);
    END COMPONENT;


    SIGNAL clk                      :  std_logic;   
    SIGNAL det_on_xhdl1             :  std_logic;   
    SIGNAL rcv_found_xhdl2          :  std_logic;   
    SIGNAL detect_valid_xhdl3       :  std_logic;   

BEGIN
    det_on <= det_on_xhdl1;
    rcv_found <= rcv_found_xhdl2;
    detect_valid <= detect_valid_xhdl3;
    Xclk_Gen : cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen 
        PORT MAP (
            clk => oscclk,
            reset_n => rcv_det_pdb,
            clkout => clk);   
    
    Xrcv_det_CTRL : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control 
        PORT MAP (
            clk => clk,
            rcv_det_en => rcv_det_en,
            rcv_det_pdb => rcv_det_pdb,
            com_pass => com_pass,
            probe_pass => probe_pass,
            det_on => det_on_xhdl1,
            detect_valid => detect_valid_xhdl3,
            rcv_found => rcv_found_xhdl2);   
    

END rcv_det_digital_arch;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det
--
-- Description : Receiver detect
--
-------------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital;

ENTITY cycloneiv_hssi_tx_pma_sub_tx_rx_det IS
    PORT (
        rx_det_pdb              : IN std_logic;   
        clk15m                  : IN std_logic;   
        tx_det_rx               : IN std_logic;   
        rx_found                : OUT std_logic;   
        rx_det_valid            : OUT std_logic);   
END cycloneiv_hssi_tx_pma_sub_tx_rx_det;

ARCHITECTURE tx_rx_det_arch OF cycloneiv_hssi_tx_pma_sub_tx_rx_det IS

    CONSTANT xhdl_timescale         : time := 1 ps;

    COMPONENT cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital
        PORT (
            oscclk                  : IN  std_logic;
            rcv_det_pdb             : IN  std_logic;
            rcv_det_en              : IN  std_logic;
            com_pass                : IN  std_logic;
            probe_pass              : IN  std_logic;
            det_on                  : OUT std_logic;
            detect_valid            : OUT std_logic;
            rcv_found               : OUT std_logic);
    END COMPONENT;


    SIGNAL com_pass                 :  std_logic;   
    SIGNAL probe_pass               :  std_logic;   
    SIGNAL det_on                   :  std_logic;   
    CONSTANT  rx_exist              :  std_logic := '1';    
    SIGNAL rx_found_xhdl1           :  std_logic;   
    SIGNAL rx_det_valid_xhdl2       :  std_logic;   

BEGIN
    rx_found <= rx_found_xhdl1;
    rx_det_valid <= rx_det_valid_xhdl2;
    com_pass <= det_on  AFTER 100000 * xhdl_timescale;
    probe_pass <= NOT rx_exist  AFTER 100000 * xhdl_timescale;
    Xrcv_det_digital : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital 
        PORT MAP (
            oscclk => clk15m,
            rcv_det_pdb => rx_det_pdb,
            rcv_det_en => tx_det_rx,
            com_pass => com_pass,
            probe_pass => probe_pass,
            det_on => det_on,
            detect_valid => rx_det_valid_xhdl2,
            rcv_found => rx_found_xhdl1);   
    
END tx_rx_det_arch;
-- ***********************************************************
-- This WYSIWYG atom header was automatically generated by the
-- Atmgen build tool. To change it, alter data stored in the 
-- corresponding WYS file(s) in the tools-atmgen subdirectory.
-- ***********************************************************

-- *** Section 1 -- Header ***

-- -----------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_tx_pma
--
-- Description : DEV_FAMILY_cycloneiv cycloneiv_hssi_tx_pma VHDL simulation model
--
-- -----------------------------------------------------------

-- *** End of Section 1 ***

-- *** Section 3 -- Module declaration ***

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
ENTITY cycloneiv_hssi_tx_pma IS
GENERIC (
          --  generic control parameters  --
	enable_diagnostic_loopback			: STRING := "false";
      	enable_reverse_serial_loopback			: STRING := "false";
      	enable_txclkout_loopback			: STRING := "false";
      	lpm_type                  			: STRING := "cycloneiv_hssi_tx_pma";
      	channel_number            			: INTEGER := 0;
      	common_mode               			: STRING := "0.65V";
      	dprio_config_mode         			: STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
      	logical_channel_address   			: INTEGER := 0;
      	preemp_tap_1              			: INTEGER := 0;
      	protocol_hint             			: STRING := "basic";
      	effective_data_rate                 : STRING := "unused";
      	rx_detect                 			: INTEGER := 0;
      	serialization_factor      			: INTEGER := 8;
      	slew_rate                 			: STRING := "low";
      	termination               			: STRING := "OCT 100 Ohms";
      	use_external_termination  			: STRING := "false";
      	use_rx_detect             			: STRING := "false";
      	vod_selection             			: INTEGER := 0
);
PORT (
	cgbpowerdn		: IN STD_LOGIC := '0';
	datain                  : IN STD_LOGIC_VECTOR(9 DOWNTO 0) := (others => '0');
      	detectrxpowerdown       : IN STD_LOGIC := '0';
      	diagnosticlpbkin 	: IN STD_LOGIC := '0';
      	dpriodisable            : IN STD_LOGIC := '1';
      	dprioin                 : IN STD_LOGIC_VECTOR(300 - 1 DOWNTO 0) := (others => '0');
      	fastrefclk0in           : IN STD_LOGIC := '0';
      	forceelecidle           : IN STD_LOGIC := '0';
      	powerdn                 : IN STD_LOGIC := '0';
      	refclk0in               : IN STD_LOGIC := '0';
      	refclk0inpulse          : IN STD_LOGIC := '0';
      	reverselpbkin		: IN STD_LOGIC := '0';
      	rxdetectclk             : IN STD_LOGIC := '0';
      	rxdetecten              : IN STD_LOGIC := '0';
      	txpmareset              : IN STD_LOGIC := '0';
      	clockout                : OUT STD_LOGIC;
      	dataout                 : OUT STD_LOGIC;
      	dprioout                : OUT STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);
      	rxdetectvalidout        : OUT STD_LOGIC;
      	rxfoundout              : OUT STD_LOGIC;
      	seriallpbkout		: OUT STD_LOGIC
);
END cycloneiv_hssi_tx_pma;

ARCHITECTURE trans OF cycloneiv_hssi_tx_pma IS
COMPONENT cycloneiv_hssi_tx_pma_sub_ser
GENERIC (
	channel_width             		: INTEGER := 8;
        bypass_serializer         		: STRING := "false";
        invert_clock              		: STRING := "false";
        use_falling_clock_edge    		: STRING := "false";
        use_serial_data_input     		: STRING := "false";
        use_post_dpa_serial_data_input 		: STRING := "false";
        is_used_as_outclk         		: STRING := "false";
        tx_output_path_delay_engineering_bits 	: INTEGER := -1;
        enable_dpaclk_to_lvdsout  		: STRING := "off";
        preemphasis_setting       		: INTEGER := 0;
        vod_setting               		: INTEGER := 0;
        differential_drive        		: INTEGER := 0;
        lpm_type                  		: STRING := "cycloneiv_hssi_tx_pma_sub_ser"
);
PORT (
        datain                    : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
        clk0                      : IN STD_LOGIC;
        cgb_pdb			  : IN STD_LOGIC; -- not in wys yet
	enable0                   : IN STD_LOGIC;
        serialdatain              : IN STD_LOGIC;
        postdpaserialdatain       : IN STD_LOGIC;
        devclrn                   : IN STD_LOGIC;
        devpor                    : IN STD_LOGIC;
        dpaclkin                  : IN STD_LOGIC;
        dataout                   : OUT STD_LOGIC;
        serialfdbkout             : OUT STD_LOGIC
);
END COMPONENT;

COMPONENT cycloneiv_hssi_tx_pma_sub_tx_rx_det
PORT (
	rx_det_pdb              : IN std_logic;   
        clk15m                  : IN std_logic;   
        tx_det_rx               : IN std_logic;   
        rx_found                : OUT std_logic;   
        rx_det_valid            : OUT std_logic
);   
END COMPONENT;   
   
-- Declare intermediate signals for referenced outputs
-- Buffers
SIGNAL dataout_buf		: STD_LOGIC;

-- Resets
SIGNAL txpma_rstb		: STD_LOGIC;
SIGNAL cgb_pdb			: STD_LOGIC;
SIGNAL tx_pdb			: STD_LOGIC;

-- Serializer
SIGNAL ser_dataout		: STD_LOGIC;

-- RX Detect
SIGNAL rxdet_in_rx_det_pdb	: STD_LOGIC;
SIGNAL rxdet_in_tx_det_rx	: STD_LOGIC;
SIGNAL rxdet_in_clk15m		: STD_LOGIC;
SIGNAL rxdet_fixclk_reg		: STD_LOGIC;
SIGNAL rxdet_out_rx_found	: STD_LOGIC;
SIGNAL rxdet_out_rx_det_valid	: STD_LOGIC;

-- ---------------------------------------------------------------------------
--  New DPRIO Begin 
-- ---------------------------------------------------------------------------

   -- Table28: PMA Per Channel TX Control Register 1 for Channel 0
   constant rpowdnt_TXPMA_IDX_0	: integer := 0;
   constant reserved_0_TB28_TXPMA_IDX_1	: integer := 1;
   constant reserved_0_TB28_TXPMA_IDX_2	: integer := 2;
   constant reserved_0_TB28_TXPMA_IDX_3	: integer := 3;
   constant reserved_0_TB28_TXPMA_IDX_4	: integer := 4;
   constant reserved_0_TB28_TXPMA_IDX_5	: integer := 5;
   constant reserved_0_TB28_TXPMA_IDX_6	: integer := 6;
   constant reserved_0_TB28_TXPMA_IDX_7	: integer := 7;
   constant reserved_0_TB28_TXPMA_IDX_8	: integer := 8;
   constant reserved_0_TB28_TXPMA_IDX_9	: integer := 9;
   constant reserved_0_TB28_TXPMA_IDX_10	: integer := 10;
   constant reserved_0_TB28_TXPMA_IDX_11	: integer := 11;
   constant reserved_0_TB28_TXPMA_IDX_12	: integer := 12;
   constant rvod_sel_non_pcie_TXPMA_IDX_0	: integer := 13;
   constant rvod_sel_non_pcie_TXPMA_IDX_1	: integer := 14;
   constant rvod_sel_non_pcie_TXPMA_IDX_2	: integer := 15;
   
   -- Table29: PMA Per Channel TX Control Register 2 for Channel 0
   constant reserved_0_TB29_TXPMA_IDX_0	: integer := 16;
   constant reserved_0_TB29_TXPMA_IDX_1	: integer := 17;
   constant reserved_0_TB29_TXPMA_IDX_2	: integer := 18;
   constant reserved_0_TB29_TXPMA_IDX_3	: integer := 19;
   constant reserved_0_TB29_TXPMA_IDX_4	: integer := 20;
   constant reserved_0_TB29_TXPMA_IDX_5	: integer := 21;
   constant reserved_0_TB29_TXPMA_IDX_6	: integer := 22;
   constant reserved_0_TB29_TXPMA_IDX_7	: integer := 23;
   constant reserved_0_TB29_TXPMA_IDX_8	: integer := 24;
   constant reserved_0_TB29_TXPMA_IDX_9	: integer := 25;
   constant reserved_0_TB29_TXPMA_IDX_10	: integer := 26;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_0	: integer := 27;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_1	: integer := 28;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_2	: integer := 29;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_3	: integer := 30;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_4	: integer := 31;
   
   -- Table30: PMA Per Channel TX Control Register 3 for Channel 0
   constant reserved_0_TB30_TXPMA_IDX_0	: integer := 32;
   constant reserved_0_TB30_TXPMA_IDX_1	: integer := 33;
   constant reserved_0_TB30_TXPMA_IDX_2	: integer := 34;
   constant reserved_0_TB30_TXPMA_IDX_3	: integer := 35;
   constant reserved_0_TB30_TXPMA_IDX_4	: integer := 36;
   constant reserved_0_TB30_TXPMA_IDX_5	: integer := 37;
   constant reserved_0_TB30_TXPMA_IDX_6	: integer := 38;
   constant reserved_0_TB30_TXPMA_IDX_7	: integer := 39;
   constant reserved_0_TB30_TXPMA_IDX_8	: integer := 40;
   constant reserved_0_TB30_TXPMA_IDX_9	: integer := 41;
   constant reserved_0_TB30_TXPMA_IDX_10	: integer := 42;
   constant reserved_0_TB30_TXPMA_IDX_11	: integer := 43;
   constant reserved_0_TB30_TXPMA_IDX_12	: integer := 44;
   constant reserved_0_TB30_TXPMA_IDX_13	: integer := 45;
   constant reserved_0_TB30_TXPMA_IDX_14	: integer := 46;
   constant reserved_0_TB30_TXPMA_IDX_15	: integer := 47;
   
   -- Table31: PMA Per Channel TX Control Register 4 for Channel 0
   constant rlowv_TXPMA_IDX_0	: integer := 48;
   constant rrx_det_TXPMA_IDX_0	: integer := 49;
   constant rrx_det_TXPMA_IDX_1	: integer := 50;
   constant reserved_0_TB31_TXPMA_IDX_3	: integer := 51;
   constant reserved_0_TB31_TXPMA_IDX_4	: integer := 52;
   constant rslew_TXPMA_IDX_0	: integer := 53;
   constant rslew_TXPMA_IDX_1	: integer := 54;
   constant rtx_lst_TXPMA_IDX_0	: integer := 55;
   constant rtx_lst_TXPMA_IDX_1	: integer := 56;
   constant rtx_lst_TXPMA_IDX_2	: integer := 57;
   constant rtx_lst_TXPMA_IDX_3	: integer := 58;
   constant rtx_vtt_TXPMA_IDX_0	: integer := 59;
   constant rtx_vtt_TXPMA_IDX_1	: integer := 60;
   constant rtx_term_sel_TXPMA_IDX_0	: integer := 61;
   constant rtx_term_sel_TXPMA_IDX_1	: integer := 62;
   constant rtx_term_sel_TXPMA_IDX_2	: integer := 63;
   
   -- Table32: PMA Per Channel TX Control Register 5 for Channel 0
   constant reserved_1_TB32_TXPMA_IDX_0	: integer := 64;
   constant reserved_1_TB32_TXPMA_IDX_1	: integer := 65;
   constant reserved_1_TB32_TXPMA_IDX_2	: integer := 66;
   constant reserved_1_TB32_TXPMA_IDX_3	: integer := 67;
   constant reserved_1_TB32_TXPMA_IDX_4	: integer := 68;
   constant reserved_1_TB32_TXPMA_IDX_5	: integer := 69;
   constant reserved_1_TB32_TXPMA_IDX_6	: integer := 70;
   constant reserved_1_TB32_TXPMA_IDX_7	: integer := 71;
   constant reserved_1_TB32_TXPMA_IDX_8	: integer := 72;
   constant reserved_1_TB32_TXPMA_IDX_9	: integer := 73;
   constant reserved_1_TB32_TXPMA_IDX_10	: integer := 74;
   constant rtx_ob_pdb_TXPMA_IDX_0	: integer := 75;
   constant reserved_0_TB32_TXPMA_IDX_0	: integer := 76;
   constant r_dft_sel_TXPMA_IDX_0	: integer := 77;
   constant r_dft_sel_TXPMA_IDX_1	: integer := 78;
   constant r_dft_sel_TXPMA_IDX_2	: integer := 79;
   
   -- Table33: PMA Per Channel TX Control Register 6 for Channel 0
   constant reserved_0_TB33_TXPMA_IDX_0	: integer := 80;
   constant reserved_0_TB33_TXPMA_IDX_1	: integer := 81;
   constant reserved_0_TB33_TXPMA_IDX_2	: integer := 82;
   constant reserved_0_TB33_TXPMA_IDX_3	: integer := 83;
   constant rtx_cgb_pdb_TXPMA_IDX_0	: integer := 84;
   constant reserved_0_TB33_TXPMA_IDX_5	: integer := 85;
   constant reserved_0_TB33_TXPMA_IDX_6	: integer := 86;
   constant reserved_0_TB33_TXPMA_IDX_7	: integer := 87;
   constant reserved_0_TB33_TXPMA_IDX_8	: integer := 88;
   constant rpmadwidth_tx_TXPMA_IDX_0	: integer := 89;
   constant reserved_0_TB33_TXPMA_IDX_10	: integer := 90;
   constant reserved_0_TB33_TXPMA_IDX_11	: integer := 91;
   constant reserved_0_TB33_TXPMA_IDX_12	: integer := 92;
   constant reserved_0_TB33_TXPMA_IDX_13	: integer := 93;
   constant reserved_0_TB33_TXPMA_IDX_14	: integer := 94;
   constant reserved_0_TB33_TXPMA_IDX_15	: integer := 95;
   
   -- Table34: PMA Per Channel TX Control Register 7 for Channel 0
   constant ricdr_reserved_0_TB34_TXPMA_IDX_8	: integer := 96;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_9	: integer := 97;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_10	: integer := 98;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_11	: integer := 99;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_12	: integer := 100;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_13	: integer := 101;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_14	: integer := 102;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_15	: integer := 103;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_16	: integer := 104;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_17	: integer := 105;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_18	: integer := 106;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_19	: integer := 107;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_20	: integer := 108;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_21	: integer := 109;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_22	: integer := 110;
   constant ricdr_reserved_0_TB34_TXPMA_IDX_23	: integer := 111;
   
   -- Table35: PMA Per Channel TX Control Register 8 for Channel 0
   constant rpma_reserved_0_TB35_TXPMA_IDX_0	: integer := 112;
   constant rpma_reserved_0_TB35_TXPMA_IDX_1	: integer := 113;
   constant rpma_reserved_0_TB35_TXPMA_IDX_2	: integer := 114;
   constant rpma_reserved_0_TB35_TXPMA_IDX_3	: integer := 115;
   constant rpma_reserved_0_TB35_TXPMA_IDX_4	: integer := 116;
   constant rpma_reserved_0_TB35_TXPMA_IDX_5	: integer := 117;
   constant rpma_reserved_0_TB35_TXPMA_IDX_6	: integer := 118;
   constant rpma_reserved_0_TB35_TXPMA_IDX_7	: integer := 119;
   constant rpma_reserved_0_TB35_TXPMA_IDX_8	: integer := 120;
   constant rpma_reserved_0_TB35_TXPMA_IDX_9	: integer := 121;
   constant rpma_reserved_0_TB35_TXPMA_IDX_10	: integer := 122;
   constant rpma_reserved_0_TB35_TXPMA_IDX_11	: integer := 123;
   constant rpma_reserved_0_TB35_TXPMA_IDX_12	: integer := 124;
   constant rpma_reserved_0_TB35_TXPMA_IDX_13	: integer := 125;
   constant rpma_reserved_0_TB35_TXPMA_IDX_14	: integer := 126;
   constant rpma_reserved_0_TB35_TXPMA_IDX_15	: integer := 127;
   
   -- Manually added cram bit that shared with RX PMA 
   constant rpma_loopback1                      : integer := 203;
   constant rpma_loopback3                      : integer := 204;
   
    -- ---------------------------------------------------------------------------
    -- DPRIO input CRAM  
    -- ---------------------------------------------------------------------------  

    -- PMA Per Channel TX Control Register 6 for Channel 0
    SIGNAL dprioin_rpmadwidth_tx	: STD_LOGIC;
    
    -- PMA Per Channel TX Control that shared with RX PMA
    SIGNAL dprioin_rpma_loopback1   : STD_LOGIC;
    SIGNAL dprioin_rpma_loopback3   : STD_LOGIC;
    
    -- ---------------------------------------------------------------------------
    -- CRAM  
    -- ---------------------------------------------------------------------------
    
    -- PMA Per Channel TX Control Register 6 for Channel 0
    SIGNAL cram_rpmadwidth_tx	: STD_LOGIC;
    
    -- PMA Per Channel TX Control that shared with RX PMA
    SIGNAL cram_rpma_rloopback1 : STD_LOGIC;
    SIGNAL cram_rpma_rloopback3 : STD_LOGIC;
    
    -- -----------------------------------
    -- Initial CRAM ---------------------- 
    -- -----------------------------------
    
    -- PMA Per Channel TX Control Register 1 for Channel 0
    SIGNAL init_rpowdnt	            : STD_LOGIC;
    SIGNAL init_rvod_sel_non_pcie	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    
    -- PMA Per Channel TX Control Register 2 for Channel 0
    SIGNAL init_rpre_em_1t_no_pcie	: STD_LOGIC_VECTOR(4 DOWNTO 0);
    
    -- PMA Per Channel TX Control Register 4 for Channel 0
    SIGNAL init_rlowv           : STD_LOGIC;
    SIGNAL init_rrx_det         : STD_LOGIC_VECTOR(1 DOWNTO 0);
    SIGNAL init_rslew	        : STD_LOGIC_VECTOR(1 DOWNTO 0);
    SIGNAL init_rtx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL init_rtx_vtt	        : STD_LOGIC_VECTOR(1 DOWNTO 0);
    
    -- PMA Per Channel TX Control Register 6 for Channel 0
    SIGNAL init_rtx_cgb_pdb	    : STD_LOGIC;
    SIGNAL init_rpmadwidth_tx	: STD_LOGIC;
    SIGNAL init_rs_lpbk	        : STD_LOGIC;

BEGIN

	-- Resets
	txpma_rstb  	<= mux_select((txpmareset = '1'), '0', '1');
	cgb_pdb  	<= mux_select((cgbpowerdn = '1'), '0', '1'); -- not in wys yet
	tx_pdb  	<= mux_select((powerdn = '1'), '0', '1');
	
	-- Drive referenced outputs
	dataout		  	<= mux_select((tx_pdb = '0'), '0', dataout_buf);
	
	dataout_buf 		<= (mux_select((enable_reverse_serial_loopback = ("true") OR (cram_rpma_rloopback3 = '1' AND cram_rpma_rloopback1 = '0')), reverselpbkin, 
		      		    mux_select((enable_diagnostic_loopback = ("true") OR cram_rpma_rloopback1 = '1'), diagnosticlpbkin, 
	      			    mux_select((enable_txclkout_loopback = ("true")), refclk0in, ser_dataout))));
	-- Serializer
	clockout 		<= refclk0in;
	seriallpbkout 		<= ser_dataout;

	-- RX Detect
	rxfoundout 		<= rxdet_out_rx_found;
	rxdetectvalidout 	<= rxdet_out_rx_det_valid;
	rxdet_in_clk15m		<= rxdet_fixclk_reg;
	rxdet_in_rx_det_pdb  	<= mux_select((detectrxpowerdown = '1'), '0', '1');
	rxdet_in_tx_det_rx   	<= mux_select((rxdetecten = '1'), '1', '0');

    -- ---------------------------------------------------------------------------
    -- Set DPRIO CRAM input from dprioin  
    -- ---------------------------------------------------------------------------
    
    -- PMA Per Channel TX Control Register 6 for Channel 0
    dprioin_rpmadwidth_tx	<= dprioin(rpmadwidth_tx_TXPMA_IDX_0);

    -- PMA Per Channel TX Control that shared with RX PMA
    dprioin_rpma_loopback1  <= dprioin(rpma_loopback1);
    dprioin_rpma_loopback3  <= dprioin(rpma_loopback3);
    
    -- ---------------------------------------------------------------------------
    -- Set DPRIO output from initial CRAM
    -- ---------------------------------------------------------------------------
    
    -- PMA Per Channel TX Control Register 1 for Channel 0
    dprioout(rpowdnt_TXPMA_IDX_0) <= init_rpowdnt;
    dprioout(rvod_sel_non_pcie_TXPMA_IDX_2 DOWNTO rvod_sel_non_pcie_TXPMA_IDX_0) <= init_rvod_sel_non_pcie;
    
    -- PMA Per Channel TX Control Register 2 for Channel 0
    dprioout(rpre_em_1t_no_pcie_TXPMA_IDX_4 DOWNTO rpre_em_1t_no_pcie_TXPMA_IDX_0) <= init_rpre_em_1t_no_pcie;
    
    -- PMA Per Channel TX Control Register 4 for Channel 0
    dprioout(rlowv_TXPMA_IDX_0) <= init_rlowv;
    dprioout(rrx_det_TXPMA_IDX_1 DOWNTO rrx_det_TXPMA_IDX_0) <= init_rrx_det;
    dprioout(rslew_TXPMA_IDX_1 DOWNTO rslew_TXPMA_IDX_0) <= init_rslew;
    dprioout(rtx_vtt_TXPMA_IDX_1 DOWNTO rtx_vtt_TXPMA_IDX_0) <= init_rtx_vtt;
    dprioout(rtx_term_sel_TXPMA_IDX_2 DOWNTO rtx_term_sel_TXPMA_IDX_0) <= init_rtx_term_sel;
    
    -- PMA Per Channel TX Control Register 6 for Channel 0
    dprioout(rtx_cgb_pdb_TXPMA_IDX_0) <= init_rtx_cgb_pdb;
    dprioout(rpmadwidth_tx_TXPMA_IDX_0) <= init_rpmadwidth_tx;
        
    -- PMA Per Channel TX Control that shared with RX PMA
    dprioout(rpma_loopback1) <= init_rs_lpbk;
    dprioout(rpma_loopback3) <= init_rs_lpbk;
    
    -- ---------------------------------------------------------------------------
    -- Set DPRIO CRAM
    -- ---------------------------------------------------------------------------
    
    -- PMA Per Channel TX Control Register 6 for Channel 0
    cram_rpmadwidth_tx <= init_rpmadwidth_tx WHEN (dpriodisable /= '0') ELSE dprioin_rpmadwidth_tx;
    
    -- PMA Per Channel TX Control that shared with RX PMA
    cram_rpma_rloopback1 <= init_rs_lpbk WHEN (dpriodisable /= '0') ELSE dprioin_rpma_loopback1;
    cram_rpma_rloopback3 <= init_rs_lpbk WHEN (dpriodisable /= '0') ELSE dprioin_rpma_loopback3;
    
	-- --------------------------------------------
	-- CRAM bits ----------------------------------
	-- --------------------------------------------
	
	PROCESS
	BEGIN
		-- TX PMA control register 1
		init_rpowdnt <= '0';
		init_rvod_sel_non_pcie <= mux_select((vod_selection = 0), "000", mux_select((vod_selection = 1), "001", mux_select((vod_selection = 2), "010", mux_select((vod_selection = 3), "110", mux_select((vod_selection = 4), "011", mux_select((vod_selection = 5), "111", mux_select((vod_selection = 6), "100", mux_select((vod_selection = 7), "101", "000"))))))));
		
		-- TX PMA control register 2 
		init_rpre_em_1t_no_pcie <= 	mux_select((preemp_tap_1 = 1), "00001", 
			    			mux_select((preemp_tap_1 = 5), "00101", 
						mux_select((preemp_tap_1 = 9), "01001", 
						mux_select((preemp_tap_1 = 13), "01101", 
						mux_select((preemp_tap_1 = 16), "10000",
					        mux_select((preemp_tap_1 = 17), "10001", 
						mux_select((preemp_tap_1 = 18), "10010",
						mux_select((preemp_tap_1 = 19), "10011", 
						mux_select((preemp_tap_1 = 20), "10100", 	
						mux_select((preemp_tap_1 = 21), "10101", "XXXXX"))))))))));
	
		-- TX PMA control register 4
		init_rlowv		<=	'0';
		init_rrx_det <= 		mux_select((rx_detect = 1), "01", 
			    			mux_select((rx_detect = 2), "10", 
						mux_select((rx_detect = 3), "11", "00")));

		init_rslew <= 			mux_select((alpha_tolower(slew_rate) = ("low")), "01", 
		   				mux_select((alpha_tolower(slew_rate) = ("medium")), "10", 
						mux_select((alpha_tolower(slew_rate) = ("high")), "11", "00")));

        init_rtx_term_sel(1 DOWNTO 0) <= (mux_select((alpha_tolower(termination) = ("oct 150 ohms")), "00", mux_select((alpha_tolower(termination) = ("oct 100 ohms")), "10", "XX")));
        init_rtx_term_sel(2) <= mux_select((use_external_termination = ("true")), '1', '0');
		
		init_rtx_vtt <= 		mux_select((alpha_tolower(common_mode) = ("tristate")), "00", 
						mux_select((alpha_tolower(common_mode) = ("0.65v")), "11", "XX"));

		-- TX PMA Control Register 6
	    init_rtx_cgb_pdb		<= '0';
	    init_rpmadwidth_tx		<= mux_select((serialization_factor = 10), '1', '0'); 
		init_rs_lpbk <= 		mux_select((enable_reverse_serial_loopback = ("true")), '1', '0');   
	WAIT;	
	END PROCESS;

	-- --------------------------------------------
	-- Behavior model starting here ---------------
	-- --------------------------------------------
      
	-- RX Detect
	PROCESS 
	BEGIN
		rxdet_fixclk_reg <= '0';
	      	WHILE (TRUE) LOOP
	        WAIT FOR 4000 ps;
	        	rxdet_fixclk_reg <= NOT(rxdet_fixclk_reg);
	      	END LOOP;
	      	WAIT;
	END PROCESS; 
   
tx_pma_ser : cycloneiv_hssi_tx_pma_sub_ser
GENERIC MAP (
        channel_width  => serialization_factor
)
PORT MAP (
	clk0                 => fastrefclk0in,
        cgb_pdb		     => cgb_pdb, -- not in wys yet
	enable0              => refclk0inpulse,
        datain               => datain,
        serialdatain         => '0',
        postdpaserialdatain  => '0',
        dataout              => ser_dataout,
        --serialfdbkout        => ,
        dpaclkin             => '0',
        devclrn              => txpma_rstb,
        devpor               => '1'
);

m_rxdet : cycloneiv_hssi_tx_pma_sub_tx_rx_det
PORT MAP (
	rx_det_pdb          => rxdet_in_rx_det_pdb,
        clk15m              => rxdet_in_clk15m,
        tx_det_rx           => rxdet_in_tx_det_rx,
        rx_found            => rxdet_out_rx_found,
        rx_det_valid        => rxdet_out_rx_det_valid
);
        	   
END trans;
-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_rx_pma_sub_deser
--
-- Description : Timing simulation model for the cycloneiv RX PMA
--               Deserializer. This module receives serial data and outputs
--               parallel data word of width = channel_width
--
-------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

ENTITY cycloneiv_hssi_rx_pma_sub_deser IS
    GENERIC (
        channel_width  : INTEGER := 8
    );
    PORT (
        fclk           : IN STD_LOGIC := '0';
        deven          : IN STD_LOGIC := '0';
        dodd           : IN STD_LOGIC := '0';
        loaden         : IN STD_LOGIC := '0';
        clr            : IN STD_LOGIC := '0';
        rxdat          : OUT STD_LOGIC_VECTOR(9 DOWNTO 0)
    );
END cycloneiv_hssi_rx_pma_sub_deser;

ARCHITECTURE trans OF cycloneiv_hssi_rx_pma_sub_deser IS
    -- INTERNAL VARIABLES AND NETS
    SIGNAL rxdat_tmp     : STD_LOGIC_VECTOR(9 DOWNTO 0) := "0000000000" ;
    SIGNAL rxdat_output  : STD_LOGIC_VECTOR(9 DOWNTO 0) := "0000000000" ;
   
    SIGNAL i             : INTEGER := 0 ;
    SIGNAL clr_edge      : STD_LOGIC := '0' ;
BEGIN   
    PROCESS (loaden, clr)
    BEGIN
        IF (clr = '1') THEN
            rxdat_output <= "0000000000";
            rxdat <= "0000000000";
        ELSE    
            IF (loaden = '1') THEN
                rxdat_output <= rxdat_tmp;
            ELSIF (loaden = '0') THEN
                rxdat <= rxdat_output;
            END IF;
        END IF;
    END PROCESS;
   
    PROCESS (fclk, clr)
    BEGIN
        IF (clr = '1') THEN
            rxdat_tmp <= "0000000000";
            i <= 0;
            clr_edge <= '1';
        ELSE    
            IF (clr_edge = '1') THEN
                clr_edge <= '0';
            ELSIF (rising_edge(fclk)) THEN
            	rxdat_tmp(7 DOWNTO 0) <= rxdat_tmp(9 DOWNTO 2);
            	rxdat_tmp(8) <= deven;
            	rxdat_tmp(9) <= dodd;  
            END IF;
        END IF;
    END PROCESS;  
END trans;

-------------------------------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_rx_pma_sub_clkdiv
--
-- Description : Cyclone IV GX RX PMA Clock divider
--
-------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

ENTITY cycloneiv_hssi_rx_pma_sub_clkdiv IS
    PORT (
        rxfclk         : IN STD_LOGIC := '0';
        clr            : IN STD_LOGIC := '0';
        deser_fact     : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
        loaden         : OUT STD_LOGIC;
        clkdivrx       : OUT STD_LOGIC
    );
END cycloneiv_hssi_rx_pma_sub_clkdiv;

ARCHITECTURE trans OF cycloneiv_hssi_rx_pma_sub_clkdiv IS
    SIGNAL clk_count_prev  : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000" ;
    SIGNAL clk_count       : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000" ;
    
    SIGNAL first_clkcount  : STD_LOGIC := '0' ;
    SIGNAL clkdivrx_prev   : STD_LOGIC := '0' ;
    SIGNAL rxloaden        : STD_LOGIC := '0' ;
    SIGNAL clkdivrx_tmp    : STD_LOGIC := '1' ;
    SIGNAL loaden_tmp      : STD_LOGIC := '0' ;

BEGIN
    -- Drive referenced outputs
    loaden <= loaden_tmp;
    clkdivrx <= clkdivrx_tmp;   
    
    PROCESS (clk_count_prev)
    BEGIN
        clk_count <= clk_count_prev + "0001";
    END PROCESS;
   
    -- rxloaden
    PROCESS (rxfclk)
    BEGIN        
        IF (clkdivrx_tmp = '0' OR first_clkcount = '0') THEN
            rxloaden <= '0';
        ELSIF (falling_edge(rxfclk) AND (clkdivrx_tmp = '1' OR rising_edge(clkdivrx_tmp))) THEN
            rxloaden <= NOT rxloaden;
        END IF;
    END PROCESS;

    PROCESS (rxfclk, clr)
    BEGIN
        IF (clr = '1') THEN
            clkdivrx_tmp <= '1';
            loaden_tmp <= '0';
            clkdivrx_prev <= '1';
            clk_count_prev <= "0000";
            first_clkcount <= '0';
        ELSIF (clr = '0') THEN
            -- clockout
            IF (first_clkcount = '0' AND rising_edge(rxfclk)) THEN
                first_clkcount <= '1';
                clk_count_prev <= "0000";
                clkdivrx_tmp <= '0';
            ELSIF (clk_count = deser_fact) THEN
                clk_count_prev <= "0000";
                clkdivrx_tmp <= NOT (clkdivrx_prev);
            ELSE
                clk_count_prev <= clk_count;
            END IF;
            clkdivrx_prev <= clkdivrx_tmp;
            
            -- loaden
            IF (rising_edge(rxfclk)) THEN
                IF (rxloaden = '1') THEN
                    loaden_tmp <= '1';
                ELSIF (rxloaden = '0') THEN
                    loaden_tmp <= '0';
                END IF;
            END IF;
        END IF;
    END PROCESS;
        
END trans;-- ***********************************************************
-- This WYSIWYG atom header was automatically generated by the
-- Atmgen build tool. To change it, alter data stored in the 
-- corresponding WYS file(s) in the tools-atmgen subdirectory.
-- ***********************************************************

-- *** Section 1 -- Header ***

-- -----------------------------------------------------------
--
-- Module Name : cycloneiv_hssi_rx_pma
--
-- Description : DEV_FAMILY_cycloneiv cycloneiv_hssi_rx_pma Verilog simulation model
--
-- -----------------------------------------------------------

-- *** End of Section 1 ***

-- *** Section 3 -- Module declaration ***

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_rx_pma IS
    GENERIC (
        lpm_type                                    : STRING := "cycloneiv_hssi_rx_pma";
        allow_serial_loopback                       : STRING := "false";
        channel_number                              : INTEGER := 0;
        common_mode                                 : STRING := "0.82V";
        deserialization_factor                      : INTEGER := 8;
        dprio_config_mode                           : STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
        enable_local_divider                       : STRING := "false";
        enable_dpa_shift                            : STRING := "false";
        enable_initial_phase_selection              : STRING := "false";
        enable_pd_counter_accumulate_mode           : STRING := "false";
        enable_ltd                                  : STRING := "false";
        enable_ltr                                  : STRING := "false";
        eq_dc_gain                                  : INTEGER := 0;
        eq_setting                                  : INTEGER := 1;
        force_signal_detect                         : STRING := "true";
        initial_phase_value                         : INTEGER := 0;
        logical_channel_address                     : INTEGER := 0;
        offset_cancellation                         : INTEGER := 0;
        pi_frequency_selector                       : INTEGER := 0;              
        ppm_gen1_2_xcnt_en                          : INTEGER := 1;
        ppm_post_eidle                              : INTEGER := 0;        
        pd1_counter_setting                         : INTEGER := 5;
        pd2_counter_setting                         : INTEGER := 5;
        pd_rising_edge_only                         : STRING := "false";
        phase_step_add_setting                      : INTEGER := 2;
        phase_step_sub_setting                      : INTEGER := 1;
        ppmselect                                   : INTEGER := 0;
        protocol_hint                               : STRING := "basic";
        effective_data_rate							: STRING := "unused";
        send_reverse_serial_loopback_data           : STRING := "false";
        send_reverse_serial_loopback_recovered_clk  : STRING := "false";
        signal_detect_hysteresis                    : INTEGER := 4;
        signal_detect_hysteresis_valid_threshold    : INTEGER := 1;
        signal_detect_loss_threshold                : INTEGER := 1;
        termination                                 : STRING := "OCT 85 Ohms";
        use_external_termination                    : STRING := "false";
		loop_1_digital_filter						: INTEGER := 8;
		power_down_pd2_clocks						: STRING := "false";
		enable_pd2_deadzone_detection				: STRING := "true";
		enable_second_order_loop					: STRING := "false"
    );
    PORT (
        crupowerdn                                  : IN STD_LOGIC := '0';
        datain                                      : IN STD_LOGIC := '0';
        deserclock                                  : IN STD_LOGIC := '0';
        dpashift                                    : IN STD_LOGIC := '0';
        dpriodisable                                : IN STD_LOGIC := '1';
        dprioin                                     : IN STD_LOGIC_VECTOR(300 - 1 DOWNTO 0) := (others => '0');
        locktodata                                  : IN STD_LOGIC := '0';
        locktoref                                   : IN STD_LOGIC := '0';
        powerdn                                     : IN STD_LOGIC := '0';
        ppmdetectrefclk                             : IN STD_LOGIC := '0';
        rxpmareset                                  : IN STD_LOGIC := '0';
        seriallpbkin                                : IN STD_LOGIC := '0';
        testbussel                                  : IN STD_LOGIC_VECTOR(3 DOWNTO 0):= (others => '0');
        analogtestbus                               : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
        clockout                                    : OUT STD_LOGIC;
        datastrobeout                               : OUT STD_LOGIC;
        diagnosticlpbkout                           : OUT STD_LOGIC;
        dprioout                                    : OUT STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);        
        freqlocked                                  : OUT STD_LOGIC;
        locktorefout                                : OUT STD_LOGIC;
        recoverdataout                              : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);
        reverselpbkout                              : OUT STD_LOGIC;
        signaldetect                                : OUT STD_LOGIC
    );
END cycloneiv_hssi_rx_pma;

ARCHITECTURE trans OF cycloneiv_hssi_rx_pma IS
    COMPONENT cycloneiv_hssi_rx_pma_sub_deser
        GENERIC (
            channel_width                           : INTEGER := 8
        );
        PORT (
            fclk                                    : IN STD_LOGIC;
            deven                                   : IN STD_LOGIC;
            dodd                                    : IN STD_LOGIC;
            loaden                                  : IN STD_LOGIC;
            clr                                     : IN STD_LOGIC;
            rxdat                                   : OUT STD_LOGIC_VECTOR(9 DOWNTO 0)
        );
    END COMPONENT;
   
    COMPONENT cycloneiv_hssi_rx_pma_sub_clkdiv
        PORT (
            rxfclk                                  : IN STD_LOGIC;
            clr                                     : IN STD_LOGIC;
            deser_fact                              : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
            loaden                                  : OUT STD_LOGIC;
            clkdivrx                                : OUT STD_LOGIC
        );
    END COMPONENT;
   
    ----------------------------------------------------------------------------
    -- Behavior model starting here --------------------------------------------
    ----------------------------------------------------------------------------
    ----------------------------------------------------------------------------
    --  Model / Submodule Instantiations                                       -
    ----------------------------------------------------------------------------
    SIGNAL deven                  : STD_LOGIC := '0' ;
    SIGNAL dodd                   : STD_LOGIC := '0' ;
    SIGNAL deven_prev             : STD_LOGIC := '0' ;
    SIGNAL dodd_prev              : STD_LOGIC := '0' ;
    SIGNAL rxdata                 : STD_LOGIC_VECTOR(9 DOWNTO 0);
    SIGNAL loaden                 : STD_LOGIC;  
    SIGNAL first_edge             : STD_LOGIC := '1' ; 
    SIGNAL clkdivrx               : STD_LOGIC;
    SIGNAL signaldetect_reg       : STD_LOGIC := '0' ;
    SIGNAL rxdatain               : STD_LOGIC;
    SIGNAL datain_in              : STD_LOGIC;
    SIGNAL sd_reset               : STD_LOGIC;   
    SIGNAL mfreqlocked_reg        : STD_LOGIC := '0' ;
    SIGNAL mfreqlocked_cnt        : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000" ;
    SIGNAL signal_detect_reg_n    : STD_LOGIC;
    SIGNAL sd_cdr                 : STD_LOGIC;
    SIGNAL clockout_xhdl0         : STD_LOGIC;
    SIGNAL locktorefout_xhdl1     : STD_LOGIC;
    SIGNAL recoverdataout_xhdl2   : STD_LOGIC_VECTOR(9 DOWNTO 0);
    SIGNAL signaldetect_xhdl3     : STD_LOGIC;
    SIGNAL locktorefout_freqlock  : STD_LOGIC := '0';
    SIGNAL deserclock_div_2		  : STD_LOGIC := '0';
    -- lpbk signals
    SIGNAL rlpbk_data             : STD_LOGIC;
    SIGNAL rlpbk_clk              : STD_LOGIC;    
    SIGNAL clr                    : STD_LOGIC; 
    -- for dpashift
    SIGNAL dpashift_on            : STD_LOGIC := '0'; 
    SIGNAL deserclock_dly         : STD_LOGIC := '0'; 
    SIGNAL prev_posedge           : TIME := 0.0 ps;
    SIGNAL deserclock_period      : TIME := 0.0 ps;
    SIGNAL deserclock_delay       : TIME := 0.0 ps; 

    -- ---------------------------------------------------------------------------
    --  New DPRIO Begin 
    -- ---------------------------------------------------------------------------
-- Table34: PMA Per Channel TX Control Register 7 for Channel 0 (RX PMA)
constant ricdr_reserved_0_TB34_TXPMA_IDX_0	: integer := 0;
constant ricdr_reserved_0_TB34_TXPMA_IDX_1	: integer := 1;
constant ricdr_reserved_1_TB34_TXPMA_IDX_0	: integer := 2;
constant ricdr_reserved_1_TB34_TXPMA_IDX_1	: integer := 3;
constant ricdr_reserved_2_TB34_TXPMA_IDX_0	: integer := 4;
constant ricdr_reserved_2_TB34_TXPMA_IDX_1	: integer := 5;
constant ricdr_ssc_enable	: integer := 6;
constant ricdr_en_local_clkdiv  : integer := 7;
constant ricdr_rlocdiv_TXPMA_IDX_0	: integer := 8;
constant ricdr_rlocdiv_TXPMA_IDX_1	: integer := 9;
constant ricdr_rlocdiv_TXPMA_IDX_2	: integer := 10;
constant ricdr_rlocdiv_TXPMA_IDX_3	: integer := 11;
constant ricdr_rlocdiv_TXPMA_IDX_4	: integer := 12;
constant ricdr_rlocdiv_TXPMA_IDX_5	: integer := 13;
constant ricdr_rlocdiv_TXPMA_IDX_6	: integer := 14;
constant ricdr_rlocdiv_TXPMA_IDX_7	: integer := 15;


    -- Table36: PMA Per Channel RX Control Register 1 for Channel 0
constant rrx_term_sel_RXPMA_IDX_0	: integer := 16;
constant rrx_term_sel_RXPMA_IDX_1	: integer := 17;
constant rrx_term_sel_RXPMA_IDX_2	: integer := 18;
constant rrx_vtt_RXPMA_IDX_0	: integer := 19;
constant rrx_vtt_RXPMA_IDX_1	: integer := 20;
constant rrx_vtt_RXPMA_IDX_2	: integer := 21;
constant rrx_s_rdlpbk_RXPMA_IDX_0	: integer := 22;
constant rrx_bit_dc_RXPMA_IDX_0	: integer := 23;
constant rrx_bit_dc_RXPMA_IDX_1	: integer := 24;
constant rrx_bit_dc_RXPMA_IDX_2	: integer := 25;
constant rrx_bit_dc_RXPMA_IDX_3	: integer := 26;
constant rrx_lst_RXPMA_IDX_0	: integer := 27;
constant rrx_lst_RXPMA_IDX_1	: integer := 28;
constant rrx_lst_RXPMA_IDX_2	: integer := 29;
constant rrx_lst_RXPMA_IDX_3	: integer := 30;
constant rrx_lst_RXPMA_IDX_4	: integer := 31;
   
    -- Table37: PMA Per Channel RX Control Register 2 for Channel 0
constant rrxurstpma_RXPMA_IDX_0	: integer := 32;
constant rrx_test_RXPMA_IDX_0	: integer := 33;
constant rrx_sd_force_RXPMA_IDX_0	: integer := 34;
constant rrx_oc_RXPMA_IDX_0	: integer := 35;
constant rrx_oc_RXPMA_IDX_1	: integer := 36;
constant rrx_oc_RXPMA_IDX_2	: integer := 37;
constant rrx_oc_RXPMA_IDX_3	: integer := 38;
constant rrx_oc_RXPMA_IDX_4	: integer := 39;
constant rrx_oc_RXPMA_IDX_5	: integer := 40;
constant rrx_oc_RXPMA_IDX_6	: integer := 41;
constant rrx_oc_RXPMA_IDX_7	: integer := 42;
constant rrx_oc_en_RXPMA_IDX_0	: integer := 43;
constant rrx_sdlv_RXPMA_IDX_0	: integer := 44;
constant rrx_sdlv_RXPMA_IDX_1	: integer := 45;
constant rrx_sdlv_RXPMA_IDX_2	: integer := 46;
constant rrx_sdlv_RXPMA_IDX_3	: integer := 47;
   
    -- Table38: PMA Per Channel RX Control Register 3 for Channel 0
constant reserved_0_TB38_RXPMA_IDX_0	: integer := 48;
constant reserved_0_TB38_RXPMA_IDX_1	: integer := 49;
constant reserved_0_TB38_RXPMA_IDX_2	: integer := 50;
constant rpowdnr_RXPMA_IDX_0	: integer := 51;
constant rrx_ib_pdb_RXPMA_IDX_0	: integer := 52;
constant rurx_pdb_RXPMA_IDX_0	: integer := 53;
constant rrx_oc_calpd_RXPMA_IDX_0	: integer := 54;
constant rrx_sd_off_RXPMA_IDX_0	: integer := 55;
constant rrx_sd_off_RXPMA_IDX_1	: integer := 56;
constant rrx_sd_off_RXPMA_IDX_2	: integer := 57;
constant rrx_sd_off_RXPMA_IDX_3	: integer := 58;
constant rrx_sd_off_RXPMA_IDX_4	: integer := 59;
constant rrx_sd_on_RXPMA_IDX_0	: integer := 60;
constant rrx_sd_on_RXPMA_IDX_1	: integer := 61;
constant rrx_sd_on_RXPMA_IDX_2	: integer := 62;
constant rrx_sd_on_RXPMA_IDX_3	: integer := 63;
   
    -- Table39: PMA Per Channel RX Control Register 4 for Channel 0
constant ricdr_freq_sel_pi_IDX_0	: integer := 64;
constant ricdr_freq_sel_pi_IDX_1	: integer := 65;
constant rdefact_RXPMA_IDX_0	: integer := 66;
constant rdefact_RXPMA_IDX_1	: integer := 67;
constant rdefact_RXPMA_IDX_2	: integer := 68;
constant rdefact_RXPMA_IDX_3	: integer := 69;
constant ricdr_rcl_prst_IDX_0	: integer := 70;
constant ricdr_rcl_prst_IDX_1	: integer := 71;
constant ricdr_rcl_prst_IDX_2	: integer := 72;
constant ricdr_rcl_prst_IDX_3	: integer := 73;
constant ricdr_rcl_prst_IDX_4	: integer := 74;
constant ricdr_rcl_prst_IDX_5	: integer := 75;
constant ricdr_rcl_prst_IDX_6	: integer := 76;
constant ricdr_rcl_prst_IDX_7	: integer := 77;
constant ricdr_rcl_hi_DP	: integer := 78;
constant ricdr_rcl_lo_DP	: integer := 79;
    
    -- Table40: PMA Per Channel RX Control Register 5 for Channel 0
constant ricdr_rcl_hi_tb40_IDX_0	: integer := 80;
constant ricdr_rcl_hi_tb40_IDX_1	: integer := 81;
constant ricdr_rcl_hi_tb40_IDX_2	: integer := 82;
constant ricdr_rcl_hi_tb40_IDX_3	: integer := 83;
constant ricdr_rcl_hi_tb40_IDX_4	: integer := 84;
constant ricdr_rcl_hi_tb40_IDX_5	: integer := 85;
constant ricdr_rcl_hi_tb40_IDX_6	: integer := 86;
constant ricdr_rcl_hi_tb40_IDX_7	: integer := 87;
constant ricdr_rcl_lo_tb40_IDX_0	: integer := 88;
constant ricdr_rcl_lo_tb40_IDX_1	: integer := 89;
constant ricdr_rcl_lo_tb40_IDX_2	: integer := 90;
constant ricdr_rcl_lo_tb40_IDX_3	: integer := 91;
constant ricdr_rcl_lo_tb40_IDX_4	: integer := 92;
constant ricdr_rcl_lo_tb40_IDX_5	: integer := 93;
constant ricdr_rcl_lo_tb40_IDX_6	: integer := 94;
constant ricdr_rcl_lo_tb40_IDX_7	: integer := 95;
    
    -- Table41: PMA Per Channel RX Control Register 6 for Channel 0
constant reserved_0_tb41_IDX_0	: integer := 96;
constant reserved_1_tb41_IDX_0	: integer := 97;
constant reserved_2_tb41_IDX_0	: integer := 98;
constant reserved_2_tb41_IDX_1	: integer := 99;
constant reserved_2_tb41_IDX_2	: integer := 100;
constant reserved_2_tb41_IDX_3	: integer := 101;
constant reserved_3_tb41_IDX_0	: integer := 102;
constant reserved_3_tb41_IDX_1	: integer := 103;
constant rclocktree_reserved_tb41_IDX_0	: integer := 104;
constant rclocktree_reserved_tb41_IDX_1	: integer := 105;
constant reserved_4_tb41_IDX_0	: integer := 106;
constant reserved_5_tb41_IDX_0	: integer := 107;
constant rrx_cru_pdb_IDX_0	: integer := 108;
constant rltr_RXPMA_IDX_0	: integer := 109;
constant rltd_RXPMA_IDX_0	: integer := 110;
constant reserved_6_tb41_IDX_0	: integer := 111;
    
-- Table42: PMA Per Channel RX Control Register 7 for Channel 0
constant rphsel_clkdivrx_RXPMA_IDX_0	: integer := 112;
constant rrisedge_RXPMA_IDX_0	: integer := 113;
constant rpdof_en_RXPMA_IDX_0	: integer := 114;
constant rcntfact_RXPMA_IDX_0	: integer := 115;
constant rcntfact_RXPMA_IDX_1	: integer := 116;
constant rcntfact_RXPMA_IDX_2	: integer := 117;
constant rcntfact2_RXPMA_IDX_0	: integer := 118;
constant rcntfact2_RXPMA_IDX_1	: integer := 119;
constant rcntfact2_RXPMA_IDX_2	: integer := 120;
constant ropt1_RXPMA_IDX_0	: integer := 121;
constant rrtest_RXPMA_IDX_0	: integer := 122;
constant rrtest2_RXPMA_IDX_0	: integer := 123;
constant ricdrclkout_RXPMA_IDX_0	: integer := 124;
constant rtxfclkout_RXPMA_IDX_0	: integer := 125;
constant rjtaglp_RXPMA_IDX_2	: integer := 126;
constant reserved_0_tb42_IDX_0	: integer := 127;
        
    -- Table43: PMA Per Channel RX Control Register 8 for Channel 0
constant rloopback1_RXPMA_IDX_0	: integer := 128;
constant rloopback2_RXPMA_IDX_0	: integer := 129;
constant rloopback3_RXPMA_IDX_0	: integer := 130;
constant rendpa_RXPMA_IDX_0	: integer := 131;
constant rup_RXPMA_IDX_0	: integer := 132;
constant rdn_RXPMA_IDX_0	: integer := 133;
constant rtxclk_en_b_RXPMA_IDX_0	: integer := 134;
constant rtxclk_en_t_RXPMA_IDX_0	: integer := 135;
constant rfrefmx_RXPMA_IDX_0	: integer := 136;
constant rtxclk_divmx_RXPMA_IDX_0	: integer := 137;
constant rtxloadmx_RXPMA_IDX_0	: integer := 138;
constant rtxfclkmx_RXPMA_IDX_0	: integer := 139;
constant rntri_icdrtree_RXPMA_IDX_0	: integer := 140;
constant rntri_lvdstree_RXPMA_IDX_0	: integer := 141;
constant rsel_lvdstree_RXPMA_IDX_0	: integer := 142;
constant reserved_0_TB43_RXPMA_IDX_0	: integer := 143;
   
   -- Table44: PMA Per Channel RX Control Register 9 for Channel 0
constant rclk_sd_RXPMA_IDX_0	: integer := 144;
constant rclk_sd_RXPMA_IDX_1	: integer := 145;
constant rtestenp_sd_RXPMA_IDX_0	: integer := 146;
constant rtestenn_sd_RXPMA_IDX_0	: integer := 147;
constant rshiften_RXPMA_IDX_0	: integer := 148;
constant radd_RXPMA_IDX_0	: integer := 149;
constant radd_RXPMA_IDX_1	: integer := 150;
constant rsub_RXPMA_IDX_0	: integer := 151;
constant rsub_RXPMA_IDX_1	: integer := 152;
constant rphenable_RXPMA_IDX_0	: integer := 153;
constant rprst_RXPMA_IDX_0	: integer := 154;
constant rprst_RXPMA_IDX_1	: integer := 155;
constant rprst_RXPMA_IDX_2	: integer := 156;
constant rprst_RXPMA_IDX_3	: integer := 157;
constant rprst_RXPMA_IDX_4	: integer := 158;
constant rprst_RXPMA_IDX_5	: integer := 159;
   
-- Table45: PMA Per Channel RX Control Register 10 for Channel 0
constant rppm_cnt_reset_RXPMA_IDX_0	: integer := 160;
constant rforce1_freqdet_RXPMA_IDX_1	: integer := 161;
constant rforce0_freqdet_RXPMA_IDX_0	: integer := 162;
constant rppmsel_RXPMA_IDX_0	: integer := 163;
constant rppmsel_RXPMA_IDX_1	: integer := 164;
constant rppmsel_RXPMA_IDX_2	: integer := 165;
constant rppmsel_RXPMA_IDX_3	: integer := 166;
constant rppmsel_RXPMA_IDX_4	: integer := 167;
constant rppmsel_RXPMA_IDX_5	: integer := 168;
constant reserved_0_TB45_RXPMA_IDX_0	: integer := 169;
constant reserved_0_TB45_RXPMA_IDX_1	: integer := 170;
constant reserved_0_TB45_RXPMA_IDX_2	: integer := 171;
constant reserved_0_TB45_RXPMA_IDX_3	: integer := 172;
constant reserved_1_TB45_RXPMA_IDX_4	: integer := 173;
constant rpmadwidth_rx_RXPMA_IDX_0	: integer := 174;
constant reserved_2_TB45_RXPMA_IDX_0	: integer := 175;
   
   -- Table46: PMA Per Channel RX Control Register 11 for Channel 0
constant reserved_0_TB46_RXPMA_IDX_0	: integer := 176;
constant reserved_0_TB46_RXPMA_IDX_1	: integer := 177;
constant reserved_0_TB46_RXPMA_IDX_2	: integer := 178;
constant reserved_0_TB46_RXPMA_IDX_3	: integer := 179;
constant reserved_0_TB46_RXPMA_IDX_4	: integer := 180;
constant reserved_0_TB46_RXPMA_IDX_5	: integer := 181;
constant reserved_0_TB46_RXPMA_IDX_6	: integer := 182;
constant reserved_0_TB46_RXPMA_IDX_7	: integer := 183;
constant rppm_gen1_2xcnt_en_RXPMA_IDX_0	: integer := 184;
constant rppm_post_eidle_del_RXPMA_IDX_0	: integer := 185;
constant r_dfe_2t_RXPMA_IDX_0	: integer := 186;
constant r_dfe_2t_RXPMA_IDX_1	: integer := 187;
constant r_dfe_2t_RXPMA_IDX_2	: integer := 188;
constant r_dfe_1t_RXPMA_IDX_0	: integer := 189;
constant r_dfe_1t_RXPMA_IDX_1	: integer := 190;
constant r_dfe_1t_RXPMA_IDX_2	: integer := 191;
   
   -- Table47: PMA Per Channel RX Control Register 12 for Channel 0
constant reqv_set_RXPMA_IDX_0	: integer := 192;
constant reqv_set_RXPMA_IDX_1	: integer := 193;
constant reqv_set_RXPMA_IDX_2	: integer := 194;
constant reqd_set_RXPMA_IDX_0	: integer := 195;
constant reqd_set_RXPMA_IDX_1	: integer := 196;
constant reqd_set_RXPMA_IDX_2	: integer := 197;
constant reqc_set_RXPMA_IDX_0	: integer := 198;
constant reqc_set_RXPMA_IDX_1	: integer := 199;
constant reqc_set_RXPMA_IDX_2	: integer := 200;
constant reqb_set_RXPMA_IDX_0	: integer := 201;
constant reqb_set_RXPMA_IDX_1	: integer := 202;
constant reqb_set_RXPMA_IDX_2	: integer := 203;
constant reqa_set_RXPMA_IDX_0	: integer := 204;
constant reqa_set_RXPMA_IDX_1	: integer := 205;
constant reqa_set_RXPMA_IDX_2	: integer := 206;
constant reserved_0_TB47_RXPMA_IDX_0	: integer := 207;
    
    -- ---------------------------------------------------------------------------
    -- DPRIO input CRAM  
    -- ---------------------------------------------------------------------------    
    -- PMA Per Channel RX Control Register 2 for Channel 0
    SIGNAL dprioin_rrx_sd_force	: STD_LOGIC;
    
    -- PMA Per Channel RX Control Register 4 for Channel 0
    SIGNAL dprioin_rdefact	: STD_LOGIC_VECTOR(3 DOWNTO 0);
    
    -- PMA Per Channel RX Control Register 7 for Channel 0
    SIGNAL dprioin_ricdrclkout	: STD_LOGIC;
    
    -- PMA Per Channel RX Control Register 8 for Channel 0
    SIGNAL dprioin_rloopback2	: STD_LOGIC;
    SIGNAL dprioin_rloopback3	: STD_LOGIC;
    
    -- PMA Per Channel RX Control Register 9 for Channel 0
    SIGNAL dprioin_rshiften	: STD_LOGIC;

    -- PMA Per Channel RX Control Register 7 for Channel 0 (Table 34)
    SIGNAL dprioin_bypass_local_div : STD_LOGIC;
    
  
  
    

    -- ---------------------------------------------------------------------------
    -- Initial CRAM  
    -- ---------------------------------------------------------------------------
    
    -- PMA Per Channel RX Control Register 1 for Channel 0
    SIGNAL init_rrx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL init_rrx_vtt	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL init_rrx_bit_dc	: STD_LOGIC_VECTOR(3 DOWNTO 0);
    
    -- PMA Per Channel RX Control Register 2 for Channel 0
    SIGNAL init_rrx_sd_force	: STD_LOGIC;
    SIGNAL init_rrx_sdlv	: STD_LOGIC_VECTOR(3 DOWNTO 0);
    
    -- PMA Per Channel RX Control Register 3 for Channel 0
    SIGNAL init_rrx_sd_off	: STD_LOGIC_VECTOR(4 DOWNTO 0);
    SIGNAL init_rrx_sd_on	: STD_LOGIC_VECTOR(3 DOWNTO 0);
    
    -- PMA Per Channel RX Control Register 4 for Channel 0
    SIGNAL init_rdefact	: STD_LOGIC_VECTOR(3 DOWNTO 0);
    
    -- PMA Per Channel RX Control Register 7 for Channel 0
    SIGNAL init_rrisedge	: STD_LOGIC;
    SIGNAL init_rcntfact	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL init_rcntfact2	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL init_ropt1	: STD_LOGIC;
    SIGNAL init_ricdrclkout	: STD_LOGIC;
    SIGNAL init_bypass_local_div : STD_LOGIC;

    
    -- PMA Per Channel RX Control Register 8 for Channel 0
    SIGNAL init_rloopback2	: STD_LOGIC;
    SIGNAL init_rloopback3	: STD_LOGIC;
    
    -- PMA Per Channel RX Control Register 9 for Channel 0
    SIGNAL init_rshiften	: STD_LOGIC;
    SIGNAL init_radd	: STD_LOGIC_VECTOR(1 DOWNTO 0);
    SIGNAL init_rsub	: STD_LOGIC_VECTOR(1 DOWNTO 0);
    SIGNAL init_rphenable	: STD_LOGIC;
    SIGNAL init_rprst	: STD_LOGIC_VECTOR(5 DOWNTO 0);
    
    -- PMA Per Channel RX Control Register 10 for Channel 0
    SIGNAL init_rppmsel	: STD_LOGIC_VECTOR(5 DOWNTO 0);
    SIGNAL init_rpmadwidth_rx : STD_LOGIC;

    
    -- PMA Per Channel RX Control Register 12 for Channel 0
    SIGNAL init_reqv_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL init_reqb_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL init_reqa_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
    
    -- ---------------------------------------------------------------------------
    -- CRAM  
    -- ---------------------------------------------------------------------------
   
    -- PMA Per Channel RX Control Register 2 for Channel 0
    SIGNAL cram_rrx_sd_force	: STD_LOGIC;
    
    -- PMA Per Channel RX Control Register 4 for Channel 0
    SIGNAL cram_rdefact	: STD_LOGIC_VECTOR(3 DOWNTO 0);
    
    -- PMA Per Channel RX Control Register 7 for Channel 0
    SIGNAL cram_ricdrclkout	: STD_LOGIC;
    SIGNAL cram_bypass_local_div : STD_LOGIC;
    
    -- PMA Per Channel RX Control Register 8 for Channel 0
    SIGNAL cram_rloopback2	: STD_LOGIC;
    SIGNAL cram_rloopback3	: STD_LOGIC;
    
    -- PMA Per Channel RX Control Register 9 for Channel 0
    SIGNAL cram_rshiften	: STD_LOGIC;
    
BEGIN

    -- ---------------------------------------------------------------------------
    -- Set DPRIO CRAM input from dprioin  
    -- ---------------------------------------------------------------------------

    -- PMA Per Channel RX Control Register 2 for Channel 0
    dprioin_rrx_sd_force	<= dprioin(rrx_sd_force_RXPMA_IDX_0);
    
    -- PMA Per Channel RX Control Register 4 for Channel 0
    dprioin_rdefact	<= dprioin(rdefact_RXPMA_IDX_3 DOWNTO rdefact_RXPMA_IDX_0);
    
    
    -- PMA Per Channel RX Control Register 7 for Channel 0
    dprioin_ricdrclkout	<= dprioin(ricdrclkout_RXPMA_IDX_0);
    dprioin_bypass_local_div <= dprioin(ricdr_en_local_clkdiv);
    
    -- PMA Per Channel RX Control Register 8 for Channel 0
    dprioin_rloopback2	<= dprioin(rloopback2_RXPMA_IDX_0);
    dprioin_rloopback3	<= dprioin(rloopback3_RXPMA_IDX_0);
    
    -- PMA Per Channel RX Control Register 9 for Channel 0
    dprioin_rshiften	<= dprioin(rshiften_RXPMA_IDX_0);
    
    -- ---------------------------------------------------------------------------
    -- Set DPRIO CRAM
    -- ---------------------------------------------------------------------------

    -- PMA Per Channel RX Control Register 2 for Channel 0
    cram_rrx_sd_force <= init_rrx_sd_force WHEN (dpriodisable /= '0') ELSE dprioin_rrx_sd_force;
    
    -- PMA Per Channel RX Control Register 4 for Channel 0
    cram_rdefact <= init_rdefact WHEN (dpriodisable /= '0') ELSE dprioin_rdefact;
    
    -- PMA Per Channel RX Control Register 7 for Channel 0
    cram_ricdrclkout <= init_ricdrclkout WHEN (dpriodisable /= '0') ELSE dprioin_ricdrclkout;
    cram_bypass_local_div <= init_bypass_local_div WHEN (dpriodisable /= '0') ELSE dprioin_bypass_local_div;
    
    -- PMA Per Channel RX Control Register 8 for Channel 0
    cram_rloopback2 <= init_rloopback2 WHEN (dpriodisable /= '0') ELSE dprioin_rloopback2;
    cram_rloopback3 <= init_rloopback3 WHEN (dpriodisable /= '0') ELSE dprioin_rloopback3;
    
    -- PMA Per Channel RX Control Register 9 for Channel 0
    cram_rshiften <= init_rshiften WHEN (dpriodisable /= '0') ELSE dprioin_rshiften;

    -- ---------------------------------------------------------------------------
    -- Set DPRIO output from initial CRAM
    -- ---------------------------------------------------------------------------
    
    -- PMA Per Channel RX Control Register 1 for Channel 0
    dprioout(rrx_term_sel_RXPMA_IDX_2 DOWNTO rrx_term_sel_RXPMA_IDX_0) <= init_rrx_term_sel;
    dprioout(rrx_vtt_RXPMA_IDX_2 DOWNTO rrx_vtt_RXPMA_IDX_0) <= init_rrx_vtt;
    dprioout(rrx_bit_dc_RXPMA_IDX_3 DOWNTO rrx_bit_dc_RXPMA_IDX_0) <= init_rrx_bit_dc;
    
    -- PMA Per Channel RX Control Register 2 for Channel 0
    dprioout(rrx_sd_force_RXPMA_IDX_0) <= init_rrx_sd_force;
    dprioout(rrx_sdlv_RXPMA_IDX_3 DOWNTO rrx_sdlv_RXPMA_IDX_0) <= init_rrx_sdlv;
    
    -- PMA Per Channel RX Control Register 3 for Channel 0
    dprioout(rrx_sd_off_RXPMA_IDX_4 DOWNTO rrx_sd_off_RXPMA_IDX_0) <= init_rrx_sd_off;
    dprioout(rrx_sd_on_RXPMA_IDX_3 DOWNTO rrx_sd_on_RXPMA_IDX_0) <= init_rrx_sd_on;
    
    -- PMA Per Channel RX Control Register 4 for Channel 0
    dprioout(rdefact_RXPMA_IDX_3 DOWNTO rdefact_RXPMA_IDX_0) <= init_rdefact;
    
    -- PMA Per Channel RX Control Register 7 for Channel 0
    dprioout(rrisedge_RXPMA_IDX_0) <= init_rrisedge;
    dprioout(rcntfact_RXPMA_IDX_2 DOWNTO rcntfact_RXPMA_IDX_0) <= init_rcntfact;
    dprioout(rcntfact2_RXPMA_IDX_2 DOWNTO rcntfact2_RXPMA_IDX_0) <= init_rcntfact2;
    dprioout(ropt1_RXPMA_IDX_0) <= init_ropt1;
    dprioout(ricdrclkout_RXPMA_IDX_0) <= init_ricdrclkout;
    dprioout(ricdr_en_local_clkdiv) <= init_bypass_local_div;
    
    -- PMA Per Channel RX Control Register 8 for Channel 0
    dprioout(rloopback2_RXPMA_IDX_0) <= init_rloopback2;
    dprioout(rloopback3_RXPMA_IDX_0) <= init_rloopback3;
    
    -- PMA Per Channel RX Control Register 9 for Channel 0
    dprioout(rshiften_RXPMA_IDX_0) <= init_rshiften;
    dprioout(radd_RXPMA_IDX_1 DOWNTO radd_RXPMA_IDX_0) <= init_radd;
    dprioout(rsub_RXPMA_IDX_1 DOWNTO rsub_RXPMA_IDX_0) <= init_rsub;
    dprioout(rphenable_RXPMA_IDX_0) <= init_rphenable;
    dprioout(rprst_RXPMA_IDX_5 DOWNTO rprst_RXPMA_IDX_0) <= init_rprst;
    
    -- PMA Per Channel RX Control Register 10 for Channel 0
    dprioout(rppmsel_RXPMA_IDX_5 DOWNTO rppmsel_RXPMA_IDX_0) <= init_rppmsel;
    dprioout(rpmadwidth_rx_RXPMA_IDX_0) <= init_rpmadwidth_rx;
    
    -- PMA Per Channel RX Control Register 12 for Channel 0
    dprioout(reqv_set_RXPMA_IDX_2 DOWNTO reqv_set_RXPMA_IDX_0) <= init_reqv_set;
    dprioout(reqb_set_RXPMA_IDX_2 DOWNTO reqb_set_RXPMA_IDX_0) <= init_reqb_set;
    dprioout(reqa_set_RXPMA_IDX_2 DOWNTO reqa_set_RXPMA_IDX_0) <= init_reqa_set;
    
    -- --------------------------------------------------------------------------
    -- Initial CRAM bits ---------------------------------------------
    -- --------------------------------------------------------------------------
    
    PROCESS 
    BEGIN
        -- RX PMA control register 1     
        init_rrx_term_sel(1 DOWNTO 0) <= (mux_select((alpha_tolower(termination) = ("oct 150 ohms")), "00", mux_select((alpha_tolower(termination) = ("oct 85 ohms")), "10", "XX")));
        init_rrx_term_sel(2) <= mux_select((use_external_termination = ("true")), '1', '0');
        init_rrx_vtt <= (mux_select((alpha_tolower(common_mode) = ("0.82v")), "010", mux_select((alpha_tolower(common_mode) = ("tristate")), "100", "000")));        
        init_rrx_bit_dc <= (mux_select((eq_dc_gain = 3), "0001", mux_select((eq_dc_gain = 6), "0011", mux_select((eq_dc_gain = 9), "0111", mux_select((eq_dc_gain = 12), "1111", "0000")))));    
        
        -- RX PMA control register 2
        init_rrx_sd_force	<= (mux_select((force_signal_detect = ("true")), '1', '0'));
        init_rrx_sdlv <= int2bin(signal_detect_hysteresis, 4);
        
        -- RX PMA control register 3
        init_rrx_sd_off		<= int2bin(signal_detect_loss_threshold, 5); 
        init_rrx_sd_on		<= int2bin(signal_detect_hysteresis_valid_threshold, 4);
    
        -- RX PMA Control Register 4
        init_rdefact <= (mux_select((deserialization_factor = 8), "0100", "0101"));
        
        -- RX PMA Control Register 7
        init_rrisedge <= (mux_select((pd_rising_edge_only = ("true")), '1', '0'));
        init_rcntfact <= int2bin(pd1_counter_setting, 3);
        init_rcntfact2 <= int2bin(pd2_counter_setting, 3);
        init_ropt1 <= (mux_select((enable_pd_counter_accumulate_mode = ("true")), '1', '0'));    
        init_ricdrclkout <= (mux_select((send_reverse_serial_loopback_recovered_clk = ("true")), '1', mux_select((send_reverse_serial_loopback_data = ("true")), '0', 'X')));  
        init_bypass_local_div <= (mux_select((enable_local_divider = ("true")), '0', '1'));      
                
        -- RX PMA Control Register 8
        init_rloopback2 <= (mux_select((allow_serial_loopback = ("true")), '1', '0'));
        init_rloopback3 <= (mux_select((send_reverse_serial_loopback_data = ("true") OR send_reverse_serial_loopback_recovered_clk = ("true")), '1', '0'));
        
        -- RX PMA Control Register 9
        init_rshiften <= (mux_select((enable_dpa_shift = ("true")), '1', '0'));
        init_radd <= int2bin(phase_step_add_setting, 2);
        init_rsub <= int2bin(phase_step_sub_setting, 2);
        init_rphenable <= mux_select((enable_initial_phase_selection = ("true")), '1', '0');
        init_rprst <= int2bin(initial_phase_value, 6);
    
        -- RX PMA Control Register 10
        init_rppmsel <= int2bin(ppmselect, 6);

        init_rpmadwidth_rx <=  (mux_select((deserialization_factor = 8), '0', '1'));
         
        -- RX PMA control register 12
        -- to be    
        WAIT;
    END PROCESS;
    
    -- enable_dpa_shift is turned on    
    -- for shifting 0.25 UI of deserclock if enable_dpa_shift==true
    PROCESS (dpashift)
    BEGIN    
        IF (cram_rshiften = '1') THEN
            IF (dpashift'EVENT AND dpashift = '1') THEN
                dpashift_on <= NOT dpashift_on;
            END IF;
        END IF;
    END PROCESS;

    --prevent x/z propagate to gate netlist
    datain_in <= datain WHEN (datain = '1' OR datain = '0') ELSE '0'; 
                       
    clr <= '1' WHEN ((rxpmareset = '1') OR (crupowerdn = '1')) ELSE 
           '0';
    rxdatain <= '0' WHEN (clr = '1') ELSE 
                seriallpbkin WHEN (cram_rloopback2 = '1') ELSE 
                datain_in;
    
    -- Divide the deserializer fast clock if local divider is turned on
    PROCESS (deserclock)
    BEGIN
    	IF (cram_bypass_local_div = '0') THEN
    		deserclock_div_2 <= NOT (deserclock_div_2);
    	ELSE
    		deserclock_div_2 <= deserclock;
    	END IF;
    	
    END PROCESS;
    
    -- Deserializer & dpashift operation
    PROCESS (deserclock_div_2)
    BEGIN
        -- dpashift operation
        -- calculating period
        deserclock_period <= NOW - prev_posedge;
        deserclock_delay <= deserclock_period / 4;
        prev_posedge <= NOW;

        IF (dpashift_on = '1' AND dpashift = '0') THEN
            deserclock_dly <= TRANSPORT deserclock AFTER deserclock_delay; 
        ELSE
            deserclock_dly <= deserclock; 
        END IF;
    END PROCESS;
    
    -- Deserializer              
    PROCESS (deserclock_dly)
    BEGIN
        -- sample deven & dodd
        IF (deserclock_dly'EVENT AND deserclock_dly = '1') THEN
            deven_prev <= rxdatain;
            IF (first_edge = '1') THEN
                deven <= '0';
                dodd <= '0';
                first_edge <= '0';
            ELSE
                deven <= deven_prev;
                dodd <= dodd_prev;
            END IF;
        
        ELSIF (deserclock_dly'EVENT AND deserclock_dly = '0') THEN
            dodd_prev <= rxdatain;
        END IF;         
    END PROCESS;

    rx_pma_deser : cycloneiv_hssi_rx_pma_sub_deser
        GENERIC MAP (
            channel_width  => deserialization_factor
        )
        PORT MAP (
            fclk    => deserclock_dly,
            deven   => deven,
            dodd    => dodd,
            loaden  => loaden,
            clr     => clr,
            rxdat   => rxdata
        );
      
    recoverdataout <= rxdata;
   
    -- CLKDIVRX
    rx_pma_clkdiv : cycloneiv_hssi_rx_pma_sub_clkdiv
        PORT MAP (
            rxfclk     => deserclock_dly,
            loaden     => loaden,
            deser_fact => cram_rdefact,
            clr        => clr,
            clkdivrx   => clkdivrx
        );
      
    clockout <= clkdivrx;   
   
    -- Signal Detect
    sd_reset <= '1' WHEN (powerdn = '1' OR rxpmareset = '1') ELSE
                '0';            
    PROCESS (sd_reset, rxdatain)
    BEGIN
        IF (sd_reset = '1') THEN
            signaldetect_reg <= '0';
        ELSIF (rxdatain = '0' OR rxdatain = '1') THEN
            signaldetect_reg <= '1';
        ELSE
            signaldetect_reg <= '0';
        END IF;
    END PROCESS;

    signaldetect <= signaldetect_reg;
   
    -- Lock to Ref Out
    -- simplified freqlock behavior:
    --  (1). Responding to rising edge of rxpll_lock with small counter;
    --  (2). Responding to analogreset
    --  (3). Not responding to loss of rxpll_lock
   
    signal_detect_reg_n <= NOT(signaldetect_reg);
 
    PROCESS (ppmdetectrefclk, rxpmareset)
    BEGIN
        IF (rxpmareset = '1') THEN
            mfreqlocked_reg <= '0';
        ELSIF (ppmdetectrefclk'EVENT AND ppmdetectrefclk = '1') THEN
            IF (mfreqlocked_cnt = "1111") THEN
                mfreqlocked_reg <= '1';
            ELSE
                mfreqlocked_reg <= '0';
            END IF;
        END IF;
    END PROCESS;
   
    PROCESS (ppmdetectrefclk, signal_detect_reg_n)
    BEGIN
        IF (signal_detect_reg_n = '1') THEN
            mfreqlocked_cnt <= "0000";
        ELSIF (ppmdetectrefclk'EVENT AND ppmdetectrefclk = '1') THEN
            IF (mfreqlocked_cnt /= "1111") THEN
                mfreqlocked_cnt <= mfreqlocked_cnt + "0001";
            END IF;
        END IF;
    END PROCESS;
   
    sd_cdr <= cram_rrx_sd_force OR cram_rloopback2 OR signaldetect_reg;
   
    locktorefout <= '0' WHEN (clr = '1') ELSE
                    '1' WHEN (locktodata = '1') ELSE
                    '0' WHEN (locktoref = '1') ELSE
                    '0' WHEN (sd_cdr = '0') ELSE
                    '1' WHEN (sd_cdr = '1' AND mfreqlocked_reg = '1' AND locktoref = '0') ELSE
                    '0';

    -- Loopback
    rlpbk_data <= '1' WHEN (cram_rloopback3 = '1' AND cram_ricdrclkout = '0') ELSE '0';
    rlpbk_clk <= '1' WHEN (cram_rloopback3 = '1' AND cram_ricdrclkout = '1') ELSE '0';
    
    diagnosticlpbkout <= datain_in;
    reverselpbkout <= deserclock_dly WHEN (rlpbk_clk = '1') ELSE
                      rxdatain WHEN (rlpbk_data = '1') ELSE 
                      '0';
                        
    -- drive 0 on analogtestbus
    analogtestbus <= "00000000";

    -- freqlocked
    locktorefout_freqlock <= '0' WHEN (clr = '1') ELSE
                             '0' WHEN (sd_cdr = '0') ELSE
                             '1' WHEN (sd_cdr = '1' AND mfreqlocked_reg = '1') ELSE
                             '0';
                                          
    freqlocked <= '1' WHEN (locktorefout_freqlock = '1') ELSE
                  '0';

    -- datastrobeout
    datastrobeout <= '0';
    
END trans;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_pcs_reset IS
   PORT (
      
      hard_reset   : IN STD_LOGIC;
      clk_2_b      : IN STD_LOGIC;
      refclk_b_in  : IN STD_LOGIC;
      scan_mode    : IN STD_LOGIC;
      rxpcs_rst    : IN STD_LOGIC;
      txpcs_rst    : IN STD_LOGIC;
      
      rxrst_int    : OUT STD_LOGIC;
      txrst_int    : OUT STD_LOGIC
   );
END cycloneiv_hssi_pcs_reset;

ARCHITECTURE trans OF cycloneiv_hssi_pcs_reset IS
   
   SIGNAL txrst_sync1 : STD_LOGIC := '0';
   SIGNAL txrst_sync2 : STD_LOGIC := '0';
   SIGNAL rxrst_sync1 : STD_LOGIC := '0';
   SIGNAL rxrst_sync2 : STD_LOGIC := '0';
BEGIN
   
   PROCESS (hard_reset, clk_2_b)
VARIABLE  txt : LINE;
   BEGIN
      IF (hard_reset = '1') THEN
         rxrst_sync2 <= '1';
         rxrst_sync1 <= '1';
      ELSIF (clk_2_b'EVENT AND clk_2_b = '1') THEN
         rxrst_sync2 <=  TRANSPORT rxrst_sync1 AFTER 1* 1 ps;
         rxrst_sync1 <= rxpcs_rst;
      END IF;
   END PROCESS;
   
   PROCESS (hard_reset, refclk_b_in)
VARIABLE  txt : LINE;
   BEGIN
      IF (hard_reset = '1') THEN
         txrst_sync2 <= '1';
         txrst_sync1 <= '1';
      ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
         txrst_sync2 <=  TRANSPORT txrst_sync1 AFTER 1* 1 ps;
         txrst_sync1 <= txpcs_rst;
      END IF;
   END PROCESS;
   
   -- 06-14-02 BT Changed SCAN_SHIFT signal to SCAN_MODE
   --assign rxrst_int = !SCAN_SHIFT & rxrst_sync2;
   --assign txrst_int = !SCAN_SHIFT & txrst_sync2;
   rxrst_int <= NOT(scan_mode) AND rxrst_sync2;
   txrst_int <= NOT(scan_mode) AND txrst_sync2;
   
END trans;



LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_digi_chnl_hip_spt IS
   PORT (
      
      rhip_ena                : IN STD_LOGIC;
      
      pcs_rxd_ch              : IN STD_LOGIC_VECTOR(8 DOWNTO 0);
      pcs_rxvalid             : IN STD_LOGIC;
      pcs_rxelecidle          : IN STD_LOGIC;
      pcs_rxstatus_ch         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      pcs_phystatus           : IN STD_LOGIC;
      txpma_local_clk         : IN STD_LOGIC;
      txd_ch                  : IN STD_LOGIC_VECTOR(10 DOWNTO 0);
      hip_txd_ch              : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
      txdetectrxloopback      : IN STD_LOGIC;
      hip_txdetectrxloopback  : IN STD_LOGIC;
      rxpolarity              : IN STD_LOGIC;
      hip_rxpolarity          : IN STD_LOGIC;
      powerdown_ch            : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      hip_powerdown_ch        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      txdeemph                : IN STD_LOGIC;
      hip_txdeemph            : IN STD_LOGIC;
      txmargin_ch             : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      hip_txmargin_ch         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel_ch        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      hip_eidleinfersel_ch    : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rate                    : IN STD_LOGIC;
      hip_rate                : IN STD_LOGIC;
      hip_txelecidle          : IN STD_LOGIC;
      
      rxd_ch                  : OUT STD_LOGIC_VECTOR(8 DOWNTO 0);
      hip_rxd_ch              : OUT STD_LOGIC_VECTOR(8 DOWNTO 0);
      rxvalid                 : OUT STD_LOGIC;
      hip_rxvalid             : OUT STD_LOGIC;
      rxelecidle              : OUT STD_LOGIC;
      hip_rxelecidle          : OUT STD_LOGIC;
      rxstatus_ch             : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      hip_rxstatus_ch         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      phystatus               : OUT STD_LOGIC;
      hip_phystatus           : OUT STD_LOGIC;
      hip_tx_clk              : OUT STD_LOGIC;
      pcs_txd_ch              : OUT STD_LOGIC_VECTOR(10 DOWNTO 0);
      pcs_txdetectrxloopback  : OUT STD_LOGIC;
      pcs_rxpolarity          : OUT STD_LOGIC;
      pcs_powerdown_ch        : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      pcs_txdeemph            : OUT STD_LOGIC;
      pcs_txmargin_ch         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      pcs_eidleinfersel_ch    : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      pcs_rate                : OUT STD_LOGIC
   );
END cycloneiv_hssi_digi_chnl_hip_spt;

ARCHITECTURE trans OF cycloneiv_hssi_digi_chnl_hip_spt IS
BEGIN
   
   --// SECTION for SPLIT signals
   --// ===============================
   --//
   -- MUX/SPLIT #5,6,7,8 in Excel spreadsheet
   rxd_ch <= pcs_rxd_ch;
   hip_rxd_ch <= pcs_rxd_ch WHEN (rhip_ena = '1') ELSE
                 "000000000";
   
   -- MUX/SPLIT #16 in Excel spreadsheet
   rxvalid <= pcs_rxvalid;
   hip_rxvalid <= pcs_rxvalid WHEN (rhip_ena = '1') ELSE
                  '0';
   
   -- MUX/SPLIT #17 in Excel spreadsheet
   rxelecidle <= pcs_rxelecidle;
   hip_rxelecidle <= pcs_rxelecidle WHEN (rhip_ena = '1') ELSE
                     '1';
   
   -- MUX/SPLIT #18,19,20,21 in Excel spreadsheet
   rxstatus_ch <= pcs_rxstatus_ch;
   hip_rxstatus_ch <= pcs_rxstatus_ch WHEN (rhip_ena = '1') ELSE
                      "000";
   
   -- MUX/SPLIT #22 in Excel spreadsheet
   phystatus <= pcs_phystatus;
   hip_phystatus <= pcs_phystatus WHEN (rhip_ena = '1') ELSE
                    '0';
   
   hip_tx_clk <= txpma_local_clk;
   
   --// SECTION for MUX signals
   --// ===============================
   --//
   -- MUX/SPLIT #1,2,3,4 in Excel spreadsheet
   pcs_txd_ch <= (hip_txelecidle & hip_txd_ch) WHEN (rhip_ena = '1') ELSE
                 txd_ch;
   
   -- MUX/SPLIT #10 in Excel spreadsheet
   pcs_txdetectrxloopback <= hip_txdetectrxloopback WHEN (rhip_ena = '1') ELSE
                             txdetectrxloopback;
   
   -- MUX/SPLIT #11 in Excel spreadsheet
   pcs_rxpolarity <= hip_rxpolarity WHEN (rhip_ena = '1') ELSE
                     rxpolarity;
   
   -- MUX/SPLIT #12,13,14,15 in Excel spreadsheet
   pcs_powerdown_ch <= hip_powerdown_ch WHEN (rhip_ena = '1') ELSE
                       powerdown_ch;
   
   -- MUX/SPLIT #23 in Excel spreadsheet
   pcs_txdeemph <= hip_txdeemph WHEN (rhip_ena = '1') ELSE
                   txdeemph;
   
   -- MUX/SPLIT #24,25,26,27 in Excel spreadsheet
   pcs_txmargin_ch <= hip_txmargin_ch WHEN (rhip_ena = '1') ELSE
                      txmargin_ch;
   
   -- MUX/SPLIT #28,29,30,31 in Excel spreadsheet
   pcs_eidleinfersel_ch <= hip_eidleinfersel_ch WHEN (rhip_ena = '1') ELSE
                           eidleinfersel_ch;
   
   -- MUX/SPLIT #32 in Excel spreadsheet
   pcs_rate <= hip_rate WHEN (rhip_ena = '1') ELSE
               rate;
   
END trans;





LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_phystatus_generator_fsm IS
   PORT (
      
      -- General signals
      
      --CRAM
      -- OR of rtx_pipe_enable and rrx_pipe_enable
      -- no toggle (gen 2) = 0, toggle (option for gen 1) = 1
      
      -- PLD Interface
      -- power state control
      -- communicate completion of power state transitions, receiver 
      -- detection, rate change
      
      -- Auto Negotiation Module
      -- asserted when signaling rate change between Gen 1 and Gen 2
      
      -- RX PIPE Interface
      --	p1_sync,
      
      -- PMA interface
      -- TX PMA
      -- rx_detect_bypass = 0 : Validation of rx_found: 
      -- 					synchronized at pipe_interface_top level
      -- rx_detect_bypass = 1 : delayed version of txdetectrx
      
      -- RX PMA
      -- asserted when successful power state transition occurs
      -- validates power_state_transition_done, currently tied to 0
      
      -- Latched Power State Signals
      -- P1 power state from TX PIPE interface
      
      -- Internal Power State Done Generator
      -- faked successful power state transition generated by internal	
      -- power state transition done module
      
      --********************************************************************************
      -- INCLUDE STATEMENTS
      --********************************************************************************
      
      --********************************************************************************
      -- I/O SIGNALS
      --********************************************************************************
      -- General signals
      clk                              : IN STD_LOGIC;
      reset_n                          : IN STD_LOGIC;
      
      -- CRAM
      phystat_ena                      : IN STD_LOGIC;
      rphystatus_rst_toggle            : IN STD_LOGIC;
      
      -- PLD Interface
      powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      phystatus                        : OUT STD_LOGIC;
      
      rindv_rx                         : IN STD_LOGIC;		-- Select between XAUI mode or indiv  channel mode
      rmaster_rx                       : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rmaster_up_rx                    : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      
      -- Auto Negotiation Module
      speed_change                     : IN STD_LOGIC;
      speed_change_centrl              : IN STD_LOGIC;
      speed_change_quad_up             : IN STD_LOGIC;
      speed_change_quad_down           : IN STD_LOGIC;
      
      -- RX PIPE Interface
      --output			p1_sync;
      
      -- PMA interface
      -- TX PMA
      rx_detect_valid                  : IN STD_LOGIC;
      
      -- RX PMA
      power_state_transition_done      : IN STD_LOGIC;
      power_state_transition_done_ena  : IN STD_LOGIC;
      
      -- Latched Power state signals
      p1                               : IN STD_LOGIC;		-- longer recovery time (64 us max) latency
      
      -- Internal Power State Done Generator
      internal_done                    : IN STD_LOGIC
   );
END cycloneiv_hssi_phystatus_generator_fsm;

ARCHITECTURE trans OF cycloneiv_hssi_phystatus_generator_fsm IS
   
   --********************************************************************************
   -- PARAMETERS
   --********************************************************************************
   
   --********************************************************************************
   -- DECLARATIONS
   --********************************************************************************
   --reg		phystatus;
   
   -- select between PMA done and internally generated done
   SIGNAL done                                 : STD_LOGIC;
   SIGNAL pre_power_state_transition_done_sync : STD_LOGIC;
   SIGNAL power_state_transition_done_sync     : STD_LOGIC;
   SIGNAL power_state_transition_done_sync_reg : STD_LOGIC;
   
   -- Reset condition
   SIGNAL reset_phystatus                      : STD_LOGIC;
   
   -- State transition
   SIGNAL state_transition_phystatus           : STD_LOGIC;
   
   -- Speed Negotiation
   SIGNAL speed_change_reg                     : STD_LOGIC;
   SIGNAL speed_change_sync                    : STD_LOGIC;
   SIGNAL speed_change_sync_reg                : STD_LOGIC;
   SIGNAL speed_change_phystatus               : STD_LOGIC;
   
   -- Receiver Detection
   --reg		p1_reg;				// synchronize from tx clk domain to rx clk domain
   --reg		p1_sync;
   
   SIGNAL rx_detect_valid_reg                  : STD_LOGIC;		-- Edge detection of receiver detection status signal
   SIGNAL rx_detect_valid_phystatus            : STD_LOGIC;
   
   -- P2 exit detection
   SIGNAL decode_p2                            : STD_LOGIC;
   SIGNAL decode_p2_reg                        : STD_LOGIC;
   SIGNAL decode_p2_reg1                       : STD_LOGIC;
   SIGNAL phystatus_high_sel                   : STD_LOGIC;
   SIGNAL phystatus_high_sel_reg               : STD_LOGIC;
   
   -- Reset
   SIGNAL phystatus_toggle_sel                 : STD_LOGIC;
   SIGNAL phystatus_toggle_sel_reg             : STD_LOGIC;
   
   SIGNAL pre_phystatus                        : STD_LOGIC;
   
   SIGNAL speed_change_local                   : STD_LOGIC;
   
   SIGNAL speed_change_centrl_del1             : STD_LOGIC;
   SIGNAL speed_change_centrl_del2             : STD_LOGIC;
BEGIN
   
   --********************************************************************************
   -- ASSIGN STATEMENTS
   --********************************************************************************
   -- Move to PLD interface
   phystatus <= '1' WHEN ((NOT(decode_p2) AND decode_p2_reg1) = '1') ELSE
                pre_phystatus;
   --assign phystatus= pre_phystatus;
   
   done <= (power_state_transition_done_sync AND NOT(power_state_transition_done_sync_reg)) WHEN (power_state_transition_done_ena = '1') ELSE
           internal_done;
   
   decode_p2 <= phystat_ena WHEN (powerdown = "11") ELSE
                '0';
   
   --********************************************************************************
   -- SUBMODULE INSTANTIATIONS
   --********************************************************************************
   
   --********************************************************************************
   -- MAIN CODE
   --********************************************************************************
   -- Reset phystatus generation
   
   -- Phystatus is asserted during reset and then the successful 'transition' into P1 is signal by the assertion
   -- phystatus for 1 cycle.  Unlike regular operation, the first entry into P1 is not indicated by a 'done' signal
   -- The assertion of phystatus occurs 4 cycles after reset is released
   PROCESS (reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         reset_phystatus <= '1';
      ELSE
         reset_phystatus <= '0';
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, rphystatus_rst_toggle, done, phystatus_toggle_sel_reg)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         phystatus_toggle_sel <= '1';
      ELSIF ((rphystatus_rst_toggle OR done) = '1') THEN
         phystatus_toggle_sel <= '0';
      ELSE
         phystatus_toggle_sel <= phystatus_toggle_sel_reg;
      END IF;
   END PROCESS;
   
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         phystatus_toggle_sel_reg <=  TRANSPORT '1' AFTER 1* 1 ps;
         phystatus_high_sel_reg <=  TRANSPORT '1' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         phystatus_toggle_sel_reg <=  TRANSPORT phystatus_toggle_sel AFTER 1* 1 ps;
         phystatus_high_sel_reg <=  TRANSPORT phystatus_high_sel AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   -- State transition: sync PMA signal to local clk.  Currently not being used
   -- State transition: Internal done generator indicates that there was a successful state transition.  
   -- Illegal transitions have been taken into account by the previous module.
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         pre_power_state_transition_done_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
         power_state_transition_done_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
         
         power_state_transition_done_sync_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         pre_power_state_transition_done_sync <=  TRANSPORT power_state_transition_done AFTER 1* 1 ps;
         power_state_transition_done_sync <=  TRANSPORT pre_power_state_transition_done_sync AFTER 1* 1 ps;
         
         power_state_transition_done_sync_reg <=  TRANSPORT power_state_transition_done_sync AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, done)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         state_transition_phystatus <= '0';
      ELSIF (done = '1') THEN
            state_transition_phystatus <= '1';
         ELSE
            state_transition_phystatus <= '0';
         END IF;
   END PROCESS;
   
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         speed_change_centrl_del1 <=  TRANSPORT '0' AFTER 1* 1 ps;
         
         speed_change_centrl_del2 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         speed_change_centrl_del1 <=  TRANSPORT speed_change_centrl AFTER 1* 1 ps;
         speed_change_centrl_del2 <=  TRANSPORT speed_change_centrl_del1 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   -- always @ (posedge clk or negedge reset_n)
   
   speed_change_local <= speed_change WHEN (rindv_rx = '1') ELSE
                         speed_change_centrl_del2 WHEN (rmaster_rx = '1') ELSE
                         speed_change_quad_up WHEN (rmaster_up_rx = '1') ELSE
                         speed_change_quad_down;
   
   -- Speed Negotiation
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         speed_change_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
         speed_change_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
         
         speed_change_sync_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         speed_change_reg <=  TRANSPORT speed_change_local AFTER 1* 1 ps;
         speed_change_sync <=  TRANSPORT speed_change_reg AFTER 1* 1 ps;
         speed_change_sync_reg <=  TRANSPORT speed_change_sync AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, speed_change_sync, speed_change_sync_reg)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         speed_change_phystatus <= '0';
      ELSIF ((NOT(speed_change_sync) AND speed_change_sync_reg) = '1') THEN
         speed_change_phystatus <= '1';
      ELSE
         speed_change_phystatus <= '0';
      END IF;
   END PROCESS;
   
   -- Receiver Detection
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         --		p1_reg					<= 1'b0;
         --		p1_sync					<= 1'b0;
         
         --		rx_detect_valid_phystatus	<= 1'b0;
         rx_detect_valid_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         --		p1_reg					<= p1;
         --		p1_sync					<= p1_reg;
         
         --		rx_detect_valid_phystatus	<= p1_sync && rx_detect_valid && !rx_detect_valid_reg;
         rx_detect_valid_reg <=  TRANSPORT rx_detect_valid AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, p1, rx_detect_valid, rx_detect_valid_reg)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         --	else if (p1_sync && rx_detect_valid && !rx_detect_valid_reg)
         rx_detect_valid_phystatus <= '0';
      ELSIF ((p1 AND rx_detect_valid AND NOT(rx_detect_valid_reg)) = '1') THEN
         rx_detect_valid_phystatus <= '1';
      ELSE
         
         rx_detect_valid_phystatus <= '0';
      END IF;
   END PROCESS;
   
   -- P2 state exit Detection
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         decode_p2_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
         decode_p2_reg1 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         decode_p2_reg <=  TRANSPORT decode_p2 AFTER 1* 1 ps;
         decode_p2_reg1 <=  TRANSPORT decode_p2_reg AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, decode_p2, decode_p2_reg, phystatus_high_sel_reg, done)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         phystatus_high_sel <= '0';
      ELSIF ((NOT(decode_p2) AND decode_p2_reg) = '1') THEN
         phystatus_high_sel <= '1';
      ELSIF (done = '1') THEN
         phystatus_high_sel <= '0';
      ELSE
         phystatus_high_sel <= phystatus_high_sel_reg;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, phystatus_high_sel, reset_phystatus, state_transition_phystatus, rx_detect_valid_phystatus, phystatus_toggle_sel, speed_change_phystatus)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         pre_phystatus <= '1';
      ELSE
         IF ((phystatus_high_sel OR reset_phystatus OR state_transition_phystatus OR rx_detect_valid_phystatus OR phystatus_toggle_sel OR speed_change_phystatus) = '1') THEN
            pre_phystatus <= '1';
         ELSE
            pre_phystatus <= '0';
         END IF;
      END IF;
   END PROCESS;
   
END trans;


-- always @ (reset_n or phystatus_high_sel or reset_phystatus or state_transition_phystatus or rx_detect_valid_phystatus...

-- phystatus_generator_fsm--IP Functional Simulation Model
--VERSION_BEGIN 10.0SP1 cbx_mgl 2010:08:18:21:20:44:SJ cbx_simgen 2010:08:18:21:16:35:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 53 oper_mux 1 cycloneiv_hssi_phystatus_generator_fsm 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  cycloneiv_hssi_phystatus_generator IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p0	:	IN  STD_LOGIC;
		 latched_p0s	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 latched_p2	:	IN  STD_LOGIC;
		 phystat_ena	:	IN  STD_LOGIC;
		 phystatus	:	OUT  STD_LOGIC;
		 power_state_transition_done	:	IN  STD_LOGIC;
		 power_state_transition_done_ena	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 reset_n	:	IN  STD_LOGIC;
		 rindv_rx	:	IN  STD_LOGIC;
		 rmaster_rx	:	IN  STD_LOGIC;
		 rmaster_up_rx	:	IN  STD_LOGIC;
		 rphystatus_delay	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rphystatus_rst_toggle	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC;
		 speed_change	:	IN  STD_LOGIC;
		 speed_change_centrl	:	IN  STD_LOGIC;
		 speed_change_quad_down	:	IN  STD_LOGIC;
		 speed_change_quad_up	:	IN  STD_LOGIC
	 ); 
 END cycloneiv_hssi_phystatus_generator;

 ARCHITECTURE RTL OF cycloneiv_hssi_phystatus_generator IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nllOi21	:	STD_LOGIC := '0';
	 SIGNAL	 nllOi22	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllOi22_w_lg_w_lg_q82w83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOi22_w_lg_q82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllOl19	:	STD_LOGIC := '0';
	 SIGNAL	 nllOl20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllOl20_w_lg_w_lg_q79w80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOl20_w_lg_q79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllOO17	:	STD_LOGIC := '0';
	 SIGNAL	 nllOO18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllOO18_w_lg_w_lg_q72w73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOO18_w_lg_q72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlO0l11	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0l12	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1i15	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1i16	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1O13	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1O14	:	STD_LOGIC := '0';
	 SIGNAL	 nlOii10	:	STD_LOGIC := '0';
	 SIGNAL	 nlOii9	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil7	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil8	:	STD_LOGIC := '0';
	 SIGNAL	 nlOli5	:	STD_LOGIC := '0';
	 SIGNAL	 nlOli6	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlO3	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlO4	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOl1	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOl2	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL	niii	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0O_CLRN	:	STD_LOGIC;
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n01i	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1OO	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	niil	:	STD_LOGIC := '0';
	 SIGNAL	niiO	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	nill	:	STD_LOGIC := '0';
	 SIGNAL	nilO	:	STD_LOGIC := '0';
	 SIGNAL	niOi	:	STD_LOGIC := '0';
	 SIGNAL	niOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1i	:	STD_LOGIC := '0';
	 SIGNAL	wire_niOO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_niOO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_niOO_w_lg_w_lg_w_lg_w_lg_nill7w9w11w12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_w_lg_nill7w9w11w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_w_lg_nill7w9w16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_nill7w9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_nill7w24w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_nill32w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_niil17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_niiO10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_nili8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_nill7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Oi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0O_phystatus	:	STD_LOGIC;
	 SIGNAL  wire_nl0O_powerdown	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_w_lg_power_state_transition_done_ena60w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nlO0O :	STD_LOGIC;
	 SIGNAL  nlOiO :	STD_LOGIC;
	 COMPONENT  cycloneiv_hssi_phystatus_generator_fsm
	 PORT
	 ( 
		clk	:	IN STD_LOGIC;
		internal_done	:	IN STD_LOGIC;
		p1	:	IN STD_LOGIC;
		phystat_ena	:	IN STD_LOGIC;
		phystatus	:	OUT STD_LOGIC;
		power_state_transition_done	:	IN STD_LOGIC;
		power_state_transition_done_ena	:	IN STD_LOGIC;
		powerdown	:	IN STD_LOGIC_VECTOR(1 DOWNTO 0);
		reset_n	:	IN STD_LOGIC;
		rindv_rx	:	IN STD_LOGIC;
		rmaster_rx	:	IN STD_LOGIC;
		rmaster_up_rx	:	IN STD_LOGIC;
		rphystatus_rst_toggle	:	IN STD_LOGIC;
		rx_detect_valid	:	IN STD_LOGIC;
		speed_change	:	IN STD_LOGIC;
		speed_change_centrl	:	IN STD_LOGIC;
		speed_change_quad_down	:	IN STD_LOGIC;
		speed_change_quad_up	:	IN STD_LOGIC
	 ); 
	 END COMPONENT;
 BEGIN

	wire_w_lg_power_state_transition_done_ena60w(0) <= NOT power_state_transition_done_ena;
	nlO0O <= '1';
	nlOiO <= ((((((wire_niOO_w_lg_w_lg_w_lg_w_lg_nill7w9w11w12w(0) AND (nlOOl2 XOR nlOOl1)) OR (wire_niOO_w_lg_w_lg_w_lg_nill7w9w16w(0) AND wire_niOO_w_lg_niil17w(0))) OR (NOT (nlOlO4 XOR nlOlO3))) OR ((wire_niOO_w_lg_w_lg_nill7w24w(0) AND wire_niOO_w_lg_niiO10w(0)) AND wire_niOO_w_lg_niil17w(0))) OR (NOT (nlOli6 XOR nlOli5))) OR ((wire_niOO_w_lg_nill32w(0) AND wire_niOO_w_lg_niiO10w(0)) AND wire_niOO_w_lg_niil17w(0)));
	phystatus <= wire_nl0O_phystatus;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOi21 <= nllOi22;
		END IF;
		if (now = 0 ns) then
			nllOi21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOi22 <= nllOi21;
		END IF;
	END PROCESS;
	wire_nllOi22_w_lg_w_lg_q82w83w(0) <= wire_nllOi22_w_lg_q82w(0) AND n1OO;
	wire_nllOi22_w_lg_q82w(0) <= nllOi22 XOR nllOi21;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOl19 <= nllOl20;
		END IF;
		if (now = 0 ns) then
			nllOl19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOl20 <= nllOl19;
		END IF;
	END PROCESS;
	wire_nllOl20_w_lg_w_lg_q79w80w(0) <= wire_nllOl20_w_lg_q79w(0) AND n01i;
	wire_nllOl20_w_lg_q79w(0) <= nllOl20 XOR nllOl19;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOO17 <= nllOO18;
		END IF;
		if (now = 0 ns) then
			nllOO17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOO18 <= nllOO17;
		END IF;
	END PROCESS;
	wire_nllOO18_w_lg_w_lg_q72w73w(0) <= wire_nllOO18_w_lg_q72w(0) AND n00l;
	wire_nllOO18_w_lg_q72w(0) <= nllOO18 XOR nllOO17;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0l11 <= nlO0l12;
		END IF;
		if (now = 0 ns) then
			nlO0l11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0l12 <= nlO0l11;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1i15 <= nlO1i16;
		END IF;
		if (now = 0 ns) then
			nlO1i15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1i16 <= nlO1i15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1O13 <= nlO1O14;
		END IF;
		if (now = 0 ns) then
			nlO1O13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1O14 <= nlO1O13;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOii10 <= nlOii9;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOii9 <= nlOii10;
		END IF;
		if (now = 0 ns) then
			nlOii9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOil7 <= nlOil8;
		END IF;
		if (now = 0 ns) then
			nlOil7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOil8 <= nlOil7;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOli5 <= nlOli6;
		END IF;
		if (now = 0 ns) then
			nlOli5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOli6 <= nlOli5;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlO3 <= nlOlO4;
		END IF;
		if (now = 0 ns) then
			nlOlO3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlO4 <= nlOlO3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOl1 <= nlOOl2;
		END IF;
		if (now = 0 ns) then
			nlOOl1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOl2 <= nlOOl1;
		END IF;
	END PROCESS;
	PROCESS (clk, wire_ni0O_CLRN)
	BEGIN
		IF (wire_ni0O_CLRN = '0') THEN
				ni0i <= '0';
				ni0l <= '0';
				ni1O <= '0';
				niii <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
			IF (nlOiO = '1') THEN
				ni0i <= niiO;
				ni0l <= nili;
				ni1O <= niil;
				niii <= nill;
			END IF;
		END IF;
	END PROCESS;
	wire_ni0O_CLRN <= ((nlO0l12 XOR nlO0l11) AND reset_n);
	PROCESS (clk, wire_niOO_PRN, wire_niOO_CLRN)
	BEGIN
		IF (wire_niOO_PRN = '0') THEN
				n00i <= '1';
				n00l <= '1';
				n00O <= '1';
				n01i <= '1';
				n01l <= '1';
				n01O <= '1';
				n0ii <= '1';
				n0il <= '1';
				n0iO <= '1';
				n0li <= '1';
				n0ll <= '1';
				n0lO <= '1';
				n0Ol <= '1';
				n0OO <= '1';
				n1lO <= '1';
				n1Ol <= '1';
				n1OO <= '1';
				ni1i <= '1';
				ni1l <= '1';
				niil <= '1';
				niiO <= '1';
				nili <= '1';
				nill <= '1';
				nilO <= '1';
				niOi <= '1';
				niOl <= '1';
				nl1i <= '1';
		ELSIF (wire_niOO_CLRN = '0') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n01i <= '0';
				n01l <= '0';
				n01O <= '0';
				n0ii <= '0';
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n1lO <= '0';
				n1Ol <= '0';
				n1OO <= '0';
				ni1i <= '0';
				ni1l <= '0';
				niil <= '0';
				niiO <= '0';
				nili <= '0';
				nill <= '0';
				nilO <= '0';
				niOi <= '0';
				niOl <= '0';
				nl1i <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n00i <= n00l;
				n00l <= n0ii;
				n00O <= wire_n1Oi_o;
				n01i <= n01l;
				n01l <= n01O;
				n01O <= n00i;
				n0ii <= n0il;
				n0il <= n0iO;
				n0iO <= n0li;
				n0li <= n0ll;
				n0ll <= ((phystat_ena AND wire_w_lg_power_state_transition_done_ena60w(0)) AND n0lO);
				n0lO <= (NOT (((((NOT ((ni1O XOR n0Ol) XOR (NOT (nlO1O14 XOR nlO1O13)))) AND (NOT (ni0i XOR n0OO))) AND (NOT (ni0l XOR ni1i))) AND (NOT (niii XOR ni1l))) AND (nlO1i16 XOR nlO1i15)));
				n0Ol <= ni1O;
				n0OO <= ni0i;
				n1lO <= n1Ol;
				n1Ol <= n1OO;
				n1OO <= n01i;
				ni1i <= ni0l;
				ni1l <= niii;
				niil <= nilO;
				niiO <= niOi;
				nili <= niOl;
				nill <= nl1i;
				nilO <= latched_p0;
				niOi <= latched_p0s;
				niOl <= latched_p1;
				nl1i <= latched_p2;
		END IF;
	END PROCESS;
	wire_niOO_CLRN <= ((nlOil8 XOR nlOil7) AND reset_n);
	wire_niOO_PRN <= (nlOii10 XOR nlOii9);
	wire_niOO_w_lg_w_lg_w_lg_w_lg_nill7w9w11w12w(0) <= wire_niOO_w_lg_w_lg_w_lg_nill7w9w11w(0) AND niil;
	wire_niOO_w_lg_w_lg_w_lg_nill7w9w11w(0) <= wire_niOO_w_lg_w_lg_nill7w9w(0) AND wire_niOO_w_lg_niiO10w(0);
	wire_niOO_w_lg_w_lg_w_lg_nill7w9w16w(0) <= wire_niOO_w_lg_w_lg_nill7w9w(0) AND niiO;
	wire_niOO_w_lg_w_lg_nill7w9w(0) <= wire_niOO_w_lg_nill7w(0) AND wire_niOO_w_lg_nili8w(0);
	wire_niOO_w_lg_w_lg_nill7w24w(0) <= wire_niOO_w_lg_nill7w(0) AND nili;
	wire_niOO_w_lg_nill32w(0) <= nill AND wire_niOO_w_lg_nili8w(0);
	wire_niOO_w_lg_niil17w(0) <= NOT niil;
	wire_niOO_w_lg_niiO10w(0) <= NOT niiO;
	wire_niOO_w_lg_nili8w(0) <= NOT nili;
	wire_niOO_w_lg_nill7w(0) <= NOT nill;
	wire_n1Oi_data <= ( n1lO & n1Ol & wire_nllOi22_w_lg_w_lg_q82w83w & wire_nllOl20_w_lg_w_lg_q79w80w & n01l & n01O & n00i & wire_nllOO18_w_lg_w_lg_q72w73w);
	wire_n1Oi_sel <= ( rphystatus_delay(2 DOWNTO 0));
	n1Oi :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1Oi_data,
		o => wire_n1Oi_o,
		sel => wire_n1Oi_sel
	  );
	wire_nl0O_powerdown <= ( powerdown(1 DOWNTO 0));
	nl0O :  cycloneiv_hssi_phystatus_generator_fsm
	  PORT MAP ( 
		clk => clk,
		internal_done => n00O,
		p1 => latched_p1,
		phystat_ena => phystat_ena,
		phystatus => wire_nl0O_phystatus,
		power_state_transition_done => power_state_transition_done,
		power_state_transition_done_ena => power_state_transition_done_ena,
		powerdown => wire_nl0O_powerdown,
		reset_n => reset_n,
		rindv_rx => rindv_rx,
		rmaster_rx => rmaster_rx,
		rmaster_up_rx => rmaster_up_rx,
		rphystatus_rst_toggle => rphystatus_rst_toggle,
		rx_detect_valid => rx_detect_valid,
		speed_change => speed_change,
		speed_change_centrl => speed_change_centrl,
		speed_change_quad_down => speed_change_quad_down,
		speed_change_quad_up => speed_change_quad_up
	  );

 END RTL; --cycloneiv_hssi_phystatus_generator
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 10.0SP1 cbx_mgl 2010:08:18:21:20:44:SJ cbx_simgen 2010:08:18:21:16:35:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

--synthesis_resources = lut 50 mux21 146 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  cycloneiv_hssi_rx_pipe_interface IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 polinv_rx	:	IN  STD_LOGIC;
		 polinv_rx_int	:	OUT  STD_LOGIC;
		 rclkcmpinsertpad	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rind_error_reporting	:	IN  STD_LOGIC;
		 rrdwidth_rx	:	IN  STD_LOGIC;
		 rrx_pipe_enable	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC;
		 rx_detect_valid_sync	:	IN  STD_LOGIC;
		 rx_found	:	IN  STD_LOGIC;
		 rx_found_sync	:	IN  STD_LOGIC;
		 rxd	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxd_ch	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxelecidle	:	OUT  STD_LOGIC;
		 rxelectricalidle	:	IN  STD_LOGIC;
		 rxpolarity	:	IN  STD_LOGIC;
		 rxstatus	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxvalid	:	OUT  STD_LOGIC;
		 sigdetni	:	IN  STD_LOGIC;
		 txdetectrx	:	IN  STD_LOGIC
	 ); 
 END cycloneiv_hssi_rx_pipe_interface;

 ARCHITECTURE RTL OF cycloneiv_hssi_rx_pipe_interface IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 n110l7	:	STD_LOGIC := '0';
	 SIGNAL	 n110l8	:	STD_LOGIC := '0';
	 SIGNAL  wire_n110l8_w_lg_q84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n111i11	:	STD_LOGIC := '0';
	 SIGNAL	 n111i12	:	STD_LOGIC := '0';
	 SIGNAL  wire_n111i12_w_lg_q92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n111O10	:	STD_LOGIC := '0';
	 SIGNAL  wire_n111O10_w_lg_q88w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n111O9	:	STD_LOGIC := '0';
	 SIGNAL	 n11ii5	:	STD_LOGIC := '0';
	 SIGNAL	 n11ii6	:	STD_LOGIC := '0';
	 SIGNAL  wire_n11ii6_w_lg_q77w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n11iO3	:	STD_LOGIC := '0';
	 SIGNAL	 n11iO4	:	STD_LOGIC := '0';
	 SIGNAL	 n11Ol1	:	STD_LOGIC := '0';
	 SIGNAL	 n11Ol2	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0ll41	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0ll42	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0Oi39	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0Oi40	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0OO37	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0OO38	:	STD_LOGIC := '0';
	 SIGNAL	 nlOi0l35	:	STD_LOGIC := '0';
	 SIGNAL	 nlOi0l36	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiil33	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiil34	:	STD_LOGIC := '0';
	 SIGNAL	 nlOilO31	:	STD_LOGIC := '0';
	 SIGNAL	 nlOilO32	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiOl29	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiOl30	:	STD_LOGIC := '0';
	 SIGNAL	 nlOl1l27	:	STD_LOGIC := '0';
	 SIGNAL	 nlOl1l28	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlii25	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlii26	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlli23	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlli24	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlOi21	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlOi22	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO0i17	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO0i18	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO1i19	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO1i20	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOiO15	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOiO16	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOOl13	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOOl14	:	STD_LOGIC := '0';
	 SIGNAL	n00ii	:	STD_LOGIC := '0';
	 SIGNAL	n0ill	:	STD_LOGIC := '0';
	 SIGNAL	n0iOi	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l	:	STD_LOGIC := '0';
	 SIGNAL	n1O0i	:	STD_LOGIC := '0';
	 SIGNAL	n1O1O	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0ilO_w_lg_w_lg_w_lg_n0iOi81w94w95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_w_lg_w_lg_n1O0i73w79w80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_w_lg_n0iOi81w94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_w_lg_n1O0i73w79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_n0iOi81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_n1O0i73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlOOO	:	STD_LOGIC := '0';
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_rrdwidth_rx82w85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rx_detect_valid_sync90w93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rx_detect_valid_sync75w78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rx_found_sync86w89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlO0iO267w268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlOl0l211w212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_latched_p174w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOl0i226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOl0i220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOii110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rclkcmpinsertpad227w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rclkcmpinsertpad221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rrdwidth_rx82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync90w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync75w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_found_sync86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range52w279w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range20w235w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO00l272w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0iO267w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0li263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOili225w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOl0l211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOliO197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rclkcmpinsertpad205w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset_n72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rind_error_reporting109w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rrdwidth_rx199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_sigdetni66w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range51w277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range19w233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n11lO :	STD_LOGIC;
	 SIGNAL  nlO00i :	STD_LOGIC;
	 SIGNAL  nlO00l :	STD_LOGIC;
	 SIGNAL  nlO00O :	STD_LOGIC;
	 SIGNAL  nlO01i :	STD_LOGIC;
	 SIGNAL  nlO01l :	STD_LOGIC;
	 SIGNAL  nlO01O :	STD_LOGIC;
	 SIGNAL  nlO0ii :	STD_LOGIC;
	 SIGNAL  nlO0il :	STD_LOGIC;
	 SIGNAL  nlO0iO :	STD_LOGIC;
	 SIGNAL  nlO0li :	STD_LOGIC;
	 SIGNAL  nlOi0i :	STD_LOGIC;
	 SIGNAL  nlOi1l :	STD_LOGIC;
	 SIGNAL  nlOi1O :	STD_LOGIC;
	 SIGNAL  nlOiii :	STD_LOGIC;
	 SIGNAL  nlOili :	STD_LOGIC;
	 SIGNAL  nlOill :	STD_LOGIC;
	 SIGNAL  nlOl0i :	STD_LOGIC;
	 SIGNAL  nlOl0l :	STD_LOGIC;
	 SIGNAL  nlOl0O :	STD_LOGIC;
	 SIGNAL  nlOl1i :	STD_LOGIC;
	 SIGNAL  nlOliO :	STD_LOGIC;
	 SIGNAL  nlOllO :	STD_LOGIC;
	 SIGNAL  nlOlOO :	STD_LOGIC;
	 SIGNAL  nlOO0O :	STD_LOGIC;
	 SIGNAL  nlOO1O :	STD_LOGIC;
	 SIGNAL  nlOOii :	STD_LOGIC;
	 SIGNAL  nlOOil :	STD_LOGIC;
	 SIGNAL  nlOOll :	STD_LOGIC;
	 SIGNAL  nlOOlO :	STD_LOGIC;
	 SIGNAL  nlOOOi :	STD_LOGIC;
	 SIGNAL  wire_w_rxd_range52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_lg_rrdwidth_rx82w85w(0) <= wire_w_lg_rrdwidth_rx82w(0) AND wire_n110l8_w_lg_q84w(0);
	wire_w_lg_w_lg_rx_detect_valid_sync90w93w(0) <= wire_w_lg_rx_detect_valid_sync90w(0) AND wire_n111i12_w_lg_q92w(0);
	wire_w_lg_w_lg_rx_detect_valid_sync75w78w(0) <= wire_w_lg_rx_detect_valid_sync75w(0) AND wire_n11ii6_w_lg_q77w(0);
	wire_w_lg_w_lg_rx_found_sync86w89w(0) <= wire_w_lg_rx_found_sync86w(0) AND wire_n111O10_w_lg_q88w(0);
	wire_w_lg_w_lg_nlO0iO267w268w(0) <= wire_w_lg_nlO0iO267w(0) AND nlO0il;
	wire_w_lg_w_lg_nlOl0l211w212w(0) <= wire_w_lg_nlOl0l211w(0) AND nlOl0i;
	wire_w_lg_latched_p174w(0) <= latched_p1 AND rx_found_sync;
	wire_w_lg_nlOl0i226w(0) <= nlOl0i AND wire_w_lg_nlOili225w(0);
	wire_w_lg_nlOl0i220w(0) <= nlOl0i AND nlOili;
	wire_w_lg_nlOOii110w(0) <= nlOOii AND wire_w_lg_rind_error_reporting109w(0);
	wire_w_lg_rclkcmpinsertpad227w(0) <= rclkcmpinsertpad AND wire_w_lg_nlOl0i226w(0);
	wire_w_lg_rclkcmpinsertpad221w(0) <= rclkcmpinsertpad AND wire_w_lg_nlOl0i220w(0);
	wire_w_lg_rrdwidth_rx82w(0) <= rrdwidth_rx AND latched_p1;
	wire_w_lg_rx_detect_valid_sync90w(0) <= rx_detect_valid_sync AND wire_w_lg_w_lg_rx_found_sync86w89w(0);
	wire_w_lg_rx_detect_valid_sync75w(0) <= rx_detect_valid_sync AND wire_w_lg_latched_p174w(0);
	wire_w_lg_rx_detect_valid_sync193w(0) <= rx_detect_valid_sync AND wire_n0ilO_w_lg_n0iOi81w(0);
	wire_w_lg_rx_detect_valid_sync259w(0) <= rx_detect_valid_sync AND wire_n0ilO_w_lg_n1O0i73w(0);
	wire_w_lg_rx_found_sync86w(0) <= rx_found_sync AND wire_w_lg_w_lg_rrdwidth_rx82w85w(0);
	wire_w_lg_w_rxd_range52w279w(0) <= wire_w_rxd_range52w(0) AND wire_w_lg_w_rxd_range51w277w(0);
	wire_w_lg_w_rxd_range20w235w(0) <= wire_w_rxd_range20w(0) AND wire_w_lg_w_rxd_range19w233w(0);
	wire_w_lg_nlO00l272w(0) <= NOT nlO00l;
	wire_w_lg_nlO0iO267w(0) <= NOT nlO0iO;
	wire_w_lg_nlO0li263w(0) <= NOT nlO0li;
	wire_w_lg_nlOili225w(0) <= NOT nlOili;
	wire_w_lg_nlOl0l211w(0) <= NOT nlOl0l;
	wire_w_lg_nlOliO197w(0) <= NOT nlOliO;
	wire_w_lg_rclkcmpinsertpad205w(0) <= NOT rclkcmpinsertpad;
	wire_w_lg_reset_n72w(0) <= NOT reset_n;
	wire_w_lg_rind_error_reporting109w(0) <= NOT rind_error_reporting;
	wire_w_lg_rrdwidth_rx199w(0) <= NOT rrdwidth_rx;
	wire_w_lg_sigdetni66w(0) <= NOT sigdetni;
	wire_w_lg_w_rxd_range51w277w(0) <= NOT wire_w_rxd_range51w(0);
	wire_w_lg_w_rxd_range19w233w(0) <= NOT wire_w_rxd_range19w(0);
	n11lO <= '1';
	nlO00i <= (rclkcmpinsertpad AND (nlO0il AND nlO00l));
	nlO00l <= (((((((rxd(0) AND rxd(1)) AND rxd(2)) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	nlO00O <= (wire_w_lg_rclkcmpinsertpad205w(0) AND wire_w_lg_w_lg_nlO0iO267w268w(0));
	nlO01i <= ((NOT rxd(13)) AND wire_w_lg_w_rxd_range51w277w(0));
	nlO01l <= wire_w_lg_w_rxd_range52w279w(0);
	nlO01O <= (rclkcmpinsertpad AND (nlO0il AND wire_w_lg_nlO00l272w(0)));
	nlO0ii <= (wire_w_lg_rclkcmpinsertpad205w(0) AND (nlO0iO AND nlO0il));
	nlO0il <= ((NOT rxd(13)) AND rxd(14));
	nlO0iO <= ((((((((NOT rxd(0)) AND rxd(1)) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	nlO0li <= (wire_w_lg_rx_detect_valid_sync259w(0) AND (nlO0ll42 XOR nlO0ll41));
	nlOi0i <= (wire_w_lg_rclkcmpinsertpad227w(0) AND (nlOi0l36 XOR nlOi0l35));
	nlOi1l <= ((NOT rxd(45)) AND wire_w_lg_w_rxd_range19w233w(0));
	nlOi1O <= (wire_w_lg_w_rxd_range20w235w(0) AND (nlO0OO38 XOR nlO0OO37));
	nlOiii <= (wire_w_lg_rclkcmpinsertpad221w(0) AND (nlOiil34 XOR nlOiil33));
	nlOili <= ((((((((rxd(32) AND rxd(33)) AND rxd(34)) AND (NOT rxd(35))) AND rxd(36)) AND rxd(37)) AND rxd(38)) AND rxd(39)) AND (nlO0Oi40 XOR nlO0Oi39));
	nlOill <= ((wire_w_lg_rclkcmpinsertpad205w(0) AND (wire_w_lg_w_lg_nlOl0l211w212w(0) AND (nlOiOl30 XOR nlOiOl29))) AND (nlOilO32 XOR nlOilO31));
	nlOl0i <= ((NOT rxd(45)) AND rxd(46));
	nlOl0l <= ((((((((NOT rxd(32)) AND rxd(33)) AND rxd(34)) AND rxd(35)) AND rxd(36)) AND rxd(37)) AND rxd(38)) AND rxd(39));
	nlOl0O <= ((wire_w_lg_reset_n72w(0) OR wire_w_lg_rrdwidth_rx199w(0)) OR (NOT (nlOlii26 XOR nlOlii25)));
	nlOl1i <= ((wire_w_lg_rclkcmpinsertpad205w(0) AND (nlOl0l AND nlOl0i)) AND (nlOl1l28 XOR nlOl1l27));
	nlOliO <= (wire_w_lg_rx_detect_valid_sync193w(0) AND (nlOlli24 XOR nlOlli23));
	nlOllO <= ((reset_n AND rrdwidth_rx) AND (nlOlOi22 XOR nlOlOi21));
	nlOlOO <= ((wire_n10ii_dataout OR wire_n1OlO_dataout) OR (NOT (nlOO1i20 XOR nlOO1i19)));
	nlOO0O <= (nlOOii AND rind_error_reporting);
	nlOO1O <= (wire_w_lg_nlOOii110w(0) AND (nlOO0i18 XOR nlOO0i17));
	nlOOii <= (wire_n1liO_dataout OR wire_n00OO_dataout);
	nlOOil <= ((wire_n10il_dataout OR wire_n1OOi_dataout) OR (NOT (nlOOiO16 XOR nlOOiO15)));
	nlOOll <= (wire_n10iO_dataout OR wire_n1OOl_dataout);
	nlOOlO <= (wire_n1lll_dataout OR wire_n0i1l_dataout);
	nlOOOi <= (wire_n0ilO_w_lg_w_lg_w_lg_n1O0i73w79w80w(0) OR (wire_n0ilO_w_lg_w_lg_w_lg_n0iOi81w94w95w(0) AND (nlOOOl14 XOR nlOOOl13)));
	polinv_rx_int <= wire_n1iO_dataout;
	rxd_ch <= ( wire_ni_dataout & wire_nlO_dataout & wire_nll_dataout & wire_nli_dataout & wire_niO_dataout & wire_nil_dataout & wire_nii_dataout & wire_n0O_dataout & wire_n0l_dataout & wire_n0i_dataout & wire_n1O_dataout & wire_n1l_dataout & wire_n1i_dataout & wire_nlOO_dataout & wire_nlOl_dataout & wire_nlOi_dataout & wire_nllO_dataout & wire_nlll_dataout & wire_nlli_dataout & wire_nliO_dataout & wire_nlil_dataout & wire_nlii_dataout & wire_nl0O_dataout & wire_nl0l_dataout & wire_nl0i_dataout & wire_nl1O_dataout & wire_nl1l_dataout & wire_nl1i_dataout & wire_niOO_dataout & wire_niOl_dataout & wire_niOi_dataout & wire_nilO_dataout & wire_nill_dataout & wire_nili_dataout & wire_niiO_dataout & wire_niil_dataout & wire_niii_dataout & wire_ni0O_dataout & wire_ni0l_dataout & wire_ni0i_dataout & wire_ni1O_dataout & wire_ni1l_dataout & wire_ni1i_dataout & wire_n0OO_dataout & wire_n0Ol_dataout & wire_n0Oi_dataout & wire_n0lO_dataout & wire_n0ll_dataout & wire_n0li_dataout & wire_n0iO_dataout & wire_n0il_dataout & wire_n0ii_dataout & wire_n00O_dataout & wire_n00l_dataout & wire_n00i_dataout & wire_n01O_dataout & wire_n01l_dataout & wire_n01i_dataout & wire_n1OO_dataout & wire_n1Ol_dataout & wire_n1Oi_dataout & wire_n1lO_dataout & wire_n1ll_dataout & wire_n1li_dataout);
	rxelecidle <= wire_n1ii_dataout;
	rxstatus <= ( wire_n10O_dataout & wire_n10l_dataout & wire_n10i_dataout);
	rxvalid <= wire_n1il_dataout;
	wire_w_rxd_range52w(0) <= rxd(13);
	wire_w_rxd_range51w(0) <= rxd(14);
	wire_w_rxd_range20w(0) <= rxd(45);
	wire_w_rxd_range19w(0) <= rxd(46);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n110l7 <= n110l8;
		END IF;
		if (now = 0 ns) then
			n110l7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n110l8 <= n110l7;
		END IF;
	END PROCESS;
	wire_n110l8_w_lg_q84w(0) <= n110l8 XOR n110l7;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111i11 <= n111i12;
		END IF;
		if (now = 0 ns) then
			n111i11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111i12 <= n111i11;
		END IF;
	END PROCESS;
	wire_n111i12_w_lg_q92w(0) <= n111i12 XOR n111i11;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111O10 <= n111O9;
		END IF;
	END PROCESS;
	wire_n111O10_w_lg_q88w(0) <= n111O10 XOR n111O9;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111O9 <= n111O10;
		END IF;
		if (now = 0 ns) then
			n111O9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11ii5 <= n11ii6;
		END IF;
		if (now = 0 ns) then
			n11ii5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11ii6 <= n11ii5;
		END IF;
	END PROCESS;
	wire_n11ii6_w_lg_q77w(0) <= n11ii6 XOR n11ii5;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11iO3 <= n11iO4;
		END IF;
		if (now = 0 ns) then
			n11iO3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11iO4 <= n11iO3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11Ol1 <= n11Ol2;
		END IF;
		if (now = 0 ns) then
			n11Ol1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11Ol2 <= n11Ol1;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0ll41 <= nlO0ll42;
		END IF;
		if (now = 0 ns) then
			nlO0ll41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0ll42 <= nlO0ll41;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0Oi39 <= nlO0Oi40;
		END IF;
		if (now = 0 ns) then
			nlO0Oi39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0Oi40 <= nlO0Oi39;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0OO37 <= nlO0OO38;
		END IF;
		if (now = 0 ns) then
			nlO0OO37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0OO38 <= nlO0OO37;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOi0l35 <= nlOi0l36;
		END IF;
		if (now = 0 ns) then
			nlOi0l35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOi0l36 <= nlOi0l35;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiil33 <= nlOiil34;
		END IF;
		if (now = 0 ns) then
			nlOiil33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiil34 <= nlOiil33;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOilO31 <= nlOilO32;
		END IF;
		if (now = 0 ns) then
			nlOilO31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOilO32 <= nlOilO31;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiOl29 <= nlOiOl30;
		END IF;
		if (now = 0 ns) then
			nlOiOl29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiOl30 <= nlOiOl29;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOl1l27 <= nlOl1l28;
		END IF;
		if (now = 0 ns) then
			nlOl1l27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOl1l28 <= nlOl1l27;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlii25 <= nlOlii26;
		END IF;
		if (now = 0 ns) then
			nlOlii25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlii26 <= nlOlii25;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlli23 <= nlOlli24;
		END IF;
		if (now = 0 ns) then
			nlOlli23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlli24 <= nlOlli23;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlOi21 <= nlOlOi22;
		END IF;
		if (now = 0 ns) then
			nlOlOi21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlOi22 <= nlOlOi21;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO0i17 <= nlOO0i18;
		END IF;
		if (now = 0 ns) then
			nlOO0i17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO0i18 <= nlOO0i17;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO1i19 <= nlOO1i20;
		END IF;
		if (now = 0 ns) then
			nlOO1i19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO1i20 <= nlOO1i19;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOiO15 <= nlOOiO16;
		END IF;
		if (now = 0 ns) then
			nlOOiO15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOiO16 <= nlOOiO15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOOl13 <= nlOOOl14;
		END IF;
		if (now = 0 ns) then
			nlOOOl13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOOl14 <= nlOOOl13;
		END IF;
	END PROCESS;
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				n00ii <= '0';
				n0ill <= '0';
				n0iOi <= '0';
				n1l1l <= '0';
				n1O0i <= '0';
				n1O1O <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n00ii <= n0ill;
				n0ill <= txdetectrx;
				n0iOi <= rx_detect_valid_sync;
				n1l1l <= n1O1O;
				n1O0i <= rx_detect_valid_sync;
				n1O1O <= txdetectrx;
		END IF;
	END PROCESS;
	wire_n0ilO_w_lg_w_lg_w_lg_n0iOi81w94w95w(0) <= wire_n0ilO_w_lg_w_lg_n0iOi81w94w(0) AND n00ii;
	wire_n0ilO_w_lg_w_lg_w_lg_n1O0i73w79w80w(0) <= wire_n0ilO_w_lg_w_lg_n1O0i73w79w(0) AND n1l1l;
	wire_n0ilO_w_lg_w_lg_n0iOi81w94w(0) <= wire_n0ilO_w_lg_n0iOi81w(0) AND wire_w_lg_w_lg_rx_detect_valid_sync90w93w(0);
	wire_n0ilO_w_lg_w_lg_n1O0i73w79w(0) <= wire_n0ilO_w_lg_n1O0i73w(0) AND wire_w_lg_w_lg_rx_detect_valid_sync75w78w(0);
	wire_n0ilO_w_lg_n0iOi81w(0) <= NOT n0iOi;
	wire_n0ilO_w_lg_n1O0i73w(0) <= NOT n1O0i;
	PROCESS (clk, reset_n, wire_nl_CLRN)
	BEGIN
		IF (reset_n = '0') THEN
				nlOOO <= '1';
				nO <= '1';
		ELSIF (wire_nl_CLRN = '0') THEN
				nlOOO <= '0';
				nO <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				nlOOO <= rxelectricalidle;
				nO <= nlOOO;
		END IF;
	END PROCESS;
	wire_nl_CLRN <= (n11Ol2 XOR n11Ol1);
	wire_n000i_dataout <= (rxd(45) AND rxd(46)) AND NOT(nlOi0i);
	wire_n001i_dataout <= wire_n001O_dataout AND NOT(nlOill);
	wire_n001l_dataout <= nlOi0i AND NOT(nlOiii);
	wire_n001O_dataout <= wire_n000i_dataout AND NOT(nlOiii);
	wire_n00i_dataout <= rxd(9) AND rrx_pipe_enable;
	wire_n00l_dataout <= rxd(10) AND rrx_pipe_enable;
	wire_n00O_dataout <= rxd(11) AND rrx_pipe_enable;
	wire_n00OO_dataout <= rxd(43) AND (nlOllO AND wire_w_lg_nlOliO197w(0));
	wire_n010i_dataout <= wire_n01il_dataout AND NOT(nlOi1l);
	wire_n010l_dataout <= nlOi1O AND NOT(nlOi1l);
	wire_n010O_dataout <= wire_n01iO_dataout AND NOT(nlOi1l);
	wire_n011i_dataout <= wire_n010l_dataout AND NOT(nlOliO);
	wire_n011l_dataout <= wire_n010O_dataout AND NOT(nlOliO);
	wire_n011O_dataout <= wire_n01ii_dataout AND NOT(nlOliO);
	wire_n01i_dataout <= rxd(6) AND rrx_pipe_enable;
	wire_n01ii_dataout <= wire_n01li_dataout AND NOT(nlOi1l);
	wire_n01il_dataout <= wire_n01ll_dataout AND NOT(nlOi1O);
	wire_n01iO_dataout <= wire_n01lO_dataout AND NOT(nlOi1O);
	wire_n01l_dataout <= rxd(7) AND rrx_pipe_enable;
	wire_n01li_dataout <= wire_n01Oi_dataout AND NOT(nlOi1O);
	wire_n01ll_dataout <= wire_n01Ol_dataout AND NOT(nlOl1i);
	wire_n01lO_dataout <= wire_n01OO_dataout OR nlOl1i;
	wire_n01O_dataout <= rxd(8) AND rrx_pipe_enable;
	wire_n01Oi_dataout <= wire_n001i_dataout AND NOT(nlOl1i);
	wire_n01Ol_dataout <= wire_n001l_dataout OR nlOill;
	wire_n01OO_dataout <= nlOiii AND NOT(nlOill);
	wire_n0i_dataout <= rxd(54) AND rrx_pipe_enable;
	wire_n0i1l_dataout <= rxd(41) AND (nlOllO AND wire_w_lg_nlOliO197w(0));
	wire_n0ii_dataout <= rxd(12) AND rrx_pipe_enable;
	wire_n0il_dataout <= rxd(13) AND rrx_pipe_enable;
	wire_n0iO_dataout <= rxd(14) AND rrx_pipe_enable;
	wire_n0l_dataout <= rxd(55) AND rrx_pipe_enable;
	wire_n0li_dataout <= rxd(15) AND rrx_pipe_enable;
	wire_n0ll_dataout <= rxd(16) AND rrx_pipe_enable;
	wire_n0lO_dataout <= rxd(17) AND rrx_pipe_enable;
	wire_n0O_dataout <= rxd(56) AND rrx_pipe_enable;
	wire_n0Oi_dataout <= rxd(18) AND rrx_pipe_enable;
	wire_n0Ol_dataout <= rxd(19) AND rrx_pipe_enable;
	wire_n0OO_dataout <= rxd(20) AND rrx_pipe_enable;
	wire_n100O_dataout <= wire_n10li_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10i_dataout <= wire_nliOl_dataout WHEN rrx_pipe_enable = '1'  ELSE rx_found;
	wire_n10ii_dataout <= wire_n10ll_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10il_dataout <= wire_n10lO_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10iO_dataout <= wire_n10Oi_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10l_dataout <= wire_nliOO_dataout WHEN rrx_pipe_enable = '1'  ELSE rx_detect_valid;
	wire_n10li_dataout <= wire_n10Ol_dataout AND NOT(nlO0li);
	wire_n10ll_dataout <= wire_n10OO_dataout AND NOT(nlO0li);
	wire_n10lO_dataout <= wire_n1i1i_dataout AND NOT(nlO0li);
	wire_n10O_dataout <= wire_nll1i_dataout AND rrx_pipe_enable;
	wire_n10Oi_dataout <= wire_n1i1l_dataout AND NOT(nlO0li);
	wire_n10Ol_dataout <= wire_n1i1O_dataout AND NOT(nlO01i);
	wire_n10OO_dataout <= nlO01l AND NOT(nlO01i);
	wire_n11i_dataout <= wire_n11l_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n11l_dataout <= ((rxd(10) OR rxd(42)) OR (NOT (n11iO4 XOR n11iO3))) WHEN rrdwidth_rx = '1'  ELSE rxd(10);
	wire_n1i_dataout <= rxd(51) AND rrx_pipe_enable;
	wire_n1i0i_dataout <= wire_n1iii_dataout AND NOT(nlO01l);
	wire_n1i0l_dataout <= wire_n1iil_dataout AND NOT(nlO01l);
	wire_n1i0O_dataout <= wire_n1iiO_dataout AND NOT(nlO0ii);
	wire_n1i1i_dataout <= wire_n1i0i_dataout AND NOT(nlO01i);
	wire_n1i1l_dataout <= wire_n1i0l_dataout AND NOT(nlO01i);
	wire_n1i1O_dataout <= wire_n1i0O_dataout AND NOT(nlO01l);
	wire_n1ii_dataout <= wire_nlOOl_dataout WHEN rrx_pipe_enable = '1'  ELSE wire_w_lg_sigdetni66w(0);
	wire_n1iii_dataout <= wire_n1ili_dataout OR nlO0ii;
	wire_n1iil_dataout <= wire_n1ill_dataout AND NOT(nlO0ii);
	wire_n1iiO_dataout <= wire_n1ilO_dataout OR nlO00O;
	wire_n1il_dataout <= wire_n11i_dataout AND rrx_pipe_enable;
	wire_n1ili_dataout <= nlO00i AND NOT(nlO00O);
	wire_n1ill_dataout <= wire_n1iOi_dataout AND NOT(nlO00O);
	wire_n1ilO_dataout <= nlO01O AND NOT(nlO00i);
	wire_n1iO_dataout <= rxpolarity WHEN rrx_pipe_enable = '1'  ELSE polinv_rx;
	wire_n1iOi_dataout <= wire_n1iOl_dataout AND NOT(nlO00i);
	wire_n1iOl_dataout <= (rxd(13) AND rxd(14)) AND NOT(nlO01O);
	wire_n1l_dataout <= rxd(52) AND rrx_pipe_enable;
	wire_n1li_dataout <= rxd(0) AND rrx_pipe_enable;
	wire_n1liO_dataout <= rxd(11) AND (reset_n AND wire_w_lg_nlO0li263w(0));
	wire_n1ll_dataout <= rxd(1) AND rrx_pipe_enable;
	wire_n1lll_dataout <= rxd(9) AND (reset_n AND wire_w_lg_nlO0li263w(0));
	wire_n1lO_dataout <= rxd(2) AND rrx_pipe_enable;
	wire_n1O_dataout <= rxd(53) AND rrx_pipe_enable;
	wire_n1Oi_dataout <= rxd(3) AND rrx_pipe_enable;
	wire_n1Ol_dataout <= rxd(4) AND rrx_pipe_enable;
	wire_n1Oll_dataout <= wire_n1OOO_dataout AND NOT(nlOl0O);
	wire_n1OlO_dataout <= wire_n011i_dataout AND NOT(nlOl0O);
	wire_n1OO_dataout <= rxd(5) AND rrx_pipe_enable;
	wire_n1OOi_dataout <= wire_n011l_dataout AND NOT(nlOl0O);
	wire_n1OOl_dataout <= wire_n011O_dataout AND NOT(nlOl0O);
	wire_n1OOO_dataout <= wire_n010i_dataout AND NOT(nlOliO);
	wire_ni_dataout <= rxd(63) AND rrx_pipe_enable;
	wire_ni0i_dataout <= rxd(24) AND rrx_pipe_enable;
	wire_ni0l_dataout <= rxd(25) AND rrx_pipe_enable;
	wire_ni0O_dataout <= rxd(26) AND rrx_pipe_enable;
	wire_ni1i_dataout <= rxd(21) AND rrx_pipe_enable;
	wire_ni1l_dataout <= rxd(22) AND rrx_pipe_enable;
	wire_ni1O_dataout <= rxd(23) AND rrx_pipe_enable;
	wire_nii_dataout <= rxd(57) AND rrx_pipe_enable;
	wire_niii_dataout <= rxd(27) AND rrx_pipe_enable;
	wire_niil_dataout <= rxd(28) AND rrx_pipe_enable;
	wire_niiO_dataout <= rxd(29) AND rrx_pipe_enable;
	wire_nil_dataout <= rxd(58) AND rrx_pipe_enable;
	wire_nili_dataout <= rxd(30) AND rrx_pipe_enable;
	wire_nill_dataout <= rxd(31) AND rrx_pipe_enable;
	wire_nilO_dataout <= rxd(32) AND rrx_pipe_enable;
	wire_niO_dataout <= rxd(59) AND rrx_pipe_enable;
	wire_niOi_dataout <= rxd(33) AND rrx_pipe_enable;
	wire_niOl_dataout <= rxd(34) AND rrx_pipe_enable;
	wire_niOO_dataout <= rxd(35) AND rrx_pipe_enable;
	wire_nl0i_dataout <= rxd(39) AND rrx_pipe_enable;
	wire_nl0l_dataout <= rxd(40) AND rrx_pipe_enable;
	wire_nl0O_dataout <= rxd(41) AND rrx_pipe_enable;
	wire_nl1i_dataout <= rxd(36) AND rrx_pipe_enable;
	wire_nl1l_dataout <= rxd(37) AND rrx_pipe_enable;
	wire_nl1O_dataout <= rxd(38) AND rrx_pipe_enable;
	wire_nli_dataout <= rxd(60) AND rrx_pipe_enable;
	wire_nlii_dataout <= rxd(42) AND rrx_pipe_enable;
	wire_nlil_dataout <= rxd(43) AND rrx_pipe_enable;
	wire_nliO_dataout <= rxd(44) AND rrx_pipe_enable;
	wire_nliOl_dataout <= wire_nll1l_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_nliOO_dataout <= wire_nll1O_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_nll_dataout <= rxd(61) AND rrx_pipe_enable;
	wire_nll0i_dataout <= wire_nllii_dataout AND NOT(nlOOOi);
	wire_nll0l_dataout <= wire_nllil_dataout AND NOT(nlOOlO);
	wire_nll0O_dataout <= wire_nlliO_dataout AND NOT(nlOOlO);
	wire_nll1i_dataout <= wire_nll0i_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_nll1l_dataout <= wire_nll0l_dataout OR nlOOOi;
	wire_nll1O_dataout <= wire_nll0O_dataout OR nlOOOi;
	wire_nlli_dataout <= rxd(45) AND rrx_pipe_enable;
	wire_nllii_dataout <= wire_nllli_dataout OR nlOOlO;
	wire_nllil_dataout <= wire_nllll_dataout OR nlOOll;
	wire_nlliO_dataout <= wire_nlllO_dataout AND NOT(nlOOll);
	wire_nlll_dataout <= rxd(46) AND rrx_pipe_enable;
	wire_nllli_dataout <= wire_nllOi_dataout OR nlOOll;
	wire_nllll_dataout <= wire_nllOl_dataout AND NOT(nlOOil);
	wire_nlllO_dataout <= wire_nllOO_dataout OR nlOOil;
	wire_nllO_dataout <= rxd(47) AND rrx_pipe_enable;
	wire_nllOi_dataout <= wire_nlO1i_dataout OR nlOOil;
	wire_nllOl_dataout <= wire_nlO1l_dataout OR nlOO0O;
	wire_nllOO_dataout <= wire_nlO1O_dataout OR nlOO0O;
	wire_nlO_dataout <= rxd(62) AND rrx_pipe_enable;
	wire_nlO0i_dataout <= (wire_n100O_dataout OR wire_n1Oll_dataout) AND NOT(nlOlOO);
	wire_nlO1i_dataout <= nlOO1O OR nlOO0O;
	wire_nlO1l_dataout <= wire_nlO0i_dataout AND NOT(nlOO1O);
	wire_nlO1O_dataout <= nlOlOO AND NOT(nlOO1O);
	wire_nlOi_dataout <= rxd(48) AND rrx_pipe_enable;
	wire_nlOl_dataout <= rxd(49) AND rrx_pipe_enable;
	wire_nlOO_dataout <= rxd(50) AND rrx_pipe_enable;
	wire_nlOOl_dataout <= nO OR wire_w_lg_reset_n72w(0);

 END RTL; --cycloneiv_hssi_rx_pipe_interface
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 10.0SP1 cbx_mgl 2010:08:18:21:20:44:SJ cbx_simgen 2010:08:18:21:16:35:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 36 mux21 13 oper_mux 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  cycloneiv_hssi_tx_pipe_interface IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerstate	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 refclk_b	:	IN  STD_LOGIC;
		 refclk_b_reset_n	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rev_loopbk	:	OUT  STD_LOGIC;
		 revloopback	:	IN  STD_LOGIC;
		 rtx_elec_idle_delay	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rtx_pipe_enable	:	IN  STD_LOGIC;
		 rtxswing_sel_ena	:	IN  STD_LOGIC;
		 tx_elec_idle	:	OUT  STD_LOGIC;
		 tx_elec_idle_comp	:	IN  STD_LOGIC;
		 txd	:	OUT  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txd_ch	:	IN  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txdeemph	:	IN  STD_LOGIC;
		 txdeemph_int	:	OUT  STD_LOGIC;
		 txdetectrx	:	OUT  STD_LOGIC;
		 txdetectrxloopback	:	IN  STD_LOGIC;
		 txelecidle	:	IN  STD_LOGIC;
		 txmargin	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 txmargin_int	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 txswing	:	IN  STD_LOGIC;
		 txswing_int	:	OUT  STD_LOGIC
	 ); 
 END cycloneiv_hssi_tx_pipe_interface;

 ARCHITECTURE RTL OF cycloneiv_hssi_tx_pipe_interface IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 niiOl23	:	STD_LOGIC := '0';
	 SIGNAL	 niiOl24	:	STD_LOGIC := '0';
	 SIGNAL	 nil0i19	:	STD_LOGIC := '0';
	 SIGNAL	 nil0i20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil0i20_w_lg_w_lg_q190w191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil0i20_w_lg_q190w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nil0l17	:	STD_LOGIC := '0';
	 SIGNAL	 nil0l18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil0l18_w_lg_w_lg_q184w185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil0l18_w_lg_q184w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nil0O15	:	STD_LOGIC := '0';
	 SIGNAL	 nil0O16	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil0O16_w_lg_w_lg_q171w172w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil0O16_w_lg_q171w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nil1i21	:	STD_LOGIC := '0';
	 SIGNAL	 nil1i22	:	STD_LOGIC := '0';
	 SIGNAL	 nilii13	:	STD_LOGIC := '0';
	 SIGNAL	 nilii14	:	STD_LOGIC := '0';
	 SIGNAL	 niliO11	:	STD_LOGIC := '0';
	 SIGNAL	 niliO12	:	STD_LOGIC := '0';
	 SIGNAL	 nilli10	:	STD_LOGIC := '0';
	 SIGNAL	 nilli9	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi7	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi8	:	STD_LOGIC := '0';
	 SIGNAL	 nilOl5	:	STD_LOGIC := '0';
	 SIGNAL	 nilOl6	:	STD_LOGIC := '0';
	 SIGNAL	 niO1i3	:	STD_LOGIC := '0';
	 SIGNAL	 niO1i4	:	STD_LOGIC := '0';
	 SIGNAL	 niO1O1	:	STD_LOGIC := '0';
	 SIGNAL	 niO1O2	:	STD_LOGIC := '0';
	 SIGNAL	nl00i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1li	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl01O_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nl01O_PRN	:	STD_LOGIC;
	 SIGNAL	nl1lO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl1ll_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_PRN	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_ENA	:	STD_LOGIC;
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1OO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl1Ol_w_lg_nl1Oi168w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl11l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl11l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl11l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_powerdown_range196w204w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nilOO193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset_n194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rtx_pipe_enable151w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_powerdown_range198w199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nil1O :	STD_LOGIC;
	 SIGNAL  nilll :	STD_LOGIC;
	 SIGNAL  nillO :	STD_LOGIC;
	 SIGNAL  nilOO :	STD_LOGIC;
	 SIGNAL  wire_w_powerdown_range196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_powerdown_range198w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rtx_elec_idle_delay_range170w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_powerdown_range196w204w(0) <= wire_w_powerdown_range196w(0) AND wire_w_lg_w_powerdown_range198w199w(0);
	wire_w_lg_nilOO193w(0) <= NOT nilOO;
	wire_w_lg_reset_n194w(0) <= NOT reset_n;
	wire_w_lg_rtx_pipe_enable151w(0) <= NOT rtx_pipe_enable;
	wire_w_lg_w_powerdown_range198w199w(0) <= NOT wire_w_powerdown_range198w(0);
	nil1O <= (wire_w_lg_reset_n194w(0) OR wire_w_lg_rtx_pipe_enable151w(0));
	nilll <= '0';
	nillO <= '1';
	nilOO <= ((tx_elec_idle_comp OR nl1lO) OR (NOT (niO1i4 XOR niO1i3)));
	powerstate <= ( wire_nl0OO_dataout & wire_nl0Ol_dataout & wire_nl0Oi_dataout & wire_nl0lO_dataout);
	rev_loopbk <= wire_nl0iO_dataout;
	tx_elec_idle <= wire_nl0il_dataout;
	txd <= ( txd_ch(43 DOWNTO 0));
	txdeemph_int <= txdeemph;
	txdetectrx <= wire_nl00O_dataout;
	txmargin_int <= ( txmargin(2 DOWNTO 0));
	txswing_int <= wire_nl0ll_dataout;
	wire_w_powerdown_range196w(0) <= powerdown(0);
	wire_w_powerdown_range198w(0) <= powerdown(1);
	wire_w_rtx_elec_idle_delay_range170w(0) <= rtx_elec_idle_delay(0);
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niiOl23 <= niiOl24;
		END IF;
		if (now = 0 ns) then
			niiOl23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niiOl24 <= niiOl23;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0i19 <= nil0i20;
		END IF;
		if (now = 0 ns) then
			nil0i19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0i20 <= nil0i19;
		END IF;
	END PROCESS;
	wire_nil0i20_w_lg_w_lg_q190w191w(0) <= wire_nil0i20_w_lg_q190w(0) AND nl00i;
	wire_nil0i20_w_lg_q190w(0) <= nil0i20 XOR nil0i19;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0l17 <= nil0l18;
		END IF;
		if (now = 0 ns) then
			nil0l17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0l18 <= nil0l17;
		END IF;
	END PROCESS;
	wire_nil0l18_w_lg_w_lg_q184w185w(0) <= wire_nil0l18_w_lg_q184w(0) AND nl10O;
	wire_nil0l18_w_lg_q184w(0) <= nil0l18 XOR nil0l17;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0O15 <= nil0O16;
		END IF;
		if (now = 0 ns) then
			nil0O15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0O16 <= nil0O15;
		END IF;
	END PROCESS;
	wire_nil0O16_w_lg_w_lg_q171w172w(0) <= wire_nil0O16_w_lg_q171w(0) AND wire_w_rtx_elec_idle_delay_range170w(0);
	wire_nil0O16_w_lg_q171w(0) <= nil0O16 XOR nil0O15;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil1i21 <= nil1i22;
		END IF;
		if (now = 0 ns) then
			nil1i21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil1i22 <= nil1i21;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilii13 <= nilii14;
		END IF;
		if (now = 0 ns) then
			nilii13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilii14 <= nilii13;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niliO11 <= niliO12;
		END IF;
		if (now = 0 ns) then
			niliO11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niliO12 <= niliO11;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilli10 <= nilli9;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilli9 <= nilli10;
		END IF;
		if (now = 0 ns) then
			nilli9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOi7 <= nilOi8;
		END IF;
		if (now = 0 ns) then
			nilOi7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOi8 <= nilOi7;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOl5 <= nilOl6;
		END IF;
		if (now = 0 ns) then
			nilOl5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOl6 <= nilOl5;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1i3 <= niO1i4;
		END IF;
		if (now = 0 ns) then
			niO1i3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1i4 <= niO1i3;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1O1 <= niO1O2;
		END IF;
		if (now = 0 ns) then
			niO1O1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1O2 <= niO1O1;
		END IF;
	END PROCESS;
	PROCESS (refclk_b, wire_nl01O_PRN, wire_nl01O_CLRN)
	BEGIN
		IF (wire_nl01O_PRN = '0') THEN
				nl00i <= '1';
				nl10i <= '1';
				nl10l <= '1';
				nl10O <= '1';
				nl11O <= '1';
				nl1ii <= '1';
				nl1il <= '1';
				nl1iO <= '1';
				nl1li <= '1';
		ELSIF (wire_nl01O_CLRN = '0') THEN
				nl00i <= '0';
				nl10i <= '0';
				nl10l <= '0';
				nl10O <= '0';
				nl11O <= '0';
				nl1ii <= '0';
				nl1il <= '0';
				nl1iO <= '0';
				nl1li <= '0';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
				nl00i <= nl11O;
				nl10i <= nl10l;
				nl10l <= nl10O;
				nl10O <= nl1ii;
				nl11O <= nl10i;
				nl1ii <= nl1il;
				nl1il <= nl1iO;
				nl1iO <= nl1li;
				nl1li <= nilOO;
		END IF;
	END PROCESS;
	wire_nl01O_CLRN <= (nilOl6 XOR nilOl5);
	wire_nl01O_PRN <= ((nilOi8 XOR nilOi7) AND refclk_b_reset_n);
	PROCESS (refclk_b, wire_nl1ll_PRN, wire_nl1ll_CLRN)
	BEGIN
		IF (wire_nl1ll_PRN = '0') THEN
				nl1lO <= '1';
		ELSIF (wire_nl1ll_CLRN = '0') THEN
				nl1lO <= '0';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
			IF (wire_nl1ll_ENA = '1') THEN
				nl1lO <= nilll;
			END IF;
		END IF;
	END PROCESS;
	wire_nl1ll_CLRN <= (nilli10 XOR nilli9);
	wire_nl1ll_ENA <= (((nl1OO AND nl1lO) AND (nilii14 XOR nilii13)) AND wire_nl1Ol_w_lg_nl1Oi168w(0));
	wire_nl1ll_PRN <= ((niliO12 XOR niliO11) AND refclk_b_reset_n);
	PROCESS (refclk_b, refclk_b_reset_n)
	BEGIN
		IF (refclk_b_reset_n = '0') THEN
				nl1Oi <= '0';
				nl1OO <= '0';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
				nl1Oi <= nl1OO;
				nl1OO <= tx_elec_idle_comp;
		END IF;
	END PROCESS;
	wire_nl1Ol_w_lg_nl1Oi168w(0) <= NOT nl1Oi;
	wire_niOll_dataout <= (powerdown(0) AND powerdown(1)) AND NOT(nil1O);
	wire_niOlO_dataout <= ((NOT powerdown(0)) AND powerdown(1)) AND NOT(nil1O);
	wire_niOOi_dataout <= (wire_w_lg_w_powerdown_range196w204w(0) AND (niiOl24 XOR niiOl23)) AND NOT(nil1O);
	wire_niOOl_dataout <= (((NOT powerdown(0)) AND wire_w_lg_w_powerdown_range198w199w(0)) AND (nil1i22 XOR nil1i21)) AND NOT(nil1O);
	wire_nl00O_dataout <= txdetectrxloopback WHEN wire_w_lg_rtx_pipe_enable151w(0) = '1'  ELSE (txdetectrxloopback AND wire_niOlO_dataout);
	wire_nl0il_dataout <= txelecidle WHEN wire_w_lg_rtx_pipe_enable151w(0) = '1'  ELSE wire_nl11i_dataout;
	wire_nl0iO_dataout <= revloopback WHEN wire_w_lg_rtx_pipe_enable151w(0) = '1'  ELSE ((txdetectrxloopback AND wire_niOOl_dataout) AND (niO1O2 XOR niO1O1));
	wire_nl0ll_dataout <= txswing AND rtxswing_sel_ena;
	wire_nl0lO_dataout <= wire_niOOl_dataout AND rtx_pipe_enable;
	wire_nl0Oi_dataout <= wire_niOOi_dataout AND rtx_pipe_enable;
	wire_nl0Ol_dataout <= wire_niOlO_dataout AND rtx_pipe_enable;
	wire_nl0OO_dataout <= wire_niOll_dataout AND rtx_pipe_enable;
	wire_nl11i_dataout <= nl1li WHEN wire_w_lg_nilOO193w(0) = '1'  ELSE wire_nl11l_o;
	wire_nl11l_data <= ( wire_nil0i20_w_lg_w_lg_q190w191w & nl11O & nl10i & nl10l & wire_nil0l18_w_lg_w_lg_q184w185w & nl1ii & nl1il & nl1iO);
	wire_nl11l_sel <= ( rtx_elec_idle_delay(2 DOWNTO 1) & wire_nil0O16_w_lg_w_lg_q171w172w);
	nl11l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl11l_data,
		o => wire_nl11l_o,
		sel => wire_nl11l_sel
	  );

 END RTL; --cycloneiv_hssi_tx_pipe_interface
--synopsys translate_on
--VALID FILE


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_q_pipe_interface_top IS
   PORT (
      
      -- General signals
      -- TX PIPE interface clock == TX Phase Comp write clock
      -- RX PIPE interface clock == RX Phase Comp read clock
      -- TX Phase Comp FIFO read clock
      -- synchronized reset i.e TX Phase Comp write clock
      -- synchronized reset i.e.RX Phase Comp read clock
      -- synchronized reset i.e.TX Phase Comp read clock
      
      -- CRAM 
      -- enable tx pipe interface
      -- enable rx pipe interface
      -- Single width = 0, double width = 1
      -- programmable delay for controlling output buffer
      -- Enables control of voltage swing level.  Implementation 
      -- is optional under PIPE 1.87.  When this CRAM is not set, full swing is the default mode
      -- normal = 0, bypass = 1
      -- recognize EDB = 0, PAD = 1 insertion for 8b/10b decode errors
      -- Combined reporting = 0 i.e. 8b/10b error|disparity error=> rxstatus=3'b100
      -- individual reporting = 1 i.e. 8b/10b error => rxstatus = 3'b111;
      -- disparity error => rxstatus = 3'b100
      -- no toggle (gen 2) = 0, toggle (option for gen 1) = 1
      
      -- programmable delay for the emulation circuitry of successfull power state
      -- transition.  Default delay between the change of power state and the assertion
      -- of ~ 13 parallel cycles.  Setting of this CRAM to 3'b000 will result in a delay
      -- of ~ 13 parallel cycles.
      
      -- PLD - PIPE Interface
      -- TX PIPE Interface: Command 
      -- P0 ==> loopback, P1 ==> RX detection
      -- output buffer control
      --			   txcompliance,				// compliance pattern command
      -- power state control
      
      -- Selects transmitter de-emphasis under Gen 2 speeds
      -- Selects transmitter voltage levels 
      -- Selects transmitter voltage swing levels
      
      -- TX PIPE Interface: Data
      -- TX data path	
      
      -- RX PIPE Interface: Command/Status
      -- polarity inversion command
      
      -- indicates symbol lock and valid data
      -- indicates receiver detection of electrical idle.  
      -- encodes receiver status and error codes when receiving data
      -- encodes compliance pattern speed when doing receiver detection
      
      -- RX PIPE Interface: Data
      -- RX data path
      
      -- PHYStatus Generator
      -- communicate completion of power state transitions, receiver 
      -- detection, rate change
      
      -- Commands
      -- enables reverse parallel loopback when in PIPE bypass mode
      -- enables polarity inversion when in PIPE bypass mode
      
      -- PIPE - PCS Inteface
      -- TX PIPE Interface
      -- TX data path to TX Phase Comp FIFO
      -- reverse parallel loopback control to MUX after the encoder
      -- compensated txelecidle from the TX Phase Comp FIFO
      -- synchronous to refclk_b
      
      -- Auto Speed Negotiation
      
      -- Auto Negotiation Module
      -- asserted when signaling rate change between Gen 1 and Gen 2 is in process.  Sychronization occurs within PIPE module
      
      -- RX PIPE Interface
      -- RX data path from the RX Phase comp FIFO
      -- polarity inversion control; sychronization occurs at 8b/10b decoder
      
      -- PIPE - PMA Interface
      -- TX PIPE Interface
      -- command to the output buffer
      -- command to the PMA module for receiver detection
      -- decoded power state: used internally to the PIPE interface
      
      -- RX PIPE Interface
      -- PMA indication of receiver being detected
      -- Validation of rx_found
      -- electrical idle detection from Rx Electrical Idle inference module
      
      --shawn
      --shawn
      --shawn
      
      -- PHYStatus Generator
      -- asserted when successful power state transition occurs
      -- validates power_state_transition_done, currently tied to 0
      
      -- PIPE-DPRIO interface
      -- Selects transmitter de-emphasis under Gen 2 speeds
      -- Selects transmitter voltage levels 
      -- Selects transmitter voltage swing levels
      
      --********************************************************************************
      -- INCLUDE STATEMENTS
      --********************************************************************************
      
      --********************************************************************************
      -- I/O SIGNALS
      --********************************************************************************
      -- General signals
      --shawn
      --shawn
      --shawn
      
      pipe_tx_clk                      : IN STD_LOGIC;
      pipe_rx_clk                      : IN STD_LOGIC;
      refclk_b                         : IN STD_LOGIC;
      tx_pipe_reset                    : IN STD_LOGIC;
      rx_pipe_reset                    : IN STD_LOGIC;
      refclk_b_reset                   : IN STD_LOGIC;
      
      -- CRAM 
      rtx_pipe_enable                  : IN STD_LOGIC;
      rrx_pipe_enable                  : IN STD_LOGIC;
      rrdwidth_rx                      : IN STD_LOGIC;
      rtx_elec_idle_delay              : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rtxswing_sel_ena                 : IN STD_LOGIC;
      rrx_detect_bypass                : IN STD_LOGIC;
      rclkcmpinsertpad                 : IN STD_LOGIC;
      rind_error_reporting             : IN STD_LOGIC;
      rphystatus_rst_toggle            : IN STD_LOGIC;
      rphystatus_delay                 : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- PLD - PIPE Interface
      -- TX PIPE Interface: Command 
      txdetectrxloopback               : IN STD_LOGIC;
      txelecidle                       : IN STD_LOGIC;
      powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      txdeemph                         : IN STD_LOGIC;
      txmargin                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      txswing                          : IN STD_LOGIC;
      
      -- TX PIPE Interface: Data
      txd_ch                           : IN STD_LOGIC_VECTOR(43 DOWNTO 0);
      
      -- RX PIPE Interface: Command/Status
      rxpolarity                       : IN STD_LOGIC;
      
      rxvalid                          : OUT STD_LOGIC;
      rxelecidle                       : OUT STD_LOGIC;
      rxstatus                         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE Interface: Data
      rxd_ch                           : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
      
      -- PHYStatus Generator
      phystatus                        : OUT STD_LOGIC;
      
      -- Commands
      revloopback                      : IN STD_LOGIC;
      polinv_rx                        : IN STD_LOGIC;
      
      -- PIPE - PCS Inteface
      -- TX PIPE Interface
      txd                              : OUT STD_LOGIC_VECTOR(43 DOWNTO 0);
      rev_loopbk                       : OUT STD_LOGIC;
      tx_elec_idle_comp                : IN STD_LOGIC;
      
      rindv_rx                         : IN STD_LOGIC;
      rmaster_rx                       : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rmaster_up_rx                    : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      
      -- Auto Negotiation Module
      speed_change                     : IN STD_LOGIC;
      speed_change_centrl              : IN STD_LOGIC;
      speed_change_quad_up             : IN STD_LOGIC;
      speed_change_quad_down           : IN STD_LOGIC;
      
      -- RX PIPE Interface
      rxd                              : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
      polinv_rx_int                    : OUT STD_LOGIC;
      
      -- PIPE - PMA Interface
      -- TX PIPE Interface
      tx_elec_idle                     : OUT STD_LOGIC;
      txdetectrx                       : OUT STD_LOGIC;
      powerstate                       : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      
      sigdetni                         : IN STD_LOGIC;  -- ww25_2008
      
      -- RX PIPE Interface
      rx_found                         : IN STD_LOGIC;
      rx_detect_valid                  : IN STD_LOGIC;
      rxelectricalidle                 : IN STD_LOGIC;
      txdetectrxin                     : IN STD_LOGIC;
      powerstatein                     : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      use_powerstatein                 : IN STD_LOGIC;
      
      -- PHYStatus Generator
      power_state_transition_done      : IN STD_LOGIC;
      power_state_transition_done_ena  : IN STD_LOGIC;
      
      -- PIPE-DPRIO interface
      txdeemph_int                     : OUT STD_LOGIC;
      txmargin_int                     : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txswing_int                      : OUT STD_LOGIC
   );
END cycloneiv_hssi_q_pipe_interface_top;

ARCHITECTURE trans OF cycloneiv_hssi_q_pipe_interface_top IS
   COMPONENT cycloneiv_hssi_tx_pipe_interface
      PORT (
         clk                              : IN STD_LOGIC;
         refclk_b                         : IN STD_LOGIC;
         reset_n                          : IN STD_LOGIC;
         refclk_b_reset_n                 : IN STD_LOGIC;
         rtx_pipe_enable                  : IN STD_LOGIC;
         rtx_elec_idle_delay              : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rtxswing_sel_ena                 : IN STD_LOGIC;
         txdetectrxloopback               : IN STD_LOGIC;
         txelecidle                       : IN STD_LOGIC;
         powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         txdeemph                         : IN STD_LOGIC;
         txmargin                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         txswing                          : IN STD_LOGIC;
         txd_ch                           : IN STD_LOGIC_VECTOR(43 DOWNTO 0);
         revloopback                      : IN STD_LOGIC;
         txd                              : OUT STD_LOGIC_VECTOR(43 DOWNTO 0);
         rev_loopbk                       : OUT STD_LOGIC;
         tx_elec_idle_comp                : IN STD_LOGIC;
         tx_elec_idle                     : OUT STD_LOGIC;
         txdetectrx                       : OUT STD_LOGIC;
         powerstate                       : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
         txdeemph_int                     : OUT STD_LOGIC;
         txmargin_int                     : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         txswing_int                      : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_phystatus_generator
      PORT (
         clk                              : IN STD_LOGIC;
         reset_n                          : IN STD_LOGIC;
         phystat_ena                      : IN STD_LOGIC;
         rphystatus_rst_toggle            : IN STD_LOGIC;
         rphystatus_delay                 : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         phystatus                        : OUT STD_LOGIC;
         latched_p0                       : IN STD_LOGIC;
         latched_p0s                      : IN STD_LOGIC;
         latched_p1                       : IN STD_LOGIC;
         latched_p2                       : IN STD_LOGIC;
         rindv_rx                         : IN STD_LOGIC;
         rmaster_rx                       : IN STD_LOGIC;
         rmaster_up_rx                    : IN STD_LOGIC;
         speed_change                     : IN STD_LOGIC;
         speed_change_centrl              : IN STD_LOGIC;
         speed_change_quad_up             : IN STD_LOGIC;
         speed_change_quad_down           : IN STD_LOGIC;
         rx_detect_valid                  : IN STD_LOGIC;
         power_state_transition_done      : IN STD_LOGIC;
         power_state_transition_done_ena  : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_rx_pipe_interface
      PORT (
         clk                              : IN STD_LOGIC;
         reset_n                          : IN STD_LOGIC;
         rrx_pipe_enable                  : IN STD_LOGIC;
         rrdwidth_rx                      : IN STD_LOGIC;
         rclkcmpinsertpad                 : IN STD_LOGIC;
         rind_error_reporting             : IN STD_LOGIC;
         rxpolarity                       : IN STD_LOGIC;
         rxvalid                          : OUT STD_LOGIC;
         rxelecidle                       : OUT STD_LOGIC;
         rxstatus                         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rxd_ch                           : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         polinv_rx                        : IN STD_LOGIC;
         rxd                              : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         polinv_rx_int                    : OUT STD_LOGIC;
         latched_p1                       : IN STD_LOGIC;
         txdetectrx                       : IN STD_LOGIC;
         rx_found                         : IN STD_LOGIC;
         rx_found_sync                    : IN STD_LOGIC;
         rx_detect_valid                  : IN STD_LOGIC;
         rx_detect_valid_sync             : IN STD_LOGIC;
         sigdetni                         : IN STD_LOGIC;  -- ww25_2008
         rxelectricalidle                 : IN STD_LOGIC
      );
   END COMPONENT;
   
   
   --********************************************************************************
   -- PARAMETERS
   --********************************************************************************
   
   --********************************************************************************
   -- DECLARATIONS
   --********************************************************************************
   
   SIGNAL phystat_ena            : STD_LOGIC;
   
   SIGNAL rx_found_reg_0         : STD_LOGIC;
   SIGNAL rx_found_reg_1         : STD_LOGIC;
   
   SIGNAL rx_detect_valid_reg_0  : STD_LOGIC;
   SIGNAL rx_detect_valid_reg_1  : STD_LOGIC;
   
   SIGNAL tx_pipe_reset_n        : STD_LOGIC;
   SIGNAL rx_pipe_reset_n        : STD_LOGIC;
   SIGNAL refclk_b_reset_n       : STD_LOGIC;		-- reset for txelecidle_d_generator
   
   SIGNAL txdetectrx_reg_0       : STD_LOGIC;
   SIGNAL txdetectrx_reg_1       : STD_LOGIC;
   SIGNAL txdetectrx_reg_2       : STD_LOGIC;
   SIGNAL txdetectrx_reg_3       : STD_LOGIC;
   SIGNAL txdetectrx_reg_4       : STD_LOGIC;
   SIGNAL txdetectrx_reg_5       : STD_LOGIC;
   SIGNAL txdetectrx_reg_6       : STD_LOGIC;
   
   SIGNAL bypass_rx_found        : STD_LOGIC;
   SIGNAL bypass_rx_detect_valid : STD_LOGIC;
   
   SIGNAL rx_found_int           : STD_LOGIC;
   SIGNAL rx_detect_valid_int    : STD_LOGIC;
   
   SIGNAL latched_p0             : STD_LOGIC;
   SIGNAL latched_p0s            : STD_LOGIC;
   SIGNAL latched_p1             : STD_LOGIC;
   SIGNAL latched_p2             : STD_LOGIC;
   
   SIGNAL p1_sync                : STD_LOGIC;
   
   SIGNAL tmp_txdetectrxin       : STD_LOGIC;		--shawn
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL rxvalid_xhdl7          : STD_LOGIC;
   SIGNAL rxelecidle_xhdl5       : STD_LOGIC;
   SIGNAL rxstatus_xhdl6         : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rxd_ch_xhdl4           : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL phystatus_xhdl0        : STD_LOGIC;
   SIGNAL txd_xhdl9              : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL rev_loopbk_xhdl3       : STD_LOGIC;
   SIGNAL polinv_rx_int_xhdl1    : STD_LOGIC;
   SIGNAL tx_elec_idle_xhdl8     : STD_LOGIC;
   SIGNAL txdetectrx_xhdl11      : STD_LOGIC;
   SIGNAL powerstate_xhdl2       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL txdeemph_int_xhdl10    : STD_LOGIC;
   SIGNAL txmargin_int_xhdl12    : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL txswing_int_xhdl13     : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   rxvalid <= rxvalid_xhdl7;
   rxelecidle <= rxelecidle_xhdl5;
   rxstatus <= rxstatus_xhdl6;
   rxd_ch <= rxd_ch_xhdl4;
   phystatus <= phystatus_xhdl0;
   txd <= txd_xhdl9;
   rev_loopbk <= rev_loopbk_xhdl3;
   polinv_rx_int <= polinv_rx_int_xhdl1;
   tx_elec_idle <= tx_elec_idle_xhdl8;
   txdetectrx <= txdetectrx_xhdl11;
   powerstate <= powerstate_xhdl2;
   txdeemph_int <= txdeemph_int_xhdl10;
   txmargin_int <= txmargin_int_xhdl12;
   txswing_int <= txswing_int_xhdl13;
   
   --********************************************************************************
   -- ASSIGN STATEMENTS
   --********************************************************************************
   phystat_ena <= rtx_pipe_enable OR rrx_pipe_enable;
   
   tx_pipe_reset_n <= NOT(tx_pipe_reset);
   rx_pipe_reset_n <= NOT(rx_pipe_reset);
   refclk_b_reset_n <= NOT(refclk_b_reset);
   
   rx_found_int <= bypass_rx_found WHEN (rrx_detect_bypass = '1') ELSE
                   rx_found_reg_1;
   rx_detect_valid_int <= bypass_rx_detect_valid WHEN (rrx_detect_bypass = '1') ELSE
                          rx_detect_valid_reg_1;
   
   tmp_txdetectrxin <= txdetectrxin WHEN (use_powerstatein = '1') ELSE		--shawn
                       txdetectrx_xhdl11;
   
   latched_p0 <= powerstatein(0) WHEN (use_powerstatein = '1') ELSE		--shawn
                 powerstate_xhdl2(0);
   latched_p0s <= powerstatein(1) WHEN (use_powerstatein = '1') ELSE		--shawn;
                  powerstate_xhdl2(1);
   latched_p1 <= powerstatein(2) WHEN (use_powerstatein = '1') ELSE		--shawn;
                 powerstate_xhdl2(2);
   latched_p2 <= powerstatein(3) WHEN (use_powerstatein = '1') ELSE		--shawn;
                 powerstate_xhdl2(3);
   
   --********************************************************************************
   -- SUBMODULE INSTANTIATIONS
   --********************************************************************************
   
   
   
   tx_pipe_interface_inst : cycloneiv_hssi_tx_pipe_interface
      PORT MAP (
         
         -- General signals
         clk                  => pipe_tx_clk,
         refclk_b             => refclk_b,
         reset_n              => tx_pipe_reset_n,
         refclk_b_reset_n     => refclk_b_reset_n,
         
         -- CRAM 
         rtx_pipe_enable      => rtx_pipe_enable,
         rtx_elec_idle_delay  => rtx_elec_idle_delay,
         
         rtxswing_sel_ena     => rtxswing_sel_ena,
         
         -- PLD - PIPE Interface
         -- TX PIPE Interface: Command
         txdetectrxloopback   => txdetectrxloopback,
         txelecidle           => txelecidle,
         --					     .txcompliance					(txcompliance),
         powerdown            => powerdown,
         
         txdeemph             => txdeemph,
         txmargin             => txmargin,
         txswing              => txswing,
         
         -- TX PIPE Interface: Data
         txd_ch               => txd_ch,
         
         -- Commands
         revloopback          => revloopback,
         
         -- PIPE - PCS Inteface
         -- TX PIPE Interface
         txd                  => txd_xhdl9,
         rev_loopbk           => rev_loopbk_xhdl3,
         tx_elec_idle_comp    => tx_elec_idle_comp,
         
         -- PIPE - PMA Interface
         tx_elec_idle         => tx_elec_idle_xhdl8,
         txdetectrx           => txdetectrx_xhdl11,
         
         -- Central PCS
         powerstate           => powerstate_xhdl2,
         
         -- PIPE - DPRIO
         txdeemph_int         => txdeemph_int_xhdl10,
         txmargin_int         => txmargin_int_xhdl12,
         txswing_int          => txswing_int_xhdl13
      );
   
   
   
   rx_pipe_interface_inst : cycloneiv_hssi_rx_pipe_interface
      PORT MAP (
         
         -- General signals
         clk                   => pipe_rx_clk,
         reset_n               => rx_pipe_reset_n,
         
         -- CRAM 
         rrx_pipe_enable       => rrx_pipe_enable,
         rrdwidth_rx           => rrdwidth_rx,
         rclkcmpinsertpad      => rclkcmpinsertpad,
         rind_error_reporting  => rind_error_reporting,
         
         -- PLD - PIPE Interface
         -- RX PIPE Interface: Command/Status
         rxpolarity            => rxpolarity,
         
         rxvalid               => rxvalid_xhdl7,
         rxelecidle            => rxelecidle_xhdl5,
         rxstatus              => rxstatus_xhdl6,
         
         -- RX PIPE Interface: Data
         rxd_ch                => rxd_ch_xhdl4,
         
         -- Commands
         polinv_rx             => polinv_rx,
         
         -- PIPE - PCS Inteface
         -- RX PIPE Interface
         rxd                   => rxd,
         polinv_rx_int         => polinv_rx_int_xhdl1,
         
         -- TX PIPE Interface
         -- Latched Power State Signals
         latched_p1            => latched_p1,
         
         txdetectrx            => tmp_txdetectrxin,		--shawn (txdetectrx),
         
         -- PIPE - PMA Interface
         -- TX PIPE Interface
         rx_found              => rx_found,
         rx_found_sync         => rx_found_int,
         rx_detect_valid       => rx_detect_valid,
         rx_detect_valid_sync  => rx_detect_valid_int,
         
         sigdetni              => sigdetni,  -- ww25_2008
         
         -- RX PIPE Interface
         rxelectricalidle      => rxelectricalidle
      );
   
   
   
   phystatus_generator_inst : cycloneiv_hssi_phystatus_generator
      PORT MAP (
         
         -- General signals
         clk                              => pipe_rx_clk,
         reset_n                          => rx_pipe_reset_n,
         
         --CRAM
         phystat_ena                      => phystat_ena,
         rphystatus_rst_toggle            => rphystatus_rst_toggle,
         rphystatus_delay                 => rphystatus_delay,
         
         -- PLD Interface
         powerdown                        => powerdown,
         phystatus                        => phystatus_xhdl0,
         
         -- Latched Power State Signals
         latched_p0                       => latched_p0,
         latched_p0s                      => latched_p0s,
         latched_p1                       => latched_p1,
         latched_p2                       => latched_p2,
         
         rindv_rx                         => rindv_rx,
         rmaster_rx                       => rmaster_rx,
         rmaster_up_rx                    => rmaster_up_rx,
         
         -- Auto Negotiation Module
         speed_change                     => speed_change,
         speed_change_centrl              => speed_change_centrl,
         speed_change_quad_up             => speed_change_quad_up,
         speed_change_quad_down           => speed_change_quad_down,
         
         -- TX PMA Interface
         rx_detect_valid                  => rx_detect_valid_int,
         
         -- RX PMA Interface
         power_state_transition_done      => power_state_transition_done,
         power_state_transition_done_ena  => power_state_transition_done_ena
      );
   
   --********************************************************************************
   -- MAIN CODE 
   --********************************************************************************
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         rx_detect_valid_reg_0 <=  TRANSPORT '0' AFTER 1* 1 ps;
         rx_found_reg_0 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         rx_detect_valid_reg_0 <=  TRANSPORT rx_detect_valid AFTER 1* 1 ps;
         rx_found_reg_0 <=  TRANSPORT rx_found AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         rx_detect_valid_reg_1 <=  TRANSPORT '0' AFTER 1* 1 ps;
         rx_found_reg_1 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         rx_detect_valid_reg_1 <=  TRANSPORT rx_detect_valid_reg_0 AFTER 1* 1 ps;
         rx_found_reg_1 <=  TRANSPORT rx_found_reg_0 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_0 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_0 <=  TRANSPORT tmp_txdetectrxin AFTER 1* 1 ps;		-- txdetectrx; shawn
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_1 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_1 <=  TRANSPORT txdetectrx_reg_0 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_2 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_2 <=  TRANSPORT txdetectrx_reg_1 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_3 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_3 <=  TRANSPORT txdetectrx_reg_2 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_4 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_4 <=  TRANSPORT txdetectrx_reg_3 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_5 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_5 <=  TRANSPORT txdetectrx_reg_4 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_6 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_6 <=  TRANSPORT txdetectrx_reg_5 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         bypass_rx_found <=  TRANSPORT '0' AFTER 1* 1 ps;
         bypass_rx_detect_valid <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         bypass_rx_found <=  TRANSPORT txdetectrx_reg_6 AFTER 1* 1 ps;
         bypass_rx_detect_valid <=  TRANSPORT txdetectrx_reg_6 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
END trans;



-- pipe_interface_top

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_tx_digis_txclk_gating IS
    PORT (
        
        select_n   : IN STD_LOGIC;
        clk1       : IN STD_LOGIC;
        clk2       : IN STD_LOGIC;
        clk1out_n  : OUT STD_LOGIC;
        clk2out_n  : OUT STD_LOGIC
    );
END cycloneiv_hssi_tx_digis_txclk_gating;

ARCHITECTURE trans OF cycloneiv_hssi_tx_digis_txclk_gating IS
BEGIN
    
    clk1out_n <= NOT((select_n OR clk1));
    clk2out_n <= NOT((NOT(select_n) OR clk2));
    
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_tx_digi_txclk_ctl IS
   PORT (
      
      -- Clock Inputs
      pld_tx_clk              : IN STD_LOGIC;		-- PLD clock from PLD clock trees, the transmit clock from XGMII.
      refclk_pma              : IN STD_LOGIC;		-- Quad based clk from TXPLL
      txpma_local_clk         : IN STD_LOGIC;		-- Local channel TX PMA clock.
      
      -- Control Inputs
      txrst                   : IN STD_LOGIC;		-- reset for the tx_pcs
      scan_mode               : IN STD_LOGIC;		-- Scan mode enable signal for selecting scan_clk from refclk_pma
      
      -- New Control Inputs
      gen2ngen1               : IN STD_LOGIC;		-- from PMA for PCIexp Gen1/Gen2 datawidth scaling
      gen2ngen1_bundle        : IN STD_LOGIC;		-- from PMA for PCIexp Gen1/Gen2 datawidth scaling in x4 and x8
      tx_div2_sync_centrl     : IN STD_LOGIC;		-- divided clock from the central channel (x2, x4 mode)
      tx_div2_sync_quad_up    : IN STD_LOGIC;		-- divided clock from quad above (> x4 mode)
      tx_div2_sync_quad_down  : IN STD_LOGIC;		-- divided clock from quad below (> x4 mode)
      
      -- MDIO Inputs
      rindv_tx                : IN STD_LOGIC;		-- Selects between indiv chan. mode and bundled mode
      rtxwrclksel             : IN STD_LOGIC;		-- Selects which clock writes into FIFO
      rtxrdclksel             : IN STD_LOGIC;		-- Selects which clock reads from FIFO and also clocks reest of TX logic
      rdwidth_tx              : IN STD_LOGIC;		-- divide by 1 or 2 before feeding to FIFO read clock
      rfreerun_tx             : IN STD_LOGIC;		-- Select whether divider is permamently enabled (free -running) or  divider should be enabled / reset by TX PCS reset  
      
      -- New MDIO Inputs
      rauto_speed_ena         : IN STD_LOGIC;		-- auto speed negotiation enable
      rfreq_sel               : IN STD_LOGIC;		-- freq scaling or data width scaling
      rtxpcsclkpwdn           : IN STD_LOGIC;		-- TX clocking power down enable
      rmaster_tx              : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rmaster_up_tx           : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rself_sw_en_tx          : IN STD_LOGIC;		-- enables self-switch to have correct /2 clock in all quads in bundle mode
      
      -- Removed Inputs
      -- input        tx_div2_sync_in_ch0;    // from the channel zero tx_div2_sync_out
      -- input        tx_div2_sync_in_q0_ch0; // From channel0 of Master Quad
      -- input        rphfifo_master_sel_tx;  // TX Phase comp. FIFO tx_div2_sync selection CRAM
      
      -- Clock Outputs wtih CTS
      refclk_b                : OUT STD_LOGIC;		-- Drives the tx channel clock
      wr_clk_pos              : OUT STD_LOGIC;		-- Drives tx phase comp fifo write side
      fifo_rd_clk             : OUT STD_LOGIC;		-- Drives tx phase comp fifo read side
      
      -- Clock Outputs to PLD, w/o CTS
      tx_clk_out              : OUT STD_LOGIC;		-- Drives to the PLD clock tree -- unconnected
      
      -- New Clock Outputs with CTS
      refclk_b_raw            : OUT STD_LOGIC;		-- same as refclk_b, but with no clock gating
      wr_clk_pos_raw          : OUT STD_LOGIC;		-- same as wr_clk_pos, but with no clock gating
      fifo_rd_clk_raw         : OUT STD_LOGIC;		-- same as fifo_rd_clk, but with no clock gating
      
      -- Control Outputs
      tx_div2_sync_out        : OUT STD_LOGIC		-- Synchronizes the divided by two clock
   );
END cycloneiv_hssi_tx_digi_txclk_ctl;

ARCHITECTURE trans OF cycloneiv_hssi_tx_digi_txclk_ctl IS
   COMPONENT cycloneiv_hssi_tx_digis_txclk_gating
        PORT (
            select_n                : IN STD_LOGIC;
            clk1                    : IN STD_LOGIC;
            clk2                    : IN STD_LOGIC;
            clk1out_n               : OUT STD_LOGIC;
            clk2out_n               : OUT STD_LOGIC
        );
    END COMPONENT;
   
   
   SIGNAL fifo_rd_clk_by2        : STD_LOGIC := '0';
   SIGNAL gen2ngen1_local_sync   : STD_LOGIC;
   SIGNAL counter                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   SIGNAL tx_rst_n               : STD_LOGIC;
   SIGNAL tx_div2_sync           : STD_LOGIC;
   SIGNAL dynamic_div2ndiv1      : STD_LOGIC;
   SIGNAL gen2ngen1_local        : STD_LOGIC;
   SIGNAL tx_div2_this_quad      : STD_LOGIC;
   SIGNAL tx_div2_this_channel   : STD_LOGIC;
   SIGNAL tx_div2_other_quad     : STD_LOGIC;
   SIGNAL force_master           : STD_LOGIC;
   SIGNAL rtxpcsclkpwdn_nscan    : STD_LOGIC;
   
    SIGNAL select_div1_n          : STD_LOGIC;
    SIGNAL clk1out_n              : STD_LOGIC;
    SIGNAL clk2out_n              : STD_LOGIC;
    
   -- Declare intermediate signals for referenced outputs
   SIGNAL fifo_rd_clk_xhdl0      : STD_LOGIC;
   SIGNAL refclk_b_raw_xhdl2     : STD_LOGIC;
   SIGNAL wr_clk_pos_raw_xhdl4   : STD_LOGIC;
   SIGNAL fifo_rd_clk_raw_xhdl1  : STD_LOGIC;
   SIGNAL tx_div2_sync_out_xhdl3 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   fifo_rd_clk <= fifo_rd_clk_xhdl0;
   refclk_b_raw <= refclk_b_raw_xhdl2;
   wr_clk_pos_raw <= wr_clk_pos_raw_xhdl4;
   fifo_rd_clk_raw <= fifo_rd_clk_raw_xhdl1;
   tx_div2_sync_out <= tx_div2_sync_out_xhdl3;
   

   -- Old bundle logic:   
   -- Select between the local synchronization signal or the global synchronization signal (either from Channel0 or 
   -- Channel0 of Master Quad
   --assign tx_div2_sync = rindv_tx ? tx_div2_sync_out : tx_div2_sync_in;
   -- assign 	tx_div2_sync = (rphfifo_master_sel_tx == 1'b0) ? tx_div2_sync_in_q0_ch0 :
   --                            (rindv_tx == 1'b0) ? tx_div2_sync_in_ch0 : 
   --                            (rauto_speed_ena & ~rfreq_sel) ? (tx_div2_sync_out | ~gen2ngen1_local_sync) : tx_div2_sync_out;
   
   PROCESS (txrst, refclk_b_raw_xhdl2)
VARIABLE  txt : LINE;
   BEGIN
      IF (txrst = '1') THEN
         counter <=  TRANSPORT "00" AFTER 1* 1 ps;
      ELSIF (refclk_b_raw_xhdl2'EVENT AND refclk_b_raw_xhdl2 = '1') THEN
         IF (((rauto_speed_ena AND NOT(rfreq_sel) AND rself_sw_en_tx) AND NOT(force_master)) = '1') THEN
            counter <=  TRANSPORT counter + "01" AFTER 1* 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   force_master <= '1' WHEN ((counter = "11") AND ((rauto_speed_ena AND NOT(rfreq_sel) AND rself_sw_en_tx) = '1')) ELSE
                   '0';
   
   tx_div2_sync <= tx_div2_this_quad WHEN ((rmaster_tx OR force_master) = '1') ELSE
                   tx_div2_other_quad;
   tx_div2_this_quad <= tx_div2_this_channel WHEN ((rindv_tx OR force_master) = '1') ELSE
                        tx_div2_sync_centrl;
   tx_div2_this_channel <= (tx_div2_sync_out_xhdl3 OR NOT(gen2ngen1_local_sync)) WHEN ((rauto_speed_ena AND NOT(rfreq_sel)) = '1') ELSE
                           tx_div2_sync_out_xhdl3;
   tx_div2_other_quad <= tx_div2_sync_quad_up WHEN (rmaster_up_tx = '1') ELSE
                         tx_div2_sync_quad_down;
   
   gen2ngen1_local <= gen2ngen1_bundle WHEN (rindv_tx = '0') ELSE
                      gen2ngen1;
   
   PROCESS (txrst, refclk_b_raw_xhdl2)
VARIABLE  txt : LINE;
   BEGIN
      IF (txrst = '1') THEN
         gen2ngen1_local_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (refclk_b_raw_xhdl2'EVENT AND refclk_b_raw_xhdl2 = '1') THEN
         gen2ngen1_local_sync <=  TRANSPORT gen2ngen1_local AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   dynamic_div2ndiv1 <= rdwidth_tx OR (gen2ngen1_local_sync AND rauto_speed_ena AND NOT(rfreq_sel));
   
   -- Reset for Divide-by-2 FF
   tx_rst_n <= '1' WHEN (rfreerun_tx = '1') ELSE
               NOT(txrst);
   
   rtxpcsclkpwdn_nscan <= rtxpcsclkpwdn AND NOT(scan_mode);
   
   -- Full speed clock for TX PCS
   refclk_b_raw_xhdl2 <= refclk_pma WHEN ((scan_mode OR rtxrdclksel) = '1') ELSE
                         txpma_local_clk;
   
   refclk_b <= '1' WHEN (rtxpcsclkpwdn_nscan = '1') ELSE
               refclk_b_raw_xhdl2;
   
   -- Divide-by-2 FF
   PROCESS (tx_rst_n, refclk_b_raw_xhdl2)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(tx_rst_n)) = '1') THEN
         fifo_rd_clk_by2 <= '1';
      ELSIF (refclk_b_raw_xhdl2'EVENT AND refclk_b_raw_xhdl2 = '1') THEN
         fifo_rd_clk_by2 <= tx_div2_sync;		-- local divided clock
      END IF;
   END PROCESS;
   
   tx_div2_sync_out_xhdl3 <= NOT(fifo_rd_clk_by2);
   
   -- TX FIFO read clock: could be fast or divided by 2
   -- old code:
   -- assign fifo_rd_clk = ((rdwidth_tx == 1'b0) || scan_mode) ? refclk_b_raw : fifo_rd_clk_by2;
   
   select_div1_n <= NOT((scan_mode OR NOT(dynamic_div2ndiv1)));
   
   cycloneiv_hssi_tx_digis_txclk_gating_inst : cycloneiv_hssi_tx_digis_txclk_gating
        PORT MAP (
            select_n   => select_div1_n,
            clk1       => refclk_b_raw_xhdl2,
            clk2       => fifo_rd_clk_by2,
            clk1out_n  => clk1out_n,
            clk2out_n  => clk2out_n
        );
        
  fifo_rd_clk_raw_xhdl1 <= NOT (clk1out_n OR clk2out_n);

   fifo_rd_clk_xhdl0 <= '1' WHEN (rtxpcsclkpwdn_nscan = '1') ELSE
                        fifo_rd_clk_raw_xhdl1;
   
   -- TX FIFO write clock: used internal clock when in BIST or scan or HIP
   wr_clk_pos_raw_xhdl4 <= fifo_rd_clk_raw_xhdl1 WHEN ((scan_mode OR rtxwrclksel) = '1') ELSE
                           pld_tx_clk;
   wr_clk_pos <= '1' WHEN (rtxpcsclkpwdn_nscan = '1') ELSE
                 wr_clk_pos_raw_xhdl4;
   
   -- TX Clock Out
   tx_clk_out <= fifo_rd_clk_xhdl0;		-- drives PLD clock tree
   
END trans;




-- txclk_ctl


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_tx_digis_ram8x49_syn IS
   GENERIC (
      
      read_access_time   : INTEGER := 0;
      write_access_time  : INTEGER := 0;
      ram_width          : INTEGER := 54
   );
   PORT (
      data_in            : IN STD_LOGIC_VECTOR(53 DOWNTO 0);
      clk                : IN STD_LOGIC;
      fifo_wr            : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rst_l              : IN STD_LOGIC;
      fifo_re            : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      data_out           : OUT STD_LOGIC_VECTOR(53 DOWNTO 0)
   );
END cycloneiv_hssi_tx_digis_ram8x49_syn;

ARCHITECTURE trans OF cycloneiv_hssi_tx_digis_ram8x49_syn IS
   
   SIGNAL data_out_i    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_0 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_1 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_2 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_3 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_4 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_5 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_6 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_7 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_0 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_1 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_2 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_3 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_4 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_5 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_6 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_7 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   
   SIGNAL data_reg_0    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_1    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_2    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_3    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_4    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_5    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_6    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_7    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   
   SIGNAL we            : STD_LOGIC;
   SIGNAL re_l          : STD_LOGIC;
BEGIN
   
   we <= '1';
   re_l <= '0';
   
   data_reg_0 <= data_in WHEN (fifo_wr(0) = '1') ELSE
                 ram_array_q_0;
   data_reg_1 <= data_in WHEN (fifo_wr(1) = '1') ELSE
                 ram_array_q_1;
   data_reg_2 <= data_in WHEN (fifo_wr(2) = '1') ELSE
                 ram_array_q_2;
   data_reg_3 <= data_in WHEN (fifo_wr(3) = '1') ELSE
                 ram_array_q_3;
   data_reg_4 <= data_in WHEN (fifo_wr(4) = '1') ELSE
                 ram_array_q_4;
   data_reg_5 <= data_in WHEN (fifo_wr(5) = '1') ELSE
                 ram_array_q_5;
   data_reg_6 <= data_in WHEN (fifo_wr(6) = '1') ELSE
                 ram_array_q_6;
   data_reg_7 <= data_in WHEN (fifo_wr(7) = '1') ELSE
                 ram_array_q_7;
   
   data_out <= "100001000000000000000000000000000000000000000000000000" WHEN (re_l = '1') ELSE
               data_out_i;
   
   PROCESS (ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, fifo_re)
VARIABLE  txt : LINE;
   BEGIN
      CASE fifo_re IS		-- synopsys parallel_case full_case
         WHEN "00000001" =>
            data_out_i <= ram_array_q_0;
         WHEN "00000010" =>
            data_out_i <= ram_array_q_1;
         WHEN "00000100" =>
            data_out_i <= ram_array_q_2;
         WHEN "00001000" =>
            data_out_i <= ram_array_q_3;
         WHEN "00010000" =>
            data_out_i <= ram_array_q_4;
         WHEN "00100000" =>
            data_out_i <= ram_array_q_5;
         WHEN "01000000" =>
            data_out_i <= ram_array_q_6;
         WHEN "10000000" =>
            data_out_i <= ram_array_q_7;
         WHEN OTHERS =>
            data_out_i <= ram_array_q_0;
      END CASE;
   END PROCESS;
   
   
   PROCESS (clk, rst_l)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rst_l)) = '1') THEN
         ram_array_q_0 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_1 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_2 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_3 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_4 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_5 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_6 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_7 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         ram_array_q_0 <=  TRANSPORT ram_array_d_0 AFTER (write_access_time)*1 ps;
         ram_array_q_1 <=  TRANSPORT ram_array_d_1 AFTER (write_access_time)*1 ps;
         ram_array_q_2 <=  TRANSPORT ram_array_d_2 AFTER (write_access_time)*1 ps;
         ram_array_q_3 <=  TRANSPORT ram_array_d_3 AFTER (write_access_time)*1 ps;
         ram_array_q_4 <=  TRANSPORT ram_array_d_4 AFTER (write_access_time)*1 ps;
         ram_array_q_5 <=  TRANSPORT ram_array_d_5 AFTER (write_access_time)*1 ps;
         ram_array_q_6 <=  TRANSPORT ram_array_d_6 AFTER (write_access_time)*1 ps;
         ram_array_q_7 <=  TRANSPORT ram_array_d_7 AFTER (write_access_time)*1 ps;
      END IF;
   END PROCESS;
   
   
   PROCESS (we, data_reg_0, data_reg_1, data_reg_2, data_reg_3, data_reg_4, data_reg_5, data_reg_6, data_reg_7, ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7)
VARIABLE  txt : LINE;
   BEGIN
      IF (we = '1') THEN
         ram_array_d_0 <= data_reg_0;
         ram_array_d_1 <= data_reg_1;
         ram_array_d_2 <= data_reg_2;
         ram_array_d_3 <= data_reg_3;
         ram_array_d_4 <= data_reg_4;
         ram_array_d_5 <= data_reg_5;
         ram_array_d_6 <= data_reg_6;
         ram_array_d_7 <= data_reg_7;
      ELSE
         ram_array_d_0 <= ram_array_q_0;
         ram_array_d_1 <= ram_array_q_1;
         ram_array_d_2 <= ram_array_q_2;
         ram_array_d_3 <= ram_array_q_3;
         ram_array_d_4 <= ram_array_q_4;
         ram_array_d_5 <= ram_array_q_5;
         ram_array_d_6 <= ram_array_q_6;
         ram_array_d_7 <= ram_array_q_7;
      END IF;
   END PROCESS;
   
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_tx_digis_ph_fifo IS
   PORT (
      -- inputs
      --en,
      -- outputs
      
      -- =======
      -- inputs
      -- =======
      rst_wclk                 : IN STD_LOGIC;		-- wr clk rst
      rst_rclk                 : IN STD_LOGIC;		-- rd clk rst
      wr_clk                   : IN STD_LOGIC;		-- Write Clock
      rd_clk                   : IN STD_LOGIC;		-- Read Clock
      bypass_en                : IN STD_LOGIC;		-- FIFO bypass enable - only for Altera internal debug
      --input         en;		// Disable FIFO, reset wptr and rptr 
      -- only for Altera internal debug
      lowlatency_en            : IN STD_LOGIC;		-- Enable low latency option 
      we                       : IN STD_LOGIC;		-- PLD dynamic write pointer enable  
      re                       : IN STD_LOGIC;		-- PLD dynamic read pointer enable  
      din                      : IN STD_LOGIC_VECTOR(53 DOWNTO 0);		-- 10-bit code-group bus from deskew module.
      
      rphfifo_regmode_tx       : IN STD_LOGIC;
      rindv_tx                 : IN STD_LOGIC;
      rauto_speed_ena          : IN STD_LOGIC;
      reset_pc_ptrs            : IN STD_LOGIC;
      reset_pc_ptrs_centrl     : IN STD_LOGIC;
      reset_pc_ptrs_quad_up    : IN STD_LOGIC;
      reset_pc_ptrs_quad_down  : IN STD_LOGIC;
      rmaster_tx               : IN STD_LOGIC;
      rmaster_up_tx            : IN STD_LOGIC;
      
      -- =======
      -- outputs
      -- =======
      -- Indicates overflow (rd_clk)
      -- FIFO empty (rd_clk)
      data_out                 : OUT STD_LOGIC_VECTOR(53 DOWNTO 0);		-- output data (rd_clk synchronous if not FIFO bypass)
      ph_fifo_full             : OUT STD_LOGIC;
      ph_fifo_empty            : OUT STD_LOGIC;
      wptr_bin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);		-- wptr test bus
      rptr_bin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)		-- rptr test bus
   );
END cycloneiv_hssi_tx_digis_ph_fifo;

ARCHITECTURE trans OF cycloneiv_hssi_tx_digis_ph_fifo IS
   COMPONENT cycloneiv_hssi_tx_digis_ram8x49_syn
      GENERIC (
         read_access_time         : INTEGER := 0;
         write_access_time        : INTEGER := 0;
         ram_width                : INTEGER := 54
      );
      PORT (
         data_in                  : IN STD_LOGIC_VECTOR(53 DOWNTO 0);
         clk                      : IN STD_LOGIC;
         fifo_wr                  : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         rst_l                    : IN STD_LOGIC;
         fifo_re                  : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         data_out                 : OUT STD_LOGIC_VECTOR(53 DOWNTO 0)
      );
   END COMPONENT;
   
   
   -- ===================
   -- signal declaration
   -- ===================
   SIGNAL wptr                   : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL rptr                   : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL wptr0_pre              : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL wptr0                  : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL wptr1                  : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL rptr_gray              : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000" ;
   SIGNAL rptr_gray0             : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rptr0                  : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000" ;
   SIGNAL rptr1                  : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000" ;
   SIGNAL rptr1_onehot           : STD_LOGIC_VECTOR(7 DOWNTO 0);
   -- wptr test bus
   -- rptr test bus
   SIGNAL first_rd               : STD_LOGIC;		-- first read after reset
   SIGNAL ram_data_out           : STD_LOGIC_VECTOR(53 DOWNTO 0);
   SIGNAL ram_data_out_pre       : STD_LOGIC_VECTOR(53 DOWNTO 0);
   
   SIGNAL ph_fifo_full_pre       : STD_LOGIC;
   
   -- Invert rst for new FIFO     
   SIGNAL rst_n                  : STD_LOGIC;
   
   SIGNAL fifo_cnt               : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL fifo_cnt_pre           : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL wptr1_bin              : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rptr1_bin_wclk         : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   SIGNAL reset_ptrs_local       : STD_LOGIC;
   
   SIGNAL reset_ptrs_local_sync1 : STD_LOGIC;
   SIGNAL reset_ptrs_local_sync2 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL ph_fifo_empty_xhdl0    : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   ph_fifo_empty <= ph_fifo_empty_xhdl0;
   
   -- =============
   -- functionality
   -- =============
   rst_n <= NOT(rst_wclk);
   
   data_out(53 DOWNTO 0) <= din WHEN (bypass_en = '1') ELSE
                            ram_data_out;
   
   reset_ptrs_local <= rauto_speed_ena AND reset_pc_ptrs WHEN (rindv_tx = '1') ELSE
                       reset_pc_ptrs_centrl WHEN (rmaster_tx = '1') ELSE
                       reset_pc_ptrs_quad_up WHEN (rmaster_up_tx = '1') ELSE
                       reset_pc_ptrs_quad_down;
   
   --newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use
   -- manually translated
   PROCESS(fifo_cnt_pre, rst_wclk, rptr1_bin_wclk, wptr1_bin)
   BEGIN
       IF (rptr1_bin_wclk = wptr1_bin) THEN
           IF (rst_wclk /= '1') THEN
               IF (fifo_cnt_pre = "0111" OR fifo_cnt_pre = "0110" OR fifo_cnt_pre = "1000") THEN
                   fifo_cnt <= "1000";
               ELSE
                   fifo_cnt <= "0000";
               END IF;    
           ELSE
               fifo_cnt <= "0000";
           END IF;
       ELSE
           IF (wptr1_bin > rptr1_bin_wclk) THEN
               fifo_cnt <= ('0' & (wptr1_bin - rptr1_bin_wclk));
           ELSE
               fifo_cnt <= ("1000" - ('0' & (rptr1_bin_wclk - wptr1_bin)));
           END IF;     
       END IF;
   END PROCESS;
   
   --newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use 
   -- incorrect translation - replaced above section
   --fifo_cnt <= "1000" WHEN (fifo_cnt_pre = "0111" OR fifo_cnt_pre = "0110" OR fifo_cnt_pre = "1000") ELSE
   --            "0000" WHEN (rst_wclk /= '1') ELSE
   --            "0000" WHEN (wptr1_bin = rptr1_bin_wclk) ELSE
   --            ('0' & (wptr1_bin - rptr1_bin_wclk)) WHEN (wptr1_bin > rptr1_bin_wclk) ELSE
   --            ("1000" - ('0' & (rptr1_bin_wclk - wptr1_bin)));
   
   PROCESS (rst_wclk, wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_wclk = '1') THEN
         reset_ptrs_local_sync1 <=  TRANSPORT '0' AFTER 1 ps;
         reset_ptrs_local_sync2 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         IF (rphfifo_regmode_tx = '1') THEN
            reset_ptrs_local_sync1 <=  TRANSPORT '0' AFTER 1 ps;
            reset_ptrs_local_sync2 <=  TRANSPORT '0' AFTER 1 ps;
         ELSE
            reset_ptrs_local_sync1 <=  TRANSPORT reset_ptrs_local AFTER 1 ps;
            reset_ptrs_local_sync2 <=  TRANSPORT reset_ptrs_local_sync1 AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS; -- always @ (posedge rst_wclk or posedge wr_clk)

    --ECO for S4GX to fix metastability issue
    -- replace the 1st FF with new flop w/o reset
    -- replace the 2nd FF with an enhanced flop
    PROCESS (wr_clk)
    BEGIN
        IF (wr_clk'EVENT AND wr_clk = '1') THEN
            IF (reset_ptrs_local_sync2 = '1' OR rphfifo_regmode_tx = '1') THEN
                rptr0 <=  TRANSPORT "000" AFTER 1 ps;
            ELSE
                rptr0 <=  TRANSPORT rptr_gray(2 DOWNTO 0) AFTER 1 ps;
            END IF;
        END IF;
    END PROCESS; -- always @ (posedge rst_wclk or posedge wr_clk)
      
    PROCESS(rst_wclk, wr_clk)
    BEGIN
      IF (rst_wclk = '1') THEN
         rptr1 <=  TRANSPORT "000" AFTER 1 ps;
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         IF ((reset_ptrs_local_sync2 OR rphfifo_regmode_tx) = '1') THEN
            rptr1 <=  TRANSPORT "000" AFTER 1 ps;
         ELSE
            rptr1 <=  TRANSPORT rptr0 AFTER 1 ps;
         END IF;
      END IF;
     END PROCESS;  -- always @ (posedge rst_wclk or posedge wr_clk)
      
   PROCESS (rst_wclk, wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_wclk = '1') THEN
         wptr <=  TRANSPORT "00000001" AFTER 1 ps;
         wptr0_pre <=  TRANSPORT "00000001" AFTER 1 ps;
         wptr0 <=  TRANSPORT "00000001" AFTER 1 ps;
         wptr1 <=  TRANSPORT "00000001" AFTER 1 ps;
         --rptr0 <=  TRANSPORT "000" AFTER 1 ps;
         --rptr1 <=  TRANSPORT "000" AFTER 1 ps;
         ph_fifo_full_pre <=  TRANSPORT '0' AFTER 1 ps;
         ph_fifo_full <=  TRANSPORT '0' AFTER 1 ps;
         ph_fifo_empty_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;		-- fifo_cnt previous value
         fifo_cnt_pre <=  TRANSPORT "0000" AFTER 1 ps;		-- if (rst_wclk == 1'b1)
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         IF ((reset_ptrs_local_sync2 OR rphfifo_regmode_tx) = '1') THEN
            wptr <=  TRANSPORT "00000001" AFTER 1 ps;
            wptr0_pre <=  TRANSPORT "00000001" AFTER 1 ps;
            wptr0 <=  TRANSPORT "00000001" AFTER 1 ps;
            wptr1 <=  TRANSPORT "00000001" AFTER 1 ps;
            --rptr0 <=  TRANSPORT "000" AFTER 1 ps;
            --rptr1 <=  TRANSPORT "000" AFTER 1 ps;
            ph_fifo_full_pre <=  TRANSPORT '0' AFTER 1 ps;
            ph_fifo_full <=  TRANSPORT '0' AFTER 1 ps;
            ph_fifo_empty_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;		-- fifo_cnt previous value
            fifo_cnt_pre <=  TRANSPORT "0000" AFTER 1 ps;		-- if (reset_ptrs_local_sync2)
         ELSE
            
            fifo_cnt_pre <=  TRANSPORT fifo_cnt AFTER 1 ps;
            ph_fifo_full <=  TRANSPORT ph_fifo_full_pre AFTER 1 ps;
            wptr0_pre <=  TRANSPORT wptr AFTER 1 ps;
            wptr0 <=  TRANSPORT wptr0_pre AFTER 1 ps;
            wptr1 <=  TRANSPORT wptr0 AFTER 1 ps;
            
            --rptr0 <=  TRANSPORT rptr_gray(2 DOWNTO 0) AFTER 1 ps;
            --rptr1 <=  TRANSPORT rptr0 AFTER 1 ps;
            
            -- wptr operation
            IF (we = '1') THEN
               
               -- full condition
               --$if ({wptr1[6:0],wptr1[7]} == rptr1_onehot)
               --new full flag requirement
               wptr <=  TRANSPORT (wptr(6 DOWNTO 0) & wptr(7)) AFTER 1 ps;
            END IF;
            IF ((fifo_cnt = "1000") AND ((NOT(ph_fifo_empty_xhdl0))) = '1') THEN
               --else if (ph_fifo_full_pre == 1'b1 & (wptr1 != rptr1_onehot)) //now become sticky flag until reset
               --ph_fifo_full_pre <= #1 1'b0;
               
               -- empty condition
               --$if ({rptr1_onehot[6:0],rptr1_onehot[7]} == wptr1)
               --new empty flag requirement
               ph_fifo_full_pre <=  TRANSPORT '1' AFTER 1 ps;		--==1 to cover if wptr not moving
            END IF;
            IF ((((wptr1(6 DOWNTO 0)) & (wptr1(7))) = rptr1_onehot) AND (fifo_cnt_pre = "0001" OR fifo_cnt_pre = "0000") AND ((NOT(ph_fifo_full_pre))) = '1') THEN
               --else if (ph_fifo_empty == 1'b1 & ({wptr1[6:0],wptr1[7]} != rptr1_onehot)) //now become sticky flag until reset
               --ph_fifo_empty <= #1 1'b0;
               ph_fifo_empty_xhdl0 <=  TRANSPORT '1' AFTER 1 ps;
            END IF;
         END IF;
      END IF;
   END PROCESS; -- always @ (posedge rst_wclk or posedge wr_clk)
   -- end of eco
   
   PROCESS (rst_rclk, rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_rclk = '1') THEN
         first_rd <=  TRANSPORT '1' AFTER 1 ps;
         rptr <=  TRANSPORT "00100000" AFTER 1 ps;
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         IF ((reset_ptrs_local OR rphfifo_regmode_tx) = '1') THEN
            first_rd <=  TRANSPORT '1' AFTER 1 ps;
            rptr <=  TRANSPORT "00100000" AFTER 1 ps;
         ELSE
            
            IF (first_rd = '1' AND re = '1') THEN
               
               -- read pointer operation
               first_rd <=  TRANSPORT '0' AFTER 1 ps;
            END IF;
            IF (re = '1') THEN
               -- low latency option, advance 2 on the first read 
               IF (first_rd = '1' AND lowlatency_en = '1') THEN
                  rptr <=  TRANSPORT (rptr(5 DOWNTO 0) & rptr(7 DOWNTO 6)) AFTER 1 ps;
               ELSE
                  rptr <=  TRANSPORT (rptr(6 DOWNTO 0) & rptr(7)) AFTER 1 ps;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge rst_rclk or posedge rd_clk)
   
   -- Instantiate FIFO CORE Module. Fifo 8 words deep, 44 bits wide
   
   
   
   ram8x49_syn_1 : cycloneiv_hssi_tx_digis_ram8x49_syn
      PORT MAP (
         rst_l     => rst_n,
         clk       => wr_clk,
         fifo_wr   => wptr,
         data_in   => din,
         fifo_re   => rptr,
         data_out  => ram_data_out_pre
      );
   
   PROCESS (rst_rclk, rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_rclk = '1') THEN
         ram_data_out <=  TRANSPORT "100000000000000000000000000000000000000000000000000000" AFTER 1 ps;
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         IF (rphfifo_regmode_tx = '1') THEN
            ram_data_out <=  TRANSPORT din AFTER 1 ps;
         ELSE
            ram_data_out <=  TRANSPORT ram_data_out_pre AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge rst_rclk or posedge rd_clk)
   
   PROCESS (wptr)
VARIABLE  txt : LINE;
   BEGIN
      CASE wptr IS
         WHEN "00000001" =>
            wptr_bin <= "000";
         WHEN "00000010" =>
            wptr_bin <= "001";
         WHEN "00000100" =>
            wptr_bin <= "010";
         WHEN "00001000" =>
            wptr_bin <= "011";
         WHEN "00010000" =>
            wptr_bin <= "100";
         WHEN "00100000" =>
            wptr_bin <= "101";
         WHEN "01000000" =>
            wptr_bin <= "110";
         WHEN "10000000" =>
            wptr_bin <= "111";
         WHEN OTHERS =>		-- case(wptr)
            wptr_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (wptr)
   
   PROCESS (wptr1)
VARIABLE  txt : LINE;
   BEGIN
      CASE wptr1 IS
         WHEN "00000001" =>
            wptr1_bin <= "000";
         WHEN "00000010" =>
            wptr1_bin <= "001";
         WHEN "00000100" =>
            wptr1_bin <= "010";
         WHEN "00001000" =>
            wptr1_bin <= "011";
         WHEN "00010000" =>
            wptr1_bin <= "100";
         WHEN "00100000" =>
            wptr1_bin <= "101";
         WHEN "01000000" =>
            wptr1_bin <= "110";
         WHEN "10000000" =>
            wptr1_bin <= "111";
         WHEN OTHERS =>		-- case(wptr1)
            wptr1_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (wptr1)
   
   PROCESS (rptr)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr IS
         WHEN "00000001" =>
            rptr_bin <= "000";
         WHEN "00000010" =>
            rptr_bin <= "001";
         WHEN "00000100" =>
            rptr_bin <= "010";
         WHEN "00001000" =>
            rptr_bin <= "011";
         WHEN "00010000" =>
            rptr_bin <= "100";
         WHEN "00100000" =>
            rptr_bin <= "101";
         WHEN "01000000" =>
            rptr_bin <= "110";
         WHEN "10000000" =>
            rptr_bin <= "111";
         WHEN OTHERS =>		-- case(rptr)
            rptr_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr)
   
   PROCESS (rst_rclk, rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_rclk = '1') THEN
         rptr_gray <=  TRANSPORT "000" AFTER 1 ps;
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         rptr_gray <=  TRANSPORT rptr_gray0 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   
   PROCESS (rptr)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr IS
         WHEN "00000001" =>
            rptr_gray0 <= "000";
         WHEN "00000010" =>
            rptr_gray0 <= "001";
         WHEN "00000100" =>
            rptr_gray0 <= "011";
         WHEN "00001000" =>
            rptr_gray0 <= "010";
         WHEN "00010000" =>
            rptr_gray0 <= "110";
         WHEN "00100000" =>
            rptr_gray0 <= "111";
         WHEN "01000000" =>
            rptr_gray0 <= "101";
         WHEN "10000000" =>
            rptr_gray0 <= "100";
         WHEN OTHERS =>		-- case(rptr)
            rptr_gray0 <= "000";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr)
   
   PROCESS (rptr1)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr1 IS
         WHEN "000" =>
            rptr1_onehot <= "00000001";
         WHEN "001" =>
            rptr1_onehot <= "00000010";
         WHEN "011" =>
            rptr1_onehot <= "00000100";
         WHEN "010" =>
            rptr1_onehot <= "00001000";
         WHEN "110" =>
            rptr1_onehot <= "00010000";
         WHEN "111" =>
            rptr1_onehot <= "00100000";
         WHEN "101" =>
            rptr1_onehot <= "01000000";
         WHEN "100" =>
            rptr1_onehot <= "10000000";
         WHEN OTHERS =>		-- case(rptr1)
            rptr1_onehot <= "00000001";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr1)
   
   PROCESS (rptr1)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr1 IS
         WHEN "000" =>
            rptr1_bin_wclk <= "000";
         WHEN "001" =>
            rptr1_bin_wclk <= "001";
         WHEN "011" =>
            rptr1_bin_wclk <= "010";
         WHEN "010" =>
            rptr1_bin_wclk <= "011";
         WHEN "110" =>
            rptr1_bin_wclk <= "100";
         WHEN "111" =>
            rptr1_bin_wclk <= "101";
         WHEN "101" =>
            rptr1_bin_wclk <= "110";
         WHEN "100" =>
            rptr1_bin_wclk <= "111";
         WHEN OTHERS =>		-- case(rptr1)
            rptr1_bin_wclk <= "000";
      END CASE;
   END PROCESS;
   
   
END trans;


-- always@ (rptr1)


-- ph_fifo_tx

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_tx_digi_tx_ctrl IS
   PORT (
      -- inputs
      --is_lane0,
      -- PCS bypass
      
      -- TX PIPE signals
      
      -- RX PIPE signals
      
      -- New inputs for new bundling scheme and new PCIE features like autospeed
      
      -- New MDIO for new bundling scheme and new PCIE features like autospeed
      
      -- outputs
      
      -- TX PIPE signals
      
      -- RX PIPE signals
      
      -- test bus
      -- fifo_select_out	// test_bus[8], bit re-used in test bus
      -- test_bus[7]
      -- test_bus[6:4]
      -- test_bus[3]
      -- test_bus[2:0]
      -- *_xgmii = from XGMII interface
      -- *_sg    = from selftest_gen
      -- *_rc    = from rx_ctrl
      
      -- ======
      -- inputs
      -- ======
      soft_reset                : IN STD_LOGIC;		-- Reset
      fifo_wr_clk               : IN STD_LOGIC;		-- Used to be wr_clk_pos
      fifo_rd_clk               : IN STD_LOGIC;		-- Coming from txclk_xg_ctl 
      refclk_b_in               : IN STD_LOGIC;		-- The local reference clock used by the internal
      -- transmit logic. Used to be tx_clk.
      scan_mode                 : IN STD_LOGIC;		-- scan enable
      -- Control bit/pin to enable parallel loop back at XGMII
      -- To select XGMII signals from selftest_gen (*_sg)
      -- Control bit to support double-width data bus on xgmii.
      -- When set, fifo_wr_clk is running at half frequency
      -- as refclk_b_in and 2-byte/code-group of data should be sampled
      -- at the rising edge of fifo_wr_clk. When DWIDTH=1'b0, the
      -- fifo_wr_clk is running at the same frequency as refclk_b_in.
      rindv_tx                  : IN STD_LOGIC;
      p_rlpbk                   : IN STD_LOGIC;
      selftest_en               : IN STD_LOGIC;
      rdwidth_tx                : IN STD_LOGIC;
      --input		is_lane0; 	// lane 0 of the quad
      -- rx data from rx_ctrl.
      txfifo_dis                : IN STD_LOGIC;
      
      -- Tx data 
      -- These extension bits may be used to force disparity or other uses.
      -- Extend txd by 2 bits. Used to force disparity.
      -- The xgmii data from selftest_gen..
      -- The xgmii control from selftest_gen.
      -- redundant Tx data , unused
      -- redundant Tx data select, unused
      -- Acting with {txd_extend, TXD[9]	forces current disparity to 1 or 0
      
      rtxfifo_urst_en           : IN STD_LOGIC;		-- user reset CRAM enable
      txfifo_urst               : IN STD_LOGIC;		-- user reset 
      rtxfifo_lowlatency_en     : IN STD_LOGIC;		-- low latency enable
      rtxphfifopldctl_en        : IN STD_LOGIC;		-- CRAM to enable PLD controlled write/read enable
      rtx_pipe_enable           : IN STD_LOGIC;		-- enable pipe
      pld_we                    : IN STD_LOGIC;		-- PLD phase comp. fifo we, level active
      pld_rd_dis                : IN STD_LOGIC;		-- PLD phase comp. fifo rd dis, edge active
      txd                       : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
      txd_extend                : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rforce_disp               : IN STD_LOGIC;
      tx_data_sg                : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      tx_control_sg             : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rxd_lpbk                  : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
      redund_ctl                : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      txd_redun                 : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
      rforce_kchar              : IN STD_LOGIC;
      rforce_echar              : IN STD_LOGIC;
      -- PCS Bypass mode
      rtxpcsbypass_en           : IN STD_LOGIC;
      
      -- TX PIPE interface signals
      txdetectrxloopback        : IN STD_LOGIC;
      --input			txelecidle; 	txd[9]
      --input			txcompliance;	txd[10] and txd[32]
      powerdown                 : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      revloopback               : IN STD_LOGIC;
      
      txswing                   : IN STD_LOGIC;
      txdeemph                  : IN STD_LOGIC;
      txmargin                  : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE interface signals
      rxpolarity                : IN STD_LOGIC;
      polinv_rx                 : IN STD_LOGIC;
      eidleinfersel             : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- New Inputs for new bundling scheme and new PCIE features like autospeed
      reset_pc_ptrs             : IN STD_LOGIC;
      reset_pc_ptrs_centrl      : IN STD_LOGIC;
      reset_pc_ptrs_quad_up     : IN STD_LOGIC;
      reset_pc_ptrs_quad_down   : IN STD_LOGIC;
      gen2ngen1                 : IN STD_LOGIC;
      gen2ngen1_bundle          : IN STD_LOGIC;
      dis_pc_byte               : IN STD_LOGIC;
      wr_enable_centrl          : IN STD_LOGIC;
      wr_enable_quad_up         : IN STD_LOGIC;
      wr_enable_quad_down       : IN STD_LOGIC;
      rd_enable_centrl          : IN STD_LOGIC;
      rd_enable_quad_up         : IN STD_LOGIC;
      rd_enable_quad_down       : IN STD_LOGIC;
      fifo_select_in_centrl     : IN STD_LOGIC;
      fifo_select_in_quad_up    : IN STD_LOGIC;
      fifo_select_in_quad_down  : IN STD_LOGIC;
      
      -- New MDIO for new bundling scheme and new PCIE features like autospeed
      rauto_speed_ena           : IN STD_LOGIC;
      rfreq_sel                 : IN STD_LOGIC;
      rphfifo_regmode_tx        : IN STD_LOGIC;
      rmaster_tx                : IN STD_LOGIC;
      rmaster_up_tx             : IN STD_LOGIC;
      
      -- =======
      -- outputs
      -- =======
      txd_extend_tc             : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);		-- This will go to the encoder. This is serialized (muxed) txd_extend_int. But 
      -- txd_extend_int has to go through the FIFOs first to be serialized. 
      -- ch0 wr_enable1 output for X4/X8 mode
      -- ch0 rd_enable1 output for X4/X8 mode
      tx_data_tc                : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);		-- 8-bit data passed onto the internal transmit logic.
      tx_ctl_tc                 : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);		-- Control passed onto the internal transmit logic.
      -- Can be bit 8 of the 10-bit code group.
      tx_data_9_tc              : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);		-- Bit 9 of the 10-bit code group passed onto the internal transmit logic.
      rd_enable_sync            : OUT STD_LOGIC;
      k_det                     : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      d21_5_eq_n                : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      d2_2_eq_n                 : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      wr_enable_out             : OUT STD_LOGIC;
      rd_enable_out             : OUT STD_LOGIC;
      fifo_select_out           : OUT STD_LOGIC;		-- New output for Rev.B 
      ph_fifo_full              : OUT STD_LOGIC;		-- fifo full flag
      ph_fifo_empty             : OUT STD_LOGIC;		-- fifo empty flag
      soft_reset_wclk1          : OUT STD_LOGIC;		-- synchronized reset for BIST;
      soft_reset_rclk1          : OUT STD_LOGIC;		-- syncrhonized reset for PIPE
      pipe_electric_idle        : OUT STD_LOGIC;		-- PIPE electric idle bit
      
      -- TX PIPE interface signals
      txdetectrxloopback_int    : OUT STD_LOGIC;
      --output			txelecidle; 	txd[9]
      --output			txcompliance;	txd[10] and txd[32]
      powerdown_int             : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      revloopback_int           : OUT STD_LOGIC;
      
      phfifo_txswing            : OUT STD_LOGIC;
      phfifo_txdeemph           : OUT STD_LOGIC;
      phfifo_txmargin           : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE interface signals
      rxpolarity_int            : OUT STD_LOGIC;
      polinv_rx_int             : OUT STD_LOGIC;
      gray_eidleinfersel        : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- test bus
      -- testbus[8]   = fifo_select_out
      -- testbus[7]   = wr_enable2
      -- testbus[6:4] = wptr_bin
      -- testbus[3]   = rd_enable2
      -- testbus[2:0] = rptr_bin
      wr_enable2                : OUT STD_LOGIC;
      wptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      rd_enable2                : OUT STD_LOGIC;
      rptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
   );
END cycloneiv_hssi_tx_digi_tx_ctrl;

ARCHITECTURE trans OF cycloneiv_hssi_tx_digi_tx_ctrl IS
   COMPONENT cycloneiv_hssi_tx_digis_ph_fifo
      PORT (
         rst_wclk                  : IN STD_LOGIC;
         rst_rclk                  : IN STD_LOGIC;
         wr_clk                    : IN STD_LOGIC;
         rd_clk                    : IN STD_LOGIC;
         bypass_en                 : IN STD_LOGIC;
         lowlatency_en             : IN STD_LOGIC;
         we                        : IN STD_LOGIC;
         re                        : IN STD_LOGIC;
         din                       : IN STD_LOGIC_VECTOR(53 DOWNTO 0);
         rphfifo_regmode_tx        : IN STD_LOGIC;
         rindv_tx                  : IN STD_LOGIC;
         rauto_speed_ena           : IN STD_LOGIC;
         reset_pc_ptrs             : IN STD_LOGIC;
         reset_pc_ptrs_centrl      : IN STD_LOGIC;
         reset_pc_ptrs_quad_up     : IN STD_LOGIC;
         reset_pc_ptrs_quad_down   : IN STD_LOGIC;
         rmaster_tx                : IN STD_LOGIC;
         rmaster_up_tx             : IN STD_LOGIC;
         data_out                  : OUT STD_LOGIC_VECTOR(53 DOWNTO 0);
         ph_fifo_full              : OUT STD_LOGIC;
         ph_fifo_empty             : OUT STD_LOGIC;
         wptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
      );
   END COMPONENT;
   
   
   -- ================
   -- internal signals
   -- ================
   
   -- Begin: 22 Bits output of this module (44 to 22 / 22 to 22)
   SIGNAL tx_data_tc_mux             : STD_LOGIC_VECTOR(15 DOWNTO 0);		--temp holder for non PCS bypass data branch before mux
   SIGNAL tx_ctl_tc_mux              : STD_LOGIC_VECTOR(1 DOWNTO 0);		--temp holder for non PCS bypass branch before mux
   SIGNAL tx_data_9_tc_mux           : STD_LOGIC_VECTOR(1 DOWNTO 0);		--temp holder for non PCS bypass branch before mux
   SIGNAL txd_extend_tc_mux          : STD_LOGIC_VECTOR(1 DOWNTO 0);		--temp holder for non PCS bypass branch before mux
   -- End:   22 bits output of this module
   
   SIGNAL tx_data_lt                 : STD_LOGIC_VECTOR(19 DOWNTO 0);
   
   SIGNAL tx_data                    : STD_LOGIC_VECTOR(39 DOWNTO 0);
   SIGNAL din0                       : STD_LOGIC_VECTOR(53 DOWNTO 0);
   SIGNAL fifo_data_out              : STD_LOGIC_VECTOR(39 DOWNTO 0);
   SIGNAL tx_data_9_tc_d             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_data_9_tc_d_others      : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_ctl_tc_d                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_ctl_tc_d_others         : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_data_tc_d               : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL tx_data_tc_d_others        : STD_LOGIC_VECTOR(17 DOWNTO 0);
   SIGNAL d21_5_eq_n_d               : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL d2_2_eq_n_d                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL k_det_sync1                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   SIGNAL txfifo_en_refclk0          : STD_LOGIC;
   SIGNAL txfifo_en_refclk1          : STD_LOGIC;
   
   SIGNAL wr_enable0                 : STD_LOGIC;
   SIGNAL wr_enable0p5               : STD_LOGIC;
   SIGNAL wr_enable1                 : STD_LOGIC;
   SIGNAL rd_enable0                 : STD_LOGIC;
   SIGNAL rd_enable0p5               : STD_LOGIC;
   SIGNAL rd_enable1                 : STD_LOGIC;
   
   SIGNAL txd_extend_int             : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL txd_extend_tc_d            : STD_LOGIC_VECTOR(1 DOWNTO 0);		-- This is registered and sent out to the encoder as txd_extend_tc. 
   -- This is serialized (muxed) txd_extend_int. But 
   -- txd_extend_int has to go through the FIFOs first to be serialized. 
   SIGNAL txd_extend_low             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL txd_extend_high            : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL txd_data_extend_tmp        : STD_LOGIC_VECTOR(17 DOWNTO 0);
   
   SIGNAL txfifo_en_rclk0            : STD_LOGIC;
   SIGNAL txfifo_en_rclk1            : STD_LOGIC;
   SIGNAL txfifo_en                  : STD_LOGIC;
   
   SIGNAL soft_reset_local           : STD_LOGIC;
   SIGNAL soft_reset_wclk0           : STD_LOGIC;
   SIGNAL soft_reset_wclk1_b4scan    : STD_LOGIC;
   SIGNAL soft_reset_wclk1_wire      : STD_LOGIC;
   SIGNAL soft_reset_rclk0           : STD_LOGIC;
   SIGNAL soft_reset_rclk1_b4scan    : STD_LOGIC;
   SIGNAL soft_reset_rclk1_wire      : STD_LOGIC;
   SIGNAL data_out_temp              : STD_LOGIC_VECTOR(53 DOWNTO 0);
   
   SIGNAL pld_rd_dis0                : STD_LOGIC;
   SIGNAL pld_rd_dis1                : STD_LOGIC;
   SIGNAL pld_rd_dis2                : STD_LOGIC;
   SIGNAL pld_rd_dis_edge            : STD_LOGIC;
   
   -- PIPE electric idle bit
   
   -- register rd_enable_sync to fast clock domain. Necessary to send out low 
   -- byte first after soft_reset.
   SIGNAL rd_enable_sync_refclk_b_in : STD_LOGIC;
   
   -- PIPE command signals
   SIGNAL pipe_cmd                   : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL pipe_cmd_out               : STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   SIGNAL rdwidth_or_auto            : STD_LOGIC;
   SIGNAL gen2ngen1_int              : STD_LOGIC;
   SIGNAL gen2ngen1_reg              : STD_LOGIC;
   SIGNAL gen2ngen1_sync              : STD_LOGIC;
   
   SIGNAL pipe_tx_trans              : STD_LOGIC_VECTOR(4 DOWNTO 0);		-- PIPE transmitter settings
   -- {txswing, txdeemph, txmargin}
   SIGNAL pipe_tx_trans_out          : STD_LOGIC_VECTOR(4 DOWNTO 0);
   -- X-HDL generated signals

   SIGNAL xhdl8 : STD_LOGIC;
   SIGNAL xhdl9 : STD_LOGIC;
   SIGNAL xhdl10 : STD_LOGIC;
   SIGNAL xhdl11 : STD_LOGIC;
   SIGNAL xhdl12 : STD_LOGIC;
   SIGNAL xhdl13 : STD_LOGIC;
   SIGNAL xhdl14 : STD_LOGIC;
   SIGNAL xhdl15 : STD_LOGIC;
   SIGNAL xhdl16 : STD_LOGIC;
   SIGNAL xhdl17 : STD_LOGIC;
   SIGNAL xhdl18 : STD_LOGIC;
   SIGNAL xhdl19 : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL xhdl20 : STD_LOGIC;
   SIGNAL xhdl21 : STD_LOGIC;
   SIGNAL xhdl22 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL rd_enable_sync_xhdl4       : STD_LOGIC;
   SIGNAL fifo_select_out_xhdl0      : STD_LOGIC;
   SIGNAL ph_fifo_full_xhdl2         : STD_LOGIC;
   SIGNAL ph_fifo_empty_xhdl1        : STD_LOGIC;
   SIGNAL wr_enable2_xhdl7           : STD_LOGIC;
   SIGNAL wptr_bin_xhdl6             : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rd_enable2_xhdl3           : STD_LOGIC;
   SIGNAL rptr_bin_xhdl5             : STD_LOGIC_VECTOR(2 DOWNTO 0);
BEGIN
   -- Drive referenced outputs
   rd_enable_sync <= rd_enable_sync_xhdl4;
   fifo_select_out <= fifo_select_out_xhdl0;
   ph_fifo_full <= ph_fifo_full_xhdl2;
   ph_fifo_empty <= ph_fifo_empty_xhdl1;
   wr_enable2 <= wr_enable2_xhdl7;
   wptr_bin <= wptr_bin_xhdl6;
   rd_enable2 <= rd_enable2_xhdl3;
   rptr_bin <= rptr_bin_xhdl5;
   
   -- =============
   -- functionality
   -- =============
   soft_reset_wclk1 <= soft_reset_wclk1_wire;
   soft_reset_rclk1 <= soft_reset_rclk1_wire;
   txd_extend_int <= txd_extend WHEN (rforce_disp = '1') ELSE
                     "0000";
   
   -- GiGE Idle Detection, replaced in 8b10b encoder
   d21_5_eq_n_d(0) <= int2bit(((tx_ctl_tc_d(0) & tx_data_tc_d(7 DOWNTO 0)) /= "010110101"));
   d21_5_eq_n_d(1) <= int2bit(((tx_ctl_tc_d(1) & tx_data_tc_d(15 DOWNTO 8)) /= "010110101"));
   d2_2_eq_n_d(0) <= int2bit(((tx_ctl_tc_d(0) & tx_data_tc_d(7 DOWNTO 0)) /= "001000010"));
   d2_2_eq_n_d(1) <= int2bit(((tx_ctl_tc_d(1) & tx_data_tc_d(15 DOWNTO 8)) /= "001000010"));
   
   wr_enable_out <= wr_enable1;
   rd_enable_out <= rd_enable1;
   
   -- 2-17-04 BT: Tied the tx_data[9] to 1'b0 in selftest mode since it effects the 
   --             disparity input in the 8B/10B encoder
   tx_data(19 DOWNTO 0) <= rxd_lpbk(19 DOWNTO 0) WHEN (p_rlpbk = '1') ELSE
                           ('0' & tx_control_sg(1) & tx_data_sg(15 DOWNTO 8) & '0' & tx_control_sg(0) & tx_data_sg(7 DOWNTO 0)) WHEN (selftest_en = '1') ELSE
                           txd_redun(19 DOWNTO 0) WHEN (redund_ctl /= "0000") ELSE
                           txd(19 DOWNTO 0);
   
   -- enable 3G double-width BIST by mapping tx_data_sg[15:8] & tx_control_sg[1] to the 3rd symbol location
   tx_data(39 DOWNTO 20) <= rxd_lpbk(39 DOWNTO 20) WHEN (p_rlpbk = '1') ELSE
                            ('0' & tx_control_sg(3) & tx_data_sg(31 DOWNTO 24) & '0' & tx_control_sg(1) & tx_data_sg(15 DOWNTO 8)) WHEN (selftest_en = '1') ELSE
                            txd_redun(39 DOWNTO 20) WHEN (redund_ctl /= "0000") ELSE
                            txd(39 DOWNTO 20);
   
   txfifo_en <= NOT(txfifo_urst) WHEN (rtxfifo_urst_en = '1') ELSE
                '1';
   
   -- PIPE electric idle is on txd[10]
   --assign pipe_electric_idle = txd_extend_tc_d[0];
   
   soft_reset_local <= soft_reset OR (rtxfifo_urst_en AND txfifo_urst);
   
   -- PIPE cmd
   pipe_cmd <= (powerdown & txdetectrxloopback & revloopback & '0');
   
   revloopback_int <= pipe_cmd(1) WHEN (txfifo_dis = '1') ELSE
                      pipe_cmd_out(1);
   txdetectrxloopback_int <= pipe_cmd(2) WHEN (txfifo_dis = '1') ELSE
                             pipe_cmd_out(2);
   powerdown_int <= pipe_cmd(4 DOWNTO 3) WHEN (txfifo_dis = '1') ELSE
                    pipe_cmd_out(4 DOWNTO 3);
   
   rxpolarity_int <= rxpolarity;
   polinv_rx_int <= polinv_rx;
   
   gen2ngen1_int <= gen2ngen1 WHEN (rindv_tx = '1') ELSE
                    gen2ngen1_bundle;
   --//************************************
   --// Synchronization of gen2ngen1
   --//************************************
   PROCESS (soft_reset, refclk_b_in)
   BEGIN
	IF (soft_reset = '1') THEN
	     gen2ngen1_reg  <= '0';
	     gen2ngen1_sync <= '0';
	ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
	     gen2ngen1_reg <= gen2ngen1_int;
	     gen2ngen1_sync <= gen2ngen1_reg;
	END IF;
   END PROCESS; -- always @ (posedge soft_reset or posedge refclk_b_in)
                          
   rdwidth_or_auto <= (rdwidth_tx OR (rauto_speed_ena AND NOT(rfreq_sel) AND gen2ngen1_sync));
   
   pipe_tx_trans <= (txswing & txdeemph & txmargin);
   
   phfifo_txswing <= pipe_tx_trans(4) WHEN (txfifo_dis = '1') ELSE
                     pipe_tx_trans_out(4);
   phfifo_txdeemph <= pipe_tx_trans(3) WHEN (txfifo_dis = '1') ELSE
                      pipe_tx_trans_out(3);
   phfifo_txmargin <= pipe_tx_trans(2 DOWNTO 0) WHEN (txfifo_dis = '1') ELSE
                      pipe_tx_trans_out(2 DOWNTO 0);
   
   -- synchronize reset input (in refclk_b domain)
   PROCESS (soft_reset_local, fifo_wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_local = '1') THEN
         soft_reset_wclk0 <=  TRANSPORT '1' AFTER 1 ps;
         soft_reset_wclk1_b4scan <=  TRANSPORT '1' AFTER 1 ps;
      ELSIF (fifo_wr_clk'EVENT AND fifo_wr_clk = '1') THEN
         soft_reset_wclk0 <=  TRANSPORT '0' AFTER 1 ps;
         soft_reset_wclk1_b4scan <=  TRANSPORT soft_reset_wclk0 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_local or posedge fifo_wr_clk)
   
   soft_reset_wclk1_wire <= '0' WHEN (scan_mode = '1') ELSE
                            soft_reset_wclk1_b4scan;
   
   -- synchronize reset input (in refclk_b domain) and balance it with fifo_wr_clk reset
   PROCESS (soft_reset_local, fifo_rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_local = '1') THEN
         soft_reset_rclk0 <=  TRANSPORT '1' AFTER 1 ps;
         soft_reset_rclk1_b4scan <=  TRANSPORT '1' AFTER 1 ps;
      ELSIF (fifo_rd_clk'EVENT AND fifo_rd_clk = '1') THEN
         soft_reset_rclk0 <=  TRANSPORT '0' AFTER 1 ps;
         soft_reset_rclk1_b4scan <=  TRANSPORT soft_reset_rclk0 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_local or posedge fifo_rd_clk)
   
   soft_reset_rclk1_wire <= '0' WHEN (scan_mode = '1') ELSE
                            soft_reset_rclk1_b4scan;
   
   -- write enable
   --wr_enable0   <= txfifo_en;
   --wr_enable0   <= 1'b1;
   xhdl8 <= (wr_enable0p5 AND pld_we) WHEN (rtxphfifopldctl_en = '1') ELSE
                            wr_enable0p5;
   xhdl9 <= wr_enable1 WHEN (rindv_tx = '1') ELSE
                            wr_enable_centrl;
   xhdl10 <= wr_enable_quad_up WHEN (rmaster_up_tx = '1') ELSE
                            wr_enable_quad_down;
   xhdl11 <= (xhdl9) WHEN (rmaster_tx = '1') ELSE
                            (xhdl10);
   PROCESS (soft_reset_wclk1_wire, fifo_wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_wclk1_wire = '1') THEN
         wr_enable0 <=  TRANSPORT '0' AFTER 1 ps;
         wr_enable0p5 <=  TRANSPORT '0' AFTER 1 ps;
         wr_enable1 <=  TRANSPORT '0' AFTER 1 ps;
         wr_enable2_xhdl7 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (fifo_wr_clk'EVENT AND fifo_wr_clk = '1') THEN
         wr_enable0 <=  TRANSPORT NOT((rauto_speed_ena AND dis_pc_byte)) AFTER 1 ps;
         wr_enable0p5 <=  TRANSPORT wr_enable0 AFTER 1 ps;
         wr_enable1 <=  TRANSPORT xhdl8 AFTER 1 ps;
         wr_enable2_xhdl7 <=  TRANSPORT xhdl11 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_wclk1 or posedge fifo_wr_clk)
   
   din0 <= (pipe_tx_trans & pipe_cmd & txd_extend_int(3 DOWNTO 2) & tx_data(39 DOWNTO 20) & txd_extend_int(1 DOWNTO 0) & tx_data(19 DOWNTO 0));
   
   -- Instantiate new FIFO
   
   
   ph_fifo_tx_1 : cycloneiv_hssi_tx_digis_ph_fifo
      PORT MAP (
         rst_wclk                 => soft_reset_wclk1_wire,
         rst_rclk                 => soft_reset_rclk1_wire,
         wr_clk                   => fifo_wr_clk,
         rd_clk                   => fifo_rd_clk,
         bypass_en                => txfifo_dis,
         --.en(1'b1),
         lowlatency_en            => rtxfifo_lowlatency_en,
         we                       => wr_enable2_xhdl7,
         re                       => rd_enable2_xhdl3,
         din                      => din0,
         data_out                 => data_out_temp,
         ph_fifo_full             => ph_fifo_full_xhdl2,
         ph_fifo_empty            => ph_fifo_empty_xhdl1,
         wptr_bin                 => wptr_bin_xhdl6,
         rptr_bin                 => rptr_bin_xhdl5,
         rphfifo_regmode_tx       => rphfifo_regmode_tx,
         rindv_tx                 => rindv_tx,
         rmaster_tx               => rmaster_tx,
         rmaster_up_tx            => rmaster_up_tx,
         rauto_speed_ena          => rauto_speed_ena,
         reset_pc_ptrs            => reset_pc_ptrs,
         reset_pc_ptrs_centrl     => reset_pc_ptrs_centrl,
         reset_pc_ptrs_quad_up    => reset_pc_ptrs_quad_up,
         reset_pc_ptrs_quad_down  => reset_pc_ptrs_quad_down
      );
   pipe_tx_trans_out <= data_out_temp(53 DOWNTO 49);
   pipe_cmd_out <= data_out_temp(48 DOWNTO 44);
   txd_extend_high <= data_out_temp(43 DOWNTO 42);
   fifo_data_out(39 DOWNTO 20) <= data_out_temp(41 DOWNTO 22);
   txd_extend_low <= data_out_temp(21 DOWNTO 20);
   fifo_data_out(19 DOWNTO 0) <= data_out_temp(19 DOWNTO 0);
   
   -- Modified Byte Serializer logic to use fifo_select_out to ping-pong between 
   -- low and high banks of FIFO during normal mode
   -- Toggle between {19,9} and {39,29} when DWIDTH is set, else fixed to {19,9}
   tx_data_9_tc_d <= (fifo_data_out(19) & fifo_data_out(9)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (NOT(rdwidth_or_auto) OR fifo_select_out_xhdl0) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                     (fifo_data_out(39) & fifo_data_out(29)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                     (tx_data(19) & tx_data(9)) WHEN ((txfifo_dis AND (NOT(rdwidth_or_auto) OR NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                     tx_data_9_tc_d_others;
   
   tx_data_9_tc_d_others <= "00" WHEN ((NOT(rforce_kchar) AND rforce_echar) = '1') ELSE
                            (tx_data_lt(19) & tx_data_lt(9)) WHEN ((txfifo_dis AND rdwidth_or_auto AND fifo_select_out_xhdl0 AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                            "00";
   
   -- 8th bit in each word. Toggle between {18,8} and {38,28} when DWIDTH is set, else fixed to {18,8}
   tx_ctl_tc_d <= (fifo_data_out(18) & fifo_data_out(8)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (NOT(rdwidth_or_auto) OR fifo_select_out_xhdl0) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                  (fifo_data_out(38) & fifo_data_out(28)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                  (tx_data(18) & tx_data(8)) WHEN ((txfifo_dis AND (NOT(rdwidth_or_auto) OR NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                  tx_ctl_tc_d_others;
   
   -- When transmitting Error(FE) or bypassing FIFO, transmit 11 in the former case and transmit bypassed data/ctl in the latter
   tx_ctl_tc_d_others <= "11" WHEN ((NOT(rforce_kchar) AND rforce_echar) = '1') ELSE
                         (tx_data_lt(18) & tx_data_lt(8)) WHEN ((txfifo_dis AND rdwidth_or_auto AND fifo_select_out_xhdl0 AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                         "11";
   
   -- After rd_enable_sync goes high, start transmitting. Initially, fifo_select_out is zero, so MSByte transmitted first.
   -- Transmit data if not forced Error or K-char.
   txd_extend_tc_d <= txd_data_extend_tmp(17 DOWNTO 16);
   tx_data_tc_d <= txd_data_extend_tmp(15 DOWNTO 0);
   txd_data_extend_tmp <= (txd_extend_low & fifo_data_out(17 DOWNTO 10) & fifo_data_out(7 DOWNTO 0)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (NOT(rdwidth_or_auto) OR fifo_select_out_xhdl0) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          (txd_extend_high & fifo_data_out(37 DOWNTO 30) & fifo_data_out(27 DOWNTO 20)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          (txd_extend_int(1 DOWNTO 0) & tx_data(17 DOWNTO 10) & tx_data(7 DOWNTO 0)) WHEN ((txfifo_dis AND (NOT(rdwidth_or_auto) OR NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          tx_data_tc_d_others;
   
   -- When transmitting Error(FE) or bypassing FIFO, transmit FE in the former case and transmit bypassed data/ctl in the latter
   tx_data_tc_d_others <= ("00" & "11111110" & "11111110") WHEN ((NOT(rforce_kchar) AND rforce_echar) = '1') ELSE
                          (txd_extend_int(3 DOWNTO 2) & tx_data_lt(17 DOWNTO 10) & tx_data_lt(7 DOWNTO 0)) WHEN ((txfifo_dis AND rdwidth_or_auto AND fifo_select_out_xhdl0 AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          ("00" & "00000111" & "00000111") WHEN ((NOT(rindv_tx)) = '1') ELSE
                          ("00" & "10111100" & "10111100");
   
   -- read enable & 
   -- read enable sync (for byte serializer output enable)
   
   --rd_enable0   <= txfifo_en;
   -- rd_enable0   <= 1'b1;
   xhdl12 <= (rd_enable0p5 AND NOT(pld_rd_dis_edge)) WHEN (rtxphfifopldctl_en = '1') ELSE
                          rd_enable0p5;
   xhdl13 <= rd_enable1 WHEN (rindv_tx = '1') ELSE
                          rd_enable_centrl;
   xhdl14 <= rd_enable_quad_up WHEN (rmaster_up_tx = '1') ELSE
                          rd_enable_quad_down;
   xhdl15 <= (xhdl13) WHEN (rmaster_tx = '1') ELSE
                          (xhdl14);
   
   --txfifo_en_rclk0 <= txfifo_en;
   
   -- start with valid data, so rd_enable_sync serves as dout valid
   -- ideally should be "rptr_bin == 3'd7", 
   -- but fifo_data_out is registered (1 clk delay). rd_enable_sync is
   -- used in high/low byte selection enable
   xhdl16 <= rd_enable1 WHEN (rindv_tx = '1') ELSE
                          rd_enable_centrl;
   xhdl17 <= rd_enable_quad_up WHEN (rmaster_up_tx = '1') ELSE
                          rd_enable_quad_down;
   xhdl18 <= (xhdl16) WHEN (rmaster_tx = '1') ELSE
                          (xhdl17);
   PROCESS (soft_reset_rclk1_wire, fifo_rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_rclk1_wire = '1') THEN
         pld_rd_dis0 <=  TRANSPORT '0' AFTER 1 ps;
         pld_rd_dis1 <=  TRANSPORT '0' AFTER 1 ps;
         pld_rd_dis2 <=  TRANSPORT '0' AFTER 1 ps;
         pld_rd_dis_edge <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable0 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable0p5 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable1 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable2_xhdl3 <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_rclk0 <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_rclk1 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable_sync_xhdl4 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (fifo_rd_clk'EVENT AND fifo_rd_clk = '1') THEN
         pld_rd_dis0 <=  TRANSPORT pld_rd_dis AFTER 1 ps;
         pld_rd_dis1 <=  TRANSPORT pld_rd_dis0 AFTER 1 ps;
         pld_rd_dis2 <=  TRANSPORT pld_rd_dis1 AFTER 1 ps;
         pld_rd_dis_edge <=  TRANSPORT int2bit((pld_rd_dis2 /= pld_rd_dis1)) AFTER 1 ps;
         rd_enable0 <=  TRANSPORT NOT((rauto_speed_ena AND dis_pc_byte)) AFTER 1 ps;
         rd_enable0p5 <=  TRANSPORT rd_enable0 AFTER 1 ps;
         rd_enable1 <=  TRANSPORT xhdl12 AFTER 1 ps;
         rd_enable2_xhdl3 <=  TRANSPORT xhdl15 AFTER 1 ps;
         txfifo_en_rclk0 <=  TRANSPORT '1' AFTER 1 ps;
         txfifo_en_rclk1 <=  TRANSPORT txfifo_en_rclk0 AFTER 1 ps;
         IF (rphfifo_regmode_tx = '1') THEN
            rd_enable_sync_xhdl4 <=  TRANSPORT '1' AFTER 1 ps;
         ELSIF (rd_enable_sync_xhdl4 = '0' AND rptr_bin_xhdl5 = "000") THEN
            rd_enable_sync_xhdl4 <=  TRANSPORT xhdl18 AFTER 1 ps;
         ELSIF (txfifo_en_rclk1 = '0') THEN
            rd_enable_sync_xhdl4 <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_rclk1 or posedge fifo_rd_clk)
   
   
   -- PIPE enabled, txd[21] & txd[10] are used as PIPE electric idle
   -- hence in PIPE mode, txd[21] & txd[10](crd_enforce_value) are forced to txd[20] & txd[9] 
   -- (crd_enforce_enable) to have crd negative enable.
   -- crd positive enable is not provided in PIPE mode
   xhdl19 <= (txd_extend_tc_d(1) & tx_data_9_tc_d(0)) WHEN (rtx_pipe_enable = '1') ELSE
                           txd_extend_tc_d;
   PROCESS (soft_reset, refclk_b_in)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset = '1') THEN
         tx_data_9_tc_mux <=  TRANSPORT "00" AFTER 1 ps;
         tx_ctl_tc_mux <=  TRANSPORT "00" AFTER 1 ps;
         tx_data_tc_mux <=  TRANSPORT "0000000000000000" AFTER 1 ps;
         txd_extend_tc_mux <=  TRANSPORT "00" AFTER 1 ps;
         tx_data_lt <=  TRANSPORT "00000000000000000000" AFTER 1 ps;
         d21_5_eq_n <=  TRANSPORT "11" AFTER 1 ps;
         d2_2_eq_n <=  TRANSPORT "11" AFTER 1 ps;
         k_det_sync1 <=  TRANSPORT "00" AFTER 1 ps;
         k_det <=  TRANSPORT "00" AFTER 1 ps;
         pipe_electric_idle <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
         tx_data_9_tc_mux <=  TRANSPORT tx_data_9_tc_d AFTER 1 ps;
         tx_ctl_tc_mux <=  TRANSPORT tx_ctl_tc_d AFTER 1 ps;
         tx_data_tc_mux <=  TRANSPORT tx_data_tc_d AFTER 1 ps;
         txd_extend_tc_mux <=  TRANSPORT xhdl19 AFTER 1 ps;
         
         pipe_electric_idle <=  TRANSPORT txd_extend_tc_d(0) AFTER 1 ps;
         d21_5_eq_n <=  TRANSPORT d21_5_eq_n_d AFTER 1 ps;
         d2_2_eq_n <=  TRANSPORT d2_2_eq_n_d AFTER 1 ps;
         
         k_det <=  TRANSPORT k_det_sync1 AFTER 1 ps;
         IF ((rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) = '1') THEN
            
            tx_data_lt <=  TRANSPORT tx_data(39 DOWNTO 20) AFTER 1 ps;
         END IF;
         IF (((tx_ctl_tc_d(0)) & (tx_data_tc_d(7 DOWNTO 0))) = "110111100") THEN
            k_det_sync1(0) <=  TRANSPORT '1' AFTER 1 ps;
         ELSE
            
            k_det_sync1(0) <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
         IF (((tx_ctl_tc_d(1)) & (tx_data_tc_d(15 DOWNTO 8))) = "110111100") THEN
            k_det_sync1(1) <=  TRANSPORT '1' AFTER 1 ps;
         ELSE
            k_det_sync1(1) <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset or posedge refclk_b_in)
   
   -- byte serializer high/low select
   --txfifo_en_refclk0 <= txfifo_en;
   -- txfifo_en_refclk0 <= 1'b1;
   
   -- was ~fifo_select_in, it allows 1 cycle to send the signal across x4, x8 channels
   xhdl20 <= NOT(fifo_select_out_xhdl0) WHEN (rindv_tx = '1') ELSE
                     NOT(fifo_select_in_centrl);
   xhdl21 <= NOT(fifo_select_in_quad_up) WHEN (rmaster_up_tx = '1') ELSE
                     NOT(fifo_select_in_quad_down);
   xhdl22 <= (xhdl20) WHEN (rmaster_tx = '1') ELSE
                     (xhdl21);
   PROCESS (soft_reset, refclk_b_in)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset = '1') THEN
         rd_enable_sync_refclk_b_in <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_refclk0 <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_refclk1 <=  TRANSPORT '0' AFTER 1 ps;
         fifo_select_out_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
         txfifo_en_refclk0 <=  TRANSPORT NOT((rauto_speed_ena AND dis_pc_byte)) AFTER 1 ps;
         txfifo_en_refclk1 <=  TRANSPORT txfifo_en_refclk0 AFTER 1 ps;
         IF (txfifo_en_refclk1 = '0') THEN
            rd_enable_sync_refclk_b_in <=  TRANSPORT '0' AFTER 1 ps;
         ELSIF (rd_enable_sync_refclk_b_in = '0') THEN
            rd_enable_sync_refclk_b_in <=  TRANSPORT rd_enable2_xhdl3 AFTER 1 ps;
         END IF;
         IF (rd_enable_sync_refclk_b_in = '1') THEN
            fifo_select_out_xhdl0 <=  TRANSPORT xhdl22 AFTER 1 ps;
         ELSE
            fifo_select_out_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset or posedge refclk_b_in)
   
   tx_data_9_tc <= tx_data_9_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                   tx_data_9_tc_mux;
   tx_ctl_tc <= tx_ctl_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                tx_ctl_tc_mux;
   tx_data_tc <= tx_data_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                 tx_data_tc_mux;
   txd_extend_tc <= txd_extend_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                    txd_extend_tc_mux;
   
   -- LMC bin to gray for eidlinfersel
   
   PROCESS (fifo_wr_clk, soft_reset_wclk1_wire)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_wclk1_wire = '1') THEN
         gray_eidleinfersel <= "000";
      ELSIF (fifo_wr_clk'EVENT AND fifo_wr_clk = '1') THEN
         CASE eidleinfersel IS
            WHEN "000" =>
               gray_eidleinfersel <= "000";
            WHEN "001" =>
               gray_eidleinfersel <= "001";
            WHEN "010" =>
               gray_eidleinfersel <= "011";
            WHEN "011" =>
               gray_eidleinfersel <= "010";
            WHEN "100" =>
               gray_eidleinfersel <= "110";
            WHEN "101" =>
               gray_eidleinfersel <= "111";
            WHEN "110" =>
               gray_eidleinfersel <= "101";
            WHEN "111" =>
               gray_eidleinfersel <= "100";
            WHEN OTHERS =>
               gray_eidleinfersel <= "000";
         END CASE;
      END IF;
   END PROCESS;
   
   
END trans;



-- tx_ctrl--IP Functional Simulation Model
--VERSION_BEGIN 10.0SP1 cbx_mgl 2010:08:18:21:20:44:SJ cbx_simgen 2010:08:18:21:16:35:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 211 mux21 446 oper_add 10 oper_selector 88 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  cycloneiv_hssi_tx_digi_bist_gen IS 
	 PORT 
	 ( 
		 bist_ctl_sg	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 bist_data_sg	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 rbist_sel	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rbisten_tx	:	IN  STD_LOGIC;
		 rcxpat_chnl_sel	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rdwidth_tx	:	IN  STD_LOGIC;
		 rpma_doublewidth_tx	:	IN  STD_LOGIC;
		 rpmadwidth_tx	:	IN  STD_LOGIC;
		 soft_reset	:	IN  STD_LOGIC;
		 tx_clk	:	IN  STD_LOGIC
	 ); 
 END cycloneiv_hssi_tx_digi_bist_gen;

 ARCHITECTURE RTL OF cycloneiv_hssi_tx_digi_bist_gen IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 ni001l45	:	STD_LOGIC := '0';
	 SIGNAL	 ni001l46	:	STD_LOGIC := '0';
	 SIGNAL	 nii00O39	:	STD_LOGIC := '0';
	 SIGNAL	 nii00O40	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii00O40_w_lg_w_lg_q228w230w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii00O40_w_lg_q228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii01O41	:	STD_LOGIC := '0';
	 SIGNAL	 nii01O42	:	STD_LOGIC := '0';
	 SIGNAL	 nii0il37	:	STD_LOGIC := '0';
	 SIGNAL	 nii0il38	:	STD_LOGIC := '0';
	 SIGNAL	 nii0li35	:	STD_LOGIC := '0';
	 SIGNAL	 nii0li36	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii0li36_w_lg_w_lg_q207w208w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0li36_w_lg_q207w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii0lO33	:	STD_LOGIC := '0';
	 SIGNAL	 nii0lO34	:	STD_LOGIC := '0';
	 SIGNAL	 nii0OO31	:	STD_LOGIC := '0';
	 SIGNAL	 nii0OO32	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii0OO32_w_lg_w_lg_q155w156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0OO32_w_lg_q155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii1OO43	:	STD_LOGIC := '0';
	 SIGNAL	 nii1OO44	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii1OO44_w_lg_w_lg_q295w296w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1OO44_w_lg_q295w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii0i23	:	STD_LOGIC := '0';
	 SIGNAL	 niii0i24	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii0i24_w_lg_w_lg_q129w130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii0i24_w_lg_q129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii0O21	:	STD_LOGIC := '0';
	 SIGNAL	 niii0O22	:	STD_LOGIC := '0';
	 SIGNAL	 niii1i29	:	STD_LOGIC := '0';
	 SIGNAL	 niii1i30	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii1i30_w_lg_w_lg_q152w153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii1i30_w_lg_q152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii1l27	:	STD_LOGIC := '0';
	 SIGNAL	 niii1l28	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii1l28_w_lg_w_lg_q141w142w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii1l28_w_lg_q141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii1O25	:	STD_LOGIC := '0';
	 SIGNAL	 niii1O26	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii1O26_w_lg_w_lg_q132w133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii1O26_w_lg_q132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niillO19	:	STD_LOGIC := '0';
	 SIGNAL	 niillO20	:	STD_LOGIC := '0';
	 SIGNAL	 niilOi17	:	STD_LOGIC := '0';
	 SIGNAL	 niilOi18	:	STD_LOGIC := '0';
	 SIGNAL	 niilOO15	:	STD_LOGIC := '0';
	 SIGNAL	 niilOO16	:	STD_LOGIC := '0';
	 SIGNAL  wire_niilOO16_w_lg_w_lg_q78w79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilOO16_w_lg_q78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niiO0i10	:	STD_LOGIC := '0';
	 SIGNAL	 niiO0i9	:	STD_LOGIC := '0';
	 SIGNAL	 niiO0O7	:	STD_LOGIC := '0';
	 SIGNAL	 niiO0O8	:	STD_LOGIC := '0';
	 SIGNAL	 niiO1i13	:	STD_LOGIC := '0';
	 SIGNAL	 niiO1i14	:	STD_LOGIC := '0';
	 SIGNAL  wire_niiO1i14_w_lg_w_lg_q53w54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO1i14_w_lg_q53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niiO1l11	:	STD_LOGIC := '0';
	 SIGNAL	 niiO1l12	:	STD_LOGIC := '0';
	 SIGNAL	 niiOll5	:	STD_LOGIC := '0';
	 SIGNAL	 niiOll6	:	STD_LOGIC := '0';
	 SIGNAL	 niiOOl3	:	STD_LOGIC := '0';
	 SIGNAL	 niiOOl4	:	STD_LOGIC := '0';
	 SIGNAL	 nil11i1	:	STD_LOGIC := '0';
	 SIGNAL	 nil11i2	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil11i2_w_lg_q4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n100i	:	STD_LOGIC := '0';
	 SIGNAL	n100l	:	STD_LOGIC := '0';
	 SIGNAL	n100O	:	STD_LOGIC := '0';
	 SIGNAL	n101i	:	STD_LOGIC := '0';
	 SIGNAL	n101l	:	STD_LOGIC := '0';
	 SIGNAL	n101O	:	STD_LOGIC := '0';
	 SIGNAL	n10ii	:	STD_LOGIC := '0';
	 SIGNAL	n10il	:	STD_LOGIC := '0';
	 SIGNAL	n10iO	:	STD_LOGIC := '0';
	 SIGNAL	n10li	:	STD_LOGIC := '0';
	 SIGNAL	n10ll	:	STD_LOGIC := '0';
	 SIGNAL	n10lO	:	STD_LOGIC := '0';
	 SIGNAL	n10Oi	:	STD_LOGIC := '0';
	 SIGNAL	n10Ol	:	STD_LOGIC := '0';
	 SIGNAL	n10OO	:	STD_LOGIC := '0';
	 SIGNAL	n110i	:	STD_LOGIC := '0';
	 SIGNAL	n110l	:	STD_LOGIC := '0';
	 SIGNAL	n110O	:	STD_LOGIC := '0';
	 SIGNAL	n111i	:	STD_LOGIC := '0';
	 SIGNAL	n111l	:	STD_LOGIC := '0';
	 SIGNAL	n111O	:	STD_LOGIC := '0';
	 SIGNAL	n11ii	:	STD_LOGIC := '0';
	 SIGNAL	n11il	:	STD_LOGIC := '0';
	 SIGNAL	n11iO	:	STD_LOGIC := '0';
	 SIGNAL	n11li	:	STD_LOGIC := '0';
	 SIGNAL	n11ll	:	STD_LOGIC := '0';
	 SIGNAL	n11lO	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol	:	STD_LOGIC := '0';
	 SIGNAL	n11OO	:	STD_LOGIC := '0';
	 SIGNAL	n1i0i	:	STD_LOGIC := '0';
	 SIGNAL	n1i0l	:	STD_LOGIC := '0';
	 SIGNAL	n1i0O	:	STD_LOGIC := '0';
	 SIGNAL	n1i1i	:	STD_LOGIC := '0';
	 SIGNAL	n1i1l	:	STD_LOGIC := '0';
	 SIGNAL	n1i1O	:	STD_LOGIC := '0';
	 SIGNAL	n1iii	:	STD_LOGIC := '0';
	 SIGNAL	n1iil	:	STD_LOGIC := '0';
	 SIGNAL	n1iiO	:	STD_LOGIC := '0';
	 SIGNAL	n1ili	:	STD_LOGIC := '0';
	 SIGNAL	n1ill	:	STD_LOGIC := '0';
	 SIGNAL	n1ilO	:	STD_LOGIC := '0';
	 SIGNAL	n1iOi	:	STD_LOGIC := '0';
	 SIGNAL	n1iOl	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO	:	STD_LOGIC := '0';
	 SIGNAL	n1l0i	:	STD_LOGIC := '0';
	 SIGNAL	n1l0l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1i	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O	:	STD_LOGIC := '0';
	 SIGNAL	n1lii	:	STD_LOGIC := '0';
	 SIGNAL	nliliO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOil	:	STD_LOGIC := '0';
	 SIGNAL	nlOOiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOli	:	STD_LOGIC := '0';
	 SIGNAL	nlOOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w1510w1511w1512w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w1501w1502w1503w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w1510w1511w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w1501w1502w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w1510w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w1501w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1506w1507w1508w1509w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1480w1497w1499w1500w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n11ii897w899w900w901w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n101i1506w1507w1508w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n11ii902w903w904w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1497w1499w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n101i1506w1507w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n11ii902w903w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n101i1480w1482w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n101i1480w1497w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n11ii897w899w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_nlOOiO1476w1543w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_nlOOOO1529w1530w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n101i1506w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11ii902w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOO1538w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n101i1480w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n110i1516w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n110O898w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n111O1524w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11ii897w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11il1494w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11iO1492w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11li1490w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11ll1488w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11lO1486w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11Oi1484w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11Ol1498w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11OO1481w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nliliO1544w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOil1477w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOiO1476w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOlO1533w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOi1531w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOl1537w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOO1529w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n1ill1401w1402w1403w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n1ill1401w1402w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n1ill1401w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n1l0i1211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1liO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n1lil_w_lg_w_lg_w_lg_n1liO1051w1092w1093w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lil_w_lg_w_lg_n1liO1051w1092w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lil_w_lg_n1liO1051w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nl00il	:	STD_LOGIC := '0';
	 SIGNAL	nl00iO	:	STD_LOGIC := '0';
	 SIGNAL	nl00li	:	STD_LOGIC := '0';
	 SIGNAL	nl00ll	:	STD_LOGIC := '0';
	 SIGNAL	nl00lO	:	STD_LOGIC := '0';
	 SIGNAL	nl00Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl00Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl00OO	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl0iii	:	STD_LOGIC := '0';
	 SIGNAL	nl0iil	:	STD_LOGIC := '0';
	 SIGNAL	nl0iiO	:	STD_LOGIC := '0';
	 SIGNAL	nl0ili	:	STD_LOGIC := '0';
	 SIGNAL	nl0ill	:	STD_LOGIC := '0';
	 SIGNAL	nl0ilO	:	STD_LOGIC := '0';
	 SIGNAL	nl0iOi	:	STD_LOGIC := '0';
	 SIGNAL	nl0iOl	:	STD_LOGIC := '0';
	 SIGNAL	nl0iOO	:	STD_LOGIC := '0';
	 SIGNAL	nl0l0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl0l1i	:	STD_LOGIC := '0';
	 SIGNAL	nl0l1l	:	STD_LOGIC := '0';
	 SIGNAL	nl0l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl0lii	:	STD_LOGIC := '0';
	 SIGNAL	nl0lil	:	STD_LOGIC := '0';
	 SIGNAL	nl0liO	:	STD_LOGIC := '0';
	 SIGNAL	nl0lli	:	STD_LOGIC := '0';
	 SIGNAL	nl0lll	:	STD_LOGIC := '0';
	 SIGNAL	nl0llO	:	STD_LOGIC := '0';
	 SIGNAL	nl0lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl0lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl0lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl0O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl0O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl0O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl0O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl0OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nli11i	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl0OOO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nl0OOO_w_lg_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w2253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_w_lg_nl0iOl2241w2243w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iii2259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iil2257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iiO2255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0ili2248w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0ill2246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0ilO2244w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iOi2242w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iOl2241w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0O0l2201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0O0l2215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nli11O	:	STD_LOGIC := '0';
	 SIGNAL  wire_nli11l_w_lg_nli11O2169w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0lOi	:	STD_LOGIC := '0';
	 SIGNAL	niO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO0O	:	STD_LOGIC := '0';
	 SIGNAL	niOii	:	STD_LOGIC := '0';
	 SIGNAL	niOil	:	STD_LOGIC := '0';
	 SIGNAL	niOiO	:	STD_LOGIC := '0';
	 SIGNAL	niOli	:	STD_LOGIC := '0';
	 SIGNAL	niOll	:	STD_LOGIC := '0';
	 SIGNAL	niOlO	:	STD_LOGIC := '0';
	 SIGNAL	niOOi	:	STD_LOGIC := '0';
	 SIGNAL	niOOl	:	STD_LOGIC := '0';
	 SIGNAL	niOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl00i	:	STD_LOGIC := '0';
	 SIGNAL	nl00l	:	STD_LOGIC := '0';
	 SIGNAL	nl00O	:	STD_LOGIC := '0';
	 SIGNAL	nl01i	:	STD_LOGIC := '0';
	 SIGNAL	nl01l	:	STD_LOGIC := '0';
	 SIGNAL	nl01O	:	STD_LOGIC := '0';
	 SIGNAL	nl0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl0il	:	STD_LOGIC := '0';
	 SIGNAL	nl0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl0li	:	STD_LOGIC := '0';
	 SIGNAL	nl0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11i	:	STD_LOGIC := '0';
	 SIGNAL	nl11l	:	STD_LOGIC := '0';
	 SIGNAL	nl11O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1OO	:	STD_LOGIC := '0';
	 SIGNAL	nli0i	:	STD_LOGIC := '0';
	 SIGNAL	nli0l	:	STD_LOGIC := '0';
	 SIGNAL	nli0O	:	STD_LOGIC := '0';
	 SIGNAL	nli1i	:	STD_LOGIC := '0';
	 SIGNAL	nli1l	:	STD_LOGIC := '0';
	 SIGNAL	nli1O	:	STD_LOGIC := '0';
	 SIGNAL	nliil	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_niOll766w767w768w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niOll766w767w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niO0O762w771w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOll766w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0lOi772w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niO0l763w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niO0O762w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOii769w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nl00O654w655w656w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nl00O654w655w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl00O654w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlili	:	STD_LOGIC := '0';
	 SIGNAL	wire_nliiO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w194w195w196w197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w120w121w122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w194w195w196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w120w121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w194w195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w223w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w261w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w222w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w256w257w258w259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w217w218w219w220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w114w115w116w117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w188w189w190w191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w256w257w258w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w217w218w219w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w114w115w116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w188w189w190w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w256w257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w217w218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w114w115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w188w189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w217w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w188w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w216w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w214w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili109w110w111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_nlili160w161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_nlili109w110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_nlili109w184w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_nlili160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_nlili109w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO_w_lg_dataout1647w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00Oi_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n00Oi_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_n00Oi_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01iO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n01iO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n01iO_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1lOi_a	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1lOi_b	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1lOi_o	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Oll_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n1Oll_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n1Oll_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n1OOO_a	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OOO_b	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OOO_o	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli0ll_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0ll_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0ll_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0lO_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0lO_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0lO_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0Oi_a	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0Oi_b	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0Oi_o	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nliOl_a	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOl_b	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOl_o	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllli_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nllli_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nllli_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iil_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iiO_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iiO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0ilO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0ilO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ilO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0iOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0l1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0l1i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0l1O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0l1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l1O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0lii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lil_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0liO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0liO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0liO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lli_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lli_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lli_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O0l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0O0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0O1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oil_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Oil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oll_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oll_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Oll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0OOl_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n0OOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0OOl_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni00l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni00l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni00l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni01i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01O_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01O_o	:	STD_LOGIC;
	 SIGNAL  wire_ni01O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ii_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ii_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0ii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0iO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0iO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ll_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0ll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_data	:	STD_LOGIC_VECTOR (9 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oi_sel	:	STD_LOGIC_VECTOR (9 DOWNTO 0);
	 SIGNAL  wire_ni10i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni10i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni10i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni11l_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni11l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni11l_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni1Ol_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni1Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1Ol_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nil00l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil00l_o	:	STD_LOGIC;
	 SIGNAL  wire_nil00l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil01O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nil01O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil0il_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0il_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0il_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0li_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0li_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0li_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0Oi_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0Oi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1li_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nil1li_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1li_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nil1lO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1lO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1OO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1OO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili0i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nili0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nili0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nili0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nili0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nili1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nili1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niliil_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niliil_o	:	STD_LOGIC;
	 SIGNAL  wire_niliil_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nilili_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nilili_o	:	STD_LOGIC;
	 SIGNAL  wire_nilili_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nililO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nililO_o	:	STD_LOGIC;
	 SIGNAL  wire_nililO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niliOl_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niliOl_o	:	STD_LOGIC;
	 SIGNAL  wire_niliOl_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nill0O_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nill0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nill0O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nill1i_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nill1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nill1i_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nill1O_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nill1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nill1O_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nillil_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nillil_o	:	STD_LOGIC;
	 SIGNAL  wire_nillil_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nillli_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nillli_o	:	STD_LOGIC;
	 SIGNAL  wire_nillli_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilllO_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilllO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilllO_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nillOl_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nillOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nillOl_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilO0l_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO0l_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO1i_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO1i_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO1O_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO1O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOii_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOii_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOii_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOiO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOiO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOli_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOli_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOlO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOlO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOOl_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOOl_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_niO11i_data	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_niO11i_o	:	STD_LOGIC;
	 SIGNAL  wire_niO11i_sel	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_nlilOi_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nlilOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlilOi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nliO0l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nliO0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO1i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nliO1i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliO1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nliO1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliOii_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliOli_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOli_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOlO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOlO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOi_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll00O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll00O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll00O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll01i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll01i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll01i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll01O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll01O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0iO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0iO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0lO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0lO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0OO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0OO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll10i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll10i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll10i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll10O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll10O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll10O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll11l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll11l_o	:	STD_LOGIC;
	 SIGNAL  wire_nll11l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1il_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nll1il_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1il_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nll1ll_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1ll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1Ol_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nll1Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1Ol_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlli0i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlli0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlli0i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlliil_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliil_o	:	STD_LOGIC;
	 SIGNAL  wire_nlliil_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllili_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllili_o	:	STD_LOGIC;
	 SIGNAL  wire_nllili_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllilO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllilO_o	:	STD_LOGIC;
	 SIGNAL  wire_nllilO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOi_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlliOi_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlliOO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll0i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlll0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll0O_data	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_nlll0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlll0O_sel	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_nlll1l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlll1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_rpmadwidth_tx2w5w6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rpmadwidth_tx2w5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rpmadwidth_tx2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rbist_sel_range12w20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rcxpat_chnl_sel_range755w760w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni000l1442w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOi1037w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOl1019w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOO996w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l0l913w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l0O912w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1i983w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1l970w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1O957w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lii914w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lil911w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0liO910w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lll909w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0llO908w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lOl907w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O0i894w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O0O893w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O1i896w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O1l895w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0Oii1237w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0Oil891w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0OiO892w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0Oli906w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0OOi889w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0OOl888w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni1lll2233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni1Oil2081w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii00l246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii01i291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii01l267w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii0ii229w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii0ll204w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii0Ol176w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii11i695w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii1Ol312w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiil107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiiO106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiili108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiill105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiilO447w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiOi102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiOl103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiOO104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niil0l99w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niil0O98w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niil1O100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niilii97w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niilil96w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiliO95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiOOi445w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rpma_doublewidth_tx1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rbist_sel_range14w15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rcxpat_chnl_sel_range757w758w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  ni000i :	STD_LOGIC;
	 SIGNAL  ni000l :	STD_LOGIC;
	 SIGNAL  ni000O :	STD_LOGIC;
	 SIGNAL  ni001i :	STD_LOGIC;
	 SIGNAL  ni001O :	STD_LOGIC;
	 SIGNAL  ni00ii :	STD_LOGIC;
	 SIGNAL  ni00il :	STD_LOGIC;
	 SIGNAL  ni00iO :	STD_LOGIC;
	 SIGNAL  ni00li :	STD_LOGIC;
	 SIGNAL  ni00ll :	STD_LOGIC;
	 SIGNAL  ni00lO :	STD_LOGIC;
	 SIGNAL  ni00Oi :	STD_LOGIC;
	 SIGNAL  ni00Ol :	STD_LOGIC;
	 SIGNAL  ni00OO :	STD_LOGIC;
	 SIGNAL  ni010i :	STD_LOGIC;
	 SIGNAL  ni010l :	STD_LOGIC;
	 SIGNAL  ni010O :	STD_LOGIC;
	 SIGNAL  ni011i :	STD_LOGIC;
	 SIGNAL  ni011l :	STD_LOGIC;
	 SIGNAL  ni011O :	STD_LOGIC;
	 SIGNAL  ni01ii :	STD_LOGIC;
	 SIGNAL  ni01il :	STD_LOGIC;
	 SIGNAL  ni01iO :	STD_LOGIC;
	 SIGNAL  ni01li :	STD_LOGIC;
	 SIGNAL  ni01ll :	STD_LOGIC;
	 SIGNAL  ni01lO :	STD_LOGIC;
	 SIGNAL  ni01Oi :	STD_LOGIC;
	 SIGNAL  ni01Ol :	STD_LOGIC;
	 SIGNAL  ni01OO :	STD_LOGIC;
	 SIGNAL  ni0i0i :	STD_LOGIC;
	 SIGNAL  ni0i0l :	STD_LOGIC;
	 SIGNAL  ni0i0O :	STD_LOGIC;
	 SIGNAL  ni0i1i :	STD_LOGIC;
	 SIGNAL  ni0i1l :	STD_LOGIC;
	 SIGNAL  ni0i1O :	STD_LOGIC;
	 SIGNAL  ni0iii :	STD_LOGIC;
	 SIGNAL  ni0iil :	STD_LOGIC;
	 SIGNAL  ni0iiO :	STD_LOGIC;
	 SIGNAL  ni0ili :	STD_LOGIC;
	 SIGNAL  ni0ill :	STD_LOGIC;
	 SIGNAL  ni0ilO :	STD_LOGIC;
	 SIGNAL  ni0iOi :	STD_LOGIC;
	 SIGNAL  ni0iOl :	STD_LOGIC;
	 SIGNAL  ni0iOO :	STD_LOGIC;
	 SIGNAL  ni0l0i :	STD_LOGIC;
	 SIGNAL  ni0l0l :	STD_LOGIC;
	 SIGNAL  ni0l0O :	STD_LOGIC;
	 SIGNAL  ni0l1i :	STD_LOGIC;
	 SIGNAL  ni0l1l :	STD_LOGIC;
	 SIGNAL  ni0l1O :	STD_LOGIC;
	 SIGNAL  ni0lii :	STD_LOGIC;
	 SIGNAL  ni0lil :	STD_LOGIC;
	 SIGNAL  ni0liO :	STD_LOGIC;
	 SIGNAL  ni0lli :	STD_LOGIC;
	 SIGNAL  ni0lll :	STD_LOGIC;
	 SIGNAL  ni0llO :	STD_LOGIC;
	 SIGNAL  ni0lOi :	STD_LOGIC;
	 SIGNAL  ni0lOl :	STD_LOGIC;
	 SIGNAL  ni0lOO :	STD_LOGIC;
	 SIGNAL  ni0O0i :	STD_LOGIC;
	 SIGNAL  ni0O0l :	STD_LOGIC;
	 SIGNAL  ni0O0O :	STD_LOGIC;
	 SIGNAL  ni0O1i :	STD_LOGIC;
	 SIGNAL  ni0O1l :	STD_LOGIC;
	 SIGNAL  ni0O1O :	STD_LOGIC;
	 SIGNAL  ni0Oii :	STD_LOGIC;
	 SIGNAL  ni0Oil :	STD_LOGIC;
	 SIGNAL  ni0OiO :	STD_LOGIC;
	 SIGNAL  ni0Oli :	STD_LOGIC;
	 SIGNAL  ni0Oll :	STD_LOGIC;
	 SIGNAL  ni0OlO :	STD_LOGIC;
	 SIGNAL  ni0OOi :	STD_LOGIC;
	 SIGNAL  ni0OOl :	STD_LOGIC;
	 SIGNAL  ni0OOO :	STD_LOGIC;
	 SIGNAL  ni1lll :	STD_LOGIC;
	 SIGNAL  ni1llO :	STD_LOGIC;
	 SIGNAL  ni1lOi :	STD_LOGIC;
	 SIGNAL  ni1lOl :	STD_LOGIC;
	 SIGNAL  ni1lOO :	STD_LOGIC;
	 SIGNAL  ni1O0i :	STD_LOGIC;
	 SIGNAL  ni1O0l :	STD_LOGIC;
	 SIGNAL  ni1O0O :	STD_LOGIC;
	 SIGNAL  ni1O1i :	STD_LOGIC;
	 SIGNAL  ni1O1l :	STD_LOGIC;
	 SIGNAL  ni1O1O :	STD_LOGIC;
	 SIGNAL  ni1Oii :	STD_LOGIC;
	 SIGNAL  ni1Oil :	STD_LOGIC;
	 SIGNAL  ni1OiO :	STD_LOGIC;
	 SIGNAL  ni1Oli :	STD_LOGIC;
	 SIGNAL  ni1Oll :	STD_LOGIC;
	 SIGNAL  ni1OlO :	STD_LOGIC;
	 SIGNAL  ni1OOi :	STD_LOGIC;
	 SIGNAL  ni1OOl :	STD_LOGIC;
	 SIGNAL  ni1OOO :	STD_LOGIC;
	 SIGNAL  nii00l :	STD_LOGIC;
	 SIGNAL  nii01i :	STD_LOGIC;
	 SIGNAL  nii01l :	STD_LOGIC;
	 SIGNAL  nii0ii :	STD_LOGIC;
	 SIGNAL  nii0ll :	STD_LOGIC;
	 SIGNAL  nii0Ol :	STD_LOGIC;
	 SIGNAL  nii10i :	STD_LOGIC;
	 SIGNAL  nii10l :	STD_LOGIC;
	 SIGNAL  nii10O :	STD_LOGIC;
	 SIGNAL  nii11i :	STD_LOGIC;
	 SIGNAL  nii11l :	STD_LOGIC;
	 SIGNAL  nii11O :	STD_LOGIC;
	 SIGNAL  nii1ii :	STD_LOGIC;
	 SIGNAL  nii1il :	STD_LOGIC;
	 SIGNAL  nii1iO :	STD_LOGIC;
	 SIGNAL  nii1li :	STD_LOGIC;
	 SIGNAL  nii1ll :	STD_LOGIC;
	 SIGNAL  nii1lO :	STD_LOGIC;
	 SIGNAL  nii1Oi :	STD_LOGIC;
	 SIGNAL  nii1Ol :	STD_LOGIC;
	 SIGNAL  niii0l :	STD_LOGIC;
	 SIGNAL  niiiil :	STD_LOGIC;
	 SIGNAL  niiiiO :	STD_LOGIC;
	 SIGNAL  niiili :	STD_LOGIC;
	 SIGNAL  niiill :	STD_LOGIC;
	 SIGNAL  niiilO :	STD_LOGIC;
	 SIGNAL  niiiOi :	STD_LOGIC;
	 SIGNAL  niiiOl :	STD_LOGIC;
	 SIGNAL  niiiOO :	STD_LOGIC;
	 SIGNAL  niil0i :	STD_LOGIC;
	 SIGNAL  niil0l :	STD_LOGIC;
	 SIGNAL  niil0O :	STD_LOGIC;
	 SIGNAL  niil1i :	STD_LOGIC;
	 SIGNAL  niil1l :	STD_LOGIC;
	 SIGNAL  niil1O :	STD_LOGIC;
	 SIGNAL  niilii :	STD_LOGIC;
	 SIGNAL  niilil :	STD_LOGIC;
	 SIGNAL  niiliO :	STD_LOGIC;
	 SIGNAL  niilli :	STD_LOGIC;
	 SIGNAL  niilll :	STD_LOGIC;
	 SIGNAL  niilOl :	STD_LOGIC;
	 SIGNAL  niiOil :	STD_LOGIC;
	 SIGNAL  niiOiO :	STD_LOGIC;
	 SIGNAL  niiOli :	STD_LOGIC;
	 SIGNAL  niiOOi :	STD_LOGIC;
	 SIGNAL  wire_w_rbist_sel_range12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rbist_sel_range14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rcxpat_chnl_sel_range755w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rcxpat_chnl_sel_range757w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_w_lg_w_lg_rpmadwidth_tx2w5w6w(0) <= wire_w_lg_w_lg_rpmadwidth_tx2w5w(0) AND rdwidth_tx;
	wire_w_lg_w_lg_rpmadwidth_tx2w5w(0) <= wire_w_lg_rpmadwidth_tx2w(0) AND wire_nil11i2_w_lg_q4w(0);
	wire_w_lg_rpmadwidth_tx2w(0) <= rpmadwidth_tx AND wire_w_lg_rpma_doublewidth_tx1w(0);
	wire_w_lg_w_rbist_sel_range12w20w(0) <= wire_w_rbist_sel_range12w(0) AND wire_w_lg_w_rbist_sel_range14w15w(0);
	wire_w_lg_w_rcxpat_chnl_sel_range755w760w(0) <= wire_w_rcxpat_chnl_sel_range755w(0) AND wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0);
	wire_w_lg_ni000l1442w(0) <= NOT ni000l;
	wire_w_lg_ni0iOi1037w(0) <= NOT ni0iOi;
	wire_w_lg_ni0iOl1019w(0) <= NOT ni0iOl;
	wire_w_lg_ni0iOO996w(0) <= NOT ni0iOO;
	wire_w_lg_ni0l0l913w(0) <= NOT ni0l0l;
	wire_w_lg_ni0l0O912w(0) <= NOT ni0l0O;
	wire_w_lg_ni0l1i983w(0) <= NOT ni0l1i;
	wire_w_lg_ni0l1l970w(0) <= NOT ni0l1l;
	wire_w_lg_ni0l1O957w(0) <= NOT ni0l1O;
	wire_w_lg_ni0lii914w(0) <= NOT ni0lii;
	wire_w_lg_ni0lil911w(0) <= NOT ni0lil;
	wire_w_lg_ni0liO910w(0) <= NOT ni0liO;
	wire_w_lg_ni0lll909w(0) <= NOT ni0lll;
	wire_w_lg_ni0llO908w(0) <= NOT ni0llO;
	wire_w_lg_ni0lOl907w(0) <= NOT ni0lOl;
	wire_w_lg_ni0O0i894w(0) <= NOT ni0O0i;
	wire_w_lg_ni0O0O893w(0) <= NOT ni0O0O;
	wire_w_lg_ni0O1i896w(0) <= NOT ni0O1i;
	wire_w_lg_ni0O1l895w(0) <= NOT ni0O1l;
	wire_w_lg_ni0Oii1237w(0) <= NOT ni0Oii;
	wire_w_lg_ni0Oil891w(0) <= NOT ni0Oil;
	wire_w_lg_ni0OiO892w(0) <= NOT ni0OiO;
	wire_w_lg_ni0Oli906w(0) <= NOT ni0Oli;
	wire_w_lg_ni0OOi889w(0) <= NOT ni0OOi;
	wire_w_lg_ni0OOl888w(0) <= NOT ni0OOl;
	wire_w_lg_ni1lll2233w(0) <= NOT ni1lll;
	wire_w_lg_ni1Oil2081w(0) <= NOT ni1Oil;
	wire_w_lg_nii00l246w(0) <= NOT nii00l;
	wire_w_lg_nii01i291w(0) <= NOT nii01i;
	wire_w_lg_nii01l267w(0) <= NOT nii01l;
	wire_w_lg_nii0ii229w(0) <= NOT nii0ii;
	wire_w_lg_nii0ll204w(0) <= NOT nii0ll;
	wire_w_lg_nii0Ol176w(0) <= NOT nii0Ol;
	wire_w_lg_nii11i695w(0) <= NOT nii11i;
	wire_w_lg_nii1Ol312w(0) <= NOT nii1Ol;
	wire_w_lg_niiiil107w(0) <= NOT niiiil;
	wire_w_lg_niiiiO106w(0) <= NOT niiiiO;
	wire_w_lg_niiili108w(0) <= NOT niiili;
	wire_w_lg_niiill105w(0) <= NOT niiill;
	wire_w_lg_niiilO447w(0) <= NOT niiilO;
	wire_w_lg_niiiOi102w(0) <= NOT niiiOi;
	wire_w_lg_niiiOl103w(0) <= NOT niiiOl;
	wire_w_lg_niiiOO104w(0) <= NOT niiiOO;
	wire_w_lg_niil0l99w(0) <= NOT niil0l;
	wire_w_lg_niil0O98w(0) <= NOT niil0O;
	wire_w_lg_niil1O100w(0) <= NOT niil1O;
	wire_w_lg_niilii97w(0) <= NOT niilii;
	wire_w_lg_niilil96w(0) <= NOT niilil;
	wire_w_lg_niiliO95w(0) <= NOT niiliO;
	wire_w_lg_niiOOi445w(0) <= NOT niiOOi;
	wire_w_lg_rpma_doublewidth_tx1w(0) <= NOT rpma_doublewidth_tx;
	wire_w_lg_soft_reset93w(0) <= NOT soft_reset;
	wire_w_lg_w_rbist_sel_range14w15w(0) <= NOT wire_w_rbist_sel_range14w(0);
	wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0) <= NOT wire_w_rcxpat_chnl_sel_range757w(0);
	bist_ctl_sg <= ( wire_ni1O_dataout & wire_ni1l_dataout);
	bist_data_sg <= ( wire_ni1i_dataout & wire_n0OO_dataout & wire_n0Ol_dataout & wire_n0Oi_dataout & wire_n0lO_dataout & wire_n0ll_dataout & wire_n0li_dataout & wire_n0iO_dataout & wire_n0il_dataout & wire_n0ii_dataout & wire_n00O_dataout & wire_n00l_dataout & wire_n00i_dataout & wire_n01O_dataout & wire_n01l_dataout & wire_n01i_dataout);
	ni000i <= (((((((((((((n1liO OR n1lii) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil);
	ni000l <= ((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1iiO) OR n1i0O) OR n1i0l);
	ni000O <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii);
	ni001i <= (((((wire_nl0OOO_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w(0) AND wire_nl0OOO_w_lg_nl0ill2246w(0)) AND wire_nl0OOO_w_lg_nl0ili2248w(0)) AND nl0iiO) AND nl0iil) AND nl0iii);
	ni001O <= (nli11i OR nl0OOi);
	ni00ii <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1i0l);
	ni00il <= (((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1i0O) OR n1i0l);
	ni00iO <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00li <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00ll <= ((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00lO <= ((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00Oi <= (((((((((((n1liO OR n1lii) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00Ol <= (((((((((((((((n1liO OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00OO <= (((((((((((wire_n1l0O_w_lg_n1l0i1211w(0) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1i0O);
	ni010i <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni010l <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni010O <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni011i <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O1O);
	ni011l <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0i) OR nl0O1O);
	ni011O <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01ii <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01il <= ((((((((nl0OOl OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01iO <= (((((((((nl0OOl OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01li <= (((((((((nl0OlO OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01ll <= ((((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01lO <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l);
	ni01Oi <= (((((((nl0iOl AND nl0iOi) AND nl0ilO) AND nl0ill) AND nl0ili) AND nl0iiO) AND nl0iil) AND nl0iii);
	ni01Ol <= ((((((nl00Ol AND nl00Oi) AND nl00lO) AND nl00ll) AND nl00li) AND nl00iO) AND nl00il);
	ni01OO <= ((((wire_nl0OOO_w_lg_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w2253w(0) AND wire_nl0OOO_w_lg_nl0ili2248w(0)) AND wire_nl0OOO_w_lg_nl0iiO2255w(0)) AND wire_nl0OOO_w_lg_nl0iil2257w(0)) AND wire_nl0OOO_w_lg_nl0iii2259w(0));
	ni0i0i <= ((((((n1lii OR n1l1O) OR n1l1l) OR n1iOO) OR n1ill) OR n1ili) OR n1iil);
	ni0i0l <= (((((((((n1liO OR n1l0l) OR n1l0i) OR n1l1i) OR n1iOl) OR n1ilO) OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0i0O <= (((((((((((n1l0l OR n1l0i) OR n1l1l) OR n1l1i) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0i1i <= ((((((((((((((n1lii OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1i0O);
	ni0i1l <= (((((((((n1lii OR n1l0l) OR n1l0i) OR n1l1O) OR n1iOO) OR n1iOl) OR n1ilO) OR n1ill) OR n1iiO) OR n1iil);
	ni0i1O <= ((((((n1liO OR n1l1l) OR n1l1i) OR n1ili) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iii <= ((((n1liO OR n1lii) OR n1l1O) OR n1iOO) OR n1iil);
	ni0iil <= (((((((((((n1lii OR n1l1O) OR n1l1l) OR n1iOO) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iiO <= ((((n1liO OR n1l0l) OR n1l0i) OR n1l1i) OR n1iOl);
	ni0ili <= ((((((((((((n1lii OR n1l0l) OR n1l0i) OR n1l1l) OR n1l1i) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0ill <= (((((((n1lii OR n1l0l) OR n1l0i) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iiO) OR n1i0O);
	ni0ilO <= (((((((wire_n1lil_w_lg_n1liO1051w(0) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iil) OR n1iii) OR n1i0l);
	ni0iOi <= (((((((((((n1liO OR n1l0i) OR n1l1O) OR n1l1l) OR n1iOO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iOl <= (((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1iOO) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iOO <= ((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1iOO) OR n1iOl) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l0i <= (((((((n1liO OR n1lii) OR n1l0i) OR n1l1O) OR n1l1l) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l0l <= ((nlOOiO AND wire_n1l0O_w_lg_nlOOil1477w(0)) AND nliliO);
	ni0l0O <= ((nlOOiO AND nlOOil) AND wire_n1l0O_w_lg_nliliO1544w(0));
	ni0l1i <= ((((((n1liO OR n1l0i) OR n1l1i) OR n1iOi) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l1l <= ((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l1O <= ((((((((((n1liO OR n1l0i) OR n1iOl) OR n1iOi) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0lii <= (wire_n1l0O_w_lg_w_lg_nlOOiO1476w1543w(0) AND wire_n1l0O_w_lg_nliliO1544w(0));
	ni0lil <= ((((wire_n1l0O_w_lg_w_lg_nlOOOO1529w1530w(0) AND wire_n1l0O_w_lg_nlOOOi1531w(0)) AND wire_n1l0O_w_lg_nlOOlO1533w(0)) AND nlOOll) AND nlOOli);
	ni0liO <= ((((wire_n1l0O_w_lg_nlOOOO1538w(0) AND wire_n1l0O_w_lg_nlOOOi1531w(0)) AND nlOOlO) AND nlOOll) AND nlOOli);
	ni0lli <= ((wire_n1l0O_w_lg_n111O1524w(0) AND n111l) AND n111i);
	ni0lll <= ((n111O AND n111l) AND n111i);
	ni0llO <= (wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w(0) AND wire_n1l0O_w_lg_n110i1516w(0));
	ni0lOi <= (((wire_n1l0O_w_lg_n11ii897w(0) AND n110O) AND n110l) AND n110i);
	ni0lOl <= (((n11ii AND n110O) AND n110l) AND n110i);
	ni0lOO <= (wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n11ii897w899w900w901w(0) OR wire_n1l0O_w_lg_w_lg_w_lg_n11ii902w903w904w(0));
	ni0O0i <= (wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w(0) AND n11il);
	ni0O0l <= ((((((wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0)) AND wire_n1l0O_w_lg_n11lO1486w(0)) AND wire_n1l0O_w_lg_n11ll1488w(0)) AND wire_n1l0O_w_lg_n11li1490w(0)) AND wire_n1l0O_w_lg_n11iO1492w(0)) AND wire_n1l0O_w_lg_n11il1494w(0));
	ni0O0O <= (wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w(0) AND wire_n1l0O_w_lg_n11il1494w(0));
	ni0O1i <= (wire_n1l0O_w_lg_w_lg_w1510w1511w1512w(0) AND n11il);
	ni0O1l <= (wire_n1l0O_w_lg_w_lg_w1510w1511w1512w(0) AND wire_n1l0O_w_lg_n11il1494w(0));
	ni0O1O <= ((((((wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0)) AND wire_n1l0O_w_lg_n11lO1486w(0)) AND wire_n1l0O_w_lg_n11ll1488w(0)) AND wire_n1l0O_w_lg_n11li1490w(0)) AND wire_n1l0O_w_lg_n11iO1492w(0)) AND n11il);
	ni0Oii <= ((NOT rcxpat_chnl_sel(0)) AND wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0));
	ni0Oil <= ((wire_n1l0O_w_lg_nlOOiO1476w(0) AND wire_n1l0O_w_lg_nlOOil1477w(0)) AND nliliO);
	ni0OiO <= (ni0Oll OR ni0Oli);
	ni0Oli <= ((NOT rcxpat_chnl_sel(0)) AND rcxpat_chnl_sel(1));
	ni0Oll <= wire_w_lg_w_rcxpat_chnl_sel_range755w760w(0);
	ni0OlO <= ((((n1lii OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0OOi <= ((((((n1liO OR n1l0l) OR n1l0i) OR n1l1O) OR n1ill) OR n1ili) OR n1i0l);
	ni0OOl <= ((((((n1liO OR n1l0l) OR n1l1O) OR n1l1l) OR n1ili) OR n1i0O) OR n1i0l);
	ni0OOO <= (((((((((((((((((wire_nliiO_w_lg_w_lg_nlili109w110w(0) OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O);
	ni1lll <= ((((((nli11O OR nl0OOi) OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1llO <= (((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0i);
	ni1lOi <= (((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O1O);
	ni1lOl <= ((((((((((nli11i OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1lOO <= ((((((((((nli11i OR nl0OOl) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0i) OR nl0O1O);
	ni1O0i <= ((((((nl0Oli OR nl0OiO) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O0l <= ((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oil);
	ni1O0O <= (((((((nli11i OR nl0OOl) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O1i <= (((((((((((nli11i OR nl0OOl) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O1l <= (((((((nli11i OR nl0OOl) OR nl0Oll) OR nl0OiO) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O1O <= ((((nli11O OR nl0OlO) OR nl0Oli) OR nl0Oil) OR nl0Oii);
	ni1Oii <= ((((nli11O OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO);
	ni1Oil <= (((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OiO <= ((((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1Oli <= ((((((nli11O OR nl0OOl) OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1Oll <= ((((((nli11O OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O1O);
	ni1OlO <= (((((nli11O OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OOi <= ((((((nli11O OR nl0Oll) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OOl <= (((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OOO <= (((((((nli11O OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	nii00l <= ((((((((wire_nliiO_w_lg_w188w189w(0) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0il) OR nl01O) OR nl01i) OR nl1OO);
	nii01i <= ((((((((((((((((wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w(0) OR nli1O) OR nli1i) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii01l <= (wire_nliiO_w262w(0) OR (NOT (nii01O42 XOR nii01O41)));
	nii0ii <= (wire_nliiO_w223w(0) OR (NOT (nii0il38 XOR nii0il37)));
	nii0ll <= (wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w199w(0) OR (NOT (nii0lO34 XOR nii0lO33)));
	nii0Ol <= (((((((((((((wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w162w(0) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0il) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii10i <= ((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl01i) OR nl1OO);
	nii10l <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii10O <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii11i <= (((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl01O) OR nl01i) OR nl1OO);
	nii11l <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l);
	nii11O <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl1OO);
	nii1ii <= ((((((((((((wire_nliiO_w_lg_w_lg_w_lg_w188w189w190w191w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1il <= ((((((((((((((wire_nliiO_w_lg_w188w189w(0) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1iO <= ((((((((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w187w(0) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1li <= ((((((((((((((((((wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w(0) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1ll <= ((((((((((((((((((nlili OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1lO <= ((((((((((((((((((nli0l OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01i);
	nii1Oi <= ((((((((((((((((((((nliil OR nli0O) OR nli0l) OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01i);
	nii1Ol <= (((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w(0) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0il) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	niii0l <= (wire_nliiO_w_lg_w_lg_w120w121w122w(0) OR (NOT (niii0O22 XOR niii0O21)));
	niiiil <= ((niO0O AND wire_nliii_w_lg_niO0l763w(0)) AND n0lOi);
	niiiiO <= ((niO0O AND niO0l) AND wire_nliii_w_lg_n0lOi772w(0));
	niiili <= (wire_nliii_w_lg_w_lg_niO0O762w771w(0) AND wire_nliii_w_lg_n0lOi772w(0));
	niiill <= (wire_nliii_w_lg_w_lg_w_lg_niOll766w767w768w(0) AND wire_nliii_w_lg_niOii769w(0));
	niiilO <= ((NOT rcxpat_chnl_sel(0)) AND wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0));
	niiiOi <= ((wire_nliii_w_lg_niO0O762w(0) AND wire_nliii_w_lg_niO0l763w(0)) AND n0lOi);
	niiiOl <= (niil1i OR niiiOO);
	niiiOO <= ((NOT rcxpat_chnl_sel(0)) AND rcxpat_chnl_sel(1));
	niil0i <= (((((((((nliil OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0ll) OR nl0li);
	niil0l <= ((((((((wire_nliiO_w_lg_nlili109w(0) OR nli1l) OR nl0OO) OR nl0Oi) OR nl0li) OR nl0il) OR nl0ii) OR nl00O) OR nl00i);
	niil0O <= (((((((((nlili OR nli0O) OR nli0l) OR nli1O) OR nli1l) OR nli1i) OR nl0Oi) OR nl0lO) OR nl0iO) OR nl00l);
	niil1i <= wire_w_lg_w_rcxpat_chnl_sel_range755w760w(0);
	niil1l <= ((((nliil OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	niil1O <= (((((((nlili OR nli0i) OR nl0lO) OR nl0ll) OR nl0ii) OR nl01l) OR nl01i) OR nl1OO);
	niilii <= (((((nlili OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl00l);
	niilil <= (((((((((((nlili OR nli0O) OR nli0l) OR nli1O) OR nli1i) OR nl0Ol) OR nl0lO) OR nl0ll) OR nl0il) OR nl00l) OR nl00i) OR nl1OO);
	niiliO <= (((((((((nlili OR nli0i) OR nli1l) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0iO) OR nl00l) OR nl01l) OR nl1OO);
	niilli <= (((((((((nliil OR nli0l) OR nli0i) OR nli1O) OR nl0Ol) OR nl0Oi) OR nl0li) OR nl0ii) OR nl01O) OR nl01l);
	niilll <= '1';
	niilOl <= '0';
	niiOil <= (((NOT rbist_sel(0)) AND wire_w_lg_w_rbist_sel_range14w15w(0)) AND (niiO0O8 XOR niiO0O7));
	niiOiO <= (wire_w_lg_w_rbist_sel_range12w20w(0) AND (niiO0i10 XOR niiO0i9));
	niiOli <= (((NOT rbist_sel(0)) AND rbist_sel(1)) AND (niiO1l12 XOR niiO1l11));
	niiOOi <= (wire_w_lg_w_lg_w_lg_rpmadwidth_tx2w5w6w(0) OR ((rpmadwidth_tx AND rpma_doublewidth_tx) AND (niiOOl4 XOR niiOOl3)));
	wire_w_rbist_sel_range12w(0) <= rbist_sel(0);
	wire_w_rbist_sel_range14w(0) <= rbist_sel(1);
	wire_w_rcxpat_chnl_sel_range755w(0) <= rcxpat_chnl_sel(0);
	wire_w_rcxpat_chnl_sel_range757w(0) <= rcxpat_chnl_sel(1);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN ni001l45 <= ni001l46;
		END IF;
		if (now = 0 ns) then
			ni001l45 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN ni001l46 <= ni001l45;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii00O39 <= nii00O40;
		END IF;
		if (now = 0 ns) then
			nii00O39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii00O40 <= nii00O39;
		END IF;
	END PROCESS;
	wire_nii00O40_w_lg_w_lg_q228w230w(0) <= wire_nii00O40_w_lg_q228w(0) AND wire_w_lg_nii0ii229w(0);
	wire_nii00O40_w_lg_q228w(0) <= nii00O40 XOR nii00O39;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii01O41 <= nii01O42;
		END IF;
		if (now = 0 ns) then
			nii01O41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii01O42 <= nii01O41;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0il37 <= nii0il38;
		END IF;
		if (now = 0 ns) then
			nii0il37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0il38 <= nii0il37;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0li35 <= nii0li36;
		END IF;
		if (now = 0 ns) then
			nii0li35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0li36 <= nii0li35;
		END IF;
	END PROCESS;
	wire_nii0li36_w_lg_w_lg_q207w208w(0) <= wire_nii0li36_w_lg_q207w(0) AND nii0ll;
	wire_nii0li36_w_lg_q207w(0) <= nii0li36 XOR nii0li35;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0lO33 <= nii0lO34;
		END IF;
		if (now = 0 ns) then
			nii0lO33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0lO34 <= nii0lO33;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0OO31 <= nii0OO32;
		END IF;
		if (now = 0 ns) then
			nii0OO31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0OO32 <= nii0OO31;
		END IF;
	END PROCESS;
	wire_nii0OO32_w_lg_w_lg_q155w156w(0) <= wire_nii0OO32_w_lg_q155w(0) AND wire_nilli_dataout;
	wire_nii0OO32_w_lg_q155w(0) <= nii0OO32 XOR nii0OO31;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii1OO43 <= nii1OO44;
		END IF;
		if (now = 0 ns) then
			nii1OO43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii1OO44 <= nii1OO43;
		END IF;
	END PROCESS;
	wire_nii1OO44_w_lg_w_lg_q295w296w(0) <= wire_nii1OO44_w_lg_q295w(0) AND niiOOi;
	wire_nii1OO44_w_lg_q295w(0) <= nii1OO44 XOR nii1OO43;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0i23 <= niii0i24;
		END IF;
		if (now = 0 ns) then
			niii0i23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0i24 <= niii0i23;
		END IF;
	END PROCESS;
	wire_niii0i24_w_lg_w_lg_q129w130w(0) <= wire_niii0i24_w_lg_q129w(0) AND nl00i;
	wire_niii0i24_w_lg_q129w(0) <= niii0i24 XOR niii0i23;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0O21 <= niii0O22;
		END IF;
		if (now = 0 ns) then
			niii0O21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0O22 <= niii0O21;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1i29 <= niii1i30;
		END IF;
		if (now = 0 ns) then
			niii1i29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1i30 <= niii1i29;
		END IF;
	END PROCESS;
	wire_niii1i30_w_lg_w_lg_q152w153w(0) <= wire_niii1i30_w_lg_q152w(0) AND niiOOi;
	wire_niii1i30_w_lg_q152w(0) <= niii1i30 XOR niii1i29;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1l27 <= niii1l28;
		END IF;
		if (now = 0 ns) then
			niii1l27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1l28 <= niii1l27;
		END IF;
	END PROCESS;
	wire_niii1l28_w_lg_w_lg_q141w142w(0) <= wire_niii1l28_w_lg_q141w(0) AND niii0l;
	wire_niii1l28_w_lg_q141w(0) <= niii1l28 XOR niii1l27;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1O25 <= niii1O26;
		END IF;
		if (now = 0 ns) then
			niii1O25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1O26 <= niii1O25;
		END IF;
	END PROCESS;
	wire_niii1O26_w_lg_w_lg_q132w133w(0) <= wire_niii1O26_w_lg_q132w(0) AND nl00l;
	wire_niii1O26_w_lg_q132w(0) <= niii1O26 XOR niii1O25;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niillO19 <= niillO20;
		END IF;
		if (now = 0 ns) then
			niillO19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niillO20 <= niillO19;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOi17 <= niilOi18;
		END IF;
		if (now = 0 ns) then
			niilOi17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOi18 <= niilOi17;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOO15 <= niilOO16;
		END IF;
		if (now = 0 ns) then
			niilOO15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOO16 <= niilOO15;
		END IF;
	END PROCESS;
	wire_niilOO16_w_lg_w_lg_q78w79w(0) <= wire_niilOO16_w_lg_q78w(0) AND niO0O;
	wire_niilOO16_w_lg_q78w(0) <= niilOO16 XOR niilOO15;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0i10 <= niiO0i9;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0i9 <= niiO0i10;
		END IF;
		if (now = 0 ns) then
			niiO0i9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0O7 <= niiO0O8;
		END IF;
		if (now = 0 ns) then
			niiO0O7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0O8 <= niiO0O7;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1i13 <= niiO1i14;
		END IF;
		if (now = 0 ns) then
			niiO1i13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1i14 <= niiO1i13;
		END IF;
	END PROCESS;
	wire_niiO1i14_w_lg_w_lg_q53w54w(0) <= wire_niiO1i14_w_lg_q53w(0) AND niOil;
	wire_niiO1i14_w_lg_q53w(0) <= niiO1i14 XOR niiO1i13;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1l11 <= niiO1l12;
		END IF;
		if (now = 0 ns) then
			niiO1l11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1l12 <= niiO1l11;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOll5 <= niiOll6;
		END IF;
		if (now = 0 ns) then
			niiOll5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOll6 <= niiOll5;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOOl3 <= niiOOl4;
		END IF;
		if (now = 0 ns) then
			niiOOl3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOOl4 <= niiOOl3;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nil11i1 <= nil11i2;
		END IF;
		if (now = 0 ns) then
			nil11i1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nil11i2 <= nil11i1;
		END IF;
	END PROCESS;
	wire_nil11i2_w_lg_q4w(0) <= nil11i2 XOR nil11i1;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n100i <= '0';
				n100l <= '0';
				n100O <= '0';
				n101i <= '0';
				n101l <= '0';
				n101O <= '0';
				n10ii <= '0';
				n10il <= '0';
				n10iO <= '0';
				n10li <= '0';
				n10ll <= '0';
				n10lO <= '0';
				n10Oi <= '0';
				n10Ol <= '0';
				n10OO <= '0';
				n110i <= '0';
				n110l <= '0';
				n110O <= '0';
				n111i <= '0';
				n111l <= '0';
				n111O <= '0';
				n11ii <= '0';
				n11il <= '0';
				n11iO <= '0';
				n11li <= '0';
				n11ll <= '0';
				n11lO <= '0';
				n11Oi <= '0';
				n11Ol <= '0';
				n11OO <= '0';
				n1i0i <= '0';
				n1i0l <= '0';
				n1i0O <= '0';
				n1i1i <= '0';
				n1i1l <= '0';
				n1i1O <= '0';
				n1iii <= '0';
				n1iil <= '0';
				n1iiO <= '0';
				n1ili <= '0';
				n1ill <= '0';
				n1ilO <= '0';
				n1iOi <= '0';
				n1iOl <= '0';
				n1iOO <= '0';
				n1l0i <= '0';
				n1l0l <= '0';
				n1l1i <= '0';
				n1l1l <= '0';
				n1l1O <= '0';
				n1lii <= '0';
				nliliO <= '0';
				nlOOil <= '0';
				nlOOiO <= '0';
				nlOOli <= '0';
				nlOOll <= '0';
				nlOOlO <= '0';
				nlOOOi <= '0';
				nlOOOl <= '0';
				nlOOOO <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (wire_nll_dataout = '1') THEN
				n100i <= wire_nll01O_o;
				n100l <= wire_nll00O_o;
				n100O <= wire_nll0iO_o;
				n101i <= wire_n001O_dataout;
				n101l <= ni0OlO;
				n101O <= wire_nliO1i_o;
				n10ii <= wire_nll0lO_o;
				n10il <= wire_nll0OO_o;
				n10iO <= wire_w_lg_ni0OOi889w(0);
				n10li <= wire_nlli0i_o;
				n10ll <= wire_w_lg_ni0OOl888w(0);
				n10lO <= wire_nlliil_o;
				n10Oi <= wire_nllili_o;
				n10Ol <= wire_nllilO_o;
				n10OO <= wire_nlliOi_o;
				n110i <= wire_n011i_dataout;
				n110l <= wire_n011l_dataout;
				n110O <= wire_n011O_dataout;
				n111i <= wire_n1OlO_dataout;
				n111l <= wire_n1OOi_dataout;
				n111O <= wire_n1OOl_dataout;
				n11ii <= wire_n010i_dataout;
				n11il <= wire_n01li_dataout;
				n11iO <= wire_n01ll_dataout;
				n11li <= wire_n01lO_dataout;
				n11ll <= wire_n01Oi_dataout;
				n11lO <= wire_n01Ol_dataout;
				n11Oi <= wire_n01OO_dataout;
				n11Ol <= wire_n001i_dataout;
				n11OO <= wire_n001l_dataout;
				n1i0i <= wire_nlll0O_o;
				n1i0l <= wire_nliO1O_o;
				n1i0O <= wire_nliO0l_o;
				n1i1i <= wire_nlliOO_o;
				n1i1l <= wire_nlll1l_o;
				n1i1O <= wire_nlll0i_o;
				n1iii <= wire_nliOii_o;
				n1iil <= wire_nliOli_o;
				n1iiO <= wire_nliOll_dataout;
				n1ili <= wire_nliOlO_o;
				n1ill <= wire_nliOOi_o;
				n1ilO <= wire_nliOOl_o;
				n1iOi <= wire_nll11i_dataout;
				n1iOl <= wire_nll11l_o;
				n1iOO <= wire_nll10i_o;
				n1l0i <= wire_nll1Oi_dataout;
				n1l0l <= wire_nll1Ol_o;
				n1l1i <= wire_nll10O_o;
				n1l1l <= wire_nll1il_o;
				n1l1O <= wire_nll1ll_o;
				n1lii <= wire_nll01i_o;
				nliliO <= wire_n1lli_dataout;
				nlOOil <= wire_n1lll_dataout;
				nlOOiO <= wire_n1llO_dataout;
				nlOOli <= wire_n1lOl_dataout;
				nlOOll <= wire_n1lOO_dataout;
				nlOOlO <= wire_n1O1i_dataout;
				nlOOOi <= wire_n1O1l_dataout;
				nlOOOl <= wire_n1O1O_dataout;
				nlOOOO <= wire_n1O0i_dataout;
			END IF;
		END IF;
	END PROCESS;
	wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w(0) <= wire_n1l0O_w_lg_w_lg_w1501w1502w1503w(0) AND n11iO;
	wire_n1l0O_w_lg_w_lg_w1510w1511w1512w(0) <= wire_n1l0O_w_lg_w1510w1511w(0) AND n11iO;
	wire_n1l0O_w_lg_w_lg_w1501w1502w1503w(0) <= wire_n1l0O_w_lg_w1501w1502w(0) AND wire_n1l0O_w_lg_n11li1490w(0);
	wire_n1l0O_w_lg_w1510w1511w(0) <= wire_n1l0O_w1510w(0) AND n11li;
	wire_n1l0O_w_lg_w1501w1502w(0) <= wire_n1l0O_w1501w(0) AND wire_n1l0O_w_lg_n11ll1488w(0);
	wire_n1l0O_w1510w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1506w1507w1508w1509w(0) AND wire_n1l0O_w_lg_n11ll1488w(0);
	wire_n1l0O_w1501w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1480w1497w1499w1500w(0) AND wire_n1l0O_w_lg_n11lO1486w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1506w1507w1508w1509w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_n101i1506w1507w1508w(0) AND wire_n1l0O_w_lg_n11lO1486w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1480w1497w1499w1500w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1497w1499w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n11ii897w899w900w901w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w(0) AND n110i;
	wire_n1l0O_w_lg_w_lg_w_lg_n101i1506w1507w1508w(0) <= wire_n1l0O_w_lg_w_lg_n101i1506w1507w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_n11ii902w903w904w(0) <= wire_n1l0O_w_lg_w_lg_n11ii902w903w(0) AND n110i;
	wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w(0) <= wire_n1l0O_w_lg_w_lg_n101i1480w1482w(0) AND n11Ol;
	wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1497w1499w(0) <= wire_n1l0O_w_lg_w_lg_n101i1480w1497w(0) AND wire_n1l0O_w_lg_n11Ol1498w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w(0) <= wire_n1l0O_w_lg_w_lg_n11ii897w899w(0) AND n110l;
	wire_n1l0O_w_lg_w_lg_n101i1506w1507w(0) <= wire_n1l0O_w_lg_n101i1506w(0) AND wire_n1l0O_w_lg_n11Ol1498w(0);
	wire_n1l0O_w_lg_w_lg_n11ii902w903w(0) <= wire_n1l0O_w_lg_n11ii902w(0) AND n110l;
	wire_n1l0O_w_lg_w_lg_n101i1480w1482w(0) <= wire_n1l0O_w_lg_n101i1480w(0) AND wire_n1l0O_w_lg_n11OO1481w(0);
	wire_n1l0O_w_lg_w_lg_n101i1480w1497w(0) <= wire_n1l0O_w_lg_n101i1480w(0) AND n11OO;
	wire_n1l0O_w_lg_w_lg_n11ii897w899w(0) <= wire_n1l0O_w_lg_n11ii897w(0) AND wire_n1l0O_w_lg_n110O898w(0);
	wire_n1l0O_w_lg_w_lg_nlOOiO1476w1543w(0) <= wire_n1l0O_w_lg_nlOOiO1476w(0) AND nlOOil;
	wire_n1l0O_w_lg_w_lg_nlOOOO1529w1530w(0) <= wire_n1l0O_w_lg_nlOOOO1529w(0) AND nlOOOl;
	wire_n1l0O_w_lg_n101i1506w(0) <= n101i AND wire_n1l0O_w_lg_n11OO1481w(0);
	wire_n1l0O_w_lg_n11ii902w(0) <= n11ii AND wire_n1l0O_w_lg_n110O898w(0);
	wire_n1l0O_w_lg_nlOOOO1538w(0) <= nlOOOO AND wire_n1l0O_w_lg_nlOOOl1537w(0);
	wire_n1l0O_w_lg_n101i1480w(0) <= NOT n101i;
	wire_n1l0O_w_lg_n110i1516w(0) <= NOT n110i;
	wire_n1l0O_w_lg_n110O898w(0) <= NOT n110O;
	wire_n1l0O_w_lg_n111O1524w(0) <= NOT n111O;
	wire_n1l0O_w_lg_n11ii897w(0) <= NOT n11ii;
	wire_n1l0O_w_lg_n11il1494w(0) <= NOT n11il;
	wire_n1l0O_w_lg_n11iO1492w(0) <= NOT n11iO;
	wire_n1l0O_w_lg_n11li1490w(0) <= NOT n11li;
	wire_n1l0O_w_lg_n11ll1488w(0) <= NOT n11ll;
	wire_n1l0O_w_lg_n11lO1486w(0) <= NOT n11lO;
	wire_n1l0O_w_lg_n11Oi1484w(0) <= NOT n11Oi;
	wire_n1l0O_w_lg_n11Ol1498w(0) <= NOT n11Ol;
	wire_n1l0O_w_lg_n11OO1481w(0) <= NOT n11OO;
	wire_n1l0O_w_lg_nliliO1544w(0) <= NOT nliliO;
	wire_n1l0O_w_lg_nlOOil1477w(0) <= NOT nlOOil;
	wire_n1l0O_w_lg_nlOOiO1476w(0) <= NOT nlOOiO;
	wire_n1l0O_w_lg_nlOOlO1533w(0) <= NOT nlOOlO;
	wire_n1l0O_w_lg_nlOOOi1531w(0) <= NOT nlOOOi;
	wire_n1l0O_w_lg_nlOOOl1537w(0) <= NOT nlOOOl;
	wire_n1l0O_w_lg_nlOOOO1529w(0) <= NOT nlOOOO;
	wire_n1l0O_w_lg_w_lg_w_lg_n1ill1401w1402w1403w(0) <= wire_n1l0O_w_lg_w_lg_n1ill1401w1402w(0) OR n1iil;
	wire_n1l0O_w_lg_w_lg_n1ill1401w1402w(0) <= wire_n1l0O_w_lg_n1ill1401w(0) OR n1iiO;
	wire_n1l0O_w_lg_n1ill1401w(0) <= n1ill OR n1ili;
	wire_n1l0O_w_lg_n1l0i1211w(0) <= n1l0i OR n1l1O;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n1liO <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (wire_nll_dataout = '1') THEN
				n1liO <= niilOl;
			END IF;
		END IF;
	END PROCESS;
	wire_n1lil_w_lg_w_lg_w_lg_n1liO1051w1092w1093w(0) <= wire_n1lil_w_lg_w_lg_n1liO1051w1092w(0) OR n1iil;
	wire_n1lil_w_lg_w_lg_n1liO1051w1092w(0) <= wire_n1lil_w_lg_n1liO1051w(0) OR n1iOO;
	wire_n1lil_w_lg_n1liO1051w(0) <= n1liO OR n1l1O;
	PROCESS (tx_clk, wire_nl0OOO_PRN, soft_reset)
	BEGIN
		IF (wire_nl0OOO_PRN = '0') THEN
				nl00il <= '1';
				nl00iO <= '1';
				nl00li <= '1';
				nl00ll <= '1';
				nl00lO <= '1';
				nl00Oi <= '1';
				nl00Ol <= '1';
				nl00OO <= '1';
				nl0i0i <= '1';
				nl0i0l <= '1';
				nl0i0O <= '1';
				nl0i1i <= '1';
				nl0i1l <= '1';
				nl0i1O <= '1';
				nl0iii <= '1';
				nl0iil <= '1';
				nl0iiO <= '1';
				nl0ili <= '1';
				nl0ill <= '1';
				nl0ilO <= '1';
				nl0iOi <= '1';
				nl0iOl <= '1';
				nl0iOO <= '1';
				nl0l0i <= '1';
				nl0l0l <= '1';
				nl0l0O <= '1';
				nl0l1i <= '1';
				nl0l1l <= '1';
				nl0l1O <= '1';
				nl0lii <= '1';
				nl0lil <= '1';
				nl0liO <= '1';
				nl0lli <= '1';
				nl0lll <= '1';
				nl0llO <= '1';
				nl0lOi <= '1';
				nl0lOl <= '1';
				nl0lOO <= '1';
				nl0O0i <= '1';
				nl0O0l <= '1';
				nl0O0O <= '1';
				nl0O1i <= '1';
				nl0O1l <= '1';
				nl0O1O <= '1';
				nl0Oii <= '1';
				nl0Oil <= '1';
				nl0OiO <= '1';
				nl0Oli <= '1';
				nl0Oll <= '1';
				nl0OlO <= '1';
				nl0OOi <= '1';
				nl0OOl <= '1';
				nli11i <= '1';
		ELSIF (soft_reset = '1') THEN
				nl00il <= '0';
				nl00iO <= '0';
				nl00li <= '0';
				nl00ll <= '0';
				nl00lO <= '0';
				nl00Oi <= '0';
				nl00Ol <= '0';
				nl00OO <= '0';
				nl0i0i <= '0';
				nl0i0l <= '0';
				nl0i0O <= '0';
				nl0i1i <= '0';
				nl0i1l <= '0';
				nl0i1O <= '0';
				nl0iii <= '0';
				nl0iil <= '0';
				nl0iiO <= '0';
				nl0ili <= '0';
				nl0ill <= '0';
				nl0ilO <= '0';
				nl0iOi <= '0';
				nl0iOl <= '0';
				nl0iOO <= '0';
				nl0l0i <= '0';
				nl0l0l <= '0';
				nl0l0O <= '0';
				nl0l1i <= '0';
				nl0l1l <= '0';
				nl0l1O <= '0';
				nl0lii <= '0';
				nl0lil <= '0';
				nl0liO <= '0';
				nl0lli <= '0';
				nl0lll <= '0';
				nl0llO <= '0';
				nl0lOi <= '0';
				nl0lOl <= '0';
				nl0lOO <= '0';
				nl0O0i <= '0';
				nl0O0l <= '0';
				nl0O0O <= '0';
				nl0O1i <= '0';
				nl0O1l <= '0';
				nl0O1O <= '0';
				nl0Oii <= '0';
				nl0Oil <= '0';
				nl0OiO <= '0';
				nl0Oli <= '0';
				nl0Oll <= '0';
				nl0OlO <= '0';
				nl0OOi <= '0';
				nl0OOl <= '0';
				nli11i <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				nl00il <= wire_nli10i_dataout;
				nl00iO <= wire_nli10l_dataout;
				nl00li <= wire_nli10O_dataout;
				nl00ll <= wire_nli1ii_dataout;
				nl00lO <= wire_nli1il_dataout;
				nl00Oi <= wire_nli1iO_dataout;
				nl00Ol <= wire_nli1li_dataout;
				nl00OO <= wire_nli1ll_dataout;
				nl0i0i <= wire_nli1OO_dataout;
				nl0i0l <= wire_nli01i_dataout;
				nl0i0O <= wire_nli01l_dataout;
				nl0i1i <= wire_nli1lO_dataout;
				nl0i1l <= wire_nli1Oi_dataout;
				nl0i1O <= wire_nli1Ol_dataout;
				nl0iii <= wire_nli01O_dataout;
				nl0iil <= wire_nli00i_dataout;
				nl0iiO <= wire_nli00l_dataout;
				nl0ili <= wire_nli00O_dataout;
				nl0ill <= wire_nli0ii_dataout;
				nl0ilO <= wire_nli0il_dataout;
				nl0iOi <= wire_nli0iO_dataout;
				nl0iOl <= wire_nli0li_dataout;
				nl0iOO <= (NOT (nli11O OR nl0OOi));
				nl0l0i <= wire_nil01O_o;
				nl0l0l <= wire_nil00l_o;
				nl0l0O <= wire_nil0il_o;
				nl0l1i <= wire_nil1li_o;
				nl0l1l <= wire_nil1lO_o;
				nl0l1O <= wire_nil1OO_o;
				nl0lii <= wire_nil0li_o;
				nl0lil <= wire_nil0Oi_o;
				nl0liO <= wire_nili1i_o;
				nl0lli <= wire_nili0i_o;
				nl0lll <= wire_nili0O_o;
				nl0llO <= wire_niliil_o;
				nl0lOi <= wire_nilili_o;
				nl0lOl <= wire_nililO_o;
				nl0lOO <= wire_niliOl_o;
				nl0O0i <= wire_nillil_o;
				nl0O0l <= wire_nillli_o;
				nl0O0O <= wire_nilllO_o;
				nl0O1i <= wire_nill1i_o;
				nl0O1l <= wire_nill1O_o;
				nl0O1O <= wire_nill0O_o;
				nl0Oii <= wire_nillOl_o;
				nl0Oil <= wire_nilO1i_o;
				nl0OiO <= wire_nilO1O_o;
				nl0Oli <= wire_nilO0l_o;
				nl0Oll <= wire_nilOii_o;
				nl0OlO <= wire_nilOiO_o;
				nl0OOi <= wire_nilOli_o;
				nl0OOl <= wire_nilOlO_o;
				nli11i <= wire_nilOOl_o;
		END IF;
	END PROCESS;
	wire_nl0OOO_PRN <= (ni001l46 XOR ni001l45);
	wire_nl0OOO_w_lg_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w2253w(0) <= wire_nl0OOO_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w(0) AND nl0ill;
	wire_nl0OOO_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w(0) <= wire_nl0OOO_w_lg_w_lg_nl0iOl2241w2243w(0) AND wire_nl0OOO_w_lg_nl0ilO2244w(0);
	wire_nl0OOO_w_lg_w_lg_nl0iOl2241w2243w(0) <= wire_nl0OOO_w_lg_nl0iOl2241w(0) AND wire_nl0OOO_w_lg_nl0iOi2242w(0);
	wire_nl0OOO_w_lg_nl0iii2259w(0) <= NOT nl0iii;
	wire_nl0OOO_w_lg_nl0iil2257w(0) <= NOT nl0iil;
	wire_nl0OOO_w_lg_nl0iiO2255w(0) <= NOT nl0iiO;
	wire_nl0OOO_w_lg_nl0ili2248w(0) <= NOT nl0ili;
	wire_nl0OOO_w_lg_nl0ill2246w(0) <= NOT nl0ill;
	wire_nl0OOO_w_lg_nl0ilO2244w(0) <= NOT nl0ilO;
	wire_nl0OOO_w_lg_nl0iOi2242w(0) <= NOT nl0iOi;
	wire_nl0OOO_w_lg_nl0iOl2241w(0) <= NOT nl0iOl;
	wire_nl0OOO_w_lg_nl0O0l2201w(0) <= nl0O0l OR nl0O0i;
	wire_nl0OOO_w_lg_nl0O0l2215w(0) <= nl0O0l OR nl0O1O;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nli11O <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				nli11O <= wire_niO11i_o;
		END IF;
	END PROCESS;
	wire_nli11l_w_lg_nli11O2169w(0) <= nli11O OR nl0O0l;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n0lOi <= '0';
				niO0l <= '0';
				niO0O <= '0';
				niOii <= '0';
				niOil <= '0';
				niOiO <= '0';
				niOli <= '0';
				niOll <= '0';
				niOlO <= '0';
				niOOi <= '0';
				niOOl <= '0';
				niOOO <= '0';
				nl00i <= '0';
				nl00l <= '0';
				nl00O <= '0';
				nl01i <= '0';
				nl01l <= '0';
				nl01O <= '0';
				nl0ii <= '0';
				nl0il <= '0';
				nl0iO <= '0';
				nl0li <= '0';
				nl0ll <= '0';
				nl0lO <= '0';
				nl0Oi <= '0';
				nl0Ol <= '0';
				nl0OO <= '0';
				nl10i <= '0';
				nl10l <= '0';
				nl10O <= '0';
				nl11i <= '0';
				nl11l <= '0';
				nl11O <= '0';
				nl1ii <= '0';
				nl1il <= '0';
				nl1iO <= '0';
				nl1li <= '0';
				nl1ll <= '0';
				nl1lO <= '0';
				nl1Oi <= '0';
				nl1Ol <= '0';
				nl1OO <= '0';
				nli0i <= '0';
				nli0l <= '0';
				nli0O <= '0';
				nli1i <= '0';
				nli1l <= '0';
				nli1O <= '0';
				nliil <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (wire_nli_dataout = '1') THEN
				n0lOi <= wire_nlill_dataout;
				niO0l <= wire_nlilO_dataout;
				niO0O <= wire_nliOi_dataout;
				niOii <= wire_nliOO_dataout;
				niOil <= wire_nll1i_dataout;
				niOiO <= wire_nll1l_dataout;
				niOli <= wire_nll1O_dataout;
				niOll <= wire_nll0i_dataout;
				niOlO <= niil1l;
				niOOi <= wire_n0ilO_o;
				niOOl <= wire_w_lg_niil1O100w(0);
				niOOO <= niil0i;
				nl00i <= wire_n0lii_o;
				nl00l <= wire_n0lil_o;
				nl00O <= wire_n0liO_o;
				nl01i <= wire_n0l1i_o;
				nl01l <= wire_n0l1O_o;
				nl01O <= wire_n0l0O_dataout;
				nl0ii <= wire_n0lli_o;
				nl0il <= wire_n0llO_dataout;
				nl0iO <= wire_n0lOl_o;
				nl0li <= wire_n0O1i_dataout;
				nl0ll <= wire_n0O1l_o;
				nl0lO <= wire_n0O0i_dataout;
				nl0Oi <= wire_n0O0l_o;
				nl0Ol <= wire_n0Oii_dataout;
				nl0OO <= wire_n0Oil_o;
				nl10i <= wire_w_lg_niilil96w(0);
				nl10l <= wire_w_lg_niiliO95w(0);
				nl10O <= niilli;
				nl11i <= wire_w_lg_niil0l99w(0);
				nl11l <= wire_w_lg_niil0O98w(0);
				nl11O <= wire_w_lg_niilii97w(0);
				nl1ii <= wire_ni1Ol_o;
				nl1il <= wire_ni01i_o;
				nl1iO <= wire_ni01O_o;
				nl1li <= wire_ni00l_o;
				nl1ll <= wire_ni0ii_o;
				nl1lO <= wire_ni0iO_o;
				nl1Oi <= wire_ni0ll_o;
				nl1Ol <= wire_ni0Oi_o;
				nl1OO <= wire_n0iOl_o;
				nli0i <= wire_n0OOl_o;
				nli0l <= wire_ni11i_dataout;
				nli0O <= wire_ni11l_o;
				nli1i <= wire_n0Oli_dataout;
				nli1l <= wire_n0Oll_o;
				nli1O <= wire_n0OOi_dataout;
				nliil <= wire_ni10i_o;
			END IF;
		END IF;
	END PROCESS;
	wire_nliii_w_lg_w_lg_w_lg_niOll766w767w768w(0) <= wire_nliii_w_lg_w_lg_niOll766w767w(0) AND niOil;
	wire_nliii_w_lg_w_lg_niOll766w767w(0) <= wire_nliii_w_lg_niOll766w(0) AND niOiO;
	wire_nliii_w_lg_w_lg_niO0O762w771w(0) <= wire_nliii_w_lg_niO0O762w(0) AND niO0l;
	wire_nliii_w_lg_niOll766w(0) <= niOll AND niOli;
	wire_nliii_w_lg_n0lOi772w(0) <= NOT n0lOi;
	wire_nliii_w_lg_niO0l763w(0) <= NOT niO0l;
	wire_nliii_w_lg_niO0O762w(0) <= NOT niO0O;
	wire_nliii_w_lg_niOii769w(0) <= NOT niOii;
	wire_nliii_w_lg_w_lg_w_lg_nl00O654w655w656w(0) <= wire_nliii_w_lg_w_lg_nl00O654w655w(0) OR nl01O;
	wire_nliii_w_lg_w_lg_nl00O654w655w(0) <= wire_nliii_w_lg_nl00O654w(0) OR nl00i;
	wire_nliii_w_lg_nl00O654w(0) <= nl00O OR nl00l;
	PROCESS (tx_clk, wire_nliiO_PRN, wire_nliiO_CLRN)
	BEGIN
		IF (wire_nliiO_PRN = '0') THEN
				nlili <= '1';
		ELSIF (wire_nliiO_CLRN = '0') THEN
				nlili <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (wire_nli_dataout = '1') THEN
				nlili <= niilOl;
			END IF;
		END IF;
	END PROCESS;
	wire_nliiO_CLRN <= (niilOi18 XOR niilOi17);
	wire_nliiO_PRN <= ((niillO20 XOR niillO19) AND wire_w_lg_soft_reset93w(0));
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w199w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w(0) OR nl1OO;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w194w195w196w197w(0) OR nl01i;
	wire_nliiO_w_lg_w_lg_w_lg_w194w195w196w197w(0) <= wire_nliiO_w_lg_w_lg_w194w195w196w(0) OR nl01O;
	wire_nliiO_w_lg_w_lg_w120w121w122w(0) <= wire_nliiO_w_lg_w120w121w(0) OR nl1OO;
	wire_nliiO_w_lg_w_lg_w194w195w196w(0) <= wire_nliiO_w_lg_w194w195w(0) OR nl0il;
	wire_nliiO_w_lg_w120w121w(0) <= wire_nliiO_w120w(0) OR nl01i;
	wire_nliiO_w_lg_w194w195w(0) <= wire_nliiO_w194w(0) OR nl0iO;
	wire_nliiO_w262w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w261w(0) OR nl1OO;
	wire_nliiO_w223w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w222w(0) OR nl1OO;
	wire_nliiO_w120w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w119w(0) OR nl01O;
	wire_nliiO_w194w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0li;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w261w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w(0) OR nl01i;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w222w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w(0) OR nl01i;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w119w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w(0) OR nl0il;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w(0) OR nl0lO;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w256w257w258w259w(0) OR nl01O;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w217w218w219w220w(0) OR nl01O;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w114w115w116w117w(0) OR nl0iO;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w188w189w190w191w(0) OR nl0Oi;
	wire_nliiO_w_lg_w_lg_w_lg_w256w257w258w259w(0) <= wire_nliiO_w_lg_w_lg_w256w257w258w(0) OR nl0il;
	wire_nliiO_w_lg_w_lg_w_lg_w217w218w219w220w(0) <= wire_nliiO_w_lg_w_lg_w217w218w219w(0) OR nl0il;
	wire_nliiO_w_lg_w_lg_w_lg_w114w115w116w117w(0) <= wire_nliiO_w_lg_w_lg_w114w115w116w(0) OR nl0li;
	wire_nliiO_w_lg_w_lg_w_lg_w188w189w190w191w(0) <= wire_nliiO_w_lg_w_lg_w188w189w190w(0) OR nl0Ol;
	wire_nliiO_w_lg_w_lg_w256w257w258w(0) <= wire_nliiO_w_lg_w256w257w(0) OR nl0iO;
	wire_nliiO_w_lg_w_lg_w217w218w219w(0) <= wire_nliiO_w_lg_w217w218w(0) OR nl0li;
	wire_nliiO_w_lg_w_lg_w114w115w116w(0) <= wire_nliiO_w_lg_w114w115w(0) OR nl0lO;
	wire_nliiO_w_lg_w_lg_w188w189w190w(0) <= wire_nliiO_w_lg_w188w189w(0) OR nl0OO;
	wire_nliiO_w_lg_w256w257w(0) <= wire_nliiO_w256w(0) OR nl0li;
	wire_nliiO_w_lg_w217w218w(0) <= wire_nliiO_w217w(0) OR nl0lO;
	wire_nliiO_w_lg_w114w115w(0) <= wire_nliiO_w114w(0) OR nl0Oi;
	wire_nliiO_w_lg_w188w189w(0) <= wire_nliiO_w188w(0) OR nli1i;
	wire_nliiO_w256w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w255w(0) OR nl0ll;
	wire_nliiO_w217w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w216w(0) OR nl0Ol;
	wire_nliiO_w114w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w113w(0) OR nl0Ol;
	wire_nliiO_w188w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w187w(0) OR nli1l;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w255w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w(0) OR nl0lO;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w216w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w(0) OR nl0OO;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w113w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w(0) OR nli1i;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w187w(0) <= wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w(0) OR nli1O;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w(0) <= wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w162w(0) OR nl0Ol;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w(0) <= wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w214w(0) OR nli1i;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w(0) <= wire_nliiO_w_lg_w_lg_w_lg_nlili109w110w111w(0) OR nli1l;
	wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w(0) <= wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w(0) OR nli0i;
	wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w162w(0) <= wire_nliiO_w_lg_w_lg_nlili160w161w(0) OR nli1i;
	wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w214w(0) <= wire_nliiO_w_lg_w_lg_nlili160w161w(0) OR nli1l;
	wire_nliiO_w_lg_w_lg_w_lg_nlili109w110w111w(0) <= wire_nliiO_w_lg_w_lg_nlili109w110w(0) OR nli1O;
	wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w(0) <= wire_nliiO_w_lg_w_lg_nlili109w184w(0) OR nli0l;
	wire_nliiO_w_lg_w_lg_nlili160w161w(0) <= wire_nliiO_w_lg_nlili160w(0) OR nli1O;
	wire_nliiO_w_lg_w_lg_nlili109w110w(0) <= wire_nliiO_w_lg_nlili109w(0) OR nli0l;
	wire_nliiO_w_lg_w_lg_nlili109w184w(0) <= wire_nliiO_w_lg_nlili109w(0) OR nli0O;
	wire_nliiO_w_lg_nlili160w(0) <= nlili OR nli0l;
	wire_nliiO_w_lg_nlili109w(0) <= nlili OR nliil;
	wire_n000i_dataout <= wire_n00Oi_o(0) WHEN n1l1l = '1'  ELSE n11il;
	wire_n000l_dataout <= wire_n00Oi_o(1) WHEN n1l1l = '1'  ELSE n11iO;
	wire_n000O_dataout <= wire_n00Oi_o(2) WHEN n1l1l = '1'  ELSE n11li;
	wire_n001i_dataout <= wire_n00li_dataout AND NOT(wire_nlillO_dataout);
	wire_n001l_dataout <= wire_n00ll_dataout AND NOT(wire_nlillO_dataout);
	wire_n001O_dataout <= wire_n00lO_dataout AND NOT(wire_nlillO_dataout);
	wire_n00i_dataout <= nl0l0l WHEN niiOil = '1'  ELSE wire_niii_dataout;
	wire_n00ii_dataout <= wire_n00Oi_o(3) WHEN n1l1l = '1'  ELSE n11ll;
	wire_n00il_dataout <= wire_n00Oi_o(4) WHEN n1l1l = '1'  ELSE n11lO;
	wire_n00iO_dataout <= wire_n00Oi_o(5) WHEN n1l1l = '1'  ELSE n11Oi;
	wire_n00l_dataout <= nl0l0O WHEN niiOil = '1'  ELSE wire_niil_dataout;
	wire_n00li_dataout <= wire_n00Oi_o(6) WHEN n1l1l = '1'  ELSE n11Ol;
	wire_n00ll_dataout <= wire_n00Oi_o(7) WHEN n1l1l = '1'  ELSE n11OO;
	wire_n00lO_dataout <= wire_n00Oi_o(8) WHEN n1l1l = '1'  ELSE n101i;
	wire_n00O_dataout <= nl0lii WHEN niiOil = '1'  ELSE wire_niiO_dataout;
	wire_n010i_dataout <= wire_n01il_dataout AND NOT(wire_nlilll_dataout);
	wire_n010l_dataout <= wire_n01iO_o(0) WHEN wire_nlilli_dataout = '1'  ELSE n110i;
	wire_n010O_dataout <= wire_n01iO_o(1) WHEN wire_nlilli_dataout = '1'  ELSE n110l;
	wire_n011i_dataout <= wire_n010l_dataout AND NOT(wire_nlilll_dataout);
	wire_n011l_dataout <= wire_n010O_dataout AND NOT(wire_nlilll_dataout);
	wire_n011O_dataout <= wire_n01ii_dataout AND NOT(wire_nlilll_dataout);
	wire_n01i_dataout <= nl0l1l WHEN niiOil = '1'  ELSE wire_ni0i_dataout;
	wire_n01ii_dataout <= wire_n01iO_o(2) WHEN wire_nlilli_dataout = '1'  ELSE n110O;
	wire_n01il_dataout <= wire_n01iO_o(3) WHEN wire_nlilli_dataout = '1'  ELSE n11ii;
	wire_n01l_dataout <= nl0l1O WHEN niiOil = '1'  ELSE wire_ni0l_dataout;
	wire_n01li_dataout <= wire_n000i_dataout AND NOT(wire_nlillO_dataout);
	wire_n01ll_dataout <= wire_n000l_dataout AND NOT(wire_nlillO_dataout);
	wire_n01lO_dataout <= wire_n000O_dataout AND NOT(wire_nlillO_dataout);
	wire_n01O_dataout <= nl0l0i WHEN niiOil = '1'  ELSE wire_ni0O_dataout;
	wire_n01Oi_dataout <= wire_n00ii_dataout AND NOT(wire_nlillO_dataout);
	wire_n01Ol_dataout <= wire_n00il_dataout AND NOT(wire_nlillO_dataout);
	wire_n01OO_dataout <= wire_n00iO_dataout AND NOT(wire_nlillO_dataout);
	wire_n0i_dataout <= nl1ll AND niiOli;
	wire_n0ii_dataout <= nl0lil WHEN niiOil = '1'  ELSE wire_nili_dataout;
	wire_n0il_dataout <= nl0liO WHEN niiOil = '1'  ELSE wire_nill_dataout;
	wire_n0iO_dataout <= nl0lli WHEN niiOil = '1'  ELSE wire_nilO_dataout;
	wire_n0l_dataout <= nl1lO AND niiOli;
	wire_n0l0O_dataout <= wire_w_lg_niiOOi445w(0) AND nl0ii;
	wire_n0li_dataout <= nl0lll WHEN niiOil = '1'  ELSE wire_niOi_dataout;
	wire_n0ll_dataout <= nl0llO WHEN niiOil = '1'  ELSE wire_niOl_dataout;
	wire_n0llO_dataout <= wire_w_lg_niiOOi445w(0) AND nl0iO;
	wire_n0lO_dataout <= nl0lOi WHEN niiOil = '1'  ELSE wire_niOO_dataout;
	wire_n0O_dataout <= nl1Oi AND niiOli;
	wire_n0O0i_dataout <= wire_w_lg_niiOOi445w(0) AND nl0Oi;
	wire_n0O1i_dataout <= wire_w_lg_niiOOi445w(0) AND nl0ll;
	wire_n0Oi_dataout <= nl0lOl WHEN niiOil = '1'  ELSE wire_nl1i_dataout;
	wire_n0Oii_dataout <= wire_w_lg_niiOOi445w(0) AND nl0OO;
	wire_n0Ol_dataout <= nl0lOO WHEN niiOil = '1'  ELSE wire_nl1l_dataout;
	wire_n0Oli_dataout <= wire_w_lg_niiOOi445w(0) AND nli1l;
	wire_n0OO_dataout <= nl0O1i WHEN niiOil = '1'  ELSE wire_nl1O_dataout;
	wire_n0OOi_dataout <= wire_w_lg_niiOOi445w(0) AND nli0i;
	wire_n1i_dataout <= nl1il AND niiOli;
	wire_n1l_dataout <= nl1iO AND niiOli;
	wire_n1lli_dataout <= wire_n1lOi_o(0) AND wire_nlilOi_o;
	wire_n1lll_dataout <= wire_n1lOi_o(1) AND wire_nlilOi_o;
	wire_n1llO_dataout <= wire_n1lOi_o(2) AND wire_nlilOi_o;
	wire_n1lOl_dataout <= wire_n1Oll_o(0) WHEN wire_nlil0O_dataout = '1'  ELSE wire_n1O0l_dataout;
	wire_n1lOO_dataout <= wire_n1Oll_o(1) WHEN wire_nlil0O_dataout = '1'  ELSE wire_n1O0O_dataout;
	wire_n1O_dataout <= nl1li AND niiOli;
	wire_n1O0i_dataout <= wire_n1Oll_o(5) WHEN wire_nlil0O_dataout = '1'  ELSE wire_n1Oli_dataout;
	wire_n1O0l_dataout <= nlOOli AND NOT(wire_nlilii_dataout);
	wire_n1O0O_dataout <= nlOOll AND NOT(wire_nlilii_dataout);
	wire_n1O1i_dataout <= wire_n1Oll_o(2) WHEN wire_nlil0O_dataout = '1'  ELSE wire_n1Oii_dataout;
	wire_n1O1l_dataout <= wire_n1Oll_o(3) WHEN wire_nlil0O_dataout = '1'  ELSE wire_n1Oil_dataout;
	wire_n1O1O_dataout <= wire_n1Oll_o(4) WHEN wire_nlil0O_dataout = '1'  ELSE wire_n1OiO_dataout;
	wire_n1Oii_dataout <= nlOOlO AND NOT(wire_nlilii_dataout);
	wire_n1Oil_dataout <= nlOOOi AND NOT(wire_nlilii_dataout);
	wire_n1OiO_dataout <= nlOOOl AND NOT(wire_nlilii_dataout);
	wire_n1Oli_dataout <= nlOOOO AND NOT(wire_nlilii_dataout);
	wire_n1OlO_dataout <= wire_n1OOO_o(0) WHEN wire_nlilil_dataout = '1'  ELSE n111i;
	wire_n1OOi_dataout <= wire_n1OOO_o(1) WHEN wire_nlilil_dataout = '1'  ELSE n111l;
	wire_n1OOl_dataout <= wire_n1OOO_o(2) WHEN wire_nlilil_dataout = '1'  ELSE n111O;
	wire_ni0i_dataout <= n100i WHEN niiOiO = '1'  ELSE wire_nlii_dataout;
	wire_ni0l_dataout <= n100l WHEN niiOiO = '1'  ELSE wire_nlil_dataout;
	wire_ni0O_dataout <= n100O WHEN niiOiO = '1'  ELSE wire_nliO_dataout;
	wire_ni0OO_dataout <= niiiil AND NOT(niiilO);
	wire_ni11i_dataout <= wire_nillO_dataout AND nli0O;
	wire_ni1i_dataout <= nl0O1l WHEN niiOil = '1'  ELSE wire_nl0i_dataout;
	wire_ni1l_dataout <= nl0iOO WHEN niiOil = '1'  ELSE wire_nl0l_dataout;
	wire_ni1O_dataout <= nl0l1i WHEN niiOil = '1'  ELSE wire_nl0O_dataout;
	wire_nii_dataout <= nl1Ol AND niiOli;
	wire_nii0i_dataout <= wire_niiil_dataout AND niiOOi;
	wire_nii0l_dataout <= wire_niiiO_dataout AND niiOOi;
	wire_nii0O_dataout <= niiiil WHEN niiilO = '1'  ELSE niiiiO;
	wire_nii1i_dataout <= niiiil AND niiilO;
	wire_nii1l_dataout <= wire_nii0O_dataout AND NOT(niiOOi);
	wire_nii1O_dataout <= wire_w_lg_niiili108w(0) WHEN niiOOi = '1'  ELSE wire_niiii_dataout;
	wire_niii_dataout <= n10ii WHEN niiOiO = '1'  ELSE wire_nlli_dataout;
	wire_niiii_dataout <= wire_w_lg_niiiil107w(0) WHEN niiilO = '1'  ELSE wire_w_lg_niiiiO106w(0);
	wire_niiil_dataout <= niiili AND NOT(niiilO);
	wire_niiiO_dataout <= niiili AND niiilO;
	wire_niil_dataout <= n10il WHEN niiOiO = '1'  ELSE wire_nlll_dataout;
	wire_niili_dataout <= wire_nil1i_dataout AND niiOOi;
	wire_niill_dataout <= wire_nil1l_dataout AND niiOOi;
	wire_niilO_dataout <= wire_nil1O_dataout AND niiOOi;
	wire_niiO_dataout <= n10iO WHEN niiOiO = '1'  ELSE wire_nllO_dataout;
	wire_niiOi_dataout <= wire_nil0i_dataout AND niiOOi;
	wire_niiOl_dataout <= wire_w_lg_niiill105w(0) AND niiOOi;
	wire_niiOO_dataout <= niiill AND niiOOi;
	wire_nil_dataout <= niOlO AND niiOli;
	wire_nil0i_dataout <= niiilO AND niiill;
	wire_nil0l_dataout <= wire_nilil_dataout AND NOT(niiilO);
	wire_nil0O_dataout <= wire_niliO_dataout AND NOT(niiilO);
	wire_nil1i_dataout <= wire_nil0l_dataout AND niiill;
	wire_nil1l_dataout <= wire_nil0O_dataout AND niiill;
	wire_nil1O_dataout <= wire_nilii_dataout AND niiill;
	wire_nili_dataout <= n10li WHEN niiOiO = '1'  ELSE wire_nlOi_dataout;
	wire_nilii_dataout <= niil1i AND NOT(niiilO);
	wire_nilil_dataout <= wire_w_lg_niiiOO104w(0) AND NOT(niil1i);
	wire_niliO_dataout <= niiiOO AND NOT(niil1i);
	wire_nill_dataout <= n10ll WHEN niiOiO = '1'  ELSE wire_nlOl_dataout;
	wire_nilli_dataout <= wire_w_lg_niiiOl103w(0) AND niiOOi;
	wire_nilll_dataout <= wire_nilOl_dataout OR niiOOi;
	wire_nillO_dataout <= wire_nilOO_dataout AND NOT(niiOOi);
	wire_nilO_dataout <= n10lO WHEN niiOiO = '1'  ELSE wire_nlOO_dataout;
	wire_nilOi_dataout <= wire_niO1i_dataout AND NOT(niiOOi);
	wire_nilOl_dataout <= wire_niO1l_dataout OR niiilO;
	wire_nilOO_dataout <= wire_w_lg_niiiOl103w(0) AND NOT(niiilO);
	wire_niO_dataout <= niOOi AND niiOli;
	wire_niO00i_dataout <= nl00OO WHEN niiOOi = '1'  ELSE nl0iil;
	wire_niO00l_dataout <= nl0i1i WHEN niiOOi = '1'  ELSE nl0iiO;
	wire_niO00O_dataout <= nl0i1l WHEN niiOOi = '1'  ELSE nl0ili;
	wire_niO01i_dataout <= wire_niOOOi_dataout WHEN niiOOi = '1'  ELSE wire_niOiOO_dataout;
	wire_niO01l_dataout <= wire_niOOOl_dataout WHEN niiOOi = '1'  ELSE wire_niOl1i_dataout;
	wire_niO01O_dataout <= nl0iii AND NOT(niiOOi);
	wire_niO0ii_dataout <= nl0i1O WHEN niiOOi = '1'  ELSE nl0ill;
	wire_niO0il_dataout <= nl0i0i WHEN niiOOi = '1'  ELSE nl0ilO;
	wire_niO0iO_dataout <= nl0i0l WHEN niiOOi = '1'  ELSE nl0iOi;
	wire_niO0li_dataout <= nl0i0O WHEN niiOOi = '1'  ELSE nl0iOl;
	wire_niO0ll_dataout <= nl00il AND niiOOi;
	wire_niO0lO_dataout <= nl00iO AND niiOOi;
	wire_niO0Oi_dataout <= nl00li AND niiOOi;
	wire_niO0Ol_dataout <= nl00ll AND niiOOi;
	wire_niO0OO_dataout <= nl00lO AND niiOOi;
	wire_niO10i_dataout <= wire_niOO1i_dataout WHEN niiOOi = '1'  ELSE wire_niOi1O_dataout;
	wire_niO10l_dataout <= wire_niOO1l_dataout WHEN niiOOi = '1'  ELSE wire_niOi0i_dataout;
	wire_niO10O_dataout <= wire_niOO1O_dataout WHEN niiOOi = '1'  ELSE wire_niOi0l_dataout;
	wire_niO11l_dataout <= wire_nlO_dataout AND niiOOi;
	wire_niO11O_dataout <= wire_nlO_dataout AND NOT(niiOOi);
	wire_niO1i_dataout <= wire_niO1O_dataout AND NOT(niiilO);
	wire_niO1ii_dataout <= wire_niOO0i_dataout WHEN niiOOi = '1'  ELSE wire_niOi0O_dataout;
	wire_niO1il_dataout <= wire_niOO0l_dataout WHEN niiOOi = '1'  ELSE wire_niOiii_dataout;
	wire_niO1iO_dataout <= wire_niOO0O_dataout WHEN niiOOi = '1'  ELSE wire_niOiil_dataout;
	wire_niO1l_dataout <= niiiOi AND niiiOl;
	wire_niO1li_dataout <= wire_niOOii_dataout WHEN niiOOi = '1'  ELSE wire_niOiiO_dataout;
	wire_niO1ll_dataout <= wire_niOOil_dataout WHEN niiOOi = '1'  ELSE wire_niOili_dataout;
	wire_niO1lO_dataout <= wire_niOOiO_dataout WHEN niiOOi = '1'  ELSE wire_niOill_dataout;
	wire_niO1O_dataout <= wire_w_lg_niiiOi102w(0) AND niiiOl;
	wire_niO1Oi_dataout <= wire_niOOli_dataout WHEN niiOOi = '1'  ELSE wire_niOilO_dataout;
	wire_niO1Ol_dataout <= wire_niOOll_dataout WHEN niiOOi = '1'  ELSE wire_niOiOi_dataout;
	wire_niO1OO_dataout <= wire_niOOlO_dataout WHEN niiOOi = '1'  ELSE wire_niOiOl_dataout;
	wire_niOi_dataout <= n10Oi WHEN niiOiO = '1'  ELSE wire_n1i_dataout;
	wire_niOi0i_dataout <= wire_niOl1O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOi0l_dataout <= wire_niOl0i_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOi0O_dataout <= wire_niOl0l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOi1i_dataout <= nl00Oi AND niiOOi;
	wire_niOi1l_dataout <= nl00Ol AND niiOOi;
	wire_niOi1O_dataout <= wire_niOl1l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOiii_dataout <= wire_niOl0O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOiil_dataout <= wire_niOlii_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOiiO_dataout <= wire_niOlil_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOili_dataout <= wire_niOliO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOill_dataout <= wire_niOlli_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOilO_dataout <= wire_niOlll_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOiOi_dataout <= wire_niOllO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOiOl_dataout <= wire_niOlOi_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOiOO_dataout <= wire_niOlOl_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOl_dataout <= n10Ol WHEN niiOiO = '1'  ELSE wire_n1l_dataout;
	wire_niOl0i_dataout <= nl0O0l AND NOT(ni01Oi);
	wire_niOl0l_dataout <= nl0O0O AND NOT(ni01Oi);
	wire_niOl0O_dataout <= nl0Oii AND NOT(ni01Oi);
	wire_niOl1i_dataout <= wire_niOlOO_dataout OR wire_nlO_w_lg_dataout1647w(0);
	wire_niOl1l_dataout <= nl0O1O AND NOT(ni01Oi);
	wire_niOl1O_dataout <= nl0O0i AND NOT(ni01Oi);
	wire_niOlii_dataout <= nl0Oil AND NOT(ni01Oi);
	wire_niOlil_dataout <= nl0OiO AND NOT(ni01Oi);
	wire_niOliO_dataout <= nl0Oli AND NOT(ni01Oi);
	wire_niOlli_dataout <= nl0Oll AND NOT(ni01Oi);
	wire_niOlll_dataout <= nl0OlO OR ni01Oi;
	wire_niOllO_dataout <= nl0OOi AND NOT(ni01Oi);
	wire_niOlOi_dataout <= nl0OOl AND NOT(ni01Oi);
	wire_niOlOl_dataout <= nli11i AND NOT(ni01Oi);
	wire_niOlOO_dataout <= nli11O AND NOT(ni01Oi);
	wire_niOO_dataout <= n10OO WHEN niiOiO = '1'  ELSE wire_n1O_dataout;
	wire_niOO0i_dataout <= wire_nl111O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOO0l_dataout <= wire_nl110i_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOO0O_dataout <= wire_nl110l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOO1i_dataout <= wire_niOOOO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOO1l_dataout <= wire_nl111i_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOO1O_dataout <= wire_nl111l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOii_dataout <= wire_nl110O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOil_dataout <= wire_nl11ii_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOiO_dataout <= wire_nl11il_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOli_dataout <= wire_nl11iO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOll_dataout <= wire_nl11li_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOlO_dataout <= wire_nl11ll_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOOi_dataout <= wire_nl11lO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_niOOOl_dataout <= wire_nl11Oi_dataout OR wire_nlO_w_lg_dataout1647w(0);
	wire_niOOOO_dataout <= nl0O1O AND NOT(ni01Ol);
	wire_nl000i_dataout <= nl0OOi AND NOT(wire_nlO_dataout);
	wire_nl000l_dataout <= nl0OOl AND NOT(wire_nlO_dataout);
	wire_nl000O_dataout <= nli11i OR wire_nlO_dataout;
	wire_nl001i_dataout <= nl0Oli AND NOT(wire_nlO_dataout);
	wire_nl001l_dataout <= nl0Oll AND NOT(wire_nlO_dataout);
	wire_nl001O_dataout <= nl0OlO AND NOT(wire_nlO_dataout);
	wire_nl00ii_dataout <= nli11O AND NOT(wire_nlO_dataout);
	wire_nl010i_dataout <= nl0OlO AND NOT(ni001i);
	wire_nl010l_dataout <= nl0OOi AND NOT(ni001i);
	wire_nl010O_dataout <= nl0OOl OR ni001i;
	wire_nl011i_dataout <= nl0OiO AND NOT(ni001i);
	wire_nl011l_dataout <= nl0Oli AND NOT(ni001i);
	wire_nl011O_dataout <= nl0Oll AND NOT(ni001i);
	wire_nl01ii_dataout <= nli11i AND NOT(ni001i);
	wire_nl01il_dataout <= nli11O AND NOT(ni001i);
	wire_nl01iO_dataout <= nl0O1O AND NOT(wire_nlO_dataout);
	wire_nl01li_dataout <= nl0O0i AND NOT(wire_nlO_dataout);
	wire_nl01ll_dataout <= nl0O0l AND NOT(wire_nlO_dataout);
	wire_nl01lO_dataout <= nl0O0O AND NOT(wire_nlO_dataout);
	wire_nl01Oi_dataout <= nl0Oii AND NOT(wire_nlO_dataout);
	wire_nl01Ol_dataout <= nl0Oil AND NOT(wire_nlO_dataout);
	wire_nl01OO_dataout <= nl0OiO AND NOT(wire_nlO_dataout);
	wire_nl0i_dataout <= n1i0i WHEN niiOiO = '1'  ELSE wire_nii_dataout;
	wire_nl0l_dataout <= n101l WHEN niiOiO = '1'  ELSE wire_nil_dataout;
	wire_nl0O_dataout <= n101O WHEN niiOiO = '1'  ELSE wire_niO_dataout;
	wire_nl100i_dataout <= wire_nl1O1i_dataout WHEN niiOOi = '1'  ELSE wire_nl1i1O_dataout;
	wire_nl100l_dataout <= wire_nl1O1l_dataout WHEN niiOOi = '1'  ELSE wire_nl1i0i_dataout;
	wire_nl100O_dataout <= wire_nl1O1O_dataout WHEN niiOOi = '1'  ELSE wire_nl1i0l_dataout;
	wire_nl101i_dataout <= wire_nl1lOi_dataout WHEN niiOOi = '1'  ELSE wire_nl10OO_dataout;
	wire_nl101l_dataout <= wire_nl1lOl_dataout WHEN niiOOi = '1'  ELSE wire_nl1i1i_dataout;
	wire_nl101O_dataout <= wire_nl1lOO_dataout WHEN niiOOi = '1'  ELSE wire_nl1i1l_dataout;
	wire_nl10ii_dataout <= wire_nl1O0i_dataout WHEN niiOOi = '1'  ELSE wire_nl1i0O_dataout;
	wire_nl10il_dataout <= wire_nl1O0l_dataout WHEN niiOOi = '1'  ELSE wire_nl1iii_dataout;
	wire_nl10iO_dataout <= wire_nl1O0O_dataout WHEN niiOOi = '1'  ELSE wire_nl1iil_dataout;
	wire_nl10li_dataout <= wire_nl1Oii_dataout WHEN niiOOi = '1'  ELSE wire_nl1iiO_dataout;
	wire_nl10ll_dataout <= wire_nl1Oil_dataout WHEN niiOOi = '1'  ELSE wire_nl1ili_dataout;
	wire_nl10lO_dataout <= wire_nl1OiO_dataout WHEN niiOOi = '1'  ELSE wire_nl1ill_dataout;
	wire_nl10Oi_dataout <= wire_nl1ilO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl10Ol_dataout <= wire_nl1iOi_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl10OO_dataout <= wire_nl1iOl_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl110i_dataout <= nl0Oii AND NOT(ni01Ol);
	wire_nl110l_dataout <= nl0Oil AND NOT(ni01Ol);
	wire_nl110O_dataout <= nl0OiO AND NOT(ni01Ol);
	wire_nl111i_dataout <= nl0O0i AND NOT(ni01Ol);
	wire_nl111l_dataout <= nl0O0l AND NOT(ni01Ol);
	wire_nl111O_dataout <= nl0O0O AND NOT(ni01Ol);
	wire_nl11ii_dataout <= nl0Oli AND NOT(ni01Ol);
	wire_nl11il_dataout <= nl0Oll AND NOT(ni01Ol);
	wire_nl11iO_dataout <= nl0OlO OR ni01Ol;
	wire_nl11li_dataout <= nl0OOi AND NOT(ni01Ol);
	wire_nl11ll_dataout <= nl0OOl AND NOT(ni01Ol);
	wire_nl11lO_dataout <= nli11i AND NOT(ni01Ol);
	wire_nl11Oi_dataout <= nli11O AND NOT(ni01Ol);
	wire_nl11Ol_dataout <= wire_nl1lll_dataout WHEN niiOOi = '1'  ELSE wire_nl10Oi_dataout;
	wire_nl11OO_dataout <= wire_nl1llO_dataout WHEN niiOOi = '1'  ELSE wire_nl10Ol_dataout;
	wire_nl1i_dataout <= n1i1i WHEN niiOiO = '1'  ELSE wire_n0i_dataout;
	wire_nl1i0i_dataout <= wire_nl1l1O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1i0l_dataout <= wire_nl1l0i_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1i0O_dataout <= wire_nl1l0l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1i1i_dataout <= wire_nl1iOO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1i1l_dataout <= wire_nl1l1i_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1i1O_dataout <= wire_nl1l1l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1iii_dataout <= wire_nl1l0O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1iil_dataout <= wire_nl1lii_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1iiO_dataout <= wire_nl1lil_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1ili_dataout <= wire_nl1liO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1ill_dataout <= wire_nl1lli_dataout OR wire_nlO_w_lg_dataout1647w(0);
	wire_nl1ilO_dataout <= nl0O1O AND NOT(ni01OO);
	wire_nl1iOi_dataout <= nl0O0i AND NOT(ni01OO);
	wire_nl1iOl_dataout <= nl0O0l AND NOT(ni01OO);
	wire_nl1iOO_dataout <= nl0O0O AND NOT(ni01OO);
	wire_nl1l_dataout <= n1i1l WHEN niiOiO = '1'  ELSE wire_n0l_dataout;
	wire_nl1l0i_dataout <= nl0Oli AND NOT(ni01OO);
	wire_nl1l0l_dataout <= nl0Oll AND NOT(ni01OO);
	wire_nl1l0O_dataout <= nl0OlO AND NOT(ni01OO);
	wire_nl1l1i_dataout <= nl0Oii AND NOT(ni01OO);
	wire_nl1l1l_dataout <= nl0Oil AND NOT(ni01OO);
	wire_nl1l1O_dataout <= nl0OiO AND NOT(ni01OO);
	wire_nl1lii_dataout <= nl0OOi AND NOT(ni01OO);
	wire_nl1lil_dataout <= nl0OOl OR ni01OO;
	wire_nl1liO_dataout <= nli11i AND NOT(ni01OO);
	wire_nl1lli_dataout <= nli11O AND NOT(ni01OO);
	wire_nl1lll_dataout <= wire_nl1Oli_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1llO_dataout <= wire_nl1Oll_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1lOi_dataout <= wire_nl1OlO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1lOl_dataout <= wire_nl1OOi_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1lOO_dataout <= wire_nl1OOl_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1O_dataout <= n1i1O WHEN niiOiO = '1'  ELSE wire_n0O_dataout;
	wire_nl1O0i_dataout <= wire_nl011O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1O0l_dataout <= wire_nl010i_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1O0O_dataout <= wire_nl010l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1O1i_dataout <= wire_nl1OOO_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1O1l_dataout <= wire_nl011i_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1O1O_dataout <= wire_nl011l_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1Oii_dataout <= wire_nl010O_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1Oil_dataout <= wire_nl01ii_dataout AND NOT(wire_nlO_w_lg_dataout1647w(0));
	wire_nl1OiO_dataout <= wire_nl01il_dataout OR wire_nlO_w_lg_dataout1647w(0);
	wire_nl1Oli_dataout <= nl0O1O AND NOT(ni001i);
	wire_nl1Oll_dataout <= nl0O0i AND NOT(ni001i);
	wire_nl1OlO_dataout <= nl0O0l AND NOT(ni001i);
	wire_nl1OOi_dataout <= nl0O0O AND NOT(ni001i);
	wire_nl1OOl_dataout <= nl0Oii AND NOT(ni001i);
	wire_nl1OOO_dataout <= nl0Oil AND NOT(ni001i);
	wire_nli_dataout <= rbisten_tx AND ((NOT rbist_sel(0)) AND rbist_sel(1));
	wire_nli00i_dataout <= wire_nli0Oi_o(1) AND ni001O;
	wire_nli00l_dataout <= wire_nli0Oi_o(2) AND ni001O;
	wire_nli00O_dataout <= wire_nli0Oi_o(3) AND ni001O;
	wire_nli01i_dataout <= wire_nli0lO_o(5) AND ni001O;
	wire_nli01l_dataout <= wire_nli0lO_o(6) AND ni001O;
	wire_nli01O_dataout <= wire_nli0Oi_o(0) AND ni001O;
	wire_nli0ii_dataout <= wire_nli0Oi_o(4) AND ni001O;
	wire_nli0il_dataout <= wire_nli0Oi_o(5) AND ni001O;
	wire_nli0iO_dataout <= wire_nli0Oi_o(6) AND ni001O;
	wire_nli0li_dataout <= wire_nli0Oi_o(7) AND ni001O;
	wire_nli10i_dataout <= wire_nli0ll_o(0) AND ni001O;
	wire_nli10l_dataout <= wire_nli0ll_o(1) AND ni001O;
	wire_nli10O_dataout <= wire_nli0ll_o(2) AND ni001O;
	wire_nli1ii_dataout <= wire_nli0ll_o(3) AND ni001O;
	wire_nli1il_dataout <= wire_nli0ll_o(4) AND ni001O;
	wire_nli1iO_dataout <= wire_nli0ll_o(5) AND ni001O;
	wire_nli1li_dataout <= wire_nli0ll_o(6) AND ni001O;
	wire_nli1ll_dataout <= wire_nli0lO_o(0) AND ni001O;
	wire_nli1lO_dataout <= wire_nli0lO_o(1) AND ni001O;
	wire_nli1Oi_dataout <= wire_nli0lO_o(2) AND ni001O;
	wire_nli1Ol_dataout <= wire_nli0lO_o(3) AND ni001O;
	wire_nli1OO_dataout <= wire_nli0lO_o(4) AND ni001O;
	wire_nlii_dataout <= niOOl AND niiOli;
	wire_nlil_dataout <= niOOO AND niiOli;
	wire_nlil0O_dataout <= wire_nllO1O_dataout AND n1iOl;
	wire_nlilii_dataout <= wire_nllO0i_dataout AND n1iOl;
	wire_nlilil_dataout <= niiOOi AND n1iOO;
	wire_nlill_dataout <= wire_nliOl_o(0) AND wire_n0iiO_o;
	wire_nlilli_dataout <= wire_nlO10l_dataout AND n1l1i;
	wire_nlilll_dataout <= wire_nlO10O_dataout AND n1l1i;
	wire_nlillO_dataout <= wire_nlOi0O_dataout AND n1l1l;
	wire_nlilO_dataout <= wire_nliOl_o(1) AND wire_n0iiO_o;
	wire_nliO_dataout <= nl11i AND niiOli;
	wire_nliOi_dataout <= wire_nliOl_o(2) AND wire_n0iiO_o;
	wire_nliOll_dataout <= wire_w_lg_niiOOi445w(0) AND n1ilO;
	wire_nliOO_dataout <= wire_nllli_o(0) WHEN wire_n0iii_o = '1'  ELSE wire_nll0l_dataout;
	wire_nll_dataout <= rbisten_tx AND wire_w_lg_w_rbist_sel_range12w20w(0);
	wire_nll0i_dataout <= wire_nllli_o(4) WHEN wire_n0iii_o = '1'  ELSE wire_nlliO_dataout;
	wire_nll0l_dataout <= niOii AND NOT(wire_n0iil_o);
	wire_nll0O_dataout <= niOil AND NOT(wire_n0iil_o);
	wire_nll11i_dataout <= wire_nlO1ll_dataout AND n1l1i;
	wire_nll1i_dataout <= wire_nllli_o(1) WHEN wire_n0iii_o = '1'  ELSE wire_nll0O_dataout;
	wire_nll1l_dataout <= wire_nllli_o(2) WHEN wire_n0iii_o = '1'  ELSE wire_nllii_dataout;
	wire_nll1O_dataout <= wire_nllli_o(3) WHEN wire_n0iii_o = '1'  ELSE wire_nllil_dataout;
	wire_nll1Oi_dataout <= wire_nlOlOO_dataout AND n1l0l;
	wire_nlli_dataout <= nl11l AND niiOli;
	wire_nllii_dataout <= niOiO AND NOT(wire_n0iil_o);
	wire_nllil_dataout <= niOli AND NOT(wire_n0iil_o);
	wire_nlliO_dataout <= niOll AND NOT(wire_n0iil_o);
	wire_nlll_dataout <= nl11O AND niiOli;
	wire_nlllil_dataout <= ni0l0l AND NOT(ni0Oii);
	wire_nllliO_dataout <= ni0l0l AND ni0Oii;
	wire_nlllli_dataout <= wire_nlllOl_dataout AND NOT(niiOOi);
	wire_nlllll_dataout <= wire_w_lg_ni0lii914w(0) WHEN niiOOi = '1'  ELSE wire_nlllOO_dataout;
	wire_nllllO_dataout <= wire_nllO1i_dataout AND niiOOi;
	wire_nlllOi_dataout <= wire_nllO1l_dataout AND niiOOi;
	wire_nlllOl_dataout <= ni0l0l WHEN ni0Oii = '1'  ELSE ni0l0O;
	wire_nlllOO_dataout <= wire_w_lg_ni0l0l913w(0) WHEN ni0Oii = '1'  ELSE wire_w_lg_ni0l0O912w(0);
	wire_nllO_dataout <= nl10i AND niiOli;
	wire_nllO0i_dataout <= ni0lil WHEN niiOOi = '1'  ELSE ni0liO;
	wire_nllO0l_dataout <= wire_nllOll_dataout AND niiOOi;
	wire_nllO0O_dataout <= wire_nllOlO_dataout AND niiOOi;
	wire_nllO1i_dataout <= ni0lii AND NOT(ni0Oii);
	wire_nllO1l_dataout <= ni0lii AND ni0Oii;
	wire_nllO1O_dataout <= wire_w_lg_ni0lil911w(0) WHEN niiOOi = '1'  ELSE wire_w_lg_ni0liO910w(0);
	wire_nllOii_dataout <= wire_nllOOi_dataout AND niiOOi;
	wire_nllOil_dataout <= wire_nllOOl_dataout AND niiOOi;
	wire_nllOiO_dataout <= wire_nllOOO_dataout AND niiOOi;
	wire_nllOli_dataout <= ni0lli AND niiOOi;
	wire_nllOll_dataout <= wire_nlO11i_dataout AND NOT(ni0lli);
	wire_nllOlO_dataout <= wire_nlO11l_dataout AND NOT(ni0lli);
	wire_nllOOi_dataout <= wire_nlO11O_dataout AND NOT(ni0lli);
	wire_nllOOl_dataout <= wire_nlO10i_dataout AND NOT(ni0lli);
	wire_nllOOO_dataout <= wire_w_lg_ni0lll909w(0) AND NOT(ni0lli);
	wire_nlO_dataout <= rbisten_tx AND (((NOT rbist_sel(0)) AND wire_w_lg_w_rbist_sel_range14w15w(0)) AND (niiOll6 XOR niiOll5));
	wire_nlO_w_lg_dataout1647w(0) <= NOT wire_nlO_dataout;
	wire_nlO00i_dataout <= wire_nlO0li_dataout AND NOT(ni0lOO);
	wire_nlO00l_dataout <= ni0lOi AND NOT(ni0lOO);
	wire_nlO00O_dataout <= wire_nlO0ll_dataout AND NOT(ni0lOi);
	wire_nlO01i_dataout <= wire_nlO0ii_dataout AND NOT(ni0lOO);
	wire_nlO01l_dataout <= wire_nlO0il_dataout AND NOT(ni0lOO);
	wire_nlO01O_dataout <= wire_nlO0iO_dataout AND NOT(ni0lOO);
	wire_nlO0ii_dataout <= wire_nlO0lO_dataout AND NOT(ni0lOi);
	wire_nlO0il_dataout <= wire_nlO0Oi_dataout AND NOT(ni0lOi);
	wire_nlO0iO_dataout <= wire_nlO0Ol_dataout AND NOT(ni0lOi);
	wire_nlO0li_dataout <= wire_w_lg_ni0lOl907w(0) AND NOT(ni0lOi);
	wire_nlO0ll_dataout <= wire_nlO0OO_dataout AND ni0lOl;
	wire_nlO0lO_dataout <= wire_nlOi1i_dataout AND ni0lOl;
	wire_nlO0Oi_dataout <= wire_nlOi1l_dataout AND ni0lOl;
	wire_nlO0Ol_dataout <= ni0Oii AND ni0lOl;
	wire_nlO0OO_dataout <= wire_nlOi1O_dataout AND NOT(ni0Oii);
	wire_nlO10i_dataout <= ni0Oii AND ni0lll;
	wire_nlO10l_dataout <= wire_w_lg_ni0llO908w(0) OR NOT(niiOOi);
	wire_nlO10O_dataout <= ni0llO AND niiOOi;
	wire_nlO11i_dataout <= wire_nlO0OO_dataout AND ni0lll;
	wire_nlO11l_dataout <= wire_nlOi1i_dataout AND ni0lll;
	wire_nlO11O_dataout <= wire_nlOi1l_dataout AND ni0lll;
	wire_nlO1ii_dataout <= wire_nlO1OO_dataout AND NOT(niiOOi);
	wire_nlO1il_dataout <= wire_nlO01i_dataout AND NOT(niiOOi);
	wire_nlO1iO_dataout <= wire_nlO01l_dataout AND NOT(niiOOi);
	wire_nlO1li_dataout <= wire_nlO01O_dataout AND NOT(niiOOi);
	wire_nlO1ll_dataout <= ni0llO WHEN niiOOi = '1'  ELSE ni0lOO;
	wire_nlO1lO_dataout <= wire_nlO00i_dataout AND NOT(niiOOi);
	wire_nlO1Oi_dataout <= wire_w_lg_ni0llO908w(0) AND niiOOi;
	wire_nlO1Ol_dataout <= wire_nlO00l_dataout AND NOT(niiOOi);
	wire_nlO1OO_dataout <= wire_nlO00O_dataout AND NOT(ni0lOO);
	wire_nlOi_dataout <= nl10l AND niiOli;
	wire_nlOi0i_dataout <= ni0Oli AND NOT(ni0Oll);
	wire_nlOi0O_dataout <= wire_nlOl1O_dataout WHEN niiOOi = '1'  ELSE wire_nlOiiO_dataout;
	wire_nlOi1i_dataout <= wire_nlOi0i_dataout AND NOT(ni0Oii);
	wire_nlOi1l_dataout <= ni0Oll AND NOT(ni0Oii);
	wire_nlOi1O_dataout <= wire_w_lg_ni0Oli906w(0) AND NOT(ni0Oll);
	wire_nlOiii_dataout <= wire_nlOl0i_dataout WHEN niiOOi = '1'  ELSE wire_nlOili_dataout;
	wire_nlOiil_dataout <= wire_nlOl0l_dataout WHEN niiOOi = '1'  ELSE wire_nlOill_dataout;
	wire_nlOiiO_dataout <= wire_nlOiOO_dataout WHEN ni0Oii = '1'  ELSE wire_nlOilO_dataout;
	wire_nlOili_dataout <= wire_nlOl1i_dataout WHEN ni0Oii = '1'  ELSE wire_nlOiOi_dataout;
	wire_nlOill_dataout <= wire_nlOl1l_dataout WHEN ni0Oii = '1'  ELSE wire_nlOiOl_dataout;
	wire_nlOilO_dataout <= ni0O1i AND NOT(ni0O0i);
	wire_nlOiOi_dataout <= ni0O1i OR ni0O0i;
	wire_nlOiOl_dataout <= wire_w_lg_ni0O1i896w(0) AND NOT(ni0O0i);
	wire_nlOiOO_dataout <= ni0O1l AND NOT(ni0O0O);
	wire_nlOl_dataout <= nl10O AND niiOli;
	wire_nlOl0i_dataout <= wire_nlOlli_dataout WHEN ni0Oii = '1'  ELSE wire_nlOlii_dataout;
	wire_nlOl0l_dataout <= wire_nlOlll_dataout WHEN ni0Oii = '1'  ELSE wire_nlOlil_dataout;
	wire_nlOl0O_dataout <= ni0O0i AND NOT(ni0O1O);
	wire_nlOl1i_dataout <= ni0O1l OR ni0O0O;
	wire_nlOl1l_dataout <= wire_w_lg_ni0O1l895w(0) AND NOT(ni0O0O);
	wire_nlOl1O_dataout <= wire_nlOliO_dataout WHEN ni0Oii = '1'  ELSE wire_nlOl0O_dataout;
	wire_nlOlii_dataout <= ni0O0i OR ni0O1O;
	wire_nlOlil_dataout <= wire_w_lg_ni0O0i894w(0) AND NOT(ni0O1O);
	wire_nlOliO_dataout <= ni0O0O AND NOT(ni0O0l);
	wire_nlOlli_dataout <= ni0O0O OR ni0O0l;
	wire_nlOlll_dataout <= wire_w_lg_ni0O0O893w(0) AND NOT(ni0O0l);
	wire_nlOllO_dataout <= wire_w_lg_ni0OiO892w(0) AND niiOOi;
	wire_nlOlOi_dataout <= wire_nlOO1l_dataout OR niiOOi;
	wire_nlOlOl_dataout <= ni0Oii AND NOT(niiOOi);
	wire_nlOlOO_dataout <= wire_nlOO1O_dataout AND NOT(niiOOi);
	wire_nlOO_dataout <= nl1ii AND niiOli;
	wire_nlOO0i_dataout <= wire_nlOO0O_dataout AND NOT(ni0Oii);
	wire_nlOO0l_dataout <= ni0Oil AND ni0OiO;
	wire_nlOO0O_dataout <= wire_w_lg_ni0Oil891w(0) AND ni0OiO;
	wire_nlOO1i_dataout <= wire_nlOO0i_dataout AND NOT(niiOOi);
	wire_nlOO1l_dataout <= wire_nlOO0l_dataout AND NOT(ni0Oii);
	wire_nlOO1O_dataout <= wire_w_lg_ni0OiO892w(0) AND NOT(ni0Oii);
	wire_n00Oi_a <= ( n101i & n11OO & n11Ol & n11Oi & n11lO & n11ll & n11li & n11iO & n11il);
	wire_n00Oi_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	n00Oi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_n00Oi_a,
		b => wire_n00Oi_b,
		cin => wire_gnd,
		o => wire_n00Oi_o
	  );
	wire_n01iO_a <= ( n11ii & n110O & n110l & n110i);
	wire_n01iO_b <= ( "0" & "0" & "0" & "1");
	n01iO :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4,
		width_o => 4
	  )
	  PORT MAP ( 
		a => wire_n01iO_a,
		b => wire_n01iO_b,
		cin => wire_gnd,
		o => wire_n01iO_o
	  );
	wire_n1lOi_a <= ( nlOOiO & nlOOil & nliliO);
	wire_n1lOi_b <= ( "0" & "0" & "1");
	n1lOi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 3,
		width_b => 3,
		width_o => 3
	  )
	  PORT MAP ( 
		a => wire_n1lOi_a,
		b => wire_n1lOi_b,
		cin => wire_gnd,
		o => wire_n1lOi_o
	  );
	wire_n1Oll_a <= ( nlOOOO & nlOOOl & nlOOOi & nlOOlO & nlOOll & nlOOli);
	wire_n1Oll_b <= ( "0" & "0" & "0" & "0" & "0" & "1");
	n1Oll :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_n1Oll_a,
		b => wire_n1Oll_b,
		cin => wire_gnd,
		o => wire_n1Oll_o
	  );
	wire_n1OOO_a <= ( n111O & n111l & n111i);
	wire_n1OOO_b <= ( "0" & "0" & "1");
	n1OOO :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 3,
		width_b => 3,
		width_o => 3
	  )
	  PORT MAP ( 
		a => wire_n1OOO_a,
		b => wire_n1OOO_b,
		cin => wire_gnd,
		o => wire_n1OOO_o
	  );
	wire_nli0ll_a <= ( nl00Ol & nl00Oi & nl00lO & nl00ll & nl00li & nl00iO & nl00il);
	wire_nli0ll_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nli0ll :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nli0ll_a,
		b => wire_nli0ll_b,
		cin => wire_gnd,
		o => wire_nli0ll_o
	  );
	wire_nli0lO_a <= ( nl0i0O & nl0i0l & nl0i0i & nl0i1O & nl0i1l & nl0i1i & nl00OO);
	wire_nli0lO_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nli0lO :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 7,
		width_b => 7,
		width_o => 7
	  )
	  PORT MAP ( 
		a => wire_nli0lO_a,
		b => wire_nli0lO_b,
		cin => wire_gnd,
		o => wire_nli0lO_o
	  );
	wire_nli0Oi_a <= ( nl0iOl & nl0iOi & nl0ilO & nl0ill & nl0ili & nl0iiO & nl0iil & nl0iii);
	wire_nli0Oi_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nli0Oi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 8,
		width_b => 8,
		width_o => 8
	  )
	  PORT MAP ( 
		a => wire_nli0Oi_a,
		b => wire_nli0Oi_b,
		cin => wire_gnd,
		o => wire_nli0Oi_o
	  );
	wire_nliOl_a <= ( wire_niilOO16_w_lg_w_lg_q78w79w & niO0l & n0lOi);
	wire_nliOl_b <= ( "0" & "0" & "1");
	nliOl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 3,
		width_b => 3,
		width_o => 3
	  )
	  PORT MAP ( 
		a => wire_nliOl_a,
		b => wire_nliOl_b,
		cin => wire_gnd,
		o => wire_nliOl_o
	  );
	wire_nllli_a <= ( niOll & niOli & niOiO & wire_niiO1i14_w_lg_w_lg_q53w54w & niOii);
	wire_nllli_b <= ( "0" & "0" & "0" & "0" & "1");
	nllli :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_nllli_a,
		b => wire_nllli_b,
		cin => wire_gnd,
		o => wire_nllli_o
	  );
	wire_n0iii_data <= ( "0" & wire_niiOl_dataout & wire_w_lg_niiill105w);
	wire_n0iii_sel <= ( nii10l & nl0iO & nl0il);
	n0iii :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0iii_data,
		o => wire_n0iii_o,
		sel => wire_n0iii_sel
	  );
	wire_n0iil_data <= ( "0" & wire_niiOO_dataout & niiill);
	wire_n0iil_sel <= ( nii10l & nl0iO & nl0il);
	n0iil :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0iil_data,
		o => wire_n0iil_o,
		sel => wire_n0iil_sel
	  );
	wire_n0iiO_data <= ( "0" & wire_nilOi_dataout & wire_nii1O_dataout & wire_w_lg_niiiil107w & wire_w_lg_niiiil107w);
	wire_n0iiO_sel <= ( ni0OOO & nli0O & nl01l & nl01i & nl1OO);
	n0iiO :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0iiO_data,
		o => wire_n0iiO_o,
		sel => wire_n0iiO_sel
	  );
	wire_n0ilO_data <= ( "0" & niiOOi);
	wire_n0ilO_sel <= ( nii11i & wire_w_lg_nii11i695w);
	n0ilO :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0ilO_data,
		o => wire_n0ilO_o,
		sel => wire_n0ilO_sel
	  );
	wire_n0iOl_data <= ( "0" & niiiil & wire_w_lg_niiiil107w);
	wire_n0iOl_sel <= ( nii11l & nl01i & nl1OO);
	n0iOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0iOl_data,
		o => wire_n0iOl_o,
		sel => wire_n0iOl_sel
	  );
	wire_n0l1i_data <= ( "0" & wire_nii1l_dataout & wire_w_lg_niiiil107w);
	wire_n0l1i_sel <= ( nii11O & nl01l & nl01i);
	n0l1i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0l1i_data,
		o => wire_n0l1i_o,
		sel => wire_n0l1i_sel
	  );
	wire_n0l1O_data <= ( "0" & niiOOi & "1" & wire_nii1O_dataout);
	wire_n0l1O_sel <= ( nii10i & nl0ii & wire_nliii_w_lg_w_lg_w_lg_nl00O654w655w656w & nl01l);
	n0l1O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0l1O_data,
		o => wire_n0l1O_o,
		sel => wire_n0l1O_sel
	  );
	wire_n0lii_data <= ( "0" & wire_niili_dataout & wire_nil1i_dataout);
	wire_n0lii_sel <= ( nii10l & nl0iO & nl0il);
	n0lii :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0lii_data,
		o => wire_n0lii_o,
		sel => wire_n0lii_sel
	  );
	wire_n0lil_data <= ( "0" & wire_niill_dataout & wire_nil1l_dataout);
	wire_n0lil_sel <= ( nii10l & nl0iO & nl0il);
	n0lil :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0lil_data,
		o => wire_n0lil_o,
		sel => wire_n0lil_sel
	  );
	wire_n0liO_data <= ( "0" & wire_niilO_dataout & wire_nil1O_dataout);
	wire_n0liO_sel <= ( nii10l & nl0iO & nl0il);
	n0liO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0liO_data,
		o => wire_n0liO_o,
		sel => wire_n0liO_sel
	  );
	wire_n0lli_data <= ( "0" & wire_niiOi_dataout & wire_nil0i_dataout);
	wire_n0lli_sel <= ( nii10l & nl0iO & nl0il);
	n0lli :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0lli_data,
		o => wire_n0lli_o,
		sel => wire_n0lli_sel
	  );
	wire_n0lOl_data <= ( "0" & niiOOi & "1");
	wire_n0lOl_sel <= ( nii10O & nl0ll & nl0li);
	n0lOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0lOl_data,
		o => wire_n0lOl_o,
		sel => wire_n0lOl_sel
	  );
	wire_n0O0l_data <= ( "0" & niiOOi & "1");
	wire_n0O0l_sel <= ( nii1il & nl0OO & nl0Ol);
	n0O0l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0O0l_data,
		o => wire_n0O0l_o,
		sel => wire_n0O0l_sel
	  );
	wire_n0O1l_data <= ( "0" & niiOOi & "1");
	wire_n0O1l_sel <= ( nii1ii & nl0Oi & nl0lO);
	n0O1l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0O1l_data,
		o => wire_n0O1l_o,
		sel => wire_n0O1l_sel
	  );
	wire_n0Oil_data <= ( "0" & niiOOi & "1");
	wire_n0Oil_sel <= ( nii1iO & nli1l & nli1i);
	n0Oil :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0Oil_data,
		o => wire_n0Oil_o,
		sel => wire_n0Oil_sel
	  );
	wire_n0Oll_data <= ( "0" & niiOOi & "1");
	wire_n0Oll_sel <= ( nii1li & nli0i & nli1O);
	n0Oll :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0Oll_data,
		o => wire_n0Oll_o,
		sel => wire_n0Oll_sel
	  );
	wire_n0OOl_data <= ( "0" & niiOOi & wire_nilll_dataout & "1" & wire_niiOl_dataout & wire_w_lg_niiill105w);
	wire_n0OOl_sel <= ( nii1ll & nliil & nli0O & nli0l & nl0iO & nl0il);
	n0OOl :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n0OOl_data,
		o => wire_n0OOl_o,
		sel => wire_n0OOl_sel
	  );
	wire_ni00l_data <= ( "0" & niiOOi);
	wire_ni00l_sel <= ( nii00l & wire_w_lg_nii00l246w);
	ni00l :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni00l_data,
		o => wire_ni00l_o,
		sel => wire_ni00l_sel
	  );
	wire_ni01i_data <= ( "0" & wire_nii1OO44_w_lg_w_lg_q295w296w);
	wire_ni01i_sel <= ( nii01i & wire_w_lg_nii01i291w);
	ni01i :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni01i_data,
		o => wire_ni01i_o,
		sel => wire_ni01i_sel
	  );
	wire_ni01O_data <= ( "0" & niiOOi);
	wire_ni01O_sel <= ( nii01l & wire_w_lg_nii01l267w);
	ni01O :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni01O_data,
		o => wire_ni01O_o,
		sel => wire_ni01O_sel
	  );
	wire_ni0ii_data <= ( "0" & niiOOi);
	wire_ni0ii_sel <= ( nii0ii & wire_nii00O40_w_lg_w_lg_q228w230w);
	ni0ii :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni0ii_data,
		o => wire_ni0ii_o,
		sel => wire_ni0ii_sel
	  );
	wire_ni0iO_data <= ( "0" & niiOOi);
	wire_ni0iO_sel <= ( wire_nii0li36_w_lg_w_lg_q207w208w & wire_w_lg_nii0ll204w);
	ni0iO :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni0iO_data,
		o => wire_ni0iO_o,
		sel => wire_ni0iO_sel
	  );
	wire_ni0ll_data <= ( "0" & niiOOi);
	wire_ni0ll_sel <= ( nii0Ol & wire_w_lg_nii0Ol176w);
	ni0ll :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni0ll_data,
		o => wire_ni0ll_o,
		sel => wire_ni0ll_sel
	  );
	wire_ni0Oi_data <= ( "0" & wire_nii0OO32_w_lg_w_lg_q155w156w & wire_niii1i30_w_lg_w_lg_q152w153w & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi);
	wire_ni0Oi_sel <= ( wire_niii1l28_w_lg_w_lg_q141w142w & nli0O & nli0i & nl0OO & nl0ll & nl0ii & nl00O & wire_niii1O26_w_lg_w_lg_q132w133w & wire_niii0i24_w_lg_w_lg_q129w130w & nl01l);
	ni0Oi :  oper_selector
	  GENERIC MAP (
		width_data => 10,
		width_sel => 10
	  )
	  PORT MAP ( 
		data => wire_ni0Oi_data,
		o => wire_ni0Oi_o,
		sel => wire_ni0Oi_sel
	  );
	wire_ni10i_data <= ( niiilO & "0" & wire_nii0l_dataout & wire_nii1i_dataout);
	wire_ni10i_sel <= ( nlili & nii1Oi & nl01l & nl1OO);
	ni10i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_ni10i_data,
		o => wire_ni10i_o,
		sel => wire_ni10i_sel
	  );
	wire_ni11l_data <= ( wire_w_lg_niiilO447w & wire_w_lg_niiOOi445w & wire_nilOi_dataout & "0" & wire_nii0i_dataout & wire_ni0OO_dataout);
	wire_ni11l_sel <= ( nlili & nliil & nli0O & nii1lO & nl01l & nl1OO);
	ni11l :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_ni11l_data,
		o => wire_ni11l_o,
		sel => wire_ni11l_sel
	  );
	wire_ni1Ol_data <= ( "0" & niiOOi);
	wire_ni1Ol_sel <= ( nii1Ol & wire_w_lg_nii1Ol312w);
	ni1Ol :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni1Ol_data,
		o => wire_ni1Ol_o,
		sel => wire_ni1Ol_sel
	  );
	wire_nil00l_data <= ( "0" & "1" & wire_niO00O_dataout);
	wire_nil00l_sel <= ( wire_nli11l_w_lg_nli11O2169w & ni1lOO & nl0OOi);
	nil00l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nil00l_data,
		o => wire_nil00l_o,
		sel => wire_nil00l_sel
	  );
	wire_nil01O_data <= ( "0" & "1" & niiOOi & wire_niO00l_dataout);
	wire_nil01O_sel <= ( nli11O & ni1lOl & nl0OOl & nl0OOi);
	nil01O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nil01O_data,
		o => wire_nil01O_o,
		sel => wire_nil01O_sel
	  );
	wire_nil0il_data <= ( "0" & "1" & wire_niO0ii_dataout);
	wire_nil0il_sel <= ( nli11O & ni1O1i & nl0OOi);
	nil0il :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nil0il_data,
		o => wire_nil0il_o,
		sel => wire_nil0il_sel
	  );
	wire_nil0li_data <= ( "0" & "1" & wire_niO0il_dataout);
	wire_nil0li_sel <= ( ni1O1O & ni1O1l & nl0OOi);
	nil0li :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nil0li_data,
		o => wire_nil0li_o,
		sel => wire_nil0li_sel
	  );
	wire_nil0Oi_data <= ( "0" & wire_w_lg_niiOOi445w & wire_niO0iO_dataout & "1");
	wire_nil0Oi_sel <= ( ni1O0l & nl0OOl & nl0OOi & ni1O0i);
	nil0Oi :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nil0Oi_data,
		o => wire_nil0Oi_o,
		sel => wire_nil0Oi_sel
	  );
	wire_nil1li_data <= ( "0" & niiOOi);
	wire_nil1li_sel <= ( ni1lll & wire_w_lg_ni1lll2233w);
	nil1li :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nil1li_data,
		o => wire_nil1li_o,
		sel => wire_nil1li_sel
	  );
	wire_nil1lO_data <= ( "0" & wire_w_lg_niiOOi445w & wire_niO01O_dataout & "1");
	wire_nil1lO_sel <= ( ni1llO & nl0OOl & nl0OOi & wire_nl0OOO_w_lg_nl0O0l2215w);
	nil1lO :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nil1lO_data,
		o => wire_nil1lO_o,
		sel => wire_nil1lO_sel
	  );
	wire_nil1OO_data <= ( "0" & wire_w_lg_niiOOi445w & wire_niO00i_dataout & "1");
	wire_nil1OO_sel <= ( ni1lOi & nl0OOl & nl0OOi & wire_nl0OOO_w_lg_nl0O0l2201w);
	nil1OO :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nil1OO_data,
		o => wire_nil1OO_o,
		sel => wire_nil1OO_sel
	  );
	wire_nili0i_data <= ( "0" & niiOOi);
	wire_nili0i_sel <= ( ni1Oil & wire_w_lg_ni1Oil2081w);
	nili0i :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nili0i_data,
		o => wire_nili0i_o,
		sel => wire_nili0i_sel
	  );
	wire_nili0O_data <= ( "0" & niiOOi & wire_niO0ll_dataout & niiOOi);
	wire_nili0O_sel <= ( ni1OiO & nl0OOl & nl0OOi & nl0O0O);
	nili0O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nili0O_data,
		o => wire_nili0O_o,
		sel => wire_nili0O_sel
	  );
	wire_nili1i_data <= ( "0" & "1" & wire_niO0li_dataout);
	wire_nili1i_sel <= ( ni1Oii & ni1O0O & nl0OOi);
	nili1i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nili1i_data,
		o => wire_nili1i_o,
		sel => wire_nili1i_sel
	  );
	wire_niliil_data <= ( "0" & niiOOi & wire_niO0lO_dataout & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi);
	wire_niliil_sel <= ( ni1Oli & nli11i & nl0OOi & nl0OlO & nl0Oli & nl0Oil & nl0O0O & nl0O0i);
	niliil :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_niliil_data,
		o => wire_niliil_o,
		sel => wire_niliil_sel
	  );
	wire_nilili_data <= ( "0" & niiOOi & niiOOi & wire_niO0Oi_dataout & niiOOi & niiOOi & niiOOi & niiOOi);
	wire_nilili_sel <= ( ni1Oll & nli11i & nl0OOl & nl0OOi & nl0OlO & nl0Oli & nl0Oil & nl0O0i);
	nilili :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_nilili_data,
		o => wire_nilili_o,
		sel => wire_nilili_sel
	  );
	wire_nililO_data <= ( "0" & niiOOi & niiOOi & wire_niO0Ol_dataout & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi);
	wire_nililO_sel <= ( ni1OlO & nli11i & nl0OOl & nl0OOi & nl0OlO & nl0Oli & nl0Oil & nl0O0O & nl0O0i);
	nililO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nililO_data,
		o => wire_nililO_o,
		sel => wire_nililO_sel
	  );
	wire_niliOl_data <= ( "0" & niiOOi & niiOOi & wire_niO0OO_dataout & niiOOi & niiOOi & niiOOi & niiOOi);
	wire_niliOl_sel <= ( ni1OOi & nli11i & nl0OOl & nl0OOi & nl0OlO & nl0Oli & nl0O0O & nl0O0i);
	niliOl :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_niliOl_data,
		o => wire_niliOl_o,
		sel => wire_niliOl_sel
	  );
	wire_nill0O_data <= ( wire_nl01iO_dataout & wire_nl11Ol_dataout & "0" & wire_niO10i_dataout & wire_niO11O_dataout);
	wire_nill0O_sel <= ( nli11O & nli11i & ni011i & nl0OOi & nl0O0i);
	nill0O :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nill0O_data,
		o => wire_nill0O_o,
		sel => wire_nill0O_sel
	  );
	wire_nill1i_data <= ( "0" & niiOOi & wire_niOi1i_dataout & niiOOi & niiOOi & niiOOi & niiOOi);
	wire_nill1i_sel <= ( ni1OOl & nl0OOl & nl0OOi & nl0Oli & nl0Oil & nl0O0O & nl0O0i);
	nill1i :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_nill1i_data,
		o => wire_nill1i_o,
		sel => wire_nill1i_sel
	  );
	wire_nill1O_data <= ( "0" & niiOOi & niiOOi & wire_niOi1l_dataout & niiOOi & niiOOi & niiOOi);
	wire_nill1O_sel <= ( ni1OOO & nli11i & nl0OOl & nl0OOi & nl0Oil & nl0O0O & nl0O0i);
	nill1O :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_nill1O_data,
		o => wire_nill1O_o,
		sel => wire_nill1O_sel
	  );
	wire_nillil_data <= ( wire_nl01li_dataout & wire_nl11OO_dataout & "0" & wire_niO10l_dataout & wire_niO11l_dataout & wire_nlO_dataout);
	wire_nillil_sel <= ( nli11O & nli11i & ni011l & nl0OOi & nl0O0O & nl0O0l);
	nillil :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_nillil_data,
		o => wire_nillil_o,
		sel => wire_nillil_sel
	  );
	wire_nillli_data <= ( wire_nl01ll_dataout & wire_nl101i_dataout & "0" & wire_niO10O_dataout & wire_niO11O_dataout);
	wire_nillli_sel <= ( nli11O & nli11i & ni011O & nl0OOi & nl0O0O);
	nillli :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nillli_data,
		o => wire_nillli_o,
		sel => wire_nillli_sel
	  );
	wire_nilllO_data <= ( wire_nl01lO_dataout & wire_nl101l_dataout & "0" & wire_niO1ii_dataout & wire_niO11l_dataout & wire_nlO_dataout);
	wire_nilllO_sel <= ( nli11O & nli11i & ni010i & nl0OOi & nl0Oil & nl0Oii);
	nilllO :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_nilllO_data,
		o => wire_nilllO_o,
		sel => wire_nilllO_sel
	  );
	wire_nillOl_data <= ( wire_nl01Oi_dataout & wire_nl101O_dataout & "0" & wire_niO1il_dataout & wire_niO11O_dataout);
	wire_nillOl_sel <= ( nli11O & nli11i & ni010l & nl0OOi & nl0Oil);
	nillOl :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nillOl_data,
		o => wire_nillOl_o,
		sel => wire_nillOl_sel
	  );
	wire_nilO0l_data <= ( wire_nl001i_dataout & wire_nl100O_dataout & "0" & wire_niO1ll_dataout & wire_niO11l_dataout & wire_nlO_dataout);
	wire_nilO0l_sel <= ( nli11O & nli11i & ni01il & nl0OOi & nl0OlO & nl0Oll);
	nilO0l :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_nilO0l_data,
		o => wire_nilO0l_o,
		sel => wire_nilO0l_sel
	  );
	wire_nilO1i_data <= ( wire_nl01Ol_dataout & wire_nl100i_dataout & "0" & wire_niO1iO_dataout & wire_niO11l_dataout & wire_nlO_dataout);
	wire_nilO1i_sel <= ( nli11O & nli11i & ni010O & nl0OOi & nl0Oli & nl0OiO);
	nilO1i :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_nilO1i_data,
		o => wire_nilO1i_o,
		sel => wire_nilO1i_sel
	  );
	wire_nilO1O_data <= ( wire_nl01OO_dataout & wire_nl100l_dataout & "0" & wire_niO1li_dataout & wire_niO11O_dataout);
	wire_nilO1O_sel <= ( nli11O & nli11i & ni01ii & nl0OOi & nl0Oli);
	nilO1O :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nilO1O_data,
		o => wire_nilO1O_o,
		sel => wire_nilO1O_sel
	  );
	wire_nilOii_data <= ( wire_nl001l_dataout & wire_nl10ii_dataout & "0" & wire_niO1lO_dataout & wire_niO11O_dataout);
	wire_nilOii_sel <= ( nli11O & nli11i & ni01iO & nl0OOi & nl0OlO);
	nilOii :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nilOii_data,
		o => wire_nilOii_o,
		sel => wire_nilOii_sel
	  );
	wire_nilOiO_data <= ( wire_nl001O_dataout & wire_nl10il_dataout & "0" & wire_niO1Oi_dataout);
	wire_nilOiO_sel <= ( nli11O & nli11i & ni01ll & nl0OOi);
	nilOiO :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilOiO_data,
		o => wire_nilOiO_o,
		sel => wire_nilOiO_sel
	  );
	wire_nilOli_data <= ( wire_nl000i_dataout & wire_nl10iO_dataout & wire_nlO_dataout & wire_niO1Ol_dataout & "0");
	wire_nilOli_sel <= ( nli11O & nli11i & nl0OOl & nl0OOi & ni01li);
	nilOli :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nilOli_data,
		o => wire_nilOli_o,
		sel => wire_nilOli_sel
	  );
	wire_nilOlO_data <= ( wire_nl000l_dataout & wire_nl10li_dataout & "0" & wire_niO1OO_dataout);
	wire_nilOlO_sel <= ( nli11O & nli11i & ni01ll & nl0OOi);
	nilOlO :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilOlO_data,
		o => wire_nilOlO_o,
		sel => wire_nilOlO_sel
	  );
	wire_nilOOl_data <= ( wire_nl000O_dataout & wire_nl10ll_dataout & "0" & wire_niO01i_dataout & wire_niO11l_dataout & wire_nlO_dataout);
	wire_nilOOl_sel <= ( nli11O & nli11i & ni01lO & nl0OOi & nl0O0i & nl0O1O);
	nilOOl :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_nilOOl_data,
		o => wire_nilOOl_o,
		sel => wire_nilOOl_sel
	  );
	wire_niO11i_data <= ( wire_nl00ii_dataout & wire_nl10lO_dataout & wire_nlO_w_lg_dataout1647w & wire_niO01l_dataout & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w & wire_nlO_w_lg_dataout1647w);
	wire_niO11i_sel <= ( nli11O & nli11i & nl0OOl & nl0OOi & nl0OlO & nl0Oll & nl0Oli & nl0OiO & nl0Oil & nl0Oii & nl0O0O & nl0O0l & nl0O0i & nl0O1O);
	niO11i :  oper_selector
	  GENERIC MAP (
		width_data => 14,
		width_sel => 14
	  )
	  PORT MAP ( 
		data => wire_niO11i_data,
		o => wire_niO11i_o,
		sel => wire_niO11i_sel
	  );
	wire_nlilOi_data <= ( "0" & wire_nlOO1i_dataout & wire_nlllll_dataout & wire_w_lg_ni0l0l913w & wire_w_lg_ni0l0l913w);
	wire_nlilOi_sel <= ( ni000i & n1l0l & n1iii & n1i0O & n1i0l);
	nlilOi :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nlilOi_data,
		o => wire_nlilOi_o,
		sel => wire_nlilOi_sel
	  );
	wire_nliO0l_data <= ( "0" & wire_nlllli_dataout & wire_w_lg_ni0l0l913w);
	wire_nliO0l_sel <= ( ni00ii & n1iii & n1i0O);
	nliO0l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliO0l_data,
		o => wire_nliO0l_o,
		sel => wire_nliO0l_sel
	  );
	wire_nliO1i_data <= ( "0" & niiOOi);
	wire_nliO1i_sel <= ( ni000l & wire_w_lg_ni000l1442w);
	nliO1i :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nliO1i_data,
		o => wire_nliO1i_o,
		sel => wire_nliO1i_sel
	  );
	wire_nliO1O_data <= ( "0" & ni0l0l & wire_w_lg_ni0l0l913w);
	wire_nliO1O_sel <= ( ni000O & n1i0O & n1i0l);
	nliO1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliO1O_data,
		o => wire_nliO1O_o,
		sel => wire_nliO1O_sel
	  );
	wire_nliOii_data <= ( "0" & niiOOi & "1" & wire_nlllll_dataout);
	wire_nliOii_sel <= ( ni00il & n1ilO & wire_n1l0O_w_lg_w_lg_w_lg_n1ill1401w1402w1403w & n1iii);
	nliOii :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nliOii_data,
		o => wire_nliOii_o,
		sel => wire_nliOii_sel
	  );
	wire_nliOli_data <= ( "0" & wire_nlO1ii_dataout & wire_nllO0l_dataout);
	wire_nliOli_sel <= ( ni00iO & n1l1i & n1iOO);
	nliOli :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliOli_data,
		o => wire_nliOli_o,
		sel => wire_nliOli_sel
	  );
	wire_nliOlO_data <= ( "0" & wire_nlO1il_dataout & wire_nllO0O_dataout);
	wire_nliOlO_sel <= ( ni00iO & n1l1i & n1iOO);
	nliOlO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliOlO_data,
		o => wire_nliOlO_o,
		sel => wire_nliOlO_sel
	  );
	wire_nliOOi_data <= ( "0" & wire_nlO1iO_dataout & wire_nllOii_dataout);
	wire_nliOOi_sel <= ( ni00iO & n1l1i & n1iOO);
	nliOOi :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliOOi_data,
		o => wire_nliOOi_o,
		sel => wire_nliOOi_sel
	  );
	wire_nliOOl_data <= ( "0" & wire_nlO1li_dataout & wire_nllOil_dataout);
	wire_nliOOl_sel <= ( ni00iO & n1l1i & n1iOO);
	nliOOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliOOl_data,
		o => wire_nliOOl_o,
		sel => wire_nliOOl_sel
	  );
	wire_nll00O_data <= ( "0" & "1" & wire_w_lg_niiOOi445w);
	wire_nll00O_sel <= ( ni0i0l & ni0i0i & n1iOi);
	nll00O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll00O_data,
		o => wire_nll00O_o,
		sel => wire_nll00O_sel
	  );
	wire_nll01i_data <= ( ni0Oii & "0" & wire_nlllOi_dataout & wire_nllliO_dataout);
	wire_nll01i_sel <= ( n1liO & ni0i1i & n1iii & n1i0l);
	nll01i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nll01i_data,
		o => wire_nll01i_o,
		sel => wire_nll01i_sel
	  );
	wire_nll01O_data <= ( "0" & "1" & wire_w_lg_niiOOi445w);
	wire_nll01O_sel <= ( ni0i1O & ni0i1l & n1iOi);
	nll01O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll01O_data,
		o => wire_nll01O_o,
		sel => wire_nll01O_sel
	  );
	wire_nll0iO_data <= ( "0" & "1" & niiOOi);
	wire_nll0iO_sel <= ( ni0iii & ni0i0O & n1iOi);
	nll0iO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll0iO_data,
		o => wire_nll0iO_o,
		sel => wire_nll0iO_sel
	  );
	wire_nll0lO_data <= ( "0" & "1" & wire_w_lg_niiOOi445w);
	wire_nll0lO_sel <= ( ni0iiO & ni0iil & n1iOi);
	nll0lO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll0lO_data,
		o => wire_nll0lO_o,
		sel => wire_nll0lO_sel
	  );
	wire_nll0OO_data <= ( "0" & "1" & niiOOi);
	wire_nll0OO_sel <= ( wire_n1lil_w_lg_w_lg_w_lg_n1liO1051w1092w1093w & ni0ili & n1iOi);
	nll0OO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll0OO_data,
		o => wire_nll0OO_o,
		sel => wire_nll0OO_sel
	  );
	wire_nll10i_data <= ( "0" & wire_nlO1lO_dataout & wire_nllOiO_dataout & wire_nllO0i_dataout);
	wire_nll10i_sel <= ( ni00ll & n1l1i & n1iOO & n1iOl);
	nll10i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nll10i_data,
		o => wire_nll10i_o,
		sel => wire_nll10i_sel
	  );
	wire_nll10O_data <= ( "0" & wire_nlOiii_dataout & wire_nlO1Oi_dataout & wire_w_lg_niiOOi445w);
	wire_nll10O_sel <= ( ni00lO & n1l1l & n1l1i & n1iOO);
	nll10O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nll10O_data,
		o => wire_nll10O_o,
		sel => wire_nll10O_sel
	  );
	wire_nll11l_data <= ( "0" & "1" & wire_nllO1O_dataout);
	wire_nll11l_sel <= ( ni00li & n1iOi & n1iOl);
	nll11l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll11l_data,
		o => wire_nll11l_o,
		sel => wire_nll11l_sel
	  );
	wire_nll1il_data <= ( "0" & wire_nlOlOi_dataout & "1" & wire_nlOiil_dataout & wire_nlO1Ol_dataout & wire_nllOli_dataout);
	wire_nll1il_sel <= ( ni00Oi & n1l0l & wire_n1l0O_w_lg_n1l0i1211w & n1l1l & n1l1i & n1iOO);
	nll1il :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_nll1il_data,
		o => wire_nll1il_o,
		sel => wire_nll1il_sel
	  );
	wire_nll1ll_data <= ( "0" & niiOOi & wire_nlOlOl_dataout);
	wire_nll1ll_sel <= ( ni00Ol & n1lii & n1l0l);
	nll1ll :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll1ll_data,
		o => wire_nll1ll_o,
		sel => wire_nll1ll_sel
	  );
	wire_nll1Ol_data <= ( wire_w_lg_ni0Oii1237w & wire_w_lg_niiOOi445w & wire_nlOO1i_dataout & "0" & wire_nllllO_dataout & wire_nlllil_dataout);
	wire_nll1Ol_sel <= ( n1liO & n1lii & n1l0l & ni00OO & n1iii & n1i0l);
	nll1Ol :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_nll1Ol_data,
		o => wire_nll1Ol_o,
		sel => wire_nll1Ol_sel
	  );
	wire_nlli0i_data <= ( "0" & "1" & niiOOi);
	wire_nlli0i_sel <= ( ni0ilO & ni0ill & n1iOi);
	nlli0i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlli0i_data,
		o => wire_nlli0i_o,
		sel => wire_nlli0i_sel
	  );
	wire_nlliil_data <= ( "0" & niiOOi);
	wire_nlliil_sel <= ( ni0iOi & wire_w_lg_ni0iOi1037w);
	nlliil :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlliil_data,
		o => wire_nlliil_o,
		sel => wire_nlliil_sel
	  );
	wire_nllili_data <= ( "0" & niiOOi);
	wire_nllili_sel <= ( ni0iOl & wire_w_lg_ni0iOl1019w);
	nllili :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllili_data,
		o => wire_nllili_o,
		sel => wire_nllili_sel
	  );
	wire_nllilO_data <= ( "0" & niiOOi);
	wire_nllilO_sel <= ( ni0l1i & wire_w_lg_ni0l1i983w);
	nllilO :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllilO_data,
		o => wire_nllilO_o,
		sel => wire_nllilO_sel
	  );
	wire_nlliOi_data <= ( "0" & niiOOi);
	wire_nlliOi_sel <= ( ni0iOO & wire_w_lg_ni0iOO996w);
	nlliOi :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlliOi_data,
		o => wire_nlliOi_o,
		sel => wire_nlliOi_sel
	  );
	wire_nlliOO_data <= ( "0" & niiOOi);
	wire_nlliOO_sel <= ( ni0l1i & wire_w_lg_ni0l1i983w);
	nlliOO :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlliOO_data,
		o => wire_nlliOO_o,
		sel => wire_nlliOO_sel
	  );
	wire_nlll0i_data <= ( "0" & niiOOi);
	wire_nlll0i_sel <= ( ni0l1O & wire_w_lg_ni0l1O957w);
	nlll0i :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlll0i_data,
		o => wire_nlll0i_o,
		sel => wire_nlll0i_sel
	  );
	wire_nlll0O_data <= ( "0" & wire_nlOllO_dataout & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi & niiOOi);
	wire_nlll0O_sel <= ( ni0l0i & n1l0l & n1l1i & n1iOO & n1iOi & n1iOl & n1ilO & n1ill & n1ili & n1iil & n1iii);
	nlll0O :  oper_selector
	  GENERIC MAP (
		width_data => 11,
		width_sel => 11
	  )
	  PORT MAP ( 
		data => wire_nlll0O_data,
		o => wire_nlll0O_o,
		sel => wire_nlll0O_sel
	  );
	wire_nlll1l_data <= ( "0" & niiOOi);
	wire_nlll1l_sel <= ( ni0l1l & wire_w_lg_ni0l1l970w);
	nlll1l :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlll1l_data,
		o => wire_nlll1l_o,
		sel => wire_nlll1l_sel
	  );

 END RTL; --cycloneiv_hssi_tx_digi_bist_gen
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 10.0SP1 cbx_mgl 2010:08:18:21:20:44:SJ cbx_simgen 2010:08:18:21:16:35:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 106 mux21 189 oper_add 1 oper_decoder 1 oper_mux 23 oper_selector 23 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  cycloneiv_hssi_tx_digi_prbs_gen IS 
	 PORT 
	 ( 
		 cid_en	:	IN  STD_LOGIC;
		 prbs_out	:	OUT  STD_LOGIC_VECTOR (19 DOWNTO 0);
		 rcid_len	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 rcid_pattern	:	IN  STD_LOGIC;
		 rpma_doublewidth_tx	:	IN  STD_LOGIC;
		 rpmadwidth_tx	:	IN  STD_LOGIC;
		 rprbs_en_tx	:	IN  STD_LOGIC;
		 rprbs_sel	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 soft_reset	:	IN  STD_LOGIC;
		 tx_clk	:	IN  STD_LOGIC
	 ); 
 END cycloneiv_hssi_tx_digi_prbs_gen;

 ARCHITECTURE RTL OF cycloneiv_hssi_tx_digi_prbs_gen IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nll00l33	:	STD_LOGIC := '0';
	 SIGNAL	 nll00l34	:	STD_LOGIC := '0';
	 SIGNAL  wire_nll00l34_w_lg_w_lg_q141w142w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll00l34_w_lg_q141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nll01i37	:	STD_LOGIC := '0';
	 SIGNAL	 nll01i38	:	STD_LOGIC := '0';
	 SIGNAL  wire_nll01i38_w_lg_w_lg_q152w153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i38_w_lg_q152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nll01O35	:	STD_LOGIC := '0';
	 SIGNAL	 nll01O36	:	STD_LOGIC := '0';
	 SIGNAL	 nll0ii31	:	STD_LOGIC := '0';
	 SIGNAL	 nll0ii32	:	STD_LOGIC := '0';
	 SIGNAL	 nll0iO29	:	STD_LOGIC := '0';
	 SIGNAL	 nll0iO30	:	STD_LOGIC := '0';
	 SIGNAL	 nll0Ol27	:	STD_LOGIC := '0';
	 SIGNAL	 nll0Ol28	:	STD_LOGIC := '0';
	 SIGNAL	 nll1ii45	:	STD_LOGIC := '0';
	 SIGNAL	 nll1ii46	:	STD_LOGIC := '0';
	 SIGNAL	 nll1li43	:	STD_LOGIC := '0';
	 SIGNAL	 nll1li44	:	STD_LOGIC := '0';
	 SIGNAL	 nll1lO41	:	STD_LOGIC := '0';
	 SIGNAL	 nll1lO42	:	STD_LOGIC := '0';
	 SIGNAL	 nll1Ol39	:	STD_LOGIC := '0';
	 SIGNAL	 nll1Ol40	:	STD_LOGIC := '0';
	 SIGNAL  wire_nll1Ol40_w_lg_w_lg_q157w158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll1Ol40_w_lg_q157w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlli0l23	:	STD_LOGIC := '0';
	 SIGNAL	 nlli0l24	:	STD_LOGIC := '0';
	 SIGNAL	 nlli1O25	:	STD_LOGIC := '0';
	 SIGNAL	 nlli1O26	:	STD_LOGIC := '0';
	 SIGNAL	 nlliil21	:	STD_LOGIC := '0';
	 SIGNAL	 nlliil22	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlliil22_w_lg_w_lg_q93w94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliil22_w_lg_q93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlliiO19	:	STD_LOGIC := '0';
	 SIGNAL	 nlliiO20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlliiO20_w_lg_w_lg_q88w89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliiO20_w_lg_q88w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllill17	:	STD_LOGIC := '0';
	 SIGNAL	 nllill18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllill18_w_lg_w_lg_q79w80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllill18_w_lg_q79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlliOi15	:	STD_LOGIC := '0';
	 SIGNAL	 nlliOi16	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlliOi16_w_lg_w_lg_q69w70w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliOi16_w_lg_q69w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlll0O11	:	STD_LOGIC := '0';
	 SIGNAL	 nlll0O12	:	STD_LOGIC := '0';
	 SIGNAL	 nlll1i13	:	STD_LOGIC := '0';
	 SIGNAL	 nlll1i14	:	STD_LOGIC := '0';
	 SIGNAL	 nlllil10	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlllil10_w_lg_w_lg_q20w21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllil10_w_lg_q20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlllil9	:	STD_LOGIC := '0';
	 SIGNAL	 nllliO7	:	STD_LOGIC := '0';
	 SIGNAL	 nllliO8	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllliO8_w_lg_w_lg_q17w18w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllliO8_w_lg_q17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlllli5	:	STD_LOGIC := '0';
	 SIGNAL	 nlllli6	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlllli6_w_lg_w_lg_q12w13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllli6_w_lg_q12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlllll3	:	STD_LOGIC := '0';
	 SIGNAL	 nlllll4	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlllll4_w_lg_w_lg_q7w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllll4_w_lg_q7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlllOl1	:	STD_LOGIC := '0';
	 SIGNAL	 nlllOl2	:	STD_LOGIC := '0';
	 SIGNAL	ni0O	:	STD_LOGIC := '0';
	 SIGNAL	nlO0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO0OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOili	:	STD_LOGIC := '0';
	 SIGNAL	nlOill	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0l_PRN	:	STD_LOGIC;
	 SIGNAL  wire_ni0l_w_lg_ni0O182w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0i	:	STD_LOGIC := '0';
	 SIGNAL	n1i	:	STD_LOGIC := '0';
	 SIGNAL	n1l	:	STD_LOGIC := '0';
	 SIGNAL	n1O	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	nill	:	STD_LOGIC := '0';
	 SIGNAL	nlll	:	STD_LOGIC := '0';
	 SIGNAL	nllO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOl0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOl0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOl0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOlii	:	STD_LOGIC := '0';
	 SIGNAL	nlOlil	:	STD_LOGIC := '0';
	 SIGNAL	nlOliO	:	STD_LOGIC := '0';
	 SIGNAL	nlOlli	:	STD_LOGIC := '0';
	 SIGNAL	nlOlll	:	STD_LOGIC := '0';
	 SIGNAL	nlOllO	:	STD_LOGIC := '0';
	 SIGNAL	nlOlOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOlOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOO1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOOii	:	STD_LOGIC := '0';
	 SIGNAL	nlOOil	:	STD_LOGIC := '0';
	 SIGNAL	nlOOiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOli	:	STD_LOGIC := '0';
	 SIGNAL	nlOOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOOlO	:	STD_LOGIC := '0';
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll2157w2180w2181w2182w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll2189w2190w2191w2192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_w_lg_nlOlll2157w2180w2181w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_w_lg_nlOlll2189w2190w2191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_n0i61w62w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOlll2157w2180w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOlll2189w2190w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_n0i61w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlll2157w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_n1i2167w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_n1l2165w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_n1O2164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlll2177w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nllO2175w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOi2173w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOl0i2187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOl0l2185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOl0O2183w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOl2171w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlii2193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOliO2179w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlll2189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO2169w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOOlO103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w144w145w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll137w138w139w143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_w_lg_nlOlll137w138w139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOlll1321w1322w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOlll137w138w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOO0i869w870w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOO0l1760w1761w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOO0O1692w1693w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOO1O939w940w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOOii955w956w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_w_lg_nlOOil885w886w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOl0O1719w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlii1254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlii1651w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOliO1625w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlli1560w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlli1530w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlll1321w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlll1465w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlll137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOllO1400w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlOi1333w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlOl1744w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlOO1280w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOlOO1676w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO0i869w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO0l1760w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO0l1227w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO0O1692w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO0O1159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO1i1212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO1l1144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO1O939w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOO1O1076w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOOii1091w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOOii955w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOOil885w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_nlOOil1023w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nilO	:	STD_LOGIC := '0';
	 SIGNAL	nlil	:	STD_LOGIC := '0';
	 SIGNAL	nlli	:	STD_LOGIC := '0';
	 SIGNAL	wire_nliO_PRN	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_ni_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_lg_w_lg_w_o_range106w1878w1941w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_lg_w_lg_w_o_range106w1961w1962w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_lg_w_o_range106w1878w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_lg_w_o_range106w1961w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ii_i	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00ii_o	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_o_range106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_o_range1798w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_o_range1824w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ii_w_o_range1839w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00il_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00il_o	:	STD_LOGIC;
	 SIGNAL  wire_n00il_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00iO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n00iO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00li_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00li_o	:	STD_LOGIC;
	 SIGNAL  wire_n00li_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00ll_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n00ll_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00lO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00lO_o	:	STD_LOGIC;
	 SIGNAL  wire_n00lO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00Oi_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n00Oi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00Ol_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n00Ol_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n00OO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n00OO_o	:	STD_LOGIC;
	 SIGNAL  wire_n00OO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0i0i_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0i0i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0i0l_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0i0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0l_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0i0O_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0i0O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i0O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0i1i_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0i1i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i1i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0i1l_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0i1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i1l_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0i1O_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0i1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0i1O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iii_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0iii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iii_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iil_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0iil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iil_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iiO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0iiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iiO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0ili_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0ili_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ili_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0ill_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0ill_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ill_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0ilO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0ilO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ilO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iOi_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0iOi_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iOl_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0iOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOl_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iOO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n0iOO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n000i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n000i_o	:	STD_LOGIC;
	 SIGNAL  wire_n000i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n001O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n001O_o	:	STD_LOGIC;
	 SIGNAL  wire_n001O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n010i_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n010i_o	:	STD_LOGIC;
	 SIGNAL  wire_n010i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n010O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n010O_o	:	STD_LOGIC;
	 SIGNAL  wire_n010O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n011i_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n011i_o	:	STD_LOGIC;
	 SIGNAL  wire_n011i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n011l_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n011l_o	:	STD_LOGIC;
	 SIGNAL  wire_n011l_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n011O_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n011O_o	:	STD_LOGIC;
	 SIGNAL  wire_n011O_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01iO_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n01iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n01iO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n01ll_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n01ll_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01lO_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01lO_o	:	STD_LOGIC;
	 SIGNAL  wire_n01lO_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01Oi_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n01Oi_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01Ol_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n01Ol_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n1O0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O0O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1O0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oii_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oil_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oil_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oil_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OiO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oli_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oli_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oli_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oll_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oll_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oll_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OlO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OlO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OlO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OOi_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OOi_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OOi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niOO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niOO_o	:	STD_LOGIC;
	 SIGNAL  wire_niOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlli0i2123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlliii115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nllili85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nllilO77w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlliOl66w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlll0i60w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rpma_doublewidth_tx2149w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rpmadwidth_tx2148w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w160w161w162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w160w161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_nlli1i150w154w155w159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nlli1i150w154w155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliOli815w816w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliOll745w746w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliOlO675w676w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliOOi538w539w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nliOOl469w470w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nll10i729w730w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nll11O799w800w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlli1i150w154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliO0O1363w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliO1l1348w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliOli815w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliOll745w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliOlO675w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliOOi607w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliOOi538w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nliOOl469w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nll10i729w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nll10l1129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nll10O1197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nll11O799w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nll1iO1265w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlli1i150w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nliiOO :	STD_LOGIC;
	 SIGNAL  nlil0i :	STD_LOGIC;
	 SIGNAL  nlil0l :	STD_LOGIC;
	 SIGNAL  nlil0O :	STD_LOGIC;
	 SIGNAL  nlil1i :	STD_LOGIC;
	 SIGNAL  nlil1l :	STD_LOGIC;
	 SIGNAL  nlil1O :	STD_LOGIC;
	 SIGNAL  nlilii :	STD_LOGIC;
	 SIGNAL  nlilil :	STD_LOGIC;
	 SIGNAL  nliliO :	STD_LOGIC;
	 SIGNAL  nlilli :	STD_LOGIC;
	 SIGNAL  nlilll :	STD_LOGIC;
	 SIGNAL  nlillO :	STD_LOGIC;
	 SIGNAL  nlilOi :	STD_LOGIC;
	 SIGNAL  nlilOl :	STD_LOGIC;
	 SIGNAL  nlilOO :	STD_LOGIC;
	 SIGNAL  nliO0i :	STD_LOGIC;
	 SIGNAL  nliO0l :	STD_LOGIC;
	 SIGNAL  nliO0O :	STD_LOGIC;
	 SIGNAL  nliO1i :	STD_LOGIC;
	 SIGNAL  nliO1l :	STD_LOGIC;
	 SIGNAL  nliO1O :	STD_LOGIC;
	 SIGNAL  nliOii :	STD_LOGIC;
	 SIGNAL  nliOil :	STD_LOGIC;
	 SIGNAL  nliOiO :	STD_LOGIC;
	 SIGNAL  nliOli :	STD_LOGIC;
	 SIGNAL  nliOll :	STD_LOGIC;
	 SIGNAL  nliOlO :	STD_LOGIC;
	 SIGNAL  nliOOi :	STD_LOGIC;
	 SIGNAL  nliOOl :	STD_LOGIC;
	 SIGNAL  nliOOO :	STD_LOGIC;
	 SIGNAL  nll0ll :	STD_LOGIC;
	 SIGNAL  nll0lO :	STD_LOGIC;
	 SIGNAL  nll0Oi :	STD_LOGIC;
	 SIGNAL  nll10i :	STD_LOGIC;
	 SIGNAL  nll10l :	STD_LOGIC;
	 SIGNAL  nll10O :	STD_LOGIC;
	 SIGNAL  nll11i :	STD_LOGIC;
	 SIGNAL  nll11l :	STD_LOGIC;
	 SIGNAL  nll11O :	STD_LOGIC;
	 SIGNAL  nll1iO :	STD_LOGIC;
	 SIGNAL  nlli0i :	STD_LOGIC;
	 SIGNAL  nlli1i :	STD_LOGIC;
	 SIGNAL  nlli1l :	STD_LOGIC;
	 SIGNAL  nlliii :	STD_LOGIC;
	 SIGNAL  nllili :	STD_LOGIC;
	 SIGNAL  nllilO :	STD_LOGIC;
	 SIGNAL  nlliOl :	STD_LOGIC;
	 SIGNAL  nlliOO :	STD_LOGIC;
	 SIGNAL  nlll0i :	STD_LOGIC;
	 SIGNAL  nlll0l :	STD_LOGIC;
	 SIGNAL  nlll1O :	STD_LOGIC;
	 SIGNAL  nllllO :	STD_LOGIC;
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_nlli0i2123w(0) <= NOT nlli0i;
	wire_w_lg_nlliii115w(0) <= NOT nlliii;
	wire_w_lg_nllili85w(0) <= NOT nllili;
	wire_w_lg_nllilO77w(0) <= NOT nllilO;
	wire_w_lg_nlliOl66w(0) <= NOT nlliOl;
	wire_w_lg_nlll0i60w(0) <= NOT nlll0i;
	wire_w_lg_rpma_doublewidth_tx2149w(0) <= NOT rpma_doublewidth_tx;
	wire_w_lg_rpmadwidth_tx2148w(0) <= NOT rpmadwidth_tx;
	wire_w_lg_soft_reset2w(0) <= NOT soft_reset;
	wire_w_lg_w_lg_w160w161w162w(0) <= wire_w_lg_w160w161w(0) XOR nlOl0i;
	wire_w_lg_w160w161w(0) <= wire_w160w(0) XOR nlOl0l;
	wire_w160w(0) <= wire_w_lg_w_lg_w_lg_w_lg_nlli1i150w154w155w159w(0) XOR nlOl0O;
	wire_w_lg_w_lg_w_lg_w_lg_nlli1i150w154w155w159w(0) <= wire_w_lg_w_lg_w_lg_nlli1i150w154w155w(0) XOR wire_nll1Ol40_w_lg_w_lg_q157w158w(0);
	wire_w_lg_w_lg_w_lg_nlli1i150w154w155w(0) <= wire_w_lg_w_lg_nlli1i150w154w(0) XOR nlOlii;
	wire_w_lg_w_lg_nliOli815w816w(0) <= wire_w_lg_nliOli815w(0) XOR nlOO1l;
	wire_w_lg_w_lg_nliOll745w746w(0) <= wire_w_lg_nliOll745w(0) XOR nlOO1O;
	wire_w_lg_w_lg_nliOlO675w676w(0) <= wire_w_lg_nliOlO675w(0) XOR nlOO0i;
	wire_w_lg_w_lg_nliOOi538w539w(0) <= wire_w_lg_nliOOi538w(0) XOR nlOO1l;
	wire_w_lg_w_lg_nliOOl469w470w(0) <= wire_w_lg_nliOOl469w(0) XOR nlOO1l;
	wire_w_lg_w_lg_nll10i729w730w(0) <= wire_w_lg_nll10i729w(0) XOR nlOlOl;
	wire_w_lg_w_lg_nll11O799w800w(0) <= wire_w_lg_nll11O799w(0) XOR nlOlOi;
	wire_w_lg_w_lg_nlli1i150w154w(0) <= wire_w_lg_nlli1i150w(0) XOR wire_nll01i38_w_lg_w_lg_q152w153w(0);
	wire_w_lg_nliO0O1363w(0) <= nliO0O XOR nlOO1l;
	wire_w_lg_nliO1l1348w(0) <= nliO1l XOR nlOlOi;
	wire_w_lg_nliOli815w(0) <= nliOli XOR nlOO1O;
	wire_w_lg_nliOll745w(0) <= nliOll XOR nlOO0i;
	wire_w_lg_nliOlO675w(0) <= nliOlO XOR nlOO0l;
	wire_w_lg_nliOOi607w(0) <= nliOOi XOR nlOO0l;
	wire_w_lg_nliOOi538w(0) <= nliOOi XOR nlOO1O;
	wire_w_lg_nliOOl469w(0) <= nliOOl XOR nlOO0i;
	wire_w_lg_nll10i729w(0) <= nll10i XOR nlOlOO;
	wire_w_lg_nll10l1129w(0) <= nll10l XOR nlOlOi;
	wire_w_lg_nll10O1197w(0) <= nll10O XOR nlOllO;
	wire_w_lg_nll11O799w(0) <= nll11O XOR nlOlOl;
	wire_w_lg_nll1iO1265w(0) <= nll1iO XOR nlOlll;
	wire_w_lg_nlli1i150w(0) <= nlli1i XOR nlOliO;
	nliiOO <= ((wire_n00ii_o(25) OR wire_n00ii_o(17)) OR wire_n00ii_o(4));
	nlil0i <= wire_n00ii_w_lg_w_o_range106w1878w(0);
	nlil0l <= (((((((((wire_n00ii_o(24) OR wire_n00ii_o(2)) OR wire_n00ii_o(28)) OR wire_n00ii_o(27)) OR wire_n00ii_o(26)) OR wire_n00ii_o(11)) OR wire_n00ii_o(10)) OR wire_n00ii_o(9)) OR wire_n00ii_o(8)) OR wire_n00ii_o(1));
	nlil0O <= ((((((((((((((((wire_n00ii_o(31) OR wire_n00ii_o(30)) OR wire_n00ii_o(29)) OR wire_n00ii_o(23)) OR wire_n00ii_o(22)) OR wire_n00ii_o(21)) OR wire_n00ii_o(20)) OR wire_n00ii_o(19)) OR wire_n00ii_o(15)) OR wire_n00ii_o(14)) OR wire_n00ii_o(13)) OR wire_n00ii_o(12)) OR wire_n00ii_o(7)) OR wire_n00ii_o(6)) OR wire_n00ii_o(5)) OR wire_n00ii_o(4)) OR wire_n00ii_o(3));
	nlil1i <= (((((((((((((((wire_n00ii_o(31) OR wire_n00ii_o(30)) OR wire_n00ii_o(29)) OR wire_n00ii_o(23)) OR wire_n00ii_o(22)) OR wire_n00ii_o(21)) OR wire_n00ii_o(20)) OR wire_n00ii_o(19)) OR wire_n00ii_o(15)) OR wire_n00ii_o(14)) OR wire_n00ii_o(13)) OR wire_n00ii_o(12)) OR wire_n00ii_o(7)) OR wire_n00ii_o(6)) OR wire_n00ii_o(5)) OR wire_n00ii_o(3));
	nlil1l <= ((((((((((wire_n00ii_o(24) OR wire_n00ii_o(2)) OR wire_n00ii_o(28)) OR wire_n00ii_o(27)) OR wire_n00ii_o(26)) OR wire_n00ii_o(25)) OR wire_n00ii_o(11)) OR wire_n00ii_o(10)) OR wire_n00ii_o(9)) OR wire_n00ii_o(8)) OR wire_n00ii_o(1));
	nlil1O <= ((((((((((wire_n00ii_o(24) OR wire_n00ii_o(2)) OR wire_n00ii_o(28)) OR wire_n00ii_o(27)) OR wire_n00ii_o(26)) OR wire_n00ii_o(17)) OR wire_n00ii_o(11)) OR wire_n00ii_o(10)) OR wire_n00ii_o(9)) OR wire_n00ii_o(8)) OR wire_n00ii_o(1));
	nlilii <= (((((((((((wire_n00ii_o(24) OR wire_n00ii_o(16)) OR wire_n00ii_o(2)) OR wire_n00ii_o(28)) OR wire_n00ii_o(27)) OR wire_n00ii_o(26)) OR wire_n00ii_o(18)) OR wire_n00ii_o(11)) OR wire_n00ii_o(10)) OR wire_n00ii_o(9)) OR wire_n00ii_o(8)) OR wire_n00ii_o(1));
	nlilil <= (((((((((((((((((wire_n00ii_o(31) OR wire_n00ii_o(30)) OR wire_n00ii_o(29)) OR wire_n00ii_o(23)) OR wire_n00ii_o(22)) OR wire_n00ii_o(21)) OR wire_n00ii_o(20)) OR wire_n00ii_o(19)) OR wire_n00ii_o(17)) OR wire_n00ii_o(15)) OR wire_n00ii_o(14)) OR wire_n00ii_o(13)) OR wire_n00ii_o(12)) OR wire_n00ii_o(7)) OR wire_n00ii_o(6)) OR wire_n00ii_o(5)) OR wire_n00ii_o(4)) OR wire_n00ii_o(3));
	nliliO <= (nlOlll XOR nlOl0O);
	nlilli <= (nlOllO XOR nlOlii);
	nlilll <= (nlOlOi XOR nlOlil);
	nlillO <= (nlOlOl XOR nlOliO);
	nlilOi <= (nlOlOO XOR nlOlli);
	nlilOl <= (nlOO1i XOR nlOlll);
	nlilOO <= (nlOO1l XOR nlOllO);
	nliO0i <= (nlOO0O XOR nlOO1i);
	nliO0l <= (nlOOii XOR nlOO1l);
	nliO0O <= (nlOOil XOR nlOO1O);
	nliO1i <= (nlOO1O XOR nlOlOi);
	nliO1l <= (nlOO0i XOR nlOlOl);
	nliO1O <= (nlOO0l XOR nlOlOO);
	nliOii <= (nlOOiO XOR nlOO0i);
	nliOil <= (nlOOli XOR nlOO0l);
	nliOiO <= (nlOOll XOR nlOO0O);
	nliOli <= (nlOO0l XOR nlOO0i);
	nliOll <= (nlOO0O XOR nlOO0l);
	nliOlO <= (nlOOii XOR nlOO0O);
	nliOOi <= (nliOOl XOR nlOO0O);
	nliOOl <= (nlOOil XOR nlOOii);
	nliOOO <= (nlOO1O XOR nlOO1l);
	nll0ll <= (nlOlil XOR nlOlii);
	nll0lO <= (nlOliO XOR nlOlil);
	nll0Oi <= ((nlOlli XOR nlOliO) XOR (NOT (nll0Ol28 XOR nll0Ol27)));
	nll10i <= (nlOO1l XOR nlOO1i);
	nll10l <= (nlOliO XOR nlOl0O);
	nll10O <= ((nlOlil XOR nlOl0l) XOR (NOT (nll1ii46 XOR nll1ii45)));
	nll11i <= (nlOO0i XOR nlOO1O);
	nll11l <= (nlOO0i XOR nlOO1l);
	nll11O <= (nlOO1i XOR nlOlOO);
	nll1iO <= ((nlOlii XOR nlOl0i) XOR (NOT (nll1li44 XOR nll1li43)));
	nlli0i <= (((wire_n00ii_o(24) OR wire_n00ii_o(16)) OR wire_n00ii_o(2)) OR (NOT (nlli0l24 XOR nlli0l23)));
	nlli1i <= (nlOlll XOR nlOlli);
	nlli1l <= (wire_niOl_dataout OR wire_niOi_dataout);
	nlliii <= (nili AND wire_nl_w_lg_nlOOlO103w(0));
	nllili <= (((((((wire_nl_w_lg_n1O2164w(0) AND wire_nl_w_lg_n1l2165w(0)) AND wire_nl_w_lg_n1i2167w(0)) AND wire_nl_w_lg_nlOO2169w(0)) AND wire_nl_w_lg_nlOl2171w(0)) AND wire_nl_w_lg_nlOi2173w(0)) AND wire_nl_w_lg_nllO2175w(0)) AND nlll);
	nllilO <= ((((((wire_nl_w_lg_nlOlll2157w(0) AND nlOliO) AND nlOlil) AND nlOlii) AND nlOl0O) AND nlOl0l) AND nlOl0i);
	nlliOl <= ((((wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll2189w2190w2191w2192w(0) AND wire_nl_w_lg_nlOlii2193w(0)) AND wire_nl_w_lg_nlOl0O2183w(0)) AND wire_nl_w_lg_nlOl0l2185w(0)) AND wire_nl_w_lg_nlOl0i2187w(0));
	nlliOO <= (wire_nl_w_lg_w_lg_n0i61w62w(0) AND (nlll1i14 XOR nlll1i13));
	nlll0i <= (((((((wire_nl_w_lg_n1O2164w(0) AND wire_nl_w_lg_n1l2165w(0)) AND wire_nl_w_lg_n1i2167w(0)) AND wire_nl_w_lg_nlOO2169w(0)) AND wire_nl_w_lg_nlOl2171w(0)) AND wire_nl_w_lg_nlOi2173w(0)) AND wire_nl_w_lg_nllO2175w(0)) AND wire_nl_w_lg_nlll2177w(0));
	nlll0l <= ((((wire_w_lg_rpmadwidth_tx2148w(0) AND wire_w_lg_rpma_doublewidth_tx2149w(0)) AND (NOT rprbs_sel(0))) AND (NOT rprbs_sel(1))) AND (NOT rprbs_sel(2)));
	nlll1O <= (((wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll2157w2180w2181w2182w(0) AND wire_nl_w_lg_nlOl0O2183w(0)) AND wire_nl_w_lg_nlOl0l2185w(0)) AND wire_nl_w_lg_nlOl0i2187w(0));
	nllllO <= '1';
	prbs_out <= ( nlOl1O & nlOl1l & nlOl1i & nlOiOO & nlOiOl & nlOiOi & nlOilO & nlOill & nlOili & nlOiiO & nlOiil & nlOiii & nlOi0O & nlOi0l & nlOi0i & nlOi1O & nlOi1l & nlOi1i & nlO0OO & nlO0Ol);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll00l33 <= nll00l34;
		END IF;
		if (now = 0 ns) then
			nll00l33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll00l34 <= nll00l33;
		END IF;
	END PROCESS;
	wire_nll00l34_w_lg_w_lg_q141w142w(0) <= NOT wire_nll00l34_w_lg_q141w(0);
	wire_nll00l34_w_lg_q141w(0) <= nll00l34 XOR nll00l33;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll01i37 <= nll01i38;
		END IF;
		if (now = 0 ns) then
			nll01i37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll01i38 <= nll01i37;
		END IF;
	END PROCESS;
	wire_nll01i38_w_lg_w_lg_q152w153w(0) <= NOT wire_nll01i38_w_lg_q152w(0);
	wire_nll01i38_w_lg_q152w(0) <= nll01i38 XOR nll01i37;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll01O35 <= nll01O36;
		END IF;
		if (now = 0 ns) then
			nll01O35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll01O36 <= nll01O35;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll0ii31 <= nll0ii32;
		END IF;
		if (now = 0 ns) then
			nll0ii31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll0ii32 <= nll0ii31;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll0iO29 <= nll0iO30;
		END IF;
		if (now = 0 ns) then
			nll0iO29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll0iO30 <= nll0iO29;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll0Ol27 <= nll0Ol28;
		END IF;
		if (now = 0 ns) then
			nll0Ol27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll0Ol28 <= nll0Ol27;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1ii45 <= nll1ii46;
		END IF;
		if (now = 0 ns) then
			nll1ii45 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1ii46 <= nll1ii45;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1li43 <= nll1li44;
		END IF;
		if (now = 0 ns) then
			nll1li43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1li44 <= nll1li43;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1lO41 <= nll1lO42;
		END IF;
		if (now = 0 ns) then
			nll1lO41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1lO42 <= nll1lO41;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1Ol39 <= nll1Ol40;
		END IF;
		if (now = 0 ns) then
			nll1Ol39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nll1Ol40 <= nll1Ol39;
		END IF;
	END PROCESS;
	wire_nll1Ol40_w_lg_w_lg_q157w158w(0) <= NOT wire_nll1Ol40_w_lg_q157w(0);
	wire_nll1Ol40_w_lg_q157w(0) <= nll1Ol40 XOR nll1Ol39;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlli0l23 <= nlli0l24;
		END IF;
		if (now = 0 ns) then
			nlli0l23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlli0l24 <= nlli0l23;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlli1O25 <= nlli1O26;
		END IF;
		if (now = 0 ns) then
			nlli1O25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlli1O26 <= nlli1O25;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlliil21 <= nlliil22;
		END IF;
		if (now = 0 ns) then
			nlliil21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlliil22 <= nlliil21;
		END IF;
	END PROCESS;
	wire_nlliil22_w_lg_w_lg_q93w94w(0) <= wire_nlliil22_w_lg_q93w(0) AND nlil;
	wire_nlliil22_w_lg_q93w(0) <= nlliil22 XOR nlliil21;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlliiO19 <= nlliiO20;
		END IF;
		if (now = 0 ns) then
			nlliiO19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlliiO20 <= nlliiO19;
		END IF;
	END PROCESS;
	wire_nlliiO20_w_lg_w_lg_q88w89w(0) <= wire_nlliiO20_w_lg_q88w(0) AND nlliOO;
	wire_nlliiO20_w_lg_q88w(0) <= nlliiO20 XOR nlliiO19;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nllill17 <= nllill18;
		END IF;
		if (now = 0 ns) then
			nllill17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nllill18 <= nllill17;
		END IF;
	END PROCESS;
	wire_nllill18_w_lg_w_lg_q79w80w(0) <= wire_nllill18_w_lg_q79w(0) AND nlil;
	wire_nllill18_w_lg_q79w(0) <= nllill18 XOR nllill17;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlliOi15 <= nlliOi16;
		END IF;
		if (now = 0 ns) then
			nlliOi15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlliOi16 <= nlliOi15;
		END IF;
	END PROCESS;
	wire_nlliOi16_w_lg_w_lg_q69w70w(0) <= wire_nlliOi16_w_lg_q69w(0) AND nilO;
	wire_nlliOi16_w_lg_q69w(0) <= nlliOi16 XOR nlliOi15;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlll0O11 <= nlll0O12;
		END IF;
		if (now = 0 ns) then
			nlll0O11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlll0O12 <= nlll0O11;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlll1i13 <= nlll1i14;
		END IF;
		if (now = 0 ns) then
			nlll1i13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlll1i14 <= nlll1i13;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllil10 <= nlllil9;
		END IF;
	END PROCESS;
	wire_nlllil10_w_lg_w_lg_q20w21w(0) <= wire_nlllil10_w_lg_q20w(0) AND n1O;
	wire_nlllil10_w_lg_q20w(0) <= nlllil10 XOR nlllil9;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllil9 <= nlllil10;
		END IF;
		if (now = 0 ns) then
			nlllil9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nllliO7 <= nllliO8;
		END IF;
		if (now = 0 ns) then
			nllliO7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nllliO8 <= nllliO7;
		END IF;
	END PROCESS;
	wire_nllliO8_w_lg_w_lg_q17w18w(0) <= wire_nllliO8_w_lg_q17w(0) AND n1l;
	wire_nllliO8_w_lg_q17w(0) <= nllliO8 XOR nllliO7;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllli5 <= nlllli6;
		END IF;
		if (now = 0 ns) then
			nlllli5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllli6 <= nlllli5;
		END IF;
	END PROCESS;
	wire_nlllli6_w_lg_w_lg_q12w13w(0) <= wire_nlllli6_w_lg_q12w(0) AND nlOl;
	wire_nlllli6_w_lg_q12w(0) <= nlllli6 XOR nlllli5;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllll3 <= nlllll4;
		END IF;
		if (now = 0 ns) then
			nlllll3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllll4 <= nlllll3;
		END IF;
	END PROCESS;
	wire_nlllll4_w_lg_w_lg_q7w8w(0) <= wire_nlllll4_w_lg_q7w(0) AND nlll;
	wire_nlllll4_w_lg_q7w(0) <= nlllll4 XOR nlllll3;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllOl1 <= nlllOl2;
		END IF;
		if (now = 0 ns) then
			nlllOl1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nlllOl2 <= nlllOl1;
		END IF;
	END PROCESS;
	PROCESS (tx_clk, wire_ni0l_PRN, soft_reset)
	BEGIN
		IF (wire_ni0l_PRN = '0') THEN
				ni0O <= '1';
				nlO0Ol <= '1';
				nlO0OO <= '1';
				nlOi0i <= '1';
				nlOi0l <= '1';
				nlOi0O <= '1';
				nlOi1i <= '1';
				nlOi1l <= '1';
				nlOi1O <= '1';
				nlOiii <= '1';
				nlOiil <= '1';
				nlOiiO <= '1';
				nlOili <= '1';
				nlOill <= '1';
				nlOilO <= '1';
				nlOiOi <= '1';
				nlOiOl <= '1';
				nlOiOO <= '1';
				nlOl1i <= '1';
				nlOl1l <= '1';
				nlOl1O <= '1';
		ELSIF (soft_reset = '1') THEN
				ni0O <= '0';
				nlO0Ol <= '0';
				nlO0OO <= '0';
				nlOi0i <= '0';
				nlOi0l <= '0';
				nlOi0O <= '0';
				nlOi1i <= '0';
				nlOi1l <= '0';
				nlOi1O <= '0';
				nlOiii <= '0';
				nlOiil <= '0';
				nlOiiO <= '0';
				nlOili <= '0';
				nlOill <= '0';
				nlOilO <= '0';
				nlOiOi <= '0';
				nlOiOl <= '0';
				nlOiOO <= '0';
				nlOl1i <= '0';
				nlOl1l <= '0';
				nlOl1O <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (nlliii = '0') THEN
				ni0O <= wire_n100O_dataout;
				nlO0Ol <= wire_n10ii_dataout;
				nlO0OO <= wire_n10il_dataout;
				nlOi0i <= wire_n10lO_dataout;
				nlOi0l <= wire_n10Oi_dataout;
				nlOi0O <= wire_n10Ol_dataout;
				nlOi1i <= wire_n10iO_dataout;
				nlOi1l <= wire_n10li_dataout;
				nlOi1O <= wire_n10ll_dataout;
				nlOiii <= wire_n10OO_dataout;
				nlOiil <= wire_n1i1i_dataout;
				nlOiiO <= wire_n1i1l_dataout;
				nlOili <= wire_n1i1O_dataout;
				nlOill <= wire_n1i0i_dataout;
				nlOilO <= wire_n1i0l_dataout;
				nlOiOi <= wire_n1i0O_dataout;
				nlOiOl <= wire_n1iii_dataout;
				nlOiOO <= wire_n1iil_dataout;
				nlOl1i <= wire_n1iiO_dataout;
				nlOl1l <= wire_n1ili_dataout;
				nlOl1O <= wire_n1ill_dataout;
			END IF;
		END IF;
	END PROCESS;
	wire_ni0l_PRN <= (nlli1O26 XOR nlli1O25);
	wire_ni0l_w_lg_ni0O182w(0) <= NOT ni0O;
	PROCESS (tx_clk, wire_nl_CLRN)
	BEGIN
		IF (wire_nl_CLRN = '0') THEN
				n0i <= '0';
				n1i <= '0';
				n1l <= '0';
				n1O <= '0';
				nili <= '0';
				nill <= '0';
				nlll <= '0';
				nllO <= '0';
				nlOi <= '0';
				nlOl <= '0';
				nlOl0i <= '0';
				nlOl0l <= '0';
				nlOl0O <= '0';
				nlOlii <= '0';
				nlOlil <= '0';
				nlOliO <= '0';
				nlOlli <= '0';
				nlOlll <= '0';
				nlOllO <= '0';
				nlOlOi <= '0';
				nlOlOl <= '0';
				nlOlOO <= '0';
				nlOO <= '0';
				nlOO0i <= '0';
				nlOO0l <= '0';
				nlOO0O <= '0';
				nlOO1i <= '0';
				nlOO1l <= '0';
				nlOO1O <= '0';
				nlOOii <= '0';
				nlOOil <= '0';
				nlOOiO <= '0';
				nlOOli <= '0';
				nlOOll <= '0';
				nlOOlO <= '0';
				nO <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				n0i <= nO;
				n1i <= wire_nli_dataout;
				n1l <= wire_nll_dataout;
				n1O <= wire_nlO_dataout;
				nili <= nill;
				nill <= rprbs_en_tx;
				nlll <= wire_n0l_dataout;
				nllO <= wire_n0O_dataout;
				nlOi <= wire_nii_dataout;
				nlOl <= wire_nil_dataout;
				nlOl0i <= wire_nlOOOi_dataout;
				nlOl0l <= wire_nlOOOl_dataout;
				nlOl0O <= wire_nlOOOO_dataout;
				nlOlii <= wire_n111i_dataout;
				nlOlil <= wire_n111l_dataout;
				nlOliO <= wire_n111O_dataout;
				nlOlli <= wire_n110i_dataout;
				nlOlll <= wire_n110l_dataout;
				nlOllO <= wire_n110O_dataout;
				nlOlOi <= wire_n11ii_dataout;
				nlOlOl <= wire_n11il_dataout;
				nlOlOO <= wire_n11iO_dataout;
				nlOO <= wire_niO_dataout;
				nlOO0i <= wire_n11Oi_dataout;
				nlOO0l <= wire_n11Ol_dataout;
				nlOO0O <= wire_n11OO_dataout;
				nlOO1i <= wire_n11li_dataout;
				nlOO1l <= wire_n11ll_dataout;
				nlOO1O <= wire_n11lO_dataout;
				nlOOii <= wire_n101i_dataout;
				nlOOil <= wire_n101l_dataout;
				nlOOiO <= wire_n101O_dataout;
				nlOOli <= wire_n100i_dataout;
				nlOOll <= wire_n100l_dataout;
				nlOOlO <= nili;
				nO <= cid_en;
		END IF;
	END PROCESS;
	wire_nl_CLRN <= ((nlllOl2 XOR nlllOl1) AND wire_w_lg_soft_reset2w(0));
	wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll2157w2180w2181w2182w(0) <= wire_nl_w_lg_w_lg_w_lg_nlOlll2157w2180w2181w(0) AND nlOlii;
	wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll2189w2190w2191w2192w(0) <= wire_nl_w_lg_w_lg_w_lg_nlOlll2189w2190w2191w(0) AND nlOlil;
	wire_nl_w_lg_w_lg_w_lg_nlOlll2157w2180w2181w(0) <= wire_nl_w_lg_w_lg_nlOlll2157w2180w(0) AND nlOlil;
	wire_nl_w_lg_w_lg_w_lg_nlOlll2189w2190w2191w(0) <= wire_nl_w_lg_w_lg_nlOlll2189w2190w(0) AND wire_nl_w_lg_nlOliO2179w(0);
	wire_nl_w_lg_w_lg_n0i61w62w(0) <= wire_nl_w_lg_n0i61w(0) AND nlll1O;
	wire_nl_w_lg_w_lg_nlOlll2157w2180w(0) <= wire_nl_w_lg_nlOlll2157w(0) AND wire_nl_w_lg_nlOliO2179w(0);
	wire_nl_w_lg_w_lg_nlOlll2189w2190w(0) <= wire_nl_w_lg_nlOlll2189w(0) AND nlOlli;
	wire_nl_w_lg_n0i61w(0) <= n0i AND wire_w_lg_nlll0i60w(0);
	wire_nl_w_lg_nlOlll2157w(0) <= nlOlll AND nlOlli;
	wire_nl_w_lg_n1i2167w(0) <= NOT n1i;
	wire_nl_w_lg_n1l2165w(0) <= NOT n1l;
	wire_nl_w_lg_n1O2164w(0) <= NOT n1O;
	wire_nl_w_lg_nlll2177w(0) <= NOT nlll;
	wire_nl_w_lg_nllO2175w(0) <= NOT nllO;
	wire_nl_w_lg_nlOi2173w(0) <= NOT nlOi;
	wire_nl_w_lg_nlOl0i2187w(0) <= NOT nlOl0i;
	wire_nl_w_lg_nlOl0l2185w(0) <= NOT nlOl0l;
	wire_nl_w_lg_nlOl0O2183w(0) <= NOT nlOl0O;
	wire_nl_w_lg_nlOl2171w(0) <= NOT nlOl;
	wire_nl_w_lg_nlOlii2193w(0) <= NOT nlOlii;
	wire_nl_w_lg_nlOliO2179w(0) <= NOT nlOliO;
	wire_nl_w_lg_nlOlll2189w(0) <= NOT nlOlll;
	wire_nl_w_lg_nlOO2169w(0) <= NOT nlOO;
	wire_nl_w_lg_nlOOlO103w(0) <= NOT nlOOlO;
	wire_nl_w_lg_w144w145w(0) <= wire_nl_w144w(0) XOR nlOl0i;
	wire_nl_w144w(0) <= wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll137w138w139w143w(0) XOR nlOl0O;
	wire_nl_w_lg_w_lg_w_lg_w_lg_nlOlll137w138w139w143w(0) <= wire_nl_w_lg_w_lg_w_lg_nlOlll137w138w139w(0) XOR wire_nll00l34_w_lg_w_lg_q141w142w(0);
	wire_nl_w_lg_w_lg_w_lg_nlOlll137w138w139w(0) <= wire_nl_w_lg_w_lg_nlOlll137w138w(0) XOR nlOlii;
	wire_nl_w_lg_w_lg_nlOlll1321w1322w(0) <= wire_nl_w_lg_nlOlll1321w(0) XOR nlOl0O;
	wire_nl_w_lg_w_lg_nlOlll137w138w(0) <= wire_nl_w_lg_nlOlll137w(0) XOR nlOlil;
	wire_nl_w_lg_w_lg_nlOO0i869w870w(0) <= wire_nl_w_lg_nlOO0i869w(0) XOR nlOlOl;
	wire_nl_w_lg_w_lg_nlOO0l1760w1761w(0) <= wire_nl_w_lg_nlOO0l1760w(0) XOR nlOOli;
	wire_nl_w_lg_w_lg_nlOO0O1692w1693w(0) <= wire_nl_w_lg_nlOO0O1692w(0) XOR nlOOll;
	wire_nl_w_lg_w_lg_nlOO1O939w940w(0) <= wire_nl_w_lg_nlOO1O939w(0) XOR nlOlOi;
	wire_nl_w_lg_w_lg_nlOOii955w956w(0) <= wire_nl_w_lg_nlOOii955w(0) XOR nlOO1l;
	wire_nl_w_lg_w_lg_nlOOil885w886w(0) <= wire_nl_w_lg_nlOOil885w(0) XOR nlOO1O;
	wire_nl_w_lg_nlOl0O1719w(0) <= nlOl0O XOR nlOl0l;
	wire_nl_w_lg_nlOlii1254w(0) <= nlOlii XOR nlOl0l;
	wire_nl_w_lg_nlOlii1651w(0) <= nlOlii XOR nlOl0O;
	wire_nl_w_lg_nlOliO1625w(0) <= nlOliO XOR nlOl0i;
	wire_nl_w_lg_nlOlli1560w(0) <= nlOlli XOR nlOl0l;
	wire_nl_w_lg_nlOlli1530w(0) <= nlOlli XOR nlOlii;
	wire_nl_w_lg_nlOlll1321w(0) <= nlOlll XOR nlOl0l;
	wire_nl_w_lg_nlOlll1465w(0) <= nlOlll XOR nlOlil;
	wire_nl_w_lg_nlOlll137w(0) <= nlOlll XOR nlOliO;
	wire_nl_w_lg_nlOllO1400w(0) <= nlOllO XOR nlOliO;
	wire_nl_w_lg_nlOlOi1333w(0) <= nlOlOi XOR nlOlli;
	wire_nl_w_lg_nlOlOl1744w(0) <= nlOlOl XOR nlOlOi;
	wire_nl_w_lg_nlOlOO1280w(0) <= nlOlOO XOR nlOlOi;
	wire_nl_w_lg_nlOlOO1676w(0) <= nlOlOO XOR nlOlOl;
	wire_nl_w_lg_nlOO0i869w(0) <= nlOO0i XOR nlOlOO;
	wire_nl_w_lg_nlOO0l1760w(0) <= nlOO0l XOR nlOlii;
	wire_nl_w_lg_nlOO0l1227w(0) <= nlOO0l XOR nlOO1O;
	wire_nl_w_lg_nlOO0O1692w(0) <= nlOO0O XOR nlOlil;
	wire_nl_w_lg_nlOO0O1159w(0) <= nlOO0O XOR nlOO0i;
	wire_nl_w_lg_nlOO1i1212w(0) <= nlOO1i XOR nlOlOl;
	wire_nl_w_lg_nlOO1l1144w(0) <= nlOO1l XOR nlOlOO;
	wire_nl_w_lg_nlOO1O939w(0) <= nlOO1O XOR nlOlOl;
	wire_nl_w_lg_nlOO1O1076w(0) <= nlOO1O XOR nlOO1i;
	wire_nl_w_lg_nlOOii1091w(0) <= nlOOii XOR nlOO0l;
	wire_nl_w_lg_nlOOii955w(0) <= nlOOii XOR nlOO1O;
	wire_nl_w_lg_nlOOil885w(0) <= nlOOil XOR nlOO0i;
	wire_nl_w_lg_nlOOil1023w(0) <= nlOOil XOR nlOO0O;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nilO <= '0';
				nlil <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (nlll0l = '1') THEN
				nilO <= wire_niOO_o;
				nlil <= wire_nl1i_o;
			END IF;
		END IF;
	END PROCESS;
	PROCESS (tx_clk, wire_nliO_PRN)
	BEGIN
		IF (wire_nliO_PRN = '0') THEN
				nlli <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (nlll0l = '1') THEN
				nlli <= wire_nl1l_o;
			END IF;
		END IF;
	END PROCESS;
	wire_nliO_PRN <= ((nlll0O12 XOR nlll0O11) AND wire_w_lg_soft_reset2w(0));
	wire_n0l_dataout <= wire_ni_o(1) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(0);
	wire_n0O_dataout <= wire_ni_o(2) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(1);
	wire_n100i_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1O1O_dataout;
	wire_n100l_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1O0i_dataout;
	wire_n100O_dataout <= wire_n1O0l_dataout WHEN nlOOlO = '1'  ELSE ni0O;
	wire_n101i_dataout <= (NOT (wire_n00ii_o(16) OR wire_n00ii_o(2))) WHEN nlliii = '1'  ELSE wire_n1lOO_dataout;
	wire_n101l_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1O1i_dataout;
	wire_n101O_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1O1l_dataout;
	wire_n10i_dataout <= nlOO0i AND nlli1l;
	wire_n10ii_dataout <= wire_n1O0O_o WHEN nlOOlO = '1'  ELSE nlO0Ol;
	wire_n10il_dataout <= wire_n1Oii_o WHEN nlOOlO = '1'  ELSE nlO0OO;
	wire_n10iO_dataout <= wire_n1Oil_o WHEN nlOOlO = '1'  ELSE nlOi1i;
	wire_n10l_dataout <= nlOO0l AND nlli1l;
	wire_n10li_dataout <= wire_n1OiO_o WHEN nlOOlO = '1'  ELSE nlOi1l;
	wire_n10ll_dataout <= wire_n1Oli_o WHEN nlOOlO = '1'  ELSE nlOi1O;
	wire_n10lO_dataout <= wire_n1Oll_o WHEN nlOOlO = '1'  ELSE nlOi0i;
	wire_n10O_dataout <= nlOO0O AND nlli1l;
	wire_n10Oi_dataout <= wire_n1OlO_o WHEN nlOOlO = '1'  ELSE nlOi0l;
	wire_n10Ol_dataout <= wire_n1OOi_o WHEN nlOOlO = '1'  ELSE nlOi0O;
	wire_n10OO_dataout <= wire_n011i_o WHEN nlOOlO = '1'  ELSE nlOiii;
	wire_n110i_dataout <= wire_n1l1O_dataout OR nlliii;
	wire_n110l_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1l0i_dataout;
	wire_n110O_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1l0l_dataout;
	wire_n111i_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1iOO_dataout;
	wire_n111l_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1l1i_dataout;
	wire_n111O_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1l1l_dataout;
	wire_n11i_dataout <= nlOO1i AND nlli1l;
	wire_n11ii_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1l0O_dataout;
	wire_n11il_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1lii_dataout;
	wire_n11iO_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1lil_dataout;
	wire_n11l_dataout <= nlOO1l AND nlli1l;
	wire_n11li_dataout <= (NOT wire_n00ii_o(2)) WHEN nlliii = '1'  ELSE wire_n1liO_dataout;
	wire_n11ll_dataout <= (NOT wire_n00ii_o(2)) WHEN nlliii = '1'  ELSE wire_n1lli_dataout;
	wire_n11lO_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1lll_dataout;
	wire_n11O_dataout <= nlOO1O AND nlli1l;
	wire_n11Oi_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1llO_dataout;
	wire_n11Ol_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1lOi_dataout;
	wire_n11OO_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1lOl_dataout;
	wire_n1i0i_dataout <= wire_n010O_o WHEN nlOOlO = '1'  ELSE nlOill;
	wire_n1i0l_dataout <= wire_n01iO_o WHEN nlOOlO = '1'  ELSE nlOilO;
	wire_n1i0O_dataout <= wire_n01ll_o WHEN nlOOlO = '1'  ELSE nlOiOi;
	wire_n1i1i_dataout <= wire_n011l_o WHEN nlOOlO = '1'  ELSE nlOiil;
	wire_n1i1l_dataout <= wire_n011O_o WHEN nlOOlO = '1'  ELSE nlOiiO;
	wire_n1i1O_dataout <= wire_n010i_o WHEN nlOOlO = '1'  ELSE nlOili;
	wire_n1ii_dataout <= nlOOii AND nlli1l;
	wire_n1iii_dataout <= wire_n01lO_o WHEN nlOOlO = '1'  ELSE nlOiOl;
	wire_n1iil_dataout <= wire_n01Oi_o WHEN nlOOlO = '1'  ELSE nlOiOO;
	wire_n1iiO_dataout <= wire_n01Ol_o WHEN nlOOlO = '1'  ELSE nlOl1i;
	wire_n1il_dataout <= nlOOil AND nlli1l;
	wire_n1ili_dataout <= wire_n001O_o WHEN nlOOlO = '1'  ELSE nlOl1l;
	wire_n1ill_dataout <= wire_n000i_o WHEN nlOOlO = '1'  ELSE nlOl1O;
	wire_n1ilO_dataout <= wire_n00il_o WHEN nlOOlO = '1'  ELSE nlOl0i;
	wire_n1iO_dataout <= nlOOiO AND nlli1l;
	wire_n1iOi_dataout <= wire_n00iO_o WHEN nlOOlO = '1'  ELSE nlOl0l;
	wire_n1iOl_dataout <= wire_n00li_o WHEN nlOOlO = '1'  ELSE nlOl0O;
	wire_n1iOO_dataout <= wire_n00ll_o WHEN nlOOlO = '1'  ELSE nlOlii;
	wire_n1l0i_dataout <= wire_n00OO_o WHEN nlOOlO = '1'  ELSE nlOlll;
	wire_n1l0l_dataout <= wire_n0i1i_o WHEN nlOOlO = '1'  ELSE nlOllO;
	wire_n1l0O_dataout <= wire_n0i1l_o WHEN nlOOlO = '1'  ELSE nlOlOi;
	wire_n1l1i_dataout <= wire_n00lO_o WHEN nlOOlO = '1'  ELSE nlOlil;
	wire_n1l1l_dataout <= wire_n00Oi_o WHEN nlOOlO = '1'  ELSE nlOliO;
	wire_n1l1O_dataout <= wire_n00Ol_o WHEN nlOOlO = '1'  ELSE nlOlli;
	wire_n1li_dataout <= nlOOli AND nlli1l;
	wire_n1lii_dataout <= wire_n0i1O_o WHEN nlOOlO = '1'  ELSE nlOlOl;
	wire_n1lil_dataout <= wire_n0i0i_o WHEN nlOOlO = '1'  ELSE nlOlOO;
	wire_n1liO_dataout <= wire_n0i0l_o WHEN nlOOlO = '1'  ELSE nlOO1i;
	wire_n1ll_dataout <= nlOOll AND nlli1l;
	wire_n1lli_dataout <= wire_n0i0O_o WHEN nlOOlO = '1'  ELSE nlOO1l;
	wire_n1lll_dataout <= wire_n0iii_o WHEN nlOOlO = '1'  ELSE nlOO1O;
	wire_n1llO_dataout <= wire_n0iil_o WHEN nlOOlO = '1'  ELSE nlOO0i;
	wire_n1lOi_dataout <= wire_n0iiO_o WHEN nlOOlO = '1'  ELSE nlOO0l;
	wire_n1lOl_dataout <= wire_n0ili_o WHEN nlOOlO = '1'  ELSE nlOO0O;
	wire_n1lOO_dataout <= wire_n0ill_o WHEN nlOOlO = '1'  ELSE nlOOii;
	wire_n1O0i_dataout <= wire_n0iOO_o WHEN nlOOlO = '1'  ELSE nlOOll;
	wire_n1O0l_dataout <= wire_ni0l_w_lg_ni0O182w(0) WHEN wire_n00ii_o(11) = '1'  ELSE ni0O;
	wire_n1O1i_dataout <= wire_n0ilO_o WHEN nlOOlO = '1'  ELSE nlOOil;
	wire_n1O1l_dataout <= wire_n0iOi_o WHEN nlOOlO = '1'  ELSE nlOOiO;
	wire_n1O1O_dataout <= wire_n0iOl_o WHEN nlOOlO = '1'  ELSE nlOOli;
	wire_nii_dataout <= wire_ni_o(3) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(2);
	wire_niiil_dataout <= wire_niO1i_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_niiiO_dataout <= wire_niO1l_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_niili_dataout <= wire_niO1O_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_niill_dataout <= wire_niO0i_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_niilO_dataout <= wire_niO0l_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_niiOi_dataout <= wire_niO0O_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_niiOl_dataout <= wire_niOii_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_niiOO_dataout <= wire_niOil_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nil_dataout <= wire_ni_o(4) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(3);
	wire_nil0i_dataout <= wire_niOlO_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nil0l_dataout <= wire_niOOi_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nil0O_dataout <= wire_niOOl_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nil1i_dataout <= wire_niOiO_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_nil1l_dataout <= wire_niOli_dataout OR wire_ni0l_w_lg_ni0O182w(0);
	wire_nil1O_dataout <= wire_niOll_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nilii_dataout <= wire_niOOO_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nilil_dataout <= wire_nl11i_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_niliO_dataout <= wire_nl11l_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nilli_dataout <= wire_nl11O_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nilll_dataout <= wire_nl10i_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nillO_dataout <= wire_nl10l_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nilOi_dataout <= wire_nl10O_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nilOl_dataout <= wire_nl1ii_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_nilOO_dataout <= wire_nl1il_dataout AND NOT(wire_ni0l_w_lg_ni0O182w(0));
	wire_niO_dataout <= wire_ni_o(5) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(4);
	wire_niO0i_dataout <= nlOlii AND NOT(ni0O);
	wire_niO0l_dataout <= nlOlil AND NOT(ni0O);
	wire_niO0O_dataout <= nlOliO OR ni0O;
	wire_niO1i_dataout <= nlOl0i AND NOT(ni0O);
	wire_niO1l_dataout <= nlOl0l AND NOT(ni0O);
	wire_niO1O_dataout <= nlOl0O AND NOT(ni0O);
	wire_niOi_dataout <= nlil AND nlll0l;
	wire_niOii_dataout <= nlOlli AND NOT(ni0O);
	wire_niOil_dataout <= nlOlll OR ni0O;
	wire_niOiO_dataout <= nlOllO AND NOT(ni0O);
	wire_niOl_dataout <= nlli AND nlll0l;
	wire_niOli_dataout <= nlOlOi AND NOT(ni0O);
	wire_niOll_dataout <= nlOlOl AND NOT(ni0O);
	wire_niOlO_dataout <= nlOlOO AND NOT(ni0O);
	wire_niOOi_dataout <= nlOO1i AND NOT(ni0O);
	wire_niOOl_dataout <= nlOO1l AND NOT(ni0O);
	wire_niOOO_dataout <= nlOO1O AND NOT(ni0O);
	wire_nl0i_dataout <= nlliOl AND NOT(nlliOO);
	wire_nl0iO_dataout <= wire_nliOl_dataout AND NOT(wire_niOl_dataout);
	wire_nl0li_dataout <= wire_nliOO_dataout OR wire_niOl_dataout;
	wire_nl0ll_dataout <= wire_nll1i_dataout AND NOT(wire_niOl_dataout);
	wire_nl0lO_dataout <= wire_nll1l_dataout OR wire_niOl_dataout;
	wire_nl0Oi_dataout <= wire_nll1O_dataout OR wire_niOl_dataout;
	wire_nl0Ol_dataout <= wire_nll0i_dataout AND NOT(wire_niOl_dataout);
	wire_nl0OO_dataout <= wire_nll0l_dataout OR wire_niOl_dataout;
	wire_nl10i_dataout <= nlOOii AND NOT(ni0O);
	wire_nl10l_dataout <= nlOOil AND NOT(ni0O);
	wire_nl10O_dataout <= nlOOiO AND NOT(ni0O);
	wire_nl11i_dataout <= nlOO0i AND NOT(ni0O);
	wire_nl11l_dataout <= nlOO0l AND NOT(ni0O);
	wire_nl11O_dataout <= nlOO0O AND NOT(ni0O);
	wire_nl1ii_dataout <= nlOOli AND NOT(ni0O);
	wire_nl1il_dataout <= nlOOll AND NOT(ni0O);
	wire_nl1O_dataout <= wire_w_lg_nlliOl66w(0) AND NOT(nlliOO);
	wire_nli_dataout <= wire_ni_o(6) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(5);
	wire_nli0i_dataout <= wire_nlliO_dataout AND NOT(wire_niOl_dataout);
	wire_nli0l_dataout <= wire_nllli_dataout AND NOT(wire_niOl_dataout);
	wire_nli0O_dataout <= wire_nllll_dataout AND NOT(wire_niOl_dataout);
	wire_nli1i_dataout <= wire_nll0O_dataout AND NOT(wire_niOl_dataout);
	wire_nli1l_dataout <= wire_nllii_dataout AND NOT(wire_niOl_dataout);
	wire_nli1O_dataout <= wire_nllil_dataout AND NOT(wire_niOl_dataout);
	wire_nliii_dataout <= wire_nlllO_dataout AND NOT(wire_niOl_dataout);
	wire_nliil_dataout <= wire_nllOi_dataout AND NOT(wire_niOl_dataout);
	wire_nliiO_dataout <= wire_nllOl_dataout AND NOT(wire_niOl_dataout);
	wire_nlili_dataout <= wire_nllOO_dataout AND NOT(wire_niOl_dataout);
	wire_nlill_dataout <= wire_nlO1i_dataout AND NOT(wire_niOl_dataout);
	wire_nlilO_dataout <= wire_nlO1l_dataout AND NOT(wire_niOl_dataout);
	wire_nliOi_dataout <= wire_nlO1O_dataout AND NOT(wire_niOl_dataout);
	wire_nliOl_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOl0i;
	wire_nliOO_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOl0l;
	wire_nll_dataout <= wire_ni_o(7) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(6);
	wire_nll0i_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOliO;
	wire_nll0l_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOlli;
	wire_nll0O_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOlll;
	wire_nll1i_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOl0O;
	wire_nll1l_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOlii;
	wire_nll1O_dataout <= rcid_pattern WHEN wire_niOi_dataout = '1'  ELSE nlOlil;
	wire_nllii_dataout <= nlOllO AND NOT(wire_niOi_dataout);
	wire_nllil_dataout <= nlOlOi AND NOT(wire_niOi_dataout);
	wire_nlliO_dataout <= nlOlOl AND NOT(wire_niOi_dataout);
	wire_nllli_dataout <= nlOlOO AND NOT(wire_niOi_dataout);
	wire_nllll_dataout <= nlOO1i AND NOT(wire_niOi_dataout);
	wire_nlllO_dataout <= nlOO1l AND NOT(wire_niOi_dataout);
	wire_nllOi_dataout <= nlOO1O AND NOT(wire_niOi_dataout);
	wire_nllOl_dataout <= nlOO0i AND NOT(wire_niOi_dataout);
	wire_nllOO_dataout <= nlOO0l AND NOT(wire_niOi_dataout);
	wire_nlO_dataout <= wire_ni_o(8) WHEN wire_niOi_dataout = '1'  ELSE rcid_len(7);
	wire_nlO0i_dataout <= nlOl0i WHEN nlli1l = '1'  ELSE ((nll0Oi XOR nlOl0l) XOR nlOl0i);
	wire_nlO0l_dataout <= nlOl0l WHEN nlli1l = '1'  ELSE ((nlli1i XOR nlOl0O) XOR nlOl0l);
	wire_nlO0O_dataout <= nlOl0O WHEN nlli1l = '1'  ELSE (wire_w_lg_w_lg_w160w161w162w(0) XOR (NOT (nll1lO42 XOR nll1lO41)));
	wire_nlO1i_dataout <= nlOO0O AND NOT(wire_niOi_dataout);
	wire_nlO1l_dataout <= nlOOii AND NOT(wire_niOi_dataout);
	wire_nlO1O_dataout <= nlOOil AND NOT(wire_niOi_dataout);
	wire_nlOii_dataout <= nlOlii WHEN nlli1l = '1'  ELSE (wire_nl_w_lg_w144w145w(0) XOR (NOT (nll01O36 XOR nll01O35)));
	wire_nlOil_dataout <= nlOlil WHEN nlli1l = '1'  ELSE (nll0ll XOR nlOl0i);
	wire_nlOiO_dataout <= nlOliO WHEN nlli1l = '1'  ELSE (nll0lO XOR nlOl0l);
	wire_nlOli_dataout <= nlOlli WHEN nlli1l = '1'  ELSE ((nll0Oi XOR nlOl0O) XOR (NOT (nll0ii32 XOR nll0ii31)));
	wire_nlOll_dataout <= nlOlll WHEN nlli1l = '1'  ELSE ((nlli1i XOR nlOlii) XOR (NOT (nll0iO30 XOR nll0iO29)));
	wire_nlOlO_dataout <= nlOllO AND nlli1l;
	wire_nlOOi_dataout <= nlOlOi AND nlli1l;
	wire_nlOOl_dataout <= nlOlOl AND nlli1l;
	wire_nlOOO_dataout <= nlOlOO AND nlli1l;
	wire_nlOOOi_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1ilO_dataout;
	wire_nlOOOl_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1iOi_dataout;
	wire_nlOOOO_dataout <= wire_w_lg_nlli0i2123w(0) WHEN nlliii = '1'  ELSE wire_n1iOl_dataout;
	wire_ni_a <= ( wire_nlllil10_w_lg_w_lg_q20w21w & wire_nllliO8_w_lg_w_lg_q17w18w & n1i & nlOO & wire_nlllli6_w_lg_w_lg_q12w13w & nlOi & nllO & wire_nlllll4_w_lg_w_lg_q7w8w & "1");
	wire_ni_b <= ( "1" & "1" & "1" & "1" & "1" & "1" & "1" & "0" & "1");
	ni :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 9,
		width_b => 9,
		width_o => 9
	  )
	  PORT MAP ( 
		a => wire_ni_a,
		b => wire_ni_b,
		cin => wire_gnd,
		o => wire_ni_o
	  );
	wire_n00ii_w_lg_w_lg_w_o_range106w1878w1941w(0) <= wire_n00ii_w_lg_w_o_range106w1878w(0) OR wire_n00ii_w_o_range1798w(0);
	wire_n00ii_w_lg_w_lg_w_o_range106w1961w1962w(0) <= wire_n00ii_w_lg_w_o_range106w1961w(0) OR wire_n00ii_w_o_range1824w(0);
	wire_n00ii_w_lg_w_o_range106w1878w(0) <= wire_n00ii_w_o_range106w(0) OR wire_n00ii_w_o_range1824w(0);
	wire_n00ii_w_lg_w_o_range106w1961w(0) <= wire_n00ii_w_o_range106w(0) OR wire_n00ii_w_o_range1839w(0);
	wire_n00ii_i <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	wire_n00ii_w_o_range106w(0) <= wire_n00ii_o(16);
	wire_n00ii_w_o_range1798w(0) <= wire_n00ii_o(17);
	wire_n00ii_w_o_range1824w(0) <= wire_n00ii_o(18);
	wire_n00ii_w_o_range1839w(0) <= wire_n00ii_o(25);
	n00ii :  oper_decoder
	  GENERIC MAP (
		width_i => 5,
		width_o => 32
	  )
	  PORT MAP ( 
		i => wire_n00ii_i,
		o => wire_n00ii_o
	  );
	wire_n00il_data <= ( "0" & "0" & "0" & "1" & "1" & "1" & wire_nl_w_lg_w_lg_nlOO0l1760w1761w & nliOOO & "0" & "0" & "0" & "0" & "0" & "1" & nliliO & wire_nl_w_lg_nlOlOl1744w & "0" & "0" & "0" & "0" & wire_niiil_dataout & "1" & "1" & nll1iO & "0" & "0" & "0" & nliO1l & "0" & wire_nl_w_lg_nlOl0O1719w & "1" & wire_nlO0i_dataout);
	wire_n00il_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00il :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00il_data,
		o => wire_n00il_o,
		sel => wire_n00il_sel
	  );
	wire_n00iO_data <= ( "0" & "0" & "0" & "1" & "1" & "0" & wire_nl_w_lg_w_lg_nlOO0O1692w1693w & nll11i & "0" & "0" & "0" & "0" & "0" & "0" & nlilli & wire_nl_w_lg_nlOlOO1676w & "0" & "0" & "0" & "0" & wire_niiiO_dataout & "1" & "0" & nll10O & "0" & "0" & "0" & nliO1O & "0" & wire_nl_w_lg_nlOlii1651w & "0" & wire_nlO0l_dataout);
	wire_n00iO_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00iO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00iO_data,
		o => wire_n00iO_o,
		sel => wire_n00iO_sel
	  );
	wire_n00li_data <= ( "0" & "0" & "0" & "1" & "1" & "1" & wire_nl_w_lg_nlOliO1625w & nliOli & "0" & "0" & "0" & "0" & "0" & "1" & nlilll & nll11O & "0" & "0" & "0" & "0" & wire_niili_dataout & "1" & "1" & nll10l & "0" & "0" & "0" & nliO0i & "0" & nll0ll & "1" & wire_nlO0O_dataout);
	wire_n00li_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00li :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00li_data,
		o => wire_n00li_o,
		sel => wire_n00li_sel
	  );
	wire_n00ll_data <= ( "0" & "0" & "0" & "1" & "1" & "0" & wire_nl_w_lg_nlOlli1560w & nliOll & "0" & "0" & "0" & "0" & "0" & "0" & nlillO & nll10i & "0" & "0" & "0" & "0" & wire_niill_dataout & "1" & "0" & wire_nl_w_lg_nlOlli1530w & "0" & "0" & "0" & nliO0l & "0" & nll0lO & "0" & wire_nlOii_dataout);
	wire_n00ll_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00ll :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00ll_data,
		o => wire_n00ll_o,
		sel => wire_n00ll_sel
	  );
	wire_n00lO_data <= ( "0" & "0" & "0" & "1" & "1" & "1" & nliliO & nliOlO & "0" & "0" & "0" & "0" & "0" & "1" & nlilOi & nliOOO & "0" & "0" & "0" & "0" & wire_niilO_dataout & "1" & "1" & wire_nl_w_lg_nlOlll1465w & "0" & "0" & "0" & nliO0O & "0" & nll0Oi & "1" & wire_nlOil_dataout);
	wire_n00lO_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00lO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00lO_data,
		o => wire_n00lO_o,
		sel => wire_n00lO_sel
	  );
	wire_n00Oi_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & nlilli & nliOOl & "0" & "0" & "0" & "0" & "0" & "0" & nlilOl & nll11i & "0" & "0" & "0" & "0" & wire_niiOi_dataout & "0" & "0" & wire_nl_w_lg_nlOllO1400w & "0" & "0" & "0" & nliOii & "0" & nlli1i & "0" & wire_nlOiO_dataout);
	wire_n00Oi_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00Oi :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00Oi_data,
		o => wire_n00Oi_o,
		sel => wire_n00Oi_sel
	  );
	wire_n00Ol_data <= ( "0" & "0" & "0" & "1" & "0" & "1" & nlilll & wire_w_lg_nliO0O1363w & "0" & "0" & "0" & "0" & "0" & "1" & nlilOO & wire_w_lg_nliO1l1348w & "0" & "0" & "0" & "0" & wire_niiOl_dataout & "0" & "1" & wire_nl_w_lg_nlOlOi1333w & "0" & "0" & "0" & nliOil & "0" & wire_nl_w_lg_w_lg_nlOlll1321w1322w & "1" & wire_nlOli_dataout);
	wire_n00Ol_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00Ol :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00Ol_data,
		o => wire_n00Ol_o,
		sel => wire_n00Ol_sel
	  );
	wire_n00OO_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & nlillO & nll11l & "0" & "0" & "0" & "0" & "0" & "0" & nliO1i & wire_nl_w_lg_nlOlOO1280w & "0" & "0" & "0" & "0" & wire_niiOO_dataout & "0" & "0" & wire_w_lg_nll1iO1265w & "0" & "0" & "0" & nliOiO & "0" & wire_nl_w_lg_nlOlii1254w & "0" & wire_nlOll_dataout);
	wire_n00OO_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n00OO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n00OO_data,
		o => wire_n00OO_o,
		sel => wire_n00OO_sel
	  );
	wire_n0i0i_data <= ( "0" & "0" & "0" & "0" & "1" & "0" & nliO1i & wire_nl_w_lg_nlOOil1023w & "0" & "0" & "0" & "0" & "0" & "0" & nliO0l & nll11l & "0" & "0" & "0" & "0" & wire_nil0i_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOlii & "0" & "0" & "0" & wire_nlOOO_dataout);
	wire_n0i0i_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0i0i :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0i0i_data,
		o => wire_n0i0i_o,
		sel => wire_n0i0i_sel
	  );
	wire_n0i0l_data <= ( "0" & "0" & "0" & "0" & "1" & "1" & nliO1l & wire_nl_w_lg_w_lg_nlOOii955w956w & "0" & "0" & "0" & "0" & "0" & "1" & nliO0O & wire_nl_w_lg_w_lg_nlOO1O939w940w & "0" & "0" & "0" & "0" & wire_nil0l_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOlil & "0" & "0" & "0" & wire_n11i_dataout);
	wire_n0i0l_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0i0l :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0i0l_data,
		o => wire_n0i0l_o,
		sel => wire_n0i0l_sel
	  );
	wire_n0i0O_data <= ( "0" & "0" & "0" & "0" & "1" & "0" & nliO1O & wire_nl_w_lg_w_lg_nlOOil885w886w & "0" & "0" & "0" & "0" & "0" & "0" & nliOii & wire_nl_w_lg_w_lg_nlOO0i869w870w & "0" & "0" & "0" & "0" & wire_nil0O_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOliO & "0" & "0" & "0" & wire_n11l_dataout);
	wire_n0i0O_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0i0O :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0i0O_data,
		o => wire_n0i0O_o,
		sel => wire_n0i0O_sel
	  );
	wire_n0i1i_data <= ( "0" & "0" & "0" & "1" & "0" & "1" & nlilOi & wire_nl_w_lg_nlOO0l1227w & "0" & "0" & "0" & "0" & "0" & "1" & nliO1l & wire_nl_w_lg_nlOO1i1212w & "0" & "0" & "0" & "0" & wire_nil1i_dataout & "0" & "1" & wire_w_lg_nll10O1197w & "0" & "0" & "0" & nlOl0i & "0" & "0" & "0" & wire_nlOlO_dataout);
	wire_n0i1i_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0i1i :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0i1i_data,
		o => wire_n0i1i_o,
		sel => wire_n0i1i_sel
	  );
	wire_n0i1l_data <= ( "0" & "0" & "0" & "1" & "0" & "0" & nlilOl & wire_nl_w_lg_nlOO0O1159w & "0" & "0" & "0" & "0" & "0" & "0" & nliO1O & wire_nl_w_lg_nlOO1l1144w & "0" & "0" & "0" & "0" & wire_nil1l_dataout & "0" & "0" & wire_w_lg_nll10l1129w & "0" & "0" & "0" & nlOl0l & "0" & "0" & "0" & wire_nlOOi_dataout);
	wire_n0i1l_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0i1l :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0i1l_data,
		o => wire_n0i1l_o,
		sel => wire_n0i1l_sel
	  );
	wire_n0i1O_data <= ( "0" & "0" & "0" & "0" & "1" & "1" & nlilOO & wire_nl_w_lg_nlOOii1091w & "0" & "0" & "0" & "0" & "0" & "1" & nliO0i & wire_nl_w_lg_nlOO1O1076w & "0" & "0" & "0" & "0" & wire_nil1O_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOl0O & "0" & "0" & "0" & wire_nlOOl_dataout);
	wire_n0i1O_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0i1O :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0i1O_data,
		o => wire_n0i1O_o,
		sel => wire_n0i1O_sel
	  );
	wire_n0iii_data <= ( "0" & "0" & "0" & "0" & "1" & "1" & nliO0i & wire_w_lg_w_lg_nliOli815w816w & "0" & "0" & "0" & "0" & "0" & "1" & nliOil & wire_w_lg_w_lg_nll11O799w800w & "0" & "0" & "0" & "0" & wire_nilii_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOlli & "0" & "0" & "0" & wire_n11O_dataout);
	wire_n0iii_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0iii :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0iii_data,
		o => wire_n0iii_o,
		sel => wire_n0iii_sel
	  );
	wire_n0iil_data <= ( "0" & "0" & "0" & "1" & "0" & "0" & nliO0l & wire_w_lg_w_lg_nliOll745w746w & "0" & "0" & "0" & "0" & "0" & "0" & nliOiO & wire_w_lg_w_lg_nll10i729w730w & "0" & "0" & "0" & "0" & wire_nilil_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOlll & "0" & "0" & "0" & wire_n10i_dataout);
	wire_n0iil_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0iil :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0iil_data,
		o => wire_n0iil_o,
		sel => wire_n0iil_sel
	  );
	wire_n0iiO_data <= ( "0" & "0" & "0" & "0" & "0" & "1" & nliO0O & wire_w_lg_w_lg_nliOlO675w676w & "0" & "0" & "0" & "0" & "0" & "0" & nlOl0i & "0" & "0" & "0" & "0" & "0" & wire_niliO_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOllO & "0" & "0" & "0" & wire_n10l_dataout);
	wire_n0iiO_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0iiO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0iiO_data,
		o => wire_n0iiO_o,
		sel => wire_n0iiO_sel
	  );
	wire_n0ili_data <= ( "0" & "0" & "0" & "1" & "0" & "0" & nliOii & wire_w_lg_nliOOi607w & "0" & "0" & "0" & "0" & "0" & "0" & nlOl0l & "0" & "0" & "0" & "0" & "0" & wire_nilli_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOlOi & "0" & "0" & "0" & wire_n10O_dataout);
	wire_n0ili_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0ili :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0ili_data,
		o => wire_n0ili_o,
		sel => wire_n0ili_sel
	  );
	wire_n0ill_data <= ( "0" & "0" & "0" & "0" & "0" & "1" & nliOil & wire_w_lg_w_lg_nliOOi538w539w & "0" & "0" & "0" & "0" & "0" & "0" & nlOl0O & "0" & "0" & "0" & "0" & "0" & wire_nilll_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOlOl & "0" & "0" & "0" & wire_n1ii_dataout);
	wire_n0ill_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0ill :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0ill_data,
		o => wire_n0ill_o,
		sel => wire_n0ill_sel
	  );
	wire_n0ilO_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & nliOiO & wire_w_lg_w_lg_nliOOl469w470w & "0" & "0" & "0" & "0" & "0" & "0" & nlOlii & "0" & "0" & "0" & "0" & "0" & wire_nillO_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOlOO & "0" & "0" & "0" & wire_n1il_dataout);
	wire_n0ilO_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0ilO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0ilO_data,
		o => wire_n0ilO_o,
		sel => wire_n0ilO_sel
	  );
	wire_n0iOi_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & nlOl0i & "0" & "0" & "0" & "0" & "0" & "0" & "0" & nlOlil & "0" & "0" & "0" & "0" & "0" & wire_nilOi_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOO1i & "0" & "0" & "0" & wire_n1iO_dataout);
	wire_n0iOi_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0iOi :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0iOi_data,
		o => wire_n0iOi_o,
		sel => wire_n0iOi_sel
	  );
	wire_n0iOl_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & nlOl0l & "0" & "0" & "0" & "0" & "0" & "0" & "0" & nlOliO & "0" & "0" & "0" & "0" & "0" & wire_nilOl_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOO1l & "0" & "0" & "0" & wire_n1li_dataout);
	wire_n0iOl_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0iOl :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0iOl_data,
		o => wire_n0iOl_o,
		sel => wire_n0iOl_sel
	  );
	wire_n0iOO_data <= ( "0" & "0" & "0" & "0" & "0" & "0" & nlOl0O & "0" & "0" & "0" & "0" & "0" & "0" & "0" & nlOlli & "0" & "0" & "0" & "0" & "0" & wire_nilOO_dataout & "0" & "0" & "0" & "0" & "0" & "0" & nlOO1O & "0" & "0" & "0" & wire_n1ll_dataout);
	wire_n0iOO_sel <= ( rpma_doublewidth_tx & rpmadwidth_tx & rprbs_sel(2 DOWNTO 0));
	n0iOO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n0iOO_data,
		o => wire_n0iOO_o,
		sel => wire_n0iOO_sel
	  );
	wire_n000i_data <= ( "0" & nlOOil & nlOlii & wire_nliOi_dataout);
	wire_n000i_sel <= ( nlilil & nlilii & wire_n00ii_o(25) & wire_n00ii_o(0));
	n000i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n000i_data,
		o => wire_n000i_o,
		sel => wire_n000i_sel
	  );
	wire_n001O_data <= ( "0" & nlOOii & nlOlil & wire_nlilO_dataout);
	wire_n001O_sel <= ( nlilil & nlilii & wire_n00ii_o(25) & wire_n00ii_o(0));
	n001O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n001O_data,
		o => wire_n001O_o,
		sel => wire_n001O_sel
	  );
	wire_n010i_data <= ( "0" & nlOlOO & nlOlOi & nlOO1l & wire_nli0l_dataout);
	wire_n010i_sel <= ( nlil0O & nlil1l & nlil0i & wire_n00ii_o(17) & wire_n00ii_o(0));
	n010i :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n010i_data,
		o => wire_n010i_o,
		sel => wire_n010i_sel
	  );
	wire_n010O_data <= ( "0" & nlOO1i & nlOlOl & wire_nli0O_dataout);
	wire_n010O_sel <= ( nlil0O & nlil1O & wire_n00ii_w_lg_w_lg_w_o_range106w1961w1962w & wire_n00ii_o(0));
	n010O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n010O_data,
		o => wire_n010O_o,
		sel => wire_n010O_sel
	  );
	wire_n011i_data <= ( "0" & nlOllO & nlOO1O & nlOO0l & wire_nli1l_dataout);
	wire_n011i_sel <= ( nlilil & nlil0l & wire_n00ii_o(25) & nlil0i & wire_n00ii_o(0));
	n011i :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n011i_data,
		o => wire_n011i_o,
		sel => wire_n011i_sel
	  );
	wire_n011l_data <= ( "0" & nlOlOi & nlOO1l & nlOO0O & wire_nli1O_dataout);
	wire_n011l_sel <= ( nlilil & nlil0l & wire_n00ii_o(25) & nlil0i & wire_n00ii_o(0));
	n011l :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n011l_data,
		o => wire_n011l_o,
		sel => wire_n011l_sel
	  );
	wire_n011O_data <= ( "0" & nlOlOl & nlOO1i & nlOllO & nlOO1O & wire_nli0i_dataout);
	wire_n011O_sel <= ( nlil0O & nlil0l & wire_n00ii_o(25) & nlil0i & wire_n00ii_o(17) & wire_n00ii_o(0));
	n011O :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n011O_data,
		o => wire_n011O_o,
		sel => wire_n011O_sel
	  );
	wire_n01iO_data <= ( "0" & nlOO1l & nlOlOi & nlOlOO & wire_nliii_dataout);
	wire_n01iO_sel <= ( nlil0O & nlil0l & wire_n00ii_o(25) & wire_n00ii_w_lg_w_lg_w_o_range106w1878w1941w & wire_n00ii_o(0));
	n01iO :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_n01iO_data,
		o => wire_n01iO_o,
		sel => wire_n01iO_sel
	  );
	wire_n01ll_data <= ( "0" & nlOO1O & nlOllO & nlOO1i & nlOlOl & wire_nliil_dataout);
	wire_n01ll_sel <= ( nlil0O & nlil0l & wire_n00ii_o(25) & nlil0i & wire_n00ii_o(17) & wire_n00ii_o(0));
	n01ll :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n01ll_data,
		o => wire_n01ll_o,
		sel => wire_n01ll_sel
	  );
	wire_n01lO_data <= ( "0" & nlOO0i & nlOlll & nlOO1l & nlOlOi & wire_nliiO_dataout);
	wire_n01lO_sel <= ( nlil0O & nlil0l & wire_n00ii_o(25) & nlil0i & wire_n00ii_o(17) & wire_n00ii_o(0));
	n01lO :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n01lO_data,
		o => wire_n01lO_o,
		sel => wire_n01lO_sel
	  );
	wire_n01Oi_data <= ( "0" & nlOO0l & nlOlli & nlOO1O & nlOllO & wire_nlili_dataout);
	wire_n01Oi_sel <= ( nlil0O & nlil0l & wire_n00ii_o(25) & nlil0i & wire_n00ii_o(17) & wire_n00ii_o(0));
	n01Oi :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n01Oi_data,
		o => wire_n01Oi_o,
		sel => wire_n01Oi_sel
	  );
	wire_n01Ol_data <= ( "0" & nlOO0O & nlOliO & nlOO0i & nlOlll & wire_nlill_dataout);
	wire_n01Ol_sel <= ( nlil0O & nlil0l & wire_n00ii_o(25) & nlil0i & wire_n00ii_o(17) & wire_n00ii_o(0));
	n01Ol :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n01Ol_data,
		o => wire_n01Ol_o,
		sel => wire_n01Ol_sel
	  );
	wire_n1O0O_data <= ( "0" & nlOl0i & nlOOll & wire_nl0iO_dataout);
	wire_n1O0O_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1O0O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1O0O_data,
		o => wire_n1O0O_o,
		sel => wire_n1O0O_sel
	  );
	wire_n1Oii_data <= ( "0" & nlOl0l & nlOOli & wire_nl0li_dataout);
	wire_n1Oii_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1Oii :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oii_data,
		o => wire_n1Oii_o,
		sel => wire_n1Oii_sel
	  );
	wire_n1Oil_data <= ( "0" & nlOl0O & nlOOiO & wire_nl0ll_dataout);
	wire_n1Oil_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1Oil :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oil_data,
		o => wire_n1Oil_o,
		sel => wire_n1Oil_sel
	  );
	wire_n1OiO_data <= ( "0" & nlOlii & nlOOil & wire_nl0lO_dataout);
	wire_n1OiO_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1OiO :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OiO_data,
		o => wire_n1OiO_o,
		sel => wire_n1OiO_sel
	  );
	wire_n1Oli_data <= ( "0" & nlOlil & nlOOii & wire_nl0Oi_dataout);
	wire_n1Oli_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1Oli :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oli_data,
		o => wire_n1Oli_o,
		sel => wire_n1Oli_sel
	  );
	wire_n1Oll_data <= ( "0" & nlOliO & nlOO0O & wire_nl0Ol_dataout);
	wire_n1Oll_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1Oll :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oll_data,
		o => wire_n1Oll_o,
		sel => wire_n1Oll_sel
	  );
	wire_n1OlO_data <= ( "0" & nlOlli & nlOO0l & wire_nl0OO_dataout);
	wire_n1OlO_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1OlO :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OlO_data,
		o => wire_n1OlO_o,
		sel => wire_n1OlO_sel
	  );
	wire_n1OOi_data <= ( "0" & nlOlll & nlOO0i & wire_nli1i_dataout);
	wire_n1OOi_sel <= ( nlil1i & nlilii & nliiOO & wire_n00ii_o(0));
	n1OOi :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OOi_data,
		o => wire_n1OOi_o,
		sel => wire_n1OOi_sel
	  );
	wire_niOO_data <= ( nllilO & wire_nl1O_dataout & nllili);
	wire_niOO_sel <= ( nlli & nilO & wire_nlliil22_w_lg_w_lg_q93w94w);
	niOO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niOO_data,
		o => wire_niOO_o,
		sel => wire_niOO_sel
	  );
	wire_nl1i_data <= ( "0" & wire_nlliiO20_w_lg_w_lg_q88w89w & wire_w_lg_nllili85w);
	wire_nl1i_sel <= ( nlli & nilO & wire_nllill18_w_lg_w_lg_q79w80w);
	nl1i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1i_data,
		o => wire_nl1i_o,
		sel => wire_nl1i_sel
	  );
	wire_nl1l_data <= ( wire_w_lg_nllilO77w & wire_nl0i_dataout & "0");
	wire_nl1l_sel <= ( nlli & wire_nlliOi16_w_lg_w_lg_q69w70w & nlil);
	nl1l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1l_data,
		o => wire_nl1l_o,
		sel => wire_nl1l_sel
	  );

 END RTL; --cycloneiv_hssi_tx_digi_prbs_gen
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 10.0SP1 cbx_mgl 2010:08:18:21:20:44:SJ cbx_simgen 2010:08:18:21:16:35:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 139 mux21 168 oper_decoder 2 oper_mux 184 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  cycloneiv_hssi_tx_digi_enc_chnl_top IS 
	 PORT 
	 ( 
		 cascaded_8b10b_en	:	IN  STD_LOGIC;
		 clk	:	IN  STD_LOGIC;
		 d21_5_eq_n	:	IN  STD_LOGIC;
		 d2_2_eq_n	:	IN  STD_LOGIC;
		 disp_out_3b	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 doublewidth	:	IN  STD_LOGIC;
		 dwidth	:	IN  STD_LOGIC;
		 endec	:	IN  STD_LOGIC;
		 enpolinv_tx	:	IN  STD_LOGIC;
		 ge_xaui_sel	:	IN  STD_LOGIC;
		 ib_force_disparity	:	IN  STD_LOGIC;
		 k_det	:	IN  STD_LOGIC;
		 prbs_en	:	IN  STD_LOGIC;
		 pudr	:	OUT  STD_LOGIC_VECTOR (19 DOWNTO 0);
		 r8b10b_enc_ibm_en	:	IN  STD_LOGIC;
		 renbitrev_tx	:	IN  STD_LOGIC;
		 rendec_data_sel_tx	:	IN  STD_LOGIC;
		 renpolinv_tx	:	IN  STD_LOGIC;
		 rensymswap_tx	:	IN  STD_LOGIC;
		 rev_loop_data	:	IN  STD_LOGIC_VECTOR (19 DOWNTO 0);
		 rev_loopbk	:	IN  STD_LOGIC;
		 rforce_disp	:	IN  STD_LOGIC;
		 rrev_loopbk	:	IN  STD_LOGIC;
		 rst	:	IN  STD_LOGIC;
		 rtxbitslip_en	:	IN  STD_LOGIC;
		 tx_boundary_sel	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 tx_ctl_pre_en	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 tx_ctl_tc	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 tx_ctl_ts	:	IN  STD_LOGIC;
		 tx_data_9_pre_en	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 tx_data_9_tc	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 tx_data_pg	:	IN  STD_LOGIC_VECTOR (19 DOWNTO 0);
		 tx_data_pre_en	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 tx_data_tc	:	IN  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 tx_data_ts	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 txd_extend_tc	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 txlp20b	:	OUT  STD_LOGIC_VECTOR (19 DOWNTO 0)
	 ); 
 END cycloneiv_hssi_tx_digi_enc_chnl_top;

 ARCHITECTURE RTL OF cycloneiv_hssi_tx_digi_enc_chnl_top IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 ni0O0l49	:	STD_LOGIC := '0';
	 SIGNAL	 ni0O0l50	:	STD_LOGIC := '0';
	 SIGNAL	 ni0O0O47	:	STD_LOGIC := '0';
	 SIGNAL	 ni0O0O48	:	STD_LOGIC := '0';
	 SIGNAL	 ni0Oii45	:	STD_LOGIC := '0';
	 SIGNAL	 ni0Oii46	:	STD_LOGIC := '0';
	 SIGNAL	 ni0OiO43	:	STD_LOGIC := '0';
	 SIGNAL	 ni0OiO44	:	STD_LOGIC := '0';
	 SIGNAL	 ni0Oli41	:	STD_LOGIC := '0';
	 SIGNAL	 ni0Oli42	:	STD_LOGIC := '0';
	 SIGNAL	 ni0Oll39	:	STD_LOGIC := '0';
	 SIGNAL	 ni0Oll40	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni0Oll40_w_lg_w_lg_q202w203w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0Oll40_w_lg_q202w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 ni0OlO37	:	STD_LOGIC := '0';
	 SIGNAL	 ni0OlO38	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni0OlO38_w_lg_w_lg_q195w196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OlO38_w_lg_q195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 ni0OOi35	:	STD_LOGIC := '0';
	 SIGNAL	 ni0OOi36	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni0OOi36_w_lg_w_lg_q187w189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOi36_w_lg_q187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 ni0OOl33	:	STD_LOGIC := '0';
	 SIGNAL	 ni0OOl34	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni0OOl34_w_lg_w_lg_q160w161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOl34_w_lg_q160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 ni0OOO31	:	STD_LOGIC := '0';
	 SIGNAL	 ni0OOO32	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni0OOO32_w_lg_w_lg_q139w140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOO32_w_lg_q139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii00i5	:	STD_LOGIC := '0';
	 SIGNAL	 nii00i6	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii00i6_w_lg_q15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii01l7	:	STD_LOGIC := '0';
	 SIGNAL	 nii01l8	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii01l8_w_lg_q21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii0ii3	:	STD_LOGIC := '0';
	 SIGNAL	 nii0ii4	:	STD_LOGIC := '0';
	 SIGNAL	 nii0iO1	:	STD_LOGIC := '0';
	 SIGNAL	 nii0iO2	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii0iO2_w_lg_q3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii10i23	:	STD_LOGIC := '0';
	 SIGNAL	 nii10i24	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii10i24_w_lg_w_lg_q100w101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii10i24_w_lg_q100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii10l21	:	STD_LOGIC := '0';
	 SIGNAL	 nii10l22	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii10l22_w_lg_w_lg_q86w87w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii10l22_w_lg_q86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii10O19	:	STD_LOGIC := '0';
	 SIGNAL	 nii10O20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii10O20_w_lg_w_lg_q83w84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii10O20_w_lg_q83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii11i29	:	STD_LOGIC := '0';
	 SIGNAL	 nii11i30	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii11i30_w_lg_w_lg_q132w134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii11i30_w_lg_q132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii11l27	:	STD_LOGIC := '0';
	 SIGNAL	 nii11l28	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii11l28_w_lg_w_lg_q118w120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii11l28_w_lg_q118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii11O25	:	STD_LOGIC := '0';
	 SIGNAL	 nii11O26	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii11O26_w_lg_w_lg_q115w116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii11O26_w_lg_q115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii1ii17	:	STD_LOGIC := '0';
	 SIGNAL	 nii1ii18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii1ii18_w_lg_w_lg_q75w76w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1ii18_w_lg_q75w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii1il15	:	STD_LOGIC := '0';
	 SIGNAL	 nii1il16	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii1il16_w_lg_w_lg_q67w68w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1il16_w_lg_q67w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii1li13	:	STD_LOGIC := '0';
	 SIGNAL	 nii1li14	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii1li14_w_lg_q33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii1lO11	:	STD_LOGIC := '0';
	 SIGNAL	 nii1lO12	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii1lO12_w_lg_q28w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii1OO10	:	STD_LOGIC := '0';
	 SIGNAL	 nii1OO9	:	STD_LOGIC := '0';
	 SIGNAL	n01li	:	STD_LOGIC := '0';
	 SIGNAL	wire_n01iO_PRN	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_ENA	:	STD_LOGIC;
	 SIGNAL  wire_n01iO_w_lg_n01li1049w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n000i	:	STD_LOGIC := '0';
	 SIGNAL	n000l	:	STD_LOGIC := '0';
	 SIGNAL	n000O	:	STD_LOGIC := '0';
	 SIGNAL	n001i	:	STD_LOGIC := '0';
	 SIGNAL	n001l	:	STD_LOGIC := '0';
	 SIGNAL	n001O	:	STD_LOGIC := '0';
	 SIGNAL	n00ii	:	STD_LOGIC := '0';
	 SIGNAL	n00il	:	STD_LOGIC := '0';
	 SIGNAL	n00iO	:	STD_LOGIC := '0';
	 SIGNAL	n00li	:	STD_LOGIC := '0';
	 SIGNAL	n00ll	:	STD_LOGIC := '0';
	 SIGNAL	n00lO	:	STD_LOGIC := '0';
	 SIGNAL	n00Oi	:	STD_LOGIC := '0';
	 SIGNAL	n00Ol	:	STD_LOGIC := '0';
	 SIGNAL	n00OO	:	STD_LOGIC := '0';
	 SIGNAL	n01ii	:	STD_LOGIC := '0';
	 SIGNAL	n01il	:	STD_LOGIC := '0';
	 SIGNAL	n01lO	:	STD_LOGIC := '0';
	 SIGNAL	n01Oi	:	STD_LOGIC := '0';
	 SIGNAL	n01Ol	:	STD_LOGIC := '0';
	 SIGNAL	n01OO	:	STD_LOGIC := '0';
	 SIGNAL	n0i1i	:	STD_LOGIC := '0';
	 SIGNAL	n0i1l	:	STD_LOGIC := '0';
	 SIGNAL	n0i1O	:	STD_LOGIC := '0';
	 SIGNAL	n0iiO	:	STD_LOGIC := '0';
	 SIGNAL	n0ill	:	STD_LOGIC := '0';
	 SIGNAL	n0iOl	:	STD_LOGIC := '0';
	 SIGNAL	n0iOO	:	STD_LOGIC := '0';
	 SIGNAL	n0l0l	:	STD_LOGIC := '0';
	 SIGNAL	n0l1i	:	STD_LOGIC := '0';
	 SIGNAL	n0l1l	:	STD_LOGIC := '0';
	 SIGNAL	n0l1O	:	STD_LOGIC := '0';
	 SIGNAL	n0lii	:	STD_LOGIC := '0';
	 SIGNAL	n0lil	:	STD_LOGIC := '0';
	 SIGNAL	n0liO	:	STD_LOGIC := '0';
	 SIGNAL	n0lli	:	STD_LOGIC := '0';
	 SIGNAL	n0lll	:	STD_LOGIC := '0';
	 SIGNAL	n0llO	:	STD_LOGIC := '0';
	 SIGNAL	n0lOi	:	STD_LOGIC := '0';
	 SIGNAL	ni00i	:	STD_LOGIC := '0';
	 SIGNAL	ni01l	:	STD_LOGIC := '0';
	 SIGNAL	ni0ii	:	STD_LOGIC := '0';
	 SIGNAL	ni0il	:	STD_LOGIC := '0';
	 SIGNAL	ni0iO	:	STD_LOGIC := '0';
	 SIGNAL	ni0li	:	STD_LOGIC := '0';
	 SIGNAL	ni0ll	:	STD_LOGIC := '0';
	 SIGNAL	ni0Ol	:	STD_LOGIC := '0';
	 SIGNAL	ni1li	:	STD_LOGIC := '0';
	 SIGNAL	ni1ll	:	STD_LOGIC := '0';
	 SIGNAL	nii0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nii0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nii0OO	:	STD_LOGIC := '0';
	 SIGNAL	niii0i	:	STD_LOGIC := '0';
	 SIGNAL	niii0l	:	STD_LOGIC := '0';
	 SIGNAL	niii0O	:	STD_LOGIC := '0';
	 SIGNAL	niii1i	:	STD_LOGIC := '0';
	 SIGNAL	niii1l	:	STD_LOGIC := '0';
	 SIGNAL	niii1O	:	STD_LOGIC := '0';
	 SIGNAL	niiiii	:	STD_LOGIC := '0';
	 SIGNAL	niiiil	:	STD_LOGIC := '0';
	 SIGNAL	niiiiO	:	STD_LOGIC := '0';
	 SIGNAL	niiili	:	STD_LOGIC := '0';
	 SIGNAL	niiill	:	STD_LOGIC := '0';
	 SIGNAL	niiilO	:	STD_LOGIC := '0';
	 SIGNAL	niiiOi	:	STD_LOGIC := '0';
	 SIGNAL	niiiOl	:	STD_LOGIC := '0';
	 SIGNAL	niiiOO	:	STD_LOGIC := '0';
	 SIGNAL	niil1i	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0Oi_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oi_PRN	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oi_w_lg_n01il36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0i0i	:	STD_LOGIC := '0';
	 SIGNAL	n0i0l	:	STD_LOGIC := '0';
	 SIGNAL	n0i0O	:	STD_LOGIC := '0';
	 SIGNAL	n0iii	:	STD_LOGIC := '0';
	 SIGNAL	n0iil	:	STD_LOGIC := '0';
	 SIGNAL	n0ili	:	STD_LOGIC := '0';
	 SIGNAL	n0ilO	:	STD_LOGIC := '0';
	 SIGNAL	n0iOi	:	STD_LOGIC := '0';
	 SIGNAL	n0l0i	:	STD_LOGIC := '0';
	 SIGNAL	n0l0O	:	STD_LOGIC := '0';
	 SIGNAL	ni00l	:	STD_LOGIC := '0';
	 SIGNAL	ni00O	:	STD_LOGIC := '0';
	 SIGNAL	ni01i	:	STD_LOGIC := '0';
	 SIGNAL	ni01O	:	STD_LOGIC := '0';
	 SIGNAL	ni0lO	:	STD_LOGIC := '0';
	 SIGNAL	ni1lO	:	STD_LOGIC := '0';
	 SIGNAL	ni1Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni1Ol	:	STD_LOGIC := '0';
	 SIGNAL	ni1OO	:	STD_LOGIC := '0';
	 SIGNAL	nii1i	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0OO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_PRN	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00i_w_lg_w_lg_dataout1617w1689w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w_lg_dataout1617w1640w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w_lg_dataout1617w1698w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1751w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1746w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1737w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1734w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1642w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1633w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1740w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1645w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1648w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_dataout1617w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w_lg_w_lg_dataout1617w1689w1691w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w_lg_w_lg_dataout1617w1640w1643w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w_lg_w_lg_dataout1617w1698w1699w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w_lg_w_lg_w_lg_dataout1617w1689w1691w1693w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w_lg_w_lg_w_lg_dataout1617w1640w1643w1646w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w1695w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w1649w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_w1695w1696w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00l_w_lg_w_lg_w_lg_dataout1637w1638w1650w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_w_lg_dataout1719w1720w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_w_lg_dataout1637w1700w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_w_lg_dataout1637w1638w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_w_lg_w_lg_dataout1637w1679w1680w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_dataout1685w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_dataout1618w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_dataout1719w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_dataout1694w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_dataout1692w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_dataout1690w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_dataout1637w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l_w_lg_w_lg_dataout1637w1679w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00O_w_lg_dataout1663w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n01i_w_lg_dataout1624w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n01l_w_lg_w_lg_dataout1620w1666w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01l_w_lg_w_lg_dataout1620w1621w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01l_w_lg_dataout1625w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01l_w_lg_dataout1667w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01l_w_lg_dataout1620w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01l_w_lg_dataout1676w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n01O_w_lg_w_lg_dataout1619w1750w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_w_lg_dataout1619w1745w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_w_lg_dataout1619w1736w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_w_lg_dataout1619w1733w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_w_lg_dataout1619w1641w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_w_lg_dataout1619w1632w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_dataout1739w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_dataout1644w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_dataout1647w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_dataout1688w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_dataout1639w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_dataout1619w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n01O_w_lg_dataout1677w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0ii_w_lg_dataout1654w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ii_w_lg_dataout1616w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0il_w_lg_dataout1655w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0il_w_lg_dataout1612w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0O1l_w_lg_dataout1848w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0O1O_w_lg_dataout1697w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1il_w_lg_dataout1775w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1iO_w_lg_w_lg_dataout1771w1817w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iO_w_lg_w_lg_dataout1771w1772w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iO_w_lg_dataout1776w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iO_w_lg_dataout1818w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iO_w_lg_dataout1771w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iO_w_lg_dataout1827w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1li_w_lg_w_lg_dataout1770w1792w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_w_lg_dataout1770w1783w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_w_lg_dataout1770w1901w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_w_lg_dataout1770w1896w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_w_lg_dataout1770w1887w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_w_lg_dataout1770w1884w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_dataout1890w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_dataout1795w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_dataout1798w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_dataout1839w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_dataout1790w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_dataout1770w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1li_w_lg_dataout1828w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1ll_w_lg_w_lg_dataout1768w1840w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w_lg_dataout1768w1791w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w_lg_dataout1768w1849w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1793w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1784w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1902w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1897w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1888w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1885w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1891w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1796w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1799w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_dataout1768w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1840w1842w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1791w1794w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1849w1850w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w_lg_w_lg_w_lg_dataout1768w1840w1842w1844w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w_lg_w_lg_w_lg_dataout1768w1791w1794w1797w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w1846w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w1800w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1ll_w_lg_w1846w1847w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1lO_w_lg_w_lg_w_lg_dataout1788w1789w1801w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_w_lg_dataout1870w1871w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_w_lg_dataout1788w1851w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_w_lg_dataout1788w1789w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_w_lg_w_lg_dataout1788w1830w1831w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_dataout1836w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_dataout1769w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_dataout1870w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_dataout1845w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_dataout1843w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_dataout1841w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_dataout1788w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lO_w_lg_w_lg_dataout1788w1830w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1Oi_w_lg_dataout1814w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1Ol_w_lg_dataout1805w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Ol_w_lg_dataout1767w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1OO_w_lg_dataout1806w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1OO_w_lg_dataout1763w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nil_w_lg_dataout1804w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nil00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO_w_lg_dataout1653w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlOi_w_lg_w_lg_dataout1755w1758w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOlOi_w_lg_w_lg_dataout1755w1760w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOlOi_w_lg_dataout1802w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOlOi_w_lg_dataout1755w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOlOi_w_lg_w_lg_w_lg_dataout1755w1758w1759w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl001i_w_lg_dataout1765w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl00ll_w_lg_dataout1757w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl01iO_w_lg_dataout1762w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl01Ol_w_lg_dataout1764w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl10Ol_w_lg_dataout1859w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl10OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl10OO_w_lg_dataout1860w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1i0O_w_lg_dataout1861w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli1il_w_lg_w_lg_dataout1604w1607w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1il_w_lg_w_lg_dataout1604w1609w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1il_w_lg_dataout1651w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1il_w_lg_dataout1604w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1il_w_lg_w_lg_w_lg_dataout1604w1607w1608w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliliO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliliO_w_lg_dataout1708w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlilli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlilli_w_lg_dataout1709w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliO1i_w_lg_dataout1710w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nliO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlli0i_w_lg_dataout1611w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlliiO_w_lg_dataout1613w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nllill_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllill_w_lg_dataout1614w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nllilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlll0O_w_lg_dataout1606w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nili1O_i	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nili1O_o	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nillli_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nillli_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n010i_w_lg_o200w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n010i_o	:	STD_LOGIC;
	 SIGNAL  wire_n010i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n010l_w_lg_o188w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n010l_o	:	STD_LOGIC;
	 SIGNAL  wire_n010l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_o178w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n010O_o	:	STD_LOGIC;
	 SIGNAL  wire_n010O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n011i_w_lg_o229w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n011i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n011i_o	:	STD_LOGIC;
	 SIGNAL  wire_n011i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n011l_w_lg_o220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n011l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n011l_o	:	STD_LOGIC;
	 SIGNAL  wire_n011l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n011O_w_lg_o211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n011O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n011O_o	:	STD_LOGIC;
	 SIGNAL  wire_n011O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O0i_w_lg_o122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1O0i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1O0i_o	:	STD_LOGIC;
	 SIGNAL  wire_n1O0i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O0l_w_lg_o133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1O0l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1O0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1O0l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O0O_w_lg_o130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1O0O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1O0O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1O0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O1l_w_lg_o96w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1O1l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1O1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1O1l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1O1O_w_lg_o108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1O1O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1O1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1O1O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oii_w_lg_o119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Oii_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1Oii_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oil_w_lg_o106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Oil_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1Oil_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oil_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OiO_w_lg_o94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1OiO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1OiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oli_w_lg_o81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Oli_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1Oli_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oli_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Oll_w_lg_o70w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Oll_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1Oll_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oll_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OlO_w_lg_o265w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1OlO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1OlO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OlO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OOi_w_lg_o256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1OOi_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1OOi_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OOi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OOl_w_lg_o247w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1OOl_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1OOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OOl_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OOO_w_lg_o238w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1OOO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_n1OOO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OOO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niil0i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niil0i_o	:	STD_LOGIC;
	 SIGNAL  wire_niil0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niil0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niil0l_o	:	STD_LOGIC;
	 SIGNAL  wire_niil0l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niil0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niil0O_o	:	STD_LOGIC;
	 SIGNAL  wire_niil0O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niil1l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niil1l_o	:	STD_LOGIC;
	 SIGNAL  wire_niil1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niil1O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niil1O_o	:	STD_LOGIC;
	 SIGNAL  wire_niil1O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niilii_o	:	STD_LOGIC;
	 SIGNAL  wire_niilii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilil_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niilil_o	:	STD_LOGIC;
	 SIGNAL  wire_niilil_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiliO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiliO_o	:	STD_LOGIC;
	 SIGNAL  wire_niiliO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilli_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niilli_o	:	STD_LOGIC;
	 SIGNAL  wire_niilli_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilll_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niilll_o	:	STD_LOGIC;
	 SIGNAL  wire_niilll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niillO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niillO_o	:	STD_LOGIC;
	 SIGNAL  wire_niillO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilOi_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niilOi_o	:	STD_LOGIC;
	 SIGNAL  wire_niilOi_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilOl_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niilOl_o	:	STD_LOGIC;
	 SIGNAL  wire_niilOl_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilOO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niilOO_o	:	STD_LOGIC;
	 SIGNAL  wire_niilOO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiO0i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiO0i_o	:	STD_LOGIC;
	 SIGNAL  wire_niiO0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiO0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_niiO0l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiO0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiO0O_o	:	STD_LOGIC;
	 SIGNAL  wire_niiO0O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiO1i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_niiO1i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiO1l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiO1l_o	:	STD_LOGIC;
	 SIGNAL  wire_niiO1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiO1O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niiO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_niiO1O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiOii_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOii_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOii_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOil_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOil_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOil_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOiO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOiO_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOiO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOli_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOli_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOli_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOll_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOll_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOll_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOlO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOlO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOOi_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOOi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOOl_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOOl_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOOO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_niiOOO_o	:	STD_LOGIC;
	 SIGNAL  wire_niiOOO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil00i_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil00i_o	:	STD_LOGIC;
	 SIGNAL  wire_nil00i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil01i_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil01i_o	:	STD_LOGIC;
	 SIGNAL  wire_nil01i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil01l_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil01l_o	:	STD_LOGIC;
	 SIGNAL  wire_nil01l_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil01O_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nil01O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0ii_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0ii_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0ii_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0il_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0il_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0il_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0iO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0iO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0li_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0li_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0li_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0ll_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0ll_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0lO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0lO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0Oi_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0Oi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil0Ol_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil0Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0Ol_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil10i_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil10i_o	:	STD_LOGIC;
	 SIGNAL  wire_nil10i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil10l_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil10l_o	:	STD_LOGIC;
	 SIGNAL  wire_nil10l_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil10O_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil10O_o	:	STD_LOGIC;
	 SIGNAL  wire_nil10O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil11i_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil11i_o	:	STD_LOGIC;
	 SIGNAL  wire_nil11i_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil11l_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil11l_o	:	STD_LOGIC;
	 SIGNAL  wire_nil11l_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil11O_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil11O_o	:	STD_LOGIC;
	 SIGNAL  wire_nil11O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1ii_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1ii_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1ii_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1il_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1il_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1il_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1iO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1iO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1li_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1li_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1li_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1ll_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1ll_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1lO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1lO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1Oi_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1Oi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1Ol_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1Ol_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nil1OO_data	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nil1OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1OO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nili0i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nili0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nili0i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili0l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nili0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nili0l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili0O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nili0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nili0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilii_o	:	STD_LOGIC;
	 SIGNAL  wire_nilii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niliii_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_niliii_o	:	STD_LOGIC;
	 SIGNAL  wire_niliii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niliil_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_niliil_o	:	STD_LOGIC;
	 SIGNAL  wire_niliil_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niliiO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_niliiO_o	:	STD_LOGIC;
	 SIGNAL  wire_niliiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilil_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilil_o	:	STD_LOGIC;
	 SIGNAL  wire_nilil_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nilili_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilili_o	:	STD_LOGIC;
	 SIGNAL  wire_nilili_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilill_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilill_o	:	STD_LOGIC;
	 SIGNAL  wire_nilill_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nililO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nililO_o	:	STD_LOGIC;
	 SIGNAL  wire_nililO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niliO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niliO_o	:	STD_LOGIC;
	 SIGNAL  wire_niliO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niliOi_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_niliOi_o	:	STD_LOGIC;
	 SIGNAL  wire_niliOi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilli_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilli_o	:	STD_LOGIC;
	 SIGNAL  wire_nilli_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nilll_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilll_o	:	STD_LOGIC;
	 SIGNAL  wire_nilll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nillll_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nillll_o	:	STD_LOGIC;
	 SIGNAL  wire_nillll_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilllO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilllO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilllO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nillO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nillO_o	:	STD_LOGIC;
	 SIGNAL  wire_nillO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nillOi_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nillOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nillOi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nillOl_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nillOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nillOl_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nillOO_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nillOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nillOO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilO1i_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO1i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilO1l_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilO1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO1l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilO1O_data	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nilO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO1O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOi_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOi_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nilOl_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOl_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nilOO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niO0i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niO0i_o	:	STD_LOGIC;
	 SIGNAL  wire_niO0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niO0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_niO0l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niO0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niO0O_o	:	STD_LOGIC;
	 SIGNAL  wire_niO0O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niO1i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_niO1i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niO1l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niO1l_o	:	STD_LOGIC;
	 SIGNAL  wire_niO1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niO1O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_niO1O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niOii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niOii_o	:	STD_LOGIC;
	 SIGNAL  wire_niOii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niOil_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niOil_o	:	STD_LOGIC;
	 SIGNAL  wire_niOil_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niOiO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niOiO_o	:	STD_LOGIC;
	 SIGNAL  wire_niOiO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niOli_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niOli_o	:	STD_LOGIC;
	 SIGNAL  wire_niOli_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niOll_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_niOll_o	:	STD_LOGIC;
	 SIGNAL  wire_niOll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niOlO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_niOlO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niOOi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_niOOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niOOl_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_niOOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niOOO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niOOO_o	:	STD_LOGIC;
	 SIGNAL  wire_niOOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl00i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl00i_o	:	STD_LOGIC;
	 SIGNAL  wire_nl00i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl00l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl00l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl00l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl00O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl00O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl00O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl01i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl01i_o	:	STD_LOGIC;
	 SIGNAL  wire_nl01i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl01l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl01l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl01l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl01O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl01O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0ii_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0ii_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0ii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0il_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0il_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0il_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0iO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0iO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0li_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0li_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0li_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0ll_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0ll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0lO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0lO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0Oi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0Oi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0Ol_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0Ol_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0OO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0OO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl10i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl10i_o	:	STD_LOGIC;
	 SIGNAL  wire_nl10i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl10l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl10l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl10l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl10O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl10O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl10O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl11i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl11i_o	:	STD_LOGIC;
	 SIGNAL  wire_nl11i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl11l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl11l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl11l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl11O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl11O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl11O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1ii_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1ii_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1ii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1il_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1il_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1il_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1iO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1iO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1li_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1li_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1li_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1ll_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1ll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1lO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1lO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1Oi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1Oi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1Ol_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1Ol_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1OO_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1OO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli0i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nli0i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli0l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nli0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli0O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nli0O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli1i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nli1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli1l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nli1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli1O_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nli1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliii_o	:	STD_LOGIC;
	 SIGNAL  wire_nliii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliil_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliil_o	:	STD_LOGIC;
	 SIGNAL  wire_nliil_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliiO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliiO_o	:	STD_LOGIC;
	 SIGNAL  wire_nliiO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlili_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlili_o	:	STD_LOGIC;
	 SIGNAL  wire_nlili_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlill_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlill_o	:	STD_LOGIC;
	 SIGNAL  wire_nlill_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlilO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlilO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlilO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliOi_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOi_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliOl_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOl_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliOO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll0i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll1i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll1l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll1O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllii_o	:	STD_LOGIC;
	 SIGNAL  wire_nllii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllil_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllil_o	:	STD_LOGIC;
	 SIGNAL  wire_nllil_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlliO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlliO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllli_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllli_o	:	STD_LOGIC;
	 SIGNAL  wire_nllli_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllll_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllll_o	:	STD_LOGIC;
	 SIGNAL  wire_nllll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlllO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlllO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlllO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllOi_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOi_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllOl_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOl_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllOO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nllOO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO0i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO0l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO0O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO1i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO1l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO1O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_w_lg_w22w23w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w22w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w18w19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w31w34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w18w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w31w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_d21_5_eq_n1w4w5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_ni000i1832w1834w1835w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_ni0l1i1681w1683w1684w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_d21_5_eq_n1w16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_d21_5_eq_n1w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_d21_5_eq_n1w29w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_ni000i1832w1834w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_ni0l1i1681w1683w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_d21_5_eq_n1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ib_force_disparity1054w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rforce_disp1040w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rforce_disp1047w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rforce_disp1036w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rforce_disp1043w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni000i1832w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni000l1833w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni000O1858w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni001O1857w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0i0O1756w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOO1706w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1i1681w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1l1682w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1O1707w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O1O1605w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rst1030w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_tc_range6w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txd_extend_tc_range1035w1039w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txd_extend_tc_range1042w1046w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_ni00lO1852w1853w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_ni0liO1701w1702w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni001l1854w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni00lO1852w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOl1703w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0liO1701w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  ni000i :	STD_LOGIC;
	 SIGNAL  ni000l :	STD_LOGIC;
	 SIGNAL  ni000O :	STD_LOGIC;
	 SIGNAL  ni001i :	STD_LOGIC;
	 SIGNAL  ni001l :	STD_LOGIC;
	 SIGNAL  ni001O :	STD_LOGIC;
	 SIGNAL  ni00ii :	STD_LOGIC;
	 SIGNAL  ni00il :	STD_LOGIC;
	 SIGNAL  ni00iO :	STD_LOGIC;
	 SIGNAL  ni00li :	STD_LOGIC;
	 SIGNAL  ni00ll :	STD_LOGIC;
	 SIGNAL  ni00lO :	STD_LOGIC;
	 SIGNAL  ni00Oi :	STD_LOGIC;
	 SIGNAL  ni00Ol :	STD_LOGIC;
	 SIGNAL  ni00OO :	STD_LOGIC;
	 SIGNAL  ni01il :	STD_LOGIC;
	 SIGNAL  ni01iO :	STD_LOGIC;
	 SIGNAL  ni01li :	STD_LOGIC;
	 SIGNAL  ni01ll :	STD_LOGIC;
	 SIGNAL  ni01lO :	STD_LOGIC;
	 SIGNAL  ni01Oi :	STD_LOGIC;
	 SIGNAL  ni01Ol :	STD_LOGIC;
	 SIGNAL  ni01OO :	STD_LOGIC;
	 SIGNAL  ni0i0i :	STD_LOGIC;
	 SIGNAL  ni0i0l :	STD_LOGIC;
	 SIGNAL  ni0i0O :	STD_LOGIC;
	 SIGNAL  ni0i1i :	STD_LOGIC;
	 SIGNAL  ni0i1l :	STD_LOGIC;
	 SIGNAL  ni0i1O :	STD_LOGIC;
	 SIGNAL  ni0iii :	STD_LOGIC;
	 SIGNAL  ni0iil :	STD_LOGIC;
	 SIGNAL  ni0iiO :	STD_LOGIC;
	 SIGNAL  ni0ili :	STD_LOGIC;
	 SIGNAL  ni0ill :	STD_LOGIC;
	 SIGNAL  ni0ilO :	STD_LOGIC;
	 SIGNAL  ni0iOi :	STD_LOGIC;
	 SIGNAL  ni0iOl :	STD_LOGIC;
	 SIGNAL  ni0iOO :	STD_LOGIC;
	 SIGNAL  ni0l0i :	STD_LOGIC;
	 SIGNAL  ni0l0l :	STD_LOGIC;
	 SIGNAL  ni0l0O :	STD_LOGIC;
	 SIGNAL  ni0l1i :	STD_LOGIC;
	 SIGNAL  ni0l1l :	STD_LOGIC;
	 SIGNAL  ni0l1O :	STD_LOGIC;
	 SIGNAL  ni0lii :	STD_LOGIC;
	 SIGNAL  ni0lil :	STD_LOGIC;
	 SIGNAL  ni0liO :	STD_LOGIC;
	 SIGNAL  ni0lli :	STD_LOGIC;
	 SIGNAL  ni0lll :	STD_LOGIC;
	 SIGNAL  ni0llO :	STD_LOGIC;
	 SIGNAL  ni0lOi :	STD_LOGIC;
	 SIGNAL  ni0lOl :	STD_LOGIC;
	 SIGNAL  ni0lOO :	STD_LOGIC;
	 SIGNAL  ni0O0i :	STD_LOGIC;
	 SIGNAL  ni0O1i :	STD_LOGIC;
	 SIGNAL  ni0O1l :	STD_LOGIC;
	 SIGNAL  ni0O1O :	STD_LOGIC;
	 SIGNAL  ni0Oil :	STD_LOGIC;
	 SIGNAL  nii00O :	STD_LOGIC;
	 SIGNAL  nii1iO :	STD_LOGIC;
	 SIGNAL  nii1Ol :	STD_LOGIC;
	 SIGNAL  wire_w_tx_ctl_tc_range6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_9_tc_range1037w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txd_extend_tc_range1035w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txd_extend_tc_range1042w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w22w23w(0) <= wire_w22w(0) AND n01il;
	wire_w22w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w18w19w(0) AND wire_nii01l8_w_lg_q21w(0);
	wire_w35w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w31w34w(0) AND k_det;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w18w19w(0) <= wire_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w18w(0) AND k_det;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w31w34w(0) <= wire_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w31w(0) AND wire_nii1li14_w_lg_q33w(0);
	wire_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w18w(0) <= wire_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w(0) AND wire_w_lg_w_tx_ctl_tc_range6w7w(0);
	wire_w_lg_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w31w(0) <= wire_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w(0) AND wire_w_lg_w_tx_ctl_tc_range6w7w(0);
	wire_w_lg_w_lg_w_lg_d21_5_eq_n1w16w17w(0) <= wire_w_lg_w_lg_d21_5_eq_n1w16w(0) AND ge_xaui_sel;
	wire_w_lg_w_lg_w_lg_d21_5_eq_n1w4w5w(0) <= wire_w_lg_w_lg_d21_5_eq_n1w4w(0) AND ge_xaui_sel;
	wire_w_lg_w_lg_w_lg_d21_5_eq_n1w29w30w(0) <= wire_w_lg_w_lg_d21_5_eq_n1w29w(0) AND ge_xaui_sel;
	wire_w_lg_w_lg_w_lg_ni000i1832w1834w1835w(0) <= wire_w_lg_w_lg_ni000i1832w1834w(0) AND ni00ii;
	wire_w_lg_w_lg_w_lg_ni0l1i1681w1683w1684w(0) <= wire_w_lg_w_lg_ni0l1i1681w1683w(0) AND ni0l0i;
	wire_w_lg_w_lg_d21_5_eq_n1w16w(0) <= wire_w_lg_d21_5_eq_n1w(0) AND wire_nii00i6_w_lg_q15w(0);
	wire_w_lg_w_lg_d21_5_eq_n1w4w(0) <= wire_w_lg_d21_5_eq_n1w(0) AND wire_nii0iO2_w_lg_q3w(0);
	wire_w_lg_w_lg_d21_5_eq_n1w29w(0) <= wire_w_lg_d21_5_eq_n1w(0) AND wire_nii1lO12_w_lg_q28w(0);
	wire_w_lg_w_lg_ni000i1832w1834w(0) <= wire_w_lg_ni000i1832w(0) AND wire_w_lg_ni000l1833w(0);
	wire_w_lg_w_lg_ni0l1i1681w1683w(0) <= wire_w_lg_ni0l1i1681w(0) AND wire_w_lg_ni0l1l1682w(0);
	wire_w_lg_d21_5_eq_n1w(0) <= d21_5_eq_n AND d2_2_eq_n;
	wire_w_lg_ib_force_disparity1054w(0) <= ib_force_disparity AND wire_w_tx_data_9_tc_range1037w(0);
	wire_w_lg_rforce_disp1040w(0) <= rforce_disp AND wire_w_lg_w_txd_extend_tc_range1035w1039w(0);
	wire_w_lg_rforce_disp1047w(0) <= rforce_disp AND wire_w_lg_w_txd_extend_tc_range1042w1046w(0);
	wire_w_lg_rforce_disp1036w(0) <= rforce_disp AND wire_w_txd_extend_tc_range1035w(0);
	wire_w_lg_rforce_disp1043w(0) <= rforce_disp AND wire_w_txd_extend_tc_range1042w(0);
	wire_w_lg_ni000i1832w(0) <= NOT ni000i;
	wire_w_lg_ni000l1833w(0) <= NOT ni000l;
	wire_w_lg_ni000O1858w(0) <= NOT ni000O;
	wire_w_lg_ni001O1857w(0) <= NOT ni001O;
	wire_w_lg_ni0i0O1756w(0) <= NOT ni0i0O;
	wire_w_lg_ni0iOO1706w(0) <= NOT ni0iOO;
	wire_w_lg_ni0l1i1681w(0) <= NOT ni0l1i;
	wire_w_lg_ni0l1l1682w(0) <= NOT ni0l1l;
	wire_w_lg_ni0l1O1707w(0) <= NOT ni0l1O;
	wire_w_lg_ni0O1O1605w(0) <= NOT ni0O1O;
	wire_w_lg_rst1030w(0) <= NOT rst;
	wire_w_lg_w_tx_ctl_tc_range6w7w(0) <= NOT wire_w_tx_ctl_tc_range6w(0);
	wire_w_lg_w_txd_extend_tc_range1035w1039w(0) <= NOT wire_w_txd_extend_tc_range1035w(0);
	wire_w_lg_w_txd_extend_tc_range1042w1046w(0) <= NOT wire_w_txd_extend_tc_range1042w(0);
	wire_w_lg_w_lg_ni00lO1852w1853w(0) <= wire_w_lg_ni00lO1852w(0) OR ni001i;
	wire_w_lg_w_lg_ni0liO1701w1702w(0) <= wire_w_lg_ni0liO1701w(0) OR ni0iOi;
	wire_w_lg_ni001l1854w(0) <= ni001l OR wire_w_lg_w_lg_ni00lO1852w1853w(0);
	wire_w_lg_ni00lO1852w(0) <= ni00lO OR wire_n1lO_w_lg_w_lg_dataout1788w1851w(0);
	wire_w_lg_ni0iOl1703w(0) <= ni0iOl OR wire_w_lg_w_lg_ni0liO1701w1702w(0);
	wire_w_lg_ni0liO1701w(0) <= ni0liO OR wire_n00l_w_lg_w_lg_dataout1637w1700w(0);
	disp_out_3b <= ( wire_nlli1i_dataout & wire_nl010O_dataout);
	ni000i <= ((((wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_dataout AND ni01ll)) OR wire_n1ll_w_lg_dataout1902w(0)) OR wire_n1ll_w_lg_dataout1796w(0)) OR wire_n1ll_w_lg_dataout1799w(0));
	ni000l <= ((((((wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_w_lg_dataout1770w(0) AND wire_n1iO_w_lg_dataout1818w(0))) OR (wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_dataout AND ni01Ol))) OR (wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_dataout AND ni01Oi))) OR wire_n1ll_w_lg_dataout1885w(0)) OR wire_n1ll_w_lg_dataout1888w(0)) OR wire_n1ll_w_lg_dataout1891w(0));
	ni000O <= (ni00il OR (wire_n1lO_dataout AND ni00ii));
	ni001i <= (wire_n1lO_dataout AND ((wire_n1ll_dataout AND ni00iO) OR ni000i));
	ni001l <= (wire_nl1iii_dataout AND ni000l);
	ni001O <= (wire_n1lO_w_lg_w_lg_w_lg_dataout1788w1830w1831w(0) OR wire_n1lO_w_lg_dataout1836w(0));
	ni00ii <= (wire_n1ll_w_lg_dataout1768w(0) OR wire_n1li_w_lg_dataout1828w(0));
	ni00il <= (wire_n1lO_w_lg_dataout1788w(0) AND ni00iO);
	ni00iO <= ((((wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_w_lg_dataout1770w(0) AND wire_n1iO_w_lg_w_lg_dataout1771w1772w(0))) OR (wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_w_lg_dataout1770w(0) AND wire_n1iO_w_lg_dataout1776w(0)))) OR (wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_dataout AND ni01lO))) OR wire_n1ll_w_lg_dataout1897w(0));
	ni00li <= (wire_n1ll_dataout AND wire_n1li_w_lg_dataout1839w(0));
	ni00ll <= (wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_w_lg_dataout1770w(0) AND wire_n1iO_w_lg_w_lg_dataout1771w1817w(0)));
	ni00lO <= (ni00li OR ni00ll);
	ni00Oi <= ((wire_n1lO_w_lg_w_lg_dataout1870w1871w(0) AND wire_n1iO_w_lg_dataout1771w(0)) AND wire_n1il_w_lg_dataout1775w(0));
	ni00Ol <= wire_n1iO_w_lg_dataout1818w(0);
	ni00OO <= wire_n1iO_w_lg_w_lg_dataout1771w1817w(0);
	ni01il <= ((((((((((((((wire_nili1O_o(15) OR wire_nili1O_o(14)) OR wire_nili1O_o(13)) OR wire_nili1O_o(12)) OR wire_nili1O_o(11)) OR wire_nili1O_o(10)) OR wire_nili1O_o(9)) OR wire_nili1O_o(8)) OR wire_nili1O_o(7)) OR wire_nili1O_o(6)) OR wire_nili1O_o(5)) OR wire_nili1O_o(4)) OR wire_nili1O_o(3)) OR wire_nili1O_o(2)) OR wire_nili1O_o(1));
	ni01iO <= ((((((wire_nillli_o(15) OR wire_nillli_o(14)) OR wire_nillli_o(13)) OR wire_nillli_o(12)) OR wire_nillli_o(11)) OR wire_nillli_o(10)) OR wire_nillli_o(0));
	ni01li <= ((((((wire_nillli_o(7) OR wire_nillli_o(6)) OR wire_nillli_o(5)) OR wire_nillli_o(4)) OR wire_nillli_o(3)) OR wire_nillli_o(2)) OR wire_nillli_o(1));
	ni01ll <= wire_n1iO_w_lg_dataout1818w(0);
	ni01lO <= wire_n1iO_w_lg_w_lg_dataout1771w1817w(0);
	ni01Oi <= wire_n1iO_w_lg_dataout1776w(0);
	ni01Ol <= wire_n1iO_w_lg_w_lg_dataout1771w1772w(0);
	ni01OO <= (wire_n1ll_w_lg_w1846w1847w(0) XOR (wire_n0O1l_w_lg_dataout1848w(0) AND wire_w_lg_ni001l1854w(0)));
	ni0i0i <= (wire_niOlOi_w_lg_w_lg_w_lg_dataout1755w1758w1759w(0) XOR wire_niOlOi_w_lg_w_lg_dataout1755w1760w(0));
	ni0i0l <= (wire_n1Ol_dataout AND wire_n1Oi_dataout);
	ni0i0O <= (ni0i0l OR ni0i1l);
	ni0i1i <= (wire_n1OO_w_lg_dataout1763w(0) AND ni0i1l);
	ni0i1l <= (wire_n1Ol_w_lg_dataout1767w(0) AND wire_n1Oi_w_lg_dataout1814w(0));
	ni0i1O <= (wire_n1OO_dataout AND (wire_n1Ol_dataout AND (wire_n1Oi_dataout AND (((wire_niOlOi_w_lg_dataout1755w(0) AND (wire_n1lO_w_lg_dataout1769w(0) AND ((((wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_w_lg_dataout1770w(0) AND wire_n1iO_w_lg_w_lg_dataout1771w1772w(0))) OR (wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_w_lg_dataout1770w(0) AND wire_n1iO_w_lg_dataout1776w(0)))) OR (wire_n1ll_w_lg_dataout1768w(0) AND (wire_n1li_dataout AND ni00OO))) OR wire_n1ll_w_lg_dataout1784w(0)))) OR wire_niOlOi_w_lg_dataout1802w(0)) OR wire_n1OO_w_lg_dataout1806w(0)))));
	ni0iii <= (wire_nil_dataout AND ni00Oi);
	ni0iil <= wire_n01l_w_lg_dataout1667w(0);
	ni0iiO <= wire_n01l_w_lg_w_lg_dataout1620w1666w(0);
	ni0ili <= wire_n01l_w_lg_dataout1625w(0);
	ni0ill <= wire_n01l_w_lg_w_lg_dataout1620w1621w(0);
	ni0ilO <= (wire_n00i_w_lg_w1695w1696w(0) XOR (wire_n0O1O_w_lg_dataout1697w(0) AND wire_w_lg_ni0iOl1703w(0)));
	ni0iOi <= (wire_n00l_dataout AND ((wire_n00i_dataout AND ni0l0O) OR ni0l1i));
	ni0iOl <= (wire_nliO1l_dataout AND ni0l1l);
	ni0iOO <= (wire_n00l_w_lg_w_lg_w_lg_dataout1637w1679w1680w(0) OR wire_n00l_w_lg_dataout1685w(0));
	ni0l0i <= (wire_n00i_w_lg_dataout1617w(0) OR wire_n01O_w_lg_dataout1677w(0));
	ni0l0l <= (wire_n00l_w_lg_dataout1637w(0) AND ni0l0O);
	ni0l0O <= ((((wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_w_lg_dataout1619w(0) AND wire_n01l_w_lg_w_lg_dataout1620w1621w(0))) OR (wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_w_lg_dataout1619w(0) AND wire_n01l_w_lg_dataout1625w(0)))) OR (wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_dataout AND ni0iiO))) OR wire_n00i_w_lg_dataout1746w(0));
	ni0l1i <= ((((wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_dataout AND ni0iil)) OR wire_n00i_w_lg_dataout1751w(0)) OR wire_n00i_w_lg_dataout1645w(0)) OR wire_n00i_w_lg_dataout1648w(0));
	ni0l1l <= ((((((wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_w_lg_dataout1619w(0) AND wire_n01l_w_lg_dataout1667w(0))) OR (wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_dataout AND ni0ill))) OR (wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_dataout AND ni0ili))) OR wire_n00i_w_lg_dataout1734w(0)) OR wire_n00i_w_lg_dataout1737w(0)) OR wire_n00i_w_lg_dataout1740w(0));
	ni0l1O <= (ni0l0l OR (wire_n00l_dataout AND ni0l0i));
	ni0lii <= (wire_n00i_dataout AND wire_n01O_w_lg_dataout1688w(0));
	ni0lil <= (wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_w_lg_dataout1619w(0) AND wire_n01l_w_lg_w_lg_dataout1620w1666w(0)));
	ni0liO <= (ni0lii OR ni0lil);
	ni0lli <= ((wire_n00l_w_lg_w_lg_dataout1719w1720w(0) AND wire_n01l_w_lg_dataout1620w(0)) AND wire_n01i_w_lg_dataout1624w(0));
	ni0lll <= wire_n01l_w_lg_dataout1667w(0);
	ni0llO <= wire_n01l_w_lg_w_lg_dataout1620w1666w(0);
	ni0lOi <= (wire_n0il_w_lg_dataout1612w(0) AND ni0lOl);
	ni0lOl <= (wire_n0ii_w_lg_dataout1616w(0) AND wire_n00O_w_lg_dataout1663w(0));
	ni0lOO <= (wire_n0il_dataout AND (wire_n0ii_dataout AND (wire_n00O_dataout AND (((wire_nli1il_w_lg_dataout1604w(0) AND (wire_n00l_w_lg_dataout1618w(0) AND ((((wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_w_lg_dataout1619w(0) AND wire_n01l_w_lg_w_lg_dataout1620w1621w(0))) OR (wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_w_lg_dataout1619w(0) AND wire_n01l_w_lg_dataout1625w(0)))) OR (wire_n00i_w_lg_dataout1617w(0) AND (wire_n01O_dataout AND ni0llO))) OR wire_n00i_w_lg_dataout1633w(0)))) OR wire_nli1il_w_lg_dataout1651w(0)) OR wire_n0il_w_lg_dataout1655w(0)))));
	ni0O0i <= (wire_niO_dataout AND ni0lli);
	ni0O1i <= (wire_nli1il_w_lg_w_lg_w_lg_dataout1604w1607w1608w(0) XOR wire_nli1il_w_lg_w_lg_dataout1604w1609w(0));
	ni0O1l <= (wire_n0ii_dataout AND wire_n00O_dataout);
	ni0O1O <= (ni0O1l OR ni0lOl);
	ni0Oil <= '1';
	nii00O <= (((wire_w_lg_w_lg_w_lg_d21_5_eq_n1w4w5w(0) AND wire_w_lg_w_tx_ctl_tc_range6w7w(0)) AND (nii0ii4 XOR nii0ii3)) AND k_det);
	nii1iO <= (wire_w35w(0) AND wire_ni0Oi_w_lg_n01il36w(0));
	nii1Ol <= (wire_w_lg_w22w23w(0) AND (nii1OO10 XOR nii1OO9));
	pudr <= ( nii1i & ni0Ol & ni0lO & ni0ll & ni0li & ni0iO & ni0il & ni0ii & ni00O & ni00l & ni00i & ni01O & ni01l & ni01i & ni1OO & ni1Ol & ni1Oi & ni1lO & ni1ll & n0lOi);
	tx_ctl_pre_en <= ( n01OO & n01Ol);
	tx_data_9_pre_en <= ( n01Oi & n01lO);
	tx_data_pre_en <= ( n0i1i & n00OO & n00Ol & n00Oi & n00lO & n00ll & n00li & n00iO & n00il & n00ii & n000O & n000l & n000i & n001O & n001l & n001i);
	txlp20b <= ( n0l0O & n0l0l & n0l0i & n0l1O & n0l1l & n0l1i & n0iOO & n0iOl & n0iOi & n0ilO & n0ill & n0ili & n0iiO & n0iil & n0iii & n0i0O & n0i0l & n0i0i & n0i1O & n0i1l);
	wire_w_tx_ctl_tc_range6w(0) <= tx_ctl_tc(0);
	wire_w_tx_data_9_tc_range1037w(0) <= tx_data_9_tc(0);
	wire_w_txd_extend_tc_range1035w(0) <= txd_extend_tc(0);
	wire_w_txd_extend_tc_range1042w(0) <= txd_extend_tc(1);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0O0l49 <= ni0O0l50;
		END IF;
		if (now = 0 ns) then
			ni0O0l49 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0O0l50 <= ni0O0l49;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0O0O47 <= ni0O0O48;
		END IF;
		if (now = 0 ns) then
			ni0O0O47 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0O0O48 <= ni0O0O47;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0Oii45 <= ni0Oii46;
		END IF;
		if (now = 0 ns) then
			ni0Oii45 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0Oii46 <= ni0Oii45;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OiO43 <= ni0OiO44;
		END IF;
		if (now = 0 ns) then
			ni0OiO43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OiO44 <= ni0OiO43;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0Oli41 <= ni0Oli42;
		END IF;
		if (now = 0 ns) then
			ni0Oli41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0Oli42 <= ni0Oli41;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0Oll39 <= ni0Oll40;
		END IF;
		if (now = 0 ns) then
			ni0Oll39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0Oll40 <= ni0Oll39;
		END IF;
	END PROCESS;
	wire_ni0Oll40_w_lg_w_lg_q202w203w(0) <= wire_ni0Oll40_w_lg_q202w(0) AND wire_n010i_w_lg_o200w(0);
	wire_ni0Oll40_w_lg_q202w(0) <= ni0Oll40 XOR ni0Oll39;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OlO37 <= ni0OlO38;
		END IF;
		if (now = 0 ns) then
			ni0OlO37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OlO38 <= ni0OlO37;
		END IF;
	END PROCESS;
	wire_ni0OlO38_w_lg_w_lg_q195w196w(0) <= wire_ni0OlO38_w_lg_q195w(0) AND wire_n010i_o;
	wire_ni0OlO38_w_lg_q195w(0) <= ni0OlO38 XOR ni0OlO37;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OOi35 <= ni0OOi36;
		END IF;
		if (now = 0 ns) then
			ni0OOi35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OOi36 <= ni0OOi35;
		END IF;
	END PROCESS;
	wire_ni0OOi36_w_lg_w_lg_q187w189w(0) <= wire_ni0OOi36_w_lg_q187w(0) AND wire_n010l_w_lg_o188w(0);
	wire_ni0OOi36_w_lg_q187w(0) <= ni0OOi36 XOR ni0OOi35;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OOl33 <= ni0OOl34;
		END IF;
		if (now = 0 ns) then
			ni0OOl33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OOl34 <= ni0OOl33;
		END IF;
	END PROCESS;
	wire_ni0OOl34_w_lg_w_lg_q160w161w(0) <= wire_ni0OOl34_w_lg_q160w(0) AND wire_n1O1O_w_lg_o108w(0);
	wire_ni0OOl34_w_lg_q160w(0) <= ni0OOl34 XOR ni0OOl33;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OOO31 <= ni0OOO32;
		END IF;
		if (now = 0 ns) then
			ni0OOO31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni0OOO32 <= ni0OOO31;
		END IF;
	END PROCESS;
	wire_ni0OOO32_w_lg_w_lg_q139w140w(0) <= wire_ni0OOO32_w_lg_q139w(0) AND wire_n1O0l_o;
	wire_ni0OOO32_w_lg_q139w(0) <= ni0OOO32 XOR ni0OOO31;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii00i5 <= nii00i6;
		END IF;
		if (now = 0 ns) then
			nii00i5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii00i6 <= nii00i5;
		END IF;
	END PROCESS;
	wire_nii00i6_w_lg_q15w(0) <= nii00i6 XOR nii00i5;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii01l7 <= nii01l8;
		END IF;
		if (now = 0 ns) then
			nii01l7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii01l8 <= nii01l7;
		END IF;
	END PROCESS;
	wire_nii01l8_w_lg_q21w(0) <= nii01l8 XOR nii01l7;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii0ii3 <= nii0ii4;
		END IF;
		if (now = 0 ns) then
			nii0ii3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii0ii4 <= nii0ii3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii0iO1 <= nii0iO2;
		END IF;
		if (now = 0 ns) then
			nii0iO1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii0iO2 <= nii0iO1;
		END IF;
	END PROCESS;
	wire_nii0iO2_w_lg_q3w(0) <= nii0iO2 XOR nii0iO1;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii10i23 <= nii10i24;
		END IF;
		if (now = 0 ns) then
			nii10i23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii10i24 <= nii10i23;
		END IF;
	END PROCESS;
	wire_nii10i24_w_lg_w_lg_q100w101w(0) <= wire_nii10i24_w_lg_q100w(0) AND n0lll;
	wire_nii10i24_w_lg_q100w(0) <= nii10i24 XOR nii10i23;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii10l21 <= nii10l22;
		END IF;
		if (now = 0 ns) then
			nii10l21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii10l22 <= nii10l21;
		END IF;
	END PROCESS;
	wire_nii10l22_w_lg_w_lg_q86w87w(0) <= wire_nii10l22_w_lg_q86w(0) AND n0liO;
	wire_nii10l22_w_lg_q86w(0) <= nii10l22 XOR nii10l21;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii10O19 <= nii10O20;
		END IF;
		if (now = 0 ns) then
			nii10O19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii10O20 <= nii10O19;
		END IF;
	END PROCESS;
	wire_nii10O20_w_lg_w_lg_q83w84w(0) <= wire_nii10O20_w_lg_q83w(0) AND wire_n1Oli_w_lg_o81w(0);
	wire_nii10O20_w_lg_q83w(0) <= nii10O20 XOR nii10O19;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii11i29 <= nii11i30;
		END IF;
		if (now = 0 ns) then
			nii11i29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii11i30 <= nii11i29;
		END IF;
	END PROCESS;
	wire_nii11i30_w_lg_w_lg_q132w134w(0) <= wire_nii11i30_w_lg_q132w(0) AND wire_n1O0l_w_lg_o133w(0);
	wire_nii11i30_w_lg_q132w(0) <= nii11i30 XOR nii11i29;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii11l27 <= nii11l28;
		END IF;
		if (now = 0 ns) then
			nii11l27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii11l28 <= nii11l27;
		END IF;
	END PROCESS;
	wire_nii11l28_w_lg_w_lg_q118w120w(0) <= wire_nii11l28_w_lg_q118w(0) AND wire_n1Oii_w_lg_o119w(0);
	wire_nii11l28_w_lg_q118w(0) <= nii11l28 XOR nii11l27;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii11O25 <= nii11O26;
		END IF;
		if (now = 0 ns) then
			nii11O25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii11O26 <= nii11O25;
		END IF;
	END PROCESS;
	wire_nii11O26_w_lg_w_lg_q115w116w(0) <= wire_nii11O26_w_lg_q115w(0) AND wire_n1O0i_o;
	wire_nii11O26_w_lg_q115w(0) <= nii11O26 XOR nii11O25;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1ii17 <= nii1ii18;
		END IF;
		if (now = 0 ns) then
			nii1ii17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1ii18 <= nii1ii17;
		END IF;
	END PROCESS;
	wire_nii1ii18_w_lg_w_lg_q75w76w(0) <= wire_nii1ii18_w_lg_q75w(0) AND n0lll;
	wire_nii1ii18_w_lg_q75w(0) <= nii1ii18 XOR nii1ii17;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1il15 <= nii1il16;
		END IF;
		if (now = 0 ns) then
			nii1il15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1il16 <= nii1il15;
		END IF;
	END PROCESS;
	wire_nii1il16_w_lg_w_lg_q67w68w(0) <= wire_nii1il16_w_lg_q67w(0) AND wire_n1Oll_o;
	wire_nii1il16_w_lg_q67w(0) <= nii1il16 XOR nii1il15;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1li13 <= nii1li14;
		END IF;
		if (now = 0 ns) then
			nii1li13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1li14 <= nii1li13;
		END IF;
	END PROCESS;
	wire_nii1li14_w_lg_q33w(0) <= nii1li14 XOR nii1li13;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1lO11 <= nii1lO12;
		END IF;
		if (now = 0 ns) then
			nii1lO11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1lO12 <= nii1lO11;
		END IF;
	END PROCESS;
	wire_nii1lO12_w_lg_q28w(0) <= nii1lO12 XOR nii1lO11;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1OO10 <= nii1OO9;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nii1OO9 <= nii1OO10;
		END IF;
		if (now = 0 ns) then
			nii1OO9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk, wire_n01iO_PRN, rst)
	BEGIN
		IF (wire_n01iO_PRN = '0') THEN
				n01li <= '1';
		ELSIF (rst = '1') THEN
				n01li <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
			IF (wire_n01iO_ENA = '1') THEN
				n01li <= ni0Oil;
			END IF;
		END IF;
	END PROCESS;
	wire_n01iO_ENA <= (wire_w_lg_ib_force_disparity1054w(0) AND wire_n01iO_w_lg_n01li1049w(0));
	wire_n01iO_PRN <= (ni0O0l50 XOR ni0O0l49);
	wire_n01iO_w_lg_n01li1049w(0) <= NOT n01li;
	PROCESS (clk, wire_ni0Oi_PRN, wire_ni0Oi_CLRN)
	BEGIN
		IF (wire_ni0Oi_PRN = '0') THEN
				n000i <= '1';
				n000l <= '1';
				n000O <= '1';
				n001i <= '1';
				n001l <= '1';
				n001O <= '1';
				n00ii <= '1';
				n00il <= '1';
				n00iO <= '1';
				n00li <= '1';
				n00ll <= '1';
				n00lO <= '1';
				n00Oi <= '1';
				n00Ol <= '1';
				n00OO <= '1';
				n01ii <= '1';
				n01il <= '1';
				n01lO <= '1';
				n01Oi <= '1';
				n01Ol <= '1';
				n01OO <= '1';
				n0i1i <= '1';
				n0i1l <= '1';
				n0i1O <= '1';
				n0iiO <= '1';
				n0ill <= '1';
				n0iOl <= '1';
				n0iOO <= '1';
				n0l0l <= '1';
				n0l1i <= '1';
				n0l1l <= '1';
				n0l1O <= '1';
				n0lii <= '1';
				n0lil <= '1';
				n0liO <= '1';
				n0lli <= '1';
				n0lll <= '1';
				n0llO <= '1';
				n0lOi <= '1';
				ni00i <= '1';
				ni01l <= '1';
				ni0ii <= '1';
				ni0il <= '1';
				ni0iO <= '1';
				ni0li <= '1';
				ni0ll <= '1';
				ni0Ol <= '1';
				ni1li <= '1';
				ni1ll <= '1';
				nii0Oi <= '1';
				nii0Ol <= '1';
				nii0OO <= '1';
				niii0i <= '1';
				niii0l <= '1';
				niii0O <= '1';
				niii1i <= '1';
				niii1l <= '1';
				niii1O <= '1';
				niiiii <= '1';
				niiiil <= '1';
				niiiiO <= '1';
				niiili <= '1';
				niiill <= '1';
				niiilO <= '1';
				niiiOi <= '1';
				niiiOl <= '1';
				niiiOO <= '1';
				niil1i <= '1';
		ELSIF (wire_ni0Oi_CLRN = '0') THEN
				n000i <= '0';
				n000l <= '0';
				n000O <= '0';
				n001i <= '0';
				n001l <= '0';
				n001O <= '0';
				n00ii <= '0';
				n00il <= '0';
				n00iO <= '0';
				n00li <= '0';
				n00ll <= '0';
				n00lO <= '0';
				n00Oi <= '0';
				n00Ol <= '0';
				n00OO <= '0';
				n01ii <= '0';
				n01il <= '0';
				n01lO <= '0';
				n01Oi <= '0';
				n01Ol <= '0';
				n01OO <= '0';
				n0i1i <= '0';
				n0i1l <= '0';
				n0i1O <= '0';
				n0iiO <= '0';
				n0ill <= '0';
				n0iOl <= '0';
				n0iOO <= '0';
				n0l0l <= '0';
				n0l1i <= '0';
				n0l1l <= '0';
				n0l1O <= '0';
				n0lii <= '0';
				n0lil <= '0';
				n0liO <= '0';
				n0lli <= '0';
				n0lll <= '0';
				n0llO <= '0';
				n0lOi <= '0';
				ni00i <= '0';
				ni01l <= '0';
				ni0ii <= '0';
				ni0il <= '0';
				ni0iO <= '0';
				ni0li <= '0';
				ni0ll <= '0';
				ni0Ol <= '0';
				ni1li <= '0';
				ni1ll <= '0';
				nii0Oi <= '0';
				nii0Ol <= '0';
				nii0OO <= '0';
				niii0i <= '0';
				niii0l <= '0';
				niii0O <= '0';
				niii1i <= '0';
				niii1l <= '0';
				niii1O <= '0';
				niiiii <= '0';
				niiiil <= '0';
				niiiiO <= '0';
				niiili <= '0';
				niiill <= '0';
				niiilO <= '0';
				niiiOi <= '0';
				niiiOl <= '0';
				niiiOO <= '0';
				niil1i <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n000i <= tx_data_tc(3);
				n000l <= tx_data_tc(4);
				n000O <= tx_data_tc(5);
				n001i <= tx_data_tc(0);
				n001l <= tx_data_tc(1);
				n001O <= tx_data_tc(2);
				n00ii <= tx_data_tc(6);
				n00il <= tx_data_tc(7);
				n00iO <= tx_data_tc(8);
				n00li <= tx_data_tc(9);
				n00ll <= tx_data_tc(10);
				n00lO <= tx_data_tc(11);
				n00Oi <= tx_data_tc(12);
				n00Ol <= tx_data_tc(13);
				n00OO <= tx_data_tc(14);
				n01ii <= rev_loopbk;
				n01il <= wire_n01ll_dataout;
				n01lO <= tx_data_9_tc(0);
				n01Oi <= tx_data_9_tc(1);
				n01Ol <= tx_ctl_tc(0);
				n01OO <= tx_ctl_tc(1);
				n0i1i <= tx_data_tc(15);
				n0i1l <= n0lOi;
				n0i1O <= ni1ll;
				n0iiO <= ni01l;
				n0ill <= ni00i;
				n0iOl <= ni0ii;
				n0iOO <= ni0il;
				n0l0l <= ni0Ol;
				n0l1i <= ni0iO;
				n0l1l <= ni0li;
				n0l1O <= ni0ll;
				n0lii <= n0lil;
				n0lil <= rensymswap_tx;
				n0liO <= n0lli;
				n0lli <= renbitrev_tx;
				n0lll <= n0llO;
				n0llO <= (renpolinv_tx AND enpolinv_tx);
				n0lOi <= wire_nii1l_dataout;
				ni00i <= wire_niill_dataout;
				ni01l <= wire_niiiO_dataout;
				ni0ii <= wire_niiOl_dataout;
				ni0il <= wire_niiOO_dataout;
				ni0iO <= wire_nil1i_dataout;
				ni0li <= wire_nil1l_dataout;
				ni0ll <= wire_nil1O_dataout;
				ni0Ol <= wire_nil0l_dataout;
				ni1li <= n01ii;
				ni1ll <= wire_nii1O_dataout;
				nii0Oi <= wire_niliO_o;
				nii0Ol <= wire_nilli_o;
				nii0OO <= wire_nilll_o;
				niii0i <= wire_nilOO_o;
				niii0l <= wire_niO1i_o;
				niii0O <= wire_niO1l_o;
				niii1i <= wire_nillO_o;
				niii1l <= wire_nilOi_o;
				niii1O <= wire_nilOl_o;
				niiiii <= wire_niO1O_o;
				niiiil <= wire_niO0i_o;
				niiiiO <= wire_niO0l_o;
				niiili <= wire_niO0O_o;
				niiill <= wire_niOii_o;
				niiilO <= wire_niOil_o;
				niiiOi <= wire_niOiO_o;
				niiiOl <= wire_niOli_o;
				niiiOO <= wire_niOll_o;
				niil1i <= wire_nilil_o;
		END IF;
	END PROCESS;
	wire_ni0Oi_CLRN <= ((ni0Oii46 XOR ni0Oii45) AND wire_w_lg_rst1030w(0));
	wire_ni0Oi_PRN <= (ni0O0O48 XOR ni0O0O47);
	wire_ni0Oi_w_lg_n01il36w(0) <= NOT n01il;
	PROCESS (clk, wire_ni0OO_PRN, wire_ni0OO_CLRN)
	BEGIN
		IF (wire_ni0OO_PRN = '0') THEN
				n0i0i <= '1';
				n0i0l <= '1';
				n0i0O <= '1';
				n0iii <= '1';
				n0iil <= '1';
				n0ili <= '1';
				n0ilO <= '1';
				n0iOi <= '1';
				n0l0i <= '1';
				n0l0O <= '1';
				ni00l <= '1';
				ni00O <= '1';
				ni01i <= '1';
				ni01O <= '1';
				ni0lO <= '1';
				ni1lO <= '1';
				ni1Oi <= '1';
				ni1Ol <= '1';
				ni1OO <= '1';
				nii1i <= '1';
		ELSIF (wire_ni0OO_CLRN = '0') THEN
				n0i0i <= '0';
				n0i0l <= '0';
				n0i0O <= '0';
				n0iii <= '0';
				n0iil <= '0';
				n0ili <= '0';
				n0ilO <= '0';
				n0iOi <= '0';
				n0l0i <= '0';
				n0l0O <= '0';
				ni00l <= '0';
				ni00O <= '0';
				ni01i <= '0';
				ni01O <= '0';
				ni0lO <= '0';
				ni1lO <= '0';
				ni1Oi <= '0';
				ni1Ol <= '0';
				ni1OO <= '0';
				nii1i <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n0i0i <= ni1lO;
				n0i0l <= ni1Oi;
				n0i0O <= ni1Ol;
				n0iii <= ni1OO;
				n0iil <= ni01i;
				n0ili <= ni01O;
				n0ilO <= ni00l;
				n0iOi <= ni00O;
				n0l0i <= ni0lO;
				n0l0O <= nii1i;
				ni00l <= wire_niilO_dataout;
				ni00O <= wire_niiOi_dataout;
				ni01i <= wire_niiil_dataout;
				ni01O <= wire_niili_dataout;
				ni0lO <= wire_nil0i_dataout;
				ni1lO <= wire_nii0i_dataout;
				ni1Oi <= wire_nii0l_dataout;
				ni1Ol <= wire_nii0O_dataout;
				ni1OO <= wire_niiii_dataout;
				nii1i <= wire_nil0O_dataout;
		END IF;
	END PROCESS;
	wire_ni0OO_CLRN <= (ni0Oli42 XOR ni0Oli41);
	wire_ni0OO_PRN <= ((ni0OiO44 XOR ni0OiO43) AND wire_w_lg_rst1030w(0));
	wire_n00i_dataout <= tx_data_tc(11) WHEN cascaded_8b10b_en = '1'  ELSE wire_ni0l_dataout;
	wire_n00i_w_lg_w_lg_dataout1617w1689w(0) <= wire_n00i_w_lg_dataout1617w(0) AND wire_n01O_w_lg_dataout1688w(0);
	wire_n00i_w_lg_w_lg_dataout1617w1640w(0) <= wire_n00i_w_lg_dataout1617w(0) AND wire_n01O_w_lg_dataout1639w(0);
	wire_n00i_w_lg_w_lg_dataout1617w1698w(0) <= wire_n00i_w_lg_dataout1617w(0) AND ni0l1i;
	wire_n00i_w_lg_dataout1751w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_w_lg_dataout1619w1750w(0);
	wire_n00i_w_lg_dataout1746w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_w_lg_dataout1619w1745w(0);
	wire_n00i_w_lg_dataout1737w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_w_lg_dataout1619w1736w(0);
	wire_n00i_w_lg_dataout1734w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_w_lg_dataout1619w1733w(0);
	wire_n00i_w_lg_dataout1642w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_w_lg_dataout1619w1641w(0);
	wire_n00i_w_lg_dataout1633w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_w_lg_dataout1619w1632w(0);
	wire_n00i_w_lg_dataout1740w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_dataout1739w(0);
	wire_n00i_w_lg_dataout1645w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_dataout1644w(0);
	wire_n00i_w_lg_dataout1648w(0) <= wire_n00i_dataout AND wire_n01O_w_lg_dataout1647w(0);
	wire_n00i_w_lg_dataout1617w(0) <= NOT wire_n00i_dataout;
	wire_n00i_w_lg_w_lg_w_lg_dataout1617w1689w1691w(0) <= wire_n00i_w_lg_w_lg_dataout1617w1689w(0) OR wire_n00l_w_lg_dataout1690w(0);
	wire_n00i_w_lg_w_lg_w_lg_dataout1617w1640w1643w(0) <= wire_n00i_w_lg_w_lg_dataout1617w1640w(0) OR wire_n00i_w_lg_dataout1642w(0);
	wire_n00i_w_lg_w_lg_w_lg_dataout1617w1698w1699w(0) <= wire_n00i_w_lg_w_lg_dataout1617w1698w(0) OR ni0l0O;
	wire_n00i_w_lg_w_lg_w_lg_w_lg_dataout1617w1689w1691w1693w(0) <= wire_n00i_w_lg_w_lg_w_lg_dataout1617w1689w1691w(0) OR wire_n00l_w_lg_dataout1692w(0);
	wire_n00i_w_lg_w_lg_w_lg_w_lg_dataout1617w1640w1643w1646w(0) <= wire_n00i_w_lg_w_lg_w_lg_dataout1617w1640w1643w(0) OR wire_n00i_w_lg_dataout1645w(0);
	wire_n00i_w1695w(0) <= wire_n00i_w_lg_w_lg_w_lg_w_lg_dataout1617w1689w1691w1693w(0) OR wire_n00l_w_lg_dataout1694w(0);
	wire_n00i_w1649w(0) <= wire_n00i_w_lg_w_lg_w_lg_w_lg_dataout1617w1640w1643w1646w(0) OR wire_n00i_w_lg_dataout1648w(0);
	wire_n00i_w_lg_w1695w1696w(0) <= wire_n00i_w1695w(0) OR ni0iOl;
	wire_n00l_dataout <= tx_data_tc(12) WHEN cascaded_8b10b_en = '1'  ELSE wire_ni0O_dataout;
	wire_n00l_w_lg_w_lg_w_lg_dataout1637w1638w1650w(0) <= wire_n00l_w_lg_w_lg_dataout1637w1638w(0) AND wire_n00i_w1649w(0);
	wire_n00l_w_lg_w_lg_dataout1719w1720w(0) <= wire_n00l_w_lg_dataout1719w(0) AND wire_n01O_dataout;
	wire_n00l_w_lg_w_lg_dataout1637w1700w(0) <= wire_n00l_w_lg_dataout1637w(0) AND wire_n00i_w_lg_w_lg_w_lg_dataout1617w1698w1699w(0);
	wire_n00l_w_lg_w_lg_dataout1637w1638w(0) <= wire_n00l_w_lg_dataout1637w(0) AND wire_n00i_dataout;
	wire_n00l_w_lg_w_lg_w_lg_dataout1637w1679w1680w(0) <= wire_n00l_w_lg_w_lg_dataout1637w1679w(0) AND ni0l1l;
	wire_n00l_w_lg_dataout1685w(0) <= wire_n00l_dataout AND wire_w_lg_w_lg_w_lg_ni0l1i1681w1683w1684w(0);
	wire_n00l_w_lg_dataout1618w(0) <= wire_n00l_dataout AND wire_n00i_w_lg_dataout1617w(0);
	wire_n00l_w_lg_dataout1719w(0) <= wire_n00l_dataout AND wire_n00i_dataout;
	wire_n00l_w_lg_dataout1694w(0) <= wire_n00l_dataout AND ni0l1i;
	wire_n00l_w_lg_dataout1692w(0) <= wire_n00l_dataout AND ni0lii;
	wire_n00l_w_lg_dataout1690w(0) <= wire_n00l_dataout AND ni0lil;
	wire_n00l_w_lg_dataout1637w(0) <= NOT wire_n00l_dataout;
	wire_n00l_w_lg_w_lg_dataout1637w1679w(0) <= wire_n00l_w_lg_dataout1637w(0) OR wire_nliO1l_dataout;
	wire_n00O_dataout <= tx_data_tc(13) WHEN cascaded_8b10b_en = '1'  ELSE wire_niii_dataout;
	wire_n00O_w_lg_dataout1663w(0) <= NOT wire_n00O_dataout;
	wire_n01i_dataout <= tx_data_tc(8) WHEN cascaded_8b10b_en = '1'  ELSE wire_ni1l_dataout;
	wire_n01i_w_lg_dataout1624w(0) <= NOT wire_n01i_dataout;
	wire_n01l_dataout <= tx_data_tc(9) WHEN cascaded_8b10b_en = '1'  ELSE wire_ni1O_dataout;
	wire_n01l_w_lg_w_lg_dataout1620w1666w(0) <= wire_n01l_w_lg_dataout1620w(0) AND wire_n01i_w_lg_dataout1624w(0);
	wire_n01l_w_lg_w_lg_dataout1620w1621w(0) <= wire_n01l_w_lg_dataout1620w(0) AND wire_n01i_dataout;
	wire_n01l_w_lg_dataout1625w(0) <= wire_n01l_dataout AND wire_n01i_w_lg_dataout1624w(0);
	wire_n01l_w_lg_dataout1667w(0) <= wire_n01l_dataout AND wire_n01i_dataout;
	wire_n01l_w_lg_dataout1620w(0) <= NOT wire_n01l_dataout;
	wire_n01l_w_lg_dataout1676w(0) <= wire_n01l_dataout OR wire_n01i_dataout;
	wire_n01ll_dataout <= wire_nlli1i_dataout WHEN cascaded_8b10b_en = '1'  ELSE wire_nl010O_dataout;
	wire_n01O_dataout <= tx_data_tc(10) WHEN cascaded_8b10b_en = '1'  ELSE wire_ni0i_dataout;
	wire_n01O_w_lg_w_lg_dataout1619w1750w(0) <= wire_n01O_w_lg_dataout1619w(0) AND ni0iil;
	wire_n01O_w_lg_w_lg_dataout1619w1745w(0) <= wire_n01O_w_lg_dataout1619w(0) AND ni0iiO;
	wire_n01O_w_lg_w_lg_dataout1619w1736w(0) <= wire_n01O_w_lg_dataout1619w(0) AND ni0ili;
	wire_n01O_w_lg_w_lg_dataout1619w1733w(0) <= wire_n01O_w_lg_dataout1619w(0) AND ni0ill;
	wire_n01O_w_lg_w_lg_dataout1619w1641w(0) <= wire_n01O_w_lg_dataout1619w(0) AND ni0lll;
	wire_n01O_w_lg_w_lg_dataout1619w1632w(0) <= wire_n01O_w_lg_dataout1619w(0) AND ni0llO;
	wire_n01O_w_lg_dataout1739w(0) <= wire_n01O_dataout AND wire_n01l_w_lg_w_lg_dataout1620w1666w(0);
	wire_n01O_w_lg_dataout1644w(0) <= wire_n01O_dataout AND wire_n01l_w_lg_w_lg_dataout1620w1621w(0);
	wire_n01O_w_lg_dataout1647w(0) <= wire_n01O_dataout AND wire_n01l_w_lg_dataout1625w(0);
	wire_n01O_w_lg_dataout1688w(0) <= wire_n01O_dataout AND wire_n01l_w_lg_dataout1667w(0);
	wire_n01O_w_lg_dataout1639w(0) <= wire_n01O_dataout AND ni0lll;
	wire_n01O_w_lg_dataout1619w(0) <= NOT wire_n01O_dataout;
	wire_n01O_w_lg_dataout1677w(0) <= wire_n01O_dataout OR wire_n01l_w_lg_dataout1676w(0);
	wire_n0ii_dataout <= tx_data_tc(14) WHEN cascaded_8b10b_en = '1'  ELSE wire_niil_dataout;
	wire_n0ii_w_lg_dataout1654w(0) <= wire_n0ii_dataout AND wire_niO_w_lg_dataout1653w(0);
	wire_n0ii_w_lg_dataout1616w(0) <= NOT wire_n0ii_dataout;
	wire_n0il_dataout <= tx_data_tc(15) WHEN cascaded_8b10b_en = '1'  ELSE wire_niiO_dataout;
	wire_n0il_w_lg_dataout1655w(0) <= wire_n0il_dataout AND wire_n0ii_w_lg_dataout1654w(0);
	wire_n0il_w_lg_dataout1612w(0) <= NOT wire_n0il_dataout;
	wire_n0iO_dataout <= wire_nili_dataout AND NOT(nii1Ol);
	wire_n0li_dataout <= wire_nill_dataout AND NOT(nii1Ol);
	wire_n0ll_dataout <= wire_nilO_dataout AND NOT(nii1Ol);
	wire_n0lO_dataout <= wire_niOi_dataout AND NOT(nii1Ol);
	wire_n0O_dataout <= tx_ctl_tc(0) WHEN rendec_data_sel_tx = '1'  ELSE tx_ctl_ts;
	wire_n0O0i_dataout <= ((wire_n01iO_w_lg_n01li1049w(0) AND tx_data_9_tc(0)) OR n01il) WHEN ib_force_disparity = '1'  ELSE wire_n0O0l_dataout;
	wire_n0O0l_dataout <= wire_n0O0O_dataout OR (wire_w_lg_rforce_disp1040w(0) AND tx_data_9_tc(0));
	wire_n0O0O_dataout <= n01il AND NOT((wire_w_lg_rforce_disp1036w(0) AND tx_data_9_tc(0)));
	wire_n0O1l_dataout <= wire_ni10i_dataout WHEN cascaded_8b10b_en = '1'  ELSE wire_n0O0i_dataout;
	wire_n0O1l_w_lg_dataout1848w(0) <= NOT wire_n0O1l_dataout;
	wire_n0O1O_dataout <= wire_n0OOi_dataout WHEN cascaded_8b10b_en = '1'  ELSE wire_nl010O_dataout;
	wire_n0O1O_w_lg_dataout1697w(0) <= NOT wire_n0O1O_dataout;
	wire_n0Oi_dataout <= wire_niOl_dataout OR nii1Ol;
	wire_n0Ol_dataout <= wire_niOO_dataout AND NOT(nii1Ol);
	wire_n0OO_dataout <= wire_nl1i_dataout OR nii1Ol;
	wire_n0OOi_dataout <= wire_n0OOl_dataout OR (wire_w_lg_rforce_disp1047w(0) AND tx_data_9_tc(1));
	wire_n0OOl_dataout <= wire_nl010O_dataout AND NOT((wire_w_lg_rforce_disp1043w(0) AND tx_data_9_tc(1)));
	wire_n10i_dataout <= tx_data_tc(12) AND rendec_data_sel_tx;
	wire_n10l_dataout <= tx_data_tc(13) AND rendec_data_sel_tx;
	wire_n10O_dataout <= tx_data_tc(14) AND rendec_data_sel_tx;
	wire_n11i_dataout <= tx_data_tc(9) AND rendec_data_sel_tx;
	wire_n11l_dataout <= tx_data_tc(10) AND rendec_data_sel_tx;
	wire_n11O_dataout <= tx_data_tc(11) AND rendec_data_sel_tx;
	wire_n1ii_dataout <= tx_data_tc(15) AND rendec_data_sel_tx;
	wire_n1il_dataout <= tx_data_tc(0) WHEN cascaded_8b10b_en = '1'  ELSE wire_n0iO_dataout;
	wire_n1il_w_lg_dataout1775w(0) <= NOT wire_n1il_dataout;
	wire_n1iO_dataout <= tx_data_tc(1) WHEN cascaded_8b10b_en = '1'  ELSE wire_n0li_dataout;
	wire_n1iO_w_lg_w_lg_dataout1771w1817w(0) <= wire_n1iO_w_lg_dataout1771w(0) AND wire_n1il_w_lg_dataout1775w(0);
	wire_n1iO_w_lg_w_lg_dataout1771w1772w(0) <= wire_n1iO_w_lg_dataout1771w(0) AND wire_n1il_dataout;
	wire_n1iO_w_lg_dataout1776w(0) <= wire_n1iO_dataout AND wire_n1il_w_lg_dataout1775w(0);
	wire_n1iO_w_lg_dataout1818w(0) <= wire_n1iO_dataout AND wire_n1il_dataout;
	wire_n1iO_w_lg_dataout1771w(0) <= NOT wire_n1iO_dataout;
	wire_n1iO_w_lg_dataout1827w(0) <= wire_n1iO_dataout OR wire_n1il_dataout;
	wire_n1li_dataout <= tx_data_tc(2) WHEN cascaded_8b10b_en = '1'  ELSE wire_n0ll_dataout;
	wire_n1li_w_lg_w_lg_dataout1770w1792w(0) <= wire_n1li_w_lg_dataout1770w(0) AND ni00Ol;
	wire_n1li_w_lg_w_lg_dataout1770w1783w(0) <= wire_n1li_w_lg_dataout1770w(0) AND ni00OO;
	wire_n1li_w_lg_w_lg_dataout1770w1901w(0) <= wire_n1li_w_lg_dataout1770w(0) AND ni01ll;
	wire_n1li_w_lg_w_lg_dataout1770w1896w(0) <= wire_n1li_w_lg_dataout1770w(0) AND ni01lO;
	wire_n1li_w_lg_w_lg_dataout1770w1887w(0) <= wire_n1li_w_lg_dataout1770w(0) AND ni01Oi;
	wire_n1li_w_lg_w_lg_dataout1770w1884w(0) <= wire_n1li_w_lg_dataout1770w(0) AND ni01Ol;
	wire_n1li_w_lg_dataout1890w(0) <= wire_n1li_dataout AND wire_n1iO_w_lg_w_lg_dataout1771w1817w(0);
	wire_n1li_w_lg_dataout1795w(0) <= wire_n1li_dataout AND wire_n1iO_w_lg_w_lg_dataout1771w1772w(0);
	wire_n1li_w_lg_dataout1798w(0) <= wire_n1li_dataout AND wire_n1iO_w_lg_dataout1776w(0);
	wire_n1li_w_lg_dataout1839w(0) <= wire_n1li_dataout AND wire_n1iO_w_lg_dataout1818w(0);
	wire_n1li_w_lg_dataout1790w(0) <= wire_n1li_dataout AND ni00Ol;
	wire_n1li_w_lg_dataout1770w(0) <= NOT wire_n1li_dataout;
	wire_n1li_w_lg_dataout1828w(0) <= wire_n1li_dataout OR wire_n1iO_w_lg_dataout1827w(0);
	wire_n1ll_dataout <= tx_data_tc(3) WHEN cascaded_8b10b_en = '1'  ELSE wire_n0lO_dataout;
	wire_n1ll_w_lg_w_lg_dataout1768w1840w(0) <= wire_n1ll_w_lg_dataout1768w(0) AND wire_n1li_w_lg_dataout1839w(0);
	wire_n1ll_w_lg_w_lg_dataout1768w1791w(0) <= wire_n1ll_w_lg_dataout1768w(0) AND wire_n1li_w_lg_dataout1790w(0);
	wire_n1ll_w_lg_w_lg_dataout1768w1849w(0) <= wire_n1ll_w_lg_dataout1768w(0) AND ni000i;
	wire_n1ll_w_lg_dataout1793w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_w_lg_dataout1770w1792w(0);
	wire_n1ll_w_lg_dataout1784w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_w_lg_dataout1770w1783w(0);
	wire_n1ll_w_lg_dataout1902w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_w_lg_dataout1770w1901w(0);
	wire_n1ll_w_lg_dataout1897w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_w_lg_dataout1770w1896w(0);
	wire_n1ll_w_lg_dataout1888w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_w_lg_dataout1770w1887w(0);
	wire_n1ll_w_lg_dataout1885w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_w_lg_dataout1770w1884w(0);
	wire_n1ll_w_lg_dataout1891w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_dataout1890w(0);
	wire_n1ll_w_lg_dataout1796w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_dataout1795w(0);
	wire_n1ll_w_lg_dataout1799w(0) <= wire_n1ll_dataout AND wire_n1li_w_lg_dataout1798w(0);
	wire_n1ll_w_lg_dataout1768w(0) <= NOT wire_n1ll_dataout;
	wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1840w1842w(0) <= wire_n1ll_w_lg_w_lg_dataout1768w1840w(0) OR wire_n1lO_w_lg_dataout1841w(0);
	wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1791w1794w(0) <= wire_n1ll_w_lg_w_lg_dataout1768w1791w(0) OR wire_n1ll_w_lg_dataout1793w(0);
	wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1849w1850w(0) <= wire_n1ll_w_lg_w_lg_dataout1768w1849w(0) OR ni00iO;
	wire_n1ll_w_lg_w_lg_w_lg_w_lg_dataout1768w1840w1842w1844w(0) <= wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1840w1842w(0) OR wire_n1lO_w_lg_dataout1843w(0);
	wire_n1ll_w_lg_w_lg_w_lg_w_lg_dataout1768w1791w1794w1797w(0) <= wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1791w1794w(0) OR wire_n1ll_w_lg_dataout1796w(0);
	wire_n1ll_w1846w(0) <= wire_n1ll_w_lg_w_lg_w_lg_w_lg_dataout1768w1840w1842w1844w(0) OR wire_n1lO_w_lg_dataout1845w(0);
	wire_n1ll_w1800w(0) <= wire_n1ll_w_lg_w_lg_w_lg_w_lg_dataout1768w1791w1794w1797w(0) OR wire_n1ll_w_lg_dataout1799w(0);
	wire_n1ll_w_lg_w1846w1847w(0) <= wire_n1ll_w1846w(0) OR ni001l;
	wire_n1lO_dataout <= tx_data_tc(4) WHEN cascaded_8b10b_en = '1'  ELSE wire_n0Oi_dataout;
	wire_n1lO_w_lg_w_lg_w_lg_dataout1788w1789w1801w(0) <= wire_n1lO_w_lg_w_lg_dataout1788w1789w(0) AND wire_n1ll_w1800w(0);
	wire_n1lO_w_lg_w_lg_dataout1870w1871w(0) <= wire_n1lO_w_lg_dataout1870w(0) AND wire_n1li_dataout;
	wire_n1lO_w_lg_w_lg_dataout1788w1851w(0) <= wire_n1lO_w_lg_dataout1788w(0) AND wire_n1ll_w_lg_w_lg_w_lg_dataout1768w1849w1850w(0);
	wire_n1lO_w_lg_w_lg_dataout1788w1789w(0) <= wire_n1lO_w_lg_dataout1788w(0) AND wire_n1ll_dataout;
	wire_n1lO_w_lg_w_lg_w_lg_dataout1788w1830w1831w(0) <= wire_n1lO_w_lg_w_lg_dataout1788w1830w(0) AND ni000l;
	wire_n1lO_w_lg_dataout1836w(0) <= wire_n1lO_dataout AND wire_w_lg_w_lg_w_lg_ni000i1832w1834w1835w(0);
	wire_n1lO_w_lg_dataout1769w(0) <= wire_n1lO_dataout AND wire_n1ll_w_lg_dataout1768w(0);
	wire_n1lO_w_lg_dataout1870w(0) <= wire_n1lO_dataout AND wire_n1ll_dataout;
	wire_n1lO_w_lg_dataout1845w(0) <= wire_n1lO_dataout AND ni000i;
	wire_n1lO_w_lg_dataout1843w(0) <= wire_n1lO_dataout AND ni00li;
	wire_n1lO_w_lg_dataout1841w(0) <= wire_n1lO_dataout AND ni00ll;
	wire_n1lO_w_lg_dataout1788w(0) <= NOT wire_n1lO_dataout;
	wire_n1lO_w_lg_w_lg_dataout1788w1830w(0) <= wire_n1lO_w_lg_dataout1788w(0) OR wire_nl1iii_dataout;
	wire_n1Oi_dataout <= tx_data_tc(5) WHEN cascaded_8b10b_en = '1'  ELSE wire_n0Ol_dataout;
	wire_n1Oi_w_lg_dataout1814w(0) <= NOT wire_n1Oi_dataout;
	wire_n1Ol_dataout <= tx_data_tc(6) WHEN cascaded_8b10b_en = '1'  ELSE wire_n0OO_dataout;
	wire_n1Ol_w_lg_dataout1805w(0) <= wire_n1Ol_dataout AND wire_nil_w_lg_dataout1804w(0);
	wire_n1Ol_w_lg_dataout1767w(0) <= NOT wire_n1Ol_dataout;
	wire_n1OO_dataout <= tx_data_tc(7) WHEN cascaded_8b10b_en = '1'  ELSE wire_ni1i_dataout;
	wire_n1OO_w_lg_dataout1806w(0) <= wire_n1OO_dataout AND wire_n1Ol_w_lg_dataout1805w(0);
	wire_n1OO_w_lg_dataout1763w(0) <= NOT wire_n1OO_dataout;
	wire_ni0i_dataout <= wire_nl0l_dataout AND NOT(nii1Ol);
	wire_ni0l_dataout <= wire_nl0O_dataout AND NOT(nii1Ol);
	wire_ni0O_dataout <= wire_nlii_dataout AND NOT(nii1Ol);
	wire_ni10i_dataout <= wire_ni10l_dataout OR (wire_w_lg_rforce_disp1040w(0) AND tx_data_9_tc(0));
	wire_ni10l_dataout <= n01il AND NOT((wire_w_lg_rforce_disp1036w(0) AND tx_data_9_tc(0)));
	wire_ni1i_dataout <= wire_nl1l_dataout AND NOT(nii1Ol);
	wire_ni1l_dataout <= wire_nl1O_dataout AND NOT(nii1Ol);
	wire_ni1O_dataout <= wire_nl0i_dataout AND NOT(nii1Ol);
	wire_nii_dataout <= tx_ctl_tc(1) AND rendec_data_sel_tx;
	wire_nii0i_dataout <= wire_niil0i_o WHEN rtxbitslip_en = '1'  ELSE wire_niliO_o;
	wire_nii0l_dataout <= wire_niil0l_o WHEN rtxbitslip_en = '1'  ELSE wire_nilli_o;
	wire_nii0O_dataout <= wire_niil0O_o WHEN rtxbitslip_en = '1'  ELSE wire_nilll_o;
	wire_nii1l_dataout <= wire_niil1l_o WHEN rtxbitslip_en = '1'  ELSE wire_nilii_o;
	wire_nii1O_dataout <= wire_niil1O_o WHEN rtxbitslip_en = '1'  ELSE wire_nilil_o;
	wire_niii_dataout <= wire_nlil_dataout AND NOT(nii1Ol);
	wire_niiii_dataout <= wire_niilii_o WHEN rtxbitslip_en = '1'  ELSE wire_nillO_o;
	wire_niiil_dataout <= wire_niilil_o WHEN rtxbitslip_en = '1'  ELSE wire_nilOi_o;
	wire_niiiO_dataout <= wire_niiliO_o WHEN rtxbitslip_en = '1'  ELSE wire_nilOl_o;
	wire_niil_dataout <= wire_nliO_dataout AND NOT(nii1Ol);
	wire_niili_dataout <= wire_niilli_o WHEN rtxbitslip_en = '1'  ELSE wire_nilOO_o;
	wire_niill_dataout <= wire_niilll_o WHEN rtxbitslip_en = '1'  ELSE wire_niO1i_o;
	wire_niilO_dataout <= wire_niillO_o WHEN rtxbitslip_en = '1'  ELSE wire_niO1l_o;
	wire_niiO_dataout <= wire_nlli_dataout AND NOT(nii1Ol);
	wire_niiOi_dataout <= wire_niilOi_o WHEN rtxbitslip_en = '1'  ELSE wire_niO1O_o;
	wire_niiOl_dataout <= wire_niilOl_o WHEN rtxbitslip_en = '1'  ELSE wire_niO0i_o;
	wire_niiOO_dataout <= wire_niilOO_o WHEN rtxbitslip_en = '1'  ELSE wire_niO0l_o;
	wire_nil_dataout <= tx_ctl_tc(0) WHEN cascaded_8b10b_en = '1'  ELSE wire_nli_dataout;
	wire_nil_w_lg_dataout1804w(0) <= wire_nil_dataout AND wire_n1Oi_dataout;
	wire_nil00l_dataout <= wire_nilOO_o AND NOT(ni01il);
	wire_nil00O_dataout <= wire_niO1i_o AND NOT(ni01il);
	wire_nil0i_dataout <= wire_niiO0i_o WHEN rtxbitslip_en = '1'  ELSE wire_niOiO_o;
	wire_nil0l_dataout <= wire_niiO0l_o WHEN rtxbitslip_en = '1'  ELSE wire_niOli_o;
	wire_nil0O_dataout <= wire_niiO0O_o WHEN rtxbitslip_en = '1'  ELSE wire_niOll_o;
	wire_nil0OO_dataout <= wire_niOli_o AND NOT(ni01il);
	wire_nil1i_dataout <= wire_niiO1i_o WHEN rtxbitslip_en = '1'  ELSE wire_niO0O_o;
	wire_nil1l_dataout <= wire_niiO1l_o WHEN rtxbitslip_en = '1'  ELSE wire_niOii_o;
	wire_nil1O_dataout <= wire_niiO1O_o WHEN rtxbitslip_en = '1'  ELSE wire_niOil_o;
	wire_nili_dataout <= wire_nlOii_dataout OR nii1iO;
	wire_nili1i_dataout <= wire_niOll_o AND NOT(ni01il);
	wire_niliOl_dataout <= wire_niO1l_o AND ni01iO;
	wire_niliOO_dataout <= wire_niO1O_o AND ni01iO;
	wire_nill_dataout <= wire_nlOil_dataout AND NOT(nii1iO);
	wire_nill0i_dataout <= wire_niOii_o AND ni01iO;
	wire_nill0l_dataout <= wire_niOil_o AND ni01iO;
	wire_nill0O_dataout <= wire_niOiO_o AND ni01iO;
	wire_nill1i_dataout <= wire_niO0i_o AND ni01iO;
	wire_nill1l_dataout <= wire_niO0l_o AND ni01iO;
	wire_nill1O_dataout <= wire_niO0O_o AND ni01iO;
	wire_nillii_dataout <= wire_niOli_o AND ni01iO;
	wire_nillil_dataout <= wire_niOll_o AND ni01iO;
	wire_nilO_dataout <= wire_nlOiO_dataout OR nii1iO;
	wire_nilO0i_dataout <= wire_nilOO_o AND NOT(ni01li);
	wire_nilO0l_dataout <= wire_niO1i_o AND NOT(ni01li);
	wire_nilO0O_dataout <= wire_niO1l_o AND NOT(ni01li);
	wire_nilOii_dataout <= wire_niO1O_o AND NOT(ni01li);
	wire_nilOil_dataout <= wire_niO0i_o AND NOT(ni01li);
	wire_nilOiO_dataout <= wire_niO0l_o AND NOT(ni01li);
	wire_nilOli_dataout <= wire_niO0O_o AND NOT(ni01li);
	wire_nilOll_dataout <= wire_niOii_o AND NOT(ni01li);
	wire_nilOlO_dataout <= wire_niOil_o AND NOT(ni01li);
	wire_nilOOi_dataout <= wire_niOiO_o AND NOT(ni01li);
	wire_nilOOl_dataout <= wire_niOli_o AND NOT(ni01li);
	wire_nilOOO_dataout <= wire_niOll_o AND NOT(ni01li);
	wire_niO_dataout <= tx_ctl_tc(1) WHEN cascaded_8b10b_en = '1'  ELSE wire_nll_dataout;
	wire_niO_w_lg_dataout1653w(0) <= wire_niO_dataout AND wire_n00O_dataout;
	wire_niOi_dataout <= wire_nlOli_dataout AND NOT(nii1iO);
	wire_niOl_dataout <= wire_nlOll_dataout AND NOT(nii1iO);
	wire_niOlOi_dataout <= wire_n0O1l_w_lg_dataout1848w(0) WHEN ((ni00il OR ((wire_nl1iii_dataout OR ni00ll) OR ni00li)) OR ni001i) = '1'  ELSE wire_n0O1l_dataout;
	wire_niOlOi_w_lg_w_lg_dataout1755w1758w(0) <= wire_niOlOi_w_lg_dataout1755w(0) AND wire_nl00ll_w_lg_dataout1757w(0);
	wire_niOlOi_w_lg_w_lg_dataout1755w1760w(0) <= wire_niOlOi_w_lg_dataout1755w(0) AND ni0i0O;
	wire_niOlOi_w_lg_dataout1802w(0) <= wire_niOlOi_dataout AND wire_n1lO_w_lg_w_lg_w_lg_dataout1788w1789w1801w(0);
	wire_niOlOi_w_lg_dataout1755w(0) <= NOT wire_niOlOi_dataout;
	wire_niOlOi_w_lg_w_lg_w_lg_dataout1755w1758w1759w(0) <= wire_niOlOi_w_lg_w_lg_dataout1755w1758w(0) OR ni0i0l;
	wire_niOO_dataout <= wire_nlOlO_dataout AND NOT(nii1iO);
	wire_niOOOi_dataout <= wire_n1il_w_lg_dataout1775w(0) WHEN ni01OO = '1'  ELSE wire_n1il_dataout;
	wire_niOOOl_dataout <= wire_nl1i0O_w_lg_dataout1861w(0) WHEN ni01OO = '1'  ELSE wire_nl1i0O_dataout;
	wire_niOOOO_dataout <= wire_nl10OO_w_lg_dataout1860w(0) WHEN ni01OO = '1'  ELSE wire_nl10OO_dataout;
	wire_nl000i_dataout <= wire_n1OO_w_lg_dataout1763w(0) WHEN ni0i0i = '1'  ELSE wire_n1OO_dataout;
	wire_nl000l_dataout <= wire_nl01iO_w_lg_dataout1762w(0) WHEN ni0i0i = '1'  ELSE wire_nl01iO_dataout;
	wire_nl001i_dataout <= wire_n1Oi_dataout AND NOT(ni0i1O);
	wire_nl001i_w_lg_dataout1765w(0) <= NOT wire_nl001i_dataout;
	wire_nl001l_dataout <= wire_nl001i_w_lg_dataout1765w(0) WHEN ni0i0i = '1'  ELSE wire_nl001i_dataout;
	wire_nl001O_dataout <= wire_nl01Ol_w_lg_dataout1764w(0) WHEN ni0i0i = '1'  ELSE wire_nl01Ol_dataout;
	wire_nl00ll_dataout <= ni0iii WHEN r8b10b_enc_ibm_en = '1'  ELSE wire_nil_dataout;
	wire_nl00ll_w_lg_dataout1757w(0) <= wire_nl00ll_dataout AND wire_w_lg_ni0i0O1756w(0);
	wire_nl010O_dataout <= wire_niOlOi_w_lg_dataout1755w(0) WHEN (ni0i1i OR (wire_n1OO_dataout AND ni0i0O)) = '1'  ELSE wire_niOlOi_dataout;
	wire_nl01iO_dataout <= wire_nl01li_dataout OR ni0i1O;
	wire_nl01iO_w_lg_dataout1762w(0) <= NOT wire_nl01iO_dataout;
	wire_nl01li_dataout <= wire_w_lg_ni0i0O1756w(0) AND NOT(wire_n1OO_dataout);
	wire_nl01Ol_dataout <= wire_n1Ol_w_lg_dataout1767w(0) WHEN ni0i1i = '1'  ELSE wire_n1Ol_dataout;
	wire_nl01Ol_w_lg_dataout1764w(0) <= NOT wire_nl01Ol_dataout;
	wire_nl0i_dataout <= wire_n11i_dataout AND NOT(nii1iO);
	wire_nl0l_dataout <= wire_n11l_dataout AND NOT(nii1iO);
	wire_nl0O_dataout <= wire_n11O_dataout AND NOT(nii1iO);
	wire_nl10Ol_dataout <= wire_n1ll_w_lg_dataout1768w(0) WHEN ni00li = '1'  ELSE wire_n1ll_dataout;
	wire_nl10Ol_w_lg_dataout1859w(0) <= NOT wire_nl10Ol_dataout;
	wire_nl10OO_dataout <= wire_n1li_w_lg_dataout1770w(0) WHEN ((wire_n1lO_dataout AND (wire_n1ll_dataout AND (wire_n1li_w_lg_dataout1770w(0) AND wire_n1iO_w_lg_w_lg_dataout1771w1817w(0)))) OR ni00ll) = '1'  ELSE wire_n1li_dataout;
	wire_nl10OO_w_lg_dataout1860w(0) <= NOT wire_nl10OO_dataout;
	wire_nl111i_dataout <= wire_nl10Ol_w_lg_dataout1859w(0) WHEN ni01OO = '1'  ELSE wire_nl10Ol_dataout;
	wire_nl111l_dataout <= wire_w_lg_ni000O1858w(0) WHEN ni01OO = '1'  ELSE ni000O;
	wire_nl111O_dataout <= wire_w_lg_ni001O1857w(0) WHEN ni01OO = '1'  ELSE ni001O;
	wire_nl1i_dataout <= wire_nlOOi_dataout OR nii1iO;
	wire_nl1i0O_dataout <= wire_n1iO_w_lg_dataout1771w(0) WHEN ni00lO = '1'  ELSE wire_n1iO_dataout;
	wire_nl1i0O_w_lg_dataout1861w(0) <= NOT wire_nl1i0O_dataout;
	wire_nl1iii_dataout <= ni0iii WHEN r8b10b_enc_ibm_en = '1'  ELSE wire_nil_dataout;
	wire_nl1l_dataout <= wire_nlOOl_dataout OR nii1iO;
	wire_nl1O_dataout <= wire_nlOOO_dataout AND NOT(nii1iO);
	wire_nli_dataout <= wire_n0O_dataout AND NOT(nii00O);
	wire_nli0il_dataout <= wire_n01i_w_lg_dataout1624w(0) WHEN ni0ilO = '1'  ELSE wire_n01i_dataout;
	wire_nli0iO_dataout <= wire_nliO1i_w_lg_dataout1710w(0) WHEN ni0ilO = '1'  ELSE wire_nliO1i_dataout;
	wire_nli0li_dataout <= wire_nlilli_w_lg_dataout1709w(0) WHEN ni0ilO = '1'  ELSE wire_nlilli_dataout;
	wire_nli0ll_dataout <= wire_nliliO_w_lg_dataout1708w(0) WHEN ni0ilO = '1'  ELSE wire_nliliO_dataout;
	wire_nli0lO_dataout <= wire_w_lg_ni0l1O1707w(0) WHEN ni0ilO = '1'  ELSE ni0l1O;
	wire_nli0Oi_dataout <= wire_w_lg_ni0iOO1706w(0) WHEN ni0ilO = '1'  ELSE ni0iOO;
	wire_nli1il_dataout <= wire_n0O1O_w_lg_dataout1697w(0) WHEN ((ni0l0l OR ((wire_nliO1l_dataout OR ni0lil) OR ni0lii)) OR ni0iOi) = '1'  ELSE wire_n0O1O_dataout;
	wire_nli1il_w_lg_w_lg_dataout1604w1607w(0) <= wire_nli1il_w_lg_dataout1604w(0) AND wire_nlll0O_w_lg_dataout1606w(0);
	wire_nli1il_w_lg_w_lg_dataout1604w1609w(0) <= wire_nli1il_w_lg_dataout1604w(0) AND ni0O1O;
	wire_nli1il_w_lg_dataout1651w(0) <= wire_nli1il_dataout AND wire_n00l_w_lg_w_lg_w_lg_dataout1637w1638w1650w(0);
	wire_nli1il_w_lg_dataout1604w(0) <= NOT wire_nli1il_dataout;
	wire_nli1il_w_lg_w_lg_w_lg_dataout1604w1607w1608w(0) <= wire_nli1il_w_lg_w_lg_dataout1604w1607w(0) OR ni0O1l;
	wire_nlii_dataout <= wire_n10i_dataout AND NOT(nii1iO);
	wire_nlil_dataout <= wire_n10l_dataout AND NOT(nii1iO);
	wire_nliliO_dataout <= wire_n00i_w_lg_dataout1617w(0) WHEN ni0lii = '1'  ELSE wire_n00i_dataout;
	wire_nliliO_w_lg_dataout1708w(0) <= NOT wire_nliliO_dataout;
	wire_nlilli_dataout <= wire_n01O_w_lg_dataout1619w(0) WHEN ((wire_n00l_dataout AND (wire_n00i_dataout AND (wire_n01O_w_lg_dataout1619w(0) AND wire_n01l_w_lg_w_lg_dataout1620w1666w(0)))) OR ni0lil) = '1'  ELSE wire_n01O_dataout;
	wire_nlilli_w_lg_dataout1709w(0) <= NOT wire_nlilli_dataout;
	wire_nliO_dataout <= wire_n10O_dataout AND NOT(nii1iO);
	wire_nliO1i_dataout <= wire_n01l_w_lg_dataout1620w(0) WHEN ni0liO = '1'  ELSE wire_n01l_dataout;
	wire_nliO1i_w_lg_dataout1710w(0) <= NOT wire_nliO1i_dataout;
	wire_nliO1l_dataout <= ni0O0i WHEN r8b10b_enc_ibm_en = '1'  ELSE wire_niO_dataout;
	wire_nll_dataout <= wire_nii_dataout AND NOT(nii00O);
	wire_nlli_dataout <= wire_n1ii_dataout AND NOT(nii1iO);
	wire_nlli0i_dataout <= wire_nlli0l_dataout OR ni0lOO;
	wire_nlli0i_w_lg_dataout1611w(0) <= NOT wire_nlli0i_dataout;
	wire_nlli0l_dataout <= wire_w_lg_ni0O1O1605w(0) AND NOT(wire_n0il_dataout);
	wire_nlli1i_dataout <= wire_nli1il_w_lg_dataout1604w(0) WHEN (ni0lOi OR (wire_n0il_dataout AND ni0O1O)) = '1'  ELSE wire_nli1il_dataout;
	wire_nlliiO_dataout <= wire_n0ii_w_lg_dataout1616w(0) WHEN ni0lOi = '1'  ELSE wire_n0ii_dataout;
	wire_nlliiO_w_lg_dataout1613w(0) <= NOT wire_nlliiO_dataout;
	wire_nllill_dataout <= wire_n00O_dataout AND NOT(ni0lOO);
	wire_nllill_w_lg_dataout1614w(0) <= NOT wire_nllill_dataout;
	wire_nllilO_dataout <= wire_nllill_w_lg_dataout1614w(0) WHEN ni0O1i = '1'  ELSE wire_nllill_dataout;
	wire_nlliOi_dataout <= wire_nlliiO_w_lg_dataout1613w(0) WHEN ni0O1i = '1'  ELSE wire_nlliiO_dataout;
	wire_nlliOl_dataout <= wire_n0il_w_lg_dataout1612w(0) WHEN ni0O1i = '1'  ELSE wire_n0il_dataout;
	wire_nlliOO_dataout <= wire_nlli0i_w_lg_dataout1611w(0) WHEN ni0O1i = '1'  ELSE wire_nlli0i_dataout;
	wire_nlll0O_dataout <= ni0O0i WHEN r8b10b_enc_ibm_en = '1'  ELSE wire_niO_dataout;
	wire_nlll0O_w_lg_dataout1606w(0) <= wire_nlll0O_dataout AND wire_w_lg_ni0O1O1605w(0);
	wire_nlOii_dataout <= tx_data_tc(0) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(0);
	wire_nlOil_dataout <= tx_data_tc(1) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(1);
	wire_nlOiO_dataout <= tx_data_tc(2) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(2);
	wire_nlOli_dataout <= tx_data_tc(3) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(3);
	wire_nlOll_dataout <= tx_data_tc(4) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(4);
	wire_nlOlO_dataout <= tx_data_tc(5) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(5);
	wire_nlOOi_dataout <= tx_data_tc(6) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(6);
	wire_nlOOl_dataout <= tx_data_tc(7) WHEN rendec_data_sel_tx = '1'  ELSE tx_data_ts(7);
	wire_nlOOO_dataout <= tx_data_tc(8) AND rendec_data_sel_tx;
	wire_nili1O_i <= ( tx_boundary_sel(4 DOWNTO 0));
	nili1O :  oper_decoder
	  GENERIC MAP (
		width_i => 5,
		width_o => 32
	  )
	  PORT MAP ( 
		i => wire_nili1O_i,
		o => wire_nili1O_o
	  );
	wire_nillli_i <= ( tx_boundary_sel(3 DOWNTO 0));
	nillli :  oper_decoder
	  GENERIC MAP (
		width_i => 4,
		width_o => 16
	  )
	  PORT MAP ( 
		i => wire_nillli_i,
		o => wire_nillli_o
	  );
	wire_n010i_w_lg_o200w(0) <= NOT wire_n010i_o;
	wire_n010i_data <= ( tx_data_pg(17) & tx_data_pg(17) & tx_data_pg(17) & tx_data_pg(17) & rev_loop_data(17) & wire_nlliOi_dataout & tx_data_pg(17) & wire_nlliOi_dataout & tx_data_pg(17) & tx_data_pg(17) & tx_data_pg(17) & tx_data_pg(17) & rev_loop_data(17) & tx_data_tc(15) & tx_data_pg(17) & tx_data_tc(15));
	wire_n010i_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n010i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n010i_data,
		o => wire_n010i_o,
		sel => wire_n010i_sel
	  );
	wire_n010l_w_lg_o188w(0) <= NOT wire_n010l_o;
	wire_n010l_data <= ( tx_data_pg(18) & tx_data_pg(18) & tx_data_pg(18) & tx_data_pg(18) & rev_loop_data(18) & wire_nlliOl_dataout & tx_data_pg(18) & wire_nlliOl_dataout & tx_data_pg(18) & tx_data_pg(18) & tx_data_pg(18) & tx_data_pg(18) & rev_loop_data(18) & tx_ctl_tc(1) & tx_data_pg(18) & tx_ctl_tc(1));
	wire_n010l_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n010l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n010l_data,
		o => wire_n010l_o,
		sel => wire_n010l_sel
	  );
	wire_n010O_w_lg_o178w(0) <= NOT wire_n010O_o;
	wire_n010O_data <= ( tx_data_pg(19) & tx_data_pg(19) & tx_data_pg(19) & tx_data_pg(19) & rev_loop_data(19) & wire_nlliOO_dataout & tx_data_pg(19) & wire_nlliOO_dataout & tx_data_pg(19) & tx_data_pg(19) & tx_data_pg(19) & tx_data_pg(19) & rev_loop_data(19) & tx_data_9_tc(1) & tx_data_pg(19) & tx_data_9_tc(1));
	wire_n010O_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n010O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n010O_data,
		o => wire_n010O_o,
		sel => wire_n010O_sel
	  );
	wire_n011i_w_lg_o229w(0) <= NOT wire_n011i_o;
	wire_n011i_data <= ( tx_data_pg(14) & tx_data_pg(14) & tx_data_pg(14) & tx_data_pg(14) & rev_loop_data(14) & wire_nli0lO_dataout & tx_data_pg(14) & wire_nli0lO_dataout & tx_data_pg(14) & tx_data_pg(14) & tx_data_pg(14) & tx_data_pg(14) & rev_loop_data(14) & tx_data_tc(12) & tx_data_pg(14) & tx_data_tc(12));
	wire_n011i_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n011i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n011i_data,
		o => wire_n011i_o,
		sel => wire_n011i_sel
	  );
	wire_n011l_w_lg_o220w(0) <= NOT wire_n011l_o;
	wire_n011l_data <= ( tx_data_pg(15) & tx_data_pg(15) & tx_data_pg(15) & tx_data_pg(15) & rev_loop_data(15) & wire_nli0Oi_dataout & tx_data_pg(15) & wire_nli0Oi_dataout & tx_data_pg(15) & tx_data_pg(15) & tx_data_pg(15) & tx_data_pg(15) & rev_loop_data(15) & tx_data_tc(13) & tx_data_pg(15) & tx_data_tc(13));
	wire_n011l_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n011l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n011l_data,
		o => wire_n011l_o,
		sel => wire_n011l_sel
	  );
	wire_n011O_w_lg_o211w(0) <= NOT wire_n011O_o;
	wire_n011O_data <= ( tx_data_pg(16) & tx_data_pg(16) & tx_data_pg(16) & tx_data_pg(16) & rev_loop_data(16) & wire_nllilO_dataout & tx_data_pg(16) & wire_nllilO_dataout & tx_data_pg(16) & tx_data_pg(16) & tx_data_pg(16) & tx_data_pg(16) & rev_loop_data(16) & tx_data_tc(14) & tx_data_pg(16) & tx_data_tc(14));
	wire_n011O_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n011O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n011O_data,
		o => wire_n011O_o,
		sel => wire_n011O_sel
	  );
	wire_n1O0i_w_lg_o122w(0) <= NOT wire_n1O0i_o;
	wire_n1O0i_data <= ( tx_data_pg(2) & tx_data_pg(2) & tx_data_pg(2) & tx_data_pg(2) & rev_loop_data(2) & wire_niOOOO_dataout & tx_data_pg(2) & wire_niOOOO_dataout & tx_data_pg(2) & tx_data_pg(2) & tx_data_pg(2) & tx_data_pg(2) & rev_loop_data(2) & tx_data_tc(2) & tx_data_pg(2) & tx_data_tc(2));
	wire_n1O0i_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1O0i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1O0i_data,
		o => wire_n1O0i_o,
		sel => wire_n1O0i_sel
	  );
	wire_n1O0l_w_lg_o133w(0) <= NOT wire_n1O0l_o;
	wire_n1O0l_data <= ( tx_data_pg(3) & tx_data_pg(3) & tx_data_pg(3) & tx_data_pg(3) & rev_loop_data(3) & wire_nl111i_dataout & tx_data_pg(3) & wire_nl111i_dataout & tx_data_pg(3) & tx_data_pg(3) & tx_data_pg(3) & tx_data_pg(3) & rev_loop_data(3) & tx_data_tc(3) & tx_data_pg(3) & tx_data_tc(3));
	wire_n1O0l_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1O0l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1O0l_data,
		o => wire_n1O0l_o,
		sel => wire_n1O0l_sel
	  );
	wire_n1O0O_w_lg_o130w(0) <= NOT wire_n1O0O_o;
	wire_n1O0O_data <= ( tx_data_pg(4) & tx_data_pg(4) & tx_data_pg(4) & tx_data_pg(4) & rev_loop_data(4) & wire_nl111l_dataout & tx_data_pg(4) & wire_nl111l_dataout & tx_data_pg(4) & tx_data_pg(4) & tx_data_pg(4) & tx_data_pg(4) & rev_loop_data(4) & tx_data_tc(4) & tx_data_pg(4) & tx_data_tc(4));
	wire_n1O0O_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1O0O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1O0O_data,
		o => wire_n1O0O_o,
		sel => wire_n1O0O_sel
	  );
	wire_n1O1l_w_lg_o96w(0) <= NOT wire_n1O1l_o;
	wire_n1O1l_data <= ( tx_data_pg(0) & tx_data_pg(0) & tx_data_pg(0) & tx_data_pg(0) & rev_loop_data(0) & wire_niOOOi_dataout & tx_data_pg(0) & wire_niOOOi_dataout & tx_data_pg(0) & tx_data_pg(0) & tx_data_pg(0) & tx_data_pg(0) & rev_loop_data(0) & tx_data_tc(0) & tx_data_pg(0) & tx_data_tc(0));
	wire_n1O1l_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1O1l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1O1l_data,
		o => wire_n1O1l_o,
		sel => wire_n1O1l_sel
	  );
	wire_n1O1O_w_lg_o108w(0) <= NOT wire_n1O1O_o;
	wire_n1O1O_data <= ( tx_data_pg(1) & tx_data_pg(1) & tx_data_pg(1) & tx_data_pg(1) & rev_loop_data(1) & wire_niOOOl_dataout & tx_data_pg(1) & wire_niOOOl_dataout & tx_data_pg(1) & tx_data_pg(1) & tx_data_pg(1) & tx_data_pg(1) & rev_loop_data(1) & tx_data_tc(1) & tx_data_pg(1) & tx_data_tc(1));
	wire_n1O1O_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1O1O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1O1O_data,
		o => wire_n1O1O_o,
		sel => wire_n1O1O_sel
	  );
	wire_n1Oii_w_lg_o119w(0) <= NOT wire_n1Oii_o;
	wire_n1Oii_data <= ( tx_data_pg(5) & tx_data_pg(5) & tx_data_pg(5) & tx_data_pg(5) & rev_loop_data(5) & wire_nl111O_dataout & tx_data_pg(5) & wire_nl111O_dataout & tx_data_pg(5) & tx_data_pg(5) & tx_data_pg(5) & tx_data_pg(5) & rev_loop_data(5) & tx_data_tc(5) & tx_data_pg(5) & tx_data_tc(5));
	wire_n1Oii_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1Oii :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oii_data,
		o => wire_n1Oii_o,
		sel => wire_n1Oii_sel
	  );
	wire_n1Oil_w_lg_o106w(0) <= NOT wire_n1Oil_o;
	wire_n1Oil_data <= ( tx_data_pg(6) & tx_data_pg(6) & tx_data_pg(6) & tx_data_pg(6) & rev_loop_data(6) & wire_nl001l_dataout & tx_data_pg(6) & wire_nl001l_dataout & tx_data_pg(6) & tx_data_pg(6) & tx_data_pg(6) & tx_data_pg(6) & rev_loop_data(6) & tx_data_tc(6) & tx_data_pg(6) & tx_data_tc(6));
	wire_n1Oil_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1Oil :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oil_data,
		o => wire_n1Oil_o,
		sel => wire_n1Oil_sel
	  );
	wire_n1OiO_w_lg_o94w(0) <= NOT wire_n1OiO_o;
	wire_n1OiO_data <= ( tx_data_pg(7) & tx_data_pg(7) & tx_data_pg(7) & tx_data_pg(7) & rev_loop_data(7) & wire_nl001O_dataout & tx_data_pg(7) & wire_nl001O_dataout & tx_data_pg(7) & tx_data_pg(7) & tx_data_pg(7) & tx_data_pg(7) & rev_loop_data(7) & tx_data_tc(7) & tx_data_pg(7) & tx_data_tc(7));
	wire_n1OiO_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1OiO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OiO_data,
		o => wire_n1OiO_o,
		sel => wire_n1OiO_sel
	  );
	wire_n1Oli_w_lg_o81w(0) <= NOT wire_n1Oli_o;
	wire_n1Oli_data <= ( tx_data_pg(8) & tx_data_pg(8) & tx_data_pg(8) & tx_data_pg(8) & rev_loop_data(8) & wire_nl000i_dataout & tx_data_pg(8) & wire_nl000i_dataout & tx_data_pg(8) & tx_data_pg(8) & tx_data_pg(8) & tx_data_pg(8) & rev_loop_data(8) & tx_ctl_tc(1) & tx_data_pg(8) & tx_ctl_tc(0));
	wire_n1Oli_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1Oli :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oli_data,
		o => wire_n1Oli_o,
		sel => wire_n1Oli_sel
	  );
	wire_n1Oll_w_lg_o70w(0) <= NOT wire_n1Oll_o;
	wire_n1Oll_data <= ( tx_data_pg(9) & tx_data_pg(9) & tx_data_pg(9) & tx_data_pg(9) & rev_loop_data(9) & wire_nl000l_dataout & tx_data_pg(9) & wire_nl000l_dataout & tx_data_pg(9) & tx_data_pg(9) & tx_data_pg(9) & tx_data_pg(9) & rev_loop_data(9) & tx_data_9_tc(0) & tx_data_pg(9) & tx_data_9_tc(0));
	wire_n1Oll_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1Oll :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Oll_data,
		o => wire_n1Oll_o,
		sel => wire_n1Oll_sel
	  );
	wire_n1OlO_w_lg_o265w(0) <= NOT wire_n1OlO_o;
	wire_n1OlO_data <= ( tx_data_pg(10) & tx_data_pg(10) & tx_data_pg(10) & tx_data_pg(10) & rev_loop_data(10) & wire_nli0il_dataout & tx_data_pg(10) & wire_nli0il_dataout & tx_data_pg(10) & tx_data_pg(10) & tx_data_pg(10) & tx_data_pg(10) & rev_loop_data(10) & tx_data_tc(8) & tx_data_pg(10) & tx_data_tc(8));
	wire_n1OlO_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1OlO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OlO_data,
		o => wire_n1OlO_o,
		sel => wire_n1OlO_sel
	  );
	wire_n1OOi_w_lg_o256w(0) <= NOT wire_n1OOi_o;
	wire_n1OOi_data <= ( tx_data_pg(11) & tx_data_pg(11) & tx_data_pg(11) & tx_data_pg(11) & rev_loop_data(11) & wire_nli0iO_dataout & tx_data_pg(11) & wire_nli0iO_dataout & tx_data_pg(11) & tx_data_pg(11) & tx_data_pg(11) & tx_data_pg(11) & rev_loop_data(11) & tx_data_tc(9) & tx_data_pg(11) & tx_data_tc(9));
	wire_n1OOi_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1OOi :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OOi_data,
		o => wire_n1OOi_o,
		sel => wire_n1OOi_sel
	  );
	wire_n1OOl_w_lg_o247w(0) <= NOT wire_n1OOl_o;
	wire_n1OOl_data <= ( tx_data_pg(12) & tx_data_pg(12) & tx_data_pg(12) & tx_data_pg(12) & rev_loop_data(12) & wire_nli0li_dataout & tx_data_pg(12) & wire_nli0li_dataout & tx_data_pg(12) & tx_data_pg(12) & tx_data_pg(12) & tx_data_pg(12) & rev_loop_data(12) & tx_data_tc(10) & tx_data_pg(12) & tx_data_tc(10));
	wire_n1OOl_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1OOl :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OOl_data,
		o => wire_n1OOl_o,
		sel => wire_n1OOl_sel
	  );
	wire_n1OOO_w_lg_o238w(0) <= NOT wire_n1OOO_o;
	wire_n1OOO_data <= ( tx_data_pg(13) & tx_data_pg(13) & tx_data_pg(13) & tx_data_pg(13) & rev_loop_data(13) & wire_nli0ll_dataout & tx_data_pg(13) & wire_nli0ll_dataout & tx_data_pg(13) & tx_data_pg(13) & tx_data_pg(13) & tx_data_pg(13) & rev_loop_data(13) & tx_data_tc(11) & tx_data_pg(13) & tx_data_tc(11));
	wire_n1OOO_sel <= ( endec & prbs_en & rrev_loopbk & ni1li);
	n1OOO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1OOO_data,
		o => wire_n1OOO_o,
		sel => wire_n1OOO_sel
	  );
	wire_niil0i_data <= ( wire_niiOiO_o & wire_nil1Ol_o & wire_nili0O_o & wire_nillOi_o);
	wire_niil0i_sel <= ( doublewidth & dwidth);
	niil0i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niil0i_data,
		o => wire_niil0i_o,
		sel => wire_niil0i_sel
	  );
	wire_niil0l_data <= ( wire_niiOli_o & wire_nil1OO_o & wire_niliii_o & wire_nillOl_o);
	wire_niil0l_sel <= ( doublewidth & dwidth);
	niil0l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niil0l_data,
		o => wire_niil0l_o,
		sel => wire_niil0l_sel
	  );
	wire_niil0O_data <= ( wire_niiOll_o & wire_nil01i_o & wire_niliil_o & wire_nillOO_o);
	wire_niil0O_sel <= ( doublewidth & dwidth);
	niil0O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niil0O_data,
		o => wire_niil0O_o,
		sel => wire_niil0O_sel
	  );
	wire_niil1l_data <= ( wire_niiOii_o & wire_nil1lO_o & wire_nili0i_o & wire_nillll_o);
	wire_niil1l_sel <= ( doublewidth & dwidth);
	niil1l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niil1l_data,
		o => wire_niil1l_o,
		sel => wire_niil1l_sel
	  );
	wire_niil1O_data <= ( wire_niiOil_o & wire_nil1Oi_o & wire_nili0l_o & wire_nilllO_o);
	wire_niil1O_sel <= ( doublewidth & dwidth);
	niil1O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niil1O_data,
		o => wire_niil1O_o,
		sel => wire_niil1O_sel
	  );
	wire_niilii_data <= ( wire_niiOlO_o & wire_nil01l_o & wire_niliiO_o & wire_nilO1i_o);
	wire_niilii_sel <= ( doublewidth & dwidth);
	niilii :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niilii_data,
		o => wire_niilii_o,
		sel => wire_niilii_sel
	  );
	wire_niilil_data <= ( wire_niiOOi_o & wire_nil01O_o & wire_nilili_o & wire_nilO1l_o);
	wire_niilil_sel <= ( doublewidth & dwidth);
	niilil :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niilil_data,
		o => wire_niilil_o,
		sel => wire_niilil_sel
	  );
	wire_niiliO_data <= ( wire_niiOOl_o & wire_nil00i_o & wire_nilill_o & wire_nilO1O_o);
	wire_niiliO_sel <= ( doublewidth & dwidth);
	niiliO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niiliO_data,
		o => wire_niiliO_o,
		sel => wire_niiliO_sel
	  );
	wire_niilli_data <= ( wire_niiOOO_o & wire_nil00l_dataout & wire_nililO_o & wire_nilO0i_dataout);
	wire_niilli_sel <= ( doublewidth & dwidth);
	niilli :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niilli_data,
		o => wire_niilli_o,
		sel => wire_niilli_sel
	  );
	wire_niilll_data <= ( wire_nil11i_o & wire_nil00O_dataout & wire_niliOi_o & wire_nilO0l_dataout);
	wire_niilll_sel <= ( doublewidth & dwidth);
	niilll :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niilll_data,
		o => wire_niilll_o,
		sel => wire_niilll_sel
	  );
	wire_niillO_data <= ( wire_nil11l_o & wire_nil0ii_o & wire_niliOl_dataout & wire_nilO0O_dataout);
	wire_niillO_sel <= ( doublewidth & dwidth);
	niillO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niillO_data,
		o => wire_niillO_o,
		sel => wire_niillO_sel
	  );
	wire_niilOi_data <= ( wire_nil11O_o & wire_nil0il_o & wire_niliOO_dataout & wire_nilOii_dataout);
	wire_niilOi_sel <= ( doublewidth & dwidth);
	niilOi :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niilOi_data,
		o => wire_niilOi_o,
		sel => wire_niilOi_sel
	  );
	wire_niilOl_data <= ( wire_nil10i_o & wire_nil0iO_o & wire_nill1i_dataout & wire_nilOil_dataout);
	wire_niilOl_sel <= ( doublewidth & dwidth);
	niilOl :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niilOl_data,
		o => wire_niilOl_o,
		sel => wire_niilOl_sel
	  );
	wire_niilOO_data <= ( wire_nil10l_o & wire_nil0li_o & wire_nill1l_dataout & wire_nilOiO_dataout);
	wire_niilOO_sel <= ( doublewidth & dwidth);
	niilOO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niilOO_data,
		o => wire_niilOO_o,
		sel => wire_niilOO_sel
	  );
	wire_niiO0i_data <= ( wire_nil1iO_o & wire_nil0Ol_o & wire_nill0O_dataout & wire_nilOOi_dataout);
	wire_niiO0i_sel <= ( doublewidth & dwidth);
	niiO0i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niiO0i_data,
		o => wire_niiO0i_o,
		sel => wire_niiO0i_sel
	  );
	wire_niiO0l_data <= ( wire_nil1li_o & wire_nil0OO_dataout & wire_nillii_dataout & wire_nilOOl_dataout);
	wire_niiO0l_sel <= ( doublewidth & dwidth);
	niiO0l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niiO0l_data,
		o => wire_niiO0l_o,
		sel => wire_niiO0l_sel
	  );
	wire_niiO0O_data <= ( wire_nil1ll_o & wire_nili1i_dataout & wire_nillil_dataout & wire_nilOOO_dataout);
	wire_niiO0O_sel <= ( doublewidth & dwidth);
	niiO0O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niiO0O_data,
		o => wire_niiO0O_o,
		sel => wire_niiO0O_sel
	  );
	wire_niiO1i_data <= ( wire_nil10O_o & wire_nil0ll_o & wire_nill1O_dataout & wire_nilOli_dataout);
	wire_niiO1i_sel <= ( doublewidth & dwidth);
	niiO1i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niiO1i_data,
		o => wire_niiO1i_o,
		sel => wire_niiO1i_sel
	  );
	wire_niiO1l_data <= ( wire_nil1ii_o & wire_nil0lO_o & wire_nill0i_dataout & wire_nilOll_dataout);
	wire_niiO1l_sel <= ( doublewidth & dwidth);
	niiO1l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niiO1l_data,
		o => wire_niiO1l_o,
		sel => wire_niiO1l_sel
	  );
	wire_niiO1O_data <= ( wire_nil1il_o & wire_nil0Oi_o & wire_nill0l_dataout & wire_nilOlO_dataout);
	wire_niiO1O_sel <= ( doublewidth & dwidth);
	niiO1O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niiO1O_data,
		o => wire_niiO1O_o,
		sel => wire_niiO1O_sel
	  );
	wire_niiOii_data <= ( wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & niil1i & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o);
	wire_niiOii_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOii :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOii_data,
		o => wire_niiOii_o,
		sel => wire_niiOii_sel
	  );
	wire_niiOil_data <= ( wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o);
	wire_niiOil_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOil :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOil_data,
		o => wire_niiOil_o,
		sel => wire_niiOil_sel
	  );
	wire_niiOiO_data <= ( wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o);
	wire_niiOiO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOiO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOiO_data,
		o => wire_niiOiO_o,
		sel => wire_niiOiO_sel
	  );
	wire_niiOli_data <= ( wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o);
	wire_niiOli_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOli :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOli_data,
		o => wire_niiOli_o,
		sel => wire_niiOli_sel
	  );
	wire_niiOll_data <= ( wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & niii1i & niii1l & niii1O & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o);
	wire_niiOll_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOll :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOll_data,
		o => wire_niiOll_o,
		sel => wire_niiOll_sel
	  );
	wire_niiOlO_data <= ( wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & niii1l & niii1O & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o);
	wire_niiOlO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOlO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOlO_data,
		o => wire_niiOlO_o,
		sel => wire_niiOlO_sel
	  );
	wire_niiOOi_data <= ( wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & niii1O & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o);
	wire_niiOOi_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOOi :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOOi_data,
		o => wire_niiOOi_o,
		sel => wire_niiOOi_sel
	  );
	wire_niiOOl_data <= ( wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & niii0i & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o);
	wire_niiOOl_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOOl :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOOl_data,
		o => wire_niiOOl_o,
		sel => wire_niiOOl_sel
	  );
	wire_niiOOO_data <= ( wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & niii0l & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o);
	wire_niiOOO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	niiOOO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_niiOOO_data,
		o => wire_niiOOO_o,
		sel => wire_niiOOO_sel
	  );
	wire_nil00i_data <= ( wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o);
	wire_nil00i_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil00i :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil00i_data,
		o => wire_nil00i_o,
		sel => wire_nil00i_sel
	  );
	wire_nil01i_data <= ( wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & niii1i & niii1l & niii1O & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o);
	wire_nil01i_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil01i :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil01i_data,
		o => wire_nil01i_o,
		sel => wire_nil01i_sel
	  );
	wire_nil01l_data <= ( wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & niii1l & niii1O & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o);
	wire_nil01l_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil01l :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil01l_data,
		o => wire_nil01l_o,
		sel => wire_nil01l_sel
	  );
	wire_nil01O_data <= ( wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & niii1O & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o);
	wire_nil01O_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil01O :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil01O_data,
		o => wire_nil01O_o,
		sel => wire_nil01O_sel
	  );
	wire_nil0ii_data <= ( wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o);
	wire_nil0ii_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0ii :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0ii_data,
		o => wire_nil0ii_o,
		sel => wire_nil0ii_sel
	  );
	wire_nil0il_data <= ( wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o & wire_niO1O_o);
	wire_nil0il_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0il :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0il_data,
		o => wire_nil0il_o,
		sel => wire_nil0il_sel
	  );
	wire_nil0iO_data <= ( wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o);
	wire_nil0iO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0iO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0iO_data,
		o => wire_nil0iO_o,
		sel => wire_nil0iO_sel
	  );
	wire_nil0li_data <= ( wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o);
	wire_nil0li_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0li :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0li_data,
		o => wire_nil0li_o,
		sel => wire_nil0li_sel
	  );
	wire_nil0ll_data <= ( wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o);
	wire_nil0ll_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0ll :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0ll_data,
		o => wire_nil0ll_o,
		sel => wire_nil0ll_sel
	  );
	wire_nil0lO_data <= ( wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o);
	wire_nil0lO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0lO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0lO_data,
		o => wire_nil0lO_o,
		sel => wire_nil0lO_sel
	  );
	wire_nil0Oi_data <= ( wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o & wire_niOil_o);
	wire_nil0Oi_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0Oi :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0Oi_data,
		o => wire_nil0Oi_o,
		sel => wire_nil0Oi_sel
	  );
	wire_nil0Ol_data <= ( wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o & wire_niOil_o & wire_niOiO_o);
	wire_nil0Ol_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil0Ol :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil0Ol_data,
		o => wire_nil0Ol_o,
		sel => wire_nil0Ol_sel
	  );
	wire_nil10i_data <= ( wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & wire_niO0i_o & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o);
	wire_nil10i_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil10i :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil10i_data,
		o => wire_nil10i_o,
		sel => wire_nil10i_sel
	  );
	wire_nil10l_data <= ( wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & wire_niO0l_o & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o);
	wire_nil10l_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil10l :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil10l_data,
		o => wire_nil10l_o,
		sel => wire_nil10l_sel
	  );
	wire_nil10O_data <= ( wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & wire_niO0O_o & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o);
	wire_nil10O_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil10O :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil10O_data,
		o => wire_nil10O_o,
		sel => wire_nil10O_sel
	  );
	wire_nil11i_data <= ( wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o);
	wire_nil11i_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil11i :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil11i_data,
		o => wire_nil11i_o,
		sel => wire_nil11i_sel
	  );
	wire_nil11l_data <= ( wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & wire_niO1l_o & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o);
	wire_nil11l_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil11l :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil11l_data,
		o => wire_nil11l_o,
		sel => wire_nil11l_sel
	  );
	wire_nil11O_data <= ( wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & wire_niO1O_o & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o);
	wire_nil11O_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil11O :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil11O_data,
		o => wire_nil11O_o,
		sel => wire_nil11O_sel
	  );
	wire_nil1ii_data <= ( wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & wire_niOii_o & niiilO & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o);
	wire_nil1ii_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1ii :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1ii_data,
		o => wire_nil1ii_o,
		sel => wire_nil1ii_sel
	  );
	wire_nil1il_data <= ( wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & wire_niOil_o & niiiOi & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o & wire_niOil_o);
	wire_nil1il_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1il :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1il_data,
		o => wire_nil1il_o,
		sel => wire_nil1il_sel
	  );
	wire_nil1iO_data <= ( wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & wire_niOiO_o & niiiOl & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o & wire_niOil_o & wire_niOiO_o);
	wire_nil1iO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1iO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1iO_data,
		o => wire_nil1iO_o,
		sel => wire_nil1iO_sel
	  );
	wire_nil1li_data <= ( wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & wire_niOli_o & niiiOO & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o & wire_niOil_o & wire_niOiO_o & wire_niOli_o);
	wire_nil1li_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1li :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1li_data,
		o => wire_nil1li_o,
		sel => wire_nil1li_sel
	  );
	wire_nil1ll_data <= ( wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_niOll_o & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o & wire_niO1l_o & wire_niO1O_o & wire_niO0i_o & wire_niO0l_o & wire_niO0O_o & wire_niOii_o & wire_niOil_o & wire_niOiO_o & wire_niOli_o & wire_niOll_o);
	wire_nil1ll_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1ll :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1ll_data,
		o => wire_nil1ll_o,
		sel => wire_nil1ll_sel
	  );
	wire_nil1lO_data <= ( wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & niil1i & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o);
	wire_nil1lO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1lO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1lO_data,
		o => wire_nil1lO_o,
		sel => wire_nil1lO_sel
	  );
	wire_nil1Oi_data <= ( wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o);
	wire_nil1Oi_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1Oi :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1Oi_data,
		o => wire_nil1Oi_o,
		sel => wire_nil1Oi_sel
	  );
	wire_nil1Ol_data <= ( wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o);
	wire_nil1Ol_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1Ol :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1Ol_data,
		o => wire_nil1Ol_o,
		sel => wire_nil1Ol_sel
	  );
	wire_nil1OO_data <= ( wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & nii0OO & niii1i & niii1l & niii1O & niii0O & niiiii & niiiil & niiiiO & niiili & niiill & niiilO & niiiOi & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o);
	wire_nil1OO_sel <= ( tx_boundary_sel(4 DOWNTO 0));
	nil1OO :  oper_mux
	  GENERIC MAP (
		width_data => 32,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_nil1OO_data,
		o => wire_nil1OO_o,
		sel => wire_nil1OO_sel
	  );
	wire_nili0i_data <= ( wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & niil1i & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & wire_nilii_o);
	wire_nili0i_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nili0i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nili0i_data,
		o => wire_nili0i_o,
		sel => wire_nili0i_sel
	  );
	wire_nili0l_data <= ( wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & wire_nilii_o & wire_nilil_o);
	wire_nili0l_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nili0l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nili0l_data,
		o => wire_nili0l_o,
		sel => wire_nili0l_sel
	  );
	wire_nili0O_data <= ( wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & nii0Ol & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & wire_nilii_o & wire_nilil_o & wire_niliO_o);
	wire_nili0O_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nili0O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nili0O_data,
		o => wire_nili0O_o,
		sel => wire_nili0O_sel
	  );
	wire_nilii_data <= ( wire_niOlO_o & wire_nl01l_o & wire_nliii_o & wire_nlllO_o);
	wire_nilii_sel <= ( doublewidth & dwidth);
	nilii :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nilii_data,
		o => wire_nilii_o,
		sel => wire_nilii_sel
	  );
	wire_niliii_data <= ( wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & nii0OO & niii1i & niii1l & niii1O & niii0i & niii0l & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o);
	wire_niliii_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	niliii :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_niliii_data,
		o => wire_niliii_o,
		sel => wire_niliii_sel
	  );
	wire_niliil_data <= ( wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & niii1i & niii1l & niii1O & niii0i & niii0l & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o);
	wire_niliil_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	niliil :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_niliil_data,
		o => wire_niliil_o,
		sel => wire_niliil_sel
	  );
	wire_niliiO_data <= ( wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & niii1l & niii1O & niii0i & niii0l & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o);
	wire_niliiO_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	niliiO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_niliiO_data,
		o => wire_niliiO_o,
		sel => wire_niliiO_sel
	  );
	wire_nilil_data <= ( wire_niOOi_o & wire_nl01O_o & wire_nliil_o & wire_nllOi_o);
	wire_nilil_sel <= ( doublewidth & dwidth);
	nilil :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nilil_data,
		o => wire_nilil_o,
		sel => wire_nilil_sel
	  );
	wire_nilili_data <= ( wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & niii1O & niii0i & niii0l & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o);
	wire_nilili_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nilili :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilili_data,
		o => wire_nilili_o,
		sel => wire_nilili_sel
	  );
	wire_nilill_data <= ( wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & niii0i & niii0l & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o);
	wire_nilill_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nilill :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilill_data,
		o => wire_nilill_o,
		sel => wire_nilill_sel
	  );
	wire_nililO_data <= ( wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & wire_nilOO_o & niii0l & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o);
	wire_nililO_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nililO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nililO_data,
		o => wire_nililO_o,
		sel => wire_nililO_sel
	  );
	wire_niliO_data <= ( wire_niOOl_o & wire_nl00i_o & wire_nliiO_o & wire_nllOl_o);
	wire_niliO_sel <= ( doublewidth & dwidth);
	niliO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niliO_data,
		o => wire_niliO_o,
		sel => wire_niliO_sel
	  );
	wire_niliOi_data <= ( wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_niO1i_o & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o & wire_nilOO_o & wire_niO1i_o);
	wire_niliOi_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	niliOi :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_niliOi_data,
		o => wire_niliOi_o,
		sel => wire_niliOi_sel
	  );
	wire_nilli_data <= ( wire_niOOO_o & wire_nl00l_o & wire_nlili_o & wire_nllOO_o);
	wire_nilli_sel <= ( doublewidth & dwidth);
	nilli :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nilli_data,
		o => wire_nilli_o,
		sel => wire_nilli_sel
	  );
	wire_nilll_data <= ( wire_nl11i_o & wire_nl00O_o & wire_nlill_o & wire_nlO1i_o);
	wire_nilll_sel <= ( doublewidth & dwidth);
	nilll :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nilll_data,
		o => wire_nilll_o,
		sel => wire_nilll_sel
	  );
	wire_nillll_data <= ( wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & wire_nilii_o & niil1i & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & wire_nilii_o);
	wire_nillll_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nillll :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nillll_data,
		o => wire_nillll_o,
		sel => wire_nillll_sel
	  );
	wire_nilllO_data <= ( wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & wire_nilil_o & nii0Oi & nii0Ol & nii0OO & niii1i & niii1l & niii1O & wire_nilii_o & wire_nilil_o);
	wire_nilllO_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nilllO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilllO_data,
		o => wire_nilllO_o,
		sel => wire_nilllO_sel
	  );
	wire_nillO_data <= ( wire_nl11l_o & wire_nl0ii_o & wire_nlilO_o & wire_nlO1l_o);
	wire_nillO_sel <= ( doublewidth & dwidth);
	nillO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nillO_data,
		o => wire_nillO_o,
		sel => wire_nillO_sel
	  );
	wire_nillOi_data <= ( wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & wire_niliO_o & nii0Ol & nii0OO & niii1i & niii1l & niii1O & wire_nilii_o & wire_nilil_o & wire_niliO_o);
	wire_nillOi_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nillOi :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nillOi_data,
		o => wire_nillOi_o,
		sel => wire_nillOi_sel
	  );
	wire_nillOl_data <= ( wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & wire_nilli_o & nii0OO & niii1i & niii1l & niii1O & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o);
	wire_nillOl_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nillOl :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nillOl_data,
		o => wire_nillOl_o,
		sel => wire_nillOl_sel
	  );
	wire_nillOO_data <= ( wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & wire_nilll_o & niii1i & niii1l & niii1O & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o);
	wire_nillOO_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nillOO :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nillOO_data,
		o => wire_nillOO_o,
		sel => wire_nillOO_sel
	  );
	wire_nilO1i_data <= ( wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & wire_nillO_o & niii1l & niii1O & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o);
	wire_nilO1i_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nilO1i :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilO1i_data,
		o => wire_nilO1i_o,
		sel => wire_nilO1i_sel
	  );
	wire_nilO1l_data <= ( wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & wire_nilOi_o & niii1O & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o);
	wire_nilO1l_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nilO1l :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilO1l_data,
		o => wire_nilO1l_o,
		sel => wire_nilO1l_sel
	  );
	wire_nilO1O_data <= ( wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilOl_o & wire_nilii_o & wire_nilil_o & wire_niliO_o & wire_nilli_o & wire_nilll_o & wire_nillO_o & wire_nilOi_o & wire_nilOl_o);
	wire_nilO1O_sel <= ( tx_boundary_sel(3 DOWNTO 0));
	nilO1O :  oper_mux
	  GENERIC MAP (
		width_data => 16,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nilO1O_data,
		o => wire_nilO1O_o,
		sel => wire_nilO1O_sel
	  );
	wire_nilOi_data <= ( wire_nl11O_o & wire_nl0il_o & wire_nliOi_o & wire_nlO1O_o);
	wire_nilOi_sel <= ( doublewidth & dwidth);
	nilOi :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nilOi_data,
		o => wire_nilOi_o,
		sel => wire_nilOi_sel
	  );
	wire_nilOl_data <= ( wire_nl10i_o & wire_nl0iO_o & wire_nliOl_o & wire_nlO0i_o);
	wire_nilOl_sel <= ( doublewidth & dwidth);
	nilOl :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nilOl_data,
		o => wire_nilOl_o,
		sel => wire_nilOl_sel
	  );
	wire_nilOO_data <= ( wire_nl10l_o & wire_nl0li_o & wire_nliOO_o & wire_nlO0l_o);
	wire_nilOO_sel <= ( doublewidth & dwidth);
	nilOO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nilOO_data,
		o => wire_nilOO_o,
		sel => wire_nilOO_sel
	  );
	wire_niO0i_data <= ( wire_nl1iO_o & wire_nl0Ol_o & wire_nll0i_o & wire_nll0i_o);
	wire_niO0i_sel <= ( doublewidth & dwidth);
	niO0i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niO0i_data,
		o => wire_niO0i_o,
		sel => wire_niO0i_sel
	  );
	wire_niO0l_data <= ( wire_nl1li_o & wire_nl0OO_o & wire_nll0l_o & wire_nll0l_o);
	wire_niO0l_sel <= ( doublewidth & dwidth);
	niO0l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niO0l_data,
		o => wire_niO0l_o,
		sel => wire_niO0l_sel
	  );
	wire_niO0O_data <= ( wire_nl1ll_o & wire_nli1i_o & wire_nll0O_o & wire_nll0O_o);
	wire_niO0O_sel <= ( doublewidth & dwidth);
	niO0O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niO0O_data,
		o => wire_niO0O_o,
		sel => wire_niO0O_sel
	  );
	wire_niO1i_data <= ( wire_nl10O_o & wire_nl0ll_o & wire_nll1i_o & wire_nlO0O_o);
	wire_niO1i_sel <= ( doublewidth & dwidth);
	niO1i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niO1i_data,
		o => wire_niO1i_o,
		sel => wire_niO1i_sel
	  );
	wire_niO1l_data <= ( wire_nl1ii_o & wire_nl0lO_o & wire_nll1l_o & wire_nll1l_o);
	wire_niO1l_sel <= ( doublewidth & dwidth);
	niO1l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niO1l_data,
		o => wire_niO1l_o,
		sel => wire_niO1l_sel
	  );
	wire_niO1O_data <= ( wire_nl1il_o & wire_nl0Oi_o & wire_nll1O_o & wire_nll1O_o);
	wire_niO1O_sel <= ( doublewidth & dwidth);
	niO1O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niO1O_data,
		o => wire_niO1O_o,
		sel => wire_niO1O_sel
	  );
	wire_niOii_data <= ( wire_nl1lO_o & wire_nli1l_o & wire_nllii_o & wire_nllii_o);
	wire_niOii_sel <= ( doublewidth & dwidth);
	niOii :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niOii_data,
		o => wire_niOii_o,
		sel => wire_niOii_sel
	  );
	wire_niOil_data <= ( wire_nl1Oi_o & wire_nli1O_o & wire_nllil_o & wire_nllil_o);
	wire_niOil_sel <= ( doublewidth & dwidth);
	niOil :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niOil_data,
		o => wire_niOil_o,
		sel => wire_niOil_sel
	  );
	wire_niOiO_data <= ( wire_nl1Ol_o & wire_nli0i_o & wire_nlliO_o & wire_nlliO_o);
	wire_niOiO_sel <= ( doublewidth & dwidth);
	niOiO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niOiO_data,
		o => wire_niOiO_o,
		sel => wire_niOiO_sel
	  );
	wire_niOli_data <= ( wire_nl1OO_o & wire_nli0l_o & wire_nllli_o & wire_nllli_o);
	wire_niOli_sel <= ( doublewidth & dwidth);
	niOli :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niOli_data,
		o => wire_niOli_o,
		sel => wire_niOli_sel
	  );
	wire_niOll_data <= ( wire_nl01i_o & wire_nli0O_o & wire_nllll_o & wire_nllll_o);
	wire_niOll_sel <= ( doublewidth & dwidth);
	niOll :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_niOll_data,
		o => wire_niOll_o,
		sel => wire_niOll_sel
	  );
	wire_niOlO_data <= ( wire_n1Oll_w_lg_o70w & wire_n010O_w_lg_o178w & wire_n1OlO_w_lg_o265w & wire_n1O1l_w_lg_o96w & wire_n1Oll_o & wire_n010O_o & wire_n1OlO_o & wire_n1O1l_o);
	wire_niOlO_sel <= ( n0lll & n0liO & n0lii);
	niOlO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niOlO_data,
		o => wire_niOlO_o,
		sel => wire_niOlO_sel
	  );
	wire_niOOi_data <= ( wire_n1Oli_w_lg_o81w & wire_n010l_w_lg_o188w & wire_n1OOi_w_lg_o256w & wire_n1O1O_w_lg_o108w & wire_n1Oli_o & wire_n010l_o & wire_n1OOi_o & wire_n1O1O_o);
	wire_niOOi_sel <= ( n0lll & n0liO & n0lii);
	niOOi :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niOOi_data,
		o => wire_niOOi_o,
		sel => wire_niOOi_sel
	  );
	wire_niOOl_data <= ( wire_n1OiO_w_lg_o94w & wire_n010i_w_lg_o200w & wire_n1OOl_w_lg_o247w & wire_n1O0i_w_lg_o122w & wire_n1OiO_o & wire_n010i_o & wire_n1OOl_o & wire_n1O0i_o);
	wire_niOOl_sel <= ( n0lll & n0liO & n0lii);
	niOOl :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niOOl_data,
		o => wire_niOOl_o,
		sel => wire_niOOl_sel
	  );
	wire_niOOO_data <= ( wire_n1Oil_w_lg_o106w & wire_n011O_w_lg_o211w & wire_n1OOO_w_lg_o238w & wire_n1O0l_w_lg_o133w & wire_n1Oil_o & wire_n011O_o & wire_n1OOO_o & wire_n1O0l_o);
	wire_niOOO_sel <= ( n0lll & n0liO & n0lii);
	niOOO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_niOOO_data,
		o => wire_niOOO_o,
		sel => wire_niOOO_sel
	  );
	wire_nl00i_data <= ( wire_n1Oii_w_lg_o119w & wire_n011l_w_lg_o220w & wire_n1OOl_w_lg_o247w & wire_n1O0i_w_lg_o122w & wire_n1Oii_o & wire_n011l_o & wire_n1OOl_o & wire_n1O0i_o);
	wire_nl00i_sel <= ( n0lll & n0liO & n0lii);
	nl00i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl00i_data,
		o => wire_nl00i_o,
		sel => wire_nl00i_sel
	  );
	wire_nl00l_data <= ( wire_n1O0O_w_lg_o130w & wire_n011i_w_lg_o229w & wire_n1OOO_w_lg_o238w & wire_n1O0l_w_lg_o133w & wire_n1O0O_o & wire_n011i_o & wire_n1OOO_o & wire_n1O0l_o);
	wire_nl00l_sel <= ( n0lll & n0liO & n0lii);
	nl00l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl00l_data,
		o => wire_nl00l_o,
		sel => wire_nl00l_sel
	  );
	wire_nl00O_data <= ( wire_n1O0l_w_lg_o133w & wire_n1OOO_w_lg_o238w & wire_n011i_w_lg_o229w & wire_n1O0O_w_lg_o130w & wire_n1O0l_o & wire_n1OOO_o & wire_n011i_o & wire_n1O0O_o);
	wire_nl00O_sel <= ( n0lll & n0liO & n0lii);
	nl00O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl00O_data,
		o => wire_nl00O_o,
		sel => wire_nl00O_sel
	  );
	wire_nl01i_data <= ( wire_n1OlO_w_lg_o265w & wire_n1O1l_w_lg_o96w & wire_n1Oll_w_lg_o70w & wire_n010O_w_lg_o178w & wire_n1OlO_o & wire_n1O1l_o & wire_n1Oll_o & wire_n010O_o);
	wire_nl01i_sel <= ( n0lll & n0liO & n0lii);
	nl01i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl01i_data,
		o => wire_nl01i_o,
		sel => wire_nl01i_sel
	  );
	wire_nl01l_data <= ( wire_n1OiO_w_lg_o94w & wire_n010i_w_lg_o200w & wire_n1OlO_w_lg_o265w & wire_n1O1l_w_lg_o96w & wire_n1OiO_o & wire_n010i_o & wire_n1OlO_o & wire_n1O1l_o);
	wire_nl01l_sel <= ( n0lll & n0liO & n0lii);
	nl01l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl01l_data,
		o => wire_nl01l_o,
		sel => wire_nl01l_sel
	  );
	wire_nl01O_data <= ( wire_n1Oil_w_lg_o106w & wire_n011O_w_lg_o211w & wire_n1OOi_w_lg_o256w & wire_n1O1O_w_lg_o108w & wire_n1Oil_o & wire_n011O_o & wire_n1OOi_o & wire_n1O1O_o);
	wire_nl01O_sel <= ( n0lll & n0liO & n0lii);
	nl01O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl01O_data,
		o => wire_nl01O_o,
		sel => wire_nl01O_sel
	  );
	wire_nl0ii_data <= ( wire_n1O0i_w_lg_o122w & wire_n1OOl_w_lg_o247w & wire_n011l_w_lg_o220w & wire_n1Oii_w_lg_o119w & wire_n1O0i_o & wire_n1OOl_o & wire_n011l_o & wire_n1Oii_o);
	wire_nl0ii_sel <= ( n0lll & n0liO & n0lii);
	nl0ii :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0ii_data,
		o => wire_nl0ii_o,
		sel => wire_nl0ii_sel
	  );
	wire_nl0il_data <= ( wire_n1O1O_w_lg_o108w & wire_n1OOi_w_lg_o256w & wire_n011O_w_lg_o211w & wire_n1Oil_w_lg_o106w & wire_n1O1O_o & wire_n1OOi_o & wire_n011O_o & wire_n1Oil_o);
	wire_nl0il_sel <= ( n0lll & n0liO & n0lii);
	nl0il :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0il_data,
		o => wire_nl0il_o,
		sel => wire_nl0il_sel
	  );
	wire_nl0iO_data <= ( wire_n1O1l_w_lg_o96w & wire_n1OlO_w_lg_o265w & wire_n010i_w_lg_o200w & wire_n1OiO_w_lg_o94w & wire_n1O1l_o & wire_n1OlO_o & wire_n010i_o & wire_n1OiO_o);
	wire_nl0iO_sel <= ( n0lll & n0liO & n0lii);
	nl0iO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0iO_data,
		o => wire_nl0iO_o,
		sel => wire_nl0iO_sel
	  );
	wire_nl0li_data <= ( wire_n1Oli_w_lg_o81w & wire_n1Oli_w_lg_o81w & wire_n1Oli_w_lg_o81w & wire_n1Oli_w_lg_o81w & wire_n1Oli_o & wire_n1Oli_o & wire_n1Oli_o & wire_n1Oli_o);
	wire_nl0li_sel <= ( n0lll & n0liO & n0lii);
	nl0li :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0li_data,
		o => wire_nl0li_o,
		sel => wire_nl0li_sel
	  );
	wire_nl0ll_data <= ( wire_n1Oll_w_lg_o70w & wire_n1Oll_w_lg_o70w & wire_n1Oll_w_lg_o70w & wire_n1Oll_w_lg_o70w & wire_n1Oll_o & wire_n1Oll_o & wire_n1Oll_o & wire_n1Oll_o);
	wire_nl0ll_sel <= ( n0lll & n0liO & n0lii);
	nl0ll :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0ll_data,
		o => wire_nl0ll_o,
		sel => wire_nl0ll_sel
	  );
	wire_nl0lO_data <= ( wire_n010i_w_lg_o200w & wire_n1OiO_w_lg_o94w & wire_n1O1l_w_lg_o96w & wire_n1OlO_w_lg_o265w & wire_n010i_o & wire_n1OiO_o & wire_n1O1l_o & wire_n1OlO_o);
	wire_nl0lO_sel <= ( n0lll & n0liO & n0lii);
	nl0lO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0lO_data,
		o => wire_nl0lO_o,
		sel => wire_nl0lO_sel
	  );
	wire_nl0Oi_data <= ( wire_n011O_w_lg_o211w & wire_n1Oil_w_lg_o106w & wire_n1O1O_w_lg_o108w & wire_n1OOi_w_lg_o256w & wire_n011O_o & wire_n1Oil_o & wire_n1O1O_o & wire_n1OOi_o);
	wire_nl0Oi_sel <= ( n0lll & n0liO & n0lii);
	nl0Oi :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0Oi_data,
		o => wire_nl0Oi_o,
		sel => wire_nl0Oi_sel
	  );
	wire_nl0Ol_data <= ( wire_n011l_w_lg_o220w & wire_n1Oii_w_lg_o119w & wire_n1O0i_w_lg_o122w & wire_n1OOl_w_lg_o247w & wire_n011l_o & wire_n1Oii_o & wire_n1O0i_o & wire_n1OOl_o);
	wire_nl0Ol_sel <= ( n0lll & n0liO & n0lii);
	nl0Ol :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0Ol_data,
		o => wire_nl0Ol_o,
		sel => wire_nl0Ol_sel
	  );
	wire_nl0OO_data <= ( wire_n011i_w_lg_o229w & wire_n1O0O_w_lg_o130w & wire_n1O0l_w_lg_o133w & wire_n1OOO_w_lg_o238w & wire_n011i_o & wire_n1O0O_o & wire_n1O0l_o & wire_n1OOO_o);
	wire_nl0OO_sel <= ( n0lll & n0liO & n0lii);
	nl0OO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl0OO_data,
		o => wire_nl0OO_o,
		sel => wire_nl0OO_sel
	  );
	wire_nl10i_data <= ( wire_n1O0i_w_lg_o122w & wire_n1OOl_w_lg_o247w & wire_n010i_w_lg_o200w & wire_n1OiO_w_lg_o94w & wire_n1O0i_o & wire_n1OOl_o & wire_n010i_o & wire_n1OiO_o);
	wire_nl10i_sel <= ( n0lll & n0liO & n0lii);
	nl10i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl10i_data,
		o => wire_nl10i_o,
		sel => wire_nl10i_sel
	  );
	wire_nl10l_data <= ( wire_n1O1O_w_lg_o108w & wire_n1OOi_w_lg_o256w & wire_n010l_w_lg_o188w & wire_n1Oli_w_lg_o81w & wire_n1O1O_o & wire_n1OOi_o & wire_n010l_o & wire_n1Oli_o);
	wire_nl10l_sel <= ( n0lll & n0liO & n0lii);
	nl10l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl10l_data,
		o => wire_nl10l_o,
		sel => wire_nl10l_sel
	  );
	wire_nl10O_data <= ( wire_n1O1l_w_lg_o96w & wire_n1OlO_w_lg_o265w & wire_n010O_w_lg_o178w & wire_n1Oll_w_lg_o70w & wire_n1O1l_o & wire_n1OlO_o & wire_n010O_o & wire_n1Oll_o);
	wire_nl10O_sel <= ( n0lll & n0liO & n0lii);
	nl10O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl10O_data,
		o => wire_nl10O_o,
		sel => wire_nl10O_sel
	  );
	wire_nl11i_data <= ( wire_n1Oii_w_lg_o119w & wire_n011l_w_lg_o220w & wire_n011i_w_lg_o229w & wire_n1O0O_w_lg_o130w & wire_n1Oii_o & wire_n011l_o & wire_n011i_o & wire_n1O0O_o);
	wire_nl11i_sel <= ( n0lll & n0liO & n0lii);
	nl11i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl11i_data,
		o => wire_nl11i_o,
		sel => wire_nl11i_sel
	  );
	wire_nl11l_data <= ( wire_n1O0O_w_lg_o130w & wire_n011i_w_lg_o229w & wire_n011l_w_lg_o220w & wire_n1Oii_w_lg_o119w & wire_n1O0O_o & wire_n011i_o & wire_n011l_o & wire_n1Oii_o);
	wire_nl11l_sel <= ( n0lll & n0liO & n0lii);
	nl11l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl11l_data,
		o => wire_nl11l_o,
		sel => wire_nl11l_sel
	  );
	wire_nl11O_data <= ( wire_n1O0l_w_lg_o133w & wire_n1OOO_w_lg_o238w & wire_n011O_w_lg_o211w & wire_n1Oil_w_lg_o106w & wire_n1O0l_o & wire_n1OOO_o & wire_n011O_o & wire_n1Oil_o);
	wire_nl11O_sel <= ( n0lll & n0liO & n0lii);
	nl11O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl11O_data,
		o => wire_nl11O_o,
		sel => wire_nl11O_sel
	  );
	wire_nl1ii_data <= ( wire_n010O_w_lg_o178w & wire_n1Oll_w_lg_o70w & wire_n1O1l_w_lg_o96w & wire_n1OlO_w_lg_o265w & wire_n010O_o & wire_n1Oll_o & wire_n1O1l_o & wire_n1OlO_o);
	wire_nl1ii_sel <= ( n0lll & n0liO & n0lii);
	nl1ii :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1ii_data,
		o => wire_nl1ii_o,
		sel => wire_nl1ii_sel
	  );
	wire_nl1il_data <= ( wire_n010l_w_lg_o188w & wire_n1Oli_w_lg_o81w & wire_n1O1O_w_lg_o108w & wire_n1OOi_w_lg_o256w & wire_n010l_o & wire_n1Oli_o & wire_n1O1O_o & wire_n1OOi_o);
	wire_nl1il_sel <= ( n0lll & n0liO & n0lii);
	nl1il :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1il_data,
		o => wire_nl1il_o,
		sel => wire_nl1il_sel
	  );
	wire_nl1iO_data <= ( wire_n010i_w_lg_o200w & wire_n1OiO_w_lg_o94w & wire_n1O0i_w_lg_o122w & wire_n1OOl_w_lg_o247w & wire_n010i_o & wire_n1OiO_o & wire_n1O0i_o & wire_n1OOl_o);
	wire_nl1iO_sel <= ( n0lll & n0liO & n0lii);
	nl1iO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1iO_data,
		o => wire_nl1iO_o,
		sel => wire_nl1iO_sel
	  );
	wire_nl1li_data <= ( wire_n011O_w_lg_o211w & wire_n1Oil_w_lg_o106w & wire_n1O0l_w_lg_o133w & wire_n1OOO_w_lg_o238w & wire_n011O_o & wire_n1Oil_o & wire_n1O0l_o & wire_n1OOO_o);
	wire_nl1li_sel <= ( n0lll & n0liO & n0lii);
	nl1li :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1li_data,
		o => wire_nl1li_o,
		sel => wire_nl1li_sel
	  );
	wire_nl1ll_data <= ( wire_n011l_w_lg_o220w & wire_n1Oii_w_lg_o119w & wire_n1O0O_w_lg_o130w & wire_n011i_w_lg_o229w & wire_n011l_o & wire_n1Oii_o & wire_n1O0O_o & wire_n011i_o);
	wire_nl1ll_sel <= ( n0lll & n0liO & n0lii);
	nl1ll :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1ll_data,
		o => wire_nl1ll_o,
		sel => wire_nl1ll_sel
	  );
	wire_nl1lO_data <= ( wire_n011i_w_lg_o229w & wire_n1O0O_w_lg_o130w & wire_n1Oii_w_lg_o119w & wire_n011l_w_lg_o220w & wire_n011i_o & wire_n1O0O_o & wire_n1Oii_o & wire_n011l_o);
	wire_nl1lO_sel <= ( n0lll & n0liO & n0lii);
	nl1lO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1lO_data,
		o => wire_nl1lO_o,
		sel => wire_nl1lO_sel
	  );
	wire_nl1Oi_data <= ( wire_n1OOO_w_lg_o238w & wire_n1O0l_w_lg_o133w & wire_n1Oil_w_lg_o106w & wire_n011O_w_lg_o211w & wire_n1OOO_o & wire_n1O0l_o & wire_n1Oil_o & wire_n011O_o);
	wire_nl1Oi_sel <= ( n0lll & n0liO & n0lii);
	nl1Oi :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1Oi_data,
		o => wire_nl1Oi_o,
		sel => wire_nl1Oi_sel
	  );
	wire_nl1Ol_data <= ( wire_n1OOl_w_lg_o247w & wire_n1O0i_w_lg_o122w & wire_n1OiO_w_lg_o94w & wire_n010i_w_lg_o200w & wire_n1OOl_o & wire_n1O0i_o & wire_n1OiO_o & wire_n010i_o);
	wire_nl1Ol_sel <= ( n0lll & n0liO & n0lii);
	nl1Ol :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1Ol_data,
		o => wire_nl1Ol_o,
		sel => wire_nl1Ol_sel
	  );
	wire_nl1OO_data <= ( wire_n1OOi_w_lg_o256w & wire_n1O1O_w_lg_o108w & wire_n1Oli_w_lg_o81w & wire_n010l_w_lg_o188w & wire_n1OOi_o & wire_n1O1O_o & wire_n1Oli_o & wire_n010l_o);
	wire_nl1OO_sel <= ( n0lll & n0liO & n0lii);
	nl1OO :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1OO_data,
		o => wire_nl1OO_o,
		sel => wire_nl1OO_sel
	  );
	wire_nli0i_data <= ( wire_n1OlO_w_lg_o265w & wire_n1O1l_w_lg_o96w & wire_n1OiO_w_lg_o94w & wire_n010i_w_lg_o200w & wire_n1OlO_o & wire_n1O1l_o & wire_n1OiO_o & wire_n010i_o);
	wire_nli0i_sel <= ( n0lll & n0liO & n0lii);
	nli0i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli0i_data,
		o => wire_nli0i_o,
		sel => wire_nli0i_sel
	  );
	wire_nli0l_data <= ( wire_n010l_w_lg_o188w & wire_n010l_w_lg_o188w & wire_n010l_w_lg_o188w & wire_n010l_w_lg_o188w & wire_n010l_o & wire_n010l_o & wire_n010l_o & wire_n010l_o);
	wire_nli0l_sel <= ( n0lll & n0liO & n0lii);
	nli0l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli0l_data,
		o => wire_nli0l_o,
		sel => wire_nli0l_sel
	  );
	wire_nli0O_data <= ( wire_n010O_w_lg_o178w & wire_n010O_w_lg_o178w & wire_n010O_w_lg_o178w & wire_n010O_w_lg_o178w & wire_n010O_o & wire_n010O_o & wire_n010O_o & wire_n010O_o);
	wire_nli0O_sel <= ( n0lll & n0liO & n0lii);
	nli0O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli0O_data,
		o => wire_nli0O_o,
		sel => wire_nli0O_sel
	  );
	wire_nli1i_data <= ( wire_n1OOO_w_lg_o238w & wire_n1O0l_w_lg_o133w & wire_n1O0O_w_lg_o130w & wire_n011i_w_lg_o229w & wire_n1OOO_o & wire_n1O0l_o & wire_n1O0O_o & wire_n011i_o);
	wire_nli1i_sel <= ( n0lll & n0liO & n0lii);
	nli1i :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli1i_data,
		o => wire_nli1i_o,
		sel => wire_nli1i_sel
	  );
	wire_nli1l_data <= ( wire_n1OOl_w_lg_o247w & wire_n1O0i_w_lg_o122w & wire_n1Oii_w_lg_o119w & wire_n011l_w_lg_o220w & wire_n1OOl_o & wire_n1O0i_o & wire_n1Oii_o & wire_n011l_o);
	wire_nli1l_sel <= ( n0lll & n0liO & n0lii);
	nli1l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli1l_data,
		o => wire_nli1l_o,
		sel => wire_nli1l_sel
	  );
	wire_nli1O_data <= ( wire_n1OOi_w_lg_o256w & wire_n1O1O_w_lg_o108w & wire_n1Oil_w_lg_o106w & wire_n011O_w_lg_o211w & wire_n1OOi_o & wire_n1O1O_o & wire_n1Oil_o & wire_n011O_o);
	wire_nli1O_sel <= ( n0lll & n0liO & n0lii);
	nli1O :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nli1O_data,
		o => wire_nli1O_o,
		sel => wire_nli1O_sel
	  );
	wire_nliii_data <= ( wire_n1Oll_w_lg_o70w & wire_n1O1l_w_lg_o96w & wire_n1Oll_o & wire_n1O1l_o);
	wire_nliii_sel <= ( n0lll & n0liO);
	nliii :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nliii_data,
		o => wire_nliii_o,
		sel => wire_nliii_sel
	  );
	wire_nliil_data <= ( wire_n1Oli_w_lg_o81w & wire_n1O1O_w_lg_o108w & wire_n1Oli_o & wire_n1O1O_o);
	wire_nliil_sel <= ( n0lll & n0liO);
	nliil :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nliil_data,
		o => wire_nliil_o,
		sel => wire_nliil_sel
	  );
	wire_nliiO_data <= ( wire_n1OiO_w_lg_o94w & wire_n1O0i_w_lg_o122w & wire_n1OiO_o & wire_n1O0i_o);
	wire_nliiO_sel <= ( n0lll & n0liO);
	nliiO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nliiO_data,
		o => wire_nliiO_o,
		sel => wire_nliiO_sel
	  );
	wire_nlili_data <= ( wire_n1Oil_w_lg_o106w & wire_n1O0l_w_lg_o133w & wire_n1Oil_o & wire_n1O0l_o);
	wire_nlili_sel <= ( n0lll & n0liO);
	nlili :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlili_data,
		o => wire_nlili_o,
		sel => wire_nlili_sel
	  );
	wire_nlill_data <= ( wire_n1Oii_w_lg_o119w & wire_n1O0O_w_lg_o130w & wire_n1Oii_o & wire_n1O0O_o);
	wire_nlill_sel <= ( n0lll & n0liO);
	nlill :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlill_data,
		o => wire_nlill_o,
		sel => wire_nlill_sel
	  );
	wire_nlilO_data <= ( wire_n1O0O_w_lg_o130w & wire_n1Oii_w_lg_o119w & wire_n1O0O_o & wire_n1Oii_o);
	wire_nlilO_sel <= ( n0lll & n0liO);
	nlilO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlilO_data,
		o => wire_nlilO_o,
		sel => wire_nlilO_sel
	  );
	wire_nliOi_data <= ( wire_n1O0l_w_lg_o133w & wire_n1Oil_w_lg_o106w & wire_n1O0l_o & wire_n1Oil_o);
	wire_nliOi_sel <= ( n0lll & n0liO);
	nliOi :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nliOi_data,
		o => wire_nliOi_o,
		sel => wire_nliOi_sel
	  );
	wire_nliOl_data <= ( wire_n1O0i_w_lg_o122w & wire_n1OiO_w_lg_o94w & wire_n1O0i_o & wire_n1OiO_o);
	wire_nliOl_sel <= ( n0lll & n0liO);
	nliOl :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nliOl_data,
		o => wire_nliOl_o,
		sel => wire_nliOl_sel
	  );
	wire_nliOO_data <= ( wire_n1O1O_w_lg_o108w & wire_n1Oli_w_lg_o81w & wire_n1O1O_o & wire_n1Oli_o);
	wire_nliOO_sel <= ( n0lll & n0liO);
	nliOO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nliOO_data,
		o => wire_nliOO_o,
		sel => wire_nliOO_sel
	  );
	wire_nll0i_data <= ( wire_n1OOl_w_lg_o247w & wire_n1OOl_w_lg_o247w & wire_n1OOl_o & wire_n1OOl_o);
	wire_nll0i_sel <= ( n0lll & n0liO);
	nll0i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nll0i_data,
		o => wire_nll0i_o,
		sel => wire_nll0i_sel
	  );
	wire_nll0l_data <= ( wire_n1OOO_w_lg_o238w & wire_n1OOO_w_lg_o238w & wire_n1OOO_o & wire_n1OOO_o);
	wire_nll0l_sel <= ( n0lll & n0liO);
	nll0l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nll0l_data,
		o => wire_nll0l_o,
		sel => wire_nll0l_sel
	  );
	wire_nll0O_data <= ( wire_n011i_w_lg_o229w & wire_n011i_w_lg_o229w & wire_n011i_o & wire_n011i_o);
	wire_nll0O_sel <= ( n0lll & n0liO);
	nll0O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nll0O_data,
		o => wire_nll0O_o,
		sel => wire_nll0O_sel
	  );
	wire_nll1i_data <= ( wire_n1O1l_w_lg_o96w & wire_n1Oll_w_lg_o70w & wire_n1O1l_o & wire_n1Oll_o);
	wire_nll1i_sel <= ( n0lll & n0liO);
	nll1i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nll1i_data,
		o => wire_nll1i_o,
		sel => wire_nll1i_sel
	  );
	wire_nll1l_data <= ( wire_n1OlO_w_lg_o265w & wire_n1OlO_w_lg_o265w & wire_n1OlO_o & wire_n1OlO_o);
	wire_nll1l_sel <= ( n0lll & n0liO);
	nll1l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nll1l_data,
		o => wire_nll1l_o,
		sel => wire_nll1l_sel
	  );
	wire_nll1O_data <= ( wire_n1OOi_w_lg_o256w & wire_n1OOi_w_lg_o256w & wire_n1OOi_o & wire_n1OOi_o);
	wire_nll1O_sel <= ( n0lll & n0liO);
	nll1O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nll1O_data,
		o => wire_nll1O_o,
		sel => wire_nll1O_sel
	  );
	wire_nllii_data <= ( wire_n011l_w_lg_o220w & wire_n011l_w_lg_o220w & wire_n011l_o & wire_n011l_o);
	wire_nllii_sel <= ( n0lll & n0liO);
	nllii :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllii_data,
		o => wire_nllii_o,
		sel => wire_nllii_sel
	  );
	wire_nllil_data <= ( wire_n011O_w_lg_o211w & wire_n011O_w_lg_o211w & wire_n011O_o & wire_n011O_o);
	wire_nllil_sel <= ( n0lll & n0liO);
	nllil :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllil_data,
		o => wire_nllil_o,
		sel => wire_nllil_sel
	  );
	wire_nlliO_data <= ( wire_ni0Oll40_w_lg_w_lg_q202w203w & wire_n010i_w_lg_o200w & wire_n010i_o & wire_ni0OlO38_w_lg_w_lg_q195w196w);
	wire_nlliO_sel <= ( n0lll & n0liO);
	nlliO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlliO_data,
		o => wire_nlliO_o,
		sel => wire_nlliO_sel
	  );
	wire_nllli_data <= ( wire_n010l_w_lg_o188w & wire_ni0OOi36_w_lg_w_lg_q187w189w & wire_n010l_o & wire_n010l_o);
	wire_nllli_sel <= ( n0lll & n0liO);
	nllli :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllli_data,
		o => wire_nllli_o,
		sel => wire_nllli_sel
	  );
	wire_nllll_data <= ( wire_n010O_w_lg_o178w & wire_n010O_w_lg_o178w & wire_n010O_o & wire_n010O_o);
	wire_nllll_sel <= ( n0lll & n0liO);
	nllll :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllll_data,
		o => wire_nllll_o,
		sel => wire_nllll_sel
	  );
	wire_nlllO_data <= ( wire_n1OiO_w_lg_o94w & wire_n1O1l_w_lg_o96w & wire_n1OiO_o & wire_n1O1l_o);
	wire_nlllO_sel <= ( n0lll & n0liO);
	nlllO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlllO_data,
		o => wire_nlllO_o,
		sel => wire_nlllO_sel
	  );
	wire_nllOi_data <= ( wire_n1Oil_w_lg_o106w & wire_ni0OOl34_w_lg_w_lg_q160w161w & wire_n1Oil_o & wire_n1O1O_o);
	wire_nllOi_sel <= ( n0lll & n0liO);
	nllOi :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllOi_data,
		o => wire_nllOi_o,
		sel => wire_nllOi_sel
	  );
	wire_nllOl_data <= ( wire_n1Oii_w_lg_o119w & wire_n1O0i_w_lg_o122w & wire_n1Oii_o & wire_n1O0i_o);
	wire_nllOl_sel <= ( n0lll & n0liO);
	nllOl :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllOl_data,
		o => wire_nllOl_o,
		sel => wire_nllOl_sel
	  );
	wire_nllOO_data <= ( wire_n1O0O_w_lg_o130w & wire_n1O0l_w_lg_o133w & wire_n1O0O_o & wire_ni0OOO32_w_lg_w_lg_q139w140w);
	wire_nllOO_sel <= ( n0lll & n0liO);
	nllOO :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nllOO_data,
		o => wire_nllOO_o,
		sel => wire_nllOO_sel
	  );
	wire_nlO0i_data <= ( wire_n1O1l_w_lg_o96w & wire_n1OiO_w_lg_o94w & wire_n1O1l_o & wire_n1OiO_o);
	wire_nlO0i_sel <= ( n0lll & wire_nii10l22_w_lg_w_lg_q86w87w);
	nlO0i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlO0i_data,
		o => wire_nlO0i_o,
		sel => wire_nlO0i_sel
	  );
	wire_nlO0l_data <= ( wire_nii10O20_w_lg_w_lg_q83w84w & wire_n1Oli_w_lg_o81w & wire_n1Oli_o & wire_n1Oli_o);
	wire_nlO0l_sel <= ( wire_nii1ii18_w_lg_w_lg_q75w76w & n0liO);
	nlO0l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlO0l_data,
		o => wire_nlO0l_o,
		sel => wire_nlO0l_sel
	  );
	wire_nlO0O_data <= ( wire_n1Oll_w_lg_o70w & wire_n1Oll_w_lg_o70w & wire_nii1il16_w_lg_w_lg_q67w68w & wire_n1Oll_o);
	wire_nlO0O_sel <= ( n0lll & n0liO);
	nlO0O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlO0O_data,
		o => wire_nlO0O_o,
		sel => wire_nlO0O_sel
	  );
	wire_nlO1i_data <= ( wire_nii11i30_w_lg_w_lg_q132w134w & wire_n1O0O_w_lg_o130w & wire_n1O0l_o & wire_n1O0O_o);
	wire_nlO1i_sel <= ( n0lll & n0liO);
	nlO1i :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlO1i_data,
		o => wire_nlO1i_o,
		sel => wire_nlO1i_sel
	  );
	wire_nlO1l_data <= ( wire_n1O0i_w_lg_o122w & wire_nii11l28_w_lg_w_lg_q118w120w & wire_nii11O26_w_lg_w_lg_q115w116w & wire_n1Oii_o);
	wire_nlO1l_sel <= ( n0lll & n0liO);
	nlO1l :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlO1l_data,
		o => wire_nlO1l_o,
		sel => wire_nlO1l_sel
	  );
	wire_nlO1O_data <= ( wire_n1O1O_w_lg_o108w & wire_n1Oil_w_lg_o106w & wire_n1O1O_o & wire_n1Oil_o);
	wire_nlO1O_sel <= ( wire_nii10i24_w_lg_w_lg_q100w101w & n0liO);
	nlO1O :  oper_mux
	  GENERIC MAP (
		width_data => 4,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nlO1O_data,
		o => wire_nlO1O_o,
		sel => wire_nlO1O_sel
	  );

 END RTL; --cycloneiv_hssi_tx_digi_enc_chnl_top
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 10.0SP1 cbx_mgl 2010:08:18:21:20:44:SJ cbx_simgen 2010:08:18:21:16:35:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

--synthesis_resources = lut 12 mux21 13 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  cycloneiv_hssi_tx_digi_iq_pipe_tx IS 
	 PORT 
	 ( 
		 fifo_rd_clk_raw	:	IN  STD_LOGIC;
		 fifo_select_in_centrl	:	IN  STD_LOGIC;
		 fifo_select_in_pipe_quad_down	:	IN  STD_LOGIC;
		 fifo_select_in_pipe_quad_up	:	IN  STD_LOGIC;
		 fifo_select_out_pipe	:	OUT  STD_LOGIC;
		 rd_enable_in_centrl	:	IN  STD_LOGIC;
		 rd_enable_in_pipe_quad_down	:	IN  STD_LOGIC;
		 rd_enable_in_pipe_quad_up	:	IN  STD_LOGIC;
		 rd_enable_out_pipe	:	OUT  STD_LOGIC;
		 refclk_b_raw	:	IN  STD_LOGIC;
		 rfreerun_tx	:	IN  STD_LOGIC;
		 rmaster_tx	:	IN  STD_LOGIC;
		 rmaster_up_tx	:	IN  STD_LOGIC;
		 rpipeline_bypass_tx	:	IN  STD_LOGIC;
		 soft_reset_rclk1	:	IN  STD_LOGIC;
		 soft_reset_wclk1	:	IN  STD_LOGIC;
		 tx_div2_sync_in_centrl	:	IN  STD_LOGIC;
		 tx_div2_sync_in_pipe_quad_down	:	IN  STD_LOGIC;
		 tx_div2_sync_in_pipe_quad_up	:	IN  STD_LOGIC;
		 tx_div2_sync_out_pipe	:	OUT  STD_LOGIC;
		 txrst	:	IN  STD_LOGIC;
		 wr_clk_pos_raw	:	IN  STD_LOGIC;
		 wr_enable_in_centrl	:	IN  STD_LOGIC;
		 wr_enable_in_pipe_quad_down	:	IN  STD_LOGIC;
		 wr_enable_in_pipe_quad_up	:	IN  STD_LOGIC;
		 wr_enable_out_pipe	:	OUT  STD_LOGIC
	 ); 
 END cycloneiv_hssi_tx_digi_iq_pipe_tx;

 ARCHITECTURE RTL OF cycloneiv_hssi_tx_digi_iq_pipe_tx IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 n0ii7	:	STD_LOGIC := '0';
	 SIGNAL	 n0ii8	:	STD_LOGIC := '0';
	 SIGNAL	 n0il5	:	STD_LOGIC := '0';
	 SIGNAL	 n0il6	:	STD_LOGIC := '0';
	 SIGNAL	 n0li3	:	STD_LOGIC := '0';
	 SIGNAL	 n0li4	:	STD_LOGIC := '0';
	 SIGNAL	 n0Oi1	:	STD_LOGIC := '0';
	 SIGNAL	 n0Oi2	:	STD_LOGIC := '0';
	 SIGNAL	n1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1i_CLRN	:	STD_LOGIC;
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl_CLRN	:	STD_LOGIC;
	 SIGNAL	ni	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO_CLRN	:	STD_LOGIC;
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlOl_PRN	:	STD_LOGIC;
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1O_w_lg_dataout8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_rmaster_tx6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset_rclk12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset_wclk19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_txrst5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n0ll :	STD_LOGIC;
 BEGIN

	wire_w_lg_rmaster_tx6w(0) <= NOT rmaster_tx;
	wire_w_lg_soft_reset_rclk12w(0) <= NOT soft_reset_rclk1;
	wire_w_lg_soft_reset_wclk19w(0) <= NOT soft_reset_wclk1;
	wire_w_lg_txrst5w(0) <= NOT txrst;
	fifo_select_out_pipe <= wire_nllO_dataout;
	n0ll <= '1';
	rd_enable_out_pipe <= wire_nlli_dataout;
	tx_div2_sync_out_pipe <= wire_nlOi_dataout;
	wr_enable_out_pipe <= wire_nlll_dataout;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0ii7 <= n0ii8;
		END IF;
		if (now = 0 ns) then
			n0ii7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0ii8 <= n0ii7;
		END IF;
	END PROCESS;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0il5 <= n0il6;
		END IF;
		if (now = 0 ns) then
			n0il5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0il6 <= n0il5;
		END IF;
	END PROCESS;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0li3 <= n0li4;
		END IF;
		if (now = 0 ns) then
			n0li3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0li4 <= n0li3;
		END IF;
	END PROCESS;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0Oi1 <= n0Oi2;
		END IF;
		if (now = 0 ns) then
			n0Oi1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b_raw)
	BEGIN
		IF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN n0Oi2 <= n0Oi1;
		END IF;
	END PROCESS;
	PROCESS (refclk_b_raw, wire_n1O_dataout, wire_n1i_CLRN)
	BEGIN
		IF (wire_n1O_dataout = '1') THEN
				n1l <= '1';
		ELSIF (wire_n1i_CLRN = '0') THEN
				n1l <= '0';
		ELSIF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN
				n1l <= wire_nli_dataout;
		END IF;
	END PROCESS;
	wire_n1i_CLRN <= (n0il6 XOR n0il5);
	PROCESS (fifo_rd_clk_raw, wire_nl_CLRN)
	BEGIN
		IF (wire_nl_CLRN = '0') THEN
				nO <= '0';
		ELSIF (fifo_rd_clk_raw = '1' AND fifo_rd_clk_raw'event) THEN
				nO <= wire_n0i_dataout;
		END IF;
	END PROCESS;
	wire_nl_CLRN <= ((n0Oi2 XOR n0Oi1) AND wire_w_lg_soft_reset_rclk12w(0));
	PROCESS (refclk_b_raw, txrst, wire_nlO_CLRN)
	BEGIN
		IF (txrst = '1') THEN
				ni <= '1';
		ELSIF (wire_nlO_CLRN = '0') THEN
				ni <= '0';
		ELSIF (refclk_b_raw = '1' AND refclk_b_raw'event) THEN
				ni <= wire_nil_dataout;
		END IF;
	END PROCESS;
	wire_nlO_CLRN <= (n0li4 XOR n0li3);
	PROCESS (wr_clk_pos_raw, wire_nlOl_PRN, soft_reset_wclk1)
	BEGIN
		IF (wire_nlOl_PRN = '0') THEN
				nlOO <= '1';
		ELSIF (soft_reset_wclk1 = '1') THEN
				nlOO <= '0';
		ELSIF (wr_clk_pos_raw = '1' AND wr_clk_pos_raw'event) THEN
				nlOO <= wire_n0O_dataout;
		END IF;
	END PROCESS;
	wire_nlOl_PRN <= (n0ii8 XOR n0ii7);
	wire_n0i_dataout <= wire_n0l_dataout WHEN wire_w_lg_rmaster_tx6w(0) = '1'  ELSE rd_enable_in_centrl;
	wire_n0l_dataout <= rd_enable_in_pipe_quad_up WHEN rmaster_up_tx = '1'  ELSE rd_enable_in_pipe_quad_down;
	wire_n0O_dataout <= wire_nii_dataout WHEN wire_w_lg_rmaster_tx6w(0) = '1'  ELSE wr_enable_in_centrl;
	wire_n1O_dataout <= txrst AND NOT(rfreerun_tx);
	wire_n1O_w_lg_dataout8w(0) <= NOT wire_n1O_dataout;
	wire_nii_dataout <= wr_enable_in_pipe_quad_up WHEN rmaster_up_tx = '1'  ELSE wr_enable_in_pipe_quad_down;
	wire_nil_dataout <= wire_niO_dataout WHEN wire_w_lg_rmaster_tx6w(0) = '1'  ELSE fifo_select_in_centrl;
	wire_niO_dataout <= fifo_select_in_pipe_quad_up WHEN rmaster_up_tx = '1'  ELSE fifo_select_in_pipe_quad_down;
	wire_nli_dataout <= wire_nll_dataout WHEN wire_w_lg_rmaster_tx6w(0) = '1'  ELSE tx_div2_sync_in_centrl;
	wire_nll_dataout <= tx_div2_sync_in_pipe_quad_up WHEN rmaster_up_tx = '1'  ELSE tx_div2_sync_in_pipe_quad_down;
	wire_nlli_dataout <= wire_n0i_dataout WHEN rpipeline_bypass_tx = '1'  ELSE nO;
	wire_nlll_dataout <= wire_n0O_dataout WHEN rpipeline_bypass_tx = '1'  ELSE nlOO;
	wire_nllO_dataout <= wire_nil_dataout WHEN rpipeline_bypass_tx = '1'  ELSE ni;
	wire_nlOi_dataout <= wire_nli_dataout WHEN rpipeline_bypass_tx = '1'  ELSE n1l;

 END RTL; --cycloneiv_hssi_tx_digi_iq_pipe_tx
--synopsys translate_on
--VALID FILE


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_tx_digi IS
   PORT (
      
      -- Reset inputs
      txpcs_rst                       : IN STD_LOGIC;		-- TX PCS resets
      
      -- Scan inputs
      scan_mode                       : IN STD_LOGIC;		-- 1'b1 = scan mode active; 
      -- 1'b0 = normal mode
      -- TX PCS channel inputs/outputs
      txd                             : IN STD_LOGIC_VECTOR(43 DOWNTO 0);		-- TXD data bus from PLD
      pld_tx_clk                      : IN STD_LOGIC;		-- XGMII tx clock for this lane from PLD
      polinv_tx                       : IN STD_LOGIC;		-- TX polarity inversion dynamic control signal
      -- 8-bit tx data from 10G ethernet 
      -- tx state machine (tx_sm)
      -- 1-bit tx control from 10G ethernet tx state machine (tx_sm)
      -- Global parallel clock from TX PLL
      -- Individual TX PMA clock from TX PMA Extension
      -- Dynamic signal causes reverse loopback
      rev_loop_data                   : IN STD_LOGIC_VECTOR(19 DOWNTO 0);		-- 10 bit data from RX rate matching FIFO, reverse loopback
      wrenable_tx                     : IN STD_LOGIC;		-- TX phase comp. FIFO write enable control signal
      rddisable_tx                    : IN STD_LOGIC;		-- TX phase comp. FIFO read disable control signal
      phfifourst_tx                   : IN STD_LOGIC;		-- TX phase comp. FIFO user reset
      
      -- TX PIPE interface signals
      txdetectrxloopback              : IN STD_LOGIC;
      --input			txelecidle; 	txd[9]
      --input			txcompliance;	txd[10] and txd[32]
      powerdown                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      revloopback                     : IN STD_LOGIC;
      
      -- push through TX Phase Comp FIFO
      txswing                         : IN STD_LOGIC;
      pcs_txdeemph                    : IN STD_LOGIC;
      pcs_txmargin                    : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE interface signals
      rxpolarity                      : IN STD_LOGIC;
      polinv_rx                       : IN STD_LOGIC;
      
      --PRBS-CID dynamic signal
      
      full_tx                         : OUT STD_LOGIC;		-- TX Phase comp. FIFO full flag
      empty_tx                        : OUT STD_LOGIC;		-- TX Phase comp. FIFO empty flag
      tx_data_ts                      : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      tx_ctl_ts                       : IN STD_LOGIC;
      refclk_pma                      : IN STD_LOGIC;
      txpma_local_clk                 : IN STD_LOGIC;
      tx_clk_out                      : OUT STD_LOGIC;
      tx_data_tc                      : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);		-- 8-bit tx data from tx_ctrl to XAUI TX SM
      tx_ctl_tc                       : OUT STD_LOGIC;		-- TX control/TX data bit 8 from tx_ctrl to XAUI TX SM
      pudr                            : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);		-- TX PCS 20-bit code group bus to TX PMA
      rd_enable_sync                  : OUT STD_LOGIC;
      refclk_b                        : OUT STD_LOGIC;
      txlp20b                         : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);		-- tx 20-bit code group bus to RX PCS for loopback
      tx_pipe_clk                     : OUT STD_LOGIC;		-- TX PIPE interface clock
      encoder_testbus                 : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);		-- Test bus from 8B10B encoder
      tx_ctrl_testbus                 : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);		-- Test bus from TX FIFO
      tx_pipe_soft_reset              : OUT STD_LOGIC;		-- TX PIPE soft reset from TX FIFO
      tx_pipe_electidle               : OUT STD_LOGIC;		-- TxElecIdle output from TX FIFO
      
      -- TX PIPE interface signals
      txdetectrxloopback_int          : OUT STD_LOGIC;
      --output			txelecidle; 	txd[9]
      --output			txcompliance;	txd[10] and txd[32]
      powerdown_int                   : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      revloopback_int                 : OUT STD_LOGIC;
      
      -- push through TX Phase Comp FIFO
      phfifo_txswing                  : OUT STD_LOGIC;
      phfifo_txdeemph                 : OUT STD_LOGIC;
      phfifo_txmargin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE interface signals
      rxpolarity_int                  : OUT STD_LOGIC;
      polinv_rx_int                   : OUT STD_LOGIC;
      
      -- TX PCS CRAMs
      rrev_loopbk                     : IN STD_LOGIC;		-- CRAM - Enable dynamic Reverse, PIPE mode
      rev_loopbk                      : IN STD_LOGIC;
      eidleinfersel                   : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      gray_eidleinfersel              : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      rbisten_tx                      : IN STD_LOGIC;		-- ENBIST CRAM
      rforce_disp                     : IN STD_LOGIC;		-- Acting with TXD[9, 19] forces current disparity to 1 or 0
      rib_force_disp                  : IN STD_LOGIC;		-- Disparity force CRAM in IB mode
      rforce_echar                    : IN STD_LOGIC;		-- Force /E/ char CRAM
      rforce_kchar                    : IN STD_LOGIC;		-- Force /K/ char CRAM
      rendec_tx                       : IN STD_LOGIC;		-- Enable 8B/10B encoder CRAM
      rge_xaui_tx                     : IN STD_LOGIC;		-- GIGE Idle test enable CRAM
      rdwidth_tx                      : IN STD_LOGIC;		-- TX parallel interface data width CRAM
      rtxfifo_dis                     : IN STD_LOGIC;		-- TX FIFO disable CRAM
      rcascaded_8b10b_en_tx           : IN STD_LOGIC;		-- Caascaded 8b/10b encoder enable CRAM
      rprbsen_tx                      : IN STD_LOGIC;		-- PRBS generator enable CRAM
      rprbs_sel                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);		-- PRBS selection CRAM
      rbist_sel                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);		-- BIST selection CRAM
      rcxpat_chnl_en                  : IN STD_LOGIC_VECTOR(1 DOWNTO 0);		-- CRPAT or CJPAT selection CRAM
      renpolinv_tx                    : IN STD_LOGIC;		-- TX Polarity inversion enable CRAM
      rphfifopldentx                  : IN STD_LOGIC;		-- TX phase comp. FIFO PLD read/write enable CRAM
      rphfifoursttx                   : IN STD_LOGIC;		-- TX phase comp. FIFO user reset enable CRAM
      rfreerun_tx                     : IN STD_LOGIC;		-- TX_CLK out free running during TX PCS reset enable CRAM
      rtxwrclksel                     : IN STD_LOGIC;		-- TX FIFO write clock selection CRAM
      rtxrdclksel                     : IN STD_LOGIC;		-- TX FIFO read clock selection CRAM
      renbitrev_tx                    : IN STD_LOGIC;		-- TX bit reversal enable CRAM
      rensymswap_tx                   : IN STD_LOGIC;		-- TX symbol swap enable CRAM
      r8b10b_enc_ibm_en               : IN STD_LOGIC;		-- 8B10B Encoder fix enable CRAM
      rtxfifo_lowlatency_en           : IN STD_LOGIC;		-- TX FIFO low latency enable CRAM
      rpmadwidth_tx                   : IN STD_LOGIC;		-- TX PCS to TX PMA data width selection CRAM
      rpma_doublewidth_tx             : IN STD_LOGIC;		-- PCS/PMA double width (16/20) selection CRAM
      rtx_pipe_enable                 : IN STD_LOGIC;		-- TX PIPE enable CRAM
      -- CID pattern to be 0 or 1
      -- Length of CID pattern in cycles
      
      -- Common PCS CRAMs
      rindv_tx                        : IN STD_LOGIC;		-- TX SM bypassing CRAM
      rendec_data_sel_tx              : IN STD_LOGIC;		-- TX 8B10B encoder data in selection CRAM
      rtxpcsbypass_en                 : IN STD_LOGIC;		-- CRAM for enable low-latency PCS bypass mode
      rtxpcsclkpwdn                   : IN STD_LOGIC;
      rauto_speed_ena                 : IN STD_LOGIC;
      rfreq_sel                       : IN STD_LOGIC;
      gen2ngen1                       : IN STD_LOGIC;
      gen2ngen1_bundle                : IN STD_LOGIC;
      rcid_pattern_tx                 : IN STD_LOGIC;
      rcid_len_tx                     : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      
      -- new signal inputs for bundling
      tx_div2_sync_in_centrl          : IN STD_LOGIC;
      tx_div2_sync_in_quad_up         : IN STD_LOGIC;
      tx_div2_sync_in_quad_down       : IN STD_LOGIC;
      wr_enable_in_centrl             : IN STD_LOGIC;
      wr_enable_in_quad_up            : IN STD_LOGIC;
      wr_enable_in_quad_down          : IN STD_LOGIC;
      rd_enable_in_centrl             : IN STD_LOGIC;
      rd_enable_in_quad_up            : IN STD_LOGIC;
      rd_enable_in_quad_down          : IN STD_LOGIC;
      fifo_select_in_centrl           : IN STD_LOGIC;
      fifo_select_in_quad_up          : IN STD_LOGIC;
      fifo_select_in_quad_down        : IN STD_LOGIC;
      
      dis_pc_byte                     : IN STD_LOGIC;
      reset_pc_ptrs                   : IN STD_LOGIC;
      reset_pc_ptrs_in_centrl         : IN STD_LOGIC;
      reset_pc_ptrs_in_quad_up        : IN STD_LOGIC;
      reset_pc_ptrs_in_quad_down      : IN STD_LOGIC;
      tx_div2_sync_in_pipe_quad_up    : IN STD_LOGIC;
      tx_div2_sync_in_pipe_quad_down  : IN STD_LOGIC;
      wr_enable_in_pipe_quad_up       : IN STD_LOGIC;
      wr_enable_in_pipe_quad_down     : IN STD_LOGIC;
      rd_enable_in_pipe_quad_up       : IN STD_LOGIC;
      rd_enable_in_pipe_quad_down     : IN STD_LOGIC;
      fifo_select_in_pipe_quad_up     : IN STD_LOGIC;
      fifo_select_in_pipe_quad_down   : IN STD_LOGIC;
      
      -- new MDIO inputs for bundling and auto speed
      rmaster_tx                      : IN STD_LOGIC;
      rmaster_up_tx                   : IN STD_LOGIC;
      rself_sw_en_tx                  : IN STD_LOGIC;
      rpipeline_bypass_tx             : IN STD_LOGIC;
      rphfifo_regmode_tx              : IN STD_LOGIC;
      
      -- new outputs for bundling and auto speed
      
      -- new signals in this module for bundling and auto speed
      
      --CRAM for TX bitslip 
      rtxbitslip_en                   : IN STD_LOGIC;
      tx_div2_sync_out_pipe_up        : OUT STD_LOGIC;
      fifo_select_out_pipe_up         : OUT STD_LOGIC;
      wr_enable_out_pipe_up           : OUT STD_LOGIC;
      rd_enable_out_pipe_up           : OUT STD_LOGIC;
      tx_div2_sync_out_pipe_down      : OUT STD_LOGIC;
      fifo_select_out_pipe_down       : OUT STD_LOGIC;
      wr_enable_out_pipe_down         : OUT STD_LOGIC;
      rd_enable_out_pipe_down         : OUT STD_LOGIC;
      prbs_cid_en                     : IN STD_LOGIC;
      tx_boundary_sel                 : IN STD_LOGIC_VECTOR(4 DOWNTO 0)
   );
END cycloneiv_hssi_tx_digi;

ARCHITECTURE trans OF cycloneiv_hssi_tx_digi IS
   COMPONENT cycloneiv_hssi_tx_digi_prbs_gen
      PORT (
         tx_clk                          : IN STD_LOGIC;
         soft_reset                      : IN STD_LOGIC;
         rprbs_en_tx                     : IN STD_LOGIC;
         rpmadwidth_tx                   : IN STD_LOGIC;
         rpma_doublewidth_tx             : IN STD_LOGIC;
         rprbs_sel                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         cid_en                          : IN STD_LOGIC;
         rcid_len                        : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         rcid_pattern                    : IN STD_LOGIC;
         prbs_out                        : OUT STD_LOGIC_VECTOR(19 DOWNTO 0)
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_tx_digi_txclk_ctl
      PORT (
         pld_tx_clk                      : IN STD_LOGIC;
         refclk_pma                      : IN STD_LOGIC;
         txpma_local_clk                 : IN STD_LOGIC;
         txrst                           : IN STD_LOGIC;
         scan_mode                       : IN STD_LOGIC;
         gen2ngen1                       : IN STD_LOGIC;
         gen2ngen1_bundle                : IN STD_LOGIC;
         tx_div2_sync_centrl             : IN STD_LOGIC;
         tx_div2_sync_quad_up            : IN STD_LOGIC;
         tx_div2_sync_quad_down          : IN STD_LOGIC;
         rindv_tx                        : IN STD_LOGIC;
         rtxwrclksel                     : IN STD_LOGIC;
         rtxrdclksel                     : IN STD_LOGIC;
         rdwidth_tx                      : IN STD_LOGIC;
         rfreerun_tx                     : IN STD_LOGIC;
         rauto_speed_ena                 : IN STD_LOGIC;
         rfreq_sel                       : IN STD_LOGIC;
         rtxpcsclkpwdn                   : IN STD_LOGIC;
         rmaster_tx                      : IN STD_LOGIC;
         rmaster_up_tx                   : IN STD_LOGIC;
         rself_sw_en_tx                  : IN STD_LOGIC;
         refclk_b                        : OUT STD_LOGIC;
         wr_clk_pos                      : OUT STD_LOGIC;
         fifo_rd_clk                     : OUT STD_LOGIC;
         tx_clk_out                      : OUT STD_LOGIC;
         refclk_b_raw                    : OUT STD_LOGIC;
         wr_clk_pos_raw                  : OUT STD_LOGIC;
         fifo_rd_clk_raw                 : OUT STD_LOGIC;
         tx_div2_sync_out                : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_tx_digi_enc_chnl_top
      PORT (
         rst                             : IN STD_LOGIC;
         clk                             : IN STD_LOGIC;
         cascaded_8b10b_en               : IN STD_LOGIC;
         rendec_data_sel_tx              : IN STD_LOGIC;
         rrev_loopbk                     : IN STD_LOGIC;
         rev_loopbk                      : IN STD_LOGIC;
         dwidth                          : IN STD_LOGIC;
         doublewidth                     : IN STD_LOGIC;
         endec                           : IN STD_LOGIC;
         ge_xaui_sel                     : IN STD_LOGIC;
         rforce_disp                     : IN STD_LOGIC;
         ib_force_disparity              : IN STD_LOGIC;
         prbs_en                         : IN STD_LOGIC;
         r8b10b_enc_ibm_en               : IN STD_LOGIC;
         rev_loop_data                   : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
         tx_ctl_ts                       : IN STD_LOGIC;
         tx_ctl_tc                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         tx_data_ts                      : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         txd_extend_tc                   : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         tx_data_tc                      : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
         tx_data_9_tc                    : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         tx_data_pg                      : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
         k_det                           : IN STD_LOGIC;
         d21_5_eq_n                      : IN STD_LOGIC;
         d2_2_eq_n                       : IN STD_LOGIC;
         renpolinv_tx                    : IN STD_LOGIC;
         enpolinv_tx                     : IN STD_LOGIC;
         renbitrev_tx                    : IN STD_LOGIC;
         rensymswap_tx                   : IN STD_LOGIC;
         rtxbitslip_en                   : IN STD_LOGIC;
         tx_boundary_sel                 : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
         pudr                            : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);
         txlp20b                         : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);
         tx_data_pre_en                  : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
         tx_data_9_pre_en                : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         tx_ctl_pre_en                   : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         disp_out_3b                     : OUT STD_LOGIC_VECTOR(1 DOWNTO 0)
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_tx_digi_iq_pipe_tx
      PORT (
         refclk_b_raw                    : IN STD_LOGIC;
         wr_clk_pos_raw                  : IN STD_LOGIC;
         fifo_rd_clk_raw                 : IN STD_LOGIC;
         txrst                           : IN STD_LOGIC;
         soft_reset_rclk1                : IN STD_LOGIC;
         soft_reset_wclk1                : IN STD_LOGIC;
         tx_div2_sync_in_centrl          : IN STD_LOGIC;
         tx_div2_sync_in_pipe_quad_up    : IN STD_LOGIC;
         tx_div2_sync_in_pipe_quad_down  : IN STD_LOGIC;
         wr_enable_in_centrl             : IN STD_LOGIC;
         wr_enable_in_pipe_quad_up       : IN STD_LOGIC;
         wr_enable_in_pipe_quad_down     : IN STD_LOGIC;
         rd_enable_in_centrl             : IN STD_LOGIC;
         rd_enable_in_pipe_quad_up       : IN STD_LOGIC;
         rd_enable_in_pipe_quad_down     : IN STD_LOGIC;
         fifo_select_in_centrl           : IN STD_LOGIC;
         fifo_select_in_pipe_quad_up     : IN STD_LOGIC;
         fifo_select_in_pipe_quad_down   : IN STD_LOGIC;
         rmaster_tx                      : IN STD_LOGIC;
         rmaster_up_tx                   : IN STD_LOGIC;
         rpipeline_bypass_tx             : IN STD_LOGIC;
         rfreerun_tx                     : IN STD_LOGIC;
         tx_div2_sync_out_pipe           : OUT STD_LOGIC;
         fifo_select_out_pipe            : OUT STD_LOGIC;
         wr_enable_out_pipe              : OUT STD_LOGIC;
         rd_enable_out_pipe              : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_tx_digi_bist_gen
      PORT (
         tx_clk                          : IN STD_LOGIC;
         soft_reset                      : IN STD_LOGIC;
         rbisten_tx                      : IN STD_LOGIC;
         rpmadwidth_tx                   : IN STD_LOGIC;
         rpma_doublewidth_tx             : IN STD_LOGIC;
         rdwidth_tx                      : IN STD_LOGIC;
         rbist_sel                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rcxpat_chnl_sel                 : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         bist_data_sg                    : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
         bist_ctl_sg                     : OUT STD_LOGIC_VECTOR(1 DOWNTO 0)
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_tx_digi_tx_ctrl
      PORT (
         soft_reset                      : IN STD_LOGIC;
         fifo_wr_clk                     : IN STD_LOGIC;
         fifo_rd_clk                     : IN STD_LOGIC;
         refclk_b_in                     : IN STD_LOGIC;
         scan_mode                       : IN STD_LOGIC;
         rindv_tx                        : IN STD_LOGIC;
         p_rlpbk                         : IN STD_LOGIC;
         selftest_en                     : IN STD_LOGIC;
         rdwidth_tx                      : IN STD_LOGIC;
         txfifo_dis                      : IN STD_LOGIC;
         rtxfifo_urst_en                 : IN STD_LOGIC;
         txfifo_urst                     : IN STD_LOGIC;
         rtxfifo_lowlatency_en           : IN STD_LOGIC;
         rtxphfifopldctl_en              : IN STD_LOGIC;
         rtx_pipe_enable                 : IN STD_LOGIC;
         pld_we                          : IN STD_LOGIC;
         pld_rd_dis                      : IN STD_LOGIC;
         txd                             : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
         txd_extend                      : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rforce_disp                     : IN STD_LOGIC;
         tx_data_sg                      : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
         tx_control_sg                   : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rxd_lpbk                        : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
         redund_ctl                      : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         txd_redun                       : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
         rforce_kchar                    : IN STD_LOGIC;
         rforce_echar                    : IN STD_LOGIC;
         rtxpcsbypass_en                 : IN STD_LOGIC;
         txdetectrxloopback              : IN STD_LOGIC;
         powerdown                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         revloopback                     : IN STD_LOGIC;
         txswing                         : IN STD_LOGIC;
         txdeemph                        : IN STD_LOGIC;
         txmargin                        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rxpolarity                      : IN STD_LOGIC;
         polinv_rx                       : IN STD_LOGIC;
         eidleinfersel                   : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         reset_pc_ptrs                   : IN STD_LOGIC;
         reset_pc_ptrs_centrl            : IN STD_LOGIC;
         reset_pc_ptrs_quad_up           : IN STD_LOGIC;
         reset_pc_ptrs_quad_down         : IN STD_LOGIC;
         gen2ngen1                       : IN STD_LOGIC;
         gen2ngen1_bundle                : IN STD_LOGIC;
         dis_pc_byte                     : IN STD_LOGIC;
         wr_enable_centrl                : IN STD_LOGIC;
         wr_enable_quad_up               : IN STD_LOGIC;
         wr_enable_quad_down             : IN STD_LOGIC;
         rd_enable_centrl                : IN STD_LOGIC;
         rd_enable_quad_up               : IN STD_LOGIC;
         rd_enable_quad_down             : IN STD_LOGIC;
         fifo_select_in_centrl           : IN STD_LOGIC;
         fifo_select_in_quad_up          : IN STD_LOGIC;
         fifo_select_in_quad_down        : IN STD_LOGIC;
         rauto_speed_ena                 : IN STD_LOGIC;
         rfreq_sel                       : IN STD_LOGIC;
         rphfifo_regmode_tx              : IN STD_LOGIC;
         rmaster_tx                      : IN STD_LOGIC;
         rmaster_up_tx                   : IN STD_LOGIC;
         txd_extend_tc                   : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         tx_data_tc                      : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
         tx_ctl_tc                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         tx_data_9_tc                    : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         rd_enable_sync                  : OUT STD_LOGIC;
         k_det                           : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         d21_5_eq_n                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         d2_2_eq_n                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         wr_enable_out                   : OUT STD_LOGIC;
         rd_enable_out                   : OUT STD_LOGIC;
         fifo_select_out                 : OUT STD_LOGIC;
         ph_fifo_full                    : OUT STD_LOGIC;
         ph_fifo_empty                   : OUT STD_LOGIC;
         soft_reset_wclk1                : OUT STD_LOGIC;
         soft_reset_rclk1                : OUT STD_LOGIC;
         pipe_electric_idle              : OUT STD_LOGIC;
         txdetectrxloopback_int          : OUT STD_LOGIC;
         powerdown_int                   : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         revloopback_int                 : OUT STD_LOGIC;
         phfifo_txswing                  : OUT STD_LOGIC;
         phfifo_txdeemph                 : OUT STD_LOGIC;
         phfifo_txmargin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rxpolarity_int                  : OUT STD_LOGIC;
         polinv_rx_int                   : OUT STD_LOGIC;
         gray_eidleinfersel              : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         wr_enable2                      : OUT STD_LOGIC;
         wptr_bin                        : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rd_enable2                      : OUT STD_LOGIC;
         rptr_bin                        : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
      );
   END COMPONENT;
   
   SIGNAL refclk_b_raw                      : STD_LOGIC;
   SIGNAL wr_clk_pos_raw                    : STD_LOGIC;
   SIGNAL fifo_rd_clk_raw                   : STD_LOGIC;
   SIGNAL nc_new_bundle1                    : STD_LOGIC;
   SIGNAL nc_new_bundle2                    : STD_LOGIC;
   SIGNAL nc_new_bundle3                    : STD_LOGIC;
   SIGNAL fifo_select_out_testbus           : STD_LOGIC;
   -- removed
   -- txfifo_shared_sig_in_ch0
   -- txfifo_shared_sig_in_q0_ch0
   -- rphfifo_master_sel_tx
   -- txfifo_shared_sig_out
   
   -- Wiring section
   SIGNAL wr_clk_pos                        : STD_LOGIC;
   SIGNAL fifo_rd_clk                       : STD_LOGIC;
   SIGNAL soft_reset_wclk1                  : STD_LOGIC;
   SIGNAL tx_data_tc_high                   : STD_LOGIC_VECTOR(7 DOWNTO 0);		-- high 8-bit tx data from tx_ctrl
   -- low 8-bit tx data from tx_ctrl
   SIGNAL tx_ctl_tc_high                    : STD_LOGIC;		-- high tx control/tx data bit 8 from tx_ctrl
   -- low tx control/tx data bit 8 from tx_ctrl
   SIGNAL tx_ctl_pre_en                     : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_data_pre_en                    : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL tx_data_9_pre_en                  : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_data_sg                        : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- 16-bit data sequence generated by bist_gen.
   SIGNAL tx_control_sg                     : STD_LOGIC_VECTOR(1 DOWNTO 0);		-- 2-bit control sequence generated by selftest_gen.
   SIGNAL tx_data_9_tc                      : STD_LOGIC_VECTOR(1 DOWNTO 0);		-- tx data bit 9 from tx_ctrl
   SIGNAL tx_data_pg                        : STD_LOGIC_VECTOR(19 DOWNTO 0);		-- 20-bit tx code group generated by prbs_gen
   SIGNAL soft_reset_int                    : STD_LOGIC;
   SIGNAL k_det                             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL d21_5_eq_n                        : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL d2_2_eq_n                         : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL txd_extend_tc                     : STD_LOGIC_VECTOR(1 DOWNTO 0);		-- Extend txd by 2 bits. Used to force disparity. This will go to the encoder. 
   -- THis is input from the PLD Fabric
   SIGNAL disp_out_3b                       : STD_LOGIC_VECTOR(1 DOWNTO 0);		-- Disparity output from encoder for testbus
   SIGNAL wr_enable2                        : STD_LOGIC;
   SIGNAL wptr_bin                          : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rd_enable2                        : STD_LOGIC;
   SIGNAL rptr_bin                          : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   SIGNAL tx_data_tc_temp                   : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL tx_ctl_tc_temp                    : STD_LOGIC_VECTOR(1 DOWNTO 0);
   -- X-HDL generated signals

   SIGNAL xhdl28 : STD_LOGIC_VECTOR(39 DOWNTO 0);
   SIGNAL xhdl29 : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xhdl30 : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL xhdl31 : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xhdl32 : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL xhdl33 : STD_LOGIC_VECTOR(15 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL full_tx_xhdl3                     : STD_LOGIC;
   SIGNAL empty_tx_xhdl0                    : STD_LOGIC;
   SIGNAL tx_clk_out_xhdl17                 : STD_LOGIC;
   SIGNAL tx_data_tc_xhdl19                 : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL tx_ctl_tc_xhdl18                  : STD_LOGIC;
   SIGNAL pudr_xhdl10                       : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL rd_enable_sync_xhdl13             : STD_LOGIC;
   SIGNAL refclk_b_xhdl14                   : STD_LOGIC;
   SIGNAL txlp20b_xhdl25                    : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL tx_pipe_soft_reset_xhdl23         : STD_LOGIC;
   SIGNAL tx_pipe_electidle_xhdl22          : STD_LOGIC;
   SIGNAL txdetectrxloopback_int_xhdl24     : STD_LOGIC;
   SIGNAL powerdown_int_xhdl9               : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL revloopback_int_xhdl15            : STD_LOGIC;
   SIGNAL phfifo_txswing_xhdl7              : STD_LOGIC;
   SIGNAL phfifo_txdeemph_xhdl5             : STD_LOGIC;
   SIGNAL phfifo_txmargin_xhdl6             : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rxpolarity_int_xhdl16             : STD_LOGIC;
   SIGNAL polinv_rx_int_xhdl8               : STD_LOGIC;
   SIGNAL gray_eidleinfersel_xhdl4          : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL tx_div2_sync_out_pipe_up_xhdl21   : STD_LOGIC;
   SIGNAL fifo_select_out_pipe_up_xhdl2     : STD_LOGIC;
   SIGNAL wr_enable_out_pipe_up_xhdl27      : STD_LOGIC;
   SIGNAL rd_enable_out_pipe_up_xhdl12      : STD_LOGIC;
   SIGNAL tx_div2_sync_out_pipe_down_xhdl20 : STD_LOGIC;
   SIGNAL fifo_select_out_pipe_down_xhdl1   : STD_LOGIC;
   SIGNAL wr_enable_out_pipe_down_xhdl26    : STD_LOGIC;
   SIGNAL rd_enable_out_pipe_down_xhdl11    : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   full_tx <= full_tx_xhdl3;
   empty_tx <= empty_tx_xhdl0;
   tx_clk_out <= tx_clk_out_xhdl17;
   tx_data_tc <= tx_data_tc_xhdl19;
   tx_ctl_tc <= tx_ctl_tc_xhdl18;
   pudr <= pudr_xhdl10;
   rd_enable_sync <= rd_enable_sync_xhdl13;
   refclk_b <= refclk_b_xhdl14;
   txlp20b <= txlp20b_xhdl25;
   tx_pipe_soft_reset <= tx_pipe_soft_reset_xhdl23;
   tx_pipe_electidle <= tx_pipe_electidle_xhdl22;
   txdetectrxloopback_int <= txdetectrxloopback_int_xhdl24;
   powerdown_int <= powerdown_int_xhdl9;
   revloopback_int <= revloopback_int_xhdl15;
   phfifo_txswing <= phfifo_txswing_xhdl7;
   phfifo_txdeemph <= phfifo_txdeemph_xhdl5;
   phfifo_txmargin <= phfifo_txmargin_xhdl6;
   rxpolarity_int <= rxpolarity_int_xhdl16;
   polinv_rx_int <= polinv_rx_int_xhdl8;
   gray_eidleinfersel <= gray_eidleinfersel_xhdl4;
   tx_div2_sync_out_pipe_up <= tx_div2_sync_out_pipe_up_xhdl21;
   fifo_select_out_pipe_up <= fifo_select_out_pipe_up_xhdl2;
   wr_enable_out_pipe_up <= wr_enable_out_pipe_up_xhdl27;
   rd_enable_out_pipe_up <= rd_enable_out_pipe_up_xhdl12;
   tx_div2_sync_out_pipe_down <= tx_div2_sync_out_pipe_down_xhdl20;
   fifo_select_out_pipe_down <= fifo_select_out_pipe_down_xhdl1;
   wr_enable_out_pipe_down <= wr_enable_out_pipe_down_xhdl26;
   rd_enable_out_pipe_down <= rd_enable_out_pipe_down_xhdl11;
   
   -- Gated soft reset by scan_mode signal
   --assign soft_reset_int = (scan_mode) ? 1'b0 : txpcs_rst;
   soft_reset_int <= txpcs_rst;
   
   -- TX PIPE interface clock
   --assign tx_pipe_clk = wr_clk_pos;
   tx_pipe_clk <= fifo_rd_clk;
   
   -- Encoder testbus
   encoder_testbus <= (disp_out_3b & pudr_xhdl10(7 DOWNTO 0));
   
   -- TX FIFO testbus
   tx_ctrl_testbus <= ('0' & fifo_select_out_testbus & wr_enable2 & wptr_bin & rd_enable2 & rptr_bin);
   
   -- Clock selection module
   
   
   txclk_ctl_1 : cycloneiv_hssi_tx_digi_txclk_ctl
      PORT MAP (
         pld_tx_clk              => pld_tx_clk,
         refclk_pma              => refclk_pma,
         txpma_local_clk         => txpma_local_clk,
         txrst                   => txpcs_rst,
         scan_mode               => scan_mode,
         gen2ngen1               => gen2ngen1,
         gen2ngen1_bundle        => gen2ngen1_bundle,
         tx_div2_sync_centrl     => tx_div2_sync_in_centrl,
         tx_div2_sync_quad_up    => tx_div2_sync_in_quad_up,
         tx_div2_sync_quad_down  => tx_div2_sync_in_quad_down,
         rindv_tx                => rindv_tx,
         rtxwrclksel             => rtxwrclksel,
         rtxrdclksel             => rtxrdclksel,
         rdwidth_tx              => rdwidth_tx,
         rfreerun_tx             => rfreerun_tx,
         rauto_speed_ena         => rauto_speed_ena,
         rfreq_sel               => rfreq_sel,
         rtxpcsclkpwdn           => rtxpcsclkpwdn,
         rmaster_tx              => rmaster_tx,
         rmaster_up_tx           => rmaster_up_tx,
         rself_sw_en_tx          => rself_sw_en_tx,
         refclk_b                => refclk_b_xhdl14,
         wr_clk_pos              => wr_clk_pos,
         fifo_rd_clk             => fifo_rd_clk,
         tx_clk_out              => tx_clk_out_xhdl17,
         refclk_b_raw            => refclk_b_raw,
         wr_clk_pos_raw          => wr_clk_pos_raw,
         fifo_rd_clk_raw         => fifo_rd_clk_raw,
         tx_div2_sync_out        => nc_new_bundle1
      );
   
   -- TX Phase compensation FIFO module
   
   
   -- S. Park 11/29/07 - Phase FIFO bypass feature removed
   -- .txfifo_dis (rtxfifo_dis),
   xhdl28 <= (txd(42 DOWNTO 33) & txd(31 DOWNTO 22) & txd(20 DOWNTO 11) & txd(9 DOWNTO 0));
   xhdl29 <= (txd(43) & txd(32) & txd(21) & txd(10));
   xhdl30 <= ("0000000000000000" & tx_data_sg);
   xhdl31 <= ("00" & tx_control_sg);
   tx_ctrl_1 : cycloneiv_hssi_tx_digi_tx_ctrl
      PORT MAP (
         soft_reset                => soft_reset_int,
         fifo_wr_clk               => wr_clk_pos,
         fifo_rd_clk               => fifo_rd_clk,
         refclk_b_in               => refclk_b_xhdl14,
         scan_mode                 => scan_mode,
         rindv_tx                  => rindv_tx,
         p_rlpbk                   => '0',
         selftest_en               => rbisten_tx,
         rdwidth_tx                => rdwidth_tx,
         txfifo_dis                => '0',
         rtxfifo_urst_en           => rphfifoursttx,
         txfifo_urst               => phfifourst_tx,
         rtxfifo_lowlatency_en     => rtxfifo_lowlatency_en,
         rtxphfifopldctl_en        => rphfifopldentx,
         rtx_pipe_enable           => rtx_pipe_enable,
         pld_we                    => wrenable_tx,
         pld_rd_dis                => rddisable_tx,
         txd                       => xhdl28,
         txd_extend                => xhdl29,
         rforce_disp               => rforce_disp,
         tx_data_sg                => xhdl30,
         tx_control_sg             => xhdl31,
         rxd_lpbk                  => "0000000000000000000000000000000000000000",
         redund_ctl                => "0000",
         txd_redun                 => "0000000000000000000000000000000000000000",
         rforce_kchar              => rforce_kchar,
         rforce_echar              => rforce_echar,
         rtxpcsbypass_en           => rtxpcsbypass_en,
         -- TX PIPE signals
         txdetectrxloopback        => txdetectrxloopback,
         powerdown                 => powerdown,
         revloopback               => revloopback,
         txswing                   => txswing,
         txdeemph                  => pcs_txdeemph,
         txmargin                  => pcs_txmargin,
         -- RX PIPE signals
         rxpolarity                => rxpolarity,
         polinv_rx                 => polinv_rx,
         eidleinfersel             => eidleinfersel,
         reset_pc_ptrs             => reset_pc_ptrs,
         reset_pc_ptrs_centrl      => reset_pc_ptrs_in_centrl,
         reset_pc_ptrs_quad_up     => reset_pc_ptrs_in_quad_up,
         reset_pc_ptrs_quad_down   => reset_pc_ptrs_in_quad_down,
         gen2ngen1                 => gen2ngen1,
         gen2ngen1_bundle          => gen2ngen1_bundle,
         dis_pc_byte               => dis_pc_byte,
         wr_enable_centrl          => wr_enable_in_centrl,
         wr_enable_quad_up         => wr_enable_in_quad_up,
         wr_enable_quad_down       => wr_enable_in_quad_down,
         rd_enable_centrl          => rd_enable_in_centrl,
         rd_enable_quad_up         => rd_enable_in_quad_up,
         rd_enable_quad_down       => rd_enable_in_quad_down,
         fifo_select_in_centrl     => fifo_select_in_centrl,
         fifo_select_in_quad_up    => fifo_select_in_quad_up,
         fifo_select_in_quad_down  => fifo_select_in_quad_down,
         rauto_speed_ena           => rauto_speed_ena,
         rfreq_sel                 => rfreq_sel,
         rphfifo_regmode_tx        => rphfifo_regmode_tx,
         rmaster_tx                => rmaster_tx,
         rmaster_up_tx             => rmaster_up_tx,
         txd_extend_tc             => txd_extend_tc,
         tx_data_tc                => tx_data_tc_temp,
         tx_ctl_tc                 => tx_ctl_tc_temp,
         tx_data_9_tc              => tx_data_9_tc,
         rd_enable_sync            => rd_enable_sync_xhdl13,
         k_det                     => k_det,
         d21_5_eq_n                => d21_5_eq_n,
         d2_2_eq_n                 => d2_2_eq_n,
         wr_enable_out             => nc_new_bundle2,
         rd_enable_out             => nc_new_bundle3,
         fifo_select_out           => fifo_select_out_testbus,
         ph_fifo_full              => full_tx_xhdl3,
         ph_fifo_empty             => empty_tx_xhdl0,
         soft_reset_wclk1          => soft_reset_wclk1,
         soft_reset_rclk1          => tx_pipe_soft_reset_xhdl23,
         pipe_electric_idle        => tx_pipe_electidle_xhdl22,
         -- TX PIPE signals
         txdetectrxloopback_int    => txdetectrxloopback_int_xhdl24,
         powerdown_int             => powerdown_int_xhdl9,
         revloopback_int           => revloopback_int_xhdl15,
         gray_eidleinfersel        => gray_eidleinfersel_xhdl4,
         
         phfifo_txswing            => phfifo_txswing_xhdl7,
         phfifo_txdeemph           => phfifo_txdeemph_xhdl5,
         phfifo_txmargin           => phfifo_txmargin_xhdl6,
         
         -- RX PIPE signals
         rxpolarity_int            => rxpolarity_int_xhdl16,
         polinv_rx_int             => polinv_rx_int_xhdl8,
         wr_enable2                => wr_enable2,
         wptr_bin                  => wptr_bin,
         rd_enable2                => rd_enable2,
         rptr_bin                  => rptr_bin
      );
   tx_data_tc_high <= tx_data_tc_temp(15 DOWNTO 8);
   tx_data_tc_xhdl19 <= tx_data_tc_temp(7 DOWNTO 0);
   tx_ctl_tc_high <= tx_ctl_tc_temp(1);
   tx_ctl_tc_xhdl18 <= tx_ctl_tc_temp(0);
   -- BIST generator module
   
   
   selftest_gen_1 : cycloneiv_hssi_tx_digi_bist_gen
      PORT MAP (
         tx_clk               => wr_clk_pos,
         soft_reset           => soft_reset_wclk1,
         rbisten_tx           => rbisten_tx,
         rpmadwidth_tx        => rpmadwidth_tx,
         rpma_doublewidth_tx  => rpma_doublewidth_tx,
         rdwidth_tx           => rdwidth_tx,
         rbist_sel            => rbist_sel,
         rcxpat_chnl_sel      => rcxpat_chnl_en,
         bist_data_sg         => tx_data_sg,
         bist_ctl_sg          => tx_control_sg
      );
   
   -- PRBS generator module
   
   
   prbs_gen_1 : cycloneiv_hssi_tx_digi_prbs_gen
      PORT MAP (
         tx_clk               => refclk_b_xhdl14,
         soft_reset           => soft_reset_int,
         rprbs_en_tx          => rprbsen_tx,
         rpmadwidth_tx        => rpmadwidth_tx,
         rpma_doublewidth_tx  => rpma_doublewidth_tx,
         cid_en               => prbs_cid_en,
         rcid_len             => rcid_len_tx,
         rcid_pattern         => rcid_pattern_tx,
         rprbs_sel            => rprbs_sel,
         prbs_out             => tx_data_pg
      );
   
   -- 8B-10B Encoder module
   
   
   xhdl32 <= (tx_ctl_tc_high & tx_ctl_tc_xhdl18);
   xhdl33 <= (tx_data_tc_high & tx_data_tc_xhdl19);
   enc_chnl_top_1 : cycloneiv_hssi_tx_digi_enc_chnl_top
      PORT MAP (
         rst                 => soft_reset_int,
         clk                 => refclk_b_xhdl14,
         cascaded_8b10b_en   => rcascaded_8b10b_en_tx,
         rendec_data_sel_tx  => rendec_data_sel_tx,
         rrev_loopbk         => rrev_loopbk,
         rev_loopbk          => rev_loopbk,
         dwidth              => rpmadwidth_tx,
         doublewidth         => rpma_doublewidth_tx,
         endec               => rendec_tx,
         ge_xaui_sel         => rge_xaui_tx,
         rforce_disp         => rforce_disp,
         ib_force_disparity  => rib_force_disp,
         prbs_en             => rprbsen_tx,
         r8b10b_enc_ibm_en   => r8b10b_enc_ibm_en,
         rev_loop_data       => rev_loop_data,
         tx_ctl_ts           => tx_ctl_ts,
         tx_ctl_tc           => xhdl32,
         tx_data_ts          => tx_data_ts,
         txd_extend_tc       => txd_extend_tc,
         tx_data_tc          => xhdl33,
         tx_data_9_tc        => tx_data_9_tc,
         tx_data_pg          => tx_data_pg,
         k_det               => k_det(0),
         d21_5_eq_n          => d21_5_eq_n(0),
         d2_2_eq_n           => d2_2_eq_n(0),
         renpolinv_tx        => renpolinv_tx,
         enpolinv_tx         => polinv_tx,
         renbitrev_tx        => renbitrev_tx,
         rensymswap_tx       => rensymswap_tx,
         rtxbitslip_en       => rtxbitslip_en,
         tx_boundary_sel     => tx_boundary_sel,
         pudr                => pudr_xhdl10,
         txlp20b             => txlp20b_xhdl25,
         tx_data_pre_en      => tx_data_pre_en,
         tx_data_9_pre_en    => tx_data_9_pre_en,
         tx_ctl_pre_en       => tx_ctl_pre_en,
         disp_out_3b         => disp_out_3b
      );
   
   
   
   iqp_out_up : cycloneiv_hssi_tx_digi_iq_pipe_tx
      PORT MAP (
         refclk_b_raw                    => refclk_b_raw,
         wr_clk_pos_raw                  => wr_clk_pos_raw,
         fifo_rd_clk_raw                 => fifo_rd_clk_raw,
         txrst                           => txpcs_rst,
         soft_reset_rclk1                => tx_pipe_soft_reset_xhdl23,
         soft_reset_wclk1                => soft_reset_wclk1,
         tx_div2_sync_in_centrl          => tx_div2_sync_in_centrl,
         tx_div2_sync_in_pipe_quad_up    => '0',
         tx_div2_sync_in_pipe_quad_down  => tx_div2_sync_in_pipe_quad_down,
         wr_enable_in_centrl             => wr_enable_in_centrl,
         wr_enable_in_pipe_quad_up       => '0',
         wr_enable_in_pipe_quad_down     => wr_enable_in_pipe_quad_down,
         rd_enable_in_centrl             => rd_enable_in_centrl,
         rd_enable_in_pipe_quad_up       => '0',
         rd_enable_in_pipe_quad_down     => rd_enable_in_pipe_quad_down,
         fifo_select_in_centrl           => fifo_select_in_centrl,
         fifo_select_in_pipe_quad_up     => '0',
         fifo_select_in_pipe_quad_down   => fifo_select_in_pipe_quad_down,
         rmaster_tx                      => rmaster_tx,
         rmaster_up_tx                   => rmaster_up_tx,
         rpipeline_bypass_tx             => rpipeline_bypass_tx,
         rfreerun_tx                     => rfreerun_tx,
         tx_div2_sync_out_pipe           => tx_div2_sync_out_pipe_up_xhdl21,
         fifo_select_out_pipe            => fifo_select_out_pipe_up_xhdl2,
         wr_enable_out_pipe              => wr_enable_out_pipe_up_xhdl27,
         rd_enable_out_pipe              => rd_enable_out_pipe_up_xhdl12
      );
   
   
   
   iqp_out_down : cycloneiv_hssi_tx_digi_iq_pipe_tx
      PORT MAP (
         refclk_b_raw                    => refclk_b_raw,
         wr_clk_pos_raw                  => wr_clk_pos_raw,
         fifo_rd_clk_raw                 => fifo_rd_clk_raw,
         txrst                           => txpcs_rst,
         soft_reset_rclk1                => tx_pipe_soft_reset_xhdl23,
         soft_reset_wclk1                => soft_reset_wclk1,
         tx_div2_sync_in_centrl          => tx_div2_sync_in_centrl,
         tx_div2_sync_in_pipe_quad_up    => tx_div2_sync_in_pipe_quad_up,
         tx_div2_sync_in_pipe_quad_down  => '0',
         wr_enable_in_centrl             => wr_enable_in_centrl,
         wr_enable_in_pipe_quad_up       => wr_enable_in_pipe_quad_up,
         wr_enable_in_pipe_quad_down     => '0',
         rd_enable_in_centrl             => rd_enable_in_centrl,
         rd_enable_in_pipe_quad_up       => rd_enable_in_pipe_quad_up,
         rd_enable_in_pipe_quad_down     => '0',
         fifo_select_in_centrl           => fifo_select_in_centrl,
         fifo_select_in_pipe_quad_up     => fifo_select_in_pipe_quad_up,
         fifo_select_in_pipe_quad_down   => '0',
         rmaster_tx                      => rmaster_tx,
         rmaster_up_tx                   => rmaster_up_tx,
         rpipeline_bypass_tx             => rpipeline_bypass_tx,
         rfreerun_tx                     => rfreerun_tx,
         tx_div2_sync_out_pipe           => tx_div2_sync_out_pipe_down_xhdl20,
         fifo_select_out_pipe            => fifo_select_out_pipe_down_xhdl1,
         wr_enable_out_pipe              => wr_enable_out_pipe_down_xhdl26,
         rd_enable_out_pipe              => rd_enable_out_pipe_down_xhdl11
      );
   
END trans;




-- digi_tx--///////////////////////////////////////////////////////////////////////////////
-- hssi_module: transmitter ***************************************************//
--///////////////////////////////////////////////////////////////////////////////

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
ENTITY cycloneiv_hssi_tx_pcs IS
   GENERIC (

          --  generic control parameters  --
       -- VITAL
       MsgOn                   : Boolean := DefGlitchMsgOn;
       XOn                     : Boolean := DefGlitchXOn;
       MsgOnChecks             : Boolean := DefMsgOnChecks;
       XOnChecks               : Boolean := DefXOnChecks;
       InstancePath            : String := "*";
       TimingChecksOn          : Boolean := True;
       
          --  tipd  :interconnect path delays --
      tipd_bitslipboundaryselect               :VitalDelayArrayType01(4 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_coreclk                : VitalDelayType01 := DefpropDelay01;
      tipd_ctrlenable               :VitalDelayArrayType01(3 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_datain               :VitalDelayArrayType01(39 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_datainfull               :VitalDelayArrayType01(43 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_detectrxloop                : VitalDelayType01 := DefpropDelay01;
      tipd_digitalreset                : VitalDelayType01 := DefpropDelay01;
      tipd_dispval               :VitalDelayArrayType01(3 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_dpriodisable                : VitalDelayType01 := DefpropDelay01;
      tipd_dprioin               :VitalDelayArrayType01(149 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_enrevparallellpbk                : VitalDelayType01 := DefpropDelay01;
      tipd_forcedisp               :VitalDelayArrayType01(3 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_forcedispcompliance                : VitalDelayType01 := DefpropDelay01;
      tipd_forceelecidle                : VitalDelayType01 := DefpropDelay01;
      tipd_freezptr                : VitalDelayType01 := DefpropDelay01;
      tipd_hipdatain               :VitalDelayArrayType01(9 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_hipdetectrxloop                : VitalDelayType01 := DefpropDelay01;
      tipd_hipelecidleinfersel     :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_hipforceelecidle                : VitalDelayType01 := DefpropDelay01;
      tipd_hippowerdn               :VitalDelayArrayType01(1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_hiptxdeemph                : VitalDelayType01 := DefpropDelay01;
      tipd_hiptxmargin               :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_invpol                : VitalDelayType01 := DefpropDelay01;
      tipd_iqpphfifoxnwrenable               :VitalDelayArrayType01(1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_iqpphfifoxnrdenable               :VitalDelayArrayType01(1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_iqpphfifoxnbytesel               :VitalDelayArrayType01(1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_iqpphfifoxnrdclk               :VitalDelayArrayType01(1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_localrefclk                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifobyteserdisable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxnbytesel               :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_phfifoxnbottomwrenable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxntopwrenable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoptrsreset                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxnptrsreset               :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_phfifoxnrdenable               :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_phfiforddisable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfiforeset                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifowrenable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifox4bytesel                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifox4rdclk                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifox4rdenable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifox4wrenable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxntopbytesel                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxntoprdclk                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxnbottombytesel                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxntoprdenable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxnrdclk               :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_phfifoxnbottomrdenable                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxnbottomrdclk                : VitalDelayType01 := DefpropDelay01;
      tipd_phfifoxnwrenable               :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_pipestatetransdone                : VitalDelayType01 := DefpropDelay01;
      tipd_pipetxmargin               :VitalDelayArrayType01(2 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_pipetxdeemph                : VitalDelayType01 := DefpropDelay01;
      tipd_pipetxswing                : VitalDelayType01 := DefpropDelay01;
      tipd_powerdn               :VitalDelayArrayType01(1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_prbscidenable                : VitalDelayType01 := DefpropDelay01;
      tipd_quadreset                : VitalDelayType01 := DefpropDelay01;
      tipd_rateswitch                : VitalDelayType01 := DefpropDelay01;
      tipd_rateswitchisdone                : VitalDelayType01 := DefpropDelay01;
      tipd_rateswitchxndone                : VitalDelayType01 := DefpropDelay01;
      tipd_refclk                : VitalDelayType01 := DefpropDelay01;
      tipd_revparallelfdbk               :VitalDelayArrayType01(19 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_xgmctrl                : VitalDelayType01 := DefpropDelay01;
      tipd_xgmdatain               :VitalDelayArrayType01(7 DOWNTO 0)   := (OTHERS => DefPropDelay01);

      -- TSU-TH section
      tsetup_ctrlenable_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_datain_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_detectrxloop_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_dispval_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_forcedisp_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      --tsetup_forcedispcompliance_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_phfifowrenable_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_forceelecidle_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_powerdn_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      --tsetup_pipetxdeemph_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      tsetup_pipetxswing_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      --tsetup_pipetxmargin_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_ctrlenable_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_datain_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_detectrxloop_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_dispval_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_forcedisp_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      --thold_forcedispcompliance_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_phfifowrenable_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_forceelecidle_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_powerdn_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      --thold_pipetxdeemph_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      thold_pipetxswing_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;
      --thold_pipetxmargin_coreclk_noedge_posedge : VitalDelayType := DefSetupHoldCnst;

      -- TCO section
      tpd_coreclk_phfifooverflow_posedge : VitalDelayType01 := DefPropDelay01;
      tpd_coreclk_phfifounderflow_posedge : VitalDelayType01 := DefPropDelay01;

      lpm_type                                 : STRING := "cycloneiv_hssi_tx_pcs";
      allow_polarity_inversion                 : STRING := "false";
      --auto_spd_self_switch_enable              : STRING := "false";
      bitslip_enable                           : STRING := "false";
      channel_bonding                          : STRING := "none";	-- none, x8, x4
      channel_number                           : INTEGER := 0;
      channel_width                            : INTEGER := 8;
      core_clock_0ppm                          : STRING := "false";
      datapath_low_latency_mode                : STRING := "false";	--NEW_PARAM, RTL=
      datapath_protocol                        : STRING := "basic";	--replaced by protocol_hint
      disable_ph_low_latency_mode              : STRING := "false";
      disparity_mode                           : STRING := "none";	-- legacy, new, none
      dprio_config_mode                        : STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
      elec_idle_delay                          : INTEGER := 6;		-- new in 6.0 <3-6>
      enable_bit_reversal                      : STRING := "false";
      enable_idle_selection                    : STRING := "false";
      enable_phfifo_bypass                     : STRING := "false";
      enable_reverse_parallel_loopback         : STRING := "false";
      enable_self_test_mode                    : STRING := "false";
      --enable_symbol_swap                       : STRING := "false";
      enc_8b_10b_compatibility_mode            : STRING := "true";
      enc_8b_10b_mode                          : STRING := "none";	-- cascade, normal, none
      force_echar                              : STRING := "false";
      force_kchar                              : STRING := "false";
      hip_enable                               : STRING := "false";
      --iqp_bypass                               : STRING := "false";
      --iqp_ph_fifo_xn_select                    : INTEGER := 9999;
      logical_channel_address                  : INTEGER := 0;		
      migrated_from_prev_family                : STRING := "false";
      ph_fifo_reg_mode                         : STRING := "false";
      ph_fifo_reset_enable                     : STRING := "false";
      ph_fifo_user_ctrl_enable                 : STRING := "false";
      --ph_fifo_xn_mapping0                      : STRING := "none";
      --ph_fifo_xn_mapping1                      : STRING := "none";
      --ph_fifo_xn_mapping2                      : STRING := "none";
      --ph_fifo_xn_select                        : INTEGER := 9999;
      --pipe_auto_speed_nego_enable              : STRING := "false";	
      --pipe_freq_scale_mode                     : STRING := "Data width";		
      pipe_voltage_swing_control               : STRING := "false";	--NEW_PARAM, RTL=
      --prbs_all_one_detect                      : STRING := "false";
      prbs_cid_pattern                         : STRING := "false";
      prbs_cid_pattern_length                  : INTEGER := 0;
      protocol_hint                            : STRING := "basic";
      refclk_select                            : STRING := "local";	-- cmu_clk_divider
      reset_clock_output_during_digital_reset  : STRING := "false";
      self_test_mode                           : STRING := "incremental";
      use_double_data_mode                     : STRING := "false";
      --use_serializer_double_data_mode          : STRING := "false";
      wr_clk_mux_select                        : STRING := "core_clk"	-- INT_CLK                  // int_clk
   );
   PORT (
      bitslipboundaryselect                    : IN STD_LOGIC_VECTOR(4 DOWNTO 0) := (others => '0');		
      coreclk                                  : IN STD_LOGIC := '0';
      ctrlenable                               : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');
      datain                                   : IN STD_LOGIC_VECTOR(19 DOWNTO 0) := (others => '0');
      datainfull                               : IN STD_LOGIC_VECTOR(21 DOWNTO 0) := (others => '0');		-- WYS_TO_CHANGE
      detectrxloop                             : IN STD_LOGIC := '0';
      digitalreset                             : IN STD_LOGIC := '0';
      dispval                                  : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');
      dpriodisable                             : IN STD_LOGIC := '1';
      dprioin                                  : IN STD_LOGIC_VECTOR(149 DOWNTO 0) := (others => '0');
      elecidleinfersel                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');   
      enrevparallellpbk                        : IN STD_LOGIC := '0';
      forcedisp                                : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		--fix_width
      --forcedispcompliance                      : IN STD_LOGIC := '0';
      forceelecidle                            : IN STD_LOGIC := '0';		
      --freezptr                                 : IN STD_LOGIC := '0';
      hipdatain                                : IN STD_LOGIC_VECTOR(9 DOWNTO 0) := (others => '0');		
      hipdetectrxloop                          : IN STD_LOGIC := '0';		
      hipelecidleinfersel                      : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');		
      hipforceelecidle                         : IN STD_LOGIC := '0';		
      hippowerdn                               : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
      --hiptxdeemph                              : IN STD_LOGIC := '0';		
      --hiptxmargin                              : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');		
      invpol                                   : IN STD_LOGIC := '0';
      --iqpphfifoxnbytesel                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
      --iqpphfifoxnrdclk                         : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
      --iqpphfifoxnrdenable                      : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
      --iqpphfifoxnwrenable                      : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
      localrefclk                              : IN STD_LOGIC := '0';		
      --phfifobyteserdisable                     : IN STD_LOGIC := '0';		
      --phfifoptrsreset                          : IN STD_LOGIC := '0';		
      phfiforddisable                          : IN STD_LOGIC := '0';
      phfiforeset                              : IN STD_LOGIC := '0';
      phfifowrenable                           : IN STD_LOGIC := '1';
      phfifox4bytesel                          : IN STD_LOGIC := '0';
      phfifox4rdclk                            : IN STD_LOGIC := '0';
      phfifox4rdenable                         : IN STD_LOGIC := '0';
      phfifox4wrenable                         : IN STD_LOGIC := '0';
      --phfifoxnbottombytesel                    : IN STD_LOGIC := '0';		
      --phfifoxnbottomrdclk                      : IN STD_LOGIC := '0';		
      --phfifoxnbottomrdenable                   : IN STD_LOGIC := '0';		
      --phfifoxnbottomwrenable                   : IN STD_LOGIC := '0';		
      --phfifoxnbytesel                          : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
      --phfifoxnptrsreset                        : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
      --phfifoxnrdclk                            : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
      --phfifoxnrdenable                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
      --phfifoxntopbytesel                       : IN STD_LOGIC := '0';		
      --phfifoxntoprdclk                         : IN STD_LOGIC := '0';		
      --phfifoxntoprdenable                      : IN STD_LOGIC := '0';		
      --phfifoxntopwrenable                      : IN STD_LOGIC := '0';		
      --phfifoxnwrenable                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
      pipestatetransdone                       : IN STD_LOGIC := '0';
      --pipetxdeemph                             : IN STD_LOGIC := '0';		--NEW;  RTL=txdeemph;
      --pipetxmargin                             : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');		--NEW;  RTL=txmargin[2:0]
      pipetxswing                              : IN STD_LOGIC := '0';		--NEW;  RTL=txswing
      powerdn                                  : IN STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');
      prbscidenable                            : IN STD_LOGIC := '0';		
      quadreset                                : IN STD_LOGIC := '0';
      --rateswitch                               : IN STD_LOGIC := '0';		--NEW,  RTL=rate
      --rateswitchisdone                         : IN STD_LOGIC := '0';		
      --rateswitchxndone                         : IN STD_LOGIC := '0';		
      refclk                                   : IN STD_LOGIC := '0';
      revparallelfdbk                          : IN STD_LOGIC_VECTOR(19 DOWNTO 0) := (others => '0');
      xgmctrl                                  : IN STD_LOGIC := '0';
      xgmdatain                                : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := (others => '0');
      
      clkout                                   : OUT STD_LOGIC;
      coreclkout                               : OUT STD_LOGIC;		
      dataout                                  : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);
      dprioout                                 : OUT STD_LOGIC_VECTOR(149 DOWNTO 0);
      forceelecidleout                         : OUT STD_LOGIC;
      grayelecidleinferselout                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);  
      hiptxclkout                              : OUT STD_LOGIC;		
      --iqpphfifobyteselout                      : OUT STD_LOGIC;		
      --iqpphfifordclkout                        : OUT STD_LOGIC;		
      --iqpphfifordenableout                     : OUT STD_LOGIC;		
      --iqpphfifowrenableout                     : OUT STD_LOGIC;		
      parallelfdbkout                          : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);
      --phfifobyteselout                         : OUT STD_LOGIC;
      phfifooverflow                           : OUT STD_LOGIC;
      --phfifordclkout                           : OUT STD_LOGIC;
      phfiforddisableout                       : OUT STD_LOGIC;		
      --phfifordenableout                        : OUT STD_LOGIC;
      phfiforesetout                           : OUT STD_LOGIC;		
      phfifounderflow                          : OUT STD_LOGIC;
      phfifowrenableout                        : OUT STD_LOGIC;
      pipeenrevparallellpbkout                 : OUT STD_LOGIC;     
      pipepowerdownout                         : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      pipepowerstateout                        : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      --rateswitchout                            : OUT STD_LOGIC;
      rdenablesync                             : OUT STD_LOGIC;
      txdetectrx                               : OUT STD_LOGIC;		
      xgmctrlenable                            : OUT STD_LOGIC;
      xgmdataout                               : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)
   );
END cycloneiv_hssi_tx_pcs;

ARCHITECTURE trans OF cycloneiv_hssi_tx_pcs IS

-- --------------------------------------------------------------------------
-- parameters in TgX but not in cycloneiv ------------------------------------
--         --- make them local with fixed value so maximally reuse TgX code -
--             to not modifying internal codes                              -
--         --- total = 57 5/7/09                                            -
-- --------------------------------------------------------------------------
    CONSTANT auto_spd_self_switch_enable              : STRING := "false";
    CONSTANT enable_symbol_swap                       : STRING := "false";
    CONSTANT iqp_bypass                               : STRING := "false";
    CONSTANT iqp_ph_fifo_xn_select                    : INTEGER := 9999;
    CONSTANT ph_fifo_xn_mapping0                      : STRING := "none";
    CONSTANT ph_fifo_xn_mapping1                      : STRING := "none";
    CONSTANT ph_fifo_xn_mapping2                      : STRING := "none";
    CONSTANT ph_fifo_xn_select                        : INTEGER := 9999;
    CONSTANT pipe_auto_speed_nego_enable              : STRING := "false";	
    CONSTANT pipe_freq_scale_mode                     : STRING := "Data width";		
    CONSTANT prbs_all_one_detect                      : STRING := "false";
    CONSTANT use_serializer_double_data_mode          : STRING := "false";

-- --------------------------------------------------------------------------
-- Input ports in TgX but not in cycloneiv -----------------------------------
--         --- make them wire with fixed value so maximally reuse TgX code  -
--             to not modifying internal codes                              -
--         --- total = 60 5/7/09                                            -
-- --------------------------------------------------------------------------
    SIGNAL forcedispcompliance                      : STD_LOGIC := '0';
    SIGNAL freezptr                                 : STD_LOGIC := '0';
    SIGNAL hiptxdeemph                              : STD_LOGIC := '0';		
    SIGNAL hiptxmargin                              : STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');		
    SIGNAL iqpphfifoxnbytesel                       : STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
    SIGNAL iqpphfifoxnrdclk                         : STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
    SIGNAL iqpphfifoxnrdenable                      : STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
    SIGNAL iqpphfifoxnwrenable                      : STD_LOGIC_VECTOR(1 DOWNTO 0) := (others => '0');		
    SIGNAL phfifobyteserdisable                     : STD_LOGIC := '0';		
    SIGNAL phfifoptrsreset                          : STD_LOGIC := '0';		
    SIGNAL phfifoxnbottombytesel                    : STD_LOGIC := '0';		
    SIGNAL phfifoxnbottomrdclk                      : STD_LOGIC := '0';		
    SIGNAL phfifoxnbottomrdenable                   : STD_LOGIC := '0';		
    SIGNAL phfifoxnbottomwrenable                   : STD_LOGIC := '0';		
    SIGNAL phfifoxnbytesel                          : STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
    SIGNAL phfifoxnptrsreset                        : STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
    SIGNAL phfifoxnrdclk                            : STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
    SIGNAL phfifoxnrdenable                         : STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
    SIGNAL phfifoxntopbytesel                       : STD_LOGIC := '0';		
    SIGNAL phfifoxntoprdclk                         : STD_LOGIC := '0';		
    SIGNAL phfifoxntoprdenable                      : STD_LOGIC := '0';		
    SIGNAL phfifoxntopwrenable                      : STD_LOGIC := '0';		
    SIGNAL phfifoxnwrenable                         : STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');	
    SIGNAL pipetxdeemph                             : STD_LOGIC := '0';		--NEW;  RTL=txdeemph;
    SIGNAL pipetxmargin                             : STD_LOGIC_VECTOR(2 DOWNTO 0) := (others => '0');		--NEW;  RTL=txmargin[2:0]
    SIGNAL rateswitch                               : STD_LOGIC := '0';		--NEW,  RTL=rate
    SIGNAL rateswitchisdone                         : STD_LOGIC := '0';		
    SIGNAL rateswitchxndone                         : STD_LOGIC := '0';		

-- --------------------------------------------------------------------------
-- Output ports in TgX but not in cycloneiv ----------------------------------
--       SIGNAL - make them wire to maximally reuse TgX code                   -
--             to not modifying internal codes                              -
-- --------------------------------------------------------------------------
    SIGNAL iqpphfifobyteselout                      : STD_LOGIC;		
    SIGNAL iqpphfifordclkout                        : STD_LOGIC;		
    SIGNAL iqpphfifordenableout                     : STD_LOGIC;		
    SIGNAL iqpphfifowrenableout                     : STD_LOGIC;		
    SIGNAL phfifobyteselout                         : STD_LOGIC;
    SIGNAL phfifordclkout                           : STD_LOGIC;
    SIGNAL phfifordenableout                        : STD_LOGIC;    
    SIGNAL rateswitchout                            : STD_LOGIC;

-- --------------------------------------------------------------------------
-- Behavior code start                     ----------------------------------
-- --------------------------------------------------------------------------

   SIGNAL bitslipboundaryselect_ipd : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL coreclk_ipd             : STD_LOGIC;
   SIGNAL ctrlenable_ipd          : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL datain_ipd              : STD_LOGIC_VECTOR(39 DOWNTO 0);
   SIGNAL datainfull_ipd          : STD_LOGIC_VECTOR(21 DOWNTO 0);
   SIGNAL datainfull_siv          : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL detectrxloop_ipd        : STD_LOGIC;
   SIGNAL digitalreset_ipd        : STD_LOGIC;
   SIGNAL dispval_ipd             : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dpriodisable_ipd        : STD_LOGIC;
   SIGNAL dprioin_ipd             : STD_LOGIC_VECTOR(149 DOWNTO 0);
   SIGNAL enrevparallellpbk_ipd   : STD_LOGIC;
   SIGNAL forcedisp_ipd           : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL forcedispcompliance_ipd : STD_LOGIC;
   SIGNAL forceelecidle_ipd       : STD_LOGIC;
   SIGNAL freezptr_ipd            : STD_LOGIC;
   SIGNAL hipdatain_ipd           : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL hipdetectrxloop_ipd     : STD_LOGIC;
   SIGNAL hipforceelecidle_ipd    : STD_LOGIC;
   SIGNAL hippowerdn_ipd          : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL hiptxdeemph_ipd         : STD_LOGIC;
   SIGNAL hiptxmargin_ipd         : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL invpol_ipd              : STD_LOGIC;
   SIGNAL iqpphfifoxnbytesel_ipd  : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL iqpphfifoxnrdclk_ipd    : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL iqpphfifoxnrdenable_ipd : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL iqpphfifoxnwrenable_ipd : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL localrefclk_ipd         : STD_LOGIC;
   SIGNAL phfifobyteserdisable_ipd: STD_LOGIC;
   SIGNAL phfifoptrsreset_ipd     : STD_LOGIC;
   SIGNAL phfiforddisable_ipd     : STD_LOGIC;
   SIGNAL phfiforeset_ipd         : STD_LOGIC;
   SIGNAL phfifowrenable_ipd      : STD_LOGIC;
   SIGNAL phfifox4bytesel_ipd     : STD_LOGIC;
   SIGNAL phfifox4rdclk_ipd       : STD_LOGIC;
   SIGNAL phfifox4rdenable_ipd    : STD_LOGIC;
   SIGNAL phfifox4wrenable_ipd    : STD_LOGIC;
   SIGNAL phfifoxnbottombytesel_ipd    : STD_LOGIC;
   SIGNAL phfifoxnbottomrdclk_ipd      : STD_LOGIC;
   SIGNAL phfifoxnbottomrdenable_ipd   : STD_LOGIC;
   SIGNAL phfifoxnbottomwrenable_ipd   : STD_LOGIC;
   SIGNAL phfifoxnbytesel_ipd     : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxnptrsreset_ipd   : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxnrdclk_ipd       : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxnrdenable_ipd    : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxntopbytesel_ipd  : STD_LOGIC;
   SIGNAL phfifoxntoprdclk_ipd    : STD_LOGIC;
   SIGNAL phfifoxntoprdenable_ipd : STD_LOGIC;
   SIGNAL phfifoxntopwrenable_ipd : STD_LOGIC;
   SIGNAL phfifoxnwrenable_ipd    : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL pipestatetransdone_ipd  : STD_LOGIC;
   SIGNAL pipetxdeemph_ipd        : STD_LOGIC;
   SIGNAL pipetxmargin_ipd        : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL pipetxswing_ipd         : STD_LOGIC;
   SIGNAL powerdn_ipd             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL prbscidenable_ipd       : STD_LOGIC;
   SIGNAL quadreset_ipd           : STD_LOGIC;
   SIGNAL rateswitch_ipd          : STD_LOGIC;
   SIGNAL rateswitchisdone_ipd    : STD_LOGIC;
   SIGNAL rateswitchxndone_ipd    : STD_LOGIC;
   SIGNAL refclk_ipd              : STD_LOGIC;
   SIGNAL revparallelfdbk_ipd     : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL xgmctrl_ipd             : STD_LOGIC;
   SIGNAL xgmdatain_ipd           : STD_LOGIC_VECTOR(7 DOWNTO 0);
 
   COMPONENT cycloneiv_hssi_tx_pipe_interface
      PORT (
         clk                                      : IN STD_LOGIC;
         refclk_b                                 : IN STD_LOGIC;
         reset_n                                  : IN STD_LOGIC;
         refclk_b_reset_n                         : IN STD_LOGIC;
         rtx_pipe_enable                          : IN STD_LOGIC;
         rtx_elec_idle_delay                      : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rtxswing_sel_ena                         : IN STD_LOGIC;
         txdetectrxloopback                       : IN STD_LOGIC;
         txelecidle                               : IN STD_LOGIC;
         powerdown                                : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         txswing                                  : IN STD_LOGIC;
         txdeemph                                 : IN STD_LOGIC;
         txmargin                                 : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         txd_ch                                   : IN STD_LOGIC_VECTOR(43 DOWNTO 0);
         revloopback                              : IN STD_LOGIC;
         txd                                      : OUT STD_LOGIC_VECTOR(43 DOWNTO 0);
         rev_loopbk                               : OUT STD_LOGIC;
         tx_elec_idle_comp                        : IN STD_LOGIC;
         tx_elec_idle                             : OUT STD_LOGIC;
         txdetectrx                               : OUT STD_LOGIC;
         powerstate                               : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
         txswing_int                              : OUT STD_LOGIC;
         txdeemph_int                             : OUT STD_LOGIC;
         txmargin_int                             : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_tx_digi
      PORT (
         txpcs_rst                                : IN STD_LOGIC;
         scan_mode                                : IN STD_LOGIC;
         txd                                      : IN STD_LOGIC_VECTOR(43 DOWNTO 0);
         pld_tx_clk                               : IN STD_LOGIC;
         polinv_tx                                : IN STD_LOGIC;
         rev_loop_data                            : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
         wrenable_tx                              : IN STD_LOGIC;
         rddisable_tx                             : IN STD_LOGIC;
         phfifourst_tx                            : IN STD_LOGIC;
         txdetectrxloopback                       : IN STD_LOGIC;
         powerdown                                : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         revloopback                              : IN STD_LOGIC;
         txswing                                  : IN STD_LOGIC;
         pcs_txdeemph                             : IN STD_LOGIC;
         pcs_txmargin                             : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rxpolarity                               : IN STD_LOGIC;
         polinv_rx                                : IN STD_LOGIC;
         full_tx                                  : OUT STD_LOGIC;
         empty_tx                                 : OUT STD_LOGIC;
         tx_data_ts                               : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         tx_ctl_ts                                : IN STD_LOGIC;
         refclk_pma                               : IN STD_LOGIC;
         txpma_local_clk                          : IN STD_LOGIC;
         tx_clk_out                               : OUT STD_LOGIC;
         tx_data_tc                               : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
         tx_ctl_tc                                : OUT STD_LOGIC;
         pudr                                     : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);
         rd_enable_sync                           : OUT STD_LOGIC;
         refclk_b                                 : OUT STD_LOGIC;
         txlp20b                                  : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);
         tx_pipe_clk                              : OUT STD_LOGIC;
         encoder_testbus                          : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);
         tx_ctrl_testbus                          : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);
         tx_pipe_soft_reset                       : OUT STD_LOGIC;
         tx_pipe_electidle                        : OUT STD_LOGIC;
         txdetectrxloopback_int                   : OUT STD_LOGIC;
         powerdown_int                            : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         revloopback_int                          : OUT STD_LOGIC;
         phfifo_txswing                           : OUT STD_LOGIC;
         phfifo_txdeemph                          : OUT STD_LOGIC;
         phfifo_txmargin                          : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rxpolarity_int                           : OUT STD_LOGIC;
         polinv_rx_int                            : OUT STD_LOGIC;
         rrev_loopbk                              : IN STD_LOGIC;
         rev_loopbk                               : IN STD_LOGIC;
         eidleinfersel                            : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         gray_eidleinfersel                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rbisten_tx                               : IN STD_LOGIC;
         rforce_disp                              : IN STD_LOGIC;
         rib_force_disp                           : IN STD_LOGIC;
         rforce_echar                             : IN STD_LOGIC;
         rforce_kchar                             : IN STD_LOGIC;
         rendec_tx                                : IN STD_LOGIC;
         rge_xaui_tx                              : IN STD_LOGIC;
         rdwidth_tx                               : IN STD_LOGIC;
         rtxfifo_dis                              : IN STD_LOGIC;
         rcascaded_8b10b_en_tx                    : IN STD_LOGIC;
         rprbsen_tx                               : IN STD_LOGIC;
         rprbs_sel                                : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rbist_sel                                : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rcxpat_chnl_en                           : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         renpolinv_tx                             : IN STD_LOGIC;
         rphfifopldentx                           : IN STD_LOGIC;
         rphfifoursttx                            : IN STD_LOGIC;
         rfreerun_tx                              : IN STD_LOGIC;
         rtxwrclksel                              : IN STD_LOGIC;
         rtxrdclksel                              : IN STD_LOGIC;
         renbitrev_tx                             : IN STD_LOGIC;
         rensymswap_tx                            : IN STD_LOGIC;
         r8b10b_enc_ibm_en                        : IN STD_LOGIC;
         rtxfifo_lowlatency_en                    : IN STD_LOGIC;
         rpmadwidth_tx                            : IN STD_LOGIC;
         rpma_doublewidth_tx                      : IN STD_LOGIC;
         rtx_pipe_enable                          : IN STD_LOGIC;
         rindv_tx                                 : IN STD_LOGIC;
         rendec_data_sel_tx                       : IN STD_LOGIC;
         rtxpcsbypass_en                          : IN STD_LOGIC;
         rtxpcsclkpwdn                            : IN STD_LOGIC;
         rauto_speed_ena                          : IN STD_LOGIC;
         rfreq_sel                                : IN STD_LOGIC;
         gen2ngen1                                : IN STD_LOGIC;
         gen2ngen1_bundle                         : IN STD_LOGIC;
         rcid_pattern_tx                          : IN STD_LOGIC;
         rcid_len_tx                              : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         tx_div2_sync_in_centrl                   : IN STD_LOGIC;
         tx_div2_sync_in_quad_up                  : IN STD_LOGIC;
         tx_div2_sync_in_quad_down                : IN STD_LOGIC;
         wr_enable_in_centrl                      : IN STD_LOGIC;
         wr_enable_in_quad_up                     : IN STD_LOGIC;
         wr_enable_in_quad_down                   : IN STD_LOGIC;
         rd_enable_in_centrl                      : IN STD_LOGIC;
         rd_enable_in_quad_up                     : IN STD_LOGIC;
         rd_enable_in_quad_down                   : IN STD_LOGIC;
         fifo_select_in_centrl                    : IN STD_LOGIC;
         fifo_select_in_quad_up                   : IN STD_LOGIC;
         fifo_select_in_quad_down                 : IN STD_LOGIC;
         dis_pc_byte                              : IN STD_LOGIC;
         reset_pc_ptrs                            : IN STD_LOGIC;
         reset_pc_ptrs_in_centrl                  : IN STD_LOGIC;
         reset_pc_ptrs_in_quad_up                 : IN STD_LOGIC;
         reset_pc_ptrs_in_quad_down               : IN STD_LOGIC;
         tx_div2_sync_in_pipe_quad_up             : IN STD_LOGIC;
         tx_div2_sync_in_pipe_quad_down           : IN STD_LOGIC;
         wr_enable_in_pipe_quad_up                : IN STD_LOGIC;
         wr_enable_in_pipe_quad_down              : IN STD_LOGIC;
         rd_enable_in_pipe_quad_up                : IN STD_LOGIC;
         rd_enable_in_pipe_quad_down              : IN STD_LOGIC;
         fifo_select_in_pipe_quad_up              : IN STD_LOGIC;
         fifo_select_in_pipe_quad_down            : IN STD_LOGIC;
         rmaster_tx                               : IN STD_LOGIC;
         rmaster_up_tx                            : IN STD_LOGIC;
         rself_sw_en_tx                           : IN STD_LOGIC;
         rpipeline_bypass_tx                      : IN STD_LOGIC;
         rphfifo_regmode_tx                       : IN STD_LOGIC;
         rtxbitslip_en                            : IN STD_LOGIC;
         tx_div2_sync_out_pipe_up                 : OUT STD_LOGIC;
         fifo_select_out_pipe_up                  : OUT STD_LOGIC;
         wr_enable_out_pipe_up                    : OUT STD_LOGIC;
         rd_enable_out_pipe_up                    : OUT STD_LOGIC;
         tx_div2_sync_out_pipe_down               : OUT STD_LOGIC;
         fifo_select_out_pipe_down                : OUT STD_LOGIC;
         wr_enable_out_pipe_down                  : OUT STD_LOGIC;
         rd_enable_out_pipe_down                  : OUT STD_LOGIC;
         prbs_cid_en                              : IN STD_LOGIC;
         tx_boundary_sel                          : IN STD_LOGIC_VECTOR(4 DOWNTO 0)
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_digi_chnl_hip_spt
      PORT (
         rhip_ena                                 : IN STD_LOGIC;
         pcs_rxd_ch                               : IN STD_LOGIC_VECTOR(8 DOWNTO 0);
         pcs_rxvalid                              : IN STD_LOGIC;
         pcs_rxelecidle                           : IN STD_LOGIC;
         pcs_rxstatus_ch                          : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         pcs_phystatus                            : IN STD_LOGIC;
         txpma_local_clk                          : IN STD_LOGIC;
         txd_ch                                   : IN STD_LOGIC_VECTOR(10 DOWNTO 0);
         hip_txd_ch                               : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
         txdetectrxloopback                       : IN STD_LOGIC;
         hip_txdetectrxloopback                   : IN STD_LOGIC;
         rxpolarity                               : IN STD_LOGIC;
         hip_rxpolarity                           : IN STD_LOGIC;
         powerdown_ch                             : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         hip_powerdown_ch                         : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         txdeemph                                 : IN STD_LOGIC;
         hip_txdeemph                             : IN STD_LOGIC;
         txmargin_ch                              : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         hip_txmargin_ch                          : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         eidleinfersel_ch                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         hip_eidleinfersel_ch                     : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rate                                     : IN STD_LOGIC;
         hip_rate                                 : IN STD_LOGIC;
         hip_txelecidle                           : IN STD_LOGIC;
         rxd_ch                                   : OUT STD_LOGIC_VECTOR(8 DOWNTO 0);
         hip_rxd_ch                               : OUT STD_LOGIC_VECTOR(8 DOWNTO 0);
         rxvalid                                  : OUT STD_LOGIC;
         hip_rxvalid                              : OUT STD_LOGIC;
         rxelecidle                               : OUT STD_LOGIC;
         hip_rxelecidle                           : OUT STD_LOGIC;
         rxstatus_ch                              : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         hip_rxstatus_ch                          : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         phystatus                                : OUT STD_LOGIC;
         hip_phystatus                            : OUT STD_LOGIC;
         hip_tx_clk                               : OUT STD_LOGIC;
         pcs_txd_ch                               : OUT STD_LOGIC_VECTOR(10 DOWNTO 0);
         pcs_txdetectrxloopback                   : OUT STD_LOGIC;
         pcs_rxpolarity                           : OUT STD_LOGIC;
         pcs_powerdown_ch                         : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
         pcs_txdeemph                             : OUT STD_LOGIC;
         pcs_txmargin_ch                          : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         pcs_eidleinfersel_ch                     : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         pcs_rate                                 : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT cycloneiv_hssi_pcs_reset
      PORT (
         hard_reset                               : IN STD_LOGIC;
         clk_2_b                                  : IN STD_LOGIC;
         refclk_b_in                              : IN STD_LOGIC;
         scan_mode                                : IN STD_LOGIC;
         rxpcs_rst                                : IN STD_LOGIC;
         txpcs_rst                                : IN STD_LOGIC;
         rxrst_int                                : OUT STD_LOGIC;
         txrst_int                                : OUT STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL tmp_ctrlenable                       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL tmp_datain                           : STD_LOGIC_VECTOR(39 DOWNTO 0);
   SIGNAL tmp_dispval                          : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL tmp_forcedisp                        : STD_LOGIC_VECTOR(3 DOWNTO 0);

   constant DPRIO_CHANNEL_INTERFACE_BIT : STD_LOGIC_VECTOR(5 DOWNTO 0) := "000100";
   
   -- new dprio model --
   -- Table1: PCS Per Channel TX Control Register 1 for Channel 0
	constant rforce_disp_TXPCS_IDX_0	: integer := 0;
	constant rrev_loopbk_TXPCS_IDX_0	: integer := 1;
	constant rtxrdclksel_TXPCS_IDX_0	: integer := 2;
	constant rtxwrclksel_TXPCS_IDX_0	: integer := 3;
	constant rfreerun_tx_TXPCS_IDX_0	: integer := 4;
	constant rtxurstpcs_TXPCS_IDX_0	: integer := 5;
	constant reserved_0_TB1_TXPCS_IDX_0	: integer := 6;
	constant rphfifoursttx_TXPCS_IDX_0	: integer := 7;
	constant rphfifopldentx_TXPCS_IDX_0	: integer := 8;
	constant rge_xaui_tx_TXPCS_IDX_0	: integer := 9;
	constant rdwidth_tx_TXPCS_IDX_0	: integer := 10;
	constant rtxfifo_lowlatency_en_TXPCS_IDX_0	: integer := 11;
	constant rib_force_disp_TXPCS_IDX_0	: integer := 12;
	constant rtxfifo_dis_TXPCS_IDX_0	: integer := 13;
	constant rforce_echar_TXPCS_IDX_0	: integer := 14;
	constant rforce_kchar_TXPCS_IDX_0	: integer := 15;
	
	-- Table2: PCS Per Channel TX Control Register 2 for Channel 0
	constant rtxpcsbypass_en_TXPCS_IDX_0	: integer := 16;
	constant rcxpat_chnl_en_TXPCS_IDX_0	: integer := 17;
	constant rcxpat_chnl_en_TXPCS_IDX_1	: integer := 18;
	constant rbist_sel_TXPCS_IDX_0	: integer := 19;
	constant rbist_sel_TXPCS_IDX_1	: integer := 20;
	constant rbisten_tx_TXPCS_IDX_0	: integer := 21;
	constant rprbs_sel_TXPCS_IDX_0	: integer := 22;
	constant rprbs_sel_TXPCS_IDX_1	: integer := 23;
	constant rprbs_sel_TXPCS_IDX_2	: integer := 24;
	constant rprbsen_tx_TXPCS_IDX_0	: integer := 25;
	constant renbitrev_tx_TXPCS_IDX_0	: integer := 26;
	constant renpolinv_tx_TXPCS_IDX_0	: integer := 27;
	constant rensymswap_tx_TXPCS_IDX_0	: integer := 28;
	constant rcascaded_8b10b_en_tx_TXPCS_IDX_0	: integer := 29;
	constant r8b10b_enc_ibm_en_TXPCS_IDX_0	: integer := 30;
	constant rendec_tx_TXPCS_IDX_0	: integer := 31;
	
	-- Table3: PCS Per Channel TX Control Register 3 for Channel 0
	constant reserved_0_TB3_TXPCS_IDX_0	: integer := 32;
	constant rcid_len_tx_TXPCS_IDX_0	: integer := 33;
	constant rcid_len_tx_TXPCS_IDX_1	: integer := 34;
	constant rcid_len_tx_TXPCS_IDX_2	: integer := 35;
	constant rcid_len_tx_TXPCS_IDX_3	: integer := 36;
	constant rcid_len_tx_TXPCS_IDX_4	: integer := 37;
	constant rcid_len_tx_TXPCS_IDX_5	: integer := 38;
	constant rcid_len_tx_TXPCS_IDX_6	: integer := 39;
	constant rcid_len_tx_TXPCS_IDX_7	: integer := 40;
	constant rcid_pattern_tx_TXPCS_IDX_0	: integer := 41;
	constant rtxpcsclkpwdn_TXPCS_IDX_0	: integer := 42;
	constant rtxswing_sel_ena_TXPCS_IDX_0	: integer := 43;
	constant rtx_elec_idle_delay_TXPCS_IDX_0	: integer := 44;
	constant rtx_elec_idle_delay_TXPCS_IDX_1	: integer := 45;
	constant rtx_elec_idle_delay_TXPCS_IDX_2	: integer := 46;
	constant rtx_pipe_enable_TXPCS_IDX_0	: integer := 47;
	
	-- Table4: PCS Per Channel TX Control Register 4 for Channel 0
	constant reserved_0_TB4_TXPCS_IDX_0	: integer := 48;
	constant reserved_0_TB4_TXPCS_IDX_1	: integer := 49;
	constant reserved_0_TB4_TXPCS_IDX_2	: integer := 50;
	constant reserved_0_TB4_TXPCS_IDX_3	: integer := 51;
	constant reserved_0_TB4_TXPCS_IDX_4	: integer := 52;
	constant reserved_0_TB4_TXPCS_IDX_5	: integer := 53;
	constant reserved_0_TB4_TXPCS_IDX_6	: integer := 54;
	constant reserved_0_TB4_TXPCS_IDX_7	: integer := 55;
	constant reserved_0_TB4_TXPCS_IDX_8	: integer := 56;
	constant reserved_0_TB4_TXPCS_IDX_9	: integer := 57;
	constant reserved_0_TB4_TXPCS_IDX_10	: integer := 58;
	constant reserved_0_TB4_TXPCS_IDX_11	: integer := 59;
	constant rtxbitslip_en_TXPCS_IDX_0	: integer := 60;
	constant rphfifo_regmode_tx_TXPCS_IDX_0	: integer := 61;
	constant rpipeline_bypass_tx_TXPCS_IDX_0	: integer := 62;
	constant rself_sw_en_tx_TXPCS_IDX_0	: integer := 63;
	
	-- Existing
	constant rauto_speed_ena_TX_IDX		: integer := 64;
	constant rendec_data_sel_tx_TX_IDX  : integer := 65;
	constant rfreq_sel_TX_IDX           : integer := 66;
	constant rhip_ena_TX_IDX            : integer := 67;
	constant rindv_tx_TX_IDX            : integer := 68;
	constant rphfifo_master_sel_tx_TX_IDX : integer := 69;
	constant rpma_doublewidth_tx_TX_IDX   : integer := 70;
	constant rpmadwidth_tx_TX_IDX         : integer := 71;
	constant rtx_cmu_sel_TX_IDX           : integer := 72;
	
	-- -------------------------------------------------------------------------
	-- DPRIO input CRAM  
	-- -------------------------------------------------------------------------
	-- Existing
	SIGNAL dprioin_is_lane0: STD_LOGIC;
	SIGNAL dprioin_rauto_speed_ena: STD_LOGIC;
	SIGNAL dprioin_rclkcmpinsertpad: STD_LOGIC;         -- rx only ========= pipe ===========    
	SIGNAL dprioin_rendec_data_sel_tx: STD_LOGIC;
	SIGNAL dprioin_rfreq_sel: STD_LOGIC;
	SIGNAL dprioin_rhip_ena: STD_LOGIC;
	SIGNAL dprioin_rindv_tx: STD_LOGIC;
	SIGNAL dprioin_rmaster_tx: STD_LOGIC;
	SIGNAL dprioin_rmaster_up_tx: STD_LOGIC;
	SIGNAL dprioin_rphfifo_master_sel_tx: STD_LOGIC;
	SIGNAL dprioin_rpma_doublewidth_tx: STD_LOGIC;
	SIGNAL dprioin_rpmadwidth_tx: STD_LOGIC;
	SIGNAL dprioin_rrdwidth_rx: STD_LOGIC;              	-- rx only
	SIGNAL dprioin_rrx_detect_bypass: STD_LOGIC;        	-- rx only
	SIGNAL dprioin_rrx_pipe_enable: STD_LOGIC;          	-- rx only
	SIGNAL dprioin_rtx_cmu_sel: STD_LOGIC;                 -- added in 6.1
	SIGNAL dprioin_scan_mode: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 1 for Channel 0
	SIGNAL dprioin_rforce_disp	: STD_LOGIC;
	SIGNAL dprioin_rrev_loopbk	: STD_LOGIC;
	SIGNAL dprioin_rtxrdclksel	: STD_LOGIC;
	SIGNAL dprioin_rtxwrclksel	: STD_LOGIC;
	SIGNAL dprioin_rfreerun_tx	: STD_LOGIC;
	SIGNAL dprioin_rtxurstpcs	: STD_LOGIC;
	SIGNAL dprioin_reserved_0_TB1	: STD_LOGIC;
	SIGNAL dprioin_rphfifoursttx	: STD_LOGIC;
	SIGNAL dprioin_rphfifopldentx	: STD_LOGIC;
	SIGNAL dprioin_rge_xaui_tx	: STD_LOGIC;
	SIGNAL dprioin_rdwidth_tx	: STD_LOGIC;
	SIGNAL dprioin_rtxfifo_lowlatency_en	: STD_LOGIC;
	SIGNAL dprioin_rib_force_disp	: STD_LOGIC;
	SIGNAL dprioin_rtxfifo_dis	: STD_LOGIC;
	SIGNAL dprioin_rforce_echar	: STD_LOGIC;
	SIGNAL dprioin_rforce_kchar	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 2 for Channel 0
	SIGNAL dprioin_rtxpcsbypass_en	: STD_LOGIC;
	SIGNAL dprioin_rcxpat_chnl_en	: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL dprioin_rbist_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL dprioin_rbisten_tx	: STD_LOGIC;
	SIGNAL dprioin_rprbs_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
	SIGNAL dprioin_rprbsen_tx	: STD_LOGIC;
	SIGNAL dprioin_renbitrev_tx	: STD_LOGIC;
	SIGNAL dprioin_renpolinv_tx	: STD_LOGIC;
	SIGNAL dprioin_rensymswap_tx	: STD_LOGIC;
	SIGNAL dprioin_rcascaded_8b10b_en_tx	: STD_LOGIC;
	SIGNAL dprioin_r8b10b_enc_ibm_en	: STD_LOGIC;
	SIGNAL dprioin_rendec_tx	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 3 for Channel 0
	SIGNAL dprioin_reserved_0_TB3	: STD_LOGIC;
	SIGNAL dprioin_rcid_len_tx	: STD_LOGIC_VECTOR(7 DOWNTO 0);
	SIGNAL dprioin_rcid_pattern_tx	: STD_LOGIC;
	SIGNAL dprioin_rtxpcsclkpwdn	: STD_LOGIC;
	SIGNAL dprioin_rtxswing_sel_ena	: STD_LOGIC;
	SIGNAL dprioin_rtx_elec_idle_delay	: STD_LOGIC_VECTOR(2 DOWNTO 0);
	SIGNAL dprioin_rtx_pipe_enable	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 4 for Channel 0
	SIGNAL dprioin_reserved_0_TB4	: STD_LOGIC_VECTOR(11 DOWNTO 0);
	SIGNAL dprioin_rtxbitslip_en	: STD_LOGIC;
	SIGNAL dprioin_rphfifo_regmode_tx	: STD_LOGIC;
	SIGNAL dprioin_rpipeline_bypass_tx	: STD_LOGIC;
	SIGNAL dprioin_rself_sw_en_tx	: STD_LOGIC;
	
	-- -------------------------------------------------------------------------
	-- Initial CRAM  
	-- -------------------------------------------------------------------------
	-- Existing
    SIGNAL init_is_lane0: STD_LOGIC;
    SIGNAL init_rauto_speed_ena: STD_LOGIC;
    SIGNAL init_rclkcmpinsertpad: STD_LOGIC;             -- rx only ========= pipe ===========    
    SIGNAL init_rendec_data_sel_tx: STD_LOGIC;
    SIGNAL init_rfreq_sel: STD_LOGIC;
    SIGNAL init_rhip_ena: STD_LOGIC;
    SIGNAL init_rindv_tx: STD_LOGIC;
    SIGNAL init_rmaster_tx: STD_LOGIC;
    SIGNAL init_rmaster_up_tx: STD_LOGIC;
    SIGNAL init_rphfifo_master_sel_tx: STD_LOGIC;
    SIGNAL init_rpma_doublewidth_tx: STD_LOGIC;
    SIGNAL init_rpmadwidth_tx: STD_LOGIC;
    SIGNAL init_rrdwidth_rx: STD_LOGIC;                  -- rx only
    SIGNAL init_rrx_detect_bypass: STD_LOGIC;            -- rx only
    SIGNAL init_rrx_pipe_enable: STD_LOGIC;              -- rx only
    SIGNAL init_rtx_cmu_sel: STD_LOGIC;          		 -- added in 6.1
    SIGNAL init_scan_mode: STD_LOGIC;
   
	-- PCS Per Channel TX Control Register 1 for Channel 0
	SIGNAL init_rforce_disp	: STD_LOGIC;
	SIGNAL init_rrev_loopbk	: STD_LOGIC;
	SIGNAL init_rtxrdclksel	: STD_LOGIC;
	SIGNAL init_rtxwrclksel	: STD_LOGIC;
	SIGNAL init_rfreerun_tx	: STD_LOGIC;
	SIGNAL init_rtxurstpcs	: STD_LOGIC;
	SIGNAL init_reserved_0_TB1	: STD_LOGIC;
	SIGNAL init_rphfifoursttx	: STD_LOGIC;
	SIGNAL init_rphfifopldentx	: STD_LOGIC;
	SIGNAL init_rge_xaui_tx	: STD_LOGIC;
	SIGNAL init_rdwidth_tx	: STD_LOGIC;
	SIGNAL init_rtxfifo_lowlatency_en	: STD_LOGIC;
	SIGNAL init_rib_force_disp	: STD_LOGIC;
	SIGNAL init_rtxfifo_dis	: STD_LOGIC;
	SIGNAL init_rforce_echar	: STD_LOGIC;
	SIGNAL init_rforce_kchar	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 2 for Channel 0
	SIGNAL init_rtxpcsbypass_en	: STD_LOGIC;
	SIGNAL init_rcxpat_chnl_en	: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL init_rbist_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL init_rbisten_tx	: STD_LOGIC;
	SIGNAL init_rprbs_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
	SIGNAL init_rprbsen_tx	: STD_LOGIC;
	SIGNAL init_renbitrev_tx	: STD_LOGIC;
	SIGNAL init_renpolinv_tx	: STD_LOGIC;
	SIGNAL init_rensymswap_tx	: STD_LOGIC;
	SIGNAL init_rcascaded_8b10b_en_tx	: STD_LOGIC;
	SIGNAL init_r8b10b_enc_ibm_en	: STD_LOGIC;
	SIGNAL init_rendec_tx	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 3 for Channel 0
	SIGNAL init_reserved_0_TB3	: STD_LOGIC;
	SIGNAL init_rcid_len_tx	: STD_LOGIC_VECTOR(7 DOWNTO 0);
	SIGNAL init_rcid_pattern_tx	: STD_LOGIC;
	SIGNAL init_rtxpcsclkpwdn	: STD_LOGIC;
	SIGNAL init_rtxswing_sel_ena	: STD_LOGIC;
	SIGNAL init_rtx_elec_idle_delay	: STD_LOGIC_VECTOR(2 DOWNTO 0);
	SIGNAL init_rtx_pipe_enable	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 4 for Channel 0
	SIGNAL init_reserved_0_TB4	: STD_LOGIC_VECTOR(11 DOWNTO 0);
	SIGNAL init_rtxbitslip_en	: STD_LOGIC;
	SIGNAL init_rphfifo_regmode_tx	: STD_LOGIC;
	SIGNAL init_rpipeline_bypass_tx	: STD_LOGIC;
	SIGNAL init_rself_sw_en_tx	: STD_LOGIC;
	
	-- -------------------------------------------------------------------------
	-- CRAM  
	-- -------------------------------------------------------------------------
	-- Existing
	SIGNAL cram_is_lane0: STD_LOGIC;
	SIGNAL cram_rauto_speed_ena: STD_LOGIC;
	SIGNAL cram_rclkcmpinsertpad: STD_LOGIC;             -- rx only ========= pipe ===========    
	SIGNAL cram_rendec_data_sel_tx: STD_LOGIC;
	SIGNAL cram_rfreq_sel: STD_LOGIC;
	SIGNAL cram_rhip_ena: STD_LOGIC;
	SIGNAL cram_rindv_tx: STD_LOGIC;
	SIGNAL cram_rmaster_tx: STD_LOGIC;
	SIGNAL cram_rmaster_up_tx: STD_LOGIC;
	SIGNAL cram_rphfifo_master_sel_tx: STD_LOGIC;
	SIGNAL cram_rpma_doublewidth_tx: STD_LOGIC;
	SIGNAL cram_rpmadwidth_tx: STD_LOGIC;
	SIGNAL cram_rrdwidth_rx: STD_LOGIC;                  -- rx only
	SIGNAL cram_rrx_detect_bypass: STD_LOGIC;            -- rx only
	SIGNAL cram_rrx_pipe_enable: STD_LOGIC;              -- rx only
	SIGNAL cram_rtx_cmu_sel: STD_LOGIC;          		  -- added in 6.1
	SIGNAL cram_scan_mode: STD_LOGIC;

	-- PCS Per Channel TX Control Register 1 for Channel 0
	SIGNAL cram_rforce_disp	: STD_LOGIC;
	SIGNAL cram_rrev_loopbk	: STD_LOGIC;
	SIGNAL cram_rtxrdclksel	: STD_LOGIC;
	SIGNAL cram_rtxwrclksel	: STD_LOGIC;
	SIGNAL cram_rfreerun_tx	: STD_LOGIC;
	SIGNAL cram_rtxurstpcs	: STD_LOGIC;
	SIGNAL cram_reserved_0_TB1	: STD_LOGIC;
	SIGNAL cram_rphfifoursttx	: STD_LOGIC;
	SIGNAL cram_rphfifopldentx	: STD_LOGIC;
	SIGNAL cram_rge_xaui_tx	: STD_LOGIC;
	SIGNAL cram_rdwidth_tx	: STD_LOGIC;
	SIGNAL cram_rtxfifo_lowlatency_en	: STD_LOGIC;
	SIGNAL cram_rib_force_disp	: STD_LOGIC;
	SIGNAL cram_rtxfifo_dis	: STD_LOGIC;
	SIGNAL cram_rforce_echar	: STD_LOGIC;
	SIGNAL cram_rforce_kchar	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 2 for Channel 0
	SIGNAL cram_rtxpcsbypass_en	: STD_LOGIC;
	SIGNAL cram_rcxpat_chnl_en	: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL cram_rbist_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL cram_rbisten_tx	: STD_LOGIC;
	SIGNAL cram_rprbs_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
	SIGNAL cram_rprbsen_tx	: STD_LOGIC;
	SIGNAL cram_renbitrev_tx	: STD_LOGIC;
	SIGNAL cram_renpolinv_tx	: STD_LOGIC;
	SIGNAL cram_rensymswap_tx	: STD_LOGIC;
	SIGNAL cram_rcascaded_8b10b_en_tx	: STD_LOGIC;
	SIGNAL cram_r8b10b_enc_ibm_en	: STD_LOGIC;
	SIGNAL cram_rendec_tx	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 3 for Channel 0
	SIGNAL cram_reserved_0_TB3	: STD_LOGIC;
	SIGNAL cram_rcid_len_tx	: STD_LOGIC_VECTOR(7 DOWNTO 0);
	SIGNAL cram_rcid_pattern_tx	: STD_LOGIC;
	SIGNAL cram_rtxpcsclkpwdn	: STD_LOGIC;
	SIGNAL cram_rtxswing_sel_ena	: STD_LOGIC;
	SIGNAL cram_rtx_elec_idle_delay	: STD_LOGIC_VECTOR(2 DOWNTO 0);
	SIGNAL cram_rtx_pipe_enable	: STD_LOGIC;
	
	-- PCS Per Channel TX Control Register 4 for Channel 0
	SIGNAL cram_reserved_0_TB4	: STD_LOGIC_VECTOR(11 DOWNTO 0);
	SIGNAL cram_rtxbitslip_en	: STD_LOGIC;
	SIGNAL cram_rphfifo_regmode_tx	: STD_LOGIC;
	SIGNAL cram_rpipeline_bypass_tx	: STD_LOGIC;
	SIGNAL cram_rself_sw_en_tx	: STD_LOGIC;
	
	SIGNAL dpriodisable_in           : STD_LOGIC;
	
	----- new dprio end   
   
   --///////////////////////////////////////////////////////////////////////////////
   -- sub-block interface: pcs_reset     -----------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   SIGNAL pr_in_hard_reset                     : STD_LOGIC;
   SIGNAL pr_in_clk_2_b                        : STD_LOGIC;
   SIGNAL pr_in_refclk_b_in                    : STD_LOGIC;
   SIGNAL pr_in_scan_mode                      : STD_LOGIC;
   SIGNAL pr_in_rxpcs_rst                      : STD_LOGIC;
   SIGNAL pr_in_txpcs_rst                      : STD_LOGIC;
   SIGNAL pr_out_txrst_int                     : STD_LOGIC;
   
   --///////////////////////////////////////////////////////////////////////////////
   -- sub-block interface: chnl_hip_spt  -----------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   SIGNAL hs_in_eidleinfersel_ch               : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_in_hip_eidleinfersel_ch           : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_in_hip_powerdown_ch               : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL hs_in_hip_rate                       : STD_LOGIC;
   SIGNAL hs_in_hip_rxpolarity                 : STD_LOGIC;
   SIGNAL hs_in_hip_txd_ch                     : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL hs_in_hip_txdeemph                   : STD_LOGIC;
   SIGNAL hs_in_hip_txdetectrxloopback         : STD_LOGIC;
   SIGNAL hs_in_hip_txelecidle                 : STD_LOGIC;
   SIGNAL hs_in_hip_txmargin_ch                : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_in_pcs_phystatus                  : STD_LOGIC;
   SIGNAL hs_in_pcs_rxd_ch                     : STD_LOGIC_VECTOR(8 DOWNTO 0);
   SIGNAL hs_in_pcs_rxelecidle                 : STD_LOGIC;
   SIGNAL hs_in_pcs_rxstatus_ch                : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_in_pcs_rxvalid                    : STD_LOGIC;
   SIGNAL hs_in_powerdown_ch                   : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL hs_in_rate                           : STD_LOGIC;
   SIGNAL hs_in_rhip_ena                       : STD_LOGIC;
   SIGNAL hs_in_rxpolarity                     : STD_LOGIC;
   SIGNAL hs_in_txd_ch                         : STD_LOGIC_VECTOR(10 DOWNTO 0);
   SIGNAL hs_in_txdeemph                       : STD_LOGIC;
   SIGNAL hs_in_txdetectrxloopback             : STD_LOGIC;
   SIGNAL hs_in_txmargin_ch                    : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_in_txpma_local_clk                : STD_LOGIC;
   
   SIGNAL hs_out_hip_phystatus                 : STD_LOGIC;
   SIGNAL hs_out_hip_rxd_ch                    : STD_LOGIC_VECTOR(8 DOWNTO 0);
   SIGNAL hs_out_hip_rxelecidle                : STD_LOGIC;
   SIGNAL hs_out_hip_rxstatus_ch               : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_out_hip_rxvalid                   : STD_LOGIC;
   SIGNAL hs_out_hip_tx_clk                    : STD_LOGIC;
   SIGNAL hs_out_pcs_eidleinfersel_ch          : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_out_pcs_powerdown_ch              : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL hs_out_pcs_rate                      : STD_LOGIC;
   SIGNAL hs_out_pcs_rxpolarity                : STD_LOGIC;
   SIGNAL hs_out_pcs_txd_ch                    : STD_LOGIC_VECTOR(10 DOWNTO 0);
   SIGNAL hs_out_pcs_txdeemph                  : STD_LOGIC;
   SIGNAL hs_out_pcs_txdetectrxloopback        : STD_LOGIC;
   SIGNAL hs_out_pcs_txmargin_ch               : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_out_phystatus                     : STD_LOGIC;
   SIGNAL hs_out_rxd_ch                        : STD_LOGIC_VECTOR(8 DOWNTO 0);
   SIGNAL hs_out_rxelecidle                    : STD_LOGIC;
   SIGNAL hs_out_rxstatus_ch                   : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hs_out_rxvalid                       : STD_LOGIC;
   
   --///////////////////////////////////////////////////////////////////////////////
   -- sub-block interface: pipe_interface  ---------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   -- inputs
   SIGNAL pi_in_pipe_tx_clk                    : STD_LOGIC;
   SIGNAL pi_in_powerdown                      : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL pi_in_refclk_b                       : STD_LOGIC;
   SIGNAL pi_in_refclk_b_reset_n               : STD_LOGIC;		
   SIGNAL pi_in_revloopback                    : STD_LOGIC;
   SIGNAL pi_in_state_transition_done          : STD_LOGIC;
   SIGNAL pi_in_tx_elec_idle_comp              : STD_LOGIC;
   SIGNAL pi_in_tx_pipe_reset_n                : STD_LOGIC;
   SIGNAL pi_in_txd_ch                         : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL pi_in_txd_ch_dprio                   : STD_LOGIC_VECTOR(43 DOWNTO 0);		
   SIGNAL pi_in_txdetectrxloopback             : STD_LOGIC;
   SIGNAL pi_in_txelecidle                     : STD_LOGIC;
   SIGNAL pi_in_txd_ch_tmp                     : STD_LOGIC_VECTOR(43 DOWNTO 0);		-- before interleaving in dwidth_single PMA
   
   -- outputs
   SIGNAL pi_out_powerstate                    : STD_LOGIC_VECTOR(3 DOWNTO 0);		-- to top - both cmu and rx
   SIGNAL pi_out_rev_loopbk                    : STD_LOGIC;		-- to TD
   SIGNAL pi_out_tx_elec_idle                  : STD_LOGIC;		-- to tx PMA - TX sending electrical idle
   SIGNAL pi_out_txd                           : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL pi_out_txdetectrx                    : STD_LOGIC;		-- to tx PMA - RX_DET
   
   -- new input in CYCLONEIV - ww26.5 =====================================
   -- from PLD
   SIGNAL pi_in_txdeemph                       : STD_LOGIC;
   SIGNAL pi_in_txmargin                       : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL pi_in_txswing                        : STD_LOGIC;
   
   -- new output in CYCLONEIV - ww26.5 ====================================
   -- exposured to digi_top
   SIGNAL pi_out_txdeemph_int                  : STD_LOGIC;
   SIGNAL pi_out_txmargin_int                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL pi_out_txswing_int                   : STD_LOGIC;
   
   --///////////////////////////////////////////////////////////////////////////////
   -- sub-block interface: tx digital  -------------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   -- inputs
   SIGNAL td_in_phfifourst_tx                  : STD_LOGIC;
   SIGNAL td_in_pld_tx_clk                     : STD_LOGIC;
   SIGNAL td_in_polinv_tx                      : STD_LOGIC;
   SIGNAL td_in_rddisable_tx                   : STD_LOGIC;
   SIGNAL td_in_refclk_pma                     : STD_LOGIC;
   SIGNAL td_in_rev_loop_data                  : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL td_in_rev_loopbk                     : STD_LOGIC;
   SIGNAL td_in_tx_ctl_ts                      : STD_LOGIC;
   SIGNAL td_in_tx_data_ts                     : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL td_in_txd                            : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL td_in_txfifo_shared_sig_in_ch0       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL td_in_txfifo_shared_sig_in_q0_ch0    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL td_in_txpcs_rst                      : STD_LOGIC;
   SIGNAL td_in_txpma_local_clk                : STD_LOGIC;
   SIGNAL td_in_wrenable_tx                    : STD_LOGIC;
   
   -- new input in CYCLONEIV - ww26.5 ======================================
   
   -- freeze pointer for TX/RX phase comp FIFO during freq negotiation
   -- to tx_ctrl from rx_digi (auto_speed_neg sub-block) 
   SIGNAL td_in_freeze_ptr                     : STD_LOGIC;
   -- to tx_ctrl from TX PMA local clock divider 
   SIGNAL td_in_gen2ngen1                      : STD_LOGIC;
   -- to tx_ctrl from central clock divider 
   SIGNAL td_in_gen2ngen1_bundle               : STD_LOGIC;
   -- to tx_ctrl from PLD (RX polarity inversion dynamic control)
   --       paired with polinv_tx
   -- path: polinv_rx (pld) -> tx_digi (tx_ctrl after encoder) ->
   --    (just a simple wire in tx_ctrl so leaving it out of tx)
   --       rx_pipe (mux with rxpolarity) -> rx_digi (wordalign and decoder)
   SIGNAL td_in_polinv_rx                      : STD_LOGIC;
   -- to tx_ctrl from PLD
   -- generating powerdown_int output feeding both rx_pipe and tx_pipe
   SIGNAL td_in_powerdown                      : STD_LOGIC_VECTOR(1 DOWNTO 0);
   -- to tx_ctrl from quad pcs top
   -- generating rate_int output feeding rx_digi (auto_speed_neg)
   SIGNAL td_in_rate                           : STD_LOGIC;
   -- to tx_ctrl from quad pcs top
   -- generating revloopback_int output feeding tx_pipe
   SIGNAL td_in_revloopback                    : STD_LOGIC;
   -- to tx_ctrl from quad pcs top (no functionality change)
   -- path: rxpolarity (pld) -> tx_digi (tx_ctrl)->
   --       rx_pipe (muxing with polinv_rx) --> rx_digi
   SIGNAL td_in_rxpolarity                     : STD_LOGIC;
   -- to tx_ctrl from quad pcs top
   --    (just a simple wire in tx_ctrl so leaving it out of tx)
   -- generating txdetectrxloopback_int output feeding tx_pipe
   SIGNAL td_in_txdetectrxloopback             : STD_LOGIC;
   
   -- new output in CYCLONEIV - ww26.5 ===================================
   -- to rx_digi muxed with rxpolarity_int
   SIGNAL td_out_polinv_rx_int                 : STD_LOGIC;
   -- to rx_pipe and tx_pipe
   SIGNAL td_out_powerdown_int                 : STD_LOGIC_VECTOR(1 DOWNTO 0);
   -- to tx_pipe
   SIGNAL td_out_revloopback_int               : STD_LOGIC;
   -- to rx_digi (mux with polinv_rx_int)
   SIGNAL td_out_rxpolarity_int                : STD_LOGIC;
   -- to tx_pipe
   SIGNAL td_out_txdetectrxloopback_int        : STD_LOGIC;
   
   -- outputs
   SIGNAL td_out_empty_tx                      : STD_LOGIC;
   SIGNAL td_out_encoder_testbus               : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL td_out_full_tx                       : STD_LOGIC;
   SIGNAL td_out_pudr                          : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL td_out_rd_enable_sync                : STD_LOGIC;
   SIGNAL td_out_refclk_b                      : STD_LOGIC;
   SIGNAL td_out_tx_clk_out                    : STD_LOGIC;
   SIGNAL td_out_tx_ctl_tc                     : STD_LOGIC;
   SIGNAL td_out_tx_ctrl_testbus               : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL td_out_tx_data_tc                    : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL td_out_tx_pipe_clk                   : STD_LOGIC;
   SIGNAL td_out_tx_pipe_electidle             : STD_LOGIC;
   SIGNAL td_out_tx_pipe_soft_reset            : STD_LOGIC;
   SIGNAL td_out_txfifo_shared_sig_out         : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL td_out_txlp20b                       : STD_LOGIC_VECTOR(19 DOWNTO 0);
   
   -- new ports in ww47 --------------------------------------------------
   SIGNAL td_in_prbs_cid_en                    : STD_LOGIC;		--PRBS-CID dynamic signal
   SIGNAL td_in_tx_boundary_sel                : STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- new signal inputs for bundling
   SIGNAL td_in_tx_div2_sync_in_centrl         : STD_LOGIC;
   SIGNAL td_in_tx_div2_sync_in_quad_up        : STD_LOGIC;
   SIGNAL td_in_tx_div2_sync_in_quad_down      : STD_LOGIC;
   SIGNAL td_in_wr_enable_in_centrl            : STD_LOGIC;
   SIGNAL td_in_wr_enable_in_quad_up           : STD_LOGIC;
   SIGNAL td_in_wr_enable_in_quad_down         : STD_LOGIC;
   SIGNAL td_in_rd_enable_in_centrl            : STD_LOGIC;
   SIGNAL td_in_rd_enable_in_quad_up           : STD_LOGIC;
   SIGNAL td_in_rd_enable_in_quad_down         : STD_LOGIC;
   SIGNAL td_in_fifo_select_in_centrl          : STD_LOGIC;
   SIGNAL td_in_fifo_select_in_quad_up         : STD_LOGIC;
   SIGNAL td_in_fifo_select_in_quad_down       : STD_LOGIC;
   SIGNAL td_in_reset_pc_ptrs                  : STD_LOGIC;
   SIGNAL td_in_reset_pc_ptrs_in_centrl        : STD_LOGIC;
   SIGNAL td_in_reset_pc_ptrs_in_quad_up       : STD_LOGIC;
   SIGNAL td_in_reset_pc_ptrs_in_quad_down     : STD_LOGIC;
   
   SIGNAL td_in_tx_div2_sync_in_pipe_quad_up   : STD_LOGIC;
   SIGNAL td_in_tx_div2_sync_in_pipe_quad_down : STD_LOGIC;
   SIGNAL td_in_wr_enable_in_pipe_quad_up      : STD_LOGIC;
   SIGNAL td_in_wr_enable_in_pipe_quad_down    : STD_LOGIC;
   SIGNAL td_in_rd_enable_in_pipe_quad_up      : STD_LOGIC;
   SIGNAL td_in_rd_enable_in_pipe_quad_down    : STD_LOGIC;
   SIGNAL td_in_fifo_select_in_pipe_quad_up    : STD_LOGIC;
   SIGNAL td_in_fifo_select_in_pipe_quad_down  : STD_LOGIC;
   
   SIGNAL td_in_dis_pc_byte                    : STD_LOGIC;
   
   -- new outputs for bundling and auto speed
   SIGNAL td_out_tx_div2_sync_out_pipe         : STD_LOGIC;
   SIGNAL td_out_fifo_select_out_pipe          : STD_LOGIC;
   SIGNAL td_out_wr_enable_out_pipe            : STD_LOGIC;
   SIGNAL td_out_rd_enable_out_pipe            : STD_LOGIC;
   -- ww47 new ports end ---------------------------------------------------------
   
   -- new ports in ww12 ----------------------------------------------------------
   -- push through TX Phase Comp FIFO
   SIGNAL td_in_txswing                        : STD_LOGIC;
   SIGNAL td_in_pcs_txdeemph                   : STD_LOGIC;
   SIGNAL td_in_pcs_txmargin                   : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- RX PIPE interface signals
   SIGNAL td_in_eidleinfersel                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- push through TX Phase Comp FIFO
   SIGNAL td_out_phfifo_txswing                : STD_LOGIC;
   SIGNAL td_out_phfifo_txdeemph               : STD_LOGIC;
   SIGNAL td_out_phfifo_txmargin               : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- RX PIPE interface signals
   SIGNAL td_out_gray_eidleinfersel            : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- new outputs for bundling and auto speed
   -- splitting _out_pipe into _up and _down
   SIGNAL td_out_tx_div2_sync_out_pipe_up      : STD_LOGIC;
   SIGNAL td_out_fifo_select_out_pipe_up       : STD_LOGIC;
   SIGNAL td_out_wr_enable_out_pipe_up         : STD_LOGIC;
   SIGNAL td_out_rd_enable_out_pipe_up         : STD_LOGIC;
   SIGNAL td_out_tx_div2_sync_out_pipe_down    : STD_LOGIC;
   SIGNAL td_out_fifo_select_out_pipe_down     : STD_LOGIC;
   SIGNAL td_out_wr_enable_out_pipe_down       : STD_LOGIC;
   SIGNAL td_out_rd_enable_out_pipe_down       : STD_LOGIC;
   -- ww12 new ports end ---------------------------------------------------------
   
   --///////////////////////////////////////////////////////////////////////////////
   -- Internal Variables  --------------------------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   SIGNAL i                                    : INTEGER;
   SIGNAL j                                    : INTEGER;
   SIGNAL rxdet_fixclk_reg                     : STD_LOGIC;
   
   --///////////////////////////////////////////////////////////////////////////////
   -- Timing - INPUT BUFFERS  ----------------------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   SIGNAL rxrst_int_wire                       : STD_LOGIC;
   
   --ww47 new inputs
   SIGNAL hipdatain_in                         : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL hipdetectrxloop_in                   : STD_LOGIC;
   SIGNAL hipforceelecidle_in                  : STD_LOGIC;
   SIGNAL hippowerdn_in                        : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL hiptxdeemph_in                       : STD_LOGIC;
   SIGNAL hiptxmargin_in                       : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL iqpphfifoxnbytesel_in                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL iqpphfifoxnrdclk_in                  : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL iqpphfifoxnrdenable_in               : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL iqpphfifoxnwrenable_in               : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL phfifobyteserdisable_in              : STD_LOGIC;
   SIGNAL phfifoptrsreset_in                   : STD_LOGIC;
   SIGNAL phfifoxnbytesel_in                   : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxnptrsreset_in                 : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxnrdclk_in                     : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxnrdenable_in                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL phfifoxnwrenable_in                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL prbscidenable_in                     : STD_LOGIC;
	
   -- cycloneiv only
   SIGNAL phfifox4rdclk_in                      : STD_LOGIC;
   SIGNAL phfifox4wrenable_in                      : STD_LOGIC;
   SIGNAL phfifox4rdenable_in                      : STD_LOGIC;
   SIGNAL phfifox4bytesel_in                      : STD_LOGIC;
   
   -- ww12.08 inputs
   SIGNAL elecidleinfersel_in                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL hipelecidleinfersel_in               : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   --///////////////////////////////////////////////////////////////////////////////
   -- TIMING -- TCO/TSU/HOLD                                                      //
   --///////////////////////////////////////////////////////////////////////////////
   
   --///////////////////////////////////////////////////////////////////////////////
   -- dprio outputs
   --///////////////////////////////////////////////////////////////////////////////
   
   SIGNAL dprioin_in                           : STD_LOGIC_VECTOR(149 DOWNTO 0);
        
   -- PCS - disabled with mpcs_dpriodisable - enable case by case
   SIGNAL mpcs_dpriodisable                    : STD_LOGIC;
   -- X-HDL generated signals

   SIGNAL xhdl0 : STD_LOGIC_VECTOR(1 DOWNTO 0);
BEGIN
          
      ------------------------
      --  Wire Delay Block --
      ------------------------
      WireDelay : BLOCK
      BEGIN
       bits_phfifoxnbytesel : FOR i in phfifoxnbytesel'RANGE GENERATE
           VitalWireDelay (phfifoxnbytesel_ipd(i),phfifoxnbytesel(i), tipd_phfifoxnbytesel(i));
       END GENERATE;
       bits_dispval : FOR i in dispval'RANGE GENERATE
           VitalWireDelay (dispval_ipd(i),dispval(i), tipd_dispval(i));
       END GENERATE;
           VitalWireDelay (phfifoxnbottomwrenable_ipd,phfifoxnbottomwrenable, tipd_phfifoxnbottomwrenable);
           VitalWireDelay (phfifoxntopwrenable_ipd,phfifoxntopwrenable, tipd_phfifoxntopwrenable);
           VitalWireDelay (phfifoptrsreset_ipd,phfifoptrsreset, tipd_phfifoptrsreset);
       bits_phfifoxnptrsreset : FOR i in phfifoxnptrsreset'RANGE GENERATE
           VitalWireDelay (phfifoxnptrsreset_ipd(i),phfifoxnptrsreset(i), tipd_phfifoxnptrsreset(i));
       END GENERATE;
       bits_forcedisp : FOR i in forcedisp'RANGE GENERATE
           VitalWireDelay (forcedisp_ipd(i),forcedisp(i), tipd_forcedisp(i));
       END GENERATE;
       bits_hiptxmargin : FOR i in hiptxmargin'RANGE GENERATE
           VitalWireDelay (hiptxmargin_ipd(i),hiptxmargin(i), tipd_hiptxmargin(i));
       END GENERATE;
       bits_iqpphfifoxnwrenable : FOR i in iqpphfifoxnwrenable'RANGE GENERATE
           VitalWireDelay (iqpphfifoxnwrenable_ipd(i),iqpphfifoxnwrenable(i), tipd_iqpphfifoxnwrenable(i));
       END GENERATE;
           VitalWireDelay (phfiforddisable_ipd,phfiforddisable, tipd_phfiforddisable);
       bits_phfifoxnrdenable : FOR i in phfifoxnrdenable'RANGE GENERATE
           VitalWireDelay (phfifoxnrdenable_ipd(i),phfifoxnrdenable(i), tipd_phfifoxnrdenable(i));
       END GENERATE;
       bits_powerdn : FOR i in powerdn'RANGE GENERATE
           VitalWireDelay (powerdn_ipd(i),powerdn(i), tipd_powerdn(i));
       END GENERATE;
           VitalWireDelay (rateswitchisdone_ipd,rateswitchisdone, tipd_rateswitchisdone);
           VitalWireDelay (phfifoxntopbytesel_ipd,phfifoxntopbytesel, tipd_phfifoxntopbytesel);
       bits_ctrlenable : FOR i in ctrlenable'RANGE GENERATE
           VitalWireDelay (ctrlenable_ipd(i),ctrlenable(i), tipd_ctrlenable(i));
       END GENERATE;
           VitalWireDelay (phfifoxntoprdclk_ipd,phfifoxntoprdclk, tipd_phfifoxntoprdclk);
           VitalWireDelay (hiptxdeemph_ipd,hiptxdeemph, tipd_hiptxdeemph);
           VitalWireDelay (freezptr_ipd,freezptr, tipd_freezptr);
           VitalWireDelay (refclk_ipd,refclk, tipd_refclk);
           VitalWireDelay (phfifox4bytesel_ipd,phfifox4bytesel, tipd_phfifox4bytesel);
           VitalWireDelay (rateswitchxndone_ipd,rateswitchxndone, tipd_rateswitchxndone);
           VitalWireDelay (forcedispcompliance_ipd,forcedispcompliance, tipd_forcedispcompliance);
       bits_datainfull : FOR i in datainfull'RANGE GENERATE
           VitalWireDelay (datainfull_ipd(i),datainfull(i), tipd_datainfull(i));
       END GENERATE;
           VitalWireDelay (phfifox4rdclk_ipd,phfifox4rdclk, tipd_phfifox4rdclk);
           VitalWireDelay (phfiforeset_ipd,phfiforeset, tipd_phfiforeset);
       bits_dprioin : FOR i in dprioin'RANGE GENERATE
           VitalWireDelay (dprioin_ipd(i),dprioin(i), tipd_dprioin(i));
       END GENERATE;
           VitalWireDelay (coreclk_ipd,coreclk, tipd_coreclk);
           VitalWireDelay (pipestatetransdone_ipd,pipestatetransdone, tipd_pipestatetransdone);
           VitalWireDelay (rateswitch_ipd,rateswitch, tipd_rateswitch);
           VitalWireDelay (hipforceelecidle_ipd,hipforceelecidle, tipd_hipforceelecidle);
           VitalWireDelay (phfifox4rdenable_ipd,phfifox4rdenable, tipd_phfifox4rdenable);
           VitalWireDelay (phfifowrenable_ipd,phfifowrenable, tipd_phfifowrenable);
       bits_datain : FOR i in datain'RANGE GENERATE
           VitalWireDelay (datain_ipd(i),datain(i), tipd_datain(i));
       END GENERATE;
           VitalWireDelay (enrevparallellpbk_ipd,enrevparallellpbk, tipd_enrevparallellpbk);
           VitalWireDelay (forceelecidle_ipd,forceelecidle, tipd_forceelecidle);
       bits_phfifoxnrdclk : FOR i in phfifoxnrdclk'RANGE GENERATE
           VitalWireDelay (phfifoxnrdclk_ipd(i),phfifoxnrdclk(i), tipd_phfifoxnrdclk(i));
       END GENERATE;
           VitalWireDelay (pipetxswing_ipd,pipetxswing, tipd_pipetxswing);
       bits_pipetxmargin : FOR i in pipetxmargin'RANGE GENERATE
           VitalWireDelay (pipetxmargin_ipd(i),pipetxmargin(i), tipd_pipetxmargin(i));
       END GENERATE;
           VitalWireDelay (phfifox4wrenable_ipd,phfifox4wrenable, tipd_phfifox4wrenable);
           VitalWireDelay (pipetxdeemph_ipd,pipetxdeemph, tipd_pipetxdeemph);
       bits_bitslipboundaryselect : FOR i in bitslipboundaryselect'RANGE GENERATE
           VitalWireDelay (bitslipboundaryselect_ipd(i),bitslipboundaryselect(i), tipd_bitslipboundaryselect(i));
       END GENERATE;
           VitalWireDelay (phfifobyteserdisable_ipd,phfifobyteserdisable, tipd_phfifobyteserdisable);
           VitalWireDelay (dpriodisable_ipd,dpriodisable, tipd_dpriodisable);
           VitalWireDelay (phfifoxnbottomrdclk_ipd,phfifoxnbottomrdclk, tipd_phfifoxnbottomrdclk);
           VitalWireDelay (phfifoxnbottomrdenable_ipd,phfifoxnbottomrdenable, tipd_phfifoxnbottomrdenable);
       bits_hippowerdn : FOR i in hippowerdn'RANGE GENERATE
           VitalWireDelay (hippowerdn_ipd(i),hippowerdn(i), tipd_hippowerdn(i));
       END GENERATE;
           VitalWireDelay (xgmctrl_ipd,xgmctrl, tipd_xgmctrl);
           VitalWireDelay (invpol_ipd,invpol, tipd_invpol);
           VitalWireDelay (hipdetectrxloop_ipd,hipdetectrxloop, tipd_hipdetectrxloop);
           VitalWireDelay (localrefclk_ipd,localrefclk, tipd_localrefclk);
       bits_revparallelfdbk : FOR i in revparallelfdbk'RANGE GENERATE
           VitalWireDelay (revparallelfdbk_ipd(i),revparallelfdbk(i), tipd_revparallelfdbk(i));
       END GENERATE;
       bits_iqpphfifoxnrdenable : FOR i in iqpphfifoxnrdenable'RANGE GENERATE
           VitalWireDelay (iqpphfifoxnrdenable_ipd(i),iqpphfifoxnrdenable(i), tipd_iqpphfifoxnrdenable(i));
       END GENERATE;
           VitalWireDelay (prbscidenable_ipd,prbscidenable, tipd_prbscidenable);
           VitalWireDelay (digitalreset_ipd,digitalreset, tipd_digitalreset);
       bits_iqpphfifoxnbytesel : FOR i in iqpphfifoxnbytesel'RANGE GENERATE
           VitalWireDelay (iqpphfifoxnbytesel_ipd(i),iqpphfifoxnbytesel(i), tipd_iqpphfifoxnbytesel(i));
       END GENERATE;
       bits_iqpphfifoxnrdclk : FOR i in iqpphfifoxnrdclk'RANGE GENERATE
           VitalWireDelay (iqpphfifoxnrdclk_ipd(i),iqpphfifoxnrdclk(i), tipd_iqpphfifoxnrdclk(i));
       END GENERATE;
       bits_phfifoxnwrenable : FOR i in phfifoxnwrenable'RANGE GENERATE
           VitalWireDelay (phfifoxnwrenable_ipd(i),phfifoxnwrenable(i), tipd_phfifoxnwrenable(i));
       END GENERATE;
           VitalWireDelay (quadreset_ipd,quadreset, tipd_quadreset);
       bits_xgmdatain : FOR i in xgmdatain'RANGE GENERATE
           VitalWireDelay (xgmdatain_ipd(i),xgmdatain(i), tipd_xgmdatain(i));
       END GENERATE;
           VitalWireDelay (phfifoxnbottombytesel_ipd,phfifoxnbottombytesel, tipd_phfifoxnbottombytesel);
       bits_hipdatain : FOR i in hipdatain'RANGE GENERATE
           VitalWireDelay (hipdatain_ipd(i),hipdatain(i), tipd_hipdatain(i));
       END GENERATE;
           VitalWireDelay (phfifoxntoprdenable_ipd,phfifoxntoprdenable, tipd_phfifoxntoprdenable);
           VitalWireDelay (detectrxloop_ipd,detectrxloop, tipd_detectrxloop);
      END BLOCK;
       

    VITAL: PROCESS (coreclk_ipd, datain_ipd, ctrlenable_ipd, detectrxloop_ipd, dispval_ipd, forcedisp_ipd, forcedispcompliance_ipd, forceelecidle_ipd, phfifowrenable_ipd, powerdn_ipd, pipetxdeemph_ipd, pipetxswing_ipd, pipetxmargin_ipd)

    variable Tviol_coreclk_ctrlenable : std_ulogic := '0';
    variable TimingData_coreclk_ctrlenable : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_datain : std_ulogic := '0';
    variable TimingData_coreclk_datain : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_detectrxloop : std_ulogic := '0';
    variable TimingData_coreclk_detectrxloop : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_dispval : std_ulogic := '0';
    variable TimingData_coreclk_dispval : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_forcedisp : std_ulogic := '0';
    variable TimingData_coreclk_forcedisp : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_forcedispcompliance : std_ulogic := '0';
    variable TimingData_coreclk_forcedispcompliance : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_forceelecidle : std_ulogic := '0';
    variable TimingData_coreclk_forceelecidle : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_phfifowrenable : std_ulogic := '0';
    variable TimingData_coreclk_phfifowrenable : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_powerdn : std_ulogic := '0';
    variable TimingData_coreclk_powerdn : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_pipetxdeemph : std_ulogic := '0';
    variable TimingData_coreclk_pipetxdeemph : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_pipetxmargin : std_ulogic := '0';
    variable TimingData_coreclk_pipetxmargin : VitalTimingDataType := VitalTimingDataInit;

    variable Tviol_coreclk_pipetxswing : std_ulogic := '0';
    variable TimingData_coreclk_pipetxswing : VitalTimingDataType := VitalTimingDataInit;

    variable phfifooverflow_VitalGlitchData : VitalGlitchDataType;
    variable phfifounderflow_VitalGlitchData : VitalGlitchDataType;

    BEGIN

        ------------------------
        --  Timing Check Section
        ------------------------
        IF (TimingChecksOn) THEN
            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_ctrlenable,
                        TimingData      => TimingData_coreclk_ctrlenable,
                        TestSignal      => ctrlenable_ipd,
                        TestSignalName  => "CTRLENABLE",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_ctrlenable_coreclk_noedge_posedge,
                        SetupLow        => tsetup_ctrlenable_coreclk_noedge_posedge,
                        HoldHigh        => thold_ctrlenable_coreclk_noedge_posedge,
                        HoldLow         => thold_ctrlenable_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );

            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_datain,
                        TimingData      => TimingData_coreclk_datain,
                        TestSignal      => datain_ipd,
                        TestSignalName  => "DATAIN",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_datain_coreclk_noedge_posedge,
                        SetupLow        => tsetup_datain_coreclk_noedge_posedge,
                        HoldHigh        => thold_datain_coreclk_noedge_posedge,
                        HoldLow         => thold_datain_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );

            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_detectrxloop,
                        TimingData      => TimingData_coreclk_detectrxloop,
                        TestSignal      => detectrxloop_ipd,
                        TestSignalName  => "DETECTRXLOOP",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_detectrxloop_coreclk_noedge_posedge,
                        SetupLow        => tsetup_detectrxloop_coreclk_noedge_posedge,
                        HoldHigh        => thold_detectrxloop_coreclk_noedge_posedge,
                        HoldLow         => thold_detectrxloop_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );

            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_dispval,
                        TimingData      => TimingData_coreclk_dispval,
                        TestSignal      => dispval_ipd,
                        TestSignalName  => "DISPVAL",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_dispval_coreclk_noedge_posedge,
                        SetupLow        => tsetup_dispval_coreclk_noedge_posedge,
                        HoldHigh        => thold_dispval_coreclk_noedge_posedge,
                        HoldLow         => thold_dispval_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );

            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_forcedisp,
                        TimingData      => TimingData_coreclk_forcedisp,
                        TestSignal      => forcedisp_ipd,
                        TestSignalName  => "FORCEDISP",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_forcedisp_coreclk_noedge_posedge,
                        SetupLow        => tsetup_forcedisp_coreclk_noedge_posedge,
                        HoldHigh        => thold_forcedisp_coreclk_noedge_posedge,
                        HoldLow         => thold_forcedisp_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );


            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_forceelecidle,
                        TimingData      => TimingData_coreclk_forceelecidle,
                        TestSignal      => forceelecidle_ipd,
                        TestSignalName  => "FORCEELECIDLE",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_forceelecidle_coreclk_noedge_posedge,
                        SetupLow        => tsetup_forceelecidle_coreclk_noedge_posedge,
                        HoldHigh        => thold_forceelecidle_coreclk_noedge_posedge,
                        HoldLow         => thold_forceelecidle_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );

            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_phfifowrenable,
                        TimingData      => TimingData_coreclk_phfifowrenable,
                        TestSignal      => phfifowrenable_ipd,
                        TestSignalName  => "PHFIFOWRENABLE",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_phfifowrenable_coreclk_noedge_posedge,
                        SetupLow        => tsetup_phfifowrenable_coreclk_noedge_posedge,
                        HoldHigh        => thold_phfifowrenable_coreclk_noedge_posedge,
                        HoldLow         => thold_phfifowrenable_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );

            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_powerdn,
                        TimingData      => TimingData_coreclk_powerdn,
                        TestSignal      => powerdn_ipd,
                        TestSignalName  => "POWERDN",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_powerdn_coreclk_noedge_posedge,
                        SetupLow        => tsetup_powerdn_coreclk_noedge_posedge,
                        HoldHigh        => thold_powerdn_coreclk_noedge_posedge,
                        HoldLow         => thold_powerdn_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );



            VitalSetupHoldCheck (
                        Violation       => Tviol_coreclk_pipetxswing,
                        TimingData      => TimingData_coreclk_pipetxswing,
                        TestSignal      => pipetxswing_ipd,
                        TestSignalName  => "PIPETXSWING",
                        RefSignal       => coreclk_ipd,
                        RefSignalName   => "CORECLK",
                        SetupHigh       => tsetup_pipetxswing_coreclk_noedge_posedge,
                        SetupLow        => tsetup_pipetxswing_coreclk_noedge_posedge,
                        HoldHigh        => thold_pipetxswing_coreclk_noedge_posedge,
                        HoldLow         => thold_pipetxswing_coreclk_noedge_posedge,
                        RefTransition   => '/',
                        HeaderMsg       => InstancePath & "/CYCLONEIV_HSSI_TX_PCS",
                        XOn             => XOnChecks,
                        MsgOn           => MsgOnChecks
            );

        END IF;

        ----------------------
        --  Path Delay Section
        ----------------------

        VitalPathDelay01 (
            OutSignal => phfifooverflow,
            OutSignalName => "PHFIFOOVERFLOW",
            OutTemp => td_out_full_tx,
            Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_phfifooverflow_posedge, TRUE)),
            GlitchData => phfifooverflow_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOn,
            MsgOn => MsgOn );

        VitalPathDelay01 (
            OutSignal => phfifounderflow,
            OutSignalName => "PHFIFOUNDERFLOW",
            OutTemp => td_out_empty_tx,
            Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_phfifounderflow_posedge, TRUE)),
            GlitchData => phfifounderflow_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOn,
            MsgOn => MsgOn );

    END PROCESS;

      ----------------------------------------
      --  Cyclone IV GX_modify due to width change
      ----------------------------------------
      ctrlenable_ipd (3 DOWNTO 2)  <= "00";
      datainfull_siv(43 DOWNTO 33) <= (others => '0');
      datainfull_siv(10 DOWNTO 0) <= datainfull_ipd(10 DOWNTO 0);
      datainfull_siv(32 DOWNTO 22) <= datainfull_ipd(21 DOWNTO 11);
      datainfull_siv(21 DOWNTO 11) <= (others => '0');
      dispval_ipd (3 DOWNTO 2)     <= "00";
      forcedisp_ipd (3 DOWNTO 2)   <= "00"; 
   
      ------------------------
      --  Functionality Section --
      ------------------------
   -- cycloneiv only
   phfifox4rdclk_in <= '1' WHEN (phfifox4rdclk = '1') ELSE '0';
   phfifox4wrenable_in <= '1' WHEN (phfifox4wrenable = '1') ELSE '0';
   phfifox4rdenable_in <= '1' WHEN (phfifox4rdenable = '1') ELSE '0';
   phfifox4bytesel_in <= '1' WHEN (phfifox4bytesel = '1') ELSE '0';   
   
   hipdatain_in <= hipdatain;
   hipdetectrxloop_in <= hipdetectrxloop;
   hipforceelecidle_in <= hipforceelecidle;
   hippowerdn_in <= hippowerdn;
   hiptxdeemph_in <= hiptxdeemph;
   hiptxmargin_in <= hiptxmargin;
   iqpphfifoxnbytesel_in <= iqpphfifoxnbytesel;
   iqpphfifoxnrdclk_in <= iqpphfifoxnrdclk;
   iqpphfifoxnrdenable_in <= iqpphfifoxnrdenable;
   iqpphfifoxnwrenable_in <= iqpphfifoxnwrenable;
   phfifobyteserdisable_in <= phfifobyteserdisable;
   phfifoptrsreset_in <= phfifoptrsreset;
   phfifoxnbytesel_in <= phfifoxnbytesel;
   phfifoxnptrsreset_in <= phfifoxnptrsreset;
   phfifoxnrdclk_in <= phfifoxnrdclk;
   phfifoxnrdenable_in <= phfifoxnrdenable;
   phfifoxnwrenable_in <= phfifoxnwrenable;
   prbscidenable_in <= prbscidenable;
   dprioin_in <= dprioin;
   
    PROCESS
        VARIABLE i : INTEGER := 0;
        VARIABLE txt : LINE;
        
        PROCEDURE compute_rprbs_sel (
            pma_doublewidth         : IN std_logic;   
            pma_width               : IN std_logic;   
            test_mode               : IN string; result : OUT std_logic_vector) IS
        
            VARIABLE res                    :  std_logic_vector(2 DOWNTO 0);   
            VARIABLE temp_xhdl20 : STD_LOGIC_VECTOR(1 DOWNTO 0);
        BEGIN
            temp_xhdl20 := pma_doublewidth & pma_width;
            CASE temp_xhdl20 IS
               WHEN "00" =>                                                                                          
                           IF ((test_mode = "prbs_8") OR (test_mode = "prbs8")) THEN       
                               res := "000";                                                                         
                           ELSIF (test_mode = "prbs7") THEN
                               res := "010";                     
                           ELSIF (test_mode = "prbs23") THEN
                               res := "100";
                           ELSIF (test_mode = "high frequency") THEN
                               res := "001";
                           ELSE                        
                               res := "000";     -- default
                           END IF;                                                                                   
               WHEN "01" =>                                                                                          
                           IF ((test_mode = "prbs_10") OR (test_mode = "prbs10")) THEN    
                               res := "000";                                                                         
                           ELSIF (test_mode = "high frequency") THEN
                               res := "001";
                           ELSIF (test_mode = "low frequency") THEN
                               res := "010";
                           ELSIF (test_mode = "mixed frequency") THEN
                               res := "011";
                           ELSE
                               res := "000";     -- default
                           END IF;                                                                                   
               WHEN "10" =>                                                                                          
                           IF ((test_mode = "prbs_7") OR (test_mode = "prbs7")) THEN       
                               res := "000";                                                                         
                           ELSIF (test_mode = "PRBS_23" OR test_mode = "prbs_23" OR test_mode = "prbs23")  THEN
                               res := "001";
                           ELSIF (test_mode = "high frequency")  THEN
                               res := "010";
                           ELSE
                               res := "000";     -- default
                           END IF;                                                                                   
               WHEN "11" =>                                                                                          
                           IF ((test_mode = "prbs_7") OR (test_mode = "prbs7")) THEN       
                               res := "000";                                                                         
                           ELSIF ((test_mode = "PRBS_23") OR (test_mode = "prbs_23") OR (test_mode = "prbs23")) THEN
                               res := "001";                     
                           ELSIF (test_mode = "high frequency") THEN
                               res := "010";
                           ELSIF (test_mode = "low frequency") THEN
                               res := "011";
                           ELSIF (test_mode = "mixed frequency") THEN
                               res := "100";
                           ELSE
                               res := "000";     -- default
                           END IF;                                                                                   
                WHEN OTHERS  =>
                            --WRITE(txt,string'("Invalid pma_doublewidth and pma_width selection"));   
                            --WRITELINE (OUTPUT,txt);
                
            END CASE;
            result := res;    
        END compute_rprbs_sel;
                                                                                         
        VARIABLE init_rprbs_sel_val : std_logic_vector(2 DOWNTO 0);
        VARIABLE init_rpma_doublewidth_tx_var,init_rpmadwidth_tx_var : STD_LOGIC;
      
   BEGIN
      init_r8b10b_enc_ibm_en <= mux_select((enc_8b_10b_compatibility_mode = ("true")), '1', '0');
      init_rbist_sel <= mux_select((self_test_mode = ("incremental")), "00", mux_select((self_test_mode = ("cjpat")), "01", mux_select((self_test_mode = ("crpat")), "10", "00")));
      init_rbisten_tx <= mux_select(((enable_self_test_mode = ("true")) AND (self_test_mode = ("incremental") OR self_test_mode = ("cjpat") OR self_test_mode = ("cjpat"))), '1', '0');
      init_rcascaded_8b10b_en_tx <= mux_select((enc_8b_10b_mode = ("cascaded")), '1', '0');
      init_rcxpat_chnl_en <= mux_select((channel_number = 1), "01", mux_select((channel_number = 2), "10", mux_select((channel_number = 3), "11", "00")));
      init_rdwidth_tx <= mux_select((use_double_data_mode = ("true")), '1', '0');
      init_renbitrev_tx <= mux_select((enable_bit_reversal = ("true")), '1', '0');
      init_rendec_data_sel_tx <= mux_select((protocol_hint = ("xaui")), '0', '1');
      init_rendec_tx <= mux_select((enc_8b_10b_mode /= ("none")), '1', '0');
      init_renpolinv_tx <= mux_select((allow_polarity_inversion = ("true")), '1', '0');
      init_rensymswap_tx <= mux_select((alpha_tolower(enable_symbol_swap) = ("true")), '1', '0');
      init_rforce_disp <= mux_select((disparity_mode = ("new")), '1', '0');
      init_rforce_echar <= mux_select((force_echar = ("true")), '1', '0');
      init_rforce_kchar <= mux_select((force_kchar = ("true")), '1', '0');
      init_rfreerun_tx <= mux_select((reset_clock_output_during_digital_reset = ("false")), '1', '0');
      init_rge_xaui_tx <= mux_select((protocol_hint = ("gige") OR enable_idle_selection = ("true")), '1', '0');
      init_rib_force_disp <= mux_select((disparity_mode = ("legacy")), '1', '0');
      init_rindv_tx <= mux_select((channel_bonding = ("x4") OR channel_bonding = ("x8") OR protocol_hint = ("xaui")), '0', '1');
      init_rphfifo_master_sel_tx <= mux_select((channel_bonding = ("x8")), '0', '1');
      init_rphfifopldentx <= '1';
      init_rphfifoursttx <= '1';
      
            IF (alpha_tolower(use_serializer_double_data_mode) = "true") THEN
                init_rpma_doublewidth_tx <= '1';
                init_rpma_doublewidth_tx_var := '1';
            ELSE
                init_rpma_doublewidth_tx <= '0';
                init_rpma_doublewidth_tx_var := '0';
            END IF;
            
            IF ((enc_8b_10b_mode = "none") AND ((channel_width = 8) OR (channel_width = 16) OR (channel_width = 32))) THEN
                init_rpmadwidth_tx <= '0';
                init_rpmadwidth_tx_var := '0';
            ELSE
                init_rpmadwidth_tx <= '1';
                init_rpmadwidth_tx_var := '1';
            END IF;
            
            compute_rprbs_sel(init_rpma_doublewidth_tx_var,init_rpmadwidth_tx_var,self_test_mode,init_rprbs_sel_val);
            init_rprbs_sel <= init_rprbs_sel_val;
      
      init_rprbsen_tx <= mux_select(((enable_self_test_mode = ("true")) AND (self_test_mode /= ("incremental")) AND (self_test_mode /= ("cjpat")) AND (self_test_mode /= ("crpat"))), '1', '0');
      init_rrev_loopbk <= mux_select((enable_reverse_parallel_loopback = ("true")), '1', '0');
      init_rtx_pipe_enable <= mux_select((protocol_hint = ("pcie") OR protocol_hint = ("pcie2")), '1', '0');
      init_rtxfifo_dis <= mux_select((enable_phfifo_bypass = ("true")), '1', '0');
      init_rtxfifo_lowlatency_en <= mux_select((disable_ph_low_latency_mode = ("false")), '1', '0');
      init_rtxpcsbypass_en <= mux_select((datapath_low_latency_mode = ("true")), '1', '0');
      init_rtxrdclksel <= mux_select((refclk_select = ("central")), '1', '0');
      init_rtxswing_sel_ena <= mux_select((pipe_voltage_swing_control = ("true")), '1', '0');
      init_rtxwrclksel <= mux_select((wr_clk_mux_select = ("int_clk") OR wr_clk_mux_select = ("int clk") OR wr_clk_mux_select = ("internal clock")), '1', '0');
      init_rclkcmpinsertpad <= '1';
      init_rrdwidth_rx <= '1';
      init_rrx_detect_bypass <= '1';
      init_rrx_pipe_enable <= '1';
      init_rtx_elec_idle_delay <= "011";
      init_is_lane0 <= mux_select((channel_number = 0), '1', '0');
      init_scan_mode <= '0';
      init_rauto_speed_ena <= mux_select((alpha_tolower(pipe_auto_speed_nego_enable) = ("true")), '1', '0');
      init_rfreq_sel <= mux_select((pipe_freq_scale_mode = ("data width")), '0', '1');
      init_rtxpcsclkpwdn <= '0';
      init_rcid_pattern_tx <= mux_select((prbs_cid_pattern = ("true")), '1', '0');
      init_rcid_len_tx <= int2bin(prbs_cid_pattern_length, 8);
      IF ((channel_bonding /= "x8") OR (cycloneiv_tx_pcs_mph_fifo_xn_mapping(ph_fifo_xn_select,ph_fifo_xn_mapping0,ph_fifo_xn_mapping1,ph_fifo_xn_mapping2) = "central")) THEN
          init_rmaster_tx <= '1';
      ELSE
          init_rmaster_tx <= '0';
      END IF;
      -- flip
      IF (cycloneiv_tx_pcs_mph_fifo_xn_mapping(ph_fifo_xn_select,ph_fifo_xn_mapping0,ph_fifo_xn_mapping1,ph_fifo_xn_mapping2) = "down") THEN
          init_rmaster_up_tx <= '1';  
      ELSE
          init_rmaster_up_tx <= '0';
      END IF;
      init_rself_sw_en_tx <= mux_select((alpha_tolower(auto_spd_self_switch_enable) = ("true")), '1', '0');
      init_rpipeline_bypass_tx <= mux_select((alpha_tolower(iqp_bypass) = ("true")), '1', '0');
      init_rphfifo_regmode_tx <= mux_select((ph_fifo_reg_mode = ("true")), '1', '0');
      init_rtxbitslip_en <= mux_select((bitslip_enable = ("true")), '1', '0');
      init_rhip_ena <= mux_select((hip_enable = ("true")), '1', '0');
      WAIT;
   END PROCESS;
   
-- new DPRIO model begin --
-- ---------------------------------------------------------------------------
-- Set DPRIO CRAM input from dprioin  
-- ---------------------------------------------------------------------------
-- Existing
dprioin_is_lane0              <= init_is_lane0;
dprioin_rauto_speed_ena       <= dprioin_in(rauto_speed_ena_TX_IDX);
dprioin_rclkcmpinsertpad      <= init_rclkcmpinsertpad;  		-- rx only <=<=<=<=<=<=<=<=<= pipe <=<=<=<=<=<=<=<=<=<=<=    
dprioin_rendec_data_sel_tx    <= init_rendec_data_sel_tx; 		-- disable reconfiguration for quad-level crams
dprioin_rfreq_sel             <= dprioin_in(rfreq_sel_TX_IDX);
dprioin_rhip_ena              <= dprioin_in(rhip_ena_TX_IDX);
dprioin_rmaster_tx            <= init_rmaster_tx;
dprioin_rmaster_up_tx         <= init_rmaster_up_tx;
dprioin_rindv_tx              <= init_rindv_tx;       			-- disable reconfiguration for quad-level crams
dprioin_rphfifo_master_sel_tx <= init_rphfifo_master_sel_tx;    -- disable reconfiguration for quad-level crams
dprioin_rpma_doublewidth_tx   <= dprioin_in(rpma_doublewidth_tx_TX_IDX);    --dprioen
dprioin_rpmadwidth_tx         <= dprioin_in(rpmadwidth_tx_TX_IDX);          --dprioen
dprioin_rrdwidth_rx           <= init_rrdwidth_rx;              -- rx only
dprioin_rrx_detect_bypass     <= init_rrx_detect_bypass;        -- rx only
dprioin_rrx_pipe_enable       <= init_rrx_pipe_enable;          -- rx only
dprioin_rtx_cmu_sel           <= dprioin_in(rtx_cmu_sel_TX_IDX);
dprioin_scan_mode             <= init_scan_mode;

-- PCS Per Channel TX Control Register 1 for Channel 0
dprioin_rforce_disp	<= dprioin(rforce_disp_TXPCS_IDX_0);
dprioin_rrev_loopbk	<= dprioin(rrev_loopbk_TXPCS_IDX_0);
dprioin_rtxrdclksel	<= dprioin(rtxrdclksel_TXPCS_IDX_0);
dprioin_rtxwrclksel	<= dprioin(rtxwrclksel_TXPCS_IDX_0);
dprioin_rfreerun_tx	<= dprioin(rfreerun_tx_TXPCS_IDX_0);
dprioin_rtxurstpcs	<= dprioin(rtxurstpcs_TXPCS_IDX_0);
dprioin_reserved_0_TB1	<= dprioin(reserved_0_TB1_TXPCS_IDX_0);
dprioin_rphfifoursttx	<= dprioin(rphfifoursttx_TXPCS_IDX_0);
dprioin_rphfifopldentx	<= dprioin(rphfifopldentx_TXPCS_IDX_0);
dprioin_rge_xaui_tx	<= dprioin(rge_xaui_tx_TXPCS_IDX_0);
dprioin_rdwidth_tx	<= dprioin(rdwidth_tx_TXPCS_IDX_0);
dprioin_rtxfifo_lowlatency_en	<= dprioin(rtxfifo_lowlatency_en_TXPCS_IDX_0);
dprioin_rib_force_disp	<= dprioin(rib_force_disp_TXPCS_IDX_0);
dprioin_rtxfifo_dis	<= dprioin(rtxfifo_dis_TXPCS_IDX_0);
dprioin_rforce_echar	<= dprioin(rforce_echar_TXPCS_IDX_0);
dprioin_rforce_kchar	<= dprioin(rforce_kchar_TXPCS_IDX_0);

-- PCS Per Channel TX Control Register 2 for Channel 0
dprioin_rtxpcsbypass_en	<= dprioin(rtxpcsbypass_en_TXPCS_IDX_0);
dprioin_rcxpat_chnl_en	<= dprioin(rcxpat_chnl_en_TXPCS_IDX_1 DOWNTO rcxpat_chnl_en_TXPCS_IDX_0);
dprioin_rbist_sel	<= dprioin(rbist_sel_TXPCS_IDX_1 DOWNTO rbist_sel_TXPCS_IDX_0);
dprioin_rbisten_tx	<= dprioin(rbisten_tx_TXPCS_IDX_0);
dprioin_rprbs_sel	<= dprioin(rprbs_sel_TXPCS_IDX_2 DOWNTO rprbs_sel_TXPCS_IDX_0);
dprioin_rprbsen_tx	<= dprioin(rprbsen_tx_TXPCS_IDX_0);
dprioin_renbitrev_tx	<= dprioin(renbitrev_tx_TXPCS_IDX_0);
dprioin_renpolinv_tx	<= dprioin(renpolinv_tx_TXPCS_IDX_0);
dprioin_rensymswap_tx	<= dprioin(rensymswap_tx_TXPCS_IDX_0);
dprioin_rcascaded_8b10b_en_tx	<= dprioin(rcascaded_8b10b_en_tx_TXPCS_IDX_0);
dprioin_r8b10b_enc_ibm_en	<= dprioin(r8b10b_enc_ibm_en_TXPCS_IDX_0);
dprioin_rendec_tx	<= dprioin(rendec_tx_TXPCS_IDX_0);

-- PCS Per Channel TX Control Register 3 for Channel 0
dprioin_reserved_0_TB3	<= dprioin(reserved_0_TB3_TXPCS_IDX_0);
dprioin_rcid_len_tx	<= dprioin(rcid_len_tx_TXPCS_IDX_7 DOWNTO rcid_len_tx_TXPCS_IDX_0);
dprioin_rcid_pattern_tx	<= dprioin(rcid_pattern_tx_TXPCS_IDX_0);
dprioin_rtxpcsclkpwdn	<= dprioin(rtxpcsclkpwdn_TXPCS_IDX_0);
dprioin_rtxswing_sel_ena	<= dprioin(rtxswing_sel_ena_TXPCS_IDX_0);
dprioin_rtx_elec_idle_delay	<= dprioin(rtx_elec_idle_delay_TXPCS_IDX_2 DOWNTO rtx_elec_idle_delay_TXPCS_IDX_0);
dprioin_rtx_pipe_enable	<= dprioin(rtx_pipe_enable_TXPCS_IDX_0);

-- PCS Per Channel TX Control Register 4 for Channel 0
dprioin_reserved_0_TB4	<= dprioin(reserved_0_TB4_TXPCS_IDX_11 DOWNTO reserved_0_TB4_TXPCS_IDX_0);
dprioin_rtxbitslip_en	<= dprioin(rtxbitslip_en_TXPCS_IDX_0);
dprioin_rphfifo_regmode_tx	<= dprioin(rphfifo_regmode_tx_TXPCS_IDX_0);
dprioin_rpipeline_bypass_tx	<= dprioin(rpipeline_bypass_tx_TXPCS_IDX_0);
dprioin_rself_sw_en_tx	<= dprioin(rself_sw_en_tx_TXPCS_IDX_0);

-- ---------------------------------------------------------------------------
-- Set DPRIO output from initial CRAM
-- ---------------------------------------------------------------------------
-- Existing
dprioout(rauto_speed_ena_TX_IDX)       <= init_rauto_speed_ena;           
dprioout(rfreq_sel_TX_IDX)             <= init_rfreq_sel;           
dprioout(rhip_ena_TX_IDX)              <= init_rhip_ena;
dprioout(rpma_doublewidth_tx_TX_IDX)   <= init_rpma_doublewidth_tx;   
dprioout(rpmadwidth_tx_TX_IDX)         <= init_rpmadwidth_tx;         
dprioout(rtx_cmu_sel_TX_IDX)           <= init_rtx_cmu_sel;           

-- PCS Per Channel TX Control Register 1 for Channel 0
dprioout(rforce_disp_TXPCS_IDX_0) <= init_rforce_disp;
dprioout(rrev_loopbk_TXPCS_IDX_0) <= init_rrev_loopbk;
dprioout(rtxrdclksel_TXPCS_IDX_0) <= init_rtxrdclksel;
dprioout(rtxwrclksel_TXPCS_IDX_0) <= init_rtxwrclksel;
dprioout(rfreerun_tx_TXPCS_IDX_0) <= init_rfreerun_tx;
dprioout(rtxurstpcs_TXPCS_IDX_0) <= init_rtxurstpcs;
dprioout(reserved_0_TB1_TXPCS_IDX_0) <= init_reserved_0_TB1;
dprioout(rphfifoursttx_TXPCS_IDX_0) <= init_rphfifoursttx;
dprioout(rphfifopldentx_TXPCS_IDX_0) <= init_rphfifopldentx;
dprioout(rge_xaui_tx_TXPCS_IDX_0) <= init_rge_xaui_tx;
dprioout(rdwidth_tx_TXPCS_IDX_0) <= init_rdwidth_tx;
dprioout(rtxfifo_lowlatency_en_TXPCS_IDX_0) <= init_rtxfifo_lowlatency_en;
dprioout(rib_force_disp_TXPCS_IDX_0) <= init_rib_force_disp;
dprioout(rtxfifo_dis_TXPCS_IDX_0) <= init_rtxfifo_dis;
dprioout(rforce_echar_TXPCS_IDX_0) <= init_rforce_echar;
dprioout(rforce_kchar_TXPCS_IDX_0) <= init_rforce_kchar;

-- PCS Per Channel TX Control Register 2 for Channel 0
dprioout(rtxpcsbypass_en_TXPCS_IDX_0) <= init_rtxpcsbypass_en;
dprioout(rcxpat_chnl_en_TXPCS_IDX_1 DOWNTO rcxpat_chnl_en_TXPCS_IDX_0) <= init_rcxpat_chnl_en;
dprioout(rbist_sel_TXPCS_IDX_1 DOWNTO rbist_sel_TXPCS_IDX_0) <= init_rbist_sel;
dprioout(rbisten_tx_TXPCS_IDX_0) <= init_rbisten_tx;
dprioout(rprbs_sel_TXPCS_IDX_2 DOWNTO rprbs_sel_TXPCS_IDX_0) <= init_rprbs_sel;
dprioout(rprbsen_tx_TXPCS_IDX_0) <= init_rprbsen_tx;
dprioout(renbitrev_tx_TXPCS_IDX_0) <= init_renbitrev_tx;
dprioout(renpolinv_tx_TXPCS_IDX_0) <= init_renpolinv_tx;
dprioout(rensymswap_tx_TXPCS_IDX_0) <= init_rensymswap_tx;
dprioout(rcascaded_8b10b_en_tx_TXPCS_IDX_0) <= init_rcascaded_8b10b_en_tx;
dprioout(r8b10b_enc_ibm_en_TXPCS_IDX_0) <= init_r8b10b_enc_ibm_en;
dprioout(rendec_tx_TXPCS_IDX_0) <= init_rendec_tx;

-- PCS Per Channel TX Control Register 3 for Channel 0
dprioout(reserved_0_TB3_TXPCS_IDX_0) <= init_reserved_0_TB3;
dprioout(rcid_len_tx_TXPCS_IDX_7 DOWNTO rcid_len_tx_TXPCS_IDX_0) <= init_rcid_len_tx;
dprioout(rcid_pattern_tx_TXPCS_IDX_0) <= init_rcid_pattern_tx;
dprioout(rtxpcsclkpwdn_TXPCS_IDX_0) <= init_rtxpcsclkpwdn;
dprioout(rtxswing_sel_ena_TXPCS_IDX_0) <= init_rtxswing_sel_ena;
dprioout(rtx_elec_idle_delay_TXPCS_IDX_2 DOWNTO rtx_elec_idle_delay_TXPCS_IDX_0) <= init_rtx_elec_idle_delay;
dprioout(rtx_pipe_enable_TXPCS_IDX_0) <= init_rtx_pipe_enable;

-- PCS Per Channel TX Control Register 4 for Channel 0
dprioout(reserved_0_TB4_TXPCS_IDX_11 DOWNTO reserved_0_TB4_TXPCS_IDX_0) <= init_reserved_0_TB4;
dprioout(rtxbitslip_en_TXPCS_IDX_0) <= init_rtxbitslip_en;
dprioout(rphfifo_regmode_tx_TXPCS_IDX_0) <= init_rphfifo_regmode_tx;
dprioout(rpipeline_bypass_tx_TXPCS_IDX_0) <= init_rpipeline_bypass_tx;
dprioout(rself_sw_en_tx_TXPCS_IDX_0) <= init_rself_sw_en_tx;

-- ---------------------------------------------------------------------------
-- Set DPRIO CRAM
-- ---------------------------------------------------------------------------
dpriodisable_in <= '0' WHEN (dpriodisable = '0') ELSE '1';

-- Existing
cram_is_lane0              <= init_is_lane0 WHEN (dpriodisable_in /= '0') ELSE dprioin_is_lane0;
cram_rauto_speed_ena       <= init_rauto_speed_ena WHEN (dpriodisable_in /= '0') ELSE dprioin_rauto_speed_ena;
cram_rclkcmpinsertpad      <= init_rclkcmpinsertpad WHEN (dpriodisable_in /= '0') ELSE dprioin_rclkcmpinsertpad;           -- rx only     
cram_rendec_data_sel_tx    <= init_rendec_data_sel_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rendec_data_sel_tx;
cram_rfreq_sel             <= init_rfreq_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rfreq_sel;
cram_rhip_ena              <= init_rhip_ena WHEN (dpriodisable_in /= '0') ELSE  dprioin_rhip_ena;
cram_rindv_tx              <= init_rindv_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rindv_tx;
cram_rmaster_tx            <= init_rmaster_tx WHEN (dpriodisable_in /= '0') ELSE  dprioin_rmaster_tx;
cram_rmaster_up_tx         <= init_rmaster_up_tx WHEN (dpriodisable_in /= '0') ELSE  dprioin_rmaster_up_tx;
cram_rphfifo_master_sel_tx <= init_rphfifo_master_sel_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rphfifo_master_sel_tx;
cram_rpma_doublewidth_tx   <= init_rpma_doublewidth_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpma_doublewidth_tx;
cram_rpmadwidth_tx         <= init_rpmadwidth_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpmadwidth_tx;      
cram_rrdwidth_rx           <= init_rrdwidth_rx WHEN (dpriodisable_in /= '0') ELSE dprioin_rrdwidth_rx;                     -- rx only
cram_rrx_detect_bypass     <= init_rrx_detect_bypass WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_detect_bypass;         -- rx only
cram_rrx_pipe_enable       <= init_rrx_pipe_enable WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_pipe_enable;             -- rx only
cram_rtx_cmu_sel           <= init_rtx_cmu_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_cmu_sel;
cram_scan_mode             <= init_scan_mode WHEN (dpriodisable_in /= '0') ELSE dprioin_scan_mode;

-- PCS Per Channel TX Control Register 1 for Channel 0
cram_rforce_disp <= init_rforce_disp WHEN (dpriodisable_in /= '0') ELSE dprioin_rforce_disp;
cram_rrev_loopbk <= init_rrev_loopbk WHEN (dpriodisable_in /= '0') ELSE dprioin_rrev_loopbk;
cram_rtxrdclksel <= init_rtxrdclksel WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxrdclksel;
cram_rtxwrclksel <= init_rtxwrclksel WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxwrclksel;
cram_rfreerun_tx <= init_rfreerun_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rfreerun_tx;
cram_rtxurstpcs <= init_rtxurstpcs WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxurstpcs;
cram_reserved_0_TB1 <= init_reserved_0_TB1 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB1;
cram_rphfifoursttx <= init_rphfifoursttx WHEN (dpriodisable_in /= '0') ELSE dprioin_rphfifoursttx;
cram_rphfifopldentx <= init_rphfifopldentx WHEN (dpriodisable_in /= '0') ELSE dprioin_rphfifopldentx;
cram_rge_xaui_tx <= init_rge_xaui_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rge_xaui_tx;
cram_rdwidth_tx <= init_rdwidth_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rdwidth_tx;
cram_rtxfifo_lowlatency_en <= init_rtxfifo_lowlatency_en WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxfifo_lowlatency_en;
cram_rib_force_disp <= init_rib_force_disp WHEN (dpriodisable_in /= '0') ELSE dprioin_rib_force_disp;
cram_rtxfifo_dis <= init_rtxfifo_dis WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxfifo_dis;
cram_rforce_echar <= init_rforce_echar WHEN (dpriodisable_in /= '0') ELSE dprioin_rforce_echar;
cram_rforce_kchar <= init_rforce_kchar WHEN (dpriodisable_in /= '0') ELSE dprioin_rforce_kchar;

-- PCS Per Channel TX Control Register 2 for Channel 0
cram_rtxpcsbypass_en <= init_rtxpcsbypass_en WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxpcsbypass_en;
cram_rcxpat_chnl_en <= init_rcxpat_chnl_en WHEN (dpriodisable_in /= '0') ELSE dprioin_rcxpat_chnl_en;
cram_rbist_sel <= init_rbist_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rbist_sel;
cram_rbisten_tx <= init_rbisten_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rbisten_tx;
cram_rprbs_sel <= init_rprbs_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rprbs_sel;
cram_rprbsen_tx <= init_rprbsen_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rprbsen_tx;
cram_renbitrev_tx <= init_renbitrev_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_renbitrev_tx;
cram_renpolinv_tx <= init_renpolinv_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_renpolinv_tx;
cram_rensymswap_tx <= init_rensymswap_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rensymswap_tx;
cram_rcascaded_8b10b_en_tx <= init_rcascaded_8b10b_en_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rcascaded_8b10b_en_tx;
cram_r8b10b_enc_ibm_en <= init_r8b10b_enc_ibm_en WHEN (dpriodisable_in /= '0') ELSE dprioin_r8b10b_enc_ibm_en;
cram_rendec_tx <= init_rendec_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rendec_tx;

-- PCS Per Channel TX Control Register 3 for Channel 0
cram_reserved_0_TB3 <= init_reserved_0_TB3 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB3;
cram_rcid_len_tx <= init_rcid_len_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rcid_len_tx;
cram_rcid_pattern_tx <= init_rcid_pattern_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rcid_pattern_tx;
cram_rtxpcsclkpwdn <= init_rtxpcsclkpwdn WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxpcsclkpwdn;
cram_rtxswing_sel_ena <= init_rtxswing_sel_ena WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxswing_sel_ena;
cram_rtx_elec_idle_delay <= init_rtx_elec_idle_delay WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_elec_idle_delay;
cram_rtx_pipe_enable <= init_rtx_pipe_enable WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_pipe_enable;

-- PCS Per Channel TX Control Register 4 for Channel 0
cram_reserved_0_TB4 <= init_reserved_0_TB4 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB4;
cram_rtxbitslip_en <= init_rtxbitslip_en WHEN (dpriodisable_in /= '0') ELSE dprioin_rtxbitslip_en;
cram_rphfifo_regmode_tx <= init_rphfifo_regmode_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rphfifo_regmode_tx;
cram_rpipeline_bypass_tx <= init_rpipeline_bypass_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpipeline_bypass_tx;
cram_rself_sw_en_tx <= init_rself_sw_en_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rself_sw_en_tx;
-- new DPRIO model end --
   
   --//////////////////////////////////////////////////////////////////////////////////////////////////
   -- datain TXD mapping - datain[32/40], ctrlenable[4], forcedispacompliance, forcedisp[4], dispval[4]
   --//////////////////////////////////////////////////////////////////////////////////////////////////
   
   tmp_ctrlenable(0) <= '1' WHEN (ctrlenable_ipd(0) = '1') ELSE
                        '0';
   tmp_ctrlenable(1) <= '1' WHEN (ctrlenable_ipd(1) = '1') ELSE
                        '0';
   tmp_ctrlenable(2) <= '1' WHEN (ctrlenable_ipd(2) = '1') ELSE
                        '0';
   tmp_ctrlenable(3) <= '1' WHEN (ctrlenable_ipd(3) = '1') ELSE
                        '0';
   
   tmp_dispval(0) <= '1' WHEN (dispval_ipd(0) = '1') ELSE
                     '0';
   tmp_dispval(1) <= '1' WHEN (dispval_ipd(1) = '1') ELSE
                     '0';
   tmp_dispval(2) <= '1' WHEN (dispval_ipd(2) = '1') ELSE
                     '0';
   tmp_dispval(3) <= '1' WHEN (dispval_ipd(3) = '1') ELSE
                     '0';
   
   tmp_forcedisp(0) <= '1' WHEN (forcedisp_ipd(0) = '1') ELSE
                       '0';
   tmp_forcedisp(1) <= '1' WHEN (forcedisp_ipd(1) = '1') ELSE
                       '0';
   tmp_forcedisp(2) <= '1' WHEN (forcedisp_ipd(2) = '1') ELSE
                       '0';
   tmp_forcedisp(3) <= '1' WHEN (forcedisp_ipd(3) = '1') ELSE
                       '0';
   
   tmp_datain(0) <= '1' WHEN (datain_ipd(0) = '1') ELSE
                    '0';
   tmp_datain(1) <= '1' WHEN (datain_ipd(1) = '1') ELSE
                    '0';
   tmp_datain(2) <= '1' WHEN (datain_ipd(2) = '1') ELSE
                    '0';
   tmp_datain(3) <= '1' WHEN (datain_ipd(3) = '1') ELSE
                    '0';
   tmp_datain(4) <= '1' WHEN (datain_ipd(4) = '1') ELSE
                    '0';
   tmp_datain(5) <= '1' WHEN (datain_ipd(5) = '1') ELSE
                    '0';
   tmp_datain(6) <= '1' WHEN (datain_ipd(6) = '1') ELSE
                    '0';
   tmp_datain(7) <= '1' WHEN (datain_ipd(7) = '1') ELSE
                    '0';
   tmp_datain(8) <= '1' WHEN (datain_ipd(8) = '1') ELSE
                    '0';
   tmp_datain(9) <= '1' WHEN (datain_ipd(9) = '1') ELSE
                    '0';
   tmp_datain(10) <= '1' WHEN (datain_ipd(10) = '1') ELSE
                     '0';
   tmp_datain(11) <= '1' WHEN (datain_ipd(11) = '1') ELSE
                     '0';
   tmp_datain(12) <= '1' WHEN (datain_ipd(12) = '1') ELSE
                     '0';
   tmp_datain(13) <= '1' WHEN (datain_ipd(13) = '1') ELSE
                     '0';
   tmp_datain(14) <= '1' WHEN (datain_ipd(14) = '1') ELSE
                     '0';
   tmp_datain(15) <= '1' WHEN (datain_ipd(15) = '1') ELSE
                     '0';
   tmp_datain(16) <= '1' WHEN (datain_ipd(16) = '1') ELSE
                     '0';
   tmp_datain(17) <= '1' WHEN (datain_ipd(17) = '1') ELSE
                     '0';
   tmp_datain(18) <= '1' WHEN (datain_ipd(18) = '1') ELSE
                     '0';
   tmp_datain(19) <= '1' WHEN (datain_ipd(19) = '1') ELSE
                     '0';
   tmp_datain(20) <= '1' WHEN (datain_ipd(20) = '1') ELSE
                     '0';
   tmp_datain(21) <= '1' WHEN (datain_ipd(21) = '1') ELSE
                     '0';
   tmp_datain(22) <= '1' WHEN (datain_ipd(22) = '1') ELSE
                     '0';
   tmp_datain(23) <= '1' WHEN (datain_ipd(23) = '1') ELSE
                     '0';
   tmp_datain(24) <= '1' WHEN (datain_ipd(24) = '1') ELSE
                     '0';
   tmp_datain(25) <= '1' WHEN (datain_ipd(25) = '1') ELSE
                     '0';
   tmp_datain(26) <= '1' WHEN (datain_ipd(26) = '1') ELSE
                     '0';
   tmp_datain(27) <= '1' WHEN (datain_ipd(27) = '1') ELSE
                     '0';
   tmp_datain(28) <= '1' WHEN (datain_ipd(28) = '1') ELSE
                     '0';
   tmp_datain(29) <= '1' WHEN (datain_ipd(29) = '1') ELSE
                     '0';
   tmp_datain(30) <= '1' WHEN (datain_ipd(30) = '1') ELSE
                     '0';
   tmp_datain(31) <= '1' WHEN (datain_ipd(31) = '1') ELSE
                     '0';
   tmp_datain(32) <= '1' WHEN (datain_ipd(32) = '1') ELSE
                     '0';
   tmp_datain(33) <= '1' WHEN (datain_ipd(33) = '1') ELSE
                     '0';
   tmp_datain(34) <= '1' WHEN (datain_ipd(34) = '1') ELSE
                     '0';
   tmp_datain(35) <= '1' WHEN (datain_ipd(35) = '1') ELSE
                     '0';
   tmp_datain(36) <= '1' WHEN (datain_ipd(36) = '1') ELSE
                     '0';
   tmp_datain(37) <= '1' WHEN (datain_ipd(37) = '1') ELSE
                     '0';
   tmp_datain(38) <= '1' WHEN (datain_ipd(38) = '1') ELSE
                     '0';
   tmp_datain(39) <= '1' WHEN (datain_ipd(39) = '1') ELSE
                     '0';
   
   pi_in_txd_ch_tmp(7 DOWNTO 0) <= tmp_datain(7 DOWNTO 0);
   pi_in_txd_ch_tmp(8) <= tmp_ctrlenable(0) WHEN (cram_rendec_tx = '1') ELSE
                          tmp_datain(8) WHEN (cram_rpmadwidth_tx = '1') ELSE
                          'X';
   pi_in_txd_ch_tmp(9) <= tmp_forcedisp(0) WHEN (cram_rendec_tx = '1') ELSE
                          tmp_datain(9) WHEN (cram_rpmadwidth_tx = '1') ELSE
                          'X';
   pi_in_txd_ch_tmp(10) <= tmp_dispval(0) WHEN (cram_rendec_tx = '1') ELSE
                           'X';
   
   pi_in_txd_ch_tmp(18 DOWNTO 11) <= tmp_datain(15 DOWNTO 8) WHEN (cram_rendec_tx = '1' OR cram_rpmadwidth_tx = '0') ELSE
                                     tmp_datain(17 DOWNTO 10);
   pi_in_txd_ch_tmp(19) <= tmp_ctrlenable(1) WHEN (cram_rendec_tx = '1') ELSE
                           tmp_datain(18) WHEN (cram_rpmadwidth_tx = '1') ELSE
                           'X';
   pi_in_txd_ch_tmp(20) <= tmp_forcedisp(1) WHEN (cram_rendec_tx = '1') ELSE
                           tmp_datain(19) WHEN (cram_rpmadwidth_tx = '1') ELSE
                           'X';
   pi_in_txd_ch_tmp(21) <= tmp_dispval(1) WHEN (cram_rendec_tx = '1') ELSE
                           'X';
   
   pi_in_txd_ch_tmp(29 DOWNTO 22) <= tmp_datain(23 DOWNTO 16) WHEN (cram_rendec_tx = '1' OR cram_rpmadwidth_tx = '0') ELSE
                                     tmp_datain(27 DOWNTO 20);
   pi_in_txd_ch_tmp(30) <= tmp_ctrlenable(2) WHEN (cram_rendec_tx = '1') ELSE
                           tmp_datain(28) WHEN (cram_rpmadwidth_tx = '1') ELSE
                           'X';
   pi_in_txd_ch_tmp(31) <= tmp_forcedisp(2) WHEN (cram_rendec_tx = '1') ELSE
                           tmp_datain(29) WHEN (cram_rpmadwidth_tx = '1') ELSE
                           'X';
   pi_in_txd_ch_tmp(32) <= tmp_dispval(2) WHEN (cram_rendec_tx = '1') ELSE
                           'X';
   
   pi_in_txd_ch_tmp(40 DOWNTO 33) <= tmp_datain(31 DOWNTO 24) WHEN (cram_rendec_tx = '1' OR cram_rpmadwidth_tx = '0') ELSE
                                     tmp_datain(37 DOWNTO 30);
   pi_in_txd_ch_tmp(41) <= tmp_ctrlenable(3) WHEN (cram_rendec_tx = '1') ELSE
                           tmp_datain(38) WHEN (cram_rpmadwidth_tx = '1') ELSE
                           'X';
   pi_in_txd_ch_tmp(42) <= tmp_forcedisp(3) WHEN (cram_rendec_tx = '1') ELSE
                           tmp_datain(39) WHEN (cram_rpmadwidth_tx = '1') ELSE
                           'X';
   pi_in_txd_ch_tmp(43) <= tmp_dispval(3) WHEN (cram_rendec_tx = '1') ELSE
                           'X';
   
   --interleaving
   pi_in_txd_ch(10 DOWNTO 0) <= pi_in_txd_ch_tmp(10 DOWNTO 0);
   pi_in_txd_ch(32 DOWNTO 22) <= pi_in_txd_ch_tmp(21 DOWNTO 11) WHEN (cram_rdwidth_tx = '1' AND cram_rpma_doublewidth_tx = '0') ELSE
                                 pi_in_txd_ch_tmp(32 DOWNTO 22);
   pi_in_txd_ch(21 DOWNTO 11) <= pi_in_txd_ch_tmp(32 DOWNTO 22) WHEN (cram_rdwidth_tx = '1' AND cram_rpma_doublewidth_tx = '0') ELSE
                                 pi_in_txd_ch_tmp(21 DOWNTO 11);
   pi_in_txd_ch(43 DOWNTO 33) <= pi_in_txd_ch_tmp(43 DOWNTO 33);
   
    pi_in_txd_ch_dprio <=  datainfull_siv WHEN ((dprio_config_mode AND DPRIO_CHANNEL_INTERFACE_BIT) = "000100") ELSE pi_in_txd_ch;
   
   --///////////////////////////////////////////////////////////////////////////////
   -- Connect Atom level output to appropriate RTL  - PORT_OUT_Table ------------ //
   --///////////////////////////////////////////////////////////////////////////////
   
   clkout <= td_out_tx_clk_out;
   dataout <= td_out_pudr(9 DOWNTO 0);   -- cycloneiv_width modify
   parallelfdbkout <= td_out_txlp20b;
   phfifooverflow <= td_out_full_tx;
   phfifounderflow <= td_out_empty_tx;
   
   pipepowerdownout <= td_out_powerdown_int;		-- powerdn_ipd;
   pipepowerstateout <= pi_out_powerstate(3 DOWNTO 0);
   rdenablesync <= td_out_rd_enable_sync;
   txdetectrx <= pi_out_txdetectrx;		-- NEW
   xgmctrlenable <= td_out_tx_ctl_tc;
   xgmdataout <= td_out_tx_data_tc;
   
   coreclkout <= coreclk_ipd;
   hiptxclkout <= hs_out_hip_tx_clk;
   iqpphfifobyteselout <= td_out_fifo_select_out_pipe;
   iqpphfifordclkout <= td_out_tx_div2_sync_out_pipe;
   iqpphfifordenableout <= td_out_rd_enable_out_pipe;
   iqpphfifowrenableout <= td_out_wr_enable_out_pipe;
   phfiforddisableout <= phfiforddisable;
   phfiforesetout <= phfiforeset;
   phfifowrenableout <= phfifowrenable;
    
   grayelecidleinferselout <= td_out_gray_eidleinfersel;
   pipeenrevparallellpbkout <= pi_out_rev_loopbk;

   -- q90 ww47 fix ---------------------------------------------------------------
   forceelecidleout     <= pi_out_tx_elec_idle;
   
   --///////////////////////////////////////////////////////////////////////////////
   -- tx sub-block instantiation: pcs_reset --------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   pr_in_hard_reset <= '1' WHEN (quadreset = '1') ELSE		-- from top
                       '0';
   pr_in_clk_2_b <= '0';		-- for rx side 
   pr_in_refclk_b_in <= td_out_refclk_b;
   pr_in_scan_mode <= '0';
   pr_in_rxpcs_rst <= '0';		-- for rx side
   pr_in_txpcs_rst <= '1' WHEN (digitalreset = '1') ELSE		-- from top
                      '0';
   
   tx_pcs_reset_1 : cycloneiv_hssi_pcs_reset
      PORT MAP (
         hard_reset   => pr_in_hard_reset,
         clk_2_b      => pr_in_clk_2_b,
         refclk_b_in  => pr_in_refclk_b_in,
         scan_mode    => pr_in_scan_mode,
         rxpcs_rst    => pr_in_rxpcs_rst,
         txpcs_rst    => pr_in_txpcs_rst,
         rxrst_int    => rxrst_int_wire,
         txrst_int    => pr_out_txrst_int
      );
   
   --///////////////////////////////////////////////////////////////////////////////
   -- tx sub-block instantiation: chnl_hip_support -------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   hs_in_eidleinfersel_ch <= elecidleinfersel_in;
   hs_in_hip_eidleinfersel_ch <= hipelecidleinfersel_in;
   hs_in_hip_powerdown_ch <= hippowerdn_in;
   hs_in_hip_rate <= 'X';
   hs_in_hip_rxpolarity <= 'X';
   hs_in_hip_txd_ch <= hipdatain_in;
   hs_in_hip_txdeemph <= hiptxdeemph_in;
   hs_in_hip_txdetectrxloopback <= hipdetectrxloop_in;
   hs_in_hip_txelecidle <= hipforceelecidle_in;
   hs_in_hip_txmargin_ch <= hiptxmargin_in;
   hs_in_pcs_phystatus <= 'X';
   hs_in_pcs_rxd_ch <= "XXXXXXXXX";
   hs_in_pcs_rxelecidle <= 'X';
   hs_in_pcs_rxstatus_ch <= "00X";
   hs_in_pcs_rxvalid <= 'X';
   hs_in_powerdown_ch <= powerdn_ipd;
   hs_in_rate <= 'X';
   hs_in_rhip_ena <= cram_rhip_ena;
   hs_in_rxpolarity <= 'X';
   hs_in_txd_ch <= pi_in_txd_ch_dprio(10 DOWNTO 0);
   hs_in_txdeemph <= pipetxdeemph_ipd;
   hs_in_txdetectrxloopback <= detectrxloop_ipd;
   hs_in_txmargin_ch <= pipetxmargin_ipd;
   hs_in_txpma_local_clk <= localrefclk;
   
   mtx_hs : cycloneiv_hssi_digi_chnl_hip_spt
      PORT MAP (
         
         eidleinfersel_ch        => hs_in_eidleinfersel_ch,
         hip_eidleinfersel_ch    => hs_in_hip_eidleinfersel_ch,
         hip_powerdown_ch        => hs_in_hip_powerdown_ch,
         hip_rate                => hs_in_hip_rate,
         hip_rxpolarity          => hs_in_hip_rxpolarity,
         hip_txd_ch              => hs_in_hip_txd_ch,
         hip_txdeemph            => hs_in_hip_txdeemph,
         hip_txdetectrxloopback  => hs_in_hip_txdetectrxloopback,
         hip_txelecidle          => hs_in_hip_txelecidle,
         hip_txmargin_ch         => hs_in_hip_txmargin_ch,
         pcs_phystatus           => hs_in_pcs_phystatus,
         pcs_rxd_ch              => hs_in_pcs_rxd_ch,
         pcs_rxelecidle          => hs_in_pcs_rxelecidle,
         pcs_rxstatus_ch         => hs_in_pcs_rxstatus_ch,
         pcs_rxvalid             => hs_in_pcs_rxvalid,
         powerdown_ch            => hs_in_powerdown_ch,
         rate                    => hs_in_rate,
         rhip_ena                => hs_in_rhip_ena,
         rxpolarity              => hs_in_rxpolarity,
         txd_ch                  => hs_in_txd_ch,
         txdeemph                => hs_in_txdeemph,
         txdetectrxloopback      => hs_in_txdetectrxloopback,
         txmargin_ch             => hs_in_txmargin_ch,
         txpma_local_clk         => hs_in_txpma_local_clk,
         
         hip_phystatus           => hs_out_hip_phystatus,
         hip_rxd_ch              => hs_out_hip_rxd_ch,
         hip_rxelecidle          => hs_out_hip_rxelecidle,
         hip_rxstatus_ch         => hs_out_hip_rxstatus_ch,
         hip_rxvalid             => hs_out_hip_rxvalid,
         hip_tx_clk              => hs_out_hip_tx_clk,
         pcs_eidleinfersel_ch    => hs_out_pcs_eidleinfersel_ch,
         pcs_powerdown_ch        => hs_out_pcs_powerdown_ch,
         pcs_rate                => hs_out_pcs_rate,
         pcs_rxpolarity          => hs_out_pcs_rxpolarity,
         pcs_txd_ch              => hs_out_pcs_txd_ch,
         pcs_txdeemph            => hs_out_pcs_txdeemph,
         pcs_txdetectrxloopback  => hs_out_pcs_txdetectrxloopback,
         pcs_txmargin_ch         => hs_out_pcs_txmargin_ch,
         phystatus               => hs_out_phystatus,
         rxd_ch                  => hs_out_rxd_ch,
         rxelecidle              => hs_out_rxelecidle,
         rxstatus_ch             => hs_out_rxstatus_ch,
         rxvalid                 => hs_out_rxvalid
      );
   
   --///////////////////////////////////////////////////////////////////////////////
   -- tx sub-block instantiation: pipe_interface ---------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   pi_in_pipe_tx_clk <= '0' WHEN (cram_rtx_pipe_enable = '0') ELSE
                        td_out_tx_pipe_clk;
   pi_in_powerdown <= td_out_powerdown_int;		-- powerdn_ipd;            
   pi_in_refclk_b <= '0' WHEN (cram_rtx_pipe_enable = '0') ELSE
                     td_out_refclk_b;
   pi_in_refclk_b_reset_n <= NOT(pr_out_txrst_int);
   pi_in_revloopback <= td_out_revloopback_int;		-- (enrevparallellpbk_ipd === 1'b1) ? 1'b1 : 1'b0; 
   pi_in_tx_elec_idle_comp <= td_out_tx_pipe_electidle;
   pi_in_tx_pipe_reset_n <= NOT(td_out_tx_pipe_soft_reset);
   pi_in_txdetectrxloopback <= td_out_txdetectrxloopback_int;		-- (detectrxloop_ipd === 1'b1) ? 1'b1 : 1'b0;
   pi_in_txelecidle <= forceelecidle_ipd;
   pi_in_state_transition_done <= pipestatetransdone;
   
   -- new interfaces in CYCLONEIV
   pi_in_txdeemph <= td_out_phfifo_txdeemph;
   pi_in_txmargin <= td_out_phfifo_txmargin;
   pi_in_txswing  <= td_out_phfifo_txswing;
   
   tx_pipe_interface_inst : cycloneiv_hssi_tx_pipe_interface
      PORT MAP (
         clk                  => pi_in_pipe_tx_clk,
         refclk_b             => pi_in_refclk_b,
         refclk_b_reset_n     => pi_in_refclk_b_reset_n,
         reset_n              => pi_in_tx_pipe_reset_n,
         rtx_pipe_enable      => cram_rtx_pipe_enable,
         rtx_elec_idle_delay  => cram_rtx_elec_idle_delay,
         txdetectrxloopback   => pi_in_txdetectrxloopback,
         txelecidle           => pi_in_txelecidle,
         powerdown            => pi_in_powerdown,
         txd_ch               => pi_in_txd_ch_dprio,
         revloopback          => pi_in_revloopback,
         txd                  => pi_out_txd,
         rev_loopbk           => pi_out_rev_loopbk,
         tx_elec_idle_comp    => pi_in_tx_elec_idle_comp,
         tx_elec_idle         => pi_out_tx_elec_idle,
         txdetectrx           => pi_out_txdetectrx,
         powerstate           => pi_out_powerstate,
         
         -- new interfaces in CYCLONEIV - ww26.5
         rtxswing_sel_ena     => cram_rtxswing_sel_ena,
         txdeemph             => pi_in_txdeemph,
         txmargin             => pi_in_txmargin,
         txswing              => pi_in_txswing,
         txdeemph_int         => pi_out_txdeemph_int,
         txmargin_int         => pi_out_txmargin_int,
         txswing_int          => pi_out_txswing_int
      );
   
   --///////////////////////////////////////////////////////////////////////////////
   -- tx sub-block instantiation: tx_digi ----------------------------------------//
   --///////////////////////////////////////////////////////////////////////////////
   
   td_in_phfifourst_tx <= '1' WHEN (phfiforeset = '1') ELSE
                          '0';
   td_in_pld_tx_clk <= coreclk;		-- coreclk_ipd;
   td_in_polinv_tx <= '1' WHEN (invpol_ipd = '1') ELSE
                      '0';
   td_in_rddisable_tx <= '1' WHEN (phfiforddisable = '1') ELSE		-- enable by default
                         '0';
   td_in_refclk_pma <= refclk_ipd;
   td_in_rev_loop_data <= revparallelfdbk;
   td_in_rev_loopbk <= pi_out_rev_loopbk;
   td_in_tx_data_ts <= xgmdatain;
   td_in_tx_ctl_ts <= xgmctrl;
   td_in_txd <= (pi_in_txd_ch_dprio(43 DOWNTO 11) & hs_out_pcs_txd_ch);		--pi_in_txd_ch_dprio; // pi_out_txd - 44 bit
   td_in_txpcs_rst <= pr_out_txrst_int;
   td_in_txpma_local_clk <= localrefclk;
   td_in_wrenable_tx <= '0' WHEN (phfifowrenable_ipd = '0') ELSE		-- enable by default 
                        '1';
   
   td_in_gen2ngen1 <= '1' WHEN (rateswitchisdone = '1') ELSE		--from tx_pma local clk divider
                      '0';
   td_in_gen2ngen1_bundle <= '1' WHEN (rateswitchxndone = '1') ELSE		--from central clk divider
                             '0';
   td_in_polinv_rx <= '0';		-- leaving it out of tx as it is a simple wire in tx_ctrl 
   td_in_powerdown <= hs_out_pcs_powerdown_ch;		-- powerdn_ipd;	
   td_in_revloopback <= '1' WHEN (enrevparallellpbk_ipd = '1') ELSE
                        '0';
   td_in_rxpolarity <= '0';		--// leaving it out of tx as it is a simple wire in tx_ctrl
   td_in_txdetectrxloopback <= hs_out_pcs_txdetectrxloopback;		-- (detectrxloop_ipd === 1'b1) ? 1'b1 : 1'b0;
   
   td_in_prbs_cid_en <= prbscidenable_in;
   td_in_tx_boundary_sel <= bitslipboundaryselect_ipd;
   
   -- new signal inputs for bundling
   -- temporary disabled by forcing rindv_tx = 1'b0 todo
   -- SPR 311609
   td_in_tx_div2_sync_in_centrl <= phfifox4rdclk_in;
   td_in_tx_div2_sync_in_quad_up <= phfifox4rdclk_in;
   td_in_tx_div2_sync_in_quad_down <= phfifox4rdclk_in;
   td_in_wr_enable_in_centrl <= phfifox4wrenable_in;
   td_in_wr_enable_in_quad_up <= phfifox4wrenable_in;
   td_in_wr_enable_in_quad_down <= phfifox4wrenable_in;
   td_in_rd_enable_in_centrl <= phfifox4rdenable_in;
   td_in_rd_enable_in_quad_up <= phfifox4rdenable_in;
   td_in_rd_enable_in_quad_down <= phfifox4rdenable_in;
   td_in_fifo_select_in_centrl <= phfifox4bytesel_in;
   td_in_fifo_select_in_quad_up <= phfifox4bytesel_in;
   td_in_fifo_select_in_quad_down <= phfifox4bytesel_in;
   td_in_reset_pc_ptrs <= phfifoptrsreset_in;		-- from rx
   td_in_reset_pc_ptrs_in_centrl <= phfifoxnptrsreset_in(cycloneiv_tx_pcs_mphfifo_index(ph_fifo_xn_select));
   td_in_reset_pc_ptrs_in_quad_up <= phfifoxnptrsreset_in(cycloneiv_tx_pcs_mphfifo_index(ph_fifo_xn_select));
   td_in_reset_pc_ptrs_in_quad_down <= phfifoxnptrsreset_in(cycloneiv_tx_pcs_mphfifo_index(ph_fifo_xn_select));
   
   td_in_tx_div2_sync_in_pipe_quad_up <= iqpphfifoxnrdclk_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   td_in_tx_div2_sync_in_pipe_quad_down <= iqpphfifoxnrdclk_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   td_in_wr_enable_in_pipe_quad_up <= iqpphfifoxnwrenable_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   td_in_wr_enable_in_pipe_quad_down <= iqpphfifoxnwrenable_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   td_in_rd_enable_in_pipe_quad_up <= iqpphfifoxnrdenable_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   td_in_rd_enable_in_pipe_quad_down <= iqpphfifoxnrdenable_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   td_in_fifo_select_in_pipe_quad_up <= iqpphfifoxnbytesel_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   td_in_fifo_select_in_pipe_quad_down <= iqpphfifoxnbytesel_in(cycloneiv_tx_pcs_miqp_phfifo_index(ph_fifo_xn_select));
   
   td_in_dis_pc_byte <= phfifobyteserdisable_in;		-- from rx
   
   -- push through TX Phase Comp FIFO
   td_in_txswing      <= pipetxswing_ipd; 		    --ww12_new conne
   td_in_pcs_txdeemph <= hs_out_pcs_txdeemph; 		--ww12_new conne
   td_in_pcs_txmargin <= hs_out_pcs_txmargin_ch;	--ww12_new conne
   
   -- RX PIPE interface signals
   td_in_eidleinfersel <= hs_out_pcs_eidleinfersel_ch;
   
   td_out_tx_div2_sync_out_pipe <= td_out_tx_div2_sync_out_pipe_up WHEN (cram_rmaster_up_tx = '0') ELSE
                                   td_out_tx_div2_sync_out_pipe_down;
   td_out_fifo_select_out_pipe <= td_out_fifo_select_out_pipe_up WHEN (cram_rmaster_up_tx = '0') ELSE
                                  td_out_fifo_select_out_pipe_down;
   td_out_wr_enable_out_pipe <= td_out_wr_enable_out_pipe_up WHEN (cram_rmaster_up_tx = '0') ELSE
                                td_out_wr_enable_out_pipe_down;
   td_out_rd_enable_out_pipe <= td_out_rd_enable_out_pipe_up WHEN (cram_rmaster_up_tx = '0') ELSE
                                td_out_rd_enable_out_pipe_down;
   
   digi_tx_1 : cycloneiv_hssi_tx_digi
      PORT MAP (
         empty_tx                        => td_out_empty_tx,
         encoder_testbus                 => td_out_encoder_testbus,
         full_tx                         => td_out_full_tx,
         phfifourst_tx                   => td_in_phfifourst_tx,
         pld_tx_clk                      => td_in_pld_tx_clk,
         polinv_tx                       => td_in_polinv_tx,
         pudr                            => td_out_pudr,
         r8b10b_enc_ibm_en               => cram_r8b10b_enc_ibm_en,
         rbist_sel                       => cram_rbist_sel,
         rbisten_tx                      => cram_rbisten_tx,
         rcascaded_8b10b_en_tx           => cram_rcascaded_8b10b_en_tx,
         rcxpat_chnl_en                  => cram_rcxpat_chnl_en,
         rd_enable_sync                  => td_out_rd_enable_sync,
         rddisable_tx                    => td_in_rddisable_tx,
         rdwidth_tx                      => cram_rdwidth_tx,
         refclk_b                        => td_out_refclk_b,
         refclk_pma                      => td_in_refclk_pma,
         renbitrev_tx                    => cram_renbitrev_tx,
         rendec_data_sel_tx              => cram_rendec_data_sel_tx,
         rendec_tx                       => cram_rendec_tx,
         renpolinv_tx                    => cram_renpolinv_tx,
         rensymswap_tx                   => cram_rensymswap_tx,
         rev_loop_data                   => td_in_rev_loop_data,
         rev_loopbk                      => td_in_rev_loopbk,
         rforce_disp                     => cram_rforce_disp,
         rforce_echar                    => cram_rforce_echar,
         rforce_kchar                    => cram_rforce_kchar,
         rfreerun_tx                     => cram_rfreerun_tx,
         rge_xaui_tx                     => cram_rge_xaui_tx,
         rib_force_disp                  => cram_rib_force_disp,
         rindv_tx                        => cram_rindv_tx,
         rphfifopldentx                  => cram_rphfifopldentx,
         rphfifoursttx                   => cram_rphfifoursttx,
         rpma_doublewidth_tx             => cram_rpma_doublewidth_tx,
         rpmadwidth_tx                   => cram_rpmadwidth_tx,
         rprbs_sel                       => cram_rprbs_sel,
         rprbsen_tx                      => cram_rprbsen_tx,
         rrev_loopbk                     => cram_rrev_loopbk,
         rtx_pipe_enable                 => cram_rtx_pipe_enable,
         rtxfifo_dis                     => cram_rtxfifo_dis,
         rtxfifo_lowlatency_en           => cram_rtxfifo_lowlatency_en,
         rtxrdclksel                     => cram_rtxrdclksel,
         rtxwrclksel                     => cram_rtxwrclksel,
         scan_mode                       => cram_scan_mode,
         tx_clk_out                      => td_out_tx_clk_out,
         tx_ctl_tc                       => td_out_tx_ctl_tc,
         tx_ctl_ts                       => td_in_tx_ctl_ts,
         tx_ctrl_testbus                 => td_out_tx_ctrl_testbus,
         tx_data_tc                      => td_out_tx_data_tc,
         tx_data_ts                      => td_in_tx_data_ts,
         tx_pipe_clk                     => td_out_tx_pipe_clk,
         tx_pipe_electidle               => td_out_tx_pipe_electidle,
         tx_pipe_soft_reset              => td_out_tx_pipe_soft_reset,
         txd                             => td_in_txd,
         txlp20b                         => td_out_txlp20b,
         txpcs_rst                       => td_in_txpcs_rst,
         txpma_local_clk                 => td_in_txpma_local_clk,
         wrenable_tx                     => td_in_wrenable_tx,
         
         gen2ngen1                       => td_in_gen2ngen1,
         gen2ngen1_bundle                => td_in_gen2ngen1_bundle,
         polinv_rx                       => td_in_polinv_rx,
         powerdown                       => td_in_powerdown,
         revloopback                     => td_in_revloopback,
         rxpolarity                      => td_in_rxpolarity,
         txdetectrxloopback              => td_in_txdetectrxloopback,
         
         rauto_speed_ena                 => cram_rauto_speed_ena,
         rfreq_sel                       => cram_rfreq_sel,
         rtxpcsbypass_en                 => cram_rtxpcsbypass_en,
         rtxpcsclkpwdn                   => cram_rtxpcsclkpwdn,
         
         polinv_rx_int                   => td_out_polinv_rx_int,
         powerdown_int                   => td_out_powerdown_int,
         revloopback_int                 => td_out_revloopback_int,
         rxpolarity_int                  => td_out_rxpolarity_int,
         txdetectrxloopback_int          => td_out_txdetectrxloopback_int,
         
         prbs_cid_en                     => td_in_prbs_cid_en,
         tx_boundary_sel                 => td_in_tx_boundary_sel,
         rcid_pattern_tx                 => cram_rcid_pattern_tx,
         rcid_len_tx                     => cram_rcid_len_tx,
         
         tx_div2_sync_in_centrl          => td_in_tx_div2_sync_in_centrl,
         tx_div2_sync_in_quad_up         => td_in_tx_div2_sync_in_quad_up,
         tx_div2_sync_in_quad_down       => td_in_tx_div2_sync_in_quad_down,
         wr_enable_in_centrl             => td_in_wr_enable_in_centrl,
         wr_enable_in_quad_up            => td_in_wr_enable_in_quad_up,
         wr_enable_in_quad_down          => td_in_wr_enable_in_quad_down,
         rd_enable_in_centrl             => td_in_rd_enable_in_centrl,
         rd_enable_in_quad_up            => td_in_rd_enable_in_quad_up,
         rd_enable_in_quad_down          => td_in_rd_enable_in_quad_down,
         fifo_select_in_centrl           => td_in_fifo_select_in_centrl,
         fifo_select_in_quad_up          => td_in_fifo_select_in_quad_up,
         fifo_select_in_quad_down        => td_in_fifo_select_in_quad_down,
         reset_pc_ptrs                   => td_in_reset_pc_ptrs,
         reset_pc_ptrs_in_centrl         => td_in_reset_pc_ptrs_in_centrl,
         reset_pc_ptrs_in_quad_up        => td_in_reset_pc_ptrs_in_quad_up,
         reset_pc_ptrs_in_quad_down      => td_in_reset_pc_ptrs_in_quad_down,
         tx_div2_sync_in_pipe_quad_up    => td_in_tx_div2_sync_in_pipe_quad_up,
         tx_div2_sync_in_pipe_quad_down  => td_in_tx_div2_sync_in_pipe_quad_down,
         wr_enable_in_pipe_quad_up       => td_in_wr_enable_in_pipe_quad_up,
         wr_enable_in_pipe_quad_down     => td_in_wr_enable_in_pipe_quad_down,
         rd_enable_in_pipe_quad_up       => td_in_rd_enable_in_pipe_quad_up,
         rd_enable_in_pipe_quad_down     => td_in_rd_enable_in_pipe_quad_down,
         fifo_select_in_pipe_quad_up     => td_in_fifo_select_in_pipe_quad_up,
         fifo_select_in_pipe_quad_down   => td_in_fifo_select_in_pipe_quad_down,
         
         dis_pc_byte                     => td_in_dis_pc_byte,
         
         rmaster_tx                      => cram_rmaster_tx,
         rmaster_up_tx                   => cram_rmaster_up_tx,
         rself_sw_en_tx                  => cram_rself_sw_en_tx,
         rpipeline_bypass_tx             => cram_rpipeline_bypass_tx,
         rphfifo_regmode_tx              => cram_rphfifo_regmode_tx,
         
         tx_div2_sync_out_pipe_up        => td_out_tx_div2_sync_out_pipe_up,
         fifo_select_out_pipe_up         => td_out_fifo_select_out_pipe_up,
         wr_enable_out_pipe_up           => td_out_wr_enable_out_pipe_up,
         rd_enable_out_pipe_up           => td_out_rd_enable_out_pipe_up,
         tx_div2_sync_out_pipe_down      => td_out_tx_div2_sync_out_pipe_down,
         fifo_select_out_pipe_down       => td_out_fifo_select_out_pipe_down,
         wr_enable_out_pipe_down         => td_out_wr_enable_out_pipe_down,
         rd_enable_out_pipe_down         => td_out_rd_enable_out_pipe_down,
         
         txswing                         => td_in_txswing,
         pcs_txdeemph                    => td_in_pcs_txdeemph,
         pcs_txmargin                    => td_in_pcs_txmargin,
         eidleinfersel                   => td_in_eidleinfersel,
         
         phfifo_txswing                  => td_out_phfifo_txswing,
         phfifo_txdeemph                 => td_out_phfifo_txdeemph,
         phfifo_txmargin                 => td_out_phfifo_txmargin,
         gray_eidleinfersel              => td_out_gray_eidleinfersel,
         
         rtxbitslip_en                   => cram_rtxbitslip_en
      );
   
END trans;

-- stratixiigx_hssi_transmitter 


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_rx_digis_ram8x70_syn IS
   GENERIC (
      
      read_access_time   : INTEGER := 0;
      write_access_time  : INTEGER := 0;
      ram_width          : INTEGER := 70
   );
   PORT (
      rst_l              : IN STD_LOGIC;
      clk                : IN STD_LOGIC;
      fifo_wr            : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      data_in            : IN STD_LOGIC_VECTOR(69 DOWNTO 0);
      fifo_re            : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      data_out           : OUT STD_LOGIC_VECTOR(69 DOWNTO 0)
   );
END cycloneiv_hssi_rx_digis_ram8x70_syn;

ARCHITECTURE trans OF cycloneiv_hssi_rx_digis_ram8x70_syn IS
   
   SIGNAL data_out_i    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_0 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_1 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_2 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_3 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_4 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_5 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_6 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_7 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_0 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_1 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_2 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_3 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_4 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_5 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_6 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_7 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   
   SIGNAL data_reg_0    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_1    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_2    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_3    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_4    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_5    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_6    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_7    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   
   SIGNAL we            : STD_LOGIC;
   SIGNAL re_l          : STD_LOGIC;
BEGIN
   
   we <= '1';
   re_l <= '0';
   
   --assignment
   data_reg_0 <= data_in WHEN (fifo_wr(0) = '1') ELSE
                 ram_array_q_0;
   data_reg_1 <= data_in WHEN (fifo_wr(1) = '1') ELSE
                 ram_array_q_1;
   data_reg_2 <= data_in WHEN (fifo_wr(2) = '1') ELSE
                 ram_array_q_2;
   data_reg_3 <= data_in WHEN (fifo_wr(3) = '1') ELSE
                 ram_array_q_3;
   data_reg_4 <= data_in WHEN (fifo_wr(4) = '1') ELSE
                 ram_array_q_4;
   data_reg_5 <= data_in WHEN (fifo_wr(5) = '1') ELSE
                 ram_array_q_5;
   data_reg_6 <= data_in WHEN (fifo_wr(6) = '1') ELSE
                 ram_array_q_6;
   data_reg_7 <= data_in WHEN (fifo_wr(7) = '1') ELSE
                 ram_array_q_7;
   
   data_out <= "0000000000000000000000000000000000000000000000000000000000000000000000" WHEN (re_l = '1') ELSE
               data_out_i;
   
   PROCESS (ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, fifo_re)
VARIABLE  txt : LINE;
   BEGIN
      CASE fifo_re IS		-- synopsys parallel_case full_case
         WHEN "00000001" =>
            data_out_i <= ram_array_q_0;
         WHEN "00000010" =>
            data_out_i <= ram_array_q_1;
         WHEN "00000100" =>
            data_out_i <= ram_array_q_2;
         WHEN "00001000" =>
            data_out_i <= ram_array_q_3;
         WHEN "00010000" =>
            data_out_i <= ram_array_q_4;
         WHEN "00100000" =>
            data_out_i <= ram_array_q_5;
         WHEN "01000000" =>
            data_out_i <= ram_array_q_6;
         WHEN "10000000" =>
            data_out_i <= ram_array_q_7;
         WHEN OTHERS =>
            data_out_i <= ram_array_q_0;
      END CASE;
   END PROCESS;
   
   PROCESS (clk, rst_l)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rst_l)) = '1') THEN
         ram_array_q_0 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_1 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_2 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_3 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_4 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_5 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_6 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_7 <=  TRANSPORT "0000100000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         ram_array_q_0 <=  TRANSPORT ram_array_d_0 AFTER (write_access_time)*1 ps;
         ram_array_q_1 <=  TRANSPORT ram_array_d_1 AFTER (write_access_time)*1 ps;
         ram_array_q_2 <=  TRANSPORT ram_array_d_2 AFTER (write_access_time)*1 ps;
         ram_array_q_3 <=  TRANSPORT ram_array_d_3 AFTER (write_access_time)*1 ps;
         ram_array_q_4 <=  TRANSPORT ram_array_d_4 AFTER (write_access_time)*1 ps;
         ram_array_q_5 <=  TRANSPORT ram_array_d_5 AFTER (write_access_time)*1 ps;
         ram_array_q_6 <=  TRANSPORT ram_array_d_6 AFTER (write_access_time)*1 ps;
         ram_array_q_7 <=  TRANSPORT ram_array_d_7 AFTER (write_access_time)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (we, data_reg_0, data_reg_1, data_reg_2, data_reg_3, data_reg_4, data_reg_5, data_reg_6, data_reg_7, ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7)
VARIABLE  txt : LINE;
   BEGIN
      IF (we = '1') THEN
         ram_array_d_0 <= data_reg_0;
         ram_array_d_1 <= data_reg_1;
         ram_array_d_2 <= data_reg_2;
         ram_array_d_3 <= data_reg_3;
         ram_array_d_4 <= data_reg_4;
         ram_array_d_5 <= data_reg_5;
         ram_array_d_6 <= data_reg_6;
         ram_array_d_7 <= data_reg_7;
      ELSE
         ram_array_d_0 <= ram_array_q_0;
         ram_array_d_1 <= ram_array_q_1;
         ram_array_d_2 <= ram_array_q_2;
         ram_array_d_3 <= ram_array_q_3;
         ram_array_d_4 <= ram_array_q_4;
         ram_array_d_5 <= ram_array_q_5;
         ram_array_d_6 <= ram_array_q_6;
         ram_array_d_7 <= ram_array_q_7;
      END IF;
   END PROCESS;
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_rx_digis_ph_fifo IS
   PORT (
      -- inputs
      -- outputs
      
      -- =======
      -- inputs 
      -- =======
      rst_wclk                 : IN STD_LOGIC;
      rst_rclk                 : IN STD_LOGIC;
      wr_clk                   : IN STD_LOGIC;		-- Write Clock
      rd_clk                   : IN STD_LOGIC;		-- Read Clock
      en                       : IN STD_LOGIC;		-- Disable FIFO or bypass - only for Altera internal debug
      lowlatency_en            : IN STD_LOGIC;		-- low latency enable
      we                       : IN STD_LOGIC;		-- PLD dynamic write pointer enable  
      re                       : IN STD_LOGIC;		-- PLD dynamic read pointer enable  
      din                      : IN STD_LOGIC_VECTOR(69 DOWNTO 0);		-- 10-bit code-group bus from deskew module.
      
      rphfifo_regmode_rx       : IN STD_LOGIC;
      rindv_rx                 : IN STD_LOGIC;
      rauto_speed_ena          : IN STD_LOGIC;
      reset_pc_ptrs            : IN STD_LOGIC;
      reset_pc_ptrs_centrl     : IN STD_LOGIC;
      reset_pc_ptrs_quad_up    : IN STD_LOGIC;
      reset_pc_ptrs_quad_down  : IN STD_LOGIC;
      rmaster_rx               : IN STD_LOGIC;
      rmaster_up_rx            : IN STD_LOGIC;
      
      -- =======
      -- outputs 
      -- =======
      -- Indicates overflow (rd_clk)
      -- FIFO empty (rd_clk)
      data_out                 : OUT STD_LOGIC_VECTOR(69 DOWNTO 0);		-- output data (rd_clk synchronous if not FIFO bypass)
      ph_fifo_full             : OUT STD_LOGIC;
      ph_fifo_empty            : OUT STD_LOGIC;
      wptr_bin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);		-- test bus
      rptr_bin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      pcs_wrapback_in          : IN STD_LOGIC_VECTOR(69 DOWNTO 0);
      rpcs_wrapback_en         : IN STD_LOGIC;
      scan_mode                : IN STD_LOGIC
   );
END cycloneiv_hssi_rx_digis_ph_fifo;

ARCHITECTURE trans OF cycloneiv_hssi_rx_digis_ph_fifo IS
   COMPONENT cycloneiv_hssi_rx_digis_ram8x70_syn IS
      GENERIC (    
      read_access_time   : INTEGER := 0;
      write_access_time  : INTEGER := 0;
      ram_width          : INTEGER := 70
   );
      PORT (
         rst_l                    : IN STD_LOGIC;
         clk                      : IN STD_LOGIC;
         fifo_wr                  : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         data_in                  : IN STD_LOGIC_VECTOR(69 DOWNTO 0);
         fifo_re                  : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         data_out                 : OUT STD_LOGIC_VECTOR(69 DOWNTO 0)
      );
   END COMPONENT;
   
   
   -- ===================
   -- signal declaration
   -- ===================
   SIGNAL wptr                   : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL rptr                   : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL wptr_gray              : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL wptr_gray0             : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL wptr0                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL wptr1                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL wptr1_onehot           : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL rptr0_pre              : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL rptr0                  : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL rptr1                  : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL first_rd               : STD_LOGIC;
   SIGNAL ram_data_out           : STD_LOGIC_VECTOR(69 DOWNTO 0);
   SIGNAL ram_data_out_pre       : STD_LOGIC_VECTOR(69 DOWNTO 0);
   -- test bus
   -- test bus
   
   SIGNAL ph_fifo_empty_pre      : STD_LOGIC;
   
   SIGNAL rst_n                  : STD_LOGIC;		-- Invert rst for new FIFO     
   
   SIGNAL fifo_cnt               : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL fifo_cnt_pre           : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rptr1_bin              : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL wptr1_bin_rclk         : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   SIGNAL reset_ptrs_local       : STD_LOGIC;
   
   SIGNAL reset_ptrs_local_sync1 : STD_LOGIC;
   SIGNAL reset_ptrs_local_sync2 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL ph_fifo_full_xhdl0     : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   ph_fifo_full <= ph_fifo_full_xhdl0;
   
   -- =============
   -- functionality
   -- =============
   rst_n <= NOT(rst_wclk);
   
   -- bypass
   data_out(69 DOWNTO 0) <= ram_data_out WHEN (en = '1') ELSE
                            din;
   
   reset_ptrs_local <= rauto_speed_ena AND reset_pc_ptrs WHEN (rindv_rx = '1') ELSE
                       reset_pc_ptrs_centrl WHEN (rmaster_rx = '1') ELSE
                       reset_pc_ptrs_quad_up WHEN (rmaster_up_rx = '1') ELSE
                       reset_pc_ptrs_quad_down;
   
   -- write pointer
   PROCESS (rst_wclk, wr_clk)
   BEGIN
      IF (rst_wclk = '1') THEN
         wptr <=  TRANSPORT "00000001" AFTER 1 ps;
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         IF (rphfifo_regmode_rx = '1') THEN
            wptr <=  TRANSPORT "00000001" AFTER 1 ps;
         ELSIF (reset_ptrs_local = '1') THEN
            wptr <=  TRANSPORT "00000001" AFTER 1 ps;
         ELSE
            IF (we = '1') THEN
               wptr <=  TRANSPORT (wptr(6 DOWNTO 0) & wptr(7)) AFTER 1 ps;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   --newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use
   -- manually translated
   PROCESS(fifo_cnt_pre, rst_rclk, rptr1_bin, wptr1_bin_rclk)
   BEGIN
       IF (rptr1_bin = wptr1_bin_rclk) THEN
           IF (rst_rclk /= '1') THEN
               IF (fifo_cnt_pre = "0111" OR fifo_cnt_pre = "0110" OR fifo_cnt_pre = "1000") THEN
                   fifo_cnt <= "1000";
               ELSE
                   fifo_cnt <= "0000";
               END IF;    
           ELSE
               fifo_cnt <= "0000";
           END IF;
       ELSE
           IF (wptr1_bin_rclk > rptr1_bin) THEN
               fifo_cnt <= ('0' & (wptr1_bin_rclk - rptr1_bin));
           ELSE
               fifo_cnt <= ("1000" - ('0' & (rptr1_bin - wptr1_bin_rclk)));
           END IF;     
       END IF;
   END PROCESS;
   
   -- incorrect translation
   --fifo_cnt <= "1000" WHEN (fifo_cnt_pre = "0111" OR fifo_cnt_pre = "0110" OR fifo_cnt_pre = "1000") ELSE
   --            "0000" WHEN (rst_rclk /= '1') ELSE
   --            "0000" WHEN (rptr1_bin = wptr1_bin_rclk) ELSE
   --            ('0' & (wptr1_bin_rclk - rptr1_bin)) WHEN (wptr1_bin_rclk > rptr1_bin) ELSE
   --            ("1000" - ('0' & (rptr1_bin - wptr1_bin_rclk)));
   
   PROCESS (rst_rclk, rd_clk)
   BEGIN
      IF (rst_rclk = '1') THEN
         reset_ptrs_local_sync1 <=  TRANSPORT '0' AFTER 1 ps;
         reset_ptrs_local_sync2 <=  TRANSPORT '0' AFTER 1 ps;		-- if (rst_rclk == 1'b1)
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         IF (rphfifo_regmode_rx = '1') THEN
            reset_ptrs_local_sync1 <=  TRANSPORT '0' AFTER 1 ps;
            reset_ptrs_local_sync2 <=  TRANSPORT '0' AFTER 1 ps;
         ELSE
            reset_ptrs_local_sync1 <=  TRANSPORT reset_ptrs_local AFTER 1 ps;
            reset_ptrs_local_sync2 <=  TRANSPORT reset_ptrs_local_sync1 AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   -- always @ (posedge rst_rclk or posedge rd_clk)

    --ECO for S4GX to fix metastability issue
    -- replace the 1st FF with new flop w/o reset
    -- replace the 2nd FF with an enhanced flop
    PROCESS (rd_clk)
    BEGIN
        IF (rd_clk'EVENT AND rd_clk = '1') THEN
            IF (reset_ptrs_local_sync2 = '1' OR rphfifo_regmode_rx = '1') THEN
                wptr0 <=  TRANSPORT "001" AFTER 1 ps;
            ELSE
                wptr0 <=  TRANSPORT wptr_gray AFTER 1 ps;
            END IF;
        END IF;
    END PROCESS;     -- always @ (posedge rst_rclk or posedge rd_clk)
   
    PROCESS(rst_rclk, rd_clk)
    BEGIN
        IF (rst_rclk = '1') THEN
            wptr1 <=  TRANSPORT "001" AFTER 1 ps;
        ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
            IF ((reset_ptrs_local_sync2 OR rphfifo_regmode_rx) = '1') THEN
                wptr1 <=  TRANSPORT "001" AFTER 1 ps;
            ELSE
                wptr1 <=  TRANSPORT wptr0 AFTER 1 ps;
            END IF;
        END IF;
   END PROCESS; -- always @ (posedge rst_rclk or posedge rd_clk)
         
   -- read pointer
   -- full & empty
   PROCESS (rst_rclk, rd_clk)
   BEGIN
      IF (rst_rclk = '1') THEN
         --wptr0 <=  TRANSPORT "001" AFTER 1 ps;
         --wptr1 <=  TRANSPORT "001" AFTER 1 ps;
         rptr <=  TRANSPORT "00100000" AFTER 1 ps;
         rptr0_pre <=  TRANSPORT "00010000" AFTER 1 ps;
         rptr0 <=  TRANSPORT "00010000" AFTER 1 ps;
         rptr1 <=  TRANSPORT "00010000" AFTER 1 ps;
         ph_fifo_full_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;
         ph_fifo_empty <=  TRANSPORT '0' AFTER 1 ps;
         ph_fifo_empty_pre <=  TRANSPORT '0' AFTER 1 ps;
         first_rd <=  TRANSPORT '1' AFTER 1 ps;		-- fifo_cnt previous value
         fifo_cnt_pre <=  TRANSPORT "0000" AFTER 1 ps;		-- if (rst_rclk == 1'b1)
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         IF ((reset_ptrs_local_sync2 OR rphfifo_regmode_rx) = '1') THEN
            --wptr0 <=  TRANSPORT "001" AFTER 1 ps;
            --wptr1 <=  TRANSPORT "001" AFTER 1 ps;
            rptr <=  TRANSPORT "00100000" AFTER 1 ps;
            rptr0_pre <=  TRANSPORT "00010000" AFTER 1 ps;
            rptr0 <=  TRANSPORT "00010000" AFTER 1 ps;
            rptr1 <=  TRANSPORT "00010000" AFTER 1 ps;
            ph_fifo_full_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;
            ph_fifo_empty <=  TRANSPORT '0' AFTER 1 ps;
            ph_fifo_empty_pre <=  TRANSPORT '0' AFTER 1 ps;
            first_rd <=  TRANSPORT '1' AFTER 1 ps;		-- fifo_cnt previous value
            fifo_cnt_pre <=  TRANSPORT "0000" AFTER 1 ps;		-- if (reset_ptrs_local_sync2)
         ELSE
            ph_fifo_empty <=  TRANSPORT ph_fifo_empty_pre AFTER 1 ps;
            
            fifo_cnt_pre <=  TRANSPORT fifo_cnt AFTER 1 ps;
            
            --wptr0 <=  TRANSPORT wptr_gray AFTER 1 ps;
            --wptr1 <=  TRANSPORT wptr0 AFTER 1 ps;
            
            rptr0_pre <=  TRANSPORT rptr AFTER 1 ps;
            rptr0 <=  TRANSPORT rptr0_pre AFTER 1 ps;
            
            rptr1 <=  TRANSPORT rptr0 AFTER 1 ps;
            IF (first_rd = '1' AND re = '1') THEN
               
               -- advance by 2 on first read in low-latency mode
               first_rd <=  TRANSPORT '0' AFTER 1 ps;
            END IF;
            IF (re = '1') THEN
               IF (first_rd = '1' AND lowlatency_en = '1') THEN
                  rptr <=  TRANSPORT (rptr(5 DOWNTO 0) & rptr(7 DOWNTO 6)) AFTER 1 ps;
               ELSE
                  
                  -- full condition
                  --$if ({wptr1_onehot[6:0],wptr1_onehot[7]} == rptr1)
                  --new full flag requirement
                  rptr <=  TRANSPORT (rptr(6 DOWNTO 0) & rptr(7)) AFTER 1 ps;
               END IF;
            END IF;
            IF ( ((rptr1(6 DOWNTO 0) & rptr1(7)) = wptr1_onehot) AND (fifo_cnt_pre = "0111" OR fifo_cnt_pre = "1000") AND ((NOT ph_fifo_empty_pre) = '1') ) THEN
               --else if (ph_fifo_full == 1'b1 && ({rptr1[6:0],rptr1[7]} != wptr1_onehot)) //become sticky until reset
               --ph_fifo_full <= #1 1'b0;
               
               -- empty condition
               --$if ({rptr1[6:0],rptr1[7]} == wptr1_onehot)
               --new empty flag requirement
               ph_fifo_full_xhdl0 <=  TRANSPORT '1' AFTER 1 ps;
            END IF;
            IF (fifo_cnt = "0000" AND ((NOT(ph_fifo_full_xhdl0))) = '1') THEN
               --else if (ph_fifo_empty_pre == 1'b1 && (rptr1 != wptr1_onehot)) // become sticky until reset
               --ph_fifo_empty_pre <= #1 1'b0;
               ph_fifo_empty_pre <=  TRANSPORT '1' AFTER 1 ps;		-- else: !if(rst_rclk == 1'b1)
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge rst_rclk or posedge rd_clk)
   
   
   
   ram8x70_syn_1 : cycloneiv_hssi_rx_digis_ram8x70_syn
      PORT MAP (
         rst_l     => rst_n,
         clk       => wr_clk,
         fifo_wr   => wptr,
         data_in   => din,
         fifo_re   => rptr,
         data_out  => ram_data_out_pre
      );
   
   PROCESS (rst_rclk, rd_clk)
   BEGIN
      IF (rst_rclk = '1') THEN
         ram_data_out <=  TRANSPORT "0000000000000000000000000000000000000000000000000000000000000000000000" AFTER 1 ps;
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         IF (rphfifo_regmode_rx = '1') THEN
            ram_data_out <=  TRANSPORT din AFTER 1 ps;
         ELSE
            ram_data_out <=  TRANSPORT ram_data_out_pre AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge rst_rclk or posedge rd_clk)
   
   PROCESS (wptr)
   BEGIN
      CASE wptr IS
         WHEN "00000001" =>
            wptr_bin <= "000";
         WHEN "00000010" =>
            wptr_bin <= "001";
         WHEN "00000100" =>
            wptr_bin <= "010";
         WHEN "00001000" =>
            wptr_bin <= "011";
         WHEN "00010000" =>
            wptr_bin <= "100";
         WHEN "00100000" =>
            wptr_bin <= "101";
         WHEN "01000000" =>
            wptr_bin <= "110";
         WHEN "10000000" =>
            wptr_bin <= "111";
         WHEN OTHERS =>		-- case(wptr)
            wptr_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (wptr)
   
   PROCESS (rptr)
   BEGIN
      CASE rptr IS
         WHEN "00000001" =>
            rptr_bin <= "000";
         WHEN "00000010" =>
            rptr_bin <= "001";
         WHEN "00000100" =>
            rptr_bin <= "010";
         WHEN "00001000" =>
            rptr_bin <= "011";
         WHEN "00010000" =>
            rptr_bin <= "100";
         WHEN "00100000" =>
            rptr_bin <= "101";
         WHEN "01000000" =>
            rptr_bin <= "110";
         WHEN "10000000" =>
            rptr_bin <= "111";
         WHEN OTHERS =>		-- case(rptr)
            rptr_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr)
   
   PROCESS (rptr1)
   BEGIN
      CASE rptr1 IS
         WHEN "00000001" =>
            rptr1_bin <= "000";
         WHEN "00000010" =>
            rptr1_bin <= "001";
         WHEN "00000100" =>
            rptr1_bin <= "010";
         WHEN "00001000" =>
            rptr1_bin <= "011";
         WHEN "00010000" =>
            rptr1_bin <= "100";
         WHEN "00100000" =>
            rptr1_bin <= "101";
         WHEN "01000000" =>
            rptr1_bin <= "110";
         WHEN "10000000" =>
            rptr1_bin <= "111";
         WHEN OTHERS =>		-- case(rptr1)
            rptr1_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr1)
   
   PROCESS (rst_wclk, wr_clk)
   BEGIN
      IF (rst_wclk = '1') THEN
         wptr_gray <=  TRANSPORT "000" AFTER 1 ps;
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         wptr_gray <=  TRANSPORT wptr_gray0 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   
   PROCESS (wptr)
   BEGIN
      CASE wptr IS
         WHEN "00000001" =>
            wptr_gray0 <= "000";
         WHEN "00000010" =>
            wptr_gray0 <= "001";
         WHEN "00000100" =>
            wptr_gray0 <= "011";
         WHEN "00001000" =>
            wptr_gray0 <= "010";
         WHEN "00010000" =>
            wptr_gray0 <= "110";
         WHEN "00100000" =>
            wptr_gray0 <= "111";
         WHEN "01000000" =>
            wptr_gray0 <= "101";
         WHEN "10000000" =>
            wptr_gray0 <= "100";
         WHEN OTHERS =>		-- case(wptr)
            wptr_gray0 <= "000";
      END CASE;
   END PROCESS;
   
   -- always@ (wptr)
   
   PROCESS (wptr1)
   BEGIN
      CASE wptr1 IS
         WHEN "000" =>
            wptr1_onehot <= "00000001";
         WHEN "001" =>
            wptr1_onehot <= "00000010";
         WHEN "011" =>
            wptr1_onehot <= "00000100";
         WHEN "010" =>
            wptr1_onehot <= "00001000";
         WHEN "110" =>
            wptr1_onehot <= "00010000";
         WHEN "111" =>
            wptr1_onehot <= "00100000";
         WHEN "101" =>
            wptr1_onehot <= "01000000";
         WHEN "100" =>
            wptr1_onehot <= "10000000";
         WHEN OTHERS =>		-- case(wptr1)
            wptr1_onehot <= "10000000";
      END CASE;
   END PROCESS;
   
   -- always@ (wptr1)
   
   PROCESS (wptr1)
   BEGIN
      CASE wptr1 IS
         WHEN "000" =>
            wptr1_bin_rclk <= "000";
         WHEN "001" =>
            wptr1_bin_rclk <= "001";
         WHEN "011" =>
            wptr1_bin_rclk <= "010";
         WHEN "010" =>
            wptr1_bin_rclk <= "011";
         WHEN "110" =>
            wptr1_bin_rclk <= "100";
         WHEN "111" =>
            wptr1_bin_rclk <= "101";
         WHEN "101" =>
            wptr1_bin_rclk <= "110";
         WHEN "100" =>
            wptr1_bin_rclk <= "111";
         WHEN OTHERS =>		-- case(wptr1)
            wptr1_bin_rclk <= "000";
      END CASE;
   END PROCESS;
   
   
END trans;


-- always@ (wptr1)

-- ph_fifo_rx

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_rx_digis_ram16x14_syn IS
   GENERIC (
      
      read_access_time   : INTEGER := 0;
      write_access_time  : INTEGER := 0;
      ram_width          : INTEGER := 14
   );
   PORT (
      clk                : IN STD_LOGIC;
      rst_l              : IN STD_LOGIC;
      addr_wr            : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
      addr_rd1           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
      addr_rd2           : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
      data_in            : IN STD_LOGIC_VECTOR(13 DOWNTO 0);
      we                 : IN STD_LOGIC;
      re_l               : IN STD_LOGIC;
      data_out1          : OUT STD_LOGIC_VECTOR(13 DOWNTO 0);
      data_out2          : OUT STD_LOGIC_VECTOR(13 DOWNTO 0)
   );
END cycloneiv_hssi_rx_digis_ram16x14_syn;

ARCHITECTURE trans OF cycloneiv_hssi_rx_digis_ram16x14_syn IS
   
   SIGNAL data_out1_i    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_out2_i    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_0  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_1  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_2  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_3  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_4  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_5  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_6  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_7  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_8  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_9  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_10 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_11 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_12 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_13 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_14 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_15 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_0  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_1  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_2  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_3  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_4  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_5  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_6  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_7  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_8  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_9  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_10 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_11 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_12 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_13 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_14 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_15 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_0     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_1     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_2     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_3     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_4     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_5     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_6     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_7     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_8     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_9     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_10    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_11    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_12    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_13    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_14    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_15    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
BEGIN
   
   --assignment
   data_reg_0 <= data_in WHEN (addr_wr(0) = '1') ELSE
                 ram_array_q_0;
   data_reg_1 <= data_in WHEN (addr_wr(1) = '1') ELSE
                 ram_array_q_1;
   data_reg_2 <= data_in WHEN (addr_wr(2) = '1') ELSE
                 ram_array_q_2;
   data_reg_3 <= data_in WHEN (addr_wr(3) = '1') ELSE
                 ram_array_q_3;
   data_reg_4 <= data_in WHEN (addr_wr(4) = '1') ELSE
                 ram_array_q_4;
   data_reg_5 <= data_in WHEN (addr_wr(5) = '1') ELSE
                 ram_array_q_5;
   data_reg_6 <= data_in WHEN (addr_wr(6) = '1') ELSE
                 ram_array_q_6;
   data_reg_7 <= data_in WHEN (addr_wr(7) = '1') ELSE
                 ram_array_q_7;
   data_reg_8 <= data_in WHEN (addr_wr(8) = '1') ELSE
                 ram_array_q_8;
   data_reg_9 <= data_in WHEN (addr_wr(9) = '1') ELSE
                 ram_array_q_9;
   data_reg_10 <= data_in WHEN (addr_wr(10) = '1') ELSE
                  ram_array_q_10;
   data_reg_11 <= data_in WHEN (addr_wr(11) = '1') ELSE
                  ram_array_q_11;
   data_reg_12 <= data_in WHEN (addr_wr(12) = '1') ELSE
                  ram_array_q_12;
   data_reg_13 <= data_in WHEN (addr_wr(13) = '1') ELSE
                  ram_array_q_13;
   data_reg_14 <= data_in WHEN (addr_wr(14) = '1') ELSE
                  ram_array_q_14;
   data_reg_15 <= data_in WHEN (addr_wr(15) = '1') ELSE
                  ram_array_q_15;
   
   data_out1 <= "00000000000000" WHEN (re_l = '1') ELSE
                data_out1_i;
   data_out2 <= "00000000000000" WHEN (re_l = '1') ELSE
                data_out2_i;
   
   PROCESS (ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, ram_array_q_8, ram_array_q_9, ram_array_q_10, ram_array_q_11, ram_array_q_12, ram_array_q_13, ram_array_q_14, ram_array_q_15, addr_rd1, addr_rd2)
VARIABLE  txt : LINE;
   BEGIN
      CASE addr_rd1 IS		-- synopsys parallel_case full_case
         WHEN "0000000000000001" =>
            data_out1_i <= ram_array_q_0;
         WHEN "0000000000000010" =>
            data_out1_i <= ram_array_q_1;
         WHEN "0000000000000100" =>
            data_out1_i <= ram_array_q_2;
         WHEN "0000000000001000" =>
            data_out1_i <= ram_array_q_3;
         WHEN "0000000000010000" =>
            data_out1_i <= ram_array_q_4;
         WHEN "0000000000100000" =>
            data_out1_i <= ram_array_q_5;
         WHEN "0000000001000000" =>
            data_out1_i <= ram_array_q_6;
         WHEN "0000000010000000" =>
            data_out1_i <= ram_array_q_7;
         WHEN "0000000100000000" =>
            data_out1_i <= ram_array_q_8;
         WHEN "0000001000000000" =>
            data_out1_i <= ram_array_q_9;
         WHEN "0000010000000000" =>
            data_out1_i <= ram_array_q_10;
         WHEN "0000100000000000" =>
            data_out1_i <= ram_array_q_11;
         WHEN "0001000000000000" =>
            data_out1_i <= ram_array_q_12;
         WHEN "0010000000000000" =>
            data_out1_i <= ram_array_q_13;
         WHEN "0100000000000000" =>
            data_out1_i <= ram_array_q_14;
         WHEN "1000000000000000" =>
            data_out1_i <= ram_array_q_15;
         WHEN OTHERS =>
            NULL;
      END CASE;
      
      CASE addr_rd2 IS		-- synopsys parallel_case full_case
         WHEN "0000000000000001" =>
            data_out2_i <= ram_array_q_0;
         WHEN "0000000000000010" =>
            data_out2_i <= ram_array_q_1;
         WHEN "0000000000000100" =>
            data_out2_i <= ram_array_q_2;
         WHEN "0000000000001000" =>
            data_out2_i <= ram_array_q_3;
         WHEN "0000000000010000" =>
            data_out2_i <= ram_array_q_4;
         WHEN "0000000000100000" =>
            data_out2_i <= ram_array_q_5;
         WHEN "0000000001000000" =>
            data_out2_i <= ram_array_q_6;
         WHEN "0000000010000000" =>
            data_out2_i <= ram_array_q_7;
         WHEN "0000000100000000" =>
            data_out2_i <= ram_array_q_8;
         WHEN "0000001000000000" =>
            data_out2_i <= ram_array_q_9;
         WHEN "0000010000000000" =>
            data_out2_i <= ram_array_q_10;
         WHEN "0000100000000000" =>
            data_out2_i <= ram_array_q_11;
         WHEN "0001000000000000" =>
            data_out2_i <= ram_array_q_12;
         WHEN "0010000000000000" =>
            data_out2_i <= ram_array_q_13;
         WHEN "0100000000000000" =>
            data_out2_i <= ram_array_q_14;
         WHEN "1000000000000000" =>
            data_out2_i <= ram_array_q_15;
         WHEN OTHERS =>
            NULL;
      END CASE;
   END PROCESS;
   
   PROCESS (clk, rst_l)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rst_l)) = '1') THEN
         ram_array_q_0 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_1 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_2 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_3 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_4 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_5 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_6 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_7 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_8 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_9 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_10 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_11 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_12 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_13 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_14 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
         ram_array_q_15 <=  TRANSPORT "00000000000000" AFTER (write_access_time)*1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         ram_array_q_0 <=  TRANSPORT ram_array_d_0 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_1 <=  TRANSPORT ram_array_d_1 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_2 <=  TRANSPORT ram_array_d_2 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_3 <=  TRANSPORT ram_array_d_3 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_4 <=  TRANSPORT ram_array_d_4 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_5 <=  TRANSPORT ram_array_d_5 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_6 <=  TRANSPORT ram_array_d_6 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_7 <=  TRANSPORT ram_array_d_7 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_8 <=  TRANSPORT ram_array_d_8 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_9 <=  TRANSPORT ram_array_d_9 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_10 <=  TRANSPORT ram_array_d_10 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_11 <=  TRANSPORT ram_array_d_11 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_12 <=  TRANSPORT ram_array_d_12 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_13 <=  TRANSPORT ram_array_d_13 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_14 <=  TRANSPORT ram_array_d_14 AFTER (write_access_time)*1* 1 ps;
         ram_array_q_15 <=  TRANSPORT ram_array_d_15 AFTER (write_access_time)*1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (we, data_reg_0, data_reg_1, data_reg_2, data_reg_3, data_reg_4, data_reg_5, data_reg_6, data_reg_7, data_reg_8, data_reg_9, data_reg_10, data_reg_11, data_reg_12, data_reg_13, data_reg_14, data_reg_15, ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, ram_array_q_8, ram_array_q_9, ram_array_q_10, ram_array_q_11, ram_array_q_12, ram_array_q_13, ram_array_q_14, ram_array_q_15)
VARIABLE  txt : LINE;
   BEGIN
      IF (we = '1') THEN
         ram_array_d_0 <=  TRANSPORT data_reg_0 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_1 <=  TRANSPORT data_reg_1 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_2 <=  TRANSPORT data_reg_2 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_3 <=  TRANSPORT data_reg_3 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_4 <=  TRANSPORT data_reg_4 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_5 <=  TRANSPORT data_reg_5 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_6 <=  TRANSPORT data_reg_6 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_7 <=  TRANSPORT data_reg_7 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_8 <=  TRANSPORT data_reg_8 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_9 <=  TRANSPORT data_reg_9 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_10 <=  TRANSPORT data_reg_10 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_11 <=  TRANSPORT data_reg_11 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_12 <=  TRANSPORT data_reg_12 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_13 <=  TRANSPORT data_reg_13 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_14 <=  TRANSPORT data_reg_14 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_15 <=  TRANSPORT data_reg_15 AFTER (write_access_time)*1* 1 ps;
      ELSE
         ram_array_d_0 <=  TRANSPORT ram_array_q_0 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_1 <=  TRANSPORT ram_array_q_1 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_2 <=  TRANSPORT ram_array_q_2 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_3 <=  TRANSPORT ram_array_q_3 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_4 <=  TRANSPORT ram_array_q_4 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_5 <=  TRANSPORT ram_array_q_5 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_6 <=  TRANSPORT ram_array_q_6 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_7 <=  TRANSPORT ram_array_q_7 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_8 <=  TRANSPORT ram_array_q_8 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_9 <=  TRANSPORT ram_array_q_9 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_10 <=  TRANSPORT ram_array_q_10 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_11 <=  TRANSPORT ram_array_q_11 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_12 <=  TRANSPORT ram_array_q_12 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_13 <=  TRANSPORT ram_array_q_13 AFTER (write_access_time)*1* 1 ps;
         ram_array_d_14 <=  TRANSPORT ram_array_q_14 AFTER (write_access_time)*1* 1 ps;
         
         ram_array_d_15 <=  TRANSPORT ram_array_q_15 AFTER (write_access_time)*1* 1 ps;
      END IF;
   END PROCESS;
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.cycloneiv_hssi_components.all;

ENTITY cycloneiv_hssi_rx_digis_ram20x16_syn IS
   GENERIC (
      
      read_access_time   : INTEGER := 0;
      write_access_time  : INTEGER := 0;
      ram_width          : INTEGER := 16
   );
   PORT (
      data_in            : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
      clk                : IN STD_LOGIC;
      fifo_wr            : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
      rst_l              : IN STD_LOGIC;
      fifo_re1           : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
      fifo_re2           : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
      data_out1          : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
      data_out2          : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
   );
END cycloneiv_hssi_rx_digis_ram20x16_syn;

ARCHITECTURE trans OF cycloneiv_hssi_rx_digis_ram20x16_syn IS
   
   SIGNAL data_out1_i    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_out2_i    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_0  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_1  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_2  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_3  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_4  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_5  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_6  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_7  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_8  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_9  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_10 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_11 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_12 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_13 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_14 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_15 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_16 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_17 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_18 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_19 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_0  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_1  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_2  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_3  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_4  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_5  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_6  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_7  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_8  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_9  : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_10 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_11 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_12 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_13 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_14 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_15 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_16 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_17 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_18 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_19 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_0     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_1     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_2     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_3     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_4     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_5     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_6     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_7     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_8     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_9     : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_10    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_11    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_12    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_13    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_14    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_15    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_16    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_17    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_18    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_19    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   
   SIGNAL we             : STD_LOGIC;
   SIGNAL re_l           : STD_LOGIC;
BEGIN
   
   we <= '1';
   re_l <= '0';
   
   --assignment
   data_reg_0 <= data_in WHEN (fifo_wr(0) = '1') ELSE
                 ram_array_q_0;
   data_reg_1 <= data_in WHEN (fifo_wr(1) = '1') ELSE
                 ram_array_q_1;
   data_reg_2 <= data_in WHEN (fifo_wr(2) = '1') ELSE
                 ram_array_q_2;
   data_reg_3 <= data_in WHEN (fifo_wr(3) = '1') ELSE
                 ram_array_q_3;
   data_reg_4 <= data_in WHEN (fifo_wr(4) = '1') ELSE
                 ram_array_q_4;
   data_reg_5 <= data_in WHEN (fifo_wr(5) = '1') ELSE
                 ram_array_q_5;
   data_reg_6 <= data_in WHEN (fifo_wr(6) = '1') ELSE
                 ram_array_q_6;
   data_reg_7 <= data_in WHEN (fifo_wr(7) = '1') ELSE
                 ram_array_q_7;
   data_reg_8 <= data_in WHEN (fifo_wr(8) = '1') ELSE
                 ram_array_q_8;
   data_reg_9 <= data_in WHEN (fifo_wr(9) = '1') ELSE
                 ram_array_q_9;
   data_reg_10 <= data_in WHEN (fifo_wr(10) = '1') ELSE
                  ram_array_q_10;
   data_reg_11 <= data_in WHEN (fifo_wr(11) = '1') ELSE
                  ram_array_q_11;
   data_reg_12 <= data_in WHEN (fifo_wr(12) = '1') ELSE
                  ram_array_q_12;
   data_reg_13 <= data_in WHEN (fifo_wr(13) = '1') ELSE
                  ram_array_q_13;
   data_reg_14 <= data_in WHEN (fifo_wr(14) = '1') ELSE
                  ram_array_q_14;
   data_reg_15 <= data_in WHEN (fifo_wr(15) = '1') ELSE
                  ram_array_q_15;
   data_reg_16 <= data_in WHEN (fifo_wr(16) = '1') ELSE
                  ram_array_q_16;
   data_reg_17 <= data_in WHEN (fifo_wr(17) = '1') ELSE
                  ram_array_q_17;
   data_reg_18 <= data_in WHEN (fifo_wr(18) = '1') ELSE
                  ram_array_q_18;
   data_reg_19 <= data_in WHEN (fifo_wr(19) = '1') ELSE
                  ram_array_q_19;
   
   -- 03/22/05 VC: LEDA fix: Remove delay on combinatorial statement
   --                        and changed 15'b0 to 16'd0
   --assign #read_access_time data_out1 = re_l ? 15'b0 : data_out1_i;
   --assign #read_access_time data_out2 = re_l ? 15'b0 : data_out2_i;
   data_out1 <= "0000000000000000" WHEN (re_l = '1') ELSE
                data_out1_i;
   data_out2 <= "0000000000000000" WHEN (re_l = '1') ELSE
                data_out2_i;
   
   PROCESS (ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, ram_array_q_8, ram_array_q_9, ram_array_q_10, ram_array_q_11, ram_array_q_12, ram_array_q_13, ram_array_q_14, ram_array_q_15, ram_array_q_16, ram_array_q_17, ram_array_q_18, ram_array_q_19, fifo_re1, fifo_re2)
VARIABLE  txt : LINE;
   BEGIN
      -- 03/22/05 VC: Removed full case statement because
      --              not all cases are listed
      --    case ( fifo_re1 )  // synopsys parallel_case full_case
      CASE fifo_re1 IS		-- synopsys parallel_case
         WHEN "00000000000000000001" =>
            data_out1_i <= ram_array_q_0;
         WHEN "00000000000000000010" =>
            data_out1_i <= ram_array_q_1;
         WHEN "00000000000000000100" =>
            data_out1_i <= ram_array_q_2;
         WHEN "00000000000000001000" =>
            data_out1_i <= ram_array_q_3;
         WHEN "00000000000000010000" =>
            data_out1_i <= ram_array_q_4;
         WHEN "00000000000000100000" =>
            data_out1_i <= ram_array_q_5;
         WHEN "00000000000001000000" =>
            data_out1_i <= ram_array_q_6;
         WHEN "00000000000010000000" =>
            data_out1_i <= ram_array_q_7;
         WHEN "00000000000100000000" =>
            data_out1_i <= ram_array_q_8;
         WHEN "00000000001000000000" =>
            data_out1_i <= ram_array_q_9;
         WHEN "00000000010000000000" =>
            data_out1_i <= ram_array_q_10;
         WHEN "00000000100000000000" =>
            data_out1_i <= ram_array_q_11;
         WHEN "00000001000000000000" =>
            data_out1_i <= ram_array_q_12;
         WHEN "00000010000000000000" =>
            data_out1_i <= ram_array_q_13;
         WHEN "00000100000000000000" =>
            data_out1_i <= ram_array_q_14;
         WHEN "00001000000000000000" =>
            data_out1_i <= ram_array_q_15;
         WHEN "00010000000000000000" =>
            data_out1_i <= ram_array_q_16;
         WHEN "00100000000000000000" =>
            data_out1_i <= ram_array_q_17;
         WHEN "01000000000000000000" =>
            data_out1_i <= ram_array_q_18;
         -- 03/22/05 VC: LEDA fix: Added default clause to case statem