# (C) 2001-2010 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera MegaCore Function License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# +-----------------------------------
# | 
# | m_splitter - signal/bus termination
# | 
# +-----------------------------------

package require -exact sopc 9.1

# module simple_streaming
set_module_property NAME m_splitter
set_module_property VERSION 10.0
set_module_property INTERNAL true
set_module_property GROUP "Local/alt_xaui sub-blocks"
set_module_property DISPLAY_NAME m_splitter
#set_module_property TOP_LEVEL_HDL_FILE m_splitter.v
set_module_property TOP_LEVEL_HDL_MODULE m_splitter
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property ANALYZE_HDL FALSE
set_module_property SIMULATION_MODEL_IN_VERILOG 1
#
set_module_property ELABORATION_CALLBACK m_splitter_elaborate
set_module_property GENERATION_CALLBACK  m_splitter_generate
set_module_property SIMULATION_MODEL_IN_VERILOG 1

# files
#add_file m_splitter.v {SYNTHESIS SIMULATION}

# helper functions
source ipcc_tcl_helper.tcl

# parameters
add_param_int_not_hdl number_of_outputs   2 {0:999} ""
add_param_int_not_hdl input_bus_width     1 {0:999} ""
add_param_int_not_hdl output_bus_width    1 {0:999} ""

add_clock_interface     clk       end    1

proc m_splitter_elaborate {} {
    set NUM_OUT [get_parameter_value number_of_outputs]
    set IBWIDTH [get_parameter_value input_bus_width]
    set OBWIDTH [get_parameter_value output_bus_width]

    add_streaming_interface split_in end $IBWIDTH clk

    for { set i 0 } { $i < $NUM_OUT } { incr i } {
        if { $NUM_OUT == 1 } { set sfx "" } else { set sfx "_$i" }
        add_streaming_interface split_out$sfx start $OBWIDTH clk
    }
}

proc m_splitter_generate {} {
    set NUM_OUT [get_parameter_value number_of_outputs]
    set IBWIDTH  [get_parameter_value input_bus_width]
    set OBWIDTH [get_parameter_value output_bus_width]

    set this_dir      [ get_module_property MODULE_DIRECTORY ]
    set terp_file     [ file join $this_dir "../../merlin/lib/terp.tcl" ]
    set template_file [ file join $this_dir "m_splitter.v.terp" ]
    source $terp_file

    set output_dir  [ get_generation_property OUTPUT_DIRECTORY ]
    set output_name [ get_generation_property OUTPUT_NAME ]
    set template    [ read [ open $template_file r ] ]

    set params(output_name) $output_name
    set params(NUM_OUT)     $NUM_OUT
    set params(IBWIDTH)     $IBWIDTH
    set params(OBWIDTH)     $OBWIDTH

    set result          [ terp $template params ]
    set output_file     [ file join $output_dir ${output_name}.v ]
    set output_handle   [ open $output_file w ]

    puts $output_handle $result
    close $output_handle

    add_file ${output_file} {SIMULATION SYNTHESIS}
}

