# (C) 2001-2010 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera MegaCore Function License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# +-----------------------------------
# |
# | alt_xaui v1.0
# | ishimony 2009.08.12
# |
# +-----------------------------------

package require -exact sopc 9.1
sopc::preview_add_transform name preview_avalon_mm_transform

#
# User SIF (system interconnect fabric) Avalon Memory Mapped Bus
#
# Base address is <external_base_addr> 
# These offsets are byte-addresses
#0x0 = PHY common
#0x80 = PMA controller
#0x100 = Reset controller (for soft XAUI, reset controller and pma ch controller are combined inside alt_pma)
#0x180 = PMA Ch Controller
#0x200 = PCS
#0x400 = XCVR Reconfig
#
# Currently (10.0), only one instance is supported.  In the future, the first register
#  in the PCS space (0x200) will become an 'instance' register for indirection.  This
#  register will select which XAUI instance is to be controlled.  For now, the space
#  is reserved. 

# module alt_xaui
set_module_property NAME alt_xaui
set_module_property AUTHOR Altera
set_module_property DESCRIPTION "XGMII to XAUI transceiver"
set_module_property VERSION 10.0
set_module_property INTERNAL false
set_module_property GROUP "Interface Protocols/Ethernet"
set_module_property DISPLAY_NAME "XAUI PHY"
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property SIMULATION_MODEL_IN_VERILOG true
set_module_property ANALYZE_HDL FALSE
set_module_property DATASHEET_URL "http://www.altera.com/literature/ug/xcvr_user_guide.pdf"

# enable callbacks
set_module_property COMPOSE_CALLBACK     alt_xaui_compose
set_module_property VALIDATION_CALLBACK  alt_xaui_validate
#set_module_property ELABORATION_CALLBACK alt_xaui_elaborate
#set_module_property GENERATION_CALLBACK  alt_xaui_generate
# |
# +-----------------------------------

# +-----------------------------------
# | files
# |
#add_file alt_xaui.v                                     {SYNTHESIS SIMULATION}
# |
# +-----------------------------------

# +-----------------------------------
# | tabs
# |
add_display_item "" "General Options"           GROUP tab
add_display_item "" "Analog Options" GROUP tab
add_display_item "" "Advanced Options"  GROUP tab
# |
# +-----------------------------------

add_display_item "Analog Options" sv_message_text TEXT "These options are only available for family Stratix IV."

#
# Helper Routines
#-----------------
source ipcc_tcl_helper.tcl

proc add_instance_clocks { num_interfaces } {
#--- refclk ---
  add_instance             refclk clock_source
    set_instance_parameter refclk clockFrequency      "156250000"
    set_instance_parameter refclk clockFrequencyKnown "true"

#--- xgmii_tx_clk ---
  for { set i 0 } { $i < $num_interfaces } { incr i } {
  add_instance             xgmii_tx_clk_$i clock_source
    set_instance_parameter xgmii_tx_clk_$i clockFrequency      "156250000"
    set_instance_parameter xgmii_tx_clk_$i clockFrequencyKnown "true"
  }

#--- avmm_clk --- renamed to mgmt_clk
  add_instance             mgmt_clk clock_source
    set_instance_parameter mgmt_clk clockFrequency      "50000000"
    set_instance_parameter mgmt_clk clockFrequencyKnown "true"

}

#--- alt_pma ---
proc add_instance_alt_pma { name starting_ch_num } {
  add_instance           $name alt_pma
  set_instance_parameter $name gui_split_interfaces         "false"
##  set_instance_parameter $name device_family                "Stratix IV"
  set_instance_parameter $name number_of_channels           "4"
  set_instance_parameter $name gui_support_reconfig         "true"
  set_instance_parameter $name operation_mode               "DUPLEX"
  set_instance_parameter $name phase_comp_fifo_mode         "NONE"
  set_instance_parameter $name serialization_factor         "20"
  set_instance_parameter $name data_rate                    "3125 Mbps"
  set_instance_parameter $name pll_input_frequency          "156.25 MHz"
  set_instance_parameter $name gui_add_pll_pdn              "true"
  set_instance_parameter $name gui_add_pll_locked           "true"
  set_instance_parameter $name gui_add_rx_is_lockedtoref    "true"
  set_instance_parameter $name gui_add_rx_is_lockedtodata   "true"
  set_instance_parameter $name gui_support_cal              "true"
  set_instance_parameter $name number_pll_inclks            "1"
  set_instance_parameter $name pll_inclk_select             "0"
  set_instance_parameter $name rx_use_cruclk                "FALSE"
  set_instance_parameter $name intended_device_variant      "ANY"

  set_instance_parameter $name pll_type [get_parameter_value xaui_pll_type]
  set_instance_parameter $name starting_channel_number      $starting_ch_num
  set_instance_parameter $name bonded_mode                  "TRUE"
  get_set_parameter      $name tx_termination
  get_set_parameter      $name rx_common_mode
  get_set_parameter      $name rx_termination
  get_set_parameter      $name tx_preemp_pretap
  get_set_parameter      $name tx_preemp_pretap_inv
  get_set_parameter      $name tx_preemp_tap_1
  get_set_parameter      $name tx_preemp_tap_2
  get_set_parameter      $name tx_preemp_tap_2_inv
  get_set_parameter      $name tx_vod_selection
  get_set_parameter      $name rx_eq_dc_gain
  get_set_parameter      $name rx_eq_ctrl
}

#--- alt_pma_ch_controller ---
proc add_instance_alt_pma_ch_controller { name starting_ch_num } {
  add_instance           $name alt_pma_ch_controller
  set_instance_parameter $name number_of_channels      "4"
  set_instance_parameter $name sync_depth              "2"
}

#--- alt_pma_controller ---
proc add_instance_alt_pma_controller { name } {
  add_instance           $name alt_pma_controller
  set_instance_parameter $name number_of_plls  "1"
  set_instance_parameter $name sync_depth      "2"
}

#--- reconfig ---
proc add_instance_reconfig { name num_interfaces } {
  add_instance           $name  alt_xcvr_reconfig
  set_instance_parameter $name  number_of_reconfig_interfaces $num_interfaces
  set_instance_parameter $name  gui_enable_adce "on"
}

proc add_instance_togxbsplit { name num_interfaces } {
#--- m_splitter for 'to_gxb' bus ---
  add_instance           ${name}_split_togxb m_splitter
  set_instance_parameter ${name}_split_togxb number_of_outputs "4"
  set_instance_parameter ${name}_split_togxb input_bus_width   "4"
  set_instance_parameter ${name}_split_togxb output_bus_width  "1"
}

proc add_instance_astac_op { name width} {
#--- m_splitter for 'to_gxb' bus ---
  add_instance           ${name} astac_op
  set_instance_parameter ${name} N_TERM "2"
  set_instance_parameter ${name} N_TYPE "avalon_streaming"
  set_instance_parameter ${name} N_OP   "split"
  set_instance_parameter ${name} dataBitsPerSymbol ${width}
  set_instance_parameter ${name} symbolsPerBeat "1"
}

# parameters - alt_xaui
add_param_str device_family  "Stratix IV" {"Stratix IV" "Stratix V"} "General Options"
set_parameter_property device_family SYSTEM_INFO {DEVICE_FAMILY}
set_parameter_property device_family DESCRIPTION \
  "Possible values are \"Stratix IV\" or \"Stratix V\""
set_parameter_property device_family DISPLAY_NAME \
  "Device family"

add_param_int starting_channel_number   0 {0:127} "General Options"
set_parameter_property starting_channel_number DESCRIPTION \
  "Possible values are from 0 to 127"
set_parameter_property starting_channel_number DISPLAY_NAME \
  "Starting channel number"

add_param_str interface_type "Soft XAUI" {"Hard XAUI" "Soft XAUI"}   "General Options"
set_parameter_property interface_type DESCRIPTION \
  "Select whether to use hard PCS XAUI or soft PCS XAUI"
set_parameter_property interface_type DISPLAY_NAME \
  "XAUI interface type"

add_param_int number_of_interfaces 1 {1} "General Options"
set_parameter_property number_of_interfaces ENABLED false
set_parameter_property number_of_interfaces DESCRIPTION \
  "Currently limited to 1 (one) instance"
set_parameter_property number_of_interfaces DISPLAY_NAME \
  "Number of XAUI interfaces"

add_param_str xaui_pll_type CMU {"CMU" "ATX"} "Advanced Options"
set_parameter_property xaui_pll_type DESCRIPTION \
  "Specify the soft XAUI PLL type: CMU or ATX (LC tank)"
set_parameter_property xaui_pll_type DISPLAY_NAME \
  "Soft XAUI PLL type"

add_param_bool use_control_and_status_ports 0 "Advanced Options"
set_parameter_property use_control_and_status_ports DESCRIPTION \
  "Expose control and status ports at the top level"
set_parameter_property use_control_and_status_ports DISPLAY_NAME\
  "Include control and status ports"

add_param_bool external_pma_ctrl_reconf 0 "Advanced Options"
set_parameter_property external_pma_ctrl_reconf DESCRIPTION \
  "Use external PMA controller and reconfig"
set_parameter_property external_pma_ctrl_reconf DISPLAY_NAME \
  "External PMA control and configuration"

add_param_str tx_termination                OCT_100_OHMS \
  {OCT_85_OHMS OCT_100_OHMS OCT_120_OHMS OCT_150_OHMS}  "Analog Options"
set_parameter_property tx_termination DESCRIPTION \
  "Possible values are OCT_85_OHMS, OCT_100_OHMS, OCT_120_OHMS, or OCT_150_OHMS"
set_parameter_property tx_termination DISPLAY_NAME \
  "Transmitter termination resistance"

add_param_int tx_vod_selection          1 {0:7}         "Analog Options"
set_parameter_property tx_vod_selection DESCRIPTION \
  "Possible values are from 0 to 7"
set_parameter_property tx_vod_selection DISPLAY_NAME \
  "Transmitter VOD control setting"
  
add_param_int tx_preemp_pretap          0 {0:7}         "Analog Options"
set_parameter_property tx_preemp_pretap DESCRIPTION \
  "Possible values are from 0 to 7"
set_parameter_property tx_preemp_pretap DISPLAY_NAME \
  "Pre-emphasis pre-tap setting"

add_param_bool tx_preemp_pretap_inv     0               "Analog Options"
set_parameter_property tx_preemp_pretap_inv DESCRIPTION \
  "Select this option to invert the pre-emphasis pre-tap polarity"
set_parameter_property tx_preemp_pretap_inv DISPLAY_NAME \
  "Pre-emphasis pre-tap polarity setting"

add_param_int tx_preemp_tap_1           5 {0:15}        "Analog Options"
set_parameter_property tx_preemp_tap_1 DESCRIPTION \
  "Possible values are from 0 to 15"
set_parameter_property tx_preemp_tap_1 DISPLAY_NAME \
  "Pre-emphasis first post-tap setting"

add_param_int tx_preemp_tap_2           0 {0:7}         "Analog Options"
set_parameter_property tx_preemp_tap_2 DESCRIPTION \
  "Possible values are from 0 to 7"
set_parameter_property tx_preemp_tap_2 DISPLAY_NAME \
  "Pre-emphasis second post-tap setting"

add_param_bool tx_preemp_tap_2_inv      0               "Analog Options"
set_parameter_property tx_preemp_tap_2_inv DESCRIPTION \
  "Select this option to invert the pre-emphasis second post-tap polarity"
set_parameter_property tx_preemp_tap_2_inv DISPLAY_NAME \
  "Pre-emphasis second post-tap polarity setting"

add_param_str rx_common_mode                0.82v \
  {TRISTATE 0.82v 1.1v}                                 "Analog Options"
set_parameter_property rx_common_mode DESCRIPTION \
  "Possible values are TRISTATE, 0.82v, or 1.1v"
set_parameter_property rx_common_mode DISPLAY_NAME \
  "Receiver common mode voltage"

add_param_str rx_termination                OCT_100_OHMS \
  {OCT_85_OHMS OCT_100_OHMS OCT_120_OHMS OCT_150_OHMS}  "Analog Options"
set_parameter_property rx_termination DESCRIPTION \
  "Possible values are OCT_85_OHMS, OCT_100_OHMS, OCT_120_OHMS, or OCT_150_OHMS"
set_parameter_property rx_termination DISPLAY_NAME \
  "Receiver termination resistance"

add_param_int rx_eq_dc_gain             0 {0:4}         "Analog Options"
set_parameter_property rx_eq_dc_gain DESCRIPTION \
  "Possible values are from 0 to 4"
set_parameter_property rx_eq_dc_gain DISPLAY_NAME \
  "Receiver DC gain"

add_param_int rx_eq_ctrl                14 {0:16}       "Analog Options"
set_parameter_property rx_eq_ctrl DESCRIPTION \
  "Possible values are from 0 to 16"
set_parameter_property rx_eq_ctrl DISPLAY_NAME \
  "Receiver static equalizer setting"

#
# Compose
#----------
proc alt_xaui_compose { } {
  send_message info "alt_xaui_compose"

# get compose parameters
  set num_interfaces [get_parameter_value number_of_interfaces]
  set interface      [get_parameter_value interface_type]
  set dev_family  	 [get_parameter_value device_family]
  if {$interface == "Soft XAUI"} {
    set num_hxaui      0
    set num_sxaui      1
  } else {
    set num_hxaui      1
    set num_sxaui      0
  }
  set use_cs_ports   [get_parameter_value use_control_and_status_ports]
  set num_ch         [get_parameter_value starting_channel_number]

    if { [get_parameter_value external_pma_ctrl_reconf] } {
        set internal_pcr 0
    } else {
        set internal_pcr 1
    }

    if { $internal_pcr } {
        send_message info "Using internal pma control and reconfig"
    } else {
        send_message info "Using external pma control and reconfig"
    }

#
# clock sources
#---------------
  add_instance_clocks $num_interfaces

#
# Instantiations
#----------------

# for now just duplicate
  for { set i 0 } { $i < $num_sxaui } { incr i } {
    add_instance_alt_pma            alt_pma_$i [expr $num_ch + 4 * $i ]
#This is a workaround for SPR 338564 - this should be fixed in 10.1
    set asdf [get_instance_interfaces alt_pma_0]
    add_instance_togxbsplit         alt_xcvr_reconfig_$i "4"
    add_instance_astac_op           astac_op_soft_plllocked_$i "1"
    if { $internal_pcr } {
        add_instance_alt_pma_controller alt_pma_controller_$i
        add_instance_reconfig           alt_xcvr_reconfig_$i "4"
    }
  }
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
    set x [expr $num_ch + 4 * $i ]
    add_instance_alt_pma_ch_controller  alt_pma_ch_controller_$i $x
    add_instance_togxbsplit             alt_xcvr_reconfig_$i "1"
    add_instance_astac_op               astac_op_reconfigtogxb_$i "4"
      if { $internal_pcr } {
          add_instance_alt_pma_controller     alt_pma_controller_$i
          add_instance_reconfig               alt_xcvr_reconfig_$i "1"
          add_instance_astac_op               astac_op_plllocked_$i "1"
      } else { ; # external reconfig - need to replicate the togxb bus
          add_instance_astac_op astac_op_plllocked_$i "1"
      }
  }

# +-----------------------------------
# | Merlin Master Translator
# |
 #
    add_instance merlin_master_translator altera_merlin_master_translator
    set_instance_parameter merlin_master_translator AV_ADDRESS_W "16"
    set_instance_parameter merlin_master_translator AV_DATA_W "32"
    set_instance_parameter merlin_master_translator AV_BURSTCOUNT_W "1"
    set_instance_parameter merlin_master_translator AV_BYTEENABLE_W "4"
    set_instance_parameter merlin_master_translator UAV_ADDRESS_W "12"
    set_instance_parameter merlin_master_translator UAV_BURSTCOUNT_W "3"
    set_instance_parameter merlin_master_translator AV_READLATENCY "0"
    set_instance_parameter merlin_master_translator AV_WRITE_WAIT "0"
    set_instance_parameter merlin_master_translator AV_READ_WAIT "0"
    set_instance_parameter merlin_master_translator AV_DATA_HOLD "0"
    set_instance_parameter merlin_master_translator AV_SETUP_WAIT "0"
    set_instance_parameter merlin_master_translator USE_READDATA "1"
    set_instance_parameter merlin_master_translator USE_WRITEDATA "1"
    set_instance_parameter merlin_master_translator USE_READ "1"
    set_instance_parameter merlin_master_translator USE_WRITE "1"
    set_instance_parameter merlin_master_translator USE_BEGINBURSTTRANSFER "0"
    set_instance_parameter merlin_master_translator USE_BEGINTRANSFER "0"
    set_instance_parameter merlin_master_translator USE_BYTEENABLE "0"
    set_instance_parameter merlin_master_translator USE_CHIPSELECT "0"
    set_instance_parameter merlin_master_translator USE_ADDRESS "1"
    set_instance_parameter merlin_master_translator USE_BURSTCOUNT "0"
    set_instance_parameter merlin_master_translator USE_READDATAVALID "0"
    set_instance_parameter merlin_master_translator USE_WAITREQUEST "1"
    set_instance_parameter merlin_master_translator USE_ARBITERLOCK "0"
    set_instance_parameter merlin_master_translator AV_SYMBOLS_PER_WORD "4"
    set_instance_parameter merlin_master_translator AV_ADDRESS_SYMBOLS "0"
    set_instance_parameter merlin_master_translator AV_BURSTCOUNT_SYMBOLS "0"
    set_instance_parameter merlin_master_translator AV_CONSTANT_BURST_BEHAVIOR "0"
    set_instance_parameter merlin_master_translator AV_LINEWRAPBURSTS "0"
    set_instance_parameter merlin_master_translator AV_MAX_PENDING_READ_TRANSACTIONS "0"
    set_instance_parameter merlin_master_translator AV_BURSTBOUNDARIES "0"
    set_instance_parameter merlin_master_translator AV_INTERLEAVEBURSTS "0"
    set_instance_parameter merlin_master_translator AV_BITS_PER_SYMBOL "8"
    set_instance_parameter merlin_master_translator AV_ISBIGENDIAN "0"
    set_instance_parameter merlin_master_translator AV_ADDRESSGROUP "0"
    set_instance_parameter merlin_master_translator UAV_ADDRESSGROUP "0"
    set_instance_parameter merlin_master_translator AV_REGISTEROUTGOINGSIGNALS "0"
    set_instance_parameter merlin_master_translator AV_REGISTERINCOMINGSIGNALS "0"
    set_instance_parameter merlin_master_translator AV_ALWAYSBURSTMAXBURST "0"

    add_connection mgmt_clk.clk/merlin_master_translator.clk
    add_connection mgmt_clk.clk_reset/merlin_master_translator.reset




#--- control/startus registers hxaui_csr:hxaui_csr_i ---
  for { set i 0 } { $i < $num_interfaces } { incr i } {
    add_instance hxaui_csr_$i hxaui_csr
  }

#--- soft pcs ---
  for { set i 0 } { $i < $num_sxaui } { incr i } {
    add_instance           sxaui_$i sxaui
    set_instance_parameter sxaui_$i \
      use_control_and_status_ports $use_cs_ports
    set_instance_parameter sxaui_$i \
      starting_channel_number [expr $num_ch + 4 * $i ]
  }

#--- hard pcs ---
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
    add_instance           hxaui_$i hxaui
    set_instance_parameter hxaui_$i \
      use_control_and_status_ports $use_cs_ports
    set_instance_parameter hxaui_$i \
      starting_channel_number [expr $num_ch + 4 * $i ]
    get_set_parameter hxaui_$i tx_termination
    get_set_parameter hxaui_$i rx_common_mode
    get_set_parameter hxaui_$i rx_termination
    get_set_parameter hxaui_$i tx_preemp_pretap
    get_set_parameter hxaui_$i tx_preemp_pretap_inv
    get_set_parameter hxaui_$i tx_preemp_tap_1
    get_set_parameter hxaui_$i tx_preemp_tap_2
    get_set_parameter hxaui_$i tx_preemp_tap_2_inv
    get_set_parameter hxaui_$i tx_vod_selection
    get_set_parameter hxaui_$i rx_eq_dc_gain
    get_set_parameter hxaui_$i rx_eq_ctrl
  }

#
# ports
#-------

# clocks
  add_export_if refclk              clock   end   refclk.clk_in
  for { set i 0 } { $i < $num_sxaui } { incr i } {
      if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }

      add_export_if xgmii_tx_clk$sfx        clock   end xgmii_tx_clk_$i.clk_in
      add_export_if xgmii_rx_clk$sfx        clock start sxaui_$i.xgmii_rx_clk
  }
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
      if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }
      add_export_if xgmii_tx_clk$sfx        clock   end xgmii_tx_clk_$i.clk_in
      add_export_if xgmii_rx_clk$sfx        clock start hxaui_$i.xgmii_rx_clk
  }


  add_export_if mgmt_clk           clock   end   mgmt_clk.clk_in
  add_export_if mgmt_clk_rst       reset   end   mgmt_clk.clk_in_reset

# User memory mapped bus interface
#  add_export_if phy_mgmt           avalon end    demux_ports.avalon_slave
  add_export_if phy_mgmt           avalon end    merlin_master_translator.avalon_anti_master_0

#--- soft pcs ports ---
  for { set i 0 } { $i < $num_sxaui } { incr i } {

      if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }

# xgmii
      add_export_if     xgmii_tx_dc$sfx st end   sxaui_$i.xgmii_tx_dc
      add_export_if     xgmii_rx_dc$sfx st start sxaui_$i.xgmii_rx_dc

# serial
      add_export_if xaui_tx_serial$sfx conduit start alt_pma_$i.tx_serial_data
      add_export_if xaui_rx_serial$sfx conduit end   alt_pma_$i.rx_serial_data

# ctrl_stat: control and status: soft+hard
      if { $use_cs_ports } {
        add_export_if rx_digitalreset$sfx   st end   sxaui_$i.rx_digitalreset
        add_export_if tx_digitalreset$sfx   st end   sxaui_$i.tx_digitalreset
        add_export_if rx_channelaligned$sfx st start sxaui_$i.rx_channelaligned
        add_export_if rx_syncstatus$sfx     st start sxaui_$i.rx_syncstatus
        add_export_if rx_disperr$sfx        st start sxaui_$i.rx_disperr
        add_export_if rx_errdetect$sfx      st start sxaui_$i.rx_errdetect
    }
  }

#--- hard pcs ports ---
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {

    if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }

# xgmii
    add_export_if xgmii_tx_dc$sfx st end   hxaui_$i.xgmii_tx_dc
    add_export_if xgmii_rx_dc$sfx st start hxaui_$i.xgmii_rx_dc

# serial
    add_export_if xaui_tx_serial$sfx conduit start hxaui_$i.xaui_tx_serial
    add_export_if xaui_rx_serial$sfx conduit end   hxaui_$i.xaui_rx_serial

# ctrl_stat: control and status: soft+hard
    if { $use_cs_ports } {
      add_export_if rx_analogreset$sfx     st end   hxaui_$i.rx_analogreset
      add_export_if rx_digitalreset$sfx    st end   hxaui_$i.rx_digitalreset
      add_export_if tx_digitalreset$sfx    st end   hxaui_$i.tx_digitalreset
      add_export_if rx_channelaligned$sfx  st start hxaui_$i.rx_channelaligned
      add_export_if rx_invpolarity$sfx     st end   hxaui_$i.rx_invpolarity
      add_export_if rx_set_locktodata$sfx  st end   hxaui_$i.rx_set_locktodata
      add_export_if rx_set_locktoref$sfx   st end   hxaui_$i.rx_set_locktoref
      add_export_if rx_seriallpbken$sfx    st end   hxaui_$i.rx_seriallpbken
      add_export_if tx_invpolarity$sfx     st end   hxaui_$i.tx_invpolarity
      add_export_if rx_is_lockedtodata$sfx st start hxaui_$i.rx_is_lockedtodata
      add_export_if rx_phase_comp_fifo_error$sfx st \
          start hxaui_$i.rx_phase_comp_fifo_error
      add_export_if rx_is_lockedtoref$sfx  st start hxaui_$i.rx_is_lockedtoref
      add_export_if rx_rlv$sfx             st start hxaui_$i.rx_rlv
      add_export_if rx_rmfifoempty$sfx     st start hxaui_$i.rx_rmfifoempty
      add_export_if rx_rmfifofull$sfx      st start hxaui_$i.rx_rmfifofull
      add_export_if tx_phase_comp_fifo_error$sfx st \
          start hxaui_$i.tx_phase_comp_fifo_error
      add_export_if rx_disperr$sfx         st start hxaui_$i.rx_disperr
      add_export_if rx_errdetect$sfx       st start hxaui_$i.rx_errdetect
      add_export_if rx_patterndetect$sfx   st start hxaui_$i.rx_patterndetect
      add_export_if rx_rmfifodatadeleted$sfx     st \
          start hxaui_$i.rx_rmfifodatadeleted
      add_export_if rx_rmfifodatainserted$sfx    st \
          start hxaui_$i.rx_rmfifodatainserted
      add_export_if rx_runningdisp$sfx     st start hxaui_$i.rx_runningdisp
      add_export_if rx_syncstatus$sfx      st start hxaui_$i.rx_syncstatus
    }
  }

#--- external pma control reconfig option ---
    if { $internal_pcr == 0 } {
      for { set i 0 } { $i < $num_sxaui } { incr i } {

        if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }

        add_export_if cal_blk_pdn$sfx st end alt_pma_$i.cal_blk_pdn
        add_export_if pll_pdn$sfx     st end alt_pma_$i.pll_pdn

        add_export_if pll_locked$sfx  st start alt_pma_$i.pll_locked

		# The reconfig_from_gxb and reconfig_to_gxb are
		# not supported for Stratix V.  Only expose these
		# ports for Stratix IV.
		if {$dev_family == "Stratix IV"} {
                        add_export_if gx_pdn$sfx            st end alt_pma_$i.gx_pdn
			add_export_if reconfig_from_gxb$sfx st start alt_pma_$i.reconfig_from_gxb$i
			add_export_if reconfig_to_gxb$sfx   st end alt_pma_$i.reconfig_to_gxb
		}
      }

      for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {

        if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }

        add_export_if cal_blk_pdn$sfx st end hxaui_$i.r_cal_blk_powerdown
        add_export_if pll_pdn$sfx     st end hxaui_$i.r_pll_powerdown
        add_export_if gxb_pdn$sfx     st end hxaui_$i.r_gxb_powerdown

        add_export_if pll_locked$sfx st start astac_op_plllocked_${i}.source0
        add_export_if reconfig_from_gxb$sfx st start hxaui_$i.reconfig_fromgxb

        add_export_if reconfig_to_gxb$sfx   st end astac_op_reconfigtogxb_$i.sink0


        if {$dev_family == "Stratix IV"} {
			ac \
				astac_op_reconfigtogxb_${i}.source0\
				alt_xcvr_reconfig_${i}_split_togxb.split_in
			ac \
				astac_op_reconfigtogxb_${i}.source1\
				hxaui_$i.reconfig_togxb
			ac \
				alt_xcvr_reconfig_${i}_split_togxb.split_out_3 \
				alt_pma_ch_controller_$i.rx_oc_busy
		}
        ac  astac_op_plllocked_${i}.source1 alt_pma_ch_controller_$i.pll_locked
        ac  hxaui_$i.pll_locked astac_op_plllocked_${i}.sink0
      }

    } ; # if { $internal_pcr == 0 }

    for { set i 0 } { $i < $num_sxaui } { incr i } {
      if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }
      add_export_if rx_pma_ready$sfx  st      start alt_pma_$i.rx_pma_ready
      add_export_if tx_pma_ready$sfx  st      start alt_pma_$i.tx_pma_ready
    }
    for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
      if { $num_interfaces == 1 } { set sfx "" } else { set sfx "_$i" }
      add_export_if rx_pma_ready$sfx  st      start alt_pma_ch_controller_$i.rx_pma_ready
      add_export_if tx_pma_ready$sfx  st      start alt_pma_ch_controller_$i.tx_pma_ready
    }



#
# Connections
#-------------

#--- alt_pma_controller_i ---
  if { $internal_pcr } {
      for { set i 0 } { $i < $num_sxaui } { incr i } {
          ac  alt_pma_controller_$i.cal_blk_pdn  alt_pma_$i.cal_blk_pdn
          ac  alt_pma_controller_$i.pll_pdn0     alt_pma_$i.pll_pdn

          if {$dev_family == "Stratix IV"} {
              ac  alt_pma_controller_$i.gx_pdn   alt_pma_$i.gx_pdn
          }
      }
      for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
          ac  alt_pma_controller_$i.cal_blk_pdn  hxaui_$i.r_cal_blk_powerdown
          ac  alt_pma_controller_$i.pll_pdn0     hxaui_$i.r_pll_powerdown
          ac  alt_pma_controller_$i.gx_pdn       hxaui_$i.r_gxb_powerdown
      }

#--- alt_pma_i ---
      for { set i 0 } { $i < $num_sxaui } { incr i } {
          ac  alt_pma_$i.pll_locked              astac_op_soft_plllocked_$i.sink0
          ac  astac_op_soft_plllocked_$i.source0 alt_pma_controller_$i.pll_locked0

		  # No reconfig_from_gxb output port exists for alt_pma
		  # in Stratix V for this version of of the XAUI core.
		  # Also for Stratix V, the reconfig controller does not
		  # support the reconfig_fromgxb(x)_st input ports.
		  # Disabling all of these connections in Stratix V
		  if {$dev_family == "Stratix IV"} {
			  ac  alt_pma_$i.reconfig_from_gxb0 alt_xcvr_reconfig_${i}.reconfig_fromgxb0_st
			  ac  alt_pma_$i.reconfig_from_gxb1 alt_xcvr_reconfig_${i}.reconfig_fromgxb1_st
			  ac  alt_pma_$i.reconfig_from_gxb2 alt_xcvr_reconfig_${i}.reconfig_fromgxb2_st
			  ac  alt_pma_$i.reconfig_from_gxb3 alt_xcvr_reconfig_${i}.reconfig_fromgxb3_st
		  }
      }
      for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
          ac  astac_op_plllocked_${i}.source0 alt_pma_controller_$i.pll_locked0
          ac  astac_op_plllocked_${i}.source1 alt_pma_ch_controller_$i.pll_locked
          ac  hxaui_$i.pll_locked astac_op_plllocked_${i}.sink0
          ac \
              hxaui_$i.reconfig_fromgxb \
              alt_xcvr_reconfig_${i}.reconfig_fromgxb0_st
      }

#--- alt_xcvr_reconfig_basic ---
      if {$dev_family == "Stratix IV"} {
		  for { set i 0 } { $i < $num_sxaui } { incr i } {
			  ac \
				  alt_xcvr_reconfig_${i}.reconfig_togxb_data \
				  alt_pma_$i.reconfig_to_gxb
		  }
		  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
			  ac \
				  alt_xcvr_reconfig_${i}.reconfig_togxb_data \
				  astac_op_reconfigtogxb_${i}.sink0 
			  ac \
				  astac_op_reconfigtogxb_${i}.source0 \
				  alt_xcvr_reconfig_${i}_split_togxb.split_in
			  ac \
				  astac_op_reconfigtogxb_${i}.source1 \
				  hxaui_$i.reconfig_togxb

			  ac \
				  alt_xcvr_reconfig_${i}_split_togxb.split_out_3 \
				  alt_pma_ch_controller_$i.rx_oc_busy
		  }
	  }

  } ; # if { $internal_pcr }

#0x0 = PHY common
#0x80 = PMA controller
#0x100 = Reset controller
#0x180 = PMA Ch Controller
#0x200 = PCS
#0x400 = XCVR Reconfig

  for { set i 0 } { $i < $num_interfaces } { incr i } {

      if { $internal_pcr } {
          set addr [format "0x%08x" [expr (0x0800 * $i + 0x0080)]] ; #byte address = 0x80, word address = 0x20
          ac_2parameter \
              merlin_master_translator.avalon_universal_master_0 \
              alt_pma_controller_${i}.pma_mgmt \
              "arbitrationPriority 1" "baseAddress $addr"
          send_message info "alt_xaui_hw:alt_pma_controller_$i, addr $addr"

          set addr [format "0x%08x" [expr (0x0800 * $i + 0x0400)]] ; #byte address = 0x400, word address = 0x100
          ac_2parameter \
              merlin_master_translator.avalon_universal_master_0 \
              alt_xcvr_reconfig_${i}.reconfig_mgmt \
              "arbitrationPriority 1" "baseAddress $addr"
          send_message info \
              "alt_xaui_hw:alt_xcvr_reconfig_${i}, addr $addr"

      } ; # if { $internal_pcr }

      set addr [format "0x%08x" [expr 0x0800 * $i + 0x0200 ]] ; #byte address = 0x200, word address = 0x80
      ac_2parameter \
          merlin_master_translator.avalon_universal_master_0 \
          hxaui_csr_$i.hxaui_csr_mm \
          "arbitrationPriority 1" "baseAddress $addr"
      send_message info "alt_xaui_hw:hxaui_csr_$i, addr $addr"
  }

# for soft xaui, alt_pma is actually the pma_ch_controller memory map
  for { set i 0 } { $i < $num_sxaui } { incr i } {
      set addr [format "0x%08x" [expr 0x0800 * $i + 0x0100 ]] ; #byte address = 0x100, word address = 0x60
      ac_2parameter \
          merlin_master_translator.avalon_universal_master_0 \
          alt_pma_$i.ch_mgmt \
          "arbitrationPriority 1" "baseAddress $addr"
      send_message info "alt_xaui_hw:alt_pma_$i, addr $addr"
  }
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
      set addr [format "0x%08x" [expr 0x0800 * $i + 0x0100 ]] ; #byte address = 0x100, word address = 0x60
      ac_2parameter \
          merlin_master_translator.avalon_universal_master_0 \
          alt_pma_ch_controller_$i.ch_mgmt \
          "arbitrationPriority 1" "baseAddress $addr"
      send_message info "alt_xaui_hw:alt_pma_ch_controller$i, addr $addr"
  }

#--- avmm_clk ---

  for { set i 0 } { $i < $num_interfaces } { incr i } {
      if { $internal_pcr } {
          ac  mgmt_clk.clk  alt_pma_controller_$i.mgmt_clk
      }
      ac  mgmt_clk.clk  hxaui_csr_$i.clock_reset
  }
  for { set i 0 } { $i < $num_sxaui } { incr i } {
      ac  mgmt_clk.clk  alt_pma_$i.mgmt_clk
  }
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
      ac  mgmt_clk.clk  alt_pma_ch_controller_$i.mgmt_clk
  }

  for { set i 0 } { $i < $num_interfaces } { incr i } {
    if { $internal_pcr } {
        ac  mgmt_clk.clk_reset  alt_pma_controller_$i.mgmt_clk_reset
        ac  mgmt_clk.clk_reset  alt_xcvr_reconfig_${i}.mgmt_rst
    }
    ac  mgmt_clk.clk_reset  hxaui_csr_$i.clock_reset_reset
  }
  for { set i 0 } { $i < $num_sxaui } { incr i } {
    ac  mgmt_clk.clk_reset  alt_pma_$i.mgmt_clk_reset
  }
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
    ac  mgmt_clk.clk_reset  alt_pma_ch_controller_$i.mgmt_clk_reset
  }

#--- xgmii_tx_clk, xgmii_rx_clk, cal_blk_clk, reconfig_clk
  for { set i 0 } { $i < $num_interfaces } { incr i } {
      if { $internal_pcr } {
          ac  mgmt_clk.clk       alt_pma_controller_$i.cal_clk
          ac  mgmt_clk.clk       alt_xcvr_reconfig_${i}.mgmt_clk
      }
  }
  for { set i 0 } { $i < $num_sxaui } { incr i } {
    ac  refclk.clk                sxaui_$i.refclk
    ac  refclk.clk                alt_pma_$i.pll_ref_clk
    ac  xgmii_tx_clk_$i.clk       sxaui_$i.xgmii_tx_clk
    ac  mgmt_clk.clk              sxaui_$i.mgmt_clk
    ac  mgmt_clk.clk          alt_pma_$i.cal_blk_clk
    if {$dev_family == "Stratix IV"} {
		ac  mgmt_clk.clk          alt_pma_$i.reconfig_clk
	}
  }
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
    ac  refclk.clk                hxaui_$i.refclk
    ac  xgmii_tx_clk_$i.clk       hxaui_$i.xgmii_tx_clk
    ac  mgmt_clk.clk          hxaui_$i.cal_blk_clk
    ac  mgmt_clk.clk          hxaui_$i.reconfig_clk
  }

#--- sxaui_i ---
  for { set i 0 } { $i < $num_sxaui } { incr i } {
    ac  alt_pma_$i.tx_out_clk             sxaui_$i.tx_out_clk
    ac  alt_pma_$i.rx_recovered_clk       sxaui_$i.rx_recovered_clk
    ac  sxaui_$i.tx_parallel_data         alt_pma_$i.tx_parallel_data
    ac  alt_pma_$i.rx_parallel_data       sxaui_$i.rx_parallel_data
    ac  alt_pma_$i.rx_is_lockedtodata     sxaui_$i.rx_is_lockedtodata
    ac  astac_op_soft_plllocked_$i.source1 sxaui_$i.pll_locked
    ac  sxaui_$i.rx_syncstatus            hxaui_csr_$i.rx_syncstatus
    ac  sxaui_$i.rx_disperr               hxaui_csr_$i.rx_disperr
    ac  sxaui_$i.rx_errdetect             hxaui_csr_$i.rx_errdetect
    ac  hxaui_csr_$i.r_rx_digitalreset    sxaui_$i.r_rx_digitalreset
    ac  hxaui_csr_$i.r_tx_digitalreset    sxaui_$i.r_tx_digitalreset
    ac  hxaui_csr_$i.simulation_flag      sxaui_$i.simulation_flag
  }

#--- hxaui_i ---
  for { set i $num_sxaui } { $i < $num_interfaces } { incr i } {
    ac hxaui_$i.rx_disperr               hxaui_csr_$i.rx_disperr
    ac hxaui_$i.rx_errdetect             hxaui_csr_$i.rx_errdetect
    ac hxaui_$i.rx_patterndetect         hxaui_csr_$i.rx_patterndetect
    ac hxaui_$i.rx_phase_comp_fifo_error hxaui_csr_$i.rx_phase_comp_fifo_error
    ac hxaui_$i.rx_rlv                   hxaui_csr_$i.rx_rlv
    ac hxaui_$i.rx_rmfifodatadeleted     hxaui_csr_$i.rx_rmfifodatadeleted
    ac hxaui_$i.rx_rmfifodatainserted    hxaui_csr_$i.rx_rmfifodatainserted
    ac hxaui_$i.rx_rmfifoempty           hxaui_csr_$i.rx_rmfifoempty
    ac hxaui_$i.rx_rmfifofull            hxaui_csr_$i.rx_rmfifofull
    ac hxaui_$i.rx_runningdisp           hxaui_csr_$i.rx_runningdisp
    ac hxaui_$i.rx_syncstatus            hxaui_csr_$i.rx_syncstatus
    ac hxaui_$i.tx_phase_comp_fifo_error hxaui_csr_$i.tx_phase_comp_fifo_error

    ac alt_pma_ch_controller_$i.rx_set_locktodata  hxaui_$i.r_rx_set_locktodata
    ac alt_pma_ch_controller_$i.rx_set_locktoref   hxaui_$i.r_rx_set_locktoref
    ac alt_pma_ch_controller_$i.rx_seriallpbken    hxaui_$i.r_rx_seriallpbken
    ac alt_pma_ch_controller_$i.rx_analog_rst      hxaui_$i.r_rx_analogreset
    ac hxaui_$i.rx_is_lockedtodata                 alt_pma_ch_controller_$i.rx_is_lockedtodata
    ac hxaui_$i.rx_is_lockedtoref                  alt_pma_ch_controller_$i.rx_is_lockedtoref
    ac alt_pma_ch_controller_$i.tx_digital_rst     hxaui_$i.tx_digitalreset
    ac alt_pma_ch_controller_$i.rx_digital_rst     hxaui_$i.rx_digitalreset

    ac hxaui_csr_$i.r_rx_digitalreset           hxaui_$i.r_rx_digitalreset
    ac hxaui_csr_$i.r_rx_invpolarity            hxaui_$i.r_rx_invpolarity
    ac hxaui_csr_$i.r_tx_digitalreset           hxaui_$i.r_tx_digitalreset
    ac hxaui_csr_$i.r_tx_invpolarity            hxaui_$i.r_tx_invpolarity
  }

#--- Generate SDC file ---
  add_instance             xaui_create_sdc alt_xaui_create_sdc
    set_instance_parameter xaui_create_sdc number_of_hard_interfaces $num_hxaui
    set_instance_parameter xaui_create_sdc number_of_soft_interfaces $num_sxaui

# Dummy connection, makes sure the module is instatiated
  ac  mgmt_clk.clk  xaui_create_sdc.clk

}

#------------------------------------------------------------------------------

#
# Validation
#-------------
# validate - displaying messages and checking parameters
proc alt_xaui_validate {} {
    send_message info "alt_xaui_validate"
    set num_interfaces  [get_parameter_value number_of_interfaces]
    set if_type         [get_parameter_value interface_type]
	set dev_family 		[get_parameter_value device_family]
	
	# Stratix IV : Allow users to select between Soft and Hard XAUI
	# Stratix V  : No Hard XAUI support; Disable selection (default: soft)
        # Stratix V  : No Analog tab options; Disable Visibility
	if {$dev_family == "Stratix V"} {
          # General Tab: Interface type is visible but disabled
	  set_parameter_property interface_type ENABLED false
          set_parameter_property starting_channel_number VISIBLE false
          # Analog Tab: All parameters invisible
          set_parameter_property tx_termination VISIBLE false
          set_parameter_property tx_vod_selection VISIBLE false
          set_parameter_property tx_preemp_pretap VISIBLE false
          set_parameter_property tx_preemp_pretap_inv VISIBLE false
          set_parameter_property tx_preemp_tap_1 VISIBLE false
          set_parameter_property tx_preemp_tap_2 VISIBLE false
          set_parameter_property tx_preemp_tap_2_inv VISIBLE false
          set_parameter_property rx_common_mode VISIBLE false
          set_parameter_property rx_termination VISIBLE false
          set_parameter_property rx_eq_dc_gain VISIBLE false
          set_parameter_property rx_eq_ctrl VISIBLE false
          # Advanced Tab: 
          set_parameter_property xaui_pll_type VISIBLE false
          set_parameter_property external_pma_ctrl_reconf VISIBLE false
	} else {
	  set_parameter_property interface_type ENABLED true
	}
	
	# Stratix IV soft XAUI allows selection between CMU and ATX PLL
	# Else disable selection (defaults to CMU PLL)
    if {$if_type == "Soft XAUI" && $dev_family == "Stratix IV"} {
      set_parameter_property xaui_pll_type ENABLED true
    } else {
      set_parameter_property xaui_pll_type ENABLED false
    }

	# Only 1 XAUI interface allowed!
    if { [expr ($num_interfaces > 1)] } {
	  send_message error "Only one xaui interface is supported in this version."
    }
}

