# (C) 2001-2010 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera MegaCore Function License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# +-----------------------------------
# | 
# | Description: alt_xaui_create_sdc.v is a null verilog block, the tcl 
# |              generation code generates an SDC file for alt_xaui
# | 
# +-----------------------------------

package require -exact sopc 9.1

# module alt_xaui_create_sdc
set_module_property NAME                          alt_xaui_create_sdc
set_module_property VERSION                       10.0
set_module_property INTERNAL                      true
set_module_property GROUP                         "Local/alt_xaui sub-blocks"
set_module_property DISPLAY_NAME                  alt_xaui_create_sdc
#set_module_property TOP_LEVEL_HDL_FILE           alt_xaui_create_sdc.v
#set_module_property TOP_LEVEL_HDL_MODULE         alt_xaui_create_sdc
set_module_property INSTANTIATE_IN_SYSTEM_MODULE  true
set_module_property EDITABLE                      true
set_module_property SIMULATION_MODEL_IN_VERILOG   true
set_module_property ANALYZE_HDL FALSE

# callbacks
set_module_property ELABORATION_CALLBACK alt_xaui_create_sdc_elaborate
set_module_property GENERATION_CALLBACK  alt_xaui_create_sdc_generate

# files
add_file alt_xaui_create_sdc.v {SIMULATION SYNTHESIS}

# helper functions
source ipcc_tcl_helper.tcl
source ../../sopc_builder_ip/altera_avalon_mega_common/ipcc_wrap_split.tcl

# parameters
add_param_int_not_hdl             number_of_hard_interfaces  1      {0:32} ""
add_param_int_not_hdl             number_of_soft_interfaces  1      {0:32} ""

# main
add_clock_interface   clk     end   1 

#------------------------------------------------------------------------------

# elaboration call back
proc alt_xaui_create_sdc_elaborate { } {
    send_message info "alt_xaui_create_sdc_elaborate"

	ipcc_init_mappings elaboration

	set hdl_module alt_xaui_create_sdc
	ipcc_set_module $hdl_module

	ipcc_elaboration_declarations
}

# generataion call back
proc alt_xaui_create_sdc_generate { } {
    send_message info "alt_xaui_create_sdc_generate"

    set num_hxaui      [get_parameter_value number_of_hard_interfaces]
    set num_sxaui      [get_parameter_value number_of_soft_interfaces]
    set num_interfaces [expr $num_hxaui + $num_sxaui]

    generate_sdc $num_interfaces $num_sxaui

	ipcc_init_mappings generation

# add verilog file (empty one...)
	set hdl_file [ipcc_generate_hdl_wrapper]
	send_message info "add_file $hdl_file {SIMULATION SYNTHESIS}"
 
#	add_file [get_generation_property OUTPUT_NAME] {SIMULATION SYNTHESIS}
#	add_file alt_xaui_create_sdc.v  {SYNTHESIS}

        set output_dir  [ get_generation_property OUTPUT_DIRECTORY ]
        set output_name [ get_generation_property OUTPUT_NAME ]
        set output_file [ file join $output_dir ${output_name}.v ]

        add_file $output_file {SIMULATION SYNTHESIS}
}

#------------------------------------------------------------------------------

# create_clock
#     cc <file id> <name> <period in ns?> [port|net] <signal name>
proc cc { sdcf name period type signal } {
    set t_half [expr $period / 2]
    puts $sdcf "create_clock -name \{$name\} \\"
    puts $sdcf "    -period $period -waveform {0.000 $t_half} \\"
    if { $type == "port" } {
        puts $sdcf "    \[ get_ports \{$signal\} \]"
    } else {
        puts $sdcf "    \[ get_nets \{$signal\} \]"
    }
}

# create_generated_clock
#     cgc <file id> <name> <clock_source> <multiply_factor> <signal name>
proc cgc { sdcf name source multiply_factor signal } {
    puts $sdcf "create_generated_clock -name \{$name\} \\"
    puts $sdcf "    -source  \[ get_ports \{$source\} \] \\" 
    puts $sdcf "    -multiply_by $multiply_factor \\"
    puts $sdcf "    \[ get_ports \{$signal\} \]"
}

#------------------------------------------------------------------------------


# generate timing sdc file
#--------------------------
proc generate_sdc { num_interfaces num_sxaui } {

    send_message info "Generating sdc..."

# sdc file name
    set path_name   [get_generation_property OUTPUT_DIRECTORY]
	set output_name [get_generation_property OUTPUT_NAME] 
    set sdcf_name   "$path_name${output_name}.sdc"
	send_message     info "add_file $sdcf_name {SDC}"
	add_file         $sdcf_name {SDC}
    
# sdc generation
    set sdcf [open $sdcf_name "w"]
    if [ catch {open $sdcf_name "w"} sdcf ] {
        send_message error "Couldn't open file '$sdcf_name' for writing: $sdcf"
    } else {
        
        puts $sdcf "\#"
        puts $sdcf "\#$sdcf_name: alt_xaui sdc file"
        puts $sdcf "\#"
        
        puts $sdcf ""
        puts $sdcf "set_time_format -unit ns -decimal_places 3"
        puts $sdcf "derive_pll_clocks"
        puts $sdcf "derive_clock_uncertainty"
        
        puts $sdcf ""
        puts $sdcf "\#"
        puts $sdcf "\# input clocks"
        puts $sdcf "\#"
        
        cc $sdcf xgmii_tx_clk       6.400   port xgmii_tx_clk_clk
        cc $sdcf mgmt_clk          20.000   port mgmt_clk_clk
        cc $sdcf refclk             6.400   port refclk_clk 
        
        puts $sdcf ""
        puts $sdcf "\#"
        puts $sdcf "\# generated clocks"
        puts $sdcf "\#"
        
        if {$num_sxaui} {
            puts $sdcf "\#"
            puts $sdcf "\# xgmii_rx_clk is generated from refclkout "
            puts $sdcf "\#"
            puts $sdcf "create_generated_clock -name \{xgmii_rx_clk_0\} \\"
            puts $sdcf "-source \[get_pins -compatibility_mode \{*alt_pma_0|alt_pma_tgx_inst|pma_direct|auto_generated|central_clk_div0|refclkout\} \] \\"
            puts $sdcf "-multiply_by 1 \\"
            puts $sdcf "\[get_ports \{xgmii_rx_clk_clk\}\]"

        } else {; # hard xaui
            puts $sdcf "\#"
            puts $sdcf "\# xgmii_rx_clk is generated from coreclkout"
            puts $sdcf "\#"
            puts $sdcf "create_generated_clock -name \{xgmii_rx_clk_0\} \\"
            puts $sdcf "-source \[get_pins -compatibility_mode \{*hxaui_0|hxaui_alt4gxb|hxaui_alt4gxb_alt4gxb_dksa_component|central_clk_div0|coreclkout\} \] \\"
            puts $sdcf "-multiply_by 1 \\"
            puts $sdcf "\[get_ports \{xgmii_rx_clk_clk\}\]"
        }
        
        puts $sdcf ""
        puts $sdcf "\#"
        puts $sdcf "\# internal clocks"
        puts $sdcf "\#"
        if { $num_sxaui } {
            # remove temporarily - causes an IE
        #    cc $sdcf pma_tx_clkout  6.400 net *wire_transmit_pma0_clockout
        #    cc $sdcf pma_rx_clkout0 6.400 net *wire_receive_pma0_clockout
        #    cc $sdcf pma_rx_clkout1 6.400 net *wire_receive_pma1_clockout
        #    cc $sdcf pma_rx_clkout2 6.400 net *wire_receive_pma2_clockout
        #    cc $sdcf pma_rx_clkout3 6.400 net *wire_receive_pma3_clockout
            puts $sdcf "\#"
            puts $sdcf "\# There should be no direct (unsynchronized) paths from xgmii_rx_clk to mgmt, deserclock to mgmt_clk, or refclk to mgmt_clk."
            puts $sdcf "\#"
            puts $sdcf "set_clock_groups -asynchronous -group \{*alt_pma_0|alt_pma_tgx_inst|pma_direct|auto_generated|central_clk_div0|refclkout\} -group \{mgmt_clk\}"
            puts $sdcf "set_clock_groups -asynchronous -group \{*alt_pma_0|alt_pma_tgx_inst|pma_direct|auto_generated|receive_pma*|deserclock*\} -group \{mgmt_clk\}"
            puts $sdcf "set_clock_groups -asynchronous -group \{refclk\} -group \{mgmt_clk\}"
        } else { ; # hard xaui
            puts $sdcf "\#"
            puts $sdcf "\# There should be no direct (unsynchronized) paths from coreclkout to mgmt_clk"
            puts $sdcf "\#"
            puts $sdcf "set_clock_groups -asynchronous -group \{*hxaui_0|hxaui_alt4gxb|hxaui_alt4gxb_alt4gxb_dksa_component|central_clk_div0|coreclkout\} -group \{mgmt_clk\}"
        }
        

        puts $sdcf ""
        close $sdcf
    }
}
