# (C) 2001-2010 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera MegaCore Function License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# (C) 2001-2010 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera MegaCore Function License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# +-----------------------------------
# | 
# | alt_pma_ch_controller "alt_pma_ch_controller" v1.0
# | 
# | 
# |    ./alt_pma_ch_controller_tgx.v syn, sim
# | 
# +-----------------------------------

package require -exact sopc 9.1

# module alt_pma_ch_controller
set_module_property NAME alt_pma_ch_controller
set_module_property VERSION 10.0
set_module_property INTERNAL true
set_module_property GROUP "Local/alt_xaui sub-blocks"
set_module_property DISPLAY_NAME alt_pma_ch_controller
set_module_property TOP_LEVEL_HDL_FILE ../../alt_pma/source/channel_controller/alt_pma_ch_controller_tgx.v 
set_module_property TOP_LEVEL_HDL_MODULE alt_pma_ch_controller_tgx
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property SIMULATION_MODEL_IN_VERILOG true
set_module_property VALIDATION_CALLBACK my_validation_callback
set_module_property ANALYZE_HDL FALSE


# files
add_file ../../alt_pma/source/channel_controller/alt_pma_ch_controller_tgx.v {SYNTHESIS}
add_file ../../alt_pma/source/channel_controller/tgx_ch_reset_ctrl.sv {SYNTHESIS}
add_file ../../altera_xcvr_generic/alt_reset_ctrl_lego.sv {SYNTHESIS}
add_file ../../altera_xcvr_generic/sv/sv_generic_csr.sv {SYNTHESIS}
add_file ../../altera_xcvr_generic/sv/sv_generic_csr_h.sv {SYNTHESIS}
add_file ../../altera_xcvr_generic/altera_wait_generate.v {SYNTHESIS}

# helper functions
source ipcc_tcl_helper.tcl

# parameters
add_param_int number_of_channels 4 {1:24}   ""
add_param_int sync_depth         2 {1:5}    ""

add_parameter sys_clk_in_hz LONG 50000000
set_parameter_property sys_clk_in_hz SYSTEM_INFO {CLOCK_RATE mgmt_clk}
set_parameter_property sys_clk_in_hz VISIBLE false
set_parameter_property sys_clk_in_hz AFFECTS_GENERATION true
set_parameter_property sys_clk_in_hz HDL_PARAMETER false

add_parameter sys_clk_in_mhz INTEGER 50
set_parameter_property sys_clk_in_mhz DERIVED true
set_parameter_property sys_clk_in_mhz VISIBLE false
set_parameter_property sys_clk_in_mhz AFFECTS_GENERATION true
set_parameter_property sys_clk_in_mhz HDL_PARAMETER true

# mgmt_clk
add_interface              mgmt_clk clock end
    set_interface_property mgmt_clk ENABLED true

    add_interface_port     mgmt_clk clk clk Input 1
    add_interface_port     mgmt_clk rst reset Input 1

# connection point ch_mgmt
add_interface              ch_mgmt avalon end
    set_interface_property ch_mgmt addressAlignment DYNAMIC
    set_interface_property ch_mgmt burstOnBurstBoundariesOnly false
    set_interface_property ch_mgmt explicitAddressSpan 0
    set_interface_property ch_mgmt holdTime 0
    set_interface_property ch_mgmt isMemoryDevice false
    set_interface_property ch_mgmt isNonVolatileStorage false
    set_interface_property ch_mgmt linewrapBursts false
    set_interface_property ch_mgmt maximumPendingReadTransactions 0
    set_interface_property ch_mgmt printableDevice false
    set_interface_property ch_mgmt readLatency 0
    set_interface_property ch_mgmt readWaitStates 0
    set_interface_property ch_mgmt readWaitTime 0
    set_interface_property ch_mgmt setupTime 0
    set_interface_property ch_mgmt timingUnits Cycles
    set_interface_property ch_mgmt writeWaitTime 0
    set_interface_property ch_mgmt ASSOCIATED_CLOCK mgmt_clk
    set_interface_property ch_mgmt ENABLED true

    add_interface_port ch_mgmt ch_mgmt_address address Input 6
    add_interface_port ch_mgmt ch_mgmt_read read Input 1
    add_interface_port ch_mgmt ch_mgmt_readdata readdata Output 32
    add_interface_port ch_mgmt ch_mgmt_write write Input 1
    add_interface_port ch_mgmt ch_mgmt_writedata writedata Input 32
    add_interface_port ch_mgmt ch_mgmt_waitrequest waitrequest output 1 

# +-----------------------------------
# | connection point rx_pma_ready
# |
add_interface rx_pma_ready avalon_streaming start
set_interface_property rx_pma_ready dataBitsPerSymbol 1
set_interface_property rx_pma_ready errorDescriptor ""
set_interface_property rx_pma_ready maxChannel 0
set_interface_property rx_pma_ready readyLatency 0
set_interface_property rx_pma_ready symbolsPerBeat 1

set_interface_property rx_pma_ready ASSOCIATED_CLOCK mgmt_clk
set_interface_property rx_pma_ready ENABLED true

add_interface_port rx_pma_ready rx_pma_ready data Output 1

# +-----------------------------------
# | connection point tx_pma_ready
# |
add_interface tx_pma_ready avalon_streaming start
set_interface_property tx_pma_ready dataBitsPerSymbol 1
set_interface_property tx_pma_ready errorDescriptor ""
set_interface_property tx_pma_ready maxChannel 0
set_interface_property tx_pma_ready readyLatency 0
set_interface_property tx_pma_ready symbolsPerBeat 1

set_interface_property tx_pma_ready ASSOCIATED_CLOCK mgmt_clk
set_interface_property tx_pma_ready ENABLED true

add_interface_port tx_pma_ready tx_pma_ready data Output 1


#for 10.0 - fix to 4, since we only allow one interface
add_streaming_interface  rx_is_lockedtodata  end   4   mgmt_clk
add_streaming_interface  rx_is_lockedtoref   end   4   mgmt_clk
add_streaming_interface  rx_set_locktodata   start 4   mgmt_clk
add_streaming_interface  rx_set_locktoref    start 4   mgmt_clk
add_streaming_interface  rx_seriallpbken     start 4   mgmt_clk
add_streaming_interface  rx_analog_rst       start 4   mgmt_clk
add_streaming_interface  tx_digital_rst      start 4   mgmt_clk
add_streaming_interface  rx_digital_rst      start 4   mgmt_clk
add_streaming_interface  rx_oc_busy          end   1   mgmt_clk
add_streaming_interface  pll_locked          end   1   mgmt_clk

proc my_validation_callback {} {
	set_parameter_value sys_clk_in_mhz [expr [get_parameter_value sys_clk_in_hz] / 1000000]
}

