function w_p_estimator(block)
% Level-2 MATLAB file S-Function for limited integrator demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.2 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  %% Register number of dialog parameters   
  block.NumDialogPrms = 0;

  %% Register number of input and output ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts = 4;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 3; %Hall Effect Sensors
  block.InputPort(1).DirectFeedthrough = false;
    
  block.OutputPort(1).Dimensions       = 1; %w - angular velocity estimator
  block.OutputPort(2).Dimensions       = 1; %sector
  block.OutputPort(3).Dimensions       = 1; %mechanical position
  block.OutputPort(4).Dimensions       = 1; %mechanical position
 %% Set block sample time to inherited
  block.SampleTimes = [-1 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';

  %% Register methods
  %block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  %block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('SetInputPortSamplingMode',@SetInputPortSamplingMode);  
  block.RegBlockMethod('Outputs',                 @Output);  
  %block.RegBlockMethod('Update',                  @Update);  
%endfunction

   
function SetInputPortSamplingMode(block,idx,fd)
     block.InputPort(1).SamplingMode = fd;
     block.OutputPort(1).SamplingMode = fd;
     block.OutputPort(2).SamplingMode = fd;
     block.OutputPort(3).SamplingMode = fd;    
     block.OutputPort(4).SamplingMode = fd; 
%endfunction


function Output(block)
  persistent last_update_time
  persistent sector_last
  persistent angle_speed
  persistent position
  
  if (isempty(last_update_time)) last_update_time = 0;
  end
  
  if (isempty(sector_last)) sector_last = 0;
  end
  
  if (isempty(angle_speed)) angle_speed = 0;
  end
  
  if (isempty(position)) position = 0;
  end
    
  %Determine the position sector
  if block.InputPort(1).Data == [1;0;0] sector = 0; %0-60 sector
  elseif block.InputPort(1).Data == [1;1;0] sector = 1; %60 - 120 sector
  elseif block.InputPort(1).Data == [0;1;0] sector = 2; %120 - 180 sector
  elseif block.InputPort(1).Data == [0;1;1] sector = 3; %180 - 240 sector
  elseif block.InputPort(1).Data == [0;0;1] sector = 4; %240 - 300 sector
  elseif block.InputPort(1).Data == [1;0;1] sector = 5; %300 - 360 sector
  else sector = 0; %illegal sequence
  end
  block.OutputPort(2).Data = sector;
  
  
  
 
  if ((sector >=0 && sector <= 5) && (sector ~= sector_last))
      %%%%%%%%%%%%%%%%%%%%%%%
      %Update angular speed
      %%%%%%%%%%%%%%%%%%%%%%%
      delta = (sector - sector_last); % -5 -> 1, -4->2, -3->3, 5->-1, 4-> -2, 3->-3
      if (abs(delta) >= 3) delta = -sign(delta)*(6 - abs(delta));
      end
      
      time_delta = (block.CurrentTime - last_update_time);
      if (time_delta < 1e-3) angle_speed = 0; %filters out glitches
      else angle_speed = (delta*pi/3)/(block.CurrentTime - last_update_time) ;
      end
      sector_last = sector;
      last_update_time = block.CurrentTime;

      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      %Update Position to new reference based on recent hall sensor change
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      if (delta > 0)
          switch sector
            case 0 
                position = 0;
            case 1 
                position = pi/3;
            case 2 
                position = 2*pi/3;
            case 3 
                position = pi;
            case 4 
                position = 4*pi/3;
            case 5 
                position = 5*pi/3;
          end
      else
          switch sector
            case 0 
                position = pi/3;
            case 1 
                position = 2*pi/3;
            case 2 
                position = pi;
            case 3 
                position = 4*pi/3;
            case 4 
                position = 5*pi/3;
            case 5 
                position = 2*pi;
          end
      end
    
  else
   % position = position + (angle_speed * 0.0001);
   delta_pos=(angle_speed * 0.0001);
   time_delta = (block.CurrentTime - last_update_time);
   block.OutputPort(4).Data=position + time_delta*angle_speed;
  end
  block.OutputPort(1).Data = angle_speed;
  block.OutputPort(3).Data = position + time_delta*angle_speed;
%endfunction


