%Mode
%SimulationMode = 0; %0 - Simulink, 1 - HIL , 2 - DSPBA
switch SimulationModeSelName
    case 'Simulink'
        SimulationMode = 0;
    case 'HIL'
        SimulationMode = 1;
    case 'DSPBA'
        SimulationMode = 2;
end

%GenerationMode = 1; %0 - No HW Generation, 1 - Generate normal HW, 2 - Generate HIL HW
switch GenerationModeSelName
    case 'No HW Generation'
        GenerationMode = 0;
    case 'Normal HW'
        GenerationMode = 1;
    case 'HIL HW'
        GenerationMode = 2;
end
%Path Index of System Console. May need to modify to access HW. See Matlab console
global SysConIndexPath
SysConIndexPath = 2;

global SimulinkSampleTime

SimulinkSampleTime  = 1e-4;
DSPBASampleTime     = 5e-7;

switch SimulationMode
    case 0
        SampleTime = SimulinkSampleTime;
    case 1
        SampleTime = SimulinkSampleTime;
    case 2
        SampleTime = DSPBASampleTime;        
end

SampleTimeRatio     = SimulinkSampleTime/SampleTime;

%dspba.runGeneration('compile','SPath','bldc1','RTLPath','./DSPB_Controller/rtl')
 

% DSPBA Design Parameters Start
DSPBA.SystemClk = 200;
DSPBA.BusClk    = 200;




%Interface Address Map
DSPBA.PositionCommandAddr  = 0;
DSPBA.PositionFeedbackAddr = 1;
DSPBA.SpeedFeedbackAddr    = 2;
DSPBA.CurrentFeedbackAddr  = 3;
DSPBA.InputDataValidAddr   = 4;

DSPBA.ControllerOutAddr    = 5;
