function inverter(block)
% Level-2 MATLAB file S-Function for limited integrator demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.2 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  %% Register number of dialog parameters   
  block.NumDialogPrms = 0;

  %% Register number of input and output ports
  block.NumInputPorts  = 4;
  block.NumOutputPorts = 2;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 3; %Hall Effect Sensors
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(2).Dimensions        = 3; %Iabc - Phase Current
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(3).Dimensions        = 3;%Eabc - BEMF voltage
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(4).Dimensions        = 1; %Vs drive voltage
  block.InputPort(1).DirectFeedthrough = false;
  
  block.OutputPort(1).Dimensions       = 2; %Vac-Eab , Vbc-Ebc
  block.OutputPort(2).Dimensions       = 1; %sector
  
 %% Set block sample time to inherited
  block.SampleTimes = [0.001 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';

  %% Register methods
  %block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  %block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('SetInputPortSamplingMode',@SetInputPortSamplingMode);  
  block.RegBlockMethod('Outputs',                 @Output);  
  %block.RegBlockMethod('Update',                  @Update);  
%endfunction

   
function SetInputPortSamplingMode(block,idx,fd)
     block.InputPort(1).SamplingMode = fd;
     block.InputPort(2).SamplingMode = fd;
     block.InputPort(3).SamplingMode = fd;
     block.InputPort(4).SamplingMode = fd;
     block.OutputPort(1).SamplingMode = fd;
     block.OutputPort(2).SamplingMode = fd;
     
%endfunction


function Output(block)
  Vs = block.InputPort(4).Data; %command
  E  = block.InputPort(3).Data; %BEMF
  
  %Determine the position sector
  if block.InputPort(1).Data == [1;0;0] sector = 0; %0-60 sector
  elseif block.InputPort(1).Data == [1;1;0] sector = 1; %60 - 120 sector
  elseif block.InputPort(1).Data == [0;1;0] sector = 2; %120 - 180 sector
  elseif block.InputPort(1).Data == [0;1;1] sector = 3; %180 - 240 sector
  elseif block.InputPort(1).Data == [0;0;1] sector = 4; %300 - 360 sector
  elseif block.InputPort(1).Data == [1;0;1] sector = 5;
  else sector = 999; %illegal sequence
  end
  
  block.OutputPort(2).Data = sector;
  %Determine if the disconnected phase current decayed
  I_decayed = (block.InputPort(3).Data == 0);
  
  %Calculate the phase voltages
  switch sector
      case 0
          if I_decayed(3) == 1 block.OutputPort(1).Data = [Vs-E(1)+E(2) 0.5*(-Vs+E(1)-E(2))];
          else block.OutputPort(1).Data = [Vs-E(1)+E(2) -E(2)+E(3)];
          end
          
      case 1
          if I_decayed(2) == 1 block.OutputPort(1).Data = [0.5*(Vs-E(1)+E(3)) 0.5*(Vs-E(1)+E(3))];
          else block.OutputPort(1).Data = [-E(1)+E(2) Vs-E(2)+E(3)];
          end
          
      case 2
          if I_decayed(1) == 1 block.OutputPort(1).Data = [0.5*(-Vs+E(2)-E(3)) Vs-E(2)+E(3)];
          else block.OutputPort(1).Data = [-Vs-E(1)+E(2) Vs-E(2)+E(3)];
          end
      
      case 3
          if I_decayed(3) == 1 block.OutputPort(1).Data = [-Vs-E(1)+E(2) 0.5*(Vs+E(1)-E(2))];
          else block.OutputPort(1).Data = [-Vs-E(1)+E(2) -E(2)+E(3)];
          end
          
      case 4
          if I_decayed(2) == 1 block.OutputPort(1).Data = [0.5*(-Vs-E(1)+E(3)) 0.5*(-Vs-E(1)+E(3))];
          else block.OutputPort(1).Data = [-E(1)+E(2) -Vs-E(2)+E(3)];
          end
          
      case 5
          if I_decayed(1) == 1 block.OutputPort(1).Data = [0.5*(Vs+E(2)-E(3)) -Vs-E(2)+E(3)];
          else block.OutputPort(1).Data = [Vs-E(1)+E(2) -Vs-E(2)+E(3)];
          end
  end
  
 
%endfunction


