function hil_comm(block)

  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 0;
  
  %% Register number of input and output ports
  block.NumInputPorts  = 4;
  block.NumOutputPorts = 1;

  %% Setup functional port properties  
  block.InputPort(1).Dimensions        = 1;
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(1).DatatypeID        = 1;
  block.InputPort(2).Dimensions        = 1;
  block.InputPort(2).DirectFeedthrough = false;
  block.InputPort(2).DatatypeID        = 1;
  block.InputPort(3).Dimensions        = 1;
  block.InputPort(3).DirectFeedthrough = false;
  block.InputPort(3).DatatypeID        = 1;
  block.InputPort(4).Dimensions        = 1;
  block.InputPort(4).DirectFeedthrough = false;
  block.InputPort(4).DatatypeID        = 1;
    
  block.OutputPort(1).Dimensions       = 1;
  block.OutputPort(1).DatatypeID       = 1; %single
  %% Set block sample time to inherited
  global SimulinkSampleTime
  block.SampleTimes = [SimulinkSampleTime 0];
  
  %% Register methods
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Terminate',               @Terminate);
  block.RegBlockMethod('Enable',               @DoEnable);
%endfunction

function DoEnable(~)
SystemConsole.refreshMasters;
global M
global SysConIndexPath
M = SystemConsole.openMaster(SysConIndexPath);%may be need to modify to ajust to hw

function Output(block)
global M
InputData = [];
for i = 1:4
    InputData = [InputData block.InputPort(i).Data];
end

%assumes that all inputs are single precision
InputData = uint32(hex2dec(num2hex(InputData)));
M.write('uint32',uint32(0),InputData);

%toggle valid
M.write('uint32',uint32(4*4),1);
M.write('uint32',uint32(4*4),0);

block.OutputPort(1).Data = typecast(uint32(M.read('uint32',uint32(5*4),1)),'single');

%endfunction

function Terminate(~)
global M
if (ismethod(M,'close'))
    M.close;
end
clear M;
%endfunction

