function flap_anim(block)
  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 0;
  
  %% Register number of input and output ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts  = 0;
  %% Setup functional port properties to dynamically
  %% inherited.
  %block.SetPreCompInpPortInfoToDynamic;
  %block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 1; %Range
  block.InputPort(1).DirectFeedthrough = false;
    
  %% Set block sample time to inherited
  block.SampleTimes = [0.01 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('SetInputPortSamplingMode',@SetInputPortSamplingMode);  
  %block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
%endfunction
%% 
  h_f2=findobj('type','figure','Tag','Flaps anim');
   
  if isempty(h_f2)
    h_flaps_anim=figure;
  else
    h_flaps_anim=h_f2;
  end

   set(h_flaps_anim,'name','Flaps Animation Figure', ...
           'renderer','zbuffer','resize','off', ...
           'OuterPosition',[10, 700, 525, 350], ...
           'Tag','Flaps anim');
   
   if ~isempty(h_flaps_anim)
     h_flaps_del = findobj(h_flaps_anim,'type','axes');
     delete(h_flaps_del);
     figure(h_flaps_anim);
   end


%Initialize Axes

   handle.axes(1)=axes;
   axis([0 500 -200 200]);
   set(handle.axes(1),'visible','on','xtick',[],'ytick',[],'ztick',[],'box','on', ...
           'dataaspectratio',[1 1 1], ...
           'units','normal', ...
           'position',[0.1 0.1 0.75 0.75], ...
           'Color',[.8 .8 .8], ...
           'drawmode','fast');

   
       
%define body
body.scale = 10; body.xoffset=2;body.yoffset=-5;
body.xdata = [0  10 10 10  23 23;
              40 15 15 15  37 37;
              40 15 15 15  37 37;
              0  10 10 10  23 23];
body.ydata = [0  10 0  4.5 10 0;
              0  10 0  4.5 10 0;
              10 15 -5 5.5 17 -7;
              10 10 0  5.5 10 0];
body.zdata = ones(4,6);


%define elevator
phi = 0;
elevator.axis_xoffset = 25; elevator.axis_yoffset = 5;
elevator.xdata = [-2 ;
                  -2 ;
                  12 ;
                  12 ];
              
elevator.ydata = [-0.5 ;
                  0.5 ;
                  0.5 ;
                  -0.5 ];
              
elevator.zdata = ones(4,1);

temp1 = elevator.xdata * cos(phi) - elevator.ydata * sin(phi);
temp2 = elevator.xdata * sin(phi) + elevator.ydata * cos(phi);
elevator.xdata = temp1;
elevator.ydata = temp2;

elevator.xdata = elevator.xdata + elevator.axis_xoffset;
elevator.ydata = elevator.ydata + elevator.axis_yoffset;
elevator.Cdata = [0;0;1];
body.xdata = [body.xdata elevator.xdata];
body.ydata = [body.ydata elevator.ydata];
body.zdata = [body.zdata elevator.zdata];

body.xdata = body.scale*(body.xdata+body.xoffset);
body.ydata = body.scale*(body.ydata+body.yoffset);

body.Cdata = [repmat([3;4;3;4],1,6) [1;1;1;1] ];
 
handle.body = patch(body.xdata,body.ydata,body.zdata,body.Cdata);
set(handle.axes(1),'userdata',get(handle.body,'vertices'));

%
% Set Handles of graphics in Figure UserData
%   
   set(h_flaps_anim,'userdata',handle);

function SetInputPortSamplingMode(block,idx,fd)
     block.InputPort(1).SamplingMode = fd;
     
     
function DoPostPropSetup(block)

  %% Setup Dwork
  
  
%endfunction

function InitConditions(block)

  %% Initialize Dwork
  
  
%endfunction

%function Output(block)
    
%endfunction

function Update(block)

%
% Obtain Handles of Figure Objects
%
handle = get(findobj('type','figure','Tag','Flaps anim'),'userdata');

if isempty(findobj('type','figure','Tag','Flaps anim'))
%figure has been manually closed
return
end

vert  = get(handle.axes(1),'userdata');

%define elevator
phi = block.InputPort(1).Data;
elevator.axis_xoffset = 25; elevator.axis_yoffset = 5;
elevator.xdata = [-2 ;
                  -2 ;
                  12 ;
                  12 ];
              
elevator.ydata = [-0.5 ;
                  0.5 ;
                  0.5 ;
                  -0.5 ];
              
elevator.zdata = ones(4,1);

temp1 = elevator.xdata * cos(phi) - elevator.ydata * sin(phi);
temp2 = elevator.xdata * sin(phi) + elevator.ydata * cos(phi);
elevator.xdata = temp1;
elevator.ydata = temp2;

elevator.xdata = elevator.xdata + elevator.axis_xoffset;
elevator.ydata = elevator.ydata + elevator.axis_yoffset;

body.scale = 10; body.xoffset=2;body.yoffset=-5;
vert(end-3:end,1) = body.scale*(elevator.xdata+body.xoffset);
vert(end-3:end,2) = body.scale*(elevator.ydata+body.yoffset);
set(handle.body,'vertices',vert);
drawnow;

%endfunction

