%This file defines parameters of BLDC motor from Kearfott Fin Actuator
Gear_Ratio = 251; %Ratio between Motor and Actuator? 

BLDC.R = 0.42e0;      %DC resistance of motor coil
BLDC.L = 0.38e-3;   %Inductance of motor coil

%Inertia calculation
BLDC.Jrotor = 0.0028;      %Inertia in-oz-sec^2
BLDC.Jact = 222.5;    %Inertia in-oz-sec^2
BLDC.J = BLDC.Jrotor + BLDC.Jact * (1/Gear_Ratio)^2;

BLDC.Kf = 1e-6;        %Friction coeficient  -estimated
BLDC.Ke = 1.25e-5;      %Back EMF coefficient 4.7V/KRPM
BLDC.Kt = 6.3;      %Torque constant
BLDC.P  = 1;        % Number of pole-pairs
%Define State Matrix for BLDC
BLDC.A = [-BLDC.R/BLDC.L 0 0 0;0 -BLDC.R/BLDC.L 0 0;0 0 -BLDC.Kf/BLDC.J 0;0 0 1 0];

%Define Drive Matrix for BLDC
BLDC.B = [2/(3*BLDC.L) 1/(3*BLDC.L) 0;-1/(3*BLDC.L) 1/(3*BLDC.L) 0;0 0 1/BLDC.J;0 0 0];

%Define output-state matrix
BLDC.C = [1 0 0 0;0 1 0 0;-1 -1 0 0;0 0 1 0;0 0 0 1];

%Define output-drive matrix
BLDC.D = zeros(5,3);

%Define Fins Load
BLDC.Load = 10;

%% Control Loop Parameters
%Position Loop
Controller.P.Kp = 160e3;

%Velocity Loop
Controller.W.Kp = 0.05;
Controller.W.Ki = 2;

%Torque Loop
Controller.T.Kp = 1.08;
Controller.T.Ki = 400;
Controller.T.Kd = 4e-4;


