-- (C) 2010 Altera Corporation. All rights reserved.
-- Your use of Altera Corporation's design tools, logic functions and other
-- software and tools, and its AMPP partner logic functions, and any output
-- files any of the foregoing (including device programming or simulation
-- files), and any associated documentation or information are expressly subject
-- to the terms and conditions of the Altera Program License Subscription
-- Agreement, Altera MegaCore Function License Agreement, or other applicable
-- license agreement, including, without limitation, that your use is for the
-- sole purpose of programming logic devices manufactured by Altera and sold by
-- Altera or its authorized distributors.  Please refer to the applicable
-- agreement for further details.


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION CORE LIBRARY             ***
--***                                             ***
--***   DP_ADDB.VHD                               ***
--***                                             ***
--***   Function: Behavioral Fixed Point Adder    ***
--***                                             ***
--***   31/01/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_addb IS 
GENERIC (
         width : positive := 64;
         pipes : positive := 1
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      carryin : IN STD_LOGIC;
      
      cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
     );
END dp_addb;

ARCHITECTURE rtl OF dp_addb IS

  type pipefftype IS ARRAY (pipes DOWNTO 1) OF STD_LOGIC_VECTOR (width DOWNTO 1);
  
  signal delff : STD_LOGIC_VECTOR (width DOWNTO 1);
  signal pipeff : pipefftype;
  signal ccnode : STD_LOGIC_VECTOR (width DOWNTO 1);
  signal zerovec : STD_LOGIC_VECTOR (width-1 DOWNTO 1);
    
BEGIN
  
  gza: FOR k IN 1 TO width-1 GENERATE
    zerovec(k) <= '0';
  END GENERATE;

  ccnode <= aa + bb + (zerovec & carryin);
  
  gda: IF (pipes = 1) GENERATE
  
    pda: PROCESS (sysclk,reset)
    BEGIN

      IF (reset = '1') THEN
    
        FOR k IN 1 TO width LOOP
          delff(k) <= '0';
        END LOOP;
     
      ELSIF (rising_edge(sysclk)) THEN

        IF (enable = '1') THEN   
          delff <= ccnode;
        END IF;

      END IF;

    END PROCESS;
    
    cc <= delff;
    
  END GENERATE;
  
  gpa: IF (pipes > 1) GENERATE
  
    ppa: PROCESS (sysclk,reset)
    BEGIN

      IF (reset = '1') THEN
        
        FOR k IN 1 TO pipes LOOP 
          FOR j IN 1 TO width LOOP
            pipeff(k)(j) <= '0';
          END LOOP;
        END LOOP;
   
      ELSIF (rising_edge(sysclk)) THEN

        IF (enable = '1') THEN   
          pipeff(1)(width DOWNTO 1) <= ccnode;
          FOR k IN 2 TO pipes LOOP
            pipeff(k)(width DOWNTO 1) <= pipeff(k-1)(width DOWNTO 1);
          END LOOP;
        END IF;

      END IF;

    END PROCESS;

    cc <= pipeff(pipes)(width DOWNTO 1);
          
  END GENERATE;
       
END rtl;


LIBRARY ieee;
LIBRARY work;
LIBRARY lpm;
USE lpm.all;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CONVERSION - CORE LEVEL    ***
--***                                             ***
--***   DP_ADDPIPE.VHD                            ***
--***                                             ***
--***   Function: Adder                           ***
--***                                             ***
--***   14/07/07 ML                               ***
--***                                             ***
--***   (c) 2007 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_addpipe IS
GENERIC (
         width : positive := 64;
         pipes : positive := 1
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      carryin : IN STD_LOGIC;
      
      cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
     );
END dp_addpipe;

ARCHITECTURE syn of dp_addpipe IS

  component lpm_add_sub
  GENERIC (
		     lpm_direction		: STRING;
		     lpm_hint		: STRING;
		     lpm_pipeline		: NATURAL;
		     lpm_type		: STRING;
		     lpm_width		: NATURAL
	       );
	PORT (
			dataa	: IN STD_LOGIC_VECTOR (lpm_width-1 DOWNTO 0);
			datab	: IN STD_LOGIC_VECTOR (lpm_width-1 DOWNTO 0);
			cin	: IN STD_LOGIC ;
			clken	: IN STD_LOGIC ;
			aclr	: IN STD_LOGIC ;
			clock	: IN STD_LOGIC ;
			result	: OUT STD_LOGIC_VECTOR (lpm_width-1 DOWNTO 0)
	     );
  end component;

BEGIN
  
  addtwo: lpm_add_sub
  GENERIC MAP (
		       lpm_direction => "ADD",
		       lpm_hint => "ONE_INPUT_IS_CONSTANT=NO,CIN_USED=YES",
		       lpm_pipeline => pipes,
		       lpm_type => "LPM_ADD_SUB",
		       lpm_width => width
	           )
  PORT MAP (
  		    dataa => aa,
		    datab => bb,
		    cin => carryin,
		    clken => enable,
		    aclr => reset,
		    clock => sysclk,
		    result => cc
	       );  
  
END syn;


LIBRARY ieee;
LIBRARY work;
LIBRARY lpm;
USE lpm.all;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION CORE LIBRARY             ***
--***                                             ***
--***   DP_ADDS.VHD                               ***
--***                                             ***
--***   Function: Synthesizable Fixed Point Adder ***
--***                                             ***
--***   31/01/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_adds IS
GENERIC (
         width : positive := 64;
         pipes : positive := 1
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      carryin : IN STD_LOGIC;
      
      cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
     );
END dp_adds;

ARCHITECTURE syn of dp_adds IS

  component lpm_add_sub
  GENERIC (
		     lpm_direction		: STRING;
		     lpm_hint		: STRING;
		     lpm_pipeline		: NATURAL;
		     lpm_type		: STRING;
		     lpm_width		: NATURAL
	       );
	PORT (
			dataa	: IN STD_LOGIC_VECTOR (lpm_width-1 DOWNTO 0);
			datab	: IN STD_LOGIC_VECTOR (lpm_width-1 DOWNTO 0);
			cin	: IN STD_LOGIC ;
			clken	: IN STD_LOGIC ;
			aclr	: IN STD_LOGIC ;
			clock	: IN STD_LOGIC ;
			result	: OUT STD_LOGIC_VECTOR (lpm_width-1 DOWNTO 0)
	     );
  end component;

BEGIN
  
  addtwo: lpm_add_sub
  GENERIC MAP (
		       lpm_direction => "ADD",
		       lpm_hint => "ONE_INPUT_IS_CONSTANT=NO,CIN_USED=YES",
		       lpm_pipeline => pipes,
		       lpm_type => "LPM_ADD_SUB",
		       lpm_width => width
	           )
  PORT MAP (
  		    dataa => aa,
		    datab => bb,
		    cin => carryin,
		    clken => enable,
		    aclr => reset,
		    clock => sysclk,
		    result => cc
	       );  
  
END syn;


LIBRARY ieee;
LIBRARY work;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_signed.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOAT CONVERT - CORE LEVEL                ***
--***                                             ***
--***   DP_CLZ64.VHD                              ***
--***                                             ***
--***   Function: Combinatorial Count Leading     ***
--***             Zeroes (64 bits)                ***
--***                                             ***
--***   01/12/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_clz64 IS
PORT (
      mantissa : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
      
      leading : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
     );
END dp_clz64;

ARCHITECTURE rtl of dp_clz64 IS

  type positiontype IS ARRAY (11 DOWNTO 1) OF STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  signal position, positionmux : positiontype;
  signal zerogroup, firstzero : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal lastman : STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  component dp_pos
  GENERIC (start: integer := 0);
  PORT 
       (
        ingroup : IN STD_LOGIC_VECTOR (6 DOWNTO 1); 
        
        position : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
       );
  end component;
  
BEGIN
     
  zerogroup(1) <= mantissa(64) OR mantissa(63) OR mantissa(62) OR mantissa(61) OR mantissa(60) OR mantissa(59);
  zerogroup(2) <= mantissa(58) OR mantissa(57) OR mantissa(56) OR mantissa(55) OR mantissa(54) OR mantissa(53);
  zerogroup(3) <= mantissa(52) OR mantissa(51) OR mantissa(50) OR mantissa(49) OR mantissa(48) OR mantissa(47);
  zerogroup(4) <= mantissa(46) OR mantissa(45) OR mantissa(44) OR mantissa(43) OR mantissa(42) OR mantissa(41);
  zerogroup(5) <= mantissa(40) OR mantissa(39) OR mantissa(38) OR mantissa(37) OR mantissa(36) OR mantissa(35);
  zerogroup(6) <= mantissa(34) OR mantissa(33) OR mantissa(32) OR mantissa(31) OR mantissa(30) OR mantissa(29);
  zerogroup(7) <= mantissa(28) OR mantissa(27) OR mantissa(26) OR mantissa(25) OR mantissa(24) OR mantissa(23);
  zerogroup(8) <= mantissa(22) OR mantissa(21) OR mantissa(20) OR mantissa(19) OR mantissa(18) OR mantissa(17);
  zerogroup(9) <= mantissa(16) OR mantissa(15) OR mantissa(14) OR mantissa(13) OR mantissa(12) OR mantissa(11); 
  zerogroup(10) <= mantissa(10) OR mantissa(9) OR mantissa(8) OR mantissa(7) OR mantissa(6) OR mantissa(5); 
  zerogroup(11) <= mantissa(4) OR mantissa(3) OR mantissa(2) OR mantissa(1); 

  lastman <= mantissa(4 DOWNTO 1) & "00";
  
  pone: dp_pos 
  GENERIC MAP (start=>60) 
  PORT MAP (ingroup=>lastman,position=>position(11)(6 DOWNTO 1));
  ptwo: dp_pos 
  GENERIC MAP (start=>54) 
  PORT MAP (ingroup=>mantissa(10 DOWNTO 5),position=>position(10)(6 DOWNTO 1));
  pthr: dp_pos 
  GENERIC MAP (start=>48) 
  PORT MAP (ingroup=>mantissa(16 DOWNTO 11),position=>position(9)(6 DOWNTO 1));
  pfor: dp_pos 
  GENERIC MAP (start=>42) 
  PORT MAP (ingroup=>mantissa(22 DOWNTO 17),position=>position(8)(6 DOWNTO 1));
  pfiv: dp_pos
  GENERIC MAP (start=>36) 
  PORT MAP (ingroup=>mantissa(28 DOWNTO 23),position=>position(7)(6 DOWNTO 1));
  psix: dp_pos 
  GENERIC MAP (start=>30) 
  PORT MAP (ingroup=>mantissa(34 DOWNTO 29),position=>position(6)(6 DOWNTO 1));
  psev: dp_pos 
  GENERIC MAP (start=>24) 
  PORT MAP (ingroup=>mantissa(40 DOWNTO 35),position=>position(5)(6 DOWNTO 1));
  pegt: dp_pos 
  GENERIC MAP (start=>18) 
  PORT MAP (ingroup=>mantissa(46 DOWNTO 41),position=>position(4)(6 DOWNTO 1));  
  pnin: dp_pos 
  GENERIC MAP (start=>12) 
  PORT MAP (ingroup=>mantissa(52 DOWNTO 47),position=>position(3)(6 DOWNTO 1));
  pten: dp_pos 
  GENERIC MAP (start=>6) 
  PORT MAP (ingroup=>mantissa(58 DOWNTO 53),position=>position(2)(6 DOWNTO 1));
  pelv: dp_pos 
  GENERIC MAP (start=>0) 
  PORT MAP (ingroup=>mantissa(64 DOWNTO 59),position=>position(1)(6 DOWNTO 1));

  firstzero(1) <= zerogroup(1);
  firstzero(2) <= NOT(zerogroup(1)) AND zerogroup(2);
  firstzero(3) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND zerogroup(3);
  firstzero(4) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND zerogroup(4);
  firstzero(5) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND zerogroup(5);
  firstzero(6) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND zerogroup(6);                
  firstzero(7) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND zerogroup(7); 
  firstzero(8) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND zerogroup(8); 
  firstzero(9) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND NOT(zerogroup(8)) 
                  AND zerogroup(9);
  firstzero(10) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                   AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND NOT(zerogroup(8)) 
                   AND NOT(zerogroup(9)) AND zerogroup(10);
  firstzero(11) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                   AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND NOT(zerogroup(8)) 
                   AND NOT(zerogroup(9)) AND NOT(zerogroup(10)) AND zerogroup(11); 
                
gma: FOR k IN 1 TO 6 GENERATE
  positionmux(1)(k) <= position(1)(k) AND firstzero(1);
  gmb: FOR j IN 2 TO 11 GENERATE
    positionmux(j)(k) <= positionmux(j-1)(k) OR (position(j)(k) AND firstzero(j));
  END GENERATE;
END GENERATE;
  
leading <= positionmux(11)(6 DOWNTO 1);
                                               
END rtl;


LIBRARY ieee;
LIBRARY work;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_signed.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOAT CONVERT - CORE LEVEL                ***
--***                                             ***
--***   DP_CLZPIPE64.VHD                          ***
--***                                             ***
--***   Function: Pipelined, Count Leading Zeroes ***
--***                                             ***
--***   01/12/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_clzpipe64 IS
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      mantissa : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
      
      leading : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
     );
END dp_clzpipe64;

ARCHITECTURE rtl of dp_clzpipe64 IS

  type positiontype IS ARRAY (11 DOWNTO 1) OF STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  signal position, positionff, positionmux : positiontype;
  signal zerogroupff, firstzero : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal lastman : STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  component dp_pos
  GENERIC (start: integer := 0);
  PORT 
       (
        ingroup : IN STD_LOGIC_VECTOR (6 DOWNTO 1); 
        
        position : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
       );
  end component;
  
BEGIN

  pp: PROCESS (sysclk,reset)
  BEGIN
    
    IF (reset = '1') THEN
      
      FOR k IN 1 TO 11 LOOP
        zerogroupff(k) <= '0';
        FOR j IN 1 TO 6 LOOP
          positionff(k)(j) <= '0';
        END LOOP;
      END LOOP;
  
    ELSIF (rising_edge(sysclk)) THEN
      
      IF (enable = '1') THEN
     
        zerogroupff(1) <= mantissa(64) OR mantissa(63) OR mantissa(62) OR mantissa(61) OR mantissa(60) OR mantissa(59);
        zerogroupff(2) <= mantissa(58) OR mantissa(57) OR mantissa(56) OR mantissa(55) OR mantissa(54) OR mantissa(53);
        zerogroupff(3) <= mantissa(52) OR mantissa(51) OR mantissa(50) OR mantissa(49) OR mantissa(48) OR mantissa(47);
        zerogroupff(4) <= mantissa(46) OR mantissa(45) OR mantissa(44) OR mantissa(43) OR mantissa(42) OR mantissa(41);
        zerogroupff(5) <= mantissa(40) OR mantissa(39) OR mantissa(38) OR mantissa(37) OR mantissa(36) OR mantissa(35);
        zerogroupff(6) <= mantissa(34) OR mantissa(33) OR mantissa(32) OR mantissa(31) OR mantissa(30) OR mantissa(29);
        zerogroupff(7) <= mantissa(28) OR mantissa(27) OR mantissa(26) OR mantissa(25) OR mantissa(24) OR mantissa(23);
        zerogroupff(8) <= mantissa(22) OR mantissa(21) OR mantissa(20) OR mantissa(19) OR mantissa(18) OR mantissa(17);
        zerogroupff(9) <= mantissa(16) OR mantissa(15) OR mantissa(14) OR mantissa(13) OR mantissa(12) OR mantissa(11); 
        zerogroupff(10) <= mantissa(10) OR mantissa(9) OR mantissa(8) OR mantissa(7) OR mantissa(6) OR mantissa(5); 
        zerogroupff(11) <= mantissa(4) OR mantissa(3) OR mantissa(2) OR mantissa(1);  
        FOR k IN 1 TO 11 LOOP
          positionff(k)(6 DOWNTO 1) <= position(k)(6 DOWNTO 1);
        END LOOP;
     
      END IF;
    
    END IF;
  
  END PROCESS;

  lastman <= mantissa(4 DOWNTO 1) & "00";
  
  pone: dp_pos 
  GENERIC MAP (start=>60) 
  PORT MAP (ingroup=>lastman,position=>position(11)(6 DOWNTO 1));
  ptwo: dp_pos 
  GENERIC MAP (start=>54) 
  PORT MAP (ingroup=>mantissa(10 DOWNTO 5),position=>position(10)(6 DOWNTO 1));
  pthr: dp_pos 
  GENERIC MAP (start=>48) 
  PORT MAP (ingroup=>mantissa(16 DOWNTO 11),position=>position(9)(6 DOWNTO 1));
  pfor: dp_pos 
  GENERIC MAP (start=>42) 
  PORT MAP (ingroup=>mantissa(22 DOWNTO 17),position=>position(8)(6 DOWNTO 1));
  pfiv: dp_pos
  GENERIC MAP (start=>36) 
  PORT MAP (ingroup=>mantissa(28 DOWNTO 23),position=>position(7)(6 DOWNTO 1));
  psix: dp_pos 
  GENERIC MAP (start=>30) 
  PORT MAP (ingroup=>mantissa(34 DOWNTO 29),position=>position(6)(6 DOWNTO 1));
  psev: dp_pos 
  GENERIC MAP (start=>24) 
  PORT MAP (ingroup=>mantissa(40 DOWNTO 35),position=>position(5)(6 DOWNTO 1));
  pegt: dp_pos 
  GENERIC MAP (start=>18) 
  PORT MAP (ingroup=>mantissa(46 DOWNTO 41),position=>position(4)(6 DOWNTO 1));  
  pnin: dp_pos 
  GENERIC MAP (start=>12) 
  PORT MAP (ingroup=>mantissa(52 DOWNTO 47),position=>position(3)(6 DOWNTO 1));
  pten: dp_pos 
  GENERIC MAP (start=>6) 
  PORT MAP (ingroup=>mantissa(58 DOWNTO 53),position=>position(2)(6 DOWNTO 1));
  pelv: dp_pos 
  GENERIC MAP (start=>0) 
  PORT MAP (ingroup=>mantissa(64 DOWNTO 59),position=>position(1)(6 DOWNTO 1));

  firstzero(1) <= zerogroupff(1);
  firstzero(2) <= NOT(zerogroupff(1)) AND zerogroupff(2);
  firstzero(3) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND zerogroupff(3);
  firstzero(4) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND zerogroupff(4);
  firstzero(5) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND NOT(zerogroupff(4)) 
                  AND zerogroupff(5);
  firstzero(6) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND NOT(zerogroupff(4)) 
                  AND NOT(zerogroupff(5)) AND zerogroupff(6);                
  firstzero(7) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND NOT(zerogroupff(4)) 
                  AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND zerogroupff(7); 
  firstzero(8) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND NOT(zerogroupff(4)) 
                  AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND NOT(zerogroupff(7)) AND zerogroupff(8); 
  firstzero(9) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND NOT(zerogroupff(4)) 
                  AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND NOT(zerogroupff(7)) AND NOT(zerogroupff(8)) 
                  AND zerogroupff(9); 
  firstzero(10) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND NOT(zerogroupff(4)) 
                   AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND NOT(zerogroupff(7)) AND NOT(zerogroupff(8)) 
                   AND NOT(zerogroupff(9)) AND zerogroupff(10);
  firstzero(11) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND NOT(zerogroupff(4)) 
                   AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND NOT(zerogroupff(7)) AND NOT(zerogroupff(8)) 
                   AND NOT(zerogroupff(9)) AND NOT(zerogroupff(10)) AND zerogroupff(11);
                                   
gma: FOR k IN 1 TO 6 GENERATE
  positionmux(1)(k) <= positionff(1)(k) AND firstzero(1);
  gmb: FOR j IN 2 TO 11 GENERATE
    positionmux(j)(k) <= positionmux(j-1)(k) OR (positionff(j)(k) AND firstzero(j));
  END GENERATE;
END GENERATE;
  
leading <= positionmux(11)(6 DOWNTO 1);
                                               
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION DIVIDER - CORE           ***
--***                                             ***
--***   DP_DIV_CORE.VHD                           ***
--***                                             ***
--***   Function: Fixed Point 54 Bit Divider      ***
--***                                             ***
--***   Multiplier Convergence Algorithm          ***
--***                                             ***
--***   31/01/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***   24/04/09 - SIII/SIV multiplier support    ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--*** SII Latency = 19 + 4*doublespeed            ***
--*** SIII/IV Latency = 18 + 2*doublespeed        ***
--***************************************************

ENTITY dp_div_core IS 
GENERIC (
         doublespeed : integer := 0; -- 0/1
         doubleaccuracy : integer := 0;  -- 0 = pruned multiplier, 1 = normal multiplier
         device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1      -- 0/1      
        ); 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      dividend : IN STD_LOGIC_VECTOR (54 DOWNTO 1);
      divisor : IN STD_LOGIC_VECTOR (54 DOWNTO 1);

		quotient : OUT STD_LOGIC_VECTOR (55 DOWNTO 1)
		);
END dp_div_core;

ARCHITECTURE rtl OF dp_div_core IS

  --SII mullatency = doublespeed+5, SIII/IV mullatency = 4
  constant mullatency : positive := doublespeed+5 - device*(1+doublespeed);
  --SII addlatency = 2*doublespeed+1, SIII/IV addlatency = doublespeed+1
  constant addlatency : positive := 2*doublespeed+1 - device*doublespeed;
 
  signal zerovec : STD_LOGIC_VECTOR (54 DOWNTO 1);
  
  -- estimate
  signal invdivisor : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal dividenddel, divisordel : STD_LOGIC_VECTOR (54 DOWNTO 1);
  -- scale
  signal scaleden, scalenum : STD_LOGIC_VECTOR (54 DOWNTO 1);
  -- iteration
  signal twonode, subscaleden : STD_LOGIC_VECTOR (55 DOWNTO 1);
  signal guessone : STD_LOGIC_VECTOR (55 DOWNTO 1);
  signal guessonevec : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal absoluteval : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal absolutevalff, absoluteff : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal abscarryff : STD_LOGIC;
  signal delscalenum : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal iteratenumnode : STD_LOGIC_VECTOR (72 DOWNTO 1);
  signal iteratenum : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal absoluteerror : STD_LOGIC_VECTOR (72 DOWNTO 1);
  signal mulabsguesslower : STD_LOGIC_VECTOR (19 DOWNTO 1);
  signal mulabsguessnode : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal mulabsguess : STD_LOGIC_VECTOR (54 DOWNTO 1);

  signal quotientnode : STD_LOGIC_VECTOR (72 DOWNTO 1);
  
  component fp_div_est IS 
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        divisor : IN STD_LOGIC_VECTOR (19 DOWNTO 1);

		  invdivisor : OUT STD_LOGIC_VECTOR (18 DOWNTO 1)
		  );
  end component;
  
  component fp_fxmul  
  GENERIC (
           widthaa : positive := 18;
           widthbb : positive := 18;
           widthcc : positive := 36;
           pipes : positive := 1;
           accuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        dataaa : IN STD_LOGIC_VECTOR (widthaa DOWNTO 1);
        databb : IN STD_LOGIC_VECTOR (widthbb DOWNTO 1); 
      
        result : OUT STD_LOGIC_VECTOR (widthcc DOWNTO 1)
       );
  end component;
  
  component dp_fxadd 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1;
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
   
  component fp_del
  GENERIC (
           width : positive := 64;
           pipes : positive := 2
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
       
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
   end component;  
       
BEGIN
  
  gza: FOR k IN 1 TO 54 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  invcore: fp_div_est 
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            divisor=>divisor(54 DOWNTO 36),invdivisor=>invdivisor);
  
  delinone: fp_del
  GENERIC MAP (width=>54,pipes=>5)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>dividend,cc=>dividenddel);
            
  delintwo: fp_del
  GENERIC MAP (width=>54,pipes=>5)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>divisor,cc=>divisordel);
            
  --**********************************
  --*** ITERATION 0 - SCALE INPUTS ***
  --**********************************
  
  -- in level 5, out level 8+doublespeed
  mulscaleone: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>18,widthcc=>54,
               pipes=>3+doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>divisordel,databb=>invdivisor,
            result=>scaleden);
  
  mulscaletwo: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>18,widthcc=>54,
               pipes=>3+doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>dividenddel,databb=>invdivisor,
            result=>scalenum);
  
  --********************
  --*** ITERATION 1  ***
  --********************
  
  twonode <= '1' & zerovec(54 DOWNTO 1);
  
  gta: FOR k IN 1 TO 54 GENERATE
    subscaleden(k) <= NOT(scaleden(k));
  END GENERATE;
  subscaleden(55) <= '1';

  -- in level 8+speed, outlevel 9+2*speed
  addtwoone: dp_fxadd 
  GENERIC MAP (width=>55,pipes=>doublespeed+1,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>twonode,bb=>subscaleden,carryin=>'1',
            cc=>guessone);  
  
  guessonevec <= guessone(54 DOWNTO 1);
  
  -- absolute value of guess lower 36 bits
  -- this is still correct, because (for positive), value will be 1.(17 zeros)error
  -- can also be calculated from guessonevec (code below)
  -- gabs: FOR k IN 1 TO 36 GENERATE
  --   absoluteval(k) <= guessonevec(k) XOR NOT(guessonevec(54));
  -- END GENERATE;
  gabs: FOR k IN 1 TO 36 GENERATE
    absoluteval(k) <= scaleden(k) XOR NOT(scaleden(54));
  END GENERATE;
  
  pta: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN

      FOR k IN 1 TO 36 LOOP
        absolutevalff(k) <= '0';
        absoluteff(k) <= '0';
      END LOOP;
      abscarryff <= '0';
      
    ELSIF (rising_edge(sysclk)) THEN
      
      IF (enable = '1') THEN
          
        absolutevalff <= absoluteval; -- out level 9+speed
        abscarryff <= NOT(scaleden(54)); 
        absoluteff <= absolutevalff + 
                     (zerovec(35 DOWNTO 1) & abscarryff); -- out level 10+speed
        
      END IF;
    
    END IF;
    
  END PROCESS;

  deloneone: fp_del
  GENERIC MAP (width=>54,pipes=>doublespeed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>scalenum,
            cc=>delscalenum);
    
  -- in level 9+2*doublespeed
  -- SII out level 14+3*doublespeed
  -- SIII/IV out level 13+2*doublespeed
  muloneone: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>54,widthcc=>72,pipes=>mullatency,
               accuracy=>doubleaccuracy,device=>device,
               synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>delscalenum,databb=>guessonevec,
            result=>iteratenumnode);
         
  gia: IF (device = 0) GENERATE     
    iteratenum <= iteratenumnode(71 DOWNTO 18);
  END GENERATE;

  gib: IF (device = 1) GENERATE 
    -- SIII/IV out level 14+2*doublespeed
    delit: fp_del
    GENERIC MAP (width=>54,pipes=>1)   
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>iteratenumnode(71 DOWNTO 18),
              cc=>iteratenum);
  END GENERATE;
  
  -- in level 10+doublespeed, out level 13+doublespeed
  mulonetwo: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>36,widthcc=>72,pipes=>3,
               synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>absoluteff,databb=>absoluteff,
            result=>absoluteerror);

  -- if speed = 0, delay absoluteerror 1 clock, else 2
  -- this guess always positive (check??)
  -- change here, error can be [19:1], not [18:1] - this is because (1.[17 zeros].error)^2
  -- gives 1.[34 zeros].error
  
  -- in level 13+speed
  -- SII out level 14+3*speed
  -- SIII/IV out level 14+2*speed
  addtwotwo: dp_fxadd 
  GENERIC MAP (width=>19,pipes=>addlatency,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>absoluteerror(72 DOWNTO 54),
            bb=>zerovec(19 DOWNTO 1),
            carryin=>absoluteerror(53),
            cc=>mulabsguesslower);  
            
  mulabsguessnode(19 DOWNTO 1) <= mulabsguesslower;
  gmga: FOR k IN 20 TO 53 GENERATE
    mulabsguessnode(k) <= '0';
  END GENERATE;
  mulabsguessnode(54) <= '1';

  mulabsguess <= mulabsguessnode;
  
  --*********************
  --*** OUTPUT SCALE  ***
  --*********************
  
  -- SII: in level 14+3*doublespeed, out level 19+4*doublespeed
  -- SIII/IV: in level 14+2*doublespeed, out level 18+2*doublespeed
  mulout: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>54,widthcc=>72,pipes=>mullatency,
               accuracy=>doubleaccuracy,device=>device,
               synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>iteratenum,databb=>mulabsguess,
            result=>quotientnode);
            
  quotient <= quotientnode(71 DOWNTO 17);
                  
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION DIVIDER - OUTPUT STAGE   ***
--***                                             ***
--***   DP_DIVNORND.VHD                           ***
--***                                             ***
--***   Function: Output Stage, No Rounding       ***
--***                                             ***
--***   31/01/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes: Latency = 1                          ***
--***************************************************

ENTITY dp_divnornd IS 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentdiv : IN STD_LOGIC_VECTOR (13 DOWNTO 1);
      mantissadiv : IN STD_LOGIC_VECTOR (53 DOWNTO 1); -- includes roundbit
      nanin : IN STD_LOGIC;
      dividebyzeroin : IN STD_LOGIC;

		signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      --------------------------------------------------
      nanout : OUT STD_LOGIC;
      invalidout : OUT STD_LOGIC;
      dividebyzeroout : OUT STD_LOGIC
		);
END dp_divnornd;

ARCHITECTURE rtl OF dp_divnornd IS

  constant expwidth : positive := 11;
  constant manwidth : positive := 52;
  
  type exponentfftype IS ARRAY (2 DOWNTO 1) OF STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  
  signal zerovec : STD_LOGIC_VECTOR (manwidth-1 DOWNTO 1);
  signal signff : STD_LOGIC;
  signal nanff : STD_LOGIC;
  signal dividebyzeroff : STD_LOGIC;  
  signal mantissaff : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal exponentff : STD_LOGIC_VECTOR (expwidth+2 DOWNTO 1);
  
  signal infinitygen : STD_LOGIC_VECTOR (expwidth+1 DOWNTO 1);
  signal zerogen : STD_LOGIC_VECTOR (expwidth+1 DOWNTO 1);  
  signal setmanzero, setmanmax : STD_LOGIC;
  signal setexpzero, setexpmax : STD_LOGIC;

BEGIN
    
  gzv: FOR k IN 1 TO manwidth-1 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  pra: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN
        
      signff <= '0';
      nanff <= '0';
      dividebyzeroff <= '0';
      FOR k IN 1 TO manwidth LOOP
        mantissaff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        exponentff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF(enable = '1') THEN 
      
        signff <= signin;
        nanff <= nanin;
        dividebyzeroff <= dividebyzeroin;

        -- nan takes precedence (set max)
        -- nan takes precedence (set max)  
        FOR k IN 1 TO manwidth LOOP
          mantissaff(k) <= (mantissadiv(k+1) AND setmanzero) OR setmanmax;
        END LOOP;
               
        FOR k IN 1 TO expwidth LOOP
          exponentff(k) <= (exponentdiv(k) AND setexpzero) OR setexpmax;
        END LOOP;
      
      END IF;
             
    END IF;
      
  END PROCESS;
                                                  
--**********************************
--*** CHECK GENERATED CONDITIONS ***   
--**********************************

  -- infinity if exponent >= 255
  infinitygen(1) <= exponentdiv(1);
  gia: FOR k IN 2 TO expwidth GENERATE
    infinitygen(k) <= infinitygen(k-1) AND exponentdiv(k);
  END GENERATE;
  infinitygen(expwidth+1) <= infinitygen(expwidth) OR 
                            (exponentdiv(expwidth+1) AND 
                             NOT(exponentdiv(expwidth+2))); -- ;1' if infinity
                         
  -- zero if exponent <= 0
  zerogen(1) <= exponentdiv(1);
  gza: FOR k IN 2 TO expwidth GENERATE
    zerogen(k) <= zerogen(k-1) OR exponentdiv(k);
  END GENERATE;
  zerogen(expwidth+1) <= zerogen(expwidth) AND 
                         NOT(exponentdiv(expwidth+2)); -- '0' if zero
                    
  -- set mantissa to 0 when infinity or zero condition
  setmanzero <= NOT(infinitygen(expwidth+1)) AND zerogen(expwidth+1) AND NOT(dividebyzeroin);
  -- setmantissa to "11..11" when nan
  setmanmax <= nanin;
  -- set exponent to 0 when zero condition 
  setexpzero <= zerogen(expwidth+1);
  -- set exponent to "11..11" when nan, infinity, or divide by 0
  setexpmax <= nanin OR infinitygen(expwidth+1) OR dividebyzeroin;
                             
--***************
--*** OUTPUTS ***
--***************

  signout <= signff;   
  mantissaout <= mantissaff;
  exponentout <= exponentff(expwidth DOWNTO 1); 
  -----------------------------------------------
  nanout <= nanff;
  invalidout <= nanff;
  dividebyzeroout <= dividebyzeroff;

END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION EXPONENT(e) - TOP LEVEL  ***
--***                                             ***
--***   DP_EXP.VHD                                ***
--***                                             ***
--***   Function: IEEE754 DP EXP()                ***
--***                                             ***
--***   12/08/09 ML                               ***
--***                                             ***
--***   (c) 2009 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--*** Stratix II                                  ***
--*** Latency = 20 + 2*DoubleSpeed +              ***
--***           Roundconvert*(1+DoubleSpeed)      ***
--*** DoubleSpeed = 0, Roundconvert = 0 : 20      ***
--*** DoubleSpeed = 1, Roundconvert = 0 : 22      ***
--*** DoubleSpeed = 0, Roundconvert = 1 : 21      ***
--*** DoubleSpeed = 1, Roundconvert = 1 : 24      ***
--***                                             ***
--*** Stratix III                                 ***
--*** Latency = 18 +                              ***
--***           Roundconvert*(1+DoubleSpeed)      ***
--*** DoubleSpeed = 0, Roundconvert = 0 : 18      ***
--*** DoubleSpeed = 1, Roundconvert = 0 : 18      ***
--*** DoubleSpeed = 0, Roundconvert = 1 : 19      ***
--*** DoubleSpeed = 1, Roundconvert = 1 : 20      ***
--***                                             ***
--***************************************************

ENTITY dp_exp IS 
GENERIC (
         roundconvert : integer := 0; -- 0 = no round, 1 = round
         doubleaccuracy : integer := 0;  -- 0 = pruned multiplier, 1 = normal multiplier
         doublespeed : integer := 0;   -- 0/1
         device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1      -- 0/1    
        );          
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentin : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissain : IN STD_LOGIC_VECTOR (52 DOWNTO 1);

		  signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      --------------------------------------------------
      nanout : OUT STD_LOGIC;
      overflowout : OUT STD_LOGIC;
      underflowout : OUT STD_LOGIC
		);
END dp_exp;

ARCHITECTURE rtl OF dp_exp IS
  
  constant expwidth : positive := 11;
  constant manwidth : positive := 52;
  
  constant coredepth : positive := 19 + 2*doublespeed - device*(4 + 2*doublespeed);

  signal signinff : STD_LOGIC;
  signal maninff : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal expinff : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal signff : STD_LOGIC_VECTOR (coredepth-1 DOWNTO 1);    
  signal mantissanode : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal exponentnode : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal rangeerror : STD_LOGIC;
      
  -- conditions
  signal zeroman : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal zeroexp : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal maxexp : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal zeromaninff : STD_LOGIC;
  signal maxexpinff : STD_LOGIC;
  signal naninff : STD_LOGIC;
  signal nanff : STD_LOGIC_VECTOR (coredepth-3 DOWNTO 1);
  
  --*** SII Latency = 19 + 2*doublespeed            ***
  --*** SIII/IV Latency = 14                        ***    
  component dp_exp_core
  GENERIC (
           doublespeed : integer := 0;   -- 0/1
           doubleaccuracy : integer := 0;  -- 0 = pruned multiplier, 1 = normal multiplier
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 1      -- 0/1       
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aasgn : IN STD_LOGIC;
        aaman : IN STD_LOGIC_VECTOR (52 DOWNTO 1);
        aaexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);

        ccman : OUT STD_LOGIC_VECTOR (54 DOWNTO 1);
        ccexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        rangeerror : OUT STD_LOGIC
      );
  end component;

  component dp_expnornd
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        signin : IN STD_LOGIC;
        exponentexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaexp : IN STD_LOGIC_VECTOR (53 DOWNTO 1);
        nanin : IN STD_LOGIC;
        rangeerror : IN STD_LOGIC;

        exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        --------------------------------------------------
        nanout : OUT STD_LOGIC;
        overflowout : OUT STD_LOGIC;
        underflowout : OUT STD_LOGIC
		  );
  end component;
       	
  component dp_exprnd
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        signin : IN STD_LOGIC;
        exponentexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaexp : IN STD_LOGIC_VECTOR (53 DOWNTO 1);
        nanin : IN STD_LOGIC;
        rangeerror : IN STD_LOGIC;

        exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        --------------------------------------------------
        nanout : OUT STD_LOGIC;
        overflowout : OUT STD_LOGIC;
        underflowout : OUT STD_LOGIC
		  );
  end component;

  component dp_exprndpipe
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        signin : IN STD_LOGIC;
        exponentexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaexp : IN STD_LOGIC_VECTOR (53 DOWNTO 1);
        nanin : IN STD_LOGIC;
        rangeerror : IN STD_LOGIC;

        exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        --------------------------------------------------
        nanout : OUT STD_LOGIC;
        overflowout : OUT STD_LOGIC;
        underflowout : OUT STD_LOGIC
		  );
  end component;
  
BEGIN

  pma: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
  
      signinff <= '0';
      FOR k IN 1 TO manwidth LOOP
        maninff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        expinff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO coredepth-1 LOOP
        signff(k) <= '0';
      END LOOP;
    
    ELSIF (rising_edge(sysclk)) THEN

      IF (enable = '1') THEN
        
        signinff <= signin;
        maninff <= mantissain;
        expinff <= exponentin;

        signff(1) <= signinff;
        FOR k IN 2 TO coredepth-1 LOOP
          signff(k) <= signff(k-1);
        END LOOP;
                                                  
      END IF;
  
    END IF;
  
  END PROCESS;

--********************
--*** CHECK INPUTS ***
--********************

  zeroman(1) <= maninff(1);
  gca: FOR k IN 2 TO manwidth GENERATE
    zeroman(k) <= zeroman(k-1) OR maninff(k);
  END GENERATE; 
  zeroexp(1) <= expinff(1);
  gcb: FOR k IN 2 TO expwidth GENERATE
    zeroexp(k) <= zeroexp(k-1) OR expinff(k);
  END GENERATE;
  maxexp(1) <= expinff(1);
  gcc: FOR k IN 2 TO expwidth GENERATE
    maxexp(k) <= maxexp(k-1) AND expinff(k);
  END GENERATE;

  pcc: PROCESS (sysclk,reset)
  BEGIN
    
    IF (reset = '1') THEN
      
      zeromaninff <= '0';
      maxexpinff <= '0';  
      naninff <= '0';
      FOR k IN 1 TO coredepth-3 LOOP
        nanff(k) <= '0';
      END LOOP;
     
    ELSIF (rising_edge(sysclk)) THEN
            
      IF (enable = '1') THEN
     
        zeromaninff <= zeroman(manwidth);
        maxexpinff <= maxexp(expwidth);
    
        -- zero when man = 0, exp = 0
        -- infinity when man = 0, exp = max
        -- nan when man != 0, exp = max
    
        -- all ffs '1' when condition true
        naninff <= zeromaninff AND maxexpinff;

        -- nan output when nan input
        nanff(1) <= naninff;
        FOR k IN 2 TO coredepth-3 LOOP
          nanff(k) <= nanff(k-1);
        END LOOP;
      
      END IF;
   
    END IF;

  END PROCESS;


--****************
--*** EXP CORE ***
--****************

  expcore: dp_exp_core
  GENERIC MAP (doublespeed=>doublespeed,doubleaccuracy=>doubleaccuracy,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aasgn=>signin,aaman=>mantissain,aaexp=>exponentin,
            ccman=>mantissanode,ccexp=>exponentnode,
            rangeerror=>rangeerror);
           
--************************
--*** ROUND AND OUTPUT ***
--************************

  gra: IF (roundconvert = 0) GENERATE

    norndout: dp_expnornd
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              signin=>signff(coredepth-1),
              exponentexp=>exponentnode,
              mantissaexp=>mantissanode(53 DOWNTO 1),
              nanin=>nanff(coredepth-3),
              rangeerror=>rangeerror,

              exponentout=>exponentout,mantissaout=>mantissaout,
              nanout=>nanout,overflowout=>overflowout,underflowout=>underflowout);
            
  END GENERATE;
  
  grb: IF (roundconvert = 1 AND doublespeed = 0) GENERATE

    rndout: dp_exprnd
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              signin=>signff(coredepth-1),
              exponentexp=>exponentnode,
              mantissaexp=>mantissanode(53 DOWNTO 1),
              nanin=>nanff(coredepth-3),
              rangeerror=>rangeerror,

              exponentout=>exponentout,mantissaout=>mantissaout,
              nanout=>nanout,overflowout=>overflowout,underflowout=>underflowout);
            
  END GENERATE;

  grc: IF (roundconvert = 1 AND doublespeed = 1) GENERATE
    
    rndoutpipe: dp_exprndpipe
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              signin=>signff(coredepth-1),
              exponentexp=>exponentnode,
              mantissaexp=>mantissanode(53 DOWNTO 1),
              nanin=>nanff(coredepth-3),
              rangeerror=>rangeerror,

              exponentout=>exponentout,mantissaout=>mantissaout,
              nanout=>nanout,overflowout=>overflowout,underflowout=>underflowout);
            
  END GENERATE;
  
  signout <= '0';
  
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION EXPONENT(e) - CORE       ***
--***                                             ***
--***   DP_EXP_CORE.VHD                           ***
--***                                             ***
--***   Function: Double Precision Exponent Core  ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***   24/04/09 - SIII/SIV multiplier support    ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--*** SII Latency = 19 + 2*doublespeed            ***
--*** SIII/IV Latency = 17                        ***
--***************************************************

ENTITY dp_exp_core IS
GENERIC (
         doublespeed : integer := 0;   -- 0/1
         doubleaccuracy : integer := 0;  -- 0 = pruned multiplier, 1 = normal multiplier
         device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1      -- 0/1       
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aasgn : IN STD_LOGIC;
      aaman : IN STD_LOGIC_VECTOR (52 DOWNTO 1);
      aaexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);

      ccman : OUT STD_LOGIC_VECTOR (54 DOWNTO 1);
      ccexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      rangeerror : OUT STD_LOGIC
     );
END dp_exp_core;

ARCHITECTURE rtl OF dp_exp_core IS

  --SII mullatency = doublespeed+5, SIII/IV mullatency = 4
  constant mullatency : positive := doublespeed+5 - device*(1+doublespeed);
  constant ranlatency : positive := 15+2*doublespeed-device*(2+2*doublespeed);
  
  type expcalcfftype IS ARRAY ((ranlatency-4) DOWNTO 1) OF 
       STD_LOGIC_VECTOR (11 DOWNTO 1);
  
  signal zerovec : STD_LOGIC_VECTOR (54 DOWNTO 1);
  -- INPUT BLOCK & SHIFTER
  signal signff : STD_LOGIC_VECTOR (ranlatency+3 DOWNTO 1);
  signal aamanff, aamandelff : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal aaexpff : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal leftshift, rightshift : STD_LOGIC_VECTOR (12 DOWNTO 1);
  signal leftshiftff, rightshiftff : STD_LOGIC_VECTOR (10 DOWNTO 1);
  signal cmpexp : STD_LOGIC_VECTOR(11 DOWNTO 1);
  signal bigexpff : STD_LOGIC_VECTOR(2 DOWNTO 1);
  signal smallrightshift : STD_LOGIC;
  signal selshiftff : STD_LOGIC_VECTOR (2 DOWNTO 1);
  signal powerbus : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal leftone, lefttwo : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal rightone, righttwo, rightthree : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal leftff, rightff : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal powerff : STD_LOGIC_VECTOR (65 DOWNTO 1);
  signal decimalleft : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal decimalright : STD_LOGIC_VECTOR (10 DOWNTO 1);
  signal fractionalleft, fractionalright : STD_LOGIC_VECTOR (54 DOWNTO 1);
  -- TABLES
  signal addlutposff, addlutnegff : STD_LOGIC_VECTOR (10 DOWNTO 1);
  signal addluttwoff, addlutthrff : STD_LOGIC_VECTOR (10 DOWNTO 1);
  signal lutposmanff, lutnegmanff : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal luttwomanff, lutthrmanff : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal lutposexpff, lutnegexpff : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal luttwoexpff : STD_LOGIC;
  signal manpos, manneg, mantwo, manthr : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal exppos, expneg : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal exptwo : STD_LOGIC;
  signal lutonemanff, luttwomandelff : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal lutoneexpff : STD_LOGIC_VECTOR (11 DOWNTO 1); 
  signal luttwoexpdelff : STD_LOGIC;
  signal expcalcff : expcalcfftype;  
  -- OVER & UNDERFLOW
  signal powercheck : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal rangeff : STD_LOGIC_VECTOR (ranlatency DOWNTO 1);
  -- TAYLOR SERIES
  signal fraction : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal xterm : STD_LOGIC_VECTOR (33 DOWNTO 1);
  signal xsquareterm : STD_LOGIC_VECTOR (12 DOWNTO 1);
  signal approxff : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal lutthrmandel : STD_LOGIC_VECTOR (54 DOWNTO 1);
  -- MULTIPLY
  signal resultone : STD_LOGIC_VECTOR (72 DOWNTO 1);
  signal resultonedel : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal resulttwo, resultthr : STD_LOGIC_VECTOR (72 DOWNTO 1);
  -- NORMALIZE
  signal normshift : STD_LOGIC_VECTOR (2 DOWNTO 1);
  signal manoutff : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal expout, expoutff : STD_LOGIC_VECTOR (11 DOWNTO 1);
    
  component dp_explutpos
  PORT (
        add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
        manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
        manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1);
        exponent : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
       );
  end component;

  component dp_explutneg 
  PORT (
        add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
        manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
        manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1);
        exponent : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
       );
  end component;
    
  component dp_explut10 
  PORT (
        add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
        manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
        manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1);
        exponent : OUT STD_LOGIC
       );
  end component;
  
  component dp_explut20 
  PORT (
        add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
        manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
        manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1)
       );
  end component;

  component fp_fxmul
  GENERIC (
           widthaa : positive := 18;
           widthbb : positive := 18;
           widthcc : positive := 36;
           pipes : positive := 1;
           accuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        dataaa : IN STD_LOGIC_VECTOR (widthaa DOWNTO 1);
        databb : IN STD_LOGIC_VECTOR (widthbb DOWNTO 1); 
      
        result : OUT STD_LOGIC_VECTOR (widthcc DOWNTO 1)
       );
  end component;

  component fp_del
  GENERIC (
           width : positive := 64;
           pipes : positive := 2
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
       
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
   end component;  
     
BEGIN
    
  gza: FOR k IN 1 TO 54 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  --*******************
  --*** INPUT BLOCK ***
  --*******************
  
  psa: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN
    
      FOR k IN 1 TO (ranlatency+3) LOOP
        signff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 52 LOOP
        aamanff(k) <= '0';
        aamandelff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP
        aaexpff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 10 LOOP
        leftshiftff(k) <= '0';
        rightshiftff(k) <= '0';
	  END LOOP;
      selshiftff <= "00";
      FOR k IN 1 TO 64 LOOP
        leftff(k) <= '0';
        rightff(k) <= '0';
        powerff(k) <= '0';
      END LOOP;
	  powerff(65) <= '0';
	  bigexpff <= "00";
          
    ELSIF (rising_edge(sysclk)) THEN
    
      IF (enable = '1') THEN
          
        signff(1) <= aasgn;
        FOR k IN 2 TO (ranlatency+3) LOOP
          signff(k) <= signff(k-1);
        END LOOP;
        aamanff <= aaman;
        aamandelff <= aamanff;
        aaexpff <= aaexp;
            
        leftshiftff <= leftshift(10 DOWNTO 1);
        rightshiftff <= rightshift(10 DOWNTO 1);
        
        selshiftff(1) <= leftshift(12);
        selshiftff(2) <= selshiftff(1);
          
        -- level 3
        leftff <= lefttwo;
		-- mask out right barrel shifter output when shifting by 64 or more positions
		FOR k IN 1 TO 64 LOOP
		  rightff(k) <= rightthree(k) AND smallrightshift;
		END LOOP;
		-- overflow of left shifter matters only when the left shifted mantissa result is to be used
		bigexpff(2) <= bigexpff(1) AND NOT(selshiftff(2));
		bigexpff(1) <= NOT(cmpexp(11));
        
        -- level 4
        FOR k IN 1 TO 54 LOOP
          powerff(k) <= (fractionalleft(k) AND NOT(selshiftff(2))) OR 
                        (fractionalright(k) AND selshiftff(2));
        END LOOP;
        FOR k IN 1 TO 10 LOOP
          powerff(k+54) <= (decimalleft(k) AND NOT(selshiftff(2))) OR 
                           (decimalright(k) AND selshiftff(2));
        END LOOP;
		powerff(65) <= (decimalleft(11) AND NOT(selshiftff(2)));
		-- overflow bit required to catch exp(-1023.frac) case
     
      END IF;
 
    END IF;    
      
      
  END PROCESS;
 
  leftshift <= ('0' & aaexpff) - "001111111111";
  rightshift <= "001111111111" - ('0' & aaexpff);
          
  powerbus <= "0000000001" & aamandelff & "00";
  
  decimalleft <= ('0' & leftff(64 DOWNTO 55)) + ("0000000000" & signff(3));
  -- decimalleft may overflow to bit 11 when exp(x), -1024 < x <= -1023
  decimalright <= rightff(64 DOWNTO 55) + ("000000000" & signff(3));
  gfa: FOR k IN 1 TO 54 GENERATE
    fractionalleft(k) <= leftff(k) XOR signff(3);
    fractionalright(k) <= rightff(k) XOR signff(3);
  END GENERATE;
  
  --**********************    
  --*** BARREL SHIFTER ***
  --**********************
  
  leftone(1) <=  powerbus(1)     AND NOT(leftshiftff(2)) AND NOT(leftshiftff(1));
  leftone(2) <= (powerbus(2)     AND NOT(leftshiftff(2)) AND NOT(leftshiftff(1))) OR
                (powerbus(1)     AND NOT(leftshiftff(2)) AND     leftshiftff(1)); 
  leftone(3) <= (powerbus(3)     AND NOT(leftshiftff(2)) AND NOT(leftshiftff(1))) OR
                (powerbus(2)     AND NOT(leftshiftff(2)) AND     leftshiftff(1)) OR
                (powerbus(1)     AND     leftshiftff(2)  AND NOT(leftshiftff(1))); 
  gla: FOR k IN 4 TO 64 GENERATE
    leftone(k) <= (powerbus(k)   AND NOT(leftshiftff(2)) AND NOT(leftshiftff(1))) OR
                  (powerbus(k-1) AND NOT(leftshiftff(2)) AND     leftshiftff(1)) OR
                  (powerbus(k-2) AND     leftshiftff(2)  AND NOT(leftshiftff(1))) OR
                  (powerbus(k-3) AND     leftshiftff(2)  AND     leftshiftff(1));
  END GENERATE;
             
  glb: FOR k IN 1 TO 4 GENERATE
    lefttwo(k) <=  leftone(k)    AND NOT(leftshiftff(4)) AND NOT(leftshiftff(3));
  END GENERATE;
  glc: FOR k IN 5 TO 8 GENERATE
    lefttwo(k) <= (leftone(k)    AND NOT(leftshiftff(4)) AND NOT(leftshiftff(3))) OR
                  (leftone(k-4)  AND NOT(leftshiftff(4)) AND     leftshiftff(3)); 
  END GENERATE;
  gld: FOR k IN 9 TO 12 GENERATE
    lefttwo(k) <= (leftone(k)    AND NOT(leftshiftff(4)) AND NOT(leftshiftff(3))) OR
                  (leftone(k-4)  AND NOT(leftshiftff(4)) AND     leftshiftff(3)) OR
                  (leftone(k-8)  AND     leftshiftff(4)  AND NOT(leftshiftff(3))); 
  END GENERATE;
  gle: FOR k IN 13 TO 64 GENERATE
    lefttwo(k) <= (leftone(k)    AND NOT(leftshiftff(4)) AND NOT(leftshiftff(3))) OR
                  (leftone(k-4)  AND NOT(leftshiftff(4)) AND     leftshiftff(3)) OR
                  (leftone(k-8)  AND     leftshiftff(4)  AND NOT(leftshiftff(3)))  OR
                  (leftone(k-12) AND     leftshiftff(4)  AND     leftshiftff(3)); 
  END GENERATE;
  cmpexp <=  ('0' & leftshiftff) - "00000001010";
  -- detect when left barrel shifter overflows (i.e. leftshiftff > 9)
  
  gra: FOR k IN 1 TO 61 GENERATE
    rightone(k) <= (powerbus(k)   AND NOT(rightshiftff(2)) AND NOT(rightshiftff(1))) OR
                   (powerbus(k+1) AND NOT(rightshiftff(2)) AND     rightshiftff(1)) OR
                   (powerbus(k+2) AND     rightshiftff(2)  AND NOT(rightshiftff(1))) OR
                   (powerbus(k+3) AND     rightshiftff(2)  AND     rightshiftff(1));
  END GENERATE;
  rightone(62) <= (powerbus(62) AND NOT(rightshiftff(2)) AND NOT(rightshiftff(1))) OR
                  (powerbus(63) AND NOT(rightshiftff(2)) AND     rightshiftff(1)) OR
                  (powerbus(64) AND     rightshiftff(2)  AND NOT(rightshiftff(1))); 
  rightone(63) <= (powerbus(63) AND NOT(rightshiftff(2)) AND NOT(rightshiftff(1))) OR
                  (powerbus(64) AND NOT(rightshiftff(2)) AND     rightshiftff(1));
  rightone(64) <=  powerbus(64) AND NOT(rightshiftff(2)) AND NOT(rightshiftff(1));
  
  grb: FOR k IN 1 TO 52 GENERATE
    righttwo(k) <= (rightone(k)    AND NOT(rightshiftff(4)) AND NOT(rightshiftff(3))) OR
                   (rightone(k+4)  AND NOT(rightshiftff(4)) AND     rightshiftff(3)) OR
                   (rightone(k+8)  AND     rightshiftff(4)  AND NOT(rightshiftff(3))) OR
                   (rightone(k+12) AND     rightshiftff(4)  AND     rightshiftff(3)); 
  END GENERATE;
  grc: FOR k IN 53 TO 56 GENERATE
    righttwo(k) <= (rightone(k)   AND NOT(rightshiftff(4)) AND NOT(rightshiftff(3))) OR
                   (rightone(k+4) AND NOT(rightshiftff(4)) AND     rightshiftff(3)) OR
                   (rightone(k+8) AND     rightshiftff(4)  AND NOT(rightshiftff(3))); 
  END GENERATE; 
  grd: FOR k IN 57 TO 60 GENERATE
    righttwo(k) <= (rightone(k)   AND NOT(rightshiftff(4)) AND NOT(rightshiftff(3))) OR
                   (rightone(k+4) AND NOT(rightshiftff(4)) AND     rightshiftff(3));
  END GENERATE; 
  gre: FOR k IN 61 TO 64 GENERATE
    righttwo(k) <= (rightone(k)   AND NOT(rightshiftff(4)) AND NOT(rightshiftff(3)));
  END GENERATE; 

  grf: FOR k IN 1 TO 16 GENERATE
    rightthree(k) <= (righttwo(k)    AND NOT(rightshiftff(6)) AND NOT(rightshiftff(5))) OR
                     (righttwo(k+16) AND NOT(rightshiftff(6)) AND     rightshiftff(5)) OR
                     (righttwo(k+32) AND     rightshiftff(6)  AND NOT(rightshiftff(5))) OR
                     (righttwo(k+48) AND     rightshiftff(6)  AND     rightshiftff(5)); 
  END GENERATE;
  grg: FOR k IN 17 TO 32 GENERATE
    rightthree(k) <= (righttwo(k)    AND NOT(rightshiftff(6)) AND NOT(rightshiftff(5))) OR
                     (righttwo(k+16) AND NOT(rightshiftff(6)) AND     rightshiftff(5)) OR
                     (righttwo(k+32) AND     rightshiftff(6)  AND NOT(rightshiftff(5)));
  END GENERATE;
  grh: FOR k IN 33 TO 48 GENERATE
    rightthree(k) <= (righttwo(k)    AND NOT(rightshiftff(6)) AND NOT(rightshiftff(5))) OR
                     (righttwo(k+16) AND NOT(rightshiftff(6)) AND     rightshiftff(5));
  END GENERATE;
  gri: FOR k IN 49 TO 64 GENERATE
    rightthree(k) <= (righttwo(k)    AND NOT(rightshiftff(6)) AND NOT(rightshiftff(5)));
  END GENERATE;
  -- is rightshiftff < 64, otherwise right barrel shifter output will be masked out
  smallrightshift <= NOT(rightshiftff(7) OR rightshiftff(8) OR rightshiftff(9) OR rightshiftff(10));
  
  --******************************************
  --*** TABLES - NO RESET, FORCE TO MEMORY ***
  --******************************************
  
  -- level: 4 in, 6 out
  pla: PROCESS (sysclk)
  BEGIN
  
    IF (rising_edge(sysclk)) THEN
        
      IF (enable = '1') THEN
          
        addlutposff <= powerff(64 DOWNTO 55);
        addlutnegff <= powerff(64 DOWNTO 55);
        addluttwoff <= powerff(54 DOWNTO 45);
        addlutthrff <= powerff(44 DOWNTO 35);
        
        lutposmanff <= '1' & manpos & '0';
        lutposexpff <= exppos;
        lutnegmanff <= '1' & manneg & '0';
        lutnegexpff <= expneg;
        luttwomanff <= '1' & mantwo & '0';
        luttwoexpff <= exptwo;
        lutthrmanff <= '1' & manthr & '0';
            
      END IF;
      
    END IF;
  
  END PROCESS;
  
  declut: dp_explutpos
  PORT MAP (add=>addlutposff,
            manhi=>manpos(52 DOWNTO 29),manlo=>manpos(28 DOWNTO 1),exponent=>exppos);
            
  neglut: dp_explutneg
  PORT MAP (add=>addlutnegff,
            manhi=>manneg(52 DOWNTO 29),manlo=>manneg(28 DOWNTO 1),exponent=>expneg);
                     
  frachilut: dp_explut10
  PORT MAP (add=>addluttwoff,
            manhi=>mantwo(52 DOWNTO 29),manlo=>mantwo(28 DOWNTO 1),exponent=>exptwo);
            
  fraclolut: dp_explut20
  PORT MAP (add=>addlutthrff,
            manhi=>manthr(52 DOWNTO 29),manlo=>manthr(28 DOWNTO 1));

  -- level: 6 in, 7 out
  pma: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
    
      FOR k IN 1 TO 54 LOOP
        lutonemanff(k) <= '0';
        luttwomandelff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP
        lutoneexpff(k) <= '0';
      END LOOP;
      luttwoexpdelff <= '0';
      FOR k IN 1 TO (ranlatency-4) LOOP
        expcalcff(k)(11 DOWNTO 1) <= "00000000000";
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
        
      IF (enable = '1') THEN
          
        FOR k IN 1 TO 54 LOOP
          lutonemanff(k) <= (lutposmanff(k) AND NOT(signff(6))) OR (lutnegmanff(k) AND signff(6));
        END LOOP;
        luttwomandelff <= luttwomanff;
        FOR k IN 1 TO 11 LOOP
          lutoneexpff(k) <= (lutposexpff(k) AND NOT(signff(6))) OR (lutnegexpff(k) AND signff(6));
        END LOOP;
        luttwoexpdelff <= luttwoexpff;
        
        -- level: 8 in
        -- SII: 19+2*doublespeed out
        -- SII: 17+2*doublespeed out
        expcalcff(1)(11 DOWNTO 1) <= lutoneexpff + ("0000000000" & luttwoexpdelff);
        FOR k IN 2 TO (ranlatency-4) LOOP
          expcalcff(k)(11 DOWNTO 1) <= expcalcff(k-1)(11 DOWNTO 1);
        END LOOP;
            
      END IF;
      
    END IF;
          
  END PROCESS;
  
  --**************************************
  --*** PREDICT OVERFLOW AND UNDERFLOW ***
  --**************************************
  
  -- overflow or underflow if power > 709
  -- overflow or underflow if power != 0 and explut = 0
  
  powercheck <= powerff(65 DOWNTO 55) - "1011000110";  -- 710
  
  -- level 4 in
  -- SII: level 19+2 out
  -- SIII/IV: level 17 out
  ppca: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
    
      FOR k IN 1 TO ranlatency LOOP
        rangeff(k) <= '0';
      END LOOP;
    
    ELSIF (rising_edge(sysclk)) THEN
        
      IF (enable = '1') THEN
       
         rangeff(1) <= bigexpff(2) OR NOT(powercheck(11));
		 -- exp(x) -> 0 or Inf, when abs(x)>=710 or has overflowed the left shifter
         FOR k IN 2 TO (ranlatency-1) LOOP
           rangeff(k) <= rangeff(k-1);
         END LOOP;
		 rangeff(ranlatency) <= rangeff(ranlatency-1) AND NOT(signff(ranlatency+3));
		 -- overflow only if input x is large and positive, exp(x) -> Inf
       
      END IF;
      
    END IF;
          
  END PROCESS;
  
  --***********************
  --*** TAYLOR's SERIES ***
  --***********************
  
  -- approximation : sequence = 1 + x + x^2/2 + x^3/6 + x^4/24
  -- but x^3/6 term is about 62 bits down, so just try 1 + x + x^2/2
  -- ('1' & zero) + (zero(21:1) & x(34:2)) + (zero(42:1) & square(72:61))
  
  fraction <= powerff(34 DOWNTO 1) & "00";
  
  -- level: 4 in, 7 out
  mulsqr: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>36,widthcc=>12,
               pipes=>3,device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>fraction,databb=>fraction,
            result=>xsquareterm);
 
  delfrac: fp_del
  GENERIC MAP (width=>33,pipes=>3)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>powerff(34 DOWNTO 2),
            cc=>xterm); 
            
  delthr: fp_del
  GENERIC MAP (width=>54,pipes=>2)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>lutthrmanff,
            cc=>lutthrmandel); 
           
  -- level 8
  pta: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
    
      FOR k IN 1 TO 54 LOOP
        approxff(k) <= '0';
      END LOOP;
     
    ELSIF (rising_edge(sysclk)) THEN
        
      IF (enable = '1') THEN
          
        approxff <= ('1' & zerovec(20 DOWNTO 1) & xterm) + (zerovec(42 DOWNTO 1) & xsquareterm);
            
      END IF;
      
    END IF;
          
  END PROCESS;          

  --*************************************
  --*** MULTIPLY ALL EXP(X) SUBRANGES ***
  --*************************************
  
  -- SII level in 7, level out 12+speed
  -- SIII/IV level in 7, level out 11
  mulone: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>54,widthcc=>72,
               pipes=>mullatency,accuracy=>doubleaccuracy,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>lutonemanff,databb=>luttwomandelff,
            result=>resultone);
  
  -- SII level in 12+speed, level out 13+speed
  -- SIII/IV level in 11, level out 12        
  delone: fp_del
  GENERIC MAP (width=>54,pipes=>1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>resultone(72 DOWNTO 19),
            cc=>resultonedel); 
  
  -- SII level in 8, level out 13+speed
  -- SIII/IV level in 8, level out 12 
  multwo: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>54,widthcc=>72,
               pipes=>mullatency,accuracy=>doubleaccuracy,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>lutthrmandel,databb=>approxff,
            result=>resulttwo);
  
  -- SII level in 13+speed, level out 18+2*speed
  -- SIII/IV level in 12, level out 16   
  multhr: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>54,widthcc=>72,
               pipes=>mullatency,accuracy=>doubleaccuracy,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>resultonedel,databb=>resulttwo(72 DOWNTO 19),
            result=>resultthr);

  --************************
  --*** NORMALIZE OUTPUT ***
  --************************
              
  pns: PROCESS (resultthr)
  BEGIN
      
    CASE resultthr(72 DOWNTO 69) IS
      WHEN "0000" => normshift <= "11";
      WHEN "0001" => normshift <= "11";
      WHEN "0010" => normshift <= "10";
      WHEN "0011" => normshift <= "10";
      WHEN "0100" => normshift <= "01";
      WHEN "0101" => normshift <= "01";
      WHEN "0110" => normshift <= "01";
      WHEN "0111" => normshift <= "01";
      WHEN "1000" => normshift <= "00";
      WHEN "1001" => normshift <= "00";
      WHEN "1010" => normshift <= "00";
      WHEN "1011" => normshift <= "00";
      WHEN "1100" => normshift <= "00";
      WHEN "1101" => normshift <= "00";
      WHEN "1110" => normshift <= "00";
      WHEN "1111" => normshift <= "00";   
      WHEN others => normshift <= "00";
    END CASE;
        
  END PROCESS;
  
  pna: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
    
      FOR k IN 1 TO 54 LOOP
        manoutff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP
        expoutff(k) <= '0';
      END LOOP;
     
    ELSIF (rising_edge(sysclk)) THEN
        
      IF (enable = '1') THEN
         
        -- SII level in 18+2*doublespeed, level out 19+2*doublespeed
        -- SIII/IV level in 16, level out 17 
        FOR k IN 1 TO 54 LOOP
          manoutff(k) <= (resultthr(k+18) AND NOT(normshift(2)) AND NOT(normshift(1))) OR
                         (resultthr(k+17) AND NOT(normshift(2)) AND     normshift(1)) OR
                         (resultthr(k+16) AND     normshift(2)  AND NOT(normshift(1))) OR
                         (resultthr(k+15) AND     normshift(2)  AND     normshift(1));
        END LOOP;
		FOR k IN 1 TO 11 LOOP
          expoutff(k) <= expout(k) AND NOT(rangeff(ranlatency-1) AND signff(ranlatency+3));
		END LOOP;
        -- IEEE exponent field is set to zero when x = large negative, exp(x) -> 0
      END IF;
      
    END IF;
          
  END PROCESS; 
  expout <= expcalcff(ranlatency-4)(11 DOWNTO 1) - ("000000000" & normshift) + "00000000011";

  --***************
  --*** OUTPUTS ***
  --***************
  
  ccman <= manoutff;
  ccexp <= expoutff;
  rangeerror <= rangeff(ranlatency);
        
END rtl;

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_EXPLUT10.VHD                           ***
--***                                             ***
--***   Function: Look Up Table - EXP()           ***
--***                                             ***
--***   Generated by MATLAB Utility               ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_explut10 IS
PORT (
      add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
      manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
      manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1);
      exponent : OUT STD_LOGIC
     );
END dp_explut10;

ARCHITECTURE rtl OF dp_explut10 IS

BEGIN

  pca: PROCESS (add)
  BEGIN
    CASE add IS
      WHEN "0000000000" =>
            manhi <= conv_std_logic_vector(0,24);
            manlo <= conv_std_logic_vector(0,28);
           exponent <= '0';
      WHEN "0000000001" =>
            manhi <= conv_std_logic_vector(16392,24);
            manlo <= conv_std_logic_vector(699221,28);
           exponent <= '0';
      WHEN "0000000010" =>
            manhi <= conv_std_logic_vector(32800,24);
            manlo <= conv_std_logic_vector(5595137,28);
           exponent <= '0';
      WHEN "0000000011" =>
            manhi <= conv_std_logic_vector(49224,24);
            manlo <= conv_std_logic_vector(18888200,28);
           exponent <= '0';
      WHEN "0000000100" =>
            manhi <= conv_std_logic_vector(65664,24);
            manlo <= conv_std_logic_vector(44782967,28);
           exponent <= '0';
      WHEN "0000000101" =>
            manhi <= conv_std_logic_vector(82120,24);
            manlo <= conv_std_logic_vector(87488104,28);
           exponent <= '0';
      WHEN "0000000110" =>
            manhi <= conv_std_logic_vector(98592,24);
            manlo <= conv_std_logic_vector(151216387,28);
           exponent <= '0';
      WHEN "0000000111" =>
            manhi <= conv_std_logic_vector(115080,24);
            manlo <= conv_std_logic_vector(240184710,28);
           exponent <= '0';
      WHEN "0000001000" =>
            manhi <= conv_std_logic_vector(131585,24);
            manlo <= conv_std_logic_vector(90178630,28);
           exponent <= '0';
      WHEN "0000001001" =>
            manhi <= conv_std_logic_vector(148105,24);
            manlo <= conv_std_logic_vector(242294195,28);
           exponent <= '0';
      WHEN "0000001010" =>
            manhi <= conv_std_logic_vector(164642,24);
            manlo <= conv_std_logic_vector(163889760,28);
           exponent <= '0';
      WHEN "0000001011" =>
            manhi <= conv_std_logic_vector(181195,24);
            manlo <= conv_std_logic_vector(127634178,28);
           exponent <= '0';
      WHEN "0000001100" =>
            manhi <= conv_std_logic_vector(197764,24);
            manlo <= conv_std_logic_vector(137764983,28);
           exponent <= '0';
      WHEN "0000001101" =>
            manhi <= conv_std_logic_vector(214349,24);
            manlo <= conv_std_logic_vector(198523848,28);
           exponent <= '0';
      WHEN "0000001110" =>
            manhi <= conv_std_logic_vector(230951,24);
            manlo <= conv_std_logic_vector(45721136,28);
           exponent <= '0';
      WHEN "0000001111" =>
            manhi <= conv_std_logic_vector(247568,24);
            manlo <= conv_std_logic_vector(220477726,28);
           exponent <= '0';
      WHEN "0000010000" =>
            manhi <= conv_std_logic_vector(264202,24);
            manlo <= conv_std_logic_vector(190176825,28);
           exponent <= '0';
      WHEN "0000010001" =>
            manhi <= conv_std_logic_vector(280852,24);
            manlo <= conv_std_logic_vector(227512164,28);
           exponent <= '0';
      WHEN "0000010010" =>
            manhi <= conv_std_logic_vector(297519,24);
            manlo <= conv_std_logic_vector(68310723,28);
           exponent <= '0';
      WHEN "0000010011" =>
            manhi <= conv_std_logic_vector(314201,24);
            manlo <= conv_std_logic_vector(253710014,28);
           exponent <= '0';
      WHEN "0000010100" =>
            manhi <= conv_std_logic_vector(330900,24);
            manlo <= conv_std_logic_vector(251109895,28);
           exponent <= '0';
      WHEN "0000010101" =>
            manhi <= conv_std_logic_vector(347616,24);
            manlo <= conv_std_logic_vector(64785307,28);
           exponent <= '0';
      WHEN "0000010110" =>
            manhi <= conv_std_logic_vector(364347,24);
            manlo <= conv_std_logic_vector(235886282,28);
           exponent <= '0';
      WHEN "0000010111" =>
            manhi <= conv_std_logic_vector(381095,24);
            manlo <= conv_std_logic_vector(231825206,28);
           exponent <= '0';
      WHEN "0000011000" =>
            manhi <= conv_std_logic_vector(397860,24);
            manlo <= conv_std_logic_vector(56889565,28);
           exponent <= '0';
      WHEN "0000011001" =>
            manhi <= conv_std_logic_vector(414640,24);
            manlo <= conv_std_logic_vector(252241943,28);
           exponent <= '0';
      WHEN "0000011010" =>
            manhi <= conv_std_logic_vector(431438,24);
            manlo <= conv_std_logic_vector(16871840,28);
           exponent <= '0';
      WHEN "0000011011" =>
            manhi <= conv_std_logic_vector(448251,24);
            manlo <= conv_std_logic_vector(160385687,28);
           exponent <= '0';
      WHEN "0000011100" =>
            manhi <= conv_std_logic_vector(465081,24);
            manlo <= conv_std_logic_vector(150216837,28);
           exponent <= '0';
      WHEN "0000011101" =>
            manhi <= conv_std_logic_vector(481927,24);
            manlo <= conv_std_logic_vector(259109217,28);
           exponent <= '0';
      WHEN "0000011110" =>
            manhi <= conv_std_logic_vector(498790,24);
            manlo <= conv_std_logic_vector(222940052,28);
           exponent <= '0';
      WHEN "0000011111" =>
            manhi <= conv_std_logic_vector(515670,24);
            manlo <= conv_std_logic_vector(46026234,28);
           exponent <= '0';
      WHEN "0000100000" =>
            manhi <= conv_std_logic_vector(532566,24);
            manlo <= conv_std_logic_vector(1124333,28);
           exponent <= '0';
      WHEN "0000100001" =>
            manhi <= conv_std_logic_vector(549478,24);
            manlo <= conv_std_logic_vector(92559680,28);
           exponent <= '0';
      WHEN "0000100010" =>
            manhi <= conv_std_logic_vector(566407,24);
            manlo <= conv_std_logic_vector(56226380,28);
           exponent <= '0';
      WHEN "0000100011" =>
            manhi <= conv_std_logic_vector(583352,24);
            manlo <= conv_std_logic_vector(164893679,28);
           exponent <= '0';
      WHEN "0000100100" =>
            manhi <= conv_std_logic_vector(600314,24);
            manlo <= conv_std_logic_vector(154464145,28);
           exponent <= '0';
      WHEN "0000100101" =>
            manhi <= conv_std_logic_vector(617293,24);
            manlo <= conv_std_logic_vector(29280039,28);
           exponent <= '0';
      WHEN "0000100110" =>
            manhi <= conv_std_logic_vector(634288,24);
            manlo <= conv_std_logic_vector(62123323,28);
           exponent <= '0';
      WHEN "0000100111" =>
            manhi <= conv_std_logic_vector(651299,24);
            manlo <= conv_std_logic_vector(257344748,28);
           exponent <= '0';
      WHEN "0000101000" =>
            manhi <= conv_std_logic_vector(668328,24);
            manlo <= conv_std_logic_vector(82428406,28);
           exponent <= '0';
      WHEN "0000101001" =>
            manhi <= conv_std_logic_vector(685373,24);
            manlo <= conv_std_logic_vector(78604464,28);
           exponent <= '0';
      WHEN "0000101010" =>
            manhi <= conv_std_logic_vector(702434,24);
            manlo <= conv_std_logic_vector(250236442,28);
           exponent <= '0';
      WHEN "0000101011" =>
            manhi <= conv_std_logic_vector(719513,24);
            manlo <= conv_std_logic_vector(64821205,28);
           exponent <= '0';
      WHEN "0000101100" =>
            manhi <= conv_std_logic_vector(736608,24);
            manlo <= conv_std_logic_vector(63601714,28);
           exponent <= '0';
      WHEN "0000101101" =>
            manhi <= conv_std_logic_vector(753719,24);
            manlo <= conv_std_logic_vector(250954289,28);
           exponent <= '0';
      WHEN "0000101110" =>
            manhi <= conv_std_logic_vector(770848,24);
            manlo <= conv_std_logic_vector(94388611,28);
           exponent <= '0';
      WHEN "0000101111" =>
            manhi <= conv_std_logic_vector(787993,24);
            manlo <= conv_std_logic_vector(135160468,28);
           exponent <= '0';
      WHEN "0000110000" =>
            manhi <= conv_std_logic_vector(805155,24);
            manlo <= conv_std_logic_vector(109223564,28);
           exponent <= '0';
      WHEN "0000110001" =>
            manhi <= conv_std_logic_vector(822334,24);
            manlo <= conv_std_logic_vector(20971345,28);
           exponent <= '0';
      WHEN "0000110010" =>
            manhi <= conv_std_logic_vector(839529,24);
            manlo <= conv_std_logic_vector(143237009,28);
           exponent <= '0';
      WHEN "0000110011" =>
            manhi <= conv_std_logic_vector(856741,24);
            manlo <= conv_std_logic_vector(211987135,28);
           exponent <= '0';
      WHEN "0000110100" =>
            manhi <= conv_std_logic_vector(873970,24);
            manlo <= conv_std_logic_vector(231628063,28);
           exponent <= '0';
      WHEN "0000110101" =>
            manhi <= conv_std_logic_vector(891216,24);
            manlo <= conv_std_logic_vector(206570434,28);
           exponent <= '0';
      WHEN "0000110110" =>
            manhi <= conv_std_logic_vector(908479,24);
            manlo <= conv_std_logic_vector(141229202,28);
           exponent <= '0';
      WHEN "0000110111" =>
            manhi <= conv_std_logic_vector(925759,24);
            manlo <= conv_std_logic_vector(40023632,28);
           exponent <= '0';
      WHEN "0000111000" =>
            manhi <= conv_std_logic_vector(943055,24);
            manlo <= conv_std_logic_vector(175812765,28);
           exponent <= '0';
      WHEN "0000111001" =>
            manhi <= conv_std_logic_vector(960369,24);
            manlo <= conv_std_logic_vector(16153594,28);
           exponent <= '0';
      WHEN "0000111010" =>
            manhi <= conv_std_logic_vector(977699,24);
            manlo <= conv_std_logic_vector(102349263,28);
           exponent <= '0';
      WHEN "0000111011" =>
            manhi <= conv_std_logic_vector(995046,24);
            manlo <= conv_std_logic_vector(170400879,28);
           exponent <= '0';
      WHEN "0000111100" =>
            manhi <= conv_std_logic_vector(1012410,24);
            manlo <= conv_std_logic_vector(224749339,28);
           exponent <= '0';
      WHEN "0000111101" =>
            manhi <= conv_std_logic_vector(1029792,24);
            manlo <= conv_std_logic_vector(1404424,28);
           exponent <= '0';
      WHEN "0000111110" =>
            manhi <= conv_std_logic_vector(1047190,24);
            manlo <= conv_std_logic_vector(41686624,28);
           exponent <= '0';
      WHEN "0000111111" =>
            manhi <= conv_std_logic_vector(1064605,24);
            manlo <= conv_std_logic_vector(81614410,28);
           exponent <= '0';
      WHEN "0001000000" =>
            manhi <= conv_std_logic_vector(1082037,24);
            manlo <= conv_std_logic_vector(125646062,28);
           exponent <= '0';
      WHEN "0001000001" =>
            manhi <= conv_std_logic_vector(1099486,24);
            manlo <= conv_std_logic_vector(178244212,28);
           exponent <= '0';
      WHEN "0001000010" =>
            manhi <= conv_std_logic_vector(1116952,24);
            manlo <= conv_std_logic_vector(243875856,28);
           exponent <= '0';
      WHEN "0001000011" =>
            manhi <= conv_std_logic_vector(1134436,24);
            manlo <= conv_std_logic_vector(58576897,28);
           exponent <= '0';
      WHEN "0001000100" =>
            manhi <= conv_std_logic_vector(1151936,24);
            manlo <= conv_std_logic_vector(163693974,28);
           exponent <= '0';
      WHEN "0001000101" =>
            manhi <= conv_std_logic_vector(1169454,24);
            manlo <= conv_std_logic_vector(26836276,28);
           exponent <= '0';
      WHEN "0001000110" =>
            manhi <= conv_std_logic_vector(1186988,24);
            manlo <= conv_std_logic_vector(189359192,28);
           exponent <= '0';
      WHEN "0001000111" =>
            manhi <= conv_std_logic_vector(1204540,24);
            manlo <= conv_std_logic_vector(118880671,28);
           exponent <= '0';
      WHEN "0001001000" =>
            manhi <= conv_std_logic_vector(1222109,24);
            manlo <= conv_std_logic_vector(88329413,28);
           exponent <= '0';
      WHEN "0001001001" =>
            manhi <= conv_std_logic_vector(1239695,24);
            manlo <= conv_std_logic_vector(102203053,28);
           exponent <= '0';
      WHEN "0001001010" =>
            manhi <= conv_std_logic_vector(1257298,24);
            manlo <= conv_std_logic_vector(165003622,28);
           exponent <= '0';
      WHEN "0001001011" =>
            manhi <= conv_std_logic_vector(1274919,24);
            manlo <= conv_std_logic_vector(12802090,28);
           exponent <= '0';
      WHEN "0001001100" =>
            manhi <= conv_std_logic_vector(1292556,24);
            manlo <= conv_std_logic_vector(186980202,28);
           exponent <= '0';
      WHEN "0001001101" =>
            manhi <= conv_std_logic_vector(1310211,24);
            manlo <= conv_std_logic_vector(155182284,28);
           exponent <= '0';
      WHEN "0001001110" =>
            manhi <= conv_std_logic_vector(1327883,24);
            manlo <= conv_std_logic_vector(190363442,28);
           exponent <= '0';
      WHEN "0001001111" =>
            manhi <= conv_std_logic_vector(1345573,24);
            manlo <= conv_std_logic_vector(28612286,28);
           exponent <= '0';
      WHEN "0001010000" =>
            manhi <= conv_std_logic_vector(1363279,24);
            manlo <= conv_std_logic_vector(211328214,28);
           exponent <= '0';
      WHEN "0001010001" =>
            manhi <= conv_std_logic_vector(1381003,24);
            manlo <= conv_std_logic_vector(206173225,28);
           exponent <= '0';
      WHEN "0001010010" =>
            manhi <= conv_std_logic_vector(1398745,24);
            manlo <= conv_std_logic_vector(17684657,28);
           exponent <= '0';
      WHEN "0001010011" =>
            manhi <= conv_std_logic_vector(1416503,24);
            manlo <= conv_std_logic_vector(187275197,28);
           exponent <= '0';
      WHEN "0001010100" =>
            manhi <= conv_std_logic_vector(1434279,24);
            manlo <= conv_std_logic_vector(182620141,28);
           exponent <= '0';
      WHEN "0001010101" =>
            manhi <= conv_std_logic_vector(1452073,24);
            manlo <= conv_std_logic_vector(8270141,28);
           exponent <= '0';
      WHEN "0001010110" =>
            manhi <= conv_std_logic_vector(1469883,24);
            manlo <= conv_std_logic_vector(205651209,28);
           exponent <= '0';
      WHEN "0001010111" =>
            manhi <= conv_std_logic_vector(1487711,24);
            manlo <= conv_std_logic_vector(242451980,28);
           exponent <= '0';
      WHEN "0001011000" =>
            manhi <= conv_std_logic_vector(1505557,24);
            manlo <= conv_std_logic_vector(123236457,28);
           exponent <= '0';
      WHEN "0001011001" =>
            manhi <= conv_std_logic_vector(1523420,24);
            manlo <= conv_std_logic_vector(121008560,28);
           exponent <= '0';
      WHEN "0001011010" =>
            manhi <= conv_std_logic_vector(1541300,24);
            manlo <= conv_std_logic_vector(240341215,28);
           exponent <= '0';
      WHEN "0001011011" =>
            manhi <= conv_std_logic_vector(1559198,24);
            manlo <= conv_std_logic_vector(217376360,28);
           exponent <= '0';
      WHEN "0001011100" =>
            manhi <= conv_std_logic_vector(1577114,24);
            manlo <= conv_std_logic_vector(56695861,28);
           exponent <= '0';
      WHEN "0001011101" =>
            manhi <= conv_std_logic_vector(1595047,24);
            manlo <= conv_std_logic_vector(31321518,28);
           exponent <= '0';
      WHEN "0001011110" =>
            manhi <= conv_std_logic_vector(1612997,24);
            manlo <= conv_std_logic_vector(145844154,28);
           exponent <= '0';
      WHEN "0001011111" =>
            manhi <= conv_std_logic_vector(1630965,24);
            manlo <= conv_std_logic_vector(136423623,28);
           exponent <= '0';
      WHEN "0001100000" =>
            manhi <= conv_std_logic_vector(1648951,24);
            manlo <= conv_std_logic_vector(7659725,28);
           exponent <= '0';
      WHEN "0001100001" =>
            manhi <= conv_std_logic_vector(1666954,24);
            manlo <= conv_std_logic_vector(32592210,28);
           exponent <= '0';
      WHEN "0001100010" =>
            manhi <= conv_std_logic_vector(1684974,24);
            manlo <= conv_std_logic_vector(215829868,28);
           exponent <= '0';
      WHEN "0001100011" =>
            manhi <= conv_std_logic_vector(1703013,24);
            manlo <= conv_std_logic_vector(25115084,28);
           exponent <= '0';
      WHEN "0001100100" =>
            manhi <= conv_std_logic_vector(1721069,24);
            manlo <= conv_std_logic_vector(1936572,28);
           exponent <= '0';
      WHEN "0001100101" =>
            manhi <= conv_std_logic_vector(1739142,24);
            manlo <= conv_std_logic_vector(150916647,28);
           exponent <= '0';
      WHEN "0001100110" =>
            manhi <= conv_std_logic_vector(1757233,24);
            manlo <= conv_std_logic_vector(208246681,28);
           exponent <= '0';
      WHEN "0001100111" =>
            manhi <= conv_std_logic_vector(1775342,24);
            manlo <= conv_std_logic_vector(178558028,28);
           exponent <= '0';
      WHEN "0001101000" =>
            manhi <= conv_std_logic_vector(1793469,24);
            manlo <= conv_std_logic_vector(66486562,28);
           exponent <= '0';
      WHEN "0001101001" =>
            manhi <= conv_std_logic_vector(1811613,24);
            manlo <= conv_std_logic_vector(145108146,28);
           exponent <= '0';
      WHEN "0001101010" =>
            manhi <= conv_std_logic_vector(1829775,24);
            manlo <= conv_std_logic_vector(150632262,28);
           exponent <= '0';
      WHEN "0001101011" =>
            manhi <= conv_std_logic_vector(1847955,24);
            manlo <= conv_std_logic_vector(87708388,28);
           exponent <= '0';
      WHEN "0001101100" =>
            manhi <= conv_std_logic_vector(1866152,24);
            manlo <= conv_std_logic_vector(229426001,28);
           exponent <= '0';
      WHEN "0001101101" =>
            manhi <= conv_std_logic_vector(1884368,24);
            manlo <= conv_std_logic_vector(43572756,28);
           exponent <= '0';
      WHEN "0001101110" =>
            manhi <= conv_std_logic_vector(1902601,24);
            manlo <= conv_std_logic_vector(71682684,28);
           exponent <= '0';
      WHEN "0001101111" =>
            manhi <= conv_std_logic_vector(1920852,24);
            manlo <= conv_std_logic_vector(49988005,28);
           exponent <= '0';
      WHEN "0001110000" =>
            manhi <= conv_std_logic_vector(1939120,24);
            manlo <= conv_std_logic_vector(251596409,28);
           exponent <= '0';
      WHEN "0001110001" =>
            manhi <= conv_std_logic_vector(1957407,24);
            manlo <= conv_std_logic_vector(144313787,28);
           exponent <= '0';
      WHEN "0001110010" =>
            manhi <= conv_std_logic_vector(1975712,24);
            manlo <= conv_std_logic_vector(1256963,28);
           exponent <= '0';
      WHEN "0001110011" =>
            manhi <= conv_std_logic_vector(1994034,24);
            manlo <= conv_std_logic_vector(95547338,28);
           exponent <= '0';
      WHEN "0001110100" =>
            manhi <= conv_std_logic_vector(2012374,24);
            manlo <= conv_std_logic_vector(163439978,28);
           exponent <= '0';
      WHEN "0001110101" =>
            manhi <= conv_std_logic_vector(2030732,24);
            manlo <= conv_std_logic_vector(209629988,28);
           exponent <= '0';
      WHEN "0001110110" =>
            manhi <= conv_std_logic_vector(2049108,24);
            manlo <= conv_std_logic_vector(238817060,28);
           exponent <= '0';
      WHEN "0001110111" =>
            manhi <= conv_std_logic_vector(2067502,24);
            manlo <= conv_std_logic_vector(255705480,28);
           exponent <= '0';
      WHEN "0001111000" =>
            manhi <= conv_std_logic_vector(2085914,24);
            manlo <= conv_std_logic_vector(265004126,28);
           exponent <= '0';
      WHEN "0001111001" =>
            manhi <= conv_std_logic_vector(2104345,24);
            manlo <= conv_std_logic_vector(2991026,28);
           exponent <= '0';
      WHEN "0001111010" =>
            manhi <= conv_std_logic_vector(2122793,24);
            manlo <= conv_std_logic_vector(11255176,28);
           exponent <= '0';
      WHEN "0001111011" =>
            manhi <= conv_std_logic_vector(2141259,24);
            manlo <= conv_std_logic_vector(26083817,28);
           exponent <= '0';
      WHEN "0001111100" =>
            manhi <= conv_std_logic_vector(2159743,24);
            manlo <= conv_std_logic_vector(52204260,28);
           exponent <= '0';
      WHEN "0001111101" =>
            manhi <= conv_std_logic_vector(2178245,24);
            manlo <= conv_std_logic_vector(94348435,28);
           exponent <= '0';
      WHEN "0001111110" =>
            manhi <= conv_std_logic_vector(2196765,24);
            manlo <= conv_std_logic_vector(157252892,28);
           exponent <= '0';
      WHEN "0001111111" =>
            manhi <= conv_std_logic_vector(2215303,24);
            manlo <= conv_std_logic_vector(245658814,28);
           exponent <= '0';
      WHEN "0010000000" =>
            manhi <= conv_std_logic_vector(2233860,24);
            manlo <= conv_std_logic_vector(95876557,28);
           exponent <= '0';
      WHEN "0010000001" =>
            manhi <= conv_std_logic_vector(2252434,24);
            manlo <= conv_std_logic_vector(249527482,28);
           exponent <= '0';
      WHEN "0010000010" =>
            manhi <= conv_std_logic_vector(2271027,24);
            manlo <= conv_std_logic_vector(174495768,28);
           exponent <= '0';
      WHEN "0010000011" =>
            manhi <= conv_std_logic_vector(2289638,24);
            manlo <= conv_std_logic_vector(143976608,28);
           exponent <= '0';
      WHEN "0010000100" =>
            manhi <= conv_std_logic_vector(2308267,24);
            manlo <= conv_std_logic_vector(162734389,28);
           exponent <= '0';
      WHEN "0010000101" =>
            manhi <= conv_std_logic_vector(2326914,24);
            manlo <= conv_std_logic_vector(235538153,28);
           exponent <= '0';
      WHEN "0010000110" =>
            manhi <= conv_std_logic_vector(2345580,24);
            manlo <= conv_std_logic_vector(98726147,28);
           exponent <= '0';
      WHEN "0010000111" =>
            manhi <= conv_std_logic_vector(2364264,24);
            manlo <= conv_std_logic_vector(25512192,28);
           exponent <= '0';
      WHEN "0010001000" =>
            manhi <= conv_std_logic_vector(2382966,24);
            manlo <= conv_std_logic_vector(20679323,28);
           exponent <= '0';
      WHEN "0010001001" =>
            manhi <= conv_std_logic_vector(2401686,24);
            manlo <= conv_std_logic_vector(89015247,28);
           exponent <= '0';
      WHEN "0010001010" =>
            manhi <= conv_std_logic_vector(2420424,24);
            manlo <= conv_std_logic_vector(235312351,28);
           exponent <= '0';
      WHEN "0010001011" =>
            manhi <= conv_std_logic_vector(2439181,24);
            manlo <= conv_std_logic_vector(195932245,28);
           exponent <= '0';
      WHEN "0010001100" =>
            manhi <= conv_std_logic_vector(2457956,24);
            manlo <= conv_std_logic_vector(244112142,28);
           exponent <= '0';
      WHEN "0010001101" =>
            manhi <= conv_std_logic_vector(2476750,24);
            manlo <= conv_std_logic_vector(116223030,28);
           exponent <= '0';
      WHEN "0010001110" =>
            manhi <= conv_std_logic_vector(2495562,24);
            manlo <= conv_std_logic_vector(85511509,28);
           exponent <= '0';
      WHEN "0010001111" =>
            manhi <= conv_std_logic_vector(2514392,24);
            manlo <= conv_std_logic_vector(156793422,28);
           exponent <= '0';
      WHEN "0010010000" =>
            manhi <= conv_std_logic_vector(2533241,24);
            manlo <= conv_std_logic_vector(66453860,28);
           exponent <= '0';
      WHEN "0010010001" =>
            manhi <= conv_std_logic_vector(2552108,24);
            manlo <= conv_std_logic_vector(87753539,28);
           exponent <= '0';
      WHEN "0010010010" =>
            manhi <= conv_std_logic_vector(2570993,24);
            manlo <= conv_std_logic_vector(225522431,28);
           exponent <= '0';
      WHEN "0010010011" =>
            manhi <= conv_std_logic_vector(2589897,24);
            manlo <= conv_std_logic_vector(216159772,28);
           exponent <= '0';
      WHEN "0010010100" =>
            manhi <= conv_std_logic_vector(2608820,24);
            manlo <= conv_std_logic_vector(64504976,28);
           exponent <= '0';
      WHEN "0010010101" =>
            manhi <= conv_std_logic_vector(2627761,24);
            manlo <= conv_std_logic_vector(43837645,28);
           exponent <= '0';
      WHEN "0010010110" =>
            manhi <= conv_std_logic_vector(2646720,24);
            manlo <= conv_std_logic_vector(159006654,28);
           exponent <= '0';
      WHEN "0010010111" =>
            manhi <= conv_std_logic_vector(2665698,24);
            manlo <= conv_std_logic_vector(146430162,28);
           exponent <= '0';
      WHEN "0010011000" =>
            manhi <= conv_std_logic_vector(2684695,24);
            manlo <= conv_std_logic_vector(10966526,28);
           exponent <= '0';
      WHEN "0010011001" =>
            manhi <= conv_std_logic_vector(2703710,24);
            manlo <= conv_std_logic_vector(25914303,28);
           exponent <= '0';
      WHEN "0010011010" =>
            manhi <= conv_std_logic_vector(2722743,24);
            manlo <= conv_std_logic_vector(196141350,28);
           exponent <= '0';
      WHEN "0010011011" =>
            manhi <= conv_std_logic_vector(2741795,24);
            manlo <= conv_std_logic_vector(258084820,28);
           exponent <= '0';
      WHEN "0010011100" =>
            manhi <= conv_std_logic_vector(2760866,24);
            manlo <= conv_std_logic_vector(216622086,28);
           exponent <= '0';
      WHEN "0010011101" =>
            manhi <= conv_std_logic_vector(2779956,24);
            manlo <= conv_std_logic_vector(76635284,28);
           exponent <= '0';
      WHEN "0010011110" =>
            manhi <= conv_std_logic_vector(2799064,24);
            manlo <= conv_std_logic_vector(111446777,28);
           exponent <= '0';
      WHEN "0010011111" =>
            manhi <= conv_std_logic_vector(2818191,24);
            manlo <= conv_std_logic_vector(57512790,28);
           exponent <= '0';
      WHEN "0010100000" =>
            manhi <= conv_std_logic_vector(2837336,24);
            manlo <= conv_std_logic_vector(188165241,28);
           exponent <= '0';
      WHEN "0010100001" =>
            manhi <= conv_std_logic_vector(2856500,24);
            manlo <= conv_std_logic_vector(239869919,28);
           exponent <= '0';
      WHEN "0010100010" =>
            manhi <= conv_std_logic_vector(2875683,24);
            manlo <= conv_std_logic_vector(217532856,28);
           exponent <= '0';
      WHEN "0010100011" =>
            manhi <= conv_std_logic_vector(2894885,24);
            manlo <= conv_std_logic_vector(126064881,28);
           exponent <= '0';
      WHEN "0010100100" =>
            manhi <= conv_std_logic_vector(2914105,24);
            manlo <= conv_std_logic_vector(238817075,28);
           exponent <= '0';
      WHEN "0010100101" =>
            manhi <= conv_std_logic_vector(2933345,24);
            manlo <= conv_std_logic_vector(23838952,28);
           exponent <= '0';
      WHEN "0010100110" =>
            manhi <= conv_std_logic_vector(2952603,24);
            manlo <= conv_std_logic_vector(22926662,28);
           exponent <= '0';
      WHEN "0010100111" =>
            manhi <= conv_std_logic_vector(2971879,24);
            manlo <= conv_std_logic_vector(241010251,28);
           exponent <= '0';
      WHEN "0010101000" =>
            manhi <= conv_std_logic_vector(2991175,24);
            manlo <= conv_std_logic_vector(146153671,28);
           exponent <= '0';
      WHEN "0010101001" =>
            manhi <= conv_std_logic_vector(3010490,24);
            manlo <= conv_std_logic_vector(11732065,28);
           exponent <= '0';
      WHEN "0010101010" =>
            manhi <= conv_std_logic_vector(3029823,24);
            manlo <= conv_std_logic_vector(111125401,28);
           exponent <= '0';
      WHEN "0010101011" =>
            manhi <= conv_std_logic_vector(3049175,24);
            manlo <= conv_std_logic_vector(180847566,28);
           exponent <= '0';
      WHEN "0010101100" =>
            manhi <= conv_std_logic_vector(3068546,24);
            manlo <= conv_std_logic_vector(225852738,28);
           exponent <= '0';
      WHEN "0010101101" =>
            manhi <= conv_std_logic_vector(3087936,24);
            manlo <= conv_std_logic_vector(251099938,28);
           exponent <= '0';
      WHEN "0010101110" =>
            manhi <= conv_std_logic_vector(3107345,24);
            manlo <= conv_std_logic_vector(261553029,28);
           exponent <= '0';
      WHEN "0010101111" =>
            manhi <= conv_std_logic_vector(3126773,24);
            manlo <= conv_std_logic_vector(262180727,28);
           exponent <= '0';
      WHEN "0010110000" =>
            manhi <= conv_std_logic_vector(3146220,24);
            manlo <= conv_std_logic_vector(257956599,28);
           exponent <= '0';
      WHEN "0010110001" =>
            manhi <= conv_std_logic_vector(3165686,24);
            manlo <= conv_std_logic_vector(253859075,28);
           exponent <= '0';
      WHEN "0010110010" =>
            manhi <= conv_std_logic_vector(3185171,24);
            manlo <= conv_std_logic_vector(254871446,28);
           exponent <= '0';
      WHEN "0010110011" =>
            manhi <= conv_std_logic_vector(3204675,24);
            manlo <= conv_std_logic_vector(265981875,28);
           exponent <= '0';
      WHEN "0010110100" =>
            manhi <= conv_std_logic_vector(3224199,24);
            manlo <= conv_std_logic_vector(23747940,28);
           exponent <= '0';
      WHEN "0010110101" =>
            manhi <= conv_std_logic_vector(3243741,24);
            manlo <= conv_std_logic_vector(70038466,28);
           exponent <= '0';
      WHEN "0010110110" =>
            manhi <= conv_std_logic_vector(3263302,24);
            manlo <= conv_std_logic_vector(141420795,28);
           exponent <= '0';
      WHEN "0010110111" =>
            manhi <= conv_std_logic_vector(3282882,24);
            manlo <= conv_std_logic_vector(242902610,28);
           exponent <= '0';
      WHEN "0010111000" =>
            manhi <= conv_std_logic_vector(3302482,24);
            manlo <= conv_std_logic_vector(111061033,28);
           exponent <= '0';
      WHEN "0010111001" =>
            manhi <= conv_std_logic_vector(3322101,24);
            manlo <= conv_std_logic_vector(19348994,28);
           exponent <= '0';
      WHEN "0010111010" =>
            manhi <= conv_std_logic_vector(3341738,24);
            manlo <= conv_std_logic_vector(241224327,28);
           exponent <= '0';
      WHEN "0010111011" =>
            manhi <= conv_std_logic_vector(3361395,24);
            manlo <= conv_std_logic_vector(244843403,28);
           exponent <= '0';
      WHEN "0010111100" =>
            manhi <= conv_std_logic_vector(3381072,24);
            manlo <= conv_std_logic_vector(35238419,28);
           exponent <= '0';
      WHEN "0010111101" =>
            manhi <= conv_std_logic_vector(3400767,24);
            manlo <= conv_std_logic_vector(154317398,28);
           exponent <= '0';
      WHEN "0010111110" =>
            manhi <= conv_std_logic_vector(3420482,24);
            manlo <= conv_std_logic_vector(70251462,28);
           exponent <= '0';
      WHEN "0010111111" =>
            manhi <= conv_std_logic_vector(3440216,24);
            manlo <= conv_std_logic_vector(56523029,28);
           exponent <= '0';
      WHEN "0011000000" =>
            manhi <= conv_std_logic_vector(3459969,24);
            manlo <= conv_std_logic_vector(118183989,28);
           exponent <= '0';
      WHEN "0011000001" =>
            manhi <= conv_std_logic_vector(3479741,24);
            manlo <= conv_std_logic_vector(260291170,28);
           exponent <= '0';
      WHEN "0011000010" =>
            manhi <= conv_std_logic_vector(3499533,24);
            manlo <= conv_std_logic_vector(219470882,28);
           exponent <= '0';
      WHEN "0011000011" =>
            manhi <= conv_std_logic_vector(3519345,24);
            manlo <= conv_std_logic_vector(789841,28);
           exponent <= '0';
      WHEN "0011000100" =>
            manhi <= conv_std_logic_vector(3539175,24);
            manlo <= conv_std_logic_vector(146190621,28);
           exponent <= '0';
      WHEN "0011000101" =>
            manhi <= conv_std_logic_vector(3559025,24);
            manlo <= conv_std_logic_vector(123878930,28);
           exponent <= '0';
      WHEN "0011000110" =>
            manhi <= conv_std_logic_vector(3578894,24);
            manlo <= conv_std_logic_vector(207371803,28);
           exponent <= '0';
      WHEN "0011000111" =>
            manhi <= conv_std_logic_vector(3598783,24);
            manlo <= conv_std_logic_vector(133320328,28);
           exponent <= '0';
      WHEN "0011001000" =>
            manhi <= conv_std_logic_vector(3618691,24);
            manlo <= conv_std_logic_vector(175251474,28);
           exponent <= '0';
      WHEN "0011001001" =>
            manhi <= conv_std_logic_vector(3638619,24);
            manlo <= conv_std_logic_vector(69826275,28);
           exponent <= '0';
      WHEN "0011001010" =>
            manhi <= conv_std_logic_vector(3658566,24);
            manlo <= conv_std_logic_vector(90581653,28);
           exponent <= '0';
      WHEN "0011001011" =>
            manhi <= conv_std_logic_vector(3678532,24);
            manlo <= conv_std_logic_vector(242624062,28);
           exponent <= '0';
      WHEN "0011001100" =>
            manhi <= conv_std_logic_vector(3698518,24);
            manlo <= conv_std_logic_vector(262629486,28);
           exponent <= '0';
      WHEN "0011001101" =>
            manhi <= conv_std_logic_vector(3718524,24);
            manlo <= conv_std_logic_vector(155714362,28);
           exponent <= '0';
      WHEN "0011001110" =>
            manhi <= conv_std_logic_vector(3738549,24);
            manlo <= conv_std_logic_vector(195435578,28);
           exponent <= '0';
      WHEN "0011001111" =>
            manhi <= conv_std_logic_vector(3758594,24);
            manlo <= conv_std_logic_vector(118484119,28);
           exponent <= '0';
      WHEN "0011010000" =>
            manhi <= conv_std_logic_vector(3778658,24);
            manlo <= conv_std_logic_vector(198426886,28);
           exponent <= '0';
      WHEN "0011010001" =>
            manhi <= conv_std_logic_vector(3798742,24);
            manlo <= conv_std_logic_vector(171964885,28);
           exponent <= '0';
      WHEN "0011010010" =>
            manhi <= conv_std_logic_vector(3818846,24);
            manlo <= conv_std_logic_vector(44239595,28);
           exponent <= '0';
      WHEN "0011010011" =>
            manhi <= conv_std_logic_vector(3838969,24);
            manlo <= conv_std_logic_vector(88832973,28);
           exponent <= '0';
      WHEN "0011010100" =>
            manhi <= conv_std_logic_vector(3859112,24);
            manlo <= conv_std_logic_vector(42461096,28);
           exponent <= '0';
      WHEN "0011010101" =>
            manhi <= conv_std_logic_vector(3879274,24);
            manlo <= conv_std_logic_vector(178715983,28);
           exponent <= '0';
      WHEN "0011010110" =>
            manhi <= conv_std_logic_vector(3899456,24);
            manlo <= conv_std_logic_vector(234323781,28);
           exponent <= '0';
      WHEN "0011010111" =>
            manhi <= conv_std_logic_vector(3919658,24);
            manlo <= conv_std_logic_vector(214451135,28);
           exponent <= '0';
      WHEN "0011011000" =>
            manhi <= conv_std_logic_vector(3939880,24);
            manlo <= conv_std_logic_vector(124269738,28);
           exponent <= '0';
      WHEN "0011011001" =>
            manhi <= conv_std_logic_vector(3960121,24);
            manlo <= conv_std_logic_vector(237391794,28);
           exponent <= '0';
      WHEN "0011011010" =>
            manhi <= conv_std_logic_vector(3980383,24);
            manlo <= conv_std_logic_vector(22128194,28);
           exponent <= '0';
      WHEN "0011011011" =>
            manhi <= conv_std_logic_vector(4000664,24);
            manlo <= conv_std_logic_vector(20536717,28);
           exponent <= '0';
      WHEN "0011011100" =>
            manhi <= conv_std_logic_vector(4020964,24);
            manlo <= conv_std_logic_vector(237809299,28);
           exponent <= '0';
      WHEN "0011011101" =>
            manhi <= conv_std_logic_vector(4041285,24);
            manlo <= conv_std_logic_vector(142272034,28);
           exponent <= '0';
      WHEN "0011011110" =>
            manhi <= conv_std_logic_vector(4061626,24);
            manlo <= conv_std_logic_vector(7562465,28);
           exponent <= '0';
      WHEN "0011011111" =>
            manhi <= conv_std_logic_vector(4081986,24);
            manlo <= conv_std_logic_vector(107323215,28);
           exponent <= '0';
      WHEN "0011100000" =>
            manhi <= conv_std_logic_vector(4102366,24);
            manlo <= conv_std_logic_vector(178331084,28);
           exponent <= '0';
      WHEN "0011100001" =>
            manhi <= conv_std_logic_vector(4122766,24);
            manlo <= conv_std_logic_vector(225803419,28);
           exponent <= '0';
      WHEN "0011100010" =>
            manhi <= conv_std_logic_vector(4143186,24);
            manlo <= conv_std_logic_vector(254962667,28);
           exponent <= '0';
      WHEN "0011100011" =>
            manhi <= conv_std_logic_vector(4163627,24);
            manlo <= conv_std_logic_vector(2600920,28);
           exponent <= '0';
      WHEN "0011100100" =>
            manhi <= conv_std_logic_vector(4184087,24);
            manlo <= conv_std_logic_vector(10821746,28);
           exponent <= '0';
      WHEN "0011100101" =>
            manhi <= conv_std_logic_vector(4204567,24);
            manlo <= conv_std_logic_vector(16427456,28);
           exponent <= '0';
      WHEN "0011100110" =>
            manhi <= conv_std_logic_vector(4225067,24);
            manlo <= conv_std_logic_vector(24660936,28);
           exponent <= '0';
      WHEN "0011100111" =>
            manhi <= conv_std_logic_vector(4245587,24);
            manlo <= conv_std_logic_vector(40770196,28);
           exponent <= '0';
      WHEN "0011101000" =>
            manhi <= conv_std_logic_vector(4266127,24);
            manlo <= conv_std_logic_vector(70008370,28);
           exponent <= '0';
      WHEN "0011101001" =>
            manhi <= conv_std_logic_vector(4286687,24);
            manlo <= conv_std_logic_vector(117633727,28);
           exponent <= '0';
      WHEN "0011101010" =>
            manhi <= conv_std_logic_vector(4307267,24);
            manlo <= conv_std_logic_vector(188909673,28);
           exponent <= '0';
      WHEN "0011101011" =>
            manhi <= conv_std_logic_vector(4327868,24);
            manlo <= conv_std_logic_vector(20669300,28);
           exponent <= '0';
      WHEN "0011101100" =>
            manhi <= conv_std_logic_vector(4348488,24);
            manlo <= conv_std_logic_vector(155057216,28);
           exponent <= '0';
      WHEN "0011101101" =>
            manhi <= conv_std_logic_vector(4369129,24);
            manlo <= conv_std_logic_vector(60481357,28);
           exponent <= '0';
      WHEN "0011101110" =>
            manhi <= conv_std_logic_vector(4389790,24);
            manlo <= conv_std_logic_vector(10661187,28);
           exponent <= '0';
      WHEN "0011101111" =>
            manhi <= conv_std_logic_vector(4410471,24);
            manlo <= conv_std_logic_vector(10885873,28);
           exponent <= '0';
      WHEN "0011110000" =>
            manhi <= conv_std_logic_vector(4431172,24);
            manlo <= conv_std_logic_vector(66449753,28);
           exponent <= '0';
      WHEN "0011110001" =>
            manhi <= conv_std_logic_vector(4451893,24);
            manlo <= conv_std_logic_vector(182652336,28);
           exponent <= '0';
      WHEN "0011110010" =>
            manhi <= conv_std_logic_vector(4472635,24);
            manlo <= conv_std_logic_vector(96362852,28);
           exponent <= '0';
      WHEN "0011110011" =>
            manhi <= conv_std_logic_vector(4493397,24);
            manlo <= conv_std_logic_vector(81326629,28);
           exponent <= '0';
      WHEN "0011110100" =>
            manhi <= conv_std_logic_vector(4514179,24);
            manlo <= conv_std_logic_vector(142858724,28);
           exponent <= '0';
      WHEN "0011110101" =>
            manhi <= conv_std_logic_vector(4534982,24);
            manlo <= conv_std_logic_vector(17843933,28);
           exponent <= '0';
      WHEN "0011110110" =>
            manhi <= conv_std_logic_vector(4555804,24);
            manlo <= conv_std_logic_vector(248478616,28);
           exponent <= '0';
      WHEN "0011110111" =>
            manhi <= conv_std_logic_vector(4576648,24);
            manlo <= conv_std_logic_vector(34787059,28);
           exponent <= '0';
      WHEN "0011111000" =>
            manhi <= conv_std_logic_vector(4597511,24);
            manlo <= conv_std_logic_vector(187411489,28);
           exponent <= '0';
      WHEN "0011111001" =>
            manhi <= conv_std_logic_vector(4618395,24);
            manlo <= conv_std_logic_vector(174822068,28);
           exponent <= '0';
      WHEN "0011111010" =>
            manhi <= conv_std_logic_vector(4639300,24);
            manlo <= conv_std_logic_vector(2365090,28);
           exponent <= '0';
      WHEN "0011111011" =>
            manhi <= conv_std_logic_vector(4660224,24);
            manlo <= conv_std_logic_vector(212262982,28);
           exponent <= '0';
      WHEN "0011111100" =>
            manhi <= conv_std_logic_vector(4681170,24);
            manlo <= conv_std_logic_vector(4566120,28);
           exponent <= '0';
      WHEN "0011111101" =>
            manhi <= conv_std_logic_vector(4702135,24);
            manlo <= conv_std_logic_vector(189942850,28);
           exponent <= '0';
      WHEN "0011111110" =>
            manhi <= conv_std_logic_vector(4723121,24);
            manlo <= conv_std_logic_vector(236889480,28);
           exponent <= '0';
      WHEN "0011111111" =>
            manhi <= conv_std_logic_vector(4744128,24);
            manlo <= conv_std_logic_vector(150778468,28);
           exponent <= '0';
      WHEN "0100000000" =>
            manhi <= conv_std_logic_vector(4765155,24);
            manlo <= conv_std_logic_vector(205422982,28);
           exponent <= '0';
      WHEN "0100000001" =>
            manhi <= conv_std_logic_vector(4786203,24);
            manlo <= conv_std_logic_vector(137770531,28);
           exponent <= '0';
      WHEN "0100000010" =>
            manhi <= conv_std_logic_vector(4807271,24);
            manlo <= conv_std_logic_vector(221644793,28);
           exponent <= '0';
      WHEN "0100000011" =>
            manhi <= conv_std_logic_vector(4828360,24);
            manlo <= conv_std_logic_vector(194003802,28);
           exponent <= '0';
      WHEN "0100000100" =>
            manhi <= conv_std_logic_vector(4849470,24);
            manlo <= conv_std_logic_vector(60246316,28);
           exponent <= '0';
      WHEN "0100000101" =>
            manhi <= conv_std_logic_vector(4870600,24);
            manlo <= conv_std_logic_vector(94211823,28);
           exponent <= '0';
      WHEN "0100000110" =>
            manhi <= conv_std_logic_vector(4891751,24);
            manlo <= conv_std_logic_vector(32874180,28);
           exponent <= '0';
      WHEN "0100000111" =>
            manhi <= conv_std_logic_vector(4912922,24);
            manlo <= conv_std_logic_vector(150083442,28);
           exponent <= '0';
      WHEN "0100001000" =>
            manhi <= conv_std_logic_vector(4934114,24);
            manlo <= conv_std_logic_vector(182824039,28);
           exponent <= '0';
      WHEN "0100001001" =>
            manhi <= conv_std_logic_vector(4955327,24);
            manlo <= conv_std_logic_vector(136521157,28);
           exponent <= '0';
      WHEN "0100001010" =>
            manhi <= conv_std_logic_vector(4976561,24);
            manlo <= conv_std_logic_vector(16605280,28);
           exponent <= '0';
      WHEN "0100001011" =>
            manhi <= conv_std_logic_vector(4997815,24);
            manlo <= conv_std_logic_vector(96947652,28);
           exponent <= '0';
      WHEN "0100001100" =>
            manhi <= conv_std_logic_vector(5019090,24);
            manlo <= conv_std_logic_vector(114553920,28);
           exponent <= '0';
      WHEN "0100001101" =>
            manhi <= conv_std_logic_vector(5040386,24);
            manlo <= conv_std_logic_vector(74870501,28);
           exponent <= '0';
      WHEN "0100001110" =>
            manhi <= conv_std_logic_vector(5061702,24);
            manlo <= conv_std_logic_vector(251784590,28);
           exponent <= '0';
      WHEN "0100001111" =>
            manhi <= conv_std_logic_vector(5083040,24);
            manlo <= conv_std_logic_vector(113882338,28);
           exponent <= '0';
      WHEN "0100010000" =>
            manhi <= conv_std_logic_vector(5104398,24);
            manlo <= conv_std_logic_vector(203497056,28);
           exponent <= '0';
      WHEN "0100010001" =>
            manhi <= conv_std_logic_vector(5125777,24);
            manlo <= conv_std_logic_vector(257661021,28);
           exponent <= '0';
      WHEN "0100010010" =>
            manhi <= conv_std_logic_vector(5147178,24);
            manlo <= conv_std_logic_vector(13411854,28);
           exponent <= '0';
      WHEN "0100010011" =>
            manhi <= conv_std_logic_vector(5168599,24);
            manlo <= conv_std_logic_vector(13098889,28);
           exponent <= '0';
      WHEN "0100010100" =>
            manhi <= conv_std_logic_vector(5190040,24);
            manlo <= conv_std_logic_vector(262205904,28);
           exponent <= '0';
      WHEN "0100010101" =>
            manhi <= conv_std_logic_vector(5211503,24);
            manlo <= conv_std_logic_vector(229351119,28);
           exponent <= '0';
      WHEN "0100010110" =>
            manhi <= conv_std_logic_vector(5232987,24);
            manlo <= conv_std_logic_vector(188464488,28);
           exponent <= '0';
      WHEN "0100010111" =>
            manhi <= conv_std_logic_vector(5254492,24);
            manlo <= conv_std_logic_vector(145045878,28);
           exponent <= '0';
      WHEN "0100011000" =>
            manhi <= conv_std_logic_vector(5276018,24);
            manlo <= conv_std_logic_vector(104600525,28);
           exponent <= '0';
      WHEN "0100011001" =>
            manhi <= conv_std_logic_vector(5297565,24);
            manlo <= conv_std_logic_vector(72639049,28);
           exponent <= '0';
      WHEN "0100011010" =>
            manhi <= conv_std_logic_vector(5319133,24);
            manlo <= conv_std_logic_vector(54677451,28);
           exponent <= '0';
      WHEN "0100011011" =>
            manhi <= conv_std_logic_vector(5340722,24);
            manlo <= conv_std_logic_vector(56237123,28);
           exponent <= '0';
      WHEN "0100011100" =>
            manhi <= conv_std_logic_vector(5362332,24);
            manlo <= conv_std_logic_vector(82844851,28);
           exponent <= '0';
      WHEN "0100011101" =>
            manhi <= conv_std_logic_vector(5383963,24);
            manlo <= conv_std_logic_vector(140032820,28);
           exponent <= '0';
      WHEN "0100011110" =>
            manhi <= conv_std_logic_vector(5405615,24);
            manlo <= conv_std_logic_vector(233338622,28);
           exponent <= '0';
      WHEN "0100011111" =>
            manhi <= conv_std_logic_vector(5427289,24);
            manlo <= conv_std_logic_vector(99869801,28);
           exponent <= '0';
      WHEN "0100100000" =>
            manhi <= conv_std_logic_vector(5448984,24);
            manlo <= conv_std_logic_vector(13610232,28);
           exponent <= '0';
      WHEN "0100100001" =>
            manhi <= conv_std_logic_vector(5470699,24);
            manlo <= conv_std_logic_vector(248549207,28);
           exponent <= '0';
      WHEN "0100100010" =>
            manhi <= conv_std_logic_vector(5492437,24);
            manlo <= conv_std_logic_vector(4939624,28);
           exponent <= '0';
      WHEN "0100100011" =>
            manhi <= conv_std_logic_vector(5514195,24);
            manlo <= conv_std_logic_vector(93652547,28);
           exponent <= '0';
      WHEN "0100100100" =>
            manhi <= conv_std_logic_vector(5535974,24);
            manlo <= conv_std_logic_vector(251822653,28);
           exponent <= '0';
      WHEN "0100100101" =>
            manhi <= conv_std_logic_vector(5557775,24);
            manlo <= conv_std_logic_vector(216590061,28);
           exponent <= '0';
      WHEN "0100100110" =>
            manhi <= conv_std_logic_vector(5579597,24);
            manlo <= conv_std_logic_vector(261971250,28);
           exponent <= '0';
      WHEN "0100100111" =>
            manhi <= conv_std_logic_vector(5601441,24);
            manlo <= conv_std_logic_vector(125117240,28);
           exponent <= '0';
      WHEN "0100101000" =>
            manhi <= conv_std_logic_vector(5623306,24);
            manlo <= conv_std_logic_vector(80055420,28);
           exponent <= '0';
      WHEN "0100101001" =>
            manhi <= conv_std_logic_vector(5645192,24);
            manlo <= conv_std_logic_vector(132383188,28);
           exponent <= '0';
      WHEN "0100101010" =>
            manhi <= conv_std_logic_vector(5667100,24);
            manlo <= conv_std_logic_vector(19267955,28);
           exponent <= '0';
      WHEN "0100101011" =>
            manhi <= conv_std_logic_vector(5689029,24);
            manlo <= conv_std_logic_vector(14753516,28);
           exponent <= '0';
      WHEN "0100101100" =>
            manhi <= conv_std_logic_vector(5710979,24);
            manlo <= conv_std_logic_vector(124453694,28);
           exponent <= '0';
      WHEN "0100101101" =>
            manhi <= conv_std_logic_vector(5732951,24);
            manlo <= conv_std_logic_vector(85552334,28);
           exponent <= '0';
      WHEN "0100101110" =>
            manhi <= conv_std_logic_vector(5754944,24);
            manlo <= conv_std_logic_vector(172109691,28);
           exponent <= '0';
      WHEN "0100101111" =>
            manhi <= conv_std_logic_vector(5776959,24);
            manlo <= conv_std_logic_vector(121320598,28);
           exponent <= '0';
      WHEN "0100110000" =>
            manhi <= conv_std_logic_vector(5798995,24);
            manlo <= conv_std_logic_vector(207256304,28);
           exponent <= '0';
      WHEN "0100110001" =>
            manhi <= conv_std_logic_vector(5821053,24);
            manlo <= conv_std_logic_vector(167122651,28);
           exponent <= '0';
      WHEN "0100110010" =>
            manhi <= conv_std_logic_vector(5843133,24);
            manlo <= conv_std_logic_vector(6566449,28);
           exponent <= '0';
      WHEN "0100110011" =>
            manhi <= conv_std_logic_vector(5865233,24);
            manlo <= conv_std_logic_vector(268110937,28);
           exponent <= '0';
      WHEN "0100110100" =>
            manhi <= conv_std_logic_vector(5887356,24);
            manlo <= conv_std_logic_vector(152107598,28);
           exponent <= '0';
      WHEN "0100110101" =>
            manhi <= conv_std_logic_vector(5909500,24);
            manlo <= conv_std_logic_vector(201090721,28);
           exponent <= '0';
      WHEN "0100110110" =>
            manhi <= conv_std_logic_vector(5931666,24);
            manlo <= conv_std_logic_vector(152293761,28);
           exponent <= '0';
      WHEN "0100110111" =>
            manhi <= conv_std_logic_vector(5953854,24);
            manlo <= conv_std_logic_vector(11391168,28);
           exponent <= '0';
      WHEN "0100111000" =>
            manhi <= conv_std_logic_vector(5976063,24);
            manlo <= conv_std_logic_vector(52498394,28);
           exponent <= '0';
      WHEN "0100111001" =>
            manhi <= conv_std_logic_vector(5998294,24);
            manlo <= conv_std_logic_vector(12865523,28);
           exponent <= '0';
      WHEN "0100111010" =>
            manhi <= conv_std_logic_vector(6020546,24);
            manlo <= conv_std_logic_vector(166619112,28);
           exponent <= '0';
      WHEN "0100111011" =>
            manhi <= conv_std_logic_vector(6042820,24);
            manlo <= conv_std_logic_vector(251020365,28);
           exponent <= '0';
      WHEN "0100111100" =>
            manhi <= conv_std_logic_vector(6065117,24);
            manlo <= conv_std_logic_vector(3336048,28);
           exponent <= '0';
      WHEN "0100111101" =>
            manhi <= conv_std_logic_vector(6087434,24);
            manlo <= conv_std_logic_vector(234580328,28);
           exponent <= '0';
      WHEN "0100111110" =>
            manhi <= conv_std_logic_vector(6109774,24);
            manlo <= conv_std_logic_vector(145160209,28);
           exponent <= '0';
      WHEN "0100111111" =>
            manhi <= conv_std_logic_vector(6132136,24);
            manlo <= conv_std_logic_vector(9230102,28);
           exponent <= '0';
      WHEN "0101000000" =>
            manhi <= conv_std_logic_vector(6154519,24);
            manlo <= conv_std_logic_vector(100950005,28);
           exponent <= '0';
      WHEN "0101000001" =>
            manhi <= conv_std_logic_vector(6176924,24);
            manlo <= conv_std_logic_vector(157614600,28);
           exponent <= '0';
      WHEN "0101000010" =>
            manhi <= conv_std_logic_vector(6199351,24);
            manlo <= conv_std_logic_vector(184959620,28);
           exponent <= '0';
      WHEN "0101000011" =>
            manhi <= conv_std_logic_vector(6221800,24);
            manlo <= conv_std_logic_vector(188726403,28);
           exponent <= '0';
      WHEN "0101000100" =>
            manhi <= conv_std_logic_vector(6244271,24);
            manlo <= conv_std_logic_vector(174661898,28);
           exponent <= '0';
      WHEN "0101000101" =>
            manhi <= conv_std_logic_vector(6266764,24);
            manlo <= conv_std_logic_vector(148518669,28);
           exponent <= '0';
      WHEN "0101000110" =>
            manhi <= conv_std_logic_vector(6289279,24);
            manlo <= conv_std_logic_vector(116054898,28);
           exponent <= '0';
      WHEN "0101000111" =>
            manhi <= conv_std_logic_vector(6311816,24);
            manlo <= conv_std_logic_vector(83034395,28);
           exponent <= '0';
      WHEN "0101001000" =>
            manhi <= conv_std_logic_vector(6334375,24);
            manlo <= conv_std_logic_vector(55226600,28);
           exponent <= '0';
      WHEN "0101001001" =>
            manhi <= conv_std_logic_vector(6356956,24);
            manlo <= conv_std_logic_vector(38406593,28);
           exponent <= '0';
      WHEN "0101001010" =>
            manhi <= conv_std_logic_vector(6379559,24);
            manlo <= conv_std_logic_vector(38355093,28);
           exponent <= '0';
      WHEN "0101001011" =>
            manhi <= conv_std_logic_vector(6402184,24);
            manlo <= conv_std_logic_vector(60858469,28);
           exponent <= '0';
      WHEN "0101001100" =>
            manhi <= conv_std_logic_vector(6424831,24);
            manlo <= conv_std_logic_vector(111708742,28);
           exponent <= '0';
      WHEN "0101001101" =>
            manhi <= conv_std_logic_vector(6447500,24);
            manlo <= conv_std_logic_vector(196703594,28);
           exponent <= '0';
      WHEN "0101001110" =>
            manhi <= conv_std_logic_vector(6470192,24);
            manlo <= conv_std_logic_vector(53210914,28);
           exponent <= '0';
      WHEN "0101001111" =>
            manhi <= conv_std_logic_vector(6492905,24);
            manlo <= conv_std_logic_vector(223910630,28);
           exponent <= '0';
      WHEN "0101010000" =>
            manhi <= conv_std_logic_vector(6515641,24);
            manlo <= conv_std_logic_vector(177746520,28);
           exponent <= '0';
      WHEN "0101010001" =>
            manhi <= conv_std_logic_vector(6538399,24);
            manlo <= conv_std_logic_vector(188974414,28);
           exponent <= '0';
      WHEN "0101010010" =>
            manhi <= conv_std_logic_vector(6561179,24);
            manlo <= conv_std_logic_vector(263420371,28);
           exponent <= '0';
      WHEN "0101010011" =>
            manhi <= conv_std_logic_vector(6583982,24);
            manlo <= conv_std_logic_vector(138480686,28);
           exponent <= '0';
      WHEN "0101010100" =>
            manhi <= conv_std_logic_vector(6606807,24);
            manlo <= conv_std_logic_vector(88428264,28);
           exponent <= '0';
      WHEN "0101010101" =>
            manhi <= conv_std_logic_vector(6629654,24);
            manlo <= conv_std_logic_vector(119106258,28);
           exponent <= '0';
      WHEN "0101010110" =>
            manhi <= conv_std_logic_vector(6652523,24);
            manlo <= conv_std_logic_vector(236363530,28);
           exponent <= '0';
      WHEN "0101010111" =>
            manhi <= conv_std_logic_vector(6675415,24);
            manlo <= conv_std_logic_vector(177619200,28);
           exponent <= '0';
      WHEN "0101011000" =>
            manhi <= conv_std_logic_vector(6698329,24);
            manlo <= conv_std_logic_vector(217169020,28);
           exponent <= '0';
      WHEN "0101011001" =>
            manhi <= conv_std_logic_vector(6721266,24);
            manlo <= conv_std_logic_vector(92443558,28);
           exponent <= '0';
      WHEN "0101011010" =>
            manhi <= conv_std_logic_vector(6744225,24);
            manlo <= conv_std_logic_vector(77750021,28);
           exponent <= '0';
      WHEN "0101011011" =>
            manhi <= conv_std_logic_vector(6767206,24);
            manlo <= conv_std_logic_vector(178965902,28);
           exponent <= '0';
      WHEN "0101011100" =>
            manhi <= conv_std_logic_vector(6790210,24);
            manlo <= conv_std_logic_vector(133538975,28);
           exponent <= '0';
      WHEN "0101011101" =>
            manhi <= conv_std_logic_vector(6813236,24);
            manlo <= conv_std_logic_vector(215793680,28);
           exponent <= '0';
      WHEN "0101011110" =>
            manhi <= conv_std_logic_vector(6836285,24);
            manlo <= conv_std_logic_vector(163189294,28);
           exponent <= '0';
      WHEN "0101011111" =>
            manhi <= conv_std_logic_vector(6859356,24);
            manlo <= conv_std_logic_vector(250061769,28);
           exponent <= '0';
      WHEN "0101100000" =>
            manhi <= conv_std_logic_vector(6882450,24);
            manlo <= conv_std_logic_vector(213881907,28);
           exponent <= '0';
      WHEN "0101100001" =>
            manhi <= conv_std_logic_vector(6905567,24);
            manlo <= conv_std_logic_vector(60561738,28);
           exponent <= '0';
      WHEN "0101100010" =>
            manhi <= conv_std_logic_vector(6928706,24);
            manlo <= conv_std_logic_vector(64454525,28);
           exponent <= '0';
      WHEN "0101100011" =>
            manhi <= conv_std_logic_vector(6951867,24);
            manlo <= conv_std_logic_vector(231483856,28);
           exponent <= '0';
      WHEN "0101100100" =>
            manhi <= conv_std_logic_vector(6975052,24);
            manlo <= conv_std_logic_vector(30708194,28);
           exponent <= '0';
      WHEN "0101100101" =>
            manhi <= conv_std_logic_vector(6998259,24);
            manlo <= conv_std_logic_vector(4933620,28);
           exponent <= '0';
      WHEN "0101100110" =>
            manhi <= conv_std_logic_vector(7021488,24);
            manlo <= conv_std_logic_vector(160101103,28);
           exponent <= '0';
      WHEN "0101100111" =>
            manhi <= conv_std_logic_vector(7044740,24);
            manlo <= conv_std_logic_vector(233721959,28);
           exponent <= '0';
      WHEN "0101101000" =>
            manhi <= conv_std_logic_vector(7068015,24);
            manlo <= conv_std_logic_vector(231748770,28);
           exponent <= '0';
      WHEN "0101101001" =>
            manhi <= conv_std_logic_vector(7091313,24);
            manlo <= conv_std_logic_vector(160139936,28);
           exponent <= '0';
      WHEN "0101101010" =>
            manhi <= conv_std_logic_vector(7114634,24);
            manlo <= conv_std_logic_vector(24859676,28);
           exponent <= '0';
      WHEN "0101101011" =>
            manhi <= conv_std_logic_vector(7137977,24);
            manlo <= conv_std_logic_vector(100313494,28);
           exponent <= '0';
      WHEN "0101101100" =>
            manhi <= conv_std_logic_vector(7161343,24);
            manlo <= conv_std_logic_vector(124041814,28);
           exponent <= '0';
      WHEN "0101101101" =>
            manhi <= conv_std_logic_vector(7184732,24);
            manlo <= conv_std_logic_vector(102026355,28);
           exponent <= '0';
      WHEN "0101101110" =>
            manhi <= conv_std_logic_vector(7208144,24);
            manlo <= conv_std_logic_vector(40254681,28);
           exponent <= '0';
      WHEN "0101101111" =>
            manhi <= conv_std_logic_vector(7231578,24);
            manlo <= conv_std_logic_vector(213155662,28);
           exponent <= '0';
      WHEN "0101110000" =>
            manhi <= conv_std_logic_vector(7255036,24);
            manlo <= conv_std_logic_vector(89857654,28);
           exponent <= '0';
      WHEN "0101110001" =>
            manhi <= conv_std_logic_vector(7278516,24);
            manlo <= conv_std_logic_vector(213236700,28);
           exponent <= '0';
      WHEN "0101110010" =>
            manhi <= conv_std_logic_vector(7302020,24);
            manlo <= conv_std_logic_vector(52432888,28);
           exponent <= '0';
      WHEN "0101110011" =>
            manhi <= conv_std_logic_vector(7325546,24);
            manlo <= conv_std_logic_vector(150334000,28);
           exponent <= '0';
      WHEN "0101110100" =>
            manhi <= conv_std_logic_vector(7349095,24);
            manlo <= conv_std_logic_vector(244527329,28);
           exponent <= '0';
      WHEN "0101110101" =>
            manhi <= conv_std_logic_vector(7372668,24);
            manlo <= conv_std_logic_vector(72606054,28);
           exponent <= '0';
      WHEN "0101110110" =>
            manhi <= conv_std_logic_vector(7396263,24);
            manlo <= conv_std_logic_vector(177475612,28);
           exponent <= '0';
      WHEN "0101110111" =>
            manhi <= conv_std_logic_vector(7419882,24);
            manlo <= conv_std_logic_vector(28305511,28);
           exponent <= '0';
      WHEN "0101111000" =>
            manhi <= conv_std_logic_vector(7443523,24);
            manlo <= conv_std_logic_vector(168012985,28);
           exponent <= '0';
      WHEN "0101111001" =>
            manhi <= conv_std_logic_vector(7467188,24);
            manlo <= conv_std_logic_vector(65779352,28);
           exponent <= '0';
      WHEN "0101111010" =>
            manhi <= conv_std_logic_vector(7490875,24);
            manlo <= conv_std_logic_vector(264533668,28);
           exponent <= '0';
      WHEN "0101111011" =>
            manhi <= conv_std_logic_vector(7514586,24);
            manlo <= conv_std_logic_vector(233469080,28);
           exponent <= '0';
      WHEN "0101111100" =>
            manhi <= conv_std_logic_vector(7538320,24);
            manlo <= conv_std_logic_vector(247091035,28);
           exponent <= '0';
      WHEN "0101111101" =>
            manhi <= conv_std_logic_vector(7562078,24);
            manlo <= conv_std_logic_vector(43039991,28);
           exponent <= '0';
      WHEN "0101111110" =>
            manhi <= conv_std_logic_vector(7585858,24);
            manlo <= conv_std_logic_vector(164268716,28);
           exponent <= '0';
      WHEN "0101111111" =>
            manhi <= conv_std_logic_vector(7609662,24);
            manlo <= conv_std_logic_vector(79994093,28);
           exponent <= '0';
      WHEN "0110000000" =>
            manhi <= conv_std_logic_vector(7633489,24);
            manlo <= conv_std_logic_vector(64745322,28);
           exponent <= '0';
      WHEN "0110000001" =>
            manhi <= conv_std_logic_vector(7657339,24);
            manlo <= conv_std_logic_vector(124622102,28);
           exponent <= '0';
      WHEN "0110000010" =>
            manhi <= conv_std_logic_vector(7681212,24);
            manlo <= conv_std_logic_vector(265730090,28);
           exponent <= '0';
      WHEN "0110000011" =>
            manhi <= conv_std_logic_vector(7705109,24);
            manlo <= conv_std_logic_vector(225745453,28);
           exponent <= '0';
      WHEN "0110000100" =>
            manhi <= conv_std_logic_vector(7729030,24);
            manlo <= conv_std_logic_vector(10785785,28);
           exponent <= '0';
      WHEN "0110000101" =>
            manhi <= conv_std_logic_vector(7752973,24);
            manlo <= conv_std_logic_vector(163845570,28);
           exponent <= '0';
      WHEN "0110000110" =>
            manhi <= conv_std_logic_vector(7776940,24);
            manlo <= conv_std_logic_vector(154183450,28);
           exponent <= '0';
      WHEN "0110000111" =>
            manhi <= conv_std_logic_vector(7800930,24);
            manlo <= conv_std_logic_vector(256370426,28);
           exponent <= '0';
      WHEN "0110001000" =>
            manhi <= conv_std_logic_vector(7824944,24);
            manlo <= conv_std_logic_vector(208112577,28);
           exponent <= '0';
      WHEN "0110001001" =>
            manhi <= conv_std_logic_vector(7848982,24);
            manlo <= conv_std_logic_vector(15557444,28);
           exponent <= '0';
      WHEN "0110001010" =>
            manhi <= conv_std_logic_vector(7873042,24);
            manlo <= conv_std_logic_vector(221729482,28);
           exponent <= '0';
      WHEN "0110001011" =>
            manhi <= conv_std_logic_vector(7897127,24);
            manlo <= conv_std_logic_vector(27481881,28);
           exponent <= '0';
      WHEN "0110001100" =>
            manhi <= conv_std_logic_vector(7921234,24);
            manlo <= conv_std_logic_vector(244286584,28);
           exponent <= '0';
      WHEN "0110001101" =>
            manhi <= conv_std_logic_vector(7945366,24);
            manlo <= conv_std_logic_vector(73008824,28);
           exponent <= '0';
      WHEN "0110001110" =>
            manhi <= conv_std_logic_vector(7969521,24);
            manlo <= conv_std_logic_vector(56697140,28);
           exponent <= '0';
      WHEN "0110001111" =>
            manhi <= conv_std_logic_vector(7993699,24);
            manlo <= conv_std_logic_vector(201535196,28);
           exponent <= '0';
      WHEN "0110010000" =>
            manhi <= conv_std_logic_vector(8017901,24);
            manlo <= conv_std_logic_vector(245277246,28);
           exponent <= '0';
      WHEN "0110010001" =>
            manhi <= conv_std_logic_vector(8042127,24);
            manlo <= conv_std_logic_vector(194119042,28);
           exponent <= '0';
      WHEN "0110010010" =>
            manhi <= conv_std_logic_vector(8066377,24);
            manlo <= conv_std_logic_vector(54262392,28);
           exponent <= '0';
      WHEN "0110010011" =>
            manhi <= conv_std_logic_vector(8090650,24);
            manlo <= conv_std_logic_vector(100350618,28);
           exponent <= '0';
      WHEN "0110010100" =>
            manhi <= conv_std_logic_vector(8114947,24);
            manlo <= conv_std_logic_vector(70162199,28);
           exponent <= '0';
      WHEN "0110010101" =>
            manhi <= conv_std_logic_vector(8139267,24);
            manlo <= conv_std_logic_vector(238352593,28);
           exponent <= '0';
      WHEN "0110010110" =>
            manhi <= conv_std_logic_vector(8163612,24);
            manlo <= conv_std_logic_vector(74276969,28);
           exponent <= '0';
      WHEN "0110010111" =>
            manhi <= conv_std_logic_vector(8187980,24);
            manlo <= conv_std_logic_vector(121038404,28);
           exponent <= '0';
      WHEN "0110011000" =>
            manhi <= conv_std_logic_vector(8212372,24);
            manlo <= conv_std_logic_vector(116439694,28);
           exponent <= '0';
      WHEN "0110011001" =>
            manhi <= conv_std_logic_vector(8236788,24);
            manlo <= conv_std_logic_vector(66725186,28);
           exponent <= '0';
      WHEN "0110011010" =>
            manhi <= conv_std_logic_vector(8261227,24);
            manlo <= conv_std_logic_vector(246580788,28);
           exponent <= '0';
      WHEN "0110011011" =>
            manhi <= conv_std_logic_vector(8285691,24);
            manlo <= conv_std_logic_vector(125392143,28);
           exponent <= '0';
      WHEN "0110011100" =>
            manhi <= conv_std_logic_vector(8310178,24);
            manlo <= conv_std_logic_vector(246292830,28);
           exponent <= '0';
      WHEN "0110011101" =>
            manhi <= conv_std_logic_vector(8334690,24);
            manlo <= conv_std_logic_vector(78680728,28);
           exponent <= '0';
      WHEN "0110011110" =>
            manhi <= conv_std_logic_vector(8359225,24);
            manlo <= conv_std_logic_vector(165701659,28);
           exponent <= '0';
      WHEN "0110011111" =>
            manhi <= conv_std_logic_vector(8383784,24);
            manlo <= conv_std_logic_vector(245201212,28);
           exponent <= '0';
      WHEN "0110100000" =>
            manhi <= conv_std_logic_vector(8408368,24);
            manlo <= conv_std_logic_vector(55031110,28);
           exponent <= '0';
      WHEN "0110100001" =>
            manhi <= conv_std_logic_vector(8432975,24);
            manlo <= conv_std_logic_vector(138355589,28);
           exponent <= '0';
      WHEN "0110100010" =>
            manhi <= conv_std_logic_vector(8457606,24);
            manlo <= conv_std_logic_vector(233038665,28);
           exponent <= '0';
      WHEN "0110100011" =>
            manhi <= conv_std_logic_vector(8482262,24);
            manlo <= conv_std_logic_vector(76950508,28);
           exponent <= '0';
      WHEN "0110100100" =>
            manhi <= conv_std_logic_vector(8506941,24);
            manlo <= conv_std_logic_vector(213273820,28);
           exponent <= '0';
      WHEN "0110100101" =>
            manhi <= conv_std_logic_vector(8531645,24);
            manlo <= conv_std_logic_vector(111455640,28);
           exponent <= '0';
      WHEN "0110100110" =>
            manhi <= conv_std_logic_vector(8556373,24);
            manlo <= conv_std_logic_vector(46255554,28);
           exponent <= '0';
      WHEN "0110100111" =>
            manhi <= conv_std_logic_vector(8581125,24);
            manlo <= conv_std_logic_vector(24003868,28);
           exponent <= '0';
      WHEN "0110101000" =>
            manhi <= conv_std_logic_vector(8605901,24);
            manlo <= conv_std_logic_vector(51037072,28);
           exponent <= '0';
      WHEN "0110101001" =>
            manhi <= conv_std_logic_vector(8630701,24);
            manlo <= conv_std_logic_vector(133697849,28);
           exponent <= '0';
      WHEN "0110101010" =>
            manhi <= conv_std_logic_vector(8655526,24);
            manlo <= conv_std_logic_vector(9899623,28);
           exponent <= '0';
      WHEN "0110101011" =>
            manhi <= conv_std_logic_vector(8680374,24);
            manlo <= conv_std_logic_vector(222868388,28);
           exponent <= '0';
      WHEN "0110101100" =>
            manhi <= conv_std_logic_vector(8705247,24);
            manlo <= conv_std_logic_vector(242094523,28);
           exponent <= '0';
      WHEN "0110101101" =>
            manhi <= conv_std_logic_vector(8730145,24);
            manlo <= conv_std_logic_vector(73945536,28);
           exponent <= '0';
      WHEN "0110101110" =>
            manhi <= conv_std_logic_vector(8755066,24);
            manlo <= conv_std_logic_vector(261666066,28);
           exponent <= '0';
      WHEN "0110101111" =>
            manhi <= conv_std_logic_vector(8780013,24);
            manlo <= conv_std_logic_vector(6329700,28);
           exponent <= '0';
      WHEN "0110110000" =>
            manhi <= conv_std_logic_vector(8804983,24);
            manlo <= conv_std_logic_vector(119628997,28);
           exponent <= '0';
      WHEN "0110110001" =>
            manhi <= conv_std_logic_vector(8829978,24);
            manlo <= conv_std_logic_vector(71085473,28);
           exponent <= '0';
      WHEN "0110110010" =>
            manhi <= conv_std_logic_vector(8854997,24);
            manlo <= conv_std_logic_vector(135533257,28);
           exponent <= '0';
      WHEN "0110110011" =>
            manhi <= conv_std_logic_vector(8880041,24);
            manlo <= conv_std_logic_vector(50941820,28);
           exponent <= '0';
      WHEN "0110110100" =>
            manhi <= conv_std_logic_vector(8905109,24);
            manlo <= conv_std_logic_vector(92157802,28);
           exponent <= '0';
      WHEN "0110110101" =>
            manhi <= conv_std_logic_vector(8930201,24);
            manlo <= conv_std_logic_vector(265598650,28);
           exponent <= '0';
      WHEN "0110110110" =>
            manhi <= conv_std_logic_vector(8955319,24);
            manlo <= conv_std_logic_vector(40817170,28);
           exponent <= '0';
      WHEN "0110110111" =>
            manhi <= conv_std_logic_vector(8980460,24);
            manlo <= conv_std_logic_vector(229549724,28);
           exponent <= '0';
      WHEN "0110111000" =>
            manhi <= conv_std_logic_vector(9005627,24);
            manlo <= conv_std_logic_vector(32926222,28);
           exponent <= '0';
      WHEN "0110111001" =>
            manhi <= conv_std_logic_vector(9030817,24);
            manlo <= conv_std_logic_vector(262695596,28);
           exponent <= '0';
      WHEN "0110111010" =>
            manhi <= conv_std_logic_vector(9056033,24);
            manlo <= conv_std_logic_vector(120000337,28);
           exponent <= '0';
      WHEN "0110111011" =>
            manhi <= conv_std_logic_vector(9081273,24);
            manlo <= conv_std_logic_vector(148166518,28);
           exponent <= '0';
      WHEN "0110111100" =>
            manhi <= conv_std_logic_vector(9106538,24);
            manlo <= conv_std_logic_vector(85220151,28);
           exponent <= '0';
      WHEN "0110111101" =>
            manhi <= conv_std_logic_vector(9131827,24);
            manlo <= conv_std_logic_vector(206064472,28);
           exponent <= '0';
      WHEN "0110111110" =>
            manhi <= conv_std_logic_vector(9157141,24);
            manlo <= conv_std_logic_vector(248738124,28);
           exponent <= '0';
      WHEN "0110111111" =>
            manhi <= conv_std_logic_vector(9182480,24);
            manlo <= conv_std_logic_vector(219721533,28);
           exponent <= '0';
      WHEN "0111000000" =>
            manhi <= conv_std_logic_vector(9207844,24);
            manlo <= conv_std_logic_vector(125501456,28);
           exponent <= '0';
      WHEN "0111000001" =>
            manhi <= conv_std_logic_vector(9233232,24);
            manlo <= conv_std_logic_vector(241006443,28);
           exponent <= '0';
      WHEN "0111000010" =>
            manhi <= conv_std_logic_vector(9258646,24);
            manlo <= conv_std_logic_vector(35865021,28);
           exponent <= '0';
      WHEN "0111000011" =>
            manhi <= conv_std_logic_vector(9284084,24);
            manlo <= conv_std_logic_vector(53453891,28);
           exponent <= '0';
      WHEN "0111000100" =>
            manhi <= conv_std_logic_vector(9309547,24);
            manlo <= conv_std_logic_vector(31849742,28);
           exponent <= '0';
      WHEN "0111000101" =>
            manhi <= conv_std_logic_vector(9335034,24);
            manlo <= conv_std_logic_vector(246006538,28);
           exponent <= '0';
      WHEN "0111000110" =>
            manhi <= conv_std_logic_vector(9360547,24);
            manlo <= conv_std_logic_vector(165578245,28);
           exponent <= '0';
      WHEN "0111000111" =>
            manhi <= conv_std_logic_vector(9386085,24);
            manlo <= conv_std_logic_vector(65531569,28);
           exponent <= '0';
      WHEN "0111001000" =>
            manhi <= conv_std_logic_vector(9411647,24);
            manlo <= conv_std_logic_vector(220839600,28);
           exponent <= '0';
      WHEN "0111001001" =>
            manhi <= conv_std_logic_vector(9437235,24);
            manlo <= conv_std_logic_vector(101175446,28);
           exponent <= '0';
      WHEN "0111001010" =>
            manhi <= conv_std_logic_vector(9462847,24);
            manlo <= conv_std_logic_vector(249960434,28);
           exponent <= '0';
      WHEN "0111001011" =>
            manhi <= conv_std_logic_vector(9488485,24);
            manlo <= conv_std_logic_vector(136880466,28);
           exponent <= '0';
      WHEN "0111001100" =>
            manhi <= conv_std_logic_vector(9514148,24);
            manlo <= conv_std_logic_vector(36934219,28);
           exponent <= '0';
      WHEN "0111001101" =>
            manhi <= conv_std_logic_vector(9539835,24);
            manlo <= conv_std_logic_vector(225126782,28);
           exponent <= '0';
      WHEN "0111001110" =>
            manhi <= conv_std_logic_vector(9565548,24);
            manlo <= conv_std_logic_vector(171163295,28);
           exponent <= '0';
      WHEN "0111001111" =>
            manhi <= conv_std_logic_vector(9591286,24);
            manlo <= conv_std_logic_vector(150061692,28);
           exponent <= '0';
      WHEN "0111010000" =>
            manhi <= conv_std_logic_vector(9617049,24);
            manlo <= conv_std_logic_vector(168410880,28);
           exponent <= '0';
      WHEN "0111010001" =>
            manhi <= conv_std_logic_vector(9642837,24);
            manlo <= conv_std_logic_vector(232806206,28);
           exponent <= '0';
      WHEN "0111010010" =>
            manhi <= conv_std_logic_vector(9668651,24);
            manlo <= conv_std_logic_vector(81414002,28);
           exponent <= '0';
      WHEN "0111010011" =>
            manhi <= conv_std_logic_vector(9694489,24);
            manlo <= conv_std_logic_vector(257713424,28);
           exponent <= '0';
      WHEN "0111010100" =>
            manhi <= conv_std_logic_vector(9720353,24);
            manlo <= conv_std_logic_vector(231448253,28);
           exponent <= '0';
      WHEN "0111010101" =>
            manhi <= conv_std_logic_vector(9746243,24);
            manlo <= conv_std_logic_vector(9239650,28);
           exponent <= '0';
      WHEN "0111010110" =>
            manhi <= conv_std_logic_vector(9772157,24);
            manlo <= conv_std_logic_vector(134586155,28);
           exponent <= '0';
      WHEN "0111010111" =>
            manhi <= conv_std_logic_vector(9798097,24);
            manlo <= conv_std_logic_vector(77250961,28);
           exponent <= '0';
      WHEN "0111011000" =>
            manhi <= conv_std_logic_vector(9824062,24);
            manlo <= conv_std_logic_vector(112310110,28);
           exponent <= '0';
      WHEN "0111011001" =>
            manhi <= conv_std_logic_vector(9850052,24);
            manlo <= conv_std_logic_vector(246410674,28);
           exponent <= '0';
      WHEN "0111011010" =>
            manhi <= conv_std_logic_vector(9876068,24);
            manlo <= conv_std_logic_vector(217770768,28);
           exponent <= '0';
      WHEN "0111011011" =>
            manhi <= conv_std_logic_vector(9902110,24);
            manlo <= conv_std_logic_vector(33050459,28);
           exponent <= '0';
      WHEN "0111011100" =>
            manhi <= conv_std_logic_vector(9928176,24);
            manlo <= conv_std_logic_vector(235787236,28);
           exponent <= '0';
      WHEN "0111011101" =>
            manhi <= conv_std_logic_vector(9954269,24);
            manlo <= conv_std_logic_vector(27347822,28);
           exponent <= '0';
      WHEN "0111011110" =>
            manhi <= conv_std_logic_vector(9980386,24);
            manlo <= conv_std_logic_vector(219718194,28);
           exponent <= '0';
      WHEN "0111011111" =>
            manhi <= conv_std_logic_vector(10006530,24);
            manlo <= conv_std_logic_vector(14278120,28);
           exponent <= '0';
      WHEN "0111100000" =>
            manhi <= conv_std_logic_vector(10032698,24);
            manlo <= conv_std_logic_vector(223026636,28);
           exponent <= '0';
      WHEN "0111100001" =>
            manhi <= conv_std_logic_vector(10058893,24);
            manlo <= conv_std_logic_vector(47356582,28);
           exponent <= '0';
      WHEN "0111100010" =>
            manhi <= conv_std_logic_vector(10085113,24);
            manlo <= conv_std_logic_vector(30844624,28);
           exponent <= '0';
      WHEN "0111100011" =>
            manhi <= conv_std_logic_vector(10111358,24);
            manlo <= conv_std_logic_vector(180203065,28);
           exponent <= '0';
      WHEN "0111100100" =>
            manhi <= conv_std_logic_vector(10137629,24);
            manlo <= conv_std_logic_vector(233715314,28);
           exponent <= '0';
      WHEN "0111100101" =>
            manhi <= conv_std_logic_vector(10163926,24);
            manlo <= conv_std_logic_vector(198106796,28);
           exponent <= '0';
      WHEN "0111100110" =>
            manhi <= conv_std_logic_vector(10190249,24);
            manlo <= conv_std_logic_vector(80109512,28);
           exponent <= '0';
      WHEN "0111100111" =>
            manhi <= conv_std_logic_vector(10216597,24);
            manlo <= conv_std_logic_vector(154897493,28);
           exponent <= '0';
      WHEN "0111101000" =>
            manhi <= conv_std_logic_vector(10242971,24);
            manlo <= conv_std_logic_vector(160780443,28);
           exponent <= '0';
      WHEN "0111101001" =>
            manhi <= conv_std_logic_vector(10269371,24);
            manlo <= conv_std_logic_vector(104510112,28);
           exponent <= '0';
      WHEN "0111101010" =>
            manhi <= conv_std_logic_vector(10295796,24);
            manlo <= conv_std_logic_vector(261280303,28);
           exponent <= '0';
      WHEN "0111101011" =>
            manhi <= conv_std_logic_vector(10322248,24);
            manlo <= conv_std_logic_vector(100985054,28);
           exponent <= '0';
      WHEN "0111101100" =>
            manhi <= conv_std_logic_vector(10348725,24);
            manlo <= conv_std_logic_vector(167266836,28);
           exponent <= '0';
      WHEN "0111101101" =>
            manhi <= conv_std_logic_vector(10375228,24);
            manlo <= conv_std_logic_vector(198468370,28);
           exponent <= '0';
      WHEN "0111101110" =>
            manhi <= conv_std_logic_vector(10401757,24);
            manlo <= conv_std_logic_vector(201374454,28);
           exponent <= '0';
      WHEN "0111101111" =>
            manhi <= conv_std_logic_vector(10428312,24);
            manlo <= conv_std_logic_vector(182776514,28);
           exponent <= '0';
      WHEN "0111110000" =>
            manhi <= conv_std_logic_vector(10454893,24);
            manlo <= conv_std_logic_vector(149472614,28);
           exponent <= '0';
      WHEN "0111110001" =>
            manhi <= conv_std_logic_vector(10481500,24);
            manlo <= conv_std_logic_vector(108267459,28);
           exponent <= '0';
      WHEN "0111110010" =>
            manhi <= conv_std_logic_vector(10508133,24);
            manlo <= conv_std_logic_vector(65972402,28);
           exponent <= '0';
      WHEN "0111110011" =>
            manhi <= conv_std_logic_vector(10534792,24);
            manlo <= conv_std_logic_vector(29405451,28);
           exponent <= '0';
      WHEN "0111110100" =>
            manhi <= conv_std_logic_vector(10561477,24);
            manlo <= conv_std_logic_vector(5391275,28);
           exponent <= '0';
      WHEN "0111110101" =>
            manhi <= conv_std_logic_vector(10588188,24);
            manlo <= conv_std_logic_vector(761213,28);
           exponent <= '0';
      WHEN "0111110110" =>
            manhi <= conv_std_logic_vector(10614925,24);
            manlo <= conv_std_logic_vector(22353276,28);
           exponent <= '0';
      WHEN "0111110111" =>
            manhi <= conv_std_logic_vector(10641688,24);
            manlo <= conv_std_logic_vector(77012158,28);
           exponent <= '0';
      WHEN "0111111000" =>
            manhi <= conv_std_logic_vector(10668477,24);
            manlo <= conv_std_logic_vector(171589240,28);
           exponent <= '0';
      WHEN "0111111001" =>
            manhi <= conv_std_logic_vector(10695293,24);
            manlo <= conv_std_logic_vector(44507139,28);
           exponent <= '0';
      WHEN "0111111010" =>
            manhi <= conv_std_logic_vector(10722134,24);
            manlo <= conv_std_logic_vector(239501544,28);
           exponent <= '0';
      WHEN "0111111011" =>
            manhi <= conv_std_logic_vector(10749002,24);
            manlo <= conv_std_logic_vector(226573024,28);
           exponent <= '0';
      WHEN "0111111100" =>
            manhi <= conv_std_logic_vector(10775897,24);
            manlo <= conv_std_logic_vector(12599777,28);
           exponent <= '0';
      WHEN "0111111101" =>
            manhi <= conv_std_logic_vector(10802817,24);
            manlo <= conv_std_logic_vector(141337630,28);
           exponent <= '0';
      WHEN "0111111110" =>
            manhi <= conv_std_logic_vector(10829764,24);
            manlo <= conv_std_logic_vector(82807315,28);
           exponent <= '0';
      WHEN "0111111111" =>
            manhi <= conv_std_logic_vector(10856737,24);
            manlo <= conv_std_logic_vector(112342665,28);
           exponent <= '0';
      WHEN "1000000000" =>
            manhi <= conv_std_logic_vector(10883736,24);
            manlo <= conv_std_logic_vector(236848796,28);
           exponent <= '0';
      WHEN "1000000001" =>
            manhi <= conv_std_logic_vector(10910762,24);
            manlo <= conv_std_logic_vector(194802116,28);
           exponent <= '0';
      WHEN "1000000010" =>
            manhi <= conv_std_logic_vector(10937814,24);
            manlo <= conv_std_logic_vector(261556696,28);
           exponent <= '0';
      WHEN "1000000011" =>
            manhi <= conv_std_logic_vector(10964893,24);
            manlo <= conv_std_logic_vector(175602458,28);
           exponent <= '0';
      WHEN "1000000100" =>
            manhi <= conv_std_logic_vector(10991998,24);
            manlo <= conv_std_logic_vector(212307000,28);
           exponent <= '0';
      WHEN "1000000101" =>
            manhi <= conv_std_logic_vector(11019130,24);
            manlo <= conv_std_logic_vector(110173782,28);
           exponent <= '0';
      WHEN "1000000110" =>
            manhi <= conv_std_logic_vector(11046288,24);
            manlo <= conv_std_logic_vector(144583954,28);
           exponent <= '0';
      WHEN "1000000111" =>
            manhi <= conv_std_logic_vector(11073473,24);
            manlo <= conv_std_logic_vector(54054542,28);
           exponent <= '0';
      WHEN "1000001000" =>
            manhi <= conv_std_logic_vector(11100684,24);
            manlo <= conv_std_logic_vector(113980276,28);
           exponent <= '0';
      WHEN "1000001001" =>
            manhi <= conv_std_logic_vector(11127922,24);
            manlo <= conv_std_logic_vector(62891774,28);
           exponent <= '0';
      WHEN "1000001010" =>
            manhi <= conv_std_logic_vector(11155186,24);
            manlo <= conv_std_logic_vector(176197372,28);
           exponent <= '0';
      WHEN "1000001011" =>
            manhi <= conv_std_logic_vector(11182477,24);
            manlo <= conv_std_logic_vector(192441306,28);
           exponent <= '0';
      WHEN "1000001100" =>
            manhi <= conv_std_logic_vector(11209795,24);
            manlo <= conv_std_logic_vector(118610088,28);
           exponent <= '0';
      WHEN "1000001101" =>
            manhi <= conv_std_logic_vector(11237139,24);
            manlo <= conv_std_logic_vector(230132514,28);
           exponent <= '0';
      WHEN "1000001110" =>
            manhi <= conv_std_logic_vector(11264510,24);
            manlo <= conv_std_logic_vector(265573296,28);
           exponent <= '0';
      WHEN "1000001111" =>
            manhi <= conv_std_logic_vector(11291908,24);
            manlo <= conv_std_logic_vector(231939446,28);
           exponent <= '0';
      WHEN "1000010000" =>
            manhi <= conv_std_logic_vector(11319333,24);
            manlo <= conv_std_logic_vector(136244820,28);
           exponent <= '0';
      WHEN "1000010001" =>
            manhi <= conv_std_logic_vector(11346784,24);
            manlo <= conv_std_logic_vector(253945584,28);
           exponent <= '0';
      WHEN "1000010010" =>
            manhi <= conv_std_logic_vector(11374263,24);
            manlo <= conv_std_logic_vector(55198395,28);
           exponent <= '0';
      WHEN "1000010011" =>
            manhi <= conv_std_logic_vector(11401768,24);
            manlo <= conv_std_logic_vector(83908598,28);
           exponent <= '0';
      WHEN "1000010100" =>
            manhi <= conv_std_logic_vector(11429300,24);
            manlo <= conv_std_logic_vector(78682048,28);
           exponent <= '0';
      WHEN "1000010101" =>
            manhi <= conv_std_logic_vector(11456859,24);
            manlo <= conv_std_logic_vector(46566930,28);
           exponent <= '0';
      WHEN "1000010110" =>
            manhi <= conv_std_logic_vector(11484444,24);
            manlo <= conv_std_logic_vector(263053774,28);
           exponent <= '0';
      WHEN "1000010111" =>
            manhi <= conv_std_logic_vector(11512057,24);
            manlo <= conv_std_logic_vector(198333637,28);
           exponent <= '0';
      WHEN "1000011000" =>
            manhi <= conv_std_logic_vector(11539697,24);
            manlo <= conv_std_logic_vector(127910840,28);
           exponent <= '0';
      WHEN "1000011001" =>
            manhi <= conv_std_logic_vector(11567364,24);
            manlo <= conv_std_logic_vector(58861158,28);
           exponent <= '0';
      WHEN "1000011010" =>
            manhi <= conv_std_logic_vector(11595057,24);
            manlo <= conv_std_logic_vector(266702732,28);
           exponent <= '0';
      WHEN "1000011011" =>
            manhi <= conv_std_logic_vector(11622778,24);
            manlo <= conv_std_logic_vector(221654258,28);
           exponent <= '0';
      WHEN "1000011100" =>
            manhi <= conv_std_logic_vector(11650526,24);
            manlo <= conv_std_logic_vector(199247725,28);
           exponent <= '0';
      WHEN "1000011101" =>
            manhi <= conv_std_logic_vector(11678301,24);
            manlo <= conv_std_logic_vector(206586600,28);
           exponent <= '0';
      WHEN "1000011110" =>
            manhi <= conv_std_logic_vector(11706103,24);
            manlo <= conv_std_logic_vector(250781292,28);
           exponent <= '0';
      WHEN "1000011111" =>
            manhi <= conv_std_logic_vector(11733933,24);
            manlo <= conv_std_logic_vector(70513697,28);
           exponent <= '0';
      WHEN "1000100000" =>
            manhi <= conv_std_logic_vector(11761789,24);
            manlo <= conv_std_logic_vector(209779039,28);
           exponent <= '0';
      WHEN "1000100001" =>
            manhi <= conv_std_logic_vector(11789673,24);
            manlo <= conv_std_logic_vector(138837672,28);
           exponent <= '0';
      WHEN "1000100010" =>
            manhi <= conv_std_logic_vector(11817584,24);
            manlo <= conv_std_logic_vector(133263292,28);
           exponent <= '0';
      WHEN "1000100011" =>
            manhi <= conv_std_logic_vector(11845522,24);
            manlo <= conv_std_logic_vector(200201109,28);
           exponent <= '0';
      WHEN "1000100100" =>
            manhi <= conv_std_logic_vector(11873488,24);
            manlo <= conv_std_logic_vector(78367858,28);
           exponent <= '0';
      WHEN "1000100101" =>
            manhi <= conv_std_logic_vector(11901481,24);
            manlo <= conv_std_logic_vector(43358178,28);
           exponent <= '0';
      WHEN "1000100110" =>
            manhi <= conv_std_logic_vector(11929501,24);
            manlo <= conv_std_logic_vector(102338242,28);
           exponent <= '0';
      WHEN "1000100111" =>
            manhi <= conv_std_logic_vector(11957548,24);
            manlo <= conv_std_logic_vector(262481228,28);
           exponent <= '0';
      WHEN "1000101000" =>
            manhi <= conv_std_logic_vector(11985623,24);
            manlo <= conv_std_logic_vector(262531864,28);
           exponent <= '0';
      WHEN "1000101001" =>
            manhi <= conv_std_logic_vector(12013726,24);
            manlo <= conv_std_logic_vector(109677352,28);
           exponent <= '0';
      WHEN "1000101010" =>
            manhi <= conv_std_logic_vector(12041856,24);
            manlo <= conv_std_logic_vector(79547371,28);
           exponent <= '0';
      WHEN "1000101011" =>
            manhi <= conv_std_logic_vector(12070013,24);
            manlo <= conv_std_logic_vector(179343172,28);
           exponent <= '0';
      WHEN "1000101100" =>
            manhi <= conv_std_logic_vector(12098198,24);
            manlo <= conv_std_logic_vector(147837587,28);
           exponent <= '0';
      WHEN "1000101101" =>
            manhi <= conv_std_logic_vector(12126410,24);
            manlo <= conv_std_logic_vector(260681402,28);
           exponent <= '0';
      WHEN "1000101110" =>
            manhi <= conv_std_logic_vector(12154650,24);
            manlo <= conv_std_logic_vector(256661542,28);
           exponent <= '0';
      WHEN "1000101111" =>
            manhi <= conv_std_logic_vector(12182918,24);
            manlo <= conv_std_logic_vector(143007443,28);
           exponent <= '0';
      WHEN "1000110000" =>
            manhi <= conv_std_logic_vector(12211213,24);
            manlo <= conv_std_logic_vector(195391062,28);
           exponent <= '0';
      WHEN "1000110001" =>
            manhi <= conv_std_logic_vector(12239536,24);
            manlo <= conv_std_logic_vector(152620513,28);
           exponent <= '0';
      WHEN "1000110010" =>
            manhi <= conv_std_logic_vector(12267887,24);
            manlo <= conv_std_logic_vector(21946444,28);
           exponent <= '0';
      WHEN "1000110011" =>
            manhi <= conv_std_logic_vector(12296265,24);
            manlo <= conv_std_logic_vector(79062042,28);
           exponent <= '0';
      WHEN "1000110100" =>
            manhi <= conv_std_logic_vector(12324671,24);
            manlo <= conv_std_logic_vector(62796676,28);
           exponent <= '0';
      WHEN "1000110101" =>
            manhi <= conv_std_logic_vector(12353104,24);
            manlo <= conv_std_logic_vector(248857722,28);
           exponent <= '0';
      WHEN "1000110110" =>
            manhi <= conv_std_logic_vector(12381566,24);
            manlo <= conv_std_logic_vector(107653293,28);
           exponent <= '0';
      WHEN "1000110111" =>
            manhi <= conv_std_logic_vector(12410055,24);
            manlo <= conv_std_logic_vector(183340440,28);
           exponent <= '0';
      WHEN "1000111000" =>
            manhi <= conv_std_logic_vector(12438572,24);
            manlo <= conv_std_logic_vector(214776964,28);
           exponent <= '0';
      WHEN "1000111001" =>
            manhi <= conv_std_logic_vector(12467117,24);
            manlo <= conv_std_logic_vector(209263248,28);
           exponent <= '0';
      WHEN "1000111010" =>
            manhi <= conv_std_logic_vector(12495690,24);
            manlo <= conv_std_logic_vector(174106806,28);
           exponent <= '0';
      WHEN "1000111011" =>
            manhi <= conv_std_logic_vector(12524291,24);
            manlo <= conv_std_logic_vector(116622293,28);
           exponent <= '0';
      WHEN "1000111100" =>
            manhi <= conv_std_logic_vector(12552920,24);
            manlo <= conv_std_logic_vector(44131512,28);
           exponent <= '0';
      WHEN "1000111101" =>
            manhi <= conv_std_logic_vector(12581576,24);
            manlo <= conv_std_logic_vector(232398874,28);
           exponent <= '0';
      WHEN "1000111110" =>
            manhi <= conv_std_logic_vector(12610261,24);
            manlo <= conv_std_logic_vector(151889582,28);
           exponent <= '0';
      WHEN "1000111111" =>
            manhi <= conv_std_logic_vector(12638974,24);
            manlo <= conv_std_logic_vector(78382378,28);
           exponent <= '0';
      WHEN "1001000000" =>
            manhi <= conv_std_logic_vector(12667715,24);
            manlo <= conv_std_logic_vector(19227718,28);
           exponent <= '0';
      WHEN "1001000001" =>
            manhi <= conv_std_logic_vector(12696483,24);
            manlo <= conv_std_logic_vector(250218700,28);
           exponent <= '0';
      WHEN "1001000010" =>
            manhi <= conv_std_logic_vector(12725280,24);
            manlo <= conv_std_logic_vector(241849240,28);
           exponent <= '0';
      WHEN "1001000011" =>
            manhi <= conv_std_logic_vector(12754106,24);
            manlo <= conv_std_logic_vector(1491364,28);
           exponent <= '0';
      WHEN "1001000100" =>
            manhi <= conv_std_logic_vector(12782959,24);
            manlo <= conv_std_logic_vector(73395209,28);
           exponent <= '0';
      WHEN "1001000101" =>
            manhi <= conv_std_logic_vector(12811840,24);
            manlo <= conv_std_logic_vector(196511758,28);
           exponent <= '0';
      WHEN "1001000110" =>
            manhi <= conv_std_logic_vector(12840750,24);
            manlo <= conv_std_logic_vector(109799208,28);
           exponent <= '0';
      WHEN "1001000111" =>
            manhi <= conv_std_logic_vector(12869688,24);
            manlo <= conv_std_logic_vector(89093893,28);
           exponent <= '0';
      WHEN "1001001000" =>
            manhi <= conv_std_logic_vector(12898654,24);
            manlo <= conv_std_logic_vector(141803923,28);
           exponent <= '0';
      WHEN "1001001001" =>
            manhi <= conv_std_logic_vector(12927649,24);
            manlo <= conv_std_logic_vector(6909187,28);
           exponent <= '0';
      WHEN "1001001010" =>
            manhi <= conv_std_logic_vector(12956671,24);
            manlo <= conv_std_logic_vector(228703191,28);
           exponent <= '0';
      WHEN "1001001011" =>
            manhi <= conv_std_logic_vector(12985723,24);
            manlo <= conv_std_logic_vector(9309409,28);
           exponent <= '0';
      WHEN "1001001100" =>
            manhi <= conv_std_logic_vector(13014802,24);
            manlo <= conv_std_logic_vector(161471314,28);
           exponent <= '0';
      WHEN "1001001101" =>
            manhi <= conv_std_logic_vector(13043910,24);
            manlo <= conv_std_logic_vector(155762363,28);
           exponent <= '0';
      WHEN "1001001110" =>
            manhi <= conv_std_logic_vector(13073046,24);
            manlo <= conv_std_logic_vector(268069656,28);
           exponent <= '0';
      WHEN "1001001111" =>
            manhi <= conv_std_logic_vector(13102211,24);
            manlo <= conv_std_logic_vector(237416659,28);
           exponent <= '0';
      WHEN "1001010000" =>
            manhi <= conv_std_logic_vector(13131405,24);
            manlo <= conv_std_logic_vector(71269584,28);
           exponent <= '0';
      WHEN "1001010001" =>
            manhi <= conv_std_logic_vector(13160627,24);
            manlo <= conv_std_logic_vector(45537394,28);
           exponent <= '0';
      WHEN "1001010010" =>
            manhi <= conv_std_logic_vector(13189877,24);
            manlo <= conv_std_logic_vector(167700897,28);
           exponent <= '0';
      WHEN "1001010011" =>
            manhi <= conv_std_logic_vector(13219156,24);
            manlo <= conv_std_logic_vector(176812753,28);
           exponent <= '0';
      WHEN "1001010100" =>
            manhi <= conv_std_logic_vector(13248464,24);
            manlo <= conv_std_logic_vector(80368396,28);
           exponent <= '0';
      WHEN "1001010101" =>
            manhi <= conv_std_logic_vector(13277800,24);
            manlo <= conv_std_logic_vector(154306039,28);
           exponent <= '0';
      WHEN "1001010110" =>
            manhi <= conv_std_logic_vector(13307165,24);
            manlo <= conv_std_logic_vector(137700312,28);
           exponent <= '0';
      WHEN "1001010111" =>
            manhi <= conv_std_logic_vector(13336559,24);
            manlo <= conv_std_logic_vector(38068641,28);
           exponent <= '0';
      WHEN "1001011000" =>
            manhi <= conv_std_logic_vector(13365981,24);
            manlo <= conv_std_logic_vector(131371250,28);
           exponent <= '0';
      WHEN "1001011001" =>
            manhi <= conv_std_logic_vector(13395432,24);
            manlo <= conv_std_logic_vector(156704806,28);
           exponent <= '0';
      WHEN "1001011010" =>
            manhi <= conv_std_logic_vector(13424912,24);
            manlo <= conv_std_logic_vector(121608790,28);
           exponent <= '0';
      WHEN "1001011011" =>
            manhi <= conv_std_logic_vector(13454421,24);
            manlo <= conv_std_logic_vector(33630048,28);
           exponent <= '0';
      WHEN "1001011100" =>
            manhi <= conv_std_logic_vector(13483958,24);
            manlo <= conv_std_logic_vector(168758257,28);
           exponent <= '0';
      WHEN "1001011101" =>
            manhi <= conv_std_logic_vector(13513524,24);
            manlo <= conv_std_logic_vector(266119562,28);
           exponent <= '0';
      WHEN "1001011110" =>
            manhi <= conv_std_logic_vector(13543120,24);
            manlo <= conv_std_logic_vector(64847498,28);
           exponent <= '0';
      WHEN "1001011111" =>
            manhi <= conv_std_logic_vector(13572744,24);
            manlo <= conv_std_logic_vector(109389360,28);
           exponent <= '0';
      WHEN "1001100000" =>
            manhi <= conv_std_logic_vector(13602397,24);
            manlo <= conv_std_logic_vector(138893481,28);
           exponent <= '0';
      WHEN "1001100001" =>
            manhi <= conv_std_logic_vector(13632079,24);
            manlo <= conv_std_logic_vector(160951056,28);
           exponent <= '0';
      WHEN "1001100010" =>
            manhi <= conv_std_logic_vector(13661790,24);
            manlo <= conv_std_logic_vector(183160698,28);
           exponent <= '0';
      WHEN "1001100011" =>
            manhi <= conv_std_logic_vector(13691530,24);
            manlo <= conv_std_logic_vector(213128447,28);
           exponent <= '0';
      WHEN "1001100100" =>
            manhi <= conv_std_logic_vector(13721299,24);
            manlo <= conv_std_logic_vector(258467771,28);
           exponent <= '0';
      WHEN "1001100101" =>
            manhi <= conv_std_logic_vector(13751098,24);
            manlo <= conv_std_logic_vector(58364122,28);
           exponent <= '0';
      WHEN "1001100110" =>
            manhi <= conv_std_logic_vector(13780925,24);
            manlo <= conv_std_logic_vector(157316766,28);
           exponent <= '0';
      WHEN "1001100111" =>
            manhi <= conv_std_logic_vector(13810782,24);
            manlo <= conv_std_logic_vector(26090597,28);
           exponent <= '0';
      WHEN "1001101000" =>
            manhi <= conv_std_logic_vector(13840667,24);
            manlo <= conv_std_logic_vector(209199796,28);
           exponent <= '0';
      WHEN "1001101001" =>
            manhi <= conv_std_logic_vector(13870582,24);
            manlo <= conv_std_logic_vector(177424185,28);
           exponent <= '0';
      WHEN "1001101010" =>
            manhi <= conv_std_logic_vector(13900526,24);
            manlo <= conv_std_logic_vector(206857431,28);
           exponent <= '0';
      WHEN "1001101011" =>
            manhi <= conv_std_logic_vector(13930500,24);
            manlo <= conv_std_logic_vector(36729770,28);
           exponent <= '0';
      WHEN "1001101100" =>
            manhi <= conv_std_logic_vector(13960502,24);
            manlo <= conv_std_logic_vector(211585297,28);
           exponent <= '0';
      WHEN "1001101101" =>
            manhi <= conv_std_logic_vector(13990534,24);
            manlo <= conv_std_logic_vector(202233780,28);
           exponent <= '0';
      WHEN "1001101110" =>
            manhi <= conv_std_logic_vector(14020596,24);
            manlo <= conv_std_logic_vector(16363400,28);
           exponent <= '0';
      WHEN "1001101111" =>
            manhi <= conv_std_logic_vector(14050686,24);
            manlo <= conv_std_logic_vector(198540768,28);
           exponent <= '0';
      WHEN "1001110000" =>
            manhi <= conv_std_logic_vector(14080806,24);
            manlo <= conv_std_logic_vector(219598184,28);
           exponent <= '0';
      WHEN "1001110001" =>
            manhi <= conv_std_logic_vector(14110956,24);
            manlo <= conv_std_logic_vector(87246388,28);
           exponent <= '0';
      WHEN "1001110010" =>
            manhi <= conv_std_logic_vector(14141135,24);
            manlo <= conv_std_logic_vector(77639113,28);
           exponent <= '0';
      WHEN "1001110011" =>
            manhi <= conv_std_logic_vector(14171343,24);
            manlo <= conv_std_logic_vector(198502173,28);
           exponent <= '0';
      WHEN "1001110100" =>
            manhi <= conv_std_logic_vector(14201581,24);
            manlo <= conv_std_logic_vector(189133475,28);
           exponent <= '0';
      WHEN "1001110101" =>
            manhi <= conv_std_logic_vector(14231849,24);
            manlo <= conv_std_logic_vector(57273941,28);
           exponent <= '0';
      WHEN "1001110110" =>
            manhi <= conv_std_logic_vector(14262146,24);
            manlo <= conv_std_logic_vector(79107508,28);
           exponent <= '0';
      WHEN "1001110111" =>
            manhi <= conv_std_logic_vector(14292472,24);
            manlo <= conv_std_logic_vector(262390229,28);
           exponent <= '0';
      WHEN "1001111000" =>
            manhi <= conv_std_logic_vector(14322829,24);
            manlo <= conv_std_logic_vector(78014825,28);
           exponent <= '0';
      WHEN "1001111001" =>
            manhi <= conv_std_logic_vector(14353215,24);
            manlo <= conv_std_logic_vector(70623424,28);
           exponent <= '0';
      WHEN "1001111010" =>
            manhi <= conv_std_logic_vector(14383630,24);
            manlo <= conv_std_logic_vector(247994836,28);
           exponent <= '0';
      WHEN "1001111011" =>
            manhi <= conv_std_logic_vector(14414076,24);
            manlo <= conv_std_logic_vector(81044559,28);
           exponent <= '0';
      WHEN "1001111100" =>
            manhi <= conv_std_logic_vector(14444551,24);
            manlo <= conv_std_logic_vector(114437521,28);
           exponent <= '0';
      WHEN "1001111101" =>
            manhi <= conv_std_logic_vector(14475056,24);
            manlo <= conv_std_logic_vector(87539900,28);
           exponent <= '0';
      WHEN "1001111110" =>
            manhi <= conv_std_logic_vector(14505591,24);
            manlo <= conv_std_logic_vector(8160950,28);
           exponent <= '0';
      WHEN "1001111111" =>
            manhi <= conv_std_logic_vector(14536155,24);
            manlo <= conv_std_logic_vector(152553012,28);
           exponent <= '0';
      WHEN "1010000000" =>
            manhi <= conv_std_logic_vector(14566749,24);
            manlo <= conv_std_logic_vector(260105152,28);
           exponent <= '0';
      WHEN "1010000001" =>
            manhi <= conv_std_logic_vector(14597374,24);
            manlo <= conv_std_logic_vector(70214083,28);
           exponent <= '0';
      WHEN "1010000010" =>
            manhi <= conv_std_logic_vector(14628028,24);
            manlo <= conv_std_logic_vector(127590534,28);
           exponent <= '0';
      WHEN "1010000011" =>
            manhi <= conv_std_logic_vector(14658712,24);
            manlo <= conv_std_logic_vector(171646531,28);
           exponent <= '0';
      WHEN "1010000100" =>
            manhi <= conv_std_logic_vector(14689426,24);
            manlo <= conv_std_logic_vector(210237219,28);
           exponent <= '0';
      WHEN "1010000101" =>
            manhi <= conv_std_logic_vector(14720170,24);
            manlo <= conv_std_logic_vector(251225419,28);
           exponent <= '0';
      WHEN "1010000110" =>
            manhi <= conv_std_logic_vector(14750945,24);
            manlo <= conv_std_logic_vector(34046180,28);
           exponent <= '0';
      WHEN "1010000111" =>
            manhi <= conv_std_logic_vector(14781749,24);
            manlo <= conv_std_logic_vector(103448606,28);
           exponent <= '0';
      WHEN "1010001000" =>
            manhi <= conv_std_logic_vector(14812583,24);
            manlo <= conv_std_logic_vector(198883134,28);
           exponent <= '0';
      WHEN "1010001001" =>
            manhi <= conv_std_logic_vector(14843448,24);
            manlo <= conv_std_logic_vector(59807901,28);
           exponent <= '0';
      WHEN "1010001010" =>
            manhi <= conv_std_logic_vector(14874342,24);
            manlo <= conv_std_logic_vector(230995129,28);
           exponent <= '0';
      WHEN "1010001011" =>
            manhi <= conv_std_logic_vector(14905267,24);
            manlo <= conv_std_logic_vector(183482934,28);
           exponent <= '0';
      WHEN "1010001100" =>
            manhi <= conv_std_logic_vector(14936222,24);
            manlo <= conv_std_logic_vector(193623526,28);
           exponent <= '0';
      WHEN "1010001101" =>
            manhi <= conv_std_logic_vector(14967208,24);
            manlo <= conv_std_logic_vector(905939,28);
           exponent <= '0';
      WHEN "1010001110" =>
            manhi <= conv_std_logic_vector(14998223,24);
            manlo <= conv_std_logic_vector(150133320,28);
           exponent <= '0';
      WHEN "1010001111" =>
            manhi <= conv_std_logic_vector(15029269,24);
            manlo <= conv_std_logic_vector(112374738,28);
           exponent <= '0';
      WHEN "1010010000" =>
            manhi <= conv_std_logic_vector(15060345,24);
            manlo <= conv_std_logic_vector(164013390,28);
           exponent <= '0';
      WHEN "1010010001" =>
            manhi <= conv_std_logic_vector(15091452,24);
            manlo <= conv_std_logic_vector(44569327,28);
           exponent <= '0';
      WHEN "1010010010" =>
            manhi <= conv_std_logic_vector(15122589,24);
            manlo <= conv_std_logic_vector(30441282,28);
           exponent <= '0';
      WHEN "1010010011" =>
            manhi <= conv_std_logic_vector(15153756,24);
            manlo <= conv_std_logic_vector(129600316,28);
           exponent <= '0';
      WHEN "1010010100" =>
            manhi <= conv_std_logic_vector(15184954,24);
            manlo <= conv_std_logic_vector(81589818,28);
           exponent <= '0';
      WHEN "1010010101" =>
            manhi <= conv_std_logic_vector(15216182,24);
            manlo <= conv_std_logic_vector(162831889,28);
           exponent <= '0';
      WHEN "1010010110" =>
            manhi <= conv_std_logic_vector(15247441,24);
            manlo <= conv_std_logic_vector(112885518,28);
           exponent <= '0';
      WHEN "1010010111" =>
            manhi <= conv_std_logic_vector(15278730,24);
            manlo <= conv_std_logic_vector(208188418,28);
           exponent <= '0';
      WHEN "1010011000" =>
            manhi <= conv_std_logic_vector(15310050,24);
            manlo <= conv_std_logic_vector(188315209,28);
           exponent <= '0';
      WHEN "1010011001" =>
            manhi <= conv_std_logic_vector(15341401,24);
            manlo <= conv_std_logic_vector(61283792,28);
           exponent <= '0';
      WHEN "1010011010" =>
            manhi <= conv_std_logic_vector(15372782,24);
            manlo <= conv_std_logic_vector(103555359,28);
           exponent <= '0';
      WHEN "1010011011" =>
            manhi <= conv_std_logic_vector(15404194,24);
            manlo <= conv_std_logic_vector(54728032,28);
           exponent <= '0';
      WHEN "1010011100" =>
            manhi <= conv_std_logic_vector(15435636,24);
            manlo <= conv_std_logic_vector(191278690,28);
           exponent <= '0';
      WHEN "1010011101" =>
            manhi <= conv_std_logic_vector(15467109,24);
            manlo <= conv_std_logic_vector(252821163,28);
           exponent <= '0';
      WHEN "1010011110" =>
            manhi <= conv_std_logic_vector(15498613,24);
            manlo <= conv_std_logic_vector(247412597,28);
           exponent <= '0';
      WHEN "1010011111" =>
            manhi <= conv_std_logic_vector(15530148,24);
            manlo <= conv_std_logic_vector(183118012,28);
           exponent <= '0';
      WHEN "1010100000" =>
            manhi <= conv_std_logic_vector(15561714,24);
            manlo <= conv_std_logic_vector(68010306,28);
           exponent <= '0';
      WHEN "1010100001" =>
            manhi <= conv_std_logic_vector(15593310,24);
            manlo <= conv_std_logic_vector(178605723,28);
           exponent <= '0';
      WHEN "1010100010" =>
            manhi <= conv_std_logic_vector(15624937,24);
            manlo <= conv_std_logic_vector(254557489,28);
           exponent <= '0';
      WHEN "1010100011" =>
            manhi <= conv_std_logic_vector(15656596,24);
            manlo <= conv_std_logic_vector(35526733,28);
           exponent <= '0';
      WHEN "1010100100" =>
            manhi <= conv_std_logic_vector(15688285,24);
            manlo <= conv_std_logic_vector(66488863,28);
           exponent <= '0';
      WHEN "1010100101" =>
            manhi <= conv_std_logic_vector(15720005,24);
            manlo <= conv_std_logic_vector(87120837,28);
           exponent <= '0';
      WHEN "1010100110" =>
            manhi <= conv_std_logic_vector(15751756,24);
            manlo <= conv_std_logic_vector(105542995,28);
           exponent <= '0';
      WHEN "1010100111" =>
            manhi <= conv_std_logic_vector(15783538,24);
            manlo <= conv_std_logic_vector(129883612,28);
           exponent <= '0';
      WHEN "1010101000" =>
            manhi <= conv_std_logic_vector(15815351,24);
            manlo <= conv_std_logic_vector(168278902,28);
           exponent <= '0';
      WHEN "1010101001" =>
            manhi <= conv_std_logic_vector(15847195,24);
            manlo <= conv_std_logic_vector(228873033,28);
           exponent <= '0';
      WHEN "1010101010" =>
            manhi <= conv_std_logic_vector(15879071,24);
            manlo <= conv_std_logic_vector(51382669,28);
           exponent <= '0';
      WHEN "1010101011" =>
            manhi <= conv_std_logic_vector(15910977,24);
            manlo <= conv_std_logic_vector(180838811,28);
           exponent <= '0';
      WHEN "1010101100" =>
            manhi <= conv_std_logic_vector(15942915,24);
            manlo <= conv_std_logic_vector(88538606,28);
           exponent <= '0';
      WHEN "1010101101" =>
            manhi <= conv_std_logic_vector(15974884,24);
            manlo <= conv_std_logic_vector(51093552,28);
           exponent <= '0';
      WHEN "1010101110" =>
            manhi <= conv_std_logic_vector(16006884,24);
            manlo <= conv_std_logic_vector(76687676,28);
           exponent <= '0';
      WHEN "1010101111" =>
            manhi <= conv_std_logic_vector(16038915,24);
            manlo <= conv_std_logic_vector(173513005,28);
           exponent <= '0';
      WHEN "1010110000" =>
            manhi <= conv_std_logic_vector(16070978,24);
            manlo <= conv_std_logic_vector(81334110,28);
           exponent <= '0';
      WHEN "1010110001" =>
            manhi <= conv_std_logic_vector(16103072,24);
            manlo <= conv_std_logic_vector(76794490,28);
           exponent <= '0';
      WHEN "1010110010" =>
            manhi <= conv_std_logic_vector(16135197,24);
            manlo <= conv_std_logic_vector(168110204,28);
           exponent <= '0';
      WHEN "1010110011" =>
            manhi <= conv_std_logic_vector(16167354,24);
            manlo <= conv_std_logic_vector(95069884,28);
           exponent <= '0';
      WHEN "1010110100" =>
            manhi <= conv_std_logic_vector(16199542,24);
            manlo <= conv_std_logic_vector(134341108,28);
           exponent <= '0';
      WHEN "1010110101" =>
            manhi <= conv_std_logic_vector(16231762,24);
            manlo <= conv_std_logic_vector(25728588,28);
           exponent <= '0';
      WHEN "1010110110" =>
            manhi <= conv_std_logic_vector(16264013,24);
            manlo <= conv_std_logic_vector(45915996,28);
           exponent <= '0';
      WHEN "1010110111" =>
            manhi <= conv_std_logic_vector(16296295,24);
            manlo <= conv_std_logic_vector(203159607,28);
           exponent <= '0';
      WHEN "1010111000" =>
            manhi <= conv_std_logic_vector(16328609,24);
            manlo <= conv_std_logic_vector(237288310,28);
           exponent <= '0';
      WHEN "1010111001" =>
            manhi <= conv_std_logic_vector(16360955,24);
            manlo <= conv_std_logic_vector(156574520,28);
           exponent <= '0';
      WHEN "1010111010" =>
            manhi <= conv_std_logic_vector(16393332,24);
            manlo <= conv_std_logic_vector(237734194,28);
           exponent <= '0';
      WHEN "1010111011" =>
            manhi <= conv_std_logic_vector(16425741,24);
            manlo <= conv_std_logic_vector(220620465,28);
           exponent <= '0';
      WHEN "1010111100" =>
            manhi <= conv_std_logic_vector(16458182,24);
            manlo <= conv_std_logic_vector(113530022,28);
           exponent <= '0';
      WHEN "1010111101" =>
            manhi <= conv_std_logic_vector(16490654,24);
            manlo <= conv_std_logic_vector(193203116,28);
           exponent <= '0';
      WHEN "1010111110" =>
            manhi <= conv_std_logic_vector(16523158,24);
            manlo <= conv_std_logic_vector(199517199,28);
           exponent <= '0';
      WHEN "1010111111" =>
            manhi <= conv_std_logic_vector(16555694,24);
            manlo <= conv_std_logic_vector(140793302,28);
           exponent <= '0';
      WHEN "1011000000" =>
            manhi <= conv_std_logic_vector(16588262,24);
            manlo <= conv_std_logic_vector(25360585,28);
           exponent <= '0';
      WHEN "1011000001" =>
            manhi <= conv_std_logic_vector(16620861,24);
            manlo <= conv_std_logic_vector(129991803,28);
           exponent <= '0';
      WHEN "1011000010" =>
            manhi <= conv_std_logic_vector(16653492,24);
            manlo <= conv_std_logic_vector(194596944,28);
           exponent <= '0';
      WHEN "1011000011" =>
            manhi <= conv_std_logic_vector(16686155,24);
            manlo <= conv_std_logic_vector(227529607,28);
           exponent <= '0';
      WHEN "1011000100" =>
            manhi <= conv_std_logic_vector(16718850,24);
            manlo <= conv_std_logic_vector(237151552,28);
           exponent <= '0';
      WHEN "1011000101" =>
            manhi <= conv_std_logic_vector(16751577,24);
            manlo <= conv_std_logic_vector(231832709,28);
           exponent <= '0';
      WHEN "1011000110" =>
            manhi <= conv_std_logic_vector(3560,24);
            manlo <= conv_std_logic_vector(109975592,28);
           exponent <= '1';
      WHEN "1011000111" =>
            manhi <= conv_std_logic_vector(19955,24);
            manlo <= conv_std_logic_vector(239164365,28);
           exponent <= '1';
      WHEN "1011001000" =>
            manhi <= conv_std_logic_vector(36367,24);
            manlo <= conv_std_logic_vector(105026731,28);
           exponent <= '1';
      WHEN "1011001001" =>
            manhi <= conv_std_logic_vector(52794,24);
            manlo <= conv_std_logic_vector(248634947,28);
           exponent <= '1';
      WHEN "1011001010" =>
            manhi <= conv_std_logic_vector(69238,24);
            manlo <= conv_std_logic_vector(137323551,28);
           exponent <= '1';
      WHEN "1011001011" =>
            manhi <= conv_std_logic_vector(85698,24);
            manlo <= conv_std_logic_vector(43737556,28);
           exponent <= '1';
      WHEN "1011001100" =>
            manhi <= conv_std_logic_vector(102173,24);
            manlo <= conv_std_logic_vector(240526091,28);
           exponent <= '1';
      WHEN "1011001101" =>
            manhi <= conv_std_logic_vector(118665,24);
            manlo <= conv_std_logic_vector(195036030,28);
           exponent <= '1';
      WHEN "1011001110" =>
            manhi <= conv_std_logic_vector(135173,24);
            manlo <= conv_std_logic_vector(179924739,28);
           exponent <= '1';
      WHEN "1011001111" =>
            manhi <= conv_std_logic_vector(151697,24);
            manlo <= conv_std_logic_vector(199418251,28);
           exponent <= '1';
      WHEN "1011010000" =>
            manhi <= conv_std_logic_vector(168237,24);
            manlo <= conv_std_logic_vector(257746730,28);
           exponent <= '1';
      WHEN "1011010001" =>
            manhi <= conv_std_logic_vector(184794,24);
            manlo <= conv_std_logic_vector(90709016,28);
           exponent <= '1';
      WHEN "1011010010" =>
            manhi <= conv_std_logic_vector(201366,24);
            manlo <= conv_std_logic_vector(239414453,28);
           exponent <= '1';
      WHEN "1011010011" =>
            manhi <= conv_std_logic_vector(217955,24);
            manlo <= conv_std_logic_vector(171234704,28);
           exponent <= '1';
      WHEN "1011010100" =>
            manhi <= conv_std_logic_vector(234560,24);
            manlo <= conv_std_logic_vector(158851944,28);
           exponent <= '1';
      WHEN "1011010101" =>
            manhi <= conv_std_logic_vector(251181,24);
            manlo <= conv_std_logic_vector(206517042,28);
           exponent <= '1';
      WHEN "1011010110" =>
            manhi <= conv_std_logic_vector(267819,24);
            manlo <= conv_std_logic_vector(50049563,28);
           exponent <= '1';
      WHEN "1011010111" =>
            manhi <= conv_std_logic_vector(284472,24);
            manlo <= conv_std_logic_vector(230579599,28);
           exponent <= '1';
      WHEN "1011011000" =>
            manhi <= conv_std_logic_vector(301142,24);
            manlo <= conv_std_logic_vector(215499577,28);
           exponent <= '1';
      WHEN "1011011001" =>
            manhi <= conv_std_logic_vector(317829,24);
            manlo <= conv_std_logic_vector(9077005,28);
           exponent <= '1';
      WHEN "1011011010" =>
            manhi <= conv_std_logic_vector(334531,24);
            manlo <= conv_std_logic_vector(152454469,28);
           exponent <= '1';
      WHEN "1011011011" =>
            manhi <= conv_std_logic_vector(351250,24);
            manlo <= conv_std_logic_vector(113036907,28);
           exponent <= '1';
      WHEN "1011011100" =>
            manhi <= conv_std_logic_vector(367985,24);
            manlo <= conv_std_logic_vector(163539801,28);
           exponent <= '1';
      WHEN "1011011101" =>
            manhi <= conv_std_logic_vector(384737,24);
            manlo <= conv_std_logic_vector(39811903,28);
           exponent <= '1';
      WHEN "1011011110" =>
            manhi <= conv_std_logic_vector(401505,24);
            manlo <= conv_std_logic_vector(14577065,28);
           exponent <= '1';
      WHEN "1011011111" =>
            manhi <= conv_std_logic_vector(418289,24);
            manlo <= conv_std_logic_vector(92127870,28);
           exponent <= '1';
      WHEN "1011100000" =>
            manhi <= conv_std_logic_vector(435090,24);
            manlo <= conv_std_logic_vector(8325641,28);
           exponent <= '1';
      WHEN "1011100001" =>
            manhi <= conv_std_logic_vector(451907,24);
            manlo <= conv_std_logic_vector(35906810,28);
           exponent <= '1';
      WHEN "1011100010" =>
            manhi <= conv_std_logic_vector(468740,24);
            manlo <= conv_std_logic_vector(179176556,28);
           exponent <= '1';
      WHEN "1011100011" =>
            manhi <= conv_std_logic_vector(485590,24);
            manlo <= conv_std_logic_vector(174008808,28);
           exponent <= '1';
      WHEN "1011100100" =>
            manhi <= conv_std_logic_vector(502457,24);
            manlo <= conv_std_logic_vector(24717160,28);
           exponent <= '1';
      WHEN "1011100101" =>
            manhi <= conv_std_logic_vector(519340,24);
            manlo <= conv_std_logic_vector(4054880,28);
           exponent <= '1';
      WHEN "1011100110" =>
            manhi <= conv_std_logic_vector(536239,24);
            manlo <= conv_std_logic_vector(116343996,28);
           exponent <= '1';
      WHEN "1011100111" =>
            manhi <= conv_std_logic_vector(553155,24);
            manlo <= conv_std_logic_vector(97475302,28);
           exponent <= '1';
      WHEN "1011101000" =>
            manhi <= conv_std_logic_vector(570087,24);
            manlo <= conv_std_logic_vector(220214735,28);
           exponent <= '1';
      WHEN "1011101001" =>
            manhi <= conv_std_logic_vector(587036,24);
            manlo <= conv_std_logic_vector(220461546,28);
           exponent <= '1';
      WHEN "1011101010" =>
            manhi <= conv_std_logic_vector(604002,24);
            manlo <= conv_std_logic_vector(102554681,28);
           exponent <= '1';
      WHEN "1011101011" =>
            manhi <= conv_std_logic_vector(620984,24);
            manlo <= conv_std_logic_vector(139272779,28);
           exponent <= '1';
      WHEN "1011101100" =>
            manhi <= conv_std_logic_vector(637983,24);
            manlo <= conv_std_logic_vector(66527812,28);
           exponent <= '1';
      WHEN "1011101101" =>
            manhi <= conv_std_logic_vector(654998,24);
            manlo <= conv_std_logic_vector(157106911,28);
           exponent <= '1';
      WHEN "1011101110" =>
            manhi <= conv_std_logic_vector(672030,24);
            manlo <= conv_std_logic_vector(146930546,28);
           exponent <= '1';
      WHEN "1011101111" =>
            manhi <= conv_std_logic_vector(689079,24);
            manlo <= conv_std_logic_vector(40358901,28);
           exponent <= '1';
      WHEN "1011110000" =>
            manhi <= conv_std_logic_vector(706144,24);
            manlo <= conv_std_logic_vector(110191873,28);
           exponent <= '1';
      WHEN "1011110001" =>
            manhi <= conv_std_logic_vector(723226,24);
            manlo <= conv_std_logic_vector(92362714,28);
           exponent <= '1';
      WHEN "1011110010" =>
            manhi <= conv_std_logic_vector(740324,24);
            manlo <= conv_std_logic_vector(259679855,28);
           exponent <= '1';
      WHEN "1011110011" =>
            manhi <= conv_std_logic_vector(757440,24);
            manlo <= conv_std_logic_vector(79649632,28);
           exponent <= '1';
      WHEN "1011110100" =>
            manhi <= conv_std_logic_vector(774572,24);
            manlo <= conv_std_logic_vector(93524482,28);
           exponent <= '1';
      WHEN "1011110101" =>
            manhi <= conv_std_logic_vector(791721,24);
            manlo <= conv_std_logic_vector(37254754,28);
           exponent <= '1';
      WHEN "1011110110" =>
            manhi <= conv_std_logic_vector(808886,24);
            manlo <= conv_std_logic_vector(183665996,28);
           exponent <= '1';
      WHEN "1011110111" =>
            manhi <= conv_std_logic_vector(826069,24);
            manlo <= conv_std_logic_vector(281674,28);
           exponent <= '1';
      WHEN "1011111000" =>
            manhi <= conv_std_logic_vector(843268,24);
            manlo <= conv_std_logic_vector(28371374,28);
           exponent <= '1';
      WHEN "1011111001" =>
            manhi <= conv_std_logic_vector(860484,24);
            manlo <= conv_std_logic_vector(3902612,28);
           exponent <= '1';
      WHEN "1011111010" =>
            manhi <= conv_std_logic_vector(877716,24);
            manlo <= conv_std_logic_vector(199718117,28);
           exponent <= '1';
      WHEN "1011111011" =>
            manhi <= conv_std_logic_vector(894966,24);
            manlo <= conv_std_logic_vector(83358555,28);
           exponent <= '1';
      WHEN "1011111100" =>
            manhi <= conv_std_logic_vector(912232,24);
            manlo <= conv_std_logic_vector(196110728,28);
           exponent <= '1';
      WHEN "1011111101" =>
            manhi <= conv_std_logic_vector(929516,24);
            manlo <= conv_std_logic_vector(5523929,28);
           exponent <= '1';
      WHEN "1011111110" =>
            manhi <= conv_std_logic_vector(946816,24);
            manlo <= conv_std_logic_vector(52893590,28);
           exponent <= '1';
      WHEN "1011111111" =>
            manhi <= conv_std_logic_vector(964133,24);
            manlo <= conv_std_logic_vector(74213103,28);
           exponent <= '1';
      WHEN "1100000000" =>
            manhi <= conv_std_logic_vector(981467,24);
            manlo <= conv_std_logic_vector(73915640,28);
           exponent <= '1';
      WHEN "1100000001" =>
            manhi <= conv_std_logic_vector(998818,24);
            manlo <= conv_std_logic_vector(56438704,28);
           exponent <= '1';
      WHEN "1100000010" =>
            manhi <= conv_std_logic_vector(1016186,24);
            manlo <= conv_std_logic_vector(26224136,28);
           exponent <= '1';
      WHEN "1100000011" =>
            manhi <= conv_std_logic_vector(1033570,24);
            manlo <= conv_std_logic_vector(256153571,28);
           exponent <= '1';
      WHEN "1100000100" =>
            manhi <= conv_std_logic_vector(1050972,24);
            manlo <= conv_std_logic_vector(213806620,28);
           exponent <= '1';
      WHEN "1100000101" =>
            manhi <= conv_std_logic_vector(1068391,24);
            manlo <= conv_std_logic_vector(172073612,28);
           exponent <= '1';
      WHEN "1100000110" =>
            manhi <= conv_std_logic_vector(1085827,24);
            manlo <= conv_std_logic_vector(135413771,28);
           exponent <= '1';
      WHEN "1100000111" =>
            manhi <= conv_std_logic_vector(1103280,24);
            manlo <= conv_std_logic_vector(108290679,28);
           exponent <= '1';
      WHEN "1100001000" =>
            manhi <= conv_std_logic_vector(1120750,24);
            manlo <= conv_std_logic_vector(95172278,28);
           exponent <= '1';
      WHEN "1100001001" =>
            manhi <= conv_std_logic_vector(1138237,24);
            manlo <= conv_std_logic_vector(100530876,28);
           exponent <= '1';
      WHEN "1100001010" =>
            manhi <= conv_std_logic_vector(1155741,24);
            manlo <= conv_std_logic_vector(128843150,28);
           exponent <= '1';
      WHEN "1100001011" =>
            manhi <= conv_std_logic_vector(1173262,24);
            manlo <= conv_std_logic_vector(184590152,28);
           exponent <= '1';
      WHEN "1100001100" =>
            manhi <= conv_std_logic_vector(1190801,24);
            manlo <= conv_std_logic_vector(3821855,28);
           exponent <= '1';
      WHEN "1100001101" =>
            manhi <= conv_std_logic_vector(1208356,24);
            manlo <= conv_std_logic_vector(127898983,28);
           exponent <= '1';
      WHEN "1100001110" =>
            manhi <= conv_std_logic_vector(1225929,24);
            manlo <= conv_std_logic_vector(24444823,28);
           exponent <= '1';
      WHEN "1100001111" =>
            manhi <= conv_std_logic_vector(1243518,24);
            manlo <= conv_std_logic_vector(234828877,28);
           exponent <= '1';
      WHEN "1100010000" =>
            manhi <= conv_std_logic_vector(1261125,24);
            manlo <= conv_std_logic_vector(226683218,28);
           exponent <= '1';
      WHEN "1100010001" =>
            manhi <= conv_std_logic_vector(1278750,24);
            manlo <= conv_std_logic_vector(4515229,28);
           exponent <= '1';
      WHEN "1100010010" =>
            manhi <= conv_std_logic_vector(1296391,24);
            manlo <= conv_std_logic_vector(109707612,28);
           exponent <= '1';
      WHEN "1100010011" =>
            manhi <= conv_std_logic_vector(1314050,24);
            manlo <= conv_std_logic_vector(9905652,28);
           exponent <= '1';
      WHEN "1100010100" =>
            manhi <= conv_std_logic_vector(1331725,24);
            manlo <= conv_std_logic_vector(246500869,28);
           exponent <= '1';
      WHEN "1100010101" =>
            manhi <= conv_std_logic_vector(1349419,24);
            manlo <= conv_std_logic_vector(18711921,28);
           exponent <= '1';
      WHEN "1100010110" =>
            manhi <= conv_std_logic_vector(1367129,24);
            manlo <= conv_std_logic_vector(136374624,28);
           exponent <= '1';
      WHEN "1100010111" =>
            manhi <= conv_std_logic_vector(1384857,24);
            manlo <= conv_std_logic_vector(67151939,28);
           exponent <= '1';
      WHEN "1100011000" =>
            manhi <= conv_std_logic_vector(1402602,24);
            manlo <= conv_std_logic_vector(84017623,28);
           exponent <= '1';
      WHEN "1100011001" =>
            manhi <= conv_std_logic_vector(1420364,24);
            manlo <= conv_std_logic_vector(191514413,28);
           exponent <= '1';
      WHEN "1100011010" =>
            manhi <= conv_std_logic_vector(1438144,24);
            manlo <= conv_std_logic_vector(125754028,28);
           exponent <= '1';
      WHEN "1100011011" =>
            manhi <= conv_std_logic_vector(1455941,24);
            manlo <= conv_std_logic_vector(159723541,28);
           exponent <= '1';
      WHEN "1100011100" =>
            manhi <= conv_std_logic_vector(1473756,24);
            manlo <= conv_std_logic_vector(29543561,28);
           exponent <= '1';
      WHEN "1100011101" =>
            manhi <= conv_std_logic_vector(1491588,24);
            manlo <= conv_std_logic_vector(8210062,28);
           exponent <= '1';
      WHEN "1100011110" =>
            manhi <= conv_std_logic_vector(1509437,24);
            manlo <= conv_std_logic_vector(100288013,28);
           exponent <= '1';
      WHEN "1100011111" =>
            manhi <= conv_std_logic_vector(1527304,24);
            manlo <= conv_std_logic_vector(41911392,28);
           exponent <= '1';
      WHEN "1100100000" =>
            manhi <= conv_std_logic_vector(1545188,24);
            manlo <= conv_std_logic_vector(106089552,28);
           exponent <= '1';
      WHEN "1100100001" =>
            manhi <= conv_std_logic_vector(1563090,24);
            manlo <= conv_std_logic_vector(28965402,28);
           exponent <= '1';
      WHEN "1100100010" =>
            manhi <= conv_std_logic_vector(1581009,24);
            manlo <= conv_std_logic_vector(83557236,28);
           exponent <= '1';
      WHEN "1100100011" =>
            manhi <= conv_std_logic_vector(1598946,24);
            manlo <= conv_std_logic_vector(6016916,28);
           exponent <= '1';
      WHEN "1100100100" =>
            manhi <= conv_std_logic_vector(1616900,24);
            manlo <= conv_std_logic_vector(69371695,28);
           exponent <= '1';
      WHEN "1100100101" =>
            manhi <= conv_std_logic_vector(1634872,24);
            manlo <= conv_std_logic_vector(9782402,28);
           exponent <= '1';
      WHEN "1100100110" =>
            manhi <= conv_std_logic_vector(1652861,24);
            manlo <= conv_std_logic_vector(100285270,28);
           exponent <= '1';
      WHEN "1100100111" =>
            manhi <= conv_std_logic_vector(1670868,24);
            manlo <= conv_std_logic_vector(77050112,28);
           exponent <= '1';
      WHEN "1100101000" =>
            manhi <= conv_std_logic_vector(1688892,24);
            manlo <= conv_std_logic_vector(213122155,28);
           exponent <= '1';
      WHEN "1100101001" =>
            manhi <= conv_std_logic_vector(1706934,24);
            manlo <= conv_std_logic_vector(244680216,28);
           exponent <= '1';
      WHEN "1100101010" =>
            manhi <= conv_std_logic_vector(1724994,24);
            manlo <= conv_std_logic_vector(176343080,28);
           exponent <= '1';
      WHEN "1100101011" =>
            manhi <= conv_std_logic_vector(1743072,24);
            manlo <= conv_std_logic_vector(12734040,28);
           exponent <= '1';
      WHEN "1100101100" =>
            manhi <= conv_std_logic_vector(1761167,24);
            manlo <= conv_std_logic_vector(26916364,28);
           exponent <= '1';
      WHEN "1100101101" =>
            manhi <= conv_std_logic_vector(1779279,24);
            manlo <= conv_std_logic_vector(223522388,28);
           exponent <= '1';
      WHEN "1100101110" =>
            manhi <= conv_std_logic_vector(1797410,24);
            manlo <= conv_std_logic_vector(70318058,28);
           exponent <= '1';
      WHEN "1100101111" =>
            manhi <= conv_std_logic_vector(1815558,24);
            manlo <= conv_std_logic_vector(108815677,28);
           exponent <= '1';
      WHEN "1100110000" =>
            manhi <= conv_std_logic_vector(1833724,24);
            manlo <= conv_std_logic_vector(75225715,28);
           exponent <= '1';
      WHEN "1100110001" =>
            manhi <= conv_std_logic_vector(1851907,24);
            manlo <= conv_std_logic_vector(242634090,28);
           exponent <= '1';
      WHEN "1100110010" =>
            manhi <= conv_std_logic_vector(1870109,24);
            manlo <= conv_std_logic_vector(78824900,28);
           exponent <= '1';
      WHEN "1100110011" =>
            manhi <= conv_std_logic_vector(1888328,24);
            manlo <= conv_std_logic_vector(125328613,28);
           exponent <= '1';
      WHEN "1100110100" =>
            manhi <= conv_std_logic_vector(1906565,24);
            manlo <= conv_std_logic_vector(118373881,28);
           exponent <= '1';
      WHEN "1100110101" =>
            manhi <= conv_std_logic_vector(1924820,24);
            manlo <= conv_std_logic_vector(62629370,28);
           exponent <= '1';
      WHEN "1100110110" =>
            manhi <= conv_std_logic_vector(1943092,24);
            manlo <= conv_std_logic_vector(231203763,28);
           exponent <= '1';
      WHEN "1100110111" =>
            manhi <= conv_std_logic_vector(1961383,24);
            manlo <= conv_std_logic_vector(91903942,28);
           exponent <= '1';
      WHEN "1100111000" =>
            manhi <= conv_std_logic_vector(1979691,24);
            manlo <= conv_std_logic_vector(186283181,28);
           exponent <= '1';
      WHEN "1100111001" =>
            manhi <= conv_std_logic_vector(1998017,24);
            manlo <= conv_std_logic_vector(250592964,28);
           exponent <= '1';
      WHEN "1100111010" =>
            manhi <= conv_std_logic_vector(2016362,24);
            manlo <= conv_std_logic_vector(21089351,28);
           exponent <= '1';
      WHEN "1100111011" =>
            manhi <= conv_std_logic_vector(2034724,24);
            manlo <= conv_std_logic_vector(39339357,28);
           exponent <= '1';
      WHEN "1100111100" =>
            manhi <= conv_std_logic_vector(2053104,24);
            manlo <= conv_std_logic_vector(41608216,28);
           exponent <= '1';
      WHEN "1100111101" =>
            manhi <= conv_std_logic_vector(2071502,24);
            manlo <= conv_std_logic_vector(32601209,28);
           exponent <= '1';
      WHEN "1100111110" =>
            manhi <= conv_std_logic_vector(2089918,24);
            manlo <= conv_std_logic_vector(17028217,28);
           exponent <= '1';
      WHEN "1100111111" =>
            manhi <= conv_std_logic_vector(2108351,24);
            manlo <= conv_std_logic_vector(268039176,28);
           exponent <= '1';
      WHEN "1101000000" =>
            manhi <= conv_std_logic_vector(2126803,24);
            manlo <= conv_std_logic_vector(253482264,28);
           exponent <= '1';
      WHEN "1101000001" =>
            manhi <= conv_std_logic_vector(2145273,24);
            manlo <= conv_std_logic_vector(246516634,28);
           exponent <= '1';
      WHEN "1101000010" =>
            manhi <= conv_std_logic_vector(2163761,24);
            manlo <= conv_std_logic_vector(251870600,28);
           exponent <= '1';
      WHEN "1101000011" =>
            manhi <= conv_std_logic_vector(2182268,24);
            manlo <= conv_std_logic_vector(5841640,28);
           exponent <= '1';
      WHEN "1101000100" =>
            manhi <= conv_std_logic_vector(2200792,24);
            manlo <= conv_std_logic_vector(50038222,28);
           exponent <= '1';
      WHEN "1101000101" =>
            manhi <= conv_std_logic_vector(2219334,24);
            manlo <= conv_std_logic_vector(120767079,28);
           exponent <= '1';
      WHEN "1101000110" =>
            manhi <= conv_std_logic_vector(2237894,24);
            manlo <= conv_std_logic_vector(222775030,28);
           exponent <= '1';
      WHEN "1101000111" =>
            manhi <= conv_std_logic_vector(2256473,24);
            manlo <= conv_std_logic_vector(92378075,28);
           exponent <= '1';
      WHEN "1101001000" =>
            manhi <= conv_std_logic_vector(2275070,24);
            manlo <= conv_std_logic_vector(2767772,28);
           exponent <= '1';
      WHEN "1101001001" =>
            manhi <= conv_std_logic_vector(2293684,24);
            manlo <= conv_std_logic_vector(227140324,28);
           exponent <= '1';
      WHEN "1101001010" =>
            manhi <= conv_std_logic_vector(2312317,24);
            manlo <= conv_std_logic_vector(233390216,28);
           exponent <= '1';
      WHEN "1101001011" =>
            manhi <= conv_std_logic_vector(2330969,24);
            manlo <= conv_std_logic_vector(26287503,28);
           exponent <= '1';
      WHEN "1101001100" =>
            manhi <= conv_std_logic_vector(2349638,24);
            manlo <= conv_std_logic_vector(147477811,28);
           exponent <= '1';
      WHEN "1101001101" =>
            manhi <= conv_std_logic_vector(2368326,24);
            manlo <= conv_std_logic_vector(64869610,28);
           exponent <= '1';
      WHEN "1101001110" =>
            manhi <= conv_std_logic_vector(2387032,24);
            manlo <= conv_std_logic_vector(51682404,28);
           exponent <= '1';
      WHEN "1101001111" =>
            manhi <= conv_std_logic_vector(2405756,24);
            manlo <= conv_std_logic_vector(112704917,28);
           exponent <= '1';
      WHEN "1101010000" =>
            manhi <= conv_std_logic_vector(2424498,24);
            manlo <= conv_std_logic_vector(252730552,28);
           exponent <= '1';
      WHEN "1101010001" =>
            manhi <= conv_std_logic_vector(2443259,24);
            manlo <= conv_std_logic_vector(208121938,28);
           exponent <= '1';
      WHEN "1101010010" =>
            manhi <= conv_std_logic_vector(2462038,24);
            manlo <= conv_std_logic_vector(252117306,28);
           exponent <= '1';
      WHEN "1101010011" =>
            manhi <= conv_std_logic_vector(2480836,24);
            manlo <= conv_std_logic_vector(121088666,28);
           exponent <= '1';
      WHEN "1101010100" =>
            manhi <= conv_std_logic_vector(2499652,24);
            manlo <= conv_std_logic_vector(88283637,28);
           exponent <= '1';
      WHEN "1101010101" =>
            manhi <= conv_std_logic_vector(2518486,24);
            manlo <= conv_std_logic_vector(158519085,28);
           exponent <= '1';
      WHEN "1101010110" =>
            manhi <= conv_std_logic_vector(2537339,24);
            manlo <= conv_std_logic_vector(68181124,28);
           exponent <= '1';
      WHEN "1101010111" =>
            manhi <= conv_std_logic_vector(2556210,24);
            manlo <= conv_std_logic_vector(90531494,28);
           exponent <= '1';
      WHEN "1101011000" =>
            manhi <= conv_std_logic_vector(2575099,24);
            manlo <= conv_std_logic_vector(230401190,28);
           exponent <= '1';
      WHEN "1101011001" =>
            manhi <= conv_std_logic_vector(2594007,24);
            manlo <= conv_std_logic_vector(224190477,28);
           exponent <= '1';
      WHEN "1101011010" =>
            manhi <= conv_std_logic_vector(2612934,24);
            manlo <= conv_std_logic_vector(76739795,28);
           exponent <= '1';
      WHEN "1101011011" =>
            manhi <= conv_std_logic_vector(2631879,24);
            manlo <= conv_std_logic_vector(61329773,28);
           exponent <= '1';
      WHEN "1101011100" =>
            manhi <= conv_std_logic_vector(2650842,24);
            manlo <= conv_std_logic_vector(182810317,28);
           exponent <= '1';
      WHEN "1101011101" =>
            manhi <= conv_std_logic_vector(2669824,24);
            manlo <= conv_std_logic_vector(177600614,28);
           exponent <= '1';
      WHEN "1101011110" =>
            manhi <= conv_std_logic_vector(2688825,24);
            manlo <= conv_std_logic_vector(50560052,28);
           exponent <= '1';
      WHEN "1101011111" =>
            manhi <= conv_std_logic_vector(2707844,24);
            manlo <= conv_std_logic_vector(74988222,28);
           exponent <= '1';
      WHEN "1101100000" =>
            manhi <= conv_std_logic_vector(2726881,24);
            manlo <= conv_std_logic_vector(255754012,28);
           exponent <= '1';
      WHEN "1101100001" =>
            manhi <= conv_std_logic_vector(2745938,24);
            manlo <= conv_std_logic_vector(60860155,28);
           exponent <= '1';
      WHEN "1101100010" =>
            manhi <= conv_std_logic_vector(2765013,24);
            manlo <= conv_std_logic_vector(32055969,28);
           exponent <= '1';
      WHEN "1101100011" =>
            manhi <= conv_std_logic_vector(2784106,24);
            manlo <= conv_std_logic_vector(174224628,28);
           exponent <= '1';
      WHEN "1101100100" =>
            manhi <= conv_std_logic_vector(2803218,24);
            manlo <= conv_std_logic_vector(223818618,28);
           exponent <= '1';
      WHEN "1101100101" =>
            manhi <= conv_std_logic_vector(2822349,24);
            manlo <= conv_std_logic_vector(185730660,28);
           exponent <= '1';
      WHEN "1101100110" =>
            manhi <= conv_std_logic_vector(2841499,24);
            manlo <= conv_std_logic_vector(64858254,28);
           exponent <= '1';
      WHEN "1101100111" =>
            manhi <= conv_std_logic_vector(2860667,24);
            manlo <= conv_std_logic_vector(134539142,28);
           exponent <= '1';
      WHEN "1101101000" =>
            manhi <= conv_std_logic_vector(2879854,24);
            manlo <= conv_std_logic_vector(131244940,28);
           exponent <= '1';
      WHEN "1101101001" =>
            manhi <= conv_std_logic_vector(2899060,24);
            manlo <= conv_std_logic_vector(59887520,28);
           exponent <= '1';
      WHEN "1101101010" =>
            manhi <= conv_std_logic_vector(2918284,24);
            manlo <= conv_std_logic_vector(193819006,28);
           exponent <= '1';
      WHEN "1101101011" =>
            manhi <= conv_std_logic_vector(2937528,24);
            manlo <= conv_std_logic_vector(1089957,28);
           exponent <= '1';
      WHEN "1101101100" =>
            manhi <= conv_std_logic_vector(2956790,24);
            manlo <= conv_std_logic_vector(23497566,28);
           exponent <= '1';
      WHEN "1101101101" =>
            manhi <= conv_std_logic_vector(2976070,24);
            manlo <= conv_std_logic_vector(265972927,28);
           exponent <= '1';
      WHEN "1101101110" =>
            manhi <= conv_std_logic_vector(2995370,24);
            manlo <= conv_std_logic_vector(196581040,28);
           exponent <= '1';
      WHEN "1101101111" =>
            manhi <= conv_std_logic_vector(3014689,24);
            manlo <= conv_std_logic_vector(88698094,28);
           exponent <= '1';
      WHEN "1101110000" =>
            manhi <= conv_std_logic_vector(3034026,24);
            manlo <= conv_std_logic_vector(215705108,28);
           exponent <= '1';
      WHEN "1101110001" =>
            manhi <= conv_std_logic_vector(3053383,24);
            manlo <= conv_std_logic_vector(45681562,28);
           exponent <= '1';
      WHEN "1101110010" =>
            manhi <= conv_std_logic_vector(3072758,24);
            manlo <= conv_std_logic_vector(120453600,28);
           exponent <= '1';
      WHEN "1101110011" =>
            manhi <= conv_std_logic_vector(3092152,24);
            manlo <= conv_std_logic_vector(176545836,28);
           exponent <= '1';
      WHEN "1101110100" =>
            manhi <= conv_std_logic_vector(3111565,24);
            manlo <= conv_std_logic_vector(218923189,28);
           exponent <= '1';
      WHEN "1101110101" =>
            manhi <= conv_std_logic_vector(3130997,24);
            manlo <= conv_std_logic_vector(252555427,28);
           exponent <= '1';
      WHEN "1101110110" =>
            manhi <= conv_std_logic_vector(3150449,24);
            manlo <= conv_std_logic_vector(13981719,28);
           exponent <= '1';
      WHEN "1101110111" =>
            manhi <= conv_std_logic_vector(3169919,24);
            manlo <= conv_std_logic_vector(45052462,28);
           exponent <= '1';
      WHEN "1101111000" =>
            manhi <= conv_std_logic_vector(3189408,24);
            manlo <= conv_std_logic_vector(82316549,28);
           exponent <= '1';
      WHEN "1101111001" =>
            manhi <= conv_std_logic_vector(3208916,24);
            manlo <= conv_std_logic_vector(130763202,28);
           exponent <= '1';
      WHEN "1101111010" =>
            manhi <= conv_std_logic_vector(3228443,24);
            manlo <= conv_std_logic_vector(195386513,28);
           exponent <= '1';
      WHEN "1101111011" =>
            manhi <= conv_std_logic_vector(3247990,24);
            manlo <= conv_std_logic_vector(12750002,28);
           exponent <= '1';
      WHEN "1101111100" =>
            manhi <= conv_std_logic_vector(3267555,24);
            manlo <= conv_std_logic_vector(124728439,28);
           exponent <= '1';
      WHEN "1101111101" =>
            manhi <= conv_std_logic_vector(3287139,24);
            manlo <= conv_std_logic_vector(267895114,28);
           exponent <= '1';
      WHEN "1101111110" =>
            manhi <= conv_std_logic_vector(3306743,24);
            manlo <= conv_std_logic_vector(178828213,28);
           exponent <= '1';
      WHEN "1101111111" =>
            manhi <= conv_std_logic_vector(3326366,24);
            manlo <= conv_std_logic_vector(130981732,28);
           exponent <= '1';
      WHEN "1110000000" =>
            manhi <= conv_std_logic_vector(3346008,24);
            manlo <= conv_std_logic_vector(129379112,28);
           exponent <= '1';
      WHEN "1110000001" =>
            manhi <= conv_std_logic_vector(3365669,24);
            manlo <= conv_std_logic_vector(179048704,28);
           exponent <= '1';
      WHEN "1110000010" =>
            manhi <= conv_std_logic_vector(3385350,24);
            manlo <= conv_std_logic_vector(16588318,28);
           exponent <= '1';
      WHEN "1110000011" =>
            manhi <= conv_std_logic_vector(3405049,24);
            manlo <= conv_std_logic_vector(183907046,28);
           exponent <= '1';
      WHEN "1110000100" =>
            manhi <= conv_std_logic_vector(3424768,24);
            manlo <= conv_std_logic_vector(149177079,28);
           exponent <= '1';
      WHEN "1110000101" =>
            manhi <= conv_std_logic_vector(3444506,24);
            manlo <= conv_std_logic_vector(185881906,28);
           exponent <= '1';
      WHEN "1110000110" =>
            manhi <= conv_std_logic_vector(3464264,24);
            manlo <= conv_std_logic_vector(30639033,28);
           exponent <= '1';
      WHEN "1110000111" =>
            manhi <= conv_std_logic_vector(3484040,24);
            manlo <= conv_std_logic_vector(225377274,28);
           exponent <= '1';
      WHEN "1110001000" =>
            manhi <= conv_std_logic_vector(3503836,24);
            manlo <= conv_std_logic_vector(238288557,28);
           exponent <= '1';
      WHEN "1110001001" =>
            manhi <= conv_std_logic_vector(3523652,24);
            manlo <= conv_std_logic_vector(74440673,28);
           exponent <= '1';
      WHEN "1110001010" =>
            manhi <= conv_std_logic_vector(3543487,24);
            manlo <= conv_std_logic_vector(7341816,28);
           exponent <= '1';
      WHEN "1110001011" =>
            manhi <= conv_std_logic_vector(3563341,24);
            manlo <= conv_std_logic_vector(42069684,28);
           exponent <= '1';
      WHEN "1110001100" =>
            manhi <= conv_std_logic_vector(3583214,24);
            manlo <= conv_std_logic_vector(183706934,28);
           exponent <= '1';
      WHEN "1110001101" =>
            manhi <= conv_std_logic_vector(3603107,24);
            manlo <= conv_std_logic_vector(168905734,28);
           exponent <= '1';
      WHEN "1110001110" =>
            manhi <= conv_std_logic_vector(3623020,24);
            manlo <= conv_std_logic_vector(2758677,28);
           exponent <= '1';
      WHEN "1110001111" =>
            manhi <= conv_std_logic_vector(3642951,24);
            manlo <= conv_std_logic_vector(227234245,28);
           exponent <= '1';
      WHEN "1110010000" =>
            manhi <= conv_std_logic_vector(3662903,24);
            manlo <= conv_std_logic_vector(42128622,28);
           exponent <= '1';
      WHEN "1110010001" =>
            manhi <= conv_std_logic_vector(3682873,24);
            manlo <= conv_std_logic_vector(257855711,28);
           exponent <= '1';
      WHEN "1110010010" =>
            manhi <= conv_std_logic_vector(3702864,24);
            manlo <= conv_std_logic_vector(74221670,28);
           exponent <= '1';
      WHEN "1110010011" =>
            manhi <= conv_std_logic_vector(3722874,24);
            manlo <= conv_std_logic_vector(33214933,28);
           exponent <= '1';
      WHEN "1110010100" =>
            manhi <= conv_std_logic_vector(3742903,24);
            manlo <= conv_std_logic_vector(139958020,28);
           exponent <= '1';
      WHEN "1110010101" =>
            manhi <= conv_std_logic_vector(3762952,24);
            manlo <= conv_std_logic_vector(131143002,28);
           exponent <= '1';
      WHEN "1110010110" =>
            manhi <= conv_std_logic_vector(3783021,24);
            manlo <= conv_std_logic_vector(11902416,28);
           exponent <= '1';
      WHEN "1110010111" =>
            manhi <= conv_std_logic_vector(3803109,24);
            manlo <= conv_std_logic_vector(55809266,28);
           exponent <= '1';
      WHEN "1110011000" =>
            manhi <= conv_std_logic_vector(3823216,24);
            manlo <= conv_std_logic_vector(268006125,28);
           exponent <= '1';
      WHEN "1110011001" =>
            manhi <= conv_std_logic_vector(3843344,24);
            manlo <= conv_std_logic_vector(116769675,28);
           exponent <= '1';
      WHEN "1110011010" =>
            manhi <= conv_std_logic_vector(3863491,24);
            manlo <= conv_std_logic_vector(144123451,28);
           exponent <= '1';
      WHEN "1110011011" =>
            manhi <= conv_std_logic_vector(3883658,24);
            manlo <= conv_std_logic_vector(86789657,28);
           exponent <= '1';
      WHEN "1110011100" =>
            manhi <= conv_std_logic_vector(3903844,24);
            manlo <= conv_std_logic_vector(218366446,28);
           exponent <= '1';
      WHEN "1110011101" =>
            manhi <= conv_std_logic_vector(3924051,24);
            manlo <= conv_std_logic_vector(7150648,28);
           exponent <= '1';
      WHEN "1110011110" =>
            manhi <= conv_std_logic_vector(3944276,24);
            manlo <= conv_std_logic_vector(263621422,28);
           exponent <= '1';
      WHEN "1110011111" =>
            manhi <= conv_std_logic_vector(3964522,24);
            manlo <= conv_std_logic_vector(187650244,28);
           exponent <= '1';
      WHEN "1110100000" =>
            manhi <= conv_std_logic_vector(3984788,24);
            manlo <= conv_std_logic_vector(52855476,28);
           exponent <= '1';
      WHEN "1110100001" =>
            manhi <= conv_std_logic_vector(4005073,24);
            manlo <= conv_std_logic_vector(132860541,28);
           exponent <= '1';
      WHEN "1110100010" =>
            manhi <= conv_std_logic_vector(4025378,24);
            manlo <= conv_std_logic_vector(164423019,28);
           exponent <= '1';
      WHEN "1110100011" =>
            manhi <= conv_std_logic_vector(4045703,24);
            manlo <= conv_std_logic_vector(152741021,28);
           exponent <= '1';
      WHEN "1110100100" =>
            manhi <= conv_std_logic_vector(4066048,24);
            manlo <= conv_std_logic_vector(103017737,28);
           exponent <= '1';
      WHEN "1110100101" =>
            manhi <= conv_std_logic_vector(4086413,24);
            manlo <= conv_std_logic_vector(20461438,28);
           exponent <= '1';
      WHEN "1110100110" =>
            manhi <= conv_std_logic_vector(4106797,24);
            manlo <= conv_std_logic_vector(178720944,28);
           exponent <= '1';
      WHEN "1110100111" =>
            manhi <= conv_std_logic_vector(4127202,24);
            manlo <= conv_std_logic_vector(46143798,28);
           exponent <= '1';
      WHEN "1110101000" =>
            manhi <= conv_std_logic_vector(4147626,24);
            manlo <= conv_std_logic_vector(164824464,28);
           exponent <= '1';
      WHEN "1110101001" =>
            manhi <= conv_std_logic_vector(4168071,24);
            manlo <= conv_std_logic_vector(3120689,28);
           exponent <= '1';
      WHEN "1110101010" =>
            manhi <= conv_std_logic_vector(4188535,24);
            manlo <= conv_std_logic_vector(103137152,28);
           exponent <= '1';
      WHEN "1110101011" =>
            manhi <= conv_std_logic_vector(4209019,24);
            manlo <= conv_std_logic_vector(201677275,28);
           exponent <= '1';
      WHEN "1110101100" =>
            manhi <= conv_std_logic_vector(4229524,24);
            manlo <= conv_std_logic_vector(35549602,28);
           exponent <= '1';
      WHEN "1110101101" =>
            manhi <= conv_std_logic_vector(4250048,24);
            manlo <= conv_std_logic_vector(146874166,28);
           exponent <= '1';
      WHEN "1110101110" =>
            manhi <= conv_std_logic_vector(4270593,24);
            manlo <= conv_std_logic_vector(4034305,28);
           exponent <= '1';
      WHEN "1110101111" =>
            manhi <= conv_std_logic_vector(4291157,24);
            manlo <= conv_std_logic_vector(149160317,28);
           exponent <= '1';
      WHEN "1110110000" =>
            manhi <= conv_std_logic_vector(4311742,24);
            manlo <= conv_std_logic_vector(50645812,28);
           exponent <= '1';
      WHEN "1110110001" =>
            manhi <= conv_std_logic_vector(4332346,24);
            manlo <= conv_std_logic_vector(250631368,28);
           exponent <= '1';
      WHEN "1110110010" =>
            manhi <= conv_std_logic_vector(4352971,24);
            manlo <= conv_std_logic_vector(217520889,28);
           exponent <= '1';
      WHEN "1110110011" =>
            manhi <= conv_std_logic_vector(4373616,24);
            manlo <= conv_std_logic_vector(225029798,28);
           exponent <= '1';
      WHEN "1110110100" =>
            manhi <= conv_std_logic_vector(4394282,24);
            manlo <= conv_std_logic_vector(10007770,28);
           exponent <= '1';
      WHEN "1110110101" =>
            manhi <= conv_std_logic_vector(4414967,24);
            manlo <= conv_std_logic_vector(114616005,28);
           exponent <= '1';
      WHEN "1110110110" =>
            manhi <= conv_std_logic_vector(4435673,24);
            manlo <= conv_std_logic_vector(7279052,28);
           exponent <= '1';
      WHEN "1110110111" =>
            manhi <= conv_std_logic_vector(4456398,24);
            manlo <= conv_std_logic_vector(230168458,28);
           exponent <= '1';
      WHEN "1110111000" =>
            manhi <= conv_std_logic_vector(4477144,24);
            manlo <= conv_std_logic_vector(251719124,28);
           exponent <= '1';
      WHEN "1110111001" =>
            manhi <= conv_std_logic_vector(4497911,24);
            manlo <= conv_std_logic_vector(77242046,28);
           exponent <= '1';
      WHEN "1110111010" =>
            manhi <= conv_std_logic_vector(4518697,24);
            manlo <= conv_std_logic_vector(248924323,28);
           exponent <= '1';
      WHEN "1110111011" =>
            manhi <= conv_std_logic_vector(4539504,24);
            manlo <= conv_std_logic_vector(235216422,28);
           exponent <= '1';
      WHEN "1110111100" =>
            manhi <= conv_std_logic_vector(4560332,24);
            manlo <= conv_std_logic_vector(41444923,28);
           exponent <= '1';
      WHEN "1110111101" =>
            manhi <= conv_std_logic_vector(4581179,24);
            manlo <= conv_std_logic_vector(209812522,28);
           exponent <= '1';
      WHEN "1110111110" =>
            manhi <= conv_std_logic_vector(4602047,24);
            manlo <= conv_std_logic_vector(208785300,28);
           exponent <= '1';
      WHEN "1110111111" =>
            manhi <= conv_std_logic_vector(4622936,24);
            manlo <= conv_std_logic_vector(43705464,28);
           exponent <= '1';
      WHEN "1111000000" =>
            manhi <= conv_std_logic_vector(4643844,24);
            manlo <= conv_std_logic_vector(256791352,28);
           exponent <= '1';
      WHEN "1111000001" =>
            manhi <= conv_std_logic_vector(4664774,24);
            manlo <= conv_std_logic_vector(48089250,28);
           exponent <= '1';
      WHEN "1111000010" =>
            manhi <= conv_std_logic_vector(4685723,24);
            manlo <= conv_std_logic_vector(228263405,28);
           exponent <= '1';
      WHEN "1111000011" =>
            manhi <= conv_std_logic_vector(4706693,24);
            manlo <= conv_std_logic_vector(265806023,28);
           exponent <= '1';
      WHEN "1111000100" =>
            manhi <= conv_std_logic_vector(4727684,24);
            manlo <= conv_std_logic_vector(166085460,28);
           exponent <= '1';
      WHEN "1111000101" =>
            manhi <= conv_std_logic_vector(4748695,24);
            manlo <= conv_std_logic_vector(202910772,28);
           exponent <= '1';
      WHEN "1111000110" =>
            manhi <= conv_std_logic_vector(4769727,24);
            manlo <= conv_std_logic_vector(113225356,28);
           exponent <= '1';
      WHEN "1111000111" =>
            manhi <= conv_std_logic_vector(4790779,24);
            manlo <= conv_std_logic_vector(170848774,28);
           exponent <= '1';
      WHEN "1111001000" =>
            manhi <= conv_std_logic_vector(4811852,24);
            manlo <= conv_std_logic_vector(112734938,28);
           exponent <= '1';
      WHEN "1111001001" =>
            manhi <= conv_std_logic_vector(4832945,24);
            manlo <= conv_std_logic_vector(212713936,28);
           exponent <= '1';
      WHEN "1111001010" =>
            manhi <= conv_std_logic_vector(4854059,24);
            manlo <= conv_std_logic_vector(207750218,28);
           exponent <= '1';
      WHEN "1111001011" =>
            manhi <= conv_std_logic_vector(4875194,24);
            manlo <= conv_std_logic_vector(103248961,28);
           exponent <= '1';
      WHEN "1111001100" =>
            manhi <= conv_std_logic_vector(4896349,24);
            manlo <= conv_std_logic_vector(173056083,28);
           exponent <= '1';
      WHEN "1111001101" =>
            manhi <= conv_std_logic_vector(4917525,24);
            manlo <= conv_std_logic_vector(154151876,28);
           exponent <= '1';
      WHEN "1111001110" =>
            manhi <= conv_std_logic_vector(4938722,24);
            manlo <= conv_std_logic_vector(51957376,28);
           exponent <= '1';
      WHEN "1111001111" =>
            manhi <= conv_std_logic_vector(4959939,24);
            manlo <= conv_std_logic_vector(140334376,28);
           exponent <= '1';
      WHEN "1111010000" =>
            manhi <= conv_std_logic_vector(4981177,24);
            manlo <= conv_std_logic_vector(156279056,28);
           exponent <= '1';
      WHEN "1111010001" =>
            manhi <= conv_std_logic_vector(5002436,24);
            manlo <= conv_std_logic_vector(105228360,28);
           exponent <= '1';
      WHEN "1111010010" =>
            manhi <= conv_std_logic_vector(5023715,24);
            manlo <= conv_std_logic_vector(261060000,28);
           exponent <= '1';
      WHEN "1111010011" =>
            manhi <= conv_std_logic_vector(5045016,24);
            manlo <= conv_std_logic_vector(92350636,28);
           exponent <= '1';
      WHEN "1111010100" =>
            manhi <= conv_std_logic_vector(5066337,24);
            manlo <= conv_std_logic_vector(141424076,28);
           exponent <= '1';
      WHEN "1111010101" =>
            manhi <= conv_std_logic_vector(5087679,24);
            manlo <= conv_std_logic_vector(145303087,28);
           exponent <= '1';
      WHEN "1111010110" =>
            manhi <= conv_std_logic_vector(5109042,24);
            manlo <= conv_std_logic_vector(109451226,28);
           exponent <= '1';
      WHEN "1111010111" =>
            manhi <= conv_std_logic_vector(5130426,24);
            manlo <= conv_std_logic_vector(39337386,28);
           exponent <= '1';
      WHEN "1111011000" =>
            manhi <= conv_std_logic_vector(5151830,24);
            manlo <= conv_std_logic_vector(208871261,28);
           exponent <= '1';
      WHEN "1111011001" =>
            manhi <= conv_std_logic_vector(5173256,24);
            manlo <= conv_std_logic_vector(86661526,28);
           exponent <= '1';
      WHEN "1111011010" =>
            manhi <= conv_std_logic_vector(5194702,24);
            manlo <= conv_std_logic_vector(215064032,28);
           exponent <= '1';
      WHEN "1111011011" =>
            manhi <= conv_std_logic_vector(5216170,24);
            manlo <= conv_std_logic_vector(62698166,28);
           exponent <= '1';
      WHEN "1111011100" =>
            manhi <= conv_std_logic_vector(5237658,24);
            manlo <= conv_std_logic_vector(171930504,28);
           exponent <= '1';
      WHEN "1111011101" =>
            manhi <= conv_std_logic_vector(5259168,24);
            manlo <= conv_std_logic_vector(11391165,28);
           exponent <= '1';
      WHEN "1111011110" =>
            manhi <= conv_std_logic_vector(5280698,24);
            manlo <= conv_std_logic_vector(123457470,28);
           exponent <= '1';
      WHEN "1111011111" =>
            manhi <= conv_std_logic_vector(5302249,24);
            manlo <= conv_std_logic_vector(245205748,28);
           exponent <= '1';
      WHEN "1111100000" =>
            manhi <= conv_std_logic_vector(5323822,24);
            manlo <= conv_std_logic_vector(113717718,28);
           exponent <= '1';
      WHEN "1111100001" =>
            manhi <= conv_std_logic_vector(5345416,24);
            manlo <= conv_std_logic_vector(2951399,28);
           exponent <= '1';
      WHEN "1111100010" =>
            manhi <= conv_std_logic_vector(5367030,24);
            manlo <= conv_std_logic_vector(186870204,28);
           exponent <= '1';
      WHEN "1111100011" =>
            manhi <= conv_std_logic_vector(5388666,24);
            manlo <= conv_std_logic_vector(134136582,28);
           exponent <= '1';
      WHEN "1111100100" =>
            manhi <= conv_std_logic_vector(5410323,24);
            manlo <= conv_std_logic_vector(118724754,28);
           exponent <= '1';
      WHEN "1111100101" =>
            manhi <= conv_std_logic_vector(5432001,24);
            manlo <= conv_std_logic_vector(146178900,28);
           exponent <= '1';
      WHEN "1111100110" =>
            manhi <= conv_std_logic_vector(5453700,24);
            manlo <= conv_std_logic_vector(222048612,28);
           exponent <= '1';
      WHEN "1111100111" =>
            manhi <= conv_std_logic_vector(5475421,24);
            manlo <= conv_std_logic_vector(83453453,28);
           exponent <= '1';
      WHEN "1111101000" =>
            manhi <= conv_std_logic_vector(5497163,24);
            manlo <= conv_std_logic_vector(4389322,28);
           exponent <= '1';
      WHEN "1111101001" =>
            manhi <= conv_std_logic_vector(5518925,24);
            manlo <= conv_std_logic_vector(258857552,28);
           exponent <= '1';
      WHEN "1111101010" =>
            manhi <= conv_std_logic_vector(5540710,24);
            manlo <= conv_std_logic_vector(47123091,28);
           exponent <= '1';
      WHEN "1111101011" =>
            manhi <= conv_std_logic_vector(5562515,24);
            manlo <= conv_std_logic_vector(180069064,28);
           exponent <= '1';
      WHEN "1111101100" =>
            manhi <= conv_std_logic_vector(5584342,24);
            manlo <= conv_std_logic_vector(126406768,28);
           exponent <= '1';
      WHEN "1111101101" =>
            manhi <= conv_std_logic_vector(5606190,24);
            manlo <= conv_std_logic_vector(160159320,28);
           exponent <= '1';
      WHEN "1111101110" =>
            manhi <= conv_std_logic_vector(5628060,24);
            manlo <= conv_std_logic_vector(18484384,28);
           exponent <= '1';
      WHEN "1111101111" =>
            manhi <= conv_std_logic_vector(5649950,24);
            manlo <= conv_std_logic_vector(243851457,28);
           exponent <= '1';
      WHEN "1111110000" =>
            manhi <= conv_std_logic_vector(5671863,24);
            manlo <= conv_std_logic_vector(36558227,28);
           exponent <= '1';
      WHEN "1111110001" =>
            manhi <= conv_std_logic_vector(5693796,24);
            manlo <= conv_std_logic_vector(207520592,28);
           exponent <= '1';
      WHEN "1111110010" =>
            manhi <= conv_std_logic_vector(5715751,24);
            manlo <= conv_std_logic_vector(225482653,28);
           exponent <= '1';
      WHEN "1111110011" =>
            manhi <= conv_std_logic_vector(5737728,24);
            manlo <= conv_std_logic_vector(96064906,28);
           exponent <= '1';
      WHEN "1111110100" =>
            manhi <= conv_std_logic_vector(5759726,24);
            manlo <= conv_std_logic_vector(93328797,28);
           exponent <= '1';
      WHEN "1111110101" =>
            manhi <= conv_std_logic_vector(5781745,24);
            manlo <= conv_std_logic_vector(222905812,28);
           exponent <= '1';
      WHEN "1111110110" =>
            manhi <= conv_std_logic_vector(5803786,24);
            manlo <= conv_std_logic_vector(221997482,28);
           exponent <= '1';
      WHEN "1111110111" =>
            manhi <= conv_std_logic_vector(5825849,24);
            manlo <= conv_std_logic_vector(96246303,28);
           exponent <= '1';
      WHEN "1111111000" =>
            manhi <= conv_std_logic_vector(5847933,24);
            manlo <= conv_std_logic_vector(119735740,28);
           exponent <= '1';
      WHEN "1111111001" =>
            manhi <= conv_std_logic_vector(5870039,24);
            manlo <= conv_std_logic_vector(29683863,28);
           exponent <= '1';
      WHEN "1111111010" =>
            manhi <= conv_std_logic_vector(5892166,24);
            manlo <= conv_std_logic_vector(100185179,28);
           exponent <= '1';
      WHEN "1111111011" =>
            manhi <= conv_std_logic_vector(5914315,24);
            manlo <= conv_std_logic_vector(68468812,28);
           exponent <= '1';
      WHEN "1111111100" =>
            manhi <= conv_std_logic_vector(5936485,24);
            manlo <= conv_std_logic_vector(208640332,28);
           exponent <= '1';
      WHEN "1111111101" =>
            manhi <= conv_std_logic_vector(5958677,24);
            manlo <= conv_std_logic_vector(257939938,28);
           exponent <= '1';
      WHEN "1111111110" =>
            manhi <= conv_std_logic_vector(5980891,24);
            manlo <= conv_std_logic_vector(222048827,28);
           exponent <= '1';
      WHEN "1111111111" =>
            manhi <= conv_std_logic_vector(6003127,24);
            manlo <= conv_std_logic_vector(106653752,28);
           exponent <= '1';
      WHEN others =>
           manhi <= conv_std_logic_vector(0,24);
           manlo <= conv_std_logic_vector(0,28);
           exponent <= '0';
    END CASE;
  END PROCESS;

END rtl;
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_EXPLUT20.VHD                           ***
--***                                             ***
--***   Function: Look Up Table - EXP()           ***
--***                                             ***
--***   Generated by MATLAB Utility               ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_explut20 IS
PORT (
      add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
      manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
      manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1)
     );
END dp_explut20;

ARCHITECTURE rtl OF dp_explut20 IS

BEGIN

  pca: PROCESS (add)
  BEGIN
    CASE add IS
      WHEN "0000000000" =>
            manhi <= conv_std_logic_vector(0,24);
            manlo <= conv_std_logic_vector(0,28);
      WHEN "0000000001" =>
            manhi <= conv_std_logic_vector(16,24);
            manlo <= conv_std_logic_vector(2048,28);
      WHEN "0000000010" =>
            manhi <= conv_std_logic_vector(32,24);
            manlo <= conv_std_logic_vector(8192,28);
      WHEN "0000000011" =>
            manhi <= conv_std_logic_vector(48,24);
            manlo <= conv_std_logic_vector(18432,28);
      WHEN "0000000100" =>
            manhi <= conv_std_logic_vector(64,24);
            manlo <= conv_std_logic_vector(32768,28);
      WHEN "0000000101" =>
            manhi <= conv_std_logic_vector(80,24);
            manlo <= conv_std_logic_vector(51200,28);
      WHEN "0000000110" =>
            manhi <= conv_std_logic_vector(96,24);
            manlo <= conv_std_logic_vector(73728,28);
      WHEN "0000000111" =>
            manhi <= conv_std_logic_vector(112,24);
            manlo <= conv_std_logic_vector(100352,28);
      WHEN "0000001000" =>
            manhi <= conv_std_logic_vector(128,24);
            manlo <= conv_std_logic_vector(131072,28);
      WHEN "0000001001" =>
            manhi <= conv_std_logic_vector(144,24);
            manlo <= conv_std_logic_vector(165888,28);
      WHEN "0000001010" =>
            manhi <= conv_std_logic_vector(160,24);
            manlo <= conv_std_logic_vector(204801,28);
      WHEN "0000001011" =>
            manhi <= conv_std_logic_vector(176,24);
            manlo <= conv_std_logic_vector(247809,28);
      WHEN "0000001100" =>
            manhi <= conv_std_logic_vector(192,24);
            manlo <= conv_std_logic_vector(294913,28);
      WHEN "0000001101" =>
            manhi <= conv_std_logic_vector(208,24);
            manlo <= conv_std_logic_vector(346113,28);
      WHEN "0000001110" =>
            manhi <= conv_std_logic_vector(224,24);
            manlo <= conv_std_logic_vector(401410,28);
      WHEN "0000001111" =>
            manhi <= conv_std_logic_vector(240,24);
            manlo <= conv_std_logic_vector(460802,28);
      WHEN "0000010000" =>
            manhi <= conv_std_logic_vector(256,24);
            manlo <= conv_std_logic_vector(524291,28);
      WHEN "0000010001" =>
            manhi <= conv_std_logic_vector(272,24);
            manlo <= conv_std_logic_vector(591875,28);
      WHEN "0000010010" =>
            manhi <= conv_std_logic_vector(288,24);
            manlo <= conv_std_logic_vector(663556,28);
      WHEN "0000010011" =>
            manhi <= conv_std_logic_vector(304,24);
            manlo <= conv_std_logic_vector(739332,28);
      WHEN "0000010100" =>
            manhi <= conv_std_logic_vector(320,24);
            manlo <= conv_std_logic_vector(819205,28);
      WHEN "0000010101" =>
            manhi <= conv_std_logic_vector(336,24);
            manlo <= conv_std_logic_vector(903174,28);
      WHEN "0000010110" =>
            manhi <= conv_std_logic_vector(352,24);
            manlo <= conv_std_logic_vector(991239,28);
      WHEN "0000010111" =>
            manhi <= conv_std_logic_vector(368,24);
            manlo <= conv_std_logic_vector(1083400,28);
      WHEN "0000011000" =>
            manhi <= conv_std_logic_vector(384,24);
            manlo <= conv_std_logic_vector(1179657,28);
      WHEN "0000011001" =>
            manhi <= conv_std_logic_vector(400,24);
            manlo <= conv_std_logic_vector(1280010,28);
      WHEN "0000011010" =>
            manhi <= conv_std_logic_vector(416,24);
            manlo <= conv_std_logic_vector(1384459,28);
      WHEN "0000011011" =>
            manhi <= conv_std_logic_vector(432,24);
            manlo <= conv_std_logic_vector(1493005,28);
      WHEN "0000011100" =>
            manhi <= conv_std_logic_vector(448,24);
            manlo <= conv_std_logic_vector(1605646,28);
      WHEN "0000011101" =>
            manhi <= conv_std_logic_vector(464,24);
            manlo <= conv_std_logic_vector(1722384,28);
      WHEN "0000011110" =>
            manhi <= conv_std_logic_vector(480,24);
            manlo <= conv_std_logic_vector(1843218,28);
      WHEN "0000011111" =>
            manhi <= conv_std_logic_vector(496,24);
            manlo <= conv_std_logic_vector(1968147,28);
      WHEN "0000100000" =>
            manhi <= conv_std_logic_vector(512,24);
            manlo <= conv_std_logic_vector(2097173,28);
      WHEN "0000100001" =>
            manhi <= conv_std_logic_vector(528,24);
            manlo <= conv_std_logic_vector(2230295,28);
      WHEN "0000100010" =>
            manhi <= conv_std_logic_vector(544,24);
            manlo <= conv_std_logic_vector(2367514,28);
      WHEN "0000100011" =>
            manhi <= conv_std_logic_vector(560,24);
            manlo <= conv_std_logic_vector(2508828,28);
      WHEN "0000100100" =>
            manhi <= conv_std_logic_vector(576,24);
            manlo <= conv_std_logic_vector(2654238,28);
      WHEN "0000100101" =>
            manhi <= conv_std_logic_vector(592,24);
            manlo <= conv_std_logic_vector(2803745,28);
      WHEN "0000100110" =>
            manhi <= conv_std_logic_vector(608,24);
            manlo <= conv_std_logic_vector(2957348,28);
      WHEN "0000100111" =>
            manhi <= conv_std_logic_vector(624,24);
            manlo <= conv_std_logic_vector(3115047,28);
      WHEN "0000101000" =>
            manhi <= conv_std_logic_vector(640,24);
            manlo <= conv_std_logic_vector(3276842,28);
      WHEN "0000101001" =>
            manhi <= conv_std_logic_vector(656,24);
            manlo <= conv_std_logic_vector(3442733,28);
      WHEN "0000101010" =>
            manhi <= conv_std_logic_vector(672,24);
            manlo <= conv_std_logic_vector(3612720,28);
      WHEN "0000101011" =>
            manhi <= conv_std_logic_vector(688,24);
            manlo <= conv_std_logic_vector(3786804,28);
      WHEN "0000101100" =>
            manhi <= conv_std_logic_vector(704,24);
            manlo <= conv_std_logic_vector(3964983,28);
      WHEN "0000101101" =>
            manhi <= conv_std_logic_vector(720,24);
            manlo <= conv_std_logic_vector(4147259,28);
      WHEN "0000101110" =>
            manhi <= conv_std_logic_vector(736,24);
            manlo <= conv_std_logic_vector(4333631,28);
      WHEN "0000101111" =>
            manhi <= conv_std_logic_vector(752,24);
            manlo <= conv_std_logic_vector(4524100,28);
      WHEN "0000110000" =>
            manhi <= conv_std_logic_vector(768,24);
            manlo <= conv_std_logic_vector(4718664,28);
      WHEN "0000110001" =>
            manhi <= conv_std_logic_vector(784,24);
            manlo <= conv_std_logic_vector(4917325,28);
      WHEN "0000110010" =>
            manhi <= conv_std_logic_vector(800,24);
            manlo <= conv_std_logic_vector(5120081,28);
      WHEN "0000110011" =>
            manhi <= conv_std_logic_vector(816,24);
            manlo <= conv_std_logic_vector(5326934,28);
      WHEN "0000110100" =>
            manhi <= conv_std_logic_vector(832,24);
            manlo <= conv_std_logic_vector(5537884,28);
      WHEN "0000110101" =>
            manhi <= conv_std_logic_vector(848,24);
            manlo <= conv_std_logic_vector(5752929,28);
      WHEN "0000110110" =>
            manhi <= conv_std_logic_vector(864,24);
            manlo <= conv_std_logic_vector(5972071,28);
      WHEN "0000110111" =>
            manhi <= conv_std_logic_vector(880,24);
            manlo <= conv_std_logic_vector(6195308,28);
      WHEN "0000111000" =>
            manhi <= conv_std_logic_vector(896,24);
            manlo <= conv_std_logic_vector(6422642,28);
      WHEN "0000111001" =>
            manhi <= conv_std_logic_vector(912,24);
            manlo <= conv_std_logic_vector(6654073,28);
      WHEN "0000111010" =>
            manhi <= conv_std_logic_vector(928,24);
            manlo <= conv_std_logic_vector(6889599,28);
      WHEN "0000111011" =>
            manhi <= conv_std_logic_vector(944,24);
            manlo <= conv_std_logic_vector(7129222,28);
      WHEN "0000111100" =>
            manhi <= conv_std_logic_vector(960,24);
            manlo <= conv_std_logic_vector(7372941,28);
      WHEN "0000111101" =>
            manhi <= conv_std_logic_vector(976,24);
            manlo <= conv_std_logic_vector(7620756,28);
      WHEN "0000111110" =>
            manhi <= conv_std_logic_vector(992,24);
            manlo <= conv_std_logic_vector(7872667,28);
      WHEN "0000111111" =>
            manhi <= conv_std_logic_vector(1008,24);
            manlo <= conv_std_logic_vector(8128675,28);
      WHEN "0001000000" =>
            manhi <= conv_std_logic_vector(1024,24);
            manlo <= conv_std_logic_vector(8388779,28);
      WHEN "0001000001" =>
            manhi <= conv_std_logic_vector(1040,24);
            manlo <= conv_std_logic_vector(8652979,28);
      WHEN "0001000010" =>
            manhi <= conv_std_logic_vector(1056,24);
            manlo <= conv_std_logic_vector(8921275,28);
      WHEN "0001000011" =>
            manhi <= conv_std_logic_vector(1072,24);
            manlo <= conv_std_logic_vector(9193668,28);
      WHEN "0001000100" =>
            manhi <= conv_std_logic_vector(1088,24);
            manlo <= conv_std_logic_vector(9470157,28);
      WHEN "0001000101" =>
            manhi <= conv_std_logic_vector(1104,24);
            manlo <= conv_std_logic_vector(9750742,28);
      WHEN "0001000110" =>
            manhi <= conv_std_logic_vector(1120,24);
            manlo <= conv_std_logic_vector(10035423,28);
      WHEN "0001000111" =>
            manhi <= conv_std_logic_vector(1136,24);
            manlo <= conv_std_logic_vector(10324201,28);
      WHEN "0001001000" =>
            manhi <= conv_std_logic_vector(1152,24);
            manlo <= conv_std_logic_vector(10617075,28);
      WHEN "0001001001" =>
            manhi <= conv_std_logic_vector(1168,24);
            manlo <= conv_std_logic_vector(10914045,28);
      WHEN "0001001010" =>
            manhi <= conv_std_logic_vector(1184,24);
            manlo <= conv_std_logic_vector(11215112,28);
      WHEN "0001001011" =>
            manhi <= conv_std_logic_vector(1200,24);
            manlo <= conv_std_logic_vector(11520275,28);
      WHEN "0001001100" =>
            manhi <= conv_std_logic_vector(1216,24);
            manlo <= conv_std_logic_vector(11829534,28);
      WHEN "0001001101" =>
            manhi <= conv_std_logic_vector(1232,24);
            manlo <= conv_std_logic_vector(12142889,28);
      WHEN "0001001110" =>
            manhi <= conv_std_logic_vector(1248,24);
            manlo <= conv_std_logic_vector(12460341,28);
      WHEN "0001001111" =>
            manhi <= conv_std_logic_vector(1264,24);
            manlo <= conv_std_logic_vector(12781889,28);
      WHEN "0001010000" =>
            manhi <= conv_std_logic_vector(1280,24);
            manlo <= conv_std_logic_vector(13107533,28);
      WHEN "0001010001" =>
            manhi <= conv_std_logic_vector(1296,24);
            manlo <= conv_std_logic_vector(13437274,28);
      WHEN "0001010010" =>
            manhi <= conv_std_logic_vector(1312,24);
            manlo <= conv_std_logic_vector(13771111,28);
      WHEN "0001010011" =>
            manhi <= conv_std_logic_vector(1328,24);
            manlo <= conv_std_logic_vector(14109044,28);
      WHEN "0001010100" =>
            manhi <= conv_std_logic_vector(1344,24);
            manlo <= conv_std_logic_vector(14451074,28);
      WHEN "0001010101" =>
            manhi <= conv_std_logic_vector(1360,24);
            manlo <= conv_std_logic_vector(14797200,28);
      WHEN "0001010110" =>
            manhi <= conv_std_logic_vector(1376,24);
            manlo <= conv_std_logic_vector(15147422,28);
      WHEN "0001010111" =>
            manhi <= conv_std_logic_vector(1392,24);
            manlo <= conv_std_logic_vector(15501741,28);
      WHEN "0001011000" =>
            manhi <= conv_std_logic_vector(1408,24);
            manlo <= conv_std_logic_vector(15860156,28);
      WHEN "0001011001" =>
            manhi <= conv_std_logic_vector(1424,24);
            manlo <= conv_std_logic_vector(16222667,28);
      WHEN "0001011010" =>
            manhi <= conv_std_logic_vector(1440,24);
            manlo <= conv_std_logic_vector(16589275,28);
      WHEN "0001011011" =>
            manhi <= conv_std_logic_vector(1456,24);
            manlo <= conv_std_logic_vector(16959979,28);
      WHEN "0001011100" =>
            manhi <= conv_std_logic_vector(1472,24);
            manlo <= conv_std_logic_vector(17334779,28);
      WHEN "0001011101" =>
            manhi <= conv_std_logic_vector(1488,24);
            manlo <= conv_std_logic_vector(17713676,28);
      WHEN "0001011110" =>
            manhi <= conv_std_logic_vector(1504,24);
            manlo <= conv_std_logic_vector(18096669,28);
      WHEN "0001011111" =>
            manhi <= conv_std_logic_vector(1520,24);
            manlo <= conv_std_logic_vector(18483758,28);
      WHEN "0001100000" =>
            manhi <= conv_std_logic_vector(1536,24);
            manlo <= conv_std_logic_vector(18874944,28);
      WHEN "0001100001" =>
            manhi <= conv_std_logic_vector(1552,24);
            manlo <= conv_std_logic_vector(19270226,28);
      WHEN "0001100010" =>
            manhi <= conv_std_logic_vector(1568,24);
            manlo <= conv_std_logic_vector(19669605,28);
      WHEN "0001100011" =>
            manhi <= conv_std_logic_vector(1584,24);
            manlo <= conv_std_logic_vector(20073080,28);
      WHEN "0001100100" =>
            manhi <= conv_std_logic_vector(1600,24);
            manlo <= conv_std_logic_vector(20480651,28);
      WHEN "0001100101" =>
            manhi <= conv_std_logic_vector(1616,24);
            manlo <= conv_std_logic_vector(20892319,28);
      WHEN "0001100110" =>
            manhi <= conv_std_logic_vector(1632,24);
            manlo <= conv_std_logic_vector(21308083,28);
      WHEN "0001100111" =>
            manhi <= conv_std_logic_vector(1648,24);
            manlo <= conv_std_logic_vector(21727943,28);
      WHEN "0001101000" =>
            manhi <= conv_std_logic_vector(1664,24);
            manlo <= conv_std_logic_vector(22151900,28);
      WHEN "0001101001" =>
            manhi <= conv_std_logic_vector(1680,24);
            manlo <= conv_std_logic_vector(22579954,28);
      WHEN "0001101010" =>
            manhi <= conv_std_logic_vector(1696,24);
            manlo <= conv_std_logic_vector(23012103,28);
      WHEN "0001101011" =>
            manhi <= conv_std_logic_vector(1712,24);
            manlo <= conv_std_logic_vector(23448350,28);
      WHEN "0001101100" =>
            manhi <= conv_std_logic_vector(1728,24);
            manlo <= conv_std_logic_vector(23888692,28);
      WHEN "0001101101" =>
            manhi <= conv_std_logic_vector(1744,24);
            manlo <= conv_std_logic_vector(24333131,28);
      WHEN "0001101110" =>
            manhi <= conv_std_logic_vector(1760,24);
            manlo <= conv_std_logic_vector(24781667,28);
      WHEN "0001101111" =>
            manhi <= conv_std_logic_vector(1776,24);
            manlo <= conv_std_logic_vector(25234298,28);
      WHEN "0001110000" =>
            manhi <= conv_std_logic_vector(1792,24);
            manlo <= conv_std_logic_vector(25691027,28);
      WHEN "0001110001" =>
            manhi <= conv_std_logic_vector(1808,24);
            manlo <= conv_std_logic_vector(26151851,28);
      WHEN "0001110010" =>
            manhi <= conv_std_logic_vector(1824,24);
            manlo <= conv_std_logic_vector(26616773,28);
      WHEN "0001110011" =>
            manhi <= conv_std_logic_vector(1840,24);
            manlo <= conv_std_logic_vector(27085790,28);
      WHEN "0001110100" =>
            manhi <= conv_std_logic_vector(1856,24);
            manlo <= conv_std_logic_vector(27558904,28);
      WHEN "0001110101" =>
            manhi <= conv_std_logic_vector(1872,24);
            manlo <= conv_std_logic_vector(28036115,28);
      WHEN "0001110110" =>
            manhi <= conv_std_logic_vector(1888,24);
            manlo <= conv_std_logic_vector(28517422,28);
      WHEN "0001110111" =>
            manhi <= conv_std_logic_vector(1904,24);
            manlo <= conv_std_logic_vector(29002825,28);
      WHEN "0001111000" =>
            manhi <= conv_std_logic_vector(1920,24);
            manlo <= conv_std_logic_vector(29492325,28);
      WHEN "0001111001" =>
            manhi <= conv_std_logic_vector(1936,24);
            manlo <= conv_std_logic_vector(29985921,28);
      WHEN "0001111010" =>
            manhi <= conv_std_logic_vector(1952,24);
            manlo <= conv_std_logic_vector(30483614,28);
      WHEN "0001111011" =>
            manhi <= conv_std_logic_vector(1968,24);
            manlo <= conv_std_logic_vector(30985404,28);
      WHEN "0001111100" =>
            manhi <= conv_std_logic_vector(1984,24);
            manlo <= conv_std_logic_vector(31491289,28);
      WHEN "0001111101" =>
            manhi <= conv_std_logic_vector(2000,24);
            manlo <= conv_std_logic_vector(32001272,28);
      WHEN "0001111110" =>
            manhi <= conv_std_logic_vector(2016,24);
            manlo <= conv_std_logic_vector(32515350,28);
      WHEN "0001111111" =>
            manhi <= conv_std_logic_vector(2032,24);
            manlo <= conv_std_logic_vector(33033526,28);
      WHEN "0010000000" =>
            manhi <= conv_std_logic_vector(2048,24);
            manlo <= conv_std_logic_vector(33555797,28);
      WHEN "0010000001" =>
            manhi <= conv_std_logic_vector(2064,24);
            manlo <= conv_std_logic_vector(34082166,28);
      WHEN "0010000010" =>
            manhi <= conv_std_logic_vector(2080,24);
            manlo <= conv_std_logic_vector(34612630,28);
      WHEN "0010000011" =>
            manhi <= conv_std_logic_vector(2096,24);
            manlo <= conv_std_logic_vector(35147192,28);
      WHEN "0010000100" =>
            manhi <= conv_std_logic_vector(2112,24);
            manlo <= conv_std_logic_vector(35685849,28);
      WHEN "0010000101" =>
            manhi <= conv_std_logic_vector(2128,24);
            manlo <= conv_std_logic_vector(36228604,28);
      WHEN "0010000110" =>
            manhi <= conv_std_logic_vector(2144,24);
            manlo <= conv_std_logic_vector(36775455,28);
      WHEN "0010000111" =>
            manhi <= conv_std_logic_vector(2160,24);
            manlo <= conv_std_logic_vector(37326402,28);
      WHEN "0010001000" =>
            manhi <= conv_std_logic_vector(2176,24);
            manlo <= conv_std_logic_vector(37881446,28);
      WHEN "0010001001" =>
            manhi <= conv_std_logic_vector(2192,24);
            manlo <= conv_std_logic_vector(38440586,28);
      WHEN "0010001010" =>
            manhi <= conv_std_logic_vector(2208,24);
            manlo <= conv_std_logic_vector(39003823,28);
      WHEN "0010001011" =>
            manhi <= conv_std_logic_vector(2224,24);
            manlo <= conv_std_logic_vector(39571157,28);
      WHEN "0010001100" =>
            manhi <= conv_std_logic_vector(2240,24);
            manlo <= conv_std_logic_vector(40142587,28);
      WHEN "0010001101" =>
            manhi <= conv_std_logic_vector(2256,24);
            manlo <= conv_std_logic_vector(40718113,28);
      WHEN "0010001110" =>
            manhi <= conv_std_logic_vector(2272,24);
            manlo <= conv_std_logic_vector(41297736,28);
      WHEN "0010001111" =>
            manhi <= conv_std_logic_vector(2288,24);
            manlo <= conv_std_logic_vector(41881456,28);
      WHEN "0010010000" =>
            manhi <= conv_std_logic_vector(2304,24);
            manlo <= conv_std_logic_vector(42469272,28);
      WHEN "0010010001" =>
            manhi <= conv_std_logic_vector(2320,24);
            manlo <= conv_std_logic_vector(43061185,28);
      WHEN "0010010010" =>
            manhi <= conv_std_logic_vector(2336,24);
            manlo <= conv_std_logic_vector(43657194,28);
      WHEN "0010010011" =>
            manhi <= conv_std_logic_vector(2352,24);
            manlo <= conv_std_logic_vector(44257300,28);
      WHEN "0010010100" =>
            manhi <= conv_std_logic_vector(2368,24);
            manlo <= conv_std_logic_vector(44861503,28);
      WHEN "0010010101" =>
            manhi <= conv_std_logic_vector(2384,24);
            manlo <= conv_std_logic_vector(45469802,28);
      WHEN "0010010110" =>
            manhi <= conv_std_logic_vector(2400,24);
            manlo <= conv_std_logic_vector(46082197,28);
      WHEN "0010010111" =>
            manhi <= conv_std_logic_vector(2416,24);
            manlo <= conv_std_logic_vector(46698690,28);
      WHEN "0010011000" =>
            manhi <= conv_std_logic_vector(2432,24);
            manlo <= conv_std_logic_vector(47319278,28);
      WHEN "0010011001" =>
            manhi <= conv_std_logic_vector(2448,24);
            manlo <= conv_std_logic_vector(47943964,28);
      WHEN "0010011010" =>
            manhi <= conv_std_logic_vector(2464,24);
            manlo <= conv_std_logic_vector(48572746,28);
      WHEN "0010011011" =>
            manhi <= conv_std_logic_vector(2480,24);
            manlo <= conv_std_logic_vector(49205624,28);
      WHEN "0010011100" =>
            manhi <= conv_std_logic_vector(2496,24);
            manlo <= conv_std_logic_vector(49842600,28);
      WHEN "0010011101" =>
            manhi <= conv_std_logic_vector(2512,24);
            manlo <= conv_std_logic_vector(50483672,28);
      WHEN "0010011110" =>
            manhi <= conv_std_logic_vector(2528,24);
            manlo <= conv_std_logic_vector(51128840,28);
      WHEN "0010011111" =>
            manhi <= conv_std_logic_vector(2544,24);
            manlo <= conv_std_logic_vector(51778105,28);
      WHEN "0010100000" =>
            manhi <= conv_std_logic_vector(2560,24);
            manlo <= conv_std_logic_vector(52431467,28);
      WHEN "0010100001" =>
            manhi <= conv_std_logic_vector(2576,24);
            manlo <= conv_std_logic_vector(53088925,28);
      WHEN "0010100010" =>
            manhi <= conv_std_logic_vector(2592,24);
            manlo <= conv_std_logic_vector(53750480,28);
      WHEN "0010100011" =>
            manhi <= conv_std_logic_vector(2608,24);
            manlo <= conv_std_logic_vector(54416132,28);
      WHEN "0010100100" =>
            manhi <= conv_std_logic_vector(2624,24);
            manlo <= conv_std_logic_vector(55085880,28);
      WHEN "0010100101" =>
            manhi <= conv_std_logic_vector(2640,24);
            manlo <= conv_std_logic_vector(55759725,28);
      WHEN "0010100110" =>
            manhi <= conv_std_logic_vector(2656,24);
            manlo <= conv_std_logic_vector(56437666,28);
      WHEN "0010100111" =>
            manhi <= conv_std_logic_vector(2672,24);
            manlo <= conv_std_logic_vector(57119704,28);
      WHEN "0010101000" =>
            manhi <= conv_std_logic_vector(2688,24);
            manlo <= conv_std_logic_vector(57805839,28);
      WHEN "0010101001" =>
            manhi <= conv_std_logic_vector(2704,24);
            manlo <= conv_std_logic_vector(58496071,28);
      WHEN "0010101010" =>
            manhi <= conv_std_logic_vector(2720,24);
            manlo <= conv_std_logic_vector(59190399,28);
      WHEN "0010101011" =>
            manhi <= conv_std_logic_vector(2736,24);
            manlo <= conv_std_logic_vector(59888823,28);
      WHEN "0010101100" =>
            manhi <= conv_std_logic_vector(2752,24);
            manlo <= conv_std_logic_vector(60591345,28);
      WHEN "0010101101" =>
            manhi <= conv_std_logic_vector(2768,24);
            manlo <= conv_std_logic_vector(61297963,28);
      WHEN "0010101110" =>
            manhi <= conv_std_logic_vector(2784,24);
            manlo <= conv_std_logic_vector(62008678,28);
      WHEN "0010101111" =>
            manhi <= conv_std_logic_vector(2800,24);
            manlo <= conv_std_logic_vector(62723489,28);
      WHEN "0010110000" =>
            manhi <= conv_std_logic_vector(2816,24);
            manlo <= conv_std_logic_vector(63442397,28);
      WHEN "0010110001" =>
            manhi <= conv_std_logic_vector(2832,24);
            manlo <= conv_std_logic_vector(64165402,28);
      WHEN "0010110010" =>
            manhi <= conv_std_logic_vector(2848,24);
            manlo <= conv_std_logic_vector(64892504,28);
      WHEN "0010110011" =>
            manhi <= conv_std_logic_vector(2864,24);
            manlo <= conv_std_logic_vector(65623702,28);
      WHEN "0010110100" =>
            manhi <= conv_std_logic_vector(2880,24);
            manlo <= conv_std_logic_vector(66358997,28);
      WHEN "0010110101" =>
            manhi <= conv_std_logic_vector(2896,24);
            manlo <= conv_std_logic_vector(67098389,28);
      WHEN "0010110110" =>
            manhi <= conv_std_logic_vector(2912,24);
            manlo <= conv_std_logic_vector(67841877,28);
      WHEN "0010110111" =>
            manhi <= conv_std_logic_vector(2928,24);
            manlo <= conv_std_logic_vector(68589462,28);
      WHEN "0010111000" =>
            manhi <= conv_std_logic_vector(2944,24);
            manlo <= conv_std_logic_vector(69341144,28);
      WHEN "0010111001" =>
            manhi <= conv_std_logic_vector(2960,24);
            manlo <= conv_std_logic_vector(70096922,28);
      WHEN "0010111010" =>
            manhi <= conv_std_logic_vector(2976,24);
            manlo <= conv_std_logic_vector(70856798,28);
      WHEN "0010111011" =>
            manhi <= conv_std_logic_vector(2992,24);
            manlo <= conv_std_logic_vector(71620769,28);
      WHEN "0010111100" =>
            manhi <= conv_std_logic_vector(3008,24);
            manlo <= conv_std_logic_vector(72388838,28);
      WHEN "0010111101" =>
            manhi <= conv_std_logic_vector(3024,24);
            manlo <= conv_std_logic_vector(73161004,28);
      WHEN "0010111110" =>
            manhi <= conv_std_logic_vector(3040,24);
            manlo <= conv_std_logic_vector(73937266,28);
      WHEN "0010111111" =>
            manhi <= conv_std_logic_vector(3056,24);
            manlo <= conv_std_logic_vector(74717625,28);
      WHEN "0011000000" =>
            manhi <= conv_std_logic_vector(3072,24);
            manlo <= conv_std_logic_vector(75502080,28);
      WHEN "0011000001" =>
            manhi <= conv_std_logic_vector(3088,24);
            manlo <= conv_std_logic_vector(76290633,28);
      WHEN "0011000010" =>
            manhi <= conv_std_logic_vector(3104,24);
            manlo <= conv_std_logic_vector(77083282,28);
      WHEN "0011000011" =>
            manhi <= conv_std_logic_vector(3120,24);
            manlo <= conv_std_logic_vector(77880028,28);
      WHEN "0011000100" =>
            manhi <= conv_std_logic_vector(3136,24);
            manlo <= conv_std_logic_vector(78680870,28);
      WHEN "0011000101" =>
            manhi <= conv_std_logic_vector(3152,24);
            manlo <= conv_std_logic_vector(79485810,28);
      WHEN "0011000110" =>
            manhi <= conv_std_logic_vector(3168,24);
            manlo <= conv_std_logic_vector(80294846,28);
      WHEN "0011000111" =>
            manhi <= conv_std_logic_vector(3184,24);
            manlo <= conv_std_logic_vector(81107979,28);
      WHEN "0011001000" =>
            manhi <= conv_std_logic_vector(3200,24);
            manlo <= conv_std_logic_vector(81925209,28);
      WHEN "0011001001" =>
            manhi <= conv_std_logic_vector(3216,24);
            manlo <= conv_std_logic_vector(82746535,28);
      WHEN "0011001010" =>
            manhi <= conv_std_logic_vector(3232,24);
            manlo <= conv_std_logic_vector(83571958,28);
      WHEN "0011001011" =>
            manhi <= conv_std_logic_vector(3248,24);
            manlo <= conv_std_logic_vector(84401479,28);
      WHEN "0011001100" =>
            manhi <= conv_std_logic_vector(3264,24);
            manlo <= conv_std_logic_vector(85235095,28);
      WHEN "0011001101" =>
            manhi <= conv_std_logic_vector(3280,24);
            manlo <= conv_std_logic_vector(86072809,28);
      WHEN "0011001110" =>
            manhi <= conv_std_logic_vector(3296,24);
            manlo <= conv_std_logic_vector(86914620,28);
      WHEN "0011001111" =>
            manhi <= conv_std_logic_vector(3312,24);
            manlo <= conv_std_logic_vector(87760527,28);
      WHEN "0011010000" =>
            manhi <= conv_std_logic_vector(3328,24);
            manlo <= conv_std_logic_vector(88610531,28);
      WHEN "0011010001" =>
            manhi <= conv_std_logic_vector(3344,24);
            manlo <= conv_std_logic_vector(89464632,28);
      WHEN "0011010010" =>
            manhi <= conv_std_logic_vector(3360,24);
            manlo <= conv_std_logic_vector(90322830,28);
      WHEN "0011010011" =>
            manhi <= conv_std_logic_vector(3376,24);
            manlo <= conv_std_logic_vector(91185124,28);
      WHEN "0011010100" =>
            manhi <= conv_std_logic_vector(3392,24);
            manlo <= conv_std_logic_vector(92051516,28);
      WHEN "0011010101" =>
            manhi <= conv_std_logic_vector(3408,24);
            manlo <= conv_std_logic_vector(92922004,28);
      WHEN "0011010110" =>
            manhi <= conv_std_logic_vector(3424,24);
            manlo <= conv_std_logic_vector(93796589,28);
      WHEN "0011010111" =>
            manhi <= conv_std_logic_vector(3440,24);
            manlo <= conv_std_logic_vector(94675271,28);
      WHEN "0011011000" =>
            manhi <= conv_std_logic_vector(3456,24);
            manlo <= conv_std_logic_vector(95558049,28);
      WHEN "0011011001" =>
            manhi <= conv_std_logic_vector(3472,24);
            manlo <= conv_std_logic_vector(96444925,28);
      WHEN "0011011010" =>
            manhi <= conv_std_logic_vector(3488,24);
            manlo <= conv_std_logic_vector(97335897,28);
      WHEN "0011011011" =>
            manhi <= conv_std_logic_vector(3504,24);
            manlo <= conv_std_logic_vector(98230967,28);
      WHEN "0011011100" =>
            manhi <= conv_std_logic_vector(3520,24);
            manlo <= conv_std_logic_vector(99130133,28);
      WHEN "0011011101" =>
            manhi <= conv_std_logic_vector(3536,24);
            manlo <= conv_std_logic_vector(100033396,28);
      WHEN "0011011110" =>
            manhi <= conv_std_logic_vector(3552,24);
            manlo <= conv_std_logic_vector(100940755,28);
      WHEN "0011011111" =>
            manhi <= conv_std_logic_vector(3568,24);
            manlo <= conv_std_logic_vector(101852212,28);
      WHEN "0011100000" =>
            manhi <= conv_std_logic_vector(3584,24);
            manlo <= conv_std_logic_vector(102767766,28);
      WHEN "0011100001" =>
            manhi <= conv_std_logic_vector(3600,24);
            manlo <= conv_std_logic_vector(103687416,28);
      WHEN "0011100010" =>
            manhi <= conv_std_logic_vector(3616,24);
            manlo <= conv_std_logic_vector(104611163,28);
      WHEN "0011100011" =>
            manhi <= conv_std_logic_vector(3632,24);
            manlo <= conv_std_logic_vector(105539008,28);
      WHEN "0011100100" =>
            manhi <= conv_std_logic_vector(3648,24);
            manlo <= conv_std_logic_vector(106470949,28);
      WHEN "0011100101" =>
            manhi <= conv_std_logic_vector(3664,24);
            manlo <= conv_std_logic_vector(107406987,28);
      WHEN "0011100110" =>
            manhi <= conv_std_logic_vector(3680,24);
            manlo <= conv_std_logic_vector(108347122,28);
      WHEN "0011100111" =>
            manhi <= conv_std_logic_vector(3696,24);
            manlo <= conv_std_logic_vector(109291353,28);
      WHEN "0011101000" =>
            manhi <= conv_std_logic_vector(3712,24);
            manlo <= conv_std_logic_vector(110239682,28);
      WHEN "0011101001" =>
            manhi <= conv_std_logic_vector(3728,24);
            manlo <= conv_std_logic_vector(111192108,28);
      WHEN "0011101010" =>
            manhi <= conv_std_logic_vector(3744,24);
            manlo <= conv_std_logic_vector(112148630,28);
      WHEN "0011101011" =>
            manhi <= conv_std_logic_vector(3760,24);
            manlo <= conv_std_logic_vector(113109250,28);
      WHEN "0011101100" =>
            manhi <= conv_std_logic_vector(3776,24);
            manlo <= conv_std_logic_vector(114073966,28);
      WHEN "0011101101" =>
            manhi <= conv_std_logic_vector(3792,24);
            manlo <= conv_std_logic_vector(115042779,28);
      WHEN "0011101110" =>
            manhi <= conv_std_logic_vector(3808,24);
            manlo <= conv_std_logic_vector(116015689,28);
      WHEN "0011101111" =>
            manhi <= conv_std_logic_vector(3824,24);
            manlo <= conv_std_logic_vector(116992696,28);
      WHEN "0011110000" =>
            manhi <= conv_std_logic_vector(3840,24);
            manlo <= conv_std_logic_vector(117973801,28);
      WHEN "0011110001" =>
            manhi <= conv_std_logic_vector(3856,24);
            manlo <= conv_std_logic_vector(118959001,28);
      WHEN "0011110010" =>
            manhi <= conv_std_logic_vector(3872,24);
            manlo <= conv_std_logic_vector(119948299,28);
      WHEN "0011110011" =>
            manhi <= conv_std_logic_vector(3888,24);
            manlo <= conv_std_logic_vector(120941694,28);
      WHEN "0011110100" =>
            manhi <= conv_std_logic_vector(3904,24);
            manlo <= conv_std_logic_vector(121939186,28);
      WHEN "0011110101" =>
            manhi <= conv_std_logic_vector(3920,24);
            manlo <= conv_std_logic_vector(122940775,28);
      WHEN "0011110110" =>
            manhi <= conv_std_logic_vector(3936,24);
            manlo <= conv_std_logic_vector(123946461,28);
      WHEN "0011110111" =>
            manhi <= conv_std_logic_vector(3952,24);
            manlo <= conv_std_logic_vector(124956243,28);
      WHEN "0011111000" =>
            manhi <= conv_std_logic_vector(3968,24);
            manlo <= conv_std_logic_vector(125970123,28);
      WHEN "0011111001" =>
            manhi <= conv_std_logic_vector(3984,24);
            manlo <= conv_std_logic_vector(126988100,28);
      WHEN "0011111010" =>
            manhi <= conv_std_logic_vector(4000,24);
            manlo <= conv_std_logic_vector(128010173,28);
      WHEN "0011111011" =>
            manhi <= conv_std_logic_vector(4016,24);
            manlo <= conv_std_logic_vector(129036344,28);
      WHEN "0011111100" =>
            manhi <= conv_std_logic_vector(4032,24);
            manlo <= conv_std_logic_vector(130066611,28);
      WHEN "0011111101" =>
            manhi <= conv_std_logic_vector(4048,24);
            manlo <= conv_std_logic_vector(131100976,28);
      WHEN "0011111110" =>
            manhi <= conv_std_logic_vector(4064,24);
            manlo <= conv_std_logic_vector(132139437,28);
      WHEN "0011111111" =>
            manhi <= conv_std_logic_vector(4080,24);
            manlo <= conv_std_logic_vector(133181996,28);
      WHEN "0100000000" =>
            manhi <= conv_std_logic_vector(4096,24);
            manlo <= conv_std_logic_vector(134228651,28);
      WHEN "0100000001" =>
            manhi <= conv_std_logic_vector(4112,24);
            manlo <= conv_std_logic_vector(135279404,28);
      WHEN "0100000010" =>
            manhi <= conv_std_logic_vector(4128,24);
            manlo <= conv_std_logic_vector(136334253,28);
      WHEN "0100000011" =>
            manhi <= conv_std_logic_vector(4144,24);
            manlo <= conv_std_logic_vector(137393200,28);
      WHEN "0100000100" =>
            manhi <= conv_std_logic_vector(4160,24);
            manlo <= conv_std_logic_vector(138456243,28);
      WHEN "0100000101" =>
            manhi <= conv_std_logic_vector(4176,24);
            manlo <= conv_std_logic_vector(139523384,28);
      WHEN "0100000110" =>
            manhi <= conv_std_logic_vector(4192,24);
            manlo <= conv_std_logic_vector(140594622,28);
      WHEN "0100000111" =>
            manhi <= conv_std_logic_vector(4208,24);
            manlo <= conv_std_logic_vector(141669956,28);
      WHEN "0100001000" =>
            manhi <= conv_std_logic_vector(4224,24);
            manlo <= conv_std_logic_vector(142749388,28);
      WHEN "0100001001" =>
            manhi <= conv_std_logic_vector(4240,24);
            manlo <= conv_std_logic_vector(143832916,28);
      WHEN "0100001010" =>
            manhi <= conv_std_logic_vector(4256,24);
            manlo <= conv_std_logic_vector(144920542,28);
      WHEN "0100001011" =>
            manhi <= conv_std_logic_vector(4272,24);
            manlo <= conv_std_logic_vector(146012265,28);
      WHEN "0100001100" =>
            manhi <= conv_std_logic_vector(4288,24);
            manlo <= conv_std_logic_vector(147108085,28);
      WHEN "0100001101" =>
            manhi <= conv_std_logic_vector(4304,24);
            manlo <= conv_std_logic_vector(148208001,28);
      WHEN "0100001110" =>
            manhi <= conv_std_logic_vector(4320,24);
            manlo <= conv_std_logic_vector(149312015,28);
      WHEN "0100001111" =>
            manhi <= conv_std_logic_vector(4336,24);
            manlo <= conv_std_logic_vector(150420126,28);
      WHEN "0100010000" =>
            manhi <= conv_std_logic_vector(4352,24);
            manlo <= conv_std_logic_vector(151532334,28);
      WHEN "0100010001" =>
            manhi <= conv_std_logic_vector(4368,24);
            manlo <= conv_std_logic_vector(152648639,28);
      WHEN "0100010010" =>
            manhi <= conv_std_logic_vector(4384,24);
            manlo <= conv_std_logic_vector(153769041,28);
      WHEN "0100010011" =>
            manhi <= conv_std_logic_vector(4400,24);
            manlo <= conv_std_logic_vector(154893541,28);
      WHEN "0100010100" =>
            manhi <= conv_std_logic_vector(4416,24);
            manlo <= conv_std_logic_vector(156022137,28);
      WHEN "0100010101" =>
            manhi <= conv_std_logic_vector(4432,24);
            manlo <= conv_std_logic_vector(157154830,28);
      WHEN "0100010110" =>
            manhi <= conv_std_logic_vector(4448,24);
            manlo <= conv_std_logic_vector(158291621,28);
      WHEN "0100010111" =>
            manhi <= conv_std_logic_vector(4464,24);
            manlo <= conv_std_logic_vector(159432508,28);
      WHEN "0100011000" =>
            manhi <= conv_std_logic_vector(4480,24);
            manlo <= conv_std_logic_vector(160577493,28);
      WHEN "0100011001" =>
            manhi <= conv_std_logic_vector(4496,24);
            manlo <= conv_std_logic_vector(161726574,28);
      WHEN "0100011010" =>
            manhi <= conv_std_logic_vector(4512,24);
            manlo <= conv_std_logic_vector(162879753,28);
      WHEN "0100011011" =>
            manhi <= conv_std_logic_vector(4528,24);
            manlo <= conv_std_logic_vector(164037029,28);
      WHEN "0100011100" =>
            manhi <= conv_std_logic_vector(4544,24);
            manlo <= conv_std_logic_vector(165198402,28);
      WHEN "0100011101" =>
            manhi <= conv_std_logic_vector(4560,24);
            manlo <= conv_std_logic_vector(166363872,28);
      WHEN "0100011110" =>
            manhi <= conv_std_logic_vector(4576,24);
            manlo <= conv_std_logic_vector(167533439,28);
      WHEN "0100011111" =>
            manhi <= conv_std_logic_vector(4592,24);
            manlo <= conv_std_logic_vector(168707104,28);
      WHEN "0100100000" =>
            manhi <= conv_std_logic_vector(4608,24);
            manlo <= conv_std_logic_vector(169884865,28);
      WHEN "0100100001" =>
            manhi <= conv_std_logic_vector(4624,24);
            manlo <= conv_std_logic_vector(171066724,28);
      WHEN "0100100010" =>
            manhi <= conv_std_logic_vector(4640,24);
            manlo <= conv_std_logic_vector(172252679,28);
      WHEN "0100100011" =>
            manhi <= conv_std_logic_vector(4656,24);
            manlo <= conv_std_logic_vector(173442732,28);
      WHEN "0100100100" =>
            manhi <= conv_std_logic_vector(4672,24);
            manlo <= conv_std_logic_vector(174636882,28);
      WHEN "0100100101" =>
            manhi <= conv_std_logic_vector(4688,24);
            manlo <= conv_std_logic_vector(175835129,28);
      WHEN "0100100110" =>
            manhi <= conv_std_logic_vector(4704,24);
            manlo <= conv_std_logic_vector(177037474,28);
      WHEN "0100100111" =>
            manhi <= conv_std_logic_vector(4720,24);
            manlo <= conv_std_logic_vector(178243915,28);
      WHEN "0100101000" =>
            manhi <= conv_std_logic_vector(4736,24);
            manlo <= conv_std_logic_vector(179454454,28);
      WHEN "0100101001" =>
            manhi <= conv_std_logic_vector(4752,24);
            manlo <= conv_std_logic_vector(180669089,28);
      WHEN "0100101010" =>
            manhi <= conv_std_logic_vector(4768,24);
            manlo <= conv_std_logic_vector(181887822,28);
      WHEN "0100101011" =>
            manhi <= conv_std_logic_vector(4784,24);
            manlo <= conv_std_logic_vector(183110652,28);
      WHEN "0100101100" =>
            manhi <= conv_std_logic_vector(4800,24);
            manlo <= conv_std_logic_vector(184337579,28);
      WHEN "0100101101" =>
            manhi <= conv_std_logic_vector(4816,24);
            manlo <= conv_std_logic_vector(185568604,28);
      WHEN "0100101110" =>
            manhi <= conv_std_logic_vector(4832,24);
            manlo <= conv_std_logic_vector(186803725,28);
      WHEN "0100101111" =>
            manhi <= conv_std_logic_vector(4848,24);
            manlo <= conv_std_logic_vector(188042944,28);
      WHEN "0100110000" =>
            manhi <= conv_std_logic_vector(4864,24);
            manlo <= conv_std_logic_vector(189286260,28);
      WHEN "0100110001" =>
            manhi <= conv_std_logic_vector(4880,24);
            manlo <= conv_std_logic_vector(190533673,28);
      WHEN "0100110010" =>
            manhi <= conv_std_logic_vector(4896,24);
            manlo <= conv_std_logic_vector(191785183,28);
      WHEN "0100110011" =>
            manhi <= conv_std_logic_vector(4912,24);
            manlo <= conv_std_logic_vector(193040791,28);
      WHEN "0100110100" =>
            manhi <= conv_std_logic_vector(4928,24);
            manlo <= conv_std_logic_vector(194300496,28);
      WHEN "0100110101" =>
            manhi <= conv_std_logic_vector(4944,24);
            manlo <= conv_std_logic_vector(195564298,28);
      WHEN "0100110110" =>
            manhi <= conv_std_logic_vector(4960,24);
            manlo <= conv_std_logic_vector(196832197,28);
      WHEN "0100110111" =>
            manhi <= conv_std_logic_vector(4976,24);
            manlo <= conv_std_logic_vector(198104193,28);
      WHEN "0100111000" =>
            manhi <= conv_std_logic_vector(4992,24);
            manlo <= conv_std_logic_vector(199380286,28);
      WHEN "0100111001" =>
            manhi <= conv_std_logic_vector(5008,24);
            manlo <= conv_std_logic_vector(200660477,28);
      WHEN "0100111010" =>
            manhi <= conv_std_logic_vector(5024,24);
            manlo <= conv_std_logic_vector(201944765,28);
      WHEN "0100111011" =>
            manhi <= conv_std_logic_vector(5040,24);
            manlo <= conv_std_logic_vector(203233150,28);
      WHEN "0100111100" =>
            manhi <= conv_std_logic_vector(5056,24);
            manlo <= conv_std_logic_vector(204525633,28);
      WHEN "0100111101" =>
            manhi <= conv_std_logic_vector(5072,24);
            manlo <= conv_std_logic_vector(205822213,28);
      WHEN "0100111110" =>
            manhi <= conv_std_logic_vector(5088,24);
            manlo <= conv_std_logic_vector(207122889,28);
      WHEN "0100111111" =>
            manhi <= conv_std_logic_vector(5104,24);
            manlo <= conv_std_logic_vector(208427664,28);
      WHEN "0101000000" =>
            manhi <= conv_std_logic_vector(5120,24);
            manlo <= conv_std_logic_vector(209736535,28);
      WHEN "0101000001" =>
            manhi <= conv_std_logic_vector(5136,24);
            manlo <= conv_std_logic_vector(211049504,28);
      WHEN "0101000010" =>
            manhi <= conv_std_logic_vector(5152,24);
            manlo <= conv_std_logic_vector(212366570,28);
      WHEN "0101000011" =>
            manhi <= conv_std_logic_vector(5168,24);
            manlo <= conv_std_logic_vector(213687733,28);
      WHEN "0101000100" =>
            manhi <= conv_std_logic_vector(5184,24);
            manlo <= conv_std_logic_vector(215012993,28);
      WHEN "0101000101" =>
            manhi <= conv_std_logic_vector(5200,24);
            manlo <= conv_std_logic_vector(216342351,28);
      WHEN "0101000110" =>
            manhi <= conv_std_logic_vector(5216,24);
            manlo <= conv_std_logic_vector(217675806,28);
      WHEN "0101000111" =>
            manhi <= conv_std_logic_vector(5232,24);
            manlo <= conv_std_logic_vector(219013358,28);
      WHEN "0101001000" =>
            manhi <= conv_std_logic_vector(5248,24);
            manlo <= conv_std_logic_vector(220355007,28);
      WHEN "0101001001" =>
            manhi <= conv_std_logic_vector(5264,24);
            manlo <= conv_std_logic_vector(221700754,28);
      WHEN "0101001010" =>
            manhi <= conv_std_logic_vector(5280,24);
            manlo <= conv_std_logic_vector(223050598,28);
      WHEN "0101001011" =>
            manhi <= conv_std_logic_vector(5296,24);
            manlo <= conv_std_logic_vector(224404540,28);
      WHEN "0101001100" =>
            manhi <= conv_std_logic_vector(5312,24);
            manlo <= conv_std_logic_vector(225762578,28);
      WHEN "0101001101" =>
            manhi <= conv_std_logic_vector(5328,24);
            manlo <= conv_std_logic_vector(227124714,28);
      WHEN "0101001110" =>
            manhi <= conv_std_logic_vector(5344,24);
            manlo <= conv_std_logic_vector(228490948,28);
      WHEN "0101001111" =>
            manhi <= conv_std_logic_vector(5360,24);
            manlo <= conv_std_logic_vector(229861278,28);
      WHEN "0101010000" =>
            manhi <= conv_std_logic_vector(5376,24);
            manlo <= conv_std_logic_vector(231235706,28);
      WHEN "0101010001" =>
            manhi <= conv_std_logic_vector(5392,24);
            manlo <= conv_std_logic_vector(232614231,28);
      WHEN "0101010010" =>
            manhi <= conv_std_logic_vector(5408,24);
            manlo <= conv_std_logic_vector(233996854,28);
      WHEN "0101010011" =>
            manhi <= conv_std_logic_vector(5424,24);
            manlo <= conv_std_logic_vector(235383573,28);
      WHEN "0101010100" =>
            manhi <= conv_std_logic_vector(5440,24);
            manlo <= conv_std_logic_vector(236774391,28);
      WHEN "0101010101" =>
            manhi <= conv_std_logic_vector(5456,24);
            manlo <= conv_std_logic_vector(238169305,28);
      WHEN "0101010110" =>
            manhi <= conv_std_logic_vector(5472,24);
            manlo <= conv_std_logic_vector(239568317,28);
      WHEN "0101010111" =>
            manhi <= conv_std_logic_vector(5488,24);
            manlo <= conv_std_logic_vector(240971426,28);
      WHEN "0101011000" =>
            manhi <= conv_std_logic_vector(5504,24);
            manlo <= conv_std_logic_vector(242378633,28);
      WHEN "0101011001" =>
            manhi <= conv_std_logic_vector(5520,24);
            manlo <= conv_std_logic_vector(243789936,28);
      WHEN "0101011010" =>
            manhi <= conv_std_logic_vector(5536,24);
            manlo <= conv_std_logic_vector(245205338,28);
      WHEN "0101011011" =>
            manhi <= conv_std_logic_vector(5552,24);
            manlo <= conv_std_logic_vector(246624836,28);
      WHEN "0101011100" =>
            manhi <= conv_std_logic_vector(5568,24);
            manlo <= conv_std_logic_vector(248048432,28);
      WHEN "0101011101" =>
            manhi <= conv_std_logic_vector(5584,24);
            manlo <= conv_std_logic_vector(249476125,28);
      WHEN "0101011110" =>
            manhi <= conv_std_logic_vector(5600,24);
            manlo <= conv_std_logic_vector(250907916,28);
      WHEN "0101011111" =>
            manhi <= conv_std_logic_vector(5616,24);
            manlo <= conv_std_logic_vector(252343804,28);
      WHEN "0101100000" =>
            manhi <= conv_std_logic_vector(5632,24);
            manlo <= conv_std_logic_vector(253783789,28);
      WHEN "0101100001" =>
            manhi <= conv_std_logic_vector(5648,24);
            manlo <= conv_std_logic_vector(255227872,28);
      WHEN "0101100010" =>
            manhi <= conv_std_logic_vector(5664,24);
            manlo <= conv_std_logic_vector(256676052,28);
      WHEN "0101100011" =>
            manhi <= conv_std_logic_vector(5680,24);
            manlo <= conv_std_logic_vector(258128329,28);
      WHEN "0101100100" =>
            manhi <= conv_std_logic_vector(5696,24);
            manlo <= conv_std_logic_vector(259584704,28);
      WHEN "0101100101" =>
            manhi <= conv_std_logic_vector(5712,24);
            manlo <= conv_std_logic_vector(261045176,28);
      WHEN "0101100110" =>
            manhi <= conv_std_logic_vector(5728,24);
            manlo <= conv_std_logic_vector(262509746,28);
      WHEN "0101100111" =>
            manhi <= conv_std_logic_vector(5744,24);
            manlo <= conv_std_logic_vector(263978413,28);
      WHEN "0101101000" =>
            manhi <= conv_std_logic_vector(5760,24);
            manlo <= conv_std_logic_vector(265451178,28);
      WHEN "0101101001" =>
            manhi <= conv_std_logic_vector(5776,24);
            manlo <= conv_std_logic_vector(266928039,28);
      WHEN "0101101010" =>
            manhi <= conv_std_logic_vector(5792,24);
            manlo <= conv_std_logic_vector(268408999,28);
      WHEN "0101101011" =>
            manhi <= conv_std_logic_vector(5809,24);
            manlo <= conv_std_logic_vector(1458599,28);
      WHEN "0101101100" =>
            manhi <= conv_std_logic_vector(5825,24);
            manlo <= conv_std_logic_vector(2947754,28);
      WHEN "0101101101" =>
            manhi <= conv_std_logic_vector(5841,24);
            manlo <= conv_std_logic_vector(4441005,28);
      WHEN "0101101110" =>
            manhi <= conv_std_logic_vector(5857,24);
            manlo <= conv_std_logic_vector(5938354,28);
      WHEN "0101101111" =>
            manhi <= conv_std_logic_vector(5873,24);
            manlo <= conv_std_logic_vector(7439800,28);
      WHEN "0101110000" =>
            manhi <= conv_std_logic_vector(5889,24);
            manlo <= conv_std_logic_vector(8945344,28);
      WHEN "0101110001" =>
            manhi <= conv_std_logic_vector(5905,24);
            manlo <= conv_std_logic_vector(10454985,28);
      WHEN "0101110010" =>
            manhi <= conv_std_logic_vector(5921,24);
            manlo <= conv_std_logic_vector(11968724,28);
      WHEN "0101110011" =>
            manhi <= conv_std_logic_vector(5937,24);
            manlo <= conv_std_logic_vector(13486560,28);
      WHEN "0101110100" =>
            manhi <= conv_std_logic_vector(5953,24);
            manlo <= conv_std_logic_vector(15008494,28);
      WHEN "0101110101" =>
            manhi <= conv_std_logic_vector(5969,24);
            manlo <= conv_std_logic_vector(16534525,28);
      WHEN "0101110110" =>
            manhi <= conv_std_logic_vector(5985,24);
            manlo <= conv_std_logic_vector(18064653,28);
      WHEN "0101110111" =>
            manhi <= conv_std_logic_vector(6001,24);
            manlo <= conv_std_logic_vector(19598879,28);
      WHEN "0101111000" =>
            manhi <= conv_std_logic_vector(6017,24);
            manlo <= conv_std_logic_vector(21137203,28);
      WHEN "0101111001" =>
            manhi <= conv_std_logic_vector(6033,24);
            manlo <= conv_std_logic_vector(22679624,28);
      WHEN "0101111010" =>
            manhi <= conv_std_logic_vector(6049,24);
            manlo <= conv_std_logic_vector(24226142,28);
      WHEN "0101111011" =>
            manhi <= conv_std_logic_vector(6065,24);
            manlo <= conv_std_logic_vector(25776758,28);
      WHEN "0101111100" =>
            manhi <= conv_std_logic_vector(6081,24);
            manlo <= conv_std_logic_vector(27331471,28);
      WHEN "0101111101" =>
            manhi <= conv_std_logic_vector(6097,24);
            manlo <= conv_std_logic_vector(28890282,28);
      WHEN "0101111110" =>
            manhi <= conv_std_logic_vector(6113,24);
            manlo <= conv_std_logic_vector(30453190,28);
      WHEN "0101111111" =>
            manhi <= conv_std_logic_vector(6129,24);
            manlo <= conv_std_logic_vector(32020196,28);
      WHEN "0110000000" =>
            manhi <= conv_std_logic_vector(6145,24);
            manlo <= conv_std_logic_vector(33591299,28);
      WHEN "0110000001" =>
            manhi <= conv_std_logic_vector(6161,24);
            manlo <= conv_std_logic_vector(35166500,28);
      WHEN "0110000010" =>
            manhi <= conv_std_logic_vector(6177,24);
            manlo <= conv_std_logic_vector(36745798,28);
      WHEN "0110000011" =>
            manhi <= conv_std_logic_vector(6193,24);
            manlo <= conv_std_logic_vector(38329194,28);
      WHEN "0110000100" =>
            manhi <= conv_std_logic_vector(6209,24);
            manlo <= conv_std_logic_vector(39916688,28);
      WHEN "0110000101" =>
            manhi <= conv_std_logic_vector(6225,24);
            manlo <= conv_std_logic_vector(41508278,28);
      WHEN "0110000110" =>
            manhi <= conv_std_logic_vector(6241,24);
            manlo <= conv_std_logic_vector(43103967,28);
      WHEN "0110000111" =>
            manhi <= conv_std_logic_vector(6257,24);
            manlo <= conv_std_logic_vector(44703753,28);
      WHEN "0110001000" =>
            manhi <= conv_std_logic_vector(6273,24);
            manlo <= conv_std_logic_vector(46307636,28);
      WHEN "0110001001" =>
            manhi <= conv_std_logic_vector(6289,24);
            manlo <= conv_std_logic_vector(47915617,28);
      WHEN "0110001010" =>
            manhi <= conv_std_logic_vector(6305,24);
            manlo <= conv_std_logic_vector(49527695,28);
      WHEN "0110001011" =>
            manhi <= conv_std_logic_vector(6321,24);
            manlo <= conv_std_logic_vector(51143871,28);
      WHEN "0110001100" =>
            manhi <= conv_std_logic_vector(6337,24);
            manlo <= conv_std_logic_vector(52764145,28);
      WHEN "0110001101" =>
            manhi <= conv_std_logic_vector(6353,24);
            manlo <= conv_std_logic_vector(54388516,28);
      WHEN "0110001110" =>
            manhi <= conv_std_logic_vector(6369,24);
            manlo <= conv_std_logic_vector(56016985,28);
      WHEN "0110001111" =>
            manhi <= conv_std_logic_vector(6385,24);
            manlo <= conv_std_logic_vector(57649551,28);
      WHEN "0110010000" =>
            manhi <= conv_std_logic_vector(6401,24);
            manlo <= conv_std_logic_vector(59286215,28);
      WHEN "0110010001" =>
            manhi <= conv_std_logic_vector(6417,24);
            manlo <= conv_std_logic_vector(60926976,28);
      WHEN "0110010010" =>
            manhi <= conv_std_logic_vector(6433,24);
            manlo <= conv_std_logic_vector(62571835,28);
      WHEN "0110010011" =>
            manhi <= conv_std_logic_vector(6449,24);
            manlo <= conv_std_logic_vector(64220791,28);
      WHEN "0110010100" =>
            manhi <= conv_std_logic_vector(6465,24);
            manlo <= conv_std_logic_vector(65873845,28);
      WHEN "0110010101" =>
            manhi <= conv_std_logic_vector(6481,24);
            manlo <= conv_std_logic_vector(67530997,28);
      WHEN "0110010110" =>
            manhi <= conv_std_logic_vector(6497,24);
            manlo <= conv_std_logic_vector(69192246,28);
      WHEN "0110010111" =>
            manhi <= conv_std_logic_vector(6513,24);
            manlo <= conv_std_logic_vector(70857593,28);
      WHEN "0110011000" =>
            manhi <= conv_std_logic_vector(6529,24);
            manlo <= conv_std_logic_vector(72527037,28);
      WHEN "0110011001" =>
            manhi <= conv_std_logic_vector(6545,24);
            manlo <= conv_std_logic_vector(74200579,28);
      WHEN "0110011010" =>
            manhi <= conv_std_logic_vector(6561,24);
            manlo <= conv_std_logic_vector(75878219,28);
      WHEN "0110011011" =>
            manhi <= conv_std_logic_vector(6577,24);
            manlo <= conv_std_logic_vector(77559956,28);
      WHEN "0110011100" =>
            manhi <= conv_std_logic_vector(6593,24);
            manlo <= conv_std_logic_vector(79245791,28);
      WHEN "0110011101" =>
            manhi <= conv_std_logic_vector(6609,24);
            manlo <= conv_std_logic_vector(80935723,28);
      WHEN "0110011110" =>
            manhi <= conv_std_logic_vector(6625,24);
            manlo <= conv_std_logic_vector(82629753,28);
      WHEN "0110011111" =>
            manhi <= conv_std_logic_vector(6641,24);
            manlo <= conv_std_logic_vector(84327881,28);
      WHEN "0110100000" =>
            manhi <= conv_std_logic_vector(6657,24);
            manlo <= conv_std_logic_vector(86030106,28);
      WHEN "0110100001" =>
            manhi <= conv_std_logic_vector(6673,24);
            manlo <= conv_std_logic_vector(87736429,28);
      WHEN "0110100010" =>
            manhi <= conv_std_logic_vector(6689,24);
            manlo <= conv_std_logic_vector(89446849,28);
      WHEN "0110100011" =>
            manhi <= conv_std_logic_vector(6705,24);
            manlo <= conv_std_logic_vector(91161367,28);
      WHEN "0110100100" =>
            manhi <= conv_std_logic_vector(6721,24);
            manlo <= conv_std_logic_vector(92879983,28);
      WHEN "0110100101" =>
            manhi <= conv_std_logic_vector(6737,24);
            manlo <= conv_std_logic_vector(94602697,28);
      WHEN "0110100110" =>
            manhi <= conv_std_logic_vector(6753,24);
            manlo <= conv_std_logic_vector(96329508,28);
      WHEN "0110100111" =>
            manhi <= conv_std_logic_vector(6769,24);
            manlo <= conv_std_logic_vector(98060416,28);
      WHEN "0110101000" =>
            manhi <= conv_std_logic_vector(6785,24);
            manlo <= conv_std_logic_vector(99795423,28);
      WHEN "0110101001" =>
            manhi <= conv_std_logic_vector(6801,24);
            manlo <= conv_std_logic_vector(101534527,28);
      WHEN "0110101010" =>
            manhi <= conv_std_logic_vector(6817,24);
            manlo <= conv_std_logic_vector(103277728,28);
      WHEN "0110101011" =>
            manhi <= conv_std_logic_vector(6833,24);
            manlo <= conv_std_logic_vector(105025028,28);
      WHEN "0110101100" =>
            manhi <= conv_std_logic_vector(6849,24);
            manlo <= conv_std_logic_vector(106776425,28);
      WHEN "0110101101" =>
            manhi <= conv_std_logic_vector(6865,24);
            manlo <= conv_std_logic_vector(108531919,28);
      WHEN "0110101110" =>
            manhi <= conv_std_logic_vector(6881,24);
            manlo <= conv_std_logic_vector(110291512,28);
      WHEN "0110101111" =>
            manhi <= conv_std_logic_vector(6897,24);
            manlo <= conv_std_logic_vector(112055202,28);
      WHEN "0110110000" =>
            manhi <= conv_std_logic_vector(6913,24);
            manlo <= conv_std_logic_vector(113822989,28);
      WHEN "0110110001" =>
            manhi <= conv_std_logic_vector(6929,24);
            manlo <= conv_std_logic_vector(115594875,28);
      WHEN "0110110010" =>
            manhi <= conv_std_logic_vector(6945,24);
            manlo <= conv_std_logic_vector(117370858,28);
      WHEN "0110110011" =>
            manhi <= conv_std_logic_vector(6961,24);
            manlo <= conv_std_logic_vector(119150939,28);
      WHEN "0110110100" =>
            manhi <= conv_std_logic_vector(6977,24);
            manlo <= conv_std_logic_vector(120935117,28);
      WHEN "0110110101" =>
            manhi <= conv_std_logic_vector(6993,24);
            manlo <= conv_std_logic_vector(122723393,28);
      WHEN "0110110110" =>
            manhi <= conv_std_logic_vector(7009,24);
            manlo <= conv_std_logic_vector(124515767,28);
      WHEN "0110110111" =>
            manhi <= conv_std_logic_vector(7025,24);
            manlo <= conv_std_logic_vector(126312239,28);
      WHEN "0110111000" =>
            manhi <= conv_std_logic_vector(7041,24);
            manlo <= conv_std_logic_vector(128112808,28);
      WHEN "0110111001" =>
            manhi <= conv_std_logic_vector(7057,24);
            manlo <= conv_std_logic_vector(129917475,28);
      WHEN "0110111010" =>
            manhi <= conv_std_logic_vector(7073,24);
            manlo <= conv_std_logic_vector(131726240,28);
      WHEN "0110111011" =>
            manhi <= conv_std_logic_vector(7089,24);
            manlo <= conv_std_logic_vector(133539102,28);
      WHEN "0110111100" =>
            manhi <= conv_std_logic_vector(7105,24);
            manlo <= conv_std_logic_vector(135356063,28);
      WHEN "0110111101" =>
            manhi <= conv_std_logic_vector(7121,24);
            manlo <= conv_std_logic_vector(137177121,28);
      WHEN "0110111110" =>
            manhi <= conv_std_logic_vector(7137,24);
            manlo <= conv_std_logic_vector(139002276,28);
      WHEN "0110111111" =>
            manhi <= conv_std_logic_vector(7153,24);
            manlo <= conv_std_logic_vector(140831530,28);
      WHEN "0111000000" =>
            manhi <= conv_std_logic_vector(7169,24);
            manlo <= conv_std_logic_vector(142664881,28);
      WHEN "0111000001" =>
            manhi <= conv_std_logic_vector(7185,24);
            manlo <= conv_std_logic_vector(144502330,28);
      WHEN "0111000010" =>
            manhi <= conv_std_logic_vector(7201,24);
            manlo <= conv_std_logic_vector(146343877,28);
      WHEN "0111000011" =>
            manhi <= conv_std_logic_vector(7217,24);
            manlo <= conv_std_logic_vector(148189521,28);
      WHEN "0111000100" =>
            manhi <= conv_std_logic_vector(7233,24);
            manlo <= conv_std_logic_vector(150039263,28);
      WHEN "0111000101" =>
            manhi <= conv_std_logic_vector(7249,24);
            manlo <= conv_std_logic_vector(151893103,28);
      WHEN "0111000110" =>
            manhi <= conv_std_logic_vector(7265,24);
            manlo <= conv_std_logic_vector(153751041,28);
      WHEN "0111000111" =>
            manhi <= conv_std_logic_vector(7281,24);
            manlo <= conv_std_logic_vector(155613076,28);
      WHEN "0111001000" =>
            manhi <= conv_std_logic_vector(7297,24);
            manlo <= conv_std_logic_vector(157479210,28);
      WHEN "0111001001" =>
            manhi <= conv_std_logic_vector(7313,24);
            manlo <= conv_std_logic_vector(159349441,28);
      WHEN "0111001010" =>
            manhi <= conv_std_logic_vector(7329,24);
            manlo <= conv_std_logic_vector(161223770,28);
      WHEN "0111001011" =>
            manhi <= conv_std_logic_vector(7345,24);
            manlo <= conv_std_logic_vector(163102196,28);
      WHEN "0111001100" =>
            manhi <= conv_std_logic_vector(7361,24);
            manlo <= conv_std_logic_vector(164984721,28);
      WHEN "0111001101" =>
            manhi <= conv_std_logic_vector(7377,24);
            manlo <= conv_std_logic_vector(166871343,28);
      WHEN "0111001110" =>
            manhi <= conv_std_logic_vector(7393,24);
            manlo <= conv_std_logic_vector(168762063,28);
      WHEN "0111001111" =>
            manhi <= conv_std_logic_vector(7409,24);
            manlo <= conv_std_logic_vector(170656881,28);
      WHEN "0111010000" =>
            manhi <= conv_std_logic_vector(7425,24);
            manlo <= conv_std_logic_vector(172555797,28);
      WHEN "0111010001" =>
            manhi <= conv_std_logic_vector(7441,24);
            manlo <= conv_std_logic_vector(174458810,28);
      WHEN "0111010010" =>
            manhi <= conv_std_logic_vector(7457,24);
            manlo <= conv_std_logic_vector(176365921,28);
      WHEN "0111010011" =>
            manhi <= conv_std_logic_vector(7473,24);
            manlo <= conv_std_logic_vector(178277130,28);
      WHEN "0111010100" =>
            manhi <= conv_std_logic_vector(7489,24);
            manlo <= conv_std_logic_vector(180192437,28);
      WHEN "0111010101" =>
            manhi <= conv_std_logic_vector(7505,24);
            manlo <= conv_std_logic_vector(182111842,28);
      WHEN "0111010110" =>
            manhi <= conv_std_logic_vector(7521,24);
            manlo <= conv_std_logic_vector(184035345,28);
      WHEN "0111010111" =>
            manhi <= conv_std_logic_vector(7537,24);
            manlo <= conv_std_logic_vector(185962945,28);
      WHEN "0111011000" =>
            manhi <= conv_std_logic_vector(7553,24);
            manlo <= conv_std_logic_vector(187894643,28);
      WHEN "0111011001" =>
            manhi <= conv_std_logic_vector(7569,24);
            manlo <= conv_std_logic_vector(189830439,28);
      WHEN "0111011010" =>
            manhi <= conv_std_logic_vector(7585,24);
            manlo <= conv_std_logic_vector(191770333,28);
      WHEN "0111011011" =>
            manhi <= conv_std_logic_vector(7601,24);
            manlo <= conv_std_logic_vector(193714325,28);
      WHEN "0111011100" =>
            manhi <= conv_std_logic_vector(7617,24);
            manlo <= conv_std_logic_vector(195662415,28);
      WHEN "0111011101" =>
            manhi <= conv_std_logic_vector(7633,24);
            manlo <= conv_std_logic_vector(197614602,28);
      WHEN "0111011110" =>
            manhi <= conv_std_logic_vector(7649,24);
            manlo <= conv_std_logic_vector(199570888,28);
      WHEN "0111011111" =>
            manhi <= conv_std_logic_vector(7665,24);
            manlo <= conv_std_logic_vector(201531271,28);
      WHEN "0111100000" =>
            manhi <= conv_std_logic_vector(7681,24);
            manlo <= conv_std_logic_vector(203495752,28);
      WHEN "0111100001" =>
            manhi <= conv_std_logic_vector(7697,24);
            manlo <= conv_std_logic_vector(205464331,28);
      WHEN "0111100010" =>
            manhi <= conv_std_logic_vector(7713,24);
            manlo <= conv_std_logic_vector(207437008,28);
      WHEN "0111100011" =>
            manhi <= conv_std_logic_vector(7729,24);
            manlo <= conv_std_logic_vector(209413783,28);
      WHEN "0111100100" =>
            manhi <= conv_std_logic_vector(7745,24);
            manlo <= conv_std_logic_vector(211394656,28);
      WHEN "0111100101" =>
            manhi <= conv_std_logic_vector(7761,24);
            manlo <= conv_std_logic_vector(213379626,28);
      WHEN "0111100110" =>
            manhi <= conv_std_logic_vector(7777,24);
            manlo <= conv_std_logic_vector(215368695,28);
      WHEN "0111100111" =>
            manhi <= conv_std_logic_vector(7793,24);
            manlo <= conv_std_logic_vector(217361861,28);
      WHEN "0111101000" =>
            manhi <= conv_std_logic_vector(7809,24);
            manlo <= conv_std_logic_vector(219359125,28);
      WHEN "0111101001" =>
            manhi <= conv_std_logic_vector(7825,24);
            manlo <= conv_std_logic_vector(221360487,28);
      WHEN "0111101010" =>
            manhi <= conv_std_logic_vector(7841,24);
            manlo <= conv_std_logic_vector(223365947,28);
      WHEN "0111101011" =>
            manhi <= conv_std_logic_vector(7857,24);
            manlo <= conv_std_logic_vector(225375505,28);
      WHEN "0111101100" =>
            manhi <= conv_std_logic_vector(7873,24);
            manlo <= conv_std_logic_vector(227389161,28);
      WHEN "0111101101" =>
            manhi <= conv_std_logic_vector(7889,24);
            manlo <= conv_std_logic_vector(229406915,28);
      WHEN "0111101110" =>
            manhi <= conv_std_logic_vector(7905,24);
            manlo <= conv_std_logic_vector(231428767,28);
      WHEN "0111101111" =>
            manhi <= conv_std_logic_vector(7921,24);
            manlo <= conv_std_logic_vector(233454716,28);
      WHEN "0111110000" =>
            manhi <= conv_std_logic_vector(7937,24);
            manlo <= conv_std_logic_vector(235484764,28);
      WHEN "0111110001" =>
            manhi <= conv_std_logic_vector(7953,24);
            manlo <= conv_std_logic_vector(237518910,28);
      WHEN "0111110010" =>
            manhi <= conv_std_logic_vector(7969,24);
            manlo <= conv_std_logic_vector(239557153,28);
      WHEN "0111110011" =>
            manhi <= conv_std_logic_vector(7985,24);
            manlo <= conv_std_logic_vector(241599495,28);
      WHEN "0111110100" =>
            manhi <= conv_std_logic_vector(8001,24);
            manlo <= conv_std_logic_vector(243645934,28);
      WHEN "0111110101" =>
            manhi <= conv_std_logic_vector(8017,24);
            manlo <= conv_std_logic_vector(245696471,28);
      WHEN "0111110110" =>
            manhi <= conv_std_logic_vector(8033,24);
            manlo <= conv_std_logic_vector(247751107,28);
      WHEN "0111110111" =>
            manhi <= conv_std_logic_vector(8049,24);
            manlo <= conv_std_logic_vector(249809840,28);
      WHEN "0111111000" =>
            manhi <= conv_std_logic_vector(8065,24);
            manlo <= conv_std_logic_vector(251872671,28);
      WHEN "0111111001" =>
            manhi <= conv_std_logic_vector(8081,24);
            manlo <= conv_std_logic_vector(253939600,28);
      WHEN "0111111010" =>
            manhi <= conv_std_logic_vector(8097,24);
            manlo <= conv_std_logic_vector(256010627,28);
      WHEN "0111111011" =>
            manhi <= conv_std_logic_vector(8113,24);
            manlo <= conv_std_logic_vector(258085753,28);
      WHEN "0111111100" =>
            manhi <= conv_std_logic_vector(8129,24);
            manlo <= conv_std_logic_vector(260164976,28);
      WHEN "0111111101" =>
            manhi <= conv_std_logic_vector(8145,24);
            manlo <= conv_std_logic_vector(262248297,28);
      WHEN "0111111110" =>
            manhi <= conv_std_logic_vector(8161,24);
            manlo <= conv_std_logic_vector(264335716,28);
      WHEN "0111111111" =>
            manhi <= conv_std_logic_vector(8177,24);
            manlo <= conv_std_logic_vector(266427233,28);
      WHEN "1000000000" =>
            manhi <= conv_std_logic_vector(8194,24);
            manlo <= conv_std_logic_vector(87392,28);
      WHEN "1000000001" =>
            manhi <= conv_std_logic_vector(8210,24);
            manlo <= conv_std_logic_vector(2187105,28);
      WHEN "1000000010" =>
            manhi <= conv_std_logic_vector(8226,24);
            manlo <= conv_std_logic_vector(4290916,28);
      WHEN "1000000011" =>
            manhi <= conv_std_logic_vector(8242,24);
            manlo <= conv_std_logic_vector(6398825,28);
      WHEN "1000000100" =>
            manhi <= conv_std_logic_vector(8258,24);
            manlo <= conv_std_logic_vector(8510832,28);
      WHEN "1000000101" =>
            manhi <= conv_std_logic_vector(8274,24);
            manlo <= conv_std_logic_vector(10626938,28);
      WHEN "1000000110" =>
            manhi <= conv_std_logic_vector(8290,24);
            manlo <= conv_std_logic_vector(12747141,28);
      WHEN "1000000111" =>
            manhi <= conv_std_logic_vector(8306,24);
            manlo <= conv_std_logic_vector(14871442,28);
      WHEN "1000001000" =>
            manhi <= conv_std_logic_vector(8322,24);
            manlo <= conv_std_logic_vector(16999841,28);
      WHEN "1000001001" =>
            manhi <= conv_std_logic_vector(8338,24);
            manlo <= conv_std_logic_vector(19132338,28);
      WHEN "1000001010" =>
            manhi <= conv_std_logic_vector(8354,24);
            manlo <= conv_std_logic_vector(21268934,28);
      WHEN "1000001011" =>
            manhi <= conv_std_logic_vector(8370,24);
            manlo <= conv_std_logic_vector(23409627,28);
      WHEN "1000001100" =>
            manhi <= conv_std_logic_vector(8386,24);
            manlo <= conv_std_logic_vector(25554418,28);
      WHEN "1000001101" =>
            manhi <= conv_std_logic_vector(8402,24);
            manlo <= conv_std_logic_vector(27703308,28);
      WHEN "1000001110" =>
            manhi <= conv_std_logic_vector(8418,24);
            manlo <= conv_std_logic_vector(29856295,28);
      WHEN "1000001111" =>
            manhi <= conv_std_logic_vector(8434,24);
            manlo <= conv_std_logic_vector(32013381,28);
      WHEN "1000010000" =>
            manhi <= conv_std_logic_vector(8450,24);
            manlo <= conv_std_logic_vector(34174564,28);
      WHEN "1000010001" =>
            manhi <= conv_std_logic_vector(8466,24);
            manlo <= conv_std_logic_vector(36339846,28);
      WHEN "1000010010" =>
            manhi <= conv_std_logic_vector(8482,24);
            manlo <= conv_std_logic_vector(38509225,28);
      WHEN "1000010011" =>
            manhi <= conv_std_logic_vector(8498,24);
            manlo <= conv_std_logic_vector(40682703,28);
      WHEN "1000010100" =>
            manhi <= conv_std_logic_vector(8514,24);
            manlo <= conv_std_logic_vector(42860279,28);
      WHEN "1000010101" =>
            manhi <= conv_std_logic_vector(8530,24);
            manlo <= conv_std_logic_vector(45041953,28);
      WHEN "1000010110" =>
            manhi <= conv_std_logic_vector(8546,24);
            manlo <= conv_std_logic_vector(47227725,28);
      WHEN "1000010111" =>
            manhi <= conv_std_logic_vector(8562,24);
            manlo <= conv_std_logic_vector(49417595,28);
      WHEN "1000011000" =>
            manhi <= conv_std_logic_vector(8578,24);
            manlo <= conv_std_logic_vector(51611563,28);
      WHEN "1000011001" =>
            manhi <= conv_std_logic_vector(8594,24);
            manlo <= conv_std_logic_vector(53809629,28);
      WHEN "1000011010" =>
            manhi <= conv_std_logic_vector(8610,24);
            manlo <= conv_std_logic_vector(56011794,28);
      WHEN "1000011011" =>
            manhi <= conv_std_logic_vector(8626,24);
            manlo <= conv_std_logic_vector(58218056,28);
      WHEN "1000011100" =>
            manhi <= conv_std_logic_vector(8642,24);
            manlo <= conv_std_logic_vector(60428417,28);
      WHEN "1000011101" =>
            manhi <= conv_std_logic_vector(8658,24);
            manlo <= conv_std_logic_vector(62642876,28);
      WHEN "1000011110" =>
            manhi <= conv_std_logic_vector(8674,24);
            manlo <= conv_std_logic_vector(64861432,28);
      WHEN "1000011111" =>
            manhi <= conv_std_logic_vector(8690,24);
            manlo <= conv_std_logic_vector(67084087,28);
      WHEN "1000100000" =>
            manhi <= conv_std_logic_vector(8706,24);
            manlo <= conv_std_logic_vector(69310840,28);
      WHEN "1000100001" =>
            manhi <= conv_std_logic_vector(8722,24);
            manlo <= conv_std_logic_vector(71541691,28);
      WHEN "1000100010" =>
            manhi <= conv_std_logic_vector(8738,24);
            manlo <= conv_std_logic_vector(73776641,28);
      WHEN "1000100011" =>
            manhi <= conv_std_logic_vector(8754,24);
            manlo <= conv_std_logic_vector(76015688,28);
      WHEN "1000100100" =>
            manhi <= conv_std_logic_vector(8770,24);
            manlo <= conv_std_logic_vector(78258834,28);
      WHEN "1000100101" =>
            manhi <= conv_std_logic_vector(8786,24);
            manlo <= conv_std_logic_vector(80506077,28);
      WHEN "1000100110" =>
            manhi <= conv_std_logic_vector(8802,24);
            manlo <= conv_std_logic_vector(82757419,28);
      WHEN "1000100111" =>
            manhi <= conv_std_logic_vector(8818,24);
            manlo <= conv_std_logic_vector(85012859,28);
      WHEN "1000101000" =>
            manhi <= conv_std_logic_vector(8834,24);
            manlo <= conv_std_logic_vector(87272397,28);
      WHEN "1000101001" =>
            manhi <= conv_std_logic_vector(8850,24);
            manlo <= conv_std_logic_vector(89536034,28);
      WHEN "1000101010" =>
            manhi <= conv_std_logic_vector(8866,24);
            manlo <= conv_std_logic_vector(91803768,28);
      WHEN "1000101011" =>
            manhi <= conv_std_logic_vector(8882,24);
            manlo <= conv_std_logic_vector(94075601,28);
      WHEN "1000101100" =>
            manhi <= conv_std_logic_vector(8898,24);
            manlo <= conv_std_logic_vector(96351532,28);
      WHEN "1000101101" =>
            manhi <= conv_std_logic_vector(8914,24);
            manlo <= conv_std_logic_vector(98631561,28);
      WHEN "1000101110" =>
            manhi <= conv_std_logic_vector(8930,24);
            manlo <= conv_std_logic_vector(100915688,28);
      WHEN "1000101111" =>
            manhi <= conv_std_logic_vector(8946,24);
            manlo <= conv_std_logic_vector(103203913,28);
      WHEN "1000110000" =>
            manhi <= conv_std_logic_vector(8962,24);
            manlo <= conv_std_logic_vector(105496237,28);
      WHEN "1000110001" =>
            manhi <= conv_std_logic_vector(8978,24);
            manlo <= conv_std_logic_vector(107792658,28);
      WHEN "1000110010" =>
            manhi <= conv_std_logic_vector(8994,24);
            manlo <= conv_std_logic_vector(110093178,28);
      WHEN "1000110011" =>
            manhi <= conv_std_logic_vector(9010,24);
            manlo <= conv_std_logic_vector(112397796,28);
      WHEN "1000110100" =>
            manhi <= conv_std_logic_vector(9026,24);
            manlo <= conv_std_logic_vector(114706513,28);
      WHEN "1000110101" =>
            manhi <= conv_std_logic_vector(9042,24);
            manlo <= conv_std_logic_vector(117019327,28);
      WHEN "1000110110" =>
            manhi <= conv_std_logic_vector(9058,24);
            manlo <= conv_std_logic_vector(119336240,28);
      WHEN "1000110111" =>
            manhi <= conv_std_logic_vector(9074,24);
            manlo <= conv_std_logic_vector(121657251,28);
      WHEN "1000111000" =>
            manhi <= conv_std_logic_vector(9090,24);
            manlo <= conv_std_logic_vector(123982360,28);
      WHEN "1000111001" =>
            manhi <= conv_std_logic_vector(9106,24);
            manlo <= conv_std_logic_vector(126311567,28);
      WHEN "1000111010" =>
            manhi <= conv_std_logic_vector(9122,24);
            manlo <= conv_std_logic_vector(128644873,28);
      WHEN "1000111011" =>
            manhi <= conv_std_logic_vector(9138,24);
            manlo <= conv_std_logic_vector(130982277,28);
      WHEN "1000111100" =>
            manhi <= conv_std_logic_vector(9154,24);
            manlo <= conv_std_logic_vector(133323779,28);
      WHEN "1000111101" =>
            manhi <= conv_std_logic_vector(9170,24);
            manlo <= conv_std_logic_vector(135669379,28);
      WHEN "1000111110" =>
            manhi <= conv_std_logic_vector(9186,24);
            manlo <= conv_std_logic_vector(138019077,28);
      WHEN "1000111111" =>
            manhi <= conv_std_logic_vector(9202,24);
            manlo <= conv_std_logic_vector(140372874,28);
      WHEN "1001000000" =>
            manhi <= conv_std_logic_vector(9218,24);
            manlo <= conv_std_logic_vector(142730769,28);
      WHEN "1001000001" =>
            manhi <= conv_std_logic_vector(9234,24);
            manlo <= conv_std_logic_vector(145092762,28);
      WHEN "1001000010" =>
            manhi <= conv_std_logic_vector(9250,24);
            manlo <= conv_std_logic_vector(147458854,28);
      WHEN "1001000011" =>
            manhi <= conv_std_logic_vector(9266,24);
            manlo <= conv_std_logic_vector(149829044,28);
      WHEN "1001000100" =>
            manhi <= conv_std_logic_vector(9282,24);
            manlo <= conv_std_logic_vector(152203332,28);
      WHEN "1001000101" =>
            manhi <= conv_std_logic_vector(9298,24);
            manlo <= conv_std_logic_vector(154581718,28);
      WHEN "1001000110" =>
            manhi <= conv_std_logic_vector(9314,24);
            manlo <= conv_std_logic_vector(156964202,28);
      WHEN "1001000111" =>
            manhi <= conv_std_logic_vector(9330,24);
            manlo <= conv_std_logic_vector(159350785,28);
      WHEN "1001001000" =>
            manhi <= conv_std_logic_vector(9346,24);
            manlo <= conv_std_logic_vector(161741466,28);
      WHEN "1001001001" =>
            manhi <= conv_std_logic_vector(9362,24);
            manlo <= conv_std_logic_vector(164136246,28);
      WHEN "1001001010" =>
            manhi <= conv_std_logic_vector(9378,24);
            manlo <= conv_std_logic_vector(166535123,28);
      WHEN "1001001011" =>
            manhi <= conv_std_logic_vector(9394,24);
            manlo <= conv_std_logic_vector(168938099,28);
      WHEN "1001001100" =>
            manhi <= conv_std_logic_vector(9410,24);
            manlo <= conv_std_logic_vector(171345174,28);
      WHEN "1001001101" =>
            manhi <= conv_std_logic_vector(9426,24);
            manlo <= conv_std_logic_vector(173756346,28);
      WHEN "1001001110" =>
            manhi <= conv_std_logic_vector(9442,24);
            manlo <= conv_std_logic_vector(176171617,28);
      WHEN "1001001111" =>
            manhi <= conv_std_logic_vector(9458,24);
            manlo <= conv_std_logic_vector(178590986,28);
      WHEN "1001010000" =>
            manhi <= conv_std_logic_vector(9474,24);
            manlo <= conv_std_logic_vector(181014454,28);
      WHEN "1001010001" =>
            manhi <= conv_std_logic_vector(9490,24);
            manlo <= conv_std_logic_vector(183442020,28);
      WHEN "1001010010" =>
            manhi <= conv_std_logic_vector(9506,24);
            manlo <= conv_std_logic_vector(185873684,28);
      WHEN "1001010011" =>
            manhi <= conv_std_logic_vector(9522,24);
            manlo <= conv_std_logic_vector(188309446,28);
      WHEN "1001010100" =>
            manhi <= conv_std_logic_vector(9538,24);
            manlo <= conv_std_logic_vector(190749307,28);
      WHEN "1001010101" =>
            manhi <= conv_std_logic_vector(9554,24);
            manlo <= conv_std_logic_vector(193193266,28);
      WHEN "1001010110" =>
            manhi <= conv_std_logic_vector(9570,24);
            manlo <= conv_std_logic_vector(195641323,28);
      WHEN "1001010111" =>
            manhi <= conv_std_logic_vector(9586,24);
            manlo <= conv_std_logic_vector(198093479,28);
      WHEN "1001011000" =>
            manhi <= conv_std_logic_vector(9602,24);
            manlo <= conv_std_logic_vector(200549733,28);
      WHEN "1001011001" =>
            manhi <= conv_std_logic_vector(9618,24);
            manlo <= conv_std_logic_vector(203010086,28);
      WHEN "1001011010" =>
            manhi <= conv_std_logic_vector(9634,24);
            manlo <= conv_std_logic_vector(205474536,28);
      WHEN "1001011011" =>
            manhi <= conv_std_logic_vector(9650,24);
            manlo <= conv_std_logic_vector(207943085,28);
      WHEN "1001011100" =>
            manhi <= conv_std_logic_vector(9666,24);
            manlo <= conv_std_logic_vector(210415733,28);
      WHEN "1001011101" =>
            manhi <= conv_std_logic_vector(9682,24);
            manlo <= conv_std_logic_vector(212892479,28);
      WHEN "1001011110" =>
            manhi <= conv_std_logic_vector(9698,24);
            manlo <= conv_std_logic_vector(215373323,28);
      WHEN "1001011111" =>
            manhi <= conv_std_logic_vector(9714,24);
            manlo <= conv_std_logic_vector(217858266,28);
      WHEN "1001100000" =>
            manhi <= conv_std_logic_vector(9730,24);
            manlo <= conv_std_logic_vector(220347307,28);
      WHEN "1001100001" =>
            manhi <= conv_std_logic_vector(9746,24);
            manlo <= conv_std_logic_vector(222840446,28);
      WHEN "1001100010" =>
            manhi <= conv_std_logic_vector(9762,24);
            manlo <= conv_std_logic_vector(225337684,28);
      WHEN "1001100011" =>
            manhi <= conv_std_logic_vector(9778,24);
            manlo <= conv_std_logic_vector(227839020,28);
      WHEN "1001100100" =>
            manhi <= conv_std_logic_vector(9794,24);
            manlo <= conv_std_logic_vector(230344454,28);
      WHEN "1001100101" =>
            manhi <= conv_std_logic_vector(9810,24);
            manlo <= conv_std_logic_vector(232853987,28);
      WHEN "1001100110" =>
            manhi <= conv_std_logic_vector(9826,24);
            manlo <= conv_std_logic_vector(235367618,28);
      WHEN "1001100111" =>
            manhi <= conv_std_logic_vector(9842,24);
            manlo <= conv_std_logic_vector(237885348,28);
      WHEN "1001101000" =>
            manhi <= conv_std_logic_vector(9858,24);
            manlo <= conv_std_logic_vector(240407176,28);
      WHEN "1001101001" =>
            manhi <= conv_std_logic_vector(9874,24);
            manlo <= conv_std_logic_vector(242933102,28);
      WHEN "1001101010" =>
            manhi <= conv_std_logic_vector(9890,24);
            manlo <= conv_std_logic_vector(245463127,28);
      WHEN "1001101011" =>
            manhi <= conv_std_logic_vector(9906,24);
            manlo <= conv_std_logic_vector(247997251,28);
      WHEN "1001101100" =>
            manhi <= conv_std_logic_vector(9922,24);
            manlo <= conv_std_logic_vector(250535472,28);
      WHEN "1001101101" =>
            manhi <= conv_std_logic_vector(9938,24);
            manlo <= conv_std_logic_vector(253077793,28);
      WHEN "1001101110" =>
            manhi <= conv_std_logic_vector(9954,24);
            manlo <= conv_std_logic_vector(255624211,28);
      WHEN "1001101111" =>
            manhi <= conv_std_logic_vector(9970,24);
            manlo <= conv_std_logic_vector(258174728,28);
      WHEN "1001110000" =>
            manhi <= conv_std_logic_vector(9986,24);
            manlo <= conv_std_logic_vector(260729344,28);
      WHEN "1001110001" =>
            manhi <= conv_std_logic_vector(10002,24);
            manlo <= conv_std_logic_vector(263288057,28);
      WHEN "1001110010" =>
            manhi <= conv_std_logic_vector(10018,24);
            manlo <= conv_std_logic_vector(265850870,28);
      WHEN "1001110011" =>
            manhi <= conv_std_logic_vector(10034,24);
            manlo <= conv_std_logic_vector(268417780,28);
      WHEN "1001110100" =>
            manhi <= conv_std_logic_vector(10051,24);
            manlo <= conv_std_logic_vector(2553334,28);
      WHEN "1001110101" =>
            manhi <= conv_std_logic_vector(10067,24);
            manlo <= conv_std_logic_vector(5128441,28);
      WHEN "1001110110" =>
            manhi <= conv_std_logic_vector(10083,24);
            manlo <= conv_std_logic_vector(7707647,28);
      WHEN "1001110111" =>
            manhi <= conv_std_logic_vector(10099,24);
            manlo <= conv_std_logic_vector(10290952,28);
      WHEN "1001111000" =>
            manhi <= conv_std_logic_vector(10115,24);
            manlo <= conv_std_logic_vector(12878355,28);
      WHEN "1001111001" =>
            manhi <= conv_std_logic_vector(10131,24);
            manlo <= conv_std_logic_vector(15469857,28);
      WHEN "1001111010" =>
            manhi <= conv_std_logic_vector(10147,24);
            manlo <= conv_std_logic_vector(18065457,28);
      WHEN "1001111011" =>
            manhi <= conv_std_logic_vector(10163,24);
            manlo <= conv_std_logic_vector(20665155,28);
      WHEN "1001111100" =>
            manhi <= conv_std_logic_vector(10179,24);
            manlo <= conv_std_logic_vector(23268952,28);
      WHEN "1001111101" =>
            manhi <= conv_std_logic_vector(10195,24);
            manlo <= conv_std_logic_vector(25876847,28);
      WHEN "1001111110" =>
            manhi <= conv_std_logic_vector(10211,24);
            manlo <= conv_std_logic_vector(28488841,28);
      WHEN "1001111111" =>
            manhi <= conv_std_logic_vector(10227,24);
            manlo <= conv_std_logic_vector(31104934,28);
      WHEN "1010000000" =>
            manhi <= conv_std_logic_vector(10243,24);
            manlo <= conv_std_logic_vector(33725125,28);
      WHEN "1010000001" =>
            manhi <= conv_std_logic_vector(10259,24);
            manlo <= conv_std_logic_vector(36349414,28);
      WHEN "1010000010" =>
            manhi <= conv_std_logic_vector(10275,24);
            manlo <= conv_std_logic_vector(38977802,28);
      WHEN "1010000011" =>
            manhi <= conv_std_logic_vector(10291,24);
            manlo <= conv_std_logic_vector(41610288,28);
      WHEN "1010000100" =>
            manhi <= conv_std_logic_vector(10307,24);
            manlo <= conv_std_logic_vector(44246873,28);
      WHEN "1010000101" =>
            manhi <= conv_std_logic_vector(10323,24);
            manlo <= conv_std_logic_vector(46887557,28);
      WHEN "1010000110" =>
            manhi <= conv_std_logic_vector(10339,24);
            manlo <= conv_std_logic_vector(49532339,28);
      WHEN "1010000111" =>
            manhi <= conv_std_logic_vector(10355,24);
            manlo <= conv_std_logic_vector(52181219,28);
      WHEN "1010001000" =>
            manhi <= conv_std_logic_vector(10371,24);
            manlo <= conv_std_logic_vector(54834198,28);
      WHEN "1010001001" =>
            manhi <= conv_std_logic_vector(10387,24);
            manlo <= conv_std_logic_vector(57491276,28);
      WHEN "1010001010" =>
            manhi <= conv_std_logic_vector(10403,24);
            manlo <= conv_std_logic_vector(60152452,28);
      WHEN "1010001011" =>
            manhi <= conv_std_logic_vector(10419,24);
            manlo <= conv_std_logic_vector(62817727,28);
      WHEN "1010001100" =>
            manhi <= conv_std_logic_vector(10435,24);
            manlo <= conv_std_logic_vector(65487100,28);
      WHEN "1010001101" =>
            manhi <= conv_std_logic_vector(10451,24);
            manlo <= conv_std_logic_vector(68160572,28);
      WHEN "1010001110" =>
            manhi <= conv_std_logic_vector(10467,24);
            manlo <= conv_std_logic_vector(70838142,28);
      WHEN "1010001111" =>
            manhi <= conv_std_logic_vector(10483,24);
            manlo <= conv_std_logic_vector(73519811,28);
      WHEN "1010010000" =>
            manhi <= conv_std_logic_vector(10499,24);
            manlo <= conv_std_logic_vector(76205578,28);
      WHEN "1010010001" =>
            manhi <= conv_std_logic_vector(10515,24);
            manlo <= conv_std_logic_vector(78895444,28);
      WHEN "1010010010" =>
            manhi <= conv_std_logic_vector(10531,24);
            manlo <= conv_std_logic_vector(81589409,28);
      WHEN "1010010011" =>
            manhi <= conv_std_logic_vector(10547,24);
            manlo <= conv_std_logic_vector(84287472,28);
      WHEN "1010010100" =>
            manhi <= conv_std_logic_vector(10563,24);
            manlo <= conv_std_logic_vector(86989633,28);
      WHEN "1010010101" =>
            manhi <= conv_std_logic_vector(10579,24);
            manlo <= conv_std_logic_vector(89695894,28);
      WHEN "1010010110" =>
            manhi <= conv_std_logic_vector(10595,24);
            manlo <= conv_std_logic_vector(92406252,28);
      WHEN "1010010111" =>
            manhi <= conv_std_logic_vector(10611,24);
            manlo <= conv_std_logic_vector(95120710,28);
      WHEN "1010011000" =>
            manhi <= conv_std_logic_vector(10627,24);
            manlo <= conv_std_logic_vector(97839266,28);
      WHEN "1010011001" =>
            manhi <= conv_std_logic_vector(10643,24);
            manlo <= conv_std_logic_vector(100561920,28);
      WHEN "1010011010" =>
            manhi <= conv_std_logic_vector(10659,24);
            manlo <= conv_std_logic_vector(103288674,28);
      WHEN "1010011011" =>
            manhi <= conv_std_logic_vector(10675,24);
            manlo <= conv_std_logic_vector(106019525,28);
      WHEN "1010011100" =>
            manhi <= conv_std_logic_vector(10691,24);
            manlo <= conv_std_logic_vector(108754476,28);
      WHEN "1010011101" =>
            manhi <= conv_std_logic_vector(10707,24);
            manlo <= conv_std_logic_vector(111493525,28);
      WHEN "1010011110" =>
            manhi <= conv_std_logic_vector(10723,24);
            manlo <= conv_std_logic_vector(114236673,28);
      WHEN "1010011111" =>
            manhi <= conv_std_logic_vector(10739,24);
            manlo <= conv_std_logic_vector(116983919,28);
      WHEN "1010100000" =>
            manhi <= conv_std_logic_vector(10755,24);
            manlo <= conv_std_logic_vector(119735264,28);
      WHEN "1010100001" =>
            manhi <= conv_std_logic_vector(10771,24);
            manlo <= conv_std_logic_vector(122490707,28);
      WHEN "1010100010" =>
            manhi <= conv_std_logic_vector(10787,24);
            manlo <= conv_std_logic_vector(125250249,28);
      WHEN "1010100011" =>
            manhi <= conv_std_logic_vector(10803,24);
            manlo <= conv_std_logic_vector(128013890,28);
      WHEN "1010100100" =>
            manhi <= conv_std_logic_vector(10819,24);
            manlo <= conv_std_logic_vector(130781629,28);
      WHEN "1010100101" =>
            manhi <= conv_std_logic_vector(10835,24);
            manlo <= conv_std_logic_vector(133553468,28);
      WHEN "1010100110" =>
            manhi <= conv_std_logic_vector(10851,24);
            manlo <= conv_std_logic_vector(136329404,28);
      WHEN "1010100111" =>
            manhi <= conv_std_logic_vector(10867,24);
            manlo <= conv_std_logic_vector(139109440,28);
      WHEN "1010101000" =>
            manhi <= conv_std_logic_vector(10883,24);
            manlo <= conv_std_logic_vector(141893574,28);
      WHEN "1010101001" =>
            manhi <= conv_std_logic_vector(10899,24);
            manlo <= conv_std_logic_vector(144681806,28);
      WHEN "1010101010" =>
            manhi <= conv_std_logic_vector(10915,24);
            manlo <= conv_std_logic_vector(147474137,28);
      WHEN "1010101011" =>
            manhi <= conv_std_logic_vector(10931,24);
            manlo <= conv_std_logic_vector(150270567,28);
      WHEN "1010101100" =>
            manhi <= conv_std_logic_vector(10947,24);
            manlo <= conv_std_logic_vector(153071096,28);
      WHEN "1010101101" =>
            manhi <= conv_std_logic_vector(10963,24);
            manlo <= conv_std_logic_vector(155875723,28);
      WHEN "1010101110" =>
            manhi <= conv_std_logic_vector(10979,24);
            manlo <= conv_std_logic_vector(158684449,28);
      WHEN "1010101111" =>
            manhi <= conv_std_logic_vector(10995,24);
            manlo <= conv_std_logic_vector(161497274,28);
      WHEN "1010110000" =>
            manhi <= conv_std_logic_vector(11011,24);
            manlo <= conv_std_logic_vector(164314197,28);
      WHEN "1010110001" =>
            manhi <= conv_std_logic_vector(11027,24);
            manlo <= conv_std_logic_vector(167135219,28);
      WHEN "1010110010" =>
            manhi <= conv_std_logic_vector(11043,24);
            manlo <= conv_std_logic_vector(169960340,28);
      WHEN "1010110011" =>
            manhi <= conv_std_logic_vector(11059,24);
            manlo <= conv_std_logic_vector(172789560,28);
      WHEN "1010110100" =>
            manhi <= conv_std_logic_vector(11075,24);
            manlo <= conv_std_logic_vector(175622878,28);
      WHEN "1010110101" =>
            manhi <= conv_std_logic_vector(11091,24);
            manlo <= conv_std_logic_vector(178460295,28);
      WHEN "1010110110" =>
            manhi <= conv_std_logic_vector(11107,24);
            manlo <= conv_std_logic_vector(181301810,28);
      WHEN "1010110111" =>
            manhi <= conv_std_logic_vector(11123,24);
            manlo <= conv_std_logic_vector(184147424,28);
      WHEN "1010111000" =>
            manhi <= conv_std_logic_vector(11139,24);
            manlo <= conv_std_logic_vector(186997137,28);
      WHEN "1010111001" =>
            manhi <= conv_std_logic_vector(11155,24);
            manlo <= conv_std_logic_vector(189850949,28);
      WHEN "1010111010" =>
            manhi <= conv_std_logic_vector(11171,24);
            manlo <= conv_std_logic_vector(192708860,28);
      WHEN "1010111011" =>
            manhi <= conv_std_logic_vector(11187,24);
            manlo <= conv_std_logic_vector(195570869,28);
      WHEN "1010111100" =>
            manhi <= conv_std_logic_vector(11203,24);
            manlo <= conv_std_logic_vector(198436977,28);
      WHEN "1010111101" =>
            manhi <= conv_std_logic_vector(11219,24);
            manlo <= conv_std_logic_vector(201307183,28);
      WHEN "1010111110" =>
            manhi <= conv_std_logic_vector(11235,24);
            manlo <= conv_std_logic_vector(204181489,28);
      WHEN "1010111111" =>
            manhi <= conv_std_logic_vector(11251,24);
            manlo <= conv_std_logic_vector(207059893,28);
      WHEN "1011000000" =>
            manhi <= conv_std_logic_vector(11267,24);
            manlo <= conv_std_logic_vector(209942395,28);
      WHEN "1011000001" =>
            manhi <= conv_std_logic_vector(11283,24);
            manlo <= conv_std_logic_vector(212828997,28);
      WHEN "1011000010" =>
            manhi <= conv_std_logic_vector(11299,24);
            manlo <= conv_std_logic_vector(215719697,28);
      WHEN "1011000011" =>
            manhi <= conv_std_logic_vector(11315,24);
            manlo <= conv_std_logic_vector(218614497,28);
      WHEN "1011000100" =>
            manhi <= conv_std_logic_vector(11331,24);
            manlo <= conv_std_logic_vector(221513394,28);
      WHEN "1011000101" =>
            manhi <= conv_std_logic_vector(11347,24);
            manlo <= conv_std_logic_vector(224416391,28);
      WHEN "1011000110" =>
            manhi <= conv_std_logic_vector(11363,24);
            manlo <= conv_std_logic_vector(227323486,28);
      WHEN "1011000111" =>
            manhi <= conv_std_logic_vector(11379,24);
            manlo <= conv_std_logic_vector(230234681,28);
      WHEN "1011001000" =>
            manhi <= conv_std_logic_vector(11395,24);
            manlo <= conv_std_logic_vector(233149974,28);
      WHEN "1011001001" =>
            manhi <= conv_std_logic_vector(11411,24);
            manlo <= conv_std_logic_vector(236069365,28);
      WHEN "1011001010" =>
            manhi <= conv_std_logic_vector(11427,24);
            manlo <= conv_std_logic_vector(238992856,28);
      WHEN "1011001011" =>
            manhi <= conv_std_logic_vector(11443,24);
            manlo <= conv_std_logic_vector(241920445,28);
      WHEN "1011001100" =>
            manhi <= conv_std_logic_vector(11459,24);
            manlo <= conv_std_logic_vector(244852133,28);
      WHEN "1011001101" =>
            manhi <= conv_std_logic_vector(11475,24);
            manlo <= conv_std_logic_vector(247787920,28);
      WHEN "1011001110" =>
            manhi <= conv_std_logic_vector(11491,24);
            manlo <= conv_std_logic_vector(250727806,28);
      WHEN "1011001111" =>
            manhi <= conv_std_logic_vector(11507,24);
            manlo <= conv_std_logic_vector(253671790,28);
      WHEN "1011010000" =>
            manhi <= conv_std_logic_vector(11523,24);
            manlo <= conv_std_logic_vector(256619874,28);
      WHEN "1011010001" =>
            manhi <= conv_std_logic_vector(11539,24);
            manlo <= conv_std_logic_vector(259572056,28);
      WHEN "1011010010" =>
            manhi <= conv_std_logic_vector(11555,24);
            manlo <= conv_std_logic_vector(262528337,28);
      WHEN "1011010011" =>
            manhi <= conv_std_logic_vector(11571,24);
            manlo <= conv_std_logic_vector(265488717,28);
      WHEN "1011010100" =>
            manhi <= conv_std_logic_vector(11588,24);
            manlo <= conv_std_logic_vector(17739,28);
      WHEN "1011010101" =>
            manhi <= conv_std_logic_vector(11604,24);
            manlo <= conv_std_logic_vector(2986317,28);
      WHEN "1011010110" =>
            manhi <= conv_std_logic_vector(11620,24);
            manlo <= conv_std_logic_vector(5958993,28);
      WHEN "1011010111" =>
            manhi <= conv_std_logic_vector(11636,24);
            manlo <= conv_std_logic_vector(8935768,28);
      WHEN "1011011000" =>
            manhi <= conv_std_logic_vector(11652,24);
            manlo <= conv_std_logic_vector(11916642,28);
      WHEN "1011011001" =>
            manhi <= conv_std_logic_vector(11668,24);
            manlo <= conv_std_logic_vector(14901615,28);
      WHEN "1011011010" =>
            manhi <= conv_std_logic_vector(11684,24);
            manlo <= conv_std_logic_vector(17890686,28);
      WHEN "1011011011" =>
            manhi <= conv_std_logic_vector(11700,24);
            manlo <= conv_std_logic_vector(20883857,28);
      WHEN "1011011100" =>
            manhi <= conv_std_logic_vector(11716,24);
            manlo <= conv_std_logic_vector(23881126,28);
      WHEN "1011011101" =>
            manhi <= conv_std_logic_vector(11732,24);
            manlo <= conv_std_logic_vector(26882494,28);
      WHEN "1011011110" =>
            manhi <= conv_std_logic_vector(11748,24);
            manlo <= conv_std_logic_vector(29887961,28);
      WHEN "1011011111" =>
            manhi <= conv_std_logic_vector(11764,24);
            manlo <= conv_std_logic_vector(32897527,28);
      WHEN "1011100000" =>
            manhi <= conv_std_logic_vector(11780,24);
            manlo <= conv_std_logic_vector(35911192,28);
      WHEN "1011100001" =>
            manhi <= conv_std_logic_vector(11796,24);
            manlo <= conv_std_logic_vector(38928956,28);
      WHEN "1011100010" =>
            manhi <= conv_std_logic_vector(11812,24);
            manlo <= conv_std_logic_vector(41950818,28);
      WHEN "1011100011" =>
            manhi <= conv_std_logic_vector(11828,24);
            manlo <= conv_std_logic_vector(44976780,28);
      WHEN "1011100100" =>
            manhi <= conv_std_logic_vector(11844,24);
            manlo <= conv_std_logic_vector(48006840,28);
      WHEN "1011100101" =>
            manhi <= conv_std_logic_vector(11860,24);
            manlo <= conv_std_logic_vector(51040999,28);
      WHEN "1011100110" =>
            manhi <= conv_std_logic_vector(11876,24);
            manlo <= conv_std_logic_vector(54079258,28);
      WHEN "1011100111" =>
            manhi <= conv_std_logic_vector(11892,24);
            manlo <= conv_std_logic_vector(57121615,28);
      WHEN "1011101000" =>
            manhi <= conv_std_logic_vector(11908,24);
            manlo <= conv_std_logic_vector(60168071,28);
      WHEN "1011101001" =>
            manhi <= conv_std_logic_vector(11924,24);
            manlo <= conv_std_logic_vector(63218625,28);
      WHEN "1011101010" =>
            manhi <= conv_std_logic_vector(11940,24);
            manlo <= conv_std_logic_vector(66273279,28);
      WHEN "1011101011" =>
            manhi <= conv_std_logic_vector(11956,24);
            manlo <= conv_std_logic_vector(69332032,28);
      WHEN "1011101100" =>
            manhi <= conv_std_logic_vector(11972,24);
            manlo <= conv_std_logic_vector(72394883,28);
      WHEN "1011101101" =>
            manhi <= conv_std_logic_vector(11988,24);
            manlo <= conv_std_logic_vector(75461834,28);
      WHEN "1011101110" =>
            manhi <= conv_std_logic_vector(12004,24);
            manlo <= conv_std_logic_vector(78532883,28);
      WHEN "1011101111" =>
            manhi <= conv_std_logic_vector(12020,24);
            manlo <= conv_std_logic_vector(81608032,28);
      WHEN "1011110000" =>
            manhi <= conv_std_logic_vector(12036,24);
            manlo <= conv_std_logic_vector(84687279,28);
      WHEN "1011110001" =>
            manhi <= conv_std_logic_vector(12052,24);
            manlo <= conv_std_logic_vector(87770625,28);
      WHEN "1011110010" =>
            manhi <= conv_std_logic_vector(12068,24);
            manlo <= conv_std_logic_vector(90858070,28);
      WHEN "1011110011" =>
            manhi <= conv_std_logic_vector(12084,24);
            manlo <= conv_std_logic_vector(93949615,28);
      WHEN "1011110100" =>
            manhi <= conv_std_logic_vector(12100,24);
            manlo <= conv_std_logic_vector(97045258,28);
      WHEN "1011110101" =>
            manhi <= conv_std_logic_vector(12116,24);
            manlo <= conv_std_logic_vector(100145000,28);
      WHEN "1011110110" =>
            manhi <= conv_std_logic_vector(12132,24);
            manlo <= conv_std_logic_vector(103248841,28);
      WHEN "1011110111" =>
            manhi <= conv_std_logic_vector(12148,24);
            manlo <= conv_std_logic_vector(106356781,28);
      WHEN "1011111000" =>
            manhi <= conv_std_logic_vector(12164,24);
            manlo <= conv_std_logic_vector(109468819,28);
      WHEN "1011111001" =>
            manhi <= conv_std_logic_vector(12180,24);
            manlo <= conv_std_logic_vector(112584957,28);
      WHEN "1011111010" =>
            manhi <= conv_std_logic_vector(12196,24);
            manlo <= conv_std_logic_vector(115705194,28);
      WHEN "1011111011" =>
            manhi <= conv_std_logic_vector(12212,24);
            manlo <= conv_std_logic_vector(118829530,28);
      WHEN "1011111100" =>
            manhi <= conv_std_logic_vector(12228,24);
            manlo <= conv_std_logic_vector(121957965,28);
      WHEN "1011111101" =>
            manhi <= conv_std_logic_vector(12244,24);
            manlo <= conv_std_logic_vector(125090499,28);
      WHEN "1011111110" =>
            manhi <= conv_std_logic_vector(12260,24);
            manlo <= conv_std_logic_vector(128227131,28);
      WHEN "1011111111" =>
            manhi <= conv_std_logic_vector(12276,24);
            manlo <= conv_std_logic_vector(131367863,28);
      WHEN "1100000000" =>
            manhi <= conv_std_logic_vector(12292,24);
            manlo <= conv_std_logic_vector(134512694,28);
      WHEN "1100000001" =>
            manhi <= conv_std_logic_vector(12308,24);
            manlo <= conv_std_logic_vector(137661624,28);
      WHEN "1100000010" =>
            manhi <= conv_std_logic_vector(12324,24);
            manlo <= conv_std_logic_vector(140814653,28);
      WHEN "1100000011" =>
            manhi <= conv_std_logic_vector(12340,24);
            manlo <= conv_std_logic_vector(143971780,28);
      WHEN "1100000100" =>
            manhi <= conv_std_logic_vector(12356,24);
            manlo <= conv_std_logic_vector(147133007,28);
      WHEN "1100000101" =>
            manhi <= conv_std_logic_vector(12372,24);
            manlo <= conv_std_logic_vector(150298333,28);
      WHEN "1100000110" =>
            manhi <= conv_std_logic_vector(12388,24);
            manlo <= conv_std_logic_vector(153467758,28);
      WHEN "1100000111" =>
            manhi <= conv_std_logic_vector(12404,24);
            manlo <= conv_std_logic_vector(156641282,28);
      WHEN "1100001000" =>
            manhi <= conv_std_logic_vector(12420,24);
            manlo <= conv_std_logic_vector(159818905,28);
      WHEN "1100001001" =>
            manhi <= conv_std_logic_vector(12436,24);
            manlo <= conv_std_logic_vector(163000627,28);
      WHEN "1100001010" =>
            manhi <= conv_std_logic_vector(12452,24);
            manlo <= conv_std_logic_vector(166186448,28);
      WHEN "1100001011" =>
            manhi <= conv_std_logic_vector(12468,24);
            manlo <= conv_std_logic_vector(169376368,28);
      WHEN "1100001100" =>
            manhi <= conv_std_logic_vector(12484,24);
            manlo <= conv_std_logic_vector(172570387,28);
      WHEN "1100001101" =>
            manhi <= conv_std_logic_vector(12500,24);
            manlo <= conv_std_logic_vector(175768505,28);
      WHEN "1100001110" =>
            manhi <= conv_std_logic_vector(12516,24);
            manlo <= conv_std_logic_vector(178970722,28);
      WHEN "1100001111" =>
            manhi <= conv_std_logic_vector(12532,24);
            manlo <= conv_std_logic_vector(182177038,28);
      WHEN "1100010000" =>
            manhi <= conv_std_logic_vector(12548,24);
            manlo <= conv_std_logic_vector(185387453,28);
      WHEN "1100010001" =>
            manhi <= conv_std_logic_vector(12564,24);
            manlo <= conv_std_logic_vector(188601968,28);
      WHEN "1100010010" =>
            manhi <= conv_std_logic_vector(12580,24);
            manlo <= conv_std_logic_vector(191820581,28);
      WHEN "1100010011" =>
            manhi <= conv_std_logic_vector(12596,24);
            manlo <= conv_std_logic_vector(195043294,28);
      WHEN "1100010100" =>
            manhi <= conv_std_logic_vector(12612,24);
            manlo <= conv_std_logic_vector(198270105,28);
      WHEN "1100010101" =>
            manhi <= conv_std_logic_vector(12628,24);
            manlo <= conv_std_logic_vector(201501016,28);
      WHEN "1100010110" =>
            manhi <= conv_std_logic_vector(12644,24);
            manlo <= conv_std_logic_vector(204736025,28);
      WHEN "1100010111" =>
            manhi <= conv_std_logic_vector(12660,24);
            manlo <= conv_std_logic_vector(207975134,28);
      WHEN "1100011000" =>
            manhi <= conv_std_logic_vector(12676,24);
            manlo <= conv_std_logic_vector(211218342,28);
      WHEN "1100011001" =>
            manhi <= conv_std_logic_vector(12692,24);
            manlo <= conv_std_logic_vector(214465649,28);
      WHEN "1100011010" =>
            manhi <= conv_std_logic_vector(12708,24);
            manlo <= conv_std_logic_vector(217717055,28);
      WHEN "1100011011" =>
            manhi <= conv_std_logic_vector(12724,24);
            manlo <= conv_std_logic_vector(220972560,28);
      WHEN "1100011100" =>
            manhi <= conv_std_logic_vector(12740,24);
            manlo <= conv_std_logic_vector(224232165,28);
      WHEN "1100011101" =>
            manhi <= conv_std_logic_vector(12756,24);
            manlo <= conv_std_logic_vector(227495868,28);
      WHEN "1100011110" =>
            manhi <= conv_std_logic_vector(12772,24);
            manlo <= conv_std_logic_vector(230763671,28);
      WHEN "1100011111" =>
            manhi <= conv_std_logic_vector(12788,24);
            manlo <= conv_std_logic_vector(234035572,28);
      WHEN "1100100000" =>
            manhi <= conv_std_logic_vector(12804,24);
            manlo <= conv_std_logic_vector(237311573,28);
      WHEN "1100100001" =>
            manhi <= conv_std_logic_vector(12820,24);
            manlo <= conv_std_logic_vector(240591673,28);
      WHEN "1100100010" =>
            manhi <= conv_std_logic_vector(12836,24);
            manlo <= conv_std_logic_vector(243875872,28);
      WHEN "1100100011" =>
            manhi <= conv_std_logic_vector(12852,24);
            manlo <= conv_std_logic_vector(247164170,28);
      WHEN "1100100100" =>
            manhi <= conv_std_logic_vector(12868,24);
            manlo <= conv_std_logic_vector(250456567,28);
      WHEN "1100100101" =>
            manhi <= conv_std_logic_vector(12884,24);
            manlo <= conv_std_logic_vector(253753064,28);
      WHEN "1100100110" =>
            manhi <= conv_std_logic_vector(12900,24);
            manlo <= conv_std_logic_vector(257053659,28);
      WHEN "1100100111" =>
            manhi <= conv_std_logic_vector(12916,24);
            manlo <= conv_std_logic_vector(260358354,28);
      WHEN "1100101000" =>
            manhi <= conv_std_logic_vector(12932,24);
            manlo <= conv_std_logic_vector(263667148,28);
      WHEN "1100101001" =>
            manhi <= conv_std_logic_vector(12948,24);
            manlo <= conv_std_logic_vector(266980041,28);
      WHEN "1100101010" =>
            manhi <= conv_std_logic_vector(12965,24);
            manlo <= conv_std_logic_vector(1861577,28);
      WHEN "1100101011" =>
            manhi <= conv_std_logic_vector(12981,24);
            manlo <= conv_std_logic_vector(5182668,28);
      WHEN "1100101100" =>
            manhi <= conv_std_logic_vector(12997,24);
            manlo <= conv_std_logic_vector(8507859,28);
      WHEN "1100101101" =>
            manhi <= conv_std_logic_vector(13013,24);
            manlo <= conv_std_logic_vector(11837149,28);
      WHEN "1100101110" =>
            manhi <= conv_std_logic_vector(13029,24);
            manlo <= conv_std_logic_vector(15170538,28);
      WHEN "1100101111" =>
            manhi <= conv_std_logic_vector(13045,24);
            manlo <= conv_std_logic_vector(18508026,28);
      WHEN "1100110000" =>
            manhi <= conv_std_logic_vector(13061,24);
            manlo <= conv_std_logic_vector(21849613,28);
      WHEN "1100110001" =>
            manhi <= conv_std_logic_vector(13077,24);
            manlo <= conv_std_logic_vector(25195299,28);
      WHEN "1100110010" =>
            manhi <= conv_std_logic_vector(13093,24);
            manlo <= conv_std_logic_vector(28545085,28);
      WHEN "1100110011" =>
            manhi <= conv_std_logic_vector(13109,24);
            manlo <= conv_std_logic_vector(31898970,28);
      WHEN "1100110100" =>
            manhi <= conv_std_logic_vector(13125,24);
            manlo <= conv_std_logic_vector(35256954,28);
      WHEN "1100110101" =>
            manhi <= conv_std_logic_vector(13141,24);
            manlo <= conv_std_logic_vector(38619037,28);
      WHEN "1100110110" =>
            manhi <= conv_std_logic_vector(13157,24);
            manlo <= conv_std_logic_vector(41985219,28);
      WHEN "1100110111" =>
            manhi <= conv_std_logic_vector(13173,24);
            manlo <= conv_std_logic_vector(45355501,28);
      WHEN "1100111000" =>
            manhi <= conv_std_logic_vector(13189,24);
            manlo <= conv_std_logic_vector(48729882,28);
      WHEN "1100111001" =>
            manhi <= conv_std_logic_vector(13205,24);
            manlo <= conv_std_logic_vector(52108362,28);
      WHEN "1100111010" =>
            manhi <= conv_std_logic_vector(13221,24);
            manlo <= conv_std_logic_vector(55490941,28);
      WHEN "1100111011" =>
            manhi <= conv_std_logic_vector(13237,24);
            manlo <= conv_std_logic_vector(58877620,28);
      WHEN "1100111100" =>
            manhi <= conv_std_logic_vector(13253,24);
            manlo <= conv_std_logic_vector(62268398,28);
      WHEN "1100111101" =>
            manhi <= conv_std_logic_vector(13269,24);
            manlo <= conv_std_logic_vector(65663275,28);
      WHEN "1100111110" =>
            manhi <= conv_std_logic_vector(13285,24);
            manlo <= conv_std_logic_vector(69062251,28);
      WHEN "1100111111" =>
            manhi <= conv_std_logic_vector(13301,24);
            manlo <= conv_std_logic_vector(72465326,28);
      WHEN "1101000000" =>
            manhi <= conv_std_logic_vector(13317,24);
            manlo <= conv_std_logic_vector(75872501,28);
      WHEN "1101000001" =>
            manhi <= conv_std_logic_vector(13333,24);
            manlo <= conv_std_logic_vector(79283775,28);
      WHEN "1101000010" =>
            manhi <= conv_std_logic_vector(13349,24);
            manlo <= conv_std_logic_vector(82699148,28);
      WHEN "1101000011" =>
            manhi <= conv_std_logic_vector(13365,24);
            manlo <= conv_std_logic_vector(86118621,28);
      WHEN "1101000100" =>
            manhi <= conv_std_logic_vector(13381,24);
            manlo <= conv_std_logic_vector(89542193,28);
      WHEN "1101000101" =>
            manhi <= conv_std_logic_vector(13397,24);
            manlo <= conv_std_logic_vector(92969864,28);
      WHEN "1101000110" =>
            manhi <= conv_std_logic_vector(13413,24);
            manlo <= conv_std_logic_vector(96401634,28);
      WHEN "1101000111" =>
            manhi <= conv_std_logic_vector(13429,24);
            manlo <= conv_std_logic_vector(99837503,28);
      WHEN "1101001000" =>
            manhi <= conv_std_logic_vector(13445,24);
            manlo <= conv_std_logic_vector(103277472,28);
      WHEN "1101001001" =>
            manhi <= conv_std_logic_vector(13461,24);
            manlo <= conv_std_logic_vector(106721540,28);
      WHEN "1101001010" =>
            manhi <= conv_std_logic_vector(13477,24);
            manlo <= conv_std_logic_vector(110169708,28);
      WHEN "1101001011" =>
            manhi <= conv_std_logic_vector(13493,24);
            manlo <= conv_std_logic_vector(113621975,28);
      WHEN "1101001100" =>
            manhi <= conv_std_logic_vector(13509,24);
            manlo <= conv_std_logic_vector(117078341,28);
      WHEN "1101001101" =>
            manhi <= conv_std_logic_vector(13525,24);
            manlo <= conv_std_logic_vector(120538806,28);
      WHEN "1101001110" =>
            manhi <= conv_std_logic_vector(13541,24);
            manlo <= conv_std_logic_vector(124003370,28);
      WHEN "1101001111" =>
            manhi <= conv_std_logic_vector(13557,24);
            manlo <= conv_std_logic_vector(127472034,28);
      WHEN "1101010000" =>
            manhi <= conv_std_logic_vector(13573,24);
            manlo <= conv_std_logic_vector(130944798,28);
      WHEN "1101010001" =>
            manhi <= conv_std_logic_vector(13589,24);
            manlo <= conv_std_logic_vector(134421660,28);
      WHEN "1101010010" =>
            manhi <= conv_std_logic_vector(13605,24);
            manlo <= conv_std_logic_vector(137902622,28);
      WHEN "1101010011" =>
            manhi <= conv_std_logic_vector(13621,24);
            manlo <= conv_std_logic_vector(141387683,28);
      WHEN "1101010100" =>
            manhi <= conv_std_logic_vector(13637,24);
            manlo <= conv_std_logic_vector(144876844,28);
      WHEN "1101010101" =>
            manhi <= conv_std_logic_vector(13653,24);
            manlo <= conv_std_logic_vector(148370104,28);
      WHEN "1101010110" =>
            manhi <= conv_std_logic_vector(13669,24);
            manlo <= conv_std_logic_vector(151867463,28);
      WHEN "1101010111" =>
            manhi <= conv_std_logic_vector(13685,24);
            manlo <= conv_std_logic_vector(155368921,28);
      WHEN "1101011000" =>
            manhi <= conv_std_logic_vector(13701,24);
            manlo <= conv_std_logic_vector(158874479,28);
      WHEN "1101011001" =>
            manhi <= conv_std_logic_vector(13717,24);
            manlo <= conv_std_logic_vector(162384136,28);
      WHEN "1101011010" =>
            manhi <= conv_std_logic_vector(13733,24);
            manlo <= conv_std_logic_vector(165897893,28);
      WHEN "1101011011" =>
            manhi <= conv_std_logic_vector(13749,24);
            manlo <= conv_std_logic_vector(169415749,28);
      WHEN "1101011100" =>
            manhi <= conv_std_logic_vector(13765,24);
            manlo <= conv_std_logic_vector(172937704,28);
      WHEN "1101011101" =>
            manhi <= conv_std_logic_vector(13781,24);
            manlo <= conv_std_logic_vector(176463758,28);
      WHEN "1101011110" =>
            manhi <= conv_std_logic_vector(13797,24);
            manlo <= conv_std_logic_vector(179993912,28);
      WHEN "1101011111" =>
            manhi <= conv_std_logic_vector(13813,24);
            manlo <= conv_std_logic_vector(183528166,28);
      WHEN "1101100000" =>
            manhi <= conv_std_logic_vector(13829,24);
            manlo <= conv_std_logic_vector(187066519,28);
      WHEN "1101100001" =>
            manhi <= conv_std_logic_vector(13845,24);
            manlo <= conv_std_logic_vector(190608971,28);
      WHEN "1101100010" =>
            manhi <= conv_std_logic_vector(13861,24);
            manlo <= conv_std_logic_vector(194155522,28);
      WHEN "1101100011" =>
            manhi <= conv_std_logic_vector(13877,24);
            manlo <= conv_std_logic_vector(197706173,28);
      WHEN "1101100100" =>
            manhi <= conv_std_logic_vector(13893,24);
            manlo <= conv_std_logic_vector(201260923,28);
      WHEN "1101100101" =>
            manhi <= conv_std_logic_vector(13909,24);
            manlo <= conv_std_logic_vector(204819773,28);
      WHEN "1101100110" =>
            manhi <= conv_std_logic_vector(13925,24);
            manlo <= conv_std_logic_vector(208382722,28);
      WHEN "1101100111" =>
            manhi <= conv_std_logic_vector(13941,24);
            manlo <= conv_std_logic_vector(211949770,28);
      WHEN "1101101000" =>
            manhi <= conv_std_logic_vector(13957,24);
            manlo <= conv_std_logic_vector(215520918,28);
      WHEN "1101101001" =>
            manhi <= conv_std_logic_vector(13973,24);
            manlo <= conv_std_logic_vector(219096165,28);
      WHEN "1101101010" =>
            manhi <= conv_std_logic_vector(13989,24);
            manlo <= conv_std_logic_vector(222675512,28);
      WHEN "1101101011" =>
            manhi <= conv_std_logic_vector(14005,24);
            manlo <= conv_std_logic_vector(226258958,28);
      WHEN "1101101100" =>
            manhi <= conv_std_logic_vector(14021,24);
            manlo <= conv_std_logic_vector(229846504,28);
      WHEN "1101101101" =>
            manhi <= conv_std_logic_vector(14037,24);
            manlo <= conv_std_logic_vector(233438148,28);
      WHEN "1101101110" =>
            manhi <= conv_std_logic_vector(14053,24);
            manlo <= conv_std_logic_vector(237033893,28);
      WHEN "1101101111" =>
            manhi <= conv_std_logic_vector(14069,24);
            manlo <= conv_std_logic_vector(240633737,28);
      WHEN "1101110000" =>
            manhi <= conv_std_logic_vector(14085,24);
            manlo <= conv_std_logic_vector(244237680,28);
      WHEN "1101110001" =>
            manhi <= conv_std_logic_vector(14101,24);
            manlo <= conv_std_logic_vector(247845722,28);
      WHEN "1101110010" =>
            manhi <= conv_std_logic_vector(14117,24);
            manlo <= conv_std_logic_vector(251457864,28);
      WHEN "1101110011" =>
            manhi <= conv_std_logic_vector(14133,24);
            manlo <= conv_std_logic_vector(255074106,28);
      WHEN "1101110100" =>
            manhi <= conv_std_logic_vector(14149,24);
            manlo <= conv_std_logic_vector(258694447,28);
      WHEN "1101110101" =>
            manhi <= conv_std_logic_vector(14165,24);
            manlo <= conv_std_logic_vector(262318887,28);
      WHEN "1101110110" =>
            manhi <= conv_std_logic_vector(14181,24);
            manlo <= conv_std_logic_vector(265947427,28);
      WHEN "1101110111" =>
            manhi <= conv_std_logic_vector(14198,24);
            manlo <= conv_std_logic_vector(1144611,28);
      WHEN "1101111000" =>
            manhi <= conv_std_logic_vector(14214,24);
            manlo <= conv_std_logic_vector(4781350,28);
      WHEN "1101111001" =>
            manhi <= conv_std_logic_vector(14230,24);
            manlo <= conv_std_logic_vector(8422188,28);
      WHEN "1101111010" =>
            manhi <= conv_std_logic_vector(14246,24);
            manlo <= conv_std_logic_vector(12067126,28);
      WHEN "1101111011" =>
            manhi <= conv_std_logic_vector(14262,24);
            manlo <= conv_std_logic_vector(15716163,28);
      WHEN "1101111100" =>
            manhi <= conv_std_logic_vector(14278,24);
            manlo <= conv_std_logic_vector(19369300,28);
      WHEN "1101111101" =>
            manhi <= conv_std_logic_vector(14294,24);
            manlo <= conv_std_logic_vector(23026536,28);
      WHEN "1101111110" =>
            manhi <= conv_std_logic_vector(14310,24);
            manlo <= conv_std_logic_vector(26687871,28);
      WHEN "1101111111" =>
            manhi <= conv_std_logic_vector(14326,24);
            manlo <= conv_std_logic_vector(30353307,28);
      WHEN "1110000000" =>
            manhi <= conv_std_logic_vector(14342,24);
            manlo <= conv_std_logic_vector(34022841,28);
      WHEN "1110000001" =>
            manhi <= conv_std_logic_vector(14358,24);
            manlo <= conv_std_logic_vector(37696476,28);
      WHEN "1110000010" =>
            manhi <= conv_std_logic_vector(14374,24);
            manlo <= conv_std_logic_vector(41374209,28);
      WHEN "1110000011" =>
            manhi <= conv_std_logic_vector(14390,24);
            manlo <= conv_std_logic_vector(45056043,28);
      WHEN "1110000100" =>
            manhi <= conv_std_logic_vector(14406,24);
            manlo <= conv_std_logic_vector(48741975,28);
      WHEN "1110000101" =>
            manhi <= conv_std_logic_vector(14422,24);
            manlo <= conv_std_logic_vector(52432007,28);
      WHEN "1110000110" =>
            manhi <= conv_std_logic_vector(14438,24);
            manlo <= conv_std_logic_vector(56126139,28);
      WHEN "1110000111" =>
            manhi <= conv_std_logic_vector(14454,24);
            manlo <= conv_std_logic_vector(59824371,28);
      WHEN "1110001000" =>
            manhi <= conv_std_logic_vector(14470,24);
            manlo <= conv_std_logic_vector(63526701,28);
      WHEN "1110001001" =>
            manhi <= conv_std_logic_vector(14486,24);
            manlo <= conv_std_logic_vector(67233132,28);
      WHEN "1110001010" =>
            manhi <= conv_std_logic_vector(14502,24);
            manlo <= conv_std_logic_vector(70943662,28);
      WHEN "1110001011" =>
            manhi <= conv_std_logic_vector(14518,24);
            manlo <= conv_std_logic_vector(74658291,28);
      WHEN "1110001100" =>
            manhi <= conv_std_logic_vector(14534,24);
            manlo <= conv_std_logic_vector(78377020,28);
      WHEN "1110001101" =>
            manhi <= conv_std_logic_vector(14550,24);
            manlo <= conv_std_logic_vector(82099849,28);
      WHEN "1110001110" =>
            manhi <= conv_std_logic_vector(14566,24);
            manlo <= conv_std_logic_vector(85826777,28);
      WHEN "1110001111" =>
            manhi <= conv_std_logic_vector(14582,24);
            manlo <= conv_std_logic_vector(89557804,28);
      WHEN "1110010000" =>
            manhi <= conv_std_logic_vector(14598,24);
            manlo <= conv_std_logic_vector(93292931,28);
      WHEN "1110010001" =>
            manhi <= conv_std_logic_vector(14614,24);
            manlo <= conv_std_logic_vector(97032158,28);
      WHEN "1110010010" =>
            manhi <= conv_std_logic_vector(14630,24);
            manlo <= conv_std_logic_vector(100775484,28);
      WHEN "1110010011" =>
            manhi <= conv_std_logic_vector(14646,24);
            manlo <= conv_std_logic_vector(104522910,28);
      WHEN "1110010100" =>
            manhi <= conv_std_logic_vector(14662,24);
            manlo <= conv_std_logic_vector(108274436,28);
      WHEN "1110010101" =>
            manhi <= conv_std_logic_vector(14678,24);
            manlo <= conv_std_logic_vector(112030061,28);
      WHEN "1110010110" =>
            manhi <= conv_std_logic_vector(14694,24);
            manlo <= conv_std_logic_vector(115789786,28);
      WHEN "1110010111" =>
            manhi <= conv_std_logic_vector(14710,24);
            manlo <= conv_std_logic_vector(119553610,28);
      WHEN "1110011000" =>
            manhi <= conv_std_logic_vector(14726,24);
            manlo <= conv_std_logic_vector(123321534,28);
      WHEN "1110011001" =>
            manhi <= conv_std_logic_vector(14742,24);
            manlo <= conv_std_logic_vector(127093557,28);
      WHEN "1110011010" =>
            manhi <= conv_std_logic_vector(14758,24);
            manlo <= conv_std_logic_vector(130869680,28);
      WHEN "1110011011" =>
            manhi <= conv_std_logic_vector(14774,24);
            manlo <= conv_std_logic_vector(134649903,28);
      WHEN "1110011100" =>
            manhi <= conv_std_logic_vector(14790,24);
            manlo <= conv_std_logic_vector(138434225,28);
      WHEN "1110011101" =>
            manhi <= conv_std_logic_vector(14806,24);
            manlo <= conv_std_logic_vector(142222647,28);
      WHEN "1110011110" =>
            manhi <= conv_std_logic_vector(14822,24);
            manlo <= conv_std_logic_vector(146015168,28);
      WHEN "1110011111" =>
            manhi <= conv_std_logic_vector(14838,24);
            manlo <= conv_std_logic_vector(149811789,28);
      WHEN "1110100000" =>
            manhi <= conv_std_logic_vector(14854,24);
            manlo <= conv_std_logic_vector(153612510,28);
      WHEN "1110100001" =>
            manhi <= conv_std_logic_vector(14870,24);
            manlo <= conv_std_logic_vector(157417330,28);
      WHEN "1110100010" =>
            manhi <= conv_std_logic_vector(14886,24);
            manlo <= conv_std_logic_vector(161226250,28);
      WHEN "1110100011" =>
            manhi <= conv_std_logic_vector(14902,24);
            manlo <= conv_std_logic_vector(165039270,28);
      WHEN "1110100100" =>
            manhi <= conv_std_logic_vector(14918,24);
            manlo <= conv_std_logic_vector(168856389,28);
      WHEN "1110100101" =>
            manhi <= conv_std_logic_vector(14934,24);
            manlo <= conv_std_logic_vector(172677608,28);
      WHEN "1110100110" =>
            manhi <= conv_std_logic_vector(14950,24);
            manlo <= conv_std_logic_vector(176502926,28);
      WHEN "1110100111" =>
            manhi <= conv_std_logic_vector(14966,24);
            manlo <= conv_std_logic_vector(180332344,28);
      WHEN "1110101000" =>
            manhi <= conv_std_logic_vector(14982,24);
            manlo <= conv_std_logic_vector(184165862,28);
      WHEN "1110101001" =>
            manhi <= conv_std_logic_vector(14998,24);
            manlo <= conv_std_logic_vector(188003480,28);
      WHEN "1110101010" =>
            manhi <= conv_std_logic_vector(15014,24);
            manlo <= conv_std_logic_vector(191845197,28);
      WHEN "1110101011" =>
            manhi <= conv_std_logic_vector(15030,24);
            manlo <= conv_std_logic_vector(195691014,28);
      WHEN "1110101100" =>
            manhi <= conv_std_logic_vector(15046,24);
            manlo <= conv_std_logic_vector(199540930,28);
      WHEN "1110101101" =>
            manhi <= conv_std_logic_vector(15062,24);
            manlo <= conv_std_logic_vector(203394946,28);
      WHEN "1110101110" =>
            manhi <= conv_std_logic_vector(15078,24);
            manlo <= conv_std_logic_vector(207253062,28);
      WHEN "1110101111" =>
            manhi <= conv_std_logic_vector(15094,24);
            manlo <= conv_std_logic_vector(211115277,28);
      WHEN "1110110000" =>
            manhi <= conv_std_logic_vector(15110,24);
            manlo <= conv_std_logic_vector(214981593,28);
      WHEN "1110110001" =>
            manhi <= conv_std_logic_vector(15126,24);
            manlo <= conv_std_logic_vector(218852007,28);
      WHEN "1110110010" =>
            manhi <= conv_std_logic_vector(15142,24);
            manlo <= conv_std_logic_vector(222726522,28);
      WHEN "1110110011" =>
            manhi <= conv_std_logic_vector(15158,24);
            manlo <= conv_std_logic_vector(226605136,28);
      WHEN "1110110100" =>
            manhi <= conv_std_logic_vector(15174,24);
            manlo <= conv_std_logic_vector(230487850,28);
      WHEN "1110110101" =>
            manhi <= conv_std_logic_vector(15190,24);
            manlo <= conv_std_logic_vector(234374664,28);
      WHEN "1110110110" =>
            manhi <= conv_std_logic_vector(15206,24);
            manlo <= conv_std_logic_vector(238265577,28);
      WHEN "1110110111" =>
            manhi <= conv_std_logic_vector(15222,24);
            manlo <= conv_std_logic_vector(242160590,28);
      WHEN "1110111000" =>
            manhi <= conv_std_logic_vector(15238,24);
            manlo <= conv_std_logic_vector(246059703,28);
      WHEN "1110111001" =>
            manhi <= conv_std_logic_vector(15254,24);
            manlo <= conv_std_logic_vector(249962916,28);
      WHEN "1110111010" =>
            manhi <= conv_std_logic_vector(15270,24);
            manlo <= conv_std_logic_vector(253870228,28);
      WHEN "1110111011" =>
            manhi <= conv_std_logic_vector(15286,24);
            manlo <= conv_std_logic_vector(257781640,28);
      WHEN "1110111100" =>
            manhi <= conv_std_logic_vector(15302,24);
            manlo <= conv_std_logic_vector(261697152,28);
      WHEN "1110111101" =>
            manhi <= conv_std_logic_vector(15318,24);
            manlo <= conv_std_logic_vector(265616763,28);
      WHEN "1110111110" =>
            manhi <= conv_std_logic_vector(15335,24);
            manlo <= conv_std_logic_vector(1105018,28);
      WHEN "1110111111" =>
            manhi <= conv_std_logic_vector(15351,24);
            manlo <= conv_std_logic_vector(5032829,28);
      WHEN "1111000000" =>
            manhi <= conv_std_logic_vector(15367,24);
            manlo <= conv_std_logic_vector(8964740,28);
      WHEN "1111000001" =>
            manhi <= conv_std_logic_vector(15383,24);
            manlo <= conv_std_logic_vector(12900750,28);
      WHEN "1111000010" =>
            manhi <= conv_std_logic_vector(15399,24);
            manlo <= conv_std_logic_vector(16840860,28);
      WHEN "1111000011" =>
            manhi <= conv_std_logic_vector(15415,24);
            manlo <= conv_std_logic_vector(20785070,28);
      WHEN "1111000100" =>
            manhi <= conv_std_logic_vector(15431,24);
            manlo <= conv_std_logic_vector(24733380,28);
      WHEN "1111000101" =>
            manhi <= conv_std_logic_vector(15447,24);
            manlo <= conv_std_logic_vector(28685790,28);
      WHEN "1111000110" =>
            manhi <= conv_std_logic_vector(15463,24);
            manlo <= conv_std_logic_vector(32642299,28);
      WHEN "1111000111" =>
            manhi <= conv_std_logic_vector(15479,24);
            manlo <= conv_std_logic_vector(36602908,28);
      WHEN "1111001000" =>
            manhi <= conv_std_logic_vector(15495,24);
            manlo <= conv_std_logic_vector(40567617,28);
      WHEN "1111001001" =>
            manhi <= conv_std_logic_vector(15511,24);
            manlo <= conv_std_logic_vector(44536425,28);
      WHEN "1111001010" =>
            manhi <= conv_std_logic_vector(15527,24);
            manlo <= conv_std_logic_vector(48509334,28);
      WHEN "1111001011" =>
            manhi <= conv_std_logic_vector(15543,24);
            manlo <= conv_std_logic_vector(52486342,28);
      WHEN "1111001100" =>
            manhi <= conv_std_logic_vector(15559,24);
            manlo <= conv_std_logic_vector(56467450,28);
      WHEN "1111001101" =>
            manhi <= conv_std_logic_vector(15575,24);
            manlo <= conv_std_logic_vector(60452657,28);
      WHEN "1111001110" =>
            manhi <= conv_std_logic_vector(15591,24);
            manlo <= conv_std_logic_vector(64441965,28);
      WHEN "1111001111" =>
            manhi <= conv_std_logic_vector(15607,24);
            manlo <= conv_std_logic_vector(68435372,28);
      WHEN "1111010000" =>
            manhi <= conv_std_logic_vector(15623,24);
            manlo <= conv_std_logic_vector(72432880,28);
      WHEN "1111010001" =>
            manhi <= conv_std_logic_vector(15639,24);
            manlo <= conv_std_logic_vector(76434487,28);
      WHEN "1111010010" =>
            manhi <= conv_std_logic_vector(15655,24);
            manlo <= conv_std_logic_vector(80440193,28);
      WHEN "1111010011" =>
            manhi <= conv_std_logic_vector(15671,24);
            manlo <= conv_std_logic_vector(84450000,28);
      WHEN "1111010100" =>
            manhi <= conv_std_logic_vector(15687,24);
            manlo <= conv_std_logic_vector(88463906,28);
      WHEN "1111010101" =>
            manhi <= conv_std_logic_vector(15703,24);
            manlo <= conv_std_logic_vector(92481913,28);
      WHEN "1111010110" =>
            manhi <= conv_std_logic_vector(15719,24);
            manlo <= conv_std_logic_vector(96504019,28);
      WHEN "1111010111" =>
            manhi <= conv_std_logic_vector(15735,24);
            manlo <= conv_std_logic_vector(100530225,28);
      WHEN "1111011000" =>
            manhi <= conv_std_logic_vector(15751,24);
            manlo <= conv_std_logic_vector(104560531,28);
      WHEN "1111011001" =>
            manhi <= conv_std_logic_vector(15767,24);
            manlo <= conv_std_logic_vector(108594936,28);
      WHEN "1111011010" =>
            manhi <= conv_std_logic_vector(15783,24);
            manlo <= conv_std_logic_vector(112633442,28);
      WHEN "1111011011" =>
            manhi <= conv_std_logic_vector(15799,24);
            manlo <= conv_std_logic_vector(116676047,28);
      WHEN "1111011100" =>
            manhi <= conv_std_logic_vector(15815,24);
            manlo <= conv_std_logic_vector(120722752,28);
      WHEN "1111011101" =>
            manhi <= conv_std_logic_vector(15831,24);
            manlo <= conv_std_logic_vector(124773557,28);
      WHEN "1111011110" =>
            manhi <= conv_std_logic_vector(15847,24);
            manlo <= conv_std_logic_vector(128828462,28);
      WHEN "1111011111" =>
            manhi <= conv_std_logic_vector(15863,24);
            manlo <= conv_std_logic_vector(132887467,28);
      WHEN "1111100000" =>
            manhi <= conv_std_logic_vector(15879,24);
            manlo <= conv_std_logic_vector(136950572,28);
      WHEN "1111100001" =>
            manhi <= conv_std_logic_vector(15895,24);
            manlo <= conv_std_logic_vector(141017776,28);
      WHEN "1111100010" =>
            manhi <= conv_std_logic_vector(15911,24);
            manlo <= conv_std_logic_vector(145089081,28);
      WHEN "1111100011" =>
            manhi <= conv_std_logic_vector(15927,24);
            manlo <= conv_std_logic_vector(149164485,28);
      WHEN "1111100100" =>
            manhi <= conv_std_logic_vector(15943,24);
            manlo <= conv_std_logic_vector(153243989,28);
      WHEN "1111100101" =>
            manhi <= conv_std_logic_vector(15959,24);
            manlo <= conv_std_logic_vector(157327593,28);
      WHEN "1111100110" =>
            manhi <= conv_std_logic_vector(15975,24);
            manlo <= conv_std_logic_vector(161415297,28);
      WHEN "1111100111" =>
            manhi <= conv_std_logic_vector(15991,24);
            manlo <= conv_std_logic_vector(165507101,28);
      WHEN "1111101000" =>
            manhi <= conv_std_logic_vector(16007,24);
            manlo <= conv_std_logic_vector(169603005,28);
      WHEN "1111101001" =>
            manhi <= conv_std_logic_vector(16023,24);
            manlo <= conv_std_logic_vector(173703009,28);
      WHEN "1111101010" =>
            manhi <= conv_std_logic_vector(16039,24);
            manlo <= conv_std_logic_vector(177807112,28);
      WHEN "1111101011" =>
            manhi <= conv_std_logic_vector(16055,24);
            manlo <= conv_std_logic_vector(181915316,28);
      WHEN "1111101100" =>
            manhi <= conv_std_logic_vector(16071,24);
            manlo <= conv_std_logic_vector(186027619,28);
      WHEN "1111101101" =>
            manhi <= conv_std_logic_vector(16087,24);
            manlo <= conv_std_logic_vector(190144023,28);
      WHEN "1111101110" =>
            manhi <= conv_std_logic_vector(16103,24);
            manlo <= conv_std_logic_vector(194264526,28);
      WHEN "1111101111" =>
            manhi <= conv_std_logic_vector(16119,24);
            manlo <= conv_std_logic_vector(198389129,28);
      WHEN "1111110000" =>
            manhi <= conv_std_logic_vector(16135,24);
            manlo <= conv_std_logic_vector(202517832,28);
      WHEN "1111110001" =>
            manhi <= conv_std_logic_vector(16151,24);
            manlo <= conv_std_logic_vector(206650635,28);
      WHEN "1111110010" =>
            manhi <= conv_std_logic_vector(16167,24);
            manlo <= conv_std_logic_vector(210787538,28);
      WHEN "1111110011" =>
            manhi <= conv_std_logic_vector(16183,24);
            manlo <= conv_std_logic_vector(214928541,28);
      WHEN "1111110100" =>
            manhi <= conv_std_logic_vector(16199,24);
            manlo <= conv_std_logic_vector(219073644,28);
      WHEN "1111110101" =>
            manhi <= conv_std_logic_vector(16215,24);
            manlo <= conv_std_logic_vector(223222847,28);
      WHEN "1111110110" =>
            manhi <= conv_std_logic_vector(16231,24);
            manlo <= conv_std_logic_vector(227376150,28);
      WHEN "1111110111" =>
            manhi <= conv_std_logic_vector(16247,24);
            manlo <= conv_std_logic_vector(231533553,28);
      WHEN "1111111000" =>
            manhi <= conv_std_logic_vector(16263,24);
            manlo <= conv_std_logic_vector(235695056,28);
      WHEN "1111111001" =>
            manhi <= conv_std_logic_vector(16279,24);
            manlo <= conv_std_logic_vector(239860659,28);
      WHEN "1111111010" =>
            manhi <= conv_std_logic_vector(16295,24);
            manlo <= conv_std_logic_vector(244030361,28);
      WHEN "1111111011" =>
            manhi <= conv_std_logic_vector(16311,24);
            manlo <= conv_std_logic_vector(248204164,28);
      WHEN "1111111100" =>
            manhi <= conv_std_logic_vector(16327,24);
            manlo <= conv_std_logic_vector(252382067,28);
      WHEN "1111111101" =>
            manhi <= conv_std_logic_vector(16343,24);
            manlo <= conv_std_logic_vector(256564069,28);
      WHEN "1111111110" =>
            manhi <= conv_std_logic_vector(16359,24);
            manlo <= conv_std_logic_vector(260750172,28);
      WHEN "1111111111" =>
            manhi <= conv_std_logic_vector(16375,24);
            manlo <= conv_std_logic_vector(264940375,28);
      WHEN others =>
           manhi <= conv_std_logic_vector(0,24);
           manlo <= conv_std_logic_vector(0,28);
    END CASE;
  END PROCESS;

END rtl;
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_EXPLUTNEG.VHD                          ***
--***                                             ***
--***   Function: Look Up Table - EXP()           ***
--***                                             ***
--***   Generated by MATLAB Utility               ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_explutneg IS
PORT (
      add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
      manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
      manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1);
      exponent : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
     );
END dp_explutneg;

ARCHITECTURE rtl OF dp_explutneg IS

BEGIN

  pca: PROCESS (add)
  BEGIN
    CASE add IS
      WHEN "0000000000" =>
            manhi <= conv_std_logic_vector(0,24);
            manlo <= conv_std_logic_vector(0,28);
            exponent <= conv_std_logic_vector(1023,11);
      WHEN "0000000001" =>
            manhi <= conv_std_logic_vector(7910755,24);
            manlo <= conv_std_logic_vector(103608120,28);
            exponent <= conv_std_logic_vector(1021,11);
      WHEN "0000000010" =>
            manhi <= conv_std_logic_vector(1387178,24);
            manlo <= conv_std_logic_vector(62882252,28);
            exponent <= conv_std_logic_vector(1020,11);
      WHEN "0000000011" =>
            manhi <= conv_std_logic_vector(9952012,24);
            manlo <= conv_std_logic_vector(214872239,28);
            exponent <= conv_std_logic_vector(1018,11);
      WHEN "0000000100" =>
            manhi <= conv_std_logic_vector(2889051,24);
            manlo <= conv_std_logic_vector(136396020,28);
            exponent <= conv_std_logic_vector(1017,11);
      WHEN "0000000101" =>
            manhi <= conv_std_logic_vector(12162046,24);
            manlo <= conv_std_logic_vector(873334,28);
            exponent <= conv_std_logic_vector(1015,11);
      WHEN "0000000110" =>
            manhi <= conv_std_logic_vector(4515103,24);
            manlo <= conv_std_logic_vector(18076886,28);
            exponent <= conv_std_logic_vector(1014,11);
      WHEN "0000000111" =>
            manhi <= conv_std_logic_vector(14554809,24);
            manlo <= conv_std_logic_vector(203729295,28);
            exponent <= conv_std_logic_vector(1012,11);
      WHEN "0000001000" =>
            manhi <= conv_std_logic_vector(6275600,24);
            manlo <= conv_std_logic_vector(68167597,28);
            exponent <= conv_std_logic_vector(1011,11);
      WHEN "0000001001" =>
            manhi <= conv_std_logic_vector(184098,24);
            manlo <= conv_std_logic_vector(86398042,28);
            exponent <= conv_std_logic_vector(1010,11);
      WHEN "0000001010" =>
            manhi <= conv_std_logic_vector(8181659,24);
            manlo <= conv_std_logic_vector(90471578,28);
            exponent <= conv_std_logic_vector(1008,11);
      WHEN "0000001011" =>
            manhi <= conv_std_logic_vector(1586498,24);
            manlo <= conv_std_logic_vector(59729764,28);
            exponent <= conv_std_logic_vector(1007,11);
      WHEN "0000001100" =>
            manhi <= conv_std_logic_vector(10245315,24);
            manlo <= conv_std_logic_vector(188988555,28);
            exponent <= conv_std_logic_vector(1005,11);
      WHEN "0000001101" =>
            manhi <= conv_std_logic_vector(3104851,24);
            manlo <= conv_std_logic_vector(194518424,28);
            exponent <= conv_std_logic_vector(1004,11);
      WHEN "0000001110" =>
            manhi <= conv_std_logic_vector(12479599,24);
            manlo <= conv_std_logic_vector(229643794,28);
            exponent <= conv_std_logic_vector(1002,11);
      WHEN "0000001111" =>
            manhi <= conv_std_logic_vector(4748746,24);
            manlo <= conv_std_logic_vector(36170808,28);
            exponent <= conv_std_logic_vector(1001,11);
      WHEN "0000010000" =>
            manhi <= conv_std_logic_vector(14898619,24);
            manlo <= conv_std_logic_vector(183403979,28);
            exponent <= conv_std_logic_vector(999,11);
      WHEN "0000010001" =>
            manhi <= conv_std_logic_vector(6528561,24);
            manlo <= conv_std_logic_vector(123365533,28);
            exponent <= conv_std_logic_vector(998,11);
      WHEN "0000010010" =>
            manhi <= conv_std_logic_vector(370216,24);
            manlo <= conv_std_logic_vector(208248737,28);
            exponent <= conv_std_logic_vector(997,11);
      WHEN "0000010011" =>
            manhi <= conv_std_logic_vector(8455535,24);
            manlo <= conv_std_logic_vector(254564210,28);
            exponent <= conv_std_logic_vector(995,11);
      WHEN "0000010100" =>
            manhi <= conv_std_logic_vector(1788005,24);
            manlo <= conv_std_logic_vector(99840615,28);
            exponent <= conv_std_logic_vector(994,11);
      WHEN "0000010101" =>
            manhi <= conv_std_logic_vector(10541837,24);
            manlo <= conv_std_logic_vector(14529516,28);
            exponent <= conv_std_logic_vector(992,11);
      WHEN "0000010110" =>
            manhi <= conv_std_logic_vector(3323019,24);
            manlo <= conv_std_logic_vector(252804514,28);
            exponent <= conv_std_logic_vector(991,11);
      WHEN "0000010111" =>
            manhi <= conv_std_logic_vector(12800638,24);
            manlo <= conv_std_logic_vector(70515377,28);
            exponent <= conv_std_logic_vector(989,11);
      WHEN "0000011000" =>
            manhi <= conv_std_logic_vector(4984952,24);
            manlo <= conv_std_logic_vector(266936970,28);
            exponent <= conv_std_logic_vector(988,11);
      WHEN "0000011001" =>
            manhi <= conv_std_logic_vector(15246202,24);
            manlo <= conv_std_logic_vector(73384750,28);
            exponent <= conv_std_logic_vector(986,11);
      WHEN "0000011010" =>
            manhi <= conv_std_logic_vector(6784298,24);
            manlo <= conv_std_logic_vector(117472834,28);
            exponent <= conv_std_logic_vector(985,11);
      WHEN "0000011011" =>
            manhi <= conv_std_logic_vector(558377,24);
            manlo <= conv_std_logic_vector(141983386,28);
            exponent <= conv_std_logic_vector(984,11);
      WHEN "0000011100" =>
            manhi <= conv_std_logic_vector(8732417,24);
            manlo <= conv_std_logic_vector(225268666,28);
            exponent <= conv_std_logic_vector(982,11);
      WHEN "0000011101" =>
            manhi <= conv_std_logic_vector(1991723,24);
            manlo <= conv_std_logic_vector(183207072,28);
            exponent <= conv_std_logic_vector(981,11);
      WHEN "0000011110" =>
            manhi <= conv_std_logic_vector(10841612,24);
            manlo <= conv_std_logic_vector(44859253,28);
            exponent <= conv_std_logic_vector(979,11);
      WHEN "0000011111" =>
            manhi <= conv_std_logic_vector(3543582,24);
            manlo <= conv_std_logic_vector(38615994,28);
            exponent <= conv_std_logic_vector(978,11);
      WHEN "0000100000" =>
            manhi <= conv_std_logic_vector(13125199,24);
            manlo <= conv_std_logic_vector(123823208,28);
            exponent <= conv_std_logic_vector(976,11);
      WHEN "0000100001" =>
            manhi <= conv_std_logic_vector(5223751,24);
            manlo <= conv_std_logic_vector(209149352,28);
            exponent <= conv_std_logic_vector(975,11);
      WHEN "0000100010" =>
            manhi <= conv_std_logic_vector(15597598,24);
            manlo <= conv_std_logic_vector(248916640,28);
            exponent <= conv_std_logic_vector(973,11);
      WHEN "0000100011" =>
            manhi <= conv_std_logic_vector(7042841,24);
            manlo <= conv_std_logic_vector(173666528,28);
            exponent <= conv_std_logic_vector(972,11);
      WHEN "0000100100" =>
            manhi <= conv_std_logic_vector(748602,24);
            manlo <= conv_std_logic_vector(266199140,28);
            exponent <= conv_std_logic_vector(971,11);
      WHEN "0000100101" =>
            manhi <= conv_std_logic_vector(9012337,24);
            manlo <= conv_std_logic_vector(264921173,28);
            exponent <= conv_std_logic_vector(969,11);
      WHEN "0000100110" =>
            manhi <= conv_std_logic_vector(2197677,24);
            manlo <= conv_std_logic_vector(112079619,28);
            exponent <= conv_std_logic_vector(968,11);
      WHEN "0000100111" =>
            manhi <= conv_std_logic_vector(11144676,24);
            manlo <= conv_std_logic_vector(200497976,28);
            exponent <= conv_std_logic_vector(966,11);
      WHEN "0000101000" =>
            manhi <= conv_std_logic_vector(3766564,24);
            manlo <= conv_std_logic_vector(161159716,28);
            exponent <= conv_std_logic_vector(965,11);
      WHEN "0000101001" =>
            manhi <= conv_std_logic_vector(13453322,24);
            manlo <= conv_std_logic_vector(28788768,28);
            exponent <= conv_std_logic_vector(963,11);
      WHEN "0000101010" =>
            manhi <= conv_std_logic_vector(5465170,24);
            manlo <= conv_std_logic_vector(249755484,28);
            exponent <= conv_std_logic_vector(962,11);
      WHEN "0000101011" =>
            manhi <= conv_std_logic_vector(15952851,24);
            manlo <= conv_std_logic_vector(133443390,28);
            exponent <= conv_std_logic_vector(960,11);
      WHEN "0000101100" =>
            manhi <= conv_std_logic_vector(7304221,24);
            manlo <= conv_std_logic_vector(236407020,28);
            exponent <= conv_std_logic_vector(959,11);
      WHEN "0000101101" =>
            manhi <= conv_std_logic_vector(940915,24);
            manlo <= conv_std_logic_vector(220198205,28);
            exponent <= conv_std_logic_vector(958,11);
      WHEN "0000101110" =>
            manhi <= conv_std_logic_vector(9295329,24);
            manlo <= conv_std_logic_vector(196124030,28);
            exponent <= conv_std_logic_vector(956,11);
      WHEN "0000101111" =>
            manhi <= conv_std_logic_vector(2405891,24);
            manlo <= conv_std_logic_vector(28613594,28);
            exponent <= conv_std_logic_vector(955,11);
      WHEN "0000110000" =>
            manhi <= conv_std_logic_vector(11451066,24);
            manlo <= conv_std_logic_vector(238698933,28);
            exponent <= conv_std_logic_vector(953,11);
      WHEN "0000110001" =>
            manhi <= conv_std_logic_vector(3991993,24);
            manlo <= conv_std_logic_vector(233279365,28);
            exponent <= conv_std_logic_vector(952,11);
      WHEN "0000110010" =>
            manhi <= conv_std_logic_vector(13785045,24);
            manlo <= conv_std_logic_vector(75368511,28);
            exponent <= conv_std_logic_vector(950,11);
      WHEN "0000110011" =>
            manhi <= conv_std_logic_vector(5709239,24);
            manlo <= conv_std_logic_vector(54173026,28);
            exponent <= conv_std_logic_vector(949,11);
      WHEN "0000110100" =>
            manhi <= conv_std_logic_vector(16312002,24);
            manlo <= conv_std_logic_vector(78993710,28);
            exponent <= conv_std_logic_vector(947,11);
      WHEN "0000110101" =>
            manhi <= conv_std_logic_vector(7568470,24);
            manlo <= conv_std_logic_vector(72422582,28);
            exponent <= conv_std_logic_vector(946,11);
      WHEN "0000110110" =>
            manhi <= conv_std_logic_vector(1135338,24);
            manlo <= conv_std_logic_vector(246889480,28);
            exponent <= conv_std_logic_vector(945,11);
      WHEN "0000110111" =>
            manhi <= conv_std_logic_vector(9581426,24);
            manlo <= conv_std_logic_vector(208117876,28);
            exponent <= conv_std_logic_vector(943,11);
      WHEN "0000111000" =>
            manhi <= conv_std_logic_vector(2616389,24);
            manlo <= conv_std_logic_vector(147217980,28);
            exponent <= conv_std_logic_vector(942,11);
      WHEN "0000111001" =>
            manhi <= conv_std_logic_vector(11760819,24);
            manlo <= conv_std_logic_vector(23037889,28);
            exponent <= conv_std_logic_vector(940,11);
      WHEN "0000111010" =>
            manhi <= conv_std_logic_vector(4219896,24);
            manlo <= conv_std_logic_vector(214481816,28);
            exponent <= conv_std_logic_vector(939,11);
      WHEN "0000111011" =>
            manhi <= conv_std_logic_vector(14120408,24);
            manlo <= conv_std_logic_vector(131761485,28);
            exponent <= conv_std_logic_vector(937,11);
      WHEN "0000111100" =>
            manhi <= conv_std_logic_vector(5955985,24);
            manlo <= conv_std_logic_vector(177821786,28);
            exponent <= conv_std_logic_vector(936,11);
      WHEN "0000111101" =>
            manhi <= conv_std_logic_vector(16675094,24);
            manlo <= conv_std_logic_vector(25356748,28);
            exponent <= conv_std_logic_vector(934,11);
      WHEN "0000111110" =>
            manhi <= conv_std_logic_vector(7835618,24);
            manlo <= conv_std_logic_vector(77011020,28);
            exponent <= conv_std_logic_vector(933,11);
      WHEN "0000111111" =>
            manhi <= conv_std_logic_vector(1331895,24);
            manlo <= conv_std_logic_vector(119779026,28);
            exponent <= conv_std_logic_vector(932,11);
      WHEN "0001000000" =>
            manhi <= conv_std_logic_vector(9870663,24);
            manlo <= conv_std_logic_vector(52552908,28);
            exponent <= conv_std_logic_vector(930,11);
      WHEN "0001000001" =>
            manhi <= conv_std_logic_vector(2829197,24);
            manlo <= conv_std_logic_vector(218477336,28);
            exponent <= conv_std_logic_vector(929,11);
      WHEN "0001000010" =>
            manhi <= conv_std_logic_vector(12073970,24);
            manlo <= conv_std_logic_vector(61450731,28);
            exponent <= conv_std_logic_vector(927,11);
      WHEN "0001000011" =>
            manhi <= conv_std_logic_vector(4450300,24);
            manlo <= conv_std_logic_vector(143360086,28);
            exponent <= conv_std_logic_vector(926,11);
      WHEN "0001000100" =>
            manhi <= conv_std_logic_vector(14459451,24);
            manlo <= conv_std_logic_vector(182543396,28);
            exponent <= conv_std_logic_vector(924,11);
      WHEN "0001000101" =>
            manhi <= conv_std_logic_vector(6205439,24);
            manlo <= conv_std_logic_vector(188004913,28);
            exponent <= conv_std_logic_vector(923,11);
      WHEN "0001000110" =>
            manhi <= conv_std_logic_vector(132477,24);
            manlo <= conv_std_logic_vector(19160299,28);
            exponent <= conv_std_logic_vector(922,11);
      WHEN "0001000111" =>
            manhi <= conv_std_logic_vector(8105697,24);
            manlo <= conv_std_logic_vector(201304075,28);
            exponent <= conv_std_logic_vector(920,11);
      WHEN "0001001000" =>
            manhi <= conv_std_logic_vector(1530608,24);
            manlo <= conv_std_logic_vector(217452229,28);
            exponent <= conv_std_logic_vector(919,11);
      WHEN "0001001001" =>
            manhi <= conv_std_logic_vector(10163073,24);
            manlo <= conv_std_logic_vector(118320126,28);
            exponent <= conv_std_logic_vector(917,11);
      WHEN "0001001010" =>
            manhi <= conv_std_logic_vector(3044341,24);
            manlo <= conv_std_logic_vector(66824260,28);
            exponent <= conv_std_logic_vector(916,11);
      WHEN "0001001011" =>
            manhi <= conv_std_logic_vector(12390557,24);
            manlo <= conv_std_logic_vector(165235674,28);
            exponent <= conv_std_logic_vector(914,11);
      WHEN "0001001100" =>
            manhi <= conv_std_logic_vector(4683232,24);
            manlo <= conv_std_logic_vector(138461149,28);
            exponent <= conv_std_logic_vector(913,11);
      WHEN "0001001101" =>
            manhi <= conv_std_logic_vector(14802215,24);
            manlo <= conv_std_logic_vector(61508170,28);
            exponent <= conv_std_logic_vector(911,11);
      WHEN "0001001110" =>
            manhi <= conv_std_logic_vector(6457631,24);
            manlo <= conv_std_logic_vector(7025744,28);
            exponent <= conv_std_logic_vector(910,11);
      WHEN "0001001111" =>
            manhi <= conv_std_logic_vector(318029,24);
            manlo <= conv_std_logic_vector(21309721,28);
            exponent <= conv_std_logic_vector(909,11);
      WHEN "0001010000" =>
            manhi <= conv_std_logic_vector(8378740,24);
            manlo <= conv_std_logic_vector(221720132,28);
            exponent <= conv_std_logic_vector(907,11);
      WHEN "0001010001" =>
            manhi <= conv_std_logic_vector(1731502,24);
            manlo <= conv_std_logic_vector(182144977,28);
            exponent <= conv_std_logic_vector(906,11);
      WHEN "0001010010" =>
            manhi <= conv_std_logic_vector(10458692,24);
            manlo <= conv_std_logic_vector(90475423,28);
            exponent <= conv_std_logic_vector(904,11);
      WHEN "0001010011" =>
            manhi <= conv_std_logic_vector(3261845,24);
            manlo <= conv_std_logic_vector(128220642,28);
            exponent <= conv_std_logic_vector(903,11);
      WHEN "0001010100" =>
            manhi <= conv_std_logic_vector(12710618,24);
            manlo <= conv_std_logic_vector(255552070,28);
            exponent <= conv_std_logic_vector(901,11);
      WHEN "0001010101" =>
            manhi <= conv_std_logic_vector(4918720,24);
            manlo <= conv_std_logic_vector(130727832,28);
            exponent <= conv_std_logic_vector(900,11);
      WHEN "0001010110" =>
            manhi <= conv_std_logic_vector(15148739,24);
            manlo <= conv_std_logic_vector(258265342,28);
            exponent <= conv_std_logic_vector(898,11);
      WHEN "0001010111" =>
            manhi <= conv_std_logic_vector(6712589,24);
            manlo <= conv_std_logic_vector(181573149,28);
            exponent <= conv_std_logic_vector(897,11);
      WHEN "0001011000" =>
            manhi <= conv_std_logic_vector(505617,24);
            manlo <= conv_std_logic_vector(45883390,28);
            exponent <= conv_std_logic_vector(896,11);
      WHEN "0001011001" =>
            manhi <= conv_std_logic_vector(8654780,24);
            manlo <= conv_std_logic_vector(9428106,28);
            exponent <= conv_std_logic_vector(894,11);
      WHEN "0001011010" =>
            manhi <= conv_std_logic_vector(1934600,24);
            manlo <= conv_std_logic_vector(262677610,28);
            exponent <= conv_std_logic_vector(893,11);
      WHEN "0001011011" =>
            manhi <= conv_std_logic_vector(10757555,24);
            manlo <= conv_std_logic_vector(25094861,28);
            exponent <= conv_std_logic_vector(891,11);
      WHEN "0001011100" =>
            manhi <= conv_std_logic_vector(3481736,24);
            manlo <= conv_std_logic_vector(108799619,28);
            exponent <= conv_std_logic_vector(890,11);
      WHEN "0001011101" =>
            manhi <= conv_std_logic_vector(13034192,24);
            manlo <= conv_std_logic_vector(96190464,28);
            exponent <= conv_std_logic_vector(888,11);
      WHEN "0001011110" =>
            manhi <= conv_std_logic_vector(5156792,24);
            manlo <= conv_std_logic_vector(132821234,28);
            exponent <= conv_std_logic_vector(887,11);
      WHEN "0001011111" =>
            manhi <= conv_std_logic_vector(15499067,24);
            manlo <= conv_std_logic_vector(40497064,28);
            exponent <= conv_std_logic_vector(885,11);
      WHEN "0001100000" =>
            manhi <= conv_std_logic_vector(6970346,24);
            manlo <= conv_std_logic_vector(4633646,28);
            exponent <= conv_std_logic_vector(884,11);
      WHEN "0001100001" =>
            manhi <= conv_std_logic_vector(695263,24);
            manlo <= conv_std_logic_vector(184734272,28);
            exponent <= conv_std_logic_vector(883,11);
      WHEN "0001100010" =>
            manhi <= conv_std_logic_vector(8933848,24);
            manlo <= conv_std_logic_vector(68258056,28);
            exponent <= conv_std_logic_vector(881,11);
      WHEN "0001100011" =>
            manhi <= conv_std_logic_vector(2139927,24);
            manlo <= conv_std_logic_vector(241478077,28);
            exponent <= conv_std_logic_vector(880,11);
      WHEN "0001100100" =>
            manhi <= conv_std_logic_vector(11059697,24);
            manlo <= conv_std_logic_vector(81964893,28);
            exponent <= conv_std_logic_vector(878,11);
      WHEN "0001100101" =>
            manhi <= conv_std_logic_vector(3704040,24);
            manlo <= conv_std_logic_vector(59435624,28);
            exponent <= conv_std_logic_vector(877,11);
      WHEN "0001100110" =>
            manhi <= conv_std_logic_vector(13361316,24);
            manlo <= conv_std_logic_vector(100097713,28);
            exponent <= conv_std_logic_vector(875,11);
      WHEN "0001100111" =>
            manhi <= conv_std_logic_vector(5397476,24);
            manlo <= conv_std_logic_vector(240017437,28);
            exponent <= conv_std_logic_vector(874,11);
      WHEN "0001101000" =>
            manhi <= conv_std_logic_vector(15853238,24);
            manlo <= conv_std_logic_vector(139632179,28);
            exponent <= conv_std_logic_vector(872,11);
      WHEN "0001101001" =>
            manhi <= conv_std_logic_vector(7230930,24);
            manlo <= conv_std_logic_vector(200816807,28);
            exponent <= conv_std_logic_vector(871,11);
      WHEN "0001101010" =>
            manhi <= conv_std_logic_vector(886991,24);
            manlo <= conv_std_logic_vector(58654941,28);
            exponent <= conv_std_logic_vector(870,11);
      WHEN "0001101011" =>
            manhi <= conv_std_logic_vector(9215978,24);
            manlo <= conv_std_logic_vector(193575030,28);
            exponent <= conv_std_logic_vector(868,11);
      WHEN "0001101100" =>
            manhi <= conv_std_logic_vector(2347507,24);
            manlo <= conv_std_logic_vector(240661664,28);
            exponent <= conv_std_logic_vector(867,11);
      WHEN "0001101101" =>
            manhi <= conv_std_logic_vector(11365154,24);
            manlo <= conv_std_logic_vector(257284930,28);
            exponent <= conv_std_logic_vector(865,11);
      WHEN "0001101110" =>
            manhi <= conv_std_logic_vector(3928783,24);
            manlo <= conv_std_logic_vector(108146246,28);
            exponent <= conv_std_logic_vector(864,11);
      WHEN "0001101111" =>
            manhi <= conv_std_logic_vector(13692029,24);
            manlo <= conv_std_logic_vector(256867284,28);
            exponent <= conv_std_logic_vector(862,11);
      WHEN "0001110000" =>
            manhi <= conv_std_logic_vector(5640802,24);
            manlo <= conv_std_logic_vector(94243132,28);
            exponent <= conv_std_logic_vector(861,11);
      WHEN "0001110001" =>
            manhi <= conv_std_logic_vector(16211296,24);
            manlo <= conv_std_logic_vector(67825654,28);
            exponent <= conv_std_logic_vector(859,11);
      WHEN "0001110010" =>
            manhi <= conv_std_logic_vector(7494374,24);
            manlo <= conv_std_logic_vector(242982196,28);
            exponent <= conv_std_logic_vector(858,11);
      WHEN "0001110011" =>
            manhi <= conv_std_logic_vector(1080822,24);
            manlo <= conv_std_logic_vector(160277009,28);
            exponent <= conv_std_logic_vector(857,11);
      WHEN "0001110100" =>
            manhi <= conv_std_logic_vector(9501205,24);
            manlo <= conv_std_logic_vector(10212621,28);
            exponent <= conv_std_logic_vector(855,11);
      WHEN "0001110101" =>
            manhi <= conv_std_logic_vector(2557365,24);
            manlo <= conv_std_logic_vector(185941944,28);
            exponent <= conv_std_logic_vector(854,11);
      WHEN "0001110110" =>
            manhi <= conv_std_logic_vector(11673964,24);
            manlo <= conv_std_logic_vector(116382402,28);
            exponent <= conv_std_logic_vector(852,11);
      WHEN "0001110111" =>
            manhi <= conv_std_logic_vector(4155992,24);
            manlo <= conv_std_logic_vector(192503267,28);
            exponent <= conv_std_logic_vector(851,11);
      WHEN "0001111000" =>
            manhi <= conv_std_logic_vector(14026372,24);
            manlo <= conv_std_logic_vector(133984890,28);
            exponent <= conv_std_logic_vector(849,11);
      WHEN "0001111001" =>
            manhi <= conv_std_logic_vector(5886797,24);
            manlo <= conv_std_logic_vector(227169396,28);
            exponent <= conv_std_logic_vector(848,11);
      WHEN "0001111010" =>
            manhi <= conv_std_logic_vector(16573282,24);
            manlo <= conv_std_logic_vector(266790864,28);
            exponent <= conv_std_logic_vector(846,11);
      WHEN "0001111011" =>
            manhi <= conv_std_logic_vector(7760709,24);
            manlo <= conv_std_logic_vector(232279832,28);
            exponent <= conv_std_logic_vector(845,11);
      WHEN "0001111100" =>
            manhi <= conv_std_logic_vector(1276780,24);
            manlo <= conv_std_logic_vector(244188460,28);
            exponent <= conv_std_logic_vector(844,11);
      WHEN "0001111101" =>
            manhi <= conv_std_logic_vector(9789561,24);
            manlo <= conv_std_logic_vector(47289108,28);
            exponent <= conv_std_logic_vector(842,11);
      WHEN "0001111110" =>
            manhi <= conv_std_logic_vector(2769526,24);
            manlo <= conv_std_logic_vector(75856665,28);
            exponent <= conv_std_logic_vector(841,11);
      WHEN "0001111111" =>
            manhi <= conv_std_logic_vector(11986162,24);
            manlo <= conv_std_logic_vector(137053172,28);
            exponent <= conv_std_logic_vector(839,11);
      WHEN "0010000000" =>
            manhi <= conv_std_logic_vector(4385695,24);
            manlo <= conv_std_logic_vector(60488459,28);
            exponent <= conv_std_logic_vector(838,11);
      WHEN "0010000001" =>
            manhi <= conv_std_logic_vector(14364383,24);
            manlo <= conv_std_logic_vector(220265084,28);
            exponent <= conv_std_logic_vector(836,11);
      WHEN "0010000010" =>
            manhi <= conv_std_logic_vector(6135492,24);
            manlo <= conv_std_logic_vector(182090040,28);
            exponent <= conv_std_logic_vector(835,11);
      WHEN "0010000011" =>
            manhi <= conv_std_logic_vector(81012,24);
            manlo <= conv_std_logic_vector(249275143,28);
            exponent <= conv_std_logic_vector(834,11);
      WHEN "0010000100" =>
            manhi <= conv_std_logic_vector(8029967,24);
            manlo <= conv_std_logic_vector(93846972,28);
            exponent <= conv_std_logic_vector(832,11);
      WHEN "0010000101" =>
            manhi <= conv_std_logic_vector(1474889,24);
            manlo <= conv_std_logic_vector(132978099,28);
            exponent <= conv_std_logic_vector(831,11);
      WHEN "0010000110" =>
            manhi <= conv_std_logic_vector(10081081,24);
            manlo <= conv_std_logic_vector(128680817,28);
            exponent <= conv_std_logic_vector(829,11);
      WHEN "0010000111" =>
            manhi <= conv_std_logic_vector(2984014,24);
            manlo <= conv_std_logic_vector(251002315,28);
            exponent <= conv_std_logic_vector(828,11);
      WHEN "0010001000" =>
            manhi <= conv_std_logic_vector(12301786,24);
            manlo <= conv_std_logic_vector(100124707,28);
            exponent <= conv_std_logic_vector(826,11);
      WHEN "0010001001" =>
            manhi <= conv_std_logic_vector(4617918,24);
            manlo <= conv_std_logic_vector(76665129,28);
            exponent <= conv_std_logic_vector(825,11);
      WHEN "0010001010" =>
            manhi <= conv_std_logic_vector(14706104,24);
            manlo <= conv_std_logic_vector(48076192,28);
            exponent <= conv_std_logic_vector(823,11);
      WHEN "0010001011" =>
            manhi <= conv_std_logic_vector(6386916,24);
            manlo <= conv_std_logic_vector(125471070,28);
            exponent <= conv_std_logic_vector(822,11);
      WHEN "0010001100" =>
            manhi <= conv_std_logic_vector(266000,24);
            manlo <= conv_std_logic_vector(57624675,28);
            exponent <= conv_std_logic_vector(821,11);
      WHEN "0010001101" =>
            manhi <= conv_std_logic_vector(8302179,24);
            manlo <= conv_std_logic_vector(114693198,28);
            exponent <= conv_std_logic_vector(819,11);
      WHEN "0010001110" =>
            manhi <= conv_std_logic_vector(1675171,24);
            manlo <= conv_std_logic_vector(254852645,28);
            exponent <= conv_std_logic_vector(818,11);
      WHEN "0010001111" =>
            manhi <= conv_std_logic_vector(10375800,24);
            manlo <= conv_std_logic_vector(179426511,28);
            exponent <= conv_std_logic_vector(816,11);
      WHEN "0010010000" =>
            manhi <= conv_std_logic_vector(3200857,24);
            manlo <= conv_std_logic_vector(52664716,28);
            exponent <= conv_std_logic_vector(815,11);
      WHEN "0010010001" =>
            manhi <= conv_std_logic_vector(12620873,24);
            manlo <= conv_std_logic_vector(164386702,28);
            exponent <= conv_std_logic_vector(813,11);
      WHEN "0010010010" =>
            manhi <= conv_std_logic_vector(4852689,24);
            manlo <= conv_std_logic_vector(149310968,28);
            exponent <= conv_std_logic_vector(812,11);
      WHEN "0010010011" =>
            manhi <= conv_std_logic_vector(15051574,24);
            manlo <= conv_std_logic_vector(73675604,28);
            exponent <= conv_std_logic_vector(810,11);
      WHEN "0010010100" =>
            manhi <= conv_std_logic_vector(6641099,24);
            manlo <= conv_std_logic_vector(42591307,28);
            exponent <= conv_std_logic_vector(809,11);
      WHEN "0010010101" =>
            manhi <= conv_std_logic_vector(453017,24);
            manlo <= conv_std_logic_vector(104016801,28);
            exponent <= conv_std_logic_vector(808,11);
      WHEN "0010010110" =>
            manhi <= conv_std_logic_vector(8577378,24);
            manlo <= conv_std_logic_vector(139419332,28);
            exponent <= conv_std_logic_vector(806,11);
      WHEN "0010010111" =>
            manhi <= conv_std_logic_vector(1877652,24);
            manlo <= conv_std_logic_vector(33778363,28);
            exponent <= conv_std_logic_vector(805,11);
      WHEN "0010011000" =>
            manhi <= conv_std_logic_vector(10673753,24);
            manlo <= conv_std_logic_vector(226837452,28);
            exponent <= conv_std_logic_vector(803,11);
      WHEN "0010011001" =>
            manhi <= conv_std_logic_vector(3420078,24);
            manlo <= conv_std_logic_vector(239554874,28);
            exponent <= conv_std_logic_vector(802,11);
      WHEN "0010011010" =>
            manhi <= conv_std_logic_vector(12943462,24);
            manlo <= conv_std_logic_vector(62486566,28);
            exponent <= conv_std_logic_vector(800,11);
      WHEN "0010011011" =>
            manhi <= conv_std_logic_vector(5090036,24);
            manlo <= conv_std_logic_vector(268173235,28);
            exponent <= conv_std_logic_vector(799,11);
      WHEN "0010011100" =>
            manhi <= conv_std_logic_vector(15400835,24);
            manlo <= conv_std_logic_vector(67898261,28);
            exponent <= conv_std_logic_vector(797,11);
      WHEN "0010011101" =>
            manhi <= conv_std_logic_vector(6898071,24);
            manlo <= conv_std_logic_vector(6935226,28);
            exponent <= conv_std_logic_vector(796,11);
      WHEN "0010011110" =>
            manhi <= conv_std_logic_vector(642086,24);
            manlo <= conv_std_logic_vector(193616024,28);
            exponent <= conv_std_logic_vector(795,11);
      WHEN "0010011111" =>
            manhi <= conv_std_logic_vector(8855597,24);
            manlo <= conv_std_logic_vector(108124901,28);
            exponent <= conv_std_logic_vector(793,11);
      WHEN "0010100000" =>
            manhi <= conv_std_logic_vector(2082354,24);
            manlo <= conv_std_logic_vector(37727361,28);
            exponent <= conv_std_logic_vector(792,11);
      WHEN "0010100001" =>
            manhi <= conv_std_logic_vector(10974976,24);
            manlo <= conv_std_logic_vector(133184200,28);
            exponent <= conv_std_logic_vector(790,11);
      WHEN "0010100010" =>
            manhi <= conv_std_logic_vector(3641706,24);
            manlo <= conv_std_logic_vector(35844662,28);
            exponent <= conv_std_logic_vector(789,11);
      WHEN "0010100011" =>
            manhi <= conv_std_logic_vector(13269590,24);
            manlo <= conv_std_logic_vector(175886280,28);
            exponent <= conv_std_logic_vector(787,11);
      WHEN "0010100100" =>
            manhi <= conv_std_logic_vector(5329988,24);
            manlo <= conv_std_logic_vector(236927280,28);
            exponent <= conv_std_logic_vector(786,11);
      WHEN "0010100101" =>
            manhi <= conv_std_logic_vector(15753928,24);
            manlo <= conv_std_logic_vector(191213976,28);
            exponent <= conv_std_logic_vector(784,11);
      WHEN "0010100110" =>
            manhi <= conv_std_logic_vector(7157862,24);
            manlo <= conv_std_logic_vector(181160855,28);
            exponent <= conv_std_logic_vector(783,11);
      WHEN "0010100111" =>
            manhi <= conv_std_logic_vector(833230,24);
            manlo <= conv_std_logic_vector(197197075,28);
            exponent <= conv_std_logic_vector(782,11);
      WHEN "0010101000" =>
            manhi <= conv_std_logic_vector(9136869,24);
            manlo <= conv_std_logic_vector(57456047,28);
            exponent <= conv_std_logic_vector(780,11);
      WHEN "0010101001" =>
            manhi <= conv_std_logic_vector(2289302,24);
            manlo <= conv_std_logic_vector(100400411,28);
            exponent <= conv_std_logic_vector(779,11);
      WHEN "0010101010" =>
            manhi <= conv_std_logic_vector(11279504,24);
            manlo <= conv_std_logic_vector(133702078,28);
            exponent <= conv_std_logic_vector(777,11);
      WHEN "0010101011" =>
            manhi <= conv_std_logic_vector(3865765,24);
            manlo <= conv_std_logic_vector(84791606,28);
            exponent <= conv_std_logic_vector(776,11);
      WHEN "0010101100" =>
            manhi <= conv_std_logic_vector(13599297,24);
            manlo <= conv_std_logic_vector(193913492,28);
            exponent <= conv_std_logic_vector(774,11);
      WHEN "0010101101" =>
            manhi <= conv_std_logic_vector(5572573,24);
            manlo <= conv_std_logic_vector(210951234,28);
            exponent <= conv_std_logic_vector(773,11);
      WHEN "0010101110" =>
            manhi <= conv_std_logic_vector(16110896,24);
            manlo <= conv_std_logic_vector(189751005,28);
            exponent <= conv_std_logic_vector(771,11);
      WHEN "0010101111" =>
            manhi <= conv_std_logic_vector(7420505,24);
            manlo <= conv_std_logic_vector(12771910,28);
            exponent <= conv_std_logic_vector(770,11);
      WHEN "0010110000" =>
            manhi <= conv_std_logic_vector(1026472,24);
            manlo <= conv_std_logic_vector(51864863,28);
            exponent <= conv_std_logic_vector(769,11);
      WHEN "0010110001" =>
            manhi <= conv_std_logic_vector(9421227,24);
            manlo <= conv_std_logic_vector(121664951,28);
            exponent <= conv_std_logic_vector(767,11);
      WHEN "0010110010" =>
            manhi <= conv_std_logic_vector(2498521,24);
            manlo <= conv_std_logic_vector(127312793,28);
            exponent <= conv_std_logic_vector(766,11);
      WHEN "0010110011" =>
            manhi <= conv_std_logic_vector(11587374,24);
            manlo <= conv_std_logic_vector(32431827,28);
            exponent <= conv_std_logic_vector(764,11);
      WHEN "0010110100" =>
            manhi <= conv_std_logic_vector(4092283,24);
            manlo <= conv_std_logic_vector(33663701,28);
            exponent <= conv_std_logic_vector(763,11);
      WHEN "0010110101" =>
            manhi <= conv_std_logic_vector(13932622,24);
            manlo <= conv_std_logic_vector(188745186,28);
            exponent <= conv_std_logic_vector(761,11);
      WHEN "0010110110" =>
            manhi <= conv_std_logic_vector(5817820,24);
            manlo <= conv_std_logic_vector(161368804,28);
            exponent <= conv_std_logic_vector(760,11);
      WHEN "0010110111" =>
            manhi <= conv_std_logic_vector(16471781,24);
            manlo <= conv_std_logic_vector(201946939,28);
            exponent <= conv_std_logic_vector(758,11);
      WHEN "0010111000" =>
            manhi <= conv_std_logic_vector(7686029,24);
            manlo <= conv_std_logic_vector(114155240,28);
            exponent <= conv_std_logic_vector(757,11);
      WHEN "0010111001" =>
            manhi <= conv_std_logic_vector(1221834,24);
            manlo <= conv_std_logic_vector(30217784,28);
            exponent <= conv_std_logic_vector(756,11);
      WHEN "0010111010" =>
            manhi <= conv_std_logic_vector(9708705,24);
            manlo <= conv_std_logic_vector(265245416,28);
            exponent <= conv_std_logic_vector(754,11);
      WHEN "0010111011" =>
            manhi <= conv_std_logic_vector(2710036,24);
            manlo <= conv_std_logic_vector(96582323,28);
            exponent <= conv_std_logic_vector(753,11);
      WHEN "0010111100" =>
            manhi <= conv_std_logic_vector(11898622,24);
            manlo <= conv_std_logic_vector(8685564,28);
            exponent <= conv_std_logic_vector(751,11);
      WHEN "0010111101" =>
            manhi <= conv_std_logic_vector(4321286,24);
            manlo <= conv_std_logic_vector(145205332,28);
            exponent <= conv_std_logic_vector(750,11);
      WHEN "0010111110" =>
            manhi <= conv_std_logic_vector(14269605,24);
            manlo <= conv_std_logic_vector(79792252,28);
            exponent <= conv_std_logic_vector(748,11);
      WHEN "0010111111" =>
            manhi <= conv_std_logic_vector(6065758,24);
            manlo <= conv_std_logic_vector(144408455,28);
            exponent <= conv_std_logic_vector(747,11);
      WHEN "0011000000" =>
            manhi <= conv_std_logic_vector(29705,24);
            manlo <= conv_std_logic_vector(111518540,28);
            exponent <= conv_std_logic_vector(746,11);
      WHEN "0011000001" =>
            manhi <= conv_std_logic_vector(7954467,24);
            manlo <= conv_std_logic_vector(116097284,28);
            exponent <= conv_std_logic_vector(744,11);
      WHEN "0011000010" =>
            manhi <= conv_std_logic_vector(1419339,24);
            manlo <= conv_std_logic_vector(204212637,28);
            exponent <= conv_std_logic_vector(743,11);
      WHEN "0011000011" =>
            manhi <= conv_std_logic_vector(9999339,24);
            manlo <= conv_std_logic_vector(15580207,28);
            exponent <= conv_std_logic_vector(741,11);
      WHEN "0011000100" =>
            manhi <= conv_std_logic_vector(2923872,24);
            manlo <= conv_std_logic_vector(59726033,28);
            exponent <= conv_std_logic_vector(740,11);
      WHEN "0011000101" =>
            manhi <= conv_std_logic_vector(12213285,24);
            manlo <= conv_std_logic_vector(81348195,28);
            exponent <= conv_std_logic_vector(738,11);
      WHEN "0011000110" =>
            manhi <= conv_std_logic_vector(4552802,24);
            manlo <= conv_std_logic_vector(224758002,28);
            exponent <= conv_std_logic_vector(737,11);
      WHEN "0011000111" =>
            manhi <= conv_std_logic_vector(14610285,24);
            manlo <= conv_std_logic_vector(171839647,28);
            exponent <= conv_std_logic_vector(735,11);
      WHEN "0011001000" =>
            manhi <= conv_std_logic_vector(6316417,24);
            manlo <= conv_std_logic_vector(33901818,28);
            exponent <= conv_std_logic_vector(734,11);
      WHEN "0011001001" =>
            manhi <= conv_std_logic_vector(214129,24);
            manlo <= conv_std_logic_vector(187432044,28);
            exponent <= conv_std_logic_vector(733,11);
      WHEN "0011001010" =>
            manhi <= conv_std_logic_vector(8225851,24);
            manlo <= conv_std_logic_vector(10972428,28);
            exponent <= conv_std_logic_vector(731,11);
      WHEN "0011001011" =>
            manhi <= conv_std_logic_vector(1619012,24);
            manlo <= conv_std_logic_vector(177473085,28);
            exponent <= conv_std_logic_vector(730,11);
      WHEN "0011001100" =>
            manhi <= conv_std_logic_vector(10293161,24);
            manlo <= conv_std_logic_vector(74648462,28);
            exponent <= conv_std_logic_vector(728,11);
      WHEN "0011001101" =>
            manhi <= conv_std_logic_vector(3140054,24);
            manlo <= conv_std_logic_vector(142465582,28);
            exponent <= conv_std_logic_vector(727,11);
      WHEN "0011001110" =>
            manhi <= conv_std_logic_vector(12531401,24);
            manlo <= conv_std_logic_vector(110062606,28);
            exponent <= conv_std_logic_vector(725,11);
      WHEN "0011001111" =>
            manhi <= conv_std_logic_vector(4786859,24);
            manlo <= conv_std_logic_vector(158003247,28);
            exponent <= conv_std_logic_vector(724,11);
      WHEN "0011010000" =>
            manhi <= conv_std_logic_vector(14954704,24);
            manlo <= conv_std_logic_vector(82587752,28);
            exponent <= conv_std_logic_vector(722,11);
      WHEN "0011010001" =>
            manhi <= conv_std_logic_vector(6569826,24);
            manlo <= conv_std_logic_vector(59098716,28);
            exponent <= conv_std_logic_vector(721,11);
      WHEN "0011010010" =>
            manhi <= conv_std_logic_vector(400577,24);
            manlo <= conv_std_logic_vector(185198176,28);
            exponent <= conv_std_logic_vector(720,11);
      WHEN "0011010011" =>
            manhi <= conv_std_logic_vector(8500212,24);
            manlo <= conv_std_logic_vector(153765179,28);
            exponent <= conv_std_logic_vector(718,11);
      WHEN "0011010100" =>
            manhi <= conv_std_logic_vector(1820876,24);
            manlo <= conv_std_logic_vector(159783545,28);
            exponent <= conv_std_logic_vector(717,11);
      WHEN "0011010101" =>
            manhi <= conv_std_logic_vector(10590207,24);
            manlo <= conv_std_logic_vector(172648734,28);
            exponent <= conv_std_logic_vector(715,11);
      WHEN "0011010110" =>
            manhi <= conv_std_logic_vector(3358609,24);
            manlo <= conv_std_logic_vector(8670608,28);
            exponent <= conv_std_logic_vector(714,11);
      WHEN "0011010111" =>
            manhi <= conv_std_logic_vector(12853008,24);
            manlo <= conv_std_logic_vector(64863304,28);
            exponent <= conv_std_logic_vector(712,11);
      WHEN "0011011000" =>
            manhi <= conv_std_logic_vector(5023484,24);
            manlo <= conv_std_logic_vector(180279682,28);
            exponent <= conv_std_logic_vector(711,11);
      WHEN "0011011001" =>
            manhi <= conv_std_logic_vector(15302902,24);
            manlo <= conv_std_logic_vector(86126918,28);
            exponent <= conv_std_logic_vector(709,11);
      WHEN "0011011010" =>
            manhi <= conv_std_logic_vector(6826016,24);
            manlo <= conv_std_logic_vector(315265,28);
            exponent <= conv_std_logic_vector(708,11);
      WHEN "0011011011" =>
            manhi <= conv_std_logic_vector(589071,24);
            manlo <= conv_std_logic_vector(160219440,28);
            exponent <= conv_std_logic_vector(707,11);
      WHEN "0011011100" =>
            manhi <= conv_std_logic_vector(8777584,24);
            manlo <= conv_std_logic_vector(189361726,28);
            exponent <= conv_std_logic_vector(705,11);
      WHEN "0011011101" =>
            manhi <= conv_std_logic_vector(2024955,24);
            manlo <= conv_std_logic_vector(162543151,28);
            exponent <= conv_std_logic_vector(704,11);
      WHEN "0011011110" =>
            manhi <= conv_std_logic_vector(10890513,24);
            manlo <= conv_std_logic_vector(142859647,28);
            exponent <= conv_std_logic_vector(702,11);
      WHEN "0011011111" =>
            manhi <= conv_std_logic_vector(3579561,24);
            manlo <= conv_std_logic_vector(203359193,28);
            exponent <= conv_std_logic_vector(701,11);
      WHEN "0011100000" =>
            manhi <= conv_std_logic_vector(13178144,24);
            manlo <= conv_std_logic_vector(27387766,28);
            exponent <= conv_std_logic_vector(699,11);
      WHEN "0011100001" =>
            manhi <= conv_std_logic_vector(5262706,24);
            manlo <= conv_std_logic_vector(72167880,28);
            exponent <= conv_std_logic_vector(698,11);
      WHEN "0011100010" =>
            manhi <= conv_std_logic_vector(15654921,24);
            manlo <= conv_std_logic_vector(40507130,28);
            exponent <= conv_std_logic_vector(696,11);
      WHEN "0011100011" =>
            manhi <= conv_std_logic_vector(7085016,24);
            manlo <= conv_std_logic_vector(263640644,28);
            exponent <= conv_std_logic_vector(695,11);
      WHEN "0011100100" =>
            manhi <= conv_std_logic_vector(779633,24);
            manlo <= conv_std_logic_vector(233308885,28);
            exponent <= conv_std_logic_vector(694,11);
      WHEN "0011100101" =>
            manhi <= conv_std_logic_vector(9058000,24);
            manlo <= conv_std_logic_vector(127336500,28);
            exponent <= conv_std_logic_vector(692,11);
      WHEN "0011100110" =>
            manhi <= conv_std_logic_vector(2231273,24);
            manlo <= conv_std_logic_vector(267969878,28);
            exponent <= conv_std_logic_vector(691,11);
      WHEN "0011100111" =>
            manhi <= conv_std_logic_vector(11194114,24);
            manlo <= conv_std_logic_vector(191206462,28);
            exponent <= conv_std_logic_vector(689,11);
      WHEN "0011101000" =>
            manhi <= conv_std_logic_vector(3802939,24);
            manlo <= conv_std_logic_vector(6046440,28);
            exponent <= conv_std_logic_vector(688,11);
      WHEN "0011101001" =>
            manhi <= conv_std_logic_vector(13506847,24);
            manlo <= conv_std_logic_vector(192101060,28);
            exponent <= conv_std_logic_vector(686,11);
      WHEN "0011101010" =>
            manhi <= conv_std_logic_vector(5504552,24);
            manlo <= conv_std_logic_vector(234133234,28);
            exponent <= conv_std_logic_vector(685,11);
      WHEN "0011101011" =>
            manhi <= conv_std_logic_vector(16010802,24);
            manlo <= conv_std_logic_vector(194370273,28);
            exponent <= conv_std_logic_vector(683,11);
      WHEN "0011101100" =>
            manhi <= conv_std_logic_vector(7346860,24);
            manlo <= conv_std_logic_vector(2864438,28);
            exponent <= conv_std_logic_vector(682,11);
      WHEN "0011101101" =>
            manhi <= conv_std_logic_vector(972287,24);
            manlo <= conv_std_logic_vector(54536955,28);
            exponent <= conv_std_logic_vector(681,11);
      WHEN "0011101110" =>
            manhi <= conv_std_logic_vector(9341493,24);
            manlo <= conv_std_logic_vector(74572905,28);
            exponent <= conv_std_logic_vector(679,11);
      WHEN "0011101111" =>
            manhi <= conv_std_logic_vector(2439856,24);
            manlo <= conv_std_logic_vector(93006730,28);
            exponent <= conv_std_logic_vector(678,11);
      WHEN "0011110000" =>
            manhi <= conv_std_logic_vector(11501047,24);
            manlo <= conv_std_logic_vector(92098230,28);
            exponent <= conv_std_logic_vector(676,11);
      WHEN "0011110001" =>
            manhi <= conv_std_logic_vector(4028767,24);
            manlo <= conv_std_logic_vector(115940390,28);
            exponent <= conv_std_logic_vector(675,11);
      WHEN "0011110010" =>
            manhi <= conv_std_logic_vector(13839158,24);
            manlo <= conv_std_logic_vector(62227559,28);
            exponent <= conv_std_logic_vector(673,11);
      WHEN "0011110011" =>
            manhi <= conv_std_logic_vector(5749053,24);
            manlo <= conv_std_logic_vector(76824142,28);
            exponent <= conv_std_logic_vector(672,11);
      WHEN "0011110100" =>
            manhi <= conv_std_logic_vector(16370589,24);
            manlo <= conv_std_logic_vector(114548734,28);
            exponent <= conv_std_logic_vector(670,11);
      WHEN "0011110101" =>
            manhi <= conv_std_logic_vector(7611576,24);
            manlo <= conv_std_logic_vector(73252889,28);
            exponent <= conv_std_logic_vector(669,11);
      WHEN "0011110110" =>
            manhi <= conv_std_logic_vector(1167054,24);
            manlo <= conv_std_logic_vector(146134399,28);
            exponent <= conv_std_logic_vector(668,11);
      WHEN "0011110111" =>
            manhi <= conv_std_logic_vector(9628096,24);
            manlo <= conv_std_logic_vector(236331104,28);
            exponent <= conv_std_logic_vector(666,11);
      WHEN "0011111000" =>
            manhi <= conv_std_logic_vector(2650727,24);
            manlo <= conv_std_logic_vector(132284651,28);
            exponent <= conv_std_logic_vector(665,11);
      WHEN "0011111001" =>
            manhi <= conv_std_logic_vector(11811347,24);
            manlo <= conv_std_logic_vector(263325685,28);
            exponent <= conv_std_logic_vector(663,11);
      WHEN "0011111010" =>
            manhi <= conv_std_logic_vector(4257073,24);
            manlo <= conv_std_logic_vector(236873507,28);
            exponent <= conv_std_logic_vector(662,11);
      WHEN "0011111011" =>
            manhi <= conv_std_logic_vector(14175115,24);
            manlo <= conv_std_logic_vector(61615323,28);
            exponent <= conv_std_logic_vector(660,11);
      WHEN "0011111100" =>
            manhi <= conv_std_logic_vector(5996236,24);
            manlo <= conv_std_logic_vector(169476567,28);
            exponent <= conv_std_logic_vector(659,11);
      WHEN "0011111101" =>
            manhi <= conv_std_logic_vector(16734324,24);
            manlo <= conv_std_logic_vector(29597837,28);
            exponent <= conv_std_logic_vector(657,11);
      WHEN "0011111110" =>
            manhi <= conv_std_logic_vector(7879197,24);
            manlo <= conv_std_logic_vector(79755942,28);
            exponent <= conv_std_logic_vector(656,11);
      WHEN "0011111111" =>
            manhi <= conv_std_logic_vector(1363959,24);
            manlo <= conv_std_logic_vector(24177677,28);
            exponent <= conv_std_logic_vector(655,11);
      WHEN "0100000000" =>
            manhi <= conv_std_logic_vector(9917845,24);
            manlo <= conv_std_logic_vector(112021148,28);
            exponent <= conv_std_logic_vector(653,11);
      WHEN "0100000001" =>
            manhi <= conv_std_logic_vector(2863912,24);
            manlo <= conv_std_logic_vector(148304045,28);
            exponent <= conv_std_logic_vector(652,11);
      WHEN "0100000010" =>
            manhi <= conv_std_logic_vector(12125053,24);
            manlo <= conv_std_logic_vector(156617262,28);
            exponent <= conv_std_logic_vector(650,11);
      WHEN "0100000011" =>
            manhi <= conv_std_logic_vector(4487885,24);
            manlo <= conv_std_logic_vector(151904422,28);
            exponent <= conv_std_logic_vector(649,11);
      WHEN "0100000100" =>
            manhi <= conv_std_logic_vector(14514758,24);
            manlo <= conv_std_logic_vector(193824214,28);
            exponent <= conv_std_logic_vector(647,11);
      WHEN "0100000101" =>
            manhi <= conv_std_logic_vector(6246132,24);
            manlo <= conv_std_logic_vector(93361418,28);
            exponent <= conv_std_logic_vector(646,11);
      WHEN "0100000110" =>
            manhi <= conv_std_logic_vector(162417,24);
            manlo <= conv_std_logic_vector(12929741,28);
            exponent <= conv_std_logic_vector(645,11);
      WHEN "0100000111" =>
            manhi <= conv_std_logic_vector(8149754,24);
            manlo <= conv_std_logic_vector(257063442,28);
            exponent <= conv_std_logic_vector(643,11);
      WHEN "0100001000" =>
            manhi <= conv_std_logic_vector(1563024,24);
            manlo <= conv_std_logic_vector(78378796,28);
            exponent <= conv_std_logic_vector(642,11);
      WHEN "0100001001" =>
            manhi <= conv_std_logic_vector(10210773,24);
            manlo <= conv_std_logic_vector(106907060,28);
            exponent <= conv_std_logic_vector(640,11);
      WHEN "0100001010" =>
            manhi <= conv_std_logic_vector(3079436,24);
            manlo <= conv_std_logic_vector(245979562,28);
            exponent <= conv_std_logic_vector(639,11);
      WHEN "0100001011" =>
            manhi <= conv_std_logic_vector(12442201,24);
            manlo <= conv_std_logic_vector(137868870,28);
            exponent <= conv_std_logic_vector(637,11);
      WHEN "0100001100" =>
            manhi <= conv_std_logic_vector(4721229,24);
            manlo <= conv_std_logic_vector(261058204,28);
            exponent <= conv_std_logic_vector(636,11);
      WHEN "0100001101" =>
            manhi <= conv_std_logic_vector(14858129,24);
            manlo <= conv_std_logic_vector(43405174,28);
            exponent <= conv_std_logic_vector(634,11);
      WHEN "0100001110" =>
            manhi <= conv_std_logic_vector(6498770,24);
            manlo <= conv_std_logic_vector(53338521,28);
            exponent <= conv_std_logic_vector(633,11);
      WHEN "0100001111" =>
            manhi <= conv_std_logic_vector(348297,24);
            manlo <= conv_std_logic_vector(158641329,28);
            exponent <= conv_std_logic_vector(632,11);
      WHEN "0100010000" =>
            manhi <= conv_std_logic_vector(8423281,24);
            manlo <= conv_std_logic_vector(128446906,28);
            exponent <= conv_std_logic_vector(630,11);
      WHEN "0100010001" =>
            manhi <= conv_std_logic_vector(1764273,24);
            manlo <= conv_std_logic_vector(230657816,28);
            exponent <= conv_std_logic_vector(629,11);
      WHEN "0100010010" =>
            manhi <= conv_std_logic_vector(10506915,24);
            manlo <= conv_std_logic_vector(191032874,28);
            exponent <= conv_std_logic_vector(627,11);
      WHEN "0100010011" =>
            manhi <= conv_std_logic_vector(3297326,24);
            manlo <= conv_std_logic_vector(68145509,28);
            exponent <= conv_std_logic_vector(626,11);
      WHEN "0100010100" =>
            manhi <= conv_std_logic_vector(12762829,24);
            manlo <= conv_std_logic_vector(146161159,28);
            exponent <= conv_std_logic_vector(624,11);
      WHEN "0100010101" =>
            manhi <= conv_std_logic_vector(4957134,24);
            manlo <= conv_std_logic_vector(240027976,28);
            exponent <= conv_std_logic_vector(623,11);
      WHEN "0100010110" =>
            manhi <= conv_std_logic_vector(15205267,24);
            manlo <= conv_std_logic_vector(119370809,28);
            exponent <= conv_std_logic_vector(621,11);
      WHEN "0100010111" =>
            manhi <= conv_std_logic_vector(6754180,24);
            manlo <= conv_std_logic_vector(73501816,28);
            exponent <= conv_std_logic_vector(620,11);
      WHEN "0100011000" =>
            manhi <= conv_std_logic_vector(536217,24);
            manlo <= conv_std_logic_vector(220758658,28);
            exponent <= conv_std_logic_vector(619,11);
      WHEN "0100011001" =>
            manhi <= conv_std_logic_vector(8699809,24);
            manlo <= conv_std_logic_vector(117402516,28);
            exponent <= conv_std_logic_vector(617,11);
      WHEN "0100011010" =>
            manhi <= conv_std_logic_vector(1967731,24);
            manlo <= conv_std_logic_vector(204336317,28);
            exponent <= conv_std_logic_vector(616,11);
      WHEN "0100011011" =>
            manhi <= conv_std_logic_vector(10806307,24);
            manlo <= conv_std_logic_vector(168773516,28);
            exponent <= conv_std_logic_vector(614,11);
      WHEN "0100011100" =>
            manhi <= conv_std_logic_vector(3517606,24);
            manlo <= conv_std_logic_vector(138553816,28);
            exponent <= conv_std_logic_vector(613,11);
      WHEN "0100011101" =>
            manhi <= conv_std_logic_vector(13086975,24);
            manlo <= conv_std_logic_vector(231838082,28);
            exponent <= conv_std_logic_vector(611,11);
      WHEN "0100011110" =>
            manhi <= conv_std_logic_vector(5195628,24);
            manlo <= conv_std_logic_vector(114805284,28);
            exponent <= conv_std_logic_vector(610,11);
      WHEN "0100011111" =>
            manhi <= conv_std_logic_vector(15556214,24);
            manlo <= conv_std_logic_vector(245890169,28);
            exponent <= conv_std_logic_vector(608,11);
      WHEN "0100100000" =>
            manhi <= conv_std_logic_vector(7012392,24);
            manlo <= conv_std_logic_vector(266576824,28);
            exponent <= conv_std_logic_vector(607,11);
      WHEN "0100100001" =>
            manhi <= conv_std_logic_vector(726200,24);
            manlo <= conv_std_logic_vector(33318175,28);
            exponent <= conv_std_logic_vector(606,11);
      WHEN "0100100010" =>
            manhi <= conv_std_logic_vector(8979371,24);
            manlo <= conv_std_logic_vector(206515377,28);
            exponent <= conv_std_logic_vector(604,11);
      WHEN "0100100011" =>
            manhi <= conv_std_logic_vector(2173422,24);
            manlo <= conv_std_logic_vector(61774637,28);
            exponent <= conv_std_logic_vector(603,11);
      WHEN "0100100100" =>
            manhi <= conv_std_logic_vector(11108984,24);
            manlo <= conv_std_logic_vector(216833386,28);
            exponent <= conv_std_logic_vector(601,11);
      WHEN "0100100101" =>
            manhi <= conv_std_logic_vector(3740303,24);
            manlo <= conv_std_logic_vector(252090990,28);
            exponent <= conv_std_logic_vector(600,11);
      WHEN "0100100110" =>
            manhi <= conv_std_logic_vector(13414679,24);
            manlo <= conv_std_logic_vector(20856890,28);
            exponent <= conv_std_logic_vector(598,11);
      WHEN "0100100111" =>
            manhi <= conv_std_logic_vector(5436738,24);
            manlo <= conv_std_logic_vector(262578382,28);
            exponent <= conv_std_logic_vector(597,11);
      WHEN "0100101000" =>
            manhi <= conv_std_logic_vector(15911013,24);
            manlo <= conv_std_logic_vector(100481506,28);
            exponent <= conv_std_logic_vector(595,11);
      WHEN "0100101001" =>
            manhi <= conv_std_logic_vector(7273439,24);
            manlo <= conv_std_logic_vector(29586843,28);
            exponent <= conv_std_logic_vector(594,11);
      WHEN "0100101010" =>
            manhi <= conv_std_logic_vector(918267,24);
            manlo <= conv_std_logic_vector(33154287,28);
            exponent <= conv_std_logic_vector(593,11);
      WHEN "0100101011" =>
            manhi <= conv_std_logic_vector(9262001,24);
            manlo <= conv_std_logic_vector(206947959,28);
            exponent <= conv_std_logic_vector(591,11);
      WHEN "0100101100" =>
            manhi <= conv_std_logic_vector(2381369,24);
            manlo <= conv_std_logic_vector(205146615,28);
            exponent <= conv_std_logic_vector(590,11);
      WHEN "0100101101" =>
            manhi <= conv_std_logic_vector(11414983,24);
            manlo <= conv_std_logic_vector(80080029,28);
            exponent <= conv_std_logic_vector(588,11);
      WHEN "0100101110" =>
            manhi <= conv_std_logic_vector(3965445,24);
            manlo <= conv_std_logic_vector(12487826,28);
            exponent <= conv_std_logic_vector(587,11);
      WHEN "0100101111" =>
            manhi <= conv_std_logic_vector(13745978,24);
            manlo <= conv_std_logic_vector(58199715,28);
            exponent <= conv_std_logic_vector(585,11);
      WHEN "0100110000" =>
            manhi <= conv_std_logic_vector(5680495,24);
            manlo <= conv_std_logic_vector(70463110,28);
            exponent <= conv_std_logic_vector(584,11);
      WHEN "0100110001" =>
            manhi <= conv_std_logic_vector(16269705,24);
            manlo <= conv_std_logic_vector(20654997,28);
            exponent <= conv_std_logic_vector(582,11);
      WHEN "0100110010" =>
            manhi <= conv_std_logic_vector(7537349,24);
            manlo <= conv_std_logic_vector(192319832,28);
            exponent <= conv_std_logic_vector(581,11);
      WHEN "0100110011" =>
            manhi <= conv_std_logic_vector(1112441,24);
            manlo <= conv_std_logic_vector(186880957,28);
            exponent <= conv_std_logic_vector(580,11);
      WHEN "0100110100" =>
            manhi <= conv_std_logic_vector(9547733,24);
            manlo <= conv_std_logic_vector(27940083,28);
            exponent <= conv_std_logic_vector(578,11);
      WHEN "0100110101" =>
            manhi <= conv_std_logic_vector(2591599,24);
            manlo <= conv_std_logic_vector(35045549,28);
            exponent <= conv_std_logic_vector(577,11);
      WHEN "0100110110" =>
            manhi <= conv_std_logic_vector(11724339,24);
            manlo <= conv_std_logic_vector(146438512,28);
            exponent <= conv_std_logic_vector(575,11);
      WHEN "0100110111" =>
            manhi <= conv_std_logic_vector(4193056,24);
            manlo <= conv_std_logic_vector(175344679,28);
            exponent <= conv_std_logic_vector(574,11);
      WHEN "0100111000" =>
            manhi <= conv_std_logic_vector(14080912,24);
            manlo <= conv_std_logic_vector(198508677,28);
            exponent <= conv_std_logic_vector(572,11);
      WHEN "0100111001" =>
            manhi <= conv_std_logic_vector(5926926,24);
            manlo <= conv_std_logic_vector(83904648,28);
            exponent <= conv_std_logic_vector(571,11);
      WHEN "0100111010" =>
            manhi <= conv_std_logic_vector(16632332,24);
            manlo <= conv_std_logic_vector(199957404,28);
            exponent <= conv_std_logic_vector(569,11);
      WHEN "0100111011" =>
            manhi <= conv_std_logic_vector(7804156,24);
            manlo <= conv_std_logic_vector(65532420,28);
            exponent <= conv_std_logic_vector(568,11);
      WHEN "0100111100" =>
            manhi <= conv_std_logic_vector(1308746,24);
            manlo <= conv_std_logic_vector(260058525,28);
            exponent <= conv_std_logic_vector(567,11);
      WHEN "0100111101" =>
            manhi <= conv_std_logic_vector(9836599,24);
            manlo <= conv_std_logic_vector(214756046,28);
            exponent <= conv_std_logic_vector(565,11);
      WHEN "0100111110" =>
            manhi <= conv_std_logic_vector(2804135,24);
            manlo <= conv_std_logic_vector(98759674,28);
            exponent <= conv_std_logic_vector(564,11);
      WHEN "0100111111" =>
            manhi <= conv_std_logic_vector(12037090,24);
            manlo <= conv_std_logic_vector(105879341,28);
            exponent <= conv_std_logic_vector(562,11);
      WHEN "0101000000" =>
            manhi <= conv_std_logic_vector(4423165,24);
            manlo <= conv_std_logic_vector(233069674,28);
            exponent <= conv_std_logic_vector(561,11);
      WHEN "0101000001" =>
            manhi <= conv_std_logic_vector(14419522,24);
            manlo <= conv_std_logic_vector(144218340,28);
            exponent <= conv_std_logic_vector(559,11);
      WHEN "0101000010" =>
            manhi <= conv_std_logic_vector(6176061,24);
            manlo <= conv_std_logic_vector(128557517,28);
            exponent <= conv_std_logic_vector(558,11);
      WHEN "0101000011" =>
            manhi <= conv_std_logic_vector(110861,24);
            manlo <= conv_std_logic_vector(210451229,28);
            exponent <= conv_std_logic_vector(557,11);
      WHEN "0101000100" =>
            manhi <= conv_std_logic_vector(8073890,24);
            manlo <= conv_std_logic_vector(126309403,28);
            exponent <= conv_std_logic_vector(555,11);
      WHEN "0101000101" =>
            manhi <= conv_std_logic_vector(1507206,24);
            manlo <= conv_std_logic_vector(86368556,28);
            exponent <= conv_std_logic_vector(554,11);
      WHEN "0101000110" =>
            manhi <= conv_std_logic_vector(10128636,24);
            manlo <= conv_std_logic_vector(70724454,28);
            exponent <= conv_std_logic_vector(552,11);
      WHEN "0101000111" =>
            manhi <= conv_std_logic_vector(3019003,24);
            manlo <= conv_std_logic_vector(212024500,28);
            exponent <= conv_std_logic_vector(551,11);
      WHEN "0101001000" =>
            manhi <= conv_std_logic_vector(12353273,24);
            manlo <= conv_std_logic_vector(25338267,28);
            exponent <= conv_std_logic_vector(549,11);
      WHEN "0101001001" =>
            manhi <= conv_std_logic_vector(4655800,24);
            manlo <= conv_std_logic_vector(26358145,28);
            exponent <= conv_std_logic_vector(548,11);
      WHEN "0101001010" =>
            manhi <= conv_std_logic_vector(14761847,24);
            manlo <= conv_std_logic_vector(252137457,28);
            exponent <= conv_std_logic_vector(546,11);
      WHEN "0101001011" =>
            manhi <= conv_std_logic_vector(6427930,24);
            manlo <= conv_std_logic_vector(116530320,28);
            exponent <= conv_std_logic_vector(545,11);
      WHEN "0101001100" =>
            manhi <= conv_std_logic_vector(296176,24);
            manlo <= conv_std_logic_vector(162393576,28);
            exponent <= conv_std_logic_vector(544,11);
      WHEN "0101001101" =>
            manhi <= conv_std_logic_vector(8346584,24);
            manlo <= conv_std_logic_vector(140031506,28);
            exponent <= conv_std_logic_vector(542,11);
      WHEN "0101001110" =>
            manhi <= conv_std_logic_vector(1707843,24);
            manlo <= conv_std_logic_vector(105232250,28);
            exponent <= conv_std_logic_vector(541,11);
      WHEN "0101001111" =>
            manhi <= conv_std_logic_vector(10423877,24);
            manlo <= conv_std_logic_vector(74257288,28);
            exponent <= conv_std_logic_vector(539,11);
      WHEN "0101010000" =>
            manhi <= conv_std_logic_vector(3236229,24);
            manlo <= conv_std_logic_vector(265138481,28);
            exponent <= conv_std_logic_vector(538,11);
      WHEN "0101010001" =>
            manhi <= conv_std_logic_vector(12672925,24);
            manlo <= conv_std_logic_vector(81471742,28);
            exponent <= conv_std_logic_vector(536,11);
      WHEN "0101010010" =>
            manhi <= conv_std_logic_vector(4890987,24);
            manlo <= conv_std_logic_vector(13504322,28);
            exponent <= conv_std_logic_vector(535,11);
      WHEN "0101010011" =>
            manhi <= conv_std_logic_vector(15107929,24);
            manlo <= conv_std_logic_vector(192561070,28);
            exponent <= conv_std_logic_vector(533,11);
      WHEN "0101010100" =>
            manhi <= conv_std_logic_vector(6682563,24);
            manlo <= conv_std_logic_vector(47334412,28);
            exponent <= conv_std_logic_vector(532,11);
      WHEN "0101010101" =>
            manhi <= conv_std_logic_vector(483524,24);
            manlo <= conv_std_logic_vector(243414774,28);
            exponent <= conv_std_logic_vector(531,11);
      WHEN "0101010110" =>
            manhi <= conv_std_logic_vector(8622270,24);
            manlo <= conv_std_logic_vector(235144322,28);
            exponent <= conv_std_logic_vector(529,11);
      WHEN "0101010111" =>
            manhi <= conv_std_logic_vector(1910682,24);
            manlo <= conv_std_logic_vector(20388866,28);
            exponent <= conv_std_logic_vector(528,11);
      WHEN "0101011000" =>
            manhi <= conv_std_logic_vector(10722358,24);
            manlo <= conv_std_logic_vector(913747,28);
            exponent <= conv_std_logic_vector(526,11);
      WHEN "0101011001" =>
            manhi <= conv_std_logic_vector(3455839,24);
            manlo <= conv_std_logic_vector(223781205,28);
            exponent <= conv_std_logic_vector(525,11);
      WHEN "0101011010" =>
            manhi <= conv_std_logic_vector(12996085,24);
            manlo <= conv_std_logic_vector(24989984,28);
            exponent <= conv_std_logic_vector(523,11);
      WHEN "0101011011" =>
            manhi <= conv_std_logic_vector(5128754,24);
            manlo <= conv_std_logic_vector(197545335,28);
            exponent <= conv_std_logic_vector(522,11);
      WHEN "0101011100" =>
            manhi <= conv_std_logic_vector(15457809,24);
            manlo <= conv_std_logic_vector(24315860,28);
            exponent <= conv_std_logic_vector(520,11);
      WHEN "0101011101" =>
            manhi <= conv_std_logic_vector(6939990,24);
            manlo <= conv_std_logic_vector(8842978,28);
            exponent <= conv_std_logic_vector(519,11);
      WHEN "0101011110" =>
            manhi <= conv_std_logic_vector(672929,24);
            manlo <= conv_std_logic_vector(830489,28);
            exponent <= conv_std_logic_vector(518,11);
      WHEN "0101011111" =>
            manhi <= conv_std_logic_vector(8900982,24);
            manlo <= conv_std_logic_vector(98890321,28);
            exponent <= conv_std_logic_vector(516,11);
      WHEN "0101100000" =>
            manhi <= conv_std_logic_vector(2115746,24);
            manlo <= conv_std_logic_vector(142837003,28);
            exponent <= conv_std_logic_vector(515,11);
      WHEN "0101100001" =>
            manhi <= conv_std_logic_vector(11024113,24);
            manlo <= conv_std_logic_vector(266701758,28);
            exponent <= conv_std_logic_vector(513,11);
      WHEN "0101100010" =>
            manhi <= conv_std_logic_vector(3677859,24);
            manlo <= conv_std_logic_vector(129840563,28);
            exponent <= conv_std_logic_vector(512,11);
      WHEN "0101100011" =>
            manhi <= conv_std_logic_vector(13322790,24);
            manlo <= conv_std_logic_vector(255615990,28);
            exponent <= conv_std_logic_vector(510,11);
      WHEN "0101100100" =>
            manhi <= conv_std_logic_vector(5369131,24);
            manlo <= conv_std_logic_vector(127156783,28);
            exponent <= conv_std_logic_vector(509,11);
      WHEN "0101100101" =>
            manhi <= conv_std_logic_vector(15811527,24);
            manlo <= conv_std_logic_vector(196077973,28);
            exponent <= conv_std_logic_vector(507,11);
      WHEN "0101100110" =>
            manhi <= conv_std_logic_vector(7200241,24);
            manlo <= conv_std_logic_vector(178260644,28);
            exponent <= conv_std_logic_vector(506,11);
      WHEN "0101100111" =>
            manhi <= conv_std_logic_vector(864411,24);
            manlo <= conv_std_logic_vector(121424610,28);
            exponent <= conv_std_logic_vector(505,11);
      WHEN "0101101000" =>
            manhi <= conv_std_logic_vector(9182752,24);
            manlo <= conv_std_logic_vector(52100447,28);
            exponent <= conv_std_logic_vector(503,11);
      WHEN "0101101001" =>
            manhi <= conv_std_logic_vector(2323061,24);
            manlo <= conv_std_logic_vector(49429697,28);
            exponent <= conv_std_logic_vector(502,11);
      WHEN "0101101010" =>
            manhi <= conv_std_logic_vector(11329181,24);
            manlo <= conv_std_logic_vector(50166358,28);
            exponent <= conv_std_logic_vector(500,11);
      WHEN "0101101011" =>
            manhi <= conv_std_logic_vector(3902315,24);
            manlo <= conv_std_logic_vector(102248985,28);
            exponent <= conv_std_logic_vector(499,11);
      WHEN "0101101100" =>
            manhi <= conv_std_logic_vector(13653081,24);
            manlo <= conv_std_logic_vector(212703346,28);
            exponent <= conv_std_logic_vector(497,11);
      WHEN "0101101101" =>
            manhi <= conv_std_logic_vector(5612145,24);
            manlo <= conv_std_logic_vector(239735388,28);
            exponent <= conv_std_logic_vector(496,11);
      WHEN "0101101110" =>
            manhi <= conv_std_logic_vector(16169127,24);
            manlo <= conv_std_logic_vector(205528034,28);
            exponent <= conv_std_logic_vector(494,11);
      WHEN "0101101111" =>
            manhi <= conv_std_logic_vector(7463349,24);
            manlo <= conv_std_logic_vector(17797346,28);
            exponent <= conv_std_logic_vector(493,11);
      WHEN "0101110000" =>
            manhi <= conv_std_logic_vector(1057995,24);
            manlo <= conv_std_logic_vector(16251369,28);
            exponent <= conv_std_logic_vector(492,11);
      WHEN "0101110001" =>
            manhi <= conv_std_logic_vector(9467613,24);
            manlo <= conv_std_logic_vector(244949044,28);
            exponent <= conv_std_logic_vector(490,11);
      WHEN "0101110010" =>
            manhi <= conv_std_logic_vector(2532650,24);
            manlo <= conv_std_logic_vector(194268012,28);
            exponent <= conv_std_logic_vector(489,11);
      WHEN "0101110011" =>
            manhi <= conv_std_logic_vector(11637595,24);
            manlo <= conv_std_logic_vector(246328755,28);
            exponent <= conv_std_logic_vector(487,11);
      WHEN "0101110100" =>
            manhi <= conv_std_logic_vector(4129234,24);
            manlo <= conv_std_logic_vector(69393408,28);
            exponent <= conv_std_logic_vector(486,11);
      WHEN "0101110101" =>
            manhi <= conv_std_logic_vector(13986996,24);
            manlo <= conv_std_logic_vector(255528468,28);
            exponent <= conv_std_logic_vector(484,11);
      WHEN "0101110110" =>
            manhi <= conv_std_logic_vector(5857826,24);
            manlo <= conv_std_logic_vector(251701587,28);
            exponent <= conv_std_logic_vector(483,11);
      WHEN "0101110111" =>
            manhi <= conv_std_logic_vector(16530651,24);
            manlo <= conv_std_logic_vector(211310789,28);
            exponent <= conv_std_logic_vector(481,11);
      WHEN "0101111000" =>
            manhi <= conv_std_logic_vector(7729343,24);
            manlo <= conv_std_logic_vector(154707528,28);
            exponent <= conv_std_logic_vector(480,11);
      WHEN "0101111001" =>
            manhi <= conv_std_logic_vector(1253702,24);
            manlo <= conv_std_logic_vector(237283577,28);
            exponent <= conv_std_logic_vector(479,11);
      WHEN "0101111010" =>
            manhi <= conv_std_logic_vector(9755601,24);
            manlo <= conv_std_logic_vector(121155884,28);
            exponent <= conv_std_logic_vector(477,11);
      WHEN "0101111011" =>
            manhi <= conv_std_logic_vector(2744540,24);
            manlo <= conv_std_logic_vector(30442277,28);
            exponent <= conv_std_logic_vector(476,11);
      WHEN "0101111100" =>
            manhi <= conv_std_logic_vector(11949394,24);
            manlo <= conv_std_logic_vector(246622503,28);
            exponent <= conv_std_logic_vector(474,11);
      WHEN "0101111101" =>
            manhi <= conv_std_logic_vector(4358643,24);
            manlo <= conv_std_logic_vector(38405425,28);
            exponent <= conv_std_logic_vector(473,11);
      WHEN "0101111110" =>
            manhi <= conv_std_logic_vector(14324576,24);
            manlo <= conv_std_logic_vector(53935566,28);
            exponent <= conv_std_logic_vector(471,11);
      WHEN "0101111111" =>
            manhi <= conv_std_logic_vector(6106203,24);
            manlo <= conv_std_logic_vector(233166714,28);
            exponent <= conv_std_logic_vector(470,11);
      WHEN "0110000000" =>
            manhi <= conv_std_logic_vector(59463,24);
            manlo <= conv_std_logic_vector(114545214,28);
            exponent <= conv_std_logic_vector(469,11);
      WHEN "0110000001" =>
            manhi <= conv_std_logic_vector(7998256,24);
            manlo <= conv_std_logic_vector(234808364,28);
            exponent <= conv_std_logic_vector(467,11);
      WHEN "0110000010" =>
            manhi <= conv_std_logic_vector(1451558,24);
            manlo <= conv_std_logic_vector(62230667,28);
            exponent <= conv_std_logic_vector(466,11);
      WHEN "0110000011" =>
            manhi <= conv_std_logic_vector(10046749,24);
            manlo <= conv_std_logic_vector(29683609,28);
            exponent <= conv_std_logic_vector(464,11);
      WHEN "0110000100" =>
            manhi <= conv_std_logic_vector(2958754,24);
            manlo <= conv_std_logic_vector(158313814,28);
            exponent <= conv_std_logic_vector(463,11);
      WHEN "0110000101" =>
            manhi <= conv_std_logic_vector(12264615,24);
            manlo <= conv_std_logic_vector(87551554,28);
            exponent <= conv_std_logic_vector(461,11);
      WHEN "0110000110" =>
            manhi <= conv_std_logic_vector(4590569,24);
            manlo <= conv_std_logic_vector(96025360,28);
            exponent <= conv_std_logic_vector(460,11);
      WHEN "0110000111" =>
            manhi <= conv_std_logic_vector(14665859,24);
            manlo <= conv_std_logic_vector(200220878,28);
            exponent <= conv_std_logic_vector(458,11);
      WHEN "0110001000" =>
            manhi <= conv_std_logic_vector(6357306,24);
            manlo <= conv_std_logic_vector(71997608,28);
            exponent <= conv_std_logic_vector(457,11);
      WHEN "0110001001" =>
            manhi <= conv_std_logic_vector(244214,24);
            manlo <= conv_std_logic_vector(66463607,28);
            exponent <= conv_std_logic_vector(456,11);
      WHEN "0110001010" =>
            manhi <= conv_std_logic_vector(8270120,24);
            manlo <= conv_std_logic_vector(265669912,28);
            exponent <= conv_std_logic_vector(454,11);
      WHEN "0110001011" =>
            manhi <= conv_std_logic_vector(1651584,24);
            manlo <= conv_std_logic_vector(179638473,28);
            exponent <= conv_std_logic_vector(453,11);
      WHEN "0110001100" =>
            manhi <= conv_std_logic_vector(10341091,24);
            manlo <= conv_std_logic_vector(152092530,28);
            exponent <= conv_std_logic_vector(451,11);
      WHEN "0110001101" =>
            manhi <= conv_std_logic_vector(3175319,24);
            manlo <= conv_std_logic_vector(178838140,28);
            exponent <= conv_std_logic_vector(450,11);
      WHEN "0110001110" =>
            manhi <= conv_std_logic_vector(12583294,24);
            manlo <= conv_std_logic_vector(183442082,28);
            exponent <= conv_std_logic_vector(448,11);
      WHEN "0110001111" =>
            manhi <= conv_std_logic_vector(4825040,24);
            manlo <= conv_std_logic_vector(141040370,28);
            exponent <= conv_std_logic_vector(447,11);
      WHEN "0110010000" =>
            manhi <= conv_std_logic_vector(15010888,24);
            manlo <= conv_std_logic_vector(62934477,28);
            exponent <= conv_std_logic_vector(445,11);
      WHEN "0110010001" =>
            manhi <= conv_std_logic_vector(6611164,24);
            manlo <= conv_std_logic_vector(11633311,28);
            exponent <= conv_std_logic_vector(444,11);
      WHEN "0110010010" =>
            manhi <= conv_std_logic_vector(430992,24);
            manlo <= conv_std_logic_vector(96770068,28);
            exponent <= conv_std_logic_vector(443,11);
      WHEN "0110010011" =>
            manhi <= conv_std_logic_vector(8544968,24);
            manlo <= conv_std_logic_vector(80768180,28);
            exponent <= conv_std_logic_vector(441,11);
      WHEN "0110010100" =>
            manhi <= conv_std_logic_vector(1853806,24);
            manlo <= conv_std_logic_vector(5288079,28);
            exponent <= conv_std_logic_vector(440,11);
      WHEN "0110010101" =>
            manhi <= conv_std_logic_vector(10638663,24);
            manlo <= conv_std_logic_vector(235213815,28);
            exponent <= conv_std_logic_vector(438,11);
      WHEN "0110010110" =>
            manhi <= conv_std_logic_vector(3394261,24);
            manlo <= conv_std_logic_vector(36557939,28);
            exponent <= conv_std_logic_vector(437,11);
      WHEN "0110010111" =>
            manhi <= conv_std_logic_vector(12905470,24);
            manlo <= conv_std_logic_vector(253900977,28);
            exponent <= conv_std_logic_vector(435,11);
      WHEN "0110011000" =>
            manhi <= conv_std_logic_vector(5062084,24);
            manlo <= conv_std_logic_vector(153603034,28);
            exponent <= conv_std_logic_vector(434,11);
      WHEN "0110011001" =>
            manhi <= conv_std_logic_vector(15359702,24);
            manlo <= conv_std_logic_vector(204098933,28);
            exponent <= conv_std_logic_vector(432,11);
      WHEN "0110011010" =>
            manhi <= conv_std_logic_vector(6867807,24);
            manlo <= conv_std_logic_vector(115170312,28);
            exponent <= conv_std_logic_vector(431,11);
      WHEN "0110011011" =>
            manhi <= conv_std_logic_vector(619820,24);
            manlo <= conv_std_logic_vector(2986045,28);
            exponent <= conv_std_logic_vector(430,11);
      WHEN "0110011100" =>
            manhi <= conv_std_logic_vector(8822831,24);
            manlo <= conv_std_logic_vector(145826716,28);
            exponent <= conv_std_logic_vector(428,11);
      WHEN "0110011101" =>
            manhi <= conv_std_logic_vector(2058246,24);
            manlo <= conv_std_logic_vector(98876593,28);
            exponent <= conv_std_logic_vector(427,11);
      WHEN "0110011110" =>
            manhi <= conv_std_logic_vector(10939501,24);
            manlo <= conv_std_logic_vector(129141213,28);
            exponent <= conv_std_logic_vector(425,11);
      WHEN "0110011111" =>
            manhi <= conv_std_logic_vector(3615605,24);
            manlo <= conv_std_logic_vector(20427716,28);
            exponent <= conv_std_logic_vector(424,11);
      WHEN "0110100000" =>
            manhi <= conv_std_logic_vector(13231182,24);
            manlo <= conv_std_logic_vector(130335695,28);
            exponent <= conv_std_logic_vector(422,11);
      WHEN "0110100001" =>
            manhi <= conv_std_logic_vector(5301729,24);
            manlo <= conv_std_logic_vector(196124198,28);
            exponent <= conv_std_logic_vector(421,11);
      WHEN "0110100010" =>
            manhi <= conv_std_logic_vector(15712344,24);
            manlo <= conv_std_logic_vector(233039482,28);
            exponent <= conv_std_logic_vector(419,11);
      WHEN "0110100011" =>
            manhi <= conv_std_logic_vector(7127266,24);
            manlo <= conv_std_logic_vector(266329205,28);
            exponent <= conv_std_logic_vector(418,11);
      WHEN "0110100100" =>
            manhi <= conv_std_logic_vector(810719,24);
            manlo <= conv_std_logic_vector(185030259,28);
            exponent <= conv_std_logic_vector(417,11);
      WHEN "0110100101" =>
            manhi <= conv_std_logic_vector(9103743,24);
            manlo <= conv_std_logic_vector(217685905,28);
            exponent <= conv_std_logic_vector(415,11);
      WHEN "0110100110" =>
            manhi <= conv_std_logic_vector(2264930,24);
            manlo <= conv_std_logic_vector(17303531,28);
            exponent <= conv_std_logic_vector(414,11);
      WHEN "0110100111" =>
            manhi <= conv_std_logic_vector(11243640,24);
            manlo <= conv_std_logic_vector(56799625,28);
            exponent <= conv_std_logic_vector(412,11);
      WHEN "0110101000" =>
            manhi <= conv_std_logic_vector(3839377,24);
            manlo <= conv_std_logic_vector(227776580,28);
            exponent <= conv_std_logic_vector(411,11);
      WHEN "0110101001" =>
            manhi <= conv_std_logic_vector(13560468,24);
            manlo <= conv_std_logic_vector(25616516,28);
            exponent <= conv_std_logic_vector(409,11);
      WHEN "0110101010" =>
            manhi <= conv_std_logic_vector(5544004,24);
            manlo <= conv_std_logic_vector(145740137,28);
            exponent <= conv_std_logic_vector(408,11);
      WHEN "0110101011" =>
            manhi <= conv_std_logic_vector(16068856,24);
            manlo <= conv_std_logic_vector(149889545,28);
            exponent <= conv_std_logic_vector(406,11);
      WHEN "0110101100" =>
            manhi <= conv_std_logic_vector(7389573,24);
            manlo <= conv_std_logic_vector(170431948,28);
            exponent <= conv_std_logic_vector(405,11);
      WHEN "0110101101" =>
            manhi <= conv_std_logic_vector(1003714,24);
            manlo <= conv_std_logic_vector(35324999,28);
            exponent <= conv_std_logic_vector(404,11);
      WHEN "0110101110" =>
            manhi <= conv_std_logic_vector(9387738,24);
            manlo <= conv_std_logic_vector(150667400,28);
            exponent <= conv_std_logic_vector(402,11);
      WHEN "0110101111" =>
            manhi <= conv_std_logic_vector(2473881,24);
            manlo <= conv_std_logic_vector(194497484,28);
            exponent <= conv_std_logic_vector(401,11);
      WHEN "0110110000" =>
            manhi <= conv_std_logic_vector(11551116,24);
            manlo <= conv_std_logic_vector(78219737,28);
            exponent <= conv_std_logic_vector(399,11);
      WHEN "0110110001" =>
            manhi <= conv_std_logic_vector(4065606,24);
            manlo <= conv_std_logic_vector(28280174,28);
            exponent <= conv_std_logic_vector(398,11);
      WHEN "0110110010" =>
            manhi <= conv_std_logic_vector(13893366,24);
            manlo <= conv_std_logic_vector(266881350,28);
            exponent <= conv_std_logic_vector(396,11);
      WHEN "0110110011" =>
            manhi <= conv_std_logic_vector(5788937,24);
            manlo <= conv_std_logic_vector(232096008,28);
            exponent <= conv_std_logic_vector(395,11);
      WHEN "0110110100" =>
            manhi <= conv_std_logic_vector(16429280,24);
            manlo <= conv_std_logic_vector(78498076,28);
            exponent <= conv_std_logic_vector(393,11);
      WHEN "0110110101" =>
            manhi <= conv_std_logic_vector(7654758,24);
            manlo <= conv_std_logic_vector(160696217,28);
            exponent <= conv_std_logic_vector(392,11);
      WHEN "0110110110" =>
            manhi <= conv_std_logic_vector(1198826,24);
            manlo <= conv_std_logic_vector(87006684,28);
            exponent <= conv_std_logic_vector(391,11);
      WHEN "0110110111" =>
            manhi <= conv_std_logic_vector(9674849,24);
            manlo <= conv_std_logic_vector(166079254,28);
            exponent <= conv_std_logic_vector(389,11);
      WHEN "0110111000" =>
            manhi <= conv_std_logic_vector(2685126,24);
            manlo <= conv_std_logic_vector(63154951,28);
            exponent <= conv_std_logic_vector(388,11);
      WHEN "0110111001" =>
            manhi <= conv_std_logic_vector(11861966,24);
            manlo <= conv_std_logic_vector(91696135,28);
            exponent <= conv_std_logic_vector(386,11);
      WHEN "0110111010" =>
            manhi <= conv_std_logic_vector(4294316,24);
            manlo <= conv_std_logic_vector(212296424,28);
            exponent <= conv_std_logic_vector(385,11);
      WHEN "0110111011" =>
            manhi <= conv_std_logic_vector(14229918,24);
            manlo <= conv_std_logic_vector(223047784,28);
            exponent <= conv_std_logic_vector(383,11);
      WHEN "0110111100" =>
            manhi <= conv_std_logic_vector(6036558,24);
            manlo <= conv_std_logic_vector(232962025,28);
            exponent <= conv_std_logic_vector(382,11);
      WHEN "0110111101" =>
            manhi <= conv_std_logic_vector(8221,24);
            manlo <= conv_std_logic_vector(133893557,28);
            exponent <= conv_std_logic_vector(381,11);
      WHEN "0110111110" =>
            manhi <= conv_std_logic_vector(7922853,24);
            manlo <= conv_std_logic_vector(125492404,28);
            exponent <= conv_std_logic_vector(379,11);
      WHEN "0110111111" =>
            manhi <= conv_std_logic_vector(1396079,24);
            manlo <= conv_std_logic_vector(135612572,28);
            exponent <= conv_std_logic_vector(378,11);
      WHEN "0111000000" =>
            manhi <= conv_std_logic_vector(9965111,24);
            manlo <= conv_std_logic_vector(47990958,28);
            exponent <= conv_std_logic_vector(376,11);
      WHEN "0111000001" =>
            manhi <= conv_std_logic_vector(2898688,24);
            manlo <= conv_std_logic_vector(203019642,28);
            exponent <= conv_std_logic_vector(375,11);
      WHEN "0111000010" =>
            manhi <= conv_std_logic_vector(12176227,24);
            manlo <= conv_std_logic_vector(103393586,28);
            exponent <= conv_std_logic_vector(373,11);
      WHEN "0111000011" =>
            manhi <= conv_std_logic_vector(4525537,24);
            manlo <= conv_std_logic_vector(38936964,28);
            exponent <= conv_std_logic_vector(372,11);
      WHEN "0111000100" =>
            manhi <= conv_std_logic_vector(14570163,24);
            manlo <= conv_std_logic_vector(185128905,28);
            exponent <= conv_std_logic_vector(370,11);
      WHEN "0111000101" =>
            manhi <= conv_std_logic_vector(6286897,24);
            manlo <= conv_std_logic_vector(12037044,28);
            exponent <= conv_std_logic_vector(369,11);
      WHEN "0111000110" =>
            manhi <= conv_std_logic_vector(192410,24);
            manlo <= conv_std_logic_vector(9691196,28);
            exponent <= conv_std_logic_vector(368,11);
      WHEN "0111000111" =>
            manhi <= conv_std_logic_vector(8193890,24);
            manlo <= conv_std_logic_vector(46224319,28);
            exponent <= conv_std_logic_vector(366,11);
      WHEN "0111001000" =>
            manhi <= conv_std_logic_vector(1595497,24);
            manlo <= conv_std_logic_vector(45130080,28);
            exponent <= conv_std_logic_vector(365,11);
      WHEN "0111001001" =>
            manhi <= conv_std_logic_vector(10258557,24);
            manlo <= conv_std_logic_vector(218068546,28);
            exponent <= conv_std_logic_vector(363,11);
      WHEN "0111001010" =>
            manhi <= conv_std_logic_vector(3114594,24);
            manlo <= conv_std_logic_vector(194203222,28);
            exponent <= conv_std_logic_vector(362,11);
      WHEN "0111001011" =>
            manhi <= conv_std_logic_vector(12493936,24);
            manlo <= conv_std_logic_vector(228530713,28);
            exponent <= conv_std_logic_vector(360,11);
      WHEN "0111001100" =>
            manhi <= conv_std_logic_vector(4759294,24);
            manlo <= conv_std_logic_vector(189728046,28);
            exponent <= conv_std_logic_vector(359,11);
      WHEN "0111001101" =>
            manhi <= conv_std_logic_vector(14914142,24);
            manlo <= conv_std_logic_vector(25337562,28);
            exponent <= conv_std_logic_vector(357,11);
      WHEN "0111001110" =>
            manhi <= conv_std_logic_vector(6539982,24);
            manlo <= conv_std_logic_vector(56762382,28);
            exponent <= conv_std_logic_vector(356,11);
      WHEN "0111001111" =>
            manhi <= conv_std_logic_vector(378619,24);
            manlo <= conv_std_logic_vector(186677702,28);
            exponent <= conv_std_logic_vector(355,11);
      WHEN "0111010000" =>
            manhi <= conv_std_logic_vector(8467900,24);
            manlo <= conv_std_logic_vector(266785510,28);
            exponent <= conv_std_logic_vector(353,11);
      WHEN "0111010001" =>
            manhi <= conv_std_logic_vector(1797103,24);
            manlo <= conv_std_logic_vector(17183357,28);
            exponent <= conv_std_logic_vector(352,11);
      WHEN "0111010010" =>
            manhi <= conv_std_logic_vector(10555224,24);
            manlo <= conv_std_logic_vector(126067134,28);
            exponent <= conv_std_logic_vector(350,11);
      WHEN "0111010011" =>
            manhi <= conv_std_logic_vector(3332869,24);
            manlo <= conv_std_logic_vector(228611260,28);
            exponent <= conv_std_logic_vector(349,11);
      WHEN "0111010100" =>
            manhi <= conv_std_logic_vector(12815132,24);
            manlo <= conv_std_logic_vector(155705738,28);
            exponent <= conv_std_logic_vector(347,11);
      WHEN "0111010101" =>
            manhi <= conv_std_logic_vector(4995617,24);
            manlo <= conv_std_logic_vector(85136440,28);
            exponent <= conv_std_logic_vector(346,11);
      WHEN "0111010110" =>
            manhi <= conv_std_logic_vector(15261895,24);
            manlo <= conv_std_logic_vector(3688335,28);
            exponent <= conv_std_logic_vector(344,11);
      WHEN "0111010111" =>
            manhi <= conv_std_logic_vector(6795844,24);
            manlo <= conv_std_logic_vector(137097782,28);
            exponent <= conv_std_logic_vector(343,11);
      WHEN "0111011000" =>
            manhi <= conv_std_logic_vector(566872,24);
            manlo <= conv_std_logic_vector(175764875,28);
            exponent <= conv_std_logic_vector(342,11);
      WHEN "0111011001" =>
            manhi <= conv_std_logic_vector(8744918,24);
            manlo <= conv_std_logic_vector(152414052,28);
            exponent <= conv_std_logic_vector(340,11);
      WHEN "0111011010" =>
            manhi <= conv_std_logic_vector(2000921,24);
            manlo <= conv_std_logic_vector(54921723,28);
            exponent <= conv_std_logic_vector(339,11);
      WHEN "0111011011" =>
            manhi <= conv_std_logic_vector(10855146,24);
            manlo <= conv_std_logic_vector(129996510,28);
            exponent <= conv_std_logic_vector(337,11);
      WHEN "0111011100" =>
            manhi <= conv_std_logic_vector(3553540,24);
            manlo <= conv_std_logic_vector(37023540,28);
            exponent <= conv_std_logic_vector(336,11);
      WHEN "0111011101" =>
            manhi <= conv_std_logic_vector(13139852,24);
            manlo <= conv_std_logic_vector(221848100,28);
            exponent <= conv_std_logic_vector(334,11);
      WHEN "0111011110" =>
            manhi <= conv_std_logic_vector(5234533,24);
            manlo <= conv_std_logic_vector(32943194,28);
            exponent <= conv_std_logic_vector(333,11);
      WHEN "0111011111" =>
            manhi <= conv_std_logic_vector(15613463,24);
            manlo <= conv_std_logic_vector(232436445,28);
            exponent <= conv_std_logic_vector(331,11);
      WHEN "0111100000" =>
            manhi <= conv_std_logic_vector(7054514,24);
            manlo <= conv_std_logic_vector(111791498,28);
            exponent <= conv_std_logic_vector(330,11);
      WHEN "0111100001" =>
            manhi <= conv_std_logic_vector(757191,24);
            manlo <= conv_std_logic_vector(90062360,28);
            exponent <= conv_std_logic_vector(329,11);
      WHEN "0111100010" =>
            manhi <= conv_std_logic_vector(9024975,24);
            manlo <= conv_std_logic_vector(238219590,28);
            exponent <= conv_std_logic_vector(327,11);
      WHEN "0111100011" =>
            manhi <= conv_std_logic_vector(2206975,24);
            manlo <= conv_std_logic_vector(232222812,28);
            exponent <= conv_std_logic_vector(326,11);
      WHEN "0111100100" =>
            manhi <= conv_std_logic_vector(11158359,24);
            manlo <= conv_std_logic_vector(155073518,28);
            exponent <= conv_std_logic_vector(324,11);
      WHEN "0111100101" =>
            manhi <= conv_std_logic_vector(3776631,24);
            manlo <= conv_std_logic_vector(232102510,28);
            exponent <= conv_std_logic_vector(323,11);
      WHEN "0111100110" =>
            manhi <= conv_std_logic_vector(13468136,24);
            manlo <= conv_std_logic_vector(71264246,28);
            exponent <= conv_std_logic_vector(321,11);
      WHEN "0111100111" =>
            manhi <= conv_std_logic_vector(5476070,24);
            manlo <= conv_std_logic_vector(155401688,28);
            exponent <= conv_std_logic_vector(320,11);
      WHEN "0111101000" =>
            manhi <= conv_std_logic_vector(15968890,24);
            manlo <= conv_std_logic_vector(140531032,28);
            exponent <= conv_std_logic_vector(318,11);
      WHEN "0111101001" =>
            manhi <= conv_std_logic_vector(7316022,24);
            manlo <= conv_std_logic_vector(197790036,28);
            exponent <= conv_std_logic_vector(317,11);
      WHEN "0111101010" =>
            manhi <= conv_std_logic_vector(949598,24);
            manlo <= conv_std_logic_vector(108723575,28);
            exponent <= conv_std_logic_vector(316,11);
      WHEN "0111101011" =>
            manhi <= conv_std_logic_vector(9308106,24);
            manlo <= conv_std_logic_vector(82754530,28);
            exponent <= conv_std_logic_vector(314,11);
      WHEN "0111101100" =>
            manhi <= conv_std_logic_vector(2415291,24);
            manlo <= conv_std_logic_vector(157597766,28);
            exponent <= conv_std_logic_vector(313,11);
      WHEN "0111101101" =>
            manhi <= conv_std_logic_vector(11464899,24);
            manlo <= conv_std_logic_vector(231735034,28);
            exponent <= conv_std_logic_vector(311,11);
      WHEN "0111101110" =>
            manhi <= conv_std_logic_vector(4002171,24);
            manlo <= conv_std_logic_vector(161749904,28);
            exponent <= conv_std_logic_vector(310,11);
      WHEN "0111101111" =>
            manhi <= conv_std_logic_vector(13800021,24);
            manlo <= conv_std_logic_vector(267486845,28);
            exponent <= conv_std_logic_vector(308,11);
      WHEN "0111110000" =>
            manhi <= conv_std_logic_vector(5720258,24);
            manlo <= conv_std_logic_vector(121711942,28);
            exponent <= conv_std_logic_vector(307,11);
      WHEN "0111110001" =>
            manhi <= conv_std_logic_vector(16328217,24);
            manlo <= conv_std_logic_vector(85566619,28);
            exponent <= conv_std_logic_vector(305,11);
      WHEN "0111110010" =>
            manhi <= conv_std_logic_vector(7580400,24);
            manlo <= conv_std_logic_vector(165916765,28);
            exponent <= conv_std_logic_vector(304,11);
      WHEN "0111110011" =>
            manhi <= conv_std_logic_vector(1144116,24);
            manlo <= conv_std_logic_vector(209234965,28);
            exponent <= conv_std_logic_vector(303,11);
      WHEN "0111110100" =>
            manhi <= conv_std_logic_vector(9594343,24);
            manlo <= conv_std_logic_vector(148128653,28);
            exponent <= conv_std_logic_vector(301,11);
      WHEN "0111110101" =>
            manhi <= conv_std_logic_vector(2625893,24);
            manlo <= conv_std_logic_vector(48717694,28);
            exponent <= conv_std_logic_vector(300,11);
      WHEN "0111110110" =>
            manhi <= conv_std_logic_vector(11774803,24);
            manlo <= conv_std_logic_vector(228357100,28);
            exponent <= conv_std_logic_vector(298,11);
      WHEN "0111110111" =>
            manhi <= conv_std_logic_vector(4230186,24);
            manlo <= conv_std_logic_vector(57439900,28);
            exponent <= conv_std_logic_vector(297,11);
      WHEN "0111111000" =>
            manhi <= conv_std_logic_vector(14135549,24);
            manlo <= conv_std_logic_vector(147041206,28);
            exponent <= conv_std_logic_vector(295,11);
      WHEN "0111111001" =>
            manhi <= conv_std_logic_vector(5967125,24);
            manlo <= conv_std_logic_vector(222682176,28);
            exponent <= conv_std_logic_vector(294,11);
      WHEN "0111111010" =>
            manhi <= conv_std_logic_vector(16691487,24);
            manlo <= conv_std_logic_vector(12959237,28);
            exponent <= conv_std_logic_vector(292,11);
      WHEN "0111111011" =>
            manhi <= conv_std_logic_vector(7847679,24);
            manlo <= conv_std_logic_vector(147174066,28);
            exponent <= conv_std_logic_vector(291,11);
      WHEN "0111111100" =>
            manhi <= conv_std_logic_vector(1340769,24);
            manlo <= conv_std_logic_vector(168148656,28);
            exponent <= conv_std_logic_vector(290,11);
      WHEN "0111111101" =>
            manhi <= conv_std_logic_vector(9883721,24);
            manlo <= conv_std_logic_vector(190474495,28);
            exponent <= conv_std_logic_vector(288,11);
      WHEN "0111111110" =>
            manhi <= conv_std_logic_vector(2838805,24);
            manlo <= conv_std_logic_vector(196335986,28);
            exponent <= conv_std_logic_vector(287,11);
      WHEN "0111111111" =>
            manhi <= conv_std_logic_vector(12088108,24);
            manlo <= conv_std_logic_vector(120857634,28);
            exponent <= conv_std_logic_vector(285,11);
      WHEN "1000000000" =>
            manhi <= conv_std_logic_vector(4460702,24);
            manlo <= conv_std_logic_vector(229771569,28);
            exponent <= conv_std_logic_vector(284,11);
      WHEN "1000000001" =>
            manhi <= conv_std_logic_vector(14474758,24);
            manlo <= conv_std_logic_vector(236628147,28);
            exponent <= conv_std_logic_vector(282,11);
      WHEN "1000000010" =>
            manhi <= conv_std_logic_vector(6216702,24);
            manlo <= conv_std_logic_vector(29481361,28);
            exponent <= conv_std_logic_vector(281,11);
      WHEN "1000000011" =>
            manhi <= conv_std_logic_vector(140763,24);
            manlo <= conv_std_logic_vector(131310533,28);
            exponent <= conv_std_logic_vector(280,11);
      WHEN "1000000100" =>
            manhi <= conv_std_logic_vector(8117891,24);
            manlo <= conv_std_logic_vector(96879140,28);
            exponent <= conv_std_logic_vector(278,11);
      WHEN "1000000101" =>
            manhi <= conv_std_logic_vector(1539580,24);
            manlo <= conv_std_logic_vector(98694067,28);
            exponent <= conv_std_logic_vector(277,11);
      WHEN "1000000110" =>
            manhi <= conv_std_logic_vector(10176275,24);
            manlo <= conv_std_logic_vector(66343668,28);
            exponent <= conv_std_logic_vector(275,11);
      WHEN "1000000111" =>
            manhi <= conv_std_logic_vector(3054054,24);
            manlo <= conv_std_logic_vector(159783892,28);
            exponent <= conv_std_logic_vector(274,11);
      WHEN "1000001000" =>
            manhi <= conv_std_logic_vector(12404850,24);
            manlo <= conv_std_logic_vector(262311967,28);
            exponent <= conv_std_logic_vector(272,11);
      WHEN "1000001001" =>
            manhi <= conv_std_logic_vector(4693748,24);
            manlo <= conv_std_logic_vector(264030756,28);
            exponent <= conv_std_logic_vector(271,11);
      WHEN "1000001010" =>
            manhi <= conv_std_logic_vector(14817690,24);
            manlo <= conv_std_logic_vector(106917994,28);
            exponent <= conv_std_logic_vector(269,11);
      WHEN "1000001011" =>
            manhi <= conv_std_logic_vector(6469017,24);
            manlo <= conv_std_logic_vector(5191992,28);
            exponent <= conv_std_logic_vector(268,11);
      WHEN "1000001100" =>
            manhi <= conv_std_logic_vector(326406,24);
            manlo <= conv_std_logic_vector(114083215,28);
            exponent <= conv_std_logic_vector(267,11);
      WHEN "1000001101" =>
            manhi <= conv_std_logic_vector(8391068,24);
            manlo <= conv_std_logic_vector(64117214,28);
            exponent <= conv_std_logic_vector(265,11);
      WHEN "1000001110" =>
            manhi <= conv_std_logic_vector(1740572,24);
            manlo <= conv_std_logic_vector(183091279,28);
            exponent <= conv_std_logic_vector(264,11);
      WHEN "1000001111" =>
            manhi <= conv_std_logic_vector(10472039,24);
            manlo <= conv_std_logic_vector(2244224,28);
            exponent <= conv_std_logic_vector(262,11);
      WHEN "1000010000" =>
            manhi <= conv_std_logic_vector(3271665,24);
            manlo <= conv_std_logic_vector(109958542,28);
            exponent <= conv_std_logic_vector(261,11);
      WHEN "1000010001" =>
            manhi <= conv_std_logic_vector(12725069,24);
            manlo <= conv_std_logic_vector(41968573,28);
            exponent <= conv_std_logic_vector(259,11);
      WHEN "1000010010" =>
            manhi <= conv_std_logic_vector(4929352,24);
            manlo <= conv_std_logic_vector(94809674,28);
            exponent <= conv_std_logic_vector(258,11);
      WHEN "1000010011" =>
            manhi <= conv_std_logic_vector(15164384,24);
            manlo <= conv_std_logic_vector(252890425,28);
            exponent <= conv_std_logic_vector(256,11);
      WHEN "1000010100" =>
            manhi <= conv_std_logic_vector(6724100,24);
            manlo <= conv_std_logic_vector(163583158,28);
            exponent <= conv_std_logic_vector(255,11);
      WHEN "1000010101" =>
            manhi <= conv_std_logic_vector(514086,24);
            manlo <= conv_std_logic_vector(118679222,28);
            exponent <= conv_std_logic_vector(254,11);
      WHEN "1000010110" =>
            manhi <= conv_std_logic_vector(8667242,24);
            manlo <= conv_std_logic_vector(192770478,28);
            exponent <= conv_std_logic_vector(252,11);
      WHEN "1000010111" =>
            manhi <= conv_std_logic_vector(1943770,24);
            manlo <= conv_std_logic_vector(136437165,28);
            exponent <= conv_std_logic_vector(251,11);
      WHEN "1000011000" =>
            manhi <= conv_std_logic_vector(10771048,24);
            manlo <= conv_std_logic_vector(58883744,28);
            exponent <= conv_std_logic_vector(249,11);
      WHEN "1000011001" =>
            manhi <= conv_std_logic_vector(3491664,24);
            manlo <= conv_std_logic_vector(24836209,28);
            exponent <= conv_std_logic_vector(248,11);
      WHEN "1000011010" =>
            manhi <= conv_std_logic_vector(13048801,24);
            manlo <= conv_std_logic_vector(33938829,28);
            exponent <= conv_std_logic_vector(246,11);
      WHEN "1000011011" =>
            manhi <= conv_std_logic_vector(5167541,24);
            manlo <= conv_std_logic_vector(6894318,28);
            exponent <= conv_std_logic_vector(245,11);
      WHEN "1000011100" =>
            manhi <= conv_std_logic_vector(15514883,24);
            manlo <= conv_std_logic_vector(216092120,28);
            exponent <= conv_std_logic_vector(243,11);
      WHEN "1000011101" =>
            manhi <= conv_std_logic_vector(6981983,24);
            manlo <= conv_std_logic_vector(70071320,28);
            exponent <= conv_std_logic_vector(242,11);
      WHEN "1000011110" =>
            manhi <= conv_std_logic_vector(703825,24);
            manlo <= conv_std_logic_vector(239890498,28);
            exponent <= conv_std_logic_vector(241,11);
      WHEN "1000011111" =>
            manhi <= conv_std_logic_vector(8946447,24);
            manlo <= conv_std_logic_vector(185687386,28);
            exponent <= conv_std_logic_vector(239,11);
      WHEN "1000100000" =>
            manhi <= conv_std_logic_vector(2149198,24);
            manlo <= conv_std_logic_vector(12777107,28);
            exponent <= conv_std_logic_vector(238,11);
      WHEN "1000100001" =>
            manhi <= conv_std_logic_vector(11073338,24);
            manlo <= conv_std_logic_vector(132295567,28);
            exponent <= conv_std_logic_vector(236,11);
      WHEN "1000100010" =>
            manhi <= conv_std_logic_vector(3714076,24);
            manlo <= conv_std_logic_vector(227171857,28);
            exponent <= conv_std_logic_vector(235,11);
      WHEN "1000100011" =>
            manhi <= conv_std_logic_vector(13376085,24);
            manlo <= conv_std_logic_vector(119368169,28);
            exponent <= conv_std_logic_vector(233,11);
      WHEN "1000100100" =>
            manhi <= conv_std_logic_vector(5408343,24);
            manlo <= conv_std_logic_vector(99290689,28);
            exponent <= conv_std_logic_vector(232,11);
      WHEN "1000100101" =>
            manhi <= conv_std_logic_vector(15869228,24);
            manlo <= conv_std_logic_vector(196569651,28);
            exponent <= conv_std_logic_vector(230,11);
      WHEN "1000100110" =>
            manhi <= conv_std_logic_vector(7242695,24);
            manlo <= conv_std_logic_vector(184868911,28);
            exponent <= conv_std_logic_vector(229,11);
      WHEN "1000100111" =>
            manhi <= conv_std_logic_vector(895647,24);
            manlo <= conv_std_logic_vector(101480846,28);
            exponent <= conv_std_logic_vector(228,11);
      WHEN "1000101000" =>
            manhi <= conv_std_logic_vector(9228716,24);
            manlo <= conv_std_logic_vector(111040654,28);
            exponent <= conv_std_logic_vector(226,11);
      WHEN "1000101001" =>
            manhi <= conv_std_logic_vector(2356879,24);
            manlo <= conv_std_logic_vector(205878747,28);
            exponent <= conv_std_logic_vector(225,11);
      WHEN "1000101010" =>
            manhi <= conv_std_logic_vector(11378945,24);
            manlo <= conv_std_logic_vector(223412824,28);
            exponent <= conv_std_logic_vector(223,11);
      WHEN "1000101011" =>
            manhi <= conv_std_logic_vector(3938930,24);
            manlo <= conv_std_logic_vector(43159582,28);
            exponent <= conv_std_logic_vector(222,11);
      WHEN "1000101100" =>
            manhi <= conv_std_logic_vector(13706961,24);
            manlo <= conv_std_logic_vector(24539717,28);
            exponent <= conv_std_logic_vector(220,11);
      WHEN "1000101101" =>
            manhi <= conv_std_logic_vector(5651788,24);
            manlo <= conv_std_logic_vector(17696328,28);
            exponent <= conv_std_logic_vector(219,11);
      WHEN "1000101110" =>
            manhi <= conv_std_logic_vector(16227461,24);
            manlo <= conv_std_logic_vector(248897772,28);
            exponent <= conv_std_logic_vector(217,11);
      WHEN "1000101111" =>
            manhi <= conv_std_logic_vector(7506268,24);
            manlo <= conv_std_logic_vector(253353585,28);
            exponent <= conv_std_logic_vector(216,11);
      WHEN "1000110000" =>
            manhi <= conv_std_logic_vector(1089573,24);
            manlo <= conv_std_logic_vector(199085712,28);
            exponent <= conv_std_logic_vector(215,11);
      WHEN "1000110001" =>
            manhi <= conv_std_logic_vector(9514082,24);
            manlo <= conv_std_logic_vector(134954983,28);
            exponent <= conv_std_logic_vector(213,11);
      WHEN "1000110010" =>
            manhi <= conv_std_logic_vector(2566840,24);
            manlo <= conv_std_logic_vector(107836942,28);
            exponent <= conv_std_logic_vector(212,11);
      WHEN "1000110011" =>
            manhi <= conv_std_logic_vector(11687906,24);
            manlo <= conv_std_logic_vector(170784064,28);
            exponent <= conv_std_logic_vector(210,11);
      WHEN "1000110100" =>
            manhi <= conv_std_logic_vector(4166250,24);
            manlo <= conv_std_logic_vector(219198631,28);
            exponent <= conv_std_logic_vector(209,11);
      WHEN "1000110101" =>
            manhi <= conv_std_logic_vector(14041467,24);
            manlo <= conv_std_logic_vector(127426909,28);
            exponent <= conv_std_logic_vector(207,11);
      WHEN "1000110110" =>
            manhi <= conv_std_logic_vector(5897904,24);
            manlo <= conv_std_logic_vector(29159081,28);
            exponent <= conv_std_logic_vector(206,11);
      WHEN "1000110111" =>
            manhi <= conv_std_logic_vector(16589626,24);
            manlo <= conv_std_logic_vector(15093248,28);
            exponent <= conv_std_logic_vector(204,11);
      WHEN "1000111000" =>
            manhi <= conv_std_logic_vector(7772734,24);
            manlo <= conv_std_logic_vector(112367334,28);
            exponent <= conv_std_logic_vector(203,11);
      WHEN "1000111001" =>
            manhi <= conv_std_logic_vector(1285628,24);
            manlo <= conv_std_logic_vector(21894417,28);
            exponent <= conv_std_logic_vector(202,11);
      WHEN "1000111010" =>
            manhi <= conv_std_logic_vector(9802579,24);
            manlo <= conv_std_logic_vector(254146435,28);
            exponent <= conv_std_logic_vector(200,11);
      WHEN "1000111011" =>
            manhi <= conv_std_logic_vector(2779104,24);
            manlo <= conv_std_logic_vector(257348234,28);
            exponent <= conv_std_logic_vector(199,11);
      WHEN "1000111100" =>
            manhi <= conv_std_logic_vector(12000257,24);
            manlo <= conv_std_logic_vector(188607876,28);
            exponent <= conv_std_logic_vector(197,11);
      WHEN "1000111101" =>
            manhi <= conv_std_logic_vector(4396065,24);
            manlo <= conv_std_logic_vector(238395052,28);
            exponent <= conv_std_logic_vector(196,11);
      WHEN "1000111110" =>
            manhi <= conv_std_logic_vector(14379644,24);
            manlo <= conv_std_logic_vector(116776141,28);
            exponent <= conv_std_logic_vector(194,11);
      WHEN "1000111111" =>
            manhi <= conv_std_logic_vector(6146720,24);
            manlo <= conv_std_logic_vector(217697734,28);
            exponent <= conv_std_logic_vector(193,11);
      WHEN "1001000000" =>
            manhi <= conv_std_logic_vector(89274,24);
            manlo <= conv_std_logic_vector(34078121,28);
            exponent <= conv_std_logic_vector(192,11);
      WHEN "1001000001" =>
            manhi <= conv_std_logic_vector(8042123,24);
            manlo <= conv_std_logic_vector(228091050,28);
            exponent <= conv_std_logic_vector(190,11);
      WHEN "1001000010" =>
            manhi <= conv_std_logic_vector(1483833,24);
            manlo <= conv_std_logic_vector(200872250,28);
            exponent <= conv_std_logic_vector(189,11);
      WHEN "1001000011" =>
            manhi <= conv_std_logic_vector(10094243,24);
            manlo <= conv_std_logic_vector(28573613,28);
            exponent <= conv_std_logic_vector(187,11);
      WHEN "1001000100" =>
            manhi <= conv_std_logic_vector(2993698,24);
            manlo <= conv_std_logic_vector(193026703,28);
            exponent <= conv_std_logic_vector(186,11);
      WHEN "1001000101" =>
            manhi <= conv_std_logic_vector(12316036,24);
            manlo <= conv_std_logic_vector(62602992,28);
            exponent <= conv_std_logic_vector(184,11);
      WHEN "1001000110" =>
            manhi <= conv_std_logic_vector(4628402,24);
            manlo <= conv_std_logic_vector(200475490,28);
            exponent <= conv_std_logic_vector(183,11);
      WHEN "1001000111" =>
            manhi <= conv_std_logic_vector(14721532,24);
            manlo <= conv_std_logic_vector(67122338,28);
            exponent <= conv_std_logic_vector(181,11);
      WHEN "1001001000" =>
            manhi <= conv_std_logic_vector(6398267,24);
            manlo <= conv_std_logic_vector(216803728,28);
            exponent <= conv_std_logic_vector(180,11);
      WHEN "1001001001" =>
            manhi <= conv_std_logic_vector(274352,24);
            manlo <= conv_std_logic_vector(17200594,28);
            exponent <= conv_std_logic_vector(179,11);
      WHEN "1001001010" =>
            manhi <= conv_std_logic_vector(8314469,24);
            manlo <= conv_std_logic_vector(86446456,28);
            exponent <= conv_std_logic_vector(177,11);
      WHEN "1001001011" =>
            manhi <= conv_std_logic_vector(1684214,24);
            manlo <= conv_std_logic_vector(93587914,28);
            exponent <= conv_std_logic_vector(176,11);
      WHEN "1001001100" =>
            manhi <= conv_std_logic_vector(10389106,24);
            manlo <= conv_std_logic_vector(193148951,28);
            exponent <= conv_std_logic_vector(174,11);
      WHEN "1001001101" =>
            manhi <= conv_std_logic_vector(3210647,24);
            manlo <= conv_std_logic_vector(64824977,28);
            exponent <= conv_std_logic_vector(173,11);
      WHEN "1001001110" =>
            manhi <= conv_std_logic_vector(12635279,24);
            manlo <= conv_std_logic_vector(224939505,28);
            exponent <= conv_std_logic_vector(171,11);
      WHEN "1001001111" =>
            manhi <= conv_std_logic_vector(4863289,24);
            manlo <= conv_std_logic_vector(17355920,28);
            exponent <= conv_std_logic_vector(170,11);
      WHEN "1001010000" =>
            manhi <= conv_std_logic_vector(15067171,24);
            manlo <= conv_std_logic_vector(171641236,28);
            exponent <= conv_std_logic_vector(168,11);
      WHEN "1001010001" =>
            manhi <= conv_std_logic_vector(6652575,24);
            manlo <= conv_std_logic_vector(15694991,28);
            exponent <= conv_std_logic_vector(167,11);
      WHEN "1001010010" =>
            manhi <= conv_std_logic_vector(461460,24);
            manlo <= conv_std_logic_vector(236949593,28);
            exponent <= conv_std_logic_vector(166,11);
      WHEN "1001010011" =>
            manhi <= conv_std_logic_vector(8589803,24);
            manlo <= conv_std_logic_vector(73170085,28);
            exponent <= conv_std_logic_vector(164,11);
      WHEN "1001010100" =>
            manhi <= conv_std_logic_vector(1886793,24);
            manlo <= conv_std_logic_vector(200887360,28);
            exponent <= conv_std_logic_vector(163,11);
      WHEN "1001010101" =>
            manhi <= conv_std_logic_vector(10687205,24);
            manlo <= conv_std_logic_vector(242930225,28);
            exponent <= conv_std_logic_vector(161,11);
      WHEN "1001010110" =>
            manhi <= conv_std_logic_vector(3429976,24);
            manlo <= conv_std_logic_vector(97980458,28);
            exponent <= conv_std_logic_vector(160,11);
      WHEN "1001010111" =>
            manhi <= conv_std_logic_vector(12958026,24);
            manlo <= conv_std_logic_vector(144828568,28);
            exponent <= conv_std_logic_vector(158,11);
      WHEN "1001011000" =>
            manhi <= conv_std_logic_vector(5100752,24);
            manlo <= conv_std_logic_vector(219332721,28);
            exponent <= conv_std_logic_vector(157,11);
      WHEN "1001011001" =>
            manhi <= conv_std_logic_vector(15416603,24);
            manlo <= conv_std_logic_vector(206580322,28);
            exponent <= conv_std_logic_vector(155,11);
      WHEN "1001011010" =>
            manhi <= conv_std_logic_vector(6909672,24);
            manlo <= conv_std_logic_vector(228709240,28);
            exponent <= conv_std_logic_vector(154,11);
      WHEN "1001011011" =>
            manhi <= conv_std_logic_vector(650622,24);
            manlo <= conv_std_logic_vector(232984198,28);
            exponent <= conv_std_logic_vector(153,11);
      WHEN "1001011100" =>
            manhi <= conv_std_logic_vector(8868158,24);
            manlo <= conv_std_logic_vector(132673062,28);
            exponent <= conv_std_logic_vector(151,11);
      WHEN "1001011101" =>
            manhi <= conv_std_logic_vector(2091596,24);
            manlo <= conv_std_logic_vector(20173170,28);
            exponent <= conv_std_logic_vector(150,11);
      WHEN "1001011110" =>
            manhi <= conv_std_logic_vector(10988576,24);
            manlo <= conv_std_logic_vector(44856082,28);
            exponent <= conv_std_logic_vector(148,11);
      WHEN "1001011111" =>
            manhi <= conv_std_logic_vector(3651712,24);
            manlo <= conv_std_logic_vector(56970522,28);
            exponent <= conv_std_logic_vector(147,11);
      WHEN "1001100000" =>
            manhi <= conv_std_logic_vector(13284314,24);
            manlo <= conv_std_logic_vector(208786223,28);
            exponent <= conv_std_logic_vector(145,11);
      WHEN "1001100001" =>
            manhi <= conv_std_logic_vector(5340822,24);
            manlo <= conv_std_logic_vector(76928898,28);
            exponent <= conv_std_logic_vector(144,11);
      WHEN "1001100010" =>
            manhi <= conv_std_logic_vector(15769870,24);
            manlo <= conv_std_logic_vector(69445892,28);
            exponent <= conv_std_logic_vector(142,11);
      WHEN "1001100011" =>
            manhi <= conv_std_logic_vector(7169591,24);
            manlo <= conv_std_logic_vector(217224162,28);
            exponent <= conv_std_logic_vector(141,11);
      WHEN "1001100100" =>
            manhi <= conv_std_logic_vector(841860,24);
            manlo <= conv_std_logic_vector(147476782,28);
            exponent <= conv_std_logic_vector(140,11);
      WHEN "1001100101" =>
            manhi <= conv_std_logic_vector(9149568,24);
            manlo <= conv_std_logic_vector(37524984,28);
            exponent <= conv_std_logic_vector(138,11);
      WHEN "1001100110" =>
            manhi <= conv_std_logic_vector(2298645,24);
            manlo <= conv_std_logic_vector(193659590,28);
            exponent <= conv_std_logic_vector(137,11);
      WHEN "1001100111" =>
            manhi <= conv_std_logic_vector(11293253,24);
            manlo <= conv_std_logic_vector(107316618,28);
            exponent <= conv_std_logic_vector(135,11);
      WHEN "1001101000" =>
            manhi <= conv_std_logic_vector(3875881,24);
            manlo <= conv_std_logic_vector(51654059,28);
            exponent <= conv_std_logic_vector(134,11);
      WHEN "1001101001" =>
            manhi <= conv_std_logic_vector(13614183,24);
            manlo <= conv_std_logic_vector(111249634,28);
            exponent <= conv_std_logic_vector(132,11);
      WHEN "1001101010" =>
            manhi <= conv_std_logic_vector(5583526,24);
            manlo <= conv_std_logic_vector(17717412,28);
            exponent <= conv_std_logic_vector(131,11);
      WHEN "1001101011" =>
            manhi <= conv_std_logic_vector(16127013,24);
            manlo <= conv_std_logic_vector(48769099,28);
            exponent <= conv_std_logic_vector(129,11);
      WHEN "1001101100" =>
            manhi <= conv_std_logic_vector(7432362,24);
            manlo <= conv_std_logic_vector(238120049,28);
            exponent <= conv_std_logic_vector(128,11);
      WHEN "1001101101" =>
            manhi <= conv_std_logic_vector(1035196,24);
            manlo <= conv_std_logic_vector(188962402,28);
            exponent <= conv_std_logic_vector(127,11);
      WHEN "1001101110" =>
            manhi <= conv_std_logic_vector(9434065,24);
            manlo <= conv_std_logic_vector(194820226,28);
            exponent <= conv_std_logic_vector(125,11);
      WHEN "1001101111" =>
            manhi <= conv_std_logic_vector(2507967,24);
            manlo <= conv_std_logic_vector(93233285,28);
            exponent <= conv_std_logic_vector(124,11);
      WHEN "1001110000" =>
            manhi <= conv_std_logic_vector(11601273,24);
            manlo <= conv_std_logic_vector(239123672,28);
            exponent <= conv_std_logic_vector(122,11);
      WHEN "1001110001" =>
            manhi <= conv_std_logic_vector(4102510,24);
            manlo <= conv_std_logic_vector(1244898,28);
            exponent <= conv_std_logic_vector(121,11);
      WHEN "1001110010" =>
            manhi <= conv_std_logic_vector(13947671,24);
            manlo <= conv_std_logic_vector(197996828,28);
            exponent <= conv_std_logic_vector(119,11);
      WHEN "1001110011" =>
            manhi <= conv_std_logic_vector(5828893,24);
            manlo <= conv_std_logic_vector(16622593,28);
            exponent <= conv_std_logic_vector(118,11);
      WHEN "1001110100" =>
            manhi <= conv_std_logic_vector(16488075,24);
            manlo <= conv_std_logic_vector(20144764,28);
            exponent <= conv_std_logic_vector(116,11);
      WHEN "1001110101" =>
            manhi <= conv_std_logic_vector(7698017,24);
            manlo <= conv_std_logic_vector(102592250,28);
            exponent <= conv_std_logic_vector(115,11);
      WHEN "1001110110" =>
            manhi <= conv_std_logic_vector(1230654,24);
            manlo <= conv_std_logic_vector(96196092,28);
            exponent <= conv_std_logic_vector(114,11);
      WHEN "1001110111" =>
            manhi <= conv_std_logic_vector(9721685,24);
            manlo <= conv_std_logic_vector(36636777,28);
            exponent <= conv_std_logic_vector(112,11);
      WHEN "1001111000" =>
            manhi <= conv_std_logic_vector(2719585,24);
            manlo <= conv_std_logic_vector(237160861,28);
            exponent <= conv_std_logic_vector(111,11);
      WHEN "1001111001" =>
            manhi <= conv_std_logic_vector(11912674,24);
            manlo <= conv_std_logic_vector(87541902,28);
            exponent <= conv_std_logic_vector(109,11);
      WHEN "1001111010" =>
            manhi <= conv_std_logic_vector(4331625,24);
            manlo <= conv_std_logic_vector(172036325,28);
            exponent <= conv_std_logic_vector(108,11);
      WHEN "1001111011" =>
            manhi <= conv_std_logic_vector(14284819,24);
            manlo <= conv_std_logic_vector(125225503,28);
            exponent <= conv_std_logic_vector(106,11);
      WHEN "1001111100" =>
            manhi <= conv_std_logic_vector(6076952,24);
            manlo <= conv_std_logic_vector(133715238,28);
            exponent <= conv_std_logic_vector(105,11);
      WHEN "1001111101" =>
            manhi <= conv_std_logic_vector(37941,24);
            manlo <= conv_std_logic_vector(126448851,28);
            exponent <= conv_std_logic_vector(104,11);
      WHEN "1001111110" =>
            manhi <= conv_std_logic_vector(7966586,24);
            manlo <= conv_std_logic_vector(250893596,28);
            exponent <= conv_std_logic_vector(102,11);
      WHEN "1001111111" =>
            manhi <= conv_std_logic_vector(1428256,24);
            manlo <= conv_std_logic_vector(212630882,28);
            exponent <= conv_std_logic_vector(101,11);
      WHEN "1010000000" =>
            manhi <= conv_std_logic_vector(10012460,24);
            manlo <= conv_std_logic_vector(168603206,28);
            exponent <= conv_std_logic_vector(99,11);
      WHEN "1010000001" =>
            manhi <= conv_std_logic_vector(2933526,24);
            manlo <= conv_std_logic_vector(143402282,28);
            exponent <= conv_std_logic_vector(98,11);
      WHEN "1010000010" =>
            manhi <= conv_std_logic_vector(12227491,24);
            manlo <= conv_std_logic_vector(213203509,28);
            exponent <= conv_std_logic_vector(96,11);
      WHEN "1010000011" =>
            manhi <= conv_std_logic_vector(4563255,24);
            manlo <= conv_std_logic_vector(104522224,28);
            exponent <= conv_std_logic_vector(95,11);
      WHEN "1010000100" =>
            manhi <= conv_std_logic_vector(14625666,24);
            manlo <= conv_std_logic_vector(203000190,28);
            exponent <= conv_std_logic_vector(93,11);
      WHEN "1010000101" =>
            manhi <= conv_std_logic_vector(6327733,24);
            manlo <= conv_std_logic_vector(246711469,28);
            exponent <= conv_std_logic_vector(92,11);
      WHEN "1010000110" =>
            manhi <= conv_std_logic_vector(222456,24);
            manlo <= conv_std_logic_vector(34640152,28);
            exponent <= conv_std_logic_vector(91,11);
      WHEN "1010000111" =>
            manhi <= conv_std_logic_vector(8238103,24);
            manlo <= conv_std_logic_vector(142733230,28);
            exponent <= conv_std_logic_vector(89,11);
      WHEN "1010001000" =>
            manhi <= conv_std_logic_vector(1628027,24);
            manlo <= conv_std_logic_vector(144984792,28);
            exponent <= conv_std_logic_vector(88,11);
      WHEN "1010001001" =>
            manhi <= conv_std_logic_vector(10306426,24);
            manlo <= conv_std_logic_vector(223510234,28);
            exponent <= conv_std_logic_vector(86,11);
      WHEN "1010001010" =>
            manhi <= conv_std_logic_vector(3149814,24);
            manlo <= conv_std_logic_vector(209464872,28);
            exponent <= conv_std_logic_vector(85,11);
      WHEN "1010001011" =>
            manhi <= conv_std_logic_vector(12545763,24);
            manlo <= conv_std_logic_vector(212245812,28);
            exponent <= conv_std_logic_vector(83,11);
      WHEN "1010001100" =>
            manhi <= conv_std_logic_vector(4797426,24);
            manlo <= conv_std_logic_vector(224882259,28);
            exponent <= conv_std_logic_vector(82,11);
      WHEN "1010001101" =>
            manhi <= conv_std_logic_vector(14970254,24);
            manlo <= conv_std_logic_vector(54358776,28);
            exponent <= conv_std_logic_vector(80,11);
      WHEN "1010001110" =>
            manhi <= conv_std_logic_vector(6581267,24);
            manlo <= conv_std_logic_vector(51917314,28);
            exponent <= conv_std_logic_vector(79,11);
      WHEN "1010001111" =>
            manhi <= conv_std_logic_vector(408995,24);
            manlo <= conv_std_logic_vector(130890803,28);
            exponent <= conv_std_logic_vector(78,11);
      WHEN "1010010000" =>
            manhi <= conv_std_logic_vector(8512599,24);
            manlo <= conv_std_logic_vector(137347476,28);
            exponent <= conv_std_logic_vector(76,11);
      WHEN "1010010001" =>
            manhi <= conv_std_logic_vector(1829990,24);
            manlo <= conv_std_logic_vector(106170554,28);
            exponent <= conv_std_logic_vector(75,11);
      WHEN "1010010010" =>
            manhi <= conv_std_logic_vector(10603618,24);
            manlo <= conv_std_logic_vector(204595238,28);
            exponent <= conv_std_logic_vector(73,11);
      WHEN "1010010011" =>
            manhi <= conv_std_logic_vector(3368476,24);
            manlo <= conv_std_logic_vector(102605239,28);
            exponent <= conv_std_logic_vector(72,11);
      WHEN "1010010100" =>
            manhi <= conv_std_logic_vector(12867528,24);
            manlo <= conv_std_logic_vector(59687307,28);
            exponent <= conv_std_logic_vector(70,11);
      WHEN "1010010101" =>
            manhi <= conv_std_logic_vector(5034167,24);
            manlo <= conv_std_logic_vector(235251142,28);
            exponent <= conv_std_logic_vector(69,11);
      WHEN "1010010110" =>
            manhi <= conv_std_logic_vector(15318622,24);
            manlo <= conv_std_logic_vector(227223140,28);
            exponent <= conv_std_logic_vector(67,11);
      WHEN "1010010111" =>
            manhi <= conv_std_logic_vector(6837582,24);
            manlo <= conv_std_logic_vector(138925467,28);
            exponent <= conv_std_logic_vector(66,11);
      WHEN "1010011000" =>
            manhi <= conv_std_logic_vector(597581,24);
            manlo <= conv_std_logic_vector(205088968,28);
            exponent <= conv_std_logic_vector(65,11);
      WHEN "1010011001" =>
            manhi <= conv_std_logic_vector(8790107,24);
            manlo <= conv_std_logic_vector(152356460,28);
            exponent <= conv_std_logic_vector(63,11);
      WHEN "1010011010" =>
            manhi <= conv_std_logic_vector(2034169,24);
            manlo <= conv_std_logic_vector(110749946,28);
            exponent <= conv_std_logic_vector(62,11);
      WHEN "1010011011" =>
            manhi <= conv_std_logic_vector(10904071,24);
            manlo <= conv_std_logic_vector(218226183,28);
            exponent <= conv_std_logic_vector(60,11);
      WHEN "1010011100" =>
            manhi <= conv_std_logic_vector(3589537,24);
            manlo <= conv_std_logic_vector(102830143,28);
            exponent <= conv_std_logic_vector(59,11);
      WHEN "1010011101" =>
            manhi <= conv_std_logic_vector(13192823,24);
            manlo <= conv_std_logic_vector(110639602,28);
            exponent <= conv_std_logic_vector(57,11);
      WHEN "1010011110" =>
            manhi <= conv_std_logic_vector(5273506,24);
            manlo <= conv_std_logic_vector(188352155,28);
            exponent <= conv_std_logic_vector(56,11);
      WHEN "1010011111" =>
            manhi <= conv_std_logic_vector(15670814,24);
            manlo <= conv_std_logic_vector(48227643,28);
            exponent <= conv_std_logic_vector(54,11);
      WHEN "1010100000" =>
            manhi <= conv_std_logic_vector(7096710,24);
            manlo <= conv_std_logic_vector(112532514,28);
            exponent <= conv_std_logic_vector(53,11);
      WHEN "1010100001" =>
            manhi <= conv_std_logic_vector(788237,24);
            manlo <= conv_std_logic_vector(112565412,28);
            exponent <= conv_std_logic_vector(52,11);
      WHEN "1010100010" =>
            manhi <= conv_std_logic_vector(9070660,24);
            manlo <= conv_std_logic_vector(201680253,28);
            exponent <= conv_std_logic_vector(50,11);
      WHEN "1010100011" =>
            manhi <= conv_std_logic_vector(2240588,24);
            manlo <= conv_std_logic_vector(244138286,28);
            exponent <= conv_std_logic_vector(49,11);
      WHEN "1010100100" =>
            manhi <= conv_std_logic_vector(11207821,24);
            manlo <= conv_std_logic_vector(206597824,28);
            exponent <= conv_std_logic_vector(47,11);
      WHEN "1010100101" =>
            manhi <= conv_std_logic_vector(3813024,24);
            manlo <= conv_std_logic_vector(29987310,28);
            exponent <= conv_std_logic_vector(46,11);
      WHEN "1010100110" =>
            manhi <= conv_std_logic_vector(13521688,24);
            manlo <= conv_std_logic_vector(27790821,28);
            exponent <= conv_std_logic_vector(44,11);
      WHEN "1010100111" =>
            manhi <= conv_std_logic_vector(5515471,24);
            manlo <= conv_std_logic_vector(219963166,28);
            exponent <= conv_std_logic_vector(43,11);
      WHEN "1010101000" =>
            manhi <= conv_std_logic_vector(16026870,24);
            manlo <= conv_std_logic_vector(39964772,28);
            exponent <= conv_std_logic_vector(41,11);
      WHEN "1010101001" =>
            manhi <= conv_std_logic_vector(7358681,24);
            manlo <= conv_std_logic_vector(204327682,28);
            exponent <= conv_std_logic_vector(40,11);
      WHEN "1010101010" =>
            manhi <= conv_std_logic_vector(980985,24);
            manlo <= conv_std_logic_vector(43247066,28);
            exponent <= conv_std_logic_vector(39,11);
      WHEN "1010101011" =>
            manhi <= conv_std_logic_vector(9354292,24);
            manlo <= conv_std_logic_vector(128160132,28);
            exponent <= conv_std_logic_vector(37,11);
      WHEN "1010101100" =>
            manhi <= conv_std_logic_vector(2449273,24);
            manlo <= conv_std_logic_vector(126511008,28);
            exponent <= conv_std_logic_vector(36,11);
      WHEN "1010101101" =>
            manhi <= conv_std_logic_vector(11514904,24);
            manlo <= conv_std_logic_vector(217311246,28);
            exponent <= conv_std_logic_vector(34,11);
      WHEN "1010101110" =>
            manhi <= conv_std_logic_vector(4038963,24);
            manlo <= conv_std_logic_vector(49913566,28);
            exponent <= conv_std_logic_vector(33,11);
      WHEN "1010101111" =>
            manhi <= conv_std_logic_vector(13854161,24);
            manlo <= conv_std_logic_vector(124821568,28);
            exponent <= conv_std_logic_vector(31,11);
      WHEN "1010110000" =>
            manhi <= conv_std_logic_vector(5760092,24);
            manlo <= conv_std_logic_vector(12957085,28);
            exponent <= conv_std_logic_vector(30,11);
      WHEN "1010110001" =>
            manhi <= conv_std_logic_vector(16386833,24);
            manlo <= conv_std_logic_vector(43278038,28);
            exponent <= conv_std_logic_vector(28,11);
      WHEN "1010110010" =>
            manhi <= conv_std_logic_vector(7623527,24);
            manlo <= conv_std_logic_vector(199937734,28);
            exponent <= conv_std_logic_vector(27,11);
      WHEN "1010110011" =>
            manhi <= conv_std_logic_vector(1175847,24);
            manlo <= conv_std_logic_vector(253947561,28);
            exponent <= conv_std_logic_vector(26,11);
      WHEN "1010110100" =>
            manhi <= conv_std_logic_vector(9641036,24);
            manlo <= conv_std_logic_vector(141497796,28);
            exponent <= conv_std_logic_vector(24,11);
      WHEN "1010110101" =>
            manhi <= conv_std_logic_vector(2660247,24);
            manlo <= conv_std_logic_vector(255766959,28);
            exponent <= conv_std_logic_vector(23,11);
      WHEN "1010110110" =>
            manhi <= conv_std_logic_vector(11825357,24);
            manlo <= conv_std_logic_vector(136095046,28);
            exponent <= conv_std_logic_vector(21,11);
      WHEN "1010110111" =>
            manhi <= conv_std_logic_vector(4267381,24);
            manlo <= conv_std_logic_vector(138414926,28);
            exponent <= conv_std_logic_vector(20,11);
      WHEN "1010111000" =>
            manhi <= conv_std_logic_vector(14190283,24);
            manlo <= conv_std_logic_vector(25479908,28);
            exponent <= conv_std_logic_vector(18,11);
      WHEN "1010111001" =>
            manhi <= conv_std_logic_vector(6007396,24);
            manlo <= conv_std_logic_vector(140400514,28);
            exponent <= conv_std_logic_vector(17,11);
      WHEN "1010111010" =>
            manhi <= conv_std_logic_vector(16750746,24);
            manlo <= conv_std_logic_vector(23924155,28);
            exponent <= conv_std_logic_vector(15,11);
      WHEN "1010111011" =>
            manhi <= conv_std_logic_vector(7891279,24);
            manlo <= conv_std_logic_vector(245330892,28);
            exponent <= conv_std_logic_vector(14,11);
      WHEN "1010111100" =>
            manhi <= conv_std_logic_vector(1372848,24);
            manlo <= conv_std_logic_vector(263794815,28);
            exponent <= conv_std_logic_vector(13,11);
      WHEN "1010111101" =>
            manhi <= conv_std_logic_vector(9930927,24);
            manlo <= conv_std_logic_vector(14029030,28);
            exponent <= conv_std_logic_vector(11,11);
      WHEN "1010111110" =>
            manhi <= conv_std_logic_vector(2873537,24);
            manlo <= conv_std_logic_vector(129274844,28);
            exponent <= conv_std_logic_vector(10,11);
      WHEN "1010111111" =>
            manhi <= conv_std_logic_vector(12139216,24);
            manlo <= conv_std_logic_vector(224845565,28);
            exponent <= conv_std_logic_vector(8,11);
      WHEN "1011000000" =>
            manhi <= conv_std_logic_vector(4498306,24);
            manlo <= conv_std_logic_vector(82126943,28);
            exponent <= conv_std_logic_vector(7,11);
      WHEN "1011000001" =>
            manhi <= conv_std_logic_vector(14530093,24);
            manlo <= conv_std_logic_vector(7024665,28);
            exponent <= conv_std_logic_vector(5,11);
      WHEN "1011000010" =>
            manhi <= conv_std_logic_vector(6257414,24);
            manlo <= conv_std_logic_vector(187437029,28);
            exponent <= conv_std_logic_vector(4,11);
      WHEN "1011000011" =>
            manhi <= conv_std_logic_vector(170718,24);
            manlo <= conv_std_logic_vector(36971864,28);
            exponent <= conv_std_logic_vector(3,11);
      WHEN "1011000100" =>
            manhi <= conv_std_logic_vector(8161970,24);
            manlo <= conv_std_logic_vector(42518955,28);
            exponent <= conv_std_logic_vector(1,11);
      WHEN "1011000101" =>
            manhi <= conv_std_logic_vector(1572011,24);
            manlo <= conv_std_logic_vector(197150320,28);
            exponent <= conv_std_logic_vector(0,11);
      WHEN others =>
           manhi <= conv_std_logic_vector(0,24);
           manlo <= conv_std_logic_vector(0,28);
           exponent <= conv_std_logic_vector(0,11);
    END CASE;
  END PROCESS;

END rtl;
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_EXPLUTPOS.VHD                          ***
--***                                             ***
--***   Function: Look Up Table - EXP()           ***
--***                                             ***
--***   Generated by MATLAB Utility               ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_explutpos IS
PORT (
      add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
      manhi : OUT STD_LOGIC_VECTOR (24 DOWNTO 1);
      manlo : OUT STD_LOGIC_VECTOR (28 DOWNTO 1);
      exponent : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
     );
END dp_explutpos;

ARCHITECTURE rtl OF dp_explutpos IS

BEGIN

  pca: PROCESS (add)
  BEGIN
    CASE add IS
      WHEN "0000000000" =>
            manhi <= conv_std_logic_vector(0,24);
            manlo <= conv_std_logic_vector(0,28);
            exponent <= conv_std_logic_vector(1023,11);
      WHEN "0000000001" =>
            manhi <= conv_std_logic_vector(6025384,24);
            manlo <= conv_std_logic_vector(185882474,28);
            exponent <= conv_std_logic_vector(1024,11);
      WHEN "0000000010" =>
            manhi <= conv_std_logic_vector(14214731,24);
            manlo <= conv_std_logic_vector(148168110,28);
            exponent <= conv_std_logic_vector(1025,11);
      WHEN "0000000011" =>
            manhi <= conv_std_logic_vector(4283995,24);
            manlo <= conv_std_logic_vector(258978054,28);
            exponent <= conv_std_logic_vector(1027,11);
      WHEN "0000000100" =>
            manhi <= conv_std_logic_vector(11847938,24);
            manlo <= conv_std_logic_vector(237451864,28);
            exponent <= conv_std_logic_vector(1028,11);
      WHEN "0000000101" =>
            manhi <= conv_std_logic_vector(2675593,24);
            manlo <= conv_std_logic_vector(158348175,28);
            exponent <= conv_std_logic_vector(1030,11);
      WHEN "0000000110" =>
            manhi <= conv_std_logic_vector(9661893,24);
            manlo <= conv_std_logic_vector(110149775,28);
            exponent <= conv_std_logic_vector(1031,11);
      WHEN "0000000111" =>
            manhi <= conv_std_logic_vector(1190021,24);
            manlo <= conv_std_logic_vector(179232170,28);
            exponent <= conv_std_logic_vector(1033,11);
      WHEN "0000001000" =>
            manhi <= conv_std_logic_vector(7642791,24);
            manlo <= conv_std_logic_vector(222760046,28);
            exponent <= conv_std_logic_vector(1034,11);
      WHEN "0000001001" =>
            manhi <= conv_std_logic_vector(16413015,24);
            manlo <= conv_std_logic_vector(205983618,28);
            exponent <= conv_std_logic_vector(1035,11);
      WHEN "0000001010" =>
            manhi <= conv_std_logic_vector(5777884,24);
            manlo <= conv_std_logic_vector(261424480,28);
            exponent <= conv_std_logic_vector(1037,11);
      WHEN "0000001011" =>
            manhi <= conv_std_logic_vector(13878344,24);
            manlo <= conv_std_logic_vector(149835647,28);
            exponent <= conv_std_logic_vector(1038,11);
      WHEN "0000001100" =>
            manhi <= conv_std_logic_vector(4055397,24);
            manlo <= conv_std_logic_vector(80968858,28);
            exponent <= conv_std_logic_vector(1040,11);
      WHEN "0000001101" =>
            manhi <= conv_std_logic_vector(11537241,24);
            manlo <= conv_std_logic_vector(23775573,28);
            exponent <= conv_std_logic_vector(1041,11);
      WHEN "0000001110" =>
            manhi <= conv_std_logic_vector(2464452,24);
            manlo <= conv_std_logic_vector(146736599,28);
            exponent <= conv_std_logic_vector(1043,11);
      WHEN "0000001111" =>
            manhi <= conv_std_logic_vector(9374922,24);
            manlo <= conv_std_logic_vector(263006855,28);
            exponent <= conv_std_logic_vector(1044,11);
      WHEN "0000010000" =>
            manhi <= conv_std_logic_vector(995005,24);
            manlo <= conv_std_logic_vector(11010080,28);
            exponent <= conv_std_logic_vector(1046,11);
      WHEN "0000010001" =>
            manhi <= conv_std_logic_vector(7377736,24);
            manlo <= conv_std_logic_vector(202286329,28);
            exponent <= conv_std_logic_vector(1047,11);
      WHEN "0000010010" =>
            manhi <= conv_std_logic_vector(16052768,24);
            manlo <= conv_std_logic_vector(152649917,28);
            exponent <= conv_std_logic_vector(1048,11);
      WHEN "0000010011" =>
            manhi <= conv_std_logic_vector(5533071,24);
            manlo <= conv_std_logic_vector(166536930,28);
            exponent <= conv_std_logic_vector(1050,11);
      WHEN "0000010100" =>
            manhi <= conv_std_logic_vector(13545608,24);
            manlo <= conv_std_logic_vector(191424516,28);
            exponent <= conv_std_logic_vector(1051,11);
      WHEN "0000010101" =>
            manhi <= conv_std_logic_vector(3829279,24);
            manlo <= conv_std_logic_vector(228519165,28);
            exponent <= conv_std_logic_vector(1053,11);
      WHEN "0000010110" =>
            manhi <= conv_std_logic_vector(11229915,24);
            manlo <= conv_std_logic_vector(163853824,28);
            exponent <= conv_std_logic_vector(1054,11);
      WHEN "0000010111" =>
            manhi <= conv_std_logic_vector(2255603,24);
            manlo <= conv_std_logic_vector(61996481,28);
            exponent <= conv_std_logic_vector(1056,11);
      WHEN "0000011000" =>
            manhi <= conv_std_logic_vector(9091067,24);
            manlo <= conv_std_logic_vector(88563639,28);
            exponent <= conv_std_logic_vector(1057,11);
      WHEN "0000011001" =>
            manhi <= conv_std_logic_vector(802105,24);
            manlo <= conv_std_logic_vector(34169545,28);
            exponent <= conv_std_logic_vector(1059,11);
      WHEN "0000011010" =>
            manhi <= conv_std_logic_vector(7115558,24);
            manlo <= conv_std_logic_vector(157969244,28);
            exponent <= conv_std_logic_vector(1060,11);
      WHEN "0000011011" =>
            manhi <= conv_std_logic_vector(15696431,24);
            manlo <= conv_std_logic_vector(133591837,28);
            exponent <= conv_std_logic_vector(1061,11);
      WHEN "0000011100" =>
            manhi <= conv_std_logic_vector(5290915,24);
            manlo <= conv_std_logic_vector(127285146,28);
            exponent <= conv_std_logic_vector(1063,11);
      WHEN "0000011101" =>
            manhi <= conv_std_logic_vector(13216484,24);
            manlo <= conv_std_logic_vector(103923798,28);
            exponent <= conv_std_logic_vector(1064,11);
      WHEN "0000011110" =>
            manhi <= conv_std_logic_vector(3605616,24);
            manlo <= conv_std_logic_vector(183249133,28);
            exponent <= conv_std_logic_vector(1066,11);
      WHEN "0000011111" =>
            manhi <= conv_std_logic_vector(10925925,24);
            manlo <= conv_std_logic_vector(227336045,28);
            exponent <= conv_std_logic_vector(1067,11);
      WHEN "0000100000" =>
            manhi <= conv_std_logic_vector(2049020,24);
            manlo <= conv_std_logic_vector(206267948,28);
            exponent <= conv_std_logic_vector(1069,11);
      WHEN "0000100001" =>
            manhi <= conv_std_logic_vector(8810292,24);
            manlo <= conv_std_logic_vector(175265666,28);
            exponent <= conv_std_logic_vector(1070,11);
      WHEN "0000100010" =>
            manhi <= conv_std_logic_vector(611298,24);
            manlo <= conv_std_logic_vector(255467255,28);
            exponent <= conv_std_logic_vector(1072,11);
      WHEN "0000100011" =>
            manhi <= conv_std_logic_vector(6856226,24);
            manlo <= conv_std_logic_vector(29134171,28);
            exponent <= conv_std_logic_vector(1073,11);
      WHEN "0000100100" =>
            manhi <= conv_std_logic_vector(15343962,24);
            manlo <= conv_std_logic_vector(30543222,28);
            exponent <= conv_std_logic_vector(1074,11);
      WHEN "0000100101" =>
            manhi <= conv_std_logic_vector(5051387,24);
            manlo <= conv_std_logic_vector(186253338,28);
            exponent <= conv_std_logic_vector(1076,11);
      WHEN "0000100110" =>
            manhi <= conv_std_logic_vector(12890932,24);
            manlo <= conv_std_logic_vector(102222951,28);
            exponent <= conv_std_logic_vector(1077,11);
      WHEN "0000100111" =>
            manhi <= conv_std_logic_vector(3384381,24);
            manlo <= conv_std_logic_vector(42116377,28);
            exponent <= conv_std_logic_vector(1079,11);
      WHEN "0000101000" =>
            manhi <= conv_std_logic_vector(10625235,24);
            manlo <= conv_std_logic_vector(158954218,28);
            exponent <= conv_std_logic_vector(1080,11);
      WHEN "0000101001" =>
            manhi <= conv_std_logic_vector(1844680,24);
            manlo <= conv_std_logic_vector(148858978,28);
            exponent <= conv_std_logic_vector(1082,11);
      WHEN "0000101010" =>
            manhi <= conv_std_logic_vector(8532565,24);
            manlo <= conv_std_logic_vector(136319321,28);
            exponent <= conv_std_logic_vector(1083,11);
      WHEN "0000101011" =>
            manhi <= conv_std_logic_vector(422563,24);
            manlo <= conv_std_logic_vector(211728497,28);
            exponent <= conv_std_logic_vector(1085,11);
      WHEN "0000101100" =>
            manhi <= conv_std_logic_vector(6599708,24);
            manlo <= conv_std_logic_vector(114522162,28);
            exponent <= conv_std_logic_vector(1086,11);
      WHEN "0000101101" =>
            manhi <= conv_std_logic_vector(14995318,24);
            manlo <= conv_std_logic_vector(117328318,28);
            exponent <= conv_std_logic_vector(1087,11);
      WHEN "0000101110" =>
            manhi <= conv_std_logic_vector(4814459,24);
            manlo <= conv_std_logic_vector(201622499,28);
            exponent <= conv_std_logic_vector(1089,11);
      WHEN "0000101111" =>
            manhi <= conv_std_logic_vector(12568913,24);
            manlo <= conv_std_logic_vector(246987638,28);
            exponent <= conv_std_logic_vector(1090,11);
      WHEN "0000110000" =>
            manhi <= conv_std_logic_vector(3165546,24);
            manlo <= conv_std_logic_vector(248128843,28);
            exponent <= conv_std_logic_vector(1092,11);
      WHEN "0000110001" =>
            manhi <= conv_std_logic_vector(10327809,24);
            manlo <= conv_std_logic_vector(8929872,28);
            exponent <= conv_std_logic_vector(1093,11);
      WHEN "0000110010" =>
            manhi <= conv_std_logic_vector(1642558,24);
            manlo <= conv_std_logic_vector(67636037,28);
            exponent <= conv_std_logic_vector(1095,11);
      WHEN "0000110011" =>
            manhi <= conv_std_logic_vector(8257852,24);
            manlo <= conv_std_logic_vector(219235425,28);
            exponent <= conv_std_logic_vector(1096,11);
      WHEN "0000110100" =>
            manhi <= conv_std_logic_vector(235877,24);
            manlo <= conv_std_logic_vector(42862412,28);
            exponent <= conv_std_logic_vector(1098,11);
      WHEN "0000110101" =>
            manhi <= conv_std_logic_vector(6345974,24);
            manlo <= conv_std_logic_vector(265996080,28);
            exponent <= conv_std_logic_vector(1099,11);
      WHEN "0000110110" =>
            manhi <= conv_std_logic_vector(14650458,24);
            manlo <= conv_std_logic_vector(253213243,28);
            exponent <= conv_std_logic_vector(1100,11);
      WHEN "0000110111" =>
            manhi <= conv_std_logic_vector(4580103,24);
            manlo <= conv_std_logic_vector(114693785,28);
            exponent <= conv_std_logic_vector(1102,11);
      WHEN "0000111000" =>
            manhi <= conv_std_logic_vector(12250390,24);
            manlo <= conv_std_logic_vector(174984615,28);
            exponent <= conv_std_logic_vector(1103,11);
      WHEN "0000111001" =>
            manhi <= conv_std_logic_vector(2949087,24);
            manlo <= conv_std_logic_vector(247325089,28);
            exponent <= conv_std_logic_vector(1105,11);
      WHEN "0000111010" =>
            manhi <= conv_std_logic_vector(10033610,24);
            manlo <= conv_std_logic_vector(200264553,28);
            exponent <= conv_std_logic_vector(1106,11);
      WHEN "0000111011" =>
            manhi <= conv_std_logic_vector(1442629,24);
            manlo <= conv_std_logic_vector(211375075,28);
            exponent <= conv_std_logic_vector(1108,11);
      WHEN "0000111100" =>
            manhi <= conv_std_logic_vector(7986121,24);
            manlo <= conv_std_logic_vector(231029862,28);
            exponent <= conv_std_logic_vector(1109,11);
      WHEN "0000111101" =>
            manhi <= conv_std_logic_vector(51216,24);
            manlo <= conv_std_logic_vector(222707863,28);
            exponent <= conv_std_logic_vector(1111,11);
      WHEN "0000111110" =>
            manhi <= conv_std_logic_vector(6094995,24);
            manlo <= conv_std_logic_vector(155999272,28);
            exponent <= conv_std_logic_vector(1112,11);
      WHEN "0000111111" =>
            manhi <= conv_std_logic_vector(14309342,24);
            manlo <= conv_std_logic_vector(150013864,28);
            exponent <= conv_std_logic_vector(1113,11);
      WHEN "0001000000" =>
            manhi <= conv_std_logic_vector(4348290,24);
            manlo <= conv_std_logic_vector(217421773,28);
            exponent <= conv_std_logic_vector(1115,11);
      WHEN "0001000001" =>
            manhi <= conv_std_logic_vector(11935324,24);
            manlo <= conv_std_logic_vector(171597361,28);
            exponent <= conv_std_logic_vector(1116,11);
      WHEN "0001000010" =>
            manhi <= conv_std_logic_vector(2734978,24);
            manlo <= conv_std_logic_vector(98553735,28);
            exponent <= conv_std_logic_vector(1118,11);
      WHEN "0001000011" =>
            manhi <= conv_std_logic_vector(9742605,24);
            manlo <= conv_std_logic_vector(185429986,28);
            exponent <= conv_std_logic_vector(1119,11);
      WHEN "0001000100" =>
            manhi <= conv_std_logic_vector(1244871,24);
            manlo <= conv_std_logic_vector(93685501,28);
            exponent <= conv_std_logic_vector(1121,11);
      WHEN "0001000101" =>
            manhi <= conv_std_logic_vector(7717340,24);
            manlo <= conv_std_logic_vector(74048432,28);
            exponent <= conv_std_logic_vector(1122,11);
      WHEN "0001000110" =>
            manhi <= conv_std_logic_vector(16514337,24);
            manlo <= conv_std_logic_vector(163855108,28);
            exponent <= conv_std_logic_vector(1123,11);
      WHEN "0001000111" =>
            manhi <= conv_std_logic_vector(5846740,24);
            manlo <= conv_std_logic_vector(81895750,28);
            exponent <= conv_std_logic_vector(1125,11);
      WHEN "0001001000" =>
            manhi <= conv_std_logic_vector(13971928,24);
            manlo <= conv_std_logic_vector(176088988,28);
            exponent <= conv_std_logic_vector(1126,11);
      WHEN "0001001001" =>
            manhi <= conv_std_logic_vector(4118994,24);
            manlo <= conv_std_logic_vector(77780251,28);
            exponent <= conv_std_logic_vector(1128,11);
      WHEN "0001001010" =>
            manhi <= conv_std_logic_vector(11623678,24);
            manlo <= conv_std_logic_vector(95871356,28);
            exponent <= conv_std_logic_vector(1129,11);
      WHEN "0001001011" =>
            manhi <= conv_std_logic_vector(2523192,24);
            manlo <= conv_std_logic_vector(204213760,28);
            exponent <= conv_std_logic_vector(1131,11);
      WHEN "0001001100" =>
            manhi <= conv_std_logic_vector(9454759,24);
            manlo <= conv_std_logic_vector(55860552,28);
            exponent <= conv_std_logic_vector(1132,11);
      WHEN "0001001101" =>
            manhi <= conv_std_logic_vector(1049259,24);
            manlo <= conv_std_logic_vector(102861624,28);
            exponent <= conv_std_logic_vector(1134,11);
      WHEN "0001001110" =>
            manhi <= conv_std_logic_vector(7451476,24);
            manlo <= conv_std_logic_vector(13367584,28);
            exponent <= conv_std_logic_vector(1135,11);
      WHEN "0001001111" =>
            manhi <= conv_std_logic_vector(16152990,24);
            manlo <= conv_std_logic_vector(178012490,28);
            exponent <= conv_std_logic_vector(1136,11);
      WHEN "0001010000" =>
            manhi <= conv_std_logic_vector(5601179,24);
            manlo <= conv_std_logic_vector(159708139,28);
            exponent <= conv_std_logic_vector(1138,11);
      WHEN "0001010001" =>
            manhi <= conv_std_logic_vector(13638177,24);
            manlo <= conv_std_logic_vector(12864164,28);
            exponent <= conv_std_logic_vector(1139,11);
      WHEN "0001010010" =>
            manhi <= conv_std_logic_vector(3892186,24);
            manlo <= conv_std_logic_vector(149492240,28);
            exponent <= conv_std_logic_vector(1141,11);
      WHEN "0001010011" =>
            manhi <= conv_std_logic_vector(11315414,24);
            manlo <= conv_std_logic_vector(184620728,28);
            exponent <= conv_std_logic_vector(1142,11);
      WHEN "0001010100" =>
            manhi <= conv_std_logic_vector(2313705,24);
            manlo <= conv_std_logic_vector(235697385,28);
            exponent <= conv_std_logic_vector(1144,11);
      WHEN "0001010101" =>
            manhi <= conv_std_logic_vector(9170037,24);
            manlo <= conv_std_logic_vector(3974263,28);
            exponent <= conv_std_logic_vector(1145,11);
      WHEN "0001010110" =>
            manhi <= conv_std_logic_vector(855770,24);
            manlo <= conv_std_logic_vector(158952336,28);
            exponent <= conv_std_logic_vector(1147,11);
      WHEN "0001010111" =>
            manhi <= conv_std_logic_vector(7188497,24);
            manlo <= conv_std_logic_vector(138900038,28);
            exponent <= conv_std_logic_vector(1148,11);
      WHEN "0001011000" =>
            manhi <= conv_std_logic_vector(15795565,24);
            manlo <= conv_std_logic_vector(209449517,28);
            exponent <= conv_std_logic_vector(1149,11);
      WHEN "0001011001" =>
            manhi <= conv_std_logic_vector(5358284,24);
            manlo <= conv_std_logic_vector(54736896,28);
            exponent <= conv_std_logic_vector(1151,11);
      WHEN "0001011010" =>
            manhi <= conv_std_logic_vector(13308047,24);
            manlo <= conv_std_logic_vector(264159588,28);
            exponent <= conv_std_logic_vector(1152,11);
      WHEN "0001011011" =>
            manhi <= conv_std_logic_vector(3667840,24);
            manlo <= conv_std_logic_vector(160544132,28);
            exponent <= conv_std_logic_vector(1154,11);
      WHEN "0001011100" =>
            manhi <= conv_std_logic_vector(11010496,24);
            manlo <= conv_std_logic_vector(245935181,28);
            exponent <= conv_std_logic_vector(1155,11);
      WHEN "0001011101" =>
            manhi <= conv_std_logic_vector(2106492,24);
            manlo <= conv_std_logic_vector(206325441,28);
            exponent <= conv_std_logic_vector(1157,11);
      WHEN "0001011110" =>
            manhi <= conv_std_logic_vector(8888405,24);
            manlo <= conv_std_logic_vector(53641237,28);
            exponent <= conv_std_logic_vector(1158,11);
      WHEN "0001011111" =>
            manhi <= conv_std_logic_vector(664381,24);
            manlo <= conv_std_logic_vector(249887163,28);
            exponent <= conv_std_logic_vector(1160,11);
      WHEN "0001100000" =>
            manhi <= conv_std_logic_vector(6928373,24);
            manlo <= conv_std_logic_vector(95946938,28);
            exponent <= conv_std_logic_vector(1161,11);
      WHEN "0001100001" =>
            manhi <= conv_std_logic_vector(15442020,24);
            manlo <= conv_std_logic_vector(105121290,28);
            exponent <= conv_std_logic_vector(1162,11);
      WHEN "0001100010" =>
            manhi <= conv_std_logic_vector(5118025,24);
            manlo <= conv_std_logic_vector(54367076,28);
            exponent <= conv_std_logic_vector(1164,11);
      WHEN "0001100011" =>
            manhi <= conv_std_logic_vector(12981502,24);
            manlo <= conv_std_logic_vector(39000129,28);
            exponent <= conv_std_logic_vector(1165,11);
      WHEN "0001100100" =>
            manhi <= conv_std_logic_vector(3445929,24);
            manlo <= conv_std_logic_vector(186063861,28);
            exponent <= conv_std_logic_vector(1167,11);
      WHEN "0001100101" =>
            manhi <= conv_std_logic_vector(10708888,24);
            manlo <= conv_std_logic_vector(194877084,28);
            exponent <= conv_std_logic_vector(1168,11);
      WHEN "0001100110" =>
            manhi <= conv_std_logic_vector(1901528,24);
            manlo <= conv_std_logic_vector(202114223,28);
            exponent <= conv_std_logic_vector(1170,11);
      WHEN "0001100111" =>
            manhi <= conv_std_logic_vector(8609830,24);
            manlo <= conv_std_logic_vector(59099508,28);
            exponent <= conv_std_logic_vector(1171,11);
      WHEN "0001101000" =>
            manhi <= conv_std_logic_vector(475070,24);
            manlo <= conv_std_logic_vector(162304029,28);
            exponent <= conv_std_logic_vector(1173,11);
      WHEN "0001101001" =>
            manhi <= conv_std_logic_vector(6671072,24);
            manlo <= conv_std_logic_vector(157938310,28);
            exponent <= conv_std_logic_vector(1174,11);
      WHEN "0001101010" =>
            manhi <= conv_std_logic_vector(15092312,24);
            manlo <= conv_std_logic_vector(104450792,28);
            exponent <= conv_std_logic_vector(1175,11);
      WHEN "0001101011" =>
            manhi <= conv_std_logic_vector(4880373,24);
            manlo <= conv_std_logic_vector(261837049,28);
            exponent <= conv_std_logic_vector(1177,11);
      WHEN "0001101100" =>
            manhi <= conv_std_logic_vector(12658500,24);
            manlo <= conv_std_logic_vector(171583716,28);
            exponent <= conv_std_logic_vector(1178,11);
      WHEN "0001101101" =>
            manhi <= conv_std_logic_vector(3226427,24);
            manlo <= conv_std_logic_vector(110595717,28);
            exponent <= conv_std_logic_vector(1180,11);
      WHEN "0001101110" =>
            manhi <= conv_std_logic_vector(10410554,24);
            manlo <= conv_std_logic_vector(52320382,28);
            exponent <= conv_std_logic_vector(1181,11);
      WHEN "0001101111" =>
            manhi <= conv_std_logic_vector(1698789,24);
            manlo <= conv_std_logic_vector(112550995,28);
            exponent <= conv_std_logic_vector(1183,11);
      WHEN "0001110000" =>
            manhi <= conv_std_logic_vector(8334278,24);
            manlo <= conv_std_logic_vector(240753534,28);
            exponent <= conv_std_logic_vector(1184,11);
      WHEN "0001110001" =>
            manhi <= conv_std_logic_vector(287814,24);
            manlo <= conv_std_logic_vector(17691391,28);
            exponent <= conv_std_logic_vector(1186,11);
      WHEN "0001110010" =>
            manhi <= conv_std_logic_vector(6416564,24);
            manlo <= conv_std_logic_vector(151700710,28);
            exponent <= conv_std_logic_vector(1187,11);
      WHEN "0001110011" =>
            manhi <= conv_std_logic_vector(14746400,24);
            manlo <= conv_std_logic_vector(32676275,28);
            exponent <= conv_std_logic_vector(1188,11);
      WHEN "0001110100" =>
            manhi <= conv_std_logic_vector(4645302,24);
            manlo <= conv_std_logic_vector(58452725,28);
            exponent <= conv_std_logic_vector(1190,11);
      WHEN "0001110101" =>
            manhi <= conv_std_logic_vector(12339004,24);
            manlo <= conv_std_logic_vector(267247876,28);
            exponent <= conv_std_logic_vector(1191,11);
      WHEN "0001110110" =>
            manhi <= conv_std_logic_vector(3009307,24);
            manlo <= conv_std_logic_vector(164126253,28);
            exponent <= conv_std_logic_vector(1193,11);
      WHEN "0001110111" =>
            manhi <= conv_std_logic_vector(10115457,24);
            manlo <= conv_std_logic_vector(212237584,28);
            exponent <= conv_std_logic_vector(1194,11);
      WHEN "0001111000" =>
            manhi <= conv_std_logic_vector(1498250,24);
            manlo <= conv_std_logic_vector(166684427,28);
            exponent <= conv_std_logic_vector(1196,11);
      WHEN "0001111001" =>
            manhi <= conv_std_logic_vector(8061718,24);
            manlo <= conv_std_logic_vector(110371593,28);
            exponent <= conv_std_logic_vector(1197,11);
      WHEN "0001111010" =>
            manhi <= conv_std_logic_vector(102590,24);
            manlo <= conv_std_logic_vector(3231911,28);
            exponent <= conv_std_logic_vector(1199,11);
      WHEN "0001111011" =>
            manhi <= conv_std_logic_vector(6164818,24);
            manlo <= conv_std_logic_vector(261783833,28);
            exponent <= conv_std_logic_vector(1200,11);
      WHEN "0001111100" =>
            manhi <= conv_std_logic_vector(14404242,24);
            manlo <= conv_std_logic_vector(104825991,28);
            exponent <= conv_std_logic_vector(1201,11);
      WHEN "0001111101" =>
            manhi <= conv_std_logic_vector(4412781,24);
            manlo <= conv_std_logic_vector(250166254,28);
            exponent <= conv_std_logic_vector(1203,11);
      WHEN "0001111110" =>
            manhi <= conv_std_logic_vector(12022977,24);
            manlo <= conv_std_logic_vector(43417082,28);
            exponent <= conv_std_logic_vector(1204,11);
      WHEN "0001111111" =>
            manhi <= conv_std_logic_vector(2794544,24);
            manlo <= conv_std_logic_vector(115942082,28);
            exponent <= conv_std_logic_vector(1206,11);
      WHEN "0010000000" =>
            manhi <= conv_std_logic_vector(9823564,24);
            manlo <= conv_std_logic_vector(98386456,28);
            exponent <= conv_std_logic_vector(1207,11);
      WHEN "0010000001" =>
            manhi <= conv_std_logic_vector(1299888,24);
            manlo <= conv_std_logic_vector(127046227,28);
            exponent <= conv_std_logic_vector(1209,11);
      WHEN "0010000010" =>
            manhi <= conv_std_logic_vector(7792116,24);
            manlo <= conv_std_logic_vector(80649262,28);
            exponent <= conv_std_logic_vector(1210,11);
      WHEN "0010000011" =>
            manhi <= conv_std_logic_vector(16615968,24);
            manlo <= conv_std_logic_vector(205307910,28);
            exponent <= conv_std_logic_vector(1211,11);
      WHEN "0010000100" =>
            manhi <= conv_std_logic_vector(5915805,24);
            manlo <= conv_std_logic_vector(224185017,28);
            exponent <= conv_std_logic_vector(1213,11);
      WHEN "0010000101" =>
            manhi <= conv_std_logic_vector(14065798,24);
            manlo <= conv_std_logic_vector(119094636,28);
            exponent <= conv_std_logic_vector(1214,11);
      WHEN "0010000110" =>
            manhi <= conv_std_logic_vector(4182785,24);
            manlo <= conv_std_logic_vector(113890892,28);
            exponent <= conv_std_logic_vector(1216,11);
      WHEN "0010000111" =>
            manhi <= conv_std_logic_vector(11710379,24);
            manlo <= conv_std_logic_vector(133692518,28);
            exponent <= conv_std_logic_vector(1217,11);
      WHEN "0010001000" =>
            manhi <= conv_std_logic_vector(2582112,24);
            manlo <= conv_std_logic_vector(79109485,28);
            exponent <= conv_std_logic_vector(1219,11);
      WHEN "0010001001" =>
            manhi <= conv_std_logic_vector(9534839,24);
            manlo <= conv_std_logic_vector(42234535,28);
            exponent <= conv_std_logic_vector(1220,11);
      WHEN "0010001010" =>
            manhi <= conv_std_logic_vector(1103679,24);
            manlo <= conv_std_logic_vector(94193887,28);
            exponent <= conv_std_logic_vector(1222,11);
      WHEN "0010001011" =>
            manhi <= conv_std_logic_vector(7525440,24);
            manlo <= conv_std_logic_vector(121994268,28);
            exponent <= conv_std_logic_vector(1223,11);
      WHEN "0010001100" =>
            manhi <= conv_std_logic_vector(16253518,24);
            manlo <= conv_std_logic_vector(191052573,28);
            exponent <= conv_std_logic_vector(1224,11);
      WHEN "0010001101" =>
            manhi <= conv_std_logic_vector(5669495,24);
            manlo <= conv_std_logic_vector(130696997,28);
            exponent <= conv_std_logic_vector(1226,11);
      WHEN "0010001110" =>
            manhi <= conv_std_logic_vector(13731027,24);
            manlo <= conv_std_logic_vector(260846837,28);
            exponent <= conv_std_logic_vector(1227,11);
      WHEN "0010001111" =>
            manhi <= conv_std_logic_vector(3955285,24);
            manlo <= conv_std_logic_vector(80970159,28);
            exponent <= conv_std_logic_vector(1229,11);
      WHEN "0010010000" =>
            manhi <= conv_std_logic_vector(11401174,24);
            manlo <= conv_std_logic_vector(207600506,28);
            exponent <= conv_std_logic_vector(1230,11);
      WHEN "0010010001" =>
            manhi <= conv_std_logic_vector(2371985,24);
            manlo <= conv_std_logic_vector(241221170,28);
            exponent <= conv_std_logic_vector(1232,11);
      WHEN "0010010010" =>
            manhi <= conv_std_logic_vector(9249247,24);
            manlo <= conv_std_logic_vector(208105818,28);
            exponent <= conv_std_logic_vector(1233,11);
      WHEN "0010010011" =>
            manhi <= conv_std_logic_vector(909599,24);
            manlo <= conv_std_logic_vector(237519888,28);
            exponent <= conv_std_logic_vector(1235,11);
      WHEN "0010010100" =>
            manhi <= conv_std_logic_vector(7261659,24);
            manlo <= conv_std_logic_vector(29935335,28);
            exponent <= conv_std_logic_vector(1236,11);
      WHEN "0010010101" =>
            manhi <= conv_std_logic_vector(15895002,24);
            manlo <= conv_std_logic_vector(186862656,28);
            exponent <= conv_std_logic_vector(1237,11);
      WHEN "0010010110" =>
            manhi <= conv_std_logic_vector(5425858,24);
            manlo <= conv_std_logic_vector(159524243,28);
            exponent <= conv_std_logic_vector(1239,11);
      WHEN "0010010111" =>
            manhi <= conv_std_logic_vector(13399891,24);
            manlo <= conv_std_logic_vector(27586577,28);
            exponent <= conv_std_logic_vector(1240,11);
      WHEN "0010011000" =>
            manhi <= conv_std_logic_vector(3730254,24);
            manlo <= conv_std_logic_vector(125689310,28);
            exponent <= conv_std_logic_vector(1242,11);
      WHEN "0010011001" =>
            manhi <= conv_std_logic_vector(11095326,24);
            manlo <= conv_std_logic_vector(43144000,28);
            exponent <= conv_std_logic_vector(1243,11);
      WHEN "0010011010" =>
            manhi <= conv_std_logic_vector(2164140,24);
            manlo <= conv_std_logic_vector(58280992,28);
            exponent <= conv_std_logic_vector(1245,11);
      WHEN "0010011011" =>
            manhi <= conv_std_logic_vector(8966756,24);
            manlo <= conv_std_logic_vector(55210422,28);
            exponent <= conv_std_logic_vector(1246,11);
      WHEN "0010011100" =>
            manhi <= conv_std_logic_vector(717626,24);
            manlo <= conv_std_logic_vector(257633658,28);
            exponent <= conv_std_logic_vector(1248,11);
      WHEN "0010011101" =>
            manhi <= conv_std_logic_vector(7000740,24);
            manlo <= conv_std_logic_vector(229413090,28);
            exponent <= conv_std_logic_vector(1249,11);
      WHEN "0010011110" =>
            manhi <= conv_std_logic_vector(15540378,24);
            manlo <= conv_std_logic_vector(4808337,28);
            exponent <= conv_std_logic_vector(1250,11);
      WHEN "0010011111" =>
            manhi <= conv_std_logic_vector(5184866,24);
            manlo <= conv_std_logic_vector(37474138,28);
            exponent <= conv_std_logic_vector(1252,11);
      WHEN "0010100000" =>
            manhi <= conv_std_logic_vector(13072348,24);
            manlo <= conv_std_logic_vector(106730632,28);
            exponent <= conv_std_logic_vector(1253,11);
      WHEN "0010100001" =>
            manhi <= conv_std_logic_vector(3507666,24);
            manlo <= conv_std_logic_vector(32844500,28);
            exponent <= conv_std_logic_vector(1255,11);
      WHEN "0010100010" =>
            manhi <= conv_std_logic_vector(10792797,24);
            manlo <= conv_std_logic_vector(62496090,28);
            exponent <= conv_std_logic_vector(1256,11);
      WHEN "0010100011" =>
            manhi <= conv_std_logic_vector(1958550,24);
            manlo <= conv_std_logic_vector(132952012,28);
            exponent <= conv_std_logic_vector(1258,11);
      WHEN "0010100100" =>
            manhi <= conv_std_logic_vector(8687330,24);
            manlo <= conv_std_logic_vector(215605290,28);
            exponent <= conv_std_logic_vector(1259,11);
      WHEN "0010100101" =>
            manhi <= conv_std_logic_vector(527737,24);
            manlo <= conv_std_logic_vector(190928911,28);
            exponent <= conv_std_logic_vector(1261,11);
      WHEN "0010100110" =>
            manhi <= conv_std_logic_vector(6742654,24);
            manlo <= conv_std_logic_vector(163162889,28);
            exponent <= conv_std_logic_vector(1262,11);
      WHEN "0010100111" =>
            manhi <= conv_std_logic_vector(15189602,24);
            manlo <= conv_std_logic_vector(118241780,28);
            exponent <= conv_std_logic_vector(1263,11);
      WHEN "0010101000" =>
            manhi <= conv_std_logic_vector(4946489,24);
            manlo <= conv_std_logic_vector(112771062,28);
            exponent <= conv_std_logic_vector(1265,11);
      WHEN "0010101001" =>
            manhi <= conv_std_logic_vector(12748360,24);
            manlo <= conv_std_logic_vector(226864003,28);
            exponent <= conv_std_logic_vector(1266,11);
      WHEN "0010101010" =>
            manhi <= conv_std_logic_vector(3287493,24);
            manlo <= conv_std_logic_vector(202192272,28);
            exponent <= conv_std_logic_vector(1268,11);
      WHEN "0010101011" =>
            manhi <= conv_std_logic_vector(10493551,24);
            manlo <= conv_std_logic_vector(257093553,28);
            exponent <= conv_std_logic_vector(1269,11);
      WHEN "0010101100" =>
            manhi <= conv_std_logic_vector(1755192,24);
            manlo <= conv_std_logic_vector(66281405,28);
            exponent <= conv_std_logic_vector(1271,11);
      WHEN "0010101101" =>
            manhi <= conv_std_logic_vector(8410938,24);
            manlo <= conv_std_logic_vector(77199396,28);
            exponent <= conv_std_logic_vector(1272,11);
      WHEN "0010101110" =>
            manhi <= conv_std_logic_vector(339909,24);
            manlo <= conv_std_logic_vector(140417186,28);
            exponent <= conv_std_logic_vector(1274,11);
      WHEN "0010101111" =>
            manhi <= conv_std_logic_vector(6487369,24);
            manlo <= conv_std_logic_vector(169769464,28);
            exponent <= conv_std_logic_vector(1275,11);
      WHEN "0010110000" =>
            manhi <= conv_std_logic_vector(14842634,24);
            manlo <= conv_std_logic_vector(49834035,28);
            exponent <= conv_std_logic_vector(1276,11);
      WHEN "0010110001" =>
            manhi <= conv_std_logic_vector(4710700,24);
            manlo <= conv_std_logic_vector(11961455,28);
            exponent <= conv_std_logic_vector(1278,11);
      WHEN "0010110010" =>
            manhi <= conv_std_logic_vector(12427889,24);
            manlo <= conv_std_logic_vector(230234502,28);
            exponent <= conv_std_logic_vector(1279,11);
      WHEN "0010110011" =>
            manhi <= conv_std_logic_vector(3069711,24);
            manlo <= conv_std_logic_vector(36989233,28);
            exponent <= conv_std_logic_vector(1281,11);
      WHEN "0010110100" =>
            manhi <= conv_std_logic_vector(10197554,24);
            manlo <= conv_std_logic_vector(186484869,28);
            exponent <= conv_std_logic_vector(1282,11);
      WHEN "0010110101" =>
            manhi <= conv_std_logic_vector(1554041,24);
            manlo <= conv_std_logic_vector(67530342,28);
            exponent <= conv_std_logic_vector(1284,11);
      WHEN "0010110110" =>
            manhi <= conv_std_logic_vector(8137545,24);
            manlo <= conv_std_logic_vector(198608842,28);
            exponent <= conv_std_logic_vector(1285,11);
      WHEN "0010110111" =>
            manhi <= conv_std_logic_vector(154120,24);
            manlo <= conv_std_logic_vector(6569319,28);
            exponent <= conv_std_logic_vector(1287,11);
      WHEN "0010111000" =>
            manhi <= conv_std_logic_vector(6234855,24);
            manlo <= conv_std_logic_vector(140506894,28);
            exponent <= conv_std_logic_vector(1288,11);
      WHEN "0010111001" =>
            manhi <= conv_std_logic_vector(14499431,24);
            manlo <= conv_std_logic_vector(249287529,28);
            exponent <= conv_std_logic_vector(1289,11);
      WHEN "0010111010" =>
            manhi <= conv_std_logic_vector(4477469,24);
            manlo <= conv_std_logic_vector(249618841,28);
            exponent <= conv_std_logic_vector(1291,11);
      WHEN "0010111011" =>
            manhi <= conv_std_logic_vector(12110897,24);
            manlo <= conv_std_logic_vector(71519058,28);
            exponent <= conv_std_logic_vector(1292,11);
      WHEN "0010111100" =>
            manhi <= conv_std_logic_vector(2854292,24);
            manlo <= conv_std_logic_vector(90637320,28);
            exponent <= conv_std_logic_vector(1294,11);
      WHEN "0010111101" =>
            manhi <= conv_std_logic_vector(9904770,24);
            manlo <= conv_std_logic_vector(50932558,28);
            exponent <= conv_std_logic_vector(1295,11);
      WHEN "0010111110" =>
            manhi <= conv_std_logic_vector(1355073,24);
            manlo <= conv_std_logic_vector(148093260,28);
            exponent <= conv_std_logic_vector(1297,11);
      WHEN "0010111111" =>
            manhi <= conv_std_logic_vector(7867120,24);
            manlo <= conv_std_logic_vector(160620741,28);
            exponent <= conv_std_logic_vector(1298,11);
      WHEN "0011000000" =>
            manhi <= conv_std_logic_vector(16717910,24);
            manlo <= conv_std_logic_vector(46942270,28);
            exponent <= conv_std_logic_vector(1299,11);
      WHEN "0011000001" =>
            manhi <= conv_std_logic_vector(5985082,24);
            manlo <= conv_std_logic_vector(55237426,28);
            exponent <= conv_std_logic_vector(1301,11);
      WHEN "0011000010" =>
            manhi <= conv_std_logic_vector(14159954,24);
            manlo <= conv_std_logic_vector(212966668,28);
            exponent <= conv_std_logic_vector(1302,11);
      WHEN "0011000011" =>
            manhi <= conv_std_logic_vector(4246771,24);
            manlo <= conv_std_logic_vector(79962334,28);
            exponent <= conv_std_logic_vector(1304,11);
      WHEN "0011000100" =>
            manhi <= conv_std_logic_vector(11797345,24);
            manlo <= conv_std_logic_vector(85038862,28);
            exponent <= conv_std_logic_vector(1305,11);
      WHEN "0011000101" =>
            manhi <= conv_std_logic_vector(2641211,24);
            manlo <= conv_std_logic_vector(186806322,28);
            exponent <= conv_std_logic_vector(1307,11);
      WHEN "0011000110" =>
            manhi <= conv_std_logic_vector(9615163,24);
            manlo <= conv_std_logic_vector(153415152,28);
            exponent <= conv_std_logic_vector(1308,11);
      WHEN "0011000111" =>
            manhi <= conv_std_logic_vector(1158265,24);
            manlo <= conv_std_logic_vector(120731907,28);
            exponent <= conv_std_logic_vector(1310,11);
      WHEN "0011001000" =>
            manhi <= conv_std_logic_vector(7599630,24);
            manlo <= conv_std_logic_vector(175764921,28);
            exponent <= conv_std_logic_vector(1311,11);
      WHEN "0011001001" =>
            manhi <= conv_std_logic_vector(16354353,24);
            manlo <= conv_std_logic_vector(174054693,28);
            exponent <= conv_std_logic_vector(1312,11);
      WHEN "0011001010" =>
            manhi <= conv_std_logic_vector(5738019,24);
            manlo <= conv_std_logic_vector(249885394,28);
            exponent <= conv_std_logic_vector(1314,11);
      WHEN "0011001011" =>
            manhi <= conv_std_logic_vector(13824162,24);
            manlo <= conv_std_logic_vector(93203713,28);
            exponent <= conv_std_logic_vector(1315,11);
      WHEN "0011001100" =>
            manhi <= conv_std_logic_vector(4018576,24);
            manlo <= conv_std_logic_vector(180323091,28);
            exponent <= conv_std_logic_vector(1317,11);
      WHEN "0011001101" =>
            manhi <= conv_std_logic_vector(11487196,24);
            manlo <= conv_std_logic_vector(178245939,28);
            exponent <= conv_std_logic_vector(1318,11);
      WHEN "0011001110" =>
            manhi <= conv_std_logic_vector(2430443,24);
            manlo <= conv_std_logic_vector(223919964,28);
            exponent <= conv_std_logic_vector(1320,11);
      WHEN "0011001111" =>
            manhi <= conv_std_logic_vector(9328700,24);
            manlo <= conv_std_logic_vector(93205956,28);
            exponent <= conv_std_logic_vector(1321,11);
      WHEN "0011010000" =>
            manhi <= conv_std_logic_vector(963593,24);
            manlo <= conv_std_logic_vector(135688620,28);
            exponent <= conv_std_logic_vector(1323,11);
      WHEN "0011010001" =>
            manhi <= conv_std_logic_vector(7335044,24);
            manlo <= conv_std_logic_vector(13542358,28);
            exponent <= conv_std_logic_vector(1324,11);
      WHEN "0011010010" =>
            manhi <= conv_std_logic_vector(15994743,24);
            manlo <= conv_std_logic_vector(45394459,28);
            exponent <= conv_std_logic_vector(1325,11);
      WHEN "0011010011" =>
            manhi <= conv_std_logic_vector(5493639,24);
            manlo <= conv_std_logic_vector(73308838,28);
            exponent <= conv_std_logic_vector(1327,11);
      WHEN "0011010100" =>
            manhi <= conv_std_logic_vector(13492014,24);
            manlo <= conv_std_logic_vector(160135181,28);
            exponent <= conv_std_logic_vector(1328,11);
      WHEN "0011010101" =>
            manhi <= conv_std_logic_vector(3792858,24);
            manlo <= conv_std_logic_vector(234346738,28);
            exponent <= conv_std_logic_vector(1330,11);
      WHEN "0011010110" =>
            manhi <= conv_std_logic_vector(11180414,24);
            manlo <= conv_std_logic_vector(98964646,28);
            exponent <= conv_std_logic_vector(1331,11);
      WHEN "0011010111" =>
            manhi <= conv_std_logic_vector(2221963,24);
            manlo <= conv_std_logic_vector(174344531,28);
            exponent <= conv_std_logic_vector(1333,11);
      WHEN "0011011000" =>
            manhi <= conv_std_logic_vector(9045346,24);
            manlo <= conv_std_logic_vector(106947534,28);
            exponent <= conv_std_logic_vector(1334,11);
      WHEN "0011011001" =>
            manhi <= conv_std_logic_vector(771034,24);
            manlo <= conv_std_logic_vector(143065990,28);
            exponent <= conv_std_logic_vector(1336,11);
      WHEN "0011011010" =>
            manhi <= conv_std_logic_vector(7073329,24);
            manlo <= conv_std_logic_vector(73148434,28);
            exponent <= conv_std_logic_vector(1337,11);
      WHEN "0011011011" =>
            manhi <= conv_std_logic_vector(15639035,24);
            manlo <= conv_std_logic_vector(243346703,28);
            exponent <= conv_std_logic_vector(1338,11);
      WHEN "0011011100" =>
            manhi <= conv_std_logic_vector(5251911,24);
            manlo <= conv_std_logic_vector(33842377,28);
            exponent <= conv_std_logic_vector(1340,11);
      WHEN "0011011101" =>
            manhi <= conv_std_logic_vector(13163471,24);
            manlo <= conv_std_logic_vector(263552292,28);
            exponent <= conv_std_logic_vector(1341,11);
      WHEN "0011011110" =>
            manhi <= conv_std_logic_vector(3569591,24);
            manlo <= conv_std_logic_vector(4866264,28);
            exponent <= conv_std_logic_vector(1343,11);
      WHEN "0011011111" =>
            manhi <= conv_std_logic_vector(10876961,24);
            manlo <= conv_std_logic_vector(239517036,28);
            exponent <= conv_std_logic_vector(1344,11);
      WHEN "0011100000" =>
            manhi <= conv_std_logic_vector(2015746,24);
            manlo <= conv_std_logic_vector(83586287,28);
            exponent <= conv_std_logic_vector(1346,11);
      WHEN "0011100001" =>
            manhi <= conv_std_logic_vector(8765067,24);
            manlo <= conv_std_logic_vector(262254542,28);
            exponent <= conv_std_logic_vector(1347,11);
      WHEN "0011100010" =>
            manhi <= conv_std_logic_vector(580565,24);
            manlo <= conv_std_logic_vector(160521039,28);
            exponent <= conv_std_logic_vector(1349,11);
      WHEN "0011100011" =>
            manhi <= conv_std_logic_vector(6814455,24);
            manlo <= conv_std_logic_vector(40288155,28);
            exponent <= conv_std_logic_vector(1350,11);
      WHEN "0011100100" =>
            manhi <= conv_std_logic_vector(15287189,24);
            manlo <= conv_std_logic_vector(132910147,28);
            exponent <= conv_std_logic_vector(1351,11);
      WHEN "0011100101" =>
            manhi <= conv_std_logic_vector(5012806,24);
            manlo <= conv_std_logic_vector(187753904,28);
            exponent <= conv_std_logic_vector(1353,11);
      WHEN "0011100110" =>
            manhi <= conv_std_logic_vector(12838495,24);
            manlo <= conv_std_logic_vector(100071648,28);
            exponent <= conv_std_logic_vector(1354,11);
      WHEN "0011100111" =>
            manhi <= conv_std_logic_vector(3348746,24);
            manlo <= conv_std_logic_vector(138348888,28);
            exponent <= conv_std_logic_vector(1356,11);
      WHEN "0011101000" =>
            manhi <= conv_std_logic_vector(10576803,24);
            manlo <= conv_std_logic_vector(24941937,28);
            exponent <= conv_std_logic_vector(1357,11);
      WHEN "0011101001" =>
            manhi <= conv_std_logic_vector(1811767,24);
            manlo <= conv_std_logic_vector(69497619,28);
            exponent <= conv_std_logic_vector(1359,11);
      WHEN "0011101010" =>
            manhi <= conv_std_logic_vector(8487831,24);
            manlo <= conv_std_logic_vector(188199296,28);
            exponent <= conv_std_logic_vector(1360,11);
      WHEN "0011101011" =>
            manhi <= conv_std_logic_vector(392164,24);
            manlo <= conv_std_logic_vector(4096525,28);
            exponent <= conv_std_logic_vector(1362,11);
      WHEN "0011101100" =>
            manhi <= conv_std_logic_vector(6558390,24);
            manlo <= conv_std_logic_vector(228356857,28);
            exponent <= conv_std_logic_vector(1363,11);
      WHEN "0011101101" =>
            manhi <= conv_std_logic_vector(14939162,24);
            manlo <= conv_std_logic_vector(7826265,28);
            exponent <= conv_std_logic_vector(1364,11);
      WHEN "0011101110" =>
            manhi <= conv_std_logic_vector(4776297,24);
            manlo <= conv_std_logic_vector(138324122,28);
            exponent <= conv_std_logic_vector(1366,11);
      WHEN "0011101111" =>
            manhi <= conv_std_logic_vector(12517046,24);
            manlo <= conv_std_logic_vector(17190560,28);
            exponent <= conv_std_logic_vector(1367,11);
      WHEN "0011110000" =>
            manhi <= conv_std_logic_vector(3130299,24);
            manlo <= conv_std_logic_vector(16562242,28);
            exponent <= conv_std_logic_vector(1369,11);
      WHEN "0011110001" =>
            manhi <= conv_std_logic_vector(10279902,24);
            manlo <= conv_std_logic_vector(59323104,28);
            exponent <= conv_std_logic_vector(1370,11);
      WHEN "0011110010" =>
            manhi <= conv_std_logic_vector(1610002,24);
            manlo <= conv_std_logic_vector(53056333,28);
            exponent <= conv_std_logic_vector(1372,11);
      WHEN "0011110011" =>
            manhi <= conv_std_logic_vector(8213604,24);
            manlo <= conv_std_logic_vector(147986337,28);
            exponent <= conv_std_logic_vector(1373,11);
      WHEN "0011110100" =>
            manhi <= conv_std_logic_vector(205807,24);
            manlo <= conv_std_logic_vector(92802035,28);
            exponent <= conv_std_logic_vector(1375,11);
      WHEN "0011110101" =>
            manhi <= conv_std_logic_vector(6305105,24);
            manlo <= conv_std_logic_vector(235277170,28);
            exponent <= conv_std_logic_vector(1376,11);
      WHEN "0011110110" =>
            manhi <= conv_std_logic_vector(14594912,24);
            manlo <= conv_std_logic_vector(15497684,28);
            exponent <= conv_std_logic_vector(1377,11);
      WHEN "0011110111" =>
            manhi <= conv_std_logic_vector(4542355,24);
            manlo <= conv_std_logic_vector(108677892,28);
            exponent <= conv_std_logic_vector(1379,11);
      WHEN "0011111000" =>
            manhi <= conv_std_logic_vector(12199085,24);
            manlo <= conv_std_logic_vector(206743222,28);
            exponent <= conv_std_logic_vector(1380,11);
      WHEN "0011111001" =>
            manhi <= conv_std_logic_vector(2914222,24);
            manlo <= conv_std_logic_vector(171652524,28);
            exponent <= conv_std_logic_vector(1382,11);
      WHEN "0011111010" =>
            manhi <= conv_std_logic_vector(9986223,24);
            manlo <= conv_std_logic_vector(245598061,28);
            exponent <= conv_std_logic_vector(1383,11);
      WHEN "0011111011" =>
            manhi <= conv_std_logic_vector(1410427,24);
            manlo <= conv_std_logic_vector(26024388,28);
            exponent <= conv_std_logic_vector(1385,11);
      WHEN "0011111100" =>
            manhi <= conv_std_logic_vector(7942353,24);
            manlo <= conv_std_logic_vector(232590388,28);
            exponent <= conv_std_logic_vector(1386,11);
      WHEN "0011111101" =>
            manhi <= conv_std_logic_vector(21473,24);
            manlo <= conv_std_logic_vector(105719295,28);
            exponent <= conv_std_logic_vector(1388,11);
      WHEN "0011111110" =>
            manhi <= conv_std_logic_vector(6054570,24);
            manlo <= conv_std_logic_vector(16265786,28);
            exponent <= conv_std_logic_vector(1389,11);
      WHEN "0011111111" =>
            manhi <= conv_std_logic_vector(14254398,24);
            manlo <= conv_std_logic_vector(155662944,28);
            exponent <= conv_std_logic_vector(1390,11);
      WHEN "0100000000" =>
            manhi <= conv_std_logic_vector(4310952,24);
            manlo <= conv_std_logic_vector(135577274,28);
            exponent <= conv_std_logic_vector(1392,11);
      WHEN "0100000001" =>
            manhi <= conv_std_logic_vector(11884576,24);
            manlo <= conv_std_logic_vector(166805756,28);
            exponent <= conv_std_logic_vector(1393,11);
      WHEN "0100000010" =>
            manhi <= conv_std_logic_vector(2700491,24);
            manlo <= conv_std_logic_vector(137829044,28);
            exponent <= conv_std_logic_vector(1395,11);
      WHEN "0100000011" =>
            manhi <= conv_std_logic_vector(9695733,24);
            manlo <= conv_std_logic_vector(52863001,28);
            exponent <= conv_std_logic_vector(1396,11);
      WHEN "0100000100" =>
            manhi <= conv_std_logic_vector(1213018,24);
            manlo <= conv_std_logic_vector(50179603,28);
            exponent <= conv_std_logic_vector(1398,11);
      WHEN "0100000101" =>
            manhi <= conv_std_logic_vector(7674047,24);
            manlo <= conv_std_logic_vector(91276680,28);
            exponent <= conv_std_logic_vector(1399,11);
      WHEN "0100000110" =>
            manhi <= conv_std_logic_vector(16455496,24);
            manlo <= conv_std_logic_vector(110068760,28);
            exponent <= conv_std_logic_vector(1400,11);
      WHEN "0100000111" =>
            manhi <= conv_std_logic_vector(5806753,24);
            manlo <= conv_std_logic_vector(151304445,28);
            exponent <= conv_std_logic_vector(1402,11);
      WHEN "0100001000" =>
            manhi <= conv_std_logic_vector(13917581,24);
            manlo <= conv_std_logic_vector(10650184,28);
            exponent <= conv_std_logic_vector(1403,11);
      WHEN "0100001001" =>
            manhi <= conv_std_logic_vector(4082061,24);
            manlo <= conv_std_logic_vector(68530707,28);
            exponent <= conv_std_logic_vector(1405,11);
      WHEN "0100001010" =>
            manhi <= conv_std_logic_vector(11573481,24);
            manlo <= conv_std_logic_vector(42662756,28);
            exponent <= conv_std_logic_vector(1406,11);
      WHEN "0100001011" =>
            manhi <= conv_std_logic_vector(2489080,24);
            manlo <= conv_std_logic_vector(61154162,28);
            exponent <= conv_std_logic_vector(1408,11);
      WHEN "0100001100" =>
            manhi <= conv_std_logic_vector(9408395,24);
            manlo <= conv_std_logic_vector(125867240,28);
            exponent <= conv_std_logic_vector(1409,11);
      WHEN "0100001101" =>
            manhi <= conv_std_logic_vector(1017751,24);
            manlo <= conv_std_logic_vector(256555705,28);
            exponent <= conv_std_logic_vector(1411,11);
      WHEN "0100001110" =>
            manhi <= conv_std_logic_vector(7408653,24);
            manlo <= conv_std_logic_vector(4309896,28);
            exponent <= conv_std_logic_vector(1412,11);
      WHEN "0100001111" =>
            manhi <= conv_std_logic_vector(16094788,24);
            manlo <= conv_std_logic_vector(33800670,28);
            exponent <= conv_std_logic_vector(1413,11);
      WHEN "0100010000" =>
            manhi <= conv_std_logic_vector(5561626,24);
            manlo <= conv_std_logic_vector(233573192,28);
            exponent <= conv_std_logic_vector(1415,11);
      WHEN "0100010001" =>
            manhi <= conv_std_logic_vector(13584419,24);
            manlo <= conv_std_logic_vector(86257801,28);
            exponent <= conv_std_logic_vector(1416,11);
      WHEN "0100010010" =>
            manhi <= conv_std_logic_vector(3855654,24);
            manlo <= conv_std_logic_vector(105782775,28);
            exponent <= conv_std_logic_vector(1418,11);
      WHEN "0100010011" =>
            manhi <= conv_std_logic_vector(11265762,24);
            manlo <= conv_std_logic_vector(88738762,28);
            exponent <= conv_std_logic_vector(1419,11);
      WHEN "0100010100" =>
            manhi <= conv_std_logic_vector(2279963,24);
            manlo <= conv_std_logic_vector(161858527,28);
            exponent <= conv_std_logic_vector(1421,11);
      WHEN "0100010101" =>
            manhi <= conv_std_logic_vector(9124176,24);
            manlo <= conv_std_logic_vector(136423424,28);
            exponent <= conv_std_logic_vector(1422,11);
      WHEN "0100010110" =>
            manhi <= conv_std_logic_vector(824605,24);
            manlo <= conv_std_logic_vector(39384255,28);
            exponent <= conv_std_logic_vector(1424,11);
      WHEN "0100010111" =>
            manhi <= conv_std_logic_vector(7146139,24);
            manlo <= conv_std_logic_vector(76626123,28);
            exponent <= conv_std_logic_vector(1425,11);
      WHEN "0100011000" =>
            manhi <= conv_std_logic_vector(15737994,24);
            manlo <= conv_std_logic_vector(261485765,28);
            exponent <= conv_std_logic_vector(1426,11);
      WHEN "0100011001" =>
            manhi <= conv_std_logic_vector(5319160,24);
            manlo <= conv_std_logic_vector(210684009,28);
            exponent <= conv_std_logic_vector(1428,11);
      WHEN "0100011010" =>
            manhi <= conv_std_logic_vector(13254873,24);
            manlo <= conv_std_logic_vector(199859160,28);
            exponent <= conv_std_logic_vector(1429,11);
      WHEN "0100011011" =>
            manhi <= conv_std_logic_vector(3631704,24);
            manlo <= conv_std_logic_vector(256571707,28);
            exponent <= conv_std_logic_vector(1431,11);
      WHEN "0100011100" =>
            manhi <= conv_std_logic_vector(10961383,24);
            manlo <= conv_std_logic_vector(130542749,28);
            exponent <= conv_std_logic_vector(1432,11);
      WHEN "0100011101" =>
            manhi <= conv_std_logic_vector(2073116,24);
            manlo <= conv_std_logic_vector(196665136,28);
            exponent <= conv_std_logic_vector(1434,11);
      WHEN "0100011110" =>
            manhi <= conv_std_logic_vector(8843042,24);
            manlo <= conv_std_logic_vector(124490661,28);
            exponent <= conv_std_logic_vector(1435,11);
      WHEN "0100011111" =>
            manhi <= conv_std_logic_vector(633554,24);
            manlo <= conv_std_logic_vector(202834752,28);
            exponent <= conv_std_logic_vector(1437,11);
      WHEN "0100100000" =>
            manhi <= conv_std_logic_vector(6886474,24);
            manlo <= conv_std_logic_vector(236822279,28);
            exponent <= conv_std_logic_vector(1438,11);
      WHEN "0100100001" =>
            manhi <= conv_std_logic_vector(15385074,24);
            manlo <= conv_std_logic_vector(123405487,28);
            exponent <= conv_std_logic_vector(1439,11);
      WHEN "0100100010" =>
            manhi <= conv_std_logic_vector(5079326,24);
            manlo <= conv_std_logic_vector(115311954,28);
            exponent <= conv_std_logic_vector(1441,11);
      WHEN "0100100011" =>
            manhi <= conv_std_logic_vector(12928905,24);
            manlo <= conv_std_logic_vector(16004876,28);
            exponent <= conv_std_logic_vector(1442,11);
      WHEN "0100100100" =>
            manhi <= conv_std_logic_vector(3410186,24);
            manlo <= conv_std_logic_vector(71831800,28);
            exponent <= conv_std_logic_vector(1444,11);
      WHEN "0100100101" =>
            manhi <= conv_std_logic_vector(10660308,24);
            manlo <= conv_std_logic_vector(100367284,28);
            exponent <= conv_std_logic_vector(1445,11);
      WHEN "0100100110" =>
            manhi <= conv_std_logic_vector(1868514,24);
            manlo <= conv_std_logic_vector(263299419,28);
            exponent <= conv_std_logic_vector(1447,11);
      WHEN "0100100111" =>
            manhi <= conv_std_logic_vector(8564959,24);
            manlo <= conv_std_logic_vector(228656810,28);
            exponent <= conv_std_logic_vector(1448,11);
      WHEN "0100101000" =>
            manhi <= conv_std_logic_vector(444578,24);
            manlo <= conv_std_logic_vector(7489141,28);
            exponent <= conv_std_logic_vector(1450,11);
      WHEN "0100101001" =>
            manhi <= conv_std_logic_vector(6629628,24);
            manlo <= conv_std_logic_vector(236156491,28);
            exponent <= conv_std_logic_vector(1451,11);
      WHEN "0100101010" =>
            manhi <= conv_std_logic_vector(15035984,24);
            manlo <= conv_std_logic_vector(147396312,28);
            exponent <= conv_std_logic_vector(1452,11);
      WHEN "0100101011" =>
            manhi <= conv_std_logic_vector(4842095,24);
            manlo <= conv_std_logic_vector(64271882,28);
            exponent <= conv_std_logic_vector(1454,11);
      WHEN "0100101100" =>
            manhi <= conv_std_logic_vector(12606474,24);
            manlo <= conv_std_logic_vector(118909770,28);
            exponent <= conv_std_logic_vector(1455,11);
      WHEN "0100101101" =>
            manhi <= conv_std_logic_vector(3191071,24);
            manlo <= conv_std_logic_vector(253953386,28);
            exponent <= conv_std_logic_vector(1457,11);
      WHEN "0100101110" =>
            manhi <= conv_std_logic_vector(10362501,24);
            manlo <= conv_std_logic_vector(36129498,28);
            exponent <= conv_std_logic_vector(1458,11);
      WHEN "0100101111" =>
            manhi <= conv_std_logic_vector(1666133,24);
            manlo <= conv_std_logic_vector(262830684,28);
            exponent <= conv_std_logic_vector(1460,11);
      WHEN "0100110000" =>
            manhi <= conv_std_logic_vector(8289895,24);
            manlo <= conv_std_logic_vector(148197046,28);
            exponent <= conv_std_logic_vector(1461,11);
      WHEN "0100110001" =>
            manhi <= conv_std_logic_vector(257652,24);
            manlo <= conv_std_logic_vector(122404338,28);
            exponent <= conv_std_logic_vector(1463,11);
      WHEN "0100110010" =>
            manhi <= conv_std_logic_vector(6375570,24);
            manlo <= conv_std_logic_vector(184430245,28);
            exponent <= conv_std_logic_vector(1464,11);
      WHEN "0100110011" =>
            manhi <= conv_std_logic_vector(14690683,24);
            manlo <= conv_std_logic_vector(178457687,28);
            exponent <= conv_std_logic_vector(1465,11);
      WHEN "0100110100" =>
            manhi <= conv_std_logic_vector(4607438,24);
            manlo <= conv_std_logic_vector(257605193,28);
            exponent <= conv_std_logic_vector(1467,11);
      WHEN "0100110101" =>
            manhi <= conv_std_logic_vector(12287543,24);
            manlo <= conv_std_logic_vector(132163446,28);
            exponent <= conv_std_logic_vector(1468,11);
      WHEN "0100110110" =>
            manhi <= conv_std_logic_vector(2974335,24);
            manlo <= conv_std_logic_vector(240020217,28);
            exponent <= conv_std_logic_vector(1470,11);
      WHEN "0100110111" =>
            manhi <= conv_std_logic_vector(10067926,24);
            manlo <= conv_std_logic_vector(80224641,28);
            exponent <= conv_std_logic_vector(1471,11);
      WHEN "0100111000" =>
            manhi <= conv_std_logic_vector(1465949,24);
            manlo <= conv_std_logic_vector(167328478,28);
            exponent <= conv_std_logic_vector(1473,11);
      WHEN "0100111001" =>
            manhi <= conv_std_logic_vector(8017816,24);
            manlo <= conv_std_logic_vector(215756784,28);
            exponent <= conv_std_logic_vector(1474,11);
      WHEN "0100111010" =>
            manhi <= conv_std_logic_vector(72755,24);
            manlo <= conv_std_logic_vector(208473528,28);
            exponent <= conv_std_logic_vector(1476,11);
      WHEN "0100111011" =>
            manhi <= conv_std_logic_vector(6124270,24);
            manlo <= conv_std_logic_vector(12139444,28);
            exponent <= conv_std_logic_vector(1477,11);
      WHEN "0100111100" =>
            manhi <= conv_std_logic_vector(14349130,24);
            manlo <= conv_std_logic_vector(182729110,28);
            exponent <= conv_std_logic_vector(1478,11);
      WHEN "0100111101" =>
            manhi <= conv_std_logic_vector(4375329,24);
            manlo <= conv_std_logic_vector(172370119,28);
            exponent <= conv_std_logic_vector(1480,11);
      WHEN "0100111110" =>
            manhi <= conv_std_logic_vector(11972074,24);
            manlo <= conv_std_logic_vector(59679792,28);
            exponent <= conv_std_logic_vector(1481,11);
      WHEN "0100111111" =>
            manhi <= conv_std_logic_vector(2759952,24);
            manlo <= conv_std_logic_vector(80023302,28);
            exponent <= conv_std_logic_vector(1483,11);
      WHEN "0101000000" =>
            manhi <= conv_std_logic_vector(9776548,24);
            manlo <= conv_std_logic_vector(209956608,28);
            exponent <= conv_std_logic_vector(1484,11);
      WHEN "0101000001" =>
            manhi <= conv_std_logic_vector(1267938,24);
            manlo <= conv_std_logic_vector(19091951,28);
            exponent <= conv_std_logic_vector(1486,11);
      WHEN "0101000010" =>
            manhi <= conv_std_logic_vector(7748691,24);
            manlo <= conv_std_logic_vector(54127000,28);
            exponent <= conv_std_logic_vector(1487,11);
      WHEN "0101000011" =>
            manhi <= conv_std_logic_vector(16556947,24);
            manlo <= conv_std_logic_vector(251347868,28);
            exponent <= conv_std_logic_vector(1488,11);
      WHEN "0101000100" =>
            manhi <= conv_std_logic_vector(5875697,24);
            manlo <= conv_std_logic_vector(6377900,28);
            exponent <= conv_std_logic_vector(1490,11);
      WHEN "0101000101" =>
            manhi <= conv_std_logic_vector(14011284,24);
            manlo <= conv_std_logic_vector(246175281,28);
            exponent <= conv_std_logic_vector(1491,11);
      WHEN "0101000110" =>
            manhi <= conv_std_logic_vector(4145739,24);
            manlo <= conv_std_logic_vector(172360927,28);
            exponent <= conv_std_logic_vector(1493,11);
      WHEN "0101000111" =>
            manhi <= conv_std_logic_vector(11660029,24);
            manlo <= conv_std_logic_vector(16047086,28);
            exponent <= conv_std_logic_vector(1494,11);
      WHEN "0101001000" =>
            manhi <= conv_std_logic_vector(2547895,24);
            manlo <= conv_std_logic_vector(167600151,28);
            exponent <= conv_std_logic_vector(1496,11);
      WHEN "0101001001" =>
            manhi <= conv_std_logic_vector(9488333,24);
            manlo <= conv_std_logic_vector(236416250,28);
            exponent <= conv_std_logic_vector(1497,11);
      WHEN "0101001010" =>
            manhi <= conv_std_logic_vector(1072075,24);
            manlo <= conv_std_logic_vector(198323037,28);
            exponent <= conv_std_logic_vector(1499,11);
      WHEN "0101001011" =>
            manhi <= conv_std_logic_vector(7482486,24);
            manlo <= conv_std_logic_vector(185820926,28);
            exponent <= conv_std_logic_vector(1500,11);
      WHEN "0101001100" =>
            manhi <= conv_std_logic_vector(16195138,24);
            manlo <= conv_std_logic_vector(133160968,28);
            exponent <= conv_std_logic_vector(1501,11);
      WHEN "0101001101" =>
            manhi <= conv_std_logic_vector(5629822,24);
            manlo <= conv_std_logic_vector(4574050,28);
            exponent <= conv_std_logic_vector(1503,11);
      WHEN "0101001110" =>
            manhi <= conv_std_logic_vector(13677106,24);
            manlo <= conv_std_logic_vector(36414601,28);
            exponent <= conv_std_logic_vector(1504,11);
      WHEN "0101001111" =>
            manhi <= conv_std_logic_vector(3918641,24);
            manlo <= conv_std_logic_vector(165046798,28);
            exponent <= conv_std_logic_vector(1506,11);
      WHEN "0101010000" =>
            manhi <= conv_std_logic_vector(11351370,24);
            manlo <= conv_std_logic_vector(225326735,28);
            exponent <= conv_std_logic_vector(1507,11);
      WHEN "0101010001" =>
            manhi <= conv_std_logic_vector(2338140,24);
            manlo <= conv_std_logic_vector(165476611,28);
            exponent <= conv_std_logic_vector(1509,11);
      WHEN "0101010010" =>
            manhi <= conv_std_logic_vector(9203247,24);
            manlo <= conv_std_logic_vector(71807303,28);
            exponent <= conv_std_logic_vector(1510,11);
      WHEN "0101010011" =>
            manhi <= conv_std_logic_vector(878339,24);
            manlo <= conv_std_logic_vector(80195176,28);
            exponent <= conv_std_logic_vector(1512,11);
      WHEN "0101010100" =>
            manhi <= conv_std_logic_vector(7219171,24);
            manlo <= conv_std_logic_vector(153001068,28);
            exponent <= conv_std_logic_vector(1513,11);
      WHEN "0101010101" =>
            manhi <= conv_std_logic_vector(15837256,24);
            manlo <= conv_std_logic_vector(37596960,28);
            exponent <= conv_std_logic_vector(1514,11);
      WHEN "0101010110" =>
            manhi <= conv_std_logic_vector(5386615,24);
            manlo <= conv_std_logic_vector(198850796,28);
            exponent <= conv_std_logic_vector(1516,11);
      WHEN "0101010111" =>
            manhi <= conv_std_logic_vector(13346554,24);
            manlo <= conv_std_logic_vector(143609986,28);
            exponent <= conv_std_logic_vector(1517,11);
      WHEN "0101011000" =>
            manhi <= conv_std_logic_vector(3694008,24);
            manlo <= conv_std_logic_vector(137568494,28);
            exponent <= conv_std_logic_vector(1519,11);
      WHEN "0101011001" =>
            manhi <= conv_std_logic_vector(11046062,24);
            manlo <= conv_std_logic_vector(214558683,28);
            exponent <= conv_std_logic_vector(1520,11);
      WHEN "0101011010" =>
            manhi <= conv_std_logic_vector(2130662,24);
            manlo <= conv_std_logic_vector(78401205,28);
            exponent <= conv_std_logic_vector(1522,11);
      WHEN "0101011011" =>
            manhi <= conv_std_logic_vector(8921254,24);
            manlo <= conv_std_logic_vector(265219821,28);
            exponent <= conv_std_logic_vector(1523,11);
      WHEN "0101011100" =>
            manhi <= conv_std_logic_vector(686705,24);
            manlo <= conv_std_logic_vector(181591149,28);
            exponent <= conv_std_logic_vector(1525,11);
      WHEN "0101011101" =>
            manhi <= conv_std_logic_vector(6958714,24);
            manlo <= conv_std_logic_vector(127078273,28);
            exponent <= conv_std_logic_vector(1526,11);
      WHEN "0101011110" =>
            manhi <= conv_std_logic_vector(15483258,24);
            manlo <= conv_std_logic_vector(65420394,28);
            exponent <= conv_std_logic_vector(1527,11);
      WHEN "0101011111" =>
            manhi <= conv_std_logic_vector(5146049,24);
            manlo <= conv_std_logic_vector(61347424,28);
            exponent <= conv_std_logic_vector(1529,11);
      WHEN "0101100000" =>
            manhi <= conv_std_logic_vector(13019590,24);
            manlo <= conv_std_logic_vector(200148168,28);
            exponent <= conv_std_logic_vector(1530,11);
      WHEN "0101100001" =>
            manhi <= conv_std_logic_vector(3471813,24);
            manlo <= conv_std_logic_vector(155873600,28);
            exponent <= conv_std_logic_vector(1532,11);
      WHEN "0101100010" =>
            manhi <= conv_std_logic_vector(10744068,24);
            manlo <= conv_std_logic_vector(154763366,28);
            exponent <= conv_std_logic_vector(1533,11);
      WHEN "0101100011" =>
            manhi <= conv_std_logic_vector(1925435,24);
            manlo <= conv_std_logic_vector(252346422,28);
            exponent <= conv_std_logic_vector(1535,11);
      WHEN "0101100100" =>
            manhi <= conv_std_logic_vector(8642323,24);
            manlo <= conv_std_logic_vector(122496413,28);
            exponent <= conv_std_logic_vector(1536,11);
      WHEN "0101100101" =>
            manhi <= conv_std_logic_vector(497152,24);
            manlo <= conv_std_logic_vector(12881703,28);
            exponent <= conv_std_logic_vector(1538,11);
      WHEN "0101100110" =>
            manhi <= conv_std_logic_vector(6701084,24);
            manlo <= conv_std_logic_vector(102402698,28);
            exponent <= conv_std_logic_vector(1539,11);
      WHEN "0101100111" =>
            manhi <= conv_std_logic_vector(15133102,24);
            manlo <= conv_std_logic_vector(173151546,28);
            exponent <= conv_std_logic_vector(1540,11);
      WHEN "0101101000" =>
            manhi <= conv_std_logic_vector(4908093,24);
            manlo <= conv_std_logic_vector(222341698,28);
            exponent <= conv_std_logic_vector(1542,11);
      WHEN "0101101001" =>
            manhi <= conv_std_logic_vector(12696175,24);
            manlo <= conv_std_logic_vector(221558290,28);
            exponent <= conv_std_logic_vector(1543,11);
      WHEN "0101101010" =>
            manhi <= conv_std_logic_vector(3252030,24);
            manlo <= conv_std_logic_vector(95425703,28);
            exponent <= conv_std_logic_vector(1545,11);
      WHEN "0101101011" =>
            manhi <= conv_std_logic_vector(10445352,24);
            manlo <= conv_std_logic_vector(54472775,28);
            exponent <= conv_std_logic_vector(1546,11);
      WHEN "0101101100" =>
            manhi <= conv_std_logic_vector(1722437,24);
            manlo <= conv_std_logic_vector(31541381,28);
            exponent <= conv_std_logic_vector(1548,11);
      WHEN "0101101101" =>
            manhi <= conv_std_logic_vector(8366419,24);
            manlo <= conv_std_logic_vector(121077564,28);
            exponent <= conv_std_logic_vector(1549,11);
      WHEN "0101101110" =>
            manhi <= conv_std_logic_vector(309655,24);
            manlo <= conv_std_logic_vector(224679493,28);
            exponent <= conv_std_logic_vector(1551,11);
      WHEN "0101101111" =>
            manhi <= conv_std_logic_vector(6446250,24);
            manlo <= conv_std_logic_vector(163707479,28);
            exponent <= conv_std_logic_vector(1552,11);
      WHEN "0101110000" =>
            manhi <= conv_std_logic_vector(14786747,24);
            manlo <= conv_std_logic_vector(171718440,28);
            exponent <= conv_std_logic_vector(1553,11);
      WHEN "0101110001" =>
            manhi <= conv_std_logic_vector(4672721,24);
            manlo <= conv_std_logic_vector(53414720,28);
            exponent <= conv_std_logic_vector(1555,11);
      WHEN "0101110010" =>
            manhi <= conv_std_logic_vector(12376271,24);
            manlo <= conv_std_logic_vector(68395953,28);
            exponent <= conv_std_logic_vector(1556,11);
      WHEN "0101110011" =>
            manhi <= conv_std_logic_vector(3034632,24);
            manlo <= conv_std_logic_vector(177229210,28);
            exponent <= conv_std_logic_vector(1558,11);
      WHEN "0101110100" =>
            manhi <= conv_std_logic_vector(10149878,24);
            manlo <= conv_std_logic_vector(27015960,28);
            exponent <= conv_std_logic_vector(1559,11);
      WHEN "0101110101" =>
            manhi <= conv_std_logic_vector(1521641,24);
            manlo <= conv_std_logic_vector(173609470,28);
            exponent <= conv_std_logic_vector(1561,11);
      WHEN "0101110110" =>
            manhi <= conv_std_logic_vector(8093510,24);
            manlo <= conv_std_logic_vector(29891310,28);
            exponent <= conv_std_logic_vector(1562,11);
      WHEN "0101110111" =>
            manhi <= conv_std_logic_vector(124194,24);
            manlo <= conv_std_logic_vector(191198183,28);
            exponent <= conv_std_logic_vector(1564,11);
      WHEN "0101111000" =>
            manhi <= conv_std_logic_vector(6194182,24);
            manlo <= conv_std_logic_vector(216692261,28);
            exponent <= conv_std_logic_vector(1565,11);
      WHEN "0101111001" =>
            manhi <= conv_std_logic_vector(14444151,24);
            manlo <= conv_std_logic_vector(261994424,28);
            exponent <= conv_std_logic_vector(1566,11);
      WHEN "0101111010" =>
            manhi <= conv_std_logic_vector(4439903,24);
            manlo <= conv_std_logic_vector(82463931,28);
            exponent <= conv_std_logic_vector(1568,11);
      WHEN "0101111011" =>
            manhi <= conv_std_logic_vector(12059838,24);
            manlo <= conv_std_logic_vector(250318074,28);
            exponent <= conv_std_logic_vector(1569,11);
      WHEN "0101111100" =>
            manhi <= conv_std_logic_vector(2819594,24);
            manlo <= conv_std_logic_vector(161686084,28);
            exponent <= conv_std_logic_vector(1571,11);
      WHEN "0101111101" =>
            manhi <= conv_std_logic_vector(9857611,24);
            manlo <= conv_std_logic_vector(20946108,28);
            exponent <= conv_std_logic_vector(1572,11);
      WHEN "0101111110" =>
            manhi <= conv_std_logic_vector(1323025,24);
            manlo <= conv_std_logic_vector(164440795,28);
            exponent <= conv_std_logic_vector(1574,11);
      WHEN "0101111111" =>
            manhi <= conv_std_logic_vector(7823562,24);
            manlo <= conv_std_logic_vector(250479918,28);
            exponent <= conv_std_logic_vector(1575,11);
      WHEN "0110000000" =>
            manhi <= conv_std_logic_vector(16658709,24);
            manlo <= conv_std_logic_vector(45608811,28);
            exponent <= conv_std_logic_vector(1576,11);
      WHEN "0110000001" =>
            manhi <= conv_std_logic_vector(5944850,24);
            manlo <= conv_std_logic_vector(255488281,28);
            exponent <= conv_std_logic_vector(1578,11);
      WHEN "0110000010" =>
            manhi <= conv_std_logic_vector(14105274,24);
            manlo <= conv_std_logic_vector(228172930,28);
            exponent <= conv_std_logic_vector(1579,11);
      WHEN "0110000011" =>
            manhi <= conv_std_logic_vector(4209612,24);
            manlo <= conv_std_logic_vector(113758652,28);
            exponent <= conv_std_logic_vector(1581,11);
      WHEN "0110000100" =>
            manhi <= conv_std_logic_vector(11746841,24);
            manlo <= conv_std_logic_vector(45816542,28);
            exponent <= conv_std_logic_vector(1582,11);
      WHEN "0110000101" =>
            manhi <= conv_std_logic_vector(2606890,24);
            manlo <= conv_std_logic_vector(153074390,28);
            exponent <= conv_std_logic_vector(1584,11);
      WHEN "0110000110" =>
            manhi <= conv_std_logic_vector(9568516,24);
            manlo <= conv_std_logic_vector(87350878,28);
            exponent <= conv_std_logic_vector(1585,11);
      WHEN "0110000111" =>
            manhi <= conv_std_logic_vector(1126565,24);
            manlo <= conv_std_logic_vector(96475766,28);
            exponent <= conv_std_logic_vector(1587,11);
      WHEN "0110001000" =>
            manhi <= conv_std_logic_vector(7556545,24);
            manlo <= conv_std_logic_vector(205347948,28);
            exponent <= conv_std_logic_vector(1588,11);
      WHEN "0110001001" =>
            manhi <= conv_std_logic_vector(16295795,24);
            manlo <= conv_std_logic_vector(56881285,28);
            exponent <= conv_std_logic_vector(1589,11);
      WHEN "0110001010" =>
            manhi <= conv_std_logic_vector(5698225,24);
            manlo <= conv_std_logic_vector(93263076,28);
            exponent <= conv_std_logic_vector(1591,11);
      WHEN "0110001011" =>
            manhi <= conv_std_logic_vector(13770075,24);
            manlo <= conv_std_logic_vector(241769289,28);
            exponent <= conv_std_logic_vector(1592,11);
      WHEN "0110001100" =>
            manhi <= conv_std_logic_vector(3981821,24);
            manlo <= conv_std_logic_vector(32359920,28);
            exponent <= conv_std_logic_vector(1594,11);
      WHEN "0110001101" =>
            manhi <= conv_std_logic_vector(11437240,24);
            manlo <= conv_std_logic_vector(185367850,28);
            exponent <= conv_std_logic_vector(1595,11);
      WHEN "0110001110" =>
            manhi <= conv_std_logic_vector(2396495,24);
            manlo <= conv_std_logic_vector(61858550,28);
            exponent <= conv_std_logic_vector(1597,11);
      WHEN "0110001111" =>
            manhi <= conv_std_logic_vector(9282559,24);
            manlo <= conv_std_logic_vector(110304027,28);
            exponent <= conv_std_logic_vector(1598,11);
      WHEN "0110010000" =>
            manhi <= conv_std_logic_vector(932237,24);
            manlo <= conv_std_logic_vector(131077892,28);
            exponent <= conv_std_logic_vector(1600,11);
      WHEN "0110010001" =>
            manhi <= conv_std_logic_vector(7292426,24);
            manlo <= conv_std_logic_vector(215982528,28);
            exponent <= conv_std_logic_vector(1601,11);
      WHEN "0110010010" =>
            manhi <= conv_std_logic_vector(15936820,24);
            manlo <= conv_std_logic_vector(87676082,28);
            exponent <= conv_std_logic_vector(1602,11);
      WHEN "0110010011" =>
            manhi <= conv_std_logic_vector(5454276,24);
            manlo <= conv_std_logic_vector(166577430,28);
            exponent <= conv_std_logic_vector(1604,11);
      WHEN "0110010100" =>
            manhi <= conv_std_logic_vector(13438515,24);
            manlo <= conv_std_logic_vector(55023964,28);
            exponent <= conv_std_logic_vector(1605,11);
      WHEN "0110010101" =>
            manhi <= conv_std_logic_vector(3756502,24);
            manlo <= conv_std_logic_vector(71679026,28);
            exponent <= conv_std_logic_vector(1607,11);
      WHEN "0110010110" =>
            manhi <= conv_std_logic_vector(11131000,24);
            manlo <= conv_std_logic_vector(165886683,28);
            exponent <= conv_std_logic_vector(1608,11);
      WHEN "0110010111" =>
            manhi <= conv_std_logic_vector(2188383,24);
            manlo <= conv_std_logic_vector(140750309,28);
            exponent <= conv_std_logic_vector(1610,11);
      WHEN "0110011000" =>
            manhi <= conv_std_logic_vector(8999706,24);
            manlo <= conv_std_logic_vector(74200045,28);
            exponent <= conv_std_logic_vector(1611,11);
      WHEN "0110011001" =>
            manhi <= conv_std_logic_vector(740018,24);
            manlo <= conv_std_logic_vector(229350227,28);
            exponent <= conv_std_logic_vector(1613,11);
      WHEN "0110011010" =>
            manhi <= conv_std_logic_vector(7031174,24);
            manlo <= conv_std_logic_vector(159659309,28);
            exponent <= conv_std_logic_vector(1614,11);
      WHEN "0110011011" =>
            manhi <= conv_std_logic_vector(15581741,24);
            manlo <= conv_std_logic_vector(203828183,28);
            exponent <= conv_std_logic_vector(1615,11);
      WHEN "0110011100" =>
            manhi <= conv_std_logic_vector(5212975,24);
            manlo <= conv_std_logic_vector(192268981,28);
            exponent <= conv_std_logic_vector(1617,11);
      WHEN "0110011101" =>
            manhi <= conv_std_logic_vector(13110553,24);
            manlo <= conv_std_logic_vector(73367990,28);
            exponent <= conv_std_logic_vector(1618,11);
      WHEN "0110011110" =>
            manhi <= conv_std_logic_vector(3533629,24);
            manlo <= conv_std_logic_vector(7303751,28);
            exponent <= conv_std_logic_vector(1620,11);
      WHEN "0110011111" =>
            manhi <= conv_std_logic_vector(10828084,24);
            manlo <= conv_std_logic_vector(128595197,28);
            exponent <= conv_std_logic_vector(1621,11);
      WHEN "0110100000" =>
            manhi <= conv_std_logic_vector(1982530,24);
            manlo <= conv_std_logic_vector(178601213,28);
            exponent <= conv_std_logic_vector(1623,11);
      WHEN "0110100001" =>
            manhi <= conv_std_logic_vector(8719923,24);
            manlo <= conv_std_logic_vector(62665264,28);
            exponent <= conv_std_logic_vector(1624,11);
      WHEN "0110100010" =>
            manhi <= conv_std_logic_vector(549886,24);
            manlo <= conv_std_logic_vector(151395401,28);
            exponent <= conv_std_logic_vector(1626,11);
      WHEN "0110100011" =>
            manhi <= conv_std_logic_vector(6772758,24);
            manlo <= conv_std_logic_vector(5307652,28);
            exponent <= conv_std_logic_vector(1627,11);
      WHEN "0110100100" =>
            manhi <= conv_std_logic_vector(15230517,24);
            manlo <= conv_std_logic_vector(58871965,28);
            exponent <= conv_std_logic_vector(1628,11);
      WHEN "0110100101" =>
            manhi <= conv_std_logic_vector(4974293,24);
            manlo <= conv_std_logic_vector(240265124,28);
            exponent <= conv_std_logic_vector(1630,11);
      WHEN "0110100110" =>
            manhi <= conv_std_logic_vector(12786151,24);
            manlo <= conv_std_logic_vector(11983156,28);
            exponent <= conv_std_logic_vector(1631,11);
      WHEN "0110100111" =>
            manhi <= conv_std_logic_vector(3313174,24);
            manlo <= conv_std_logic_vector(229882212,28);
            exponent <= conv_std_logic_vector(1633,11);
      WHEN "0110101000" =>
            manhi <= conv_std_logic_vector(10528456,24);
            manlo <= conv_std_logic_vector(52550536,28);
            exponent <= conv_std_logic_vector(1634,11);
      WHEN "0110101001" =>
            manhi <= conv_std_logic_vector(1778912,24);
            manlo <= conv_std_logic_vector(36481057,28);
            exponent <= conv_std_logic_vector(1636,11);
      WHEN "0110101010" =>
            manhi <= conv_std_logic_vector(8443176,24);
            manlo <= conv_std_logic_vector(257480801,28);
            exponent <= conv_std_logic_vector(1637,11);
      WHEN "0110101011" =>
            manhi <= conv_std_logic_vector(361817,24);
            manlo <= conv_std_logic_vector(260890045,28);
            exponent <= conv_std_logic_vector(1639,11);
      WHEN "0110101100" =>
            manhi <= conv_std_logic_vector(6517146,24);
            manlo <= conv_std_logic_vector(80951272,28);
            exponent <= conv_std_logic_vector(1640,11);
      WHEN "0110101101" =>
            manhi <= conv_std_logic_vector(14883104,24);
            manlo <= conv_std_logic_vector(234866389,28);
            exponent <= conv_std_logic_vector(1641,11);
      WHEN "0110101110" =>
            manhi <= conv_std_logic_vector(4738202,24);
            manlo <= conv_std_logic_vector(195793257,28);
            exponent <= conv_std_logic_vector(1643,11);
      WHEN "0110101111" =>
            manhi <= conv_std_logic_vector(12465269,24);
            manlo <= conv_std_logic_vector(236730454,28);
            exponent <= conv_std_logic_vector(1644,11);
      WHEN "0110110000" =>
            manhi <= conv_std_logic_vector(3095113,24);
            manlo <= conv_std_logic_vector(133661452,28);
            exponent <= conv_std_logic_vector(1646,11);
      WHEN "0110110001" =>
            manhi <= conv_std_logic_vector(10232080,24);
            manlo <= conv_std_logic_vector(21926822,28);
            exponent <= conv_std_logic_vector(1647,11);
      WHEN "0110110010" =>
            manhi <= conv_std_logic_vector(1577503,24);
            manlo <= conv_std_logic_vector(183764948,28);
            exponent <= conv_std_logic_vector(1649,11);
      WHEN "0110110011" =>
            manhi <= conv_std_logic_vector(8169434,24);
            manlo <= conv_std_logic_vector(132210812,28);
            exponent <= conv_std_logic_vector(1650,11);
      WHEN "0110110100" =>
            manhi <= conv_std_logic_vector(175790,24);
            manlo <= conv_std_logic_vector(182183516,28);
            exponent <= conv_std_logic_vector(1652,11);
      WHEN "0110110101" =>
            manhi <= conv_std_logic_vector(6264308,24);
            manlo <= conv_std_logic_vector(267417858,28);
            exponent <= conv_std_logic_vector(1653,11);
      WHEN "0110110110" =>
            manhi <= conv_std_logic_vector(14539463,24);
            manlo <= conv_std_logic_vector(93573944,28);
            exponent <= conv_std_logic_vector(1654,11);
      WHEN "0110110111" =>
            manhi <= conv_std_logic_vector(4504674,24);
            manlo <= conv_std_logic_vector(26907375,28);
            exponent <= conv_std_logic_vector(1656,11);
      WHEN "0110111000" =>
            manhi <= conv_std_logic_vector(12147871,24);
            manlo <= conv_std_logic_vector(152302066,28);
            exponent <= conv_std_logic_vector(1657,11);
      WHEN "0110111001" =>
            manhi <= conv_std_logic_vector(2879418,24);
            manlo <= conv_std_logic_vector(263131635,28);
            exponent <= conv_std_logic_vector(1659,11);
      WHEN "0110111010" =>
            manhi <= conv_std_logic_vector(9938920,24);
            manlo <= conv_std_logic_vector(224874222,28);
            exponent <= conv_std_logic_vector(1660,11);
      WHEN "0110111011" =>
            manhi <= conv_std_logic_vector(1378281,24);
            manlo <= conv_std_logic_vector(86745210,28);
            exponent <= conv_std_logic_vector(1662,11);
      WHEN "0110111100" =>
            manhi <= conv_std_logic_vector(7898663,24);
            manlo <= conv_std_logic_vector(61761420,28);
            exponent <= conv_std_logic_vector(1663,11);
      WHEN "0110111101" =>
            manhi <= conv_std_logic_vector(16760781,24);
            manlo <= conv_std_logic_vector(15082626,28);
            exponent <= conv_std_logic_vector(1664,11);
      WHEN "0110111110" =>
            manhi <= conv_std_logic_vector(6014215,24);
            manlo <= conv_std_logic_vector(265801199,28);
            exponent <= conv_std_logic_vector(1666,11);
      WHEN "0110111111" =>
            manhi <= conv_std_logic_vector(14199551,24);
            manlo <= conv_std_logic_vector(191056853,28);
            exponent <= conv_std_logic_vector(1667,11);
      WHEN "0111000000" =>
            manhi <= conv_std_logic_vector(4273680,24);
            manlo <= conv_std_logic_vector(52024524,28);
            exponent <= conv_std_logic_vector(1669,11);
      WHEN "0111000001" =>
            manhi <= conv_std_logic_vector(11833918,24);
            manlo <= conv_std_logic_vector(80047690,28);
            exponent <= conv_std_logic_vector(1670,11);
      WHEN "0111000010" =>
            manhi <= conv_std_logic_vector(2666065,24);
            manlo <= conv_std_logic_vector(164712049,28);
            exponent <= conv_std_logic_vector(1672,11);
      WHEN "0111000011" =>
            manhi <= conv_std_logic_vector(9648943,24);
            manlo <= conv_std_logic_vector(147084012,28);
            exponent <= conv_std_logic_vector(1673,11);
      WHEN "0111000100" =>
            manhi <= conv_std_logic_vector(1181221,24);
            manlo <= conv_std_logic_vector(86912647,28);
            exponent <= conv_std_logic_vector(1675,11);
      WHEN "0111000101" =>
            manhi <= conv_std_logic_vector(7630830,24);
            manlo <= conv_std_logic_vector(247596521,28);
            exponent <= conv_std_logic_vector(1676,11);
      WHEN "0111000110" =>
            manhi <= conv_std_logic_vector(16396759,24);
            manlo <= conv_std_logic_vector(56002502,28);
            exponent <= conv_std_logic_vector(1677,11);
      WHEN "0111000111" =>
            manhi <= conv_std_logic_vector(5766837,24);
            manlo <= conv_std_logic_vector(133369322,28);
            exponent <= conv_std_logic_vector(1679,11);
      WHEN "0111001000" =>
            manhi <= conv_std_logic_vector(13863329,24);
            manlo <= conv_std_logic_vector(128884889,28);
            exponent <= conv_std_logic_vector(1680,11);
      WHEN "0111001001" =>
            manhi <= conv_std_logic_vector(4045193,24);
            manlo <= conv_std_logic_vector(133729186,28);
            exponent <= conv_std_logic_vector(1682,11);
      WHEN "0111001010" =>
            manhi <= conv_std_logic_vector(11523372,24);
            manlo <= conv_std_logic_vector(183024104,28);
            exponent <= conv_std_logic_vector(1683,11);
      WHEN "0111001011" =>
            manhi <= conv_std_logic_vector(2455027,24);
            manlo <= conv_std_logic_vector(264977965,28);
            exponent <= conv_std_logic_vector(1685,11);
      WHEN "0111001100" =>
            manhi <= conv_std_logic_vector(9362113,24);
            manlo <= conv_std_logic_vector(181285013,28);
            exponent <= conv_std_logic_vector(1686,11);
      WHEN "0111001101" =>
            manhi <= conv_std_logic_vector(986300,24);
            manlo <= conv_std_logic_vector(58020653,28);
            exponent <= conv_std_logic_vector(1688,11);
      WHEN "0111001110" =>
            manhi <= conv_std_logic_vector(7365905,24);
            manlo <= conv_std_logic_vector(179835810,28);
            exponent <= conv_std_logic_vector(1689,11);
      WHEN "0111001111" =>
            manhi <= conv_std_logic_vector(16036688,24);
            manlo <= conv_std_logic_vector(123168298,28);
            exponent <= conv_std_logic_vector(1690,11);
      WHEN "0111010000" =>
            manhi <= conv_std_logic_vector(5522144,24);
            manlo <= conv_std_logic_vector(14176725,28);
            exponent <= conv_std_logic_vector(1692,11);
      WHEN "0111010001" =>
            manhi <= conv_std_logic_vector(13530756,24);
            manlo <= conv_std_logic_vector(163453775,28);
            exponent <= conv_std_logic_vector(1693,11);
      WHEN "0111010010" =>
            manhi <= conv_std_logic_vector(3819186,24);
            manlo <= conv_std_logic_vector(214764608,28);
            exponent <= conv_std_logic_vector(1695,11);
      WHEN "0111010011" =>
            manhi <= conv_std_logic_vector(11216197,24);
            manlo <= conv_std_logic_vector(196364225,28);
            exponent <= conv_std_logic_vector(1696,11);
      WHEN "0111010100" =>
            manhi <= conv_std_logic_vector(2246280,24);
            manlo <= conv_std_logic_vector(259235483,28);
            exponent <= conv_std_logic_vector(1698,11);
      WHEN "0111010101" =>
            manhi <= conv_std_logic_vector(9078397,24);
            manlo <= conv_std_logic_vector(15526664,28);
            exponent <= conv_std_logic_vector(1699,11);
      WHEN "0111010110" =>
            manhi <= conv_std_logic_vector(793494,24);
            manlo <= conv_std_logic_vector(210641201,28);
            exponent <= conv_std_logic_vector(1701,11);
      WHEN "0111010111" =>
            manhi <= conv_std_logic_vector(7103855,24);
            manlo <= conv_std_logic_vector(246847656,28);
            exponent <= conv_std_logic_vector(1702,11);
      WHEN "0111011000" =>
            manhi <= conv_std_logic_vector(15680525,24);
            manlo <= conv_std_logic_vector(247378795,28);
            exponent <= conv_std_logic_vector(1703,11);
      WHEN "0111011001" =>
            manhi <= conv_std_logic_vector(5280106,24);
            manlo <= conv_std_logic_vector(138122391,28);
            exponent <= conv_std_logic_vector(1705,11);
      WHEN "0111011010" =>
            manhi <= conv_std_logic_vector(13201793,24);
            manlo <= conv_std_logic_vector(130963079,28);
            exponent <= conv_std_logic_vector(1706,11);
      WHEN "0111011011" =>
            manhi <= conv_std_logic_vector(3595633,24);
            manlo <= conv_std_logic_vector(48727293,28);
            exponent <= conv_std_logic_vector(1708,11);
      WHEN "0111011100" =>
            manhi <= conv_std_logic_vector(10912356,24);
            manlo <= conv_std_logic_vector(231400966,28);
            exponent <= conv_std_logic_vector(1709,11);
      WHEN "0111011101" =>
            manhi <= conv_std_logic_vector(2039799,24);
            manlo <= conv_std_logic_vector(184459756,28);
            exponent <= conv_std_logic_vector(1711,11);
      WHEN "0111011110" =>
            manhi <= conv_std_logic_vector(8797759,24);
            manlo <= conv_std_logic_vector(242699544,28);
            exponent <= conv_std_logic_vector(1712,11);
      WHEN "0111011111" =>
            manhi <= conv_std_logic_vector(602782,24);
            manlo <= conv_std_logic_vector(17680793,28);
            exponent <= conv_std_logic_vector(1714,11);
      WHEN "0111100000" =>
            manhi <= conv_std_logic_vector(6844650,24);
            manlo <= conv_std_logic_vector(123627565,28);
            exponent <= conv_std_logic_vector(1715,11);
      WHEN "0111100001" =>
            manhi <= conv_std_logic_vector(15328229,24);
            manlo <= conv_std_logic_vector(47512453,28);
            exponent <= conv_std_logic_vector(1716,11);
      WHEN "0111100010" =>
            manhi <= conv_std_logic_vector(5040696,24);
            manlo <= conv_std_logic_vector(14711664,28);
            exponent <= conv_std_logic_vector(1718,11);
      WHEN "0111100011" =>
            manhi <= conv_std_logic_vector(12876400,24);
            manlo <= conv_std_logic_vector(251456186,28);
            exponent <= conv_std_logic_vector(1719,11);
      WHEN "0111100100" =>
            manhi <= conv_std_logic_vector(3374506,24);
            manlo <= conv_std_logic_vector(4512772,28);
            exponent <= conv_std_logic_vector(1721,11);
      WHEN "0111100101" =>
            manhi <= conv_std_logic_vector(10611813,24);
            manlo <= conv_std_logic_vector(237626642,28);
            exponent <= conv_std_logic_vector(1722,11);
      WHEN "0111100110" =>
            manhi <= conv_std_logic_vector(1835559,24);
            manlo <= conv_std_logic_vector(150064655,28);
            exponent <= conv_std_logic_vector(1724,11);
      WHEN "0111100111" =>
            manhi <= conv_std_logic_vector(8520168,24);
            manlo <= conv_std_logic_vector(211971382,28);
            exponent <= conv_std_logic_vector(1725,11);
      WHEN "0111101000" =>
            manhi <= conv_std_logic_vector(414139,24);
            manlo <= conv_std_logic_vector(92694471,28);
            exponent <= conv_std_logic_vector(1727,11);
      WHEN "0111101001" =>
            manhi <= conv_std_logic_vector(6588258,24);
            manlo <= conv_std_logic_vector(112977613,28);
            exponent <= conv_std_logic_vector(1728,11);
      WHEN "0111101010" =>
            manhi <= conv_std_logic_vector(14979756,24);
            manlo <= conv_std_logic_vector(71348470,28);
            exponent <= conv_std_logic_vector(1729,11);
      WHEN "0111101011" =>
            manhi <= conv_std_logic_vector(4803884,24);
            manlo <= conv_std_logic_vector(42747344,28);
            exponent <= conv_std_logic_vector(1731,11);
      WHEN "0111101100" =>
            manhi <= conv_std_logic_vector(12554540,24);
            manlo <= conv_std_logic_vector(53825836,28);
            exponent <= conv_std_logic_vector(1732,11);
      WHEN "0111101101" =>
            manhi <= conv_std_logic_vector(3155778,24);
            manlo <= conv_std_logic_vector(260157975,28);
            exponent <= conv_std_logic_vector(1734,11);
      WHEN "0111101110" =>
            manhi <= conv_std_logic_vector(10314533,24);
            manlo <= conv_std_logic_vector(1535990,28);
            exponent <= conv_std_logic_vector(1735,11);
      WHEN "0111101111" =>
            manhi <= conv_std_logic_vector(1633536,24);
            manlo <= conv_std_logic_vector(68681060,28);
            exponent <= conv_std_logic_vector(1737,11);
      WHEN "0111110000" =>
            manhi <= conv_std_logic_vector(8245590,24);
            manlo <= conv_std_logic_vector(175202070,28);
            exponent <= conv_std_logic_vector(1738,11);
      WHEN "0111110001" =>
            manhi <= conv_std_logic_vector(227544,24);
            manlo <= conv_std_logic_vector(41675965,28);
            exponent <= conv_std_logic_vector(1740,11);
      WHEN "0111110010" =>
            manhi <= conv_std_logic_vector(6334649,24);
            manlo <= conv_std_logic_vector(70777607,28);
            exponent <= conv_std_logic_vector(1741,11);
      WHEN "0111110011" =>
            manhi <= conv_std_logic_vector(14635065,24);
            manlo <= conv_std_logic_vector(183612561,28);
            exponent <= conv_std_logic_vector(1742,11);
      WHEN "0111110100" =>
            manhi <= conv_std_logic_vector(4569642,24);
            manlo <= conv_std_logic_vector(167240760,28);
            exponent <= conv_std_logic_vector(1744,11);
      WHEN "0111110101" =>
            manhi <= conv_std_logic_vector(12236172,24);
            manlo <= conv_std_logic_vector(253623266,28);
            exponent <= conv_std_logic_vector(1745,11);
      WHEN "0111110110" =>
            manhi <= conv_std_logic_vector(2939425,24);
            manlo <= conv_std_logic_vector(265128301,28);
            exponent <= conv_std_logic_vector(1747,11);
      WHEN "0111110111" =>
            manhi <= conv_std_logic_vector(10020478,24);
            manlo <= conv_std_logic_vector(219223569,28);
            exponent <= conv_std_logic_vector(1748,11);
      WHEN "0111111000" =>
            manhi <= conv_std_logic_vector(1433705,24);
            manlo <= conv_std_logic_vector(192250058,28);
            exponent <= conv_std_logic_vector(1750,11);
      WHEN "0111111001" =>
            manhi <= conv_std_logic_vector(7973992,24);
            manlo <= conv_std_logic_vector(212144821,28);
            exponent <= conv_std_logic_vector(1751,11);
      WHEN "0111111010" =>
            manhi <= conv_std_logic_vector(42974,24);
            manlo <= conv_std_logic_vector(72952107,28);
            exponent <= conv_std_logic_vector(1753,11);
      WHEN "0111111011" =>
            manhi <= conv_std_logic_vector(6083792,24);
            manlo <= conv_std_logic_vector(210315148,28);
            exponent <= conv_std_logic_vector(1754,11);
      WHEN "0111111100" =>
            manhi <= conv_std_logic_vector(14294116,24);
            manlo <= conv_std_logic_vector(101520926,28);
            exponent <= conv_std_logic_vector(1755,11);
      WHEN "0111111101" =>
            manhi <= conv_std_logic_vector(4337943,24);
            manlo <= conv_std_logic_vector(146945490,28);
            exponent <= conv_std_logic_vector(1757,11);
      WHEN "0111111110" =>
            manhi <= conv_std_logic_vector(11921261,24);
            manlo <= conv_std_logic_vector(67478049,28);
            exponent <= conv_std_logic_vector(1758,11);
      WHEN "0111111111" =>
            manhi <= conv_std_logic_vector(2725421,24);
            manlo <= conv_std_logic_vector(81662013,28);
            exponent <= conv_std_logic_vector(1760,11);
      WHEN "1000000000" =>
            manhi <= conv_std_logic_vector(9729616,24);
            manlo <= conv_std_logic_vector(79332654,28);
            exponent <= conv_std_logic_vector(1761,11);
      WHEN "1000000001" =>
            manhi <= conv_std_logic_vector(1236044,24);
            manlo <= conv_std_logic_vector(37511845,28);
            exponent <= conv_std_logic_vector(1763,11);
      WHEN "1000000010" =>
            manhi <= conv_std_logic_vector(7705342,24);
            manlo <= conv_std_logic_vector(229400607,28);
            exponent <= conv_std_logic_vector(1764,11);
      WHEN "1000000011" =>
            manhi <= conv_std_logic_vector(16498031,24);
            manlo <= conv_std_logic_vector(113896411,28);
            exponent <= conv_std_logic_vector(1765,11);
      WHEN "1000000100" =>
            manhi <= conv_std_logic_vector(5835659,24);
            manlo <= conv_std_logic_vector(27578100,28);
            exponent <= conv_std_logic_vector(1767,11);
      WHEN "1000000101" =>
            manhi <= conv_std_logic_vector(13956867,24);
            manlo <= conv_std_logic_vector(198774093,28);
            exponent <= conv_std_logic_vector(1768,11);
      WHEN "1000000110" =>
            manhi <= conv_std_logic_vector(4108759,24);
            manlo <= conv_std_logic_vector(90336304,28);
            exponent <= conv_std_logic_vector(1770,11);
      WHEN "1000000111" =>
            manhi <= conv_std_logic_vector(11609767,24);
            manlo <= conv_std_logic_vector(164675818,28);
            exponent <= conv_std_logic_vector(1771,11);
      WHEN "1000001000" =>
            manhi <= conv_std_logic_vector(2513739,24);
            manlo <= conv_std_logic_vector(115510945,28);
            exponent <= conv_std_logic_vector(1773,11);
      WHEN "1000001001" =>
            manhi <= conv_std_logic_vector(9441910,24);
            manlo <= conv_std_logic_vector(214725537,28);
            exponent <= conv_std_logic_vector(1774,11);
      WHEN "1000001010" =>
            manhi <= conv_std_logic_vector(1040527,24);
            manlo <= conv_std_logic_vector(264292986,28);
            exponent <= conv_std_logic_vector(1776,11);
      WHEN "1000001011" =>
            manhi <= conv_std_logic_vector(7439608,24);
            manlo <= conv_std_logic_vector(227819416,28);
            exponent <= conv_std_logic_vector(1777,11);
      WHEN "1000001100" =>
            manhi <= conv_std_logic_vector(16136861,24);
            manlo <= conv_std_logic_vector(124712281,28);
            exponent <= conv_std_logic_vector(1778,11);
      WHEN "1000001101" =>
            manhi <= conv_std_logic_vector(5590218,24);
            manlo <= conv_std_logic_vector(179347558,28);
            exponent <= conv_std_logic_vector(1780,11);
      WHEN "1000001110" =>
            manhi <= conv_std_logic_vector(13623279,24);
            manlo <= conv_std_logic_vector(162081347,28);
            exponent <= conv_std_logic_vector(1781,11);
      WHEN "1000001111" =>
            manhi <= conv_std_logic_vector(3882062,24);
            manlo <= conv_std_logic_vector(186291443,28);
            exponent <= conv_std_logic_vector(1783,11);
      WHEN "1000010000" =>
            manhi <= conv_std_logic_vector(11301654,24);
            manlo <= conv_std_logic_vector(250040022,28);
            exponent <= conv_std_logic_vector(1784,11);
      WHEN "1000010001" =>
            manhi <= conv_std_logic_vector(2304355,24);
            manlo <= conv_std_logic_vector(41383777,28);
            exponent <= conv_std_logic_vector(1786,11);
      WHEN "1000010010" =>
            manhi <= conv_std_logic_vector(9157328,24);
            manlo <= conv_std_logic_vector(17021400,28);
            exponent <= conv_std_logic_vector(1787,11);
      WHEN "1000010011" =>
            manhi <= conv_std_logic_vector(847133,24);
            manlo <= conv_std_logic_vector(258834653,28);
            exponent <= conv_std_logic_vector(1789,11);
      WHEN "1000010100" =>
            manhi <= conv_std_logic_vector(7176759,24);
            manlo <= conv_std_logic_vector(33041815,28);
            exponent <= conv_std_logic_vector(1790,11);
      WHEN "1000010101" =>
            manhi <= conv_std_logic_vector(15779611,24);
            manlo <= conv_std_logic_vector(174007449,28);
            exponent <= conv_std_logic_vector(1791,11);
      WHEN "1000010110" =>
            manhi <= conv_std_logic_vector(5347442,24);
            manlo <= conv_std_logic_vector(66333886,28);
            exponent <= conv_std_logic_vector(1793,11);
      WHEN "1000010111" =>
            manhi <= conv_std_logic_vector(13293312,24);
            manlo <= conv_std_logic_vector(63618366,28);
            exponent <= conv_std_logic_vector(1794,11);
      WHEN "1000011000" =>
            manhi <= conv_std_logic_vector(3657826,24);
            manlo <= conv_std_logic_vector(166348998,28);
            exponent <= conv_std_logic_vector(1796,11);
      WHEN "1000011001" =>
            manhi <= conv_std_logic_vector(10996886,24);
            manlo <= conv_std_logic_vector(136487624,28);
            exponent <= conv_std_logic_vector(1797,11);
      WHEN "1000011010" =>
            manhi <= conv_std_logic_vector(2097243,24);
            manlo <= conv_std_logic_vector(144317262,28);
            exponent <= conv_std_logic_vector(1799,11);
      WHEN "1000011011" =>
            manhi <= conv_std_logic_vector(8875834,24);
            manlo <= conv_std_logic_vector(51419886,28);
            exponent <= conv_std_logic_vector(1800,11);
      WHEN "1000011100" =>
            manhi <= conv_std_logic_vector(655839,24);
            manlo <= conv_std_logic_vector(12096311,28);
            exponent <= conv_std_logic_vector(1802,11);
      WHEN "1000011101" =>
            manhi <= conv_std_logic_vector(6916762,24);
            manlo <= conv_std_logic_vector(99793437,28);
            exponent <= conv_std_logic_vector(1803,11);
      WHEN "1000011110" =>
            manhi <= conv_std_logic_vector(15426239,24);
            manlo <= conv_std_logic_vector(114334116,28);
            exponent <= conv_std_logic_vector(1804,11);
      WHEN "1000011111" =>
            manhi <= conv_std_logic_vector(5107300,24);
            manlo <= conv_std_logic_vector(248161218,28);
            exponent <= conv_std_logic_vector(1806,11);
      WHEN "1000100000" =>
            manhi <= conv_std_logic_vector(12966926,24);
            manlo <= conv_std_logic_vector(91321506,28);
            exponent <= conv_std_logic_vector(1807,11);
      WHEN "1000100001" =>
            manhi <= conv_std_logic_vector(3436024,24);
            manlo <= conv_std_logic_vector(109150055,28);
            exponent <= conv_std_logic_vector(1809,11);
      WHEN "1000100010" =>
            manhi <= conv_std_logic_vector(10695426,24);
            manlo <= conv_std_logic_vector(12291314,28);
            exponent <= conv_std_logic_vector(1810,11);
      WHEN "1000100011" =>
            manhi <= conv_std_logic_vector(1892379,24);
            manlo <= conv_std_logic_vector(245137096,28);
            exponent <= conv_std_logic_vector(1812,11);
      WHEN "1000100100" =>
            manhi <= conv_std_logic_vector(8597395,24);
            manlo <= conv_std_logic_vector(176569250,28);
            exponent <= conv_std_logic_vector(1813,11);
      WHEN "1000100101" =>
            manhi <= conv_std_logic_vector(466620,24);
            manlo <= conv_std_logic_vector(119019308,28);
            exponent <= conv_std_logic_vector(1815,11);
      WHEN "1000100110" =>
            manhi <= conv_std_logic_vector(6659587,24);
            manlo <= conv_std_logic_vector(168706814,28);
            exponent <= conv_std_logic_vector(1816,11);
      WHEN "1000100111" =>
            manhi <= conv_std_logic_vector(15076702,24);
            manlo <= conv_std_logic_vector(190651618,28);
            exponent <= conv_std_logic_vector(1817,11);
      WHEN "1000101000" =>
            manhi <= conv_std_logic_vector(4869766,24);
            manlo <= conv_std_logic_vector(26523901,28);
            exponent <= conv_std_logic_vector(1819,11);
      WHEN "1000101001" =>
            manhi <= conv_std_logic_vector(12644083,24);
            manlo <= conv_std_logic_vector(10760420,28);
            exponent <= conv_std_logic_vector(1820,11);
      WHEN "1000101010" =>
            manhi <= conv_std_logic_vector(3216629,24);
            manlo <= conv_std_logic_vector(171149379,28);
            exponent <= conv_std_logic_vector(1822,11);
      WHEN "1000101011" =>
            manhi <= conv_std_logic_vector(10397237,24);
            manlo <= conv_std_logic_vector(171483537,28);
            exponent <= conv_std_logic_vector(1823,11);
      WHEN "1000101100" =>
            manhi <= conv_std_logic_vector(1689739,24);
            manlo <= conv_std_logic_vector(236540182,28);
            exponent <= conv_std_logic_vector(1825,11);
      WHEN "1000101101" =>
            manhi <= conv_std_logic_vector(8321979,24);
            manlo <= conv_std_logic_vector(80365386,28);
            exponent <= conv_std_logic_vector(1826,11);
      WHEN "1000101110" =>
            manhi <= conv_std_logic_vector(279455,24);
            manlo <= conv_std_logic_vector(167185714,28);
            exponent <= conv_std_logic_vector(1828,11);
      WHEN "1000101111" =>
            manhi <= conv_std_logic_vector(6405204,24);
            manlo <= conv_std_logic_vector(70637708,28);
            exponent <= conv_std_logic_vector(1829,11);
      WHEN "1000110000" =>
            manhi <= conv_std_logic_vector(14730959,24);
            manlo <= conv_std_logic_vector(233674466,28);
            exponent <= conv_std_logic_vector(1830,11);
      WHEN "1000110001" =>
            manhi <= conv_std_logic_vector(4634809,24);
            manlo <= conv_std_logic_vector(128626627,28);
            exponent <= conv_std_logic_vector(1832,11);
      WHEN "1000110010" =>
            manhi <= conv_std_logic_vector(12324743,24);
            manlo <= conv_std_logic_vector(237637056,28);
            exponent <= conv_std_logic_vector(1833,11);
      WHEN "1000110011" =>
            manhi <= conv_std_logic_vector(2999616,24);
            manlo <= conv_std_logic_vector(48899908,28);
            exponent <= conv_std_logic_vector(1835,11);
      WHEN "1000110100" =>
            manhi <= conv_std_logic_vector(10102285,24);
            manlo <= conv_std_logic_vector(207402206,28);
            exponent <= conv_std_logic_vector(1836,11);
      WHEN "1000110101" =>
            manhi <= conv_std_logic_vector(1489299,24);
            manlo <= conv_std_logic_vector(82314533,28);
            exponent <= conv_std_logic_vector(1838,11);
      WHEN "1000110110" =>
            manhi <= conv_std_logic_vector(8049552,24);
            manlo <= conv_std_logic_vector(84197942,28);
            exponent <= conv_std_logic_vector(1839,11);
      WHEN "1000110111" =>
            manhi <= conv_std_logic_vector(94322,24);
            manlo <= conv_std_logic_vector(78275083,28);
            exponent <= conv_std_logic_vector(1841,11);
      WHEN "1000111000" =>
            manhi <= conv_std_logic_vector(6153581,24);
            manlo <= conv_std_logic_vector(262556746,28);
            exponent <= conv_std_logic_vector(1842,11);
      WHEN "1000111001" =>
            manhi <= conv_std_logic_vector(14388969,24);
            manlo <= conv_std_logic_vector(195412276,28);
            exponent <= conv_std_logic_vector(1843,11);
      WHEN "1000111010" =>
            manhi <= conv_std_logic_vector(4402403,24);
            manlo <= conv_std_logic_vector(21925377,28);
            exponent <= conv_std_logic_vector(1845,11);
      WHEN "1000111011" =>
            manhi <= conv_std_logic_vector(12008870,24);
            manlo <= conv_std_logic_vector(225943576,28);
            exponent <= conv_std_logic_vector(1846,11);
      WHEN "1000111100" =>
            manhi <= conv_std_logic_vector(2784958,24);
            manlo <= conv_std_logic_vector(51959162,28);
            exponent <= conv_std_logic_vector(1848,11);
      WHEN "1000111101" =>
            manhi <= conv_std_logic_vector(9810535,24);
            manlo <= conv_std_logic_vector(85297068,28);
            exponent <= conv_std_logic_vector(1849,11);
      WHEN "1000111110" =>
            manhi <= conv_std_logic_vector(1291034,24);
            manlo <= conv_std_logic_vector(85003113,28);
            exponent <= conv_std_logic_vector(1851,11);
      WHEN "1000111111" =>
            manhi <= conv_std_logic_vector(7780082,24);
            manlo <= conv_std_logic_vector(68159752,28);
            exponent <= conv_std_logic_vector(1852,11);
      WHEN "1001000000" =>
            manhi <= conv_std_logic_vector(16599612,24);
            manlo <= conv_std_logic_vector(214703512,28);
            exponent <= conv_std_logic_vector(1853,11);
      WHEN "1001000001" =>
            manhi <= conv_std_logic_vector(5904690,24);
            manlo <= conv_std_logic_vector(215968023,28);
            exponent <= conv_std_logic_vector(1855,11);
      WHEN "1001000010" =>
            manhi <= conv_std_logic_vector(14050691,24);
            manlo <= conv_std_logic_vector(147853227,28);
            exponent <= conv_std_logic_vector(1856,11);
      WHEN "1001000011" =>
            manhi <= conv_std_logic_vector(4172519,24);
            manlo <= conv_std_logic_vector(60716388,28);
            exponent <= conv_std_logic_vector(1858,11);
      WHEN "1001000100" =>
            manhi <= conv_std_logic_vector(11696426,24);
            manlo <= conv_std_logic_vector(77359100,28);
            exponent <= conv_std_logic_vector(1859,11);
      WHEN "1001000101" =>
            manhi <= conv_std_logic_vector(2572630,24);
            manlo <= conv_std_logic_vector(28321055,28);
            exponent <= conv_std_logic_vector(1861,11);
      WHEN "1001000110" =>
            manhi <= conv_std_logic_vector(9521951,24);
            manlo <= conv_std_logic_vector(141206574,28);
            exponent <= conv_std_logic_vector(1862,11);
      WHEN "1001000111" =>
            manhi <= conv_std_logic_vector(1094921,24);
            manlo <= conv_std_logic_vector(79834212,28);
            exponent <= conv_std_logic_vector(1864,11);
      WHEN "1001001000" =>
            manhi <= conv_std_logic_vector(7513537,24);
            manlo <= conv_std_logic_vector(6880382,28);
            exponent <= conv_std_logic_vector(1865,11);
      WHEN "1001001001" =>
            manhi <= conv_std_logic_vector(16237340,24);
            manlo <= conv_std_logic_vector(73707069,28);
            exponent <= conv_std_logic_vector(1866,11);
      WHEN "1001001010" =>
            manhi <= conv_std_logic_vector(5658501,24);
            manlo <= conv_std_logic_vector(26563701,28);
            exponent <= conv_std_logic_vector(1868,11);
      WHEN "1001001011" =>
            manhi <= conv_std_logic_vector(13716085,24);
            manlo <= conv_std_logic_vector(13226359,28);
            exponent <= conv_std_logic_vector(1869,11);
      WHEN "1001001100" =>
            manhi <= conv_std_logic_vector(3945130,24);
            manlo <= conv_std_logic_vector(143073903,28);
            exponent <= conv_std_logic_vector(1871,11);
      WHEN "1001001101" =>
            manhi <= conv_std_logic_vector(11387373,24);
            manlo <= conv_std_logic_vector(3175990,28);
            exponent <= conv_std_logic_vector(1872,11);
      WHEN "1001001110" =>
            manhi <= conv_std_logic_vector(2362606,24);
            manlo <= conv_std_logic_vector(168904878,28);
            exponent <= conv_std_logic_vector(1874,11);
      WHEN "1001001111" =>
            manhi <= conv_std_logic_vector(9236500,24);
            manlo <= conv_std_logic_vector(7105104,28);
            exponent <= conv_std_logic_vector(1875,11);
      WHEN "1001010000" =>
            manhi <= conv_std_logic_vector(900936,24);
            manlo <= conv_std_logic_vector(239272854,28);
            exponent <= conv_std_logic_vector(1877,11);
      WHEN "1001010001" =>
            manhi <= conv_std_logic_vector(7249884,24);
            manlo <= conv_std_logic_vector(236935482,28);
            exponent <= conv_std_logic_vector(1878,11);
      WHEN "1001010010" =>
            manhi <= conv_std_logic_vector(15878999,24);
            manlo <= conv_std_logic_vector(230836932,28);
            exponent <= conv_std_logic_vector(1879,11);
      WHEN "1001010011" =>
            manhi <= conv_std_logic_vector(5414983,24);
            manlo <= conv_std_logic_vector(144840810,28);
            exponent <= conv_std_logic_vector(1881,11);
      WHEN "1001010100" =>
            manhi <= conv_std_logic_vector(13385110,24);
            manlo <= conv_std_logic_vector(99584369,28);
            exponent <= conv_std_logic_vector(1882,11);
      WHEN "1001010101" =>
            manhi <= conv_std_logic_vector(3720209,24);
            manlo <= conv_std_logic_vector(246845719,28);
            exponent <= conv_std_logic_vector(1884,11);
      WHEN "1001010110" =>
            manhi <= conv_std_logic_vector(11081674,24);
            manlo <= conv_std_logic_vector(54674652,28);
            exponent <= conv_std_logic_vector(1885,11);
      WHEN "1001010111" =>
            manhi <= conv_std_logic_vector(2154862,24);
            manlo <= conv_std_logic_vector(201440422,28);
            exponent <= conv_std_logic_vector(1887,11);
      WHEN "1001011000" =>
            manhi <= conv_std_logic_vector(8954146,24);
            manlo <= conv_std_logic_vector(220416825,28);
            exponent <= conv_std_logic_vector(1888,11);
      WHEN "1001011001" =>
            manhi <= conv_std_logic_vector(709057,24);
            manlo <= conv_std_logic_vector(266967657,28);
            exponent <= conv_std_logic_vector(1890,11);
      WHEN "1001011010" =>
            manhi <= conv_std_logic_vector(6989094,24);
            manlo <= conv_std_logic_vector(113654547,28);
            exponent <= conv_std_logic_vector(1891,11);
      WHEN "1001011011" =>
            manhi <= conv_std_logic_vector(15524548,24);
            manlo <= conv_std_logic_vector(235342013,28);
            exponent <= conv_std_logic_vector(1892,11);
      WHEN "1001011100" =>
            manhi <= conv_std_logic_vector(5174109,24);
            manlo <= conv_std_logic_vector(32986511,28);
            exponent <= conv_std_logic_vector(1894,11);
      WHEN "1001011101" =>
            manhi <= conv_std_logic_vector(13057728,24);
            manlo <= conv_std_logic_vector(25787653,28);
            exponent <= conv_std_logic_vector(1895,11);
      WHEN "1001011110" =>
            manhi <= conv_std_logic_vector(3497730,24);
            manlo <= conv_std_logic_vector(160351868,28);
            exponent <= conv_std_logic_vector(1897,11);
      WHEN "1001011111" =>
            manhi <= conv_std_logic_vector(10779293,24);
            manlo <= conv_std_logic_vector(121946709,28);
            exponent <= conv_std_logic_vector(1898,11);
      WHEN "1001100000" =>
            manhi <= conv_std_logic_vector(1949373,24);
            manlo <= conv_std_logic_vector(194974600,28);
            exponent <= conv_std_logic_vector(1900,11);
      WHEN "1001100001" =>
            manhi <= conv_std_logic_vector(8674858,24);
            manlo <= conv_std_logic_vector(75445083,28);
            exponent <= conv_std_logic_vector(1901,11);
      WHEN "1001100010" =>
            manhi <= conv_std_logic_vector(519261,24);
            manlo <= conv_std_logic_vector(202318540,28);
            exponent <= conv_std_logic_vector(1903,11);
      WHEN "1001100011" =>
            manhi <= conv_std_logic_vector(6731134,24);
            manlo <= conv_std_logic_vector(157600610,28);
            exponent <= conv_std_logic_vector(1904,11);
      WHEN "1001100100" =>
            manhi <= conv_std_logic_vector(15173945,24);
            manlo <= conv_std_logic_vector(29256816,28);
            exponent <= conv_std_logic_vector(1905,11);
      WHEN "1001100101" =>
            manhi <= conv_std_logic_vector(4935849,24);
            manlo <= conv_std_logic_vector(42999013,28);
            exponent <= conv_std_logic_vector(1907,11);
      WHEN "1001100110" =>
            manhi <= conv_std_logic_vector(12733899,24);
            manlo <= conv_std_logic_vector(62421287,28);
            exponent <= conv_std_logic_vector(1908,11);
      WHEN "1001100111" =>
            manhi <= conv_std_logic_vector(3277666,24);
            manlo <= conv_std_logic_vector(18399062,28);
            exponent <= conv_std_logic_vector(1910,11);
      WHEN "1001101000" =>
            manhi <= conv_std_logic_vector(10480194,24);
            manlo <= conv_std_logic_vector(201166396,28);
            exponent <= conv_std_logic_vector(1911,11);
      WHEN "1001101001" =>
            manhi <= conv_std_logic_vector(1746115,24);
            manlo <= conv_std_logic_vector(22209480,28);
            exponent <= conv_std_logic_vector(1913,11);
      WHEN "1001101010" =>
            manhi <= conv_std_logic_vector(8398601,24);
            manlo <= conv_std_logic_vector(38216343,28);
            exponent <= conv_std_logic_vector(1914,11);
      WHEN "1001101011" =>
            manhi <= conv_std_logic_vector(331525,24);
            manlo <= conv_std_logic_vector(151310615,28);
            exponent <= conv_std_logic_vector(1916,11);
      WHEN "1001101100" =>
            manhi <= conv_std_logic_vector(6475974,24);
            manlo <= conv_std_logic_vector(174528998,28);
            exponent <= conv_std_logic_vector(1917,11);
      WHEN "1001101101" =>
            manhi <= conv_std_logic_vector(14827146,24);
            manlo <= conv_std_logic_vector(214487191,28);
            exponent <= conv_std_logic_vector(1918,11);
      WHEN "1001101110" =>
            manhi <= conv_std_logic_vector(4700175,24);
            manlo <= conv_std_logic_vector(73593076,28);
            exponent <= conv_std_logic_vector(1920,11);
      WHEN "1001101111" =>
            manhi <= conv_std_logic_vector(12413585,24);
            manlo <= conv_std_logic_vector(56806573,28);
            exponent <= conv_std_logic_vector(1921,11);
      WHEN "1001110000" =>
            manhi <= conv_std_logic_vector(3059990,24);
            manlo <= conv_std_logic_vector(32998071,28);
            exponent <= conv_std_logic_vector(1923,11);
      WHEN "1001110001" =>
            manhi <= conv_std_logic_vector(10184342,24);
            manlo <= conv_std_logic_vector(125003687,28);
            exponent <= conv_std_logic_vector(1924,11);
      WHEN "1001110010" =>
            manhi <= conv_std_logic_vector(1545062,24);
            manlo <= conv_std_logic_vector(164026180,28);
            exponent <= conv_std_logic_vector(1926,11);
      WHEN "1001110011" =>
            manhi <= conv_std_logic_vector(8125342,24);
            manlo <= conv_std_logic_vector(134803968,28);
            exponent <= conv_std_logic_vector(1927,11);
      WHEN "1001110100" =>
            manhi <= conv_std_logic_vector(145827,24);
            manlo <= conv_std_logic_vector(17356019,28);
            exponent <= conv_std_logic_vector(1929,11);
      WHEN "1001110101" =>
            manhi <= conv_std_logic_vector(6223584,24);
            manlo <= conv_std_logic_vector(59711433,28);
            exponent <= conv_std_logic_vector(1930,11);
      WHEN "1001110110" =>
            manhi <= conv_std_logic_vector(14484112,24);
            manlo <= conv_std_logic_vector(172427100,28);
            exponent <= conv_std_logic_vector(1931,11);
      WHEN "1001110111" =>
            manhi <= conv_std_logic_vector(4467059,24);
            manlo <= conv_std_logic_vector(106163660,28);
            exponent <= conv_std_logic_vector(1933,11);
      WHEN "1001111000" =>
            manhi <= conv_std_logic_vector(12096747,24);
            manlo <= conv_std_logic_vector(237074316,28);
            exponent <= conv_std_logic_vector(1934,11);
      WHEN "1001111001" =>
            manhi <= conv_std_logic_vector(2844676,24);
            manlo <= conv_std_logic_vector(224090291,28);
            exponent <= conv_std_logic_vector(1936,11);
      WHEN "1001111010" =>
            manhi <= conv_std_logic_vector(9891701,24);
            manlo <= conv_std_logic_vector(98356275,28);
            exponent <= conv_std_logic_vector(1937,11);
      WHEN "1001111011" =>
            manhi <= conv_std_logic_vector(1346192,24);
            manlo <= conv_std_logic_vector(98098154,28);
            exponent <= conv_std_logic_vector(1939,11);
      WHEN "1001111100" =>
            manhi <= conv_std_logic_vector(7855049,24);
            manlo <= conv_std_logic_vector(218711727,28);
            exponent <= conv_std_logic_vector(1940,11);
      WHEN "1001111101" =>
            manhi <= conv_std_logic_vector(16701504,24);
            manlo <= conv_std_logic_vector(74899902,28);
            exponent <= conv_std_logic_vector(1941,11);
      WHEN "1001111110" =>
            manhi <= conv_std_logic_vector(5973933,24);
            manlo <= conv_std_logic_vector(65399866,28);
            exponent <= conv_std_logic_vector(1943,11);
      WHEN "1001111111" =>
            manhi <= conv_std_logic_vector(14144801,24);
            manlo <= conv_std_logic_vector(210121699,28);
            exponent <= conv_std_logic_vector(1944,11);
      WHEN "1010000000" =>
            manhi <= conv_std_logic_vector(4236473,24);
            manlo <= conv_std_logic_vector(203888522,28);
            exponent <= conv_std_logic_vector(1946,11);
      WHEN "1010000001" =>
            manhi <= conv_std_logic_vector(11783349,24);
            manlo <= conv_std_logic_vector(137203293,28);
            exponent <= conv_std_logic_vector(1947,11);
      WHEN "1010000010" =>
            manhi <= conv_std_logic_vector(2631700,24);
            manlo <= conv_std_logic_vector(150283410,28);
            exponent <= conv_std_logic_vector(1949,11);
      WHEN "1010000011" =>
            manhi <= conv_std_logic_vector(9602236,24);
            manlo <= conv_std_logic_vector(160352104,28);
            exponent <= conv_std_logic_vector(1950,11);
      WHEN "1010000100" =>
            manhi <= conv_std_logic_vector(1149480,24);
            manlo <= conv_std_logic_vector(177173803,28);
            exponent <= conv_std_logic_vector(1952,11);
      WHEN "1010000101" =>
            manhi <= conv_std_logic_vector(7587690,24);
            manlo <= conv_std_logic_vector(238268718,28);
            exponent <= conv_std_logic_vector(1953,11);
      WHEN "1010000110" =>
            manhi <= conv_std_logic_vector(16338125,24);
            manlo <= conv_std_logic_vector(220749839,28);
            exponent <= conv_std_logic_vector(1954,11);
      WHEN "1010000111" =>
            manhi <= conv_std_logic_vector(5726991,24);
            manlo <= conv_std_logic_vector(262994505,28);
            exponent <= conv_std_logic_vector(1956,11);
      WHEN "1010001000" =>
            manhi <= conv_std_logic_vector(13809173,24);
            manlo <= conv_std_logic_vector(216783842,28);
            exponent <= conv_std_logic_vector(1957,11);
      WHEN "1010001001" =>
            manhi <= conv_std_logic_vector(4008390,24);
            manlo <= conv_std_logic_vector(242405077,28);
            exponent <= conv_std_logic_vector(1959,11);
      WHEN "1010001010" =>
            manhi <= conv_std_logic_vector(11473352,24);
            manlo <= conv_std_logic_vector(206426515,28);
            exponent <= conv_std_logic_vector(1960,11);
      WHEN "1010001011" =>
            manhi <= conv_std_logic_vector(2421035,24);
            manlo <= conv_std_logic_vector(250208807,28);
            exponent <= conv_std_logic_vector(1962,11);
      WHEN "1010001100" =>
            manhi <= conv_std_logic_vector(9315913,24);
            manlo <= conv_std_logic_vector(183235034,28);
            exponent <= conv_std_logic_vector(1963,11);
      WHEN "1010001101" =>
            manhi <= conv_std_logic_vector(954904,24);
            manlo <= conv_std_logic_vector(17706469,28);
            exponent <= conv_std_logic_vector(1965,11);
      WHEN "1010001110" =>
            manhi <= conv_std_logic_vector(7323233,24);
            manlo <= conv_std_logic_vector(235600136,28);
            exponent <= conv_std_logic_vector(1966,11);
      WHEN "1010001111" =>
            manhi <= conv_std_logic_vector(15978691,24);
            manlo <= conv_std_logic_vector(128873524,28);
            exponent <= conv_std_logic_vector(1967,11);
      WHEN "1010010000" =>
            manhi <= conv_std_logic_vector(5482731,24);
            manlo <= conv_std_logic_vector(5222268,28);
            exponent <= conv_std_logic_vector(1969,11);
      WHEN "1010010001" =>
            manhi <= conv_std_logic_vector(13477188,24);
            manlo <= conv_std_logic_vector(199372940,28);
            exponent <= conv_std_logic_vector(1970,11);
      WHEN "1010010010" =>
            manhi <= conv_std_logic_vector(3782783,24);
            manlo <= conv_std_logic_vector(177367827,28);
            exponent <= conv_std_logic_vector(1972,11);
      WHEN "1010010011" =>
            manhi <= conv_std_logic_vector(11166720,24);
            manlo <= conv_std_logic_vector(197425116,28);
            exponent <= conv_std_logic_vector(1973,11);
      WHEN "1010010100" =>
            manhi <= conv_std_logic_vector(2212657,24);
            manlo <= conv_std_logic_vector(231097832,28);
            exponent <= conv_std_logic_vector(1975,11);
      WHEN "1010010101" =>
            manhi <= conv_std_logic_vector(9032698,24);
            manlo <= conv_std_logic_vector(139698050,28);
            exponent <= conv_std_logic_vector(1976,11);
      WHEN "1010010110" =>
            manhi <= conv_std_logic_vector(762439,24);
            manlo <= conv_std_logic_vector(109718127,28);
            exponent <= conv_std_logic_vector(1978,11);
      WHEN "1010010111" =>
            manhi <= conv_std_logic_vector(7061647,24);
            manlo <= conv_std_logic_vector(77173752,28);
            exponent <= conv_std_logic_vector(1979,11);
      WHEN "1010011000" =>
            manhi <= conv_std_logic_vector(15623158,24);
            manlo <= conv_std_logic_vector(118851961,28);
            exponent <= conv_std_logic_vector(1980,11);
      WHEN "1010011001" =>
            manhi <= conv_std_logic_vector(5241121,24);
            manlo <= conv_std_logic_vector(72680114,28);
            exponent <= conv_std_logic_vector(1982,11);
      WHEN "1010011010" =>
            manhi <= conv_std_logic_vector(13148807,24);
            manlo <= conv_std_logic_vector(12881486,28);
            exponent <= conv_std_logic_vector(1983,11);
      WHEN "1010011011" =>
            manhi <= conv_std_logic_vector(3559625,24);
            manlo <= conv_std_logic_vector(43579850,28);
            exponent <= conv_std_logic_vector(1985,11);
      WHEN "1010011100" =>
            manhi <= conv_std_logic_vector(10863416,24);
            manlo <= conv_std_logic_vector(238889758,28);
            exponent <= conv_std_logic_vector(1986,11);
      WHEN "1010011101" =>
            manhi <= conv_std_logic_vector(2006541,24);
            manlo <= conv_std_logic_vector(141721451,28);
            exponent <= conv_std_logic_vector(1988,11);
      WHEN "1010011110" =>
            manhi <= conv_std_logic_vector(8752557,24);
            manlo <= conv_std_logic_vector(101792997,28);
            exponent <= conv_std_logic_vector(1989,11);
      WHEN "1010011111" =>
            manhi <= conv_std_logic_vector(572063,24);
            manlo <= conv_std_logic_vector(205445723,28);
            exponent <= conv_std_logic_vector(1991,11);
      WHEN "1010100000" =>
            manhi <= conv_std_logic_vector(6802899,24);
            manlo <= conv_std_logic_vector(258099270,28);
            exponent <= conv_std_logic_vector(1992,11);
      WHEN "1010100001" =>
            manhi <= conv_std_logic_vector(15271484,24);
            manlo <= conv_std_logic_vector(98124990,28);
            exponent <= conv_std_logic_vector(1993,11);
      WHEN "1010100010" =>
            manhi <= conv_std_logic_vector(5002133,24);
            manlo <= conv_std_logic_vector(256985826,28);
            exponent <= conv_std_logic_vector(1995,11);
      WHEN "1010100011" =>
            manhi <= conv_std_logic_vector(12823989,24);
            manlo <= conv_std_logic_vector(164377270,28);
            exponent <= conv_std_logic_vector(1996,11);
      WHEN "1010100100" =>
            manhi <= conv_std_logic_vector(3338888,24);
            manlo <= conv_std_logic_vector(222569178,28);
            exponent <= conv_std_logic_vector(1998,11);
      WHEN "1010100101" =>
            manhi <= conv_std_logic_vector(10563405,24);
            manlo <= conv_std_logic_vector(29046646,28);
            exponent <= conv_std_logic_vector(1999,11);
      WHEN "1010100110" =>
            manhi <= conv_std_logic_vector(1802662,24);
            manlo <= conv_std_logic_vector(103161316,28);
            exponent <= conv_std_logic_vector(2001,11);
      WHEN "1010100111" =>
            manhi <= conv_std_logic_vector(8475456,24);
            manlo <= conv_std_logic_vector(239852126,28);
            exponent <= conv_std_logic_vector(2002,11);
      WHEN "1010101000" =>
            manhi <= conv_std_logic_vector(383754,24);
            manlo <= conv_std_logic_vector(123914668,28);
            exponent <= conv_std_logic_vector(2004,11);
      WHEN "1010101001" =>
            manhi <= conv_std_logic_vector(6546961,24);
            manlo <= conv_std_logic_vector(22084044,28);
            exponent <= conv_std_logic_vector(2005,11);
      WHEN "1010101010" =>
            manhi <= conv_std_logic_vector(14923627,24);
            manlo <= conv_std_logic_vector(97508377,28);
            exponent <= conv_std_logic_vector(2006,11);
      WHEN "1010101011" =>
            manhi <= conv_std_logic_vector(4765740,24);
            manlo <= conv_std_logic_vector(165164368,28);
            exponent <= conv_std_logic_vector(2008,11);
      WHEN "1010101100" =>
            manhi <= conv_std_logic_vector(12502697,24);
            manlo <= conv_std_logic_vector(201140216,28);
            exponent <= conv_std_logic_vector(2009,11);
      WHEN "1010101101" =>
            manhi <= conv_std_logic_vector(3120548,24);
            manlo <= conv_std_logic_vector(99561759,28);
            exponent <= conv_std_logic_vector(2011,11);
      WHEN "1010101110" =>
            manhi <= conv_std_logic_vector(10266649,24);
            manlo <= conv_std_logic_vector(176679877,28);
            exponent <= conv_std_logic_vector(2012,11);
      WHEN "1010101111" =>
            manhi <= conv_std_logic_vector(1600996,24);
            manlo <= conv_std_logic_vector(39589446,28);
            exponent <= conv_std_logic_vector(2014,11);
      WHEN "1010110000" =>
            manhi <= conv_std_logic_vector(8201364,24);
            manlo <= conv_std_logic_vector(16114999,28);
            exponent <= conv_std_logic_vector(2015,11);
      WHEN "1010110001" =>
            manhi <= conv_std_logic_vector(197489,24);
            manlo <= conv_std_logic_vector(18649371,28);
            exponent <= conv_std_logic_vector(2017,11);
      WHEN "1010110010" =>
            manhi <= conv_std_logic_vector(6293800,24);
            manlo <= conv_std_logic_vector(44802372,28);
            exponent <= conv_std_logic_vector(2018,11);
      WHEN "1010110011" =>
            manhi <= conv_std_logic_vector(14579546,24);
            manlo <= conv_std_logic_vector(1419236,28);
            exponent <= conv_std_logic_vector(2019,11);
      WHEN "1010110100" =>
            manhi <= conv_std_logic_vector(4531913,24);
            manlo <= conv_std_logic_vector(24044223,28);
            exponent <= conv_std_logic_vector(2021,11);
      WHEN "1010110101" =>
            manhi <= conv_std_logic_vector(12184893,24);
            manlo <= conv_std_logic_vector(51602800,28);
            exponent <= conv_std_logic_vector(2022,11);
      WHEN "1010110110" =>
            manhi <= conv_std_logic_vector(2904577,24);
            manlo <= conv_std_logic_vector(210124577,28);
            exponent <= conv_std_logic_vector(2024,11);
      WHEN "1010110111" =>
            manhi <= conv_std_logic_vector(9973115,24);
            manlo <= conv_std_logic_vector(52505388,28);
            exponent <= conv_std_logic_vector(2025,11);
      WHEN "1010111000" =>
            manhi <= conv_std_logic_vector(1401518,24);
            manlo <= conv_std_logic_vector(214362802,28);
            exponent <= conv_std_logic_vector(2027,11);
      WHEN "1010111001" =>
            manhi <= conv_std_logic_vector(7930246,24);
            manlo <= conv_std_logic_vector(62721516,28);
            exponent <= conv_std_logic_vector(2028,11);
      WHEN "1010111010" =>
            manhi <= conv_std_logic_vector(13245,24);
            manlo <= conv_std_logic_vector(108520727,28);
            exponent <= conv_std_logic_vector(2030,11);
      WHEN "1010111011" =>
            manhi <= conv_std_logic_vector(6043387,24);
            manlo <= conv_std_logic_vector(17001813,28);
            exponent <= conv_std_logic_vector(2031,11);
      WHEN "1010111100" =>
            manhi <= conv_std_logic_vector(14239199,24);
            manlo <= conv_std_logic_vector(83422350,28);
            exponent <= conv_std_logic_vector(2032,11);
      WHEN "1010111101" =>
            manhi <= conv_std_logic_vector(4300623,24);
            manlo <= conv_std_logic_vector(142486326,28);
            exponent <= conv_std_logic_vector(2034,11);
      WHEN "1010111110" =>
            manhi <= conv_std_logic_vector(11870538,24);
            manlo <= conv_std_logic_vector(24126621,28);
            exponent <= conv_std_logic_vector(2035,11);
      WHEN "1010111111" =>
            manhi <= conv_std_logic_vector(2690951,24);
            manlo <= conv_std_logic_vector(91850592,28);
            exponent <= conv_std_logic_vector(2037,11);
      WHEN "1011000000" =>
            manhi <= conv_std_logic_vector(9682766,24);
            manlo <= conv_std_logic_vector(203960059,28);
            exponent <= conv_std_logic_vector(2038,11);
      WHEN "1011000001" =>
            manhi <= conv_std_logic_vector(1204206,24);
            manlo <= conv_std_logic_vector(155513539,28);
            exponent <= conv_std_logic_vector(2040,11);
      WHEN "1011000010" =>
            manhi <= conv_std_logic_vector(7662071,24);
            manlo <= conv_std_logic_vector(33184566,28);
            exponent <= conv_std_logic_vector(2041,11);
      WHEN "1011000011" =>
            manhi <= conv_std_logic_vector(16439219,24);
            manlo <= conv_std_logic_vector(11896414,28);
            exponent <= conv_std_logic_vector(2042,11);
      WHEN "1011000100" =>
            manhi <= conv_std_logic_vector(5795691,24);
            manlo <= conv_std_logic_vector(254151921,28);
            exponent <= conv_std_logic_vector(2044,11);
      WHEN "1011000101" =>
            manhi <= conv_std_logic_vector(13902546,24);
            manlo <= conv_std_logic_vector(199613595,28);
            exponent <= conv_std_logic_vector(2045,11);
      WHEN others =>
           manhi <= conv_std_logic_vector(0,24);
           manlo <= conv_std_logic_vector(0,28);
           exponent <= conv_std_logic_vector(0,11);
    END CASE;
  END PROCESS;

END rtl;

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_EXPNORND.VHD                           ***
--***                                             ***
--***   Function: DP Exponent Output Block -      ***
--***   Simple                                    ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_expnornd IS 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaexp : IN STD_LOGIC_VECTOR (53 DOWNTO 1); -- includes roundbit
      nanin : IN STD_LOGIC;
      rangeerror : IN STD_LOGIC;

		signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      --------------------------------------------------
      nanout : OUT STD_LOGIC;
      overflowout : OUT STD_LOGIC;
      underflowout : OUT STD_LOGIC
		);
END dp_expnornd;

ARCHITECTURE rtl OF dp_expnornd IS

  constant expwidth : positive := 11;
  constant manwidth : positive := 52;
  
  signal nanff : STD_LOGIC;
  signal overflownode, underflownode : STD_LOGIC;
  signal overflowff, underflowff : STD_LOGIC;  
  signal mantissaff : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal exponentff : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  
  signal infinitygen : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal zerogen : STD_LOGIC_VECTOR (expwidth DOWNTO 1);  
  signal setmanzero, setmanmax : STD_LOGIC;
  signal setexpzero, setexpmax : STD_LOGIC;

BEGIN

  pra: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN
        
      nanff <= '0';
      overflowff <= '0';
      underflowff <= '0';
      FOR k IN 1 TO manwidth LOOP
        mantissaff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        exponentff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF(enable = '1') THEN 
      
        nanff <= nanin;
        overflowff <= overflownode;
        underflowff <= underflownode;

        -- nan takes precedence (set max)  
        FOR k IN 1 TO manwidth LOOP
          mantissaff(k) <= (mantissaexp(k+1) AND setmanzero) OR setmanmax;
        END LOOP;
               
        FOR k IN 1 TO expwidth LOOP
          exponentff(k) <= (exponentexp(k) AND setexpzero) OR setexpmax;
        END LOOP;
      
      END IF;
             
    END IF;
      
  END PROCESS;
                                                  
--**********************************
--*** CHECK GENERATED CONDITIONS ***   
--**********************************

  -- infinity if exponent == 255
  infinitygen(1) <= exponentexp(1);
  gia: FOR k IN 2 TO expwidth GENERATE
    infinitygen(k) <= infinitygen(k-1) AND exponentexp(k);
  END GENERATE;
                         
  -- zero if exponent == 0
  zerogen(1) <= exponentexp(1);
  gza: FOR k IN 2 TO expwidth GENERATE
    zerogen(k) <= zerogen(k-1) OR exponentexp(k);
  END GENERATE;
                    
  -- trap any other overflow errors
  -- when sign = 0 and rangeerror = 1, overflow
  -- when sign = 1 and rangeerror = 1, underflow
  overflownode <= NOT(signin) AND rangeerror;
  underflownode <= signin AND rangeerror;
  
  -- set mantissa to 0 when infinity or zero condition
  setmanzero <= NOT(infinitygen(expwidth)) AND zerogen(expwidth) AND NOT(rangeerror);
  -- setmantissa to "11..11" when nan
  setmanmax <= nanin;
  -- set exponent to 0 when zero condition 
  setexpzero <= zerogen(expwidth);
  -- set exponent to "11..11" when nan, infinity, or divide by 0
  setexpmax <= nanin OR infinitygen(expwidth) OR rangeerror;
                             
--***************
--*** OUTPUTS ***
--***************

  signout <= '0';   
  mantissaout <= mantissaff;
  exponentout <= exponentff; 
  -----------------------------------------------
  nanout <= nanff;
  overflowout <= overflowff;
  underflowout <= underflowff;

END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_EXPRND.VHD                             ***
--***                                             ***
--***   Function: DP Exponent Output Block -      ***
--***   Rounded                                   ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_exprnd IS 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaexp : IN STD_LOGIC_VECTOR (53 DOWNTO 1); -- includes roundbit
      nanin : IN STD_LOGIC;
      rangeerror : IN STD_LOGIC;

		signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      --------------------------------------------------
      nanout : OUT STD_LOGIC;
      overflowout : OUT STD_LOGIC;
      underflowout : OUT STD_LOGIC
		);
END dp_exprnd;

ARCHITECTURE rtl OF dp_exprnd IS

  constant expwidth : positive := 11;
  constant manwidth : positive := 52;
  
  type exponentfftype IS ARRAY (2 DOWNTO 1) OF STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  
  signal zerovec : STD_LOGIC_VECTOR (manwidth-1 DOWNTO 1);
  signal nanff : STD_LOGIC_VECTOR (2 DOWNTO 1);
  signal rangeerrorff : STD_LOGIC;
  signal overflownode, underflownode : STD_LOGIC;
  signal overflowff, underflowff : STD_LOGIC_VECTOR (2 DOWNTO 1);
  signal manoverflowbitff : STD_LOGIC; 
  signal roundmantissaff, mantissaff : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal exponentnode : STD_LOGIC_VECTOR (expwidth+2 DOWNTO 1);
  signal exponentoneff : STD_LOGIC_VECTOR (expwidth+2 DOWNTO 1);
  signal exponenttwoff : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
    
  signal manoverflow : STD_LOGIC_VECTOR (manwidth+1 DOWNTO 1);
  signal infinitygen : STD_LOGIC_VECTOR (expwidth+1 DOWNTO 1);
  signal zerogen : STD_LOGIC_VECTOR (expwidth+1 DOWNTO 1);  
  signal setmanzero, setmanmax : STD_LOGIC;
  signal setexpzero, setexpmax : STD_LOGIC;

BEGIN
    
  gzv: FOR k IN 1 TO manwidth-1 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  pra: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN
        
      nanff <= "00";
      rangeerrorff <= '0';
      overflowff <= "00";
      underflowff <= "00";
      manoverflowbitff <= '0';
      FOR k IN 1 TO manwidth LOOP
        roundmantissaff(k) <= '0';
        mantissaff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth+2 LOOP
        exponentoneff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        exponenttwoff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF(enable = '1') THEN 
      
        nanff(1) <= nanin;
        nanff(2) <= nanff(1);
        rangeerrorff <= rangeerror;
        overflowff(1) <= overflownode;
        overflowff(2) <= overflowff(1);
        underflowff(1) <= underflownode;
        underflowff(2) <= underflowff(1);
        
        manoverflowbitff <= manoverflow(manwidth+1);
        
        roundmantissaff <= mantissaexp(manwidth+1 DOWNTO 2) + (zerovec & mantissaexp(1));
        
        -- nan takes precedence (set max)
        -- nan takes precedence (set max)  
        FOR k IN 1 TO manwidth LOOP
          mantissaff(k) <= (roundmantissaff(k) AND setmanzero) OR setmanmax;
        END LOOP;
        
        exponentoneff(expwidth+2 DOWNTO 1) <= "00" & exponentexp;                 
        FOR k IN 1 TO expwidth LOOP
          exponenttwoff(k) <= (exponentnode(k) AND setexpzero) OR setexpmax;
        END LOOP;
      
      END IF;
             
    END IF;
      
  END PROCESS;
  
  exponentnode <= exponentoneff(expwidth+2 DOWNTO 1) + 
                 (zerovec(expwidth+1 DOWNTO 1) & manoverflowbitff);

--*********************************
--*** PREDICT MANTISSA OVERFLOW ***   
--*********************************
     
  manoverflow(1) <= mantissaexp(1);
  gmoa: FOR k IN 2 TO manwidth+1 GENERATE
    manoverflow(k) <= manoverflow(k-1) AND mantissaexp(k);
  END GENERATE; 
                                                                 
--**********************************
--*** CHECK GENERATED CONDITIONS ***   
--**********************************

  -- infinity if exponent == 255
  infinitygen(1) <= exponentnode(1);
  gia: FOR k IN 2 TO expwidth GENERATE
    infinitygen(k) <= infinitygen(k-1) AND exponentnode(k);
  END GENERATE;
  infinitygen(expwidth+1) <= infinitygen(expwidth) OR 
                            (exponentnode(expwidth+1) AND 
                             NOT(exponentnode(expwidth+2))); -- '1' if infinity
                                                    
  -- zero if exponent == 0
  zerogen(1) <= exponentnode(1);
  gza: FOR k IN 2 TO expwidth GENERATE
    zerogen(k) <= zerogen(k-1) OR exponentnode(k);
  END GENERATE;
  zerogen(expwidth+1) <= zerogen(expwidth) AND 
                         NOT(exponentnode(expwidth+2)); -- '0' if zero
                                           
  -- trap any other overflow errors
  -- when sign = 0 and rangeerror = 1, overflow
  -- when sign = 1 and rangeerror = 1, underflow
  overflownode <= NOT(signin) AND rangeerror;
  underflownode <= signin AND rangeerror;
  
  -- set mantissa to 0 when infinity or zero condition
  setmanzero <= NOT(infinitygen(expwidth+1)) AND zerogen(expwidth+1) AND NOT(rangeerrorff);
  -- setmantissa to "11..11" when nan
  setmanmax <= nanff(1);
  -- set exponent to 0 when zero condition 
  setexpzero <= zerogen(expwidth+1);
  -- set exponent to "11..11" when nan, infinity, or divide by 0
  setexpmax <= nanff(1) OR infinitygen(expwidth+1) OR rangeerrorff;
                             
--***************
--*** OUTPUTS ***
--***************
  
  signout <= '0';   
  mantissaout <= mantissaff;
  exponentout <= exponenttwoff; 
  -----------------------------------------------
  nanout <= nanff(2);
  overflowout <= overflowff(2);
  underflowout <= underflowff(2);

END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_EXPRNDPIPE.VHD                         ***
--***                                             ***
--***   Function: DP Exponent Output Block -      ***
--***   Rounded, Pipelined Add                    ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_exprndpipe IS 
GENERIC (synthesize : integer := 1); 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaexp : IN STD_LOGIC_VECTOR (53 DOWNTO 1); -- includes roundbit
      nanin : IN STD_LOGIC;
      rangeerror : IN STD_LOGIC;

		signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      --------------------------------------------------
      nanout : OUT STD_LOGIC;
      overflowout : OUT STD_LOGIC;
      underflowout : OUT STD_LOGIC
		);
END dp_exprndpipe;

ARCHITECTURE rtl OF dp_exprndpipe IS

  constant expwidth : positive := 11;
  constant manwidth : positive := 52;
  
  type exponentfftype IS ARRAY (3 DOWNTO 1) OF STD_LOGIC_VECTOR (expwidth+2 DOWNTO 1);
  
  signal zerovec : STD_LOGIC_VECTOR (manwidth+1 DOWNTO 1);
  signal nanff : STD_LOGIC_VECTOR (3 DOWNTO 1);
  signal rangeerrorff : STD_LOGIC_VECTOR (2 DOWNTO 1);
  signal overflownode, underflownode : STD_LOGIC; 
  signal overflowff, underflowff : STD_LOGIC_VECTOR (3 DOWNTO 1);  
  signal roundmantissanode : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal mantissaff : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal exponentff : exponentfftype;
       
  signal manoverflow : STD_LOGIC_VECTOR (manwidth+1 DOWNTO 1);
  signal manoverflowff : STD_LOGIC;
  signal infinitygen : STD_LOGIC_VECTOR (expwidth+1 DOWNTO 1);
  signal zerogen : STD_LOGIC_VECTOR (expwidth+1 DOWNTO 1);  
  signal setmanzero, setmanmax : STD_LOGIC;
  signal setexpzero, setexpmax : STD_LOGIC;

  component dp_fxadd 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1;
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
BEGIN
    
  gzv: FOR k IN 1 TO manwidth+1 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  pra: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN

      nanff <= "000";
      rangeerrorff <= "00";
      overflowff <= "000";
      underflowff <= "000";
      manoverflowff <= '0';
      FOR k IN 1 TO manwidth LOOP
        mantissaff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        exponentff(1)(k) <= '0';
        exponentff(2)(k) <= '0';
        exponentff(3)(k) <= '0';
      END LOOP;
        
    ELSIF (rising_edge(sysclk)) THEN
    
      IF(enable = '1') THEN 
      
        nanff(1) <= nanin;
        nanff(2) <= nanff(1);
        nanff(3) <= nanff(2);
        rangeerrorff(1) <= rangeerror;
        rangeerrorff(2) <= rangeerrorff(1);
        overflowff(1) <= overflownode;
        overflowff(2) <= overflowff(1);
        overflowff(3) <= overflowff(2);
        underflowff(1) <= underflownode;
        underflowff(2) <= underflowff(1);
        underflowff(3) <= underflowff(2);
        
        manoverflowff <= manoverflow(53);
        
        -- nan takes precedence (set max)
        -- nan takes precedence (set max)  
        FOR k IN 1 TO manwidth LOOP
          mantissaff(k) <= (roundmantissanode(k) AND setmanzero) OR setmanmax;
        END LOOP;
        
        exponentff(1)(expwidth+2 DOWNTO 1) <= "00" & exponentexp(expwidth DOWNTO 1);
        exponentff(2)(expwidth+2 DOWNTO 1) <= (exponentff(1)(expwidth+2 DOWNTO 1)) + 
                                              (zerovec(expwidth+1 DOWNTO 1) & manoverflowff);                 
        FOR k IN 1 TO expwidth LOOP
          exponentff(3)(k) <= (exponentff(2)(k) AND setexpzero) OR setexpmax;
        END LOOP;
      
      END IF;
             
    END IF;
      
  END PROCESS;
       
  rndadd: dp_fxadd 
  GENERIC MAP(width=>manwidth,pipes=>2,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>mantissaexp(manwidth+1 DOWNTO 2),bb=>zerovec(manwidth DOWNTO 1),
            carryin=>mantissaexp(1),
            cc=>roundmantissanode);

--*********************************
--*** PREDICT MANTISSA OVERFLOW ***   
--*********************************
     
  manoverflow(1) <= mantissaexp(1);
  gmoa: FOR k IN 2 TO 53 GENERATE
    manoverflow(k) <= manoverflow(k-1) AND mantissaexp(k);
  END GENERATE;                                           
    
--**********************************
--*** CHECK GENERATED CONDITIONS ***   
--**********************************

  -- infinity if exponent >= 255
  infinitygen(1) <= exponentff(2)(1);
  gia: FOR k IN 2 TO expwidth GENERATE
    infinitygen(k) <= infinitygen(k-1) AND exponentff(2)(k);
  END GENERATE;
  infinitygen(expwidth+1) <= infinitygen(expwidth) OR 
                            (exponentff(2)(expwidth+1) AND 
                             NOT(exponentff(2)(expwidth+2))); -- ;1' if infinity
                         
  -- zero if exponent <= 0
  zerogen(1) <= exponentff(2)(1);
  gza: FOR k IN 2 TO expwidth GENERATE
    zerogen(k) <= zerogen(k-1) OR exponentff(2)(k);
  END GENERATE;
  zerogen(expwidth+1) <= zerogen(expwidth) AND 
                         NOT(exponentff(2)(expwidth+2)); -- '0' if zero
  
    -- trap any other overflow errors
  -- when sign = 0 and rangeerror = 1, overflow
  -- when sign = 1 and rangeerror = 1, underflow
  overflownode <= NOT(signin) AND rangeerror;
  underflownode <= signin AND rangeerror;
                    
  -- set mantissa to 0 when infinity or zero condition
  setmanzero <= NOT(infinitygen(expwidth+1)) AND zerogen(expwidth+1) AND NOT(rangeerrorff(2));
  -- setmantissa to "11..11" when nan
  setmanmax <= nanff(2);
  -- set exponent to 0 when zero condition 
  setexpzero <= zerogen(expwidth+1);
  -- set exponent to "11..11" when nan, infinity, or divide by 0
  setexpmax <= nanff(2) OR infinitygen(expwidth+1) OR rangeerrorff(2);
                             
--***************
--*** OUTPUTS ***
--***************

  signout <= '0';   
  mantissaout <= mantissaff;
  exponentout <= exponentff(3)(expwidth DOWNTO 1); 
  -----------------------------------------------
  nanout <= nanff(3);
  overflowout <= overflowff(3);
  underflowout <= underflowff(3);
  
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   ALTERA FLOATING POINT DATAPATH COMPILER   ***
--***                                             ***
--***   DP_FABS.VHD                               ***
--***                                             ***
--***   Function: Single Precision Absolute Value ***
--***                                             ***
--***   abs(x)                                    ***
--***                                             ***
--***   Created 12/09/09                          ***
--***                                             ***
--***   (c) 2009 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_fabs IS 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentin : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissain : IN STD_LOGIC_VECTOR (52 DOWNTO 1);

		  signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
		  satout, zeroout, nanout : OUT STD_LOGIC
		);
END dp_fabs;

ARCHITECTURE rtl OF dp_fabs IS
 
  signal signff : STD_LOGIC;
  signal exponentff : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal mantissaff : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal expnode : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal expzerochk, expmaxchk : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal expzero, expmax : STD_LOGIC;
  signal manzerochk : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal manzero, mannonzero : STD_LOGIC; 

BEGIN
    
  pin: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
    
      signff <= '0';
      FOR k IN 1 TO 11 LOOP
        exponentff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 52 LOOP
        mantissaff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF (enable = '1') THEN
          
        signff <= '0';
        exponentff <= exponentin;
        mantissaff <= mantissain;
        
      END IF;
    
    END IF;  
      
  END PROCESS;

  expzerochk(1) <= exponentff(1);
  expmaxchk(1) <= exponentff(1);
  gxa: FOR k IN 2 TO 11 GENERATE
    expzerochk(k) <= expzerochk(k-1) OR exponentff(k);
    expmaxchk(k) <= expmaxchk(k-1) AND exponentff(k);
  END GENERATE;
  expzero <= NOT(expzerochk(11));
  expmax <= expmaxchk(11);
  
  manzerochk(1) <= mantissaff(1);
  gma: FOR k IN 2 TO 52 GENERATE
    manzerochk(k) <= manzerochk(k-1) OR mantissaff(k);
  END GENERATE;
  manzero <= NOT(manzerochk(52));
  mannonzero <= manzerochk(52);
  
  signout <= signff;
  exponentout <= exponentff;
  mantissaout <= mantissaff;
  satout <= expmax AND manzero;
  zeroout <= expzero;
  nanout <= expmax AND mannonzero;

END rtl;


LIBRARY ieee;
LIBRARY work;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CONVERSION - TOP LEVEL     ***
--***                                             ***
--***   DP_FIXFLOAT.VHD                           ***
--***                                             ***
--***   Function: Convert Fixed Point to Floating ***
--***   Point Number                              ***
--***                                             ***
--***   01/12/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** LATENCY : unsigned = 3 + 3*speed            ***
--*** LATENCY : signed = 4 + 4*speed              ***
--***************************************************

ENTITY dp_fixfloat IS
GENERIC (
         unsigned : integer := 0; -- unsigned = 0, signed = 1
         decimal : integer := 18;
         fractional : integer := 14;
         precision : integer := 0; -- single = 0, double = 1
         speed : integer := 0 -- low speed = 0, high speed = 1 
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      fixed_number : IN STD_LOGIC_VECTOR (decimal+fractional DOWNTO 1);
      
      sign : OUT STD_LOGIC;
      exponent : OUT STD_LOGIC_VECTOR (8+3*precision DOWNTO 1);
      mantissa : OUT STD_LOGIC_VECTOR (23+29*precision DOWNTO 1)    
     );
END dp_fixfloat;

ARCHITECTURE rtl of dp_fixfloat IS

  constant fixed_width : positive := decimal + fractional;
  -- unsigned has 1 bit less (due to leading 1), signed has 2 less (leading 1 and sign)
  constant fixed_precision : positive := fixed_width - unsigned - 1;
  constant mantissa_width : positive := 23 + 29*precision;
  constant exponent_width : positive := 8 + 3*precision;
  constant exponent_base_number : positive := 126+896*precision+decimal;
   
  -- input stage
  signal zerovec : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentbase : STD_LOGIC_VECTOR (exponent_width DOWNTO 1);
  signal invfixed : STD_LOGIC_VECTOR (fixed_width DOWNTO 1);
  signal absnode, delabsnode : STD_LOGIC_VECTOR (fixed_width DOWNTO 1);
  -- detect range stage
  signal clzinbus : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal count, delcount : STD_LOGIC_VECTOR (6 DOWNTO 1);
  signal zerochk, delzerochk : STD_LOGIC;
  signal exponentnode, delexponentnode : STD_LOGIC_VECTOR (exponent_width DOWNTO 1);
  -- normalize stage
  signal shiftinbus : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal shiftnode : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal delshift : STD_LOGIC_VECTOR (fixed_width DOWNTO 1);
  signal shiftvalue : STD_LOGIC_VECTOR (64 DOWNTO 1);
  -- output stage
  signal mantissaroundbit : STD_LOGIC;
  signal exponentoutnode : STD_LOGIC_VECTOR (exponent_width DOWNTO 1);
  signal exponentroundnode : STD_LOGIC_VECTOR (exponent_width DOWNTO 1);
    
  component dp_addpipe IS
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
  component dp_clz64 IS
  PORT (
        mantissa : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        
        leading : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
       );
  end component;
  
  component dp_clzpipe64 IS
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        mantissa : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        
        leading : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
       );
  end component;
 
  component dp_lsft64 IS
  PORT (
        inbus : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (6 DOWNTO 1);      
        
        outbus : OUT STD_LOGIC_VECTOR (64 DOWNTO 1)    
       );
  end component;
  
  component dp_lsftpipe64 IS
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        inbus : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (6 DOWNTO 1);      
        
        outbus : OUT STD_LOGIC_VECTOR (64 DOWNTO 1)    
       );
  end component;
  
  component fp_del IS 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
 end component;

  component fp_delbit IS 
  GENERIC (
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC; 
      
        cc : OUT STD_LOGIC
       );
 end component;
     
BEGIN
    
  gera : IF NOT((precision = 0) OR 
	             (precision = 1)) GENERATE
	 assert false report "precision must be 0 (single precision) or 1 (double precision)" severity error;
  END GENERATE;
  
  gerb : IF NOT((speed = 0) OR 
	             (speed = 1)) GENERATE
	 assert false report "speed must be 0 or 1" severity error;
  END GENERATE;
  
  gerc : IF NOT((unsigned = 0) OR 
	             (unsigned = 1)) GENERATE
	 assert false report "unsigned must be 0 or 1" severity error;
  END GENERATE;

  gerd : IF (decimal < 1) GENERATE
	 assert false report "decimal must be greater than 1" severity error;
  END GENERATE;
  
  gere : IF (fixed_width > 64) GENERATE
	 assert false report "maximum fixed point precision must be 64 or less" severity error;
  END GENERATE; 
  
  gza: FOR k IN 1 TO 64 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  exponentbase <= conv_std_logic_vector (exponent_base_number,exponent_width);
  
  --*** LEVEL 0 - 2 (ABSNODE) ***
  -- level 0 if unsigned = 0, 
  -- level 1 if signed = 1 & speed = 0, 
  -- level 2 if signed = 1 & speed = 1 
  gabsa: IF (unsigned = 1) GENERATE  
    giva: FOR k IN 1 TO fixed_width GENERATE
      invfixed(k) <= fixed_number(k) XOR fixed_number(fixed_width);
    END GENERATE;
    aabs: dp_addpipe
    GENERIC MAP (width=>fixed_width,pipes=>speed+1)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>invfixed,bb=>zerovec(fixed_width DOWNTO 1),carryin=>fixed_number(fixed_width),
              cc=>absnode);
  END GENERATE;
   
  gabsb: IF (unsigned = 0) GENERATE  
    invfixed <= fixed_number;
    absnode <= invfixed;
  END GENERATE;   
  
  gczc: IF (fixed_width < 64) GENERATE
    clzinbus <= absnode & zerovec(64-fixed_width DOWNTO 1);
  END GENERATE;
  gczd: IF (fixed_width = 64) GENERATE
    clzinbus <= absnode;
  END GENERATE;
  
  --*** LEVEL 1-4 (ABSDELNODE, COUNTFF) ***
  -- level 1 if unsigned = 0 & speed = 0,
  -- level 2 if unsigned = 0 & speed = 1, 
  -- level 2 if signed = 1 & speed = 0, 
  -- level 4 if signed = 1 & speed = 1 
  
  gcca: IF (speed = 0) GENERATE
    cntzip: dp_clz64
    PORT MAP (mantissa=>clzinbus,leading=>count);
  END GENERATE;
  gccb: IF (speed = 1) GENERATE
    cntone: dp_clzpipe64
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              mantissa=>clzinbus,leading=>count);
  END GENERATE;
  
  delabsbus: fp_del
  GENERIC MAP (width=>fixed_width,pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>absnode,cc=>delabsnode);
  
  ddc: fp_del
  GENERIC MAP (width=>6,pipes=>1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>count,cc=>delcount);
  
  -- check for 0 input - when countff = 0 and absdelnode(64) (unsigned) or 
  -- absdelnode(63) (signed) not '1'
  zerochk <= NOT(delcount(6) OR delcount(5) OR delcount(4) OR delcount(3) OR
                 delcount(2) OR delcount(1) OR delabsnode(fixed_width) OR delabsnode(fixed_width-1));
                 
  delzc: fp_delbit
  GENERIC MAP (pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>zerochk,cc=>delzerochk);
            
  exponentnode <= exponentbase - (zerovec(2+3*precision DOWNTO 1) & delcount);  
  
  delx: fp_del
  GENERIC MAP (width=>exponent_width,pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>exponentnode,cc=>delexponentnode);
            
  --*** LEVEL 2-6 (SHIFTFF) ***
  -- level 2 if unsigned = 0 & speed = 0,
  -- level 3 if unsigned = 0 & speed = 1, 
  -- level 3 if signed = 1 & speed = 0, 
  -- level 6 if signed = 1 & speed = 1 

  gfsc: IF (fixed_width < 64) GENERATE
    shiftinbus <= delabsnode & zerovec(64-fixed_width DOWNTO 1);
  END GENERATE;
  gfsd: IF (fixed_width = 64) GENERATE
    shiftinbus <= delabsnode;
  END GENERATE;

  gssa: IF (speed = 0) GENERATE
    sftzip: dp_lsft64
    PORT MAP (inbus=>shiftinbus,shift=>delcount,
              outbus=>shiftnode);
  END GENERATE;
  gssb: IF (speed = 1) GENERATE
    sftone: dp_lsftpipe64
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              inbus=>shiftinbus,shift=>delcount,
              outbus=>shiftnode);
  END GENERATE;
  
  dels: fp_del
  GENERIC MAP (width=>fixed_width,pipes=>1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>shiftnode(64 DOWNTO 65-fixed_width),cc=>delshift);

  gsoa: IF (fixed_width = 64) GENERATE
    shiftvalue <= delshift;
  END GENERATE;
  gsob: IF (fixed_width < 64) GENERATE
    shiftvalue <= delshift & zerovec(64-fixed_width DOWNTO 1);
  END GENERATE;
   
  --*** LEVEL 3-8 (OUTPUT) ***
  -- level 3 if unsigned = 0 & speed = 0,
  -- level 5 if unsigned = 0 & speed = 1, 
  -- level 4 if signed = 1 & speed = 0, 
  -- level 8 if signed = 1 & speed = 1 

  -- single precision
  goa: IF (fixed_precision <= 23 AND mantissa_width = 23) GENERATE
    mantissaroundbit <= '0';
    exponentroundnode <= delexponentnode;
    goax: FOR k IN 1 TO 8 GENERATE
      exponentoutnode(k) <= exponentroundnode(k) AND NOT(delzerochk);
    END GENERATE;
  END GENERATE;
  
  gob: IF (fixed_precision > 23 AND mantissa_width = 23) GENERATE
    mantissaroundbit <= ( shiftvalue(41) AND shiftvalue(40) ) OR
                        (NOT(shiftvalue(41)) AND shiftvalue(40) AND
                         (shiftvalue(39) OR shiftvalue(38) OR shiftvalue(37) OR shiftvalue(36) OR 
                          shiftvalue(35) OR shiftvalue(34) OR shiftvalue(33) OR shiftvalue(32) OR 
                          shiftvalue(31) OR shiftvalue(30) OR shiftvalue(29) OR shiftvalue(28)));
    -- check for mantissa overflow here
    exponentroundnode <= delexponentnode;
    gobx: FOR k IN 1 TO 8 GENERATE
      exponentoutnode(k) <= exponentroundnode(k) AND NOT(delzerochk);
    END GENERATE;
  END GENERATE;
  
  -- double precision
  goc: IF (fixed_precision <= 52 AND mantissa_width = 52) GENERATE
    mantissaroundbit <= '0';
    exponentroundnode <= delexponentnode;
    gocx: FOR k IN 1 TO 11 GENERATE
      exponentoutnode(k) <= exponentroundnode(k) AND NOT(delzerochk);
    END GENERATE;
  END GENERATE;
  
  god: IF (fixed_width > 52 AND mantissa_width = 52) GENERATE
    mantissaroundbit <= (shiftvalue(12) AND shiftvalue(11)) OR
                        (NOT(shiftvalue(12)) AND shiftvalue(11) AND
                         (shiftvalue(10) OR shiftvalue(9) OR shiftvalue(8) OR shiftvalue(7) OR 
                          shiftvalue(6) OR shiftvalue(5) OR shiftvalue(4) OR shiftvalue(3) OR 
                          shiftvalue(2) OR shiftvalue(1)));
    -- check for mantissa overflow here
    exponentroundnode <= delexponentnode;
    godx: FOR k IN 1 TO 11 GENERATE
      exponentoutnode(k) <= exponentroundnode(k) AND NOT(delzerochk);
    END GENERATE;
  END GENERATE;
  
  gsgna: IF (unsigned = 0) GENERATE
    sign <= '0';
  END GENERATE;
  gsgnb: IF (unsigned = 1) GENERATE
    delss: fp_delbit
    GENERIC MAP (pipes=>4+4*speed)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>fixed_number(decimal+fractional),cc=>sign);  
  END GENERATE;
  
  mno: dp_addpipe
  GENERIC MAP (width=>mantissa_width,pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>shiftvalue(63 DOWNTO 64-mantissa_width),
            bb=>zerovec(mantissa_width DOWNTO 1),
            carryin=>mantissaroundbit,
            cc=>mantissa);
            
  exo: dp_addpipe
  GENERIC MAP (width=>exponent_width,pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>exponentoutnode,
            bb=>zerovec(exponent_width DOWNTO 1),
            --carryin=>mantissaoverflowbit,
            carryin=>'0',
            cc=>exponent);
                
END rtl;


LIBRARY ieee;
LIBRARY work;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CONVERSION - TOP LEVEL     ***
--***                                             ***
--***   DP_FLOATFIX.VHD                           ***
--***                                             ***
--***   Function: Convert Floating Point to Fixed ***
--***   Point Number                              ***
--***                                             ***
--***   07/12/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** LATENCY :                                   ***
--***           speed = 0 : 3                     ***
--***           speed = 1 : 5                     ***
--***************************************************

--***************************************************
--*** OUTPUT FORMAT - UNSIGNED                    ***
--*** maximum number is (2^decimal)-1, else       ***
--*** saturate. if input negative, zero output    ***
--*** OUTPUT FORMAT - SIGNED                      ***
--*** maximum number is (2^decimal-1)-1, else     ***
--*** saturate                                    ***
--***************************************************

ENTITY dp_floatfix IS
GENERIC (
         unsigned : integer := 1;  -- unsigned = 0, signed = 1
         decimal : integer := 14;
         fractional : integer := 6;
         precision : integer := 0; -- single = 0, double = 1
         speed : integer := 0 -- low speed = 0, high speed = 1
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      sign : IN STD_LOGIC;
      exponent : IN STD_LOGIC_VECTOR (8+3*precision DOWNTO 1);
      mantissa : IN STD_LOGIC_VECTOR (23+29*precision DOWNTO 1);
      
      fixed_number : OUT STD_LOGIC_VECTOR (decimal+fractional DOWNTO 1)
     );
END dp_floatfix;

ARCHITECTURE rtl of dp_floatfix IS

  constant fixed_width : positive := decimal + fractional;
  constant mantissa_width : positive := 23 + 29*precision;
  constant exponent_width : positive := 8 + 3*precision;
  constant exponent_base_number : positive := 127+896*precision;
  
  -- input stage
  signal zerovec : STD_LOGIC_VECTOR (116 DOWNTO 1);
  signal exponent_base_node : STD_LOGIC_VECTOR (exponent_width+1 DOWNTO 1);
  signal saturate_check : STD_LOGIC_VECTOR (exponent_width+1 DOWNTO 1);
  signal saturate_output, zero_output : STD_LOGIC;
  signal saturate_apply, zero_apply : STD_LOGIC;
  signal sign_apply : STD_LOGIC;
  signal signed_mantissa_node : STD_LOGIC_VECTOR (mantissa_width+2 DOWNTO 1);
  signal signed_mantissa_comp : STD_LOGIC_VECTOR (mantissa_width+2 DOWNTO 1);
  signal signed_mantissa : STD_LOGIC_VECTOR (mantissa_width+2 DOWNTO 1);
  signal input_vector : STD_LOGIC_VECTOR (116 DOWNTO 1);
  signal negexponent : STD_LOGIC_VECTOR (exponent_width DOWNTO 1);
  signal expbase, negexpbase : STD_LOGIC_VECTOR (exponent_width DOWNTO 1);
  signal leftshift, rightshift : STD_LOGIC_VECTOR (exponent_width DOWNTO 1);
  -- shift stage
  signal leftbus, rightbus : STD_LOGIC_VECTOR (116 DOWNTO 1);
  signal shiftbus, shiftbusff : STD_LOGIC_VECTOR (fixed_width DOWNTO 1);
  signal select_bit : STD_LOGIC;
  -- output stage
  signal fixed_numberff : STD_LOGIC_VECTOR (fixed_width DOWNTO 1);
    
  component dp_addpipe IS
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
   
  component dp_lsft64x64 IS
  PORT (
        inbus : IN STD_LOGIC_VECTOR (116 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (6 DOWNTO 1);      
        
        outbus : OUT STD_LOGIC_VECTOR (116 DOWNTO 1)    
       );
  end component;
  
  component dp_lsftpipe64x64 IS
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        inbus : IN STD_LOGIC_VECTOR (116 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (6 DOWNTO 1);      
        
        outbus : OUT STD_LOGIC_VECTOR (116 DOWNTO 1)    
       );
  end component;
  
  component dp_rsft64x64 IS
  PORT (
        inbus : IN STD_LOGIC_VECTOR (116 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (6 DOWNTO 1);      
        
        outbus : OUT STD_LOGIC_VECTOR (116 DOWNTO 1)    
       );
  end component;
  
  component dp_rsftpipe64x64 IS
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        inbus : IN STD_LOGIC_VECTOR (116 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (6 DOWNTO 1);      
        
        outbus : OUT STD_LOGIC_VECTOR (116 DOWNTO 1)    
       );
  end component;
  
  component fp_delbit IS 
  GENERIC (
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC; 
      
        cc : OUT STD_LOGIC
       );
 end component;
  
BEGIN
  
  gera : IF NOT((unsigned = 0) OR 
	             (unsigned = 1)) GENERATE
	 assert false report "unsigned must be 0 or 1" severity error;
  END GENERATE;
    
  gerb : IF NOT((precision = 0) OR 
	             (precision = 1)) GENERATE
	 assert false report "precision must be 0 (single precision) or 1 (double precision)" severity error;
  END GENERATE;
  
  gerc : IF NOT((speed = 0) OR 
	             (speed = 1)) GENERATE
	 assert false report "speed must be 0 or 1" severity error;
  END GENERATE;
 
  gerd : IF (decimal < 2) GENERATE
	 assert false report "decimal must be greater than 2" severity error;
  END GENERATE;
  
  gere : IF (fixed_width > 64) GENERATE
	 assert false report "maximum fixed point precision must be 64 or less" severity error;
  END GENERATE; 

  gza: FOR k IN 1 TO 116 GENERATE
    zerovec(k) <= '0';
  END GENERATE;

  --*** LEVEL 1-2 ***
  -- level 1 if speed = 0
  -- level 2 if speed = 1
  
  -- check for zero and saturate conditions
  exponent_base_node <= conv_std_logic_vector(exponent_base_number,exponent_width+1);
  
  gzsa: IF (unsigned = 0) GENERATE
    saturate_check <= exponent - exponent_base_node - decimal;
    -- '1' when condition true
    saturate_output <= NOT(saturate_check(exponent_width+1));
    zero_output <= sign;
  END GENERATE;
  
  gzsb: IF (unsigned = 1) GENERATE
    saturate_check <= exponent - exponent_base_node - decimal + 1;
    -- '1' when condition true
    saturate_output <= NOT(saturate_check(exponent_width+1));
    zero_output <= '0';
    
    dss: fp_delbit
    GENERIC MAP (pipes=>2+2*speed)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>sign,
              cc=>sign_apply);
              
  END GENERATE;
  
  ds: fp_delbit
  GENERIC MAP (pipes=>2+2*speed)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>saturate_output,
              cc=>saturate_apply);
              
  dz: fp_delbit
  GENERIC MAP (pipes=>2+2*speed)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>zero_output,
              cc=>zero_apply);
               
  signed_mantissa_node <= "01" & mantissa;
  gsma: FOR k IN 1 TO mantissa_width+2 GENERATE
    signed_mantissa_comp(k) <= signed_mantissa_node(k) XOR sign;
  END GENERATE;
  
  addtop: dp_addpipe
  GENERIC MAP (width=>mantissa_width+2,pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>signed_mantissa_comp,bb=>zerovec(mantissa_width+2 DOWNTO 1),
            carryin=>sign,
            cc=>signed_mantissa);
  
  giva: FOR k IN 116-decimal+3 TO 116 GENERATE
    input_vector(k) <= signed_mantissa(mantissa_width+2);
  END GENERATE;
  input_vector(116-decimal+2 DOWNTO 116-decimal-mantissa_width+1) <= signed_mantissa;
  givb: IF (116-decimal-mantissa_width+1 > 1) GENERATE
    input_vector(116-decimal-mantissa_width DOWNTO 1) <= zerovec(116-decimal-mantissa_width DOWNTO 1);
  END GENERATE;
  
  gcxa: FOR k IN 1 TO exponent_width GENERATE
    negexponent(k) <= NOT(exponent(k));
  END GENERATE;
  gcxb: FOR k IN 1 TO exponent_width-1 GENERATE
    expbase(k) <= '1';
    negexpbase(k) <= '0';
  END GENERATE;
  expbase(exponent_width) <= '0';
  negexpbase(exponent_width) <= '1';
  
  sublx: dp_addpipe
  GENERIC MAP (width=>exponent_width,pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>exponent,bb=>negexpbase,
            carryin=>'1',
            cc=>leftshift);
            
  subrx: dp_addpipe
  GENERIC MAP (width=>exponent_width,pipes=>speed+1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>negexponent,bb=>expbase,
            carryin=>'1',
            cc=>rightshift);

  --*** LEVEL 2-4 (shiftbusff) ***
  -- level 2 if speed = 0
  -- level 4 if speed = 1
  
  gsfa: IF (speed = 0) GENERATE
    clsc: dp_lsft64x64
    PORT MAP (inbus=>input_vector,shift=>leftshift(6 DOWNTO 1),
              outbus=>leftbus);
            
    crsc: dp_rsft64x64
    PORT MAP (inbus=>input_vector,shift=>rightshift(6 DOWNTO 1),
              outbus=>rightbus);
              
    select_bit <= leftshift(exponent_width);
  END GENERATE;
  
  gsfb: IF (speed = 1) GENERATE
    clsp: dp_lsftpipe64x64
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              inbus=>input_vector,shift=>leftshift(6 DOWNTO 1),
              outbus=>leftbus);
            
    crsp: dp_rsftpipe64x64
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              inbus=>input_vector,shift=>rightshift(6 DOWNTO 1),
              outbus=>rightbus);
              
    db: fp_delbit
    GENERIC MAP (pipes=>1)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>leftshift(exponent_width),
              cc=>select_bit);
  END GENERATE;
    
  gsba: FOR k IN 1 TO fixed_width GENERATE
    shiftbus(k) <= (leftbus(116-fixed_width+k) AND NOT(select_bit)) OR
                   (rightbus(116-fixed_width+k) AND select_bit);
  END GENERATE;
  
  psa: PROCESS (sysclk,reset)
  BEGIN
    IF (reset = '1') THEN
      FOR k IN 1 TO fixed_width LOOP
        shiftbusff(k) <= '0';
      END LOOP; 
    ELSIF (rising_edge(sysclk)) THEN
      IF (enable = '1') THEN
        shiftbusff <= shiftbus;
      END IF;
    END IF;
  END PROCESS;
  
  --*** LEVEL 3-5 ***
  -- level 3 if speed = 0
  -- level 5 if speed = 1

  gou: IF (unsigned = 0) GENERATE
    poa: PROCESS (sysclk,reset)
    BEGIN
      IF (reset = '1') THEN
        FOR k IN 1 TO fixed_width LOOP
          fixed_numberff(k) <= '0';
        END LOOP; 
      ELSIF (rising_edge(sysclk)) THEN
        IF (enable = '1') THEN
          FOR k IN 1 TO fixed_width LOOP    
            fixed_numberff(k) <= (shiftbusff(k) AND NOT(zero_apply)) OR saturate_apply;
          END LOOP;
        END IF;
      END IF;
    END PROCESS;
  END GENERATE;

  gos: IF (unsigned = 1) GENERATE
    pos: PROCESS (sysclk,reset)
    BEGIN
      IF (reset = '1') THEN
        FOR k IN 1 TO fixed_width LOOP
          fixed_numberff(k) <= '0';
        END LOOP; 
      ELSIF (rising_edge(sysclk)) THEN
        IF (enable = '1') THEN
          FOR k IN 1 TO fixed_width-1 LOOP    
            fixed_numberff(k) <= (shiftbusff(k) AND NOT(zero_apply) AND 
                                  NOT(saturate_apply AND sign_apply)) OR
                                 (saturate_apply AND NOT(sign_apply));
          END LOOP;
          fixed_numberff(fixed_width) <= (shiftbusff(fixed_width) AND NOT(zero_apply) AND 
                                          NOT(saturate_apply AND NOT(sign_apply))) OR
                                         (saturate_apply AND sign_apply);
        END IF;
      END IF;
    END PROCESS;
  END GENERATE;
    
  fixed_number <= fixed_numberff;
  
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   FP_FXADD.VHD                              ***
--***                                             ***
--***   Function: Generic Fixed Point Adder       ***
--***                                             ***
--***   31/01/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_fxadd IS 
GENERIC (
         width : positive := 64;
         pipes : positive := 1;
         synthesize : integer := 0
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      carryin : IN STD_LOGIC;
      
      cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
     );
END dp_fxadd;

ARCHITECTURE rtl OF dp_fxadd IS

  component dp_addb IS
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
  component dp_adds IS
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
   
BEGIN
  
  gaa: IF (synthesize = 0) GENERATE
    addone: dp_addb
    GENERIC MAP (width=>width,pipes=>pipes)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>aa,bb=>bb,carryin=>carryin,
              cc=>cc);
  END GENERATE;
  
  gab: IF (synthesize = 1) GENERATE
    addtwo: dp_adds
    GENERIC MAP (width=>width,pipes=>pipes)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>aa,bb=>bb,carryin=>carryin,
              cc=>cc);
  END GENERATE;
       
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   FP_FXSUB.VHD                              ***
--***                                             ***
--***   Function: Generic Fixed Point Subtractor  ***
--***                                             ***
--***   31/01/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_fxsub IS 
GENERIC (
         width : positive := 64;
         pipes : positive := 1;
         synthesize : integer := 0
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      borrowin : IN STD_LOGIC;
      
      cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
     );
END dp_fxsub;

ARCHITECTURE rtl OF dp_fxsub IS

  component dp_subb IS
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        borrowin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
  component dp_subs IS
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        borrowin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
   
BEGIN
  
  gaa: IF (synthesize = 0) GENERATE
    addone: dp_subb
    GENERIC MAP (width=>width,pipes=>pipes)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>aa,bb=>bb,borrowin=>borrowin,
              cc=>cc);
  END GENERATE;
  
  gab: IF (synthesize = 1) GENERATE
    addtwo: dp_subs
    GENERIC MAP (width=>width,pipes=>pipes)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>aa,bb=>bb,borrowin=>borrowin,
              cc=>cc);
  END GENERATE;
       
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION INVERSE - TOP LEVEL      ***
--***                                             ***
--***   DP_INV.VHD                                ***
--***                                             ***
--***   Function: IEEE754 DP Inverse              ***
--***   (multiplicative iterative algorithm)      ***
--***                                             ***
--***   12/08/09 ML                               ***
--***                                             ***
--***   (c) 2009 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--***                                             ***
--*** Stratix II                                  ***
--*** Latency = 20 + 2*DoubleSpeed +              ***
--***           RoundConvert*(1+DoubleSpeed)      ***
--*** DoubleSpeed = 0, Roundconvert = 0 : 20      ***
--*** DoubleSpeed = 1, Roundconvert = 0 : 22      ***
--*** DoubleSpeed = 0, Roundconvert = 1 : 21      ***
--*** DoubleSpeed = 1, Roundconvert = 1 : 24      ***
--***                                             ***
--*** Stratix III/IV                              ***
--*** Latency = 19 + DoubleSpeed +                ***
--***           Roundconvert*(1+DoubleSpeed)      ***
--*** DoubleSpeed = 0, Roundconvert = 0 : 19      ***
--*** DoubleSpeed = 1, Roundconvert = 0 : 20      ***
--*** DoubleSpeed = 0, Roundconvert = 1 : 20      ***
--*** DoubleSpeed = 1, Roundconvert = 1 : 22      ***
--***                                             ***
--***************************************************

ENTITY dp_inv IS 
GENERIC (
         roundconvert : integer := 0; -- 0 = no round, 1 = round
         doubleaccuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
         doublespeed : integer := 0;   -- 0/1
         device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1   -- 0/1    
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentin : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissain : IN STD_LOGIC_VECTOR (52 DOWNTO 1);

		signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      --------------------------------------------------
      nanout : OUT STD_LOGIC;
      invalidout : OUT STD_LOGIC;
      dividebyzeroout : OUT STD_LOGIC
		);
END dp_inv;

ARCHITECTURE rtl OF dp_inv IS
  
  constant expwidth : positive := 11;
  constant manwidth : positive := 52;
  
  -- SII Latency = 19 + 2*speed                  
  -- SIII Latency = 18 + speed                   
  constant coredepth : positive := 19+2*doublespeed - device*(1+doublespeed);
  
  type expfftype IS ARRAY (coredepth-1 DOWNTO 1) OF STD_LOGIC_VECTOR (expwidth+2 DOWNTO 1);
  
  signal zerovec : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
    
  signal signinff : STD_LOGIC;
  signal manff : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal expinff : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal expoffset : STD_LOGIC_VECTOR (expwidth+2 DOWNTO 1);
  signal invertnum : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal quotient : STD_LOGIC_VECTOR (55 DOWNTO 1);
  signal signff : STD_LOGIC_VECTOR (coredepth-1 DOWNTO 1);  
  signal expff : expfftype;  

  -- conditions
  signal zeroman : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal zeroexp : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal maxexp : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal zeromaninff : STD_LOGIC;
  signal zeroexpinff : STD_LOGIC;
  signal maxexpinff : STD_LOGIC;
  signal zeroinff : STD_LOGIC;
  signal infinityinff : STD_LOGIC;
  signal naninff : STD_LOGIC;
  signal dividebyzeroff, nanff : STD_LOGIC_VECTOR (coredepth-3 DOWNTO 1);

  component dp_inv_core 
  GENERIC (
           doublespeed : integer := 0;  -- 0/1
           doubleaccuracy : integer := 0;  -- 0/1
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 1      -- 0/1      
          ); 
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        divisor : IN STD_LOGIC_VECTOR (54 DOWNTO 1);

		  quotient : OUT STD_LOGIC_VECTOR (55 DOWNTO 1)
		  );
  end component;
  
  component dp_divnornd
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        signin : IN STD_LOGIC;
        exponentdiv : IN STD_LOGIC_VECTOR (13 DOWNTO 1);
        mantissadiv : IN STD_LOGIC_VECTOR (53 DOWNTO 1);
        nanin : IN STD_LOGIC;
        dividebyzeroin : IN STD_LOGIC;

		  signout : OUT STD_LOGIC;
        exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        --------------------------------------------------
        nanout : OUT STD_LOGIC;
        invalidout : OUT STD_LOGIC;
        dividebyzeroout : OUT STD_LOGIC
		  );
  end component;
       	
  component dp_divrnd
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        signin : IN STD_LOGIC;
        exponentdiv : IN STD_LOGIC_VECTOR (13 DOWNTO 1);
        mantissadiv : IN STD_LOGIC_VECTOR (53 DOWNTO 1);
        nanin : IN STD_LOGIC;
        dividebyzeroin : IN STD_LOGIC;

		  signout : OUT STD_LOGIC;
        exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        --------------------------------------------------
        nanout : OUT STD_LOGIC;
        invalidout : OUT STD_LOGIC;
        dividebyzeroout : OUT STD_LOGIC
		  );
  end component;

  component dp_divrndpipe
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        signin : IN STD_LOGIC;
        exponentdiv : IN STD_LOGIC_VECTOR (13 DOWNTO 1);
        mantissadiv : IN STD_LOGIC_VECTOR (53 DOWNTO 1);
        nanin : IN STD_LOGIC;
        dividebyzeroin : IN STD_LOGIC;

		  signout : OUT STD_LOGIC;
        exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        --------------------------------------------------
        nanout : OUT STD_LOGIC;
        invalidout : OUT STD_LOGIC;
        dividebyzeroout : OUT STD_LOGIC
		  );
  end component;
BEGIN
    
  gzva: FOR k IN 1 TO manwidth GENERATE
    zerovec(k) <= '0';
  END GENERATE;

  gxa: FOR k IN 1 TO expwidth-1 GENERATE
    expoffset(k) <= '1';
  END GENERATE;
  expoffset(expwidth+2 DOWNTO expwidth) <= "000";

  pma: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
  
      FOR k IN 1 TO manwidth LOOP
        manff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        expinff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO coredepth-1 LOOP
        signff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO coredepth-1 LOOP
        FOR j IN 1 TO expwidth+2 LOOP
          expff(k)(j) <= '0';
        END LOOP;
      END LOOP;
    
    ELSIF (rising_edge(sysclk)) THEN

      IF (enable = '1') THEN
        
        signinff <= signin;
        manff <= mantissain;
        expinff <= exponentin;

        signff(1) <= signinff;
        FOR k IN 2 TO coredepth-1 LOOP
          signff(k) <= signff(k-1);
        END LOOP;
    
        expff(1)(expwidth+2 DOWNTO 1) <= expoffset - ("00" & expinff);
        expff(2)(expwidth+2 DOWNTO 1) <= expff(1)(expwidth+2 DOWNTO 1) + expoffset;
        FOR k IN 3 TO coredepth-2 LOOP
          expff(k)(expwidth+2 DOWNTO 1) <= expff(k-1)(expwidth+2 DOWNTO 1);
        END LOOP;
        -- quotient always <1, so decrement exponent
        expff(coredepth-1)(expwidth+2 DOWNTO 1) <= expff(coredepth-2)(expwidth+2 DOWNTO 1) - 
                                                  (zerovec(expwidth+1 DOWNTO 1) & '1');   
                                                  
      END IF;
  
    END IF;
  
  END PROCESS;

--********************
--*** CHECK INPUTS ***
--********************

  zeroman(1) <= manff(1);
  gca: FOR k IN 2 TO manwidth GENERATE
    zeroman(k) <= zeroman(k-1) OR manff(k);
  END GENERATE; 
  zeroexp(1) <= expinff(1);
  gcb: FOR k IN 2 TO expwidth GENERATE
    zeroexp(k) <= zeroexp(k-1) OR expinff(k);
  END GENERATE;
  maxexp(1) <= expinff(1);
  gcc: FOR k IN 2 TO expwidth GENERATE
    maxexp(k) <= maxexp(k-1) AND expinff(k);
  END GENERATE;

  pcc: PROCESS (sysclk,reset)
  BEGIN
    
    IF (reset = '1') THEN
      
      zeromaninff <= '0';  
      zeroexpinff <= '0'; 
      maxexpinff <= '0';  
      zeroinff <= '0';
      infinityinff <= '0';
      naninff <= '0';
      FOR k IN 1 TO coredepth-3 LOOP
        dividebyzeroff(k) <= '0';
        nanff(k) <= '0';
      END LOOP;
     
    ELSIF (rising_edge(sysclk)) THEN
            
      IF (enable = '1') THEN
     
        zeromaninff <= zeroman(manwidth);
        zeroexpinff <= zeroexp(expwidth);
        maxexpinff <= maxexp(expwidth);
    
        -- zero when man = 0, exp = 0
        -- infinity when man = 0, exp = max
        -- nan when man != 0, exp = max
    
        -- all ffs '1' when condition true
        zeroinff <= NOT(zeromaninff OR zeroexpinff); 
        infinityinff <= NOT(zeromaninff) AND maxexpinff;
        naninff <= zeromaninff AND maxexpinff;

        -- nan output when nan input
        nanff(1) <= naninff;
        FOR k IN 2 TO coredepth-3 LOOP
          nanff(k) <= nanff(k-1);
        END LOOP;
        
        dividebyzeroff(1) <= zeroinff;
        FOR k IN 2 TO coredepth-3 LOOP
          dividebyzeroff(k) <= dividebyzeroff(k-1);
        END LOOP;
      
      END IF;
   
    END IF;

  END PROCESS;


--*******************
--*** DIVIDE CORE ***
--*******************

  invertnum <= '1' & mantissain & '0';

  invcore: dp_inv_core
  GENERIC MAP (doublespeed=>doublespeed,doubleaccuracy=>doubleaccuracy,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            divisor=>invertnum,
            quotient=>quotient);
  -- quotient always <1
  
--************************
--*** ROUND AND OUTPUT ***
--************************

  -- in depth coredepth+1 (core + normalff)

  gra: IF (roundconvert = 0) GENERATE

    norndout: dp_divnornd
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              signin=>signff(coredepth-1),
              exponentdiv=>expff(coredepth-1)(expwidth+2 DOWNTO 1),
              mantissadiv=>quotient(53 DOWNTO 1),
              nanin=>nanff(coredepth-3),
              dividebyzeroin=>dividebyzeroff(coredepth-3),

              signout=>signout,exponentout=>exponentout,mantissaout=>mantissaout,
              nanout=>nanout,invalidout=>invalidout,dividebyzeroout=>dividebyzeroout);
            
  END GENERATE;
  
  grb: IF (roundconvert = 1 AND doublespeed = 0) GENERATE

    rndout: dp_divrnd
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              signin=>signff(coredepth-1),
              exponentdiv=>expff(coredepth-1)(expwidth+2 DOWNTO 1),
              mantissadiv=>quotient(53 DOWNTO 1),
              nanin=>nanff(coredepth-3),
              dividebyzeroin=>dividebyzeroff(coredepth-3),

              signout=>signout,exponentout=>exponentout,mantissaout=>mantissaout,
              nanout=>nanout,invalidout=>invalidout,dividebyzeroout=>dividebyzeroout);
            
  END GENERATE;

  grc: IF (roundconvert = 1 AND doublespeed = 1) GENERATE
    
    rndoutpipe: dp_divrndpipe
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              signin=>signff(coredepth-1),
              exponentdiv=>expff(coredepth-1)(expwidth+2 DOWNTO 1),
              mantissadiv=>quotient(53 DOWNTO 1),
              nanin=>nanff(coredepth-3),
              dividebyzeroin=>dividebyzeroff(coredepth-3),

              signout=>signout,exponentout=>exponentout,mantissaout=>mantissaout,
              nanout=>nanout,invalidout=>invalidout,dividebyzeroout=>dividebyzeroout);
            
  END GENERATE;
  
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION INVERSE - CORE           ***
--***                                             ***
--***   DP_INV_CORE.VHD                           ***
--***                                             ***
--***   Function: 54 bit Inverse                  ***
--***   (multiplicative iterative algorithm)      ***
--***                                             ***
--***   09/12/07 ML                               ***
--***                                             ***
--***   (c) 2007 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***   24/04/09 - SIII/SIV multiplier support    ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--*** SII Latency = 19 + 2*doublepeed             ***
--*** SIII Latency = 18 + doublespeed             ***
--***************************************************

ENTITY dp_inv_core IS 
GENERIC (
         doublespeed : integer := 0;  -- 0/1
         doubleaccuracy : integer := 0;  -- 0/1
         device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1      -- 0/1      
        ); 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      divisor : IN STD_LOGIC_VECTOR (54 DOWNTO 1);

		quotient : OUT STD_LOGIC_VECTOR (55 DOWNTO 1)
		);
END dp_inv_core;

ARCHITECTURE rtl OF dp_inv_core IS

  --SII mullatency = doublespeed+5, SIII/IV mullatency = 4
  constant mullatency : positive := doublespeed+5 - device*(1+doublespeed);
  
  signal zerovec : STD_LOGIC_VECTOR (54 DOWNTO 1);
  
  signal divisordel : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal invdivisor : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal delinvdivisor : STD_LOGIC_VECTOR (18 DOWNTO 1);
  
  signal scaleden : STD_LOGIC_VECTOR (54 DOWNTO 1);
  
  signal twonode, subscaleden : STD_LOGIC_VECTOR (55 DOWNTO 1);
  signal guessone : STD_LOGIC_VECTOR (55 DOWNTO 1);
  signal guessonevec : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal absoluteval : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal absolutevalff, absoluteff : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal abscarryff : STD_LOGIC;
  signal iteratenumnode : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal iteratenum : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal absoluteerror : STD_LOGIC_VECTOR (72 DOWNTO 1);
  signal mulabsguessff : STD_LOGIC_VECTOR (19 DOWNTO 1);
  signal mulabsguess : STD_LOGIC_VECTOR (54 DOWNTO 1);

  signal quotientnode : STD_LOGIC_VECTOR (72 DOWNTO 1);
  
  component fp_div_est IS 
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        divisor : IN STD_LOGIC_VECTOR (19 DOWNTO 1);

		  invdivisor : OUT STD_LOGIC_VECTOR (18 DOWNTO 1)
		  );
  end component;
  
  component fp_fxmul IS 
  GENERIC (
           widthaa : positive := 18;
           widthbb : positive := 18;
           widthcc : positive := 36;
           pipes : positive := 1;
           accuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        dataaa : IN STD_LOGIC_VECTOR (widthaa DOWNTO 1);
        databb : IN STD_LOGIC_VECTOR (widthbb DOWNTO 1); 
      
        result : OUT STD_LOGIC_VECTOR (widthcc DOWNTO 1)
       );
  end component;
  
  component dp_fxadd 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1;
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
  component fp_del
  GENERIC (
           width : positive := 64;
           pipes : positive := 2
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
       
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
   end component;  
       
BEGIN
  
  gza: FOR k IN 1 TO 54 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  invcore: fp_div_est
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            divisor=>divisor(54 DOWNTO 36),invdivisor=>invdivisor);
  
  delinone: fp_del
  GENERIC MAP (width=>54,pipes=>5)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>divisor,cc=>divisordel);

  --**********************************
  --*** ITERATION 0 - SCALE INPUTS ***
  --**********************************
  
  -- in level 5, out level 8+speed
  mulscaleone: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>18,widthcc=>54,
               pipes=>3+doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>divisordel,databb=>invdivisor,
            result=>scaleden);
              
  --********************
  --*** ITERATION 1  ***
  --********************

  twonode <= '1' & zerovec(54 DOWNTO 1);
  
  gta: FOR k IN 1 TO 54 GENERATE
    subscaleden(k) <= NOT(scaleden(k));
  END GENERATE;
  subscaleden(55) <= '1';
  
  -- in level 8+doublespeed, outlevel 9+2*doublespeed
  addtwoone: dp_fxadd 
  GENERIC MAP (width=>55,pipes=>doublespeed+1,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>twonode,bb=>subscaleden,carryin=>'1',
            cc=>guessone);  
            
  guessonevec <= guessone(54 DOWNTO 1);
  
  -- absolute value of guess lower 36 bits
  -- this is still correct, because (for positive), value will be 1.(17 zeros)error
  -- can also be calculated from guessonevec (code below)
  -- gabs: FOR k IN 1 TO 36 GENERATE
  --   absoluteval(k) <= guessonevec(k) XOR NOT(guessonevec(54));
  -- END GENERATE;
  gabs: FOR k IN 1 TO 36 GENERATE
    absoluteval(k) <= scaleden(k) XOR NOT(scaleden(54));
  END GENERATE;
  
  pta: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN

      FOR k IN 1 TO 36 LOOP
        absolutevalff(k) <= '0';
        absoluteff(k) <= '0';
      END LOOP;
      abscarryff <= '0';
      
    ELSIF (rising_edge(sysclk)) THEN
      
      IF (enable = '1') THEN
          
        absolutevalff <= absoluteval; -- out level 9+speed
        abscarryff <= NOT(scaleden(54)); 
        absoluteff <= absolutevalff + (zerovec(35 DOWNTO 1) & abscarryff); -- out level 10+speed
        
      END IF;
    
    END IF;
    
  END PROCESS;

  deloneone: fp_del
  GENERIC MAP (width=>18,pipes=>4+2*doublespeed)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>invdivisor,
            cc=>delinvdivisor);
 
  -- in level 9+2*doublespeed, out level 12+3*doublespeed
  muloneone: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>18,widthcc=>54,
               pipes=>3+doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>guessonevec,databb=>delinvdivisor,
            result=>iteratenumnode);
 
  -- in level 10+doublespeed, out level 13+doublespeed
  mulonetwo: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>36,widthcc=>72,
               pipes=>3,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>absoluteff,databb=>absoluteff,
            result=>absoluteerror);
            
  -- if speed = 0, delay absoluteerror 1 clock, else 2
  -- this guess always positive (check??)
  -- change here, error can be [19:1], not [18:1] - this is because (1.[17 zeros].error)^2
  -- gives 1.[34 zeros].error 
  pgaa: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN

      FOR k IN 1 TO 19 LOOP
        mulabsguessff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
      
      IF (enable = '1') THEN
        mulabsguessff <= absoluteerror(72 DOWNTO 54) + 
                        (zerovec(18 DOWNTO 1) & absoluteerror(53));
      END IF;
    
    END IF;
    
  END PROCESS;

  mulabsguess(19 DOWNTO 1) <= mulabsguessff;
  gmga: FOR k IN 20 TO 53 GENERATE
    mulabsguess(k) <= '0';
  END GENERATE;
  mulabsguess(54) <= '1';
  
  -- mulabsguess at 14+doublespeed depth
  -- iteratenum at 12+3*doublespeed depth
  
  -- mulabsguess 5 (5)clocks from absolutevalff
  -- iteratenum 3+2doublespeed (3/5)clocks from abssolutevalff
  -- delay iterate num 
  gdoa: IF (doublespeed = 0) GENERATE
    delonetwo: fp_del
    GENERIC MAP (width=>54,pipes=>2)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>iteratenumnode,
              cc=>iteratenum);
            
  END GENERATE;
  
  gdob: IF (doublespeed = 1) GENERATE
    iteratenum <= iteratenumnode;
  END GENERATE;
  
  --*********************
  --*** OUTPUT SCALE  ***
  --*********************
  
  -- in level 14+doublespeed
  -- SII out level 19+2*doublespeed
  -- SIII/IV out level 18+doublespeed
  mulout: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>54,widthcc=>72,pipes=>mullatency,
               accuracy=>doubleaccuracy,device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>iteratenum,databb=>mulabsguess,
            result=>quotientnode);
          
  quotient <= quotientnode(71 DOWNTO 17);
                  
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION INVERSE SQUARE ROOT      ***
--***              TOP LEVEL                      ***
--***                                             ***
--***   DP_INVSQR.VHD                             ***
--***                                             ***
--***   Function: IEEE754 DP Inverse Square Root  ***
--***   (multiplicative iterative algorithm)      ***
--***                                             ***
--***   11/08/09 ML                               ***
--***                                             ***
--***   (c) 2009 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--***                                             ***
--*** Stratix II                                  ***
--*** Latency = 32 + 2*Speed                      ***
--*** Speed = 0 : 32                              ***
--*** Speed = 1 : 34                              ***
--***                                             ***
--*** Stratix III/IV                              ***
--*** Latency = 31 + Speed                        ***
--*** Speed = 0 : 31                              ***
--*** Speed = 1 : 32                              ***
--***                                             ***
--*************************************************** 
    
ENTITY dp_invsqr IS 
GENERIC (
         doubleaccuracy : integer := 0;  -- 0 = pruned multiplier, 1 = normal multiplier
         doublespeed : integer := 0;  -- 0/1
         device : integer := 0;  -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1  -- 0/1    
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentin: IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissain : IN STD_LOGIC_VECTOR (52 DOWNTO 1);

		  signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      --------------------------------------------------
      nanout : OUT STD_LOGIC;
      invalidout : OUT STD_LOGIC
		);
END dp_invsqr;

ARCHITECTURE rtl OF dp_invsqr IS
  
  constant manwidth : positive := 52;
  constant expwidth : positive := 11;
  
  constant coredepth : positive := 31+2*doublespeed - device*(1+doublespeed);
  
  type expfftype IS ARRAY (coredepth+1 DOWNTO 1) OF STD_LOGIC_VECTOR (expwidth DOWNTO 1);

  signal maninff : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal expinff : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal signff : STD_LOGIC_VECTOR (coredepth+1 DOWNTO 1);
  signal correctff : STD_LOGIC_VECTOR (3 DOWNTO 1);  -- SPR 383712
  signal expff : expfftype;
  signal radicand : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal oddexponent : STD_LOGIC;
  signal invroot : STD_LOGIC_VECTOR (54 DOWNTO 1);
  --signal invroottest : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal manff : STD_LOGIC_VECTOR (manwidth DOWNTO 1); 
  signal zerovec : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal offset : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
    
  -- conditions
  signal nanmanff, nanexpff : STD_LOGIC_VECTOR (coredepth-1 DOWNTO 1);
  signal zeroexpff, zeromanff : STD_LOGIC_VECTOR (coredepth-2 DOWNTO 1); 
  signal expinzero, expinmax : STD_LOGIC_VECTOR (expwidth DOWNTO 1);
  signal maninzero : STD_LOGIC_VECTOR (manwidth DOWNTO 1);
  signal expzero, expmax, manzero : STD_LOGIC;
  signal infinityconditionff, nanconditionff, expzeroff : STD_LOGIC;
  signal correct_powers_of_two : STD_LOGIC;  -- SPR 383712
    
  component dp_invsqr_core IS 
  GENERIC (
           doublespeed : integer := 0;  -- 0/1
           doubleaccuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 1  -- 0/1      
          );         
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        radicand : IN STD_LOGIC_VECTOR (54 DOWNTO 1);
        odd : IN STD_LOGIC;

		  invroot : OUT STD_LOGIC_VECTOR (54 DOWNTO 1)
		  );
  end component;
	
BEGIN
    
  gzva: FOR k IN 1 TO manwidth GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  gxoa: FOR k IN 1 TO expwidth-1 GENERATE
    offset(k) <= '1';
  END GENERATE;
  offset(expwidth) <= '0';

  pma: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN

      FOR k IN 1 TO manwidth LOOP
        maninff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        expinff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO coredepth+1 LOOP
        signff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO coredepth+1 LOOP
        FOR j IN 1 TO expwidth LOOP
          expff(k)(j) <= '0';
        END LOOP;
      END LOOP;
      FOR k IN 1 TO manwidth LOOP
        manff(k) <= '0';
      END LOOP;
	  correctff <= "000";  -- SPR 383712
  
    ELSIF (rising_edge(sysclk)) THEN

      maninff <= mantissain;
      expinff <= exponentin;
    
      signff(1) <= signin;
      FOR k IN 2 TO coredepth+1 LOOP
        signff(k) <= signff(k-1);
      END LOOP;
  
      expff(1)(expwidth DOWNTO 1) <= exponentin;
      expff(2)(expwidth DOWNTO 1) <= expff(1)(expwidth DOWNTO 1) - offset;
      expff(3)(expwidth DOWNTO 1) <= expff(2)(expwidth) & expff(2)(expwidth DOWNTO 2);
      expff(4)(expwidth DOWNTO 1) <= offset - expff(3)(expwidth DOWNTO 1);
      expff(5)(expwidth DOWNTO 1) <= expff(4)(expwidth DOWNTO 1) - 1 + correctff(3);
      FOR k IN 6 TO coredepth LOOP
        expff(k)(expwidth DOWNTO 1) <= expff(k-1)(expwidth DOWNTO 1);
      END LOOP;
      FOR k IN 1 TO expwidth LOOP
        expff(coredepth+1)(k) <= (expff(coredepth)(k) AND zeroexpff(coredepth-2)) OR nanexpff(coredepth-2);
      END LOOP;

	  -- SPR 383712
	  correctff(1) <= correct_powers_of_two;
	  correctff(2) <= correctff(1);
	  correctff(3) <= correctff(2);
	  
      FOR k IN 1 TO manwidth LOOP
        manff(k) <= (invroot(k+1) AND zeromanff(coredepth-2)) OR nanmanff(coredepth-2);
      END LOOP;
  
    END IF;
  
  END PROCESS;

--*******************
--*** CONDITIONS ***
--*******************

  pcc: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
      
      FOR k IN 1 TO coredepth-1 LOOP
        nanmanff(k) <= '0';
        nanexpff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO coredepth-2 LOOP
        zeroexpff(k) <= '0';
        zeromanff(k) <= '0';
      END LOOP;
      infinityconditionff <= '0'; 
      nanconditionff <= '0';
      expzeroff <= '0';

    ELSIF (rising_edge(sysclk)) THEN
     
      infinityconditionff <= manzero AND expmax;
      nanconditionff <= signff(1) OR expzero OR (expmax AND manzero);
      expzeroff <= expzero;
 
      nanmanff(1) <= nanconditionff; -- level 3
      nanexpff(1) <= nanconditionff OR infinityconditionff; -- also max exp when infinity
      FOR k IN 2 TO coredepth-1 LOOP
        nanmanff(k) <= nanmanff(k-1);
        nanexpff(k) <= nanexpff(k-1);
      END LOOP;

      zeromanff(1) <= NOT(expzeroff) AND NOT(infinityconditionff); -- level 3
      zeroexpff(1) <= NOT(expzeroff); -- level 3
      FOR k IN 2 TO coredepth-2 LOOP
        zeromanff(k) <= zeromanff(k-1);
        zeroexpff(k) <= zeroexpff(k-1);
      END LOOP;
    
    END IF;
  
  END PROCESS;

--*******************
--*** SQUARE ROOT ***
--*******************
  
  radicand <= '1' & mantissain & '0';
  -- sub 1023, so 1023 (odd) = 2^0 => even
  oddexponent <= NOT(exponentin(1));

  -- does not require rounding, output of core rounded already, LSB always 0
  isqr: dp_invsqr_core
  GENERIC MAP (doublespeed=>doublespeed,doubleaccuracy=>doubleaccuracy,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            radicand=>radicand,odd=>oddexponent,
            invroot=>invroot);

--*********************
--*** SPECIAL CASES ***
--*********************
-- 1. if negative input, invalid operation, NAN 
-- 2. 0 in, invalid operation, NAN
-- 3. infinity in, invalid operation, infinity out
-- 4. NAN in, invalid operation, NAN

  -- '1' if 0 
  expinzero(1) <= expinff(1);
  gxza: FOR k IN 2 TO expwidth GENERATE
    expinzero(k) <= expinzero(k-1) OR expinff(k);
  END GENERATE;
  expzero <= NOT(expinzero(expwidth)); -- '0' when zero
                 
  -- '1' if nan or infinity
  expinmax(1) <= expinff(1);
  gxia: FOR k IN 2 TO expwidth GENERATE
    expinmax(k) <= expinmax(k-1) AND expinff(k);
  END GENERATE;
  expmax <= expinmax(expwidth); -- '1' when true
          
  -- '1' if zero or infinity
  maninzero(1) <= maninff(1);
  gmza: FOR k IN 2 TO manwidth GENERATE
    maninzero(k) <= maninzero(k-1) OR maninff(k);
  END GENERATE;
  manzero <= NOT(maninzero(manwidth)); 
  -- 09/03/11 ML
  -- if mantissa is 0 and exponent is odd (...123,125,127,129,131...) then dont subtract 1 from offset corrected exponent
  -- '1' is subtracted as any value, no matter how small, in the mantissa will reduce the inverse below the mirrored exponent (around 127)
  -- if the exponent is odd (with mantissa 0) the value is a power of 2 (...0.25,0.5,1,2,4...) and the mirrored exponent is correct
  -- if the exponent is even (with mantissa 0), the inverse square root will have a non zero mantissa and can be handled normally
  correct_powers_of_two <= manzero AND expinff(1);  -- SPR 383712
       
--***************
--*** OUTPUTS ***
--***************

  signout <= signff(coredepth+1);
  exponentout <= expff(coredepth+1)(expwidth DOWNTO 1);   
  mantissaout <= manff;
  -----------------------------------------------
  nanout <= nanmanff(coredepth-1);
  invalidout <= nanmanff(coredepth-1);

END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION INVERSE SQUARE ROOT      ***
--***                 CORE                        ***
--***                                             ***
--***   DP_INVSQR_CORE.VHD                        ***
--***                                             ***
--***   Function: 54 bit Inverse Square Root      ***
--***   (multiplicative iterative algorithm)      ***
--***                                             ***
--***   09/12/07 ML                               ***
--***                                             ***
--***   (c) 2007 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***   24/04/09 - SIII/SIV multiplier support    ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--*** SII Latency = 31 + 2*doublespeed            ***
--*** SIII/IV Latency = 30 + doublespeed          ***
--*** 1. Output is rounded already, LSB always 0  ***
--***************************************************

ENTITY dp_invsqr_core IS 
GENERIC (
         doublespeed : integer := 0;  -- 0/1
         doubleaccuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
         device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1  -- 0/1      
        ); 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      radicand : IN STD_LOGIC_VECTOR (54 DOWNTO 1);
      odd : IN STD_LOGIC;

		invroot : OUT STD_LOGIC_VECTOR (54 DOWNTO 1)
		);
END dp_invsqr_core;

ARCHITECTURE rtl OF dp_invsqr_core IS

  --SII mullatency = speed+5, SIII/IV mullatency = 4
  constant mullatency : positive := doublespeed+5 - device*(1+doublespeed);
    
  signal zerovec : STD_LOGIC_VECTOR (54 DOWNTO 1);
  
  signal evennum : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal oddnum : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal guessvec : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal oddff : STD_LOGIC_VECTOR (25+doublespeed DOWNTO 1);
  signal scalenumff : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal guess : STD_LOGIC_VECTOR (18 DOWNTO 1);

  -- 1st iteration
  signal radicanddelone : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal guessdel : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal multoneone : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal multonetwo : STD_LOGIC_VECTOR (37 DOWNTO 1);
  signal multonetwoff : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal suboneff : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal multonethr : STD_LOGIC_VECTOR (37 DOWNTO 1);
  signal guessonevec : STD_LOGIC_VECTOR (36 DOWNTO 1);
      
  -- 2ns iteration
  signal radicanddeltwo : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal guessonevecdelone : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal guessonevecdeltwo : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal multtwoone : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal multtwotwo : STD_LOGIC_VECTOR (72 DOWNTO 1);
  signal multtwotwoff : STD_LOGIC_VECTOR (36 DOWNTO 1);
  signal finaladdsub : STD_LOGIC;
  signal finaladdsubff : STD_LOGIC_VECTOR (4 DOWNTO 1);
  signal finaladdff : STD_LOGIC_VECTOR (55 DOWNTO 1);
  signal multtwothr : STD_LOGIC_VECTOR (36 DOWNTO 1);  
  signal finalguessvec : STD_LOGIC_VECTOR (53 DOWNTO 1);
  signal invrootvec : STD_LOGIC_VECTOR (53 DOWNTO 1);

  component fp_invsqr_est IS 
  GENERIC (synthesize : integer := 0); -- 0 = behavioral, 1 = syntheziable
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        radicand : IN STD_LOGIC_VECTOR (19 DOWNTO 1);

		  invroot : OUT STD_LOGIC_VECTOR (18 DOWNTO 1)
		  );
  end component;
  
  component dp_fxadd IS 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1;
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       ); 
  end component;
  
  component fp_fxmul IS 
  GENERIC (
           widthaa : positive := 18;
           widthbb : positive := 18;
           widthcc : positive := 36;
           pipes : positive := 1;
           accuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 0
        );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        dataaa : IN STD_LOGIC_VECTOR (widthaa DOWNTO 1);
        databb : IN STD_LOGIC_VECTOR (widthbb DOWNTO 1); 
      
        result : OUT STD_LOGIC_VECTOR (widthcc DOWNTO 1)
       ); 
  end component;
 
  component fp_del 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
   end component;
   		 
BEGIN
    
  oddnum <= conv_std_logic_vector(185363,18); -- mult by 2^-.5 (odd exp)
  evennum <= conv_std_logic_vector(262143,18); -- mult by 1 (even exp)
  
  gza: FOR k IN 1 TO 54 GENERATE
    zerovec(k) <= '0';
  END GENERATE;

  -- in level 0, out level 5
  look: fp_invsqr_est
  GENERIC MAP (synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            radicand=>radicand(54 DOWNTO 36),invroot=>guessvec);
              
  pta: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN
    
      FOR k IN 1 TO 25+doublespeed LOOP
        oddff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 18 LOOP
        scalenumff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF (enable = '1') THEN
        
        oddff(1) <= odd;
        FOR k IN 2 TO 25+doublespeed LOOP
          oddff(k) <= oddff(k-1);
        END LOOP; 
        
        FOR k IN 1 TO 18 LOOP
          scalenumff(k) <= (oddnum(k) AND oddff(4)) OR (evennum(k) AND NOT(oddff(4)));
        END LOOP;
          
      END IF;
    
    END IF;    
      
  END PROCESS;

  -- in level 5, out level 7
  mulscale: fp_fxmul
  GENERIC MAP (widthaa=>18,widthbb=>18,widthcc=>18,pipes=>2,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>guessvec,databb=>scalenumff,
            result=>guess);

  --*********************
  --*** ITERATION ONE ***
  --*********************
  --X' = X/2(3-YXX)
  
  deloneone: fp_del
  GENERIC MAP(width=>54,pipes=>9)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>radicand,cc=>radicanddelone);
            
  delonetwo: fp_del
  GENERIC MAP(width=>18,pipes=>7)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>guess,cc=>guessdel);
            
  -- in level 7, out level 9 (18x18=36)
  oneone: fp_fxmul
  GENERIC MAP (widthaa=>18,widthbb=>18,widthcc=>36,pipes=>2,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>guess,databb=>guess,
            result=>multoneone);
                   
  -- in level 9, out level 12 (36x36=37)
  onetwo: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>36,widthcc=>37,pipes=>3,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>radicanddelone(54 DOWNTO 19),databb=>multoneone,
            result=>multonetwo);
                   
  -- multonetwo is about 1 - either 1.000000XXX or 0.9999999
  -- mult by 2 if odd exponent (37 DOWNTO 2), otherwise (38 DOWNTO 3)
  -- round bit in position 1 or 2
  pone: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN

      FOR k IN 1 TO 36 LOOP
        multonetwoff(k) <= '0';
        suboneff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF (enable = '1') THEN
        
        --invert here so that borrow can be added in simple expression
        -- level 13
        FOR k IN 1 TO 36 LOOP
          multonetwoff(k) <= NOT((multonetwo(k) AND oddff(12)) OR (multonetwo(k+1) AND NOT(oddff(12))));
        END LOOP;
        -- level 14
        suboneff <= ("11" & zerovec(34 DOWNTO 1)) + 
                    ('1' & multonetwoff(36 DOWNTO 2)) +
                    (zerovec(35 DOWNTO 1) & multonetwoff(1));
          
      END IF;
    
    END IF;    
      
  END PROCESS;    

  -- in level 14, out level 17 (36x18=37)
  onethr: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>18,widthcc=>37,pipes=>3,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>suboneff,databb=>guessdel,
            result=>multonethr); 
            
  -- mult by 2 - subone is about 1 (1.000 or 0.9999) so will effectively multiply by 0.5
  guessonevec <= multonethr(36 DOWNTO 1);
  
  --************************
  --*** SECOND ITERATION ***
  --************************
  --X' = X/2(3-YXX)
  
  deltwoone: fp_del
  GENERIC MAP(width=>54,pipes=>11)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>radicanddelone,cc=>radicanddeltwo);
            
  -- SII level in 17, level out 26+doublespeed
  -- SIII/IV level in 17, level out 25
  deltwotwo: fp_del
  GENERIC MAP(width=>36,pipes=>(9+doublespeed-device*(1+doublespeed)))
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>guessonevec,cc=>guessonevecdelone);
            
  deltwothr: fp_del
  GENERIC MAP (width=>36,pipes=>4)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>guessonevecdelone,cc=>guessonevecdeltwo);
            
  -- in level 17, out level 20 (36x36=54)
  twoone: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>36,widthcc=>54,pipes=>3,
               accuracy=>doubleaccuracy,device=>device,
               synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>guessonevec,databb=>guessonevec,
            result=>multtwoone); 
            
  -- in level 20, 
  -- SII out level 25/26 - 25+doublespeed
  -- SIII/SIV out level 24   
  twotwo: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>54,widthcc=>72,pipes=>mullatency,
               accuracy=>doubleaccuracy,device=>device,
               synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>multtwoone,databb=>radicanddeltwo,
            result=>multtwotwo); 

  -- multtwotwo is about 1 - either 1.000000XXX or 0.9999999
  -- mult by 2 if odd exponent (55 DOWNTO 2), otherwise (56 DOWNTO 3)
  -- round bit in position 1 or 2
  ptwo: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN

      FOR k IN 1 TO 36 LOOP
        multtwotwoff(k) <= '0';
      END LOOP;
      finaladdsubff <= "0000";
      FOR k IN 1 TO 55 LOOP
        finaladdff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF (enable = '1') THEN
        
        -- SII in level 25+doublespeed, out level 26+doublespeed
        -- SIII in level 24, out level 25
        -- if multwotwo > 1, subtwo negative, subtract multwothr from guessonevec
        -- if multwotwo <= 1, subtwo positive, add multwothr to guessonevec
        FOR k IN 1 TO 36 LOOP
          multtwotwoff(k) <= ((multtwotwo(k+6) AND oddff(25+doublespeed-device*(1+doublespeed))) OR 
                              (multtwotwo(k+7) AND NOT(oddff(25+doublespeed-device*(1+doublespeed))))) XOR finaladdsub;
        END LOOP;
        
        finaladdsubff(1) <= finaladdsub;
        FOR k IN 2 TO 4 LOOP
          finaladdsubff(k) <= finaladdsubff(k-1);
        END LOOP;

        -- makes sure no overflow happens here, for example if less than 30 leading 1s/0s
        -- in multtwotwoff
        -- SII level in 29+doublespeed level out 30+doublespeed
        -- SIII level in 28 level out 29
        FOR k IN 1 TO 26 LOOP
          finaladdff(k) <= multtwothr(k+10) XOR NOT(finaladdsubff(4));
        END LOOP;
        FOR k IN 27 TO 55 LOOP
          finaladdff(k) <= NOT(finaladdsubff(4));
        END LOOP;
          
      END IF;
    
    END IF;    
      
  END PROCESS;  
  
  -- doesnt have to be near msb
  finaladdsub <= multtwotwo(60);  

  -- SII level in (26+doublespeed), level out (29+doublespeed)
  -- SII level in 25, level out 28
  twothr: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>36,widthcc=>36,pipes=>3,
               device=>device,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>multtwotwoff,databb=>guessonevecdelone,
            result=>multtwothr);
                      
  finalguessvec <= guessonevecdeltwo & zerovec(17 DOWNTO 1);
   
  -- SII level in 30+doublespeed, level out 31+2*doublespeed
  -- SIII level in 29, level out 30+doublespeed
  final: dp_fxadd
  GENERIC MAP (width=>53,pipes=>doublespeed+1,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>finalguessvec,bb=>finaladdff(55 DOWNTO 3),carryin=>finaladdff(2),
            cc=>invrootvec);
  
  invroot <= invrootvec & '0';
   
END rtl;

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   ALTERA FLOATING POINT DATAPATH COMPILER   ***
--***                                             ***
--***   DP_LDEXP.VHD                              ***
--***                                             ***
--***   Function: Single Precision Load Exponent  ***
--***                                             ***
--***   ldexp(x,n) - x*2^n - IEEE in and out      ***
--***                                             ***
--***   Created 12/09/09                          ***
--***                                             ***
--***   (c) 2009 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_ldexp IS 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      signin : IN STD_LOGIC;
      exponentin : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissain : IN STD_LOGIC_VECTOR (52 DOWNTO 1);
      bb : IN STD_LOGIC_VECTOR (32 DOWNTO 1);
      
		  signout : OUT STD_LOGIC;
      exponentout : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      mantissaout : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
		  satout, zeroout, nanout : OUT STD_LOGIC
		);
END dp_ldexp;

ARCHITECTURE rtl OF dp_ldexp IS
 
  signal signinff : STD_LOGIC;
  signal exponentinff : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal mantissainff : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal bbff : STD_LOGIC_VECTOR (13 DOWNTO 1);
  signal signoutff : STD_LOGIC;
  signal exponentoutff : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal mantissaoutff : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal satoutff, zerooutff, nanoutff : STD_LOGIC;
  signal satnode, zeronode, nannode : STD_LOGIC;
  signal expnode : STD_LOGIC_VECTOR (13 DOWNTO 1);
  signal expzeroin, expmaxin : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal expzeronode, expmaxnode : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal expzeroout, expmaxout : STD_LOGIC;
  signal manzeroin : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal manzero, mannonzero : STD_LOGIC; 

BEGIN
    
  pin: PROCESS (sysclk,reset)
  BEGIN

    IF (reset = '1') THEN
    
      signinff <= '0';
      signoutff <= '0';
      FOR k IN 1 TO 11 LOOP
        exponentinff(k) <= '0';
        exponentoutff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 52 LOOP
        mantissainff(k) <= '0';
        mantissaoutff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 13 LOOP
        bbff(k) <= '0';
      END LOOP;
      satoutff <= '0';
      zerooutff <= '0';
      nanoutff <= '0';
      
    ELSIF (rising_edge(sysclk)) THEN
    
      IF (enable = '1') THEN

      
        signinff <= signin;
        exponentinff <= exponentin;
        mantissainff <= mantissain;
        
        bbff <= bb(13 DOWNTO 1);
        
        signoutff <= signinff;
        FOR k IN 1 TO 11 LOOP
          exponentoutff(k) <= (expnode(k) AND NOT(zeronode)) OR satnode OR nannode;
        END LOOP;
        FOR k IN 1 TO 52 LOOP
          mantissaoutff(k) <= (mantissainff(k) AND NOT(zeronode) AND NOT(satnode)) OR nannode;
        END LOOP;
        
        satoutff <= satnode;
        zerooutff <= zeronode;
        nanoutff <= nannode;
        
      END IF;
    
    END IF;  
      
  END PROCESS;
  
  expnode <= ("00" & exponentinff) + bbff;
  
  expzeroin(1) <= exponentinff(1);
  expmaxin(1) <= exponentinff(1);
  gxa: FOR k IN 2 TO 11 GENERATE
    expzeroin(k) <= expzeroin(k-1) OR exponentinff(k);
    expmaxin(k) <= expmaxin(k-1) AND exponentinff(k);
  END GENERATE;
  
  expzeronode(1) <= expnode(1);
  expmaxnode(1) <= expnode(1);
  gxb: FOR k IN 2 TO 11 GENERATE
    expzeronode(k) <= expzeronode(k-1) OR expnode(k);
    expmaxnode(k) <= expmaxnode(k-1) AND expnode(k);
  END GENERATE;
  expzeroout <= NOT(expzeroin(11)) OR (NOT(expzeronode(11)) AND NOT(expnode(12))) OR (expnode(13));
  expmaxout <= expmaxin(11) OR (expmaxnode(11) AND NOT(expnode(12))) OR (expnode(12) AND NOT(expnode(13))); 
  
  manzeroin(1) <= mantissainff(1);
  gma: FOR k IN 2 TO 52 GENERATE
    manzeroin(k) <= manzeroin(k-1) OR mantissainff(k);
  END GENERATE;
  manzero <= NOT(manzeroin(52));
  mannonzero <= manzeroin(52);
  
  satnode <= (expmaxin(11) AND NOT(manzeroin(52))) OR expmaxout;
  zeronode <= NOT(expzeroin(11)) OR expzeroout;
  nannode <= expmaxin(11) AND manzeroin(52);
  
	signout <= signoutff;
  exponentout <= exponentoutff;
  mantissaout <= mantissaoutff;
      
  satout <= satoutff;
  zeroout <= zerooutff;
  nanout <= nanoutff;

END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   DOUBLE PRECISION LOG(e) - CORE            ***
--***                                             ***
--***   DP_LN_CORE.VHD                            ***
--***                                             ***
--***   Function: Double Precision LOG (LN) Core  ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***   24/04/09 - SIII/SIV multiplier support    ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--*** SII/SIII/SIV Latency = 26 + 7*doublespeed   ***
--*** no 54x54 multipliers                        ***
--***************************************************

ENTITY dp_ln_core IS 
GENERIC (
         doublespeed : integer := 0; -- 0/1
         device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
         synthesize : integer := 1 -- 0/1       
        );
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aaman : IN STD_LOGIC_VECTOR (52 DOWNTO 1); 
      aaexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      
      ccman : OUT STD_LOGIC_VECTOR (53 DOWNTO 1);
      ccexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
      ccsgn : OUT STD_LOGIC;
      zeroout : OUT STD_LOGIC
     );
END dp_ln_core;

ARCHITECTURE rtl OF dp_ln_core IS

  signal zerovec : STD_LOGIC_VECTOR (64 DOWNTO 1);
  --*** INPUT BLOCK ***
  signal aamanff : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal aaexpff : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal aaexpabsff : STD_LOGIC_VECTOR (10 DOWNTO 1);
  signal aaexppos, aaexpneg : STD_LOGIC_VECTOR (12 DOWNTO 1);
  signal aaexpabs : STD_LOGIC_VECTOR (10 DOWNTO 1);
  --*** TABLES ***
  signal lutpowaddff : STD_LOGIC_VECTOR (10 DOWNTO 1);
  signal lutoneaddff, luttwoaddff : STD_LOGIC_VECTOR (9 DOWNTO 1);
  signal lutpowmanff, lutonemanff, luttwomanff : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal lutpowexpff, lutoneexpff, luttwoexpff : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal lutoneinvff : STD_LOGIC_VECTOR (12 DOWNTO 1); 
  signal luttwoinvff : STD_LOGIC_VECTOR (18 DOWNTO 1);  
  signal lutpowmannode, lutonemannode, luttwomannode : STD_LOGIC_VECTOR (52 DOWNTO 1);
  signal lutpowexpnode, lutoneexpnode, luttwoexpnode : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal lutoneinvnode : STD_LOGIC_VECTOR (12 DOWNTO 1); 
  signal luttwoinvnode : STD_LOGIC_VECTOR (18 DOWNTO 1);   
  signal aanum, aanumdel : STD_LOGIC_VECTOR (54 DOWNTO 1); 
  signal invonenum : STD_LOGIC_VECTOR (18 DOWNTO 1); 
  signal mulonenode : STD_LOGIC_VECTOR (65 DOWNTO 1);
  signal mulonenormff : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal mulonenumdel : STD_LOGIC_VECTOR (54 DOWNTO 1);
  signal multwonode : STD_LOGIC_VECTOR (72 DOWNTO 1); 
  signal multwonormff : STD_LOGIC_VECTOR (71 DOWNTO 1);
  --*** SERIES ***
  signal squaredterm : STD_LOGIC_VECTOR (48 DOWNTO 1);
  signal onethird : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal scaledterm, scaledtermdel : STD_LOGIC_VECTOR (18 DOWNTO 1);
  signal cubedterm : STD_LOGIC_VECTOR (32 DOWNTO 1);
  signal xtermdel : STD_LOGIC_VECTOR (54 DOWNTO 1);   
  signal oneterm, twoterm, thrterm : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal oneplustwoterm : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal seriesterm : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal mantissaseries : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentseries : STD_LOGIC_VECTOR (11 DOWNTO 1);          
  --*** ADD LOGS ***
  signal zeropow, zeroone, zerotwo : STD_LOGIC;
  signal mantissapowernode : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal mantissapower : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentpower : STD_LOGIC_VECTOR (11 DOWNTO 1); 
  signal numberone, numberonedel : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal mantissaone : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentone : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal mantissaaddone : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentaddone : STD_LOGIC_VECTOR (11 DOWNTO 1); 
  signal mantissatwo : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponenttwo : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal numbertwo, numbertwodel : STD_LOGIC_VECTOR (75 DOWNTO 1);
  signal mantissaaddtwo : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentaddtwo : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal numberthr, numberthrdel : STD_LOGIC_VECTOR (75 DOWNTO 1);
  signal mantissasum : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal mantissasumabs : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentsum : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal mantissanorm : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal exponentnorm : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal zeronorm : STD_LOGIC;
  signal signff : STD_LOGIC_VECTOR (25+7*doublespeed DOWNTO 1);
  
  component dp_lnlutpow
  PORT (
        add : IN STD_LOGIC_VECTOR (10 DOWNTO 1);
        logman : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        logexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
       );
  end component;
  
  component dp_lnlut9
  PORT (
        add : IN STD_LOGIC_VECTOR (9 DOWNTO 1);
        inv : OUT STD_LOGIC_VECTOR (12 DOWNTO 1);
        logman : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        logexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
       );
  end component;

  component dp_lnlut18
  PORT (
        add : IN STD_LOGIC_VECTOR (9 DOWNTO 1);
        inv : OUT STD_LOGIC_VECTOR (18 DOWNTO 1);
        logman : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
        logexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
       );
  end component;
  
  component fp_del
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
  component dp_fxadd 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1;
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
  component dp_fxsub
  GENERIC (
           width : positive := 64;
           pipes : positive := 1;
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        borrowin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
 
  component fp_fxmul
  GENERIC (
           widthaa : positive := 18;
           widthbb : positive := 18;
           widthcc : positive := 36;
           pipes : positive := 1;
           accuracy : integer := 0; -- 0 = pruned multiplier, 1 = normal multiplier
           device : integer := 0; -- 0 = "Stratix II", 1 = "Stratix III" (also 4)
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        dataaa : IN STD_LOGIC_VECTOR (widthaa DOWNTO 1);
        databb : IN STD_LOGIC_VECTOR (widthbb DOWNTO 1); 
      
        result : OUT STD_LOGIC_VECTOR (widthcc DOWNTO 1)
       );
  end component;
   
  component dp_lnadd
  GENERIC (
           speed : integer := 1; -- '0' for unpiped adder, '1' for piped adder
           synthesize : integer := 1
          ); 
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aaman : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        aaexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
        bbman : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        bbexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);

	     ccman : OUT STD_LOGIC_VECTOR (64 DOWNTO 1);
	     ccexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
	   );
	end component;
	
  component dp_lnnorm
  GENERIC (
           speed : integer := 1
          ); 
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        inman : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        inexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      
        outman : OUT STD_LOGIC_VECTOR (64 DOWNTO 1);
        outexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1);
        zero : OUT STD_LOGIC
      );	
  end component;
                  
BEGIN
  
  gza: FOR k IN 1 TO 64 GENERATE
    zerovec(k) <= '0';
  END GENERATE;
  
  --*******************
  --*** INPUT BLOCK ***
  --*******************
  
  ppin: PROCESS (sysclk,reset)
  BEGIN
  
    IF (reset = '1') THEN
        
      FOR k IN 1 TO 52 LOOP
        aamanff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP
        aaexpff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 10 LOOP
        aaexpabsff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
     
      IF (enable = '1') THEN       
      
        aamanff <= aaman;  -- level 1
        aaexpff <= aaexp;  -- level 1
      
        aaexpabsff <= aaexpabs;  -- level 2
      
      END IF;
 
    END IF;
    
  END PROCESS;
  
  aaexppos <= ('0' & aaexpff) - "001111111111";
  aaexpneg <= "001111111111" - ('0' & aaexpff);
  gaba: FOR k IN 1 TO 10 GENERATE
    aaexpabs(k) <= (aaexppos(k) AND NOT(aaexppos(12))) OR (aaexpneg(k) AND aaexppos(12));
  END GENERATE;

  --******************************************
  --*** RANGE REDUCTION THROUGH LUT SERIES ***
  --******************************************
    
  plut: PROCESS (sysclk,reset)
  BEGIN
  
    IF (reset = '1') THEN
       
      FOR k IN 1 TO 10 LOOP 
        lutpowaddff(k) <= '0'; 
      END LOOP;
      FOR k IN 1 TO 9 LOOP
        lutoneaddff(k) <= '0';
        luttwoaddff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 52 LOOP
        lutpowmanff(k) <= '0';
        lutonemanff(k) <= '0';
        luttwomanff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP
        lutpowexpff(k) <= '0';
        lutoneexpff(k) <= '0';
        luttwoexpff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 12 LOOP
        lutoneinvff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 18 LOOP
        luttwoinvff(k) <= '0';
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
            
      IF (enable = '1') THEN
          
        lutpowaddff <= aaexpabsff;  -- level 3
        lutoneaddff <= aamanff(52 DOWNTO 44);  -- level 2
        luttwoaddff <= mulonenormff(55 DOWNTO 47);  -- level 8+speed
      
        lutpowmanff <= lutpowmannode;  -- level 4
        lutpowexpff <= lutpowexpnode; -- level 4
      
        lutoneinvff <= lutoneinvnode;  -- level 3
        lutonemanff <= lutonemannode;  -- level 3
        lutoneexpff <= lutoneexpnode; -- level 3
      
        luttwoinvff <= luttwoinvnode;  -- level 9+speed
        luttwomanff <= luttwomannode;  -- level 9+speed
        luttwoexpff <= luttwoexpnode; -- level 9+speed
      
      END IF;
      
    END IF;
    
  END PROCESS;
  
  lutpow: dp_lnlutpow
  PORT MAP (add=>lutpowaddff,
            logman=>lutpowmannode,logexp=>lutpowexpnode);

  lutone: dp_lnlut9
  PORT MAP (add=>lutoneaddff,
            inv=>lutoneinvnode,logman=>lutonemannode,logexp=>lutoneexpnode);
 
  luttwo: dp_lnlut18
  PORT MAP (add=>luttwoaddff,
            inv=>luttwoinvnode,logman=>luttwomannode,logexp=>luttwoexpnode);
           
  aanum <= '1' & aamanff & '0'; 
  
  -- level 1 in, level 3 out
  delone: fp_del
  GENERIC MAP (width=>54,pipes=>2)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>aanum,cc=>aanumdel);
   
  invonenum <= lutoneinvff & "000000";
  
  --mulone <= aanum * invone; -- 53*12 = 65
  
  -- level 3 in, level 6+doublespeed out
  mulone: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>18,widthcc=>65,
               pipes=>3+doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>aanumdel,databb=>invonenum,
            result=>mulonenode);

  --multwo <= mulonenorm(64 DOWNTO 11) * invtwo;  -- 54x18=72
  
  -- level 7+speed in, level 9+speed out
  deltwo: fp_del
  GENERIC MAP (width=>54,pipes=>2)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>mulonenormff(64 DOWNTO 11),cc=>mulonenumdel);
  
  -- level 9+doublespeed in, level 12+2*doublespeed out
  multwo: fp_fxmul
  GENERIC MAP (widthaa=>54,widthbb=>18,widthcc=>72,
               pipes=>3+doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>mulonenumdel,databb=>luttwoinvff,
            result=>multwonode);

  pmna: PROCESS (sysclk,reset)
  BEGIN
  
    IF (reset = '1') THEN
        
      FOR k IN 1 TO 64 LOOP
        mulonenormff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 71 LOOP
        multwonormff(k) <= '0';
      END LOOP;
   
    ELSIF (rising_edge(sysclk)) THEN
     
      IF (enable = '1') THEN
        
        -- normalize in case input is 1.000000 and inv is 0.5  
        -- level 7+speed
        FOR k IN 1 TO 64 LOOP
          mulonenormff(k) <= (mulonenode(k+1) AND mulonenode(65)) OR 
                             (mulonenode(k) AND NOT(mulonenode(65)));
        END LOOP;
        -- level 13+2*speed
        FOR k IN 1 TO 71 LOOP
          multwonormff(k) <= (multwonode(k+1) AND multwonode(72)) OR 
                             (multwonode(k) AND NOT(multwonode(72)));
        END LOOP;
         
      END IF;       
    END IF;
    
  END PROCESS;  
           
  --************************************
  --*** TAYLOR SERIES OF SMALL RANGE ***
  --************************************
  
  -- taylor series expansion of subrange (36 bits)
  -- x - x*x/2
  -- 16 leading bits, so x*x 16 bits down, +1 bit for 1/2
  -- 36 lower bits in multwo(54:19)
  
  --square <= multwonorm(54 DOWNTO 19) * multwonorm(54 DOWNTO 19);
  
  -- level 13+2*doublespeed in, 16+2*doublespeed out
  multhr: fp_fxmul
  GENERIC MAP (widthaa=>36,widthbb=>36,widthcc=>48,
               pipes=>3,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>multwonormff(54 DOWNTO 19),databb=>multwonormff(54 DOWNTO 19),
            result=>squaredterm);
  
  onethird <= "010101010101010101";
            
  -- level 13+2*doublespeed in, level 15+2*doublespeed out
  mulfor: fp_fxmul
  GENERIC MAP (widthaa=>18,widthbb=>18,widthcc=>18,
               pipes=>2,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>multwonormff(54 DOWNTO 37),databb=>onethird,
            result=>scaledterm);
  
  --level 15+2*doublespeed in, level 16+2*doublespeed out
  delthr: fp_del
  GENERIC MAP (width=>18,pipes=>1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>scaledterm,cc=>scaledtermdel);
            
  -- level 16+2*doublespeed in, level 18+2*doublespeed out
  mulfiv: fp_fxmul
  GENERIC MAP (widthaa=>18,widthbb=>18,widthcc=>32,
               pipes=>2,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            dataaa=>squaredterm(48 DOWNTO 31),databb=>scaledtermdel,
            result=>cubedterm);
            
  --level 13+2*doublespeed in, level 16+2*doublespeed out
  delfor: fp_del
  GENERIC MAP (width=>54,pipes=>3)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>multwonormff(54 DOWNTO 1),cc=>xtermdel); 
   
  -- level 16+2*doublespeed         
  oneterm <= xtermdel & zerovec(10 DOWNTO 1);
  twoterm <= zerovec(17 DOWNTO 1) & squaredterm(48 DOWNTO 2); -- x*x/2
  -- level 18+2*doublespeed
  thrterm <= zerovec(32 DOWNTO 1) & cubedterm;
  
  --level 16+2*doublespeed in, level 18+2*doublespeed out
  tayone: dp_fxsub
  GENERIC MAP (width=>64,pipes=>2,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>oneterm,bb=>twoterm,borrowin=>'1',
            cc=>oneplustwoterm); 
  
  --level 18+2*doublespeed in, level 19+3*doublespeed out
  taytwo: dp_fxadd
  GENERIC MAP (width=>64,pipes=>1+doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>oneplustwoterm,bb=>thrterm,carryin=>'0',
            cc=>seriesterm); 
            
  --mantissaseries <= seriesterm;
  mantissaseries <= '0' & seriesterm(64 DOWNTO 2);
  exponentseries <= conv_std_logic_vector (1006,11); 
            
  --18x18
  --cubed <= square(72 DOWNTO 55) * multwonorm(54 DOWNTO 37);
  --cubedscale <= cubed(36 DOWNTO 19) * onethird;
  
  --**************************
  --*** ADD ALL LOGARITHMS ***
  --**************************
  
  zeropow <= lutpowexpff(11) OR lutpowexpff(10) OR lutpowexpff(9) OR 
             lutpowexpff(8) OR lutpowexpff(7) OR lutpowexpff(6) OR 
             lutpowexpff(5) OR lutpowexpff(4) OR lutpowexpff(3) OR 
             lutpowexpff(2) OR lutpowexpff(1);
             
  -- level 4
  --mantissapower <= zeropow & lutpowmanff & zerovec(11 DOWNTO 1);
  --mantissapower <= '0' & zeropow & lutpowmanff & zerovec(10 DOWNTO 1);
  mantissapowernode <= '0' & zeropow & lutpowmanff & zerovec(10 DOWNTO 1);
  gmpz: FOR k IN 1 TO 64 GENERATE
    mantissapower(k) <= mantissapowernode(k) XOR signff(3);
  END GENERATE;
  exponentpower <= lutpowexpff;
  
  zeroone <= lutoneexpff(11) OR lutoneexpff(10) OR lutoneexpff(9) OR 
             lutoneexpff(8) OR lutoneexpff(7) OR lutoneexpff(6) OR 
             lutoneexpff(5) OR lutoneexpff(4) OR lutoneexpff(3) OR 
             lutoneexpff(2) OR lutoneexpff(1);
             
  -- level 3
  numberone <= zeroone & lutonemanff & lutoneexpff;
  
  -- level 3 in, level 4 out
  delfiv: fp_del
  GENERIC MAP (width=>64,pipes=>1)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>numberone,cc=>numberonedel);
            
  --mantissaone <= numberonedel(64 DOWNTO 12) & zerovec(11 DOWNTO 1);
  mantissaone <= '0' & numberonedel(64 DOWNTO 12) & zerovec(10 DOWNTO 1);
  exponentone <= numberonedel(11 DOWNTO 1); 
  
  -- level 4 in, level 10 out
  addone: dp_lnadd
  GENERIC MAP (speed=>1,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aaman=>mantissapower,aaexp=>exponentpower,
            bbman=>mantissaone,bbexp=>exponentone,
            ccman=>mantissaaddone,ccexp=>exponentaddone);
           
  zerotwo <= luttwoexpff(11) OR luttwoexpff(10) OR luttwoexpff(9) OR 
             luttwoexpff(8) OR luttwoexpff(7) OR luttwoexpff(6) OR 
             luttwoexpff(5) OR luttwoexpff(4) OR luttwoexpff(3) OR 
             luttwoexpff(2) OR luttwoexpff(1);
             
  -- level 9+doublespeed
  --mantissatwo <= zerotwo & luttwomanff & zerovec(11 DOWNTO 1);
  mantissatwo <= '0' & zerotwo & luttwomanff & zerovec(10 DOWNTO 1);
  exponenttwo <= luttwoexpff;

  numbertwo <= mantissatwo & exponenttwo;
    
  gasa: IF (doublespeed = 0) GENERATE
    delsix: fp_del
    GENERIC MAP (width=>75,pipes=>1)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>numbertwo,cc=>numbertwodel);
  END GENERATE;
  gasb: IF (doublespeed = 1) GENERATE
    numbertwodel <= numbertwo;
  END GENERATE;

  -- level 10 in, level 16 out
  addtwo: dp_lnadd
  GENERIC MAP (speed=>1,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aaman=>mantissaaddone,aaexp=>exponentaddone,
            bbman=>numbertwodel(75 DOWNTO 12),bbexp=>numbertwodel(11 DOWNTO 1),
            ccman=>mantissaaddtwo,ccexp=>exponentaddtwo);
            
  numberthr <= mantissaaddtwo & exponentaddtwo;

  -- level 16 in, level 19+3*doublespeed out
  delsev: fp_del
  GENERIC MAP (width=>75,pipes=>3+3*doublespeed)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>numberthr,cc=>numberthrdel);
              
  -- level 19+3*doublespeed in, level 23+5*doublespeed out
  addthr: dp_lnadd
  GENERIC MAP (speed=>doublespeed,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aaman=>mantissaseries,aaexp=>exponentseries,
            bbman=>numberthrdel(75 DOWNTO 12),bbexp=>numberthrdel(11 DOWNTO 1),
            ccman=>mantissasum,ccexp=>exponentsum);            

  gmsa: FOR k IN 1 TO 64 GENERATE
    mantissasumabs(k) <= mantissasum(k) XOR signff(22+5*doublespeed);
  END GENERATE;
  
  -- level 23+5*doublespeed in, level 26+7*doublespeed out
  norm: dp_lnnorm
  GENERIC MAP (speed=>doublespeed)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            inman=>mantissasumabs,inexp=>exponentsum,
            outman=>mantissanorm,outexp=>exponentnorm,
            zero=>zeronorm);
  
  psgna: PROCESS (sysclk, reset)
  BEGIN
      
    IF (reset = '1') THEN
      FOR k IN 1 TO 25+7*doublespeed LOOP
        signff(k) <= '0';
      END LOOP;
    ELSIF (rising_edge(sysclk)) THEN
      signff(1) <= aaexppos(12);
      FOR k IN 2 TO 25+7*doublespeed LOOP
        signff(k) <= signff(k-1);
      END LOOP;    
    END IF;
    
  END PROCESS;

  --***************  
  --*** OUTPUTS ***
  --***************
  
  ccman <= mantissanorm(63 DOWNTO 11);
  ccexp <= exponentnorm;          
  ccsgn <= signff(25+7*doublespeed);
  zeroout <= zeronorm;
  
END rtl;


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_LNADD.VHD                              ***
--***                                             ***
--***   Function: Double Precision Addition of    ***
--***   LN elements                               ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

--***************************************************
--*** Notes:                                      ***
--*** Latency = 4 + 2*Speed                       ***
--***************************************************

ENTITY dp_lnadd IS 
GENERIC (
         speed : integer := 1; -- '0' for unpiped adder, '1' for piped adder
         synthesize : integer := 1
        ); 
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      aaman : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
      aaexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);
      bbman : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
      bbexp : IN STD_LOGIC_VECTOR (11 DOWNTO 1);

	   ccman : OUT STD_LOGIC_VECTOR (64 DOWNTO 1);
	   ccexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
	 );
END dp_lnadd;

ARCHITECTURE rtl OF dp_lnadd IS
  
  type expbasefftype IS ARRAY (3+2*speed DOWNTO 1) OF STD_LOGIC_VECTOR (13 DOWNTO 1);
  
  signal aamanff, bbmanff : STD_LOGIC_VECTOR (64 DOWNTO 1); 
  signal aaexpff, bbexpff : STD_LOGIC_VECTOR (11 DOWNTO 1);  
  signal manleftff, manrightff : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal aluleftff, alurightff : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal expbaseff : expbasefftype;
  signal shiftff : STD_LOGIC_VECTOR (5 DOWNTO 1);
  signal subexpone, subexptwo : STD_LOGIC_VECTOR (12 DOWNTO 1);
  signal switch : STD_LOGIC;
  signal shiftleftnode, shiftrightnode : STD_LOGIC_VECTOR (64 DOWNTO 1);
  signal alunode : STD_LOGIC_VECTOR (64 DOWNTO 1);
  
    component dp_rsft64x5 IS 
  PORT (
        inbus : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (5 DOWNTO 1);
        outbus : OUT STD_LOGIC_VECTOR (64 DOWNTO 1)
      );
  end component;
  
  component dp_rsft64x5pipe IS 
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        inbus : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
        shift : IN STD_LOGIC_VECTOR (5 DOWNTO 1);
        outbus : OUT STD_LOGIC_VECTOR (64 DOWNTO 1)
      );
  end component;

  component fp_del
  GENERIC (
           width : positive := 64;
           pipes : positive := 1
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
  
  component dp_fxadd 
  GENERIC (
           width : positive := 64;
           pipes : positive := 1;
           synthesize : integer := 0
          );
  PORT (
        sysclk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        enable : IN STD_LOGIC;
        aa, bb : IN STD_LOGIC_VECTOR (width DOWNTO 1); 
        carryin : IN STD_LOGIC;
      
        cc : OUT STD_LOGIC_VECTOR (width DOWNTO 1)
       );
  end component;
     
BEGIN
     
  paa: PROCESS (sysclk, reset)
  BEGIN
      
    IF (reset = '1') THEN
       
      FOR k IN 1 TO 64 LOOP 
        aamanff(k) <= '0';
        bbmanff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP 
        aaexpff(k) <= '0';
        bbexpff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 64 LOOP
        manleftff(k) <= '0';
        manrightff(k) <= '0';
        aluleftff(k) <= '0';
        alurightff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP
        FOR j IN 1 TO 3+speed LOOP
          expbaseff(j)(k) <= '0';
        END LOOP;
      END LOOP;
      shiftff <= "00000";
        
    ELSIF (rising_edge(sysclk)) THEN
            
      IF (enable = '1') THEN
          
        --*** LEVEL 1 ***
        aamanff <= aaman;
        bbmanff <= bbman;
        aaexpff <= aaexp;
        bbexpff <= bbexp;
        
        --*** LEVEL 2 ***
        FOR k IN 1 TO 64 LOOP
          manleftff(k) <= (aamanff(k) AND NOT(switch)) OR (bbmanff(k) AND switch);
          manrightff(k) <= (bbmanff(k) AND NOT(switch)) OR (aamanff(k) AND switch);
        END LOOP;
          
        FOR k IN 1 TO 11 LOOP
          expbaseff(1)(k) <= (aaexpff(k) AND NOT(switch)) OR (bbexpff(k) AND switch); 
        END LOOP;
        FOR k IN 2 TO (3+2*speed) LOOP
          expbaseff(k)(11 DOWNTO 1) <= expbaseff(k-1)(11 DOWNTO 1);  -- level 3 to 4/6
        END LOOP;
        
        FOR k IN 1 TO 5 LOOP
          shiftff(k) <= (subexpone(k) AND NOT(switch)) OR (subexptwo(k) AND switch);
        END LOOP;
        
        aluleftff <= shiftleftnode;
        alurightff <= shiftrightnode;
      
      END IF;
        
    END IF;
      
  END PROCESS;
  
  subexpone <= ('0' & aaexpff) - ('0' & bbexpff);
  subexptwo <= ('0' & bbexpff) - ('0' & aaexpff);

  switch <= subexpone(12);

  gsa: IF (speed = 0) GENERATE
  
    shifter: dp_rsft64x5
    PORT MAP (inbus=>manrightff,shift=>shiftff,
              outbus=>shiftrightnode);
              
    shiftleftnode <= manleftff;
              
  END GENERATE;

  gsb: IF (speed = 1) GENERATE
  
    shifter: dp_rsft64x5pipe
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              inbus=>manrightff,shift=>shiftff,
              outbus=>shiftrightnode);
   
    sftdel: fp_del
    GENERIC MAP (width=>64,pipes=>1)
    PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
              aa=>manleftff,
              cc=>shiftleftnode);

  END GENERATE;

  -- level 3+speed in, level 4+2*speed out
  adder: dp_fxadd
  GENERIC MAP (width=>64,pipes=>speed+1,synthesize=>synthesize)
  PORT MAP (sysclk=>sysclk,reset=>reset,enable=>enable,
            aa=>aluleftff,bb=>alurightff,carryin=>'0',
            cc=>alunode);

  --*** OUTPUTS ***
  ccman <= alunode;
  ccexp <= expbaseff(3+2*speed)(11 DOWNTO 1);

END rtl;


LIBRARY ieee;
LIBRARY work;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_signed.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_LNCLZ.VHD                              ***
--***                                             ***
--***   Function: Double Precision CLZ (no pipe)  ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_lnclz IS
PORT (
      mantissa : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
      
      leading : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
     );
END dp_lnclz;

ARCHITECTURE rtl of dp_lnclz IS

  type positiontype IS ARRAY (11 DOWNTO 1) OF STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  signal position, positionmux : positiontype;
  signal zerogroup, firstzero : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal lastman : STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  component dp_pos
  GENERIC (start: integer := 0);
  PORT 
       (
        ingroup : IN STD_LOGIC_VECTOR (6 DOWNTO 1); 
        
        position : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
       );
  end component;
  
BEGIN
     
  zerogroup(1) <= mantissa(64) OR mantissa(63) OR mantissa(62) OR mantissa(61) OR mantissa(60) OR mantissa(59);
  zerogroup(2) <= mantissa(58) OR mantissa(57) OR mantissa(56) OR mantissa(55) OR mantissa(54) OR mantissa(53);
  zerogroup(3) <= mantissa(52) OR mantissa(51) OR mantissa(50) OR mantissa(49) OR mantissa(48) OR mantissa(47);
  zerogroup(4) <= mantissa(46) OR mantissa(45) OR mantissa(44) OR mantissa(43) OR mantissa(42) OR mantissa(41);
  zerogroup(5) <= mantissa(40) OR mantissa(39) OR mantissa(38) OR mantissa(37) OR mantissa(36) OR mantissa(35);
  zerogroup(6) <= mantissa(34) OR mantissa(33) OR mantissa(32) OR mantissa(31) OR mantissa(30) OR mantissa(29);
  zerogroup(7) <= mantissa(28) OR mantissa(27) OR mantissa(26) OR mantissa(25) OR mantissa(24) OR mantissa(23);
  zerogroup(8) <= mantissa(22) OR mantissa(21) OR mantissa(20) OR mantissa(19) OR mantissa(18) OR mantissa(17);
  zerogroup(9) <= mantissa(16) OR mantissa(15) OR mantissa(14) OR mantissa(13) OR mantissa(12) OR mantissa(11);
  zerogroup(10) <= mantissa(10) OR mantissa(9) OR mantissa(8) OR mantissa(7) OR mantissa(6) OR mantissa(5);
  zerogroup(11) <= mantissa(4) OR mantissa(3) OR mantissa(2) OR mantissa(1);

  pa: dp_pos 
  GENERIC MAP (start=>0) 
  PORT MAP (ingroup=>mantissa(64 DOWNTO 59),position=>position(1)(6 DOWNTO 1));
  pb: dp_pos 
  GENERIC MAP (start=>6) 
  PORT MAP (ingroup=>mantissa(58 DOWNTO 53),position=>position(2)(6 DOWNTO 1));
  pc: dp_pos 
  GENERIC MAP (start=>12) 
  PORT MAP (ingroup=>mantissa(52 DOWNTO 47),position=>position(3)(6 DOWNTO 1));
  pd: dp_pos 
  GENERIC MAP (start=>18) 
  PORT MAP (ingroup=>mantissa(46 DOWNTO 41),position=>position(4)(6 DOWNTO 1));
  pe: dp_pos 
  GENERIC MAP (start=>24) 
  PORT MAP (ingroup=>mantissa(40 DOWNTO 35),position=>position(5)(6 DOWNTO 1));
  pf: dp_pos 
  GENERIC MAP (start=>30) 
  PORT MAP (ingroup=>mantissa(34 DOWNTO 29),position=>position(6)(6 DOWNTO 1));
  pg: dp_pos 
  GENERIC MAP (start=>36) 
  PORT MAP (ingroup=>mantissa(28 DOWNTO 23),position=>position(7)(6 DOWNTO 1));
  ph: dp_pos 
  GENERIC MAP (start=>42) 
  PORT MAP (ingroup=>mantissa(22 DOWNTO 17),position=>position(8)(6 DOWNTO 1));
  pi: dp_pos 
  GENERIC MAP (start=>48) 
  PORT MAP (ingroup=>mantissa(16 DOWNTO 11),position=>position(9)(6 DOWNTO 1));
  pj: dp_pos 
  GENERIC MAP (start=>54) 
  PORT MAP (ingroup=>mantissa(10 DOWNTO 5),position=>position(10)(6 DOWNTO 1));
  pk: dp_pos 
  GENERIC MAP (start=>60) 
  PORT MAP (ingroup=>lastman,position=>position(11)(6 DOWNTO 1));
      
  lastman <= mantissa(4 DOWNTO 1) & "00";

  firstzero(1) <= zerogroup(1);
  firstzero(2) <= NOT(zerogroup(1)) AND zerogroup(2);
  firstzero(3) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND zerogroup(3);
  firstzero(4) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND zerogroup(4);
  firstzero(5) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND zerogroup(5);
  firstzero(6) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND zerogroup(6);                
  firstzero(7) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND zerogroup(7); 
  firstzero(8) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND zerogroup(8); 
  firstzero(9) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                  AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND NOT(zerogroup(8)) 
                  AND zerogroup(9); 
  firstzero(10) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                   AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND NOT(zerogroup(8)) 
                   AND NOT(zerogroup(9)) AND zerogroup(10); 
  firstzero(11) <= NOT(zerogroup(1)) AND NOT(zerogroup(2)) AND NOT(zerogroup(3)) AND NOT(zerogroup(4)) 
                   AND NOT(zerogroup(5)) AND NOT(zerogroup(6)) AND NOT(zerogroup(7)) AND NOT(zerogroup(8)) 
                   AND NOT(zerogroup(9)) AND NOT(zerogroup(10)) AND zerogroup(11); 
                
gma: FOR k IN 1 TO 6 GENERATE
  positionmux(1)(k) <= position(1)(k) AND firstzero(1);
  gmb: FOR j IN 2 TO 11 GENERATE
    positionmux(j)(k) <= positionmux(j-1)(k) OR (position(j)(k) AND firstzero(j));
  END GENERATE;
END GENERATE;
  
leading <= positionmux(11)(6 DOWNTO 1);
                                               
END rtl;


LIBRARY ieee;
LIBRARY work;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_signed.all;
USE ieee.std_logic_arith.all; 

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_LNCLZPIPE.VHD                          ***
--***                                             ***
--***   Function: Double Precision CLZ pipelined  ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_lnclzpipe IS
PORT (
      sysclk : IN STD_LOGIC;
      reset : IN STD_LOGIC;
      enable : IN STD_LOGIC;
      mantissa : IN STD_LOGIC_VECTOR (64 DOWNTO 1);
      
      leading : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
     );
END dp_lnclzpipe;

ARCHITECTURE rtl of dp_lnclzpipe IS

  type positiontype IS ARRAY (11 DOWNTO 1) OF STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  signal position, positionff, positionmux : positiontype;
  signal zerogroup, zerogroupff, firstzero : STD_LOGIC_VECTOR (11 DOWNTO 1);
  signal lastman : STD_LOGIC_VECTOR (6 DOWNTO 1);
  
  component dp_pos
  GENERIC (start: integer := 0);
  PORT 
       (
        ingroup : IN STD_LOGIC_VECTOR (6 DOWNTO 1); 
        
        position : OUT STD_LOGIC_VECTOR (6 DOWNTO 1)    
       );
  end component;
  
BEGIN
     
  zerogroup(1) <= mantissa(64) OR mantissa(63) OR mantissa(62) OR mantissa(61) OR mantissa(60) OR mantissa(59);
  zerogroup(2) <= mantissa(58) OR mantissa(57) OR mantissa(56) OR mantissa(55) OR mantissa(54) OR mantissa(53);
  zerogroup(3) <= mantissa(52) OR mantissa(51) OR mantissa(50) OR mantissa(49) OR mantissa(48) OR mantissa(47);
  zerogroup(4) <= mantissa(46) OR mantissa(45) OR mantissa(44) OR mantissa(43) OR mantissa(42) OR mantissa(41);
  zerogroup(5) <= mantissa(40) OR mantissa(39) OR mantissa(38) OR mantissa(37) OR mantissa(36) OR mantissa(35);
  zerogroup(6) <= mantissa(34) OR mantissa(33) OR mantissa(32) OR mantissa(31) OR mantissa(30) OR mantissa(29);
  zerogroup(7) <= mantissa(28) OR mantissa(27) OR mantissa(26) OR mantissa(25) OR mantissa(24) OR mantissa(23);
  zerogroup(8) <= mantissa(22) OR mantissa(21) OR mantissa(20) OR mantissa(19) OR mantissa(18) OR mantissa(17);
  zerogroup(9) <= mantissa(16) OR mantissa(15) OR mantissa(14) OR mantissa(13) OR mantissa(12) OR mantissa(11);
  zerogroup(10) <= mantissa(10) OR mantissa(9) OR mantissa(8) OR mantissa(7) OR mantissa(6) OR mantissa(5);
  zerogroup(11) <= mantissa(4) OR mantissa(3) OR mantissa(2) OR mantissa(1);

  pa: dp_pos 
  GENERIC MAP (start=>0) 
  PORT MAP (ingroup=>mantissa(64 DOWNTO 59),position=>position(1)(6 DOWNTO 1));
  pb: dp_pos 
  GENERIC MAP (start=>6) 
  PORT MAP (ingroup=>mantissa(58 DOWNTO 53),position=>position(2)(6 DOWNTO 1));
  pc: dp_pos 
  GENERIC MAP (start=>12) 
  PORT MAP (ingroup=>mantissa(52 DOWNTO 47),position=>position(3)(6 DOWNTO 1));
  pd: dp_pos 
  GENERIC MAP (start=>18) 
  PORT MAP (ingroup=>mantissa(46 DOWNTO 41),position=>position(4)(6 DOWNTO 1));
  pe: dp_pos 
  GENERIC MAP (start=>24) 
  PORT MAP (ingroup=>mantissa(40 DOWNTO 35),position=>position(5)(6 DOWNTO 1));
  pf: dp_pos 
  GENERIC MAP (start=>30) 
  PORT MAP (ingroup=>mantissa(34 DOWNTO 29),position=>position(6)(6 DOWNTO 1));
  pg: dp_pos 
  GENERIC MAP (start=>36) 
  PORT MAP (ingroup=>mantissa(28 DOWNTO 23),position=>position(7)(6 DOWNTO 1));
  ph: dp_pos 
  GENERIC MAP (start=>42) 
  PORT MAP (ingroup=>mantissa(22 DOWNTO 17),position=>position(8)(6 DOWNTO 1));
  pi: dp_pos 
  GENERIC MAP (start=>48) 
  PORT MAP (ingroup=>mantissa(16 DOWNTO 11),position=>position(9)(6 DOWNTO 1));
  pj: dp_pos 
  GENERIC MAP (start=>54) 
  PORT MAP (ingroup=>mantissa(10 DOWNTO 5),position=>position(10)(6 DOWNTO 1));
  pk: dp_pos 
  GENERIC MAP (start=>60) 
  PORT MAP (ingroup=>lastman,position=>position(11)(6 DOWNTO 1));
      
  lastman <= mantissa(4 DOWNTO 1) & "00";

  ppa: PROCESS (sysclk,reset)
  BEGIN
      
    IF (reset = '1') THEN
        
      FOR k IN 1 TO 11 LOOP
        zerogroupff(k) <= '0';
      END LOOP;
      FOR k IN 1 TO 11 LOOP
        FOR j IN 1 TO 6 LOOP
          positionff(k)(j) <= '0';
        END LOOP;
      END LOOP;
      
    ELSIF (rising_edge(sysclk)) THEN
    
      zerogroupff <= zerogroup;
      FOR k IN 1 TO 11 LOOP
        positionff(k)(6 DOWNTO 1) <= position(k)(6 DOWNTO 1);
      END LOOP;
              
    END IF;
      
  END PROCESS;
  
  firstzero(1) <= zerogroupff(1);
  firstzero(2) <= NOT(zerogroupff(1)) AND zerogroupff(2);
  firstzero(3) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND zerogroupff(3);
  firstzero(4) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND zerogroupff(4);
  firstzero(5) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND 
                  NOT(zerogroupff(4)) AND zerogroupff(5);
  firstzero(6) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND 
                  NOT(zerogroupff(4)) AND NOT(zerogroupff(5)) AND zerogroupff(6);                
  firstzero(7) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND 
                  NOT(zerogroupff(4)) AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND zerogroupff(7); 
  firstzero(8) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND 
                  NOT(zerogroupff(4)) AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND 
                  NOT(zerogroupff(7)) AND zerogroupff(8); 
  firstzero(9) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND 
                  NOT(zerogroupff(4)) AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND 
                  NOT(zerogroupff(7)) AND NOT(zerogroupff(8)) AND zerogroupff(9); 
  firstzero(10) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND 
                   NOT(zerogroupff(4)) AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND 
                   NOT(zerogroupff(7)) AND NOT(zerogroupff(8)) AND NOT(zerogroupff(9)) AND zerogroupff(10); 
  firstzero(11) <= NOT(zerogroupff(1)) AND NOT(zerogroupff(2)) AND NOT(zerogroupff(3)) AND 
                   NOT(zerogroupff(4)) AND NOT(zerogroupff(5)) AND NOT(zerogroupff(6)) AND 
                   NOT(zerogroupff(7)) AND NOT(zerogroupff(8)) AND NOT(zerogroupff(9)) AND 
                   NOT(zerogroupff(10)) AND zerogroupff(11); 
                
gma: FOR k IN 1 TO 6 GENERATE
  positionmux(1)(k) <= positionff(1)(k) AND firstzero(1);
  gmb: FOR j IN 2 TO 11 GENERATE
    positionmux(j)(k) <= positionmux(j-1)(k) OR (positionff(j)(k) AND firstzero(j));
  END GENERATE;
END GENERATE;
  
leading <= positionmux(11)(6 DOWNTO 1);
                                               
END rtl;

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_LNLUT18.VHD                            ***
--***                                             ***
--***   Function: Look Up Table - LN()            ***
--***                                             ***
--***   Generated by MATLAB Utility               ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_lnlut18 IS
PORT (
      add : IN STD_LOGIC_VECTOR (9 DOWNTO 1);
      inv : OUT STD_LOGIC_VECTOR (18 DOWNTO 1);
      logman : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      logexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
     );
END dp_lnlut18;

ARCHITECTURE rtl OF dp_lnlut18 IS

BEGIN

  pca: PROCESS (add)
  BEGIN
    CASE add IS
      WHEN "000000000" =>
            inv <= conv_std_logic_vector(131072,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(0,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(0,28);
            logexp <= conv_std_logic_vector(0,11);
      WHEN "000000001" =>
            inv <= conv_std_logic_vector(262143,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(31,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(268391765,28);
            logexp <= conv_std_logic_vector(1005,11);
      WHEN "000000010" =>
            inv <= conv_std_logic_vector(262141,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8388752,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(327672,28);
            logexp <= conv_std_logic_vector(1006,11);
      WHEN "000000011" =>
            inv <= conv_std_logic_vector(262139,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4194504,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(666254,28);
            logexp <= conv_std_logic_vector(1007,11);
      WHEN "000000100" =>
            inv <= conv_std_logic_vector(262137,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12583304,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(1889508,28);
            logexp <= conv_std_logic_vector(1007,11);
      WHEN "000000101" =>
            inv <= conv_std_logic_vector(262135,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2097476,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(1982311,28);
            logexp <= conv_std_logic_vector(1008,11);
      WHEN "000000110" =>
            inv <= conv_std_logic_vector(262133,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6291940,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(3642366,28);
            logexp <= conv_std_logic_vector(1008,11);
      WHEN "000000111" =>
            inv <= conv_std_logic_vector(262131,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10486436,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(5990414,28);
            logexp <= conv_std_logic_vector(1008,11);
      WHEN "000001000" =>
            inv <= conv_std_logic_vector(262129,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14680964,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(9223005,28);
            logexp <= conv_std_logic_vector(1008,11);
      WHEN "000001001" =>
            inv <= conv_std_logic_vector(262127,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1049154,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(6702808,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000001010" =>
            inv <= conv_std_logic_vector(262125,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3146450,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(9367390,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000001011" =>
            inv <= conv_std_logic_vector(262123,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5243762,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(12637977,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000001100" =>
            inv <= conv_std_logic_vector(262121,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7341090,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(16612827,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000001101" =>
            inv <= conv_std_logic_vector(262119,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9438434,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(21341043,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000001110" =>
            inv <= conv_std_logic_vector(262117,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11535794,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(26871724,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000001111" =>
            inv <= conv_std_logic_vector(262115,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13633170,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(33303113,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000010000" =>
            inv <= conv_std_logic_vector(262113,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15730562,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(40684301,28);
            logexp <= conv_std_logic_vector(1009,11);
      WHEN "000010001" =>
            inv <= conv_std_logic_vector(262111,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(525377,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(24532187,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000010010" =>
            inv <= conv_std_logic_vector(262109,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1574089,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(29270780,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000010011" =>
            inv <= conv_std_logic_vector(262107,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2622809,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(34582468,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000010100" =>
            inv <= conv_std_logic_vector(262105,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3671537,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(40499978,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000010101" =>
            inv <= conv_std_logic_vector(262103,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4720273,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(47056037,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000010110" =>
            inv <= conv_std_logic_vector(262101,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5769017,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(54283367,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000010111" =>
            inv <= conv_std_logic_vector(262099,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6817769,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(62214689,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011000" =>
            inv <= conv_std_logic_vector(262097,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7866529,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(70882721,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011001" =>
            inv <= conv_std_logic_vector(262095,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8915297,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(80328369,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011010" =>
            inv <= conv_std_logic_vector(262093,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9964073,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(90567968,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011011" =>
            inv <= conv_std_logic_vector(262091,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11012857,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(101650610,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011100" =>
            inv <= conv_std_logic_vector(262089,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12061649,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(113592623,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011101" =>
            inv <= conv_std_logic_vector(262087,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13110449,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(126443095,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011110" =>
            inv <= conv_std_logic_vector(262085,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14159257,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(140226541,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000011111" =>
            inv <= conv_std_logic_vector(262083,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15208073,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(154975663,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000100000" =>
            inv <= conv_std_logic_vector(262081,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16256897,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(170731353,28);
            logexp <= conv_std_logic_vector(1010,11);
      WHEN "000100001" =>
            inv <= conv_std_logic_vector(262079,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(264256,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(227972692,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000100010" =>
            inv <= conv_std_logic_vector(262077,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(788676,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(236897961,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000100011" =>
            inv <= conv_std_logic_vector(262075,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1313100,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(246371462,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000100100" =>
            inv <= conv_std_logic_vector(262073,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1837528,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(256409541,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000100101" =>
            inv <= conv_std_logic_vector(262071,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2361960,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(267028543,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000100110" =>
            inv <= conv_std_logic_vector(262069,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2886397,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(9813450,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000100111" =>
            inv <= conv_std_logic_vector(262067,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3410837,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(21647423,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101000" =>
            inv <= conv_std_logic_vector(262065,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3935281,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(34111345,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101001" =>
            inv <= conv_std_logic_vector(262063,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4459729,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(47221557,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101010" =>
            inv <= conv_std_logic_vector(262061,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4984181,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(60998494,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101011" =>
            inv <= conv_std_logic_vector(262059,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5508637,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(75454397,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101100" =>
            inv <= conv_std_logic_vector(262057,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6033097,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(90605604,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101101" =>
            inv <= conv_std_logic_vector(262055,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6557561,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(106472545,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101110" =>
            inv <= conv_std_logic_vector(262053,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7082029,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(123067460,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000101111" =>
            inv <= conv_std_logic_vector(262051,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7606501,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(140410777,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110000" =>
            inv <= conv_std_logic_vector(262049,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8130977,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(158510638,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110001" =>
            inv <= conv_std_logic_vector(262047,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8655457,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(177395659,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110010" =>
            inv <= conv_std_logic_vector(262045,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9179941,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(197069887,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110011" =>
            inv <= conv_std_logic_vector(262043,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9704429,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(217561932,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110100" =>
            inv <= conv_std_logic_vector(262041,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10228921,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(238875840,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110101" =>
            inv <= conv_std_logic_vector(262039,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10753417,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(261036127,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110110" =>
            inv <= conv_std_logic_vector(262037,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11277918,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(15623661,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000110111" =>
            inv <= conv_std_logic_vector(262035,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11802422,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(39521584,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111000" =>
            inv <= conv_std_logic_vector(262033,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12326930,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(64314859,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111001" =>
            inv <= conv_std_logic_vector(262031,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12851442,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(90015713,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111010" =>
            inv <= conv_std_logic_vector(262029,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13375958,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(116644561,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111011" =>
            inv <= conv_std_logic_vector(262027,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13900478,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(144213628,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111100" =>
            inv <= conv_std_logic_vector(262025,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14425002,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(172743328,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111101" =>
            inv <= conv_std_logic_vector(262023,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14949530,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(202249979,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111110" =>
            inv <= conv_std_logic_vector(262021,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15474062,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(232745802,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "000111111" =>
            inv <= conv_std_logic_vector(262019,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15998598,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(264251207,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "001000000" =>
            inv <= conv_std_logic_vector(262017,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16523139,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(28347053,28);
            logexp <= conv_std_logic_vector(1011,11);
      WHEN "001000001" =>
            inv <= conv_std_logic_vector(262015,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(135233,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(165175963,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001000010" =>
            inv <= conv_std_logic_vector(262013,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(397507,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(182491979,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001000011" =>
            inv <= conv_std_logic_vector(262011,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(659783,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(200343364,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001000100" =>
            inv <= conv_std_logic_vector(262009,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(922061,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(218740319,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001000101" =>
            inv <= conv_std_logic_vector(262007,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1184341,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(237688954,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001000110" =>
            inv <= conv_std_logic_vector(262005,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1446623,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(257201513,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001000111" =>
            inv <= conv_std_logic_vector(262003,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1708908,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(8846602,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001000" =>
            inv <= conv_std_logic_vector(262001,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1971194,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(29507379,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001001" =>
            inv <= conv_std_logic_vector(261999,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2233482,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(50752445,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001010" =>
            inv <= conv_std_logic_vector(261997,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2495772,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(72592000,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001011" =>
            inv <= conv_std_logic_vector(261995,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2758064,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(95036240,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001100" =>
            inv <= conv_std_logic_vector(261993,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3020358,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(118089223,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001101" =>
            inv <= conv_std_logic_vector(261991,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3282654,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(141761145,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001110" =>
            inv <= conv_std_logic_vector(261989,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3544952,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(166062202,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001001111" =>
            inv <= conv_std_logic_vector(261987,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3807252,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(190996450,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010000" =>
            inv <= conv_std_logic_vector(261985,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4069554,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(216576129,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010001" =>
            inv <= conv_std_logic_vector(261983,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4331858,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(242805295,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010010" =>
            inv <= conv_std_logic_vector(261981,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4594165,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(1260730,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010011" =>
            inv <= conv_std_logic_vector(261979,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4856473,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(28821495,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010100" =>
            inv <= conv_std_logic_vector(261977,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5118783,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(57056185,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010101" =>
            inv <= conv_std_logic_vector(261975,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5381095,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(85977038,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010110" =>
            inv <= conv_std_logic_vector(261973,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5643409,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(115590153,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001010111" =>
            inv <= conv_std_logic_vector(261971,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5905725,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(145903675,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011000" =>
            inv <= conv_std_logic_vector(261969,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6168043,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(176927792,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011001" =>
            inv <= conv_std_logic_vector(261967,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6430363,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(208668602,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011010" =>
            inv <= conv_std_logic_vector(261965,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6692685,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(241134248,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011011" =>
            inv <= conv_std_logic_vector(261963,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6955010,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(5901507,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011100" =>
            inv <= conv_std_logic_vector(261961,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7217336,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(39843294,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011101" =>
            inv <= conv_std_logic_vector(261959,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7479664,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(74536387,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011110" =>
            inv <= conv_std_logic_vector(261957,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7741994,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(109988926,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001011111" =>
            inv <= conv_std_logic_vector(261955,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8004326,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(146207004,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100000" =>
            inv <= conv_std_logic_vector(261953,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8266660,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(183200806,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100001" =>
            inv <= conv_std_logic_vector(261951,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8528996,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(220976425,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100010" =>
            inv <= conv_std_logic_vector(261949,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8791334,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(259546091,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100011" =>
            inv <= conv_std_logic_vector(261947,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9053675,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(30478393,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100100" =>
            inv <= conv_std_logic_vector(261945,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9316017,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(70652380,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100101" =>
            inv <= conv_std_logic_vector(261943,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9578361,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(111644825,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100110" =>
            inv <= conv_std_logic_vector(261941,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9840707,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(153461817,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001100111" =>
            inv <= conv_std_logic_vector(261939,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10103055,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(196109445,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101000" =>
            inv <= conv_std_logic_vector(261937,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10365405,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(239597890,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101001" =>
            inv <= conv_std_logic_vector(261935,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10627758,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(15499830,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101010" =>
            inv <= conv_std_logic_vector(261933,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10890112,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(60696356,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101011" =>
            inv <= conv_std_logic_vector(261931,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11152468,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(106756053,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101100" =>
            inv <= conv_std_logic_vector(261929,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11414826,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(153689099,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101101" =>
            inv <= conv_std_logic_vector(261927,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11677186,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(201505673,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101110" =>
            inv <= conv_std_logic_vector(261925,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11939548,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(250209813,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001101111" =>
            inv <= conv_std_logic_vector(261923,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12201913,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(31378287,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110000" =>
            inv <= conv_std_logic_vector(261921,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12464279,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(81888089,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110001" =>
            inv <= conv_std_logic_vector(261919,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12726647,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(133313941,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110010" =>
            inv <= conv_std_logic_vector(261917,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12989017,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(185659877,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110011" =>
            inv <= conv_std_logic_vector(261915,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13251389,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(238938120,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110100" =>
            inv <= conv_std_logic_vector(261913,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13513764,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(24721341,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110101" =>
            inv <= conv_std_logic_vector(261911,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13776140,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(79886532,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110110" =>
            inv <= conv_std_logic_vector(261909,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14038518,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(136006365,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001110111" =>
            inv <= conv_std_logic_vector(261907,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14300898,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(193091012,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111000" =>
            inv <= conv_std_logic_vector(261905,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14563280,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(251146552,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111001" =>
            inv <= conv_std_logic_vector(261903,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14825665,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(41747701,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111010" =>
            inv <= conv_std_logic_vector(261901,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15088051,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(101773495,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111011" =>
            inv <= conv_std_logic_vector(261899,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15350439,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(162796601,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111100" =>
            inv <= conv_std_logic_vector(261897,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15612829,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(224823097,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111101" =>
            inv <= conv_std_logic_vector(261895,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15875222,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(19427696,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111110" =>
            inv <= conv_std_logic_vector(261893,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16137616,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(83489431,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "001111111" =>
            inv <= conv_std_logic_vector(261891,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16400012,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(148578923,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "010000000" =>
            inv <= conv_std_logic_vector(261889,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16662410,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(214708384,28);
            logexp <= conv_std_logic_vector(1012,11);
      WHEN "010000001" =>
            inv <= conv_std_logic_vector(261887,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(73797,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(140941945,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010000010" =>
            inv <= conv_std_logic_vector(261885,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(204998,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(175055756,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010000011" =>
            inv <= conv_std_logic_vector(261883,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(336200,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(209701733,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010000100" =>
            inv <= conv_std_logic_vector(261881,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(467403,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(244882910,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010000101" =>
            inv <= conv_std_logic_vector(261879,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(598608,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(12167891,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010000110" =>
            inv <= conv_std_logic_vector(261877,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(729813,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(48431647,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010000111" =>
            inv <= conv_std_logic_vector(261875,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(861019,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(85243804,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001000" =>
            inv <= conv_std_logic_vector(261873,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(992226,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(122607396,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001001" =>
            inv <= conv_std_logic_vector(261871,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1123434,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(160526482,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001010" =>
            inv <= conv_std_logic_vector(261869,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1254643,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(199006142,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001011" =>
            inv <= conv_std_logic_vector(261867,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1385853,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(238049411,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001100" =>
            inv <= conv_std_logic_vector(261865,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1517065,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(9224891,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001101" =>
            inv <= conv_std_logic_vector(261863,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1648277,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(49409594,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001110" =>
            inv <= conv_std_logic_vector(261861,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1779490,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(90169054,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010001111" =>
            inv <= conv_std_logic_vector(261859,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1910704,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(131510396,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010000" =>
            inv <= conv_std_logic_vector(261857,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2041919,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(173435630,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010001" =>
            inv <= conv_std_logic_vector(261855,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2173135,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(215949833,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010010" =>
            inv <= conv_std_logic_vector(261853,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2304352,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(259057063,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010011" =>
            inv <= conv_std_logic_vector(261851,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2435571,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(34325917,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010100" =>
            inv <= conv_std_logic_vector(261849,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2566790,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(78630340,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010101" =>
            inv <= conv_std_logic_vector(261847,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2698010,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(123540976,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010110" =>
            inv <= conv_std_logic_vector(261845,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2829231,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(169060858,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010010111" =>
            inv <= conv_std_logic_vector(261843,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2960453,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(215194037,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011000" =>
            inv <= conv_std_logic_vector(261841,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3091676,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(261943547,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011001" =>
            inv <= conv_std_logic_vector(261839,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3222901,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(40881052,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011010" =>
            inv <= conv_std_logic_vector(261837,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3354126,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(88878449,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011011" =>
            inv <= conv_std_logic_vector(261835,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3485352,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(137506381,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011100" =>
            inv <= conv_std_logic_vector(261833,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3616579,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(186767878,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011101" =>
            inv <= conv_std_logic_vector(261831,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3747807,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(236666992,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011110" =>
            inv <= conv_std_logic_vector(261829,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3879037,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(18774364,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010011111" =>
            inv <= conv_std_logic_vector(261827,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4010267,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(69961890,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100000" =>
            inv <= conv_std_logic_vector(261825,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4141498,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(121800212,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100001" =>
            inv <= conv_std_logic_vector(261823,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4272730,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(174293379,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100010" =>
            inv <= conv_std_logic_vector(261821,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4403963,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(227445444,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100011" =>
            inv <= conv_std_logic_vector(261819,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4535198,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(12823978,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100100" =>
            inv <= conv_std_logic_vector(261817,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4666433,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(67305989,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100101" =>
            inv <= conv_std_logic_vector(261815,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4797669,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(122458025,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100110" =>
            inv <= conv_std_logic_vector(261813,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4928906,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(178285160,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010100111" =>
            inv <= conv_std_logic_vector(261811,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5060144,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(234791442,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101000" =>
            inv <= conv_std_logic_vector(261809,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5191384,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(23545465,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101001" =>
            inv <= conv_std_logic_vector(261807,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5322624,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(81422190,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101010" =>
            inv <= conv_std_logic_vector(261805,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5453865,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(139991231,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101011" =>
            inv <= conv_std_logic_vector(261803,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5585107,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(199255616,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101100" =>
            inv <= conv_std_logic_vector(261801,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5716350,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(259219392,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101101" =>
            inv <= conv_std_logic_vector(261799,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5847595,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(51452173,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101110" =>
            inv <= conv_std_logic_vector(261797,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5978840,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(112827896,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010101111" =>
            inv <= conv_std_logic_vector(261795,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6110086,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(174915153,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110000" =>
            inv <= conv_std_logic_vector(261793,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6241333,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(237719013,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110001" =>
            inv <= conv_std_logic_vector(261791,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6372582,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(32808067,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110010" =>
            inv <= conv_std_logic_vector(261789,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6503831,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(97057274,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110011" =>
            inv <= conv_std_logic_vector(261787,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6635081,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(162034200,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110100" =>
            inv <= conv_std_logic_vector(261785,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6766332,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(227743914,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110101" =>
            inv <= conv_std_logic_vector(261783,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6897585,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(25755007,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110110" =>
            inv <= conv_std_logic_vector(261781,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7028838,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(92942434,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010110111" =>
            inv <= conv_std_logic_vector(261779,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7160092,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(160875808,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111000" =>
            inv <= conv_std_logic_vector(261777,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7291347,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(229557128,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111001" =>
            inv <= conv_std_logic_vector(261775,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7422604,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(30556006,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111010" =>
            inv <= conv_std_logic_vector(261773,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7553861,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(100748419,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111011" =>
            inv <= conv_std_logic_vector(261771,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7685119,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(171701934,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111100" =>
            inv <= conv_std_logic_vector(261769,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7816378,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(243420594,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111101" =>
            inv <= conv_std_logic_vector(261767,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7947639,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(47474008,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111110" =>
            inv <= conv_std_logic_vector(261765,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8078900,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(120736110,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "010111111" =>
            inv <= conv_std_logic_vector(261763,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8210162,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(194776508,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000000" =>
            inv <= conv_std_logic_vector(261761,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8341426,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(1163789,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000001" =>
            inv <= conv_std_logic_vector(261759,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8472690,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(76771885,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000010" =>
            inv <= conv_std_logic_vector(261757,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8603955,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(153170403,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000011" =>
            inv <= conv_std_logic_vector(261755,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8735221,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(230363387,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000100" =>
            inv <= conv_std_logic_vector(261753,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8866489,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(39919420,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000101" =>
            inv <= conv_std_logic_vector(261751,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8997757,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(118713456,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000110" =>
            inv <= conv_std_logic_vector(261749,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9129026,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(198314080,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011000111" =>
            inv <= conv_std_logic_vector(261747,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9260297,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(10289876,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001000" =>
            inv <= conv_std_logic_vector(261745,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9391568,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(91515797,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001001" =>
            inv <= conv_std_logic_vector(261743,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9522840,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(173561448,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001010" =>
            inv <= conv_std_logic_vector(261741,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9654113,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(256429848,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001011" =>
            inv <= conv_std_logic_vector(261739,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9785388,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(71690601,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001100" =>
            inv <= conv_std_logic_vector(261737,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9916663,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(156217637,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001101" =>
            inv <= conv_std_logic_vector(261735,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10047939,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(241580560,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001110" =>
            inv <= conv_std_logic_vector(261733,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10179217,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(59346931,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011001111" =>
            inv <= conv_std_logic_vector(261731,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10310495,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(146392723,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010000" =>
            inv <= conv_std_logic_vector(261729,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10441774,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(234286516,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010001" =>
            inv <= conv_std_logic_vector(261727,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10573055,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(54596894,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010010" =>
            inv <= conv_std_logic_vector(261725,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10704336,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(144198805,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010011" =>
            inv <= conv_std_logic_vector(261723,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10835618,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(234660830,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010100" =>
            inv <= conv_std_logic_vector(261721,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10966902,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(57551551,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010101" =>
            inv <= conv_std_logic_vector(261719,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11098186,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(149745915,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010110" =>
            inv <= conv_std_logic_vector(261717,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11229471,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(242812504,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011010111" =>
            inv <= conv_std_logic_vector(261715,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11360758,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(68320919,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011000" =>
            inv <= conv_std_logic_vector(261713,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11492045,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(163146107,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011001" =>
            inv <= conv_std_logic_vector(261711,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11623333,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(258854605,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011010" =>
            inv <= conv_std_logic_vector(261709,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11754623,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(87018057,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011011" =>
            inv <= conv_std_logic_vector(261707,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11885913,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(184509366,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011100" =>
            inv <= conv_std_logic_vector(261705,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12017205,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(14462677,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011101" =>
            inv <= conv_std_logic_vector(261703,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12148497,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(113752937,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011110" =>
            inv <= conv_std_logic_vector(261701,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12279790,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(213947700,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011011111" =>
            inv <= conv_std_logic_vector(261699,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12411085,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(46617589,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100000" =>
            inv <= conv_std_logic_vector(261697,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12542380,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(148636528,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100001" =>
            inv <= conv_std_logic_vector(261695,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12673676,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(251573093,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100010" =>
            inv <= conv_std_logic_vector(261693,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12804974,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(86995861,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100011" =>
            inv <= conv_std_logic_vector(261691,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12936272,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(191780799,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100100" =>
            inv <= conv_std_logic_vector(261689,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13067572,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(29060005,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100101" =>
            inv <= conv_std_logic_vector(261687,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13198872,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(135708424,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100110" =>
            inv <= conv_std_logic_vector(261685,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13330173,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(243295652,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011100111" =>
            inv <= conv_std_logic_vector(261683,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13461476,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(83390266,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101000" =>
            inv <= conv_std_logic_vector(261681,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13592779,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(192867209,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101001" =>
            inv <= conv_std_logic_vector(261679,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13724084,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(34858577,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101010" =>
            inv <= conv_std_logic_vector(261677,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13855389,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(146240336,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101011" =>
            inv <= conv_std_logic_vector(261675,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13986695,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(258581058,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101100" =>
            inv <= conv_std_logic_vector(261673,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14118003,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(103450342,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101101" =>
            inv <= conv_std_logic_vector(261671,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14249311,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(217721083,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101110" =>
            inv <= conv_std_logic_vector(261669,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14380621,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(64528444,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011101111" =>
            inv <= conv_std_logic_vector(261667,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14511931,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(180746345,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110000" =>
            inv <= conv_std_logic_vector(261665,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14643243,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(29508923,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110001" =>
            inv <= conv_std_logic_vector(261663,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14774555,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(147690097,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110010" =>
            inv <= conv_std_logic_vector(261661,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14905868,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(266859463,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110011" =>
            inv <= conv_std_logic_vector(261659,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15037183,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(118585591,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110100" =>
            inv <= conv_std_logic_vector(261657,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15168498,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(239742400,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110101" =>
            inv <= conv_std_logic_vector(261655,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15299815,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(93464027,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110110" =>
            inv <= conv_std_logic_vector(261653,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15431132,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(216625411,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011110111" =>
            inv <= conv_std_logic_vector(261651,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15562451,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(72360690,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111000" =>
            inv <= conv_std_logic_vector(261649,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15693770,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(197542758,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111001" =>
            inv <= conv_std_logic_vector(261647,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15825091,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(55306773,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111010" =>
            inv <= conv_std_logic_vector(261645,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15956412,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(182526652,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111011" =>
            inv <= conv_std_logic_vector(261643,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16087735,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(42335507,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111100" =>
            inv <= conv_std_logic_vector(261641,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16219058,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(171609300,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111101" =>
            inv <= conv_std_logic_vector(261639,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16350383,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(33481142,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111110" =>
            inv <= conv_std_logic_vector(261637,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16481708,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(164824949,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "011111111" =>
            inv <= conv_std_logic_vector(261635,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16613035,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(28774856,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "100000000" =>
            inv <= conv_std_logic_vector(261633,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16744362,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(162205798,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "100000001" =>
            inv <= conv_std_logic_vector(261632,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16405,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(97880094,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100000010" =>
            inv <= conv_std_logic_vector(261630,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(82069,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(232492642,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100000011" =>
            inv <= conv_std_logic_vector(261628,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(147734,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(233414771,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100000100" =>
            inv <= conv_std_logic_vector(261626,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(213400,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(100649515,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100000101" =>
            inv <= conv_std_logic_vector(261624,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(279066,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(102634341,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100000110" =>
            inv <= conv_std_logic_vector(261622,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(344732,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(239370238,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100000111" =>
            inv <= conv_std_logic_vector(261620,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(410399,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(242424784,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001000" =>
            inv <= conv_std_logic_vector(261618,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(476067,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(111799989,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001001" =>
            inv <= conv_std_logic_vector(261616,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(541735,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(115933322,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001010" =>
            inv <= conv_std_logic_vector(261614,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(607403,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(254826281,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001011" =>
            inv <= conv_std_logic_vector(261612,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(673072,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(260045933,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001100" =>
            inv <= conv_std_logic_vector(261610,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(738742,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(131594288,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001101" =>
            inv <= conv_std_logic_vector(261608,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(804412,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(137909323,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001110" =>
            inv <= conv_std_logic_vector(261606,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(870083,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(10556570,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100001111" =>
            inv <= conv_std_logic_vector(261604,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(935754,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(17974519,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010000" =>
            inv <= conv_std_logic_vector(261602,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1001425,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(160164667,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010001" =>
            inv <= conv_std_logic_vector(261600,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1067097,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(168694080,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010010" =>
            inv <= conv_std_logic_vector(261598,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1132770,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(43564256,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010011" =>
            inv <= conv_std_logic_vector(261596,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1198443,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(53213172,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010100" =>
            inv <= conv_std_logic_vector(261594,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1264116,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(197642837,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010101" =>
            inv <= conv_std_logic_vector(261592,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1329790,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(208419294,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010110" =>
            inv <= conv_std_logic_vector(261590,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1395465,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(85545574,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100010111" =>
            inv <= conv_std_logic_vector(261588,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1461140,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(97458630,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011000" =>
            inv <= conv_std_logic_vector(261586,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1526815,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(244160472,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011001" =>
            inv <= conv_std_logic_vector(261584,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1592491,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(257217653,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011010" =>
            inv <= conv_std_logic_vector(261582,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1658168,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(136632180,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011011" =>
            inv <= conv_std_logic_vector(261580,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1723845,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(150842541,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011100" =>
            inv <= conv_std_logic_vector(261578,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1789523,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(31413754,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011101" =>
            inv <= conv_std_logic_vector(261576,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1855201,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(46784817,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011110" =>
            inv <= conv_std_logic_vector(261574,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1920879,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(196956715,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100011111" =>
            inv <= conv_std_logic_vector(261572,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1986558,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(213496513,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100000" =>
            inv <= conv_std_logic_vector(261570,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2052238,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(96406727,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100001" =>
            inv <= conv_std_logic_vector(261568,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2117918,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(114123801,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100010" =>
            inv <= conv_std_logic_vector(261566,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2183598,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(266650763,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100011" =>
            inv <= conv_std_logic_vector(261564,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2249280,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(17118198,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100100" =>
            inv <= conv_std_logic_vector(261562,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2314961,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(170834480,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100101" =>
            inv <= conv_std_logic_vector(261560,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2380643,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(190931217,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100110" =>
            inv <= conv_std_logic_vector(261558,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2446326,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(77410414,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100100111" =>
            inv <= conv_std_logic_vector(261556,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2512009,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(98709023,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101000" =>
            inv <= conv_std_logic_vector(261554,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2577692,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(254830073,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101001" =>
            inv <= conv_std_logic_vector(261552,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2643377,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(8903637,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101010" =>
            inv <= conv_std_logic_vector(261550,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2709061,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(166239111,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101011" =>
            inv <= conv_std_logic_vector(261548,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2774746,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(189966567,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101100" =>
            inv <= conv_std_logic_vector(261546,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2840432,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(80089032,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101101" =>
            inv <= conv_std_logic_vector(261544,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2906118,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(105043970,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101110" =>
            inv <= conv_std_logic_vector(261542,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2971804,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(264832874,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100101111" =>
            inv <= conv_std_logic_vector(261540,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3037492,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(22586838,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110000" =>
            inv <= conv_std_logic_vector(261538,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3103179,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(183615258,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110001" =>
            inv <= conv_std_logic_vector(261536,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3168867,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(211048205,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110010" =>
            inv <= conv_std_logic_vector(261534,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3234556,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(104888194,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110011" =>
            inv <= conv_std_logic_vector(261532,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3300245,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(133573199,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110100" =>
            inv <= conv_std_logic_vector(261530,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3365935,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(28668746,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110101" =>
            inv <= conv_std_logic_vector(261528,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3431625,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(58613318,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110110" =>
            inv <= conv_std_logic_vector(261526,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3497315,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(223408408,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100110111" =>
            inv <= conv_std_logic_vector(261524,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3563006,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(254621075,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111000" =>
            inv <= conv_std_logic_vector(261522,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3628698,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(152253325,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111001" =>
            inv <= conv_std_logic_vector(261520,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3694390,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(184742106,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111010" =>
            inv <= conv_std_logic_vector(261518,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3760083,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(83654478,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111011" =>
            inv <= conv_std_logic_vector(261516,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3825776,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(117428410,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111100" =>
            inv <= conv_std_logic_vector(261514,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3891470,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(17629430,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111101" =>
            inv <= conv_std_logic_vector(261512,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3957164,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(52695507,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111110" =>
            inv <= conv_std_logic_vector(261510,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4022858,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(222629156,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "100111111" =>
            inv <= conv_std_logic_vector(261508,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4088553,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(258996925,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000000" =>
            inv <= conv_std_logic_vector(261506,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4154249,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(161800305,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000001" =>
            inv <= conv_std_logic_vector(261504,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4219945,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(199477266,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000010" =>
            inv <= conv_std_logic_vector(261502,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4285642,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(103593845,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000011" =>
            inv <= conv_std_logic_vector(261500,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4351339,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(142588522,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000100" =>
            inv <= conv_std_logic_vector(261498,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4417037,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(48026823,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000101" =>
            inv <= conv_std_logic_vector(261496,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4482735,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(88347226,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000110" =>
            inv <= conv_std_logic_vector(261494,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4548433,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(263551224,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101000111" =>
            inv <= conv_std_logic_vector(261492,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4614133,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(36769906,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001000" =>
            inv <= conv_std_logic_vector(261490,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4679832,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(213312155,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001001" =>
            inv <= conv_std_logic_vector(261488,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4745532,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(256309059,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001010" =>
            inv <= conv_std_logic_vector(261486,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4811233,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(165762621,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001011" =>
            inv <= conv_std_logic_vector(261484,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4876934,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(210109787,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001100" =>
            inv <= conv_std_logic_vector(261482,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4942636,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(120917613,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001101" =>
            inv <= conv_std_logic_vector(261480,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5008338,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(166624068,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001110" =>
            inv <= conv_std_logic_vector(261478,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5074041,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(78795186,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101001111" =>
            inv <= conv_std_logic_vector(261476,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5139744,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(125868425,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010000" =>
            inv <= conv_std_logic_vector(261474,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5205448,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(39410329,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010001" =>
            inv <= conv_std_logic_vector(261472,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5271152,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(87859376,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010010" =>
            inv <= conv_std_logic_vector(261470,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5336857,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(2781090,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010011" =>
            inv <= conv_std_logic_vector(261468,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5402562,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(52613438,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010100" =>
            inv <= conv_std_logic_vector(261466,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5468267,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(237358419,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010101" =>
            inv <= conv_std_logic_vector(261464,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5533974,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(20147124,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010110" =>
            inv <= conv_std_logic_vector(261462,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5599680,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(206287919,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101010111" =>
            inv <= conv_std_logic_vector(261460,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5665387,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(258912403,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011000" =>
            inv <= conv_std_logic_vector(261458,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5731095,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(178022066,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011001" =>
            inv <= conv_std_logic_vector(261456,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5796803,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(232054873,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011010" =>
            inv <= conv_std_logic_vector(261454,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5862512,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(152577368,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011011" =>
            inv <= conv_std_logic_vector(261452,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5928221,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(208027007,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011100" =>
            inv <= conv_std_logic_vector(261450,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5993931,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(129969822,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011101" =>
            inv <= conv_std_logic_vector(261448,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6059641,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(186844290,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011110" =>
            inv <= conv_std_logic_vector(261446,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6125352,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(110216442,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101011111" =>
            inv <= conv_std_logic_vector(261444,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6191063,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(168523735,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100000" =>
            inv <= conv_std_logic_vector(261442,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6256775,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(93333220,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100001" =>
            inv <= conv_std_logic_vector(261440,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6322487,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(153082353,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100010" =>
            inv <= conv_std_logic_vector(261438,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6388200,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(79337165,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100011" =>
            inv <= conv_std_logic_vector(261436,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6453913,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(140535621,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100100" =>
            inv <= conv_std_logic_vector(261434,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6519627,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(68244774,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100101" =>
            inv <= conv_std_logic_vector(261432,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6585341,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(130901057,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100110" =>
            inv <= conv_std_logic_vector(261430,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6651056,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(60072032,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101100111" =>
            inv <= conv_std_logic_vector(261428,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6716771,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(124194644,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101000" =>
            inv <= conv_std_logic_vector(261426,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6782487,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(54835943,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101001" =>
            inv <= conv_std_logic_vector(261424,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6848203,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(120433383,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101010" =>
            inv <= conv_std_logic_vector(261422,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6913920,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(52552996,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101011" =>
            inv <= conv_std_logic_vector(261421,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6946778,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(203440839,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101100" =>
            inv <= conv_std_logic_vector(261419,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7012496,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(69566203,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101101" =>
            inv <= conv_std_logic_vector(261417,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7078214,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(70654699,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101110" =>
            inv <= conv_std_logic_vector(261415,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7143932,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(206708322,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101101111" =>
            inv <= conv_std_logic_vector(261413,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7209651,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(209294124,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110000" =>
            inv <= conv_std_logic_vector(261411,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7275371,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(78413591,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110001" =>
            inv <= conv_std_logic_vector(261409,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7341091,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(82505197,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110010" =>
            inv <= conv_std_logic_vector(261407,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7406811,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(221569406,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110011" =>
            inv <= conv_std_logic_vector(261405,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7472532,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(227174289,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110100" =>
            inv <= conv_std_logic_vector(261403,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7538254,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(99321843,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110101" =>
            inv <= conv_std_logic_vector(261401,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7603976,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(106448498,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110110" =>
            inv <= conv_std_logic_vector(261399,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7669698,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(248557271,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101110111" =>
            inv <= conv_std_logic_vector(261397,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7735421,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(257214192,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111000" =>
            inv <= conv_std_logic_vector(261395,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7801145,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(132421765,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111001" =>
            inv <= conv_std_logic_vector(261393,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7866869,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(142616931,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111010" =>
            inv <= conv_std_logic_vector(261391,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7932594,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(19367251,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111011" =>
            inv <= conv_std_logic_vector(261389,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7998319,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(31109665,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111100" =>
            inv <= conv_std_logic_vector(261387,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8064044,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(177846168,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111101" =>
            inv <= conv_std_logic_vector(261385,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8129770,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(191143299,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111110" =>
            inv <= conv_std_logic_vector(261383,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8195497,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(71003562,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "101111111" =>
            inv <= conv_std_logic_vector(261381,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8261224,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(85863897,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000000" =>
            inv <= conv_std_logic_vector(261379,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8326951,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(235726809,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000001" =>
            inv <= conv_std_logic_vector(261377,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8392679,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(252159347,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000010" =>
            inv <= conv_std_logic_vector(261375,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8458408,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(135162483,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000011" =>
            inv <= conv_std_logic_vector(261373,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8524137,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(153174178,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000100" =>
            inv <= conv_std_logic_vector(261371,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8589867,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(37761480,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000101" =>
            inv <= conv_std_logic_vector(261369,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8655597,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(57361328,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000110" =>
            inv <= conv_std_logic_vector(261367,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8721327,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(211976226,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110000111" =>
            inv <= conv_std_logic_vector(261365,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8787058,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(233172711,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001000" =>
            inv <= conv_std_logic_vector(261363,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8852790,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(120952266,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001001" =>
            inv <= conv_std_logic_vector(261361,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8918522,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(143753360,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001010" =>
            inv <= conv_std_logic_vector(261359,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8984255,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(33142020,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001011" =>
            inv <= conv_std_logic_vector(261357,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9049988,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(57555694,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001100" =>
            inv <= conv_std_logic_vector(261355,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9115721,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(216996886,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001101" =>
            inv <= conv_std_logic_vector(261353,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9181455,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(243031622,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001110" =>
            inv <= conv_std_logic_vector(261351,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9247190,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(135662403,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110001111" =>
            inv <= conv_std_logic_vector(261349,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9312925,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(163326679,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010000" =>
            inv <= conv_std_logic_vector(261347,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9378661,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(57590984,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010001" =>
            inv <= conv_std_logic_vector(261345,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9444397,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(86893278,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010010" =>
            inv <= conv_std_logic_vector(261343,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9510133,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(251234532,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010011" =>
            inv <= conv_std_logic_vector(261341,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9575871,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(13747355,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010100" =>
            inv <= conv_std_logic_vector(261339,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9641608,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(179738576,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010101" =>
            inv <= conv_std_logic_vector(261337,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9707346,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(212340806,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010110" =>
            inv <= conv_std_logic_vector(261335,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9773085,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(111555525,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110010111" =>
            inv <= conv_std_logic_vector(261333,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9838824,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(145820180,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011000" =>
            inv <= conv_std_logic_vector(261331,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9904564,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(46701306,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011001" =>
            inv <= conv_std_logic_vector(261329,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9970304,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(82636350,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011010" =>
            inv <= conv_std_logic_vector(261327,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10036044,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(253627813,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011011" =>
            inv <= conv_std_logic_vector(261325,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10101786,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(22806772,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011100" =>
            inv <= conv_std_logic_vector(261323,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10167527,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(195481587,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011101" =>
            inv <= conv_std_logic_vector(261321,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10233269,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(234782825,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011110" =>
            inv <= conv_std_logic_vector(261319,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10299012,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(140713496,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110011111" =>
            inv <= conv_std_logic_vector(261317,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10364755,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(181710537,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100000" =>
            inv <= conv_std_logic_vector(261315,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10430499,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(89340991,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100001" =>
            inv <= conv_std_logic_vector(261313,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10496243,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(132041793,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100010" =>
            inv <= conv_std_logic_vector(261311,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10561988,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(41379987,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100011" =>
            inv <= conv_std_logic_vector(261309,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10627733,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(85793018,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100100" =>
            inv <= conv_std_logic_vector(261307,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10693478,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(265282876,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100101" =>
            inv <= conv_std_logic_vector(261305,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10759225,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(42980638,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100110" =>
            inv <= conv_std_logic_vector(261303,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10824971,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(224195170,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110100111" =>
            inv <= conv_std_logic_vector(261301,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10890719,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(3621583,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101000" =>
            inv <= conv_std_logic_vector(261299,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10956466,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(186568744,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101001" =>
            inv <= conv_std_logic_vector(261297,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11022214,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(236167729,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101010" =>
            inv <= conv_std_logic_vector(261295,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11087963,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(152420527,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101011" =>
            inv <= conv_std_logic_vector(261293,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11153712,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(203764581,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101100" =>
            inv <= conv_std_logic_vector(261291,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11219462,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(121766424,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101101" =>
            inv <= conv_std_logic_vector(261289,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11285212,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(174864010,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101110" =>
            inv <= conv_std_logic_vector(261287,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11350963,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(94623359,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110101111" =>
            inv <= conv_std_logic_vector(261285,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11416714,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(149482427,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110000" =>
            inv <= conv_std_logic_vector(261283,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11482466,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(71008255,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110001" =>
            inv <= conv_std_logic_vector(261281,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11548218,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(127637265,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110010" =>
            inv <= conv_std_logic_vector(261279,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11613971,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(50936498,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110011" =>
            inv <= conv_std_logic_vector(261277,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11679724,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(109344419,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110100" =>
            inv <= conv_std_logic_vector(261275,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11745478,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(34426028,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110101" =>
            inv <= conv_std_logic_vector(261273,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11811232,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(94620297,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110110" =>
            inv <= conv_std_logic_vector(261271,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11876987,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(21492737,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110110111" =>
            inv <= conv_std_logic_vector(261269,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11942742,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(83481301,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111000" =>
            inv <= conv_std_logic_vector(261267,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12008498,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(12153029,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111001" =>
            inv <= conv_std_logic_vector(261265,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12074254,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(75944853,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111010" =>
            inv <= conv_std_logic_vector(261263,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12140011,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(6423814,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111011" =>
            inv <= conv_std_logic_vector(261261,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12205768,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(72026842,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111100" =>
            inv <= conv_std_logic_vector(261259,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12271526,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(4320978,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111101" =>
            inv <= conv_std_logic_vector(261258,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12304405,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(21141383,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111110" =>
            inv <= conv_std_logic_vector(261256,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12370163,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(156129342,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "110111111" =>
            inv <= conv_std_logic_vector(261254,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12435922,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(157813374,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000000" =>
            inv <= conv_std_logic_vector(261252,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12501682,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(26195972,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000001" =>
            inv <= conv_std_logic_vector(261250,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12567442,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(29714068,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000010" =>
            inv <= conv_std_logic_vector(261248,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12633202,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(168370156,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000011" =>
            inv <= conv_std_logic_vector(261246,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12698963,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(173730767,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000100" =>
            inv <= conv_std_logic_vector(261244,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12764725,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(45797884,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000101" =>
            inv <= conv_std_logic_vector(261242,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12830487,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(53009458,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000110" =>
            inv <= conv_std_logic_vector(261240,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12896249,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(195366963,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111000111" =>
            inv <= conv_std_logic_vector(261238,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12962012,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(204436928,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001000" =>
            inv <= conv_std_logic_vector(261236,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13027776,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(80222356,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001001" =>
            inv <= conv_std_logic_vector(261234,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13093540,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(91159668,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001010" =>
            inv <= conv_std_logic_vector(261232,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13159304,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(237251358,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001011" =>
            inv <= conv_std_logic_vector(261230,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13225069,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(250064462,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001100" =>
            inv <= conv_std_logic_vector(261228,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13290835,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(129600456,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001101" =>
            inv <= conv_std_logic_vector(261226,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13356601,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(144297287,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001110" =>
            inv <= conv_std_logic_vector(261224,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13422368,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(25721484,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111001111" =>
            inv <= conv_std_logic_vector(261222,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13488135,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(42309975,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010000" =>
            inv <= conv_std_logic_vector(261220,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13553902,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(194065764,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010001" =>
            inv <= conv_std_logic_vector(261218,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13619670,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(212554867,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010010" =>
            inv <= conv_std_logic_vector(261216,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13685439,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(97779777,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010011" =>
            inv <= conv_std_logic_vector(261214,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13751208,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(118177423,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010100" =>
            inv <= conv_std_logic_vector(261212,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13816978,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(5314840,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010101" =>
            inv <= conv_std_logic_vector(261210,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13882748,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(27629467,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010110" =>
            inv <= conv_std_logic_vector(261208,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13948518,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(185123287,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111010111" =>
            inv <= conv_std_logic_vector(261206,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14014289,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(209363335,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011000" =>
            inv <= conv_std_logic_vector(261204,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14080061,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(100351083,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011001" =>
            inv <= conv_std_logic_vector(261202,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14145833,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(126524479,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011010" =>
            inv <= conv_std_logic_vector(261200,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14211606,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(19449539,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011011" =>
            inv <= conv_std_logic_vector(261198,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14277379,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(47564719,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011100" =>
            inv <= conv_std_logic_vector(261196,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14343152,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(210871490,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011101" =>
            inv <= conv_std_logic_vector(261194,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14408926,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(240936379,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011110" =>
            inv <= conv_std_logic_vector(261192,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14474701,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(137761877,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111011111" =>
            inv <= conv_std_logic_vector(261190,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14540476,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(169784908,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100000" =>
            inv <= conv_std_logic_vector(261188,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14606252,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(68573020,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100001" =>
            inv <= conv_std_logic_vector(261186,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14672028,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(102562628,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100010" =>
            inv <= conv_std_logic_vector(261184,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14737805,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(3321276,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100011" =>
            inv <= conv_std_logic_vector(261182,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14803582,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(39285891,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100100" =>
            inv <= conv_std_logic_vector(261180,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14869359,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(210458963,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100101" =>
            inv <= conv_std_logic_vector(261178,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14935137,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(248407016,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100110" =>
            inv <= conv_std_logic_vector(261176,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15000916,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(153132030,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111100111" =>
            inv <= conv_std_logic_vector(261174,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15066695,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(193071440,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101000" =>
            inv <= conv_std_logic_vector(261172,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15132475,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(99791770,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101001" =>
            inv <= conv_std_logic_vector(261170,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15198255,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(141730965,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101010" =>
            inv <= conv_std_logic_vector(261168,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15264036,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(50455039,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101011" =>
            inv <= conv_std_logic_vector(261166,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15329817,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(94401937,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101100" =>
            inv <= conv_std_logic_vector(261164,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15395599,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(5138692,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101101" =>
            inv <= conv_std_logic_vector(261162,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15461381,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(51101718,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101110" =>
            inv <= conv_std_logic_vector(261160,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15527163,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(232294014,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111101111" =>
            inv <= conv_std_logic_vector(261158,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15592947,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(11846647,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110000" =>
            inv <= conv_std_logic_vector(261156,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15658730,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(195067454,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110001" =>
            inv <= conv_std_logic_vector(261154,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15724514,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(245088520,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110010" =>
            inv <= conv_std_logic_vector(261152,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15790299,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(161910803,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110011" =>
            inv <= conv_std_logic_vector(261150,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15856084,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(213972758,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110100" =>
            inv <= conv_std_logic_vector(261148,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15921870,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(132840397,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110101" =>
            inv <= conv_std_logic_vector(261146,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15987656,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(186951663,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110110" =>
            inv <= conv_std_logic_vector(261144,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16053443,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(107873077,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111110111" =>
            inv <= conv_std_logic_vector(261142,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16119230,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(164042073,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111000" =>
            inv <= conv_std_logic_vector(261140,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16185018,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(87025173,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111001" =>
            inv <= conv_std_logic_vector(261138,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16250806,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(145260319,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111010" =>
            inv <= conv_std_logic_vector(261136,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16316595,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(70314033,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111011" =>
            inv <= conv_std_logic_vector(261134,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16382384,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(130623237,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111100" =>
            inv <= conv_std_logic_vector(261132,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16448174,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(57754962,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111101" =>
            inv <= conv_std_logic_vector(261130,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16513964,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(120146640,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111110" =>
            inv <= conv_std_logic_vector(261128,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16579755,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(49365303,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "111111111" =>
            inv <= conv_std_logic_vector(261126,18);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16645546,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(113847871,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN others =>
           inv <= conv_std_logic_vector(0,18);
           logman(52 DOWNTO 29) <= conv_std_logic_vector(0,24);
           logman(28 DOWNTO 1) <= conv_std_logic_vector(0,28);
           logexp <= conv_std_logic_vector(0,11);
    END CASE;
  END PROCESS;

END rtl;
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

--***************************************************
--***                                             ***
--***   FLOATING POINT CORE LIBRARY               ***
--***                                             ***
--***   DP_LNLUT9.VHD                             ***
--***                                             ***
--***   Function: Look Up Table - LN()            ***
--***                                             ***
--***   Generated by MATLAB Utility               ***
--***                                             ***
--***   18/02/08 ML                               ***
--***                                             ***
--***   (c) 2008 Altera Corporation               ***
--***                                             ***
--***   Change History                            ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***                                             ***
--***************************************************

ENTITY dp_lnlut9 IS
PORT (
      add : IN STD_LOGIC_VECTOR (9 DOWNTO 1);
      inv : OUT STD_LOGIC_VECTOR (12 DOWNTO 1);
      logman : OUT STD_LOGIC_VECTOR (52 DOWNTO 1);
      logexp : OUT STD_LOGIC_VECTOR (11 DOWNTO 1)
     );
END dp_lnlut9;

ARCHITECTURE rtl OF dp_lnlut9 IS

BEGIN

  pca: PROCESS (add)
  BEGIN
    CASE add IS
      WHEN "000000000" =>
            inv <= conv_std_logic_vector(2048,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(0,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(0,28);
            logexp <= conv_std_logic_vector(0,11);
      WHEN "000000001" =>
            inv <= conv_std_logic_vector(4089,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12608028,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(166435551,28);
            logexp <= conv_std_logic_vector(1013,11);
      WHEN "000000010" =>
            inv <= conv_std_logic_vector(4081,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14737805,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(3321276,28);
            logexp <= conv_std_logic_vector(1014,11);
      WHEN "000000011" =>
            inv <= conv_std_logic_vector(4073,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7407998,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(148040387,28);
            logexp <= conv_std_logic_vector(1015,11);
      WHEN "000000100" =>
            inv <= conv_std_logic_vector(4065,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15852272,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(51070306,28);
            logexp <= conv_std_logic_vector(1015,11);
      WHEN "000000101" =>
            inv <= conv_std_logic_vector(4057,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3767982,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(94668708,28);
            logexp <= conv_std_logic_vector(1016,11);
      WHEN "000000110" =>
            inv <= conv_std_logic_vector(4049,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8006786,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(237055061,28);
            logexp <= conv_std_logic_vector(1016,11);
      WHEN "000000111" =>
            inv <= conv_std_logic_vector(4041,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12253974,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(192188802,28);
            logexp <= conv_std_logic_vector(1016,11);
      WHEN "000001000" =>
            inv <= conv_std_logic_vector(4033,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16509579,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(20710393,28);
            logexp <= conv_std_logic_vector(1016,11);
      WHEN "000001001" =>
            inv <= conv_std_logic_vector(4026,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1731473,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(180827014,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000001010" =>
            inv <= conv_std_logic_vector(4018,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3867211,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(126637664,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000001011" =>
            inv <= conv_std_logic_vector(4010,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6007205,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(228245542,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000001100" =>
            inv <= conv_std_logic_vector(4003,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7883206,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(5368567,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000001101" =>
            inv <= conv_std_logic_vector(3995,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10031227,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(104563152,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000001110" =>
            inv <= conv_std_logic_vector(3987,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12183554,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(132223343,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000001111" =>
            inv <= conv_std_logic_vector(3980,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14070386,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(93820959,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000010000" =>
            inv <= conv_std_logic_vector(3972,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16230833,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(108537941,28);
            logexp <= conv_std_logic_vector(1017,11);
      WHEN "000010001" =>
            inv <= conv_std_logic_vector(3965,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(673790,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(140554826,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000010010" =>
            inv <= conv_std_logic_vector(3957,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1758104,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(208459132,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000010011" =>
            inv <= conv_std_logic_vector(3950,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2708679,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(147574307,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000010100" =>
            inv <= conv_std_logic_vector(3943,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3660940,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(102190772,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000010101" =>
            inv <= conv_std_logic_vector(3935,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4751310,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(193668840,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000010110" =>
            inv <= conv_std_logic_vector(3928,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5707204,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(201576161,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000010111" =>
            inv <= conv_std_logic_vector(3920,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6801743,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(47496037,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011000" =>
            inv <= conv_std_logic_vector(3913,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7761298,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(63049717,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011001" =>
            inv <= conv_std_logic_vector(3906,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8722571,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(103870568,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011010" =>
            inv <= conv_std_logic_vector(3899,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9685568,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(213866899,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011011" =>
            inv <= conv_std_logic_vector(3891,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10788256,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(148111271,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011100" =>
            inv <= conv_std_logic_vector(3884,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11754969,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(190364328,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011101" =>
            inv <= conv_std_logic_vector(3877,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12723426,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(191372810,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011110" =>
            inv <= conv_std_logic_vector(3870,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13693633,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(232417040,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000011111" =>
            inv <= conv_std_logic_vector(3863,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14665597,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(135531172,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000100000" =>
            inv <= conv_std_logic_vector(3856,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15639324,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(440444,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000100001" =>
            inv <= conv_std_logic_vector(3848,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16754321,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(28021513,28);
            logexp <= conv_std_logic_vector(1018,11);
      WHEN "000100010" =>
            inv <= conv_std_logic_vector(3841,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(477315,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(103375890,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000100011" =>
            inv <= conv_std_logic_vector(3834,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(966969,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(207463933,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000100100" =>
            inv <= conv_std_logic_vector(3827,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1457518,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(261454332,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000100101" =>
            inv <= conv_std_logic_vector(3820,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1948966,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(71112978,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000100110" =>
            inv <= conv_std_logic_vector(3814,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2370924,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(27626077,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000100111" =>
            inv <= conv_std_logic_vector(3807,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2864048,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(7790664,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101000" =>
            inv <= conv_std_logic_vector(3800,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3358079,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(135806794,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101001" =>
            inv <= conv_std_logic_vector(3793,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3853021,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(236303861,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101010" =>
            inv <= conv_std_logic_vector(3786,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4348878,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(138889654,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101011" =>
            inv <= conv_std_logic_vector(3779,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4845652,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(215058204,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101100" =>
            inv <= conv_std_logic_vector(3772,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5343348,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(36049681,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101101" =>
            inv <= conv_std_logic_vector(3766,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5770679,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(216749821,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101110" =>
            inv <= conv_std_logic_vector(3759,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6270094,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(202231188,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000101111" =>
            inv <= conv_std_logic_vector(3752,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6770440,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(154557048,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110000" =>
            inv <= conv_std_logic_vector(3745,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7271720,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(201681452,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110001" =>
            inv <= conv_std_logic_vector(3739,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7702135,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(212518450,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110010" =>
            inv <= conv_std_logic_vector(3732,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8205160,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(130192328,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110011" =>
            inv <= conv_std_logic_vector(3725,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8709129,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(153765892,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110100" =>
            inv <= conv_std_logic_vector(3719,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9141857,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(115454106,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110101" =>
            inv <= conv_std_logic_vector(3712,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9647589,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(223955336,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110110" =>
            inv <= conv_std_logic_vector(3706,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10081834,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(106871151,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000110111" =>
            inv <= conv_std_logic_vector(3699,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10589342,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(134545541,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111000" =>
            inv <= conv_std_logic_vector(3693,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11025114,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(118400992,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111001" =>
            inv <= conv_std_logic_vector(3686,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11534410,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(203065005,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111010" =>
            inv <= conv_std_logic_vector(3680,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11971720,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(229464861,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111011" =>
            inv <= conv_std_logic_vector(3673,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12482818,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(7696520,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111100" =>
            inv <= conv_std_logic_vector(3667,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12921677,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(49003431,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111101" =>
            inv <= conv_std_logic_vector(3660,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13434587,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(267260840,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111110" =>
            inv <= conv_std_logic_vector(3654,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(13875007,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(58597277,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "000111111" =>
            inv <= conv_std_logic_vector(3648,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14316150,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(59000478,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "001000000" =>
            inv <= conv_std_logic_vector(3641,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(14831735,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(2814011,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "001000001" =>
            inv <= conv_std_logic_vector(3635,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15274454,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(104571506,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "001000010" =>
            inv <= conv_std_logic_vector(3629,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(15717905,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(35857837,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "001000011" =>
            inv <= conv_std_logic_vector(3623,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16162089,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(177959810,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "001000100" =>
            inv <= conv_std_logic_vector(3616,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(16681235,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(165401956,28);
            logexp <= conv_std_logic_vector(1019,11);
      WHEN "001000101" =>
            inv <= conv_std_logic_vector(3610,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(174901,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(50275830,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001000110" =>
            inv <= conv_std_logic_vector(3604,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(398163,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(88951577,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001000111" =>
            inv <= conv_std_logic_vector(3598,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(621797,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(127737931,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001000" =>
            inv <= conv_std_logic_vector(3592,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(845804,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(231522955,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001001" =>
            inv <= conv_std_logic_vector(3585,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1107620,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(57821111,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001010" =>
            inv <= conv_std_logic_vector(3579,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1332440,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(156464157,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001011" =>
            inv <= conv_std_logic_vector(3573,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1557638,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(44535294,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001100" =>
            inv <= conv_std_logic_vector(3567,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(1783214,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(62397887,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001101" =>
            inv <= conv_std_logic_vector(3561,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2009170,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(15263403,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001110" =>
            inv <= conv_std_logic_vector(3555,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2235506,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(246944822,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001001111" =>
            inv <= conv_std_logic_vector(3549,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2462226,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(29255593,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010000" =>
            inv <= conv_std_logic_vector(3543,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2689328,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(246376003,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010001" =>
            inv <= conv_std_logic_vector(3537,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(2916816,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(173639564,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010010" =>
            inv <= conv_std_logic_vector(3531,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3144690,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(161899610,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010011" =>
            inv <= conv_std_logic_vector(3525,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3372952,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(26928617,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010100" =>
            inv <= conv_std_logic_vector(3519,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3601602,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(123172243,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010101" =>
            inv <= conv_std_logic_vector(3513,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(3830643,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(1584354,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010110" =>
            inv <= conv_std_logic_vector(3507,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4060075,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(20252153,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001010111" =>
            inv <= conv_std_logic_vector(3502,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4251568,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(137854980,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011000" =>
            inv <= conv_std_logic_vector(3496,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4481721,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(231322588,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011001" =>
            inv <= conv_std_logic_vector(3490,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4712270,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(147480442,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011010" =>
            inv <= conv_std_logic_vector(3484,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(4943215,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(251536037,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011011" =>
            inv <= conv_std_logic_vector(3478,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5174559,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(105278949,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011100" =>
            inv <= conv_std_logic_vector(3473,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5367650,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(181375864,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011101" =>
            inv <= conv_std_logic_vector(3467,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5599727,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(133308340,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011110" =>
            inv <= conv_std_logic_vector(3461,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(5832206,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(80096944,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001011111" =>
            inv <= conv_std_logic_vector(3455,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6065088,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(127763081,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100000" =>
            inv <= conv_std_logic_vector(3450,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6259466,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(27642512,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100001" =>
            inv <= conv_std_logic_vector(3444,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6493091,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(120806774,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100010" =>
            inv <= conv_std_logic_vector(3438,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6727124,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(44281139,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100011" =>
            inv <= conv_std_logic_vector(3433,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(6922463,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(171170237,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100100" =>
            inv <= conv_std_logic_vector(3427,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7157246,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(240302137,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100101" =>
            inv <= conv_std_logic_vector(3422,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7353213,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(222094360,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100110" =>
            inv <= conv_std_logic_vector(3416,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7588752,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(122671437,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001100111" =>
            inv <= conv_std_logic_vector(3411,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(7785350,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(239607246,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101000" =>
            inv <= conv_std_logic_vector(3405,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8021649,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(206841234,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101001" =>
            inv <= conv_std_logic_vector(3399,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8258365,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(107795018,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101010" =>
            inv <= conv_std_logic_vector(3394,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8455947,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(226201607,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101011" =>
            inv <= conv_std_logic_vector(3388,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8693431,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(94327085,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101100" =>
            inv <= conv_std_logic_vector(3383,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(8891655,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(206124156,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101101" =>
            inv <= conv_std_logic_vector(3378,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9090173,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(99984141,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101110" =>
            inv <= conv_std_logic_vector(3372,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9328782,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(195833281,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001101111" =>
            inv <= conv_std_logic_vector(3367,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9527948,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(110283065,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110000" =>
            inv <= conv_std_logic_vector(3361,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9767338,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(282511,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110001" =>
            inv <= conv_std_logic_vector(3356,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(9967156,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(1157748,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110010" =>
            inv <= conv_std_logic_vector(3351,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10167271,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(250247631,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110011" =>
            inv <= conv_std_logic_vector(3345,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10407805,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(150148144,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110100" =>
            inv <= conv_std_logic_vector(3340,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10608580,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(15841264,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110101" =>
            inv <= conv_std_logic_vector(3335,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(10809655,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(92492368,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110110" =>
            inv <= conv_std_logic_vector(3329,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11051343,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(267282110,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001110111" =>
            inv <= conv_std_logic_vector(3324,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11253084,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(51811246,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001111000" =>
            inv <= conv_std_logic_vector(3319,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11455128,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(21159361,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001111001" =>
            inv <= conv_std_logic_vector(3314,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11657476,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(152694737,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001111010" =>
            inv <= conv_std_logic_vector(3308,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(11900698,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(34843865,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001111011" =>
            inv <= conv_std_logic_vector(3303,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12103719,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(266488285,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001111100" =>
            inv <= conv_std_logic_vector(3298,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12307049,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(112230017,28);
            logexp <= conv_std_logic_vector(1020,11);
      WHEN "001111101" =>
            inv <= conv_std_logic_vector(3293,12);
            logman(52 DOWNTO 29) <= conv_std_logic_vector(12510687,24);
            logman(28 DOWNTO 1) <= conv_std_logic_vector(91030082,28);
            logexp <= conv_std_logic_vector(