----------------------------------------------------------------------------- 
-- Altera DSP Builder Advanced Flow Tools Release Version 13.0sp1
-- Quartus II development tool and MATLAB/Simulink Interface
-- 
-- Legal Notice: Copyright 2013 Altera Corporation.  All rights reserved.    
-- Your use of  Altera  Corporation's design tools,  logic functions and other 
-- software and tools,  and its AMPP  partner logic functions, and  any output 
-- files  any of the  foregoing  device programming or simulation files),  and 
-- any associated  documentation or information are expressly subject  to  the 
-- terms and conditions  of the Altera Program License Subscription Agreement, 
-- Altera  MegaCore  Function  License  Agreement, or other applicable license 
-- agreement,  including,  without limitation,  that your use  is for the sole 
-- purpose of  programming  logic  devices  manufactured by Altera and sold by 
-- Altera or its authorized  distributors.  Please  refer  to  the  applicable 
-- agreement for further details.
----------------------------------------------------------------------------- 

-- VHDL created from bldc1_Fins_Controller_HW_DUT_HIL_out
-- VHDL created on Fri May 17 08:26:09 2013


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.NUMERIC_STD.all;
use IEEE.MATH_REAL.all;
use std.TextIO.all;
use work.dspba_library_package.all;
USE work.bldc1_Fins_Controller_HW_DUT_safe_path.all;

LIBRARY altera_mf;
USE altera_mf.altera_mf_components.all;
LIBRARY lpm;
USE lpm.lpm_components.all;

-- Text written from d:/SJ/nightly/13.0sp1/212/w64/p4/ip/aion/src/mip_common/hw_model.cpp:1303
entity bldc1_Fins_Controller_HW_DUT_HIL_out is
    port (
        validHIL : in std_logic_vector(0 downto 0);
        channelHIL : in std_logic_vector(7 downto 0);
        ControllerOutHIL : in std_logic_vector(31 downto 0);
        busIn_d : in std_logic_vector(31 downto 0);
        busIn_a : in std_logic_vector(9 downto 0);
        busIn_w : in std_logic_vector(0 downto 0);
        busOut_v : out std_logic_vector(0 downto 0);
        busOut_r : out std_logic_vector(31 downto 0);
        vout : out std_logic_vector(0 downto 0);
        cout : out std_logic_vector(7 downto 0);
        ControllerOut : out std_logic_vector(31 downto 0);
        clk : in std_logic;
        areset : in std_logic;
        bus_clk : in std_logic;
        bus_areset : in std_logic
        );
end;

architecture normal of bldc1_Fins_Controller_HW_DUT_HIL_out is

    attribute altera_attribute : string;
    attribute altera_attribute of normal : architecture is "-name NOT_GATE_PUSH_BACK OFF; -name PHYSICAL_SYNTHESIS_REGISTER_DUPLICATION ON; -name AUTO_SHIFT_REGISTER_RECOGNITION OFF; -name MESSAGE_DISABLE 10036; -name MESSAGE_DISABLE 10037; -name MESSAGE_DISABLE 14130; -name MESSAGE_DISABLE 14320; -name MESSAGE_DISABLE 15400; -name MESSAGE_DISABLE 14130; -name MESSAGE_DISABLE 10036; -name MESSAGE_DISABLE 12020; -name MESSAGE_DISABLE 12030; -name MESSAGE_DISABLE 12010; -name MESSAGE_DISABLE 12110; -name MESSAGE_DISABLE 14320; -name MESSAGE_DISABLE 13410";

    signal VCC_q : std_logic_vector (0 downto 0);
    signal latch_0L_SampleDelay_q : std_logic_vector (31 downto 0);
    signal busReadSelector_q : std_logic_vector (31 downto 0);
    signal busReadSelector_v : std_logic_vector (0 downto 0);
    signal RegOut_dec_h : std_logic_vector(0 downto 0);
    signal RegOut_q : std_logic_vector (31 downto 0);
    signal latch_0L_Mux_s : std_logic_vector (0 downto 0);
    signal latch_0L_Mux_q : std_logic_vector (31 downto 0);
begin


	--GND(CONSTANT,0)

	--ChannelIn(PORTIN,2)@1

	--RegOut(REG,19)@1
    RegOut: PROCESS (clk, areset)
    BEGIN
        IF (areset = '1') THEN
            RegOut_q <= "00000000000000000000000000000000";
        ELSIF rising_edge(clk) THEN
            IF (validHIL = "1") THEN
                RegOut_q <= ControllerOutHIL;
            END IF;
        END IF;
    END PROCESS;


	--busIn(BUSIN,12)

	--RegOut_dec(DECODE,18)@0
    RegOut_dec: PROCESS (bus_clk, bus_areset)
    BEGIN
        IF (bus_areset = '1') THEN
            RegOut_dec_h <= (others => '0');
        ELSIF(bus_clk'EVENT AND bus_clk = '1') THEN
            IF UNSIGNED(busIn_a(9 downto 0)) = 5 THEN
                RegOut_dec_h <= "1";
            ELSE
                RegOut_dec_h <= "0";
            END IF;
        END IF;
    END PROCESS;


	--VCC(CONSTANT,1)
    VCC_q <= "1";

	--busReadSelector(SELECTOR,13)@0
    busReadSelector: PROCESS (bus_clk, bus_areset)
        VARIABLE q : STD_LOGIC_VECTOR(31 downto 0);
        VARIABLE v : STD_LOGIC_VECTOR(0 downto 0);
    BEGIN
        IF (bus_areset = '1') THEN
            busReadSelector_q <= (others => '0');
            busReadSelector_v <= "0";
        ELSIF (bus_clk'EVENT AND bus_clk = '1') THEN
            q := (others => '0');
            v := "0";
            -- guarantee zero: false
            IF (RegOut_dec_h = "1") THEN
                q := q or RegOut_q;
                v := v or "1";
            END IF;
            busReadSelector_q <= q;
            busReadSelector_v <= v;
        END IF;
    END PROCESS;


	--busOut(BUSOUT,14)@1
    busOut_v <= busReadSelector_v;
    busOut_r <= busReadSelector_q;


	--latch_0L_SampleDelay(DELAY,9)@1
    latch_0L_SampleDelay : dspba_delay
    GENERIC MAP ( width => 32, depth => 1 )
    PORT MAP ( xin => latch_0L_Mux_q, xout => latch_0L_SampleDelay_q, clk => clk, aclr => areset );

	--latch_0L_Mux(MUX,8)@1
    latch_0L_Mux_s <= validHIL;
    latch_0L_Mux: PROCESS (latch_0L_Mux_s, latch_0L_SampleDelay_q, ControllerOutHIL)
    BEGIN
            CASE latch_0L_Mux_s IS
                  WHEN "0" => latch_0L_Mux_q <= latch_0L_SampleDelay_q;
                  WHEN "1" => latch_0L_Mux_q <= ControllerOutHIL;
                  WHEN OTHERS => latch_0L_Mux_q <= (others => '0');
            END CASE;
    END PROCESS;


	--ChannelOut(PORTOUT,3)@1
    vout <= validHIL;
    cout <= channelHIL;
    ControllerOut <= latch_0L_Mux_q;


end normal;
