

#**************************************************************
# Create Clock
#**************************************************************

# JTAG Signal Constraints constrain the TCK port, assuming a 10MHz JTAG clock and 3ns delays
create_clock -name {altera_reserved_tck} -period 41.667 [get_ports { altera_reserved_tck }]
set_input_delay -clock altera_reserved_tck -clock_fall -max 5 [get_ports altera_reserved_tdi]
set_input_delay -clock altera_reserved_tck -clock_fall -max 5 [get_ports altera_reserved_tms]
set_output_delay -clock altera_reserved_tck 5 [get_ports altera_reserved_tdo]



create_clock -name {clk_config} -period 10.000 -waveform { 0.000 5.000 } [get_ports {clk_config}]
#create_clock -name {clkin_50} -period 20.000 -waveform { 0.000 10.000 } [get_ports {clkin_50}]
create_clock -name {flash_clk} -period 20.000 -waveform { 0.000 10.000 } [get_ports {flash_clk}]
create_clock -name {fpga_dclk} -period 10.000 -waveform { 0.000 5.000 } [get_ports {fpga_dclk}]
create_clock -name {clkin_50} -period 20.000 -waveform {0 10} {clkin_max_50}

#create_clock -name {fppovj_clk} -period 10.000 -waveform {0 5} {pfl_control:pfl_control_inst|fppOvj:fppOvj_inst|vj_decode:vj_decode_inst|clk_out_int}
create_generated_clock -name fppovj_clk -source [get_ports {clk_config}] -divide_by 1 {pfl_control:pfl_control_inst|fppOvj:fppOvj_inst|vj_decode:vj_decode_inst|clk_out_int}

#**************************************************************
# Create Generated Clock
#**************************************************************



#**************************************************************
# Set Clock Latency
#**************************************************************



#**************************************************************
# Set Clock Uncertainty
#**************************************************************



#**************************************************************
# Set Input Delay
#**************************************************************

set_input_delay -add_delay  -clock [get_clocks {clkin_50}]  2.000 [get_ports {sense_smb_data}]

set_input_delay -clock clkin_50 1 [get_ports fm_a[*]]
set_input_delay -clock clkin_50 1 [get_ports clock_scl]
set_input_delay -clock clkin_50 1 [get_ports max5_*]


#**************************************************************
# Set Output Delay
#**************************************************************

set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  0.000 [get_ports {fpga_dclk}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  0.000 [get_ports {fpga_dclk}]
set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  0.000 [get_ports {flash_clk}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  0.000 [get_ports {flash_clk}]

set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  3.500 [get_ports {flash_advn}]
set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  3.500 [get_ports {flash_oen}]
set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  3.500 [get_ports {flash_wen}]
set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  3.500 [get_ports {flash_cen[*]}]
set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  3.500 [get_ports {flash_advn}]
set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  3.500 [get_ports {flash_resetn}]
set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  3.500 [get_ports {fpga_config_d[*]}]


set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  -1.000 [get_ports {flash_advn}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  -1.000 [get_ports {flash_oen}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  -1.000 [get_ports {flash_wen}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  -1.000 [get_ports {flash_cen[*]}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  -1.000 [get_ports {flash_advn}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  -1.000 [get_ports {flash_resetn}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  -1.000 [get_ports {fpga_config_d[*]}]

set_output_delay -add_delay -max -clock [get_clocks {clkin_50}]  0.500 [get_ports {sense_smb_clk}]
set_output_delay -add_delay -min -clock [get_clocks {clkin_50}]  0.000 [get_ports {sense_smb_clk}]
set_output_delay -add_delay -max -clock [get_clocks {sense_smb_clk}]  2.500 [get_ports {sense_smb_data}]
set_output_delay -add_delay -min -clock [get_clocks {sense_smb_clk}]  0.500 [get_ports {sense_smb_data}]


set_output_delay  -clock [ get_clocks clkin_50 ] 2   [ get_ports {sense_cs0n} ]
set_output_delay  -clock [ get_clocks clkin_50 ] 2   [ get_ports {sense_smb_data} ]

#**************************************************************
# Set Clock Groups
#**************************************************************

set_clock_groups -asynchronous -group [get_clocks {altera_reserved_tck}] 
set_clock_groups -asynchronous -group [get_clocks {altera_reserved_tck}] 
set_clock_groups -asynchronous -group [get_clocks {altera_reserved_tck}] 
set_clock_groups -asynchronous -group [get_clocks {altera_reserved_tck}] 


#**************************************************************
# Set False Path
#**************************************************************

#set_false_path  -from  [get_clocks {clkin_50}]  -to  [get_clocks {fpga_dclk}]
set_false_path -from [get_ports {fm_d[*]}] 
set_false_path -from [get_ports {fpga_conf_done}] 
set_false_path -from [get_ports {fpga_nstatus}] 
set_false_path -from [get_ports {pcie_jtag_en}] 
set_false_path -from [get_ports {pgm_config}] 
set_false_path -to [get_ports {fm_*}]
set_false_path -from [get_ports {factory_load}] 
set_false_path -from [get_ports {pgm_sel}] 
set_false_path -to [get_ports {max_error}]
set_false_path -to [get_ports {overtemp}]
set_false_path -to [get_ports {fpga_nconfig}]
set_false_path -to [get_ports {flash_resetn}]
set_false_path -to [get_ports {pgm_led[*]}]

set_false_path -from [get_ports {factory_status}] -to *
set_false_path -from [get_ports {security_mode}] -to *
set_false_path -from [get_ports {clock_sda}] -to *
set_false_path -from [get_ports {sense_sdo}] -to *

set_false_path -from * -to [get_ports {factory_request}]
set_false_path -from * -to [get_ports {fpga_nstatus}]
set_false_path -from * -to [get_ports {m570_clock}]
set_false_path -from * -to [get_ports {m570_pcie_jtag_en}]
set_false_path -from * -to [get_ports {sense_sck}]
set_false_path -from * -to [get_ports {sense_sdi}]
set_false_path -from * -to [get_ports {clock_scl}]
set_false_path -from * -to [get_ports {clock_sda}]

#**************************************************************
# Set Multicycle Path
#**************************************************************



#**************************************************************
# Set Maximum Delay
#**************************************************************



#**************************************************************
# Set Minimum Delay
#**************************************************************



#**************************************************************
# Set Input Transition
#**************************************************************




#JTAG Signal Constraints
#constrain the TDI TMS and TDO ports  -- (modified from timequest SDC cookbook)

set_false_path -from * -to [get_ports {cpu_resetn}]
set_false_path -from [get_ports {cpu_resetn}] -to *

set_false_path -from [get_ports {fpga_msel[*]}] -to *

set_false_path -from * -to fpga_msel[*]

set_false_path -from factory_user1 -to *
set_false_path -from max_* -to *


set_false_path -from * -to sense_csn
set_false_path -from * -to flash_cen

set_false_path -from [get_clocks {clk_config}] -to [get_clocks {clkin_50}]
set_false_path -from [get_clocks {clkin_50}] -to [get_clocks {clk_config}]


set_false_path -from {pfl_control:pfl_control_inst|fppOvj:fppOvj_inst|vj_decode:vj_decode_inst|clk_count[*]} -to *