library ieee;
use ieee.std_logic_1164.all;

entity sys_max_id is
	port (
		reset_n: in std_logic;
		clk : in std_logic;
		
		 version : in std_logic_vector(15 downto 0);
		 project_id : in std_logic_vector(15 downto 0);
		
		
		-- interface for AvMM-slave
		slv_en_n : in std_logic;
		slv_address : in std_logic_vector(2 downto 0);
		slv_read_n : in std_logic;
		slv_write_n : in std_logic;
		slv_data_in : in  std_logic_vector(31 downto 0);
		slv_data_out : out std_logic_vector(31 downto 0);
		slv_waitrequest_n : out std_logic -- 0: under process   1:process done, same ad wait_n
		
	);
end sys_max_id;


architecture rtl of sys_max_id is
	signal trigger, trigger_d1, trigger_d2, trigger_pls : std_logic;

begin

	process(clk, reset_n)begin
		if(reset_n = '0')then
			slv_data_out <= x"00000000";
		elsif(clk'event and clk = '1')then
			if(slv_en_n = '0' and slv_read_n = '0')then
				if(slv_address = "000")then
					slv_data_out <= x"0000" & version;
				elsif(slv_address = "001")then
					slv_data_out <= x"0000" & project_id;
				else
					slv_data_out <= x"deadbeef";
				end if;
			end if;
		end if;
	end process;
	
	process(clk, reset_n)begin
		if(reset_n = '0')then
			trigger <= '0';
		elsif(clk'event and clk = '1')then
			if(slv_en_n = '0' and slv_read_n = '0')then
				trigger <= '1';
			else
				trigger <= '0';
			end if;
		end if;
	end process;
	
	process(clk, reset_n)begin
		if(reset_n = '0')then
			trigger_d1 <= '0';
			trigger_d2 <= '1';
		elsif(clk'event and clk = '1')then
			trigger_d1 <= trigger_d2;
			trigger_d1 <= not trigger;
		end if;
	end process;
	
	trigger_pls <= trigger and trigger_d2;
	
	
	process(clk, reset_n)begin
		if(reset_n = '0')then
			slv_waitrequest_n <= '1';
		elsif(clk'event and clk = '1')then
			if(trigger_pls = '1')then
				slv_waitrequest_n <= '1';
			elsif(slv_en_n = '1' or slv_read_n = '1')then
				slv_waitrequest_n <= '0';
			end if;
		end if;
	end process;
	
	
end rtl;
