--Legal Notice: (C)2009 Altera Corporation. All rights reserved.  Your
--use of Altera Corporation's design tools, logic functions and other
--software and tools, and its AMPP partner logic functions, and any
--output files any of the foregoing (including device programming or
--simulation files), and any associated documentation or information are
--expressly subject to the terms and conditions of the Altera Program
--License Subscription Agreement or other applicable license agreement,
--including, without limitation, that your use is for the sole purpose
--of programming logic devices manufactured by Altera and sold by Altera
--or its authorized distributors.  Please refer to the applicable
--agreement for further details.

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;


entity fpga_interface_sopc is
	port
	(
		--Global signals
		reset_n: in std_logic;
		system_clk : in std_logic;
		
		--FPGA interface
		max_csn: in std_logic;
		max_wen: in std_logic;
		max_oen: in std_logic;
		address: in std_logic_vector(2 downto 0);
		data_in: in std_logic_vector(15 downto 0);
		data_out: out std_logic_vector(15 downto 0);
		
		--dipswitch/PFL interface
		dsw_pagesel: in std_logic_vector(2 downto 0);
		pfl_pagesel: out std_logic_vector(2 downto 0);
		srst_out : out std_logic;
		
		pfl_en : in std_logic;
		
		
		-- board setting
		MAX_VER : in std_logic_vector(7 downto 0);
		factory_confign : in std_logic
		
	);

end fpga_interface_sopc;


architecture rtl of fpga_interface_sopc is
	
--	constant REGFILE_TOP: integer := 4;
--	type regfile_t is array(1 to REGFILE_TOP) of std_logic_vector(15 downto 0);
	type regfile_t is array(1 to 2) of std_logic_vector(15 downto 0);
	signal regfile: regfile_t;
	
--	alias pss is regfile(2)(3 downto 0);
--	alias pso is regfile(2)(4);
--	alias psr is regfile(2)(10 downto 8);
--	alias srst is regfile(2)(11);
		
--	signal srst_d1, srst_d2 : std_logic;
	
	signal reset_count : integer range 0 to 15;
	signal pfl_pagesel_int : std_logic_vector(2 downto 0);
	

	signal srst_protect : integer range 0 to 7;
	

begin

---------------------------------------------------------------------------------------------------------
-- FPGA interface logic
---------------------------------------------------------------------------------------------------------

	process(reset_n,system_clk, regfile)begin	
		
		-------------------------------------------------
		--Reset clause
		-------------------------------------------------
		if(reset_n = '0')then
			regfile(2)(4) <= '1'; -- pso
			regfile(2)(11) <= '1'; -- srst bit
			regfile(2)(10 downto 8) <= "111"; -- psr bits
			regfile(2)(15 downto 12) <= "0000";
			regfile(2)(7 downto 5) <= "000";
			
		-------------------------------------------------
		--Operating clause
		-------------------------------------------------
		elsif(system_clk'event and system_clk = '1')then
			if(max_csn = '0' and max_wen = '0')then
--				case address(4 downto 1) is
				case address(2 downto 1) is
--					when "0010" => 
					when "10" => 
							regfile(2)(10 downto 8)	<= data_in(10 downto 8); -- PSR
							regfile(2)(4)<= data_in(4); -- PSO
							regfile(2)(11)		<= data_in(11); --SRST
--					when "0011" => regfile(1) <= data_in(15 downto 0);
					when "11" => regfile(1) <= data_in(15 downto 0);
					when others => null;
				end case;
			elsif(srst_protect = 7)then
				regfile(2)(11) <= '1'; -- clear the srst bit
			end if;
		end if;
	end process;
	
	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			srst_protect <= 7;
		elsif(system_clk'event and system_clk = '1')then
			if(max_csn = '0' and max_wen = '0')then
				srst_protect <= 0;
			elsif(srst_protect = 7)then
				srst_protect <= 7;
			else
				srst_protect <= srst_protect + 1;
			end if;
		end if;
	end process;
	
	
	process(reset_n, system_clk)begin	
		if(reset_n = '0')then
			data_out <= (others => '1');
		elsif(system_clk'event and system_clk = '1')then
			if(max_oen = '0' and max_csn = '0')then
--				case address(4 downto 1) is
				case address(2 downto 1) is
--					when "0000" => data_out <= x"A862";  -- 0xA862 is the serial number of the S4GT host kit.
--					when "0001" => data_out <= x"00" & MAX_VER;  -- MAX-II program Rev
--					when "0010" => data_out <= regfile(2); -- control reg RSU
--					when "0011" => data_out <= regfile(1); -- reserved
					when "00" => data_out <= x"A862";  -- 0xA862 is the serial number of the S4GT host kit.
					when "01" => data_out <= x"00" & MAX_VER;  -- MAX-II program Rev
					when "10" => data_out <= regfile(2); -- control reg RSU
					when "11" => data_out <= regfile(1); -- reserved
					when others => data_out <= (others => '1');
				end case;
			end if;
		end if;
	end process;


---------------------------------------------------------------------------------------------------------
--dipswitch/PFL interface
---------------------------------------------------------------------------------------------------------
	regfile(2)(2 downto 0) <= dsw_pagesel(2 downto 0);	
	
	process(reset_n, system_clk)begin	
		if(reset_n = '0')then
			pfl_pagesel_int <= dsw_pagesel(2 downto 0);	
		elsif(system_clk'event and system_clk = '1')then
			if(factory_confign = '0')then
				pfl_pagesel_int <= "000";
			elsif(pfl_en = '1')then -- do not change the pagesel during configuration
				pfl_pagesel_int <= pfl_pagesel_int;
			elsif(regfile(2)(4) = '1')then --pso	
				pfl_pagesel_int  <= dsw_pagesel(2 downto 0);			
			else
				pfl_pagesel_int  <= regfile(2)(10 downto 8); --psr
			end if;
		end if;
	end process;
	pfl_pagesel <= pfl_pagesel_int;

	
	
	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			reset_count <= 15;
		elsif(system_clk'event and system_clk = '1')then
			if(regfile(2)(11) = '0' and max_csn = '1')then --srst
				reset_count <= 0;
			elsif(reset_count = 15)then
				reset_count <= reset_count;
			else
				reset_count <= reset_count + 1;
			end if;
		end if;
	end process;

	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			srst_out <= '1';	
		elsif(system_clk'event and system_clk = '1')then
			if(reset_count = 15)then
				srst_out <= '1';
			else
				srst_out <= '0';
			end if;
		end if;
	end process;

end rtl;

