library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity avalon_external_master is
	generic (
		address_width : integer := 18
	);
	port (
		--Global signals
		reset_n: in std_logic;
		system_clk : in std_logic; -- expecting 50Mhz
		clk_pls_p : in std_logic; --48.828KHz or 20.480us
		
		--FPGA interface comes/goes external of chip
		max_csn: in std_logic;
		max_wen: in std_logic;
		max_oen: in std_logic;
		address: in std_logic_vector(address_width-1 downto 0);
		data: inout std_logic_vector(15 downto 0);
		
	-- for Avalon BUS master
		nios_address : out std_logic_vector(31 downto 0);
		nios_write_n : out std_logic;
		nios_read_n : out std_logic;
		nios_waitrequest_n : in std_logic;

		nios_data_in : in  std_logic_vector(31 downto 0);
		nios_data_out : out std_logic_vector(31 downto 0)					  
	);

end entity avalon_external_master;


architecture rtl of avalon_external_master is
	
	signal data_int : std_logic_vector(31 downto 0);
	signal readTimeOut : integer range 0 to 500;
	signal nios_address_int : std_logic_vector(31 downto 0);
	signal nios_read_n_int : std_logic;

begin

---------------------------------------------------------------------------------------------------------
-- FPGA interface logic
---------------------------------------------------------------------------------------------------------

	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			nios_data_out <= (others => '0');
			nios_write_n <= '1';
		elsif(system_clk'event and system_clk = '1')then
			if(max_wen = '0' and max_csn = '0')then
				nios_write_n <= '0'; -- start writing data
				nios_data_out(15 downto 0) <= data;
--			elsif(readTimeOut = 500000)then  -- either finish process or timed out
			elsif(readTimeOut = 500)then  -- either finish process or timed out
				nios_data_out <= (others => '0');
				nios_write_n <= '1';
			end if;
		end if;
	end process;
	
	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			data <= (others => 'Z');
		elsif(system_clk'event and system_clk = '1')then
			if(max_oen = '0' and max_csn = '0')then
				data <= data_int(15 downto 0);
			else
				data <= (others => 'Z');
			end if;
		end if;
	end process;


	-- generating read control signal at here
	-- and copying the coming back read data 
	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			data_int <= (others => '0');
			nios_read_n_int <= '1';
		elsif(system_clk'event and system_clk = '1')then
			if(max_oen = '0' and max_csn = '0')then
				nios_read_n_int <= '0'; -- start reading data
--			elsif(readTimeOut = 500000)then  -- either finish process or timed out
			elsif(readTimeOut = 500)then  -- either finish process or timed out
				nios_read_n_int <= '1';
--			elsif(readTimeOut = 499999 or nios_waitrequest_n = '1')then  -- either finish process or timed out
			elsif(readTimeOut = 499 or nios_waitrequest_n = '1')then  -- either finish process or timed out
				data_int <= nios_data_in;
			end if;
		end if;
	end process;
	
	nios_read_n <= nios_read_n_int;
	
	-- start the read time out timer
	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			readTimeOut <= 0;
		elsif(system_clk'event and system_clk = '1')then
			if(max_oen = '0' and max_csn = '0')then
				readTimeOut <= 0;
			elsif(max_wen = '0' and max_csn = '0')then
				readTimeOut <= 0;
			elsif(clk_pls_p = '1')then
--				if(readTimeOut = 500000 or nios_waitrequest_n = '1')then -- end condition
--					readTimeOut <= 500000;
				if(readTimeOut = 500 or nios_waitrequest_n = '1')then -- end condition
					readTimeOut <= 500;
				else
					readTimeOut <= readTimeOut + 1;
				end if;
			end if;
		end if;
	end process;


	-- controlling the address signal
	process(reset_n, system_clk)begin
		if(reset_n = '0')then
			nios_address_int <= (others => '0');
		elsif(system_clk'event and system_clk = '1')then
			if(max_csn = '0')then -- this helps to keep the address until next access and gives a time to process
				nios_address_int(address_width-1 downto 0) <= address;
			end if;
		end if;
	end process;
	nios_address <= nios_address_int;
	

end rtl;

