//a wrapper to allow simulation to drive the avalon bus directly

module alt_jtagavalon_wrapper (
    av_clk,
    av_rst,
    av_address,
    av_write,
    av_read,
    av_waitrequest,
    av_writedata,
    av_readdata
);
parameter ADDR_WIDTH = 32;
parameter DATA_WIDTH = 32;
parameter INSTANCE_ID = 0;
parameter MODE_WIDTH = 3;
parameter SLD_AUTO_INSTANCE_INDEX = "NO";
parameter OWNER_ID = 8'h0;
parameter USAGE_ID = 12'h0;
parameter USER_ID1 = 8'h0;
parameter USER_ID2 = 12'h0;

input                   av_clk;
input                   av_rst;
output [ADDR_WIDTH-1:0] av_address;
output                  av_write;
output                  av_read;
input                   av_waitrequest;
output [DATA_WIDTH-1:0] av_writedata;
input  [DATA_WIDTH-1:0] av_readdata;

wire                    av_write;
wire                    av_read;

//in simulation drive this bus from the testbench ...
//synthesis translate_off
reg    [ADDR_WIDTH-1:0] av_address;
reg                     av_read_n;
reg                     av_write_n;
reg    [DATA_WIDTH-1:0] av_writedata;
//synthesis translate_on

//synthesis read_comments_as_HDL on
//wire   [ADDR_WIDTH-1:0] av_address;
//wire                    av_read_n;
//wire                    av_write_n;
//wire   [DATA_WIDTH-1:0] av_writedata;
//
//alt_jtagavalon alt_jtagavalon
//(
//    .clk            (av_clk),
//    .rst_n          (~av_rst),
//    .av_address     (av_address),
//    .av_write_n     (av_write_n),
//    .av_read_n      (av_read_n),
//    .av_waitrequest (av_waitrequest),
//    .av_writedata   (av_writedata),
//    .av_readdata    (av_readdata)
//);
//defparam alt_jtagavalon.ADDR_WIDTH = ADDR_WIDTH;
//defparam alt_jtagavalon.DATA_WIDTH = DATA_WIDTH;
//defparam alt_jtagavalon.INSTANCE_ID = INSTANCE_ID;
//defparam alt_jtagavalon.MODE_WIDTH = MODE_WIDTH;
//defparam alt_jtagavalon.SLD_AUTO_INSTANCE_INDEX = SLD_AUTO_INSTANCE_INDEX;
//defparam alt_jtagavalon.OWNER_ID = OWNER_ID;
//defparam alt_jtagavalon.USAGE_ID = USAGE_ID;
//defparam alt_jtagavalon.USER_ID1 = USER_ID1;
//defparam alt_jtagavalon.USER_ID2 = USER_ID2;
//synthesis read_comments_as_HDL off

assign av_read  = ~av_read_n;
assign av_write = ~av_write_n;

endmodule

