#Copyright (C)2001-2003 Altera Corporation
#Any megafunction design, and related net list (encrypted or decrypted),
#support information, device programming or simulation file, and any other
#associated documentation or information provided by Altera or a partner
#under Altera's Megafunction Partnership Program may be used only to
#program PLD devices (but not masked PLD devices) from Altera.  Any other
#use of such megafunction design, net list, support information, device
#programming or simulation file, or any other related documentation or
#information is prohibited for any other purpose, including, but not
#limited to modification, reverse engineering, de-compiling, or use with
#any other silicon devices, unless such use is explicitly licensed under
#a separate agreement with Altera or a megafunction partner.  Title to
#the intellectual property, including patents, copyrights, trademarks,
#trade secrets, or maskworks, embodied in any such megafunction design,
#net list, support information, device programming or simulation file, or
#any other related documentation or information provided by Altera or a
#megafunction partner, remains with Altera, the megafunction partner, or
#their respective licensors.  No other licenses, including any licenses
#needed under any third party's intellectual property, are provided herein.
#Copying or modifying any file, or portion thereof, to which this notice
#is attached violates this copyright.

use strict;
use europa_all;
use format_conversion_utils;
use wiz_utils;

my $project = e_project->new (@ARGV);
&make_mem ($project->top(), $project);
$project->output();


sub make_mem
{
    my ($module, $project) = (@_);
    my $Opt = &copy_of_hash($project->WSA());
    $Opt->{name} = $module->name();

    &instantiate_alt_jtagavalon($module, $Opt, $project);

    e_avalon_master->new({within => $module, name   => "master"});

#want to copy
#<component_lib>/verilog/alt_jtagavalon_wrapper.v --> project directory
    my $file1 = "alt_jtagavalon_wrapper.v";
    my $src = $project->_module_lib_dir()."/verilog/".$file1;
    my $dst = $project->_system_directory()."/".$file1;
    &Perlcopy ($src, $dst);

#want to copy
#<component_lib>/verilog/alt_jtagavalon.v --> project directory
    my $file1 = "alt_jtagavalon.v";
    my $src = $project->_module_lib_dir()."/verilog/".$file1;
    my $dst = $project->_system_directory()."/".$file1;
    &Perlcopy ($src, $dst);

    return $module;
}



sub instantiate_alt_jtagavalon
{
    my ($module, $Opt, $project) = (@_);
    my $marker = e_default_module_marker->new ($module);

    e_port->adds(
        ["clk",             1,                      "in" ],
        ["reset",           1,                      "in" ],

        ["address",         $Opt->{addr_width},     "out" ],
        ["write",           1,                      "out" ],
        ["read",            1,                      "out" ],
        ["writedata",       $Opt->{data_width},     "out" ],
        ["readdata",        $Opt->{data_width},     "in"],
        ["waitrequest",     1,                      "in"],
    );


    my $in_port_map = {
             av_clk         => 'clk',
             av_rst         => 'reset',
             av_readdata    => 'readdata',
             av_waitrequest => 'waitrequest',
          };

    my $out_port_map = {
             av_address     => 'address',
             av_write       => 'write',
             av_read        => 'read',
             av_writedata   => 'writedata',
          };


    my $parameter_map = {

        DATA_WIDTH   => $Opt->{data_width},         
        ADDR_WIDTH   => $Opt->{addr_width},      
        MODE_WIDTH   => $Opt->{mode_width},         
        INSTANCE_ID  => $Opt->{instance_id},      
    };

    e_blind_instance->add({
       use_sim_models => 0,                        # ???
       name   => 'alt_jtagavalon_wrapper',
       module => 'alt_jtagavalon_wrapper',
       in_port_map => $in_port_map,
       out_port_map => $out_port_map,
       parameter_map => $parameter_map,
    });
    return $module;
}

