library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity fan_cont is
	port (
		reset_n: in std_logic;
		clk : in std_logic;
		clk_pls_p : in std_logic;
--		data_out_t_r : in std_logic_vector(15 downto 0);
--		data_out_t_r : in std_logic_vector(7 downto 0);

		fan_cont_out: out std_logic
	);
end fan_cont;


architecture rtl of fan_cont is	
--	signal counter : integer range 0 to 8191;
	signal counter : integer range 0 to 511;
--	signal speed : integer range 0 to 8191;
	signal speed : integer range 0 to 511;
	signal sp : integer range 0 to 15;
	signal temp : integer range 0 to 127;
	signal sp_int : std_logic_vector(3 downto 0);
	
	constant fan_speed_overwrite : std_logic := '0';
	constant fan_force_on : std_logic := '1'; -- not force on
	constant fan_force_on_fpga : std_logic := '1'; -- not force on


	signal ctr : integer range 0 to 73730 := 0;
	signal hold : std_logic;
	
begin


	process(reset_n, clk)begin
		if(reset_n = '0')then
			ctr <= 0;
			hold <= '1';
		elsif(clk'event and clk = '1')then
			if(clk_pls_p = '1')then
				if(ctr = 73730)then
					hold <= '0';
					ctr <= ctr;
				else
					hold <= '1';
					ctr <= ctr + 1;
				end if;
			end if;
		end if;
	end process;



	process(reset_n, clk)begin
		if(reset_n = '0')then
--			sp <= 15;
			speed <= 511;
		elsif(clk'event and clk = '1')then
			if(hold = '1')then
--				sp <= 15;
				speed <= 511;
			else
--				sp <= 6;
				speed <= 160;
			end if;
		end if;
	end process;			

	process(reset_n, clk)begin
		if(reset_n = '0')then
			counter <= 0;
		elsif(clk'event and clk = '1')then
			if(clk_pls_p = '1')then
--				if(sp > 1)then
					if(counter = 511)then -- faster freq
						counter <= 0;
					else
						counter <= counter + 1;
					end if;
--				else
--					if(counter = 8191)then -- much slower freq
--						counter <= 0;
--					else
--						counter <= counter + 1;
--					end if;
--				end if;	
			end if;
		end if;
	end process;


	process(reset_n, clk)begin
		if(reset_n = '0')then
			fan_cont_out <= '1'; -- fan off
		elsif(clk'event and clk = '1')then
			if(counter > speed)then
				fan_cont_out <= '1'; -- fan off
			else
				fan_cont_out <= '0'; -- fan on
			end if;
		end if;
	end process;

end rtl;