-- Copyright (C) 2007 - Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-------------------------------------------------------------------------------
--                                                                           --
-- Containing VHDL Model for the Atoms:                                      --
--                                                                           --
--                                 stratixiv_hssi_refclk_divider                   --
--                                                                           --
-------------------------------------------------------------------------------




LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;


ENTITY stratixiv_hssi_aux_clock_div IS
    GENERIC (
        clk_divide_by : INTEGER := 1;
        extra_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN STD_LOGIC;   
        reset                   : IN STD_LOGIC := '0';  
        powerdown               : IN STD_LOGIC := '0'; 
        enable_d                : IN STD_LOGIC := '0';
        d                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
        clkout                  : OUT STD_LOGIC
    );   
END stratixiv_hssi_aux_clock_div;

ARCHITECTURE clock_div_arch OF stratixiv_hssi_aux_clock_div IS  
    SIGNAL clk_edges                :  INTEGER := -1;     
    SIGNAL div_n_register           :  STD_LOGIC_VECTOR(2 * extra_latency DOWNTO 0)
                                                    := (OTHERS => '0');     
    SIGNAL d_factor : INTEGER := 1;
    FUNCTION to_int(arg : IN STD_LOGIC_VECTOR) RETURN INTEGER IS
    VARIABLE result : INTEGER;
    BEGIN
    result := 0;
    FOR i IN arg'RANGE LOOP
        IF arg(i) = '1' THEN
            result := result + 2**i;
        END IF;
    END LOOP;
    RETURN result;
    END to_int;

BEGIN

    d_factor <= to_int(d) WHEN (enable_d = '1') ELSE clk_divide_by;

    PROCESS(clk,reset,d_factor,powerdown)
    VARIABLE div_n : STD_LOGIC_VECTOR(2 * extra_latency DOWNTO 0) := (OTHERS => '0');
    VARIABLE m : INTEGER := 0;
    VARIABLE running_clk_edge : INTEGER := -1;
    BEGIN
        running_clk_edge := clk_edges;
        IF (powerdown = '1') THEN
            clk_edges <= -1;
            m := 0;    
            div_n := (OTHERS => '0'); 
        ELSIF (d_factor'EVENT) THEN
            clk_edges <= -1;
            m := 0;    
            div_n := (OTHERS => '0'); 
        ELSIF (reset = '1') THEN
            clk_edges <= -1;
            m := 0;    
            div_n := (OTHERS => '0');  
        ELSIF (clk'EVENT AND (clk = '1' OR clk = '0')) THEN
            IF (running_clk_edge = -1) THEN
                m := 0;
                div_n(0) := clk;
                IF (clk = '1') THEN running_clk_edge := 0; END IF;
            ELSIF (running_clk_edge mod d_factor = 0) THEN
                div_n(0) := NOT div_n(0);
            END IF;
            IF (running_clk_edge >= 0 OR clk = '1') THEN 
                clk_edges <= (running_clk_edge + 1) mod (2 * d_factor);
            END IF;
        END IF;
        
        m := 0;
        div_n_register(m) <= div_n(m); 
        WHILE (m < 2 * extra_latency) LOOP
            div_n_register(m+1) <=  div_n_register(m);  
            m := m + 1;
        END LOOP;
        
    END PROCESS;
    clkout <= div_n_register(2 * extra_latency);

END clock_div_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiv_hssi_components.ALL;

ENTITY stratixiv_hssi_aux_clock_mult IS
    GENERIC (
        clk_multiply_by : INTEGER := 1;
        pfd_fb_select : string := "internal"
    );
    PORT (
        clk                     : IN STD_LOGIC;   
        fbclk                   : IN STD_LOGIC;   
        adjust                  : IN STD_LOGIC := '0';   
        adjust_without_lol      : IN STD_LOGIC := '0';   
        reset                   : IN STD_LOGIC := '0';   
        enable_m                : IN STD_LOGIC := '0';
        m                       : IN STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000001";
        clkout                  : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);   
        busy                    : OUT STD_LOGIC_VECTOR(1 DOWNTO 0));   
END stratixiv_hssi_aux_clock_mult;

ARCHITECTURE clock_mult_arch OF stratixiv_hssi_aux_clock_mult IS

    SIGNAL busy_m,busy_n : STD_LOGIC_VECTOR(1 DOWNTO 0) := "01";
    SIGNAL mult_n                   :  STD_LOGIC := '0'; 
    SIGNAL m_factor : INTEGER := 1;  
    SIGNAL m_change : BOOLEAN := FALSE;
    SIGNAL sig_clk_fast_period : TIME := 0 ps;
    SIGNAL phase_adjust : TIME := 0 ps;
    SIGNAL init_ext_fb : STD_LOGIC := '0';
    SIGNAL last_fb_rising_edge  :  TIME := 0 ps;     
    SIGNAL sig_last_rising_edge  :  TIME := 0 ps;     
 
    FUNCTION to_int(arg : IN STD_LOGIC_VECTOR) RETURN INTEGER IS
    VARIABLE result : INTEGER;
    BEGIN
    result := 0;
    FOR i IN arg'RANGE LOOP
        IF arg(i) = '1' THEN
            result := result + 2**i;
        END IF;
    END LOOP;
    RETURN result;
    END to_int;
BEGIN

    m_factor <= to_int(m) WHEN (enable_m = '1') ELSE clk_multiply_by;

    PROCESS 
    BEGIN
        IF (alpha_tolower(pfd_fb_select) = ("iqtxrxclk")) THEN
            init_ext_fb <= '1';
        ELSE
            init_ext_fb <= '0';
        END IF;
        WAIT;
    END PROCESS;

    PROCESS (adjust, busy_m, m_factor)
    BEGIN
        IF (m_factor'EVENT) THEN
            busy_n <= "01";
            m_change <= TRUE, FALSE AFTER 1 ps;
        END IF;
        IF (adjust'EVENT AND adjust = '1') THEN
            busy_n <= "01";
        END IF;
        IF (busy_m'EVENT) THEN
            busy_n <= busy_m;
        END IF;
    END PROCESS;
    
    PROCESS (fbclk)
    BEGIN
       IF (fbclk'EVENT AND fbclk = '1') THEN
          last_fb_rising_edge <= NOW;
       END IF;
    END PROCESS;
    
    PROCESS
    VARIABLE clk_period :  TIME;   
    VARIABLE clk_fast_period :  TIME := 0 ps; 
    VARIABLE last_rising_edge  :  TIME := 0 ps;     
    VARIABLE n :  INTEGER := 0;
    VARIABLE clk_adjust_settled : BOOLEAN := FALSE;   
    VARIABLE clk_sync_period :  TIME; 
    VARIABLE clk_adjust : TIME := 0 ps;
    VARIABLE clk_adjust_running : TIME := 0 ps;
    VARIABLE clk_adjust_interval : INTEGER := 0;
    VARIABLE current_mult_val : STD_LOGIC;
    VARIABLE sched_time : time := 0 ps;
    BEGIN
        WAIT UNTIL (clk'EVENT OR reset'EVENT OR adjust'EVENT OR m_change'EVENT);
        IF (m_change'EVENT AND m_change = FALSE) THEN
            mult_n <= '0';
        END IF;
        IF (adjust'EVENT AND adjust = '1') THEN
            busy_m <= "01";
        END IF;
        IF (reset = '1') THEN
            mult_n <= '0';   
            busy_m <= "01"; 
        ELSIF (clk'EVENT AND clk = '1') THEN
            IF (init_ext_fb = '1') THEN
                IF (busy_n = "01" and adjust_without_lol = '0') THEN -- first rising edge            
                        mult_n <= '0';    
                        last_rising_edge := NOW;    
                        sig_last_rising_edge <= last_rising_edge;    
                        busy_m <= "11";    
                ELSE
                    last_rising_edge := NOW;    
                    sig_last_rising_edge <= last_rising_edge;    
                    IF (busy_n = "01" and adjust_without_lol = '1') THEN -- first rising edge            
                        mult_n <= '0';    
                        busy_m <= "11";
                    END IF;
                    IF (busy_n = "11") THEN -- second rising edge                
                        clk_period := NOW - sig_last_rising_edge;    

                        IF ((NOW - last_fb_rising_edge) >= clk_period) THEN
                            phase_adjust <= 0 ps;
                        ELSE
                            phase_adjust <= NOW - last_fb_rising_edge;    
                        END IF;
    
                        clk_fast_period := clk_period / m_factor;    
                        sig_clk_fast_period <= clk_fast_period;    
                        clk_adjust := clk_period - (clk_fast_period * m_factor);    
                        IF ((phase_adjust = 0 ps) AND (sig_last_rising_edge = last_fb_rising_edge)) THEN
                                busy_m <= "00";    
                        END IF;
                    END IF;
                    current_mult_val := mult_n;
                    --mult_n <= transport NOT mult_n after phase_adjust;    
                    mult_n <= NOT mult_n;    
                    IF (clk_adjust > 0 ps) THEN
                        clk_adjust_running := clk_adjust + 1 ps;    
                    END IF;
                    clk_adjust_settled := (clk_adjust = 0 ps);    --  if no adjustment necessary
                    n := m_factor;
                    sched_time := 0 ps;
                    WHILE (n >= 1) LOOP
                        IF (clk_adjust_settled = FALSE) THEN
                            clk_adjust_running := clk_adjust_running - 1 ps;    
                            clk_adjust_interval := (n * 1 ps)/ clk_adjust_running;    
                            IF ((n * 1 ps) - (clk_adjust_interval * clk_adjust_running) = 0 ps) THEN
                                clk_adjust_settled := TRUE;    
                            END IF;
                            clk_sync_period := clk_fast_period + 1 ps;    
                        ELSE
                            IF (clk_adjust = 0 ps) THEN
                                clk_sync_period := clk_fast_period;    
                            ELSE
                                IF (n mod clk_adjust_interval = 0) THEN
                                    clk_sync_period := clk_fast_period + 1 ps;    
                                ELSE
                                    clk_sync_period := clk_fast_period;    
                                END IF;
                            END IF;
                        END IF;
                        IF (reset = '1') THEN
                            mult_n <= '0';    
                        ELSE
                              -- begin new code
                              sched_time := sched_time + clk_sync_period/2;
                              mult_n <= transport current_mult_val after sched_time;
                              if (n > 1) then
                                  sched_time := sched_time + (clk_sync_period - clk_sync_period/2);
                                  mult_n <= transport NOT current_mult_val after sched_time;
                              end if;
                        END IF;
                        n := n - 1;
                    END LOOP;
                END IF;
            ELSE --end of external feedback
                IF (busy_n = "01" and adjust_without_lol = '0') THEN -- first rising edge            
                    mult_n <= '0';    
                    last_rising_edge := NOW;    
                    busy_m <= "11";    
                ELSE
                    IF (busy_n = "01" and adjust_without_lol = '1') THEN -- first rising edge            
                       mult_n <= '0';    
                       last_rising_edge := NOW;    
                       busy_m <= "11";
                    END IF;
                    IF (busy_n = "11") THEN -- second rising edge                
                        clk_period := NOW - last_rising_edge;    
                        clk_fast_period := clk_period / m_factor;    
                        sig_clk_fast_period <= clk_fast_period;    
                        clk_adjust := clk_period - (clk_fast_period * m_factor);    
                        busy_m <= "00";    
                    END IF;
                    current_mult_val := mult_n;
                    mult_n <= NOT mult_n;    
                    IF (clk_adjust > 0 ps) THEN
                        clk_adjust_running := clk_adjust + 1 ps;    
                    END IF;
                    clk_adjust_settled := (clk_adjust = 0 ps);    --  if no adjustment necessary
                    n := m_factor;
                    sched_time := 0 ps;
                    WHILE (n >= 1) LOOP
                        IF (clk_adjust_settled = FALSE) THEN
                            clk_adjust_running := clk_adjust_running - 1 ps;    
                            clk_adjust_interval := (n * 1 ps)/ clk_adjust_running;    
                            IF ((n * 1 ps) - (clk_adjust_interval * clk_adjust_running) = 0 ps) THEN
                                clk_adjust_settled := TRUE;    
                            END IF;
                            clk_sync_period := clk_fast_period + 1 ps;    
                        ELSE
                            IF (clk_adjust = 0 ps) THEN
                                clk_sync_period := clk_fast_period;    
                            ELSE
                                IF (n mod clk_adjust_interval = 0) THEN
                                    clk_sync_period := clk_fast_period + 1 ps;    
                                ELSE
                                    clk_sync_period := clk_fast_period;    
                                END IF;
                            END IF;
                        END IF;
                        IF (reset = '1') THEN
                            mult_n <= '0';    
                        ELSE
    --                        WAIT FOR (clk_sync_period/2);
    --                        mult_n <= NOT mult_n;  
    --                        IF (n > 1) THEN
    --                            WAIT FOR (clk_sync_period - clk_sync_period/2);
    --                            mult_n <= NOT mult_n;    
    --                        END IF;
                              -- begin new code
                              sched_time := sched_time + clk_sync_period/2;
                              mult_n <= transport current_mult_val after sched_time;
                              if (n > 1) then
                                  sched_time := sched_time + (clk_sync_period - clk_sync_period/2);
                                  mult_n <= transport NOT current_mult_val after sched_time;
                              end if;
                        END IF;
                        n := n - 1;
                    END LOOP;
                END IF;
            END IF; --end of internal feedback
        END IF;
    END PROCESS;
    clkout(0) <= transport mult_n after phase_adjust;
    clkout(1) <= transport mult_n after (sig_clk_fast_period/4 + phase_adjust);
    clkout(2) <= transport NOT mult_n after phase_adjust; 
    clkout(3) <= transport mult_n after ((sig_clk_fast_period * 3)/4 + phase_adjust);
    busy <= busy_n;

END clock_mult_arch;
Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_divby2q IS
   PORT (
      
      clk       : IN STD_LOGIC;
      
      clk0      : OUT STD_LOGIC;
      clk90     : OUT STD_LOGIC;
      clk180    : OUT STD_LOGIC;
      clk270    : OUT STD_LOGIC;
      clkb      : IN STD_LOGIC;
      rst_n     : IN STD_LOGIC;
      vcce_la   : IN STD_LOGIC;
      vssexqyx  : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_divby2q;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_divby2q IS
   
   SIGNAL clk0_init   : STD_LOGIC := '0' ;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL clk0_xhdl0  : STD_LOGIC := '1' ;
   SIGNAL clk90_xhdl1 : STD_LOGIC := '1' ;
   SIGNAL clk180_xhdl0 : STD_LOGIC := '0' ;
BEGIN
   -- Drive referenced outputs
   clk0 <= clk0_xhdl0;
   clk90 <= clk90_xhdl1;
   clk180 <= clk180_xhdl0;
   
   PROCESS (clk, rst_n)
   BEGIN
      IF (rst_n = '0') THEN
         clk0_init <= '0';
         clk0_xhdl0 <= '1';
         clk180_xhdl0 <= '1';
      ELSIF (clk'EVENT AND clk = '1') THEN
         clk0_init <= '1';
         clk0_xhdl0 <= NOT(clk0_xhdl0);
         clk180_xhdl0 <= clk0_xhdl0;
      END IF;
   END PROCESS;
   
   PROCESS (clkb, rst_n)
   BEGIN
      IF (rst_n = '0') THEN
         clk90_xhdl1 <= '1';
         clk270 <= '1';
      ELSIF (clkb'EVENT AND clkb = '1') THEN
         IF (clk0_init = '1') THEN
            clk90_xhdl1 <= NOT(clk90_xhdl1);
            clk270 <= clk90_xhdl1;
         END IF;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_pcie_sw IS
   GENERIC (
      
      PARAM_DELAY  : INTEGER := 0
   );
   PORT (
      cpulse       : IN STD_LOGIC;
      
      cpulse_out   : OUT STD_LOGIC;
      cpulseb      : IN STD_LOGIC;
      cpulsei      : IN STD_LOGIC;
      dynamic_sw   : IN STD_LOGIC;
      gen2ngen1    : OUT STD_LOGIC;
      hclk         : OUT STD_LOGIC;
      hfclkn       : IN STD_LOGIC;
      hfclkn_out   : OUT STD_LOGIC;
      hfclkp       : IN STD_LOGIC;
      hfclkp_out   : OUT STD_LOGIC;
      lfclkn       : IN STD_LOGIC;
      lfclkn_out   : OUT STD_LOGIC;
      lfclkp       : IN STD_LOGIC;
      lfclkp_out   : OUT STD_LOGIC;
      pcie_sw      : IN STD_LOGIC;
      pcie_sw_cdr  : OUT STD_LOGIC;
      pclk         : OUT STD_LOGIC;
      pdb          : IN STD_LOGIC;
      rst_n        : IN STD_LOGIC;
      vccelxqyx    : IN STD_LOGIC;
      vssexqyx     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_pcie_sw;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_pcie_sw IS
   COMPONENT stratixiv_hssi_pma_c_divby2q
      PORT (
         clk          : IN STD_LOGIC;
         clk0         : OUT STD_LOGIC;
         clk90        : OUT STD_LOGIC;
         clk180       : OUT STD_LOGIC;
         clk270       : OUT STD_LOGIC;
         clkb         : IN STD_LOGIC;
         rst_n        : IN STD_LOGIC;
         vcce_la      : IN STD_LOGIC;
         vssexqyx     : IN STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL nclri             : STD_LOGIC;
   SIGNAL clk_selectb       : STD_LOGIC;
   SIGNAL div2_enlf         : STD_LOGIC;
   SIGNAL lfclk0_div2       : STD_LOGIC;
   SIGNAL lfclk90_div2      : STD_LOGIC;
   SIGNAL lfclk180_div2     : STD_LOGIC;
   SIGNAL lfclk270_div2     : STD_LOGIC;
   SIGNAL lfclk0_div2_int   : STD_LOGIC;
   SIGNAL lfclk90_div2_int  : STD_LOGIC;
   SIGNAL lfclk180_div2_int : STD_LOGIC;
   SIGNAL lfclk270_div2_int : STD_LOGIC;
   SIGNAL hfclk0_div2       : STD_LOGIC;
   SIGNAL hfclk90_div2      : STD_LOGIC;
   SIGNAL hfclk180_div2     : STD_LOGIC;
   SIGNAL hfclk270_div2     : STD_LOGIC;
   SIGNAL cpulse_div2       : STD_LOGIC;
   SIGNAL div2_enhf         : STD_LOGIC;
   SIGNAL div2_enhf_reg     : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL lfclkp_out_xhdl0  : STD_LOGIC;
   SIGNAL pcie_sw_cdr_xhdl1 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   lfclkp_out <= lfclkp_out_xhdl0;
   pcie_sw_cdr <= pcie_sw_cdr_xhdl1;
   
   PROCESS (hfclkp)
   BEGIN
      IF (hfclkp'EVENT AND hfclkp = '0') THEN
         div2_enhf_reg <= div2_enhf;
      END IF;
   END PROCESS;
   
   xhf : stratixiv_hssi_pma_c_divby2q
      PORT MAP (
         clk       => hfclkp,
         clk0      => hfclk0_div2,
         clk90     => hfclk90_div2,
         clk180    => hfclk180_div2,
         vcce_la   => '1',
         vssexqyx  => '0',
         clk270    => hfclk270_div2,
         clkb      => hfclkn,
         rst_n     => div2_enhf_reg
      );
   
   xlf : stratixiv_hssi_pma_c_divby2q
      PORT MAP (
         clk       => lfclkp,
         clk0      => lfclk0_div2_int,
         clk90     => lfclk90_div2_int,
         clk180    => lfclk180_div2_int,
         vcce_la   => '1',
         vssexqyx  => '0',
         clk270    => lfclk270_div2_int,
         clkb      => lfclkn,
         rst_n     => '1'
      );
   
--   hclk <= NOT((NOT(lfclkp) AND nclri));
   hclk <= NOT((NOT(lfclkp) AND rst_n));
   pclk <= lfclkp_out_xhdl0;
   
   clk_selectb <= div2_enhf_reg;
   div2_enlf <= div2_enhf_reg;
   gen2ngen1 <= NOT((div2_enhf_reg AND nclri));
   nclri <= dynamic_sw AND rst_n;
   pcie_sw_cdr_xhdl1 <= NOT(pcie_sw) AND dynamic_sw AND rst_n;
--   (lfclk0_div2, lfclk90_div2, lfclk180_div2, lfclk270_div2) <= (lfclk0_div2_int & lfclk90_div2_int & lfclk180_div2_int & lfclk270_div2_int) WHEN (div2_enhf_reg = '1') ELSE
--                                                                "0000";
   lfclk0_div2 <= lfclk0_div2_int WHEN (div2_enhf_reg = '1') ELSE '0';
   lfclk90_div2 <= lfclk90_div2_int WHEN (div2_enhf_reg = '1') ELSE '0';
   lfclk180_div2 <= lfclk180_div2_int WHEN (div2_enhf_reg = '1') ELSE '0';
   lfclk270_div2 <= lfclk270_div2_int WHEN (div2_enhf_reg = '1') ELSE '0';

   hfclkp_out <= hfclkp WHEN ((NOT(clk_selectb)) = '1') ELSE
                 hfclk0_div2;
   hfclkn_out <= hfclkn WHEN ((NOT(clk_selectb)) = '1') ELSE
                 hfclk180_div2;
   cpulse_out <= cpulse WHEN ((NOT(clk_selectb)) = '1') ELSE
                 cpulse_div2 AND lfclk0_div2;
   lfclkp_out_xhdl0 <= lfclkp WHEN ((NOT(clk_selectb)) = '1') ELSE
                       lfclk0_div2;
   lfclkn_out <= lfclkn WHEN ((NOT(clk_selectb)) = '1') ELSE
                 lfclk180_div2;
   
   -- cpulse div by 2
   PROCESS (hfclk0_div2, div2_enhf_reg)
   BEGIN
      IF (div2_enhf_reg = '0') THEN
         cpulse_div2 <= '0';
      ELSIF (hfclk0_div2'EVENT AND hfclk0_div2 = '1') THEN
         -- - stratixiv_hssi_pma_c_deglitch -
         -- Synchronization with lclk270 _div2
         cpulse_div2 <= cpulse;
      END IF;
   END PROCESS;
   
   PROCESS (lfclk270_div2_int, rst_n)
   BEGIN
      IF (rst_n = '0') THEN
         div2_enhf <= '0';
      ELSIF (lfclk270_div2_int'EVENT AND lfclk270_div2_int = '1') THEN
         div2_enhf <= pcie_sw_cdr_xhdl1;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;

   
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_controller_4t16 IS
   PORT (
      
      atben    : OUT STD_LOGIC;
      ct0      : IN STD_LOGIC;
      ct1      : IN STD_LOGIC;
      ct2      : IN STD_LOGIC;
      ct3      : IN STD_LOGIC;
      tmsb1    : OUT STD_LOGIC;
      tmsb2    : OUT STD_LOGIC;
      tmsb3    : OUT STD_LOGIC;
      tmsb4    : OUT STD_LOGIC;
      tmsb5    : OUT STD_LOGIC;
      tmsb6    : OUT STD_LOGIC;
      tmsb7    : OUT STD_LOGIC;
      tmsb8    : OUT STD_LOGIC;
      tmsb9    : OUT STD_LOGIC;
      tmsb10   : OUT STD_LOGIC;
      tmsb11   : OUT STD_LOGIC;
      tmsb12   : OUT STD_LOGIC;
      tmsb13   : OUT STD_LOGIC;
      tmsb14   : OUT STD_LOGIC;
      tmsb15   : OUT STD_LOGIC;
      vcce_la  : IN STD_LOGIC;
      vssex    : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_controller_4t16;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_controller_4t16 IS
   
   SIGNAL tmsb0    : STD_LOGIC;
   SIGNAL tmsb_bus : STD_LOGIC_VECTOR(15 DOWNTO 0);
   -- X-HDL generated signals

   SIGNAL xhdl0 : STD_LOGIC_VECTOR(3 DOWNTO 0);
BEGIN
   
   tmsb0 <= tmsb_bus(0);
   tmsb1 <= tmsb_bus(1);
   tmsb2 <= tmsb_bus(2);
   tmsb3 <= tmsb_bus(3);
   tmsb4 <= tmsb_bus(4);
   tmsb5 <= tmsb_bus(5);
   tmsb6 <= tmsb_bus(6);
   tmsb7 <= tmsb_bus(7);
   tmsb8 <= tmsb_bus(8);
   tmsb9 <= tmsb_bus(9);
   tmsb10 <= tmsb_bus(10);
   tmsb11 <= tmsb_bus(11);
   tmsb12 <= tmsb_bus(12);
   tmsb13 <= tmsb_bus(13);
   tmsb14 <= tmsb_bus(14);
   tmsb15 <= tmsb_bus(15);
   
   atben <= reduction_or((ct3 & ct2 & ct1 & ct0));
   xhdl0 <= ct3 & ct2 & ct1 & ct0;
   PROCESS (ct3, ct2, ct1, ct0)
   BEGIN
      CASE xhdl0 IS
         WHEN "0000" =>
            tmsb_bus <= "0000000000000001";
         WHEN "0001" =>
            tmsb_bus <= "0000000000000010";
         WHEN "0010" =>
            tmsb_bus <= "0000000000000100";
         WHEN "0011" =>
            tmsb_bus <= "0000000000001000";
         WHEN "0100" =>
            tmsb_bus <= "0000000000010000";
         WHEN "0101" =>
            tmsb_bus <= "0000000000100000";
         WHEN "0110" =>
            tmsb_bus <= "0000000001000000";
         WHEN "0111" =>
            tmsb_bus <= "0000000010000000";
         WHEN "1000" =>
            tmsb_bus <= "0000000100000000";
         WHEN "1001" =>
            tmsb_bus <= "0000001000000000";
         WHEN "1010" =>
            tmsb_bus <= "0000010000000000";
         WHEN "1011" =>
            tmsb_bus <= "0000100000000000";
         WHEN "1100" =>
            tmsb_bus <= "0001000000000000";
         WHEN "1101" =>
            tmsb_bus <= "0010000000000000";
         WHEN "1110" =>
            tmsb_bus <= "0100000000000000";
         WHEN "1111" =>
            tmsb_bus <= "1000000000000000";
         WHEN OTHERS =>
            tmsb_bus <= "0000000000000000";
      END CASE;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_c_clkgendrv IS
   PORT (
      
      clk0       : IN STD_LOGIC;
      clk90      : IN STD_LOGIC;
      clk180     : IN STD_LOGIC;
      clk270     : IN STD_LOGIC;
      
      cpulse     : OUT STD_LOGIC;
      cpulseb    : OUT STD_LOGIC;
      cpulseo    : OUT STD_LOGIC;
      div5       : IN STD_LOGIC;
      hfclk_n    : OUT STD_LOGIC;
      hfclk_p    : OUT STD_LOGIC;
      lfclk_n    : OUT STD_LOGIC;
      lfclk_p    : OUT STD_LOGIC;
      rst_n      : IN STD_LOGIC;
      vccelxqyx  : IN STD_LOGIC;
      vssexqyx   : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_clkgendrv;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_clkgendrv IS
   
   SIGNAL lfclkp_counter : INTEGER := 0 ;
   SIGNAL lfclkp_div5    : STD_LOGIC := '0' ;
   SIGNAL lfclkp_div4    : STD_LOGIC := '0' ;
   SIGNAL lfclkn_div5    : STD_LOGIC := '1' ;
   SIGNAL lfclkn_div4    : STD_LOGIC := '1' ;
   SIGNAL cpulse_div4    : STD_LOGIC := '0' ;
   SIGNAL cpulse_div5    : STD_LOGIC := '0' ;
   SIGNAL init_done      : STD_LOGIC := '0' ;
--   SIGNAL hfclk_p_prev   : STD_LOGIC := '0' ;
   SIGNAL hfclk_p_prev   : STD_LOGIC;
   SIGNAL hfclk_p_wire   : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL cpulse_xhdl0   : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   cpulse <= cpulse_xhdl0;
   
   hfclk_p <= hfclk_p_wire;
   hfclk_p_wire <= '0' WHEN (rst_n = '0') ELSE
                   NOT(clk180);
   hfclk_n <= '1' WHEN (rst_n = '0') ELSE
                   NOT(clk0);
   lfclk_p <= lfclkp_div5 WHEN (div5 = '1') ELSE
              lfclkp_div4;
   lfclk_n <= lfclkn_div5 WHEN (div5 = '1') ELSE
              lfclkn_div4;
   cpulse_xhdl0 <= cpulse_div5 WHEN (div5 = '1') ELSE
                   cpulse_div4;
   cpulseo <= cpulse_xhdl0;
   cpulseb <= NOT(cpulse_xhdl0);
   
   
   -- Edge counter used for lfclkp/n_div4/div5 and cpulse_div4/5 generation
   PROCESS (hfclk_p_wire, rst_n)
   BEGIN
      IF (rst_n = '0') THEN
         lfclkp_counter <= 0;
         init_done <= '0';
      ELSIF (hfclk_p_wire'event) THEN
         IF (hfclk_p_wire /= hfclk_p_prev) THEN
            -- after one cycle of hfclkp, if set, reset cpulse_div4/5
            IF (hfclk_p_wire = '1' AND cpulse_div5 = '1') THEN
               cpulse_div5 <= '0';
            END IF;
            IF (hfclk_p_wire = '1' AND cpulse_div4 = '1') THEN
               -- generation of lfclkp/n_div5 & pulse_div5 ** posedge of lfclkp_div5 occurs at posedge of hfclkp **
               cpulse_div4 <= '0';
            END IF;
            IF ((lfclkp_counter MOD 5 = 1) AND (hfclk_p_wire = '1')) THEN
               lfclkp_div5 <= '1';
               lfclkn_div5 <= '0';
               IF (lfclkp_div5 = '0') THEN
                  cpulse_div5 <= '1';
               END IF;
            ELSIF ((lfclkp_counter MOD 5 = 1) AND (hfclk_p_wire = '0')) THEN
               lfclkp_div5 <= '0';
               lfclkn_div5 <= '1';
            END IF;
            -- generation of lfclkp/n_div4 & pulse_div4 ** posedge of lfclkp_div5 occurs at posedge of hfclkp **
            IF ((hfclk_p_wire = '1') AND ((lfclkp_counter MOD 4 = 0) OR (lfclkp_counter MOD 4 = 1))) THEN
               IF (init_done = '0') THEN
                  lfclkp_div4 <= '1';
                  lfclkn_div4 <= '0';
                  init_done <= '1';
               ELSE
                  lfclkp_div4 <= NOT(lfclkp_div4);
                  lfclkn_div4 <= NOT(lfclkn_div4);
               END IF;
               IF (lfclkp_div4 = '0') THEN
                  cpulse_div4 <= '1';
               END IF;
            END IF;
            lfclkp_counter <= lfclkp_counter + 1;
         END IF;
      END IF;
      hfclk_p_prev <= hfclk_p_wire;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_clkgenbuf IS
   GENERIC (
      
      PARAM_DELAY  : INTEGER := 0
   );
   PORT (
      cgb_x_en     : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      clk0_0       : IN STD_LOGIC;
      clk0_1       : IN STD_LOGIC;
      
      clk0_out     : OUT STD_LOGIC;
      clk90_0      : IN STD_LOGIC;
      clk90_1      : IN STD_LOGIC;
      clk90_out    : OUT STD_LOGIC;
      clk180_0     : IN STD_LOGIC;
      clk180_1     : IN STD_LOGIC;
      clk180_out   : OUT STD_LOGIC;
      clk270_0     : IN STD_LOGIC;
      clk270_1     : IN STD_LOGIC;
      clk270_out   : OUT STD_LOGIC;
      cmu_sel      : IN STD_LOGIC;
      cpulse       : OUT STD_LOGIC;
      div5         : IN STD_LOGIC;
      dynamic_sw   : IN STD_LOGIC;
      gen2ngen1    : OUT STD_LOGIC;
      hclk         : OUT STD_LOGIC;
      hfclk_n      : OUT STD_LOGIC;
      hfclk_p      : OUT STD_LOGIC;
      lfclk_n      : OUT STD_LOGIC;
      lfclk_p      : OUT STD_LOGIC;
      m_sel        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      pcie_sw      : IN STD_LOGIC;
      pcie_sw_cdr  : OUT STD_LOGIC;
      pclk         : OUT STD_LOGIC;
      pdb          : IN STD_LOGIC;
      rst_n        : IN STD_LOGIC;
      rst_n1       : OUT STD_LOGIC;
      vccelxqyx    : IN STD_LOGIC;
      vssexqyx     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_clkgenbuf;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_clkgenbuf IS
   COMPONENT stratixiv_hssi_pma_c_divby2q
      PORT (
         clk          : IN STD_LOGIC;
         clk0         : OUT STD_LOGIC;
         clk90        : OUT STD_LOGIC;
         clk180       : OUT STD_LOGIC;
         clk270       : OUT STD_LOGIC;
         clkb         : IN STD_LOGIC;
         rst_n        : IN STD_LOGIC;
         vcce_la      : IN STD_LOGIC;
         vssexqyx     : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_clkgendrv
      PORT (
         clk0         : IN STD_LOGIC;
         clk90        : IN STD_LOGIC;
         clk180       : IN STD_LOGIC;
         clk270       : IN STD_LOGIC;
         cpulse       : OUT STD_LOGIC;
         cpulseb      : OUT STD_LOGIC;
         cpulseo      : OUT STD_LOGIC;
         div5         : IN STD_LOGIC;
         hfclk_n      : OUT STD_LOGIC;
         hfclk_p      : OUT STD_LOGIC;
         lfclk_n      : OUT STD_LOGIC;
         lfclk_p      : OUT STD_LOGIC;
         rst_n        : IN STD_LOGIC;
         vccelxqyx    : IN STD_LOGIC;
         vssexqyx     : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_pcie_sw
   GENERIC (
      
      PARAM_DELAY  : INTEGER := 0
   );
    PORT (
      cpulse       : IN STD_LOGIC;
      cpulse_out   : OUT STD_LOGIC;
      cpulseb      : IN STD_LOGIC;
      cpulsei      : IN STD_LOGIC;
      dynamic_sw   : IN STD_LOGIC;
      gen2ngen1    : OUT STD_LOGIC;
      hclk         : OUT STD_LOGIC;
      hfclkn       : IN STD_LOGIC;
      hfclkn_out   : OUT STD_LOGIC;
      hfclkp       : IN STD_LOGIC;
      hfclkp_out   : OUT STD_LOGIC;
      lfclkn       : IN STD_LOGIC;
      lfclkn_out   : OUT STD_LOGIC;
      lfclkp       : IN STD_LOGIC;
      lfclkp_out   : OUT STD_LOGIC;
      pcie_sw      : IN STD_LOGIC;
      pcie_sw_cdr  : OUT STD_LOGIC;
      pclk         : OUT STD_LOGIC;
      pdb          : IN STD_LOGIC;
      rst_n        : IN STD_LOGIC;
      vccelxqyx    : IN STD_LOGIC;
      vssexqyx     : IN STD_LOGIC
   );
END COMPONENT;

   SIGNAL pdb_buf              : STD_LOGIC;
   SIGNAL clk_in               : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL clk_div2             : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL clk_div4             : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL clk_out              : STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   SIGNAL rst_n1_clkgenbuf_div : STD_LOGIC;
   SIGNAL rst_n2_clkgenbuf_div : STD_LOGIC;
   SIGNAL cpulse_i             : STD_LOGIC;
   SIGNAL cpulseb_i            : STD_LOGIC;
   SIGNAL cpulseo              : STD_LOGIC;
   SIGNAL hfclkn_i             : STD_LOGIC;
   SIGNAL hfclkp_i             : STD_LOGIC;
   SIGNAL lfclkn_i             : STD_LOGIC;
   SIGNAL lfclkp_i             : STD_LOGIC;
   -- X-HDL generated signals

   SIGNAL xhdl14 : STD_LOGIC;
   SIGNAL xhdl15 : STD_LOGIC;
   SIGNAL xhdl16 : STD_LOGIC;
   SIGNAL xhdl17 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL clk0_out_xhdl0       : STD_LOGIC;
   SIGNAL clk90_out_xhdl3      : STD_LOGIC;
   SIGNAL clk180_out_xhdl1     : STD_LOGIC;
   SIGNAL clk270_out_xhdl2     : STD_LOGIC;
   SIGNAL cpulse_xhdl4         : STD_LOGIC;
   SIGNAL gen2ngen1_xhdl5      : STD_LOGIC;
   SIGNAL hclk_xhdl6           : STD_LOGIC;
   SIGNAL hfclk_n_xhdl7        : STD_LOGIC;
   SIGNAL hfclk_p_xhdl8        : STD_LOGIC;
   SIGNAL lfclk_n_xhdl9        : STD_LOGIC;
   SIGNAL lfclk_p_xhdl10       : STD_LOGIC;
   SIGNAL pcie_sw_cdr_xhdl11   : STD_LOGIC;
   SIGNAL pclk_xhdl12          : STD_LOGIC;
   SIGNAL rst_n1_xhdl13        : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   clk0_out <= clk0_out_xhdl0;
   clk90_out <= clk90_out_xhdl3;
   clk180_out <= clk180_out_xhdl1;
   clk270_out <= clk270_out_xhdl2;
   cpulse <= cpulse_xhdl4;
   gen2ngen1 <= gen2ngen1_xhdl5;
   hclk <= hclk_xhdl6;
   hfclk_n <= hfclk_n_xhdl7;
   hfclk_p <= hfclk_p_xhdl8;
   lfclk_n <= lfclk_n_xhdl9;
   lfclk_p <= lfclk_p_xhdl10;
   pcie_sw_cdr <= pcie_sw_cdr_xhdl11;
   pclk <= pclk_xhdl12;
   rst_n1 <= rst_n1_xhdl13;
   
   pdb_buf <= pdb AND NOT((reduction_or(cgb_x_en)));
   rst_n1_xhdl13 <= rst_n AND pdb_buf;
   
   -- * * b_mux4_2t1 - xcmux instance * *
   clk_in <= "0000" WHEN ((NOT(pdb)) = '1') ELSE
             (clk270_1 & clk180_1 & clk90_1 & clk0_1) WHEN (cmu_sel = '1') ELSE
             (clk270_0 & clk180_0 & clk90_0 & clk0_0);
   
   -- * * stratixiv_hssi_pma_c_clkgenbuf_div - xdiv instance * *
   rst_n1_clkgenbuf_div <= rst_n1_xhdl13 AND (m_sel(1) OR m_sel(0));
   rst_n2_clkgenbuf_div <= rst_n1_xhdl13 AND m_sel(1);
   --   assign {clk270_out,clk180_out,clk90_out,clk0_out} = clk_out;
   clk270_out_xhdl2 <= clk_out(3);
   clk180_out_xhdl1 <= clk_out(2);
   clk90_out_xhdl3 <= clk_out(1);
   clk0_out_xhdl0 <= clk_out(0);
   
   
   xhdl14 <= NOT(clk_in(2));
   xhdl15 <= NOT(clk_in(0));
   xdiv2_2 : stratixiv_hssi_pma_c_divby2q
      PORT MAP (
         clk       => xhdl14,
         clk0      => clk_div2(0),
         clk90     => clk_div2(1),
         clk180    => clk_div2(2),
         clk270    => clk_div2(3),
         vcce_la   => '1',
         vssexqyx  => '0',
         clkb      => xhdl15,
         rst_n     => rst_n1_clkgenbuf_div
      );
   
   xhdl16 <= NOT(clk_div2(2));
   xhdl17 <= NOT(clk_div2(0));
   xdiv2_4 : stratixiv_hssi_pma_c_divby2q
      PORT MAP (
         clk       => xhdl16,
         clk0      => clk_div4(0),
         clk90     => clk_div4(1),
         clk180    => clk_div4(2),
         clk270    => clk_div4(3),
         vcce_la   => '1',
         vssexqyx  => '0',
         clkb      => xhdl17,
         rst_n     => rst_n2_clkgenbuf_div
      );
   
   PROCESS (m_sel, clk_in, clk_div2, clk_div4)
   BEGIN
      CASE m_sel IS
         WHEN "00" =>
            clk_out <= clk_in;
         WHEN "01" =>
            clk_out <= clk_div2;
         --       2'b11   : clk_out = 4'b0000;
         WHEN "10" =>
            clk_out <= clk_div4;
         WHEN "11" =>
            clk_out <= "0000";
         WHEN OTHERS =>
            clk_out <= "XXXX";
      END CASE;
   END PROCESS;
   
   -- * * stratixiv_hssi_pma_c_clkgendrv - xdrv instance - div by 4 or 5 * *
   xdrv : stratixiv_hssi_pma_c_clkgendrv
      PORT MAP (
         clk0       => clk0_out_xhdl0,
         clk90      => clk90_out_xhdl3,
         clk180     => clk180_out_xhdl1,
         clk270     => clk270_out_xhdl2,
         cpulse     => cpulse_i,
         cpulseb    => cpulseb_i,
         cpulseo    => cpulseo,
         div5       => div5,
         hfclk_n    => hfclkn_i,
         hfclk_p    => hfclkp_i,
         lfclk_n    => lfclkn_i,
         lfclk_p    => lfclkp_i,
         rst_n      => rst_n1_xhdl13,
         vccelxqyx  => vccelxqyx,
         vssexqyx   => vssexqyx
      );
   
   -- * * c_pcie_sw - xpcie_sw instance * *
   xpcie_sw : stratixiv_hssi_pma_c_pcie_sw
      GENERIC MAP (
         param_delay  => PARAM_DELAY
      )
      PORT MAP (
         cpulse       => cpulse_i,
         cpulse_out   => cpulse_xhdl4,
         cpulseb      => cpulseb_i,
         cpulsei      => cpulse_i,
         dynamic_sw   => dynamic_sw,
         gen2ngen1    => gen2ngen1_xhdl5,
         hclk         => hclk_xhdl6,
         hfclkn       => hfclkn_i,
         hfclkn_out   => hfclk_n_xhdl7,
         hfclkp       => hfclkp_i,
         hfclkp_out   => hfclk_p_xhdl8,
         lfclkn       => lfclkn_i,
         lfclkn_out   => lfclk_n_xhdl9,
         lfclkp       => lfclkp_i,
         lfclkp_out   => lfclk_p_xhdl10,
         pcie_sw      => pcie_sw,
         pcie_sw_cdr  => pcie_sw_cdr_xhdl11,
         pclk         => pclk_xhdl12,
         pdb          => pdb_buf,
         rst_n        => rst_n1_xhdl13,
         vccelxqyx    => vccelxqyx,
         vssexqyx     => vssexqyx
      );
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_clkgenbuf_cmu IS
   PORT (
      cgb_vccelxqyx  : OUT STD_LOGIC;
      cgb_vssexqyx   : OUT STD_LOGIC;
      cgb_x_en       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      clk0_0         : IN STD_LOGIC;
      clk0_1         : IN STD_LOGIC;
      clk90_0        : IN STD_LOGIC;
      clk90_1        : IN STD_LOGIC;
      clk180_0       : IN STD_LOGIC;
      clk180_1       : IN STD_LOGIC;
      clk270_0       : IN STD_LOGIC;
      clk270_1       : IN STD_LOGIC;
      pdb            : IN STD_LOGIC;
      cmu_sel        : IN STD_LOGIC;
      cpulse_ht      : OUT STD_LOGIC;
      cpulse_x1      : OUT STD_LOGIC;
      div5           : IN STD_LOGIC;
      dynamic_sw     : IN STD_LOGIC;
      hfclkn_ht      : OUT STD_LOGIC;
      hfclkn_x1      : OUT STD_LOGIC;
      hfclkp_ht      : OUT STD_LOGIC;
      hfclkp_x1      : OUT STD_LOGIC;
      hclk           : OUT STD_LOGIC;
      ht_sel         : IN STD_LOGIC;
      lfclkn_ht      : OUT STD_LOGIC;
      lfclkn_x1      : OUT STD_LOGIC;
      lfclkp_ht      : OUT STD_LOGIC;
      lfclkp_x1      : OUT STD_LOGIC;
      m_sel          : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      pcie_sw        : IN STD_LOGIC;
      pcie_sw_cdr    : OUT STD_LOGIC;
      pclk           : OUT STD_LOGIC;
      gen2ngen1      : OUT STD_LOGIC;
      rst_n          : IN STD_LOGIC;
      vccelxqyx      : IN STD_LOGIC;
      vssexqyx       : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_clkgenbuf_cmu;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_clkgenbuf_cmu IS
   COMPONENT stratixiv_hssi_pma_c_divby2q
      PORT (
         clk            : IN STD_LOGIC;
         clk0           : OUT STD_LOGIC;
         clk90          : OUT STD_LOGIC;
         clk180         : OUT STD_LOGIC;
         clk270         : OUT STD_LOGIC;
         clkb           : IN STD_LOGIC;
         rst_n          : IN STD_LOGIC;
         vcce_la        : IN STD_LOGIC;
         vssexqyx       : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_clkgenbuf
      GENERIC (
         PARAM_DELAY    : INTEGER := 0
      );
      PORT (
         cgb_x_en       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         clk0_0         : IN STD_LOGIC;
         clk0_1         : IN STD_LOGIC;
         clk0_out       : OUT STD_LOGIC;
         clk90_0        : IN STD_LOGIC;
         clk90_1        : IN STD_LOGIC;
         clk90_out      : OUT STD_LOGIC;
         clk180_0       : IN STD_LOGIC;
         clk180_1       : IN STD_LOGIC;
         clk180_out     : OUT STD_LOGIC;
         clk270_0       : IN STD_LOGIC;
         clk270_1       : IN STD_LOGIC;
         clk270_out     : OUT STD_LOGIC;
         cmu_sel        : IN STD_LOGIC;
         cpulse         : OUT STD_LOGIC;
         div5           : IN STD_LOGIC;
         dynamic_sw     : IN STD_LOGIC;
         gen2ngen1      : OUT STD_LOGIC;
         hclk           : OUT STD_LOGIC;
         hfclk_n        : OUT STD_LOGIC;
         hfclk_p        : OUT STD_LOGIC;
         lfclk_n        : OUT STD_LOGIC;
         lfclk_p        : OUT STD_LOGIC;
         m_sel          : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         pcie_sw        : IN STD_LOGIC;
         pcie_sw_cdr    : OUT STD_LOGIC;
         pclk           : OUT STD_LOGIC;
         pdb            : IN STD_LOGIC;
         rst_n          : IN STD_LOGIC;
         rst_n1         : OUT STD_LOGIC;
         vccelxqyx      : IN STD_LOGIC;
         vssexqyx       : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_clkgendrv
      PORT (
         clk0           : IN STD_LOGIC;
         clk90          : IN STD_LOGIC;
         clk180         : IN STD_LOGIC;
         clk270         : IN STD_LOGIC;
         cpulse         : OUT STD_LOGIC;
         cpulseb        : OUT STD_LOGIC;
         cpulseo        : OUT STD_LOGIC;
         div5           : IN STD_LOGIC;
         hfclk_n        : OUT STD_LOGIC;
         hfclk_p        : OUT STD_LOGIC;
         lfclk_n        : OUT STD_LOGIC;
         lfclk_p        : OUT STD_LOGIC;
         rst_n          : IN STD_LOGIC;
         vccelxqyx      : IN STD_LOGIC;
         vssexqyx       : IN STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL rst_n1             : STD_LOGIC;
   SIGNAL rst_n1b            : STD_LOGIC;
   SIGNAL ht_en              : STD_LOGIC;
   SIGNAL clk0_out           : STD_LOGIC;
   SIGNAL clk90_out          : STD_LOGIC;
   SIGNAL clk180_out         : STD_LOGIC;
   SIGNAL clk270_out         : STD_LOGIC;
   SIGNAL cpulseo            : STD_LOGIC;
   SIGNAL cpulseb_ht         : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL cpulse_ht_xhdl0    : STD_LOGIC;
   SIGNAL cpulse_x1_xhdl1    : STD_LOGIC;
   SIGNAL hfclkn_ht_xhdl4    : STD_LOGIC;
   SIGNAL hfclkn_x1_xhdl5    : STD_LOGIC;
   SIGNAL hfclkp_ht_xhdl6    : STD_LOGIC;
   SIGNAL hfclkp_x1_xhdl7    : STD_LOGIC;
   SIGNAL hclk_xhdl3         : STD_LOGIC;
   SIGNAL lfclkn_ht_xhdl8    : STD_LOGIC;
   SIGNAL lfclkn_x1_xhdl9    : STD_LOGIC;
   SIGNAL lfclkp_ht_xhdl10   : STD_LOGIC;
   SIGNAL lfclkp_x1_xhdl11   : STD_LOGIC;
   SIGNAL pcie_sw_cdr_xhdl12 : STD_LOGIC;
   SIGNAL gen2ngen1_xhdl2    : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   cpulse_ht <= cpulse_ht_xhdl0;
   cpulse_x1 <= cpulse_x1_xhdl1;
   hfclkn_ht <= hfclkn_ht_xhdl4;
   hfclkn_x1 <= hfclkn_x1_xhdl5;
   hfclkp_ht <= hfclkp_ht_xhdl6;
   hfclkp_x1 <= hfclkp_x1_xhdl7;
   hclk <= hclk_xhdl3;
   lfclkn_ht <= lfclkn_ht_xhdl8;
   lfclkn_x1 <= lfclkn_x1_xhdl9;
   lfclkp_ht <= lfclkp_ht_xhdl10;
   lfclkp_x1 <= lfclkp_x1_xhdl11;
   pcie_sw_cdr <= pcie_sw_cdr_xhdl12;
   gen2ngen1 <= gen2ngen1_xhdl2;
   
   rst_n1b <= NOT((rst_n1 AND ht_sel));
   ht_en <= NOT(rst_n1b);
   
   xclkgen : stratixiv_hssi_pma_c_clkgenbuf
      PORT MAP (
         cgb_x_en     => cgb_x_en,
         clk0_0       => clk0_0,
         clk0_1       => clk0_1,
         clk0_out     => clk0_out,
         clk90_0      => clk90_0,
         clk90_1      => clk90_1,
         clk90_out    => clk90_out,
         clk180_0     => clk180_0,
         clk180_1     => clk180_1,
         clk180_out   => clk180_out,
         clk270_0     => clk270_0,
         clk270_1     => clk270_1,
         clk270_out   => clk270_out,
         cmu_sel      => cmu_sel,
         cpulse       => cpulse_x1_xhdl1,
         div5         => div5,
         dynamic_sw   => dynamic_sw,
         gen2ngen1    => gen2ngen1_xhdl2,
         hclk         => hclk_xhdl3,
         hfclk_n      => hfclkn_x1_xhdl5,
         hfclk_p      => hfclkp_x1_xhdl7,
         lfclk_n      => lfclkn_x1_xhdl9,
         lfclk_p      => lfclkp_x1_xhdl11,
         m_sel        => m_sel,
         pcie_sw      => pcie_sw,
         pcie_sw_cdr  => pcie_sw_cdr_xhdl12,
         pclk         => pclk,
         pdb          => pdb,
         rst_n        => rst_n,
         rst_n1       => rst_n1,
         vccelxqyx    => vccelxqyx,
         vssexqyx     => vssexqyx
      );
   
   xdrv : stratixiv_hssi_pma_c_clkgendrv
      PORT MAP (
         clk0       => clk270_out,
         clk90      => clk0_out,
         clk180     => clk90_out,
         clk270     => clk180_out,
         cpulse     => cpulse_ht_xhdl0,
         cpulseb    => cpulseb_ht,
         cpulseo    => cpulseo,
         div5       => div5,
         hfclk_n    => hfclkn_ht_xhdl4,
         hfclk_p    => hfclkp_ht_xhdl6,
         lfclk_n    => lfclkn_ht_xhdl8,
         lfclk_p    => lfclkp_ht_xhdl10,
         rst_n      => ht_en,
         vccelxqyx  => vccelxqyx,
         vssexqyx   => vssexqyx
      );
   
   cgb_vccelxqyx <= vccelxqyx WHEN (vssexqyx = '0') ELSE
                    'Z';
   cgb_vssexqyx <= vssexqyx WHEN (vccelxqyx = '1') ELSE
                   'Z';
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_d2a_mbpass IS
   PORT (
      
      bypass       : IN STD_LOGIC_VECTOR(7 DOWNTO 5);
      d2a_in       : IN STD_LOGIC;
      d2a_out      : OUT STD_LOGIC;
      radce_adapt  : IN STD_LOGIC;
      radce_pdb    : IN STD_LOGIC;
      vccehx       : IN STD_LOGIC;
      vssex        : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_d2a_mbpass;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_d2a_mbpass IS
   
   SIGNAL level   : STD_LOGIC_VECTOR(7 DOWNTO 1);
   SIGNAL nbypass : STD_LOGIC_VECTOR(7 DOWNTO 5);
   SIGNAL sel     : STD_LOGIC_VECTOR(7 DOWNTO 0);
BEGIN
   
   d2a_out <= d2a_in WHEN ((radce_adapt OR (NOT(radce_adapt) AND NOT(radce_pdb))) = '1') ELSE
              'Z';
   d2a_out <= vccehx WHEN (((NOT(radce_adapt) AND radce_pdb) AND (bypass(7) OR bypass(6) OR bypass(5))) = '1') ELSE
              'Z';
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_tx_clkmux_cmu IS
   GENERIC (
      DELAY        : INTEGER := 1
   );
   PORT (
      cpulse       : OUT STD_LOGIC;
      cpulse_ht    : IN STD_LOGIC;
      cpulse_x1    : IN STD_LOGIC;
      cpulse_x4    : IN STD_LOGIC;
      cpulse_xn_b  : IN STD_LOGIC;
      cpulse_xn_t  : IN STD_LOGIC;
      delay_sel    : IN STD_LOGIC;
      hfclk_n      : OUT STD_LOGIC;
      hfclk_p      : OUT STD_LOGIC;
      hfclkn_ht    : IN STD_LOGIC;
      hfclkn_x1    : IN STD_LOGIC;
      hfclkn_x4    : IN STD_LOGIC;
      hfclkn_xn_b  : IN STD_LOGIC;
      hfclkn_xn_t  : IN STD_LOGIC;
      hfclkp_ht    : IN STD_LOGIC;
      hfclkp_x1    : IN STD_LOGIC;
      hfclkp_x4    : IN STD_LOGIC;
      hfclkp_xn_b  : IN STD_LOGIC;
      hfclkp_xn_t  : IN STD_LOGIC;
      ht_sel       : IN STD_LOGIC;
      lfclk_n      : OUT STD_LOGIC;
      lfclk_p      : OUT STD_LOGIC;
      lfclkn_ht    : IN STD_LOGIC;
      lfclkn_x1    : IN STD_LOGIC;
      lfclkn_x4    : IN STD_LOGIC;
      lfclkn_xn_b  : IN STD_LOGIC;
      lfclkn_xn_t  : IN STD_LOGIC;
      lfclkp_ht    : IN STD_LOGIC;
      lfclkp_x1    : IN STD_LOGIC;
      lfclkp_x4    : IN STD_LOGIC;
      lfclkp_xn_b  : IN STD_LOGIC;
      lfclkp_xn_t  : IN STD_LOGIC;
      pdb          : IN STD_LOGIC;
      sel          : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      vccelxqyx    : IN STD_LOGIC;
      vssexqyx     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_tx_clkmux_cmu;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_tx_clkmux_cmu IS
   
   SIGNAL n10_sel_0   : STD_LOGIC;
   SIGNAL n11_sel_1   : STD_LOGIC;
   SIGNAL nx1_sel_xn  : STD_LOGIC;
   SIGNAL n01_sel_x4  : STD_LOGIC;
   SIGNAL n00_sel_x1  : STD_LOGIC;
   SIGNAL hfclkp_x1_0 : STD_LOGIC;
   SIGNAL hfclkn_x1_0 : STD_LOGIC;
   SIGNAL cpulse_x1_0 : STD_LOGIC;
   SIGNAL lfclkp_x1_0 : STD_LOGIC;
   SIGNAL lfclkn_x1_0 : STD_LOGIC;
   SIGNAL sel_x4_d    : STD_LOGIC;
   SIGNAL hfclkp_x4_0 : STD_LOGIC;
   SIGNAL hfclkn_x4_0 : STD_LOGIC;
   SIGNAL cpulse_x4_0 : STD_LOGIC;
   SIGNAL lfclkp_x4_0 : STD_LOGIC;
   SIGNAL lfclkn_x4_0 : STD_LOGIC;
   SIGNAL hfclkp_xn   : STD_LOGIC;
   SIGNAL hfclkn_xn   : STD_LOGIC;
   SIGNAL cpulse_xn   : STD_LOGIC;
   SIGNAL lfclkp_xn   : STD_LOGIC;
   SIGNAL lfclkn_xn   : STD_LOGIC;
   SIGNAL hfclkp_ht_d : STD_LOGIC;
   SIGNAL hfclkn_ht_d : STD_LOGIC;
   SIGNAL cpulse_ht_d : STD_LOGIC;
   SIGNAL lfclkp_ht_d : STD_LOGIC;
   SIGNAL lfclkn_ht_d : STD_LOGIC;
   SIGNAL hfclkp_x4_d : STD_LOGIC;
   SIGNAL hfclkn_x4_d : STD_LOGIC;
   SIGNAL cpulse_x4_d : STD_LOGIC;
   SIGNAL lfclkp_x4_d : STD_LOGIC;
   SIGNAL lfclkn_x4_d : STD_LOGIC;
   -- X-HDL generated signals

   SIGNAL xhdl0 : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL xhdl1 : STD_LOGIC_VECTOR(2 DOWNTO 0);
BEGIN
   
   -- * * c_tx_clkmux_2t1 x0 * *
   
   -- xhtdelay
   PROCESS (hfclkp_ht, hfclkn_ht, cpulse_ht, lfclkp_ht, lfclkn_ht)
   BEGIN
      hfclkp_ht_d <=  TRANSPORT hfclkp_ht AFTER (DELAY)*1 ps;
      hfclkn_ht_d <=  TRANSPORT hfclkn_ht AFTER (DELAY)*1 ps;
      cpulse_ht_d <=  TRANSPORT cpulse_ht AFTER (DELAY)*1 ps;
      lfclkp_ht_d <=  TRANSPORT lfclkp_ht AFTER (DELAY)*1 ps;
      lfclkn_ht_d <=  TRANSPORT lfclkn_ht AFTER (DELAY)*1 ps;
   END PROCESS;
   
   -- assign {hfclkp_x1_0,hfclkn_x1_0,cpulse_x1_0,lfclkp_x1_0,lfclkn_x1_0} = ( pdb == 1'b0  ) ? 1'b0 :( (ht_sel == 1'b1) & (sel == 2'b00) ) ? {hfclkp_ht_d,hfclkn_ht_d,cpulse_ht_d,lfclkp_ht_d,lfclkn_ht_d} : {hfclkp_x1,hfclkn_x1,cpulse_x1,lfclkp_x1,lfclkn_x1};
   hfclkp_x1_0 <= '0' WHEN (pdb = '0') ELSE
                  hfclkp_ht_d WHEN ((ht_sel = '1') AND (sel = "00")) ELSE
                  hfclkp_x1;
   hfclkn_x1_0 <= '0' WHEN (pdb = '0') ELSE
                  hfclkn_ht_d WHEN ((ht_sel = '1') AND (sel = "00")) ELSE
                  hfclkn_x1;
   cpulse_x1_0 <= '0' WHEN (pdb = '0') ELSE
                  cpulse_ht_d WHEN ((ht_sel = '1') AND (sel = "00")) ELSE
                  cpulse_x1;
   lfclkp_x1_0 <= '0' WHEN (pdb = '0') ELSE
                  lfclkp_ht_d WHEN ((ht_sel = '1') AND (sel = "00")) ELSE
                  lfclkp_x1;
   lfclkn_x1_0 <= '0' WHEN (pdb = '0') ELSE
                  lfclkn_ht_d WHEN ((ht_sel = '1') AND (sel = "00")) ELSE
                  lfclkn_x1;
   
   -- * * c_tx_clkmux_2t1 x2 * *
   
   -- xdelay
   PROCESS (hfclkp_x4, hfclkn_x4, cpulse_x4, lfclkp_x4, lfclkn_x4)
   BEGIN
      hfclkp_x4_d <=  TRANSPORT hfclkp_x4 AFTER (DELAY)*1 ps;
      hfclkn_x4_d <=  TRANSPORT hfclkn_x4 AFTER (DELAY)*1 ps;
      cpulse_x4_d <=  TRANSPORT cpulse_x4 AFTER (DELAY)*1 ps;
      lfclkp_x4_d <=  TRANSPORT lfclkp_x4 AFTER (DELAY)*1 ps;
      lfclkn_x4_d <=  TRANSPORT lfclkn_x4 AFTER (DELAY)*1 ps;
   END PROCESS;
   
   sel_x4_d <= delay_sel AND NOT(sel(1)) AND sel(0);
   
   PROCESS (sel_x4_d, hfclkp_x4_d, hfclkn_x4_d, cpulse_x4_d, lfclkp_x4_d, lfclkn_x4_d, hfclkp_x4, hfclkn_x4, cpulse_x4, lfclkp_x4, lfclkn_x4, pdb)
   BEGIN
      IF (pdb = '1') THEN
         CASE sel_x4_d IS
            WHEN '0' =>
               hfclkp_x4_0 <= hfclkp_x4;
               hfclkn_x4_0 <= hfclkn_x4;
               cpulse_x4_0 <= cpulse_x4;
               lfclkp_x4_0 <= lfclkp_x4;
               lfclkn_x4_0 <= lfclkn_x4;
            WHEN '1' =>
               hfclkp_x4_0 <= hfclkp_x4_d;
               hfclkn_x4_0 <= hfclkn_x4_d;
               cpulse_x4_0 <= cpulse_x4_d;
               lfclkp_x4_0 <= lfclkp_x4_d;
               lfclkn_x4_0 <= lfclkn_x4_d;
            WHEN OTHERS =>
               hfclkp_x4_0 <= 'X';
               hfclkn_x4_0 <= 'X';
               cpulse_x4_0 <= 'X';
               lfclkp_x4_0 <= 'X';
               lfclkn_x4_0 <= 'X';
         END CASE;
      ELSE
         --     {hfclkp_x4_0,hfclkn_x4_0,cpulse_x4_0,lfclkp_x4_0,lfclkn_x4_0} = 5'b01001; : revert to 5'b00000 for now : all 6g regtests failing : need to find vhdl_out why
         hfclkp_x4_0 <= '0';
         hfclkn_x4_0 <= '0';
         cpulse_x4_0 <= '0';
         lfclkp_x4_0 <= '0';
         lfclkn_x4_0 <= '0';
      END IF;
   END PROCESS;
   
   -- * * c_tx_clkmux_2t1 x0 * *
   n10_sel_0 <= sel(1) AND NOT(sel(0)) AND pdb;
   n11_sel_1 <= sel(1) AND sel(0) AND pdb;
   
   xhdl0 <= n11_sel_1 & n10_sel_0;
   PROCESS (n11_sel_1, n10_sel_0, hfclkp_xn_t, hfclkn_xn_t, cpulse_xn_t, lfclkp_xn_t, lfclkn_xn_t, hfclkp_xn_b, hfclkn_xn_b, cpulse_xn_b, lfclkp_xn_b, lfclkn_xn_b, pdb)
   BEGIN
      IF (pdb = '1') THEN
         CASE xhdl0 IS
            WHEN "00" =>
               hfclkp_xn <= 'Z';
               hfclkn_xn <= 'Z';
               cpulse_xn <= 'Z';
               lfclkp_xn <= 'Z';
               lfclkn_xn <= 'Z';
            WHEN "01" =>
               hfclkp_xn <= hfclkp_xn_t;
               hfclkn_xn <= hfclkn_xn_t;
               cpulse_xn <= cpulse_xn_t;
               lfclkp_xn <= lfclkp_xn_t;
               lfclkn_xn <= lfclkn_xn_t;
            WHEN "10" =>
               hfclkp_xn <= hfclkp_xn_b;
               hfclkn_xn <= hfclkn_xn_b;
               cpulse_xn <= cpulse_xn_b;
               lfclkp_xn <= lfclkp_xn_b;
               lfclkn_xn <= lfclkn_xn_b;
            WHEN OTHERS =>
               hfclkp_xn <= 'X';
               hfclkn_xn <= 'X';
               cpulse_xn <= 'X';
               lfclkp_xn <= 'X';
               lfclkn_xn <= 'X';
         END CASE;
      ELSE
         --     {hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn} = 5'b01001; : revert to 5'b00000 for now : all 6g regtests failing : need to find vhdl_out why
         hfclkp_xn <= '0';
         hfclkn_xn <= '0';
         cpulse_xn <= '0';
         lfclkp_xn <= '0';
         lfclkn_xn <= '0';
      END IF;
   END PROCESS;
   
   -- * * c_tx_clkmux x1 * *
   nx1_sel_xn <= sel(1);
   n01_sel_x4 <= NOT(sel(1)) AND sel(0) AND pdb;
   n00_sel_x1 <= NOT(sel(1)) AND NOT(sel(0)) AND pdb;
   
   xhdl1 <= nx1_sel_xn & n01_sel_x4 & n00_sel_x1;
   PROCESS (nx1_sel_xn, n01_sel_x4, n00_sel_x1, hfclkp_x1_0, hfclkn_x1_0, cpulse_x1_0, lfclkp_x1_0, lfclkn_x1_0, hfclkp_x4_0, hfclkn_x4_0, cpulse_x4_0, lfclkp_x4_0, lfclkn_x4_0, hfclkp_xn, hfclkn_xn, cpulse_xn, lfclkp_xn, lfclkn_xn, pdb)
   BEGIN
      IF (pdb = '1') THEN
         CASE xhdl1 IS
            WHEN "000" =>
               hfclk_p <= 'Z';
               hfclk_n <= 'Z';
               cpulse <= 'Z';
               lfclk_p <= 'Z';
               lfclk_n <= 'Z';
            WHEN "001" =>
               hfclk_p <= hfclkp_x1_0;
               hfclk_n <= hfclkn_x1_0;
               cpulse <= cpulse_x1_0;
               lfclk_p <= lfclkp_x1_0;
               lfclk_n <= lfclkn_x1_0;
            WHEN "010" =>
               hfclk_p <= hfclkp_x4_0;
               hfclk_n <= hfclkn_x4_0;
               cpulse <= cpulse_x4_0;
               lfclk_p <= lfclkp_x4_0;
               lfclk_n <= lfclkn_x4_0;
            WHEN "100" =>
               hfclk_p <= hfclkp_xn;
               hfclk_n <= hfclkn_xn;
               cpulse <= cpulse_xn;
               lfclk_p <= lfclkp_xn;
               lfclk_n <= lfclkn_xn;
            WHEN OTHERS =>
               hfclk_p <= 'X';
               hfclk_n <= 'X';
               cpulse <= 'X';
               lfclk_p <= 'X';
               lfclk_n <= 'X';
         END CASE;
      ELSE
         --     {hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n} = 5'b01001; : revert to 5'b00000 for now : all 6g regtests failing : need to find vhdl_out why
         hfclk_p <= '0';
         hfclk_n <= '0';
         cpulse <= '0';
         lfclk_p <= '0';
         lfclk_n <= '0';
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
   
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_c_deser IS
   GENERIC (
      PARAM_DELAY         : INTEGER := 0;
      RST_SD_PULSE_WIDTH  : INTEGER := 1
   );
   PORT (
      clk90b              : IN STD_LOGIC;
      clk_divrx           : OUT STD_LOGIC;
      deser_div2          : IN STD_LOGIC;
      deser_div5          : IN STD_LOGIC;
      deser_pdb           : IN STD_LOGIC;
      deven               : IN STD_LOGIC;
      devenb              : IN STD_LOGIC;
      dodd                : IN STD_LOGIC;
      doddb               : IN STD_LOGIC;
      dout                : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);
      fsd                 : OUT STD_LOGIC;
      pcie_sw             : IN STD_LOGIC;
      pcieo               : OUT STD_LOGIC;
      rdynamic_sw         : IN STD_LOGIC;
      rfast_sd            : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rst_n               : IN STD_LOGIC;
      rtest_fastsd        : IN STD_LOGIC;
      rxinn               : IN STD_LOGIC;
      rxinp               : IN STD_LOGIC;
      vcce_la             : IN STD_LOGIC;
      vssexqyx            : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_deser;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_deser IS
   COMPONENT stratixiv_hssi_pma_c_divby2q
      PORT (
         clk                 : IN STD_LOGIC;
         clk0                : OUT STD_LOGIC;
         clk90               : OUT STD_LOGIC;
         clk180              : OUT STD_LOGIC;
         clk270              : OUT STD_LOGIC;
         clkb                : IN STD_LOGIC;
         rst_n               : IN STD_LOGIC;
         vcce_la             : IN STD_LOGIC;
         vssexqyx            : IN STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL dp                           : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL dsync                        : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL drp                          : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000" ;
   SIGNAL dfp                          : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000" ;
   SIGNAL outp                         : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL outn                         : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL ph                           : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL d10a                         : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL douta                        : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL doutb                        : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL deven_ok                     : STD_LOGIC;
   SIGNAL devenb_ok                    : STD_LOGIC;
   SIGNAL data_even                    : STD_LOGIC;
   SIGNAL dodd_ok                      : STD_LOGIC;
   SIGNAL doddb_ok                     : STD_LOGIC;
   SIGNAL data_odd                     : STD_LOGIC;
   SIGNAL ck_div                       : STD_LOGIC;
   SIGNAL clk90_div5                   : STD_LOGIC := '0' ;
   SIGNAL clk90_div4                   : STD_LOGIC := '0' ;
   SIGNAL clk270_div5                  : STD_LOGIC := '0' ;
   SIGNAL clk270_div4                  : STD_LOGIC := '0' ;
   SIGNAL clk90_div_init_done          : STD_LOGIC := '0' ;
   SIGNAL clk270_div_init_done         : STD_LOGIC := '0' ;
   SIGNAL rst_sd                       : STD_LOGIC := '1' ;
   SIGNAL even_all0q                   : STD_LOGIC := '0' ;
   SIGNAL even_all1q                   : STD_LOGIC := '0' ;
   SIGNAL odd_all0q                    : STD_LOGIC := '0' ;
   SIGNAL odd_all1q                    : STD_LOGIC := '0' ;
   SIGNAL shiftout                     : STD_LOGIC := '0' ;
   SIGNAL shiftout_1                   : STD_LOGIC := '0' ;
   SIGNAL shiftoutq                    : STD_LOGIC := '0' ;
   SIGNAL n1                           : STD_LOGIC := '0' ;
   SIGNAL n0                           : STD_LOGIC := '0' ;
   SIGNAL pcie2                        : STD_LOGIC := '0' ;
   SIGNAL n4                           : STD_LOGIC := '0' ;
   SIGNAL n3                           : STD_LOGIC := '0' ;
   SIGNAL n2                           : STD_LOGIC := '0' ;
   SIGNAL n6                           : STD_LOGIC := '0' ;
--   SIGNAL got_first_clk270_rising_edge : STD_LOGIC := '0' ;
   
   SIGNAL clk90                        : STD_LOGIC;
   SIGNAL clk270                       : STD_LOGIC;
   SIGNAL b1                           : STD_LOGIC;
   SIGNAL cout                         : STD_LOGIC;
   SIGNAL muxout_ff_chain              : STD_LOGIC;
   SIGNAL rst_ni                       : STD_LOGIC;
   SIGNAL rst_n_div2                   : STD_LOGIC;
   SIGNAL ck_div2                      : STD_LOGIC;
   SIGNAL ck_2div                      : STD_LOGIC;
   SIGNAL even_all0                    : STD_LOGIC;
   SIGNAL even_all1                    : STD_LOGIC;
   SIGNAL odd_all0                     : STD_LOGIC;
   SIGNAL odd_all1                     : STD_LOGIC;
   SIGNAL ckb_2div                     : STD_LOGIC;
   SIGNAL rxp_clk                      : STD_LOGIC;
   SIGNAL rxn_clk                      : STD_LOGIC;
   SIGNAL noswitch                     : STD_LOGIC;
   SIGNAL nc0                          : STD_LOGIC;
   SIGNAL nc1                          : STD_LOGIC;
   SIGNAL nc2                          : STD_LOGIC;
   SIGNAL ck_div_en                    : STD_LOGIC;
   SIGNAL pcie_clk_div                 : STD_LOGIC;
   SIGNAL activity                     : STD_LOGIC;
   SIGNAL exor                         : STD_LOGIC;
   
   SIGNAL clk90_counter                : INTEGER := 0 ;
   SIGNAL clk270_counter               : INTEGER := 0 ;
   -- X-HDL generated signals

   SIGNAL xhdl1 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL clk_divrx_xhdl0              : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   clk_divrx <= clk_divrx_xhdl0;
   
   rst_ni <= deser_pdb AND rst_n;
   rst_n_div2 <= rst_ni AND deser_div2;
   dout <= (doutb & douta);
   clk_divrx_xhdl0 <= ck_div_en AND (NOT(ck_2div));
   clk90 <= NOT(clk90b);
   clk270 <= clk90b;
   
   -- * * c_deser_ph_clk * * 
   -- b1   synch w/ clk90  ; 60-40 duty-cycle vhdl_in div5 mode ; 50-50 vhdl_in div4 mode
   -- cout synch w/ clk270 ; 50-50 duty-cycle vhdl_in div5 and div4 modes
   b1 <= clk90_div5 WHEN (deser_div5 = '1') ELSE
         clk90_div4;
   cout <= clk270_div5 WHEN (deser_div5 = '1') ELSE
           clk270_div4;
   PROCESS (clk90, rst_ni)
   BEGIN
      IF (rst_ni = '0') THEN
         clk90_counter <= 0;
         clk90_div_init_done <= '0';
         clk90_div5 <= '0';
         clk90_div4 <= '0';
      ELSIF (clk90'EVENT AND clk90 = '1') THEN
         -- generation of clk90_div5 
         IF (clk90_div_init_done = '0') THEN
            clk90_div5 <= '1';
            clk90_div4 <= '1';
            clk90_div_init_done <= '1';
         ELSE
            IF (clk90_counter MOD 5 = 0) THEN
               clk90_div5 <= '1';
            ELSIF (clk90_counter MOD 5 = 3) THEN
               -- generation of clk90_div4 
               clk90_div5 <= '0';
            END IF;
            IF (clk90_counter MOD 2 = 0) THEN
               clk90_div4 <= NOT(clk90_div4);
            END IF;
         END IF;
         clk90_counter <= clk90_counter + 1;
      END IF;
   END PROCESS;
   
   -- clk270_div4/5 should not start toggling before clk90_div4/5 
   PROCESS (clk270, rst_ni)
   VARIABLE got_first_clk270_rising_edge : STD_LOGIC := '0' ;
   BEGIN
      IF (rst_ni = '0') THEN
         clk270_counter <= 0;
         clk270_div_init_done <= '0';
         clk270_div5 <= '0';
         clk270_div4 <= '0';
         got_first_clk270_rising_edge := '0';
      ELSE
         IF (clk90_div_init_done = '1') THEN
            -- generation of clk270_div5
            IF ((clk270_counter MOD 5 = 0) AND (clk270 = '1')) THEN
               got_first_clk270_rising_edge := '1';
               clk270_div5 <= '1';
            ELSIF ((clk270_counter MOD 5 = 0) AND (clk270 = '0')) THEN
               -- generation of clk270_div4
               clk270_div5 <= '0';
            END IF;
            IF ((clk270 = '1') AND (clk270_counter MOD 4 = 0)) THEN
               IF (clk270_div_init_done = '0') THEN
                  clk270_div4 <= '1';
                  clk270_div_init_done <= '1';
               ELSE
                  clk270_div4 <= NOT(clk270_div4);
               END IF;
            END IF;
            IF (got_first_clk270_rising_edge = '1') THEN
               clk270_counter <= clk270_counter + 1;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   -- like b1, ph duty-cycle is 60-40 vhdl_in dvi5 mode, and 50-50 vhdl_in div4 mode
   PROCESS (rst_ni, clk270)
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         ph(3 DOWNTO 0) <=  TRANSPORT "0000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (clk270'EVENT AND clk270 = '1') THEN
         ph(3 DOWNTO 0) <=  TRANSPORT (ph(2 DOWNTO 0) & b1) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (deser_div5, clk270)
   BEGIN
      IF ((NOT(deser_div5)) = '1') THEN
         ph(4) <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (clk270'EVENT AND clk270 = '1') THEN
         -- Shift register
         ph(4) <=  TRANSPORT ph(3) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ph(0))
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         dp(1 DOWNTO 0) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ph(0)'EVENT AND ph(0) = '1') THEN
         dp(1 DOWNTO 0) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;		-- used to be {data_odd,data_even}
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ph(1))
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         dp(3 DOWNTO 2) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ph(1)'EVENT AND ph(1) = '1') THEN
         dp(3 DOWNTO 2) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ph(2))
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         dp(5 DOWNTO 4) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ph(2)'EVENT AND ph(2) = '1') THEN
         dp(5 DOWNTO 4) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ph(3))
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         dp(7 DOWNTO 6) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ph(3)'EVENT AND ph(3) = '1') THEN
         dp(7 DOWNTO 6) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ph(4))
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         dp(9 DOWNTO 8) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ph(4)'EVENT AND ph(4) = '1') THEN
         -- dp[0,1,2,3] synchronization
         dp(9 DOWNTO 8) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ph(3))
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         dsync(3 DOWNTO 0) <=  TRANSPORT "0000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ph(3)'EVENT AND ph(3) = '1') THEN
         dsync(3 DOWNTO 0) <=  TRANSPORT dp(3 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ph(0))
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         outp(9 DOWNTO 0) <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
         outn(9 DOWNTO 0) <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ph(0)'EVENT AND ph(0) = '1') THEN
         outp(9 DOWNTO 0) <=  TRANSPORT (dp(9 DOWNTO 4) & dsync(3 DOWNTO 0)) AFTER (PARAM_DELAY)*1 ps;
         outn(9 DOWNTO 0) <=  TRANSPORT NOT((dp(9 DOWNTO 4) & dsync(3 DOWNTO 0))) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   -- * * c_deser_10to20 * *
   
   xhdl1 <= NOT(cout);
   xdiv2_2 : stratixiv_hssi_pma_c_divby2q
      PORT MAP (
         clk       => xhdl1,
         clkb      => cout,
         clk0      => nc0,
         clk90     => nc1,
         vcce_la   => '1',
         vssexqyx  => '0',
         clk180    => ck_div2,
         clk270    => nc2,
         rst_n     => rst_ni
      );
   
   ck_2div <= NOT(ck_div2) WHEN (deser_div2 = '1') ELSE
              NOT(cout);
   ckb_2div <= ck_div2 WHEN (deser_div2 = '1') ELSE
               cout;
   
   PROCESS (rst_ni, ck_2div)
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         d10a(9 DOWNTO 0) <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ck_2div'EVENT AND ck_2div = '1') THEN
         d10a(9 DOWNTO 0) <=  TRANSPORT outp(9 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, ckb_2div)
   BEGIN
      IF ((NOT(rst_ni)) = '1') THEN
         douta(9 DOWNTO 0) <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ckb_2div'EVENT AND ckb_2div = '1') THEN
         douta(9 DOWNTO 0) <=  TRANSPORT d10a(9 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_n_div2, ckb_2div)
   BEGIN
      IF ((NOT(rst_n_div2)) = '1') THEN
         doutb(9 DOWNTO 0) <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ckb_2div'EVENT AND ckb_2div = '1') THEN
         -- ** c_deser_data_comp blocks * *
         doutb(9 DOWNTO 0) <=  TRANSPORT outp(9 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   even_all1 <= reduction_and((outp(6) & outp(4) & outp(2) & outp(0))) AND (NOT(deser_div5) OR outp(8));
   even_all0 <= reduction_and((outn(6) & outn(4) & outn(2) & outn(0))) AND (NOT(deser_div5) OR outn(8));
   odd_all1 <= reduction_and((outp(7) & outp(5) & outp(3) & outp(1))) AND (NOT(deser_div5) OR outp(9));
   odd_all0 <= reduction_and((outn(7) & outn(5) & outn(3) & outn(1))) AND (NOT(deser_div5) OR outn(9));
   
   -- rst_sd pulse generator
   PROCESS (ph(3))
   BEGIN
      IF (ph(3)'EVENT AND ph(3) = '1') THEN
         rst_sd <= '0';
         rst_sd <=  TRANSPORT '1' AFTER (RST_SD_PULSE_WIDTH)*1 ps;
      END IF;
   END PROCESS;
   
   -- c_deser_ff_chain
   rxp_clk <= rxinp AND rfast_sd(2);
   rxn_clk <= rxinn AND rfast_sd(2);
   muxout_ff_chain <= reduction_or((drp(0) & dfp(0))) WHEN (rfast_sd(1) = '0' AND rfast_sd(0) = '0') ELSE
                      reduction_or((drp(1) & dfp(1))) WHEN (rfast_sd(1) = '0' AND rfast_sd(0) = '1') ELSE
                      reduction_or((drp(2) & dfp(2))) WHEN (rfast_sd(1) = '1' AND rfast_sd(0) = '0') ELSE
                      reduction_or((drp(3) & dfp(3))) WHEN (rfast_sd(1) = '1' AND rfast_sd(0) = '1') ELSE
                      'X';
   
   PROCESS (rxp_clk, rst_sd)
   BEGIN
      IF (rst_sd = '0') THEN
         drp(3 DOWNTO 0) <=  TRANSPORT "0000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (rxp_clk'EVENT AND rxp_clk = '1') THEN
         drp(3 DOWNTO 0) <=  TRANSPORT (drp(2 DOWNTO 0) & vcce_la) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rxn_clk, rst_sd)
   BEGIN
      IF (rst_sd = '0') THEN
         dfp(3 DOWNTO 0) <=  TRANSPORT "0000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (rxn_clk'EVENT AND rxn_clk = '1') THEN
         dfp(3 DOWNTO 0) <=  TRANSPORT (dfp(2 DOWNTO 0) & vcce_la) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (ph(3))
   BEGIN
      IF (ph(3)'EVENT AND ph(3) = '1') THEN
         shiftout_1 <=  TRANSPORT muxout_ff_chain AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (ph(3))
   BEGIN
      IF (ph(3)'EVENT AND ph(3) = '0') THEN
         -- c_deser_pcie
         shiftout <=  TRANSPORT shiftout_1 AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   pcie_clk_div <= ck_2div AND rdynamic_sw;
   exor <= (NOT(n1) AND n0) OR (n1 AND NOT(n0));
   ck_div_en <= NOT((n2 OR n3 OR n4));
   pcieo <= NOT(rdynamic_sw) OR n6;
   
   PROCESS (pcie_clk_div, rst_ni)
   BEGIN
      IF (rst_ni = '0') THEN
         n1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         n0 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         pcie2 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         n4 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         n3 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         n2 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         n6 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (pcie_clk_div'EVENT AND pcie_clk_div = '1') THEN
         n1 <=  TRANSPORT n0 AFTER (PARAM_DELAY)*1 ps;
         n0 <=  TRANSPORT pcie2 AFTER (PARAM_DELAY)*1 ps;
         pcie2 <=  TRANSPORT pcie_sw AFTER (PARAM_DELAY)*1 ps;
         n4 <=  TRANSPORT n3 AFTER (PARAM_DELAY)*1 ps;
         n3 <=  TRANSPORT n2 AFTER (PARAM_DELAY)*1 ps;
         n2 <=  TRANSPORT exor AFTER (PARAM_DELAY)*1 ps;
         n6 <=  TRANSPORT n1 AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   -- c_deser_data_comp
   noswitch <= (((shiftout OR NOT(rfast_sd(3))) AND shiftoutq) OR (NOT(rfast_sd(2)) AND rtest_fastsd)) AND (NOT(activity) OR (NOT(rfast_sd(2)) AND NOT(rtest_fastsd)));
   
   activity <= NOT(((((even_all0 OR NOT(rfast_sd(3))) AND even_all0q) OR ((even_all1 OR NOT(rfast_sd(3))) AND even_all1q)) AND (((odd_all0 OR NOT(rfast_sd(3))) AND odd_all0q) OR ((odd_all0 OR NOT(rfast_sd(3))) AND odd_all0q))));
   
   PROCESS (rst_ni, clk_divrx_xhdl0)
   BEGIN
      IF (rst_ni = '0') THEN
         even_all1q <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         even_all0q <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         odd_all1q <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         odd_all0q <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         shiftoutq <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (clk_divrx_xhdl0'EVENT AND clk_divrx_xhdl0 = '0') THEN
         even_all1q <=  TRANSPORT even_all1 AFTER (PARAM_DELAY)*1 ps;
         even_all0q <=  TRANSPORT even_all0 AFTER (PARAM_DELAY)*1 ps;
         odd_all1q <=  TRANSPORT odd_all1 AFTER (PARAM_DELAY)*1 ps;
         odd_all0q <=  TRANSPORT odd_all0 AFTER (PARAM_DELAY)*1 ps;
         shiftoutq <=  TRANSPORT shiftout AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (rst_ni, clk_divrx_xhdl0)
   BEGIN
      IF (rst_ni = '0') THEN
         fsd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (clk_divrx_xhdl0'EVENT AND clk_divrx_xhdl0 = '1') THEN
         fsd <=  TRANSPORT NOT(noswitch) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_div4or5_mcnt IS
   PORT (
      clk     : IN STD_LOGIC;
      clkb    : IN STD_LOGIC;
      d5      : IN STD_LOGIC;
      fout    : OUT STD_LOGIC;
      foutn   : OUT STD_LOGIC;
      rst_n   : IN STD_LOGIC;
      vccerx  : IN STD_LOGIC;
      vssex   : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_div4or5_mcnt;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_div4or5_mcnt IS
   
   SIGNAL clk_by2    : STD_LOGIC;
   SIGNAL clk_by4    : STD_LOGIC;
   SIGNAL a          : STD_LOGIC;
   SIGNAL b          : STD_LOGIC;
   SIGNAL c          : STD_LOGIC;
   SIGNAL clk_by5    : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL fout_xhdl0 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   fout <= fout_xhdl0;
   
   foutn <= NOT(fout_xhdl0);
   fout_xhdl0 <= clk_by5 WHEN (d5 = '1') ELSE
                 clk_by4;
   
   -- Divide-by-4 clock
   PROCESS (rst_n, clk)
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         clk_by2 <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         
         clk_by2 <= NOT(clk_by2);
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, clk_by2)
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         clk_by4 <= '0';
      ELSIF (clk_by2'EVENT AND clk_by2 = '1') THEN
         
         -- Divide-by-5 clock
         clk_by4 <= NOT(clk_by4);
      END IF;
   END PROCESS;
   
   clk_by5 <= (clk OR NOT(b)) AND (a OR clk_by5);
   PROCESS (rst_n, clk)
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         a <= '0';
         b <= '0';
         c <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         a <= (NOT(a) AND NOT(b) AND c);
         b <= (NOT(a) AND NOT(c));
         c <= (b);
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_c_lockdet_tx18 IS
   PORT (
      
      disableb  : IN STD_LOGIC;
      dn        : IN STD_LOGIC;
      dnb       : IN STD_LOGIC;
      ib50      : INOUT STD_LOGIC;
      lock      : OUT STD_LOGIC;
      lockb     : OUT STD_LOGIC;
      pd        : IN STD_LOGIC;
      up        : IN STD_LOGIC;
      upb       : IN STD_LOGIC;
      vccerx    : IN STD_LOGIC;
      vssex     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_lockdet_tx18;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_lockdet_tx18 IS
   
   SIGNAL cnt        : STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL lock_xhdl0 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   lock <= lock_xhdl0;
   
   lock_xhdl0 <= int2bit((cnt = "00011"));
   lockb <= NOT(lock_xhdl0);
   
   PROCESS (pd, up)
   BEGIN
      IF (pd = '1') THEN
         cnt <= "00000";
      ELSIF (up'EVENT AND up = '1') THEN
         IF (cnt /= "00011") THEN
            cnt <= cnt + "00001";
         END IF;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_pfd IS
   PORT (
      dn      : OUT STD_LOGIC;
      dnb     : OUT STD_LOGIC;
      fbclk   : IN STD_LOGIC;
      refclk  : IN STD_LOGIC;
      up      : OUT STD_LOGIC;
      upb     : OUT STD_LOGIC;
      vccerx  : IN STD_LOGIC;
      vssex   : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_pfd;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_pfd IS
BEGIN
   
   up <= refclk;
   upb <= NOT(refclk);
   dn <= fbclk;
   dnb <= NOT(fbclk);
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rlpbk_ctrl IS
   PORT (
      cru_rlbk      : IN STD_LOGIC;
      rrevlb_sw     : IN STD_LOGIC;
      rrx_s_rdlpbk  : IN STD_LOGIC;
      tx_rlpbk      : OUT STD_LOGIC;
      vccerx        : IN STD_LOGIC;
      vssex         : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_rlpbk_ctrl;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rlpbk_ctrl IS
BEGIN
   
   tx_rlpbk <= cru_rlbk WHEN (rrevlb_sw = '1') ELSE
               rrx_s_rdlpbk;
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rlpbk_mux IS
   PORT (
      
      doddn    : IN STD_LOGIC;
      doddp    : IN STD_LOGIC;
      dodn     : IN STD_LOGIC;
      dodp     : IN STD_LOGIC;
      don      : IN STD_LOGIC;
      don_pre  : IN STD_LOGIC;
      dop      : IN STD_LOGIC;
      dop_pre  : IN STD_LOGIC;
      drxn     : IN STD_LOGIC;
      drxp     : IN STD_LOGIC;
      sel      : IN STD_LOGIC;
      vcce_la  : IN STD_LOGIC;
      
      voddn    : OUT STD_LOGIC;
      voddp    : OUT STD_LOGIC;
      vodn     : OUT STD_LOGIC;
      vodp     : OUT STD_LOGIC;
      von      : OUT STD_LOGIC;
      von_pre  : OUT STD_LOGIC;
      vop      : OUT STD_LOGIC;
      vop_pre  : OUT STD_LOGIC;
      vssex    : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_rlpbk_mux;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rlpbk_mux IS
BEGIN
   
   von <= don WHEN (sel = '1') ELSE
          drxn;
   vop <= dop WHEN (sel = '1') ELSE
          drxp;
   voddn <= doddn;
   voddp <= doddp;
   vodn <= dodn;
   vodp <= dodp;
   von_pre <= don_pre;
   vop_pre <= dop_pre;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;

   
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_c_rx IS
   GENERIC (
      PARAM_DELAY        : INTEGER := 0;
      INVALID_SD_ON_OFF  : INTEGER := 500
   );
   PORT (
      analog_sd          : OUT STD_LOGIC;
      atb_0              : INOUT STD_LOGIC;
      atb_1              : INOUT STD_LOGIC;
      atbsel             : IN STD_LOGIC_VECTOR(5 DOWNTO 0);
      ck0_sigdet         : IN STD_LOGIC;
      eqa_ctrl           : IN STD_LOGIC;
      eqb_ctrl           : IN STD_LOGIC;
      eqc_ctrl           : IN STD_LOGIC;
      eqd_ctrl           : IN STD_LOGIC;
      eqv_ctrl           : IN STD_LOGIC;
      ibc50u             : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      ibp50u             : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      ibp150u            : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      inn                : IN STD_LOGIC;
      inn3               : OUT STD_LOGIC;
      inp                : IN STD_LOGIC;
      inp3               : OUT STD_LOGIC;
      lpbkn              : IN STD_LOGIC;
      lpbkp              : IN STD_LOGIC;
      oc_calpd           : IN STD_LOGIC;
      oc_en              : IN STD_LOGIC;
      pdb                : IN STD_LOGIC;
      rbit_dc            : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rdlpbkn            : OUT STD_LOGIC;
      rdlpbkp            : OUT STD_LOGIC;
      refclk             : IN STD_LOGIC;
      rx_b50             : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rx_oc              : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rx_test            : IN STD_LOGIC;
      rx_testclk         : IN STD_LOGIC;
      rxbuf_ibias        : OUT STD_LOGIC;
      rxn                : OUT STD_LOGIC;
      rxp                : OUT STD_LOGIC;
      s_lpbk             : IN STD_LOGIC;
      s_rdlpbk           : IN STD_LOGIC;
      sd_cdr             : OUT STD_LOGIC;
      sd_cpon            : OUT STD_LOGIC;
      sd_cpop            : OUT STD_LOGIC;
      sd_force           : IN STD_LOGIC;
      sd_off             : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      sd_on              : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      sdlv               : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      term               : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      vcce_la            : IN STD_LOGIC;
      vcce_oa            : IN STD_LOGIC;
      vccehtxqyx         : IN STD_LOGIC;
      vssexqyx           : IN STD_LOGIC;
      vtt                : IN STD_LOGIC_VECTOR(2 DOWNTO 0)
   );
END stratixiv_hssi_pma_c_rx;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rx IS
   
   SIGNAL ib50uc2               : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   SIGNAL vccbn1g               : STD_LOGIC;
   SIGNAL d_vm                  : STD_LOGIC;
   SIGNAL vbn_lb                : STD_LOGIC;
   SIGNAL vbn_dlb               : STD_LOGIC;
   SIGNAL vbn2_dlb              : STD_LOGIC;
   SIGNAL rxbuf_vcc             : STD_LOGIC;
   SIGNAL rxbuf_vsg             : STD_LOGIC;
   SIGNAL dlbpd                 : STD_LOGIC;
   SIGNAL lbpd                  : STD_LOGIC;
   SIGNAL linepd                : STD_LOGIC;
   
   SIGNAL rst_sdn               : STD_LOGIC := '0' ;
   SIGNAL rst_sdp               : STD_LOGIC := '0' ;
   SIGNAL sdp                   : STD_LOGIC := '0' ;
   SIGNAL sdn                   : STD_LOGIC := '0' ;
   SIGNAL sd_on_chg             : STD_LOGIC;
   SIGNAL sd_off_chg            : STD_LOGIC;
   SIGNAL sd_1_compout_pulse    : INTEGER;
   SIGNAL sd_0_ck0_pulse        : INTEGER;
   SIGNAL sdp_count             : INTEGER := 0 ;
   SIGNAL sdn_count             : INTEGER := 0 ;
   SIGNAL ck0_sigdet_count_cpop : INTEGER := 0 ;
   SIGNAL ck0_sigdet_count_cpon : INTEGER := 0 ;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL analog_sd_xhdl0       : STD_LOGIC;
   SIGNAL inn3_xhdl1            : STD_LOGIC;
   SIGNAL inp3_xhdl2            : STD_LOGIC;
   SIGNAL rxbuf_ibias_xhdl3     : STD_LOGIC;
   SIGNAL rxn_xhdl4             : STD_LOGIC;
   SIGNAL rxp_xhdl5             : STD_LOGIC;
   SIGNAL sd_cpon_xhdl6         : STD_LOGIC;
   SIGNAL sd_cpop_xhdl7         : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   analog_sd <= analog_sd_xhdl0;
   inn3 <= inn3_xhdl1;
   inp3 <= inp3_xhdl2;
   rxbuf_ibias <= rxbuf_ibias_xhdl3;
   rxn <= rxn_xhdl4;
   rxp <= rxp_xhdl5;
   sd_cpon <= sd_cpon_xhdl6;
   sd_cpop <= sd_cpop_xhdl7;
   
   atb_0 <= vccbn1g WHEN ((atbsel(0)) = '1') ELSE
            'Z';
   atb_1 <= d_vm WHEN ((atbsel(0)) = '1') ELSE
            'Z';
   atb_0 <= rxbuf_ibias_xhdl3 WHEN ((atbsel(1)) = '1') ELSE
            'Z';
   atb_1 <= vbn_lb WHEN ((atbsel(1)) = '1') ELSE
            'Z';
   atb_0 <= vbn_dlb WHEN ((atbsel(2)) = '1') ELSE
            'Z';
   atb_1 <= vbn2_dlb WHEN ((atbsel(2)) = '1') ELSE
            'Z';
   atb_0 <= rxbuf_vcc WHEN ((atbsel(3)) = '1') ELSE
            'Z';
   atb_1 <= rxbuf_vsg WHEN ((atbsel(3)) = '1') ELSE
            'Z';
   atb_0 <= vssexqyx WHEN ((atbsel(4)) = '1') ELSE
            'Z';
   atb_1 <= vssexqyx WHEN ((atbsel(4)) = '1') ELSE
            'Z';
   
   -- c_rx_dlb - buffer w/ power-down (loopback to TX)
   dlbpd <= NOT((s_rdlpbk AND pdb));
   rdlpbkp <= '1' WHEN (dlbpd = '1') ELSE
              rxp_xhdl5;
   rdlpbkn <= '0' WHEN (dlbpd = '1') ELSE
              rxn_xhdl4;
   
   -- c_rx_lb - buffer w/ power-down (loopback from serializer)
   lbpd <= NOT((s_lpbk AND pdb));
   inp3_xhdl2 <= inp WHEN (lbpd = '1') ELSE
                 lpbkp WHEN (pdb = '1') ELSE
                 '1';
   inn3_xhdl1 <= inn WHEN (lbpd = '1') ELSE
                 lpbkn WHEN (pdb = '1') ELSE
                 '1';
   
   -- c_rx_term_vtt black-box
   
   -- c_rx_buffer instance
   linepd <= rx_test OR s_lpbk;
   rxp_xhdl5 <= inp WHEN (linepd = '0') ELSE		-- Logic to be changed
                inp3_xhdl2 WHEN ((rx_test = '0') AND (rx_testclk = '0')) ELSE
                refclk WHEN ((rx_test = '0') AND (rx_testclk = '1')) ELSE
                lpbkp WHEN ((rx_test = '1') AND (rx_testclk = '0')) ELSE
                '1' WHEN (pdb = '1') ELSE
                '1';
   rxn_xhdl4 <= inn WHEN (linepd = '0') ELSE		-- Logic to be changed
                inn3_xhdl1 WHEN ((rx_test = '0') AND (rx_testclk = '0')) ELSE
                NOT(refclk) WHEN ((rx_test = '0') AND (rx_testclk = '1')) ELSE
                lpbkn WHEN ((rx_test = '1') AND (rx_testclk = '0')) ELSE
                '1' WHEN (pdb = '1') ELSE
                '1';
   
   -- c_sd - vhdl_signal detect 
   analog_sd_xhdl0 <= sdp OR sdn;
   sd_cdr <= sd_force OR s_lpbk OR analog_sd_xhdl0;
   sd_cpop_xhdl7 <= (inp AND pdb);		-- for digital simulation, assuming inp and inn are comparator's outputs
   sd_cpon_xhdl6 <= (inn AND pdb);
   
   
   PROCESS (sd_on)
   BEGIN
      IF ((sd_on = "0000") OR (sd_on = "1111")) THEN
         --       $display ("Instance %m, Time %t: ERROR [Illegal usage]: The SD_ON value is illegal - sd_on=%b", $time, sd_on);
         sd_1_compout_pulse <= INVALID_SD_ON_OFF;
      ELSE
         CASE sd_on IS
            WHEN "0001" =>
               sd_1_compout_pulse <= 4;
            WHEN "0010" =>
               sd_1_compout_pulse <= 6;
            WHEN "0011" =>
               sd_1_compout_pulse <= 8;
            WHEN "0100" =>
               sd_1_compout_pulse <= 10;
            WHEN "0101" =>
               sd_1_compout_pulse <= 12;
            WHEN "0110" =>
               sd_1_compout_pulse <= 14;
            WHEN "0111" =>
               sd_1_compout_pulse <= 16;
            WHEN "1000" =>
               sd_1_compout_pulse <= 18;
            WHEN "1001" =>
               sd_1_compout_pulse <= 20;
            WHEN "1010" =>
               sd_1_compout_pulse <= 22;
            WHEN "1011" =>
               sd_1_compout_pulse <= 24;
            WHEN "1100" =>
               sd_1_compout_pulse <= 26;
            WHEN "1101" =>
               sd_1_compout_pulse <= 28;
            WHEN "1110" =>
               sd_1_compout_pulse <= 30;
            WHEN "1111" =>
               sd_1_compout_pulse <= INVALID_SD_ON_OFF;
            WHEN OTHERS =>
               sd_1_compout_pulse <= 4;
         END CASE;
      END IF;
      sd_1_compout_pulse <= bin2int(sd_on);
      sd_on_chg <= '1';
      sd_on_chg <=  TRANSPORT '0' AFTER 1 ps;
   END PROCESS;
   
   
   PROCESS (sd_off)
   BEGIN
      IF (sd_off = "01111") THEN
         --       $display ("Instance %m, Time %t: ERROR [Illegal usage]: The SD_OFF value is illegal - sd_off=%b", $time, sd_off);
         sd_0_ck0_pulse <= INVALID_SD_ON_OFF;
      ELSE
         CASE sd_off(3 DOWNTO 0) IS
            WHEN "0001" =>
               sd_0_ck0_pulse <= 4;
            WHEN "0010" =>
               sd_0_ck0_pulse <= 6;
            WHEN "0011" =>
               sd_0_ck0_pulse <= 8;
            WHEN "0100" =>
               sd_0_ck0_pulse <= 10;
            WHEN "0101" =>
               sd_0_ck0_pulse <= 12;
            WHEN "0110" =>
               sd_0_ck0_pulse <= 14;
            WHEN "0111" =>
               sd_0_ck0_pulse <= 16;
            WHEN "1000" =>
               sd_0_ck0_pulse <= 18;
            WHEN "1001" =>
               sd_0_ck0_pulse <= 20;
            WHEN "1010" =>
               sd_0_ck0_pulse <= 22;
            WHEN "1011" =>
               sd_0_ck0_pulse <= 24;
            WHEN "1100" =>
               sd_0_ck0_pulse <= 26;
            WHEN "1101" =>
               sd_0_ck0_pulse <= 28;
            WHEN "1110" =>
               sd_0_ck0_pulse <= 30;
            WHEN "1111" =>
               sd_0_ck0_pulse <= INVALID_SD_ON_OFF;
            WHEN OTHERS =>
               sd_0_ck0_pulse <= 4;
         END CASE;
      END IF;
      sd_off_chg <= '1';
      sd_off_chg <=  TRANSPORT '0' AFTER 1 ps;
   END PROCESS;
   
   
   -- Set sdp
   PROCESS (sd_cpop_xhdl7, rst_sdp, sd_on_chg)
   BEGIN
      IF (sd_cpop_xhdl7'EVENT AND sd_cpop_xhdl7 = '0') THEN
         IF ((rst_sdp = '1') OR (sd_on_chg = '1')) THEN
            sdp <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
             
            sdp_count <= 0;
         ELSE
            sdp_count <= sdp_count + 1;
            IF (sdp_count >= sd_1_compout_pulse) THEN
               sdp <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
                
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   
   -- Set sdn
   PROCESS (sd_cpon_xhdl6, rst_sdn, sd_on_chg)
   BEGIN
      IF (sd_cpon_xhdl6'EVENT AND sd_cpon_xhdl6 = '0') THEN
         IF ((rst_sdn = '1') OR (sd_on_chg = '1')) THEN
            sdn <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
             
            sdn_count <= 0;
         ELSE
            sdn_count <= sdn_count + 1;
            IF (sdn_count >= sd_1_compout_pulse) THEN
               sdn <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
                
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   
   -- Clear sdp -- generate rst_sdp
   PROCESS (ck0_sigdet, sd_cpop_xhdl7)
   BEGIN
      IF ((ck0_sigdet = '0') AND (sd_cpop_xhdl7 = '0')) THEN
         ck0_sigdet_count_cpop <= ck0_sigdet_count_cpop + 1;
         IF (ck0_sigdet_count_cpop = sd_0_ck0_pulse) THEN
            rst_sdp <= '1';
         END IF;
      ELSIF (sd_cpop_xhdl7'EVENT AND sd_cpop_xhdl7 = '1') THEN
         IF (ck0_sigdet = '1') THEN
            rst_sdp <= '0';
         END IF;
      END IF;
      IF (sd_cpop_xhdl7 = '1') THEN
         ck0_sigdet_count_cpop <= 0;
      END IF;
   END PROCESS;
   
   
   -- Clear sdn -- generate rst_sdn
   PROCESS (ck0_sigdet, sd_cpon_xhdl6)
   BEGIN
      IF ((ck0_sigdet = '0') AND (sd_cpon_xhdl6 = '0')) THEN
         ck0_sigdet_count_cpon <= ck0_sigdet_count_cpon + 1;
         IF (ck0_sigdet_count_cpon = sd_0_ck0_pulse) THEN
            rst_sdn <= '1';
         END IF;
      ELSIF (sd_cpon_xhdl6'EVENT AND sd_cpon_xhdl6 = '1') THEN
         IF (ck0_sigdet = '1') THEN
            rst_sdn <= '0';
         END IF;
      END IF;
      IF (sd_cpon_xhdl6 = '1') THEN
         ck0_sigdet_count_cpon <= 0;
      END IF;
   END PROCESS;
   
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;

   
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_ser IS
   GENERIC (
      
      PARAM_DELAY    : INTEGER := 0
   );
   PORT (
      
      clk_divtx      : OUT STD_LOGIC;
      cpulse         : IN STD_LOGIC;
      data           : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
      div2           : IN STD_LOGIC;
      div5           : IN STD_LOGIC;
      hfclkn         : IN STD_LOGIC;
      hfclkp         : IN STD_LOGIC;
      lbvon          : OUT STD_LOGIC;
      lbvop          : OUT STD_LOGIC;
      lfclkn         : IN STD_LOGIC;
      lfclkp         : IN STD_LOGIC;
      pclk_in        : IN STD_LOGIC;
      pclksel        : IN STD_LOGIC;
      pdb            : IN STD_LOGIC;
      pre_em         : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      pre_em_2t      : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      pre_em_pretap  : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      pre_en_out     : OUT STD_LOGIC;
      rst_n          : IN STD_LOGIC;
      s_lpbk         : IN STD_LOGIC;
      vccelxqyx      : IN STD_LOGIC;
      vccetxqyx      : IN STD_LOGIC;
      von            : OUT STD_LOGIC;
      von_op1        : OUT STD_LOGIC;
      von_op2        : OUT STD_LOGIC;
      von_pre        : OUT STD_LOGIC;
      vop            : OUT STD_LOGIC;
      vop_op1        : OUT STD_LOGIC;
      vop_op2        : OUT STD_LOGIC;
      vop_pre        : OUT STD_LOGIC;
      vssexqyx       : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_ser;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_ser IS
   COMPONENT stratixiv_hssi_pma_c_divby2q
      PORT (
         clk            : IN STD_LOGIC;
         clk0           : OUT STD_LOGIC;
         clk90          : OUT STD_LOGIC;
         clk180         : OUT STD_LOGIC;
         clk270         : OUT STD_LOGIC;
         clkb           : IN STD_LOGIC;
         rst_n          : IN STD_LOGIC;
         vcce_la        : IN STD_LOGIC;
         vssexqyx       : IN STD_LOGIC
      );
   END COMPONENT;
   
   
   SIGNAL pre_en            : STD_LOGIC;
   SIGNAL pre_en_pretap     : STD_LOGIC;
   SIGNAL pre_en_2t         : STD_LOGIC;
   SIGNAL s_lpbkbuf         : STD_LOGIC;
   SIGNAL div5buf           : STD_LOGIC;
   SIGNAL rst_nbuf          : STD_LOGIC;
   SIGNAL rst_pdb           : STD_LOGIC;
   SIGNAL sel               : STD_LOGIC;
   SIGNAL pe_pre            : STD_LOGIC;
   SIGNAL pe                : STD_LOGIC;
   SIGNAL pe_2t             : STD_LOGIC;
   SIGNAL lben              : STD_LOGIC;
   SIGNAL a                 : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL b                 : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL d10m              : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL lfclk_div2        : STD_LOGIC;
   SIGNAL nc0               : STD_LOGIC;
   SIGNAL nc1               : STD_LOGIC;
   SIGNAL nc3               : STD_LOGIC;
   SIGNAL nc2               : STD_LOGIC;
   
   SIGNAL d10a              : STD_LOGIC_VECTOR(9 DOWNTO 0) := "0000000000" ;
   SIGNAL d10b              : STD_LOGIC_VECTOR(9 DOWNTO 0) := "0000000000" ;
   SIGNAL d10               : STD_LOGIC_VECTOR(9 DOWNTO 0) := "0000000000" ;
   SIGNAL data_mux5t1_sync1 : STD_LOGIC_VECTOR(9 DOWNTO 0) := "0000000000" ;
   SIGNAL do_mux5t1_sync2   : STD_LOGIC_VECTOR(4 DOWNTO 0) := "00000" ;
   SIGNAL de_mux5t1_sync2   : STD_LOGIC_VECTOR(4 DOWNTO 0) := "00000" ;
   SIGNAL cp_even           : STD_LOGIC := '0' ;
   SIGNAL c0_even           : STD_LOGIC := '0' ;
   SIGNAL c1_even           : STD_LOGIC := '0' ;
   SIGNAL c2_even           : STD_LOGIC := '0' ;
   SIGNAL c3_even           : STD_LOGIC := '0' ;
   SIGNAL c4_even           : STD_LOGIC := '0' ;
   SIGNAL cp_odd            : STD_LOGIC := '0' ;
   SIGNAL c0_odd            : STD_LOGIC := '0' ;
   SIGNAL c1_odd            : STD_LOGIC := '0' ;
   SIGNAL c2_odd            : STD_LOGIC := '0' ;
   SIGNAL c3_odd            : STD_LOGIC := '0' ;
   SIGNAL c4_odd            : STD_LOGIC := '0' ;
   SIGNAL out_o             : STD_LOGIC := '0' ;
   SIGNAL out_e             : STD_LOGIC := '0' ;
   SIGNAL vop_pre_reg       : STD_LOGIC := '0' ;
   SIGNAL von_pre_reg       : STD_LOGIC := '1' ;
   SIGNAL vop_reg           : STD_LOGIC := '0' ;
   SIGNAL von_reg           : STD_LOGIC := '1' ;
   SIGNAL vop_op1_reg       : STD_LOGIC := '0' ;
   SIGNAL von_op1_reg       : STD_LOGIC := '1' ;
   SIGNAL oo1               : STD_LOGIC := '0' ;
   SIGNAL oo2               : STD_LOGIC := '0' ;
   SIGNAL oo3               : STD_LOGIC := '0' ;
   SIGNAL oe1               : STD_LOGIC := '0' ;
   SIGNAL oe2               : STD_LOGIC := '0' ;
   SIGNAL oe3               : STD_LOGIC := '0' ;
   SIGNAL vop_op2_reg       : STD_LOGIC := '0' ;
   SIGNAL von_op2_reg       : STD_LOGIC := '1' ;
   SIGNAL out_lb_reg        : STD_LOGIC := '0' ;
   SIGNAL outb_lb_reg       : STD_LOGIC := '1' ;
   SIGNAL clk_divtx_wire    : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL pre_en_out_xhdl0  : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   pre_en_out <= pre_en_out_xhdl0;
   
   pre_en_out_xhdl0 <= reduction_nor(pre_em);
   pre_en_pretap <= reduction_or(pre_em_pretap);
   pre_en_2t <= reduction_or(pre_em_2t);
   s_lpbkbuf <= pdb AND s_lpbk;
   div5buf <= pdb AND div5;
   rst_nbuf <= pdb AND rst_n;
   clk_divtx <= clk_divtx_wire;
   -- * * c_ser_20to10 -- x20to10 instance * *
   a <= data(9 DOWNTO 0);
   b <= data(19 DOWNTO 10);
   sel <= NOT(clk_divtx_wire) AND div2;
   rst_pdb <= rst_n AND div2;
   
   -- xdivby2
   
   xdiv2_2 : stratixiv_hssi_pma_c_divby2q
      PORT MAP (
         clk       => lfclkp,
         clkb      => lfclkn,
         clk0      => nc0,
         clk90     => nc1,
         vcce_la   => '1',
         vssexqyx  => '0',
         clk180    => lfclk_div2,
         clk270    => nc2,
         rst_n     => rst_nbuf
      );
   
   -- c_mux2to1_4xd - xi37 // clk_divtx is same as halfclk_p
   clk_divtx_wire <= lfclkp WHEN ((pclksel = '0') AND (div2 = '0')) ELSE
                     lfclk_div2 WHEN ((pclksel = '0') AND (div2 = '1')) ELSE
                     pclk_in WHEN ((pclksel = '1') AND (div2 = '0' OR div2 = '1')) ELSE
                     'X';
   
   -- Pipe #1
   PROCESS (clk_divtx_wire, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         d10a <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
         d10b <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (clk_divtx_wire'EVENT AND clk_divtx_wire = '1') THEN
         d10a <=  TRANSPORT a AFTER (PARAM_DELAY)*1 ps;
         d10b <=  TRANSPORT b AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   d10m <= d10b WHEN (sel = '1') ELSE
           d10a;
   
   -- Pipe #2
   -- Pipe #1 - synchronize data to lfclkp negedge
   PROCESS (lfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         d10 <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (lfclkp'EVENT AND lfclkp = '1') THEN
         d10 <=  TRANSPORT d10m AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   -- Pipe #2 - Synchronize 0,2,4 and 1,3 to CLK and CLKB ; 6,8 and 5,7,9 to CLK and CLKB
   PROCESS (lfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         data_mux5t1_sync1 <=  TRANSPORT "0000000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (lfclkn'EVENT AND lfclkn = '1') THEN
         data_mux5t1_sync1 <=  TRANSPORT d10 AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (lfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         de_mux5t1_sync2(2 DOWNTO 0) <=  TRANSPORT "000" AFTER (PARAM_DELAY)*1 ps;
         do_mux5t1_sync2(1 DOWNTO 0) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (lfclkp'EVENT AND lfclkp = '1') THEN
         de_mux5t1_sync2(2 DOWNTO 0) <=  TRANSPORT (data_mux5t1_sync1(4) & data_mux5t1_sync1(2) & data_mux5t1_sync1(0)) AFTER (PARAM_DELAY)*1 ps;
         do_mux5t1_sync2(1 DOWNTO 0) <=  TRANSPORT (data_mux5t1_sync1(3) & data_mux5t1_sync1(1)) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (lfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         de_mux5t1_sync2(4 DOWNTO 3) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
         do_mux5t1_sync2(4 DOWNTO 2) <=  TRANSPORT "000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (lfclkn'EVENT AND lfclkn = '1') THEN
         de_mux5t1_sync2(4 DOWNTO 3) <=  TRANSPORT (data_mux5t1_sync1(8) & data_mux5t1_sync1(6)) AFTER (PARAM_DELAY)*1 ps;
         do_mux5t1_sync2(4 DOWNTO 2) <=  TRANSPORT (data_mux5t1_sync1(9) & data_mux5t1_sync1(7) & data_mux5t1_sync1(5)) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   -- Pulse generation for odd and even - CPULSE, CP, C0, ..., C4
   --   always @ ( posedge hfclkp or negedge rst_nbuf ) // Mux Even 
   --     if ( hfclkp == 1'b1 ) 
   --       cp_even <= #(PARAM_DELAY) cpulse;
   --     else 
   --       cp_even <= #(PARAM_DELAY) 1'b0;
   
   PROCESS (hfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         c4_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c3_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c2_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c1_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c0_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkn'EVENT AND hfclkn = '1') THEN
         c0_even <=  TRANSPORT cpulse AFTER (PARAM_DELAY)*1 ps;
         c1_even <=  TRANSPORT c0_even AFTER (PARAM_DELAY)*1 ps;
         c2_even <=  TRANSPORT c1_even AFTER (PARAM_DELAY)*1 ps;
         c3_even <=  TRANSPORT c2_even AFTER (PARAM_DELAY)*1 ps;
         IF (div5buf = '1') THEN
            c4_even <=  TRANSPORT c3_even AFTER (PARAM_DELAY)*1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkn, rst_nbuf)		-- Mux Odd
   BEGIN
      IF (rst_nbuf = '0') THEN
         cp_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkn'EVENT AND hfclkn = '1') THEN
         cp_odd <=  TRANSPORT cpulse AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         c4_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c3_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c2_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c1_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c0_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkp'EVENT AND hfclkp = '1') THEN
         c0_odd <=  TRANSPORT cp_odd AFTER (PARAM_DELAY)*1 ps;
         c1_odd <=  TRANSPORT c0_odd AFTER (PARAM_DELAY)*1 ps;
         c2_odd <=  TRANSPORT c1_odd AFTER (PARAM_DELAY)*1 ps;
         c3_odd <=  TRANSPORT c2_odd AFTER (PARAM_DELAY)*1 ps;
         IF (div5buf = '1') THEN
            c4_odd <=  TRANSPORT c3_odd AFTER (PARAM_DELAY)*1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   
   -- Mux2to1 Even outputs
   PROCESS (c0_even,c1_even,c2_even,c3_even,c4_even)
   BEGIN
      IF (c0_even = '1' AND c0_even'EVENT) THEN
         out_e <=  TRANSPORT de_mux5t1_sync2(0) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c1_even = '1'AND c1_even'EVENT) THEN
         out_e <=  TRANSPORT de_mux5t1_sync2(1) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c2_even = '1'AND c2_even'EVENT) THEN
         out_e <=  TRANSPORT de_mux5t1_sync2(2) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c3_even = '1'AND c3_even'EVENT) THEN
         out_e <=  TRANSPORT de_mux5t1_sync2(3) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c4_even = '1'AND c4_even'EVENT) THEN
         out_e <=  TRANSPORT de_mux5t1_sync2(4) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   -- Mux2to1 Odd outputs
   PROCESS (c0_odd,c1_odd,c2_odd,c3_odd,c4_odd)
   BEGIN
      IF (c0_odd = '1'AND c0_odd'EVENT) THEN
         out_o <=  TRANSPORT do_mux5t1_sync2(0) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c1_odd = '1'AND c1_odd'EVENT) THEN
         out_o <=  TRANSPORT do_mux5t1_sync2(1) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c2_odd = '1'AND c2_odd'EVENT) THEN
         out_o <=  TRANSPORT do_mux5t1_sync2(2) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c3_odd = '1'AND c3_odd'EVENT) THEN
         out_o <=  TRANSPORT do_mux5t1_sync2(3) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF (c4_odd = '1'AND c4_odd'EVENT) THEN
         out_o <=  TRANSPORT do_mux5t1_sync2(4) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   -- * * c_ser_mux2to1 -- xmux2to1 instance * *
   pe_pre <= pre_en_pretap AND rst_nbuf AND pdb;
   pe <= pre_en_out_xhdl0 AND rst_nbuf AND pdb;
   pe_2t <= pre_en_2t AND rst_nbuf AND pdb;
   
   vop_pre <= vop_pre_reg WHEN (pe_pre = '1') ELSE
              '1';
   von_pre <= von_pre_reg WHEN (pe_pre = '1') ELSE
              '1';
   vop <= vop_reg WHEN (pdb = '1') ELSE
          '1';
   von <= von_reg WHEN (pdb = '1') ELSE
          '1';
   vop_op1 <= vop_op1_reg WHEN (pe = '1') ELSE
              '1';
   von_op1 <= von_op1_reg WHEN (pe = '1') ELSE
              '1';
   vop_op2 <= vop_op2_reg WHEN (pe_2t = '1') ELSE
              '1';
   von_op2 <= von_op2_reg WHEN (pe_2t = '1') ELSE
              '1';
   
   -- FFs for OO & OE 1, 2 and 3 Generation
   PROCESS (hfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         oe3 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         oo2 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         oe1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkn'EVENT AND hfclkn = '1') THEN
         oe1 <=  TRANSPORT out_e AFTER (PARAM_DELAY)*1 ps;
         oo2 <=  TRANSPORT oo1 AFTER (PARAM_DELAY)*1 ps;
         oe3 <=  TRANSPORT oe2 AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         oo3 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         oe2 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         oo1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkp'EVENT AND hfclkp = '1') THEN
         oo1 <=  TRANSPORT out_o AFTER (PARAM_DELAY)*1 ps;
         oe2 <=  TRANSPORT oe1 AFTER (PARAM_DELAY)*1 ps;
         oo3 <=  TRANSPORT oo2 AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   -- FFs for VOP/N_PRE, VOP/N, VOP/N_OP1 and VOP/N_OP2 Outputs Generation 
   PROCESS (hfclkp,hfclkn)
   BEGIN
      IF ((hfclkp = '1' AND hfclkp'EVENT)AND pe_pre = '1') THEN
         vop_pre_reg <=  TRANSPORT out_o AFTER (PARAM_DELAY)*1 ps;
         von_pre_reg <=  TRANSPORT NOT(out_o) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF ((hfclkn = '1' AND hfclkn'EVENT)AND pe_pre = '1') THEN
         vop_pre_reg <=  TRANSPORT out_e AFTER (PARAM_DELAY)*1 ps;
         von_pre_reg <=  TRANSPORT NOT(out_e) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp,hfclkn)
   BEGIN
      IF ((hfclkp = '1' AND hfclkp'EVENT) AND pdb = '1') THEN
         vop_reg <=  TRANSPORT oe1 AFTER (PARAM_DELAY)*1 ps;
         von_reg <=  TRANSPORT NOT(oe1) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF ((hfclkn = '1' AND hfclkn'EVENT) AND pdb = '1') THEN
         vop_reg <=  TRANSPORT oo1 AFTER (PARAM_DELAY)*1 ps;
         von_reg <=  TRANSPORT NOT(oo1) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   PROCESS (hfclkp,hfclkn)
   BEGIN
      IF ((hfclkp = '1' AND hfclkp'EVENT) AND pe = '1') THEN
         vop_op1_reg <=  TRANSPORT oo2 AFTER (PARAM_DELAY)*1 ps;
         von_op1_reg <=  TRANSPORT NOT(oo2) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF ((hfclkn = '1' AND hfclkn'EVENT) AND pe = '1') THEN
         vop_op1_reg <=  TRANSPORT oe2 AFTER (PARAM_DELAY)*1 ps;
         von_op1_reg <=  TRANSPORT NOT(oe2) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp,hfclkn)
   BEGIN
      IF ((hfclkp = '1' AND hfclkp'EVENT) AND pe_2t = '1') THEN
         vop_op2_reg <=  TRANSPORT oe3 AFTER (PARAM_DELAY)*1 ps;
         von_op2_reg <=  TRANSPORT NOT(oe3) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF ((hfclkn = '1' AND hfclkn'EVENT) AND pe_2t = '1') THEN
         vop_op2_reg <=  TRANSPORT oo3 AFTER (PARAM_DELAY)*1 ps;
         von_op2_reg <=  TRANSPORT NOT(oo3) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   -- * * c_ser_mux2to1_lb -- xmux2to1_lb instance * *
   lben <= pdb AND s_lpbkbuf;
   lbvop <= out_lb_reg WHEN (lben = '1') ELSE
            '1';
   lbvon <= outb_lb_reg WHEN (lben = '1') ELSE
            '1';
   
   PROCESS (hfclkn,hfclkp)
   BEGIN
      IF ((hfclkn = '1' AND hfclkn'EVENT) AND lben = '1') THEN
         out_lb_reg <=  TRANSPORT out_e AFTER (PARAM_DELAY)*1 ps;
         outb_lb_reg <=  TRANSPORT NOT(out_e) AFTER (PARAM_DELAY)*1 ps;
      END IF;
      IF ((hfclkp = '1' AND hfclkp'EVENT) AND lben = '1') THEN
         out_lb_reg <=  TRANSPORT out_o AFTER (PARAM_DELAY)*1 ps;
         outb_lb_reg <=  TRANSPORT NOT(out_o) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_sdl_en_2x IS
   PORT (
      
      clk       : IN STD_LOGIC;
      d         : IN STD_LOGIC;
      db        : IN STD_LOGIC;
      en        : IN STD_LOGIC;
      
      vhdl_out  : OUT STD_LOGIC;
      outb      : OUT STD_LOGIC;
      vcce_la   : IN STD_LOGIC;
      vssex     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_sdl_en_2x;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_sdl_en_2x IS
BEGIN
   
   PROCESS (en, clk)
   BEGIN
      IF ((NOT(en)) = '1') THEN
         vhdl_out <= '0';
         outb <= '1';
      ELSIF (clk'EVENT AND clk = '1') THEN
         vhdl_out <= d;
         outb <= db;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rcv_detect_div_by_2 IS		-- synthesis syn_black_box
   PORT (
      CLK      : IN STD_LOGIC;
      RESET_N  : IN STD_LOGIC;
      CLKOUT   : OUT STD_LOGIC
   );
END stratixiv_hssi_pma_c_rcv_detect_div_by_2;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rcv_detect_div_by_2 IS
   SIGNAL NEXT_VAL     : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL CLKOUT_xhdl0 : STD_LOGIC := '0';
BEGIN
   -- Drive referenced outputs
   CLKOUT <= CLKOUT_xhdl0;
   
   -- state definition
   PROCESS (CLK, RESET_N)
   BEGIN
      IF ((NOT(RESET_N)) = '1') THEN
         CLKOUT_xhdl0 <= '0';
      ELSIF (CLK'EVENT AND CLK = '1') THEN
         CLKOUT_xhdl0 <= NEXT_VAL;
      END IF;
   END PROCESS;
   
   NEXT_VAL <= NOT(CLKOUT_xhdl0);
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rcv_detect_clk_gen IS
   PORT (
      CLK      : IN STD_LOGIC;
      RESET_N  : IN STD_LOGIC;
      CLKOUT   : OUT STD_LOGIC
   );
END stratixiv_hssi_pma_c_rcv_detect_clk_gen;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rcv_detect_clk_gen IS
   COMPONENT stratixiv_hssi_pma_c_rcv_detect_div_by_2
      PORT (
         CLK      : IN STD_LOGIC;
         RESET_N  : IN STD_LOGIC;
         CLKOUT   : OUT STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL CLK8M        : STD_LOGIC;
   SIGNAL CLK4M        : STD_LOGIC;
   SIGNAL CLK2M        : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL CLKOUT_xhdl0 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   CLKOUT <= CLKOUT_xhdl0;
   
   DIV_1 : stratixiv_hssi_pma_c_rcv_detect_div_by_2
      PORT MAP (
         CLK      => CLK,
         RESET_N  => RESET_N,
         CLKOUT   => CLK8M
      );
   
   DIV_2 : stratixiv_hssi_pma_c_rcv_detect_div_by_2
      PORT MAP (
         CLK      => CLK8M,
         RESET_N  => RESET_N,
         CLKOUT   => CLK4M
      );
   
   DIV_3 : stratixiv_hssi_pma_c_rcv_detect_div_by_2
      PORT MAP (
         CLK      => CLK4M,
         RESET_N  => RESET_N,
         CLKOUT   => CLK2M
      );
   
   DIV_4 : stratixiv_hssi_pma_c_rcv_detect_div_by_2
      PORT MAP (
         CLK      => CLK2M,
         RESET_N  => RESET_N,
         CLKOUT   => CLKOUT_xhdl0
      );
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rcv_detect_sync IS		-- synthesis syn_black_box
   PORT (
      
      CLK          : IN STD_LOGIC;
      RESET_N      : IN STD_LOGIC;
      RCV_DET      : IN STD_LOGIC;
      RCV_DET_OUT  : OUT STD_LOGIC
   );
END stratixiv_hssi_pma_c_rcv_detect_sync;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rcv_detect_sync IS
   SIGNAL RCV_DET_MID : STD_LOGIC;
BEGIN
   
   PROCESS (CLK, RESET_N)
   BEGIN
      IF ((NOT(RESET_N)) = '1') THEN
         RCV_DET_OUT <= '0';
         RCV_DET_MID <= '0';
      ELSIF (CLK'EVENT AND CLK = '1') THEN
         RCV_DET_OUT <= RCV_DET_MID;
         RCV_DET_MID <= RCV_DET;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rcv_detect_fsm IS		-- synthesis syn_black_box
   GENERIC (
      
      RESET         : INTEGER := 0;
      WAKE          : INTEGER := 1;
      STATE_1       : INTEGER := 3;
      STATE_2       : INTEGER := 5;
      HOLD          : INTEGER := 4
   );
   PORT (
      CLK           : IN STD_LOGIC;
      RESET_N       : IN STD_LOGIC;
      COM_PASS      : IN STD_LOGIC;
      PROBE_PASS    : IN STD_LOGIC;
      
      DET_ON        : OUT STD_LOGIC;
      DETECT_VALID  : OUT STD_LOGIC;
      RCV_FOUND     : OUT STD_LOGIC;
      TX_DET_RX     : IN STD_LOGIC;
      RX_P          : IN STD_LOGIC;
      RX_N          : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_rcv_detect_fsm;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rcv_detect_fsm IS
   SIGNAL STATE            : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL NEXTSTATE        : STD_LOGIC_VECTOR(2 DOWNTO 0) := int2bin(WAKE, 3);
   SIGNAL NEXT_RCV_FOUND   : STD_LOGIC := '0';
   
   SIGNAL FAKE_RCV_PRESENT : STD_LOGIC := '1' ;
   
   SIGNAL RXPN_NOT_Z       : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL RCV_FOUND_xhdl0  : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   RCV_FOUND <= RCV_FOUND_xhdl0;
   
   -- state definition
   
   -- manju : FAKE_RCV_PRESENT will always be '1' as no Denali models.
   --   assign    RXPN_NOT_Z = ( (RX_P == 1'b1) && (RX_N == 1'b1) || (RX_P == 1'b0) && (RX_N == 1'b0) ) ? 1'b1 : 1'b0; 
   
   
   --   always @ ( TX_DET_RX or RXPN_NOT_Z ) 
   --     if ( TX_DET_RX == 1'b1 && RXPN_NOT_Z == 1'b1 )
   --       FAKE_RCV_PRESENT <= 1'b1;
   --     else if ( TX_DET_RX == 1'b0 )
   --       FAKE_RCV_PRESENT <= 1'b0;
   
   -- State logic and FSM
   PROCESS (CLK, RESET_N)
   BEGIN
      IF ((NOT(RESET_N)) = '1') THEN
         STATE <= int2bin(RESET, 3);
      ELSIF (CLK'EVENT AND CLK = '1') THEN
         STATE <= NEXTSTATE;
      END IF;
   END PROCESS;
   
   PROCESS (STATE, COM_PASS)
   BEGIN
      CASE STATE IS
         WHEN "000" =>
            NEXTSTATE <= int2bin(WAKE, 3);
           WHEN "001" =>
            IF (COM_PASS = '1') THEN
               NEXTSTATE <= int2bin(STATE_1, 3);
            ELSE
               NEXTSTATE <= int2bin(WAKE, 3);
            END IF;
          WHEN "011" =>
            NEXTSTATE <= int2bin(STATE_2, 3);
          WHEN "101"=>
            NEXTSTATE <= int2bin(HOLD, 3);
           WHEN "100" =>
            NEXTSTATE <= int2bin(HOLD, 3);
         WHEN OTHERS =>		-- case(state)
            NEXTSTATE <= int2bin(RESET, 3);
      END CASE;
   END PROCESS;
   
   -- Output logic
   PROCESS (CLK, RESET_N)
   BEGIN
      IF ((NOT(RESET_N)) = '1') THEN
         RCV_FOUND_xhdl0 <= '0';
      ELSIF (CLK'EVENT AND CLK = '1') THEN
         RCV_FOUND_xhdl0 <= NEXT_RCV_FOUND;
      END IF;
   END PROCESS;
   
   PROCESS (NEXTSTATE, PROBE_PASS, FAKE_RCV_PRESENT)
   BEGIN
      IF ((NEXTSTATE = int2bin(STATE_2, 3)) AND ((NOT(PROBE_PASS))) = '1' AND FAKE_RCV_PRESENT = '1') THEN		-- probe pass goes up slow -> there is rx 
         NEXT_RCV_FOUND <= '1';
      ELSIF ((NEXTSTATE = int2bin(HOLD, 3)) AND FAKE_RCV_PRESENT = '1') THEN
         NEXT_RCV_FOUND <= RCV_FOUND_xhdl0;		-- probe pass goes up fast -> no rx
      ELSE
         NEXT_RCV_FOUND <= '0';
      END IF;
   END PROCESS;
   
   -- there is no rcv_det_syn
   PROCESS (STATE)
   BEGIN
      IF (STATE = int2bin(RESET, 3)) THEN
         DET_ON <= '0';
      ELSE
         DET_ON <= '1';
      END IF;
   END PROCESS;
   
   PROCESS (STATE)
   BEGIN
      IF (STATE = int2bin(HOLD, 3)) THEN
         DETECT_VALID <= '1';
      ELSE
         DETECT_VALID <= '0';
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rcv_detect_control IS
   PORT (
      CLK           : IN STD_LOGIC;
      RCV_DET_EN    : IN STD_LOGIC;
      RCV_DET_PDB   : IN STD_LOGIC;
      COM_PASS      : IN STD_LOGIC;
      PROBE_PASS    : IN STD_LOGIC;
      DET_ON        : OUT STD_LOGIC;
      DETECT_VALID  : OUT STD_LOGIC;
      RCV_FOUND     : OUT STD_LOGIC;
      RX_P          : IN STD_LOGIC;
      RX_N          : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_rcv_detect_control;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rcv_detect_control IS
   COMPONENT stratixiv_hssi_pma_c_rcv_detect_fsm
      GENERIC (
         RESET         : INTEGER := 0;
         WAKE          : INTEGER := 1;
         STATE_1       : INTEGER := 3;
         STATE_2       : INTEGER := 5;
         HOLD          : INTEGER := 4
      );
      PORT (
         CLK           : IN STD_LOGIC;
         RESET_N       : IN STD_LOGIC;
         COM_PASS      : IN STD_LOGIC;
         PROBE_PASS    : IN STD_LOGIC;
         DET_ON        : OUT STD_LOGIC;
         DETECT_VALID  : OUT STD_LOGIC;
         RCV_FOUND     : OUT STD_LOGIC;
         TX_DET_RX     : IN STD_LOGIC;
         RX_P          : IN STD_LOGIC;
         RX_N          : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_rcv_detect_sync
      PORT (
         CLK           : IN STD_LOGIC;
         RESET_N       : IN STD_LOGIC;
         RCV_DET       : IN STD_LOGIC;
         RCV_DET_OUT   : OUT STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL RCV_DET_SYN        : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL DET_ON_xhdl1       : STD_LOGIC;
   SIGNAL DETECT_VALID_xhdl0 : STD_LOGIC;
   SIGNAL RCV_FOUND_xhdl2    : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   DET_ON <= DET_ON_xhdl1;
   DETECT_VALID <= DETECT_VALID_xhdl0;
   RCV_FOUND <= RCV_FOUND_xhdl2;
   
   
   XRCV_DET_SYNC : stratixiv_hssi_pma_c_rcv_detect_sync
      PORT MAP (
         CLK          => CLK,
         RESET_N      => RCV_DET_PDB,
         RCV_DET      => RCV_DET_EN,
         RCV_DET_OUT  => RCV_DET_SYN
      );
   
   XRCV_DET_FSM : stratixiv_hssi_pma_c_rcv_detect_fsm
      PORT MAP (
         CLK           => CLK,
         RESET_N       => RCV_DET_SYN,
         COM_PASS      => COM_PASS,
         PROBE_PASS    => PROBE_PASS,
         DET_ON        => DET_ON_xhdl1,
         DETECT_VALID  => DETECT_VALID_xhdl0,
         RCV_FOUND     => RCV_FOUND_xhdl2,
         TX_DET_RX     => RCV_DET_EN,
         RX_P          => RX_P,
         RX_N          => RX_N
      );
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rcv_det_digital IS
   PORT (
      
      OSCCLK        : IN STD_LOGIC;
      RCV_DET_PDB   : IN STD_LOGIC;
      RCV_DET_EN    : IN STD_LOGIC;
      COM_PASS      : IN STD_LOGIC;
      PROBE_PASS    : IN STD_LOGIC;
      DET_ON        : OUT STD_LOGIC;
      DETECT_VALID  : OUT STD_LOGIC;
      RCV_FOUND     : OUT STD_LOGIC;
      RX_P          : IN STD_LOGIC;
      RX_N          : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_rcv_det_digital;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rcv_det_digital IS
   COMPONENT stratixiv_hssi_pma_c_rcv_detect_control
      PORT (
         CLK           : IN STD_LOGIC;
         RCV_DET_EN    : IN STD_LOGIC;
         RCV_DET_PDB   : IN STD_LOGIC;
         COM_PASS      : IN STD_LOGIC;
         PROBE_PASS    : IN STD_LOGIC;
         DET_ON        : OUT STD_LOGIC;
         DETECT_VALID  : OUT STD_LOGIC;
         RCV_FOUND     : OUT STD_LOGIC;
         RX_P          : IN STD_LOGIC;
         RX_N          : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_rcv_detect_clk_gen
      PORT (
         CLK           : IN STD_LOGIC;
         RESET_N       : IN STD_LOGIC;
         CLKOUT        : OUT STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL CLK                : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL DET_ON_xhdl1       : STD_LOGIC;
   SIGNAL DETECT_VALID_xhdl0 : STD_LOGIC;
   SIGNAL RCV_FOUND_xhdl2    : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   DET_ON <= DET_ON_xhdl1;
   DETECT_VALID <= DETECT_VALID_xhdl0;
   RCV_FOUND <= RCV_FOUND_xhdl2;
   
   XCLK_GEN : stratixiv_hssi_pma_c_rcv_detect_clk_gen
      PORT MAP (
         CLK      => OSCCLK,
         RESET_N  => RCV_DET_PDB,
         CLKOUT   => CLK
      );
   
   XRCV_DET_CTRL : stratixiv_hssi_pma_c_rcv_detect_control
      PORT MAP (
         CLK           => CLK,
         RCV_DET_EN    => RCV_DET_EN,
         RCV_DET_PDB   => RCV_DET_PDB,
         COM_PASS      => COM_PASS,
         PROBE_PASS    => PROBE_PASS,
         DET_ON        => DET_ON_xhdl1,
         DETECT_VALID  => DETECT_VALID_xhdl0,
         RCV_FOUND     => RCV_FOUND_xhdl2,
         RX_P          => RX_P,
         RX_N          => RX_N
      );
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_rcv_detect IS
   GENERIC (
      RX_EXIST       : INTEGER := 1
   );
   PORT (
      com_pass       : OUT STD_LOGIC;
      detect_on      : OUT STD_LOGIC;
      fixed_clk_out  : OUT STD_LOGIC;
      probe_pass     : OUT STD_LOGIC;
      rcv_det_pdb    : IN STD_LOGIC;
      rdet           : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rx_det_clk     : IN STD_LOGIC;
      rx_det_valid   : OUT STD_LOGIC;
      rx_found       : OUT STD_LOGIC;
      sel_150r       : OUT STD_LOGIC;
      tx_det_rx      : IN STD_LOGIC;
      rx_n           : IN STD_LOGIC;
      rx_p           : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_rcv_detect;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_rcv_detect IS
   COMPONENT stratixiv_hssi_pma_c_rcv_det_digital
      PORT (
         OSCCLK         : IN STD_LOGIC;
         RCV_DET_PDB    : IN STD_LOGIC;
         RCV_DET_EN     : IN STD_LOGIC;
         COM_PASS       : IN STD_LOGIC;
         PROBE_PASS     : IN STD_LOGIC;
         DET_ON         : OUT STD_LOGIC;
         DETECT_VALID   : OUT STD_LOGIC;
         RCV_FOUND      : OUT STD_LOGIC;
         RX_P           : IN STD_LOGIC;
         RX_N           : IN STD_LOGIC
      );
   END COMPONENT;
   
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL com_pass_xhdl0     : STD_LOGIC;
   SIGNAL detect_on_xhdl1    : STD_LOGIC;
   SIGNAL probe_pass_xhdl2   : STD_LOGIC;
   SIGNAL rx_det_valid_xhdl3 : STD_LOGIC;
   SIGNAL rx_found_xhdl4     : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   com_pass <= com_pass_xhdl0;
   detect_on <= detect_on_xhdl1;
   probe_pass <= probe_pass_xhdl2;
   rx_det_valid <= rx_det_valid_xhdl3;
   rx_found <= rx_found_xhdl4;
   
   fixed_clk_out <= rx_det_clk;
   sel_150r <= '0';
   
   com_pass_xhdl0 <= transport detect_on_xhdl1 after 100 ns;
   probe_pass_xhdl2 <= NOT(int2bit(RX_EXIST));
   
   -- * * Analog portion not modeled * *
   
   XRCV_DET_DIGITAL : stratixiv_hssi_pma_c_rcv_det_digital
      PORT MAP (
         OSCCLK        => rx_det_clk,
         RCV_DET_PDB   => rcv_det_pdb,
         RCV_DET_EN    => tx_det_rx,
         COM_PASS      => com_pass_xhdl0,
         PROBE_PASS    => probe_pass_xhdl2,
         DET_ON        => detect_on_xhdl1,
         DETECT_VALID  => rx_det_valid_xhdl3,
         RCV_FOUND     => rx_found_xhdl4,
         RX_N          => rx_n,
         RX_P          => rx_p
      );
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;

   
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_tx IS
   PORT (
      
      atb0             : INOUT STD_LOGIC;
      atb1             : INOUT STD_LOGIC;
      bsmode           : IN STD_LOGIC;
      bstxn_in         : IN STD_LOGIC;
      bstxp_in         : IN STD_LOGIC;
      cgb_vccelxqyx    : IN STD_LOGIC;
      cgb_vssexqyx     : IN STD_LOGIC;
      
      com_pass         : OUT STD_LOGIC;
      detect_on        : OUT STD_LOGIC;
      fixed_clk_out    : OUT STD_LOGIC;
      ib50uc_rcvdt     : INOUT STD_LOGIC;
      ib50uc_vcm       : INOUT STD_LOGIC;
      ib50ut_vcm       : INOUT STD_LOGIC;
      ib100uc          : INOUT STD_LOGIC;
      lst              : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      pdb              : IN STD_LOGIC;
      probe_pass       : OUT STD_LOGIC;
      r_dft_sel        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      r_dis_idlegate   : IN STD_LOGIC;
      r_highv          : IN STD_LOGIC;
      r_lowv           : IN STD_LOGIC;
      r_rx_det         : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      r_slew           : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rlpbkn           : IN STD_LOGIC;
      rlpbkn_em        : IN STD_LOGIC;
      rlpbkp           : IN STD_LOGIC;
      rlpbkp_em        : IN STD_LOGIC;
      rpre_em_1t       : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      rpre_em_2t       : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rpre_em_pt       : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rsig_inv_2t      : IN STD_LOGIC;
      rsig_inv_ptap    : IN STD_LOGIC;
      rterm_sel        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rtx_rlpbk        : IN STD_LOGIC;
      rtx_vtt          : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rvod_sel         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rx_det_clk       : IN STD_LOGIC;
      rx_det_pdb       : IN STD_LOGIC;
      rx_detect_valid  : OUT STD_LOGIC;
      rx_found         : OUT STD_LOGIC;
      sel_150r         : OUT STD_LOGIC;
      tx50             : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      tx_det_rx        : IN STD_LOGIC;
      tx_dftout        : OUT STD_LOGIC_VECTOR(6 DOWNTO 1);
      tx_elec_idl      : IN STD_LOGIC;
      vccehtxqyx       : IN STD_LOGIC;
      vccehxqyx        : IN STD_LOGIC;
      vccesdh_la       : IN STD_LOGIC;
      vccesdp_la       : IN STD_LOGIC;
      vccetxqyx        : IN STD_LOGIC;
      vin              : IN STD_LOGIC;
      vin_po1          : IN STD_LOGIC;
      vin_po2          : IN STD_LOGIC;
      vin_pre          : IN STD_LOGIC;
      vip              : IN STD_LOGIC;
      vip_po1          : IN STD_LOGIC;
      vip_po2          : IN STD_LOGIC;
      vip_pre          : IN STD_LOGIC;
      von              : INOUT STD_LOGIC;
      vop              : INOUT STD_LOGIC;
      vssexqyx         : IN STD_LOGIC;
      rx_p             : IN STD_LOGIC;
      rx_n             : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_tx;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_tx IS
   COMPONENT stratixiv_hssi_pma_c_controller_4t16
      PORT (
         atben            : OUT STD_LOGIC;
         ct0              : IN STD_LOGIC;
         ct1              : IN STD_LOGIC;
         ct2              : IN STD_LOGIC;
         ct3              : IN STD_LOGIC;
         tmsb1            : OUT STD_LOGIC;
         tmsb2            : OUT STD_LOGIC;
         tmsb3            : OUT STD_LOGIC;
         tmsb4            : OUT STD_LOGIC;
         tmsb5            : OUT STD_LOGIC;
         tmsb6            : OUT STD_LOGIC;
         tmsb7            : OUT STD_LOGIC;
         tmsb8            : OUT STD_LOGIC;
         tmsb9            : OUT STD_LOGIC;
         tmsb10           : OUT STD_LOGIC;
         tmsb11           : OUT STD_LOGIC;
         tmsb12           : OUT STD_LOGIC;
         tmsb13           : OUT STD_LOGIC;
         tmsb14           : OUT STD_LOGIC;
         tmsb15           : OUT STD_LOGIC;
         vcce_la          : IN STD_LOGIC;
         vssex            : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_rcv_detect
      GENERIC (
         RX_EXIST         : INTEGER := 1
      );
      PORT (
         com_pass         : OUT STD_LOGIC;
         detect_on        : OUT STD_LOGIC;
         fixed_clk_out    : OUT STD_LOGIC;
         probe_pass       : OUT STD_LOGIC;
         rcv_det_pdb      : IN STD_LOGIC;
         rdet             : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rx_det_clk       : IN STD_LOGIC;
         rx_det_valid     : OUT STD_LOGIC;
         rx_found         : OUT STD_LOGIC;
         sel_150r         : OUT STD_LOGIC;
         tx_det_rx        : IN STD_LOGIC;
         rx_n             : IN STD_LOGIC;
         rx_p             : IN STD_LOGIC
      );
   END COMPONENT;
   
   
   SIGNAL atbsel                : STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL atbi_0                : STD_LOGIC;
   SIGNAL atbi_1                : STD_LOGIC;
   SIGNAL vtp_1po               : STD_LOGIC;		-- not driven for now
   SIGNAL vtn_1po               : STD_LOGIC;
   SIGNAL vbiasp_cs             : STD_LOGIC;
   SIGNAL vbiasn_cs             : STD_LOGIC;
   SIGNAL vbiasp                : STD_LOGIC;
   SIGNAL vbiasn                : STD_LOGIC;
   SIGNAL vtp                   : STD_LOGIC;
   SIGNAL vtn                   : STD_LOGIC;
   SIGNAL vodselb               : STD_LOGIC_VECTOR(6 DOWNTO 1);
   SIGNAL vodsel_pdrv           : STD_LOGIC_VECTOR(6 DOWNTO 1);
   SIGNAL atben                 : STD_LOGIC;
   SIGNAL pre_em_2po            : STD_LOGIC_VECTOR(5 DOWNTO 1);
   SIGNAL pre_em_pre            : STD_LOGIC_VECTOR(5 DOWNTO 1);
   SIGNAL pre_em_1po            : STD_LOGIC_VECTOR(6 DOWNTO 1);
   SIGNAL po1_en_pdrvb          : STD_LOGIC;
   SIGNAL pre_en_pos            : STD_LOGIC;
   SIGNAL pre_en_neg            : STD_LOGIC;
   SIGNAL po2_en_pos            : STD_LOGIC;
   SIGNAL po2_en_neg            : STD_LOGIC;
   SIGNAL outpos_p              : STD_LOGIC;
   SIGNAL outpos_n              : STD_LOGIC;
   SIGNAL outneg_p              : STD_LOGIC;
   SIGNAL outneg_n              : STD_LOGIC;
   SIGNAL vopos_pd              : STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL vopos_nd              : STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL voneg_pd              : STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL voneg_nd              : STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL txden                 : STD_LOGIC;
   SIGNAL rlpbk_en              : STD_LOGIC;
   SIGNAL po1_rlpbk_en          : STD_LOGIC;
   SIGNAL po1_en                : STD_LOGIC;
   SIGNAL po2_en                : STD_LOGIC;
   SIGNAL pre_en                : STD_LOGIC;
   SIGNAL prepb_em_pre          : STD_LOGIC;
   SIGNAL pd_idl                : STD_LOGIC;
   SIGNAL tx_p                  : STD_LOGIC;
   SIGNAL tx_n                  : STD_LOGIC;
   SIGNAL vccbn1g               : STD_LOGIC;
   SIGNAL threshold             : STD_LOGIC;
   
   SIGNAL prep                  : STD_LOGIC;
   SIGNAL pren                  : STD_LOGIC;
   SIGNAL po1p                  : STD_LOGIC;
   SIGNAL po1n                  : STD_LOGIC;
   SIGNAL po2p                  : STD_LOGIC;
   SIGNAL po2n                  : STD_LOGIC;
   SIGNAL mainp                 : STD_LOGIC;
   SIGNAL mainn                 : STD_LOGIC;
   SIGNAL dec2t4_en             : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL vodsel                : STD_LOGIC_VECTOR(6 DOWNTO 1);
   -- X-HDL generated signals

   SIGNAL xhdl7 : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL com_pass_xhdl0        : STD_LOGIC;
   SIGNAL detect_on_xhdl1       : STD_LOGIC;
   SIGNAL fixed_clk_out_xhdl2   : STD_LOGIC;
   SIGNAL probe_pass_xhdl3      : STD_LOGIC;
   SIGNAL rx_detect_valid_xhdl4 : STD_LOGIC;
   SIGNAL rx_found_xhdl5        : STD_LOGIC;
   SIGNAL sel_150r_xhdl6        : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   com_pass <= com_pass_xhdl0;
   detect_on <= detect_on_xhdl1;
   fixed_clk_out <= fixed_clk_out_xhdl2;
   probe_pass <= probe_pass_xhdl3;
   rx_detect_valid <= rx_detect_valid_xhdl4;
   rx_found <= rx_found_xhdl5;
   sel_150r <= sel_150r_xhdl6;
   
   -- ibias_ref & c_tx_vcm not modeled
   
   -- txgate_por
   atb0 <= atbi_0 WHEN (atben = '1') ELSE
           'Z';
   atb1 <= atbi_1 WHEN (atben = '1') ELSE
           'Z';
   
   xatb : stratixiv_hssi_pma_c_controller_4t16
      PORT MAP (
         atben    => atben,
         ct0      => lst(0),
         ct1      => lst(1),
         ct2      => lst(2),
         ct3      => lst(3),
         tmsb1    => atbsel(0),
         tmsb2    => atbsel(1),
         tmsb3    => atbsel(2),
         tmsb4    => atbsel(3),
         tmsb5    => atbsel(4),
         tmsb6    => atbsel(5),
         tmsb7    => atbsel(6),
         tmsb8    => atbsel(7),
         tmsb9    => atbsel(8),
         tmsb10   => atbsel(9),
         tmsb11   => atbsel(10),
         tmsb12   => atbsel(11),
         tmsb13   => atbsel(12),
         tmsb14   => atbsel(13),
         tmsb15   => atbsel(14),
         vcce_la  => '1',
         vssex    => '0'
      );
   
   -- * * C_TX_DRIVER * *
   
   -- txgate_por 
   atbi_0 <= vtp_1po WHEN ((atbsel(1)) = '1') ELSE
             'Z';
   atbi_0 <= vbiasp WHEN ((atbsel(0)) = '1') ELSE
             'Z';
   atbi_0 <= vbiasp_cs WHEN ((atbsel(2)) = '1') ELSE
             'Z';
   atbi_0 <= vtp WHEN ((atbsel(3)) = '1') ELSE
             'Z';
   atbi_1 <= vtn_1po WHEN ((atbsel(1)) = '1') ELSE
             'Z';
   atbi_1 <= vbiasn WHEN ((atbsel(0)) = '1') ELSE
             'Z';
   atbi_1 <= vbiasn_cs WHEN ((atbsel(2)) = '1') ELSE
             'Z';
   atbi_1 <= vtn WHEN ((atbsel(3)) = '1') ELSE
             'Z';
   
   -- -- c_tx_dec xtxdec --
   txden <= pdb AND NOT(tx_elec_idl) AND NOT(rtx_rlpbk);
   rlpbk_en <= pdb AND NOT(tx_elec_idl) AND rtx_rlpbk;
   po1_rlpbk_en <= reduction_or(rpre_em_1t) WHEN (rlpbk_en = '1') ELSE
                   '0';
   
   -- c_dec3t7 - xmp_decode
   vodselb <= NOT(vodsel);
   PROCESS (rvod_sel, pdb)
   BEGIN
      IF (pdb = '1') THEN
         CASE rvod_sel IS
            WHEN "000" =>
               vodsel <= "000000";
            WHEN "001" =>
               vodsel <= "000001";
            WHEN "010" =>
               vodsel <= "000011";
            WHEN "011" =>
               vodsel <= "000111";
            WHEN "100" =>
               vodsel <= "001111";
            WHEN "101" =>
               vodsel <= "011111";
            WHEN "110" =>
               vodsel <= "100011";
            WHEN "111" =>
               vodsel <= "100111";
            WHEN OTHERS =>
               vodsel <= "000000";
         END CASE;
      ELSE
         vodsel <= "000000";
      END IF;
   END PROCESS;
   
   
   -- c_dec5t5 - x1t_decode
   PROCESS (rpre_em_1t, pdb)
   BEGIN
      IF (pdb = '1') THEN
         CASE rpre_em_1t IS
            WHEN "00000" =>
               pre_em_1po <= "000000";
            WHEN "00001" =>
               pre_em_1po <= "000100";
            WHEN "00010" =>
               pre_em_1po <= "000101";
            WHEN "00011" =>
               pre_em_1po <= "000110";
            WHEN "00100" =>
               pre_em_1po <= "000111";
            WHEN "00101" =>
               pre_em_1po <= "001000";
            WHEN "00110" =>
               pre_em_1po <= "001001";
            
            WHEN "00111" =>
               pre_em_1po <= "001010";
            WHEN "01000" =>
               pre_em_1po <= "001011";
            WHEN "01001" =>
               pre_em_1po <= "001100";
            WHEN "01010" =>
               pre_em_1po <= "001101";
            WHEN "01011" =>
               pre_em_1po <= "001110";
            WHEN "01100" =>
               pre_em_1po <= "001111";
            WHEN "01101" =>
               pre_em_1po <= "010000";
            WHEN "01110" =>
               pre_em_1po <= "010001";
            
            WHEN "01111" =>
               pre_em_1po <= "010010";
            WHEN "10000" =>
               pre_em_1po <= "010011";
            WHEN "10001" =>
               pre_em_1po <= "010100";
            WHEN "10010" =>
               pre_em_1po <= "010101";
            WHEN "10011" =>
               pre_em_1po <= "010110";
            WHEN "10100" =>
               pre_em_1po <= "010111";
            WHEN "10101" =>
               pre_em_1po <= "011000";
            WHEN "10110" =>
               pre_em_1po <= "011010";
            
            WHEN "10111" =>
               pre_em_1po <= "011100";
            WHEN "11000" =>
               pre_em_1po <= "011110";
            WHEN "11001" =>
               pre_em_1po <= "110000";
            WHEN "11010" =>
               pre_em_1po <= "110010";
            WHEN "11011" =>
               pre_em_1po <= "110100";
            WHEN "11100" =>
               pre_em_1po <= "110110";
            WHEN "11101" =>
               pre_em_1po <= "111000";
            WHEN "11110" =>
               pre_em_1po <= "111100";
            
            WHEN "11111" =>
               pre_em_1po <= "111111";
            WHEN OTHERS =>
               pre_em_1po <= "000000";
         END CASE;
      ELSE
         pre_em_1po <= "000000";
      END IF;
   END PROCESS;
   
   
   -- x2t_decode 
   PROCESS (rpre_em_2t, pdb)
   BEGIN
      IF (pdb = '1') THEN
         IF (rpre_em_2t = "0000") THEN
            pre_em_2po(5 DOWNTO 1) <= "00000";
         ELSE
            pre_em_2po(5 DOWNTO 1) <= ('1' & rpre_em_2t);
         END IF;
      ELSE
         pre_em_2po <= "00000";
      END IF;
   END PROCESS;
   
   
   -- xpr_decode
   PROCESS (rpre_em_pt, pdb)
   BEGIN
      IF (pdb = '1') THEN
         IF (rpre_em_pt = "0000") THEN
            pre_em_pre(5 DOWNTO 1) <= "00000";
         ELSE
            pre_em_pre(5 DOWNTO 1) <= ('1' & rpre_em_pt);
         END IF;
      ELSE
         pre_em_pre <= "00000";
      END IF;
   END PROCESS;
   
   
   -- -- c_tx_testmux_dec --
   PROCESS (r_dft_sel)
   BEGIN
      CASE r_dft_sel IS
         WHEN "0--" =>
            dec2t4_en <= "0000";
         WHEN "100" =>
            dec2t4_en <= "0001";
         WHEN "101" =>
            dec2t4_en <= "0010";
         WHEN "110" =>
            dec2t4_en <= "0100";
         WHEN "111" =>
            dec2t4_en <= "1000";
         WHEN OTHERS =>
            dec2t4_en <= "0000";
      END CASE;
   END PROCESS;
   
   
   tx_dftout(6 DOWNTO 1) <= ('0' & pre_em_pre(5 DOWNTO 1)) WHEN (dec2t4_en(3) = '1') ELSE		-- used to be 6'bxxxxxx -- too pessimistic
                            ('0' & pre_em_2po(5 DOWNTO 1)) WHEN (dec2t4_en(2) = '1') ELSE
                            pre_em_1po(6 DOWNTO 1) WHEN (dec2t4_en(1) = '1') ELSE
                            vodsel(6 DOWNTO 1) WHEN (dec2t4_en(0) = '1') ELSE
                            "000000";
   
   -- -- c_tx_drv_buf xdrvbuf --
   vodsel_pdrv <= vodsel AND NOT(tx_elec_idl) & NOT(tx_elec_idl) & NOT(tx_elec_idl) & NOT(tx_elec_idl) & NOT(tx_elec_idl) & NOT(tx_elec_idl);
   
   -- -- c_tx_predrv xpredrv --
   pd_idl <= NOT(pdb) OR tx_elec_idl;
   
   -- xmain_tap_mux
   xhdl7 <= rlpbk_en & txden;
   PROCESS (txden, rlpbk_en, vip, vin, rlpbkp, rlpbkn)
   BEGIN
      CASE xhdl7 IS
         WHEN "00" =>
            mainp <= '0';
            mainn <= '1';
         WHEN "01" =>
            mainp <= vip;
            mainn <= vin;
         WHEN "10" =>
            mainp <= rlpbkp;
            mainn <= rlpbkn;
         WHEN "11" =>
            mainp <= 'X';
            mainn <= 'X';
         WHEN OTHERS =>
            mainp <= 'X';
            mainn <= 'X';
      END CASE;
   END PROCESS;
   
   
   -- xdrv0
   vopos_pd(0) <= mainp WHEN ((NOT(pd_idl)) = '1') ELSE		-- slew fct is not implemented
                  '1';
   vopos_nd(0) <= mainp WHEN ((NOT(pd_idl)) = '1') ELSE
                  '0';
   voneg_pd(0) <= mainn WHEN ((NOT(pd_idl)) = '1') ELSE
                  '1';
   voneg_nd(0) <= mainn WHEN ((NOT(pd_idl)) = '1') ELSE
                  '0';
   
   -- xdv_x6 - for driving strength
   vopos_pd(1) <= mainp WHEN ((vodsel_pdrv(1)) = '1') ELSE		-- slew fct is not implemelted
                  '1';
   vopos_nd(1) <= mainp WHEN ((vodsel_pdrv(1)) = '1') ELSE
                  '0';
   voneg_pd(1) <= mainn WHEN ((vodsel_pdrv(1)) = '1') ELSE
                  '1';
   voneg_nd(1) <= mainn WHEN ((vodsel_pdrv(1)) = '1') ELSE
                  '0';
   
   vopos_pd(2) <= mainp WHEN ((vodsel_pdrv(2)) = '1') ELSE
                  '1';
   vopos_nd(2) <= mainp WHEN ((vodsel_pdrv(2)) = '1') ELSE
                  '0';
   voneg_pd(2) <= mainn WHEN ((vodsel_pdrv(2)) = '1') ELSE
                  '1';
   voneg_nd(2) <= mainn WHEN ((vodsel_pdrv(2)) = '1') ELSE
                  '0';
   
   vopos_pd(3) <= mainp WHEN ((vodsel_pdrv(3)) = '1') ELSE
                  '1';
   vopos_nd(3) <= mainp WHEN ((vodsel_pdrv(3)) = '1') ELSE
                  '0';
   voneg_pd(3) <= mainn WHEN ((vodsel_pdrv(3)) = '1') ELSE
                  '1';
   voneg_nd(3) <= mainn WHEN ((vodsel_pdrv(3)) = '1') ELSE
                  '0';
   
   vopos_pd(4) <= mainp WHEN ((vodsel_pdrv(4)) = '1') ELSE
                  '1';
   vopos_nd(4) <= mainp WHEN ((vodsel_pdrv(4)) = '1') ELSE
                  '0';
   voneg_pd(4) <= mainn WHEN ((vodsel_pdrv(4)) = '1') ELSE
                  '1';
   voneg_nd(4) <= mainn WHEN ((vodsel_pdrv(4)) = '1') ELSE
                  '0';
   
   vopos_pd(5) <= mainp WHEN ((vodsel_pdrv(5)) = '1') ELSE
                  '1';
   vopos_nd(5) <= mainp WHEN ((vodsel_pdrv(5)) = '1') ELSE
                  '0';
   voneg_pd(5) <= mainn WHEN ((vodsel_pdrv(5)) = '1') ELSE
                  '1';
   voneg_nd(5) <= mainn WHEN ((vodsel_pdrv(5)) = '1') ELSE
                  '0';
   
   -- * * x1post_drv, x2post_drv and xpre_drv not implemented * *
   
   -- -- c_tx_drv xctxdrv --
   vop <= '1' WHEN ((NOT((reduction_and(voneg_pd))) AND NOT((reduction_and(voneg_nd)))) = '1') ELSE		-- 7 bits for driving strength - fct not implemented
          '0' WHEN (((reduction_or(voneg_pd)) AND (reduction_or(voneg_nd))) = '1') ELSE
          'Z' WHEN (((reduction_or(voneg_pd)) AND NOT((reduction_and(voneg_nd)))) = '1') ELSE
          '0' WHEN (tx_det_rx = '1') ELSE
          'X';
   von <= '1' WHEN ((NOT((reduction_and(vopos_pd))) AND NOT((reduction_and(vopos_nd)))) = '1') ELSE
          '0' WHEN (((reduction_or(vopos_pd)) AND (reduction_or(vopos_nd))) = '1') ELSE
          'Z' WHEN (((reduction_or(vopos_pd)) AND NOT((reduction_and(vopos_nd)))) = '1') ELSE
          '0' WHEN (tx_det_rx = '1') ELSE
          'X';
   
   -- * * C_RCV_DETECT * *
   tx_p <= vop;
   tx_n <= von;
   
   
   xi_rcv_det : stratixiv_hssi_pma_c_rcv_detect
      PORT MAP (
         com_pass       => com_pass_xhdl0,
         detect_on      => detect_on_xhdl1,
         fixed_clk_out  => fixed_clk_out_xhdl2,
         probe_pass     => probe_pass_xhdl3,
         rcv_det_pdb    => rx_det_pdb,
         rdet           => r_rx_det,
         rx_det_clk     => rx_det_clk,
         rx_det_valid   => rx_detect_valid_xhdl4,
         rx_found       => rx_found_xhdl5,
         sel_150r       => sel_150r_xhdl6,
         tx_det_rx      => tx_det_rx,
         rx_n           => rx_n,
         rx_p           => rx_p
      );
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;

   
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_ppmdetect IS		-- MZ
   PORT (
      scan_mode      : IN STD_LOGIC;		-- MZ
      ppmsel         : IN STD_LOGIC_VECTOR(5 DOWNTO 0);		-- ppmsel setting      ppmsel=6'b100000 <=> +/- 1000 PPM
      --                     ppmsel=6'b010000 <=> +/- 500 PPM
      --                     ppmsel=6'b001000 <=> +/- 300 PPM
      --                     ppmsel=6'b000100 <=> +/- 200 PPM
      --                     ppmsel=6'b000010 <=> +/- 125 PPM
      --                     ppmsel=6'b000001 <=> +/- 100 PPM
      
      fref           : IN STD_LOGIC;		-- Reference clock
      fvcobyn        : IN STD_LOGIC;		-- VCO divided clock
      pd             : IN STD_LOGIC;		-- Power down
      -- CRAM: force freq_lock high
      -- CRAM: force freq_lock low
      hard_reset     : IN STD_LOGIC;		-- initialize all registers to one
      rforcehigh     : IN STD_LOGIC;
      rforcelow      : IN STD_LOGIC;
      -- reset ppm_cnt_latch register
      
      freq_lock      : OUT STD_LOGIC;		-- fref and fvcobyn are vhdl_in range, set by ppmsel
      ppm_cnt_latch  : OUT STD_LOGIC_VECTOR(6 DOWNTO 0);		-- PPM difference, can be sent off-chip via testmux
      ppm_cnt_reset  : IN STD_LOGIC
   );
END stratixiv_hssi_pma_ppmdetect;

ARCHITECTURE trans OF stratixiv_hssi_pma_ppmdetect IS
   
   SIGNAL ref_cnt                   : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- 16-vhdl_bit counter using fref clock
   SIGNAL vco_cnt                   : STD_LOGIC_VECTOR(15 DOWNTO 0);		-- 16-vhdl_bit counter using fvcobyn clock
   SIGNAL eight_cnt                 : STD_LOGIC_VECTOR(3 DOWNTO 0);		-- counter used to delay the 16-vhdl_bit counters reset by 8-cycles
   SIGNAL ppm_cnt                   : STD_LOGIC_VECTOR(6 DOWNTO 0);		-- 6-vhdl_bit counter used to count number of fref vhdl_in open windows
   SIGNAL stable2                   : STD_LOGIC;
   SIGNAL stable1                   : STD_LOGIC;
   SIGNAL stable0                   : STD_LOGIC;
   SIGNAL overflow_vco              : STD_LOGIC;
   SIGNAL overflow_vco1             : STD_LOGIC;
   SIGNAL overflow_vco2             : STD_LOGIC;
   SIGNAL freq_lock_pre             : STD_LOGIC;
   SIGNAL v65536v                   : STD_LOGIC;
   SIGNAL v65536r                   : STD_LOGIC;
   SIGNAL window0                   : STD_LOGIC;
   SIGNAL window1                   : STD_LOGIC;
   SIGNAL rst_div2                  : STD_LOGIC;
   SIGNAL rst_div1                  : STD_LOGIC;
   SIGNAL rst_div0                  : STD_LOGIC;
   SIGNAL stay                      : STD_LOGIC;
   SIGNAL rst_div_fref              : STD_LOGIC;		--exists to delay the release of ref_cnt by one cycle. This will reduce the 
   -- the time difference between the start of ref_cnt and vco_cnt after the
   -- release of rst_div. The time difference is due to rst_div being synchronized
   -- to fvcobyn from fref domain. ref_cnt start up immediately and vco_cnt starts
   -- 2 fvcobyn clock edges later. rst_div_fref will help reduce that 2 edge gap to
   -- 1 edge.
   
   SIGNAL eight_cnt_0               : STD_LOGIC;
   SIGNAL eight_cnt_4               : STD_LOGIC;
   SIGNAL eight_cnt_8               : STD_LOGIC;
   SIGNAL window                    : STD_LOGIC;
   SIGNAL pd_sync_fref              : STD_LOGIC;
   SIGNAL pd_sync_fvcobyn           : STD_LOGIC;
   SIGNAL hard_reset_inv            : STD_LOGIC;
   
   -- Inverting hard_reset because rxpma_rstb is active low
   
   SIGNAL pd_sync_fref_pre          : STD_LOGIC;		-- MZ
   SIGNAL pd_sync_fref_b4scanmux    : STD_LOGIC;
   SIGNAL pd_sync_fvcobyn_pre       : STD_LOGIC;
   SIGNAL pd_sync_fvcobyn_b4scanmux : STD_LOGIC;
   --Synchronize pd to fref
   -- MZ
   --Synchronize pd to fvcobyn
   -- MZ
   
   -- This piece of code creates flags that reset the 16-vhdl_bit counters, when they BOTH go 
   -- beyond 32768 (plus about 20 cycles) cycles. Before that they have to synchronized to
   -- relevant clock domains. This resetting has to happen because when the PPM difference
   -- is so low that the window vhdl_signal is less than a fref clock period, it will be missed
   -- and the counters will continue counting until it reaches all ONES. This is not desirable.
   SIGNAL overflow_ref              : STD_LOGIC;
   -- X-HDL generated signals

   SIGNAL xhdl0 : STD_LOGIC;
   SIGNAL xhdl1 : STD_LOGIC;
   SIGNAL xhdl2 : STD_LOGIC;
BEGIN
   eight_cnt_0 <= reduction_nor(eight_cnt);
   eight_cnt_4 <= NOT(eight_cnt(3)) AND eight_cnt(2) AND NOT(eight_cnt(1)) AND NOT(eight_cnt(0));
   eight_cnt_8 <= eight_cnt(3) AND NOT(eight_cnt(2)) AND NOT(eight_cnt(1)) AND NOT(eight_cnt(0));
   window <= v65536r XOR v65536v;
   hard_reset_inv <= NOT(hard_reset);
   PROCESS (hard_reset_inv, fref)
   BEGIN
      IF (hard_reset_inv = '1') THEN
         pd_sync_fref_pre <= '1';
         pd_sync_fref_b4scanmux <= '1';
      ELSIF (fref'EVENT AND fref = '1') THEN
         pd_sync_fref_pre <= pd;
         pd_sync_fref_b4scanmux <= pd_sync_fref_pre;
      END IF;
   END PROCESS;
   
   pd_sync_fref <= '0' WHEN (scan_mode = '1') ELSE
                   pd_sync_fref_b4scanmux;
   PROCESS (hard_reset_inv, fvcobyn)
   BEGIN
      IF (hard_reset_inv = '1') THEN
         pd_sync_fvcobyn_pre <= '1';
         pd_sync_fvcobyn_b4scanmux <= '1';
      ELSIF (fvcobyn'EVENT AND fvcobyn = '1') THEN
         pd_sync_fvcobyn_pre <= pd;
         pd_sync_fvcobyn_b4scanmux <= pd_sync_fvcobyn_pre;
      END IF;
   END PROCESS;
   
   pd_sync_fvcobyn <= '0' WHEN (scan_mode = '1') ELSE
                      pd_sync_fvcobyn_b4scanmux;
   xhdl0 <= '1' WHEN (ref_cnt > "1000000000010000") ELSE
                      '0';
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         overflow_ref <= '0';
      ELSIF (fref'EVENT AND fref = '1') THEN
         overflow_ref <= xhdl0;
      END IF;
   END PROCESS;
   
   xhdl1 <= '1' WHEN (vco_cnt > "1000000000010000") ELSE
                   '0';
   PROCESS (pd_sync_fvcobyn, fvcobyn)
   BEGIN
      IF (pd_sync_fvcobyn = '1') THEN
         overflow_vco <= '0';
      ELSIF (fvcobyn'EVENT AND fvcobyn = '1') THEN
         
         -- After power down is released, the counters start counting. One counter may start several
         -- thousand cycles after the other. So, after 128 cycles of fvcobyn, a vhdl_signal called "stable"
         -- is released. This will guarantee that fvcobyn was stable, before module operation started.
         overflow_vco <= xhdl1;
      END IF;
   END PROCESS;
   
   PROCESS (pd_sync_fvcobyn, fvcobyn)
   BEGIN
      IF (pd_sync_fvcobyn = '1') THEN
         stable0 <= '0';
      ELSIF (fvcobyn'EVENT AND fvcobyn = '1') THEN
         IF (vco_cnt(15 DOWNTO 0) = "0000000011111111") THEN
            
            --synchronize stable and overflow_vco to fref domain. "overflow_vco" will be used as one of the
            --cases when rst_div = 1
            stable0 <= '1';
         END IF;
      END IF;
   END PROCESS;
   
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         stable1 <= '0';
         stable2 <= '0';
         overflow_vco1 <= '0';
         overflow_vco2 <= '0';
      ELSIF (fref'EVENT AND fref = '1') THEN
         stable1 <= stable0;
         stable2 <= stable1;
         overflow_vco1 <= overflow_vco;
         overflow_vco2 <= overflow_vco1;
      END IF;
   END PROCESS;
   
   
   --synchronize rst_div to fvcobyn domain
   PROCESS (pd_sync_fvcobyn, fvcobyn)
   BEGIN
      IF (pd_sync_fvcobyn = '1') THEN
         rst_div1 <= '0';
         rst_div2 <= '0';
      ELSIF (fvcobyn'EVENT AND fvcobyn = '1') THEN
         rst_div1 <= rst_div0;
         rst_div2 <= rst_div1;
      END IF;
   END PROCESS;
   
   
   --window1 is set to HIGH if clocks  are stable ("stable2" = 1) and 
   --window1 can be HIGH only when the 8 counter is not counting down.
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         window0 <= '0';
         window1 <= '0';
      ELSIF (fref'EVENT AND fref = '1') THEN
         IF ((NOT(stable2)) = '1') THEN
            window0 <= '0';
            window1 <= '0';
         ELSE
            window1 <= window0;
            IF (eight_cnt_8 = '1') THEN
               window0 <= window;
            ELSE
               window0 <= '0';
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   
   -- fref and fvcobyn counter reset
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         rst_div0 <= '0';
         rst_div_fref <= '0';
      ELSIF (fref'EVENT AND fref = '1') THEN
         IF (((eight_cnt > "0000") AND (eight_cnt < "1000")) OR ((overflow_ref AND overflow_vco2)) = '1') THEN
            rst_div0 <= '1';
            rst_div_fref <= rst_div0;
         ELSE
            rst_div0 <= '0';
            rst_div_fref <= rst_div0;
         END IF;
      END IF;
   END PROCESS;
   
   
   --reset counters during PD_SYNC and during the clocking down of the 8 counter
   -- fref counter
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         ref_cnt <= "0000000000000000";
         v65536r <= '1';
      ELSIF (fref'EVENT AND fref = '1') THEN
         IF (rst_div_fref = '1') THEN
            ref_cnt <= "0000000000000000";
            v65536r <= '1';
         ELSE
            ref_cnt <= ref_cnt + "0000000000000001";		--ref_cnt[15] = 1 means 32,768 cycles have passed
            v65536r <= NOT((ref_cnt(15)));
         END IF;
      END IF;
   END PROCESS;
   
   
   -- fvcobyn counter
   PROCESS (pd_sync_fvcobyn, fvcobyn)
   BEGIN
      IF (pd_sync_fvcobyn = '1') THEN
         vco_cnt <= "0000000000000000";
         v65536v <= '1';
      ELSIF (fvcobyn'EVENT AND fvcobyn = '1') THEN
         IF (rst_div2 = '1') THEN
            vco_cnt <= "0000000000000000";
            v65536v <= '1';
         ELSE
            vco_cnt <= vco_cnt + "0000000000000001";		--vco_cnt[15] = 1 means 32,768 cycles have passed
            v65536v <= NOT((vco_cnt(15)));
         END IF;
      END IF;
   END PROCESS;
   
   
   -- count only after window ends. Then stop at 0 and reset to 8.
   -- "stay" there until window goes high and low again. STAY is HIGH from 
   -- when WINDOW1 is HIGH to when EIGHT_CNT is 0. 
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         eight_cnt <= "1000";
         stay <= '0';
      ELSIF (fref'EVENT AND fref = '1') THEN
         IF (eight_cnt_0 = '1') THEN
            eight_cnt <= "1000";
            stay <= '0';
         ELSIF ((window1 = '1') OR ((overflow_ref AND overflow_vco2)) = '1') THEN
            stay <= '1';
         ELSIF ((window1 = '0') AND (stay = '1')) THEN
            eight_cnt <= eight_cnt - "0001";
         END IF;
      END IF;
   END PROCESS;
   
   
   -- PPM counter
   -- using 6-vhdl_bit counter to acount for setting of more than 1000PPM
   -- starts counting when window starts, which is "upd_synctctr"
   -- stops counting when window ends, which is when 
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         ppm_cnt <= "0000000";		-- Avoiding the comparison after pd_sync
      ELSIF (fref'EVENT AND fref = '1') THEN
         IF (eight_cnt_0 = '1') THEN
            ppm_cnt <= "0000000";		-- If 
         ELSIF (ppm_cnt = "1111111") THEN
            ppm_cnt <= "1111111";		--Hold all Ones until eight_count_0
         ELSIF (window1 = '1') THEN		--If window has been opened by FREF or FVCOBYN
            ppm_cnt <= ppm_cnt + "0000001";
         END IF;
      END IF;
   END PROCESS;
   
   
   -- freq_lock_pre detection
   -- Perfom the comparison 4 clock cycles before reseting the 16-vhdl_bit counters
   -- ppmsel setting      ppmsel=6'b100000 <=> +/- 1000 PPM
   --                     ppmsel=6'b010000 <=> +/- 500 PPM
   --                     ppmsel=6'b001000 <=> +/- 300 PPM
   --                     ppmsel=6'b001001 <=> +/- 250 PPM
   --                     ppmsel=6'b000100 <=> +/- 200 PPM
   --                     ppmsel=6'b000010 <=> +/- 125 PPM
   --                     ppmsel=6'b000001 <=> +/- 100 PPM
   --                     ppmsel=6'b000011 <=> +/- 62.5 PPM
   --  +/- 1000 PPM
   --  +/- 500 PPM
   --  +/- 300 PPM
   --  +/- 250 PPM
   --  +/- 200 PPM
   --  +/- 125 PPM
   --  +/- 100 PPM
   xhdl2 <= '1' WHEN (((eight_cnt_4 = '1') AND (ppmsel = "100000") AND (ppm_cnt <= "1000011")) OR ((eight_cnt_4 = '1') AND (ppmsel = "010000") AND (ppm_cnt <= "0100010")) OR ((eight_cnt_4 = '1') AND (ppmsel = "001000") AND (ppm_cnt <= "0010101")) OR ((eight_cnt_4 = '1') AND (ppmsel = "001001") AND (ppm_cnt <= "0010010")) OR ((eight_cnt_4 = '1') AND (ppmsel = "000100") AND (ppm_cnt <= "0001111")) OR ((eight_cnt_4 = '1') AND (ppmsel = "000010") AND (ppm_cnt <= "0001010")) OR ((eight_cnt_4 = '1') AND (ppmsel = "000001") AND (ppm_cnt <= "0001000")) OR ((eight_cnt_4 = '1') AND (ppmsel = "000011") AND (ppm_cnt <= "0000110")) OR ((eight_cnt_4 = '1') AND (ppmsel = "111111"))) ELSE		--  +/- 62.5 PPM
              '0';
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         freq_lock_pre <= '0';
      ELSIF (fref'EVENT AND fref = '1') THEN
         IF (eight_cnt_4 = '1') THEN
            freq_lock_pre <= xhdl2;
         END IF;
      END IF;
   END PROCESS;
   
   
   PROCESS (pd_sync_fref, fref)
   BEGIN
      IF (pd_sync_fref = '1') THEN
         ppm_cnt_latch <= "0000000";
      ELSIF (fref'EVENT AND fref = '1') THEN
         IF (ppm_cnt_reset = '1') THEN
            ppm_cnt_latch <= "0000000";
         ELSIF (eight_cnt_4 = '1') THEN
            ppm_cnt_latch <= ppm_cnt;
         END IF;
      END IF;
   END PROCESS;
   
   
   --CRAM bits force HIGH or LOW on to freq_lock. This serves as module bypass.
   freq_lock <= '1' WHEN (rforcehigh = '1') ELSE
                '0' WHEN (rforcelow = '1') ELSE
                freq_lock_pre;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;

   
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_c_ser_10g IS
   GENERIC (
      
      PARAM_DELAY  : INTEGER := 0
   );
   PORT (
      
      clk_divtx    : OUT STD_LOGIC;
      clk_skew     : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      cpulse       : IN STD_LOGIC;
      cpulseb      : IN STD_LOGIC;
      data_in      : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
      hfclkn       : IN STD_LOGIC;
      hfclkp       : IN STD_LOGIC;
      lbvon        : OUT STD_LOGIC;
      lbvop        : OUT STD_LOGIC;
      lfclkn       : IN STD_LOGIC;
      lfclkp       : IN STD_LOGIC;
      pdb          : IN STD_LOGIC;
      pre_em       : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      rst_n        : IN STD_LOGIC;
      s_lpbk       : IN STD_LOGIC;
      vccelxqyx    : IN STD_LOGIC;
      vccetxqyx    : IN STD_LOGIC;
      von          : OUT STD_LOGIC;
      von_op1      : OUT STD_LOGIC;
      vop          : OUT STD_LOGIC;
      vop_op1      : OUT STD_LOGIC;
      vssexqyx     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_ser_10g;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_ser_10g IS
   
   SIGNAL do8                  : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL core_clk             : STD_LOGIC;
   SIGNAL lfclkp_div_init_done : STD_LOGIC := '0' ;
   SIGNAL out_lb_reg           : STD_LOGIC := '0' ;
   SIGNAL outb_lb_reg          : STD_LOGIC := '1' ;
   SIGNAL out_e                : STD_LOGIC := '0' ;
   SIGNAL out_o                : STD_LOGIC := '0' ;
   SIGNAL data_mux4t1_sync1    : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL cpulse_x8_bus        : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL do_mux4t1_sync2      : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000" ;
   SIGNAL de_mux4t1_sync2      : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000" ;
   SIGNAL c0_even              : STD_LOGIC := '0' ;
   SIGNAL c1_even              : STD_LOGIC := '0' ;
   SIGNAL c2_even              : STD_LOGIC := '0' ;
   SIGNAL c3_even              : STD_LOGIC := '0' ;
   SIGNAL cp                   : STD_LOGIC := '0' ; -- initialization : manju
   SIGNAL cp_odd               : STD_LOGIC;
   SIGNAL c0_odd               : STD_LOGIC := '0' ;
   SIGNAL c1_odd               : STD_LOGIC := '0' ;
   SIGNAL c2_odd               : STD_LOGIC := '0' ;
   SIGNAL c3_odd               : STD_LOGIC := '0' ;
   SIGNAL cpulse_x8            : STD_LOGIC := '0' ; -- initialization : manju
   SIGNAL oo1                  : STD_LOGIC := '0' ;
   SIGNAL oe1                  : STD_LOGIC := '0' ;
   SIGNAL vop_reg              : STD_LOGIC := '0' ;
   SIGNAL von_reg              : STD_LOGIC := '1' ;
   SIGNAL vop_op1_reg          : STD_LOGIC := '0' ;
   SIGNAL von_op1_reg          : STD_LOGIC := '1' ;
   SIGNAL data_sync            : STD_LOGIC_VECTOR(63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000" ;
   SIGNAL do64                 : STD_LOGIC_VECTOR(63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000" ;
   
   SIGNAL lben                 : STD_LOGIC;
   SIGNAL pre_en               : STD_LOGIC;
   SIGNAL s_lpbkbuf            : STD_LOGIC;
   SIGNAL rst_nbuf             : STD_LOGIC;
   SIGNAL pe                   : STD_LOGIC;
   
   SIGNAL lfclkp_counter       : INTEGER := 0 ;
   -- X-HDL generated signals

   SIGNAL xhdl0 : STD_LOGIC_VECTOR(8 DOWNTO 0);
   SIGNAL xhdl1 : STD_LOGIC_VECTOR(8 DOWNTO 0);
BEGIN
   
   pre_en <= reduction_nor(pre_em);
   s_lpbkbuf <= pdb AND s_lpbk;
   rst_nbuf <= pdb AND rst_n;
   clk_divtx <= core_clk;
   
   xhdl0 <= "000000000";
   
   -- * * c_div8_10g * *
   PROCESS (lfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         lfclkp_counter <= 0;
         lfclkp_div_init_done <= '0';
         core_clk <= '0';
      ELSIF (lfclkp'EVENT AND lfclkp = '1') THEN
         -- after one cycle of lfclkp, if set, reset cpulse_x8
         IF (lfclkp = '1' AND cpulse_x8 = '1') THEN
            cpulse_x8 <= '0';
         END IF;
         IF (lfclkp_div_init_done = '0') THEN
            core_clk <= '1';
            lfclkp_div_init_done <= '1';
         ELSE
            -- generation of core_clk
            IF (lfclkp_counter MOD 4 = 0) THEN
               core_clk <= NOT(core_clk);
               IF (core_clk = '0') THEN
                  cpulse_x8 <= '1';
               END IF;
            END IF;
         END IF;
         lfclkp_counter <= lfclkp_counter + 1;
      END IF;
   END PROCESS;
   
   -- * * c_mux64to8_10g * *
   -- - cpulse_8x8_gen -
   xhdl1 <= "000000000";
   PROCESS (lfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
--         (cpulse_x8_bus(7 DOWNTO 0), cp) <=  TRANSPORT xhdl1 AFTER (PARAM_DELAY)*1 ps;
         cpulse_x8_bus(7 DOWNTO 0) <=  TRANSPORT xhdl1(8 downto 1) AFTER (PARAM_DELAY)*1 ps;
         cp <=  TRANSPORT xhdl1(0) AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (lfclkp'EVENT AND lfclkp = '1') THEN
--         (cpulse_x8_bus(7 DOWNTO 0), cp) <=  TRANSPORT (cpulse_x8_bus(6 DOWNTO 0) & cp & cpulse_x8) AFTER (PARAM_DELAY)*1 ps;
         cpulse_x8_bus(7 DOWNTO 0) <=  TRANSPORT (cpulse_x8_bus(6 DOWNTO 0) & cp) AFTER (PARAM_DELAY)*1 ps;
         cp <=  TRANSPORT (cpulse_x8) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   
   -- - c_64bit_reg_10g -
   PROCESS (core_clk)
   BEGIN
      IF (core_clk'EVENT AND core_clk = '1') THEN
         -- - c_32bit_reg_10g bits[63:32] -
         data_sync <=  TRANSPORT data_in AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (core_clk)
   BEGIN
      IF (core_clk'EVENT AND core_clk = '1') THEN
         -- - c_32bit_reg_10g bits[31:0] -
         do64(63 DOWNTO 32) <=  TRANSPORT data_sync(63 DOWNTO 32) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (core_clk)
   BEGIN
      IF (core_clk'EVENT AND core_clk = '0') THEN
         -- - a_8bit_tri_reg - 
         do64(31 DOWNTO 0) <=  TRANSPORT data_sync(31 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (cpulse_x8_bus, rst_nbuf)
   BEGIN
      IF ((NOT(rst_nbuf)) = '1') THEN
         do8 <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
      ELSE
         IF (cpulse_x8_bus(4)'EVENT AND cpulse_x8_bus(4) = '1') THEN
             do8 <=  TRANSPORT do64(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
         END IF;

         IF (cpulse_x8_bus(5)'EVENT AND cpulse_x8_bus(5) = '1') THEN
             do8 <=  TRANSPORT do64(15 DOWNTO 8) AFTER (PARAM_DELAY)*1 ps;
         END IF;

         IF (cpulse_x8_bus(6)'EVENT AND cpulse_x8_bus(6) = '1') THEN
             do8 <=  TRANSPORT do64(23 DOWNTO 16) AFTER (PARAM_DELAY)*1 ps;
         END IF;

         IF (cpulse_x8_bus(7)'EVENT AND cpulse_x8_bus(7) = '1') THEN
             do8 <=  TRANSPORT do64(31 DOWNTO 24) AFTER (PARAM_DELAY)*1 ps;
         END IF;
         
         IF (cpulse_x8_bus(0)'EVENT AND cpulse_x8_bus(0) = '1') THEN
             do8 <=  TRANSPORT do64(39 DOWNTO 32) AFTER (PARAM_DELAY)*1 ps;
         END IF;
          
         IF (cpulse_x8_bus(1)'EVENT AND cpulse_x8_bus(1) = '1') THEN
             do8 <=  TRANSPORT do64(47 DOWNTO 40) AFTER (PARAM_DELAY)*1 ps;
         END IF;
          
         IF (cpulse_x8_bus(2)'EVENT AND cpulse_x8_bus(2) = '1') THEN
             do8 <=  TRANSPORT do64(55 DOWNTO 48) AFTER (PARAM_DELAY)*1 ps;
         END IF;
         
         IF (cpulse_x8_bus(3)'EVENT AND cpulse_x8_bus(3) = '1') THEN
             do8 <=  TRANSPORT do64(63 DOWNTO 56) AFTER (PARAM_DELAY)*1 ps;
         END IF;
      END IF;
   END PROCESS;

   -- * * stratixiv_hssi_pma_c_ser_mux4to1 -- xmux4to1_even & odd instances * *
   -- Pipe #1 - synchronize data to lfclkp negedge
   PROCESS (lfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         data_mux4t1_sync1 <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (lfclkn'EVENT AND lfclkn = '1') THEN
         data_mux4t1_sync1 <=  TRANSPORT do8 AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   -- Pipe #2 - Synchronize 0,2 and 1,3 to CLK and CLKB ; 6,8 and 5,7 to CLK and CLKB
   PROCESS (lfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         de_mux4t1_sync2(1 DOWNTO 0) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
         do_mux4t1_sync2(1 DOWNTO 0) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (lfclkp'EVENT AND lfclkp = '1') THEN
         de_mux4t1_sync2(1 DOWNTO 0) <=  TRANSPORT (data_mux4t1_sync1(2) & data_mux4t1_sync1(0)) AFTER (PARAM_DELAY)*1 ps;
         do_mux4t1_sync2(1 DOWNTO 0) <=  TRANSPORT (data_mux4t1_sync1(3) & data_mux4t1_sync1(1)) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (lfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         de_mux4t1_sync2(3 DOWNTO 2) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
         do_mux4t1_sync2(3 DOWNTO 2) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
      ELSIF (lfclkn'EVENT AND lfclkn = '1') THEN
         de_mux4t1_sync2(3 DOWNTO 2) <=  TRANSPORT (data_mux4t1_sync1(6) & data_mux4t1_sync1(4)) AFTER (PARAM_DELAY)*1 ps;
         do_mux4t1_sync2(3 DOWNTO 2) <=  TRANSPORT (data_mux4t1_sync1(7) & data_mux4t1_sync1(5)) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   -- Pulse generation for odd and even - CPULSE, CP, C0, ..., C3
   PROCESS (hfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         c3_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c2_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c1_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c0_even <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkn'EVENT AND hfclkn = '1') THEN
         c0_even <=  TRANSPORT cpulse AFTER (PARAM_DELAY)*1 ps;
         c1_even <=  TRANSPORT c0_even AFTER (PARAM_DELAY)*1 ps;
         c2_even <=  TRANSPORT c1_even AFTER (PARAM_DELAY)*1 ps;
         c3_even <=  TRANSPORT c2_even AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   PROCESS (hfclkn, rst_nbuf)		-- Mux Odd
   BEGIN
      IF (rst_nbuf = '0') THEN
         cp_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkn'EVENT AND hfclkn = '1') THEN
         cp_odd <=  TRANSPORT cpulse AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         c3_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c2_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c1_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         c0_odd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkp'EVENT AND hfclkp = '1') THEN
         c0_odd <=  TRANSPORT cp_odd AFTER (PARAM_DELAY)*1 ps;
         c1_odd <=  TRANSPORT c0_odd AFTER (PARAM_DELAY)*1 ps;
         c2_odd <=  TRANSPORT c1_odd AFTER (PARAM_DELAY)*1 ps;
         c3_odd <=  TRANSPORT c2_odd AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   
   -- Mux2to1 Even outputs
   PROCESS (c0_even, c1_even, c2_even, c3_even)
   BEGIN
      IF (c0_even'EVENT AND c0_even = '1') THEN
         out_e <=  TRANSPORT de_mux4t1_sync2(0) AFTER (PARAM_DELAY)*1 ps;
      END IF;

      IF (c1_even'EVENT AND c1_even = '1') THEN
         out_e <=  TRANSPORT de_mux4t1_sync2(1) AFTER (PARAM_DELAY)*1 ps;
      END IF;

      IF (c2_even'EVENT AND c2_even = '1') THEN
         out_e <=  TRANSPORT de_mux4t1_sync2(2) AFTER (PARAM_DELAY)*1 ps;
      END IF;

      IF (c3_even'EVENT AND c3_even = '1') THEN
         out_e <=  TRANSPORT de_mux4t1_sync2(3) AFTER (PARAM_DELAY)*1 ps;
      END IF;

   END PROCESS;
   
   -- Mux2to1 Odd outputs
   PROCESS (c0_odd, c1_odd, c2_odd, c3_odd)
   BEGIN
      IF (c0_odd'EVENT AND c0_odd = '1') THEN
         out_o <=  TRANSPORT do_mux4t1_sync2(0) AFTER (PARAM_DELAY)*1 ps;
      END IF;

      IF (c1_odd'EVENT AND c1_odd = '1') THEN
         out_o <=  TRANSPORT do_mux4t1_sync2(1) AFTER (PARAM_DELAY)*1 ps;
      END IF;

      IF (c2_odd'EVENT AND c2_odd = '1') THEN
         out_o <=  TRANSPORT do_mux4t1_sync2(2) AFTER (PARAM_DELAY)*1 ps;
      END IF;

      IF (c3_odd'EVENT AND c3_odd = '1') THEN
         out_o <=  TRANSPORT do_mux4t1_sync2(3) AFTER (PARAM_DELAY)*1 ps;
      END IF;

   END PROCESS;
   
   -- * * stratixiv_hssi_pma_c_ser_mux2to1 -- xmux2to1 instance * *
   pe <= pre_en AND rst_nbuf AND pdb;
   vop <= vop_reg WHEN (pdb = '1') ELSE
          '1';
   von <= von_reg WHEN (pdb = '1') ELSE
          '1';
   vop_op1 <= vop_op1_reg WHEN (pe = '1') ELSE
              '1';
   von_op1 <= von_op1_reg WHEN (pe = '1') ELSE
              '1';
   
   PROCESS (hfclkn, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         oe1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkn'EVENT AND hfclkn = '1') THEN
         oe1 <=  TRANSPORT out_e AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp, rst_nbuf)
   BEGIN
      IF (rst_nbuf = '0') THEN
         oo1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (hfclkp'EVENT AND hfclkp = '1') THEN
         oo1 <=  TRANSPORT out_o AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp, hfclkn)
   BEGIN
      IF (hfclkp'EVENT AND hfclkp = '1' AND pdb = '1') THEN
         vop_reg <=  TRANSPORT out_o AFTER (PARAM_DELAY)*1 ps;
         von_reg <=  TRANSPORT NOT(out_o) AFTER (PARAM_DELAY)*1 ps;
      END IF;
          
      IF (hfclkn'EVENT AND hfclkn = '1' AND pdb = '1') THEN
         vop_reg <=  TRANSPORT out_e AFTER (PARAM_DELAY)*1 ps;
         von_reg <=  TRANSPORT NOT(out_e) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (hfclkp, hfclkn)
   BEGIN
      IF (hfclkp'EVENT AND hfclkp = '1' AND pe = '1') THEN
         vop_op1_reg <=  TRANSPORT oe1 AFTER (PARAM_DELAY)*1 ps;
         von_op1_reg <=  TRANSPORT NOT(oe1) AFTER (PARAM_DELAY)*1 ps;
      END IF;
          
      IF (hfclkn'EVENT AND hfclkn = '1' AND pe = '1') THEN
         vop_op1_reg <=  TRANSPORT oo1 AFTER (PARAM_DELAY)*1 ps;
         von_op1_reg <=  TRANSPORT NOT(oo1) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   -- * * stratixiv_hssi_pma_c_ser_mux2to1_lb -- xmux2to1_lb instance * *
   lben <= pdb AND s_lpbkbuf;
   lbvop <= out_lb_reg WHEN (lben = '1') ELSE
            '1';
   lbvon <= outb_lb_reg WHEN (lben = '1') ELSE
            '1';
   
   PROCESS (hfclkn, hfclkp)
   BEGIN
      IF (hfclkn'EVENT AND hfclkn = '1' AND lben = '1') THEN
         out_lb_reg <=  TRANSPORT out_e AFTER (PARAM_DELAY)*1 ps;
         outb_lb_reg <=  TRANSPORT NOT(out_e) AFTER (PARAM_DELAY)*1 ps;
      END IF;
          
      IF (hfclkp'EVENT AND hfclkp = '1' AND lben = '1') THEN
         out_lb_reg <=  TRANSPORT out_o AFTER (PARAM_DELAY)*1 ps;
         outb_lb_reg <=  TRANSPORT NOT(out_o) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_c_deser_10g IS
   GENERIC (
      
      PARAM_DELAY  : INTEGER := 0
   );
   PORT (
      clk90b       : IN STD_LOGIC;
      
      clk_divrx    : OUT STD_LOGIC;
      deser_pdb    : IN STD_LOGIC;
      deven        : IN STD_LOGIC;
      devenb       : IN STD_LOGIC;
      dodd         : IN STD_LOGIC;
      doddb        : IN STD_LOGIC;
      dout         : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
      rst_n        : IN STD_LOGIC;
      vcce_la      : IN STD_LOGIC;
      vssexqyx     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_deser_10g;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_deser_10g IS
   
   SIGNAL clk90_counter        : INTEGER := 0 ;
   SIGNAL clk270_counter       : INTEGER := 0 ;
   SIGNAL ph2_counter          : INTEGER := 0 ;
   SIGNAL clk90_div_init_done  : STD_LOGIC := '0' ;
   SIGNAL clk90_div4           : STD_LOGIC := '0' ;
   SIGNAL clk270_div_init_done : STD_LOGIC := '0' ;
   SIGNAL clk270_div4          : STD_LOGIC := '0' ;
   SIGNAL ph2_div_init_done    : STD_LOGIC := '0' ;
   SIGNAL ph2_div8             : STD_LOGIC := '0' ;
   SIGNAL ph                   : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dsync                : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dp                   : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL doutp                : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL doutn                : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL ph8                  : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL dout_int             : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL dsync8               : STD_LOGIC_VECTOR(63 DOWNTO 0);
   
   SIGNAL clk90                : STD_LOGIC;
   SIGNAL clk270               : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL clk_divrx_xhdl0      : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   clk_divrx <= clk_divrx_xhdl0;
   
   clk90 <= NOT(clk90b);
   clk270 <= clk90b;
   
   -- * * c_deser_2to8_10g * * 
   
   -- - c_deser_divby4_10g -
   PROCESS (clk90, rst_n)
   BEGIN
      IF (rst_n = '0') THEN
         clk90_counter <= 0;
         clk90_div_init_done <= '0';
         clk90_div4 <= '0';
      ELSIF (clk90'EVENT AND clk90 = '1') THEN
         IF (clk90_div_init_done = '0') THEN
            clk90_div4 <= '1';
            clk90_div_init_done <= '1';
         ELSE
            -- generation of clk90_div4
            IF (clk90_counter MOD 2 = 0) THEN
               clk90_div4 <= NOT(clk90_div4);
            END IF;
         END IF;
         clk90_counter <= clk90_counter + 1;
      END IF;
   END PROCESS;
   
   
   -- clk270_div4 should not start toggling before clk90_div4
   PROCESS (clk270, rst_n)
   BEGIN
      IF (rst_n = '0') THEN
         clk270_counter <= 0;
         clk270_div_init_done <= '0';
         clk270_div4 <= '0';
      ELSE
         IF (clk90_div_init_done = '1') THEN
            -- generation of clk270_div4
            IF ((clk270 = '1') AND (clk270_counter MOD 4 = 0)) THEN
               IF (clk270_div_init_done = '0') THEN
                  clk270_div4 <= '1';
                  clk270_div_init_done <= '1';
               ELSE
                  clk270_div4 <= NOT(clk270_div4);
               END IF;
            END IF;
            clk270_counter <= clk270_counter + 1;
         END IF;
      END IF;
   END PROCESS;
   
   
   PROCESS (rst_n, clk270)
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         ph(3 DOWNTO 0) <=  TRANSPORT "0000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk270'EVENT AND clk270 = '1') THEN
         
         -- - 1 to 4 demux -
         -- Shift register
         ph(3 DOWNTO 0) <=  TRANSPORT (ph(2 DOWNTO 0) & clk270_div4) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph(0))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dp(1 DOWNTO 0) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph(0)'EVENT AND ph(0) = '1') THEN
         
         dp(1 DOWNTO 0) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph(1))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dp(3 DOWNTO 2) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph(1)'EVENT AND ph(1) = '1') THEN
         
         dp(3 DOWNTO 2) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph(2))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dp(5 DOWNTO 4) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph(2)'EVENT AND ph(2) = '1') THEN
         
         dp(5 DOWNTO 4) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph(3))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dp(7 DOWNTO 6) <=  TRANSPORT "00" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph(3)'EVENT AND ph(3) = '1') THEN
         
         -- dp[0,1,2,3] synchronization
         dp(7 DOWNTO 6) <=  TRANSPORT (dodd & deven) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph(0))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dsync(3 DOWNTO 0) <=  TRANSPORT "0000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph(0)'EVENT AND ph(0) = '0') THEN
         
         dsync(3 DOWNTO 0) <=  TRANSPORT dp(3 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph(0))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         doutp(7 DOWNTO 0) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
         doutn(7 DOWNTO 0) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph(0)'EVENT AND ph(0) = '1') THEN
         doutp(7 DOWNTO 0) <=  TRANSPORT (dp(7 DOWNTO 4) & dsync(3 DOWNTO 0)) AFTER (PARAM_DELAY)*1 ps;
          
         doutn(7 DOWNTO 0) <=  TRANSPORT NOT((dp(7 DOWNTO 4) & dsync(3 DOWNTO 0))) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   
   -- * * c_deser_8to64_10g * *
   
   -- - c_deser_divby8_10g - 
   PROCESS (ph(2), rst_n)
   BEGIN
      IF (rst_n = '0') THEN
         ph2_counter <= 0;
         ph2_div_init_done <= '0';
         ph2_div8 <= '0';
      ELSIF (ph(2)'EVENT AND ph(2) = '1') THEN
         IF (ph2_div_init_done = '0') THEN
            ph2_div8 <= '1';
            ph2_div_init_done <= '1';
         ELSE
            -- generation of ph2_div8
            IF (ph2_counter MOD 4 = 0) THEN
               ph2_div8 <= NOT(ph2_div8);
            END IF;
         END IF;
         ph2_counter <= ph2_counter + 1;
      END IF;
   END PROCESS;
   
   
   PROCESS (rst_n, ph(2))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         ph8(7 DOWNTO 0) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph(2)'EVENT AND ph(2) = '1') THEN
         
         -- - c_deser_by8_8_10g -
         ph8(7 DOWNTO 0) <=  TRANSPORT (ph8(6 DOWNTO 0) & ph2_div8) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   clk_divrx_xhdl0 <= ph8(0);
   
   PROCESS (rst_n, ph8(0))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(7 DOWNTO 0) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(0)'EVENT AND ph8(0) = '1') THEN
         
         dout_int(7 DOWNTO 0) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(1))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(15 DOWNTO 8) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(1)'EVENT AND ph8(1) = '1') THEN
         
         dout_int(15 DOWNTO 8) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(2))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(23 DOWNTO 16) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(2)'EVENT AND ph8(2) = '1') THEN
         
         dout_int(23 DOWNTO 16) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(3))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(31 DOWNTO 24) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(3)'EVENT AND ph8(3) = '1') THEN
         
         dout_int(31 DOWNTO 24) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(4))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(39 DOWNTO 32) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(4)'EVENT AND ph8(4) = '1') THEN
         
         dout_int(39 DOWNTO 32) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(5))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(47 DOWNTO 40) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(5)'EVENT AND ph8(5) = '1') THEN
         
         dout_int(47 DOWNTO 40) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(6))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(55 DOWNTO 48) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(6)'EVENT AND ph8(6) = '1') THEN
         
         dout_int(55 DOWNTO 48) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(7))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout_int(63 DOWNTO 56) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(7)'EVENT AND ph8(7) = '1') THEN
         
         dout_int(63 DOWNTO 56) <=  TRANSPORT doutp(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (rst_n, ph8(7))
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dsync8(7 DOWNTO 0) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
         dsync8(15 DOWNTO 8) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
         dsync8(23 DOWNTO 16) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
         dsync8(31 DOWNTO 24) <=  TRANSPORT "00000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (ph8(7)'EVENT AND ph8(7) = '1') THEN
         dsync8(7 DOWNTO 0) <=  TRANSPORT dout_int(7 DOWNTO 0) AFTER (PARAM_DELAY)*1 ps;
          
         dsync8(15 DOWNTO 8) <=  TRANSPORT dout_int(15 DOWNTO 8) AFTER (PARAM_DELAY)*1 ps;
          
         dsync8(23 DOWNTO 16) <=  TRANSPORT dout_int(23 DOWNTO 16) AFTER (PARAM_DELAY)*1 ps;
          
         dsync8(31 DOWNTO 24) <=  TRANSPORT dout_int(31 DOWNTO 24) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   
   PROCESS (rst_n, clk_divrx_xhdl0)
   BEGIN
      IF ((NOT(rst_n)) = '1') THEN
         dout(63 DOWNTO 0) <=  TRANSPORT "0000000000000000000000000000000000000000000000000000000000000000" AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk_divrx_xhdl0'EVENT AND clk_divrx_xhdl0 = '1') THEN
         
         dout(63 DOWNTO 0) <=  TRANSPORT (dout_int(63 DOWNTO 32) & dsync8(31 DOWNTO 0)) AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   
END trans;



Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;

ENTITY stratixiv_hssi_pma_c_clkgendrv_tx10g IS
   PORT (
      
      clk0       : IN STD_LOGIC;
      clk180     : IN STD_LOGIC;
      cpulse     : OUT STD_LOGIC;
      cpulseb    : OUT STD_LOGIC;
      hfclk_n    : OUT STD_LOGIC;
      hfclk_p    : OUT STD_LOGIC;
      lfclk_n    : OUT STD_LOGIC;
      lfclk_p    : OUT STD_LOGIC;
      rst_n      : IN STD_LOGIC;
      vccelxqyx  : IN STD_LOGIC;
      vssexqyx   : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_clkgendrv_tx10g;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_clkgendrv_tx10g IS
   
   COMPONENT stratixiv_hssi_pma_c_clkgendrv
   PORT (
      clk0       : IN STD_LOGIC;
      clk90      : IN STD_LOGIC;
      clk180     : IN STD_LOGIC;
      clk270     : IN STD_LOGIC;
      
      cpulse     : OUT STD_LOGIC;
      cpulseb    : OUT STD_LOGIC;
      cpulseo    : OUT STD_LOGIC;
      div5       : IN STD_LOGIC;
      hfclk_n    : OUT STD_LOGIC;
      hfclk_p    : OUT STD_LOGIC;
      lfclk_n    : OUT STD_LOGIC;
      lfclk_p    : OUT STD_LOGIC;
      rst_n      : IN STD_LOGIC;
      vccelxqyx  : IN STD_LOGIC;
      vssexqyx   : IN STD_LOGIC
   );
   END COMPONENT;

   SIGNAL nc2           : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL cpulse_xhdl0  : STD_LOGIC;
   SIGNAL cpulseb_xhdl1 : STD_LOGIC;
   SIGNAL hfclk_n_xhdl2 : STD_LOGIC;
   SIGNAL hfclk_p_xhdl3 : STD_LOGIC;
   SIGNAL lfclk_n_xhdl4 : STD_LOGIC;
   SIGNAL lfclk_p_xhdl5 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   cpulse <= cpulse_xhdl0;
   cpulseb <= cpulseb_xhdl1;
   hfclk_n <= hfclk_n_xhdl2;
   hfclk_p <= hfclk_p_xhdl3;
   lfclk_n <= lfclk_n_xhdl4;
   lfclk_p <= lfclk_p_xhdl5;
   
   
   
   xdrv : stratixiv_hssi_pma_c_clkgendrv
      PORT MAP (
         clk0       => clk0,
         clk90      => '0',
         clk180     => clk180,
         clk270     => '1',
         cpulse     => cpulse_xhdl0,
         cpulseb    => cpulseb_xhdl1,
         cpulseo    => nc2,
         div5       => '0',
         hfclk_n    => hfclk_n_xhdl2,
         hfclk_p    => hfclk_p_xhdl3,
         lfclk_n    => lfclk_n_xhdl4,
         lfclk_p    => lfclk_p_xhdl5,
         rst_n      => rst_n,
         vccelxqyx  => vccelxqyx,
         vssexqyx   => vssexqyx
      );
   
END trans;


Library work;
USE work.stratixiv_hssi_components.all;
LIBRARY ieee;
   USE ieee.std_logic_1164.all;

ENTITY stratixiv_hssi_pma_c_clkgenbuf_tx10g IS
   PORT (
      clk0_in      : IN STD_LOGIC;
      clk180_in    : IN STD_LOGIC;
      cpulse       : OUT STD_LOGIC;
      cpulseb      : OUT STD_LOGIC;
      hfclk_n      : OUT STD_LOGIC;
      hfclk_p      : OUT STD_LOGIC;
      lfclk_n      : OUT STD_LOGIC;
      lfclk_p      : OUT STD_LOGIC;
      rst_n        : IN STD_LOGIC;
      vccelxqyx    : IN STD_LOGIC;
      vssexqyx     : IN STD_LOGIC
   );
END stratixiv_hssi_pma_c_clkgenbuf_tx10g;

ARCHITECTURE trans OF stratixiv_hssi_pma_c_clkgenbuf_tx10g IS
   COMPONENT stratixiv_hssi_pma_c_clkgendrv_tx10g
      PORT (
         clk0         : IN STD_LOGIC;
         clk180       : IN STD_LOGIC;
         cpulse       : OUT STD_LOGIC;
         cpulseb      : OUT STD_LOGIC;
         hfclk_n      : OUT STD_LOGIC;
         hfclk_p      : OUT STD_LOGIC;
         lfclk_n      : OUT STD_LOGIC;
         lfclk_p      : OUT STD_LOGIC;
         rst_n        : IN STD_LOGIC;
         vccelxqyx    : IN STD_LOGIC;
         vssexqyx     : IN STD_LOGIC
      );
   END COMPONENT;
   
   SIGNAL clk0_out      : STD_LOGIC;
   SIGNAL clk180_out    : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL cpulse_xhdl0  : STD_LOGIC;
   SIGNAL cpulseb_xhdl1 : STD_LOGIC;
   SIGNAL hfclk_n_xhdl2 : STD_LOGIC;
   SIGNAL hfclk_p_xhdl3 : STD_LOGIC;
   SIGNAL lfclk_n_xhdl4 : STD_LOGIC;
   SIGNAL lfclk_p_xhdl5 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   cpulse <= cpulse_xhdl0;
   cpulseb <= cpulseb_xhdl1;
   hfclk_n <= hfclk_n_xhdl2;
   hfclk_p <= hfclk_p_xhdl3;
   lfclk_n <= lfclk_n_xhdl4;
   lfclk_p <= lfclk_p_xhdl5;
   
   clk0_out <= clk0_in;
   clk180_out <= clk180_in;
   
   
   
   xdrv : stratixiv_hssi_pma_c_clkgendrv_tx10g
      PORT MAP (
         clk0       => clk0_out,
         clk180     => clk180_out,
         cpulse     => cpulse_xhdl0,
         cpulseb    => cpulseb_xhdl1,
         hfclk_n    => hfclk_n_xhdl2,
         hfclk_p    => hfclk_p_xhdl3,
         lfclk_n    => lfclk_n_xhdl4,
         lfclk_p    => lfclk_p_xhdl5,
         rst_n      => rst_n,
         vccelxqyx  => vccelxqyx,
         vssexqyx   => vssexqyx
      );
   
END trans;

--IP Functional Simulation Model
--VERSION_BEGIN 10.1 cbx_mgl 2010:11:29:21:24:23:SJ cbx_simgen 2010:11:29:21:22:45:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = io_buf_tri 264 lut 176 mux21 86 tri_bus 62 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_hssi_pma_c_adce IS 
	 PORT 
	 ( 
		 adapt_capture	:	IN  STD_LOGIC;
		 adapt_done	:	OUT  STD_LOGIC;
		 atb0	:	INOUT  STD_LOGIC;
		 atb1	:	INOUT  STD_LOGIC;
		 atb_0	:	INOUT  STD_LOGIC;
		 atb_1	:	INOUT  STD_LOGIC;
		 atben	:	IN  STD_LOGIC;
		 atbsel	:	IN  STD_LOGIC_VECTOR (23 DOWNTO 0);
		 e_clk	:	OUT  STD_LOGIC;
		 eqa_ctrl	:	OUT  STD_LOGIC;
		 eqa_set	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 eqb_ctrl	:	OUT  STD_LOGIC;
		 eqb_set	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 eqc_ctrl	:	OUT  STD_LOGIC;
		 eqc_set	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 eqctrlout	:	OUT  STD_LOGIC_VECTOR (5 DOWNTO 0);
		 eqd_ctrl	:	OUT  STD_LOGIC;
		 eqd_set	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 eqin_n	:	IN  STD_LOGIC;
		 eqin_p	:	IN  STD_LOGIC;
		 eqv_ctrl	:	OUT  STD_LOGIC;
		 eqv_set	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 fine_d2aout	:	OUT  STD_LOGIC;
		 fixed_clk	:	IN  STD_LOGIC;
		 hf_adapt_done	:	OUT  STD_LOGIC;
		 hfclk_macro	:	OUT  STD_LOGIC;
		 hfmac_cnt0_nclr	:	OUT  STD_LOGIC;
		 hfmac_cnt2_nclr	:	OUT  STD_LOGIC;
		 ib50u_c	:	INOUT  STD_LOGIC;
		 ib50u_t	:	INOUT  STD_LOGIC;
		 ibrgen1	:	OUT  STD_LOGIC;
		 ibrgen2	:	OUT  STD_LOGIC;
		 lf_adapt_done	:	OUT  STD_LOGIC;
		 lfclk_macro	:	OUT  STD_LOGIC;
		 lfmac_cnt0_nclr	:	OUT  STD_LOGIC;
		 lfmac_cnt2_nclr	:	OUT  STD_LOGIC;
		 lock_lf_ovd	:	IN  STD_LOGIC;
		 lst	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 outeqn	:	INOUT  STD_LOGIC;
		 outeqp	:	INOUT  STD_LOGIC;
		 r_clk	:	OUT  STD_LOGIC;
		 radce_adapt	:	IN  STD_LOGIC;
		 radce_digital	:	IN  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 radce_hflck	:	IN  STD_LOGIC_VECTOR (14 DOWNTO 0);
		 radce_lflck	:	IN  STD_LOGIC_VECTOR (14 DOWNTO 0);
		 radce_pdb	:	IN  STD_LOGIC;
		 radce_rstb	:	IN  STD_LOGIC;
		 radce_vod_int	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 radce_vod_lsb	:	IN  STD_LOGIC;
		 rbit_dc	:	IN  STD_LOGIC;
		 rclkdiv	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rd2a_res	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rdc_freq	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rdfe_en	:	IN  STD_LOGIC;
		 rf_hpf	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rf_lpf	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rgenctrlout	:	OUT  STD_LOGIC_VECTOR (5 DOWNTO 0);
		 rhf_os	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rhyst_hf	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rhyst_lf	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rlf_os	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rrect_adj	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rrgen_bw	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rrgen_set	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rrgen_vod	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rseq_sel	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 standby	:	IN  STD_LOGIC;
		 tmxselan	:	OUT  STD_LOGIC;
		 tmxselbn	:	OUT  STD_LOGIC;
		 tmxselcn	:	OUT  STD_LOGIC;
		 tmxseldn	:	OUT  STD_LOGIC;
		 tmxselvn	:	OUT  STD_LOGIC;
		 updnn_hf	:	OUT  STD_LOGIC;
		 updnn_lf	:	OUT  STD_LOGIC;
		 vbn	:	IN  STD_LOGIC;
		 vccehxqyx	:	INOUT  STD_LOGIC;
		 vccerxqyx	:	INOUT  STD_LOGIC;
		 vctl_quiet	:	INOUT  STD_LOGIC;
		 vssexqyx	:	INOUT  STD_LOGIC
	 ); 
 END stratixiv_hssi_pma_c_adce;

 ARCHITECTURE RTL OF stratixiv_hssi_pma_c_adce IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 n0i0il69	:	STD_LOGIC := '0';
	 SIGNAL	 n0i0il70	:	STD_LOGIC := '0';
	 SIGNAL	 n0i0iO67	:	STD_LOGIC := '0';
	 SIGNAL	 n0i0iO68	:	STD_LOGIC := '0';
	 SIGNAL	 n0i0ll65	:	STD_LOGIC := '0';
	 SIGNAL	 n0i0ll66	:	STD_LOGIC := '0';
	 SIGNAL	 n0i0lO63	:	STD_LOGIC := '0';
	 SIGNAL	 n0i0lO64	:	STD_LOGIC := '0';
	 SIGNAL	 n0i10O79	:	STD_LOGIC := '0';
	 SIGNAL	 n0i10O80	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1ii77	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1ii78	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1il75	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1il76	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1iO73	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1iO74	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1li71	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1li72	:	STD_LOGIC := '0';
	 SIGNAL	 n0ii0l59	:	STD_LOGIC := '0';
	 SIGNAL	 n0ii0l60	:	STD_LOGIC := '0';
	 SIGNAL	 n0ii1i61	:	STD_LOGIC := '0';
	 SIGNAL	 n0ii1i62	:	STD_LOGIC := '0';
	 SIGNAL	 n0iiiO57	:	STD_LOGIC := '0';
	 SIGNAL	 n0iiiO58	:	STD_LOGIC := '0';
	 SIGNAL	 n0iiOi55	:	STD_LOGIC := '0';
	 SIGNAL	 n0iiOi56	:	STD_LOGIC := '0';
	 SIGNAL	 n0il0i51	:	STD_LOGIC := '0';
	 SIGNAL	 n0il0i52	:	STD_LOGIC := '0';
	 SIGNAL	 n0il0l49	:	STD_LOGIC := '0';
	 SIGNAL	 n0il0l50	:	STD_LOGIC := '0';
	 SIGNAL	 n0il1O53	:	STD_LOGIC := '0';
	 SIGNAL	 n0il1O54	:	STD_LOGIC := '0';
	 SIGNAL	 n0iliO47	:	STD_LOGIC := '0';
	 SIGNAL	 n0iliO48	:	STD_LOGIC := '0';
	 SIGNAL	 n0illi45	:	STD_LOGIC := '0';
	 SIGNAL	 n0illi46	:	STD_LOGIC := '0';
	 SIGNAL	 n0illO43	:	STD_LOGIC := '0';
	 SIGNAL	 n0illO44	:	STD_LOGIC := '0';
	 SIGNAL	 n0ilOi41	:	STD_LOGIC := '0';
	 SIGNAL	 n0ilOi42	:	STD_LOGIC := '0';
	 SIGNAL	 n0iO0O37	:	STD_LOGIC := '0';
	 SIGNAL	 n0iO0O38	:	STD_LOGIC := '0';
	 SIGNAL	 n0iO1l39	:	STD_LOGIC := '0';
	 SIGNAL	 n0iO1l40	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOii35	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOii36	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOiO33	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOiO34	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOll31	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOll32	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOlO29	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOlO30	:	STD_LOGIC := '0';
	 SIGNAL	 n0l00i1	:	STD_LOGIC := '0';
	 SIGNAL	 n0l00i2	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l00i2_w_lg_w_lg_q36w37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l00i2_w_lg_q36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l01i7	:	STD_LOGIC := '0';
	 SIGNAL	 n0l01i8	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l01i8_w_lg_w_lg_q56w57w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l01i8_w_lg_q56w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l01l5	:	STD_LOGIC := '0';
	 SIGNAL	 n0l01l6	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l01l6_w_lg_w_lg_q52w53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l01l6_w_lg_q52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l01O3	:	STD_LOGIC := '0';
	 SIGNAL	 n0l01O4	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l01O4_w_lg_w_lg_q48w49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l01O4_w_lg_q48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l10i23	:	STD_LOGIC := '0';
	 SIGNAL	 n0l10i24	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l10i24_w_lg_w_lg_q104w105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l10i24_w_lg_q104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l10l21	:	STD_LOGIC := '0';
	 SIGNAL	 n0l10l22	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l10l22_w_lg_w_lg_q100w101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l10l22_w_lg_q100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l10O19	:	STD_LOGIC := '0';
	 SIGNAL	 n0l10O20	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l10O20_w_lg_w_lg_q94w95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l10O20_w_lg_q94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l11l27	:	STD_LOGIC := '0';
	 SIGNAL	 n0l11l28	:	STD_LOGIC := '0';
	 SIGNAL	 n0l11O25	:	STD_LOGIC := '0';
	 SIGNAL	 n0l11O26	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l11O26_w_lg_w_lg_q107w108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l11O26_w_lg_q107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l1ii17	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1ii18	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l1ii18_w_lg_w_lg_q91w92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l1ii18_w_lg_q91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l1iO15	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1iO16	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1ll13	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1ll14	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1Ol11	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1Ol12	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l1Ol12_w_lg_w_lg_q72w73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l1Ol12_w_lg_q72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l1OO10	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0l1OO10_w_lg_w_lg_q62w63w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l1OO10_w_lg_q62w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l1OO9	:	STD_LOGIC := '0';
	 SIGNAL	n011O	:	STD_LOGIC := '0';
	 SIGNAL	n01il	:	STD_LOGIC := '0';
	 SIGNAL	n1O0O	:	STD_LOGIC := '0';
	 SIGNAL	n1O1l	:	STD_LOGIC := '0';
	 SIGNAL	n1Oli	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl	:	STD_LOGIC := '0';
	 SIGNAL	wire_n01ii_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_PRN	:	STD_LOGIC;
	 SIGNAL  wire_n01ii_w_lg_n1O1l250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n010i	:	STD_LOGIC := '0';
	 SIGNAL	n01li	:	STD_LOGIC := '0';
	 SIGNAL	n1O1O	:	STD_LOGIC := '0';
	 SIGNAL	n1Oii	:	STD_LOGIC := '0';
	 SIGNAL	n1Oll	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_n01iO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_PRN	:	STD_LOGIC;
	 SIGNAL	n0lili	:	STD_LOGIC := '0';
	 SIGNAL	n0liOO	:	STD_LOGIC := '0';
	 SIGNAL	n0ll0l	:	STD_LOGIC := '0';
	 SIGNAL	n0llll	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0llli_w_lg_n0lili1478w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0llli_w_lg_n0liOO1487w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0llli_w_lg_n0ll0l1498w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0llli_w_lg_n0llll1507w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0lill	:	STD_LOGIC := '0';
	 SIGNAL	n0ll0O	:	STD_LOGIC := '0';
	 SIGNAL	n0ll1i	:	STD_LOGIC := '0';
	 SIGNAL	n0llOi	:	STD_LOGIC := '0';
	 SIGNAL	n0O00O	:	STD_LOGIC := '0';
	 SIGNAL	n0O10l	:	STD_LOGIC := '0';
	 SIGNAL	n0O1li	:	STD_LOGIC := '0';
	 SIGNAL	n0O1OO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0O00l_w_lg_n0O00O1446w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0O00l_w_lg_n0O10l1417w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0O00l_w_lg_n0O1li1426w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0O00l_w_lg_n0O1OO1437w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0O01i	:	STD_LOGIC := '0';
	 SIGNAL	n0O0il	:	STD_LOGIC := '0';
	 SIGNAL	n0O10O	:	STD_LOGIC := '0';
	 SIGNAL	n0O1ll	:	STD_LOGIC := '0';
	 SIGNAL	n0Oill	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0Oili_CLK	:	STD_LOGIC;
	 SIGNAL  wire_n0Oili_w_lg_n0Oill1405w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0OiOi	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0OilO_CLK	:	STD_LOGIC;
	 SIGNAL	n0Ol0i	:	STD_LOGIC := '0';
	 SIGNAL	n0OliO	:	STD_LOGIC := '0';
	 SIGNAL	n0OlOl	:	STD_LOGIC := '0';
	 SIGNAL	n0OO0l	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0OO0i_w_lg_n0Ol0i1357w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0OO0i_w_lg_n0OliO1366w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0OO0i_w_lg_n0OlOl1377w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0OO0i_w_lg_n0OO0l1386w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0Ol0l	:	STD_LOGIC := '0';
	 SIGNAL	n0Olli	:	STD_LOGIC := '0';
	 SIGNAL	n0OlOO	:	STD_LOGIC := '0';
	 SIGNAL	n0OOii	:	STD_LOGIC := '0';
	 SIGNAL	n100i	:	STD_LOGIC := '0';
	 SIGNAL	n10li	:	STD_LOGIC := '0';
	 SIGNAL	n1i1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1i1i_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_n1i1i_w_lg_n100i276w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1i1i_w_lg_n10li285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1i1i_w_lg_n1i1l295w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n100l	:	STD_LOGIC := '0';
	 SIGNAL	n10ll	:	STD_LOGIC := '0';
	 SIGNAL	n1i0i	:	STD_LOGIC := '0';
	 SIGNAL	n1l0l	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1l0i_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_n1l0i_w_lg_n1l0l263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1l1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1l1l_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_PRN	:	STD_LOGIC;
	 SIGNAL  wire_n1l1l_w_lg_n1l1O370w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1llO	:	STD_LOGIC := '0';
	 SIGNAL	n1lOl	:	STD_LOGIC := '0';
	 SIGNAL	ni00iO	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni00il_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni00il_w_lg_ni00iO1068w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni00ll	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni00li_PRN	:	STD_LOGIC;
	 SIGNAL	ni010l	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni010i_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni010i_w_lg_ni010l1086w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni01ii	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni010O_PRN	:	STD_LOGIC;
	 SIGNAL	ni0iOi	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0ilO_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni0ilO_w_lg_ni0iOi1039w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni0iOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0iOl_PRN	:	STD_LOGIC;
	 SIGNAL	ni0O1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0O1i_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni0O1i_w_lg_ni0O1l1049w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni0O0i	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0O1O_PRN	:	STD_LOGIC;
	 SIGNAL	ni100i	:	STD_LOGIC := '0';
	 SIGNAL	ni10iO	:	STD_LOGIC := '0';
	 SIGNAL	ni10OO	:	STD_LOGIC := '0';
	 SIGNAL	ni11Ol	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni10Ol_w_lg_ni100i1305w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni10Ol_w_lg_ni10iO1316w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni10Ol_w_lg_ni10OO1325w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni10Ol_w_lg_ni11Ol1296w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni100l	:	STD_LOGIC := '0';
	 SIGNAL	ni10li	:	STD_LOGIC := '0';
	 SIGNAL	ni11OO	:	STD_LOGIC := '0';
	 SIGNAL	ni1i1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1l0l	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni1l0i_CLK	:	STD_LOGIC;
	 SIGNAL  wire_ni1l0i_w_lg_ni1l0l1284w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni1lii	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni1l0O_CLK	:	STD_LOGIC;
	 SIGNAL	ni1O1i	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni1lOO_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_ni1lOO_w_lg_ni1O1i1078w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni1O1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni1O1l_PRN	:	STD_LOGIC;
	 SIGNAL	nii0li	:	STD_LOGIC := '0';
	 SIGNAL	wire_nii0iO_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nii0iO_w_lg_nii0li939w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nii0lO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nii0ll_PRN	:	STD_LOGIC;
	 SIGNAL	nii10O	:	STD_LOGIC := '0';
	 SIGNAL	wire_nii10l_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nii10l_w_lg_nii10O1057w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nii1il	:	STD_LOGIC := '0';
	 SIGNAL	wire_nii1ii_PRN	:	STD_LOGIC;
	 SIGNAL	niiiOl	:	STD_LOGIC := '0';
	 SIGNAL	wire_niiiOi_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_niiiOi_w_lg_niiiOl940w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	niil1i	:	STD_LOGIC := '0';
	 SIGNAL	wire_niiiOO_PRN	:	STD_LOGIC;
	 SIGNAL	niiO0l	:	STD_LOGIC := '0';
	 SIGNAL	wire_niiO0i_PRN	:	STD_LOGIC;
	 SIGNAL	niiO1O	:	STD_LOGIC := '0';
	 SIGNAL	wire_niiO1l_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_niiO1l_w_lg_niiO1O937w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nl10OO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl10Ol_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nl10Ol_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nl10Ol_w_lg_nl10OO889w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nl111i	:	STD_LOGIC := '0';
	 SIGNAL	nl11ii	:	STD_LOGIC := '0';
	 SIGNAL	nl11Ol	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl11Oi_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nl11Oi_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nl11Oi_w_lg_nl111i830w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl11Oi_w_lg_nl11ii839w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl11Oi_w_lg_nl11Ol849w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nl101i	:	STD_LOGIC := '0';
	 SIGNAL	nl111l	:	STD_LOGIC := '0';
	 SIGNAL	nl11il	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl11OO_CLRN	:	STD_LOGIC;
	 SIGNAL	nl1i1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl1i1i_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nl1i1i_w_lg_nl1i1l820w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nll01O	:	STD_LOGIC := '0';
	 SIGNAL	wire_nll01l_PRN	:	STD_LOGIC;
	 SIGNAL	nll01i	:	STD_LOGIC := '0';
	 SIGNAL	wire_nll1OO_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nll1OO_w_lg_nll01i353w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlli0l	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlli0i_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nlli0i_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nlli0i_w_lg_nlli0l361w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlliii	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlli0O_PRN	:	STD_LOGIC;
	 SIGNAL	nllliO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlllil_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nlllil_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nlllil_w_lg_w_lg_w_lg_nllliO341w342w346w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllil_w_lg_w_lg_nllliO343w344w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllil_w_lg_nllliO341w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllil_w_lg_w_lg_w_lg_w_lg_nllliO341w342w346w347w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllil_w_lg_w_lg_w_lg_nllliO343w344w345w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllil_w_lg_w_lg_nllliO341w342w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllil_w_lg_nllliO343w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlllll	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlllli_PRN	:	STD_LOGIC;
	 SIGNAL	nllOOi	:	STD_LOGIC := '0';
	 SIGNAL	wire_nllOlO_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nllOlO_w_lg_w_lg_w_lg_nllOOi312w313w317w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOlO_w_lg_w_lg_nllOOi314w315w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOlO_w_lg_nllOOi312w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOlO_w_lg_w_lg_w_lg_w_lg_nllOOi312w313w317w318w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOlO_w_lg_w_lg_w_lg_nllOOi314w315w316w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOlO_w_lg_w_lg_nllOOi312w313w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOlO_w_lg_nllOOi314w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nllOOO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nllOOl_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nllOOl_PRN	:	STD_LOGIC;
	 SIGNAL	nlO01l	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO01i_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nlO01i_w_lg_nlO01l324w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlO00i	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlO01O_PRN	:	STD_LOGIC;
	 SIGNAL	nlOi0O	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlOi0l_CLRN	:	STD_LOGIC;
	 SIGNAL  wire_nlOi0l_w_lg_nlOi0O332w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlOiil	:	STD_LOGIC := '0';
	 SIGNAL	wire_nlOiii_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_PRN	:	STD_LOGIC;
	 SIGNAL  wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00il_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_hflck_range213w225w230w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00iO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w223w229w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00li_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_hflck_range213w221w228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00ll_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w217w227w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00lO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_hflck_range213w225w226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00Oi_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w223w224w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00Ol_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_hflck_range213w221w222w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00OO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w217w220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010l_w_lg_dataout234w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_vcc	:	STD_LOGIC;
	 SIGNAL  wire_n011i_w_lg_dataout243w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0ili_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_lflck_range186w198w203w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0ill_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w196w202w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0ilO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_lflck_range186w194w201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0iOi_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w190w200w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0iOl_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_lflck_range186w198w199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0iOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0iOO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w196w197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0l1i_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_radce_lflck_range186w194w195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0l1l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w190w193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0liil_w_lg_dataout1524w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0liil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0liOi_w_lg_dataout1521w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0liOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0ll1O_w_lg_dataout1518w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ll1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0llil_w_lg_dataout1515w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0llil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0O01O_w_lg_dataout1454w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0O01O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0O11O_w_lg_dataout1463w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0O11O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0O1il_w_lg_dataout1460w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0O1il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0O1Oi_w_lg_dataout1457w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0O1Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0Ol1l_w_lg_dataout1403w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0Ol1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0Olii_w_lg_dataout1400w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0Olii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0OllO_w_lg_dataout1397w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0OllO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0OO1l_w_lg_dataout1394w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0OO1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n101l_w_lg_dataout310w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n101l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n10il_w_lg_dataout309w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n10Ol_w_lg_dataout303w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1lOO_w_lg_dataout251w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1O0i_w_lg_dataout249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1Oil_w_lg_dataout247w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1OlO_w_lg_dataout245w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni00lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni00Ol_w_lg_dataout1235w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni00Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01i_datain	:	STD_LOGIC;
	 SIGNAL  wire_n0l11l28_w_lg_w_lg_q110w111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01i_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl1llO_w123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01li_w_lg_dataout1254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01Oi_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl1lOi_w_lg_w_dataout_range33w252w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni01OO_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni0i0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0i0i_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni0i1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0i1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0i1l_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni0i1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0l0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0l0l_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOiil_w_lg_w_dataout_range1099w1100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0l0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0l1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0l1O_w_lg_dataout1216w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0l1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0lii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0lii_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni0lil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0O0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oii_w_lg_dataout1197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0Oii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0OiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0OiO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOl0O_w_lg_w_dataout_range1097w1098w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0Oli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oll_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni0OlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni101l_w_lg_dataout1339w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni10ii_w_lg_dataout1336w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni10ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni10lO_w_lg_dataout1333w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni10lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni11lO_w_lg_dataout1342w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni11lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1ii_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1il_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl1llO_w_lg_w_lg_w_dataout_range35w137w148w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1iO_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl1llO_w_lg_w_lg_w_lg_w_dataout_range35w112w146w147w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1li_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1ll_oe	:	STD_LOGIC;
	 SIGNAL  wire_n0iO1l40_w_lg_w_lg_q142w143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1lO_datain	:	STD_LOGIC;
	 SIGNAL  wire_n0iO0O38_w_lg_w_lg_q134w135w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1lO_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni1O0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1O0O_w_lg_dataout1273w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oi_oe	:	STD_LOGIC;
	 SIGNAL  wire_n0iOii36_w_lg_w_lg_q132w133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1Oil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1OiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1OiO_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1Ol_oe	:	STD_LOGIC;
	 SIGNAL  wire_n0iOiO34_w_lg_w_lg_q127w128w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1Oli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oll_oe	:	STD_LOGIC;
	 SIGNAL  wire_ni1OO_datain	:	STD_LOGIC;
	 SIGNAL  wire_n0iOll32_w_lg_w_lg_q124w125w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1OO_oe	:	STD_LOGIC;
	 SIGNAL  wire_nii01i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii0Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii0OO_w_lg_dataout1153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii1iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii1ll_w_lg_dataout1175w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii1Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii1Oi_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOO0i_w_lg_w_dataout_range1095w1096w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii1OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii1OO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niii0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niii0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niii0l_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl1llO_w_lg_w_dataout_range35w112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niii1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niii1O_oe	:	STD_LOGIC;
	 SIGNAL  wire_niil0i_w_lg_dataout1134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niil0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niil0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niil1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niilii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niilii_oe	:	STD_LOGIC;
	 SIGNAL  wire_niilil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiliO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiliO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niiO0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiOil_w_lg_dataout1115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiOli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiOll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiOll_oe	:	STD_LOGIC;
	 SIGNAL  wire_niiOlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiOOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiOOi_oe	:	STD_LOGIC;
	 SIGNAL  wire_nil01l_w_lg_dataout1075w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil01l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nil10l_w_lg_dataout1083w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil10l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nil1ii_w_lg_dataout1065w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil1ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nil1iO_w_lg_dataout1036w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil1iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nil1ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nil1Oi_w_lg_dataout1046w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil1Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nil1OO_w_lg_dataout1054w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil1OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO0ll_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqa_set_range800w801w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO0ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO0ll_oe	:	STD_LOGIC;
	 SIGNAL  wire_niO0lO_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqb_set_range756w757w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO0lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO0lO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niO0Oi_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqc_set_range702w703w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO0Oi_oe	:	STD_LOGIC;
	 SIGNAL  wire_niO0Ol_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqd_set_range647w648w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO0Ol_oe	:	STD_LOGIC;
	 SIGNAL  wire_niO0OO_datain	:	STD_LOGIC;
	 SIGNAL  wire_niO0OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO0OO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOi0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOi0i_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOi0l_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqv_set_range596w601w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOi0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOi0l_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOi0O_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOi0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOi1i_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOi1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOi1i_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOi1l_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOi1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOi1O_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOi1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOiiO_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOiiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOiiO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOili_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOili_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOili_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOill_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOill_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOill_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOilO_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOilO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOilO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOiOi_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOiOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOiOi_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOiOl_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOiOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOiOl_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOiOO_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOiOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOl0i_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOl0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOl1i_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOl1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOl1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOl1l_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOl1O_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOl1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOl1O_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOlii_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqa_set_range805w806w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOlii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlii_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOlil_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqb_set_range761w762w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOlil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlil_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOliO_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqc_set_range707w708w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOliO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOliO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOlli_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqd_set_range652w653w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOlli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlli_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOlll_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOlll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlll_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOllO_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOllO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOllO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOlOi_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOlOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlOl_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOlOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOlOO_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOO0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOO1i_datain	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_eqv_set_range599w609w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOO1i_oe	:	STD_LOGIC;
	 SIGNAL  wire_niOO1l_datain	:	STD_LOGIC;
	 SIGNAL  wire_niOO1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOOlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOOOl_w_lg_dataout866w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOOOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nl000i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl000i_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w760w770w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl000l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl000l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqb_set_range756w768w769w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl000O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl000O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w766w767w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl001i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl001i_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqb_set_range756w768w773w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl001l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl001l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w766w772w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl001O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl001O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqb_set_range756w764w771w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl00ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl00ii_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqb_set_range756w764w765w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl00il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl00il_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w760w763w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl00li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl00li_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_radce_adapt746w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl00ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl00ll_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_radce_adapt537w538w745w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl00lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl00lO_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl00Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl00Oi_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_n0i01O734w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl00Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0lll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0lll_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqc_set_range702w714w719w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0llO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0llO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w712w718w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0lOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0lOi_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqc_set_range702w710w717w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0lOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0lOl_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w706w716w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0lOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0lOO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqc_set_range702w714w715w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0O0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0O0l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_radce_adapt692w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0O0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0O0O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_radce_adapt537w538w691w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0O1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0O1i_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w712w713w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0O1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0O1l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqc_set_range702w710w711w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0O1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0O1O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w706w709w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0Oii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0Oii_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl0Oil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0Oil_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_n0i00i680w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl110l_w_lg_dataout865w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl110l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl111O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl11iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl11ll_w_lg_dataout857w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl11ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1i0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1i1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1l0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1l0i_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w810w816w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1l0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1l0l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqa_set_range800w808w815w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1l0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1l0O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w804w814w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1l1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1l1O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqa_set_range800w812w817w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1lii_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqa_set_range800w812w813w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1lil_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w810w811w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1liO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1liO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqa_set_range800w808w809w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1lli_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w804w807w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1lOl_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_radce_adapt786w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1lOO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_radce_adapt537w538w785w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1O1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1O1i_oe	:	STD_LOGIC;
	 SIGNAL  wire_nl1O1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1O1l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_n0i01i781w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1O1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli00i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli00i_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqd_set_range647w655w662w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli00l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli00l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w651w661w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli00O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli00O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqd_set_range647w659w660w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli01l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli01l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqd_set_range647w659w664w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli01O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli01O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w657w663w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0ii_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w657w658w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0il_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqd_set_range647w655w656w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0iO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w651w654w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0ll_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_radce_adapt637w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0lO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_radce_adapt537w538w636w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0Oi_oe	:	STD_LOGIC;
	 SIGNAL  wire_nli0Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0Ol_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_n0i00O631w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0OO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOil_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w607w613w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliOiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOiO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqv_set_range596w605w612w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliOli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOli_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w602w611w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliOll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOll_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqv_set_range596w598w610w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliOlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOlO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w607w608w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliOOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOOi_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqv_set_range596w605w606w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliOOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOOl_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w602w603w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliOOO_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_eqv_set_range596w598w600w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll00i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll00O_w_lg_dataout503w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll00O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll0il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll0iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll0iO_oe	:	STD_LOGIC;
	 SIGNAL  wire_nll0li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll0ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll0ll_oe	:	STD_LOGIC;
	 SIGNAL  wire_nll10i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll10i_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_radce_adapt537w538w564w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll11l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll11l_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_radce_adapt586w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll11O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll11O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_lg_radce_adapt565w566w585w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlliil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllili_w_lg_dataout480w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllili_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllilO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlliOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlliOi_oe	:	STD_LOGIC;
	 SIGNAL  wire_nlliOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlliOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlliOO_oe	:	STD_LOGIC;
	 SIGNAL  wire_nllllO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlllOl_w_lg_dataout459w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllO0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllO0i_oe	:	STD_LOGIC;
	 SIGNAL  wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllO1l_oe	:	STD_LOGIC;
	 SIGNAL  wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO0ii_w_lg_dataout415w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO0li_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_radce_vod_int_range408w409w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO0lO_oe	:	STD_LOGIC;
	 SIGNAL  wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO10O_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_radce_vod_int_range431w432w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO11O_w_lg_dataout438w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO1il_oe	:	STD_LOGIC;
	 SIGNAL  wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOill_w_lg_dataout392w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOiOl_oe	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_radce_vod_int_range382w383w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOl1i_oe	:	STD_LOGIC;
	 SIGNAL  wire_nlOlil_w_lg_dataout358w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOlli_w_lg_dataout340w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOllO_w_lg_dataout311w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOlOl_w_lg_dataout321w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOO1i_w_lg_dataout329w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOO1O_w_lg_dataout350w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Olil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0i1i_datain	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0i1i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l1O_datain	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n0l1O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni001i_w_lg_w_dataout_range1257w1258w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni001i_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni001i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni001i_w_dataout_range1257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni001l_w_lg_w_dataout_range1256w1259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni001l_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni001l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni001l_w_dataout_range1256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01l_datain	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni01l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01l_w_dataout_range82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01O_datain	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni01O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni01O_w_dataout_range77w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0i0l_w_lg_w_dataout_range1238w1239w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0i0l_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0i0l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0i0l_w_dataout_range1238w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0i0O_w_lg_w_dataout_range1237w1240w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0i0O_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0i0O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0i0O_w_dataout_range1237w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0liO_w_lg_w_dataout_range1219w1220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0liO_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0liO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0liO_w_dataout_range1219w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0ll_datain	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0ll_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0lli_w_lg_w_dataout_range1218w1221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0lli_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0lli_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0lli_w_dataout_range1218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0lO_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0lO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0Ol_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0Ol_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOi_w_lg_w_dataout_range1200w1201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOi_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0OOi_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOi_w_dataout_range1200w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOl_w_lg_w_dataout_range1199w1202w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOl_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0OOl_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OOl_w_dataout_range1199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1OlO_w_lg_w_dataout_range1276w1277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1OlO_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni1OlO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1OlO_w_dataout_range1276w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1OOi_w_lg_w_dataout_range1275w1278w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1OOi_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni1OOi_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1OOi_w_dataout_range1275w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii01l_w_lg_w_dataout_range1178w1179w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii01l_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii01l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii01l_w_dataout_range1178w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii01O_w_lg_w_dataout_range1177w1180w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii01O_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii01O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii01O_w_dataout_range1177w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0i_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0l_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii0l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0O_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii0O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1i_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1l_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1O_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii0O_w_lg_w_dataout_range1156w1157w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii0O_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niii0O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii0O_w_dataout_range1156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiiii_w_lg_w_dataout_range1155w1158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiiii_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiiii_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiiii_w_dataout_range1155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilli_w_lg_w_dataout_range1137w1138w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilli_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilli_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilli_w_dataout_range1137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilll_w_lg_w_dataout_range1136w1139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilll_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niilll_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilll_w_dataout_range1136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOOl_w_lg_w_dataout_range1118w1119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOOl_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiOOl_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOOl_w_dataout_range1118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOOO_w_lg_w_dataout_range1117w1120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOOO_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_niiOOO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOOO_w_dataout_range1117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOiii_datain	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_niOiii_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOiil_datain	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niOiil_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOl0l_datain	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_niOl0l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOl0O_datain	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niOl0O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO0i_datain	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niOO0i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO1O_datain	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_niOO1O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl00iO_datain	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl00iO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i1i_datain	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0i1i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0O0i_datain	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl0O0i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0Oll_datain	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0Oll_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lll_datain	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1lll_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_w_lg_w_dataout_range35w348w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_w_lg_w_dataout_range35w319w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_w_lg_w_dataout_range35w144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_w_lg_w_dataout_range35w137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_w_lg_w_dataout_range35w130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1llO_w_dataout_range35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lOi_datain	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1lOi_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1O0l_datain	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl1O0l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0li_datain	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0li_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlii1l_datain	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlii1l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll0lO_w_lg_w_dataout_range510w511w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll0lO_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll0lO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll0lO_w_dataout_range510w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll0Oi_w_lg_w_dataout_range505w512w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll0Oi_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nll0Oi_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll0Oi_w_dataout_range505w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll11i_datain	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nll11i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll1i_w_lg_w_dataout_range487w488w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll1i_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll1i_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll1i_w_dataout_range487w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll1l_w_lg_w_dataout_range482w489w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll1l_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll1l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll1l_w_dataout_range482w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllO0l_w_lg_w_dataout_range464w465w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllO0l_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllO0l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllO0l_w_dataout_range464w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllO0O_w_lg_w_dataout_range461w466w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllO0O_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllO0O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllO0O_w_dataout_range461w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0Oi_w_lg_w_dataout_range420w421w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0Oi_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO0Oi_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0Oi_w_dataout_range420w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0Ol_w_lg_w_dataout_range417w422w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0Ol_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO0Ol_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO0Ol_w_dataout_range417w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO1iO_w_lg_w_dataout_range443w444w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO1iO_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO1iO_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO1iO_w_dataout_range443w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO1li_w_lg_w_dataout_range442w445w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO1li_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlO1li_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO1li_w_dataout_range442w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOl1l_w_lg_w_dataout_range397w398w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOl1l_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlOl1l_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOl1l_w_dataout_range397w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOl1O_w_lg_w_dataout_range396w399w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOl1O_datain	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlOl1O_dataout	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlOl1O_w_dataout_range396w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n00OOi1030w1031w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i10i1022w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i11O1015w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1OO968w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0ii1019w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0ii1012w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l1Oi83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l1Oi78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0liii258w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_radce_adapt539w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqa_set_range800w808w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqb_set_range756w764w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqc_set_range702w710w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqd_set_range647w655w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqv_set_range596w605w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range213w221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1413w1418w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1422w1427w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1433w1438w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1442w1447w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1474w1479w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1483w1488w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1494w1499w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range1503w1508w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range186w194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1292w1297w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1301w1306w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1312w1317w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1321w1326w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1353w1358w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1362w1367w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1373w1378w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range1382w1387w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rclkdiv_range154w164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rclkdiv_range149w152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rhyst_hf_range826w831w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rhyst_hf_range835w840w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rhyst_hf_range845w850w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rhyst_lf_range272w277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rhyst_lf_range281w286w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rhyst_lf_range291w296w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rseq_sel_range541w556w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rseq_sel_range543w997w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rseq_sel_range543w675w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rseq_sel_range543w684w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_radce_adapt255w256w257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_fixed_clk253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_lock_lf_ovd1279w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n000il1522w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n000iO1519w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n000ll1461w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n000lO1458w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n000OO1409w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00i0i1340w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00i0l1337w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00i1i1401w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00i1l1398w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00iil1288w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00iiO1274w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00ili1255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00ill1269w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00ilO1268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00iOi1236w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00iOl1250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00iOO1249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00l0i1198w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00l0l1212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00l0O1211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00l1i1217w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00l1l1231w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00l1O1230w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00lii1176w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00lil1193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00liO1192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00lli1154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00lll1135w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00llO1149w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00lOi1148w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00lOl1116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00lOO1130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00O0i969w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00O0l967w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00O0O959w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00O1i1129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00O1l1113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00Oii956w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00Oil951w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00OiO948w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00Oli909w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00Oll908w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00OlO1032w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00OOi1030w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00OOl907w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n00OOO906w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i00i681w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i00l623w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i00O632w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i01i782w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i01l728w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i01O735w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0ii551w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0li504w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0Oi481w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0Ol499w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0OO498w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i10i872w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i10l868w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i11i991w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i11l880w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i11O875w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1ll862w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1lO819w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii0i475w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii0O440w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii1l460w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii1O476w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iiii455w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iiil454w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iili416w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iill434w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iilO433w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iiOl394w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iiOO411w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0il0O306w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0il1i410w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0il1l390w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ilii262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ilOl248w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ilOO244w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iO0i138w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iO0l136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iO1i246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iO1O140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOil129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOli126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOOl116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOOO114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l00l31w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0ii30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0il540w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0iO549w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0li547w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0ll570w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0lO264w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0OO1290w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l11i113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0li0i821w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0li1O1411w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_radce_adapt255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_radce_pdb536w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_radce_rstb267w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqa_set_range802w803w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqb_set_range758w759w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqc_set_range704w705w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqd_set_range649w650w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_eqv_set_range597w604w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_hflck_range215w216w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_radce_lflck_range188w189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rclkdiv_range155w163w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rclkdiv_range150w151w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rseq_sel_range543w555w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n0l0ll570w571w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n0l0ll570w671w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_radce_adapt255w256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0ii683w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rseq_sel_range541w965w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n000il :	STD_LOGIC;
	 SIGNAL  n000iO :	STD_LOGIC;
	 SIGNAL  n000li :	STD_LOGIC;
	 SIGNAL  n000ll :	STD_LOGIC;
	 SIGNAL  n000lO :	STD_LOGIC;
	 SIGNAL  n000Oi :	STD_LOGIC;
	 SIGNAL  n000Ol :	STD_LOGIC;
	 SIGNAL  n000OO :	STD_LOGIC;
	 SIGNAL  n00i0i :	STD_LOGIC;
	 SIGNAL  n00i0l :	STD_LOGIC;
	 SIGNAL  n00i0O :	STD_LOGIC;
	 SIGNAL  n00i1i :	STD_LOGIC;
	 SIGNAL  n00i1l :	STD_LOGIC;
	 SIGNAL  n00i1O :	STD_LOGIC;
	 SIGNAL  n00iii :	STD_LOGIC;
	 SIGNAL  n00iil :	STD_LOGIC;
	 SIGNAL  n00iiO :	STD_LOGIC;
	 SIGNAL  n00ili :	STD_LOGIC;
	 SIGNAL  n00ill :	STD_LOGIC;
	 SIGNAL  n00ilO :	STD_LOGIC;
	 SIGNAL  n00iOi :	STD_LOGIC;
	 SIGNAL  n00iOl :	STD_LOGIC;
	 SIGNAL  n00iOO :	STD_LOGIC;
	 SIGNAL  n00l0i :	STD_LOGIC;
	 SIGNAL  n00l0l :	STD_LOGIC;
	 SIGNAL  n00l0O :	STD_LOGIC;
	 SIGNAL  n00l1i :	STD_LOGIC;
	 SIGNAL  n00l1l :	STD_LOGIC;
	 SIGNAL  n00l1O :	STD_LOGIC;
	 SIGNAL  n00lii :	STD_LOGIC;
	 SIGNAL  n00lil :	STD_LOGIC;
	 SIGNAL  n00liO :	STD_LOGIC;
	 SIGNAL  n00lli :	STD_LOGIC;
	 SIGNAL  n00lll :	STD_LOGIC;
	 SIGNAL  n00llO :	STD_LOGIC;
	 SIGNAL  n00lOi :	STD_LOGIC;
	 SIGNAL  n00lOl :	STD_LOGIC;
	 SIGNAL  n00lOO :	STD_LOGIC;
	 SIGNAL  n00O0i :	STD_LOGIC;
	 SIGNAL  n00O0l :	STD_LOGIC;
	 SIGNAL  n00O0O :	STD_LOGIC;
	 SIGNAL  n00O1i :	STD_LOGIC;
	 SIGNAL  n00O1l :	STD_LOGIC;
	 SIGNAL  n00O1O :	STD_LOGIC;
	 SIGNAL  n00Oii :	STD_LOGIC;
	 SIGNAL  n00Oil :	STD_LOGIC;
	 SIGNAL  n00OiO :	STD_LOGIC;
	 SIGNAL  n00Oli :	STD_LOGIC;
	 SIGNAL  n00Oll :	STD_LOGIC;
	 SIGNAL  n00OlO :	STD_LOGIC;
	 SIGNAL  n00OOi :	STD_LOGIC;
	 SIGNAL  n00OOl :	STD_LOGIC;
	 SIGNAL  n00OOO :	STD_LOGIC;
	 SIGNAL  n0i00i :	STD_LOGIC;
	 SIGNAL  n0i00l :	STD_LOGIC;
	 SIGNAL  n0i00O :	STD_LOGIC;
	 SIGNAL  n0i01i :	STD_LOGIC;
	 SIGNAL  n0i01l :	STD_LOGIC;
	 SIGNAL  n0i01O :	STD_LOGIC;
	 SIGNAL  n0i0ii :	STD_LOGIC;
	 SIGNAL  n0i0li :	STD_LOGIC;
	 SIGNAL  n0i0Oi :	STD_LOGIC;
	 SIGNAL  n0i0Ol :	STD_LOGIC;
	 SIGNAL  n0i0OO :	STD_LOGIC;
	 SIGNAL  n0i10i :	STD_LOGIC;
	 SIGNAL  n0i10l :	STD_LOGIC;
	 SIGNAL  n0i11i :	STD_LOGIC;
	 SIGNAL  n0i11l :	STD_LOGIC;
	 SIGNAL  n0i11O :	STD_LOGIC;
	 SIGNAL  n0i1ll :	STD_LOGIC;
	 SIGNAL  n0i1lO :	STD_LOGIC;
	 SIGNAL  n0i1Oi :	STD_LOGIC;
	 SIGNAL  n0i1Ol :	STD_LOGIC;
	 SIGNAL  n0i1OO :	STD_LOGIC;
	 SIGNAL  n0ii0i :	STD_LOGIC;
	 SIGNAL  n0ii0O :	STD_LOGIC;
	 SIGNAL  n0ii1l :	STD_LOGIC;
	 SIGNAL  n0ii1O :	STD_LOGIC;
	 SIGNAL  n0iiii :	STD_LOGIC;
	 SIGNAL  n0iiil :	STD_LOGIC;
	 SIGNAL  n0iili :	STD_LOGIC;
	 SIGNAL  n0iill :	STD_LOGIC;
	 SIGNAL  n0iilO :	STD_LOGIC;
	 SIGNAL  n0iiOl :	STD_LOGIC;
	 SIGNAL  n0iiOO :	STD_LOGIC;
	 SIGNAL  n0il0O :	STD_LOGIC;
	 SIGNAL  n0il1i :	STD_LOGIC;
	 SIGNAL  n0il1l :	STD_LOGIC;
	 SIGNAL  n0ilii :	STD_LOGIC;
	 SIGNAL  n0ilil :	STD_LOGIC;
	 SIGNAL  n0illl :	STD_LOGIC;
	 SIGNAL  n0ilOl :	STD_LOGIC;
	 SIGNAL  n0ilOO :	STD_LOGIC;
	 SIGNAL  n0iO0i :	STD_LOGIC;
	 SIGNAL  n0iO0l :	STD_LOGIC;
	 SIGNAL  n0iO1i :	STD_LOGIC;
	 SIGNAL  n0iO1O :	STD_LOGIC;
	 SIGNAL  n0iOil :	STD_LOGIC;
	 SIGNAL  n0iOli :	STD_LOGIC;
	 SIGNAL  n0iOOl :	STD_LOGIC;
	 SIGNAL  n0iOOO :	STD_LOGIC;
	 SIGNAL  n0l00l :	STD_LOGIC;
	 SIGNAL  n0l00O :	STD_LOGIC;
	 SIGNAL  n0l0ii :	STD_LOGIC;
	 SIGNAL  n0l0il :	STD_LOGIC;
	 SIGNAL  n0l0iO :	STD_LOGIC;
	 SIGNAL  n0l0li :	STD_LOGIC;
	 SIGNAL  n0l0ll :	STD_LOGIC;
	 SIGNAL  n0l0lO :	STD_LOGIC;
	 SIGNAL  n0l0Oi :	STD_LOGIC;
	 SIGNAL  n0l0Ol :	STD_LOGIC;
	 SIGNAL  n0l0OO :	STD_LOGIC;
	 SIGNAL  n0l11i :	STD_LOGIC;
	 SIGNAL  n0l1il :	STD_LOGIC;
	 SIGNAL  n0l1Oi :	STD_LOGIC;
	 SIGNAL  n0li0i :	STD_LOGIC;
	 SIGNAL  n0li1i :	STD_LOGIC;
	 SIGNAL  n0li1l :	STD_LOGIC;
	 SIGNAL  n0li1O :	STD_LOGIC;
	 SIGNAL  n0liii :	STD_LOGIC;
	 SIGNAL  wire_w_eqa_set_range800w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqa_set_range802w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqb_set_range756w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqb_set_range758w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqc_set_range702w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqc_set_range704w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqd_set_range647w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqd_set_range649w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqv_set_range596w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_eqv_set_range597w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range213w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1413w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1422w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1433w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1442w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1474w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1483w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1494w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_hflck_range1503w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1292w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1301w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1312w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1321w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range188w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1353w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1362w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1373w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_radce_lflck_range1382w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rclkdiv_range154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rclkdiv_range155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rclkdiv_range149w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rclkdiv_range150w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rhyst_hf_range826w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rhyst_hf_range835w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rhyst_hf_range845w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rhyst_lf_range272w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rhyst_lf_range281w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rhyst_lf_range291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rseq_sel_range541w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rseq_sel_range543w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_vcc <= '1';
	wire_w_lg_w_lg_n00OOi1030w1031w(0) <= wire_w_lg_n00OOi1030w(0) AND n00OOO;
	wire_w_lg_n0i10i1022w(0) <= n0i10i AND wire_w_lg_n0l0li547w(0);
	wire_w_lg_n0i11O1015w(0) <= n0i11O AND wire_w_lg_n0l0iO549w(0);
	wire_w_lg_n0i1OO968w(0) <= n0i1OO AND wire_w_lg_n00O0l967w(0);
	wire_w_lg_n0l0ii1019w(0) <= n0l0ii AND wire_w_lg_n0i10i872w(0);
	wire_w_lg_n0l0ii1012w(0) <= n0l0ii AND wire_w_lg_n0i11O875w(0);
	wire_w_lg_n0l1Oi83w(0) <= n0l1Oi AND wire_ni01l_w_dataout_range82w(0);
	wire_w_lg_n0l1Oi78w(0) <= n0l1Oi AND wire_ni01O_w_dataout_range77w(0);
	wire_w_lg_n0liii258w(0) <= n0liii AND wire_w_lg_w_lg_w_lg_radce_adapt255w256w257w(0);
	wire_w_lg_radce_adapt539w(0) <= radce_adapt AND wire_w_lg_n0l0ii30w(0);
	wire_w_lg_w_eqa_set_range800w808w(0) <= wire_w_eqa_set_range800w(0) AND wire_w_lg_w_eqa_set_range802w803w(0);
	wire_w_lg_w_eqb_set_range756w764w(0) <= wire_w_eqb_set_range756w(0) AND wire_w_lg_w_eqb_set_range758w759w(0);
	wire_w_lg_w_eqc_set_range702w710w(0) <= wire_w_eqc_set_range702w(0) AND wire_w_lg_w_eqc_set_range704w705w(0);
	wire_w_lg_w_eqd_set_range647w655w(0) <= wire_w_eqd_set_range647w(0) AND wire_w_lg_w_eqd_set_range649w650w(0);
	wire_w_lg_w_eqv_set_range596w605w(0) <= wire_w_eqv_set_range596w(0) AND wire_w_lg_w_eqv_set_range597w604w(0);
	wire_w_lg_w_radce_hflck_range213w221w(0) <= wire_w_radce_hflck_range213w(0) AND wire_w_lg_w_radce_hflck_range215w216w(0);
	wire_w_lg_w_radce_hflck_range1413w1418w(0) <= wire_w_radce_hflck_range1413w(0) AND wire_n0O00l_w_lg_n0O10l1417w(0);
	wire_w_lg_w_radce_hflck_range1422w1427w(0) <= wire_w_radce_hflck_range1422w(0) AND wire_n0O00l_w_lg_n0O1li1426w(0);
	wire_w_lg_w_radce_hflck_range1433w1438w(0) <= wire_w_radce_hflck_range1433w(0) AND wire_n0O00l_w_lg_n0O1OO1437w(0);
	wire_w_lg_w_radce_hflck_range1442w1447w(0) <= wire_w_radce_hflck_range1442w(0) AND wire_n0O00l_w_lg_n0O00O1446w(0);
	wire_w_lg_w_radce_hflck_range1474w1479w(0) <= wire_w_radce_hflck_range1474w(0) AND wire_n0llli_w_lg_n0lili1478w(0);
	wire_w_lg_w_radce_hflck_range1483w1488w(0) <= wire_w_radce_hflck_range1483w(0) AND wire_n0llli_w_lg_n0liOO1487w(0);
	wire_w_lg_w_radce_hflck_range1494w1499w(0) <= wire_w_radce_hflck_range1494w(0) AND wire_n0llli_w_lg_n0ll0l1498w(0);
	wire_w_lg_w_radce_hflck_range1503w1508w(0) <= wire_w_radce_hflck_range1503w(0) AND wire_n0llli_w_lg_n0llll1507w(0);
	wire_w_lg_w_radce_lflck_range186w194w(0) <= wire_w_radce_lflck_range186w(0) AND wire_w_lg_w_radce_lflck_range188w189w(0);
	wire_w_lg_w_radce_lflck_range1292w1297w(0) <= wire_w_radce_lflck_range1292w(0) AND wire_ni10Ol_w_lg_ni11Ol1296w(0);
	wire_w_lg_w_radce_lflck_range1301w1306w(0) <= wire_w_radce_lflck_range1301w(0) AND wire_ni10Ol_w_lg_ni100i1305w(0);
	wire_w_lg_w_radce_lflck_range1312w1317w(0) <= wire_w_radce_lflck_range1312w(0) AND wire_ni10Ol_w_lg_ni10iO1316w(0);
	wire_w_lg_w_radce_lflck_range1321w1326w(0) <= wire_w_radce_lflck_range1321w(0) AND wire_ni10Ol_w_lg_ni10OO1325w(0);
	wire_w_lg_w_radce_lflck_range1353w1358w(0) <= wire_w_radce_lflck_range1353w(0) AND wire_n0OO0i_w_lg_n0Ol0i1357w(0);
	wire_w_lg_w_radce_lflck_range1362w1367w(0) <= wire_w_radce_lflck_range1362w(0) AND wire_n0OO0i_w_lg_n0OliO1366w(0);
	wire_w_lg_w_radce_lflck_range1373w1378w(0) <= wire_w_radce_lflck_range1373w(0) AND wire_n0OO0i_w_lg_n0OlOl1377w(0);
	wire_w_lg_w_radce_lflck_range1382w1387w(0) <= wire_w_radce_lflck_range1382w(0) AND wire_n0OO0i_w_lg_n0OO0l1386w(0);
	wire_w_lg_w_rclkdiv_range154w164w(0) <= wire_w_rclkdiv_range154w(0) AND wire_w_lg_w_rclkdiv_range155w163w(0);
	wire_w_lg_w_rclkdiv_range149w152w(0) <= wire_w_rclkdiv_range149w(0) AND wire_w_lg_w_rclkdiv_range150w151w(0);
	wire_w_lg_w_rhyst_hf_range826w831w(0) <= wire_w_rhyst_hf_range826w(0) AND wire_nl11Oi_w_lg_nl111i830w(0);
	wire_w_lg_w_rhyst_hf_range835w840w(0) <= wire_w_rhyst_hf_range835w(0) AND wire_nl11Oi_w_lg_nl11ii839w(0);
	wire_w_lg_w_rhyst_hf_range845w850w(0) <= wire_w_rhyst_hf_range845w(0) AND wire_nl11Oi_w_lg_nl11Ol849w(0);
	wire_w_lg_w_rhyst_lf_range272w277w(0) <= wire_w_rhyst_lf_range272w(0) AND wire_n1i1i_w_lg_n100i276w(0);
	wire_w_lg_w_rhyst_lf_range281w286w(0) <= wire_w_rhyst_lf_range281w(0) AND wire_n1i1i_w_lg_n10li285w(0);
	wire_w_lg_w_rhyst_lf_range291w296w(0) <= wire_w_rhyst_lf_range291w(0) AND wire_n1i1i_w_lg_n1i1l295w(0);
	wire_w_lg_w_rseq_sel_range541w556w(0) <= wire_w_rseq_sel_range541w(0) AND wire_w_lg_w_rseq_sel_range543w555w(0);
	wire_w_lg_w_rseq_sel_range543w997w(0) <= wire_w_rseq_sel_range543w(0) AND wire_w_lg_n00Oii956w(0);
	wire_w_lg_w_rseq_sel_range543w675w(0) <= wire_w_rseq_sel_range543w(0) AND wire_w_lg_w_lg_n0l0ll570w571w(0);
	wire_w_lg_w_rseq_sel_range543w684w(0) <= wire_w_rseq_sel_range543w(0) AND wire_w_lg_n0l0ii683w(0);
	wire_w_lg_w_lg_w_lg_radce_adapt255w256w257w(0) <= NOT wire_w_lg_w_lg_radce_adapt255w256w(0);
	wire_w_lg_fixed_clk253w(0) <= NOT fixed_clk;
	wire_w_lg_lock_lf_ovd1279w(0) <= NOT lock_lf_ovd;
	wire_w_lg_n000il1522w(0) <= NOT n000il;
	wire_w_lg_n000iO1519w(0) <= NOT n000iO;
	wire_w_lg_n000ll1461w(0) <= NOT n000ll;
	wire_w_lg_n000lO1458w(0) <= NOT n000lO;
	wire_w_lg_n000OO1409w(0) <= NOT n000OO;
	wire_w_lg_n00i0i1340w(0) <= NOT n00i0i;
	wire_w_lg_n00i0l1337w(0) <= NOT n00i0l;
	wire_w_lg_n00i1i1401w(0) <= NOT n00i1i;
	wire_w_lg_n00i1l1398w(0) <= NOT n00i1l;
	wire_w_lg_n00iil1288w(0) <= NOT n00iil;
	wire_w_lg_n00iiO1274w(0) <= NOT n00iiO;
	wire_w_lg_n00ili1255w(0) <= NOT n00ili;
	wire_w_lg_n00ill1269w(0) <= NOT n00ill;
	wire_w_lg_n00ilO1268w(0) <= NOT n00ilO;
	wire_w_lg_n00iOi1236w(0) <= NOT n00iOi;
	wire_w_lg_n00iOl1250w(0) <= NOT n00iOl;
	wire_w_lg_n00iOO1249w(0) <= NOT n00iOO;
	wire_w_lg_n00l0i1198w(0) <= NOT n00l0i;
	wire_w_lg_n00l0l1212w(0) <= NOT n00l0l;
	wire_w_lg_n00l0O1211w(0) <= NOT n00l0O;
	wire_w_lg_n00l1i1217w(0) <= NOT n00l1i;
	wire_w_lg_n00l1l1231w(0) <= NOT n00l1l;
	wire_w_lg_n00l1O1230w(0) <= NOT n00l1O;
	wire_w_lg_n00lii1176w(0) <= NOT n00lii;
	wire_w_lg_n00lil1193w(0) <= NOT n00lil;
	wire_w_lg_n00liO1192w(0) <= NOT n00liO;
	wire_w_lg_n00lli1154w(0) <= NOT n00lli;
	wire_w_lg_n00lll1135w(0) <= NOT n00lll;
	wire_w_lg_n00llO1149w(0) <= NOT n00llO;
	wire_w_lg_n00lOi1148w(0) <= NOT n00lOi;
	wire_w_lg_n00lOl1116w(0) <= NOT n00lOl;
	wire_w_lg_n00lOO1130w(0) <= NOT n00lOO;
	wire_w_lg_n00O0i969w(0) <= NOT n00O0i;
	wire_w_lg_n00O0l967w(0) <= NOT n00O0l;
	wire_w_lg_n00O0O959w(0) <= NOT n00O0O;
	wire_w_lg_n00O1i1129w(0) <= NOT n00O1i;
	wire_w_lg_n00O1l1113w(0) <= NOT n00O1l;
	wire_w_lg_n00Oii956w(0) <= NOT n00Oii;
	wire_w_lg_n00Oil951w(0) <= NOT n00Oil;
	wire_w_lg_n00OiO948w(0) <= NOT n00OiO;
	wire_w_lg_n00Oli909w(0) <= NOT n00Oli;
	wire_w_lg_n00Oll908w(0) <= NOT n00Oll;
	wire_w_lg_n00OlO1032w(0) <= NOT n00OlO;
	wire_w_lg_n00OOi1030w(0) <= NOT n00OOi;
	wire_w_lg_n00OOl907w(0) <= NOT n00OOl;
	wire_w_lg_n00OOO906w(0) <= NOT n00OOO;
	wire_w_lg_n0i00i681w(0) <= NOT n0i00i;
	wire_w_lg_n0i00l623w(0) <= NOT n0i00l;
	wire_w_lg_n0i00O632w(0) <= NOT n0i00O;
	wire_w_lg_n0i01i782w(0) <= NOT n0i01i;
	wire_w_lg_n0i01l728w(0) <= NOT n0i01l;
	wire_w_lg_n0i01O735w(0) <= NOT n0i01O;
	wire_w_lg_n0i0ii551w(0) <= NOT n0i0ii;
	wire_w_lg_n0i0li504w(0) <= NOT n0i0li;
	wire_w_lg_n0i0Oi481w(0) <= NOT n0i0Oi;
	wire_w_lg_n0i0Ol499w(0) <= NOT n0i0Ol;
	wire_w_lg_n0i0OO498w(0) <= NOT n0i0OO;
	wire_w_lg_n0i10i872w(0) <= NOT n0i10i;
	wire_w_lg_n0i10l868w(0) <= NOT n0i10l;
	wire_w_lg_n0i11i991w(0) <= NOT n0i11i;
	wire_w_lg_n0i11l880w(0) <= NOT n0i11l;
	wire_w_lg_n0i11O875w(0) <= NOT n0i11O;
	wire_w_lg_n0i1ll862w(0) <= NOT n0i1ll;
	wire_w_lg_n0i1lO819w(0) <= NOT n0i1lO;
	wire_w_lg_n0ii0i475w(0) <= NOT n0ii0i;
	wire_w_lg_n0ii0O440w(0) <= NOT n0ii0O;
	wire_w_lg_n0ii1l460w(0) <= NOT n0ii1l;
	wire_w_lg_n0ii1O476w(0) <= NOT n0ii1O;
	wire_w_lg_n0iiii455w(0) <= NOT n0iiii;
	wire_w_lg_n0iiil454w(0) <= NOT n0iiil;
	wire_w_lg_n0iili416w(0) <= NOT n0iili;
	wire_w_lg_n0iill434w(0) <= NOT n0iill;
	wire_w_lg_n0iilO433w(0) <= NOT n0iilO;
	wire_w_lg_n0iiOl394w(0) <= NOT n0iiOl;
	wire_w_lg_n0iiOO411w(0) <= NOT n0iiOO;
	wire_w_lg_n0il0O306w(0) <= NOT n0il0O;
	wire_w_lg_n0il1i410w(0) <= NOT n0il1i;
	wire_w_lg_n0il1l390w(0) <= NOT n0il1l;
	wire_w_lg_n0ilii262w(0) <= NOT n0ilii;
	wire_w_lg_n0ilOl248w(0) <= NOT n0ilOl;
	wire_w_lg_n0ilOO244w(0) <= NOT n0ilOO;
	wire_w_lg_n0iO0i138w(0) <= NOT n0iO0i;
	wire_w_lg_n0iO0l136w(0) <= NOT n0iO0l;
	wire_w_lg_n0iO1i246w(0) <= NOT n0iO1i;
	wire_w_lg_n0iO1O140w(0) <= NOT n0iO1O;
	wire_w_lg_n0iOil129w(0) <= NOT n0iOil;
	wire_w_lg_n0iOli126w(0) <= NOT n0iOli;
	wire_w_lg_n0iOOl116w(0) <= NOT n0iOOl;
	wire_w_lg_n0iOOO114w(0) <= NOT n0iOOO;
	wire_w_lg_n0l00l31w(0) <= NOT n0l00l;
	wire_w_lg_n0l0ii30w(0) <= NOT n0l0ii;
	wire_w_lg_n0l0il540w(0) <= NOT n0l0il;
	wire_w_lg_n0l0iO549w(0) <= NOT n0l0iO;
	wire_w_lg_n0l0li547w(0) <= NOT n0l0li;
	wire_w_lg_n0l0ll570w(0) <= NOT n0l0ll;
	wire_w_lg_n0l0lO264w(0) <= NOT n0l0lO;
	wire_w_lg_n0l0OO1290w(0) <= NOT n0l0OO;
	wire_w_lg_n0l11i113w(0) <= NOT n0l11i;
	wire_w_lg_n0li0i821w(0) <= NOT n0li0i;
	wire_w_lg_n0li1O1411w(0) <= NOT n0li1O;
	wire_w_lg_radce_adapt255w(0) <= NOT radce_adapt;
	wire_w_lg_radce_pdb536w(0) <= NOT radce_pdb;
	wire_w_lg_radce_rstb267w(0) <= NOT radce_rstb;
	wire_w_lg_w_eqa_set_range802w803w(0) <= NOT wire_w_eqa_set_range802w(0);
	wire_w_lg_w_eqb_set_range758w759w(0) <= NOT wire_w_eqb_set_range758w(0);
	wire_w_lg_w_eqc_set_range704w705w(0) <= NOT wire_w_eqc_set_range704w(0);
	wire_w_lg_w_eqd_set_range649w650w(0) <= NOT wire_w_eqd_set_range649w(0);
	wire_w_lg_w_eqv_set_range597w604w(0) <= NOT wire_w_eqv_set_range597w(0);
	wire_w_lg_w_radce_hflck_range215w216w(0) <= NOT wire_w_radce_hflck_range215w(0);
	wire_w_lg_w_radce_lflck_range188w189w(0) <= NOT wire_w_radce_lflck_range188w(0);
	wire_w_lg_w_rclkdiv_range155w163w(0) <= NOT wire_w_rclkdiv_range155w(0);
	wire_w_lg_w_rclkdiv_range150w151w(0) <= NOT wire_w_rclkdiv_range150w(0);
	wire_w_lg_w_rseq_sel_range543w555w(0) <= NOT wire_w_rseq_sel_range543w(0);
	wire_w_lg_w_lg_n0l0ll570w571w(0) <= wire_w_lg_n0l0ll570w(0) OR wire_w_lg_n0l0li547w(0);
	wire_w_lg_w_lg_n0l0ll570w671w(0) <= wire_w_lg_n0l0ll570w(0) OR n0l0ii;
	wire_w_lg_w_lg_radce_adapt255w256w(0) <= wire_w_lg_radce_adapt255w(0) OR radce_pdb;
	wire_w_lg_n0l0ii683w(0) <= n0l0ii OR wire_w_lg_n0l0il540w(0);
	wire_w_lg_w_rseq_sel_range541w965w(0) <= wire_w_rseq_sel_range541w(0) OR wire_w_lg_w_rseq_sel_range543w555w(0);
	adapt_done <= n0liii;
	atb0 <= wire_nii0O_dataout(0);
	atb1 <= wire_nii0l_dataout(0);
	atb_0 <= wire_nii0i_dataout(0);
	atb_1 <= wire_nii1O_dataout(0);
	e_clk <= n0li0i;
	eqa_ctrl <= wire_nl1O0l_dataout(0);
	eqb_ctrl <= wire_nl0i1i_dataout(0);
	eqc_ctrl <= wire_nl0Oll_dataout(0);
	eqctrlout <= ( nii10O & ni0O1l & ni0iOi & ni00iO & ni010l & ni1O1i);
	eqd_ctrl <= wire_nlii1l_dataout(0);
	eqv_ctrl <= wire_ni0ll_dataout(0);
	fine_d2aout <= '0';
	hf_adapt_done <= n0li1O;
	hfclk_macro <= wire_n0i1i_dataout(0);
	hfmac_cnt0_nclr <= n0li1l;
	hfmac_cnt2_nclr <= n0li1i;
	ib50u_c <= wire_nii1l_dataout(0);
	ib50u_t <= wire_nii1i_dataout(0);
	ibrgen1 <= '0';
	ibrgen2 <= '0';
	lf_adapt_done <= n0l0OO;
	lfclk_macro <= wire_n0l1O_dataout(0);
	lfmac_cnt0_nclr <= n0l0Ol;
	lfmac_cnt2_nclr <= n0l0Oi;
	n000il <= (n0lili AND wire_nl1lOi_dataout(0));
	n000iO <= (n000il AND n0liOO);
	n000li <= ((NOT wire_nl1llO_dataout(0)) AND wire_n0i1i_dataout(0));
	n000ll <= (n0O10l AND wire_nl1lOi_dataout(0));
	n000lO <= (n000ll AND n0O1li);
	n000Oi <= (n000Ol AND wire_w_lg_n0li1O1411w(0));
	n000Ol <= ((NOT (radce_hflck(7) OR radce_hflck(8))) AND (NOT (radce_hflck(9) OR radce_hflck(10))));
	n000OO <= ((NOT ((NOT ((NOT ((NOT radce_hflck(3)) AND n0lili)) AND (NOT wire_w_lg_w_radce_hflck_range1474w1479w(0)))) OR (NOT ((NOT ((NOT radce_hflck(4)) AND n0liOO)) AND (NOT wire_w_lg_w_radce_hflck_range1483w1488w(0)))))) AND (NOT ((NOT ((NOT ((NOT radce_hflck(5)) AND n0ll0l)) AND (NOT wire_w_lg_w_radce_hflck_range1494w1499w(0)))) OR (NOT ((NOT ((NOT radce_hflck(6)) AND n0llll)) AND (NOT wire_w_lg_w_radce_hflck_range1503w1508w(0)))))));
	n00i0i <= (ni11Ol AND wire_nl1lOi_dataout(0));
	n00i0l <= (n00i0i AND ni100i);
	n00i0O <= (n00iii AND wire_w_lg_n0l0OO1290w(0));
	n00i1i <= (n0Ol0i AND wire_nl1lOi_dataout(0));
	n00i1l <= (n00i1i AND n0OliO);
	n00i1O <= ((NOT wire_nl1llO_dataout(0)) AND wire_n0l1O_dataout(0));
	n00iii <= ((NOT (radce_lflck(7) OR radce_lflck(8))) AND (NOT (radce_lflck(9) OR radce_lflck(10))));
	n00iil <= ((NOT ((NOT ((NOT ((NOT radce_lflck(3)) AND n0Ol0i)) AND (NOT wire_w_lg_w_radce_lflck_range1353w1358w(0)))) OR (NOT ((NOT ((NOT radce_lflck(4)) AND n0OliO)) AND (NOT wire_w_lg_w_radce_lflck_range1362w1367w(0)))))) AND (NOT ((NOT ((NOT ((NOT radce_lflck(5)) AND n0OlOl)) AND (NOT wire_w_lg_w_radce_lflck_range1373w1378w(0)))) OR (NOT ((NOT ((NOT radce_lflck(6)) AND n0OO0l)) AND (NOT wire_w_lg_w_radce_lflck_range1382w1387w(0)))))));
	n00iiO <= wire_ni1OOi_w_lg_w_dataout_range1275w1278w(0);
	n00ili <= wire_ni001l_w_lg_w_dataout_range1256w1259w(0);
	n00ill <= (radce_adapt AND nl10OO);
	n00ilO <= (radce_adapt AND wire_nl10Ol_w_lg_nl10OO889w(0));
	n00iOi <= wire_ni0i0O_w_lg_w_dataout_range1237w1240w(0);
	n00iOl <= (n00ill AND ni1O1i);
	n00iOO <= (n00ilO AND ni1O1O);
	n00l0i <= wire_ni0OOl_w_lg_w_dataout_range1199w1202w(0);
	n00l0l <= (n00l1l AND ni00iO);
	n00l0O <= (n00l1O AND ni00ll);
	n00l1i <= wire_ni0lli_w_lg_w_dataout_range1218w1221w(0);
	n00l1l <= (n00iOl AND ni010l);
	n00l1O <= (n00iOO AND ni01ii);
	n00lii <= wire_nii01O_w_lg_w_dataout_range1177w1180w(0);
	n00lil <= (n00l0l AND ni0iOi);
	n00liO <= (n00l0O AND ni0iOO);
	n00lli <= wire_niiiii_w_lg_w_dataout_range1155w1158w(0);
	n00lll <= wire_niilll_w_lg_w_dataout_range1136w1139w(0);
	n00llO <= (n0i1Ol AND nl10OO);
	n00lOi <= (n0i1Ol AND wire_nl10Ol_w_lg_nl10OO889w(0));
	n00lOl <= wire_niiOOO_w_lg_w_dataout_range1117w1120w(0);
	n00lOO <= (n00llO AND nii0li);
	n00O0i <= (wire_w_lg_n0l0ll570w(0) AND wire_nl10Ol_w_lg_nl10OO889w(0));
	n00O0l <= (wire_w_lg_n00OiO948w(0) AND nl10OO);
	n00O0O <= ((wire_nii0iO_w_lg_nii0li939w(0) OR niiiOl) OR niiO1O);
	n00O1i <= (n00lOi AND nii0lO);
	n00O1l <= (n0i1OO AND (NOT (wire_w_lg_n00O0l967w(0) AND wire_w_lg_n00O0i969w(0))));
	n00O1O <= (wire_w_lg_n0i1OO968w(0) AND wire_w_lg_n00O0i969w(0));
	n00Oii <= ((nii0li OR wire_niiiOi_w_lg_niiiOl940w(0)) OR niiO1O);
	n00Oil <= ((wire_nii0iO_w_lg_nii0li939w(0) OR wire_niiiOi_w_lg_niiiOl940w(0)) OR niiO1O);
	n00OiO <= ((nii0li OR niiiOl) OR wire_niiO1l_w_lg_niiO1O937w(0));
	n00Oli <= (((NOT (wire_w_lg_n0l0ii1019w(0) AND wire_nl10Ol_w_lg_nl10OO889w(0))) AND (NOT (wire_w_lg_n0i10i1022w(0) AND wire_nl10Ol_w_lg_nl10OO889w(0)))) AND (NOT (wire_w_lg_n0l0ll570w(0) AND wire_nl10Ol_w_lg_nl10OO889w(0))));
	n00Oll <= ((NOT (wire_w_lg_n0l0ii1012w(0) AND wire_nl10Ol_w_lg_nl10OO889w(0))) AND (NOT (wire_w_lg_n0i11O1015w(0) AND wire_nl10Ol_w_lg_nl10OO889w(0))));
	n00OlO <= ((NOT ((NOT (((NOT rseq_sel(0)) AND rseq_sel(1)) AND n0l0ii)) AND (NOT (n0i11l AND wire_w_lg_n0l0il540w(0))))) AND wire_nl10Ol_w_lg_nl10OO889w(0));
	n00OOi <= ((n0l0ii AND n0i11i) AND wire_nl10Ol_w_lg_nl10OO889w(0));
	n00OOl <= ((NOT (n00Oll AND n00Oli)) OR (NOT (wire_w_lg_w_lg_n00OOi1030w1031w(0) AND wire_w_lg_n00OlO1032w(0))));
	n00OOO <= (((NOT ((wire_w_lg_n0i11l880w(0) AND wire_w_lg_n0l0il540w(0)) AND wire_nl10Ol_w_lg_nl10OO889w(0))) AND (NOT ((wire_w_lg_n0i11O875w(0) AND wire_w_lg_n0l0iO549w(0)) AND wire_nl10Ol_w_lg_nl10OO889w(0)))) AND (NOT ((wire_w_lg_n0i10i872w(0) AND wire_w_lg_n0l0li547w(0)) AND wire_nl10Ol_w_lg_nl10OO889w(0))));
	n0i00i <= (radce_adapt OR radce_pdb);
	n0i00l <= (rseq_sel(0) AND rseq_sel(1));
	n0i00O <= (radce_adapt OR radce_pdb);
	n0i01i <= (radce_adapt OR radce_pdb);
	n0i01l <= (rseq_sel(0) OR rseq_sel(1));
	n0i01O <= (radce_adapt OR radce_pdb);
	n0i0ii <= (rseq_sel(0) OR rseq_sel(1));
	n0i0li <= wire_nll0Oi_w_lg_w_dataout_range505w512w(0);
	n0i0Oi <= wire_nlll1l_w_lg_w_dataout_range482w489w(0);
	n0i0Ol <= (radce_adapt AND n1l1O);
	n0i0OO <= (radce_adapt AND wire_n1l1l_w_lg_n1l1O370w(0));
	n0i10i <= (rseq_sel(0) OR rseq_sel(1));
	n0i10l <= (radce_rstb AND nl10OO);
	n0i11i <= (rseq_sel(0) AND rseq_sel(1));
	n0i11l <= wire_w_lg_w_rseq_sel_range541w965w(0);
	n0i11O <= ((NOT rseq_sel(0)) OR rseq_sel(1));
	n0i1ll <= (((NOT ((NOT ((NOT rhyst_hf(0)) AND nl111i)) AND (NOT wire_w_lg_w_rhyst_hf_range826w831w(0)))) OR (NOT ((NOT ((NOT rhyst_hf(1)) AND nl11ii)) AND (NOT wire_w_lg_w_rhyst_hf_range835w840w(0))))) OR (NOT ((NOT ((NOT rhyst_hf(2)) AND nl11Ol)) AND (NOT wire_w_lg_w_rhyst_hf_range845w850w(0)))));
	n0i1lO <= ((rhyst_hf(0) OR rhyst_hf(1)) OR rhyst_hf(2));
	n0i1Oi <= (radce_adapt AND radce_rstb);
	n0i1Ol <= (radce_adapt AND n0i1OO);
	n0i1OO <= (((NOT ((NOT ((NOT (ni0iOi AND wire_nil1iO_w_lg_dataout1036w(0))) AND (NOT (wire_ni0ilO_w_lg_ni0iOi1039w(0) AND wire_nil1iO_dataout)))) OR wire_nl1llO_dataout(0))) AND (NOT ((NOT ((NOT (ni0O1l AND wire_nil1Oi_w_lg_dataout1046w(0))) AND (NOT (wire_ni0O1i_w_lg_ni0O1l1049w(0) AND wire_nil1Oi_dataout)))) OR (NOT ((NOT (nii10O AND wire_nil1OO_w_lg_dataout1054w(0))) AND (NOT (wire_nii10l_w_lg_nii10O1057w(0) AND wire_nil1OO_dataout))))))) AND ((NOT ((NOT ((NOT (ni00iO AND wire_nil1ii_w_lg_dataout1065w(0))) AND (NOT (wire_ni00il_w_lg_ni00iO1068w(0) AND wire_nil1ii_dataout)))) OR wire_nl1llO_dataout(0))) AND (NOT ((NOT ((NOT (ni1O1i AND wire_nil01l_w_lg_dataout1075w(0))) AND (NOT (wire_ni1lOO_w_lg_ni1O1i1078w(0) AND wire_nil01l_dataout)))) OR (NOT ((NOT (ni010l AND wire_nil10l_w_lg_dataout1083w(0))) AND (NOT (wire_ni010i_w_lg_ni010l1086w(0) AND wire_nil10l_dataout))))))));
	n0ii0i <= (n0i0OO AND nll01O);
	n0ii0O <= wire_nlO1li_w_lg_w_dataout_range442w445w(0);
	n0ii1l <= wire_nllO0O_w_lg_w_dataout_range461w466w(0);
	n0ii1O <= (n0i0Ol AND nll01i);
	n0iiii <= (n0ii1O AND nlli0l);
	n0iiil <= (n0ii0i AND nlliii);
	n0iili <= wire_nlO0Ol_w_lg_w_dataout_range417w422w(0);
	n0iill <= (n0iiii AND nllliO);
	n0iilO <= (n0iiil AND nlllll);
	n0iiOl <= wire_nlOl1O_w_lg_w_dataout_range396w399w(0);
	n0iiOO <= (n0iill AND nllOOi);
	n0il0O <= (((NOT ((NOT ((NOT rhyst_lf(0)) AND n100i)) AND (NOT wire_w_lg_w_rhyst_lf_range272w277w(0)))) OR (NOT ((NOT ((NOT rhyst_lf(1)) AND n10li)) AND (NOT wire_w_lg_w_rhyst_lf_range281w286w(0))))) OR (NOT ((NOT ((NOT rhyst_lf(2)) AND n1i1l)) AND (NOT wire_w_lg_w_rhyst_lf_range291w296w(0)))));
	n0il1i <= (n0iilO AND nllOOO);
	n0il1l <= (((NOT wire_nl1llO_w_lg_w_dataout_range35w319w(0)) AND (NOT ((NOT ((NOT (nlO01l AND wire_nlOlOl_w_lg_dataout321w(0))) AND (NOT (wire_nlO01i_w_lg_nlO01l324w(0) AND wire_nlOlOl_dataout)))) OR (NOT ((NOT (nlOi0O AND wire_nlOO1i_w_lg_dataout329w(0))) AND (NOT (wire_nlOi0l_w_lg_nlOi0O332w(0) AND wire_nlOO1i_dataout))))))) AND ((NOT wire_nl1llO_w_lg_w_dataout_range35w348w(0)) AND (NOT ((NOT ((NOT (nll01i AND wire_nlOO1O_w_lg_dataout350w(0))) AND (NOT (wire_nll1OO_w_lg_nll01i353w(0) AND wire_nlOO1O_dataout)))) OR (NOT ((NOT (nlli0l AND wire_nlOlil_w_lg_dataout358w(0))) AND (NOT (wire_nlli0i_w_lg_nlli0l361w(0) AND wire_nlOlil_dataout))))))));
	n0ilii <= ((rhyst_lf(0) OR rhyst_lf(1)) OR rhyst_lf(2));
	n0ilil <= (radce_adapt AND radce_rstb);
	n0illl <= '1';
	n0ilOl <= (n1O1l AND n1O0O);
	n0ilOO <= (n0iO1i AND n1OOl);
	n0iO0i <= ((NOT wire_w_lg_w_rclkdiv_range154w164w(0)) OR (NOT wire_w_lg_w_rclkdiv_range149w152w(0)));
	n0iO0l <= ((NOT (rclkdiv(0) AND rclkdiv(1))) OR (NOT ((NOT rclkdiv(2)) AND wire_w_lg_w_rclkdiv_range150w151w(0))));
	n0iO1i <= (n0ilOl AND n1Oli);
	n0iO1O <= ((NOT ((NOT rclkdiv(2)) AND wire_w_lg_w_rclkdiv_range150w151w(0))) OR (NOT wire_w_lg_w_rclkdiv_range154w164w(0)));
	n0iOil <= ((NOT wire_w_lg_w_rclkdiv_range149w152w(0)) OR (NOT ((NOT rclkdiv(0)) AND wire_w_lg_w_rclkdiv_range155w163w(0))));
	n0iOli <= ((NOT ((NOT rclkdiv(0)) AND wire_w_lg_w_rclkdiv_range155w163w(0))) OR (NOT ((NOT rclkdiv(2)) AND wire_w_lg_w_rclkdiv_range150w151w(0))));
	n0iOOl <= ((NOT ((NOT rclkdiv(2)) AND wire_w_lg_w_rclkdiv_range150w151w(0))) OR (NOT ((NOT rclkdiv(0)) AND rclkdiv(1))));
	n0iOOO <= ((NOT wire_w_lg_w_rclkdiv_range149w152w(0)) OR (NOT ((NOT rclkdiv(0)) AND rclkdiv(1))));
	n0l00l <= (((((radce_digital(2) AND radce_digital(3)) AND rhf_os(0)) AND rhf_os(1)) AND rhf_os(2)) AND rhf_os(3));
	n0l00O <= (((((radce_digital(4) AND radce_digital(5)) AND rlf_os(0)) AND rlf_os(1)) AND rlf_os(2)) AND rlf_os(3));
	n0l0ii <= ((NOT ((NOT ((rseq_sel(0) AND rseq_sel(1)) AND wire_w_lg_n00OiO948w(0))) AND (NOT (wire_w_lg_n00Oil951w(0) AND wire_w_lg_n0i11l880w(0))))) OR (NOT ((NOT (wire_w_lg_n00Oii956w(0) AND wire_w_lg_n0i11O875w(0))) AND (NOT (wire_w_lg_n00O0O959w(0) AND wire_w_lg_n0i10i872w(0))))));
	n0l0il <= ((NOT (wire_w_lg_n00Oil951w(0) AND n0i11i)) AND (NOT (wire_w_lg_n00OiO948w(0) AND wire_w_lg_n0i11i991w(0))));
	n0l0iO <= ((NOT (wire_w_lg_w_rseq_sel_range543w555w(0) AND wire_w_lg_n00Oil951w(0))) AND (NOT wire_w_lg_w_rseq_sel_range543w997w(0)));
	n0l0li <= ((NOT (wire_w_lg_n00O0O959w(0) AND n0i10i)) AND (NOT (wire_w_lg_n00Oii956w(0) AND wire_w_lg_n0i10i872w(0))));
	n0l0ll <= ((nii0li OR niiiOl) OR niiO1O);
	n0l0lO <= (wire_w_lg_n0l1Oi83w(0) AND (n0l1iO16 XOR n0l1iO15));
	n0l0Oi <= (radce_rstb AND (NOT (n00iil AND wire_ni1l0i_w_lg_ni1l0l1284w(0))));
	n0l0Ol <= (radce_rstb AND ni1lii);
	n0l0OO <= ((NOT ((NOT ((NOT ((NOT radce_lflck(11)) AND ni11Ol)) AND (NOT wire_w_lg_w_radce_lflck_range1292w1297w(0)))) OR (NOT ((NOT ((NOT radce_lflck(12)) AND ni100i)) AND (NOT wire_w_lg_w_radce_lflck_range1301w1306w(0)))))) AND (NOT ((NOT ((NOT ((NOT radce_lflck(13)) AND ni10iO)) AND (NOT wire_w_lg_w_radce_lflck_range1312w1317w(0)))) OR (NOT ((NOT ((NOT radce_lflck(14)) AND ni10OO)) AND (NOT wire_w_lg_w_radce_lflck_range1321w1326w(0)))))));
	n0l11i <= ((NOT wire_w_lg_w_rclkdiv_range149w152w(0)) OR (NOT (rclkdiv(0) AND rclkdiv(1))));
	n0l1il <= (fixed_clk AND n1lOl);
	n0l1Oi <= (radce_adapt AND wire_nl1lOi_dataout(0));
	n0li0i <= (wire_w_lg_n0l1Oi78w(0) AND (n0l1ll14 XOR n0l1ll13));
	n0li1i <= (radce_rstb AND (NOT (n000OO AND wire_n0Oili_w_lg_n0Oill1405w(0))));
	n0li1l <= (radce_rstb AND n0OiOi);
	n0li1O <= ((NOT ((NOT ((NOT ((NOT radce_hflck(11)) AND n0O10l)) AND (NOT wire_w_lg_w_radce_hflck_range1413w1418w(0)))) OR (NOT ((NOT ((NOT radce_hflck(12)) AND n0O1li)) AND (NOT wire_w_lg_w_radce_hflck_range1422w1427w(0)))))) AND (NOT ((NOT ((NOT ((NOT radce_hflck(13)) AND n0O1OO)) AND (NOT wire_w_lg_w_radce_hflck_range1433w1438w(0)))) OR (NOT ((NOT ((NOT radce_hflck(14)) AND n0O00O)) AND (NOT wire_w_lg_w_radce_hflck_range1442w1447w(0)))))));
	n0liii <= ((lock_lf_ovd OR (wire_w_lg_lock_lf_ovd1279w(0) AND n0l0OO)) AND n0li1O);
	outeqn <= wire_ni0OO_dataout(0);
	outeqp <= wire_ni0Ol_dataout(0);
	r_clk <= n0l0lO;
	rgenctrlout <= ( nlOi0O & nlO01l & nllOOi & nllliO & nlli0l & nll01i);
	tmxselan <= n0l0ll;
	tmxselbn <= n0l0li;
	tmxselcn <= n0l0iO;
	tmxseldn <= n0l0il;
	tmxselvn <= wire_w_lg_n0l0ii30w(0);
	updnn_hf <= n0l00O;
	updnn_lf <= wire_w_lg_n0l00l31w(0);
	vccehxqyx <= wire_ni0Oi_dataout(0);
	vccerxqyx <= wire_nl1lOi_dataout(0);
	vctl_quiet <= wire_ni0lO_dataout(0);
	vssexqyx <= wire_nl1llO_dataout(0);
	wire_w_eqa_set_range800w(0) <= eqa_set(0);
	wire_w_eqa_set_range802w(0) <= eqa_set(1);
	wire_w_eqb_set_range756w(0) <= eqb_set(0);
	wire_w_eqb_set_range758w(0) <= eqb_set(1);
	wire_w_eqc_set_range702w(0) <= eqc_set(0);
	wire_w_eqc_set_range704w(0) <= eqc_set(1);
	wire_w_eqd_set_range647w(0) <= eqd_set(0);
	wire_w_eqd_set_range649w(0) <= eqd_set(1);
	wire_w_eqv_set_range596w(0) <= eqv_set(0);
	wire_w_eqv_set_range597w(0) <= eqv_set(1);
	wire_w_radce_hflck_range213w(0) <= radce_hflck(0);
	wire_w_radce_hflck_range1413w(0) <= radce_hflck(11);
	wire_w_radce_hflck_range1422w(0) <= radce_hflck(12);
	wire_w_radce_hflck_range1433w(0) <= radce_hflck(13);
	wire_w_radce_hflck_range1442w(0) <= radce_hflck(14);
	wire_w_radce_hflck_range215w(0) <= radce_hflck(1);
	wire_w_radce_hflck_range1474w(0) <= radce_hflck(3);
	wire_w_radce_hflck_range1483w(0) <= radce_hflck(4);
	wire_w_radce_hflck_range1494w(0) <= radce_hflck(5);
	wire_w_radce_hflck_range1503w(0) <= radce_hflck(6);
	wire_w_radce_lflck_range186w(0) <= radce_lflck(0);
	wire_w_radce_lflck_range1292w(0) <= radce_lflck(11);
	wire_w_radce_lflck_range1301w(0) <= radce_lflck(12);
	wire_w_radce_lflck_range1312w(0) <= radce_lflck(13);
	wire_w_radce_lflck_range1321w(0) <= radce_lflck(14);
	wire_w_radce_lflck_range188w(0) <= radce_lflck(1);
	wire_w_radce_lflck_range1353w(0) <= radce_lflck(3);
	wire_w_radce_lflck_range1362w(0) <= radce_lflck(4);
	wire_w_radce_lflck_range1373w(0) <= radce_lflck(5);
	wire_w_radce_lflck_range1382w(0) <= radce_lflck(6);
	wire_w_rclkdiv_range154w(0) <= rclkdiv(0);
	wire_w_rclkdiv_range155w(0) <= rclkdiv(1);
	wire_w_rclkdiv_range149w(0) <= rclkdiv(2);
	wire_w_rclkdiv_range150w(0) <= rclkdiv(3);
	wire_w_rhyst_hf_range826w(0) <= rhyst_hf(0);
	wire_w_rhyst_hf_range835w(0) <= rhyst_hf(1);
	wire_w_rhyst_hf_range845w(0) <= rhyst_hf(2);
	wire_w_rhyst_lf_range272w(0) <= rhyst_lf(0);
	wire_w_rhyst_lf_range281w(0) <= rhyst_lf(1);
	wire_w_rhyst_lf_range291w(0) <= rhyst_lf(2);
	wire_w_rseq_sel_range541w(0) <= rseq_sel(0);
	wire_w_rseq_sel_range543w(0) <= rseq_sel(1);
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0il69 <= n0i0il70;
		END IF;
		if (now = 0 ns) then
			n0i0il69 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0il70 <= n0i0il69;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0iO67 <= n0i0iO68;
		END IF;
		if (now = 0 ns) then
			n0i0iO67 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0iO68 <= n0i0iO67;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0ll65 <= n0i0ll66;
		END IF;
		if (now = 0 ns) then
			n0i0ll65 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0ll66 <= n0i0ll65;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0lO63 <= n0i0lO64;
		END IF;
		if (now = 0 ns) then
			n0i0lO63 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i0lO64 <= n0i0lO63;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i10O79 <= n0i10O80;
		END IF;
		if (now = 0 ns) then
			n0i10O79 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i10O80 <= n0i10O79;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1ii77 <= n0i1ii78;
		END IF;
		if (now = 0 ns) then
			n0i1ii77 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1ii78 <= n0i1ii77;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1il75 <= n0i1il76;
		END IF;
		if (now = 0 ns) then
			n0i1il75 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1il76 <= n0i1il75;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1iO73 <= n0i1iO74;
		END IF;
		if (now = 0 ns) then
			n0i1iO73 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1iO74 <= n0i1iO73;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1li71 <= n0i1li72;
		END IF;
		if (now = 0 ns) then
			n0i1li71 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0i1li72 <= n0i1li71;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0ii0l59 <= n0ii0l60;
		END IF;
		if (now = 0 ns) then
			n0ii0l59 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0ii0l60 <= n0ii0l59;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0ii1i61 <= n0ii1i62;
		END IF;
		if (now = 0 ns) then
			n0ii1i61 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0ii1i62 <= n0ii1i61;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iiiO57 <= n0iiiO58;
		END IF;
		if (now = 0 ns) then
			n0iiiO57 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iiiO58 <= n0iiiO57;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iiOi55 <= n0iiOi56;
		END IF;
		if (now = 0 ns) then
			n0iiOi55 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iiOi56 <= n0iiOi55;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0il0i51 <= n0il0i52;
		END IF;
		if (now = 0 ns) then
			n0il0i51 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0il0i52 <= n0il0i51;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0il0l49 <= n0il0l50;
		END IF;
		if (now = 0 ns) then
			n0il0l49 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0il0l50 <= n0il0l49;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0il1O53 <= n0il1O54;
		END IF;
		if (now = 0 ns) then
			n0il1O53 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0il1O54 <= n0il1O53;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iliO47 <= n0iliO48;
		END IF;
		if (now = 0 ns) then
			n0iliO47 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iliO48 <= n0iliO47;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0illi45 <= n0illi46;
		END IF;
		if (now = 0 ns) then
			n0illi45 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0illi46 <= n0illi45;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0illO43 <= n0illO44;
		END IF;
		if (now = 0 ns) then
			n0illO43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0illO44 <= n0illO43;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0ilOi41 <= n0ilOi42;
		END IF;
		if (now = 0 ns) then
			n0ilOi41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0ilOi42 <= n0ilOi41;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iO0O37 <= n0iO0O38;
		END IF;
		if (now = 0 ns) then
			n0iO0O37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iO0O38 <= n0iO0O37;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iO1l39 <= n0iO1l40;
		END IF;
		if (now = 0 ns) then
			n0iO1l39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iO1l40 <= n0iO1l39;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOii35 <= n0iOii36;
		END IF;
		if (now = 0 ns) then
			n0iOii35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOii36 <= n0iOii35;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOiO33 <= n0iOiO34;
		END IF;
		if (now = 0 ns) then
			n0iOiO33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOiO34 <= n0iOiO33;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOll31 <= n0iOll32;
		END IF;
		if (now = 0 ns) then
			n0iOll31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOll32 <= n0iOll31;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOlO29 <= n0iOlO30;
		END IF;
		if (now = 0 ns) then
			n0iOlO29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0iOlO30 <= n0iOlO29;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l00i1 <= n0l00i2;
		END IF;
		if (now = 0 ns) then
			n0l00i1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l00i2 <= n0l00i1;
		END IF;
	END PROCESS;
	wire_n0l00i2_w_lg_w_lg_q36w37w(0) <= wire_n0l00i2_w_lg_q36w(0) AND atb0;
	wire_n0l00i2_w_lg_q36w(0) <= n0l00i2 XOR n0l00i1;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l01i7 <= n0l01i8;
		END IF;
		if (now = 0 ns) then
			n0l01i7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l01i8 <= n0l01i7;
		END IF;
	END PROCESS;
	wire_n0l01i8_w_lg_w_lg_q56w57w(0) <= wire_n0l01i8_w_lg_q56w(0) AND ib50u_t;
	wire_n0l01i8_w_lg_q56w(0) <= n0l01i8 XOR n0l01i7;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l01l5 <= n0l01l6;
		END IF;
		if (now = 0 ns) then
			n0l01l5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l01l6 <= n0l01l5;
		END IF;
	END PROCESS;
	wire_n0l01l6_w_lg_w_lg_q52w53w(0) <= wire_n0l01l6_w_lg_q52w(0) AND ib50u_c;
	wire_n0l01l6_w_lg_q52w(0) <= n0l01l6 XOR n0l01l5;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l01O3 <= n0l01O4;
		END IF;
		if (now = 0 ns) then
			n0l01O3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l01O4 <= n0l01O3;
		END IF;
	END PROCESS;
	wire_n0l01O4_w_lg_w_lg_q48w49w(0) <= wire_n0l01O4_w_lg_q48w(0) AND atb_1;
	wire_n0l01O4_w_lg_q48w(0) <= n0l01O4 XOR n0l01O3;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l10i23 <= n0l10i24;
		END IF;
		if (now = 0 ns) then
			n0l10i23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l10i24 <= n0l10i23;
		END IF;
	END PROCESS;
	wire_n0l10i24_w_lg_w_lg_q104w105w(0) <= wire_n0l10i24_w_lg_q104w(0) AND wire_ni1Oi_dataout;
	wire_n0l10i24_w_lg_q104w(0) <= n0l10i24 XOR n0l10i23;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l10l21 <= n0l10l22;
		END IF;
		if (now = 0 ns) then
			n0l10l21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l10l22 <= n0l10l21;
		END IF;
	END PROCESS;
	wire_n0l10l22_w_lg_w_lg_q100w101w(0) <= wire_n0l10l22_w_lg_q100w(0) AND wire_ni1ll_dataout;
	wire_n0l10l22_w_lg_q100w(0) <= n0l10l22 XOR n0l10l21;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l10O19 <= n0l10O20;
		END IF;
		if (now = 0 ns) then
			n0l10O19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l10O20 <= n0l10O19;
		END IF;
	END PROCESS;
	wire_n0l10O20_w_lg_w_lg_q94w95w(0) <= wire_n0l10O20_w_lg_q94w(0) AND wire_ni1OO_dataout;
	wire_n0l10O20_w_lg_q94w(0) <= n0l10O20 XOR n0l10O19;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l11l27 <= n0l11l28;
		END IF;
		if (now = 0 ns) then
			n0l11l27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l11l28 <= n0l11l27;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l11O25 <= n0l11O26;
		END IF;
		if (now = 0 ns) then
			n0l11O25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l11O26 <= n0l11O25;
		END IF;
	END PROCESS;
	wire_n0l11O26_w_lg_w_lg_q107w108w(0) <= wire_n0l11O26_w_lg_q107w(0) AND wire_ni1Ol_dataout;
	wire_n0l11O26_w_lg_q107w(0) <= n0l11O26 XOR n0l11O25;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1ii17 <= n0l1ii18;
		END IF;
		if (now = 0 ns) then
			n0l1ii17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1ii18 <= n0l1ii17;
		END IF;
	END PROCESS;
	wire_n0l1ii18_w_lg_w_lg_q91w92w(0) <= wire_n0l1ii18_w_lg_q91w(0) AND wire_ni1iO_dataout;
	wire_n0l1ii18_w_lg_q91w(0) <= n0l1ii18 XOR n0l1ii17;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1iO15 <= n0l1iO16;
		END IF;
		if (now = 0 ns) then
			n0l1iO15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1iO16 <= n0l1iO15;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1ll13 <= n0l1ll14;
		END IF;
		if (now = 0 ns) then
			n0l1ll13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1ll14 <= n0l1ll13;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1Ol11 <= n0l1Ol12;
		END IF;
		if (now = 0 ns) then
			n0l1Ol11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1Ol12 <= n0l1Ol11;
		END IF;
	END PROCESS;
	wire_n0l1Ol12_w_lg_w_lg_q72w73w(0) <= wire_n0l1Ol12_w_lg_q72w(0) AND wire_nll11O_dataout;
	wire_n0l1Ol12_w_lg_q72w(0) <= n0l1Ol12 XOR n0l1Ol11;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1OO10 <= n0l1OO9;
		END IF;
	END PROCESS;
	wire_n0l1OO10_w_lg_w_lg_q62w63w(0) <= wire_n0l1OO10_w_lg_q62w(0) AND outeqp;
	wire_n0l1OO10_w_lg_q62w(0) <= n0l1OO10 XOR n0l1OO9;
	PROCESS (wire_nl1i0l_dataout)
	BEGIN
		IF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN n0l1OO9 <= n0l1OO10;
		END IF;
		if (now = 0 ns) then
			n0l1OO9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (n0l1il, wire_n01ii_PRN, wire_n01ii_CLRN)
	BEGIN
		IF (wire_n01ii_PRN = '0') THEN
				n011O <= '1';
				n01il <= '1';
				n1O0O <= '1';
				n1O1l <= '1';
				n1Oli <= '1';
				n1OOl <= '1';
		ELSIF (wire_n01ii_CLRN = '0') THEN
				n011O <= '0';
				n01il <= '0';
				n1O0O <= '0';
				n1O1l <= '0';
				n1Oli <= '0';
				n1OOl <= '0';
		ELSIF (n0l1il = '1' AND n0l1il'event) THEN
				n011O <= wire_n011i_dataout;
				n01il <= wire_n010l_dataout;
				n1O0O <= wire_n1O0i_dataout;
				n1O1l <= wire_n1lOO_dataout;
				n1Oli <= wire_n1Oil_dataout;
				n1OOl <= wire_n1OlO_dataout;
		END IF;
	END PROCESS;
	wire_n01ii_CLRN <= ((n0illi46 XOR n0illi45) AND radce_rstb);
	wire_n01ii_PRN <= (n0iliO48 XOR n0iliO47);
	wire_n01ii_w_lg_n1O1l250w(0) <= NOT n1O1l;
	PROCESS (n0l1il, wire_n01iO_PRN, wire_n01iO_CLRN)
	BEGIN
		IF (wire_n01iO_PRN = '0') THEN
				n010i <= '1';
				n01li <= '1';
				n1O1O <= '1';
				n1Oii <= '1';
				n1Oll <= '1';
				n1OOO <= '1';
		ELSIF (wire_n01iO_CLRN = '0') THEN
				n010i <= '0';
				n01li <= '0';
				n1O1O <= '0';
				n1Oii <= '0';
				n1Oll <= '0';
				n1OOO <= '0';
		ELSIF (n0l1il = '1' AND n0l1il'event) THEN
				n010i <= wire_n011i_w_lg_dataout243w(0);
				n01li <= wire_n010l_w_lg_dataout234w(0);
				n1O1O <= wire_n1lOO_w_lg_dataout251w(0);
				n1Oii <= wire_n1O0i_w_lg_dataout249w(0);
				n1Oll <= wire_n1Oil_w_lg_dataout247w(0);
				n1OOO <= wire_n1OlO_w_lg_dataout245w(0);
		END IF;
		if (now = 0 ns) then
			n010i <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n01li <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n1O1O <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n1Oii <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n1Oll <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n1OOO <= '1' after 1 ps;
		end if;
	END PROCESS;
	wire_n01iO_CLRN <= (n0ilOi42 XOR n0ilOi41);
	wire_n01iO_PRN <= ((n0illO44 XOR n0illO43) AND radce_rstb);
	PROCESS (n000li, n0li1l)
	BEGIN
		IF (n0li1l = '0') THEN
				n0lili <= '0';
				n0liOO <= '0';
				n0ll0l <= '0';
				n0llll <= '0';
		ELSIF (n000li = '1' AND n000li'event) THEN
				n0lili <= wire_n0liil_dataout;
				n0liOO <= wire_n0liOi_dataout;
				n0ll0l <= wire_n0ll1O_dataout;
				n0llll <= wire_n0llil_dataout;
		END IF;
	END PROCESS;
	wire_n0llli_w_lg_n0lili1478w(0) <= NOT n0lili;
	wire_n0llli_w_lg_n0liOO1487w(0) <= NOT n0liOO;
	wire_n0llli_w_lg_n0ll0l1498w(0) <= NOT n0ll0l;
	wire_n0llli_w_lg_n0llll1507w(0) <= NOT n0llll;
	PROCESS (n000li, n0li1l)
	BEGIN
		IF (n0li1l = '0') THEN
				n0lill <= '1';
				n0ll0O <= '1';
				n0ll1i <= '1';
				n0llOi <= '1';
		ELSIF (n000li = '1' AND n000li'event) THEN
				n0lill <= wire_n0liil_w_lg_dataout1524w(0);
				n0ll0O <= wire_n0ll1O_w_lg_dataout1518w(0);
				n0ll1i <= wire_n0liOi_w_lg_dataout1521w(0);
				n0llOi <= wire_n0llil_w_lg_dataout1515w(0);
		END IF;
		if (now = 0 ns) then
			n0lill <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0ll0O <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0ll1i <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0llOi <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (n000Oi, n0li1i)
	BEGIN
		IF (n0li1i = '0') THEN
				n0O00O <= '0';
				n0O10l <= '0';
				n0O1li <= '0';
				n0O1OO <= '0';
		ELSIF (n000Oi = '1' AND n000Oi'event) THEN
				n0O00O <= wire_n0O01O_dataout;
				n0O10l <= wire_n0O11O_dataout;
				n0O1li <= wire_n0O1il_dataout;
				n0O1OO <= wire_n0O1Oi_dataout;
		END IF;
	END PROCESS;
	wire_n0O00l_w_lg_n0O00O1446w(0) <= NOT n0O00O;
	wire_n0O00l_w_lg_n0O10l1417w(0) <= NOT n0O10l;
	wire_n0O00l_w_lg_n0O1li1426w(0) <= NOT n0O1li;
	wire_n0O00l_w_lg_n0O1OO1437w(0) <= NOT n0O1OO;
	PROCESS (n000Oi, n0li1i)
	BEGIN
		IF (n0li1i = '0') THEN
				n0O01i <= '1';
				n0O0il <= '1';
				n0O10O <= '1';
				n0O1ll <= '1';
		ELSIF (n000Oi = '1' AND n000Oi'event) THEN
				n0O01i <= wire_n0O1Oi_w_lg_dataout1457w(0);
				n0O0il <= wire_n0O01O_w_lg_dataout1454w(0);
				n0O10O <= wire_n0O11O_w_lg_dataout1463w(0);
				n0O1ll <= wire_n0O1il_w_lg_dataout1460w(0);
		END IF;
		if (now = 0 ns) then
			n0O01i <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0O0il <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0O10O <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0O1ll <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_n0Oili_CLK, radce_rstb)
	BEGIN
		IF (radce_rstb = '0') THEN
				n0Oill <= '0';
		ELSIF (wire_n0Oili_CLK = '1' AND wire_n0Oili_CLK'event) THEN
				n0Oill <= n000Ol;
		END IF;
	END PROCESS;
	wire_n0Oili_CLK <= (NOT wire_n0i1i_dataout(0));
	wire_n0Oili_w_lg_n0Oill1405w(0) <= NOT n0Oill;
	PROCESS (wire_n0i1i_dataout(0), radce_rstb)
	BEGIN
		IF (radce_rstb = '0') THEN
				n0OiOi <= '0';
		ELSIF (wire_n0i1i_dataout(0) = '1' AND wire_n0i1i_dataout(0)'event) THEN
				n0OiOi <= wire_w_lg_n000OO1409w(0);
		END IF;
	END PROCESS;
	wire_n0OilO_CLK <= wire_n0i1i_dataout(0);
	PROCESS (n00i1O, n0l0Ol)
	BEGIN
		IF (n0l0Ol = '0') THEN
				n0Ol0i <= '0';
				n0OliO <= '0';
				n0OlOl <= '0';
				n0OO0l <= '0';
		ELSIF (n00i1O = '1' AND n00i1O'event) THEN
				n0Ol0i <= wire_n0Ol1l_dataout;
				n0OliO <= wire_n0Olii_dataout;
				n0OlOl <= wire_n0OllO_dataout;
				n0OO0l <= wire_n0OO1l_dataout;
		END IF;
	END PROCESS;
	wire_n0OO0i_w_lg_n0Ol0i1357w(0) <= NOT n0Ol0i;
	wire_n0OO0i_w_lg_n0OliO1366w(0) <= NOT n0OliO;
	wire_n0OO0i_w_lg_n0OlOl1377w(0) <= NOT n0OlOl;
	wire_n0OO0i_w_lg_n0OO0l1386w(0) <= NOT n0OO0l;
	PROCESS (n00i1O, n0l0Ol)
	BEGIN
		IF (n0l0Ol = '0') THEN
				n0Ol0l <= '1';
				n0Olli <= '1';
				n0OlOO <= '1';
				n0OOii <= '1';
		ELSIF (n00i1O = '1' AND n00i1O'event) THEN
				n0Ol0l <= wire_n0Ol1l_w_lg_dataout1403w(0);
				n0Olli <= wire_n0Olii_w_lg_dataout1400w(0);
				n0OlOO <= wire_n0OllO_w_lg_dataout1397w(0);
				n0OOii <= wire_n0OO1l_w_lg_dataout1394w(0);
		END IF;
		if (now = 0 ns) then
			n0Ol0l <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0Olli <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0OlOO <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n0OOii <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (n0l0lO, wire_n1i1i_CLRN)
	BEGIN
		IF (wire_n1i1i_CLRN = '0') THEN
				n100i <= '0';
				n10li <= '0';
				n1i1l <= '0';
		ELSIF (n0l0lO = '1' AND n0l0lO'event) THEN
				n100i <= wire_n101l_dataout;
				n10li <= wire_n10il_dataout;
				n1i1l <= wire_n10Ol_dataout;
		END IF;
	END PROCESS;
	wire_n1i1i_CLRN <= ((n0il1O54 XOR n0il1O53) AND n0ilil);
	wire_n1i1i_w_lg_n100i276w(0) <= NOT n100i;
	wire_n1i1i_w_lg_n10li285w(0) <= NOT n10li;
	wire_n1i1i_w_lg_n1i1l295w(0) <= NOT n1i1l;
	PROCESS (n0l0lO, n0ilil)
	BEGIN
		IF (n0ilil = '0') THEN
				n100l <= '1';
				n10ll <= '1';
				n1i0i <= '1';
		ELSIF (n0l0lO = '1' AND n0l0lO'event) THEN
				n100l <= wire_n101l_w_lg_dataout310w(0);
				n10ll <= wire_n10il_w_lg_dataout309w(0);
				n1i0i <= wire_n10Ol_w_lg_dataout303w(0);
		END IF;
		if (now = 0 ns) then
			n100l <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n10ll <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			n1i0i <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (n0l0lO, wire_n1l0i_CLRN)
	BEGIN
		IF (wire_n1l0i_CLRN = '0') THEN
				n1l0l <= '0';
		ELSIF (n0l0lO = '0' AND n0l0lO'event) THEN
				n1l0l <= n0il0O;
		END IF;
	END PROCESS;
	wire_n1l0i_CLRN <= ((n0il0l50 XOR n0il0l49) AND radce_rstb);
	wire_n1l0i_w_lg_n1l0l263w(0) <= NOT n1l0l;
	PROCESS (wire_n1l0O_dataout, wire_n1l1l_PRN, wire_nl1lOi_dataout(0))
	BEGIN
		IF (wire_n1l1l_PRN = '0') THEN
				n1l1O <= '1';
		ELSIF (wire_nl1lOi_dataout(0) = '0') THEN
				n1l1O <= '0';
		ELSIF (wire_n1l0O_dataout = '1' AND wire_n1l0O_dataout'event) THEN
				n1l1O <= wire_w_lg_n0l00l31w(0);
		END IF;
	END PROCESS;
	wire_n1l1l_CLRN <= wire_nl1lOi_dataout(0);
	wire_n1l1l_PRN <= ((n0il0i52 XOR n0il0i51) AND (NOT (wire_w_lg_radce_rstb267w(0) AND wire_nl1lOi_dataout(0))));
	wire_n1l1l_w_lg_n1l1O370w(0) <= NOT n1l1O;
	PROCESS (fixed_clk, radce_rstb)
	BEGIN
		IF (radce_rstb = '0') THEN
				n1llO <= '0';
				n1lOl <= '0';
		ELSIF (fixed_clk = '0' AND fixed_clk'event) THEN
				n1llO <= (NOT ((adapt_capture OR standby) OR wire_w_lg_n0liii258w(0)));
				n1lOl <= n1llO;
		END IF;
	END PROCESS;
	PROCESS (wire_nl1i0l_dataout, n00iOi, wire_ni0i0O_w_dataout_range1237w(0))
	BEGIN
		IF (n00iOi = '1') THEN
				ni00iO <= '1';
		ELSIF (wire_ni0i0O_w_dataout_range1237w(0) = '0') THEN
				ni00iO <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni00iO <= wire_ni00Ol_dataout;
		END IF;
	END PROCESS;
	wire_ni00il_CLRN <= wire_ni0i0O_dataout(0);
	wire_ni00il_w_lg_ni00iO1068w(0) <= NOT ni00iO;
	PROCESS (wire_nl1i0l_dataout, wire_ni0i0O_w_dataout_range1237w(0), n00iOi)
	BEGIN
		IF (wire_ni0i0O_w_dataout_range1237w(0) = '0') THEN
				ni00ll <= '1';
		ELSIF (n00iOi = '1') THEN
				ni00ll <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni00ll <= wire_ni00Ol_w_lg_dataout1235w(0);
		END IF;
	END PROCESS;
	wire_ni00li_PRN <= wire_ni0i0O_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00ili, wire_ni001l_w_dataout_range1256w(0))
	BEGIN
		IF (n00ili = '1') THEN
				ni010l <= '1';
		ELSIF (wire_ni001l_w_dataout_range1256w(0) = '0') THEN
				ni010l <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni010l <= wire_ni01li_dataout;
		END IF;
	END PROCESS;
	wire_ni010i_CLRN <= wire_ni001l_dataout(0);
	wire_ni010i_w_lg_ni010l1086w(0) <= NOT ni010l;
	PROCESS (wire_nl1i0l_dataout, wire_ni001l_w_dataout_range1256w(0), n00ili)
	BEGIN
		IF (wire_ni001l_w_dataout_range1256w(0) = '0') THEN
				ni01ii <= '1';
		ELSIF (n00ili = '1') THEN
				ni01ii <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni01ii <= wire_ni01li_w_lg_dataout1254w(0);
		END IF;
	END PROCESS;
	wire_ni010O_PRN <= wire_ni001l_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00l1i, wire_ni0lli_w_dataout_range1218w(0))
	BEGIN
		IF (n00l1i = '1') THEN
				ni0iOi <= '1';
		ELSIF (wire_ni0lli_w_dataout_range1218w(0) = '0') THEN
				ni0iOi <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni0iOi <= wire_ni0l1O_dataout;
		END IF;
	END PROCESS;
	wire_ni0ilO_CLRN <= wire_ni0lli_dataout(0);
	wire_ni0ilO_w_lg_ni0iOi1039w(0) <= NOT ni0iOi;
	PROCESS (wire_nl1i0l_dataout, wire_ni0lli_w_dataout_range1218w(0), n00l1i)
	BEGIN
		IF (wire_ni0lli_w_dataout_range1218w(0) = '0') THEN
				ni0iOO <= '1';
		ELSIF (n00l1i = '1') THEN
				ni0iOO <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni0iOO <= wire_ni0l1O_w_lg_dataout1216w(0);
		END IF;
	END PROCESS;
	wire_ni0iOl_PRN <= wire_ni0lli_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00l0i, wire_ni0OOl_w_dataout_range1199w(0))
	BEGIN
		IF (n00l0i = '1') THEN
				ni0O1l <= '1';
		ELSIF (wire_ni0OOl_w_dataout_range1199w(0) = '0') THEN
				ni0O1l <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni0O1l <= wire_ni0Oii_dataout;
		END IF;
	END PROCESS;
	wire_ni0O1i_CLRN <= wire_ni0OOl_dataout(0);
	wire_ni0O1i_w_lg_ni0O1l1049w(0) <= NOT ni0O1l;
	PROCESS (wire_nl1i0l_dataout, wire_ni0OOl_w_dataout_range1199w(0), n00l0i)
	BEGIN
		IF (wire_ni0OOl_w_dataout_range1199w(0) = '0') THEN
				ni0O0i <= '1';
		ELSIF (n00l0i = '1') THEN
				ni0O0i <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni0O0i <= wire_ni0Oii_w_lg_dataout1197w(0);
		END IF;
	END PROCESS;
	wire_ni0O1O_PRN <= wire_ni0OOl_dataout(0);
	PROCESS (n00i0O, n0l0Oi)
	BEGIN
		IF (n0l0Oi = '0') THEN
				ni100i <= '0';
				ni10iO <= '0';
				ni10OO <= '0';
				ni11Ol <= '0';
		ELSIF (n00i0O = '1' AND n00i0O'event) THEN
				ni100i <= wire_ni101l_dataout;
				ni10iO <= wire_ni10ii_dataout;
				ni10OO <= wire_ni10lO_dataout;
				ni11Ol <= wire_ni11lO_dataout;
		END IF;
	END PROCESS;
	wire_ni10Ol_w_lg_ni100i1305w(0) <= NOT ni100i;
	wire_ni10Ol_w_lg_ni10iO1316w(0) <= NOT ni10iO;
	wire_ni10Ol_w_lg_ni10OO1325w(0) <= NOT ni10OO;
	wire_ni10Ol_w_lg_ni11Ol1296w(0) <= NOT ni11Ol;
	PROCESS (n00i0O, n0l0Oi)
	BEGIN
		IF (n0l0Oi = '0') THEN
				ni100l <= '1';
				ni10li <= '1';
				ni11OO <= '1';
				ni1i1l <= '1';
		ELSIF (n00i0O = '1' AND n00i0O'event) THEN
				ni100l <= wire_ni101l_w_lg_dataout1339w(0);
				ni10li <= wire_ni10ii_w_lg_dataout1336w(0);
				ni11OO <= wire_ni11lO_w_lg_dataout1342w(0);
				ni1i1l <= wire_ni10lO_w_lg_dataout1333w(0);
		END IF;
		if (now = 0 ns) then
			ni100l <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			ni10li <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			ni11OO <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			ni1i1l <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (wire_ni1l0i_CLK, radce_rstb)
	BEGIN
		IF (radce_rstb = '0') THEN
				ni1l0l <= '0';
		ELSIF (wire_ni1l0i_CLK = '1' AND wire_ni1l0i_CLK'event) THEN
				ni1l0l <= n00iii;
		END IF;
	END PROCESS;
	wire_ni1l0i_CLK <= (NOT wire_n0l1O_dataout(0));
	wire_ni1l0i_w_lg_ni1l0l1284w(0) <= NOT ni1l0l;
	PROCESS (wire_n0l1O_dataout(0), radce_rstb)
	BEGIN
		IF (radce_rstb = '0') THEN
				ni1lii <= '0';
		ELSIF (wire_n0l1O_dataout(0) = '1' AND wire_n0l1O_dataout(0)'event) THEN
				ni1lii <= wire_w_lg_n00iil1288w(0);
		END IF;
	END PROCESS;
	wire_ni1l0O_CLK <= wire_n0l1O_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00iiO, wire_ni1OOi_w_dataout_range1275w(0))
	BEGIN
		IF (n00iiO = '1') THEN
				ni1O1i <= '1';
		ELSIF (wire_ni1OOi_w_dataout_range1275w(0) = '0') THEN
				ni1O1i <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni1O1i <= wire_ni1O0O_dataout;
		END IF;
	END PROCESS;
	wire_ni1lOO_CLRN <= wire_ni1OOi_dataout(0);
	wire_ni1lOO_w_lg_ni1O1i1078w(0) <= NOT ni1O1i;
	PROCESS (wire_nl1i0l_dataout, wire_ni1OOi_w_dataout_range1275w(0), n00iiO)
	BEGIN
		IF (wire_ni1OOi_w_dataout_range1275w(0) = '0') THEN
				ni1O1O <= '1';
		ELSIF (n00iiO = '1') THEN
				ni1O1O <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				ni1O1O <= wire_ni1O0O_w_lg_dataout1273w(0);
		END IF;
	END PROCESS;
	wire_ni1O1l_PRN <= wire_ni1OOi_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00lli, wire_niiiii_w_dataout_range1155w(0))
	BEGIN
		IF (n00lli = '1') THEN
				nii0li <= '1';
		ELSIF (wire_niiiii_w_dataout_range1155w(0) = '0') THEN
				nii0li <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				nii0li <= wire_nii0OO_dataout;
		END IF;
	END PROCESS;
	wire_nii0iO_CLRN <= wire_niiiii_dataout(0);
	wire_nii0iO_w_lg_nii0li939w(0) <= NOT nii0li;
	PROCESS (wire_nl1i0l_dataout, wire_niiiii_w_dataout_range1155w(0), n00lli)
	BEGIN
		IF (wire_niiiii_w_dataout_range1155w(0) = '0') THEN
				nii0lO <= '1';
		ELSIF (n00lli = '1') THEN
				nii0lO <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				nii0lO <= wire_nii0OO_w_lg_dataout1153w(0);
		END IF;
	END PROCESS;
	wire_nii0ll_PRN <= wire_niiiii_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00lii, wire_nii01O_w_dataout_range1177w(0))
	BEGIN
		IF (n00lii = '1') THEN
				nii10O <= '1';
		ELSIF (wire_nii01O_w_dataout_range1177w(0) = '0') THEN
				nii10O <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				nii10O <= wire_nii1ll_dataout;
		END IF;
	END PROCESS;
	wire_nii10l_CLRN <= wire_nii01O_dataout(0);
	wire_nii10l_w_lg_nii10O1057w(0) <= NOT nii10O;
	PROCESS (wire_nl1i0l_dataout, wire_nii01O_w_dataout_range1177w(0), n00lii)
	BEGIN
		IF (wire_nii01O_w_dataout_range1177w(0) = '0') THEN
				nii1il <= '1';
		ELSIF (n00lii = '1') THEN
				nii1il <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				nii1il <= wire_nii1ll_w_lg_dataout1175w(0);
		END IF;
	END PROCESS;
	wire_nii1ii_PRN <= wire_nii01O_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00lll, wire_niilll_w_dataout_range1136w(0))
	BEGIN
		IF (n00lll = '1') THEN
				niiiOl <= '1';
		ELSIF (wire_niilll_w_dataout_range1136w(0) = '0') THEN
				niiiOl <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				niiiOl <= wire_niil0i_dataout;
		END IF;
	END PROCESS;
	wire_niiiOi_CLRN <= wire_niilll_dataout(0);
	wire_niiiOi_w_lg_niiiOl940w(0) <= NOT niiiOl;
	PROCESS (wire_nl1i0l_dataout, wire_niilll_w_dataout_range1136w(0), n00lll)
	BEGIN
		IF (wire_niilll_w_dataout_range1136w(0) = '0') THEN
				niil1i <= '1';
		ELSIF (n00lll = '1') THEN
				niil1i <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				niil1i <= wire_niil0i_w_lg_dataout1134w(0);
		END IF;
	END PROCESS;
	wire_niiiOO_PRN <= wire_niilll_dataout(0);
	PROCESS (wire_nl1i0l_dataout, wire_niiOOO_w_dataout_range1117w(0), n00lOl)
	BEGIN
		IF (wire_niiOOO_w_dataout_range1117w(0) = '0') THEN
				niiO0l <= '1';
		ELSIF (n00lOl = '1') THEN
				niiO0l <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				niiO0l <= wire_niiOil_w_lg_dataout1115w(0);
		END IF;
	END PROCESS;
	wire_niiO0i_PRN <= wire_niiOOO_dataout(0);
	PROCESS (wire_nl1i0l_dataout, n00lOl, wire_niiOOO_w_dataout_range1117w(0))
	BEGIN
		IF (n00lOl = '1') THEN
				niiO1O <= '1';
		ELSIF (wire_niiOOO_w_dataout_range1117w(0) = '0') THEN
				niiO1O <= '0';
		ELSIF (wire_nl1i0l_dataout = '1' AND wire_nl1i0l_dataout'event) THEN
				niiO1O <= wire_niiOil_dataout;
		END IF;
	END PROCESS;
	wire_niiO1l_CLRN <= wire_niiOOO_dataout(0);
	wire_niiO1l_w_lg_niiO1O937w(0) <= NOT niiO1O;
	PROCESS (wire_nl1i1O_dataout, wire_nl10Ol_PRN, wire_nl1lOi_dataout(0))
	BEGIN
		IF (wire_nl10Ol_PRN = '0') THEN
				nl10OO <= '1';
		ELSIF (wire_nl1lOi_dataout(0) = '0') THEN
				nl10OO <= '0';
		ELSIF (wire_nl1i1O_dataout = '1' AND wire_nl1i1O_dataout'event) THEN
				nl10OO <= n0l00O;
		END IF;
	END PROCESS;
	wire_nl10Ol_CLRN <= wire_nl1lOi_dataout(0);
	wire_nl10Ol_PRN <= ((n0i1iO74 XOR n0i1iO73) AND (NOT (wire_w_lg_radce_rstb267w(0) AND wire_nl1lOi_dataout(0))));
	wire_nl10Ol_w_lg_nl10OO889w(0) <= NOT nl10OO;
	PROCESS (n0li0i, wire_nl11Oi_PRN, wire_nl11Oi_CLRN)
	BEGIN
		IF (wire_nl11Oi_PRN = '0') THEN
				nl111i <= '1';
				nl11ii <= '1';
				nl11Ol <= '1';
		ELSIF (wire_nl11Oi_CLRN = '0') THEN
				nl111i <= '0';
				nl11ii <= '0';
				nl11Ol <= '0';
		ELSIF (n0li0i = '1' AND n0li0i'event) THEN
				nl111i <= wire_niOOOl_dataout;
				nl11ii <= wire_nl110l_dataout;
				nl11Ol <= wire_nl11ll_dataout;
		END IF;
	END PROCESS;
	wire_nl11Oi_CLRN <= ((n0i1ii78 XOR n0i1ii77) AND n0i1Oi);
	wire_nl11Oi_PRN <= (n0i10O80 XOR n0i10O79);
	wire_nl11Oi_w_lg_nl111i830w(0) <= NOT nl111i;
	wire_nl11Oi_w_lg_nl11ii839w(0) <= NOT nl11ii;
	wire_nl11Oi_w_lg_nl11Ol849w(0) <= NOT nl11Ol;
	PROCESS (n0li0i, n0i1Oi, wire_nl11OO_CLRN)
	BEGIN
		IF (n0i1Oi = '0') THEN
				nl101i <= '1';
				nl111l <= '1';
				nl11il <= '1';
		ELSIF (wire_nl11OO_CLRN = '0') THEN
				nl101i <= '0';
				nl111l <= '0';
				nl11il <= '0';
		ELSIF (n0li0i = '1' AND n0li0i'event) THEN
				nl101i <= wire_nl11ll_w_lg_dataout857w(0);
				nl111l <= wire_niOOOl_w_lg_dataout866w(0);
				nl11il <= wire_nl110l_w_lg_dataout865w(0);
		END IF;
		if (now = 0 ns) then
			nl101i <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl111l <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl11il <= '1' after 1 ps;
		end if;
	END PROCESS;
	wire_nl11OO_CLRN <= (n0i1il76 XOR n0i1il75);
	PROCESS (n0li0i, wire_nl1i1i_CLRN)
	BEGIN
		IF (wire_nl1i1i_CLRN = '0') THEN
				nl1i1l <= '0';
		ELSIF (n0li0i = '0' AND n0li0i'event) THEN
				nl1i1l <= n0i1ll;
		END IF;
	END PROCESS;
	wire_nl1i1i_CLRN <= ((n0i1li72 XOR n0i1li71) AND radce_rstb);
	wire_nl1i1i_w_lg_nl1i1l820w(0) <= NOT nl1i1l;
	PROCESS (wire_n1lil_dataout, wire_nll01l_PRN, n0i0li)
	BEGIN
		IF (wire_nll01l_PRN = '0') THEN
				nll01O <= '1';
		ELSIF (n0i0li = '1') THEN
				nll01O <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nll01O <= wire_nll00O_w_lg_dataout503w(0);
		END IF;
	END PROCESS;
	wire_nll01l_PRN <= ((n0i0iO68 XOR n0i0iO67) AND wire_nll0Oi_dataout(0));
	PROCESS (wire_n1lil_dataout, n0i0li, wire_nll1OO_CLRN)
	BEGIN
		IF (n0i0li = '1') THEN
				nll01i <= '1';
		ELSIF (wire_nll1OO_CLRN = '0') THEN
				nll01i <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nll01i <= wire_nll00O_dataout;
		END IF;
	END PROCESS;
	wire_nll1OO_CLRN <= ((n0i0il70 XOR n0i0il69) AND wire_nll0Oi_dataout(0));
	wire_nll1OO_w_lg_nll01i353w(0) <= NOT nll01i;
	PROCESS (wire_n1lil_dataout, wire_nlli0i_PRN, wire_nlll1l_w_dataout_range482w(0))
	BEGIN
		IF (wire_nlli0i_PRN = '0') THEN
				nlli0l <= '1';
		ELSIF (wire_nlll1l_w_dataout_range482w(0) = '0') THEN
				nlli0l <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nlli0l <= wire_nllili_dataout;
		END IF;
	END PROCESS;
	wire_nlli0i_CLRN <= wire_nlll1l_dataout(0);
	wire_nlli0i_PRN <= ((n0i0ll66 XOR n0i0ll65) AND wire_w_lg_n0i0Oi481w(0));
	wire_nlli0i_w_lg_nlli0l361w(0) <= NOT nlli0l;
	PROCESS (wire_n1lil_dataout, wire_nlli0O_PRN, n0i0Oi)
	BEGIN
		IF (wire_nlli0O_PRN = '0') THEN
				nlliii <= '1';
		ELSIF (n0i0Oi = '1') THEN
				nlliii <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nlliii <= wire_nllili_w_lg_dataout480w(0);
		END IF;
	END PROCESS;
	wire_nlli0O_PRN <= ((n0i0lO64 XOR n0i0lO63) AND wire_nlll1l_dataout(0));
	PROCESS (wire_n1lil_dataout, wire_nlllil_PRN, wire_nllO0O_w_dataout_range461w(0))
	BEGIN
		IF (wire_nlllil_PRN = '0') THEN
				nllliO <= '1';
		ELSIF (wire_nllO0O_w_dataout_range461w(0) = '0') THEN
				nllliO <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nllliO <= wire_nlllOl_dataout;
		END IF;
	END PROCESS;
	wire_nlllil_CLRN <= wire_nllO0O_dataout(0);
	wire_nlllil_PRN <= ((n0ii1i62 XOR n0ii1i61) AND wire_w_lg_n0ii1l460w(0));
	wire_nlllil_w_lg_w_lg_w_lg_nllliO341w342w346w(0) <= wire_nlllil_w_lg_w_lg_nllliO341w342w(0) AND wire_nlllil_w_lg_w_lg_w_lg_nllliO343w344w345w(0);
	wire_nlllil_w_lg_w_lg_nllliO343w344w(0) <= wire_nlllil_w_lg_nllliO343w(0) AND wire_nlOlli_dataout;
	wire_nlllil_w_lg_nllliO341w(0) <= nllliO AND wire_nlOlli_w_lg_dataout340w(0);
	wire_nlllil_w_lg_w_lg_w_lg_w_lg_nllliO341w342w346w347w(0) <= NOT wire_nlllil_w_lg_w_lg_w_lg_nllliO341w342w346w(0);
	wire_nlllil_w_lg_w_lg_w_lg_nllliO343w344w345w(0) <= NOT wire_nlllil_w_lg_w_lg_nllliO343w344w(0);
	wire_nlllil_w_lg_w_lg_nllliO341w342w(0) <= NOT wire_nlllil_w_lg_nllliO341w(0);
	wire_nlllil_w_lg_nllliO343w(0) <= NOT nllliO;
	PROCESS (wire_n1lil_dataout, wire_nllO0O_w_dataout_range461w(0), n0ii1l)
	BEGIN
		IF (wire_nllO0O_w_dataout_range461w(0) = '0') THEN
				nlllll <= '1';
		ELSIF (n0ii1l = '1') THEN
				nlllll <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nlllll <= wire_nlllOl_w_lg_dataout459w(0);
		END IF;
	END PROCESS;
	wire_nlllli_PRN <= wire_nllO0O_dataout(0);
	PROCESS (wire_n1lil_dataout, n0ii0O, wire_nlO1li_w_dataout_range442w(0))
	BEGIN
		IF (n0ii0O = '1') THEN
				nllOOi <= '1';
		ELSIF (wire_nlO1li_w_dataout_range442w(0) = '0') THEN
				nllOOi <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nllOOi <= wire_nlO11O_dataout;
		END IF;
	END PROCESS;
	wire_nllOlO_CLRN <= wire_nlO1li_dataout(0);
	wire_nllOlO_w_lg_w_lg_w_lg_nllOOi312w313w317w(0) <= wire_nllOlO_w_lg_w_lg_nllOOi312w313w(0) AND wire_nllOlO_w_lg_w_lg_w_lg_nllOOi314w315w316w(0);
	wire_nllOlO_w_lg_w_lg_nllOOi314w315w(0) <= wire_nllOlO_w_lg_nllOOi314w(0) AND wire_nlOllO_dataout;
	wire_nllOlO_w_lg_nllOOi312w(0) <= nllOOi AND wire_nlOllO_w_lg_dataout311w(0);
	wire_nllOlO_w_lg_w_lg_w_lg_w_lg_nllOOi312w313w317w318w(0) <= NOT wire_nllOlO_w_lg_w_lg_w_lg_nllOOi312w313w317w(0);
	wire_nllOlO_w_lg_w_lg_w_lg_nllOOi314w315w316w(0) <= NOT wire_nllOlO_w_lg_w_lg_nllOOi314w315w(0);
	wire_nllOlO_w_lg_w_lg_nllOOi312w313w(0) <= NOT wire_nllOlO_w_lg_nllOOi312w(0);
	wire_nllOlO_w_lg_nllOOi314w(0) <= NOT nllOOi;
	PROCESS (wire_n1lil_dataout, wire_nlO1li_w_dataout_range442w(0), wire_nllOOl_CLRN)
	BEGIN
		IF (wire_nlO1li_w_dataout_range442w(0) = '0') THEN
				nllOOO <= '1';
		ELSIF (wire_nllOOl_CLRN = '0') THEN
				nllOOO <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nllOOO <= wire_nlO11O_w_lg_dataout438w(0);
		END IF;
	END PROCESS;
	wire_nllOOl_CLRN <= ((n0ii0l60 XOR n0ii0l59) AND wire_w_lg_n0ii0O440w(0));
	wire_nllOOl_PRN <= wire_nlO1li_dataout(0);
	PROCESS (wire_n1lil_dataout, n0iili, wire_nlO0Ol_w_dataout_range417w(0))
	BEGIN
		IF (n0iili = '1') THEN
				nlO01l <= '1';
		ELSIF (wire_nlO0Ol_w_dataout_range417w(0) = '0') THEN
				nlO01l <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nlO01l <= wire_nlO0ii_dataout;
		END IF;
	END PROCESS;
	wire_nlO01i_CLRN <= wire_nlO0Ol_dataout(0);
	wire_nlO01i_w_lg_nlO01l324w(0) <= NOT nlO01l;
	PROCESS (wire_n1lil_dataout, wire_nlO01O_PRN, n0iili)
	BEGIN
		IF (wire_nlO01O_PRN = '0') THEN
				nlO00i <= '1';
		ELSIF (n0iili = '1') THEN
				nlO00i <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nlO00i <= wire_nlO0ii_w_lg_dataout415w(0);
		END IF;
	END PROCESS;
	wire_nlO01O_PRN <= ((n0iiiO58 XOR n0iiiO57) AND wire_nlO0Ol_dataout(0));
	PROCESS (wire_n1lil_dataout, n0iiOl, wire_nlOl1O_w_dataout_range396w(0))
	BEGIN
		IF (n0iiOl = '1') THEN
				nlOi0O <= '1';
		ELSIF (wire_nlOl1O_w_dataout_range396w(0) = '0') THEN
				nlOi0O <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nlOi0O <= wire_nlOill_dataout;
		END IF;
	END PROCESS;
	wire_nlOi0l_CLRN <= wire_nlOl1O_dataout(0);
	wire_nlOi0l_w_lg_nlOi0O332w(0) <= NOT nlOi0O;
	PROCESS (wire_n1lil_dataout, wire_nlOl1O_w_dataout_range396w(0), wire_nlOiii_CLRN)
	BEGIN
		IF (wire_nlOl1O_w_dataout_range396w(0) = '0') THEN
				nlOiil <= '1';
		ELSIF (wire_nlOiii_CLRN = '0') THEN
				nlOiil <= '0';
		ELSIF (wire_n1lil_dataout = '1' AND wire_n1lil_dataout'event) THEN
				nlOiil <= wire_nlOill_w_lg_dataout392w(0);
		END IF;
	END PROCESS;
	wire_nlOiii_CLRN <= ((n0iiOi56 XOR n0iiOi55) AND wire_w_lg_n0iiOl394w(0));
	wire_nlOiii_PRN <= wire_nlOl1O_dataout(0);
	wire_n00il_oe <= wire_w_lg_w_lg_w_radce_hflck_range213w225w230w(0);
	wire_w_lg_w_lg_w_radce_hflck_range213w225w230w(0) <= (radce_hflck(0) AND radce_hflck(1)) AND radce_hflck(2);
	n00il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_n00il_dataout,
		oe => wire_n00il_oe
	  );
	wire_n00iO_oe <= wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w223w229w(0);
	wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w223w229w(0) <= ((NOT radce_hflck(0)) AND radce_hflck(1)) AND radce_hflck(2);
	n00iO :  io_buf_tri
	  PORT MAP ( 
		datain => n01il,
		dataout => wire_n00iO_dataout,
		oe => wire_n00iO_oe
	  );
	wire_n00li_oe <= wire_w_lg_w_lg_w_radce_hflck_range213w221w228w(0);
	wire_w_lg_w_lg_w_radce_hflck_range213w221w228w(0) <= wire_w_lg_w_radce_hflck_range213w221w(0) AND radce_hflck(2);
	n00li :  io_buf_tri
	  PORT MAP ( 
		datain => n011O,
		dataout => wire_n00li_dataout,
		oe => wire_n00li_oe
	  );
	wire_n00ll_oe <= wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w217w227w(0);
	wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w217w227w(0) <= ((NOT radce_hflck(0)) AND wire_w_lg_w_radce_hflck_range215w216w(0)) AND radce_hflck(2);
	n00ll :  io_buf_tri
	  PORT MAP ( 
		datain => n1OOl,
		dataout => wire_n00ll_dataout,
		oe => wire_n00ll_oe
	  );
	wire_n00lO_oe <= wire_w_lg_w_lg_w_radce_hflck_range213w225w226w(0);
	wire_w_lg_w_lg_w_radce_hflck_range213w225w226w(0) <= (radce_hflck(0) AND radce_hflck(1)) AND (NOT radce_hflck(2));
	n00lO :  io_buf_tri
	  PORT MAP ( 
		datain => n1Oli,
		dataout => wire_n00lO_dataout,
		oe => wire_n00lO_oe
	  );
	wire_n00Oi_oe <= wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w223w224w(0);
	wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w223w224w(0) <= ((NOT radce_hflck(0)) AND radce_hflck(1)) AND (NOT radce_hflck(2));
	n00Oi :  io_buf_tri
	  PORT MAP ( 
		datain => n1O0O,
		dataout => wire_n00Oi_dataout,
		oe => wire_n00Oi_oe
	  );
	wire_n00Ol_oe <= wire_w_lg_w_lg_w_radce_hflck_range213w221w222w(0);
	wire_w_lg_w_lg_w_radce_hflck_range213w221w222w(0) <= wire_w_lg_w_radce_hflck_range213w221w(0) AND (NOT radce_hflck(2));
	n00Ol :  io_buf_tri
	  PORT MAP ( 
		datain => n1O1l,
		dataout => wire_n00Ol_dataout,
		oe => wire_n00Ol_oe
	  );
	wire_n00OO_oe <= wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w217w220w(0);
	wire_w_lg_w_lg_w_lg_w_radce_hflck_range213w214w217w220w(0) <= ((NOT radce_hflck(0)) AND wire_w_lg_w_radce_hflck_range215w216w(0)) AND (NOT radce_hflck(2));
	n00OO :  io_buf_tri
	  PORT MAP ( 
		datain => n0l1il,
		dataout => wire_n00OO_dataout,
		oe => wire_n00OO_oe
	  );
	wire_n010l_w_lg_dataout234w(0) <= NOT wire_n010l_dataout;
	n010l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n010O_dataout,
		dataout => wire_n010l_dataout,
		oe => wire_vcc
	  );
	wire_n011i_w_lg_dataout243w(0) <= NOT wire_n011i_dataout;
	n011i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n011l_dataout,
		dataout => wire_n011i_dataout,
		oe => wire_vcc
	  );
	wire_n0ili_oe <= wire_w_lg_w_lg_w_radce_lflck_range186w198w203w(0);
	wire_w_lg_w_lg_w_radce_lflck_range186w198w203w(0) <= (radce_lflck(0) AND radce_lflck(1)) AND radce_lflck(2);
	n0ili :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_n0ili_dataout,
		oe => wire_n0ili_oe
	  );
	wire_n0ill_oe <= wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w196w202w(0);
	wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w196w202w(0) <= ((NOT radce_lflck(0)) AND radce_lflck(1)) AND radce_lflck(2);
	n0ill :  io_buf_tri
	  PORT MAP ( 
		datain => n01il,
		dataout => wire_n0ill_dataout,
		oe => wire_n0ill_oe
	  );
	wire_n0ilO_oe <= wire_w_lg_w_lg_w_radce_lflck_range186w194w201w(0);
	wire_w_lg_w_lg_w_radce_lflck_range186w194w201w(0) <= wire_w_lg_w_radce_lflck_range186w194w(0) AND radce_lflck(2);
	n0ilO :  io_buf_tri
	  PORT MAP ( 
		datain => n011O,
		dataout => wire_n0ilO_dataout,
		oe => wire_n0ilO_oe
	  );
	wire_n0iOi_oe <= wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w190w200w(0);
	wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w190w200w(0) <= ((NOT radce_lflck(0)) AND wire_w_lg_w_radce_lflck_range188w189w(0)) AND radce_lflck(2);
	n0iOi :  io_buf_tri
	  PORT MAP ( 
		datain => n1OOl,
		dataout => wire_n0iOi_dataout,
		oe => wire_n0iOi_oe
	  );
	wire_n0iOl_oe <= wire_w_lg_w_lg_w_radce_lflck_range186w198w199w(0);
	wire_w_lg_w_lg_w_radce_lflck_range186w198w199w(0) <= (radce_lflck(0) AND radce_lflck(1)) AND (NOT radce_lflck(2));
	n0iOl :  io_buf_tri
	  PORT MAP ( 
		datain => n1Oli,
		dataout => wire_n0iOl_dataout,
		oe => wire_n0iOl_oe
	  );
	wire_n0iOO_oe <= wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w196w197w(0);
	wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w196w197w(0) <= ((NOT radce_lflck(0)) AND radce_lflck(1)) AND (NOT radce_lflck(2));
	n0iOO :  io_buf_tri
	  PORT MAP ( 
		datain => n1O0O,
		dataout => wire_n0iOO_dataout,
		oe => wire_n0iOO_oe
	  );
	wire_n0l1i_oe <= wire_w_lg_w_lg_w_radce_lflck_range186w194w195w(0);
	wire_w_lg_w_lg_w_radce_lflck_range186w194w195w(0) <= wire_w_lg_w_radce_lflck_range186w194w(0) AND (NOT radce_lflck(2));
	n0l1i :  io_buf_tri
	  PORT MAP ( 
		datain => n1O1l,
		dataout => wire_n0l1i_dataout,
		oe => wire_n0l1i_oe
	  );
	wire_n0l1l_oe <= wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w190w193w(0);
	wire_w_lg_w_lg_w_lg_w_radce_lflck_range186w187w190w193w(0) <= ((NOT radce_lflck(0)) AND wire_w_lg_w_radce_lflck_range188w189w(0)) AND (NOT radce_lflck(2));
	n0l1l :  io_buf_tri
	  PORT MAP ( 
		datain => n0l1il,
		dataout => wire_n0l1l_dataout,
		oe => wire_n0l1l_oe
	  );
	wire_n0liil_w_lg_dataout1524w(0) <= NOT wire_n0liil_dataout;
	n0liil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0liiO_dataout,
		dataout => wire_n0liil_dataout,
		oe => wire_vcc
	  );
	wire_n0liOi_w_lg_dataout1521w(0) <= NOT wire_n0liOi_dataout;
	n0liOi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0liOl_dataout,
		dataout => wire_n0liOi_dataout,
		oe => wire_vcc
	  );
	wire_n0ll1O_w_lg_dataout1518w(0) <= NOT wire_n0ll1O_dataout;
	n0ll1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0ll0i_dataout,
		dataout => wire_n0ll1O_dataout,
		oe => wire_vcc
	  );
	wire_n0llil_w_lg_dataout1515w(0) <= NOT wire_n0llil_dataout;
	n0llil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0lliO_dataout,
		dataout => wire_n0llil_dataout,
		oe => wire_vcc
	  );
	wire_n0O01O_w_lg_dataout1454w(0) <= NOT wire_n0O01O_dataout;
	n0O01O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0O00i_dataout,
		dataout => wire_n0O01O_dataout,
		oe => wire_vcc
	  );
	wire_n0O11O_w_lg_dataout1463w(0) <= NOT wire_n0O11O_dataout;
	n0O11O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0O10i_dataout,
		dataout => wire_n0O11O_dataout,
		oe => wire_vcc
	  );
	wire_n0O1il_w_lg_dataout1460w(0) <= NOT wire_n0O1il_dataout;
	n0O1il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0O1iO_dataout,
		dataout => wire_n0O1il_dataout,
		oe => wire_vcc
	  );
	wire_n0O1Oi_w_lg_dataout1457w(0) <= NOT wire_n0O1Oi_dataout;
	n0O1Oi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0O1Ol_dataout,
		dataout => wire_n0O1Oi_dataout,
		oe => wire_vcc
	  );
	wire_n0Ol1l_w_lg_dataout1403w(0) <= NOT wire_n0Ol1l_dataout;
	n0Ol1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0Ol1O_dataout,
		dataout => wire_n0Ol1l_dataout,
		oe => wire_vcc
	  );
	wire_n0Olii_w_lg_dataout1400w(0) <= NOT wire_n0Olii_dataout;
	n0Olii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0Olil_dataout,
		dataout => wire_n0Olii_dataout,
		oe => wire_vcc
	  );
	wire_n0OllO_w_lg_dataout1397w(0) <= NOT wire_n0OllO_dataout;
	n0OllO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0OlOi_dataout,
		dataout => wire_n0OllO_dataout,
		oe => wire_vcc
	  );
	wire_n0OO1l_w_lg_dataout1394w(0) <= NOT wire_n0OO1l_dataout;
	n0OO1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n0OO1O_dataout,
		dataout => wire_n0OO1l_dataout,
		oe => wire_vcc
	  );
	n100O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n10ii_dataout,
		dataout => wire_n100O_dataout,
		oe => wire_vcc
	  );
	wire_n101l_w_lg_dataout310w(0) <= NOT wire_n101l_dataout;
	n101l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n101O_dataout,
		dataout => wire_n101l_dataout,
		oe => wire_vcc
	  );
	wire_n10il_w_lg_dataout309w(0) <= NOT wire_n10il_dataout;
	n10il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n10iO_dataout,
		dataout => wire_n10il_dataout,
		oe => wire_vcc
	  );
	n10lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n10Oi_dataout,
		dataout => wire_n10lO_dataout,
		oe => wire_vcc
	  );
	wire_n10Ol_w_lg_dataout303w(0) <= NOT wire_n10Ol_dataout;
	n10Ol :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n10OO_dataout,
		dataout => wire_n10Ol_dataout,
		oe => wire_vcc
	  );
	n11OO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n101i_dataout,
		dataout => wire_n11OO_dataout,
		oe => wire_vcc
	  );
	n1l0O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n1lii_dataout,
		dataout => wire_n1l0O_dataout,
		oe => wire_vcc
	  );
	n1lil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n1liO_dataout,
		dataout => wire_n1lil_dataout,
		oe => wire_vcc
	  );
	wire_n1lOO_w_lg_dataout251w(0) <= NOT wire_n1lOO_dataout;
	n1lOO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n1O1i_dataout,
		dataout => wire_n1lOO_dataout,
		oe => wire_vcc
	  );
	wire_n1O0i_w_lg_dataout249w(0) <= NOT wire_n1O0i_dataout;
	n1O0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n1O0l_dataout,
		dataout => wire_n1O0i_dataout,
		oe => wire_vcc
	  );
	wire_n1Oil_w_lg_dataout247w(0) <= NOT wire_n1Oil_dataout;
	n1Oil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n1OiO_dataout,
		dataout => wire_n1Oil_dataout,
		oe => wire_vcc
	  );
	wire_n1OlO_w_lg_dataout245w(0) <= NOT wire_n1OlO_dataout;
	n1OlO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_n1OOi_dataout,
		dataout => wire_n1OlO_dataout,
		oe => wire_vcc
	  );
	ni00lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni00Oi_dataout,
		dataout => wire_ni00lO_dataout,
		oe => wire_vcc
	  );
	wire_ni00Ol_w_lg_dataout1235w(0) <= NOT wire_ni00Ol_dataout;
	ni00Ol :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni00OO_dataout,
		dataout => wire_ni00Ol_dataout,
		oe => wire_vcc
	  );
	wire_ni01i_datain <= wire_n0l11l28_w_lg_w_lg_q110w111w(0);
	wire_n0l11l28_w_lg_w_lg_q110w111w(0) <= (n0l11l28 XOR n0l11l27) AND n1O0O;
	wire_ni01i_oe <= wire_nl1llO_w123w(0);
	wire_nl1llO_w123w(0) <= NOT (((NOT wire_nl1llO_dataout(0)) AND (NOT ((wire_w_lg_n0l11i113w(0) OR wire_w_lg_n0iOOO114w(0)) OR wire_w_lg_n0iOOl116w(0)))) AND (n0iOlO30 XOR n0iOlO29));
	ni01i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni01i_datain,
		dataout => wire_ni01i_dataout,
		oe => wire_ni01i_oe
	  );
	ni01il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni01iO_dataout,
		dataout => wire_ni01il_dataout,
		oe => wire_vcc
	  );
	wire_ni01li_w_lg_dataout1254w(0) <= NOT wire_ni01li_dataout;
	ni01li :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni01ll_dataout,
		dataout => wire_ni01li_dataout,
		oe => wire_vcc
	  );
	ni01lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni01lO_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_ni01Oi_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	wire_nl1lOi_w_lg_w_dataout_range33w252w(0) <= NOT wire_nl1lOi_dataout(0);
	ni01Oi :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni01Oi_dataout,
		oe => wire_ni01Oi_oe
	  );
	ni01Ol :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni01Ol_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_ni01OO_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	ni01OO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni01OO_dataout,
		oe => wire_ni01OO_oe
	  );
	wire_ni0i0i_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	ni0i0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni0i0i_dataout,
		oe => wire_ni0i0i_oe
	  );
	ni0i1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni0i1i_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_ni0i1l_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	ni0i1l :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni0i1l_dataout,
		oe => wire_ni0i1l_oe
	  );
	ni0i1O :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni0i1O_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_ni0l0l_oe <= wire_niOiil_w_lg_w_dataout_range1099w1100w(0);
	wire_niOiil_w_lg_w_dataout_range1099w1100w(0) <= NOT wire_niOiil_dataout(0);
	ni0l0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni0l0l_dataout,
		oe => wire_ni0l0l_oe
	  );
	ni0l0O :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni0l0O_dataout,
		oe => wire_niOiil_dataout(0)
	  );
	ni0l1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni0l1l_dataout,
		dataout => wire_ni0l1i_dataout,
		oe => wire_vcc
	  );
	wire_ni0l1O_w_lg_dataout1216w(0) <= NOT wire_ni0l1O_dataout;
	ni0l1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni0l0i_dataout,
		dataout => wire_ni0l1O_dataout,
		oe => wire_vcc
	  );
	wire_ni0lii_oe <= wire_niOiil_w_lg_w_dataout_range1099w1100w(0);
	ni0lii :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni0lii_dataout,
		oe => wire_ni0lii_oe
	  );
	ni0lil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni0lil_dataout,
		oe => wire_niOiil_dataout(0)
	  );
	ni0O0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni0O0O_dataout,
		dataout => wire_ni0O0l_dataout,
		oe => wire_vcc
	  );
	wire_ni0Oii_w_lg_dataout1197w(0) <= NOT wire_ni0Oii_dataout;
	ni0Oii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni0Oil_dataout,
		dataout => wire_ni0Oii_dataout,
		oe => wire_vcc
	  );
	wire_ni0OiO_oe <= wire_niOl0O_w_lg_w_dataout_range1097w1098w(0);
	wire_niOl0O_w_lg_w_dataout_range1097w1098w(0) <= NOT wire_niOl0O_dataout(0);
	ni0OiO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni0OiO_dataout,
		oe => wire_ni0OiO_oe
	  );
	ni0Oli :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni0Oli_dataout,
		oe => wire_niOl0O_dataout(0)
	  );
	wire_ni0Oll_oe <= wire_niOl0O_w_lg_w_dataout_range1097w1098w(0);
	ni0Oll :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni0Oll_dataout,
		oe => wire_ni0Oll_oe
	  );
	ni0OlO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni0OlO_dataout,
		oe => wire_niOl0O_dataout(0)
	  );
	wire_ni101l_w_lg_dataout1339w(0) <= NOT wire_ni101l_dataout;
	ni101l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni101O_dataout,
		dataout => wire_ni101l_dataout,
		oe => wire_vcc
	  );
	wire_ni10ii_w_lg_dataout1336w(0) <= NOT wire_ni10ii_dataout;
	ni10ii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni10il_dataout,
		dataout => wire_ni10ii_dataout,
		oe => wire_vcc
	  );
	wire_ni10lO_w_lg_dataout1333w(0) <= NOT wire_ni10lO_dataout;
	ni10lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni10Oi_dataout,
		dataout => wire_ni10lO_dataout,
		oe => wire_vcc
	  );
	wire_ni11lO_w_lg_dataout1342w(0) <= NOT wire_ni11lO_dataout;
	ni11lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni11Oi_dataout,
		dataout => wire_ni11lO_dataout,
		oe => wire_vcc
	  );
	wire_ni1ii_oe <= wire_nl1llO_w_lg_w_dataout_range35w130w(0);
	ni1ii :  io_buf_tri
	  PORT MAP ( 
		datain => n1Oli,
		dataout => wire_ni1ii_dataout,
		oe => wire_ni1ii_oe
	  );
	wire_ni1il_oe <= wire_nl1llO_w_lg_w_lg_w_dataout_range35w137w148w(0);
	wire_nl1llO_w_lg_w_lg_w_dataout_range35w137w148w(0) <= wire_nl1llO_w_lg_w_dataout_range35w137w(0) OR wire_w_lg_n0iO1O140w(0);
	ni1il :  io_buf_tri
	  PORT MAP ( 
		datain => n011O,
		dataout => wire_ni1il_dataout,
		oe => wire_ni1il_oe
	  );
	wire_ni1iO_oe <= wire_nl1llO_w_lg_w_lg_w_lg_w_dataout_range35w112w146w147w(0);
	wire_nl1llO_w_lg_w_lg_w_lg_w_dataout_range35w112w146w147w(0) <= NOT ((NOT wire_nl1llO_dataout(0)) AND (NOT wire_nl1llO_w_lg_w_dataout_range35w144w(0)));
	ni1iO :  io_buf_tri
	  PORT MAP ( 
		datain => n01il,
		dataout => wire_ni1iO_dataout,
		oe => wire_ni1iO_oe
	  );
	wire_ni1li_oe <= wire_w_lg_n0iOli126w(0);
	ni1li :  io_buf_tri
	  PORT MAP ( 
		datain => n0l1il,
		dataout => wire_ni1li_dataout,
		oe => wire_ni1li_oe
	  );
	wire_ni1ll_oe <= wire_n0iO1l40_w_lg_w_lg_q142w143w(0);
	wire_n0iO1l40_w_lg_w_lg_q142w143w(0) <= (n0iO1l40 XOR n0iO1l39) AND ((wire_w_lg_n0l11i113w(0) OR wire_w_lg_n0iO0i138w(0)) OR wire_w_lg_n0iO1O140w(0));
	ni1ll :  io_buf_tri
	  PORT MAP ( 
		datain => n1O0O,
		dataout => wire_ni1ll_dataout,
		oe => wire_ni1ll_oe
	  );
	wire_ni1lO_datain <= wire_n0iO0O38_w_lg_w_lg_q134w135w(0);
	wire_n0iO0O38_w_lg_w_lg_q134w135w(0) <= (n0iO0O38 XOR n0iO0O37) AND n1Oli;
	wire_ni1lO_oe <= wire_nl1llO_w_lg_w_dataout_range35w137w(0);
	ni1lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni1lO_datain,
		dataout => wire_ni1lO_dataout,
		oe => wire_ni1lO_oe
	  );
	ni1O0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni1O0l_dataout,
		dataout => wire_ni1O0i_dataout,
		oe => wire_vcc
	  );
	wire_ni1O0O_w_lg_dataout1273w(0) <= NOT wire_ni1O0O_dataout;
	ni1O0O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni1Oii_dataout,
		dataout => wire_ni1O0O_dataout,
		oe => wire_vcc
	  );
	wire_ni1Oi_oe <= wire_n0iOii36_w_lg_w_lg_q132w133w(0);
	wire_n0iOii36_w_lg_w_lg_q132w133w(0) <= (n0iOii36 XOR n0iOii35) AND (wire_nl1llO_w_lg_w_dataout_range35w130w(0) OR wire_w_lg_n0iOOl116w(0));
	ni1Oi :  io_buf_tri
	  PORT MAP ( 
		datain => n011O,
		dataout => wire_ni1Oi_dataout,
		oe => wire_ni1Oi_oe
	  );
	ni1Oil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni1Oil_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_ni1OiO_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	ni1OiO :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni1OiO_dataout,
		oe => wire_ni1OiO_oe
	  );
	wire_ni1Ol_oe <= wire_n0iOiO34_w_lg_w_lg_q127w128w(0);
	wire_n0iOiO34_w_lg_w_lg_q127w128w(0) <= (n0iOiO34 XOR n0iOiO33) AND wire_w_lg_n0iOOO114w(0);
	ni1Ol :  io_buf_tri
	  PORT MAP ( 
		datain => n01il,
		dataout => wire_ni1Ol_dataout,
		oe => wire_ni1Ol_oe
	  );
	ni1Oli :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_ni1Oli_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_ni1Oll_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	ni1Oll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_ni1Oll_dataout,
		oe => wire_ni1Oll_oe
	  );
	wire_ni1OO_datain <= wire_n0iOll32_w_lg_w_lg_q124w125w(0);
	wire_n0iOll32_w_lg_w_lg_q124w125w(0) <= (n0iOll32 XOR n0iOll31) AND n0l1il;
	wire_ni1OO_oe <= wire_w_lg_n0iOli126w(0);
	ni1OO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_ni1OO_datain,
		dataout => wire_ni1OO_dataout,
		oe => wire_ni1OO_oe
	  );
	nii01i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nii01i_dataout,
		oe => wire_niOO0i_dataout(0)
	  );
	nii0Oi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nii0Ol_dataout,
		dataout => wire_nii0Oi_dataout,
		oe => wire_vcc
	  );
	wire_nii0OO_w_lg_dataout1153w(0) <= NOT wire_nii0OO_dataout;
	nii0OO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niii1i_dataout,
		dataout => wire_nii0OO_dataout,
		oe => wire_vcc
	  );
	nii1iO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nii1li_dataout,
		dataout => wire_nii1iO_dataout,
		oe => wire_vcc
	  );
	wire_nii1ll_w_lg_dataout1175w(0) <= NOT wire_nii1ll_dataout;
	nii1ll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nii1lO_dataout,
		dataout => wire_nii1ll_dataout,
		oe => wire_vcc
	  );
	wire_nii1Oi_oe <= wire_niOO0i_w_lg_w_dataout_range1095w1096w(0);
	wire_niOO0i_w_lg_w_dataout_range1095w1096w(0) <= NOT wire_niOO0i_dataout(0);
	nii1Oi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nii1Oi_dataout,
		oe => wire_nii1Oi_oe
	  );
	nii1Ol :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nii1Ol_dataout,
		oe => wire_niOO0i_dataout(0)
	  );
	wire_nii1OO_oe <= wire_niOO0i_w_lg_w_dataout_range1095w1096w(0);
	nii1OO :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nii1OO_dataout,
		oe => wire_nii1OO_oe
	  );
	niii0i :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_niii0i_dataout,
		oe => wire_nl1llO_dataout(0)
	  );
	wire_niii0l_oe <= wire_nl1llO_w_lg_w_dataout_range35w112w(0);
	wire_nl1llO_w_lg_w_dataout_range35w112w(0) <= NOT wire_nl1llO_w_dataout_range35w(0);
	niii0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_niii0l_dataout,
		oe => wire_niii0l_oe
	  );
	niii1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_niii1l_dataout,
		oe => wire_nl1llO_dataout(0)
	  );
	wire_niii1O_oe <= wire_nl1llO_w_lg_w_dataout_range35w112w(0);
	niii1O :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_niii1O_dataout,
		oe => wire_niii1O_oe
	  );
	wire_niil0i_w_lg_dataout1134w(0) <= NOT wire_niil0i_dataout;
	niil0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niil0l_dataout,
		dataout => wire_niil0i_dataout,
		oe => wire_vcc
	  );
	niil0O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_niil0O_dataout,
		oe => wire_nl1llO_dataout(0)
	  );
	niil1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niil1O_dataout,
		dataout => wire_niil1l_dataout,
		oe => wire_vcc
	  );
	wire_niilii_oe <= wire_nl1llO_w_lg_w_dataout_range35w112w(0);
	niilii :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_niilii_dataout,
		oe => wire_niilii_oe
	  );
	niilil :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_niilil_dataout,
		oe => wire_nl1llO_dataout(0)
	  );
	wire_niiliO_oe <= wire_nl1llO_w_lg_w_dataout_range35w112w(0);
	niiliO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_niiliO_dataout,
		oe => wire_niiliO_oe
	  );
	niiO0O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niiOii_dataout,
		dataout => wire_niiO0O_dataout,
		oe => wire_vcc
	  );
	wire_niiOil_w_lg_dataout1115w(0) <= NOT wire_niiOil_dataout;
	niiOil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niiOiO_dataout,
		dataout => wire_niiOil_dataout,
		oe => wire_vcc
	  );
	niiOli :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_niiOli_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_niiOll_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	niiOll :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_niiOll_dataout,
		oe => wire_niiOll_oe
	  );
	niiOlO :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_niiOlO_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_niiOOi_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	niiOOi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_niiOOi_dataout,
		oe => wire_niiOOi_oe
	  );
	wire_nil01l_w_lg_dataout1075w(0) <= NOT wire_nil01l_dataout;
	nil01l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nil01O_dataout,
		dataout => wire_nil01l_dataout,
		oe => wire_vcc
	  );
	wire_nil10l_w_lg_dataout1083w(0) <= NOT wire_nil10l_dataout;
	nil10l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nil10O_dataout,
		dataout => wire_nil10l_dataout,
		oe => wire_vcc
	  );
	wire_nil1ii_w_lg_dataout1065w(0) <= NOT wire_nil1ii_dataout;
	nil1ii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nil1il_dataout,
		dataout => wire_nil1ii_dataout,
		oe => wire_vcc
	  );
	wire_nil1iO_w_lg_dataout1036w(0) <= NOT wire_nil1iO_dataout;
	nil1iO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nil1li_dataout,
		dataout => wire_nil1iO_dataout,
		oe => wire_vcc
	  );
	nil1ll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nil1lO_dataout,
		dataout => wire_nil1ll_dataout,
		oe => wire_vcc
	  );
	wire_nil1Oi_w_lg_dataout1046w(0) <= NOT wire_nil1Oi_dataout;
	nil1Oi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nil1Ol_dataout,
		dataout => wire_nil1Oi_dataout,
		oe => wire_vcc
	  );
	wire_nil1OO_w_lg_dataout1054w(0) <= NOT wire_nil1OO_dataout;
	nil1OO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nil01i_dataout,
		dataout => wire_nil1OO_dataout,
		oe => wire_vcc
	  );
	wire_niO0ll_datain <= wire_w_lg_w_eqa_set_range800w801w(0);
	wire_w_lg_w_eqa_set_range800w801w(0) <= NOT wire_w_eqa_set_range800w(0);
	wire_niO0ll_oe <= wire_w_lg_n0l0ll570w(0);
	niO0ll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niO0ll_datain,
		dataout => wire_niO0ll_dataout,
		oe => wire_niO0ll_oe
	  );
	wire_niO0lO_datain <= wire_w_lg_w_eqb_set_range756w757w(0);
	wire_w_lg_w_eqb_set_range756w757w(0) <= NOT wire_w_eqb_set_range756w(0);
	wire_niO0lO_oe <= wire_w_lg_n0l0li547w(0);
	niO0lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niO0lO_datain,
		dataout => wire_niO0lO_dataout,
		oe => wire_niO0lO_oe
	  );
	wire_niO0Oi_datain <= wire_w_lg_w_eqc_set_range702w703w(0);
	wire_w_lg_w_eqc_set_range702w703w(0) <= NOT wire_w_eqc_set_range702w(0);
	wire_niO0Oi_oe <= wire_w_lg_n0l0iO549w(0);
	niO0Oi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niO0Oi_datain,
		dataout => wire_niO0Oi_dataout,
		oe => wire_niO0Oi_oe
	  );
	wire_niO0Ol_datain <= wire_w_lg_w_eqd_set_range647w648w(0);
	wire_w_lg_w_eqd_set_range647w648w(0) <= NOT wire_w_eqd_set_range647w(0);
	wire_niO0Ol_oe <= wire_w_lg_n0l0il540w(0);
	niO0Ol :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niO0Ol_datain,
		dataout => wire_niO0Ol_dataout,
		oe => wire_niO0Ol_oe
	  );
	wire_niO0OO_datain <= wire_w_lg_w_eqa_set_range800w801w(0);
	wire_niO0OO_oe <= wire_w_lg_n00Oli909w(0);
	niO0OO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niO0OO_datain,
		dataout => wire_niO0OO_dataout,
		oe => wire_niO0OO_oe
	  );
	wire_niOi0i_oe <= wire_w_lg_n00OOl907w(0);
	niOi0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_niOi0i_dataout,
		oe => wire_niOi0i_oe
	  );
	wire_niOi0l_datain <= wire_w_lg_w_eqv_set_range596w601w(0);
	wire_w_lg_w_eqv_set_range596w601w(0) <= NOT wire_w_eqv_set_range596w(0);
	wire_niOi0l_oe <= wire_w_lg_n00OOO906w(0);
	niOi0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOi0l_datain,
		dataout => wire_niOi0l_dataout,
		oe => wire_niOi0l_oe
	  );
	wire_niOi0O_datain <= wire_w_lg_w_eqv_set_range596w601w(0);
	niOi0O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOi0O_datain,
		dataout => wire_niOi0O_dataout,
		oe => n0l0ii
	  );
	wire_niOi1i_datain <= wire_w_lg_w_eqb_set_range756w757w(0);
	wire_niOi1i_oe <= wire_w_lg_n00Oll908w(0);
	niOi1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOi1i_datain,
		dataout => wire_niOi1i_dataout,
		oe => wire_niOi1i_oe
	  );
	wire_niOi1l_datain <= wire_w_lg_w_eqc_set_range702w703w(0);
	niOi1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOi1l_datain,
		dataout => wire_niOi1l_dataout,
		oe => n00OlO
	  );
	wire_niOi1O_datain <= wire_w_lg_w_eqd_set_range647w648w(0);
	niOi1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOi1O_datain,
		dataout => wire_niOi1O_dataout,
		oe => n00OOi
	  );
	wire_niOiiO_datain <= wire_w_lg_w_eqa_set_range802w803w(0);
	wire_niOiiO_oe <= wire_w_lg_n0l0ll570w(0);
	niOiiO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOiiO_datain,
		dataout => wire_niOiiO_dataout,
		oe => wire_niOiiO_oe
	  );
	wire_niOili_datain <= wire_w_lg_w_eqb_set_range758w759w(0);
	wire_niOili_oe <= wire_w_lg_n0l0li547w(0);
	niOili :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOili_datain,
		dataout => wire_niOili_dataout,
		oe => wire_niOili_oe
	  );
	wire_niOill_datain <= wire_w_lg_w_eqc_set_range704w705w(0);
	wire_niOill_oe <= wire_w_lg_n0l0iO549w(0);
	niOill :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOill_datain,
		dataout => wire_niOill_dataout,
		oe => wire_niOill_oe
	  );
	wire_niOilO_datain <= wire_w_lg_w_eqd_set_range649w650w(0);
	wire_niOilO_oe <= wire_w_lg_n0l0il540w(0);
	niOilO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOilO_datain,
		dataout => wire_niOilO_dataout,
		oe => wire_niOilO_oe
	  );
	wire_niOiOi_datain <= wire_w_lg_w_eqa_set_range802w803w(0);
	wire_niOiOi_oe <= wire_w_lg_n00Oli909w(0);
	niOiOi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOiOi_datain,
		dataout => wire_niOiOi_dataout,
		oe => wire_niOiOi_oe
	  );
	wire_niOiOl_datain <= wire_w_lg_w_eqb_set_range758w759w(0);
	wire_niOiOl_oe <= wire_w_lg_n00Oll908w(0);
	niOiOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOiOl_datain,
		dataout => wire_niOiOl_dataout,
		oe => wire_niOiOl_oe
	  );
	wire_niOiOO_datain <= wire_w_lg_w_eqc_set_range704w705w(0);
	niOiOO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOiOO_datain,
		dataout => wire_niOiOO_dataout,
		oe => n00OlO
	  );
	wire_niOl0i_datain <= wire_w_lg_w_eqv_set_range597w604w(0);
	niOl0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOl0i_datain,
		dataout => wire_niOl0i_dataout,
		oe => n0l0ii
	  );
	wire_niOl1i_datain <= wire_w_lg_w_eqd_set_range649w650w(0);
	niOl1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOl1i_datain,
		dataout => wire_niOl1i_dataout,
		oe => n00OOi
	  );
	wire_niOl1l_oe <= wire_w_lg_n00OOl907w(0);
	niOl1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_niOl1l_dataout,
		oe => wire_niOl1l_oe
	  );
	wire_niOl1O_datain <= wire_w_lg_w_eqv_set_range597w604w(0);
	wire_niOl1O_oe <= wire_w_lg_n00OOO906w(0);
	niOl1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOl1O_datain,
		dataout => wire_niOl1O_dataout,
		oe => wire_niOl1O_oe
	  );
	wire_niOlii_datain <= wire_w_lg_w_eqa_set_range805w806w(0);
	wire_w_lg_w_eqa_set_range805w806w(0) <= NOT eqa_set(2);
	wire_niOlii_oe <= wire_w_lg_n0l0ll570w(0);
	niOlii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOlii_datain,
		dataout => wire_niOlii_dataout,
		oe => wire_niOlii_oe
	  );
	wire_niOlil_datain <= wire_w_lg_w_eqb_set_range761w762w(0);
	wire_w_lg_w_eqb_set_range761w762w(0) <= NOT eqb_set(2);
	wire_niOlil_oe <= wire_w_lg_n0l0li547w(0);
	niOlil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOlil_datain,
		dataout => wire_niOlil_dataout,
		oe => wire_niOlil_oe
	  );
	wire_niOliO_datain <= wire_w_lg_w_eqc_set_range707w708w(0);
	wire_w_lg_w_eqc_set_range707w708w(0) <= NOT eqc_set(2);
	wire_niOliO_oe <= wire_w_lg_n0l0iO549w(0);
	niOliO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOliO_datain,
		dataout => wire_niOliO_dataout,
		oe => wire_niOliO_oe
	  );
	wire_niOlli_datain <= wire_w_lg_w_eqd_set_range652w653w(0);
	wire_w_lg_w_eqd_set_range652w653w(0) <= NOT eqd_set(2);
	wire_niOlli_oe <= wire_w_lg_n0l0il540w(0);
	niOlli :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOlli_datain,
		dataout => wire_niOlli_dataout,
		oe => wire_niOlli_oe
	  );
	wire_niOlll_datain <= wire_w_lg_w_eqa_set_range805w806w(0);
	wire_niOlll_oe <= wire_w_lg_n00Oli909w(0);
	niOlll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOlll_datain,
		dataout => wire_niOlll_dataout,
		oe => wire_niOlll_oe
	  );
	wire_niOllO_datain <= wire_w_lg_w_eqb_set_range761w762w(0);
	wire_niOllO_oe <= wire_w_lg_n00Oll908w(0);
	niOllO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOllO_datain,
		dataout => wire_niOllO_dataout,
		oe => wire_niOllO_oe
	  );
	wire_niOlOi_datain <= wire_w_lg_w_eqc_set_range707w708w(0);
	niOlOi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOlOi_datain,
		dataout => wire_niOlOi_dataout,
		oe => n00OlO
	  );
	wire_niOlOl_datain <= wire_w_lg_w_eqd_set_range652w653w(0);
	niOlOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOlOl_datain,
		dataout => wire_niOlOl_dataout,
		oe => n00OOi
	  );
	wire_niOlOO_oe <= wire_w_lg_n00OOl907w(0);
	niOlOO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_niOlOO_dataout,
		oe => wire_niOlOO_oe
	  );
	niOO0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOO0O_dataout,
		dataout => wire_niOO0l_dataout,
		oe => wire_vcc
	  );
	wire_niOO1i_datain <= wire_w_lg_w_eqv_set_range599w609w(0);
	wire_w_lg_w_eqv_set_range599w609w(0) <= NOT eqv_set(2);
	wire_niOO1i_oe <= wire_w_lg_n00OOO906w(0);
	niOO1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOO1i_datain,
		dataout => wire_niOO1i_dataout,
		oe => wire_niOO1i_oe
	  );
	wire_niOO1l_datain <= wire_w_lg_w_eqv_set_range599w609w(0);
	niOO1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOO1l_datain,
		dataout => wire_niOO1l_dataout,
		oe => n0l0ii
	  );
	niOOlO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOOOi_dataout,
		dataout => wire_niOOlO_dataout,
		oe => wire_vcc
	  );
	wire_niOOOl_w_lg_dataout866w(0) <= NOT wire_niOOOl_dataout;
	niOOOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_niOOOO_dataout,
		dataout => wire_niOOOl_dataout,
		oe => wire_vcc
	  );
	wire_nl000i_oe <= wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w760w770w(0);
	wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w760w770w(0) <= ((NOT eqb_set(0)) AND wire_w_lg_w_eqb_set_range758w759w(0)) AND eqb_set(2);
	nl000i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl000i_dataout,
		oe => wire_nl000i_oe
	  );
	wire_nl000l_oe <= wire_w_lg_w_lg_w_eqb_set_range756w768w769w(0);
	wire_w_lg_w_lg_w_eqb_set_range756w768w769w(0) <= (eqb_set(0) AND eqb_set(1)) AND (NOT eqb_set(2));
	nl000l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl000l_dataout,
		oe => wire_nl000l_oe
	  );
	wire_nl000O_oe <= wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w766w767w(0);
	wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w766w767w(0) <= ((NOT eqb_set(0)) AND eqb_set(1)) AND (NOT eqb_set(2));
	nl000O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl000O_dataout,
		oe => wire_nl000O_oe
	  );
	wire_nl001i_oe <= wire_w_lg_w_lg_w_eqb_set_range756w768w773w(0);
	wire_w_lg_w_lg_w_eqb_set_range756w768w773w(0) <= (eqb_set(0) AND eqb_set(1)) AND eqb_set(2);
	nl001i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nl001i_dataout,
		oe => wire_nl001i_oe
	  );
	wire_nl001l_oe <= wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w766w772w(0);
	wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w766w772w(0) <= ((NOT eqb_set(0)) AND eqb_set(1)) AND eqb_set(2);
	nl001l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl001l_dataout,
		oe => wire_nl001l_oe
	  );
	wire_nl001O_oe <= wire_w_lg_w_lg_w_eqb_set_range756w764w771w(0);
	wire_w_lg_w_lg_w_eqb_set_range756w764w771w(0) <= wire_w_lg_w_eqb_set_range756w764w(0) AND eqb_set(2);
	nl001O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl001O_dataout,
		oe => wire_nl001O_oe
	  );
	wire_nl00ii_oe <= wire_w_lg_w_lg_w_eqb_set_range756w764w765w(0);
	wire_w_lg_w_lg_w_eqb_set_range756w764w765w(0) <= wire_w_lg_w_eqb_set_range756w764w(0) AND (NOT eqb_set(2));
	nl00ii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl00ii_dataout,
		oe => wire_nl00ii_oe
	  );
	wire_nl00il_oe <= wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w760w763w(0);
	wire_w_lg_w_lg_w_lg_w_eqb_set_range756w757w760w763w(0) <= ((NOT eqb_set(0)) AND wire_w_lg_w_eqb_set_range758w759w(0)) AND (NOT eqb_set(2));
	nl00il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nl00il_dataout,
		oe => wire_nl00il_oe
	  );
	wire_nl00li_oe <= wire_w_lg_radce_adapt746w(0);
	wire_w_lg_radce_adapt746w(0) <= radce_adapt AND wire_w_lg_n0l0li547w(0);
	nl00li :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl00li_dataout,
		oe => wire_nl00li_oe
	  );
	wire_nl00ll_oe <= wire_w_lg_w_lg_w_lg_radce_adapt537w538w745w(0);
	wire_w_lg_w_lg_w_lg_radce_adapt537w538w745w(0) <= (NOT (radce_adapt OR wire_w_lg_radce_pdb536w(0))) OR ((radce_adapt AND n0l0li) AND (NOT ((NOT ((wire_w_lg_n0l0il540w(0) OR wire_w_lg_n0l0iO549w(0)) AND wire_w_lg_n0i01l728w(0))) AND (NOT ((wire_w_lg_n0l0ii683w(0) OR wire_w_lg_n0l0iO549w(0)) AND n0i01l)))));
	nl00ll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl00iO_dataout(0),
		dataout => wire_nl00ll_dataout,
		oe => wire_nl00ll_oe
	  );
	wire_nl00lO_oe <= wire_w_lg_n0i01O735w(0);
	nl00lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nl00lO_dataout,
		oe => wire_nl00lO_oe
	  );
	wire_nl00Oi_oe <= wire_w_lg_n0i01O734w(0);
	wire_w_lg_n0i01O734w(0) <= n0i01O AND ((radce_adapt AND n0l0li) AND (NOT ((NOT (wire_w_lg_n0l0ll570w(0) AND n0i01l)) AND (NOT (wire_w_lg_n0i01l728w(0) AND wire_w_lg_w_lg_n0l0ll570w671w(0))))));
	nl00Oi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl00Ol_dataout,
		dataout => wire_nl00Oi_dataout,
		oe => wire_nl00Oi_oe
	  );
	nl00Ol :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl00OO_dataout,
		dataout => wire_nl00Ol_dataout,
		oe => wire_vcc
	  );
	wire_nl0lll_oe <= wire_w_lg_w_lg_w_eqc_set_range702w714w719w(0);
	wire_w_lg_w_lg_w_eqc_set_range702w714w719w(0) <= (eqc_set(0) AND eqc_set(1)) AND eqc_set(2);
	nl0lll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nl0lll_dataout,
		oe => wire_nl0lll_oe
	  );
	wire_nl0llO_oe <= wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w712w718w(0);
	wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w712w718w(0) <= ((NOT eqc_set(0)) AND eqc_set(1)) AND eqc_set(2);
	nl0llO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl0llO_dataout,
		oe => wire_nl0llO_oe
	  );
	wire_nl0lOi_oe <= wire_w_lg_w_lg_w_eqc_set_range702w710w717w(0);
	wire_w_lg_w_lg_w_eqc_set_range702w710w717w(0) <= wire_w_lg_w_eqc_set_range702w710w(0) AND eqc_set(2);
	nl0lOi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl0lOi_dataout,
		oe => wire_nl0lOi_oe
	  );
	wire_nl0lOl_oe <= wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w706w716w(0);
	wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w706w716w(0) <= ((NOT eqc_set(0)) AND wire_w_lg_w_eqc_set_range704w705w(0)) AND eqc_set(2);
	nl0lOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl0lOl_dataout,
		oe => wire_nl0lOl_oe
	  );
	wire_nl0lOO_oe <= wire_w_lg_w_lg_w_eqc_set_range702w714w715w(0);
	wire_w_lg_w_lg_w_eqc_set_range702w714w715w(0) <= (eqc_set(0) AND eqc_set(1)) AND (NOT eqc_set(2));
	nl0lOO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl0lOO_dataout,
		oe => wire_nl0lOO_oe
	  );
	wire_nl0O0l_oe <= wire_w_lg_radce_adapt692w(0);
	wire_w_lg_radce_adapt692w(0) <= radce_adapt AND wire_w_lg_n0l0iO549w(0);
	nl0O0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl0O0l_dataout,
		oe => wire_nl0O0l_oe
	  );
	wire_nl0O0O_oe <= wire_w_lg_w_lg_w_lg_radce_adapt537w538w691w(0);
	wire_w_lg_w_lg_w_lg_radce_adapt537w538w691w(0) <= (NOT (radce_adapt OR wire_w_lg_radce_pdb536w(0))) OR ((radce_adapt AND n0l0iO) AND (NOT ((NOT wire_w_lg_w_rseq_sel_range543w684w(0)) AND (NOT (wire_w_lg_w_rseq_sel_range543w555w(0) AND wire_w_lg_n0l0il540w(0))))));
	nl0O0O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl0O0i_dataout(0),
		dataout => wire_nl0O0O_dataout,
		oe => wire_nl0O0O_oe
	  );
	wire_nl0O1i_oe <= wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w712w713w(0);
	wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w712w713w(0) <= ((NOT eqc_set(0)) AND eqc_set(1)) AND (NOT eqc_set(2));
	nl0O1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl0O1i_dataout,
		oe => wire_nl0O1i_oe
	  );
	wire_nl0O1l_oe <= wire_w_lg_w_lg_w_eqc_set_range702w710w711w(0);
	wire_w_lg_w_lg_w_eqc_set_range702w710w711w(0) <= wire_w_lg_w_eqc_set_range702w710w(0) AND (NOT eqc_set(2));
	nl0O1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl0O1l_dataout,
		oe => wire_nl0O1l_oe
	  );
	wire_nl0O1O_oe <= wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w706w709w(0);
	wire_w_lg_w_lg_w_lg_w_eqc_set_range702w703w706w709w(0) <= ((NOT eqc_set(0)) AND wire_w_lg_w_eqc_set_range704w705w(0)) AND (NOT eqc_set(2));
	nl0O1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nl0O1O_dataout,
		oe => wire_nl0O1O_oe
	  );
	wire_nl0Oii_oe <= wire_w_lg_n0i00i681w(0);
	nl0Oii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nl0Oii_dataout,
		oe => wire_nl0Oii_oe
	  );
	wire_nl0Oil_oe <= wire_w_lg_n0i00i680w(0);
	wire_w_lg_n0i00i680w(0) <= n0i00i AND ((radce_adapt AND n0l0iO) AND (NOT ((NOT (wire_w_lg_w_rseq_sel_range543w555w(0) AND (wire_w_lg_w_lg_n0l0ll570w671w(0) OR wire_w_lg_n0l0li547w(0)))) AND (NOT wire_w_lg_w_rseq_sel_range543w675w(0)))));
	nl0Oil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl0OiO_dataout,
		dataout => wire_nl0Oil_dataout,
		oe => wire_nl0Oil_oe
	  );
	nl0OiO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl0Oli_dataout,
		dataout => wire_nl0OiO_dataout,
		oe => wire_vcc
	  );
	wire_nl110l_w_lg_dataout865w(0) <= NOT wire_nl110l_dataout;
	nl110l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl110O_dataout,
		dataout => wire_nl110l_dataout,
		oe => wire_vcc
	  );
	nl111O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl110i_dataout,
		dataout => wire_nl111O_dataout,
		oe => wire_vcc
	  );
	nl11iO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl11li_dataout,
		dataout => wire_nl11iO_dataout,
		oe => wire_vcc
	  );
	wire_nl11ll_w_lg_dataout857w(0) <= NOT wire_nl11ll_dataout;
	nl11ll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl11lO_dataout,
		dataout => wire_nl11ll_dataout,
		oe => wire_vcc
	  );
	nl1i0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1i0O_dataout,
		dataout => wire_nl1i0l_dataout,
		oe => wire_vcc
	  );
	nl1i1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1i0i_dataout,
		dataout => wire_nl1i1O_dataout,
		oe => wire_vcc
	  );
	wire_nl1l0i_oe <= wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w810w816w(0);
	wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w810w816w(0) <= ((NOT eqa_set(0)) AND eqa_set(1)) AND eqa_set(2);
	nl1l0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl1l0i_dataout,
		oe => wire_nl1l0i_oe
	  );
	wire_nl1l0l_oe <= wire_w_lg_w_lg_w_eqa_set_range800w808w815w(0);
	wire_w_lg_w_lg_w_eqa_set_range800w808w815w(0) <= wire_w_lg_w_eqa_set_range800w808w(0) AND eqa_set(2);
	nl1l0l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl1l0l_dataout,
		oe => wire_nl1l0l_oe
	  );
	wire_nl1l0O_oe <= wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w804w814w(0);
	wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w804w814w(0) <= ((NOT eqa_set(0)) AND wire_w_lg_w_eqa_set_range802w803w(0)) AND eqa_set(2);
	nl1l0O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl1l0O_dataout,
		oe => wire_nl1l0O_oe
	  );
	wire_nl1l1O_oe <= wire_w_lg_w_lg_w_eqa_set_range800w812w817w(0);
	wire_w_lg_w_lg_w_eqa_set_range800w812w817w(0) <= (eqa_set(0) AND eqa_set(1)) AND eqa_set(2);
	nl1l1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nl1l1O_dataout,
		oe => wire_nl1l1O_oe
	  );
	wire_nl1lii_oe <= wire_w_lg_w_lg_w_eqa_set_range800w812w813w(0);
	wire_w_lg_w_lg_w_eqa_set_range800w812w813w(0) <= (eqa_set(0) AND eqa_set(1)) AND (NOT eqa_set(2));
	nl1lii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl1lii_dataout,
		oe => wire_nl1lii_oe
	  );
	wire_nl1lil_oe <= wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w810w811w(0);
	wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w810w811w(0) <= ((NOT eqa_set(0)) AND eqa_set(1)) AND (NOT eqa_set(2));
	nl1lil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl1lil_dataout,
		oe => wire_nl1lil_oe
	  );
	wire_nl1liO_oe <= wire_w_lg_w_lg_w_eqa_set_range800w808w809w(0);
	wire_w_lg_w_lg_w_eqa_set_range800w808w809w(0) <= wire_w_lg_w_eqa_set_range800w808w(0) AND (NOT eqa_set(2));
	nl1liO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl1liO_dataout,
		oe => wire_nl1liO_oe
	  );
	wire_nl1lli_oe <= wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w804w807w(0);
	wire_w_lg_w_lg_w_lg_w_eqa_set_range800w801w804w807w(0) <= ((NOT eqa_set(0)) AND wire_w_lg_w_eqa_set_range802w803w(0)) AND (NOT eqa_set(2));
	nl1lli :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nl1lli_dataout,
		oe => wire_nl1lli_oe
	  );
	wire_nl1lOl_oe <= wire_w_lg_radce_adapt786w(0);
	wire_w_lg_radce_adapt786w(0) <= radce_adapt AND wire_w_lg_n0l0ll570w(0);
	nl1lOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nl1lOl_dataout,
		oe => wire_nl1lOl_oe
	  );
	wire_nl1lOO_oe <= wire_w_lg_w_lg_w_lg_radce_adapt537w538w785w(0);
	wire_w_lg_w_lg_w_lg_radce_adapt537w538w785w(0) <= (NOT (radce_adapt OR wire_w_lg_radce_pdb536w(0))) OR ((radce_adapt AND n0l0ll) AND wire_nl1lOi_dataout(0));
	nl1lOO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lll_dataout(0),
		dataout => wire_nl1lOO_dataout,
		oe => wire_nl1lOO_oe
	  );
	wire_nl1O1i_oe <= wire_w_lg_n0i01i782w(0);
	nl1O1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nl1O1i_dataout,
		oe => wire_nl1O1i_oe
	  );
	wire_nl1O1l_oe <= wire_w_lg_n0i01i781w(0);
	wire_w_lg_n0i01i781w(0) <= n0i01i AND ((radce_adapt AND n0l0ll) AND wire_nl1llO_dataout(0));
	nl1O1l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1O1O_dataout,
		dataout => wire_nl1O1l_dataout,
		oe => wire_nl1O1l_oe
	  );
	nl1O1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1O0i_dataout,
		dataout => wire_nl1O1O_dataout,
		oe => wire_vcc
	  );
	wire_nli00i_oe <= wire_w_lg_w_lg_w_eqd_set_range647w655w662w(0);
	wire_w_lg_w_lg_w_eqd_set_range647w655w662w(0) <= wire_w_lg_w_eqd_set_range647w655w(0) AND eqd_set(2);
	nli00i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nli00i_dataout,
		oe => wire_nli00i_oe
	  );
	wire_nli00l_oe <= wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w651w661w(0);
	wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w651w661w(0) <= ((NOT eqd_set(0)) AND wire_w_lg_w_eqd_set_range649w650w(0)) AND eqd_set(2);
	nli00l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nli00l_dataout,
		oe => wire_nli00l_oe
	  );
	wire_nli00O_oe <= wire_w_lg_w_lg_w_eqd_set_range647w659w660w(0);
	wire_w_lg_w_lg_w_eqd_set_range647w659w660w(0) <= (eqd_set(0) AND eqd_set(1)) AND (NOT eqd_set(2));
	nli00O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nli00O_dataout,
		oe => wire_nli00O_oe
	  );
	wire_nli01l_oe <= wire_w_lg_w_lg_w_eqd_set_range647w659w664w(0);
	wire_w_lg_w_lg_w_eqd_set_range647w659w664w(0) <= (eqd_set(0) AND eqd_set(1)) AND eqd_set(2);
	nli01l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nli01l_dataout,
		oe => wire_nli01l_oe
	  );
	wire_nli01O_oe <= wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w657w663w(0);
	wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w657w663w(0) <= ((NOT eqd_set(0)) AND eqd_set(1)) AND eqd_set(2);
	nli01O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nli01O_dataout,
		oe => wire_nli01O_oe
	  );
	wire_nli0ii_oe <= wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w657w658w(0);
	wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w657w658w(0) <= ((NOT eqd_set(0)) AND eqd_set(1)) AND (NOT eqd_set(2));
	nli0ii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nli0ii_dataout,
		oe => wire_nli0ii_oe
	  );
	wire_nli0il_oe <= wire_w_lg_w_lg_w_eqd_set_range647w655w656w(0);
	wire_w_lg_w_lg_w_eqd_set_range647w655w656w(0) <= wire_w_lg_w_eqd_set_range647w655w(0) AND (NOT eqd_set(2));
	nli0il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nli0il_dataout,
		oe => wire_nli0il_oe
	  );
	wire_nli0iO_oe <= wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w651w654w(0);
	wire_w_lg_w_lg_w_lg_w_eqd_set_range647w648w651w654w(0) <= ((NOT eqd_set(0)) AND wire_w_lg_w_eqd_set_range649w650w(0)) AND (NOT eqd_set(2));
	nli0iO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nli0iO_dataout,
		oe => wire_nli0iO_oe
	  );
	wire_nli0ll_oe <= wire_w_lg_radce_adapt637w(0);
	wire_w_lg_radce_adapt637w(0) <= radce_adapt AND wire_w_lg_n0l0il540w(0);
	nli0ll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nli0ll_dataout,
		oe => wire_nli0ll_oe
	  );
	wire_nli0lO_oe <= wire_w_lg_w_lg_w_lg_radce_adapt537w538w636w(0);
	wire_w_lg_w_lg_w_lg_radce_adapt537w538w636w(0) <= (NOT (radce_adapt OR wire_w_lg_radce_pdb536w(0))) OR ((radce_adapt AND n0l0il) AND (n0l0ii AND n0i00l));
	nli0lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nli0li_dataout(0),
		dataout => wire_nli0lO_dataout,
		oe => wire_nli0lO_oe
	  );
	wire_nli0Oi_oe <= wire_w_lg_n0i00O632w(0);
	nli0Oi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nli0Oi_dataout,
		oe => wire_nli0Oi_oe
	  );
	wire_nli0Ol_oe <= wire_w_lg_n0i00O631w(0);
	wire_w_lg_n0i00O631w(0) <= n0i00O AND ((radce_adapt AND n0l0il) AND (NOT ((NOT (wire_w_lg_n0l0ll570w(0) OR wire_w_lg_n0i00l623w(0))) AND (NOT (wire_w_lg_n0l0li547w(0) OR wire_w_lg_n0l0iO549w(0))))));
	nli0Ol :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nli0OO_dataout,
		dataout => wire_nli0Ol_dataout,
		oe => wire_nli0Ol_oe
	  );
	nli0OO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlii1i_dataout,
		dataout => wire_nli0OO_dataout,
		oe => wire_vcc
	  );
	wire_nliOil_oe <= wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w607w613w(0);
	wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w607w613w(0) <= ((NOT eqv_set(0)) AND wire_w_lg_w_eqv_set_range597w604w(0)) AND (NOT eqv_set(2));
	nliOil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nliOil_dataout,
		oe => wire_nliOil_oe
	  );
	wire_nliOiO_oe <= wire_w_lg_w_lg_w_eqv_set_range596w605w612w(0);
	wire_w_lg_w_lg_w_eqv_set_range596w605w612w(0) <= wire_w_lg_w_eqv_set_range596w605w(0) AND (NOT eqv_set(2));
	nliOiO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nliOiO_dataout,
		oe => wire_nliOiO_oe
	  );
	wire_nliOli_oe <= wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w602w611w(0);
	wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w602w611w(0) <= ((NOT eqv_set(0)) AND eqv_set(1)) AND (NOT eqv_set(2));
	nliOli :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nliOli_dataout,
		oe => wire_nliOli_oe
	  );
	wire_nliOll_oe <= wire_w_lg_w_lg_w_eqv_set_range596w598w610w(0);
	wire_w_lg_w_lg_w_eqv_set_range596w598w610w(0) <= (eqv_set(0) AND eqv_set(1)) AND (NOT eqv_set(2));
	nliOll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nliOll_dataout,
		oe => wire_nliOll_oe
	  );
	wire_nliOlO_oe <= wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w607w608w(0);
	wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w607w608w(0) <= ((NOT eqv_set(0)) AND wire_w_lg_w_eqv_set_range597w604w(0)) AND eqv_set(2);
	nliOlO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nliOlO_dataout,
		oe => wire_nliOlO_oe
	  );
	wire_nliOOi_oe <= wire_w_lg_w_lg_w_eqv_set_range596w605w606w(0);
	wire_w_lg_w_lg_w_eqv_set_range596w605w606w(0) <= wire_w_lg_w_eqv_set_range596w605w(0) AND eqv_set(2);
	nliOOi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nliOOi_dataout,
		oe => wire_nliOOi_oe
	  );
	wire_nliOOl_oe <= wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w602w603w(0);
	wire_w_lg_w_lg_w_lg_w_eqv_set_range596w601w602w603w(0) <= ((NOT eqv_set(0)) AND eqv_set(1)) AND eqv_set(2);
	nliOOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nliOOl_dataout,
		oe => wire_nliOOl_oe
	  );
	wire_nliOOO_oe <= wire_w_lg_w_lg_w_eqv_set_range596w598w600w(0);
	wire_w_lg_w_lg_w_eqv_set_range596w598w600w(0) <= (eqv_set(0) AND eqv_set(1)) AND eqv_set(2);
	nliOOO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1llO_dataout(0),
		dataout => wire_nliOOO_dataout,
		oe => wire_nliOOO_oe
	  );
	nll00i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nll00l_dataout,
		dataout => wire_nll00i_dataout,
		oe => wire_vcc
	  );
	wire_nll00O_w_lg_dataout503w(0) <= NOT wire_nll00O_dataout;
	nll00O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nll0ii_dataout,
		dataout => wire_nll00O_dataout,
		oe => wire_vcc
	  );
	nll0il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nll0il_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_nll0iO_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	nll0iO :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nll0iO_dataout,
		oe => wire_nll0iO_oe
	  );
	nll0li :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nll0li_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_nll0ll_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	nll0ll :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nll0ll_dataout,
		oe => wire_nll0ll_oe
	  );
	wire_nll10i_oe <= wire_w_lg_w_lg_w_lg_radce_adapt537w538w564w(0);
	wire_w_lg_w_lg_w_lg_radce_adapt537w538w564w(0) <= (NOT (radce_adapt OR wire_w_lg_radce_pdb536w(0))) OR (wire_w_lg_radce_adapt539w(0) AND (NOT (((NOT (wire_w_lg_n0l0il540w(0) AND ((NOT rseq_sel(0)) AND rseq_sel(1)))) AND (NOT (((wire_w_lg_n0l0li547w(0) OR wire_w_lg_n0l0il540w(0)) OR wire_w_lg_n0l0iO549w(0)) AND wire_w_lg_n0i0ii551w(0)))) AND ((NOT wire_w_lg_w_rseq_sel_range541w556w(0)) OR (NOT (wire_w_lg_n0l0il540w(0) OR wire_w_lg_n0l0iO549w(0)))))));
	nll10i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nll11i_dataout(0),
		dataout => wire_nll10i_dataout,
		oe => wire_nll10i_oe
	  );
	wire_nll11l_oe <= wire_w_lg_radce_adapt586w(0);
	wire_w_lg_radce_adapt586w(0) <= radce_adapt AND n0l0ii;
	nll11l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_gnd,
		dataout => wire_nll11l_dataout,
		oe => wire_nll11l_oe
	  );
	wire_nll11O_oe <= wire_w_lg_w_lg_w_lg_radce_adapt565w566w585w(0);
	wire_w_lg_w_lg_w_lg_radce_adapt565w566w585w(0) <= (NOT (radce_adapt OR radce_pdb)) OR (wire_w_lg_radce_adapt539w(0) AND ((NOT ((NOT (rseq_sel(0) AND rseq_sel(1))) AND ((NOT ((NOT rseq_sel(0)) AND rseq_sel(1))) OR (NOT (wire_w_lg_w_lg_n0l0ll570w571w(0) OR wire_w_lg_n0l0iO549w(0)))))) OR (NOT (((NOT wire_w_lg_w_rseq_sel_range541w556w(0)) OR (NOT wire_w_lg_w_lg_n0l0ll570w571w(0))) AND (NOT (wire_w_lg_n0l0ll570w(0) AND wire_w_lg_n0i0ii551w(0)))))));
	nll11O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nll11O_dataout,
		oe => wire_nll11O_oe
	  );
	nlliil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlliiO_dataout,
		dataout => wire_nlliil_dataout,
		oe => wire_vcc
	  );
	wire_nllili_w_lg_dataout480w(0) <= NOT wire_nllili_dataout;
	nllili :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nllill_dataout,
		dataout => wire_nllili_dataout,
		oe => wire_vcc
	  );
	nllilO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nllilO_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_nlliOi_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	nlliOi :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlliOi_dataout,
		oe => wire_nlliOi_oe
	  );
	nlliOl :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlliOl_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_nlliOO_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	nlliOO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nlliOO_dataout,
		oe => wire_nlliOO_oe
	  );
	nllllO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlllOi_dataout,
		dataout => wire_nllllO_dataout,
		oe => wire_vcc
	  );
	wire_nlllOl_w_lg_dataout459w(0) <= NOT wire_nlllOl_dataout;
	nlllOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlllOO_dataout,
		dataout => wire_nlllOl_dataout,
		oe => wire_vcc
	  );
	wire_nllO0i_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	nllO0i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nllO0i_dataout,
		oe => wire_nllO0i_oe
	  );
	nllO1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nllO1i_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	wire_nllO1l_oe <= wire_nl1lOi_w_lg_w_dataout_range33w252w(0);
	nllO1l :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nllO1l_dataout,
		oe => wire_nllO1l_oe
	  );
	nllO1O :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nllO1O_dataout,
		oe => wire_nl1lOi_dataout(0)
	  );
	nlO00l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlO00O_dataout,
		dataout => wire_nlO00l_dataout,
		oe => wire_vcc
	  );
	wire_nlO0ii_w_lg_dataout415w(0) <= NOT wire_nlO0ii_dataout;
	nlO0ii :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlO0il_dataout,
		dataout => wire_nlO0ii_dataout,
		oe => wire_vcc
	  );
	nlO0iO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nlO0iO_dataout,
		oe => radce_vod_int(1)
	  );
	wire_nlO0li_oe <= wire_w_lg_w_radce_vod_int_range408w409w(0);
	wire_w_lg_w_radce_vod_int_range408w409w(0) <= NOT radce_vod_int(1);
	nlO0li :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlO0li_dataout,
		oe => wire_nlO0li_oe
	  );
	nlO0ll :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlO0ll_dataout,
		oe => radce_vod_int(1)
	  );
	wire_nlO0lO_oe <= wire_w_lg_w_radce_vod_int_range408w409w(0);
	nlO0lO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nlO0lO_dataout,
		oe => wire_nlO0lO_oe
	  );
	nlO10l :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nlO10l_dataout,
		oe => radce_vod_int(0)
	  );
	wire_nlO10O_oe <= wire_w_lg_w_radce_vod_int_range431w432w(0);
	wire_w_lg_w_radce_vod_int_range431w432w(0) <= NOT radce_vod_int(0);
	nlO10O :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlO10O_dataout,
		oe => wire_nlO10O_oe
	  );
	nlO11i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlO11l_dataout,
		dataout => wire_nlO11i_dataout,
		oe => wire_vcc
	  );
	wire_nlO11O_w_lg_dataout438w(0) <= NOT wire_nlO11O_dataout;
	nlO11O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlO10i_dataout,
		dataout => wire_nlO11O_dataout,
		oe => wire_vcc
	  );
	nlO1ii :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlO1ii_dataout,
		oe => radce_vod_int(0)
	  );
	wire_nlO1il_oe <= wire_w_lg_w_radce_vod_int_range431w432w(0);
	nlO1il :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nlO1il_dataout,
		oe => wire_nlO1il_oe
	  );
	nlOiiO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOili_dataout,
		dataout => wire_nlOiiO_dataout,
		oe => wire_vcc
	  );
	wire_nlOill_w_lg_dataout392w(0) <= NOT wire_nlOill_dataout;
	nlOill :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOilO_dataout,
		dataout => wire_nlOill_dataout,
		oe => wire_vcc
	  );
	nlOiOi :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nlOiOi_dataout,
		oe => radce_vod_int(2)
	  );
	wire_nlOiOl_oe <= wire_w_lg_w_radce_vod_int_range382w383w(0);
	wire_w_lg_w_radce_vod_int_range382w383w(0) <= NOT radce_vod_int(2);
	nlOiOl :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlOiOl_dataout,
		oe => wire_nlOiOl_oe
	  );
	nlOiOO :  io_buf_tri
	  PORT MAP ( 
		datain => radce_rstb,
		dataout => wire_nlOiOO_dataout,
		oe => radce_vod_int(2)
	  );
	wire_nlOl1i_oe <= wire_w_lg_w_radce_vod_int_range382w383w(0);
	nlOl1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nl1lOi_dataout(0),
		dataout => wire_nlOl1i_dataout,
		oe => wire_nlOl1i_oe
	  );
	wire_nlOlil_w_lg_dataout358w(0) <= NOT wire_nlOlil_dataout;
	nlOlil :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOliO_dataout,
		dataout => wire_nlOlil_dataout,
		oe => wire_vcc
	  );
	wire_nlOlli_w_lg_dataout340w(0) <= NOT wire_nlOlli_dataout;
	nlOlli :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOlll_dataout,
		dataout => wire_nlOlli_dataout,
		oe => wire_vcc
	  );
	wire_nlOllO_w_lg_dataout311w(0) <= NOT wire_nlOllO_dataout;
	nlOllO :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOlOi_dataout,
		dataout => wire_nlOllO_dataout,
		oe => wire_vcc
	  );
	wire_nlOlOl_w_lg_dataout321w(0) <= NOT wire_nlOlOl_dataout;
	nlOlOl :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOlOO_dataout,
		dataout => wire_nlOlOl_dataout,
		oe => wire_vcc
	  );
	wire_nlOO1i_w_lg_dataout329w(0) <= NOT wire_nlOO1i_dataout;
	nlOO1i :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOO1l_dataout,
		dataout => wire_nlOO1i_dataout,
		oe => wire_vcc
	  );
	wire_nlOO1O_w_lg_dataout350w(0) <= NOT wire_nlOO1O_dataout;
	nlOO1O :  io_buf_tri
	  PORT MAP ( 
		datain => wire_nlOO0i_dataout,
		dataout => wire_nlOO1O_dataout,
		oe => wire_vcc
	  );
	wire_n010O_dataout <= n01il WHEN (NOT (n0ilOO AND n011O)) = '1'  ELSE n01li;
	wire_n011l_dataout <= n011O WHEN wire_w_lg_n0ilOO244w(0) = '1'  ELSE n010i;
	wire_n0liiO_dataout <= n0lili WHEN (NOT wire_nl1lOi_dataout(0)) = '1'  ELSE n0lill;
	wire_n0liOl_dataout <= n0liOO WHEN wire_w_lg_n000il1522w(0) = '1'  ELSE n0ll1i;
	wire_n0ll0i_dataout <= n0ll0l WHEN wire_w_lg_n000iO1519w(0) = '1'  ELSE n0ll0O;
	wire_n0lliO_dataout <= n0llll WHEN (NOT (n000iO AND n0ll0l)) = '1'  ELSE n0llOi;
	wire_n0O00i_dataout <= n0O00O WHEN (NOT (n000lO AND n0O1OO)) = '1'  ELSE n0O0il;
	wire_n0O10i_dataout <= n0O10l WHEN (NOT wire_nl1lOi_dataout(0)) = '1'  ELSE n0O10O;
	wire_n0O1iO_dataout <= n0O1li WHEN wire_w_lg_n000ll1461w(0) = '1'  ELSE n0O1ll;
	wire_n0O1Ol_dataout <= n0O1OO WHEN wire_w_lg_n000lO1458w(0) = '1'  ELSE n0O01i;
	wire_n0Ol1O_dataout <= n0Ol0i WHEN (NOT wire_nl1lOi_dataout(0)) = '1'  ELSE n0Ol0l;
	wire_n0Olil_dataout <= n0OliO WHEN wire_w_lg_n00i1i1401w(0) = '1'  ELSE n0Olli;
	wire_n0OlOi_dataout <= n0OlOl WHEN wire_w_lg_n00i1l1398w(0) = '1'  ELSE n0OlOO;
	wire_n0OO1O_dataout <= n0OO0l WHEN (NOT (n00i1l AND n0OlOl)) = '1'  ELSE n0OOii;
	wire_n101i_dataout <= n100i WHEN (NOT wire_nl1lOi_dataout(0)) = '1'  ELSE n100l;
	wire_n101O_dataout <= wire_nl1llO_dataout(0) WHEN wire_w_lg_n0il0O306w(0) = '1'  ELSE wire_n11OO_dataout;
	wire_n10ii_dataout <= n10li WHEN wire_n1i1i_w_lg_n100i276w(0) = '1'  ELSE n10ll;
	wire_n10iO_dataout <= wire_nl1llO_dataout(0) WHEN wire_w_lg_n0il0O306w(0) = '1'  ELSE wire_n100O_dataout;
	wire_n10Oi_dataout <= n1i1l WHEN (NOT (n100i AND n10li)) = '1'  ELSE n1i0i;
	wire_n10OO_dataout <= wire_nl1llO_dataout(0) WHEN wire_w_lg_n0il0O306w(0) = '1'  ELSE wire_n10lO_dataout;
	wire_n1lii_dataout <= wire_w_lg_n0l0lO264w(0) WHEN wire_w_lg_n0ilii262w(0) = '1'  ELSE wire_n1l0i_w_lg_n1l0l263w(0);
	wire_n1liO_dataout <= n0l0lO WHEN wire_w_lg_n0ilii262w(0) = '1'  ELSE n1l0l;
	wire_n1O0l_dataout <= n1O0O WHEN wire_n01ii_w_lg_n1O1l250w(0) = '1'  ELSE n1Oii;
	wire_n1O1i_dataout <= n1O1l WHEN (NOT wire_nl1lOi_dataout(0)) = '1'  ELSE n1O1O;
	wire_n1OiO_dataout <= n1Oli WHEN wire_w_lg_n0ilOl248w(0) = '1'  ELSE n1Oll;
	wire_n1OOi_dataout <= n1OOl WHEN wire_w_lg_n0iO1i246w(0) = '1'  ELSE n1OOO;
	wire_ni00Oi_dataout <= ni00ll WHEN ((NOT (wire_w_lg_n00l1O1230w(0) AND wire_w_lg_n00l1l1231w(0))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE ni00iO;
	wire_ni00OO_dataout <= wire_nil01l_w_lg_dataout1075w(0) WHEN n00O1O = '1'  ELSE wire_ni00lO_dataout;
	wire_ni01iO_dataout <= ni01ii WHEN ((NOT (wire_w_lg_n00iOO1249w(0) AND wire_w_lg_n00iOl1250w(0))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE ni010l;
	wire_ni01ll_dataout <= wire_nil01l_w_lg_dataout1075w(0) WHEN n00O1O = '1'  ELSE wire_ni01il_dataout;
	wire_ni0l0i_dataout <= wire_niOO0l_dataout WHEN n00O1O = '1'  ELSE wire_ni0l1i_dataout;
	wire_ni0l1l_dataout <= ni0iOO WHEN ((NOT (wire_w_lg_n00l0O1211w(0) AND wire_w_lg_n00l0l1212w(0))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE ni0iOi;
	wire_ni0O0O_dataout <= ni0O0i WHEN ((NOT (wire_w_lg_n00liO1192w(0) AND wire_w_lg_n00lil1193w(0))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE ni0O1l;
	wire_ni0Oil_dataout <= (wire_w_lg_n0i10l868w(0) AND (NOT wire_niOl0l_dataout(0))) WHEN n00O1O = '1'  ELSE wire_ni0O0l_dataout;
	wire_ni101O_dataout <= ni100i WHEN wire_w_lg_n00i0i1340w(0) = '1'  ELSE ni100l;
	wire_ni10il_dataout <= ni10iO WHEN wire_w_lg_n00i0l1337w(0) = '1'  ELSE ni10li;
	wire_ni10Oi_dataout <= ni10OO WHEN (NOT (n00i0l AND ni10iO)) = '1'  ELSE ni1i1l;
	wire_ni11Oi_dataout <= ni11Ol WHEN (NOT wire_nl1lOi_dataout(0)) = '1'  ELSE ni11OO;
	wire_ni1O0l_dataout <= ni1O1O WHEN ((NOT (wire_w_lg_n00ilO1268w(0) AND wire_w_lg_n00ill1269w(0))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE ni1O1i;
	wire_ni1Oii_dataout <= wire_nil01l_w_lg_dataout1075w(0) WHEN n00O1O = '1'  ELSE wire_ni1O0i_dataout;
	wire_nii0Ol_dataout <= nii0lO WHEN ((NOT (wire_w_lg_n00lOi1148w(0) AND wire_w_lg_n00llO1149w(0))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE nii0li;
	wire_nii1li_dataout <= nii1il WHEN ((NOT ((NOT (n00liO AND ni0O0i)) AND (NOT (n00lil AND ni0O1l)))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE nii10O;
	wire_nii1lO_dataout <= (wire_w_lg_n0i10l868w(0) AND (NOT wire_niOO1O_dataout(0))) WHEN n00O1O = '1'  ELSE wire_nii1iO_dataout;
	wire_niii1i_dataout <= wire_nii0Oi_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_niil0l_dataout <= wire_niil1l_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_niil1O_dataout <= niil1i WHEN ((NOT (wire_w_lg_n00O1i1129w(0) AND wire_w_lg_n00lOO1130w(0))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE niiiOl;
	wire_niiOii_dataout <= niiO0l WHEN ((NOT ((NOT (n00O1i AND niil1i)) AND (NOT (n00lOO AND niiiOl)))) AND wire_w_lg_n00O1l1113w(0)) = '1'  ELSE niiO1O;
	wire_niiOiO_dataout <= wire_niiO0O_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_nil01i_dataout <= wire_nl1llO_dataout(0) WHEN wire_nl10Ol_w_lg_nl10OO889w(0) = '1'  ELSE (NOT wire_niOO0i_dataout(0));
	wire_nil01O_dataout <= wire_nl1llO_dataout(0) WHEN wire_nl10Ol_w_lg_nl10OO889w(0) = '1'  ELSE wire_nl1lOi_dataout(0);
	wire_nil10O_dataout <= wire_nl1llO_dataout(0) WHEN wire_nl10Ol_w_lg_nl10OO889w(0) = '1'  ELSE wire_nl1lOi_dataout(0);
	wire_nil1il_dataout <= wire_nl1llO_dataout(0) WHEN wire_nl10Ol_w_lg_nl10OO889w(0) = '1'  ELSE wire_nl1lOi_dataout(0);
	wire_nil1li_dataout <= wire_nil1ll_dataout WHEN wire_nl10Ol_w_lg_nl10OO889w(0) = '1'  ELSE (NOT wire_niOiil_dataout(0));
	wire_nil1lO_dataout <= wire_nl1llO_dataout(0) WHEN n0l0ii = '1'  ELSE radce_digital(7);
	wire_nil1Ol_dataout <= wire_nl1llO_dataout(0) WHEN wire_nl10Ol_w_lg_nl10OO889w(0) = '1'  ELSE (NOT wire_niOl0O_dataout(0));
	wire_niOO0O_dataout <= (wire_w_lg_n0i10l868w(0) AND (NOT wire_niOiii_dataout(0))) WHEN (wire_w_lg_n0i10l868w(0) OR (NOT ((NOT ((NOT ((NOT (wire_w_lg_n0l0ll570w(0) AND wire_w_lg_n0i10i872w(0))) AND (NOT (wire_w_lg_n0i11O875w(0) AND wire_w_lg_n0l0li547w(0))))) OR (NOT ((NOT (wire_w_lg_n0i11l880w(0) AND wire_w_lg_n0l0iO549w(0))) AND (NOT (wire_w_lg_n0l0il540w(0) AND n0i11i)))))) OR wire_nl10Ol_w_lg_nl10OO889w(0)))) = '1'  ELSE radce_digital(7);
	wire_niOOOi_dataout <= nl111i WHEN (NOT wire_nl1lOi_dataout(0)) = '1'  ELSE nl111l;
	wire_niOOOO_dataout <= wire_nl1llO_dataout(0) WHEN wire_w_lg_n0i1ll862w(0) = '1'  ELSE wire_niOOlO_dataout;
	wire_nl00OO_dataout <= wire_nl1llO_dataout(0) AND (NOT radce_digital(7));
	wire_nl0Oli_dataout <= wire_nl1llO_dataout(0) AND (NOT radce_digital(7));
	wire_nl110i_dataout <= nl11ii WHEN wire_nl11Oi_w_lg_nl111i830w(0) = '1'  ELSE nl11il;
	wire_nl110O_dataout <= wire_nl1llO_dataout(0) WHEN wire_w_lg_n0i1ll862w(0) = '1'  ELSE wire_nl111O_dataout;
	wire_nl11li_dataout <= nl11Ol WHEN (NOT (nl111i AND nl11ii)) = '1'  ELSE nl101i;
	wire_nl11lO_dataout <= wire_nl1llO_dataout(0) WHEN wire_w_lg_n0i1ll862w(0) = '1'  ELSE wire_nl11iO_dataout;
	wire_nl1i0i_dataout <= wire_w_lg_n0li0i821w(0) WHEN wire_w_lg_n0i1lO819w(0) = '1'  ELSE wire_nl1i1i_w_lg_nl1i1l820w(0);
	wire_nl1i0O_dataout <= n0li0i WHEN wire_w_lg_n0i1lO819w(0) = '1'  ELSE nl1i1l;
	wire_nl1O0i_dataout <= wire_nl1llO_dataout(0) AND (NOT radce_digital(7));
	wire_nlii1i_dataout <= wire_nl1llO_dataout(0) AND (NOT radce_digital(7));
	wire_nll00l_dataout <= nll01O WHEN ((NOT (wire_w_lg_n0i0OO498w(0) AND wire_w_lg_n0i0Ol499w(0))) AND wire_w_lg_n0il1l390w(0)) = '1'  ELSE nll01i;
	wire_nll0ii_dataout <= wire_nll00i_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_nlliiO_dataout <= nlliii WHEN ((NOT (wire_w_lg_n0ii0i475w(0) AND wire_w_lg_n0ii1O476w(0))) AND wire_w_lg_n0il1l390w(0)) = '1'  ELSE nlli0l;
	wire_nllill_dataout <= wire_nlliil_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_nlllOi_dataout <= nlllll WHEN ((NOT (wire_w_lg_n0iiil454w(0) AND wire_w_lg_n0iiii455w(0))) AND wire_w_lg_n0il1l390w(0)) = '1'  ELSE nllliO;
	wire_nlllOO_dataout <= wire_nllllO_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_nlO00O_dataout <= nlO00i WHEN ((NOT (wire_w_lg_n0il1i410w(0) AND wire_w_lg_n0iiOO411w(0))) AND wire_w_lg_n0il1l390w(0)) = '1'  ELSE nlO01l;
	wire_nlO0il_dataout <= wire_nlO00l_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_nlO10i_dataout <= wire_nlO11i_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_nlO11l_dataout <= nllOOO WHEN ((NOT (wire_w_lg_n0iilO433w(0) AND wire_w_lg_n0iill434w(0))) AND wire_w_lg_n0il1l390w(0)) = '1'  ELSE nllOOi;
	wire_nlOili_dataout <= nlOiil WHEN ((NOT ((NOT (n0il1i AND nlO00i)) AND (NOT (n0iiOO AND nlO01l)))) AND wire_w_lg_n0il1l390w(0)) = '1'  ELSE nlOi0O;
	wire_nlOilO_dataout <= wire_nlOiiO_dataout AND NOT((NOT wire_nl1lOi_dataout(0)));
	wire_nlOliO_dataout <= wire_nl1llO_dataout(0) WHEN wire_n1l1l_w_lg_n1l1O370w(0) = '1'  ELSE wire_nl1lOi_dataout(0);
	wire_nlOlll_dataout <= wire_nl1llO_dataout(0) WHEN wire_n1l1l_w_lg_n1l1O370w(0) = '1'  ELSE wire_nl1lOi_dataout(0);
	wire_nlOlOi_dataout <= radce_vod_lsb WHEN wire_n1l1l_w_lg_n1l1O370w(0) = '1'  ELSE rrgen_set(0);
	wire_nlOlOO_dataout <= radce_digital(8) WHEN wire_n1l1l_w_lg_n1l1O370w(0) = '1'  ELSE rrgen_set(1);
	wire_nlOO0i_dataout <= wire_nl1llO_dataout(0) WHEN wire_n1l1l_w_lg_n1l1O370w(0) = '1'  ELSE wire_nl1lOi_dataout(0);
	wire_nlOO1l_dataout <= radce_digital(9) WHEN wire_n1l1l_w_lg_n1l1O370w(0) = '1'  ELSE rrgen_set(2);
	wire_n0i1i_datain <= ( wire_n00OO_dataout & wire_n00Ol_dataout & wire_n00Oi_dataout & wire_n00lO_dataout & wire_n00ll_dataout & wire_n00li_dataout & wire_n00iO_dataout & wire_n00il_dataout);
	n0i1i :  tri_bus
	  GENERIC MAP (
		width_datain => 8,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_n0i1i_datain,
		dataout => wire_n0i1i_dataout
	  );
	wire_n0l1O_datain <= ( wire_n0l1l_dataout & wire_n0l1i_dataout & wire_n0iOO_dataout & wire_n0iOl_dataout & wire_n0iOi_dataout & wire_n0ilO_dataout & wire_n0ill_dataout & wire_n0ili_dataout);
	n0l1O :  tri_bus
	  GENERIC MAP (
		width_datain => 8,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_n0l1O_datain,
		dataout => wire_n0l1O_dataout
	  );
	wire_ni001i_w_lg_w_dataout_range1257w1258w(0) <= NOT wire_ni001i_w_dataout_range1257w(0);
	wire_ni001i_datain <= ( wire_ni01Oi_dataout & wire_ni01lO_dataout);
	wire_ni001i_w_dataout_range1257w(0) <= wire_ni001i_dataout(0);
	ni001i :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni001i_datain,
		dataout => wire_ni001i_dataout
	  );
	wire_ni001l_w_lg_w_dataout_range1256w1259w(0) <= wire_ni001l_w_dataout_range1256w(0) AND wire_ni001i_w_lg_w_dataout_range1257w1258w(0);
	wire_ni001l_datain <= ( wire_ni01OO_dataout & wire_ni01Ol_dataout);
	wire_ni001l_w_dataout_range1256w(0) <= wire_ni001l_dataout(0);
	ni001l :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni001l_datain,
		dataout => wire_ni001l_dataout
	  );
	wire_ni01l_datain <= ( wire_n0l11O26_w_lg_w_lg_q107w108w & wire_n0l10i24_w_lg_w_lg_q104w105w & wire_ni1lO_dataout & wire_n0l10l22_w_lg_w_lg_q100w101w & wire_ni1li_dataout);
	wire_ni01l_w_dataout_range82w(0) <= wire_ni01l_dataout(0);
	ni01l :  tri_bus
	  GENERIC MAP (
		width_datain => 5,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni01l_datain,
		dataout => wire_ni01l_dataout
	  );
	wire_ni01O_datain <= ( wire_ni01i_dataout & wire_n0l10O20_w_lg_w_lg_q94w95w & wire_n0l1ii18_w_lg_w_lg_q91w92w & wire_ni1il_dataout & wire_ni1ii_dataout);
	wire_ni01O_w_dataout_range77w(0) <= wire_ni01O_dataout(0);
	ni01O :  tri_bus
	  GENERIC MAP (
		width_datain => 5,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni01O_datain,
		dataout => wire_ni01O_dataout
	  );
	wire_ni0i0l_w_lg_w_dataout_range1238w1239w(0) <= NOT wire_ni0i0l_w_dataout_range1238w(0);
	wire_ni0i0l_datain <= ( wire_ni0i1l_dataout & wire_ni0i1i_dataout);
	wire_ni0i0l_w_dataout_range1238w(0) <= wire_ni0i0l_dataout(0);
	ni0i0l :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0i0l_datain,
		dataout => wire_ni0i0l_dataout
	  );
	wire_ni0i0O_w_lg_w_dataout_range1237w1240w(0) <= wire_ni0i0O_w_dataout_range1237w(0) AND wire_ni0i0l_w_lg_w_dataout_range1238w1239w(0);
	wire_ni0i0O_datain <= ( wire_ni0i0i_dataout & wire_ni0i1O_dataout);
	wire_ni0i0O_w_dataout_range1237w(0) <= wire_ni0i0O_dataout(0);
	ni0i0O :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0i0O_datain,
		dataout => wire_ni0i0O_dataout
	  );
	wire_ni0liO_w_lg_w_dataout_range1219w1220w(0) <= NOT wire_ni0liO_w_dataout_range1219w(0);
	wire_ni0liO_datain <= ( wire_ni0l0O_dataout & wire_ni0l0l_dataout);
	wire_ni0liO_w_dataout_range1219w(0) <= wire_ni0liO_dataout(0);
	ni0liO :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0liO_datain,
		dataout => wire_ni0liO_dataout
	  );
	wire_ni0ll_datain <= ( wire_nll10i_dataout & wire_n0l1Ol12_w_lg_w_lg_q72w73w & wire_nll11l_dataout);
	ni0ll :  tri_bus
	  GENERIC MAP (
		width_datain => 3,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0ll_datain,
		dataout => wire_ni0ll_dataout
	  );
	wire_ni0lli_w_lg_w_dataout_range1218w1221w(0) <= wire_ni0lli_w_dataout_range1218w(0) AND wire_ni0liO_w_lg_w_dataout_range1219w1220w(0);
	wire_ni0lli_datain <= ( wire_ni0lil_dataout & wire_ni0lii_dataout);
	wire_ni0lli_w_dataout_range1218w(0) <= wire_ni0lli_dataout(0);
	ni0lli :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0lli_datain,
		dataout => wire_ni0lli_dataout
	  );
	wire_ni0lO_datain(0) <= ( vctl_quiet);
	ni0lO :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0lO_datain,
		dataout => wire_ni0lO_dataout
	  );
	wire_ni0Oi_datain(0) <= ( vccehxqyx);
	ni0Oi :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0Oi_datain,
		dataout => wire_ni0Oi_dataout
	  );
	wire_ni0Ol_datain <= ( wire_n0l1OO10_w_lg_w_lg_q62w63w);
	ni0Ol :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0Ol_datain,
		dataout => wire_ni0Ol_dataout
	  );
	wire_ni0OO_datain(0) <= ( outeqn);
	ni0OO :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0OO_datain,
		dataout => wire_ni0OO_dataout
	  );
	wire_ni0OOi_w_lg_w_dataout_range1200w1201w(0) <= NOT wire_ni0OOi_w_dataout_range1200w(0);
	wire_ni0OOi_datain <= ( wire_ni0Oli_dataout & wire_ni0OiO_dataout);
	wire_ni0OOi_w_dataout_range1200w(0) <= wire_ni0OOi_dataout(0);
	ni0OOi :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0OOi_datain,
		dataout => wire_ni0OOi_dataout
	  );
	wire_ni0OOl_w_lg_w_dataout_range1199w1202w(0) <= wire_ni0OOl_w_dataout_range1199w(0) AND wire_ni0OOi_w_lg_w_dataout_range1200w1201w(0);
	wire_ni0OOl_datain <= ( wire_ni0OlO_dataout & wire_ni0Oll_dataout);
	wire_ni0OOl_w_dataout_range1199w(0) <= wire_ni0OOl_dataout(0);
	ni0OOl :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni0OOl_datain,
		dataout => wire_ni0OOl_dataout
	  );
	wire_ni1OlO_w_lg_w_dataout_range1276w1277w(0) <= NOT wire_ni1OlO_w_dataout_range1276w(0);
	wire_ni1OlO_datain <= ( wire_ni1OiO_dataout & wire_ni1Oil_dataout);
	wire_ni1OlO_w_dataout_range1276w(0) <= wire_ni1OlO_dataout(0);
	ni1OlO :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni1OlO_datain,
		dataout => wire_ni1OlO_dataout
	  );
	wire_ni1OOi_w_lg_w_dataout_range1275w1278w(0) <= wire_ni1OOi_w_dataout_range1275w(0) AND wire_ni1OlO_w_lg_w_dataout_range1276w1277w(0);
	wire_ni1OOi_datain <= ( wire_ni1Oll_dataout & wire_ni1Oli_dataout);
	wire_ni1OOi_w_dataout_range1275w(0) <= wire_ni1OOi_dataout(0);
	ni1OOi :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_ni1OOi_datain,
		dataout => wire_ni1OOi_dataout
	  );
	wire_nii01l_w_lg_w_dataout_range1178w1179w(0) <= NOT wire_nii01l_w_dataout_range1178w(0);
	wire_nii01l_datain <= ( wire_nii1Ol_dataout & wire_nii1Oi_dataout);
	wire_nii01l_w_dataout_range1178w(0) <= wire_nii01l_dataout(0);
	nii01l :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii01l_datain,
		dataout => wire_nii01l_dataout
	  );
	wire_nii01O_w_lg_w_dataout_range1177w1180w(0) <= wire_nii01O_w_dataout_range1177w(0) AND wire_nii01l_w_lg_w_dataout_range1178w1179w(0);
	wire_nii01O_datain <= ( wire_nii01i_dataout & wire_nii1OO_dataout);
	wire_nii01O_w_dataout_range1177w(0) <= wire_nii01O_dataout(0);
	nii01O :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii01O_datain,
		dataout => wire_nii01O_dataout
	  );
	wire_nii0i_datain(0) <= ( atb_0);
	nii0i :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii0i_datain,
		dataout => wire_nii0i_dataout
	  );
	wire_nii0l_datain <= ( "0" & atb1);
	nii0l :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii0l_datain,
		dataout => wire_nii0l_dataout
	  );
	wire_nii0O_datain <= ( "0" & wire_n0l00i2_w_lg_w_lg_q36w37w);
	nii0O :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii0O_datain,
		dataout => wire_nii0O_dataout
	  );
	wire_nii1i_datain <= ( wire_n0l01i8_w_lg_w_lg_q56w57w);
	nii1i :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii1i_datain,
		dataout => wire_nii1i_dataout
	  );
	wire_nii1l_datain <= ( wire_n0l01l6_w_lg_w_lg_q52w53w);
	nii1l :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii1l_datain,
		dataout => wire_nii1l_dataout
	  );
	wire_nii1O_datain <= ( wire_n0l01O4_w_lg_w_lg_q48w49w);
	nii1O :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nii1O_datain,
		dataout => wire_nii1O_dataout
	  );
	wire_niii0O_w_lg_w_dataout_range1156w1157w(0) <= NOT wire_niii0O_w_dataout_range1156w(0);
	wire_niii0O_datain <= ( wire_niii1O_dataout & wire_niii1l_dataout);
	wire_niii0O_w_dataout_range1156w(0) <= wire_niii0O_dataout(0);
	niii0O :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niii0O_datain,
		dataout => wire_niii0O_dataout
	  );
	wire_niiiii_w_lg_w_dataout_range1155w1158w(0) <= wire_niiiii_w_dataout_range1155w(0) AND wire_niii0O_w_lg_w_dataout_range1156w1157w(0);
	wire_niiiii_datain <= ( wire_niii0l_dataout & wire_niii0i_dataout);
	wire_niiiii_w_dataout_range1155w(0) <= wire_niiiii_dataout(0);
	niiiii :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niiiii_datain,
		dataout => wire_niiiii_dataout
	  );
	wire_niilli_w_lg_w_dataout_range1137w1138w(0) <= NOT wire_niilli_w_dataout_range1137w(0);
	wire_niilli_datain <= ( wire_niilii_dataout & wire_niil0O_dataout);
	wire_niilli_w_dataout_range1137w(0) <= wire_niilli_dataout(0);
	niilli :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niilli_datain,
		dataout => wire_niilli_dataout
	  );
	wire_niilll_w_lg_w_dataout_range1136w1139w(0) <= wire_niilll_w_dataout_range1136w(0) AND wire_niilli_w_lg_w_dataout_range1137w1138w(0);
	wire_niilll_datain <= ( wire_niiliO_dataout & wire_niilil_dataout);
	wire_niilll_w_dataout_range1136w(0) <= wire_niilll_dataout(0);
	niilll :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niilll_datain,
		dataout => wire_niilll_dataout
	  );
	wire_niiOOl_w_lg_w_dataout_range1118w1119w(0) <= NOT wire_niiOOl_w_dataout_range1118w(0);
	wire_niiOOl_datain <= ( wire_niiOll_dataout & wire_niiOli_dataout);
	wire_niiOOl_w_dataout_range1118w(0) <= wire_niiOOl_dataout(0);
	niiOOl :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niiOOl_datain,
		dataout => wire_niiOOl_dataout
	  );
	wire_niiOOO_w_lg_w_dataout_range1117w1120w(0) <= wire_niiOOO_w_dataout_range1117w(0) AND wire_niiOOl_w_lg_w_dataout_range1118w1119w(0);
	wire_niiOOO_datain <= ( wire_niiOOi_dataout & wire_niiOlO_dataout);
	wire_niiOOO_w_dataout_range1117w(0) <= wire_niiOOO_dataout(0);
	niiOOO :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niiOOO_datain,
		dataout => wire_niiOOO_dataout
	  );
	wire_niOiii_datain <= ( wire_niOi0l_dataout & wire_niOi0i_dataout & wire_niOi1O_dataout & wire_niOi1l_dataout & wire_niOi1i_dataout & wire_niO0OO_dataout);
	niOiii :  tri_bus
	  GENERIC MAP (
		width_datain => 6,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niOiii_datain,
		dataout => wire_niOiii_dataout
	  );
	wire_niOiil_datain <= ( wire_niOi0O_dataout & wire_niO0Ol_dataout & wire_niO0Oi_dataout & wire_niO0lO_dataout & wire_niO0ll_dataout);
	niOiil :  tri_bus
	  GENERIC MAP (
		width_datain => 5,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niOiil_datain,
		dataout => wire_niOiil_dataout
	  );
	wire_niOl0l_datain <= ( wire_niOl1O_dataout & wire_niOl1l_dataout & wire_niOl1i_dataout & wire_niOiOO_dataout & wire_niOiOl_dataout & wire_niOiOi_dataout);
	niOl0l :  tri_bus
	  GENERIC MAP (
		width_datain => 6,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niOl0l_datain,
		dataout => wire_niOl0l_dataout
	  );
	wire_niOl0O_datain <= ( wire_niOl0i_dataout & wire_niOilO_dataout & wire_niOill_dataout & wire_niOili_dataout & wire_niOiiO_dataout);
	niOl0O :  tri_bus
	  GENERIC MAP (
		width_datain => 5,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niOl0O_datain,
		dataout => wire_niOl0O_dataout
	  );
	wire_niOO0i_datain <= ( wire_niOO1l_dataout & wire_niOlli_dataout & wire_niOliO_dataout & wire_niOlil_dataout & wire_niOlii_dataout);
	niOO0i :  tri_bus
	  GENERIC MAP (
		width_datain => 5,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niOO0i_datain,
		dataout => wire_niOO0i_dataout
	  );
	wire_niOO1O_datain <= ( wire_niOO1i_dataout & wire_niOlOO_dataout & wire_niOlOl_dataout & wire_niOlOi_dataout & wire_niOllO_dataout & wire_niOlll_dataout);
	niOO1O :  tri_bus
	  GENERIC MAP (
		width_datain => 6,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_niOO1O_datain,
		dataout => wire_niOO1O_dataout
	  );
	wire_nl00iO_datain <= ( wire_nl00il_dataout & wire_nl00ii_dataout & wire_nl000O_dataout & wire_nl000l_dataout & wire_nl000i_dataout & wire_nl001O_dataout & wire_nl001l_dataout & wire_nl001i_dataout);
	nl00iO :  tri_bus
	  GENERIC MAP (
		width_datain => 8,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl00iO_datain,
		dataout => wire_nl00iO_dataout
	  );
	wire_nl0i1i_datain <= ( wire_nl00Oi_dataout & wire_nl00lO_dataout & wire_nl00ll_dataout & wire_nl00li_dataout);
	nl0i1i :  tri_bus
	  GENERIC MAP (
		width_datain => 4,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl0i1i_datain,
		dataout => wire_nl0i1i_dataout
	  );
	wire_nl0O0i_datain <= ( wire_nl0O1O_dataout & wire_nl0O1l_dataout & wire_nl0O1i_dataout & wire_nl0lOO_dataout & wire_nl0lOl_dataout & wire_nl0lOi_dataout & wire_nl0llO_dataout & wire_nl0lll_dataout);
	nl0O0i :  tri_bus
	  GENERIC MAP (
		width_datain => 8,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl0O0i_datain,
		dataout => wire_nl0O0i_dataout
	  );
	wire_nl0Oll_datain <= ( wire_nl0Oil_dataout & wire_nl0Oii_dataout & wire_nl0O0O_dataout & wire_nl0O0l_dataout);
	nl0Oll :  tri_bus
	  GENERIC MAP (
		width_datain => 4,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl0Oll_datain,
		dataout => wire_nl0Oll_dataout
	  );
	wire_nl1lll_datain <= ( wire_nl1lli_dataout & wire_nl1liO_dataout & wire_nl1lil_dataout & wire_nl1lii_dataout & wire_nl1l0O_dataout & wire_nl1l0l_dataout & wire_nl1l0i_dataout & wire_nl1l1O_dataout);
	nl1lll :  tri_bus
	  GENERIC MAP (
		width_datain => 8,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl1lll_datain,
		dataout => wire_nl1lll_dataout
	  );
	wire_nl1llO_w_lg_w_dataout_range35w348w(0) <= wire_nl1llO_w_dataout_range35w(0) OR wire_nlllil_w_lg_w_lg_w_lg_w_lg_nllliO341w342w346w347w(0);
	wire_nl1llO_w_lg_w_dataout_range35w319w(0) <= wire_nl1llO_w_dataout_range35w(0) OR wire_nllOlO_w_lg_w_lg_w_lg_w_lg_nllOOi312w313w317w318w(0);
	wire_nl1llO_w_lg_w_dataout_range35w144w(0) <= wire_nl1llO_w_dataout_range35w(0) OR wire_w_lg_n0iO0i138w(0);
	wire_nl1llO_w_lg_w_dataout_range35w137w(0) <= wire_nl1llO_w_dataout_range35w(0) OR wire_w_lg_n0iO0l136w(0);
	wire_nl1llO_w_lg_w_dataout_range35w130w(0) <= wire_nl1llO_w_dataout_range35w(0) OR wire_w_lg_n0iOil129w(0);
	wire_nl1llO_datain(0) <= ( vssexqyx);
	wire_nl1llO_w_dataout_range35w(0) <= wire_nl1llO_dataout(0);
	nl1llO :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl1llO_datain,
		dataout => wire_nl1llO_dataout
	  );
	wire_nl1lOi_datain(0) <= ( vccerxqyx);
	nl1lOi :  tri_bus
	  GENERIC MAP (
		width_datain => 1,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl1lOi_datain,
		dataout => wire_nl1lOi_dataout
	  );
	wire_nl1O0l_datain <= ( wire_nl1O1l_dataout & wire_nl1O1i_dataout & wire_nl1lOO_dataout & wire_nl1lOl_dataout);
	nl1O0l :  tri_bus
	  GENERIC MAP (
		width_datain => 4,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nl1O0l_datain,
		dataout => wire_nl1O0l_dataout
	  );
	wire_nli0li_datain <= ( wire_nli0iO_dataout & wire_nli0il_dataout & wire_nli0ii_dataout & wire_nli00O_dataout & wire_nli00l_dataout & wire_nli00i_dataout & wire_nli01O_dataout & wire_nli01l_dataout);
	nli0li :  tri_bus
	  GENERIC MAP (
		width_datain => 8,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nli0li_datain,
		dataout => wire_nli0li_dataout
	  );
	wire_nlii1l_datain <= ( wire_nli0Ol_dataout & wire_nli0Oi_dataout & wire_nli0lO_dataout & wire_nli0ll_dataout);
	nlii1l :  tri_bus
	  GENERIC MAP (
		width_datain => 4,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlii1l_datain,
		dataout => wire_nlii1l_dataout
	  );
	wire_nll0lO_w_lg_w_dataout_range510w511w(0) <= NOT wire_nll0lO_w_dataout_range510w(0);
	wire_nll0lO_datain <= ( wire_nll0iO_dataout & wire_nll0il_dataout);
	wire_nll0lO_w_dataout_range510w(0) <= wire_nll0lO_dataout(0);
	nll0lO :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nll0lO_datain,
		dataout => wire_nll0lO_dataout
	  );
	wire_nll0Oi_w_lg_w_dataout_range505w512w(0) <= wire_nll0Oi_w_dataout_range505w(0) AND wire_nll0lO_w_lg_w_dataout_range510w511w(0);
	wire_nll0Oi_datain <= ( wire_nll0ll_dataout & wire_nll0li_dataout);
	wire_nll0Oi_w_dataout_range505w(0) <= wire_nll0Oi_dataout(0);
	nll0Oi :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nll0Oi_datain,
		dataout => wire_nll0Oi_dataout
	  );
	wire_nll11i_datain <= ( wire_nliOOO_dataout & wire_nliOOl_dataout & wire_nliOOi_dataout & wire_nliOlO_dataout & wire_nliOll_dataout & wire_nliOli_dataout & wire_nliOiO_dataout & wire_nliOil_dataout);
	nll11i :  tri_bus
	  GENERIC MAP (
		width_datain => 8,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nll11i_datain,
		dataout => wire_nll11i_dataout
	  );
	wire_nlll1i_w_lg_w_dataout_range487w488w(0) <= NOT wire_nlll1i_w_dataout_range487w(0);
	wire_nlll1i_datain <= ( wire_nlliOi_dataout & wire_nllilO_dataout);
	wire_nlll1i_w_dataout_range487w(0) <= wire_nlll1i_dataout(0);
	nlll1i :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlll1i_datain,
		dataout => wire_nlll1i_dataout
	  );
	wire_nlll1l_w_lg_w_dataout_range482w489w(0) <= wire_nlll1l_w_dataout_range482w(0) AND wire_nlll1i_w_lg_w_dataout_range487w488w(0);
	wire_nlll1l_datain <= ( wire_nlliOO_dataout & wire_nlliOl_dataout);
	wire_nlll1l_w_dataout_range482w(0) <= wire_nlll1l_dataout(0);
	nlll1l :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlll1l_datain,
		dataout => wire_nlll1l_dataout
	  );
	wire_nllO0l_w_lg_w_dataout_range464w465w(0) <= NOT wire_nllO0l_w_dataout_range464w(0);
	wire_nllO0l_datain <= ( wire_nllO1l_dataout & wire_nllO1i_dataout);
	wire_nllO0l_w_dataout_range464w(0) <= wire_nllO0l_dataout(0);
	nllO0l :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nllO0l_datain,
		dataout => wire_nllO0l_dataout
	  );
	wire_nllO0O_w_lg_w_dataout_range461w466w(0) <= wire_nllO0O_w_dataout_range461w(0) AND wire_nllO0l_w_lg_w_dataout_range464w465w(0);
	wire_nllO0O_datain <= ( wire_nllO0i_dataout & wire_nllO1O_dataout);
	wire_nllO0O_w_dataout_range461w(0) <= wire_nllO0O_dataout(0);
	nllO0O :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nllO0O_datain,
		dataout => wire_nllO0O_dataout
	  );
	wire_nlO0Oi_w_lg_w_dataout_range420w421w(0) <= NOT wire_nlO0Oi_w_dataout_range420w(0);
	wire_nlO0Oi_datain <= ( wire_nlO0li_dataout & wire_nlO0iO_dataout);
	wire_nlO0Oi_w_dataout_range420w(0) <= wire_nlO0Oi_dataout(0);
	nlO0Oi :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlO0Oi_datain,
		dataout => wire_nlO0Oi_dataout
	  );
	wire_nlO0Ol_w_lg_w_dataout_range417w422w(0) <= wire_nlO0Ol_w_dataout_range417w(0) AND wire_nlO0Oi_w_lg_w_dataout_range420w421w(0);
	wire_nlO0Ol_datain <= ( wire_nlO0lO_dataout & wire_nlO0ll_dataout);
	wire_nlO0Ol_w_dataout_range417w(0) <= wire_nlO0Ol_dataout(0);
	nlO0Ol :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlO0Ol_datain,
		dataout => wire_nlO0Ol_dataout
	  );
	wire_nlO1iO_w_lg_w_dataout_range443w444w(0) <= NOT wire_nlO1iO_w_dataout_range443w(0);
	wire_nlO1iO_datain <= ( wire_nlO10O_dataout & wire_nlO10l_dataout);
	wire_nlO1iO_w_dataout_range443w(0) <= wire_nlO1iO_dataout(0);
	nlO1iO :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlO1iO_datain,
		dataout => wire_nlO1iO_dataout
	  );
	wire_nlO1li_w_lg_w_dataout_range442w445w(0) <= wire_nlO1li_w_dataout_range442w(0) AND wire_nlO1iO_w_lg_w_dataout_range443w444w(0);
	wire_nlO1li_datain <= ( wire_nlO1il_dataout & wire_nlO1ii_dataout);
	wire_nlO1li_w_dataout_range442w(0) <= wire_nlO1li_dataout(0);
	nlO1li :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlO1li_datain,
		dataout => wire_nlO1li_dataout
	  );
	wire_nlOl1l_w_lg_w_dataout_range397w398w(0) <= NOT wire_nlOl1l_w_dataout_range397w(0);
	wire_nlOl1l_datain <= ( wire_nlOiOl_dataout & wire_nlOiOi_dataout);
	wire_nlOl1l_w_dataout_range397w(0) <= wire_nlOl1l_dataout(0);
	nlOl1l :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlOl1l_datain,
		dataout => wire_nlOl1l_dataout
	  );
	wire_nlOl1O_w_lg_w_dataout_range396w399w(0) <= wire_nlOl1O_w_dataout_range396w(0) AND wire_nlOl1l_w_lg_w_dataout_range397w398w(0);
	wire_nlOl1O_datain <= ( wire_nlOl1i_dataout & wire_nlOiOO_dataout);
	wire_nlOl1O_w_dataout_range396w(0) <= wire_nlOl1O_dataout(0);
	nlOl1O :  tri_bus
	  GENERIC MAP (
		width_datain => 2,
		width_dataout => 1
	  )
	  PORT MAP ( 
		datain => wire_nlOl1O_datain,
		dataout => wire_nlOl1O_dataout
	  );

 END RTL; --stratixiv_hssi_pma_c_adce
--synopsys translate_on
--VALID FILE
-- ***********************************************************
-- This WYSIWYG atom header was automatically generated by the
-- Atmgen build tool. To change it, alter data stored in the 
-- corresponding WYS file(s) in the tools/atmgen subdirectory.
-- ***********************************************************

-- *** Section 1 -- Header ***

-- -----------------------------------------------------------
--
-- Module Name : stratixiv_hssi_clock_divider
--
-- Description : DEV_FAMILY_STRATIXIV stratixiv_hssi_clock_divider Verilog simulation model
--
-- -----------------------------------------------------------

-- *** End of Section 1 ***


-- *** Section 3 -- Module declaration ***


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
ENTITY stratixiv_hssi_clock_divider IS
   GENERIC (

          --  generic control parameters  --
       MsgOn                   : Boolean := DefGlitchMsgOn;
       XOn                     : Boolean := DefGlitchXOn;
       MsgOnChecks             : Boolean := DefMsgOnChecks;
       XOnChecks               : Boolean := DefXOnChecks;
       InstancePath            : String := "*";
       TimingChecksOn          : Boolean := True;
          --  tipd  :interconnect path delays --
      tipd_refclkin               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_rateswitchdonein               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_dpriodisable                : VitalDelayType01 := DefpropDelay01;
      tipd_quadreset                : VitalDelayType01 := DefpropDelay01;
      tipd_clk0in               :VitalDelayArrayType01(4 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_vcobypassin                : VitalDelayType01 := DefpropDelay01;
      tipd_clk1in               :VitalDelayArrayType01(4 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_rateswitchbaseclkin               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_refclkdig                : VitalDelayType01 := DefpropDelay01;
      tipd_dprioin               :VitalDelayArrayType01(100 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_powerdn                : VitalDelayType01 := DefpropDelay01;
      tipd_rateswitch                : VitalDelayType01 := DefpropDelay01;
          --  tpd: Edge-Sensitive Paths --
          --  tpd: parallel and Full Connection Paths --
          --  tsetup and thold values : setup and hold times  --
          --  Pulse Width parameters  --
      
      -- *** End of Section 3 ***
      
      -- *** Section 4 -- Port size declarations ***
      
      -- Note: Variable port sizes dictated by parameters are not currently defined in
      -- the WYS file data. Busses are marked with the VARIABLE notation as a reminder.
            
      -- *** End of Section 4 ***
      
      -- *** Section 5 -- Port declarations ***
      
      lpm_type                             : STRING := "stratixiv_hssi_clock_divider";
      channel_num                          : INTEGER := 0;
      coreclk_out_gated_by_quad_reset      : STRING := "false";
      data_rate                            : INTEGER := 0;
      divide_by                            : INTEGER := 4;
      divider_type                         : STRING := "CHANNEL_REGULAR";
      dprio_config_mode                    : STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
      effective_data_rate                  : STRING := "unused";
      enable_dynamic_divider               : STRING := "false";
      enable_refclk_out                    : STRING := "false";
      inclk_select                         : INTEGER := 0;
      logical_channel_address              : INTEGER := 0;
      pre_divide_by                        : INTEGER := 1;
      rate_switch_base_clk_in_select       : INTEGER := 0;
      rate_switch_done_in_select           : INTEGER := 0;
      refclk_divide_by                     : INTEGER := 0;
      refclk_multiply_by                   : INTEGER := 0;
      refclkin_select                      : INTEGER := 0;
      select_local_rate_switch_base_clock  : STRING := "false";
      select_local_rate_switch_done        : STRING := "true";		-- shawn
      select_local_refclk                  : STRING := "false";
      select_refclk_dig                    : STRING := "false";
      sim_analogfastrefclkout_phase_shift  : INTEGER := 0;
      sim_analogrefclkout_phase_shift      : INTEGER := 0;
      sim_coreclkout_phase_shift           : INTEGER := 0;
      sim_refclkout_phase_shift            : INTEGER := 0;
      use_coreclk_out_post_divider         : STRING := "false";
      use_refclk_post_divider              : STRING := "false";
      use_vco_bypass                       : STRING := "false"
   );
   PORT (
      clk0in                               : IN STD_LOGIC_VECTOR(4 - 1 DOWNTO 0) := (others => '0');
      clk1in                               : IN STD_LOGIC_VECTOR(4 - 1 DOWNTO 0) := (others => '0');
      dpriodisable                         : IN STD_LOGIC := '1';
      dprioin                              : IN STD_LOGIC_VECTOR(100 - 1 DOWNTO 0) := (others => '0');
      powerdn                              : IN STD_LOGIC := '0';
      quadreset                            : IN STD_LOGIC := '0';
      rateswitch                           : IN STD_LOGIC := '0';
      rateswitchbaseclkin                  : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      rateswitchdonein                     : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      refclkdig                            : IN STD_LOGIC := '0';
      refclkin                             : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      vcobypassin                          : IN STD_LOGIC := '0';
      analogfastrefclkout                  : OUT STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
      analogfastrefclkoutshifted           : OUT STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
      analogrefclkout                      : OUT STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
      analogrefclkoutshifted               : OUT STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
      analogrefclkpulse                    : OUT STD_LOGIC;
      analogrefclkpulseshifted             : OUT STD_LOGIC;
      coreclkout                           : OUT STD_LOGIC;
      dprioout                             : OUT STD_LOGIC_VECTOR(100 - 1 DOWNTO 0);
      rateswitchbaseclock                  : OUT STD_LOGIC;
      rateswitchdone                       : OUT STD_LOGIC;
      rateswitchout                        : OUT STD_LOGIC;
      refclkout                            : OUT STD_LOGIC
   );
END stratixiv_hssi_clock_divider;

ARCHITECTURE trans OF stratixiv_hssi_clock_divider IS

  signal refclkin_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal rateswitchdonein_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal dpriodisable_ipd  :STD_LOGIC;
  signal quadreset_ipd  :STD_LOGIC;
  signal clk0in_ipd  :STD_LOGIC_VECTOR(4 - 1 DOWNTO 0);
  signal vcobypassin_ipd  :STD_LOGIC;
  signal clk1in_ipd  :STD_LOGIC_VECTOR(4 - 1 DOWNTO 0);
  signal rateswitchbaseclkin_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal refclkdig_ipd  :STD_LOGIC;
  signal dprioin_ipd  :STD_LOGIC_VECTOR(100 - 1 DOWNTO 0);
  signal powerdn_ipd  :STD_LOGIC;
  signal rateswitch_ipd  :STD_LOGIC;
   COMPONENT stratixiv_hssi_pma_c_clkgenbuf_tx10g
      PORT (
         clk0_in                              : IN STD_LOGIC;
         clk180_in                            : IN STD_LOGIC;
         cpulse                               : OUT STD_LOGIC;
         cpulseb                              : OUT STD_LOGIC;
         hfclk_n                              : OUT STD_LOGIC;
         hfclk_p                              : OUT STD_LOGIC;
         lfclk_n                              : OUT STD_LOGIC;
         lfclk_p                              : OUT STD_LOGIC;
         rst_n                                : IN STD_LOGIC;
         vccelxqyx                            : IN STD_LOGIC;
         vssexqyx                             : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_clkgenbuf_cmu
      PORT (
         cgb_vccelxqyx                        : OUT STD_LOGIC;
         cgb_vssexqyx                         : OUT STD_LOGIC;
         cgb_x_en                             : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         clk0_0                               : IN STD_LOGIC;
         clk0_1                               : IN STD_LOGIC;
         clk90_0                              : IN STD_LOGIC;
         clk90_1                              : IN STD_LOGIC;
         clk180_0                             : IN STD_LOGIC;
         clk180_1                             : IN STD_LOGIC;
         clk270_0                             : IN STD_LOGIC;
         clk270_1                             : IN STD_LOGIC;
         pdb                                  : IN STD_LOGIC;
         cmu_sel                              : IN STD_LOGIC;
         cpulse_ht                            : OUT STD_LOGIC;
         cpulse_x1                            : OUT STD_LOGIC;
         div5                                 : IN STD_LOGIC;
         dynamic_sw                           : IN STD_LOGIC;
         hfclkn_ht                            : OUT STD_LOGIC;
         hfclkn_x1                            : OUT STD_LOGIC;
         hfclkp_ht                            : OUT STD_LOGIC;
         hfclkp_x1                            : OUT STD_LOGIC;
         hclk                                 : OUT STD_LOGIC;
         ht_sel                               : IN STD_LOGIC;
         lfclkn_ht                            : OUT STD_LOGIC;
         lfclkn_x1                            : OUT STD_LOGIC;
         lfclkp_ht                            : OUT STD_LOGIC;
         lfclkp_x1                            : OUT STD_LOGIC;
         m_sel                                : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         pcie_sw                              : IN STD_LOGIC;
         pcie_sw_cdr                          : OUT STD_LOGIC;
         pclk                                 : OUT STD_LOGIC;
         gen2ngen1                            : OUT STD_LOGIC;
         rst_n                                : IN STD_LOGIC;
         vccelxqyx                            : IN STD_LOGIC;
         vssexqyx                             : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_aux_clock_div
      GENERIC (
         clk_divide_by                        : INTEGER := 1;
         extra_latency                        : INTEGER := 0
      );
      PORT (
         clk                                  : IN STD_LOGIC;
         reset                                : IN STD_LOGIC;
         powerdown                            : IN STD_LOGIC := '0';
         enable_d                             : IN STD_LOGIC;
         d                                    : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         clkout                               : OUT STD_LOGIC
      );
   END COMPONENT;
   
   
   -- *** End of Section 5 ***
   
   -- *** Section 6 -- Parameter declarations and default values ***
   
   -- *** End of Section 6 ***
   
   -- *** Section 7 -- Port declarations with defaults, if any ***
   
   -- This section will always be empty for WYSIWYG atoms
   -- tri1 devclrn;		//sample
   
   -- *** End of Section 7 ***
   
    -- ---------------------------------------------------------------------------
	--  New DPRIO Begin                                                          
	-- ---------------------------------------------------------------------------
	constant inclk_select_CLOCK_DIV_IDX          : integer := 0;    -- logic
	constant ht_sel_CLOCK_DIV_IDX		         : integer := 1;	-- existing 
	constant rdynamic_sw_CLOCK_DIV_IDX_0 		 : integer := 86;
	constant rpmadwidth_tx_CLOCK_DIV_IDX_0 		 : integer := 89;	-- rcgb_div5
	constant rpma_doublewidth_tx_CLOCK_DIV_IDX_0 : integer := 90;	-- rcgb_div2
	constant rcgb_m_sel_CLOCK_DIV_IDX_0 		 : integer := 91;
	constant rcgb_m_sel_CLOCK_DIV_IDX_1 		 : integer := 92;
	constant rcgb_cmu_sel_CLOCK_DIV_IDX_0 		 : integer := 93;
	
	-- central clock divider section
	constant rfreerun_centrl_CLOCK_DIV_IDX   	: integer := 10;
	constant rcentrl_clk_sel_CLOCK_DIV_IDX     	: integer := 11;
	constant rrefclk_out_div2_CLOCK_DIV_IDX    	: integer := 12;
	
	-- ---------------------------------------------------------------------------
	-- DPRIO input CRAM  
	-- ---------------------------------------------------------------------------
	-- CRAM value from DPRIO
	SIGNAL dprioin_ht_sel: STD_LOGIC;
	SIGNAL dprioin_rcgb_cmu_sel: STD_LOGIC;
	SIGNAL dprioin_rcgb_m_sel: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL dprioin_rpmadwidth_tx: STD_LOGIC;				-- rcgb_div5
	SIGNAL dprioin_rcgb_rpma_doublewidth_tx: STD_LOGIC;		-- rcgb_div2
	SIGNAL dprioin_rcgb_dynamic_sw: STD_LOGIC;
	
	-- central clock divider section
	SIGNAL dprioin_rfreerun_centrl: STD_LOGIC;
	SIGNAL dprioin_rcentrl_clk_sel: STD_LOGIC;
	SIGNAL dprioin_rrefclk_out_div2: STD_LOGIC;
	
	-- ---------------------------------------------------------------------------
	-- Initial CRAM  
	-- ---------------------------------------------------------------------------
	SIGNAL init_ht_sel: STD_LOGIC;
	SIGNAL init_rcgb_cmu_sel: STD_LOGIC;
	SIGNAL init_rcgb_m_sel: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL init_rpmadwidth_tx: STD_LOGIC;				-- rcgb_div5
	SIGNAL init_rcgb_rpma_doublewidth_tx: STD_LOGIC;	-- rcgb_div2
	SIGNAL init_rcgb_dynamic_sw: STD_LOGIC;
	
	-- central clock divider section
	SIGNAL init_rfreerun_centrl: STD_LOGIC;
	SIGNAL init_rcentrl_clk_sel: STD_LOGIC;
	SIGNAL init_rrefclk_out_div2: STD_LOGIC;
	
	-- ---------------------------------------------------------------------------
	-- CRAM  
	-- ---------------------------------------------------------------------------
	SIGNAL cram_ht_sel: STD_LOGIC;
	SIGNAL cram_rcgb_cmu_sel: STD_LOGIC;
	SIGNAL cram_rcgb_m_sel: STD_LOGIC_VECTOR(1 DOWNTO 0);
	SIGNAL cram_rpmadwidth_tx: STD_LOGIC;				-- rcgb_div5
	SIGNAL cram_rcgb_rpma_doublewidth_tx: STD_LOGIC;	-- rcgb_div2
	SIGNAL cram_rcgb_dynamic_sw: STD_LOGIC;
   
	-- central clock divider section
	SIGNAL cram_rfreerun_centrl: STD_LOGIC;
	SIGNAL cram_rcentrl_clk_sel: STD_LOGIC;
	SIGNAL cram_rrefclk_out_div2: STD_LOGIC;
	
  	SIGNAL dpriodisable_in           : STD_LOGIC;   

  	-- logic index
	SIGNAL dprioin_inclk_select  : STD_LOGIC;
	SIGNAL init_inclk_select     : STD_LOGIC;
	SIGNAL cram_inclk_select     : STD_LOGIC;
   
   -- wires for other inputs and outputs
   -- inputs
   SIGNAL clkgen_cgb_x_en         : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL clkgen_clk0_0           : STD_LOGIC;
   SIGNAL clkgen_clk90_0          : STD_LOGIC;
   SIGNAL clkgen_clk180_0         : STD_LOGIC;
   SIGNAL clkgen_clk270_0         : STD_LOGIC;
   SIGNAL clkgen_clk0_1           : STD_LOGIC;
   SIGNAL clkgen_clk90_1          : STD_LOGIC;
   SIGNAL clkgen_clk180_1         : STD_LOGIC;
   SIGNAL clkgen_clk270_1         : STD_LOGIC;
   SIGNAL clkgen_cmu_sel          : STD_LOGIC;
   SIGNAL clkgen_div5             : STD_LOGIC;
   SIGNAL clkgen_div2             : STD_LOGIC;
   SIGNAL clkgen_dynamic_sw       : STD_LOGIC;
   SIGNAL clkgen_ht_sel           : STD_LOGIC;
   SIGNAL clkgen_m_sel            : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL clkgen_pcie_sw          : STD_LOGIC;
   SIGNAL clkgen_pdb              : STD_LOGIC;
   SIGNAL clkgen_rst_n            : STD_LOGIC;
   
   -- 10g inputs
   SIGNAL clkgen_10g_clk0_in      : STD_LOGIC;
   SIGNAL clkgen_10g_clk180_in    : STD_LOGIC;
   SIGNAL clkgen_10g_rst_n        : STD_LOGIC;
   
   -- outputs
   SIGNAL clkgen_cgb_vccelxqyx    : STD_LOGIC;
   SIGNAL clkgen_cgb_vssexqyx     : STD_LOGIC;
   SIGNAL clkgen_cpulse_ht        : STD_LOGIC;
   SIGNAL clkgen_cpulse_x1        : STD_LOGIC;
   SIGNAL clkgen_hclk             : STD_LOGIC;
   SIGNAL clkgen_hfclkn_ht        : STD_LOGIC;
   SIGNAL clkgen_hfclkn_x1        : STD_LOGIC;
   SIGNAL clkgen_hfclkp_ht        : STD_LOGIC;
   SIGNAL clkgen_hfclkp_x1        : STD_LOGIC;
   SIGNAL clkgen_lfclkn_x1        : STD_LOGIC;
   SIGNAL clkgen_lfclkp_x1        : STD_LOGIC;
   SIGNAL clkgen_pclk             : STD_LOGIC;
   SIGNAL clkgen_pcie_sw_cdr      : STD_LOGIC;
   SIGNAL clkgen_gen2ngen1        : STD_LOGIC;
   SIGNAL vccelx                  : STD_LOGIC;
   SIGNAL vssex                   : STD_LOGIC;
   SIGNAL wire_reset              : STD_LOGIC;
   
   -- 10g outputs
   SIGNAL clkgen_10g_cpulse       : STD_LOGIC;
   SIGNAL clkgen_10g_cpulseb      : STD_LOGIC;
   SIGNAL clkgen_10g_hfclk_n      : STD_LOGIC;
   SIGNAL clkgen_10g_hfclk_p      : STD_LOGIC;
   SIGNAL clkgen_10g_lfclk_n      : STD_LOGIC;
   SIGNAL clkgen_10g_lfclk_p      : STD_LOGIC;
   
   -- intermediate wires
   SIGNAL coreclkout_mux          : STD_LOGIC;
   SIGNAL refclk_divide_out       : STD_LOGIC;
   SIGNAL vcobypassmux_out        : STD_LOGIC;
   SIGNAL refclkdividemux_out     : STD_LOGIC;
   
   -- upper case to lower case parameter values
   SIGNAL l_divider_type          : string(1 to 20);
    
   -- ICD's clkgenbuf_cmu instantiation 
   
   SIGNAL clkgen_lfclkn_ht        : STD_LOGIC;
   SIGNAL clkgen_lfclkp_ht        : STD_LOGIC;
   
   SIGNAL vccelxqyx               : STD_LOGIC;
   SIGNAL vssexqyx                : STD_LOGIC;
   
   SIGNAL coreclk_divide_out      : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL refclkout_xhdl0         : STD_LOGIC;
BEGIN
          
      ------------------------
      --  Wire Delay Block --
      ------------------------
      WireDelay : BLOCK
      BEGIN
       bits_refclkin : FOR i in refclkin'RANGE GENERATE
           VitalWireDelay (refclkin_ipd(i),refclkin(i), tipd_refclkin(i));
       END GENERATE;
       bits_rateswitchdonein : FOR i in rateswitchdonein'RANGE GENERATE
           VitalWireDelay (rateswitchdonein_ipd(i),rateswitchdonein(i), tipd_rateswitchdonein(i));
       END GENERATE;
           VitalWireDelay (dpriodisable_ipd,dpriodisable, tipd_dpriodisable);
           VitalWireDelay (quadreset_ipd,quadreset, tipd_quadreset);
       bits_clk0in : FOR i in clk0in'RANGE GENERATE
           VitalWireDelay (clk0in_ipd(i),clk0in(i), tipd_clk0in(i));
       END GENERATE;
           VitalWireDelay (vcobypassin_ipd,vcobypassin, tipd_vcobypassin);
       bits_clk1in : FOR i in clk1in'RANGE GENERATE
           VitalWireDelay (clk1in_ipd(i),clk1in(i), tipd_clk1in(i));
       END GENERATE;
       bits_rateswitchbaseclkin : FOR i in rateswitchbaseclkin'RANGE GENERATE
           VitalWireDelay (rateswitchbaseclkin_ipd(i),rateswitchbaseclkin(i), tipd_rateswitchbaseclkin(i));
       END GENERATE;
       bits_dprioin : FOR i in dprioin'RANGE GENERATE
           VitalWireDelay (dprioin_ipd(i),dprioin(i), tipd_dprioin(i));
       END GENERATE;
           VitalWireDelay (refclkdig_ipd,refclkdig, tipd_refclkdig);
           VitalWireDelay (rateswitch_ipd,rateswitch, tipd_rateswitch);
           VitalWireDelay (powerdn_ipd,powerdn, tipd_powerdn);
      END BLOCK;
          
      ------------------------
      --  Functionality Section --
      ------------------------
   -- Drive referenced outputs
   refclkout <= refclkout_xhdl0;
   PROCESS 
      
   BEGIN
      init_ht_sel <= mux_select((alpha_tolower(divider_type) = ("central_enhanced") OR alpha_tolower(divider_type) = ("central_regular")), '1', '0');
      init_rcgb_cmu_sel <= mux_select((inclk_select = 0), '0', '1');
      IF (pre_divide_by = 2) THEN
          init_rcgb_m_sel <= "01";
      ELSIF (pre_divide_by = 4) THEN
          init_rcgb_m_sel <= "10";
      ELSE
          init_rcgb_m_sel <= "00";
      END IF;
      init_rpmadwidth_tx <= mux_select((divide_by = 4), '0', '1');
      init_rcgb_rpma_doublewidth_tx <= mux_select((use_refclk_post_divider = ("true")), '1', '0');
      init_rcgb_dynamic_sw <= mux_select((enable_dynamic_divider = ("true")), '1', '0');
      
      init_inclk_select <= mux_select((inclk_select = 0), '0', '1');
      
    -- central clock divider section
	init_rfreerun_centrl	<= '1';  -- missing parameter
	init_rcentrl_clk_sel    <= mux_select((select_refclk_dig = ("true")), '1', '0');
	init_rrefclk_out_div2   <= mux_select((use_coreclk_out_post_divider = ("true")), '1', '0');
      WAIT;
   END PROCESS;
   
   	-- ---------------------------------------------------------------------------
	-- Set DPRIO CRAM input from dprioin  
	-- ---------------------------------------------------------------------------
	dprioin_ht_sel 					<= dprioin(ht_sel_CLOCK_DIV_IDX);
	dprioin_rcgb_cmu_sel 			<= dprioin(rcgb_cmu_sel_CLOCK_DIV_IDX_0);
	dprioin_rcgb_m_sel 				<= dprioin(rcgb_m_sel_CLOCK_DIV_IDX_1 DOWNTO rcgb_m_sel_CLOCK_DIV_IDX_0);
	dprioin_rpmadwidth_tx 			<= dprioin(rpmadwidth_tx_CLOCK_DIV_IDX_0);
	dprioin_rcgb_rpma_doublewidth_tx <= dprioin(rpma_doublewidth_tx_CLOCK_DIV_IDX_0);
	dprioin_rcgb_dynamic_sw 			<= dprioin(rdynamic_sw_CLOCK_DIV_IDX_0);
	
	-- central clock divider section
	dprioin_rfreerun_centrl  <= dprioin(rfreerun_centrl_CLOCK_DIV_IDX);
	dprioin_rcentrl_clk_sel  <= dprioin(rcentrl_clk_sel_CLOCK_DIV_IDX);
	dprioin_rrefclk_out_div2 <= dprioin(rrefclk_out_div2_CLOCK_DIV_IDX);
	
	-- ---------------------------------------------------------------------------
	-- Set DPRIO output from initial CRAM
	-- ---------------------------------------------------------------------------
	dprioout(ht_sel_CLOCK_DIV_IDX) 										<= init_ht_sel;
	dprioout(rcgb_cmu_sel_CLOCK_DIV_IDX_0) 								<= init_rcgb_cmu_sel;
	dprioout(rcgb_m_sel_CLOCK_DIV_IDX_1 DOWNTO rcgb_m_sel_CLOCK_DIV_IDX_0) 	<= init_rcgb_m_sel;
	dprioout(rpmadwidth_tx_CLOCK_DIV_IDX_0) 							<= init_rpmadwidth_tx;
	dprioout(rpma_doublewidth_tx_CLOCK_DIV_IDX_0) 						<= init_rcgb_rpma_doublewidth_tx;
	dprioout(rdynamic_sw_CLOCK_DIV_IDX_0) 								<= init_rcgb_dynamic_sw;
	
	-- central clock divider section
	dprioout(rfreerun_centrl_CLOCK_DIV_IDX)  <= init_rfreerun_centrl;
	dprioout(rcentrl_clk_sel_CLOCK_DIV_IDX)  <= init_rcentrl_clk_sel;
	dprioout(rrefclk_out_div2_CLOCK_DIV_IDX) <= init_rrefclk_out_div2;
	
	-- ---------------------------------------------------------------------------
	-- Set DPRIO CRAM
	-- ---------------------------------------------------------------------------
	dpriodisable_in <= '0' WHEN (dpriodisable = '0') ELSE '1';
	
	--cram_ht_sel 					<= init_ht_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_ht_sel;
	cram_ht_sel 					<= init_ht_sel;
	cram_rcgb_cmu_sel 				<= init_rcgb_cmu_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_cmu_sel;
	cram_rcgb_m_sel 				<= init_rcgb_m_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_m_sel;
	cram_rpmadwidth_tx 				<= init_rpmadwidth_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpmadwidth_tx;
	cram_rcgb_rpma_doublewidth_tx 	<= init_rcgb_rpma_doublewidth_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_rpma_doublewidth_tx;
	cram_rcgb_dynamic_sw 			<= init_rcgb_dynamic_sw WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_dynamic_sw;
    
	-- central clock divider section
	cram_rfreerun_centrl    <= init_rfreerun_centrl WHEN (dpriodisable_in /= '0') ELSE dprioin_rfreerun_centrl;
	cram_rcentrl_clk_sel    <= init_rcentrl_clk_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rcentrl_clk_sel;
	cram_rrefclk_out_div2   <= init_rrefclk_out_div2 WHEN (dpriodisable_in /= '0') ELSE dprioin_rrefclk_out_div2;
	
	-- ---------------------------------------------------------------------------
	-- logic index
	-- ---------------------------------------------------------------------------
   	dprioin_inclk_select <= dprioin(INCLK_SELECT_CLOCK_DIV_IDX);
    cram_inclk_select    <= init_inclk_select WHEN (dpriodisable /= '0') ELSE dprioin_inclk_select;
    dprioout(INCLK_SELECT_CLOCK_DIV_IDX) <= init_inclk_select;
	
   clkgen_cgb_x_en <= "00";
   clkgen_clk0_0 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                    clk0in_ipd(0);
   clkgen_clk0_1 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                    clk1in_ipd(0);
   clkgen_clk90_0 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                     clk0in_ipd(1);
   clkgen_clk90_1 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                     clk1in_ipd(1);
   clkgen_clk180_0 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                      clk0in_ipd(2);
   clkgen_clk180_1 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                      clk1in_ipd(2);
   clkgen_clk270_0 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                      clk0in_ipd(3);
   clkgen_clk270_1 <= '0' WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                      clk1in_ipd(3);
   clkgen_pdb <= '0' WHEN (powerdn_ipd = '1') ELSE
                 '1';
   clkgen_ht_sel <= cram_ht_sel;
   clkgen_pcie_sw <= '1' WHEN (rateswitch_ipd = '1') ELSE '0';
   clkgen_cmu_sel <= cram_inclk_select;   -- shawn cram_rcgb_cmu_sel;
   clkgen_m_sel <= cram_rcgb_m_sel;
   clkgen_div2 <= cram_rcgb_rpma_doublewidth_tx;
   clkgen_div5 <= cram_rpmadwidth_tx;
   clkgen_dynamic_sw <= cram_rcgb_dynamic_sw;
   clkgen_rst_n <= '0' WHEN (quadreset_ipd = '1') ELSE
                   '1';
   clkgen_10g_clk0_in <= clk0in_ipd(0) WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                         '0';
   clkgen_10g_clk180_in <= clk0in_ipd(2) WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                           '0';
   clkgen_10g_rst_n <= '0' WHEN (quadreset_ipd = '1') ELSE
                       '1';
   
   
   clkgen : stratixiv_hssi_pma_c_clkgenbuf_cmu
      PORT MAP (
         cgb_x_en       => clkgen_cgb_x_en,
         clk0_0         => clkgen_clk0_0,
         clk0_1         => clkgen_clk0_1,
         clk90_0        => clkgen_clk90_0,
         clk90_1        => clkgen_clk90_1,
         clk180_0       => clkgen_clk180_0,
         clk180_1       => clkgen_clk180_1,
         clk270_0       => clkgen_clk270_0,
         clk270_1       => clkgen_clk270_1,
         cmu_sel        => clkgen_cmu_sel,
         div5           => clkgen_div5,
         dynamic_sw     => clkgen_dynamic_sw,
         ht_sel         => clkgen_ht_sel,
         m_sel          => clkgen_m_sel,
         pcie_sw        => clkgen_pcie_sw,
         pdb            => clkgen_pdb,
         rst_n          => clkgen_rst_n,
         vccelxqyx      => vccelx,
         vssexqyx       => vssex,
         cgb_vccelxqyx  => clkgen_cgb_vccelxqyx,
         cgb_vssexqyx   => clkgen_cgb_vssexqyx,
         cpulse_ht      => clkgen_cpulse_ht,
         cpulse_x1      => clkgen_cpulse_x1,
         gen2ngen1      => clkgen_gen2ngen1,
         hclk           => clkgen_hclk,
         hfclkn_ht      => clkgen_hfclkn_ht,
         hfclkn_x1      => clkgen_hfclkn_x1,
         hfclkp_ht      => clkgen_hfclkp_ht,
         hfclkp_x1      => clkgen_hfclkp_x1,
         lfclkn_ht      => clkgen_lfclkn_ht,
         lfclkn_x1      => clkgen_lfclkn_x1,
         lfclkp_ht      => clkgen_lfclkp_ht,
         lfclkp_x1      => clkgen_lfclkp_x1,
         pcie_sw_cdr    => clkgen_pcie_sw_cdr,
         pclk           => clkgen_pclk
      );
   
   
   clkgen_10g : stratixiv_hssi_pma_c_clkgenbuf_tx10g
      PORT MAP (
         clk0_in    => clkgen_10g_clk0_in,
         clk180_in  => clkgen_10g_clk180_in,
         rst_n      => clkgen_10g_rst_n,
         vccelxqyx  => vccelxqyx,
         vssexqyx   => vssexqyx,
         cpulse     => clkgen_10g_cpulse,
         cpulseb    => clkgen_10g_cpulseb,
         hfclk_n    => clkgen_10g_hfclk_n,
         hfclk_p    => clkgen_10g_hfclk_p,
         lfclk_n    => clkgen_10g_lfclk_n,
         lfclk_p    => clkgen_10g_lfclk_p
      );
   analogrefclkout <= ((clkgen_10g_lfclk_n & clkgen_10g_lfclk_p)) WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                      ((clkgen_lfclkn_x1 & clkgen_lfclkp_x1));
   analogfastrefclkout <= ((clkgen_10g_hfclk_n & clkgen_10g_hfclk_p)) WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                          ((clkgen_hfclkn_x1 & clkgen_hfclkp_x1));
   analogrefclkpulse <= clkgen_10g_cpulse WHEN (alpha_tolower(divider_type) = ("high_speed_regular")) ELSE
                        clkgen_cpulse_x1;
   rateswitchdone <= clkgen_gen2ngen1 WHEN (select_local_rate_switch_done = ("true")) ELSE
                     rateswitchdonein_ipd(rate_switch_done_in_select);
   rateswitchbaseclock <= clkgen_hclk WHEN (select_local_rate_switch_base_clock = ("true")) ELSE
                          rateswitchbaseclkin_ipd(rate_switch_base_clk_in_select);
   rateswitchout <= rateswitch_ipd;


   analogrefclkoutshifted <= ((clkgen_lfclkn_ht & clkgen_lfclkp_ht));
   analogfastrefclkoutshifted <= ((clkgen_hfclkn_ht & clkgen_hfclkp_ht));
   analogrefclkpulseshifted <= clkgen_cpulse_ht;


   vcobypassmux_out <= NOT(vcobypassin_ipd) WHEN (use_vco_bypass = ("true")) ELSE
                       clkgen_pclk;

   refclk_divider : stratixiv_hssi_aux_clock_div
      GENERIC MAP (
         clk_divide_by  => 2,
         extra_latency  => 0
      )
      PORT MAP (
         clk       => vcobypassmux_out,
         enable_d  => '0',
         d         => "00000000",
         reset     => wire_reset,
         clkout    => refclk_divide_out
      );
  
   refclkdividemux_out <= refclk_divide_out WHEN (cram_rcgb_rpma_doublewidth_tx = '1') ELSE
                          vcobypassmux_out; 

   refclkout_xhdl0 <= refclkdig_ipd WHEN (cram_rcentrl_clk_sel = '1') ELSE
                      refclkdividemux_out WHEN (select_local_refclk = ("true")) ELSE
                      refclkin_ipd(refclkin_select) WHEN (enable_refclk_out = ("true")) ELSE
                      'Z';
   
   
   coreclk_divider : stratixiv_hssi_aux_clock_div
      GENERIC MAP (
         clk_divide_by  => 2,
         extra_latency  => 0
      )
      PORT MAP (
         clk       => refclkout_xhdl0,
         enable_d  => '0',
         d         => "00000000",
         reset     => wire_reset,
         clkout    => coreclk_divide_out
      );
   
   coreclkout_mux <= coreclk_divide_out WHEN (cram_rrefclk_out_div2 = '1') ELSE
                     refclkout_xhdl0;
   
   coreclkout <= coreclkout_mux;
   
END trans;


-- ***********************************************************
-- This WYSIWYG atom header was automatically generated by the
-- Atmgen build tool. To change it, alter data stored in the 
-- corresponding WYS file(s) in the tools/atmgen subdirectory.
-- ***********************************************************

-- *** Section 1 -- Header ***

-- -----------------------------------------------------------
--
-- Module Name : stratixiv_hssi_pll
--
-- Description : DEV_FAMILY_STRATIXIV stratixiv_hssi_pll Verilog simulation model
--
-- -----------------------------------------------------------

-- *** End of Section 1 ***


-- *** Section 3 -- Module declaration ***


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
ENTITY stratixiv_hssi_pll IS
   GENERIC (

          --  generic control parameters  --
       MsgOn                   : Boolean := DefGlitchMsgOn;
       XOn                     : Boolean := DefGlitchXOn;
       MsgOnChecks             : Boolean := DefMsgOnChecks;
       XOnChecks               : Boolean := DefXOnChecks;
       InstancePath            : String := "*";
       TimingChecksOn          : Boolean := True;
          --  tipd  :interconnect path delays --
      tipd_dpriodisable                : VitalDelayType01 := DefpropDelay01;
      tipd_datain                : VitalDelayType01 := DefpropDelay01;
      tipd_areset                : VitalDelayType01 := DefpropDelay01;
      tipd_earlyeios             : VitalDelayType01 := DefpropDelay01;
      tipd_locktorefclk                : VitalDelayType01 := DefpropDelay01;
      tipd_pfdfbclk                : VitalDelayType01 := DefpropDelay01;
      tipd_powerdown                : VitalDelayType01 := DefpropDelay01;
      tipd_inclk               :VitalDelayArrayType01(10 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_dprioin               :VitalDelayArrayType01(300 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_rateswitch                : VitalDelayType01 := DefpropDelay01;
          --  tpd: Edge-Sensitive Paths --
          --  tpd: parallel and Full Connection Paths --
      tpd_inclk_clk : VitalDelayType01 := DefPropDelay01;
          --  tsetup and thold values : setup and hold times  --
          --  Pulse Width parameters  --
      
      -- *** End of Section 3 ***
      
      -- *** Section 4 -- Port size declarations ***
      
      -- Note: Variable port sizes dictated by parameters are not currently defined in
      -- the WYS file data. Busses are marked with the VARIABLE notation as a reminder.
      
      -- * VARIABLE
      
      -- * VARIABLE
      
      -- * VARIABLE
      
      -- * VARIABLE
      
      -- * VARIABLE
      
      -- *** End of Section 4 ***
      
      -- *** Section 5 -- Port declarations ***
      
      lpm_type                       : STRING := "stratixiv_hssi_pll";
      auto_settings                  : STRING := "true";
      bandwidth_type                 : STRING := "Auto";
      base_data_rate                 : STRING := "unused";
      channel_num                    : INTEGER := 0;
      charge_pump_current_bits       : INTEGER := 0;
      charge_pump_mode_bits          : INTEGER := 0;
      charge_pump_test_enable        : STRING := "false";
      dprio_config_mode              : STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
      effective_data_rate            : STRING := "unused";
      enable_dynamic_divider         : STRING := "false";
      fast_lock_control              : STRING := "false";
      inclk0_input_period            : INTEGER := 0;
      inclk1_input_period            : INTEGER := 0;
      inclk2_input_period            : INTEGER := 0;
      inclk3_input_period            : INTEGER := 0;
      inclk4_input_period            : INTEGER := 0;
      inclk5_input_period            : INTEGER := 0;
      inclk6_input_period            : INTEGER := 0;
      inclk7_input_period            : INTEGER := 0;
      inclk8_input_period            : INTEGER := 0;
      inclk9_input_period            : INTEGER := 0;
      input_clock_frequency          : STRING := "unused";
      logical_channel_address        : INTEGER := 0;
      logical_tx_pll_number          : INTEGER := 0;
      loop_filter_c_bits             : INTEGER := 0;
      loop_filter_r_bits             : INTEGER := 0;
      m                              : INTEGER := 0;
      n                              : INTEGER := 0;
      pd_charge_pump_current_bits    : INTEGER := 0;
      pd_loop_filter_r_bits          : INTEGER := 0;
      pfd_clk_select                 : INTEGER := 0;
      pfd_fb_select                  : STRING := "internal";
      pll_type                       : STRING := "Auto";
      protocol_hint                  : STRING := "basic";
      refclk_divide_by               : INTEGER := 0;
      refclk_multiply_by             : INTEGER := 0;
      sim_is_negative_ppm_drift      : STRING := "false";
      sim_net_ppm_variation          : INTEGER := 0;
      test_charge_pump_current_down  : STRING := "false";
      test_charge_pump_current_up    : STRING := "false";
      use_refclk_pin                 : STRING := "false";
      vco_data_rate                  : INTEGER := 0;
      vco_divide_by                  : INTEGER := 0;
      vco_range                      : STRING := "low";
      vco_multiply_by                : INTEGER := 0;
      vco_post_scale                 : INTEGER := 0;
      vco_tuning_bits                : INTEGER := 0;
      volt_reg_control_bits          : INTEGER := 0;
      volt_reg_output_bits           : INTEGER := 0;
      sim_clkout_phase_shift         : INTEGER := 0;
      sim_clkout_latency             : INTEGER := 0;
      PARAM_DELAY                    : INTEGER := 0
   );
   PORT (
      areset                         : IN STD_LOGIC := '0';
      datain                         : IN STD_LOGIC := '0';
      dpriodisable                   : IN STD_LOGIC := '1';
      dprioin                        : IN STD_LOGIC_VECTOR(300 - 1 DOWNTO 0) := (others => '0');
      earlyeios                      : IN STD_LOGIC := '0';
      extra10gin                     : IN STD_LOGIC_VECTOR(6 - 1 DOWNTO 0) := (others => '0');
      inclk                          : IN STD_LOGIC_VECTOR(10 - 1 DOWNTO 0) := (others => '0');
      locktorefclk                   : IN STD_LOGIC := '1';
      pfdfbclk                       : IN STD_LOGIC := '0';
      powerdown                      : IN STD_LOGIC := '0';
      rateswitch                     : IN STD_LOGIC := '0';
      clk                            : OUT STD_LOGIC_VECTOR(4 - 1 DOWNTO 0);
      dataout                        : OUT STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
      dprioout                       : OUT STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);
      freqlocked                     : OUT STD_LOGIC;
      locked                         : OUT STD_LOGIC;
      pfdfbclkout                    : OUT STD_LOGIC;
      pfdrefclkout                   : OUT STD_LOGIC;
      vcobypassout                   : OUT STD_LOGIC
   );
END stratixiv_hssi_pll;

ARCHITECTURE trans OF stratixiv_hssi_pll IS

  signal dpriodisable_ipd  :STD_LOGIC;
  signal datain_ipd  :STD_LOGIC;
  signal areset_ipd  :STD_LOGIC;
  signal earlyeios_ipd  :STD_LOGIC;
  signal locktorefclk_ipd  :STD_LOGIC;
  signal pfdfbclk_ipd  :STD_LOGIC;
  signal powerdown_ipd  :STD_LOGIC;
  signal inclk_ipd  :STD_LOGIC_VECTOR(10 - 1 DOWNTO 0);
  signal dprioin_ipd  :STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);
  signal rateswitch_ipd  :STD_LOGIC;
   COMPONENT stratixiv_hssi_aux_clock_div
      GENERIC (
         clk_divide_by                  : INTEGER := 1;
         extra_latency                  : INTEGER := 0
      );
      PORT (
         clk                            : IN STD_LOGIC;
         reset                          : IN STD_LOGIC;
         powerdown                      : IN STD_LOGIC := '0';
         enable_d                       : IN STD_LOGIC;
         d                              : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         clkout                         : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_aux_clock_mult
      GENERIC (
         clk_multiply_by                : INTEGER := 1;
         pfd_fb_select                  : string := "internal"
      );
      PORT (
         clk                            : IN STD_LOGIC;
         fbclk                          : IN STD_LOGIC;
         adjust                         : IN STD_LOGIC := '0';
         adjust_without_lol             : IN STD_LOGIC := '0';
         reset                          : IN STD_LOGIC := '0';
         enable_m                       : IN STD_LOGIC;
         m                              : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         clkout                         : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
         busy                           : OUT STD_LOGIC_VECTOR(1 DOWNTO 0)
      );
   END COMPONENT;
   
   
   -- *** End of Section 5 ***
   
   -- *** Section 6 -- Parameter declarations and default values ***
   
   -- *** End of Section 6 ***
   
   -- Simulation only parameters
   
   -- *** Section 7 -- Port declarations with defaults, if any ***
   
   -- This section will always be empty for WYSIWYG atoms
   -- tri1 devclrn;		//sample
   
   -- *** End of Section 7 ***
   
   -- ---------------------------------------------------------------------------
   --  Model Implementation Begin                                               -
   -- ---------------------------------------------------------------------------    
   SIGNAL mdpriodisable               : STD_LOGIC;
    
   -- ******************* DPRIO support for SDI *********************************
   
   -- ---------------------------------------------------------------------------
   --  Model / Submodule Instantiations                                         -
   -- ---------------------------------------------------------------------------
   
   --signalareset_ipd                  : STD_LOGIC;
   SIGNAL ck0_pd                      : STD_LOGIC;
   SIGNAL ck90_pd                     : STD_LOGIC;
   SIGNAL ck180_pd                    : STD_LOGIC;
   SIGNAL ck270_pd                    : STD_LOGIC;
      
   -- DPRIO
   SIGNAL dprioenable                 : STD_LOGIC;
   SIGNAL dprioen_reg                 : STD_LOGIC;
   SIGNAL cru_l_chn                   : STD_LOGIC_VECTOR(7 DOWNTO 0);
     
   -- intermediate wires
   SIGNAL busy                        : STD_LOGIC_VECTOR(1 DOWNTO 0);		-- VCO state
   SIGNAL charge_pump_delayed         : STD_LOGIC;
   SIGNAL check_phase                 : STD_LOGIC;
   SIGNAL clk_div                     : STD_LOGIC;
   SIGNAL clk_div_delayed             : STD_LOGIC;
   SIGNAL clk_post_scale              : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL clk_vco                     : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL divide_by_M_clkout          : STD_LOGIC;
   SIGNAL fbclk                       : STD_LOGIC;
   SIGNAL pcie_clk                    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL pcie_div2_clk0              : STD_LOGIC;
   SIGNAL pcie_div2_clk1              : STD_LOGIC;
   SIGNAL pfd_refclk                  : STD_LOGIC;
   SIGNAL pll_clkin                   : STD_LOGIC;
   SIGNAL pll_clkin_pre_latency       : STD_LOGIC;
   SIGNAL reset                       : STD_LOGIC;
   
   SIGNAL deven                       : STD_LOGIC;
   SIGNAL devenb                      : STD_LOGIC;
   SIGNAL dodd                        : STD_LOGIC;
   SIGNAL doddb                       : STD_LOGIC;
   SIGNAL deven_int1                  : STD_LOGIC := '0';
   SIGNAL deven_int2                  : STD_LOGIC := '0';
   SIGNAL dodd_int1                   : STD_LOGIC := '0';
   SIGNAL dodd_int2                   : STD_LOGIC := '0';
   SIGNAL d90_int1                    : STD_LOGIC;
   SIGNAL d90_int2                    : STD_LOGIC;
   SIGNAL d270_int1                   : STD_LOGIC;
   SIGNAL d270_int2                   : STD_LOGIC;
   SIGNAL pcie_div2_clk2              : STD_LOGIC;
   SIGNAL pcie_div2_clk3              : STD_LOGIC;
   
   SIGNAL pdb                         : STD_LOGIC;
   
   SIGNAL charge_pump                 : STD_LOGIC := '1';	-- re-adjust VCO frequency
   SIGNAL adjust_without_lol          : STD_LOGIC := '0';
   
   SIGNAL last_fb_clk_edge            : time ;
   SIGNAL expected_clk_period         : time ;
   SIGNAL clk_tolerance               : time ;
   SIGNAL real_clk_period             : time ;
   SIGNAL last_pfd_refclk_edge        : time ;
   SIGNAL last_pll_clkin_edge         : time ;
   SIGNAL last_real_clk_period        : time ;
   
   SIGNAL first_pll_clkin_edge_detect : STD_LOGIC := '0';
   SIGNAL display_msgs                : STD_LOGIC := '1';
   SIGNAL freq_viol_msg_sem           : STD_LOGIC;
   SIGNAL locked_real                 : STD_LOGIC := '0';
   
   SIGNAL dprio_reset                 : STD_LOGIC;		-- reset through DPRIO CRAM in 7.1
   SIGNAL d_wire                      : STD_LOGIC_VECTOR(7 DOWNTO 0);

    SIGNAL change_in_clk_freq : BOOLEAN := FALSE;
    SIGNAL minor_clk_freq_change : BOOLEAN := FALSE;
   
   SIGNAL datain_dly                  : STD_LOGIC := '0';
   -- X-HDL generated signals

   SIGNAL xhdl1 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL locked_xhdl0                : STD_LOGIC;
   
   -- Table39: PMA Per Channel RX Control Register 4 for Channel 0	(RXPLL)
   constant rcru_pdbwctrl_PLL_IDX_0	: integer := 0;
   constant rcru_pdbwctrl_PLL_IDX_1	: integer := 1;
   constant rcru_pfdbwctrl_PLL_IDX_0	: integer := 2;
   constant rcru_pfdbwctrl_PLL_IDX_1	: integer := 3;
   constant rcru_crplctrl_PLL_IDX_0	: integer := 4;
   constant rcru_crplctrl_PLL_IDX_1	: integer := 5;
   constant rcru_ctl0_PLL_IDX_0	: integer := 6;
   constant rcru_l_PLL_IDX_0	: integer := 7;
   constant rcru_l_PLL_IDX_1	: integer := 8;
   constant rcru_m_PLL_IDX_0	: integer := 9;
   constant rcru_m_PLL_IDX_1	: integer := 10;
   constant rcru_m_PLL_IDX_2	: integer := 11;
   constant rcru_m_PLL_IDX_3	: integer := 12;
   constant rcru_m_sel_PLL_IDX_0	: integer := 13;
   constant rcru_m_sel_PLL_IDX_1	: integer := 14;
   constant rcru_div2_PLL_IDX_0	: integer := 15;
   
   -- Table40: PMA Per Channel RX Control Register 5 for Channel 0	(RXPLL)
   constant reserved_0_TB40_PLL_IDX_0	: integer := 16;
   constant reserved_0_TB40_PLL_IDX_1	: integer := 17;
   constant rcru_iselpd_PLL_IDX_0	: integer := 18;
   constant rcru_iselpd_PLL_IDX_1	: integer := 19;
   constant rcru_iselpd_PLL_IDX_2	: integer := 20;
   constant rcru_isel_PLL_IDX_0	: integer := 21;
   constant rcru_isel_PLL_IDX_1	: integer := 22;
   constant rcru_isel_PLL_IDX_2	: integer := 23;
   constant rcru_testdnen_PLL_IDX_0	: integer := 24;
   constant rcru_testupen_PLL_IDX_0	: integer := 25;
   constant rcru_testen_PLL_IDX_0	: integer := 26;
   constant rcru_lst_PLL_IDX_0	: integer := 27;
   constant rcru_lst_PLL_IDX_1	: integer := 28;
   constant rcru_lst_PLL_IDX_2	: integer := 29;
   constant rcru_lst_PLL_IDX_3	: integer := 30;
   constant rcru_rlbk_PLL_IDX_0	: integer := 31;
   
   -- Table41: PMA Per Channel RX Control Register 6 for Channel 0	(RXPLL)
   constant rcru_rgla_isel_PLL_IDX_0	: integer := 32;
   constant rcru_rgla_isel_PLL_IDX_1	: integer := 33;
   constant rcru_rgla_isel_PLL_IDX_2	: integer := 34;
   constant rcru_pdof_test_PLL_IDX_0	: integer := 35;
   constant rcru_pdof_test_PLL_IDX_1	: integer := 36;
   constant rcru_pdof_test_PLL_IDX_2	: integer := 37;
   constant rcru_pdfl_PLL_IDX_0	: integer := 38;
   constant rcru_sd_sel_PLL_IDX_0	: integer := 39;
   constant reserved_0_TB41_PLL_IDX_0	: integer := 40;
   constant rcru_ignore_phslck_PLL_IDX_0	: integer := 41;
   constant rcru_cmu_mode_PLL_IDX_0	: integer := 42;
   constant rrx_cru_rst_PLL_IDX_0	: integer := 43;
   constant rrx_cru_pdb_PLL_IDX_0	: integer := 44;
   constant rltr_PLL_IDX_0	: integer := 45;
   constant rltd_PLL_IDX_0	: integer := 46;
   constant rcp_mode_PLL_IDX_0	: integer := 47;
   
   -- Table42: PMA Per Channel RX Control Register 7 for Channel 0	(RXPLL)
   constant rcru_pdof_270i_PLL_IDX_0	: integer := 48;
   constant rcru_pdof_270i_PLL_IDX_1	: integer := 49;
   constant rcru_pdof_270i_PLL_IDX_2	: integer := 50;
   constant rcru_pdof_270i_PLL_IDX_3	: integer := 51;
   constant rcru_pdof_180i_PLL_IDX_0	: integer := 52;
   constant rcru_pdof_180i_PLL_IDX_1	: integer := 53;
   constant rcru_pdof_180i_PLL_IDX_2	: integer := 54;
   constant rcru_pdof_180i_PLL_IDX_3	: integer := 55;
   constant rcru_pdof_90i_PLL_IDX_0	: integer := 56;
   constant rcru_pdof_90i_PLL_IDX_1	: integer := 57;
   constant rcru_pdof_90i_PLL_IDX_2	: integer := 58;
   constant rcru_pdof_90i_PLL_IDX_3	: integer := 59;
   constant rcru_pdof_0i_PLL_IDX_0	: integer := 60;
   constant rcru_pdof_0i_PLL_IDX_1	: integer := 61;
   constant rcru_pdof_0i_PLL_IDX_2	: integer := 62;
   constant rcru_pdof_0i_PLL_IDX_3	: integer := 63;

   -- Manual: PLL (only rx_cdr_pll uses it: table 33 & 59) --------------
   constant rdynamic_sw_PLL_IDX_0 	: integer := 70;
   
   -- SW logical index ---------------------------------------------------------- 
   constant PFD_CLK_SEL_PLL_IDX_0	: integer := 100;
   constant PFD_CLK_SEL_PLL_IDX_1	: integer := 101;
   constant PFD_CLK_SEL_PLL_IDX_2	: integer := 102;
   constant PFD_CLK_SEL_PLL_IDX_3	: integer := 103;
       
   -- ---------------------------------------------------------------------------
   -- DPRIO input CRAM  
   -- ---------------------------------------------------------------------------
   
   -- PMA Per Channel RX Control Register 4 for Channel 0
   SIGNAL dprioin_rcru_pdbwctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rcru_pfdbwctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rcru_crplctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rcru_ctl0	: STD_LOGIC;
   SIGNAL dprioin_rcru_l	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rcru_m	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rcru_m_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rcru_div2	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 5 for Channel 0
   SIGNAL dprioin_reserved_0_TB40	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rcru_iselpd	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rcru_isel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rcru_testdnen	: STD_LOGIC;
   SIGNAL dprioin_rcru_testupen	: STD_LOGIC;
   SIGNAL dprioin_rcru_testen	: STD_LOGIC;
   SIGNAL dprioin_rcru_lst	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rcru_rlbk	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 6 for Channel 0
   SIGNAL dprioin_rcru_rgla_isel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rcru_pdof_test	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rcru_pdfl	: STD_LOGIC;
   SIGNAL dprioin_rcru_sd_sel	: STD_LOGIC;
   SIGNAL dprioin_reserved_0_TB41	: STD_LOGIC;
   SIGNAL dprioin_rcru_ignore_phslck	: STD_LOGIC;
   SIGNAL dprioin_rcru_cmu_mode	: STD_LOGIC;
   SIGNAL dprioin_rrx_cru_rst	: STD_LOGIC;
   SIGNAL dprioin_rrx_cru_pdb	: STD_LOGIC;
   SIGNAL dprioin_rltr	: STD_LOGIC;
   SIGNAL dprioin_rltd	: STD_LOGIC;
   SIGNAL dprioin_rcp_mode	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 7 for Channel 0
   SIGNAL dprioin_rcru_pdof_270i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rcru_pdof_180i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rcru_pdof_90i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rcru_pdof_0i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   SIGNAL m_dprioin_modulus           : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL n_dprioin_modulus           : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL dprioin_vco_post_scale : STD_LOGIC_VECTOR(1 DOWNTO 0) := "00";
   SIGNAL dprioin_pfd_fb_select : STD_LOGIC_VECTOR(1 DOWNTO 0) := "00";
   SIGNAL dprioin_pfd_clk_sel	: STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";  
   
   -- ---------------------------------------------------------------------------
   -- Initial CRAM  
   -- ---------------------------------------------------------------------------
   
   -- PMA Per Channel RX Control Register 4 for Channel 0
   SIGNAL init_rcru_pdbwctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rcru_pfdbwctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rcru_crplctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rcru_ctl0	: STD_LOGIC;
   SIGNAL init_rcru_l	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rcru_m	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rcru_m_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rcru_div2	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 5 for Channel 0
   SIGNAL init_reserved_0_TB40	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rcru_iselpd	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rcru_isel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rcru_testdnen	: STD_LOGIC;
   SIGNAL init_rcru_testupen	: STD_LOGIC;
   SIGNAL init_rcru_testen	: STD_LOGIC;
   SIGNAL init_rcru_lst	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rcru_rlbk	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 6 for Channel 0
   SIGNAL init_rcru_rgla_isel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rcru_pdof_test	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rcru_pdfl	: STD_LOGIC;
   SIGNAL init_rcru_sd_sel	: STD_LOGIC;
   SIGNAL init_reserved_0_TB41	: STD_LOGIC;
   SIGNAL init_rcru_ignore_phslck	: STD_LOGIC;
   SIGNAL init_rcru_cmu_mode	: STD_LOGIC;
   SIGNAL init_rrx_cru_rst	: STD_LOGIC;
   SIGNAL init_rrx_cru_pdb	: STD_LOGIC;
   SIGNAL init_rltr	: STD_LOGIC;
   SIGNAL init_rltd	: STD_LOGIC;
   SIGNAL init_rcp_mode	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 7 for Channel 0
   SIGNAL init_rcru_pdof_270i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rcru_pdof_180i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rcru_pdof_90i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rcru_pdof_0i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- Manual section
   SIGNAL init_vco_post_scale : STD_LOGIC_VECTOR(1 DOWNTO 0) := "00";
   SIGNAL init_pfd_fb_select : STD_LOGIC_VECTOR(1 DOWNTO 0) := "00";
   SIGNAL init_pfd_clk_sel	    : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
   
   SIGNAL ext_fb_select : STD_LOGIC := '0';
   SIGNAL dprioin_rdynamic_sw : STD_LOGIC := '0';
   
   -- ---------------------------------------------------------------------------
   -- CRAM  
   -- ---------------------------------------------------------------------------
   
   -- PMA Per Channel RX Control Register 4 for Channel 0
   SIGNAL cram_rcru_pdbwctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rcru_pfdbwctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rcru_crplctrl	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rcru_ctl0	: STD_LOGIC;
   SIGNAL cram_rcru_l	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rcru_m	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rcru_m_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rcru_div2	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 5 for Channel 0
   SIGNAL cram_reserved_0_TB40	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rcru_iselpd	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rcru_isel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rcru_testdnen	: STD_LOGIC;
   SIGNAL cram_rcru_testupen	: STD_LOGIC;
   SIGNAL cram_rcru_testen	: STD_LOGIC;
   SIGNAL cram_rcru_lst	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rcru_rlbk	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 6 for Channel 0
   SIGNAL cram_rcru_rgla_isel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rcru_pdof_test	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rcru_pdfl	: STD_LOGIC;
   SIGNAL cram_rcru_sd_sel	: STD_LOGIC;
   SIGNAL cram_reserved_0_TB41	: STD_LOGIC;
   SIGNAL cram_rcru_ignore_phslck	: STD_LOGIC;
   SIGNAL cram_rcru_cmu_mode	: STD_LOGIC;
   SIGNAL cram_rrx_cru_rst	: STD_LOGIC;
   SIGNAL cram_rrx_cru_pdb	: STD_LOGIC;
   SIGNAL cram_rltr	: STD_LOGIC;
   SIGNAL cram_rltd	: STD_LOGIC;
   SIGNAL cram_rcp_mode	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 7 for Channel 0
   SIGNAL cram_rcru_pdof_270i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rcru_pdof_180i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rcru_pdof_90i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rcru_pdof_0i	: STD_LOGIC_VECTOR(3 DOWNTO 0);
 
   -- SW logical index ------------------------------------------
   SIGNAL cram_vco_post_scale : STD_LOGIC_VECTOR(1 DOWNTO 0) := "00";
   SIGNAL cram_pfd_fb_select : STD_LOGIC_VECTOR(1 DOWNTO 0) := "00";
   SIGNAL cram_pfd_clk_sel	    : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
   
   SIGNAL cram_rdynamic_sw : STD_LOGIC := '0';
   
BEGIN
          
      ------------------------
      --  Wire Delay Block --
      ------------------------
      WireDelay : BLOCK
      BEGIN
           VitalWireDelay (areset_ipd,areset, tipd_areset);
           VitalWireDelay (datain_ipd,datain, tipd_datain);
           VitalWireDelay (dpriodisable_ipd,dpriodisable, tipd_dpriodisable);
           VitalWireDelay (earlyeios_ipd,earlyeios, tipd_earlyeios);
           VitalWireDelay (locktorefclk_ipd,locktorefclk, tipd_locktorefclk);
           VitalWireDelay (pfdfbclk_ipd,pfdfbclk, tipd_pfdfbclk);
           VitalWireDelay (powerdown_ipd,powerdown, tipd_powerdown);
       bits_dprioin : FOR i in dprioin'RANGE GENERATE
           VitalWireDelay (dprioin_ipd(i),dprioin(i), tipd_dprioin(i));
       END GENERATE;
       bits_inclk : FOR i in inclk'RANGE GENERATE
           VitalWireDelay (inclk_ipd(i),inclk(i), tipd_inclk(i));
       END GENERATE;
           VitalWireDelay (rateswitch_ipd,rateswitch, tipd_rateswitch);
      END BLOCK;
          
        -- new DPRIO model begin --
        -- ---------------------------------------------------------------------------
        -- Set DPRIO CRAM input from dprioin  
        -- ---------------------------------------------------------------------------
        
        -- PMA Per Channel RX Control Register 4 for Channel 0
        dprioin_rcru_pdbwctrl	<= dprioin(rcru_pdbwctrl_PLL_IDX_1 DOWNTO rcru_pdbwctrl_PLL_IDX_0);
        dprioin_rcru_pfdbwctrl	<= dprioin(rcru_pfdbwctrl_PLL_IDX_1 DOWNTO rcru_pfdbwctrl_PLL_IDX_0);
        dprioin_rcru_crplctrl	<= dprioin(rcru_crplctrl_PLL_IDX_1 DOWNTO rcru_crplctrl_PLL_IDX_0);
        dprioin_rcru_ctl0	<= dprioin(rcru_ctl0_PLL_IDX_0);
        dprioin_rcru_l	<= dprioin(rcru_l_PLL_IDX_1 DOWNTO rcru_l_PLL_IDX_0);
        dprioin_rcru_m	<= dprioin(rcru_m_PLL_IDX_3 DOWNTO rcru_m_PLL_IDX_0);
        dprioin_rcru_m_sel	<= dprioin(rcru_m_sel_PLL_IDX_1 DOWNTO rcru_m_sel_PLL_IDX_0);
        dprioin_rcru_div2	<= dprioin(rcru_div2_PLL_IDX_0);
        
        -- PMA Per Channel RX Control Register 5 for Channel 0
        dprioin_reserved_0_TB40	<= dprioin(reserved_0_TB40_PLL_IDX_1 DOWNTO reserved_0_TB40_PLL_IDX_0);
        dprioin_rcru_iselpd	<= dprioin(rcru_iselpd_PLL_IDX_2 DOWNTO rcru_iselpd_PLL_IDX_0);
        dprioin_rcru_isel	<= dprioin(rcru_isel_PLL_IDX_2 DOWNTO rcru_isel_PLL_IDX_0);
        dprioin_rcru_testdnen	<= dprioin(rcru_testdnen_PLL_IDX_0);
        dprioin_rcru_testupen	<= dprioin(rcru_testupen_PLL_IDX_0);
        dprioin_rcru_testen	<= dprioin(rcru_testen_PLL_IDX_0);
        dprioin_rcru_lst	<= dprioin(rcru_lst_PLL_IDX_3 DOWNTO rcru_lst_PLL_IDX_0);
        dprioin_rcru_rlbk	<= dprioin(rcru_rlbk_PLL_IDX_0);
        
        -- PMA Per Channel RX Control Register 6 for Channel 0
        dprioin_rcru_rgla_isel	<= dprioin(rcru_rgla_isel_PLL_IDX_2 DOWNTO rcru_rgla_isel_PLL_IDX_0);
        dprioin_rcru_pdof_test	<= dprioin(rcru_pdof_test_PLL_IDX_2 DOWNTO rcru_pdof_test_PLL_IDX_0);
        dprioin_rcru_pdfl	<= dprioin(rcru_pdfl_PLL_IDX_0);
        dprioin_rcru_sd_sel	<= dprioin(rcru_sd_sel_PLL_IDX_0);
        dprioin_reserved_0_TB41	<= dprioin(reserved_0_TB41_PLL_IDX_0);
        dprioin_rcru_ignore_phslck	<= dprioin(rcru_ignore_phslck_PLL_IDX_0);
        dprioin_rcru_cmu_mode	<= dprioin(rcru_cmu_mode_PLL_IDX_0);
        dprioin_rrx_cru_rst	<= dprioin(rrx_cru_rst_PLL_IDX_0);
        dprioin_rrx_cru_pdb	<= dprioin(rrx_cru_pdb_PLL_IDX_0);
        dprioin_rltr	<= dprioin(rltr_PLL_IDX_0);
        dprioin_rltd	<= dprioin(rltd_PLL_IDX_0);
        dprioin_rcp_mode	<= dprioin(rcp_mode_PLL_IDX_0);
        
        -- PMA Per Channel RX Control Register 7 for Channel 0
        dprioin_rcru_pdof_270i	<= dprioin(rcru_pdof_270i_PLL_IDX_3 DOWNTO rcru_pdof_270i_PLL_IDX_0);
        dprioin_rcru_pdof_180i	<= dprioin(rcru_pdof_180i_PLL_IDX_3 DOWNTO rcru_pdof_180i_PLL_IDX_0);
        dprioin_rcru_pdof_90i	<= dprioin(rcru_pdof_90i_PLL_IDX_3 DOWNTO rcru_pdof_90i_PLL_IDX_0);
        dprioin_rcru_pdof_0i	<= dprioin(rcru_pdof_0i_PLL_IDX_3 DOWNTO rcru_pdof_0i_PLL_IDX_0);
        
        -- manual section --
   	    dprioin_pfd_clk_sel <= dprioin(PFD_CLK_SEL_PLL_IDX_3 DOWNTO PFD_CLK_SEL_PLL_IDX_0);
   	    dprioin_rdynamic_sw <= dprioin(rdynamic_sw_PLL_IDX_0);
   	    
        -- ---------------------------------------------------------------------------
        -- Set DPRIO output from initial CRAM
        -- ---------------------------------------------------------------------------
        
        -- PMA Per Channel RX Control Register 4 for Channel 0
        dprioout(rcru_pdbwctrl_PLL_IDX_1 DOWNTO rcru_pdbwctrl_PLL_IDX_0) <= init_rcru_pdbwctrl;
        dprioout(rcru_pfdbwctrl_PLL_IDX_1 DOWNTO rcru_pfdbwctrl_PLL_IDX_0) <= init_rcru_pfdbwctrl;
        dprioout(rcru_crplctrl_PLL_IDX_1 DOWNTO rcru_crplctrl_PLL_IDX_0) <= init_rcru_crplctrl;
        dprioout(rcru_ctl0_PLL_IDX_0) <= init_rcru_ctl0;
        dprioout(rcru_l_PLL_IDX_1 DOWNTO rcru_l_PLL_IDX_0) <= init_rcru_l;
        dprioout(rcru_m_PLL_IDX_3 DOWNTO rcru_m_PLL_IDX_0) <= init_rcru_m;
        dprioout(rcru_m_sel_PLL_IDX_1 DOWNTO rcru_m_sel_PLL_IDX_0) <= init_rcru_m_sel;
        dprioout(rcru_div2_PLL_IDX_0) <= init_rcru_div2;
        
        -- PMA Per Channel RX Control Register 5 for Channel 0
        dprioout(reserved_0_TB40_PLL_IDX_1 DOWNTO reserved_0_TB40_PLL_IDX_0) <= init_reserved_0_TB40;
        dprioout(rcru_iselpd_PLL_IDX_2 DOWNTO rcru_iselpd_PLL_IDX_0) <= init_rcru_iselpd;
        dprioout(rcru_isel_PLL_IDX_2 DOWNTO rcru_isel_PLL_IDX_0) <= init_rcru_isel;
        dprioout(rcru_testdnen_PLL_IDX_0) <= init_rcru_testdnen;
        dprioout(rcru_testupen_PLL_IDX_0) <= init_rcru_testupen;
        dprioout(rcru_testen_PLL_IDX_0) <= init_rcru_testen;
        dprioout(rcru_lst_PLL_IDX_3 DOWNTO rcru_lst_PLL_IDX_0) <= init_rcru_lst;
        dprioout(rcru_rlbk_PLL_IDX_0) <= init_rcru_rlbk;
        
        -- PMA Per Channel RX Control Register 6 for Channel 0
        dprioout(rcru_rgla_isel_PLL_IDX_2 DOWNTO rcru_rgla_isel_PLL_IDX_0) <= init_rcru_rgla_isel;
        dprioout(rcru_pdof_test_PLL_IDX_2 DOWNTO rcru_pdof_test_PLL_IDX_0) <= init_rcru_pdof_test;
        dprioout(rcru_pdfl_PLL_IDX_0) <= init_rcru_pdfl;
        dprioout(rcru_sd_sel_PLL_IDX_0) <= init_rcru_sd_sel;
        dprioout(reserved_0_TB41_PLL_IDX_0) <= init_reserved_0_TB41;
        dprioout(rcru_ignore_phslck_PLL_IDX_0) <= init_rcru_ignore_phslck;
        dprioout(rcru_cmu_mode_PLL_IDX_0) <= init_rcru_cmu_mode;
        dprioout(rrx_cru_rst_PLL_IDX_0) <= init_rrx_cru_rst;
        dprioout(rrx_cru_pdb_PLL_IDX_0) <= init_rrx_cru_pdb;
        dprioout(rltr_PLL_IDX_0) <= init_rltr;
        dprioout(rltd_PLL_IDX_0) <= init_rltd;
        dprioout(rcp_mode_PLL_IDX_0) <= init_rcp_mode;
        
        -- PMA Per Channel RX Control Register 7 for Channel 0
        dprioout(rcru_pdof_270i_PLL_IDX_3 DOWNTO rcru_pdof_270i_PLL_IDX_0) <= init_rcru_pdof_270i;
        dprioout(rcru_pdof_180i_PLL_IDX_3 DOWNTO rcru_pdof_180i_PLL_IDX_0) <= init_rcru_pdof_180i;
        dprioout(rcru_pdof_90i_PLL_IDX_3 DOWNTO rcru_pdof_90i_PLL_IDX_0) <= init_rcru_pdof_90i;
        dprioout(rcru_pdof_0i_PLL_IDX_3 DOWNTO rcru_pdof_0i_PLL_IDX_0) <= init_rcru_pdof_0i;
        
        -- manual section --
        dprioout(PFD_CLK_SEL_PLL_IDX_3 DOWNTO PFD_CLK_SEL_PLL_IDX_0) <= init_pfd_clk_sel;
        
        -- ---------------------------------------------------------------------------
        -- Set DPRIO CRAM
        -- ---------------------------------------------------------------------------
        
        -- PMA Per Channel RX Control Register 4 for Channel 0
        cram_rcru_pdbwctrl <= init_rcru_pdbwctrl WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pdbwctrl;
        cram_rcru_pfdbwctrl <= init_rcru_pfdbwctrl WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pfdbwctrl;
        cram_rcru_crplctrl <= init_rcru_crplctrl WHEN (dpriodisable /= '0') ELSE dprioin_rcru_crplctrl;
        cram_rcru_ctl0 <= init_rcru_ctl0 WHEN (dpriodisable /= '0') ELSE dprioin_rcru_ctl0;
        cram_rcru_l <= init_rcru_l WHEN (dpriodisable /= '0') ELSE dprioin_rcru_l;
        cram_rcru_m <= dprioin_rcru_m WHEN (dpriodisable = '0' AND (alpha_tolower(pll_type) = "rx cdr" OR alpha_tolower(pll_type) = "high speed rx cdr" OR alpha_tolower(pll_type) = "cmu" OR alpha_tolower(pll_type) = "high speed cmu")) ELSE init_rcru_m;
        cram_rcru_m_sel <= dprioin_rcru_m_sel WHEN (dpriodisable = '0' AND (alpha_tolower(pll_type) = "rx cdr" OR alpha_tolower(pll_type) = "high speed rx cdr" OR alpha_tolower(pll_type) = "cmu" OR alpha_tolower(pll_type) = "high speed cmu")) ELSE init_rcru_m_sel;
        cram_rcru_div2 <= init_rcru_div2 WHEN (dpriodisable /= '0') ELSE dprioin_rcru_div2;
        
        -- PMA Per Channel RX Control Register 5 for Channel 0
        cram_reserved_0_TB40 <= init_reserved_0_TB40 WHEN (dpriodisable /= '0') ELSE dprioin_reserved_0_TB40;
        cram_rcru_iselpd <= init_rcru_iselpd WHEN (dpriodisable /= '0') ELSE dprioin_rcru_iselpd;
        cram_rcru_isel <= init_rcru_isel WHEN (dpriodisable /= '0') ELSE dprioin_rcru_isel;
        cram_rcru_testdnen <= init_rcru_testdnen WHEN (dpriodisable /= '0') ELSE dprioin_rcru_testdnen;
        cram_rcru_testupen <= init_rcru_testupen WHEN (dpriodisable /= '0') ELSE dprioin_rcru_testupen;
        cram_rcru_testen <= init_rcru_testen WHEN (dpriodisable /= '0') ELSE dprioin_rcru_testen;
        cram_rcru_lst <= init_rcru_lst WHEN (dpriodisable /= '0') ELSE dprioin_rcru_lst;
        cram_rcru_rlbk <= init_rcru_rlbk WHEN (dpriodisable /= '0') ELSE dprioin_rcru_rlbk;
        
        -- PMA Per Channel RX Control Register 6 for Channel 0
        cram_rcru_rgla_isel <= init_rcru_rgla_isel WHEN (dpriodisable /= '0') ELSE dprioin_rcru_rgla_isel;
        cram_rcru_pdof_test <= init_rcru_pdof_test WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pdof_test;
        cram_rcru_pdfl <= init_rcru_pdfl WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pdfl;
        cram_rcru_sd_sel <= init_rcru_sd_sel WHEN (dpriodisable /= '0') ELSE dprioin_rcru_sd_sel;
        cram_reserved_0_TB41 <= init_reserved_0_TB41 WHEN (dpriodisable /= '0') ELSE dprioin_reserved_0_TB41;
        cram_rcru_ignore_phslck <= init_rcru_ignore_phslck WHEN (dpriodisable /= '0') ELSE dprioin_rcru_ignore_phslck;
        cram_rcru_cmu_mode <= init_rcru_cmu_mode WHEN (dpriodisable /= '0') ELSE dprioin_rcru_cmu_mode;
        cram_rrx_cru_rst <= init_rrx_cru_rst WHEN (dpriodisable /= '0') ELSE dprioin_rrx_cru_rst;
        cram_rrx_cru_pdb <= init_rrx_cru_pdb WHEN (dpriodisable /= '0') ELSE dprioin_rrx_cru_pdb;
        cram_rltr <= init_rltr WHEN (dpriodisable /= '0') ELSE dprioin_rltr;
        cram_rltd <= init_rltd WHEN (dpriodisable /= '0') ELSE dprioin_rltd;
        cram_rcp_mode <= init_rcp_mode WHEN (dpriodisable /= '0') ELSE dprioin_rcp_mode;
        
        -- PMA Per Channel RX Control Register 7 for Channel 0
        cram_rcru_pdof_270i <= init_rcru_pdof_270i WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pdof_270i;
        cram_rcru_pdof_180i <= init_rcru_pdof_180i WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pdof_180i;
        cram_rcru_pdof_90i <= init_rcru_pdof_90i WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pdof_90i;
        cram_rcru_pdof_0i <= init_rcru_pdof_0i WHEN (dpriodisable /= '0') ELSE dprioin_rcru_pdof_0i;
  
   	    -- manual section --
        cram_pfd_clk_sel <= dprioin_pfd_clk_sel WHEN (dpriodisable = '0' AND (alpha_tolower(pll_type) = "rx cdr" OR alpha_tolower(pll_type) = "high speed rx cdr" OR alpha_tolower(pll_type) = "cmu" OR alpha_tolower(pll_type) = "high speed cmu")) ELSE init_pfd_clk_sel;
   		cram_vco_post_scale <= init_vco_post_scale;
   		--cram_rdynamic_sw <= ((alpha_tolower(pll_type) = "rx cdr") AND (alpha_tolower(protocol_hint) = "pcie2" OR enable_dynamic_divider = "true")) WHEN (dpriodisable /= '0') ELSE ((alpha_tolower(pll_type) = "rx cdr") AND dprioin_rdynamic_sw);
   	    
   		cram_rdynamic_sw <= '1' WHEN (dpriodisable /= '0' AND ((alpha_tolower(pll_type) = "rx cdr") AND (alpha_tolower(protocol_hint) = "pcie2" OR enable_dynamic_divider = "true"))) 
   								ELSE dprioin_rdynamic_sw when (alpha_tolower(pll_type) = "rx cdr") ELSE '0';
   		
  	PROCESS 
   	BEGIN
  		init_rcru_pdof_270i	<= "0000";
  		init_rcru_pdof_180i	<= "0000";
  		init_rcru_pdof_90i	<= "0000";
  		init_rcru_pdof_0i	<= "0000";
  		
  		init_rcru_m <= (mux_select((m = 1), "0000", mux_select((m = 2), "0001", mux_select((m = 4), "0010", mux_select((m = 5), "0011", mux_select((m = 8), "0100", mux_select((m = 10), "0101", mux_select((m = 16), "0110", mux_select((m = 20), "0111", mux_select((m = 25), "1000", mux_select((m = 32), "1001", mux_select((m = 40), "1010", mux_select((m = 50), "1011", "000X")))))))))))));
        init_rcru_m_sel <= (mux_select((n = 1), "00", mux_select((n = 2), "01", mux_select((n = 4), "10", mux_select((n = 8), "11", "00")))));
        init_pfd_clk_sel <= mux_select(((pfd_clk_select >= 0) AND (pfd_clk_select <= 9)), int2bin(pfd_clk_select, 4), "0000");
        init_vco_post_scale <= (mux_select((vco_post_scale = 0), "01", int2bin(vco_post_scale, 2)));
        init_pfd_fb_select <= (mux_select((alpha_tolower(pfd_fb_select) = ("pldclk")), "10", mux_select((alpha_tolower(pfd_fb_select) = ("iqtxrxclk")), "11", "00")));
     	WAIT;
   	END PROCESS;	
       -- new DPRIO model end --
  
   ext_fb_select <= '1' WHEN (init_pfd_fb_select = "11") ELSE '0';

   m_dprioin_modulus <= "00000001" WHEN (cram_rcru_m = "0000") ELSE
                        "00000010" WHEN (cram_rcru_m = "0001") ELSE
                        "00000100" WHEN (cram_rcru_m = "0010") ELSE
                        "00000101" WHEN (cram_rcru_m = "0011") ELSE
                        "00001000" WHEN (cram_rcru_m = "0100") ELSE
                        "00001010" WHEN (cram_rcru_m = "0101") ELSE
                        "00010000" WHEN (cram_rcru_m = "0110") ELSE
                        "00010100" WHEN (cram_rcru_m = "0111") ELSE
                        "00011001" WHEN (cram_rcru_m = "1000") ELSE
                        "00100000" WHEN (cram_rcru_m = "1001") ELSE
                        "00101000" WHEN (cram_rcru_m = "1010") ELSE
                        "00110010" WHEN (cram_rcru_m = "1011") ELSE
                        "00000001";
   
   n_dprioin_modulus <= "00000001" WHEN (cram_rcru_m_sel = "00") ELSE
                        "00000010" WHEN (cram_rcru_m_sel = "01") ELSE
                        "00000100" WHEN (cram_rcru_m_sel = "10") ELSE
                        "00000001";
   
   PROCESS 
       FUNCTION select_clock_period (                                 
           clk_select              : IN integer) RETURN time IS       
           VARIABLE period_int             :  INTEGER;                
       BEGIN                                                          
           CASE clk_select IS                                         
               WHEN 0 =>                                              
                           period_int := inclk0_input_period;               
               WHEN 1 =>                                              
                           period_int := inclk1_input_period;               
               WHEN 2 =>                                              
                           period_int := inclk2_input_period;               
               WHEN 3 =>                                              
                           period_int := inclk3_input_period;               
               WHEN 4 =>                                              
                           period_int := inclk4_input_period;               
               WHEN 5 =>                                              
                           period_int := inclk5_input_period;               
               WHEN 6 =>                                              
                           period_int := inclk6_input_period;               
               WHEN 7 =>                                              
                           period_int := inclk7_input_period;          
               WHEN 8 =>                                              
                           period_int := inclk8_input_period;          
               WHEN 9 =>                                              
                           period_int := inclk9_input_period;          
               WHEN OTHERS  =>                                        
                           period_int := inclk0_input_period;         
                                                                      
           END CASE;                                                  
           RETURN((period_int)* 1 ps);                             
       END select_clock_period;                                        
      
   BEGIN
      expected_clk_period <= (select_clock_period((pfd_clk_select)));
      clk_tolerance <= 0.1 * expected_clk_period;
      freq_viol_msg_sem <= '1';
--      locked_real <= '0';
      WAIT;
   END PROCESS;
   
   pll_clkin_pre_latency <= inclk_ipd(bin2int(cram_pfd_clk_sel)) WHEN (bin2int(cram_pfd_clk_sel) >= 0 AND bin2int(cram_pfd_clk_sel) <= 9) ELSE inclk_ipd(0);
   reset <= areset_ipd OR powerdown_ipd OR dprio_reset;
   pdb <= NOT(powerdown_ipd);
   dprioenable <= NOT(dpriodisable_ipd);
   cru_l_chn <= dprioin_ipd(15 DOWNTO 8);
   dprio_reset <= '1' WHEN ((dprioenable = '1') AND (dprioin_ipd(16) = '1' OR dprioin_ipd(17) = '1')) ELSE
                  '0';
   
   
   clock_latency : stratixiv_hssi_aux_clock_div
      GENERIC MAP (
         clk_divide_by  => 1,
         extra_latency  => sim_clkout_latency
      )
      PORT MAP (
         clk       => pll_clkin_pre_latency,
         enable_d  => '0',
         d         => "00000000",
         reset     => reset,
         clkout    => pll_clkin
      );
   PROCESS (pll_clkin)
   VARIABLE  txt : LINE;
   BEGIN
      IF (pll_clkin'EVENT AND pll_clkin = '1') THEN
         dprioen_reg <= dprioenable;
      END IF;
   END PROCESS;
   
   n_cntr : stratixiv_hssi_aux_clock_div
      GENERIC MAP (
         clk_divide_by  => n,
         extra_latency  => 0
      )
      PORT MAP (
         clk       => pll_clkin,
         enable_d  => dprioenable,
         d         => n_dprioin_modulus,
         reset     => reset,
         clkout    => pfd_refclk
      );

   PROCESS (pfd_refclk, reset, busy, change_in_clk_freq)
   BEGIN
      IF (reset'EVENT AND reset /= '1') THEN
         charge_pump <= '1';
         adjust_without_lol <= '0';
      ELSIF (busy'EVENT and busy = "00") THEN
         charge_pump <= '0';
         adjust_without_lol <= '0';
      ELSIF (change_in_clk_freq = TRUE) THEN
         charge_pump <= '1';
         IF (minor_clk_freq_change = TRUE) THEN
             adjust_without_lol <= '1';
         END IF;
      ELSIF (pfd_refclk'EVENT AND pfd_refclk = '0' AND (NOW > 0* 1 ps) AND (busy /= "11") AND (busy /= "01") ) THEN
--            charge_pump <= int2bit((last_pfd_refclk_edge /= last_fb_clk_edge));
           IF (last_fb_clk_edge /= last_pfd_refclk_edge) THEN
               charge_pump <= '1';
               IF (locked_real = '1') THEN
                   adjust_without_lol <= '1';
               END IF;
           END IF;
      END IF;
   END PROCESS;


   PROCESS (pll_clkin, reset)
   VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         first_pll_clkin_edge_detect <= '0';
      ELSIF (pll_clkin'EVENT AND pll_clkin = '1') THEN
         IF (first_pll_clkin_edge_detect = '0') THEN
            first_pll_clkin_edge_detect <= '1';
         ELSE
            real_clk_period <= NOW - last_pll_clkin_edge;
            IF ((real_clk_period < expected_clk_period - clk_tolerance) OR (real_clk_period > expected_clk_period + clk_tolerance)) THEN
               IF (freq_viol_msg_sem = '1') THEN
ASSERT FALSE REPORT  " CMU PLL input frequency mismatch between parameter-specified period and real clock period" SEVERITY WARNING; 
                  freq_viol_msg_sem <= '0';
               END IF;
            END IF;
            IF ((real_clk_period /= last_real_clk_period) AND (last_real_clk_period > 0 ps)) THEN
               change_in_clk_freq <= TRUE;
               IF ( (abs(real_clk_period - last_real_clk_period)) <= 2 ps) THEN
                   minor_clk_freq_change <= TRUE;
               END IF;
            ELSE
               change_in_clk_freq <= FALSE;
               minor_clk_freq_change <= FALSE;
            END IF;
            last_real_clk_period <= real_clk_period;
         END IF;
         last_pll_clkin_edge <= NOW;
      END IF;
   END PROCESS;
   
   PROCESS (pfd_refclk)
   VARIABLE  txt : LINE;
   BEGIN
      IF (pfd_refclk'EVENT AND pfd_refclk = '1') THEN
         last_pfd_refclk_edge <= NOW;
      END IF;
   END PROCESS;
   
   PROCESS (fbclk)
   VARIABLE  txt : LINE;
   BEGIN
      IF (fbclk'EVENT AND fbclk = '1') THEN
         last_fb_clk_edge <= NOW;
      END IF;
   END PROCESS;
   
   PROCESS (reset)
   VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         ASSERT FALSE REPORT  " CMU PLL is reset" SEVERITY NOTE; 
      END IF;
   END PROCESS;
   
   PROCESS (charge_pump, reset)
   VARIABLE  txt : LINE;
   BEGIN
      IF (reset'EVENT AND reset = '1') THEN
         display_msgs <= '0';
      ELSIF (charge_pump'EVENT) THEN
         IF (charge_pump = '1' and adjust_without_lol = '0') THEN
            IF (display_msgs = '0') THEN
               ASSERT FALSE REPORT  " CMU PLL lost lock due to reset or change in frequency of input clock" SEVERITY NOTE; 
               display_msgs <= '1';
            END IF;
         ELSE
            IF (display_msgs = '1') THEN
               ASSERT FALSE REPORT  " CMU PLL locked to incoming clock" SEVERITY NOTE; 
               display_msgs <= '0';
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   vco : stratixiv_hssi_aux_clock_mult
      GENERIC MAP (
         clk_multiply_by  => m,
         pfd_fb_select => pfd_fb_select
      )
      PORT MAP (
         clk       => pfd_refclk,
         fbclk     => fbclk,
         adjust    => charge_pump,
         adjust_without_lol => adjust_without_lol,
         reset     => reset,
         enable_m  => dprioenable,
         m         => m_dprioin_modulus,
         clkout    => clk_vco,
         busy      => busy
      );
   post_scale : FOR j IN 0 TO 3 GENERATE
      
      l_cntr : stratixiv_hssi_aux_clock_div
         GENERIC MAP (
            clk_divide_by  => 1,
            extra_latency  => 0
         )
         PORT MAP (
            clk       => clk_vco(j),
            enable_d  => '0',
            d         => "00000000",
            reset     => reset,
            clkout    => clk_post_scale(j)
         );
   END GENERATE;
   
   divide_by_M : stratixiv_hssi_aux_clock_div
      GENERIC MAP (
         clk_divide_by  => m,
         extra_latency  => 0
      )
      PORT MAP (
         clk       => clk_post_scale(0),
         reset     => reset,
         enable_d  => dprioen_reg,
         d         => m_dprioin_modulus,
         clkout    => divide_by_M_clkout
      );
   fbclk <= divide_by_M_clkout WHEN (alpha_tolower(pfd_fb_select) = ("internal")) ELSE
            pfdfbclk_ipd;
   
   pcie_sw_0 : stratixiv_hssi_aux_clock_div
      GENERIC MAP (
         clk_divide_by  => 2,
         extra_latency  => 0
      )
      PORT MAP (
         clk       => clk_post_scale(0),
         enable_d  => '0',
         d         => d_wire,
         reset     => reset,
         clkout    => pcie_div2_clk0
      );
   PROCESS (reset, pcie_div2_clk0)
   VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         pcie_div2_clk2 <= '0';
      ELSE
         pcie_div2_clk2 <= NOT(pcie_div2_clk0);
      END IF;
   END PROCESS;
      
   xhdl1 <= NOT(clk_post_scale(0));
      pcie_sw_1 : stratixiv_hssi_aux_clock_div
         GENERIC MAP (
            clk_divide_by  => 2,
            extra_latency  => 0
         )
         PORT MAP (
            clk       => xhdl1,
            enable_d  => '0',
            d         => d_wire,
            reset     => reset,
            clkout    => pcie_div2_clk1
         );
   PROCESS (reset, pcie_div2_clk1)
   VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         pcie_div2_clk3 <= '0';
      ELSE
         pcie_div2_clk3 <= NOT(pcie_div2_clk1);
      END IF;
   END PROCESS;
   
   PROCESS (busy, reset, adjust_without_lol)
   VARIABLE  txt : LINE;
   BEGIN
      IF (reset = '1') THEN
         locked_real <= '0';
      ELSIF (busy = "00" or adjust_without_lol = '1') THEN
         locked_real <= '1';
      ELSE
         locked_real <= '0';
      END IF;
   END PROCESS;
   
   pcie_clk(0) <= pcie_div2_clk0 WHEN (rateswitch_ipd = '0') ELSE
             clk_post_scale(0);
   pcie_clk(1) <= pcie_div2_clk1 WHEN (rateswitch_ipd = '0') ELSE
              clk_post_scale(1);
   pcie_clk(2) <= pcie_div2_clk2 WHEN (rateswitch_ipd = '0') ELSE
               clk_post_scale(2);
   pcie_clk(3)<= pcie_div2_clk3 WHEN (rateswitch_ipd = '0') ELSE
               clk_post_scale(3);

   ck0_pd	<= pcie_clk(0) WHEN (cram_rdynamic_sw = '1') ELSE clk_post_scale(0);
   ck90_pd  <= pcie_clk(1) WHEN (cram_rdynamic_sw = '1') ELSE clk_post_scale(1);
   ck180_pd <= pcie_clk(2) WHEN (cram_rdynamic_sw = '1') ELSE clk_post_scale(2);
   ck270_pd <= pcie_clk(3) WHEN (cram_rdynamic_sw = '1') ELSE clk_post_scale(3);

   datain_dly <= transport datain_ipd after 5 ps;
   
   PROCESS (ck0_pd, pdb)
   VARIABLE  txt : LINE;
   BEGIN
      IF (pdb = '0') THEN
         deven_int1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSE
         IF (ck0_pd'event and ck0_pd = '1') THEN
            deven_int1 <=  TRANSPORT datain_dly AFTER (PARAM_DELAY)*1 ps;
         ELSIF (ck0_pd'event and ck0_pd = '0') THEN
            deven_int2 <=  TRANSPORT deven_int1 AFTER (PARAM_DELAY)*1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   PROCESS (ck180_pd, pdb)
   VARIABLE  txt : LINE;
   BEGIN
      IF (pdb = '0') THEN
         dodd_int1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSE
         IF (ck180_pd'event and ck180_pd = '1') THEN
            dodd_int1 <=  TRANSPORT datain_dly AFTER (PARAM_DELAY)*1 ps;
         ELSIF (ck180_pd'event and ck180_pd = '0') THEN
            dodd_int2 <=  TRANSPORT dodd_int1 AFTER (PARAM_DELAY)*1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   PROCESS (ck90_pd, pdb)
   VARIABLE  txt : LINE;
   BEGIN
      IF (pdb = '0') THEN
         d90_int1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSE
         IF (ck90_pd'event and ck90_pd = '1') THEN
            d90_int1 <=  TRANSPORT datain_dly AFTER (PARAM_DELAY)*1 ps;
         ELSIF (ck90_pd'event and ck90_pd = '0') THEN
            d90_int2 <=  TRANSPORT d90_int1 AFTER (PARAM_DELAY)*1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   PROCESS (ck270_pd, pdb)
   VARIABLE  txt : LINE;
   BEGIN
      IF (pdb = '0') THEN
         d270_int1 <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
      ELSE
         IF (ck270_pd'event and ck270_pd = '1') THEN
            d270_int1 <=  TRANSPORT datain_dly AFTER (PARAM_DELAY)*1 ps;
         ELSIF (ck270_pd'event and ck270_pd = '0') THEN
            d270_int2 <=  TRANSPORT d270_int1 AFTER (PARAM_DELAY)*1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   PROCESS (ck90_pd, pdb)
   VARIABLE  txt : LINE;
   BEGIN
      IF (pdb = '0') THEN
         deven <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         dodd <=  TRANSPORT '0' AFTER (PARAM_DELAY)*1 ps;
         devenb <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
         doddb <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
      ELSIF (ck90_pd'EVENT AND ck90_pd = '1') THEN
         deven <=  TRANSPORT deven_int2 AFTER (PARAM_DELAY)*1 ps;
         dodd <=  TRANSPORT dodd_int2 AFTER (PARAM_DELAY)*1 ps;
         devenb <=  TRANSPORT NOT(deven_int2) AFTER (PARAM_DELAY)*1 ps;
         doddb <=  TRANSPORT NOT(dodd_int2) AFTER (PARAM_DELAY)*1 ps;
      END IF;
   END PROCESS;
   
   clk(0) <= ck0_pd AND (locked_xhdl0 OR ext_fb_select);
   clk(1) <= ck90_pd AND (locked_xhdl0 OR ext_fb_select);
   clk(2) <= ck180_pd AND (locked_xhdl0 OR ext_fb_select);
   clk(3) <= ck270_pd AND (locked_xhdl0 OR ext_fb_select);
   
   dataout(0) <= deven;
   dataout(1) <= dodd;
   
   locked_xhdl0 <= locked_real;

   -- Drive referenced outputs
   locked <= locked_xhdl0;
   pfdfbclkout <= fbclk;
   pfdrefclkout <= pfd_refclk;
   vcobypassout <= pll_clkin;
   freqlocked <= NOT(locktorefclk_ipd);
   
END trans;


-- ***********************************************************
-- This WYSIWYG atom header was automatically generated by the
-- Atmgen build tool. To change it, alter data stored in the 
-- corresponding WYS file(s) in the tools/atmgen subdirectory.
-- ***********************************************************

-- *** Section 1 -- Header ***

-- -----------------------------------------------------------
--
-- Module Name : stratixiv_hssi_tx_pma
--
-- Description : DEV_FAMILY_STRATIXIV stratixiv_hssi_tx_pma Verilog simulation model
--
-- -----------------------------------------------------------

-- *** End of Section 1 ***

-- *** Section 3 -- Module declaration ***


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
ENTITY stratixiv_hssi_tx_pma IS
   GENERIC (

          --  generic control parameters  --
       MsgOn                   : Boolean := DefGlitchMsgOn;
       XOn                     : Boolean := DefGlitchXOn;
       MsgOnChecks             : Boolean := DefMsgOnChecks;
       XOnChecks               : Boolean := DefXOnChecks;
       InstancePath            : String := "*";
       TimingChecksOn          : Boolean := True;
          --  tipd  :interconnect path delays --
      tipd_datain               :VitalDelayArrayType01(64 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_datainfull           :VitalDelayArrayType01(20 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_refclk0inpulse                : VitalDelayType01 := DefpropDelay01;
      tipd_forceelecidle                : VitalDelayType01 := DefpropDelay01;
      tipd_pclk                : VitalDelayArrayType01(5 - 1 DOWNTO 0) := (OTHERS => DefpropDelay01);
      tipd_fastrefclk4in                : VitalDelayArrayType01(2 - 1 DOWNTO 0) := (OTHERS => DefpropDelay01);
      tipd_refclk1in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_refclk0in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_refclk4inpulse                : VitalDelayType01 := DefpropDelay01;
      tipd_refclk4in                : VitalDelayArrayType01(2 - 1 DOWNTO 0) := (OTHERS => DefpropDelay01);
      tipd_dpriodisable                : VitalDelayType01 := DefpropDelay01;
      tipd_rxdetecten                : VitalDelayType01 := DefpropDelay01;
      tipd_refclk1inpulse                : VitalDelayType01 := DefpropDelay01;
      tipd_fastrefclk3in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_txpmareset                : VitalDelayType01 := DefpropDelay01;
      tipd_fastrefclk0in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_revserialfdbk                : VitalDelayType01 := DefpropDelay01;
      tipd_refclk3in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_powerdn                : VitalDelayType01 := DefpropDelay01;
      tipd_fastrefclk2in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_detectrxpowerdown                : VitalDelayType01 := DefpropDelay01;
      tipd_refclk3inpulse                : VitalDelayType01 := DefpropDelay01;
      tipd_refclk2inpulse                : VitalDelayType01 := DefpropDelay01;
      tipd_refclk2in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_rxdetectclk                : VitalDelayType01 := DefpropDelay01;
      tipd_fastrefclk1in               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_dprioin               :VitalDelayArrayType01(300 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
          --  tpd: Edge-Sensitive Paths --
          --  tpd: parallel and Full Connection Paths --
          --  tsetup and thold values : setup and hold times  --
          --  Pulse Width parameters  --
      
      -- *** End of Section 3 ***
      
      -- *** Section 4 -- Port size declarations ***
      
      -- Note: Variable port sizes dictated by parameters are not currently defined in
      -- the WYS file data. Busses are marked with the VARIABLE notation as a reminder.
      -- *** End of Section 4 ***
      
      -- *** Section 5 -- Port declarations ***
      
      lpm_type                        : STRING := "stratixiv_hssi_tx_pma";
      analog_power                    : STRING := "1.5V";
      channel_number                  : INTEGER := 9999;
      channel_type                    : STRING := "auto";
      clkin_select                    : INTEGER := 0; -- 9999; out of bound in loading
      clkmux_delay                    : STRING := "false";
      common_mode                     : STRING := "0.6V";
      dprio_config_mode               : STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
      enable_reverse_serial_loopback  : STRING := "false";
      logical_channel_address         : INTEGER := 0;
      logical_protocol_hint_0         : STRING := "basic";
      logical_protocol_hint_1         : STRING := "basic";
      logical_protocol_hint_2         : STRING := "basic";
      logical_protocol_hint_3         : STRING := "basic";
      low_speed_test_select           : INTEGER := 9999;
      physical_clkin0_mapping         : STRING := "x1";
      physical_clkin1_mapping         : STRING := "x4";
      physical_clkin2_mapping         : STRING := "xn_top";
      physical_clkin3_mapping         : STRING := "xn_bottom";
      physical_clkin4_mapping         : STRING := "hypertransport";
      preemp_pretap                   : INTEGER := 0;
      preemp_pretap_inv               : STRING := "false";
      preemp_tap_1                    : INTEGER := 0;
      preemp_tap_1_a                  : INTEGER := 0;
      preemp_tap_1_b                  : INTEGER := 0;
      preemp_tap_1_c                  : INTEGER := 0;
      preemp_tap_2                    : INTEGER := 0;
      preemp_tap_2_inv                : STRING := "false";
      protocol_hint                   : STRING := "basic";
      rx_detect                       : INTEGER := 9999;
      serialization_factor            : INTEGER := 8;
      slew_rate                       : STRING := "low";
      termination                     : STRING := "OCT 100 Ohms";
      use_external_termination        : STRING := "false";
      use_pclk                        : STRING := "false";
      use_pma_direct                  : STRING := "false";
      use_rx_detect                   : STRING := "false";
      use_ser_double_data_mode        : STRING := "false";
      vod_selection                   : INTEGER := 0;
      vod_selection_a                 : INTEGER := 0;
      vod_selection_b                 : INTEGER := 0;
      vod_selection_c                 : INTEGER := 0;
      vod_selection_d                 : INTEGER := 0
   );
   PORT (
      datain                          : IN STD_LOGIC_VECTOR(64 - 1 DOWNTO 0) := (others => '0');
      datainfull                      : IN STD_LOGIC_VECTOR(20 - 1 DOWNTO 0) := (others => '0');
      detectrxpowerdown               : IN STD_LOGIC := '0';
      dpriodisable                    : IN STD_LOGIC := '1';
      dprioin                         : IN STD_LOGIC_VECTOR(300 - 1 DOWNTO 0) := (others => '0');
      extra10gin                      : IN STD_LOGIC_VECTOR(11 - 1 DOWNTO 0) := (others => '0');
      fastrefclk0in                   : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      fastrefclk1in                   : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      fastrefclk2in                   : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      fastrefclk3in                   : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      fastrefclk4in                   : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (OTHERS => '0');
      forceelecidle                   : IN STD_LOGIC := '0';
      pclk                            : IN STD_LOGIC_VECTOR(5 - 1 DOWNTO 0) := (OTHERS => '0');
      powerdn                         : IN STD_LOGIC := '0';
      refclk0in                       : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      refclk0inpulse                  : IN STD_LOGIC := '0';
      refclk1in                       : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      refclk1inpulse                  : IN STD_LOGIC := '0';
      refclk2in                       : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      refclk2inpulse                  : IN STD_LOGIC := '0';
      refclk3in                       : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      refclk3inpulse                  : IN STD_LOGIC := '0';
      refclk4in                       : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (OTHERS => '0');
      refclk4inpulse                  : IN STD_LOGIC := '0';
      revserialfdbk                   : IN STD_LOGIC := '0';
      rxdetectclk                     : IN STD_LOGIC := '0';
      rxdetecten                      : IN STD_LOGIC := '0';
      txpmareset                      : IN STD_LOGIC := '0';
      clockout                        : OUT STD_LOGIC;
      dataout                         : OUT STD_LOGIC;
      dftout                          : OUT STD_LOGIC_VECTOR(6 - 1 DOWNTO 0);
      dprioout                        : OUT STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);
      rxdetectvalidout                : OUT STD_LOGIC;
      rxfoundout                      : OUT STD_LOGIC;
      seriallpbkout                   : OUT STD_LOGIC
   );
END stratixiv_hssi_tx_pma;

ARCHITECTURE trans OF stratixiv_hssi_tx_pma IS

  signal datain_ipd  :STD_LOGIC_VECTOR(64 - 1 DOWNTO 0);
  signal datainfull_ipd  :STD_LOGIC_VECTOR(20 - 1 DOWNTO 0);
  signal refclk0inpulse_ipd  :STD_LOGIC;
  signal forceelecidle_ipd  :STD_LOGIC;
  signal pclk_ipd  :STD_LOGIC_VECTOR(5 - 1 DOWNTO 0);
  signal fastrefclk4in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal refclk1in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal refclk0in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal refclk4inpulse_ipd  :STD_LOGIC;
  signal refclk4in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal dpriodisable_ipd  :STD_LOGIC;
  signal rxdetecten_ipd  :STD_LOGIC;
  signal refclk1inpulse_ipd  :STD_LOGIC;
  signal fastrefclk3in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal txpmareset_ipd  :STD_LOGIC;
  signal fastrefclk0in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal revserialfdbk_ipd  :STD_LOGIC;
  signal refclk3in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal powerdn_ipd  :STD_LOGIC;
  signal fastrefclk2in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal detectrxpowerdown_ipd  :STD_LOGIC;
  signal refclk3inpulse_ipd  :STD_LOGIC;
  signal refclk2inpulse_ipd  :STD_LOGIC;
  signal refclk2in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal rxdetectclk_ipd  :STD_LOGIC;
  signal fastrefclk1in_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal dprioin_ipd  :STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);
   COMPONENT stratixiv_hssi_pma_c_ser_10g
      GENERIC (
         PARAM_DELAY                     : INTEGER := 0
      );
      PORT (
         clk_divtx                       : OUT STD_LOGIC;
         clk_skew                        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         cpulse                          : IN STD_LOGIC;
         cpulseb                         : IN STD_LOGIC;
         data_in                         : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         hfclkn                          : IN STD_LOGIC;
         hfclkp                          : IN STD_LOGIC;
         lbvon                           : OUT STD_LOGIC;
         lbvop                           : OUT STD_LOGIC;
         lfclkn                          : IN STD_LOGIC;
         lfclkp                          : IN STD_LOGIC;
         pdb                             : IN STD_LOGIC;
         pre_em                          : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
         rst_n                           : IN STD_LOGIC;
         s_lpbk                          : IN STD_LOGIC;
         vccelxqyx                       : IN STD_LOGIC;
         vccetxqyx                       : IN STD_LOGIC;
         von                             : OUT STD_LOGIC;
         von_op1                         : OUT STD_LOGIC;
         vop                             : OUT STD_LOGIC;
         vop_op1                         : OUT STD_LOGIC;
         vssexqyx                        : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_ser
      GENERIC (
         PARAM_DELAY                     : INTEGER := 0
      );
      PORT (
         clk_divtx                       : OUT STD_LOGIC;
         cpulse                          : IN STD_LOGIC;
         data                            : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
         div2                            : IN STD_LOGIC;
         div5                            : IN STD_LOGIC;
         hfclkn                          : IN STD_LOGIC;
         hfclkp                          : IN STD_LOGIC;
         lbvon                           : OUT STD_LOGIC;
         lbvop                           : OUT STD_LOGIC;
         lfclkn                          : IN STD_LOGIC;
         lfclkp                          : IN STD_LOGIC;
         pclk_in                         : IN STD_LOGIC;
         pclksel                         : IN STD_LOGIC;
         pdb                             : IN STD_LOGIC;
         pre_em                          : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
         pre_em_2t                       : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         pre_em_pretap                   : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         pre_en_out                      : OUT STD_LOGIC;
         rst_n                           : IN STD_LOGIC;
         s_lpbk                          : IN STD_LOGIC;
         vccelxqyx                       : IN STD_LOGIC;
         vccetxqyx                       : IN STD_LOGIC;
         von                             : OUT STD_LOGIC;
         von_op1                         : OUT STD_LOGIC;
         von_op2                         : OUT STD_LOGIC;
         von_pre                         : OUT STD_LOGIC;
         vop                             : OUT STD_LOGIC;
         vop_op1                         : OUT STD_LOGIC;
         vop_op2                         : OUT STD_LOGIC;
         vop_pre                         : OUT STD_LOGIC;
         vssexqyx                        : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_tx
      PORT (
         atb0                            : INOUT STD_LOGIC;
         atb1                            : INOUT STD_LOGIC;
         bsmode                          : IN STD_LOGIC;
         bstxn_in                        : IN STD_LOGIC;
         bstxp_in                        : IN STD_LOGIC;
         cgb_vccelxqyx                   : IN STD_LOGIC;
         cgb_vssexqyx                    : IN STD_LOGIC;
         com_pass                        : OUT STD_LOGIC;
         detect_on                       : OUT STD_LOGIC;
         fixed_clk_out                   : OUT STD_LOGIC;
         ib50uc_rcvdt                    : INOUT STD_LOGIC;
         ib50uc_vcm                      : INOUT STD_LOGIC;
         ib50ut_vcm                      : INOUT STD_LOGIC;
         ib100uc                         : INOUT STD_LOGIC;
         lst                             : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         pdb                             : IN STD_LOGIC;
         probe_pass                      : OUT STD_LOGIC;
         r_dft_sel                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         r_dis_idlegate                  : IN STD_LOGIC;
         r_highv                         : IN STD_LOGIC;
         r_lowv                          : IN STD_LOGIC;
         r_rx_det                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         r_slew                          : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rlpbkn                          : IN STD_LOGIC;
         rlpbkn_em                       : IN STD_LOGIC;
         rlpbkp                          : IN STD_LOGIC;
         rlpbkp_em                       : IN STD_LOGIC;
         rpre_em_1t                      : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
         rpre_em_2t                      : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rpre_em_pt                      : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rsig_inv_2t                     : IN STD_LOGIC;
         rsig_inv_ptap                   : IN STD_LOGIC;
         rterm_sel                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rtx_rlpbk                       : IN STD_LOGIC;
         rtx_vtt                         : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rvod_sel                        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rx_det_clk                      : IN STD_LOGIC;
         rx_det_pdb                      : IN STD_LOGIC;
         rx_detect_valid                 : OUT STD_LOGIC;
         rx_found                        : OUT STD_LOGIC;
         sel_150r                        : OUT STD_LOGIC;
         tx50                            : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         tx_det_rx                       : IN STD_LOGIC;
         tx_dftout                       : OUT STD_LOGIC_VECTOR(6 DOWNTO 1);
         tx_elec_idl                     : IN STD_LOGIC;
         vccehtxqyx                      : IN STD_LOGIC;
         vccehxqyx                       : IN STD_LOGIC;
         vccesdh_la                      : IN STD_LOGIC;
         vccesdp_la                      : IN STD_LOGIC;
         vccetxqyx                       : IN STD_LOGIC;
         vin                             : IN STD_LOGIC;
         vin_po1                         : IN STD_LOGIC;
         vin_po2                         : IN STD_LOGIC;
         vin_pre                         : IN STD_LOGIC;
         vip                             : IN STD_LOGIC;
         vip_po1                         : IN STD_LOGIC;
         vip_po2                         : IN STD_LOGIC;
         vip_pre                         : IN STD_LOGIC;
         von                             : INOUT STD_LOGIC;
         vop                             : INOUT STD_LOGIC;
         vssexqyx                        : IN STD_LOGIC;
         rx_p                            : IN STD_LOGIC;
         rx_n                            : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_tx_clkmux_cmu
      GENERIC (
         DELAY                           : INTEGER := 1
      );
      PORT (
         cpulse                          : OUT STD_LOGIC;
         cpulse_ht                       : IN STD_LOGIC;
         cpulse_x1                       : IN STD_LOGIC;
         cpulse_x4                       : IN STD_LOGIC;
         cpulse_xn_b                     : IN STD_LOGIC;
         cpulse_xn_t                     : IN STD_LOGIC;
         delay_sel                       : IN STD_LOGIC;
         hfclk_n                         : OUT STD_LOGIC;
         hfclk_p                         : OUT STD_LOGIC;
         hfclkn_ht                       : IN STD_LOGIC;
         hfclkn_x1                       : IN STD_LOGIC;
         hfclkn_x4                       : IN STD_LOGIC;
         hfclkn_xn_b                     : IN STD_LOGIC;
         hfclkn_xn_t                     : IN STD_LOGIC;
         hfclkp_ht                       : IN STD_LOGIC;
         hfclkp_x1                       : IN STD_LOGIC;
         hfclkp_x4                       : IN STD_LOGIC;
         hfclkp_xn_b                     : IN STD_LOGIC;
         hfclkp_xn_t                     : IN STD_LOGIC;
         ht_sel                          : IN STD_LOGIC;
         lfclk_n                         : OUT STD_LOGIC;
         lfclk_p                         : OUT STD_LOGIC;
         lfclkn_ht                       : IN STD_LOGIC;
         lfclkn_x1                       : IN STD_LOGIC;
         lfclkn_x4                       : IN STD_LOGIC;
         lfclkn_xn_b                     : IN STD_LOGIC;
         lfclkn_xn_t                     : IN STD_LOGIC;
         lfclkp_ht                       : IN STD_LOGIC;
         lfclkp_x1                       : IN STD_LOGIC;
         lfclkp_x4                       : IN STD_LOGIC;
         lfclkp_xn_b                     : IN STD_LOGIC;
         lfclkp_xn_t                     : IN STD_LOGIC;
         pdb                             : IN STD_LOGIC;
         sel                             : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         vccelxqyx                       : IN STD_LOGIC;
         vssexqyx                        : IN STD_LOGIC
      );
   END COMPONENT;
   
   
   -- *** End of Section 5 ***
   
   -- *** Section 6 -- Parameter declarations and default values ***
   
   -- *** End of Section 6 ***
   
   -- *** Section 7 -- Port declarations with defaults, if any ***
   
   -- This section will always be empty for WYSIWYG atoms
   -- tri1 devclrn;		//sample
   
   -- *** End of Section 7 ***
   
   -- ---------------------------------------------------------------------------
   --  Model Implementation Begin                                               -
   -- ---------------------------------------------------------------------------
   
   -- DPRIO Index  --------------------------------------------------------------
   -- --- Name in Alphabetical order
   
   -- Initial CRAM converted from parameter -------------------------------------
   -- --- Name in Alphabetical order
   
   SIGNAL ht_sel_init            : STD_LOGIC;
   SIGNAL rcgb_delay_sel_init    : STD_LOGIC;
   SIGNAL rcgb_pdb_init          : STD_LOGIC;
   SIGNAL rcgb_x_en_init         : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rpclksel_init          : STD_LOGIC;
   SIGNAL rpmphs_1tap_init       : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL rpmphs_2tap_init       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rpmphs_ptap_init       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL r_rx_det_init          : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rser_div2_init         : STD_LOGIC;
   SIGNAL rser_div5_init         : STD_LOGIC;
   SIGNAL rsig_inv_2t_init       : STD_LOGIC;
   SIGNAL rsig_inv_ptap_init     : STD_LOGIC;
   SIGNAL rslew_init             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rtx_lst_init           : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rtx_rlpbk_init         : STD_LOGIC;
   SIGNAL rtx_term_sel_init      : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rtx_vtt_init           : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- CRAM value from DPRIO -----------------------------------------------------
   -- --- Name in Alphabetical order
   
   SIGNAL ht_sel_dprioin         : STD_LOGIC;
   SIGNAL rcgb_delay_sel_dprioin : STD_LOGIC;
   SIGNAL rcgb_pdb_dprioin       : STD_LOGIC;
   SIGNAL rcgb_x_en_dprioin      : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rpclksel_dprioin       : STD_LOGIC;
   SIGNAL rpmphs_1tap_dprioin    : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL rpmphs_2tap_dprioin    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rpmphs_ptap_dprioin    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL r_rx_det_dprioin       : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rser_div2_dprioin      : STD_LOGIC;
   SIGNAL rser_div5_dprioin      : STD_LOGIC;
   SIGNAL rsig_inv_2t_dprioin    : STD_LOGIC;
   SIGNAL rsig_inv_ptap_dprioin  : STD_LOGIC;
   SIGNAL rslew_dprioin          : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rtx_lst_dprioin        : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rtx_rlpbk_dprioin      : STD_LOGIC;
   SIGNAL rtx_term_sel_dprioin   : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rtx_vtt_dprioin        : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- CRAM to pass to Model -----------------------------------------------------
   -- --- Name in Alphabetical order
   
   SIGNAL ht_sel_cram            : STD_LOGIC;
   SIGNAL rcgb_delay_sel_cram    : STD_LOGIC;
   SIGNAL rcgb_pdb_cram          : STD_LOGIC;
   SIGNAL rcgb_x_en_cram         : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rpclksel_cram          : STD_LOGIC;
   SIGNAL rpmphs_1tap_cram       : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL rpmphs_2tap_cram       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rpmphs_ptap_cram       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL r_rx_det_cram          : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rser_div2_cram         : STD_LOGIC;
   SIGNAL rser_div5_cram         : STD_LOGIC;
   SIGNAL rsig_inv_2t_cram       : STD_LOGIC;
   SIGNAL rsig_inv_ptap_cram     : STD_LOGIC;
   SIGNAL rslew_cram             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rtx_lst_cram           : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rtx_rlpbk_cram         : STD_LOGIC;
   SIGNAL rtx_term_sel_cram      : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rtx_vtt_cram           : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   SIGNAL mdpriodisable          : STD_LOGIC;
   
   -- ---------------------------------------------------------------------------
   --  Model / Submodule Instantiations                                         -
   -- ---------------------------------------------------------------------------
   -- ***************************************************************************
   --  -- uses only *_cram                                                      *
   --  -- should NOT use parameters nor *_dprioin                               *
   -- ***************************************************************************
   
   --  common supply wires
   SIGNAL vccetxqyx              : STD_LOGIC;
   SIGNAL vccelxqyx              : STD_LOGIC;
   SIGNAL vssexqyx               : STD_LOGIC;
   
   -- for the tx_clkmux instance
   -- input wires
   SIGNAL xtxclkmux_cpulse_ht    : STD_LOGIC;
   SIGNAL xtxclkmux_cpulse_x1    : STD_LOGIC;
   SIGNAL xtxclkmux_cpulse_x4    : STD_LOGIC;
   SIGNAL xtxclkmux_cpulse_x8_b  : STD_LOGIC;
   SIGNAL xtxclkmux_cpulse_x8_t  : STD_LOGIC;
   
   SIGNAL xtxclkmux_hfclkn_ht    : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkn_x1    : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkn_x4    : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkn_x8_b  : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkn_x8_t  : STD_LOGIC;
   
   SIGNAL xtxclkmux_hfclkp_ht    : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkp_x1    : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkp_x4    : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkp_x8_b  : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkp_x8_t  : STD_LOGIC;
   
   SIGNAL xtxclkmux_ht_sel       : STD_LOGIC;
   
   SIGNAL xtxclkmux_lfclkn_ht    : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkn_x1    : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkn_x4    : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkn_x8_b  : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkn_x8_t  : STD_LOGIC;
   
   SIGNAL xtxclkmux_lfclkp_ht    : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkp_x1    : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkp_x4    : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkp_x8_b  : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkp_x8_t  : STD_LOGIC;
   
   SIGNAL xtxclkmux_pdb          : STD_LOGIC;
   SIGNAL xtxclkmux_rdelay_sel   : STD_LOGIC;
   SIGNAL xtxclkmux_rsel         : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- output wires
   SIGNAL xtxclkmux_cpulse       : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkn       : STD_LOGIC;
   SIGNAL xtxclkmux_hfclkp       : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkn       : STD_LOGIC;
   SIGNAL xtxclkmux_lfclkp       : STD_LOGIC;
     
   -- for the serializer instance
   -- input wires
   SIGNAL xser_cpulse            : STD_LOGIC;
   SIGNAL xser_data              : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL xser_data_dprio        : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL xser_hfclkn            : STD_LOGIC;
   SIGNAL xser_hfclkp            : STD_LOGIC;
   SIGNAL xser_lfclkn            : STD_LOGIC;
   SIGNAL xser_lfclkp            : STD_LOGIC;
   SIGNAL xser_pclk              : STD_LOGIC;
   SIGNAL xser_pdb               : STD_LOGIC;
   SIGNAL xser_rpclksel          : STD_LOGIC;
   SIGNAL xser_rpre_em           : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL xser_rpre_em_2t        : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xser_rpre_em_pretap    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xser_rdiv2             : STD_LOGIC;
   SIGNAL xser_rdiv5             : STD_LOGIC;
   SIGNAL xser_rs_lpbk           : STD_LOGIC;
   SIGNAL xser_rst_n             : STD_LOGIC;
   SIGNAL vccetx                 : STD_LOGIC;
   
   -- 10g input wires
   SIGNAL xser_10g_clk_skew      : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL xser_10g_cpulse        : STD_LOGIC;
   SIGNAL xser_10g_cpulseb       : STD_LOGIC;
   SIGNAL xser_10g_data_in       : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL xser_10g_hfclkn        : STD_LOGIC;
   SIGNAL xser_10g_hfclkp        : STD_LOGIC;
   SIGNAL xser_10g_lfclkn        : STD_LOGIC;
   SIGNAL xser_10g_lfclkp        : STD_LOGIC;
   SIGNAL xser_10g_pdb           : STD_LOGIC;
   SIGNAL xser_10g_rpre_em       : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL xser_10g_rst_n         : STD_LOGIC;
   SIGNAL xser_10g_rs_lpbk       : STD_LOGIC;
   
   -- output wires
   SIGNAL xser_clk_divtx         : STD_LOGIC;
   SIGNAL xser_lbvop             : STD_LOGIC;
   SIGNAL xser_lbvon             : STD_LOGIC;
   SIGNAL xser_pre_en_out        : STD_LOGIC;
   SIGNAL xser_von               : STD_LOGIC;
   SIGNAL xser_von_op1           : STD_LOGIC;
   SIGNAL xser_von_op2           : STD_LOGIC;
   SIGNAL xser_von_pre           : STD_LOGIC;
   SIGNAL xser_vop               : STD_LOGIC;
   SIGNAL xser_vop_op1           : STD_LOGIC;
   SIGNAL xser_vop_op2           : STD_LOGIC;
   SIGNAL xser_vop_pre           : STD_LOGIC;
   
   -- 10g output wires
   SIGNAL xser_10g_clk_divtx     : STD_LOGIC;
   SIGNAL xser_10g_lbvon         : STD_LOGIC;
   SIGNAL xser_10g_von           : STD_LOGIC;
   SIGNAL xser_10g_von_op1       : STD_LOGIC;
   SIGNAL xser_10g_lbvop         : STD_LOGIC;
   SIGNAL xser_10g_vop           : STD_LOGIC;
   SIGNAL xser_10g_vop_op1       : STD_LOGIC;
   
   SIGNAL xser_10g_pre_em        : STD_LOGIC;
   
   -- serializer outputs
   
   -- for the TX driver instance
   -- input wires
   SIGNAL xtx_bsmode             : STD_LOGIC;
   SIGNAL xtx_bstxn_in           : STD_LOGIC;
   SIGNAL xtx_bstxp_in           : STD_LOGIC;
   SIGNAL xtx_cgb_vccelxqyx      : STD_LOGIC;
   SIGNAL xtx_cgb_vssexqyx       : STD_LOGIC;
   SIGNAL xtx_rlpbkp             : STD_LOGIC;
   SIGNAL xtx_rlpbkn             : STD_LOGIC;
   SIGNAL xtx_rlpbkn_em          : STD_LOGIC;
   SIGNAL xtx_rlpbkp_em          : STD_LOGIC;
   SIGNAL xtx_r_dft_sel          : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL xtx_r_dis_idlegate     : STD_LOGIC;
   SIGNAL xtx_r_highv            : STD_LOGIC;
   SIGNAL xtx_r_lowv             : STD_LOGIC;
   SIGNAL xtx_r_rx_det           : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL xtx_rpre_em_1t         : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL xtx_rpre_em_2t         : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xtx_rpre_em_pt         : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xtx_rsig_inv_2t        : STD_LOGIC;
   SIGNAL xtx_rsig_inv_ptap      : STD_LOGIC;
   SIGNAL xtx_rslew              : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL xtx_rlst               : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xtx_rtx_rlpbk          : STD_LOGIC;
   SIGNAL xtx_rterm_sel          : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL xtx_rtx_vtt            : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL xtx_rvod_sel           : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL xtx_rx_det_clk         : STD_LOGIC;
   SIGNAL xtx_rx_det_pdb         : STD_LOGIC;
   SIGNAL xtx_rx_n               : STD_LOGIC;
   SIGNAL xtx_rx_p               : STD_LOGIC;
   SIGNAL xtx_tx_det_rx          : STD_LOGIC;
   SIGNAL xtx_tx_elec_idl        : STD_LOGIC;
   SIGNAL xtx_pdb                : STD_LOGIC;
   SIGNAL xtx_tx50               : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL xtx_vin                : STD_LOGIC;
   SIGNAL xtx_vin_op1            : STD_LOGIC;
   SIGNAL xtx_vin_op2            : STD_LOGIC;
   SIGNAL xtx_vin_pre            : STD_LOGIC;
   SIGNAL xtx_vip                : STD_LOGIC;
   SIGNAL xtx_vip_op1            : STD_LOGIC;
   SIGNAL xtx_vip_op2            : STD_LOGIC;
   SIGNAL xtx_vip_pre            : STD_LOGIC;
   SIGNAL vccehtxqyx             : STD_LOGIC;
   SIGNAL vccehxqyx              : STD_LOGIC;
   
   -- inout wires
   SIGNAL xtx_atb0               : STD_LOGIC;
   SIGNAL xtx_atb1               : STD_LOGIC;
   SIGNAL xtx_ib50uc_vcm         : STD_LOGIC;
   SIGNAL xtx_ib50ut_vcm         : STD_LOGIC;
   SIGNAL xtx_ib100uc            : STD_LOGIC;
   SIGNAL xtx_ib50uc_rcvdt       : STD_LOGIC;
   SIGNAL xtx_von                : STD_LOGIC;
   SIGNAL xtx_vop                : STD_LOGIC;
   
   -- output wires
   SIGNAL xtx_com_pass           : STD_LOGIC;
   SIGNAL xtx_detect_on          : STD_LOGIC;
   SIGNAL xtx_fixed_clk          : STD_LOGIC;
   SIGNAL xtx_probe_pass         : STD_LOGIC;
   SIGNAL xtx_rx_detect_valid    : STD_LOGIC;
   SIGNAL xtx_rx_found           : STD_LOGIC;
   SIGNAL xtx_sel_150r           : STD_LOGIC;
   SIGNAL xtx_tx_dftout          : STD_LOGIC_VECTOR(6 DOWNTO 1);
   
   --temporarily generate rxdetectclk - fixed clock of 125 Mhz
   SIGNAL rx_det_clk_reg         : STD_LOGIC;
   -- end
   
   -- workaround incorrect connections of forceeleidle
   -- delay 25 * 4* 1 ps = 100 ns   
   SIGNAL forceelecidle_in      : STD_LOGIC;
   -- end
   
   -- the actual instance
   
   SIGNAL xtx_ib50uc             : STD_LOGIC;
   SIGNAL xtx_ib50ut             : STD_LOGIC;
   
   -- new dprio model --
   -- Table28: PMA Per Channel TX Control Register 1 for Channel 0
   constant rpowdnt_TXPMA_IDX_0	: integer := 0;
   constant rvod_seld_TXPMA_IDX_0	: integer := 1;
   constant rvod_seld_TXPMA_IDX_1	: integer := 2;
   constant rvod_seld_TXPMA_IDX_2	: integer := 3;
   constant rvod_selc_TXPMA_IDX_0	: integer := 4;
   constant rvod_selc_TXPMA_IDX_1	: integer := 5;
   constant rvod_selc_TXPMA_IDX_2	: integer := 6;
   constant rvod_selb_TXPMA_IDX_0	: integer := 7;
   constant rvod_selb_TXPMA_IDX_1	: integer := 8;
   constant rvod_selb_TXPMA_IDX_2	: integer := 9;
   constant rvod_sela_TXPMA_IDX_0	: integer := 10;
   constant rvod_sela_TXPMA_IDX_1	: integer := 11;
   constant rvod_sela_TXPMA_IDX_2	: integer := 12;
   constant rvod_sel_non_pcie_TXPMA_IDX_0	: integer := 13;
   constant rvod_sel_non_pcie_TXPMA_IDX_1	: integer := 14;
   constant rvod_sel_non_pcie_TXPMA_IDX_2	: integer := 15;
   
   -- Table29: PMA Per Channel TX Control Register 2 for Channel 0
   constant reserved_0_TB29_TXPMA_IDX_0	: integer := 16;
   constant rpre_em_1t_b_TXPMA_IDX_0	: integer := 17;
   constant rpre_em_1t_b_TXPMA_IDX_1	: integer := 18;
   constant rpre_em_1t_b_TXPMA_IDX_2	: integer := 19;
   constant rpre_em_1t_b_TXPMA_IDX_3	: integer := 20;
   constant rpre_em_1t_b_TXPMA_IDX_4	: integer := 21;
   constant rpre_em_1t_a_TXPMA_IDX_0	: integer := 22;
   constant rpre_em_1t_a_TXPMA_IDX_1	: integer := 23;
   constant rpre_em_1t_a_TXPMA_IDX_2	: integer := 24;
   constant rpre_em_1t_a_TXPMA_IDX_3	: integer := 25;
   constant rpre_em_1t_a_TXPMA_IDX_4	: integer := 26;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_0	: integer := 27;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_1	: integer := 28;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_2	: integer := 29;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_3	: integer := 30;
   constant rpre_em_1t_no_pcie_TXPMA_IDX_4	: integer := 31;
   
   -- Table30: PMA Per Channel TX Control Register 3 for Channel 0
   constant rpre_em_pt_TXPMA_IDX_0	: integer := 32;
   constant rpre_em_pt_TXPMA_IDX_1	: integer := 33;
   constant rpre_em_pt_TXPMA_IDX_2	: integer := 34;
   constant rpre_em_pt_TXPMA_IDX_3	: integer := 35;
   constant rpre_em_2t_TXPMA_IDX_0	: integer := 36;
   constant rpre_em_2t_TXPMA_IDX_1	: integer := 37;
   constant rpre_em_2t_TXPMA_IDX_2	: integer := 38;
   constant rpre_em_2t_TXPMA_IDX_3	: integer := 39;
   constant rpre_em_1t_c_TXPMA_IDX_0	: integer := 40;
   constant rpre_em_1t_c_TXPMA_IDX_1	: integer := 41;
   constant rpre_em_1t_c_TXPMA_IDX_2	: integer := 42;
   constant rpre_em_1t_c_TXPMA_IDX_3	: integer := 43;
   constant rpre_em_1t_c_TXPMA_IDX_4	: integer := 44;
   constant reserved_0_TB30_TXPMA_IDX_0	: integer := 45;
   constant reserved_0_TB30_TXPMA_IDX_1	: integer := 46;
   constant reserved_0_TB30_TXPMA_IDX_2	: integer := 47;
   
   -- Table31: PMA Per Channel TX Control Register 4 for Channel 0
   constant rlowv_TXPMA_IDX_0	: integer := 48;
   constant rrx_det_TXPMA_IDX_0	: integer := 49;
   constant rrx_det_TXPMA_IDX_1	: integer := 50;
   constant rsig_inv_2t_TXPMA_IDX_0	: integer := 51;
   constant rsig_inv_ptap_TXPMA_IDX_0	: integer := 52;
   constant rslew_TXPMA_IDX_0	: integer := 53;
   constant rslew_TXPMA_IDX_1	: integer := 54;
   constant rtx_lst_TXPMA_IDX_0	: integer := 55;
   constant rtx_lst_TXPMA_IDX_1	: integer := 56;
   constant rtx_lst_TXPMA_IDX_2	: integer := 57;
   constant rtx_lst_TXPMA_IDX_3	: integer := 58;
   constant rtx_vtt_TXPMA_IDX_0	: integer := 59;
   constant rtx_vtt_TXPMA_IDX_1	: integer := 60;
   constant rtx_term_sel_TXPMA_IDX_0	: integer := 61;
   constant rtx_term_sel_TXPMA_IDX_1	: integer := 62;
   constant rtx_term_sel_TXPMA_IDX_2	: integer := 63;
   
   -- Table32: PMA Per Channel TX Control Register 5 for Channel 0
   constant reserved_1_TB32_TXPMA_IDX_0	: integer := 64;
   constant reserved_1_TB32_TXPMA_IDX_1	: integer := 65;
   constant reserved_1_TB32_TXPMA_IDX_2	: integer := 66;
   constant reserved_1_TB32_TXPMA_IDX_3	: integer := 67;
   constant reserved_1_TB32_TXPMA_IDX_4	: integer := 68;
   constant reserved_1_TB32_TXPMA_IDX_5	: integer := 69;
   constant reserved_1_TB32_TXPMA_IDX_6	: integer := 70;
   constant reserved_1_TB32_TXPMA_IDX_7	: integer := 71;
   constant reserved_1_TB32_TXPMA_IDX_8	: integer := 72;
   constant reserved_1_TB32_TXPMA_IDX_9	: integer := 73;
   constant reserved_1_TB32_TXPMA_IDX_10	: integer := 74;
   constant rtx_ob_pdb_TXPMA_IDX_0	: integer := 75;
   constant reserved_0_TB32_TXPMA_IDX_0	: integer := 76;
   constant r_dft_sel_TXPMA_IDX_0	: integer := 77;
   constant r_dft_sel_TXPMA_IDX_1	: integer := 78;
   constant r_dft_sel_TXPMA_IDX_2	: integer := 79;
   
   -- Table33: PMA Per Channel TX Control Register 6 for Channel 0
   constant reserved_0_TB33_TXPMA_IDX_0	: integer := 80;
   constant reserved_0_TB33_TXPMA_IDX_1	: integer := 81;
   constant reserved_0_TB33_TXPMA_IDX_2	: integer := 82;
   constant reserved_0_TB33_TXPMA_IDX_3	: integer := 83;
   constant rtx_cgb_pdb_TXPMA_IDX_0	: integer := 84;
   constant rpclksel_TXPMA_IDX_0	: integer := 85;
   constant rdynamic_sw_TXPMA_IDX_0	: integer := 86;
   constant rs_lpbk_TXPMA_IDX_0	: integer := 87;
   constant rcgb_delay_sel_TXPMA_IDX_0	: integer := 88;
   constant rpmadwidth_tx_TXPMA_IDX_0	: integer := 89;
   constant rpma_doublewidth_tx_TXPMA_IDX_0	: integer := 90;
   constant rcgb_m_sel_TXPMA_IDX_0	: integer := 91;
   constant rcgb_m_sel_TXPMA_IDX_1	: integer := 92;
   constant rcgb_cmu_sel_TXPMA_IDX_0	: integer := 93;
   constant rcgb_x_en_TXPMA_IDX_0	: integer := 94;
   constant rcgb_x_en_TXPMA_IDX_1	: integer := 95;
   
   -- Table34: PMA Per Channel TX Control Register 7 for Channel 0
   constant reserved_1_TB34_TXPMA_IDX_0	: integer := 96;
   constant reserved_1_TB34_TXPMA_IDX_1	: integer := 97;
   constant reserved_1_TB34_TXPMA_IDX_2	: integer := 98;
   constant rpcs_sd_sel_TXPMA_IDX_0	: integer := 99;
   constant rrx_refclk_TXPMA_IDX_0	: integer := 100;
   constant rimpctrl_TXPMA_IDX_0	: integer := 101;
   constant reserved_0_TB34_TXPMA_IDX_0	: integer := 102;
   constant reserved_0_TB34_TXPMA_IDX_1	: integer := 103;
   constant reserved_0_TB34_TXPMA_IDX_2	: integer := 104;
   constant reserved_0_TB34_TXPMA_IDX_3	: integer := 105;
   constant rrevlb_sw_TXPMA_IDX_0	: integer := 106;
   constant rvcobypass_TXPMA_IDX_0	: integer := 107;
   constant rrefclk_sel_TXPMA_IDX_0	: integer := 108;
   constant rrefclk_sel_TXPMA_IDX_1	: integer := 109;
   constant riqclk_sel_TXPMA_IDX_0	: integer := 110;
   constant riqclk_sel_TXPMA_IDX_1	: integer := 111;
   
   -- Table35: PMA Per Channel TX Control Register 8 for Channel 0
   constant rpma_reserved_0_TB35_TXPMA_IDX_0	: integer := 112;
   constant rpma_reserved_0_TB35_TXPMA_IDX_1	: integer := 113;
   constant rpma_reserved_0_TB35_TXPMA_IDX_2	: integer := 114;
   constant rpma_reserved_0_TB35_TXPMA_IDX_3	: integer := 115;
   constant rpma_reserved_0_TB35_TXPMA_IDX_4	: integer := 116;
   constant rpma_reserved_0_TB35_TXPMA_IDX_5	: integer := 117;
   constant rpma_reserved_0_TB35_TXPMA_IDX_6	: integer := 118;
   constant rpma_reserved_0_TB35_TXPMA_IDX_7	: integer := 119;
   constant rpma_reserved_0_TB35_TXPMA_IDX_8	: integer := 120;
   constant rpma_reserved_0_TB35_TXPMA_IDX_9	: integer := 121;
   constant rpma_reserved_0_TB35_TXPMA_IDX_10	: integer := 122;
   constant rpma_reserved_0_TB35_TXPMA_IDX_11	: integer := 123;
   constant rpma_reserved_0_TB35_TXPMA_IDX_12	: integer := 124;
   constant rpma_reserved_0_TB35_TXPMA_IDX_13	: integer := 125;
   constant rpma_reserved_0_TB35_TXPMA_IDX_14	: integer := 126;
   constant rpma_reserved_0_TB35_TXPMA_IDX_15	: integer := 127;
  
   -- Extra
   constant ht_sel_TX_PMA_IDX  : integer := 128;
  
   constant DPRIO_CHANNEL_INTERFACE_BIT : INTEGER := 4;
 
   -- ---------------------------------------------------------------------------
   -- DPRIO input CRAM  
   -- ---------------------------------------------------------------------------
   -- PMA Per Channel TX Control Register 1 for Channel 0
   SIGNAL dprioin_rpowdnt	: STD_LOGIC;
   SIGNAL dprioin_rvod_seld	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rvod_selc	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rvod_selb	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rvod_sela	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rvod_sel_non_pcie	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 2 for Channel 0
   SIGNAL dprioin_reserved_0_TB29	: STD_LOGIC;
   SIGNAL dprioin_rpre_em_1t_b	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL dprioin_rpre_em_1t_a	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL dprioin_rpre_em_1t_no_pcie	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 3 for Channel 0
   SIGNAL dprioin_rpre_em_pt	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rpre_em_2t	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rpre_em_1t_c	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL dprioin_reserved_0_TB30	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 4 for Channel 0
   SIGNAL dprioin_rlowv	: STD_LOGIC;
   SIGNAL dprioin_rrx_det	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rsig_inv_2t	: STD_LOGIC;
   SIGNAL dprioin_rsig_inv_ptap	: STD_LOGIC;
   SIGNAL dprioin_rslew	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rtx_lst	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rtx_vtt	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rtx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 5 for Channel 0
   SIGNAL dprioin_reserved_1_TB32	: STD_LOGIC_VECTOR(10 DOWNTO 0);
   SIGNAL dprioin_rtx_ob_pdb	: STD_LOGIC;
   SIGNAL dprioin_reserved_0_TB32	: STD_LOGIC;
   SIGNAL dprioin_r_dft_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 6 for Channel 0
   SIGNAL dprioin_reserved_0_TB33	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rtx_cgb_pdb	: STD_LOGIC;
   SIGNAL dprioin_rpclksel	: STD_LOGIC;
   SIGNAL dprioin_rdynamic_sw	: STD_LOGIC;
   SIGNAL dprioin_rs_lpbk	: STD_LOGIC;
   SIGNAL dprioin_rcgb_delay_sel	: STD_LOGIC;
   SIGNAL dprioin_rpmadwidth_tx	: STD_LOGIC;
   SIGNAL dprioin_rpma_doublewidth_tx	: STD_LOGIC;
   SIGNAL dprioin_rcgb_m_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rcgb_cmu_sel	: STD_LOGIC;
   SIGNAL dprioin_rcgb_x_en	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 7 for Channel 0
   SIGNAL dprioin_reserved_1_TB34	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rpcs_sd_sel	: STD_LOGIC;
   SIGNAL dprioin_rrx_refclk	: STD_LOGIC;
   SIGNAL dprioin_rimpctrl	: STD_LOGIC;
   SIGNAL dprioin_reserved_0_TB34	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rrevlb_sw	: STD_LOGIC;
   SIGNAL dprioin_rvcobypass	: STD_LOGIC;
   SIGNAL dprioin_rrefclk_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_riqclk_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 8 for Channel 0
   SIGNAL dprioin_rpma_reserved_0_TB35	: STD_LOGIC_VECTOR(15 DOWNTO 0);
   
   -- Extra
   SIGNAL dprioin_ht_sel : STD_LOGIC;
   
   -- SW logical index ---------------------------------------------------------- 
   constant CLKIN_SELECT_TXPMA_IDX_0	: integer := 200;
   constant CLKIN_SELECT_TXPMA_IDX_1	: integer := 201;
   constant CLKIN_SELECT_TXPMA_IDX_2	: integer := 202;
   
   -- ---------------------------------------------------------------------------
   -- Initial CRAM  
   -- ---------------------------------------------------------------------------
   -- PMA Per Channel TX Control Register 1 for Channel 0
   SIGNAL init_rpowdnt	: STD_LOGIC;
   SIGNAL init_rvod_seld	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rvod_selc	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rvod_selb	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rvod_sela	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rvod_sel_non_pcie	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 2 for Channel 0
   SIGNAL init_reserved_0_TB29	: STD_LOGIC;
   SIGNAL init_rpre_em_1t_b	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL init_rpre_em_1t_a	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL init_rpre_em_1t_no_pcie	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 3 for Channel 0
   SIGNAL init_rpre_em_pt	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rpre_em_2t	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rpre_em_1t_c	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL init_reserved_0_TB30	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 4 for Channel 0
   SIGNAL init_rlowv	: STD_LOGIC;
   SIGNAL init_rrx_det	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rsig_inv_2t	: STD_LOGIC;
   SIGNAL init_rsig_inv_ptap	: STD_LOGIC;
   SIGNAL init_rslew	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rtx_lst	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rtx_vtt	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rtx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 5 for Channel 0
   SIGNAL init_reserved_1_TB32	: STD_LOGIC_VECTOR(10 DOWNTO 0);
   SIGNAL init_rtx_ob_pdb	: STD_LOGIC;
   SIGNAL init_reserved_0_TB32	: STD_LOGIC;
   SIGNAL init_r_dft_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 6 for Channel 0
   SIGNAL init_reserved_0_TB33	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rtx_cgb_pdb	: STD_LOGIC;
   SIGNAL init_rpclksel	: STD_LOGIC;
   SIGNAL init_rdynamic_sw	: STD_LOGIC;
   SIGNAL init_rs_lpbk	: STD_LOGIC;
   SIGNAL init_rcgb_delay_sel	: STD_LOGIC;
   SIGNAL init_rpmadwidth_tx	: STD_LOGIC;
   SIGNAL init_rpma_doublewidth_tx	: STD_LOGIC;
   SIGNAL init_rcgb_m_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rcgb_cmu_sel	: STD_LOGIC;
   SIGNAL init_rcgb_x_en	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 7 for Channel 0
   SIGNAL init_reserved_1_TB34	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rpcs_sd_sel	: STD_LOGIC;
   SIGNAL init_rrx_refclk	: STD_LOGIC;
   SIGNAL init_rimpctrl	: STD_LOGIC;
   SIGNAL init_reserved_0_TB34	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rrevlb_sw	: STD_LOGIC;
   SIGNAL init_rvcobypass	: STD_LOGIC;
   SIGNAL init_rrefclk_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_riqclk_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 8 for Channel 0
   SIGNAL init_rpma_reserved_0_TB35	: STD_LOGIC_VECTOR(15 DOWNTO 0);
   
   -- Extra
   SIGNAL init_ht_sel : STD_LOGIC;
   
   -- ---------------------------------------------------------------------------
   -- CRAM  
   -- ---------------------------------------------------------------------------
   -- PMA Per Channel TX Control Register 1 for Channel 0
   SIGNAL cram_rpowdnt	: STD_LOGIC;
   SIGNAL cram_rvod_seld	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rvod_selc	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rvod_selb	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rvod_sela	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rvod_sel_non_pcie	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 2 for Channel 0
   SIGNAL cram_reserved_0_TB29	: STD_LOGIC;
   SIGNAL cram_rpre_em_1t_b	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL cram_rpre_em_1t_a	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL cram_rpre_em_1t_no_pcie	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 3 for Channel 0
   SIGNAL cram_rpre_em_pt	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rpre_em_2t	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rpre_em_1t_c	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL cram_reserved_0_TB30	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 4 for Channel 0
   SIGNAL cram_rlowv	: STD_LOGIC;
   SIGNAL cram_rrx_det	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rsig_inv_2t	: STD_LOGIC;
   SIGNAL cram_rsig_inv_ptap	: STD_LOGIC;
   SIGNAL cram_rslew	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rtx_lst	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rtx_vtt	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rtx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 5 for Channel 0
   SIGNAL cram_reserved_1_TB32	: STD_LOGIC_VECTOR(10 DOWNTO 0);
   SIGNAL cram_rtx_ob_pdb	: STD_LOGIC;
   SIGNAL cram_reserved_0_TB32	: STD_LOGIC;
   SIGNAL cram_r_dft_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 6 for Channel 0
   SIGNAL cram_reserved_0_TB33	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rtx_cgb_pdb	: STD_LOGIC;
   SIGNAL cram_rpclksel	: STD_LOGIC;
   SIGNAL cram_rdynamic_sw	: STD_LOGIC;
   SIGNAL cram_rs_lpbk	: STD_LOGIC;
   SIGNAL cram_rcgb_delay_sel	: STD_LOGIC;
   SIGNAL cram_rpmadwidth_tx	: STD_LOGIC;
   SIGNAL cram_rpma_doublewidth_tx	: STD_LOGIC;
   SIGNAL cram_rcgb_m_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rcgb_cmu_sel	: STD_LOGIC;
   SIGNAL cram_rcgb_x_en	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 7 for Channel 0
   SIGNAL cram_reserved_1_TB34	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rpcs_sd_sel	: STD_LOGIC;
   SIGNAL cram_rrx_refclk	: STD_LOGIC;
   SIGNAL cram_rimpctrl	: STD_LOGIC;
   SIGNAL cram_reserved_0_TB34	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rrevlb_sw	: STD_LOGIC;
   SIGNAL cram_rvcobypass	: STD_LOGIC;
   SIGNAL cram_rrefclk_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_riqclk_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel TX Control Register 8 for Channel 0
   SIGNAL cram_rpma_reserved_0_TB35	: STD_LOGIC_VECTOR(15 DOWNTO 0); 
   
   -- Extra
   SIGNAL cram_ht_sel : STD_LOGIC;
   
   SIGNAL dpriodisable_in           : STD_LOGIC;
   
   -- SW logical index ------------------------------------------
   SIGNAL dprioin_clkin_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0) := "000";
   SIGNAL init_clkin_sel	    : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000";
   SIGNAL cram_clkin_sel	    : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000";
      
BEGIN
      ------------------------
      --  Wire Delay Block --
      ------------------------
      WireDelay : BLOCK
      BEGIN
       bits_datain : FOR i in datain'RANGE GENERATE
           VitalWireDelay (datain_ipd(i),datain(i), tipd_datain(i));
       END GENERATE;
       bits_datainfull : FOR i in datainfull'RANGE GENERATE
           VitalWireDelay (datainfull_ipd(i),datainfull(i), tipd_datainfull(i));
       END GENERATE;
           VitalWireDelay (refclk0inpulse_ipd,refclk0inpulse, tipd_refclk0inpulse);
           VitalWireDelay (forceelecidle_ipd,forceelecidle, tipd_forceelecidle);
       bits_pclk : FOR i in pclk'RANGE GENERATE
           VitalWireDelay (pclk_ipd(i),pclk(i), tipd_pclk(i));
       END GENERATE;
       bits_fastrefclk4in : FOR i in fastrefclk4in'RANGE GENERATE
           VitalWireDelay (fastrefclk4in_ipd(i),fastrefclk4in(i), tipd_fastrefclk4in(i));
       END GENERATE;
       bits_refclk0in : FOR i in refclk0in'RANGE GENERATE
           VitalWireDelay (refclk0in_ipd(i),refclk0in(i), tipd_refclk0in(i));
       END GENERATE;
       bits_refclk1in : FOR i in refclk1in'RANGE GENERATE
           VitalWireDelay (refclk1in_ipd(i),refclk1in(i), tipd_refclk1in(i));
       END GENERATE;
           VitalWireDelay (dpriodisable_ipd,dpriodisable, tipd_dpriodisable);
       bits_refclk4in : FOR i in refclk4in'RANGE GENERATE
           VitalWireDelay (refclk4in_ipd(i),refclk4in(i), tipd_refclk4in(i));
       END GENERATE;
           VitalWireDelay (refclk4inpulse_ipd,refclk4inpulse, tipd_refclk4inpulse);
           VitalWireDelay (rxdetecten_ipd,rxdetecten, tipd_rxdetecten);
       bits_fastrefclk3in : FOR i in fastrefclk3in'RANGE GENERATE
           VitalWireDelay (fastrefclk3in_ipd(i),fastrefclk3in(i), tipd_fastrefclk3in(i));
       END GENERATE;
           VitalWireDelay (refclk1inpulse_ipd,refclk1inpulse, tipd_refclk1inpulse);
       bits_fastrefclk0in : FOR i in fastrefclk0in'RANGE GENERATE
           VitalWireDelay (fastrefclk0in_ipd(i),fastrefclk0in(i), tipd_fastrefclk0in(i));
       END GENERATE;
           VitalWireDelay (txpmareset_ipd,txpmareset, tipd_txpmareset);
           VitalWireDelay (revserialfdbk_ipd,revserialfdbk, tipd_revserialfdbk);
       bits_refclk3in : FOR i in refclk3in'RANGE GENERATE
           VitalWireDelay (refclk3in_ipd(i),refclk3in(i), tipd_refclk3in(i));
       END GENERATE;
           VitalWireDelay (powerdn_ipd,powerdn, tipd_powerdn);
       bits_fastrefclk2in : FOR i in fastrefclk2in'RANGE GENERATE
           VitalWireDelay (fastrefclk2in_ipd(i),fastrefclk2in(i), tipd_fastrefclk2in(i));
       END GENERATE;
           VitalWireDelay (detectrxpowerdown_ipd,detectrxpowerdown, tipd_detectrxpowerdown);
           VitalWireDelay (refclk3inpulse_ipd,refclk3inpulse, tipd_refclk3inpulse);
       bits_refclk2in : FOR i in refclk2in'RANGE GENERATE
           VitalWireDelay (refclk2in_ipd(i),refclk2in(i), tipd_refclk2in(i));
       END GENERATE;
           VitalWireDelay (refclk2inpulse_ipd,refclk2inpulse, tipd_refclk2inpulse);
       bits_fastrefclk1in : FOR i in fastrefclk1in'RANGE GENERATE
           VitalWireDelay (fastrefclk1in_ipd(i),fastrefclk1in(i), tipd_fastrefclk1in(i));
       END GENERATE;
           VitalWireDelay (rxdetectclk_ipd,rxdetectclk, tipd_rxdetectclk);
       bits_dprioin : FOR i in dprioin'RANGE GENERATE
           VitalWireDelay (dprioin_ipd(i),dprioin(i), tipd_dprioin(i));
       END GENERATE;
      END BLOCK;
   
    -- new DPRIO model begin --
         -- ---------------------------------------------------------------------------
         -- Set DPRIO CRAM input from dprioin  
         -- ---------------------------------------------------------------------------
         
         -- PMA Per Channel TX Control Register 1 for Channel 0
         dprioin_rpowdnt	<= dprioin(rpowdnt_TXPMA_IDX_0);
         dprioin_rvod_seld	<= dprioin(rvod_seld_TXPMA_IDX_2 DOWNTO rvod_seld_TXPMA_IDX_0);
         dprioin_rvod_selc	<= dprioin(rvod_selc_TXPMA_IDX_2 DOWNTO rvod_selc_TXPMA_IDX_0);
         dprioin_rvod_selb	<= dprioin(rvod_selb_TXPMA_IDX_2 DOWNTO rvod_selb_TXPMA_IDX_0);
         dprioin_rvod_sela	<= dprioin(rvod_sela_TXPMA_IDX_2 DOWNTO rvod_sela_TXPMA_IDX_0);
         dprioin_rvod_sel_non_pcie	<= dprioin(rvod_sel_non_pcie_TXPMA_IDX_2 DOWNTO rvod_sel_non_pcie_TXPMA_IDX_0);
         
         -- PMA Per Channel TX Control Register 2 for Channel 0
         dprioin_reserved_0_TB29	<= dprioin(reserved_0_TB29_TXPMA_IDX_0);
         dprioin_rpre_em_1t_b	<= dprioin(rpre_em_1t_b_TXPMA_IDX_4 DOWNTO rpre_em_1t_b_TXPMA_IDX_0);
         dprioin_rpre_em_1t_a	<= dprioin(rpre_em_1t_a_TXPMA_IDX_4 DOWNTO rpre_em_1t_a_TXPMA_IDX_0);
         dprioin_rpre_em_1t_no_pcie	<= dprioin(rpre_em_1t_no_pcie_TXPMA_IDX_4 DOWNTO rpre_em_1t_no_pcie_TXPMA_IDX_0);
         
         -- PMA Per Channel TX Control Register 3 for Channel 0
         dprioin_rpre_em_pt	<= dprioin(rpre_em_pt_TXPMA_IDX_3 DOWNTO rpre_em_pt_TXPMA_IDX_0);
         dprioin_rpre_em_2t	<= dprioin(rpre_em_2t_TXPMA_IDX_3 DOWNTO rpre_em_2t_TXPMA_IDX_0);
         dprioin_rpre_em_1t_c	<= dprioin(rpre_em_1t_c_TXPMA_IDX_4 DOWNTO rpre_em_1t_c_TXPMA_IDX_0);
         dprioin_reserved_0_TB30	<= dprioin(reserved_0_TB30_TXPMA_IDX_2 DOWNTO reserved_0_TB30_TXPMA_IDX_0);
         
         -- PMA Per Channel TX Control Register 4 for Channel 0
         dprioin_rlowv	<= dprioin(rlowv_TXPMA_IDX_0);
         dprioin_rrx_det	<= dprioin(rrx_det_TXPMA_IDX_1 DOWNTO rrx_det_TXPMA_IDX_0);
         dprioin_rsig_inv_2t	<= dprioin(rsig_inv_2t_TXPMA_IDX_0);
         dprioin_rsig_inv_ptap	<= dprioin(rsig_inv_ptap_TXPMA_IDX_0);
         dprioin_rslew	<= dprioin(rslew_TXPMA_IDX_1 DOWNTO rslew_TXPMA_IDX_0);
         dprioin_rtx_lst	<= dprioin(rtx_lst_TXPMA_IDX_3 DOWNTO rtx_lst_TXPMA_IDX_0);
         dprioin_rtx_vtt	<= dprioin(rtx_vtt_TXPMA_IDX_1 DOWNTO rtx_vtt_TXPMA_IDX_0);
         dprioin_rtx_term_sel	<= dprioin(rtx_term_sel_TXPMA_IDX_2 DOWNTO rtx_term_sel_TXPMA_IDX_0);
         
         -- PMA Per Channel TX Control Register 5 for Channel 0
         dprioin_reserved_1_TB32	<= dprioin(reserved_1_TB32_TXPMA_IDX_10 DOWNTO reserved_1_TB32_TXPMA_IDX_0);
         dprioin_rtx_ob_pdb	<= dprioin(rtx_ob_pdb_TXPMA_IDX_0);
         dprioin_reserved_0_TB32	<= dprioin(reserved_0_TB32_TXPMA_IDX_0);
         dprioin_r_dft_sel	<= dprioin(r_dft_sel_TXPMA_IDX_2 DOWNTO r_dft_sel_TXPMA_IDX_0);
         
         -- PMA Per Channel TX Control Register 6 for Channel 0
         dprioin_reserved_0_TB33	<= dprioin(reserved_0_TB33_TXPMA_IDX_3 DOWNTO reserved_0_TB33_TXPMA_IDX_0);
         dprioin_rtx_cgb_pdb	<= dprioin(rtx_cgb_pdb_TXPMA_IDX_0);
         dprioin_rpclksel	<= dprioin(rpclksel_TXPMA_IDX_0);
         dprioin_rdynamic_sw	<= dprioin(rdynamic_sw_TXPMA_IDX_0);
         dprioin_rs_lpbk	<= dprioin(rs_lpbk_TXPMA_IDX_0);
         dprioin_rcgb_delay_sel	<= dprioin(rcgb_delay_sel_TXPMA_IDX_0);
         dprioin_rpmadwidth_tx	<= dprioin(rpmadwidth_tx_TXPMA_IDX_0);
         dprioin_rpma_doublewidth_tx	<= dprioin(rpma_doublewidth_tx_TXPMA_IDX_0);
         dprioin_rcgb_m_sel	<= dprioin(rcgb_m_sel_TXPMA_IDX_1 DOWNTO rcgb_m_sel_TXPMA_IDX_0);
         dprioin_rcgb_cmu_sel	<= dprioin(rcgb_cmu_sel_TXPMA_IDX_0);
         dprioin_rcgb_x_en	<= dprioin(rcgb_x_en_TXPMA_IDX_1 DOWNTO rcgb_x_en_TXPMA_IDX_0);
         
         -- PMA Per Channel TX Control Register 7 for Channel 0
         dprioin_reserved_1_TB34	<= dprioin(reserved_1_TB34_TXPMA_IDX_2 DOWNTO reserved_1_TB34_TXPMA_IDX_0);
         dprioin_rpcs_sd_sel	<= dprioin(rpcs_sd_sel_TXPMA_IDX_0);
         dprioin_rrx_refclk	<= dprioin(rrx_refclk_TXPMA_IDX_0);
         dprioin_rimpctrl	<= dprioin(rimpctrl_TXPMA_IDX_0);
         dprioin_reserved_0_TB34	<= dprioin(reserved_0_TB34_TXPMA_IDX_3 DOWNTO reserved_0_TB34_TXPMA_IDX_0);
         dprioin_rrevlb_sw	<= dprioin(rrevlb_sw_TXPMA_IDX_0);
         dprioin_rvcobypass	<= dprioin(rvcobypass_TXPMA_IDX_0);
         dprioin_rrefclk_sel	<= dprioin(rrefclk_sel_TXPMA_IDX_1 DOWNTO rrefclk_sel_TXPMA_IDX_0);
         dprioin_riqclk_sel	<= dprioin(riqclk_sel_TXPMA_IDX_1 DOWNTO riqclk_sel_TXPMA_IDX_0);
         
         -- PMA Per Channel TX Control Register 8 for Channel 0
         dprioin_rpma_reserved_0_TB35	<= dprioin(rpma_reserved_0_TB35_TXPMA_IDX_15 DOWNTO rpma_reserved_0_TB35_TXPMA_IDX_0);
         
         -- Extra
	 dprioin_ht_sel	<= dprioin(ht_sel_TX_PMA_IDX);
         
         -- ---------------------------------------------------------------------------
         -- Set DPRIO output from initial CRAM
         -- ---------------------------------------------------------------------------
         
         -- PMA Per Channel TX Control Register 1 for Channel 0
         dprioout(rpowdnt_TXPMA_IDX_0) <= init_rpowdnt;
         dprioout(rvod_seld_TXPMA_IDX_2 DOWNTO rvod_seld_TXPMA_IDX_0) <= init_rvod_seld;
         dprioout(rvod_selc_TXPMA_IDX_2 DOWNTO rvod_selc_TXPMA_IDX_0) <= init_rvod_selc;
         dprioout(rvod_selb_TXPMA_IDX_2 DOWNTO rvod_selb_TXPMA_IDX_0) <= init_rvod_selb;
         dprioout(rvod_sela_TXPMA_IDX_2 DOWNTO rvod_sela_TXPMA_IDX_0) <= init_rvod_sela;
         dprioout(rvod_sel_non_pcie_TXPMA_IDX_2 DOWNTO rvod_sel_non_pcie_TXPMA_IDX_0) <= init_rvod_sel_non_pcie;
         
         -- PMA Per Channel TX Control Register 2 for Channel 0
         dprioout(reserved_0_TB29_TXPMA_IDX_0) <= init_reserved_0_TB29;
         dprioout(rpre_em_1t_b_TXPMA_IDX_4 DOWNTO rpre_em_1t_b_TXPMA_IDX_0) <= init_rpre_em_1t_b;
         dprioout(rpre_em_1t_a_TXPMA_IDX_4 DOWNTO rpre_em_1t_a_TXPMA_IDX_0) <= init_rpre_em_1t_a;
         dprioout(rpre_em_1t_no_pcie_TXPMA_IDX_4 DOWNTO rpre_em_1t_no_pcie_TXPMA_IDX_0) <= init_rpre_em_1t_no_pcie;
         
         -- PMA Per Channel TX Control Register 3 for Channel 0
         dprioout(rpre_em_pt_TXPMA_IDX_3 DOWNTO rpre_em_pt_TXPMA_IDX_0) <= init_rpre_em_pt;
         dprioout(rpre_em_2t_TXPMA_IDX_3 DOWNTO rpre_em_2t_TXPMA_IDX_0) <= init_rpre_em_2t;
         dprioout(rpre_em_1t_c_TXPMA_IDX_4 DOWNTO rpre_em_1t_c_TXPMA_IDX_0) <= init_rpre_em_1t_c;
         dprioout(reserved_0_TB30_TXPMA_IDX_2 DOWNTO reserved_0_TB30_TXPMA_IDX_0) <= init_reserved_0_TB30;
         
         -- PMA Per Channel TX Control Register 4 for Channel 0
         dprioout(rlowv_TXPMA_IDX_0) <= init_rlowv;
         dprioout(rrx_det_TXPMA_IDX_1 DOWNTO rrx_det_TXPMA_IDX_0) <= init_rrx_det;
         dprioout(rsig_inv_2t_TXPMA_IDX_0) <= init_rsig_inv_2t;
         dprioout(rsig_inv_ptap_TXPMA_IDX_0) <= init_rsig_inv_ptap;
         dprioout(rslew_TXPMA_IDX_1 DOWNTO rslew_TXPMA_IDX_0) <= init_rslew;
         dprioout(rtx_lst_TXPMA_IDX_3 DOWNTO rtx_lst_TXPMA_IDX_0) <= init_rtx_lst;
         dprioout(rtx_vtt_TXPMA_IDX_1 DOWNTO rtx_vtt_TXPMA_IDX_0) <= init_rtx_vtt;
         dprioout(rtx_term_sel_TXPMA_IDX_2 DOWNTO rtx_term_sel_TXPMA_IDX_0) <= init_rtx_term_sel;
         
         -- PMA Per Channel TX Control Register 5 for Channel 0
         dprioout(reserved_1_TB32_TXPMA_IDX_10 DOWNTO reserved_1_TB32_TXPMA_IDX_0) <= init_reserved_1_TB32;
         dprioout(rtx_ob_pdb_TXPMA_IDX_0) <= init_rtx_ob_pdb;
         dprioout(reserved_0_TB32_TXPMA_IDX_0) <= init_reserved_0_TB32;
         dprioout(r_dft_sel_TXPMA_IDX_2 DOWNTO r_dft_sel_TXPMA_IDX_0) <= init_r_dft_sel;
         
         -- PMA Per Channel TX Control Register 6 for Channel 0
         dprioout(reserved_0_TB33_TXPMA_IDX_3 DOWNTO reserved_0_TB33_TXPMA_IDX_0) <= init_reserved_0_TB33;
         dprioout(rtx_cgb_pdb_TXPMA_IDX_0) <= init_rtx_cgb_pdb;
         dprioout(rpclksel_TXPMA_IDX_0) <= init_rpclksel;
         dprioout(rdynamic_sw_TXPMA_IDX_0) <= init_rdynamic_sw;
         dprioout(rs_lpbk_TXPMA_IDX_0) <= init_rs_lpbk;
         dprioout(rcgb_delay_sel_TXPMA_IDX_0) <= init_rcgb_delay_sel;
         dprioout(rpmadwidth_tx_TXPMA_IDX_0) <= init_rpmadwidth_tx;
         dprioout(rpma_doublewidth_tx_TXPMA_IDX_0) <= init_rpma_doublewidth_tx;
         dprioout(rcgb_m_sel_TXPMA_IDX_1 DOWNTO rcgb_m_sel_TXPMA_IDX_0) <= init_rcgb_m_sel;
         dprioout(rcgb_cmu_sel_TXPMA_IDX_0) <= init_rcgb_cmu_sel;
         dprioout(rcgb_x_en_TXPMA_IDX_1 DOWNTO rcgb_x_en_TXPMA_IDX_0) <= init_rcgb_x_en;
         
         -- PMA Per Channel TX Control Register 7 for Channel 0
         dprioout(reserved_1_TB34_TXPMA_IDX_2 DOWNTO reserved_1_TB34_TXPMA_IDX_0) <= init_reserved_1_TB34;
         dprioout(rpcs_sd_sel_TXPMA_IDX_0) <= init_rpcs_sd_sel;
         dprioout(rrx_refclk_TXPMA_IDX_0) <= init_rrx_refclk;
         dprioout(rimpctrl_TXPMA_IDX_0) <= init_rimpctrl;
         dprioout(reserved_0_TB34_TXPMA_IDX_3 DOWNTO reserved_0_TB34_TXPMA_IDX_0) <= init_reserved_0_TB34;
         dprioout(rrevlb_sw_TXPMA_IDX_0) <= init_rrevlb_sw;
         dprioout(rvcobypass_TXPMA_IDX_0) <= init_rvcobypass;
         dprioout(rrefclk_sel_TXPMA_IDX_1 DOWNTO rrefclk_sel_TXPMA_IDX_0) <= init_rrefclk_sel;
         dprioout(riqclk_sel_TXPMA_IDX_1 DOWNTO riqclk_sel_TXPMA_IDX_0) <= init_riqclk_sel;
         
         -- PMA Per Channel TX Control Register 8 for Channel 0
         dprioout(rpma_reserved_0_TB35_TXPMA_IDX_15 DOWNTO rpma_reserved_0_TB35_TXPMA_IDX_0) <= init_rpma_reserved_0_TB35;
         
         -- Extra
	 dprioout(ht_sel_TX_PMA_IDX) <= init_ht_sel;
         
         -- ---------------------------------------------------------------------------
         -- Set DPRIO CRAM
         -- ---------------------------------------------------------------------------
         dpriodisable_in <= '0' WHEN (dpriodisable = '0') ELSE '1';

         -- PMA Per Channel TX Control Register 1 for Channel 0
         cram_rpowdnt <= init_rpowdnt WHEN (dpriodisable_in /= '0') ELSE dprioin_rpowdnt;
         cram_rvod_seld <= init_rvod_seld WHEN (dpriodisable_in /= '0') ELSE dprioin_rvod_seld;
         cram_rvod_selc <= init_rvod_selc WHEN (dpriodisable_in /= '0') ELSE dprioin_rvod_selc;
         cram_rvod_selb <= init_rvod_selb WHEN (dpriodisable_in /= '0') ELSE dprioin_rvod_selb;
         cram_rvod_sela <= init_rvod_sela WHEN (dpriodisable_in /= '0') ELSE dprioin_rvod_sela;
         cram_rvod_sel_non_pcie <= init_rvod_sel_non_pcie WHEN (dpriodisable_in /= '0') ELSE dprioin_rvod_sel_non_pcie;
         
         -- PMA Per Channel TX Control Register 2 for Channel 0
         cram_reserved_0_TB29 <= init_reserved_0_TB29 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB29;
         cram_rpre_em_1t_b <= init_rpre_em_1t_b WHEN (dpriodisable_in /= '0') ELSE dprioin_rpre_em_1t_b;
         cram_rpre_em_1t_a <= init_rpre_em_1t_a WHEN (dpriodisable_in /= '0') ELSE dprioin_rpre_em_1t_a;
         cram_rpre_em_1t_no_pcie <= init_rpre_em_1t_no_pcie WHEN (dpriodisable_in /= '0') ELSE dprioin_rpre_em_1t_no_pcie;
         
         -- PMA Per Channel TX Control Register 3 for Channel 0
         cram_rpre_em_pt <= init_rpre_em_pt WHEN (dpriodisable_in /= '0') ELSE dprioin_rpre_em_pt;
         cram_rpre_em_2t <= init_rpre_em_2t WHEN (dpriodisable_in /= '0') ELSE dprioin_rpre_em_2t;
         cram_rpre_em_1t_c <= init_rpre_em_1t_c WHEN (dpriodisable_in /= '0') ELSE dprioin_rpre_em_1t_c;
         cram_reserved_0_TB30 <= init_reserved_0_TB30 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB30;
         
         -- PMA Per Channel TX Control Register 4 for Channel 0
         cram_rlowv <= init_rlowv WHEN (dpriodisable_in /= '0') ELSE dprioin_rlowv;
         cram_rrx_det <= init_rrx_det WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_det;
         cram_rsig_inv_2t <= init_rsig_inv_2t WHEN (dpriodisable_in /= '0') ELSE dprioin_rsig_inv_2t;
         cram_rsig_inv_ptap <= init_rsig_inv_ptap WHEN (dpriodisable_in /= '0') ELSE dprioin_rsig_inv_ptap;
         cram_rslew <= init_rslew WHEN (dpriodisable_in /= '0') ELSE dprioin_rslew;
         cram_rtx_lst <= init_rtx_lst WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_lst;
         cram_rtx_vtt <= init_rtx_vtt WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_vtt;
         cram_rtx_term_sel <= init_rtx_term_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_term_sel;
         
         -- PMA Per Channel TX Control Register 5 for Channel 0
         cram_reserved_1_TB32 <= init_reserved_1_TB32 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_1_TB32;
         cram_rtx_ob_pdb <= init_rtx_ob_pdb WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_ob_pdb;
         cram_reserved_0_TB32 <= init_reserved_0_TB32 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB32;
         cram_r_dft_sel <= init_r_dft_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_r_dft_sel;
         
         -- PMA Per Channel TX Control Register 6 for Channel 0
         cram_reserved_0_TB33 <= init_reserved_0_TB33 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB33;
         cram_rtx_cgb_pdb <= init_rtx_cgb_pdb WHEN (dpriodisable_in /= '0') ELSE dprioin_rtx_cgb_pdb;
         cram_rpclksel <= init_rpclksel WHEN (dpriodisable_in /= '0') ELSE dprioin_rpclksel;
         cram_rdynamic_sw <= init_rdynamic_sw WHEN (dpriodisable_in /= '0') ELSE dprioin_rdynamic_sw;
         cram_rs_lpbk <= init_rs_lpbk WHEN (dpriodisable_in /= '0') ELSE dprioin_rs_lpbk;
--         cram_rcgb_delay_sel <= init_rcgb_delay_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_delay_sel;
         cram_rcgb_delay_sel <= '0';
         cram_rpmadwidth_tx <= init_rpmadwidth_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpmadwidth_tx;
         cram_rpma_doublewidth_tx <= init_rpma_doublewidth_tx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpma_doublewidth_tx;
         cram_rcgb_m_sel <= init_rcgb_m_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_m_sel;
         cram_rcgb_cmu_sel <= init_rcgb_cmu_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_cmu_sel;
         cram_rcgb_x_en <= init_rcgb_x_en WHEN (dpriodisable_in /= '0') ELSE dprioin_rcgb_x_en;
         
         -- PMA Per Channel TX Control Register 7 for Channel 0
         cram_reserved_1_TB34 <= init_reserved_1_TB34 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_1_TB34;
         cram_rpcs_sd_sel <= init_rpcs_sd_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rpcs_sd_sel;
         cram_rrx_refclk <= init_rrx_refclk WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_refclk;
         cram_rimpctrl <= init_rimpctrl WHEN (dpriodisable_in /= '0') ELSE dprioin_rimpctrl;
         cram_reserved_0_TB34 <= init_reserved_0_TB34 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB34;
         cram_rrevlb_sw <= init_rrevlb_sw WHEN (dpriodisable_in /= '0') ELSE dprioin_rrevlb_sw;
         cram_rvcobypass <= init_rvcobypass WHEN (dpriodisable_in /= '0') ELSE dprioin_rvcobypass;
         cram_rrefclk_sel <= init_rrefclk_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rrefclk_sel;
         cram_riqclk_sel <= init_riqclk_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_riqclk_sel;
         
         -- PMA Per Channel TX Control Register 8 for Channel 0
         cram_rpma_reserved_0_TB35 <= init_rpma_reserved_0_TB35 WHEN (dpriodisable_in /= '0') ELSE dprioin_rpma_reserved_0_TB35;
         
         -- Extra
	    cram_ht_sel <= init_ht_sel;	-- SPR 288513
  
	    	    -- SW logical index --
   	    dprioin_clkin_sel <= dprioin(CLKIN_SELECT_TXPMA_IDX_2 DOWNTO CLKIN_SELECT_TXPMA_IDX_0);
        cram_clkin_sel    <= init_clkin_sel WHEN (dpriodisable /= '0') ELSE dprioin_clkin_sel;
        dprioout(CLKIN_SELECT_TXPMA_IDX_2 DOWNTO CLKIN_SELECT_TXPMA_IDX_0) <= init_clkin_sel;
       
   PROCESS 
   BEGIN
           -- map to parameter name
      	   -- TX PMA control register 1
             init_rpowdnt           <= '0';
             init_rvod_sel_non_pcie <= mux_select((vod_selection = 0), "000", mux_select((vod_selection = 1), "001", mux_select((vod_selection = 2), "010", mux_select((vod_selection = 3), "110", mux_select((vod_selection = 4), "011", mux_select((vod_selection = 5), "111", mux_select((vod_selection = 6), "100", mux_select((vod_selection = 7), "101", "000"))))))));
             init_rvod_seld         <= int2bin(vod_selection_d, 3);
             init_rvod_selc         <= int2bin(vod_selection_c, 3);
             init_rvod_selb         <= int2bin(vod_selection_b, 3);
             init_rvod_sela         <= int2bin(vod_selection_a, 3);
             
             -- TX PMA control register 2
             init_rpre_em_1t_b		<= int2bin(preemp_tap_1_b, 5);
             init_rpre_em_1t_a		<= int2bin(preemp_tap_1_a, 5);
             init_rpre_em_1t_no_pcie	<= int2bin(preemp_tap_1, 5);
             
             -- TX PMA control register 3
             init_rpre_em_pt	<= int2bin(preemp_pretap, 4);
             init_rpre_em_2t	<= int2bin(preemp_tap_2, 4);
             init_rpre_em_1t_c	<= int2bin(preemp_tap_1_c, 5);
             
             -- TX PMA control register 4
             init_rlowv			<= '0';
             init_rrx_det		<= int2bin(rx_detect, 2);
             init_rsig_inv_2t	<= mux_select((preemp_tap_2_inv = ("true")), '1', '0');
             init_rsig_inv_ptap <= mux_select((preemp_pretap_inv = ("true")), '1', '0');
             init_rslew			<= (mux_select((slew_rate = ("low")), "01", mux_select((slew_rate = ("medium")), "10", mux_select((slew_rate = ("high")), "11", "00"))));
             init_rtx_lst		<= int2bin(low_speed_test_select, 4);
             init_rtx_vtt		<= mux_select((alpha_tolower(common_mode) = ("tristate")), "00", mux_select((alpha_tolower(common_mode) = ("0.6v")), "01", mux_select((alpha_tolower(common_mode) = ("0.7v")), "10", "11")));
             init_rtx_term_sel	<= (mux_select((alpha_tolower(termination) = ("off")), "000", mux_select((alpha_tolower(termination) = ("oct 85 ohms") OR alpha_tolower(termination) = ("85_ohms")), "111", mux_select((alpha_tolower(termination) = ("100_ohms") OR alpha_tolower(termination) = ("oct 100 ohms")), "110", mux_select((alpha_tolower(termination) = ("oct 120 ohms") OR alpha_tolower(termination) = ("120_ohms")), "101", "100")))));
             
             -- TX PMA Control Register 6
	     init_rpma_doublewidth_tx 	<= (mux_select((serialization_factor = 16 OR serialization_factor = 20), '1', '0'));   	--init_rpma_doublewidth_tx = rser_div2_init;
	     init_rpmadwidth_tx 	<= (mux_select((serialization_factor = 10 OR serialization_factor = 20), '1', '0'));	--init_rpmadwidth_tx 	   = rser_div5_init;
	     init_rcgb_delay_sel	<= mux_select((clkmux_delay = ("true")), '1', '0');
 	     init_rcgb_x_en 		<= int2bin(clkin_select, 2);
	     init_rpclksel 		<= mux_select((use_pclk = ("true")), '1', '0');
	     init_rs_lpbk 		<= mux_select((enable_reverse_serial_loopback = ("true")), '1', '0');   
	     
	     -- Extra
    	 init_ht_sel 		<= mux_select((clkin_select > 3), '1', '0');  
    	 
    	 -- SW logic index
    	 init_clkin_sel  	<= int2bin(clkin_select, 3);
             
      WAIT;
   END PROCESS;       
      -- new DPRIO model end --
      ------------------------
      --  Functionality Section --
      ------------------------
   PROCESS 
   BEGIN
      ht_sel_init <= mux_select((clkin_select > 3), '1', '0');
      rcgb_delay_sel_init <= mux_select((clkmux_delay = ("true")), '1', '0');
      rcgb_x_en_init <= int2bin(clkin_select, 2);
      rpmphs_1tap_init <= int2bin(preemp_tap_1, 5);
      rpmphs_2tap_init <= int2bin(preemp_tap_2, 4);
      rpmphs_ptap_init <= int2bin(preemp_pretap, 4);
      r_rx_det_init <= int2bin(rx_detect, 2);
      rser_div2_init <= (mux_select((serialization_factor = 16 OR serialization_factor = 20), '1', '0'));
      rser_div5_init <= (mux_select((serialization_factor = 10 OR serialization_factor = 20), '1', '0'));
      rsig_inv_2t_init <= mux_select((preemp_tap_2_inv = ("true")), '1', '0');
      rsig_inv_ptap_init <= mux_select((preemp_pretap_inv = ("true")), '1', '0');
      rslew_init <= (mux_select((slew_rate = ("low")), "01", mux_select((slew_rate = ("medium")), "10", mux_select((slew_rate = ("high")), "11", "00"))));
      rtx_lst_init <= int2bin(low_speed_test_select, 4);
      rtx_rlpbk_init <= mux_select((enable_reverse_serial_loopback = ("true")), '1', '0');
      rtx_term_sel_init <= (mux_select((termination = ("off")), "000", mux_select((termination = ("OCT 85 Ohms")), "111", mux_select((termination = ("100_ohms")), "110", mux_select((termination = ("OCT 120 Ohms")), "101", "100")))));
      rtx_vtt_init <= mux_select((common_mode = ("tristate")), "00", mux_select((common_mode = ("0.6V")), "01", mux_select((common_mode = ("0.7V")), "10", "11")));
      rpclksel_init <= mux_select((use_pclk = ("true")), '1', '0');
      WAIT;
   END PROCESS;
   
   vccelxqyx <= '1';
   vccetxqyx <= '0';
   vssexqyx <= '0';
   xtxclkmux_cpulse_ht <= refclk4inpulse;
   xtxclkmux_cpulse_x1 <= refclk0inpulse;
   xtxclkmux_cpulse_x4 <= refclk1inpulse;
   xtxclkmux_cpulse_x8_b <= refclk3inpulse;
   xtxclkmux_cpulse_x8_t <= refclk2inpulse;
   xtxclkmux_hfclkp_x1 <= fastrefclk0in(0);
   xtxclkmux_hfclkp_x4 <= fastrefclk1in(0);
   xtxclkmux_hfclkp_x8_b <= fastrefclk3in(0);
   xtxclkmux_hfclkp_x8_t <= fastrefclk2in(0);
   xtxclkmux_hfclkp_ht <= fastrefclk4in(0);
   xtxclkmux_hfclkn_x1 <= fastrefclk0in(1);
   xtxclkmux_hfclkn_x4 <= fastrefclk1in(1);
   xtxclkmux_hfclkn_x8_b <= fastrefclk3in(1);
   xtxclkmux_hfclkn_x8_t <= fastrefclk2in(1);
   xtxclkmux_hfclkn_ht <= fastrefclk4in(1);
   xtxclkmux_ht_sel <= cram_ht_sel WHEN (serialization_factor <= 20) ELSE
                       '0';
   xtxclkmux_lfclkp_x1 <= refclk0in(0);
   xtxclkmux_lfclkp_x4 <= refclk1in(0);
   xtxclkmux_lfclkp_x8_b <= refclk3in(0);
   xtxclkmux_lfclkp_x8_t <= refclk2in(0);
   xtxclkmux_lfclkp_ht <= refclk4in(0);
   xtxclkmux_lfclkn_x1 <= refclk0in(1);
   xtxclkmux_lfclkn_x4 <= refclk1in(1);
   xtxclkmux_lfclkn_x8_b <= refclk3in(1);
   xtxclkmux_lfclkn_x8_t <= refclk2in(1);
   xtxclkmux_lfclkn_ht <= refclk4in(1);
   xtxclkmux_pdb <= '0' WHEN (powerdn = '1') ELSE
                    '1';
   xtxclkmux_rdelay_sel <= cram_rcgb_delay_sel;
   xtxclkmux_rsel <= cram_clkin_sel(1 DOWNTO 0); -- shawn cram_rcgb_x_en;
   
   
   xtxclkmux : stratixiv_hssi_pma_c_tx_clkmux_cmu
      PORT MAP (
         cpulse_ht    => xtxclkmux_cpulse_ht,
         cpulse_x1    => xtxclkmux_cpulse_x1,
         cpulse_x4    => xtxclkmux_cpulse_x4,
         cpulse_xn_b  => xtxclkmux_cpulse_x8_b,
         cpulse_xn_t  => xtxclkmux_cpulse_x8_t,
         delay_sel    => xtxclkmux_rdelay_sel,
         hfclkn_ht    => xtxclkmux_hfclkn_ht,
         hfclkn_x1    => xtxclkmux_hfclkn_x1,
         hfclkn_x4    => xtxclkmux_hfclkn_x4,
         hfclkn_xn_b  => xtxclkmux_hfclkn_x8_b,
         hfclkn_xn_t  => xtxclkmux_hfclkn_x8_t,
         hfclkp_ht    => xtxclkmux_hfclkp_ht,
         hfclkp_x1    => xtxclkmux_hfclkp_x1,
         hfclkp_x4    => xtxclkmux_hfclkp_x4,
         hfclkp_xn_b  => xtxclkmux_hfclkp_x8_b,
         hfclkp_xn_t  => xtxclkmux_hfclkp_x8_t,
         ht_sel       => xtxclkmux_ht_sel,
         lfclkn_ht    => xtxclkmux_lfclkn_ht,
         lfclkn_x1    => xtxclkmux_lfclkn_x1,
         lfclkn_x4    => xtxclkmux_lfclkn_x4,
         lfclkn_xn_b  => xtxclkmux_lfclkn_x8_b,
         lfclkn_xn_t  => xtxclkmux_lfclkn_x8_t,
         lfclkp_ht    => xtxclkmux_lfclkp_ht,
         lfclkp_x1    => xtxclkmux_lfclkp_x1,
         lfclkp_x4    => xtxclkmux_lfclkp_x4,
         lfclkp_xn_b  => xtxclkmux_lfclkp_x8_b,
         lfclkp_xn_t  => xtxclkmux_lfclkp_x8_t,
         pdb          => xtxclkmux_pdb,
         sel          => xtxclkmux_rsel,
         vccelxqyx    => vccelxqyx,
         vssexqyx     => vssexqyx,
         cpulse       => xtxclkmux_cpulse,
         hfclk_n      => xtxclkmux_hfclkn,
         hfclk_p      => xtxclkmux_hfclkp,
         lfclk_n      => xtxclkmux_lfclkn,
         lfclk_p      => xtxclkmux_lfclkp
      );
   xser_data <= ("00" & datain(15 DOWNTO 8) & "00" & datain(7 DOWNTO 0)) WHEN (use_pma_direct = "true" and serialization_factor = 16) ELSE datain(19 DOWNTO 0);

   xser_data_dprio <= datainfull_ipd WHEN (((dprio_config_mode(5 DOWNTO 0) AND "000100") = "000100") AND use_pma_direct = "true") ELSE xser_data;

   xser_pdb <= '0' WHEN (powerdn = '1') ELSE
               '1';
               
   -- (clkin_select);
   xser_pclk <= pclk_ipd(0) WHEN (cram_clkin_sel = "000")  ELSE
                pclk_ipd(1) WHEN (cram_clkin_sel = "001")  ELSE
                pclk_ipd(2) WHEN (cram_clkin_sel = "010")  ELSE
                pclk_ipd(3) WHEN (cram_clkin_sel = "011")  ELSE
                pclk_ipd(4) WHEN (cram_clkin_sel = "100")  ELSE
                pclk_ipd(0);
                       
   xser_rpclksel <= cram_rpclksel;
   xser_rpre_em <= cram_rpre_em_1t_no_pcie;
   xser_rpre_em_2t <= cram_rpre_em_2t;
   xser_rpre_em_pretap <= cram_rpre_em_pt;
   xser_rdiv2 <= cram_rpma_doublewidth_tx;
   xser_rdiv5 <= cram_rpmadwidth_tx;
   xser_rs_lpbk <= '1'; -- always enabled - allow serial_loop_back
   xser_rst_n <= '0' WHEN (txpmareset = '1') ELSE
                 '1';
   xser_cpulse <= '0' WHEN (serialization_factor > 20) ELSE xtxclkmux_cpulse;
   xser_hfclkn <= '0' WHEN (serialization_factor > 20) ELSE xtxclkmux_hfclkn;
   xser_hfclkp <= '0' WHEN (serialization_factor > 20) ELSE xtxclkmux_hfclkp;
   xser_lfclkn <= '0' WHEN (serialization_factor > 20) ELSE xtxclkmux_lfclkn;
   xser_lfclkp <= '0' WHEN (serialization_factor > 20) ELSE xtxclkmux_lfclkp;
   xser_10g_data_in <= datain(63 DOWNTO 0);
   xser_10g_pdb <= '0' WHEN (powerdn = '1') ELSE
                   '1';
   xser_10g_rpre_em <= rpmphs_1tap_cram;
   xser_10g_rst_n <= '0' WHEN (txpmareset = '1') ELSE
                     '1';
   xser_10g_rs_lpbk <= '1';
   xser_10g_cpulse <= xtxclkmux_cpulse WHEN (serialization_factor > 20) ELSE '0';
   xser_10g_hfclkn <= xtxclkmux_hfclkn WHEN (serialization_factor > 20) ELSE '0';
   xser_10g_hfclkp <= xtxclkmux_hfclkp WHEN (serialization_factor > 20) ELSE '0';
   xser_10g_lfclkn <= xtxclkmux_lfclkn WHEN (serialization_factor > 20) ELSE '0';
   xser_10g_lfclkp <= xtxclkmux_lfclkp WHEN (serialization_factor > 20) ELSE '0';
   xser_10g_cpulseb <= NOT xser_10g_cpulse WHEN (serialization_factor > 20) ELSE '0';
   
   xser : stratixiv_hssi_pma_c_ser
      PORT MAP (
         cpulse         => xser_cpulse,
         data           => xser_data_dprio,
         div2           => xser_rdiv2,
         div5           => xser_rdiv5,
         hfclkn         => xser_hfclkn,
         hfclkp         => xser_hfclkp,
         lfclkn         => xser_lfclkn,
         lfclkp         => xser_lfclkp,
         pclk_in        => xser_pclk,
         pclksel        => xser_rpclksel,
         pdb            => xser_pdb,
         pre_em         => xser_rpre_em,
         pre_em_2t      => xser_rpre_em_2t,
         pre_em_pretap  => xser_rpre_em_pretap,
         rst_n          => xser_rst_n,
         s_lpbk         => xser_rs_lpbk,
         vccelxqyx      => vccelxqyx,
         vccetxqyx      => vccetxqyx,
         vssexqyx       => vssexqyx,
         clk_divtx      => xser_clk_divtx,
         lbvon          => xser_lbvon,
         lbvop          => xser_lbvop,
         pre_en_out     => xser_pre_en_out,
         von            => xser_von,
         von_op1        => xser_von_op1,
         von_op2        => xser_von_op2,
         von_pre        => xser_von_pre,
         vop            => xser_vop,
         vop_op1        => xser_vop_op1,
         vop_op2        => xser_vop_op2,
         vop_pre        => xser_vop_pre
      );
   
   
   xser_10g : stratixiv_hssi_pma_c_ser_10g
      PORT MAP (
         clk_skew   => xser_10g_clk_skew,
         cpulse     => xser_10g_cpulse,
         cpulseb    => xser_10g_cpulseb,
         data_in    => xser_10g_data_in,
         hfclkn     => xser_10g_hfclkn,
         hfclkp     => xser_10g_hfclkp,
         lfclkn     => xser_10g_lfclkn,
         lfclkp     => xser_10g_lfclkp,
         pdb        => xser_10g_pdb,
         pre_em     => xser_10g_rpre_em,
         rst_n      => xser_10g_rst_n,
         s_lpbk     => xser_10g_rs_lpbk,
         vccelxqyx  => vccelxqyx,
         vccetxqyx  => vccetxqyx,
         vssexqyx   => vssexqyx,
         clk_divtx  => xser_10g_clk_divtx,
         lbvon      => xser_10g_lbvon,
         lbvop      => xser_10g_lbvop,
         von        => xser_10g_von,
         von_op1    => xser_10g_von_op1,
         vop        => xser_10g_vop,
         vop_op1    => xser_10g_vop_op1
      );
   clockout <= xser_10g_clk_divtx WHEN (serialization_factor > 20) ELSE
               xser_clk_divtx;
   seriallpbkout <= xser_10g_lbvop WHEN (serialization_factor > 20) ELSE
                    xser_lbvop;
   PROCESS 
   BEGIN
      rx_det_clk_reg <= '0';
      WHILE (TRUE) LOOP
         WAIT FOR 4000 ps;
         rx_det_clk_reg <= NOT(rx_det_clk_reg);
      END LOOP;
      WAIT;
   END PROCESS;
   
   forceelecidle_in <= '1' WHEN (forceelecidle = '1') ELSE '0';
   
   xtx_rx_det_clk <= rx_det_clk_reg;
   xtx_cgb_vccelxqyx <= '1';
   xtx_cgb_vssexqyx <= '0';
   xtx_pdb <= '0' WHEN (powerdn = '1') ELSE
              '1';
   xtx_rlpbkp <= revserialfdbk;
   xtx_rlpbkn <= NOT(revserialfdbk);
   xtx_r_rx_det <= r_rx_det_cram;
   xtx_rpre_em_1t <= rpmphs_1tap_cram;
   xtx_rpre_em_2t <= rpmphs_2tap_cram WHEN (serialization_factor <= 20) ELSE
                     "0000";
   xtx_rpre_em_pt <= rpmphs_ptap_cram WHEN (serialization_factor <= 20) ELSE
                     "0000";
   xtx_rsig_inv_2t <= cram_rsig_inv_2t;
   xtx_rsig_inv_ptap <= cram_rsig_inv_ptap;
   xtx_rslew <= cram_rslew;
   xtx_rlst <= cram_rtx_lst;
   xtx_rtx_rlpbk <= cram_rs_lpbk;
   xtx_rterm_sel <= cram_rtx_term_sel;
   xtx_rtx_vtt <= cram_rtx_vtt;
   xtx_rvod_sel <= int2bin(vod_selection, 3);
   xtx_rx_det_pdb <= '0' WHEN (detectrxpowerdown = '1') ELSE
                     '1';
   xtx_tx_det_rx <= rxdetecten;
   xtx_tx_elec_idl <= forceelecidle_in;
   xtx_vin <= xser_von WHEN (serialization_factor <= 20) ELSE
              xser_10g_von;
   xtx_vin_op1 <= xser_von_op1 WHEN (serialization_factor <= 20) ELSE
                  xser_10g_von_op1;
   xtx_vin_op2 <= xser_von_op2;
   xtx_vin_pre <= xser_von_pre;
   xtx_vip <= xser_vop WHEN (serialization_factor <= 20) ELSE
              xser_10g_vop;
   xtx_vip_op1 <= xser_vop_op1 WHEN (serialization_factor <= 20) ELSE
                  xser_10g_vop_op1;
   xtx_vip_op2 <= xser_vop_op2;
   xtx_vip_pre <= xser_vop_pre;
   vccehtxqyx <= '0';
   vccehxqyx <= '0';
   
   
   xtx : stratixiv_hssi_pma_c_tx
      PORT MAP (
         bsmode           => xtx_bsmode,
         bstxn_in         => xtx_bstxn_in,
         bstxp_in         => xtx_bstxp_in,
         cgb_vccelxqyx    => xtx_cgb_vccelxqyx,
         cgb_vssexqyx     => xtx_cgb_vssexqyx,
         lst              => xtx_rlst,
         pdb              => xtx_pdb,
         r_dft_sel        => xtx_r_dft_sel,
         r_dis_idlegate   => xtx_r_dis_idlegate,
         r_highv          => xtx_r_highv,
         r_lowv           => xtx_r_lowv,
         r_rx_det         => xtx_r_rx_det,
         r_slew           => xtx_rslew,
         rlpbkn           => xtx_rlpbkn,
         rlpbkn_em        => xtx_rlpbkn_em,
         rlpbkp           => xtx_rlpbkp,
         rlpbkp_em        => xtx_rlpbkp_em,
         rpre_em_1t       => xtx_rpre_em_1t,
         rpre_em_2t       => xtx_rpre_em_2t,
         rpre_em_pt       => xtx_rpre_em_pt,
         rsig_inv_2t      => xtx_rsig_inv_2t,
         rsig_inv_ptap    => xtx_rsig_inv_ptap,
         rterm_sel        => xtx_rterm_sel,
         rtx_rlpbk        => xtx_rtx_rlpbk,
         rtx_vtt          => xtx_rtx_vtt,
         rvod_sel         => xtx_rvod_sel,
         rx_det_clk       => xtx_rx_det_clk,
         rx_det_pdb       => xtx_rx_det_pdb,
         rx_n             => xtx_rx_n,
         rx_p             => xtx_rx_p,
         tx50             => xtx_tx50,
         tx_det_rx        => xtx_tx_det_rx,
         tx_elec_idl      => xtx_tx_elec_idl,
         vccehtxqyx       => vccehtxqyx,
         vccehxqyx        => vccehxqyx,
         vccesdh_la       => vccetxqyx,
         vccesdp_la       => vccetxqyx,
         vccetxqyx        => vccetxqyx,
         vin              => xtx_vin,
         vin_po1          => xtx_vin_op1,
         vin_po2          => xtx_vin_op2,
         vin_pre          => xtx_vin_pre,
         vip              => xtx_vip,
         vip_po1          => xtx_vip_op1,
         vip_po2          => xtx_vip_op2,
         vip_pre          => xtx_vip_pre,
         vssexqyx         => vssexqyx,
         atb0             => xtx_atb0,
         atb1             => xtx_atb1,
         ib50uc_rcvdt     => xtx_ib50uc_rcvdt,
         ib50uc_vcm       => xtx_ib50uc,
         ib50ut_vcm       => xtx_ib50ut,
         ib100uc          => xtx_ib100uc,
         von              => xtx_von,
         vop              => xtx_vop,
         
         com_pass         => xtx_com_pass,
         detect_on        => xtx_detect_on,
         fixed_clk_out    => xtx_fixed_clk,
         probe_pass       => xtx_probe_pass,
         rx_detect_valid  => xtx_rx_detect_valid,
         rx_found         => xtx_rx_found,
         sel_150r         => xtx_sel_150r,
         tx_dftout        => xtx_tx_dftout
      );
   
   -- driver outputs
   dataout <= xtx_vop;
   dftout <= xtx_tx_dftout;
   rxdetectvalidout <= xtx_rx_detect_valid;
   rxfoundout <= xtx_rx_found;
   
END trans;



-- ---------------------------------------------------------------------------
--  Model Implementation End                                                 -
-- ---------------------------------------------------------------------------

-- ***********************************************************
-- This WYSIWYG atom header was automatically generated by the
-- Atmgen build tool. To change it, alter data stored in the 
-- corresponding WYS file(s) in the tools/atmgen subdirectory.
-- ***********************************************************

-- *** Section 1 -- Header ***

-- -----------------------------------------------------------
--
-- Module Name : stratixiv_hssi_rx_pma
--
-- Description : DEV_FAMILY_STRATIXIV stratixiv_hssi_rx_pma Verilog simulation model
--
-- -----------------------------------------------------------

-- *** End of Section 1 ***

-- *** Section 3 -- Module declaration ***


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;
ENTITY stratixiv_hssi_rx_pma IS
   GENERIC (

          --  generic control parameters  --
       MsgOn                   : Boolean := DefGlitchMsgOn;
       XOn                     : Boolean := DefGlitchXOn;
       MsgOnChecks             : Boolean := DefMsgOnChecks;
       XOnChecks               : Boolean := DefXOnChecks;
       InstancePath            : String := "*";
       TimingChecksOn          : Boolean := True;
          --  tipd  :interconnect path delays --
      tipd_ppmdetectdividedclk                : VitalDelayType01 := DefpropDelay01;
      tipd_datain                : VitalDelayType01 := DefpropDelay01;
      tipd_rxpmareset                : VitalDelayType01 := DefpropDelay01;
      tipd_plllocked                : VitalDelayType01 := DefpropDelay01;
      tipd_dpriodisable                : VitalDelayType01 := DefpropDelay01;
      tipd_ignorephslck                : VitalDelayType01 := DefpropDelay01;
      tipd_locktoref                : VitalDelayType01 := DefpropDelay01;
      tipd_adcepowerdn                : VitalDelayType01 := DefpropDelay01;
      tipd_ppmdetectrefclk                : VitalDelayType01 := DefpropDelay01;
      tipd_adcestandby                : VitalDelayType01 := DefpropDelay01;
      tipd_powerdn                : VitalDelayType01 := DefpropDelay01;
      tipd_seriallpbken                : VitalDelayType01 := DefpropDelay01;
      tipd_adcereset                : VitalDelayType01 := DefpropDelay01;
      tipd_deserclock               :VitalDelayArrayType01(4 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_locktodata                : VitalDelayType01 := DefpropDelay01;
      tipd_freqlock                : VitalDelayType01 := DefpropDelay01;
      tipd_offsetcancellationen                : VitalDelayType01 := DefpropDelay01;
      tipd_testbussel               :VitalDelayArrayType01(4 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_recoverdatain               :VitalDelayArrayType01(2 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_seriallpbkin                : VitalDelayType01 := DefpropDelay01;
      tipd_dprioin               :VitalDelayArrayType01(300 - 1 DOWNTO 0)   := (OTHERS => DefPropDelay01);
      tipd_adaptcapture                : VitalDelayType01 := DefpropDelay01;
          --  tpd: Edge-Sensitive Paths --
          --  tpd: parallel and Full Connection Paths --
          --  tsetup and thold values : setup and hold times  --
          --  Pulse Width parameters  --
      
      -- *** End of Section 3 ***
      
      -- *** Section 4 -- Port size declarations ***
      
      -- *** End of Section 4 ***
      
      -- *** Section 5 -- Port declarations ***
      
      lpm_type                                  : STRING := "stratixiv_hssi_rx_pma";
      adaptive_equalization_mode                : STRING := "none";
      allow_serial_loopback                     : STRING := "false";
      allow_vco_bypass                          : INTEGER := 0;
      analog_power                              : STRING := "1.4V";
      channel_number                            : INTEGER := 0;
      channel_type                              : STRING := "auto";
      common_mode                               : STRING := "0.82V";
      deserialization_factor                    : INTEGER := 8;
      dfe_piclk_bandwidth                       : INTEGER := 0;
      dfe_piclk_phase                           : INTEGER := 0;
      dfe_piclk_sel                             : INTEGER := 0;
      dprio_config_mode                         : STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
      enable_ltd                                : STRING := "false";
      enable_ltr                                : STRING := "false";
      eq_adapt_seq_control                      : INTEGER := 0;
      eq_dc_gain                                : INTEGER := 0;
      eq_max_gradient_control                   : INTEGER := 0;
      eqa_ctrl                                  : INTEGER := 0;
      eqb_ctrl                                  : INTEGER := 0;
      eqc_ctrl                                  : INTEGER := 0;
      eqd_ctrl                                  : INTEGER := 0;
      eqv_ctrl                                  : INTEGER := 0;
      eyemon_bandwidth                          : INTEGER := 0;
      force_signal_detect                       : STRING := "true";
      ignore_lock_detect                        : STRING := "false";
      logical_channel_address                   : INTEGER := 0;
      low_speed_test_select                     : INTEGER := 0;
      offset_cancellation                       : INTEGER := 0;
      ppm_gen1_2_xcnt_en                        : INTEGER := 1;
      ppm_post_eidle                            : INTEGER := 0;
      ppmselect                                 : INTEGER := 0;
      protocol_hint                             : STRING := "basic";
      send_direct_reverse_serial_loopback       : STRING := "None";
      signal_detect_hysteresis                  : INTEGER := 4;
      signal_detect_hysteresis_valid_threshold  : INTEGER := 2;
      signal_detect_loss_threshold              : INTEGER := 3;
      termination                               : STRING := "OCT 100 Ohms";
      use_deser_double_data_width               : STRING := "false";
      use_external_termination                  : STRING := "false";
      use_pma_direct                            : STRING := "false";
      PARAM_DELAY                               : INTEGER := 0
   );
   PORT (
      adaptcapture                              : IN STD_LOGIC := '0';
      adcepowerdn                               : IN STD_LOGIC := '0';
      adcereset                                 : IN STD_LOGIC := '0';
      adcestandby                               : IN STD_LOGIC := '0';
      datain                                    : IN STD_LOGIC := '0';
      deserclock                                : IN STD_LOGIC_VECTOR(4 - 1 DOWNTO 0) := (others => '0');
      dpriodisable                              : IN STD_LOGIC := '1';
      dprioin                                   : IN STD_LOGIC_VECTOR(300 - 1 DOWNTO 0) := (others => '0');
      extra10gin                                : IN STD_LOGIC_VECTOR(38 - 1 DOWNTO 0) := (others => '0');
      freqlock                                  : IN STD_LOGIC := '0';
      ignorephslck                              : IN STD_LOGIC := '0';
      locktodata                                : IN STD_LOGIC := '0';
      locktoref                                 : IN STD_LOGIC := '0';
      offsetcancellationen                      : IN STD_LOGIC := '0';
      plllocked                                 : IN STD_LOGIC := '0';
      powerdn                                   : IN STD_LOGIC := '0';
      ppmdetectdividedclk                       : IN STD_LOGIC := '0';
      ppmdetectrefclk                           : IN STD_LOGIC := '0';
      recoverdatain                             : IN STD_LOGIC_VECTOR(2 - 1 DOWNTO 0) := (others => '0');
      rxpmareset                                : IN STD_LOGIC := '0';
      seriallpbken                              : IN STD_LOGIC := '0';
      seriallpbkin                              : IN STD_LOGIC := '0';
      testbussel                                : IN STD_LOGIC_VECTOR(4 - 1 DOWNTO 0) := (others => '0');
      adaptdone                                 : OUT STD_LOGIC;
      analogtestbus                             : OUT STD_LOGIC_VECTOR(8 - 1 DOWNTO 0);
      clockout                                  : OUT STD_LOGIC;
      dataout                                   : OUT STD_LOGIC;
      dataoutfull                               : OUT STD_LOGIC_VECTOR(20 - 1 DOWNTO 0);
      dprioout                                  : OUT STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);
      locktorefout                              : OUT STD_LOGIC;
      ppmdetectclkrel                           : OUT STD_LOGIC;
      recoverdataout                            : OUT STD_LOGIC_VECTOR(64 - 1 DOWNTO 0);
      reverselpbkout                            : OUT STD_LOGIC;
      revserialfdbkout                          : OUT STD_LOGIC;
      signaldetect                              : OUT STD_LOGIC
   );
END stratixiv_hssi_rx_pma;

ARCHITECTURE trans OF stratixiv_hssi_rx_pma IS

  signal ppmdetectdividedclk_ipd  :STD_LOGIC;
  signal datain_ipd  :STD_LOGIC;
  signal rxpmareset_ipd  :STD_LOGIC;
  signal plllocked_ipd  :STD_LOGIC;
  signal dpriodisable_ipd  :STD_LOGIC;
  signal ignorephslck_ipd  :STD_LOGIC;
  signal locktoref_ipd  :STD_LOGIC;
  signal adcepowerdn_ipd  :STD_LOGIC;
  signal ppmdetectrefclk_ipd  :STD_LOGIC;
  signal adcestandby_ipd  :STD_LOGIC;
  signal powerdn_ipd  :STD_LOGIC;
  signal seriallpbken_ipd  :STD_LOGIC;
  signal adcereset_ipd  :STD_LOGIC;
  signal deserclock_ipd  :STD_LOGIC_VECTOR(4 - 1 DOWNTO 0);
  signal locktodata_ipd  :STD_LOGIC;
  signal freqlock_ipd  :STD_LOGIC;
  signal offsetcancellationen_ipd  :STD_LOGIC;
  signal testbussel_ipd  :STD_LOGIC_VECTOR(4 - 1 DOWNTO 0);
  signal recoverdatain_ipd  :STD_LOGIC_VECTOR(2 - 1 DOWNTO 0);
  signal seriallpbkin_ipd  :STD_LOGIC;
  signal dprioin_ipd  :STD_LOGIC_VECTOR(300 - 1 DOWNTO 0);
  signal adaptcapture_ipd  :STD_LOGIC;
   COMPONENT stratixiv_hssi_pma_c_rlpbk_mux
      PORT (
         doddn                                     : IN STD_LOGIC;
         doddp                                     : IN STD_LOGIC;
         dodn                                      : IN STD_LOGIC;
         dodp                                      : IN STD_LOGIC;
         don                                       : IN STD_LOGIC;
         don_pre                                   : IN STD_LOGIC;
         dop                                       : IN STD_LOGIC;
         dop_pre                                   : IN STD_LOGIC;
         drxn                                      : IN STD_LOGIC;
         drxp                                      : IN STD_LOGIC;
         sel                                       : IN STD_LOGIC;
         vcce_la                                   : IN STD_LOGIC;
         voddn                                     : OUT STD_LOGIC;
         voddp                                     : OUT STD_LOGIC;
         vodn                                      : OUT STD_LOGIC;
         vodp                                      : OUT STD_LOGIC;
         von                                       : OUT STD_LOGIC;
         von_pre                                   : OUT STD_LOGIC;
         vop                                       : OUT STD_LOGIC;
         vop_pre                                   : OUT STD_LOGIC;
         vssex                                     : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_deser
      GENERIC (
         PARAM_DELAY                               : INTEGER := 0;
         RST_SD_PULSE_WIDTH                        : INTEGER := 1
      );
      PORT (
         clk90b                                    : IN STD_LOGIC;
         clk_divrx                                 : OUT STD_LOGIC;
         deser_div2                                : IN STD_LOGIC;
         deser_div5                                : IN STD_LOGIC;
         deser_pdb                                 : IN STD_LOGIC;
         deven                                     : IN STD_LOGIC;
         devenb                                    : IN STD_LOGIC;
         dodd                                      : IN STD_LOGIC;
         doddb                                     : IN STD_LOGIC;
         dout                                      : OUT STD_LOGIC_VECTOR(19 DOWNTO 0);
         fsd                                       : OUT STD_LOGIC;
         pcie_sw                                   : IN STD_LOGIC;
         pcieo                                     : OUT STD_LOGIC;
         rdynamic_sw                               : IN STD_LOGIC;
         rfast_sd                                  : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rst_n                                     : IN STD_LOGIC;
         rtest_fastsd                              : IN STD_LOGIC;
         rxinn                                     : IN STD_LOGIC;
         rxinp                                     : IN STD_LOGIC;
         vcce_la                                   : IN STD_LOGIC;
         vssexqyx                                  : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_deser_10g
      GENERIC (
         PARAM_DELAY                               : INTEGER := 0
      );
      PORT (
         clk90b                                    : IN STD_LOGIC;
         clk_divrx                                 : OUT STD_LOGIC;
         deser_pdb                                 : IN STD_LOGIC;
         deven                                     : IN STD_LOGIC;
         devenb                                    : IN STD_LOGIC;
         dodd                                      : IN STD_LOGIC;
         doddb                                     : IN STD_LOGIC;
         dout                                      : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         rst_n                                     : IN STD_LOGIC;
         vcce_la                                   : IN STD_LOGIC;
         vssexqyx                                  : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_adce
      PORT (
         adapt_capture                             : IN STD_LOGIC;
         adapt_done                                : OUT STD_LOGIC;
         atb0                                      : INOUT STD_LOGIC;
         atb1                                      : INOUT STD_LOGIC;
         atb_0                                     : INOUT STD_LOGIC;
         atb_1                                     : INOUT STD_LOGIC;
	 atben	 				   : IN  STD_LOGIC;
         atbsel                                    : IN STD_LOGIC_VECTOR(23 DOWNTO 0);
         e_clk                                     : OUT STD_LOGIC;
         eqa_ctrl                                  : OUT STD_LOGIC;
         eqa_set                                   : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         eqb_ctrl                                  : OUT STD_LOGIC;
         eqb_set                                   : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         eqc_ctrl                                  : OUT STD_LOGIC;
         eqc_set                                   : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         eqctrlout                                 : OUT STD_LOGIC_VECTOR(5 DOWNTO 0);
         eqd_ctrl                                  : OUT STD_LOGIC;
         eqd_set                                   : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         eqin_n                                    : IN STD_LOGIC;
         eqin_p                                    : IN STD_LOGIC;
         eqv_ctrl                                  : OUT STD_LOGIC;
         eqv_set                                   : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         fine_d2aout                               : OUT STD_LOGIC;
         fixed_clk                                 : IN STD_LOGIC;
         hf_adapt_done                             : OUT STD_LOGIC;
         hfclk_macro                               : OUT STD_LOGIC;
         hfmac_cnt0_nclr                           : OUT STD_LOGIC;
         hfmac_cnt2_nclr                           : OUT STD_LOGIC;
         ib50u_c                                   : INOUT STD_LOGIC;
         ib50u_t                                   : INOUT STD_LOGIC;
	 ibrgen1				   : OUT  STD_LOGIC;
	 ibrgen2				   : OUT  STD_LOGIC;
         lf_adapt_done                             : OUT STD_LOGIC;
         lfclk_macro                               : OUT STD_LOGIC;
         lfmac_cnt0_nclr                           : OUT STD_LOGIC;
         lfmac_cnt2_nclr                           : OUT STD_LOGIC;
         lock_lf_ovd                               : IN STD_LOGIC;
         lst                                       : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
         outeqn                                    : INOUT STD_LOGIC;
         outeqp                                    : INOUT STD_LOGIC;
         r_clk                                     : OUT STD_LOGIC;
         radce_adapt                               : IN STD_LOGIC;
         radce_digital                             : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
         radce_hflck                               : IN STD_LOGIC_VECTOR(14 DOWNTO 0);
         radce_lflck                               : IN STD_LOGIC_VECTOR(14 DOWNTO 0);
         radce_pdb                                 : IN STD_LOGIC;
         radce_rstb                                : IN STD_LOGIC;
	 radce_vod_int				   : IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
	 radce_vod_lsb				   : IN  STD_LOGIC;
         rbit_dc                                   : IN STD_LOGIC;
         rclkdiv                                   : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rd2a_res                                  : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rdc_freq                                  : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
	 rdfe_en				   : IN  STD_LOGIC;
         rf_hpf                                    : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rf_lpf                                    : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rgenctrlout                               : OUT STD_LOGIC_VECTOR(5 DOWNTO 0);
         rhf_os                                    : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rhyst_hf                                  : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rhyst_lf                                  : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rlf_os                                    : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rrect_adj                                 : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rrgen_bw                                  : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         rrgen_set                                 : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rrgen_vod                                 : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rseq_sel                                  : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         standby                                   : IN STD_LOGIC;
         tmxselan                                  : OUT STD_LOGIC;
         tmxselbn                                  : OUT STD_LOGIC;
         tmxselcn                                  : OUT STD_LOGIC;
         tmxseldn                                  : OUT STD_LOGIC;
         tmxselvn                                  : OUT STD_LOGIC;
         updnn_hf                                  : OUT STD_LOGIC;
         updnn_lf                                  : OUT STD_LOGIC;
         vbn                                       : IN STD_LOGIC;
         vccehxqyx                                 : INOUT STD_LOGIC;
         vccerxqyx                                 : INOUT STD_LOGIC;
         vctl_quiet                                : INOUT STD_LOGIC;
         vssexqyx                                  : INOUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_c_rx
      GENERIC (
         PARAM_DELAY                               : INTEGER := 0;
         INVALID_SD_ON_OFF                         : INTEGER := 500
      );
      PORT (
         analog_sd                                 : OUT STD_LOGIC;
         atb_0                                     : INOUT STD_LOGIC;
         atb_1                                     : INOUT STD_LOGIC;
         atbsel                                    : IN STD_LOGIC_VECTOR(5 DOWNTO 0);
         ck0_sigdet                                : IN STD_LOGIC;
         eqa_ctrl                                  : IN STD_LOGIC;
         eqb_ctrl                                  : IN STD_LOGIC;
         eqc_ctrl                                  : IN STD_LOGIC;
         eqd_ctrl                                  : IN STD_LOGIC;
         eqv_ctrl                                  : IN STD_LOGIC;
         ibc50u                                    : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         ibp50u                                    : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         ibp150u                                   : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         inn                                       : IN STD_LOGIC;
         inn3                                      : OUT STD_LOGIC;
         inp                                       : IN STD_LOGIC;
         inp3                                      : OUT STD_LOGIC;
         lpbkn                                     : IN STD_LOGIC;
         lpbkp                                     : IN STD_LOGIC;
         oc_calpd                                  : IN STD_LOGIC;
         oc_en                                     : IN STD_LOGIC;
         pdb                                       : IN STD_LOGIC;
         rbit_dc                                   : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rdlpbkn                                   : OUT STD_LOGIC;
         rdlpbkp                                   : OUT STD_LOGIC;
         refclk                                    : IN STD_LOGIC;
         rx_b50                                    : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         rx_oc                                     : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         rx_test                                   : IN STD_LOGIC;
         rx_testclk                                : IN STD_LOGIC;
         rxbuf_ibias                               : OUT STD_LOGIC;
         rxn                                       : OUT STD_LOGIC;
         rxp                                       : OUT STD_LOGIC;
         s_lpbk                                    : IN STD_LOGIC;
         s_rdlpbk                                  : IN STD_LOGIC;
         sd_cdr                                    : OUT STD_LOGIC;
         sd_cpon                                   : OUT STD_LOGIC;
         sd_cpop                                   : OUT STD_LOGIC;
         sd_force                                  : IN STD_LOGIC;
         sd_off                                    : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
         sd_on                                     : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         sdlv                                      : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
         term                                      : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         vcce_la                                   : IN STD_LOGIC;
         vcce_oa                                   : IN STD_LOGIC;
         vccehtxqyx                                : IN STD_LOGIC;
         vssexqyx                                  : IN STD_LOGIC;
         vtt                                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0)
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_pma_ppmdetect
      PORT (
         scan_mode                                 : IN STD_LOGIC;
         ppmsel                                    : IN STD_LOGIC_VECTOR(5 DOWNTO 0);
         fref                                      : IN STD_LOGIC;
         fvcobyn                                   : IN STD_LOGIC;
         pd                                        : IN STD_LOGIC;
         hard_reset                                : IN STD_LOGIC;
         rforcehigh                                : IN STD_LOGIC;
         rforcelow                                 : IN STD_LOGIC;
         freq_lock                                 : OUT STD_LOGIC;
         ppm_cnt_latch                             : OUT STD_LOGIC_VECTOR(6 DOWNTO 0);
         ppm_cnt_reset                             : IN STD_LOGIC
      );
   END COMPONENT;
   
   
   -- *** End of Section 5 ***
   
   -- *** Section 6 -- Parameter declarations and default values ***
   
   -- *** End of Section 6 ***
   
   -- *** Section 7 -- Port declarations with defaults, if any ***
   
   -- This section will always be empty for WYSIWYG atoms
   -- tri1 devclrn;		//sample
   
   -- *** End of Section 7 ***
   
   -- ---------------------------------------------------------------------------
   --  Model Implementation Begin                                               -
   -- ---------------------------------------------------------------------------
   
   -- Simulation only parameters
      
   -- ---------------------------------------------------------------------------
   --  Model / Submodule Instantiations                                         -
   -- ---------------------------------------------------------------------------
   
   -- ***************************************************************************
   --  -- uses only *_cram                                                      *
   --  -- should NOT use parameters nor *_dprioin                               *
   -- ***************************************************************************
   
   -- supply wires common to modules
   SIGNAL vcce_la                   : STD_LOGIC;
   SIGNAL vcce_oa                   : STD_LOGIC;
   SIGNAL vccehtx                   : STD_LOGIC;
   SIGNAL vssex                     : STD_LOGIC;
   
   -- input wires for c_adce
   
   SIGNAL xadce_atbsel               : STD_LOGIC_VECTOR(23 DOWNTO 0);
   SIGNAL xadce_adapt_capture        : STD_LOGIC;
   SIGNAL xadce_atben                : STD_LOGIC;
   SIGNAL xadce_eqin_n               : STD_LOGIC;
   SIGNAL xadce_eqin_p               : STD_LOGIC;
   SIGNAL xadce_fixed_clk            : STD_LOGIC;
   SIGNAL xadce_pdb                  : STD_LOGIC;
   SIGNAL xadce_rdfe_en              : STD_LOGIC;
   SIGNAL xadce_rstb                 : STD_LOGIC;
   SIGNAL xadce_standby              : STD_LOGIC;
   SIGNAL radce_digital             : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL radce_hflck               : STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL radce_lflck               : STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL rclkdiv                   : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rd2a_res                  : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rdc_freq                  : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rf_hpf                    : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rf_lpf                    : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rhf_os                    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rhyst_hf                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rhyst_lf                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rlf_os                    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rrect_adj                 : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rrgen_bw                  : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL rrgen_set                 : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rrgen_vod                 : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rseq_sel                  : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL radce_vod_int             : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL radce_vod_lsb             : STD_LOGIC;
   
   SIGNAL reqa_set                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL reqb_set                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL reqc_set                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL reqd_set                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL reqv_set                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rrx_lst                   : STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- supply wires for adce
   SIGNAL vccehxqyx                 : STD_LOGIC;
   SIGNAL vccerxqyx                 : STD_LOGIC;
   SIGNAL vssexqyx                  : STD_LOGIC;
   
   -- assign the inputs
   
   -- output wires
   
   SIGNAL xadce_adapt_done           : STD_LOGIC;
   SIGNAL xadce_eqctrlout                 : STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL xadce_rgenctrlout               : STD_LOGIC_VECTOR(5 DOWNTO 0);
   
   SIGNAL eqa_ctrl_wire             : STD_LOGIC;
   SIGNAL eqb_ctrl_wire             : STD_LOGIC;
   SIGNAL eqc_ctrl_wire             : STD_LOGIC;
   SIGNAL eqd_ctrl_wire             : STD_LOGIC;
   SIGNAL eqv_ctrl_wire             : STD_LOGIC;
   
   SIGNAL xadce_rxn                 : STD_LOGIC;
   SIGNAL xadce_rxp                 : STD_LOGIC;
   SIGNAL xadce_ib50u_c             : STD_LOGIC;
   SIGNAL xadce_ib50u_t             : STD_LOGIC;
   SIGNAL xadce_lock_lf_ovd         : STD_LOGIC;
   SIGNAL radce_adapt               : STD_LOGIC;
   SIGNAL xadce_vbn                 : STD_LOGIC;
   
   SIGNAL atb_0                     : STD_LOGIC;
   SIGNAL atb_1                     : STD_LOGIC;
   SIGNAL adce_rxn                  : STD_LOGIC;
   SIGNAL adce_rxp                  : STD_LOGIC;
   
   SIGNAL xadce_atb0                : STD_LOGIC;
   SIGNAL xadce_atb1                : STD_LOGIC;
   SIGNAL xadce_fine_d2aout               : STD_LOGIC;
   SIGNAL xadce_hf_clk                    : STD_LOGIC;
   SIGNAL xadce_hf_adapt_done             : STD_LOGIC;
   SIGNAL xadce_hfclk_macro               : STD_LOGIC;
   SIGNAL xadce_hfmac_cnt0_nclr           : STD_LOGIC;
   SIGNAL xadce_hfmac_cnt2_nclr           : STD_LOGIC;
   SIGNAL xadce_ibrgen1                   : STD_LOGIC;
   SIGNAL xadce_ibrgen2                   : STD_LOGIC;
   SIGNAL xadce_lf_adapt_done             : STD_LOGIC;
   SIGNAL xadce_lfclk_macro               : STD_LOGIC;
   SIGNAL xadce_lfmac_cnt0_nclr           : STD_LOGIC;
   SIGNAL xadce_lfmac_cnt2_nclr           : STD_LOGIC;
   SIGNAL xadce_lf_clk                    : STD_LOGIC;
   SIGNAL xadce_tmxselan                  : STD_LOGIC;
   SIGNAL xadce_tmxselbn                  : STD_LOGIC;
   SIGNAL xadce_tmxselcn                  : STD_LOGIC;
   SIGNAL xadce_tmxseldn                  : STD_LOGIC;
   SIGNAL xadce_tmxselvn                  : STD_LOGIC;
   SIGNAL xadce_updnn_hf                  : STD_LOGIC;
   SIGNAL xadce_updnn_lf                  : STD_LOGIC;
   SIGNAL xadce_vctl_quiet                : STD_LOGIC;
   
   -- input wires for c_rx
   SIGNAL rx_atbsel                 : STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL ck0_sigdet                : STD_LOGIC;
   SIGNAL ibp50u                    : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL ibc50u                    : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL ibp150u                   : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL lpbkn                     : STD_LOGIC;
   SIGNAL lpbkp                     : STD_LOGIC;
   SIGNAL rx_refclk                 : STD_LOGIC;
   SIGNAL rs_lpbk                   : STD_LOGIC;
   SIGNAL rx_50                     : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rx_n                      : STD_LOGIC;
   SIGNAL rx_p                      : STD_LOGIC;
   SIGNAL rrx_bit_dc                : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rrx_oc                    : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL rx_pdb                    : STD_LOGIC;
   SIGNAL rrx_sd_force              : STD_LOGIC;
   SIGNAL rrx_sd_off                : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL rrx_sd_on                 : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rrx_sdlv                  : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL rrx_term                  : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rrx_test                  : STD_LOGIC;
   SIGNAL rx_testclk                : STD_LOGIC;
   SIGNAL rrx_vtt                   : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- output wires
   SIGNAL analog_sd_icd             : STD_LOGIC;
   SIGNAL analog_sd_sw              : STD_LOGIC;
   SIGNAL analog_sd                 : STD_LOGIC;
   SIGNAL cdr_rxn                   : STD_LOGIC;
   SIGNAL cdr_rxp                   : STD_LOGIC;
   SIGNAL sd_cdr                    : STD_LOGIC;
   SIGNAL rx_rlpbkp                 : STD_LOGIC;		-- to lpbk_mux
   SIGNAL rx_rlpbkn                 : STD_LOGIC;		-- to lpbk_mux
   SIGNAL wire_sd_cpon              : STD_LOGIC;
   SIGNAL wire_sd_cpop              : STD_LOGIC;
   SIGNAL rx_eqout_n                : STD_LOGIC;
   SIGNAL rx_eqout_p                : STD_LOGIC;

   -- connect inputs
   --filtering X/Z
   --prevent x/z propagate to gate netlist
   SIGNAL rrx_oc_en                 : STD_LOGIC;
   SIGNAL rrx_s_rdlpbk              : STD_LOGIC;
      
   -- c_rx instance
   SIGNAL wire_oc_calpd             : STD_LOGIC;
   SIGNAL vccehtxqyx                : STD_LOGIC;
   
   SIGNAL wire_rxbuf_ibias          : STD_LOGIC;
   
   -- outputs from the c_rx
   
   -- simplified signal detect model like S2GX - SW ----------------
   -- input
   SIGNAL sd_rx                     : STD_LOGIC;
   SIGNAL sd_reset                  : STD_LOGIC;
   -- output
   SIGNAL signaldetect_reg          : STD_LOGIC := '0';
   
   -- PPMDETECT MODULE
   -- ppmdetect module input wires
   SIGNAL ppmdetect_fref_in         : STD_LOGIC;
   SIGNAL ppmdetect_fvcobyn_in      : STD_LOGIC;
   SIGNAL ppmdetect_hardreset_in    : STD_LOGIC;
   SIGNAL ppmdetect_pd_in           : STD_LOGIC;
   SIGNAL ppmdetect_ppmcntreset_in  : STD_LOGIC;
   SIGNAL ppmdetect_ppmsel_in       : STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL ppmdetect_scanmode_in     : STD_LOGIC;
   SIGNAL ppmdetect_rforcehigh_in   : STD_LOGIC;
   SIGNAL ppmdetect_rforcelow_in    : STD_LOGIC;
   
   -- output wires
   SIGNAL ppmdetect_freqlock_out    : STD_LOGIC;
   SIGNAL ppmdetect_ppmcntlatch_out : STD_LOGIC_VECTOR(6 DOWNTO 0);
    
   -- simplified freqlock behavior:
   --  (1). Responding to rising edge of rxpll_lock with small counter;
   --  (2). Responding to analogreset
   --  (3). Not responding to loss of rxpll_lock
   
   -- freqlock
   SIGNAL mrxpll_not_locked         : STD_LOGIC;
   SIGNAL mfreqlocked_reg           : STD_LOGIC := '0';
   SIGNAL mfreqlocked_cnt           : STD_LOGIC_VECTOR(3 DOWNTO 0) := "0000";
   
   SIGNAL signal_detect_reg_n       : STD_LOGIC;
   
   SIGNAL lck2refctl_freqlock_in    : STD_LOGIC;
   
   -- CDR
   -- input wires for cdr
   SIGNAL ltd                       : STD_LOGIC;
   SIGNAL ltr                       : STD_LOGIC;
   SIGNAL ignore_phslck             : STD_LOGIC;
   
   SIGNAL devenout                  : STD_LOGIC;
   SIGNAL devenbout                 : STD_LOGIC;
   SIGNAL doddout                   : STD_LOGIC;
   SIGNAL oddbout                   : STD_LOGIC;
   SIGNAL doddx                     : STD_LOGIC;
   SIGNAL oddbx                     : STD_LOGIC;
   SIGNAL oe1                       : STD_LOGIC;
   SIGNAL oeb1                      : STD_LOGIC;
   SIGNAL oo1                       : STD_LOGIC;
   SIGNAL oob1                      : STD_LOGIC;
   SIGNAL oe2                       : STD_LOGIC;
   SIGNAL oeb2                      : STD_LOGIC;
   SIGNAL oo2                       : STD_LOGIC;
   SIGNAL oob2                      : STD_LOGIC;
   SIGNAL rxlpbp_int                : STD_LOGIC;
   SIGNAL rxlpbn_int                : STD_LOGIC;
   SIGNAL rxlpbdp_int               : STD_LOGIC;
   SIGNAL rxlpbdn_int               : STD_LOGIC;
   
   SIGNAL deven                     : STD_LOGIC;
   SIGNAL devenb                    : STD_LOGIC;
   SIGNAL dodd                      : STD_LOGIC;
   SIGNAL doddb                     : STD_LOGIC;
   
   SIGNAL cdr_pdb                   : STD_LOGIC;
   SIGNAL ck0_pd                    : STD_LOGIC;
   SIGNAL ck90_pd                   : STD_LOGIC;
   SIGNAL ck180_pd                  : STD_LOGIC;
   SIGNAL ck270_pd                  : STD_LOGIC;
   SIGNAL clk90_slpbk               : STD_LOGIC;
   SIGNAL clk270_slpbk              : STD_LOGIC;
   SIGNAL lck2ref                   : STD_LOGIC;
   SIGNAL pdbx                      : STD_LOGIC;
   SIGNAL pe                        : STD_LOGIC;
   SIGNAL rlbk                      : STD_LOGIC;
   SIGNAL rlpbk_pre_en              : STD_LOGIC;
   SIGNAL rstb_slpbk                : STD_LOGIC;
   SIGNAL rst_n                     : STD_LOGIC;
   SIGNAL rstn2                     : STD_LOGIC;
   SIGNAL rxpll_lock                : STD_LOGIC;
   SIGNAL rxlpbp                    : STD_LOGIC;
   SIGNAL rxlpbn                    : STD_LOGIC;
   SIGNAL rxlpbdp                   : STD_LOGIC;
   SIGNAL rxlpbdn                   : STD_LOGIC;
   
   -- connect inputs
   
   -- * * c_lck2refctl * *
   --     ltd ? 1'b0 :  **** lack ltr/ltd control logic ***
   --    (~sd_cdr | ~lck2refctl_freqlock_in | ltr ) ? 1'b1 :
   
   -- rclk_mon
   --   assign { rxlpbp, rxlpbn} = rclk_mon ? { clk90_slpbk, ~clk90_slpbk} : { rxlpbp_int, rxlpbn_int};
   --   assign {rxlpbdp,rxlpbdn} = rclk_mon ? {clk270_slpbk,~clk270_slpbk} : {rxlpbdp_int,rxlpbdn_int};
   
   -- outputs from the c_cdr
   
   --//////////////end cdr
   
   -- input wires for loopback_mux
   SIGNAL rrevlb_sw                 : STD_LOGIC;
   
   -- output wires
   
   SIGNAL cdr_rlpbkn                : STD_LOGIC;
   SIGNAL cdr_rlpbkp                : STD_LOGIC;
   
   SIGNAL cdr_rlpbkdn               : STD_LOGIC;
   SIGNAL cdr_rlpbkdp               : STD_LOGIC;
   
   SIGNAL ncvondp                   : STD_LOGIC;
   SIGNAL ncvopdp                   : STD_LOGIC;
   SIGNAL rlpbkdn                   : STD_LOGIC;
   SIGNAL rlpbkdp                   : STD_LOGIC;
   SIGNAL rlpbkn                    : STD_LOGIC;
   SIGNAL ncvonp                    : STD_LOGIC;
   SIGNAL rlpbkp                    : STD_LOGIC;
   SIGNAL ncvopp                    : STD_LOGIC;
   
   -- outputs from the lpbk_mux
   
   -- input wires for the deserializer
   SIGNAL xdeser_clk90_in           : STD_LOGIC;
   SIGNAL xdeser_pdb_in             : STD_LOGIC;
   SIGNAL xdeser_rst_n              : STD_LOGIC;
   SIGNAL xdeser_pcie_sw            : STD_LOGIC;
   SIGNAL xdeser_div2_in            : STD_LOGIC;
   SIGNAL xdeser_div5_in            : STD_LOGIC;
   SIGNAL rdynamic_sw               : STD_LOGIC;
   SIGNAL rfast_sd                  : STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- input wires for the 10g deserializer
   SIGNAL xdeser_10g_clk90b         : STD_LOGIC;
   SIGNAL xdeser_10g_pdb            : STD_LOGIC;
   SIGNAL xdeser_10g_deven          : STD_LOGIC;
   SIGNAL xdeser_10g_devenb         : STD_LOGIC;
   SIGNAL xdeser_10g_dodd           : STD_LOGIC;
   SIGNAL xdeser_10g_doddb          : STD_LOGIC;
   SIGNAL xdeser_10g_rst_n          : STD_LOGIC;
   
   -- output wires
   SIGNAL xdeser_clkdivrx_out       : STD_LOGIC;
   SIGNAL xdeser_dout_out           : STD_LOGIC_VECTOR(19 DOWNTO 0);
   SIGNAL xdeser_fsd_out            : STD_LOGIC;
   SIGNAL xdeser_pcieo_out          : STD_LOGIC;
   
   -- 10g output wires
   SIGNAL xdeser_10g_clk_divrx      : STD_LOGIC;
   SIGNAL xdeser_10g_dout           : STD_LOGIC_VECTOR(63 DOWNTO 0);
   
   SIGNAL wire_rtest_fastsd         : STD_LOGIC;
  
   -- Table36: PMA Per Channel RX Control Register 1 for Channel 0
   constant rrx_term_sel_RXPMA_IDX_0	: integer := 0;
   constant rrx_term_sel_RXPMA_IDX_1	: integer := 1;
   constant rrx_term_sel_RXPMA_IDX_2	: integer := 2;
   constant rrx_vtt_RXPMA_IDX_0	: integer := 3;
   constant rrx_vtt_RXPMA_IDX_1	: integer := 4;
   constant rrx_vtt_RXPMA_IDX_2	: integer := 5;
   constant rrx_s_rdlpbk_RXPMA_IDX_0	: integer := 6;
   constant rrx_bit_dc_RXPMA_IDX_0	: integer := 7;
   constant rrx_bit_dc_RXPMA_IDX_1	: integer := 8;
   constant rrx_bit_dc_RXPMA_IDX_2	: integer := 9;
   constant rrx_bit_dc_RXPMA_IDX_3	: integer := 10;
   constant rrx_lst_RXPMA_IDX_0	: integer := 11;
   constant rrx_lst_RXPMA_IDX_1	: integer := 12;
   constant rrx_lst_RXPMA_IDX_2	: integer := 13;
   constant rrx_lst_RXPMA_IDX_3	: integer := 14;
   constant rrx_lst_RXPMA_IDX_4	: integer := 15;
   
   -- Table37: PMA Per Channel RX Control Register 2 for Channel 0
   constant rrxurstpma_RXPMA_IDX_0	: integer := 16;
   constant rrx_test_RXPMA_IDX_0	: integer := 17;
   constant rrx_sd_force_RXPMA_IDX_0	: integer := 18;
   constant rrx_oc_RXPMA_IDX_0	: integer := 19;
   constant rrx_oc_RXPMA_IDX_1	: integer := 20;
   constant rrx_oc_RXPMA_IDX_2	: integer := 21;
   constant rrx_oc_RXPMA_IDX_3	: integer := 22;
   constant rrx_oc_RXPMA_IDX_4	: integer := 23;
   constant rrx_oc_RXPMA_IDX_5	: integer := 24;
   constant rrx_oc_RXPMA_IDX_6	: integer := 25;
   constant rrx_oc_RXPMA_IDX_7	: integer := 26;
   constant rrx_oc_en_RXPMA_IDX_0	: integer := 27;
   constant rrx_sdlv_RXPMA_IDX_0	: integer := 28;
   constant rrx_sdlv_RXPMA_IDX_1	: integer := 29;
   constant rrx_sdlv_RXPMA_IDX_2	: integer := 30;
   constant rrx_sdlv_RXPMA_IDX_3	: integer := 31;
   
   -- Table38: PMA Per Channel RX Control Register 3 for Channel 0
   constant reserved_0_TB38_RXPMA_IDX_0	: integer := 32;
   constant reserved_0_TB38_RXPMA_IDX_1	: integer := 33;
   constant reserved_0_TB38_RXPMA_IDX_2	: integer := 34;
   constant rpowdnr_RXPMA_IDX_0	: integer := 35;
   constant rrx_ib_pdb_RXPMA_IDX_0	: integer := 36;
   constant rurx_pdb_RXPMA_IDX_0	: integer := 37;
   constant rrx_oc_calpd_RXPMA_IDX_0	: integer := 38;
   constant rrx_sd_off_RXPMA_IDX_0	: integer := 39;
   constant rrx_sd_off_RXPMA_IDX_1	: integer := 40;
   constant rrx_sd_off_RXPMA_IDX_2	: integer := 41;
   constant rrx_sd_off_RXPMA_IDX_3	: integer := 42;
   constant rrx_sd_off_RXPMA_IDX_4	: integer := 43;
   constant rrx_sd_on_RXPMA_IDX_0	: integer := 44;
   constant rrx_sd_on_RXPMA_IDX_1	: integer := 45;
   constant rrx_sd_on_RXPMA_IDX_2	: integer := 46;
   constant rrx_sd_on_RXPMA_IDX_3	: integer := 47;
   
   -- Table43: PMA Per Channel RX Control Register 8 for Channel 0
   constant reye_monitor_RXPMA_IDX_0	: integer := 112;
   constant reye_monitor_RXPMA_IDX_1	: integer := 113;
   constant reye_monitor_RXPMA_IDX_2	: integer := 114;
   constant reye_monitor_RXPMA_IDX_3	: integer := 115;
   constant reye_monitor_RXPMA_IDX_4	: integer := 116;
   constant reye_monitor_RXPMA_IDX_5	: integer := 117;
   constant reye_monitor_RXPMA_IDX_6	: integer := 118;
   constant reye_monitor_RXPMA_IDX_7	: integer := 119;
   constant reserved_0_TB43_RXPMA_IDX_0	: integer := 120;
   constant reserved_0_TB43_RXPMA_IDX_1	: integer := 121;
   constant reserved_0_TB43_RXPMA_IDX_2	: integer := 122;
   constant reserved_0_TB43_RXPMA_IDX_3	: integer := 123;
   constant reserved_0_TB43_RXPMA_IDX_4	: integer := 124;
   constant reserved_0_TB43_RXPMA_IDX_5	: integer := 125;
   constant reserved_0_TB43_RXPMA_IDX_6	: integer := 126;
   constant reserved_0_TB43_RXPMA_IDX_7	: integer := 127;
   
   -- Table44: PMA Per Channel RX Control Register 9 for Channel 0
   constant rpma_reserved_0_TB44_RXPMA_IDX_0	: integer := 128;
   constant rpma_reserved_0_TB44_RXPMA_IDX_1	: integer := 129;
   constant rpma_reserved_0_TB44_RXPMA_IDX_2	: integer := 130;
   constant rpma_reserved_0_TB44_RXPMA_IDX_3	: integer := 131;
   constant rpma_reserved_0_TB44_RXPMA_IDX_4	: integer := 132;
   constant rpma_reserved_0_TB44_RXPMA_IDX_5	: integer := 133;
   constant rpma_reserved_0_TB44_RXPMA_IDX_6	: integer := 134;
   constant rpma_reserved_0_TB44_RXPMA_IDX_7	: integer := 135;
   constant rpma_reserved_0_TB44_RXPMA_IDX_8	: integer := 136;
   constant rpma_reserved_0_TB44_RXPMA_IDX_9	: integer := 137;
   constant rpma_reserved_0_TB44_RXPMA_IDX_10	: integer := 138;
   constant rpma_reserved_0_TB44_RXPMA_IDX_11	: integer := 139;
   constant rpma_reserved_0_TB44_RXPMA_IDX_12	: integer := 140;
   constant rpma_reserved_0_TB44_RXPMA_IDX_13	: integer := 141;
   constant rpma_reserved_0_TB44_RXPMA_IDX_14	: integer := 142;
   constant rpma_reserved_0_TB44_RXPMA_IDX_15	: integer := 143;
   
   -- Table45: PMA Per Channel RX Control Register 10 for Channel 0
   constant rppm_cnt_reset_RXPMA_IDX_0	: integer := 144;
   constant rforce1_freqdet_RXPMA_IDX_0	: integer := 145;
   constant rforce0_freqdet_RXPMA_IDX_0	: integer := 146;
   constant rppmsel_RXPMA_IDX_0	: integer := 147;
   constant rppmsel_RXPMA_IDX_1	: integer := 148;
   constant rppmsel_RXPMA_IDX_2	: integer := 149;
   constant rppmsel_RXPMA_IDX_3	: integer := 150;
   constant rppmsel_RXPMA_IDX_4	: integer := 151;
   constant rppmsel_RXPMA_IDX_5	: integer := 152;
   constant rfastsd_RXPMA_IDX_0	: integer := 153;
   constant rfastsd_RXPMA_IDX_1	: integer := 154;
   constant rfastsd_RXPMA_IDX_2	: integer := 155;
   constant rfastsd_RXPMA_IDX_3	: integer := 156;
   constant rtest_fastsd_RXPMA_IDX_0	: integer := 157;
   constant rpmadwidth_rx_RXPMA_IDX_0	: integer := 158;
   constant rpma_doublewidth_rx_RXPMA_IDX_0	: integer := 159;
   
   -- Table46: PMA Per Channel RX Control Register 11 for Channel 0
   constant reserved_0_TB46_RXPMA_IDX_0	: integer := 160;
   constant reserved_0_TB46_RXPMA_IDX_1	: integer := 161;
   constant reserved_0_TB46_RXPMA_IDX_2	: integer := 162;
   constant reserved_0_TB46_RXPMA_IDX_3	: integer := 163;
   constant reserved_0_TB46_RXPMA_IDX_4	: integer := 164;
   constant reserved_0_TB46_RXPMA_IDX_5	: integer := 165;
   constant reserved_0_TB46_RXPMA_IDX_6	: integer := 166;
   constant reserved_0_TB46_RXPMA_IDX_7	: integer := 167;
   constant rppm_gen1_2xcnt_en_RXPMA_IDX_0	: integer := 168;
   constant rppm_post_eidle_del_RXPMA_IDX_0	: integer := 169;
   constant r_dfe_2t_RXPMA_IDX_0	: integer := 170;
   constant r_dfe_2t_RXPMA_IDX_1	: integer := 171;
   constant r_dfe_2t_RXPMA_IDX_2	: integer := 172;
   constant r_dfe_1t_RXPMA_IDX_0	: integer := 173;
   constant r_dfe_1t_RXPMA_IDX_1	: integer := 174;
   constant r_dfe_1t_RXPMA_IDX_2	: integer := 175;
   
   -- Table47: PMA Per Channel RX Control Register 12 for Channel 0
   constant reqv_set_RXPMA_IDX_0	: integer := 176;
   constant reqv_set_RXPMA_IDX_1	: integer := 177;
   constant reqv_set_RXPMA_IDX_2	: integer := 178;
   constant reqd_set_RXPMA_IDX_0	: integer := 179;
   constant reqd_set_RXPMA_IDX_1	: integer := 180;
   constant reqd_set_RXPMA_IDX_2	: integer := 181;
   constant reqc_set_RXPMA_IDX_0	: integer := 182;
   constant reqc_set_RXPMA_IDX_1	: integer := 183;
   constant reqc_set_RXPMA_IDX_2	: integer := 184;
   constant reqb_set_RXPMA_IDX_0	: integer := 185;
   constant reqb_set_RXPMA_IDX_1	: integer := 186;
   constant reqb_set_RXPMA_IDX_2	: integer := 187;
   constant reqa_set_RXPMA_IDX_0	: integer := 188;
   constant reqa_set_RXPMA_IDX_1	: integer := 189;
   constant reqa_set_RXPMA_IDX_2	: integer := 190;
   constant reserved_0_TB47_RXPMA_IDX_0	: integer := 191;
   
   -- Table48: PMA Per Channel RX Control Register 13 for Channel 0
   constant rdc_freq_RXPMA_IDX_0	: integer := 192;
   constant rdc_freq_RXPMA_IDX_1	: integer := 193;
   constant rhyst_lf_RXPMA_IDX_0	: integer := 194;
   constant rhyst_lf_RXPMA_IDX_1	: integer := 195;
   constant rhyst_lf_RXPMA_IDX_2	: integer := 196;
   constant rclkdiv_RXPMA_IDX_0	: integer := 197;
   constant rclkdiv_RXPMA_IDX_1	: integer := 198;
   constant rclkdiv_RXPMA_IDX_2	: integer := 199;
   constant rclkdiv_RXPMA_IDX_3	: integer := 200;
   constant rrgen_set_RXPMA_IDX_0	: integer := 201;
   constant rrgen_set_RXPMA_IDX_1	: integer := 202;
   constant rrgen_set_RXPMA_IDX_2	: integer := 203;
   constant radce_adapt_RXPMA_IDX_0	: integer := 204;
   constant rseq_sel_RXPMA_IDX_0	: integer := 205;
   constant rseq_sel_RXPMA_IDX_1	: integer := 206;
   constant rlock_lf_ovd_RXPMA_IDX_0	: integer := 207;
   
   -- Table49: PMA Per Channel RX Control Register 14 for Channel 0
   constant rrgen_vod_RXPMA_IDX_0	: integer := 208;
   constant rrgen_vod_RXPMA_IDX_1	: integer := 209;
   constant rrgen_vod_RXPMA_IDX_2	: integer := 210;
   constant rf_hpf_RXPMA_IDX_0	: integer := 211;
   constant rf_hpf_RXPMA_IDX_1	: integer := 212;
   constant rf_lpf_RXPMA_IDX_0	: integer := 213;
   constant rf_lpf_RXPMA_IDX_1	: integer := 214;
   constant reserved_1_TB49_RXPMA_IDX_0	: integer := 215;
   constant reserved_1_TB49_RXPMA_IDX_1	: integer := 216;
   constant reserved_1_TB49_RXPMA_IDX_2	: integer := 217;
   constant reserved_0_TB49_RXPMA_IDX_0	: integer := 218;
   constant reserved_0_TB49_RXPMA_IDX_1	: integer := 219;
   constant reserved_0_TB49_RXPMA_IDX_2	: integer := 220;
   constant rhyst_hf_RXPMA_IDX_0	: integer := 221;
   constant rhyst_hf_RXPMA_IDX_1	: integer := 222;
   constant rhyst_hf_RXPMA_IDX_2	: integer := 223;
   
   -- Table50: PMA Per Channel RX Control Register 15 for Channel 0
   constant radce_pdb_RXPMA_IDX_0	: integer := 224;
   constant radce_rst_RXPMA_IDX_0	: integer := 225;
   constant rhf_os_RXPMA_IDX_0	: integer := 226;
   constant rhf_os_RXPMA_IDX_1	: integer := 227;
   constant rhf_os_RXPMA_IDX_2	: integer := 228;
   constant rhf_os_RXPMA_IDX_3	: integer := 229;
   constant rlf_os_RXPMA_IDX_0	: integer := 230;
   constant rlf_os_RXPMA_IDX_1	: integer := 231;
   constant rlf_os_RXPMA_IDX_2	: integer := 232;
   constant rlf_os_RXPMA_IDX_3	: integer := 233;
   constant rd2a_res_RXPMA_IDX_0	: integer := 234;
   constant rd2a_res_RXPMA_IDX_1	: integer := 235;
   constant rrect_adj_RXPMA_IDX_0	: integer := 236;
   constant rrect_adj_RXPMA_IDX_1	: integer := 237;
   constant rrgen_bw_RXPMA_IDX_0	: integer := 238;
   constant rrgen_bw_RXPMA_IDX_1	: integer := 239;
   
   -- Table51: PMA Per Channel RX Control Register 16 for Channel 0
   constant radce_hflck_RXPMA_IDX_0	: integer := 240;
   constant radce_hflck_RXPMA_IDX_1	: integer := 241;
   constant radce_hflck_RXPMA_IDX_2	: integer := 242;
   constant radce_hflck_RXPMA_IDX_3	: integer := 243;
   constant radce_hflck_RXPMA_IDX_4	: integer := 244;
   constant radce_hflck_RXPMA_IDX_5	: integer := 245;
   constant radce_hflck_RXPMA_IDX_6	: integer := 246;
   constant radce_hflck_RXPMA_IDX_7	: integer := 247;
   constant radce_hflck_RXPMA_IDX_8	: integer := 248;
   constant radce_hflck_RXPMA_IDX_9	: integer := 249;
   constant radce_hflck_RXPMA_IDX_10	: integer := 250;
   constant radce_hflck_RXPMA_IDX_11	: integer := 251;
   constant radce_hflck_RXPMA_IDX_12	: integer := 252;
   constant radce_hflck_RXPMA_IDX_13	: integer := 253;
   constant radce_hflck_RXPMA_IDX_14	: integer := 254;
   constant reserved_0_TB51_RXPMA_IDX_0	: integer := 255;
   
   -- Table52: PMA Per Channel RX Control Register 17 for Channel 0
   constant radce_lflck_RXPMA_IDX_0	: integer := 256;
   constant radce_lflck_RXPMA_IDX_1	: integer := 257;
   constant radce_lflck_RXPMA_IDX_2	: integer := 258;
   constant radce_lflck_RXPMA_IDX_3	: integer := 259;
   constant radce_lflck_RXPMA_IDX_4	: integer := 260;
   constant radce_lflck_RXPMA_IDX_5	: integer := 261;
   constant radce_lflck_RXPMA_IDX_6	: integer := 262;
   constant radce_lflck_RXPMA_IDX_7	: integer := 263;
   constant radce_lflck_RXPMA_IDX_8	: integer := 264;
   constant radce_lflck_RXPMA_IDX_9	: integer := 265;
   constant radce_lflck_RXPMA_IDX_10	: integer := 266;
   constant radce_lflck_RXPMA_IDX_11	: integer := 267;
   constant radce_lflck_RXPMA_IDX_12	: integer := 268;
   constant radce_lflck_RXPMA_IDX_13	: integer := 269;
   constant radce_lflck_RXPMA_IDX_14	: integer := 270;
   constant reserved_0_TB52_RXPMA_IDX_0	: integer := 271;
   
   -- Table53: PMA Per Channel RX Control Register 18 for Channel 0
   constant radce_digital_RXPMA_IDX_0	: integer := 272;
   constant radce_digital_RXPMA_IDX_1	: integer := 273;
   constant radce_digital_RXPMA_IDX_2	: integer := 274;
   constant radce_digital_RXPMA_IDX_3	: integer := 275;
   constant radce_digital_RXPMA_IDX_4	: integer := 276;
   constant radce_digital_RXPMA_IDX_5	: integer := 277;
   constant radce_digital_RXPMA_IDX_6	: integer := 278;
   constant radce_digital_RXPMA_IDX_7	: integer := 279;
   constant radce_digital_RXPMA_IDX_8	: integer := 280;
   constant radce_digital_RXPMA_IDX_9	: integer := 281;
   constant reserved_0_TB53_RXPMA_IDX_0	: integer := 282;
   constant reserved_0_TB53_RXPMA_IDX_1	: integer := 283;
   constant reserved_0_TB53_RXPMA_IDX_2	: integer := 284;
   constant reserved_0_TB53_RXPMA_IDX_3	: integer := 285;
   constant reserved_0_TB53_RXPMA_IDX_4	: integer := 286;
   constant reserved_0_TB53_RXPMA_IDX_5	: integer := 287;
   
   -- Extra
   constant RLPBK_RXPMA_IDX             : integer := 290;
   constant RREVLB_SW_RXPMA_IDX         : integer := 291;
   constant RRX_S_LPBK_RXPMA_IDX        : integer := 292;

   -- ---------------------------------------------------------------------------
   -- DPRIO input CRAM  
   -- ---------------------------------------------------------------------------
   
   -- PMA Per Channel RX Control Register 1 for Channel 0
   SIGNAL dprioin_rrx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rrx_vtt	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rrx_s_rdlpbk	: STD_LOGIC;
   SIGNAL dprioin_rrx_bit_dc	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rrx_lst	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 2 for Channel 0
   SIGNAL dprioin_rrxurstpma	: STD_LOGIC;
   SIGNAL dprioin_rrx_test	: STD_LOGIC;
   SIGNAL dprioin_rrx_sd_force	: STD_LOGIC;
   SIGNAL dprioin_rrx_oc	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL dprioin_rrx_oc_en	: STD_LOGIC;
   SIGNAL dprioin_rrx_sdlv	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 3 for Channel 0
   SIGNAL dprioin_reserved_0_TB38	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rpowdnr	: STD_LOGIC;
   SIGNAL dprioin_rrx_ib_pdb	: STD_LOGIC;
   SIGNAL dprioin_rurx_pdb	: STD_LOGIC;
   SIGNAL dprioin_rrx_oc_calpd	: STD_LOGIC;
   SIGNAL dprioin_rrx_sd_off	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL dprioin_rrx_sd_on	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 8 for Channel 0
   SIGNAL dprioin_reye_monitor	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL dprioin_reserved_0_TB43	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 9 for Channel 0
   SIGNAL dprioin_rpma_reserved_0_TB44	: STD_LOGIC_VECTOR(15 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 10 for Channel 0
   SIGNAL dprioin_rppm_cnt_reset	: STD_LOGIC;
   SIGNAL dprioin_rforce1_freqdet	: STD_LOGIC;
   SIGNAL dprioin_rforce0_freqdet	: STD_LOGIC;
   SIGNAL dprioin_rppmsel	: STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL dprioin_rfastsd	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rtest_fastsd	: STD_LOGIC;
   SIGNAL dprioin_rpmadwidth_rx	: STD_LOGIC;
   SIGNAL dprioin_rpma_doublewidth_rx	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 11 for Channel 0
   SIGNAL dprioin_reserved_0_TB46	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL dprioin_rppm_gen1_2xcnt_en	: STD_LOGIC;
   SIGNAL dprioin_rppm_post_eidle_del	: STD_LOGIC;
   SIGNAL dprioin_r_dfe_2t	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_r_dfe_1t	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 12 for Channel 0
   SIGNAL dprioin_reqv_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_reqd_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_reqc_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_reqb_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_reqa_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_reserved_0_TB47	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 13 for Channel 0
   SIGNAL dprioin_rdc_freq	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rhyst_lf	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rclkdiv	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rrgen_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_radce_adapt	: STD_LOGIC;
   SIGNAL dprioin_rseq_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rlock_lf_ovd	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 14 for Channel 0
   SIGNAL dprioin_rrgen_vod	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rf_hpf	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rf_lpf	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_reserved_1_TB49	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_reserved_0_TB49	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL dprioin_rhyst_hf	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 15 for Channel 0
   SIGNAL dprioin_radce_pdb	: STD_LOGIC;
   SIGNAL dprioin_radce_rst	: STD_LOGIC;
   SIGNAL dprioin_rhf_os	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rlf_os	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL dprioin_rd2a_res	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rrect_adj	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL dprioin_rrgen_bw	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 16 for Channel 0
   SIGNAL dprioin_radce_hflck	: STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL dprioin_reserved_0_TB51	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 17 for Channel 0
   SIGNAL dprioin_radce_lflck	: STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL dprioin_reserved_0_TB52	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 18 for Channel 0
   SIGNAL dprioin_radce_digital	: STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL dprioin_reserved_0_TB53	: STD_LOGIC_VECTOR(5 DOWNTO 0);
   
   -- Extra
   SIGNAL dprioin_rlpbk		: STD_LOGIC;
   SIGNAL dprioin_rrevlb_sw	: STD_LOGIC;
   SIGNAL dprioin_rrx_s_lpbk	: STD_LOGIC;

   -- ---------------------------------------------------------------------------
   -- Initial CRAM  
   -- ---------------------------------------------------------------------------
   
   -- PMA Per Channel RX Control Register 1 for Channel 0
   SIGNAL init_rrx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rrx_vtt	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rrx_s_rdlpbk	: STD_LOGIC;
   SIGNAL init_rrx_bit_dc	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rrx_lst	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 2 for Channel 0
   SIGNAL init_rrxurstpma	: STD_LOGIC;
   SIGNAL init_rrx_test	: STD_LOGIC;
   SIGNAL init_rrx_sd_force	: STD_LOGIC;
   SIGNAL init_rrx_oc	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL init_rrx_oc_en	: STD_LOGIC;
   SIGNAL init_rrx_sdlv	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 3 for Channel 0
   SIGNAL init_reserved_0_TB38	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rpowdnr	: STD_LOGIC;
   SIGNAL init_rrx_ib_pdb	: STD_LOGIC;
   SIGNAL init_rurx_pdb	: STD_LOGIC;
   SIGNAL init_rrx_oc_calpd	: STD_LOGIC;
   SIGNAL init_rrx_sd_off	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL init_rrx_sd_on	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 8 for Channel 0
   SIGNAL init_reye_monitor	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL init_reserved_0_TB43	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 9 for Channel 0
   SIGNAL init_rpma_reserved_0_TB44	: STD_LOGIC_VECTOR(15 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 10 for Channel 0
   SIGNAL init_rppm_cnt_reset	: STD_LOGIC;
   SIGNAL init_rforce1_freqdet	: STD_LOGIC;
   SIGNAL init_rforce0_freqdet	: STD_LOGIC;
   SIGNAL init_rppmsel	: STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL init_rfastsd	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rtest_fastsd	: STD_LOGIC;
   SIGNAL init_rpmadwidth_rx	: STD_LOGIC;
   SIGNAL init_rpma_doublewidth_rx	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 11 for Channel 0
   SIGNAL init_reserved_0_TB46	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL init_rppm_gen1_2xcnt_en	: STD_LOGIC;
   SIGNAL init_rppm_post_eidle_del	: STD_LOGIC;
   SIGNAL init_r_dfe_2t	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_r_dfe_1t	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 12 for Channel 0
   SIGNAL init_reqv_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_reqd_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_reqc_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_reqb_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_reqa_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_reserved_0_TB47	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 13 for Channel 0
   SIGNAL init_rdc_freq	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rhyst_lf	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rclkdiv	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rrgen_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_radce_adapt	: STD_LOGIC;
   SIGNAL init_rseq_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rlock_lf_ovd	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 14 for Channel 0
   SIGNAL init_rrgen_vod	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rf_hpf	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rf_lpf	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_reserved_1_TB49	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_reserved_0_TB49	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL init_rhyst_hf	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 15 for Channel 0
   SIGNAL init_radce_pdb	: STD_LOGIC;
   SIGNAL init_radce_rst	: STD_LOGIC;
   SIGNAL init_rhf_os	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rlf_os	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL init_rd2a_res	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rrect_adj	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL init_rrgen_bw	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 16 for Channel 0
   SIGNAL init_radce_hflck	: STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL init_reserved_0_TB51	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 17 for Channel 0
   SIGNAL init_radce_lflck	: STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL init_reserved_0_TB52	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 18 for Channel 0
   SIGNAL init_radce_digital	: STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL init_reserved_0_TB53	: STD_LOGIC_VECTOR(5 DOWNTO 0);
   
   -- Extra
   SIGNAL init_rlpbk		: STD_LOGIC;
   SIGNAL init_rrevlb_sw	: STD_LOGIC;
   SIGNAL init_rrx_s_lpbk	: STD_LOGIC;
   
   -- ---------------------------------------------------------------------------
   -- CRAM  
   -- ---------------------------------------------------------------------------
   
   -- PMA Per Channel RX Control Register 1 for Channel 0
   SIGNAL cram_rrx_term_sel	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rrx_vtt	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rrx_s_rdlpbk	: STD_LOGIC;
   SIGNAL cram_rrx_bit_dc	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rrx_lst	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 2 for Channel 0
   SIGNAL cram_rrxurstpma	: STD_LOGIC;
   SIGNAL cram_rrx_test	: STD_LOGIC;
   SIGNAL cram_rrx_sd_force	: STD_LOGIC;
   SIGNAL cram_rrx_oc	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL cram_rrx_oc_en	: STD_LOGIC;
   SIGNAL cram_rrx_sdlv	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 3 for Channel 0
   SIGNAL cram_reserved_0_TB38	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rpowdnr	: STD_LOGIC;
   SIGNAL cram_rrx_ib_pdb	: STD_LOGIC;
   SIGNAL cram_rurx_pdb	: STD_LOGIC;
   SIGNAL cram_rrx_oc_calpd	: STD_LOGIC;
   SIGNAL cram_rrx_sd_off	: STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL cram_rrx_sd_on	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 8 for Channel 0
   SIGNAL cram_reye_monitor	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL cram_reserved_0_TB43	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 9 for Channel 0
   SIGNAL cram_rpma_reserved_0_TB44	: STD_LOGIC_VECTOR(15 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 10 for Channel 0
   SIGNAL cram_rppm_cnt_reset	: STD_LOGIC;
   SIGNAL cram_rforce1_freqdet	: STD_LOGIC;
   SIGNAL cram_rforce0_freqdet	: STD_LOGIC;
   SIGNAL cram_rppmsel	: STD_LOGIC_VECTOR(5 DOWNTO 0);
   SIGNAL cram_rfastsd	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rtest_fastsd	: STD_LOGIC;
   SIGNAL cram_rpmadwidth_rx	: STD_LOGIC;
   SIGNAL cram_rpma_doublewidth_rx	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 11 for Channel 0
   SIGNAL cram_reserved_0_TB46	: STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL cram_rppm_gen1_2xcnt_en	: STD_LOGIC;
   SIGNAL cram_rppm_post_eidle_del	: STD_LOGIC;
   SIGNAL cram_r_dfe_2t	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_r_dfe_1t	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 12 for Channel 0
   SIGNAL cram_reqv_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_reqd_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_reqc_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_reqb_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_reqa_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_reserved_0_TB47	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 13 for Channel 0
   SIGNAL cram_rdc_freq	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rhyst_lf	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rclkdiv	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rrgen_set	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_radce_adapt	: STD_LOGIC;
   SIGNAL cram_rseq_sel	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rlock_lf_ovd	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 14 for Channel 0
   SIGNAL cram_rrgen_vod	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rf_hpf	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rf_lpf	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_reserved_1_TB49	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_reserved_0_TB49	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL cram_rhyst_hf	: STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 15 for Channel 0
   SIGNAL cram_radce_pdb	: STD_LOGIC;
   SIGNAL cram_radce_rst	: STD_LOGIC;
   SIGNAL cram_rhf_os	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rlf_os	: STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL cram_rd2a_res	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rrect_adj	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL cram_rrgen_bw	: STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   -- PMA Per Channel RX Control Register 16 for Channel 0
   SIGNAL cram_radce_hflck	: STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL cram_reserved_0_TB51	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 17 for Channel 0
   SIGNAL cram_radce_lflck	: STD_LOGIC_VECTOR(14 DOWNTO 0);
   SIGNAL cram_reserved_0_TB52	: STD_LOGIC;
   
   -- PMA Per Channel RX Control Register 18 for Channel 0
   SIGNAL cram_radce_digital	: STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL cram_reserved_0_TB53	: STD_LOGIC_VECTOR(5 DOWNTO 0); 
   
   -- Extra
   SIGNAL cram_rlpbk		: STD_LOGIC;
   SIGNAL cram_rrevlb_sw	: STD_LOGIC;
   SIGNAL cram_rrx_s_lpbk	: STD_LOGIC;
   
   SIGNAL dpriodisable_in       : STD_LOGIC;

BEGIN
       
      ------------------------
      --  Wire Delay Block --
      ------------------------
      WireDelay : BLOCK
      BEGIN
           VitalWireDelay (datain_ipd,datain, tipd_datain);
           VitalWireDelay (ppmdetectdividedclk_ipd,ppmdetectdividedclk, tipd_ppmdetectdividedclk);
           VitalWireDelay (rxpmareset_ipd,rxpmareset, tipd_rxpmareset);
           VitalWireDelay (plllocked_ipd,plllocked, tipd_plllocked);
           VitalWireDelay (dpriodisable_ipd,dpriodisable, tipd_dpriodisable);
           VitalWireDelay (ignorephslck_ipd,ignorephslck, tipd_ignorephslck);
           VitalWireDelay (locktoref_ipd,locktoref, tipd_locktoref);
           VitalWireDelay (adcepowerdn_ipd,adcepowerdn, tipd_adcepowerdn);
           VitalWireDelay (adcestandby_ipd,adcestandby, tipd_adcestandby);
           VitalWireDelay (ppmdetectrefclk_ipd,ppmdetectrefclk, tipd_ppmdetectrefclk);
           VitalWireDelay (powerdn_ipd,powerdn, tipd_powerdn);
           VitalWireDelay (seriallpbken_ipd,seriallpbken, tipd_seriallpbken);
           VitalWireDelay (adcereset_ipd,adcereset, tipd_adcereset);
       bits_deserclock : FOR i in deserclock'RANGE GENERATE
           VitalWireDelay (deserclock_ipd(i),deserclock(i), tipd_deserclock(i));
       END GENERATE;
           VitalWireDelay (locktodata_ipd,locktodata, tipd_locktodata);
           VitalWireDelay (freqlock_ipd,freqlock, tipd_freqlock);
           VitalWireDelay (offsetcancellationen_ipd,offsetcancellationen, tipd_offsetcancellationen);
       bits_testbussel : FOR i in testbussel'RANGE GENERATE
           VitalWireDelay (testbussel_ipd(i),testbussel(i), tipd_testbussel(i));
       END GENERATE;
       bits_recoverdatain : FOR i in recoverdatain'RANGE GENERATE
           VitalWireDelay (recoverdatain_ipd(i),recoverdatain(i), tipd_recoverdatain(i));
       END GENERATE;
           VitalWireDelay (seriallpbkin_ipd,seriallpbkin, tipd_seriallpbkin);
       bits_dprioin : FOR i in dprioin'RANGE GENERATE
           VitalWireDelay (dprioin_ipd(i),dprioin(i), tipd_dprioin(i));
       END GENERATE;
           VitalWireDelay (adaptcapture_ipd,adaptcapture, tipd_adaptcapture);
      END BLOCK;
  
        -- new DPRIO model begin --
        -- ---------------------------------------------------------------------------
        -- Set DPRIO CRAM input from dprioin  
        -- ---------------------------------------------------------------------------
        
        -- PMA Per Channel RX Control Register 1 for Channel 0
        dprioin_rrx_term_sel	<= dprioin(rrx_term_sel_RXPMA_IDX_2 DOWNTO rrx_term_sel_RXPMA_IDX_0);
        dprioin_rrx_vtt	<= dprioin(rrx_vtt_RXPMA_IDX_2 DOWNTO rrx_vtt_RXPMA_IDX_0);
        dprioin_rrx_s_rdlpbk	<= dprioin(rrx_s_rdlpbk_RXPMA_IDX_0);
        dprioin_rrx_bit_dc	<= dprioin(rrx_bit_dc_RXPMA_IDX_3 DOWNTO rrx_bit_dc_RXPMA_IDX_0);
        dprioin_rrx_lst	<= dprioin(rrx_lst_RXPMA_IDX_4 DOWNTO rrx_lst_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 2 for Channel 0
        dprioin_rrxurstpma	<= dprioin(rrxurstpma_RXPMA_IDX_0);
        dprioin_rrx_test	<= dprioin(rrx_test_RXPMA_IDX_0);
        dprioin_rrx_sd_force	<= dprioin(rrx_sd_force_RXPMA_IDX_0);
        dprioin_rrx_oc	<= dprioin(rrx_oc_RXPMA_IDX_7 DOWNTO rrx_oc_RXPMA_IDX_0);
        dprioin_rrx_oc_en	<= dprioin(rrx_oc_en_RXPMA_IDX_0);
        dprioin_rrx_sdlv	<= dprioin(rrx_sdlv_RXPMA_IDX_3 DOWNTO rrx_sdlv_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 3 for Channel 0
        dprioin_reserved_0_TB38	<= dprioin(reserved_0_TB38_RXPMA_IDX_2 DOWNTO reserved_0_TB38_RXPMA_IDX_0);
        dprioin_rpowdnr	<= dprioin(rpowdnr_RXPMA_IDX_0);
        dprioin_rrx_ib_pdb	<= dprioin(rrx_ib_pdb_RXPMA_IDX_0);
        dprioin_rurx_pdb	<= dprioin(rurx_pdb_RXPMA_IDX_0);
        dprioin_rrx_oc_calpd	<= dprioin(rrx_oc_calpd_RXPMA_IDX_0);
        dprioin_rrx_sd_off	<= dprioin(rrx_sd_off_RXPMA_IDX_4 DOWNTO rrx_sd_off_RXPMA_IDX_0);
        dprioin_rrx_sd_on	<= dprioin(rrx_sd_on_RXPMA_IDX_3 DOWNTO rrx_sd_on_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 8 for Channel 0
        dprioin_reye_monitor	<= dprioin(reye_monitor_RXPMA_IDX_7 DOWNTO reye_monitor_RXPMA_IDX_0);
        dprioin_reserved_0_TB43	<= dprioin(reserved_0_TB43_RXPMA_IDX_7 DOWNTO reserved_0_TB43_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 9 for Channel 0
        dprioin_rpma_reserved_0_TB44	<= dprioin(rpma_reserved_0_TB44_RXPMA_IDX_15 DOWNTO rpma_reserved_0_TB44_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 10 for Channel 0
        dprioin_rppm_cnt_reset	<= dprioin(rppm_cnt_reset_RXPMA_IDX_0);
        dprioin_rforce1_freqdet	<= dprioin(rforce1_freqdet_RXPMA_IDX_0);
        dprioin_rforce0_freqdet	<= dprioin(rforce0_freqdet_RXPMA_IDX_0);
        dprioin_rppmsel	<= dprioin(rppmsel_RXPMA_IDX_5 DOWNTO rppmsel_RXPMA_IDX_0);
        dprioin_rfastsd	<= dprioin(rfastsd_RXPMA_IDX_3 DOWNTO rfastsd_RXPMA_IDX_0);
        dprioin_rtest_fastsd	<= dprioin(rtest_fastsd_RXPMA_IDX_0);
        dprioin_rpmadwidth_rx	<= dprioin(rpmadwidth_rx_RXPMA_IDX_0);
        dprioin_rpma_doublewidth_rx	<= dprioin(rpma_doublewidth_rx_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 11 for Channel 0
        dprioin_reserved_0_TB46	<= dprioin(reserved_0_TB46_RXPMA_IDX_7 DOWNTO reserved_0_TB46_RXPMA_IDX_0);
        dprioin_rppm_gen1_2xcnt_en	<= dprioin(rppm_gen1_2xcnt_en_RXPMA_IDX_0);
        dprioin_rppm_post_eidle_del	<= dprioin(rppm_post_eidle_del_RXPMA_IDX_0);
        dprioin_r_dfe_2t	<= dprioin(r_dfe_2t_RXPMA_IDX_2 DOWNTO r_dfe_2t_RXPMA_IDX_0);
        dprioin_r_dfe_1t	<= dprioin(r_dfe_1t_RXPMA_IDX_2 DOWNTO r_dfe_1t_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 12 for Channel 0
        dprioin_reqv_set	<= dprioin(reqv_set_RXPMA_IDX_2 DOWNTO reqv_set_RXPMA_IDX_0);
        dprioin_reqd_set	<= dprioin(reqd_set_RXPMA_IDX_2 DOWNTO reqd_set_RXPMA_IDX_0);
        dprioin_reqc_set	<= dprioin(reqc_set_RXPMA_IDX_2 DOWNTO reqc_set_RXPMA_IDX_0);
        dprioin_reqb_set	<= dprioin(reqb_set_RXPMA_IDX_2 DOWNTO reqb_set_RXPMA_IDX_0);
        dprioin_reqa_set	<= dprioin(reqa_set_RXPMA_IDX_2 DOWNTO reqa_set_RXPMA_IDX_0);
        dprioin_reserved_0_TB47	<= dprioin(reserved_0_TB47_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 13 for Channel 0
        dprioin_rdc_freq	<= dprioin(rdc_freq_RXPMA_IDX_1 DOWNTO rdc_freq_RXPMA_IDX_0);
        dprioin_rhyst_lf	<= dprioin(rhyst_lf_RXPMA_IDX_2 DOWNTO rhyst_lf_RXPMA_IDX_0);
        dprioin_rclkdiv	<= dprioin(rclkdiv_RXPMA_IDX_3 DOWNTO rclkdiv_RXPMA_IDX_0);
        dprioin_rrgen_set	<= dprioin(rrgen_set_RXPMA_IDX_2 DOWNTO rrgen_set_RXPMA_IDX_0);
        dprioin_radce_adapt	<= dprioin(radce_adapt_RXPMA_IDX_0);
        dprioin_rseq_sel	<= dprioin(rseq_sel_RXPMA_IDX_1 DOWNTO rseq_sel_RXPMA_IDX_0);
        dprioin_rlock_lf_ovd	<= dprioin(rlock_lf_ovd_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 14 for Channel 0
        dprioin_rrgen_vod	<= dprioin(rrgen_vod_RXPMA_IDX_2 DOWNTO rrgen_vod_RXPMA_IDX_0);
        dprioin_rf_hpf	<= dprioin(rf_hpf_RXPMA_IDX_1 DOWNTO rf_hpf_RXPMA_IDX_0);
        dprioin_rf_lpf	<= dprioin(rf_lpf_RXPMA_IDX_1 DOWNTO rf_lpf_RXPMA_IDX_0);
        dprioin_reserved_1_TB49	<= dprioin(reserved_1_TB49_RXPMA_IDX_2 DOWNTO reserved_1_TB49_RXPMA_IDX_0);
        dprioin_reserved_0_TB49	<= dprioin(reserved_0_TB49_RXPMA_IDX_2 DOWNTO reserved_0_TB49_RXPMA_IDX_0);
        dprioin_rhyst_hf	<= dprioin(rhyst_hf_RXPMA_IDX_2 DOWNTO rhyst_hf_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 15 for Channel 0
        dprioin_radce_pdb	<= dprioin(radce_pdb_RXPMA_IDX_0);
        dprioin_radce_rst	<= dprioin(radce_rst_RXPMA_IDX_0);
        dprioin_rhf_os	<= dprioin(rhf_os_RXPMA_IDX_3 DOWNTO rhf_os_RXPMA_IDX_0);
        dprioin_rlf_os	<= dprioin(rlf_os_RXPMA_IDX_3 DOWNTO rlf_os_RXPMA_IDX_0);
        dprioin_rd2a_res	<= dprioin(rd2a_res_RXPMA_IDX_1 DOWNTO rd2a_res_RXPMA_IDX_0);
        dprioin_rrect_adj	<= dprioin(rrect_adj_RXPMA_IDX_1 DOWNTO rrect_adj_RXPMA_IDX_0);
        dprioin_rrgen_bw	<= dprioin(rrgen_bw_RXPMA_IDX_1 DOWNTO rrgen_bw_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 16 for Channel 0
        dprioin_radce_hflck	<= dprioin(radce_hflck_RXPMA_IDX_14 DOWNTO radce_hflck_RXPMA_IDX_0);
        dprioin_reserved_0_TB51	<= dprioin(reserved_0_TB51_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 17 for Channel 0
        dprioin_radce_lflck	<= dprioin(radce_lflck_RXPMA_IDX_14 DOWNTO radce_lflck_RXPMA_IDX_0);
        dprioin_reserved_0_TB52	<= dprioin(reserved_0_TB52_RXPMA_IDX_0);
        
        -- PMA Per Channel RX Control Register 18 for Channel 0
        dprioin_radce_digital	<= dprioin(radce_digital_RXPMA_IDX_9 DOWNTO radce_digital_RXPMA_IDX_0);
        dprioin_reserved_0_TB53	<= dprioin(reserved_0_TB53_RXPMA_IDX_5 DOWNTO reserved_0_TB53_RXPMA_IDX_0);
        
        -- Extra
	dprioin_rlpbk 		<= dprioin(RLPBK_RXPMA_IDX);
	dprioin_rrevlb_sw  	<= dprioin(RREVLB_SW_RXPMA_IDX);
	dprioin_rrx_s_lpbk 	<= dprioin(RRX_S_LPBK_RXPMA_IDX);
        
        -- ---------------------------------------------------------------------------
        -- Set DPRIO output from initial CRAM
        -- ---------------------------------------------------------------------------
        
        -- PMA Per Channel RX Control Register 1 for Channel 0
        dprioout(rrx_term_sel_RXPMA_IDX_2 DOWNTO rrx_term_sel_RXPMA_IDX_0) <= init_rrx_term_sel;
        dprioout(rrx_vtt_RXPMA_IDX_2 DOWNTO rrx_vtt_RXPMA_IDX_0) <= init_rrx_vtt;
        dprioout(rrx_s_rdlpbk_RXPMA_IDX_0) <= init_rrx_s_rdlpbk;
        dprioout(rrx_bit_dc_RXPMA_IDX_3 DOWNTO rrx_bit_dc_RXPMA_IDX_0) <= init_rrx_bit_dc;
        dprioout(rrx_lst_RXPMA_IDX_4 DOWNTO rrx_lst_RXPMA_IDX_0) <= init_rrx_lst;
        
        -- PMA Per Channel RX Control Register 2 for Channel 0
        dprioout(rrxurstpma_RXPMA_IDX_0) <= init_rrxurstpma;
        dprioout(rrx_test_RXPMA_IDX_0) <= init_rrx_test;
        dprioout(rrx_sd_force_RXPMA_IDX_0) <= init_rrx_sd_force;
        dprioout(rrx_oc_RXPMA_IDX_7 DOWNTO rrx_oc_RXPMA_IDX_0) <= init_rrx_oc;
        dprioout(rrx_oc_en_RXPMA_IDX_0) <= init_rrx_oc_en;
        dprioout(rrx_sdlv_RXPMA_IDX_3 DOWNTO rrx_sdlv_RXPMA_IDX_0) <= init_rrx_sdlv;
        
        -- PMA Per Channel RX Control Register 3 for Channel 0
        dprioout(reserved_0_TB38_RXPMA_IDX_2 DOWNTO reserved_0_TB38_RXPMA_IDX_0) <= init_reserved_0_TB38;
        dprioout(rpowdnr_RXPMA_IDX_0) <= init_rpowdnr;
        dprioout(rrx_ib_pdb_RXPMA_IDX_0) <= init_rrx_ib_pdb;
        dprioout(rurx_pdb_RXPMA_IDX_0) <= init_rurx_pdb;
        dprioout(rrx_oc_calpd_RXPMA_IDX_0) <= init_rrx_oc_calpd;
        dprioout(rrx_sd_off_RXPMA_IDX_4 DOWNTO rrx_sd_off_RXPMA_IDX_0) <= init_rrx_sd_off;
        dprioout(rrx_sd_on_RXPMA_IDX_3 DOWNTO rrx_sd_on_RXPMA_IDX_0) <= init_rrx_sd_on;
        
        -- PMA Per Channel RX Control Register 8 for Channel 0
        dprioout(reye_monitor_RXPMA_IDX_7 DOWNTO reye_monitor_RXPMA_IDX_0) <= init_reye_monitor;
        dprioout(reserved_0_TB43_RXPMA_IDX_7 DOWNTO reserved_0_TB43_RXPMA_IDX_0) <= init_reserved_0_TB43;
        
        -- PMA Per Channel RX Control Register 9 for Channel 0
        dprioout(rpma_reserved_0_TB44_RXPMA_IDX_15 DOWNTO rpma_reserved_0_TB44_RXPMA_IDX_0) <= init_rpma_reserved_0_TB44;
        
        -- PMA Per Channel RX Control Register 10 for Channel 0
        dprioout(rppm_cnt_reset_RXPMA_IDX_0) <= init_rppm_cnt_reset;
        dprioout(rforce1_freqdet_RXPMA_IDX_0) <= init_rforce1_freqdet;
        dprioout(rforce0_freqdet_RXPMA_IDX_0) <= init_rforce0_freqdet;
        dprioout(rppmsel_RXPMA_IDX_5 DOWNTO rppmsel_RXPMA_IDX_0) <= init_rppmsel;
        dprioout(rfastsd_RXPMA_IDX_3 DOWNTO rfastsd_RXPMA_IDX_0) <= init_rfastsd;
        dprioout(rtest_fastsd_RXPMA_IDX_0) <= init_rtest_fastsd;
        dprioout(rpmadwidth_rx_RXPMA_IDX_0) <= init_rpmadwidth_rx;
        dprioout(rpma_doublewidth_rx_RXPMA_IDX_0) <= init_rpma_doublewidth_rx;
        
        -- PMA Per Channel RX Control Register 11 for Channel 0
        dprioout(reserved_0_TB46_RXPMA_IDX_7 DOWNTO reserved_0_TB46_RXPMA_IDX_0) <= init_reserved_0_TB46;
        dprioout(rppm_gen1_2xcnt_en_RXPMA_IDX_0) <= init_rppm_gen1_2xcnt_en;
        dprioout(rppm_post_eidle_del_RXPMA_IDX_0) <= init_rppm_post_eidle_del;
        dprioout(r_dfe_2t_RXPMA_IDX_2 DOWNTO r_dfe_2t_RXPMA_IDX_0) <= init_r_dfe_2t;
        dprioout(r_dfe_1t_RXPMA_IDX_2 DOWNTO r_dfe_1t_RXPMA_IDX_0) <= init_r_dfe_1t;
        
        -- PMA Per Channel RX Control Register 12 for Channel 0
        dprioout(reqv_set_RXPMA_IDX_2 DOWNTO reqv_set_RXPMA_IDX_0) <= init_reqv_set;
        dprioout(reqd_set_RXPMA_IDX_2 DOWNTO reqd_set_RXPMA_IDX_0) <= init_reqd_set;
        dprioout(reqc_set_RXPMA_IDX_2 DOWNTO reqc_set_RXPMA_IDX_0) <= init_reqc_set;
        dprioout(reqb_set_RXPMA_IDX_2 DOWNTO reqb_set_RXPMA_IDX_0) <= init_reqb_set;
        dprioout(reqa_set_RXPMA_IDX_2 DOWNTO reqa_set_RXPMA_IDX_0) <= init_reqa_set;
        dprioout(reserved_0_TB47_RXPMA_IDX_0) <= init_reserved_0_TB47;
        
        -- PMA Per Channel RX Control Register 13 for Channel 0
        dprioout(rdc_freq_RXPMA_IDX_1 DOWNTO rdc_freq_RXPMA_IDX_0) <= init_rdc_freq;
        dprioout(rhyst_lf_RXPMA_IDX_2 DOWNTO rhyst_lf_RXPMA_IDX_0) <= init_rhyst_lf;
        dprioout(rclkdiv_RXPMA_IDX_3 DOWNTO rclkdiv_RXPMA_IDX_0) <= init_rclkdiv;
        dprioout(rrgen_set_RXPMA_IDX_2 DOWNTO rrgen_set_RXPMA_IDX_0) <= init_rrgen_set;
        dprioout(radce_adapt_RXPMA_IDX_0) <= init_radce_adapt;
        dprioout(rseq_sel_RXPMA_IDX_1 DOWNTO rseq_sel_RXPMA_IDX_0) <= init_rseq_sel;
        dprioout(rlock_lf_ovd_RXPMA_IDX_0) <= init_rlock_lf_ovd;
        
        -- PMA Per Channel RX Control Register 14 for Channel 0
        dprioout(rrgen_vod_RXPMA_IDX_2 DOWNTO rrgen_vod_RXPMA_IDX_0) <= init_rrgen_vod;
        dprioout(rf_hpf_RXPMA_IDX_1 DOWNTO rf_hpf_RXPMA_IDX_0) <= init_rf_hpf;
        dprioout(rf_lpf_RXPMA_IDX_1 DOWNTO rf_lpf_RXPMA_IDX_0) <= init_rf_lpf;
        dprioout(reserved_1_TB49_RXPMA_IDX_2 DOWNTO reserved_1_TB49_RXPMA_IDX_0) <= init_reserved_1_TB49;
        dprioout(reserved_0_TB49_RXPMA_IDX_2 DOWNTO reserved_0_TB49_RXPMA_IDX_0) <= init_reserved_0_TB49;
        dprioout(rhyst_hf_RXPMA_IDX_2 DOWNTO rhyst_hf_RXPMA_IDX_0) <= init_rhyst_hf;
        
        -- PMA Per Channel RX Control Register 15 for Channel 0
        dprioout(radce_pdb_RXPMA_IDX_0) <= init_radce_pdb;
        dprioout(radce_rst_RXPMA_IDX_0) <= init_radce_rst;
        dprioout(rhf_os_RXPMA_IDX_3 DOWNTO rhf_os_RXPMA_IDX_0) <= init_rhf_os;
        dprioout(rlf_os_RXPMA_IDX_3 DOWNTO rlf_os_RXPMA_IDX_0) <= init_rlf_os;
        dprioout(rd2a_res_RXPMA_IDX_1 DOWNTO rd2a_res_RXPMA_IDX_0) <= init_rd2a_res;
        dprioout(rrect_adj_RXPMA_IDX_1 DOWNTO rrect_adj_RXPMA_IDX_0) <= init_rrect_adj;
        dprioout(rrgen_bw_RXPMA_IDX_1 DOWNTO rrgen_bw_RXPMA_IDX_0) <= init_rrgen_bw;
        
        -- PMA Per Channel RX Control Register 16 for Channel 0
        dprioout(radce_hflck_RXPMA_IDX_14 DOWNTO radce_hflck_RXPMA_IDX_0) <= init_radce_hflck;
        dprioout(reserved_0_TB51_RXPMA_IDX_0) <= init_reserved_0_TB51;
        
        -- PMA Per Channel RX Control Register 17 for Channel 0
        dprioout(radce_lflck_RXPMA_IDX_14 DOWNTO radce_lflck_RXPMA_IDX_0) <= init_radce_lflck;
        dprioout(reserved_0_TB52_RXPMA_IDX_0) <= init_reserved_0_TB52;
        
        -- PMA Per Channel RX Control Register 18 for Channel 0
        dprioout(radce_digital_RXPMA_IDX_9 DOWNTO radce_digital_RXPMA_IDX_0) <= init_radce_digital;
        dprioout(reserved_0_TB53_RXPMA_IDX_5 DOWNTO reserved_0_TB53_RXPMA_IDX_0) <= init_reserved_0_TB53;
        
        -- Extra
	dprioout(RLPBK_RXPMA_IDX) <= init_rlpbk;
	dprioout(RREVLB_SW_RXPMA_IDX) <= init_rrevlb_sw;
	dprioout(RRX_S_LPBK_RXPMA_IDX) <= init_rrx_s_lpbk;
        
        -- ---------------------------------------------------------------------------
        -- Set DPRIO CRAM
        -- ---------------------------------------------------------------------------
        dpriodisable_in <= '0' WHEN (dpriodisable = '0') ELSE '1';
                      
        -- PMA Per Channel RX Control Register 1 for Channel 0
        cram_rrx_term_sel <= init_rrx_term_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_term_sel;
        cram_rrx_vtt <= init_rrx_vtt WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_vtt;
        cram_rrx_s_rdlpbk <= init_rrx_s_rdlpbk WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_s_rdlpbk;
        cram_rrx_bit_dc <= init_rrx_bit_dc WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_bit_dc;
        cram_rrx_lst <= init_rrx_lst WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_lst;
        
        -- PMA Per Channel RX Control Register 2 for Channel 0
        cram_rrxurstpma <= init_rrxurstpma WHEN (dpriodisable_in /= '0') ELSE dprioin_rrxurstpma;
        cram_rrx_test <= init_rrx_test WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_test;
        cram_rrx_sd_force <= init_rrx_sd_force WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_sd_force;
        cram_rrx_oc <= init_rrx_oc WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_oc;
        cram_rrx_oc_en <= init_rrx_oc_en WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_oc_en;
        cram_rrx_sdlv <= init_rrx_sdlv WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_sdlv;
        
        -- PMA Per Channel RX Control Register 3 for Channel 0
        cram_reserved_0_TB38 <= init_reserved_0_TB38 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB38;
        cram_rpowdnr <= init_rpowdnr WHEN (dpriodisable_in /= '0') ELSE dprioin_rpowdnr;
        cram_rrx_ib_pdb <= init_rrx_ib_pdb WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_ib_pdb;
        cram_rurx_pdb <= init_rurx_pdb WHEN (dpriodisable_in /= '0') ELSE dprioin_rurx_pdb;
        cram_rrx_oc_calpd <= init_rrx_oc_calpd WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_oc_calpd;
        cram_rrx_sd_off <= init_rrx_sd_off WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_sd_off;
        cram_rrx_sd_on <= init_rrx_sd_on WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_sd_on;
        
        -- PMA Per Channel RX Control Register 8 for Channel 0
        cram_reye_monitor <= init_reye_monitor WHEN (dpriodisable_in /= '0') ELSE dprioin_reye_monitor;
        cram_reserved_0_TB43 <= init_reserved_0_TB43 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB43;
        
        -- PMA Per Channel RX Control Register 9 for Channel 0
        cram_rpma_reserved_0_TB44 <= init_rpma_reserved_0_TB44 WHEN (dpriodisable_in /= '0') ELSE dprioin_rpma_reserved_0_TB44;
        
        -- PMA Per Channel RX Control Register 10 for Channel 0
        cram_rppm_cnt_reset <= init_rppm_cnt_reset WHEN (dpriodisable_in /= '0') ELSE dprioin_rppm_cnt_reset;
        cram_rforce1_freqdet <= init_rforce1_freqdet WHEN (dpriodisable_in /= '0') ELSE dprioin_rforce1_freqdet;
        cram_rforce0_freqdet <= init_rforce0_freqdet WHEN (dpriodisable_in /= '0') ELSE dprioin_rforce0_freqdet;
        cram_rppmsel <= init_rppmsel WHEN (dpriodisable_in /= '0') ELSE dprioin_rppmsel;
        cram_rfastsd <= init_rfastsd WHEN (dpriodisable_in /= '0') ELSE dprioin_rfastsd;
        cram_rtest_fastsd <= init_rtest_fastsd WHEN (dpriodisable_in /= '0') ELSE dprioin_rtest_fastsd;
        cram_rpmadwidth_rx <= init_rpmadwidth_rx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpmadwidth_rx;
        cram_rpma_doublewidth_rx <= init_rpma_doublewidth_rx WHEN (dpriodisable_in /= '0') ELSE dprioin_rpma_doublewidth_rx;
        
        -- PMA Per Channel RX Control Register 11 for Channel 0
        cram_reserved_0_TB46 <= init_reserved_0_TB46 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB46;
        cram_rppm_gen1_2xcnt_en <= init_rppm_gen1_2xcnt_en WHEN (dpriodisable_in /= '0') ELSE dprioin_rppm_gen1_2xcnt_en;
        cram_rppm_post_eidle_del <= init_rppm_post_eidle_del WHEN (dpriodisable_in /= '0') ELSE dprioin_rppm_post_eidle_del;
        cram_r_dfe_2t <= init_r_dfe_2t WHEN (dpriodisable_in /= '0') ELSE dprioin_r_dfe_2t;
        cram_r_dfe_1t <= init_r_dfe_1t WHEN (dpriodisable_in /= '0') ELSE dprioin_r_dfe_1t;
        
        -- PMA Per Channel RX Control Register 12 for Channel 0
        cram_reqv_set <= init_reqv_set WHEN (dpriodisable_in /= '0') ELSE dprioin_reqv_set;
        cram_reqd_set <= init_reqd_set WHEN (dpriodisable_in /= '0') ELSE dprioin_reqd_set;
        cram_reqc_set <= init_reqc_set WHEN (dpriodisable_in /= '0') ELSE dprioin_reqc_set;
        cram_reqb_set <= init_reqb_set WHEN (dpriodisable_in /= '0') ELSE dprioin_reqb_set;
        cram_reqa_set <= init_reqa_set WHEN (dpriodisable_in /= '0') ELSE dprioin_reqa_set;
        cram_reserved_0_TB47 <= init_reserved_0_TB47 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB47;
        
        -- PMA Per Channel RX Control Register 13 for Channel 0
        cram_rdc_freq <= init_rdc_freq WHEN (dpriodisable_in /= '0') ELSE dprioin_rdc_freq;
        cram_rhyst_lf <= init_rhyst_lf WHEN (dpriodisable_in /= '0') ELSE dprioin_rhyst_lf;
        cram_rclkdiv <= init_rclkdiv WHEN (dpriodisable_in /= '0') ELSE dprioin_rclkdiv;
        cram_rrgen_set <= init_rrgen_set WHEN (dpriodisable_in /= '0') ELSE dprioin_rrgen_set;
        cram_radce_adapt <= init_radce_adapt WHEN (dpriodisable_in /= '0') ELSE dprioin_radce_adapt;
        cram_rseq_sel <= init_rseq_sel WHEN (dpriodisable_in /= '0') ELSE dprioin_rseq_sel;
        cram_rlock_lf_ovd <= init_rlock_lf_ovd WHEN (dpriodisable_in /= '0') ELSE dprioin_rlock_lf_ovd;
        
        -- PMA Per Channel RX Control Register 14 for Channel 0
        cram_rrgen_vod <= init_rrgen_vod WHEN (dpriodisable_in /= '0') ELSE dprioin_rrgen_vod;
        cram_rf_hpf <= init_rf_hpf WHEN (dpriodisable_in /= '0') ELSE dprioin_rf_hpf;
        cram_rf_lpf <= init_rf_lpf WHEN (dpriodisable_in /= '0') ELSE dprioin_rf_lpf;
        cram_reserved_1_TB49 <= init_reserved_1_TB49 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_1_TB49;
        cram_reserved_0_TB49 <= init_reserved_0_TB49 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB49;
        cram_rhyst_hf <= init_rhyst_hf WHEN (dpriodisable_in /= '0') ELSE dprioin_rhyst_hf;
        
        -- PMA Per Channel RX Control Register 15 for Channel 0
        cram_radce_pdb <= init_radce_pdb WHEN (dpriodisable_in /= '0') ELSE dprioin_radce_pdb;
        cram_radce_rst <= init_radce_rst WHEN (dpriodisable_in /= '0') ELSE dprioin_radce_rst;
        cram_rhf_os <= init_rhf_os WHEN (dpriodisable_in /= '0') ELSE dprioin_rhf_os;
        cram_rlf_os <= init_rlf_os WHEN (dpriodisable_in /= '0') ELSE dprioin_rlf_os;
        cram_rd2a_res <= init_rd2a_res WHEN (dpriodisable_in /= '0') ELSE dprioin_rd2a_res;
        cram_rrect_adj <= init_rrect_adj WHEN (dpriodisable_in /= '0') ELSE dprioin_rrect_adj;
        cram_rrgen_bw <= init_rrgen_bw WHEN (dpriodisable_in /= '0') ELSE dprioin_rrgen_bw;
        
        -- PMA Per Channel RX Control Register 16 for Channel 0
        cram_radce_hflck <= init_radce_hflck WHEN (dpriodisable_in /= '0') ELSE dprioin_radce_hflck;
        cram_reserved_0_TB51 <= init_reserved_0_TB51 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB51;
        
        -- PMA Per Channel RX Control Register 17 for Channel 0
        cram_radce_lflck <= init_radce_lflck WHEN (dpriodisable_in /= '0') ELSE dprioin_radce_lflck;
        cram_reserved_0_TB52 <= init_reserved_0_TB52 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB52;
        
        -- PMA Per Channel RX Control Register 18 for Channel 0
        cram_radce_digital <= init_radce_digital WHEN (dpriodisable_in /= '0') ELSE dprioin_radce_digital;
        cram_reserved_0_TB53 <= init_reserved_0_TB53 WHEN (dpriodisable_in /= '0') ELSE dprioin_reserved_0_TB53;
  
  	-- Extra
  	cram_rlpbk 	<= init_rlpbk WHEN (dpriodisable_in /= '0') ELSE dprioin_rlpbk;
  	cram_rrevlb_sw 	<= init_rrevlb_sw WHEN (dpriodisable_in /= '0') ELSE dprioin_rrevlb_sw;
	cram_rrx_s_lpbk <= init_rrx_s_lpbk WHEN (dpriodisable_in /= '0') ELSE dprioin_rrx_s_lpbk;
  
    PROCESS 
   	BEGIN
  
      -- RX PMA control register 1
  	init_rrx_term_sel	<= "000";
  	init_rrx_vtt		<= (mux_select((alpha_tolower(common_mode) = ("0.82v")), "010", mux_select((alpha_tolower(common_mode) = ("tristate")), "100", mux_select((alpha_tolower(common_mode) = ("1.1v")), "001", "000"))));
  	init_rrx_s_rdlpbk	<= mux_select((alpha_tolower(send_direct_reverse_serial_loopback) = ("pre-cdr")), '1', '0');
  	init_rrx_bit_dc		<= (mux_select((eq_dc_gain = 3), "0001", mux_select((eq_dc_gain = 6), "0011", mux_select((eq_dc_gain = 9), "0111", mux_select((eq_dc_gain = 12), "1111", "0000")))));
  	init_rrx_lst		<= int2bin(low_speed_test_select, 5);
  	
  	-- RX PMA control register 2
  	init_rrxurstpma		<= '0';
  	init_rrx_test		<= '0';
  	init_rrx_sd_force	<= mux_select((force_signal_detect = ("true")), '1', '0');
  	init_rrx_oc			<= int2bin(offset_cancellation, 8);
  	init_rrx_oc_en		<= '0';
  	init_rrx_sdlv		<= "0000";
  
  	-- RX PMA control register 3
  	init_reserved_0_TB38	<= "000";
  	init_rpowdnr		<= '0';	
  	init_rrx_ib_pdb		<= '0';	
  	init_rurx_pdb		<= '0';	
  	init_rrx_oc_calpd	<= '0';
  	init_rrx_sd_off		<= int2bin(signal_detect_loss_threshold, 5); 
  	init_rrx_sd_on		<= int2bin(signal_detect_hysteresis_valid_threshold, 4);
  	
  	-- RX PMA control register 12
  	init_reqv_set	<= int2bin(eqv_ctrl, 3);
  	init_reqd_set	<= int2bin(eqd_ctrl, 3);
  	init_reqc_set	<= int2bin(eqc_ctrl, 3);
  	init_reqb_set	<= int2bin(eqb_ctrl, 3);
  	init_reqa_set	<= int2bin(eqa_ctrl, 3);
  	init_reserved_0_TB47 <= '0';
  	
  	-- RX PMA Control Register 10
	init_rppmsel <= int2bin(ppmselect, 6);
  	
  	-- extra
	init_rpma_doublewidth_rx <= mux_select((deserialization_factor = 16 OR deserialization_factor = 20), '1', '0'); --rdeser_div2_init
	init_rpmadwidth_rx 	 <= mux_select((deserialization_factor = 10 OR deserialization_factor = 20), '1', '0');		--rdeser_div5_init
	init_rlpbk 		 <= mux_select((alpha_tolower(send_direct_reverse_serial_loopback) = ("post-cdr")), '1', '0');
	init_rrevlb_sw 		 <= init_rlpbk;    
   	init_rrx_s_lpbk 	 <= (mux_select((allow_serial_loopback = ("true")), '1', '0'));  
  	
      WAIT;
   END PROCESS;
      -- new DPRIO model end --     
      
      ------------------------
      --  Functionality Section --
      ------------------------
   vcce_la <= '1';
   vcce_oa <= '1';
   vccehtx <= '1';
   vssex <= '0';

   xadce_adapt_capture <= adaptcapture;
   xadce_eqin_n <= rx_eqout_n;
   xadce_eqin_p <= rx_eqout_p;

   xadce_pdb <= '0' WHEN (adcepowerdn = '1') ELSE '1';
   xadce_rstb <= '0' WHEN (adcereset = '1') ELSE '1';
   xadce_standby <= '0' WHEN (adcestandby = '1') ELSE '1';
   
   reqa_set <= cram_reqa_set(2 DOWNTO 0);
   reqb_set <= cram_reqb_set(2 DOWNTO 0);
   reqc_set <= cram_reqc_set;
   reqd_set <= cram_reqd_set;
   reqv_set <= cram_reqv_set;
   
   xadce : stratixiv_hssi_pma_c_adce
      PORT MAP (
         adapt_capture    => xadce_adapt_capture,
         atben            => xadce_atben,
         atbsel           => xadce_atbsel,
         eqa_set          => reqa_set,
         eqb_set          => reqb_set,
         eqc_set          => reqc_set,
         eqd_set          => reqd_set,
         eqin_n           => xadce_eqin_n,
         eqin_p           => xadce_eqin_p,
         eqv_set          => reqv_set,
         fixed_clk        => xadce_fixed_clk,
         lock_lf_ovd      => xadce_lock_lf_ovd,
         lst              => rrx_lst,
         radce_adapt      => radce_adapt,
         radce_digital    => radce_digital,
         radce_hflck      => radce_hflck,
         radce_lflck      => radce_lflck,
         radce_pdb        => xadce_pdb,
         radce_rstb       => xadce_rstb,
         radce_vod_int    => radce_vod_int,
         radce_vod_lsb    => radce_vod_lsb,
         rbit_dc          => vssex,
         rclkdiv          => rclkdiv,
         rd2a_res         => rd2a_res,
         rdc_freq         => rdc_freq,
         rdfe_en          => xadce_rdfe_en,
         rf_hpf           => rf_hpf,
         rf_lpf           => rf_lpf,
         rhf_os           => rhf_os,
         rhyst_hf         => rhyst_hf,
         rhyst_lf         => rhyst_lf,
         rlf_os           => rlf_os,
         rrect_adj        => rrect_adj,
         rrgen_bw         => rrgen_bw,
         rrgen_set        => rrgen_set,
         rrgen_vod        => rrgen_vod,
         rseq_sel         => rseq_sel,
         standby          => xadce_standby,
         vbn              => xadce_vbn,

         atb0             => xadce_atb0,
         atb1             => xadce_atb1,
         atb_0            => atb_0,
         atb_1            => atb_1,
         ib50u_c          => xadce_ib50u_c,
         ib50u_t          => xadce_ib50u_t,
         outeqn           => xadce_rxn,
         outeqp           => xadce_rxp,
         vccehxqyx        => vccehxqyx,
         vccerxqyx        => vccerxqyx,
         vctl_quiet       => xadce_vctl_quiet,
         vssexqyx         => vssexqyx,

         adapt_done       => xadce_adapt_done,
         e_clk            => xadce_hf_clk,
         eqa_ctrl         => eqa_ctrl_wire,
         eqb_ctrl         => eqb_ctrl_wire,
         eqc_ctrl         => eqc_ctrl_wire,
         eqctrlout        => xadce_eqctrlout,
         eqd_ctrl         => eqd_ctrl_wire,
         eqv_ctrl         => eqv_ctrl_wire,
         fine_d2aout      => xadce_fine_d2aout,
         hf_adapt_done    => xadce_hf_adapt_done,
         hfclk_macro      => xadce_hfclk_macro,
         hfmac_cnt0_nclr  => xadce_hfmac_cnt0_nclr,
         hfmac_cnt2_nclr  => xadce_hfmac_cnt2_nclr,
         ibrgen1          => xadce_ibrgen1,
         ibrgen2          => xadce_ibrgen2,
         lf_adapt_done    => xadce_lf_adapt_done,
         lfclk_macro      => xadce_lfclk_macro,
         lfmac_cnt0_nclr  => xadce_lfmac_cnt0_nclr,
         lfmac_cnt2_nclr  => xadce_lfmac_cnt2_nclr,
         r_clk            => xadce_lf_clk,
         rgenctrlout      => xadce_rgenctrlout,
         tmxselan         => xadce_tmxselan,
         tmxselbn         => xadce_tmxselbn,
         tmxselcn         => xadce_tmxselcn,
         tmxseldn         => xadce_tmxseldn,
         tmxselvn         => xadce_tmxselvn,
         updnn_hf         => xadce_updnn_hf,
         updnn_lf         => xadce_updnn_lf
      );
   adaptdone <= xadce_adapt_done;
   ck0_sigdet <= NOT(deserclock(3));
   lpbkp <= seriallpbkin WHEN (seriallpbkin = '0' OR seriallpbkin = '1') ELSE '0';
   rs_lpbk <= '0' WHEN (cram_rrx_s_lpbk = '0') ELSE seriallpbken;
   rx_p <= datain WHEN (datain = '1' OR datain = '0') ELSE '0';
   rx_n <= NOT(rx_p);
   rx_refclk <= '0';
   rx_testclk <= '0';
   rrx_bit_dc <= cram_rrx_bit_dc;
   rrx_lst <= cram_rrx_lst;
   rrx_oc <= cram_rrx_oc;
   rrx_oc_en <= offsetcancellationen;
   rx_pdb <= '0' WHEN (powerdn = '1') ELSE '1';
   rrx_sd_force <= cram_rrx_sd_force;
   rrx_sd_off <= cram_rrx_sd_off;
   rrx_sd_on <= cram_rrx_sd_on;
   rrx_sdlv <= cram_rrx_sdlv;
   rrx_s_rdlpbk <= cram_rrx_s_rdlpbk;
   rrx_test <= '0';
   rrx_vtt <= cram_rrx_vtt;
      
   xrx : stratixiv_hssi_pma_c_rx
      PORT MAP (
         atbsel       => rx_atbsel,
         ck0_sigdet   => ck0_sigdet,
         eqa_ctrl     => eqa_ctrl_wire,
         eqb_ctrl     => eqb_ctrl_wire,
         eqc_ctrl     => eqc_ctrl_wire,
         eqd_ctrl     => eqd_ctrl_wire,
         eqv_ctrl     => eqv_ctrl_wire,
         ibc50u       => ibc50u,
         ibp50u       => ibp50u,
         ibp150u      => ibp150u,
         inn          => rx_n,
         inp          => rx_p,
         lpbkn        => lpbkn,
         lpbkp        => lpbkp,
         oc_calpd     => wire_oc_calpd,
         oc_en        => rrx_oc_en,
         pdb          => rx_pdb,
         rbit_dc      => rrx_bit_dc,
         refclk       => rx_refclk,
         rx_b50       => rx_50,
         rx_oc        => rrx_oc,
         rx_test      => rrx_test,
         rx_testclk   => rx_testclk,
         s_lpbk       => rs_lpbk,
         s_rdlpbk     => rrx_s_rdlpbk,
         sd_force     => rrx_sd_force,
         sd_off       => rrx_sd_off,
         sd_on        => rrx_sd_on,
         sdlv         => rrx_sdlv,
         term         => rrx_term,
         vccehtxqyx   => vccehtxqyx,
         vcce_la      => vcce_la,
         vcce_oa      => vcce_oa,
         vssexqyx     => vssexqyx,
         vtt          => rrx_vtt(2 DOWNTO 0),
         atb_0        => atb_0,
         atb_1        => atb_1,
         analog_sd    => analog_sd_icd,
         inn3         => rx_eqout_n,
         inp3         => rx_eqout_p,
         rdlpbkn      => rx_rlpbkn,
         rdlpbkp      => rx_rlpbkp,
         rxn          => cdr_rxn,
         rxp          => cdr_rxp,
         sd_cdr       => sd_cdr,
         rxbuf_ibias  => wire_rxbuf_ibias,
         sd_cpon      => wire_sd_cpon,
         sd_cpop      => wire_sd_cpop
      );
   
   dataout <= cdr_rxp;
   signaldetect <= analog_sd;
   analog_sd <= analog_sd_sw;
   analog_sd_sw <= signaldetect_reg;
   sd_rx <= seriallpbkin WHEN (rs_lpbk = '1') ELSE datain;
   sd_reset <= '1' WHEN (powerdn = '1' OR rxpmareset = '1') ELSE '0';
   
   PROCESS (sd_reset, sd_rx)
VARIABLE  txt : LINE;
   BEGIN
      IF (sd_reset = '1') THEN
         signaldetect_reg <= '0';
      ELSIF (sd_rx = '0' OR sd_rx = '1') THEN
         signaldetect_reg <= '1';
      ELSE
         signaldetect_reg <= '0';
      END IF;
   END PROCESS;
   
   ppmdetect_fref_in <= ppmdetectrefclk;
   ppmdetect_fvcobyn_in <= ppmdetectdividedclk;
   ppmdetect_hardreset_in <= '0' WHEN (rxpmareset = '1') ELSE '1';
   ppmdetect_pd_in <= '0' WHEN (powerdn = '1') ELSE '1';
   ppmdetect_ppmsel_in <= cram_rppmsel;
     
   xppmdetect : stratixiv_hssi_pma_ppmdetect
      PORT MAP (
         fref           => ppmdetect_fref_in,
         fvcobyn        => ppmdetect_fvcobyn_in,
         hard_reset     => ppmdetect_hardreset_in,
         pd             => ppmdetect_pd_in,
         ppmsel         => ppmdetect_ppmsel_in,
         ppm_cnt_reset  => ppmdetect_ppmcntreset_in,
         scan_mode      => ppmdetect_scanmode_in,
         rforcehigh     => ppmdetect_rforcehigh_in,
         rforcelow      => ppmdetect_rforcelow_in,
         freq_lock      => ppmdetect_freqlock_out,
         ppm_cnt_latch  => ppmdetect_ppmcntlatch_out
      );
   mrxpll_not_locked <= '0' WHEN (plllocked = '1') ELSE
                        '1';
   signal_detect_reg_n <= NOT(analog_sd);
   
   PROCESS (ppmdetectrefclk, rxpmareset)
VARIABLE  txt : LINE;
   BEGIN
      IF (rxpmareset = '1') THEN
         mfreqlocked_reg <= '0';
      ELSIF (ppmdetectrefclk'EVENT AND ppmdetectrefclk = '1') THEN
         IF (mfreqlocked_cnt = "1111") THEN
            mfreqlocked_reg <= '1';
         ELSE
            mfreqlocked_reg <= '0';
         END IF;
      END IF;
   END PROCESS;
   
   PROCESS (ppmdetectrefclk, mrxpll_not_locked, signal_detect_reg_n)
VARIABLE  txt : LINE;
   BEGIN
      IF (ppmdetectrefclk'EVENT AND ppmdetectrefclk = '1') THEN
         IF (mrxpll_not_locked = '1' OR signal_detect_reg_n = '1') THEN
            mfreqlocked_cnt <= "0000";
         ELSIF (mfreqlocked_cnt /= "1111") THEN
            mfreqlocked_cnt <= mfreqlocked_cnt + "0001";
         END IF;
      END IF;
   END PROCESS;
   
   lck2refctl_freqlock_in <= mfreqlocked_reg;
   cdr_pdb <= '0' WHEN (powerdn = '1') ELSE
              '1';
   ck0_pd <= deserclock(0);
   ck90_pd <= deserclock(1);
   ck180_pd <= deserclock(2);
   ck270_pd <= deserclock(3);
   ignore_phslck <= ignorephslck;
   ltd <= locktodata;
   ltr <= locktoref;
   rlbk <= cram_rlpbk;
   rlpbk_pre_en <= cram_rrx_s_rdlpbk;
   rst_n <= '0' WHEN (rxpmareset = '1') ELSE
            '1';
   deven <= recoverdatain(0);
   dodd <= recoverdatain(1);
   devenb <= NOT(recoverdatain(0));
   doddb <= NOT(recoverdatain(1));
   lck2ref <= '1' WHEN ((NOT(cdr_pdb)) = '1') ELSE
              '1' WHEN ((NOT(sd_cdr) OR NOT(lck2refctl_freqlock_in)) = '1') ELSE
              '1' WHEN ((sd_cdr AND lck2refctl_freqlock_in AND NOT(plllocked) AND NOT(ignore_phslck)) = '1') ELSE
              '0' WHEN ((sd_cdr AND lck2refctl_freqlock_in AND plllocked) = '1') ELSE
              '0';
   rxpll_lock <= NOT(lck2ref);
   pdbx <= cdr_pdb AND rlbk;
   rstb_slpbk <= pdbx AND rst_n;
   clk90_slpbk <= NOT((ck90_pd AND pdbx));
   clk270_slpbk <= NOT((ck270_pd AND pdbx));
   rstn2 <= pe AND vssex;
   pe <= NOT(pdbx) AND rst_n AND rlpbk_pre_en;
   PROCESS (clk90_slpbk, rstb_slpbk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rstb_slpbk = '0') THEN
         devenout <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         devenbout <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         doddx <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         oddbx <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk90_slpbk'EVENT AND clk90_slpbk = '1') THEN
         devenout <=  TRANSPORT deven AFTER (PARAM_DELAY)*1 ps;
          
         devenbout <=  TRANSPORT devenb AFTER (PARAM_DELAY)*1 ps;
          
         doddx <=  TRANSPORT dodd AFTER (PARAM_DELAY)*1 ps;
          
         oddbx <=  TRANSPORT doddb AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (clk270_slpbk, rstb_slpbk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rstb_slpbk = '0') THEN
         doddout <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         oddbout <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk270_slpbk'EVENT AND clk270_slpbk = '1') THEN
         doddout <=  TRANSPORT doddx AFTER (PARAM_DELAY)*1 ps;
          
         oddbout <=  TRANSPORT oddbx AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (clk270_slpbk, rst_n)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_n = '0') THEN
         oe1 <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         oeb1 <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk270_slpbk'EVENT AND clk270_slpbk = '1') THEN
         oe1 <=  TRANSPORT devenout AFTER (PARAM_DELAY)*1 ps;
          
         oeb1 <=  TRANSPORT devenbout AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (clk90_slpbk, rst_n)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_n = '0') THEN
         oo1 <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         oob1 <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk90_slpbk'EVENT AND clk90_slpbk = '1') THEN
         oo1 <=  TRANSPORT doddout AFTER (PARAM_DELAY)*1 ps;
          
         oob1 <=  TRANSPORT oddbout AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (clk270_slpbk, pdbx)
VARIABLE  txt : LINE;
   BEGIN
      IF (pdbx = '0') THEN
         rxlpbp_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbn_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk270_slpbk'EVENT AND clk270_slpbk = '1') THEN
         rxlpbp_int <=  TRANSPORT devenout AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbn_int <=  TRANSPORT devenbout AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (clk90_slpbk, pdbx)
VARIABLE  txt : LINE;
   BEGIN
      IF (pdbx = '0') THEN
         rxlpbp_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbn_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk90_slpbk'EVENT AND clk90_slpbk = '1') THEN
         rxlpbp_int <=  TRANSPORT doddout AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbn_int <=  TRANSPORT oddbout AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (clk90_slpbk, pe)
VARIABLE  txt : LINE;
   BEGIN
      IF (pe = '0') THEN
         rxlpbdp_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbdn_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk90_slpbk'EVENT AND clk90_slpbk = '1') THEN
         rxlpbdp_int <=  TRANSPORT oe1 AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbdn_int <=  TRANSPORT oeb1 AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   PROCESS (clk270_slpbk, pe)
VARIABLE  txt : LINE;
   BEGIN
      IF (pe = '0') THEN
         rxlpbdp_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbdn_int <=  TRANSPORT '1' AFTER (PARAM_DELAY)*1 ps;
          
      ELSIF (clk270_slpbk'EVENT AND clk270_slpbk = '1') THEN
         rxlpbdp_int <=  TRANSPORT oo1 AFTER (PARAM_DELAY)*1 ps;
          
         rxlpbdn_int <=  TRANSPORT oob1 AFTER (PARAM_DELAY)*1 ps;
          
      END IF;
   END PROCESS;
   
   rxlpbp <= rxlpbp_int;
   rxlpbn <= rxlpbn_int;
   rxlpbdp <= rxlpbdp_int;
   rxlpbdn <= rxlpbdn_int;
   locktorefout <= lck2ref;
   revserialfdbkout <= rxlpbp;
   rrevlb_sw <= cram_rrevlb_sw;
   cdr_rlpbkn <= rxlpbn;
   cdr_rlpbkp <= rxlpbp;
   cdr_rlpbkdn <= rxlpbdn;
   cdr_rlpbkdp <= rxlpbdp;
   
   
   xrlpbk_mux : stratixiv_hssi_pma_c_rlpbk_mux
      PORT MAP (
         doddn    => vssex,
         doddp    => vssex,
         dodn     => cdr_rlpbkdn,
         dodp     => cdr_rlpbkdp,
         don      => cdr_rlpbkn,
         don_pre  => vssex,
         dop      => cdr_rlpbkp,
         dop_pre  => vssex,
         drxn     => rx_rlpbkn,
         drxp     => rx_rlpbkp,
         sel      => rrevlb_sw,
         vcce_la  => vcce_la,
         vssex    => vssex,
         voddn    => ncvondp,
         voddp    => ncvopdp,
         vodn     => rlpbkdn,
         vodp     => rlpbkdp,
         von      => rlpbkn,
         von_pre  => ncvonp,
         vop      => rlpbkp,
         vop_pre  => ncvopp
      );

   reverselpbkout <= cdr_rxp;
   xdeser_clk90_in <= NOT(deserclock(1)) WHEN (deserialization_factor <= 20) ELSE
                      '0';
   xdeser_pdb_in <= '0' WHEN (powerdn = '1') ELSE
                   '1';
   xdeser_div2_in <= cram_rpma_doublewidth_rx;
   xdeser_div5_in <= cram_rpmadwidth_rx;
   xdeser_rst_n <= '0' WHEN (rxpmareset = '1') ELSE
                  '1';
   xdeser_pcie_sw <= '0';
   rdynamic_sw <= '0';
   xdeser_10g_clk90b <= NOT(deserclock(1)) WHEN (deserialization_factor > 20) ELSE
                        '0';
   xdeser_10g_deven <= recoverdatain(0) WHEN (deserialization_factor > 20) ELSE
                       '0';
   xdeser_10g_dodd <= recoverdatain(1) WHEN (deserialization_factor > 20) ELSE
                      '0';
   xdeser_10g_devenb <= NOT(recoverdatain(0)) WHEN (deserialization_factor > 20) ELSE
                        '0';
   xdeser_10g_doddb <= NOT(recoverdatain(1)) WHEN (deserialization_factor > 20) ELSE
                       '0';
   xdeser_10g_pdb <= '0' WHEN (powerdn = '1') ELSE
                     '1';
   xdeser_10g_rst_n <= '0' WHEN (rxpmareset = '1') ELSE
                       '1';
   
   
   xdeser : stratixiv_hssi_pma_c_deser
      PORT MAP (
         clk90b        => xdeser_clk90_in,
         deser_div2    => xdeser_div2_in,
         deser_div5    => xdeser_div5_in,
         deser_pdb     => xdeser_pdb_in,
         deven         => deven,
         devenb        => devenb,
         dodd          => dodd,
         doddb         => doddb,
         pcie_sw       => xdeser_pcie_sw,
         rdynamic_sw   => rdynamic_sw,
         rfast_sd      => rfast_sd,
         rst_n         => xdeser_rst_n,
         rtest_fastsd  => wire_rtest_fastsd,
         rxinn         => rx_rlpbkn,		-- from c_rx
         rxinp         => rx_rlpbkp,		-- from c_rx
         vcce_la       => vcce_la,
         vssexqyx      => vssexqyx,
         
         clk_divrx     => xdeser_clkdivrx_out,
         dout          => xdeser_dout_out,
         fsd           => xdeser_fsd_out,
         pcieo         => xdeser_pcieo_out
      );  
   
   xdeser_10g : stratixiv_hssi_pma_c_deser_10g
      PORT MAP (
         clk90b     => xdeser_10g_clk90b,
         deser_pdb  => xdeser_10g_pdb,
         deven      => xdeser_10g_deven,
         devenb     => xdeser_10g_devenb,
         dodd       => xdeser_10g_dodd,
         doddb      => xdeser_10g_doddb,
         rst_n      => xdeser_10g_rst_n,
         vcce_la    => vcce_la,
         vssexqyx   => vssexqyx,
         
         clk_divrx  => xdeser_10g_clk_divrx,
         dout       => xdeser_10g_dout
      );
   
   -- outputs from the deserializer
   clockout <= xdeser_clkdivrx_out WHEN (allow_vco_bypass = 0 AND deserialization_factor <= 20) ELSE
               xdeser_10g_clk_divrx WHEN (allow_vco_bypass = 0) ELSE
               (NOT ppmdetectrefclk) WHEN (allow_vco_bypass = 1) ELSE
               ppmdetectdividedclk WHEN (allow_vco_bypass = 2) ELSE
               xdeser_clkdivrx_out;
   recoverdataout(19 DOWNTO 0) <= ('Z' & 'Z' & 'Z' & 'Z' & xdeser_dout_out(17 DOWNTO 10) & xdeser_dout_out(7 DOWNTO 0)) WHEN (use_pma_direct = "true" and deserialization_factor = 16) ELSE
                                  xdeser_dout_out WHEN (deserialization_factor <= 20) ELSE
                                  xdeser_10g_dout(19 DOWNTO 0);
   recoverdataout(63 DOWNTO 20) <= ('Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z' & 'Z') WHEN (deserialization_factor <= 20) ELSE
                                   xdeser_10g_dout(63 DOWNTO 20);
  
   dataoutfull <= xdeser_dout_out; 

   analogtestbus <= "00000000";

END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_pcs_reset IS
   PORT (
      
      hard_reset   : IN STD_LOGIC;
      clk_2_b      : IN STD_LOGIC;
      refclk_b_in  : IN STD_LOGIC;
      scan_mode    : IN STD_LOGIC;
      rxpcs_rst    : IN STD_LOGIC;
      txpcs_rst    : IN STD_LOGIC;
      
      rxrst_int    : OUT STD_LOGIC;
      txrst_int    : OUT STD_LOGIC
   );
END stratixiv_hssi_pcs_reset;

ARCHITECTURE trans OF stratixiv_hssi_pcs_reset IS
   
   SIGNAL txrst_sync1 : STD_LOGIC := '0';
   SIGNAL txrst_sync2 : STD_LOGIC := '0';
   SIGNAL rxrst_sync1 : STD_LOGIC := '0';
   SIGNAL rxrst_sync2 : STD_LOGIC := '0';
BEGIN
   
   PROCESS (hard_reset, clk_2_b)
VARIABLE  txt : LINE;
   BEGIN
      IF (hard_reset = '1') THEN
         rxrst_sync2 <= '1';
         rxrst_sync1 <= '1';
      ELSIF (clk_2_b'EVENT AND clk_2_b = '1') THEN
         rxrst_sync2 <=  TRANSPORT rxrst_sync1 AFTER 1* 1 ps;
         rxrst_sync1 <= rxpcs_rst;
      END IF;
   END PROCESS;
   
   PROCESS (hard_reset, refclk_b_in)
VARIABLE  txt : LINE;
   BEGIN
      IF (hard_reset = '1') THEN
         txrst_sync2 <= '1';
         txrst_sync1 <= '1';
      ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
         txrst_sync2 <=  TRANSPORT txrst_sync1 AFTER 1* 1 ps;
         txrst_sync1 <= txpcs_rst;
      END IF;
   END PROCESS;
   
   -- 06-14-02 BT Changed SCAN_SHIFT signal to SCAN_MODE
   --assign rxrst_int = !SCAN_SHIFT & rxrst_sync2;
   --assign txrst_int = !SCAN_SHIFT & txrst_sync2;
   rxrst_int <= NOT(scan_mode) AND rxrst_sync2;
   txrst_int <= NOT(scan_mode) AND txrst_sync2;
   
END trans;



LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_digi_chnl_hip_spt IS
   PORT (
      
      rhip_ena                : IN STD_LOGIC;
      
      pcs_rxd_ch              : IN STD_LOGIC_VECTOR(8 DOWNTO 0);
      pcs_rxvalid             : IN STD_LOGIC;
      pcs_rxelecidle          : IN STD_LOGIC;
      pcs_rxstatus_ch         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      pcs_phystatus           : IN STD_LOGIC;
      txpma_local_clk         : IN STD_LOGIC;
      txd_ch                  : IN STD_LOGIC_VECTOR(10 DOWNTO 0);
      hip_txd_ch              : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
      txdetectrxloopback      : IN STD_LOGIC;
      hip_txdetectrxloopback  : IN STD_LOGIC;
      rxpolarity              : IN STD_LOGIC;
      hip_rxpolarity          : IN STD_LOGIC;
      powerdown_ch            : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      hip_powerdown_ch        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      txdeemph                : IN STD_LOGIC;
      hip_txdeemph            : IN STD_LOGIC;
      txmargin_ch             : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      hip_txmargin_ch         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel_ch        : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      hip_eidleinfersel_ch    : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rate                    : IN STD_LOGIC;
      hip_rate                : IN STD_LOGIC;
      hip_txelecidle          : IN STD_LOGIC;
      
      rxd_ch                  : OUT STD_LOGIC_VECTOR(8 DOWNTO 0);
      hip_rxd_ch              : OUT STD_LOGIC_VECTOR(8 DOWNTO 0);
      rxvalid                 : OUT STD_LOGIC;
      hip_rxvalid             : OUT STD_LOGIC;
      rxelecidle              : OUT STD_LOGIC;
      hip_rxelecidle          : OUT STD_LOGIC;
      rxstatus_ch             : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      hip_rxstatus_ch         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      phystatus               : OUT STD_LOGIC;
      hip_phystatus           : OUT STD_LOGIC;
      hip_tx_clk              : OUT STD_LOGIC;
      pcs_txd_ch              : OUT STD_LOGIC_VECTOR(10 DOWNTO 0);
      pcs_txdetectrxloopback  : OUT STD_LOGIC;
      pcs_rxpolarity          : OUT STD_LOGIC;
      pcs_powerdown_ch        : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      pcs_txdeemph            : OUT STD_LOGIC;
      pcs_txmargin_ch         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      pcs_eidleinfersel_ch    : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      pcs_rate                : OUT STD_LOGIC
   );
END stratixiv_hssi_digi_chnl_hip_spt;

ARCHITECTURE trans OF stratixiv_hssi_digi_chnl_hip_spt IS
BEGIN
   
   --// SECTION for SPLIT signals
   --// ===============================
   --//
   -- MUX/SPLIT #5,6,7,8 in Excel spreadsheet
   rxd_ch <= pcs_rxd_ch;
   hip_rxd_ch <= pcs_rxd_ch WHEN (rhip_ena = '1') ELSE
                 "000000000";
   
   -- MUX/SPLIT #16 in Excel spreadsheet
   rxvalid <= pcs_rxvalid;
   hip_rxvalid <= pcs_rxvalid WHEN (rhip_ena = '1') ELSE
                  '0';
   
   -- MUX/SPLIT #17 in Excel spreadsheet
   rxelecidle <= pcs_rxelecidle;
   hip_rxelecidle <= pcs_rxelecidle WHEN (rhip_ena = '1') ELSE
                     '1';
   
   -- MUX/SPLIT #18,19,20,21 in Excel spreadsheet
   rxstatus_ch <= pcs_rxstatus_ch;
   hip_rxstatus_ch <= pcs_rxstatus_ch WHEN (rhip_ena = '1') ELSE
                      "000";
   
   -- MUX/SPLIT #22 in Excel spreadsheet
   phystatus <= pcs_phystatus;
   hip_phystatus <= pcs_phystatus WHEN (rhip_ena = '1') ELSE
                    '0';
   
   hip_tx_clk <= txpma_local_clk;
   
   --// SECTION for MUX signals
   --// ===============================
   --//
   -- MUX/SPLIT #1,2,3,4 in Excel spreadsheet
   pcs_txd_ch <= (hip_txelecidle & hip_txd_ch) WHEN (rhip_ena = '1') ELSE
                 txd_ch;
   
   -- MUX/SPLIT #10 in Excel spreadsheet
   pcs_txdetectrxloopback <= hip_txdetectrxloopback WHEN (rhip_ena = '1') ELSE
                             txdetectrxloopback;
   
   -- MUX/SPLIT #11 in Excel spreadsheet
   pcs_rxpolarity <= hip_rxpolarity WHEN (rhip_ena = '1') ELSE
                     rxpolarity;
   
   -- MUX/SPLIT #12,13,14,15 in Excel spreadsheet
   pcs_powerdown_ch <= hip_powerdown_ch WHEN (rhip_ena = '1') ELSE
                       powerdown_ch;
   
   -- MUX/SPLIT #23 in Excel spreadsheet
   pcs_txdeemph <= hip_txdeemph WHEN (rhip_ena = '1') ELSE
                   txdeemph;
   
   -- MUX/SPLIT #24,25,26,27 in Excel spreadsheet
   pcs_txmargin_ch <= hip_txmargin_ch WHEN (rhip_ena = '1') ELSE
                      txmargin_ch;
   
   -- MUX/SPLIT #28,29,30,31 in Excel spreadsheet
   pcs_eidleinfersel_ch <= hip_eidleinfersel_ch WHEN (rhip_ena = '1') ELSE
                           eidleinfersel_ch;
   
   -- MUX/SPLIT #32 in Excel spreadsheet
   pcs_rate <= hip_rate WHEN (rhip_ena = '1') ELSE
               rate;
   
END trans;





LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_phystatus_generator_fsm IS
   PORT (
      
      -- General signals
      
      --CRAM
      -- OR of rtx_pipe_enable and rrx_pipe_enable
      -- no toggle (gen 2) = 0, toggle (option for gen 1) = 1
      
      -- PLD Interface
      -- power state control
      -- communicate completion of power state transitions, receiver 
      -- detection, rate change
      
      -- Auto Negotiation Module
      -- asserted when signaling rate change between Gen 1 and Gen 2
      
      -- RX PIPE Interface
      --	p1_sync,
      
      -- PMA interface
      -- TX PMA
      -- rx_detect_bypass = 0 : Validation of rx_found: 
      -- 					synchronized at pipe_interface_top level
      -- rx_detect_bypass = 1 : delayed version of txdetectrx
      
      -- RX PMA
      -- asserted when successful power state transition occurs
      -- validates power_state_transition_done, currently tied to 0
      
      -- Latched Power State Signals
      -- P1 power state from TX PIPE interface
      
      -- Internal Power State Done Generator
      -- faked successful power state transition generated by internal	
      -- power state transition done module
      
      --********************************************************************************
      -- INCLUDE STATEMENTS
      --********************************************************************************
      
      --********************************************************************************
      -- I/O SIGNALS
      --********************************************************************************
      -- General signals
      clk                              : IN STD_LOGIC;
      reset_n                          : IN STD_LOGIC;
      
      -- CRAM
      phystat_ena                      : IN STD_LOGIC;
      rphystatus_rst_toggle            : IN STD_LOGIC;
      
      -- PLD Interface
      powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      phystatus                        : OUT STD_LOGIC;
      
      rindv_rx                         : IN STD_LOGIC;		-- Select between XAUI mode or indiv  channel mode
      rmaster_rx                       : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rmaster_up_rx                    : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      
      -- Auto Negotiation Module
      speed_change                     : IN STD_LOGIC;
      speed_change_centrl              : IN STD_LOGIC;
      speed_change_quad_up             : IN STD_LOGIC;
      speed_change_quad_down           : IN STD_LOGIC;
      
      -- RX PIPE Interface
      --output			p1_sync;
      
      -- PMA interface
      -- TX PMA
      rx_detect_valid                  : IN STD_LOGIC;
      
      -- RX PMA
      power_state_transition_done      : IN STD_LOGIC;
      power_state_transition_done_ena  : IN STD_LOGIC;
      
      -- Latched Power state signals
      p1                               : IN STD_LOGIC;		-- longer recovery time (64 us max) latency
      
      -- Internal Power State Done Generator
      internal_done                    : IN STD_LOGIC
   );
END stratixiv_hssi_phystatus_generator_fsm;

ARCHITECTURE trans OF stratixiv_hssi_phystatus_generator_fsm IS
   
   --********************************************************************************
   -- PARAMETERS
   --********************************************************************************
   
   --********************************************************************************
   -- DECLARATIONS
   --********************************************************************************
   --reg		phystatus;
   
   -- select between PMA done and internally generated done
   SIGNAL done                                 : STD_LOGIC;
   SIGNAL pre_power_state_transition_done_sync : STD_LOGIC;
   SIGNAL power_state_transition_done_sync     : STD_LOGIC;
   SIGNAL power_state_transition_done_sync_reg : STD_LOGIC;
   
   -- Reset condition
   SIGNAL reset_phystatus                      : STD_LOGIC;
   
   -- State transition
   SIGNAL state_transition_phystatus           : STD_LOGIC;
   
   -- Speed Negotiation
   SIGNAL speed_change_reg                     : STD_LOGIC;
   SIGNAL speed_change_sync                    : STD_LOGIC;
   SIGNAL speed_change_sync_reg                : STD_LOGIC;
   SIGNAL speed_change_phystatus               : STD_LOGIC;
   
   -- Receiver Detection
   --reg		p1_reg;				// synchronize from tx clk domain to rx clk domain
   --reg		p1_sync;
   
   SIGNAL rx_detect_valid_reg                  : STD_LOGIC;		-- Edge detection of receiver detection status signal
   SIGNAL rx_detect_valid_phystatus            : STD_LOGIC;
   
   -- P2 exit detection
   SIGNAL decode_p2                            : STD_LOGIC;
   SIGNAL decode_p2_reg                        : STD_LOGIC;
   SIGNAL decode_p2_reg1                       : STD_LOGIC;
   SIGNAL phystatus_high_sel                   : STD_LOGIC;
   SIGNAL phystatus_high_sel_reg               : STD_LOGIC;
   
   -- Reset
   SIGNAL phystatus_toggle_sel                 : STD_LOGIC;
   SIGNAL phystatus_toggle_sel_reg             : STD_LOGIC;
   
   SIGNAL pre_phystatus                        : STD_LOGIC;
   
   SIGNAL speed_change_local                   : STD_LOGIC;
   
   SIGNAL speed_change_centrl_del1             : STD_LOGIC;
   SIGNAL speed_change_centrl_del2             : STD_LOGIC;
BEGIN
   
   --********************************************************************************
   -- ASSIGN STATEMENTS
   --********************************************************************************
   -- Move to PLD interface
   phystatus <= '1' WHEN ((NOT(decode_p2) AND decode_p2_reg1) = '1') ELSE
                pre_phystatus;
   --assign phystatus= pre_phystatus;
   
   done <= (power_state_transition_done_sync AND NOT(power_state_transition_done_sync_reg)) WHEN (power_state_transition_done_ena = '1') ELSE
           internal_done;
   
   decode_p2 <= phystat_ena WHEN (powerdown = "11") ELSE
                '0';
   
   --********************************************************************************
   -- SUBMODULE INSTANTIATIONS
   --********************************************************************************
   
   --********************************************************************************
   -- MAIN CODE
   --********************************************************************************
   -- Reset phystatus generation
   
   -- Phystatus is asserted during reset and then the successful 'transition' into P1 is signal by the assertion
   -- phystatus for 1 cycle.  Unlike regular operation, the first entry into P1 is not indicated by a 'done' signal
   -- The assertion of phystatus occurs 4 cycles after reset is released
   PROCESS (reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         reset_phystatus <= '1';
      ELSE
         reset_phystatus <= '0';
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, rphystatus_rst_toggle, done, phystatus_toggle_sel_reg)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         phystatus_toggle_sel <= '1';
      ELSIF ((rphystatus_rst_toggle OR done) = '1') THEN
         phystatus_toggle_sel <= '0';
      ELSE
         phystatus_toggle_sel <= phystatus_toggle_sel_reg;
      END IF;
   END PROCESS;
   
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         phystatus_toggle_sel_reg <=  TRANSPORT '1' AFTER 1* 1 ps;
         phystatus_high_sel_reg <=  TRANSPORT '1' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         phystatus_toggle_sel_reg <=  TRANSPORT phystatus_toggle_sel AFTER 1* 1 ps;
         phystatus_high_sel_reg <=  TRANSPORT phystatus_high_sel AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   -- State transition: sync PMA signal to local clk.  Currently not being used
   -- State transition: Internal done generator indicates that there was a successful state transition.  
   -- Illegal transitions have been taken into account by the previous module.
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         pre_power_state_transition_done_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
         power_state_transition_done_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
         
         power_state_transition_done_sync_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         pre_power_state_transition_done_sync <=  TRANSPORT power_state_transition_done AFTER 1* 1 ps;
         power_state_transition_done_sync <=  TRANSPORT pre_power_state_transition_done_sync AFTER 1* 1 ps;
         
         power_state_transition_done_sync_reg <=  TRANSPORT power_state_transition_done_sync AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, done)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         state_transition_phystatus <= '0';
      ELSIF (done = '1') THEN
            state_transition_phystatus <= '1';
         ELSE
            state_transition_phystatus <= '0';
         END IF;
   END PROCESS;
   
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         speed_change_centrl_del1 <=  TRANSPORT '0' AFTER 1* 1 ps;
         
         speed_change_centrl_del2 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         speed_change_centrl_del1 <=  TRANSPORT speed_change_centrl AFTER 1* 1 ps;
         speed_change_centrl_del2 <=  TRANSPORT speed_change_centrl_del1 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   -- always @ (posedge clk or negedge reset_n)
   
   speed_change_local <= speed_change WHEN (rindv_rx = '1') ELSE
                         speed_change_centrl_del2 WHEN (rmaster_rx = '1') ELSE
                         speed_change_quad_up WHEN (rmaster_up_rx = '1') ELSE
                         speed_change_quad_down;
   
   -- Speed Negotiation
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         speed_change_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
         speed_change_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
         
         speed_change_sync_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         speed_change_reg <=  TRANSPORT speed_change_local AFTER 1* 1 ps;
         speed_change_sync <=  TRANSPORT speed_change_reg AFTER 1* 1 ps;
         speed_change_sync_reg <=  TRANSPORT speed_change_sync AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, speed_change_sync, speed_change_sync_reg)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         speed_change_phystatus <= '0';
      ELSIF ((NOT(speed_change_sync) AND speed_change_sync_reg) = '1') THEN
         speed_change_phystatus <= '1';
      ELSE
         speed_change_phystatus <= '0';
      END IF;
   END PROCESS;
   
   -- Receiver Detection
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         --		p1_reg					<= 1'b0;
         --		p1_sync					<= 1'b0;
         
         --		rx_detect_valid_phystatus	<= 1'b0;
         rx_detect_valid_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         --		p1_reg					<= p1;
         --		p1_sync					<= p1_reg;
         
         --		rx_detect_valid_phystatus	<= p1_sync && rx_detect_valid && !rx_detect_valid_reg;
         rx_detect_valid_reg <=  TRANSPORT rx_detect_valid AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, p1, rx_detect_valid, rx_detect_valid_reg)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         --	else if (p1_sync && rx_detect_valid && !rx_detect_valid_reg)
         rx_detect_valid_phystatus <= '0';
      ELSIF ((p1 AND rx_detect_valid AND NOT(rx_detect_valid_reg)) = '1') THEN
         rx_detect_valid_phystatus <= '1';
      ELSE
         
         rx_detect_valid_phystatus <= '0';
      END IF;
   END PROCESS;
   
   -- P2 state exit Detection
   PROCESS (clk, reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         decode_p2_reg <=  TRANSPORT '0' AFTER 1* 1 ps;
         decode_p2_reg1 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         decode_p2_reg <=  TRANSPORT decode_p2 AFTER 1* 1 ps;
         decode_p2_reg1 <=  TRANSPORT decode_p2_reg AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, decode_p2, decode_p2_reg, phystatus_high_sel_reg, done)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         phystatus_high_sel <= '0';
      ELSIF ((NOT(decode_p2) AND decode_p2_reg) = '1') THEN
         phystatus_high_sel <= '1';
      ELSIF (done = '1') THEN
         phystatus_high_sel <= '0';
      ELSE
         phystatus_high_sel <= phystatus_high_sel_reg;
      END IF;
   END PROCESS;
   
   PROCESS (reset_n, phystatus_high_sel, reset_phystatus, state_transition_phystatus, rx_detect_valid_phystatus, phystatus_toggle_sel, speed_change_phystatus)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(reset_n)) = '1') THEN
         pre_phystatus <= '1';
      ELSE
         IF ((phystatus_high_sel OR reset_phystatus OR state_transition_phystatus OR rx_detect_valid_phystatus OR phystatus_toggle_sel OR speed_change_phystatus) = '1') THEN
            pre_phystatus <= '1';
         ELSE
            pre_phystatus <= '0';
         END IF;
      END IF;
   END PROCESS;
   
END trans;


-- always @ (reset_n or phystatus_high_sel or reset_phystatus or state_transition_phystatus or rx_detect_valid_phystatus...

-- phystatus_generator_fsm--IP Functional Simulation Model
--VERSION_BEGIN 10.1 cbx_mgl 2010:11:29:21:24:23:SJ cbx_simgen 2010:11:29:21:22:45:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 53 oper_mux 1 stratixiv_hssi_phystatus_generator_fsm 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_hssi_phystatus_generator IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p0	:	IN  STD_LOGIC;
		 latched_p0s	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 latched_p2	:	IN  STD_LOGIC;
		 phystat_ena	:	IN  STD_LOGIC;
		 phystatus	:	OUT  STD_LOGIC;
		 power_state_transition_done	:	IN  STD_LOGIC;
		 power_state_transition_done_ena	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 reset_n	:	IN  STD_LOGIC;
		 rindv_rx	:	IN  STD_LOGIC;
		 rmaster_rx	:	IN  STD_LOGIC;
		 rmaster_up_rx	:	IN  STD_LOGIC;
		 rphystatus_delay	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rphystatus_rst_toggle	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC;
		 speed_change	:	IN  STD_LOGIC;
		 speed_change_centrl	:	IN  STD_LOGIC;
		 speed_change_quad_down	:	IN  STD_LOGIC;
		 speed_change_quad_up	:	IN  STD_LOGIC
	 ); 
 END stratixiv_hssi_phystatus_generator;

 ARCHITECTURE RTL OF stratixiv_hssi_phystatus_generator IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 nllOi21	:	STD_LOGIC := '0';
	 SIGNAL	 nllOi22	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllOi22_w_lg_w_lg_q82w83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOi22_w_lg_q82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllOl19	:	STD_LOGIC := '0';
	 SIGNAL	 nllOl20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllOl20_w_lg_w_lg_q79w80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOl20_w_lg_q79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllOO17	:	STD_LOGIC := '0';
	 SIGNAL	 nllOO18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllOO18_w_lg_w_lg_q72w73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOO18_w_lg_q72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlO0l11	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0l12	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1i15	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1i16	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1O13	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1O14	:	STD_LOGIC := '0';
	 SIGNAL	 nlOii10	:	STD_LOGIC := '0';
	 SIGNAL	 nlOii9	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil7	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil8	:	STD_LOGIC := '0';
	 SIGNAL	 nlOli5	:	STD_LOGIC := '0';
	 SIGNAL	 nlOli6	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlO3	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlO4	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOl1	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOl2	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL	niii	:	STD_LOGIC := '0';
	 SIGNAL	wire_ni0O_CLRN	:	STD_LOGIC;
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n01i	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1OO	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	niil	:	STD_LOGIC := '0';
	 SIGNAL	niiO	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	nill	:	STD_LOGIC := '0';
	 SIGNAL	nilO	:	STD_LOGIC := '0';
	 SIGNAL	niOi	:	STD_LOGIC := '0';
	 SIGNAL	niOl	:	STD_LOGIC := '0';
	 SIGNAL	nl1i	:	STD_LOGIC := '0';
	 SIGNAL	wire_niOO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_niOO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_niOO_w_lg_w_lg_w_lg_w_lg_nill7w9w11w12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_w_lg_nill7w9w11w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_w_lg_nill7w9w16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_nill7w9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_w_lg_nill7w24w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_nill32w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_niil17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_niiO10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_nili8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_nill7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Oi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n1Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl0O_phystatus	:	STD_LOGIC;
	 SIGNAL  wire_nl0O_powerdown	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_w_lg_power_state_transition_done_ena60w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nlO0O :	STD_LOGIC;
	 SIGNAL  nlOiO :	STD_LOGIC;
	 COMPONENT  stratixiv_hssi_phystatus_generator_fsm
	 PORT
	 ( 
		clk	:	IN STD_LOGIC;
		internal_done	:	IN STD_LOGIC;
		p1	:	IN STD_LOGIC;
		phystat_ena	:	IN STD_LOGIC;
		phystatus	:	OUT STD_LOGIC;
		power_state_transition_done	:	IN STD_LOGIC;
		power_state_transition_done_ena	:	IN STD_LOGIC;
		powerdown	:	IN STD_LOGIC_VECTOR(1 DOWNTO 0);
		reset_n	:	IN STD_LOGIC;
		rindv_rx	:	IN STD_LOGIC;
		rmaster_rx	:	IN STD_LOGIC;
		rmaster_up_rx	:	IN STD_LOGIC;
		rphystatus_rst_toggle	:	IN STD_LOGIC;
		rx_detect_valid	:	IN STD_LOGIC;
		speed_change	:	IN STD_LOGIC;
		speed_change_centrl	:	IN STD_LOGIC;
		speed_change_quad_down	:	IN STD_LOGIC;
		speed_change_quad_up	:	IN STD_LOGIC
	 ); 
	 END COMPONENT;
 BEGIN

	wire_w_lg_power_state_transition_done_ena60w(0) <= NOT power_state_transition_done_ena;
	nlO0O <= '1';
	nlOiO <= ((((((wire_niOO_w_lg_w_lg_w_lg_w_lg_nill7w9w11w12w(0) AND (nlOOl2 XOR nlOOl1)) OR (wire_niOO_w_lg_w_lg_w_lg_nill7w9w16w(0) AND wire_niOO_w_lg_niil17w(0))) OR (NOT (nlOlO4 XOR nlOlO3))) OR ((wire_niOO_w_lg_w_lg_nill7w24w(0) AND wire_niOO_w_lg_niiO10w(0)) AND wire_niOO_w_lg_niil17w(0))) OR (NOT (nlOli6 XOR nlOli5))) OR ((wire_niOO_w_lg_nill32w(0) AND wire_niOO_w_lg_niiO10w(0)) AND wire_niOO_w_lg_niil17w(0)));
	phystatus <= wire_nl0O_phystatus;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOi21 <= nllOi22;
		END IF;
		if (now = 0 ns) then
			nllOi21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOi22 <= nllOi21;
		END IF;
	END PROCESS;
	wire_nllOi22_w_lg_w_lg_q82w83w(0) <= wire_nllOi22_w_lg_q82w(0) AND n1OO;
	wire_nllOi22_w_lg_q82w(0) <= nllOi22 XOR nllOi21;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOl19 <= nllOl20;
		END IF;
		if (now = 0 ns) then
			nllOl19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOl20 <= nllOl19;
		END IF;
	END PROCESS;
	wire_nllOl20_w_lg_w_lg_q79w80w(0) <= wire_nllOl20_w_lg_q79w(0) AND n01i;
	wire_nllOl20_w_lg_q79w(0) <= nllOl20 XOR nllOl19;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOO17 <= nllOO18;
		END IF;
		if (now = 0 ns) then
			nllOO17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOO18 <= nllOO17;
		END IF;
	END PROCESS;
	wire_nllOO18_w_lg_w_lg_q72w73w(0) <= wire_nllOO18_w_lg_q72w(0) AND n00l;
	wire_nllOO18_w_lg_q72w(0) <= nllOO18 XOR nllOO17;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0l11 <= nlO0l12;
		END IF;
		if (now = 0 ns) then
			nlO0l11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0l12 <= nlO0l11;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1i15 <= nlO1i16;
		END IF;
		if (now = 0 ns) then
			nlO1i15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1i16 <= nlO1i15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1O13 <= nlO1O14;
		END IF;
		if (now = 0 ns) then
			nlO1O13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1O14 <= nlO1O13;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOii10 <= nlOii9;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOii9 <= nlOii10;
		END IF;
		if (now = 0 ns) then
			nlOii9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOil7 <= nlOil8;
		END IF;
		if (now = 0 ns) then
			nlOil7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOil8 <= nlOil7;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOli5 <= nlOli6;
		END IF;
		if (now = 0 ns) then
			nlOli5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOli6 <= nlOli5;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlO3 <= nlOlO4;
		END IF;
		if (now = 0 ns) then
			nlOlO3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlO4 <= nlOlO3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOl1 <= nlOOl2;
		END IF;
		if (now = 0 ns) then
			nlOOl1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOl2 <= nlOOl1;
		END IF;
	END PROCESS;
	PROCESS (clk, wire_ni0O_CLRN)
	BEGIN
		IF (wire_ni0O_CLRN = '0') THEN
				ni0i <= '0';
				ni0l <= '0';
				ni1O <= '0';
				niii <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
			IF (nlOiO = '1') THEN
				ni0i <= niiO;
				ni0l <= nili;
				ni1O <= niil;
				niii <= nill;
			END IF;
		END IF;
	END PROCESS;
	wire_ni0O_CLRN <= ((nlO0l12 XOR nlO0l11) AND reset_n);
	PROCESS (clk, wire_niOO_PRN, wire_niOO_CLRN)
	BEGIN
		IF (wire_niOO_PRN = '0') THEN
				n00i <= '1';
				n00l <= '1';
				n00O <= '1';
				n01i <= '1';
				n01l <= '1';
				n01O <= '1';
				n0ii <= '1';
				n0il <= '1';
				n0iO <= '1';
				n0li <= '1';
				n0ll <= '1';
				n0lO <= '1';
				n0Ol <= '1';
				n0OO <= '1';
				n1lO <= '1';
				n1Ol <= '1';
				n1OO <= '1';
				ni1i <= '1';
				ni1l <= '1';
				niil <= '1';
				niiO <= '1';
				nili <= '1';
				nill <= '1';
				nilO <= '1';
				niOi <= '1';
				niOl <= '1';
				nl1i <= '1';
		ELSIF (wire_niOO_CLRN = '0') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n01i <= '0';
				n01l <= '0';
				n01O <= '0';
				n0ii <= '0';
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n1lO <= '0';
				n1Ol <= '0';
				n1OO <= '0';
				ni1i <= '0';
				ni1l <= '0';
				niil <= '0';
				niiO <= '0';
				nili <= '0';
				nill <= '0';
				nilO <= '0';
				niOi <= '0';
				niOl <= '0';
				nl1i <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n00i <= n00l;
				n00l <= n0ii;
				n00O <= wire_n1Oi_o;
				n01i <= n01l;
				n01l <= n01O;
				n01O <= n00i;
				n0ii <= n0il;
				n0il <= n0iO;
				n0iO <= n0li;
				n0li <= n0ll;
				n0ll <= ((phystat_ena AND wire_w_lg_power_state_transition_done_ena60w(0)) AND n0lO);
				n0lO <= (NOT (((((NOT ((ni1O XOR n0Ol) XOR (NOT (nlO1O14 XOR nlO1O13)))) AND (NOT (ni0i XOR n0OO))) AND (NOT (ni0l XOR ni1i))) AND (NOT (niii XOR ni1l))) AND (nlO1i16 XOR nlO1i15)));
				n0Ol <= ni1O;
				n0OO <= ni0i;
				n1lO <= n1Ol;
				n1Ol <= n1OO;
				n1OO <= n01i;
				ni1i <= ni0l;
				ni1l <= niii;
				niil <= nilO;
				niiO <= niOi;
				nili <= niOl;
				nill <= nl1i;
				nilO <= latched_p0;
				niOi <= latched_p0s;
				niOl <= latched_p1;
				nl1i <= latched_p2;
		END IF;
	END PROCESS;
	wire_niOO_CLRN <= ((nlOil8 XOR nlOil7) AND reset_n);
	wire_niOO_PRN <= (nlOii10 XOR nlOii9);
	wire_niOO_w_lg_w_lg_w_lg_w_lg_nill7w9w11w12w(0) <= wire_niOO_w_lg_w_lg_w_lg_nill7w9w11w(0) AND niil;
	wire_niOO_w_lg_w_lg_w_lg_nill7w9w11w(0) <= wire_niOO_w_lg_w_lg_nill7w9w(0) AND wire_niOO_w_lg_niiO10w(0);
	wire_niOO_w_lg_w_lg_w_lg_nill7w9w16w(0) <= wire_niOO_w_lg_w_lg_nill7w9w(0) AND niiO;
	wire_niOO_w_lg_w_lg_nill7w9w(0) <= wire_niOO_w_lg_nill7w(0) AND wire_niOO_w_lg_nili8w(0);
	wire_niOO_w_lg_w_lg_nill7w24w(0) <= wire_niOO_w_lg_nill7w(0) AND nili;
	wire_niOO_w_lg_nill32w(0) <= nill AND wire_niOO_w_lg_nili8w(0);
	wire_niOO_w_lg_niil17w(0) <= NOT niil;
	wire_niOO_w_lg_niiO10w(0) <= NOT niiO;
	wire_niOO_w_lg_nili8w(0) <= NOT nili;
	wire_niOO_w_lg_nill7w(0) <= NOT nill;
	wire_n1Oi_data <= ( n1lO & n1Ol & wire_nllOi22_w_lg_w_lg_q82w83w & wire_nllOl20_w_lg_w_lg_q79w80w & n01l & n01O & n00i & wire_nllOO18_w_lg_w_lg_q72w73w);
	wire_n1Oi_sel <= ( rphystatus_delay(2 DOWNTO 0));
	n1Oi :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1Oi_data,
		o => wire_n1Oi_o,
		sel => wire_n1Oi_sel
	  );
	wire_nl0O_powerdown <= ( powerdown(1 DOWNTO 0));
	nl0O :  stratixiv_hssi_phystatus_generator_fsm
	  PORT MAP ( 
		clk => clk,
		internal_done => n00O,
		p1 => latched_p1,
		phystat_ena => phystat_ena,
		phystatus => wire_nl0O_phystatus,
		power_state_transition_done => power_state_transition_done,
		power_state_transition_done_ena => power_state_transition_done_ena,
		powerdown => wire_nl0O_powerdown,
		reset_n => reset_n,
		rindv_rx => rindv_rx,
		rmaster_rx => rmaster_rx,
		rmaster_up_rx => rmaster_up_rx,
		rphystatus_rst_toggle => rphystatus_rst_toggle,
		rx_detect_valid => rx_detect_valid,
		speed_change => speed_change,
		speed_change_centrl => speed_change_centrl,
		speed_change_quad_down => speed_change_quad_down,
		speed_change_quad_up => speed_change_quad_up
	  );

 END RTL; --stratixiv_hssi_phystatus_generator
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 10.1 cbx_mgl 2010:11:29:21:24:23:SJ cbx_simgen 2010:11:29:21:22:45:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

--synthesis_resources = lut 50 mux21 146 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_hssi_rx_pipe_interface IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 polinv_rx	:	IN  STD_LOGIC;
		 polinv_rx_int	:	OUT  STD_LOGIC;
		 rclkcmpinsertpad	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rind_error_reporting	:	IN  STD_LOGIC;
		 rrdwidth_rx	:	IN  STD_LOGIC;
		 rrx_pipe_enable	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC;
		 rx_detect_valid_sync	:	IN  STD_LOGIC;
		 rx_found	:	IN  STD_LOGIC;
		 rx_found_sync	:	IN  STD_LOGIC;
		 rxd	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxd_ch	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxelecidle	:	OUT  STD_LOGIC;
		 rxelectricalidle	:	IN  STD_LOGIC;
		 rxpolarity	:	IN  STD_LOGIC;
		 rxstatus	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxvalid	:	OUT  STD_LOGIC;
		 sigdetni	:	IN  STD_LOGIC;
		 txdetectrx	:	IN  STD_LOGIC
	 ); 
 END stratixiv_hssi_rx_pipe_interface;

 ARCHITECTURE RTL OF stratixiv_hssi_rx_pipe_interface IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 n110l7	:	STD_LOGIC := '0';
	 SIGNAL	 n110l8	:	STD_LOGIC := '0';
	 SIGNAL  wire_n110l8_w_lg_q84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n111i11	:	STD_LOGIC := '0';
	 SIGNAL	 n111i12	:	STD_LOGIC := '0';
	 SIGNAL  wire_n111i12_w_lg_q92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n111O10	:	STD_LOGIC := '0';
	 SIGNAL  wire_n111O10_w_lg_q88w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n111O9	:	STD_LOGIC := '0';
	 SIGNAL	 n11ii5	:	STD_LOGIC := '0';
	 SIGNAL	 n11ii6	:	STD_LOGIC := '0';
	 SIGNAL  wire_n11ii6_w_lg_q77w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n11iO3	:	STD_LOGIC := '0';
	 SIGNAL	 n11iO4	:	STD_LOGIC := '0';
	 SIGNAL	 n11Ol1	:	STD_LOGIC := '0';
	 SIGNAL	 n11Ol2	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0ll41	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0ll42	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0Oi39	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0Oi40	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0OO37	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0OO38	:	STD_LOGIC := '0';
	 SIGNAL	 nlOi0l35	:	STD_LOGIC := '0';
	 SIGNAL	 nlOi0l36	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiil33	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiil34	:	STD_LOGIC := '0';
	 SIGNAL	 nlOilO31	:	STD_LOGIC := '0';
	 SIGNAL	 nlOilO32	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiOl29	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiOl30	:	STD_LOGIC := '0';
	 SIGNAL	 nlOl1l27	:	STD_LOGIC := '0';
	 SIGNAL	 nlOl1l28	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlii25	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlii26	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlli23	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlli24	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlOi21	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlOi22	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO0i17	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO0i18	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO1i19	:	STD_LOGIC := '0';
	 SIGNAL	 nlOO1i20	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOiO15	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOiO16	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOOl13	:	STD_LOGIC := '0';
	 SIGNAL	 nlOOOl14	:	STD_LOGIC := '0';
	 SIGNAL	n00ii	:	STD_LOGIC := '0';
	 SIGNAL	n0ill	:	STD_LOGIC := '0';
	 SIGNAL	n0iOi	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l	:	STD_LOGIC := '0';
	 SIGNAL	n1O0i	:	STD_LOGIC := '0';
	 SIGNAL	n1O1O	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0ilO_w_lg_w_lg_w_lg_n0iOi81w94w95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_w_lg_w_lg_n1O0i73w79w80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_w_lg_n0iOi81w94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_w_lg_n1O0i73w79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_n0iOi81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ilO_w_lg_n1O0i73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlOOO	:	STD_LOGIC := '0';
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_rrdwidth_rx82w85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rx_detect_valid_sync90w93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rx_detect_valid_sync75w78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rx_found_sync86w89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlO0iO267w268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlOl0l211w212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_latched_p174w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOl0i226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOl0i220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOii110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rclkcmpinsertpad227w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rclkcmpinsertpad221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rrdwidth_rx82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync90w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync75w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_detect_valid_sync259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_found_sync86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range52w279w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range20w235w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO00l272w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0iO267w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0li263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOili225w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOl0l211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOliO197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rclkcmpinsertpad205w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset_n72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rind_error_reporting109w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rrdwidth_rx199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_sigdetni66w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range51w277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range19w233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n11lO :	STD_LOGIC;
	 SIGNAL  nlO00i :	STD_LOGIC;
	 SIGNAL  nlO00l :	STD_LOGIC;
	 SIGNAL  nlO00O :	STD_LOGIC;
	 SIGNAL  nlO01i :	STD_LOGIC;
	 SIGNAL  nlO01l :	STD_LOGIC;
	 SIGNAL  nlO01O :	STD_LOGIC;
	 SIGNAL  nlO0ii :	STD_LOGIC;
	 SIGNAL  nlO0il :	STD_LOGIC;
	 SIGNAL  nlO0iO :	STD_LOGIC;
	 SIGNAL  nlO0li :	STD_LOGIC;
	 SIGNAL  nlOi0i :	STD_LOGIC;
	 SIGNAL  nlOi1l :	STD_LOGIC;
	 SIGNAL  nlOi1O :	STD_LOGIC;
	 SIGNAL  nlOiii :	STD_LOGIC;
	 SIGNAL  nlOili :	STD_LOGIC;
	 SIGNAL  nlOill :	STD_LOGIC;
	 SIGNAL  nlOl0i :	STD_LOGIC;
	 SIGNAL  nlOl0l :	STD_LOGIC;
	 SIGNAL  nlOl0O :	STD_LOGIC;
	 SIGNAL  nlOl1i :	STD_LOGIC;
	 SIGNAL  nlOliO :	STD_LOGIC;
	 SIGNAL  nlOllO :	STD_LOGIC;
	 SIGNAL  nlOlOO :	STD_LOGIC;
	 SIGNAL  nlOO0O :	STD_LOGIC;
	 SIGNAL  nlOO1O :	STD_LOGIC;
	 SIGNAL  nlOOii :	STD_LOGIC;
	 SIGNAL  nlOOil :	STD_LOGIC;
	 SIGNAL  nlOOll :	STD_LOGIC;
	 SIGNAL  nlOOlO :	STD_LOGIC;
	 SIGNAL  nlOOOi :	STD_LOGIC;
	 SIGNAL  wire_w_rxd_range52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_lg_rrdwidth_rx82w85w(0) <= wire_w_lg_rrdwidth_rx82w(0) AND wire_n110l8_w_lg_q84w(0);
	wire_w_lg_w_lg_rx_detect_valid_sync90w93w(0) <= wire_w_lg_rx_detect_valid_sync90w(0) AND wire_n111i12_w_lg_q92w(0);
	wire_w_lg_w_lg_rx_detect_valid_sync75w78w(0) <= wire_w_lg_rx_detect_valid_sync75w(0) AND wire_n11ii6_w_lg_q77w(0);
	wire_w_lg_w_lg_rx_found_sync86w89w(0) <= wire_w_lg_rx_found_sync86w(0) AND wire_n111O10_w_lg_q88w(0);
	wire_w_lg_w_lg_nlO0iO267w268w(0) <= wire_w_lg_nlO0iO267w(0) AND nlO0il;
	wire_w_lg_w_lg_nlOl0l211w212w(0) <= wire_w_lg_nlOl0l211w(0) AND nlOl0i;
	wire_w_lg_latched_p174w(0) <= latched_p1 AND rx_found_sync;
	wire_w_lg_nlOl0i226w(0) <= nlOl0i AND wire_w_lg_nlOili225w(0);
	wire_w_lg_nlOl0i220w(0) <= nlOl0i AND nlOili;
	wire_w_lg_nlOOii110w(0) <= nlOOii AND wire_w_lg_rind_error_reporting109w(0);
	wire_w_lg_rclkcmpinsertpad227w(0) <= rclkcmpinsertpad AND wire_w_lg_nlOl0i226w(0);
	wire_w_lg_rclkcmpinsertpad221w(0) <= rclkcmpinsertpad AND wire_w_lg_nlOl0i220w(0);
	wire_w_lg_rrdwidth_rx82w(0) <= rrdwidth_rx AND latched_p1;
	wire_w_lg_rx_detect_valid_sync90w(0) <= rx_detect_valid_sync AND wire_w_lg_w_lg_rx_found_sync86w89w(0);
	wire_w_lg_rx_detect_valid_sync75w(0) <= rx_detect_valid_sync AND wire_w_lg_latched_p174w(0);
	wire_w_lg_rx_detect_valid_sync193w(0) <= rx_detect_valid_sync AND wire_n0ilO_w_lg_n0iOi81w(0);
	wire_w_lg_rx_detect_valid_sync259w(0) <= rx_detect_valid_sync AND wire_n0ilO_w_lg_n1O0i73w(0);
	wire_w_lg_rx_found_sync86w(0) <= rx_found_sync AND wire_w_lg_w_lg_rrdwidth_rx82w85w(0);
	wire_w_lg_w_rxd_range52w279w(0) <= wire_w_rxd_range52w(0) AND wire_w_lg_w_rxd_range51w277w(0);
	wire_w_lg_w_rxd_range20w235w(0) <= wire_w_rxd_range20w(0) AND wire_w_lg_w_rxd_range19w233w(0);
	wire_w_lg_nlO00l272w(0) <= NOT nlO00l;
	wire_w_lg_nlO0iO267w(0) <= NOT nlO0iO;
	wire_w_lg_nlO0li263w(0) <= NOT nlO0li;
	wire_w_lg_nlOili225w(0) <= NOT nlOili;
	wire_w_lg_nlOl0l211w(0) <= NOT nlOl0l;
	wire_w_lg_nlOliO197w(0) <= NOT nlOliO;
	wire_w_lg_rclkcmpinsertpad205w(0) <= NOT rclkcmpinsertpad;
	wire_w_lg_reset_n72w(0) <= NOT reset_n;
	wire_w_lg_rind_error_reporting109w(0) <= NOT rind_error_reporting;
	wire_w_lg_rrdwidth_rx199w(0) <= NOT rrdwidth_rx;
	wire_w_lg_sigdetni66w(0) <= NOT sigdetni;
	wire_w_lg_w_rxd_range51w277w(0) <= NOT wire_w_rxd_range51w(0);
	wire_w_lg_w_rxd_range19w233w(0) <= NOT wire_w_rxd_range19w(0);
	n11lO <= '1';
	nlO00i <= (rclkcmpinsertpad AND (nlO0il AND nlO00l));
	nlO00l <= (((((((rxd(0) AND rxd(1)) AND rxd(2)) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	nlO00O <= (wire_w_lg_rclkcmpinsertpad205w(0) AND wire_w_lg_w_lg_nlO0iO267w268w(0));
	nlO01i <= ((NOT rxd(13)) AND wire_w_lg_w_rxd_range51w277w(0));
	nlO01l <= wire_w_lg_w_rxd_range52w279w(0);
	nlO01O <= (rclkcmpinsertpad AND (nlO0il AND wire_w_lg_nlO00l272w(0)));
	nlO0ii <= (wire_w_lg_rclkcmpinsertpad205w(0) AND (nlO0iO AND nlO0il));
	nlO0il <= ((NOT rxd(13)) AND rxd(14));
	nlO0iO <= ((((((((NOT rxd(0)) AND rxd(1)) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	nlO0li <= (wire_w_lg_rx_detect_valid_sync259w(0) AND (nlO0ll42 XOR nlO0ll41));
	nlOi0i <= (wire_w_lg_rclkcmpinsertpad227w(0) AND (nlOi0l36 XOR nlOi0l35));
	nlOi1l <= ((NOT rxd(45)) AND wire_w_lg_w_rxd_range19w233w(0));
	nlOi1O <= (wire_w_lg_w_rxd_range20w235w(0) AND (nlO0OO38 XOR nlO0OO37));
	nlOiii <= (wire_w_lg_rclkcmpinsertpad221w(0) AND (nlOiil34 XOR nlOiil33));
	nlOili <= ((((((((rxd(32) AND rxd(33)) AND rxd(34)) AND (NOT rxd(35))) AND rxd(36)) AND rxd(37)) AND rxd(38)) AND rxd(39)) AND (nlO0Oi40 XOR nlO0Oi39));
	nlOill <= ((wire_w_lg_rclkcmpinsertpad205w(0) AND (wire_w_lg_w_lg_nlOl0l211w212w(0) AND (nlOiOl30 XOR nlOiOl29))) AND (nlOilO32 XOR nlOilO31));
	nlOl0i <= ((NOT rxd(45)) AND rxd(46));
	nlOl0l <= ((((((((NOT rxd(32)) AND rxd(33)) AND rxd(34)) AND rxd(35)) AND rxd(36)) AND rxd(37)) AND rxd(38)) AND rxd(39));
	nlOl0O <= ((wire_w_lg_reset_n72w(0) OR wire_w_lg_rrdwidth_rx199w(0)) OR (NOT (nlOlii26 XOR nlOlii25)));
	nlOl1i <= ((wire_w_lg_rclkcmpinsertpad205w(0) AND (nlOl0l AND nlOl0i)) AND (nlOl1l28 XOR nlOl1l27));
	nlOliO <= (wire_w_lg_rx_detect_valid_sync193w(0) AND (nlOlli24 XOR nlOlli23));
	nlOllO <= ((reset_n AND rrdwidth_rx) AND (nlOlOi22 XOR nlOlOi21));
	nlOlOO <= ((wire_n10ii_dataout OR wire_n1OlO_dataout) OR (NOT (nlOO1i20 XOR nlOO1i19)));
	nlOO0O <= (nlOOii AND rind_error_reporting);
	nlOO1O <= (wire_w_lg_nlOOii110w(0) AND (nlOO0i18 XOR nlOO0i17));
	nlOOii <= (wire_n1liO_dataout OR wire_n00OO_dataout);
	nlOOil <= ((wire_n10il_dataout OR wire_n1OOi_dataout) OR (NOT (nlOOiO16 XOR nlOOiO15)));
	nlOOll <= (wire_n10iO_dataout OR wire_n1OOl_dataout);
	nlOOlO <= (wire_n1lll_dataout OR wire_n0i1l_dataout);
	nlOOOi <= (wire_n0ilO_w_lg_w_lg_w_lg_n1O0i73w79w80w(0) OR (wire_n0ilO_w_lg_w_lg_w_lg_n0iOi81w94w95w(0) AND (nlOOOl14 XOR nlOOOl13)));
	polinv_rx_int <= wire_n1iO_dataout;
	rxd_ch <= ( wire_ni_dataout & wire_nlO_dataout & wire_nll_dataout & wire_nli_dataout & wire_niO_dataout & wire_nil_dataout & wire_nii_dataout & wire_n0O_dataout & wire_n0l_dataout & wire_n0i_dataout & wire_n1O_dataout & wire_n1l_dataout & wire_n1i_dataout & wire_nlOO_dataout & wire_nlOl_dataout & wire_nlOi_dataout & wire_nllO_dataout & wire_nlll_dataout & wire_nlli_dataout & wire_nliO_dataout & wire_nlil_dataout & wire_nlii_dataout & wire_nl0O_dataout & wire_nl0l_dataout & wire_nl0i_dataout & wire_nl1O_dataout & wire_nl1l_dataout & wire_nl1i_dataout & wire_niOO_dataout & wire_niOl_dataout & wire_niOi_dataout & wire_nilO_dataout & wire_nill_dataout & wire_nili_dataout & wire_niiO_dataout & wire_niil_dataout & wire_niii_dataout & wire_ni0O_dataout & wire_ni0l_dataout & wire_ni0i_dataout & wire_ni1O_dataout & wire_ni1l_dataout & wire_ni1i_dataout & wire_n0OO_dataout & wire_n0Ol_dataout & wire_n0Oi_dataout & wire_n0lO_dataout & wire_n0ll_dataout & wire_n0li_dataout & wire_n0iO_dataout & wire_n0il_dataout & wire_n0ii_dataout & wire_n00O_dataout & wire_n00l_dataout & wire_n00i_dataout & wire_n01O_dataout & wire_n01l_dataout & wire_n01i_dataout & wire_n1OO_dataout & wire_n1Ol_dataout & wire_n1Oi_dataout & wire_n1lO_dataout & wire_n1ll_dataout & wire_n1li_dataout);
	rxelecidle <= wire_n1ii_dataout;
	rxstatus <= ( wire_n10O_dataout & wire_n10l_dataout & wire_n10i_dataout);
	rxvalid <= wire_n1il_dataout;
	wire_w_rxd_range52w(0) <= rxd(13);
	wire_w_rxd_range51w(0) <= rxd(14);
	wire_w_rxd_range20w(0) <= rxd(45);
	wire_w_rxd_range19w(0) <= rxd(46);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n110l7 <= n110l8;
		END IF;
		if (now = 0 ns) then
			n110l7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n110l8 <= n110l7;
		END IF;
	END PROCESS;
	wire_n110l8_w_lg_q84w(0) <= n110l8 XOR n110l7;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111i11 <= n111i12;
		END IF;
		if (now = 0 ns) then
			n111i11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111i12 <= n111i11;
		END IF;
	END PROCESS;
	wire_n111i12_w_lg_q92w(0) <= n111i12 XOR n111i11;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111O10 <= n111O9;
		END IF;
	END PROCESS;
	wire_n111O10_w_lg_q88w(0) <= n111O10 XOR n111O9;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n111O9 <= n111O10;
		END IF;
		if (now = 0 ns) then
			n111O9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11ii5 <= n11ii6;
		END IF;
		if (now = 0 ns) then
			n11ii5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11ii6 <= n11ii5;
		END IF;
	END PROCESS;
	wire_n11ii6_w_lg_q77w(0) <= n11ii6 XOR n11ii5;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11iO3 <= n11iO4;
		END IF;
		if (now = 0 ns) then
			n11iO3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11iO4 <= n11iO3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11Ol1 <= n11Ol2;
		END IF;
		if (now = 0 ns) then
			n11Ol1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n11Ol2 <= n11Ol1;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0ll41 <= nlO0ll42;
		END IF;
		if (now = 0 ns) then
			nlO0ll41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0ll42 <= nlO0ll41;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0Oi39 <= nlO0Oi40;
		END IF;
		if (now = 0 ns) then
			nlO0Oi39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0Oi40 <= nlO0Oi39;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0OO37 <= nlO0OO38;
		END IF;
		if (now = 0 ns) then
			nlO0OO37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0OO38 <= nlO0OO37;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOi0l35 <= nlOi0l36;
		END IF;
		if (now = 0 ns) then
			nlOi0l35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOi0l36 <= nlOi0l35;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiil33 <= nlOiil34;
		END IF;
		if (now = 0 ns) then
			nlOiil33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiil34 <= nlOiil33;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOilO31 <= nlOilO32;
		END IF;
		if (now = 0 ns) then
			nlOilO31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOilO32 <= nlOilO31;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiOl29 <= nlOiOl30;
		END IF;
		if (now = 0 ns) then
			nlOiOl29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiOl30 <= nlOiOl29;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOl1l27 <= nlOl1l28;
		END IF;
		if (now = 0 ns) then
			nlOl1l27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOl1l28 <= nlOl1l27;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlii25 <= nlOlii26;
		END IF;
		if (now = 0 ns) then
			nlOlii25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlii26 <= nlOlii25;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlli23 <= nlOlli24;
		END IF;
		if (now = 0 ns) then
			nlOlli23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlli24 <= nlOlli23;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlOi21 <= nlOlOi22;
		END IF;
		if (now = 0 ns) then
			nlOlOi21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOlOi22 <= nlOlOi21;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO0i17 <= nlOO0i18;
		END IF;
		if (now = 0 ns) then
			nlOO0i17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO0i18 <= nlOO0i17;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO1i19 <= nlOO1i20;
		END IF;
		if (now = 0 ns) then
			nlOO1i19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOO1i20 <= nlOO1i19;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOiO15 <= nlOOiO16;
		END IF;
		if (now = 0 ns) then
			nlOOiO15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOiO16 <= nlOOiO15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOOl13 <= nlOOOl14;
		END IF;
		if (now = 0 ns) then
			nlOOOl13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOOOl14 <= nlOOOl13;
		END IF;
	END PROCESS;
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				n00ii <= '0';
				n0ill <= '0';
				n0iOi <= '0';
				n1l1l <= '0';
				n1O0i <= '0';
				n1O1O <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n00ii <= n0ill;
				n0ill <= txdetectrx;
				n0iOi <= rx_detect_valid_sync;
				n1l1l <= n1O1O;
				n1O0i <= rx_detect_valid_sync;
				n1O1O <= txdetectrx;
		END IF;
	END PROCESS;
	wire_n0ilO_w_lg_w_lg_w_lg_n0iOi81w94w95w(0) <= wire_n0ilO_w_lg_w_lg_n0iOi81w94w(0) AND n00ii;
	wire_n0ilO_w_lg_w_lg_w_lg_n1O0i73w79w80w(0) <= wire_n0ilO_w_lg_w_lg_n1O0i73w79w(0) AND n1l1l;
	wire_n0ilO_w_lg_w_lg_n0iOi81w94w(0) <= wire_n0ilO_w_lg_n0iOi81w(0) AND wire_w_lg_w_lg_rx_detect_valid_sync90w93w(0);
	wire_n0ilO_w_lg_w_lg_n1O0i73w79w(0) <= wire_n0ilO_w_lg_n1O0i73w(0) AND wire_w_lg_w_lg_rx_detect_valid_sync75w78w(0);
	wire_n0ilO_w_lg_n0iOi81w(0) <= NOT n0iOi;
	wire_n0ilO_w_lg_n1O0i73w(0) <= NOT n1O0i;
	PROCESS (clk, reset_n, wire_nl_CLRN)
	BEGIN
		IF (reset_n = '0') THEN
				nlOOO <= '1';
				nO <= '1';
		ELSIF (wire_nl_CLRN = '0') THEN
				nlOOO <= '0';
				nO <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				nlOOO <= rxelectricalidle;
				nO <= nlOOO;
		END IF;
		if (now = 0 ns) then
			nlOOO <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nO <= '1' after 1 ps;
		end if;
	END PROCESS;
	wire_nl_CLRN <= (n11Ol2 XOR n11Ol1);
	wire_n000i_dataout <= (rxd(45) AND rxd(46)) AND NOT(nlOi0i);
	wire_n001i_dataout <= wire_n001O_dataout AND NOT(nlOill);
	wire_n001l_dataout <= nlOi0i AND NOT(nlOiii);
	wire_n001O_dataout <= wire_n000i_dataout AND NOT(nlOiii);
	wire_n00i_dataout <= rxd(9) AND rrx_pipe_enable;
	wire_n00l_dataout <= rxd(10) AND rrx_pipe_enable;
	wire_n00O_dataout <= rxd(11) AND rrx_pipe_enable;
	wire_n00OO_dataout <= rxd(43) AND (nlOllO AND wire_w_lg_nlOliO197w(0));
	wire_n010i_dataout <= wire_n01il_dataout AND NOT(nlOi1l);
	wire_n010l_dataout <= nlOi1O AND NOT(nlOi1l);
	wire_n010O_dataout <= wire_n01iO_dataout AND NOT(nlOi1l);
	wire_n011i_dataout <= wire_n010l_dataout AND NOT(nlOliO);
	wire_n011l_dataout <= wire_n010O_dataout AND NOT(nlOliO);
	wire_n011O_dataout <= wire_n01ii_dataout AND NOT(nlOliO);
	wire_n01i_dataout <= rxd(6) AND rrx_pipe_enable;
	wire_n01ii_dataout <= wire_n01li_dataout AND NOT(nlOi1l);
	wire_n01il_dataout <= wire_n01ll_dataout AND NOT(nlOi1O);
	wire_n01iO_dataout <= wire_n01lO_dataout AND NOT(nlOi1O);
	wire_n01l_dataout <= rxd(7) AND rrx_pipe_enable;
	wire_n01li_dataout <= wire_n01Oi_dataout AND NOT(nlOi1O);
	wire_n01ll_dataout <= wire_n01Ol_dataout AND NOT(nlOl1i);
	wire_n01lO_dataout <= wire_n01OO_dataout OR nlOl1i;
	wire_n01O_dataout <= rxd(8) AND rrx_pipe_enable;
	wire_n01Oi_dataout <= wire_n001i_dataout AND NOT(nlOl1i);
	wire_n01Ol_dataout <= wire_n001l_dataout OR nlOill;
	wire_n01OO_dataout <= nlOiii AND NOT(nlOill);
	wire_n0i_dataout <= rxd(54) AND rrx_pipe_enable;
	wire_n0i1l_dataout <= rxd(41) AND (nlOllO AND wire_w_lg_nlOliO197w(0));
	wire_n0ii_dataout <= rxd(12) AND rrx_pipe_enable;
	wire_n0il_dataout <= rxd(13) AND rrx_pipe_enable;
	wire_n0iO_dataout <= rxd(14) AND rrx_pipe_enable;
	wire_n0l_dataout <= rxd(55) AND rrx_pipe_enable;
	wire_n0li_dataout <= rxd(15) AND rrx_pipe_enable;
	wire_n0ll_dataout <= rxd(16) AND rrx_pipe_enable;
	wire_n0lO_dataout <= rxd(17) AND rrx_pipe_enable;
	wire_n0O_dataout <= rxd(56) AND rrx_pipe_enable;
	wire_n0Oi_dataout <= rxd(18) AND rrx_pipe_enable;
	wire_n0Ol_dataout <= rxd(19) AND rrx_pipe_enable;
	wire_n0OO_dataout <= rxd(20) AND rrx_pipe_enable;
	wire_n100O_dataout <= wire_n10li_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10i_dataout <= wire_nliOl_dataout WHEN rrx_pipe_enable = '1'  ELSE rx_found;
	wire_n10ii_dataout <= wire_n10ll_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10il_dataout <= wire_n10lO_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10iO_dataout <= wire_n10Oi_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n10l_dataout <= wire_nliOO_dataout WHEN rrx_pipe_enable = '1'  ELSE rx_detect_valid;
	wire_n10li_dataout <= wire_n10Ol_dataout AND NOT(nlO0li);
	wire_n10ll_dataout <= wire_n10OO_dataout AND NOT(nlO0li);
	wire_n10lO_dataout <= wire_n1i1i_dataout AND NOT(nlO0li);
	wire_n10O_dataout <= wire_nll1i_dataout AND rrx_pipe_enable;
	wire_n10Oi_dataout <= wire_n1i1l_dataout AND NOT(nlO0li);
	wire_n10Ol_dataout <= wire_n1i1O_dataout AND NOT(nlO01i);
	wire_n10OO_dataout <= nlO01l AND NOT(nlO01i);
	wire_n11i_dataout <= wire_n11l_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_n11l_dataout <= ((rxd(10) OR rxd(42)) OR (NOT (n11iO4 XOR n11iO3))) WHEN rrdwidth_rx = '1'  ELSE rxd(10);
	wire_n1i_dataout <= rxd(51) AND rrx_pipe_enable;
	wire_n1i0i_dataout <= wire_n1iii_dataout AND NOT(nlO01l);
	wire_n1i0l_dataout <= wire_n1iil_dataout AND NOT(nlO01l);
	wire_n1i0O_dataout <= wire_n1iiO_dataout AND NOT(nlO0ii);
	wire_n1i1i_dataout <= wire_n1i0i_dataout AND NOT(nlO01i);
	wire_n1i1l_dataout <= wire_n1i0l_dataout AND NOT(nlO01i);
	wire_n1i1O_dataout <= wire_n1i0O_dataout AND NOT(nlO01l);
	wire_n1ii_dataout <= wire_nlOOl_dataout WHEN rrx_pipe_enable = '1'  ELSE wire_w_lg_sigdetni66w(0);
	wire_n1iii_dataout <= wire_n1ili_dataout OR nlO0ii;
	wire_n1iil_dataout <= wire_n1ill_dataout AND NOT(nlO0ii);
	wire_n1iiO_dataout <= wire_n1ilO_dataout OR nlO00O;
	wire_n1il_dataout <= wire_n11i_dataout AND rrx_pipe_enable;
	wire_n1ili_dataout <= nlO00i AND NOT(nlO00O);
	wire_n1ill_dataout <= wire_n1iOi_dataout AND NOT(nlO00O);
	wire_n1ilO_dataout <= nlO01O AND NOT(nlO00i);
	wire_n1iO_dataout <= rxpolarity WHEN rrx_pipe_enable = '1'  ELSE polinv_rx;
	wire_n1iOi_dataout <= wire_n1iOl_dataout AND NOT(nlO00i);
	wire_n1iOl_dataout <= (rxd(13) AND rxd(14)) AND NOT(nlO01O);
	wire_n1l_dataout <= rxd(52) AND rrx_pipe_enable;
	wire_n1li_dataout <= rxd(0) AND rrx_pipe_enable;
	wire_n1liO_dataout <= rxd(11) AND (reset_n AND wire_w_lg_nlO0li263w(0));
	wire_n1ll_dataout <= rxd(1) AND rrx_pipe_enable;
	wire_n1lll_dataout <= rxd(9) AND (reset_n AND wire_w_lg_nlO0li263w(0));
	wire_n1lO_dataout <= rxd(2) AND rrx_pipe_enable;
	wire_n1O_dataout <= rxd(53) AND rrx_pipe_enable;
	wire_n1Oi_dataout <= rxd(3) AND rrx_pipe_enable;
	wire_n1Ol_dataout <= rxd(4) AND rrx_pipe_enable;
	wire_n1Oll_dataout <= wire_n1OOO_dataout AND NOT(nlOl0O);
	wire_n1OlO_dataout <= wire_n011i_dataout AND NOT(nlOl0O);
	wire_n1OO_dataout <= rxd(5) AND rrx_pipe_enable;
	wire_n1OOi_dataout <= wire_n011l_dataout AND NOT(nlOl0O);
	wire_n1OOl_dataout <= wire_n011O_dataout AND NOT(nlOl0O);
	wire_n1OOO_dataout <= wire_n010i_dataout AND NOT(nlOliO);
	wire_ni_dataout <= rxd(63) AND rrx_pipe_enable;
	wire_ni0i_dataout <= rxd(24) AND rrx_pipe_enable;
	wire_ni0l_dataout <= rxd(25) AND rrx_pipe_enable;
	wire_ni0O_dataout <= rxd(26) AND rrx_pipe_enable;
	wire_ni1i_dataout <= rxd(21) AND rrx_pipe_enable;
	wire_ni1l_dataout <= rxd(22) AND rrx_pipe_enable;
	wire_ni1O_dataout <= rxd(23) AND rrx_pipe_enable;
	wire_nii_dataout <= rxd(57) AND rrx_pipe_enable;
	wire_niii_dataout <= rxd(27) AND rrx_pipe_enable;
	wire_niil_dataout <= rxd(28) AND rrx_pipe_enable;
	wire_niiO_dataout <= rxd(29) AND rrx_pipe_enable;
	wire_nil_dataout <= rxd(58) AND rrx_pipe_enable;
	wire_nili_dataout <= rxd(30) AND rrx_pipe_enable;
	wire_nill_dataout <= rxd(31) AND rrx_pipe_enable;
	wire_nilO_dataout <= rxd(32) AND rrx_pipe_enable;
	wire_niO_dataout <= rxd(59) AND rrx_pipe_enable;
	wire_niOi_dataout <= rxd(33) AND rrx_pipe_enable;
	wire_niOl_dataout <= rxd(34) AND rrx_pipe_enable;
	wire_niOO_dataout <= rxd(35) AND rrx_pipe_enable;
	wire_nl0i_dataout <= rxd(39) AND rrx_pipe_enable;
	wire_nl0l_dataout <= rxd(40) AND rrx_pipe_enable;
	wire_nl0O_dataout <= rxd(41) AND rrx_pipe_enable;
	wire_nl1i_dataout <= rxd(36) AND rrx_pipe_enable;
	wire_nl1l_dataout <= rxd(37) AND rrx_pipe_enable;
	wire_nl1O_dataout <= rxd(38) AND rrx_pipe_enable;
	wire_nli_dataout <= rxd(60) AND rrx_pipe_enable;
	wire_nlii_dataout <= rxd(42) AND rrx_pipe_enable;
	wire_nlil_dataout <= rxd(43) AND rrx_pipe_enable;
	wire_nliO_dataout <= rxd(44) AND rrx_pipe_enable;
	wire_nliOl_dataout <= wire_nll1l_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_nliOO_dataout <= wire_nll1O_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_nll_dataout <= rxd(61) AND rrx_pipe_enable;
	wire_nll0i_dataout <= wire_nllii_dataout AND NOT(nlOOOi);
	wire_nll0l_dataout <= wire_nllil_dataout AND NOT(nlOOlO);
	wire_nll0O_dataout <= wire_nlliO_dataout AND NOT(nlOOlO);
	wire_nll1i_dataout <= wire_nll0i_dataout AND NOT(wire_w_lg_reset_n72w(0));
	wire_nll1l_dataout <= wire_nll0l_dataout OR nlOOOi;
	wire_nll1O_dataout <= wire_nll0O_dataout OR nlOOOi;
	wire_nlli_dataout <= rxd(45) AND rrx_pipe_enable;
	wire_nllii_dataout <= wire_nllli_dataout OR nlOOlO;
	wire_nllil_dataout <= wire_nllll_dataout OR nlOOll;
	wire_nlliO_dataout <= wire_nlllO_dataout AND NOT(nlOOll);
	wire_nlll_dataout <= rxd(46) AND rrx_pipe_enable;
	wire_nllli_dataout <= wire_nllOi_dataout OR nlOOll;
	wire_nllll_dataout <= wire_nllOl_dataout AND NOT(nlOOil);
	wire_nlllO_dataout <= wire_nllOO_dataout OR nlOOil;
	wire_nllO_dataout <= rxd(47) AND rrx_pipe_enable;
	wire_nllOi_dataout <= wire_nlO1i_dataout OR nlOOil;
	wire_nllOl_dataout <= wire_nlO1l_dataout OR nlOO0O;
	wire_nllOO_dataout <= wire_nlO1O_dataout OR nlOO0O;
	wire_nlO_dataout <= rxd(62) AND rrx_pipe_enable;
	wire_nlO0i_dataout <= (wire_n100O_dataout OR wire_n1Oll_dataout) AND NOT(nlOlOO);
	wire_nlO1i_dataout <= nlOO1O OR nlOO0O;
	wire_nlO1l_dataout <= wire_nlO0i_dataout AND NOT(nlOO1O);
	wire_nlO1O_dataout <= nlOlOO AND NOT(nlOO1O);
	wire_nlOi_dataout <= rxd(48) AND rrx_pipe_enable;
	wire_nlOl_dataout <= rxd(49) AND rrx_pipe_enable;
	wire_nlOO_dataout <= rxd(50) AND rrx_pipe_enable;
	wire_nlOOl_dataout <= nO OR wire_w_lg_reset_n72w(0);

 END RTL; --stratixiv_hssi_rx_pipe_interface
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 10.1 cbx_mgl 2010:11:29:21:24:23:SJ cbx_simgen 2010:11:29:21:22:45:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 36 mux21 13 oper_mux 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_hssi_tx_pipe_interface IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerstate	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 refclk_b	:	IN  STD_LOGIC;
		 refclk_b_reset_n	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rev_loopbk	:	OUT  STD_LOGIC;
		 revloopback	:	IN  STD_LOGIC;
		 rtx_elec_idle_delay	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rtx_pipe_enable	:	IN  STD_LOGIC;
		 rtxswing_sel_ena	:	IN  STD_LOGIC;
		 tx_elec_idle	:	OUT  STD_LOGIC;
		 tx_elec_idle_comp	:	IN  STD_LOGIC;
		 txd	:	OUT  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txd_ch	:	IN  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txdeemph	:	IN  STD_LOGIC;
		 txdeemph_int	:	OUT  STD_LOGIC;
		 txdetectrx	:	OUT  STD_LOGIC;
		 txdetectrxloopback	:	IN  STD_LOGIC;
		 txelecidle	:	IN  STD_LOGIC;
		 txmargin	:	IN  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 txmargin_int	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 txswing	:	IN  STD_LOGIC;
		 txswing_int	:	OUT  STD_LOGIC
	 ); 
 END stratixiv_hssi_tx_pipe_interface;

 ARCHITECTURE RTL OF stratixiv_hssi_tx_pipe_interface IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 niiOl23	:	STD_LOGIC := '0';
	 SIGNAL	 niiOl24	:	STD_LOGIC := '0';
	 SIGNAL	 nil0i19	:	STD_LOGIC := '0';
	 SIGNAL	 nil0i20	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil0i20_w_lg_w_lg_q190w191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil0i20_w_lg_q190w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nil0l17	:	STD_LOGIC := '0';
	 SIGNAL	 nil0l18	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil0l18_w_lg_w_lg_q184w185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil0l18_w_lg_q184w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nil0O15	:	STD_LOGIC := '0';
	 SIGNAL	 nil0O16	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil0O16_w_lg_w_lg_q171w172w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nil0O16_w_lg_q171w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nil1i21	:	STD_LOGIC := '0';
	 SIGNAL	 nil1i22	:	STD_LOGIC := '0';
	 SIGNAL	 nilii13	:	STD_LOGIC := '0';
	 SIGNAL	 nilii14	:	STD_LOGIC := '0';
	 SIGNAL	 niliO11	:	STD_LOGIC := '0';
	 SIGNAL	 niliO12	:	STD_LOGIC := '0';
	 SIGNAL	 nilli10	:	STD_LOGIC := '0';
	 SIGNAL	 nilli9	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi7	:	STD_LOGIC := '0';
	 SIGNAL	 nilOi8	:	STD_LOGIC := '0';
	 SIGNAL	 nilOl5	:	STD_LOGIC := '0';
	 SIGNAL	 nilOl6	:	STD_LOGIC := '0';
	 SIGNAL	 niO1i3	:	STD_LOGIC := '0';
	 SIGNAL	 niO1i4	:	STD_LOGIC := '0';
	 SIGNAL	 niO1O1	:	STD_LOGIC := '0';
	 SIGNAL	 niO1O2	:	STD_LOGIC := '0';
	 SIGNAL	nl00i	:	STD_LOGIC := '0';
	 SIGNAL	nl10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1li	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl01O_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nl01O_PRN	:	STD_LOGIC;
	 SIGNAL	nl1lO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl1ll_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_PRN	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_ENA	:	STD_LOGIC;
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1OO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl1Ol_w_lg_nl1Oi168w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl11l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl11l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl11l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_powerdown_range196w204w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nilOO193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset_n194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rtx_pipe_enable151w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_powerdown_range198w199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nil1O :	STD_LOGIC;
	 SIGNAL  nilll :	STD_LOGIC;
	 SIGNAL  nillO :	STD_LOGIC;
	 SIGNAL  nilOO :	STD_LOGIC;
	 SIGNAL  wire_w_powerdown_range196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_powerdown_range198w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rtx_elec_idle_delay_range170w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_powerdown_range196w204w(0) <= wire_w_powerdown_range196w(0) AND wire_w_lg_w_powerdown_range198w199w(0);
	wire_w_lg_nilOO193w(0) <= NOT nilOO;
	wire_w_lg_reset_n194w(0) <= NOT reset_n;
	wire_w_lg_rtx_pipe_enable151w(0) <= NOT rtx_pipe_enable;
	wire_w_lg_w_powerdown_range198w199w(0) <= NOT wire_w_powerdown_range198w(0);
	nil1O <= (wire_w_lg_reset_n194w(0) OR wire_w_lg_rtx_pipe_enable151w(0));
	nilll <= '0';
	nillO <= '1';
	nilOO <= ((tx_elec_idle_comp OR nl1lO) OR (NOT (niO1i4 XOR niO1i3)));
	powerstate <= ( wire_nl0OO_dataout & wire_nl0Ol_dataout & wire_nl0Oi_dataout & wire_nl0lO_dataout);
	rev_loopbk <= wire_nl0iO_dataout;
	tx_elec_idle <= wire_nl0il_dataout;
	txd <= ( txd_ch(43 DOWNTO 0));
	txdeemph_int <= txdeemph;
	txdetectrx <= wire_nl00O_dataout;
	txmargin_int <= ( txmargin(2 DOWNTO 0));
	txswing_int <= wire_nl0ll_dataout;
	wire_w_powerdown_range196w(0) <= powerdown(0);
	wire_w_powerdown_range198w(0) <= powerdown(1);
	wire_w_rtx_elec_idle_delay_range170w(0) <= rtx_elec_idle_delay(0);
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niiOl23 <= niiOl24;
		END IF;
		if (now = 0 ns) then
			niiOl23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niiOl24 <= niiOl23;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0i19 <= nil0i20;
		END IF;
		if (now = 0 ns) then
			nil0i19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0i20 <= nil0i19;
		END IF;
	END PROCESS;
	wire_nil0i20_w_lg_w_lg_q190w191w(0) <= wire_nil0i20_w_lg_q190w(0) AND nl00i;
	wire_nil0i20_w_lg_q190w(0) <= nil0i20 XOR nil0i19;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0l17 <= nil0l18;
		END IF;
		if (now = 0 ns) then
			nil0l17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0l18 <= nil0l17;
		END IF;
	END PROCESS;
	wire_nil0l18_w_lg_w_lg_q184w185w(0) <= wire_nil0l18_w_lg_q184w(0) AND nl10O;
	wire_nil0l18_w_lg_q184w(0) <= nil0l18 XOR nil0l17;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0O15 <= nil0O16;
		END IF;
		if (now = 0 ns) then
			nil0O15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil0O16 <= nil0O15;
		END IF;
	END PROCESS;
	wire_nil0O16_w_lg_w_lg_q171w172w(0) <= wire_nil0O16_w_lg_q171w(0) AND wire_w_rtx_elec_idle_delay_range170w(0);
	wire_nil0O16_w_lg_q171w(0) <= nil0O16 XOR nil0O15;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil1i21 <= nil1i22;
		END IF;
		if (now = 0 ns) then
			nil1i21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nil1i22 <= nil1i21;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilii13 <= nilii14;
		END IF;
		if (now = 0 ns) then
			nilii13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilii14 <= nilii13;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niliO11 <= niliO12;
		END IF;
		if (now = 0 ns) then
			niliO11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niliO12 <= niliO11;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilli10 <= nilli9;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilli9 <= nilli10;
		END IF;
		if (now = 0 ns) then
			nilli9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOi7 <= nilOi8;
		END IF;
		if (now = 0 ns) then
			nilOi7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOi8 <= nilOi7;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOl5 <= nilOl6;
		END IF;
		if (now = 0 ns) then
			nilOl5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN nilOl6 <= nilOl5;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1i3 <= niO1i4;
		END IF;
		if (now = 0 ns) then
			niO1i3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1i4 <= niO1i3;
		END IF;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1O1 <= niO1O2;
		END IF;
		if (now = 0 ns) then
			niO1O1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (refclk_b)
	BEGIN
		IF (refclk_b = '1' AND refclk_b'event) THEN niO1O2 <= niO1O1;
		END IF;
	END PROCESS;
	PROCESS (refclk_b, wire_nl01O_PRN, wire_nl01O_CLRN)
	BEGIN
		IF (wire_nl01O_PRN = '0') THEN
				nl00i <= '1';
				nl10i <= '1';
				nl10l <= '1';
				nl10O <= '1';
				nl11O <= '1';
				nl1ii <= '1';
				nl1il <= '1';
				nl1iO <= '1';
				nl1li <= '1';
		ELSIF (wire_nl01O_CLRN = '0') THEN
				nl00i <= '0';
				nl10i <= '0';
				nl10l <= '0';
				nl10O <= '0';
				nl11O <= '0';
				nl1ii <= '0';
				nl1il <= '0';
				nl1iO <= '0';
				nl1li <= '0';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
				nl00i <= nl11O;
				nl10i <= nl10l;
				nl10l <= nl10O;
				nl10O <= nl1ii;
				nl11O <= nl10i;
				nl1ii <= nl1il;
				nl1il <= nl1iO;
				nl1iO <= nl1li;
				nl1li <= nilOO;
		END IF;
		if (now = 0 ns) then
			nl00i <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl10i <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl10l <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl10O <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl11O <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl1ii <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl1il <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl1iO <= '1' after 1 ps;
		end if;
		if (now = 0 ns) then
			nl1li <= '1' after 1 ps;
		end if;
	END PROCESS;
	wire_nl01O_CLRN <= (nilOl6 XOR nilOl5);
	wire_nl01O_PRN <= ((nilOi8 XOR nilOi7) AND refclk_b_reset_n);
	PROCESS (refclk_b, wire_nl1ll_PRN, wire_nl1ll_CLRN)
	BEGIN
		IF (wire_nl1ll_PRN = '0') THEN
				nl1lO <= '1';
		ELSIF (wire_nl1ll_CLRN = '0') THEN
				nl1lO <= '0';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
			IF (wire_nl1ll_ENA = '1') THEN
				nl1lO <= nilll;
			END IF;
		END IF;
		if (now = 0 ns) then
			nl1lO <= '1' after 1 ps;
		end if;
	END PROCESS;
	wire_nl1ll_CLRN <= (nilli10 XOR nilli9);
	wire_nl1ll_ENA <= (((nl1OO AND nl1lO) AND (nilii14 XOR nilii13)) AND wire_nl1Ol_w_lg_nl1Oi168w(0));
	wire_nl1ll_PRN <= ((niliO12 XOR niliO11) AND refclk_b_reset_n);
	PROCESS (refclk_b, refclk_b_reset_n)
	BEGIN
		IF (refclk_b_reset_n = '0') THEN
				nl1Oi <= '0';
				nl1OO <= '0';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
				nl1Oi <= nl1OO;
				nl1OO <= tx_elec_idle_comp;
		END IF;
	END PROCESS;
	wire_nl1Ol_w_lg_nl1Oi168w(0) <= NOT nl1Oi;
	wire_niOll_dataout <= (powerdown(0) AND powerdown(1)) AND NOT(nil1O);
	wire_niOlO_dataout <= ((NOT powerdown(0)) AND powerdown(1)) AND NOT(nil1O);
	wire_niOOi_dataout <= (wire_w_lg_w_powerdown_range196w204w(0) AND (niiOl24 XOR niiOl23)) AND NOT(nil1O);
	wire_niOOl_dataout <= (((NOT powerdown(0)) AND wire_w_lg_w_powerdown_range198w199w(0)) AND (nil1i22 XOR nil1i21)) AND NOT(nil1O);
	wire_nl00O_dataout <= txdetectrxloopback WHEN wire_w_lg_rtx_pipe_enable151w(0) = '1'  ELSE (txdetectrxloopback AND wire_niOlO_dataout);
	wire_nl0il_dataout <= txelecidle WHEN wire_w_lg_rtx_pipe_enable151w(0) = '1'  ELSE wire_nl11i_dataout;
	wire_nl0iO_dataout <= revloopback WHEN wire_w_lg_rtx_pipe_enable151w(0) = '1'  ELSE ((txdetectrxloopback AND wire_niOOl_dataout) AND (niO1O2 XOR niO1O1));
	wire_nl0ll_dataout <= txswing AND rtxswing_sel_ena;
	wire_nl0lO_dataout <= wire_niOOl_dataout AND rtx_pipe_enable;
	wire_nl0Oi_dataout <= wire_niOOi_dataout AND rtx_pipe_enable;
	wire_nl0Ol_dataout <= wire_niOlO_dataout AND rtx_pipe_enable;
	wire_nl0OO_dataout <= wire_niOll_dataout AND rtx_pipe_enable;
	wire_nl11i_dataout <= nl1li WHEN wire_w_lg_nilOO193w(0) = '1'  ELSE wire_nl11l_o;
	wire_nl11l_data <= ( wire_nil0i20_w_lg_w_lg_q190w191w & nl11O & nl10i & nl10l & wire_nil0l18_w_lg_w_lg_q184w185w & nl1ii & nl1il & nl1iO);
	wire_nl11l_sel <= ( rtx_elec_idle_delay(2 DOWNTO 1) & wire_nil0O16_w_lg_w_lg_q171w172w);
	nl11l :  oper_mux
	  GENERIC MAP (
		width_data => 8,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl11l_data,
		o => wire_nl11l_o,
		sel => wire_nl11l_sel
	  );

 END RTL; --stratixiv_hssi_tx_pipe_interface
--synopsys translate_on
--VALID FILE


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_q_pipe_interface_top IS
   PORT (
      
      -- General signals
      -- TX PIPE interface clock == TX Phase Comp write clock
      -- RX PIPE interface clock == RX Phase Comp read clock
      -- TX Phase Comp FIFO read clock
      -- synchronized reset i.e TX Phase Comp write clock
      -- synchronized reset i.e.RX Phase Comp read clock
      -- synchronized reset i.e.TX Phase Comp read clock
      
      -- CRAM 
      -- enable tx pipe interface
      -- enable rx pipe interface
      -- Single width = 0, double width = 1
      -- programmable delay for controlling output buffer
      -- Enables control of voltage swing level.  Implementation 
      -- is optional under PIPE 1.87.  When this CRAM is not set, full swing is the default mode
      -- normal = 0, bypass = 1
      -- recognize EDB = 0, PAD = 1 insertion for 8b/10b decode errors
      -- Combined reporting = 0 i.e. 8b/10b error|disparity error=> rxstatus=3'b100
      -- individual reporting = 1 i.e. 8b/10b error => rxstatus = 3'b111;
      -- disparity error => rxstatus = 3'b100
      -- no toggle (gen 2) = 0, toggle (option for gen 1) = 1
      
      -- programmable delay for the emulation circuitry of successfull power state
      -- transition.  Default delay between the change of power state and the assertion
      -- of ~ 13 parallel cycles.  Setting of this CRAM to 3'b000 will result in a delay
      -- of ~ 13 parallel cycles.
      
      -- PLD - PIPE Interface
      -- TX PIPE Interface: Command 
      -- P0 ==> loopback, P1 ==> RX detection
      -- output buffer control
      --			   txcompliance,				// compliance pattern command
      -- power state control
      
      -- Selects transmitter de-emphasis under Gen 2 speeds
      -- Selects transmitter voltage levels 
      -- Selects transmitter voltage swing levels
      
      -- TX PIPE Interface: Data
      -- TX data path	
      
      -- RX PIPE Interface: Command/Status
      -- polarity inversion command
      
      -- indicates symbol lock and valid data
      -- indicates receiver detection of electrical idle.  
      -- encodes receiver status and error codes when receiving data
      -- encodes compliance pattern speed when doing receiver detection
      
      -- RX PIPE Interface: Data
      -- RX data path
      
      -- PHYStatus Generator
      -- communicate completion of power state transitions, receiver 
      -- detection, rate change
      
      -- Commands
      -- enables reverse parallel loopback when in PIPE bypass mode
      -- enables polarity inversion when in PIPE bypass mode
      
      -- PIPE - PCS Inteface
      -- TX PIPE Interface
      -- TX data path to TX Phase Comp FIFO
      -- reverse parallel loopback control to MUX after the encoder
      -- compensated txelecidle from the TX Phase Comp FIFO
      -- synchronous to refclk_b
      
      -- Auto Speed Negotiation
      
      -- Auto Negotiation Module
      -- asserted when signaling rate change between Gen 1 and Gen 2 is in process.  Sychronization occurs within PIPE module
      
      -- RX PIPE Interface
      -- RX data path from the RX Phase comp FIFO
      -- polarity inversion control; sychronization occurs at 8b/10b decoder
      
      -- PIPE - PMA Interface
      -- TX PIPE Interface
      -- command to the output buffer
      -- command to the PMA module for receiver detection
      -- decoded power state: used internally to the PIPE interface
      
      -- RX PIPE Interface
      -- PMA indication of receiver being detected
      -- Validation of rx_found
      -- electrical idle detection from Rx Electrical Idle inference module
      
      --shawn
      --shawn
      --shawn
      
      -- PHYStatus Generator
      -- asserted when successful power state transition occurs
      -- validates power_state_transition_done, currently tied to 0
      
      -- PIPE-DPRIO interface
      -- Selects transmitter de-emphasis under Gen 2 speeds
      -- Selects transmitter voltage levels 
      -- Selects transmitter voltage swing levels
      
      --********************************************************************************
      -- INCLUDE STATEMENTS
      --********************************************************************************
      
      --********************************************************************************
      -- I/O SIGNALS
      --********************************************************************************
      -- General signals
      --shawn
      --shawn
      --shawn
      
      pipe_tx_clk                      : IN STD_LOGIC;
      pipe_rx_clk                      : IN STD_LOGIC;
      refclk_b                         : IN STD_LOGIC;
      tx_pipe_reset                    : IN STD_LOGIC;
      rx_pipe_reset                    : IN STD_LOGIC;
      refclk_b_reset                   : IN STD_LOGIC;
      
      -- CRAM 
      rtx_pipe_enable                  : IN STD_LOGIC;
      rrx_pipe_enable                  : IN STD_LOGIC;
      rrdwidth_rx                      : IN STD_LOGIC;
      rtx_elec_idle_delay              : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rtxswing_sel_ena                 : IN STD_LOGIC;
      rrx_detect_bypass                : IN STD_LOGIC;
      rclkcmpinsertpad                 : IN STD_LOGIC;
      rind_error_reporting             : IN STD_LOGIC;
      rphystatus_rst_toggle            : IN STD_LOGIC;
      rphystatus_delay                 : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- PLD - PIPE Interface
      -- TX PIPE Interface: Command 
      txdetectrxloopback               : IN STD_LOGIC;
      txelecidle                       : IN STD_LOGIC;
      powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      txdeemph                         : IN STD_LOGIC;
      txmargin                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      txswing                          : IN STD_LOGIC;
      
      -- TX PIPE Interface: Data
      txd_ch                           : IN STD_LOGIC_VECTOR(43 DOWNTO 0);
      
      -- RX PIPE Interface: Command/Status
      rxpolarity                       : IN STD_LOGIC;
      
      rxvalid                          : OUT STD_LOGIC;
      rxelecidle                       : OUT STD_LOGIC;
      rxstatus                         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE Interface: Data
      rxd_ch                           : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
      
      -- PHYStatus Generator
      phystatus                        : OUT STD_LOGIC;
      
      -- Commands
      revloopback                      : IN STD_LOGIC;
      polinv_rx                        : IN STD_LOGIC;
      
      -- PIPE - PCS Inteface
      -- TX PIPE Interface
      txd                              : OUT STD_LOGIC_VECTOR(43 DOWNTO 0);
      rev_loopbk                       : OUT STD_LOGIC;
      tx_elec_idle_comp                : IN STD_LOGIC;
      
      rindv_rx                         : IN STD_LOGIC;
      rmaster_rx                       : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rmaster_up_rx                    : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      
      -- Auto Negotiation Module
      speed_change                     : IN STD_LOGIC;
      speed_change_centrl              : IN STD_LOGIC;
      speed_change_quad_up             : IN STD_LOGIC;
      speed_change_quad_down           : IN STD_LOGIC;
      
      -- RX PIPE Interface
      rxd                              : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
      polinv_rx_int                    : OUT STD_LOGIC;
      
      -- PIPE - PMA Interface
      -- TX PIPE Interface
      tx_elec_idle                     : OUT STD_LOGIC;
      txdetectrx                       : OUT STD_LOGIC;
      powerstate                       : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      
      sigdetni                         : IN STD_LOGIC;  -- ww25_2008
      
      -- RX PIPE Interface
      rx_found                         : IN STD_LOGIC;
      rx_detect_valid                  : IN STD_LOGIC;
      rxelectricalidle                 : IN STD_LOGIC;
      txdetectrxin                     : IN STD_LOGIC;
      powerstatein                     : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      use_powerstatein                 : IN STD_LOGIC;
      
      -- PHYStatus Generator
      power_state_transition_done      : IN STD_LOGIC;
      power_state_transition_done_ena  : IN STD_LOGIC;
      
      -- PIPE-DPRIO interface
      txdeemph_int                     : OUT STD_LOGIC;
      txmargin_int                     : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txswing_int                      : OUT STD_LOGIC
   );
END stratixiv_hssi_q_pipe_interface_top;

ARCHITECTURE trans OF stratixiv_hssi_q_pipe_interface_top IS
   COMPONENT stratixiv_hssi_tx_pipe_interface
      PORT (
         clk                              : IN STD_LOGIC;
         refclk_b                         : IN STD_LOGIC;
         reset_n                          : IN STD_LOGIC;
         refclk_b_reset_n                 : IN STD_LOGIC;
         rtx_pipe_enable                  : IN STD_LOGIC;
         rtx_elec_idle_delay              : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         rtxswing_sel_ena                 : IN STD_LOGIC;
         txdetectrxloopback               : IN STD_LOGIC;
         txelecidle                       : IN STD_LOGIC;
         powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         txdeemph                         : IN STD_LOGIC;
         txmargin                         : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         txswing                          : IN STD_LOGIC;
         txd_ch                           : IN STD_LOGIC_VECTOR(43 DOWNTO 0);
         revloopback                      : IN STD_LOGIC;
         txd                              : OUT STD_LOGIC_VECTOR(43 DOWNTO 0);
         rev_loopbk                       : OUT STD_LOGIC;
         tx_elec_idle_comp                : IN STD_LOGIC;
         tx_elec_idle                     : OUT STD_LOGIC;
         txdetectrx                       : OUT STD_LOGIC;
         powerstate                       : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
         txdeemph_int                     : OUT STD_LOGIC;
         txmargin_int                     : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         txswing_int                      : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_phystatus_generator
      PORT (
         clk                              : IN STD_LOGIC;
         reset_n                          : IN STD_LOGIC;
         phystat_ena                      : IN STD_LOGIC;
         rphystatus_rst_toggle            : IN STD_LOGIC;
         rphystatus_delay                 : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         powerdown                        : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
         phystatus                        : OUT STD_LOGIC;
         latched_p0                       : IN STD_LOGIC;
         latched_p0s                      : IN STD_LOGIC;
         latched_p1                       : IN STD_LOGIC;
         latched_p2                       : IN STD_LOGIC;
         rindv_rx                         : IN STD_LOGIC;
         rmaster_rx                       : IN STD_LOGIC;
         rmaster_up_rx                    : IN STD_LOGIC;
         speed_change                     : IN STD_LOGIC;
         speed_change_centrl              : IN STD_LOGIC;
         speed_change_quad_up             : IN STD_LOGIC;
         speed_change_quad_down           : IN STD_LOGIC;
         rx_detect_valid                  : IN STD_LOGIC;
         power_state_transition_done      : IN STD_LOGIC;
         power_state_transition_done_ena  : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT stratixiv_hssi_rx_pipe_interface
      PORT (
         clk                              : IN STD_LOGIC;
         reset_n                          : IN STD_LOGIC;
         rrx_pipe_enable                  : IN STD_LOGIC;
         rrdwidth_rx                      : IN STD_LOGIC;
         rclkcmpinsertpad                 : IN STD_LOGIC;
         rind_error_reporting             : IN STD_LOGIC;
         rxpolarity                       : IN STD_LOGIC;
         rxvalid                          : OUT STD_LOGIC;
         rxelecidle                       : OUT STD_LOGIC;
         rxstatus                         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rxd_ch                           : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         polinv_rx                        : IN STD_LOGIC;
         rxd                              : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         polinv_rx_int                    : OUT STD_LOGIC;
         latched_p1                       : IN STD_LOGIC;
         txdetectrx                       : IN STD_LOGIC;
         rx_found                         : IN STD_LOGIC;
         rx_found_sync                    : IN STD_LOGIC;
         rx_detect_valid                  : IN STD_LOGIC;
         rx_detect_valid_sync             : IN STD_LOGIC;
         sigdetni                         : IN STD_LOGIC;  -- ww25_2008
         rxelectricalidle                 : IN STD_LOGIC
      );
   END COMPONENT;
   
   
   --********************************************************************************
   -- PARAMETERS
   --********************************************************************************
   
   --********************************************************************************
   -- DECLARATIONS
   --********************************************************************************
   
   SIGNAL phystat_ena            : STD_LOGIC;
   
   SIGNAL rx_found_reg_0         : STD_LOGIC;
   SIGNAL rx_found_reg_1         : STD_LOGIC;
   
   SIGNAL rx_detect_valid_reg_0  : STD_LOGIC;
   SIGNAL rx_detect_valid_reg_1  : STD_LOGIC;
   
   SIGNAL tx_pipe_reset_n        : STD_LOGIC;
   SIGNAL rx_pipe_reset_n        : STD_LOGIC;
   SIGNAL refclk_b_reset_n       : STD_LOGIC;		-- reset for txelecidle_d_generator
   
   SIGNAL txdetectrx_reg_0       : STD_LOGIC;
   SIGNAL txdetectrx_reg_1       : STD_LOGIC;
   SIGNAL txdetectrx_reg_2       : STD_LOGIC;
   SIGNAL txdetectrx_reg_3       : STD_LOGIC;
   SIGNAL txdetectrx_reg_4       : STD_LOGIC;
   SIGNAL txdetectrx_reg_5       : STD_LOGIC;
   SIGNAL txdetectrx_reg_6       : STD_LOGIC;
   
   SIGNAL bypass_rx_found        : STD_LOGIC;
   SIGNAL bypass_rx_detect_valid : STD_LOGIC;
   
   SIGNAL rx_found_int           : STD_LOGIC;
   SIGNAL rx_detect_valid_int    : STD_LOGIC;
   
   SIGNAL latched_p0             : STD_LOGIC;
   SIGNAL latched_p0s            : STD_LOGIC;
   SIGNAL latched_p1             : STD_LOGIC;
   SIGNAL latched_p2             : STD_LOGIC;
   
   SIGNAL p1_sync                : STD_LOGIC;
   
   SIGNAL tmp_txdetectrxin       : STD_LOGIC;		--shawn
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL rxvalid_xhdl7          : STD_LOGIC;
   SIGNAL rxelecidle_xhdl5       : STD_LOGIC;
   SIGNAL rxstatus_xhdl6         : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rxd_ch_xhdl4           : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL phystatus_xhdl0        : STD_LOGIC;
   SIGNAL txd_xhdl9              : STD_LOGIC_VECTOR(43 DOWNTO 0);
   SIGNAL rev_loopbk_xhdl3       : STD_LOGIC;
   SIGNAL polinv_rx_int_xhdl1    : STD_LOGIC;
   SIGNAL tx_elec_idle_xhdl8     : STD_LOGIC;
   SIGNAL txdetectrx_xhdl11      : STD_LOGIC;
   SIGNAL powerstate_xhdl2       : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL txdeemph_int_xhdl10    : STD_LOGIC;
   SIGNAL txmargin_int_xhdl12    : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL txswing_int_xhdl13     : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   rxvalid <= rxvalid_xhdl7;
   rxelecidle <= rxelecidle_xhdl5;
   rxstatus <= rxstatus_xhdl6;
   rxd_ch <= rxd_ch_xhdl4;
   phystatus <= phystatus_xhdl0;
   txd <= txd_xhdl9;
   rev_loopbk <= rev_loopbk_xhdl3;
   polinv_rx_int <= polinv_rx_int_xhdl1;
   tx_elec_idle <= tx_elec_idle_xhdl8;
   txdetectrx <= txdetectrx_xhdl11;
   powerstate <= powerstate_xhdl2;
   txdeemph_int <= txdeemph_int_xhdl10;
   txmargin_int <= txmargin_int_xhdl12;
   txswing_int <= txswing_int_xhdl13;
   
   --********************************************************************************
   -- ASSIGN STATEMENTS
   --********************************************************************************
   phystat_ena <= rtx_pipe_enable OR rrx_pipe_enable;
   
   tx_pipe_reset_n <= NOT(tx_pipe_reset);
   rx_pipe_reset_n <= NOT(rx_pipe_reset);
   refclk_b_reset_n <= NOT(refclk_b_reset);
   
   rx_found_int <= bypass_rx_found WHEN (rrx_detect_bypass = '1') ELSE
                   rx_found_reg_1;
   rx_detect_valid_int <= bypass_rx_detect_valid WHEN (rrx_detect_bypass = '1') ELSE
                          rx_detect_valid_reg_1;
   
   tmp_txdetectrxin <= txdetectrxin WHEN (use_powerstatein = '1') ELSE		--shawn
                       txdetectrx_xhdl11;
   
   latched_p0 <= powerstatein(0) WHEN (use_powerstatein = '1') ELSE		--shawn
                 powerstate_xhdl2(0);
   latched_p0s <= powerstatein(1) WHEN (use_powerstatein = '1') ELSE		--shawn;
                  powerstate_xhdl2(1);
   latched_p1 <= powerstatein(2) WHEN (use_powerstatein = '1') ELSE		--shawn;
                 powerstate_xhdl2(2);
   latched_p2 <= powerstatein(3) WHEN (use_powerstatein = '1') ELSE		--shawn;
                 powerstate_xhdl2(3);
   
   --********************************************************************************
   -- SUBMODULE INSTANTIATIONS
   --********************************************************************************
   
   
   
   tx_pipe_interface_inst : stratixiv_hssi_tx_pipe_interface
      PORT MAP (
         
         -- General signals
         clk                  => pipe_tx_clk,
         refclk_b             => refclk_b,
         reset_n              => tx_pipe_reset_n,
         refclk_b_reset_n     => refclk_b_reset_n,
         
         -- CRAM 
         rtx_pipe_enable      => rtx_pipe_enable,
         rtx_elec_idle_delay  => rtx_elec_idle_delay,
         
         rtxswing_sel_ena     => rtxswing_sel_ena,
         
         -- PLD - PIPE Interface
         -- TX PIPE Interface: Command
         txdetectrxloopback   => txdetectrxloopback,
         txelecidle           => txelecidle,
         --					     .txcompliance					(txcompliance),
         powerdown            => powerdown,
         
         txdeemph             => txdeemph,
         txmargin             => txmargin,
         txswing              => txswing,
         
         -- TX PIPE Interface: Data
         txd_ch               => txd_ch,
         
         -- Commands
         revloopback          => revloopback,
         
         -- PIPE - PCS Inteface
         -- TX PIPE Interface
         txd                  => txd_xhdl9,
         rev_loopbk           => rev_loopbk_xhdl3,
         tx_elec_idle_comp    => tx_elec_idle_comp,
         
         -- PIPE - PMA Interface
         tx_elec_idle         => tx_elec_idle_xhdl8,
         txdetectrx           => txdetectrx_xhdl11,
         
         -- Central PCS
         powerstate           => powerstate_xhdl2,
         
         -- PIPE - DPRIO
         txdeemph_int         => txdeemph_int_xhdl10,
         txmargin_int         => txmargin_int_xhdl12,
         txswing_int          => txswing_int_xhdl13
      );
   
   
   
   rx_pipe_interface_inst : stratixiv_hssi_rx_pipe_interface
      PORT MAP (
         
         -- General signals
         clk                   => pipe_rx_clk,
         reset_n               => rx_pipe_reset_n,
         
         -- CRAM 
         rrx_pipe_enable       => rrx_pipe_enable,
         rrdwidth_rx           => rrdwidth_rx,
         rclkcmpinsertpad      => rclkcmpinsertpad,
         rind_error_reporting  => rind_error_reporting,
         
         -- PLD - PIPE Interface
         -- RX PIPE Interface: Command/Status
         rxpolarity            => rxpolarity,
         
         rxvalid               => rxvalid_xhdl7,
         rxelecidle            => rxelecidle_xhdl5,
         rxstatus              => rxstatus_xhdl6,
         
         -- RX PIPE Interface: Data
         rxd_ch                => rxd_ch_xhdl4,
         
         -- Commands
         polinv_rx             => polinv_rx,
         
         -- PIPE - PCS Inteface
         -- RX PIPE Interface
         rxd                   => rxd,
         polinv_rx_int         => polinv_rx_int_xhdl1,
         
         -- TX PIPE Interface
         -- Latched Power State Signals
         latched_p1            => latched_p1,
         
         txdetectrx            => tmp_txdetectrxin,		--shawn (txdetectrx),
         
         -- PIPE - PMA Interface
         -- TX PIPE Interface
         rx_found              => rx_found,
         rx_found_sync         => rx_found_int,
         rx_detect_valid       => rx_detect_valid,
         rx_detect_valid_sync  => rx_detect_valid_int,
         
         sigdetni              => sigdetni,  -- ww25_2008
         
         -- RX PIPE Interface
         rxelectricalidle      => rxelectricalidle
      );
   
   
   
   phystatus_generator_inst : stratixiv_hssi_phystatus_generator
      PORT MAP (
         
         -- General signals
         clk                              => pipe_rx_clk,
         reset_n                          => rx_pipe_reset_n,
         
         --CRAM
         phystat_ena                      => phystat_ena,
         rphystatus_rst_toggle            => rphystatus_rst_toggle,
         rphystatus_delay                 => rphystatus_delay,
         
         -- PLD Interface
         powerdown                        => powerdown,
         phystatus                        => phystatus_xhdl0,
         
         -- Latched Power State Signals
         latched_p0                       => latched_p0,
         latched_p0s                      => latched_p0s,
         latched_p1                       => latched_p1,
         latched_p2                       => latched_p2,
         
         rindv_rx                         => rindv_rx,
         rmaster_rx                       => rmaster_rx,
         rmaster_up_rx                    => rmaster_up_rx,
         
         -- Auto Negotiation Module
         speed_change                     => speed_change,
         speed_change_centrl              => speed_change_centrl,
         speed_change_quad_up             => speed_change_quad_up,
         speed_change_quad_down           => speed_change_quad_down,
         
         -- TX PMA Interface
         rx_detect_valid                  => rx_detect_valid_int,
         
         -- RX PMA Interface
         power_state_transition_done      => power_state_transition_done,
         power_state_transition_done_ena  => power_state_transition_done_ena
      );
   
   --********************************************************************************
   -- MAIN CODE 
   --********************************************************************************
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         rx_detect_valid_reg_0 <=  TRANSPORT '0' AFTER 1* 1 ps;
         rx_found_reg_0 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         rx_detect_valid_reg_0 <=  TRANSPORT rx_detect_valid AFTER 1* 1 ps;
         rx_found_reg_0 <=  TRANSPORT rx_found AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         rx_detect_valid_reg_1 <=  TRANSPORT '0' AFTER 1* 1 ps;
         rx_found_reg_1 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         rx_detect_valid_reg_1 <=  TRANSPORT rx_detect_valid_reg_0 AFTER 1* 1 ps;
         rx_found_reg_1 <=  TRANSPORT rx_found_reg_0 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_0 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_0 <=  TRANSPORT tmp_txdetectrxin AFTER 1* 1 ps;		-- txdetectrx; shawn
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_1 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_1 <=  TRANSPORT txdetectrx_reg_0 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_2 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_2 <=  TRANSPORT txdetectrx_reg_1 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_3 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_3 <=  TRANSPORT txdetectrx_reg_2 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_4 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_4 <=  TRANSPORT txdetectrx_reg_3 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_5 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_5 <=  TRANSPORT txdetectrx_reg_4 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         txdetectrx_reg_6 <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         txdetectrx_reg_6 <=  TRANSPORT txdetectrx_reg_5 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   PROCESS (pipe_rx_clk, rx_pipe_reset_n)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rx_pipe_reset_n)) = '1') THEN
         bypass_rx_found <=  TRANSPORT '0' AFTER 1* 1 ps;
         bypass_rx_detect_valid <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') THEN
         bypass_rx_found <=  TRANSPORT txdetectrx_reg_6 AFTER 1* 1 ps;
         bypass_rx_detect_valid <=  TRANSPORT txdetectrx_reg_6 AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
END trans;



-- pipe_interface_top

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_tx_digis_txclk_gating IS
    PORT (
        
        select_n   : IN STD_LOGIC;
        clk1       : IN STD_LOGIC;
        clk2       : IN STD_LOGIC;
        clk1out_n  : OUT STD_LOGIC;
        clk2out_n  : OUT STD_LOGIC
    );
END stratixiv_hssi_tx_digis_txclk_gating;

ARCHITECTURE trans OF stratixiv_hssi_tx_digis_txclk_gating IS
BEGIN
    
    clk1out_n <= NOT((select_n OR clk1));
    clk2out_n <= NOT((NOT(select_n) OR clk2));
    
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_tx_digi_txclk_ctl IS
   PORT (
      
      -- Clock Inputs
      pld_tx_clk              : IN STD_LOGIC;		-- PLD clock from PLD clock trees, the transmit clock from XGMII.
      refclk_pma              : IN STD_LOGIC;		-- Quad based clk from TXPLL
      txpma_local_clk         : IN STD_LOGIC;		-- Local channel TX PMA clock.
      
      -- Control Inputs
      txrst                   : IN STD_LOGIC;		-- reset for the tx_pcs
      scan_mode               : IN STD_LOGIC;		-- Scan mode enable signal for selecting scan_clk from refclk_pma
      
      -- New Control Inputs
      gen2ngen1               : IN STD_LOGIC;		-- from PMA for PCIexp Gen1/Gen2 datawidth scaling
      gen2ngen1_bundle        : IN STD_LOGIC;		-- from PMA for PCIexp Gen1/Gen2 datawidth scaling in x4 and x8
      tx_div2_sync_centrl     : IN STD_LOGIC;		-- divided clock from the central channel (x2, x4 mode)
      tx_div2_sync_quad_up    : IN STD_LOGIC;		-- divided clock from quad above (> x4 mode)
      tx_div2_sync_quad_down  : IN STD_LOGIC;		-- divided clock from quad below (> x4 mode)
      
      -- MDIO Inputs
      rindv_tx                : IN STD_LOGIC;		-- Selects between indiv chan. mode and bundled mode
      rtxwrclksel             : IN STD_LOGIC;		-- Selects which clock writes into FIFO
      rtxrdclksel             : IN STD_LOGIC;		-- Selects which clock reads from FIFO and also clocks reest of TX logic
      rdwidth_tx              : IN STD_LOGIC;		-- divide by 1 or 2 before feeding to FIFO read clock
      rfreerun_tx             : IN STD_LOGIC;		-- Select whether divider is permamently enabled (free -running) or  divider should be enabled / reset by TX PCS reset  
      
      -- New MDIO Inputs
      rauto_speed_ena         : IN STD_LOGIC;		-- auto speed negotiation enable
      rfreq_sel               : IN STD_LOGIC;		-- freq scaling or data width scaling
      rtxpcsclkpwdn           : IN STD_LOGIC;		-- TX clocking power down enable
      rmaster_tx              : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rmaster_up_tx           : IN STD_LOGIC;		-- New bundle mode MDIO, selects master quad
      rself_sw_en_tx          : IN STD_LOGIC;		-- enables self-switch to have correct /2 clock in all quads in bundle mode
      
      -- Removed Inputs
      -- input        tx_div2_sync_in_ch0;    // from the channel zero tx_div2_sync_out
      -- input        tx_div2_sync_in_q0_ch0; // From channel0 of Master Quad
      -- input        rphfifo_master_sel_tx;  // TX Phase comp. FIFO tx_div2_sync selection CRAM
      
      -- Clock Outputs wtih CTS
      refclk_b                : OUT STD_LOGIC;		-- Drives the tx channel clock
      wr_clk_pos              : OUT STD_LOGIC;		-- Drives tx phase comp fifo write side
      fifo_rd_clk             : OUT STD_LOGIC;		-- Drives tx phase comp fifo read side
      
      -- Clock Outputs to PLD, w/o CTS
      tx_clk_out              : OUT STD_LOGIC;		-- Drives to the PLD clock tree -- unconnected
      
      -- New Clock Outputs with CTS
      refclk_b_raw            : OUT STD_LOGIC;		-- same as refclk_b, but with no clock gating
      wr_clk_pos_raw          : OUT STD_LOGIC;		-- same as wr_clk_pos, but with no clock gating
      fifo_rd_clk_raw         : OUT STD_LOGIC;		-- same as fifo_rd_clk, but with no clock gating
      
      -- Control Outputs
      tx_div2_sync_out        : OUT STD_LOGIC		-- Synchronizes the divided by two clock
   );
END stratixiv_hssi_tx_digi_txclk_ctl;

ARCHITECTURE trans OF stratixiv_hssi_tx_digi_txclk_ctl IS
   COMPONENT stratixiv_hssi_tx_digis_txclk_gating
        PORT (
            select_n                : IN STD_LOGIC;
            clk1                    : IN STD_LOGIC;
            clk2                    : IN STD_LOGIC;
            clk1out_n               : OUT STD_LOGIC;
            clk2out_n               : OUT STD_LOGIC
        );
    END COMPONENT;
   
   
   SIGNAL fifo_rd_clk_by2        : STD_LOGIC := '0';
   SIGNAL gen2ngen1_local_sync   : STD_LOGIC;
   SIGNAL counter                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   SIGNAL tx_rst_n               : STD_LOGIC;
   SIGNAL tx_div2_sync           : STD_LOGIC;
   SIGNAL dynamic_div2ndiv1      : STD_LOGIC;
   SIGNAL gen2ngen1_local        : STD_LOGIC;
   SIGNAL tx_div2_this_quad      : STD_LOGIC;
   SIGNAL tx_div2_this_channel   : STD_LOGIC;
   SIGNAL tx_div2_other_quad     : STD_LOGIC;
   SIGNAL force_master           : STD_LOGIC;
   SIGNAL rtxpcsclkpwdn_nscan    : STD_LOGIC;
   
    SIGNAL select_div1_n          : STD_LOGIC;
    SIGNAL clk1out_n              : STD_LOGIC;
    SIGNAL clk2out_n              : STD_LOGIC;
    
   -- Declare intermediate signals for referenced outputs
   SIGNAL fifo_rd_clk_xhdl0      : STD_LOGIC;
   SIGNAL refclk_b_raw_xhdl2     : STD_LOGIC;
   SIGNAL wr_clk_pos_raw_xhdl4   : STD_LOGIC;
   SIGNAL fifo_rd_clk_raw_xhdl1  : STD_LOGIC;
   SIGNAL tx_div2_sync_out_xhdl3 : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   fifo_rd_clk <= fifo_rd_clk_xhdl0;
   refclk_b_raw <= refclk_b_raw_xhdl2;
   wr_clk_pos_raw <= wr_clk_pos_raw_xhdl4;
   fifo_rd_clk_raw <= fifo_rd_clk_raw_xhdl1;
   tx_div2_sync_out <= tx_div2_sync_out_xhdl3;
   

   -- Old bundle logic:   
   -- Select between the local synchronization signal or the global synchronization signal (either from Channel0 or 
   -- Channel0 of Master Quad
   --assign tx_div2_sync = rindv_tx ? tx_div2_sync_out : tx_div2_sync_in;
   -- assign 	tx_div2_sync = (rphfifo_master_sel_tx == 1'b0) ? tx_div2_sync_in_q0_ch0 :
   --                            (rindv_tx == 1'b0) ? tx_div2_sync_in_ch0 : 
   --                            (rauto_speed_ena & ~rfreq_sel) ? (tx_div2_sync_out | ~gen2ngen1_local_sync) : tx_div2_sync_out;
   
   PROCESS (txrst, refclk_b_raw_xhdl2)
VARIABLE  txt : LINE;
   BEGIN
      IF (txrst = '1') THEN
         counter <=  TRANSPORT "00" AFTER 1* 1 ps;
      ELSIF (refclk_b_raw_xhdl2'EVENT AND refclk_b_raw_xhdl2 = '1') THEN
         IF (((rauto_speed_ena AND NOT(rfreq_sel) AND rself_sw_en_tx) AND NOT(force_master)) = '1') THEN
            counter <=  TRANSPORT counter + "01" AFTER 1* 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   force_master <= '1' WHEN ((counter = "11") AND ((rauto_speed_ena AND NOT(rfreq_sel) AND rself_sw_en_tx) = '1')) ELSE
                   '0';
   
   tx_div2_sync <= tx_div2_this_quad WHEN ((rmaster_tx OR force_master) = '1') ELSE
                   tx_div2_other_quad;
   tx_div2_this_quad <= tx_div2_this_channel WHEN ((rindv_tx OR force_master) = '1') ELSE
                        tx_div2_sync_centrl;
   tx_div2_this_channel <= (tx_div2_sync_out_xhdl3 OR NOT(gen2ngen1_local_sync)) WHEN ((rauto_speed_ena AND NOT(rfreq_sel)) = '1') ELSE
                           tx_div2_sync_out_xhdl3;
   tx_div2_other_quad <= tx_div2_sync_quad_up WHEN (rmaster_up_tx = '1') ELSE
                         tx_div2_sync_quad_down;
   
   gen2ngen1_local <= gen2ngen1_bundle WHEN (rindv_tx = '0') ELSE
                      gen2ngen1;
   
   PROCESS (txrst, refclk_b_raw_xhdl2)
VARIABLE  txt : LINE;
   BEGIN
      IF (txrst = '1') THEN
         gen2ngen1_local_sync <=  TRANSPORT '0' AFTER 1* 1 ps;
      ELSIF (refclk_b_raw_xhdl2'EVENT AND refclk_b_raw_xhdl2 = '1') THEN
         gen2ngen1_local_sync <=  TRANSPORT gen2ngen1_local AFTER 1* 1 ps;
      END IF;
   END PROCESS;
   
   dynamic_div2ndiv1 <= rdwidth_tx OR (gen2ngen1_local_sync AND rauto_speed_ena AND NOT(rfreq_sel));
   
   -- Reset for Divide-by-2 FF
   tx_rst_n <= '1' WHEN (rfreerun_tx = '1') ELSE
               NOT(txrst);
   
   rtxpcsclkpwdn_nscan <= rtxpcsclkpwdn AND NOT(scan_mode);
   
   -- Full speed clock for TX PCS
   refclk_b_raw_xhdl2 <= refclk_pma WHEN ((scan_mode OR rtxrdclksel) = '1') ELSE
                         txpma_local_clk;
   
   refclk_b <= '1' WHEN (rtxpcsclkpwdn_nscan = '1') ELSE
               refclk_b_raw_xhdl2;
   
   -- Divide-by-2 FF
   PROCESS (tx_rst_n, refclk_b_raw_xhdl2)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(tx_rst_n)) = '1') THEN
         fifo_rd_clk_by2 <= '1';
      ELSIF (refclk_b_raw_xhdl2'EVENT AND refclk_b_raw_xhdl2 = '1') THEN
         fifo_rd_clk_by2 <= tx_div2_sync;		-- local divided clock
      END IF;
   END PROCESS;
   
   tx_div2_sync_out_xhdl3 <= NOT(fifo_rd_clk_by2);
   
   -- TX FIFO read clock: could be fast or divided by 2
   -- old code:
   -- assign fifo_rd_clk = ((rdwidth_tx == 1'b0) || scan_mode) ? refclk_b_raw : fifo_rd_clk_by2;
   
   select_div1_n <= NOT((scan_mode OR NOT(dynamic_div2ndiv1)));
   
   stratixiv_hssi_tx_digis_txclk_gating_inst : stratixiv_hssi_tx_digis_txclk_gating
        PORT MAP (
            select_n   => select_div1_n,
            clk1       => refclk_b_raw_xhdl2,
            clk2       => fifo_rd_clk_by2,
            clk1out_n  => clk1out_n,
            clk2out_n  => clk2out_n
        );
        
  fifo_rd_clk_raw_xhdl1 <= NOT (clk1out_n OR clk2out_n);

   fifo_rd_clk_xhdl0 <= '1' WHEN (rtxpcsclkpwdn_nscan = '1') ELSE
                        fifo_rd_clk_raw_xhdl1;
   
   -- TX FIFO write clock: used internal clock when in BIST or scan or HIP
   wr_clk_pos_raw_xhdl4 <= fifo_rd_clk_raw_xhdl1 WHEN ((scan_mode OR rtxwrclksel) = '1') ELSE
                           pld_tx_clk;
   wr_clk_pos <= '1' WHEN (rtxpcsclkpwdn_nscan = '1') ELSE
                 wr_clk_pos_raw_xhdl4;
   
   -- TX Clock Out
   tx_clk_out <= fifo_rd_clk_xhdl0;		-- drives PLD clock tree
   
END trans;




-- txclk_ctl


LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_tx_digis_ram8x49_syn IS
   GENERIC (
      
      read_access_time   : INTEGER := 0;
      write_access_time  : INTEGER := 0;
      ram_width          : INTEGER := 54
   );
   PORT (
      data_in            : IN STD_LOGIC_VECTOR(53 DOWNTO 0);
      clk                : IN STD_LOGIC;
      fifo_wr            : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rst_l              : IN STD_LOGIC;
      fifo_re            : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      data_out           : OUT STD_LOGIC_VECTOR(53 DOWNTO 0)
   );
END stratixiv_hssi_tx_digis_ram8x49_syn;

ARCHITECTURE trans OF stratixiv_hssi_tx_digis_ram8x49_syn IS
   
   SIGNAL data_out_i    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_0 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_1 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_2 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_3 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_4 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_5 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_6 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_d_7 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_0 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_1 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_2 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_3 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_4 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_5 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_6 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL ram_array_q_7 : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   
   SIGNAL data_reg_0    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_1    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_2    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_3    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_4    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_5    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_6    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   SIGNAL data_reg_7    : STD_LOGIC_VECTOR(ram_width - 1 DOWNTO 0);
   
   SIGNAL we            : STD_LOGIC;
   SIGNAL re_l          : STD_LOGIC;
BEGIN
   
   we <= '1';
   re_l <= '0';
   
   data_reg_0 <= data_in WHEN (fifo_wr(0) = '1') ELSE
                 ram_array_q_0;
   data_reg_1 <= data_in WHEN (fifo_wr(1) = '1') ELSE
                 ram_array_q_1;
   data_reg_2 <= data_in WHEN (fifo_wr(2) = '1') ELSE
                 ram_array_q_2;
   data_reg_3 <= data_in WHEN (fifo_wr(3) = '1') ELSE
                 ram_array_q_3;
   data_reg_4 <= data_in WHEN (fifo_wr(4) = '1') ELSE
                 ram_array_q_4;
   data_reg_5 <= data_in WHEN (fifo_wr(5) = '1') ELSE
                 ram_array_q_5;
   data_reg_6 <= data_in WHEN (fifo_wr(6) = '1') ELSE
                 ram_array_q_6;
   data_reg_7 <= data_in WHEN (fifo_wr(7) = '1') ELSE
                 ram_array_q_7;
   
   data_out <= "100001000000000000000000000000000000000000000000000000" WHEN (re_l = '1') ELSE
               data_out_i;
   
   PROCESS (ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, fifo_re)
VARIABLE  txt : LINE;
   BEGIN
      CASE fifo_re IS		-- synopsys parallel_case full_case
         WHEN "00000001" =>
            data_out_i <= ram_array_q_0;
         WHEN "00000010" =>
            data_out_i <= ram_array_q_1;
         WHEN "00000100" =>
            data_out_i <= ram_array_q_2;
         WHEN "00001000" =>
            data_out_i <= ram_array_q_3;
         WHEN "00010000" =>
            data_out_i <= ram_array_q_4;
         WHEN "00100000" =>
            data_out_i <= ram_array_q_5;
         WHEN "01000000" =>
            data_out_i <= ram_array_q_6;
         WHEN "10000000" =>
            data_out_i <= ram_array_q_7;
         WHEN OTHERS =>
            data_out_i <= ram_array_q_0;
      END CASE;
   END PROCESS;
   
   
   PROCESS (clk, rst_l)
VARIABLE  txt : LINE;
   BEGIN
      IF ((NOT(rst_l)) = '1') THEN
         ram_array_q_0 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_1 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_2 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_3 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_4 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_5 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_6 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
         ram_array_q_7 <=  TRANSPORT "100001000000000000000000000000000000000000000000000000" AFTER (write_access_time)*1 ps;
      ELSIF (clk'EVENT AND clk = '1') THEN
         ram_array_q_0 <=  TRANSPORT ram_array_d_0 AFTER (write_access_time)*1 ps;
         ram_array_q_1 <=  TRANSPORT ram_array_d_1 AFTER (write_access_time)*1 ps;
         ram_array_q_2 <=  TRANSPORT ram_array_d_2 AFTER (write_access_time)*1 ps;
         ram_array_q_3 <=  TRANSPORT ram_array_d_3 AFTER (write_access_time)*1 ps;
         ram_array_q_4 <=  TRANSPORT ram_array_d_4 AFTER (write_access_time)*1 ps;
         ram_array_q_5 <=  TRANSPORT ram_array_d_5 AFTER (write_access_time)*1 ps;
         ram_array_q_6 <=  TRANSPORT ram_array_d_6 AFTER (write_access_time)*1 ps;
         ram_array_q_7 <=  TRANSPORT ram_array_d_7 AFTER (write_access_time)*1 ps;
      END IF;
   END PROCESS;
   
   
   PROCESS (we, data_reg_0, data_reg_1, data_reg_2, data_reg_3, data_reg_4, data_reg_5, data_reg_6, data_reg_7, ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7)
VARIABLE  txt : LINE;
   BEGIN
      IF (we = '1') THEN
         ram_array_d_0 <= data_reg_0;
         ram_array_d_1 <= data_reg_1;
         ram_array_d_2 <= data_reg_2;
         ram_array_d_3 <= data_reg_3;
         ram_array_d_4 <= data_reg_4;
         ram_array_d_5 <= data_reg_5;
         ram_array_d_6 <= data_reg_6;
         ram_array_d_7 <= data_reg_7;
      ELSE
         ram_array_d_0 <= ram_array_q_0;
         ram_array_d_1 <= ram_array_q_1;
         ram_array_d_2 <= ram_array_q_2;
         ram_array_d_3 <= ram_array_q_3;
         ram_array_d_4 <= ram_array_q_4;
         ram_array_d_5 <= ram_array_q_5;
         ram_array_d_6 <= ram_array_q_6;
         ram_array_d_7 <= ram_array_q_7;
      END IF;
   END PROCESS;
   
   
END trans;




LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_tx_digis_ph_fifo IS
   PORT (
      -- inputs
      --en,
      -- outputs
      
      -- =======
      -- inputs
      -- =======
      rst_wclk                 : IN STD_LOGIC;		-- wr clk rst
      rst_rclk                 : IN STD_LOGIC;		-- rd clk rst
      wr_clk                   : IN STD_LOGIC;		-- Write Clock
      rd_clk                   : IN STD_LOGIC;		-- Read Clock
      bypass_en                : IN STD_LOGIC;		-- FIFO bypass enable - only for Altera internal debug
      --input         en;		// Disable FIFO, reset wptr and rptr 
      -- only for Altera internal debug
      lowlatency_en            : IN STD_LOGIC;		-- Enable low latency option 
      we                       : IN STD_LOGIC;		-- PLD dynamic write pointer enable  
      re                       : IN STD_LOGIC;		-- PLD dynamic read pointer enable  
      din                      : IN STD_LOGIC_VECTOR(53 DOWNTO 0);		-- 10-bit code-group bus from deskew module.
      
      rphfifo_regmode_tx       : IN STD_LOGIC;
      rindv_tx                 : IN STD_LOGIC;
      rauto_speed_ena          : IN STD_LOGIC;
      reset_pc_ptrs            : IN STD_LOGIC;
      reset_pc_ptrs_centrl     : IN STD_LOGIC;
      reset_pc_ptrs_quad_up    : IN STD_LOGIC;
      reset_pc_ptrs_quad_down  : IN STD_LOGIC;
      rmaster_tx               : IN STD_LOGIC;
      rmaster_up_tx            : IN STD_LOGIC;
      
      -- =======
      -- outputs
      -- =======
      -- Indicates overflow (rd_clk)
      -- FIFO empty (rd_clk)
      data_out                 : OUT STD_LOGIC_VECTOR(53 DOWNTO 0);		-- output data (rd_clk synchronous if not FIFO bypass)
      ph_fifo_full             : OUT STD_LOGIC;
      ph_fifo_empty            : OUT STD_LOGIC;
      wptr_bin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);		-- wptr test bus
      rptr_bin                 : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)		-- rptr test bus
   );
END stratixiv_hssi_tx_digis_ph_fifo;

ARCHITECTURE trans OF stratixiv_hssi_tx_digis_ph_fifo IS
   COMPONENT stratixiv_hssi_tx_digis_ram8x49_syn
      GENERIC (
         read_access_time         : INTEGER := 0;
         write_access_time        : INTEGER := 0;
         ram_width                : INTEGER := 54
      );
      PORT (
         data_in                  : IN STD_LOGIC_VECTOR(53 DOWNTO 0);
         clk                      : IN STD_LOGIC;
         fifo_wr                  : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         rst_l                    : IN STD_LOGIC;
         fifo_re                  : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         data_out                 : OUT STD_LOGIC_VECTOR(53 DOWNTO 0)
      );
   END COMPONENT;
   
   
   -- ===================
   -- signal declaration
   -- ===================
   SIGNAL wptr                   : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL rptr                   : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL wptr0_pre              : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL wptr0                  : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL wptr1                  : STD_LOGIC_VECTOR(7 DOWNTO 0) := "00000000" ;
   SIGNAL rptr_gray              : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000" ;
   SIGNAL rptr_gray0             : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rptr0                  : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000" ;
   SIGNAL rptr1                  : STD_LOGIC_VECTOR(2 DOWNTO 0) := "000" ;
   SIGNAL rptr1_onehot           : STD_LOGIC_VECTOR(7 DOWNTO 0);
   -- wptr test bus
   -- rptr test bus
   SIGNAL first_rd               : STD_LOGIC;		-- first read after reset
   SIGNAL ram_data_out           : STD_LOGIC_VECTOR(53 DOWNTO 0);
   SIGNAL ram_data_out_pre       : STD_LOGIC_VECTOR(53 DOWNTO 0);
   
   SIGNAL ph_fifo_full_pre       : STD_LOGIC;
   
   -- Invert rst for new FIFO     
   SIGNAL rst_n                  : STD_LOGIC;
   
   SIGNAL fifo_cnt               : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL fifo_cnt_pre           : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL wptr1_bin              : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rptr1_bin_wclk         : STD_LOGIC_VECTOR(2 DOWNTO 0);
   
   SIGNAL reset_ptrs_local       : STD_LOGIC;
   
   SIGNAL reset_ptrs_local_sync1 : STD_LOGIC;
   SIGNAL reset_ptrs_local_sync2 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL ph_fifo_empty_xhdl0    : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   ph_fifo_empty <= ph_fifo_empty_xhdl0;
   
   -- =============
   -- functionality
   -- =============
   rst_n <= NOT(rst_wclk);
   
   data_out(53 DOWNTO 0) <= din WHEN (bypass_en = '1') ELSE
                            ram_data_out;
   
   reset_ptrs_local <= rauto_speed_ena AND reset_pc_ptrs WHEN (rindv_tx = '1') ELSE
                       reset_pc_ptrs_centrl WHEN (rmaster_tx = '1') ELSE
                       reset_pc_ptrs_quad_up WHEN (rmaster_up_tx = '1') ELSE
                       reset_pc_ptrs_quad_down;
   
   --newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use
   -- manually translated
   PROCESS(fifo_cnt_pre, rst_wclk, rptr1_bin_wclk, wptr1_bin)
   BEGIN
       IF (rptr1_bin_wclk = wptr1_bin) THEN
           IF (rst_wclk /= '1') THEN
               IF (fifo_cnt_pre = "0111" OR fifo_cnt_pre = "0110" OR fifo_cnt_pre = "1000") THEN
                   fifo_cnt <= "1000";
               ELSE
                   fifo_cnt <= "0000";
               END IF;    
           ELSE
               fifo_cnt <= "0000";
           END IF;
       ELSE
           IF (wptr1_bin > rptr1_bin_wclk) THEN
               fifo_cnt <= ('0' & (wptr1_bin - rptr1_bin_wclk));
           ELSE
               fifo_cnt <= ("1000" - ('0' & (rptr1_bin_wclk - wptr1_bin)));
           END IF;     
       END IF;
   END PROCESS;
   
   --newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use 
   -- incorrect translation - replaced above section
   --fifo_cnt <= "1000" WHEN (fifo_cnt_pre = "0111" OR fifo_cnt_pre = "0110" OR fifo_cnt_pre = "1000") ELSE
   --            "0000" WHEN (rst_wclk /= '1') ELSE
   --            "0000" WHEN (wptr1_bin = rptr1_bin_wclk) ELSE
   --            ('0' & (wptr1_bin - rptr1_bin_wclk)) WHEN (wptr1_bin > rptr1_bin_wclk) ELSE
   --            ("1000" - ('0' & (rptr1_bin_wclk - wptr1_bin)));
   
   PROCESS (rst_wclk, wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_wclk = '1') THEN
         reset_ptrs_local_sync1 <=  TRANSPORT '0' AFTER 1 ps;
         reset_ptrs_local_sync2 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         IF (rphfifo_regmode_tx = '1') THEN
            reset_ptrs_local_sync1 <=  TRANSPORT '0' AFTER 1 ps;
            reset_ptrs_local_sync2 <=  TRANSPORT '0' AFTER 1 ps;
         ELSE
            reset_ptrs_local_sync1 <=  TRANSPORT reset_ptrs_local AFTER 1 ps;
            reset_ptrs_local_sync2 <=  TRANSPORT reset_ptrs_local_sync1 AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS; -- always @ (posedge rst_wclk or posedge wr_clk)

    --ECO for S4GX to fix metastability issue
    -- replace the 1st FF with new flop w/o reset
    -- replace the 2nd FF with an enhanced flop
    PROCESS (wr_clk)
    BEGIN
        IF (wr_clk'EVENT AND wr_clk = '1') THEN
            IF (reset_ptrs_local_sync2 = '1' OR rphfifo_regmode_tx = '1') THEN
                rptr0 <=  TRANSPORT "000" AFTER 1 ps;
            ELSE
                rptr0 <=  TRANSPORT rptr_gray(2 DOWNTO 0) AFTER 1 ps;
            END IF;
        END IF;
    END PROCESS; -- always @ (posedge rst_wclk or posedge wr_clk)
      
    PROCESS(rst_wclk, wr_clk)
    BEGIN
      IF (rst_wclk = '1') THEN
         rptr1 <=  TRANSPORT "000" AFTER 1 ps;
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         IF ((reset_ptrs_local_sync2 OR rphfifo_regmode_tx) = '1') THEN
            rptr1 <=  TRANSPORT "000" AFTER 1 ps;
         ELSE
            rptr1 <=  TRANSPORT rptr0 AFTER 1 ps;
         END IF;
      END IF;
     END PROCESS;  -- always @ (posedge rst_wclk or posedge wr_clk)
      
   PROCESS (rst_wclk, wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_wclk = '1') THEN
         wptr <=  TRANSPORT "00000001" AFTER 1 ps;
         wptr0_pre <=  TRANSPORT "00000001" AFTER 1 ps;
         wptr0 <=  TRANSPORT "00000001" AFTER 1 ps;
         wptr1 <=  TRANSPORT "00000001" AFTER 1 ps;
         --rptr0 <=  TRANSPORT "000" AFTER 1 ps;
         --rptr1 <=  TRANSPORT "000" AFTER 1 ps;
         ph_fifo_full_pre <=  TRANSPORT '0' AFTER 1 ps;
         ph_fifo_full <=  TRANSPORT '0' AFTER 1 ps;
         ph_fifo_empty_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;		-- fifo_cnt previous value
         fifo_cnt_pre <=  TRANSPORT "0000" AFTER 1 ps;		-- if (rst_wclk == 1'b1)
      ELSIF (wr_clk'EVENT AND wr_clk = '1') THEN
         IF ((reset_ptrs_local_sync2 OR rphfifo_regmode_tx) = '1') THEN
            wptr <=  TRANSPORT "00000001" AFTER 1 ps;
            wptr0_pre <=  TRANSPORT "00000001" AFTER 1 ps;
            wptr0 <=  TRANSPORT "00000001" AFTER 1 ps;
            wptr1 <=  TRANSPORT "00000001" AFTER 1 ps;
            --rptr0 <=  TRANSPORT "000" AFTER 1 ps;
            --rptr1 <=  TRANSPORT "000" AFTER 1 ps;
            ph_fifo_full_pre <=  TRANSPORT '0' AFTER 1 ps;
            ph_fifo_full <=  TRANSPORT '0' AFTER 1 ps;
            ph_fifo_empty_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;		-- fifo_cnt previous value
            fifo_cnt_pre <=  TRANSPORT "0000" AFTER 1 ps;		-- if (reset_ptrs_local_sync2)
         ELSE
            
            fifo_cnt_pre <=  TRANSPORT fifo_cnt AFTER 1 ps;
            ph_fifo_full <=  TRANSPORT ph_fifo_full_pre AFTER 1 ps;
            wptr0_pre <=  TRANSPORT wptr AFTER 1 ps;
            wptr0 <=  TRANSPORT wptr0_pre AFTER 1 ps;
            wptr1 <=  TRANSPORT wptr0 AFTER 1 ps;
            
            --rptr0 <=  TRANSPORT rptr_gray(2 DOWNTO 0) AFTER 1 ps;
            --rptr1 <=  TRANSPORT rptr0 AFTER 1 ps;
            
            -- wptr operation
            IF (we = '1') THEN
               
               -- full condition
               --$if ({wptr1[6:0],wptr1[7]} == rptr1_onehot)
               --new full flag requirement
               wptr <=  TRANSPORT (wptr(6 DOWNTO 0) & wptr(7)) AFTER 1 ps;
            END IF;
            IF ((fifo_cnt = "1000") AND ((NOT(ph_fifo_empty_xhdl0))) = '1') THEN
               --else if (ph_fifo_full_pre == 1'b1 & (wptr1 != rptr1_onehot)) //now become sticky flag until reset
               --ph_fifo_full_pre <= #1 1'b0;
               
               -- empty condition
               --$if ({rptr1_onehot[6:0],rptr1_onehot[7]} == wptr1)
               --new empty flag requirement
               ph_fifo_full_pre <=  TRANSPORT '1' AFTER 1 ps;		--==1 to cover if wptr not moving
            END IF;
            IF ((((wptr1(6 DOWNTO 0)) & (wptr1(7))) = rptr1_onehot) AND (fifo_cnt_pre = "0001" OR fifo_cnt_pre = "0000") AND ((NOT(ph_fifo_full_pre))) = '1') THEN
               --else if (ph_fifo_empty == 1'b1 & ({wptr1[6:0],wptr1[7]} != rptr1_onehot)) //now become sticky flag until reset
               --ph_fifo_empty <= #1 1'b0;
               ph_fifo_empty_xhdl0 <=  TRANSPORT '1' AFTER 1 ps;
            END IF;
         END IF;
      END IF;
   END PROCESS; -- always @ (posedge rst_wclk or posedge wr_clk)
   -- end of eco
   
   PROCESS (rst_rclk, rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_rclk = '1') THEN
         first_rd <=  TRANSPORT '1' AFTER 1 ps;
         rptr <=  TRANSPORT "00100000" AFTER 1 ps;
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         IF ((reset_ptrs_local OR rphfifo_regmode_tx) = '1') THEN
            first_rd <=  TRANSPORT '1' AFTER 1 ps;
            rptr <=  TRANSPORT "00100000" AFTER 1 ps;
         ELSE
            
            IF (first_rd = '1' AND re = '1') THEN
               
               -- read pointer operation
               first_rd <=  TRANSPORT '0' AFTER 1 ps;
            END IF;
            IF (re = '1') THEN
               -- low latency option, advance 2 on the first read 
               IF (first_rd = '1' AND lowlatency_en = '1') THEN
                  rptr <=  TRANSPORT (rptr(5 DOWNTO 0) & rptr(7 DOWNTO 6)) AFTER 1 ps;
               ELSE
                  rptr <=  TRANSPORT (rptr(6 DOWNTO 0) & rptr(7)) AFTER 1 ps;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge rst_rclk or posedge rd_clk)
   
   -- Instantiate FIFO CORE Module. Fifo 8 words deep, 44 bits wide
   
   
   
   ram8x49_syn_1 : stratixiv_hssi_tx_digis_ram8x49_syn
      PORT MAP (
         rst_l     => rst_n,
         clk       => wr_clk,
         fifo_wr   => wptr,
         data_in   => din,
         fifo_re   => rptr,
         data_out  => ram_data_out_pre
      );
   
   PROCESS (rst_rclk, rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_rclk = '1') THEN
         ram_data_out <=  TRANSPORT "100000000000000000000000000000000000000000000000000000" AFTER 1 ps;
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         IF (rphfifo_regmode_tx = '1') THEN
            ram_data_out <=  TRANSPORT din AFTER 1 ps;
         ELSE
            ram_data_out <=  TRANSPORT ram_data_out_pre AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge rst_rclk or posedge rd_clk)
   
   PROCESS (wptr)
VARIABLE  txt : LINE;
   BEGIN
      CASE wptr IS
         WHEN "00000001" =>
            wptr_bin <= "000";
         WHEN "00000010" =>
            wptr_bin <= "001";
         WHEN "00000100" =>
            wptr_bin <= "010";
         WHEN "00001000" =>
            wptr_bin <= "011";
         WHEN "00010000" =>
            wptr_bin <= "100";
         WHEN "00100000" =>
            wptr_bin <= "101";
         WHEN "01000000" =>
            wptr_bin <= "110";
         WHEN "10000000" =>
            wptr_bin <= "111";
         WHEN OTHERS =>		-- case(wptr)
            wptr_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (wptr)
   
   PROCESS (wptr1)
VARIABLE  txt : LINE;
   BEGIN
      CASE wptr1 IS
         WHEN "00000001" =>
            wptr1_bin <= "000";
         WHEN "00000010" =>
            wptr1_bin <= "001";
         WHEN "00000100" =>
            wptr1_bin <= "010";
         WHEN "00001000" =>
            wptr1_bin <= "011";
         WHEN "00010000" =>
            wptr1_bin <= "100";
         WHEN "00100000" =>
            wptr1_bin <= "101";
         WHEN "01000000" =>
            wptr1_bin <= "110";
         WHEN "10000000" =>
            wptr1_bin <= "111";
         WHEN OTHERS =>		-- case(wptr1)
            wptr1_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (wptr1)
   
   PROCESS (rptr)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr IS
         WHEN "00000001" =>
            rptr_bin <= "000";
         WHEN "00000010" =>
            rptr_bin <= "001";
         WHEN "00000100" =>
            rptr_bin <= "010";
         WHEN "00001000" =>
            rptr_bin <= "011";
         WHEN "00010000" =>
            rptr_bin <= "100";
         WHEN "00100000" =>
            rptr_bin <= "101";
         WHEN "01000000" =>
            rptr_bin <= "110";
         WHEN "10000000" =>
            rptr_bin <= "111";
         WHEN OTHERS =>		-- case(rptr)
            rptr_bin <= "111";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr)
   
   PROCESS (rst_rclk, rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (rst_rclk = '1') THEN
         rptr_gray <=  TRANSPORT "000" AFTER 1 ps;
      ELSIF (rd_clk'EVENT AND rd_clk = '1') THEN
         rptr_gray <=  TRANSPORT rptr_gray0 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   
   PROCESS (rptr)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr IS
         WHEN "00000001" =>
            rptr_gray0 <= "000";
         WHEN "00000010" =>
            rptr_gray0 <= "001";
         WHEN "00000100" =>
            rptr_gray0 <= "011";
         WHEN "00001000" =>
            rptr_gray0 <= "010";
         WHEN "00010000" =>
            rptr_gray0 <= "110";
         WHEN "00100000" =>
            rptr_gray0 <= "111";
         WHEN "01000000" =>
            rptr_gray0 <= "101";
         WHEN "10000000" =>
            rptr_gray0 <= "100";
         WHEN OTHERS =>		-- case(rptr)
            rptr_gray0 <= "000";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr)
   
   PROCESS (rptr1)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr1 IS
         WHEN "000" =>
            rptr1_onehot <= "00000001";
         WHEN "001" =>
            rptr1_onehot <= "00000010";
         WHEN "011" =>
            rptr1_onehot <= "00000100";
         WHEN "010" =>
            rptr1_onehot <= "00001000";
         WHEN "110" =>
            rptr1_onehot <= "00010000";
         WHEN "111" =>
            rptr1_onehot <= "00100000";
         WHEN "101" =>
            rptr1_onehot <= "01000000";
         WHEN "100" =>
            rptr1_onehot <= "10000000";
         WHEN OTHERS =>		-- case(rptr1)
            rptr1_onehot <= "00000001";
      END CASE;
   END PROCESS;
   
   -- always@ (rptr1)
   
   PROCESS (rptr1)
VARIABLE  txt : LINE;
   BEGIN
      CASE rptr1 IS
         WHEN "000" =>
            rptr1_bin_wclk <= "000";
         WHEN "001" =>
            rptr1_bin_wclk <= "001";
         WHEN "011" =>
            rptr1_bin_wclk <= "010";
         WHEN "010" =>
            rptr1_bin_wclk <= "011";
         WHEN "110" =>
            rptr1_bin_wclk <= "100";
         WHEN "111" =>
            rptr1_bin_wclk <= "101";
         WHEN "101" =>
            rptr1_bin_wclk <= "110";
         WHEN "100" =>
            rptr1_bin_wclk <= "111";
         WHEN OTHERS =>		-- case(rptr1)
            rptr1_bin_wclk <= "000";
      END CASE;
   END PROCESS;
   
   
END trans;


-- always@ (rptr1)


-- ph_fifo_tx

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY STD;
USE STD.textio.ALL;
USE work.stratixiv_hssi_components.all;

ENTITY stratixiv_hssi_tx_digi_tx_ctrl IS
   PORT (
      -- inputs
      --is_lane0,
      -- PCS bypass
      
      -- TX PIPE signals
      
      -- RX PIPE signals
      
      -- New inputs for new bundling scheme and new PCIE features like autospeed
      
      -- New MDIO for new bundling scheme and new PCIE features like autospeed
      
      -- outputs
      
      -- TX PIPE signals
      
      -- RX PIPE signals
      
      -- test bus
      -- fifo_select_out	// test_bus[8], bit re-used in test bus
      -- test_bus[7]
      -- test_bus[6:4]
      -- test_bus[3]
      -- test_bus[2:0]
      -- *_xgmii = from XGMII interface
      -- *_sg    = from selftest_gen
      -- *_rc    = from rx_ctrl
      
      -- ======
      -- inputs
      -- ======
      soft_reset                : IN STD_LOGIC;		-- Reset
      fifo_wr_clk               : IN STD_LOGIC;		-- Used to be wr_clk_pos
      fifo_rd_clk               : IN STD_LOGIC;		-- Coming from txclk_xg_ctl 
      refclk_b_in               : IN STD_LOGIC;		-- The local reference clock used by the internal
      -- transmit logic. Used to be tx_clk.
      scan_mode                 : IN STD_LOGIC;		-- scan enable
      -- Control bit/pin to enable parallel loop back at XGMII
      -- To select XGMII signals from selftest_gen (*_sg)
      -- Control bit to support double-width data bus on xgmii.
      -- When set, fifo_wr_clk is running at half frequency
      -- as refclk_b_in and 2-byte/code-group of data should be sampled
      -- at the rising edge of fifo_wr_clk. When DWIDTH=1'b0, the
      -- fifo_wr_clk is running at the same frequency as refclk_b_in.
      rindv_tx                  : IN STD_LOGIC;
      p_rlpbk                   : IN STD_LOGIC;
      selftest_en               : IN STD_LOGIC;
      rdwidth_tx                : IN STD_LOGIC;
      --input		is_lane0; 	// lane 0 of the quad
      -- rx data from rx_ctrl.
      txfifo_dis                : IN STD_LOGIC;
      
      -- Tx data 
      -- These extension bits may be used to force disparity or other uses.
      -- Extend txd by 2 bits. Used to force disparity.
      -- The xgmii data from selftest_gen..
      -- The xgmii control from selftest_gen.
      -- redundant Tx data , unused
      -- redundant Tx data select, unused
      -- Acting with {txd_extend, TXD[9]	forces current disparity to 1 or 0
      
      rtxfifo_urst_en           : IN STD_LOGIC;		-- user reset CRAM enable
      txfifo_urst               : IN STD_LOGIC;		-- user reset 
      rtxfifo_lowlatency_en     : IN STD_LOGIC;		-- low latency enable
      rtxphfifopldctl_en        : IN STD_LOGIC;		-- CRAM to enable PLD controlled write/read enable
      rtx_pipe_enable           : IN STD_LOGIC;		-- enable pipe
      pld_we                    : IN STD_LOGIC;		-- PLD phase comp. fifo we, level active
      pld_rd_dis                : IN STD_LOGIC;		-- PLD phase comp. fifo rd dis, edge active
      txd                       : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
      txd_extend                : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rforce_disp               : IN STD_LOGIC;
      tx_data_sg                : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      tx_control_sg             : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      rxd_lpbk                  : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
      redund_ctl                : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      txd_redun                 : IN STD_LOGIC_VECTOR(39 DOWNTO 0);
      rforce_kchar              : IN STD_LOGIC;
      rforce_echar              : IN STD_LOGIC;
      -- PCS Bypass mode
      rtxpcsbypass_en           : IN STD_LOGIC;
      
      -- TX PIPE interface signals
      txdetectrxloopback        : IN STD_LOGIC;
      --input			txelecidle; 	txd[9]
      --input			txcompliance;	txd[10] and txd[32]
      powerdown                 : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      revloopback               : IN STD_LOGIC;
      
      txswing                   : IN STD_LOGIC;
      txdeemph                  : IN STD_LOGIC;
      txmargin                  : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE interface signals
      rxpolarity                : IN STD_LOGIC;
      polinv_rx                 : IN STD_LOGIC;
      eidleinfersel             : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- New Inputs for new bundling scheme and new PCIE features like autospeed
      reset_pc_ptrs             : IN STD_LOGIC;
      reset_pc_ptrs_centrl      : IN STD_LOGIC;
      reset_pc_ptrs_quad_up     : IN STD_LOGIC;
      reset_pc_ptrs_quad_down   : IN STD_LOGIC;
      gen2ngen1                 : IN STD_LOGIC;
      gen2ngen1_bundle          : IN STD_LOGIC;
      dis_pc_byte               : IN STD_LOGIC;
      wr_enable_centrl          : IN STD_LOGIC;
      wr_enable_quad_up         : IN STD_LOGIC;
      wr_enable_quad_down       : IN STD_LOGIC;
      rd_enable_centrl          : IN STD_LOGIC;
      rd_enable_quad_up         : IN STD_LOGIC;
      rd_enable_quad_down       : IN STD_LOGIC;
      fifo_select_in_centrl     : IN STD_LOGIC;
      fifo_select_in_quad_up    : IN STD_LOGIC;
      fifo_select_in_quad_down  : IN STD_LOGIC;
      
      -- New MDIO for new bundling scheme and new PCIE features like autospeed
      rauto_speed_ena           : IN STD_LOGIC;
      rfreq_sel                 : IN STD_LOGIC;
      rphfifo_regmode_tx        : IN STD_LOGIC;
      rmaster_tx                : IN STD_LOGIC;
      rmaster_up_tx             : IN STD_LOGIC;
      
      -- =======
      -- outputs
      -- =======
      txd_extend_tc             : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);		-- This will go to the encoder. This is serialized (muxed) txd_extend_int. But 
      -- txd_extend_int has to go through the FIFOs first to be serialized. 
      -- ch0 wr_enable1 output for X4/X8 mode
      -- ch0 rd_enable1 output for X4/X8 mode
      tx_data_tc                : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);		-- 8-bit data passed onto the internal transmit logic.
      tx_ctl_tc                 : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);		-- Control passed onto the internal transmit logic.
      -- Can be bit 8 of the 10-bit code group.
      tx_data_9_tc              : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);		-- Bit 9 of the 10-bit code group passed onto the internal transmit logic.
      rd_enable_sync            : OUT STD_LOGIC;
      k_det                     : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      d21_5_eq_n                : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      d2_2_eq_n                 : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      wr_enable_out             : OUT STD_LOGIC;
      rd_enable_out             : OUT STD_LOGIC;
      fifo_select_out           : OUT STD_LOGIC;		-- New output for Rev.B 
      ph_fifo_full              : OUT STD_LOGIC;		-- fifo full flag
      ph_fifo_empty             : OUT STD_LOGIC;		-- fifo empty flag
      soft_reset_wclk1          : OUT STD_LOGIC;		-- synchronized reset for BIST;
      soft_reset_rclk1          : OUT STD_LOGIC;		-- syncrhonized reset for PIPE
      pipe_electric_idle        : OUT STD_LOGIC;		-- PIPE electric idle bit
      
      -- TX PIPE interface signals
      txdetectrxloopback_int    : OUT STD_LOGIC;
      --output			txelecidle; 	txd[9]
      --output			txcompliance;	txd[10] and txd[32]
      powerdown_int             : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      
      revloopback_int           : OUT STD_LOGIC;
      
      phfifo_txswing            : OUT STD_LOGIC;
      phfifo_txdeemph           : OUT STD_LOGIC;
      phfifo_txmargin           : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- RX PIPE interface signals
      rxpolarity_int            : OUT STD_LOGIC;
      polinv_rx_int             : OUT STD_LOGIC;
      gray_eidleinfersel        : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      
      -- test bus
      -- testbus[8]   = fifo_select_out
      -- testbus[7]   = wr_enable2
      -- testbus[6:4] = wptr_bin
      -- testbus[3]   = rd_enable2
      -- testbus[2:0] = rptr_bin
      wr_enable2                : OUT STD_LOGIC;
      wptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      rd_enable2                : OUT STD_LOGIC;
      rptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
   );
END stratixiv_hssi_tx_digi_tx_ctrl;

ARCHITECTURE trans OF stratixiv_hssi_tx_digi_tx_ctrl IS
   COMPONENT stratixiv_hssi_tx_digis_ph_fifo
      PORT (
         rst_wclk                  : IN STD_LOGIC;
         rst_rclk                  : IN STD_LOGIC;
         wr_clk                    : IN STD_LOGIC;
         rd_clk                    : IN STD_LOGIC;
         bypass_en                 : IN STD_LOGIC;
         lowlatency_en             : IN STD_LOGIC;
         we                        : IN STD_LOGIC;
         re                        : IN STD_LOGIC;
         din                       : IN STD_LOGIC_VECTOR(53 DOWNTO 0);
         rphfifo_regmode_tx        : IN STD_LOGIC;
         rindv_tx                  : IN STD_LOGIC;
         rauto_speed_ena           : IN STD_LOGIC;
         reset_pc_ptrs             : IN STD_LOGIC;
         reset_pc_ptrs_centrl      : IN STD_LOGIC;
         reset_pc_ptrs_quad_up     : IN STD_LOGIC;
         reset_pc_ptrs_quad_down   : IN STD_LOGIC;
         rmaster_tx                : IN STD_LOGIC;
         rmaster_up_tx             : IN STD_LOGIC;
         data_out                  : OUT STD_LOGIC_VECTOR(53 DOWNTO 0);
         ph_fifo_full              : OUT STD_LOGIC;
         ph_fifo_empty             : OUT STD_LOGIC;
         wptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         rptr_bin                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0)
      );
   END COMPONENT;
   
   
   -- ================
   -- internal signals
   -- ================
   
   -- Begin: 22 Bits output of this module (44 to 22 / 22 to 22)
   SIGNAL tx_data_tc_mux             : STD_LOGIC_VECTOR(15 DOWNTO 0);		--temp holder for non PCS bypass data branch before mux
   SIGNAL tx_ctl_tc_mux              : STD_LOGIC_VECTOR(1 DOWNTO 0);		--temp holder for non PCS bypass branch before mux
   SIGNAL tx_data_9_tc_mux           : STD_LOGIC_VECTOR(1 DOWNTO 0);		--temp holder for non PCS bypass branch before mux
   SIGNAL txd_extend_tc_mux          : STD_LOGIC_VECTOR(1 DOWNTO 0);		--temp holder for non PCS bypass branch before mux
   -- End:   22 bits output of this module
   
   SIGNAL tx_data_lt                 : STD_LOGIC_VECTOR(19 DOWNTO 0);
   
   SIGNAL tx_data                    : STD_LOGIC_VECTOR(39 DOWNTO 0);
   SIGNAL din0                       : STD_LOGIC_VECTOR(53 DOWNTO 0);
   SIGNAL fifo_data_out              : STD_LOGIC_VECTOR(39 DOWNTO 0);
   SIGNAL tx_data_9_tc_d             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_data_9_tc_d_others      : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_ctl_tc_d                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_ctl_tc_d_others         : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL tx_data_tc_d               : STD_LOGIC_VECTOR(15 DOWNTO 0);
   SIGNAL tx_data_tc_d_others        : STD_LOGIC_VECTOR(17 DOWNTO 0);
   SIGNAL d21_5_eq_n_d               : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL d2_2_eq_n_d                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL k_det_sync1                : STD_LOGIC_VECTOR(1 DOWNTO 0);
   
   SIGNAL txfifo_en_refclk0          : STD_LOGIC;
   SIGNAL txfifo_en_refclk1          : STD_LOGIC;
   
   SIGNAL wr_enable0                 : STD_LOGIC;
   SIGNAL wr_enable0p5               : STD_LOGIC;
   SIGNAL wr_enable1                 : STD_LOGIC;
   SIGNAL rd_enable0                 : STD_LOGIC;
   SIGNAL rd_enable0p5               : STD_LOGIC;
   SIGNAL rd_enable1                 : STD_LOGIC;
   
   SIGNAL txd_extend_int             : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL txd_extend_tc_d            : STD_LOGIC_VECTOR(1 DOWNTO 0);		-- This is registered and sent out to the encoder as txd_extend_tc. 
   -- This is serialized (muxed) txd_extend_int. But 
   -- txd_extend_int has to go through the FIFOs first to be serialized. 
   SIGNAL txd_extend_low             : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL txd_extend_high            : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL txd_data_extend_tmp        : STD_LOGIC_VECTOR(17 DOWNTO 0);
   
   SIGNAL txfifo_en_rclk0            : STD_LOGIC;
   SIGNAL txfifo_en_rclk1            : STD_LOGIC;
   SIGNAL txfifo_en                  : STD_LOGIC;
   
   SIGNAL soft_reset_local           : STD_LOGIC;
   SIGNAL soft_reset_wclk0           : STD_LOGIC;
   SIGNAL soft_reset_wclk1_b4scan    : STD_LOGIC;
   SIGNAL soft_reset_wclk1_wire      : STD_LOGIC;
   SIGNAL soft_reset_rclk0           : STD_LOGIC;
   SIGNAL soft_reset_rclk1_b4scan    : STD_LOGIC;
   SIGNAL soft_reset_rclk1_wire      : STD_LOGIC;
   SIGNAL data_out_temp              : STD_LOGIC_VECTOR(53 DOWNTO 0);
   
   SIGNAL pld_rd_dis0                : STD_LOGIC;
   SIGNAL pld_rd_dis1                : STD_LOGIC;
   SIGNAL pld_rd_dis2                : STD_LOGIC;
   SIGNAL pld_rd_dis_edge            : STD_LOGIC;
   
   -- PIPE electric idle bit
   
   -- register rd_enable_sync to fast clock domain. Necessary to send out low 
   -- byte first after soft_reset.
   SIGNAL rd_enable_sync_refclk_b_in : STD_LOGIC;
   
   -- PIPE command signals
   SIGNAL pipe_cmd                   : STD_LOGIC_VECTOR(4 DOWNTO 0);
   SIGNAL pipe_cmd_out               : STD_LOGIC_VECTOR(4 DOWNTO 0);
   
   SIGNAL rdwidth_or_auto            : STD_LOGIC;
   SIGNAL gen2ngen1_int              : STD_LOGIC;
   SIGNAL gen2ngen1_reg              : STD_LOGIC;
   SIGNAL gen2ngen1_sync              : STD_LOGIC;
   
   SIGNAL pipe_tx_trans              : STD_LOGIC_VECTOR(4 DOWNTO 0);		-- PIPE transmitter settings
   -- {txswing, txdeemph, txmargin}
   SIGNAL pipe_tx_trans_out          : STD_LOGIC_VECTOR(4 DOWNTO 0);
   -- X-HDL generated signals

   SIGNAL xhdl8 : STD_LOGIC;
   SIGNAL xhdl9 : STD_LOGIC;
   SIGNAL xhdl10 : STD_LOGIC;
   SIGNAL xhdl11 : STD_LOGIC;
   SIGNAL xhdl12 : STD_LOGIC;
   SIGNAL xhdl13 : STD_LOGIC;
   SIGNAL xhdl14 : STD_LOGIC;
   SIGNAL xhdl15 : STD_LOGIC;
   SIGNAL xhdl16 : STD_LOGIC;
   SIGNAL xhdl17 : STD_LOGIC;
   SIGNAL xhdl18 : STD_LOGIC;
   SIGNAL xhdl19 : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL xhdl20 : STD_LOGIC;
   SIGNAL xhdl21 : STD_LOGIC;
   SIGNAL xhdl22 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL rd_enable_sync_xhdl4       : STD_LOGIC;
   SIGNAL fifo_select_out_xhdl0      : STD_LOGIC;
   SIGNAL ph_fifo_full_xhdl2         : STD_LOGIC;
   SIGNAL ph_fifo_empty_xhdl1        : STD_LOGIC;
   SIGNAL wr_enable2_xhdl7           : STD_LOGIC;
   SIGNAL wptr_bin_xhdl6             : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL rd_enable2_xhdl3           : STD_LOGIC;
   SIGNAL rptr_bin_xhdl5             : STD_LOGIC_VECTOR(2 DOWNTO 0);
BEGIN
   -- Drive referenced outputs
   rd_enable_sync <= rd_enable_sync_xhdl4;
   fifo_select_out <= fifo_select_out_xhdl0;
   ph_fifo_full <= ph_fifo_full_xhdl2;
   ph_fifo_empty <= ph_fifo_empty_xhdl1;
   wr_enable2 <= wr_enable2_xhdl7;
   wptr_bin <= wptr_bin_xhdl6;
   rd_enable2 <= rd_enable2_xhdl3;
   rptr_bin <= rptr_bin_xhdl5;
   
   -- =============
   -- functionality
   -- =============
   soft_reset_wclk1 <= soft_reset_wclk1_wire;
   soft_reset_rclk1 <= soft_reset_rclk1_wire;
   txd_extend_int <= txd_extend WHEN (rforce_disp = '1') ELSE
                     "0000";
   
   -- GiGE Idle Detection, replaced in 8b10b encoder
   d21_5_eq_n_d(0) <= int2bit(((tx_ctl_tc_d(0) & tx_data_tc_d(7 DOWNTO 0)) /= "010110101"));
   d21_5_eq_n_d(1) <= int2bit(((tx_ctl_tc_d(1) & tx_data_tc_d(15 DOWNTO 8)) /= "010110101"));
   d2_2_eq_n_d(0) <= int2bit(((tx_ctl_tc_d(0) & tx_data_tc_d(7 DOWNTO 0)) /= "001000010"));
   d2_2_eq_n_d(1) <= int2bit(((tx_ctl_tc_d(1) & tx_data_tc_d(15 DOWNTO 8)) /= "001000010"));
   
   wr_enable_out <= wr_enable1;
   rd_enable_out <= rd_enable1;
   
   -- 2-17-04 BT: Tied the tx_data[9] to 1'b0 in selftest mode since it effects the 
   --             disparity input in the 8B/10B encoder
   tx_data(19 DOWNTO 0) <= rxd_lpbk(19 DOWNTO 0) WHEN (p_rlpbk = '1') ELSE
                           ('0' & tx_control_sg(1) & tx_data_sg(15 DOWNTO 8) & '0' & tx_control_sg(0) & tx_data_sg(7 DOWNTO 0)) WHEN (selftest_en = '1') ELSE
                           txd_redun(19 DOWNTO 0) WHEN (redund_ctl /= "0000") ELSE
                           txd(19 DOWNTO 0);
   
   -- enable 3G double-width BIST by mapping tx_data_sg[15:8] & tx_control_sg[1] to the 3rd symbol location
   tx_data(39 DOWNTO 20) <= rxd_lpbk(39 DOWNTO 20) WHEN (p_rlpbk = '1') ELSE
                            ('0' & tx_control_sg(3) & tx_data_sg(31 DOWNTO 24) & '0' & tx_control_sg(1) & tx_data_sg(15 DOWNTO 8)) WHEN (selftest_en = '1') ELSE
                            txd_redun(39 DOWNTO 20) WHEN (redund_ctl /= "0000") ELSE
                            txd(39 DOWNTO 20);
   
   txfifo_en <= NOT(txfifo_urst) WHEN (rtxfifo_urst_en = '1') ELSE
                '1';
   
   -- PIPE electric idle is on txd[10]
   --assign pipe_electric_idle = txd_extend_tc_d[0];
   
   soft_reset_local <= soft_reset OR (rtxfifo_urst_en AND txfifo_urst);
   
   -- PIPE cmd
   pipe_cmd <= (powerdown & txdetectrxloopback & revloopback & '0');
   
   revloopback_int <= pipe_cmd(1) WHEN (txfifo_dis = '1') ELSE
                      pipe_cmd_out(1);
   txdetectrxloopback_int <= pipe_cmd(2) WHEN (txfifo_dis = '1') ELSE
                             pipe_cmd_out(2);
   powerdown_int <= pipe_cmd(4 DOWNTO 3) WHEN (txfifo_dis = '1') ELSE
                    pipe_cmd_out(4 DOWNTO 3);
   
   rxpolarity_int <= rxpolarity;
   polinv_rx_int <= polinv_rx;
   
   gen2ngen1_int <= gen2ngen1 WHEN (rindv_tx = '1') ELSE
                    gen2ngen1_bundle;
   --//************************************
   --// Synchronization of gen2ngen1
   --//************************************
   PROCESS (soft_reset, refclk_b_in)
   BEGIN
	IF (soft_reset = '1') THEN
	     gen2ngen1_reg  <= '0';
	     gen2ngen1_sync <= '0';
	ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
	     gen2ngen1_reg <= gen2ngen1_int;
	     gen2ngen1_sync <= gen2ngen1_reg;
	END IF;
   END PROCESS; -- always @ (posedge soft_reset or posedge refclk_b_in)
                          
   rdwidth_or_auto <= (rdwidth_tx OR (rauto_speed_ena AND NOT(rfreq_sel) AND gen2ngen1_sync));
   
   pipe_tx_trans <= (txswing & txdeemph & txmargin);
   
   phfifo_txswing <= pipe_tx_trans(4) WHEN (txfifo_dis = '1') ELSE
                     pipe_tx_trans_out(4);
   phfifo_txdeemph <= pipe_tx_trans(3) WHEN (txfifo_dis = '1') ELSE
                      pipe_tx_trans_out(3);
   phfifo_txmargin <= pipe_tx_trans(2 DOWNTO 0) WHEN (txfifo_dis = '1') ELSE
                      pipe_tx_trans_out(2 DOWNTO 0);
   
   -- synchronize reset input (in refclk_b domain)
   PROCESS (soft_reset_local, fifo_wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_local = '1') THEN
         soft_reset_wclk0 <=  TRANSPORT '1' AFTER 1 ps;
         soft_reset_wclk1_b4scan <=  TRANSPORT '1' AFTER 1 ps;
      ELSIF (fifo_wr_clk'EVENT AND fifo_wr_clk = '1') THEN
         soft_reset_wclk0 <=  TRANSPORT '0' AFTER 1 ps;
         soft_reset_wclk1_b4scan <=  TRANSPORT soft_reset_wclk0 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_local or posedge fifo_wr_clk)
   
   soft_reset_wclk1_wire <= '0' WHEN (scan_mode = '1') ELSE
                            soft_reset_wclk1_b4scan;
   
   -- synchronize reset input (in refclk_b domain) and balance it with fifo_wr_clk reset
   PROCESS (soft_reset_local, fifo_rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_local = '1') THEN
         soft_reset_rclk0 <=  TRANSPORT '1' AFTER 1 ps;
         soft_reset_rclk1_b4scan <=  TRANSPORT '1' AFTER 1 ps;
      ELSIF (fifo_rd_clk'EVENT AND fifo_rd_clk = '1') THEN
         soft_reset_rclk0 <=  TRANSPORT '0' AFTER 1 ps;
         soft_reset_rclk1_b4scan <=  TRANSPORT soft_reset_rclk0 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_local or posedge fifo_rd_clk)
   
   soft_reset_rclk1_wire <= '0' WHEN (scan_mode = '1') ELSE
                            soft_reset_rclk1_b4scan;
   
   -- write enable
   --wr_enable0   <= txfifo_en;
   --wr_enable0   <= 1'b1;
   xhdl8 <= (wr_enable0p5 AND pld_we) WHEN (rtxphfifopldctl_en = '1') ELSE
                            wr_enable0p5;
   xhdl9 <= wr_enable1 WHEN (rindv_tx = '1') ELSE
                            wr_enable_centrl;
   xhdl10 <= wr_enable_quad_up WHEN (rmaster_up_tx = '1') ELSE
                            wr_enable_quad_down;
   xhdl11 <= (xhdl9) WHEN (rmaster_tx = '1') ELSE
                            (xhdl10);
   PROCESS (soft_reset_wclk1_wire, fifo_wr_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_wclk1_wire = '1') THEN
         wr_enable0 <=  TRANSPORT '0' AFTER 1 ps;
         wr_enable0p5 <=  TRANSPORT '0' AFTER 1 ps;
         wr_enable1 <=  TRANSPORT '0' AFTER 1 ps;
         wr_enable2_xhdl7 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (fifo_wr_clk'EVENT AND fifo_wr_clk = '1') THEN
         wr_enable0 <=  TRANSPORT NOT((rauto_speed_ena AND dis_pc_byte)) AFTER 1 ps;
         wr_enable0p5 <=  TRANSPORT wr_enable0 AFTER 1 ps;
         wr_enable1 <=  TRANSPORT xhdl8 AFTER 1 ps;
         wr_enable2_xhdl7 <=  TRANSPORT xhdl11 AFTER 1 ps;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_wclk1 or posedge fifo_wr_clk)
   
   din0 <= (pipe_tx_trans & pipe_cmd & txd_extend_int(3 DOWNTO 2) & tx_data(39 DOWNTO 20) & txd_extend_int(1 DOWNTO 0) & tx_data(19 DOWNTO 0));
   
   -- Instantiate new FIFO
   
   
   ph_fifo_tx_1 : stratixiv_hssi_tx_digis_ph_fifo
      PORT MAP (
         rst_wclk                 => soft_reset_wclk1_wire,
         rst_rclk                 => soft_reset_rclk1_wire,
         wr_clk                   => fifo_wr_clk,
         rd_clk                   => fifo_rd_clk,
         bypass_en                => txfifo_dis,
         --.en(1'b1),
         lowlatency_en            => rtxfifo_lowlatency_en,
         we                       => wr_enable2_xhdl7,
         re                       => rd_enable2_xhdl3,
         din                      => din0,
         data_out                 => data_out_temp,
         ph_fifo_full             => ph_fifo_full_xhdl2,
         ph_fifo_empty            => ph_fifo_empty_xhdl1,
         wptr_bin                 => wptr_bin_xhdl6,
         rptr_bin                 => rptr_bin_xhdl5,
         rphfifo_regmode_tx       => rphfifo_regmode_tx,
         rindv_tx                 => rindv_tx,
         rmaster_tx               => rmaster_tx,
         rmaster_up_tx            => rmaster_up_tx,
         rauto_speed_ena          => rauto_speed_ena,
         reset_pc_ptrs            => reset_pc_ptrs,
         reset_pc_ptrs_centrl     => reset_pc_ptrs_centrl,
         reset_pc_ptrs_quad_up    => reset_pc_ptrs_quad_up,
         reset_pc_ptrs_quad_down  => reset_pc_ptrs_quad_down
      );
   pipe_tx_trans_out <= data_out_temp(53 DOWNTO 49);
   pipe_cmd_out <= data_out_temp(48 DOWNTO 44);
   txd_extend_high <= data_out_temp(43 DOWNTO 42);
   fifo_data_out(39 DOWNTO 20) <= data_out_temp(41 DOWNTO 22);
   txd_extend_low <= data_out_temp(21 DOWNTO 20);
   fifo_data_out(19 DOWNTO 0) <= data_out_temp(19 DOWNTO 0);
   
   -- Modified Byte Serializer logic to use fifo_select_out to ping-pong between 
   -- low and high banks of FIFO during normal mode
   -- Toggle between {19,9} and {39,29} when DWIDTH is set, else fixed to {19,9}
   tx_data_9_tc_d <= (fifo_data_out(19) & fifo_data_out(9)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (NOT(rdwidth_or_auto) OR fifo_select_out_xhdl0) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                     (fifo_data_out(39) & fifo_data_out(29)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                     (tx_data(19) & tx_data(9)) WHEN ((txfifo_dis AND (NOT(rdwidth_or_auto) OR NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                     tx_data_9_tc_d_others;
   
   tx_data_9_tc_d_others <= "00" WHEN ((NOT(rforce_kchar) AND rforce_echar) = '1') ELSE
                            (tx_data_lt(19) & tx_data_lt(9)) WHEN ((txfifo_dis AND rdwidth_or_auto AND fifo_select_out_xhdl0 AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                            "00";
   
   -- 8th bit in each word. Toggle between {18,8} and {38,28} when DWIDTH is set, else fixed to {18,8}
   tx_ctl_tc_d <= (fifo_data_out(18) & fifo_data_out(8)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (NOT(rdwidth_or_auto) OR fifo_select_out_xhdl0) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                  (fifo_data_out(38) & fifo_data_out(28)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                  (tx_data(18) & tx_data(8)) WHEN ((txfifo_dis AND (NOT(rdwidth_or_auto) OR NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                  tx_ctl_tc_d_others;
   
   -- When transmitting Error(FE) or bypassing FIFO, transmit 11 in the former case and transmit bypassed data/ctl in the latter
   tx_ctl_tc_d_others <= "11" WHEN ((NOT(rforce_kchar) AND rforce_echar) = '1') ELSE
                         (tx_data_lt(18) & tx_data_lt(8)) WHEN ((txfifo_dis AND rdwidth_or_auto AND fifo_select_out_xhdl0 AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                         "11";
   
   -- After rd_enable_sync goes high, start transmitting. Initially, fifo_select_out is zero, so MSByte transmitted first.
   -- Transmit data if not forced Error or K-char.
   txd_extend_tc_d <= txd_data_extend_tmp(17 DOWNTO 16);
   tx_data_tc_d <= txd_data_extend_tmp(15 DOWNTO 0);
   txd_data_extend_tmp <= (txd_extend_low & fifo_data_out(17 DOWNTO 10) & fifo_data_out(7 DOWNTO 0)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (NOT(rdwidth_or_auto) OR fifo_select_out_xhdl0) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          (txd_extend_high & fifo_data_out(37 DOWNTO 30) & fifo_data_out(27 DOWNTO 20)) WHEN ((NOT(txfifo_dis) AND rd_enable_sync_xhdl4 AND (rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          (txd_extend_int(1 DOWNTO 0) & tx_data(17 DOWNTO 10) & tx_data(7 DOWNTO 0)) WHEN ((txfifo_dis AND (NOT(rdwidth_or_auto) OR NOT(fifo_select_out_xhdl0)) AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          tx_data_tc_d_others;
   
   -- When transmitting Error(FE) or bypassing FIFO, transmit FE in the former case and transmit bypassed data/ctl in the latter
   tx_data_tc_d_others <= ("00" & "11111110" & "11111110") WHEN ((NOT(rforce_kchar) AND rforce_echar) = '1') ELSE
                          (txd_extend_int(3 DOWNTO 2) & tx_data_lt(17 DOWNTO 10) & tx_data_lt(7 DOWNTO 0)) WHEN ((txfifo_dis AND rdwidth_or_auto AND fifo_select_out_xhdl0 AND NOT(rforce_kchar) AND NOT(rforce_echar)) = '1') ELSE
                          ("00" & "00000111" & "00000111") WHEN ((NOT(rindv_tx)) = '1') ELSE
                          ("00" & "10111100" & "10111100");
   
   -- read enable & 
   -- read enable sync (for byte serializer output enable)
   
   --rd_enable0   <= txfifo_en;
   -- rd_enable0   <= 1'b1;
   xhdl12 <= (rd_enable0p5 AND NOT(pld_rd_dis_edge)) WHEN (rtxphfifopldctl_en = '1') ELSE
                          rd_enable0p5;
   xhdl13 <= rd_enable1 WHEN (rindv_tx = '1') ELSE
                          rd_enable_centrl;
   xhdl14 <= rd_enable_quad_up WHEN (rmaster_up_tx = '1') ELSE
                          rd_enable_quad_down;
   xhdl15 <= (xhdl13) WHEN (rmaster_tx = '1') ELSE
                          (xhdl14);
   
   --txfifo_en_rclk0 <= txfifo_en;
   
   -- start with valid data, so rd_enable_sync serves as dout valid
   -- ideally should be "rptr_bin == 3'd7", 
   -- but fifo_data_out is registered (1 clk delay). rd_enable_sync is
   -- used in high/low byte selection enable
   xhdl16 <= rd_enable1 WHEN (rindv_tx = '1') ELSE
                          rd_enable_centrl;
   xhdl17 <= rd_enable_quad_up WHEN (rmaster_up_tx = '1') ELSE
                          rd_enable_quad_down;
   xhdl18 <= (xhdl16) WHEN (rmaster_tx = '1') ELSE
                          (xhdl17);
   PROCESS (soft_reset_rclk1_wire, fifo_rd_clk)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_rclk1_wire = '1') THEN
         pld_rd_dis0 <=  TRANSPORT '0' AFTER 1 ps;
         pld_rd_dis1 <=  TRANSPORT '0' AFTER 1 ps;
         pld_rd_dis2 <=  TRANSPORT '0' AFTER 1 ps;
         pld_rd_dis_edge <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable0 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable0p5 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable1 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable2_xhdl3 <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_rclk0 <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_rclk1 <=  TRANSPORT '0' AFTER 1 ps;
         rd_enable_sync_xhdl4 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (fifo_rd_clk'EVENT AND fifo_rd_clk = '1') THEN
         pld_rd_dis0 <=  TRANSPORT pld_rd_dis AFTER 1 ps;
         pld_rd_dis1 <=  TRANSPORT pld_rd_dis0 AFTER 1 ps;
         pld_rd_dis2 <=  TRANSPORT pld_rd_dis1 AFTER 1 ps;
         pld_rd_dis_edge <=  TRANSPORT int2bit((pld_rd_dis2 /= pld_rd_dis1)) AFTER 1 ps;
         rd_enable0 <=  TRANSPORT NOT((rauto_speed_ena AND dis_pc_byte)) AFTER 1 ps;
         rd_enable0p5 <=  TRANSPORT rd_enable0 AFTER 1 ps;
         rd_enable1 <=  TRANSPORT xhdl12 AFTER 1 ps;
         rd_enable2_xhdl3 <=  TRANSPORT xhdl15 AFTER 1 ps;
         txfifo_en_rclk0 <=  TRANSPORT '1' AFTER 1 ps;
         txfifo_en_rclk1 <=  TRANSPORT txfifo_en_rclk0 AFTER 1 ps;
         IF (rphfifo_regmode_tx = '1') THEN
            rd_enable_sync_xhdl4 <=  TRANSPORT '1' AFTER 1 ps;
         ELSIF (rd_enable_sync_xhdl4 = '0' AND rptr_bin_xhdl5 = "000") THEN
            rd_enable_sync_xhdl4 <=  TRANSPORT xhdl18 AFTER 1 ps;
         ELSIF (txfifo_en_rclk1 = '0') THEN
            rd_enable_sync_xhdl4 <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset_rclk1 or posedge fifo_rd_clk)
   
   
   -- PIPE enabled, txd[21] & txd[10] are used as PIPE electric idle
   -- hence in PIPE mode, txd[21] & txd[10](crd_enforce_value) are forced to txd[20] & txd[9] 
   -- (crd_enforce_enable) to have crd negative enable.
   -- crd positive enable is not provided in PIPE mode
   xhdl19 <= (txd_extend_tc_d(1) & tx_data_9_tc_d(0)) WHEN (rtx_pipe_enable = '1') ELSE
                           txd_extend_tc_d;
   PROCESS (soft_reset, refclk_b_in)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset = '1') THEN
         tx_data_9_tc_mux <=  TRANSPORT "00" AFTER 1 ps;
         tx_ctl_tc_mux <=  TRANSPORT "00" AFTER 1 ps;
         tx_data_tc_mux <=  TRANSPORT "0000000000000000" AFTER 1 ps;
         txd_extend_tc_mux <=  TRANSPORT "00" AFTER 1 ps;
         tx_data_lt <=  TRANSPORT "00000000000000000000" AFTER 1 ps;
         d21_5_eq_n <=  TRANSPORT "11" AFTER 1 ps;
         d2_2_eq_n <=  TRANSPORT "11" AFTER 1 ps;
         k_det_sync1 <=  TRANSPORT "00" AFTER 1 ps;
         k_det <=  TRANSPORT "00" AFTER 1 ps;
         pipe_electric_idle <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
         tx_data_9_tc_mux <=  TRANSPORT tx_data_9_tc_d AFTER 1 ps;
         tx_ctl_tc_mux <=  TRANSPORT tx_ctl_tc_d AFTER 1 ps;
         tx_data_tc_mux <=  TRANSPORT tx_data_tc_d AFTER 1 ps;
         txd_extend_tc_mux <=  TRANSPORT xhdl19 AFTER 1 ps;
         
         pipe_electric_idle <=  TRANSPORT txd_extend_tc_d(0) AFTER 1 ps;
         d21_5_eq_n <=  TRANSPORT d21_5_eq_n_d AFTER 1 ps;
         d2_2_eq_n <=  TRANSPORT d2_2_eq_n_d AFTER 1 ps;
         
         k_det <=  TRANSPORT k_det_sync1 AFTER 1 ps;
         IF ((rdwidth_or_auto AND NOT(fifo_select_out_xhdl0)) = '1') THEN
            
            tx_data_lt <=  TRANSPORT tx_data(39 DOWNTO 20) AFTER 1 ps;
         END IF;
         IF (((tx_ctl_tc_d(0)) & (tx_data_tc_d(7 DOWNTO 0))) = "110111100") THEN
            k_det_sync1(0) <=  TRANSPORT '1' AFTER 1 ps;
         ELSE
            
            k_det_sync1(0) <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
         IF (((tx_ctl_tc_d(1)) & (tx_data_tc_d(15 DOWNTO 8))) = "110111100") THEN
            k_det_sync1(1) <=  TRANSPORT '1' AFTER 1 ps;
         ELSE
            k_det_sync1(1) <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset or posedge refclk_b_in)
   
   -- byte serializer high/low select
   --txfifo_en_refclk0 <= txfifo_en;
   -- txfifo_en_refclk0 <= 1'b1;
   
   -- was ~fifo_select_in, it allows 1 cycle to send the signal across x4, x8 channels
   xhdl20 <= NOT(fifo_select_out_xhdl0) WHEN (rindv_tx = '1') ELSE
                     NOT(fifo_select_in_centrl);
   xhdl21 <= NOT(fifo_select_in_quad_up) WHEN (rmaster_up_tx = '1') ELSE
                     NOT(fifo_select_in_quad_down);
   xhdl22 <= (xhdl20) WHEN (rmaster_tx = '1') ELSE
                     (xhdl21);
   PROCESS (soft_reset, refclk_b_in)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset = '1') THEN
         rd_enable_sync_refclk_b_in <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_refclk0 <=  TRANSPORT '0' AFTER 1 ps;
         txfifo_en_refclk1 <=  TRANSPORT '0' AFTER 1 ps;
         fifo_select_out_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;
      ELSIF (refclk_b_in'EVENT AND refclk_b_in = '1') THEN
         txfifo_en_refclk0 <=  TRANSPORT NOT((rauto_speed_ena AND dis_pc_byte)) AFTER 1 ps;
         txfifo_en_refclk1 <=  TRANSPORT txfifo_en_refclk0 AFTER 1 ps;
         IF (txfifo_en_refclk1 = '0') THEN
            rd_enable_sync_refclk_b_in <=  TRANSPORT '0' AFTER 1 ps;
         ELSIF (rd_enable_sync_refclk_b_in = '0') THEN
            rd_enable_sync_refclk_b_in <=  TRANSPORT rd_enable2_xhdl3 AFTER 1 ps;
         END IF;
         IF (rd_enable_sync_refclk_b_in = '1') THEN
            fifo_select_out_xhdl0 <=  TRANSPORT xhdl22 AFTER 1 ps;
         ELSE
            fifo_select_out_xhdl0 <=  TRANSPORT '0' AFTER 1 ps;
         END IF;
      END IF;
   END PROCESS;
   
   -- always @ (posedge soft_reset or posedge refclk_b_in)
   
   tx_data_9_tc <= tx_data_9_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                   tx_data_9_tc_mux;
   tx_ctl_tc <= tx_ctl_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                tx_ctl_tc_mux;
   tx_data_tc <= tx_data_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                 tx_data_tc_mux;
   txd_extend_tc <= txd_extend_tc_d WHEN ((rtxpcsbypass_en AND (NOT(rdwidth_or_auto))) = '1') ELSE
                    txd_extend_tc_mux;
   
   -- LMC bin to gray for eidlinfersel
   
   PROCESS (fifo_wr_clk, soft_reset_wclk1_wire)
VARIABLE  txt : LINE;
   BEGIN
      IF (soft_reset_wclk1_wire = '1') THEN
         gray_eidleinfersel <= "000";
      ELSIF (fifo_wr_clk'EVENT AND fifo_wr_clk = '1') THEN
         CASE eidleinfersel IS
            WHEN "000" =>
               gray_eidleinfersel <= "000";
            WHEN "001" =>
               gray_eidleinfersel <= "001";
            WHEN "010" =>
               gray_eidleinfersel <= "011";
            WHEN "011" =>
               gray_eidleinfersel <= "010";
            WHEN "100" =>
               gray_eidleinfersel <= "110";
            WHEN "101" =>
               gray_eidleinfersel <= "111";
            WHEN "110" =>
               gray_eidleinfersel <= "101";
            WHEN "111" =>
               gray_eidleinfersel <= "100";
            WHEN OTHERS =>
               gray_eidleinfersel <= "000";
         END CASE;
      END IF;
   END PROCESS;
   
   
END trans;



-- tx_ctrl--IP Functional Simulation Model
--VERSION_BEGIN 10.1 cbx_mgl 2010:11:29:21:24:23:SJ cbx_simgen 2010:11:29:21:22:45:SJ  VERSION_END


-- Copyright (C) 1991-2010 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- You may only use these simulation model output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event Altera disclaims all warranties of any kind).


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 211 mux21 446 oper_add 10 oper_selector 88 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiv_hssi_tx_digi_bist_gen IS 
	 PORT 
	 ( 
		 bist_ctl_sg	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 bist_data_sg	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 rbist_sel	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rbisten_tx	:	IN  STD_LOGIC;
		 rcxpat_chnl_sel	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rdwidth_tx	:	IN  STD_LOGIC;
		 rpma_doublewidth_tx	:	IN  STD_LOGIC;
		 rpmadwidth_tx	:	IN  STD_LOGIC;
		 soft_reset	:	IN  STD_LOGIC;
		 tx_clk	:	IN  STD_LOGIC
	 ); 
 END stratixiv_hssi_tx_digi_bist_gen;

 ARCHITECTURE RTL OF stratixiv_hssi_tx_digi_bist_gen IS

	 ATTRIBUTE synthesis_clearbox : natural;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS 1;
	 SIGNAL	 ni001l45	:	STD_LOGIC := '0';
	 SIGNAL	 ni001l46	:	STD_LOGIC := '0';
	 SIGNAL	 nii00O39	:	STD_LOGIC := '0';
	 SIGNAL	 nii00O40	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii00O40_w_lg_w_lg_q228w230w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii00O40_w_lg_q228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii01O41	:	STD_LOGIC := '0';
	 SIGNAL	 nii01O42	:	STD_LOGIC := '0';
	 SIGNAL	 nii0il37	:	STD_LOGIC := '0';
	 SIGNAL	 nii0il38	:	STD_LOGIC := '0';
	 SIGNAL	 nii0li35	:	STD_LOGIC := '0';
	 SIGNAL	 nii0li36	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii0li36_w_lg_w_lg_q207w208w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0li36_w_lg_q207w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii0lO33	:	STD_LOGIC := '0';
	 SIGNAL	 nii0lO34	:	STD_LOGIC := '0';
	 SIGNAL	 nii0OO31	:	STD_LOGIC := '0';
	 SIGNAL	 nii0OO32	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii0OO32_w_lg_w_lg_q155w156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0OO32_w_lg_q155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nii1OO43	:	STD_LOGIC := '0';
	 SIGNAL	 nii1OO44	:	STD_LOGIC := '0';
	 SIGNAL  wire_nii1OO44_w_lg_w_lg_q295w296w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii1OO44_w_lg_q295w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii0i23	:	STD_LOGIC := '0';
	 SIGNAL	 niii0i24	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii0i24_w_lg_w_lg_q129w130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii0i24_w_lg_q129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii0O21	:	STD_LOGIC := '0';
	 SIGNAL	 niii0O22	:	STD_LOGIC := '0';
	 SIGNAL	 niii1i29	:	STD_LOGIC := '0';
	 SIGNAL	 niii1i30	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii1i30_w_lg_w_lg_q152w153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii1i30_w_lg_q152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii1l27	:	STD_LOGIC := '0';
	 SIGNAL	 niii1l28	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii1l28_w_lg_w_lg_q141w142w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii1l28_w_lg_q141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niii1O25	:	STD_LOGIC := '0';
	 SIGNAL	 niii1O26	:	STD_LOGIC := '0';
	 SIGNAL  wire_niii1O26_w_lg_w_lg_q132w133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii1O26_w_lg_q132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niillO19	:	STD_LOGIC := '0';
	 SIGNAL	 niillO20	:	STD_LOGIC := '0';
	 SIGNAL	 niilOi17	:	STD_LOGIC := '0';
	 SIGNAL	 niilOi18	:	STD_LOGIC := '0';
	 SIGNAL	 niilOO15	:	STD_LOGIC := '0';
	 SIGNAL	 niilOO16	:	STD_LOGIC := '0';
	 SIGNAL  wire_niilOO16_w_lg_w_lg_q78w79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niilOO16_w_lg_q78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niiO0i10	:	STD_LOGIC := '0';
	 SIGNAL	 niiO0i9	:	STD_LOGIC := '0';
	 SIGNAL	 niiO0O7	:	STD_LOGIC := '0';
	 SIGNAL	 niiO0O8	:	STD_LOGIC := '0';
	 SIGNAL	 niiO1i13	:	STD_LOGIC := '0';
	 SIGNAL	 niiO1i14	:	STD_LOGIC := '0';
	 SIGNAL  wire_niiO1i14_w_lg_w_lg_q53w54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO1i14_w_lg_q53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niiO1l11	:	STD_LOGIC := '0';
	 SIGNAL	 niiO1l12	:	STD_LOGIC := '0';
	 SIGNAL	 niiOll5	:	STD_LOGIC := '0';
	 SIGNAL	 niiOll6	:	STD_LOGIC := '0';
	 SIGNAL	 niiOOl3	:	STD_LOGIC := '0';
	 SIGNAL	 niiOOl4	:	STD_LOGIC := '0';
	 SIGNAL	 nil11i1	:	STD_LOGIC := '0';
	 SIGNAL	 nil11i2	:	STD_LOGIC := '0';
	 SIGNAL  wire_nil11i2_w_lg_q4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n100i	:	STD_LOGIC := '0';
	 SIGNAL	n100l	:	STD_LOGIC := '0';
	 SIGNAL	n100O	:	STD_LOGIC := '0';
	 SIGNAL	n101i	:	STD_LOGIC := '0';
	 SIGNAL	n101l	:	STD_LOGIC := '0';
	 SIGNAL	n101O	:	STD_LOGIC := '0';
	 SIGNAL	n10ii	:	STD_LOGIC := '0';
	 SIGNAL	n10il	:	STD_LOGIC := '0';
	 SIGNAL	n10iO	:	STD_LOGIC := '0';
	 SIGNAL	n10li	:	STD_LOGIC := '0';
	 SIGNAL	n10ll	:	STD_LOGIC := '0';
	 SIGNAL	n10lO	:	STD_LOGIC := '0';
	 SIGNAL	n10Oi	:	STD_LOGIC := '0';
	 SIGNAL	n10Ol	:	STD_LOGIC := '0';
	 SIGNAL	n10OO	:	STD_LOGIC := '0';
	 SIGNAL	n110i	:	STD_LOGIC := '0';
	 SIGNAL	n110l	:	STD_LOGIC := '0';
	 SIGNAL	n110O	:	STD_LOGIC := '0';
	 SIGNAL	n111i	:	STD_LOGIC := '0';
	 SIGNAL	n111l	:	STD_LOGIC := '0';
	 SIGNAL	n111O	:	STD_LOGIC := '0';
	 SIGNAL	n11ii	:	STD_LOGIC := '0';
	 SIGNAL	n11il	:	STD_LOGIC := '0';
	 SIGNAL	n11iO	:	STD_LOGIC := '0';
	 SIGNAL	n11li	:	STD_LOGIC := '0';
	 SIGNAL	n11ll	:	STD_LOGIC := '0';
	 SIGNAL	n11lO	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol	:	STD_LOGIC := '0';
	 SIGNAL	n11OO	:	STD_LOGIC := '0';
	 SIGNAL	n1i0i	:	STD_LOGIC := '0';
	 SIGNAL	n1i0l	:	STD_LOGIC := '0';
	 SIGNAL	n1i0O	:	STD_LOGIC := '0';
	 SIGNAL	n1i1i	:	STD_LOGIC := '0';
	 SIGNAL	n1i1l	:	STD_LOGIC := '0';
	 SIGNAL	n1i1O	:	STD_LOGIC := '0';
	 SIGNAL	n1iii	:	STD_LOGIC := '0';
	 SIGNAL	n1iil	:	STD_LOGIC := '0';
	 SIGNAL	n1iiO	:	STD_LOGIC := '0';
	 SIGNAL	n1ili	:	STD_LOGIC := '0';
	 SIGNAL	n1ill	:	STD_LOGIC := '0';
	 SIGNAL	n1ilO	:	STD_LOGIC := '0';
	 SIGNAL	n1iOi	:	STD_LOGIC := '0';
	 SIGNAL	n1iOl	:	STD_LOGIC := '0';
	 SIGNAL	n1iOO	:	STD_LOGIC := '0';
	 SIGNAL	n1l0i	:	STD_LOGIC := '0';
	 SIGNAL	n1l0l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1i	:	STD_LOGIC := '0';
	 SIGNAL	n1l1l	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O	:	STD_LOGIC := '0';
	 SIGNAL	n1lii	:	STD_LOGIC := '0';
	 SIGNAL	nliliO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOil	:	STD_LOGIC := '0';
	 SIGNAL	nlOOiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOli	:	STD_LOGIC := '0';
	 SIGNAL	nlOOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w1510w1511w1512w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w1501w1502w1503w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w1510w1511w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w1501w1502w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w1510w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w1501w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1506w1507w1508w1509w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1480w1497w1499w1500w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n11ii897w899w900w901w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n101i1506w1507w1508w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n11ii902w903w904w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1497w1499w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n101i1506w1507w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n11ii902w903w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n101i1480w1482w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n101i1480w1497w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n11ii897w899w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_nlOOiO1476w1543w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_nlOOOO1529w1530w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n101i1506w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11ii902w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOO1538w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n101i1480w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n110i1516w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n110O898w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n111O1524w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11ii897w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11il1494w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11iO1492w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11li1490w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11ll1488w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11lO1486w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11Oi1484w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11Ol1498w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n11OO1481w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nliliO1544w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOil1477w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOiO1476w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOlO1533w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOi1531w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOl1537w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_nlOOOO1529w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_w_lg_n1ill1401w1402w1403w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_w_lg_n1ill1401w1402w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n1ill1401w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l0O_w_lg_n1l0i1211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1liO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n1lil_w_lg_w_lg_w_lg_n1liO1051w1092w1093w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lil_w_lg_w_lg_n1liO1051w1092w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1lil_w_lg_n1liO1051w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nl00il	:	STD_LOGIC := '0';
	 SIGNAL	nl00iO	:	STD_LOGIC := '0';
	 SIGNAL	nl00li	:	STD_LOGIC := '0';
	 SIGNAL	nl00ll	:	STD_LOGIC := '0';
	 SIGNAL	nl00lO	:	STD_LOGIC := '0';
	 SIGNAL	nl00Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl00Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl00OO	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0i0O	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1i	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1l	:	STD_LOGIC := '0';
	 SIGNAL	nl0i1O	:	STD_LOGIC := '0';
	 SIGNAL	nl0iii	:	STD_LOGIC := '0';
	 SIGNAL	nl0iil	:	STD_LOGIC := '0';
	 SIGNAL	nl0iiO	:	STD_LOGIC := '0';
	 SIGNAL	nl0ili	:	STD_LOGIC := '0';
	 SIGNAL	nl0ill	:	STD_LOGIC := '0';
	 SIGNAL	nl0ilO	:	STD_LOGIC := '0';
	 SIGNAL	nl0iOi	:	STD_LOGIC := '0';
	 SIGNAL	nl0iOl	:	STD_LOGIC := '0';
	 SIGNAL	nl0iOO	:	STD_LOGIC := '0';
	 SIGNAL	nl0l0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0l0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0l0O	:	STD_LOGIC := '0';
	 SIGNAL	nl0l1i	:	STD_LOGIC := '0';
	 SIGNAL	nl0l1l	:	STD_LOGIC := '0';
	 SIGNAL	nl0l1O	:	STD_LOGIC := '0';
	 SIGNAL	nl0lii	:	STD_LOGIC := '0';
	 SIGNAL	nl0lil	:	STD_LOGIC := '0';
	 SIGNAL	nl0liO	:	STD_LOGIC := '0';
	 SIGNAL	nl0lli	:	STD_LOGIC := '0';
	 SIGNAL	nl0lll	:	STD_LOGIC := '0';
	 SIGNAL	nl0llO	:	STD_LOGIC := '0';
	 SIGNAL	nl0lOi	:	STD_LOGIC := '0';
	 SIGNAL	nl0lOl	:	STD_LOGIC := '0';
	 SIGNAL	nl0lOO	:	STD_LOGIC := '0';
	 SIGNAL	nl0O0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0O0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0O0O	:	STD_LOGIC := '0';
	 SIGNAL	nl0O1i	:	STD_LOGIC := '0';
	 SIGNAL	nl0O1l	:	STD_LOGIC := '0';
	 SIGNAL	nl0O1O	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oii	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oil	:	STD_LOGIC := '0';
	 SIGNAL	nl0OiO	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oli	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oll	:	STD_LOGIC := '0';
	 SIGNAL	nl0OlO	:	STD_LOGIC := '0';
	 SIGNAL	nl0OOi	:	STD_LOGIC := '0';
	 SIGNAL	nl0OOl	:	STD_LOGIC := '0';
	 SIGNAL	nli11i	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl0OOO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nl0OOO_w_lg_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w2253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_w_lg_nl0iOl2241w2243w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iii2259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iil2257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iiO2255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0ili2248w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0ill2246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0ilO2244w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iOi2242w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0iOl2241w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0O0l2201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0OOO_w_lg_nl0O0l2215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nli11O	:	STD_LOGIC := '0';
	 SIGNAL  wire_nli11l_w_lg_nli11O2169w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0lOi	:	STD_LOGIC := '0';
	 SIGNAL	niO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO0O	:	STD_LOGIC := '0';
	 SIGNAL	niOii	:	STD_LOGIC := '0';
	 SIGNAL	niOil	:	STD_LOGIC := '0';
	 SIGNAL	niOiO	:	STD_LOGIC := '0';
	 SIGNAL	niOli	:	STD_LOGIC := '0';
	 SIGNAL	niOll	:	STD_LOGIC := '0';
	 SIGNAL	niOlO	:	STD_LOGIC := '0';
	 SIGNAL	niOOi	:	STD_LOGIC := '0';
	 SIGNAL	niOOl	:	STD_LOGIC := '0';
	 SIGNAL	niOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl00i	:	STD_LOGIC := '0';
	 SIGNAL	nl00l	:	STD_LOGIC := '0';
	 SIGNAL	nl00O	:	STD_LOGIC := '0';
	 SIGNAL	nl01i	:	STD_LOGIC := '0';
	 SIGNAL	nl01l	:	STD_LOGIC := '0';
	 SIGNAL	nl01O	:	STD_LOGIC := '0';
	 SIGNAL	nl0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl0il	:	STD_LOGIC := '0';
	 SIGNAL	nl0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl0li	:	STD_LOGIC := '0';
	 SIGNAL	nl0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11i	:	STD_LOGIC := '0';
	 SIGNAL	nl11l	:	STD_LOGIC := '0';
	 SIGNAL	nl11O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1OO	:	STD_LOGIC := '0';
	 SIGNAL	nli0i	:	STD_LOGIC := '0';
	 SIGNAL	nli0l	:	STD_LOGIC := '0';
	 SIGNAL	nli0O	:	STD_LOGIC := '0';
	 SIGNAL	nli1i	:	STD_LOGIC := '0';
	 SIGNAL	nli1l	:	STD_LOGIC := '0';
	 SIGNAL	nli1O	:	STD_LOGIC := '0';
	 SIGNAL	nliil	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_niOll766w767w768w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niOll766w767w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_niO0O762w771w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOll766w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_n0lOi772w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niO0l763w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niO0O762w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_niOii769w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_w_lg_nl00O654w655w656w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_w_lg_nl00O654w655w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliii_w_lg_nl00O654w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlili	:	STD_LOGIC := '0';
	 SIGNAL	wire_nliiO_CLRN	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_PRN	:	STD_LOGIC;
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w199w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w194w195w196w197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w120w121w122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w194w195w196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w120w121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w194w195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w223w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w261w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w222w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w256w257w258w259w260w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w217w218w219w220w221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w114w115w116w117w118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w256w257w258w259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w217w218w219w220w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w114w115w116w117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w188w189w190w191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w256w257w258w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w217w218w219w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w114w115w116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w188w189w190w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w256w257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w217w218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w114w115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w188w189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w217w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w188w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w216w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w214w215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w110w111w112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w214w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili109w110w111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_nlili160w161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_nlili109w110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_w_lg_nlili109w184w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_nlili160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nliiO_w_lg_nlili109w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO_w_lg_dataout1647w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00Oi_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n00Oi_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_n00Oi_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01iO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n01iO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n01iO_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1lOi_a	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1lOi_b	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1lOi_o	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Oll_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n1Oll_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n1Oll_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n1OOO_a	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OOO_b	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OOO_o	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nli0ll_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0ll_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0ll_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0lO_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0lO_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0lO_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nli0Oi_a	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0Oi_b	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nli0Oi_o	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nliOl_a	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOl_b	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOl_o	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllli_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nllli_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nllli_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iil_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iiO_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0iiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iiO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0ilO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0ilO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ilO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0iOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0iOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0l1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0l1i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0l1O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0l1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l1O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0lii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lil_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0liO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0liO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0liO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lli_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lli_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lli_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O0l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0O0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0O1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0O1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oil_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Oil_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oll_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0Oll_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Oll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0OOl_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n0OOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0OOl_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni00l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni00l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni00l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni01i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01O_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01O_o	:	STD_LOGIC;
	 SIGNAL  wire_ni01O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ii_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ii_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0ii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0iO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0iO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ll_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0ll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_data	:	STD_LOGIC_VECTOR (9 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oi_sel	:	STD_LOGIC_VECTOR (9 DOWNTO 0);
	 SIGNAL  wire_ni10i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni10i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni10i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni11l_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni11l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni11l_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni1Ol_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni1Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1Ol_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nil00l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil00l_o	:	STD_LOGIC;
	 SIGNAL  wire_nil00l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil01O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nil01O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil0il_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0il_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0il_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0li_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0li_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0li_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nil0Oi_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nil0Oi_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1li_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nil1li_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1li_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nil1lO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1lO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1OO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nil1OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nil1OO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili0i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nili0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nili0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nili0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nili0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nili1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nili1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nili1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_niliil_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niliil_o	:	STD_LOGIC;
	 SIGNAL  wire_niliil_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nilili_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nilili_o	:	STD_LOGIC;
	 SIGNAL  wire_nilili_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nililO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nililO_o	:	STD_LOGIC;
	 SIGNAL  wire_nililO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niliOl_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niliOl_o	:	STD_LOGIC;
	 SIGNAL  wire_niliOl_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nill0O_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nill0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nill0O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nill1i_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nill1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nill1i_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nill1O_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nill1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nill1O_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nillil_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nillil_o	:	STD_LOGIC;
	 SIGNAL  wire_nillil_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nillli_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nillli_o	:	STD_LOGIC;
	 SIGNAL  wire_nillli_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilllO_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilllO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilllO_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nillOl_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nillOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nillOl_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilO0l_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO0l_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO1i_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO1i_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilO1O_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nilO1O_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOii_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOii_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOii_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOiO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOiO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOiO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOli_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOli_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nilOlO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOlO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nilOOl_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nilOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOOl_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_niO11i_data	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_niO11i_o	:	STD_LOGIC;
	 SIGNAL  wire_niO11i_sel	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_nlilOi_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nlilOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlilOi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nliO0l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nliO0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO1i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nliO1i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nliO1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nliO1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliOii_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nliOli_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOli_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOlO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOlO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOi_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll00O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll00O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll00O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll01i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll01i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll01i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll01O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll01O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0iO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0iO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0lO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0lO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0OO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll0OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nll0OO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll10i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll10i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll10i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll10O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll10O_o	:	STD_LOGIC;
	 SIGNAL  wire_nll10O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll11l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll11l_o	:	STD_LOGIC;
	 SIGNAL  wire_nll11l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1il_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nll1il_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1il_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nll1ll_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1ll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1Ol_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nll1Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1Ol_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlli0i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlli0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlli0i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlliil_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliil_o	:	STD_LOGIC;
	 SIGNAL  wire_nlliil_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllili_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllili_o	:	STD_LOGIC;
	 SIGNAL  wire_nllili_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllilO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nllilO_o	:	STD_LOGIC;
	 SIGNAL  wire_nllilO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOi_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlliOi_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlliOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlliOO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll0i_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlll0i_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll0O_data	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_nlll0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlll0O_sel	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_nlll1l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlll1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlll1l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_rpmadwidth_tx2w5w6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rpmadwidth_tx2w5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rpmadwidth_tx2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rbist_sel_range12w20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rcxpat_chnl_sel_range755w760w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni000l1442w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOi1037w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOl1019w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0iOO996w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l0l913w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l0O912w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1i983w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1l970w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0l1O957w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lii914w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lil911w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0liO910w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lll909w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0llO908w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0lOl907w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O0i894w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O0O893w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O1i896w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0O1l895w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0Oii1237w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0Oil891w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0OiO892w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0Oli906w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0OOi889w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni0OOl888w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni1lll2233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni1Oil2081w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii00l246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii01i291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii01l267w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii0ii229w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii0ll204w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii0Ol176w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii11i695w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nii1Ol312w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiil107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiiO106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiili108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiill105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiilO447w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiOi102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiOl103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiiOO104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niil0l99w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niil0O98w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niil1O100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niilii97w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niilil96w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiliO95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiOOi445w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rpma_doublewidth_tx1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rbist_sel_range14w15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rcxpat_chnl_sel_range757w758w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  ni000i :	STD_LOGIC;
	 SIGNAL  ni000l :	STD_LOGIC;
	 SIGNAL  ni000O :	STD_LOGIC;
	 SIGNAL  ni001i :	STD_LOGIC;
	 SIGNAL  ni001O :	STD_LOGIC;
	 SIGNAL  ni00ii :	STD_LOGIC;
	 SIGNAL  ni00il :	STD_LOGIC;
	 SIGNAL  ni00iO :	STD_LOGIC;
	 SIGNAL  ni00li :	STD_LOGIC;
	 SIGNAL  ni00ll :	STD_LOGIC;
	 SIGNAL  ni00lO :	STD_LOGIC;
	 SIGNAL  ni00Oi :	STD_LOGIC;
	 SIGNAL  ni00Ol :	STD_LOGIC;
	 SIGNAL  ni00OO :	STD_LOGIC;
	 SIGNAL  ni010i :	STD_LOGIC;
	 SIGNAL  ni010l :	STD_LOGIC;
	 SIGNAL  ni010O :	STD_LOGIC;
	 SIGNAL  ni011i :	STD_LOGIC;
	 SIGNAL  ni011l :	STD_LOGIC;
	 SIGNAL  ni011O :	STD_LOGIC;
	 SIGNAL  ni01ii :	STD_LOGIC;
	 SIGNAL  ni01il :	STD_LOGIC;
	 SIGNAL  ni01iO :	STD_LOGIC;
	 SIGNAL  ni01li :	STD_LOGIC;
	 SIGNAL  ni01ll :	STD_LOGIC;
	 SIGNAL  ni01lO :	STD_LOGIC;
	 SIGNAL  ni01Oi :	STD_LOGIC;
	 SIGNAL  ni01Ol :	STD_LOGIC;
	 SIGNAL  ni01OO :	STD_LOGIC;
	 SIGNAL  ni0i0i :	STD_LOGIC;
	 SIGNAL  ni0i0l :	STD_LOGIC;
	 SIGNAL  ni0i0O :	STD_LOGIC;
	 SIGNAL  ni0i1i :	STD_LOGIC;
	 SIGNAL  ni0i1l :	STD_LOGIC;
	 SIGNAL  ni0i1O :	STD_LOGIC;
	 SIGNAL  ni0iii :	STD_LOGIC;
	 SIGNAL  ni0iil :	STD_LOGIC;
	 SIGNAL  ni0iiO :	STD_LOGIC;
	 SIGNAL  ni0ili :	STD_LOGIC;
	 SIGNAL  ni0ill :	STD_LOGIC;
	 SIGNAL  ni0ilO :	STD_LOGIC;
	 SIGNAL  ni0iOi :	STD_LOGIC;
	 SIGNAL  ni0iOl :	STD_LOGIC;
	 SIGNAL  ni0iOO :	STD_LOGIC;
	 SIGNAL  ni0l0i :	STD_LOGIC;
	 SIGNAL  ni0l0l :	STD_LOGIC;
	 SIGNAL  ni0l0O :	STD_LOGIC;
	 SIGNAL  ni0l1i :	STD_LOGIC;
	 SIGNAL  ni0l1l :	STD_LOGIC;
	 SIGNAL  ni0l1O :	STD_LOGIC;
	 SIGNAL  ni0lii :	STD_LOGIC;
	 SIGNAL  ni0lil :	STD_LOGIC;
	 SIGNAL  ni0liO :	STD_LOGIC;
	 SIGNAL  ni0lli :	STD_LOGIC;
	 SIGNAL  ni0lll :	STD_LOGIC;
	 SIGNAL  ni0llO :	STD_LOGIC;
	 SIGNAL  ni0lOi :	STD_LOGIC;
	 SIGNAL  ni0lOl :	STD_LOGIC;
	 SIGNAL  ni0lOO :	STD_LOGIC;
	 SIGNAL  ni0O0i :	STD_LOGIC;
	 SIGNAL  ni0O0l :	STD_LOGIC;
	 SIGNAL  ni0O0O :	STD_LOGIC;
	 SIGNAL  ni0O1i :	STD_LOGIC;
	 SIGNAL  ni0O1l :	STD_LOGIC;
	 SIGNAL  ni0O1O :	STD_LOGIC;
	 SIGNAL  ni0Oii :	STD_LOGIC;
	 SIGNAL  ni0Oil :	STD_LOGIC;
	 SIGNAL  ni0OiO :	STD_LOGIC;
	 SIGNAL  ni0Oli :	STD_LOGIC;
	 SIGNAL  ni0Oll :	STD_LOGIC;
	 SIGNAL  ni0OlO :	STD_LOGIC;
	 SIGNAL  ni0OOi :	STD_LOGIC;
	 SIGNAL  ni0OOl :	STD_LOGIC;
	 SIGNAL  ni0OOO :	STD_LOGIC;
	 SIGNAL  ni1lll :	STD_LOGIC;
	 SIGNAL  ni1llO :	STD_LOGIC;
	 SIGNAL  ni1lOi :	STD_LOGIC;
	 SIGNAL  ni1lOl :	STD_LOGIC;
	 SIGNAL  ni1lOO :	STD_LOGIC;
	 SIGNAL  ni1O0i :	STD_LOGIC;
	 SIGNAL  ni1O0l :	STD_LOGIC;
	 SIGNAL  ni1O0O :	STD_LOGIC;
	 SIGNAL  ni1O1i :	STD_LOGIC;
	 SIGNAL  ni1O1l :	STD_LOGIC;
	 SIGNAL  ni1O1O :	STD_LOGIC;
	 SIGNAL  ni1Oii :	STD_LOGIC;
	 SIGNAL  ni1Oil :	STD_LOGIC;
	 SIGNAL  ni1OiO :	STD_LOGIC;
	 SIGNAL  ni1Oli :	STD_LOGIC;
	 SIGNAL  ni1Oll :	STD_LOGIC;
	 SIGNAL  ni1OlO :	STD_LOGIC;
	 SIGNAL  ni1OOi :	STD_LOGIC;
	 SIGNAL  ni1OOl :	STD_LOGIC;
	 SIGNAL  ni1OOO :	STD_LOGIC;
	 SIGNAL  nii00l :	STD_LOGIC;
	 SIGNAL  nii01i :	STD_LOGIC;
	 SIGNAL  nii01l :	STD_LOGIC;
	 SIGNAL  nii0ii :	STD_LOGIC;
	 SIGNAL  nii0ll :	STD_LOGIC;
	 SIGNAL  nii0Ol :	STD_LOGIC;
	 SIGNAL  nii10i :	STD_LOGIC;
	 SIGNAL  nii10l :	STD_LOGIC;
	 SIGNAL  nii10O :	STD_LOGIC;
	 SIGNAL  nii11i :	STD_LOGIC;
	 SIGNAL  nii11l :	STD_LOGIC;
	 SIGNAL  nii11O :	STD_LOGIC;
	 SIGNAL  nii1ii :	STD_LOGIC;
	 SIGNAL  nii1il :	STD_LOGIC;
	 SIGNAL  nii1iO :	STD_LOGIC;
	 SIGNAL  nii1li :	STD_LOGIC;
	 SIGNAL  nii1ll :	STD_LOGIC;
	 SIGNAL  nii1lO :	STD_LOGIC;
	 SIGNAL  nii1Oi :	STD_LOGIC;
	 SIGNAL  nii1Ol :	STD_LOGIC;
	 SIGNAL  niii0l :	STD_LOGIC;
	 SIGNAL  niiiil :	STD_LOGIC;
	 SIGNAL  niiiiO :	STD_LOGIC;
	 SIGNAL  niiili :	STD_LOGIC;
	 SIGNAL  niiill :	STD_LOGIC;
	 SIGNAL  niiilO :	STD_LOGIC;
	 SIGNAL  niiiOi :	STD_LOGIC;
	 SIGNAL  niiiOl :	STD_LOGIC;
	 SIGNAL  niiiOO :	STD_LOGIC;
	 SIGNAL  niil0i :	STD_LOGIC;
	 SIGNAL  niil0l :	STD_LOGIC;
	 SIGNAL  niil0O :	STD_LOGIC;
	 SIGNAL  niil1i :	STD_LOGIC;
	 SIGNAL  niil1l :	STD_LOGIC;
	 SIGNAL  niil1O :	STD_LOGIC;
	 SIGNAL  niilii :	STD_LOGIC;
	 SIGNAL  niilil :	STD_LOGIC;
	 SIGNAL  niiliO :	STD_LOGIC;
	 SIGNAL  niilli :	STD_LOGIC;
	 SIGNAL  niilll :	STD_LOGIC;
	 SIGNAL  niilOl :	STD_LOGIC;
	 SIGNAL  niiOil :	STD_LOGIC;
	 SIGNAL  niiOiO :	STD_LOGIC;
	 SIGNAL  niiOli :	STD_LOGIC;
	 SIGNAL  niiOOi :	STD_LOGIC;
	 SIGNAL  wire_w_rbist_sel_range12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rbist_sel_range14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rcxpat_chnl_sel_range755w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rcxpat_chnl_sel_range757w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_w_lg_w_lg_rpmadwidth_tx2w5w6w(0) <= wire_w_lg_w_lg_rpmadwidth_tx2w5w(0) AND rdwidth_tx;
	wire_w_lg_w_lg_rpmadwidth_tx2w5w(0) <= wire_w_lg_rpmadwidth_tx2w(0) AND wire_nil11i2_w_lg_q4w(0);
	wire_w_lg_rpmadwidth_tx2w(0) <= rpmadwidth_tx AND wire_w_lg_rpma_doublewidth_tx1w(0);
	wire_w_lg_w_rbist_sel_range12w20w(0) <= wire_w_rbist_sel_range12w(0) AND wire_w_lg_w_rbist_sel_range14w15w(0);
	wire_w_lg_w_rcxpat_chnl_sel_range755w760w(0) <= wire_w_rcxpat_chnl_sel_range755w(0) AND wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0);
	wire_w_lg_ni000l1442w(0) <= NOT ni000l;
	wire_w_lg_ni0iOi1037w(0) <= NOT ni0iOi;
	wire_w_lg_ni0iOl1019w(0) <= NOT ni0iOl;
	wire_w_lg_ni0iOO996w(0) <= NOT ni0iOO;
	wire_w_lg_ni0l0l913w(0) <= NOT ni0l0l;
	wire_w_lg_ni0l0O912w(0) <= NOT ni0l0O;
	wire_w_lg_ni0l1i983w(0) <= NOT ni0l1i;
	wire_w_lg_ni0l1l970w(0) <= NOT ni0l1l;
	wire_w_lg_ni0l1O957w(0) <= NOT ni0l1O;
	wire_w_lg_ni0lii914w(0) <= NOT ni0lii;
	wire_w_lg_ni0lil911w(0) <= NOT ni0lil;
	wire_w_lg_ni0liO910w(0) <= NOT ni0liO;
	wire_w_lg_ni0lll909w(0) <= NOT ni0lll;
	wire_w_lg_ni0llO908w(0) <= NOT ni0llO;
	wire_w_lg_ni0lOl907w(0) <= NOT ni0lOl;
	wire_w_lg_ni0O0i894w(0) <= NOT ni0O0i;
	wire_w_lg_ni0O0O893w(0) <= NOT ni0O0O;
	wire_w_lg_ni0O1i896w(0) <= NOT ni0O1i;
	wire_w_lg_ni0O1l895w(0) <= NOT ni0O1l;
	wire_w_lg_ni0Oii1237w(0) <= NOT ni0Oii;
	wire_w_lg_ni0Oil891w(0) <= NOT ni0Oil;
	wire_w_lg_ni0OiO892w(0) <= NOT ni0OiO;
	wire_w_lg_ni0Oli906w(0) <= NOT ni0Oli;
	wire_w_lg_ni0OOi889w(0) <= NOT ni0OOi;
	wire_w_lg_ni0OOl888w(0) <= NOT ni0OOl;
	wire_w_lg_ni1lll2233w(0) <= NOT ni1lll;
	wire_w_lg_ni1Oil2081w(0) <= NOT ni1Oil;
	wire_w_lg_nii00l246w(0) <= NOT nii00l;
	wire_w_lg_nii01i291w(0) <= NOT nii01i;
	wire_w_lg_nii01l267w(0) <= NOT nii01l;
	wire_w_lg_nii0ii229w(0) <= NOT nii0ii;
	wire_w_lg_nii0ll204w(0) <= NOT nii0ll;
	wire_w_lg_nii0Ol176w(0) <= NOT nii0Ol;
	wire_w_lg_nii11i695w(0) <= NOT nii11i;
	wire_w_lg_nii1Ol312w(0) <= NOT nii1Ol;
	wire_w_lg_niiiil107w(0) <= NOT niiiil;
	wire_w_lg_niiiiO106w(0) <= NOT niiiiO;
	wire_w_lg_niiili108w(0) <= NOT niiili;
	wire_w_lg_niiill105w(0) <= NOT niiill;
	wire_w_lg_niiilO447w(0) <= NOT niiilO;
	wire_w_lg_niiiOi102w(0) <= NOT niiiOi;
	wire_w_lg_niiiOl103w(0) <= NOT niiiOl;
	wire_w_lg_niiiOO104w(0) <= NOT niiiOO;
	wire_w_lg_niil0l99w(0) <= NOT niil0l;
	wire_w_lg_niil0O98w(0) <= NOT niil0O;
	wire_w_lg_niil1O100w(0) <= NOT niil1O;
	wire_w_lg_niilii97w(0) <= NOT niilii;
	wire_w_lg_niilil96w(0) <= NOT niilil;
	wire_w_lg_niiliO95w(0) <= NOT niiliO;
	wire_w_lg_niiOOi445w(0) <= NOT niiOOi;
	wire_w_lg_rpma_doublewidth_tx1w(0) <= NOT rpma_doublewidth_tx;
	wire_w_lg_soft_reset93w(0) <= NOT soft_reset;
	wire_w_lg_w_rbist_sel_range14w15w(0) <= NOT wire_w_rbist_sel_range14w(0);
	wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0) <= NOT wire_w_rcxpat_chnl_sel_range757w(0);
	bist_ctl_sg <= ( wire_ni1O_dataout & wire_ni1l_dataout);
	bist_data_sg <= ( wire_ni1i_dataout & wire_n0OO_dataout & wire_n0Ol_dataout & wire_n0Oi_dataout & wire_n0lO_dataout & wire_n0ll_dataout & wire_n0li_dataout & wire_n0iO_dataout & wire_n0il_dataout & wire_n0ii_dataout & wire_n00O_dataout & wire_n00l_dataout & wire_n00i_dataout & wire_n01O_dataout & wire_n01l_dataout & wire_n01i_dataout);
	ni000i <= (((((((((((((n1liO OR n1lii) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil);
	ni000l <= ((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1iiO) OR n1i0O) OR n1i0l);
	ni000O <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii);
	ni001i <= (((((wire_nl0OOO_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w(0) AND wire_nl0OOO_w_lg_nl0ill2246w(0)) AND wire_nl0OOO_w_lg_nl0ili2248w(0)) AND nl0iiO) AND nl0iil) AND nl0iii);
	ni001O <= (nli11i OR nl0OOi);
	ni00ii <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1i0l);
	ni00il <= (((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1i0O) OR n1i0l);
	ni00iO <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00li <= (((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00ll <= ((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00lO <= ((((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1l1O) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00Oi <= (((((((((((n1liO OR n1lii) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00Ol <= (((((((((((((((n1liO OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni00OO <= (((((((((((wire_n1l0O_w_lg_n1l0i1211w(0) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1i0O);
	ni010i <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni010l <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni010O <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni011i <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O1O);
	ni011l <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0i) OR nl0O1O);
	ni011O <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01ii <= (((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01il <= ((((((((nl0OOl OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01iO <= (((((((((nl0OOl OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01li <= (((((((((nl0OlO OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01ll <= ((((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni01lO <= ((((((((nl0OOl OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l);
	ni01Oi <= (((((((nl0iOl AND nl0iOi) AND nl0ilO) AND nl0ill) AND nl0ili) AND nl0iiO) AND nl0iil) AND nl0iii);
	ni01Ol <= ((((((nl00Ol AND nl00Oi) AND nl00lO) AND nl00ll) AND nl00li) AND nl00iO) AND nl00il);
	ni01OO <= ((((wire_nl0OOO_w_lg_w_lg_w_lg_w_lg_nl0iOl2241w2243w2245w2253w(0) AND wire_nl0OOO_w_lg_nl0ili2248w(0)) AND wire_nl0OOO_w_lg_nl0iiO2255w(0)) AND wire_nl0OOO_w_lg_nl0iil2257w(0)) AND wire_nl0OOO_w_lg_nl0iii2259w(0));
	ni0i0i <= ((((((n1lii OR n1l1O) OR n1l1l) OR n1iOO) OR n1ill) OR n1ili) OR n1iil);
	ni0i0l <= (((((((((n1liO OR n1l0l) OR n1l0i) OR n1l1i) OR n1iOl) OR n1ilO) OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0i0O <= (((((((((((n1l0l OR n1l0i) OR n1l1l) OR n1l1i) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0i1i <= ((((((((((((((n1lii OR n1l0l) OR n1l0i) OR n1l1O) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iOl) OR n1iOi) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1i0O);
	ni0i1l <= (((((((((n1lii OR n1l0l) OR n1l0i) OR n1l1O) OR n1iOO) OR n1iOl) OR n1ilO) OR n1ill) OR n1iiO) OR n1iil);
	ni0i1O <= ((((((n1liO OR n1l1l) OR n1l1i) OR n1ili) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iii <= ((((n1liO OR n1lii) OR n1l1O) OR n1iOO) OR n1iil);
	ni0iil <= (((((((((((n1lii OR n1l1O) OR n1l1l) OR n1iOO) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iiO <= ((((n1liO OR n1l0l) OR n1l0i) OR n1l1i) OR n1iOl);
	ni0ili <= ((((((((((((n1lii OR n1l0l) OR n1l0i) OR n1l1l) OR n1l1i) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0ill <= (((((((n1lii OR n1l0l) OR n1l0i) OR n1l1l) OR n1l1i) OR n1iOO) OR n1iiO) OR n1i0O);
	ni0ilO <= (((((((wire_n1lil_w_lg_n1liO1051w(0) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iil) OR n1iii) OR n1i0l);
	ni0iOi <= (((((((((((n1liO OR n1l0i) OR n1l1O) OR n1l1l) OR n1iOO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iOl <= (((((((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1iOO) OR n1iOl) OR n1ilO) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0iOO <= ((((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1iOO) OR n1iOl) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l0i <= (((((((n1liO OR n1lii) OR n1l0i) OR n1l1O) OR n1l1l) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l0l <= ((nlOOiO AND wire_n1l0O_w_lg_nlOOil1477w(0)) AND nliliO);
	ni0l0O <= ((nlOOiO AND nlOOil) AND wire_n1l0O_w_lg_nliliO1544w(0));
	ni0l1i <= ((((((n1liO OR n1l0i) OR n1l1i) OR n1iOi) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l1l <= ((((((n1liO OR n1lii) OR n1l0l) OR n1l0i) OR n1iiO) OR n1i0O) OR n1i0l);
	ni0l1O <= ((((((((((n1liO OR n1l0i) OR n1iOl) OR n1iOi) OR n1ill) OR n1ili) OR n1iiO) OR n1iil) OR n1iii) OR n1i0O) OR n1i0l);
	ni0lii <= (wire_n1l0O_w_lg_w_lg_nlOOiO1476w1543w(0) AND wire_n1l0O_w_lg_nliliO1544w(0));
	ni0lil <= ((((wire_n1l0O_w_lg_w_lg_nlOOOO1529w1530w(0) AND wire_n1l0O_w_lg_nlOOOi1531w(0)) AND wire_n1l0O_w_lg_nlOOlO1533w(0)) AND nlOOll) AND nlOOli);
	ni0liO <= ((((wire_n1l0O_w_lg_nlOOOO1538w(0) AND wire_n1l0O_w_lg_nlOOOi1531w(0)) AND nlOOlO) AND nlOOll) AND nlOOli);
	ni0lli <= ((wire_n1l0O_w_lg_n111O1524w(0) AND n111l) AND n111i);
	ni0lll <= ((n111O AND n111l) AND n111i);
	ni0llO <= (wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w(0) AND wire_n1l0O_w_lg_n110i1516w(0));
	ni0lOi <= (((wire_n1l0O_w_lg_n11ii897w(0) AND n110O) AND n110l) AND n110i);
	ni0lOl <= (((n11ii AND n110O) AND n110l) AND n110i);
	ni0lOO <= (wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n11ii897w899w900w901w(0) OR wire_n1l0O_w_lg_w_lg_w_lg_n11ii902w903w904w(0));
	ni0O0i <= (wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w(0) AND n11il);
	ni0O0l <= ((((((wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0)) AND wire_n1l0O_w_lg_n11lO1486w(0)) AND wire_n1l0O_w_lg_n11ll1488w(0)) AND wire_n1l0O_w_lg_n11li1490w(0)) AND wire_n1l0O_w_lg_n11iO1492w(0)) AND wire_n1l0O_w_lg_n11il1494w(0));
	ni0O0O <= (wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w(0) AND wire_n1l0O_w_lg_n11il1494w(0));
	ni0O1i <= (wire_n1l0O_w_lg_w_lg_w1510w1511w1512w(0) AND n11il);
	ni0O1l <= (wire_n1l0O_w_lg_w_lg_w1510w1511w1512w(0) AND wire_n1l0O_w_lg_n11il1494w(0));
	ni0O1O <= ((((((wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0)) AND wire_n1l0O_w_lg_n11lO1486w(0)) AND wire_n1l0O_w_lg_n11ll1488w(0)) AND wire_n1l0O_w_lg_n11li1490w(0)) AND wire_n1l0O_w_lg_n11iO1492w(0)) AND n11il);
	ni0Oii <= ((NOT rcxpat_chnl_sel(0)) AND wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0));
	ni0Oil <= ((wire_n1l0O_w_lg_nlOOiO1476w(0) AND wire_n1l0O_w_lg_nlOOil1477w(0)) AND nliliO);
	ni0OiO <= (ni0Oll OR ni0Oli);
	ni0Oli <= ((NOT rcxpat_chnl_sel(0)) AND rcxpat_chnl_sel(1));
	ni0Oll <= wire_w_lg_w_rcxpat_chnl_sel_range755w760w(0);
	ni0OlO <= ((((n1lii OR n1iiO) OR n1iii) OR n1i0O) OR n1i0l);
	ni0OOi <= ((((((n1liO OR n1l0l) OR n1l0i) OR n1l1O) OR n1ill) OR n1ili) OR n1i0l);
	ni0OOl <= ((((((n1liO OR n1l0l) OR n1l1O) OR n1l1l) OR n1ili) OR n1i0O) OR n1i0l);
	ni0OOO <= (((((((((((((((((wire_nliiO_w_lg_w_lg_nlili109w110w(0) OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O);
	ni1lll <= ((((((nli11O OR nl0OOi) OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1llO <= (((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0i);
	ni1lOi <= (((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O1O);
	ni1lOl <= ((((((((((nli11i OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1lOO <= ((((((((((nli11i OR nl0OOl) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0i) OR nl0O1O);
	ni1O0i <= ((((((nl0Oli OR nl0OiO) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O0l <= ((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oil);
	ni1O0O <= (((((((nli11i OR nl0OOl) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O1i <= (((((((((((nli11i OR nl0OOl) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O1l <= (((((((nli11i OR nl0OOl) OR nl0Oll) OR nl0OiO) OR nl0O0O) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1O1O <= ((((nli11O OR nl0OlO) OR nl0Oli) OR nl0Oil) OR nl0Oii);
	ni1Oii <= ((((nli11O OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO);
	ni1Oil <= (((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OiO <= ((((((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O0i) OR nl0O1O);
	ni1Oli <= ((((((nli11O OR nl0OOl) OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1Oll <= ((((((nli11O OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0O) OR nl0O0l) OR nl0O1O);
	ni1OlO <= (((((nli11O OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OOi <= ((((((nli11O OR nl0Oll) OR nl0OiO) OR nl0Oil) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OOl <= (((((((nli11O OR nli11i) OR nl0OlO) OR nl0Oll) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	ni1OOO <= (((((((nli11O OR nl0OlO) OR nl0Oll) OR nl0Oli) OR nl0OiO) OR nl0Oii) OR nl0O0l) OR nl0O1O);
	nii00l <= ((((((((wire_nliiO_w_lg_w188w189w(0) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0il) OR nl01O) OR nl01i) OR nl1OO);
	nii01i <= ((((((((((((((((wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w(0) OR nli1O) OR nli1i) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii01l <= (wire_nliiO_w262w(0) OR (NOT (nii01O42 XOR nii01O41)));
	nii0ii <= (wire_nliiO_w223w(0) OR (NOT (nii0il38 XOR nii0il37)));
	nii0ll <= (wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w194w195w196w197w198w199w(0) OR (NOT (nii0lO34 XOR nii0lO33)));
	nii0Ol <= (((((((((((((wire_nliiO_w_lg_w_lg_w_lg_nlili160w161w162w(0) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0il) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii10i <= ((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl01i) OR nl1OO);
	nii10l <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii10O <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii11i <= (((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl01O) OR nl01i) OR nl1OO);
	nii11l <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l);
	nii11O <= ((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_w188w189w190w191w192w193w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl1OO);
	nii1ii <= ((((((((((((wire_nliiO_w_lg_w_lg_w_lg_w188w189w190w191w(0) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1il <= ((((((((((((((wire_nliiO_w_lg_w188w189w(0) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1iO <= ((((((((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_w_lg_nlili109w184w185w186w187w(0) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1li <= ((((((((((((((((((wire_nliiO_w_lg_w_lg_w_lg_nlili109w184w185w(0) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1ll <= ((((((((((((((((((nlili OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	nii1lO <= ((((((((((((((((((nli0l OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01i);
	nii1Oi <= ((((((((((((((((((((nliil OR nli0O) OR nli0l) OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0ll) OR nl0li) OR nl0iO) OR nl0il) OR nl0ii) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01i);
	nii1Ol <= (((((((((((wire_nliiO_w_lg_w_lg_w_lg_w_lg_nlili160w161w162w254w(0) OR nl0Oi) OR nl0lO) OR nl0li) OR nl0il) OR nl00O) OR nl00l) OR nl00i) OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	niii0l <= (wire_nliiO_w_lg_w_lg_w120w121w122w(0) OR (NOT (niii0O22 XOR niii0O21)));
	niiiil <= ((niO0O AND wire_nliii_w_lg_niO0l763w(0)) AND n0lOi);
	niiiiO <= ((niO0O AND niO0l) AND wire_nliii_w_lg_n0lOi772w(0));
	niiili <= (wire_nliii_w_lg_w_lg_niO0O762w771w(0) AND wire_nliii_w_lg_n0lOi772w(0));
	niiill <= (wire_nliii_w_lg_w_lg_w_lg_niOll766w767w768w(0) AND wire_nliii_w_lg_niOii769w(0));
	niiilO <= ((NOT rcxpat_chnl_sel(0)) AND wire_w_lg_w_rcxpat_chnl_sel_range757w758w(0));
	niiiOi <= ((wire_nliii_w_lg_niO0O762w(0) AND wire_nliii_w_lg_niO0l763w(0)) AND n0lOi);
	niiiOl <= (niil1i OR niiiOO);
	niiiOO <= ((NOT rcxpat_chnl_sel(0)) AND rcxpat_chnl_sel(1));
	niil0i <= (((((((((nliil OR nli0i) OR nli1O) OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl0Oi) OR nl0ll) OR nl0li);
	niil0l <= ((((((((wire_nliiO_w_lg_nlili109w(0) OR nli1l) OR nl0OO) OR nl0Oi) OR nl0li) OR nl0il) OR nl0ii) OR nl00O) OR nl00i);
	niil0O <= (((((((((nlili OR nli0O) OR nli0l) OR nli1O) OR nli1l) OR nli1i) OR nl0Oi) OR nl0lO) OR nl0iO) OR nl00l);
	niil1i <= wire_w_lg_w_rcxpat_chnl_sel_range755w760w(0);
	niil1l <= ((((nliil OR nl01O) OR nl01l) OR nl01i) OR nl1OO);
	niil1O <= (((((((nlili OR nli0i) OR nl0lO) OR nl0ll) OR nl0ii) OR nl01l) OR nl01i) OR nl1OO);
	niilii <= (((((nlili OR nli1l) OR nli1i) OR nl0OO) OR nl0Ol) OR nl00l);
	niilil <= (((((((((((nlili OR nli0O) OR nli0l) OR nli1O) OR nli1i) OR nl0Ol) OR nl0lO) OR nl0ll) OR nl0il) OR nl00l) OR nl00i) OR nl1OO);
	niiliO <= (((((((((nlili OR nli0i) OR nli1l) OR nl0Ol) OR nl0Oi) OR nl0lO) OR nl0iO) OR nl00l) OR nl01l) OR nl1OO);
	niilli <= (((((((((nliil OR nli0l) OR nli0i) OR nli1O) OR nl0Ol) OR nl0Oi) OR nl0li) OR nl0ii) OR nl01O) OR nl01l);
	niilll <= '1';
	niilOl <= '0';
	niiOil <= (((NOT rbist_sel(0)) AND wire_w_lg_w_rbist_sel_range14w15w(0)) AND (niiO0O8 XOR niiO0O7));
	niiOiO <= (wire_w_lg_w_rbist_sel_range12w20w(0) AND (niiO0i10 XOR niiO0i9));
	niiOli <= (((NOT rbist_sel(0)) AND rbist_sel(1)) AND (niiO1l12 XOR niiO1l11));
	niiOOi <= (wire_w_lg_w_lg_w_lg_rpmadwidth_tx2w5w6w(0) OR ((rpmadwidth_tx AND rpma_doublewidth_tx) AND (niiOOl4 XOR niiOOl3)));
	wire_w_rbist_sel_range12w(0) <= rbist_sel(0);
	wire_w_rbist_sel_range14w(0) <= rbist_sel(1);
	wire_w_rcxpat_chnl_sel_range755w(0) <= rcxpat_chnl_sel(0);
	wire_w_rcxpat_chnl_sel_range757w(0) <= rcxpat_chnl_sel(1);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN ni001l45 <= ni001l46;
		END IF;
		if (now = 0 ns) then
			ni001l45 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN ni001l46 <= ni001l45;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii00O39 <= nii00O40;
		END IF;
		if (now = 0 ns) then
			nii00O39 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii00O40 <= nii00O39;
		END IF;
	END PROCESS;
	wire_nii00O40_w_lg_w_lg_q228w230w(0) <= wire_nii00O40_w_lg_q228w(0) AND wire_w_lg_nii0ii229w(0);
	wire_nii00O40_w_lg_q228w(0) <= nii00O40 XOR nii00O39;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii01O41 <= nii01O42;
		END IF;
		if (now = 0 ns) then
			nii01O41 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii01O42 <= nii01O41;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0il37 <= nii0il38;
		END IF;
		if (now = 0 ns) then
			nii0il37 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0il38 <= nii0il37;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0li35 <= nii0li36;
		END IF;
		if (now = 0 ns) then
			nii0li35 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0li36 <= nii0li35;
		END IF;
	END PROCESS;
	wire_nii0li36_w_lg_w_lg_q207w208w(0) <= wire_nii0li36_w_lg_q207w(0) AND nii0ll;
	wire_nii0li36_w_lg_q207w(0) <= nii0li36 XOR nii0li35;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0lO33 <= nii0lO34;
		END IF;
		if (now = 0 ns) then
			nii0lO33 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0lO34 <= nii0lO33;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0OO31 <= nii0OO32;
		END IF;
		if (now = 0 ns) then
			nii0OO31 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii0OO32 <= nii0OO31;
		END IF;
	END PROCESS;
	wire_nii0OO32_w_lg_w_lg_q155w156w(0) <= wire_nii0OO32_w_lg_q155w(0) AND wire_nilli_dataout;
	wire_nii0OO32_w_lg_q155w(0) <= nii0OO32 XOR nii0OO31;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii1OO43 <= nii1OO44;
		END IF;
		if (now = 0 ns) then
			nii1OO43 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nii1OO44 <= nii1OO43;
		END IF;
	END PROCESS;
	wire_nii1OO44_w_lg_w_lg_q295w296w(0) <= wire_nii1OO44_w_lg_q295w(0) AND niiOOi;
	wire_nii1OO44_w_lg_q295w(0) <= nii1OO44 XOR nii1OO43;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0i23 <= niii0i24;
		END IF;
		if (now = 0 ns) then
			niii0i23 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0i24 <= niii0i23;
		END IF;
	END PROCESS;
	wire_niii0i24_w_lg_w_lg_q129w130w(0) <= wire_niii0i24_w_lg_q129w(0) AND nl00i;
	wire_niii0i24_w_lg_q129w(0) <= niii0i24 XOR niii0i23;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0O21 <= niii0O22;
		END IF;
		if (now = 0 ns) then
			niii0O21 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii0O22 <= niii0O21;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1i29 <= niii1i30;
		END IF;
		if (now = 0 ns) then
			niii1i29 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1i30 <= niii1i29;
		END IF;
	END PROCESS;
	wire_niii1i30_w_lg_w_lg_q152w153w(0) <= wire_niii1i30_w_lg_q152w(0) AND niiOOi;
	wire_niii1i30_w_lg_q152w(0) <= niii1i30 XOR niii1i29;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1l27 <= niii1l28;
		END IF;
		if (now = 0 ns) then
			niii1l27 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1l28 <= niii1l27;
		END IF;
	END PROCESS;
	wire_niii1l28_w_lg_w_lg_q141w142w(0) <= wire_niii1l28_w_lg_q141w(0) AND niii0l;
	wire_niii1l28_w_lg_q141w(0) <= niii1l28 XOR niii1l27;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1O25 <= niii1O26;
		END IF;
		if (now = 0 ns) then
			niii1O25 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niii1O26 <= niii1O25;
		END IF;
	END PROCESS;
	wire_niii1O26_w_lg_w_lg_q132w133w(0) <= wire_niii1O26_w_lg_q132w(0) AND nl00l;
	wire_niii1O26_w_lg_q132w(0) <= niii1O26 XOR niii1O25;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niillO19 <= niillO20;
		END IF;
		if (now = 0 ns) then
			niillO19 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niillO20 <= niillO19;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOi17 <= niilOi18;
		END IF;
		if (now = 0 ns) then
			niilOi17 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOi18 <= niilOi17;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOO15 <= niilOO16;
		END IF;
		if (now = 0 ns) then
			niilOO15 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niilOO16 <= niilOO15;
		END IF;
	END PROCESS;
	wire_niilOO16_w_lg_w_lg_q78w79w(0) <= wire_niilOO16_w_lg_q78w(0) AND niO0O;
	wire_niilOO16_w_lg_q78w(0) <= niilOO16 XOR niilOO15;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0i10 <= niiO0i9;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0i9 <= niiO0i10;
		END IF;
		if (now = 0 ns) then
			niiO0i9 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0O7 <= niiO0O8;
		END IF;
		if (now = 0 ns) then
			niiO0O7 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO0O8 <= niiO0O7;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1i13 <= niiO1i14;
		END IF;
		if (now = 0 ns) then
			niiO1i13 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1i14 <= niiO1i13;
		END IF;
	END PROCESS;
	wire_niiO1i14_w_lg_w_lg_q53w54w(0) <= wire_niiO1i14_w_lg_q53w(0) AND niOil;
	wire_niiO1i14_w_lg_q53w(0) <= niiO1i14 XOR niiO1i13;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1l11 <= niiO1l12;
		END IF;
		if (now = 0 ns) then
			niiO1l11 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiO1l12 <= niiO1l11;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOll5 <= niiOll6;
		END IF;
		if (now = 0 ns) then
			niiOll5 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOll6 <= niiOll5;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOOl3 <= niiOOl4;
		END IF;
		if (now = 0 ns) then
			niiOOl3 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niiOOl4 <= niiOOl3;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nil11i1 <= nil11i2;
		END IF;
		if (now = 0 ns) then
			nil11i1 <= '1' after 1 ps;
		end if;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nil11i2 <= nil11i1;
		END IF;
	END PROCESS;
	wire_nil11i2_w_lg_q4w(0) <= nil11i2 XOR nil11i1;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n100i <= '0';
				n100l <= '0';
				n100O <= '0';
				n101i <= '0';
				n101l <= '0';
				n101O <= '0';
				n10ii <= '0';
				n10il <= '0';
				n10iO <= '0';
				n10li <= '0';
				n10ll <= '0';
				n10lO <= '0';
				n10Oi <= '0';
				n10Ol <= '0';
				n10OO <= '0';
				n110i <= '0';
				n110l <= '0';
				n110O <= '0';
				n111i <= '0';
				n111l <= '0';
				n111O <= '0';
				n11ii <= '0';
				n11il <= '0';
				n11iO <= '0';
				n11li <= '0';
				n11ll <= '0';
				n11lO <= '0';
				n11Oi <= '0';
				n11Ol <= '0';
				n11OO <= '0';
				n1i0i <= '0';
				n1i0l <= '0';
				n1i0O <= '0';
				n1i1i <= '0';
				n1i1l <= '0';
				n1i1O <= '0';
				n1iii <= '0';
				n1iil <= '0';
				n1iiO <= '0';
				n1ili <= '0';
				n1ill <= '0';
				n1ilO <= '0';
				n1iOi <= '0';
				n1iOl <= '0';
				n1iOO <= '0';
				n1l0i <= '0';
				n1l0l <= '0';
				n1l1i <= '0';
				n1l1l <= '0';
				n1l1O <= '0';
				n1lii <= '0';
				nliliO <= '0';
				nlOOil <= '0';
				nlOOiO <= '0';
				nlOOli <= '0';
				nlOOll <= '0';
				nlOOlO <= '0';
				nlOOOi <= '0';
				nlOOOl <= '0';
				nlOOOO <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (wire_nll_dataout = '1') THEN
				n100i <= wire_nll01O_o;
				n100l <= wire_nll00O_o;
				n100O <= wire_nll0iO_o;
				n101i <= wire_n001O_dataout;
				n101l <= ni0OlO;
				n101O <= wire_nliO1i_o;
				n10ii <= wire_nll0lO_o;
				n10il <= wire_nll0OO_o;
				n10iO <= wire_w_lg_ni0OOi889w(0);
				n10li <= wire_nlli0i_o;
				n10ll <= wire_w_lg_ni0OOl888w(0);
				n10lO <= wire_nlliil_o;
				n10Oi <= wire_nllili_o;
				n10Ol <= wire_nllilO_o;
				n10OO <= wire_nlliOi_o;
				n110i <= wire_n011i_dataout;
				n110l <= wire_n011l_dataout;
				n110O <= wire_n011O_dataout;
				n111i <= wire_n1OlO_dataout;
				n111l <= wire_n1OOi_dataout;
				n111O <= wire_n1OOl_dataout;
				n11ii <= wire_n010i_dataout;
				n11il <= wire_n01li_dataout;
				n11iO <= wire_n01ll_dataout;
				n11li <= wire_n01lO_dataout;
				n11ll <= wire_n01Oi_dataout;
				n11lO <= wire_n01Ol_dataout;
				n11Oi <= wire_n01OO_dataout;
				n11Ol <= wire_n001i_dataout;
				n11OO <= wire_n001l_dataout;
				n1i0i <= wire_nlll0O_o;
				n1i0l <= wire_nliO1O_o;
				n1i0O <= wire_nliO0l_o;
				n1i1i <= wire_nlliOO_o;
				n1i1l <= wire_nlll1l_o;
				n1i1O <= wire_nlll0i_o;
				n1iii <= wire_nliOii_o;
				n1iil <= wire_nliOli_o;
				n1iiO <= wire_nliOll_dataout;
				n1ili <= wire_nliOlO_o;
				n1ill <= wire_nliOOi_o;
				n1ilO <= wire_nliOOl_o;
				n1iOi <= wire_nll11i_dataout;
				n1iOl <= wire_nll11l_o;
				n1iOO <= wire_nll10i_o;
				n1l0i <= wire_nll1Oi_dataout;
				n1l0l <= wire_nll1Ol_o;
				n1l1i <= wire_nll10O_o;
				n1l1l <= wire_nll1il_o;
				n1l1O <= wire_nll1ll_o;
				n1lii <= wire_nll01i_o;
				nliliO <= wire_n1lli_dataout;
				nlOOil <= wire_n1lll_dataout;
				nlOOiO <= wire_n1llO_dataout;
				nlOOli <= wire_n1lOl_dataout;
				nlOOll <= wire_n1lOO_dataout;
				nlOOlO <= wire_n1O1i_dataout;
				nlOOOi <= wire_n1O1l_dataout;
				nlOOOl <= wire_n1O1O_dataout;
				nlOOOO <= wire_n1O0i_dataout;
			END IF;
		END IF;
	END PROCESS;
	wire_n1l0O_w_lg_w_lg_w_lg_w1501w1502w1503w1504w(0) <= wire_n1l0O_w_lg_w_lg_w1501w1502w1503w(0) AND n11iO;
	wire_n1l0O_w_lg_w_lg_w1510w1511w1512w(0) <= wire_n1l0O_w_lg_w1510w1511w(0) AND n11iO;
	wire_n1l0O_w_lg_w_lg_w1501w1502w1503w(0) <= wire_n1l0O_w_lg_w1501w1502w(0) AND wire_n1l0O_w_lg_n11li1490w(0);
	wire_n1l0O_w_lg_w1510w1511w(0) <= wire_n1l0O_w1510w(0) AND n11li;
	wire_n1l0O_w_lg_w1501w1502w(0) <= wire_n1l0O_w1501w(0) AND wire_n1l0O_w_lg_n11ll1488w(0);
	wire_n1l0O_w1510w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1506w1507w1508w1509w(0) AND wire_n1l0O_w_lg_n11ll1488w(0);
	wire_n1l0O_w1501w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1480w1497w1499w1500w(0) AND wire_n1l0O_w_lg_n11lO1486w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1506w1507w1508w1509w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_n101i1506w1507w1508w(0) AND wire_n1l0O_w_lg_n11lO1486w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n101i1480w1497w1499w1500w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1497w1499w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_w_lg_n11ii897w899w900w901w(0) <= wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w(0) AND n110i;
	wire_n1l0O_w_lg_w_lg_w_lg_n101i1506w1507w1508w(0) <= wire_n1l0O_w_lg_w_lg_n101i1506w1507w(0) AND wire_n1l0O_w_lg_n11Oi1484w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_n11ii902w903w904w(0) <= wire_n1l0O_w_lg_w_lg_n11ii902w903w(0) AND n110i;
	wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1482w1483w(0) <= wire_n1l0O_w_lg_w_lg_n101i1480w1482w(0) AND n11Ol;
	wire_n1l0O_w_lg_w_lg_w_lg_n101i1480w1497w1499w(0) <= wire_n1l0O_w_lg_w_lg_n101i1480w1497w(0) AND wire_n1l0O_w_lg_n11Ol1498w(0);
	wire_n1l0O_w_lg_w_lg_w_lg_n11ii897w899w900w(0) <= wire_n1l0O_w_lg_w_lg_n11ii897w899w(0) AND n110l;
	wire_n1l0O_w_lg_w_lg_n101i1506w1507w(0) <= wire_n1l0O_w_lg_n101i1506w(0) AND wire_n1l0O_w_lg_n11Ol1498w(0);
	wire_n1l0O_w_lg_w_lg_n11ii902w903w(0) <= wire_n1l0O_w_lg_n11ii902w(0) AND n110l;
	wire_n1l0O_w_lg_w_lg_n101i1480w1482w(0) <= wire_n1l0O_w_lg_n101i1480w(0) AND wire_n1l0O_w_lg_n11OO1481w(0);
	wire_n1l0O_w_lg_w_lg_n101i1480w1497w(0) <= wire_n1l0O_w_lg_n101i1480w(0) AND n11OO;
	wire_n1l0O_w_lg_w_lg_n11ii897w899w(0) <= wire_n1l0O_w_lg_n11ii897w(0) AND wire_n1l0O_w_lg_n110O898w(0);
	wire_n1l0O_w_lg_w_lg_nlOOiO1476w1543w(0) <= wire_n1l0O_w_lg_nlOOiO1476w(0) AND nlOOil;
	wire_n1l0O_w_lg_w_lg_nlOOOO1529w1530w(0) <= wire_n1l0O_w_lg_nlOOOO1529w(0) AND nlOOOl;
	wire_n1l0O_w_lg_n101i1506w(0) <= n101i AND wire_n1l0O_w_lg_n11OO1481w(0);
	wire_n1l0O_w_lg_n11ii902w(0) <= n11ii AND wire_n1l0O_w_lg_n110O898w(0);
	wire_n1l0O_w_lg_nlOOOO1538w(0) <= nlOOOO AND wire_n1l0O_w_lg_nlOOOl1537w(0);
	wire_n1l0O_w_lg_n101i1480w(0) <= NOT n101i;
	wire_n1l0O_w_lg_n110i1516w(0) <= NOT n110i;
	wire_n1l0O_w_lg_n110O898w(0) <= NOT n110O;
	wire_n1l0O_w_lg_n111O1524w(0) <= NOT n111O;
	wire_n1l0O_w_lg_n11ii897w(0) <= NOT n11ii;
	wire_n1l0O_w_lg_n11il1494w(0) <= NOT n11il;
	wire_n1l0O_w_lg_n11iO1492w(0) <= NOT n11iO;
	wire_n1l0O_w_lg_n11li1490w(0) <= NOT n11li;
	wire_n1l0O_w_lg_n11ll1488w(0) <= NOT n11ll;
	wire_n1l0O_w_lg_n11lO1486w(0) <= NOT n11lO;
	wire_n1l0O_w_lg_n11Oi1484w(0) <= NOT n11Oi;
	wire_n1l0O_w_lg_n11Ol1498w(0) <= NOT n11Ol;
	wire_n1l0O_w_lg_n11OO1481w(0) <= NOT n11OO;
	wire_n1l0O_w_lg_nliliO1544w(0) <= NOT nliliO;
	wire_n1l0O_w_lg_nlOOil1477w(0) <= NOT nlOOil;
	wire_n1l0O_w_lg_nlOOiO1476w(0) <= NOT nlOOiO;
	wire_n1l0O_w_lg_nlOOlO1533w(0) <= NOT nlOOlO;
	wire_n1l0O_w_lg_nlOOOi1531w(0) <= NOT nlOOOi;
	wire_n1l0O_w_lg_nlOOOl1537w(0) <= NOT nlOOOl;
	wire_n1l0O_w_lg_nlOOOO1529w(0) <= NOT nlOOOO;
	wire_n1l0O_w_lg_w_lg_w_lg_n1ill1401w1402w1403w(0) <= wire_n1l0O_w_lg_w_lg_n1ill1401w1402w(0) OR n1iil;
	wire_n1l0O_w_lg_w_lg_n1ill1401w1402w(0) <= wire_n1l0O_w_lg_n1ill1401w(0) OR n1iiO;
	wire_n1l0O_w_lg_n1ill1401w(0) <= n1ill OR n1ili;
	wire_n1l0O_w_lg_n1l0i1211w(0) <= n1l0i OR n1l1O;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n1liO <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (wire_nll_dataout = '1') THEN
				n1liO <= niilOl;
			END IF;
		END IF;
		if (now = 0 ns) then
			n1liO <= '1' after 1 ps;
		end if;
	END PROCESS;
	wire_n1lil_w_lg_w_lg_w_lg_n1liO1051w1092w1093w(0) <= wire_n1lil_w_lg_w_lg_n1liO1051w1092w(0) OR n1iil;
	wire_n1lil_w_lg_w_lg_n1liO1051w1092w(0) <= wire_n1lil_w_lg_n1liO1051w(0) OR n1iOO;
	wire_n1lil_w_lg_n1liO1051w(0) <= n1liO OR n1l1O;
	PROCESS (tx_clk, wire_nl0OOO_PRN, soft_reset)
	BEGIN
		IF (wire_nl0OOO_PRN = '0') THEN
				nl00il <= '1';
				nl00iO <= '1';
				nl00li <= '1';
				nl00ll <= '1';
				nl00lO <= '1';
				nl00Oi <= '1';
				nl00Ol <= '1';
				nl00OO <= '1';
				nl0i0i <= '1';
				nl0i0l <= '1';
				nl0i0O <= '1';
				nl0i1i <= '1';
				nl0i1l <= '1';
				nl0i1O <= '1';
				nl0iii <= '1';
				nl0iil <= '1';
				nl0iiO <= '1';
				nl0ili <= '1';
				nl0ill <= '1';
				nl0ilO <= '1';
				nl0iOi <= '1';
				nl0iOl <= '1';
				nl0iOO <= '1';
				nl0l0i <= '1';
				nl0l0l <= '1';
				nl0l0O <= '1';
				nl0l1i <= '1';
				nl0l1l <= '1';
				nl0l1O <= '1';
				nl0lii <= '1';
				nl0lil <= '1';
				nl0liO <= '1';
				nl0lli <= '1';
				nl0lll <= '1';
				nl0llO <= '1';
				nl0lOi <= '1';
				nl0lOl <= '1';
				nl0lOO <= '1';
				nl0O0i <= '1';
				nl0O0l <= '1';
				nl0O0O <= '1';
				nl0O1i <= '1';
				nl0O1l <= '1';
				nl0O1O <= '1';
				nl0Oii <= '1';
				nl0Oil <= '1';
				nl0OiO <= '1';
				nl0Oli <= '1';
				nl0Oll <= '1';
				nl0OlO <= '1';
				nl0OOi <= '1';
				nl0OOl <= '1';
				nli11i <= '1';
		ELSIF (soft_reset = '1') THEN
				nl00il <= '0';
				nl00iO <= '0';
				nl00li <= '0';
				nl00ll <= '0';
				nl00lO <= '0';
				nl00Oi <= '0';
				nl00Ol <= '0';
				nl00OO <= '0';
				nl0i0i <= '0';
				nl0i0l <= '0';
				nl0i0O <= '0';
				nl0i1i <= '0';
				nl0i1l <= '0';
				nl0i1O <= '0';
				nl0iii <= '0';
				nl0iil <= '0';
				nl0iiO <= '0';
				nl0ili <= '0';
				nl0ill <= '0';
				nl0ilO <= '0';
				nl0iOi <= '0';
				nl0iOl <= '0';
				nl0iOO <= '0';
				nl0l0i <= '0';
				nl0l0l <= '0';
				nl0l0O <= '0';
				nl0l1i <= '0';
				nl0l1l <= '0';
				nl0l1O <= '0';
				nl0lii <= '0';
				nl0lil <= '0';
				nl0liO <= '0';
				nl0lli <= '0';
				nl0lll <= '0';
				nl0llO <= '0';