#####################################################################################
# Copyright (C) 1991-2009 Altera Corporation
# Any  megafunction  design,  and related netlist (encrypted  or  decrypted),
# support information,  device programming or simulation file,  and any other
# associated  documentation or information  provided by  Altera  or a partner
# under  Altera's   Megafunction   Partnership   Program  may  be  used  only
# to program  PLD  devices (but not masked  PLD  devices) from  Altera.   Any
# other  use  of such  megafunction  design,  netlist,  support  information,
# device programming or simulation file,  or any other  related documentation
# or information  is prohibited  for  any  other purpose,  including, but not
# limited to  modification,  reverse engineering,  de-compiling, or use  with
# any other  silicon devices,  unless such use is  explicitly  licensed under
# a separate agreement with  Altera  or a megafunction partner.  Title to the
# intellectual property,  including patents,  copyrights,  trademarks,  trade
# secrets,  or maskworks,  embodied in any such megafunction design, netlist,
# support  information,  device programming or simulation file,  or any other
# related documentation or information provided by  Altera  or a megafunction
# partner, remains with Altera, the megafunction partner, or their respective
# licensors. No other licenses, including any licenses needed under any third
# party's intellectual property, are provided herein.
#####################################################################################

#####################################################################################
# Altera Triple-Speed Ethernet Megacore SDC file for use with the Quartus II 
# TimeQuest Timing Analyzer
#
# To add this SDC file to your Quartus II project execute the following TCL
# command in the Quartus II TCL console:
# set_global_assignment -name SDC_FILE altera_ethernet_constraints.sdc
#
# Generated on Fri Dec 14 10:44:50 MYT 2012
#
#####################################################################################





# *************************************************************
# Customer modifiable constraints, value is set default by constraints
# *************************************************************

# Hierarchical path to the TSE
set SYSTEM_PATH_PREFIX ""

# Frequency of network-side interface clocks or reference clocks
set TSE_CLOCK_FREQUENCY "125 MHz"

# Frequency of FIFO data interface clocks
set FIFO_CLOCK_FREQUENCY "100 MHz"

# Frequency of control and status interface clock
set DEFAULT_SYSTEM_CLOCK_SPEED "66 MHz"  

# Frequency of phase measure clock
set PHASE_MEASURE_CLOCK_SPEED "66 MHz"   

# Name the clocks that will be coming into the tse core named changed from top level   
set  TX_CLK             "tx_clk"                        
set  RX_CLK             "rx_clk"                        
set  CLK                "clk"
set  FF_TX_CLK          "ff_tx_clk"
set  FF_RX_CLK          "ff_rx_clk"
set  TBI_TX_CLK         "tbi_tx_clk"
set  TBI_RX_CLK         "tbi_rx_clk"
set  REF_CLK            "ref_clk"
set  PCS_PHASE_MEASURE_CLK "pcs_phase_measure_clk"





# **************************************************************************************************
# ********************** Please do not modify anything beyond this line ****************************
# *********** The script might not work correctly if the following lines are modified **************
# **************************************************************************************************

# Generated TSE variation - Do not modify
# General Option
set IS_SOPC 0
set VARIATION_NAME "altera_ethernet"
set DEVICE_FAMILY "ARRIAV"

# MAC Option
set IS_MAC 1
set NUMBER_OF_CHANNEL 1
set IS_SMALLMAC 0
set IS_SMALLMAC_GIGE 0
set IS_FIFOLESS 0
set IS_HALFDUPLEX 32
set MII_INTERFACE "MII_GMII"
set ENA_HASH 1
set ENABLE_MAGIC_DETECT 1
set STAT_CNT_ENA 1
set ENABLE_EXTENDED_STAT_REG 1
set ENABLE_SUP_ADDR 1
set ENABLE_MAC_FLOW_CTRL 1

# PCS Option
set IS_PCS 1
set IS_SGMII 1

# PMA Option
set IS_PMA 1
set TRANSCEIVER_TYPE 0

# GXB Option
set IS_POWERDOWN 0

# 1588 Option
set IS_1588	0


   
if { [ expr ($TRANSCEIVER_TYPE == 0)]} {
	set CLOCK_1  "U_RXCLK"
	set CLOCK_2 "U_TXCLK"
} else {
	set CLOCK_1 "U_RXCLK"
	set CLOCK_2 "U_TXCLK"
}

if { [ expr ($IS_SOPC == 1) ]} {
   set FROM_THE_VARIATION_NAME "_from_the_$VARIATION_NAME"
   set TO_THE_VARIATION_NAME "_to_the_$VARIATION_NAME"
} else {
   set FROM_THE_VARIATION_NAME ""
   set TO_THE_VARIATION_NAME ""
}


#**************************************************************
# Time Information
#**************************************************************
# Uncommenting the following derive_pll_clocks lines
# will instruct the TimeQuest Timing Analyzer to automatically
# create derived clocks for all PLL outputs for all PLLs in a
# Quartus design.

# If the PLL inputs and outputs are not constrained elsewhere, 
# uncomment the next line to automatically constrain all PLL input 
# and output clocks.

# derive_pll_clocks 

# If the PLL inputs and outputs are not constrained elsewhere,
# and derive_pll_clocks is not apply, user will get Critical warnings
# Critical Warning: Register-to-register paths between different clock 
# domains is not recommended if one of the clocks is from GXB 
# transmitter channel. 
# Critical Warning: Register-to-register paths between different clock 
# domains is not recommended if one of the clocks is from GXB 
# receiver channel.
# This Critical Warning can be safely ignore and it will gone if 
# PLL inputs and outputs clock are properly constraint. 

#**************************************************************
# Create Clock
#**************************************************************

#Constrain timing for half duplex logic
#  - Direct path as we are confirmed of this path
if { [ expr ( $IS_FIFOLESS == 0 )] } {

#  mac
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 0) && ($IS_PMA == 0)] } {
      #Constrain MAC control interface clock
      create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_${CLK}_$TO_THE_VARIATION_NAME [ get_ports  $CLK]

      #Constrain MAC FIFO data interface clocks
      create_clock -period "$FIFO_CLOCK_FREQUENCY" -name altera_tse_${FF_TX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $FF_TX_CLK]
      create_clock -period "$FIFO_CLOCK_FREQUENCY" -name altera_tse_${FF_RX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $FF_RX_CLK]

      #Constrain MAC network-side interface clocks
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${TX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $TX_CLK]
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${RX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $RX_CLK]
   }

   #  macPcs
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 0) ] } {
      #Constrain MAC PCS control interface clock
      create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_${CLK}_$TO_THE_VARIATION_NAME [ get_ports  $CLK]

      #Constrain MAC PCS FIFO data interface clocks
      create_clock -period "$FIFO_CLOCK_FREQUENCY" -name altera_tse_${FF_TX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $FF_TX_CLK]
      create_clock -period "$FIFO_CLOCK_FREQUENCY" -name altera_tse_${FF_RX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $FF_RX_CLK]

      #Constrain MAC PCS network-side interface clocks 
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${TBI_RX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $TBI_RX_CLK]
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${TBI_TX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $TBI_TX_CLK]
   }

   #  macPcsPma
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) ] } {

      #Constrain transceiver reference clock
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${REF_CLK}_$TO_THE_VARIATION_NAME [ get_ports  $REF_CLK]

      #Constrain MAC PCS control interface clock
      create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_${CLK}_$TO_THE_VARIATION_NAME [ get_ports  $CLK]

      #Constrain MAC PCS FIFO data interface clocks
      create_clock -period "$FIFO_CLOCK_FREQUENCY" -name altera_tse_${FF_TX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $FF_TX_CLK]
      create_clock -period "$FIFO_CLOCK_FREQUENCY" -name altera_tse_${FF_RX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $FF_RX_CLK]
   }

   #  pcs
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 0) ] } {

	  #Cut the timing path betweeen unrelated clock domains
	  
   }

   #  pcsPma
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 1) ] } {
      #Constrain PCS control interface clock
      create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_${CLK}_$TO_THE_VARIATION_NAME [ get_ports $CLK]

      #Constrain transceiver reference clock
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${REF_CLK}_$TO_THE_VARIATION_NAME [ get_ports  $REF_CLK]
   }

   #  macPcsSgmii
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 0) && ($IS_SGMII == 1)] } {
   }

   # macPcsNoSgmii
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 0) && ($IS_SGMII == 0)] } {

   }

   #  macPcsPmaSgmii
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1)] } {
   }

   #  macPcsPmaNoSgmii
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 0)] } {
   }

   #  pmaAlt4Gxb
   if { [expr ($TRANSCEIVER_TYPE == 0) && ($IS_PMA == 1) && (([string match $DEVICE_FAMILY "STRATIXIV"]) || ([string match $DEVICE_FAMILY "ARRIAIIGX"]) || ([string match $DEVICE_FAMILY "HARDCOPYIV"]) ) ] } {
   }

   #  pcsSgmii
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 0) && ($IS_SGMII == 1)] } {
      #Constrain PCS GMII/MII interface clocks 
      create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_REG_CLK_$TO_THE_VARIATION_NAME [ get_ports reg_clk]
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${TBI_RX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $TBI_RX_CLK]
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${TBI_TX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $TBI_TX_CLK]
    }

   #  pcsNoSgmii
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 0) && ($IS_SGMII == 0)] } {
      #Constrain PCS control interface clock
      create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_REG_CLK_$TO_THE_VARIATION_NAME [ get_ports reg_clk]

      #Constrain PCS network-side interface clocks
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${TBI_RX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $TBI_RX_CLK]
      create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_${TBI_TX_CLK}_$TO_THE_VARIATION_NAME [ get_ports $TBI_TX_CLK]
	  
   }

   #  pcsPmaSgmii
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1)] } {
      #Constrain PCS GMII/MII interface clocks 
   } 
   

   #  pcsPmaNoSgmii
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1)] } {
   }

   #  macPcsPmaLvdsSgmii
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1) && ($TRANSCEIVER_TYPE == 1)] } {
     #Cut the timing path betweeen unrelated clock domains
   }

   #  macPcsPmaLvdsNoSgmii
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 0) && ($TRANSCEIVER_TYPE == 1)] } {
   }

   #  macPcsPmaTransceiverSgmii=
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1) && ($TRANSCEIVER_TYPE == 0) && (([string match $DEVICE_FAMILY "STRATIXIIGX"]) || ([string match $DEVICE_FAMILY "ARRIAGX"]))] } {

   }

   #  macPcsPmaTransceiverNoSgmii=
   if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 0) && ($TRANSCEIVER_TYPE == 0) && (([string match $DEVICE_FAMILY "STRATIXIIGX"]) || ([string match $DEVICE_FAMILY "ARRIAGX"]))] } {

   }

   #  pcsPmaLvdsSgmii=
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1) && ($TRANSCEIVER_TYPE == 1)] } {
   }

   #  pcsPmaLvdsNoSgmii
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 0) && ($TRANSCEIVER_TYPE == 1)] } {
   }

   #  pcsPmaTransceiverSgmii
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1) && ($TRANSCEIVER_TYPE == 0) && (([string match $DEVICE_FAMILY "STRATIXIIGX"]) || ([string match $DEVICE_FAMILY "ARRIAGX"])) ] } {
   }

   #  pcsPmaTransceiverNoSgmii
   if { [ expr ($IS_MAC == 0) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 0) && ($TRANSCEIVER_TYPE == 0) && (([string match $DEVICE_FAMILY "STRATIXIIGX"]) || ([string match $DEVICE_FAMILY "ARRIAGX"]))] } {
   }

} else {

#  multiChannelFifoless


#**************************************************************
# Set Parameter
#**************************************************************
#**************************************************************

#**************************************************************
# Create Clock
#**************************************************************
#**************************************************************

#All clocks used by TSE is named with prefix "altera_tse"
#Constrain MAC PCS control interface clock

if { [ expr $IS_SOPC == 0 ] } {
	create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_sys_clk [ get_ports "$CLK"]
}

if { [ expr ($IS_FIFOLESS == 1) ] } {
   for {set x 0} {$x < $NUMBER_OF_CHANNEL} {incr x} {
   		if { [ expr ($IS_SOPC == 0) ] } {
			create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_mac_tx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}mac_tx_clk_${x}${FROM_THE_VARIATION_NAME}" ]
			create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_mac_rx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}mac_rx_clk_${x}${FROM_THE_VARIATION_NAME}" ]
		} else {
			create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_mac_tx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}${VARIATION_NAME}_mac_rx_clk_${x}_out" ]
			create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_mac_rx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}${VARIATION_NAME}_mac_tx_clk_${x}_out" ]
		}
   }
}

# Mac
if { [ expr ($IS_FIFOLESS == 1) && ($IS_MAC == 1) && ($IS_PCS == 0) && ($IS_PMA == 0) ] } {
   for {set x 0} {$x < $NUMBER_OF_CHANNEL} {incr x} {
		create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_tx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}tx_clk_${x}$TO_THE_VARIATION_NAME" ]
		create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_rx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}rx_clk_${x}$TO_THE_VARIATION_NAME" ]
   }}

# MacPcs
if { [ expr ($IS_FIFOLESS == 1) && ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 0) ] } {
   for {set x 0} {$x < $NUMBER_OF_CHANNEL} {incr x} {
		create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_tbi_tx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}tbi_tx_clk_${x}$TO_THE_VARIATION_NAME" ]
		create_clock -period "$TSE_CLOCK_FREQUENCY" -name "altera_tse_tbi_rx_clk_${x}" [ get_ports "${SYSTEM_PATH_PREFIX}tbi_rx_clk_${x}$TO_THE_VARIATION_NAME" ]
   }}

# MacPcsPma
if { [ expr ($IS_FIFOLESS == 1) && ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) ] } {
	#Constrain transceiver reference clock
	create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_ref_clk [ get_ports  "${SYSTEM_PATH_PREFIX}ref_clk$TO_THE_VARIATION_NAME" ]
}

# MacPcs+SGMII
if { [ expr ($IS_FIFOLESS == 1) && ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 0) && ($IS_SGMII == 1)] } {
	#Constrain transceiver reference clock
	create_clock -period "$TSE_CLOCK_FREQUENCY" -name altera_tse_ref_clk [ get_ports  "${SYSTEM_PATH_PREFIX}ref_clk$TO_THE_VARIATION_NAME" ]
}

# MacPcs+SGMII ( with or without PMA )
if { [ expr ($IS_FIFOLESS == 1) && ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_SGMII == 1)] } {

}

#  pmaAlt4Gxb
if { [expr ($TRANSCEIVER_TYPE == 0) && ($IS_PMA == 1) && (([string match $DEVICE_FAMILY "STRATIXIV"]) || ([string match $DEVICE_FAMILY "ARRIAIIGX"]) || ([string match $DEVICE_FAMILY "HARDCOPYIV"]) ) ] } {
  
}

#  macPcsPmaLvdsSgmii
if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1) && ($TRANSCEIVER_TYPE == 1)] } {
	#Cut the timing path betweeen unrelated clock domains
}

#  macPcsPmaLvdsNoSgmii
if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 0) && ($TRANSCEIVER_TYPE == 1)] } {
}

#  macPcsPmaTransceiverSgmii=
if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 1) && ($TRANSCEIVER_TYPE == 0) && (([string match $DEVICE_FAMILY "STRATIXIIGX"]) || ([string match $DEVICE_FAMILY "ARRIAGX"]))] } {
	#Cut the timing path betweeen unrelated clock domains
}

#  macPcsPmaTransceiverNoSgmii=
if { [ expr ($IS_MAC == 1) && ($IS_PCS == 1) && ($IS_PMA == 1) && ($IS_SGMII == 0) && ($TRANSCEIVER_TYPE == 0) && (([string match $DEVICE_FAMILY "STRATIXIIGX"]) || ([string match $DEVICE_FAMILY "ARRIAGX"]))] } {
	#Cut the timing path betweeen unrelated clock domains
}

if { [ expr ($IS_SOPC == 0) ] } {
	if { [ expr ($IS_FIFOLESS == 1) ] } {
		create_clock -period "$DEFAULT_SYSTEM_CLOCK_SPEED" -name altera_tse_rx_afull_clk  [get_ports "${SYSTEM_PATH_PREFIX}rx_afull_clk$TO_THE_VARIATION_NAME" ]
	}
}

if { [ expr $IS_1588 == 1 ] } {
	create_clock -period "$PHASE_MEASURE_CLOCK_SPEED" -name altera_tse_pcs_phase_measure_clk [ get_ports "$PCS_PHASE_MEASURE_CLK"]
}

#**************************************************************
# Set False Path
#**************************************************************
if { [ expr ($IS_SGMII == 1)] } {
    set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_DSW|altera_tse_gray_cnt:U_RD|g_out[*]}] -to [get_registers {*|altera_tse_a_fifo_24:U_DSW|rd_g_wptr[*]}]
    set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_DSW|altera_tse_gray_cnt:U_RD|b_out[*]}] -to [get_registers {*|altera_tse_a_fifo_24:U_DSW|rd_g_wptr[*]}]
    set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_DSW|altera_tse_gray_cnt:U_WRT|g_out[*]}] -to [get_registers {*|altera_tse_a_fifo_24:U_DSW|wr_g_rptr[*]}]
    set_false_path -from [get_registers {*|altera_tse_top_sgmii*:U_SGMII|altera_tse_colision_detect:U_COL|state*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|gm_rx_col_reg*}]
}

}

if { [ expr ($IS_HALFDUPLEX == 8) ] } {
#Constrain timing for half duplex logic
   if { [ expr ($IS_FIFOLESS == 0) ] } {
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_altsyncram_dpm_fifo:U_RTSM|altsyncram*] -to [ get_registers *]
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*] -to [ get_registers *]
      set_multicycle_path -setup 5 -from [ get_registers *] -to [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*]
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_a_fifo_opt*:TX_DATA|altera_tse_altsyncram_dpm_fifo:U_RAM*|altsyncram*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_altsyncram_dpm_fifo:U_RTSM|altsyncram*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *] -to [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*]
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_a_fifo_opt*:TX_DATA|altera_tse_altsyncram_dpm_fifo:U_RAM*|altsyncram*] -to [ get_registers *]
      set_max_delay 7.5 -from [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_a_fifo_opt*:TX_DATA|altera_tse_altsyncram_dpm_fifo:U_RAM*|altsyncram*] -to [get_registers *|altera_tse_mac_tx:U_TX|eop[1]]
      set_max_delay 7.5 -from [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_a_fifo_opt*:TX_DATA|altera_tse_altsyncram_dpm_fifo:U_RAM*|altsyncram*] -to [get_registers *|altera_tse_mac_tx:U_TX|sop[1]]
      set_max_delay 7.5 -from [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_a_fifo_opt*:TX_DATA|altera_tse_altsyncram_dpm_fifo:U_RAM*|altsyncram*] -to [get_registers  *|altera_tse_mac_tx:U_TX|rd_1[*]]
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|*col*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|*col*] -to [ get_registers *]
   }
}

if { [ expr ($IS_HALFDUPLEX == 32) ] } {
#Constrain timing for half duplex logic
   if { [ expr ($IS_FIFOLESS == 0) ] } {
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_altsyncram_dpm_fifo:U_RTSM|altsyncram*] -to [ get_registers *]
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*] -to [ get_registers *]
      set_multicycle_path -setup 5 -from [ get_registers *] -to [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*]
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_altsyncram_dpm_fifo:U_RTSM|altsyncram*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *] -to [ get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|altera_tse_retransmit_cntl:U_RETR|*]
      set_max_delay 7 -from [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|dout_reg_sft*] -to [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_top_1geth:U_GETH|altera_tse_mac_tx:U_TX|*]
      set_max_delay 7 -from [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|eop_sft*] -to [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_top_1geth:U_GETH|altera_tse_mac_tx:U_TX|*]
      set_max_delay 7 -from [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_tx_min_ff:U_TXFF|sop_reg*] -to [get_registers *|altera_tse_top_w_fifo:U_MAC|altera_tse_top_1geth:U_GETH|altera_tse_mac_tx:U_TX|*]
   }
}

if { [ expr ($IS_HALFDUPLEX == 8) ] } {
#Constrain timing for half duplex logic
   if { [ expr ($IS_FIFOLESS == 1) ] } {
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_fifoless_mac_tx:U_TX|altera_tse_altsyncram_dpm_fifo:U_RTSM|altsyncram*] -to [ get_registers *]
      set_multicycle_path -setup 5 -from [ get_registers *|altera_tse_fifoless_mac_tx:U_TX|altera_tse_retransmit_cntl:U_RETR|*] -to [ get_registers *]
      set_multicycle_path -setup 5 -from [ get_registers *] -to [ get_registers *|altera_tse_fifoless_mac_tx:U_TX|altera_tse_retransmit_cntl:U_RETR|*]
      
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_fifoless_mac_tx:U_TX|altera_tse_altsyncram_dpm_fifo:U_RTSM|altsyncram*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *|altera_tse_fifoless_mac_tx:U_TX|altera_tse_retransmit_cntl:U_RETR|*] -to [ get_registers *]
      set_multicycle_path -hold 5 -from [ get_registers *] -to [ get_registers *|altera_tse_fifoless_mac_tx:U_TX|altera_tse_retransmit_cntl:U_RETR|*]
   }
}

# False paths for MAC registers
if {[expr ($IS_MAC == 1)]} {
   if {[expr ($IS_FIFOLESS == 0)]} {
      if {[expr $IS_SMALLMAC == 1]} {
         # Small MAC
         set_false_path -from [get_registers {*|altera_tse_register_map_small:U_REG|command_config[9]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_register_map_small:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_register_map_small:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
   
         set_false_path -from [get_registers {*|altera_tse_register_map_small:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
         set_false_path -from [get_registers {*|altera_tse_register_map_small:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
      } else {
         # MAC with FIFO
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[9]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
   
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|frm_length[*]}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
   
         if {[expr ($ENABLE_SUP_ADDR == 1)]} {
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[16]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[17]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[18]}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
   
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_0*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_1*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_2*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_3*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
   
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_0*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_1*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_2*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_3*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|*}]
   
         }
   
         if {[expr ($ENABLE_MAC_FLOW_CTRL == 1)]} {
            set_false_path -from [get_registers *|altera_tse_mac_rx:*|pause_quant_val*] -to [get_registers *|altera_tse_mac_tx:*|pause_latch*]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|pause_quant_reg*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|pause_quant_reg*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|holdoff_quant*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|*}]
         }

         # Magic packet detection 
         if {[expr ($ENABLE_MAGIC_DETECT == 1)]} {
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]

            if {[expr ($ENABLE_SUP_ADDR == 1)]} {
               set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_0*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
               set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_1*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
               set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_2*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
               set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|smac_3*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
            }
         }
      }
   } else {
      # MAC without FIFO
      set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|command_config[9]}] -to [get_registers {*altera_tse_fifoless_mac_tx:U_TX|*}]
      set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
      set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
   
      set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_fifoless_mac_rx:U_RX|*}]
      set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_fifoless_mac_rx:U_RX|*}]
      set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|frm_length[*]}] -to [get_registers {*|altera_tse_fifoless_mac_rx:U_RX|*}]

      if {[expr ($ENABLE_SUP_ADDR == 1)]} {
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|command_config[16]}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|command_config[17]}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|command_config[18]}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
   
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_0*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_1*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_2*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_3*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
   
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_0*}] -to [get_registers {*|altera_tse_fifoless_mac_rx:U_RX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_1*}] -to [get_registers {*|altera_tse_fifoless_mac_rx:U_RX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_2*}] -to [get_registers {*|altera_tse_fifoless_mac_rx:U_RX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_3*}] -to [get_registers {*|altera_tse_fifoless_mac_rx:U_RX|*}]
      }

      if {[expr ($ENABLE_MAC_FLOW_CTRL == 1)]} {
         set_false_path -from [get_registers *|altera_tse_fifoless_mac_rx:*|pause_quant_val*] -to [get_registers *|altera_tse_fifoless_mac_tx:*|pause_latch*]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|pause_quant_reg*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|pause_quant_reg*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|holdoff_quant*}] -to [get_registers {*|altera_tse_fifoless_mac_tx:U_TX|*}]

      }

      # Magic packet detection 
      if {[expr ($ENABLE_MAGIC_DETECT == 1)]} {
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|mac_0[*]}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
         set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|mac_1[*]}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]

         if {[expr ($ENABLE_SUP_ADDR == 1)]} {
            set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_0*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
            set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_1*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
            set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_2*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
            set_false_path -from [get_registers {*|altera_tse_shared_register_map:U_REG|smac_3*}] -to [get_registers {*|altera_tse_magic_detection:U_MAGIC|*}]
         }
      }
   }
}

# PCS PMA LVDS false paths
if {[expr ($IS_PCS == 1) && ($IS_PMA == 1)]} {
   # LVDS IO
   if {[expr ($TRANSCEIVER_TYPE) == 1]} {
      if {[expr ($IS_MAC == 1)]} {
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[13]*}] -to [get_registers {*|altera_tse_rx_min_ff:U_RXFF|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[26]*}] -to [get_registers {*|altera_tse_rx_min_ff:U_RXFF|err_frm_disc_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[19]*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|magic_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[2]*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|xon_gen_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[22]*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|xoff_gen_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[15]*}] -to [get_registers {*|altera_tse_lb_wrt_cntl:U_LBW|loopback_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[5]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|user_p_lgth_inf_46_reg[0]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[5]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|vlan_p_lgth_inf_42_reg[0]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_hashing:U_HSH|hash_bit_1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_hashing:U_HSH|hash_bit_2*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_hashing:U_HSH|hash_code[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|mc_hash_calc*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|tx_command_status[18]*}] -to [get_registers {*|altera_tse_tx_min_ff:U_TXFF|tx_shift16_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[21]*}] -to [get_registers {*|altera_tse_register_map:U_REG|reg_data_out[21]*}]
   
         set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_LBFF|altera_tse_gray_cnt:U_RD|g_out[*]*}] -to [get_registers {*|altera_tse_a_fifo_24:U_LBFF|rd_g_wptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_tse_rx_counter_cntl:U_RXCNT|msb_aOctetsReceivedOK_reg[*]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsReceivedOK[*]*}]
         set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_LBFF|altera_tse_gray_cnt:U_WRT|g_out[*]*}] -to [get_registers {*|altera_tse_a_fifo_24:U_LBFF|wr_g_rptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|etherstatsoctets_reg[*]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_etherstatsoctets[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mac_rx:U_RX|pause_quant_avb_s[*]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|pause_quant_avb_s[2]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_etherstatsoctets[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsReceivedOK[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsTransmittedOK[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|shadow_etherstatsoctets*}]
   
         set_false_path -from [get_registers {*|altera_tse_tx_counter_cntl:U_TXCNT|sw_reset_done*}] -to [get_registers {*|altera_tse_register_map:U_REG|tx_cnt_done_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_rx_counter_cntl:U_RXCNT|sw_reset_done*}] -to [get_registers {*|altera_tse_register_map:U_REG|rx_cnt_done_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_a_fifo_34:RX_STATUS|wr_g_ptr_reg[*]*}] -to [get_registers {*|altera_tse_a_fifo_34:RX_STATUS|wr_g_rptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|sleep_ena*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|sleep_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_clk_cntl:U_CLKCT|tx_ethernet_mode_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_clk_cntl:U_CLKCT|rx_ethernet_mode_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_gmii_io:U_GMIF|ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_mii_tx_if:U_MTX|enan_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_tx_counter_cntl:U_TXCNT|msb_aOctetsTransmittedOK_reg[*]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsTransmittedOK[*]*}]
         
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|an_enable*}] -to [get_registers {*|altera_tse_top_1000_base_x:top_1000_base_x_inst|gmii_rx_d[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|an_enable*}] -to [get_registers {*|altera_tse_top_1000_base_x:top_1000_base_x_inst|gmii_rx_dv*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|an_enable*}] -to [get_registers {*|altera_tse_top_1000_base_x:top_1000_base_x_inst|gmii_rx_err*}]
         set_false_path -from [get_registers {*|altera_tse_lvds_reset_sequencer:the_altera_tse_lvds_reset_sequencer|rx_reset_sequence_done*}] -to [get_registers {*altera_tse_mac_pcs_pma:altera_tse_mac_pcs_pma_inst|tbi_rx_d_flip[*]*}]
   
         if {[expr ($IS_SGMII == 1)]} {
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|hd_ena*}] -to [get_registers {*|altera_tse_tx_min_ff:U_TXFF|half_duplex_ena_reg1*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[11]*}] -to [get_registers {*|altera_tse_register_map:U_REG|reg_data_out[11]*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[12]*}] -to [get_registers {*|altera_tse_register_map:U_REG|reg_data_out[12]*}]
         }
         #Reset Path
         set_false_path -from [get_registers {*altera_tse_mac_pcs_pma:altera_tse_mac_pcs_pma_inst|altera_tse_reset_synchronizer:reset_sync_0|altera_tse_reset_synchronizer_chain_out*}] -to [get_registers {*altera_tse_mac_pcs_pma:altera_tse_mac_pcs_pma_inst|altera_tse_lvds_reset_sequencer:the_altera_tse_lvds_reset_sequencer|*}]
   
      } else {
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|an_enable*}] -to [get_registers {*|altera_tse_top_1000_base_x:altera_tse_top_1000_base_x_inst|gmii_rx_d[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|an_enable*}] -to [get_registers {*|altera_tse_top_1000_base_x:altera_tse_top_1000_base_x_inst|gmii_rx_dv*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|an_enable*}] -to [get_registers {*|altera_tse_top_1000_base_x:altera_tse_top_1000_base_x_inst|gmii_rx_err*}]
         set_false_path -from [get_registers {*|altera_tse_lvds_reset_sequencer:the_altera_tse_lvds_reset_sequencer|rx_reset_sequence_done*}] -to [get_registers {*altera_tse_pcs_pma:altera_tse_pcs_pma_inst|tbi_rx_d_flip*}]
      }
   
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|link_timer_reg*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|dev_ability*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_dec10b8b:U_DECOD|sw_reset_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_top_rx:U_RX|rx_detect_int*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_enc8b10b:U_ENCOD|sw_reset_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|tx_rd_ack3*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|reg_tx_rd_ack_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|state.STM_TYPE_TX_READ*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|tx_rd_ack0*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|state.STM_TYPE_TX_READ*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|tx_rd_ack1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_req*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_ack0*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_req*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_ack1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|reg_sel[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|reg_sel_rx_clk1[*]*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l_reg2*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_rxck_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|hold_reg_rx_clk[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|reg_dout[*]*}]
      set_false_path -from [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_ack*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|an_ack_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_restart_rst_i*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|mdio_control[9]*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|page_receive_l*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_rx_sync:U_SYNC|sync_acqurd*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|link_status_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_done*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|an_done_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_ack3*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|reg_rx_rd_ack_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_top_tx:U_TX|sw_reset_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_rx_encapsulation:U_FRM|sw_reset_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_rx_sync:U_SYNC|sw_reset_reg1*}]
      
      if {[expr ($IS_SGMII == 1)]} {
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_carrier_sense:U_SENSE|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_colision_detect:U_COL|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_rx_converter:U_RXC|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_tx_converter:U_TXCV|eth_speed_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_top_tx_converter:U_TXCV|eth_speed_reg1_macclk[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_top_tx_converter:U_TXCV|eth_speed_reg1_pcsclk[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_sgmii_clk_enable:U_TXCLK_ENA|ethernet_mode_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_rx_converter:U_RXC|eth_speed_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_sgmii_clk_enable:U_RXCLK_ENA|ethernet_mode_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_duplex*}] -to [get_registers {*|altera_tse_colision_detect:U_COL|hd_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|partner_ability[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_duplex*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|partner_ability[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mii_tx_if_pcs:U_RXMII|mii_txdv*}] -to [get_registers {*|altera_tse_carrier_sense:U_SENSE|receive_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_rx_encapsulation:U_FRM|receive*}] -to [get_registers {*|altera_tse_carrier_sense:U_SENSE|receive_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_top_rx:U_RX|gmii_rxdv*}] -to [get_registers {*|altera_tse_carrier_sense:U_SENSE|receive_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_top_rx:U_RX|gmii_rxdv*}] -to [get_registers {*|altera_tse_colision_detect:U_COL|receive_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|if_mode[0]*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_ability_out[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|if_mode[5]*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_ability_out[*]*}]
   
      }
   } else {
   # GXB  
      if {[expr ($IS_MAC == 1)]} {
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[13]*}] -to [get_registers {*|altera_tse_rx_min_ff:U_RXFF|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[26]*}] -to [get_registers {*|altera_tse_rx_min_ff:U_RXFF|err_frm_disc_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[19]*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|magic_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[2]*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|xon_gen_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[22]*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|xoff_gen_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[15]*}] -to [get_registers {*|altera_tse_lb_wrt_cntl:U_LBW|loopback_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[5]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|user_p_lgth_inf_46_reg[0]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[5]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|vlan_p_lgth_inf_42_reg[0]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_hashing:U_HSH|hash_bit_1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_hashing:U_HSH|hash_bit_2*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_hashing:U_HSH|hash_code[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[14]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|mc_hash_calc*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|tx_command_status[18]*}] -to [get_registers {*|altera_tse_tx_min_ff:U_TXFF|tx_shift16_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[21]*}] -to [get_registers {*|altera_tse_register_map:U_REG|reg_data_out[21]*}]
   
         set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_LBFF|altera_tse_gray_cnt:U_RD|g_out[*]*}] -to [get_registers {*|altera_tse_a_fifo_24:U_LBFF|rd_g_wptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_tse_rx_counter_cntl:U_RXCNT|msb_aOctetsReceivedOK_reg[*]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsReceivedOK[*]*}]
         set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_LBFF|altera_tse_gray_cnt:U_WRT|g_out[*]*}] -to [get_registers {*|altera_tse_a_fifo_24:U_LBFF|wr_g_rptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|etherstatsoctets_reg[*]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_etherstatsoctets[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mac_rx:U_RX|pause_quant_avb_s[*]*}] -to [get_registers {*|altera_tse_mac_rx:U_RX|pause_quant_avb_s[2]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_etherstatsoctets[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsReceivedOK[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsTransmittedOK[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|altera_std_synchronizer:U_SYNC_3|dreg[1]*}] -to [get_registers {*|altera_tse_register_map:U_REG|shadow_etherstatsoctets*}]
   
         set_false_path -from [get_registers {*|altera_tse_tx_counter_cntl:U_TXCNT|sw_reset_done*}] -to [get_registers {*|altera_tse_register_map:U_REG|tx_cnt_done_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_rx_counter_cntl:U_RXCNT|sw_reset_done*}] -to [get_registers {*|altera_tse_register_map:U_REG|rx_cnt_done_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_a_fifo_34:RX_STATUS|wr_g_ptr_reg[*]*}] -to [get_registers {*|altera_tse_a_fifo_34:RX_STATUS|wr_g_rptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|sleep_ena*}] -to [get_registers {*|altera_tse_mac_tx:U_TX|sleep_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_clk_cntl:U_CLKCT|tx_ethernet_mode_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_clk_cntl:U_CLKCT|rx_ethernet_mode_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_gmii_io:U_GMIF|ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|ethernet_mode*}] -to [get_registers {*|altera_tse_mii_tx_if:U_MTX|enan_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_tx_counter_cntl:U_TXCNT|msb_aOctetsTransmittedOK_reg[*]*}] -to [get_registers {*|altera_tse_register_map:U_REG|msb_aOctetsTransmittedOK[*]*}]
         
         if {[expr ($IS_SGMII == 1)]} {
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|hd_ena*}] -to [get_registers {*|altera_tse_tx_min_ff:U_TXFF|half_duplex_ena_reg1*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[11]*}] -to [get_registers {*|altera_tse_register_map:U_REG|reg_data_out[11]*}]
            set_false_path -from [get_registers {*|altera_tse_register_map:U_REG|command_config[12]*}] -to [get_registers {*|altera_tse_register_map:U_REG|reg_data_out[12]*}]
         }
      } else {
      }

      set_false_path -from [get_registers {*|altera_tse_gxb_aligned_rxsync:the_altera_tse_gxb_aligned_rxsync|alt_sync_reg2*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|link_status_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_rx_encapsulation_strx_gx:U_RCAPS|sw_reset_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|link_timer_reg*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|dev_ability*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|tx_rd_ack3*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|reg_tx_rd_ack_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|state.STM_TYPE_TX_READ*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|tx_rd_ack0*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|state.STM_TYPE_TX_READ*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|tx_rd_ack1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_req*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_ack0*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_req*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_ack1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|reg_sel[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|reg_sel_rx_clk1[*]*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l_reg2*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_rxck_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|hold_reg_rx_clk[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|reg_dout[*]*}]
      set_false_path -from [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_ack*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|an_ack_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_restart_rst_i*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|mdio_control[9]*}]
      set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|page_receive_l*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|page_rcv_l_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_done*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|an_done_reg1*}]
      set_false_path -from [get_registers {*|altera_tse_pcs_host_control:U_CTRL|rx_rd_ack3*}] -to [get_registers {*|altera_tse_pcs_host_control:U_CTRL|reg_rx_rd_ack_reg1*}]
      
      if {[expr ($IS_SGMII == 1)]} {
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_carrier_sense:U_SENSE|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_top_pcs_strx_gx:U_PCS|altera_tse_carrier_sense:U_SENS|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_colision_detect:U_COL|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sw_reset*}] -to [get_registers {*|altera_tse_rx_converter:U_RXC|sw_reset_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_tx_converter:U_TXCV|eth_speed_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_sgmii_clk_enable:U_TXCLK_ENA|ethernet_mode_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_rx_converter:U_RXC|eth_speed_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_sgmii_clk_enable:U_RXCLK_ENA|ethernet_mode_reg1[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_top_tx_converter:U_TXCV|eth_speed_reg1_macclk[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}] -to [get_registers {*|altera_tse_top_tx_converter:U_TXCV|eth_speed_reg1_pcsclk[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_duplex*}] -to [get_registers {*|altera_tse_colision_detect:U_COL|hd_ena_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|partner_ability[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_duplex*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|partner_ability[*]*}] -to [get_registers {*|altera_tse_mdio_reg:U_REG|sgmii_speed[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mii_tx_if_pcs:U_RXMII|mii_txdv*}] -to [get_registers {*|altera_tse_carrier_sense:U_SENSE|receive_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|if_mode[0]*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_ability_out[*]*}]
         set_false_path -from [get_registers {*|altera_tse_mdio_reg:U_REG|if_mode[5]*}] -to [get_registers {*|altera_tse_top_autoneg:U_AUTONEG|an_ability_out[*]*}]
         set_false_path -from [get_registers {*|altera_tse_top_sgmii_strx_gx:U_SGMII|altera_tse_top_rx_converter:U_RXCV|altera_tse_a_fifo_24:U_DSW|altera_tse_gray_cnt:U_RD|g_out[*]*}] -to [get_registers {*|altera_tse_top_sgmii_strx_gx:U_SGMII|altera_tse_top_rx_converter:U_RXCV|altera_tse_a_fifo_24:U_DSW|rd_g_wptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_a_fifo_24:U_DSW|altera_tse_gray_cnt:U_WRT|g_out[*]*}] -to [get_registers {*|altera_tse_a_fifo_24:U_DSW|wr_g_rptr[*]*}]
         set_false_path -from [get_registers {*|altera_tse_rx_encapsulation_strx_gx:U_RCAPS|gmii_dv*}] -to [get_registers {*|altera_tse_colision_detect:U_COL|receive_reg1*}]
         set_false_path -from [get_registers {*|altera_tse_rx_encapsulation_strx_gx:U_RCAPS|gmii_dv*}] -to [get_registers {*|altera_tse_rx_fifo_rd:U_FFRD|pcs_dv_macclk*}]
         set_false_path -from [get_registers {*|altera_tse_rx_encapsulation_strx_gx:U_RCAPS|receive*}] -to [get_registers {*|altera_tse_carrier_sense:U_SENS|receive_reg1*}]
      }
   }
}

