###23/10/2025
##rev2  --changes ---> updated script based on latest changes.
#####
package provide spll::pll_calculations 1.0.0


namespace eval ::spll::pll_calculations:: {


 variable  max_fht_ref   380000000
 variable  min_fht_ref   100000000


#   constraint pll_0_f_max_pfd_hz_rule { pll_0_f_max_pfd_hz == 36'd400000000; }
#   constraint pll_0_f_max_ref_hz_rule { pll_0_f_max_ref_hz == 36'd380000000; }
#   constraint pll_0_f_max_vco_hz_rule { pll_0_f_max_vco_hz == 36'd6650000000; }
#   constraint pll_0_f_min_pfd_hz_rule { pll_0_f_min_pfd_hz == 36'd20000000; }
#   constraint pll_0_f_min_ref_hz_rule { pll_0_f_min_ref_hz == 36'd100000000; }
#   constraint pll_0_f_min_vco_hz_rule { pll_0_f_min_vco_hz == 36'd3500000000; }
                     # 1000000 = 1 MHz
 variable  max_ref   380000000
 variable  min_ref   25000000
 variable  max_pfd   400000000
 variable  min_pfd    20000000
 variable  max_vco  4000000000
#6650000000
 variable  min_vco  1500000000
#3500000000


# pll_0_f_out_c2_hz <= 36'd450000000;
# pll_0_f_out_c2_hz >= 36'd250000000;
                     # 1000000 = 1 MHz
 variable  max_C0   1000000000   
 variable  max_C2    450000000   
 variable  min_C2    250000000   

 variable  tolerance_hz    512

# `define mod_freq_limit_hz 36'd600000000
 variable  mod_freq_limit_hz    600000000.0

# `define fastref_break_freq_hz 36'd200000000
 variable  fastref_break_freq_hz    200000000


 ### Use counter bit-widths as max value.  
 #     (checking for < , so dont need -1
 # pll_0_c0_counter inside {[1:1023]};
 # pll_0_c1_counter == 2 * pll_0_c0_counter;
 # pll_0_c2_counter inside {[1:2047]};
 variable  max_c0_counter [expr 2**11]
 variable  max_c2_counter [expr 2**11]
 variable  max_m_counter  [expr 2**10]
 variable  max_n_counter  [expr 2**4]



  dict set Presets refclk {
      ETHERNET_FREQ_805_156  156.250000  \
      ETHERNET_FREQ_805_312  312.500000  \
      ETHERNET_FREQ_805_322  322.265600  \
      ETHERNET_FREQ_322_156  156.250000  \
      ETHERNET_FREQ_322_322  322.265600  \
      PCIE_FREQ_250          100.000000  \
      PCIE_FREQ_275          100.000000  \
      PCIE_FREQ_300          100.000000  \
      PCIE_FREQ_325          100.000000  \
      PCIE_FREQ_350          100.000000  \
      PCIE_FREQ_375          100.000000  \
      PCIE_FREQ_400          100.000000  \
      PCIE_FREQ_425          100.000000  \
      PCIE_FREQ_450          100.000000  \
      PCIE_FREQ_475          100.000000  \
      PCIE_FREQ_500          100.000000  \
   } 
  dict set Presets n_counter {
      ETHERNET_FREQ_805_156  4  \
      ETHERNET_FREQ_805_312  8  \
      ETHERNET_FREQ_805_322  1  \
      ETHERNET_FREQ_322_156  1  \
      ETHERNET_FREQ_322_322  1  \
      PCIE_FREQ_250          1  \
      PCIE_FREQ_275          1  \
      PCIE_FREQ_300          1  \
      PCIE_FREQ_325          1  \
      PCIE_FREQ_350          1  \
      PCIE_FREQ_375          1  \
      PCIE_FREQ_400          1  \
      PCIE_FREQ_425          1  \
      PCIE_FREQ_450          1  \
      PCIE_FREQ_475          1  \
      PCIE_FREQ_500          2  \
   } 
  dict set Presets m_counter {
      ETHERNET_FREQ_805_156  82  \
      ETHERNET_FREQ_805_312  82  \
      ETHERNET_FREQ_805_322  10  \
      ETHERNET_FREQ_322_156  16  \
      ETHERNET_FREQ_322_322  8   \
      PCIE_FREQ_250          20  \
      PCIE_FREQ_275          22  \
      PCIE_FREQ_300          24  \
      PCIE_FREQ_325          26  \
      PCIE_FREQ_350          28  \
      PCIE_FREQ_375          30  \
      PCIE_FREQ_400          20  \
      PCIE_FREQ_425          17  \
      PCIE_FREQ_450          27  \
      PCIE_FREQ_475          19  \
      PCIE_FREQ_500          50  \
   } 
  dict set Presets c0_counter {
      ETHERNET_FREQ_805_156   4 \
      ETHERNET_FREQ_805_312   4 \
      ETHERNET_FREQ_805_322   4 \
      ETHERNET_FREQ_322_156   8  \
      ETHERNET_FREQ_322_322   8  \
      PCIE_FREQ_250           8  \
      PCIE_FREQ_275           8  \
      PCIE_FREQ_300           8  \
      PCIE_FREQ_325           8  \
      PCIE_FREQ_350           8  \
      PCIE_FREQ_375           8  \
      PCIE_FREQ_400           5 \
      PCIE_FREQ_425           4 \
      PCIE_FREQ_450           6 \
      PCIE_FREQ_475           4 \
      PCIE_FREQ_500           5 \
   } 

 dict set Presets k_counter {
      ETHERNET_FREQ_805_156  8388608  \
      ETHERNET_FREQ_805_312  8388608  \
      ETHERNET_FREQ_805_322  0        \
      ETHERNET_FREQ_322_156  8388608  \
      ETHERNET_FREQ_322_322  0  \
      PCIE_FREQ_250          0  \
      PCIE_FREQ_275          0  \
      PCIE_FREQ_300          0  \
      PCIE_FREQ_325          0  \
      PCIE_FREQ_350          0  \
      PCIE_FREQ_375          0  \
      PCIE_FREQ_400          0 \
      PCIE_FREQ_425          0 \
      PCIE_FREQ_450          0 \
      PCIE_FREQ_475          0 \
      PCIE_FREQ_500          0 \
   } 


 dict set Presets vco_hz {
 ETHERNET_FREQ_805_156  3222656250 \
 ETHERNET_FREQ_805_312  3222656250 \
 ETHERNET_FREQ_805_322  3222656250 \
 ETHERNET_FREQ_322_156  2578125000 \
 ETHERNET_FREQ_322_322  2578125000 \
 PCIE_FREQ_250          2000000000 \
 PCIE_FREQ_275          2200000000 \
 PCIE_FREQ_300          2400000000 \
 PCIE_FREQ_325          2600000000 \
 PCIE_FREQ_350          2800000000 \
 PCIE_FREQ_375          3000000000 \
 PCIE_FREQ_400          2000000000 \
 PCIE_FREQ_425          1700000000 \
 PCIE_FREQ_450          2700000000 \
 PCIE_FREQ_475          1900000000 \
 PCIE_FREQ_500          2500000000 \
   
                  
   } 



  dict set Presets pfd_hz {
      ETHERNET_FREQ_805_156   39.062500  \
      ETHERNET_FREQ_805_312   39.062500  \
      ETHERNET_FREQ_805_322   322.265600  \
      ETHERNET_FREQ_322_156   156.250000  \
      ETHERNET_FREQ_322_322   322.265600  \
      PCIE_FREQ_250          100.000000  \
      PCIE_FREQ_275          100.000000  \
      PCIE_FREQ_300          100.000000  \
      PCIE_FREQ_325          100.000000  \
      PCIE_FREQ_350          100.000000  \
      PCIE_FREQ_375          100.000000  \
      PCIE_FREQ_400          100.000000  \
      PCIE_FREQ_425          100.000000  \
      PCIE_FREQ_450          100.000000  \
      PCIE_FREQ_475          100.000000  \
      PCIE_FREQ_500          50.000000  \
   }


  dict set Presets fout_hz {
    
 ETHERNET_FREQ_805_156  805664062 \
 ETHERNET_FREQ_805_312  805664062 \
 ETHERNET_FREQ_805_322  805664062 \
 ETHERNET_FREQ_322_156  322265625 \
 ETHERNET_FREQ_322_322  322265625 \
 PCIE_FREQ_250          250000000 \
 PCIE_FREQ_275          275000000 \
 PCIE_FREQ_300          300000000 \
 PCIE_FREQ_325          325000000 \
 PCIE_FREQ_350          350000000 \
 PCIE_FREQ_375          375000000 \
 PCIE_FREQ_400          400000000 \
 PCIE_FREQ_425          425000000 \
 PCIE_FREQ_450          450000000 \
 PCIE_FREQ_475          475000000 \
 PCIE_FREQ_500          500000000 \
              
}





}

proc ::spll::pll_calculations::validate_reffreq { fref } {
   return [expr {($fref <= $::spll::pll_calculations::max_ref) && ($fref >= $::spll::pll_calculations::min_ref)} ]
#  return ([expr {($fref <= $::spll::pll_calculations::max_ref) && ($fref >= $::spll::pll_calculations::min_ref)} ])
}


proc ::spll::pll_calculations::get_pfdhz_from_preset { preset_entry } {
   if {                 [dict exists $::spll::pll_calculations::Presets  pfd_hz  $preset_entry] } {
      set preset_pfdhz  [dict get    $::spll::pll_calculations::Presets  pfd_hz  $preset_entry]
      set preset_pfdhz  [expr { int($preset_pfdhz*1000000) }]
     #puts "::spll::pll_calculations::get_pfdhz_from_preset $preset_entry $preset_pfdhz"
      return $preset_pfdhz
   } else {
      #puts "::spll::pll_calculations::get_pfdhz_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}

proc ::spll::pll_calculations::get_n_counter_from_preset { preset_entry } {
   if {                 [dict exists $::spll::pll_calculations::Presets  n_counter  $preset_entry] } {
      set preset_n_counter  [dict get    $::spll::pll_calculations::Presets  n_counter  $preset_entry]
      set preset_n_counter  [expr { int($preset_n_counter) }]
     #puts "::spll::pll_calculations::get_pfdhz_from_preset $preset_entry $preset_pfdhz"
      return $preset_n_counter   } else {
      #puts "::spll::pll_calculations::get_pfdhz_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}

proc ::spll::pll_calculations::get_m_counter_from_preset { preset_entry } {
   if {                 [dict exists $::spll::pll_calculations::Presets  m_counter  $preset_entry] } {
      set preset_m_counter  [dict get    $::spll::pll_calculations::Presets  m_counter  $preset_entry]
      set preset_m_counter  [expr { int($preset_m_counter) }]
     #puts "::spll::pll_calculations::get_pfdhz_from_preset $preset_entry $preset_pfdhz"
      return $preset_m_counter   } else {
      #puts "::spll::pll_calculations::get_pfdhz_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}

proc ::spll::pll_calculations::get_c0_counter_from_preset { preset_entry } {
   if {                 [dict exists $::spll::pll_calculations::Presets  c0_counter  $preset_entry] } {
      set preset_c0_counter  [dict get    $::spll::pll_calculations::Presets  c0_counter  $preset_entry]
      set preset_c0_counter  [expr { int($preset_c0_counter) }]
     #puts "::spll::pll_calculations::get_pfdhz_from_preset $preset_entry $preset_pfdhz"
      return $preset_c0_counter   } else {
      #puts "::spll::pll_calculations::get_pfdhz_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}

proc ::spll::pll_calculations::get_k_counter_from_preset { preset_entry } {
   if {                 [dict exists $::spll::pll_calculations::Presets  k_counter  $preset_entry] } {
      set preset_k_counter  [dict get    $::spll::pll_calculations::Presets  k_counter  $preset_entry]
      set preset_k_counter  [expr { int($preset_k_counter) }]
     #puts "::spll::pll_calculations::get_pfdhz_from_preset $preset_entry $preset_pfdhz"
      return $preset_k_counter   } else {
      #puts "::spll::pll_calculations::get_pfdhz_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}



proc ::spll::pll_calculations::get_vco_hz_from_preset { preset_entry } {
   if {                 [dict exists $::spll::pll_calculations::Presets  vco_hz  $preset_entry] } {
      set preset_vcohz  [dict get    $::spll::pll_calculations::Presets  vco_hz  $preset_entry]
      set preset_vcohz  [expr { ($preset_vcohz) }]
   #  puts "::spll::pll_calculations::get_pfdhz_from_preset $preset_entry $preset_pfdhz"
      return $preset_vcohz
   } else {
      #puts "::spll::pll_calculations::get_pfdhz_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}


proc ::spll::pll_calculations::get_fout_from_preset { preset_entry } {
   if {                 [dict exists $::spll::pll_calculations::Presets  fout_hz  $preset_entry] } {
      set preset_fouthz  [dict get    $::spll::pll_calculations::Presets  fout_hz  $preset_entry]
      set preset_fouthz  [expr { int($preset_fouthz) }]
     #puts "::spll::pll_calculations::get_pfdhz_from_preset $preset_entry $preset_pfdhz"
      return $preset_fouthz
   } else {
      #puts "::spll::pll_calculations::get_pfdhz_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}





proc ::spll::pll_calculations::get_refclk_from_preset { preset_entry } {
   if {                  [dict exists $::spll::pll_calculations::Presets  refclk  $preset_entry] } {
      set preset_refclk  [dict get    $::spll::pll_calculations::Presets  refclk  $preset_entry]
     #puts "::spll::pll_calculations::get_refclk_from_preset $preset_entry $preset_refclk"
      return $preset_refclk
   } else {
      puts "::spll::pll_calculations::get_refclk_from_preset <$preset_entry> ERROR - This is not expected"
      return 0
   }
}

proc ::spll::pll_calculations::find_refclk_values_c0c1c2 { f_out f_out1 f_out2 syspll_freq_mhz_enanble_0 syspll_freq_mhz_enanble_1 syspll_freq_mhz_enanble_2 fixfrac} {
  return [::spll::pll_calculations::find_refclk_c0c1c2 "125" $f_out $f_out1 $f_out2 0 2 $syspll_freq_mhz_enanble_0 $syspll_freq_mhz_enanble_1 $syspll_freq_mhz_enanble_2 $fixfrac]
}



proc ::spll::pll_calculations::find_refclk_c0c1c2 { f_ref f_out f_out1 f_out2 find_ref mode syspll_freq_mhz_enanble_0 syspll_freq_mhz_enanble_1 syspll_freq_mhz_enanble_2 fixfrac} {
 variable  max_vco  4000000000
 variable  min_vco  1500000000
 variable  max_fref   380000000
 variable  min_fref   25000000
 variable  max_pfd   400000000
 variable  min_pfd    20000000
 variable  max_c0_counter [expr 2**11]
 variable  max_c2_counter [expr 2**11]
 variable  max_m_counter  [expr 2**10]
 variable  max_n_counter  [expr 2**4]  
variable  val_k_counter  {0 0.5} 
 variable  mod_freq_limit_hz    600000000.0
 variable  tolerance_hz  512
 variable  fastref_break_freq_hz    200000000
 variable  max_C0   1000000000   
 variable  max_C2    450000000   
 variable  min_C2    250000000   
 
 dict set ret status bad
 set a [expr  10**2]
 set x [expr int($f_out* $a)]
 set y [expr int($f_out1* $a)]
 set z [expr int($f_out2* $a)]

#Equation for fvco = k_factor * LCM(fout,fout1,fout2)

#LCM calculation to find the vco

  
set f_vco [expr ($x/$a)]

set totalcount 0
set refclklist(0) 0

if {$f_vco > $max_vco} {
 return $ret }

set f_vco  [expr {$f_vco*1.0}]

 
  for {set k_factor 1 } \
      {$k_factor < [expr int($f_out)]} \
      {incr k_factor} \
  {
 
    set f_vco [expr $f_out*$k_factor]  ;# Fout can be sub-Hertz, ie decimal
   #puts "::systemclk_f::pll_calculations::find_values -- c:$c_counter   checking_vco $min_vco < f_vco:$f_vco < $max_vco"

    if {$f_vco < $min_vco} {continue}
    if {$f_vco > $max_vco} {break}
  
    # Each output frequecy is the divided version of the fvco ie fout= fvco/c
    if {$syspll_freq_mhz_enanble_0=="true" && $syspll_freq_mhz_enanble_1=="true" && $syspll_freq_mhz_enanble_2=="true"} {
      set C0 [expr round ($f_vco/$f_out)]
      set C1 [expr round ($f_vco/$f_out1)]
      set C2 [expr round ($f_vco/$f_out2)]
    } elseif {$syspll_freq_mhz_enanble_0=="true" && $syspll_freq_mhz_enanble_1=="true" && $syspll_freq_mhz_enanble_2=="false"} {
      set C0 [expr round ($f_vco/$f_out)]
      set C1 [expr round ($f_vco/$f_out1)]
      set C2 0
    } elseif {$syspll_freq_mhz_enanble_0=="false" && $syspll_freq_mhz_enanble_1=="true" && $syspll_freq_mhz_enanble_2=="true"} {
      set C0 0 
      set C1 [expr round($f_vco/$f_out1)]
      set C2 [expr round($f_vco/$f_out2)] 
    } elseif {$syspll_freq_mhz_enanble_0=="true" && $syspll_freq_mhz_enanble_1=="false" && $syspll_freq_mhz_enanble_2=="false"} {
      set C0 [expr round($f_vco/$f_out)]
      set C1 0
      set C2 0 
     #puts "$C0 $C1 $C2" 
    } elseif {$syspll_freq_mhz_enanble_0=="false" && $syspll_freq_mhz_enanble_1=="true" && $syspll_freq_mhz_enanble_2=="false"} {
      set C0 0
      set C1 [expr round($f_vco/$f_out1)]
      set C2 0    
    } else {
      set C0 0
      set C1 0
      set C2 [expr round($f_vco/$f_out2)]
    }
 
    for {set m_counter [expr int((ceil($f_vco/$max_pfd))) ] } {$m_counter < $max_m_counter} {incr m_counter} {
      set f_pfd_calc [expr $f_vco/$m_counter];  
      if {$f_pfd_calc < $min_pfd} { break }
      if {$f_pfd_calc > $max_pfd} { continue }
         

      for {set n_counter [expr int((ceil($min_fref/$f_pfd_calc))) ] } {$n_counter < $max_n_counter} {incr n_counter} \
          {
            foreach k  $val_k_counter \
                { set k_counter [expr round($k*(1<<24))]
                  set f_ref_calc [expr {($f_vco*$n_counter)/($m_counter+$k_counter*1.0/(1<<24))}]  ;# Decimals, minimizing computation error
                  #puts "YO! $f_ref_calc"
                  #set f_ref_calc [expr {($f_out*$C0*$n_counter)/$m_counter}] ;
                  
                  if {$f_ref_calc < $min_fref} { continue }
                  if {$f_ref_calc > $max_fref} { break }
                  #puts "m  $m_counter n $n_counter f_out $f_out C0 $C0 fref $f_ref_calc"
                  if { [expr { round($f_ref_calc) }] != $f_ref_calc } { 
                    #set xxx [expr { round($f_ref_calc) }]
                    #puts "YO2! $f_ref_calc  -- $xxx"
                    continue }
                  
                  
                  if { ($f_out + $tolerance_hz) * $C0 * $n_counter < $f_ref_calc * $m_counter } {
                    #puts "Check failed: ($f_out + $tolerance_hz) * $c_counter * $n_counter < $f_ref_calc * $m_counter "
                    continue
                  }
                  
                  if { ($f_out - $tolerance_hz) * $C0 * $n_counter >= $f_ref_calc * ($m_counter+1) } {
                    #puts "Check failed: ($f_out - $tolerance_hz) * $c_counter * $n_counter >= $f_ref_calc * ($m_counter+1) "
                    continue
                  }
                  set max_mod_counter  [expr { floor( ($f_ref_calc>$::spll::pll_calculations::fastref_break_freq_hz ) ? 
                                                      ((10.0*$f_vco*$n_counter*2)/(15.0*$f_ref_calc)) :    
                                                      ((     $f_vco*$n_counter*2)/( 3.0*$f_ref_calc))    )}]        
                  ### 10 * pll_0_f_vco_hz * pll_0_n_counter >= 15 * pll_0_f_ref_hz * pll_0_mod_counter       
                  ###      pll_0_f_vco_hz * pll_0_n_counter >=  3 * pll_0_f_ref_hz * pll_0_mod_counter 
                  
                  set min_mod_counter  [expr { ceil(2*$f_vco/($::spll::pll_calculations::mod_freq_limit_hz)) }]  
                  ###  `mod_freq_limit_hz * pll_0_mod_counter >= pll_0_f_vco_hz;
                  
     
                  if { $::spll::pll_calculations::mod_freq_limit_hz * $max_mod_counter < 2 * $f_vco } {
                    #puts "Check failed: ($f_out - $tolerance_hz) * $c_counter * $n_counter >= $f_ref_calc * ($m_counter+1) "
                    continue
                  }



                  if { (($min_mod_counter > $max_mod_counter) || ($min_mod_counter > 15) || ($max_mod_counter < 1) ) 
                     } {
                    # puts "debug: max_mod_counter $max_mod_counter min_mod_counter $min_mod_counter  $f_vco $n_counter $f_ref_calc"
                    continue 
                  }


                  ## JW:
                  ## For fractional (k!=0), skip it if the same frequency can be achieved
                  ## with an integer ratio by dividing refclk by another factor of 2
                  if {$fixfrac == "true"} {
                    if {    ([expr $f_ref_calc/(2*$n_counter)] > $min_pfd) 
                            && ($k_counter > 0) 
                            && ([expr 2*$n_counter] < $max_n_counter)
                            && ([expr 2*($m_counter+0.5)] < $max_m_counter)} {
                      continue
                    }
                  }

                  ## JW:
                  ## skip fractional ratios if LSB = '11
                  if {$fixfrac == "true"} {
                    if {(($m_counter & 3) == 3) && ($k_counter > 0)} {
                      continue
                    }
                  }


                  set f_pfd_calc [expr $f_ref_calc/$n_counter]
            
                  if {($find_ref == 1 && $f_ref_calc == $f_ref) || ($find_ref == 0  && (($k_counter!=0 && $n_counter>=4) || $k_counter==0)   )}  {
                    # puts "good $k_counter"
                    dict set ret status good
                    set refclk     [expr $f_ref_calc/1000000]
                    set refclk_str [format "%.6f" $refclk];# 6 fractional digits, \open: is it ok for hdl parameters? 
                    
                    if { ![dict exists $ret $refclk_str] } {
                      set totalcount [expr $totalcount+1]
                      set refclklist($totalcount) $refclk
                      dict set ret $refclk_str vco [format "%.6f" [expr $f_vco/1000000]]
                      dict set ret $refclk_str pfd [format "%.6f" [expr $f_pfd_calc/1000000]]
                      dict set ret $refclk_str m   $m_counter
                      dict set ret $refclk_str n   $n_counter
                      dict set ret $refclk_str c   $C0
                      dict set ret $refclk_str c1  $C1
                      dict set ret $refclk_str c2  $C2
                      dict set ret $refclk_str f2  $f_out2
                      dict set ret $refclk_str k   $k_counter
                      
                      dict set ret $refclk_str mxm $max_mod_counter
                      dict set ret $refclk_str mnm $min_mod_counter

                      #  Fractional: NOT supported k=0 for now.
                      #dict set ret $refclk_str k 0
            
                      #puts "::spll::pll_calculations::find_values -- c:$c_counter m:$m_counter n:$n_counter  fref:$f_ref_calc vco:$f_vco f_pfd:$f_pfd_calc"

                    } else {
                      # If refclk repeats with different counter settings ignore it, as the first setting found will be optimal
                      ##ip_message info "::spll::pll_calculations::find_values refclk already exists"
                    }
                  };
                } ;# N counter for loop
          } ;# M counter for loop
    } ;# M counter for loop
  } ; #K counter for loop
  #puts "YO!  $f_out -- $totalcount"
  set refclklist(0) $totalcount
  return [array get refclklist]
}



proc ::spll::pll_calculations::find_refclk_values { f_out } {
  return [::spll::pll_calculations::find_refclk_values_generic "125" $f_out 0 2]
}

proc ::spll::pll_calculations::find_refclk_values_generic { f_ref f_out find_ref  mode} {
  variable  max_pfd   ;# <- $::spll::pll_calculations::max_vco
  variable  min_pfd
  variable  max_vco
  variable  min_vco
  variable  max_ref
  variable  min_ref
  
  variable  max_c0_counter 
  variable  max_m_counter
  variable  max_n_counter
  variable  val_k_counter  {0 0.5}
  variable  max_C0
  variable  max_k_counter  [expr 2**24]
  
  variable  tolerance_hz
  
  
  # initialize return status as bad. don't forget to update the status to good once proper settings find
  dict set ret status bad
  
  # Check max fout:
  #    It's enforced C1 = C0/2, so don't need to check C1
  #    c2_counter is calculated to ensure C2 is in range
  if {$f_out > $max_C0} { return $ret }
  
  # if {[expr {$f_out/$::spll::pll_calculations::max_c2_counter}] > $::spll::pll_calculations::max_C2} { return $ret }
  # if {[expr {$f_out                                                 }] < $::spll::pll_calculations::min_C2} { return $ret }
  
  set f_out  [expr {$f_out*1.0}]

  for {set c_counter [expr int((ceil($min_vco/$f_out))) ] } \
      {$c_counter < $max_c0_counter} \
      {incr c_counter} \
      {
        set f_vco [expr $f_out*$c_counter]  ;# Fout can be sub-Hertz, ie decimal
        #puts "::spll::pll_calculations::find_values -- c:$c_counter   checking_vco $min_vco < f_vco:$f_vco < $max_vco"
        
        if {$f_vco < $min_vco} {continue}
        if {$f_vco > $max_vco} {break}
        
        
        
        for {set m_counter [expr int((ceil($f_vco/$max_pfd))) ] } {$m_counter < $max_m_counter} {incr m_counter} \
            {
              
              set f_pfd_calc [expr $f_vco/$m_counter]  ;# PFD is decimal
              #puts "::spll::pll_calculations::find_values -- c:$c_counter m:$m_counter  checking_pfd $min_pfd < pfd:$f_pfd_calc < $max_pfd"
              
              if {$f_pfd_calc < $min_pfd} { break }
              if {$f_pfd_calc > $max_pfd} { continue }
              
              for {set n_counter [expr int((ceil($min_ref/$f_pfd_calc))) ] } {$n_counter < $max_n_counter} {incr n_counter} \
                  {
                    
                    #set f_ref_calc [expr  $f_pfd_calc * $n_counter]
                    # set f_ref_calc [expr {($f_out*$c_counter*$n_counter)/$m_counter}]  ;# Decimals, minimizing computation error
                    foreach k  $val_k_counter \
                        { set k_counter [expr round($k*(1<<24))]
                          set f_ref_calc [expr {($f_out*$c_counter*$n_counter)/($m_counter+$k_counter*1.0/(1<<24))}]  ;# Decimals, minimizing computation error
                          
                          
                          if {$f_ref_calc < $min_ref} { continue }
                          if {$f_ref_calc > $max_ref} { break }
                          
                          #  Check refclk is integer
                          #    Physically, refclk can be decimal.  But RBC and BB settings limits to integer to Hz
                          #    When fraction_enabled, refclk is input, assuming it's integer.
                          #    TODO: Maybe leaving refclk setting unset, just set the counters?
                          if { [expr { round($f_ref_calc) }] != $f_ref_calc } { continue }
                          
                          
                          ### Checking:
                          #      (pll_0_f_out_c0_hz + `tolerance_hz) * pll_0_c0_counter * pll_0_n_counter >= pll_0_f_ref_hz *  pll_0_m_counter;
                          #      (pll_0_f_out_c0_hz - `tolerance_hz) * pll_0_c0_counter * pll_0_n_counter <  pll_0_f_ref_hz * (pll_0_m_counter + 1);
                          if { ($f_out + $tolerance_hz) * $c_counter * $n_counter < $f_ref_calc * $m_counter } {
                            #puts "Check failed: ($f_out + $tolerance_hz) * $c_counter * $n_counter < $f_ref_calc * $m_counter "
                            continue
                          }
                          
                          if { ($f_out - $tolerance_hz) * $c_counter * $n_counter >= $f_ref_calc * ($m_counter+1) } {
                            #puts "Check failed: ($f_out - $tolerance_hz) * $c_counter * $n_counter >= $f_ref_calc * ($m_counter+1) "
                            continue
                          }
                          
                          
                          
                          
                          #  set  c2_counter [expr int(floor($f_vco/$::spll::pll_calculations::min_C2))]
                          #  for {                                        } \
                              #      {     $c2_counter > 0                    } \
                              #      { set  c2_counter [expr {$c2_counter-1}] } \
                              #  {
                          #      set f_c2_out [expr { int($f_vco/$c2_counter) }]
                          #      if { $f_c2_out > $::spll::pll_calculations::max_C2 } { continue }
                          #     #if { $f_c2_out < $::spll::pll_calculations::min_C2 } { continue } ;dont need: f_c2_out increasing
                          #      if { $f_vco == $c2_counter*$f_c2_out } { break } ;# integer. take this
                          
                          #     #puts "::spll::pll_calculations::find_values -- looking c2:$c2_counter f_c2_out $f_c2_out c:$c_counter vco:$f_vco f_pfd:$f_pfd_calc"
                          #  }
                          # #puts "::spll::pll_calculations::find_values -- c2:$c2_counter f_c2_out $f_c2_out c:$c_counter m:$m_counter n:$n_counter  fref:$f_ref_calc vco:$f_vco f_pfd:$f_pfd_calc"
                          #  if { $c2_counter < 1 } { continue }
                          set max_mod_counter  [expr { floor( ($f_ref_calc>$::spll::pll_calculations::fastref_break_freq_hz ) ? 
                                                              ((10.0*$f_vco*$n_counter*2)/(15.0*$f_ref_calc)) :    
                                                              ((     $f_vco*$n_counter*2)/( 3.0*$f_ref_calc))    )}]        
                          ### 10 * pll_0_f_vco_hz * pll_0_n_counter >= 15 * pll_0_f_ref_hz * pll_0_mod_counter       
                          ###      pll_0_f_vco_hz * pll_0_n_counter >=  3 * pll_0_f_ref_hz * pll_0_mod_counter 
                          
                          set min_mod_counter  [expr { ceil(2*$f_vco/($::spll::pll_calculations::mod_freq_limit_hz)) }]  
                          ###  `mod_freq_limit_hz * pll_0_mod_counter >= pll_0_f_vco_hz;
                          
                          
                          if { $::spll::pll_calculations::mod_freq_limit_hz * $max_mod_counter < 2 * $f_vco } {
                            #puts "Check failed: ($f_out - $tolerance_hz) * $c_counter * $n_counter >= $f_ref_calc * ($m_counter+1) "
                            continue
                          }
                          
                          
                          
                          if { (($min_mod_counter > $max_mod_counter) || ($min_mod_counter > 15) || ($max_mod_counter < 1) ) 
                             } {
                            # puts "debug: max_mod_counter $max_mod_counter min_mod_counter $min_mod_counter  $f_vco $n_counter $f_ref_calc"
                            continue 
                          }
                          #puts "debug: max_mod_counter $max_mod_counter min_mod_counter $min_mod_counter  $f_vco $n_counter $f_ref_calc"
                          
                          #JW
                          ## For fractional (k!=0), skip it if the same frequency can be achieved
                          ## with an integer ratio by dividing refclk by another factor of 2
                          if {    ([expr $f_ref_calc/(2*$n_counter)] > $min_pfd) 
                                  && ($k_counter > 0) 
                                  && ([expr 2*$n_counter] < $max_n_counter)
                                  && ([expr 2*($m_counter+0.5)] < $max_m_counter)} {
                            continue
                          }

                          ## JW:
                          ## skip fractional ratios if LSB = '11
                          if {(($m_counter & 3) == 3) && ($k_counter > 0)} {
                            continue
                          }

                          if {($find_ref == 1 && $f_ref_calc == $f_ref) || ($find_ref == 0  && (($k_counter!=0 && $n_counter>=4) || $k_counter==0)   )} {
                            # puts " k_counter=$k_counter n_counter=$n_counter find_ref=$find_ref"
                            dict set ret status good
                            set refclk     [expr $f_ref_calc/1000000]
                            set fpfd     [expr $f_ref_calc/$n_counter]
                            set refclk_str [format "%.6f" $refclk];# 6 fractional digits, \open: is it ok for hdl parameters? 
                            
                            if { ![dict exists $ret $refclk_str] } {
                              dict set ret $refclk_str vco [format "%.6f" [expr $f_vco/1000000]]
                              dict set ret $refclk_str pfd [format "%.6f" [expr $fpfd/1000000]]
                              dict set ret $refclk_str n   $n_counter
                              dict set ret $refclk_str m   $m_counter                       
                              dict set ret $refclk_str c   $c_counter
                              dict set ret $refclk_str k   $k_counter
                              dict set ret $refclk_str c1  0
                              dict set ret $refclk_str c2  0
                              dict set ret $refclk_str f2  0
                              dict set ret $refclk_str mxm $max_mod_counter
                              dict set ret $refclk_str mnm $min_mod_counter
                              #  Fractional: NOT supported k=0 for now.
                              #dict set ret $refclk_str k 0
                              #puts "$refclk_str"
                              # ::alt_xcvr::ip_tcl::messages::ip_message info "Fractional settings 1: $ret"
                              #ip_message info "::spll::pll_calculations::find_values -- c:$c_counter m:$m_counter k:$k_counter n:$n_counter  fref:$f_ref_calc vco:$f_vco f_pfd:$f_pfd_calc"
                              
                            } else {
                              # If refclk repeats with different counter settings ignore it, as the first setting found will be optimal
                              ##ip_message info "::spll::pll_calculations::find_values refclk already exists"
                            }
                          }
                        } ;# N counter for loop
                  } ; #K counter
            } ;# M counter for loop
      } ;# M counter for loop
  
  return $ret
}


####  QSYS interface API
proc ::spll::pll_calculations::validate_fout { fout_MHz } {
   
  global max_fout
  global min_fout
  #puts "fout_MHz$fout_MHz"
  if { $fout_MHz > $max_fout || $fout_MHz < $min_fout } {
     dict set result value $fout_MHz
     dict set result msg "Output frequency ($fout_MHz MHz) is out of range. ($min_fout \< f \< $max_fout)"
  } else { 
     #TODO: reformat fout if needed.
     dict set result value $fout_MHz
     dict set result msg "" 
  } 

  return $result
}


####  Common 'helper' functions
#  (do it here.  Test and debug outside of QSYS.
proc ::spll::pll_calculations::helper_get_refclk_allow_ranges { fout fout1 fout2 syspll_freq_mhz_enanble_0 syspll_freq_mhz_enanble_1 syspll_freq_mhz_enanble_2} { 

   #set result   [::spll::pll_calculations::find_refclk_values $fout]
      if {$syspll_freq_mhz_enanble_0=="true" && $syspll_freq_mhz_enanble_1=="true" && $syspll_freq_mhz_enanble_2=="true"} {
         set result  [::spll::pll_calculations::find_refclk_values_c0c1c2 $fout $fout1 $fout2 $syspll_freq_mhz_enanble_0 $syspll_freq_mhz_enanble_1 $syspll_freq_mhz_enanble_2] 
       } elseif {$syspll_freq_mhz_enanble_0=="true" && $syspll_freq_mhz_enanble_1=="true" && $syspll_freq_mhz_enanble_2=="false"} {
          set result  [::spll::pll_calculations::find_refclk_values_c0c1c2 $fout $fout1 0 $syspll_freq_mhz_enanble_0 $syspll_freq_mhz_enanble_1 $syspll_freq_mhz_enanble_2] 
       } elseif {$syspll_freq_mhz_enanble_0=="true" && $syspll_freq_mhz_enanble_1=="false" && $syspll_freq_mhz_enanble_2=="true"} {
          set result  [::spll::pll_calculations::find_refclk_values_c0c1c2 $fout 0 $fout2 $syspll_freq_mhz_enanble_0 $syspll_freq_mhz_enanble_1 $syspll_freq_mhz_enanble_2 ] 
       } elseif {$syspll_freq_mhz_enanble_0=="true"} {
           set result  [::spll::pll_calculations::find_refclk_values $fout] 
       } elseif {$syspll_freq_mhz_enanble_1=="true"} {
          set result  [::spll::pll_calculations::find_refclk_values $fout1] 
       } elseif {$syspll_freq_mhz_enanble_2=="true"} {
           set result  [::spll::pll_calculations::find_refclk_values $fout2] 
       } else {
          ip_message ERROR  "SystemPLL#0: Enable any output frequency."
       }

   #set result  [::spll::pll_calculations::find_refclk_values_c0c1c2 $fout $fout1 $fout2 $syspll_freq_mhz_enanble_0 $syspll_freq_mhz_enanble_1 $syspll_freq_mhz_enanble_2] 
   #puts "display $fout"
   #puts "display $result"
   if { [dict get $result status] == "bad" } { 
      return {}
   } else {
      set settings [dict remove $result status]
      return [lsort -real -increasing [dict keys $settings]]
   }   
}



proc ::spll::pll_calculations::helper_list_intersect { list_a list_b } {
   ### ==>  ASSUME both lists are sorted.  <==

   variable result {}
   set index_a [expr [llength $list_a] -1]
   set index_b [expr [llength $list_b] -1]
   puts "$list_a"
   puts "$list_b"

   while { $index_a >= 0 && $index_b >=0 } {
      set a [lindex $list_a $index_a]
      set b [lindex $list_b $index_b]

      if       { $a == $b } {
         lappend result $a
         set index_a [expr $index_a - 1]
         set index_b [expr $index_b - 1]
      } elseif { $a > $b } {
         set index_a [expr $index_a - 1]
      } else {  ;# $a<$b
         set index_b [expr $index_b - 1]
      }
   } 

   return [lreverse  $result]
}






proc ::spll::pll_calculations::legality_check_refclk_input { inst in_freq } {
  global f_max_refclk
  global f_min_refclk


  #TODO: check out_freq is number
  #TODO: get f_max_C0, f_min_C0, out_freq unit (MHz?)
  
  if { $in_freq > $f_max_refclk  || $in_freq < $f_min_refclk } {
    send_message ERROR " Refclk #$inst: Input frequency ($in_freq MHz) is out of range. ($f_min_refclk < f < $f_max_refclk)"
  }

}


proc ::spll::pll_calculations::legality_check_pll_output { inst out_freq } {
  global f_max_C0
  global f_min_C0


  #TODO: check out_freq is number
  #TODO: get f_max_C0, f_min_C0, out_freq unit (MHz?)
  
  if { $out_freq > $f_max_C0  || $out_freq < $f_min_C0 } {
    send_message ERROR "SystemPLL #$inst: Output frequency ($out_freq MHz) is out of range. ($f_min_C0 < f < $f_max_C0)"
  }

}


#####################################################################
#set fref  [lindex $argv 0]
#set fout0 [lindex $argv 1]
#set fout1 0
#set enable1 "false"
#
#if {$argc == 3} {
#  set fout1 [lindex $argv 2]
#  set enable1 "true"
#}
#
#
#set result_orig  [::spll::pll_calculations::find_refclk_values_c0c1c2 [expr 1e6*$fout0] [expr 1e6*$fout1] 1e6 "true" $enable1 "false" "false"] 
#set result_new   [::spll::pll_calculations::find_refclk_values_c0c1c2 [expr 1e6*$fout0] [expr 1e6*$fout1] 1e6 "true" $enable1 "false" "true"] 
#
#array set origlist $result_orig
#array set newlist  $result_new
#
#set valid_orig "false"
#foreach key [array names origlist] {
#  if {$origlist($key) == $fref} {
#    set valid_orig "true"
#  }
#}
#
#set valid_new "false"
#foreach key [array names newlist] {
#  if {$newlist($key) == $fref} {
#    set valid_new "true"
#  }
#}
#
#
#if {($valid_orig == "true") && ($valid_new == "true")} {
#  puts "PASSED - fref=${fref}MHz fout0=${fout0}MHz valid in both original and new version" }
#
#if {($valid_orig == "true") && ($valid_new == "false")} {
#  puts "FAILED - fref=${fref}MHz fout0=${fout0}MHz valid in original version, not valid in new version" }
#
#if {($valid_orig == "false") && ($valid_new == "false")} {
#  puts "?????? - fref=${fref}MHz fout0=${fout0}MHz NOT valid in either original or new version" }


#==========================================================================================================
# 1. Open the file for reading
#
set dir "."      ;# Change to your desired directory
set extension ".xml"

set filename [glob -nocomplain -directory $dir *$extension]

#set filename [lindex $argv 0]
set fileId [open $filename r]

# 2. Initialize variable to store value
set extracted_value ""

# 3. Read file line by line
while {[gets $fileId line] != -1} {
    # 4. Check if line contains "syspll_freq_mhz_0"
    if {[string match "*syspll_freq_mhz_0\"*" $line]} {
        # 5. Use regexp to find "value <number>"
			 	if {[regexp {value="([0-9]+(?:\.[0-9]+)?)"} $line match syspll_freq_out]} {
            set extracted_value $syspll_freq_out
            # 6. Optionally, break if only first occurrence is needed
            break
        }
    }
}

set fout0 $syspll_freq_out
set fout1 0
set enable1 "false"

# 8. Output the result (for testing)
puts "------------------------------------------------------------------------------------------------------"
puts "Extracted SysPLL Output Frequency value (MHz): $extracted_value"

while {[gets $fileId line] != -1} {
    # 4. Check if line contains "refclk_xcvr_freq_mhz_0"
    if {[string match "*refclk_xcvr_freq_mhz_0*" $line]} {
        # 5. Use regexp to find "value=<number>"
			 	if {[regexp {value="([0-9]+(?:\.[0-9]+)?)"} $line match refclk_freq_in]} {
            set extracted_value $refclk_freq_in
            # 6. Optionally, break if only first occurrence is needed
            break
        }
    }
}

puts "Extracted Input Reference Clock Frequency value (MHz): $refclk_freq_in"

while {[gets $fileId line] != -1} {
    # 4. Check if line contains "m_counter"
    if {[string match "*m_counter*" $line]} {
        # 5. Use regexp to find "value <number>"
			 	if {[regexp {value="([0-9]+)"} $line match m_counter]} {
            set extracted_value $m_counter
            # 6. Optionally, break if only first occurrence is needed
            break
        }
    }
}

puts "Extracted M counter value: $extracted_value"

while {[gets $fileId line] != -1} {
    # 4. Check if line contains "k_counter"
    if {[string match "*k_counter*" $line]} {
        # 5. Use regexp to find "value <number>"
			 	if {[regexp {value="([0-9]+)"} $line match k_counter]} {
            set extracted_value $k_counter
            # 6. Optionally, break if only first occurrence is needed
            break
        }
    }
}
puts "Extracted K counter value: $extracted_value"

while {[gets $fileId line] != -1} {
    # 4. Check if line contains "k_counter"
    if {[string match "*n_counter*" $line]} {
        # 5. Use regexp to find "value <number>"
			 	if {[regexp {value="([0-9]+)"} $line match n_counter]} {
            set extracted_value $n_counter
            # 6. Optionally, break if only first occurrence is needed
            break
        }
    }
}
puts "Extracted N counter value: $extracted_value"

while {[gets $fileId line] != -1} {
    # 4. Check if line contains "k_counter"
    if {[string match "*c0_counter*" $line]} {
        # 5. Use regexp to find "value <number>"
			 	if {[regexp {value="([0-9]+)"} $line match c0_counter]} {
            set extracted_value $c0_counter
            # 6. Optionally, break if only first occurrence is needed
            break
        }
    }
}
puts "Extracted C0 counter value: $extracted_value"
set suggested_c0 [expr {($refclk_freq_in * ($m_counter)) / ($n_counter * $c0_counter)}]
puts "Extracted FVCO value: [format "%.8f" $suggested_c0]"



# 7. Close the file
close $fileId

# Check if last two bits are set to 1
puts "------------------------------------------------------------------------------------------------------"
if {$m_counter ne ""} {
    if {[expr {$m_counter & 3}] == 3 && $k_counter > 0} {
        puts "The last two bits of M counter are set to 1 & Fractional mode is enabled."
				puts "***This System PLL IP configuration is affected.***"
		} else {
				puts "***This System PLL IP configuration is NOT affected.***"
		}
} else {
    puts "No value extracted."
}		
puts "------------------------------------------------------------------------------------------------------"

if {[expr {$m_counter & 3}] == 3 && $k_counter > 0} {

	set result_new   [::spll::pll_calculations::find_refclk_values_c0c1c2 [expr 1e6*$fout0] [expr 1e6*$fout1] 1e6 "true" $enable1 "false" "true"] 
	array set newlist  $result_new

	# Create a list of key-value pairs
	set kvlist {}
	foreach key [array names newlist] {
	    lappend kvlist [list $key $newlist($key)]
	}
	# Sort by value (alphabetically)
	set sorted_kvlist [lsort -real -index 1 $kvlist]
	set valid_new "false"

	set result 0
	foreach pair $sorted_kvlist {
					set key [lindex $pair 0]
					set value [lindex $pair 1]
					
					if {$value == $refclk_freq_in} {
									set result 1
    			}
	}

	if {$result > 0} {
	puts "Existing reference clock $refclk_freq_in MHz can be used with safe settings after IP regeneration "
	puts "with the patch or next QPDS release."
	puts "------------------------------------------------------------------------------------------------------"
	}

	set suggested_c0 [expr {($refclk_freq_in * ($m_counter + 1)) / ($n_counter * $c0_counter)}]
	puts "Alternate System PLL output frequency which can be considered (MHz): [format "%.8f" $suggested_c0]"
	set suggested_c0 [expr {($refclk_freq_in * ($m_counter + 2)) / ($n_counter * $c0_counter)}]
	puts "Alternate System PLL output frequency which can be considered (MHz): [format "%.8f" $suggested_c0]"
	puts "------------------------------------------------------------------------------------------------------"

	puts "Alternate list of legal Refclk frequencies with restrictions. Pick any one and regenerate the IP"
	set newcount [llength $sorted_kvlist]	
	puts "Total number of legal Refclk frequencies found with new restriction on M counter values: $newcount"
	puts "------------------------------------------------------------------------------------------------------"
	foreach pair $sorted_kvlist {
					set key [lindex $pair 0]
					set value [lindex $pair 1]
					puts -nonewline [format "%-3.6f" $value ]
					puts -nonewline " "

					incr cnt 
    			if {$cnt % 9 == 0} {
    			    puts ""
    			}
	}
  puts "\n"

	set result_old   [::spll::pll_calculations::find_refclk_values_c0c1c2 [expr 1e6*$fout0] [expr 1e6*$fout1] 1e6 "true" $enable1 "false" "false"] 
	array set oldlist  $result_old

	# Create a list of key-value pairs
	set kvlist {}
	set sorted_kvlist {}
	foreach key [array names oldlist] {
	    lappend kvlist [list $key $oldlist($key)]
	}
	# Sort by value (alphabetically)
	set sorted_kvlist [lsort -real -index 1 $kvlist]
	set valid_new "false"

	set oldcount [llength $sorted_kvlist]	
	puts "------------------------------------------------------------------------------------------------------"
	puts "Total number of legal Refclk frequencies found without any restrictions (current implementation): $oldcount"
	puts "------------------------------------------------------------------------------------------------------"
	set cnt 0
	foreach pair $sorted_kvlist {
					set key [lindex $pair 0]
					set value [lindex $pair 1]
					#puts "$value"
					puts -nonewline [format "%-3.6f" $value ]
					puts -nonewline " "

					incr cnt 
    			if {$cnt % 9 == 0} {
    			    puts ""
    			} 
	}
  puts "\n"
	puts "------------------------------------------------------------------------------------------------------"

}

