/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.WsaPropertyBag;
import com.sun.xml.internal.ws.addressing.WsaTube;
import com.sun.xml.internal.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.internal.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.NonAnonymousResponseProcessor;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.AddressingUtils;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.ThrowableContainerPropertySet;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.client.Stub;
import com.sun.xml.internal.ws.message.FaultDetailHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;

public class WsaServerTube
extends WsaTube {
    private WSEndpoint endpoint;
    private WSEndpointReference replyTo;
    private WSEndpointReference faultTo;
    private boolean isAnonymousRequired = false;
    protected boolean isEarlyBackchannelCloseAllowed = true;
    private WSDLBoundOperation wbo;
    public static final String REQUEST_MESSAGE_ID = "com.sun.xml.internal.ws.addressing.request.messageID";
    private static final Logger LOGGER = Logger.getLogger(WsaServerTube.class.getName());

    public WsaServerTube(WSEndpoint wSEndpoint, @NotNull WSDLPort wSDLPort, WSBinding wSBinding, Tube tube) {
        super(wSDLPort, wSBinding, tube);
        this.endpoint = wSEndpoint;
    }

    public WsaServerTube(WsaServerTube wsaServerTube, TubeCloner tubeCloner) {
        super(wsaServerTube, tubeCloner);
        this.endpoint = wsaServerTube.endpoint;
    }

    @Override
    public WsaServerTube copy(TubeCloner tubeCloner) {
        return new WsaServerTube(this, tubeCloner);
    }

    @Override
    @NotNull
    public NextAction processRequest(Packet packet) {
        String string;
        Message message = packet.getMessage();
        if (message == null) {
            return this.doInvoke(this.next, packet);
        }
        packet.addSatellite(new WsaPropertyBag(this.addressingVersion, this.soapVersion, packet));
        MessageHeaders messageHeaders = packet.getMessage().getHeaders();
        try {
            this.replyTo = AddressingUtils.getReplyTo(messageHeaders, this.addressingVersion, this.soapVersion);
            this.faultTo = AddressingUtils.getFaultTo(messageHeaders, this.addressingVersion, this.soapVersion);
            string = AddressingUtils.getMessageID(messageHeaders, this.addressingVersion, this.soapVersion);
        }
        catch (InvalidAddressingHeaderException invalidAddressingHeaderException) {
            Object object;
            LOGGER.log(Level.WARNING, this.addressingVersion.getInvalidMapText() + ", Problem header:" + invalidAddressingHeaderException.getProblemHeader() + ", Reason: " + invalidAddressingHeaderException.getSubsubcode(), invalidAddressingHeaderException);
            messageHeaders.remove(invalidAddressingHeaderException.getProblemHeader());
            SOAPFault sOAPFault = this.helper.createInvalidAddressingHeaderFault(invalidAddressingHeaderException, this.addressingVersion);
            if (this.wsdlPort != null && packet.getMessage().isOneWay(this.wsdlPort)) {
                Packet packet2 = packet.createServerResponse(null, this.wsdlPort, null, this.binding);
                return this.doReturnWith(packet2);
            }
            Message message2 = Messages.create(sOAPFault);
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                object = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), invalidAddressingHeaderException.getProblemHeader());
                message2.getHeaders().add((Header)object);
            }
            object = packet.createServerResponse(message2, this.wsdlPort, null, this.binding);
            return this.doReturnWith((Packet)object);
        }
        if (this.replyTo == null) {
            this.replyTo = this.addressingVersion.anonymousEpr;
        }
        if (this.faultTo == null) {
            this.faultTo = this.replyTo;
        }
        packet.put("com.sun.xml.internal.ws.addressing.WsaPropertyBag.ReplyToFromRequest", this.replyTo);
        packet.put("com.sun.xml.internal.ws.addressing.WsaPropertyBag.FaultToFromRequest", this.faultTo);
        packet.put("com.sun.xml.internal.ws.addressing.WsaPropertyBag.MessageIdFromRequest", string);
        this.wbo = this.getWSDLBoundOperation(packet);
        this.isAnonymousRequired = this.isAnonymousRequired(this.wbo);
        Packet packet3 = this.validateInboundHeaders(packet);
        if (packet3.getMessage() == null) {
            return this.doReturnWith(packet3);
        }
        if (packet3.getMessage().isFault()) {
            if (this.isEarlyBackchannelCloseAllowed && !this.isAnonymousRequired && !this.faultTo.isAnonymous() && packet.transportBackChannel != null) {
                packet.transportBackChannel.close();
            }
            return this.processResponse(packet3);
        }
        if (this.isEarlyBackchannelCloseAllowed && !this.isAnonymousRequired && !this.replyTo.isAnonymous() && !this.faultTo.isAnonymous() && packet.transportBackChannel != null) {
            packet.transportBackChannel.close();
        }
        return this.doInvoke(this.next, packet3);
    }

    protected boolean isAnonymousRequired(@Nullable WSDLBoundOperation wSDLBoundOperation) {
        return false;
    }

    protected void checkAnonymousSemantics(WSDLBoundOperation wSDLBoundOperation, WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2) {
    }

    @Override
    @NotNull
    public NextAction processException(Throwable throwable) {
        Packet packet = Fiber.current().getPacket();
        ThrowableContainerPropertySet throwableContainerPropertySet = packet.getSatellite(ThrowableContainerPropertySet.class);
        if (throwableContainerPropertySet == null) {
            throwableContainerPropertySet = new ThrowableContainerPropertySet(throwable);
            packet.addSatellite(throwableContainerPropertySet);
        } else if (throwable != throwableContainerPropertySet.getThrowable()) {
            throwableContainerPropertySet.setThrowable(throwable);
        }
        return this.processResponse(packet.endpoint.createServiceResponseForException(throwableContainerPropertySet, packet, this.soapVersion, this.wsdlPort, packet.endpoint.getSEIModel(), this.binding));
    }

    @Override
    @NotNull
    public NextAction processResponse(Packet packet) {
        Object object;
        WSEndpointReference wSEndpointReference;
        Message message = packet.getMessage();
        if (message == null) {
            return this.doReturnWith(packet);
        }
        String string = AddressingUtils.getTo(message.getHeaders(), this.addressingVersion, this.soapVersion);
        if (string != null) {
            this.replyTo = this.faultTo = new WSEndpointReference(string, this.addressingVersion);
        }
        if (this.replyTo == null) {
            this.replyTo = (WSEndpointReference)packet.get("com.sun.xml.internal.ws.addressing.WsaPropertyBag.ReplyToFromRequest");
        }
        if (this.faultTo == null) {
            this.faultTo = (WSEndpointReference)packet.get("com.sun.xml.internal.ws.addressing.WsaPropertyBag.FaultToFromRequest");
        }
        WSEndpointReference wSEndpointReference2 = wSEndpointReference = message.isFault() ? this.faultTo : this.replyTo;
        if (wSEndpointReference == null && packet.proxy instanceof Stub) {
            wSEndpointReference = ((Stub)packet.proxy).getWSEndpointReference();
        }
        if (wSEndpointReference == null || wSEndpointReference.isAnonymous() || this.isAnonymousRequired) {
            return this.doReturnWith(packet);
        }
        if (wSEndpointReference.isNone()) {
            packet.setMessage(null);
            return this.doReturnWith(packet);
        }
        if (this.wsdlPort != null && packet.getMessage().isOneWay(this.wsdlPort)) {
            LOGGER.fine(AddressingMessages.NON_ANONYMOUS_RESPONSE_ONEWAY());
            return this.doReturnWith(packet);
        }
        if (this.wbo != null || packet.soapAction == null) {
            Object object2 = object = packet.getMessage().isFault() ? this.helper.getFaultAction(this.wbo, packet) : this.helper.getOutputAction(this.wbo);
            if (packet.soapAction == null || object != null && !((String)object).equals("http://jax-ws.dev.java.net/addressing/output-action-not-set")) {
                packet.soapAction = object;
            }
        }
        packet.expectReply = false;
        try {
            object = new EndpointAddress(URI.create(wSEndpointReference.getAddress()));
        }
        catch (NullPointerException nullPointerException) {
            throw new WebServiceException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WebServiceException(illegalArgumentException);
        }
        packet.endpointAddress = object;
        if (packet.isAdapterDeliversNonAnonymousResponse) {
            return this.doReturnWith(packet);
        }
        return this.doReturnWith(NonAnonymousResponseProcessor.getDefault().process(packet));
    }

    @Override
    protected void validateAction(Packet packet) {
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        if (wSDLBoundOperation == null) {
            return;
        }
        String string = AddressingUtils.getAction(packet.getMessage().getHeaders(), this.addressingVersion, this.soapVersion);
        if (string == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_SERVER_NULL_ACTION());
        }
        String string2 = this.helper.getInputAction(packet);
        String string3 = this.helper.getSOAPAction(packet);
        if (this.helper.isInputActionDefault(packet) && string3 != null && !string3.equals("")) {
            string2 = string3;
        }
        if (string2 != null && !string.equals(string2)) {
            throw new ActionNotSupportedException(string);
        }
    }

    @Override
    protected void checkMessageAddressingProperties(Packet packet) {
        super.checkMessageAddressingProperties(packet);
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        this.checkAnonymousSemantics(wSDLBoundOperation, this.replyTo, this.faultTo);
        this.checkNonAnonymousAddresses(this.replyTo, this.faultTo);
    }

    private void checkNonAnonymousAddresses(WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2) {
        if (!wSEndpointReference.isAnonymous()) {
            try {
                new EndpointAddress(URI.create(wSEndpointReference.getAddress()));
            }
            catch (Exception exception) {
                throw new InvalidAddressingHeaderException(this.addressingVersion.replyToTag, this.addressingVersion.invalidAddressTag);
            }
        }
    }
}

