#!/bin/tcsh

# Create VCS MX libraries
echo "--Tells VCS where the libraries are" > synopsys_sim.setup
echo "WORK > work" >> synopsys_sim.setup
echo "work : ./work" >> synopsys_sim.setup
echo "lpm : ./lpm" >> synopsys_sim.setup
echo "sgate  : ./sgate" >> synopsys_sim.setup
echo "altera : ./altera" >> synopsys_sim.setup
echo "altgxb : ./altgxb" >> synopsys_sim.setup
echo "altgxb_lib : ./altgxb" >> synopsys_sim.setup
echo "altera_mf : ./altera_mf" >> synopsys_sim.setup
echo "stratixiigx_hssi : ./stratixiigx_hssi" >> synopsys_sim.setup
echo "stratixiv_hssi : ./stratixiv_hssi" >> synopsys_sim.setup
echo "stratixiv_pcie_hip : ./stratixiv_pcie_hip" >> synopsys_sim.setup
echo "arriaii_hssi : ./arriaii_hssi" >> synopsys_sim.setup
echo "arriaii_pcie_hip : ./arriaii_pcie_hip" >> synopsys_sim.setup
echo "cycloneiv_hssi : ./cycloneiv_hssi" >> synopsys_sim.setup
echo "cycloneiv_pcie_hip : ./cycloneiv_pcie_hip" >> synopsys_sim.setup
echo "hardcopyiv_hssi : ./hardcopyiv_hssi" >> synopsys_sim.setup
echo "hardcopyiv_pcie_hip : ./hardcopyiv_pcie_hip" >> synopsys_sim.setup
echo "TIMEBASE = PS" >> synopsys_sim.setup


mkdir lpm 
mkdir altera_mf 
mkdir sgate 
mkdir altgxb 
mkdir stratixiigx_hssi 
mkdir stratixiv_hssi 
mkdir stratixiv_pcie_hip 
mkdir arriaii_hssi 
mkdir arriaii_pcie_hip 
mkdir cycloneiv_hssi 
mkdir cycloneiv_pcie_hip 
mkdir hardcopyiv_hssi
mkdir hardcopyiv_pcie_hip
mkdir altera 
mkdir work 
mkdir local_lib 
vhdlan -work lpm $QUARTUS_ROOTDIR/eda/sim_lib/220pack.vhd $QUARTUS_ROOTDIR/eda/sim_lib/220model.vhd 
vhdlan -work altera_mf $QUARTUS_ROOTDIR/eda/sim_lib/altera_mf_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/altera_mf.vhd 
vhdlan -work sgate $QUARTUS_ROOTDIR/eda/sim_lib/sgate_pack.vhd $QUARTUS_ROOTDIR/eda/sim_lib/sgate.vhd 
vhdlan -work altgxb $QUARTUS_ROOTDIR/eda/sim_lib/stratixgx_mf.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixgx_mf_components.vhd 
vhdlan -work stratixiigx_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiigx_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixiigx_hssi_atoms.vhd 
vhdlan -work stratixiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_hssi_atoms.vhd 
vhdlan -work stratixiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_pcie_hip_atoms.vhd 
vhdlan -work arriaii_hssi $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_hssi_atoms.vhd 
vhdlan -work arriaii_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_pcie_hip_atoms.vhd 
vhdlan -work cycloneiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_hssi_atoms.vhd 
vhdlan -work cycloneiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_pcie_hip_atoms.vhd 
vhdlan -work hardcopyiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_hssi_atoms.vhd 
vhdlan -work hardcopyiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_pcie_hip_atoms.vhd 
vhdlan -work altera $QUARTUS_ROOTDIR/libraries/vhdl/altera/altera_europa_support_lib.vhd 
vhdlan -list -work work -f sim_filelist 

# run simulation
set tb = `grep vsim runtb.do | grep testbench | awk '{ print "work." $NF}'`
vcs -R $tb -l transcript

cat transcript

