global env ;

set QUARTUS_ROOTDIR "PCIE_BUILD_PATH_TO_QUARTUS_ROOTDIR"

if [regexp {ModelSim ALTERA} [vsim -version]] {
        # Using Altera OEM Version need to add one more library mapping
        set altgxb_path $env(MODEL_TECH)\/../altera/vhdl/altgxb ;
        vmap altgxb_lib $altgxb_path ;

   vlib altera
} else {
      # Using non-OEM Version, compile all of the libraries
      vlib lpm
      vmap lpm lpm
      vcom -work lpm $QUARTUS_ROOTDIR/eda/sim_lib/220pack.vhd $QUARTUS_ROOTDIR/eda/sim_lib/220model.vhd

      vlib altera_mf
      vmap altera_mf altera_mf
      vcom -work altera_mf $QUARTUS_ROOTDIR/eda/sim_lib/altera_mf_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/altera_mf.vhd

      vlib sgate
      vmap sgate sgate
      vcom -work sgate $QUARTUS_ROOTDIR/eda/sim_lib/sgate_pack.vhd $QUARTUS_ROOTDIR/eda/sim_lib/sgate.vhd

      vlib altgxb
      vmap altgxb altgxb
      vmap altgxb_lib altgxb
      vcom -work altgxb $QUARTUS_ROOTDIR/eda/sim_lib/stratixgx_mf.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixgx_mf_components.vhd

      vlib stratixiigx_hssi
      vmap stratixiigx_hssi stratixiigx_hssi
      vcom -work stratixiigx_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiigx_hssi_components.vhd
      vcom -work stratixiigx_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiigx_hssi_atoms.vhd

      vlib altera
      vmap altera altera
      vcom -work altera $QUARTUS_ROOTDIR/eda/sim_lib/altera_primitives_components.vhd
      vcom -work altera $QUARTUS_ROOTDIR/eda/sim_lib/altera_primitives.vhd

   if [ file exists  $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_hssi_components.vhd ] {
      vlib stratixiv_hssi
      vmap stratixiv_hssi stratixiv_hssi
      vcom -work stratixiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_hssi_components.vhd
      vcom -work stratixiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_hssi_atoms.vhd

      vlib stratixiv_pcie_hip
      vmap stratixiv_pcie_hip stratixiv_pcie_hip
      vcom -work stratixiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_pcie_hip_components.vhd
      vcom -work stratixiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_pcie_hip_atoms.vhd
   }
}

# Create the work library
vlib work

# Map the support library from the example_top file
vmap altera work
vcom -work altera $QUARTUS_ROOTDIR/libraries/vhdl/altera/altera_europa_support_lib.vhd

# Verilog co-sim
vlog -sv -work work $QUARTUS_ROOTDIR/eda/sim_lib/stratixv_hssi_atoms.v
vlog -sv -work work $QUARTUS_ROOTDIR/eda/sim_lib/mentor/stratixv_hssi_atoms_ncrypt.v
vlog -sv -work work $QUARTUS_ROOTDIR/eda/sim_lib/stratixv_pcie_hip_atoms.v
vlog -sv -work work $QUARTUS_ROOTDIR/eda/sim_lib/mentor/stratixv_pcie_hip_atoms_ncrypt.v
vlog -work work $QUARTUS_ROOTDIR/eda/sim_lib/altera_primitives.v
vlog -work work -f sim_filelist_verilog_cosim

# Now compile the testbench/reference design files
vcom -work work -f sim_filelist

# Now run the simulation
vsim -novopt -t ps altpcietb_top_x4_pipen1b
set NumericStdNoWarnings 1
set StdArithNoWarnings 1
onbreak { resume }

# Log all nets
# log -r /*

run -all
