#!/bin/tcsh


echo "SOFTINCLUDE $CDS_ROOT/tools/inca/files/cds.lib" > cds.lib
echo "DEFINE lpm ./lpm" >> cds.lib
echo "DEFINE altera_mf ./altera_mf" >> cds.lib
echo "DEFINE sgate ./sgate" >> cds.lib
echo "DEFINE altgxb ./altgxb" >> cds.lib
echo "DEFINE altgxb_lib ./altgxb" >> cds.lib
echo "DEFINE stratixiigx_hssi ./stratixiigx_hssi" >> cds.lib
echo "DEFINE stratixiv_hssi ./stratixiv_hssi" >> cds.lib
echo "DEFINE stratixiv_pcie_hip ./stratixiv_pcie_hip" >> cds.lib
echo "DEFINE arriaii_hssi ./arriaii_hssi" >> cds.lib
echo "DEFINE arriaii_pcie_hip ./arriaii_pcie_hip" >> cds.lib
echo "DEFINE cycloneiv_hssi ./cycloneiv_hssi" >> cds.lib
echo "DEFINE cycloneiv_pcie_hip ./cycloneiv_pcie_hip" >> cds.lib
echo "DEFINE hardcopyiv_hssi ./hardcopyiv_hssi" >> cds.lib
echo "DEFINE hardcopyiv_pcie_hip ./hardcopyiv_pcie_hip" >> cds.lib
echo "DEFINE local_lib ./local_lib" >> cds.lib
echo "DEFINE altera ./altera" >> cds.lib
echo "SOFTINCLUDE $CDS_ROOT/tools/inca/files/hdl.var" > hdl.var
echo "set pack_assert_off {std_logic_arith numeric_std}" > runtb_nc.do
echo "run" >> runtb_nc.do


mkdir lpm 
mkdir altera_mf 
mkdir sgate 
mkdir altgxb 
mkdir stratixiigx_hssi 
mkdir stratixiv_hssi 
mkdir stratixiv_pcie_hip 
mkdir arriaii_hssi 
mkdir arriaii_pcie_hip 
mkdir cycloneiv_hssi 
mkdir cycloneiv_pcie_hip 
mkdir hardcopyiv_hssi 
mkdir hardcopyiv_pcie_hip 
mkdir altera 
mkdir work 
mkdir local_lib 

ncvhdl -v93 -relax -work lpm $QUARTUS_ROOTDIR/eda/sim_lib/220pack.vhd $QUARTUS_ROOTDIR/eda/sim_lib/220model.vhd 
ncvhdl -v93 -relax -work altera_mf $QUARTUS_ROOTDIR/eda/sim_lib/altera_mf_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/altera_mf.vhd 
ncvhdl -v93 -relax -work sgate $QUARTUS_ROOTDIR/eda/sim_lib/sgate_pack.vhd $QUARTUS_ROOTDIR/eda/sim_lib/sgate.vhd 
ncvhdl -v93 -relax -work altgxb $QUARTUS_ROOTDIR/eda/sim_lib/stratixgx_mf.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixgx_mf_components.vhd 
ncvhdl -v93 -relax -work stratixiigx_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiigx_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixiigx_hssi_atoms.vhd 
ncvhdl -v93 -relax -work stratixiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_hssi_atoms.vhd 
ncvhdl -v93 -relax -work stratixiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/stratixiv_pcie_hip_atoms.vhd 
ncvhdl -v93 -relax -work arriaii_hssi $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_hssi_atoms.vhd 
ncvhdl -v93 -relax -work arriaii_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/arriaii_pcie_hip_atoms.vhd 
ncvhdl -v93 -relax -work cycloneiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_hssi_atoms.vhd 
ncvhdl -v93 -relax -work cycloneiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/cycloneiv_pcie_hip_atoms.vhd 
ncvhdl -v93 -relax -work hardcopyiv_hssi $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_hssi_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_hssi_atoms.vhd 
ncvhdl -v93 -relax -work hardcopyiv_pcie_hip $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_pcie_hip_components.vhd $QUARTUS_ROOTDIR/eda/sim_lib/hardcopyiv_pcie_hip_atoms.vhd 

ncvhdl -v93 -relax -work altera $QUARTUS_ROOTDIR/libraries/vhdl/altera/altera_europa_support_lib.vhd 
ncvhdl -v93 -relax -work local_lib -nowarn UNXPCL -f sim_filelist

# run simulation
set tb = `grep vsim runtb.do | grep testbench | awk '{ print $NF ":entity" }'`
ncelab -ACCESS +r $tb
set tb = `grep vsim runtb.do | grep testbench | awk '{ print $NF }'`
ncsim -input runtb_nc.do $tb -LOGFILE transcript

