LIBRARY ieee;                          
use IEEE.std_logic_1164.all;           
use IEEE.std_logic_arith.all;          
use IEEE.std_logic_unsigned.all;       
                                       
LIBRARY altera_mf;                     
USE altera_mf.altera_mf_components.all;
                                       
--
--Copyright (C) 1991-2006 Altera Corporation
--Your use of Altera Corporation's design tools, logic functions 
--and other software and tools, and its AMPP partner logic 
--functions, and any output files any of the foregoing 
--(including device programming or simulation files), and any 
--associated documentation or information are expressly subject 
--to the terms and conditions of the Altera Program License 
--Subscription Agreement, Altera MegaCore Function License 
--Agreement, or other applicable license agreement, including, 
--without limitation, that your use is for the sole purpose of 
--programming logic devices manufactured by Altera and sold by 
--Altera or its authorized distributors.  Please refer to the 
--applicable agreement for further details.
-- synopsys translate_off
-- synopsys translate_on
ENTITY altpcierd_txdatafifo IS
   PORT (
      aclr                    : IN std_logic;   
      clock                   : IN std_logic;   
      data                    : IN std_logic_vector(63 DOWNTO 0);   
      rdreq                   : IN std_logic;   
      sclr                    : IN std_logic;   
      wrreq                   : IN std_logic;   
      almost_full             : OUT std_logic;   
      empty                   : OUT std_logic;   
      full                    : OUT std_logic;   
      q                       : OUT std_logic_vector(63 DOWNTO 0));   
END ENTITY altpcierd_txdatafifo;
ARCHITECTURE translated OF altpcierd_txdatafifo IS
   SIGNAL sub_wire0                :  std_logic;   
   SIGNAL sub_wire1                :  std_logic;   
   SIGNAL sub_wire2                :  std_logic_vector(63 DOWNTO 0);   
   SIGNAL sub_wire3                :  std_logic;   
   SIGNAL almost_full_xhdl1        :  std_logic;   
   SIGNAL empty_xhdl2              :  std_logic;   
   SIGNAL q_xhdl4                  :  std_logic_vector(63 DOWNTO 0);   
   SIGNAL full_xhdl3               :  std_logic;   
BEGIN
   almost_full <= almost_full_xhdl1;
   empty <= empty_xhdl2;
   full <= full_xhdl3;
   q <= q_xhdl4;
   almost_full_xhdl1 <= sub_wire0 ;
   empty_xhdl2 <= sub_wire1 ;
   q_xhdl4 <= sub_wire2(63 DOWNTO 0) ;
   full_xhdl3 <= sub_wire3 ;
   
   -- synopsys translate_off
   -- synopsys translate_on
   -- <<X-HDL>> Can't find translated component 'scfifo'. Port & generic names and types may not match. No template will be included
   scfifo_component : scfifo 
      GENERIC MAP (
         add_ram_output_register => "ON",
         almost_full_value => 5,
         intended_device_family => "Stratix II GX",
         lpm_numwords => 8,
         lpm_showahead => "ON",
         lpm_type => "scfifo",
         lpm_width => 64,
         lpm_widthu => 3,
         overflow_checking => "ON",
         underflow_checking => "ON",
         use_eab => "ON")
      PORT MAP (
         rdreq => rdreq,
         sclr => sclr,
         aclr => aclr,
         clock => clock,
         wrreq => wrreq,
         data => data,
         almost_full => sub_wire0,
         empty => sub_wire1,
         q => sub_wire2,
         full => sub_wire3,
         almost_empty => open,
         usedw => open);   
   
END ARCHITECTURE translated;
