LIBRARY ieee;                          
use IEEE.std_logic_1164.all;           
use IEEE.std_logic_arith.all;          
use IEEE.std_logic_unsigned.all;       
                                       
LIBRARY altera_mf;                     
USE altera_mf.altera_mf_components.all;
                                       
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
   USE ieee.std_logic_unsigned.all;
--Copyright (C) 1991-2007 Altera Corporation
--Your use of Altera Corporation's design tools, logic functions 
--and other software and tools, and its AMPP partner logic 
--functions, and any output files from any of the foregoing 
--(including device programming or simulation files), and any 
--associated documentation or information are expressly subject 
--to the terms and conditions of the Altera Program License 
--Subscription Agreement, Altera MegaCore Function License 
--Agreement, or other applicable license agreement, including, 
--without limitation, that your use is for the sole purpose of 
--programming logic devices manufactured by Altera and sold by 
--Altera or its authorized distributors.  Please refer to the 
--applicable agreement for further details.
ENTITY altpcierd_stream_fifo_lkahd IS
   GENERIC (
      RAMTYPE       : STRING := "RAM_BLOCK_TYPE=M512";
      USEEAB        : STRING := "ON";
      ALMOSTFULL    : INTEGER := 10;
      NUMWORDS      : INTEGER := 16;
      WIDTHU        : INTEGER := 4
   );
   PORT (
      
      aclr          : IN STD_LOGIC;
      clock         : IN STD_LOGIC;
      data          : IN STD_LOGIC_VECTOR(107 DOWNTO 0);
      rdreq         : IN STD_LOGIC;
      wrreq         : IN STD_LOGIC;
      almost_empty  : OUT STD_LOGIC;
      almost_full   : OUT STD_LOGIC;
      empty         : OUT STD_LOGIC;
      full          : OUT STD_LOGIC;
      q             : OUT STD_LOGIC_VECTOR(107 DOWNTO 0);
      usedw         : OUT STD_LOGIC_VECTOR(WIDTHU - 1 DOWNTO 0)
   );
END ENTITY altpcierd_stream_fifo_lkahd;
ARCHITECTURE altpcie OF altpcierd_stream_fifo_lkahd IS


                                                
   FUNCTION to_stdlogic (                        
   val      : IN integer) RETURN std_logic IS    
   BEGIN                                         
      IF (val=1) THEN                            
         RETURN('1');                            
      ELSE                                       
         RETURN('0');                            
      END IF;                                    
   END to_stdlogic;                              
   FUNCTION to_stdlogic (                        
   val      : IN boolean) RETURN std_logic IS    
   BEGIN                                         
      IF (val) THEN                              
         RETURN('1');                            
      ELSE                                       
         RETURN('0');                            
      END IF;                                    
   END to_stdlogic;                              
                                                
   

   SIGNAL sub_wire0 : STD_LOGIC;
   SIGNAL sub_wire1 : STD_LOGIC_VECTOR(WIDTHU - 1 DOWNTO 0);
   SIGNAL sub_wire2 : STD_LOGIC;
   SIGNAL sub_wire3 : STD_LOGIC;
   SIGNAL sub_wire4 : STD_LOGIC_VECTOR(107 DOWNTO 0);
   SIGNAL sub_wire5 : STD_LOGIC;
BEGIN
   almost_full <= sub_wire0;
   usedw <= sub_wire1(WIDTHU - 1 DOWNTO 0);
   empty <= sub_wire2;
   almost_empty <= sub_wire3;
   q <= sub_wire4(107 DOWNTO 0);
   full <= sub_wire5;
   
   
   scfifo_component : scfifo
      GENERIC MAP (
         add_ram_output_register  => "ON",
         almost_empty_value       => 3,
         almost_full_value        => ALMOSTFULL,
         intended_device_family   => "Stratix II GX",
         lpm_hint                 => RAMTYPE,
         lpm_numwords             => NUMWORDS,
         lpm_showahead            => "ON",
         lpm_type                 => "scfifo",
         lpm_width                => 108,
         lpm_widthu               => WIDTHU,
         overflow_checking        => "OFF",
         underflow_checking       => "OFF",
         use_eab                  => USEEAB
      )
      PORT MAP (
         rdreq         => rdreq,
         aclr          => aclr,
         clock         => clock,
         wrreq         => wrreq,
         data          => data,
         almost_full   => sub_wire0,
         usedw         => sub_wire1,
         empty         => sub_wire2,
         almost_empty  => sub_wire3,
         q             => sub_wire4,
         full          => sub_wire5
      );
   
END ARCHITECTURE altpcie;
