LIBRARY ieee;                          
use IEEE.std_logic_1164.all;           
use IEEE.std_logic_arith.all;          
use IEEE.std_logic_unsigned.all;       
                                       
LIBRARY altera_mf;                     
USE altera_mf.altera_mf_components.all;
                                       
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
-- /**
-- *
-- *  This Verilog HDL File is used for simulation and synthesis in the simple DMA design example.  
-- *  It provides the wrapper for simple DMA example design.
-- *
-- */
-------------------------------------------------------------------------------
-- Title         : PCI Express Reference Design Example Application 
-- Project       : PCI Express MegaCore function
-------------------------------------------------------------------------------
-- File          : altpcierd_example_app.v
-- Author        : Altera Corporation
-------------------------------------------------------------------------------
-- Description :
-- This is the complete example application for the PCI Express Reference
-- Design. This has all of the application logic for the example.
-------------------------------------------------------------------------------
-- Copyright (c) 2005-2006 Altera Corporation. All rights reserved.  Altera products are
-- protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
-- other intellectual property laws.  
--
-- This reference design file, and your use thereof, is subject to and governed by
-- the terms and conditions of the applicable Altera Reference Design License Agreement.
-- By using this reference design file, you indicate your acceptance of such terms and
-- conditions between you and Altera Corporation.  In the event that you do not agree with
-- such terms and conditions, you may not use the reference design file. Please promptly
-- destroy any copies you have made.
--
-- This reference design file being provided on an "as-is" basis and as an accommodation 
-- and therefore all warranties, representations or guarantees of any kind 
-- (whether express, implied or statutory) including, without limitation, warranties of 
-- merchantability, non-infringement, or fitness for a particular purpose, are 
-- specifically disclaimed.  By making this reference design file available, Altera
-- expressly does not recommend, suggest or require that this reference design file be
-- used in combination with any other product not provided by Altera.
--                                                           
-------------------------------------------------------------------------------
ENTITY altpcierd_example_app IS
   GENERIC (
      TL_SELECTION       : INTEGER := 6     -- streaming interface format selection.
   );
   PORT (
      -- 0 = ICM format.  6 = 7.2 format.
      
      clk_in             : IN STD_LOGIC;        -- Clock for synchronous interface to application
      rstn               : IN STD_LOGIC;
      test_sim           : IN STD_LOGIC;        -- Speedup counters in simulation
      ko_cpl_spc_vc0     : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
      cfg_busdev         : IN STD_LOGIC_VECTOR(12 DOWNTO 0);
      cfg_devcsr         : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      cfg_tcvcmap        : IN STD_LOGIC_VECTOR(23 DOWNTO 0);
      cfg_linkcsr        : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      cpl_err            : OUT STD_LOGIC_VECTOR(6 DOWNTO 0);
      cpl_pending        : OUT STD_LOGIC;
      pm_data            : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);
      app_int_sts        : OUT STD_LOGIC;
      aer_msi_num        : OUT STD_LOGIC_VECTOR(4 DOWNTO 0);
      pex_msi_num        : OUT STD_LOGIC_VECTOR(4 DOWNTO 0);
      rx_stream_mask0    : OUT STD_LOGIC;
      tx_stream_mask0    : IN STD_LOGIC;
      
      -- streaming interface
      tx_stream_ready0   : IN STD_LOGIC;
      tx_stream_data0    : OUT STD_LOGIC_VECTOR(74 DOWNTO 0);
      tx_stream_valid0   : OUT STD_LOGIC;
      rx_stream_ready0   : OUT STD_LOGIC;
      rx_stream_valid0   : IN STD_LOGIC;
      rx_stream_data0    : IN STD_LOGIC_VECTOR(81 DOWNTO 0);
      msi_stream_ready0  : IN STD_LOGIC;
      msi_stream_valid0  : OUT STD_LOGIC;
      msi_stream_data0   : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      
      app_msi_req        : OUT STD_LOGIC;
      app_msi_ack        : IN STD_LOGIC;
      app_msi_tc         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      app_msi_num        : OUT STD_LOGIC_VECTOR(4 DOWNTO 0)
   );
END ENTITY altpcierd_example_app;
ARCHITECTURE altpcie OF altpcierd_example_app IS
   COMPONENT altpcierd_appmsi_streaming_intf IS
      PORT (
         clk_in             : IN STD_LOGIC;
         rstn               : IN STD_LOGIC;
         m_req              : IN STD_LOGIC;
         m_ack              : OUT STD_LOGIC;
         m_data             : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         stream_ready       : IN STD_LOGIC;
         stream_data        : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
         stream_valid       : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT altpcierd_slave IS
      GENERIC (
         RAM_SIZE           : INTEGER := 8
      );
      PORT (
         hclk               : IN STD_LOGIC;
         hrstn              : IN STD_LOGIC;
         cfg_busdev         : IN STD_LOGIC_VECTOR(12 DOWNTO 0);
         cfg_maxpload       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         cfg_tcvcmap        : IN STD_LOGIC_VECTOR(23 DOWNTO 0);
         m_req              : OUT STD_LOGIC;
         m_size             : OUT STD_LOGIC_VECTOR(31 DOWNTO 0);
         m_addr             : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         m_ctrl             : OUT STD_LOGIC_VECTOR(31 DOWNTO 0);
         m_tgt_adr          : OUT STD_LOGIC_VECTOR(12 DOWNTO 0);
         m_ack              : IN STD_LOGIC;
         tx_intreq          : OUT STD_LOGIC;
         pm_event           : OUT STD_LOGIC;
         err_cplabort       : OUT STD_LOGIC;
         pm_event_pb        : IN STD_LOGIC;
         m_pending          : IN STD_LOGIC;
         vc0_out            : OUT STD_LOGIC;
         vc1_out            : OUT STD_LOGIC;
         rx_busy            : OUT STD_LOGIC;
         tx_busy            : OUT STD_LOGIC;
         rx_req             : IN STD_LOGIC;
         rx_ack             : OUT STD_LOGIC;
         rx_desc            : IN STD_LOGIC_VECTOR(135 DOWNTO 0);
         rx_ws              : OUT STD_LOGIC;
         rx_data            : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         rx_be              : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         rx_dv              : IN STD_LOGIC;
         rx_dfr             : IN STD_LOGIC;
         tx_req             : OUT STD_LOGIC;
         tx_desc            : OUT STD_LOGIC_VECTOR(127 DOWNTO 0);
         tx_ack             : IN STD_LOGIC;
         tx_dfr             : OUT STD_LOGIC;
         tx_data            : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         tx_dv              : OUT STD_LOGIC;
         tx_err             : OUT STD_LOGIC;
         tx_ws              : IN STD_LOGIC;
         app_msi_num        : OUT STD_LOGIC_VECTOR(4 DOWNTO 0);
         app_msi_tc         : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
         fetch_tx_data      : IN STD_LOGIC;
         nextcyc_is_last    : OUT STD_LOGIC;
         last_datacyc       : OUT STD_LOGIC;
         avalon_tx_data     : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         rx_st_eop          : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT altpcierd_master IS
      GENERIC (
         RAM_SIZE           : INTEGER := 10
      );
      PORT (
         hclk               : IN STD_LOGIC;
         hrstn              : IN STD_LOGIC;
         testtim            : IN STD_LOGIC;
         ko_cpl_spc_vc0     : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
         ko_cpl_spc_vc1     : IN STD_LOGIC_VECTOR(19 DOWNTO 0);
         cfg_busdev         : IN STD_LOGIC_VECTOR(12 DOWNTO 0);
         cfg_maxpload       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         cfg_maxrdreq       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
         cfg_rcb            : IN STD_LOGIC;
         cfg_tcvcmap        : IN STD_LOGIC_VECTOR(23 DOWNTO 0);
         trans_pending      : OUT STD_LOGIC;
         err_cpltim         : OUT STD_LOGIC;
         err_cplunexp       : OUT STD_LOGIC;
         m_req              : IN STD_LOGIC;
         m_size             : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
         m_addr             : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         m_ctrl             : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
         m_tgt_adr          : IN STD_LOGIC_VECTOR(12 DOWNTO 0);
         m_ack              : OUT STD_LOGIC;
         m_pending          : OUT STD_LOGIC;
         rx_busy            : OUT STD_LOGIC;
         tx_busy            : OUT STD_LOGIC;
         vc0_out            : OUT STD_LOGIC;
         vc1_out            : OUT STD_LOGIC;
         rx_req             : IN STD_LOGIC;
         rx_ack             : OUT STD_LOGIC;
         rx_desc            : IN STD_LOGIC_VECTOR(135 DOWNTO 0);
         rx_ws              : OUT STD_LOGIC;
         rx_data            : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         rx_be              : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
         rx_dv              : IN STD_LOGIC;
         rx_dfr             : IN STD_LOGIC;
         tx_req             : OUT STD_LOGIC;
         tx_desc            : OUT STD_LOGIC_VECTOR(127 DOWNTO 0);
         tx_ack             : IN STD_LOGIC;
         tx_dfr             : OUT STD_LOGIC;
         tx_data            : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         tx_dv              : OUT STD_LOGIC;
         tx_err             : OUT STD_LOGIC;
         tx_ws              : IN STD_LOGIC;
         fetch_tx_data      : IN STD_LOGIC;
         nextcyc_is_last    : OUT STD_LOGIC;
         last_datacyc       : OUT STD_LOGIC;
         tx_avalon_data     : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         rx_st_eop          : IN STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT altpcierd_apprx_streaming_intf IS
      GENERIC (
         TL_SELECTION       : INTEGER := 6
      );
      PORT (
         clk                : IN STD_LOGIC;
         rstn               : IN STD_LOGIC;
         stream_ready       : OUT STD_LOGIC;
         stream_valid       : IN STD_LOGIC;
         stream_data_in     : IN STD_LOGIC_VECTOR(107 DOWNTO 0);
         m_busy             : IN STD_LOGIC;
         s_busy             : IN STD_LOGIC;
         m_rx_dv            : OUT STD_LOGIC;
         s_rx_dv            : OUT STD_LOGIC;
         m_ack              : IN STD_LOGIC;
         s_ack              : IN STD_LOGIC;
         m_rx_sop           : OUT STD_LOGIC;
         s_rx_sop           : OUT STD_LOGIC;
         rx_data            : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         rx_desc            : OUT STD_LOGIC_VECTOR(135 DOWNTO 0);
         rx_be              : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
         rx_eop             : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT altpcierd_apptx_streaming_intf IS
      GENERIC (
         TL_SELECTION       : INTEGER := 6  
      );
      PORT (
         clk_in             : IN STD_LOGIC;
         rstn               : IN STD_LOGIC;
         m_req              : IN STD_LOGIC;
         m_ack              : OUT STD_LOGIC;
         m_data_ack         : OUT STD_LOGIC;
         m_tx_desc          : IN STD_LOGIC_VECTOR(127 DOWNTO 0);
         m_tx_data          : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         m_last_datacyc     : IN STD_LOGIC;
         s_req              : IN STD_LOGIC;
         s_ack              : OUT STD_LOGIC;
         s_data_ack         : OUT STD_LOGIC;
         s_tx_desc          : IN STD_LOGIC_VECTOR(127 DOWNTO 0);
         s_tx_data          : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
         s_last_datacyc     : IN STD_LOGIC;
         stream_ready       : IN STD_LOGIC;
         stream_wrdata      : OUT STD_LOGIC_VECTOR(107 DOWNTO 0);
         stream_wr          : OUT STD_LOGIC;
         cpl_pending        : IN STD_LOGIC;
         m_tx_err           : IN STD_LOGIC;
         s_tx_err           : IN STD_LOGIC
      );
   END COMPONENT;
   
   

   SIGNAL m_req                  : STD_LOGIC;
   SIGNAL m_ack                  : STD_LOGIC;
   SIGNAL m_addr                 : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL m_size                 : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL m_ctrl                 : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL m_tgt_adr              : STD_LOGIC_VECTOR(12 DOWNTO 0);
   SIGNAL s_rx_busy              : STD_LOGIC;
   SIGNAL s_tx_busy              : STD_LOGIC;
   SIGNAL s_vc0_out              : STD_LOGIC;
   SIGNAL open_s_vc1_out         : STD_LOGIC;
   SIGNAL m_rx_busy              : STD_LOGIC;
   SIGNAL open_m_tx_busy         : STD_LOGIC;
   SIGNAL m_vc0_out              : STD_LOGIC;
   SIGNAL open_m_vc1_out         : STD_LOGIC;
   SIGNAL s_rx_ack               : STD_LOGIC;
   SIGNAL s_tx_req               : STD_LOGIC;
   SIGNAL s_tx_ack               : STD_LOGIC;
   SIGNAL s_tx_desc              : STD_LOGIC_VECTOR(127 DOWNTO 0);
   SIGNAL s_tx_err               : STD_LOGIC;
   SIGNAL open_s_tx_dv           : STD_LOGIC;
   SIGNAL s_tx_data              : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL m_rx_ack               : STD_LOGIC;
   SIGNAL m_tx_req               : STD_LOGIC;
   SIGNAL m_tx_ack               : STD_LOGIC;
   SIGNAL m_tx_desc              : STD_LOGIC_VECTOR(127 DOWNTO 0);
   SIGNAL m_tx_err               : STD_LOGIC;
   SIGNAL open_m_tx_dv           : STD_LOGIC;
   SIGNAL m_tx_data              : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL pm_event_pb            : STD_LOGIC;
   SIGNAL m_pending              : STD_LOGIC;
   SIGNAL app_int_sts_buf        : STD_LOGIC;
   SIGNAL app_int_sts_r          : STD_LOGIC;
   
   SIGNAL ko_cpl_spc_vc1         : STD_LOGIC_VECTOR(19 DOWNTO 0);
   
   SIGNAL s_last_datacyc         : STD_LOGIC;       -- from slave.   this cycle is last data cycle of tx transfer.
   SIGNAL m_last_datacyc         : STD_LOGIC;       -- from master.  this cycle is last data cycle of tx transfer.
   
   -- master-slave interface 
   -- pipeline stages for
   -- performance.
   
   SIGNAL m_addr_del             : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL m_size_del             : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL m_ctrl_del             : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL m_tgt_adr_del          : STD_LOGIC_VECTOR(12 DOWNTO 0);
   SIGNAL m_pending_del          : STD_LOGIC;
   SIGNAL m_ack_del              : STD_LOGIC;
   SIGNAL m_req_del              : STD_LOGIC;
   SIGNAL m_addr_del2            : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL m_size_del2            : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL m_ctrl_del2            : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL m_tgt_adr_del2         : STD_LOGIC_VECTOR(12 DOWNTO 0);
   SIGNAL m_pending_del2         : STD_LOGIC;
   SIGNAL m_ack_del2             : STD_LOGIC;
   SIGNAL m_req_del2             : STD_LOGIC;
   
   SIGNAL s_tx_req_del           : STD_LOGIC;
   SIGNAL m_tx_req_del           : STD_LOGIC;
   
   SIGNAL m_rx_sop               : STD_LOGIC;
   SIGNAL s_rx_sop               : STD_LOGIC;
   SIGNAL rx_data                : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL rx_desc                : STD_LOGIC_VECTOR(135 DOWNTO 0);
   SIGNAL rx_be                  : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL m_rx_dv                : STD_LOGIC;
   SIGNAL s_rx_dv                : STD_LOGIC;
   SIGNAL rx_eop                 : STD_LOGIC;
   SIGNAL app_msi_st_ack         : STD_LOGIC;
   
   SIGNAL msi_stream_data0_n     : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL msi_stream_valid0_n    : STD_LOGIC;
   
   SIGNAL open_pm_event          : STD_LOGIC;
   SIGNAL open_s_rx_ws           : STD_LOGIC;
   SIGNAL open_s_tx_dfr          : STD_LOGIC;
   SIGNAL open_s_nextcyc_is_last : STD_LOGIC;
   SIGNAL open_m_nextcyc_is_last : STD_LOGIC;
   SIGNAL open_m_rx_ws           : STD_LOGIC;
   SIGNAL open_m_tx_dfr          : STD_LOGIC;
   
   SIGNAL cfg_busdev_del         : STD_LOGIC_VECTOR(12 DOWNTO 0);
   SIGNAL cfg_devcsr_del         : STD_LOGIC_VECTOR(31 DOWNTO 0);
   SIGNAL cfg_tcvcmap_del        : STD_LOGIC_VECTOR(23 DOWNTO 0);
   SIGNAL cfg_linkcsr_del        : STD_LOGIC_VECTOR(31 DOWNTO 0);
   
   -- structural
   
   -- pipeline stage for master-slave interface.
   -- DMA control and status signals.  for performance.
   
   SIGNAL s_data_ack             : STD_LOGIC;
   
   SIGNAL m_data_ack             : STD_LOGIC;
   
   --------------------------------------------------------------
   --    TX Streaming Interface
   --       - generates streaming interface signals 
   --       - arbitrates between master and slave requests
   --------------------------------------------------------------
   
   -- rx_req is generated one clk cycle ahead of 
   -- other control signals.  
   -- re-align here.
   SIGNAL tx_stream_data0_ext    : STD_LOGIC_VECTOR(107 DOWNTO 0);
   
   --------------------------------------------------------------
   --    MSI Streaming Interface
   --       - generates streaming interface signals
   --       - Used for 7.1 mode only 
   --------------------------------------------------------------
   
   -- if ICM mode, deassert on app_msi_st_ack
   -- if 7.2 or beyond, deassert on app_msi_ack
   
   -- extra pipe stage for performance
   -- Used for 7.1 mode only
   
   --------------------------------------------------------------
   --    RX Streaming Interface
   --       - generates streaming interface signals 
   --       - routes data to master/slave
   --------------------------------------------------------------   
   
   SIGNAL rx_stream_data0_ext    : STD_LOGIC_VECTOR(107 DOWNTO 0);
   -- X-HDL generated signals
   SIGNAL xhdl7 : STD_LOGIC;
   SIGNAL xhdl8 : STD_LOGIC;
   SIGNAL xhdl9 : STD_LOGIC;
   SIGNAL xhdl10 : STD_LOGIC;
   SIGNAL xhdl11 : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL xhdl12 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL cpl_err_xhdl3          : STD_LOGIC_VECTOR(6 DOWNTO 0);
   SIGNAL cpl_pending_xhdl4      : STD_LOGIC;
   SIGNAL tx_stream_valid0_xhdl6 : STD_LOGIC;
   SIGNAL rx_stream_ready0_xhdl5 : STD_LOGIC;
   SIGNAL app_msi_req_xhdl1      : STD_LOGIC;
   SIGNAL app_msi_tc_xhdl2       : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL app_msi_num_xhdl0      : STD_LOGIC_VECTOR(4 DOWNTO 0);
BEGIN
   -- Drive referenced outputs
   cpl_err <= cpl_err_xhdl3;
   cpl_pending <= cpl_pending_xhdl4;
   tx_stream_valid0 <= tx_stream_valid0_xhdl6;
   rx_stream_ready0 <= rx_stream_ready0_xhdl5;
   app_msi_req <= app_msi_req_xhdl1;
   app_msi_tc <= app_msi_tc_xhdl2;
   app_msi_num <= app_msi_num_xhdl0;
   rx_stream_mask0 <= '0';
   ko_cpl_spc_vc1 <= "00000000000000000000";
   pm_event_pb <= '1';
   pm_data <= "0000000000";
   PROCESS (rstn, clk_in)
   BEGIN
      IF (rstn = '0') THEN
         m_addr_del <= "0000000000000000000000000000000000000000000000000000000000000000";
         m_size_del <= "00000000000000000000000000000000";
         m_ctrl_del <= "00000000000000000000000000000000";
         m_tgt_adr_del <= "0000000000000";
         m_pending_del <= '0';
         m_ack_del <= '0';
         m_req_del <= '0';
         m_addr_del2 <= "0000000000000000000000000000000000000000000000000000000000000000";
         m_size_del2 <= "00000000000000000000000000000000";
         m_ctrl_del2 <= "00000000000000000000000000000000";
         m_tgt_adr_del2 <= "0000000000000";
         m_pending_del2 <= '0';
         m_ack_del2 <= '0';
         m_req_del2 <= '0';
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         m_addr_del <= m_addr_del2;
         m_size_del <= m_size_del2;
         m_ctrl_del <= m_ctrl_del2;
         m_tgt_adr_del <= m_tgt_adr_del2;
         m_pending_del <= m_pending_del2;
         m_ack_del <= m_ack_del2;
         m_req_del <= m_req_del2;
         m_addr_del2 <= m_addr;
         m_size_del2 <= m_size;
         m_ctrl_del2 <= m_ctrl;
         m_tgt_adr_del2 <= m_tgt_adr;
         m_pending_del2 <= m_pending;
         m_ack_del2 <= m_ack;
         m_req_del2 <= m_req;
      END IF;
   END PROCESS;
   cpl_err_xhdl3(6 DOWNTO 3) <= "0000";
   
   xhdl7 <= NOT(rx_eop);
   xhdl8 <= NOT(s_data_ack);
   slave : altpcierd_slave
      GENERIC MAP (
         11
      )
      PORT MAP (
         hclk             => clk_in,
         hrstn            => rstn,
         cfg_busdev       => cfg_busdev_del,
         cfg_maxpload     => cfg_devcsr_del(7 DOWNTO 5),
         cfg_tcvcmap      => cfg_tcvcmap_del,
         m_req            => m_req,
         m_size           => m_size,
         m_addr           => m_addr,
         m_ctrl           => m_ctrl,
         m_tgt_adr        => m_tgt_adr,
         m_ack            => m_ack_del,
         tx_intreq        => app_int_sts_buf,
         pm_event         => open_pm_event,
         err_cplabort     => cpl_err_xhdl3(1),
         pm_event_pb      => pm_event_pb,
         m_pending        => m_pending_del,
         rx_busy          => s_rx_busy,
         tx_busy          => s_tx_busy,
         vc0_out          => s_vc0_out,
         vc1_out          => open_s_vc1_out,
         rx_req           => s_rx_sop,
         rx_ack           => s_rx_ack,
         rx_desc          => rx_desc,
         rx_ws            => open_s_rx_ws,
         rx_data          => rx_data,
         rx_be            => rx_be,
         rx_dv            => s_rx_dv,
         rx_dfr           => xhdl7,
         rx_st_eop        => rx_eop,
         tx_req           => s_tx_req,
         tx_desc          => s_tx_desc,
         tx_ack           => s_tx_ack,
         tx_dfr           => open_s_tx_dfr,
         tx_data          => s_tx_data,
         tx_dv            => open_s_tx_dv,
         tx_err           => s_tx_err,
         fetch_tx_data    => '0',
         nextcyc_is_last  => open_s_nextcyc_is_last,
         last_datacyc     => s_last_datacyc,
         tx_ws            => xhdl8,
         app_msi_num      => app_msi_num_xhdl0,
         app_msi_tc       => app_msi_tc_xhdl2
      );
   
   xhdl9 <= NOT(rx_eop);
   xhdl10 <= NOT(m_data_ack);
   master : altpcierd_master
      GENERIC MAP (
         11
      )
      PORT MAP (
         hclk             => clk_in,
         hrstn            => rstn,
         testtim          => test_sim,
         ko_cpl_spc_vc0   => ko_cpl_spc_vc0,
         ko_cpl_spc_vc1   => ko_cpl_spc_vc1,
         cfg_busdev       => cfg_busdev_del,
         cfg_maxpload     => cfg_devcsr_del(7 DOWNTO 5),
         cfg_maxrdreq     => cfg_devcsr_del(14 DOWNTO 12),
         cfg_rcb          => cfg_linkcsr_del(3),
         cfg_tcvcmap      => cfg_tcvcmap_del,
         trans_pending    => cpl_pending_xhdl4,
         err_cpltim       => cpl_err_xhdl3(0),
         err_cplunexp     => cpl_err_xhdl3(2),
         m_req            => m_req_del,
         m_size           => m_size_del,
         m_addr           => m_addr_del,
         m_ctrl           => m_ctrl_del,
         m_tgt_adr        => m_tgt_adr_del,
         m_ack            => m_ack,
         m_pending        => m_pending,
         rx_busy          => m_rx_busy,
         tx_busy          => open_m_tx_busy,
         vc0_out          => m_vc0_out,
         vc1_out          => open_m_vc1_out,
         rx_req           => m_rx_sop,
         rx_ack           => m_rx_ack,
         rx_desc          => rx_desc,
         rx_ws            => open_m_rx_ws,
         rx_data          => rx_data,
         rx_be            => rx_be,
         rx_dv            => m_rx_dv,
         rx_dfr           => xhdl9,
         rx_st_eop        => rx_eop,
         tx_req           => m_tx_req,
         tx_desc          => m_tx_desc,
         tx_ack           => m_tx_ack,
         tx_dfr           => open_m_tx_dfr,
         tx_data          => m_tx_data,
         tx_dv            => open_m_tx_dv,
         tx_err           => m_tx_err,
         tx_ws            => xhdl10,
         fetch_tx_data    => '0',
         nextcyc_is_last  => open_m_nextcyc_is_last,
         last_datacyc     => m_last_datacyc
      );
   PROCESS (clk_in, rstn)
   BEGIN
      IF ((NOT(rstn)) = '1') THEN
         s_tx_req_del <= '0';
         m_tx_req_del <= '0';
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         IF (s_tx_ack = '1') THEN
            s_tx_req_del <= '0';
         ELSE
            s_tx_req_del <= (s_tx_req AND s_vc0_out);
         END IF;
         IF (m_tx_ack = '1') THEN
            m_tx_req_del <= '0';
         ELSE
            m_tx_req_del <= (m_tx_req AND m_vc0_out);
         END IF;
      END IF;
   END PROCESS;
   tx_stream_data0(74 DOWNTO 0) <= tx_stream_data0_ext(74 DOWNTO 0);
   
   altpcierd_apptx_streaming_intf_vc0 : altpcierd_apptx_streaming_intf
      GENERIC MAP (
         TL_SELECTION  => TL_SELECTION
      )
      PORT MAP (
         clk_in          => clk_in,
         rstn            => rstn,
         m_req           => m_tx_req_del,
         m_ack           => m_tx_ack,
         m_data_ack      => m_data_ack,
         m_tx_data       => m_tx_data,
         m_tx_desc       => m_tx_desc,
         m_last_datacyc  => m_last_datacyc,
         s_req           => s_tx_req_del,
         s_ack           => s_tx_ack,
         s_data_ack      => s_data_ack,
         s_tx_data       => s_tx_data,
         s_tx_desc       => s_tx_desc,
         s_last_datacyc  => s_last_datacyc,
         stream_ready    => tx_stream_ready0,
         stream_wrdata   => tx_stream_data0_ext,
         stream_wr       => tx_stream_valid0_xhdl6,
         cpl_pending     => '0',
         m_tx_err        => m_tx_err,
         s_tx_err        => s_tx_err
      );
   
   xhdl11 <= (app_msi_tc_xhdl2 & app_msi_num_xhdl0);
   altpcierd_msi_streaming_vc0 : altpcierd_appmsi_streaming_intf
      PORT MAP (
         clk_in        => clk_in,
         rstn          => rstn,
         m_req         => app_msi_req_xhdl1,
         m_ack         => app_msi_st_ack,
         m_data        => xhdl11,
         stream_ready  => msi_stream_ready0,
         stream_data   => msi_stream_data0_n,
         stream_valid  => msi_stream_valid0_n
      );
   PROCESS (rstn, clk_in)
   BEGIN
      IF (rstn = '0') THEN
         app_int_sts_r <= '0';
         app_msi_req_xhdl1 <= '0';
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         app_int_sts_r <= app_int_sts_buf;
         IF (app_int_sts_buf = '1' AND app_int_sts_r = '0') THEN
            app_msi_req_xhdl1 <= '1';
         ELSIF (((TL_SELECTION = 0) AND (app_msi_st_ack = '1')) OR ((TL_SELECTION = 6) AND (app_msi_ack = '1'))) THEN
            app_msi_req_xhdl1 <= '0';
         END IF;
      END IF;
   END PROCESS;
   PROCESS (rstn, clk_in)
   BEGIN
      IF (rstn = '0') THEN
         msi_stream_data0 <= "00000000";
         msi_stream_valid0 <= '0';
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         msi_stream_data0 <= msi_stream_data0_n;
         msi_stream_valid0 <= msi_stream_valid0_n;
      END IF;
   END PROCESS;
   aer_msi_num <= "00000";
   pex_msi_num <= "00000";
   app_int_sts <= app_int_sts_buf;
   rx_stream_data0_ext(81 DOWNTO 0) <= rx_stream_data0;
   rx_stream_data0_ext(107 DOWNTO 82) <= "00000000000000000000000000";
   
   
   xhdl12 <= s_rx_busy OR s_tx_busy;
   altpcierd_apprx_streaming_intf_vc0 : altpcierd_apprx_streaming_intf
      GENERIC MAP (
         TL_SELECTION  => TL_SELECTION
      )
      PORT MAP (
         clk             => clk_in,
         rstn            => rstn,
         stream_ready    => rx_stream_ready0_xhdl5,
         stream_valid    => rx_stream_valid0,
         stream_data_in  => rx_stream_data0_ext,
         m_busy          => m_rx_busy,
         s_busy          => xhdl12,
         m_ack           => m_rx_ack,
         s_ack           => s_rx_ack,
         m_rx_sop        => m_rx_sop,
         s_rx_sop        => s_rx_sop,
         rx_data         => rx_data,
         rx_desc         => rx_desc,
         rx_be           => rx_be,
         rx_eop          => rx_eop,
         m_rx_dv         => m_rx_dv,
         s_rx_dv         => s_rx_dv
      );
   
   -------------------------------------------------------------------- 
   -- CONFIGURATION Sideband Input Signals
   -- These are Incremental Compile input boundary registers.  
   -- No combinational logic allowed on the inputs to these registers. 
   -------------------------------------------------------------------
   PROCESS (rstn, clk_in)
   BEGIN
      IF (rstn = '0') THEN
         cfg_busdev_del <= "0000000000000";
         cfg_devcsr_del <= "00000000000000000000000000000000";
         cfg_tcvcmap_del <= "000000000000000000000000";
         cfg_linkcsr_del <= "00000000000000000000000000000000";
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         cfg_busdev_del <= cfg_busdev;
         cfg_devcsr_del <= cfg_devcsr;
         cfg_tcvcmap_del <= cfg_tcvcmap;
         cfg_linkcsr_del <= cfg_linkcsr;
      END IF;
   END PROCESS;
   
END ARCHITECTURE altpcie;
