LIBRARY ieee;                          
use IEEE.std_logic_1164.all;           
use IEEE.std_logic_arith.all;          
use IEEE.std_logic_unsigned.all;       
                                       
LIBRARY altera_mf;                     
USE altera_mf.altera_mf_components.all;
                                       
--
-------------------------------------------------------------------------------
-- Title         : PCI Express Reference Design Dual Port RAM entity
-- Project       : PCI Express MegaCore function
-------------------------------------------------------------------------------
-- File          : altpcierd_dprambe.v
-- Author        : Altera Corporation
-------------------------------------------------------------------------------
-- Description :
-- This is an entity that instantiates a Dual Port RAM with Byte Enables for
-- use in the PCI Express Reference Design
-------------------------------------------------------------------------------
-- Copyright (c) 2005 Altera Corporation. All rights reserved.  Altera products are
-- protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
-- other intellectual property laws.  
--
-- This reference design file, and your use thereof, is subject to and governed by
-- the terms and conditions of the applicable Altera Reference Design License Agreement.
-- By using this reference design file, you indicate your acceptance of such terms and
-- conditions between you and Altera Corporation.  In the event that you do not agree with
-- such terms and conditions, you may not use the reference design file. Please promptly
-- destroy any copies you have made.
--
-- This reference design file being provided on an "as-is" basis and as an accommodation 
-- and therefore all warranties, representations or guarantees of any kind 
-- (whether express, implied or statutory) including, without limitation, warranties of 
-- merchantability, non-infringement, or fitness for a particular purpose, are 
-- specifically disclaimed.  By making this reference design file available, Altera
-- expressly does not recommend, suggest or require that this reference design file be
-- used in combination with any other product not provided by Altera.
-------------------------------------------------------------------------------
ENTITY altpcierd_dprambe IS
   GENERIC (
      ADDR_WIDTH                     :  integer := 8;    
      DATA_WIDTH                     :  integer := 32;    
      BYTE_SIZE                      :  integer := 8);    
   PORT (
      wrclk                   : IN std_logic;   
      wraddr                  : IN std_logic_vector(ADDR_WIDTH - 1 DOWNTO 0);   
      wrdata                  : IN std_logic_vector(DATA_WIDTH - 1 DOWNTO 0);   
      wrbe                    : IN std_logic_vector(DATA_WIDTH / BYTE_SIZE - 1 DOWNTO 0);   
      rdclk                   : IN std_logic;   
      rdclken                 : IN std_logic;   
      rdaddr                  : IN std_logic_vector(ADDR_WIDTH - 1 DOWNTO 0);   
      rddata                  : OUT std_logic_vector(DATA_WIDTH - 1 DOWNTO 0));   
END ENTITY altpcierd_dprambe;
ARCHITECTURE translated OF altpcierd_dprambe IS


   FUNCTION get_numwords (                    
      val      : integer) RETURN integer IS   
                                              
      VARIABLE rtn      : integer:=1;         
   BEGIN                                      
   	  rtn:=1    ;                             
   	  FOR i IN 1 TO val LOOP                  
   		  rtn := 2*rtn;                        
   	  END loop;                               
   	  RETURN rtn;                             
   END get_numwords;                          
                                              
                                              
   CONSTANT  NUMWORDS_RAM          :  integer := get_numwords(ADDR_WIDTH);
   CONSTANT  WIDTHBYTEENAA         :  integer := DATA_WIDTH / BYTE_SIZE;    
   SIGNAL q_a                      :  std_logic_vector(DATA_WIDTH - 1 DOWNTO 0);   
   SIGNAL wren                     :  std_logic;   
   SIGNAL cst_1b_zer0              :  std_logic;   
   SIGNAL cst_1b_one               :  std_logic;   
   SIGNAL cst_std_logic_vector_type_one   :  std_logic_vector(127 DOWNTO 0);   
   SIGNAL cst_std_logic_vector_type_zero  :  std_logic_vector(63 DOWNTO 0);   
   SIGNAL data_b_ram               :  std_logic_vector(DATA_WIDTH - 1 DOWNTO 0);   
   SIGNAL rddata_xhdl1             :  std_logic_vector(DATA_WIDTH - 1 DOWNTO 0);   
   SIGNAL cst_1b_zero              :  std_logic;   
BEGIN
   rddata <= rddata_xhdl1;
   wren <= '1' ;
   data_b_ram(DATA_WIDTH - 1 DOWNTO 0) <= cst_std_logic_vector_type_one(DATA_WIDTH - 1 DOWNTO 0) ;
   cst_1b_zero <= '0' ;
   cst_1b_one <= '1' ;
   cst_std_logic_vector_type_one <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111" ;
   cst_std_logic_vector_type_zero <= "0000000000000000000000000000000000000000000000000000000000000000" ;
   -- <<X-HDL>> Can't find translated component 'altsyncram'. Port & generic names and types may not match. No template will be included
   dpram : altsyncram 
      GENERIC MAP (
         byteena_aclr_a => "NONE",
         widthad_b => ADDR_WIDTH,
         intended_device_family => "Stratix",
         outdata_aclr_b => "NONE",
         width_a => DATA_WIDTH,
         width_b => DATA_WIDTH,
         indata_aclr_a => "NONE",
         address_aclr_a => "NONE",
         address_aclr_b => "NONE",
         address_reg_b => "CLOCK1",
         numwords_a => NUMWORDS_RAM,
         numwords_b => NUMWORDS_RAM,
         width_byteena_a => WIDTHBYTEENAA,
         ram_block_type => "AUTO",
         wrcontrol_aclr_a => "NONE",
         lpm_type => "altsyncram",
         outdata_reg_b => "CLOCK1",
         operation_mode => "DUAL_PORT",
         widthad_a => ADDR_WIDTH)
      PORT MAP (
         wren_a => wren,
         clock0 => wrclk,
         clock1 => rdclk,
         clocken1 => rdclken,
         byteena_a => wrbe,
         address_a => wraddr,
         address_b => rdaddr,
         data_a => wrdata,
         q_b => rddata_xhdl1,
         q_a => q_a,
         addressstall_a => cst_1b_zero,
         addressstall_b => cst_1b_zero,
         byteena_b => cst_std_logic_vector_type_one(0 DOWNTO 0),
         aclr0 => cst_1b_zero,
         aclr1 => cst_1b_zero,
         clocken0 => cst_1b_one,
         data_b => data_b_ram,
         rden_b => cst_1b_one,
         wren_b => cst_1b_zero);   
   
END ARCHITECTURE translated;
