LIBRARY ieee;                          
use IEEE.std_logic_1164.all;           
use IEEE.std_logic_arith.all;          
use IEEE.std_logic_unsigned.all;       
                                       
LIBRARY altera_mf;                     
USE altera_mf.altera_mf_components.all;
                                       
--
-- /**
-- *
-- *  This Verilog HDL File is used for simulation and synthesis in the simple DMA design example.  
-- *  It provides master and slave arbitration on the transmit interface for each VC.
-- *
-- */
-------------------------------------------------------------------------------
-- Title         : PCI Express Reference Design apptxchan Entity
-- Project       : PCI Express MegaCore function
-------------------------------------------------------------------------------
-- File          : altpcierd_apptxchan.v
-- Author        : Altera Corporation
-------------------------------------------------------------------------------
-- Description :
-- This is an entity that provides master/slave arbitration on the transmit 
-- interface for each VC.
-------------------------------------------------------------------------------
-- Copyright (c) 2006 Altera Corporation. All rights reserved.  Altera products are
-- protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
-- other intellectual property laws.  
--
-- This reference design file, and your use thereof, is subject to and governed by
-- the terms and conditions of the applicable Altera Reference Design License Agreement.
-- By using this reference design file, you indicate your acceptance of such terms and
-- conditions between you and Altera Corporation.  In the event that you do not agree with
-- such terms and conditions, you may not use the reference design file. Please promptly
-- destroy any copies you have made.
--
-- This reference design file being provided on an "as-is" basis and as an accommodation 
-- and therefore all warranties, representations or guarantees of any kind 
-- (whether express, implied or statutory) including, without limitation, warranties of 
-- merchantability, non-infringement, or fitness for a particular purpose, are 
-- specifically disclaimed.  By making this reference design file available, Altera
-- expressly does not recommend, suggest or require that this reference design file be
-- used in combination with any other product not provided by Altera. 
-------------------------------------------------------------------------------
ENTITY altpcierd_apptxchan IS
   PORT (
      clk_in                  : IN std_logic;   --  Clock for synchronous interface to application
      rstn                    : IN std_logic;   
      s_nextcyc_is_last       : IN std_logic;   
      s_last_datacyc          : IN std_logic;   
      m_nextcyc_is_last       : IN std_logic;   
      m_last_datacyc          : IN std_logic;   
      s_vc0_out               : IN std_logic;   
      s_tx_req                : IN std_logic;   
      s_tx_desc               : IN std_logic_vector(127 DOWNTO 0);   
      s_tx_err                : IN std_logic;   
      s_tx_dv                 : IN std_logic;   
      s_tx_dfr                : IN std_logic;   
      s_tx_data               : IN std_logic_vector(63 DOWNTO 0);   
      s_tx_ws                 : OUT std_logic;   
      m_vc0_out               : IN std_logic;   
      m_tx_req                : IN std_logic;   
      m_tx_desc               : IN std_logic_vector(127 DOWNTO 0);   
      m_tx_err                : IN std_logic;   
      m_tx_dv                 : IN std_logic;   
      m_tx_dfr                : IN std_logic;   
      m_tx_data               : IN std_logic_vector(63 DOWNTO 0);   
      m_tx_ws                 : OUT std_logic;   
      tx_ack0                 : IN std_logic;   
      tx_ws0                  : IN std_logic;   
      s_tx_ack0               : OUT std_logic;   
      m_tx_ack0               : OUT std_logic;   
      tx_req0                 : OUT std_logic;   
      tx_desc0                : OUT std_logic_vector(127 DOWNTO 0);   
      tx_dv0                  : OUT std_logic;   
      tx_dfr0                 : OUT std_logic;   
      tx_data0                : OUT std_logic_vector(63 DOWNTO 0);   
      tx_err0                 : OUT std_logic);   
END ENTITY altpcierd_apptxchan;
ARCHITECTURE translated OF altpcierd_apptxchan IS
   COMPONENT altpcierd_txdatafifo
      PORT (
         aclr                    : IN  std_logic;
         clock                   : IN  std_logic;
         data                    : IN  std_logic_vector(63 DOWNTO 0);
         rdreq                   : IN  std_logic;
         sclr                    : IN  std_logic;
         wrreq                   : IN  std_logic;
         almost_full             : OUT std_logic;
         empty                   : OUT std_logic;
         full                    : OUT std_logic;
         q                       : OUT std_logic_vector(63 DOWNTO 0));
   END COMPONENT;
   SIGNAL tx_err0_n                :  std_logic;   
   SIGNAL s_tx_retry               :  std_logic;   
   SIGNAL m_tx_retry               :  std_logic;   
   SIGNAL sel_txmaster0            :  std_logic;   
   SIGNAL sel_txmaster0_r          :  std_logic;   
   SIGNAL m_enable_dataphase0      :  std_logic;   
   SIGNAL s_enable_dataphase0      :  std_logic;   
   SIGNAL tx_singledataphase0      :  std_logic;   
   SIGNAL vc0_tx_state             :  std_logic_vector(3 DOWNTO 0);   
   SIGNAL tx_dodataphase0          :  std_logic;   
   SIGNAL s_tx_req_del0            :  std_logic;   
   SIGNAL m_tx_req_del0            :  std_logic;   
   SIGNAL tx_req_cyc1              :  std_logic;   
   -- txdatafifo
   SIGNAL wr_data0                 :  std_logic_vector(63 DOWNTO 0);   
   SIGNAL wr_req0                  :  std_logic;   
   SIGNAL wr_req_ctl               :  std_logic;   
   SIGNAL rd_req0                  :  std_logic;   
   SIGNAL tx_fifo_full0            :  std_logic;   
   SIGNAL tx_m_nextcyc_is_last     :  std_logic;   
   SIGNAL tx_m_last_datacyc        :  std_logic;   
   SIGNAL tx_s_nextcyc_is_last     :  std_logic;   
   SIGNAL tx_s_last_datacyc        :  std_logic;   
   SIGNAL fifo_unused_outputs      :  std_logic_vector(59 DOWNTO 0);   
   SIGNAL tx_fifo_almostfull       :  std_logic;   
   SIGNAL tx_ctlfifo_almostfull    :  std_logic;   
   -- synthesis preserve 
   SIGNAL tx_fifo_notfull_del      :  std_logic;   
   -- synthesis preserve 
   SIGNAL tx_fifo_notfull_del_copy1:  std_logic;   
   -- synthesis preserve 
   SIGNAL tx_fifo_notfull_del_copy2:  std_logic;   
   -- synthesis preserve 
   SIGNAL tx_ctlfifo_notfull_del   :  std_logic;   
   SIGNAL tx_ctlfifo_output        :  std_logic_vector(63 DOWNTO 0);   
   --------------------------------------------------------------
   --    Arbitration between master and target for transmission
   --------------------------------------------------------------
   -- vc0_state SM states
   CONSTANT  TX_MASTER_IDLE        :  std_logic_vector(3 DOWNTO 0) := "0000";    --  master states
   CONSTANT  TX_MASTER_START_1     :  std_logic_vector(3 DOWNTO 0) := "0001";    
   CONSTANT  TX_MASTER_START_2     :  std_logic_vector(3 DOWNTO 0) := "0010";    
   CONSTANT  TX_MASTER_WAIT_DONE   :  std_logic_vector(3 DOWNTO 0) := "0011";    
   CONSTANT  TX_SLAVE_IDLE         :  std_logic_vector(3 DOWNTO 0) := "0100";    --  slave states
   CONSTANT  TX_SLAVE_START_1      :  std_logic_vector(3 DOWNTO 0) := "0101";    
   CONSTANT  TX_SLAVE_START_2      :  std_logic_vector(3 DOWNTO 0) := "0110";    
   CONSTANT  TX_SLAVE_WAIT_DONE    :  std_logic_vector(3 DOWNTO 0) := "0111";    
   SIGNAL temp_xhdl11              :  std_logic_vector(127 DOWNTO 0);   
   SIGNAL temp_xhdl12              :  std_logic_vector(127 DOWNTO 0);   
   SIGNAL temp_xhdl13              :  std_logic_vector(127 DOWNTO 0);   
   SIGNAL temp_xhdl14              :  std_logic_vector(127 DOWNTO 0);   
   SIGNAL temp_xhdl15              :  std_logic;   
   SIGNAL temp_xhdl16              :  std_logic;   
   SIGNAL temp_xhdl17              :  std_logic;   --  for tx_dfr0
   SIGNAL temp_xhdl18              :  std_logic;   
   SIGNAL temp_xhdl19              :  std_logic;   
   SIGNAL temp_xhdl20              :  std_logic;   
   SIGNAL temp_xhdl21              :  std_logic;   
   SIGNAL temp_xhdl22              :  std_logic;   
   SIGNAL temp_xhdl23              :  std_logic;   
   SIGNAL temp_xhdl24              :  std_logic;   
   SIGNAL temp_xhdl25              :  std_logic;   
   SIGNAL temp_xhdl26              :  std_logic;   --  for tx_dfr0
   SIGNAL temp_xhdl27              :  std_logic;   
   SIGNAL temp_xhdl28              :  std_logic;   
   SIGNAL temp_xhdl29              :  std_logic;   
   SIGNAL temp_xhdl30              :  std_logic;   
   SIGNAL temp_xhdl31              :  std_logic;   
   SIGNAL temp_xhdl32              :  std_logic;   
   SIGNAL temp_xhdl33              :  std_logic;   
   -- fifo data and control signals
   SIGNAL temp_xhdl34              :  std_logic_vector(63 DOWNTO 0);   
   SIGNAL temp_xhdl35              :  std_logic;   
   SIGNAL temp_xhdl36              :  std_logic;   
   -- holds tx_data
   SIGNAL port_xhdl37              :  std_logic;   
   SIGNAL port_xhdl38              :  std_logic;   
   -- holds flags for controlling tx_dfr and tx_dv					 
   SIGNAL xhdl_39                  :  std_logic_vector(63 DOWNTO 0);   
   SIGNAL port_xhdl40              :  std_logic;   
   SIGNAL port_xhdl41              :  std_logic;   
   SIGNAL s_tx_ws_xhdl1            :  std_logic;   
   SIGNAL m_tx_ws_xhdl2            :  std_logic;   
   SIGNAL s_tx_ack0_xhdl3          :  std_logic;   
   SIGNAL m_tx_ack0_xhdl4          :  std_logic;   
   SIGNAL tx_req0_xhdl5            :  std_logic;   
   SIGNAL tx_desc0_xhdl6           :  std_logic_vector(127 DOWNTO 0);   
   SIGNAL tx_dv0_xhdl7             :  std_logic;   
   SIGNAL tx_dfr0_xhdl8            :  std_logic;   
   SIGNAL tx_data0_xhdl9           :  std_logic_vector(63 DOWNTO 0);   
   SIGNAL tx_err0_xhdl10           :  std_logic;   
BEGIN
   s_tx_ws <= s_tx_ws_xhdl1;
   m_tx_ws <= m_tx_ws_xhdl2;
   s_tx_ack0 <= s_tx_ack0_xhdl3;
   m_tx_ack0 <= m_tx_ack0_xhdl4;
   tx_req0 <= tx_req0_xhdl5;
   tx_desc0 <= tx_desc0_xhdl6;
   tx_dv0 <= tx_dv0_xhdl7;
   tx_dfr0 <= tx_dfr0_xhdl8;
   tx_data0 <= tx_data0_xhdl9;
   tx_err0 <= tx_err0_xhdl10;
   temp_xhdl11 <= m_tx_desc WHEN (m_tx_ack0_xhdl4) = '1' ELSE tx_desc0_xhdl6;
   temp_xhdl12 <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000" WHEN tx_ack0 = '1' ELSE temp_xhdl11;
   temp_xhdl13 <= s_tx_desc WHEN (s_tx_ack0_xhdl3) = '1' ELSE tx_desc0_xhdl6;
   temp_xhdl14 <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000" WHEN tx_ack0 = '1' ELSE temp_xhdl13;
   temp_xhdl15 <= '0' WHEN (NOT m_tx_dfr AND NOT m_tx_dv) = '1' ELSE m_enable_dataphase0;
   temp_xhdl16 <= '0' WHEN (NOT m_tx_dfr AND NOT m_tx_dv) = '1' ELSE m_enable_dataphase0;
   temp_xhdl17 <= '0' WHEN tx_req_cyc1 = '1' ELSE tx_req_cyc1;
   temp_xhdl18 <= '0' WHEN tx_ack0 = '1' ELSE tx_req0_xhdl5;
   temp_xhdl19 <= '0' WHEN tx_singledataphase0 = '1' ELSE tx_dfr0_xhdl8;
   temp_xhdl20 <= '0' WHEN (tx_m_nextcyc_is_last AND NOT tx_ws0) = '1' ELSE tx_dfr0_xhdl8;
   temp_xhdl21 <= '0' WHEN (tx_m_last_datacyc AND NOT tx_ws0) = '1' ELSE tx_dv0_xhdl7;
   temp_xhdl22 <= '1' WHEN tx_dfr0_xhdl8 = '1' ELSE temp_xhdl21;
   temp_xhdl23 <= '0' WHEN (NOT m_tx_dfr AND NOT m_tx_dv) = '1' ELSE m_enable_dataphase0;
   temp_xhdl24 <= '0' WHEN (NOT s_tx_dfr AND NOT s_tx_dv) = '1' ELSE s_enable_dataphase0;
   temp_xhdl25 <= '0' WHEN (NOT s_tx_dfr AND NOT s_tx_dv) = '1' ELSE s_enable_dataphase0;
   temp_xhdl26 <= '0' WHEN tx_req_cyc1 = '1' ELSE tx_req_cyc1;
   temp_xhdl27 <= '0' WHEN tx_ack0 = '1' ELSE tx_req0_xhdl5;
   temp_xhdl28 <= '0' WHEN tx_singledataphase0 = '1' ELSE tx_dfr0_xhdl8;
   temp_xhdl29 <= '0' WHEN (tx_s_nextcyc_is_last AND NOT tx_ws0) = '1' ELSE tx_dfr0_xhdl8;
   temp_xhdl30 <= '0' WHEN (tx_s_last_datacyc AND NOT tx_ws0) = '1' ELSE tx_dv0_xhdl7;
   temp_xhdl31 <= '1' WHEN tx_dfr0_xhdl8 = '1' ELSE temp_xhdl30;
   temp_xhdl32 <= '0' WHEN (NOT s_tx_dfr AND NOT s_tx_dv) = '1' ELSE s_enable_dataphase0;
   PROCESS (rstn, clk_in)
   BEGIN
      IF (rstn = '0') THEN
         sel_txmaster0_r <= '0';    
         sel_txmaster0 <= '0';    
         tx_req0_xhdl5 <= '0';    
         tx_dfr0_xhdl8 <= '0';    
         tx_dv0_xhdl7 <= '0';    
         tx_err0_xhdl10 <= '0';    
         tx_desc0_xhdl6 <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";    
         vc0_tx_state <= TX_MASTER_IDLE;    
         tx_dodataphase0 <= '0';    
         s_tx_req_del0 <= '0';    
         m_tx_req_del0 <= '0';    
         m_tx_ack0_xhdl4 <= '0';    
         s_tx_ack0_xhdl3 <= '0';    
         tx_singledataphase0 <= '0';    
         m_enable_dataphase0 <= '0';    
         s_enable_dataphase0 <= '0';    
         tx_req_cyc1 <= '1';    
         tx_fifo_notfull_del <= '1';    
         tx_fifo_notfull_del_copy1 <= '1';    
         tx_fifo_notfull_del_copy2 <= '1';    
         tx_ctlfifo_notfull_del <= '1';    
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         sel_txmaster0_r <= sel_txmaster0;    
         s_tx_req_del0 <= s_tx_req AND s_vc0_out;    
         m_tx_req_del0 <= m_tx_req AND m_vc0_out;    
         tx_err0_xhdl10 <= tx_err0_n;    
         tx_fifo_notfull_del <= NOT tx_fifo_almostfull;    
         tx_fifo_notfull_del_copy1 <= NOT tx_fifo_almostfull;    
         tx_fifo_notfull_del_copy2 <= NOT tx_fifo_almostfull;    
         tx_ctlfifo_notfull_del <= NOT tx_ctlfifo_almostfull;    
         IF (sel_txmaster0 = '1') THEN
            tx_desc0_xhdl6 <= temp_xhdl12;    
         ELSE
            tx_desc0_xhdl6 <= temp_xhdl14;    
         END IF;
         -- this state machine arbitrates between master and slave tx requests.
         -- it generates tx interface control signals in response to tx requests,
         -- and grants tx access to the next request when the transfer is complete.
         -- fair arbitration is used for granting access to the tx interface.
         
         CASE vc0_tx_state IS
            WHEN TX_MASTER_IDLE =>
                     -- wait for tx_req from master or slave.
                     -- master has priority
                     
                     tx_dfr0_xhdl8 <= '0';    
                     tx_dv0_xhdl7 <= '0';    
                     -- wait for tx request from master 
                     
                     IF (m_tx_req_del0 = '1') THEN
                        -- wait for atleast 2nd cycle of tx_req
                        
                        sel_txmaster0 <= '1';    
                        vc0_tx_state <= TX_MASTER_START_1;    
                        m_tx_ack0_xhdl4 <= '1';    
                        m_enable_dataphase0 <= m_tx_dfr OR m_tx_dv;    
                     ELSE
                        IF (s_tx_req_del0 = '1') THEN
                           sel_txmaster0 <= '0';    
                           vc0_tx_state <= TX_SLAVE_START_1;    
                           s_tx_ack0_xhdl3 <= '1';    
                           s_enable_dataphase0 <= s_tx_dfr OR s_tx_dv;    
                        END IF;
                     END IF;
            WHEN TX_MASTER_START_1 =>
                     m_tx_ack0_xhdl4 <= '0';    
                     vc0_tx_state <= TX_MASTER_START_2;    
                     tx_dodataphase0 <= m_tx_dv;    
                     tx_singledataphase0 <= NOT m_tx_dfr AND m_tx_dv;    
                     m_enable_dataphase0 <= temp_xhdl15;    
            WHEN TX_MASTER_START_2 =>
                     m_tx_ack0_xhdl4 <= '0';    
                     -- The piping of the TxData
                     -- is done one cycle after the tx_req
                     -- because the application is priming
                     -- it's own pipe up to this point  
                     
                     m_tx_ack0_xhdl4 <= '0';    
                     tx_req0_xhdl5 <= '1';    
                     tx_req_cyc1 <= '1';    
                     tx_dfr0_xhdl8 <= m_tx_dfr OR tx_dodataphase0;    --  assert dfr if there is data
                     tx_dv0_xhdl7 <= '0';    
                     vc0_tx_state <= TX_MASTER_WAIT_DONE;    
                     m_enable_dataphase0 <= temp_xhdl16;    
            -- disallow s_tx_ws after slave data phase is done.  
            -- do not reenable until this state is over and next 
            -- tx_req is serviced.
            
            WHEN TX_MASTER_WAIT_DONE =>
                     tx_req_cyc1 <= temp_xhdl17;    
                     tx_req0_xhdl5 <= temp_xhdl18;    
                     IF (tx_req_cyc1 = '1') THEN
                        tx_dfr0_xhdl8 <= temp_xhdl19;    
                     ELSE
                        tx_dfr0_xhdl8 <= temp_xhdl20;    
                     END IF;
                     tx_dv0_xhdl7 <= temp_xhdl22;    
                     m_enable_dataphase0 <= temp_xhdl23;    
                     IF (((NOT tx_dodataphase0 AND tx_ack0) OR ((NOT tx_ws0 AND tx_dv0_xhdl7) AND NOT tx_dfr0_xhdl8)) = '1') THEN
                        IF ((NOT s_tx_req_del0 AND m_tx_req_del0) = '1') THEN
                           sel_txmaster0 <= '1';    
                           vc0_tx_state <= TX_MASTER_START_1;    
                           m_tx_ack0_xhdl4 <= '1';    
                           m_enable_dataphase0 <= m_tx_dfr OR m_tx_dv;    
                        ELSE
                           vc0_tx_state <= TX_SLAVE_IDLE;    
                        END IF;
                     END IF;
            WHEN TX_SLAVE_IDLE =>
                     -- wait for tx_req from master or slave
                     -- slave has priority
                     
                     tx_dfr0_xhdl8 <= '0';    
                     tx_dv0_xhdl7 <= '0';    
                     -- wait for tx request from master 
                     
                     IF (s_tx_req_del0 = '1') THEN
                        sel_txmaster0 <= '0';    
                        vc0_tx_state <= TX_SLAVE_START_1;    
                        s_tx_ack0_xhdl3 <= '1';    
                        s_enable_dataphase0 <= s_tx_dfr OR s_tx_dv;    
                     ELSE
                        IF (m_tx_req_del0 = '1') THEN
                           sel_txmaster0 <= '1';    
                           vc0_tx_state <= TX_MASTER_START_1;    
                           m_tx_ack0_xhdl4 <= '1';    
                           m_enable_dataphase0 <= m_tx_dfr OR m_tx_dv;    
                        END IF;
                     END IF;
            WHEN TX_SLAVE_START_1 =>
                     s_tx_ack0_xhdl3 <= '0';    
                     vc0_tx_state <= TX_SLAVE_START_2;    
                     tx_dodataphase0 <= s_tx_dv;    
                     tx_singledataphase0 <= NOT s_tx_dfr AND s_tx_dv;    
                     s_enable_dataphase0 <= temp_xhdl24;    
            WHEN TX_SLAVE_START_2 =>
                     s_tx_ack0_xhdl3 <= '0';    
                     tx_req0_xhdl5 <= '1';    
                     tx_req_cyc1 <= '1';    
                     tx_dfr0_xhdl8 <= tx_dodataphase0;    --  tx_dfr for first data cycle
                     tx_dv0_xhdl7 <= '0';    
                     vc0_tx_state <= TX_SLAVE_WAIT_DONE;    
                     s_enable_dataphase0 <= temp_xhdl25;    
            -- disallow s_tx_ws after slave data phase is done.  
            -- do not reenable until this state is over and next 
            -- tx_req is serviced.
            
            WHEN TX_SLAVE_WAIT_DONE =>
                     tx_req_cyc1 <= temp_xhdl26;    
                     tx_req0_xhdl5 <= temp_xhdl27;    
                     --  deassert dfr0 when draining fifo (i.e. when fifo is not full, but we are not writing
                     --  to it).
                     
                     IF (tx_req_cyc1 = '1') THEN
                        tx_dfr0_xhdl8 <= temp_xhdl28;    
                     ELSE
                        tx_dfr0_xhdl8 <= temp_xhdl29;    
                     END IF;
                     tx_dv0_xhdl7 <= temp_xhdl31;    
                     s_enable_dataphase0 <= temp_xhdl32;    
                     IF (((NOT tx_dodataphase0 AND tx_ack0) OR ((NOT tx_ws0 AND tx_dv0_xhdl7) AND NOT tx_dfr0_xhdl8)) = '1') THEN
                        IF (m_tx_req_del0 = '1') THEN
                           -- wait for atleast 2nd cycle of tx_req
                           
                           sel_txmaster0 <= '1';    
                           vc0_tx_state <= TX_MASTER_START_1;    
                           m_tx_ack0_xhdl4 <= '1';    
                           m_enable_dataphase0 <= m_tx_dfr OR m_tx_dv;    
                        ELSE
                           vc0_tx_state <= TX_MASTER_IDLE;    
                        END IF;
                     END IF;
            WHEN OTHERS =>
                     NULL;
            
         END CASE;
      END IF;
   END PROCESS;
   m_tx_ws_xhdl2 <= NOT ((m_enable_dataphase0 AND m_tx_dv) AND tx_fifo_notfull_del) ;
   s_tx_ws_xhdl1 <= NOT ((s_enable_dataphase0 AND s_tx_dv) AND tx_fifo_notfull_del_copy1) ;
   temp_xhdl33 <= m_tx_err WHEN (sel_txmaster0_r = '1') ELSE s_tx_err;
   tx_err0_n <= temp_xhdl33 ;
   temp_xhdl34 <= m_tx_data WHEN sel_txmaster0 = '1' ELSE s_tx_data;
   wr_data0 <= temp_xhdl34 ;
   temp_xhdl35 <= ((m_tx_dv AND m_enable_dataphase0) AND tx_fifo_notfull_del_copy2) WHEN sel_txmaster0 = '1' ELSE ((s_tx_dv AND s_enable_dataphase0) AND tx_fifo_notfull_del_copy2);
   wr_req0 <= temp_xhdl35 ;
   temp_xhdl36 <= ((m_tx_dv AND m_enable_dataphase0) AND tx_ctlfifo_notfull_del) WHEN sel_txmaster0 = '1' ELSE ((s_tx_dv AND s_enable_dataphase0) AND tx_ctlfifo_notfull_del);
   wr_req_ctl <= temp_xhdl36 ;
   rd_req0 <= tx_dv0_xhdl7 AND NOT tx_ws0 ;
   tx_m_nextcyc_is_last <= tx_ctlfifo_output(3) ;
   tx_m_last_datacyc <= tx_ctlfifo_output(2) ;
   tx_s_nextcyc_is_last <= tx_ctlfifo_output(1) ;
   tx_s_last_datacyc <= tx_ctlfifo_output(0) ;
   port_xhdl37 <= NOT rstn;
   port_xhdl38 <= '0';
   altpcierd_txdatafifo_vc0 : altpcierd_txdatafifo 
      PORT MAP (
         aclr => port_xhdl37,
         sclr => port_xhdl38,
         clock => clk_in,
         data => wr_data0,
         wrreq => wr_req0,
         rdreq => rd_req0,
         empty => open,
         full => tx_fifo_full0,
         almost_full => tx_fifo_almostfull,
         q => tx_data0_xhdl9);   
   
   xhdl_39 <= "000000000000000000000000000000000000000000000000000000000000" & m_nextcyc_is_last & m_last_datacyc & s_nextcyc_is_last & s_last_datacyc;
   port_xhdl40 <= NOT rstn;
   port_xhdl41 <= '0';
   altpcierd_txctlfifo_vc0 : altpcierd_txdatafifo 
      PORT MAP (
         aclr => port_xhdl40,
         sclr => port_xhdl41,
         clock => clk_in,
         data => xhdl_39,
         wrreq => wr_req_ctl,
         rdreq => rd_req0,
         empty => open,
         full => open,
         almost_full => tx_ctlfifo_almostfull,
         q => tx_ctlfifo_output);   
   
END ARCHITECTURE translated;
