LIBRARY ieee;                          
use IEEE.std_logic_1164.all;           
use IEEE.std_logic_arith.all;          
use IEEE.std_logic_unsigned.all;       
                                       
LIBRARY altera_mf;                     
USE altera_mf.altera_mf_components.all;
                                       
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
-- synthesis verilog_version verilog_2001
-------------------------------------------------------------------------------
-- Title         : PCI Express Reference Design Example Application 
-- Project       : PCI Express MegaCore function
-------------------------------------------------------------------------------
-- File          : core_wrapper_tx.v
-- Author        : Altera Corporation
-------------------------------------------------------------------------------
-- Description :
-- This is the complete example application for the PCI Express Reference
-- Design. This has all of the application logic for the example.
-------------------------------------------------------------------------------
-- Copyright (c) 2006 Altera Corporation. All rights reserved.  Altera products are
-- protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
-- other intellectual property laws.  
--
-- This reference design file, and your use thereof, is subject to and governed by
-- the terms and conditions of the applicable Altera Reference Design License Agreement.
-- By using this reference design file, you indicate your acceptance of such terms and
-- conditions between you and Altera Corporation.  In the event that you do not agree with
-- such terms and conditions, you may not use the reference design file. Please promptly
-- destroy any copies you have made.
--
-- This reference design file being provided on an "as-is" basis and as an accommodation 
-- and therefore all warranties, representations or guarantees of any kind 
-- (whether express, implied or statutory) including, without limitation, warranties of 
-- merchantability, non-infringement, or fitness for a particular purpose, are 
-- specifically disclaimed.  By making this reference design file available, Altera
-- expressly does not recommend, suggest or require that this reference design file be
-- used in combination with any other product not provided by Altera. 
-------------------------------------------------------------------------------
ENTITY altpcierd_apprx_streaming_intf IS
   GENERIC (
      TL_SELECTION    : INTEGER := 6        -- streaming interface format selection.
   );
   PORT (
      --  0 = ICM format, 6 = 7.2 format.
      
      clk             : IN STD_LOGIC;
      rstn            : IN STD_LOGIC;
      
      stream_ready    : OUT STD_LOGIC;
      stream_valid    : IN STD_LOGIC;
      stream_data_in  : IN STD_LOGIC_VECTOR(107 DOWNTO 0);
      m_busy          : IN STD_LOGIC;
      s_busy          : IN STD_LOGIC;
      m_rx_dv         : OUT STD_LOGIC;
      s_rx_dv         : OUT STD_LOGIC;
      m_ack           : IN STD_LOGIC;
      s_ack           : IN STD_LOGIC;
      m_rx_sop        : OUT STD_LOGIC;
      s_rx_sop        : OUT STD_LOGIC;
      rx_data         : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
      rx_desc         : OUT STD_LOGIC_VECTOR(135 DOWNTO 0);
      rx_be           : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      rx_eop          : OUT STD_LOGIC
   );
END ENTITY altpcierd_apprx_streaming_intf;
ARCHITECTURE altpcie OF altpcierd_apprx_streaming_intf IS
   COMPONENT altpcierd_stream_fifo_lkahd IS
      GENERIC (
         RAMTYPE         : STRING := "RAM_BLOCK_TYPE=M512";
         USEEAB          : STRING := "ON";
         ALMOSTFULL      : INTEGER := 10;
         NUMWORDS        : INTEGER := 16;
         WIDTHU          : INTEGER := 4
      );
      PORT (
         aclr            : IN STD_LOGIC;
         clock           : IN STD_LOGIC;
         data            : IN STD_LOGIC_VECTOR(107 DOWNTO 0);
         rdreq           : IN STD_LOGIC;
         wrreq           : IN STD_LOGIC;
         almost_empty    : OUT STD_LOGIC;
         almost_full     : OUT STD_LOGIC;
         empty           : OUT STD_LOGIC;
         full            : OUT STD_LOGIC;
         q               : OUT STD_LOGIC_VECTOR(107 DOWNTO 0);
         usedw           : OUT STD_LOGIC_VECTOR(WIDTHU - 1 DOWNTO 0)
      );
   END COMPONENT;
   
   COMPONENT altpcierd_apprxstream_decode IS
      PORT (
         clk             : IN STD_LOGIC;
         rstn            : IN STD_LOGIC;
         rx_st_valid     : IN STD_LOGIC;
         rx_st_data      : IN STD_LOGIC_VECTOR(135 DOWNTO 0);
         rx_st_ready     : OUT STD_LOGIC;
         m_busy          : IN STD_LOGIC;
         s_busy          : IN STD_LOGIC;
         m_ack           : IN STD_LOGIC;
         s_ack           : IN STD_LOGIC;
         m_rx_sop        : OUT STD_LOGIC;
         s_rx_sop        : OUT STD_LOGIC;
         rx_eop          : OUT STD_LOGIC;
         rx_data         : OUT STD_LOGIC_VECTOR(63 DOWNTO 0);
         rx_desc         : OUT STD_LOGIC_VECTOR(135 DOWNTO 0);
         rx_be           : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
         m_rx_dv         : OUT STD_LOGIC;
         s_rx_dv         : OUT STD_LOGIC
      );
   END COMPONENT;
   
   COMPONENT altpcierd_apprxstream_formatter IS
      GENERIC (
         TL_SELECTION    : INTEGER := 6 
      );
      PORT (
         clk             : IN STD_LOGIC;
         rstn            : IN STD_LOGIC;
         fifo_valid      : IN STD_LOGIC;
         fifo_data       : IN STD_LOGIC_VECTOR(107 DOWNTO 0);
         rx_st_data      : OUT STD_LOGIC_VECTOR(107 DOWNTO 0);
         rx_st_valid     : OUT STD_LOGIC;
         rx_st_ready     : IN STD_LOGIC;
         fifo_ready      : OUT STD_LOGIC
      );
   END COMPONENT;
   
   

   SIGNAL stream_data_in_del : STD_LOGIC_VECTOR(107 DOWNTO 0);      -- input boundary reg
   SIGNAL stream_valid_del   : STD_LOGIC;       -- input boundary reg
   
   -- Fifo 
   SIGNAL open_fifo_full     : STD_LOGIC;
   SIGNAL fifo_empty         : STD_LOGIC;
   SIGNAL fifo_almostfull    : STD_LOGIC;
   SIGNAL fifo_rd            : STD_LOGIC;
   SIGNAL fifo_rddata        : STD_LOGIC_VECTOR(107 DOWNTO 0);
   
   SIGNAL rx_st_valid        : STD_LOGIC;
   SIGNAL rx_st_data_ext     : STD_LOGIC_VECTOR(135 DOWNTO 0);
   SIGNAL rx_st_data         : STD_LOGIC_VECTOR(107 DOWNTO 0);
   SIGNAL rx_st_ready        : STD_LOGIC;
   
   SIGNAL open_almost_empty  : STD_LOGIC;
   -- X-HDL generated signals
   SIGNAL xhdl8 : STD_LOGIC;
   SIGNAL xhdl9 : STD_LOGIC;
   SIGNAL xhdl10 : STD_LOGIC;
   
   -- Declare intermediate signals for referenced outputs
   SIGNAL m_rx_dv_xhdl0      : STD_LOGIC;
   SIGNAL s_rx_dv_xhdl6      : STD_LOGIC;
   SIGNAL m_rx_sop_xhdl1     : STD_LOGIC;
   SIGNAL s_rx_sop_xhdl7     : STD_LOGIC;
   SIGNAL rx_data_xhdl3      : STD_LOGIC_VECTOR(63 DOWNTO 0);
   SIGNAL rx_desc_xhdl4      : STD_LOGIC_VECTOR(135 DOWNTO 0);
   SIGNAL rx_be_xhdl2        : STD_LOGIC_VECTOR(7 DOWNTO 0);
   SIGNAL rx_eop_xhdl5       : STD_LOGIC;
BEGIN
   -- Drive referenced outputs
   m_rx_dv <= m_rx_dv_xhdl0;
   s_rx_dv <= s_rx_dv_xhdl6;
   m_rx_sop <= m_rx_sop_xhdl1;
   s_rx_sop <= s_rx_sop_xhdl7;
   rx_data <= rx_data_xhdl3;
   rx_desc <= rx_desc_xhdl4;
   rx_be <= rx_be_xhdl2;
   rx_eop <= rx_eop_xhdl5;
   
   --/////////////////////////////////
   -- Avalon input pipeline stage
   --/////////////////////////////////
   
   PROCESS (clk, rstn)
   BEGIN
      IF ((NOT(rstn)) = '1') THEN
         stream_data_in_del <= "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
         stream_valid_del <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         stream_data_in_del <= stream_data_in;
         stream_valid_del <= stream_valid;
      END IF;
   END PROCESS;
   
   --//////////////////////////////////
   -- Avalon output pipe stage
   --//////////////////////////////////
   
   PROCESS (clk, rstn)
   BEGIN
      IF ((NOT(rstn)) = '1') THEN
         stream_ready <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         stream_ready <= NOT(fifo_almostfull);
      END IF;
   END PROCESS;
   
   --///////////////////////////////////////
   --  sink fifo
   --//////////////////////////////////////
   
   xhdl8 <= NOT(rstn);
   xhdl9 <= fifo_rd AND NOT(fifo_empty);
   fifo_131x4 : altpcierd_stream_fifo_lkahd
      PORT MAP (
         clock         => clk,
         aclr          => xhdl8,
         data          => stream_data_in_del,
         wrreq         => stream_valid_del,
         rdreq         => xhdl9,
         q             => fifo_rddata,
         full          => open_fifo_full,
         almost_full   => fifo_almostfull,
         almost_empty  => open_almost_empty,
         empty         => fifo_empty
      );
   
   --//////////////////////////////////////////
   -- fifo read 
   -- Legacy Output
   --/////////////////////////////////////////
   
   -- xhdl 
   rx_st_data_ext(107 DOWNTO 0) <= rx_st_data;
   rx_st_data_ext(135 DOWNTO 108) <= "0000000000000000000000000000";
   
   -- reformat streaming data 
   
   xhdl10 <= NOT(fifo_empty);
   formatter : altpcierd_apprxstream_formatter
      GENERIC MAP (
         TL_SELECTION  => TL_SELECTION
      )
      PORT MAP (
         clk          => clk,
         rstn         => rstn,
         fifo_valid   => xhdl10,
         fifo_data    => fifo_rddata,
         rx_st_data   => rx_st_data,
         rx_st_valid  => rx_st_valid,
         rx_st_ready  => rx_st_ready,
         fifo_ready   => fifo_rd
      );
   
   
   decode : altpcierd_apprxstream_decode
      PORT MAP (
         clk          => clk,
         rstn         => rstn,
         rx_st_valid  => rx_st_valid,
         rx_st_data   => rx_st_data_ext,
         rx_st_ready  => rx_st_ready,
         m_busy       => m_busy,
         s_busy       => s_busy,
         m_ack        => m_ack,
         s_ack        => s_ack,
         m_rx_sop     => m_rx_sop_xhdl1,
         s_rx_sop     => s_rx_sop_xhdl7,
         m_rx_dv      => m_rx_dv_xhdl0,
         s_rx_dv      => s_rx_dv_xhdl6,
         rx_eop       => rx_eop_xhdl5,
         rx_data      => rx_data_xhdl3,
         rx_desc      => rx_desc_xhdl4,
         rx_be        => rx_be_xhdl2
      );
   
END ARCHITECTURE altpcie;
