LIBRARY ieee;                          
use IEEE.std_logic_1164.all;           
use IEEE.std_logic_arith.all;          
use IEEE.std_logic_unsigned.all;       
                                       
LIBRARY altera_mf;                     
USE altera_mf.altera_mf_components.all;
                                       
LIBRARY ieee;
   USE ieee.std_logic_1164.all;
-- /**
-- *
-- *  This Verilog HDL File is used for simulation and synthesis in the simple DMA design example.  
-- *  It provides master and slave arbitration on the transmit interface for each VC.
-- *
-- */
-------------------------------------------------------------------------------
-- Title         : PCI Express Reference Design apptxchan Entity
-- Project       : PCI Express MegaCore function
-------------------------------------------------------------------------------
-- File          : altpcierd_apptxchan.v
-- Author        : Altera Corporation
-------------------------------------------------------------------------------
-- Description :
-- This is an entity that provides master/slave arbitration on the transmit 
-- interface for each VC.
-------------------------------------------------------------------------------
-- Copyright (c) 2006 Altera Corporation. All rights reserved.  Altera products are
-- protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
-- other intellectual property laws.  
--
-- This reference design file, and your use thereof, is subject to and governed by
-- the terms and conditions of the applicable Altera Reference Design License Agreement.
-- By using this reference design file, you indicate your acceptance of such terms and
-- conditions between you and Altera Corporation.  In the event that you do not agree with
-- such terms and conditions, you may not use the reference design file. Please promptly
-- destroy any copies you have made.
--
-- This reference design file being provided on an "as-is" basis and as an accommodation 
-- and therefore all warranties, representations or guarantees of any kind 
-- (whether express, implied or statutory) including, without limitation, warranties of 
-- merchantability, non-infringement, or fitness for a particular purpose, are 
-- specifically disclaimed.  By making this reference design file available, Altera
-- expressly does not recommend, suggest or require that this reference design file be
-- used in combination with any other product not provided by Altera. 
-------------------------------------------------------------------------------
ENTITY altpcierd_appmsi_streaming_intf IS
   PORT (
      
      clk_in        : IN STD_LOGIC;		-- Clock for synchronous interface to application
      rstn          : IN STD_LOGIC;
      m_req         : IN STD_LOGIC;
      
      m_ack         : OUT STD_LOGIC;
      m_data        : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      stream_ready  : IN STD_LOGIC;
      stream_data   : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      stream_valid  : OUT STD_LOGIC
   );
END ENTITY altpcierd_appmsi_streaming_intf;
ARCHITECTURE altpcie OF altpcierd_appmsi_streaming_intf IS
   

   SIGNAL stream_ready_del : STD_LOGIC;
   SIGNAL m_req_r          : STD_LOGIC;
BEGIN
   
   --------------------------------------------------------------
   --    Input register boundary
   --------------------------------------------------------------
   
   PROCESS (rstn, clk_in)
   BEGIN
      IF (rstn = '0') THEN
         stream_ready_del <= '0';
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         stream_ready_del <= stream_ready;
      END IF;
   END PROCESS;
   
   --------------------------------------------------------------
   --    Arbitration between master and target for transmission
   --------------------------------------------------------------
   
   -- tx_state SM states
   
   PROCESS (rstn, clk_in)
   BEGIN
      IF (rstn = '0') THEN
         m_ack <= '0';
         stream_valid <= '0';
         stream_data <= "00000000";
         m_req_r <= '0';
      ELSIF (clk_in'EVENT AND clk_in = '1') THEN
         IF (stream_ready_del = '1') THEN
            m_req_r <= m_req;
         ELSE
            
            m_req_r <= m_req_r;		-- rising edge detect  
         END IF;
         stream_valid <= stream_ready_del AND m_req AND NOT(m_req_r);
         m_ack <= stream_ready_del AND m_req;
         
         stream_data <= m_data;
      END IF;
   END PROCESS;
   
END ARCHITECTURE altpcie;
