-------------------------------------------------------------------------------
-- Title         : PCI Express Component declaration of  altpcie_hip_256_pipen1b
-- Project       : PCI Express MegaCore function
-------------------------------------------------------------------------------
-- File          : altpcie_hip_256_pipen1b_component_declaration
-- Author        : Altera Corporation
-------------------------------------------------------------------------------
-- Copyright (c) 2010 Altera Corporation. All rights reserved.  Altera products are
-- protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
-- other intellectual property laws.
-------------------------------------------------------------------------------
component altpcie_hip_256_pipen1b
   generic (
      ACDS_V10                            : INTEGER := 1;
      MEM_CHECK                           : INTEGER := 0;
      USE_INTERNAL_250MHZ_PLL             : INTEGER := 1;
      pll_refclk_freq                     : STRING := "100 MHz";
      enable_slot_register                : STRING := "false";
      pcie_mode                           : STRING := "shared_mode";
      bypass_cdc                          : STRING := "false";
      enable_rx_buffer_checking           : STRING := "false";
      single_rx_detect                    : INTEGER := 0;
      use_crc_forwarding                  : STRING := "false";
      gen123_lane_rate_mode               : STRING := "gen1";
      lane_mask                           : STRING := "x4";
      disable_link_x2_support             : STRING := "false";
      hip_hard_reset                      : STRING := "disable";
      dis_paritychk                       : STRING := "enable";
      wrong_device_id                     : STRING := "disable";
      data_pack_rx                        : STRING := "disable";
      ast_width                           : STRING := "rx_tx_64";
      rx_sop_ctrl                         : STRING := "boundary_64";
      rx_ast_parity                       : STRING := "disable";
      tx_ast_parity                       : STRING := "disable";
      ltssm_1ms_timeout                   : STRING := "disable";
      ltssm_freqlocked_check              : STRING := "disable";
      deskew_comma                        : STRING := "skp_eieos_deskw";
      port_link_number                    : INTEGER := 1;
      device_number                       : INTEGER := 0;
      bypass_clk_switch                   : STRING := "TRUE";
      pipex1_debug_sel                    : STRING := "disable";
      pclk_out_sel                        : STRING := "pclk";
      vendor_id                           : INTEGER := 4466;
      device_id                           : INTEGER := 1;
      revision_id                         : INTEGER := 1;
      class_code                          : INTEGER := 16711680;
      subsystem_vendor_id                 : INTEGER := 4466;
      subsystem_device_id                 : INTEGER := 1;
      no_soft_reset                       : STRING := "false";
      maximum_current                     : INTEGER := 0;
      d1_support                          : STRING := "false";
      d2_support                          : STRING := "false";
      d0_pme                              : STRING := "false";
      d1_pme                              : STRING := "false";
      d2_pme                              : STRING := "false";
      d3_hot_pme                          : STRING := "false";
      d3_cold_pme                         : STRING := "false";
      use_aer                             : STRING := "false";
      low_priority_vc                     : STRING := "single_vc";
      disable_snoop_packet                : STRING := "false";
      max_payload_size                    : STRING := "payload_512";
      surprise_down_error_support         : STRING := "false";
      dll_active_report_support           : STRING := "false";
      extend_tag_field                    : STRING := "false";
      endpoint_l0_latency                 : INTEGER := 0;
      endpoint_l1_latency                 : INTEGER := 0;
      indicator                           : INTEGER := 7;
      slot_power_scale                    : INTEGER := 0;
      max_link_width                      : STRING := "x4";
      enable_l1_aspm                      : STRING := "false";
      l1_exit_latency_sameclock           : INTEGER := 0;
      l1_exit_latency_diffclock           : INTEGER := 0;
      hot_plug_support                    : INTEGER := 0;
      slot_power_limit                    : INTEGER := 0;
      slot_number                         : INTEGER := 0;
      diffclock_nfts_count                : INTEGER := 0;
      sameclock_nfts_count                : INTEGER := 0;
      completion_timeout                  : STRING := "abcd";
      enable_completion_timeout_disable   : STRING := "true";
      extended_tag_reset                  : STRING := "false";
      ecrc_check_capable                  : STRING := "true";
      ecrc_gen_capable                    : STRING := "true";
      no_command_completed                : STRING := "true";
      msi_multi_message_capable           : STRING := "count_4";
      msi_64bit_addressing_capable        : STRING := "true";
      msi_masking_capable                 : STRING := "false";
      msi_support                         : STRING := "true";
      interrupt_pin                       : STRING := "inta";
      enable_function_msix_support        : STRING := "true";
      msix_table_size                     : INTEGER := 0;
      msix_table_bir                      : INTEGER := 0;
      msix_table_offset                   : INTEGER := 0;
      msix_pba_bir                        : INTEGER := 0;
      msix_pba_offset                     : INTEGER := 0;
      bridge_port_vga_enable              : STRING := "false";
      bridge_port_ssid_support            : STRING := "false";
      ssvid                               : INTEGER := 0;
      ssid                                : INTEGER := 0;
      eie_before_nfts_count               : INTEGER := 4;
      gen2_diffclock_nfts_count           : INTEGER := 255;
      gen2_sameclock_nfts_count           : INTEGER := 255;
      deemphasis_enable                   : STRING := "false";
      pcie_spec_version                   : STRING := "v2";
      l0_exit_latency_sameclock           : INTEGER := 6;
      l0_exit_latency_diffclock           : INTEGER := 6;
      rx_ei_l0s                           : STRING := "disable";
      l2_async_logic                      : STRING := "enable";
      aspm_config_management              : STRING := "true";
      atomic_op_routing                   : STRING := "false";
      atomic_op_completer_32bit           : STRING := "false";
      atomic_op_completer_64bit           : STRING := "false";
      cas_completer_128bit                : STRING := "false";
      ltr_mechanism                       : STRING := "false";
      tph_completer                       : STRING := "false";
      extended_format_field               : STRING := "true";
      atomic_malformed                    : STRING := "false";
      flr_capability                      : STRING := "true";
      enable_adapter_half_rate_mode       : STRING := "false";
      vc0_clk_enable                      : STRING := "true";
      register_pipe_signals               : STRING := "false";
      bar0_io_space                       : STRING := "false";
      bar0_64bit_mem_space                : STRING := "true";
      bar0_prefetchable                   : STRING := "true";
      bar0_size_mask                      : INTEGER := 268435455;
      bar1_io_space                       : STRING := "false";
      bar1_64bit_mem_space                : STRING := "false";
      bar1_prefetchable                   : STRING := "false";
      bar1_size_mask                      : INTEGER := 0;
      bar2_io_space                       : STRING := "false";
      bar2_64bit_mem_space                : STRING := "false";
      bar2_prefetchable                   : STRING := "false";
      bar2_size_mask                      : INTEGER := 0;
      bar3_io_space                       : STRING := "false";
      bar3_64bit_mem_space                : STRING := "false";
      bar3_prefetchable                   : STRING := "false";
      bar3_size_mask                      : INTEGER := 0;
      bar4_io_space                       : STRING := "false";
      bar4_64bit_mem_space                : STRING := "false";
      bar4_prefetchable                   : STRING := "false";
      bar4_size_mask                      : INTEGER := 0;
      bar5_io_space                       : STRING := "false";
      bar5_64bit_mem_space                : STRING := "false";
      bar5_prefetchable                   : STRING := "false";
      bar5_size_mask                      : INTEGER := 0;
      expansion_base_address_register     : INTEGER := 0;
      io_window_addr_width                : STRING := "window_32_bit";
      prefetchable_mem_window_addr_width  : STRING := "prefetch_32";
      skp_os_gen3_count                   : INTEGER := 0;
      tx_cdc_almost_empty                 : INTEGER := 5;
      rx_cdc_almost_full                  : INTEGER := 12;
      tx_cdc_almost_full                  : INTEGER := 12;
      rx_l0s_count_idl                    : INTEGER := 0;
      cdc_dummy_insert_limit              : INTEGER := 11;
      ei_delay_powerdown_count            : INTEGER := 10;
      millisecond_cycle_count             : INTEGER := 0;
      skp_os_schedule_count               : INTEGER := 0;
      fc_init_timer                       : INTEGER := 1024;
      l01_entry_latency                   : INTEGER := 31;
      flow_control_update_count           : INTEGER := 30;
      flow_control_timeout_count          : INTEGER := 200;
      vc0_rx_flow_ctrl_posted_header      : INTEGER := 50;
      vc0_rx_flow_ctrl_posted_data        : INTEGER := 360;
      vc0_rx_flow_ctrl_nonposted_header   : INTEGER := 54;
      vc0_rx_flow_ctrl_nonposted_data     : INTEGER := 0;
      vc0_rx_flow_ctrl_compl_header       : INTEGER := 112;
      vc0_rx_flow_ctrl_compl_data         : INTEGER := 448;
      rx_ptr0_posted_dpram_min            : INTEGER := 0;
      rx_ptr0_posted_dpram_max            : INTEGER := 0;
      rx_ptr0_nonposted_dpram_min         : INTEGER := 0;
      rx_ptr0_nonposted_dpram_max         : INTEGER := 0;
      retry_buffer_last_active_address    : INTEGER := 2047;
      retry_buffer_memory_settings        : INTEGER := 0;
      vc0_rx_buffer_memory_settings       : INTEGER := 0;
      bist_memory_settings                : INTEGER := 0;
      credit_buffer_allocation_aux        : STRING := "balanced";
      iei_enable_settings                 : STRING := "gen2_infei_infsd_gen1_infei_sd";
      vsec_id                             : INTEGER := 4466;
      cvp_rate_sel                        : STRING := "full_rate";
      hard_reset_bypass                   : STRING := "true";
      cvp_data_compressed                 : STRING := "false";
      cvp_data_encrypted                  : STRING := "false";
      cvp_mode_reset                      : STRING := "false";
      cvp_clk_reset                       : STRING := "false";
      in_cvp_mode                         : STRING := "not_cvp_mode";
      vsec_cap                            : INTEGER := 0;
      jtag_id                             : INTEGER := 0;
      user_id                             : INTEGER := 0;
      cseb_extend_pci                     : STRING := "false";
      cseb_extend_pcie                    : STRING := "false";
      cseb_cpl_status_during_cvp          : STRING := "config_retry_status";
      cseb_route_to_avl_rx_st             : STRING := "cseb";
      cseb_config_bypass                  : STRING := "disable";
      cseb_cpl_tag_checking               : STRING := "enable";
      cseb_bar_match_checking             : STRING := "enable";
      cseb_min_error_checking             : STRING := "false";
      cseb_temp_busy_crs                  : STRING := "completer_abort";
      gen3_diffclock_nfts_count           : INTEGER := 128;
      gen3_sameclock_nfts_count           : INTEGER := 128;
      gen3_coeff_errchk                   : STRING := "enable";
      gen3_paritychk                      : STRING := "enable";
      gen3_coeff_delay_count              : INTEGER := 125;
      gen3_coeff_1                        : INTEGER := 0;
      gen3_coeff_1_sel                    : STRING := "coeff_1";
      gen3_coeff_1_preset_hint            : INTEGER := 0;
      gen3_coeff_1_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_1_nxtber_more            : STRING := "g3_coeff_1_nxtber_more";
      gen3_coeff_1_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_1_nxtber_less            : STRING := "g3_coeff_1_nxtber_less";
      gen3_coeff_1_reqber                 : INTEGER := 0;
      gen3_coeff_1_ber_meas               : INTEGER := 0;
      gen3_coeff_2                        : INTEGER := 0;
      gen3_coeff_2_sel                    : STRING := "coeff_2";
      gen3_coeff_2_preset_hint            : INTEGER := 0;
      gen3_coeff_2_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_2_nxtber_more            : STRING := "g3_coeff_2_nxtber_more";
      gen3_coeff_2_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_2_nxtber_less            : STRING := "g3_coeff_2_nxtber_less";
      gen3_coeff_2_reqber                 : INTEGER := 0;
      gen3_coeff_2_ber_meas               : INTEGER := 0;
      gen3_coeff_3                        : INTEGER := 0;
      gen3_coeff_3_sel                    : STRING := "coeff_3";
      gen3_coeff_3_preset_hint            : INTEGER := 0;
      gen3_coeff_3_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_3_nxtber_more            : STRING := "g3_coeff_3_nxtber_more";
      gen3_coeff_3_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_3_nxtber_less            : STRING := "g3_coeff_3_nxtber_less";
      gen3_coeff_3_reqber                 : INTEGER := 0;
      gen3_coeff_3_ber_meas               : INTEGER := 0;
      gen3_coeff_4                        : INTEGER := 0;
      gen3_coeff_4_sel                    : STRING := "coeff_4";
      gen3_coeff_4_preset_hint            : INTEGER := 0;
      gen3_coeff_4_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_4_nxtber_more            : STRING := "g3_coeff_4_nxtber_more";
      gen3_coeff_4_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_4_nxtber_less            : STRING := "g3_coeff_4_nxtber_less";
      gen3_coeff_4_reqber                 : INTEGER := 0;
      gen3_coeff_4_ber_meas               : INTEGER := 0;
      gen3_coeff_5                        : INTEGER := 0;
      gen3_coeff_5_sel                    : STRING := "coeff_5";
      gen3_coeff_5_preset_hint            : INTEGER := 0;
      gen3_coeff_5_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_5_nxtber_more            : STRING := "g3_coeff_5_nxtber_more";
      gen3_coeff_5_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_5_nxtber_less            : STRING := "g3_coeff_5_nxtber_less";
      gen3_coeff_5_reqber                 : INTEGER := 0;
      gen3_coeff_5_ber_meas               : INTEGER := 0;
      gen3_coeff_6                        : INTEGER := 0;
      gen3_coeff_6_sel                    : STRING := "coeff_6";
      gen3_coeff_6_preset_hint            : INTEGER := 0;
      gen3_coeff_6_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_6_nxtber_more            : STRING := "g3_coeff_6_nxtber_more";
      gen3_coeff_6_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_6_nxtber_less            : STRING := "g3_coeff_6_nxtber_less";
      gen3_coeff_6_reqber                 : INTEGER := 0;
      gen3_coeff_6_ber_meas               : INTEGER := 0;
      gen3_coeff_7                        : INTEGER := 0;
      gen3_coeff_7_sel                    : STRING := "coeff_7";
      gen3_coeff_7_preset_hint            : INTEGER := 0;
      gen3_coeff_7_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_7_nxtber_more            : STRING := "g3_coeff_7_nxtber_more";
      gen3_coeff_7_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_7_nxtber_less            : STRING := "g3_coeff_7_nxtber_less";
      gen3_coeff_7_reqber                 : INTEGER := 0;
      gen3_coeff_7_ber_meas               : INTEGER := 0;
      gen3_coeff_8                        : INTEGER := 0;
      gen3_coeff_8_sel                    : STRING := "coeff_8";
      gen3_coeff_8_preset_hint            : INTEGER := 0;
      gen3_coeff_8_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_8_nxtber_more            : STRING := "g3_coeff_8_nxtber_more";
      gen3_coeff_8_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_8_nxtber_less            : STRING := "g3_coeff_8_nxtber_less";
      gen3_coeff_8_reqber                 : INTEGER := 0;
      gen3_coeff_8_ber_meas               : INTEGER := 0;
      gen3_coeff_9                        : INTEGER := 0;
      gen3_coeff_9_sel                    : STRING := "coeff_9";
      gen3_coeff_9_preset_hint            : INTEGER := 0;
      gen3_coeff_9_nxtber_more_ptr        : INTEGER := 0;
      gen3_coeff_9_nxtber_more            : STRING := "g3_coeff_9_nxtber_more";
      gen3_coeff_9_nxtber_less_ptr        : INTEGER := 0;
      gen3_coeff_9_nxtber_less            : STRING := "g3_coeff_9_nxtber_less";
      gen3_coeff_9_reqber                 : INTEGER := 0;
      gen3_coeff_9_ber_meas               : INTEGER := 0;
      gen3_coeff_10                       : INTEGER := 0;
      gen3_coeff_10_sel                   : STRING := "coeff_10";
      gen3_coeff_10_preset_hint           : INTEGER := 0;
      gen3_coeff_10_nxtber_more_ptr       : INTEGER := 0;
      gen3_coeff_10_nxtber_more           : STRING := "g3_coeff_10_nxtber_more";
      gen3_coeff_10_nxtber_less_ptr       : INTEGER := 0;
      gen3_coeff_10_nxtber_less           : STRING := "g3_coeff_10_nxtber_less";
      gen3_coeff_10_reqber                : INTEGER := 0;
      gen3_coeff_10_ber_meas              : INTEGER := 0;
      gen3_coeff_11                       : INTEGER := 0;
      gen3_coeff_11_sel                   : STRING := "coeff_11";
      gen3_coeff_11_preset_hint           : INTEGER := 0;
      gen3_coeff_11_nxtber_more_ptr       : INTEGER := 0;
      gen3_coeff_11_nxtber_more           : STRING := "g3_coeff_11_nxtber_more";
      gen3_coeff_11_nxtber_less_ptr       : INTEGER := 0;
      gen3_coeff_11_nxtber_less           : STRING := "g3_coeff_11_nxtber_less";
      gen3_coeff_11_reqber                : INTEGER := 0;
      gen3_coeff_11_ber_meas              : INTEGER := 0;
      gen3_coeff_12                       : INTEGER := 0;
      gen3_coeff_12_sel                   : STRING := "coeff_12";
      gen3_coeff_12_preset_hint           : INTEGER := 0;
      gen3_coeff_12_nxtber_more_ptr       : INTEGER := 0;
      gen3_coeff_12_nxtber_more           : STRING := "g3_coeff_12_nxtber_more";
      gen3_coeff_12_nxtber_less_ptr       : INTEGER := 0;
      gen3_coeff_12_nxtber_less           : STRING := "g3_coeff_12_nxtber_less";
      gen3_coeff_12_reqber                : INTEGER := 0;
      gen3_coeff_12_ber_meas              : INTEGER := 0;
      gen3_coeff_13                       : INTEGER := 0;
      gen3_coeff_13_sel                   : STRING := "coeff_13";
      gen3_coeff_13_preset_hint           : INTEGER := 0;
      gen3_coeff_13_nxtber_more_ptr       : INTEGER := 0;
      gen3_coeff_13_nxtber_more           : STRING := "g3_coeff_13_nxtber_more";
      gen3_coeff_13_nxtber_less_ptr       : INTEGER := 0;
      gen3_coeff_13_nxtber_less           : STRING := "g3_coeff_13_nxtber_less";
      gen3_coeff_13_reqber                : INTEGER := 0;
      gen3_coeff_13_ber_meas              : INTEGER := 0;
      gen3_coeff_14                       : INTEGER := 0;
      gen3_coeff_14_sel                   : STRING := "coeff_14";
      gen3_coeff_14_preset_hint           : INTEGER := 0;
      gen3_coeff_14_nxtber_more_ptr       : INTEGER := 0;
      gen3_coeff_14_nxtber_more           : STRING := "g3_coeff_14_nxtber_more";
      gen3_coeff_14_nxtber_less_ptr       : INTEGER := 0;
      gen3_coeff_14_nxtber_less           : STRING := "g3_coeff_14_nxtber_less";
      gen3_coeff_14_reqber                : INTEGER := 0;
      gen3_coeff_14_ber_meas              : INTEGER := 0;
      gen3_coeff_15                       : INTEGER := 0;
      gen3_coeff_15_sel                   : STRING := "coeff_15";
      gen3_coeff_15_preset_hint           : INTEGER := 0;
      gen3_coeff_15_nxtber_more_ptr       : INTEGER := 0;
      gen3_coeff_15_nxtber_more           : STRING := "g3_coeff_15_nxtber_more";
      gen3_coeff_15_nxtber_less_ptr       : INTEGER := 0;
      gen3_coeff_15_nxtber_less           : STRING := "g3_coeff_15_nxtber_less";
      gen3_coeff_15_reqber                : INTEGER := 0;
      gen3_coeff_15_ber_meas              : INTEGER := 0;
      gen3_coeff_16                       : INTEGER := 0;
      gen3_coeff_16_sel                   : STRING := "coeff_16";
      gen3_coeff_16_preset_hint           : INTEGER := 0;
      gen3_coeff_16_nxtber_more_ptr       : INTEGER := 0;
      gen3_coeff_16_nxtber_more           : STRING := "g3_coeff_16_nxtber_more";
      gen3_coeff_16_nxtber_less_ptr       : INTEGER := 0;
      gen3_coeff_16_nxtber_less           : STRING := "g3_coeff_16_nxtber_less";
      gen3_coeff_16_reqber                : INTEGER := 0;
      gen3_coeff_16_ber_meas              : INTEGER := 0;
      gen3_preset_coeff_1                 : INTEGER := 0;
      gen3_preset_coeff_2                 : INTEGER := 0;
      gen3_preset_coeff_3                 : INTEGER := 0;
      gen3_preset_coeff_4                 : INTEGER := 0;
      gen3_preset_coeff_5                 : INTEGER := 0;
      gen3_preset_coeff_6                 : INTEGER := 0;
      gen3_preset_coeff_7                 : INTEGER := 0;
      gen3_preset_coeff_8                 : INTEGER := 0;
      gen3_preset_coeff_9                 : INTEGER := 0;
      gen3_preset_coeff_10                : INTEGER := 0;
      gen3_rxfreqlock_counter             : INTEGER := 0
   );
   PORT (
      simu_mode                           : IN STD_LOGIC;
      pipe_mode                           : IN STD_LOGIC;
      crst                                : IN STD_LOGIC;
      srst                                : IN STD_LOGIC;
      hiphardreset                        : IN STD_LOGIC;
      npor                                : IN STD_LOGIC;
      reset_status                        : OUT STD_LOGIC;
      pld_clk                             : IN STD_LOGIC;
      pclk_in                             : IN STD_LOGIC;
      clk250_out                          : OUT STD_LOGIC;
      clk500_out                          : OUT STD_LOGIC;
      rc_pll_locked                       : OUT STD_LOGIC;
      cal_blk_clk                         : IN STD_LOGIC;
      refclk                              : IN STD_LOGIC;
      mode                                : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      hpg_ctrler                          : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      swctmod                             : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      swdn_in                             : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      swup_in                             : IN STD_LOGIC_VECTOR(6 DOWNTO 0);
      test_in                             : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      phystatus0_ext                      : IN STD_LOGIC;
      phystatus1_ext                      : IN STD_LOGIC;
      phystatus2_ext                      : IN STD_LOGIC;
      phystatus3_ext                      : IN STD_LOGIC;
      phystatus4_ext                      : IN STD_LOGIC;
      phystatus5_ext                      : IN STD_LOGIC;
      phystatus6_ext                      : IN STD_LOGIC;
      phystatus7_ext                      : IN STD_LOGIC;
      rxdata0_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdata1_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdata2_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdata3_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdata4_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdata5_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdata6_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdata7_ext                         : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      rxdatak0_ext                        : IN STD_LOGIC;
      rxdatak1_ext                        : IN STD_LOGIC;
      rxdatak2_ext                        : IN STD_LOGIC;
      rxdatak3_ext                        : IN STD_LOGIC;
      rxdatak4_ext                        : IN STD_LOGIC;
      rxdatak5_ext                        : IN STD_LOGIC;
      rxdatak6_ext                        : IN STD_LOGIC;
      rxdatak7_ext                        : IN STD_LOGIC;
      rxelecidle0_ext                     : IN STD_LOGIC;
      rxelecidle1_ext                     : IN STD_LOGIC;
      rxelecidle2_ext                     : IN STD_LOGIC;
      rxelecidle3_ext                     : IN STD_LOGIC;
      rxelecidle4_ext                     : IN STD_LOGIC;
      rxelecidle5_ext                     : IN STD_LOGIC;
      rxelecidle6_ext                     : IN STD_LOGIC;
      rxelecidle7_ext                     : IN STD_LOGIC;
      rxfreqlocked0_ext                   : IN STD_LOGIC;
      rxfreqlocked1_ext                   : IN STD_LOGIC;
      rxfreqlocked2_ext                   : IN STD_LOGIC;
      rxfreqlocked3_ext                   : IN STD_LOGIC;
      rxfreqlocked4_ext                   : IN STD_LOGIC;
      rxfreqlocked5_ext                   : IN STD_LOGIC;
      rxfreqlocked6_ext                   : IN STD_LOGIC;
      rxfreqlocked7_ext                   : IN STD_LOGIC;
      rxstatus0_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxstatus1_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxstatus2_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxstatus3_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxstatus4_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxstatus5_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxstatus6_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxstatus7_ext                       : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      rxdataskip0_ext                     : IN STD_LOGIC;
      rxdataskip1_ext                     : IN STD_LOGIC;
      rxdataskip2_ext                     : IN STD_LOGIC;
      rxdataskip3_ext                     : IN STD_LOGIC;
      rxdataskip4_ext                     : IN STD_LOGIC;
      rxdataskip5_ext                     : IN STD_LOGIC;
      rxdataskip6_ext                     : IN STD_LOGIC;
      rxdataskip7_ext                     : IN STD_LOGIC;
      rxblkst0_ext                        : IN STD_LOGIC;
      rxblkst1_ext                        : IN STD_LOGIC;
      rxblkst2_ext                        : IN STD_LOGIC;
      rxblkst3_ext                        : IN STD_LOGIC;
      rxblkst4_ext                        : IN STD_LOGIC;
      rxblkst5_ext                        : IN STD_LOGIC;
      rxblkst6_ext                        : IN STD_LOGIC;
      rxblkst7_ext                        : IN STD_LOGIC;
      rxsynchd0_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxsynchd1_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxsynchd2_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxsynchd3_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxsynchd4_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxsynchd5_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxsynchd6_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxsynchd7_ext                       : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxvalid0_ext                        : IN STD_LOGIC;
      rxvalid1_ext                        : IN STD_LOGIC;
      rxvalid2_ext                        : IN STD_LOGIC;
      rxvalid3_ext                        : IN STD_LOGIC;
      rxvalid4_ext                        : IN STD_LOGIC;
      rxvalid5_ext                        : IN STD_LOGIC;
      rxvalid6_ext                        : IN STD_LOGIC;
      rxvalid7_ext                        : IN STD_LOGIC;
      aer_msi_num                         : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      app_int_sts                         : IN STD_LOGIC;
      app_msi_num                         : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      app_msi_req                         : IN STD_LOGIC;
      app_msi_tc                          : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      pex_msi_num                         : IN STD_LOGIC_VECTOR(4 DOWNTO 0);
      lmi_addr                            : IN STD_LOGIC_VECTOR(11 DOWNTO 0);
      lmi_din                             : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      lmi_rden                            : IN STD_LOGIC;
      lmi_wren                            : IN STD_LOGIC;
      pm_auxpwr                           : IN STD_LOGIC;
      pm_data                             : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
      pme_to_cr                           : IN STD_LOGIC;
      pm_event                            : IN STD_LOGIC;
      rx_st_mask                          : IN STD_LOGIC;
      rx_st_ready                         : IN STD_LOGIC;
      tx_st_data                          : IN STD_LOGIC_VECTOR(255 DOWNTO 0);
      tx_st_empty                         : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
      tx_st_eop                           : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      tx_st_err                           : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      tx_st_parity                        : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      tx_st_sop                           : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      tx_st_valid                         : IN STD_LOGIC;
      cfglink2csrpld                      : IN STD_LOGIC_VECTOR(12 DOWNTO 0);
      cpl_err                             : IN STD_LOGIC_VECTOR(6 DOWNTO 0);
      cpl_pending                         : IN STD_LOGIC;
      tl_slotclk_cfg                      : IN STD_LOGIC;
      entest                              : IN STD_LOGIC;
      frzlogic                            : IN STD_LOGIC;
      frzreg                              : IN STD_LOGIC;
      idrcv                               : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      idrpl                               : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
      bistenrcv                           : IN STD_LOGIC;
      bistenrpl                           : IN STD_LOGIC;
      bistscanen                          : IN STD_LOGIC;
      bistscanin                          : IN STD_LOGIC;
      bisttesten                          : IN STD_LOGIC;
      memhiptestenable                    : IN STD_LOGIC;
      memredenscan                        : IN STD_LOGIC;
      memredscen                          : IN STD_LOGIC;
      memredscin                          : IN STD_LOGIC;
      memredsclk                          : IN STD_LOGIC;
      memredscrst                         : IN STD_LOGIC;
      memredscsel                         : IN STD_LOGIC;
      memregscanen                        : IN STD_LOGIC;
      memregscanin                        : IN STD_LOGIC;
      scanmoden                           : IN STD_LOGIC;
      usermode                            : IN STD_LOGIC;
      scanshiftn                          : IN STD_LOGIC;
      nfrzdrv                             : IN STD_LOGIC;
      plniotri                            : IN STD_LOGIC;
      csebrddata                          : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
      csebrddataparity                    : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
      csebrdresponse                      : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      csebwaitrequest                     : IN STD_LOGIC;
      csebwrresponse                      : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
      csebwrrespvalid                     : IN STD_LOGIC;
      dbgpipex1rx                         : IN STD_LOGIC_VECTOR(43 DOWNTO 0);
      eidleinfersel0_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel1_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel2_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel3_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel4_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel5_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel6_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      eidleinfersel7_ext                  : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      powerdown0_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      powerdown1_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      powerdown2_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      powerdown3_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      powerdown4_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      powerdown5_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      powerdown6_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      powerdown7_ext                      : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      rxpolarity0_ext                     : OUT STD_LOGIC;
      rxpolarity1_ext                     : OUT STD_LOGIC;
      rxpolarity2_ext                     : OUT STD_LOGIC;
      rxpolarity3_ext                     : OUT STD_LOGIC;
      rxpolarity4_ext                     : OUT STD_LOGIC;
      rxpolarity5_ext                     : OUT STD_LOGIC;
      rxpolarity6_ext                     : OUT STD_LOGIC;
      rxpolarity7_ext                     : OUT STD_LOGIC;
      txcompl0_ext                        : OUT STD_LOGIC;
      txcompl1_ext                        : OUT STD_LOGIC;
      txcompl2_ext                        : OUT STD_LOGIC;
      txcompl3_ext                        : OUT STD_LOGIC;
      txcompl4_ext                        : OUT STD_LOGIC;
      txcompl5_ext                        : OUT STD_LOGIC;
      txcompl6_ext                        : OUT STD_LOGIC;
      txcompl7_ext                        : OUT STD_LOGIC;
      txdata0_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdata1_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdata2_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdata3_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdata4_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdata5_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdata6_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdata7_ext                         : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      txdatak0_ext                        : OUT STD_LOGIC;
      txdatak1_ext                        : OUT STD_LOGIC;
      txdatak2_ext                        : OUT STD_LOGIC;
      txdatak3_ext                        : OUT STD_LOGIC;
      txdatak4_ext                        : OUT STD_LOGIC;
      txdatak5_ext                        : OUT STD_LOGIC;
      txdatak6_ext                        : OUT STD_LOGIC;
      txdatak7_ext                        : OUT STD_LOGIC;
      txdatavalid0_ext                    : OUT STD_LOGIC;
      txdatavalid1_ext                    : OUT STD_LOGIC;
      txdatavalid2_ext                    : OUT STD_LOGIC;
      txdatavalid3_ext                    : OUT STD_LOGIC;
      txdatavalid4_ext                    : OUT STD_LOGIC;
      txdatavalid5_ext                    : OUT STD_LOGIC;
      txdatavalid6_ext                    : OUT STD_LOGIC;
      txdatavalid7_ext                    : OUT STD_LOGIC;
      txdetectrx0_ext                     : OUT STD_LOGIC;
      txdetectrx1_ext                     : OUT STD_LOGIC;
      txdetectrx2_ext                     : OUT STD_LOGIC;
      txdetectrx3_ext                     : OUT STD_LOGIC;
      txdetectrx4_ext                     : OUT STD_LOGIC;
      txdetectrx5_ext                     : OUT STD_LOGIC;
      txdetectrx6_ext                     : OUT STD_LOGIC;
      txdetectrx7_ext                     : OUT STD_LOGIC;
      txelecidle0_ext                     : OUT STD_LOGIC;
      txelecidle1_ext                     : OUT STD_LOGIC;
      txelecidle2_ext                     : OUT STD_LOGIC;
      txelecidle3_ext                     : OUT STD_LOGIC;
      txelecidle4_ext                     : OUT STD_LOGIC;
      txelecidle5_ext                     : OUT STD_LOGIC;
      txelecidle6_ext                     : OUT STD_LOGIC;
      txelecidle7_ext                     : OUT STD_LOGIC;
      txmargin0_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txmargin1_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txmargin2_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txmargin3_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txmargin4_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txmargin5_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txmargin6_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txmargin7_ext                       : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      txdeemph0_ext                       : OUT STD_LOGIC;
      txdeemph1_ext                       : OUT STD_LOGIC;
      txdeemph2_ext                       : OUT STD_LOGIC;
      txdeemph3_ext                       : OUT STD_LOGIC;
      txdeemph4_ext                       : OUT STD_LOGIC;
      txdeemph5_ext                       : OUT STD_LOGIC;
      txdeemph6_ext                       : OUT STD_LOGIC;
      txdeemph7_ext                       : OUT STD_LOGIC;
      txblkst0_ext                        : OUT STD_LOGIC;
      txblkst1_ext                        : OUT STD_LOGIC;
      txblkst2_ext                        : OUT STD_LOGIC;
      txblkst3_ext                        : OUT STD_LOGIC;
      txblkst4_ext                        : OUT STD_LOGIC;
      txblkst5_ext                        : OUT STD_LOGIC;
      txblkst6_ext                        : OUT STD_LOGIC;
      txblkst7_ext                        : OUT STD_LOGIC;
      txsynchd0_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      txsynchd1_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      txsynchd2_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      txsynchd3_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      txsynchd4_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      txsynchd5_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      txsynchd6_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      txsynchd7_ext                       : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      currentcoeff0_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentcoeff1_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentcoeff2_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentcoeff3_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentcoeff4_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentcoeff5_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentcoeff6_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentcoeff7_ext                   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0);
      currentrxpreset0_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      currentrxpreset1_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      currentrxpreset2_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      currentrxpreset3_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      currentrxpreset4_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      currentrxpreset5_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      currentrxpreset6_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      currentrxpreset7_ext                : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      coreclkout                          : OUT STD_LOGIC;
      currentspeed                        : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      derr_cor_ext_rcv                    : OUT STD_LOGIC;
      derr_cor_ext_rcv1                   : OUT STD_LOGIC;
      derr_cor_ext_rpl                    : OUT STD_LOGIC;
      derr_rpl                            : OUT STD_LOGIC;
      dlup                                : OUT STD_LOGIC;
      dlup_exit                           : OUT STD_LOGIC;
      resetstatus                         : OUT STD_LOGIC;
      ratetiedtognd                       : OUT STD_LOGIC;
      ev128ns                             : OUT STD_LOGIC;
      ev1us                               : OUT STD_LOGIC;
      hotrst_exit                         : OUT STD_LOGIC;
      int_status                          : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      l2_exit                             : OUT STD_LOGIC;
      lane_act                            : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      ltssmstate                          : OUT STD_LOGIC_VECTOR(4 DOWNTO 0);
      rate                                : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      test_out                            : OUT STD_LOGIC_VECTOR(127 DOWNTO 0);
      app_int_ack                         : OUT STD_LOGIC;
      app_msi_ack                         : OUT STD_LOGIC;
      lmi_ack                             : OUT STD_LOGIC;
      lmi_dout                            : OUT STD_LOGIC_VECTOR(31 DOWNTO 0);
      pme_to_sr                           : OUT STD_LOGIC;
      rx_st_bardec1                       : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      rx_st_bardec2                       : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      rx_st_be                            : OUT STD_LOGIC_VECTOR(31 DOWNTO 0);
      rx_st_data                          : OUT STD_LOGIC_VECTOR(255 DOWNTO 0);
      rx_st_empty                         : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
      rx_st_eop                           : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      rx_st_err                           : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      rx_st_parity                        : OUT STD_LOGIC_VECTOR(31 DOWNTO 0);
      rx_st_sop                           : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      rx_st_valid                         : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      serr_out                            : OUT STD_LOGIC;
      swdnout                             : OUT STD_LOGIC_VECTOR(6 DOWNTO 0);
      swupout                             : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
      tl_cfg_add                          : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      tl_cfg_ctl                          : OUT STD_LOGIC_VECTOR(31 DOWNTO 0);
      tl_cfg_sts                          : OUT STD_LOGIC_VECTOR(52 DOWNTO 0);
      tx_cred_datafccp                    : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
      tx_cred_datafcnp                    : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
      tx_cred_datafcp                     : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
      tx_cred_fchipcons                   : OUT STD_LOGIC_VECTOR(5 DOWNTO 0);
      tx_cred_fcinfinite                  : OUT STD_LOGIC_VECTOR(5 DOWNTO 0);
      tx_cred_hdrfccp                     : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      tx_cred_hdrfcnp                     : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      tx_cred_hdrfcp                      : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
      tx_st_ready                         : OUT STD_LOGIC;
      rx_in0                              : IN STD_LOGIC;
      rx_in1                              : IN STD_LOGIC;
      rx_in2                              : IN STD_LOGIC;
      rx_in3                              : IN STD_LOGIC;
      rx_in4                              : IN STD_LOGIC;
      rx_in5                              : IN STD_LOGIC;
      rx_in6                              : IN STD_LOGIC;
      rx_in7                              : IN STD_LOGIC;
      tx_out0                             : OUT STD_LOGIC;
      tx_out1                             : OUT STD_LOGIC;
      tx_out2                             : OUT STD_LOGIC;
      tx_out3                             : OUT STD_LOGIC;
      tx_out4                             : OUT STD_LOGIC;
      tx_out5                             : OUT STD_LOGIC;
      tx_out6                             : OUT STD_LOGIC;
      tx_out7                             : OUT STD_LOGIC;
      csebaddr                            : OUT STD_LOGIC_VECTOR(32 DOWNTO 0);
      csebaddrparity                      : OUT STD_LOGIC_VECTOR(4 DOWNTO 0);
      csebbe                              : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      csebisshadow                        : OUT STD_LOGIC;
      csebrden                            : OUT STD_LOGIC;
      csebwrdata                          : OUT STD_LOGIC_VECTOR(31 DOWNTO 0);
      csebwrdataparity                    : OUT STD_LOGIC_VECTOR(3 DOWNTO 0);
      csebwren                            : OUT STD_LOGIC;
      csebwrrespreq                       : OUT STD_LOGIC;
      bistdonearcv                        : OUT STD_LOGIC;
      bistdonearcv1                       : OUT STD_LOGIC;
      bistdonearpl                        : OUT STD_LOGIC;
      bistdonebrcv                        : OUT STD_LOGIC;
      bistdonebrcv1                       : OUT STD_LOGIC;
      bistdonebrpl                        : OUT STD_LOGIC;
      bistpassrcv                         : OUT STD_LOGIC;
      bistpassrcv1                        : OUT STD_LOGIC;
      bistpassrpl                         : OUT STD_LOGIC;
      bistscanoutrcv                      : OUT STD_LOGIC;
      bistscanoutrcv1                     : OUT STD_LOGIC;
      bistscanoutrpl                      : OUT STD_LOGIC;
      memredscout                         : OUT STD_LOGIC;
      memregscanout                       : OUT STD_LOGIC;
      wakeoen                             : OUT STD_LOGIC
   );
end component;
