// /**
// *
// *  This Verilog HDL File is used for simulation and synthesis in the simple DMA design example.  
// *  It provides the wrapper for simple DMA example design.
// *
// */
// synthesis verilog_input_version verilog_2001
`timescale 1 ps / 1 ps 
//-----------------------------------------------------------------------------
// Title         : PCI Express Reference Design Example Application 
// Project       : PCI Express MegaCore function
//-----------------------------------------------------------------------------
// File          : altpcierd_example_app.v
// Author        : Altera Corporation
//-----------------------------------------------------------------------------
// Description :
// This is the complete example application for the PCI Express Reference
// Design. This has all of the application logic for the example.
//-----------------------------------------------------------------------------
// Copyright (c) 2005-2006 Altera Corporation. All rights reserved.  Altera products are
// protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
// other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed by
// the terms and conditions of the applicable Altera Reference Design License Agreement.
// By using this reference design file, you indicate your acceptance of such terms and
// conditions between you and Altera Corporation.  In the event that you do not agree with
// such terms and conditions, you may not use the reference design file. Please promptly
// destroy any copies you have made.
//
// This reference design file being provided on an "as-is" basis and as an accommodation 
// and therefore all warranties, representations or guarantees of any kind 
// (whether express, implied or statutory) including, without limitation, warranties of 
// merchantability, non-infringement, or fitness for a particular purpose, are 
// specifically disclaimed.  By making this reference design file available, Altera
// expressly does not recommend, suggest or require that this reference design file be
// used in combination with any other product not provided by Altera.
//                                                           
//-----------------------------------------------------------------------------
module altpcierd_example_app  #(
                                 parameter TL_SELECTION = 6    // streaming interface format selection.
                                                               // 0 = ICM format.  6 = 7.2 format.
)(clk_in, rstn, test_sim, ko_cpl_spc_vc0, 
cfg_busdev, cfg_devcsr, cfg_tcvcmap, cfg_linkcsr, 
cpl_err, cpl_pending, pm_data, app_int_sts,  
aer_msi_num, pex_msi_num,  
rx_stream_mask0,   tx_stream_mask0,
tx_stream_ready0, tx_stream_data0, tx_stream_valid0,
rx_stream_ready0, rx_stream_valid0, rx_stream_data0,
msi_stream_ready0, msi_stream_valid0, msi_stream_data0,
app_msi_req, app_msi_ack, app_msi_tc, app_msi_num);

   input         clk_in; // Clock for synchronous interface to application
   input         rstn; 
   input         test_sim; // Speedup counters in simulation
   input[19:0]   ko_cpl_spc_vc0; 
   input[12:0]   cfg_busdev; 
   input[31:0]   cfg_devcsr; 
   input[23:0]   cfg_tcvcmap; 
   input[31:0]   cfg_linkcsr;  
   output[6:0]   cpl_err; 
   wire[6:0]     cpl_err;
   output[9:0]   pm_data; 
   wire[9:0]     pm_data;
   output        app_int_sts; 
   wire          app_int_sts; 
   output[4:0]   aer_msi_num; 
   wire[4:0]     aer_msi_num;
   output[4:0]   pex_msi_num; 
   wire[4:0]     pex_msi_num; 
   output        rx_stream_mask0; 
   wire          rx_stream_mask0;
   input        tx_stream_mask0; 
   output        cpl_pending;

   // streaming interface
   input         tx_stream_ready0;
   output[74:0]  tx_stream_data0;
   output        tx_stream_valid0;
   input[81:0]   rx_stream_data0;
   input         rx_stream_valid0;
   output        rx_stream_ready0;
   input         msi_stream_ready0;
   output[7:0]   msi_stream_data0;
   output        msi_stream_valid0;
   reg[7:0]      msi_stream_data0;
   reg           msi_stream_valid0;

   output        app_msi_req;
   input         app_msi_ack;
   output[2:0]   app_msi_tc;
   output[4:0]   app_msi_num;


   wire cpl_pending;
   reg app_msi_req;
   wire[2:0] app_msi_tc;   
   wire[4:0] app_msi_num;
   wire m_req; 
   wire m_ack; 
   wire[63:0] m_addr; 
   wire[31:0] m_size; 
   wire[31:0] m_ctrl; 
   wire[12:0] m_tgt_adr; 
   wire s_rx_busy; 
   wire s_tx_busy; 
   wire s_vc0_out; 
   wire open_s_vc1_out; 
   wire m_rx_busy; 
   wire open_m_tx_busy; 
   wire m_vc0_out; 
   wire open_m_vc1_out;   
   wire s_rx_ack;       
   wire s_tx_req; 
   wire s_tx_ack; 
   wire[127:0] s_tx_desc;  
   wire s_tx_err; 
   wire open_s_tx_dv;  
   wire[63:0] s_tx_data;   
   wire m_rx_ack;       
   wire m_tx_req; 
   wire m_tx_ack;  
   wire[127:0] m_tx_desc; 
   wire m_tx_err; 
   wire open_m_tx_dv;  
   wire[63:0] m_tx_data;    
   wire pm_event_pb; 
   wire m_pending;   
   wire app_int_sts_buf; 
   reg app_int_sts_r;    

   wire[19:0]   ko_cpl_spc_vc1; 

      
   wire s_last_datacyc;     // from slave.   this cycle is last data cycle of tx transfer.
   wire m_last_datacyc;     // from master.  this cycle is last data cycle of tx transfer.
      
    // master-slave interface 
    // pipeline stages for
    // performance.
    
    reg[63:0] m_addr_del; 
    reg[31:0] m_size_del; 
    reg[31:0] m_ctrl_del; 
    reg[12:0] m_tgt_adr_del; 
    reg       m_pending_del; 
    reg       m_ack_del;
    reg       m_req_del; 
    reg[63:0] m_addr_del2; 
    reg[31:0] m_size_del2; 
    reg[31:0] m_ctrl_del2; 
    reg[12:0] m_tgt_adr_del2; 
    reg       m_pending_del2; 
    reg       m_ack_del2;
    reg       m_req_del2;   
    
    reg       s_tx_req_del;
    reg       m_tx_req_del;  

   wire        m_rx_sop; 
   wire        s_rx_sop; 
   wire[63:0]  rx_data;
   wire[135:0] rx_desc;
   wire[7:0]   rx_be;
   wire        m_rx_dv;
   wire        s_rx_dv;
   wire        rx_eop;
   wire        app_msi_st_ack;

   wire[7:0]   msi_stream_data0_n;
   wire        msi_stream_valid0_n;
   
   wire        open_pm_event;
   wire        open_s_rx_ws;
   wire        open_s_tx_dfr;
   wire        open_s_nextcyc_is_last;
   wire        open_m_nextcyc_is_last;
   wire        open_m_rx_ws;
   wire        open_m_tx_dfr;
   wire        s_data_ack;
   wire        m_data_ack;
   reg[12:0] cfg_busdev_del; 
   reg[31:0] cfg_devcsr_del; 
   reg[23:0] cfg_tcvcmap_del; 
   reg[31:0] cfg_linkcsr_del; 

   assign rx_stream_mask0 = 1'b0; 
    assign ko_cpl_spc_vc1 = 0;
   // structural
   assign pm_event_pb = 1'b1 ;
   assign pm_data = 10'b0000000000 ; 
   
   // pipeline stage for master-slave interface.
   // DMA control and status signals.  for performance.
   
   always @(negedge rstn or posedge clk_in) begin
      if (rstn == 1'b0) begin
         m_addr_del     <= 64'h0; 
         m_size_del     <= 32'h0; 
         m_ctrl_del     <= 32'h0;
         m_tgt_adr_del  <= 13'h0;
         m_pending_del  <= 1'h0;
         m_ack_del      <= 1'b0;
         m_req_del      <= 1'b0;
         m_addr_del2    <= 64'h0; 
         m_size_del2    <= 32'h0; 
         m_ctrl_del2    <= 32'h0;
         m_tgt_adr_del2 <= 13'h0;
         m_pending_del2 <= 1'h0;
         m_ack_del2     <= 1'b0;
         m_req_del2     <= 1'b0;  
      end
      else begin 
         m_addr_del     <= m_addr_del2; 
         m_size_del     <= m_size_del2; 
         m_ctrl_del     <= m_ctrl_del2;
         m_tgt_adr_del  <= m_tgt_adr_del2;
         m_pending_del  <= m_pending_del2;
         m_ack_del      <= m_ack_del2;
         m_req_del      <= m_req_del2;  
         m_addr_del2    <= m_addr; 
         m_size_del2    <= m_size; 
         m_ctrl_del2    <= m_ctrl;
         m_tgt_adr_del2 <= m_tgt_adr;
         m_pending_del2 <= m_pending;
         m_ack_del2     <= m_ack;
         m_req_del2     <= m_req;  
      end 
   end 
  
   assign cpl_err[6:3] = 4'h0;
   
   altpcierd_slave #(11) slave(
      .hclk(clk_in), 
      .hrstn(rstn), 
      .cfg_busdev(cfg_busdev_del), 
      .cfg_maxpload(cfg_devcsr_del[7:5]), 
      .cfg_tcvcmap(cfg_tcvcmap_del), 
      .m_req(m_req), 
      .m_size(m_size), 
      .m_addr(m_addr), 
      .m_ctrl(m_ctrl), 
      .m_tgt_adr(m_tgt_adr), 
      .m_ack(m_ack_del),              
      .tx_intreq(app_int_sts_buf), 
      .pm_event(open_pm_event), 
      .err_cplabort(cpl_err[1]), 
      .pm_event_pb(pm_event_pb), 
      .m_pending(m_pending_del),      
      .rx_busy(s_rx_busy), 
      .tx_busy(s_tx_busy), 
      .vc0_out(s_vc0_out), 
      .vc1_out(open_s_vc1_out), 
      .rx_req(s_rx_sop), 
      .rx_ack(s_rx_ack), 
      .rx_desc(rx_desc), 
      .rx_ws(open_s_rx_ws), 
      .rx_data(rx_data), 
      .rx_be(rx_be),  
       .rx_dv( s_rx_dv),          
      .rx_dfr(~rx_eop),    
       .rx_st_eop(rx_eop),
      .tx_req(s_tx_req), 
      .tx_desc(s_tx_desc), 
      .tx_ack(s_tx_ack), 
      .tx_dfr(open_s_tx_dfr), 
      .tx_data(s_tx_data), 
      .tx_dv(open_s_tx_dv), 
      .tx_err(s_tx_err),   
      .fetch_tx_data(1'b0),   
      .nextcyc_is_last(open_s_nextcyc_is_last ),  
      .last_datacyc(s_last_datacyc), 
      .tx_ws(~s_data_ack),
      .app_msi_num(app_msi_num),
      .app_msi_tc(app_msi_tc)
   ); 

   altpcierd_master #(11 ) master(
      .hclk(clk_in), 
      .hrstn(rstn), 
      .testtim(test_sim), 
      .ko_cpl_spc_vc0(ko_cpl_spc_vc0), 
      .ko_cpl_spc_vc1(ko_cpl_spc_vc1), 
      .cfg_busdev(cfg_busdev_del), 
      .cfg_maxpload(cfg_devcsr_del[7:5]), 
      .cfg_maxrdreq(cfg_devcsr_del[14:12]), 
      .cfg_rcb(cfg_linkcsr_del[3]), 
      .cfg_tcvcmap(cfg_tcvcmap_del), 
      .trans_pending(cpl_pending), 
      .err_cpltim(cpl_err[0]), 
      .err_cplunexp(cpl_err[2]), 
      .m_req(m_req_del),              
      .m_size(m_size_del),            
      .m_addr(m_addr_del),           
      .m_ctrl(m_ctrl_del),            
      .m_tgt_adr(m_tgt_adr_del),      
      .m_ack(m_ack), 
      .m_pending(m_pending), 
      .rx_busy(m_rx_busy), 
      .tx_busy(open_m_tx_busy), 
      .vc0_out(m_vc0_out), 
      .vc1_out(open_m_vc1_out), 
      .rx_req(m_rx_sop), 
      .rx_ack(m_rx_ack), 
      .rx_desc(rx_desc), 
      .rx_ws(open_m_rx_ws), 
      .rx_data(rx_data), 
      .rx_be(rx_be),  
      .rx_dv(m_rx_dv),    
      .rx_dfr(~rx_eop),  
      .rx_st_eop(rx_eop),
      .tx_req(m_tx_req), 
      .tx_desc(m_tx_desc), 
      .tx_ack(m_tx_ack), 
      .tx_dfr(open_m_tx_dfr), 
      .tx_data(m_tx_data), 
      .tx_dv(open_m_tx_dv), 
      .tx_err(m_tx_err), 
      .tx_ws(~m_data_ack),    
      .fetch_tx_data(1'b0),    
      .nextcyc_is_last(open_m_nextcyc_is_last ),   
      .last_datacyc(m_last_datacyc)
   ); 

   //------------------------------------------------------------
   //    TX Streaming Interface
   //       - generates streaming interface signals 
   //       - arbitrates between master and slave requests
   //------------------------------------------------------------
 
   // rx_req is generated one clk cycle ahead of 
   // other control signals.  
   // re-align here.
   wire [107:0] tx_stream_data0_ext;
   always @ (posedge clk_in or negedge rstn) begin
     if (~rstn) begin
         s_tx_req_del <= 1'b0;
         m_tx_req_del <= 1'b0;
     end
     else begin
         if (s_tx_ack)
             s_tx_req_del <= 1'b0;
         else 
             s_tx_req_del <= (s_tx_req & s_vc0_out);
             
         if (m_tx_ack)
             m_tx_req_del <= 1'b0;
         else 
             m_tx_req_del <= (m_tx_req & m_vc0_out);
     end
   end


   assign tx_stream_data0[74:0] = tx_stream_data0_ext[74:0];
   
   altpcierd_apptx_streaming_intf  #(
            .TL_SELECTION (TL_SELECTION)
            )altpcierd_apptx_streaming_intf_vc0 (
            .clk_in(clk_in), .rstn(rstn),  
            .m_req(m_tx_req_del), .m_ack(m_tx_ack), .m_data_ack(m_data_ack),
            .m_tx_data(m_tx_data), .m_tx_desc(m_tx_desc),   .m_last_datacyc(m_last_datacyc),   
            .s_req(s_tx_req_del), .s_ack(s_tx_ack), .s_data_ack(s_data_ack),
            .s_tx_data(s_tx_data), .s_tx_desc(s_tx_desc),   .s_last_datacyc(s_last_datacyc),   
            .stream_ready(tx_stream_ready0), .stream_wrdata(tx_stream_data0_ext), .stream_wr(tx_stream_valid0),
            .cpl_pending(1'b0), .m_tx_err(m_tx_err), .s_tx_err(s_tx_err)
    ); 

   //------------------------------------------------------------
   //    MSI Streaming Interface
   //       - generates streaming interface signals
   //       - Used for 7.1 mode only 
   //------------------------------------------------------------
   
   altpcierd_appmsi_streaming_intf altpcierd_msi_streaming_vc0 (
            .clk_in(clk_in), .rstn(rstn),  
            .m_req(app_msi_req), .m_ack(app_msi_st_ack), .m_data({app_msi_tc, app_msi_num}), 
            .stream_ready(msi_stream_ready0), .stream_data(msi_stream_data0_n), .stream_valid(msi_stream_valid0_n)
    ); 

   always @(negedge rstn or posedge clk_in)
   begin
      if (rstn == 1'b0)
      begin
         app_int_sts_r <= 1'b0 ; 
         app_msi_req <= 1'b0 ; 
      end
      else
      begin
         app_int_sts_r <= app_int_sts_buf ; 
         if (app_int_sts_buf == 1'b1 & app_int_sts_r == 1'b0)
         begin
            app_msi_req <= 1'b1 ; 
         end  
         else if (((TL_SELECTION == 0) & (app_msi_st_ack == 1'b1)) |       // if ICM mode, deassert on app_msi_st_ack
                  ((TL_SELECTION == 6) & (app_msi_ack == 1'b1)))           // if 7.2 or beyond, deassert on app_msi_ack
         begin
            app_msi_req <= 1'b0 ; 
         end 
      end 
   end 
   
   // extra pipe stage for performance
   // Used for 7.1 mode only
   always @(negedge rstn or posedge clk_in) begin
      if (rstn == 1'b0) begin  
          msi_stream_data0  <= 8'h0;
          msi_stream_valid0 <= 1'b0;
      end
      else begin 
          msi_stream_data0  <= msi_stream_data0_n;
          msi_stream_valid0 <= msi_stream_valid0_n;
      end 
   end 
   assign aer_msi_num     = 5'b00000 ;
   assign pex_msi_num = 5'b00000 ;
   assign app_int_sts = app_int_sts_buf ; 


   //------------------------------------------------------------
   //    RX Streaming Interface
   //       - generates streaming interface signals 
   //       - routes data to master/slave
   //------------------------------------------------------------   
   
   wire [107:0] rx_stream_data0_ext;
   assign rx_stream_data0_ext[81:0] = rx_stream_data0   ;
   assign rx_stream_data0_ext[107:82] = 0   ;
   
   altpcierd_apprx_streaming_intf  #(
            .TL_SELECTION (TL_SELECTION)
            )altpcierd_apprx_streaming_intf_vc0 ( 
            .clk(clk_in), .rstn(rstn), 
            .stream_ready(rx_stream_ready0), .stream_valid(rx_stream_valid0), .stream_data_in(rx_stream_data0_ext),
            .m_busy(m_rx_busy), .s_busy(s_rx_busy | s_tx_busy), .m_ack(m_rx_ack), .s_ack(s_rx_ack),
            .m_rx_sop(m_rx_sop), .s_rx_sop(s_rx_sop), .rx_data(rx_data), .rx_desc(rx_desc), .rx_be(rx_be), .rx_eop(rx_eop),
            .m_rx_dv(m_rx_dv), .s_rx_dv(s_rx_dv)
    );
   

   //------------------------------------------------------------------ 
   // CONFIGURATION Sideband Input Signals
   // These are Incremental Compile input boundary registers.  
   // No combinational logic allowed on the inputs to these registers. 
   //-----------------------------------------------------------------
   always @(negedge rstn or posedge clk_in) begin
      if (rstn == 1'b0) begin
          cfg_busdev_del  <= 13'h0;
          cfg_devcsr_del  <= 32'h0;
          cfg_tcvcmap_del <= 24'h0;
          cfg_linkcsr_del <= 32'h0;
      end
      else begin
          cfg_busdev_del  <= cfg_busdev;
          cfg_devcsr_del  <= cfg_devcsr;
          cfg_tcvcmap_del <= cfg_tcvcmap;
          cfg_linkcsr_del <= cfg_linkcsr;
      end 
   end    
endmodule
