// synthesis verilog_input_version verilog_2001
`timescale 1 ps / 1 ps 
//-----------------------------------------------------------------------------
// Title         : PCI Express Reference Design Dual Port RAM entity
// Project       : PCI Express MegaCore function
//-----------------------------------------------------------------------------
// File          : altpcierd_dprambe.v
// Author        : Altera Corporation
//-----------------------------------------------------------------------------
// Description :
// This is an entity that instantiates a Dual Port RAM with Byte Enables for
// use in the PCI Express Reference Design
//-----------------------------------------------------------------------------
// Copyright (c) 2005 Altera Corporation. All rights reserved.  Altera products are
// protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
// other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed by
// the terms and conditions of the applicable Altera Reference Design License Agreement.
// By using this reference design file, you indicate your acceptance of such terms and
// conditions between you and Altera Corporation.  In the event that you do not agree with
// such terms and conditions, you may not use the reference design file. Please promptly
// destroy any copies you have made.
//
// This reference design file being provided on an "as-is" basis and as an accommodation 
// and therefore all warranties, representations or guarantees of any kind 
// (whether express, implied or statutory) including, without limitation, warranties of 
// merchantability, non-infringement, or fitness for a particular purpose, are 
// specifically disclaimed.  By making this reference design file available, Altera
// expressly does not recommend, suggest or require that this reference design file be
// used in combination with any other product not provided by Altera.
//-----------------------------------------------------------------------------
module altpcierd_dprambe#(
      parameter ADDR_WIDTH  = 8,
      parameter DATA_WIDTH  = 32,
      parameter BYTE_SIZE  = 8 
   ) (
      input wrclk,
      input[ADDR_WIDTH - 1:0] wraddr,
      input[DATA_WIDTH - 1:0] wrdata, 
      input[DATA_WIDTH / BYTE_SIZE - 1:0] wrbe, 
      input rdclk, 
      input rdclken,
      input[ADDR_WIDTH - 1:0] rdaddr, 
      output[DATA_WIDTH - 1:0] rddata  );

   function integer get_numwords;
      input integer width;
      begin
         get_numwords = (1<<width);
      end
  endfunction


   localparam NUMWORDS_RAM = get_numwords(ADDR_WIDTH);
   localparam WIDTHBYTEENAA= DATA_WIDTH/BYTE_SIZE;
   

   wire [DATA_WIDTH - 1:0] q_a; 
   wire wren;

   assign wren = 1'b1 ;

   wire cst_1b_zero;
   wire cst_1b_one;
   wire [127:0] cst_std_logic_vector_type_one;
   wire [63:0] cst_std_logic_vector_type_zero;

   wire [DATA_WIDTH-1:0] data_b_ram;
   assign data_b_ram[DATA_WIDTH-1:0] =cst_std_logic_vector_type_one[DATA_WIDTH-1:0];  


   assign  cst_1b_zero = 1'b0;
   assign cst_1b_one = 1'b1;
   assign cst_std_logic_vector_type_one  = 
                                   128'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
   assign cst_std_logic_vector_type_zero = 0;

   
   altsyncram #(
   
   
		.width_a                ( DATA_WIDTH),
		.widthad_a              ( ADDR_WIDTH),
		.numwords_a             ( NUMWORDS_RAM),
		.width_b                ( DATA_WIDTH),
		.widthad_b              ( ADDR_WIDTH),
		.numwords_b             ( NUMWORDS_RAM),
		.width_byteena_a        ( WIDTHBYTEENAA),
		.lpm_type               ( "altsyncram"),
      .operation_mode         ( "DUAL_PORT"),
		.outdata_reg_b          ( "CLOCK1"), 
		.indata_aclr_a          ( "NONE"),
		.wrcontrol_aclr_a       ( "NONE"),
		.address_aclr_a         ( "NONE"),
		.byteena_aclr_a         ( "NONE"),
		.address_reg_b          ( "CLOCK1"),
		.address_aclr_b         ( "NONE"),
		.outdata_aclr_b         ( "NONE"),
		.ram_block_type         ( "AUTO"),
		.intended_device_family ( "Stratix")   
      )
   
      dpram(
      .wren_a(wren), 
      .clock0(wrclk), 
      .clock1(rdclk), 
      .clocken1(rdclken), 
      .byteena_a(wrbe), 
      .address_a(wraddr), 
      .address_b(rdaddr), 
      .data_a(wrdata), 
      .q_b(rddata),
      .q_a(q_a),
      .addressstall_a(cst_1b_zero),
      .addressstall_b(cst_1b_zero),
      .byteena_b(cst_std_logic_vector_type_one[0]),
      .aclr0(cst_1b_zero),
      .aclr1(cst_1b_zero),
      .clocken0(cst_1b_one),
      .data_b(data_b_ram),
      .rden_b(cst_1b_one),
      .wren_b(cst_1b_zero)
		    );
 
endmodule
