// synthesis verilog_version verilog_2001
`timescale 1 ps / 1 ps 
//-----------------------------------------------------------------------------
// Title         : PCI Express Reference Design Example Application 
// Project       : PCI Express MegaCore function
//-----------------------------------------------------------------------------
// File          : core_wrapper_tx.v
// Author        : Altera Corporation
//-----------------------------------------------------------------------------
// Description :
// This is the complete example application for the PCI Express Reference
// Design. This has all of the application logic for the example.
//-----------------------------------------------------------------------------
// Copyright (c) 2006 Altera Corporation. All rights reserved.  Altera products are
// protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
// other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed by
// the terms and conditions of the applicable Altera Reference Design License Agreement.
// By using this reference design file, you indicate your acceptance of such terms and
// conditions between you and Altera Corporation.  In the event that you do not agree with
// such terms and conditions, you may not use the reference design file. Please promptly
// destroy any copies you have made.
//
// This reference design file being provided on an "as-is" basis and as an accommodation 
// and therefore all warranties, representations or guarantees of any kind 
// (whether express, implied or statutory) including, without limitation, warranties of 
// merchantability, non-infringement, or fitness for a particular purpose, are 
// specifically disclaimed.  By making this reference design file available, Altera
// expressly does not recommend, suggest or require that this reference design file be
// used in combination with any other product not provided by Altera. 
//-----------------------------------------------------------------------------
 
 
module altpcierd_apprx_streaming_intf #(
                                          parameter TL_SELECTION = 6    // streaming interface format selection.
                                                                        //  0 = ICM format, 6 = 7.2 format.
                                         )  ( clk, rstn, 
                                              stream_ready, stream_valid, stream_data_in,
                                              m_busy, s_busy, m_rx_dv, s_rx_dv, m_ack, s_ack,
                                              m_rx_sop, s_rx_sop, rx_data, rx_desc, rx_be, rx_eop);
 

   input         clk;  
   input         rstn;     
   input         m_busy;    
   input         s_busy; 
   input         m_ack;
   input         s_ack;

   output        m_rx_sop; 
   output        s_rx_sop; 
   output        m_rx_dv;
   output        s_rx_dv;
   output[63:0]  rx_data;
   output[135:0] rx_desc;
   output[7:0]   rx_be;  
   output        rx_eop;

   input         stream_valid; 
   input[107:0]  stream_data_in;     
   output        stream_ready;
    
 
 
   reg           stream_ready;    
   reg[107:0]    stream_data_in_del;   // input boundary reg
   reg           stream_valid_del;     // input boundary reg

   // Fifo 
   wire          open_fifo_full;
   wire          fifo_empty;
   wire          fifo_almostfull;  
   wire          fifo_rd;  
   wire[107:0]   fifo_rddata;    
 
   wire          rx_st_valid;
   wire [135:0]  rx_st_data_ext;
   wire[107:0]   rx_st_data;
   wire          rx_st_ready;
   
   wire          open_almost_empty;

   ///////////////////////////////////
   // Avalon input pipeline stage
   ///////////////////////////////////
    
   always @ (posedge clk or negedge rstn) begin
       if (~rstn) begin
           stream_data_in_del <= 108'h0;
           stream_valid_del   <= 1'b0; 
       end
       else begin
           stream_data_in_del <= stream_data_in;
           stream_valid_del   <= stream_valid; 
       end
   end
   
   ////////////////////////////////////
   // Avalon output pipe stage
   ////////////////////////////////////

   always @ (posedge clk or negedge rstn) begin
       if (~rstn) begin 
           stream_ready   <= 1'b0;
       end
       else begin 
           stream_ready   <= ~fifo_almostfull;
       end
   end
   
 
   /////////////////////////////////////////
   //  sink fifo
   ////////////////////////////////////////
   defparam fifo_131x4.RAMTYPE = "RAM_BLOCK_TYPE=M512"; 
   altpcierd_stream_fifo_lkahd fifo_131x4( 
                           .clock        (clk),
                           .aclr         (~rstn),
                           .data         (stream_data_in_del),
                           .wrreq        (stream_valid_del),
                           .rdreq        (fifo_rd & ~fifo_empty),
                           .q            (fifo_rddata),
                           .full         (open_fifo_full),
                           .almost_full  (fifo_almostfull),
                           .almost_empty (open_almost_empty ), 
                           .empty        (fifo_empty));
                            


   ////////////////////////////////////////////
   // fifo read 
   // Legacy Output
   ///////////////////////////////////////////

   // xhdl 
   assign rx_st_data_ext[107:0]   = rx_st_data; 
   assign rx_st_data_ext[135:108] = 0;
   
   // reformat streaming data 
   altpcierd_apprxstream_formatter #(
            .TL_SELECTION (TL_SELECTION)
            )   formatter (
            .clk(clk), .rstn(rstn), .fifo_valid(~fifo_empty), .fifo_data(fifo_rddata), 
            .rx_st_data(rx_st_data), .rx_st_valid(rx_st_valid),
            .rx_st_ready(rx_st_ready),  .fifo_ready(fifo_rd) 
   );

   altpcierd_apprxstream_decode   decode (
          .clk(clk), .rstn(rstn), 
          .rx_st_valid(rx_st_valid), .rx_st_data(rx_st_data_ext), .rx_st_ready(rx_st_ready), 
          .m_busy(m_busy), .s_busy(s_busy), .m_ack(m_ack), .s_ack(s_ack),
          .m_rx_sop(m_rx_sop), .s_rx_sop(s_rx_sop),  
          .m_rx_dv(m_rx_dv), .s_rx_dv(s_rx_dv),
          .rx_eop(rx_eop), .rx_data(rx_data), .rx_desc(rx_desc), .rx_be(rx_be) 
    );

endmodule
