
// /**
// *
// *  This Verilog HDL File is used for simulation and synthesis in the simple DMA design example.  
// *  It provides master and slave arbitration on the transmit interface for each VC.
// *
// */
// synthesis verilog_input_version verilog_2001
`timescale 1 ps / 1 ps 
//-----------------------------------------------------------------------------
// Title         : PCI Express Reference Design apptxchan Entity
// Project       : PCI Express MegaCore function
//-----------------------------------------------------------------------------
// File          : altpcierd_apptxchan.v
// Author        : Altera Corporation
//-----------------------------------------------------------------------------
// Description :
// This is an entity that provides master/slave arbitration on the transmit 
// interface for each VC.
//-----------------------------------------------------------------------------
// Copyright (c) 2006 Altera Corporation. All rights reserved.  Altera products are
// protected under numerous U.S. and foreign patents, maskwork rights, copyrights and
// other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed by
// the terms and conditions of the applicable Altera Reference Design License Agreement.
// By using this reference design file, you indicate your acceptance of such terms and
// conditions between you and Altera Corporation.  In the event that you do not agree with
// such terms and conditions, you may not use the reference design file. Please promptly
// destroy any copies you have made.
//
// This reference design file being provided on an "as-is" basis and as an accommodation 
// and therefore all warranties, representations or guarantees of any kind 
// (whether express, implied or statutory) including, without limitation, warranties of 
// merchantability, non-infringement, or fitness for a particular purpose, are 
// specifically disclaimed.  By making this reference design file available, Altera
// expressly does not recommend, suggest or require that this reference design file be
// used in combination with any other product not provided by Altera. 
//-----------------------------------------------------------------------------


 
module altpcierd_appmsi_streaming_intf (
                           clk_in, rstn,  
                           m_req, m_ack, m_data,
                           stream_ready, stream_data, stream_valid);  
                                                   

   input         clk_in; // Clock for synchronous interface to application
   input         rstn;  
   input         m_req; 
   input[7:0]    m_data;
   input         stream_ready;

   output        m_ack; 
   output[7:0]   stream_data; 
   output        stream_valid;
   
   reg[7:0]      stream_data; 
   reg           stream_valid;  
   reg           m_ack; 
   reg           stream_ready_del;
   reg           m_req_r;

   //------------------------------------------------------------
   //    Input register boundary
   //------------------------------------------------------------

   always @(negedge rstn or posedge clk_in) begin
      if (rstn == 1'b0) begin
          stream_ready_del <= 1'b0;
      end
      else begin
          stream_ready_del <= stream_ready;
      end
   end
   
   //------------------------------------------------------------
   //    Arbitration between master and target for transmission
   //------------------------------------------------------------
   
   // tx_state SM states

  
   always @(negedge rstn or posedge clk_in) begin
      if (rstn == 1'b0) begin
         m_ack        <= 1'b0;
         stream_valid <= 1'b0;
         stream_data  <= 8'h0;
         m_req_r      <= 1'b0;
      end
      else begin  
         if (stream_ready_del)  
             m_req_r  <= m_req; 
         else
             m_req_r  <= m_req_r;
         
         stream_valid <= stream_ready_del & m_req & ~m_req_r;  // rising edge detect  
         m_ack        <= stream_ready_del & m_req;
         stream_data  <= m_data;
         
      end
   end  
    
                     
endmodule
