/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.utilities;

import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IModuleGenerateHDL;
import com.altera.megacore.pcie.utilities.StreamGobbler;
import com.altera.sopcmodel.util.Message;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class RunQuartusCommandHelperUtils {
    private static File quartusRootdir;

    public static String createTclWorkDir(File projectDir, String dirName) throws IOException {
        File simgenDir = new File(projectDir, dirName);
        if (simgenDir.exists()) {
            RunQuartusCommandHelperUtils.delete(simgenDir);
        }
        simgenDir.mkdir();
        File tempDir = new File(simgenDir, ".tempdir");
        tempDir.mkdir();
        return simgenDir.getPath().replace('\\', '/');
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] list = file.listFiles();
                for (int i = 0; i < list.length; ++i) {
                    RunQuartusCommandHelperUtils.delete(list[i]);
                }
            }
            file.delete();
        }
    }

    public static void addProjectFile(PrintWriter tcl, String szFileName, String szDir, IModuleGenerateHDL.HDLLanguage language, IMessageLogger logger) {
        File file = new File((szDir != null ? szDir + "/" : "") + szFileName);
        String szFilePath = "";
        try {
            szFilePath = file.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException ex) {
            Message m = Message.create((EMessageID)EMessageID.ValidationRelated);
            m.setLevel(EMessageLevel.Error);
            m.setProblemDescription("Illegal file included in project (" + szFileName + ")");
            logger.receiveMessage((IMessage)m);
        }
        if (language.toString().equals(IModuleGenerateHDL.HDLLanguage.VHDL.toString())) {
            tcl.println("set_global_assignment -name VHDL_FILE \"" + szFilePath + "\"");
        } else if (language.toString().equals(IModuleGenerateHDL.HDLLanguage.VERILOG.toString())) {
            tcl.println("set_global_assignment -name VERILOG_FILE \"" + szFilePath + "\"");
        }
    }

    public static int runQuartusTcl(String[] szQuartusCmd, File workDir, IMessageLogger logger, boolean debug) throws Exception {
        Process myProcess = Runtime.getRuntime().exec(szQuartusCmd, null, workDir);
        StreamGobbler errorGobbler = new StreamGobbler(myProcess.getErrorStream(), "ERROR", logger, debug);
        StreamGobbler outputGobbler = new StreamGobbler(myProcess.getInputStream(), "OUTPUT", logger, debug);
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = myProcess.waitFor();
        if (debug) {
            Message m = Message.create((EMessageID)EMessageID.ValidationRelated);
            m.setLevel(EMessageLevel.Debug);
            m.setProblemDescription("ExitValue: " + exitVal);
            logger.receiveMessage((IMessage)m);
        }
        Thread.sleep(1000L);
        return exitVal;
    }

    public static File getQuartusRootdir() {
        String qDir;
        if (quartusRootdir == null && (qDir = System.getenv("QUARTUS_ROOTDIR")) != null) {
            quartusRootdir = new File(qDir);
        }
        return quartusRootdir;
    }
}

