/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import altera.ipbu.pci_express.MVCConstants;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IDeviceFamily;
import com.altera.entityinterfaces.moduleext.megawizard.EMegaWizardState;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizard;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizardEvent;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizardEventHandler;
import com.altera.megacore.pcie.AlteraPCIECompiler;
import com.altera.megacore.pcie.AlteraPCIECompilerClass;
import com.altera.megacore.pcie.html.AlteraPCIEMWHtmlViewer;
import com.altera.megacore.pcie.model.ICoreParameter;
import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;
import com.altera.megacore.pcie.serializer.ModuleGenerateHDL;
import com.altera.megacore.pcie.ui.AvalonConfiguration;
import com.altera.megacore.pcie.ui.PCIEConfiguration;
import com.altera.megacore.pcie.ui.gxb.PCIEAlt2GXBPanel;
import com.altera.megawizard2.MWGUIBaseClass;
import com.altera.megawizard2.view.MWPanel;
import com.altera.sopcmodel.ensemble.DeviceFamily;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class PCIEMegaWizardGUI
extends MWGUIBaseClass
implements IMessageLogger,
IMegaWizardEventHandler {
    private static MWPanel hiddenpanel;
    private static MWPanel avalonPanel;
    public static final int PANEL_MARGIN = 5;
    private static IModule my_module;
    private static String userPrefrence;

    public void init(IModule m_module) {
        my_module = m_module;
        this.addPanel(MVCConstants.getResourceString("SystemSettings.text", "System Settings"), PCIEConfiguration.createPCIESystemSettingsPanel());
        this.addPanel(MVCConstants.getResourceString("PCIRegisters.text", "PCI Registers "), PCIEConfiguration.createPCIRegistersPanel());
        this.addPanel(MVCConstants.getResourceString("Capabilities.text", "Capabilities"), PCIEConfiguration.createPCIECapabilities());
        this.addPanel(MVCConstants.getResourceString("BufferSetup.text", "Buffer Setup"), PCIEConfiguration.createBufferSetup());
        this.addPanel(MVCConstants.getResourceString("PowerSettings.text", "Power Management"), PCIEConfiguration.createPowerManagement());
        avalonPanel = AvalonConfiguration.createAvalonConfigurationPanel();
        this.addPanel(MVCConstants.getResourceString("AvalonConfiguration.text", "Avalon Configuration"), avalonPanel);
        String rootPortendPointMode = ModuleGenerateHDL.ReadlstFile(new File(this.getCoreInstallationPath(true), "/ip_compiler_for_pci_express_wizard.lst"), "parameterization.p_pcie_enable_root_port_endpoint_mode");
        if (rootPortendPointMode != null && !rootPortendPointMode.trim().equalsIgnoreCase("0")) {
            my_module.setValue("p_pcie_enable_root_port_endpoint_mode", (Object)"1");
        } else {
            my_module.setValue("p_pcie_enable_root_port_endpoint_mode", (Object)"0");
        }
        String tlBypassMode = ModuleGenerateHDL.ReadlstFile(new File(this.getCoreInstallationPath(true), "/ip_compiler_for_pci_express_wizard.lst"), "parameterization.p_pcie_enable_tl_bypass_mode");
        if (tlBypassMode != null && !tlBypassMode.trim().equalsIgnoreCase("0")) {
            my_module.setValue("p_pcie_enable_tl_bypass_mode", (Object)"1");
        } else {
            my_module.setValue("p_pcie_enable_tl_bypass_mode", (Object)"0");
        }
        String enable_pcie_gen2_x8_es = ModuleGenerateHDL.ReadlstFile(new File(this.getCoreInstallationPath(true), "/ip_compiler_for_pci_express_wizard.lst"), "parameterization.enable_pcie_gen2_x8_es");
        if (enable_pcie_gen2_x8_es != null && !enable_pcie_gen2_x8_es.trim().equalsIgnoreCase("0")) {
            my_module.setValue("p_pcie_enable_pcie_gen2_x8_es", (Object)"1");
        } else {
            my_module.setValue("p_pcie_enable_pcie_gen2_x8_es", (Object)"0");
        }
        String enable_pcie_gen2_x8_s5gx_ = ModuleGenerateHDL.ReadlstFile(new File(this.getCoreInstallationPath(true), "/ip_compiler_for_pci_express_wizard.lst"), "parameterization.enable_pcie_gen2_x8_s5gx");
        if (enable_pcie_gen2_x8_s5gx_ != null && !enable_pcie_gen2_x8_s5gx_.trim().equalsIgnoreCase("0")) {
            my_module.setValue("p_pcie_enable_pcie_gen2_x8_s5gx", (Object)"1");
        } else {
            my_module.setValue("p_pcie_enable_pcie_gen2_x8_s5gx", (Object)"0");
        }
        this.addPanel(this.createAltGXBPanel());
        this.enableMegacoreSimulationPage(true);
        this.enableSummaryPage(true);
        this.setExternalAboutPage(new AlteraPCIEMWHtmlViewer());
        super.init(m_module);
    }

    private MWPanel createAltGXBPanel() {
        MWPanel systemPanel = new MWPanel();
        systemPanel.addNestedPanel(PCIEAlt2GXBPanel.createAlt2GXPanel());
        systemPanel.finish(5);
        hiddenpanel = systemPanel;
        return systemPanel;
    }

    public static MWPanel getAltGXBPanel() {
        return hiddenpanel;
    }

    public void setAllowedDeviceFamilies(Collection<IDeviceFamily> deviceFamilies) {
        super.setAllowedDeviceFamilies(deviceFamilies);
        PCIECompilerCoreParameters myParameter = (PCIECompilerCoreParameters)my_module.getExtension(ICoreParameter.class);
        if (myParameter != null) {
            myParameter.setAllowedDeviceFamilies(deviceFamilies);
        }
    }

    public static void main(String[] args) {
        boolean has_mwii_look_and_feel = false;
        boolean has_mwii_navigation_panel = true;
        UIDefaults defaults = UIManager.getDefaults();
        int fontSize = 11;
        String plainFontDescription = "Dialog-PLAIN-" + fontSize;
        Font plainFont = Font.decode(plainFontDescription);
        defaults.put("Table.font", plainFont);
        defaults.put("TableHeader.font", plainFont);
        defaults.put("Label.font", plainFont);
        defaults.put("List.font", plainFont);
        defaults.put("Menu.font", plainFont);
        defaults.put("MenuItem.font", plainFont);
        defaults.put("Button.font", plainFont);
        defaults.put("RadioButton.font", plainFont);
        defaults.put("TextArea.font", plainFont);
        defaults.put("TextField.font", plainFont);
        defaults.put("CheckBox.font", plainFont);
        defaults.put("ComboBox.font", plainFont);
        defaults.put("TabbedPane.font", plainFont);
        defaults.put("TitledBorder.font", plainFont);
        JFrame myframe = new JFrame("IP Compiler for PCI Express");
        AlteraPCIECompiler theModule = new AlteraPCIECompilerClass().newInstance();
        IMegaWizard megaWizard = (IMegaWizard)theModule.getExtension(IMegaWizard.class);
        PCIEMegaWizardGUI me = new PCIEMegaWizardGUI();
        if (megaWizard != null) {
            Image dummy_icon = Toolkit.getDefaultToolkit().getImage("dummy_path");
            myframe.setIconImage(dummy_icon);
            myframe.setResizable(false);
            myframe.setDefaultCloseOperation(3);
            myframe.setContentPane(megaWizard.getMegaWizardRoot((IMessageLogger)me, (IMegaWizardEventHandler)me));
        }
        megaWizard.setToolContext(IMegaWizard.EToolContext.STANDALONE);
        megaWizard.setDeviceFamily(DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.STRATIXIIGX));
        megaWizard.setAllowedDeviceFamilies((Collection)DeviceFamily.getDeviceFamilies());
        HashMap<String, String> userPrefrences = new HashMap<String, String>();
        userPrefrences.put("symbol", "1");
        megaWizard.setPreferences(((Object)userPrefrences).toString());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((d.getWidth() - (double)myframe.getWidth()) / 4.0);
        int y = (int)((d.getHeight() - (double)myframe.getHeight()) / 4.0);
        myframe.setLocation(x, y);
        myframe.pack();
        myframe.setVisible(true);
        myframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvt) {
                System.exit(0);
            }
        });
    }

    public void receiveMessage(IMessage message) {
    }

    public void processEvent(IMegaWizardEvent event) {
        if (event.getState().toString().equalsIgnoreCase(EMegaWizardState.Finished.toString())) {
            System.exit(0);
        } else if (event.getState().toString().equalsIgnoreCase(EMegaWizardState.Canceled.toString())) {
            System.exit(0);
        }
    }

    public void setToolContext(IMegaWizard.EToolContext toolContext) {
        PCIEConfiguration.customizeBARTAble(toolContext);
        if (toolContext.equals((Object)IMegaWizard.EToolContext.STANDALONE) && avalonPanel != null) {
            this.removePanel(MVCConstants.getResourceString("AvalonConfiguration.text", "Avalon Configuration"), AvalonConfiguration.createAvalonConfigurationPanel());
        }
        super.setToolContext(toolContext);
    }

    public static IModule getMyModule() {
        return my_module;
    }

    public static String getSavedPrefrences() {
        return userPrefrence;
    }

    public void setPreferences(String prefs) {
        userPrefrence = prefs;
        super.setPreferences(prefs);
    }

    protected String getCoreInstallationPath(boolean isLibPath) {
        String strMyLocation = null;
        try {
            strMyLocation = URLDecoder.decode(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        strMyLocation = strMyLocation.replace("file:", "");
        if (strMyLocation.indexOf(".jar") > 0) {
            File myLocation = new File(strMyLocation);
            if (!myLocation.exists()) {
                return null;
            }
            File fCoreLibIPToolBench = new File(myLocation.getParent());
            File fCoreLib = new File(fCoreLibIPToolBench.getParent());
            File fCore = new File(fCoreLib.getParent());
            if (isLibPath) {
                return fCoreLib.getPath();
            }
            return fCore.getParent();
        }
        String megacoreRoot = System.getenv("MEGACORE_ROOT");
        return new File(megacoreRoot, "ip_compiler_for_pci_express/lib").getAbsolutePath();
    }
}

