/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import altera.ipbu.pci_express.MVCConstants;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizard;
import com.altera.megacore.pcie.model.IPCIETableModel;
import com.altera.megacore.pcie.model.PCIEBARsTableModel;
import com.altera.megacore.pcie.ui.HeaderRenderer;
import com.altera.megacore.pcie.ui.MWButton;
import com.altera.megacore.pcie.ui.MWComboMappableDisplay;
import com.altera.megacore.pcie.ui.MWHexField;
import com.altera.megacore.pcie.ui.MWHexFormattedTextField;
import com.altera.megacore.pcie.ui.MWInfoPanel;
import com.altera.megacore.pcie.ui.MWLine;
import com.altera.megacore.pcie.ui.MWScrollPane;
import com.altera.megacore.pcie.ui.MWTable;
import com.altera.megacore.pcie.ui.MWTextMappableDisplay;
import com.altera.megacore.pcie.ui.PCIEMegaWizardGUI;
import com.altera.megacore.pcie.ui.PCIuiConstants;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.MWGUIBaseClass;
import com.altera.megawizard2.MWItem;
import com.altera.megawizard2.view.MWButtonGroup;
import com.altera.megawizard2.view.MWPanel;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.MaskFormatter;

public class PCIEConfiguration
extends MWGUIBaseClass {
    public static final int PANEL_MARGIN = 5;
    static final int LEFT_COLUMN = 343;
    static final int RIGHT_COLUMN = 343;
    private static TableColumn column = null;
    private static MWItem xcvr_ref_clk = null;
    private static MWPanel panelPCIBaseAddressRegisters = null;
    private static Integer[] columnWidth = new Integer[]{20, 213, 155};
    private static Integer[] columnWidthSOPC = new Integer[]{40, 193, 135, 125};
    public static boolean isUnderSopcBuilder = true;
    private static MWTable aTable = null;
    private static IPCIETableModel TableModel = null;
    private static Integer[] theColumnWidth = null;

    public static void update_xcvr_ref_clk(String label) {
        if (xcvr_ref_clk != null) {
            xcvr_ref_clk.setDisplayName(label);
        }
    }

    public static void update_PCIEBARHeading(boolean bRootPort) {
        if (panelPCIBaseAddressRegisters != null) {
            TitledBorder border = (TitledBorder)panelPCIBaseAddressRegisters.getJPanel().getBorder();
            if (bRootPort) {
                border.setTitle(MVCConstants.getResourceString("PCIE_BARS.Title").replaceAll("0", "1"));
            } else {
                border.setTitle(MVCConstants.getResourceString("PCIE_BARS.Title").replaceAll("1", "0"));
            }
        }
    }

    private PCIEConfiguration() {
    }

    public static void customizeBARTAble(IMegaWizard.EToolContext toolContext) {
        boolean iscurrentlyUnderSopcBuilder = isUnderSopcBuilder;
        isUnderSopcBuilder = !toolContext.equals((Object)IMegaWizard.EToolContext.STANDALONE);
        if (isUnderSopcBuilder && !iscurrentlyUnderSopcBuilder) {
            theColumnWidth = columnWidthSOPC;
            TableModel.SetStandaloneMode(false);
        } else if (!(isUnderSopcBuilder && iscurrentlyUnderSopcBuilder || !isUnderSopcBuilder && !iscurrentlyUnderSopcBuilder || isUnderSopcBuilder || !iscurrentlyUnderSopcBuilder)) {
            theColumnWidth = columnWidth;
            TableModel.SetStandaloneMode(true);
        }
        TableColumnModel cm = aTable.getColumnModel();
        for (int i = 0; i < theColumnWidth.length; ++i) {
            column = aTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(theColumnWidth[i]);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            if (i == 0) {
                renderer.setBackground(UIManager.getColor("TableHeader.background"));
                renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                renderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
            renderer.setHorizontalAlignment(0);
            column.setCellRenderer(renderer);
        }
    }

    static MWPanel createPCIESystemSettingsPanel() {
        MWPanel panelMain = new MWPanel();
        MWPanel panelPCIEPhy = PCIEConfiguration.createPCIEPhyPanel();
        MWPanel panelPCIECoreType = PCIEConfiguration.createPCIDeviceModePanel();
        panelMain.addNestedPanel(panelPCIECoreType);
        panelMain.addNestedPanel(panelPCIEPhy);
        panelMain.finish(5);
        return panelMain;
    }

    private static MWPanel createPCIDeviceModePanel() {
        MWPanel panel = new MWPanel(MVCConstants.getResourceString("PCIE_CORE_TYPE.Title"));
        panel.beginColumnsBlock();
        panel.addSpacer(1, 8);
        MWButtonGroup btnGrpPCIECoreType = new MWButtonGroup("p_pcie_enable_hip");
        MWItem item = panel.addRadioButton(MVCConstants.getResourceString("PCIE_CORE_TYPE.HIP"), "1", btnGrpPCIECoreType);
        item.getJControl().setName("pcie_enable_hip");
        item = panel.addRadioButton(MVCConstants.getResourceString("PCIE_CORE_TYPE.SIP"), "0", btnGrpPCIECoreType);
        item.getJControl().setName("pcie_enable_sip");
        panel.addSpacer(343, 10);
        panel.nextColumn();
        MWInfoPanel infoPanel = new MWInfoPanel(btnGrpPCIECoreType, true);
        infoPanel.addInfo("1", MVCConstants.getResourceString("PCIE_CORE_TYPE.HIP"), MVCConstants.getResourceString("PCIE_CORE_TYPE.HIPINFO"));
        infoPanel.addInfo("0", MVCConstants.getResourceString("PCIE_CORE_TYPE.SIP"), MVCConstants.getResourceString("PCIE_CORE_TYPE.SIPINFO"));
        infoPanel.getTextControl().getJComponent().setMinimumSize(new Dimension(323, 50));
        infoPanel.getTextControl().getJComponent().setMaximumSize(new Dimension(323, 50));
        infoPanel.finish(5);
        panel.add((MWControl)infoPanel);
        panel.addSpacer(343, 10);
        panel.endBlock();
        panel.finish(5);
        return panel;
    }

    static MWPanel createPCIEBaseAddressRegistersPanel() {
        panelPCIBaseAddressRegisters = new MWPanel(MVCConstants.getResourceString("PCIE_BARS.Title"));
        theColumnWidth = columnWidthSOPC;
        TableModel = new PCIEBARsTableModel();
        aTable = new MWTable((TableModel)TableModel, "uiPCIBarTable");
        TableColumnModel cm = aTable.getColumnModel();
        for (int i = 0; i < theColumnWidth.length; ++i) {
            column = aTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(theColumnWidth[i]);
            DefaultTableCellRenderer renderer = null;
            if (i == 0) {
                renderer = new HeaderRenderer();
                renderer.setBackground(UIManager.getColor("TableHeader.background"));
                renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                renderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            } else {
                renderer = new DefaultTableCellRenderer();
            }
            renderer.setHorizontalAlignment(0);
            column.setCellRenderer(renderer);
        }
        int tableWidth = 690;
        int tableHeight = aTable.getRowHeight() * aTable.getRowCount() + PCIEConfiguration.aTable.getTableHeader().getMaximumSize().height + 3;
        MWScrollPane scrollPane = new MWScrollPane(aTable, "uiPCIBarTable");
        panelPCIBaseAddressRegisters.add((MWControl)scrollPane).setSizeRange(tableWidth, tableHeight, tableWidth, tableHeight);
        panelPCIBaseAddressRegisters.finish(5);
        return panelPCIBaseAddressRegisters;
    }

    static MWPanel createPCIEPhyPanel() {
        MWPanel myPanel11 = new MWPanel(MVCConstants.getResourceString("PCIE_PHY_SELECTION.Title"));
        MWItem item = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_PHY_Selection"), "p_pcie_phy");
        item.getJControl().setName("p_pcie_phy");
        myPanel11.addSpacer(2, 10);
        item = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_Number_of_Lanes"), "p_pcie_number_of_lanes");
        item.getJControl().setName("p_pcie_number_of_lanes");
        myPanel11.addSpacer(2, 10);
        item = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_Port_Type"), "p_pcie_port_type");
        item.getJControl().setName("p_pcie_port_type");
        myPanel11.addSpacer(2, 10);
        item = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_Max_Rate"), "p_pcie_rate");
        item.getJControl().setName("p_pcie_rate");
        myPanel11.addSpacer(2, 10);
        myPanel11.nextColumn();
        myPanel11.addSpacer(10, 1);
        myPanel11.nextColumn();
        myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_PHY_Interface"), "p_pcie_phy_interface");
        myPanel11.addSpacer(2, 10);
        xcvr_ref_clk = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"), "p_pcie_txrx_clock");
        myPanel11.addSpacer(2, 10);
        item = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_Express_Version"), "p_pcie_version");
        item.getJControl().setName("p_pcie_version");
        myPanel11.addSpacer(2, 10);
        myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_Test_Out_Width"), "p_pcie_test_out_width");
        myPanel11.addSpacer(2, 10);
        myPanel11.nextColumn();
        myPanel11.addSpacer(10, 1);
        myPanel11.nextColumn();
        MWButton transcieverBtn = new MWButton(PCIEMegaWizardGUI.getMyModule(), "p_pcie_alt2gxb", true);
        transcieverBtn.setName("gxb_button");
        transcieverBtn.setActionListener(transcieverBtn);
        transcieverBtn.setMaximumSize(new Dimension(transcieverBtn.getMaximumSize().width + 15, transcieverBtn.getMaximumSize().height));
        myPanel11.add((MWControl)transcieverBtn);
        myPanel11.addSpacer(2, 10);
        item = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_Application_Interface"), "p_pcie_app_signal_interface");
        item.getJControl().setName("p_pcie_app_signal_interface");
        myPanel11.addSpacer(2, 10);
        MWItem mwItm2 = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_Internal_Clock"), "p_pcie_internal_clock");
        myPanel11.addSpacer(2, 10);
        mwItm2 = myPanel11.addComboBox(MVCConstants.getResourceString("PCIE_DPRIO"), "p_enable_pcie_hip_dprio");
        mwItm2.getJControl().setName("p_enable_pcie_hip_dprio");
        myPanel11.addSpacer(2, 10);
        myPanel11.finish(5);
        return myPanel11;
    }

    static MWPanel createPCIRegistersPanel() {
        MWPanel panelMain = new MWPanel();
        MWPanel panelPCIEBaseAddressRegisters = PCIEConfiguration.createPCIEBaseAddressRegistersPanel();
        panelMain.addNestedPanel(panelPCIEBaseAddressRegisters);
        MWPanel panelPCIEPhy = PCIEConfiguration.createPCIReadOnlyRegistersPanel();
        panelMain.addNestedPanel(panelPCIEPhy);
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createPCIECapabilities() {
        MWPanel panelMain = new MWPanel();
        MWPanel panelPCIELinkCapabilities = PCIEConfiguration.createPCIELinkCapabilities();
        MWPanel panelPCIEDeviceCapabilities = PCIEConfiguration.createPCIEDeviceCapabilities();
        MWPanel panelPCIEMSICapabilities = PCIEConfiguration.createPCIEMSICapabilities();
        MWPanel panelPCIEMSIxCapabilities = PCIEConfiguration.createPCIEMSIxCapabilities();
        MWPanel panelPCIEErrorReporting = PCIEConfiguration.createPCIEErrorReporting();
        MWPanel panelPCIESlotCapabilities = PCIEConfiguration.createSlotCapabilities();
        panelMain.beginColumnsBlock();
        panelMain.addNestedPanel(panelPCIEDeviceCapabilities);
        panelMain.addNestedPanel(panelPCIEErrorReporting);
        panelMain.nextColumn();
        panelMain.addNestedPanel(panelPCIEMSICapabilities);
        panelMain.addNestedPanel(panelPCIELinkCapabilities);
        panelMain.addNestedPanel(panelPCIESlotCapabilities);
        panelMain.nextColumn();
        panelMain.addNestedPanel(panelPCIEMSIxCapabilities);
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createPCIReadOnlyRegistersPanel() {
        MWPanel panelPCIERORegisters = new MWPanel(MVCConstants.getResourceString("PCI_Read_Only_Registers.Title"));
        MWPanel panelPCIReadOnlyRegisters = new MWPanel();
        MWHexField devId = new MWHexField(PCIEConfiguration.createFormatter("0xHHHH"), "p_pcie_device_id");
        panelPCIReadOnlyRegisters.add((MWControl)devId, MVCConstants.getResourceString("PCI_Read_Only_Register_1"));
        panelPCIReadOnlyRegisters.addSpacer(2, 8);
        MWHexField vendorId = new MWHexField(PCIEConfiguration.createFormatter("0xHHHH"), "p_pcie_vendor_id");
        panelPCIReadOnlyRegisters.add((MWControl)vendorId, MVCConstants.getResourceString("PCI_Read_Only_Register_4"));
        panelPCIReadOnlyRegisters.nextColumn();
        panelPCIReadOnlyRegisters.addSpacer(15, 1);
        panelPCIReadOnlyRegisters.nextColumn();
        MWHexField subsystem = new MWHexField(PCIEConfiguration.createFormatter("0xHHHH"), "p_pcie_subsystem_device_id");
        MWItem item = panelPCIReadOnlyRegisters.add((MWControl)subsystem, MVCConstants.getResourceString("PCI_Read_Only_Register_3"));
        item.getJControl().setName("p_pcie_subsystem_device_id");
        panelPCIReadOnlyRegisters.addSpacer(2, 8);
        MWHexField subsystemvendorId = new MWHexField(PCIEConfiguration.createFormatter("0xHHHH"), "p_pcie_subsystem_vendor_id");
        item = panelPCIReadOnlyRegisters.add((MWControl)subsystemvendorId, MVCConstants.getResourceString("PCI_Read_Only_Register_6"));
        item.getJControl().setName("p_pcie_subsystem_vendor_id");
        panelPCIReadOnlyRegisters.nextColumn();
        panelPCIReadOnlyRegisters.addSpacer(15, 1);
        panelPCIReadOnlyRegisters.nextColumn();
        MWHexField revId = new MWHexField(PCIEConfiguration.createFormatter("0xHHHH"), "p_pcie_revision_id");
        panelPCIReadOnlyRegisters.add((MWControl)revId, MVCConstants.getResourceString("PCI_Read_Only_Register_5"));
        panelPCIReadOnlyRegisters.addSpacer(2, 8);
        MWHexFormattedTextField clscode = new MWHexFormattedTextField("p_pcie_class_code", 6);
        panelPCIReadOnlyRegisters.add((MWControl)clscode, MVCConstants.getResourceString("PCI_Read_Only_Register_2"));
        panelPCIReadOnlyRegisters.finish(4);
        panelPCIERORegisters.addNestedPanel(panelPCIReadOnlyRegisters);
        panelPCIERORegisters.addNestedPanel(PCIEConfiguration.createRPBaseAndLimitregistersPanel());
        panelPCIERORegisters.finish(5);
        return panelPCIERORegisters;
    }

    static MWPanel createRPBaseAndLimitregistersPanel() {
        MWPanel panelRPBaseAndLimitregister = new MWPanel("Base and Limit Registers");
        panelRPBaseAndLimitregister.nextColumn();
        panelRPBaseAndLimitregister.addSpacer(25, 1);
        panelRPBaseAndLimitregister.nextColumn();
        MWItem item = panelRPBaseAndLimitregister.addComboBox(MVCConstants.getResourceString("PCIE_RP_IO_Base_and_Limit"), "p_pcie_io_base_and_limit_register");
        item.getJControl().setName("p_pcie_io_base_and_limit_register");
        panelRPBaseAndLimitregister.nextColumn();
        panelRPBaseAndLimitregister.addSpacer(55, 1);
        panelRPBaseAndLimitregister.nextColumn();
        item = panelRPBaseAndLimitregister.addComboBox(MVCConstants.getResourceString("PCIE_RP_Mem_Base_and_Limit"), "p_pcie_mem_base_and_limit_register");
        item.getJControl().setName("p_pcie_mem_base_and_limit_register");
        panelRPBaseAndLimitregister.nextColumn();
        panelRPBaseAndLimitregister.addSpacer(25, 1);
        panelRPBaseAndLimitregister.nextColumn();
        panelRPBaseAndLimitregister.finish(5);
        return panelRPBaseAndLimitregister;
    }

    static MWPanel createPCIELinkCapabilities() {
        MWPanel panelGeneralCapabilities = new MWPanel(MVCConstants.getResourceString("PCIE_Link_Capabilities.Title"));
        panelGeneralCapabilities.beginRowsBlock();
        panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_Common_Clock"), "p_pcie_link_common_clock");
        panelGeneralCapabilities.endBlock();
        panelGeneralCapabilities.addSpacer(2, 4);
        panelGeneralCapabilities.beginRowsBlock();
        MWItem item = panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_DLL_Reproting"), "p_pcie_dll_active_report_support");
        item.getJControl().setName("p_pcie_dll_active_report_support");
        panelGeneralCapabilities.endBlock();
        panelGeneralCapabilities.addSpacer(2, 4);
        panelGeneralCapabilities.beginRowsBlock();
        item = panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_Surperise_Down_Reproting"), "p_pcie_surprise_down_error_support");
        item.getJControl().setName("p_pcie_surprise_down_error_support");
        panelGeneralCapabilities.endBlock();
        panelGeneralCapabilities.addSpacer(2, 4);
        MWHexField linkPort = new MWHexField(PCIEConfiguration.createFormatter("0xHH"), "p_pcie_link_port_number");
        panelGeneralCapabilities.add((MWControl)linkPort, MVCConstants.getResourceString("PCIE_Link_Port_Number"));
        panelGeneralCapabilities.addSpacer(2, 0);
        panelGeneralCapabilities.finish(5);
        return panelGeneralCapabilities;
    }

    static MWPanel createSlotCapabilities() {
        MWPanel panelSlotCapabilities = new MWPanel(MVCConstants.getResourceString("PCIE_Slot_Capabilities.Title"));
        MWItem item = panelSlotCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_Enable_Slot"), "p_pcie_enable_slot_capability");
        item.getJControl().setName("p_pcie_enable_slot_capability");
        panelSlotCapabilities.beginRowsBlock();
        panelSlotCapabilities.addSpacer(20, 0);
        MWHexField slotRegister = new MWHexField(PCIEConfiguration.createFormatter("0xHHHHHHHH"), "p_pcie_slot_capabilities");
        item = panelSlotCapabilities.add((MWControl)slotRegister, MVCConstants.getResourceString("PCIE_Slot_Registers"));
        item.getJControl().setName("p_pcie_slot_capabilities");
        panelSlotCapabilities.endBlock();
        panelSlotCapabilities.addSpacer(2, 0);
        panelSlotCapabilities.finish(5);
        return panelSlotCapabilities;
    }

    static MWPanel createPCIEErrorReporting() {
        MWPanel panelGeneralCapabilities = new MWPanel(MVCConstants.getResourceString("PCIE_Error_Reporting.Title"));
        panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_Error_Reporting"), "p_pcie_advanced_error_reporting");
        panelGeneralCapabilities.addSpacer(1, 10);
        panelGeneralCapabilities.beginRowsBlock();
        panelGeneralCapabilities.addSpacer(20, 0);
        panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_ECRC_Check"), "p_pcie_ecrc_check");
        panelGeneralCapabilities.endBlock();
        panelGeneralCapabilities.addSpacer(1, 10);
        panelGeneralCapabilities.beginRowsBlock();
        panelGeneralCapabilities.addSpacer(20, 0);
        panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_ECRC_Generation"), "p_pcie_ecrc_generation");
        panelGeneralCapabilities.endBlock();
        panelGeneralCapabilities.addSpacer(1, 10);
        panelGeneralCapabilities.beginRowsBlock();
        panelGeneralCapabilities.addSpacer(20, 0);
        panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_ECRC_Forwarding"), "p_pcie_use_crc_forwarding");
        panelGeneralCapabilities.endBlock();
        panelGeneralCapabilities.addSpacer(1, 2);
        panelGeneralCapabilities.beginRowsBlock();
        MWItem item = panelGeneralCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_Parity"), "p_pcie_use_parity");
        panelGeneralCapabilities.endBlock();
        panelGeneralCapabilities.finish(5);
        return panelGeneralCapabilities;
    }

    static MWPanel createPCIEDeviceCapabilities() {
        MWPanel panelDeviceCapabilities = new MWPanel(MVCConstants.getResourceString("PCIE_Device_Capabilities.Title"));
        panelDeviceCapabilities.addComboBox(MVCConstants.getResourceString("PCIE_Tags_Supported"), "p_pcie_tag_supported");
        panelDeviceCapabilities.addSpacer(0, 1);
        panelDeviceCapabilities.beginRowsBlock();
        panelDeviceCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_Completion_Timeout"), "p_pcie_enable_completion_timeout_disable");
        panelDeviceCapabilities.endBlock();
        panelDeviceCapabilities.addSpacer(2, 5);
        panelDeviceCapabilities.beginRowsBlock();
        panelDeviceCapabilities.addSpacer(20, 0);
        panelDeviceCapabilities.addComboBox(MVCConstants.getResourceString("PCIE_Completion_Timeout_Range"), "p_pcie_completion_timeout");
        panelDeviceCapabilities.endBlock();
        panelDeviceCapabilities.addSpacer(2, 10);
        panelDeviceCapabilities.finish(5);
        return panelDeviceCapabilities;
    }

    static MWPanel createPCIEMSICapabilities() {
        MWPanel panelMSICapabilities = new MWPanel(MVCConstants.getResourceString("PCIE_MSI_Capabilities.Title"));
        panelMSICapabilities.addComboBox(MVCConstants.getResourceString("PCIE_MSI_Message_Requested"), "p_pcie_msi_message_requested");
        panelMSICapabilities.addSpacer(0, 1);
        panelMSICapabilities.beginRowsBlock();
        panelMSICapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_MSI_Message_64bits"), "p_pcie_msi_message_64bits_address_capable");
        panelMSICapabilities.endBlock();
        panelMSICapabilities.finish(5);
        return panelMSICapabilities;
    }

    static MWPanel createPCIEMSIxCapabilities() {
        MWPanel panelMSIxCapabilities = new MWPanel(MVCConstants.getResourceString("PCIE_MSIX_Capabilities.Title"));
        MWItem item = panelMSIxCapabilities.addCheckBox(MVCConstants.getResourceString("PCIE_Implement_MSIX"), "p_pcie_enable_function_msix_support");
        item.getJControl().setName("p_pcie_enable_function_msix_support");
        panelMSIxCapabilities.addSpacer(2, 8);
        MWPanel panelMSIxTable = new MWPanel(MVCConstants.getResourceString("PCIE_MSIX_Table.Title"));
        MWHexFormattedTextField tablesize = new MWHexFormattedTextField("p_pcie_msix_table_size", 3);
        panelMSIxTable.add((MWControl)tablesize, MVCConstants.getResourceString("PCIE_MSIX_Table_Size"));
        panelMSIxTable.addSpacer(2, 11);
        MWHexFormattedTextField tableoffset = new MWHexFormattedTextField("p_pcie_msix_table_offset", 8);
        panelMSIxTable.add((MWControl)tableoffset, MVCConstants.getResourceString("PCIE_MSIX_Table_Offset"));
        panelMSIxTable.addSpacer(2, 11);
        panelMSIxTable.addComboBox(MVCConstants.getResourceString("PCIE_MSIX_Table_BAR_Indicator"), "ui_pcie_msix_table_bir");
        panelMSIxTable.addSpacer(2, 11);
        panelMSIxTable.finish(5);
        MWPanel panelPBA = new MWPanel(MVCConstants.getResourceString("PCIE_MSIX_PBA.Title"));
        MWHexFormattedTextField PBAoffset = new MWHexFormattedTextField("p_pcie_msix_pba_offset", 8);
        panelPBA.add((MWControl)PBAoffset, MVCConstants.getResourceString("PCIE_MSIX_PBA_Offset"));
        panelPBA.addSpacer(2, 11);
        panelPBA.addComboBox(MVCConstants.getResourceString("PCIE_MSIX_PBA_BAR_Indicator"), "ui_pcie_msix_pba_bir");
        panelPBA.addSpacer(2, 11);
        panelPBA.finish(5);
        panelMSIxCapabilities.addNestedPanel(panelMSIxTable);
        panelMSIxCapabilities.addNestedPanel(panelPBA);
        panelPBA.addSpacer(1, 1);
        panelMSIxCapabilities.finish(5);
        return panelMSIxCapabilities;
    }

    static MWPanel createBufferSetup() {
        MWPanel panelMain = new MWPanel();
        MWPanel panelPCIEPayLoad = PCIEConfiguration.createPCIEPayLoadPanel();
        MWPanel panelPCIEVCArbit = PCIEConfiguration.createVCArbitPanel();
        MWPanel panelPCIERetryBufferOptions = PCIEConfiguration.createRetryBufferOptionsPanel();
        MWPanel panelPCIERxBufSpaceAllocation = PCIEConfiguration.createRxBufSpaceAllocation();
        panelMain.addNestedPanel(panelPCIEPayLoad);
        panelMain.addNestedPanel(panelPCIEVCArbit);
        panelMain.addNestedPanel(panelPCIERetryBufferOptions);
        panelMain.nextColumn();
        panelMain.addNestedPanel(panelPCIERxBufSpaceAllocation);
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createPCIEPayLoadPanel() {
        MWPanel panelPCIEPayLoad = new MWPanel();
        panelPCIEPayLoad.addSpacer(2, 10);
        MWItem itm = panelPCIEPayLoad.addComboBox(MVCConstants.getResourceString("PCIE_Maximum_Payload_Size"), "p_pcie_max_payload_size");
        itm.getJControl().setName("p_pcie_max_payload_size");
        panelPCIEPayLoad.addSpacer(2, 10);
        MWComboMappableDisplay numVCCombo = new MWComboMappableDisplay("p_pcie_virutal_channels", null);
        itm = panelPCIEPayLoad.add((MWControl)numVCCombo);
        itm.setDisplayName(MVCConstants.getResourceString("PCIE_Number_Virtual_Channels"));
        itm.getJControl().setName("p_pcie_virutal_channels");
        panelPCIEPayLoad.addSpacer(2, 10);
        panelPCIEPayLoad.finish(5);
        return panelPCIEPayLoad;
    }

    static MWPanel createVCArbitPanel() {
        MWPanel panelVCArbit = new MWPanel(MVCConstants.getResourceString("PCIE_Virtual_Channel_Arbitration.Title"));
        panelVCArbit.addSpacer(2, 10);
        MWComboMappableDisplay lowpriorityVCCombo = new MWComboMappableDisplay("p_pcie_low_priority_virtual_channels", PCIuiConstants.maplowpriorityVDisplayString);
        panelVCArbit.beginRowsBlock();
        MWItem itm = panelVCArbit.add((MWControl)lowpriorityVCCombo);
        itm.setDisplayName(MVCConstants.getResourceString("PCIE_Low_Priority_Virtual_Channels"));
        panelVCArbit.endBlock();
        panelVCArbit.addSpacer(2, 10);
        panelVCArbit.finish(5);
        return panelVCArbit;
    }

    static MWPanel createRetryBufferOptionsPanel() {
        MWPanel panelRetryBufferOptions = new MWPanel(MVCConstants.getResourceString("PCIE_Retry_Buffer_Options.Title"));
        panelRetryBufferOptions.addSpacer(2, 10);
        panelRetryBufferOptions.beginRowsBlock();
        panelRetryBufferOptions.addCheckBox(MVCConstants.getResourceString("PCIE_Auto_Configure_Retry_Buffer_Options"), "p_pcie_auto_configure_retry_buffer");
        panelRetryBufferOptions.endBlock();
        panelRetryBufferOptions.addSpacer(2, 10);
        MWItem itm = panelRetryBufferOptions.addComboBox(MVCConstants.getResourceString("PCIE_Retry_Buffer_Size"), "p_pcie_retry_buffer_size");
        itm.getJControl().setName("p_pcie_retry_buffer_size");
        panelRetryBufferOptions.addSpacer(2, 10);
        MWComboMappableDisplay retryFIFODepthCombo = new MWComboMappableDisplay("p_pcie_retry_fifo_depth", null);
        itm = panelRetryBufferOptions.add((MWControl)retryFIFODepthCombo);
        itm.setDisplayName(MVCConstants.getResourceString("PCIE_Retry_FIFO_Depth"));
        panelRetryBufferOptions.addSpacer(2, 10);
        panelRetryBufferOptions.finish(5);
        return panelRetryBufferOptions;
    }

    static MWPanel createRxBufSpaceAllocation() {
        MWPanel panelRxBufSpaceAllocations = new MWPanel(MVCConstants.getResourceString("PCIE_Rx_Buffer_Space_Allocation.Title"));
        MWPanel panelPerformanceId = new MWPanel();
        panelPerformanceId.addComboBox(MVCConstants.getResourceString("PCIE_Target_Performance"), "p_pcie_target_performance_preset");
        panelPerformanceId.addSpacer(2, 10);
        panelPerformanceId.addComboBox(MVCConstants.getResourceString("PCIE_Initiator_Performance"), "p_pcie_initiator_performance_preset");
        panelPerformanceId.addSpacer(2, 10);
        panelPerformanceId.nextColumn();
        panelPerformanceId.addSpacer(60, 1);
        panelPerformanceId.finish();
        panelRxBufSpaceAllocations.addNestedPanel(panelPerformanceId);
        panelRxBufSpaceAllocations.beginRowsBlock();
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Posted_Header_Credit"));
        panelRxBufSpaceAllocations.addSpacer(12, 1);
        MWTextMappableDisplay postedHeaderCredit0 = new MWTextMappableDisplay("p_pcie_posted_header_credit_vc0", null);
        panelRxBufSpaceAllocations.add((MWControl)postedHeaderCredit0);
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Used_Space"));
        MWTextMappableDisplay postedHeaderUsedSpace0 = new MWTextMappableDisplay("p_pcie_posted_header_used_space_vc0", null, "Bytes", true);
        panelRxBufSpaceAllocations.add((MWControl)postedHeaderUsedSpace0);
        panelRxBufSpaceAllocations.endBlock();
        panelRxBufSpaceAllocations.addSpacer(2, 10);
        panelRxBufSpaceAllocations.beginRowsBlock();
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Posted_Data_Credit"));
        panelRxBufSpaceAllocations.addSpacer(18, 1);
        MWTextMappableDisplay postedDataCredit0 = new MWTextMappableDisplay("p_pcie_posted_data_credit_vc0", null);
        panelRxBufSpaceAllocations.add((MWControl)postedDataCredit0);
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Used_Space"));
        MWTextMappableDisplay postedDataUsedSpace0 = new MWTextMappableDisplay("p_pcie_posted_data_used_space_vc0", null, "Bytes", true);
        panelRxBufSpaceAllocations.add((MWControl)postedDataUsedSpace0);
        panelRxBufSpaceAllocations.endBlock();
        panelRxBufSpaceAllocations.addSpacer(2, 10);
        panelRxBufSpaceAllocations.beginRowsBlock();
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Non_Posted_Header_Credit"));
        MWTextMappableDisplay postedNonHeaderCredit0 = new MWTextMappableDisplay("p_pcie_nonposted_header_credit_vc0", null);
        panelRxBufSpaceAllocations.add((MWControl)postedNonHeaderCredit0);
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Used_Space"));
        MWTextMappableDisplay postedNonHeaderUsedSpace0 = new MWTextMappableDisplay("p_pcie_nonposted_header_used_space_vc0", null, "Bytes", true);
        panelRxBufSpaceAllocations.add((MWControl)postedNonHeaderUsedSpace0);
        panelRxBufSpaceAllocations.endBlock();
        panelRxBufSpaceAllocations.addSpacer(2, 10);
        panelRxBufSpaceAllocations.beginRowsBlock();
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Completion_Header_Credit"));
        panelRxBufSpaceAllocations.addSpacer(1, 1);
        MWTextMappableDisplay postedCompletionHeaderCredit0 = new MWTextMappableDisplay("p_pcie_completion_header_credit_vc0", null);
        panelRxBufSpaceAllocations.add((MWControl)postedCompletionHeaderCredit0);
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Used_Space"));
        MWTextMappableDisplay postedCompletionHeaderUsedSpace0 = new MWTextMappableDisplay("p_pcie_completion_header_used_space_vc0", null, "Bytes", true);
        panelRxBufSpaceAllocations.add((MWControl)postedCompletionHeaderUsedSpace0);
        panelRxBufSpaceAllocations.endBlock();
        panelRxBufSpaceAllocations.addSpacer(2, 10);
        panelRxBufSpaceAllocations.beginRowsBlock();
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Completion_Data_Credit"));
        panelRxBufSpaceAllocations.addSpacer(6, 1);
        MWTextMappableDisplay postedCompletionDataCredit0 = new MWTextMappableDisplay("p_pcie_completion_data_credit_vc0", null);
        panelRxBufSpaceAllocations.add((MWControl)postedCompletionDataCredit0);
        panelRxBufSpaceAllocations.addText(MVCConstants.getResourceString("PCIE_Used_Space"));
        MWTextMappableDisplay postedCompletionDataUsedSpace0 = new MWTextMappableDisplay("p_pcie_completion_data_used_space_vc0", null, "Bytes", true);
        panelRxBufSpaceAllocations.add((MWControl)postedCompletionDataUsedSpace0);
        panelRxBufSpaceAllocations.endBlock();
        panelRxBufSpaceAllocations.addSpacer(2, 10);
        MWLine line = new MWLine();
        panelRxBufSpaceAllocations.add((MWControl)line);
        panelRxBufSpaceAllocations.addSpacer(2, 10);
        panelRxBufSpaceAllocations.beginRowsBlock();
        panelRxBufSpaceAllocations.addSpacer(10, 1);
        MWTextMappableDisplay TotalHeaderCredit = new MWTextMappableDisplay("p_pcie_total_header_credit_vc0", null, MVCConstants.getResourceString("PCIE_Total_Header_Credits"), false);
        panelRxBufSpaceAllocations.add((MWControl)TotalHeaderCredit);
        MWTextMappableDisplay TotalRxSpace = new MWTextMappableDisplay("p_pcie_rx_buffer_size_vc0", PCIuiConstants.mapBytesToKBytes, MVCConstants.getResourceString("PCIE_Total_Rx_Buffer_Space"), false);
        panelRxBufSpaceAllocations.add((MWControl)TotalRxSpace);
        panelRxBufSpaceAllocations.endBlock();
        panelRxBufSpaceAllocations.addSpacer(2, 10);
        panelRxBufSpaceAllocations.finish(5);
        return panelRxBufSpaceAllocations;
    }

    static MWPanel createPowerManagement() {
        MWPanel panelMain = new MWPanel();
        MWPanel panelPCIEL0ASPM = PCIEConfiguration.createL0ASPMPanel();
        MWPanel panelPCIEL1ASPM = PCIEConfiguration.createL1ASPMPanel();
        panelMain.addNestedPanel(panelPCIEL0ASPM);
        panelMain.nextColumn();
        panelMain.addNestedPanel(panelPCIEL1ASPM);
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createL0ASPMPanel() {
        MWPanel panelMain = new MWPanel(MVCConstants.getResourceString("PCIE_L0_ASPM.Title"));
        panelMain.addNestedPanel(PCIEConfiguration.createTopL0ASPMPanel());
        panelMain.addNestedPanel(PCIEConfiguration.createBottomL0ASPMPanel());
        panelMain.addNestedPanel(PCIEConfiguration.createEIEPanel());
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createTopL0ASPMPanel() {
        MWPanel panelMain = new MWPanel();
        panelMain.beginRowsBlock();
        panelMain.addCheckBox(MVCConstants.getResourceString("PCIE_DISABLE_L0s"), "p_pcie_disable_L0s");
        panelMain.endBlock();
        panelMain.addSpacer(2, 10);
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_Idle_Threshold_For_L0"), "p_pcie_threshold_for_L0s_entry");
        panelMain.addSpacer(2, 10);
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_Endpoint_L0_Acceptable_Latency"), "p_pcie_endpoint_L0s_acceptable_latency");
        panelMain.addSpacer(2, 10);
        panelMain.nextColumn();
        panelMain.addSpacer(30, 1);
        panelMain.finish();
        return panelMain;
    }

    static MWPanel createBottomL0ASPMPanel() {
        MWPanel panelMain = new MWPanel(MVCConstants.getResourceString("PCIE_N_FTS.Title"));
        panelMain.addSpacer(7, 1);
        panelMain.nextColumn();
        panelMain.addText(MVCConstants.getResourceString("PCIE_Max_Rate") + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "Gen1 (2.5 Gbps)");
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_NFTS_Common_Clock"), "p_pcie_nfts_common_clock");
        panelMain.addSpacer(2, 10);
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_NFTS_Separate_Clock"), "p_pcie_nfts_separate_clock");
        panelMain.addSpacer(2, 10);
        panelMain.nextColumn();
        panelMain.addText("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Gen2 (5.0 Gbps)");
        panelMain.addComboBox("&nbsp;&nbsp;&nbsp;&nbsp;", "p_pcie_gen2_nfts_same_clock");
        panelMain.addSpacer(2, 10);
        panelMain.addComboBox("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", "p_pcie_gen2_nfts_diff_clock");
        panelMain.addSpacer(2, 10);
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createEIEPanel() {
        MWPanel panelMain = new MWPanel();
        panelMain.addSpacer(70, 1);
        panelMain.nextColumn();
        panelMain.nextColumn();
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_EIE_FTS"), "p_pcie_eie_b4_nfts_count");
        panelMain.addSpacer(2, 10);
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createL1ASPMPanel() {
        MWPanel panelMain = new MWPanel(MVCConstants.getResourceString("PCIE_L1_ASPM.Title"));
        panelMain.addNestedPanel(PCIEConfiguration.createTopL1ASPMPanel());
        panelMain.addNestedPanel(PCIEConfiguration.createBottomL1ASPMPanel());
        panelMain.addSpacer(1, 70);
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createTopL1ASPMPanel() {
        MWPanel panelMain = new MWPanel();
        panelMain.beginRowsBlock();
        panelMain.addCheckBox(MVCConstants.getResourceString("PCIE_Enable_L1_ASPM"), "p_pcie_enable_L1_aspm");
        panelMain.endBlock();
        panelMain.addSpacer(2, 10);
        panelMain.beginRowsBlock();
        panelMain.addSpacer(10, 1);
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_Endpoint_L1_Acceptable_Latency"), "p_pcie_endpoint_L1_acceptable_latency");
        panelMain.endBlock();
        panelMain.addSpacer(2, 10);
        MWItem item = panelMain.addComboBox(MVCConstants.getResourceString("PCIE_Enable_L1_ASPM"), "");
        item.getJControl().setVisible(false);
        panelMain.addSpacer(2, 10);
        panelMain.nextColumn();
        panelMain.addSpacer(30, 1);
        panelMain.finish();
        return panelMain;
    }

    static MWPanel createBottomL1ASPMPanel() {
        MWPanel panelMain = new MWPanel(MVCConstants.getResourceString("PCIE_L1_Exit_Latency.Title"));
        panelMain.addSpacer(75, 1);
        panelMain.nextColumn();
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_L1_Common_Clock"), "p_pcie_L1_exit_latency_common_clock");
        panelMain.addSpacer(2, 10);
        panelMain.addComboBox(MVCConstants.getResourceString("PCIE_L1_Separate_Clock"), "p_pcie_L1_exit_latency_separate_clock");
        panelMain.addSpacer(2, 10);
        panelMain.nextColumn();
        panelMain.addSpacer(20, 1);
        panelMain.finish(5);
        return panelMain;
    }

    public static void main(String[] args) {
        JFrame myframe = new JFrame("MegaWizard2");
        MWPanel panel = PCIEConfiguration.createPCIESystemSettingsPanel();
        myframe.setContentPane(panel.getJPanel());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((d.getWidth() - (double)myframe.getWidth()) / 4.0);
        int y = (int)((d.getHeight() - (double)myframe.getHeight()) / 4.0);
        myframe.setLocation(x, y);
        myframe.pack();
        myframe.setVisible(true);
        myframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvt) {
                System.exit(0);
            }
        });
    }

    private static MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }
}

